// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"
typedef struct empty {} empty;
struct __attribute__((packed)) aBFu15i_BFu15i_Sf { unsigned int v1:15; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu15ll_Sf { unsigned int v1:15; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu15s_Sf { unsigned int v1:15; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu16i_Sf { unsigned int v1:15; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu16ll_Sf { unsigned int v1:15; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu16s_Sf { unsigned int v1:15; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu17i_Sf { unsigned int v1:15; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu17ll_Sf { unsigned int v1:15; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu1c_Sf { unsigned int v1:15; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu1i_Sf { unsigned int v1:15; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu1ll_Sf { unsigned int v1:15; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu1s_Sf { unsigned int v1:15; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu31i_Sf { unsigned int v1:15; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu31ll_Sf { unsigned int v1:15; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu32i_Sf { unsigned int v1:15; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu32ll_Sf { unsigned int v1:15; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu33_Sf { unsigned int v1:15; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu7c_Sf { unsigned int v1:15; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu7i_Sf { unsigned int v1:15; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu7ll_Sf { unsigned int v1:15; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu7s_Sf { unsigned int v1:15; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu8c_Sf { unsigned int v1:15; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu8i_Sf { unsigned int v1:15; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu8ll_Sf { unsigned int v1:15; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu8s_Sf { unsigned int v1:15; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu9i_Sf { unsigned int v1:15; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu9ll_Sf { unsigned int v1:15; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu15i_BFu9s_Sf { unsigned int v1:15; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu15i_C_Sf { unsigned int v1:15; char v2; empty v3; };
struct __attribute__((packed)) aBFu15i_D_Sf { unsigned int v1:15; double v2; empty v3; };
struct __attribute__((packed)) aBFu15i_F_Sf { unsigned int v1:15; float v2; empty v3; };
struct __attribute__((packed)) aBFu15i_I_Sf { unsigned int v1:15; int v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Ip_Sf { unsigned int v1:15; int * v2; empty v3; };
struct __attribute__((packed)) aBFu15i_L_Sf { unsigned int v1:15; long long v2; empty v3; };
struct __attribute__((packed)) aBFu15i_S_Sf { unsigned int v1:15; short v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Sf { unsigned int v1:15; empty v2; };
struct __attribute__((packed)) aBFu15i_Sf_BFu15i { unsigned int v1:15; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu15i_Sf_BFu15ll { unsigned int v1:15; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu15i_Sf_BFu15s { unsigned int v1:15; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu15i_Sf_BFu16i { unsigned int v1:15; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu15i_Sf_BFu16ll { unsigned int v1:15; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu15i_Sf_BFu16s { unsigned int v1:15; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu15i_Sf_BFu17i { unsigned int v1:15; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu15i_Sf_BFu17ll { unsigned int v1:15; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu15i_Sf_BFu1c { unsigned int v1:15; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu15i_Sf_BFu1i { unsigned int v1:15; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu15i_Sf_BFu1ll { unsigned int v1:15; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu15i_Sf_BFu1s { unsigned int v1:15; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu15i_Sf_BFu31i { unsigned int v1:15; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu15i_Sf_BFu31ll { unsigned int v1:15; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu15i_Sf_BFu32i { unsigned int v1:15; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu15i_Sf_BFu32ll { unsigned int v1:15; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu15i_Sf_BFu33 { unsigned int v1:15; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu15i_Sf_BFu7c { unsigned int v1:15; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu15i_Sf_BFu7i { unsigned int v1:15; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu15i_Sf_BFu7ll { unsigned int v1:15; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu15i_Sf_BFu7s { unsigned int v1:15; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu15i_Sf_BFu8c { unsigned int v1:15; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu15i_Sf_BFu8i { unsigned int v1:15; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu15i_Sf_BFu8ll { unsigned int v1:15; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu15i_Sf_BFu8s { unsigned int v1:15; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu15i_Sf_BFu9i { unsigned int v1:15; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu15i_Sf_BFu9ll { unsigned int v1:15; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu15i_Sf_BFu9s { unsigned int v1:15; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu15i_Sf_C { unsigned int v1:15; empty v2; char v3; };
struct __attribute__((packed)) aBFu15i_Sf_D { unsigned int v1:15; empty v2; double v3; };
struct __attribute__((packed)) aBFu15i_Sf_F { unsigned int v1:15; empty v2; float v3; };
struct __attribute__((packed)) aBFu15i_Sf_I { unsigned int v1:15; empty v2; int v3; };
struct __attribute__((packed)) aBFu15i_Sf_Ip { unsigned int v1:15; empty v2; int * v3; };
struct __attribute__((packed)) aBFu15i_Sf_L { unsigned int v1:15; empty v2; long long v3; };
struct __attribute__((packed)) aBFu15i_Sf_S { unsigned int v1:15; empty v2; short v3; };
struct __attribute__((packed)) aBFu15i_Sf_Sf { unsigned int v1:15; empty v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Sf_Uc { unsigned int v1:15; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu15i_Sf_Ui { unsigned int v1:15; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu15i_Sf_Ul { unsigned int v1:15; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu15i_Sf_Us { unsigned int v1:15; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu15i_Sf_Vp { unsigned int v1:15; empty v2; void * v3; };
struct __attribute__((packed)) aBFu15i_Uc_Sf { unsigned int v1:15; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Ui_Sf { unsigned int v1:15; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Ul_Sf { unsigned int v1:15; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Us_Sf { unsigned int v1:15; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu15i_Vp_Sf { unsigned int v1:15; void * v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu15i_Sf { unsigned long long v1:15; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu15ll_Sf { unsigned long long v1:15; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu15s_Sf { unsigned long long v1:15; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu16i_Sf { unsigned long long v1:15; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu16ll_Sf { unsigned long long v1:15; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu16s_Sf { unsigned long long v1:15; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu17i_Sf { unsigned long long v1:15; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu17ll_Sf { unsigned long long v1:15; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu1c_Sf { unsigned long long v1:15; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu1i_Sf { unsigned long long v1:15; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu1ll_Sf { unsigned long long v1:15; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu1s_Sf { unsigned long long v1:15; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu31i_Sf { unsigned long long v1:15; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu31ll_Sf { unsigned long long v1:15; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu32i_Sf { unsigned long long v1:15; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu32ll_Sf { unsigned long long v1:15; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu33_Sf { unsigned long long v1:15; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu7c_Sf { unsigned long long v1:15; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu7i_Sf { unsigned long long v1:15; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu7ll_Sf { unsigned long long v1:15; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu7s_Sf { unsigned long long v1:15; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu8c_Sf { unsigned long long v1:15; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu8i_Sf { unsigned long long v1:15; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu8ll_Sf { unsigned long long v1:15; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu8s_Sf { unsigned long long v1:15; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu9i_Sf { unsigned long long v1:15; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu9ll_Sf { unsigned long long v1:15; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu15ll_BFu9s_Sf { unsigned long long v1:15; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu15ll_C_Sf { unsigned long long v1:15; char v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_D_Sf { unsigned long long v1:15; double v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_F_Sf { unsigned long long v1:15; float v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_I_Sf { unsigned long long v1:15; int v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Ip_Sf { unsigned long long v1:15; int * v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_L_Sf { unsigned long long v1:15; long long v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_S_Sf { unsigned long long v1:15; short v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Sf { unsigned long long v1:15; empty v2; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu15i { unsigned long long v1:15; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu15ll { unsigned long long v1:15; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu15s { unsigned long long v1:15; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu16i { unsigned long long v1:15; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu16ll { unsigned long long v1:15; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu16s { unsigned long long v1:15; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu17i { unsigned long long v1:15; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu17ll { unsigned long long v1:15; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu1c { unsigned long long v1:15; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu1i { unsigned long long v1:15; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu1ll { unsigned long long v1:15; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu1s { unsigned long long v1:15; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu31i { unsigned long long v1:15; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu31ll { unsigned long long v1:15; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu32i { unsigned long long v1:15; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu32ll { unsigned long long v1:15; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu33 { unsigned long long v1:15; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu7c { unsigned long long v1:15; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu7i { unsigned long long v1:15; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu7ll { unsigned long long v1:15; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu7s { unsigned long long v1:15; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu8c { unsigned long long v1:15; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu8i { unsigned long long v1:15; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu8ll { unsigned long long v1:15; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu8s { unsigned long long v1:15; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu9i { unsigned long long v1:15; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu9ll { unsigned long long v1:15; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu15ll_Sf_BFu9s { unsigned long long v1:15; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu15ll_Sf_C { unsigned long long v1:15; empty v2; char v3; };
struct __attribute__((packed)) aBFu15ll_Sf_D { unsigned long long v1:15; empty v2; double v3; };
struct __attribute__((packed)) aBFu15ll_Sf_F { unsigned long long v1:15; empty v2; float v3; };
struct __attribute__((packed)) aBFu15ll_Sf_I { unsigned long long v1:15; empty v2; int v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Ip { unsigned long long v1:15; empty v2; int * v3; };
struct __attribute__((packed)) aBFu15ll_Sf_L { unsigned long long v1:15; empty v2; long long v3; };
struct __attribute__((packed)) aBFu15ll_Sf_S { unsigned long long v1:15; empty v2; short v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Sf { unsigned long long v1:15; empty v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Uc { unsigned long long v1:15; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Ui { unsigned long long v1:15; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Ul { unsigned long long v1:15; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Us { unsigned long long v1:15; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu15ll_Sf_Vp { unsigned long long v1:15; empty v2; void * v3; };
struct __attribute__((packed)) aBFu15ll_Uc_Sf { unsigned long long v1:15; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Ui_Sf { unsigned long long v1:15; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Ul_Sf { unsigned long long v1:15; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Us_Sf { unsigned long long v1:15; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu15ll_Vp_Sf { unsigned long long v1:15; void * v2; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu15i_Sf { unsigned short v1:15; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu15ll_Sf { unsigned short v1:15; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu15s_Sf { unsigned short v1:15; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu16i_Sf { unsigned short v1:15; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu16ll_Sf { unsigned short v1:15; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu16s_Sf { unsigned short v1:15; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu17i_Sf { unsigned short v1:15; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu17ll_Sf { unsigned short v1:15; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu1c_Sf { unsigned short v1:15; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu1i_Sf { unsigned short v1:15; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu1ll_Sf { unsigned short v1:15; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu1s_Sf { unsigned short v1:15; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu31i_Sf { unsigned short v1:15; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu31ll_Sf { unsigned short v1:15; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu32i_Sf { unsigned short v1:15; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu32ll_Sf { unsigned short v1:15; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu33_Sf { unsigned short v1:15; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu7c_Sf { unsigned short v1:15; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu7i_Sf { unsigned short v1:15; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu7ll_Sf { unsigned short v1:15; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu7s_Sf { unsigned short v1:15; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu8c_Sf { unsigned short v1:15; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu8i_Sf { unsigned short v1:15; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu8ll_Sf { unsigned short v1:15; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu8s_Sf { unsigned short v1:15; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu9i_Sf { unsigned short v1:15; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu9ll_Sf { unsigned short v1:15; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu15s_BFu9s_Sf { unsigned short v1:15; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu15s_C_Sf { unsigned short v1:15; char v2; empty v3; };
struct __attribute__((packed)) aBFu15s_D_Sf { unsigned short v1:15; double v2; empty v3; };
struct __attribute__((packed)) aBFu15s_F_Sf { unsigned short v1:15; float v2; empty v3; };
struct __attribute__((packed)) aBFu15s_I_Sf { unsigned short v1:15; int v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Ip_Sf { unsigned short v1:15; int * v2; empty v3; };
struct __attribute__((packed)) aBFu15s_L_Sf { unsigned short v1:15; long long v2; empty v3; };
struct __attribute__((packed)) aBFu15s_S_Sf { unsigned short v1:15; short v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Sf { unsigned short v1:15; empty v2; };
struct __attribute__((packed)) aBFu15s_Sf_BFu15i { unsigned short v1:15; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu15s_Sf_BFu15ll { unsigned short v1:15; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu15s_Sf_BFu15s { unsigned short v1:15; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu15s_Sf_BFu16i { unsigned short v1:15; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu15s_Sf_BFu16ll { unsigned short v1:15; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu15s_Sf_BFu16s { unsigned short v1:15; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu15s_Sf_BFu17i { unsigned short v1:15; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu15s_Sf_BFu17ll { unsigned short v1:15; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu15s_Sf_BFu1c { unsigned short v1:15; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu15s_Sf_BFu1i { unsigned short v1:15; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu15s_Sf_BFu1ll { unsigned short v1:15; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu15s_Sf_BFu1s { unsigned short v1:15; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu15s_Sf_BFu31i { unsigned short v1:15; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu15s_Sf_BFu31ll { unsigned short v1:15; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu15s_Sf_BFu32i { unsigned short v1:15; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu15s_Sf_BFu32ll { unsigned short v1:15; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu15s_Sf_BFu33 { unsigned short v1:15; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu15s_Sf_BFu7c { unsigned short v1:15; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu15s_Sf_BFu7i { unsigned short v1:15; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu15s_Sf_BFu7ll { unsigned short v1:15; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu15s_Sf_BFu7s { unsigned short v1:15; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu15s_Sf_BFu8c { unsigned short v1:15; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu15s_Sf_BFu8i { unsigned short v1:15; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu15s_Sf_BFu8ll { unsigned short v1:15; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu15s_Sf_BFu8s { unsigned short v1:15; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu15s_Sf_BFu9i { unsigned short v1:15; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu15s_Sf_BFu9ll { unsigned short v1:15; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu15s_Sf_BFu9s { unsigned short v1:15; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu15s_Sf_C { unsigned short v1:15; empty v2; char v3; };
struct __attribute__((packed)) aBFu15s_Sf_D { unsigned short v1:15; empty v2; double v3; };
struct __attribute__((packed)) aBFu15s_Sf_F { unsigned short v1:15; empty v2; float v3; };
struct __attribute__((packed)) aBFu15s_Sf_I { unsigned short v1:15; empty v2; int v3; };
struct __attribute__((packed)) aBFu15s_Sf_Ip { unsigned short v1:15; empty v2; int * v3; };
struct __attribute__((packed)) aBFu15s_Sf_L { unsigned short v1:15; empty v2; long long v3; };
struct __attribute__((packed)) aBFu15s_Sf_S { unsigned short v1:15; empty v2; short v3; };
struct __attribute__((packed)) aBFu15s_Sf_Sf { unsigned short v1:15; empty v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Sf_Uc { unsigned short v1:15; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu15s_Sf_Ui { unsigned short v1:15; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu15s_Sf_Ul { unsigned short v1:15; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu15s_Sf_Us { unsigned short v1:15; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu15s_Sf_Vp { unsigned short v1:15; empty v2; void * v3; };
struct __attribute__((packed)) aBFu15s_Uc_Sf { unsigned short v1:15; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Ui_Sf { unsigned short v1:15; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Ul_Sf { unsigned short v1:15; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Us_Sf { unsigned short v1:15; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu15s_Vp_Sf { unsigned short v1:15; void * v2; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu15i_Sf { unsigned int v1:16; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu15ll_Sf { unsigned int v1:16; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu15s_Sf { unsigned int v1:16; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu16i_Sf { unsigned int v1:16; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu16ll_Sf { unsigned int v1:16; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu16s_Sf { unsigned int v1:16; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu17i_Sf { unsigned int v1:16; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu17ll_Sf { unsigned int v1:16; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu1c_Sf { unsigned int v1:16; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu1i_Sf { unsigned int v1:16; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu1ll_Sf { unsigned int v1:16; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu1s_Sf { unsigned int v1:16; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu31i_Sf { unsigned int v1:16; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu31ll_Sf { unsigned int v1:16; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu32i_Sf { unsigned int v1:16; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu32ll_Sf { unsigned int v1:16; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu33_Sf { unsigned int v1:16; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu7c_Sf { unsigned int v1:16; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu7i_Sf { unsigned int v1:16; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu7ll_Sf { unsigned int v1:16; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu7s_Sf { unsigned int v1:16; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu8c_Sf { unsigned int v1:16; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu8i_Sf { unsigned int v1:16; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu8ll_Sf { unsigned int v1:16; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu8s_Sf { unsigned int v1:16; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu9i_Sf { unsigned int v1:16; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu9ll_Sf { unsigned int v1:16; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu16i_BFu9s_Sf { unsigned int v1:16; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu16i_C_Sf { unsigned int v1:16; char v2; empty v3; };
struct __attribute__((packed)) aBFu16i_D_Sf { unsigned int v1:16; double v2; empty v3; };
struct __attribute__((packed)) aBFu16i_F_Sf { unsigned int v1:16; float v2; empty v3; };
struct __attribute__((packed)) aBFu16i_I_Sf { unsigned int v1:16; int v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Ip_Sf { unsigned int v1:16; int * v2; empty v3; };
struct __attribute__((packed)) aBFu16i_L_Sf { unsigned int v1:16; long long v2; empty v3; };
struct __attribute__((packed)) aBFu16i_S_Sf { unsigned int v1:16; short v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Sf { unsigned int v1:16; empty v2; };
struct __attribute__((packed)) aBFu16i_Sf_BFu15i { unsigned int v1:16; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16i_Sf_BFu15ll { unsigned int v1:16; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16i_Sf_BFu15s { unsigned int v1:16; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16i_Sf_BFu16i { unsigned int v1:16; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16i_Sf_BFu16ll { unsigned int v1:16; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16i_Sf_BFu16s { unsigned int v1:16; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16i_Sf_BFu17i { unsigned int v1:16; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16i_Sf_BFu17ll { unsigned int v1:16; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16i_Sf_BFu1c { unsigned int v1:16; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16i_Sf_BFu1i { unsigned int v1:16; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16i_Sf_BFu1ll { unsigned int v1:16; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16i_Sf_BFu1s { unsigned int v1:16; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16i_Sf_BFu31i { unsigned int v1:16; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16i_Sf_BFu31ll { unsigned int v1:16; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16i_Sf_BFu32i { unsigned int v1:16; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16i_Sf_BFu32ll { unsigned int v1:16; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16i_Sf_BFu33 { unsigned int v1:16; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16i_Sf_BFu7c { unsigned int v1:16; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16i_Sf_BFu7i { unsigned int v1:16; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16i_Sf_BFu7ll { unsigned int v1:16; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16i_Sf_BFu7s { unsigned int v1:16; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16i_Sf_BFu8c { unsigned int v1:16; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16i_Sf_BFu8i { unsigned int v1:16; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16i_Sf_BFu8ll { unsigned int v1:16; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16i_Sf_BFu8s { unsigned int v1:16; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16i_Sf_BFu9i { unsigned int v1:16; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16i_Sf_BFu9ll { unsigned int v1:16; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16i_Sf_BFu9s { unsigned int v1:16; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16i_Sf_C { unsigned int v1:16; empty v2; char v3; };
struct __attribute__((packed)) aBFu16i_Sf_D { unsigned int v1:16; empty v2; double v3; };
struct __attribute__((packed)) aBFu16i_Sf_F { unsigned int v1:16; empty v2; float v3; };
struct __attribute__((packed)) aBFu16i_Sf_I { unsigned int v1:16; empty v2; int v3; };
struct __attribute__((packed)) aBFu16i_Sf_Ip { unsigned int v1:16; empty v2; int * v3; };
struct __attribute__((packed)) aBFu16i_Sf_L { unsigned int v1:16; empty v2; long long v3; };
struct __attribute__((packed)) aBFu16i_Sf_S { unsigned int v1:16; empty v2; short v3; };
struct __attribute__((packed)) aBFu16i_Sf_Sf { unsigned int v1:16; empty v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Sf_Uc { unsigned int v1:16; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16i_Sf_Ui { unsigned int v1:16; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16i_Sf_Ul { unsigned int v1:16; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16i_Sf_Us { unsigned int v1:16; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16i_Sf_Vp { unsigned int v1:16; empty v2; void * v3; };
struct __attribute__((packed)) aBFu16i_Uc_Sf { unsigned int v1:16; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Ui_Sf { unsigned int v1:16; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Ul_Sf { unsigned int v1:16; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Us_Sf { unsigned int v1:16; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu16i_Vp_Sf { unsigned int v1:16; void * v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu15i_Sf { unsigned long long v1:16; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu15ll_Sf { unsigned long long v1:16; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu15s_Sf { unsigned long long v1:16; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu16i_Sf { unsigned long long v1:16; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu16ll_Sf { unsigned long long v1:16; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu16s_Sf { unsigned long long v1:16; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu17i_Sf { unsigned long long v1:16; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu17ll_Sf { unsigned long long v1:16; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Sf { unsigned long long v1:16; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Sf { unsigned long long v1:16; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Sf { unsigned long long v1:16; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Sf { unsigned long long v1:16; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Sf { unsigned long long v1:16; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Sf { unsigned long long v1:16; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Sf { unsigned long long v1:16; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Sf { unsigned long long v1:16; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Sf { unsigned long long v1:16; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Sf { unsigned long long v1:16; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Sf { unsigned long long v1:16; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Sf { unsigned long long v1:16; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Sf { unsigned long long v1:16; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Sf { unsigned long long v1:16; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Sf { unsigned long long v1:16; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Sf { unsigned long long v1:16; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Sf { unsigned long long v1:16; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Sf { unsigned long long v1:16; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Sf { unsigned long long v1:16; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Sf { unsigned long long v1:16; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu16ll_C_Sf { unsigned long long v1:16; char v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_D_Sf { unsigned long long v1:16; double v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_F_Sf { unsigned long long v1:16; float v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_I_Sf { unsigned long long v1:16; int v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Sf { unsigned long long v1:16; int * v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_L_Sf { unsigned long long v1:16; long long v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_S_Sf { unsigned long long v1:16; short v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Sf { unsigned long long v1:16; empty v2; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu15i { unsigned long long v1:16; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu15ll { unsigned long long v1:16; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu15s { unsigned long long v1:16; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu16i { unsigned long long v1:16; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu16ll { unsigned long long v1:16; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu16s { unsigned long long v1:16; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu17i { unsigned long long v1:16; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu17ll { unsigned long long v1:16; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu1c { unsigned long long v1:16; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu1i { unsigned long long v1:16; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu1ll { unsigned long long v1:16; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu1s { unsigned long long v1:16; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu31i { unsigned long long v1:16; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu31ll { unsigned long long v1:16; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu32i { unsigned long long v1:16; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu32ll { unsigned long long v1:16; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu33 { unsigned long long v1:16; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu7c { unsigned long long v1:16; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu7i { unsigned long long v1:16; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu7ll { unsigned long long v1:16; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu7s { unsigned long long v1:16; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu8c { unsigned long long v1:16; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu8i { unsigned long long v1:16; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu8ll { unsigned long long v1:16; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu8s { unsigned long long v1:16; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu9i { unsigned long long v1:16; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu9ll { unsigned long long v1:16; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Sf_BFu9s { unsigned long long v1:16; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Sf_C { unsigned long long v1:16; empty v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Sf_D { unsigned long long v1:16; empty v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Sf_F { unsigned long long v1:16; empty v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Sf_I { unsigned long long v1:16; empty v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Ip { unsigned long long v1:16; empty v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Sf_L { unsigned long long v1:16; empty v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Sf_S { unsigned long long v1:16; empty v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Sf { unsigned long long v1:16; empty v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Uc { unsigned long long v1:16; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Ui { unsigned long long v1:16; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Ul { unsigned long long v1:16; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Us { unsigned long long v1:16; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Sf_Vp { unsigned long long v1:16; empty v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Sf { unsigned long long v1:16; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Sf { unsigned long long v1:16; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Sf { unsigned long long v1:16; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Us_Sf { unsigned long long v1:16; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Sf { unsigned long long v1:16; void * v2; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Sf { unsigned short v1:16; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Sf { unsigned short v1:16; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Sf { unsigned short v1:16; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Sf { unsigned short v1:16; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Sf { unsigned short v1:16; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Sf { unsigned short v1:16; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Sf { unsigned short v1:16; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Sf { unsigned short v1:16; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Sf { unsigned short v1:16; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Sf { unsigned short v1:16; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Sf { unsigned short v1:16; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Sf { unsigned short v1:16; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Sf { unsigned short v1:16; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Sf { unsigned short v1:16; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Sf { unsigned short v1:16; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Sf { unsigned short v1:16; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Sf { unsigned short v1:16; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Sf { unsigned short v1:16; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Sf { unsigned short v1:16; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Sf { unsigned short v1:16; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Sf { unsigned short v1:16; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Sf { unsigned short v1:16; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Sf { unsigned short v1:16; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Sf { unsigned short v1:16; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Sf { unsigned short v1:16; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Sf { unsigned short v1:16; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Sf { unsigned short v1:16; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Sf { unsigned short v1:16; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu16s_C_Sf { unsigned short v1:16; char v2; empty v3; };
struct __attribute__((packed)) aBFu16s_D_Sf { unsigned short v1:16; double v2; empty v3; };
struct __attribute__((packed)) aBFu16s_F_Sf { unsigned short v1:16; float v2; empty v3; };
struct __attribute__((packed)) aBFu16s_I_Sf { unsigned short v1:16; int v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Ip_Sf { unsigned short v1:16; int * v2; empty v3; };
struct __attribute__((packed)) aBFu16s_L_Sf { unsigned short v1:16; long long v2; empty v3; };
struct __attribute__((packed)) aBFu16s_S_Sf { unsigned short v1:16; short v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Sf { unsigned short v1:16; empty v2; };
struct __attribute__((packed)) aBFu16s_Sf_BFu15i { unsigned short v1:16; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_Sf_BFu15ll { unsigned short v1:16; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_Sf_BFu15s { unsigned short v1:16; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_Sf_BFu16i { unsigned short v1:16; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_Sf_BFu16ll { unsigned short v1:16; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_Sf_BFu16s { unsigned short v1:16; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_Sf_BFu17i { unsigned short v1:16; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_Sf_BFu17ll { unsigned short v1:16; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_Sf_BFu1c { unsigned short v1:16; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_Sf_BFu1i { unsigned short v1:16; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_Sf_BFu1ll { unsigned short v1:16; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_Sf_BFu1s { unsigned short v1:16; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_Sf_BFu31i { unsigned short v1:16; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_Sf_BFu31ll { unsigned short v1:16; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_Sf_BFu32i { unsigned short v1:16; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_Sf_BFu32ll { unsigned short v1:16; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_Sf_BFu33 { unsigned short v1:16; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_Sf_BFu7c { unsigned short v1:16; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_Sf_BFu7i { unsigned short v1:16; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_Sf_BFu7ll { unsigned short v1:16; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_Sf_BFu7s { unsigned short v1:16; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_Sf_BFu8c { unsigned short v1:16; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_Sf_BFu8i { unsigned short v1:16; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_Sf_BFu8ll { unsigned short v1:16; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_Sf_BFu8s { unsigned short v1:16; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_Sf_BFu9i { unsigned short v1:16; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_Sf_BFu9ll { unsigned short v1:16; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_Sf_BFu9s { unsigned short v1:16; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_Sf_C { unsigned short v1:16; empty v2; char v3; };
struct __attribute__((packed)) aBFu16s_Sf_D { unsigned short v1:16; empty v2; double v3; };
struct __attribute__((packed)) aBFu16s_Sf_F { unsigned short v1:16; empty v2; float v3; };
struct __attribute__((packed)) aBFu16s_Sf_I { unsigned short v1:16; empty v2; int v3; };
struct __attribute__((packed)) aBFu16s_Sf_Ip { unsigned short v1:16; empty v2; int * v3; };
struct __attribute__((packed)) aBFu16s_Sf_L { unsigned short v1:16; empty v2; long long v3; };
struct __attribute__((packed)) aBFu16s_Sf_S { unsigned short v1:16; empty v2; short v3; };
struct __attribute__((packed)) aBFu16s_Sf_Sf { unsigned short v1:16; empty v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Sf_Uc { unsigned short v1:16; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_Sf_Ui { unsigned short v1:16; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_Sf_Ul { unsigned short v1:16; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_Sf_Us { unsigned short v1:16; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_Sf_Vp { unsigned short v1:16; empty v2; void * v3; };
struct __attribute__((packed)) aBFu16s_Uc_Sf { unsigned short v1:16; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Ui_Sf { unsigned short v1:16; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Ul_Sf { unsigned short v1:16; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Us_Sf { unsigned short v1:16; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu16s_Vp_Sf { unsigned short v1:16; void * v2; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu15i_Sf { unsigned int v1:17; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu15ll_Sf { unsigned int v1:17; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu15s_Sf { unsigned int v1:17; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu16i_Sf { unsigned int v1:17; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu16ll_Sf { unsigned int v1:17; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu16s_Sf { unsigned int v1:17; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu17i_Sf { unsigned int v1:17; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu17ll_Sf { unsigned int v1:17; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu1c_Sf { unsigned int v1:17; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu1i_Sf { unsigned int v1:17; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu1ll_Sf { unsigned int v1:17; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu1s_Sf { unsigned int v1:17; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu31i_Sf { unsigned int v1:17; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu31ll_Sf { unsigned int v1:17; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu32i_Sf { unsigned int v1:17; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu32ll_Sf { unsigned int v1:17; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu33_Sf { unsigned int v1:17; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu7c_Sf { unsigned int v1:17; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu7i_Sf { unsigned int v1:17; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu7ll_Sf { unsigned int v1:17; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu7s_Sf { unsigned int v1:17; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu8c_Sf { unsigned int v1:17; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu8i_Sf { unsigned int v1:17; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu8ll_Sf { unsigned int v1:17; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu8s_Sf { unsigned int v1:17; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu9i_Sf { unsigned int v1:17; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu9ll_Sf { unsigned int v1:17; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu17i_BFu9s_Sf { unsigned int v1:17; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu17i_C_Sf { unsigned int v1:17; char v2; empty v3; };
struct __attribute__((packed)) aBFu17i_D_Sf { unsigned int v1:17; double v2; empty v3; };
struct __attribute__((packed)) aBFu17i_F_Sf { unsigned int v1:17; float v2; empty v3; };
struct __attribute__((packed)) aBFu17i_I_Sf { unsigned int v1:17; int v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Ip_Sf { unsigned int v1:17; int * v2; empty v3; };
struct __attribute__((packed)) aBFu17i_L_Sf { unsigned int v1:17; long long v2; empty v3; };
struct __attribute__((packed)) aBFu17i_S_Sf { unsigned int v1:17; short v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Sf { unsigned int v1:17; empty v2; };
struct __attribute__((packed)) aBFu17i_Sf_BFu15i { unsigned int v1:17; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu17i_Sf_BFu15ll { unsigned int v1:17; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu17i_Sf_BFu15s { unsigned int v1:17; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu17i_Sf_BFu16i { unsigned int v1:17; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu17i_Sf_BFu16ll { unsigned int v1:17; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu17i_Sf_BFu16s { unsigned int v1:17; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu17i_Sf_BFu17i { unsigned int v1:17; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu17i_Sf_BFu17ll { unsigned int v1:17; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu17i_Sf_BFu1c { unsigned int v1:17; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu17i_Sf_BFu1i { unsigned int v1:17; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu17i_Sf_BFu1ll { unsigned int v1:17; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu17i_Sf_BFu1s { unsigned int v1:17; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu17i_Sf_BFu31i { unsigned int v1:17; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu17i_Sf_BFu31ll { unsigned int v1:17; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu17i_Sf_BFu32i { unsigned int v1:17; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu17i_Sf_BFu32ll { unsigned int v1:17; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu17i_Sf_BFu33 { unsigned int v1:17; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu17i_Sf_BFu7c { unsigned int v1:17; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu17i_Sf_BFu7i { unsigned int v1:17; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu17i_Sf_BFu7ll { unsigned int v1:17; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu17i_Sf_BFu7s { unsigned int v1:17; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu17i_Sf_BFu8c { unsigned int v1:17; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu17i_Sf_BFu8i { unsigned int v1:17; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu17i_Sf_BFu8ll { unsigned int v1:17; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu17i_Sf_BFu8s { unsigned int v1:17; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu17i_Sf_BFu9i { unsigned int v1:17; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu17i_Sf_BFu9ll { unsigned int v1:17; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu17i_Sf_BFu9s { unsigned int v1:17; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu17i_Sf_C { unsigned int v1:17; empty v2; char v3; };
struct __attribute__((packed)) aBFu17i_Sf_D { unsigned int v1:17; empty v2; double v3; };
struct __attribute__((packed)) aBFu17i_Sf_F { unsigned int v1:17; empty v2; float v3; };
struct __attribute__((packed)) aBFu17i_Sf_I { unsigned int v1:17; empty v2; int v3; };
struct __attribute__((packed)) aBFu17i_Sf_Ip { unsigned int v1:17; empty v2; int * v3; };
struct __attribute__((packed)) aBFu17i_Sf_L { unsigned int v1:17; empty v2; long long v3; };
struct __attribute__((packed)) aBFu17i_Sf_S { unsigned int v1:17; empty v2; short v3; };
struct __attribute__((packed)) aBFu17i_Sf_Sf { unsigned int v1:17; empty v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Sf_Uc { unsigned int v1:17; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu17i_Sf_Ui { unsigned int v1:17; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu17i_Sf_Ul { unsigned int v1:17; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu17i_Sf_Us { unsigned int v1:17; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu17i_Sf_Vp { unsigned int v1:17; empty v2; void * v3; };
struct __attribute__((packed)) aBFu17i_Uc_Sf { unsigned int v1:17; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Ui_Sf { unsigned int v1:17; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Ul_Sf { unsigned int v1:17; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Us_Sf { unsigned int v1:17; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu17i_Vp_Sf { unsigned int v1:17; void * v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu15i_Sf { unsigned long long v1:17; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu15ll_Sf { unsigned long long v1:17; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu15s_Sf { unsigned long long v1:17; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu16i_Sf { unsigned long long v1:17; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu16ll_Sf { unsigned long long v1:17; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu16s_Sf { unsigned long long v1:17; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu17i_Sf { unsigned long long v1:17; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu17ll_Sf { unsigned long long v1:17; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu1c_Sf { unsigned long long v1:17; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu1i_Sf { unsigned long long v1:17; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu1ll_Sf { unsigned long long v1:17; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu1s_Sf { unsigned long long v1:17; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu31i_Sf { unsigned long long v1:17; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu31ll_Sf { unsigned long long v1:17; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu32i_Sf { unsigned long long v1:17; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu32ll_Sf { unsigned long long v1:17; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu33_Sf { unsigned long long v1:17; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu7c_Sf { unsigned long long v1:17; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu7i_Sf { unsigned long long v1:17; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu7ll_Sf { unsigned long long v1:17; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu7s_Sf { unsigned long long v1:17; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu8c_Sf { unsigned long long v1:17; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu8i_Sf { unsigned long long v1:17; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu8ll_Sf { unsigned long long v1:17; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu8s_Sf { unsigned long long v1:17; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu9i_Sf { unsigned long long v1:17; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu9ll_Sf { unsigned long long v1:17; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu17ll_BFu9s_Sf { unsigned long long v1:17; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu17ll_C_Sf { unsigned long long v1:17; char v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_D_Sf { unsigned long long v1:17; double v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_F_Sf { unsigned long long v1:17; float v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_I_Sf { unsigned long long v1:17; int v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Ip_Sf { unsigned long long v1:17; int * v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_L_Sf { unsigned long long v1:17; long long v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_S_Sf { unsigned long long v1:17; short v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Sf { unsigned long long v1:17; empty v2; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu15i { unsigned long long v1:17; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu15ll { unsigned long long v1:17; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu15s { unsigned long long v1:17; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu16i { unsigned long long v1:17; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu16ll { unsigned long long v1:17; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu16s { unsigned long long v1:17; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu17i { unsigned long long v1:17; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu17ll { unsigned long long v1:17; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu1c { unsigned long long v1:17; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu1i { unsigned long long v1:17; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu1ll { unsigned long long v1:17; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu1s { unsigned long long v1:17; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu31i { unsigned long long v1:17; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu31ll { unsigned long long v1:17; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu32i { unsigned long long v1:17; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu32ll { unsigned long long v1:17; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu33 { unsigned long long v1:17; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu7c { unsigned long long v1:17; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu7i { unsigned long long v1:17; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu7ll { unsigned long long v1:17; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu7s { unsigned long long v1:17; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu8c { unsigned long long v1:17; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu8i { unsigned long long v1:17; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu8ll { unsigned long long v1:17; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu8s { unsigned long long v1:17; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu9i { unsigned long long v1:17; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu9ll { unsigned long long v1:17; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu17ll_Sf_BFu9s { unsigned long long v1:17; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu17ll_Sf_C { unsigned long long v1:17; empty v2; char v3; };
struct __attribute__((packed)) aBFu17ll_Sf_D { unsigned long long v1:17; empty v2; double v3; };
struct __attribute__((packed)) aBFu17ll_Sf_F { unsigned long long v1:17; empty v2; float v3; };
struct __attribute__((packed)) aBFu17ll_Sf_I { unsigned long long v1:17; empty v2; int v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Ip { unsigned long long v1:17; empty v2; int * v3; };
struct __attribute__((packed)) aBFu17ll_Sf_L { unsigned long long v1:17; empty v2; long long v3; };
struct __attribute__((packed)) aBFu17ll_Sf_S { unsigned long long v1:17; empty v2; short v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Sf { unsigned long long v1:17; empty v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Uc { unsigned long long v1:17; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Ui { unsigned long long v1:17; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Ul { unsigned long long v1:17; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Us { unsigned long long v1:17; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu17ll_Sf_Vp { unsigned long long v1:17; empty v2; void * v3; };
struct __attribute__((packed)) aBFu17ll_Uc_Sf { unsigned long long v1:17; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Ui_Sf { unsigned long long v1:17; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Ul_Sf { unsigned long long v1:17; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Us_Sf { unsigned long long v1:17; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu17ll_Vp_Sf { unsigned long long v1:17; void * v2; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu15i_Sf { unsigned char v1:1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu15ll_Sf { unsigned char v1:1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu15s_Sf { unsigned char v1:1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu16i_Sf { unsigned char v1:1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu16ll_Sf { unsigned char v1:1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu16s_Sf { unsigned char v1:1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu17i_Sf { unsigned char v1:1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu17ll_Sf { unsigned char v1:1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu1c_Sf { unsigned char v1:1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu1i_Sf { unsigned char v1:1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu1ll_Sf { unsigned char v1:1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu1s_Sf { unsigned char v1:1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu31i_Sf { unsigned char v1:1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu31ll_Sf { unsigned char v1:1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu32i_Sf { unsigned char v1:1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu32ll_Sf { unsigned char v1:1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu33_Sf { unsigned char v1:1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu7c_Sf { unsigned char v1:1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu7i_Sf { unsigned char v1:1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu7ll_Sf { unsigned char v1:1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu7s_Sf { unsigned char v1:1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu8c_Sf { unsigned char v1:1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu8i_Sf { unsigned char v1:1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu8ll_Sf { unsigned char v1:1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu8s_Sf { unsigned char v1:1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu9i_Sf { unsigned char v1:1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu9ll_Sf { unsigned char v1:1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu1c_BFu9s_Sf { unsigned char v1:1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu1c_C_Sf { unsigned char v1:1; char v2; empty v3; };
struct __attribute__((packed)) aBFu1c_D_Sf { unsigned char v1:1; double v2; empty v3; };
struct __attribute__((packed)) aBFu1c_F_Sf { unsigned char v1:1; float v2; empty v3; };
struct __attribute__((packed)) aBFu1c_I_Sf { unsigned char v1:1; int v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Ip_Sf { unsigned char v1:1; int * v2; empty v3; };
struct __attribute__((packed)) aBFu1c_L_Sf { unsigned char v1:1; long long v2; empty v3; };
struct __attribute__((packed)) aBFu1c_S_Sf { unsigned char v1:1; short v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Sf { unsigned char v1:1; empty v2; };
struct __attribute__((packed)) aBFu1c_Sf_BFu15i { unsigned char v1:1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1c_Sf_BFu15ll { unsigned char v1:1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1c_Sf_BFu15s { unsigned char v1:1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1c_Sf_BFu16i { unsigned char v1:1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1c_Sf_BFu16ll { unsigned char v1:1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1c_Sf_BFu16s { unsigned char v1:1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1c_Sf_BFu17i { unsigned char v1:1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1c_Sf_BFu17ll { unsigned char v1:1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1c_Sf_BFu1c { unsigned char v1:1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1c_Sf_BFu1i { unsigned char v1:1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1c_Sf_BFu1ll { unsigned char v1:1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1c_Sf_BFu1s { unsigned char v1:1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1c_Sf_BFu31i { unsigned char v1:1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1c_Sf_BFu31ll { unsigned char v1:1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1c_Sf_BFu32i { unsigned char v1:1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1c_Sf_BFu32ll { unsigned char v1:1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1c_Sf_BFu33 { unsigned char v1:1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1c_Sf_BFu7c { unsigned char v1:1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1c_Sf_BFu7i { unsigned char v1:1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1c_Sf_BFu7ll { unsigned char v1:1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1c_Sf_BFu7s { unsigned char v1:1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1c_Sf_BFu8c { unsigned char v1:1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1c_Sf_BFu8i { unsigned char v1:1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1c_Sf_BFu8ll { unsigned char v1:1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1c_Sf_BFu8s { unsigned char v1:1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1c_Sf_BFu9i { unsigned char v1:1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1c_Sf_BFu9ll { unsigned char v1:1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1c_Sf_BFu9s { unsigned char v1:1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1c_Sf_C { unsigned char v1:1; empty v2; char v3; };
struct __attribute__((packed)) aBFu1c_Sf_D { unsigned char v1:1; empty v2; double v3; };
struct __attribute__((packed)) aBFu1c_Sf_F { unsigned char v1:1; empty v2; float v3; };
struct __attribute__((packed)) aBFu1c_Sf_I { unsigned char v1:1; empty v2; int v3; };
struct __attribute__((packed)) aBFu1c_Sf_Ip { unsigned char v1:1; empty v2; int * v3; };
struct __attribute__((packed)) aBFu1c_Sf_L { unsigned char v1:1; empty v2; long long v3; };
struct __attribute__((packed)) aBFu1c_Sf_S { unsigned char v1:1; empty v2; short v3; };
struct __attribute__((packed)) aBFu1c_Sf_Sf { unsigned char v1:1; empty v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Sf_Uc { unsigned char v1:1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1c_Sf_Ui { unsigned char v1:1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1c_Sf_Ul { unsigned char v1:1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1c_Sf_Us { unsigned char v1:1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1c_Sf_Vp { unsigned char v1:1; empty v2; void * v3; };
struct __attribute__((packed)) aBFu1c_Uc_Sf { unsigned char v1:1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Ui_Sf { unsigned char v1:1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Ul_Sf { unsigned char v1:1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Us_Sf { unsigned char v1:1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu1c_Vp_Sf { unsigned char v1:1; void * v2; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu15i_Sf { unsigned int v1:1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu15ll_Sf { unsigned int v1:1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu15s_Sf { unsigned int v1:1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu16i_Sf { unsigned int v1:1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu16ll_Sf { unsigned int v1:1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu16s_Sf { unsigned int v1:1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu17i_Sf { unsigned int v1:1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu17ll_Sf { unsigned int v1:1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu1c_Sf { unsigned int v1:1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu1i_Sf { unsigned int v1:1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu1ll_Sf { unsigned int v1:1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu1s_Sf { unsigned int v1:1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu31i_Sf { unsigned int v1:1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu31ll_Sf { unsigned int v1:1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu32i_Sf { unsigned int v1:1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu32ll_Sf { unsigned int v1:1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu33_Sf { unsigned int v1:1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu7c_Sf { unsigned int v1:1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu7i_Sf { unsigned int v1:1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu7ll_Sf { unsigned int v1:1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu7s_Sf { unsigned int v1:1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu8c_Sf { unsigned int v1:1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu8i_Sf { unsigned int v1:1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu8ll_Sf { unsigned int v1:1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu8s_Sf { unsigned int v1:1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu9i_Sf { unsigned int v1:1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu9ll_Sf { unsigned int v1:1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu1i_BFu9s_Sf { unsigned int v1:1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu1i_C_Sf { unsigned int v1:1; char v2; empty v3; };
struct __attribute__((packed)) aBFu1i_D_Sf { unsigned int v1:1; double v2; empty v3; };
struct __attribute__((packed)) aBFu1i_F_Sf { unsigned int v1:1; float v2; empty v3; };
struct __attribute__((packed)) aBFu1i_I_Sf { unsigned int v1:1; int v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Ip_Sf { unsigned int v1:1; int * v2; empty v3; };
struct __attribute__((packed)) aBFu1i_L_Sf { unsigned int v1:1; long long v2; empty v3; };
struct __attribute__((packed)) aBFu1i_S_Sf { unsigned int v1:1; short v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Sf { unsigned int v1:1; empty v2; };
struct __attribute__((packed)) aBFu1i_Sf_BFu15i { unsigned int v1:1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1i_Sf_BFu15ll { unsigned int v1:1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1i_Sf_BFu15s { unsigned int v1:1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1i_Sf_BFu16i { unsigned int v1:1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1i_Sf_BFu16ll { unsigned int v1:1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1i_Sf_BFu16s { unsigned int v1:1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1i_Sf_BFu17i { unsigned int v1:1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1i_Sf_BFu17ll { unsigned int v1:1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1i_Sf_BFu1c { unsigned int v1:1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1i_Sf_BFu1i { unsigned int v1:1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1i_Sf_BFu1ll { unsigned int v1:1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1i_Sf_BFu1s { unsigned int v1:1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1i_Sf_BFu31i { unsigned int v1:1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1i_Sf_BFu31ll { unsigned int v1:1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1i_Sf_BFu32i { unsigned int v1:1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1i_Sf_BFu32ll { unsigned int v1:1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1i_Sf_BFu33 { unsigned int v1:1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1i_Sf_BFu7c { unsigned int v1:1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1i_Sf_BFu7i { unsigned int v1:1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1i_Sf_BFu7ll { unsigned int v1:1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1i_Sf_BFu7s { unsigned int v1:1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1i_Sf_BFu8c { unsigned int v1:1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1i_Sf_BFu8i { unsigned int v1:1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1i_Sf_BFu8ll { unsigned int v1:1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1i_Sf_BFu8s { unsigned int v1:1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1i_Sf_BFu9i { unsigned int v1:1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1i_Sf_BFu9ll { unsigned int v1:1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1i_Sf_BFu9s { unsigned int v1:1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1i_Sf_C { unsigned int v1:1; empty v2; char v3; };
struct __attribute__((packed)) aBFu1i_Sf_D { unsigned int v1:1; empty v2; double v3; };
struct __attribute__((packed)) aBFu1i_Sf_F { unsigned int v1:1; empty v2; float v3; };
struct __attribute__((packed)) aBFu1i_Sf_I { unsigned int v1:1; empty v2; int v3; };
struct __attribute__((packed)) aBFu1i_Sf_Ip { unsigned int v1:1; empty v2; int * v3; };
struct __attribute__((packed)) aBFu1i_Sf_L { unsigned int v1:1; empty v2; long long v3; };
struct __attribute__((packed)) aBFu1i_Sf_S { unsigned int v1:1; empty v2; short v3; };
struct __attribute__((packed)) aBFu1i_Sf_Sf { unsigned int v1:1; empty v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Sf_Uc { unsigned int v1:1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1i_Sf_Ui { unsigned int v1:1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1i_Sf_Ul { unsigned int v1:1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1i_Sf_Us { unsigned int v1:1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1i_Sf_Vp { unsigned int v1:1; empty v2; void * v3; };
struct __attribute__((packed)) aBFu1i_Uc_Sf { unsigned int v1:1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Ui_Sf { unsigned int v1:1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Ul_Sf { unsigned int v1:1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Us_Sf { unsigned int v1:1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu1i_Vp_Sf { unsigned int v1:1; void * v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu15i_Sf { unsigned long long v1:1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu15ll_Sf { unsigned long long v1:1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu15s_Sf { unsigned long long v1:1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu16i_Sf { unsigned long long v1:1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu16ll_Sf { unsigned long long v1:1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu16s_Sf { unsigned long long v1:1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu17i_Sf { unsigned long long v1:1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu17ll_Sf { unsigned long long v1:1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu1c_Sf { unsigned long long v1:1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu1i_Sf { unsigned long long v1:1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu1ll_Sf { unsigned long long v1:1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu1s_Sf { unsigned long long v1:1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu31i_Sf { unsigned long long v1:1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu31ll_Sf { unsigned long long v1:1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu32i_Sf { unsigned long long v1:1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu32ll_Sf { unsigned long long v1:1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu33_Sf { unsigned long long v1:1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu7c_Sf { unsigned long long v1:1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu7i_Sf { unsigned long long v1:1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu7ll_Sf { unsigned long long v1:1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu7s_Sf { unsigned long long v1:1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu8c_Sf { unsigned long long v1:1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu8i_Sf { unsigned long long v1:1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu8ll_Sf { unsigned long long v1:1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu8s_Sf { unsigned long long v1:1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu9i_Sf { unsigned long long v1:1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu9ll_Sf { unsigned long long v1:1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu1ll_BFu9s_Sf { unsigned long long v1:1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu1ll_C_Sf { unsigned long long v1:1; char v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_D_Sf { unsigned long long v1:1; double v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_F_Sf { unsigned long long v1:1; float v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_I_Sf { unsigned long long v1:1; int v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Ip_Sf { unsigned long long v1:1; int * v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_L_Sf { unsigned long long v1:1; long long v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_S_Sf { unsigned long long v1:1; short v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Sf { unsigned long long v1:1; empty v2; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu15i { unsigned long long v1:1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu15ll { unsigned long long v1:1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu15s { unsigned long long v1:1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu16i { unsigned long long v1:1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu16ll { unsigned long long v1:1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu16s { unsigned long long v1:1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu17i { unsigned long long v1:1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu17ll { unsigned long long v1:1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu1c { unsigned long long v1:1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu1i { unsigned long long v1:1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu1ll { unsigned long long v1:1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu1s { unsigned long long v1:1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu31i { unsigned long long v1:1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu31ll { unsigned long long v1:1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu32i { unsigned long long v1:1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu32ll { unsigned long long v1:1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu33 { unsigned long long v1:1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu7c { unsigned long long v1:1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu7i { unsigned long long v1:1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu7ll { unsigned long long v1:1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu7s { unsigned long long v1:1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu8c { unsigned long long v1:1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu8i { unsigned long long v1:1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu8ll { unsigned long long v1:1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu8s { unsigned long long v1:1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu9i { unsigned long long v1:1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu9ll { unsigned long long v1:1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1ll_Sf_BFu9s { unsigned long long v1:1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1ll_Sf_C { unsigned long long v1:1; empty v2; char v3; };
struct __attribute__((packed)) aBFu1ll_Sf_D { unsigned long long v1:1; empty v2; double v3; };
struct __attribute__((packed)) aBFu1ll_Sf_F { unsigned long long v1:1; empty v2; float v3; };
struct __attribute__((packed)) aBFu1ll_Sf_I { unsigned long long v1:1; empty v2; int v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Ip { unsigned long long v1:1; empty v2; int * v3; };
struct __attribute__((packed)) aBFu1ll_Sf_L { unsigned long long v1:1; empty v2; long long v3; };
struct __attribute__((packed)) aBFu1ll_Sf_S { unsigned long long v1:1; empty v2; short v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Sf { unsigned long long v1:1; empty v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Uc { unsigned long long v1:1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Ui { unsigned long long v1:1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Ul { unsigned long long v1:1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Us { unsigned long long v1:1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1ll_Sf_Vp { unsigned long long v1:1; empty v2; void * v3; };
struct __attribute__((packed)) aBFu1ll_Uc_Sf { unsigned long long v1:1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Ui_Sf { unsigned long long v1:1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Ul_Sf { unsigned long long v1:1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Us_Sf { unsigned long long v1:1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu1ll_Vp_Sf { unsigned long long v1:1; void * v2; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu15i_Sf { unsigned short v1:1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu15ll_Sf { unsigned short v1:1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu15s_Sf { unsigned short v1:1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu16i_Sf { unsigned short v1:1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu16ll_Sf { unsigned short v1:1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu16s_Sf { unsigned short v1:1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu17i_Sf { unsigned short v1:1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu17ll_Sf { unsigned short v1:1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu1c_Sf { unsigned short v1:1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu1i_Sf { unsigned short v1:1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu1ll_Sf { unsigned short v1:1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu1s_Sf { unsigned short v1:1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu31i_Sf { unsigned short v1:1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu31ll_Sf { unsigned short v1:1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu32i_Sf { unsigned short v1:1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu32ll_Sf { unsigned short v1:1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu33_Sf { unsigned short v1:1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu7c_Sf { unsigned short v1:1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu7i_Sf { unsigned short v1:1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu7ll_Sf { unsigned short v1:1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu7s_Sf { unsigned short v1:1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu8c_Sf { unsigned short v1:1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu8i_Sf { unsigned short v1:1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu8ll_Sf { unsigned short v1:1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu8s_Sf { unsigned short v1:1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu9i_Sf { unsigned short v1:1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu9ll_Sf { unsigned short v1:1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu1s_BFu9s_Sf { unsigned short v1:1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu1s_C_Sf { unsigned short v1:1; char v2; empty v3; };
struct __attribute__((packed)) aBFu1s_D_Sf { unsigned short v1:1; double v2; empty v3; };
struct __attribute__((packed)) aBFu1s_F_Sf { unsigned short v1:1; float v2; empty v3; };
struct __attribute__((packed)) aBFu1s_I_Sf { unsigned short v1:1; int v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Ip_Sf { unsigned short v1:1; int * v2; empty v3; };
struct __attribute__((packed)) aBFu1s_L_Sf { unsigned short v1:1; long long v2; empty v3; };
struct __attribute__((packed)) aBFu1s_S_Sf { unsigned short v1:1; short v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Sf { unsigned short v1:1; empty v2; };
struct __attribute__((packed)) aBFu1s_Sf_BFu15i { unsigned short v1:1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu1s_Sf_BFu15ll { unsigned short v1:1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu1s_Sf_BFu15s { unsigned short v1:1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu1s_Sf_BFu16i { unsigned short v1:1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu1s_Sf_BFu16ll { unsigned short v1:1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu1s_Sf_BFu16s { unsigned short v1:1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu1s_Sf_BFu17i { unsigned short v1:1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu1s_Sf_BFu17ll { unsigned short v1:1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu1s_Sf_BFu1c { unsigned short v1:1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu1s_Sf_BFu1i { unsigned short v1:1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu1s_Sf_BFu1ll { unsigned short v1:1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu1s_Sf_BFu1s { unsigned short v1:1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu1s_Sf_BFu31i { unsigned short v1:1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu1s_Sf_BFu31ll { unsigned short v1:1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu1s_Sf_BFu32i { unsigned short v1:1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu1s_Sf_BFu32ll { unsigned short v1:1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu1s_Sf_BFu33 { unsigned short v1:1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu1s_Sf_BFu7c { unsigned short v1:1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu1s_Sf_BFu7i { unsigned short v1:1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu1s_Sf_BFu7ll { unsigned short v1:1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu1s_Sf_BFu7s { unsigned short v1:1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu1s_Sf_BFu8c { unsigned short v1:1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu1s_Sf_BFu8i { unsigned short v1:1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu1s_Sf_BFu8ll { unsigned short v1:1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu1s_Sf_BFu8s { unsigned short v1:1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu1s_Sf_BFu9i { unsigned short v1:1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu1s_Sf_BFu9ll { unsigned short v1:1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu1s_Sf_BFu9s { unsigned short v1:1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu1s_Sf_C { unsigned short v1:1; empty v2; char v3; };
struct __attribute__((packed)) aBFu1s_Sf_D { unsigned short v1:1; empty v2; double v3; };
struct __attribute__((packed)) aBFu1s_Sf_F { unsigned short v1:1; empty v2; float v3; };
struct __attribute__((packed)) aBFu1s_Sf_I { unsigned short v1:1; empty v2; int v3; };
struct __attribute__((packed)) aBFu1s_Sf_Ip { unsigned short v1:1; empty v2; int * v3; };
struct __attribute__((packed)) aBFu1s_Sf_L { unsigned short v1:1; empty v2; long long v3; };
struct __attribute__((packed)) aBFu1s_Sf_S { unsigned short v1:1; empty v2; short v3; };
struct __attribute__((packed)) aBFu1s_Sf_Sf { unsigned short v1:1; empty v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Sf_Uc { unsigned short v1:1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu1s_Sf_Ui { unsigned short v1:1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu1s_Sf_Ul { unsigned short v1:1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu1s_Sf_Us { unsigned short v1:1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu1s_Sf_Vp { unsigned short v1:1; empty v2; void * v3; };
struct __attribute__((packed)) aBFu1s_Uc_Sf { unsigned short v1:1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Ui_Sf { unsigned short v1:1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Ul_Sf { unsigned short v1:1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Us_Sf { unsigned short v1:1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu1s_Vp_Sf { unsigned short v1:1; void * v2; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu15i_Sf { unsigned int v1:31; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu15ll_Sf { unsigned int v1:31; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu15s_Sf { unsigned int v1:31; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu16i_Sf { unsigned int v1:31; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu16ll_Sf { unsigned int v1:31; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu16s_Sf { unsigned int v1:31; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu17i_Sf { unsigned int v1:31; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu17ll_Sf { unsigned int v1:31; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu1c_Sf { unsigned int v1:31; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu1i_Sf { unsigned int v1:31; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu1ll_Sf { unsigned int v1:31; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu1s_Sf { unsigned int v1:31; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu31i_Sf { unsigned int v1:31; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu31ll_Sf { unsigned int v1:31; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu32i_Sf { unsigned int v1:31; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu32ll_Sf { unsigned int v1:31; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu33_Sf { unsigned int v1:31; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu7c_Sf { unsigned int v1:31; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu7i_Sf { unsigned int v1:31; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu7ll_Sf { unsigned int v1:31; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu7s_Sf { unsigned int v1:31; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu8c_Sf { unsigned int v1:31; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu8i_Sf { unsigned int v1:31; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu8ll_Sf { unsigned int v1:31; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu8s_Sf { unsigned int v1:31; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu9i_Sf { unsigned int v1:31; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu9ll_Sf { unsigned int v1:31; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu31i_BFu9s_Sf { unsigned int v1:31; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu31i_C_Sf { unsigned int v1:31; char v2; empty v3; };
struct __attribute__((packed)) aBFu31i_D_Sf { unsigned int v1:31; double v2; empty v3; };
struct __attribute__((packed)) aBFu31i_F_Sf { unsigned int v1:31; float v2; empty v3; };
struct __attribute__((packed)) aBFu31i_I_Sf { unsigned int v1:31; int v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Ip_Sf { unsigned int v1:31; int * v2; empty v3; };
struct __attribute__((packed)) aBFu31i_L_Sf { unsigned int v1:31; long long v2; empty v3; };
struct __attribute__((packed)) aBFu31i_S_Sf { unsigned int v1:31; short v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Sf { unsigned int v1:31; empty v2; };
struct __attribute__((packed)) aBFu31i_Sf_BFu15i { unsigned int v1:31; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu31i_Sf_BFu15ll { unsigned int v1:31; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu31i_Sf_BFu15s { unsigned int v1:31; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu31i_Sf_BFu16i { unsigned int v1:31; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu31i_Sf_BFu16ll { unsigned int v1:31; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu31i_Sf_BFu16s { unsigned int v1:31; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu31i_Sf_BFu17i { unsigned int v1:31; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu31i_Sf_BFu17ll { unsigned int v1:31; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu31i_Sf_BFu1c { unsigned int v1:31; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu31i_Sf_BFu1i { unsigned int v1:31; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu31i_Sf_BFu1ll { unsigned int v1:31; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu31i_Sf_BFu1s { unsigned int v1:31; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu31i_Sf_BFu31i { unsigned int v1:31; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu31i_Sf_BFu31ll { unsigned int v1:31; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu31i_Sf_BFu32i { unsigned int v1:31; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu31i_Sf_BFu32ll { unsigned int v1:31; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu31i_Sf_BFu33 { unsigned int v1:31; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu31i_Sf_BFu7c { unsigned int v1:31; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu31i_Sf_BFu7i { unsigned int v1:31; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu31i_Sf_BFu7ll { unsigned int v1:31; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu31i_Sf_BFu7s { unsigned int v1:31; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu31i_Sf_BFu8c { unsigned int v1:31; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu31i_Sf_BFu8i { unsigned int v1:31; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu31i_Sf_BFu8ll { unsigned int v1:31; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu31i_Sf_BFu8s { unsigned int v1:31; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu31i_Sf_BFu9i { unsigned int v1:31; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu31i_Sf_BFu9ll { unsigned int v1:31; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu31i_Sf_BFu9s { unsigned int v1:31; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu31i_Sf_C { unsigned int v1:31; empty v2; char v3; };
struct __attribute__((packed)) aBFu31i_Sf_D { unsigned int v1:31; empty v2; double v3; };
struct __attribute__((packed)) aBFu31i_Sf_F { unsigned int v1:31; empty v2; float v3; };
struct __attribute__((packed)) aBFu31i_Sf_I { unsigned int v1:31; empty v2; int v3; };
struct __attribute__((packed)) aBFu31i_Sf_Ip { unsigned int v1:31; empty v2; int * v3; };
struct __attribute__((packed)) aBFu31i_Sf_L { unsigned int v1:31; empty v2; long long v3; };
struct __attribute__((packed)) aBFu31i_Sf_S { unsigned int v1:31; empty v2; short v3; };
struct __attribute__((packed)) aBFu31i_Sf_Sf { unsigned int v1:31; empty v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Sf_Uc { unsigned int v1:31; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu31i_Sf_Ui { unsigned int v1:31; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu31i_Sf_Ul { unsigned int v1:31; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu31i_Sf_Us { unsigned int v1:31; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu31i_Sf_Vp { unsigned int v1:31; empty v2; void * v3; };
struct __attribute__((packed)) aBFu31i_Uc_Sf { unsigned int v1:31; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Ui_Sf { unsigned int v1:31; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Ul_Sf { unsigned int v1:31; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Us_Sf { unsigned int v1:31; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu31i_Vp_Sf { unsigned int v1:31; void * v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu15i_Sf { unsigned long long v1:31; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu15ll_Sf { unsigned long long v1:31; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu15s_Sf { unsigned long long v1:31; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu16i_Sf { unsigned long long v1:31; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu16ll_Sf { unsigned long long v1:31; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu16s_Sf { unsigned long long v1:31; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu17i_Sf { unsigned long long v1:31; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu17ll_Sf { unsigned long long v1:31; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu1c_Sf { unsigned long long v1:31; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu1i_Sf { unsigned long long v1:31; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu1ll_Sf { unsigned long long v1:31; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu1s_Sf { unsigned long long v1:31; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu31i_Sf { unsigned long long v1:31; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu31ll_Sf { unsigned long long v1:31; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu32i_Sf { unsigned long long v1:31; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu32ll_Sf { unsigned long long v1:31; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu33_Sf { unsigned long long v1:31; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu7c_Sf { unsigned long long v1:31; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu7i_Sf { unsigned long long v1:31; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu7ll_Sf { unsigned long long v1:31; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu7s_Sf { unsigned long long v1:31; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu8c_Sf { unsigned long long v1:31; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu8i_Sf { unsigned long long v1:31; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu8ll_Sf { unsigned long long v1:31; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu8s_Sf { unsigned long long v1:31; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu9i_Sf { unsigned long long v1:31; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu9ll_Sf { unsigned long long v1:31; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu31ll_BFu9s_Sf { unsigned long long v1:31; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu31ll_C_Sf { unsigned long long v1:31; char v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_D_Sf { unsigned long long v1:31; double v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_F_Sf { unsigned long long v1:31; float v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_I_Sf { unsigned long long v1:31; int v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Ip_Sf { unsigned long long v1:31; int * v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_L_Sf { unsigned long long v1:31; long long v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_S_Sf { unsigned long long v1:31; short v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Sf { unsigned long long v1:31; empty v2; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu15i { unsigned long long v1:31; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu15ll { unsigned long long v1:31; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu15s { unsigned long long v1:31; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu16i { unsigned long long v1:31; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu16ll { unsigned long long v1:31; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu16s { unsigned long long v1:31; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu17i { unsigned long long v1:31; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu17ll { unsigned long long v1:31; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu1c { unsigned long long v1:31; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu1i { unsigned long long v1:31; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu1ll { unsigned long long v1:31; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu1s { unsigned long long v1:31; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu31i { unsigned long long v1:31; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu31ll { unsigned long long v1:31; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu32i { unsigned long long v1:31; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu32ll { unsigned long long v1:31; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu33 { unsigned long long v1:31; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu7c { unsigned long long v1:31; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu7i { unsigned long long v1:31; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu7ll { unsigned long long v1:31; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu7s { unsigned long long v1:31; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu8c { unsigned long long v1:31; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu8i { unsigned long long v1:31; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu8ll { unsigned long long v1:31; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu8s { unsigned long long v1:31; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu9i { unsigned long long v1:31; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu9ll { unsigned long long v1:31; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu31ll_Sf_BFu9s { unsigned long long v1:31; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu31ll_Sf_C { unsigned long long v1:31; empty v2; char v3; };
struct __attribute__((packed)) aBFu31ll_Sf_D { unsigned long long v1:31; empty v2; double v3; };
struct __attribute__((packed)) aBFu31ll_Sf_F { unsigned long long v1:31; empty v2; float v3; };
struct __attribute__((packed)) aBFu31ll_Sf_I { unsigned long long v1:31; empty v2; int v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Ip { unsigned long long v1:31; empty v2; int * v3; };
struct __attribute__((packed)) aBFu31ll_Sf_L { unsigned long long v1:31; empty v2; long long v3; };
struct __attribute__((packed)) aBFu31ll_Sf_S { unsigned long long v1:31; empty v2; short v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Sf { unsigned long long v1:31; empty v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Uc { unsigned long long v1:31; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Ui { unsigned long long v1:31; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Ul { unsigned long long v1:31; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Us { unsigned long long v1:31; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu31ll_Sf_Vp { unsigned long long v1:31; empty v2; void * v3; };
struct __attribute__((packed)) aBFu31ll_Uc_Sf { unsigned long long v1:31; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Ui_Sf { unsigned long long v1:31; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Ul_Sf { unsigned long long v1:31; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Us_Sf { unsigned long long v1:31; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu31ll_Vp_Sf { unsigned long long v1:31; void * v2; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu15i_Sf { unsigned int v1:32; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu15ll_Sf { unsigned int v1:32; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu15s_Sf { unsigned int v1:32; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu16i_Sf { unsigned int v1:32; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu16ll_Sf { unsigned int v1:32; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu16s_Sf { unsigned int v1:32; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu17i_Sf { unsigned int v1:32; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu17ll_Sf { unsigned int v1:32; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu1c_Sf { unsigned int v1:32; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu1i_Sf { unsigned int v1:32; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu1ll_Sf { unsigned int v1:32; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu1s_Sf { unsigned int v1:32; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu31i_Sf { unsigned int v1:32; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu31ll_Sf { unsigned int v1:32; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu32i_Sf { unsigned int v1:32; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu32ll_Sf { unsigned int v1:32; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu33_Sf { unsigned int v1:32; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu7c_Sf { unsigned int v1:32; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu7i_Sf { unsigned int v1:32; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu7ll_Sf { unsigned int v1:32; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu7s_Sf { unsigned int v1:32; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu8c_Sf { unsigned int v1:32; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu8i_Sf { unsigned int v1:32; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu8ll_Sf { unsigned int v1:32; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu8s_Sf { unsigned int v1:32; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu9i_Sf { unsigned int v1:32; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu9ll_Sf { unsigned int v1:32; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu32i_BFu9s_Sf { unsigned int v1:32; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu32i_C_Sf { unsigned int v1:32; char v2; empty v3; };
struct __attribute__((packed)) aBFu32i_D_Sf { unsigned int v1:32; double v2; empty v3; };
struct __attribute__((packed)) aBFu32i_F_Sf { unsigned int v1:32; float v2; empty v3; };
struct __attribute__((packed)) aBFu32i_I_Sf { unsigned int v1:32; int v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Ip_Sf { unsigned int v1:32; int * v2; empty v3; };
struct __attribute__((packed)) aBFu32i_L_Sf { unsigned int v1:32; long long v2; empty v3; };
struct __attribute__((packed)) aBFu32i_S_Sf { unsigned int v1:32; short v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Sf { unsigned int v1:32; empty v2; };
struct __attribute__((packed)) aBFu32i_Sf_BFu15i { unsigned int v1:32; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu32i_Sf_BFu15ll { unsigned int v1:32; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu32i_Sf_BFu15s { unsigned int v1:32; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu32i_Sf_BFu16i { unsigned int v1:32; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu32i_Sf_BFu16ll { unsigned int v1:32; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu32i_Sf_BFu16s { unsigned int v1:32; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu32i_Sf_BFu17i { unsigned int v1:32; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu32i_Sf_BFu17ll { unsigned int v1:32; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu32i_Sf_BFu1c { unsigned int v1:32; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu32i_Sf_BFu1i { unsigned int v1:32; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu32i_Sf_BFu1ll { unsigned int v1:32; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu32i_Sf_BFu1s { unsigned int v1:32; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu32i_Sf_BFu31i { unsigned int v1:32; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu32i_Sf_BFu31ll { unsigned int v1:32; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu32i_Sf_BFu32i { unsigned int v1:32; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu32i_Sf_BFu32ll { unsigned int v1:32; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu32i_Sf_BFu33 { unsigned int v1:32; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu32i_Sf_BFu7c { unsigned int v1:32; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu32i_Sf_BFu7i { unsigned int v1:32; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu32i_Sf_BFu7ll { unsigned int v1:32; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu32i_Sf_BFu7s { unsigned int v1:32; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu32i_Sf_BFu8c { unsigned int v1:32; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu32i_Sf_BFu8i { unsigned int v1:32; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu32i_Sf_BFu8ll { unsigned int v1:32; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu32i_Sf_BFu8s { unsigned int v1:32; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu32i_Sf_BFu9i { unsigned int v1:32; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu32i_Sf_BFu9ll { unsigned int v1:32; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu32i_Sf_BFu9s { unsigned int v1:32; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu32i_Sf_C { unsigned int v1:32; empty v2; char v3; };
struct __attribute__((packed)) aBFu32i_Sf_D { unsigned int v1:32; empty v2; double v3; };
struct __attribute__((packed)) aBFu32i_Sf_F { unsigned int v1:32; empty v2; float v3; };
struct __attribute__((packed)) aBFu32i_Sf_I { unsigned int v1:32; empty v2; int v3; };
struct __attribute__((packed)) aBFu32i_Sf_Ip { unsigned int v1:32; empty v2; int * v3; };
struct __attribute__((packed)) aBFu32i_Sf_L { unsigned int v1:32; empty v2; long long v3; };
struct __attribute__((packed)) aBFu32i_Sf_S { unsigned int v1:32; empty v2; short v3; };
struct __attribute__((packed)) aBFu32i_Sf_Sf { unsigned int v1:32; empty v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Sf_Uc { unsigned int v1:32; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu32i_Sf_Ui { unsigned int v1:32; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu32i_Sf_Ul { unsigned int v1:32; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu32i_Sf_Us { unsigned int v1:32; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu32i_Sf_Vp { unsigned int v1:32; empty v2; void * v3; };
struct __attribute__((packed)) aBFu32i_Uc_Sf { unsigned int v1:32; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Ui_Sf { unsigned int v1:32; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Ul_Sf { unsigned int v1:32; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Us_Sf { unsigned int v1:32; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu32i_Vp_Sf { unsigned int v1:32; void * v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu15i_Sf { unsigned long long v1:32; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu15ll_Sf { unsigned long long v1:32; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu15s_Sf { unsigned long long v1:32; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu16i_Sf { unsigned long long v1:32; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu16ll_Sf { unsigned long long v1:32; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu16s_Sf { unsigned long long v1:32; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu17i_Sf { unsigned long long v1:32; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu17ll_Sf { unsigned long long v1:32; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu1c_Sf { unsigned long long v1:32; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu1i_Sf { unsigned long long v1:32; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu1ll_Sf { unsigned long long v1:32; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu1s_Sf { unsigned long long v1:32; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu31i_Sf { unsigned long long v1:32; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu31ll_Sf { unsigned long long v1:32; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu32i_Sf { unsigned long long v1:32; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu32ll_Sf { unsigned long long v1:32; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu33_Sf { unsigned long long v1:32; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu7c_Sf { unsigned long long v1:32; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu7i_Sf { unsigned long long v1:32; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu7ll_Sf { unsigned long long v1:32; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu7s_Sf { unsigned long long v1:32; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu8c_Sf { unsigned long long v1:32; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu8i_Sf { unsigned long long v1:32; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu8ll_Sf { unsigned long long v1:32; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu8s_Sf { unsigned long long v1:32; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu9i_Sf { unsigned long long v1:32; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu9ll_Sf { unsigned long long v1:32; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu32ll_BFu9s_Sf { unsigned long long v1:32; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu32ll_C_Sf { unsigned long long v1:32; char v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_D_Sf { unsigned long long v1:32; double v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_F_Sf { unsigned long long v1:32; float v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_I_Sf { unsigned long long v1:32; int v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Ip_Sf { unsigned long long v1:32; int * v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_L_Sf { unsigned long long v1:32; long long v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_S_Sf { unsigned long long v1:32; short v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Sf { unsigned long long v1:32; empty v2; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu15i { unsigned long long v1:32; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu15ll { unsigned long long v1:32; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu15s { unsigned long long v1:32; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu16i { unsigned long long v1:32; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu16ll { unsigned long long v1:32; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu16s { unsigned long long v1:32; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu17i { unsigned long long v1:32; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu17ll { unsigned long long v1:32; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu1c { unsigned long long v1:32; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu1i { unsigned long long v1:32; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu1ll { unsigned long long v1:32; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu1s { unsigned long long v1:32; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu31i { unsigned long long v1:32; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu31ll { unsigned long long v1:32; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu32i { unsigned long long v1:32; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu32ll { unsigned long long v1:32; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu33 { unsigned long long v1:32; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu7c { unsigned long long v1:32; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu7i { unsigned long long v1:32; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu7ll { unsigned long long v1:32; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu7s { unsigned long long v1:32; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu8c { unsigned long long v1:32; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu8i { unsigned long long v1:32; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu8ll { unsigned long long v1:32; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu8s { unsigned long long v1:32; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu9i { unsigned long long v1:32; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu9ll { unsigned long long v1:32; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu32ll_Sf_BFu9s { unsigned long long v1:32; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu32ll_Sf_C { unsigned long long v1:32; empty v2; char v3; };
struct __attribute__((packed)) aBFu32ll_Sf_D { unsigned long long v1:32; empty v2; double v3; };
struct __attribute__((packed)) aBFu32ll_Sf_F { unsigned long long v1:32; empty v2; float v3; };
struct __attribute__((packed)) aBFu32ll_Sf_I { unsigned long long v1:32; empty v2; int v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Ip { unsigned long long v1:32; empty v2; int * v3; };
struct __attribute__((packed)) aBFu32ll_Sf_L { unsigned long long v1:32; empty v2; long long v3; };
struct __attribute__((packed)) aBFu32ll_Sf_S { unsigned long long v1:32; empty v2; short v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Sf { unsigned long long v1:32; empty v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Uc { unsigned long long v1:32; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Ui { unsigned long long v1:32; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Ul { unsigned long long v1:32; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Us { unsigned long long v1:32; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu32ll_Sf_Vp { unsigned long long v1:32; empty v2; void * v3; };
struct __attribute__((packed)) aBFu32ll_Uc_Sf { unsigned long long v1:32; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Ui_Sf { unsigned long long v1:32; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Ul_Sf { unsigned long long v1:32; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Us_Sf { unsigned long long v1:32; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu32ll_Vp_Sf { unsigned long long v1:32; void * v2; empty v3; };
struct __attribute__((packed)) aBFu33_BFu15i_Sf { unsigned long long v1:33; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu33_BFu15ll_Sf { unsigned long long v1:33; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu33_BFu15s_Sf { unsigned long long v1:33; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu33_BFu16i_Sf { unsigned long long v1:33; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu33_BFu16ll_Sf { unsigned long long v1:33; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu33_BFu16s_Sf { unsigned long long v1:33; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu33_BFu17i_Sf { unsigned long long v1:33; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu33_BFu17ll_Sf { unsigned long long v1:33; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu33_BFu1c_Sf { unsigned long long v1:33; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu33_BFu1i_Sf { unsigned long long v1:33; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu33_BFu1ll_Sf { unsigned long long v1:33; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu33_BFu1s_Sf { unsigned long long v1:33; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu33_BFu31i_Sf { unsigned long long v1:33; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu33_BFu31ll_Sf { unsigned long long v1:33; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu33_BFu32i_Sf { unsigned long long v1:33; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu33_BFu32ll_Sf { unsigned long long v1:33; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu33_BFu33_Sf { unsigned long long v1:33; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu33_BFu7c_Sf { unsigned long long v1:33; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu33_BFu7i_Sf { unsigned long long v1:33; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu33_BFu7ll_Sf { unsigned long long v1:33; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu33_BFu7s_Sf { unsigned long long v1:33; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu33_BFu8c_Sf { unsigned long long v1:33; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu33_BFu8i_Sf { unsigned long long v1:33; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu33_BFu8ll_Sf { unsigned long long v1:33; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu33_BFu8s_Sf { unsigned long long v1:33; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu33_BFu9i_Sf { unsigned long long v1:33; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu33_BFu9ll_Sf { unsigned long long v1:33; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu33_BFu9s_Sf { unsigned long long v1:33; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu33_C_Sf { unsigned long long v1:33; char v2; empty v3; };
struct __attribute__((packed)) aBFu33_D_Sf { unsigned long long v1:33; double v2; empty v3; };
struct __attribute__((packed)) aBFu33_F_Sf { unsigned long long v1:33; float v2; empty v3; };
struct __attribute__((packed)) aBFu33_I_Sf { unsigned long long v1:33; int v2; empty v3; };
struct __attribute__((packed)) aBFu33_Ip_Sf { unsigned long long v1:33; int * v2; empty v3; };
struct __attribute__((packed)) aBFu33_L_Sf { unsigned long long v1:33; long long v2; empty v3; };
struct __attribute__((packed)) aBFu33_S_Sf { unsigned long long v1:33; short v2; empty v3; };
struct __attribute__((packed)) aBFu33_Sf { unsigned long long v1:33; empty v2; };
struct __attribute__((packed)) aBFu33_Sf_BFu15i { unsigned long long v1:33; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu33_Sf_BFu15ll { unsigned long long v1:33; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu33_Sf_BFu15s { unsigned long long v1:33; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu33_Sf_BFu16i { unsigned long long v1:33; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu33_Sf_BFu16ll { unsigned long long v1:33; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu33_Sf_BFu16s { unsigned long long v1:33; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu33_Sf_BFu17i { unsigned long long v1:33; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu33_Sf_BFu17ll { unsigned long long v1:33; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu33_Sf_BFu1c { unsigned long long v1:33; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu33_Sf_BFu1i { unsigned long long v1:33; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu33_Sf_BFu1ll { unsigned long long v1:33; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu33_Sf_BFu1s { unsigned long long v1:33; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu33_Sf_BFu31i { unsigned long long v1:33; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu33_Sf_BFu31ll { unsigned long long v1:33; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu33_Sf_BFu32i { unsigned long long v1:33; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu33_Sf_BFu32ll { unsigned long long v1:33; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu33_Sf_BFu33 { unsigned long long v1:33; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu33_Sf_BFu7c { unsigned long long v1:33; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu33_Sf_BFu7i { unsigned long long v1:33; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu33_Sf_BFu7ll { unsigned long long v1:33; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu33_Sf_BFu7s { unsigned long long v1:33; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu33_Sf_BFu8c { unsigned long long v1:33; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu33_Sf_BFu8i { unsigned long long v1:33; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu33_Sf_BFu8ll { unsigned long long v1:33; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu33_Sf_BFu8s { unsigned long long v1:33; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu33_Sf_BFu9i { unsigned long long v1:33; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu33_Sf_BFu9ll { unsigned long long v1:33; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu33_Sf_BFu9s { unsigned long long v1:33; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu33_Sf_C { unsigned long long v1:33; empty v2; char v3; };
struct __attribute__((packed)) aBFu33_Sf_D { unsigned long long v1:33; empty v2; double v3; };
struct __attribute__((packed)) aBFu33_Sf_F { unsigned long long v1:33; empty v2; float v3; };
struct __attribute__((packed)) aBFu33_Sf_I { unsigned long long v1:33; empty v2; int v3; };
struct __attribute__((packed)) aBFu33_Sf_Ip { unsigned long long v1:33; empty v2; int * v3; };
struct __attribute__((packed)) aBFu33_Sf_L { unsigned long long v1:33; empty v2; long long v3; };
struct __attribute__((packed)) aBFu33_Sf_S { unsigned long long v1:33; empty v2; short v3; };
struct __attribute__((packed)) aBFu33_Sf_Sf { unsigned long long v1:33; empty v2; empty v3; };
struct __attribute__((packed)) aBFu33_Sf_Uc { unsigned long long v1:33; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu33_Sf_Ui { unsigned long long v1:33; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu33_Sf_Ul { unsigned long long v1:33; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu33_Sf_Us { unsigned long long v1:33; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu33_Sf_Vp { unsigned long long v1:33; empty v2; void * v3; };
struct __attribute__((packed)) aBFu33_Uc_Sf { unsigned long long v1:33; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu33_Ui_Sf { unsigned long long v1:33; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu33_Ul_Sf { unsigned long long v1:33; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu33_Us_Sf { unsigned long long v1:33; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu33_Vp_Sf { unsigned long long v1:33; void * v2; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu15i_Sf { unsigned char v1:7; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu15ll_Sf { unsigned char v1:7; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu15s_Sf { unsigned char v1:7; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu16i_Sf { unsigned char v1:7; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu16ll_Sf { unsigned char v1:7; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu16s_Sf { unsigned char v1:7; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu17i_Sf { unsigned char v1:7; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu17ll_Sf { unsigned char v1:7; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu1c_Sf { unsigned char v1:7; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu1i_Sf { unsigned char v1:7; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu1ll_Sf { unsigned char v1:7; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu1s_Sf { unsigned char v1:7; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu31i_Sf { unsigned char v1:7; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu31ll_Sf { unsigned char v1:7; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu32i_Sf { unsigned char v1:7; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu32ll_Sf { unsigned char v1:7; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu33_Sf { unsigned char v1:7; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu7c_Sf { unsigned char v1:7; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu7i_Sf { unsigned char v1:7; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu7ll_Sf { unsigned char v1:7; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu7s_Sf { unsigned char v1:7; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu8c_Sf { unsigned char v1:7; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu8i_Sf { unsigned char v1:7; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu8ll_Sf { unsigned char v1:7; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu8s_Sf { unsigned char v1:7; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu9i_Sf { unsigned char v1:7; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu9ll_Sf { unsigned char v1:7; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu7c_BFu9s_Sf { unsigned char v1:7; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu7c_C_Sf { unsigned char v1:7; char v2; empty v3; };
struct __attribute__((packed)) aBFu7c_D_Sf { unsigned char v1:7; double v2; empty v3; };
struct __attribute__((packed)) aBFu7c_F_Sf { unsigned char v1:7; float v2; empty v3; };
struct __attribute__((packed)) aBFu7c_I_Sf { unsigned char v1:7; int v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Ip_Sf { unsigned char v1:7; int * v2; empty v3; };
struct __attribute__((packed)) aBFu7c_L_Sf { unsigned char v1:7; long long v2; empty v3; };
struct __attribute__((packed)) aBFu7c_S_Sf { unsigned char v1:7; short v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Sf { unsigned char v1:7; empty v2; };
struct __attribute__((packed)) aBFu7c_Sf_BFu15i { unsigned char v1:7; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7c_Sf_BFu15ll { unsigned char v1:7; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7c_Sf_BFu15s { unsigned char v1:7; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7c_Sf_BFu16i { unsigned char v1:7; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7c_Sf_BFu16ll { unsigned char v1:7; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7c_Sf_BFu16s { unsigned char v1:7; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7c_Sf_BFu17i { unsigned char v1:7; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7c_Sf_BFu17ll { unsigned char v1:7; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7c_Sf_BFu1c { unsigned char v1:7; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7c_Sf_BFu1i { unsigned char v1:7; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7c_Sf_BFu1ll { unsigned char v1:7; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7c_Sf_BFu1s { unsigned char v1:7; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7c_Sf_BFu31i { unsigned char v1:7; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7c_Sf_BFu31ll { unsigned char v1:7; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7c_Sf_BFu32i { unsigned char v1:7; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7c_Sf_BFu32ll { unsigned char v1:7; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7c_Sf_BFu33 { unsigned char v1:7; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7c_Sf_BFu7c { unsigned char v1:7; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7c_Sf_BFu7i { unsigned char v1:7; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7c_Sf_BFu7ll { unsigned char v1:7; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7c_Sf_BFu7s { unsigned char v1:7; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7c_Sf_BFu8c { unsigned char v1:7; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7c_Sf_BFu8i { unsigned char v1:7; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7c_Sf_BFu8ll { unsigned char v1:7; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7c_Sf_BFu8s { unsigned char v1:7; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7c_Sf_BFu9i { unsigned char v1:7; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7c_Sf_BFu9ll { unsigned char v1:7; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7c_Sf_BFu9s { unsigned char v1:7; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7c_Sf_C { unsigned char v1:7; empty v2; char v3; };
struct __attribute__((packed)) aBFu7c_Sf_D { unsigned char v1:7; empty v2; double v3; };
struct __attribute__((packed)) aBFu7c_Sf_F { unsigned char v1:7; empty v2; float v3; };
struct __attribute__((packed)) aBFu7c_Sf_I { unsigned char v1:7; empty v2; int v3; };
struct __attribute__((packed)) aBFu7c_Sf_Ip { unsigned char v1:7; empty v2; int * v3; };
struct __attribute__((packed)) aBFu7c_Sf_L { unsigned char v1:7; empty v2; long long v3; };
struct __attribute__((packed)) aBFu7c_Sf_S { unsigned char v1:7; empty v2; short v3; };
struct __attribute__((packed)) aBFu7c_Sf_Sf { unsigned char v1:7; empty v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Sf_Uc { unsigned char v1:7; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7c_Sf_Ui { unsigned char v1:7; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7c_Sf_Ul { unsigned char v1:7; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7c_Sf_Us { unsigned char v1:7; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7c_Sf_Vp { unsigned char v1:7; empty v2; void * v3; };
struct __attribute__((packed)) aBFu7c_Uc_Sf { unsigned char v1:7; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Ui_Sf { unsigned char v1:7; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Ul_Sf { unsigned char v1:7; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Us_Sf { unsigned char v1:7; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu7c_Vp_Sf { unsigned char v1:7; void * v2; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu15i_Sf { unsigned int v1:7; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu15ll_Sf { unsigned int v1:7; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu15s_Sf { unsigned int v1:7; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu16i_Sf { unsigned int v1:7; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu16ll_Sf { unsigned int v1:7; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu16s_Sf { unsigned int v1:7; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu17i_Sf { unsigned int v1:7; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu17ll_Sf { unsigned int v1:7; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu1c_Sf { unsigned int v1:7; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu1i_Sf { unsigned int v1:7; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu1ll_Sf { unsigned int v1:7; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu1s_Sf { unsigned int v1:7; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu31i_Sf { unsigned int v1:7; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu31ll_Sf { unsigned int v1:7; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu32i_Sf { unsigned int v1:7; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu32ll_Sf { unsigned int v1:7; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu33_Sf { unsigned int v1:7; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu7c_Sf { unsigned int v1:7; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu7i_Sf { unsigned int v1:7; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu7ll_Sf { unsigned int v1:7; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu7s_Sf { unsigned int v1:7; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu8c_Sf { unsigned int v1:7; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu8i_Sf { unsigned int v1:7; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu8ll_Sf { unsigned int v1:7; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu8s_Sf { unsigned int v1:7; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu9i_Sf { unsigned int v1:7; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu9ll_Sf { unsigned int v1:7; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu7i_BFu9s_Sf { unsigned int v1:7; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu7i_C_Sf { unsigned int v1:7; char v2; empty v3; };
struct __attribute__((packed)) aBFu7i_D_Sf { unsigned int v1:7; double v2; empty v3; };
struct __attribute__((packed)) aBFu7i_F_Sf { unsigned int v1:7; float v2; empty v3; };
struct __attribute__((packed)) aBFu7i_I_Sf { unsigned int v1:7; int v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Ip_Sf { unsigned int v1:7; int * v2; empty v3; };
struct __attribute__((packed)) aBFu7i_L_Sf { unsigned int v1:7; long long v2; empty v3; };
struct __attribute__((packed)) aBFu7i_S_Sf { unsigned int v1:7; short v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Sf { unsigned int v1:7; empty v2; };
struct __attribute__((packed)) aBFu7i_Sf_BFu15i { unsigned int v1:7; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7i_Sf_BFu15ll { unsigned int v1:7; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7i_Sf_BFu15s { unsigned int v1:7; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7i_Sf_BFu16i { unsigned int v1:7; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7i_Sf_BFu16ll { unsigned int v1:7; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7i_Sf_BFu16s { unsigned int v1:7; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7i_Sf_BFu17i { unsigned int v1:7; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7i_Sf_BFu17ll { unsigned int v1:7; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7i_Sf_BFu1c { unsigned int v1:7; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7i_Sf_BFu1i { unsigned int v1:7; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7i_Sf_BFu1ll { unsigned int v1:7; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7i_Sf_BFu1s { unsigned int v1:7; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7i_Sf_BFu31i { unsigned int v1:7; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7i_Sf_BFu31ll { unsigned int v1:7; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7i_Sf_BFu32i { unsigned int v1:7; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7i_Sf_BFu32ll { unsigned int v1:7; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7i_Sf_BFu33 { unsigned int v1:7; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7i_Sf_BFu7c { unsigned int v1:7; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7i_Sf_BFu7i { unsigned int v1:7; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7i_Sf_BFu7ll { unsigned int v1:7; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7i_Sf_BFu7s { unsigned int v1:7; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7i_Sf_BFu8c { unsigned int v1:7; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7i_Sf_BFu8i { unsigned int v1:7; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7i_Sf_BFu8ll { unsigned int v1:7; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7i_Sf_BFu8s { unsigned int v1:7; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7i_Sf_BFu9i { unsigned int v1:7; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7i_Sf_BFu9ll { unsigned int v1:7; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7i_Sf_BFu9s { unsigned int v1:7; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7i_Sf_C { unsigned int v1:7; empty v2; char v3; };
struct __attribute__((packed)) aBFu7i_Sf_D { unsigned int v1:7; empty v2; double v3; };
struct __attribute__((packed)) aBFu7i_Sf_F { unsigned int v1:7; empty v2; float v3; };
struct __attribute__((packed)) aBFu7i_Sf_I { unsigned int v1:7; empty v2; int v3; };
struct __attribute__((packed)) aBFu7i_Sf_Ip { unsigned int v1:7; empty v2; int * v3; };
struct __attribute__((packed)) aBFu7i_Sf_L { unsigned int v1:7; empty v2; long long v3; };
struct __attribute__((packed)) aBFu7i_Sf_S { unsigned int v1:7; empty v2; short v3; };
struct __attribute__((packed)) aBFu7i_Sf_Sf { unsigned int v1:7; empty v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Sf_Uc { unsigned int v1:7; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7i_Sf_Ui { unsigned int v1:7; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7i_Sf_Ul { unsigned int v1:7; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7i_Sf_Us { unsigned int v1:7; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7i_Sf_Vp { unsigned int v1:7; empty v2; void * v3; };
struct __attribute__((packed)) aBFu7i_Uc_Sf { unsigned int v1:7; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Ui_Sf { unsigned int v1:7; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Ul_Sf { unsigned int v1:7; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Us_Sf { unsigned int v1:7; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu7i_Vp_Sf { unsigned int v1:7; void * v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu15i_Sf { unsigned long long v1:7; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu15ll_Sf { unsigned long long v1:7; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu15s_Sf { unsigned long long v1:7; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu16i_Sf { unsigned long long v1:7; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu16ll_Sf { unsigned long long v1:7; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu16s_Sf { unsigned long long v1:7; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu17i_Sf { unsigned long long v1:7; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu17ll_Sf { unsigned long long v1:7; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu1c_Sf { unsigned long long v1:7; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu1i_Sf { unsigned long long v1:7; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu1ll_Sf { unsigned long long v1:7; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu1s_Sf { unsigned long long v1:7; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu31i_Sf { unsigned long long v1:7; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu31ll_Sf { unsigned long long v1:7; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu32i_Sf { unsigned long long v1:7; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu32ll_Sf { unsigned long long v1:7; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu33_Sf { unsigned long long v1:7; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu7c_Sf { unsigned long long v1:7; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu7i_Sf { unsigned long long v1:7; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu7ll_Sf { unsigned long long v1:7; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu7s_Sf { unsigned long long v1:7; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu8c_Sf { unsigned long long v1:7; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu8i_Sf { unsigned long long v1:7; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu8ll_Sf { unsigned long long v1:7; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu8s_Sf { unsigned long long v1:7; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu9i_Sf { unsigned long long v1:7; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu9ll_Sf { unsigned long long v1:7; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu7ll_BFu9s_Sf { unsigned long long v1:7; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu7ll_C_Sf { unsigned long long v1:7; char v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_D_Sf { unsigned long long v1:7; double v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_F_Sf { unsigned long long v1:7; float v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_I_Sf { unsigned long long v1:7; int v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Ip_Sf { unsigned long long v1:7; int * v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_L_Sf { unsigned long long v1:7; long long v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_S_Sf { unsigned long long v1:7; short v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Sf { unsigned long long v1:7; empty v2; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu15i { unsigned long long v1:7; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu15ll { unsigned long long v1:7; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu15s { unsigned long long v1:7; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu16i { unsigned long long v1:7; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu16ll { unsigned long long v1:7; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu16s { unsigned long long v1:7; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu17i { unsigned long long v1:7; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu17ll { unsigned long long v1:7; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu1c { unsigned long long v1:7; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu1i { unsigned long long v1:7; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu1ll { unsigned long long v1:7; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu1s { unsigned long long v1:7; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu31i { unsigned long long v1:7; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu31ll { unsigned long long v1:7; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu32i { unsigned long long v1:7; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu32ll { unsigned long long v1:7; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu33 { unsigned long long v1:7; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu7c { unsigned long long v1:7; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu7i { unsigned long long v1:7; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu7ll { unsigned long long v1:7; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu7s { unsigned long long v1:7; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu8c { unsigned long long v1:7; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu8i { unsigned long long v1:7; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu8ll { unsigned long long v1:7; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu8s { unsigned long long v1:7; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu9i { unsigned long long v1:7; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu9ll { unsigned long long v1:7; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7ll_Sf_BFu9s { unsigned long long v1:7; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7ll_Sf_C { unsigned long long v1:7; empty v2; char v3; };
struct __attribute__((packed)) aBFu7ll_Sf_D { unsigned long long v1:7; empty v2; double v3; };
struct __attribute__((packed)) aBFu7ll_Sf_F { unsigned long long v1:7; empty v2; float v3; };
struct __attribute__((packed)) aBFu7ll_Sf_I { unsigned long long v1:7; empty v2; int v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Ip { unsigned long long v1:7; empty v2; int * v3; };
struct __attribute__((packed)) aBFu7ll_Sf_L { unsigned long long v1:7; empty v2; long long v3; };
struct __attribute__((packed)) aBFu7ll_Sf_S { unsigned long long v1:7; empty v2; short v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Sf { unsigned long long v1:7; empty v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Uc { unsigned long long v1:7; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Ui { unsigned long long v1:7; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Ul { unsigned long long v1:7; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Us { unsigned long long v1:7; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7ll_Sf_Vp { unsigned long long v1:7; empty v2; void * v3; };
struct __attribute__((packed)) aBFu7ll_Uc_Sf { unsigned long long v1:7; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Ui_Sf { unsigned long long v1:7; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Ul_Sf { unsigned long long v1:7; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Us_Sf { unsigned long long v1:7; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu7ll_Vp_Sf { unsigned long long v1:7; void * v2; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu15i_Sf { unsigned short v1:7; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu15ll_Sf { unsigned short v1:7; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu15s_Sf { unsigned short v1:7; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu16i_Sf { unsigned short v1:7; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu16ll_Sf { unsigned short v1:7; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu16s_Sf { unsigned short v1:7; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu17i_Sf { unsigned short v1:7; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu17ll_Sf { unsigned short v1:7; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu1c_Sf { unsigned short v1:7; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu1i_Sf { unsigned short v1:7; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu1ll_Sf { unsigned short v1:7; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu1s_Sf { unsigned short v1:7; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu31i_Sf { unsigned short v1:7; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu31ll_Sf { unsigned short v1:7; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu32i_Sf { unsigned short v1:7; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu32ll_Sf { unsigned short v1:7; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu33_Sf { unsigned short v1:7; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu7c_Sf { unsigned short v1:7; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu7i_Sf { unsigned short v1:7; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu7ll_Sf { unsigned short v1:7; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu7s_Sf { unsigned short v1:7; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu8c_Sf { unsigned short v1:7; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu8i_Sf { unsigned short v1:7; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu8ll_Sf { unsigned short v1:7; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu8s_Sf { unsigned short v1:7; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu9i_Sf { unsigned short v1:7; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu9ll_Sf { unsigned short v1:7; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu7s_BFu9s_Sf { unsigned short v1:7; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu7s_C_Sf { unsigned short v1:7; char v2; empty v3; };
struct __attribute__((packed)) aBFu7s_D_Sf { unsigned short v1:7; double v2; empty v3; };
struct __attribute__((packed)) aBFu7s_F_Sf { unsigned short v1:7; float v2; empty v3; };
struct __attribute__((packed)) aBFu7s_I_Sf { unsigned short v1:7; int v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Ip_Sf { unsigned short v1:7; int * v2; empty v3; };
struct __attribute__((packed)) aBFu7s_L_Sf { unsigned short v1:7; long long v2; empty v3; };
struct __attribute__((packed)) aBFu7s_S_Sf { unsigned short v1:7; short v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Sf { unsigned short v1:7; empty v2; };
struct __attribute__((packed)) aBFu7s_Sf_BFu15i { unsigned short v1:7; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu7s_Sf_BFu15ll { unsigned short v1:7; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu7s_Sf_BFu15s { unsigned short v1:7; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu7s_Sf_BFu16i { unsigned short v1:7; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu7s_Sf_BFu16ll { unsigned short v1:7; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu7s_Sf_BFu16s { unsigned short v1:7; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu7s_Sf_BFu17i { unsigned short v1:7; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu7s_Sf_BFu17ll { unsigned short v1:7; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu7s_Sf_BFu1c { unsigned short v1:7; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu7s_Sf_BFu1i { unsigned short v1:7; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu7s_Sf_BFu1ll { unsigned short v1:7; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu7s_Sf_BFu1s { unsigned short v1:7; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu7s_Sf_BFu31i { unsigned short v1:7; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu7s_Sf_BFu31ll { unsigned short v1:7; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu7s_Sf_BFu32i { unsigned short v1:7; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu7s_Sf_BFu32ll { unsigned short v1:7; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu7s_Sf_BFu33 { unsigned short v1:7; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu7s_Sf_BFu7c { unsigned short v1:7; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu7s_Sf_BFu7i { unsigned short v1:7; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu7s_Sf_BFu7ll { unsigned short v1:7; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu7s_Sf_BFu7s { unsigned short v1:7; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu7s_Sf_BFu8c { unsigned short v1:7; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu7s_Sf_BFu8i { unsigned short v1:7; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu7s_Sf_BFu8ll { unsigned short v1:7; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu7s_Sf_BFu8s { unsigned short v1:7; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu7s_Sf_BFu9i { unsigned short v1:7; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu7s_Sf_BFu9ll { unsigned short v1:7; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu7s_Sf_BFu9s { unsigned short v1:7; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu7s_Sf_C { unsigned short v1:7; empty v2; char v3; };
struct __attribute__((packed)) aBFu7s_Sf_D { unsigned short v1:7; empty v2; double v3; };
struct __attribute__((packed)) aBFu7s_Sf_F { unsigned short v1:7; empty v2; float v3; };
struct __attribute__((packed)) aBFu7s_Sf_I { unsigned short v1:7; empty v2; int v3; };
struct __attribute__((packed)) aBFu7s_Sf_Ip { unsigned short v1:7; empty v2; int * v3; };
struct __attribute__((packed)) aBFu7s_Sf_L { unsigned short v1:7; empty v2; long long v3; };
struct __attribute__((packed)) aBFu7s_Sf_S { unsigned short v1:7; empty v2; short v3; };
struct __attribute__((packed)) aBFu7s_Sf_Sf { unsigned short v1:7; empty v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Sf_Uc { unsigned short v1:7; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu7s_Sf_Ui { unsigned short v1:7; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu7s_Sf_Ul { unsigned short v1:7; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu7s_Sf_Us { unsigned short v1:7; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu7s_Sf_Vp { unsigned short v1:7; empty v2; void * v3; };
struct __attribute__((packed)) aBFu7s_Uc_Sf { unsigned short v1:7; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Ui_Sf { unsigned short v1:7; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Ul_Sf { unsigned short v1:7; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Us_Sf { unsigned short v1:7; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu7s_Vp_Sf { unsigned short v1:7; void * v2; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu15i_Sf { unsigned char v1:8; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu15ll_Sf { unsigned char v1:8; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu15s_Sf { unsigned char v1:8; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu16i_Sf { unsigned char v1:8; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu16ll_Sf { unsigned char v1:8; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu16s_Sf { unsigned char v1:8; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu17i_Sf { unsigned char v1:8; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu17ll_Sf { unsigned char v1:8; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu1c_Sf { unsigned char v1:8; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu1i_Sf { unsigned char v1:8; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu1ll_Sf { unsigned char v1:8; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu1s_Sf { unsigned char v1:8; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu31i_Sf { unsigned char v1:8; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu31ll_Sf { unsigned char v1:8; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu32i_Sf { unsigned char v1:8; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu32ll_Sf { unsigned char v1:8; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu33_Sf { unsigned char v1:8; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu7c_Sf { unsigned char v1:8; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu7i_Sf { unsigned char v1:8; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu7ll_Sf { unsigned char v1:8; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu7s_Sf { unsigned char v1:8; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu8c_Sf { unsigned char v1:8; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu8i_Sf { unsigned char v1:8; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu8ll_Sf { unsigned char v1:8; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu8s_Sf { unsigned char v1:8; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu9i_Sf { unsigned char v1:8; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu9ll_Sf { unsigned char v1:8; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu8c_BFu9s_Sf { unsigned char v1:8; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu8c_C_Sf { unsigned char v1:8; char v2; empty v3; };
struct __attribute__((packed)) aBFu8c_D_Sf { unsigned char v1:8; double v2; empty v3; };
struct __attribute__((packed)) aBFu8c_F_Sf { unsigned char v1:8; float v2; empty v3; };
struct __attribute__((packed)) aBFu8c_I_Sf { unsigned char v1:8; int v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Ip_Sf { unsigned char v1:8; int * v2; empty v3; };
struct __attribute__((packed)) aBFu8c_L_Sf { unsigned char v1:8; long long v2; empty v3; };
struct __attribute__((packed)) aBFu8c_S_Sf { unsigned char v1:8; short v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Sf { unsigned char v1:8; empty v2; };
struct __attribute__((packed)) aBFu8c_Sf_BFu15i { unsigned char v1:8; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8c_Sf_BFu15ll { unsigned char v1:8; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8c_Sf_BFu15s { unsigned char v1:8; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8c_Sf_BFu16i { unsigned char v1:8; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8c_Sf_BFu16ll { unsigned char v1:8; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8c_Sf_BFu16s { unsigned char v1:8; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8c_Sf_BFu17i { unsigned char v1:8; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8c_Sf_BFu17ll { unsigned char v1:8; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8c_Sf_BFu1c { unsigned char v1:8; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8c_Sf_BFu1i { unsigned char v1:8; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8c_Sf_BFu1ll { unsigned char v1:8; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8c_Sf_BFu1s { unsigned char v1:8; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8c_Sf_BFu31i { unsigned char v1:8; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8c_Sf_BFu31ll { unsigned char v1:8; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8c_Sf_BFu32i { unsigned char v1:8; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8c_Sf_BFu32ll { unsigned char v1:8; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8c_Sf_BFu33 { unsigned char v1:8; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8c_Sf_BFu7c { unsigned char v1:8; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8c_Sf_BFu7i { unsigned char v1:8; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8c_Sf_BFu7ll { unsigned char v1:8; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8c_Sf_BFu7s { unsigned char v1:8; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8c_Sf_BFu8c { unsigned char v1:8; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8c_Sf_BFu8i { unsigned char v1:8; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8c_Sf_BFu8ll { unsigned char v1:8; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8c_Sf_BFu8s { unsigned char v1:8; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8c_Sf_BFu9i { unsigned char v1:8; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8c_Sf_BFu9ll { unsigned char v1:8; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8c_Sf_BFu9s { unsigned char v1:8; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8c_Sf_C { unsigned char v1:8; empty v2; char v3; };
struct __attribute__((packed)) aBFu8c_Sf_D { unsigned char v1:8; empty v2; double v3; };
struct __attribute__((packed)) aBFu8c_Sf_F { unsigned char v1:8; empty v2; float v3; };
struct __attribute__((packed)) aBFu8c_Sf_I { unsigned char v1:8; empty v2; int v3; };
struct __attribute__((packed)) aBFu8c_Sf_Ip { unsigned char v1:8; empty v2; int * v3; };
struct __attribute__((packed)) aBFu8c_Sf_L { unsigned char v1:8; empty v2; long long v3; };
struct __attribute__((packed)) aBFu8c_Sf_S { unsigned char v1:8; empty v2; short v3; };
struct __attribute__((packed)) aBFu8c_Sf_Sf { unsigned char v1:8; empty v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Sf_Uc { unsigned char v1:8; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8c_Sf_Ui { unsigned char v1:8; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8c_Sf_Ul { unsigned char v1:8; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8c_Sf_Us { unsigned char v1:8; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8c_Sf_Vp { unsigned char v1:8; empty v2; void * v3; };
struct __attribute__((packed)) aBFu8c_Uc_Sf { unsigned char v1:8; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Ui_Sf { unsigned char v1:8; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Ul_Sf { unsigned char v1:8; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Us_Sf { unsigned char v1:8; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu8c_Vp_Sf { unsigned char v1:8; void * v2; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu15i_Sf { unsigned int v1:8; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu15ll_Sf { unsigned int v1:8; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu15s_Sf { unsigned int v1:8; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu16i_Sf { unsigned int v1:8; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu16ll_Sf { unsigned int v1:8; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu16s_Sf { unsigned int v1:8; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu17i_Sf { unsigned int v1:8; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu17ll_Sf { unsigned int v1:8; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu1c_Sf { unsigned int v1:8; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu1i_Sf { unsigned int v1:8; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu1ll_Sf { unsigned int v1:8; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu1s_Sf { unsigned int v1:8; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu31i_Sf { unsigned int v1:8; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu31ll_Sf { unsigned int v1:8; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu32i_Sf { unsigned int v1:8; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu32ll_Sf { unsigned int v1:8; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu33_Sf { unsigned int v1:8; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu7c_Sf { unsigned int v1:8; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu7i_Sf { unsigned int v1:8; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu7ll_Sf { unsigned int v1:8; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu7s_Sf { unsigned int v1:8; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu8c_Sf { unsigned int v1:8; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu8i_Sf { unsigned int v1:8; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu8ll_Sf { unsigned int v1:8; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu8s_Sf { unsigned int v1:8; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu9i_Sf { unsigned int v1:8; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu9ll_Sf { unsigned int v1:8; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu8i_BFu9s_Sf { unsigned int v1:8; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu8i_C_Sf { unsigned int v1:8; char v2; empty v3; };
struct __attribute__((packed)) aBFu8i_D_Sf { unsigned int v1:8; double v2; empty v3; };
struct __attribute__((packed)) aBFu8i_F_Sf { unsigned int v1:8; float v2; empty v3; };
struct __attribute__((packed)) aBFu8i_I_Sf { unsigned int v1:8; int v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Ip_Sf { unsigned int v1:8; int * v2; empty v3; };
struct __attribute__((packed)) aBFu8i_L_Sf { unsigned int v1:8; long long v2; empty v3; };
struct __attribute__((packed)) aBFu8i_S_Sf { unsigned int v1:8; short v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Sf { unsigned int v1:8; empty v2; };
struct __attribute__((packed)) aBFu8i_Sf_BFu15i { unsigned int v1:8; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8i_Sf_BFu15ll { unsigned int v1:8; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8i_Sf_BFu15s { unsigned int v1:8; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8i_Sf_BFu16i { unsigned int v1:8; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8i_Sf_BFu16ll { unsigned int v1:8; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8i_Sf_BFu16s { unsigned int v1:8; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8i_Sf_BFu17i { unsigned int v1:8; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8i_Sf_BFu17ll { unsigned int v1:8; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8i_Sf_BFu1c { unsigned int v1:8; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8i_Sf_BFu1i { unsigned int v1:8; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8i_Sf_BFu1ll { unsigned int v1:8; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8i_Sf_BFu1s { unsigned int v1:8; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8i_Sf_BFu31i { unsigned int v1:8; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8i_Sf_BFu31ll { unsigned int v1:8; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8i_Sf_BFu32i { unsigned int v1:8; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8i_Sf_BFu32ll { unsigned int v1:8; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8i_Sf_BFu33 { unsigned int v1:8; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8i_Sf_BFu7c { unsigned int v1:8; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8i_Sf_BFu7i { unsigned int v1:8; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8i_Sf_BFu7ll { unsigned int v1:8; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8i_Sf_BFu7s { unsigned int v1:8; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8i_Sf_BFu8c { unsigned int v1:8; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8i_Sf_BFu8i { unsigned int v1:8; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8i_Sf_BFu8ll { unsigned int v1:8; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8i_Sf_BFu8s { unsigned int v1:8; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8i_Sf_BFu9i { unsigned int v1:8; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8i_Sf_BFu9ll { unsigned int v1:8; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8i_Sf_BFu9s { unsigned int v1:8; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8i_Sf_C { unsigned int v1:8; empty v2; char v3; };
struct __attribute__((packed)) aBFu8i_Sf_D { unsigned int v1:8; empty v2; double v3; };
struct __attribute__((packed)) aBFu8i_Sf_F { unsigned int v1:8; empty v2; float v3; };
struct __attribute__((packed)) aBFu8i_Sf_I { unsigned int v1:8; empty v2; int v3; };
struct __attribute__((packed)) aBFu8i_Sf_Ip { unsigned int v1:8; empty v2; int * v3; };
struct __attribute__((packed)) aBFu8i_Sf_L { unsigned int v1:8; empty v2; long long v3; };
struct __attribute__((packed)) aBFu8i_Sf_S { unsigned int v1:8; empty v2; short v3; };
struct __attribute__((packed)) aBFu8i_Sf_Sf { unsigned int v1:8; empty v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Sf_Uc { unsigned int v1:8; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8i_Sf_Ui { unsigned int v1:8; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8i_Sf_Ul { unsigned int v1:8; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8i_Sf_Us { unsigned int v1:8; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8i_Sf_Vp { unsigned int v1:8; empty v2; void * v3; };
struct __attribute__((packed)) aBFu8i_Uc_Sf { unsigned int v1:8; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Ui_Sf { unsigned int v1:8; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Ul_Sf { unsigned int v1:8; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Us_Sf { unsigned int v1:8; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu8i_Vp_Sf { unsigned int v1:8; void * v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu15i_Sf { unsigned long long v1:8; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu15ll_Sf { unsigned long long v1:8; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu15s_Sf { unsigned long long v1:8; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu16i_Sf { unsigned long long v1:8; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu16ll_Sf { unsigned long long v1:8; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu16s_Sf { unsigned long long v1:8; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu17i_Sf { unsigned long long v1:8; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu17ll_Sf { unsigned long long v1:8; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu1c_Sf { unsigned long long v1:8; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu1i_Sf { unsigned long long v1:8; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu1ll_Sf { unsigned long long v1:8; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu1s_Sf { unsigned long long v1:8; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu31i_Sf { unsigned long long v1:8; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu31ll_Sf { unsigned long long v1:8; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu32i_Sf { unsigned long long v1:8; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu32ll_Sf { unsigned long long v1:8; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu33_Sf { unsigned long long v1:8; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu7c_Sf { unsigned long long v1:8; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu7i_Sf { unsigned long long v1:8; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu7ll_Sf { unsigned long long v1:8; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu7s_Sf { unsigned long long v1:8; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu8c_Sf { unsigned long long v1:8; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu8i_Sf { unsigned long long v1:8; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu8ll_Sf { unsigned long long v1:8; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu8s_Sf { unsigned long long v1:8; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu9i_Sf { unsigned long long v1:8; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu9ll_Sf { unsigned long long v1:8; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu8ll_BFu9s_Sf { unsigned long long v1:8; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu8ll_C_Sf { unsigned long long v1:8; char v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_D_Sf { unsigned long long v1:8; double v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_F_Sf { unsigned long long v1:8; float v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_I_Sf { unsigned long long v1:8; int v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Sf { unsigned long long v1:8; int * v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_L_Sf { unsigned long long v1:8; long long v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_S_Sf { unsigned long long v1:8; short v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Sf { unsigned long long v1:8; empty v2; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu15i { unsigned long long v1:8; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu15ll { unsigned long long v1:8; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu15s { unsigned long long v1:8; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu16i { unsigned long long v1:8; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu16ll { unsigned long long v1:8; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu16s { unsigned long long v1:8; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu17i { unsigned long long v1:8; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu17ll { unsigned long long v1:8; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu1c { unsigned long long v1:8; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu1i { unsigned long long v1:8; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu1ll { unsigned long long v1:8; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu1s { unsigned long long v1:8; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu31i { unsigned long long v1:8; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu31ll { unsigned long long v1:8; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu32i { unsigned long long v1:8; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu32ll { unsigned long long v1:8; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu33 { unsigned long long v1:8; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu7c { unsigned long long v1:8; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu7i { unsigned long long v1:8; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu7ll { unsigned long long v1:8; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu7s { unsigned long long v1:8; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu8c { unsigned long long v1:8; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu8i { unsigned long long v1:8; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu8ll { unsigned long long v1:8; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu8s { unsigned long long v1:8; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu9i { unsigned long long v1:8; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu9ll { unsigned long long v1:8; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Sf_BFu9s { unsigned long long v1:8; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Sf_C { unsigned long long v1:8; empty v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Sf_D { unsigned long long v1:8; empty v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Sf_F { unsigned long long v1:8; empty v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Sf_I { unsigned long long v1:8; empty v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Ip { unsigned long long v1:8; empty v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Sf_L { unsigned long long v1:8; empty v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Sf_S { unsigned long long v1:8; empty v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Sf { unsigned long long v1:8; empty v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Uc { unsigned long long v1:8; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Ui { unsigned long long v1:8; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Ul { unsigned long long v1:8; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Us { unsigned long long v1:8; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Sf_Vp { unsigned long long v1:8; empty v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Sf { unsigned long long v1:8; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Sf { unsigned long long v1:8; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Sf { unsigned long long v1:8; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Us_Sf { unsigned long long v1:8; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Sf { unsigned long long v1:8; void * v2; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Sf { unsigned short v1:8; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Sf { unsigned short v1:8; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Sf { unsigned short v1:8; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Sf { unsigned short v1:8; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Sf { unsigned short v1:8; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Sf { unsigned short v1:8; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Sf { unsigned short v1:8; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Sf { unsigned short v1:8; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Sf { unsigned short v1:8; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Sf { unsigned short v1:8; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Sf { unsigned short v1:8; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Sf { unsigned short v1:8; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Sf { unsigned short v1:8; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Sf { unsigned short v1:8; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Sf { unsigned short v1:8; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Sf { unsigned short v1:8; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Sf { unsigned short v1:8; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Sf { unsigned short v1:8; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Sf { unsigned short v1:8; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Sf { unsigned short v1:8; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Sf { unsigned short v1:8; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Sf { unsigned short v1:8; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Sf { unsigned short v1:8; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Sf { unsigned short v1:8; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Sf { unsigned short v1:8; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Sf { unsigned short v1:8; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Sf { unsigned short v1:8; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Sf { unsigned short v1:8; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu8s_C_Sf { unsigned short v1:8; char v2; empty v3; };
struct __attribute__((packed)) aBFu8s_D_Sf { unsigned short v1:8; double v2; empty v3; };
struct __attribute__((packed)) aBFu8s_F_Sf { unsigned short v1:8; float v2; empty v3; };
struct __attribute__((packed)) aBFu8s_I_Sf { unsigned short v1:8; int v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Ip_Sf { unsigned short v1:8; int * v2; empty v3; };
struct __attribute__((packed)) aBFu8s_L_Sf { unsigned short v1:8; long long v2; empty v3; };
struct __attribute__((packed)) aBFu8s_S_Sf { unsigned short v1:8; short v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Sf { unsigned short v1:8; empty v2; };
struct __attribute__((packed)) aBFu8s_Sf_BFu15i { unsigned short v1:8; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Sf_BFu15ll { unsigned short v1:8; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Sf_BFu15s { unsigned short v1:8; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Sf_BFu16i { unsigned short v1:8; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Sf_BFu16ll { unsigned short v1:8; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Sf_BFu16s { unsigned short v1:8; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Sf_BFu17i { unsigned short v1:8; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Sf_BFu17ll { unsigned short v1:8; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Sf_BFu1c { unsigned short v1:8; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Sf_BFu1i { unsigned short v1:8; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Sf_BFu1ll { unsigned short v1:8; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Sf_BFu1s { unsigned short v1:8; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Sf_BFu31i { unsigned short v1:8; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Sf_BFu31ll { unsigned short v1:8; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Sf_BFu32i { unsigned short v1:8; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Sf_BFu32ll { unsigned short v1:8; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Sf_BFu33 { unsigned short v1:8; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Sf_BFu7c { unsigned short v1:8; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Sf_BFu7i { unsigned short v1:8; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Sf_BFu7ll { unsigned short v1:8; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Sf_BFu7s { unsigned short v1:8; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Sf_BFu8c { unsigned short v1:8; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Sf_BFu8i { unsigned short v1:8; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Sf_BFu8ll { unsigned short v1:8; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Sf_BFu8s { unsigned short v1:8; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Sf_BFu9i { unsigned short v1:8; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Sf_BFu9ll { unsigned short v1:8; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Sf_BFu9s { unsigned short v1:8; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Sf_C { unsigned short v1:8; empty v2; char v3; };
struct __attribute__((packed)) aBFu8s_Sf_D { unsigned short v1:8; empty v2; double v3; };
struct __attribute__((packed)) aBFu8s_Sf_F { unsigned short v1:8; empty v2; float v3; };
struct __attribute__((packed)) aBFu8s_Sf_I { unsigned short v1:8; empty v2; int v3; };
struct __attribute__((packed)) aBFu8s_Sf_Ip { unsigned short v1:8; empty v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Sf_L { unsigned short v1:8; empty v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Sf_S { unsigned short v1:8; empty v2; short v3; };
struct __attribute__((packed)) aBFu8s_Sf_Sf { unsigned short v1:8; empty v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Sf_Uc { unsigned short v1:8; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Sf_Ui { unsigned short v1:8; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Sf_Ul { unsigned short v1:8; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Sf_Us { unsigned short v1:8; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Sf_Vp { unsigned short v1:8; empty v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Uc_Sf { unsigned short v1:8; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Ui_Sf { unsigned short v1:8; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Ul_Sf { unsigned short v1:8; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Us_Sf { unsigned short v1:8; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu8s_Vp_Sf { unsigned short v1:8; void * v2; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Sf { unsigned int v1:9; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Sf { unsigned int v1:9; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Sf { unsigned int v1:9; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Sf { unsigned int v1:9; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Sf { unsigned int v1:9; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu16s_Sf { unsigned int v1:9; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu17i_Sf { unsigned int v1:9; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu17ll_Sf { unsigned int v1:9; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu1c_Sf { unsigned int v1:9; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu1i_Sf { unsigned int v1:9; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu1ll_Sf { unsigned int v1:9; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu1s_Sf { unsigned int v1:9; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu31i_Sf { unsigned int v1:9; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu31ll_Sf { unsigned int v1:9; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu32i_Sf { unsigned int v1:9; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu32ll_Sf { unsigned int v1:9; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu33_Sf { unsigned int v1:9; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu7c_Sf { unsigned int v1:9; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu7i_Sf { unsigned int v1:9; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu7ll_Sf { unsigned int v1:9; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu7s_Sf { unsigned int v1:9; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu8c_Sf { unsigned int v1:9; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu8i_Sf { unsigned int v1:9; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu8ll_Sf { unsigned int v1:9; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu8s_Sf { unsigned int v1:9; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu9i_Sf { unsigned int v1:9; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu9ll_Sf { unsigned int v1:9; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu9i_BFu9s_Sf { unsigned int v1:9; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu9i_C_Sf { unsigned int v1:9; char v2; empty v3; };
struct __attribute__((packed)) aBFu9i_D_Sf { unsigned int v1:9; double v2; empty v3; };
struct __attribute__((packed)) aBFu9i_F_Sf { unsigned int v1:9; float v2; empty v3; };
struct __attribute__((packed)) aBFu9i_I_Sf { unsigned int v1:9; int v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Ip_Sf { unsigned int v1:9; int * v2; empty v3; };
struct __attribute__((packed)) aBFu9i_L_Sf { unsigned int v1:9; long long v2; empty v3; };
struct __attribute__((packed)) aBFu9i_S_Sf { unsigned int v1:9; short v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Sf { unsigned int v1:9; empty v2; };
struct __attribute__((packed)) aBFu9i_Sf_BFu15i { unsigned int v1:9; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_Sf_BFu15ll { unsigned int v1:9; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_Sf_BFu15s { unsigned int v1:9; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_Sf_BFu16i { unsigned int v1:9; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_Sf_BFu16ll { unsigned int v1:9; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_Sf_BFu16s { unsigned int v1:9; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_Sf_BFu17i { unsigned int v1:9; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_Sf_BFu17ll { unsigned int v1:9; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_Sf_BFu1c { unsigned int v1:9; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_Sf_BFu1i { unsigned int v1:9; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_Sf_BFu1ll { unsigned int v1:9; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_Sf_BFu1s { unsigned int v1:9; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_Sf_BFu31i { unsigned int v1:9; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_Sf_BFu31ll { unsigned int v1:9; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_Sf_BFu32i { unsigned int v1:9; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_Sf_BFu32ll { unsigned int v1:9; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_Sf_BFu33 { unsigned int v1:9; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_Sf_BFu7c { unsigned int v1:9; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_Sf_BFu7i { unsigned int v1:9; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_Sf_BFu7ll { unsigned int v1:9; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_Sf_BFu7s { unsigned int v1:9; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_Sf_BFu8c { unsigned int v1:9; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_Sf_BFu8i { unsigned int v1:9; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_Sf_BFu8ll { unsigned int v1:9; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_Sf_BFu8s { unsigned int v1:9; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_Sf_BFu9i { unsigned int v1:9; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_Sf_BFu9ll { unsigned int v1:9; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_Sf_BFu9s { unsigned int v1:9; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_Sf_C { unsigned int v1:9; empty v2; char v3; };
struct __attribute__((packed)) aBFu9i_Sf_D { unsigned int v1:9; empty v2; double v3; };
struct __attribute__((packed)) aBFu9i_Sf_F { unsigned int v1:9; empty v2; float v3; };
struct __attribute__((packed)) aBFu9i_Sf_I { unsigned int v1:9; empty v2; int v3; };
struct __attribute__((packed)) aBFu9i_Sf_Ip { unsigned int v1:9; empty v2; int * v3; };
struct __attribute__((packed)) aBFu9i_Sf_L { unsigned int v1:9; empty v2; long long v3; };
struct __attribute__((packed)) aBFu9i_Sf_S { unsigned int v1:9; empty v2; short v3; };
struct __attribute__((packed)) aBFu9i_Sf_Sf { unsigned int v1:9; empty v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Sf_Uc { unsigned int v1:9; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_Sf_Ui { unsigned int v1:9; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_Sf_Ul { unsigned int v1:9; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_Sf_Us { unsigned int v1:9; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_Sf_Vp { unsigned int v1:9; empty v2; void * v3; };
struct __attribute__((packed)) aBFu9i_Uc_Sf { unsigned int v1:9; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Ui_Sf { unsigned int v1:9; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Ul_Sf { unsigned int v1:9; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Us_Sf { unsigned int v1:9; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu9i_Vp_Sf { unsigned int v1:9; void * v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu15i_Sf { unsigned long long v1:9; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu15ll_Sf { unsigned long long v1:9; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu15s_Sf { unsigned long long v1:9; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu16i_Sf { unsigned long long v1:9; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu16ll_Sf { unsigned long long v1:9; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu16s_Sf { unsigned long long v1:9; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu17i_Sf { unsigned long long v1:9; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu17ll_Sf { unsigned long long v1:9; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu1c_Sf { unsigned long long v1:9; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu1i_Sf { unsigned long long v1:9; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu1ll_Sf { unsigned long long v1:9; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu1s_Sf { unsigned long long v1:9; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu31i_Sf { unsigned long long v1:9; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu31ll_Sf { unsigned long long v1:9; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu32i_Sf { unsigned long long v1:9; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu32ll_Sf { unsigned long long v1:9; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu33_Sf { unsigned long long v1:9; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu7c_Sf { unsigned long long v1:9; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu7i_Sf { unsigned long long v1:9; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu7ll_Sf { unsigned long long v1:9; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu7s_Sf { unsigned long long v1:9; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu8c_Sf { unsigned long long v1:9; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu8i_Sf { unsigned long long v1:9; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu8ll_Sf { unsigned long long v1:9; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu8s_Sf { unsigned long long v1:9; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu9i_Sf { unsigned long long v1:9; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu9ll_Sf { unsigned long long v1:9; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu9ll_BFu9s_Sf { unsigned long long v1:9; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu9ll_C_Sf { unsigned long long v1:9; char v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_D_Sf { unsigned long long v1:9; double v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_F_Sf { unsigned long long v1:9; float v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_I_Sf { unsigned long long v1:9; int v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Ip_Sf { unsigned long long v1:9; int * v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_L_Sf { unsigned long long v1:9; long long v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_S_Sf { unsigned long long v1:9; short v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Sf { unsigned long long v1:9; empty v2; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu15i { unsigned long long v1:9; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu15ll { unsigned long long v1:9; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu15s { unsigned long long v1:9; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu16i { unsigned long long v1:9; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu16ll { unsigned long long v1:9; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu16s { unsigned long long v1:9; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu17i { unsigned long long v1:9; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu17ll { unsigned long long v1:9; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu1c { unsigned long long v1:9; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu1i { unsigned long long v1:9; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu1ll { unsigned long long v1:9; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu1s { unsigned long long v1:9; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu31i { unsigned long long v1:9; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu31ll { unsigned long long v1:9; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu32i { unsigned long long v1:9; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu32ll { unsigned long long v1:9; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu33 { unsigned long long v1:9; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu7c { unsigned long long v1:9; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu7i { unsigned long long v1:9; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu7ll { unsigned long long v1:9; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu7s { unsigned long long v1:9; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu8c { unsigned long long v1:9; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu8i { unsigned long long v1:9; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu8ll { unsigned long long v1:9; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu8s { unsigned long long v1:9; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu9i { unsigned long long v1:9; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu9ll { unsigned long long v1:9; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9ll_Sf_BFu9s { unsigned long long v1:9; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9ll_Sf_C { unsigned long long v1:9; empty v2; char v3; };
struct __attribute__((packed)) aBFu9ll_Sf_D { unsigned long long v1:9; empty v2; double v3; };
struct __attribute__((packed)) aBFu9ll_Sf_F { unsigned long long v1:9; empty v2; float v3; };
struct __attribute__((packed)) aBFu9ll_Sf_I { unsigned long long v1:9; empty v2; int v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Ip { unsigned long long v1:9; empty v2; int * v3; };
struct __attribute__((packed)) aBFu9ll_Sf_L { unsigned long long v1:9; empty v2; long long v3; };
struct __attribute__((packed)) aBFu9ll_Sf_S { unsigned long long v1:9; empty v2; short v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Sf { unsigned long long v1:9; empty v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Uc { unsigned long long v1:9; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Ui { unsigned long long v1:9; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Ul { unsigned long long v1:9; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Us { unsigned long long v1:9; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu9ll_Sf_Vp { unsigned long long v1:9; empty v2; void * v3; };
struct __attribute__((packed)) aBFu9ll_Uc_Sf { unsigned long long v1:9; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Ui_Sf { unsigned long long v1:9; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Ul_Sf { unsigned long long v1:9; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Us_Sf { unsigned long long v1:9; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu9ll_Vp_Sf { unsigned long long v1:9; void * v2; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu15i_Sf { unsigned short v1:9; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu15ll_Sf { unsigned short v1:9; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu15s_Sf { unsigned short v1:9; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu16i_Sf { unsigned short v1:9; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu16ll_Sf { unsigned short v1:9; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu16s_Sf { unsigned short v1:9; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu17i_Sf { unsigned short v1:9; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu17ll_Sf { unsigned short v1:9; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu1c_Sf { unsigned short v1:9; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu1i_Sf { unsigned short v1:9; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu1ll_Sf { unsigned short v1:9; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu1s_Sf { unsigned short v1:9; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu31i_Sf { unsigned short v1:9; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu31ll_Sf { unsigned short v1:9; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu32i_Sf { unsigned short v1:9; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu32ll_Sf { unsigned short v1:9; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu33_Sf { unsigned short v1:9; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu7c_Sf { unsigned short v1:9; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu7i_Sf { unsigned short v1:9; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu7ll_Sf { unsigned short v1:9; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu7s_Sf { unsigned short v1:9; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu8c_Sf { unsigned short v1:9; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu8i_Sf { unsigned short v1:9; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu8ll_Sf { unsigned short v1:9; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu8s_Sf { unsigned short v1:9; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu9i_Sf { unsigned short v1:9; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu9ll_Sf { unsigned short v1:9; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aBFu9s_BFu9s_Sf { unsigned short v1:9; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aBFu9s_C_Sf { unsigned short v1:9; char v2; empty v3; };
struct __attribute__((packed)) aBFu9s_D_Sf { unsigned short v1:9; double v2; empty v3; };
struct __attribute__((packed)) aBFu9s_F_Sf { unsigned short v1:9; float v2; empty v3; };
struct __attribute__((packed)) aBFu9s_I_Sf { unsigned short v1:9; int v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Ip_Sf { unsigned short v1:9; int * v2; empty v3; };
struct __attribute__((packed)) aBFu9s_L_Sf { unsigned short v1:9; long long v2; empty v3; };
struct __attribute__((packed)) aBFu9s_S_Sf { unsigned short v1:9; short v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Sf { unsigned short v1:9; empty v2; };
struct __attribute__((packed)) aBFu9s_Sf_BFu15i { unsigned short v1:9; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9s_Sf_BFu15ll { unsigned short v1:9; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9s_Sf_BFu15s { unsigned short v1:9; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9s_Sf_BFu16i { unsigned short v1:9; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9s_Sf_BFu16ll { unsigned short v1:9; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9s_Sf_BFu16s { unsigned short v1:9; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9s_Sf_BFu17i { unsigned short v1:9; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9s_Sf_BFu17ll { unsigned short v1:9; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9s_Sf_BFu1c { unsigned short v1:9; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9s_Sf_BFu1i { unsigned short v1:9; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9s_Sf_BFu1ll { unsigned short v1:9; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9s_Sf_BFu1s { unsigned short v1:9; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9s_Sf_BFu31i { unsigned short v1:9; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9s_Sf_BFu31ll { unsigned short v1:9; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9s_Sf_BFu32i { unsigned short v1:9; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9s_Sf_BFu32ll { unsigned short v1:9; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9s_Sf_BFu33 { unsigned short v1:9; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9s_Sf_BFu7c { unsigned short v1:9; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9s_Sf_BFu7i { unsigned short v1:9; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9s_Sf_BFu7ll { unsigned short v1:9; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9s_Sf_BFu7s { unsigned short v1:9; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9s_Sf_BFu8c { unsigned short v1:9; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9s_Sf_BFu8i { unsigned short v1:9; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9s_Sf_BFu8ll { unsigned short v1:9; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9s_Sf_BFu8s { unsigned short v1:9; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9s_Sf_BFu9i { unsigned short v1:9; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9s_Sf_BFu9ll { unsigned short v1:9; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9s_Sf_BFu9s { unsigned short v1:9; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9s_Sf_C { unsigned short v1:9; empty v2; char v3; };
struct __attribute__((packed)) aBFu9s_Sf_D { unsigned short v1:9; empty v2; double v3; };
struct __attribute__((packed)) aBFu9s_Sf_F { unsigned short v1:9; empty v2; float v3; };
struct __attribute__((packed)) aBFu9s_Sf_I { unsigned short v1:9; empty v2; int v3; };
struct __attribute__((packed)) aBFu9s_Sf_Ip { unsigned short v1:9; empty v2; int * v3; };
struct __attribute__((packed)) aBFu9s_Sf_L { unsigned short v1:9; empty v2; long long v3; };
struct __attribute__((packed)) aBFu9s_Sf_S { unsigned short v1:9; empty v2; short v3; };
struct __attribute__((packed)) aBFu9s_Sf_Sf { unsigned short v1:9; empty v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Sf_Uc { unsigned short v1:9; empty v2; unsigned char v3; };
struct __attribute__((packed)) aBFu9s_Sf_Ui { unsigned short v1:9; empty v2; unsigned int v3; };
struct __attribute__((packed)) aBFu9s_Sf_Ul { unsigned short v1:9; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu9s_Sf_Us { unsigned short v1:9; empty v2; unsigned short v3; };
struct __attribute__((packed)) aBFu9s_Sf_Vp { unsigned short v1:9; empty v2; void * v3; };
struct __attribute__((packed)) aBFu9s_Uc_Sf { unsigned short v1:9; unsigned char v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Ui_Sf { unsigned short v1:9; unsigned int v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Ul_Sf { unsigned short v1:9; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Us_Sf { unsigned short v1:9; unsigned short v2; empty v3; };
struct __attribute__((packed)) aBFu9s_Vp_Sf { unsigned short v1:9; void * v2; empty v3; };
struct __attribute__((packed)) aC_BFu15i_Sf { char v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aC_BFu15ll_Sf { char v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aC_BFu15s_Sf { char v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aC_BFu16i_Sf { char v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aC_BFu16ll_Sf { char v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aC_BFu16s_Sf { char v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aC_BFu17i_Sf { char v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aC_BFu17ll_Sf { char v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aC_BFu1c_Sf { char v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aC_BFu1i_Sf { char v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aC_BFu1ll_Sf { char v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aC_BFu1s_Sf { char v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aC_BFu31i_Sf { char v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aC_BFu31ll_Sf { char v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aC_BFu32i_Sf { char v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aC_BFu32ll_Sf { char v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aC_BFu33_Sf { char v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aC_BFu7c_Sf { char v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aC_BFu7i_Sf { char v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aC_BFu7ll_Sf { char v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aC_BFu7s_Sf { char v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aC_BFu8c_Sf { char v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aC_BFu8i_Sf { char v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aC_BFu8ll_Sf { char v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aC_BFu8s_Sf { char v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aC_BFu9i_Sf { char v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aC_BFu9ll_Sf { char v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aC_BFu9s_Sf { char v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aC_C_Sf { char v1; char v2; empty v3; };
struct __attribute__((packed)) aC_D_Sf { char v1; double v2; empty v3; };
struct __attribute__((packed)) aC_F_Sf { char v1; float v2; empty v3; };
struct __attribute__((packed)) aC_I_Sf { char v1; int v2; empty v3; };
struct __attribute__((packed)) aC_Ip_Sf { char v1; int * v2; empty v3; };
struct __attribute__((packed)) aC_L_Sf { char v1; long long v2; empty v3; };
struct __attribute__((packed)) aC_S_Sf { char v1; short v2; empty v3; };
struct __attribute__((packed)) aC_Sf { char v1; empty v2; };
struct __attribute__((packed)) aC_Sf_BFu15i { char v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Sf_BFu15ll { char v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Sf_BFu15s { char v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Sf_BFu16i { char v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Sf_BFu16ll { char v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Sf_BFu16s { char v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Sf_BFu17i { char v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Sf_BFu17ll { char v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Sf_BFu1c { char v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Sf_BFu1i { char v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Sf_BFu1ll { char v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Sf_BFu1s { char v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Sf_BFu31i { char v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Sf_BFu31ll { char v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Sf_BFu32i { char v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Sf_BFu32ll { char v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Sf_BFu33 { char v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Sf_BFu7c { char v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Sf_BFu7i { char v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Sf_BFu7ll { char v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Sf_BFu7s { char v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Sf_BFu8c { char v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Sf_BFu8i { char v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Sf_BFu8ll { char v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Sf_BFu8s { char v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Sf_BFu9i { char v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Sf_BFu9ll { char v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Sf_BFu9s { char v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Sf_C { char v1; empty v2; char v3; };
struct __attribute__((packed)) aC_Sf_D { char v1; empty v2; double v3; };
struct __attribute__((packed)) aC_Sf_F { char v1; empty v2; float v3; };
struct __attribute__((packed)) aC_Sf_I { char v1; empty v2; int v3; };
struct __attribute__((packed)) aC_Sf_Ip { char v1; empty v2; int * v3; };
struct __attribute__((packed)) aC_Sf_L { char v1; empty v2; long long v3; };
struct __attribute__((packed)) aC_Sf_S { char v1; empty v2; short v3; };
struct __attribute__((packed)) aC_Sf_Sf { char v1; empty v2; empty v3; };
struct __attribute__((packed)) aC_Sf_Uc { char v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aC_Sf_Ui { char v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aC_Sf_Ul { char v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Sf_Us { char v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aC_Sf_Vp { char v1; empty v2; void * v3; };
struct __attribute__((packed)) aC_Uc_Sf { char v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aC_Ui_Sf { char v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aC_Ul_Sf { char v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aC_Us_Sf { char v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aC_Vp_Sf { char v1; void * v2; empty v3; };
struct __attribute__((packed)) aD_BFu15i_Sf { double v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aD_BFu15ll_Sf { double v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aD_BFu15s_Sf { double v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aD_BFu16i_Sf { double v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aD_BFu16ll_Sf { double v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aD_BFu16s_Sf { double v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aD_BFu17i_Sf { double v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aD_BFu17ll_Sf { double v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aD_BFu1c_Sf { double v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aD_BFu1i_Sf { double v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aD_BFu1ll_Sf { double v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aD_BFu1s_Sf { double v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aD_BFu31i_Sf { double v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aD_BFu31ll_Sf { double v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aD_BFu32i_Sf { double v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aD_BFu32ll_Sf { double v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aD_BFu33_Sf { double v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aD_BFu7c_Sf { double v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aD_BFu7i_Sf { double v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aD_BFu7ll_Sf { double v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aD_BFu7s_Sf { double v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aD_BFu8c_Sf { double v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aD_BFu8i_Sf { double v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aD_BFu8ll_Sf { double v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aD_BFu8s_Sf { double v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aD_BFu9i_Sf { double v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aD_BFu9ll_Sf { double v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aD_BFu9s_Sf { double v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aD_C_Sf { double v1; char v2; empty v3; };
struct __attribute__((packed)) aD_D_Sf { double v1; double v2; empty v3; };
struct __attribute__((packed)) aD_F_Sf { double v1; float v2; empty v3; };
struct __attribute__((packed)) aD_I_Sf { double v1; int v2; empty v3; };
struct __attribute__((packed)) aD_Ip_Sf { double v1; int * v2; empty v3; };
struct __attribute__((packed)) aD_L_Sf { double v1; long long v2; empty v3; };
struct __attribute__((packed)) aD_S_Sf { double v1; short v2; empty v3; };
struct __attribute__((packed)) aD_Sf { double v1; empty v2; };
struct __attribute__((packed)) aD_Sf_BFu15i { double v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Sf_BFu15ll { double v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Sf_BFu15s { double v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Sf_BFu16i { double v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Sf_BFu16ll { double v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Sf_BFu16s { double v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Sf_BFu17i { double v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Sf_BFu17ll { double v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Sf_BFu1c { double v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Sf_BFu1i { double v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Sf_BFu1ll { double v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Sf_BFu1s { double v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Sf_BFu31i { double v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Sf_BFu31ll { double v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Sf_BFu32i { double v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Sf_BFu32ll { double v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Sf_BFu33 { double v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Sf_BFu7c { double v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Sf_BFu7i { double v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Sf_BFu7ll { double v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Sf_BFu7s { double v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Sf_BFu8c { double v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Sf_BFu8i { double v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Sf_BFu8ll { double v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Sf_BFu8s { double v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Sf_BFu9i { double v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Sf_BFu9ll { double v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Sf_BFu9s { double v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Sf_C { double v1; empty v2; char v3; };
struct __attribute__((packed)) aD_Sf_D { double v1; empty v2; double v3; };
struct __attribute__((packed)) aD_Sf_F { double v1; empty v2; float v3; };
struct __attribute__((packed)) aD_Sf_I { double v1; empty v2; int v3; };
struct __attribute__((packed)) aD_Sf_Ip { double v1; empty v2; int * v3; };
struct __attribute__((packed)) aD_Sf_L { double v1; empty v2; long long v3; };
struct __attribute__((packed)) aD_Sf_S { double v1; empty v2; short v3; };
struct __attribute__((packed)) aD_Sf_Sf { double v1; empty v2; empty v3; };
struct __attribute__((packed)) aD_Sf_Uc { double v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aD_Sf_Ui { double v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aD_Sf_Ul { double v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Sf_Us { double v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aD_Sf_Vp { double v1; empty v2; void * v3; };
struct __attribute__((packed)) aD_Uc_Sf { double v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aD_Ui_Sf { double v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aD_Ul_Sf { double v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aD_Us_Sf { double v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aD_Vp_Sf { double v1; void * v2; empty v3; };
struct __attribute__((packed)) aF_BFu15i_Sf { float v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aF_BFu15ll_Sf { float v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aF_BFu15s_Sf { float v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aF_BFu16i_Sf { float v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aF_BFu16ll_Sf { float v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aF_BFu16s_Sf { float v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aF_BFu17i_Sf { float v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aF_BFu17ll_Sf { float v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aF_BFu1c_Sf { float v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aF_BFu1i_Sf { float v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aF_BFu1ll_Sf { float v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aF_BFu1s_Sf { float v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aF_BFu31i_Sf { float v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aF_BFu31ll_Sf { float v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aF_BFu32i_Sf { float v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aF_BFu32ll_Sf { float v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aF_BFu33_Sf { float v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aF_BFu7c_Sf { float v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aF_BFu7i_Sf { float v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aF_BFu7ll_Sf { float v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aF_BFu7s_Sf { float v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aF_BFu8c_Sf { float v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aF_BFu8i_Sf { float v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aF_BFu8ll_Sf { float v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aF_BFu8s_Sf { float v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aF_BFu9i_Sf { float v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aF_BFu9ll_Sf { float v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aF_BFu9s_Sf { float v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aF_C_Sf { float v1; char v2; empty v3; };
struct __attribute__((packed)) aF_D_Sf { float v1; double v2; empty v3; };
struct __attribute__((packed)) aF_F_Sf { float v1; float v2; empty v3; };
struct __attribute__((packed)) aF_I_Sf { float v1; int v2; empty v3; };
struct __attribute__((packed)) aF_Ip_Sf { float v1; int * v2; empty v3; };
struct __attribute__((packed)) aF_L_Sf { float v1; long long v2; empty v3; };
struct __attribute__((packed)) aF_S_Sf { float v1; short v2; empty v3; };
struct __attribute__((packed)) aF_Sf { float v1; empty v2; };
struct __attribute__((packed)) aF_Sf_BFu15i { float v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Sf_BFu15ll { float v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Sf_BFu15s { float v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Sf_BFu16i { float v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Sf_BFu16ll { float v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Sf_BFu16s { float v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Sf_BFu17i { float v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Sf_BFu17ll { float v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Sf_BFu1c { float v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Sf_BFu1i { float v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Sf_BFu1ll { float v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Sf_BFu1s { float v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Sf_BFu31i { float v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Sf_BFu31ll { float v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Sf_BFu32i { float v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Sf_BFu32ll { float v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Sf_BFu33 { float v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Sf_BFu7c { float v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Sf_BFu7i { float v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Sf_BFu7ll { float v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Sf_BFu7s { float v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Sf_BFu8c { float v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Sf_BFu8i { float v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Sf_BFu8ll { float v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Sf_BFu8s { float v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Sf_BFu9i { float v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Sf_BFu9ll { float v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Sf_BFu9s { float v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Sf_C { float v1; empty v2; char v3; };
struct __attribute__((packed)) aF_Sf_D { float v1; empty v2; double v3; };
struct __attribute__((packed)) aF_Sf_F { float v1; empty v2; float v3; };
struct __attribute__((packed)) aF_Sf_I { float v1; empty v2; int v3; };
struct __attribute__((packed)) aF_Sf_Ip { float v1; empty v2; int * v3; };
struct __attribute__((packed)) aF_Sf_L { float v1; empty v2; long long v3; };
struct __attribute__((packed)) aF_Sf_S { float v1; empty v2; short v3; };
struct __attribute__((packed)) aF_Sf_Sf { float v1; empty v2; empty v3; };
struct __attribute__((packed)) aF_Sf_Uc { float v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aF_Sf_Ui { float v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aF_Sf_Ul { float v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Sf_Us { float v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aF_Sf_Vp { float v1; empty v2; void * v3; };
struct __attribute__((packed)) aF_Uc_Sf { float v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aF_Ui_Sf { float v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aF_Ul_Sf { float v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aF_Us_Sf { float v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aF_Vp_Sf { float v1; void * v2; empty v3; };
struct __attribute__((packed)) aI_BFu15i_Sf { int v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aI_BFu15ll_Sf { int v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aI_BFu15s_Sf { int v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aI_BFu16i_Sf { int v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aI_BFu16ll_Sf { int v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aI_BFu16s_Sf { int v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aI_BFu17i_Sf { int v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aI_BFu17ll_Sf { int v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aI_BFu1c_Sf { int v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aI_BFu1i_Sf { int v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aI_BFu1ll_Sf { int v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aI_BFu1s_Sf { int v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aI_BFu31i_Sf { int v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aI_BFu31ll_Sf { int v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aI_BFu32i_Sf { int v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aI_BFu32ll_Sf { int v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aI_BFu33_Sf { int v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aI_BFu7c_Sf { int v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aI_BFu7i_Sf { int v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aI_BFu7ll_Sf { int v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aI_BFu7s_Sf { int v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aI_BFu8c_Sf { int v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aI_BFu8i_Sf { int v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aI_BFu8ll_Sf { int v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aI_BFu8s_Sf { int v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aI_BFu9i_Sf { int v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aI_BFu9ll_Sf { int v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aI_BFu9s_Sf { int v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aI_C_Sf { int v1; char v2; empty v3; };
struct __attribute__((packed)) aI_D_Sf { int v1; double v2; empty v3; };
struct __attribute__((packed)) aI_F_Sf { int v1; float v2; empty v3; };
struct __attribute__((packed)) aI_I_Sf { int v1; int v2; empty v3; };
struct __attribute__((packed)) aI_Ip_Sf { int v1; int * v2; empty v3; };
struct __attribute__((packed)) aI_L_Sf { int v1; long long v2; empty v3; };
struct __attribute__((packed)) aI_S_Sf { int v1; short v2; empty v3; };
struct __attribute__((packed)) aI_Sf { int v1; empty v2; };
struct __attribute__((packed)) aI_Sf_BFu15i { int v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Sf_BFu15ll { int v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Sf_BFu15s { int v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Sf_BFu16i { int v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Sf_BFu16ll { int v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Sf_BFu16s { int v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Sf_BFu17i { int v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Sf_BFu17ll { int v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Sf_BFu1c { int v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Sf_BFu1i { int v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Sf_BFu1ll { int v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Sf_BFu1s { int v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Sf_BFu31i { int v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Sf_BFu31ll { int v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Sf_BFu32i { int v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Sf_BFu32ll { int v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Sf_BFu33 { int v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Sf_BFu7c { int v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Sf_BFu7i { int v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Sf_BFu7ll { int v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Sf_BFu7s { int v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Sf_BFu8c { int v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Sf_BFu8i { int v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Sf_BFu8ll { int v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Sf_BFu8s { int v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Sf_BFu9i { int v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Sf_BFu9ll { int v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Sf_BFu9s { int v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Sf_C { int v1; empty v2; char v3; };
struct __attribute__((packed)) aI_Sf_D { int v1; empty v2; double v3; };
struct __attribute__((packed)) aI_Sf_F { int v1; empty v2; float v3; };
struct __attribute__((packed)) aI_Sf_I { int v1; empty v2; int v3; };
struct __attribute__((packed)) aI_Sf_Ip { int v1; empty v2; int * v3; };
struct __attribute__((packed)) aI_Sf_L { int v1; empty v2; long long v3; };
struct __attribute__((packed)) aI_Sf_S { int v1; empty v2; short v3; };
struct __attribute__((packed)) aI_Sf_Sf { int v1; empty v2; empty v3; };
struct __attribute__((packed)) aI_Sf_Uc { int v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aI_Sf_Ui { int v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aI_Sf_Ul { int v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Sf_Us { int v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aI_Sf_Vp { int v1; empty v2; void * v3; };
struct __attribute__((packed)) aI_Uc_Sf { int v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aI_Ui_Sf { int v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aI_Ul_Sf { int v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aI_Us_Sf { int v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aI_Vp_Sf { int v1; void * v2; empty v3; };
struct __attribute__((packed)) aIp_BFu15i_Sf { int * v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aIp_BFu15ll_Sf { int * v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aIp_BFu15s_Sf { int * v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aIp_BFu16i_Sf { int * v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aIp_BFu16ll_Sf { int * v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aIp_BFu16s_Sf { int * v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aIp_BFu17i_Sf { int * v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aIp_BFu17ll_Sf { int * v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aIp_BFu1c_Sf { int * v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aIp_BFu1i_Sf { int * v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aIp_BFu1ll_Sf { int * v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aIp_BFu1s_Sf { int * v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aIp_BFu31i_Sf { int * v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aIp_BFu31ll_Sf { int * v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aIp_BFu32i_Sf { int * v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aIp_BFu32ll_Sf { int * v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aIp_BFu33_Sf { int * v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aIp_BFu7c_Sf { int * v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aIp_BFu7i_Sf { int * v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aIp_BFu7ll_Sf { int * v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aIp_BFu7s_Sf { int * v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aIp_BFu8c_Sf { int * v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aIp_BFu8i_Sf { int * v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aIp_BFu8ll_Sf { int * v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aIp_BFu8s_Sf { int * v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aIp_BFu9i_Sf { int * v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aIp_BFu9ll_Sf { int * v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aIp_BFu9s_Sf { int * v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aIp_C_Sf { int * v1; char v2; empty v3; };
struct __attribute__((packed)) aIp_D_Sf { int * v1; double v2; empty v3; };
struct __attribute__((packed)) aIp_F_Sf { int * v1; float v2; empty v3; };
struct __attribute__((packed)) aIp_I_Sf { int * v1; int v2; empty v3; };
struct __attribute__((packed)) aIp_Ip_Sf { int * v1; int * v2; empty v3; };
struct __attribute__((packed)) aIp_L_Sf { int * v1; long long v2; empty v3; };
struct __attribute__((packed)) aIp_S_Sf { int * v1; short v2; empty v3; };
struct __attribute__((packed)) aIp_Sf { int * v1; empty v2; };
struct __attribute__((packed)) aIp_Sf_BFu15i { int * v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Sf_BFu15ll { int * v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Sf_BFu15s { int * v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Sf_BFu16i { int * v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Sf_BFu16ll { int * v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Sf_BFu16s { int * v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Sf_BFu17i { int * v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Sf_BFu17ll { int * v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Sf_BFu1c { int * v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Sf_BFu1i { int * v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Sf_BFu1ll { int * v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Sf_BFu1s { int * v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Sf_BFu31i { int * v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Sf_BFu31ll { int * v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Sf_BFu32i { int * v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Sf_BFu32ll { int * v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Sf_BFu33 { int * v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Sf_BFu7c { int * v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Sf_BFu7i { int * v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Sf_BFu7ll { int * v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Sf_BFu7s { int * v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Sf_BFu8c { int * v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Sf_BFu8i { int * v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Sf_BFu8ll { int * v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Sf_BFu8s { int * v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Sf_BFu9i { int * v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Sf_BFu9ll { int * v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Sf_BFu9s { int * v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Sf_C { int * v1; empty v2; char v3; };
struct __attribute__((packed)) aIp_Sf_D { int * v1; empty v2; double v3; };
struct __attribute__((packed)) aIp_Sf_F { int * v1; empty v2; float v3; };
struct __attribute__((packed)) aIp_Sf_I { int * v1; empty v2; int v3; };
struct __attribute__((packed)) aIp_Sf_Ip { int * v1; empty v2; int * v3; };
struct __attribute__((packed)) aIp_Sf_L { int * v1; empty v2; long long v3; };
struct __attribute__((packed)) aIp_Sf_S { int * v1; empty v2; short v3; };
struct __attribute__((packed)) aIp_Sf_Sf { int * v1; empty v2; empty v3; };
struct __attribute__((packed)) aIp_Sf_Uc { int * v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Sf_Ui { int * v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Sf_Ul { int * v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Sf_Us { int * v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Sf_Vp { int * v1; empty v2; void * v3; };
struct __attribute__((packed)) aIp_Uc_Sf { int * v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aIp_Ui_Sf { int * v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aIp_Ul_Sf { int * v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aIp_Us_Sf { int * v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aIp_Vp_Sf { int * v1; void * v2; empty v3; };
struct __attribute__((packed)) aL_BFu15i_Sf { long long v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aL_BFu15ll_Sf { long long v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aL_BFu15s_Sf { long long v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aL_BFu16i_Sf { long long v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aL_BFu16ll_Sf { long long v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aL_BFu16s_Sf { long long v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aL_BFu17i_Sf { long long v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aL_BFu17ll_Sf { long long v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aL_BFu1c_Sf { long long v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aL_BFu1i_Sf { long long v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aL_BFu1ll_Sf { long long v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aL_BFu1s_Sf { long long v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aL_BFu31i_Sf { long long v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aL_BFu31ll_Sf { long long v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aL_BFu32i_Sf { long long v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aL_BFu32ll_Sf { long long v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aL_BFu33_Sf { long long v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aL_BFu7c_Sf { long long v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aL_BFu7i_Sf { long long v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aL_BFu7ll_Sf { long long v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aL_BFu7s_Sf { long long v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aL_BFu8c_Sf { long long v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aL_BFu8i_Sf { long long v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aL_BFu8ll_Sf { long long v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aL_BFu8s_Sf { long long v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aL_BFu9i_Sf { long long v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aL_BFu9ll_Sf { long long v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aL_BFu9s_Sf { long long v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aL_C_Sf { long long v1; char v2; empty v3; };
struct __attribute__((packed)) aL_D_Sf { long long v1; double v2; empty v3; };
struct __attribute__((packed)) aL_F_Sf { long long v1; float v2; empty v3; };
struct __attribute__((packed)) aL_I_Sf { long long v1; int v2; empty v3; };
struct __attribute__((packed)) aL_Ip_Sf { long long v1; int * v2; empty v3; };
struct __attribute__((packed)) aL_L_Sf { long long v1; long long v2; empty v3; };
struct __attribute__((packed)) aL_S_Sf { long long v1; short v2; empty v3; };
struct __attribute__((packed)) aL_Sf { long long v1; empty v2; };
struct __attribute__((packed)) aL_Sf_BFu15i { long long v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Sf_BFu15ll { long long v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Sf_BFu15s { long long v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_Sf_BFu16i { long long v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Sf_BFu16ll { long long v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Sf_BFu16s { long long v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Sf_BFu17i { long long v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Sf_BFu17ll { long long v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Sf_BFu1c { long long v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Sf_BFu1i { long long v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Sf_BFu1ll { long long v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Sf_BFu1s { long long v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Sf_BFu31i { long long v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Sf_BFu31ll { long long v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Sf_BFu32i { long long v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Sf_BFu32ll { long long v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Sf_BFu33 { long long v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Sf_BFu7c { long long v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Sf_BFu7i { long long v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Sf_BFu7ll { long long v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Sf_BFu7s { long long v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Sf_BFu8c { long long v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Sf_BFu8i { long long v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Sf_BFu8ll { long long v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Sf_BFu8s { long long v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Sf_BFu9i { long long v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Sf_BFu9ll { long long v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Sf_BFu9s { long long v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Sf_C { long long v1; empty v2; char v3; };
struct __attribute__((packed)) aL_Sf_D { long long v1; empty v2; double v3; };
struct __attribute__((packed)) aL_Sf_F { long long v1; empty v2; float v3; };
struct __attribute__((packed)) aL_Sf_I { long long v1; empty v2; int v3; };
struct __attribute__((packed)) aL_Sf_Ip { long long v1; empty v2; int * v3; };
struct __attribute__((packed)) aL_Sf_L { long long v1; empty v2; long long v3; };
struct __attribute__((packed)) aL_Sf_S { long long v1; empty v2; short v3; };
struct __attribute__((packed)) aL_Sf_Sf { long long v1; empty v2; empty v3; };
struct __attribute__((packed)) aL_Sf_Uc { long long v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aL_Sf_Ui { long long v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aL_Sf_Ul { long long v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Sf_Us { long long v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aL_Sf_Vp { long long v1; empty v2; void * v3; };
struct __attribute__((packed)) aL_Uc_Sf { long long v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aL_Ui_Sf { long long v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aL_Ul_Sf { long long v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aL_Us_Sf { long long v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aL_Vp_Sf { long long v1; void * v2; empty v3; };
struct __attribute__((packed)) aS_BFu15i_Sf { short v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aS_BFu15ll_Sf { short v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aS_BFu15s_Sf { short v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aS_BFu16i_Sf { short v1; unsigned int v2:16; empty v3; };
struct __attribute__((packed)) aS_BFu16ll_Sf { short v1; unsigned long long v2:16; empty v3; };
struct __attribute__((packed)) aS_BFu16s_Sf { short v1; unsigned short v2:16; empty v3; };
struct __attribute__((packed)) aS_BFu17i_Sf { short v1; unsigned int v2:17; empty v3; };
struct __attribute__((packed)) aS_BFu17ll_Sf { short v1; unsigned long long v2:17; empty v3; };
struct __attribute__((packed)) aS_BFu1c_Sf { short v1; unsigned char v2:1; empty v3; };
struct __attribute__((packed)) aS_BFu1i_Sf { short v1; unsigned int v2:1; empty v3; };
struct __attribute__((packed)) aS_BFu1ll_Sf { short v1; unsigned long long v2:1; empty v3; };
struct __attribute__((packed)) aS_BFu1s_Sf { short v1; unsigned short v2:1; empty v3; };
struct __attribute__((packed)) aS_BFu31i_Sf { short v1; unsigned int v2:31; empty v3; };
struct __attribute__((packed)) aS_BFu31ll_Sf { short v1; unsigned long long v2:31; empty v3; };
struct __attribute__((packed)) aS_BFu32i_Sf { short v1; unsigned int v2:32; empty v3; };
struct __attribute__((packed)) aS_BFu32ll_Sf { short v1; unsigned long long v2:32; empty v3; };
struct __attribute__((packed)) aS_BFu33_Sf { short v1; unsigned long long v2:33; empty v3; };
struct __attribute__((packed)) aS_BFu7c_Sf { short v1; unsigned char v2:7; empty v3; };
struct __attribute__((packed)) aS_BFu7i_Sf { short v1; unsigned int v2:7; empty v3; };
struct __attribute__((packed)) aS_BFu7ll_Sf { short v1; unsigned long long v2:7; empty v3; };
struct __attribute__((packed)) aS_BFu7s_Sf { short v1; unsigned short v2:7; empty v3; };
struct __attribute__((packed)) aS_BFu8c_Sf { short v1; unsigned char v2:8; empty v3; };
struct __attribute__((packed)) aS_BFu8i_Sf { short v1; unsigned int v2:8; empty v3; };
struct __attribute__((packed)) aS_BFu8ll_Sf { short v1; unsigned long long v2:8; empty v3; };
struct __attribute__((packed)) aS_BFu8s_Sf { short v1; unsigned short v2:8; empty v3; };
struct __attribute__((packed)) aS_BFu9i_Sf { short v1; unsigned int v2:9; empty v3; };
struct __attribute__((packed)) aS_BFu9ll_Sf { short v1; unsigned long long v2:9; empty v3; };
struct __attribute__((packed)) aS_BFu9s_Sf { short v1; unsigned short v2:9; empty v3; };
struct __attribute__((packed)) aS_C_Sf { short v1; char v2; empty v3; };
struct __attribute__((packed)) aS_D_Sf { short v1; double v2; empty v3; };
struct __attribute__((packed)) aS_F_Sf { short v1; float v2; empty v3; };
struct __attribute__((packed)) aS_I_Sf { short v1; int v2; empty v3; };
struct __attribute__((packed)) aS_Ip_Sf { short v1; int * v2; empty v3; };
struct __attribute__((packed)) aS_L_Sf { short v1; long long v2; empty v3; };
struct __attribute__((packed)) aS_S_Sf { short v1; short v2; empty v3; };
struct __attribute__((packed)) aS_Sf { short v1; empty v2; };
struct __attribute__((packed)) aS_Sf_BFu15i { short v1; empty v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Sf_BFu15ll { short v1; empty v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Sf_BFu15s { short v1; empty v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Sf_BFu16i { short v1; empty v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Sf_BFu16ll { short v1; empty v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Sf_BFu16s { short v1; empty v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Sf_BFu17i { short v1; empty v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Sf_BFu17ll { short v1; empty v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Sf_BFu1c { short v1; empty v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Sf_BFu1i { short v1; empty v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Sf_BFu1ll { short v1; empty v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Sf_BFu1s { short v1; empty v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Sf_BFu31i { short v1; empty v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Sf_BFu31ll { short v1; empty v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Sf_BFu32i { short v1; empty v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Sf_BFu32ll { short v1; empty v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Sf_BFu33 { short v1; empty v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Sf_BFu7c { short v1; empty v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Sf_BFu7i { short v1; empty v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Sf_BFu7ll { short v1; empty v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Sf_BFu7s { short v1; empty v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Sf_BFu8c { short v1; empty v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Sf_BFu8i { short v1; empty v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Sf_BFu8ll { short v1; empty v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Sf_BFu8s { short v1; empty v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Sf_BFu9i { short v1; empty v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Sf_BFu9ll { short v1; empty v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Sf_BFu9s { short v1; empty v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Sf_C { short v1; empty v2; char v3; };
struct __attribute__((packed)) aS_Sf_D { short v1; empty v2; double v3; };
struct __attribute__((packed)) aS_Sf_F { short v1; empty v2; float v3; };
struct __attribute__((packed)) aS_Sf_I { short v1; empty v2; int v3; };
struct __attribute__((packed)) aS_Sf_Ip { short v1; empty v2; int * v3; };
struct __attribute__((packed)) aS_Sf_L { short v1; empty v2; long long v3; };
struct __attribute__((packed)) aS_Sf_S { short v1; empty v2; short v3; };
struct __attribute__((packed)) aS_Sf_Sf { short v1; empty v2; empty v3; };
struct __attribute__((packed)) aS_Sf_Uc { short v1; empty v2; unsigned char v3; };
struct __attribute__((packed)) aS_Sf_Ui { short v1; empty v2; unsigned int v3; };
struct __attribute__((packed)) aS_Sf_Ul { short v1; empty v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Sf_Us { short v1; empty v2; unsigned short v3; };
struct __attribute__((packed)) aS_Sf_Vp { short v1; empty v2; void * v3; };
struct __attribute__((packed)) aS_Uc_Sf { short v1; unsigned char v2; empty v3; };
struct __attribute__((packed)) aS_Ui_Sf { short v1; unsigned int v2; empty v3; };
struct __attribute__((packed)) aS_Ul_Sf { short v1; unsigned long long v2; empty v3; };
struct __attribute__((packed)) aS_Us_Sf { short v1; unsigned short v2; empty v3; };
struct __attribute__((packed)) aS_Vp_Sf { short v1; void * v2; empty v3; };
struct __attribute__((packed)) aSf { empty v1; };
struct __attribute__((packed)) aSf_BFu15i { empty v1; unsigned int v2:15; };
struct __attribute__((packed)) aSf_BFu15i_BFu15i { empty v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu15i_BFu15ll { empty v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu15i_BFu15s { empty v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu15i_BFu16i { empty v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu15i_BFu16ll { empty v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu15i_BFu16s { empty v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu15i_BFu17i { empty v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu15i_BFu17ll { empty v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu15i_BFu1c { empty v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu15i_BFu1i { empty v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu15i_BFu1ll { empty v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu15i_BFu1s { empty v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu15i_BFu31i { empty v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu15i_BFu31ll { empty v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu15i_BFu32i { empty v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu15i_BFu32ll { empty v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu15i_BFu33 { empty v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu15i_BFu7c { empty v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu15i_BFu7i { empty v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu15i_BFu7ll { empty v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu15i_BFu7s { empty v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu15i_BFu8c { empty v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu15i_BFu8i { empty v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu15i_BFu8ll { empty v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu15i_BFu8s { empty v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu15i_BFu9i { empty v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu15i_BFu9ll { empty v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu15i_BFu9s { empty v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu15i_C { empty v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aSf_BFu15i_D { empty v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aSf_BFu15i_F { empty v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aSf_BFu15i_I { empty v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aSf_BFu15i_Ip { empty v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aSf_BFu15i_L { empty v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aSf_BFu15i_S { empty v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aSf_BFu15i_Sf { empty v1; unsigned int v2:15; empty v3; };
struct __attribute__((packed)) aSf_BFu15i_Uc { empty v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu15i_Ui { empty v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu15i_Ul { empty v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu15i_Us { empty v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu15i_Vp { empty v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aSf_BFu15ll { empty v1; unsigned long long v2:15; };
struct __attribute__((packed)) aSf_BFu15ll_BFu15i { empty v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu15ll_BFu15ll { empty v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu15ll_BFu15s { empty v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu15ll_BFu16i { empty v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu15ll_BFu16ll { empty v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu15ll_BFu16s { empty v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu15ll_BFu17i { empty v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu15ll_BFu17ll { empty v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu15ll_BFu1c { empty v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu15ll_BFu1i { empty v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu15ll_BFu1ll { empty v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu15ll_BFu1s { empty v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu15ll_BFu31i { empty v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu15ll_BFu31ll { empty v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu15ll_BFu32i { empty v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu15ll_BFu32ll { empty v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu15ll_BFu33 { empty v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu15ll_BFu7c { empty v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu15ll_BFu7i { empty v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu15ll_BFu7ll { empty v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu15ll_BFu7s { empty v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu15ll_BFu8c { empty v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu15ll_BFu8i { empty v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu15ll_BFu8ll { empty v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu15ll_BFu8s { empty v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu15ll_BFu9i { empty v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu15ll_BFu9ll { empty v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu15ll_BFu9s { empty v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu15ll_C { empty v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aSf_BFu15ll_D { empty v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aSf_BFu15ll_F { empty v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aSf_BFu15ll_I { empty v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aSf_BFu15ll_Ip { empty v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aSf_BFu15ll_L { empty v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aSf_BFu15ll_S { empty v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aSf_BFu15ll_Sf { empty v1; unsigned long long v2:15; empty v3; };
struct __attribute__((packed)) aSf_BFu15ll_Uc { empty v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu15ll_Ui { empty v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu15ll_Ul { empty v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu15ll_Us { empty v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu15ll_Vp { empty v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aSf_BFu15s { empty v1; unsigned short v2:15; };
struct __attribute__((packed)) aSf_BFu15s_BFu15i { empty v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu15s_BFu15ll { empty v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aSf_BFu15s_BFu15s { empty v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aSf_BFu15s_BFu16i { empty v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aSf_BFu15s_BFu16ll { empty v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aSf_BFu15s_BFu16s { empty v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aSf_BFu15s_BFu17i { empty v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aSf_BFu15s_BFu17ll { empty v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aSf_BFu15s_BFu1c { empty v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aSf_BFu15s_BFu1i { empty v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aSf_BFu15s_BFu1ll { empty v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aSf_BFu15s_BFu1s { empty v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aSf_BFu15s_BFu31i { empty v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aSf_BFu15s_BFu31ll { empty v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aSf_BFu15s_BFu32i { empty v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aSf_BFu15s_BFu32ll { empty v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aSf_BFu15s_BFu33 { empty v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aSf_BFu15s_BFu7c { empty v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aSf_BFu15s_BFu7i { empty v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aSf_BFu15s_BFu7ll { empty v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aSf_BFu15s_BFu7s { empty v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aSf_BFu15s_BFu8c { empty v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aSf_BFu15s_BFu8i { empty v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aSf_BFu15s_BFu8ll { empty v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aSf_BFu15s_BFu8s { empty v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aSf_BFu15s_BFu9i { empty v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aSf_BFu15s_BFu9ll { empty v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aSf_BFu15s_BFu9s { empty v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aSf_BFu15s_C { empty v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aSf_BFu15s_D { empty v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aSf_BFu15s_F { empty v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aSf_BFu15s_I { empty v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aSf_BFu15s_Ip { empty v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aSf_BFu15s_L { empty v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aSf_BFu15s_S { empty v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aSf_BFu15s_Sf { empty v1; unsigned short v2:15; empty v3; };
struct __attribute__((packed)) aSf_BFu15s_Uc { empty v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aSf_BFu15s_Ui { empty v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aSf_BFu15s_Ul { empty v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aSf_BFu15s_Us { empty v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aSf_BFu15s_Vp { empty v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aSf_BFu16i { empty v1; unsigned int v2:16; };
struct __attribute__((packed)) aSf_BFu16i_BFu15i { empty v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aSf_BFu16i_BFu15ll { empty v1; unsigned int v2:16; unsigned long long v3:15; };


static void Test_empty()
{
  {
    init_simple_test("empty");
    STRUCT_IF_C empty lv;
    check2(sizeof(lv), 0, "sizeof(empty)");
    check2(__alignof__(lv), 1, "__alignof__(empty)");
  }
}
ARRANGE_TO_CALL_ME(Test_empty, empty)
//============================================================================



static void Test_aBFu15i_BFu15i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu15i_Sf");
    static STRUCT_IF_C aBFu15i_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15i_Sf, aBFu15i_BFu15i_Sf)
//============================================================================



static void Test_aBFu15i_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu15ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15ll_Sf, aBFu15i_BFu15ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu15s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu15s_Sf");
    static STRUCT_IF_C aBFu15i_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15i_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu15s_Sf, aBFu15i_BFu15s_Sf)
//============================================================================



static void Test_aBFu15i_BFu16i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu16i_Sf");
    static STRUCT_IF_C aBFu15i_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16i_Sf, aBFu15i_BFu16i_Sf)
//============================================================================



static void Test_aBFu15i_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu16ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16ll_Sf, aBFu15i_BFu16ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu16s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu16s_Sf");
    static STRUCT_IF_C aBFu15i_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15i_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu16s_Sf, aBFu15i_BFu16s_Sf)
//============================================================================



static void Test_aBFu15i_BFu17i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu17i_Sf");
    static STRUCT_IF_C aBFu15i_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17i_Sf, aBFu15i_BFu17i_Sf)
//============================================================================



static void Test_aBFu15i_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu17ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15i_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu17ll_Sf, aBFu15i_BFu17ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu1c_Sf()
{
  {
    init_simple_test("aBFu15i_BFu1c_Sf");
    static STRUCT_IF_C aBFu15i_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "aBFu15i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1c_Sf, aBFu15i_BFu1c_Sf)
//============================================================================



static void Test_aBFu15i_BFu1i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu1i_Sf");
    static STRUCT_IF_C aBFu15i_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "aBFu15i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1i_Sf, aBFu15i_BFu1i_Sf)
//============================================================================



static void Test_aBFu15i_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu1ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu15i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1ll_Sf, aBFu15i_BFu1ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu1s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu1s_Sf");
    static STRUCT_IF_C aBFu15i_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15i_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "aBFu15i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu1s_Sf, aBFu15i_BFu1s_Sf)
//============================================================================



static void Test_aBFu15i_BFu31i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu31i_Sf");
    static STRUCT_IF_C aBFu15i_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu15i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31i_Sf, aBFu15i_BFu31i_Sf)
//============================================================================



static void Test_aBFu15i_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu31ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15i_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu15i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu31ll_Sf, aBFu15i_BFu31ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu32i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu32i_Sf");
    static STRUCT_IF_C aBFu15i_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "aBFu15i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32i_Sf, aBFu15i_BFu32i_Sf)
//============================================================================



static void Test_aBFu15i_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu32ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15i_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu15i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu32ll_Sf, aBFu15i_BFu32ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu33_Sf()
{
  {
    init_simple_test("aBFu15i_BFu33_Sf");
    static STRUCT_IF_C aBFu15i_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15i_BFu33_Sf");
    check_field_offset(lv, v3, 6, "aBFu15i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu33_Sf, aBFu15i_BFu33_Sf)
//============================================================================



static void Test_aBFu15i_BFu7c_Sf()
{
  {
    init_simple_test("aBFu15i_BFu7c_Sf");
    static STRUCT_IF_C aBFu15i_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7c_Sf, aBFu15i_BFu7c_Sf)
//============================================================================



static void Test_aBFu15i_BFu7i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu7i_Sf");
    static STRUCT_IF_C aBFu15i_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7i_Sf, aBFu15i_BFu7i_Sf)
//============================================================================



static void Test_aBFu15i_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu7ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7ll_Sf, aBFu15i_BFu7ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu7s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu7s_Sf");
    static STRUCT_IF_C aBFu15i_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15i_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu7s_Sf, aBFu15i_BFu7s_Sf)
//============================================================================



static void Test_aBFu15i_BFu8c_Sf()
{
  {
    init_simple_test("aBFu15i_BFu8c_Sf");
    static STRUCT_IF_C aBFu15i_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8c_Sf, aBFu15i_BFu8c_Sf)
//============================================================================



static void Test_aBFu15i_BFu8i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu8i_Sf");
    static STRUCT_IF_C aBFu15i_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8i_Sf, aBFu15i_BFu8i_Sf)
//============================================================================



static void Test_aBFu15i_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu8ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8ll_Sf, aBFu15i_BFu8ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu8s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu8s_Sf");
    static STRUCT_IF_C aBFu15i_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15i_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu8s_Sf, aBFu15i_BFu8s_Sf)
//============================================================================



static void Test_aBFu15i_BFu9i_Sf()
{
  {
    init_simple_test("aBFu15i_BFu9i_Sf");
    static STRUCT_IF_C aBFu15i_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9i_Sf, aBFu15i_BFu9i_Sf)
//============================================================================



static void Test_aBFu15i_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu15i_BFu9ll_Sf");
    static STRUCT_IF_C aBFu15i_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9ll_Sf, aBFu15i_BFu9ll_Sf)
//============================================================================



static void Test_aBFu15i_BFu9s_Sf()
{
  {
    init_simple_test("aBFu15i_BFu9s_Sf");
    static STRUCT_IF_C aBFu15i_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15i_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_BFu9s_Sf, aBFu15i_BFu9s_Sf)
//============================================================================



static void Test_aBFu15i_C_Sf()
{
  {
    init_simple_test("aBFu15i_C_Sf");
    static STRUCT_IF_C aBFu15i_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_C_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_C_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu15i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_C_Sf, aBFu15i_C_Sf)
//============================================================================



static void Test_aBFu15i_D_Sf()
{
  {
    init_simple_test("aBFu15i_D_Sf");
    static STRUCT_IF_C aBFu15i_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_D_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_D_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_D_Sf, aBFu15i_D_Sf)
//============================================================================



static void Test_aBFu15i_F_Sf()
{
  {
    init_simple_test("aBFu15i_F_Sf");
    static STRUCT_IF_C aBFu15i_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_F_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_F_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_F_Sf, aBFu15i_F_Sf)
//============================================================================



static void Test_aBFu15i_I_Sf()
{
  {
    init_simple_test("aBFu15i_I_Sf");
    static STRUCT_IF_C aBFu15i_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_I_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_I_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_I_Sf, aBFu15i_I_Sf)
//============================================================================



static void Test_aBFu15i_Ip_Sf()
{
  {
    init_simple_test("aBFu15i_Ip_Sf");
    static STRUCT_IF_C aBFu15i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ip_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu15i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ip_Sf, aBFu15i_Ip_Sf)
//============================================================================



static void Test_aBFu15i_L_Sf()
{
  {
    init_simple_test("aBFu15i_L_Sf");
    static STRUCT_IF_C aBFu15i_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_L_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_L_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_L_Sf, aBFu15i_L_Sf)
//============================================================================



static void Test_aBFu15i_S_Sf()
{
  {
    init_simple_test("aBFu15i_S_Sf");
    static STRUCT_IF_C aBFu15i_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_S_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_S_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu15i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_S_Sf, aBFu15i_S_Sf)
//============================================================================



static void Test_aBFu15i_Sf()
{
  {
    init_simple_test("aBFu15i_Sf");
    static STRUCT_IF_C aBFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf, aBFu15i_Sf)
//============================================================================



static void Test_aBFu15i_Sf_BFu15i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu15i");
    static STRUCT_IF_C aBFu15i_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu15i, aBFu15i_Sf_BFu15i)
//============================================================================



static void Test_aBFu15i_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu15ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu15ll, aBFu15i_Sf_BFu15ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu15s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu15s");
    static STRUCT_IF_C aBFu15i_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu15s, aBFu15i_Sf_BFu15s)
//============================================================================



static void Test_aBFu15i_Sf_BFu16i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu16i");
    static STRUCT_IF_C aBFu15i_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu16i, aBFu15i_Sf_BFu16i)
//============================================================================



static void Test_aBFu15i_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu16ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu16ll, aBFu15i_Sf_BFu16ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu16s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu16s");
    static STRUCT_IF_C aBFu15i_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu16s, aBFu15i_Sf_BFu16s)
//============================================================================



static void Test_aBFu15i_Sf_BFu17i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu17i");
    static STRUCT_IF_C aBFu15i_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu15i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu15i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu15i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu17i, aBFu15i_Sf_BFu17i)
//============================================================================



static void Test_aBFu15i_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu17ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu15i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu15i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu15i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu17ll, aBFu15i_Sf_BFu17ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu1c()
{
  {
    init_simple_test("aBFu15i_Sf_BFu1c");
    static STRUCT_IF_C aBFu15i_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu1c, aBFu15i_Sf_BFu1c)
//============================================================================



static void Test_aBFu15i_Sf_BFu1i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu1i");
    static STRUCT_IF_C aBFu15i_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu1i, aBFu15i_Sf_BFu1i)
//============================================================================



static void Test_aBFu15i_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu1ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu1ll, aBFu15i_Sf_BFu1ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu1s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu1s");
    static STRUCT_IF_C aBFu15i_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu1s, aBFu15i_Sf_BFu1s)
//============================================================================



static void Test_aBFu15i_Sf_BFu31i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu31i");
    static STRUCT_IF_C aBFu15i_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu15i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu15i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu31i, aBFu15i_Sf_BFu31i)
//============================================================================



static void Test_aBFu15i_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu31ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu15i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu15i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu31ll, aBFu15i_Sf_BFu31ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu32i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu32i");
    static STRUCT_IF_C aBFu15i_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu15i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu15i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu32i, aBFu15i_Sf_BFu32i)
//============================================================================



static void Test_aBFu15i_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu32ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu15i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu15i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu32ll, aBFu15i_Sf_BFu32ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu33()
{
  {
    init_simple_test("aBFu15i_Sf_BFu33");
    static STRUCT_IF_C aBFu15i_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu15i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu33");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu15i_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu15i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu33, aBFu15i_Sf_BFu33)
//============================================================================



static void Test_aBFu15i_Sf_BFu7c()
{
  {
    init_simple_test("aBFu15i_Sf_BFu7c");
    static STRUCT_IF_C aBFu15i_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu7c, aBFu15i_Sf_BFu7c)
//============================================================================



static void Test_aBFu15i_Sf_BFu7i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu7i");
    static STRUCT_IF_C aBFu15i_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu7i, aBFu15i_Sf_BFu7i)
//============================================================================



static void Test_aBFu15i_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu7ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu7ll, aBFu15i_Sf_BFu7ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu7s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu7s");
    static STRUCT_IF_C aBFu15i_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu7s, aBFu15i_Sf_BFu7s)
//============================================================================



static void Test_aBFu15i_Sf_BFu8c()
{
  {
    init_simple_test("aBFu15i_Sf_BFu8c");
    static STRUCT_IF_C aBFu15i_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu8c, aBFu15i_Sf_BFu8c)
//============================================================================



static void Test_aBFu15i_Sf_BFu8i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu8i");
    static STRUCT_IF_C aBFu15i_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu8i, aBFu15i_Sf_BFu8i)
//============================================================================



static void Test_aBFu15i_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu8ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu8ll, aBFu15i_Sf_BFu8ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu8s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu8s");
    static STRUCT_IF_C aBFu15i_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu8s, aBFu15i_Sf_BFu8s)
//============================================================================



static void Test_aBFu15i_Sf_BFu9i()
{
  {
    init_simple_test("aBFu15i_Sf_BFu9i");
    static STRUCT_IF_C aBFu15i_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu9i, aBFu15i_Sf_BFu9i)
//============================================================================



static void Test_aBFu15i_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu15i_Sf_BFu9ll");
    static STRUCT_IF_C aBFu15i_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu9ll, aBFu15i_Sf_BFu9ll)
//============================================================================



static void Test_aBFu15i_Sf_BFu9s()
{
  {
    init_simple_test("aBFu15i_Sf_BFu9s");
    static STRUCT_IF_C aBFu15i_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_BFu9s, aBFu15i_Sf_BFu9s)
//============================================================================



static void Test_aBFu15i_Sf_C()
{
  {
    init_simple_test("aBFu15i_Sf_C");
    static STRUCT_IF_C aBFu15i_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_C");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_C.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_C, aBFu15i_Sf_C)
//============================================================================



static void Test_aBFu15i_Sf_D()
{
  {
    init_simple_test("aBFu15i_Sf_D");
    static STRUCT_IF_C aBFu15i_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_D");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_D.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_D, aBFu15i_Sf_D)
//============================================================================



static void Test_aBFu15i_Sf_F()
{
  {
    init_simple_test("aBFu15i_Sf_F");
    static STRUCT_IF_C aBFu15i_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_F");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_F.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_F, aBFu15i_Sf_F)
//============================================================================



static void Test_aBFu15i_Sf_I()
{
  {
    init_simple_test("aBFu15i_Sf_I");
    static STRUCT_IF_C aBFu15i_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_I");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_I.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_I, aBFu15i_Sf_I)
//============================================================================



static void Test_aBFu15i_Sf_Ip()
{
  {
    init_simple_test("aBFu15i_Sf_Ip");
    static STRUCT_IF_C aBFu15i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Ip");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Ip, aBFu15i_Sf_Ip)
//============================================================================



static void Test_aBFu15i_Sf_L()
{
  {
    init_simple_test("aBFu15i_Sf_L");
    static STRUCT_IF_C aBFu15i_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_L");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_L.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_L, aBFu15i_Sf_L)
//============================================================================



static void Test_aBFu15i_Sf_S()
{
  {
    init_simple_test("aBFu15i_Sf_S");
    static STRUCT_IF_C aBFu15i_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_S");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_S.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_S, aBFu15i_Sf_S)
//============================================================================



static void Test_aBFu15i_Sf_Sf()
{
  {
    init_simple_test("aBFu15i_Sf_Sf");
    static STRUCT_IF_C aBFu15i_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Sf, aBFu15i_Sf_Sf)
//============================================================================



static void Test_aBFu15i_Sf_Uc()
{
  {
    init_simple_test("aBFu15i_Sf_Uc");
    static STRUCT_IF_C aBFu15i_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Uc");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Uc, aBFu15i_Sf_Uc)
//============================================================================



static void Test_aBFu15i_Sf_Ui()
{
  {
    init_simple_test("aBFu15i_Sf_Ui");
    static STRUCT_IF_C aBFu15i_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Ui");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Ui, aBFu15i_Sf_Ui)
//============================================================================



static void Test_aBFu15i_Sf_Ul()
{
  {
    init_simple_test("aBFu15i_Sf_Ul");
    static STRUCT_IF_C aBFu15i_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Ul");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Ul, aBFu15i_Sf_Ul)
//============================================================================



static void Test_aBFu15i_Sf_Us()
{
  {
    init_simple_test("aBFu15i_Sf_Us");
    static STRUCT_IF_C aBFu15i_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Us");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Us, aBFu15i_Sf_Us)
//============================================================================



static void Test_aBFu15i_Sf_Vp()
{
  {
    init_simple_test("aBFu15i_Sf_Vp");
    static STRUCT_IF_C aBFu15i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Sf_Vp");
    check_field_offset(lv, v2, 2, "aBFu15i_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu15i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Sf_Vp, aBFu15i_Sf_Vp)
//============================================================================



static void Test_aBFu15i_Uc_Sf()
{
  {
    init_simple_test("aBFu15i_Uc_Sf");
    static STRUCT_IF_C aBFu15i_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Uc_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu15i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Uc_Sf, aBFu15i_Uc_Sf)
//============================================================================



static void Test_aBFu15i_Ui_Sf()
{
  {
    init_simple_test("aBFu15i_Ui_Sf");
    static STRUCT_IF_C aBFu15i_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ui_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ui_Sf, aBFu15i_Ui_Sf)
//============================================================================



static void Test_aBFu15i_Ul_Sf()
{
  {
    init_simple_test("aBFu15i_Ul_Sf");
    static STRUCT_IF_C aBFu15i_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Ul_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Ul_Sf, aBFu15i_Ul_Sf)
//============================================================================



static void Test_aBFu15i_Us_Sf()
{
  {
    init_simple_test("aBFu15i_Us_Sf");
    static STRUCT_IF_C aBFu15i_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Us_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu15i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Us_Sf, aBFu15i_Us_Sf)
//============================================================================



static void Test_aBFu15i_Vp_Sf()
{
  {
    init_simple_test("aBFu15i_Vp_Sf");
    static STRUCT_IF_C aBFu15i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15i_Vp_Sf");
    check_field_offset(lv, v2, 2, "aBFu15i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu15i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15i_Vp_Sf, aBFu15i_Vp_Sf)
//============================================================================



static void Test_aBFu15ll_BFu15i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu15i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15i_Sf, aBFu15ll_BFu15i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu15ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15ll_Sf, aBFu15ll_BFu15ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu15s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu15s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15ll_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu15s_Sf, aBFu15ll_BFu15s_Sf)
//============================================================================



static void Test_aBFu15ll_BFu16i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu16i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16i_Sf, aBFu15ll_BFu16i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu16ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16ll_Sf, aBFu15ll_BFu16ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu16s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu16s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15ll_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu16s_Sf, aBFu15ll_BFu16s_Sf)
//============================================================================



static void Test_aBFu15ll_BFu17i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu17i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15ll_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu17i_Sf, aBFu15ll_BFu17i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu17ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu17ll_Sf, aBFu15ll_BFu17ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu1c_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu1c_Sf");
    static STRUCT_IF_C aBFu15ll_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15ll_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "aBFu15ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu1c_Sf, aBFu15ll_BFu1c_Sf)
//============================================================================



static void Test_aBFu15ll_BFu1i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu1i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15ll_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "aBFu15ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu1i_Sf, aBFu15ll_BFu1i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu1ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu15ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu1ll_Sf, aBFu15ll_BFu1ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu1s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu1s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15ll_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "aBFu15ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu1s_Sf, aBFu15ll_BFu1s_Sf)
//============================================================================



static void Test_aBFu15ll_BFu31i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu31i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15ll_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu15ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu31i_Sf, aBFu15ll_BFu31i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu31ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu15ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu31ll_Sf, aBFu15ll_BFu31ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu32i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu32i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15ll_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "aBFu15ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu32i_Sf, aBFu15ll_BFu32i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu32ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu15ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu32ll_Sf, aBFu15ll_BFu32ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu33_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu33_Sf");
    static STRUCT_IF_C aBFu15ll_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15ll_BFu33_Sf");
    check_field_offset(lv, v3, 6, "aBFu15ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu33_Sf, aBFu15ll_BFu33_Sf)
//============================================================================



static void Test_aBFu15ll_BFu7c_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu7c_Sf");
    static STRUCT_IF_C aBFu15ll_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15ll_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu7c_Sf, aBFu15ll_BFu7c_Sf)
//============================================================================



static void Test_aBFu15ll_BFu7i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu7i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15ll_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu7i_Sf, aBFu15ll_BFu7i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu7ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu7ll_Sf, aBFu15ll_BFu7ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu7s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu7s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15ll_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu7s_Sf, aBFu15ll_BFu7s_Sf)
//============================================================================



static void Test_aBFu15ll_BFu8c_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu8c_Sf");
    static STRUCT_IF_C aBFu15ll_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15ll_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu8c_Sf, aBFu15ll_BFu8c_Sf)
//============================================================================



static void Test_aBFu15ll_BFu8i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu8i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15ll_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu8i_Sf, aBFu15ll_BFu8i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu8ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu8ll_Sf, aBFu15ll_BFu8ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu8s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu8s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15ll_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu8s_Sf, aBFu15ll_BFu8s_Sf)
//============================================================================



static void Test_aBFu15ll_BFu9i_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu9i_Sf");
    static STRUCT_IF_C aBFu15ll_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15ll_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu9i_Sf, aBFu15ll_BFu9i_Sf)
//============================================================================



static void Test_aBFu15ll_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu9ll_Sf");
    static STRUCT_IF_C aBFu15ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu9ll_Sf, aBFu15ll_BFu9ll_Sf)
//============================================================================



static void Test_aBFu15ll_BFu9s_Sf()
{
  {
    init_simple_test("aBFu15ll_BFu9s_Sf");
    static STRUCT_IF_C aBFu15ll_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15ll_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_BFu9s_Sf, aBFu15ll_BFu9s_Sf)
//============================================================================



static void Test_aBFu15ll_C_Sf()
{
  {
    init_simple_test("aBFu15ll_C_Sf");
    static STRUCT_IF_C aBFu15ll_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_C_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_C_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu15ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_C_Sf, aBFu15ll_C_Sf)
//============================================================================



static void Test_aBFu15ll_D_Sf()
{
  {
    init_simple_test("aBFu15ll_D_Sf");
    static STRUCT_IF_C aBFu15ll_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_D_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_D_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_D_Sf, aBFu15ll_D_Sf)
//============================================================================



static void Test_aBFu15ll_F_Sf()
{
  {
    init_simple_test("aBFu15ll_F_Sf");
    static STRUCT_IF_C aBFu15ll_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_F_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_F_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_F_Sf, aBFu15ll_F_Sf)
//============================================================================



static void Test_aBFu15ll_I_Sf()
{
  {
    init_simple_test("aBFu15ll_I_Sf");
    static STRUCT_IF_C aBFu15ll_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_I_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_I_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_I_Sf, aBFu15ll_I_Sf)
//============================================================================



static void Test_aBFu15ll_Ip_Sf()
{
  {
    init_simple_test("aBFu15ll_Ip_Sf");
    static STRUCT_IF_C aBFu15ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Ip_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu15ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Ip_Sf, aBFu15ll_Ip_Sf)
//============================================================================



static void Test_aBFu15ll_L_Sf()
{
  {
    init_simple_test("aBFu15ll_L_Sf");
    static STRUCT_IF_C aBFu15ll_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_L_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_L_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_L_Sf, aBFu15ll_L_Sf)
//============================================================================



static void Test_aBFu15ll_S_Sf()
{
  {
    init_simple_test("aBFu15ll_S_Sf");
    static STRUCT_IF_C aBFu15ll_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_S_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_S_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu15ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_S_Sf, aBFu15ll_S_Sf)
//============================================================================



static void Test_aBFu15ll_Sf()
{
  {
    init_simple_test("aBFu15ll_Sf");
    static STRUCT_IF_C aBFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf, aBFu15ll_Sf)
//============================================================================



static void Test_aBFu15ll_Sf_BFu15i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu15i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu15i, aBFu15ll_Sf_BFu15i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu15ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu15ll, aBFu15ll_Sf_BFu15ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu15s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu15s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu15s, aBFu15ll_Sf_BFu15s)
//============================================================================



static void Test_aBFu15ll_Sf_BFu16i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu16i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu16i, aBFu15ll_Sf_BFu16i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu16ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu16ll, aBFu15ll_Sf_BFu16ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu16s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu16s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu16s, aBFu15ll_Sf_BFu16s)
//============================================================================



static void Test_aBFu15ll_Sf_BFu17i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu17i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu15ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu15ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu15ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu17i, aBFu15ll_Sf_BFu17i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu17ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu15ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu15ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu15ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu17ll, aBFu15ll_Sf_BFu17ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu1c()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu1c");
    static STRUCT_IF_C aBFu15ll_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu1c, aBFu15ll_Sf_BFu1c)
//============================================================================



static void Test_aBFu15ll_Sf_BFu1i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu1i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu1i, aBFu15ll_Sf_BFu1i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu1ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu1ll, aBFu15ll_Sf_BFu1ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu1s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu1s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu1s, aBFu15ll_Sf_BFu1s)
//============================================================================



static void Test_aBFu15ll_Sf_BFu31i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu31i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu15ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu15ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu31i, aBFu15ll_Sf_BFu31i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu31ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu15ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu15ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu31ll, aBFu15ll_Sf_BFu31ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu32i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu32i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu15ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu15ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu32i, aBFu15ll_Sf_BFu32i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu32ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu15ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu15ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu32ll, aBFu15ll_Sf_BFu32ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu33()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu33");
    static STRUCT_IF_C aBFu15ll_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu15ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu33");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu15ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu15ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu33, aBFu15ll_Sf_BFu33)
//============================================================================



static void Test_aBFu15ll_Sf_BFu7c()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu7c");
    static STRUCT_IF_C aBFu15ll_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu7c, aBFu15ll_Sf_BFu7c)
//============================================================================



static void Test_aBFu15ll_Sf_BFu7i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu7i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu7i, aBFu15ll_Sf_BFu7i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu7ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu7ll, aBFu15ll_Sf_BFu7ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu7s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu7s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu7s, aBFu15ll_Sf_BFu7s)
//============================================================================



static void Test_aBFu15ll_Sf_BFu8c()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu8c");
    static STRUCT_IF_C aBFu15ll_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu8c, aBFu15ll_Sf_BFu8c)
//============================================================================



static void Test_aBFu15ll_Sf_BFu8i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu8i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu8i, aBFu15ll_Sf_BFu8i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu8ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu8ll, aBFu15ll_Sf_BFu8ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu8s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu8s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu8s, aBFu15ll_Sf_BFu8s)
//============================================================================



static void Test_aBFu15ll_Sf_BFu9i()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu9i");
    static STRUCT_IF_C aBFu15ll_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu9i, aBFu15ll_Sf_BFu9i)
//============================================================================



static void Test_aBFu15ll_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu9ll");
    static STRUCT_IF_C aBFu15ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu9ll, aBFu15ll_Sf_BFu9ll)
//============================================================================



static void Test_aBFu15ll_Sf_BFu9s()
{
  {
    init_simple_test("aBFu15ll_Sf_BFu9s");
    static STRUCT_IF_C aBFu15ll_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_BFu9s, aBFu15ll_Sf_BFu9s)
//============================================================================



static void Test_aBFu15ll_Sf_C()
{
  {
    init_simple_test("aBFu15ll_Sf_C");
    static STRUCT_IF_C aBFu15ll_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_C");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_C.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_C, aBFu15ll_Sf_C)
//============================================================================



static void Test_aBFu15ll_Sf_D()
{
  {
    init_simple_test("aBFu15ll_Sf_D");
    static STRUCT_IF_C aBFu15ll_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_D");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_D.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_D, aBFu15ll_Sf_D)
//============================================================================



static void Test_aBFu15ll_Sf_F()
{
  {
    init_simple_test("aBFu15ll_Sf_F");
    static STRUCT_IF_C aBFu15ll_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_F");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_F.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_F, aBFu15ll_Sf_F)
//============================================================================



static void Test_aBFu15ll_Sf_I()
{
  {
    init_simple_test("aBFu15ll_Sf_I");
    static STRUCT_IF_C aBFu15ll_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_I");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_I.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_I, aBFu15ll_Sf_I)
//============================================================================



static void Test_aBFu15ll_Sf_Ip()
{
  {
    init_simple_test("aBFu15ll_Sf_Ip");
    static STRUCT_IF_C aBFu15ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Ip");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Ip, aBFu15ll_Sf_Ip)
//============================================================================



static void Test_aBFu15ll_Sf_L()
{
  {
    init_simple_test("aBFu15ll_Sf_L");
    static STRUCT_IF_C aBFu15ll_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_L");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_L.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_L, aBFu15ll_Sf_L)
//============================================================================



static void Test_aBFu15ll_Sf_S()
{
  {
    init_simple_test("aBFu15ll_Sf_S");
    static STRUCT_IF_C aBFu15ll_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_S");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_S.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_S, aBFu15ll_Sf_S)
//============================================================================



static void Test_aBFu15ll_Sf_Sf()
{
  {
    init_simple_test("aBFu15ll_Sf_Sf");
    static STRUCT_IF_C aBFu15ll_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Sf, aBFu15ll_Sf_Sf)
//============================================================================



static void Test_aBFu15ll_Sf_Uc()
{
  {
    init_simple_test("aBFu15ll_Sf_Uc");
    static STRUCT_IF_C aBFu15ll_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Uc");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Uc, aBFu15ll_Sf_Uc)
//============================================================================



static void Test_aBFu15ll_Sf_Ui()
{
  {
    init_simple_test("aBFu15ll_Sf_Ui");
    static STRUCT_IF_C aBFu15ll_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Ui");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Ui, aBFu15ll_Sf_Ui)
//============================================================================



static void Test_aBFu15ll_Sf_Ul()
{
  {
    init_simple_test("aBFu15ll_Sf_Ul");
    static STRUCT_IF_C aBFu15ll_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Ul");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Ul, aBFu15ll_Sf_Ul)
//============================================================================



static void Test_aBFu15ll_Sf_Us()
{
  {
    init_simple_test("aBFu15ll_Sf_Us");
    static STRUCT_IF_C aBFu15ll_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Us");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Us, aBFu15ll_Sf_Us)
//============================================================================



static void Test_aBFu15ll_Sf_Vp()
{
  {
    init_simple_test("aBFu15ll_Sf_Vp");
    static STRUCT_IF_C aBFu15ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Sf_Vp");
    check_field_offset(lv, v2, 2, "aBFu15ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu15ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Sf_Vp, aBFu15ll_Sf_Vp)
//============================================================================



static void Test_aBFu15ll_Uc_Sf()
{
  {
    init_simple_test("aBFu15ll_Uc_Sf");
    static STRUCT_IF_C aBFu15ll_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Uc_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu15ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Uc_Sf, aBFu15ll_Uc_Sf)
//============================================================================



static void Test_aBFu15ll_Ui_Sf()
{
  {
    init_simple_test("aBFu15ll_Ui_Sf");
    static STRUCT_IF_C aBFu15ll_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Ui_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Ui_Sf, aBFu15ll_Ui_Sf)
//============================================================================



static void Test_aBFu15ll_Ul_Sf()
{
  {
    init_simple_test("aBFu15ll_Ul_Sf");
    static STRUCT_IF_C aBFu15ll_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Ul_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Ul_Sf, aBFu15ll_Ul_Sf)
//============================================================================



static void Test_aBFu15ll_Us_Sf()
{
  {
    init_simple_test("aBFu15ll_Us_Sf");
    static STRUCT_IF_C aBFu15ll_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Us_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu15ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Us_Sf, aBFu15ll_Us_Sf)
//============================================================================



static void Test_aBFu15ll_Vp_Sf()
{
  {
    init_simple_test("aBFu15ll_Vp_Sf");
    static STRUCT_IF_C aBFu15ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15ll_Vp_Sf");
    check_field_offset(lv, v2, 2, "aBFu15ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu15ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15ll_Vp_Sf, aBFu15ll_Vp_Sf)
//============================================================================



static void Test_aBFu15s_BFu15i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu15i_Sf");
    static STRUCT_IF_C aBFu15s_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15s_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu15i_Sf, aBFu15s_BFu15i_Sf)
//============================================================================



static void Test_aBFu15s_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu15ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15s_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu15ll_Sf, aBFu15s_BFu15ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu15s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu15s_Sf");
    static STRUCT_IF_C aBFu15s_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "aBFu15s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "aBFu15s_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu15s_Sf, aBFu15s_BFu15s_Sf)
//============================================================================



static void Test_aBFu15s_BFu16i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu16i_Sf");
    static STRUCT_IF_C aBFu15s_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15s_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu16i_Sf, aBFu15s_BFu16i_Sf)
//============================================================================



static void Test_aBFu15s_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu16ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15s_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu16ll_Sf, aBFu15s_BFu16ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu16s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu16s_Sf");
    static STRUCT_IF_C aBFu15s_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "aBFu15s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "aBFu15s_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu16s_Sf, aBFu15s_BFu16s_Sf)
//============================================================================



static void Test_aBFu15s_BFu17i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu17i_Sf");
    static STRUCT_IF_C aBFu15s_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15s_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu17i_Sf, aBFu15s_BFu17i_Sf)
//============================================================================



static void Test_aBFu15s_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu17ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu17ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "aBFu15s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "aBFu15s_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu15s_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu17ll_Sf, aBFu15s_BFu17ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu1c_Sf()
{
  {
    init_simple_test("aBFu15s_BFu1c_Sf");
    static STRUCT_IF_C aBFu15s_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15s_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "aBFu15s_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu1c_Sf, aBFu15s_BFu1c_Sf)
//============================================================================



static void Test_aBFu15s_BFu1i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu1i_Sf");
    static STRUCT_IF_C aBFu15s_BFu1i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15s_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "aBFu15s_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu1i_Sf, aBFu15s_BFu1i_Sf)
//============================================================================



static void Test_aBFu15s_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu1ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu1ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15s_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu15s_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu1ll_Sf, aBFu15s_BFu1ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu1s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu1s_Sf");
    static STRUCT_IF_C aBFu15s_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "aBFu15s_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "aBFu15s_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu1s_Sf, aBFu15s_BFu1s_Sf)
//============================================================================



static void Test_aBFu15s_BFu31i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu31i_Sf");
    static STRUCT_IF_C aBFu15s_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15s_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu15s_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu31i_Sf, aBFu15s_BFu31i_Sf)
//============================================================================



static void Test_aBFu15s_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu31ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "aBFu15s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "aBFu15s_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu15s_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu31ll_Sf, aBFu15s_BFu31ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu32i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu32i_Sf");
    static STRUCT_IF_C aBFu15s_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15s_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "aBFu15s_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu32i_Sf, aBFu15s_BFu32i_Sf)
//============================================================================



static void Test_aBFu15s_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu32ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "aBFu15s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "aBFu15s_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu15s_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu32ll_Sf, aBFu15s_BFu32ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu33_Sf()
{
  {
    init_simple_test("aBFu15s_BFu33_Sf");
    static STRUCT_IF_C aBFu15s_BFu33_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "aBFu15s_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "aBFu15s_BFu33_Sf");
    check_field_offset(lv, v3, 6, "aBFu15s_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu33_Sf, aBFu15s_BFu33_Sf)
//============================================================================



static void Test_aBFu15s_BFu7c_Sf()
{
  {
    init_simple_test("aBFu15s_BFu7c_Sf");
    static STRUCT_IF_C aBFu15s_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15s_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu7c_Sf, aBFu15s_BFu7c_Sf)
//============================================================================



static void Test_aBFu15s_BFu7i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu7i_Sf");
    static STRUCT_IF_C aBFu15s_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15s_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu7i_Sf, aBFu15s_BFu7i_Sf)
//============================================================================



static void Test_aBFu15s_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu7ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15s_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu7ll_Sf, aBFu15s_BFu7ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu7s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu7s_Sf");
    static STRUCT_IF_C aBFu15s_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "aBFu15s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "aBFu15s_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu7s_Sf, aBFu15s_BFu7s_Sf)
//============================================================================



static void Test_aBFu15s_BFu8c_Sf()
{
  {
    init_simple_test("aBFu15s_BFu8c_Sf");
    static STRUCT_IF_C aBFu15s_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15s_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu8c_Sf, aBFu15s_BFu8c_Sf)
//============================================================================



static void Test_aBFu15s_BFu8i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu8i_Sf");
    static STRUCT_IF_C aBFu15s_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15s_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu8i_Sf, aBFu15s_BFu8i_Sf)
//============================================================================



static void Test_aBFu15s_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu8ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15s_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu8ll_Sf, aBFu15s_BFu8ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu8s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu8s_Sf");
    static STRUCT_IF_C aBFu15s_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "aBFu15s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "aBFu15s_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu8s_Sf, aBFu15s_BFu8s_Sf)
//============================================================================



static void Test_aBFu15s_BFu9i_Sf()
{
  {
    init_simple_test("aBFu15s_BFu9i_Sf");
    static STRUCT_IF_C aBFu15s_BFu9i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15s_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu9i_Sf, aBFu15s_BFu9i_Sf)
//============================================================================



static void Test_aBFu15s_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu15s_BFu9ll_Sf");
    static STRUCT_IF_C aBFu15s_BFu9ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15s_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu9ll_Sf, aBFu15s_BFu9ll_Sf)
//============================================================================



static void Test_aBFu15s_BFu9s_Sf()
{
  {
    init_simple_test("aBFu15s_BFu9s_Sf");
    static STRUCT_IF_C aBFu15s_BFu9s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "aBFu15s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "aBFu15s_BFu9s_Sf");
    check_field_offset(lv, v3, 3, "aBFu15s_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_BFu9s_Sf, aBFu15s_BFu9s_Sf)
//============================================================================



static void Test_aBFu15s_C_Sf()
{
  {
    init_simple_test("aBFu15s_C_Sf");
    static STRUCT_IF_C aBFu15s_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_C_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_C_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu15s_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_C_Sf, aBFu15s_C_Sf)
//============================================================================



static void Test_aBFu15s_D_Sf()
{
  {
    init_simple_test("aBFu15s_D_Sf");
    static STRUCT_IF_C aBFu15s_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15s_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_D_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_D_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15s_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_D_Sf, aBFu15s_D_Sf)
//============================================================================



static void Test_aBFu15s_F_Sf()
{
  {
    init_simple_test("aBFu15s_F_Sf");
    static STRUCT_IF_C aBFu15s_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_F_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_F_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15s_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_F_Sf, aBFu15s_F_Sf)
//============================================================================



static void Test_aBFu15s_I_Sf()
{
  {
    init_simple_test("aBFu15s_I_Sf");
    static STRUCT_IF_C aBFu15s_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_I_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_I_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15s_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_I_Sf, aBFu15s_I_Sf)
//============================================================================



static void Test_aBFu15s_Ip_Sf()
{
  {
    init_simple_test("aBFu15s_Ip_Sf");
    static STRUCT_IF_C aBFu15s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15s_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Ip_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu15s_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Ip_Sf, aBFu15s_Ip_Sf)
//============================================================================



static void Test_aBFu15s_L_Sf()
{
  {
    init_simple_test("aBFu15s_L_Sf");
    static STRUCT_IF_C aBFu15s_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15s_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_L_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_L_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15s_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_L_Sf, aBFu15s_L_Sf)
//============================================================================



static void Test_aBFu15s_S_Sf()
{
  {
    init_simple_test("aBFu15s_S_Sf");
    static STRUCT_IF_C aBFu15s_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_S_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_S_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu15s_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_S_Sf, aBFu15s_S_Sf)
//============================================================================



static void Test_aBFu15s_Sf()
{
  {
    init_simple_test("aBFu15s_Sf");
    static STRUCT_IF_C aBFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf, aBFu15s_Sf)
//============================================================================



static void Test_aBFu15s_Sf_BFu15i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu15i");
    static STRUCT_IF_C aBFu15s_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu15i, aBFu15s_Sf_BFu15i)
//============================================================================



static void Test_aBFu15s_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu15ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu15ll, aBFu15s_Sf_BFu15ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu15s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu15s");
    static STRUCT_IF_C aBFu15s_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu15s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu15s, aBFu15s_Sf_BFu15s)
//============================================================================



static void Test_aBFu15s_Sf_BFu16i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu16i");
    static STRUCT_IF_C aBFu15s_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu16i, aBFu15s_Sf_BFu16i)
//============================================================================



static void Test_aBFu15s_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu16ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu16ll, aBFu15s_Sf_BFu16ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu16s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu16s");
    static STRUCT_IF_C aBFu15s_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu15s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu15s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu16s, aBFu15s_Sf_BFu16s)
//============================================================================



static void Test_aBFu15s_Sf_BFu17i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu17i");
    static STRUCT_IF_C aBFu15s_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu15s_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu15s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu15s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu17i, aBFu15s_Sf_BFu17i)
//============================================================================



static void Test_aBFu15s_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu17ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu15s_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu15s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu15s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu17ll, aBFu15s_Sf_BFu17ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu1c()
{
  {
    init_simple_test("aBFu15s_Sf_BFu1c");
    static STRUCT_IF_C aBFu15s_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu1c, aBFu15s_Sf_BFu1c)
//============================================================================



static void Test_aBFu15s_Sf_BFu1i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu1i");
    static STRUCT_IF_C aBFu15s_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu1i, aBFu15s_Sf_BFu1i)
//============================================================================



static void Test_aBFu15s_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu1ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu1ll, aBFu15s_Sf_BFu1ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu1s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu1s");
    static STRUCT_IF_C aBFu15s_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu15s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu1s, aBFu15s_Sf_BFu1s)
//============================================================================



static void Test_aBFu15s_Sf_BFu31i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu31i");
    static STRUCT_IF_C aBFu15s_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu15s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu15s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu31i, aBFu15s_Sf_BFu31i)
//============================================================================



static void Test_aBFu15s_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu31ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu15s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu15s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu31ll, aBFu15s_Sf_BFu31ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu32i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu32i");
    static STRUCT_IF_C aBFu15s_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu15s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu15s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu32i, aBFu15s_Sf_BFu32i)
//============================================================================



static void Test_aBFu15s_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu32ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu15s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu15s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu32ll, aBFu15s_Sf_BFu32ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu33()
{
  {
    init_simple_test("aBFu15s_Sf_BFu33");
    static STRUCT_IF_C aBFu15s_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu15s_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu33");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu15s_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu15s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu33, aBFu15s_Sf_BFu33)
//============================================================================



static void Test_aBFu15s_Sf_BFu7c()
{
  {
    init_simple_test("aBFu15s_Sf_BFu7c");
    static STRUCT_IF_C aBFu15s_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu7c, aBFu15s_Sf_BFu7c)
//============================================================================



static void Test_aBFu15s_Sf_BFu7i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu7i");
    static STRUCT_IF_C aBFu15s_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu7i, aBFu15s_Sf_BFu7i)
//============================================================================



static void Test_aBFu15s_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu7ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu7ll, aBFu15s_Sf_BFu7ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu7s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu7s");
    static STRUCT_IF_C aBFu15s_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu15s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu15s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu7s, aBFu15s_Sf_BFu7s)
//============================================================================



static void Test_aBFu15s_Sf_BFu8c()
{
  {
    init_simple_test("aBFu15s_Sf_BFu8c");
    static STRUCT_IF_C aBFu15s_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu8c, aBFu15s_Sf_BFu8c)
//============================================================================



static void Test_aBFu15s_Sf_BFu8i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu8i");
    static STRUCT_IF_C aBFu15s_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu8i, aBFu15s_Sf_BFu8i)
//============================================================================



static void Test_aBFu15s_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu8ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu8ll, aBFu15s_Sf_BFu8ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu8s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu8s");
    static STRUCT_IF_C aBFu15s_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu15s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu15s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu8s, aBFu15s_Sf_BFu8s)
//============================================================================



static void Test_aBFu15s_Sf_BFu9i()
{
  {
    init_simple_test("aBFu15s_Sf_BFu9i");
    static STRUCT_IF_C aBFu15s_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu9i, aBFu15s_Sf_BFu9i)
//============================================================================



static void Test_aBFu15s_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu15s_Sf_BFu9ll");
    static STRUCT_IF_C aBFu15s_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu9ll, aBFu15s_Sf_BFu9ll)
//============================================================================



static void Test_aBFu15s_Sf_BFu9s()
{
  {
    init_simple_test("aBFu15s_Sf_BFu9s");
    static STRUCT_IF_C aBFu15s_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu15s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu15s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_BFu9s, aBFu15s_Sf_BFu9s)
//============================================================================



static void Test_aBFu15s_Sf_C()
{
  {
    init_simple_test("aBFu15s_Sf_C");
    static STRUCT_IF_C aBFu15s_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_C");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_C.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_C, aBFu15s_Sf_C)
//============================================================================



static void Test_aBFu15s_Sf_D()
{
  {
    init_simple_test("aBFu15s_Sf_D");
    static STRUCT_IF_C aBFu15s_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15s_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_D");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_D.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_D, aBFu15s_Sf_D)
//============================================================================



static void Test_aBFu15s_Sf_F()
{
  {
    init_simple_test("aBFu15s_Sf_F");
    static STRUCT_IF_C aBFu15s_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_F");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_F.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_F, aBFu15s_Sf_F)
//============================================================================



static void Test_aBFu15s_Sf_I()
{
  {
    init_simple_test("aBFu15s_Sf_I");
    static STRUCT_IF_C aBFu15s_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_I");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_I.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_I, aBFu15s_Sf_I)
//============================================================================



static void Test_aBFu15s_Sf_Ip()
{
  {
    init_simple_test("aBFu15s_Sf_Ip");
    static STRUCT_IF_C aBFu15s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15s_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Ip");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Ip, aBFu15s_Sf_Ip)
//============================================================================



static void Test_aBFu15s_Sf_L()
{
  {
    init_simple_test("aBFu15s_Sf_L");
    static STRUCT_IF_C aBFu15s_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15s_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_L");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_L.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_L, aBFu15s_Sf_L)
//============================================================================



static void Test_aBFu15s_Sf_S()
{
  {
    init_simple_test("aBFu15s_Sf_S");
    static STRUCT_IF_C aBFu15s_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_S");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_S.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_S, aBFu15s_Sf_S)
//============================================================================



static void Test_aBFu15s_Sf_Sf()
{
  {
    init_simple_test("aBFu15s_Sf_Sf");
    static STRUCT_IF_C aBFu15s_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu15s_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Sf, aBFu15s_Sf_Sf)
//============================================================================



static void Test_aBFu15s_Sf_Uc()
{
  {
    init_simple_test("aBFu15s_Sf_Uc");
    static STRUCT_IF_C aBFu15s_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Uc");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Uc, aBFu15s_Sf_Uc)
//============================================================================



static void Test_aBFu15s_Sf_Ui()
{
  {
    init_simple_test("aBFu15s_Sf_Ui");
    static STRUCT_IF_C aBFu15s_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Ui");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Ui, aBFu15s_Sf_Ui)
//============================================================================



static void Test_aBFu15s_Sf_Ul()
{
  {
    init_simple_test("aBFu15s_Sf_Ul");
    static STRUCT_IF_C aBFu15s_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15s_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Ul");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Ul, aBFu15s_Sf_Ul)
//============================================================================



static void Test_aBFu15s_Sf_Us()
{
  {
    init_simple_test("aBFu15s_Sf_Us");
    static STRUCT_IF_C aBFu15s_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Us");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Us, aBFu15s_Sf_Us)
//============================================================================



static void Test_aBFu15s_Sf_Vp()
{
  {
    init_simple_test("aBFu15s_Sf_Vp");
    static STRUCT_IF_C aBFu15s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15s_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Sf_Vp");
    check_field_offset(lv, v2, 2, "aBFu15s_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu15s_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Sf_Vp, aBFu15s_Sf_Vp)
//============================================================================



static void Test_aBFu15s_Uc_Sf()
{
  {
    init_simple_test("aBFu15s_Uc_Sf");
    static STRUCT_IF_C aBFu15s_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu15s_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Uc_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu15s_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Uc_Sf, aBFu15s_Uc_Sf)
//============================================================================



static void Test_aBFu15s_Ui_Sf()
{
  {
    init_simple_test("aBFu15s_Ui_Sf");
    static STRUCT_IF_C aBFu15s_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu15s_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Ui_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu15s_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Ui_Sf, aBFu15s_Ui_Sf)
//============================================================================



static void Test_aBFu15s_Ul_Sf()
{
  {
    init_simple_test("aBFu15s_Ul_Sf");
    static STRUCT_IF_C aBFu15s_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu15s_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Ul_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu15s_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Ul_Sf, aBFu15s_Ul_Sf)
//============================================================================



static void Test_aBFu15s_Us_Sf()
{
  {
    init_simple_test("aBFu15s_Us_Sf");
    static STRUCT_IF_C aBFu15s_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu15s_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Us_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu15s_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Us_Sf, aBFu15s_Us_Sf)
//============================================================================



static void Test_aBFu15s_Vp_Sf()
{
  {
    init_simple_test("aBFu15s_Vp_Sf");
    static STRUCT_IF_C aBFu15s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu15s_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu15s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "aBFu15s_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "aBFu15s_Vp_Sf");
    check_field_offset(lv, v2, 2, "aBFu15s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu15s_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu15s_Vp_Sf, aBFu15s_Vp_Sf)
//============================================================================



static void Test_aBFu16i_BFu15i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu15i_Sf");
    static STRUCT_IF_C aBFu16i_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16i_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu15i_Sf, aBFu16i_BFu15i_Sf)
//============================================================================



static void Test_aBFu16i_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu15ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16i_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu15ll_Sf, aBFu16i_BFu15ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu15s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu15s_Sf");
    static STRUCT_IF_C aBFu16i_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16i_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu15s_Sf, aBFu16i_BFu15s_Sf)
//============================================================================



static void Test_aBFu16i_BFu16i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu16i_Sf");
    static STRUCT_IF_C aBFu16i_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu16i_Sf, aBFu16i_BFu16i_Sf)
//============================================================================



static void Test_aBFu16i_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu16ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu16ll_Sf, aBFu16i_BFu16ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu16s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu16s_Sf");
    static STRUCT_IF_C aBFu16i_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu16s_Sf, aBFu16i_BFu16s_Sf)
//============================================================================



static void Test_aBFu16i_BFu17i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu17i_Sf");
    static STRUCT_IF_C aBFu16i_BFu17i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu16i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu16i_BFu17i_Sf");
    check_field_offset(lv, v3, 5, "aBFu16i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu17i_Sf, aBFu16i_BFu17i_Sf)
//============================================================================



static void Test_aBFu16i_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu17ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu17ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu16i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu16i_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu16i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu17ll_Sf, aBFu16i_BFu17ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu1c_Sf()
{
  {
    init_simple_test("aBFu16i_BFu1c_Sf");
    static STRUCT_IF_C aBFu16i_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16i_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu1c_Sf, aBFu16i_BFu1c_Sf)
//============================================================================



static void Test_aBFu16i_BFu1i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu1i_Sf");
    static STRUCT_IF_C aBFu16i_BFu1i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16i_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu1i_Sf, aBFu16i_BFu1i_Sf)
//============================================================================



static void Test_aBFu16i_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu1ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu1ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16i_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu1ll_Sf, aBFu16i_BFu1ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu1s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu1s_Sf");
    static STRUCT_IF_C aBFu16i_BFu1s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16i_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu1s_Sf, aBFu16i_BFu1s_Sf)
//============================================================================



static void Test_aBFu16i_BFu31i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu31i_Sf");
    static STRUCT_IF_C aBFu16i_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16i_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu16i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu31i_Sf, aBFu16i_BFu31i_Sf)
//============================================================================



static void Test_aBFu16i_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu31ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16i_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu16i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu31ll_Sf, aBFu16i_BFu31ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu32i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu32i_Sf");
    static STRUCT_IF_C aBFu16i_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16i_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "aBFu16i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu32i_Sf, aBFu16i_BFu32i_Sf)
//============================================================================



static void Test_aBFu16i_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu32ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16i_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu16i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu32ll_Sf, aBFu16i_BFu32ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu33_Sf()
{
  {
    init_simple_test("aBFu16i_BFu33_Sf");
    static STRUCT_IF_C aBFu16i_BFu33_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16i_BFu33_Sf");
    check_field_offset(lv, v3, 7, "aBFu16i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu33_Sf, aBFu16i_BFu33_Sf)
//============================================================================



static void Test_aBFu16i_BFu7c_Sf()
{
  {
    init_simple_test("aBFu16i_BFu7c_Sf");
    static STRUCT_IF_C aBFu16i_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu7c_Sf, aBFu16i_BFu7c_Sf)
//============================================================================



static void Test_aBFu16i_BFu7i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu7i_Sf");
    static STRUCT_IF_C aBFu16i_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu7i_Sf, aBFu16i_BFu7i_Sf)
//============================================================================



static void Test_aBFu16i_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu7ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu7ll_Sf, aBFu16i_BFu7ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu7s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu7s_Sf");
    static STRUCT_IF_C aBFu16i_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu7s_Sf, aBFu16i_BFu7s_Sf)
//============================================================================



static void Test_aBFu16i_BFu8c_Sf()
{
  {
    init_simple_test("aBFu16i_BFu8c_Sf");
    static STRUCT_IF_C aBFu16i_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu8c_Sf, aBFu16i_BFu8c_Sf)
//============================================================================



static void Test_aBFu16i_BFu8i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu8i_Sf");
    static STRUCT_IF_C aBFu16i_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu8i_Sf, aBFu16i_BFu8i_Sf)
//============================================================================



static void Test_aBFu16i_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu8ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu8ll_Sf, aBFu16i_BFu8ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu8s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu8s_Sf");
    static STRUCT_IF_C aBFu16i_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu8s_Sf, aBFu16i_BFu8s_Sf)
//============================================================================



static void Test_aBFu16i_BFu9i_Sf()
{
  {
    init_simple_test("aBFu16i_BFu9i_Sf");
    static STRUCT_IF_C aBFu16i_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16i_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu9i_Sf, aBFu16i_BFu9i_Sf)
//============================================================================



static void Test_aBFu16i_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu16i_BFu9ll_Sf");
    static STRUCT_IF_C aBFu16i_BFu9ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16i_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu9ll_Sf, aBFu16i_BFu9ll_Sf)
//============================================================================



static void Test_aBFu16i_BFu9s_Sf()
{
  {
    init_simple_test("aBFu16i_BFu9s_Sf");
    static STRUCT_IF_C aBFu16i_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16i_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_BFu9s_Sf, aBFu16i_BFu9s_Sf)
//============================================================================



static void Test_aBFu16i_C_Sf()
{
  {
    init_simple_test("aBFu16i_C_Sf");
    static STRUCT_IF_C aBFu16i_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_C_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_C_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu16i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_C_Sf, aBFu16i_C_Sf)
//============================================================================



static void Test_aBFu16i_D_Sf()
{
  {
    init_simple_test("aBFu16i_D_Sf");
    static STRUCT_IF_C aBFu16i_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_D_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_D_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_D_Sf, aBFu16i_D_Sf)
//============================================================================



static void Test_aBFu16i_F_Sf()
{
  {
    init_simple_test("aBFu16i_F_Sf");
    static STRUCT_IF_C aBFu16i_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_F_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_F_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_F_Sf, aBFu16i_F_Sf)
//============================================================================



static void Test_aBFu16i_I_Sf()
{
  {
    init_simple_test("aBFu16i_I_Sf");
    static STRUCT_IF_C aBFu16i_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_I_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_I_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_I_Sf, aBFu16i_I_Sf)
//============================================================================



static void Test_aBFu16i_Ip_Sf()
{
  {
    init_simple_test("aBFu16i_Ip_Sf");
    static STRUCT_IF_C aBFu16i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Ip_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu16i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Ip_Sf, aBFu16i_Ip_Sf)
//============================================================================



static void Test_aBFu16i_L_Sf()
{
  {
    init_simple_test("aBFu16i_L_Sf");
    static STRUCT_IF_C aBFu16i_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_L_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_L_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_L_Sf, aBFu16i_L_Sf)
//============================================================================



static void Test_aBFu16i_S_Sf()
{
  {
    init_simple_test("aBFu16i_S_Sf");
    static STRUCT_IF_C aBFu16i_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_S_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_S_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu16i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_S_Sf, aBFu16i_S_Sf)
//============================================================================



static void Test_aBFu16i_Sf()
{
  {
    init_simple_test("aBFu16i_Sf");
    static STRUCT_IF_C aBFu16i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf, aBFu16i_Sf)
//============================================================================



static void Test_aBFu16i_Sf_BFu15i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu15i");
    static STRUCT_IF_C aBFu16i_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu15i, aBFu16i_Sf_BFu15i)
//============================================================================



static void Test_aBFu16i_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu15ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu15ll, aBFu16i_Sf_BFu15ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu15s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu15s");
    static STRUCT_IF_C aBFu16i_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu15s, aBFu16i_Sf_BFu15s)
//============================================================================



static void Test_aBFu16i_Sf_BFu16i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu16i");
    static STRUCT_IF_C aBFu16i_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu16i, aBFu16i_Sf_BFu16i)
//============================================================================



static void Test_aBFu16i_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu16ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu16ll, aBFu16i_Sf_BFu16ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu16s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu16s");
    static STRUCT_IF_C aBFu16i_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu16s, aBFu16i_Sf_BFu16s)
//============================================================================



static void Test_aBFu16i_Sf_BFu17i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu17i");
    static STRUCT_IF_C aBFu16i_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu16i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu16i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu17i, aBFu16i_Sf_BFu17i)
//============================================================================



static void Test_aBFu16i_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu17ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu16i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu16i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu17ll, aBFu16i_Sf_BFu17ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu1c()
{
  {
    init_simple_test("aBFu16i_Sf_BFu1c");
    static STRUCT_IF_C aBFu16i_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu1c, aBFu16i_Sf_BFu1c)
//============================================================================



static void Test_aBFu16i_Sf_BFu1i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu1i");
    static STRUCT_IF_C aBFu16i_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu1i, aBFu16i_Sf_BFu1i)
//============================================================================



static void Test_aBFu16i_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu1ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu1ll, aBFu16i_Sf_BFu1ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu1s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu1s");
    static STRUCT_IF_C aBFu16i_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu1s, aBFu16i_Sf_BFu1s)
//============================================================================



static void Test_aBFu16i_Sf_BFu31i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu31i");
    static STRUCT_IF_C aBFu16i_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu16i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu16i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu31i, aBFu16i_Sf_BFu31i)
//============================================================================



static void Test_aBFu16i_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu31ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu16i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu16i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu31ll, aBFu16i_Sf_BFu31ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu32i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu32i");
    static STRUCT_IF_C aBFu16i_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu16i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu16i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu32i, aBFu16i_Sf_BFu32i)
//============================================================================



static void Test_aBFu16i_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu32ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu16i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu16i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu32ll, aBFu16i_Sf_BFu32ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu33()
{
  {
    init_simple_test("aBFu16i_Sf_BFu33");
    static STRUCT_IF_C aBFu16i_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu33");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu16i_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu16i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu33, aBFu16i_Sf_BFu33)
//============================================================================



static void Test_aBFu16i_Sf_BFu7c()
{
  {
    init_simple_test("aBFu16i_Sf_BFu7c");
    static STRUCT_IF_C aBFu16i_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu7c, aBFu16i_Sf_BFu7c)
//============================================================================



static void Test_aBFu16i_Sf_BFu7i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu7i");
    static STRUCT_IF_C aBFu16i_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu7i, aBFu16i_Sf_BFu7i)
//============================================================================



static void Test_aBFu16i_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu7ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu7ll, aBFu16i_Sf_BFu7ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu7s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu7s");
    static STRUCT_IF_C aBFu16i_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu7s, aBFu16i_Sf_BFu7s)
//============================================================================



static void Test_aBFu16i_Sf_BFu8c()
{
  {
    init_simple_test("aBFu16i_Sf_BFu8c");
    static STRUCT_IF_C aBFu16i_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu8c, aBFu16i_Sf_BFu8c)
//============================================================================



static void Test_aBFu16i_Sf_BFu8i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu8i");
    static STRUCT_IF_C aBFu16i_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu8i, aBFu16i_Sf_BFu8i)
//============================================================================



static void Test_aBFu16i_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu8ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu8ll, aBFu16i_Sf_BFu8ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu8s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu8s");
    static STRUCT_IF_C aBFu16i_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu8s, aBFu16i_Sf_BFu8s)
//============================================================================



static void Test_aBFu16i_Sf_BFu9i()
{
  {
    init_simple_test("aBFu16i_Sf_BFu9i");
    static STRUCT_IF_C aBFu16i_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu9i, aBFu16i_Sf_BFu9i)
//============================================================================



static void Test_aBFu16i_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu16i_Sf_BFu9ll");
    static STRUCT_IF_C aBFu16i_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu9ll, aBFu16i_Sf_BFu9ll)
//============================================================================



static void Test_aBFu16i_Sf_BFu9s()
{
  {
    init_simple_test("aBFu16i_Sf_BFu9s");
    static STRUCT_IF_C aBFu16i_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_BFu9s, aBFu16i_Sf_BFu9s)
//============================================================================



static void Test_aBFu16i_Sf_C()
{
  {
    init_simple_test("aBFu16i_Sf_C");
    static STRUCT_IF_C aBFu16i_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_C");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_C.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_C, aBFu16i_Sf_C)
//============================================================================



static void Test_aBFu16i_Sf_D()
{
  {
    init_simple_test("aBFu16i_Sf_D");
    static STRUCT_IF_C aBFu16i_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_D");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_D.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_D, aBFu16i_Sf_D)
//============================================================================



static void Test_aBFu16i_Sf_F()
{
  {
    init_simple_test("aBFu16i_Sf_F");
    static STRUCT_IF_C aBFu16i_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_F");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_F.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_F, aBFu16i_Sf_F)
//============================================================================



static void Test_aBFu16i_Sf_I()
{
  {
    init_simple_test("aBFu16i_Sf_I");
    static STRUCT_IF_C aBFu16i_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_I");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_I.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_I, aBFu16i_Sf_I)
//============================================================================



static void Test_aBFu16i_Sf_Ip()
{
  {
    init_simple_test("aBFu16i_Sf_Ip");
    static STRUCT_IF_C aBFu16i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Ip");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Ip, aBFu16i_Sf_Ip)
//============================================================================



static void Test_aBFu16i_Sf_L()
{
  {
    init_simple_test("aBFu16i_Sf_L");
    static STRUCT_IF_C aBFu16i_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_L");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_L.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_L, aBFu16i_Sf_L)
//============================================================================



static void Test_aBFu16i_Sf_S()
{
  {
    init_simple_test("aBFu16i_Sf_S");
    static STRUCT_IF_C aBFu16i_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_S");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_S.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_S, aBFu16i_Sf_S)
//============================================================================



static void Test_aBFu16i_Sf_Sf()
{
  {
    init_simple_test("aBFu16i_Sf_Sf");
    static STRUCT_IF_C aBFu16i_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Sf, aBFu16i_Sf_Sf)
//============================================================================



static void Test_aBFu16i_Sf_Uc()
{
  {
    init_simple_test("aBFu16i_Sf_Uc");
    static STRUCT_IF_C aBFu16i_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Uc");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Uc, aBFu16i_Sf_Uc)
//============================================================================



static void Test_aBFu16i_Sf_Ui()
{
  {
    init_simple_test("aBFu16i_Sf_Ui");
    static STRUCT_IF_C aBFu16i_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Ui");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Ui, aBFu16i_Sf_Ui)
//============================================================================



static void Test_aBFu16i_Sf_Ul()
{
  {
    init_simple_test("aBFu16i_Sf_Ul");
    static STRUCT_IF_C aBFu16i_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Ul");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Ul, aBFu16i_Sf_Ul)
//============================================================================



static void Test_aBFu16i_Sf_Us()
{
  {
    init_simple_test("aBFu16i_Sf_Us");
    static STRUCT_IF_C aBFu16i_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Us");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Us, aBFu16i_Sf_Us)
//============================================================================



static void Test_aBFu16i_Sf_Vp()
{
  {
    init_simple_test("aBFu16i_Sf_Vp");
    static STRUCT_IF_C aBFu16i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Sf_Vp");
    check_field_offset(lv, v2, 2, "aBFu16i_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu16i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Sf_Vp, aBFu16i_Sf_Vp)
//============================================================================



static void Test_aBFu16i_Uc_Sf()
{
  {
    init_simple_test("aBFu16i_Uc_Sf");
    static STRUCT_IF_C aBFu16i_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Uc_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu16i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Uc_Sf, aBFu16i_Uc_Sf)
//============================================================================



static void Test_aBFu16i_Ui_Sf()
{
  {
    init_simple_test("aBFu16i_Ui_Sf");
    static STRUCT_IF_C aBFu16i_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Ui_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Ui_Sf, aBFu16i_Ui_Sf)
//============================================================================



static void Test_aBFu16i_Ul_Sf()
{
  {
    init_simple_test("aBFu16i_Ul_Sf");
    static STRUCT_IF_C aBFu16i_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Ul_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Ul_Sf, aBFu16i_Ul_Sf)
//============================================================================



static void Test_aBFu16i_Us_Sf()
{
  {
    init_simple_test("aBFu16i_Us_Sf");
    static STRUCT_IF_C aBFu16i_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Us_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu16i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Us_Sf, aBFu16i_Us_Sf)
//============================================================================



static void Test_aBFu16i_Vp_Sf()
{
  {
    init_simple_test("aBFu16i_Vp_Sf");
    static STRUCT_IF_C aBFu16i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16i_Vp_Sf");
    check_field_offset(lv, v2, 2, "aBFu16i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu16i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16i_Vp_Sf, aBFu16i_Vp_Sf)
//============================================================================



static void Test_aBFu16ll_BFu15i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu15i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu15i_Sf, aBFu16ll_BFu15i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu15ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu15ll_Sf, aBFu16ll_BFu15ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu15s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu15s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu15s_Sf, aBFu16ll_BFu15s_Sf)
//============================================================================



static void Test_aBFu16ll_BFu16i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu16i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu16i_Sf, aBFu16ll_BFu16i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu16ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu16ll_Sf, aBFu16ll_BFu16ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu16s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu16s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu16s_Sf, aBFu16ll_BFu16s_Sf)
//============================================================================



static void Test_aBFu16ll_BFu17i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu17i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu17i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu16ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu17i_Sf");
    check_field_offset(lv, v3, 5, "aBFu16ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu17i_Sf, aBFu16ll_BFu17i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu17ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu16ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu16ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu17ll_Sf, aBFu16ll_BFu17ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu1c_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Sf");
    static STRUCT_IF_C aBFu16ll_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Sf, aBFu16ll_BFu1c_Sf)
//============================================================================



static void Test_aBFu16ll_BFu1i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu1i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Sf, aBFu16ll_BFu1i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Sf, aBFu16ll_BFu1ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu1s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu1s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Sf, aBFu16ll_BFu1s_Sf)
//============================================================================



static void Test_aBFu16ll_BFu31i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Sf, aBFu16ll_BFu31i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Sf, aBFu16ll_BFu31ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu32i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Sf, aBFu16ll_BFu32i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Sf, aBFu16ll_BFu32ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu33_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu33_Sf");
    static STRUCT_IF_C aBFu16ll_BFu33_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Sf");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Sf, aBFu16ll_BFu33_Sf)
//============================================================================



static void Test_aBFu16ll_BFu7c_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Sf");
    static STRUCT_IF_C aBFu16ll_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Sf, aBFu16ll_BFu7c_Sf)
//============================================================================



static void Test_aBFu16ll_BFu7i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Sf, aBFu16ll_BFu7i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Sf, aBFu16ll_BFu7ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu7s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Sf, aBFu16ll_BFu7s_Sf)
//============================================================================



static void Test_aBFu16ll_BFu8c_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Sf");
    static STRUCT_IF_C aBFu16ll_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Sf, aBFu16ll_BFu8c_Sf)
//============================================================================



static void Test_aBFu16ll_BFu8i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Sf, aBFu16ll_BFu8i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Sf, aBFu16ll_BFu8ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu8s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Sf, aBFu16ll_BFu8s_Sf)
//============================================================================



static void Test_aBFu16ll_BFu9i_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Sf");
    static STRUCT_IF_C aBFu16ll_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Sf, aBFu16ll_BFu9i_Sf)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Sf");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Sf, aBFu16ll_BFu9ll_Sf)
//============================================================================



static void Test_aBFu16ll_BFu9s_Sf()
{
  {
    init_simple_test("aBFu16ll_BFu9s_Sf");
    static STRUCT_IF_C aBFu16ll_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_Sf, aBFu16ll_BFu9s_Sf)
//============================================================================



static void Test_aBFu16ll_C_Sf()
{
  {
    init_simple_test("aBFu16ll_C_Sf");
    static STRUCT_IF_C aBFu16ll_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_C_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_C_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu16ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_C_Sf, aBFu16ll_C_Sf)
//============================================================================



static void Test_aBFu16ll_D_Sf()
{
  {
    init_simple_test("aBFu16ll_D_Sf");
    static STRUCT_IF_C aBFu16ll_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_D_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_D_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_D_Sf, aBFu16ll_D_Sf)
//============================================================================



static void Test_aBFu16ll_F_Sf()
{
  {
    init_simple_test("aBFu16ll_F_Sf");
    static STRUCT_IF_C aBFu16ll_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_F_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_F_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_F_Sf, aBFu16ll_F_Sf)
//============================================================================



static void Test_aBFu16ll_I_Sf()
{
  {
    init_simple_test("aBFu16ll_I_Sf");
    static STRUCT_IF_C aBFu16ll_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_I_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_I_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_I_Sf, aBFu16ll_I_Sf)
//============================================================================



static void Test_aBFu16ll_Ip_Sf()
{
  {
    init_simple_test("aBFu16ll_Ip_Sf");
    static STRUCT_IF_C aBFu16ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Ip_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu16ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Ip_Sf, aBFu16ll_Ip_Sf)
//============================================================================



static void Test_aBFu16ll_L_Sf()
{
  {
    init_simple_test("aBFu16ll_L_Sf");
    static STRUCT_IF_C aBFu16ll_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_L_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_L_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_L_Sf, aBFu16ll_L_Sf)
//============================================================================



static void Test_aBFu16ll_S_Sf()
{
  {
    init_simple_test("aBFu16ll_S_Sf");
    static STRUCT_IF_C aBFu16ll_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_S_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_S_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu16ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_S_Sf, aBFu16ll_S_Sf)
//============================================================================



static void Test_aBFu16ll_Sf()
{
  {
    init_simple_test("aBFu16ll_Sf");
    static STRUCT_IF_C aBFu16ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf, aBFu16ll_Sf)
//============================================================================



static void Test_aBFu16ll_Sf_BFu15i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu15i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu15i, aBFu16ll_Sf_BFu15i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu15ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu15ll, aBFu16ll_Sf_BFu15ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu15s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu15s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu15s, aBFu16ll_Sf_BFu15s)
//============================================================================



static void Test_aBFu16ll_Sf_BFu16i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu16i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu16i, aBFu16ll_Sf_BFu16i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu16ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu16ll, aBFu16ll_Sf_BFu16ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu16s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu16s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu16s, aBFu16ll_Sf_BFu16s)
//============================================================================



static void Test_aBFu16ll_Sf_BFu17i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu17i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu16ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu16ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu17i, aBFu16ll_Sf_BFu17i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu17ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu16ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu16ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu17ll, aBFu16ll_Sf_BFu17ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu1c()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu1c");
    static STRUCT_IF_C aBFu16ll_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu1c, aBFu16ll_Sf_BFu1c)
//============================================================================



static void Test_aBFu16ll_Sf_BFu1i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu1i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu1i, aBFu16ll_Sf_BFu1i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu1ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu1ll, aBFu16ll_Sf_BFu1ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu1s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu1s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu1s, aBFu16ll_Sf_BFu1s)
//============================================================================



static void Test_aBFu16ll_Sf_BFu31i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu31i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu16ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu31i, aBFu16ll_Sf_BFu31i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu31ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu16ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu31ll, aBFu16ll_Sf_BFu31ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu32i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu32i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu16ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu32i, aBFu16ll_Sf_BFu32i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu32ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu16ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu32ll, aBFu16ll_Sf_BFu32ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu33()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu33");
    static STRUCT_IF_C aBFu16ll_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu33");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu16ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu33, aBFu16ll_Sf_BFu33)
//============================================================================



static void Test_aBFu16ll_Sf_BFu7c()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu7c");
    static STRUCT_IF_C aBFu16ll_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu7c, aBFu16ll_Sf_BFu7c)
//============================================================================



static void Test_aBFu16ll_Sf_BFu7i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu7i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu7i, aBFu16ll_Sf_BFu7i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu7ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu7ll, aBFu16ll_Sf_BFu7ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu7s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu7s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu7s, aBFu16ll_Sf_BFu7s)
//============================================================================



static void Test_aBFu16ll_Sf_BFu8c()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu8c");
    static STRUCT_IF_C aBFu16ll_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu8c, aBFu16ll_Sf_BFu8c)
//============================================================================



static void Test_aBFu16ll_Sf_BFu8i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu8i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu8i, aBFu16ll_Sf_BFu8i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu8ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu8ll, aBFu16ll_Sf_BFu8ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu8s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu8s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu8s, aBFu16ll_Sf_BFu8s)
//============================================================================



static void Test_aBFu16ll_Sf_BFu9i()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu9i");
    static STRUCT_IF_C aBFu16ll_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu9i, aBFu16ll_Sf_BFu9i)
//============================================================================



static void Test_aBFu16ll_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu9ll");
    static STRUCT_IF_C aBFu16ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu9ll, aBFu16ll_Sf_BFu9ll)
//============================================================================



static void Test_aBFu16ll_Sf_BFu9s()
{
  {
    init_simple_test("aBFu16ll_Sf_BFu9s");
    static STRUCT_IF_C aBFu16ll_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_BFu9s, aBFu16ll_Sf_BFu9s)
//============================================================================



static void Test_aBFu16ll_Sf_C()
{
  {
    init_simple_test("aBFu16ll_Sf_C");
    static STRUCT_IF_C aBFu16ll_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_C");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_C.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_C, aBFu16ll_Sf_C)
//============================================================================



static void Test_aBFu16ll_Sf_D()
{
  {
    init_simple_test("aBFu16ll_Sf_D");
    static STRUCT_IF_C aBFu16ll_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_D");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_D.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_D, aBFu16ll_Sf_D)
//============================================================================



static void Test_aBFu16ll_Sf_F()
{
  {
    init_simple_test("aBFu16ll_Sf_F");
    static STRUCT_IF_C aBFu16ll_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_F");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_F.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_F, aBFu16ll_Sf_F)
//============================================================================



static void Test_aBFu16ll_Sf_I()
{
  {
    init_simple_test("aBFu16ll_Sf_I");
    static STRUCT_IF_C aBFu16ll_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_I");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_I.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_I, aBFu16ll_Sf_I)
//============================================================================



static void Test_aBFu16ll_Sf_Ip()
{
  {
    init_simple_test("aBFu16ll_Sf_Ip");
    static STRUCT_IF_C aBFu16ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Ip");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Ip, aBFu16ll_Sf_Ip)
//============================================================================



static void Test_aBFu16ll_Sf_L()
{
  {
    init_simple_test("aBFu16ll_Sf_L");
    static STRUCT_IF_C aBFu16ll_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_L");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_L.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_L, aBFu16ll_Sf_L)
//============================================================================



static void Test_aBFu16ll_Sf_S()
{
  {
    init_simple_test("aBFu16ll_Sf_S");
    static STRUCT_IF_C aBFu16ll_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_S");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_S.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_S, aBFu16ll_Sf_S)
//============================================================================



static void Test_aBFu16ll_Sf_Sf()
{
  {
    init_simple_test("aBFu16ll_Sf_Sf");
    static STRUCT_IF_C aBFu16ll_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Sf, aBFu16ll_Sf_Sf)
//============================================================================



static void Test_aBFu16ll_Sf_Uc()
{
  {
    init_simple_test("aBFu16ll_Sf_Uc");
    static STRUCT_IF_C aBFu16ll_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Uc");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Uc, aBFu16ll_Sf_Uc)
//============================================================================



static void Test_aBFu16ll_Sf_Ui()
{
  {
    init_simple_test("aBFu16ll_Sf_Ui");
    static STRUCT_IF_C aBFu16ll_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Ui");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Ui, aBFu16ll_Sf_Ui)
//============================================================================



static void Test_aBFu16ll_Sf_Ul()
{
  {
    init_simple_test("aBFu16ll_Sf_Ul");
    static STRUCT_IF_C aBFu16ll_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Ul");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Ul, aBFu16ll_Sf_Ul)
//============================================================================



static void Test_aBFu16ll_Sf_Us()
{
  {
    init_simple_test("aBFu16ll_Sf_Us");
    static STRUCT_IF_C aBFu16ll_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Us");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Us, aBFu16ll_Sf_Us)
//============================================================================



static void Test_aBFu16ll_Sf_Vp()
{
  {
    init_simple_test("aBFu16ll_Sf_Vp");
    static STRUCT_IF_C aBFu16ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Sf_Vp");
    check_field_offset(lv, v2, 2, "aBFu16ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu16ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Sf_Vp, aBFu16ll_Sf_Vp)
//============================================================================



static void Test_aBFu16ll_Uc_Sf()
{
  {
    init_simple_test("aBFu16ll_Uc_Sf");
    static STRUCT_IF_C aBFu16ll_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Uc_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu16ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Uc_Sf, aBFu16ll_Uc_Sf)
//============================================================================



static void Test_aBFu16ll_Ui_Sf()
{
  {
    init_simple_test("aBFu16ll_Ui_Sf");
    static STRUCT_IF_C aBFu16ll_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Ui_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Ui_Sf, aBFu16ll_Ui_Sf)
//============================================================================



static void Test_aBFu16ll_Ul_Sf()
{
  {
    init_simple_test("aBFu16ll_Ul_Sf");
    static STRUCT_IF_C aBFu16ll_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Ul_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Ul_Sf, aBFu16ll_Ul_Sf)
//============================================================================



static void Test_aBFu16ll_Us_Sf()
{
  {
    init_simple_test("aBFu16ll_Us_Sf");
    static STRUCT_IF_C aBFu16ll_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Us_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu16ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Us_Sf, aBFu16ll_Us_Sf)
//============================================================================



static void Test_aBFu16ll_Vp_Sf()
{
  {
    init_simple_test("aBFu16ll_Vp_Sf");
    static STRUCT_IF_C aBFu16ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_Vp_Sf");
    check_field_offset(lv, v2, 2, "aBFu16ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu16ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_Vp_Sf, aBFu16ll_Vp_Sf)
//============================================================================



static void Test_aBFu16s_BFu15i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu15i_Sf");
    static STRUCT_IF_C aBFu16s_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16s_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu15i_Sf, aBFu16s_BFu15i_Sf)
//============================================================================



static void Test_aBFu16s_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu15ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16s_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu15ll_Sf, aBFu16s_BFu15ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu15s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu15s_Sf");
    static STRUCT_IF_C aBFu16s_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aBFu16s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aBFu16s_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu15s_Sf, aBFu16s_BFu15s_Sf)
//============================================================================



static void Test_aBFu16s_BFu16i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu16i_Sf");
    static STRUCT_IF_C aBFu16s_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu16i_Sf, aBFu16s_BFu16i_Sf)
//============================================================================



static void Test_aBFu16s_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu16ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu16ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu16ll_Sf, aBFu16s_BFu16ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu16s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu16s_Sf");
    static STRUCT_IF_C aBFu16s_BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aBFu16s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu16s_Sf, aBFu16s_BFu16s_Sf)
//============================================================================



static void Test_aBFu16s_BFu17i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu17i_Sf");
    static STRUCT_IF_C aBFu16s_BFu17i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16s_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu16s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu16s_BFu17i_Sf");
    check_field_offset(lv, v3, 5, "aBFu16s_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu17i_Sf, aBFu16s_BFu17i_Sf)
//============================================================================



static void Test_aBFu16s_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu17ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu17ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16s_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aBFu16s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aBFu16s_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu16s_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu17ll_Sf, aBFu16s_BFu17ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu1c_Sf()
{
  {
    init_simple_test("aBFu16s_BFu1c_Sf");
    static STRUCT_IF_C aBFu16s_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16s_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu1c_Sf, aBFu16s_BFu1c_Sf)
//============================================================================



static void Test_aBFu16s_BFu1i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu1i_Sf");
    static STRUCT_IF_C aBFu16s_BFu1i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16s_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu1i_Sf, aBFu16s_BFu1i_Sf)
//============================================================================



static void Test_aBFu16s_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu1ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu1ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16s_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu1ll_Sf, aBFu16s_BFu1ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu1s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu1s_Sf");
    static STRUCT_IF_C aBFu16s_BFu1s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16s_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu1s_Sf, aBFu16s_BFu1s_Sf)
//============================================================================



static void Test_aBFu16s_BFu31i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu31i_Sf");
    static STRUCT_IF_C aBFu16s_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16s_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu16s_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu31i_Sf, aBFu16s_BFu31i_Sf)
//============================================================================



static void Test_aBFu16s_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu31ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16s_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu16s_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu31ll_Sf, aBFu16s_BFu31ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu32i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu32i_Sf");
    static STRUCT_IF_C aBFu16s_BFu32i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16s_BFu32i_Sf");
    check_field_offset(lv, v3, 6, "aBFu16s_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu32i_Sf, aBFu16s_BFu32i_Sf)
//============================================================================



static void Test_aBFu16s_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu32ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu32ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16s_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu16s_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu32ll_Sf, aBFu16s_BFu32ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu33_Sf()
{
  {
    init_simple_test("aBFu16s_BFu33_Sf");
    static STRUCT_IF_C aBFu16s_BFu33_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16s_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16s_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16s_BFu33_Sf");
    check_field_offset(lv, v3, 7, "aBFu16s_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu33_Sf, aBFu16s_BFu33_Sf)
//============================================================================



static void Test_aBFu16s_BFu7c_Sf()
{
  {
    init_simple_test("aBFu16s_BFu7c_Sf");
    static STRUCT_IF_C aBFu16s_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu7c_Sf, aBFu16s_BFu7c_Sf)
//============================================================================



static void Test_aBFu16s_BFu7i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu7i_Sf");
    static STRUCT_IF_C aBFu16s_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu7i_Sf, aBFu16s_BFu7i_Sf)
//============================================================================



static void Test_aBFu16s_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu7ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu7ll_Sf, aBFu16s_BFu7ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu7s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu7s_Sf");
    static STRUCT_IF_C aBFu16s_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu7s_Sf, aBFu16s_BFu7s_Sf)
//============================================================================



static void Test_aBFu16s_BFu8c_Sf()
{
  {
    init_simple_test("aBFu16s_BFu8c_Sf");
    static STRUCT_IF_C aBFu16s_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu8c_Sf, aBFu16s_BFu8c_Sf)
//============================================================================



static void Test_aBFu16s_BFu8i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu8i_Sf");
    static STRUCT_IF_C aBFu16s_BFu8i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu8i_Sf, aBFu16s_BFu8i_Sf)
//============================================================================



static void Test_aBFu16s_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu8ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu8ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu8ll_Sf, aBFu16s_BFu8ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu8s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu8s_Sf");
    static STRUCT_IF_C aBFu16s_BFu8s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "aBFu16s_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu8s_Sf, aBFu16s_BFu8s_Sf)
//============================================================================



static void Test_aBFu16s_BFu9i_Sf()
{
  {
    init_simple_test("aBFu16s_BFu9i_Sf");
    static STRUCT_IF_C aBFu16s_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16s_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu9i_Sf, aBFu16s_BFu9i_Sf)
//============================================================================



static void Test_aBFu16s_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu16s_BFu9ll_Sf");
    static STRUCT_IF_C aBFu16s_BFu9ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16s_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu9ll_Sf, aBFu16s_BFu9ll_Sf)
//============================================================================



static void Test_aBFu16s_BFu9s_Sf()
{
  {
    init_simple_test("aBFu16s_BFu9s_Sf");
    static STRUCT_IF_C aBFu16s_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16s_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "aBFu16s_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_BFu9s_Sf, aBFu16s_BFu9s_Sf)
//============================================================================



static void Test_aBFu16s_C_Sf()
{
  {
    init_simple_test("aBFu16s_C_Sf");
    static STRUCT_IF_C aBFu16s_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_C_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_C_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu16s_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_C_Sf, aBFu16s_C_Sf)
//============================================================================



static void Test_aBFu16s_D_Sf()
{
  {
    init_simple_test("aBFu16s_D_Sf");
    static STRUCT_IF_C aBFu16s_D_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16s_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_D_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_D_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16s_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_D_Sf, aBFu16s_D_Sf)
//============================================================================



static void Test_aBFu16s_F_Sf()
{
  {
    init_simple_test("aBFu16s_F_Sf");
    static STRUCT_IF_C aBFu16s_F_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_F_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_F_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16s_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_F_Sf, aBFu16s_F_Sf)
//============================================================================



static void Test_aBFu16s_I_Sf()
{
  {
    init_simple_test("aBFu16s_I_Sf");
    static STRUCT_IF_C aBFu16s_I_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_I_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_I_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16s_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_I_Sf, aBFu16s_I_Sf)
//============================================================================



static void Test_aBFu16s_Ip_Sf()
{
  {
    init_simple_test("aBFu16s_Ip_Sf");
    static STRUCT_IF_C aBFu16s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16s_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Ip_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu16s_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Ip_Sf, aBFu16s_Ip_Sf)
//============================================================================



static void Test_aBFu16s_L_Sf()
{
  {
    init_simple_test("aBFu16s_L_Sf");
    static STRUCT_IF_C aBFu16s_L_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16s_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_L_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_L_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16s_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_L_Sf, aBFu16s_L_Sf)
//============================================================================



static void Test_aBFu16s_S_Sf()
{
  {
    init_simple_test("aBFu16s_S_Sf");
    static STRUCT_IF_C aBFu16s_S_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_S_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_S_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu16s_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_S_Sf, aBFu16s_S_Sf)
//============================================================================



static void Test_aBFu16s_Sf()
{
  {
    init_simple_test("aBFu16s_Sf");
    static STRUCT_IF_C aBFu16s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf, aBFu16s_Sf)
//============================================================================



static void Test_aBFu16s_Sf_BFu15i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu15i");
    static STRUCT_IF_C aBFu16s_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu15i, aBFu16s_Sf_BFu15i)
//============================================================================



static void Test_aBFu16s_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu15ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu15ll, aBFu16s_Sf_BFu15ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu15s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu15s");
    static STRUCT_IF_C aBFu16s_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu16s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu16s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu15s, aBFu16s_Sf_BFu15s)
//============================================================================



static void Test_aBFu16s_Sf_BFu16i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu16i");
    static STRUCT_IF_C aBFu16s_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu16i, aBFu16s_Sf_BFu16i)
//============================================================================



static void Test_aBFu16s_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu16ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu16ll, aBFu16s_Sf_BFu16ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu16s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu16s");
    static STRUCT_IF_C aBFu16s_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu16s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu16s, aBFu16s_Sf_BFu16s)
//============================================================================



static void Test_aBFu16s_Sf_BFu17i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu17i");
    static STRUCT_IF_C aBFu16s_Sf_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16s_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu16s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu16s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu17i, aBFu16s_Sf_BFu17i)
//============================================================================



static void Test_aBFu16s_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu17ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16s_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu16s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu16s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu17ll, aBFu16s_Sf_BFu17ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu1c()
{
  {
    init_simple_test("aBFu16s_Sf_BFu1c");
    static STRUCT_IF_C aBFu16s_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu1c, aBFu16s_Sf_BFu1c)
//============================================================================



static void Test_aBFu16s_Sf_BFu1i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu1i");
    static STRUCT_IF_C aBFu16s_Sf_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu1i, aBFu16s_Sf_BFu1i)
//============================================================================



static void Test_aBFu16s_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu1ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu1ll, aBFu16s_Sf_BFu1ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu1s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu1s");
    static STRUCT_IF_C aBFu16s_Sf_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu16s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu1s, aBFu16s_Sf_BFu1s)
//============================================================================



static void Test_aBFu16s_Sf_BFu31i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu31i");
    static STRUCT_IF_C aBFu16s_Sf_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu16s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu16s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu31i, aBFu16s_Sf_BFu31i)
//============================================================================



static void Test_aBFu16s_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu31ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu16s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu16s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu31ll, aBFu16s_Sf_BFu31ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu32i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu32i");
    static STRUCT_IF_C aBFu16s_Sf_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu16s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu16s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu32i, aBFu16s_Sf_BFu32i)
//============================================================================



static void Test_aBFu16s_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu32ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu16s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu16s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu32ll, aBFu16s_Sf_BFu32ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu33()
{
  {
    init_simple_test("aBFu16s_Sf_BFu33");
    static STRUCT_IF_C aBFu16s_Sf_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16s_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu33");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu16s_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu16s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu33, aBFu16s_Sf_BFu33)
//============================================================================



static void Test_aBFu16s_Sf_BFu7c()
{
  {
    init_simple_test("aBFu16s_Sf_BFu7c");
    static STRUCT_IF_C aBFu16s_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu7c, aBFu16s_Sf_BFu7c)
//============================================================================



static void Test_aBFu16s_Sf_BFu7i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu7i");
    static STRUCT_IF_C aBFu16s_Sf_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu7i, aBFu16s_Sf_BFu7i)
//============================================================================



static void Test_aBFu16s_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu7ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu7ll, aBFu16s_Sf_BFu7ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu7s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu7s");
    static STRUCT_IF_C aBFu16s_Sf_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu16s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu16s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu7s, aBFu16s_Sf_BFu7s)
//============================================================================



static void Test_aBFu16s_Sf_BFu8c()
{
  {
    init_simple_test("aBFu16s_Sf_BFu8c");
    static STRUCT_IF_C aBFu16s_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu8c, aBFu16s_Sf_BFu8c)
//============================================================================



static void Test_aBFu16s_Sf_BFu8i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu8i");
    static STRUCT_IF_C aBFu16s_Sf_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu8i, aBFu16s_Sf_BFu8i)
//============================================================================



static void Test_aBFu16s_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu8ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu8ll, aBFu16s_Sf_BFu8ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu8s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu8s");
    static STRUCT_IF_C aBFu16s_Sf_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu16s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu16s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu8s, aBFu16s_Sf_BFu8s)
//============================================================================



static void Test_aBFu16s_Sf_BFu9i()
{
  {
    init_simple_test("aBFu16s_Sf_BFu9i");
    static STRUCT_IF_C aBFu16s_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu9i, aBFu16s_Sf_BFu9i)
//============================================================================



static void Test_aBFu16s_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu16s_Sf_BFu9ll");
    static STRUCT_IF_C aBFu16s_Sf_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu9ll, aBFu16s_Sf_BFu9ll)
//============================================================================



static void Test_aBFu16s_Sf_BFu9s()
{
  {
    init_simple_test("aBFu16s_Sf_BFu9s");
    static STRUCT_IF_C aBFu16s_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu16s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu16s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_BFu9s, aBFu16s_Sf_BFu9s)
//============================================================================



static void Test_aBFu16s_Sf_C()
{
  {
    init_simple_test("aBFu16s_Sf_C");
    static STRUCT_IF_C aBFu16s_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_C");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_C.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_C, aBFu16s_Sf_C)
//============================================================================



static void Test_aBFu16s_Sf_D()
{
  {
    init_simple_test("aBFu16s_Sf_D");
    static STRUCT_IF_C aBFu16s_Sf_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16s_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_D");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_D.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_D, aBFu16s_Sf_D)
//============================================================================



static void Test_aBFu16s_Sf_F()
{
  {
    init_simple_test("aBFu16s_Sf_F");
    static STRUCT_IF_C aBFu16s_Sf_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_F");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_F.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_F, aBFu16s_Sf_F)
//============================================================================



static void Test_aBFu16s_Sf_I()
{
  {
    init_simple_test("aBFu16s_Sf_I");
    static STRUCT_IF_C aBFu16s_Sf_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_I");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_I.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_I, aBFu16s_Sf_I)
//============================================================================



static void Test_aBFu16s_Sf_Ip()
{
  {
    init_simple_test("aBFu16s_Sf_Ip");
    static STRUCT_IF_C aBFu16s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16s_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Ip");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Ip, aBFu16s_Sf_Ip)
//============================================================================



static void Test_aBFu16s_Sf_L()
{
  {
    init_simple_test("aBFu16s_Sf_L");
    static STRUCT_IF_C aBFu16s_Sf_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16s_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_L");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_L.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_L, aBFu16s_Sf_L)
//============================================================================



static void Test_aBFu16s_Sf_S()
{
  {
    init_simple_test("aBFu16s_Sf_S");
    static STRUCT_IF_C aBFu16s_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_S");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_S.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_S, aBFu16s_Sf_S)
//============================================================================



static void Test_aBFu16s_Sf_Sf()
{
  {
    init_simple_test("aBFu16s_Sf_Sf");
    static STRUCT_IF_C aBFu16s_Sf_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu16s_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Sf, aBFu16s_Sf_Sf)
//============================================================================



static void Test_aBFu16s_Sf_Uc()
{
  {
    init_simple_test("aBFu16s_Sf_Uc");
    static STRUCT_IF_C aBFu16s_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Uc");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Uc, aBFu16s_Sf_Uc)
//============================================================================



static void Test_aBFu16s_Sf_Ui()
{
  {
    init_simple_test("aBFu16s_Sf_Ui");
    static STRUCT_IF_C aBFu16s_Sf_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Ui");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Ui, aBFu16s_Sf_Ui)
//============================================================================



static void Test_aBFu16s_Sf_Ul()
{
  {
    init_simple_test("aBFu16s_Sf_Ul");
    static STRUCT_IF_C aBFu16s_Sf_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16s_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Ul");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Ul, aBFu16s_Sf_Ul)
//============================================================================



static void Test_aBFu16s_Sf_Us()
{
  {
    init_simple_test("aBFu16s_Sf_Us");
    static STRUCT_IF_C aBFu16s_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Us");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Us, aBFu16s_Sf_Us)
//============================================================================



static void Test_aBFu16s_Sf_Vp()
{
  {
    init_simple_test("aBFu16s_Sf_Vp");
    static STRUCT_IF_C aBFu16s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16s_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Sf_Vp");
    check_field_offset(lv, v2, 2, "aBFu16s_Sf_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu16s_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Sf_Vp, aBFu16s_Sf_Vp)
//============================================================================



static void Test_aBFu16s_Uc_Sf()
{
  {
    init_simple_test("aBFu16s_Uc_Sf");
    static STRUCT_IF_C aBFu16s_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16s_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Uc_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu16s_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Uc_Sf, aBFu16s_Uc_Sf)
//============================================================================



static void Test_aBFu16s_Ui_Sf()
{
  {
    init_simple_test("aBFu16s_Ui_Sf");
    static STRUCT_IF_C aBFu16s_Ui_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16s_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Ui_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Ui_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu16s_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Ui_Sf, aBFu16s_Ui_Sf)
//============================================================================



static void Test_aBFu16s_Ul_Sf()
{
  {
    init_simple_test("aBFu16s_Ul_Sf");
    static STRUCT_IF_C aBFu16s_Ul_Sf lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16s_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Ul_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Ul_Sf.v2");
    check_field_offset(lv, v3, 10, "aBFu16s_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Ul_Sf, aBFu16s_Ul_Sf)
//============================================================================



static void Test_aBFu16s_Us_Sf()
{
  {
    init_simple_test("aBFu16s_Us_Sf");
    static STRUCT_IF_C aBFu16s_Us_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16s_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Us_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu16s_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Us_Sf, aBFu16s_Us_Sf)
//============================================================================



static void Test_aBFu16s_Vp_Sf()
{
  {
    init_simple_test("aBFu16s_Vp_Sf");
    static STRUCT_IF_C aBFu16s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu16s_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16s_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16s_Vp_Sf");
    check_field_offset(lv, v2, 2, "aBFu16s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aBFu16s_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16s_Vp_Sf, aBFu16s_Vp_Sf)
//============================================================================



static void Test_aBFu17i_BFu15i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu15i_Sf");
    static STRUCT_IF_C aBFu17i_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "aBFu17i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "aBFu17i_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu15i_Sf, aBFu17i_BFu15i_Sf)
//============================================================================



static void Test_aBFu17i_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu15ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "aBFu17i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "aBFu17i_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu15ll_Sf, aBFu17i_BFu15ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu15s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu15s_Sf");
    static STRUCT_IF_C aBFu17i_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "aBFu17i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "aBFu17i_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu15s_Sf, aBFu17i_BFu15s_Sf)
//============================================================================



static void Test_aBFu17i_BFu16i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu16i_Sf");
    static STRUCT_IF_C aBFu17i_BFu16i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "aBFu17i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "aBFu17i_BFu16i_Sf");
    check_field_offset(lv, v3, 5, "aBFu17i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu16i_Sf, aBFu17i_BFu16i_Sf)
//============================================================================



static void Test_aBFu17i_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu16ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu16ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "aBFu17i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "aBFu17i_BFu16ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu17i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu16ll_Sf, aBFu17i_BFu16ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu16s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu16s_Sf");
    static STRUCT_IF_C aBFu17i_BFu16s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "aBFu17i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "aBFu17i_BFu16s_Sf");
    check_field_offset(lv, v3, 5, "aBFu17i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu16s_Sf, aBFu17i_BFu16s_Sf)
//============================================================================



static void Test_aBFu17i_BFu17i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu17i_Sf");
    static STRUCT_IF_C aBFu17i_BFu17i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "aBFu17i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "aBFu17i_BFu17i_Sf");
    check_field_offset(lv, v3, 5, "aBFu17i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu17i_Sf, aBFu17i_BFu17i_Sf)
//============================================================================



static void Test_aBFu17i_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu17ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu17ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "aBFu17i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "aBFu17i_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu17i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu17ll_Sf, aBFu17i_BFu17ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu1c_Sf()
{
  {
    init_simple_test("aBFu17i_BFu1c_Sf");
    static STRUCT_IF_C aBFu17i_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17i_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu1c_Sf, aBFu17i_BFu1c_Sf)
//============================================================================



static void Test_aBFu17i_BFu1i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu1i_Sf");
    static STRUCT_IF_C aBFu17i_BFu1i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17i_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu1i_Sf, aBFu17i_BFu1i_Sf)
//============================================================================



static void Test_aBFu17i_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu1ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu1ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17i_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu1ll_Sf, aBFu17i_BFu1ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu1s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu1s_Sf");
    static STRUCT_IF_C aBFu17i_BFu1s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17i_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu1s_Sf, aBFu17i_BFu1s_Sf)
//============================================================================



static void Test_aBFu17i_BFu31i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu31i_Sf");
    static STRUCT_IF_C aBFu17i_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "aBFu17i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "aBFu17i_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu17i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu31i_Sf, aBFu17i_BFu31i_Sf)
//============================================================================



static void Test_aBFu17i_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu31ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "aBFu17i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "aBFu17i_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu17i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu31ll_Sf, aBFu17i_BFu31ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu32i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu32i_Sf");
    static STRUCT_IF_C aBFu17i_BFu32i_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "aBFu17i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "aBFu17i_BFu32i_Sf");
    check_field_offset(lv, v3, 7, "aBFu17i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu32i_Sf, aBFu17i_BFu32i_Sf)
//============================================================================



static void Test_aBFu17i_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu32ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu32ll_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "aBFu17i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "aBFu17i_BFu32ll_Sf");
    check_field_offset(lv, v3, 7, "aBFu17i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu32ll_Sf, aBFu17i_BFu32ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu33_Sf()
{
  {
    init_simple_test("aBFu17i_BFu33_Sf");
    static STRUCT_IF_C aBFu17i_BFu33_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "aBFu17i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "aBFu17i_BFu33_Sf");
    check_field_offset(lv, v3, 7, "aBFu17i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu33_Sf, aBFu17i_BFu33_Sf)
//============================================================================



static void Test_aBFu17i_BFu7c_Sf()
{
  {
    init_simple_test("aBFu17i_BFu7c_Sf");
    static STRUCT_IF_C aBFu17i_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17i_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu7c_Sf, aBFu17i_BFu7c_Sf)
//============================================================================



static void Test_aBFu17i_BFu7i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu7i_Sf");
    static STRUCT_IF_C aBFu17i_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17i_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu7i_Sf, aBFu17i_BFu7i_Sf)
//============================================================================



static void Test_aBFu17i_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu7ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17i_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu7ll_Sf, aBFu17i_BFu7ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu7s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu7s_Sf");
    static STRUCT_IF_C aBFu17i_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17i_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu17i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu7s_Sf, aBFu17i_BFu7s_Sf)
//============================================================================



static void Test_aBFu17i_BFu8c_Sf()
{
  {
    init_simple_test("aBFu17i_BFu8c_Sf");
    static STRUCT_IF_C aBFu17i_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17i_BFu8c_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu8c_Sf, aBFu17i_BFu8c_Sf)
//============================================================================



static void Test_aBFu17i_BFu8i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu8i_Sf");
    static STRUCT_IF_C aBFu17i_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17i_BFu8i_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu8i_Sf, aBFu17i_BFu8i_Sf)
//============================================================================



static void Test_aBFu17i_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu8ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu8ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17i_BFu8ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu8ll_Sf, aBFu17i_BFu8ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu8s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu8s_Sf");
    static STRUCT_IF_C aBFu17i_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17i_BFu8s_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu8s_Sf, aBFu17i_BFu8s_Sf)
//============================================================================



static void Test_aBFu17i_BFu9i_Sf()
{
  {
    init_simple_test("aBFu17i_BFu9i_Sf");
    static STRUCT_IF_C aBFu17i_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "aBFu17i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "aBFu17i_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu9i_Sf, aBFu17i_BFu9i_Sf)
//============================================================================



static void Test_aBFu17i_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu17i_BFu9ll_Sf");
    static STRUCT_IF_C aBFu17i_BFu9ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "aBFu17i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "aBFu17i_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu9ll_Sf, aBFu17i_BFu9ll_Sf)
//============================================================================



static void Test_aBFu17i_BFu9s_Sf()
{
  {
    init_simple_test("aBFu17i_BFu9s_Sf");
    static STRUCT_IF_C aBFu17i_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "aBFu17i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "aBFu17i_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "aBFu17i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_BFu9s_Sf, aBFu17i_BFu9s_Sf)
//============================================================================



static void Test_aBFu17i_C_Sf()
{
  {
    init_simple_test("aBFu17i_C_Sf");
    static STRUCT_IF_C aBFu17i_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_C_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_C_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu17i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_C_Sf, aBFu17i_C_Sf)
//============================================================================



static void Test_aBFu17i_D_Sf()
{
  {
    init_simple_test("aBFu17i_D_Sf");
    static STRUCT_IF_C aBFu17i_D_Sf lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_D_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_D_Sf.v2");
    check_field_offset(lv, v3, 11, "aBFu17i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_D_Sf, aBFu17i_D_Sf)
//============================================================================



static void Test_aBFu17i_F_Sf()
{
  {
    init_simple_test("aBFu17i_F_Sf");
    static STRUCT_IF_C aBFu17i_F_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_F_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_F_Sf.v2");
    check_field_offset(lv, v3, 7, "aBFu17i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_F_Sf, aBFu17i_F_Sf)
//============================================================================



static void Test_aBFu17i_I_Sf()
{
  {
    init_simple_test("aBFu17i_I_Sf");
    static STRUCT_IF_C aBFu17i_I_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_I_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_I_Sf.v2");
    check_field_offset(lv, v3, 7, "aBFu17i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_I_Sf, aBFu17i_I_Sf)
//============================================================================



static void Test_aBFu17i_Ip_Sf()
{
  {
    init_simple_test("aBFu17i_Ip_Sf");
    static STRUCT_IF_C aBFu17i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Ip_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(11,7), "aBFu17i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Ip_Sf, aBFu17i_Ip_Sf)
//============================================================================



static void Test_aBFu17i_L_Sf()
{
  {
    init_simple_test("aBFu17i_L_Sf");
    static STRUCT_IF_C aBFu17i_L_Sf lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_L_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_L_Sf.v2");
    check_field_offset(lv, v3, 11, "aBFu17i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_L_Sf, aBFu17i_L_Sf)
//============================================================================



static void Test_aBFu17i_S_Sf()
{
  {
    init_simple_test("aBFu17i_S_Sf");
    static STRUCT_IF_C aBFu17i_S_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_S_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_S_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu17i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_S_Sf, aBFu17i_S_Sf)
//============================================================================



static void Test_aBFu17i_Sf()
{
  {
    init_simple_test("aBFu17i_Sf");
    static STRUCT_IF_C aBFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf, aBFu17i_Sf)
//============================================================================



static void Test_aBFu17i_Sf_BFu15i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu15i");
    static STRUCT_IF_C aBFu17i_Sf_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu15i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu17i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu17i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu15i, aBFu17i_Sf_BFu15i)
//============================================================================



static void Test_aBFu17i_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu15ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu15ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu17i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu17i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu15ll, aBFu17i_Sf_BFu15ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu15s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu15s");
    static STRUCT_IF_C aBFu17i_Sf_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu15s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu17i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu17i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu15s, aBFu17i_Sf_BFu15s)
//============================================================================



static void Test_aBFu17i_Sf_BFu16i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu16i");
    static STRUCT_IF_C aBFu17i_Sf_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu16i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu17i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu17i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu16i, aBFu17i_Sf_BFu16i)
//============================================================================



static void Test_aBFu17i_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu16ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu16ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu17i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu17i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu16ll, aBFu17i_Sf_BFu16ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu16s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu16s");
    static STRUCT_IF_C aBFu17i_Sf_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu16s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu17i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu17i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu16s, aBFu17i_Sf_BFu16s)
//============================================================================



static void Test_aBFu17i_Sf_BFu17i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu17i");
    static STRUCT_IF_C aBFu17i_Sf_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu17i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu17i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu17i, aBFu17i_Sf_BFu17i)
//============================================================================



static void Test_aBFu17i_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu17ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu17ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu17i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu17ll, aBFu17i_Sf_BFu17ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu1c()
{
  {
    init_simple_test("aBFu17i_Sf_BFu1c");
    static STRUCT_IF_C aBFu17i_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu1c");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu1c, aBFu17i_Sf_BFu1c)
//============================================================================



static void Test_aBFu17i_Sf_BFu1i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu1i");
    static STRUCT_IF_C aBFu17i_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu1i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu1i, aBFu17i_Sf_BFu1i)
//============================================================================



static void Test_aBFu17i_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu1ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu1ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu1ll, aBFu17i_Sf_BFu1ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu1s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu1s");
    static STRUCT_IF_C aBFu17i_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu1s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu1s, aBFu17i_Sf_BFu1s)
//============================================================================



static void Test_aBFu17i_Sf_BFu31i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu31i");
    static STRUCT_IF_C aBFu17i_Sf_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu31i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu17i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu17i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu31i, aBFu17i_Sf_BFu31i)
//============================================================================



static void Test_aBFu17i_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu31ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu31ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu17i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu17i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu31ll, aBFu17i_Sf_BFu31ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu32i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu32i");
    static STRUCT_IF_C aBFu17i_Sf_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu32i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu17i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu17i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu32i, aBFu17i_Sf_BFu32i)
//============================================================================



static void Test_aBFu17i_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu32ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu32ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu17i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu17i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu32ll, aBFu17i_Sf_BFu32ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu33()
{
  {
    init_simple_test("aBFu17i_Sf_BFu33");
    static STRUCT_IF_C aBFu17i_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu17i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu33");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu17i_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu17i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu33, aBFu17i_Sf_BFu33)
//============================================================================



static void Test_aBFu17i_Sf_BFu7c()
{
  {
    init_simple_test("aBFu17i_Sf_BFu7c");
    static STRUCT_IF_C aBFu17i_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu7c");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu7c, aBFu17i_Sf_BFu7c)
//============================================================================



static void Test_aBFu17i_Sf_BFu7i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu7i");
    static STRUCT_IF_C aBFu17i_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu7i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu7i, aBFu17i_Sf_BFu7i)
//============================================================================



static void Test_aBFu17i_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu7ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu7ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu7ll, aBFu17i_Sf_BFu7ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu7s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu7s");
    static STRUCT_IF_C aBFu17i_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu7s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu7s, aBFu17i_Sf_BFu7s)
//============================================================================



static void Test_aBFu17i_Sf_BFu8c()
{
  {
    init_simple_test("aBFu17i_Sf_BFu8c");
    static STRUCT_IF_C aBFu17i_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu8c");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu8c, aBFu17i_Sf_BFu8c)
//============================================================================



static void Test_aBFu17i_Sf_BFu8i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu8i");
    static STRUCT_IF_C aBFu17i_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu8i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu8i, aBFu17i_Sf_BFu8i)
//============================================================================



static void Test_aBFu17i_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu8ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu8ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu8ll, aBFu17i_Sf_BFu8ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu8s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu8s");
    static STRUCT_IF_C aBFu17i_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu8s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu8s, aBFu17i_Sf_BFu8s)
//============================================================================



static void Test_aBFu17i_Sf_BFu9i()
{
  {
    init_simple_test("aBFu17i_Sf_BFu9i");
    static STRUCT_IF_C aBFu17i_Sf_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu9i");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu17i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu17i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu9i, aBFu17i_Sf_BFu9i)
//============================================================================



static void Test_aBFu17i_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu17i_Sf_BFu9ll");
    static STRUCT_IF_C aBFu17i_Sf_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu9ll");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu17i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu17i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu9ll, aBFu17i_Sf_BFu9ll)
//============================================================================



static void Test_aBFu17i_Sf_BFu9s()
{
  {
    init_simple_test("aBFu17i_Sf_BFu9s");
    static STRUCT_IF_C aBFu17i_Sf_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_BFu9s");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu17i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu17i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_BFu9s, aBFu17i_Sf_BFu9s)
//============================================================================



static void Test_aBFu17i_Sf_C()
{
  {
    init_simple_test("aBFu17i_Sf_C");
    static STRUCT_IF_C aBFu17i_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_C");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_C.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_C, aBFu17i_Sf_C)
//============================================================================



static void Test_aBFu17i_Sf_D()
{
  {
    init_simple_test("aBFu17i_Sf_D");
    static STRUCT_IF_C aBFu17i_Sf_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_D");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_D.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_D, aBFu17i_Sf_D)
//============================================================================



static void Test_aBFu17i_Sf_F()
{
  {
    init_simple_test("aBFu17i_Sf_F");
    static STRUCT_IF_C aBFu17i_Sf_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_F");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_F.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_F, aBFu17i_Sf_F)
//============================================================================



static void Test_aBFu17i_Sf_I()
{
  {
    init_simple_test("aBFu17i_Sf_I");
    static STRUCT_IF_C aBFu17i_Sf_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_I");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_I.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_I, aBFu17i_Sf_I)
//============================================================================



static void Test_aBFu17i_Sf_Ip()
{
  {
    init_simple_test("aBFu17i_Sf_Ip");
    static STRUCT_IF_C aBFu17i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Ip");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Ip, aBFu17i_Sf_Ip)
//============================================================================



static void Test_aBFu17i_Sf_L()
{
  {
    init_simple_test("aBFu17i_Sf_L");
    static STRUCT_IF_C aBFu17i_Sf_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_L");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_L.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_L, aBFu17i_Sf_L)
//============================================================================



static void Test_aBFu17i_Sf_S()
{
  {
    init_simple_test("aBFu17i_Sf_S");
    static STRUCT_IF_C aBFu17i_Sf_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_S");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_S.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_S, aBFu17i_Sf_S)
//============================================================================



static void Test_aBFu17i_Sf_Sf()
{
  {
    init_simple_test("aBFu17i_Sf_Sf");
    static STRUCT_IF_C aBFu17i_Sf_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Sf, aBFu17i_Sf_Sf)
//============================================================================



static void Test_aBFu17i_Sf_Uc()
{
  {
    init_simple_test("aBFu17i_Sf_Uc");
    static STRUCT_IF_C aBFu17i_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Uc");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Uc, aBFu17i_Sf_Uc)
//============================================================================



static void Test_aBFu17i_Sf_Ui()
{
  {
    init_simple_test("aBFu17i_Sf_Ui");
    static STRUCT_IF_C aBFu17i_Sf_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Ui");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Ui.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Ui, aBFu17i_Sf_Ui)
//============================================================================



static void Test_aBFu17i_Sf_Ul()
{
  {
    init_simple_test("aBFu17i_Sf_Ul");
    static STRUCT_IF_C aBFu17i_Sf_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Ul");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Ul.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Ul, aBFu17i_Sf_Ul)
//============================================================================



static void Test_aBFu17i_Sf_Us()
{
  {
    init_simple_test("aBFu17i_Sf_Us");
    static STRUCT_IF_C aBFu17i_Sf_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Us");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Us.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Us, aBFu17i_Sf_Us)
//============================================================================



static void Test_aBFu17i_Sf_Vp()
{
  {
    init_simple_test("aBFu17i_Sf_Vp");
    static STRUCT_IF_C aBFu17i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Sf_Vp");
    check_field_offset(lv, v2, 3, "aBFu17i_Sf_Vp.v2");
    check_field_offset(lv, v3, 3, "aBFu17i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Sf_Vp, aBFu17i_Sf_Vp)
//============================================================================



static void Test_aBFu17i_Uc_Sf()
{
  {
    init_simple_test("aBFu17i_Uc_Sf");
    static STRUCT_IF_C aBFu17i_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Uc_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Uc_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu17i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Uc_Sf, aBFu17i_Uc_Sf)
//============================================================================



static void Test_aBFu17i_Ui_Sf()
{
  {
    init_simple_test("aBFu17i_Ui_Sf");
    static STRUCT_IF_C aBFu17i_Ui_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Ui_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Ui_Sf.v2");
    check_field_offset(lv, v3, 7, "aBFu17i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Ui_Sf, aBFu17i_Ui_Sf)
//============================================================================



static void Test_aBFu17i_Ul_Sf()
{
  {
    init_simple_test("aBFu17i_Ul_Sf");
    static STRUCT_IF_C aBFu17i_Ul_Sf lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Ul_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Ul_Sf.v2");
    check_field_offset(lv, v3, 11, "aBFu17i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Ul_Sf, aBFu17i_Ul_Sf)
//============================================================================



static void Test_aBFu17i_Us_Sf()
{
  {
    init_simple_test("aBFu17i_Us_Sf");
    static STRUCT_IF_C aBFu17i_Us_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Us_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Us_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu17i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Us_Sf, aBFu17i_Us_Sf)
//============================================================================



static void Test_aBFu17i_Vp_Sf()
{
  {
    init_simple_test("aBFu17i_Vp_Sf");
    static STRUCT_IF_C aBFu17i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17i_Vp_Sf");
    check_field_offset(lv, v2, 3, "aBFu17i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(11,7), "aBFu17i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17i_Vp_Sf, aBFu17i_Vp_Sf)
//============================================================================



static void Test_aBFu17ll_BFu15i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu15i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "aBFu17ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "aBFu17ll_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu15i_Sf, aBFu17ll_BFu15i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu15ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "aBFu17ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "aBFu17ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu15ll_Sf, aBFu17ll_BFu15ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu15s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu15s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "aBFu17ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "aBFu17ll_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu15s_Sf, aBFu17ll_BFu15s_Sf)
//============================================================================



static void Test_aBFu17ll_BFu16i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu16i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu16i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "aBFu17ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "aBFu17ll_BFu16i_Sf");
    check_field_offset(lv, v3, 5, "aBFu17ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu16i_Sf, aBFu17ll_BFu16i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu16ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "aBFu17ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "aBFu17ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu17ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu16ll_Sf, aBFu17ll_BFu16ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu16s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu16s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu16s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "aBFu17ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "aBFu17ll_BFu16s_Sf");
    check_field_offset(lv, v3, 5, "aBFu17ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu16s_Sf, aBFu17ll_BFu16s_Sf)
//============================================================================



static void Test_aBFu17ll_BFu17i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu17i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu17i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "aBFu17ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "aBFu17ll_BFu17i_Sf");
    check_field_offset(lv, v3, 5, "aBFu17ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu17i_Sf, aBFu17ll_BFu17i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu17ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "aBFu17ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "aBFu17ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu17ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu17ll_Sf, aBFu17ll_BFu17ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu1c_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu1c_Sf");
    static STRUCT_IF_C aBFu17ll_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17ll_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu1c_Sf, aBFu17ll_BFu1c_Sf)
//============================================================================



static void Test_aBFu17ll_BFu1i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu1i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu1i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17ll_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu1i_Sf, aBFu17ll_BFu1i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu1ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu1ll_Sf, aBFu17ll_BFu1ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu1s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu1s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu1s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "aBFu17ll_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu1s_Sf, aBFu17ll_BFu1s_Sf)
//============================================================================



static void Test_aBFu17ll_BFu31i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu31i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu31i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "aBFu17ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "aBFu17ll_BFu31i_Sf");
    check_field_offset(lv, v3, 6, "aBFu17ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu31i_Sf, aBFu17ll_BFu31i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu31ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "aBFu17ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "aBFu17ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu17ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu31ll_Sf, aBFu17ll_BFu31ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu32i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu32i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu32i_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "aBFu17ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "aBFu17ll_BFu32i_Sf");
    check_field_offset(lv, v3, 7, "aBFu17ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu32i_Sf, aBFu17ll_BFu32i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu32ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "aBFu17ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "aBFu17ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 7, "aBFu17ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu32ll_Sf, aBFu17ll_BFu32ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu33_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu33_Sf");
    static STRUCT_IF_C aBFu17ll_BFu33_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "aBFu17ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "aBFu17ll_BFu33_Sf");
    check_field_offset(lv, v3, 7, "aBFu17ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu33_Sf, aBFu17ll_BFu33_Sf)
//============================================================================



static void Test_aBFu17ll_BFu7c_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu7c_Sf");
    static STRUCT_IF_C aBFu17ll_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17ll_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu7c_Sf, aBFu17ll_BFu7c_Sf)
//============================================================================



static void Test_aBFu17ll_BFu7i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu7i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu7i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17ll_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu7i_Sf, aBFu17ll_BFu7i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu7ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu7ll_Sf, aBFu17ll_BFu7ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu7s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu7s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu7s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "aBFu17ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "aBFu17ll_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "aBFu17ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu7s_Sf, aBFu17ll_BFu7s_Sf)
//============================================================================



static void Test_aBFu17ll_BFu8c_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu8c_Sf");
    static STRUCT_IF_C aBFu17ll_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17ll_BFu8c_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu8c_Sf, aBFu17ll_BFu8c_Sf)
//============================================================================



static void Test_aBFu17ll_BFu8i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu8i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17ll_BFu8i_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu8i_Sf, aBFu17ll_BFu8i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu8ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu8ll_Sf, aBFu17ll_BFu8ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu8s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu8s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "aBFu17ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "aBFu17ll_BFu8s_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu8s_Sf, aBFu17ll_BFu8s_Sf)
//============================================================================



static void Test_aBFu17ll_BFu9i_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu9i_Sf");
    static STRUCT_IF_C aBFu17ll_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "aBFu17ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "aBFu17ll_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu9i_Sf, aBFu17ll_BFu9i_Sf)
//============================================================================



static void Test_aBFu17ll_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu9ll_Sf");
    static STRUCT_IF_C aBFu17ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "aBFu17ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "aBFu17ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu9ll_Sf, aBFu17ll_BFu9ll_Sf)
//============================================================================



static void Test_aBFu17ll_BFu9s_Sf()
{
  {
    init_simple_test("aBFu17ll_BFu9s_Sf");
    static STRUCT_IF_C aBFu17ll_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "aBFu17ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "aBFu17ll_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "aBFu17ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_BFu9s_Sf, aBFu17ll_BFu9s_Sf)
//============================================================================



static void Test_aBFu17ll_C_Sf()
{
  {
    init_simple_test("aBFu17ll_C_Sf");
    static STRUCT_IF_C aBFu17ll_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_C_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_C_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu17ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_C_Sf, aBFu17ll_C_Sf)
//============================================================================



static void Test_aBFu17ll_D_Sf()
{
  {
    init_simple_test("aBFu17ll_D_Sf");
    static STRUCT_IF_C aBFu17ll_D_Sf lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_D_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_D_Sf.v2");
    check_field_offset(lv, v3, 11, "aBFu17ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_D_Sf, aBFu17ll_D_Sf)
//============================================================================



static void Test_aBFu17ll_F_Sf()
{
  {
    init_simple_test("aBFu17ll_F_Sf");
    static STRUCT_IF_C aBFu17ll_F_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_F_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_F_Sf.v2");
    check_field_offset(lv, v3, 7, "aBFu17ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_F_Sf, aBFu17ll_F_Sf)
//============================================================================



static void Test_aBFu17ll_I_Sf()
{
  {
    init_simple_test("aBFu17ll_I_Sf");
    static STRUCT_IF_C aBFu17ll_I_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_I_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_I_Sf.v2");
    check_field_offset(lv, v3, 7, "aBFu17ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_I_Sf, aBFu17ll_I_Sf)
//============================================================================



static void Test_aBFu17ll_Ip_Sf()
{
  {
    init_simple_test("aBFu17ll_Ip_Sf");
    static STRUCT_IF_C aBFu17ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Ip_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(11,7), "aBFu17ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Ip_Sf, aBFu17ll_Ip_Sf)
//============================================================================



static void Test_aBFu17ll_L_Sf()
{
  {
    init_simple_test("aBFu17ll_L_Sf");
    static STRUCT_IF_C aBFu17ll_L_Sf lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_L_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_L_Sf.v2");
    check_field_offset(lv, v3, 11, "aBFu17ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_L_Sf, aBFu17ll_L_Sf)
//============================================================================



static void Test_aBFu17ll_S_Sf()
{
  {
    init_simple_test("aBFu17ll_S_Sf");
    static STRUCT_IF_C aBFu17ll_S_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_S_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_S_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu17ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_S_Sf, aBFu17ll_S_Sf)
//============================================================================



static void Test_aBFu17ll_Sf()
{
  {
    init_simple_test("aBFu17ll_Sf");
    static STRUCT_IF_C aBFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf, aBFu17ll_Sf)
//============================================================================



static void Test_aBFu17ll_Sf_BFu15i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu15i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu15i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu17ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu17ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu15i, aBFu17ll_Sf_BFu15i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu15ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu17ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu17ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu15ll, aBFu17ll_Sf_BFu15ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu15s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu15s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu15s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu17ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu17ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu15s, aBFu17ll_Sf_BFu15s)
//============================================================================



static void Test_aBFu17ll_Sf_BFu16i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu16i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu16i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu17ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu17ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu16i, aBFu17ll_Sf_BFu16i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu16ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu17ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu17ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu16ll, aBFu17ll_Sf_BFu16ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu16s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu16s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu16s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu17ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu17ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu16s, aBFu17ll_Sf_BFu16s)
//============================================================================



static void Test_aBFu17ll_Sf_BFu17i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu17i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu17i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu17ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu17i, aBFu17ll_Sf_BFu17i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu17ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu17ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu17ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu17ll, aBFu17ll_Sf_BFu17ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu1c()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu1c");
    static STRUCT_IF_C aBFu17ll_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu1c");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu1c, aBFu17ll_Sf_BFu1c)
//============================================================================



static void Test_aBFu17ll_Sf_BFu1i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu1i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu1i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu1i, aBFu17ll_Sf_BFu1i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu1ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu1ll, aBFu17ll_Sf_BFu1ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu1s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu1s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu1s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu17ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu1s, aBFu17ll_Sf_BFu1s)
//============================================================================



static void Test_aBFu17ll_Sf_BFu31i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu31i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu31i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu17ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu17ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu31i, aBFu17ll_Sf_BFu31i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu31ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu17ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu17ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu31ll, aBFu17ll_Sf_BFu31ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu32i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu32i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu32i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu17ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu17ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu32i, aBFu17ll_Sf_BFu32i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu32ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu17ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu17ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu32ll, aBFu17ll_Sf_BFu32ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu33()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu33");
    static STRUCT_IF_C aBFu17ll_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu17ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu33");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu17ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu17ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu33, aBFu17ll_Sf_BFu33)
//============================================================================



static void Test_aBFu17ll_Sf_BFu7c()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu7c");
    static STRUCT_IF_C aBFu17ll_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu7c");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu7c, aBFu17ll_Sf_BFu7c)
//============================================================================



static void Test_aBFu17ll_Sf_BFu7i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu7i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu7i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu7i, aBFu17ll_Sf_BFu7i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu7ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu7ll, aBFu17ll_Sf_BFu7ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu7s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu7s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu7s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu17ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu17ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu7s, aBFu17ll_Sf_BFu7s)
//============================================================================



static void Test_aBFu17ll_Sf_BFu8c()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu8c");
    static STRUCT_IF_C aBFu17ll_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu8c");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu8c, aBFu17ll_Sf_BFu8c)
//============================================================================



static void Test_aBFu17ll_Sf_BFu8i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu8i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu8i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu8i, aBFu17ll_Sf_BFu8i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu8ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu8ll, aBFu17ll_Sf_BFu8ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu8s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu8s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu8s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu17ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu17ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu8s, aBFu17ll_Sf_BFu8s)
//============================================================================



static void Test_aBFu17ll_Sf_BFu9i()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu9i");
    static STRUCT_IF_C aBFu17ll_Sf_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu9i");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu17ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu17ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu9i, aBFu17ll_Sf_BFu9i)
//============================================================================



static void Test_aBFu17ll_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu9ll");
    static STRUCT_IF_C aBFu17ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu17ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu17ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu9ll, aBFu17ll_Sf_BFu9ll)
//============================================================================



static void Test_aBFu17ll_Sf_BFu9s()
{
  {
    init_simple_test("aBFu17ll_Sf_BFu9s");
    static STRUCT_IF_C aBFu17ll_Sf_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_BFu9s");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu17ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu17ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_BFu9s, aBFu17ll_Sf_BFu9s)
//============================================================================



static void Test_aBFu17ll_Sf_C()
{
  {
    init_simple_test("aBFu17ll_Sf_C");
    static STRUCT_IF_C aBFu17ll_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_C");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_C.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_C, aBFu17ll_Sf_C)
//============================================================================



static void Test_aBFu17ll_Sf_D()
{
  {
    init_simple_test("aBFu17ll_Sf_D");
    static STRUCT_IF_C aBFu17ll_Sf_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_D");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_D.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_D, aBFu17ll_Sf_D)
//============================================================================



static void Test_aBFu17ll_Sf_F()
{
  {
    init_simple_test("aBFu17ll_Sf_F");
    static STRUCT_IF_C aBFu17ll_Sf_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_F");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_F.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_F, aBFu17ll_Sf_F)
//============================================================================



static void Test_aBFu17ll_Sf_I()
{
  {
    init_simple_test("aBFu17ll_Sf_I");
    static STRUCT_IF_C aBFu17ll_Sf_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_I");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_I.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_I, aBFu17ll_Sf_I)
//============================================================================



static void Test_aBFu17ll_Sf_Ip()
{
  {
    init_simple_test("aBFu17ll_Sf_Ip");
    static STRUCT_IF_C aBFu17ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Ip");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Ip, aBFu17ll_Sf_Ip)
//============================================================================



static void Test_aBFu17ll_Sf_L()
{
  {
    init_simple_test("aBFu17ll_Sf_L");
    static STRUCT_IF_C aBFu17ll_Sf_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_L");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_L.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_L, aBFu17ll_Sf_L)
//============================================================================



static void Test_aBFu17ll_Sf_S()
{
  {
    init_simple_test("aBFu17ll_Sf_S");
    static STRUCT_IF_C aBFu17ll_Sf_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_S");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_S.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_S, aBFu17ll_Sf_S)
//============================================================================



static void Test_aBFu17ll_Sf_Sf()
{
  {
    init_simple_test("aBFu17ll_Sf_Sf");
    static STRUCT_IF_C aBFu17ll_Sf_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu17ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Sf, aBFu17ll_Sf_Sf)
//============================================================================



static void Test_aBFu17ll_Sf_Uc()
{
  {
    init_simple_test("aBFu17ll_Sf_Uc");
    static STRUCT_IF_C aBFu17ll_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Uc");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Uc, aBFu17ll_Sf_Uc)
//============================================================================



static void Test_aBFu17ll_Sf_Ui()
{
  {
    init_simple_test("aBFu17ll_Sf_Ui");
    static STRUCT_IF_C aBFu17ll_Sf_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Ui");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Ui, aBFu17ll_Sf_Ui)
//============================================================================



static void Test_aBFu17ll_Sf_Ul()
{
  {
    init_simple_test("aBFu17ll_Sf_Ul");
    static STRUCT_IF_C aBFu17ll_Sf_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Ul");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Ul, aBFu17ll_Sf_Ul)
//============================================================================



static void Test_aBFu17ll_Sf_Us()
{
  {
    init_simple_test("aBFu17ll_Sf_Us");
    static STRUCT_IF_C aBFu17ll_Sf_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Us");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Us.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Us, aBFu17ll_Sf_Us)
//============================================================================



static void Test_aBFu17ll_Sf_Vp()
{
  {
    init_simple_test("aBFu17ll_Sf_Vp");
    static STRUCT_IF_C aBFu17ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Sf_Vp");
    check_field_offset(lv, v2, 3, "aBFu17ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 3, "aBFu17ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Sf_Vp, aBFu17ll_Sf_Vp)
//============================================================================



static void Test_aBFu17ll_Uc_Sf()
{
  {
    init_simple_test("aBFu17ll_Uc_Sf");
    static STRUCT_IF_C aBFu17ll_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu17ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Uc_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 4, "aBFu17ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Uc_Sf, aBFu17ll_Uc_Sf)
//============================================================================



static void Test_aBFu17ll_Ui_Sf()
{
  {
    init_simple_test("aBFu17ll_Ui_Sf");
    static STRUCT_IF_C aBFu17ll_Ui_Sf lv;
    check2(sizeof(lv), 7, "sizeof(aBFu17ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Ui_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 7, "aBFu17ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Ui_Sf, aBFu17ll_Ui_Sf)
//============================================================================



static void Test_aBFu17ll_Ul_Sf()
{
  {
    init_simple_test("aBFu17ll_Ul_Sf");
    static STRUCT_IF_C aBFu17ll_Ul_Sf lv;
    check2(sizeof(lv), 11, "sizeof(aBFu17ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Ul_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 11, "aBFu17ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Ul_Sf, aBFu17ll_Ul_Sf)
//============================================================================



static void Test_aBFu17ll_Us_Sf()
{
  {
    init_simple_test("aBFu17ll_Us_Sf");
    static STRUCT_IF_C aBFu17ll_Us_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu17ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Us_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Us_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu17ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Us_Sf, aBFu17ll_Us_Sf)
//============================================================================



static void Test_aBFu17ll_Vp_Sf()
{
  {
    init_simple_test("aBFu17ll_Vp_Sf");
    static STRUCT_IF_C aBFu17ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu17ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu17ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "aBFu17ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "aBFu17ll_Vp_Sf");
    check_field_offset(lv, v2, 3, "aBFu17ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(11,7), "aBFu17ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu17ll_Vp_Sf, aBFu17ll_Vp_Sf)
//============================================================================



static void Test_aBFu1c_BFu15i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu15i_Sf");
    static STRUCT_IF_C aBFu1c_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1c_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu15i_Sf, aBFu1c_BFu15i_Sf)
//============================================================================



static void Test_aBFu1c_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu15ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1c_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu15ll_Sf, aBFu1c_BFu15ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu15s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu15s_Sf");
    static STRUCT_IF_C aBFu1c_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1c_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu15s_Sf, aBFu1c_BFu15s_Sf)
//============================================================================



static void Test_aBFu1c_BFu16i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu16i_Sf");
    static STRUCT_IF_C aBFu1c_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1c_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1c_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu16i_Sf, aBFu1c_BFu16i_Sf)
//============================================================================



static void Test_aBFu1c_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu16ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1c_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1c_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu16ll_Sf, aBFu1c_BFu16ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu16s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu16s_Sf");
    static STRUCT_IF_C aBFu1c_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1c_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "aBFu1c_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu16s_Sf, aBFu1c_BFu16s_Sf)
//============================================================================



static void Test_aBFu1c_BFu17i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu17i_Sf");
    static STRUCT_IF_C aBFu1c_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1c_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1c_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu17i_Sf, aBFu1c_BFu17i_Sf)
//============================================================================



static void Test_aBFu1c_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu17ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1c_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1c_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu17ll_Sf, aBFu1c_BFu17ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu1c_Sf()
{
  {
    init_simple_test("aBFu1c_BFu1c_Sf");
    static STRUCT_IF_C aBFu1c_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1c_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu1c_Sf, aBFu1c_BFu1c_Sf)
//============================================================================



static void Test_aBFu1c_BFu1i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu1i_Sf");
    static STRUCT_IF_C aBFu1c_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1c_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu1i_Sf, aBFu1c_BFu1i_Sf)
//============================================================================



static void Test_aBFu1c_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu1ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1c_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu1ll_Sf, aBFu1c_BFu1ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu1s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu1s_Sf");
    static STRUCT_IF_C aBFu1c_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1c_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu1s_Sf, aBFu1c_BFu1s_Sf)
//============================================================================



static void Test_aBFu1c_BFu31i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu31i_Sf");
    static STRUCT_IF_C aBFu1c_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1c_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1c_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "aBFu1c_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu31i_Sf, aBFu1c_BFu31i_Sf)
//============================================================================



static void Test_aBFu1c_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu31ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1c_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1c_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu1c_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu31ll_Sf, aBFu1c_BFu31ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu32i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu32i_Sf");
    static STRUCT_IF_C aBFu1c_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1c_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "aBFu1c_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu32i_Sf, aBFu1c_BFu32i_Sf)
//============================================================================



static void Test_aBFu1c_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu32ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1c_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu1c_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu32ll_Sf, aBFu1c_BFu32ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu33_Sf()
{
  {
    init_simple_test("aBFu1c_BFu33_Sf");
    static STRUCT_IF_C aBFu1c_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "aBFu1c_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "aBFu1c_BFu33_Sf");
    check_field_offset(lv, v3, 5, "aBFu1c_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu33_Sf, aBFu1c_BFu33_Sf)
//============================================================================



static void Test_aBFu1c_BFu7c_Sf()
{
  {
    init_simple_test("aBFu1c_BFu7c_Sf");
    static STRUCT_IF_C aBFu1c_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1c_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu7c_Sf, aBFu1c_BFu7c_Sf)
//============================================================================



static void Test_aBFu1c_BFu7i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu7i_Sf");
    static STRUCT_IF_C aBFu1c_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1c_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu7i_Sf, aBFu1c_BFu7i_Sf)
//============================================================================



static void Test_aBFu1c_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu7ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1c_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu7ll_Sf, aBFu1c_BFu7ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu7s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu7s_Sf");
    static STRUCT_IF_C aBFu1c_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1c_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1c_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu7s_Sf, aBFu1c_BFu7s_Sf)
//============================================================================



static void Test_aBFu1c_BFu8c_Sf()
{
  {
    init_simple_test("aBFu1c_BFu8c_Sf");
    static STRUCT_IF_C aBFu1c_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1c_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu8c_Sf, aBFu1c_BFu8c_Sf)
//============================================================================



static void Test_aBFu1c_BFu8i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu8i_Sf");
    static STRUCT_IF_C aBFu1c_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1c_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu8i_Sf, aBFu1c_BFu8i_Sf)
//============================================================================



static void Test_aBFu1c_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu8ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1c_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu8ll_Sf, aBFu1c_BFu8ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu8s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu8s_Sf");
    static STRUCT_IF_C aBFu1c_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1c_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu8s_Sf, aBFu1c_BFu8s_Sf)
//============================================================================



static void Test_aBFu1c_BFu9i_Sf()
{
  {
    init_simple_test("aBFu1c_BFu9i_Sf");
    static STRUCT_IF_C aBFu1c_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1c_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu9i_Sf, aBFu1c_BFu9i_Sf)
//============================================================================



static void Test_aBFu1c_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu1c_BFu9ll_Sf");
    static STRUCT_IF_C aBFu1c_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1c_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu9ll_Sf, aBFu1c_BFu9ll_Sf)
//============================================================================



static void Test_aBFu1c_BFu9s_Sf()
{
  {
    init_simple_test("aBFu1c_BFu9s_Sf");
    static STRUCT_IF_C aBFu1c_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1c_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1c_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_BFu9s_Sf, aBFu1c_BFu9s_Sf)
//============================================================================



static void Test_aBFu1c_C_Sf()
{
  {
    init_simple_test("aBFu1c_C_Sf");
    static STRUCT_IF_C aBFu1c_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_C_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_C_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1c_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_C_Sf, aBFu1c_C_Sf)
//============================================================================



static void Test_aBFu1c_D_Sf()
{
  {
    init_simple_test("aBFu1c_D_Sf");
    static STRUCT_IF_C aBFu1c_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1c_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_D_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_D_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1c_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_D_Sf, aBFu1c_D_Sf)
//============================================================================



static void Test_aBFu1c_F_Sf()
{
  {
    init_simple_test("aBFu1c_F_Sf");
    static STRUCT_IF_C aBFu1c_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_F_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_F_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1c_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_F_Sf, aBFu1c_F_Sf)
//============================================================================



static void Test_aBFu1c_I_Sf()
{
  {
    init_simple_test("aBFu1c_I_Sf");
    static STRUCT_IF_C aBFu1c_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_I_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_I_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1c_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_I_Sf, aBFu1c_I_Sf)
//============================================================================



static void Test_aBFu1c_Ip_Sf()
{
  {
    init_simple_test("aBFu1c_Ip_Sf");
    static STRUCT_IF_C aBFu1c_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1c_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Ip_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1c_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Ip_Sf, aBFu1c_Ip_Sf)
//============================================================================



static void Test_aBFu1c_L_Sf()
{
  {
    init_simple_test("aBFu1c_L_Sf");
    static STRUCT_IF_C aBFu1c_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1c_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_L_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_L_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1c_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_L_Sf, aBFu1c_L_Sf)
//============================================================================



static void Test_aBFu1c_S_Sf()
{
  {
    init_simple_test("aBFu1c_S_Sf");
    static STRUCT_IF_C aBFu1c_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_S_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_S_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1c_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_S_Sf, aBFu1c_S_Sf)
//============================================================================



static void Test_aBFu1c_Sf()
{
  {
    init_simple_test("aBFu1c_Sf");
    static STRUCT_IF_C aBFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf, aBFu1c_Sf)
//============================================================================



static void Test_aBFu1c_Sf_BFu15i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu15i");
    static STRUCT_IF_C aBFu1c_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1c_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1c_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu15i, aBFu1c_Sf_BFu15i)
//============================================================================



static void Test_aBFu1c_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu15ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1c_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1c_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu15ll, aBFu1c_Sf_BFu15ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu15s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu15s");
    static STRUCT_IF_C aBFu1c_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1c_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1c_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu15s, aBFu1c_Sf_BFu15s)
//============================================================================



static void Test_aBFu1c_Sf_BFu16i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu16i");
    static STRUCT_IF_C aBFu1c_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1c_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1c_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu16i, aBFu1c_Sf_BFu16i)
//============================================================================



static void Test_aBFu1c_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu16ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1c_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1c_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu16ll, aBFu1c_Sf_BFu16ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu16s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu16s");
    static STRUCT_IF_C aBFu1c_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1c_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1c_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu16s, aBFu1c_Sf_BFu16s)
//============================================================================



static void Test_aBFu1c_Sf_BFu17i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu17i");
    static STRUCT_IF_C aBFu1c_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1c_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1c_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1c_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu17i, aBFu1c_Sf_BFu17i)
//============================================================================



static void Test_aBFu1c_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu17ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1c_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1c_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1c_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu17ll, aBFu1c_Sf_BFu17ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu1c()
{
  {
    init_simple_test("aBFu1c_Sf_BFu1c");
    static STRUCT_IF_C aBFu1c_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1c_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu1c, aBFu1c_Sf_BFu1c)
//============================================================================



static void Test_aBFu1c_Sf_BFu1i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu1i");
    static STRUCT_IF_C aBFu1c_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1c_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu1i, aBFu1c_Sf_BFu1i)
//============================================================================



static void Test_aBFu1c_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu1ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1c_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu1ll, aBFu1c_Sf_BFu1ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu1s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu1s");
    static STRUCT_IF_C aBFu1c_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1c_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu1s, aBFu1c_Sf_BFu1s)
//============================================================================



static void Test_aBFu1c_Sf_BFu31i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu31i");
    static STRUCT_IF_C aBFu1c_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1c_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1c_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu31i, aBFu1c_Sf_BFu31i)
//============================================================================



static void Test_aBFu1c_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu31ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1c_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1c_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu31ll, aBFu1c_Sf_BFu31ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu32i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu32i");
    static STRUCT_IF_C aBFu1c_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1c_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1c_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu32i, aBFu1c_Sf_BFu32i)
//============================================================================



static void Test_aBFu1c_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu32ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1c_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1c_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu32ll, aBFu1c_Sf_BFu32ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu33()
{
  {
    init_simple_test("aBFu1c_Sf_BFu33");
    static STRUCT_IF_C aBFu1c_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu1c_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu33");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "aBFu1c_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "aBFu1c_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu33, aBFu1c_Sf_BFu33)
//============================================================================



static void Test_aBFu1c_Sf_BFu7c()
{
  {
    init_simple_test("aBFu1c_Sf_BFu7c");
    static STRUCT_IF_C aBFu1c_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1c_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1c_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu7c, aBFu1c_Sf_BFu7c)
//============================================================================



static void Test_aBFu1c_Sf_BFu7i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu7i");
    static STRUCT_IF_C aBFu1c_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1c_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1c_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu7i, aBFu1c_Sf_BFu7i)
//============================================================================



static void Test_aBFu1c_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu7ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1c_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1c_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu7ll, aBFu1c_Sf_BFu7ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu7s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu7s");
    static STRUCT_IF_C aBFu1c_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1c_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1c_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu7s, aBFu1c_Sf_BFu7s)
//============================================================================



static void Test_aBFu1c_Sf_BFu8c()
{
  {
    init_simple_test("aBFu1c_Sf_BFu8c");
    static STRUCT_IF_C aBFu1c_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1c_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1c_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu8c, aBFu1c_Sf_BFu8c)
//============================================================================



static void Test_aBFu1c_Sf_BFu8i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu8i");
    static STRUCT_IF_C aBFu1c_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1c_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1c_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu8i, aBFu1c_Sf_BFu8i)
//============================================================================



static void Test_aBFu1c_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu8ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1c_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1c_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu8ll, aBFu1c_Sf_BFu8ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu8s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu8s");
    static STRUCT_IF_C aBFu1c_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1c_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1c_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu8s, aBFu1c_Sf_BFu8s)
//============================================================================



static void Test_aBFu1c_Sf_BFu9i()
{
  {
    init_simple_test("aBFu1c_Sf_BFu9i");
    static STRUCT_IF_C aBFu1c_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1c_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1c_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu9i, aBFu1c_Sf_BFu9i)
//============================================================================



static void Test_aBFu1c_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu1c_Sf_BFu9ll");
    static STRUCT_IF_C aBFu1c_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1c_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1c_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu9ll, aBFu1c_Sf_BFu9ll)
//============================================================================



static void Test_aBFu1c_Sf_BFu9s()
{
  {
    init_simple_test("aBFu1c_Sf_BFu9s");
    static STRUCT_IF_C aBFu1c_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1c_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1c_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_BFu9s, aBFu1c_Sf_BFu9s)
//============================================================================



static void Test_aBFu1c_Sf_C()
{
  {
    init_simple_test("aBFu1c_Sf_C");
    static STRUCT_IF_C aBFu1c_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_C");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_C.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_C, aBFu1c_Sf_C)
//============================================================================



static void Test_aBFu1c_Sf_D()
{
  {
    init_simple_test("aBFu1c_Sf_D");
    static STRUCT_IF_C aBFu1c_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1c_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_D");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_D.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_D, aBFu1c_Sf_D)
//============================================================================



static void Test_aBFu1c_Sf_F()
{
  {
    init_simple_test("aBFu1c_Sf_F");
    static STRUCT_IF_C aBFu1c_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_F");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_F.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_F, aBFu1c_Sf_F)
//============================================================================



static void Test_aBFu1c_Sf_I()
{
  {
    init_simple_test("aBFu1c_Sf_I");
    static STRUCT_IF_C aBFu1c_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_I");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_I.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_I, aBFu1c_Sf_I)
//============================================================================



static void Test_aBFu1c_Sf_Ip()
{
  {
    init_simple_test("aBFu1c_Sf_Ip");
    static STRUCT_IF_C aBFu1c_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1c_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Ip");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Ip, aBFu1c_Sf_Ip)
//============================================================================



static void Test_aBFu1c_Sf_L()
{
  {
    init_simple_test("aBFu1c_Sf_L");
    static STRUCT_IF_C aBFu1c_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1c_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_L");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_L.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_L, aBFu1c_Sf_L)
//============================================================================



static void Test_aBFu1c_Sf_S()
{
  {
    init_simple_test("aBFu1c_Sf_S");
    static STRUCT_IF_C aBFu1c_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_S");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_S.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_S, aBFu1c_Sf_S)
//============================================================================



static void Test_aBFu1c_Sf_Sf()
{
  {
    init_simple_test("aBFu1c_Sf_Sf");
    static STRUCT_IF_C aBFu1c_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1c_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Sf, aBFu1c_Sf_Sf)
//============================================================================



static void Test_aBFu1c_Sf_Uc()
{
  {
    init_simple_test("aBFu1c_Sf_Uc");
    static STRUCT_IF_C aBFu1c_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Uc");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Uc, aBFu1c_Sf_Uc)
//============================================================================



static void Test_aBFu1c_Sf_Ui()
{
  {
    init_simple_test("aBFu1c_Sf_Ui");
    static STRUCT_IF_C aBFu1c_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Ui");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Ui, aBFu1c_Sf_Ui)
//============================================================================



static void Test_aBFu1c_Sf_Ul()
{
  {
    init_simple_test("aBFu1c_Sf_Ul");
    static STRUCT_IF_C aBFu1c_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1c_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Ul");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Ul, aBFu1c_Sf_Ul)
//============================================================================



static void Test_aBFu1c_Sf_Us()
{
  {
    init_simple_test("aBFu1c_Sf_Us");
    static STRUCT_IF_C aBFu1c_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Us");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Us, aBFu1c_Sf_Us)
//============================================================================



static void Test_aBFu1c_Sf_Vp()
{
  {
    init_simple_test("aBFu1c_Sf_Vp");
    static STRUCT_IF_C aBFu1c_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1c_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Sf_Vp");
    check_field_offset(lv, v2, 1, "aBFu1c_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "aBFu1c_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Sf_Vp, aBFu1c_Sf_Vp)
//============================================================================



static void Test_aBFu1c_Uc_Sf()
{
  {
    init_simple_test("aBFu1c_Uc_Sf");
    static STRUCT_IF_C aBFu1c_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1c_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Uc_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1c_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Uc_Sf, aBFu1c_Uc_Sf)
//============================================================================



static void Test_aBFu1c_Ui_Sf()
{
  {
    init_simple_test("aBFu1c_Ui_Sf");
    static STRUCT_IF_C aBFu1c_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1c_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Ui_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1c_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Ui_Sf, aBFu1c_Ui_Sf)
//============================================================================



static void Test_aBFu1c_Ul_Sf()
{
  {
    init_simple_test("aBFu1c_Ul_Sf");
    static STRUCT_IF_C aBFu1c_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1c_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Ul_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1c_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Ul_Sf, aBFu1c_Ul_Sf)
//============================================================================



static void Test_aBFu1c_Us_Sf()
{
  {
    init_simple_test("aBFu1c_Us_Sf");
    static STRUCT_IF_C aBFu1c_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1c_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Us_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1c_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Us_Sf, aBFu1c_Us_Sf)
//============================================================================



static void Test_aBFu1c_Vp_Sf()
{
  {
    init_simple_test("aBFu1c_Vp_Sf");
    static STRUCT_IF_C aBFu1c_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1c_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1c_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1c_Vp_Sf");
    check_field_offset(lv, v2, 1, "aBFu1c_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1c_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1c_Vp_Sf, aBFu1c_Vp_Sf)
//============================================================================



static void Test_aBFu1i_BFu15i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu15i_Sf");
    static STRUCT_IF_C aBFu1i_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1i_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu15i_Sf, aBFu1i_BFu15i_Sf)
//============================================================================



static void Test_aBFu1i_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu15ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1i_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu15ll_Sf, aBFu1i_BFu15ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu15s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu15s_Sf");
    static STRUCT_IF_C aBFu1i_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1i_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu15s_Sf, aBFu1i_BFu15s_Sf)
//============================================================================



static void Test_aBFu1i_BFu16i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu16i_Sf");
    static STRUCT_IF_C aBFu1i_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1i_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu16i_Sf, aBFu1i_BFu16i_Sf)
//============================================================================



static void Test_aBFu1i_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu16ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1i_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu16ll_Sf, aBFu1i_BFu16ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu16s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu16s_Sf");
    static STRUCT_IF_C aBFu1i_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1i_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "aBFu1i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu16s_Sf, aBFu1i_BFu16s_Sf)
//============================================================================



static void Test_aBFu1i_BFu17i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu17i_Sf");
    static STRUCT_IF_C aBFu1i_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1i_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu17i_Sf, aBFu1i_BFu17i_Sf)
//============================================================================



static void Test_aBFu1i_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu17ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1i_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu17ll_Sf, aBFu1i_BFu17ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu1c_Sf()
{
  {
    init_simple_test("aBFu1i_BFu1c_Sf");
    static STRUCT_IF_C aBFu1i_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1i_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu1c_Sf, aBFu1i_BFu1c_Sf)
//============================================================================



static void Test_aBFu1i_BFu1i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu1i_Sf");
    static STRUCT_IF_C aBFu1i_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1i_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu1i_Sf, aBFu1i_BFu1i_Sf)
//============================================================================



static void Test_aBFu1i_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu1ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1i_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu1ll_Sf, aBFu1i_BFu1ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu1s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu1s_Sf");
    static STRUCT_IF_C aBFu1i_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1i_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu1s_Sf, aBFu1i_BFu1s_Sf)
//============================================================================



static void Test_aBFu1i_BFu31i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu31i_Sf");
    static STRUCT_IF_C aBFu1i_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1i_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "aBFu1i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu31i_Sf, aBFu1i_BFu31i_Sf)
//============================================================================



static void Test_aBFu1i_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu31ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1i_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu1i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu31ll_Sf, aBFu1i_BFu31ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu32i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu32i_Sf");
    static STRUCT_IF_C aBFu1i_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1i_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "aBFu1i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu32i_Sf, aBFu1i_BFu32i_Sf)
//============================================================================



static void Test_aBFu1i_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu32ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1i_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu1i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu32ll_Sf, aBFu1i_BFu32ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu33_Sf()
{
  {
    init_simple_test("aBFu1i_BFu33_Sf");
    static STRUCT_IF_C aBFu1i_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "aBFu1i_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "aBFu1i_BFu33_Sf");
    check_field_offset(lv, v3, 5, "aBFu1i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu33_Sf, aBFu1i_BFu33_Sf)
//============================================================================



static void Test_aBFu1i_BFu7c_Sf()
{
  {
    init_simple_test("aBFu1i_BFu7c_Sf");
    static STRUCT_IF_C aBFu1i_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1i_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu7c_Sf, aBFu1i_BFu7c_Sf)
//============================================================================



static void Test_aBFu1i_BFu7i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu7i_Sf");
    static STRUCT_IF_C aBFu1i_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1i_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu7i_Sf, aBFu1i_BFu7i_Sf)
//============================================================================



static void Test_aBFu1i_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu7ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1i_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu7ll_Sf, aBFu1i_BFu7ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu7s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu7s_Sf");
    static STRUCT_IF_C aBFu1i_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1i_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu7s_Sf, aBFu1i_BFu7s_Sf)
//============================================================================



static void Test_aBFu1i_BFu8c_Sf()
{
  {
    init_simple_test("aBFu1i_BFu8c_Sf");
    static STRUCT_IF_C aBFu1i_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1i_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu8c_Sf, aBFu1i_BFu8c_Sf)
//============================================================================



static void Test_aBFu1i_BFu8i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu8i_Sf");
    static STRUCT_IF_C aBFu1i_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1i_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu8i_Sf, aBFu1i_BFu8i_Sf)
//============================================================================



static void Test_aBFu1i_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu8ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1i_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu8ll_Sf, aBFu1i_BFu8ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu8s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu8s_Sf");
    static STRUCT_IF_C aBFu1i_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1i_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu8s_Sf, aBFu1i_BFu8s_Sf)
//============================================================================



static void Test_aBFu1i_BFu9i_Sf()
{
  {
    init_simple_test("aBFu1i_BFu9i_Sf");
    static STRUCT_IF_C aBFu1i_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1i_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu9i_Sf, aBFu1i_BFu9i_Sf)
//============================================================================



static void Test_aBFu1i_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu1i_BFu9ll_Sf");
    static STRUCT_IF_C aBFu1i_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1i_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu9ll_Sf, aBFu1i_BFu9ll_Sf)
//============================================================================



static void Test_aBFu1i_BFu9s_Sf()
{
  {
    init_simple_test("aBFu1i_BFu9s_Sf");
    static STRUCT_IF_C aBFu1i_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1i_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_BFu9s_Sf, aBFu1i_BFu9s_Sf)
//============================================================================



static void Test_aBFu1i_C_Sf()
{
  {
    init_simple_test("aBFu1i_C_Sf");
    static STRUCT_IF_C aBFu1i_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_C_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_C_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_C_Sf, aBFu1i_C_Sf)
//============================================================================



static void Test_aBFu1i_D_Sf()
{
  {
    init_simple_test("aBFu1i_D_Sf");
    static STRUCT_IF_C aBFu1i_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_D_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_D_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_D_Sf, aBFu1i_D_Sf)
//============================================================================



static void Test_aBFu1i_F_Sf()
{
  {
    init_simple_test("aBFu1i_F_Sf");
    static STRUCT_IF_C aBFu1i_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_F_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_F_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_F_Sf, aBFu1i_F_Sf)
//============================================================================



static void Test_aBFu1i_I_Sf()
{
  {
    init_simple_test("aBFu1i_I_Sf");
    static STRUCT_IF_C aBFu1i_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_I_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_I_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_I_Sf, aBFu1i_I_Sf)
//============================================================================



static void Test_aBFu1i_Ip_Sf()
{
  {
    init_simple_test("aBFu1i_Ip_Sf");
    static STRUCT_IF_C aBFu1i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Ip_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Ip_Sf, aBFu1i_Ip_Sf)
//============================================================================



static void Test_aBFu1i_L_Sf()
{
  {
    init_simple_test("aBFu1i_L_Sf");
    static STRUCT_IF_C aBFu1i_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_L_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_L_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_L_Sf, aBFu1i_L_Sf)
//============================================================================



static void Test_aBFu1i_S_Sf()
{
  {
    init_simple_test("aBFu1i_S_Sf");
    static STRUCT_IF_C aBFu1i_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_S_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_S_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_S_Sf, aBFu1i_S_Sf)
//============================================================================



static void Test_aBFu1i_Sf()
{
  {
    init_simple_test("aBFu1i_Sf");
    static STRUCT_IF_C aBFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf, aBFu1i_Sf)
//============================================================================



static void Test_aBFu1i_Sf_BFu15i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu15i");
    static STRUCT_IF_C aBFu1i_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu15i, aBFu1i_Sf_BFu15i)
//============================================================================



static void Test_aBFu1i_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu15ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu15ll, aBFu1i_Sf_BFu15ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu15s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu15s");
    static STRUCT_IF_C aBFu1i_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu15s, aBFu1i_Sf_BFu15s)
//============================================================================



static void Test_aBFu1i_Sf_BFu16i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu16i");
    static STRUCT_IF_C aBFu1i_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu16i, aBFu1i_Sf_BFu16i)
//============================================================================



static void Test_aBFu1i_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu16ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu16ll, aBFu1i_Sf_BFu16ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu16s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu16s");
    static STRUCT_IF_C aBFu1i_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu16s, aBFu1i_Sf_BFu16s)
//============================================================================



static void Test_aBFu1i_Sf_BFu17i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu17i");
    static STRUCT_IF_C aBFu1i_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu17i, aBFu1i_Sf_BFu17i)
//============================================================================



static void Test_aBFu1i_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu17ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu17ll, aBFu1i_Sf_BFu17ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu1c()
{
  {
    init_simple_test("aBFu1i_Sf_BFu1c");
    static STRUCT_IF_C aBFu1i_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu1c, aBFu1i_Sf_BFu1c)
//============================================================================



static void Test_aBFu1i_Sf_BFu1i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu1i");
    static STRUCT_IF_C aBFu1i_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu1i, aBFu1i_Sf_BFu1i)
//============================================================================



static void Test_aBFu1i_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu1ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu1ll, aBFu1i_Sf_BFu1ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu1s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu1s");
    static STRUCT_IF_C aBFu1i_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu1s, aBFu1i_Sf_BFu1s)
//============================================================================



static void Test_aBFu1i_Sf_BFu31i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu31i");
    static STRUCT_IF_C aBFu1i_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu31i, aBFu1i_Sf_BFu31i)
//============================================================================



static void Test_aBFu1i_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu31ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu31ll, aBFu1i_Sf_BFu31ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu32i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu32i");
    static STRUCT_IF_C aBFu1i_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu32i, aBFu1i_Sf_BFu32i)
//============================================================================



static void Test_aBFu1i_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu32ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu32ll, aBFu1i_Sf_BFu32ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu33()
{
  {
    init_simple_test("aBFu1i_Sf_BFu33");
    static STRUCT_IF_C aBFu1i_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu1i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu33");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "aBFu1i_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "aBFu1i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu33, aBFu1i_Sf_BFu33)
//============================================================================



static void Test_aBFu1i_Sf_BFu7c()
{
  {
    init_simple_test("aBFu1i_Sf_BFu7c");
    static STRUCT_IF_C aBFu1i_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu7c, aBFu1i_Sf_BFu7c)
//============================================================================



static void Test_aBFu1i_Sf_BFu7i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu7i");
    static STRUCT_IF_C aBFu1i_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu7i, aBFu1i_Sf_BFu7i)
//============================================================================



static void Test_aBFu1i_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu7ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu7ll, aBFu1i_Sf_BFu7ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu7s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu7s");
    static STRUCT_IF_C aBFu1i_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu7s, aBFu1i_Sf_BFu7s)
//============================================================================



static void Test_aBFu1i_Sf_BFu8c()
{
  {
    init_simple_test("aBFu1i_Sf_BFu8c");
    static STRUCT_IF_C aBFu1i_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu8c, aBFu1i_Sf_BFu8c)
//============================================================================



static void Test_aBFu1i_Sf_BFu8i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu8i");
    static STRUCT_IF_C aBFu1i_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1i_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu8i, aBFu1i_Sf_BFu8i)
//============================================================================



static void Test_aBFu1i_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu8ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1i_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu8ll, aBFu1i_Sf_BFu8ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu8s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu8s");
    static STRUCT_IF_C aBFu1i_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1i_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu8s, aBFu1i_Sf_BFu8s)
//============================================================================



static void Test_aBFu1i_Sf_BFu9i()
{
  {
    init_simple_test("aBFu1i_Sf_BFu9i");
    static STRUCT_IF_C aBFu1i_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1i_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu9i, aBFu1i_Sf_BFu9i)
//============================================================================



static void Test_aBFu1i_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu1i_Sf_BFu9ll");
    static STRUCT_IF_C aBFu1i_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1i_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu9ll, aBFu1i_Sf_BFu9ll)
//============================================================================



static void Test_aBFu1i_Sf_BFu9s()
{
  {
    init_simple_test("aBFu1i_Sf_BFu9s");
    static STRUCT_IF_C aBFu1i_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1i_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_BFu9s, aBFu1i_Sf_BFu9s)
//============================================================================



static void Test_aBFu1i_Sf_C()
{
  {
    init_simple_test("aBFu1i_Sf_C");
    static STRUCT_IF_C aBFu1i_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_C");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_C.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_C, aBFu1i_Sf_C)
//============================================================================



static void Test_aBFu1i_Sf_D()
{
  {
    init_simple_test("aBFu1i_Sf_D");
    static STRUCT_IF_C aBFu1i_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1i_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_D");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_D.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_D, aBFu1i_Sf_D)
//============================================================================



static void Test_aBFu1i_Sf_F()
{
  {
    init_simple_test("aBFu1i_Sf_F");
    static STRUCT_IF_C aBFu1i_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_F");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_F.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_F, aBFu1i_Sf_F)
//============================================================================



static void Test_aBFu1i_Sf_I()
{
  {
    init_simple_test("aBFu1i_Sf_I");
    static STRUCT_IF_C aBFu1i_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_I");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_I.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_I, aBFu1i_Sf_I)
//============================================================================



static void Test_aBFu1i_Sf_Ip()
{
  {
    init_simple_test("aBFu1i_Sf_Ip");
    static STRUCT_IF_C aBFu1i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1i_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Ip");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Ip, aBFu1i_Sf_Ip)
//============================================================================



static void Test_aBFu1i_Sf_L()
{
  {
    init_simple_test("aBFu1i_Sf_L");
    static STRUCT_IF_C aBFu1i_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1i_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_L");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_L.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_L, aBFu1i_Sf_L)
//============================================================================



static void Test_aBFu1i_Sf_S()
{
  {
    init_simple_test("aBFu1i_Sf_S");
    static STRUCT_IF_C aBFu1i_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_S");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_S.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_S, aBFu1i_Sf_S)
//============================================================================



static void Test_aBFu1i_Sf_Sf()
{
  {
    init_simple_test("aBFu1i_Sf_Sf");
    static STRUCT_IF_C aBFu1i_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1i_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Sf, aBFu1i_Sf_Sf)
//============================================================================



static void Test_aBFu1i_Sf_Uc()
{
  {
    init_simple_test("aBFu1i_Sf_Uc");
    static STRUCT_IF_C aBFu1i_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Uc");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Uc, aBFu1i_Sf_Uc)
//============================================================================



static void Test_aBFu1i_Sf_Ui()
{
  {
    init_simple_test("aBFu1i_Sf_Ui");
    static STRUCT_IF_C aBFu1i_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Ui");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Ui, aBFu1i_Sf_Ui)
//============================================================================



static void Test_aBFu1i_Sf_Ul()
{
  {
    init_simple_test("aBFu1i_Sf_Ul");
    static STRUCT_IF_C aBFu1i_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1i_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Ul");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Ul, aBFu1i_Sf_Ul)
//============================================================================



static void Test_aBFu1i_Sf_Us()
{
  {
    init_simple_test("aBFu1i_Sf_Us");
    static STRUCT_IF_C aBFu1i_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Us");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Us, aBFu1i_Sf_Us)
//============================================================================



static void Test_aBFu1i_Sf_Vp()
{
  {
    init_simple_test("aBFu1i_Sf_Vp");
    static STRUCT_IF_C aBFu1i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1i_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Sf_Vp");
    check_field_offset(lv, v2, 1, "aBFu1i_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "aBFu1i_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Sf_Vp, aBFu1i_Sf_Vp)
//============================================================================



static void Test_aBFu1i_Uc_Sf()
{
  {
    init_simple_test("aBFu1i_Uc_Sf");
    static STRUCT_IF_C aBFu1i_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1i_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Uc_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1i_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Uc_Sf, aBFu1i_Uc_Sf)
//============================================================================



static void Test_aBFu1i_Ui_Sf()
{
  {
    init_simple_test("aBFu1i_Ui_Sf");
    static STRUCT_IF_C aBFu1i_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1i_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Ui_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1i_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Ui_Sf, aBFu1i_Ui_Sf)
//============================================================================



static void Test_aBFu1i_Ul_Sf()
{
  {
    init_simple_test("aBFu1i_Ul_Sf");
    static STRUCT_IF_C aBFu1i_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1i_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Ul_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1i_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Ul_Sf, aBFu1i_Ul_Sf)
//============================================================================



static void Test_aBFu1i_Us_Sf()
{
  {
    init_simple_test("aBFu1i_Us_Sf");
    static STRUCT_IF_C aBFu1i_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1i_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Us_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1i_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Us_Sf, aBFu1i_Us_Sf)
//============================================================================



static void Test_aBFu1i_Vp_Sf()
{
  {
    init_simple_test("aBFu1i_Vp_Sf");
    static STRUCT_IF_C aBFu1i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1i_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1i_Vp_Sf");
    check_field_offset(lv, v2, 1, "aBFu1i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1i_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1i_Vp_Sf, aBFu1i_Vp_Sf)
//============================================================================



static void Test_aBFu1ll_BFu15i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu15i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1ll_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu15i_Sf, aBFu1ll_BFu15i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu15ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu15ll_Sf, aBFu1ll_BFu15ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu15s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu15s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1ll_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu15s_Sf, aBFu1ll_BFu15s_Sf)
//============================================================================



static void Test_aBFu1ll_BFu16i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu16i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1ll_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1ll_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu16i_Sf, aBFu1ll_BFu16i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu16ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1ll_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu16ll_Sf, aBFu1ll_BFu16ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu16s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu16s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1ll_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "aBFu1ll_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu16s_Sf, aBFu1ll_BFu16s_Sf)
//============================================================================



static void Test_aBFu1ll_BFu17i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu17i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1ll_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1ll_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu17i_Sf, aBFu1ll_BFu17i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu17ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1ll_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu17ll_Sf, aBFu1ll_BFu17ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu1c_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu1c_Sf");
    static STRUCT_IF_C aBFu1ll_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1ll_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu1c_Sf, aBFu1ll_BFu1c_Sf)
//============================================================================



static void Test_aBFu1ll_BFu1i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu1i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1ll_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu1i_Sf, aBFu1ll_BFu1i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu1ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu1ll_Sf, aBFu1ll_BFu1ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu1s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu1s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1ll_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu1s_Sf, aBFu1ll_BFu1s_Sf)
//============================================================================



static void Test_aBFu1ll_BFu31i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu31i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1ll_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1ll_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "aBFu1ll_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu31i_Sf, aBFu1ll_BFu31i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu31ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1ll_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu1ll_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu31ll_Sf, aBFu1ll_BFu31ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu32i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu32i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1ll_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "aBFu1ll_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu32i_Sf, aBFu1ll_BFu32i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu32ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu1ll_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu32ll_Sf, aBFu1ll_BFu32ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu33_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu33_Sf");
    static STRUCT_IF_C aBFu1ll_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "aBFu1ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "aBFu1ll_BFu33_Sf");
    check_field_offset(lv, v3, 5, "aBFu1ll_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu33_Sf, aBFu1ll_BFu33_Sf)
//============================================================================



static void Test_aBFu1ll_BFu7c_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu7c_Sf");
    static STRUCT_IF_C aBFu1ll_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1ll_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu7c_Sf, aBFu1ll_BFu7c_Sf)
//============================================================================



static void Test_aBFu1ll_BFu7i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu7i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1ll_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu7i_Sf, aBFu1ll_BFu7i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu7ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu7ll_Sf, aBFu1ll_BFu7ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu7s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu7s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1ll_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1ll_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu7s_Sf, aBFu1ll_BFu7s_Sf)
//============================================================================



static void Test_aBFu1ll_BFu8c_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu8c_Sf");
    static STRUCT_IF_C aBFu1ll_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1ll_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu8c_Sf, aBFu1ll_BFu8c_Sf)
//============================================================================



static void Test_aBFu1ll_BFu8i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu8i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1ll_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu8i_Sf, aBFu1ll_BFu8i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu8ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu8ll_Sf, aBFu1ll_BFu8ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu8s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu8s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1ll_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu8s_Sf, aBFu1ll_BFu8s_Sf)
//============================================================================



static void Test_aBFu1ll_BFu9i_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu9i_Sf");
    static STRUCT_IF_C aBFu1ll_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1ll_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu9i_Sf, aBFu1ll_BFu9i_Sf)
//============================================================================



static void Test_aBFu1ll_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu9ll_Sf");
    static STRUCT_IF_C aBFu1ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu9ll_Sf, aBFu1ll_BFu9ll_Sf)
//============================================================================



static void Test_aBFu1ll_BFu9s_Sf()
{
  {
    init_simple_test("aBFu1ll_BFu9s_Sf");
    static STRUCT_IF_C aBFu1ll_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1ll_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1ll_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_BFu9s_Sf, aBFu1ll_BFu9s_Sf)
//============================================================================



static void Test_aBFu1ll_C_Sf()
{
  {
    init_simple_test("aBFu1ll_C_Sf");
    static STRUCT_IF_C aBFu1ll_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_C_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_C_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1ll_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_C_Sf, aBFu1ll_C_Sf)
//============================================================================



static void Test_aBFu1ll_D_Sf()
{
  {
    init_simple_test("aBFu1ll_D_Sf");
    static STRUCT_IF_C aBFu1ll_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1ll_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_D_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_D_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1ll_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_D_Sf, aBFu1ll_D_Sf)
//============================================================================



static void Test_aBFu1ll_F_Sf()
{
  {
    init_simple_test("aBFu1ll_F_Sf");
    static STRUCT_IF_C aBFu1ll_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_F_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_F_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1ll_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_F_Sf, aBFu1ll_F_Sf)
//============================================================================



static void Test_aBFu1ll_I_Sf()
{
  {
    init_simple_test("aBFu1ll_I_Sf");
    static STRUCT_IF_C aBFu1ll_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_I_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_I_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1ll_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_I_Sf, aBFu1ll_I_Sf)
//============================================================================



static void Test_aBFu1ll_Ip_Sf()
{
  {
    init_simple_test("aBFu1ll_Ip_Sf");
    static STRUCT_IF_C aBFu1ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1ll_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Ip_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1ll_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Ip_Sf, aBFu1ll_Ip_Sf)
//============================================================================



static void Test_aBFu1ll_L_Sf()
{
  {
    init_simple_test("aBFu1ll_L_Sf");
    static STRUCT_IF_C aBFu1ll_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1ll_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_L_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_L_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1ll_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_L_Sf, aBFu1ll_L_Sf)
//============================================================================



static void Test_aBFu1ll_S_Sf()
{
  {
    init_simple_test("aBFu1ll_S_Sf");
    static STRUCT_IF_C aBFu1ll_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_S_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_S_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1ll_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_S_Sf, aBFu1ll_S_Sf)
//============================================================================



static void Test_aBFu1ll_Sf()
{
  {
    init_simple_test("aBFu1ll_Sf");
    static STRUCT_IF_C aBFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf, aBFu1ll_Sf)
//============================================================================



static void Test_aBFu1ll_Sf_BFu15i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu15i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1ll_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu15i, aBFu1ll_Sf_BFu15i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu15ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1ll_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu15ll, aBFu1ll_Sf_BFu15ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu15s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu15s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1ll_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu15s, aBFu1ll_Sf_BFu15s)
//============================================================================



static void Test_aBFu1ll_Sf_BFu16i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu16i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1ll_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu16i, aBFu1ll_Sf_BFu16i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu16ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1ll_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu16ll, aBFu1ll_Sf_BFu16ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu16s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu16s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1ll_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu16s, aBFu1ll_Sf_BFu16s)
//============================================================================



static void Test_aBFu1ll_Sf_BFu17i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu17i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1ll_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1ll_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu17i, aBFu1ll_Sf_BFu17i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu17ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1ll_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1ll_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu17ll, aBFu1ll_Sf_BFu17ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu1c()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu1c");
    static STRUCT_IF_C aBFu1ll_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1ll_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu1c, aBFu1ll_Sf_BFu1c)
//============================================================================



static void Test_aBFu1ll_Sf_BFu1i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu1i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1ll_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu1i, aBFu1ll_Sf_BFu1i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu1ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1ll_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu1ll, aBFu1ll_Sf_BFu1ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu1s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu1s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1ll_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu1s, aBFu1ll_Sf_BFu1s)
//============================================================================



static void Test_aBFu1ll_Sf_BFu31i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu31i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1ll_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu31i, aBFu1ll_Sf_BFu31i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu31ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1ll_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu31ll, aBFu1ll_Sf_BFu31ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu32i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu32i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1ll_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu32i, aBFu1ll_Sf_BFu32i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu32ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1ll_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu32ll, aBFu1ll_Sf_BFu32ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu33()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu33");
    static STRUCT_IF_C aBFu1ll_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu1ll_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu33");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "aBFu1ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "aBFu1ll_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu33, aBFu1ll_Sf_BFu33)
//============================================================================



static void Test_aBFu1ll_Sf_BFu7c()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu7c");
    static STRUCT_IF_C aBFu1ll_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1ll_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu7c, aBFu1ll_Sf_BFu7c)
//============================================================================



static void Test_aBFu1ll_Sf_BFu7i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu7i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1ll_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu7i, aBFu1ll_Sf_BFu7i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu7ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1ll_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu7ll, aBFu1ll_Sf_BFu7ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu7s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu7s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1ll_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu7s, aBFu1ll_Sf_BFu7s)
//============================================================================



static void Test_aBFu1ll_Sf_BFu8c()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu8c");
    static STRUCT_IF_C aBFu1ll_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1ll_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu8c, aBFu1ll_Sf_BFu8c)
//============================================================================



static void Test_aBFu1ll_Sf_BFu8i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu8i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1ll_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu8i, aBFu1ll_Sf_BFu8i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu8ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1ll_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu8ll, aBFu1ll_Sf_BFu8ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu8s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu8s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1ll_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu8s, aBFu1ll_Sf_BFu8s)
//============================================================================



static void Test_aBFu1ll_Sf_BFu9i()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu9i");
    static STRUCT_IF_C aBFu1ll_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1ll_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu9i, aBFu1ll_Sf_BFu9i)
//============================================================================



static void Test_aBFu1ll_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu9ll");
    static STRUCT_IF_C aBFu1ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1ll_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu9ll, aBFu1ll_Sf_BFu9ll)
//============================================================================



static void Test_aBFu1ll_Sf_BFu9s()
{
  {
    init_simple_test("aBFu1ll_Sf_BFu9s");
    static STRUCT_IF_C aBFu1ll_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1ll_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_BFu9s, aBFu1ll_Sf_BFu9s)
//============================================================================



static void Test_aBFu1ll_Sf_C()
{
  {
    init_simple_test("aBFu1ll_Sf_C");
    static STRUCT_IF_C aBFu1ll_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_C");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_C.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_C, aBFu1ll_Sf_C)
//============================================================================



static void Test_aBFu1ll_Sf_D()
{
  {
    init_simple_test("aBFu1ll_Sf_D");
    static STRUCT_IF_C aBFu1ll_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1ll_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_D");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_D.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_D, aBFu1ll_Sf_D)
//============================================================================



static void Test_aBFu1ll_Sf_F()
{
  {
    init_simple_test("aBFu1ll_Sf_F");
    static STRUCT_IF_C aBFu1ll_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_F");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_F.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_F, aBFu1ll_Sf_F)
//============================================================================



static void Test_aBFu1ll_Sf_I()
{
  {
    init_simple_test("aBFu1ll_Sf_I");
    static STRUCT_IF_C aBFu1ll_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_I");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_I.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_I, aBFu1ll_Sf_I)
//============================================================================



static void Test_aBFu1ll_Sf_Ip()
{
  {
    init_simple_test("aBFu1ll_Sf_Ip");
    static STRUCT_IF_C aBFu1ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1ll_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Ip");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Ip, aBFu1ll_Sf_Ip)
//============================================================================



static void Test_aBFu1ll_Sf_L()
{
  {
    init_simple_test("aBFu1ll_Sf_L");
    static STRUCT_IF_C aBFu1ll_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1ll_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_L");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_L.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_L, aBFu1ll_Sf_L)
//============================================================================



static void Test_aBFu1ll_Sf_S()
{
  {
    init_simple_test("aBFu1ll_Sf_S");
    static STRUCT_IF_C aBFu1ll_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_S");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_S.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_S, aBFu1ll_Sf_S)
//============================================================================



static void Test_aBFu1ll_Sf_Sf()
{
  {
    init_simple_test("aBFu1ll_Sf_Sf");
    static STRUCT_IF_C aBFu1ll_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1ll_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Sf, aBFu1ll_Sf_Sf)
//============================================================================



static void Test_aBFu1ll_Sf_Uc()
{
  {
    init_simple_test("aBFu1ll_Sf_Uc");
    static STRUCT_IF_C aBFu1ll_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Uc");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Uc, aBFu1ll_Sf_Uc)
//============================================================================



static void Test_aBFu1ll_Sf_Ui()
{
  {
    init_simple_test("aBFu1ll_Sf_Ui");
    static STRUCT_IF_C aBFu1ll_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Ui");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Ui, aBFu1ll_Sf_Ui)
//============================================================================



static void Test_aBFu1ll_Sf_Ul()
{
  {
    init_simple_test("aBFu1ll_Sf_Ul");
    static STRUCT_IF_C aBFu1ll_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1ll_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Ul");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Ul, aBFu1ll_Sf_Ul)
//============================================================================



static void Test_aBFu1ll_Sf_Us()
{
  {
    init_simple_test("aBFu1ll_Sf_Us");
    static STRUCT_IF_C aBFu1ll_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Us");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Us, aBFu1ll_Sf_Us)
//============================================================================



static void Test_aBFu1ll_Sf_Vp()
{
  {
    init_simple_test("aBFu1ll_Sf_Vp");
    static STRUCT_IF_C aBFu1ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1ll_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Sf_Vp");
    check_field_offset(lv, v2, 1, "aBFu1ll_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "aBFu1ll_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Sf_Vp, aBFu1ll_Sf_Vp)
//============================================================================



static void Test_aBFu1ll_Uc_Sf()
{
  {
    init_simple_test("aBFu1ll_Uc_Sf");
    static STRUCT_IF_C aBFu1ll_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1ll_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Uc_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1ll_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Uc_Sf, aBFu1ll_Uc_Sf)
//============================================================================



static void Test_aBFu1ll_Ui_Sf()
{
  {
    init_simple_test("aBFu1ll_Ui_Sf");
    static STRUCT_IF_C aBFu1ll_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1ll_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Ui_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1ll_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Ui_Sf, aBFu1ll_Ui_Sf)
//============================================================================



static void Test_aBFu1ll_Ul_Sf()
{
  {
    init_simple_test("aBFu1ll_Ul_Sf");
    static STRUCT_IF_C aBFu1ll_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1ll_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Ul_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1ll_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Ul_Sf, aBFu1ll_Ul_Sf)
//============================================================================



static void Test_aBFu1ll_Us_Sf()
{
  {
    init_simple_test("aBFu1ll_Us_Sf");
    static STRUCT_IF_C aBFu1ll_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1ll_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Us_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1ll_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Us_Sf, aBFu1ll_Us_Sf)
//============================================================================



static void Test_aBFu1ll_Vp_Sf()
{
  {
    init_simple_test("aBFu1ll_Vp_Sf");
    static STRUCT_IF_C aBFu1ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1ll_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1ll_Vp_Sf");
    check_field_offset(lv, v2, 1, "aBFu1ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1ll_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1ll_Vp_Sf, aBFu1ll_Vp_Sf)
//============================================================================



static void Test_aBFu1s_BFu15i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu15i_Sf");
    static STRUCT_IF_C aBFu1s_BFu15i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1s_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu15i_Sf, aBFu1s_BFu15i_Sf)
//============================================================================



static void Test_aBFu1s_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu15ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu15ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1s_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu15ll_Sf, aBFu1s_BFu15ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu15s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu15s_Sf");
    static STRUCT_IF_C aBFu1s_BFu15s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "aBFu1s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "aBFu1s_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu15s_Sf, aBFu1s_BFu15s_Sf)
//============================================================================



static void Test_aBFu1s_BFu16i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu16i_Sf");
    static STRUCT_IF_C aBFu1s_BFu16i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1s_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1s_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu16i_Sf, aBFu1s_BFu16i_Sf)
//============================================================================



static void Test_aBFu1s_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu16ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu16ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1s_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1s_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu16ll_Sf, aBFu1s_BFu16ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu16s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu16s_Sf");
    static STRUCT_IF_C aBFu1s_BFu16s_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "aBFu1s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "aBFu1s_BFu16s_Sf");
    check_field_offset(lv, v3, 3, "aBFu1s_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu16s_Sf, aBFu1s_BFu16s_Sf)
//============================================================================



static void Test_aBFu1s_BFu17i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu17i_Sf");
    static STRUCT_IF_C aBFu1s_BFu17i_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1s_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "aBFu1s_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu17i_Sf, aBFu1s_BFu17i_Sf)
//============================================================================



static void Test_aBFu1s_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu17ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu17ll_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "aBFu1s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "aBFu1s_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "aBFu1s_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu17ll_Sf, aBFu1s_BFu17ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu1c_Sf()
{
  {
    init_simple_test("aBFu1s_BFu1c_Sf");
    static STRUCT_IF_C aBFu1s_BFu1c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1s_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu1c_Sf, aBFu1s_BFu1c_Sf)
//============================================================================



static void Test_aBFu1s_BFu1i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu1i_Sf");
    static STRUCT_IF_C aBFu1s_BFu1i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1s_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu1i_Sf, aBFu1s_BFu1i_Sf)
//============================================================================



static void Test_aBFu1s_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu1ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu1ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1s_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu1ll_Sf, aBFu1s_BFu1ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu1s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu1s_Sf");
    static STRUCT_IF_C aBFu1s_BFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "aBFu1s_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu1s_Sf, aBFu1s_BFu1s_Sf)
//============================================================================



static void Test_aBFu1s_BFu31i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu31i_Sf");
    static STRUCT_IF_C aBFu1s_BFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1s_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1s_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "aBFu1s_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu31i_Sf, aBFu1s_BFu31i_Sf)
//============================================================================



static void Test_aBFu1s_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu31ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu31ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1s_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "aBFu1s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "aBFu1s_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu1s_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu31ll_Sf, aBFu1s_BFu31ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu32i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu32i_Sf");
    static STRUCT_IF_C aBFu1s_BFu32i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1s_BFu32i_Sf");
    check_field_offset(lv, v3, 5, "aBFu1s_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu32i_Sf, aBFu1s_BFu32i_Sf)
//============================================================================



static void Test_aBFu1s_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu32ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu32ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "aBFu1s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "aBFu1s_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu1s_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu32ll_Sf, aBFu1s_BFu32ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu33_Sf()
{
  {
    init_simple_test("aBFu1s_BFu33_Sf");
    static STRUCT_IF_C aBFu1s_BFu33_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "aBFu1s_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "aBFu1s_BFu33_Sf");
    check_field_offset(lv, v3, 5, "aBFu1s_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu33_Sf, aBFu1s_BFu33_Sf)
//============================================================================



static void Test_aBFu1s_BFu7c_Sf()
{
  {
    init_simple_test("aBFu1s_BFu7c_Sf");
    static STRUCT_IF_C aBFu1s_BFu7c_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1s_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu7c_Sf, aBFu1s_BFu7c_Sf)
//============================================================================



static void Test_aBFu1s_BFu7i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu7i_Sf");
    static STRUCT_IF_C aBFu1s_BFu7i_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1s_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu7i_Sf, aBFu1s_BFu7i_Sf)
//============================================================================



static void Test_aBFu1s_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu7ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu7ll_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1s_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu7ll_Sf, aBFu1s_BFu7ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu7s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu7s_Sf");
    static STRUCT_IF_C aBFu1s_BFu7s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "aBFu1s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "aBFu1s_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "aBFu1s_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu7s_Sf, aBFu1s_BFu7s_Sf)
//============================================================================



static void Test_aBFu1s_BFu8c_Sf()
{
  {
    init_simple_test("aBFu1s_BFu8c_Sf");
    static STRUCT_IF_C aBFu1s_BFu8c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1s_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu8c_Sf, aBFu1s_BFu8c_Sf)
//============================================================================



static void Test_aBFu1s_BFu8i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu8i_Sf");
    static STRUCT_IF_C aBFu1s_BFu8i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1s_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu8i_Sf, aBFu1s_BFu8i_Sf)
//============================================================================



static void Test_aBFu1s_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu8ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu8ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1s_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu8ll_Sf, aBFu1s_BFu8ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu8s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu8s_Sf");
    static STRUCT_IF_C aBFu1s_BFu8s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "aBFu1s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "aBFu1s_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu8s_Sf, aBFu1s_BFu8s_Sf)
//============================================================================



static void Test_aBFu1s_BFu9i_Sf()
{
  {
    init_simple_test("aBFu1s_BFu9i_Sf");
    static STRUCT_IF_C aBFu1s_BFu9i_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1s_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu9i_Sf, aBFu1s_BFu9i_Sf)
//============================================================================



static void Test_aBFu1s_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu1s_BFu9ll_Sf");
    static STRUCT_IF_C aBFu1s_BFu9ll_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1s_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu9ll_Sf, aBFu1s_BFu9ll_Sf)
//============================================================================



static void Test_aBFu1s_BFu9s_Sf()
{
  {
    init_simple_test("aBFu1s_BFu9s_Sf");
    static STRUCT_IF_C aBFu1s_BFu9s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "aBFu1s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "aBFu1s_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "aBFu1s_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_BFu9s_Sf, aBFu1s_BFu9s_Sf)
//============================================================================



static void Test_aBFu1s_C_Sf()
{
  {
    init_simple_test("aBFu1s_C_Sf");
    static STRUCT_IF_C aBFu1s_C_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_C_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_C_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1s_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_C_Sf, aBFu1s_C_Sf)
//============================================================================



static void Test_aBFu1s_D_Sf()
{
  {
    init_simple_test("aBFu1s_D_Sf");
    static STRUCT_IF_C aBFu1s_D_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1s_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_D_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_D_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1s_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_D_Sf, aBFu1s_D_Sf)
//============================================================================



static void Test_aBFu1s_F_Sf()
{
  {
    init_simple_test("aBFu1s_F_Sf");
    static STRUCT_IF_C aBFu1s_F_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_F_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_F_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1s_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_F_Sf, aBFu1s_F_Sf)
//============================================================================



static void Test_aBFu1s_I_Sf()
{
  {
    init_simple_test("aBFu1s_I_Sf");
    static STRUCT_IF_C aBFu1s_I_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_I_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_I_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1s_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_I_Sf, aBFu1s_I_Sf)
//============================================================================



static void Test_aBFu1s_Ip_Sf()
{
  {
    init_simple_test("aBFu1s_Ip_Sf");
    static STRUCT_IF_C aBFu1s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1s_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Ip_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1s_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Ip_Sf, aBFu1s_Ip_Sf)
//============================================================================



static void Test_aBFu1s_L_Sf()
{
  {
    init_simple_test("aBFu1s_L_Sf");
    static STRUCT_IF_C aBFu1s_L_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1s_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_L_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_L_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1s_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_L_Sf, aBFu1s_L_Sf)
//============================================================================



static void Test_aBFu1s_S_Sf()
{
  {
    init_simple_test("aBFu1s_S_Sf");
    static STRUCT_IF_C aBFu1s_S_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_S_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_S_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1s_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_S_Sf, aBFu1s_S_Sf)
//============================================================================



static void Test_aBFu1s_Sf()
{
  {
    init_simple_test("aBFu1s_Sf");
    static STRUCT_IF_C aBFu1s_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf, aBFu1s_Sf)
//============================================================================



static void Test_aBFu1s_Sf_BFu15i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu15i");
    static STRUCT_IF_C aBFu1s_Sf_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1s_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu15i, aBFu1s_Sf_BFu15i)
//============================================================================



static void Test_aBFu1s_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu15ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu15ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1s_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu15ll, aBFu1s_Sf_BFu15ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu15s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu15s");
    static STRUCT_IF_C aBFu1s_Sf_BFu15s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 1, 0, 15, 1, "aBFu1s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 1, 0, 15, hide_ull(1LL<<14), "aBFu1s_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu15s, aBFu1s_Sf_BFu15s)
//============================================================================



static void Test_aBFu1s_Sf_BFu16i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu16i");
    static STRUCT_IF_C aBFu1s_Sf_BFu16i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1s_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu16i, aBFu1s_Sf_BFu16i)
//============================================================================



static void Test_aBFu1s_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu16ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu16ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1s_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu16ll, aBFu1s_Sf_BFu16ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu16s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu16s");
    static STRUCT_IF_C aBFu1s_Sf_BFu16s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 1, 0, 16, 1, "aBFu1s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 1, 0, 16, hide_ull(1LL<<15), "aBFu1s_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu16s, aBFu1s_Sf_BFu16s)
//============================================================================



static void Test_aBFu1s_Sf_BFu17i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu17i");
    static STRUCT_IF_C aBFu1s_Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1s_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1s_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu17i, aBFu1s_Sf_BFu17i)
//============================================================================



static void Test_aBFu1s_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu17ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu1s_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 17, 1, "aBFu1s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 1, 0, 17, hide_ull(1LL<<16), "aBFu1s_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu17ll, aBFu1s_Sf_BFu17ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu1c()
{
  {
    init_simple_test("aBFu1s_Sf_BFu1c");
    static STRUCT_IF_C aBFu1s_Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1s_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu1c, aBFu1s_Sf_BFu1c)
//============================================================================



static void Test_aBFu1s_Sf_BFu1i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu1i");
    static STRUCT_IF_C aBFu1s_Sf_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1s_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu1i, aBFu1s_Sf_BFu1i)
//============================================================================



static void Test_aBFu1s_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu1ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1s_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu1ll, aBFu1s_Sf_BFu1ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu1s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu1s");
    static STRUCT_IF_C aBFu1s_Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 1, 0, 1, 1, "aBFu1s_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu1s, aBFu1s_Sf_BFu1s)
//============================================================================



static void Test_aBFu1s_Sf_BFu31i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu31i");
    static STRUCT_IF_C aBFu1s_Sf_BFu31i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1s_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu31i, aBFu1s_Sf_BFu31i)
//============================================================================



static void Test_aBFu1s_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu31ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu31ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 31, 1, "aBFu1s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 1, 0, 31, hide_ull(1LL<<30), "aBFu1s_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu31ll, aBFu1s_Sf_BFu31ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu32i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu32i");
    static STRUCT_IF_C aBFu1s_Sf_BFu32i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1s_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu32i, aBFu1s_Sf_BFu32i)
//============================================================================



static void Test_aBFu1s_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu32ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu32ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 32, 1, "aBFu1s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 1, 0, 32, hide_ull(1LL<<31), "aBFu1s_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu32ll, aBFu1s_Sf_BFu32ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu33()
{
  {
    init_simple_test("aBFu1s_Sf_BFu33");
    static STRUCT_IF_C aBFu1s_Sf_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aBFu1s_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu33");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 1, 0, 33, 1, "aBFu1s_Sf_BFu33");
    set_bf_and_test(lv, v3, 1, 0, 33, hide_ull(1LL<<32), "aBFu1s_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu33, aBFu1s_Sf_BFu33)
//============================================================================



static void Test_aBFu1s_Sf_BFu7c()
{
  {
    init_simple_test("aBFu1s_Sf_BFu7c");
    static STRUCT_IF_C aBFu1s_Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1s_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu7c, aBFu1s_Sf_BFu7c)
//============================================================================



static void Test_aBFu1s_Sf_BFu7i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu7i");
    static STRUCT_IF_C aBFu1s_Sf_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1s_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu7i, aBFu1s_Sf_BFu7i)
//============================================================================



static void Test_aBFu1s_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu7ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1s_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu7ll, aBFu1s_Sf_BFu7ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu7s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu7s");
    static STRUCT_IF_C aBFu1s_Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 1, 0, 7, 1, "aBFu1s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 1, 0, 7, hide_ull(1LL<<6), "aBFu1s_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu7s, aBFu1s_Sf_BFu7s)
//============================================================================



static void Test_aBFu1s_Sf_BFu8c()
{
  {
    init_simple_test("aBFu1s_Sf_BFu8c");
    static STRUCT_IF_C aBFu1s_Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1s_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu8c, aBFu1s_Sf_BFu8c)
//============================================================================



static void Test_aBFu1s_Sf_BFu8i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu8i");
    static STRUCT_IF_C aBFu1s_Sf_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1s_Sf_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu8i, aBFu1s_Sf_BFu8i)
//============================================================================



static void Test_aBFu1s_Sf_BFu8ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu8ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1s_Sf_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu8ll, aBFu1s_Sf_BFu8ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu8s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu8s");
    static STRUCT_IF_C aBFu1s_Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 1, 0, 8, 1, "aBFu1s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 1, 0, 8, hide_ull(1LL<<7), "aBFu1s_Sf_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu8s, aBFu1s_Sf_BFu8s)
//============================================================================



static void Test_aBFu1s_Sf_BFu9i()
{
  {
    init_simple_test("aBFu1s_Sf_BFu9i");
    static STRUCT_IF_C aBFu1s_Sf_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1s_Sf_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu9i, aBFu1s_Sf_BFu9i)
//============================================================================



static void Test_aBFu1s_Sf_BFu9ll()
{
  {
    init_simple_test("aBFu1s_Sf_BFu9ll");
    static STRUCT_IF_C aBFu1s_Sf_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1s_Sf_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu9ll, aBFu1s_Sf_BFu9ll)
//============================================================================



static void Test_aBFu1s_Sf_BFu9s()
{
  {
    init_simple_test("aBFu1s_Sf_BFu9s");
    static STRUCT_IF_C aBFu1s_Sf_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 1, 0, 9, 1, "aBFu1s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 1, 0, 9, hide_ull(1LL<<8), "aBFu1s_Sf_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_BFu9s, aBFu1s_Sf_BFu9s)
//============================================================================



static void Test_aBFu1s_Sf_C()
{
  {
    init_simple_test("aBFu1s_Sf_C");
    static STRUCT_IF_C aBFu1s_Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_C");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_C.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_C, aBFu1s_Sf_C)
//============================================================================



static void Test_aBFu1s_Sf_D()
{
  {
    init_simple_test("aBFu1s_Sf_D");
    static STRUCT_IF_C aBFu1s_Sf_D lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1s_Sf_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_D");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_D.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_D, aBFu1s_Sf_D)
//============================================================================



static void Test_aBFu1s_Sf_F()
{
  {
    init_simple_test("aBFu1s_Sf_F");
    static STRUCT_IF_C aBFu1s_Sf_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_F");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_F.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_F, aBFu1s_Sf_F)
//============================================================================



static void Test_aBFu1s_Sf_I()
{
  {
    init_simple_test("aBFu1s_Sf_I");
    static STRUCT_IF_C aBFu1s_Sf_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_I");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_I.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_I, aBFu1s_Sf_I)
//============================================================================



static void Test_aBFu1s_Sf_Ip()
{
  {
    init_simple_test("aBFu1s_Sf_Ip");
    static STRUCT_IF_C aBFu1s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1s_Sf_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Ip");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Ip.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Ip, aBFu1s_Sf_Ip)
//============================================================================



static void Test_aBFu1s_Sf_L()
{
  {
    init_simple_test("aBFu1s_Sf_L");
    static STRUCT_IF_C aBFu1s_Sf_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1s_Sf_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_L");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_L.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_L, aBFu1s_Sf_L)
//============================================================================



static void Test_aBFu1s_Sf_S()
{
  {
    init_simple_test("aBFu1s_Sf_S");
    static STRUCT_IF_C aBFu1s_Sf_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_S");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_S.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_S, aBFu1s_Sf_S)
//============================================================================



static void Test_aBFu1s_Sf_Sf()
{
  {
    init_simple_test("aBFu1s_Sf_Sf");
    static STRUCT_IF_C aBFu1s_Sf_Sf lv;
    check2(sizeof(lv), 1, "sizeof(aBFu1s_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Sf.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Sf, aBFu1s_Sf_Sf)
//============================================================================



static void Test_aBFu1s_Sf_Uc()
{
  {
    init_simple_test("aBFu1s_Sf_Uc");
    static STRUCT_IF_C aBFu1s_Sf_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Uc");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Uc.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Uc, aBFu1s_Sf_Uc)
//============================================================================



static void Test_aBFu1s_Sf_Ui()
{
  {
    init_simple_test("aBFu1s_Sf_Ui");
    static STRUCT_IF_C aBFu1s_Sf_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Sf_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Ui");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Ui.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Ui, aBFu1s_Sf_Ui)
//============================================================================



static void Test_aBFu1s_Sf_Ul()
{
  {
    init_simple_test("aBFu1s_Sf_Ul");
    static STRUCT_IF_C aBFu1s_Sf_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1s_Sf_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Ul");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Ul.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Ul, aBFu1s_Sf_Ul)
//============================================================================



static void Test_aBFu1s_Sf_Us()
{
  {
    init_simple_test("aBFu1s_Sf_Us");
    static STRUCT_IF_C aBFu1s_Sf_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Sf_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Us");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Us.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Us, aBFu1s_Sf_Us)
//============================================================================



static void Test_aBFu1s_Sf_Vp()
{
  {
    init_simple_test("aBFu1s_Sf_Vp");
    static STRUCT_IF_C aBFu1s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1s_Sf_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Sf_Vp");
    check_field_offset(lv, v2, 1, "aBFu1s_Sf_Vp.v2");
    check_field_offset(lv, v3, 1, "aBFu1s_Sf_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Sf_Vp, aBFu1s_Sf_Vp)
//============================================================================



static void Test_aBFu1s_Uc_Sf()
{
  {
    init_simple_test("aBFu1s_Uc_Sf");
    static STRUCT_IF_C aBFu1s_Uc_Sf lv;
    check2(sizeof(lv), 2, "sizeof(aBFu1s_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Uc_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "aBFu1s_Uc_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Uc_Sf, aBFu1s_Uc_Sf)
//============================================================================



static void Test_aBFu1s_Ui_Sf()
{
  {
    init_simple_test("aBFu1s_Ui_Sf");
    static STRUCT_IF_C aBFu1s_Ui_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu1s_Ui_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Ui_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Ui_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu1s_Ui_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Ui_Sf, aBFu1s_Ui_Sf)
//============================================================================



static void Test_aBFu1s_Ul_Sf()
{
  {
    init_simple_test("aBFu1s_Ul_Sf");
    static STRUCT_IF_C aBFu1s_Ul_Sf lv;
    check2(sizeof(lv), 9, "sizeof(aBFu1s_Ul_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Ul_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Ul_Sf.v2");
    check_field_offset(lv, v3, 9, "aBFu1s_Ul_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Ul_Sf, aBFu1s_Ul_Sf)
//============================================================================



static void Test_aBFu1s_Us_Sf()
{
  {
    init_simple_test("aBFu1s_Us_Sf");
    static STRUCT_IF_C aBFu1s_Us_Sf lv;
    check2(sizeof(lv), 3, "sizeof(aBFu1s_Us_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Us_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Us_Sf.v2");
    check_field_offset(lv, v3, 3, "aBFu1s_Us_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Us_Sf, aBFu1s_Us_Sf)
//============================================================================



static void Test_aBFu1s_Vp_Sf()
{
  {
    init_simple_test("aBFu1s_Vp_Sf");
    static STRUCT_IF_C aBFu1s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu1s_Vp_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu1s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "aBFu1s_Vp_Sf");
    check_field_offset(lv, v2, 1, "aBFu1s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu1s_Vp_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu1s_Vp_Sf, aBFu1s_Vp_Sf)
//============================================================================



static void Test_aBFu31i_BFu15i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu15i_Sf");
    static STRUCT_IF_C aBFu31i_BFu15i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu15i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "aBFu31i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "aBFu31i_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu15i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu15i_Sf, aBFu31i_BFu15i_Sf)
//============================================================================



static void Test_aBFu31i_BFu15ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu15ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu15ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu15ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "aBFu31i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "aBFu31i_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu15ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu15ll_Sf, aBFu31i_BFu15ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu15s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu15s_Sf");
    static STRUCT_IF_C aBFu31i_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu15s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "aBFu31i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "aBFu31i_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu15s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu15s_Sf, aBFu31i_BFu15s_Sf)
//============================================================================



static void Test_aBFu31i_BFu16i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu16i_Sf");
    static STRUCT_IF_C aBFu31i_BFu16i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu16i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "aBFu31i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "aBFu31i_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu16i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu16i_Sf, aBFu31i_BFu16i_Sf)
//============================================================================



static void Test_aBFu31i_BFu16ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu16ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu16ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu16ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "aBFu31i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "aBFu31i_BFu16ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu16ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu16ll_Sf, aBFu31i_BFu16ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu16s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu16s_Sf");
    static STRUCT_IF_C aBFu31i_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu16s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "aBFu31i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "aBFu31i_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu16s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu16s_Sf, aBFu31i_BFu16s_Sf)
//============================================================================



static void Test_aBFu31i_BFu17i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu17i_Sf");
    static STRUCT_IF_C aBFu31i_BFu17i_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu17i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "aBFu31i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "aBFu31i_BFu17i_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu17i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu17i_Sf, aBFu31i_BFu17i_Sf)
//============================================================================



static void Test_aBFu31i_BFu17ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu17ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu17ll_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_BFu17ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "aBFu31i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "aBFu31i_BFu17ll_Sf");
    check_field_offset(lv, v3, 6, "aBFu31i_BFu17ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu17ll_Sf, aBFu31i_BFu17ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu1c_Sf()
{
  {
    init_simple_test("aBFu31i_BFu1c_Sf");
    static STRUCT_IF_C aBFu31i_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "aBFu31i_BFu1c_Sf");
    check_field_offset(lv, v3, 4, "aBFu31i_BFu1c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu1c_Sf, aBFu31i_BFu1c_Sf)
//============================================================================



static void Test_aBFu31i_BFu1i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu1i_Sf");
    static STRUCT_IF_C aBFu31i_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu1i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "aBFu31i_BFu1i_Sf");
    check_field_offset(lv, v3, 4, "aBFu31i_BFu1i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu1i_Sf, aBFu31i_BFu1i_Sf)
//============================================================================



static void Test_aBFu31i_BFu1ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu1ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu1ll_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu1ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "aBFu31i_BFu1ll_Sf");
    check_field_offset(lv, v3, 4, "aBFu31i_BFu1ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu1ll_Sf, aBFu31i_BFu1ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu1s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu1s_Sf");
    static STRUCT_IF_C aBFu31i_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_BFu1s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "aBFu31i_BFu1s_Sf");
    check_field_offset(lv, v3, 4, "aBFu31i_BFu1s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu1s_Sf, aBFu31i_BFu1s_Sf)
//============================================================================



static void Test_aBFu31i_BFu31i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu31i_Sf");
    static STRUCT_IF_C aBFu31i_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_BFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "aBFu31i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "aBFu31i_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "aBFu31i_BFu31i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu31i_Sf, aBFu31i_BFu31i_Sf)
//============================================================================



static void Test_aBFu31i_BFu31ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu31ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_BFu31ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "aBFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "aBFu31i_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "aBFu31i_BFu31ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu31ll_Sf, aBFu31i_BFu31ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu32i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu32i_Sf");
    static STRUCT_IF_C aBFu31i_BFu32i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_BFu32i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "aBFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "aBFu31i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "aBFu31i_BFu32i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu32i_Sf, aBFu31i_BFu32i_Sf)
//============================================================================



static void Test_aBFu31i_BFu32ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu32ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_BFu32ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "aBFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "aBFu31i_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "aBFu31i_BFu32ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu32ll_Sf, aBFu31i_BFu32ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu33_Sf()
{
  {
    init_simple_test("aBFu31i_BFu33_Sf");
    static STRUCT_IF_C aBFu31i_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_BFu33_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "aBFu31i_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "aBFu31i_BFu33_Sf");
    check_field_offset(lv, v3, 8, "aBFu31i_BFu33_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu33_Sf, aBFu31i_BFu33_Sf)
//============================================================================



static void Test_aBFu31i_BFu7c_Sf()
{
  {
    init_simple_test("aBFu31i_BFu7c_Sf");
    static STRUCT_IF_C aBFu31i_BFu7c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "aBFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "aBFu31i_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu7c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu7c_Sf, aBFu31i_BFu7c_Sf)
//============================================================================



static void Test_aBFu31i_BFu7i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu7i_Sf");
    static STRUCT_IF_C aBFu31i_BFu7i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu7i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "aBFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "aBFu31i_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu7i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu7i_Sf, aBFu31i_BFu7i_Sf)
//============================================================================



static void Test_aBFu31i_BFu7ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu7ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu7ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu7ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "aBFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "aBFu31i_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu7ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu7ll_Sf, aBFu31i_BFu7ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu7s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu7s_Sf");
    static STRUCT_IF_C aBFu31i_BFu7s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu7s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "aBFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "aBFu31i_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu7s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu7s_Sf, aBFu31i_BFu7s_Sf)
//============================================================================



static void Test_aBFu31i_BFu8c_Sf()
{
  {
    init_simple_test("aBFu31i_BFu8c_Sf");
    static STRUCT_IF_C aBFu31i_BFu8c_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "aBFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "aBFu31i_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu8c_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu8c_Sf, aBFu31i_BFu8c_Sf)
//============================================================================



static void Test_aBFu31i_BFu8i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu8i_Sf");
    static STRUCT_IF_C aBFu31i_BFu8i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu8i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "aBFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "aBFu31i_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu8i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu8i_Sf, aBFu31i_BFu8i_Sf)
//============================================================================



static void Test_aBFu31i_BFu8ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu8ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu8ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu8ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "aBFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "aBFu31i_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu8ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu8ll_Sf, aBFu31i_BFu8ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu8s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu8s_Sf");
    static STRUCT_IF_C aBFu31i_BFu8s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu8s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "aBFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "aBFu31i_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu8s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu8s_Sf, aBFu31i_BFu8s_Sf)
//============================================================================



static void Test_aBFu31i_BFu9i_Sf()
{
  {
    init_simple_test("aBFu31i_BFu9i_Sf");
    static STRUCT_IF_C aBFu31i_BFu9i_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu9i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "aBFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "aBFu31i_BFu9i_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu9i_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu9i_Sf, aBFu31i_BFu9i_Sf)
//============================================================================



static void Test_aBFu31i_BFu9ll_Sf()
{
  {
    init_simple_test("aBFu31i_BFu9ll_Sf");
    static STRUCT_IF_C aBFu31i_BFu9ll_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu9ll_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "aBFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "aBFu31i_BFu9ll_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu9ll_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu9ll_Sf, aBFu31i_BFu9ll_Sf)
//============================================================================



static void Test_aBFu31i_BFu9s_Sf()
{
  {
    init_simple_test("aBFu31i_BFu9s_Sf");
    static STRUCT_IF_C aBFu31i_BFu9s_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_BFu9s_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "aBFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "aBFu31i_BFu9s_Sf");
    check_field_offset(lv, v3, 5, "aBFu31i_BFu9s_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_BFu9s_Sf, aBFu31i_BFu9s_Sf)
//============================================================================



static void Test_aBFu31i_C_Sf()
{
  {
    init_simple_test("aBFu31i_C_Sf");
    static STRUCT_IF_C aBFu31i_C_Sf lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_C_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_C_Sf.v2");
    check_field_offset(lv, v3, 5, "aBFu31i_C_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_C_Sf, aBFu31i_C_Sf)
//============================================================================



static void Test_aBFu31i_D_Sf()
{
  {
    init_simple_test("aBFu31i_D_Sf");
    static STRUCT_IF_C aBFu31i_D_Sf lv;
    check2(sizeof(lv), 12, "sizeof(aBFu31i_D_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_D_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_D_Sf.v2");
    check_field_offset(lv, v3, 12, "aBFu31i_D_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_D_Sf, aBFu31i_D_Sf)
//============================================================================



static void Test_aBFu31i_F_Sf()
{
  {
    init_simple_test("aBFu31i_F_Sf");
    static STRUCT_IF_C aBFu31i_F_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_F_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_F_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "aBFu31i_F_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_F_Sf, aBFu31i_F_Sf)
//============================================================================



static void Test_aBFu31i_I_Sf()
{
  {
    init_simple_test("aBFu31i_I_Sf");
    static STRUCT_IF_C aBFu31i_I_Sf lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_I_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_I_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "aBFu31i_I_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_I_Sf, aBFu31i_I_Sf)
//============================================================================



static void Test_aBFu31i_Ip_Sf()
{
  {
    init_simple_test("aBFu31i_Ip_Sf");
    static STRUCT_IF_C aBFu31i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu31i_Ip_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Ip_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aBFu31i_Ip_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Ip_Sf, aBFu31i_Ip_Sf)
//============================================================================



static void Test_aBFu31i_L_Sf()
{
  {
    init_simple_test("aBFu31i_L_Sf");
    static STRUCT_IF_C aBFu31i_L_Sf lv;
    check2(sizeof(lv), 12, "sizeof(aBFu31i_L_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_L_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_L_Sf.v2");
    check_field_offset(lv, v3, 12, "aBFu31i_L_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_L_Sf, aBFu31i_L_Sf)
//============================================================================



static void Test_aBFu31i_S_Sf()
{
  {
    init_simple_test("aBFu31i_S_Sf");
    static STRUCT_IF_C aBFu31i_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_S_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_S_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_S_Sf.v2");
    check_field_offset(lv, v3, 6, "aBFu31i_S_Sf.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_S_Sf, aBFu31i_S_Sf)
//============================================================================



static void Test_aBFu31i_Sf()
{
  {
    init_simple_test("aBFu31i_Sf");
    static STRUCT_IF_C aBFu31i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(aBFu31i_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf, aBFu31i_Sf)
//============================================================================



static void Test_aBFu31i_Sf_BFu15i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu15i");
    static STRUCT_IF_C aBFu31i_Sf_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_Sf_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aBFu31i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aBFu31i_Sf_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu15i, aBFu31i_Sf_BFu15i)
//============================================================================



static void Test_aBFu31i_Sf_BFu15ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu15ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_Sf_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aBFu31i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aBFu31i_Sf_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu15ll, aBFu31i_Sf_BFu15ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu15s()
{
  {
    init_simple_test("aBFu31i_Sf_BFu15s");
    static STRUCT_IF_C aBFu31i_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_Sf_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aBFu31i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aBFu31i_Sf_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu15s, aBFu31i_Sf_BFu15s)
//============================================================================



static void Test_aBFu31i_Sf_BFu16i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu16i");
    static STRUCT_IF_C aBFu31i_Sf_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_Sf_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aBFu31i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aBFu31i_Sf_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu16i, aBFu31i_Sf_BFu16i)
//============================================================================



static void Test_aBFu31i_Sf_BFu16ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu16ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_Sf_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aBFu31i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aBFu31i_Sf_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu16ll, aBFu31i_Sf_BFu16ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu16s()
{
  {
    init_simple_test("aBFu31i_Sf_BFu16s");
    static STRUCT_IF_C aBFu31i_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu31i_Sf_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aBFu31i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aBFu31i_Sf_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu16s, aBFu31i_Sf_BFu16s)
//============================================================================



static void Test_aBFu31i_Sf_BFu17i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu17i");
    static STRUCT_IF_C aBFu31i_Sf_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu31i_Sf_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aBFu31i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aBFu31i_Sf_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu17i, aBFu31i_Sf_BFu17i)
//============================================================================



static void Test_aBFu31i_Sf_BFu17ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu17ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu31i_Sf_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aBFu31i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aBFu31i_Sf_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu17ll, aBFu31i_Sf_BFu17ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu1c()
{
  {
    init_simple_test("aBFu31i_Sf_BFu1c");
    static STRUCT_IF_C aBFu31i_Sf_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aBFu31i_Sf_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu1c, aBFu31i_Sf_BFu1c)
//============================================================================



static void Test_aBFu31i_Sf_BFu1i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu1i");
    static STRUCT_IF_C aBFu31i_Sf_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aBFu31i_Sf_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu1i, aBFu31i_Sf_BFu1i)
//============================================================================



static void Test_aBFu31i_Sf_BFu1ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu1ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aBFu31i_Sf_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu1ll, aBFu31i_Sf_BFu1ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu1s()
{
  {
    init_simple_test("aBFu31i_Sf_BFu1s");
    static STRUCT_IF_C aBFu31i_Sf_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aBFu31i_Sf_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu1s, aBFu31i_Sf_BFu1s)
//============================================================================



static void Test_aBFu31i_Sf_BFu31i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu31i");
    static STRUCT_IF_C aBFu31i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_Sf_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aBFu31i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu31i, aBFu31i_Sf_BFu31i)
//============================================================================



static void Test_aBFu31i_Sf_BFu31ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu31ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_Sf_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aBFu31i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu31ll, aBFu31i_Sf_BFu31ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu32i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu32i");
    static STRUCT_IF_C aBFu31i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_Sf_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aBFu31i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aBFu31i_Sf_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu32i, aBFu31i_Sf_BFu32i)
//============================================================================



static void Test_aBFu31i_Sf_BFu32ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu32ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu31i_Sf_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aBFu31i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aBFu31i_Sf_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu32ll, aBFu31i_Sf_BFu32ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu33()
{
  {
    init_simple_test("aBFu31i_Sf_BFu33");
    static STRUCT_IF_C aBFu31i_Sf_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aBFu31i_Sf_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu33");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aBFu31i_Sf_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aBFu31i_Sf_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu33, aBFu31i_Sf_BFu33)
//============================================================================



static void Test_aBFu31i_Sf_BFu7c()
{
  {
    init_simple_test("aBFu31i_Sf_BFu7c");
    static STRUCT_IF_C aBFu31i_Sf_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aBFu31i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aBFu31i_Sf_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu7c, aBFu31i_Sf_BFu7c)
//============================================================================



static void Test_aBFu31i_Sf_BFu7i()
{
  {
    init_simple_test("aBFu31i_Sf_BFu7i");
    static STRUCT_IF_C aBFu31i_Sf_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aBFu31i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aBFu31i_Sf_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu7i, aBFu31i_Sf_BFu7i)
//============================================================================



static void Test_aBFu31i_Sf_BFu7ll()
{
  {
    init_simple_test("aBFu31i_Sf_BFu7ll");
    static STRUCT_IF_C aBFu31i_Sf_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu7ll");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aBFu31i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aBFu31i_Sf_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu7ll, aBFu31i_Sf_BFu7ll)
//============================================================================



static void Test_aBFu31i_Sf_BFu7s()
{
  {
    init_simple_test("aBFu31i_Sf_BFu7s");
    static STRUCT_IF_C aBFu31i_Sf_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu7s");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aBFu31i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aBFu31i_Sf_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu7s, aBFu31i_Sf_BFu7s)
//============================================================================



static void Test_aBFu31i_Sf_BFu8c()
{
  {
    init_simple_test("aBFu31i_Sf_BFu8c");
    static STRUCT_IF_C aBFu31i_Sf_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu31i_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu31i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "aBFu31i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "aBFu31i_Sf_BFu8c");
    check_field_offset(lv, v2, 4, "aBFu31i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aBFu31i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aBFu31i_Sf_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu31i_Sf_BFu8c, aBFu31i_Sf_BFu8c)
//============================================================================



static void Test_aBFu31i_Sf_BFu8i()
{
  {
    init_simple_test("aBFu