// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  STT010  {
  char fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT010) C1{ Fc Fc:0 Fc}



static void Test_STT010()
{
  {
    init_simple_test("STT010");
    static STRUCT_IF_C STT010 lv;
    check2(sizeof(lv), 2, "sizeof(STT010)");
    check2(__alignof__(lv), 1, "__alignof__(STT010)");
    check_field_offset(lv, fa, 0, "STT010.fa");
    check_field_offset(lv, fb, 1, "STT010.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT010, STT010)
//============================================================================


struct  STT020  {
  char fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT020) C1{ Fc Fs:0 Fc}



static void Test_STT020()
{
  {
    init_simple_test("STT020");
    static STRUCT_IF_C STT020 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT020)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT020)");
    check_field_offset(lv, fa, 0, "STT020.fa");
    check_field_offset(lv, fb, 2, "STT020.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT020, STT020)
//============================================================================


struct  STT030  {
  char fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT030) C1{ Fc Fi:0 Fc}



static void Test_STT030()
{
  {
    init_simple_test("STT030");
    static STRUCT_IF_C STT030 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(STT030)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT030)");
    check_field_offset(lv, fa, 0, "STT030.fa");
    check_field_offset(lv, fb, 4, "STT030.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT030, STT030)
//============================================================================


struct  STT040  {
  char fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT040) C1{ Fc FL:0 Fc}



static void Test_STT040()
{
  {
    init_simple_test("STT040");
    static STRUCT_IF_C STT040 lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(STT040)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT040)");
    check_field_offset(lv, fa, 0, "STT040.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT040.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT040, STT040)
//============================================================================


struct  STT050  {
  char fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT050) C1{ Fc Fc:3 Fc}



static void Test_STT050()
{
  {
    init_simple_test("STT050");
    static STRUCT_IF_C STT050 lv;
    check2(sizeof(lv), 3, "sizeof(STT050)");
    check2(__alignof__(lv), 1, "__alignof__(STT050)");
    check_field_offset(lv, fa, 0, "STT050.fa");
    check_field_offset(lv, fb, 2, "STT050.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT050, STT050)
//============================================================================


struct  STT060  {
  char fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT060) C1{ Fc Fs:3 Fc}



static void Test_STT060()
{
  {
    init_simple_test("STT060");
    static STRUCT_IF_C STT060 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT060)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT060)");
    check_field_offset(lv, fa, 0, "STT060.fa");
    check_field_offset(lv, fb, 2, "STT060.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT060, STT060)
//============================================================================


struct  STT070  {
  char fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT070) C1{ Fc Fi:3 Fc}



static void Test_STT070()
{
  {
    init_simple_test("STT070");
    static STRUCT_IF_C STT070 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT070)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT070)");
    check_field_offset(lv, fa, 0, "STT070.fa");
    check_field_offset(lv, fb, 2, "STT070.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT070, STT070)
//============================================================================


struct  STT080  {
  char fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT080) C1{ Fc FL:3 Fc}



static void Test_STT080()
{
  {
    init_simple_test("STT080");
    static STRUCT_IF_C STT080 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT080)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT080)");
    check_field_offset(lv, fa, 0, "STT080.fa");
    check_field_offset(lv, fb, 2, "STT080.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT080, STT080)
//============================================================================


struct  STT090  {
  char fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT090) C1{ Fc Fs:8 Fc}



static void Test_STT090()
{
  {
    init_simple_test("STT090");
    static STRUCT_IF_C STT090 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT090)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT090)");
    check_field_offset(lv, fa, 0, "STT090.fa");
    check_field_offset(lv, fb, 2, "STT090.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT090, STT090)
//============================================================================


struct  STT0100  {
  char fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT0100) C1{ Fc Fi:8 Fc}



static void Test_STT0100()
{
  {
    init_simple_test("STT0100");
    static STRUCT_IF_C STT0100 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT0100)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0100)");
    check_field_offset(lv, fa, 0, "STT0100.fa");
    check_field_offset(lv, fb, 2, "STT0100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0100, STT0100)
//============================================================================


struct  STT0110  {
  char fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT0110) C1{ Fc FL:8 Fc}



static void Test_STT0110()
{
  {
    init_simple_test("STT0110");
    static STRUCT_IF_C STT0110 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT0110)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0110)");
    check_field_offset(lv, fa, 0, "STT0110.fa");
    check_field_offset(lv, fb, 2, "STT0110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0110, STT0110)
//============================================================================


struct  STT0120  {
  char fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT0120) C1{ Fc Fi:18 Fc}



static void Test_STT0120()
{
  {
    init_simple_test("STT0120");
    static STRUCT_IF_C STT0120 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(STT0120)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0120)");
    check_field_offset(lv, fa, 0, "STT0120.fa");
    check_field_offset(lv, fb, 4, "STT0120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0120, STT0120)
//============================================================================


struct  STT0130  {
  char fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT0130) C1{ Fc FL:18 Fc}



static void Test_STT0130()
{
  {
    init_simple_test("STT0130");
    static STRUCT_IF_C STT0130 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(STT0130)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0130)");
    check_field_offset(lv, fa, 0, "STT0130.fa");
    check_field_offset(lv, fb, 4, "STT0130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0130, STT0130)
//============================================================================


struct  STT0140  {
  char fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT0140) C1{ Fc FL:48 Fc}



static void Test_STT0140()
{
  {
    init_simple_test("STT0140");
    static STRUCT_IF_C STT0140 lv;
    check2(sizeof(lv), 8, "sizeof(STT0140)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0140)");
    check_field_offset(lv, fa, 0, "STT0140.fa");
    check_field_offset(lv, fb, 7, "STT0140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0140, STT0140)
//============================================================================


struct  STT0150  {
  char fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT0150) C1{ Fc Fc:3 Fc}



static void Test_STT0150()
{
  {
    init_simple_test("STT0150");
    static STRUCT_IF_C STT0150 lv;
    check2(sizeof(lv), 3, "sizeof(STT0150)");
    check2(__alignof__(lv), 1, "__alignof__(STT0150)");
    check_field_offset(lv, fa, 0, "STT0150.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0150");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0150");
    check_field_offset(lv, fb, 2, "STT0150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0150, STT0150)
//============================================================================


struct  STT0160  {
  char fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT0160) C1{ Fc Fs:3 Fc}



static void Test_STT0160()
{
  {
    init_simple_test("STT0160");
    static STRUCT_IF_C STT0160 lv;
    check2(sizeof(lv), 4, "sizeof(STT0160)");
    check2(__alignof__(lv), 2, "__alignof__(STT0160)");
    check_field_offset(lv, fa, 0, "STT0160.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0160");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0160");
    check_field_offset(lv, fb, 2, "STT0160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0160, STT0160)
//============================================================================


struct  STT0170  {
  char fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT0170) C1{ Fc Fi:3 Fc}



static void Test_STT0170()
{
  {
    init_simple_test("STT0170");
    static STRUCT_IF_C STT0170 lv;
    check2(sizeof(lv), 4, "sizeof(STT0170)");
    check2(__alignof__(lv), 4, "__alignof__(STT0170)");
    check_field_offset(lv, fa, 0, "STT0170.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0170");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0170");
    check_field_offset(lv, fb, 2, "STT0170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0170, STT0170)
//============================================================================


struct  STT0180  {
  char fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT0180) C1{ Fc FL:3 Fc}



static void Test_STT0180()
{
  {
    init_simple_test("STT0180");
    static STRUCT_IF_C STT0180 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0180)");
    check_field_offset(lv, fa, 0, "STT0180.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0180");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0180");
    check_field_offset(lv, fb, 2, "STT0180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0180, STT0180)
//============================================================================


struct  STT0190  {
  char fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT0190) C1{ Fc Fs:8 Fc}



static void Test_STT0190()
{
  {
    init_simple_test("STT0190");
    static STRUCT_IF_C STT0190 lv;
    check2(sizeof(lv), 4, "sizeof(STT0190)");
    check2(__alignof__(lv), 2, "__alignof__(STT0190)");
    check_field_offset(lv, fa, 0, "STT0190.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0190");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0190");
    check_field_offset(lv, fb, 2, "STT0190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0190, STT0190)
//============================================================================


struct  STT0200  {
  char fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT0200) C1{ Fc Fi:8 Fc}



static void Test_STT0200()
{
  {
    init_simple_test("STT0200");
    static STRUCT_IF_C STT0200 lv;
    check2(sizeof(lv), 4, "sizeof(STT0200)");
    check2(__alignof__(lv), 4, "__alignof__(STT0200)");
    check_field_offset(lv, fa, 0, "STT0200.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0200");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0200");
    check_field_offset(lv, fb, 2, "STT0200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0200, STT0200)
//============================================================================


struct  STT0210  {
  char fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT0210) C1{ Fc FL:8 Fc}



static void Test_STT0210()
{
  {
    init_simple_test("STT0210");
    static STRUCT_IF_C STT0210 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0210)");
    check_field_offset(lv, fa, 0, "STT0210.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0210");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0210");
    check_field_offset(lv, fb, 2, "STT0210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0210, STT0210)
//============================================================================


struct  STT0220  {
  char fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT0220) C1{ Fc Fi:18 Fc}



static void Test_STT0220()
{
  {
    init_simple_test("STT0220");
    static STRUCT_IF_C STT0220 lv;
    check2(sizeof(lv), 8, "sizeof(STT0220)");
    check2(__alignof__(lv), 4, "__alignof__(STT0220)");
    check_field_offset(lv, fa, 0, "STT0220.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0220");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0220");
    check_field_offset(lv, fb, 4, "STT0220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0220, STT0220)
//============================================================================


struct  STT0230  {
  char fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT0230) C1{ Fc FL:18 Fc}



static void Test_STT0230()
{
  {
    init_simple_test("STT0230");
    static STRUCT_IF_C STT0230 lv;
    check2(sizeof(lv), 8, "sizeof(STT0230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0230)");
    check_field_offset(lv, fa, 0, "STT0230.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0230");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0230");
    check_field_offset(lv, fb, 4, "STT0230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0230, STT0230)
//============================================================================


struct  STT0240  {
  char fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT0240) C1{ Fc FL:48 Fc}



static void Test_STT0240()
{
  {
    init_simple_test("STT0240");
    static STRUCT_IF_C STT0240 lv;
    check2(sizeof(lv), 8, "sizeof(STT0240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0240)");
    check_field_offset(lv, fa, 0, "STT0240.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0240");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0240");
    check_field_offset(lv, fb, 7, "STT0240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0240, STT0240)
//============================================================================


struct  STT011  {
  char fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT011) C1{ Fc Fc:0 Fs}



static void Test_STT011()
{
  {
    init_simple_test("STT011");
    static STRUCT_IF_C STT011 lv;
    check2(sizeof(lv), 4, "sizeof(STT011)");
    check2(__alignof__(lv), 2, "__alignof__(STT011)");
    check_field_offset(lv, fa, 0, "STT011.fa");
    check_field_offset(lv, fb, 2, "STT011.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT011, STT011)
//============================================================================


struct  STT021  {
  char fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT021) C1{ Fc Fs:0 Fs}



static void Test_STT021()
{
  {
    init_simple_test("STT021");
    static STRUCT_IF_C STT021 lv;
    check2(sizeof(lv), 4, "sizeof(STT021)");
    check2(__alignof__(lv), 2, "__alignof__(STT021)");
    check_field_offset(lv, fa, 0, "STT021.fa");
    check_field_offset(lv, fb, 2, "STT021.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT021, STT021)
//============================================================================


struct  STT031  {
  char fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT031) C1{ Fc Fi:0 Fs}



static void Test_STT031()
{
  {
    init_simple_test("STT031");
    static STRUCT_IF_C STT031 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT031)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT031)");
    check_field_offset(lv, fa, 0, "STT031.fa");
    check_field_offset(lv, fb, 4, "STT031.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT031, STT031)
//============================================================================


struct  STT041  {
  char fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT041) C1{ Fc FL:0 Fs}



static void Test_STT041()
{
  {
    init_simple_test("STT041");
    static STRUCT_IF_C STT041 lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(STT041)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT041)");
    check_field_offset(lv, fa, 0, "STT041.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT041.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT041, STT041)
//============================================================================


struct  STT051  {
  char fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT051) C1{ Fc Fc:3 Fs}



static void Test_STT051()
{
  {
    init_simple_test("STT051");
    static STRUCT_IF_C STT051 lv;
    check2(sizeof(lv), 4, "sizeof(STT051)");
    check2(__alignof__(lv), 2, "__alignof__(STT051)");
    check_field_offset(lv, fa, 0, "STT051.fa");
    check_field_offset(lv, fb, 2, "STT051.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT051, STT051)
//============================================================================


struct  STT061  {
  char fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT061) C1{ Fc Fs:3 Fs}



static void Test_STT061()
{
  {
    init_simple_test("STT061");
    static STRUCT_IF_C STT061 lv;
    check2(sizeof(lv), 4, "sizeof(STT061)");
    check2(__alignof__(lv), 2, "__alignof__(STT061)");
    check_field_offset(lv, fa, 0, "STT061.fa");
    check_field_offset(lv, fb, 2, "STT061.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT061, STT061)
//============================================================================


struct  STT071  {
  char fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT071) C1{ Fc Fi:3 Fs}



static void Test_STT071()
{
  {
    init_simple_test("STT071");
    static STRUCT_IF_C STT071 lv;
    check2(sizeof(lv), 4, "sizeof(STT071)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT071)");
    check_field_offset(lv, fa, 0, "STT071.fa");
    check_field_offset(lv, fb, 2, "STT071.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT071, STT071)
//============================================================================


struct  STT081  {
  char fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT081) C1{ Fc FL:3 Fs}



static void Test_STT081()
{
  {
    init_simple_test("STT081");
    static STRUCT_IF_C STT081 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT081)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT081)");
    check_field_offset(lv, fa, 0, "STT081.fa");
    check_field_offset(lv, fb, 2, "STT081.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT081, STT081)
//============================================================================


struct  STT091  {
  char fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT091) C1{ Fc Fs:8 Fs}



static void Test_STT091()
{
  {
    init_simple_test("STT091");
    static STRUCT_IF_C STT091 lv;
    check2(sizeof(lv), 4, "sizeof(STT091)");
    check2(__alignof__(lv), 2, "__alignof__(STT091)");
    check_field_offset(lv, fa, 0, "STT091.fa");
    check_field_offset(lv, fb, 2, "STT091.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT091, STT091)
//============================================================================


struct  STT0101  {
  char fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT0101) C1{ Fc Fi:8 Fs}



static void Test_STT0101()
{
  {
    init_simple_test("STT0101");
    static STRUCT_IF_C STT0101 lv;
    check2(sizeof(lv), 4, "sizeof(STT0101)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0101)");
    check_field_offset(lv, fa, 0, "STT0101.fa");
    check_field_offset(lv, fb, 2, "STT0101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0101, STT0101)
//============================================================================


struct  STT0111  {
  char fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT0111) C1{ Fc FL:8 Fs}



static void Test_STT0111()
{
  {
    init_simple_test("STT0111");
    static STRUCT_IF_C STT0111 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT0111)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0111)");
    check_field_offset(lv, fa, 0, "STT0111.fa");
    check_field_offset(lv, fb, 2, "STT0111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0111, STT0111)
//============================================================================


struct  STT0121  {
  char fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT0121) C1{ Fc Fi:18 Fs}



static void Test_STT0121()
{
  {
    init_simple_test("STT0121");
    static STRUCT_IF_C STT0121 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT0121)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0121)");
    check_field_offset(lv, fa, 0, "STT0121.fa");
    check_field_offset(lv, fb, 4, "STT0121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0121, STT0121)
//============================================================================


struct  STT0131  {
  char fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT0131) C1{ Fc FL:18 Fs}



static void Test_STT0131()
{
  {
    init_simple_test("STT0131");
    static STRUCT_IF_C STT0131 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT0131)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0131)");
    check_field_offset(lv, fa, 0, "STT0131.fa");
    check_field_offset(lv, fb, 4, "STT0131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0131, STT0131)
//============================================================================


struct  STT0141  {
  char fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT0141) C1{ Fc FL:48 Fs}



static void Test_STT0141()
{
  {
    init_simple_test("STT0141");
    static STRUCT_IF_C STT0141 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT0141)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0141)");
    check_field_offset(lv, fa, 0, "STT0141.fa");
    check_field_offset(lv, fb, 8, "STT0141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0141, STT0141)
//============================================================================


struct  STT0151  {
  char fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT0151) C1{ Fc Fc:3 Fs}



static void Test_STT0151()
{
  {
    init_simple_test("STT0151");
    static STRUCT_IF_C STT0151 lv;
    check2(sizeof(lv), 4, "sizeof(STT0151)");
    check2(__alignof__(lv), 2, "__alignof__(STT0151)");
    check_field_offset(lv, fa, 0, "STT0151.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0151");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0151");
    check_field_offset(lv, fb, 2, "STT0151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0151, STT0151)
//============================================================================


struct  STT0161  {
  char fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT0161) C1{ Fc Fs:3 Fs}



static void Test_STT0161()
{
  {
    init_simple_test("STT0161");
    static STRUCT_IF_C STT0161 lv;
    check2(sizeof(lv), 4, "sizeof(STT0161)");
    check2(__alignof__(lv), 2, "__alignof__(STT0161)");
    check_field_offset(lv, fa, 0, "STT0161.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0161");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0161");
    check_field_offset(lv, fb, 2, "STT0161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0161, STT0161)
//============================================================================


struct  STT0171  {
  char fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT0171) C1{ Fc Fi:3 Fs}



static void Test_STT0171()
{
  {
    init_simple_test("STT0171");
    static STRUCT_IF_C STT0171 lv;
    check2(sizeof(lv), 4, "sizeof(STT0171)");
    check2(__alignof__(lv), 4, "__alignof__(STT0171)");
    check_field_offset(lv, fa, 0, "STT0171.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0171");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0171");
    check_field_offset(lv, fb, 2, "STT0171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0171, STT0171)
//============================================================================


struct  STT0181  {
  char fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT0181) C1{ Fc FL:3 Fs}



static void Test_STT0181()
{
  {
    init_simple_test("STT0181");
    static STRUCT_IF_C STT0181 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0181)");
    check_field_offset(lv, fa, 0, "STT0181.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0181");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0181");
    check_field_offset(lv, fb, 2, "STT0181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0181, STT0181)
//============================================================================


struct  STT0191  {
  char fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT0191) C1{ Fc Fs:8 Fs}



static void Test_STT0191()
{
  {
    init_simple_test("STT0191");
    static STRUCT_IF_C STT0191 lv;
    check2(sizeof(lv), 4, "sizeof(STT0191)");
    check2(__alignof__(lv), 2, "__alignof__(STT0191)");
    check_field_offset(lv, fa, 0, "STT0191.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0191");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0191");
    check_field_offset(lv, fb, 2, "STT0191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0191, STT0191)
//============================================================================


struct  STT0201  {
  char fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT0201) C1{ Fc Fi:8 Fs}



static void Test_STT0201()
{
  {
    init_simple_test("STT0201");
    static STRUCT_IF_C STT0201 lv;
    check2(sizeof(lv), 4, "sizeof(STT0201)");
    check2(__alignof__(lv), 4, "__alignof__(STT0201)");
    check_field_offset(lv, fa, 0, "STT0201.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0201");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0201");
    check_field_offset(lv, fb, 2, "STT0201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0201, STT0201)
//============================================================================


struct  STT0211  {
  char fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT0211) C1{ Fc FL:8 Fs}



static void Test_STT0211()
{
  {
    init_simple_test("STT0211");
    static STRUCT_IF_C STT0211 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0211)");
    check_field_offset(lv, fa, 0, "STT0211.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0211");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0211");
    check_field_offset(lv, fb, 2, "STT0211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0211, STT0211)
//============================================================================


struct  STT0221  {
  char fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT0221) C1{ Fc Fi:18 Fs}



static void Test_STT0221()
{
  {
    init_simple_test("STT0221");
    static STRUCT_IF_C STT0221 lv;
    check2(sizeof(lv), 8, "sizeof(STT0221)");
    check2(__alignof__(lv), 4, "__alignof__(STT0221)");
    check_field_offset(lv, fa, 0, "STT0221.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0221");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0221");
    check_field_offset(lv, fb, 4, "STT0221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0221, STT0221)
//============================================================================


struct  STT0231  {
  char fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT0231) C1{ Fc FL:18 Fs}



static void Test_STT0231()
{
  {
    init_simple_test("STT0231");
    static STRUCT_IF_C STT0231 lv;
    check2(sizeof(lv), 8, "sizeof(STT0231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0231)");
    check_field_offset(lv, fa, 0, "STT0231.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0231");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0231");
    check_field_offset(lv, fb, 4, "STT0231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0231, STT0231)
//============================================================================


struct  STT0241  {
  char fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT0241) C1{ Fc FL:48 Fs}



static void Test_STT0241()
{
  {
    init_simple_test("STT0241");
    static STRUCT_IF_C STT0241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0241)");
    check_field_offset(lv, fa, 0, "STT0241.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0241");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0241");
    check_field_offset(lv, fb, 8, "STT0241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0241, STT0241)
//============================================================================


struct  STT012  {
  char fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT012) C1{ Fc Fc:0 Fi}



static void Test_STT012()
{
  {
    init_simple_test("STT012");
    static STRUCT_IF_C STT012 lv;
    check2(sizeof(lv), 8, "sizeof(STT012)");
    check2(__alignof__(lv), 4, "__alignof__(STT012)");
    check_field_offset(lv, fa, 0, "STT012.fa");
    check_field_offset(lv, fb, 4, "STT012.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT012, STT012)
//============================================================================


struct  STT022  {
  char fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT022) C1{ Fc Fs:0 Fi}



static void Test_STT022()
{
  {
    init_simple_test("STT022");
    static STRUCT_IF_C STT022 lv;
    check2(sizeof(lv), 8, "sizeof(STT022)");
    check2(__alignof__(lv), 4, "__alignof__(STT022)");
    check_field_offset(lv, fa, 0, "STT022.fa");
    check_field_offset(lv, fb, 4, "STT022.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT022, STT022)
//============================================================================


struct  STT032  {
  char fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT032) C1{ Fc Fi:0 Fi}



static void Test_STT032()
{
  {
    init_simple_test("STT032");
    static STRUCT_IF_C STT032 lv;
    check2(sizeof(lv), 8, "sizeof(STT032)");
    check2(__alignof__(lv), 4, "__alignof__(STT032)");
    check_field_offset(lv, fa, 0, "STT032.fa");
    check_field_offset(lv, fb, 4, "STT032.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT032, STT032)
//============================================================================


struct  STT042  {
  char fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT042) C1{ Fc FL:0 Fi}



static void Test_STT042()
{
  {
    init_simple_test("STT042");
    static STRUCT_IF_C STT042 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT042)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT042)");
    check_field_offset(lv, fa, 0, "STT042.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT042.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT042, STT042)
//============================================================================


struct  STT052  {
  char fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT052) C1{ Fc Fc:3 Fi}



static void Test_STT052()
{
  {
    init_simple_test("STT052");
    static STRUCT_IF_C STT052 lv;
    check2(sizeof(lv), 8, "sizeof(STT052)");
    check2(__alignof__(lv), 4, "__alignof__(STT052)");
    check_field_offset(lv, fa, 0, "STT052.fa");
    check_field_offset(lv, fb, 4, "STT052.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT052, STT052)
//============================================================================


struct  STT062  {
  char fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT062) C1{ Fc Fs:3 Fi}



static void Test_STT062()
{
  {
    init_simple_test("STT062");
    static STRUCT_IF_C STT062 lv;
    check2(sizeof(lv), 8, "sizeof(STT062)");
    check2(__alignof__(lv), 4, "__alignof__(STT062)");
    check_field_offset(lv, fa, 0, "STT062.fa");
    check_field_offset(lv, fb, 4, "STT062.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT062, STT062)
//============================================================================


struct  STT072  {
  char fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT072) C1{ Fc Fi:3 Fi}



static void Test_STT072()
{
  {
    init_simple_test("STT072");
    static STRUCT_IF_C STT072 lv;
    check2(sizeof(lv), 8, "sizeof(STT072)");
    check2(__alignof__(lv), 4, "__alignof__(STT072)");
    check_field_offset(lv, fa, 0, "STT072.fa");
    check_field_offset(lv, fb, 4, "STT072.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT072, STT072)
//============================================================================


struct  STT082  {
  char fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT082) C1{ Fc FL:3 Fi}



static void Test_STT082()
{
  {
    init_simple_test("STT082");
    static STRUCT_IF_C STT082 lv;
    check2(sizeof(lv), 8, "sizeof(STT082)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT082)");
    check_field_offset(lv, fa, 0, "STT082.fa");
    check_field_offset(lv, fb, 4, "STT082.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT082, STT082)
//============================================================================


struct  STT092  {
  char fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT092) C1{ Fc Fs:8 Fi}



static void Test_STT092()
{
  {
    init_simple_test("STT092");
    static STRUCT_IF_C STT092 lv;
    check2(sizeof(lv), 8, "sizeof(STT092)");
    check2(__alignof__(lv), 4, "__alignof__(STT092)");
    check_field_offset(lv, fa, 0, "STT092.fa");
    check_field_offset(lv, fb, 4, "STT092.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT092, STT092)
//============================================================================


struct  STT0102  {
  char fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT0102) C1{ Fc Fi:8 Fi}



static void Test_STT0102()
{
  {
    init_simple_test("STT0102");
    static STRUCT_IF_C STT0102 lv;
    check2(sizeof(lv), 8, "sizeof(STT0102)");
    check2(__alignof__(lv), 4, "__alignof__(STT0102)");
    check_field_offset(lv, fa, 0, "STT0102.fa");
    check_field_offset(lv, fb, 4, "STT0102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0102, STT0102)
//============================================================================


struct  STT0112  {
  char fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT0112) C1{ Fc FL:8 Fi}



static void Test_STT0112()
{
  {
    init_simple_test("STT0112");
    static STRUCT_IF_C STT0112 lv;
    check2(sizeof(lv), 8, "sizeof(STT0112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0112)");
    check_field_offset(lv, fa, 0, "STT0112.fa");
    check_field_offset(lv, fb, 4, "STT0112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0112, STT0112)
//============================================================================


struct  STT0122  {
  char fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT0122) C1{ Fc Fi:18 Fi}



static void Test_STT0122()
{
  {
    init_simple_test("STT0122");
    static STRUCT_IF_C STT0122 lv;
    check2(sizeof(lv), 8, "sizeof(STT0122)");
    check2(__alignof__(lv), 4, "__alignof__(STT0122)");
    check_field_offset(lv, fa, 0, "STT0122.fa");
    check_field_offset(lv, fb, 4, "STT0122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0122, STT0122)
//============================================================================


struct  STT0132  {
  char fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT0132) C1{ Fc FL:18 Fi}



static void Test_STT0132()
{
  {
    init_simple_test("STT0132");
    static STRUCT_IF_C STT0132 lv;
    check2(sizeof(lv), 8, "sizeof(STT0132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0132)");
    check_field_offset(lv, fa, 0, "STT0132.fa");
    check_field_offset(lv, fb, 4, "STT0132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0132, STT0132)
//============================================================================


struct  STT0142  {
  char fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT0142) C1{ Fc FL:48 Fi}



static void Test_STT0142()
{
  {
    init_simple_test("STT0142");
    static STRUCT_IF_C STT0142 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT0142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0142)");
    check_field_offset(lv, fa, 0, "STT0142.fa");
    check_field_offset(lv, fb, 8, "STT0142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0142, STT0142)
//============================================================================


struct  STT0152  {
  char fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT0152) C1{ Fc Fc:3 Fi}



static void Test_STT0152()
{
  {
    init_simple_test("STT0152");
    static STRUCT_IF_C STT0152 lv;
    check2(sizeof(lv), 8, "sizeof(STT0152)");
    check2(__alignof__(lv), 4, "__alignof__(STT0152)");
    check_field_offset(lv, fa, 0, "STT0152.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0152");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0152");
    check_field_offset(lv, fb, 4, "STT0152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0152, STT0152)
//============================================================================


struct  STT0162  {
  char fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT0162) C1{ Fc Fs:3 Fi}



static void Test_STT0162()
{
  {
    init_simple_test("STT0162");
    static STRUCT_IF_C STT0162 lv;
    check2(sizeof(lv), 8, "sizeof(STT0162)");
    check2(__alignof__(lv), 4, "__alignof__(STT0162)");
    check_field_offset(lv, fa, 0, "STT0162.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0162");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0162");
    check_field_offset(lv, fb, 4, "STT0162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0162, STT0162)
//============================================================================


struct  STT0172  {
  char fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT0172) C1{ Fc Fi:3 Fi}



static void Test_STT0172()
{
  {
    init_simple_test("STT0172");
    static STRUCT_IF_C STT0172 lv;
    check2(sizeof(lv), 8, "sizeof(STT0172)");
    check2(__alignof__(lv), 4, "__alignof__(STT0172)");
    check_field_offset(lv, fa, 0, "STT0172.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0172");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0172");
    check_field_offset(lv, fb, 4, "STT0172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0172, STT0172)
//============================================================================


struct  STT0182  {
  char fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT0182) C1{ Fc FL:3 Fi}



static void Test_STT0182()
{
  {
    init_simple_test("STT0182");
    static STRUCT_IF_C STT0182 lv;
    check2(sizeof(lv), 8, "sizeof(STT0182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0182)");
    check_field_offset(lv, fa, 0, "STT0182.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0182");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0182");
    check_field_offset(lv, fb, 4, "STT0182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0182, STT0182)
//============================================================================


struct  STT0192  {
  char fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT0192) C1{ Fc Fs:8 Fi}



static void Test_STT0192()
{
  {
    init_simple_test("STT0192");
    static STRUCT_IF_C STT0192 lv;
    check2(sizeof(lv), 8, "sizeof(STT0192)");
    check2(__alignof__(lv), 4, "__alignof__(STT0192)");
    check_field_offset(lv, fa, 0, "STT0192.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0192");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0192");
    check_field_offset(lv, fb, 4, "STT0192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0192, STT0192)
//============================================================================


struct  STT0202  {
  char fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT0202) C1{ Fc Fi:8 Fi}



static void Test_STT0202()
{
  {
    init_simple_test("STT0202");
    static STRUCT_IF_C STT0202 lv;
    check2(sizeof(lv), 8, "sizeof(STT0202)");
    check2(__alignof__(lv), 4, "__alignof__(STT0202)");
    check_field_offset(lv, fa, 0, "STT0202.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0202");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0202");
    check_field_offset(lv, fb, 4, "STT0202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0202, STT0202)
//============================================================================


struct  STT0212  {
  char fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT0212) C1{ Fc FL:8 Fi}



static void Test_STT0212()
{
  {
    init_simple_test("STT0212");
    static STRUCT_IF_C STT0212 lv;
    check2(sizeof(lv), 8, "sizeof(STT0212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0212)");
    check_field_offset(lv, fa, 0, "STT0212.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0212");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0212");
    check_field_offset(lv, fb, 4, "STT0212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0212, STT0212)
//============================================================================


struct  STT0222  {
  char fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT0222) C1{ Fc Fi:18 Fi}



static void Test_STT0222()
{
  {
    init_simple_test("STT0222");
    static STRUCT_IF_C STT0222 lv;
    check2(sizeof(lv), 8, "sizeof(STT0222)");
    check2(__alignof__(lv), 4, "__alignof__(STT0222)");
    check_field_offset(lv, fa, 0, "STT0222.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0222");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0222");
    check_field_offset(lv, fb, 4, "STT0222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0222, STT0222)
//============================================================================


struct  STT0232  {
  char fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT0232) C1{ Fc FL:18 Fi}



static void Test_STT0232()
{
  {
    init_simple_test("STT0232");
    static STRUCT_IF_C STT0232 lv;
    check2(sizeof(lv), 8, "sizeof(STT0232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0232)");
    check_field_offset(lv, fa, 0, "STT0232.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0232");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0232");
    check_field_offset(lv, fb, 4, "STT0232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0232, STT0232)
//============================================================================


struct  STT0242  {
  char fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT0242) C1{ Fc FL:48 Fi}



static void Test_STT0242()
{
  {
    init_simple_test("STT0242");
    static STRUCT_IF_C STT0242 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0242)");
    check_field_offset(lv, fa, 0, "STT0242.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0242");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0242");
    check_field_offset(lv, fb, 8, "STT0242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0242, STT0242)
//============================================================================


struct  STT013  {
  char fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT013) C1{ Fc Fc:0 Fl}



static void Test_STT013()
{
  {
    init_simple_test("STT013");
    static STRUCT_IF_C STT013 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT013)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT013)");
    check_field_offset(lv, fa, 0, "STT013.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT013.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT013, STT013)
//============================================================================


struct  STT023  {
  char fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT023) C1{ Fc Fs:0 Fl}



static void Test_STT023()
{
  {
    init_simple_test("STT023");
    static STRUCT_IF_C STT023 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT023)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT023)");
    check_field_offset(lv, fa, 0, "STT023.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT023.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT023, STT023)
//============================================================================


struct  STT033  {
  char fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT033) C1{ Fc Fi:0 Fl}



static void Test_STT033()
{
  {
    init_simple_test("STT033");
    static STRUCT_IF_C STT033 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT033)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT033)");
    check_field_offset(lv, fa, 0, "STT033.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT033.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT033, STT033)
//============================================================================


struct  STT043  {
  char fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT043) C1{ Fc FL:0 Fl}



static void Test_STT043()
{
  {
    init_simple_test("STT043");
    static STRUCT_IF_C STT043 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT043)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT043)");
    check_field_offset(lv, fa, 0, "STT043.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT043.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT043, STT043)
//============================================================================


struct  STT053  {
  char fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT053) C1{ Fc Fc:3 Fl}



static void Test_STT053()
{
  {
    init_simple_test("STT053");
    static STRUCT_IF_C STT053 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT053)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT053)");
    check_field_offset(lv, fa, 0, "STT053.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT053.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT053, STT053)
//============================================================================


struct  STT063  {
  char fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT063) C1{ Fc Fs:3 Fl}



static void Test_STT063()
{
  {
    init_simple_test("STT063");
    static STRUCT_IF_C STT063 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT063)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT063)");
    check_field_offset(lv, fa, 0, "STT063.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT063.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT063, STT063)
//============================================================================


struct  STT073  {
  char fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT073) C1{ Fc Fi:3 Fl}



static void Test_STT073()
{
  {
    init_simple_test("STT073");
    static STRUCT_IF_C STT073 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT073)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT073)");
    check_field_offset(lv, fa, 0, "STT073.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT073.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT073, STT073)
//============================================================================


struct  STT083  {
  char fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT083) C1{ Fc FL:3 Fl}



static void Test_STT083()
{
  {
    init_simple_test("STT083");
    static STRUCT_IF_C STT083 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT083)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT083)");
    check_field_offset(lv, fa, 0, "STT083.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT083.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT083, STT083)
//============================================================================


struct  STT093  {
  char fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT093) C1{ Fc Fs:8 Fl}



static void Test_STT093()
{
  {
    init_simple_test("STT093");
    static STRUCT_IF_C STT093 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT093)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT093)");
    check_field_offset(lv, fa, 0, "STT093.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT093.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT093, STT093)
//============================================================================


struct  STT0103  {
  char fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT0103) C1{ Fc Fi:8 Fl}



static void Test_STT0103()
{
  {
    init_simple_test("STT0103");
    static STRUCT_IF_C STT0103 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0103)");
    check_field_offset(lv, fa, 0, "STT0103.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0103, STT0103)
//============================================================================


struct  STT0113  {
  char fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT0113) C1{ Fc FL:8 Fl}



static void Test_STT0113()
{
  {
    init_simple_test("STT0113");
    static STRUCT_IF_C STT0113 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0113)");
    check_field_offset(lv, fa, 0, "STT0113.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0113, STT0113)
//============================================================================


struct  STT0123  {
  char fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT0123) C1{ Fc Fi:18 Fl}



static void Test_STT0123()
{
  {
    init_simple_test("STT0123");
    static STRUCT_IF_C STT0123 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0123)");
    check_field_offset(lv, fa, 0, "STT0123.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0123, STT0123)
//============================================================================


struct  STT0133  {
  char fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT0133) C1{ Fc FL:18 Fl}



static void Test_STT0133()
{
  {
    init_simple_test("STT0133");
    static STRUCT_IF_C STT0133 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0133)");
    check_field_offset(lv, fa, 0, "STT0133.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0133, STT0133)
//============================================================================


struct  STT0143  {
  char fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT0143) C1{ Fc FL:48 Fl}



static void Test_STT0143()
{
  {
    init_simple_test("STT0143");
    static STRUCT_IF_C STT0143 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0143)");
    check_field_offset(lv, fa, 0, "STT0143.fa");
    check_field_offset(lv, fb, 8, "STT0143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0143, STT0143)
//============================================================================


struct  STT0153  {
  char fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT0153) C1{ Fc Fc:3 Fl}



static void Test_STT0153()
{
  {
    init_simple_test("STT0153");
    static STRUCT_IF_C STT0153 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0153)");
    check_field_offset(lv, fa, 0, "STT0153.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0153");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0153");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0153, STT0153)
//============================================================================


struct  STT0163  {
  char fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT0163) C1{ Fc Fs:3 Fl}



static void Test_STT0163()
{
  {
    init_simple_test("STT0163");
    static STRUCT_IF_C STT0163 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0163)");
    check_field_offset(lv, fa, 0, "STT0163.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0163");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0163");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0163, STT0163)
//============================================================================


struct  STT0173  {
  char fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT0173) C1{ Fc Fi:3 Fl}



static void Test_STT0173()
{
  {
    init_simple_test("STT0173");
    static STRUCT_IF_C STT0173 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0173)");
    check_field_offset(lv, fa, 0, "STT0173.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0173");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0173");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0173, STT0173)
//============================================================================


struct  STT0183  {
  char fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT0183) C1{ Fc FL:3 Fl}



static void Test_STT0183()
{
  {
    init_simple_test("STT0183");
    static STRUCT_IF_C STT0183 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0183)");
    check_field_offset(lv, fa, 0, "STT0183.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0183");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0183");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0183, STT0183)
//============================================================================


struct  STT0193  {
  char fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT0193) C1{ Fc Fs:8 Fl}



static void Test_STT0193()
{
  {
    init_simple_test("STT0193");
    static STRUCT_IF_C STT0193 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0193)");
    check_field_offset(lv, fa, 0, "STT0193.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0193");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0193");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0193, STT0193)
//============================================================================


struct  STT0203  {
  char fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT0203) C1{ Fc Fi:8 Fl}



static void Test_STT0203()
{
  {
    init_simple_test("STT0203");
    static STRUCT_IF_C STT0203 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0203)");
    check_field_offset(lv, fa, 0, "STT0203.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0203");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0203");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0203, STT0203)
//============================================================================


struct  STT0213  {
  char fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT0213) C1{ Fc FL:8 Fl}



static void Test_STT0213()
{
  {
    init_simple_test("STT0213");
    static STRUCT_IF_C STT0213 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0213)");
    check_field_offset(lv, fa, 0, "STT0213.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0213");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0213");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0213, STT0213)
//============================================================================


struct  STT0223  {
  char fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT0223) C1{ Fc Fi:18 Fl}



static void Test_STT0223()
{
  {
    init_simple_test("STT0223");
    static STRUCT_IF_C STT0223 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0223)");
    check_field_offset(lv, fa, 0, "STT0223.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0223");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0223");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0223, STT0223)
//============================================================================


struct  STT0233  {
  char fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT0233) C1{ Fc FL:18 Fl}



static void Test_STT0233()
{
  {
    init_simple_test("STT0233");
    static STRUCT_IF_C STT0233 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0233)");
    check_field_offset(lv, fa, 0, "STT0233.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0233");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0233");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0233, STT0233)
//============================================================================


struct  STT0243  {
  char fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT0243) C1{ Fc FL:48 Fl}



static void Test_STT0243()
{
  {
    init_simple_test("STT0243");
    static STRUCT_IF_C STT0243 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0243)");
    check_field_offset(lv, fa, 0, "STT0243.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0243");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0243");
    check_field_offset(lv, fb, 8, "STT0243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0243, STT0243)
//============================================================================


struct  STT014  {
  char fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT014) C1{ Fc Fc:0 FL}



static void Test_STT014()
{
  {
    init_simple_test("STT014");
    static STRUCT_IF_C STT014 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT014)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT014)");
    check_field_offset(lv, fa, 0, "STT014.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT014.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT014, STT014)
//============================================================================


struct  STT024  {
  char fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT024) C1{ Fc Fs:0 FL}



static void Test_STT024()
{
  {
    init_simple_test("STT024");
    static STRUCT_IF_C STT024 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT024)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT024)");
    check_field_offset(lv, fa, 0, "STT024.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT024.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT024, STT024)
//============================================================================


struct  STT034  {
  char fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT034) C1{ Fc Fi:0 FL}



static void Test_STT034()
{
  {
    init_simple_test("STT034");
    static STRUCT_IF_C STT034 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT034)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT034)");
    check_field_offset(lv, fa, 0, "STT034.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT034.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT034, STT034)
//============================================================================


struct  STT044  {
  char fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT044) C1{ Fc FL:0 FL}



static void Test_STT044()
{
  {
    init_simple_test("STT044");
    static STRUCT_IF_C STT044 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT044)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT044)");
    check_field_offset(lv, fa, 0, "STT044.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT044.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT044, STT044)
//============================================================================


struct  STT054  {
  char fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT054) C1{ Fc Fc:3 FL}



static void Test_STT054()
{
  {
    init_simple_test("STT054");
    static STRUCT_IF_C STT054 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT054)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT054)");
    check_field_offset(lv, fa, 0, "STT054.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT054.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT054, STT054)
//============================================================================


struct  STT064  {
  char fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT064) C1{ Fc Fs:3 FL}



static void Test_STT064()
{
  {
    init_simple_test("STT064");
    static STRUCT_IF_C STT064 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT064)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT064)");
    check_field_offset(lv, fa, 0, "STT064.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT064.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT064, STT064)
//============================================================================


struct  STT074  {
  char fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT074) C1{ Fc Fi:3 FL}



static void Test_STT074()
{
  {
    init_simple_test("STT074");
    static STRUCT_IF_C STT074 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT074)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT074)");
    check_field_offset(lv, fa, 0, "STT074.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT074.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT074, STT074)
//============================================================================


struct  STT084  {
  char fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT084) C1{ Fc FL:3 FL}



static void Test_STT084()
{
  {
    init_simple_test("STT084");
    static STRUCT_IF_C STT084 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT084)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT084)");
    check_field_offset(lv, fa, 0, "STT084.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT084.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT084, STT084)
//============================================================================


struct  STT094  {
  char fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT094) C1{ Fc Fs:8 FL}



static void Test_STT094()
{
  {
    init_simple_test("STT094");
    static STRUCT_IF_C STT094 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT094)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT094)");
    check_field_offset(lv, fa, 0, "STT094.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT094.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT094, STT094)
//============================================================================


struct  STT0104  {
  char fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT0104) C1{ Fc Fi:8 FL}



static void Test_STT0104()
{
  {
    init_simple_test("STT0104");
    static STRUCT_IF_C STT0104 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0104)");
    check_field_offset(lv, fa, 0, "STT0104.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0104, STT0104)
//============================================================================


struct  STT0114  {
  char fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT0114) C1{ Fc FL:8 FL}



static void Test_STT0114()
{
  {
    init_simple_test("STT0114");
    static STRUCT_IF_C STT0114 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0114)");
    check_field_offset(lv, fa, 0, "STT0114.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0114, STT0114)
//============================================================================


struct  STT0124  {
  char fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT0124) C1{ Fc Fi:18 FL}



static void Test_STT0124()
{
  {
    init_simple_test("STT0124");
    static STRUCT_IF_C STT0124 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0124)");
    check_field_offset(lv, fa, 0, "STT0124.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0124, STT0124)
//============================================================================


struct  STT0134  {
  char fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT0134) C1{ Fc FL:18 FL}



static void Test_STT0134()
{
  {
    init_simple_test("STT0134");
    static STRUCT_IF_C STT0134 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0134)");
    check_field_offset(lv, fa, 0, "STT0134.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0134, STT0134)
//============================================================================


struct  STT0144  {
  char fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT0144) C1{ Fc FL:48 FL}



static void Test_STT0144()
{
  {
    init_simple_test("STT0144");
    static STRUCT_IF_C STT0144 lv;
    check2(sizeof(lv), 16, "sizeof(STT0144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0144)");
    check_field_offset(lv, fa, 0, "STT0144.fa");
    check_field_offset(lv, fb, 8, "STT0144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0144, STT0144)
//============================================================================


struct  STT0154  {
  char fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT0154) C1{ Fc Fc:3 FL}



static void Test_STT0154()
{
  {
    init_simple_test("STT0154");
    static STRUCT_IF_C STT0154 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0154)");
    check_field_offset(lv, fa, 0, "STT0154.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0154");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0154");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0154, STT0154)
//============================================================================


struct  STT0164  {
  char fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT0164) C1{ Fc Fs:3 FL}



static void Test_STT0164()
{
  {
    init_simple_test("STT0164");
    static STRUCT_IF_C STT0164 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0164)");
    check_field_offset(lv, fa, 0, "STT0164.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0164");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0164");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0164, STT0164)
//============================================================================


struct  STT0174  {
  char fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT0174) C1{ Fc Fi:3 FL}



static void Test_STT0174()
{
  {
    init_simple_test("STT0174");
    static STRUCT_IF_C STT0174 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0174)");
    check_field_offset(lv, fa, 0, "STT0174.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0174");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0174");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0174, STT0174)
//============================================================================


struct  STT0184  {
  char fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT0184) C1{ Fc FL:3 FL}



static void Test_STT0184()
{
  {
    init_simple_test("STT0184");
    static STRUCT_IF_C STT0184 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0184)");
    check_field_offset(lv, fa, 0, "STT0184.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0184");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0184");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0184, STT0184)
//============================================================================


struct  STT0194  {
  char fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT0194) C1{ Fc Fs:8 FL}



static void Test_STT0194()
{
  {
    init_simple_test("STT0194");
    static STRUCT_IF_C STT0194 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0194)");
    check_field_offset(lv, fa, 0, "STT0194.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0194");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0194");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0194, STT0194)
//============================================================================


struct  STT0204  {
  char fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT0204) C1{ Fc Fi:8 FL}



static void Test_STT0204()
{
  {
    init_simple_test("STT0204");
    static STRUCT_IF_C STT0204 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0204)");
    check_field_offset(lv, fa, 0, "STT0204.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0204");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0204");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0204, STT0204)
//============================================================================


struct  STT0214  {
  char fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT0214) C1{ Fc FL:8 FL}



static void Test_STT0214()
{
  {
    init_simple_test("STT0214");
    static STRUCT_IF_C STT0214 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0214)");
    check_field_offset(lv, fa, 0, "STT0214.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0214");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0214");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0214, STT0214)
//============================================================================


struct  STT0224  {
  char fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT0224) C1{ Fc Fi:18 FL}



static void Test_STT0224()
{
  {
    init_simple_test("STT0224");
    static STRUCT_IF_C STT0224 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0224)");
    check_field_offset(lv, fa, 0, "STT0224.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0224");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0224");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0224, STT0224)
//============================================================================


struct  STT0234  {
  char fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT0234) C1{ Fc FL:18 FL}



static void Test_STT0234()
{
  {
    init_simple_test("STT0234");
    static STRUCT_IF_C STT0234 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0234)");
    check_field_offset(lv, fa, 0, "STT0234.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0234");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0234");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0234, STT0234)
//============================================================================


struct  STT0244  {
  char fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT0244) C1{ Fc FL:48 FL}



static void Test_STT0244()
{
  {
    init_simple_test("STT0244");
    static STRUCT_IF_C STT0244 lv;
    check2(sizeof(lv), 16, "sizeof(STT0244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0244)");
    check_field_offset(lv, fa, 0, "STT0244.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0244");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0244");
    check_field_offset(lv, fb, 8, "STT0244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0244, STT0244)
//============================================================================


struct  STT015  {
  char fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT015) C1{ Fc Fc:0 Fp}



static void Test_STT015()
{
  {
    init_simple_test("STT015");
    static STRUCT_IF_C STT015 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT015)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT015)");
    check_field_offset(lv, fa, 0, "STT015.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT015.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT015, STT015)
//============================================================================


struct  STT025  {
  char fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT025) C1{ Fc Fs:0 Fp}



static void Test_STT025()
{
  {
    init_simple_test("STT025");
    static STRUCT_IF_C STT025 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT025)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT025)");
    check_field_offset(lv, fa, 0, "STT025.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT025.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT025, STT025)
//============================================================================


struct  STT035  {
  char fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT035) C1{ Fc Fi:0 Fp}



static void Test_STT035()
{
  {
    init_simple_test("STT035");
    static STRUCT_IF_C STT035 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT035)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT035)");
    check_field_offset(lv, fa, 0, "STT035.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT035.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT035, STT035)
//============================================================================


struct  STT045  {
  char fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT045) C1{ Fc FL:0 Fp}



static void Test_STT045()
{
  {
    init_simple_test("STT045");
    static STRUCT_IF_C STT045 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT045)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT045)");
    check_field_offset(lv, fa, 0, "STT045.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT045.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT045, STT045)
//============================================================================


struct  STT055  {
  char fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT055) C1{ Fc Fc:3 Fp}



static void Test_STT055()
{
  {
    init_simple_test("STT055");
    static STRUCT_IF_C STT055 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT055)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT055)");
    check_field_offset(lv, fa, 0, "STT055.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT055.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT055, STT055)
//============================================================================


struct  STT065  {
  char fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT065) C1{ Fc Fs:3 Fp}



static void Test_STT065()
{
  {
    init_simple_test("STT065");
    static STRUCT_IF_C STT065 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT065)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT065)");
    check_field_offset(lv, fa, 0, "STT065.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT065.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT065, STT065)
//============================================================================


struct  STT075  {
  char fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT075) C1{ Fc Fi:3 Fp}



static void Test_STT075()
{
  {
    init_simple_test("STT075");
    static STRUCT_IF_C STT075 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT075)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT075)");
    check_field_offset(lv, fa, 0, "STT075.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT075.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT075, STT075)
//============================================================================


struct  STT085  {
  char fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT085) C1{ Fc FL:3 Fp}



static void Test_STT085()
{
  {
    init_simple_test("STT085");
    static STRUCT_IF_C STT085 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT085)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT085)");
    check_field_offset(lv, fa, 0, "STT085.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT085.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT085, STT085)
//============================================================================


struct  STT095  {
  char fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT095) C1{ Fc Fs:8 Fp}



static void Test_STT095()
{
  {
    init_simple_test("STT095");
    static STRUCT_IF_C STT095 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT095)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT095)");
    check_field_offset(lv, fa, 0, "STT095.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT095.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT095, STT095)
//============================================================================


struct  STT0105  {
  char fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT0105) C1{ Fc Fi:8 Fp}



static void Test_STT0105()
{
  {
    init_simple_test("STT0105");
    static STRUCT_IF_C STT0105 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0105)");
    check_field_offset(lv, fa, 0, "STT0105.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0105, STT0105)
//============================================================================


struct  STT0115  {
  char fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT0115) C1{ Fc FL:8 Fp}



static void Test_STT0115()
{
  {
    init_simple_test("STT0115");
    static STRUCT_IF_C STT0115 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0115)");
    check_field_offset(lv, fa, 0, "STT0115.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0115, STT0115)
//============================================================================


struct  STT0125  {
  char fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT0125) C1{ Fc Fi:18 Fp}



static void Test_STT0125()
{
  {
    init_simple_test("STT0125");
    static STRUCT_IF_C STT0125 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0125)");
    check_field_offset(lv, fa, 0, "STT0125.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0125, STT0125)
//============================================================================


struct  STT0135  {
  char fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT0135) C1{ Fc FL:18 Fp}



static void Test_STT0135()
{
  {
    init_simple_test("STT0135");
    static STRUCT_IF_C STT0135 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0135)");
    check_field_offset(lv, fa, 0, "STT0135.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0135, STT0135)
//============================================================================


struct  STT0145  {
  char fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT0145) C1{ Fc FL:48 Fp}



static void Test_STT0145()
{
  {
    init_simple_test("STT0145");
    static STRUCT_IF_C STT0145 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0145)");
    check_field_offset(lv, fa, 0, "STT0145.fa");
    check_field_offset(lv, fb, 8, "STT0145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0145, STT0145)
//============================================================================


struct  STT0155  {
  char fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT0155) C1{ Fc Fc:3 Fp}



static void Test_STT0155()
{
  {
    init_simple_test("STT0155");
    static STRUCT_IF_C STT0155 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0155)");
    check_field_offset(lv, fa, 0, "STT0155.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0155");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0155");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0155, STT0155)
//============================================================================


struct  STT0165  {
  char fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT0165) C1{ Fc Fs:3 Fp}



static void Test_STT0165()
{
  {
    init_simple_test("STT0165");
    static STRUCT_IF_C STT0165 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0165)");
    check_field_offset(lv, fa, 0, "STT0165.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0165");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0165");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0165, STT0165)
//============================================================================


struct  STT0175  {
  char fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT0175) C1{ Fc Fi:3 Fp}



static void Test_STT0175()
{
  {
    init_simple_test("STT0175");
    static STRUCT_IF_C STT0175 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0175)");
    check_field_offset(lv, fa, 0, "STT0175.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0175");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0175");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0175, STT0175)
//============================================================================


struct  STT0185  {
  char fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT0185) C1{ Fc FL:3 Fp}



static void Test_STT0185()
{
  {
    init_simple_test("STT0185");
    static STRUCT_IF_C STT0185 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0185)");
    check_field_offset(lv, fa, 0, "STT0185.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0185");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0185");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0185, STT0185)
//============================================================================


struct  STT0195  {
  char fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT0195) C1{ Fc Fs:8 Fp}



static void Test_STT0195()
{
  {
    init_simple_test("STT0195");
    static STRUCT_IF_C STT0195 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0195)");
    check_field_offset(lv, fa, 0, "STT0195.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0195");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0195");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0195, STT0195)
//============================================================================


struct  STT0205  {
  char fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT0205) C1{ Fc Fi:8 Fp}



static void Test_STT0205()
{
  {
    init_simple_test("STT0205");
    static STRUCT_IF_C STT0205 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0205)");
    check_field_offset(lv, fa, 0, "STT0205.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0205");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0205");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0205, STT0205)
//============================================================================


struct  STT0215  {
  char fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT0215) C1{ Fc FL:8 Fp}



static void Test_STT0215()
{
  {
    init_simple_test("STT0215");
    static STRUCT_IF_C STT0215 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0215)");
    check_field_offset(lv, fa, 0, "STT0215.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0215");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0215");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0215, STT0215)
//============================================================================


struct  STT0225  {
  char fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT0225) C1{ Fc Fi:18 Fp}



static void Test_STT0225()
{
  {
    init_simple_test("STT0225");
    static STRUCT_IF_C STT0225 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0225)");
    check_field_offset(lv, fa, 0, "STT0225.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0225");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0225");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0225, STT0225)
//============================================================================


struct  STT0235  {
  char fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT0235) C1{ Fc FL:18 Fp}



static void Test_STT0235()
{
  {
    init_simple_test("STT0235");
    static STRUCT_IF_C STT0235 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0235)");
    check_field_offset(lv, fa, 0, "STT0235.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0235");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0235");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0235, STT0235)
//============================================================================


struct  STT0245  {
  char fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT0245) C1{ Fc FL:48 Fp}



static void Test_STT0245()
{
  {
    init_simple_test("STT0245");
    static STRUCT_IF_C STT0245 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0245)");
    check_field_offset(lv, fa, 0, "STT0245.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0245");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0245");
    check_field_offset(lv, fb, 8, "STT0245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0245, STT0245)
//============================================================================


struct  STT016  {
  char fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT016) C1{ Fc Fc:0 Fi}



static void Test_STT016()
{
  {
    init_simple_test("STT016");
    static STRUCT_IF_C STT016 lv;
    check2(sizeof(lv), 8, "sizeof(STT016)");
    check2(__alignof__(lv), 4, "__alignof__(STT016)");
    check_field_offset(lv, fa, 0, "STT016.fa");
    check_field_offset(lv, fb, 4, "STT016.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT016, STT016)
//============================================================================


struct  STT026  {
  char fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT026) C1{ Fc Fs:0 Fi}



static void Test_STT026()
{
  {
    init_simple_test("STT026");
    static STRUCT_IF_C STT026 lv;
    check2(sizeof(lv), 8, "sizeof(STT026)");
    check2(__alignof__(lv), 4, "__alignof__(STT026)");
    check_field_offset(lv, fa, 0, "STT026.fa");
    check_field_offset(lv, fb, 4, "STT026.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT026, STT026)
//============================================================================


struct  STT036  {
  char fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT036) C1{ Fc Fi:0 Fi}



static void Test_STT036()
{
  {
    init_simple_test("STT036");
    static STRUCT_IF_C STT036 lv;
    check2(sizeof(lv), 8, "sizeof(STT036)");
    check2(__alignof__(lv), 4, "__alignof__(STT036)");
    check_field_offset(lv, fa, 0, "STT036.fa");
    check_field_offset(lv, fb, 4, "STT036.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT036, STT036)
//============================================================================


struct  STT046  {
  char fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT046) C1{ Fc FL:0 Fi}



static void Test_STT046()
{
  {
    init_simple_test("STT046");
    static STRUCT_IF_C STT046 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT046)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT046)");
    check_field_offset(lv, fa, 0, "STT046.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT046.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT046, STT046)
//============================================================================


struct  STT056  {
  char fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT056) C1{ Fc Fc:3 Fi}



static void Test_STT056()
{
  {
    init_simple_test("STT056");
    static STRUCT_IF_C STT056 lv;
    check2(sizeof(lv), 8, "sizeof(STT056)");
    check2(__alignof__(lv), 4, "__alignof__(STT056)");
    check_field_offset(lv, fa, 0, "STT056.fa");
    check_field_offset(lv, fb, 4, "STT056.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT056, STT056)
//============================================================================


struct  STT066  {
  char fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT066) C1{ Fc Fs:3 Fi}



static void Test_STT066()
{
  {
    init_simple_test("STT066");
    static STRUCT_IF_C STT066 lv;
    check2(sizeof(lv), 8, "sizeof(STT066)");
    check2(__alignof__(lv), 4, "__alignof__(STT066)");
    check_field_offset(lv, fa, 0, "STT066.fa");
    check_field_offset(lv, fb, 4, "STT066.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT066, STT066)
//============================================================================


struct  STT076  {
  char fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT076) C1{ Fc Fi:3 Fi}



static void Test_STT076()
{
  {
    init_simple_test("STT076");
    static STRUCT_IF_C STT076 lv;
    check2(sizeof(lv), 8, "sizeof(STT076)");
    check2(__alignof__(lv), 4, "__alignof__(STT076)");
    check_field_offset(lv, fa, 0, "STT076.fa");
    check_field_offset(lv, fb, 4, "STT076.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT076, STT076)
//============================================================================


struct  STT086  {
  char fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT086) C1{ Fc FL:3 Fi}



static void Test_STT086()
{
  {
    init_simple_test("STT086");
    static STRUCT_IF_C STT086 lv;
    check2(sizeof(lv), 8, "sizeof(STT086)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT086)");
    check_field_offset(lv, fa, 0, "STT086.fa");
    check_field_offset(lv, fb, 4, "STT086.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT086, STT086)
//============================================================================


struct  STT096  {
  char fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT096) C1{ Fc Fs:8 Fi}



static void Test_STT096()
{
  {
    init_simple_test("STT096");
    static STRUCT_IF_C STT096 lv;
    check2(sizeof(lv), 8, "sizeof(STT096)");
    check2(__alignof__(lv), 4, "__alignof__(STT096)");
    check_field_offset(lv, fa, 0, "STT096.fa");
    check_field_offset(lv, fb, 4, "STT096.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT096, STT096)
//============================================================================


struct  STT0106  {
  char fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT0106) C1{ Fc Fi:8 Fi}



static void Test_STT0106()
{
  {
    init_simple_test("STT0106");
    static STRUCT_IF_C STT0106 lv;
    check2(sizeof(lv), 8, "sizeof(STT0106)");
    check2(__alignof__(lv), 4, "__alignof__(STT0106)");
    check_field_offset(lv, fa, 0, "STT0106.fa");
    check_field_offset(lv, fb, 4, "STT0106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0106, STT0106)
//============================================================================


struct  STT0116  {
  char fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT0116) C1{ Fc FL:8 Fi}



static void Test_STT0116()
{
  {
    init_simple_test("STT0116");
    static STRUCT_IF_C STT0116 lv;
    check2(sizeof(lv), 8, "sizeof(STT0116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0116)");
    check_field_offset(lv, fa, 0, "STT0116.fa");
    check_field_offset(lv, fb, 4, "STT0116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0116, STT0116)
//============================================================================


struct  STT0126  {
  char fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT0126) C1{ Fc Fi:18 Fi}



static void Test_STT0126()
{
  {
    init_simple_test("STT0126");
    static STRUCT_IF_C STT0126 lv;
    check2(sizeof(lv), 8, "sizeof(STT0126)");
    check2(__alignof__(lv), 4, "__alignof__(STT0126)");
    check_field_offset(lv, fa, 0, "STT0126.fa");
    check_field_offset(lv, fb, 4, "STT0126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0126, STT0126)
//============================================================================


struct  STT0136  {
  char fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT0136) C1{ Fc FL:18 Fi}



static void Test_STT0136()
{
  {
    init_simple_test("STT0136");
    static STRUCT_IF_C STT0136 lv;
    check2(sizeof(lv), 8, "sizeof(STT0136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0136)");
    check_field_offset(lv, fa, 0, "STT0136.fa");
    check_field_offset(lv, fb, 4, "STT0136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0136, STT0136)
//============================================================================


struct  STT0146  {
  char fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT0146) C1{ Fc FL:48 Fi}



static void Test_STT0146()
{
  {
    init_simple_test("STT0146");
    static STRUCT_IF_C STT0146 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT0146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0146)");
    check_field_offset(lv, fa, 0, "STT0146.fa");
    check_field_offset(lv, fb, 8, "STT0146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0146, STT0146)
//============================================================================


struct  STT0156  {
  char fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT0156) C1{ Fc Fc:3 Fi}



static void Test_STT0156()
{
  {
    init_simple_test("STT0156");
    static STRUCT_IF_C STT0156 lv;
    check2(sizeof(lv), 8, "sizeof(STT0156)");
    check2(__alignof__(lv), 4, "__alignof__(STT0156)");
    check_field_offset(lv, fa, 0, "STT0156.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0156");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0156");
    check_field_offset(lv, fb, 4, "STT0156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0156, STT0156)
//============================================================================


struct  STT0166  {
  char fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT0166) C1{ Fc Fs:3 Fi}



static void Test_STT0166()
{
  {
    init_simple_test("STT0166");
    static STRUCT_IF_C STT0166 lv;
    check2(sizeof(lv), 8, "sizeof(STT0166)");
    check2(__alignof__(lv), 4, "__alignof__(STT0166)");
    check_field_offset(lv, fa, 0, "STT0166.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0166");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0166");
    check_field_offset(lv, fb, 4, "STT0166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0166, STT0166)
//============================================================================


struct  STT0176  {
  char fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT0176) C1{ Fc Fi:3 Fi}



static void Test_STT0176()
{
  {
    init_simple_test("STT0176");
    static STRUCT_IF_C STT0176 lv;
    check2(sizeof(lv), 8, "sizeof(STT0176)");
    check2(__alignof__(lv), 4, "__alignof__(STT0176)");
    check_field_offset(lv, fa, 0, "STT0176.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0176");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0176");
    check_field_offset(lv, fb, 4, "STT0176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0176, STT0176)
//============================================================================


struct  STT0186  {
  char fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT0186) C1{ Fc FL:3 Fi}



static void Test_STT0186()
{
  {
    init_simple_test("STT0186");
    static STRUCT_IF_C STT0186 lv;
    check2(sizeof(lv), 8, "sizeof(STT0186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0186)");
    check_field_offset(lv, fa, 0, "STT0186.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0186");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0186");
    check_field_offset(lv, fb, 4, "STT0186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0186, STT0186)
//============================================================================


struct  STT0196  {
  char fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT0196) C1{ Fc Fs:8 Fi}



static void Test_STT0196()
{
  {
    init_simple_test("STT0196");
    static STRUCT_IF_C STT0196 lv;
    check2(sizeof(lv), 8, "sizeof(STT0196)");
    check2(__alignof__(lv), 4, "__alignof__(STT0196)");
    check_field_offset(lv, fa, 0, "STT0196.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0196");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0196");
    check_field_offset(lv, fb, 4, "STT0196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0196, STT0196)
//============================================================================


struct  STT0206  {
  char fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT0206) C1{ Fc Fi:8 Fi}



static void Test_STT0206()
{
  {
    init_simple_test("STT0206");
    static STRUCT_IF_C STT0206 lv;
    check2(sizeof(lv), 8, "sizeof(STT0206)");
    check2(__alignof__(lv), 4, "__alignof__(STT0206)");
    check_field_offset(lv, fa, 0, "STT0206.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0206");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0206");
    check_field_offset(lv, fb, 4, "STT0206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0206, STT0206)
//============================================================================


struct  STT0216  {
  char fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT0216) C1{ Fc FL:8 Fi}



static void Test_STT0216()
{
  {
    init_simple_test("STT0216");
    static STRUCT_IF_C STT0216 lv;
    check2(sizeof(lv), 8, "sizeof(STT0216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0216)");
    check_field_offset(lv, fa, 0, "STT0216.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0216");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0216");
    check_field_offset(lv, fb, 4, "STT0216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0216, STT0216)
//============================================================================


struct  STT0226  {
  char fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT0226) C1{ Fc Fi:18 Fi}



static void Test_STT0226()
{
  {
    init_simple_test("STT0226");
    static STRUCT_IF_C STT0226 lv;
    check2(sizeof(lv), 8, "sizeof(STT0226)");
    check2(__alignof__(lv), 4, "__alignof__(STT0226)");
    check_field_offset(lv, fa, 0, "STT0226.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0226");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0226");
    check_field_offset(lv, fb, 4, "STT0226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0226, STT0226)
//============================================================================


struct  STT0236  {
  char fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT0236) C1{ Fc FL:18 Fi}



static void Test_STT0236()
{
  {
    init_simple_test("STT0236");
    static STRUCT_IF_C STT0236 lv;
    check2(sizeof(lv), 8, "sizeof(STT0236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0236)");
    check_field_offset(lv, fa, 0, "STT0236.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0236");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0236");
    check_field_offset(lv, fb, 4, "STT0236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0236, STT0236)
//============================================================================


struct  STT0246  {
  char fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT0246) C1{ Fc FL:48 Fi}



static void Test_STT0246()
{
  {
    init_simple_test("STT0246");
    static STRUCT_IF_C STT0246 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0246)");
    check_field_offset(lv, fa, 0, "STT0246.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0246");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0246");
    check_field_offset(lv, fb, 8, "STT0246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0246, STT0246)
//============================================================================


struct  STT017  {
  char fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT017) C1{ Fc Fc:0 FL}



static void Test_STT017()
{
  {
    init_simple_test("STT017");
    static STRUCT_IF_C STT017 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT017)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT017)");
    check_field_offset(lv, fa, 0, "STT017.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT017.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT017, STT017)
//============================================================================


struct  STT027  {
  char fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT027) C1{ Fc Fs:0 FL}



static void Test_STT027()
{
  {
    init_simple_test("STT027");
    static STRUCT_IF_C STT027 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT027)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT027)");
    check_field_offset(lv, fa, 0, "STT027.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT027.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT027, STT027)
//============================================================================


struct  STT037  {
  char fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT037) C1{ Fc Fi:0 FL}



static void Test_STT037()
{
  {
    init_simple_test("STT037");
    static STRUCT_IF_C STT037 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT037)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT037)");
    check_field_offset(lv, fa, 0, "STT037.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT037.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT037, STT037)
//============================================================================


struct  STT047  {
  char fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT047) C1{ Fc FL:0 FL}



static void Test_STT047()
{
  {
    init_simple_test("STT047");
    static STRUCT_IF_C STT047 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT047)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT047)");
    check_field_offset(lv, fa, 0, "STT047.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT047.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT047, STT047)
//============================================================================


struct  STT057  {
  char fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT057) C1{ Fc Fc:3 FL}



static void Test_STT057()
{
  {
    init_simple_test("STT057");
    static STRUCT_IF_C STT057 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT057)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT057)");
    check_field_offset(lv, fa, 0, "STT057.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT057.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT057, STT057)
//============================================================================


struct  STT067  {
  char fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT067) C1{ Fc Fs:3 FL}



static void Test_STT067()
{
  {
    init_simple_test("STT067");
    static STRUCT_IF_C STT067 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT067)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT067)");
    check_field_offset(lv, fa, 0, "STT067.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT067.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT067, STT067)
//============================================================================


struct  STT077  {
  char fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT077) C1{ Fc Fi:3 FL}



static void Test_STT077()
{
  {
    init_simple_test("STT077");
    static STRUCT_IF_C STT077 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT077)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT077)");
    check_field_offset(lv, fa, 0, "STT077.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT077.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT077, STT077)
//============================================================================


struct  STT087  {
  char fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT087) C1{ Fc FL:3 FL}



static void Test_STT087()
{
  {
    init_simple_test("STT087");
    static STRUCT_IF_C STT087 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT087)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT087)");
    check_field_offset(lv, fa, 0, "STT087.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT087.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT087, STT087)
//============================================================================


struct  STT097  {
  char fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT097) C1{ Fc Fs:8 FL}



static void Test_STT097()
{
  {
    init_simple_test("STT097");
    static STRUCT_IF_C STT097 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT097)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT097)");
    check_field_offset(lv, fa, 0, "STT097.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT097.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT097, STT097)
//============================================================================


struct  STT0107  {
  char fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT0107) C1{ Fc Fi:8 FL}



static void Test_STT0107()
{
  {
    init_simple_test("STT0107");
    static STRUCT_IF_C STT0107 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0107)");
    check_field_offset(lv, fa, 0, "STT0107.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0107, STT0107)
//============================================================================


struct  STT0117  {
  char fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT0117) C1{ Fc FL:8 FL}



static void Test_STT0117()
{
  {
    init_simple_test("STT0117");
    static STRUCT_IF_C STT0117 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0117)");
    check_field_offset(lv, fa, 0, "STT0117.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0117, STT0117)
//============================================================================


struct  STT0127  {
  char fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT0127) C1{ Fc Fi:18 FL}



static void Test_STT0127()
{
  {
    init_simple_test("STT0127");
    static STRUCT_IF_C STT0127 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0127)");
    check_field_offset(lv, fa, 0, "STT0127.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0127, STT0127)
//============================================================================


struct  STT0137  {
  char fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT0137) C1{ Fc FL:18 FL}



static void Test_STT0137()
{
  {
    init_simple_test("STT0137");
    static STRUCT_IF_C STT0137 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0137)");
    check_field_offset(lv, fa, 0, "STT0137.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0137, STT0137)
//============================================================================


struct  STT0147  {
  char fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT0147) C1{ Fc FL:48 FL}



static void Test_STT0147()
{
  {
    init_simple_test("STT0147");
    static STRUCT_IF_C STT0147 lv;
    check2(sizeof(lv), 16, "sizeof(STT0147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0147)");
    check_field_offset(lv, fa, 0, "STT0147.fa");
    check_field_offset(lv, fb, 8, "STT0147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0147, STT0147)
//============================================================================


struct  STT0157  {
  char fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT0157) C1{ Fc Fc:3 FL}



static void Test_STT0157()
{
  {
    init_simple_test("STT0157");
    static STRUCT_IF_C STT0157 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0157)");
    check_field_offset(lv, fa, 0, "STT0157.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0157");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0157");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0157, STT0157)
//============================================================================


struct  STT0167  {
  char fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT0167) C1{ Fc Fs:3 FL}



static void Test_STT0167()
{
  {
    init_simple_test("STT0167");
    static STRUCT_IF_C STT0167 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0167)");
    check_field_offset(lv, fa, 0, "STT0167.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0167");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0167");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0167, STT0167)
//============================================================================


struct  STT0177  {
  char fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT0177) C1{ Fc Fi:3 FL}



static void Test_STT0177()
{
  {
    init_simple_test("STT0177");
    static STRUCT_IF_C STT0177 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0177)");
    check_field_offset(lv, fa, 0, "STT0177.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0177");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0177");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0177, STT0177)
//============================================================================


struct  STT0187  {
  char fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT0187) C1{ Fc FL:3 FL}



static void Test_STT0187()
{
  {
    init_simple_test("STT0187");
    static STRUCT_IF_C STT0187 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0187)");
    check_field_offset(lv, fa, 0, "STT0187.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0187");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0187");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0187, STT0187)
//============================================================================


struct  STT0197  {
  char fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT0197) C1{ Fc Fs:8 FL}



static void Test_STT0197()
{
  {
    init_simple_test("STT0197");
    static STRUCT_IF_C STT0197 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0197)");
    check_field_offset(lv, fa, 0, "STT0197.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0197");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0197");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0197, STT0197)
//============================================================================


struct  STT0207  {
  char fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT0207) C1{ Fc Fi:8 FL}



static void Test_STT0207()
{
  {
    init_simple_test("STT0207");
    static STRUCT_IF_C STT0207 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0207)");
    check_field_offset(lv, fa, 0, "STT0207.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0207");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0207");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0207, STT0207)
//============================================================================


struct  STT0217  {
  char fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT0217) C1{ Fc FL:8 FL}



static void Test_STT0217()
{
  {
    init_simple_test("STT0217");
    static STRUCT_IF_C STT0217 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0217)");
    check_field_offset(lv, fa, 0, "STT0217.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0217");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0217");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0217, STT0217)
//============================================================================


struct  STT0227  {
  char fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT0227) C1{ Fc Fi:18 FL}



static void Test_STT0227()
{
  {
    init_simple_test("STT0227");
    static STRUCT_IF_C STT0227 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0227)");
    check_field_offset(lv, fa, 0, "STT0227.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0227");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0227");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0227, STT0227)
//============================================================================


struct  STT0237  {
  char fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT0237) C1{ Fc FL:18 FL}



static void Test_STT0237()
{
  {
    init_simple_test("STT0237");
    static STRUCT_IF_C STT0237 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0237)");
    check_field_offset(lv, fa, 0, "STT0237.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0237");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0237");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0237, STT0237)
//============================================================================


struct  STT0247  {
  char fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT0247) C1{ Fc FL:48 FL}



static void Test_STT0247()
{
  {
    init_simple_test("STT0247");
    static STRUCT_IF_C STT0247 lv;
    check2(sizeof(lv), 16, "sizeof(STT0247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0247)");
    check_field_offset(lv, fa, 0, "STT0247.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0247");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0247");
    check_field_offset(lv, fb, 8, "STT0247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0247, STT0247)
//============================================================================


struct  STT018  {
  char fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT018) C1{ Fc Fc:0 FD}



static void Test_STT018()
{
  {
    init_simple_test("STT018");
    static STRUCT_IF_C STT018 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT018)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT018)");
    check_field_offset(lv, fa, 0, "STT018.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT018.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT018, STT018)
//============================================================================


struct  STT028  {
  char fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT028) C1{ Fc Fs:0 FD}



static void Test_STT028()
{
  {
    init_simple_test("STT028");
    static STRUCT_IF_C STT028 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT028)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT028)");
    check_field_offset(lv, fa, 0, "STT028.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT028.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT028, STT028)
//============================================================================


struct  STT038  {
  char fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT038) C1{ Fc Fi:0 FD}



static void Test_STT038()
{
  {
    init_simple_test("STT038");
    static STRUCT_IF_C STT038 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT038)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT038)");
    check_field_offset(lv, fa, 0, "STT038.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT038.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT038, STT038)
//============================================================================


struct  STT048  {
  char fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT048) C1{ Fc FL:0 FD}



static void Test_STT048()
{
  {
    init_simple_test("STT048");
    static STRUCT_IF_C STT048 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT048)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT048)");
    check_field_offset(lv, fa, 0, "STT048.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT048.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT048, STT048)
//============================================================================


struct  STT058  {
  char fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT058) C1{ Fc Fc:3 FD}



static void Test_STT058()
{
  {
    init_simple_test("STT058");
    static STRUCT_IF_C STT058 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT058)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT058)");
    check_field_offset(lv, fa, 0, "STT058.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT058.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT058, STT058)
//============================================================================


struct  STT068  {
  char fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT068) C1{ Fc Fs:3 FD}



static void Test_STT068()
{
  {
    init_simple_test("STT068");
    static STRUCT_IF_C STT068 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT068)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT068)");
    check_field_offset(lv, fa, 0, "STT068.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT068.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT068, STT068)
//============================================================================


struct  STT078  {
  char fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT078) C1{ Fc Fi:3 FD}



static void Test_STT078()
{
  {
    init_simple_test("STT078");
    static STRUCT_IF_C STT078 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT078)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT078)");
    check_field_offset(lv, fa, 0, "STT078.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT078.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT078, STT078)
//============================================================================


struct  STT088  {
  char fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT088) C1{ Fc FL:3 FD}



static void Test_STT088()
{
  {
    init_simple_test("STT088");
    static STRUCT_IF_C STT088 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT088)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT088)");
    check_field_offset(lv, fa, 0, "STT088.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT088.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT088, STT088)
//============================================================================


struct  STT098  {
  char fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT098) C1{ Fc Fs:8 FD}



static void Test_STT098()
{
  {
    init_simple_test("STT098");
    static STRUCT_IF_C STT098 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT098)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT098)");
    check_field_offset(lv, fa, 0, "STT098.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT098.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT098, STT098)
//============================================================================


struct  STT0108  {
  char fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT0108) C1{ Fc Fi:8 FD}



static void Test_STT0108()
{
  {
    init_simple_test("STT0108");
    static STRUCT_IF_C STT0108 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0108)");
    check_field_offset(lv, fa, 0, "STT0108.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0108, STT0108)
//============================================================================


struct  STT0118  {
  char fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT0118) C1{ Fc FL:8 FD}



static void Test_STT0118()
{
  {
    init_simple_test("STT0118");
    static STRUCT_IF_C STT0118 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0118)");
    check_field_offset(lv, fa, 0, "STT0118.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0118, STT0118)
//============================================================================


struct  STT0128  {
  char fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT0128) C1{ Fc Fi:18 FD}



static void Test_STT0128()
{
  {
    init_simple_test("STT0128");
    static STRUCT_IF_C STT0128 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0128)");
    check_field_offset(lv, fa, 0, "STT0128.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0128, STT0128)
//============================================================================


struct  STT0138  {
  char fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT0138) C1{ Fc FL:18 FD}



static void Test_STT0138()
{
  {
    init_simple_test("STT0138");
    static STRUCT_IF_C STT0138 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0138)");
    check_field_offset(lv, fa, 0, "STT0138.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0138, STT0138)
//============================================================================


struct  STT0148  {
  char fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT0148) C1{ Fc FL:48 FD}



static void Test_STT0148()
{
  {
    init_simple_test("STT0148");
    static STRUCT_IF_C STT0148 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT0148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0148)");
    check_field_offset(lv, fa, 0, "STT0148.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT0148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0148, STT0148)
//============================================================================


struct  STT0158  {
  char fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT0158) C1{ Fc Fc:3 FD}



static void Test_STT0158()
{
  {
    init_simple_test("STT0158");
    static STRUCT_IF_C STT0158 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0158)");
    check_field_offset(lv, fa, 0, "STT0158.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0158");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0158");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0158, STT0158)
//============================================================================


struct  STT0168  {
  char fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT0168) C1{ Fc Fs:3 FD}



static void Test_STT0168()
{
  {
    init_simple_test("STT0168");
    static STRUCT_IF_C STT0168 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0168)");
    check_field_offset(lv, fa, 0, "STT0168.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0168");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0168");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0168, STT0168)
//============================================================================


struct  STT0178  {
  char fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT0178) C1{ Fc Fi:3 FD}



static void Test_STT0178()
{
  {
    init_simple_test("STT0178");
    static STRUCT_IF_C STT0178 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0178)");
    check_field_offset(lv, fa, 0, "STT0178.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0178");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0178");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0178, STT0178)
//============================================================================


struct  STT0188  {
  char fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT0188) C1{ Fc FL:3 FD}



static void Test_STT0188()
{
  {
    init_simple_test("STT0188");
    static STRUCT_IF_C STT0188 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0188)");
    check_field_offset(lv, fa, 0, "STT0188.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0188");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0188");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0188, STT0188)
//============================================================================


struct  STT0198  {
  char fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT0198) C1{ Fc Fs:8 FD}



static void Test_STT0198()
{
  {
    init_simple_test("STT0198");
    static STRUCT_IF_C STT0198 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0198)");
    check_field_offset(lv, fa, 0, "STT0198.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0198");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0198");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0198, STT0198)
//============================================================================


struct  STT0208  {
  char fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT0208) C1{ Fc Fi:8 FD}



static void Test_STT0208()
{
  {
    init_simple_test("STT0208");
    static STRUCT_IF_C STT0208 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0208)");
    check_field_offset(lv, fa, 0, "STT0208.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0208");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0208");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0208, STT0208)
//============================================================================


struct  STT0218  {
  char fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT0218) C1{ Fc FL:8 FD}



static void Test_STT0218()
{
  {
    init_simple_test("STT0218");
    static STRUCT_IF_C STT0218 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0218)");
    check_field_offset(lv, fa, 0, "STT0218.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0218");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0218");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0218, STT0218)
//============================================================================


struct  STT0228  {
  char fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT0228) C1{ Fc Fi:18 FD}



static void Test_STT0228()
{
  {
    init_simple_test("STT0228");
    static STRUCT_IF_C STT0228 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0228)");
    check_field_offset(lv, fa, 0, "STT0228.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0228");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0228");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0228, STT0228)
//============================================================================


struct  STT0238  {
  char fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT0238) C1{ Fc FL:18 FD}



static void Test_STT0238()
{
  {
    init_simple_test("STT0238");
    static STRUCT_IF_C STT0238 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0238)");
    check_field_offset(lv, fa, 0, "STT0238.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0238");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0238");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0238, STT0238)
//============================================================================


struct  STT0248  {
  char fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT0248) C1{ Fc FL:48 FD}



static void Test_STT0248()
{
  {
    init_simple_test("STT0248");
    static STRUCT_IF_C STT0248 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT0248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0248)");
    check_field_offset(lv, fa, 0, "STT0248.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0248");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0248");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT0248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0248, STT0248)
//============================================================================


struct  STT019  {
  char fa;
  unsigned char  :0;
};
//SIG(1 STT019) C1{ Fc Fc:0}



static void Test_STT019()
{
  {
    init_simple_test("STT019");
    static STRUCT_IF_C STT019 lv;
    check2(sizeof(lv), 1, "sizeof(STT019)");
    check2(__alignof__(lv), 1, "__alignof__(STT019)");
    check_field_offset(lv, fa, 0, "STT019.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT019, STT019)
//============================================================================


struct  STT029  {
  char fa;
  unsigned short  :0;
};
//SIG(1 STT029) C1{ Fc Fs:0}



static void Test_STT029()
{
  {
    init_simple_test("STT029");
    static STRUCT_IF_C STT029 lv;
    check2(sizeof(lv), 2, "sizeof(STT029)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT029)");
    check_field_offset(lv, fa, 0, "STT029.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT029, STT029)
//============================================================================


struct  STT039  {
  char fa;
  unsigned int  :0;
};
//SIG(1 STT039) C1{ Fc Fi:0}



static void Test_STT039()
{
  {
    init_simple_test("STT039");
    static STRUCT_IF_C STT039 lv;
    check2(sizeof(lv), 4, "sizeof(STT039)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT039)");
    check_field_offset(lv, fa, 0, "STT039.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT039, STT039)
//============================================================================


struct  STT049  {
  char fa;
  __tsu64  :0;
};
//SIG(1 STT049) C1{ Fc FL:0}



static void Test_STT049()
{
  {
    init_simple_test("STT049");
    static STRUCT_IF_C STT049 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT049)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT049)");
    check_field_offset(lv, fa, 0, "STT049.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT049, STT049)
//============================================================================


struct  STT059  {
  char fa;
  unsigned char  :3;
};
//SIG(1 STT059) C1{ Fc Fc:3}



static void Test_STT059()
{
  {
    init_simple_test("STT059");
    static STRUCT_IF_C STT059 lv;
    check2(sizeof(lv), 2, "sizeof(STT059)");
    check2(__alignof__(lv), 1, "__alignof__(STT059)");
    check_field_offset(lv, fa, 0, "STT059.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT059, STT059)
//============================================================================


struct  STT069  {
  char fa;
  unsigned short  :3;
};
//SIG(1 STT069) C1{ Fc Fs:3}



static void Test_STT069()
{
  {
    init_simple_test("STT069");
    static STRUCT_IF_C STT069 lv;
    check2(sizeof(lv), 2, "sizeof(STT069)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT069)");
    check_field_offset(lv, fa, 0, "STT069.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT069, STT069)
//============================================================================


struct  STT079  {
  char fa;
  unsigned int  :3;
};
//SIG(1 STT079) C1{ Fc Fi:3}



static void Test_STT079()
{
  {
    init_simple_test("STT079");
    static STRUCT_IF_C STT079 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT079)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT079)");
    check_field_offset(lv, fa, 0, "STT079.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT079, STT079)
//============================================================================


struct  STT089  {
  char fa;
  __tsu64  :3;
};
//SIG(1 STT089) C1{ Fc FL:3}



static void Test_STT089()
{
  {
    init_simple_test("STT089");
    static STRUCT_IF_C STT089 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT089)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT089)");
    check_field_offset(lv, fa, 0, "STT089.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT089, STT089)
//============================================================================


struct  STT099  {
  char fa;
  unsigned short  :8;
};
//SIG(1 STT099) C1{ Fc Fs:8}



static void Test_STT099()
{
  {
    init_simple_test("STT099");
    static STRUCT_IF_C STT099 lv;
    check2(sizeof(lv), 2, "sizeof(STT099)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT099)");
    check_field_offset(lv, fa, 0, "STT099.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT099, STT099)
//============================================================================


struct  STT0109  {
  char fa;
  unsigned int  :8;
};
//SIG(1 STT0109) C1{ Fc Fi:8}



static void Test_STT0109()
{
  {
    init_simple_test("STT0109");
    static STRUCT_IF_C STT0109 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT0109)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0109)");
    check_field_offset(lv, fa, 0, "STT0109.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0109, STT0109)
//============================================================================


struct  STT0119  {
  char fa;
  __tsu64  :8;
};
//SIG(1 STT0119) C1{ Fc FL:8}



static void Test_STT0119()
{
  {
    init_simple_test("STT0119");
    static STRUCT_IF_C STT0119 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT0119)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0119)");
    check_field_offset(lv, fa, 0, "STT0119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0119, STT0119)
//============================================================================


struct  STT0129  {
  char fa;
  unsigned int  :18;
};
//SIG(1 STT0129) C1{ Fc Fi:18}



static void Test_STT0129()
{
  {
    init_simple_test("STT0129");
    static STRUCT_IF_C STT0129 lv;
    check2(sizeof(lv), 4, "sizeof(STT0129)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0129)");
    check_field_offset(lv, fa, 0, "STT0129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0129, STT0129)
//============================================================================


struct  STT0139  {
  char fa;
  __tsu64  :18;
};
//SIG(1 STT0139) C1{ Fc FL:18}



static void Test_STT0139()
{
  {
    init_simple_test("STT0139");
    static STRUCT_IF_C STT0139 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT0139)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0139)");
    check_field_offset(lv, fa, 0, "STT0139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0139, STT0139)
//============================================================================


struct  STT0149  {
  char fa;
  __tsu64  :48;
};
//SIG(1 STT0149) C1{ Fc FL:48}



static void Test_STT0149()
{
  {
    init_simple_test("STT0149");
    static STRUCT_IF_C STT0149 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(STT0149)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0149)");
    check_field_offset(lv, fa, 0, "STT0149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0149, STT0149)
//============================================================================


struct  STT0159  {
  char fa;
  unsigned char bf:3;
};
//SIG(1 STT0159) C1{ Fc Fc:3}



static void Test_STT0159()
{
  {
    init_simple_test("STT0159");
    static STRUCT_IF_C STT0159 lv;
    check2(sizeof(lv), 2, "sizeof(STT0159)");
    check2(__alignof__(lv), 1, "__alignof__(STT0159)");
    check_field_offset(lv, fa, 0, "STT0159.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0159");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0159");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0159, STT0159)
//============================================================================


struct  STT0169  {
  char fa;
  unsigned short bf:3;
};
//SIG(1 STT0169) C1{ Fc Fs:3}



static void Test_STT0169()
{
  {
    init_simple_test("STT0169");
    static STRUCT_IF_C STT0169 lv;
    check2(sizeof(lv), 2, "sizeof(STT0169)");
    check2(__alignof__(lv), 2, "__alignof__(STT0169)");
    check_field_offset(lv, fa, 0, "STT0169.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0169");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0169");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0169, STT0169)
//============================================================================


struct  STT0179  {
  char fa;
  unsigned int bf:3;
};
//SIG(1 STT0179) C1{ Fc Fi:3}



static void Test_STT0179()
{
  {
    init_simple_test("STT0179");
    static STRUCT_IF_C STT0179 lv;
    check2(sizeof(lv), 4, "sizeof(STT0179)");
    check2(__alignof__(lv), 4, "__alignof__(STT0179)");
    check_field_offset(lv, fa, 0, "STT0179.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0179");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0179");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0179, STT0179)
//============================================================================


struct  STT0189  {
  char fa;
  __tsu64 bf:3;
};
//SIG(1 STT0189) C1{ Fc FL:3}



static void Test_STT0189()
{
  {
    init_simple_test("STT0189");
    static STRUCT_IF_C STT0189 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0189)");
    check_field_offset(lv, fa, 0, "STT0189.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0189");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0189");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0189, STT0189)
//============================================================================


struct  STT0199  {
  char fa;
  unsigned short bf:8;
};
//SIG(1 STT0199) C1{ Fc Fs:8}



static void Test_STT0199()
{
  {
    init_simple_test("STT0199");
    static STRUCT_IF_C STT0199 lv;
    check2(sizeof(lv), 2, "sizeof(STT0199)");
    check2(__alignof__(lv), 2, "__alignof__(STT0199)");
    check_field_offset(lv, fa, 0, "STT0199.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0199");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0199");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0199, STT0199)
//============================================================================


struct  STT0209  {
  char fa;
  unsigned int bf:8;
};
//SIG(1 STT0209) C1{ Fc Fi:8}



static void Test_STT0209()
{
  {
    init_simple_test("STT0209");
    static STRUCT_IF_C STT0209 lv;
    check2(sizeof(lv), 4, "sizeof(STT0209)");
    check2(__alignof__(lv), 4, "__alignof__(STT0209)");
    check_field_offset(lv, fa, 0, "STT0209.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0209");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0209");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0209, STT0209)
//============================================================================


struct  STT0219  {
  char fa;
  __tsu64 bf:8;
};
//SIG(1 STT0219) C1{ Fc FL:8}



static void Test_STT0219()
{
  {
    init_simple_test("STT0219");
    static STRUCT_IF_C STT0219 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0219)");
    check_field_offset(lv, fa, 0, "STT0219.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0219");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0219");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0219, STT0219)
//============================================================================


struct  STT0229  {
  char fa;
  unsigned int bf:18;
};
//SIG(1 STT0229) C1{ Fc Fi:18}



static void Test_STT0229()
{
  {
    init_simple_test("STT0229");
    static STRUCT_IF_C STT0229 lv;
    check2(sizeof(lv), 4, "sizeof(STT0229)");
    check2(__alignof__(lv), 4, "__alignof__(STT0229)");
    check_field_offset(lv, fa, 0, "STT0229.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0229");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0229");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0229, STT0229)
//============================================================================


struct  STT0239  {
  char fa;
  __tsu64 bf:18;
};
//SIG(1 STT0239) C1{ Fc FL:18}



static void Test_STT0239()
{
  {
    init_simple_test("STT0239");
    static STRUCT_IF_C STT0239 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0239)");
    check_field_offset(lv, fa, 0, "STT0239.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0239");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0239");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0239, STT0239)
//============================================================================


struct  STT0249  {
  char fa;
  __tsu64 bf:48;
};
//SIG(1 STT0249) C1{ Fc FL:48}



static void Test_STT0249()
{
  {
    init_simple_test("STT0249");
    static STRUCT_IF_C STT0249 lv;
    check2(sizeof(lv), 8, "sizeof(STT0249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0249)");
    check_field_offset(lv, fa, 0, "STT0249.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0249");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0249");
  }
}
ARRANGE_TO_CALL_ME(Test_STT0249, STT0249)
//============================================================================


struct  STT110  {
  short fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT110) C1{ Fs Fc:0 Fc}



static void Test_STT110()
{
  {
    init_simple_test("STT110");
    static STRUCT_IF_C STT110 lv;
    check2(sizeof(lv), 4, "sizeof(STT110)");
    check2(__alignof__(lv), 2, "__alignof__(STT110)");
    check_field_offset(lv, fa, 0, "STT110.fa");
    check_field_offset(lv, fb, 2, "STT110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT110, STT110)
//============================================================================


struct  STT120  {
  short fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT120) C1{ Fs Fs:0 Fc}



static void Test_STT120()
{
  {
    init_simple_test("STT120");
    static STRUCT_IF_C STT120 lv;
    check2(sizeof(lv), 4, "sizeof(STT120)");
    check2(__alignof__(lv), 2, "__alignof__(STT120)");
    check_field_offset(lv, fa, 0, "STT120.fa");
    check_field_offset(lv, fb, 2, "STT120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT120, STT120)
//============================================================================


struct  STT130  {
  short fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT130) C1{ Fs Fi:0 Fc}



static void Test_STT130()
{
  {
    init_simple_test("STT130");
    static STRUCT_IF_C STT130 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT130)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT130)");
    check_field_offset(lv, fa, 0, "STT130.fa");
    check_field_offset(lv, fb, 4, "STT130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT130, STT130)
//============================================================================


struct  STT140  {
  short fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT140) C1{ Fs FL:0 Fc}



static void Test_STT140()
{
  {
    init_simple_test("STT140");
    static STRUCT_IF_C STT140 lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(STT140)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT140)");
    check_field_offset(lv, fa, 0, "STT140.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT140, STT140)
//============================================================================


struct  STT150  {
  short fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT150) C1{ Fs Fc:3 Fc}



static void Test_STT150()
{
  {
    init_simple_test("STT150");
    static STRUCT_IF_C STT150 lv;
    check2(sizeof(lv), 4, "sizeof(STT150)");
    check2(__alignof__(lv), 2, "__alignof__(STT150)");
    check_field_offset(lv, fa, 0, "STT150.fa");
    check_field_offset(lv, fb, 3, "STT150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT150, STT150)
//============================================================================


struct  STT160  {
  short fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT160) C1{ Fs Fs:3 Fc}



static void Test_STT160()
{
  {
    init_simple_test("STT160");
    static STRUCT_IF_C STT160 lv;
    check2(sizeof(lv), 4, "sizeof(STT160)");
    check2(__alignof__(lv), 2, "__alignof__(STT160)");
    check_field_offset(lv, fa, 0, "STT160.fa");
    check_field_offset(lv, fb, 3, "STT160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT160, STT160)
//============================================================================


struct  STT170  {
  short fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT170) C1{ Fs Fi:3 Fc}



static void Test_STT170()
{
  {
    init_simple_test("STT170");
    static STRUCT_IF_C STT170 lv;
    check2(sizeof(lv), 4, "sizeof(STT170)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT170)");
    check_field_offset(lv, fa, 0, "STT170.fa");
    check_field_offset(lv, fb, 3, "STT170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT170, STT170)
//============================================================================


struct  STT180  {
  short fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT180) C1{ Fs FL:3 Fc}



static void Test_STT180()
{
  {
    init_simple_test("STT180");
    static STRUCT_IF_C STT180 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT180)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT180)");
    check_field_offset(lv, fa, 0, "STT180.fa");
    check_field_offset(lv, fb, 3, "STT180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT180, STT180)
//============================================================================


struct  STT190  {
  short fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT190) C1{ Fs Fs:8 Fc}



static void Test_STT190()
{
  {
    init_simple_test("STT190");
    static STRUCT_IF_C STT190 lv;
    check2(sizeof(lv), 4, "sizeof(STT190)");
    check2(__alignof__(lv), 2, "__alignof__(STT190)");
    check_field_offset(lv, fa, 0, "STT190.fa");
    check_field_offset(lv, fb, 3, "STT190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT190, STT190)
//============================================================================


struct  STT1100  {
  short fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT1100) C1{ Fs Fi:8 Fc}



static void Test_STT1100()
{
  {
    init_simple_test("STT1100");
    static STRUCT_IF_C STT1100 lv;
    check2(sizeof(lv), 4, "sizeof(STT1100)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1100)");
    check_field_offset(lv, fa, 0, "STT1100.fa");
    check_field_offset(lv, fb, 3, "STT1100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1100, STT1100)
//============================================================================


struct  STT1110  {
  short fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT1110) C1{ Fs FL:8 Fc}



static void Test_STT1110()
{
  {
    init_simple_test("STT1110");
    static STRUCT_IF_C STT1110 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT1110)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1110)");
    check_field_offset(lv, fa, 0, "STT1110.fa");
    check_field_offset(lv, fb, 3, "STT1110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1110, STT1110)
//============================================================================


struct  STT1120  {
  short fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT1120) C1{ Fs Fi:18 Fc}



static void Test_STT1120()
{
  {
    init_simple_test("STT1120");
    static STRUCT_IF_C STT1120 lv;
    check2(sizeof(lv), 8, "sizeof(STT1120)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1120)");
    check_field_offset(lv, fa, 0, "STT1120.fa");
    check_field_offset(lv, fb, 7, "STT1120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1120, STT1120)
//============================================================================


struct  STT1130  {
  short fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT1130) C1{ Fs FL:18 Fc}



static void Test_STT1130()
{
  {
    init_simple_test("STT1130");
    static STRUCT_IF_C STT1130 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1130)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1130)");
    check_field_offset(lv, fa, 0, "STT1130.fa");
    check_field_offset(lv, fb, 5, "STT1130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1130, STT1130)
//============================================================================


struct  STT1140  {
  short fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT1140) C1{ Fs FL:48 Fc}



static void Test_STT1140()
{
  {
    init_simple_test("STT1140");
    static STRUCT_IF_C STT1140 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT1140)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1140)");
    check_field_offset(lv, fa, 0, "STT1140.fa");
    check_field_offset(lv, fb, 8, "STT1140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1140, STT1140)
//============================================================================


struct  STT1150  {
  short fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT1150) C1{ Fs Fc:3 Fc}



static void Test_STT1150()
{
  {
    init_simple_test("STT1150");
    static STRUCT_IF_C STT1150 lv;
    check2(sizeof(lv), 4, "sizeof(STT1150)");
    check2(__alignof__(lv), 2, "__alignof__(STT1150)");
    check_field_offset(lv, fa, 0, "STT1150.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1150");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1150");
    check_field_offset(lv, fb, 3, "STT1150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1150, STT1150)
//============================================================================


struct  STT1160  {
  short fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT1160) C1{ Fs Fs:3 Fc}



static void Test_STT1160()
{
  {
    init_simple_test("STT1160");
    static STRUCT_IF_C STT1160 lv;
    check2(sizeof(lv), 4, "sizeof(STT1160)");
    check2(__alignof__(lv), 2, "__alignof__(STT1160)");
    check_field_offset(lv, fa, 0, "STT1160.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1160");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1160");
    check_field_offset(lv, fb, 3, "STT1160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1160, STT1160)
//============================================================================


struct  STT1170  {
  short fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT1170) C1{ Fs Fi:3 Fc}



static void Test_STT1170()
{
  {
    init_simple_test("STT1170");
    static STRUCT_IF_C STT1170 lv;
    check2(sizeof(lv), 4, "sizeof(STT1170)");
    check2(__alignof__(lv), 4, "__alignof__(STT1170)");
    check_field_offset(lv, fa, 0, "STT1170.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1170");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1170");
    check_field_offset(lv, fb, 3, "STT1170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1170, STT1170)
//============================================================================


struct  STT1180  {
  short fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT1180) C1{ Fs FL:3 Fc}



static void Test_STT1180()
{
  {
    init_simple_test("STT1180");
    static STRUCT_IF_C STT1180 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1180)");
    check_field_offset(lv, fa, 0, "STT1180.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1180");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1180");
    check_field_offset(lv, fb, 3, "STT1180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1180, STT1180)
//============================================================================


struct  STT1190  {
  short fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT1190) C1{ Fs Fs:8 Fc}



static void Test_STT1190()
{
  {
    init_simple_test("STT1190");
    static STRUCT_IF_C STT1190 lv;
    check2(sizeof(lv), 4, "sizeof(STT1190)");
    check2(__alignof__(lv), 2, "__alignof__(STT1190)");
    check_field_offset(lv, fa, 0, "STT1190.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1190");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1190");
    check_field_offset(lv, fb, 3, "STT1190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1190, STT1190)
//============================================================================


struct  STT1200  {
  short fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT1200) C1{ Fs Fi:8 Fc}



static void Test_STT1200()
{
  {
    init_simple_test("STT1200");
    static STRUCT_IF_C STT1200 lv;
    check2(sizeof(lv), 4, "sizeof(STT1200)");
    check2(__alignof__(lv), 4, "__alignof__(STT1200)");
    check_field_offset(lv, fa, 0, "STT1200.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1200");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1200");
    check_field_offset(lv, fb, 3, "STT1200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1200, STT1200)
//============================================================================


struct  STT1210  {
  short fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT1210) C1{ Fs FL:8 Fc}



static void Test_STT1210()
{
  {
    init_simple_test("STT1210");
    static STRUCT_IF_C STT1210 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1210)");
    check_field_offset(lv, fa, 0, "STT1210.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1210");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1210");
    check_field_offset(lv, fb, 3, "STT1210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1210, STT1210)
//============================================================================


struct  STT1220  {
  short fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT1220) C1{ Fs Fi:18 Fc}



static void Test_STT1220()
{
  {
    init_simple_test("STT1220");
    static STRUCT_IF_C STT1220 lv;
    check2(sizeof(lv), 8, "sizeof(STT1220)");
    check2(__alignof__(lv), 4, "__alignof__(STT1220)");
    check_field_offset(lv, fa, 0, "STT1220.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1220");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1220");
    check_field_offset(lv, fb, 7, "STT1220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1220, STT1220)
//============================================================================


struct  STT1230  {
  short fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT1230) C1{ Fs FL:18 Fc}



static void Test_STT1230()
{
  {
    init_simple_test("STT1230");
    static STRUCT_IF_C STT1230 lv;
    check2(sizeof(lv), 8, "sizeof(STT1230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1230)");
    check_field_offset(lv, fa, 0, "STT1230.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1230");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1230");
    check_field_offset(lv, fb, 5, "STT1230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1230, STT1230)
//============================================================================


struct  STT1240  {
  short fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT1240) C1{ Fs FL:48 Fc}



static void Test_STT1240()
{
  {
    init_simple_test("STT1240");
    static STRUCT_IF_C STT1240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1240)");
    check_field_offset(lv, fa, 0, "STT1240.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1240");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1240");
    check_field_offset(lv, fb, 8, "STT1240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1240, STT1240)
//============================================================================


struct  STT111  {
  short fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT111) C1{ Fs Fc:0 Fs}



static void Test_STT111()
{
  {
    init_simple_test("STT111");
    static STRUCT_IF_C STT111 lv;
    check2(sizeof(lv), 4, "sizeof(STT111)");
    check2(__alignof__(lv), 2, "__alignof__(STT111)");
    check_field_offset(lv, fa, 0, "STT111.fa");
    check_field_offset(lv, fb, 2, "STT111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT111, STT111)
//============================================================================


struct  STT121  {
  short fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT121) C1{ Fs Fs:0 Fs}



static void Test_STT121()
{
  {
    init_simple_test("STT121");
    static STRUCT_IF_C STT121 lv;
    check2(sizeof(lv), 4, "sizeof(STT121)");
    check2(__alignof__(lv), 2, "__alignof__(STT121)");
    check_field_offset(lv, fa, 0, "STT121.fa");
    check_field_offset(lv, fb, 2, "STT121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT121, STT121)
//============================================================================


struct  STT131  {
  short fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT131) C1{ Fs Fi:0 Fs}



static void Test_STT131()
{
  {
    init_simple_test("STT131");
    static STRUCT_IF_C STT131 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT131)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT131)");
    check_field_offset(lv, fa, 0, "STT131.fa");
    check_field_offset(lv, fb, 4, "STT131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT131, STT131)
//============================================================================


struct  STT141  {
  short fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT141) C1{ Fs FL:0 Fs}



static void Test_STT141()
{
  {
    init_simple_test("STT141");
    static STRUCT_IF_C STT141 lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(STT141)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT141)");
    check_field_offset(lv, fa, 0, "STT141.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT141, STT141)
//============================================================================


struct  STT151  {
  short fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT151) C1{ Fs Fc:3 Fs}



static void Test_STT151()
{
  {
    init_simple_test("STT151");
    static STRUCT_IF_C STT151 lv;
    check2(sizeof(lv), 6, "sizeof(STT151)");
    check2(__alignof__(lv), 2, "__alignof__(STT151)");
    check_field_offset(lv, fa, 0, "STT151.fa");
    check_field_offset(lv, fb, 4, "STT151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT151, STT151)
//============================================================================


struct  STT161  {
  short fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT161) C1{ Fs Fs:3 Fs}



static void Test_STT161()
{
  {
    init_simple_test("STT161");
    static STRUCT_IF_C STT161 lv;
    check2(sizeof(lv), 6, "sizeof(STT161)");
    check2(__alignof__(lv), 2, "__alignof__(STT161)");
    check_field_offset(lv, fa, 0, "STT161.fa");
    check_field_offset(lv, fb, 4, "STT161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT161, STT161)
//============================================================================


struct  STT171  {
  short fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT171) C1{ Fs Fi:3 Fs}



static void Test_STT171()
{
  {
    init_simple_test("STT171");
    static STRUCT_IF_C STT171 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT171)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT171)");
    check_field_offset(lv, fa, 0, "STT171.fa");
    check_field_offset(lv, fb, 4, "STT171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT171, STT171)
//============================================================================


struct  STT181  {
  short fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT181) C1{ Fs FL:3 Fs}



static void Test_STT181()
{
  {
    init_simple_test("STT181");
    static STRUCT_IF_C STT181 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT181)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT181)");
    check_field_offset(lv, fa, 0, "STT181.fa");
    check_field_offset(lv, fb, 4, "STT181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT181, STT181)
//============================================================================


struct  STT191  {
  short fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT191) C1{ Fs Fs:8 Fs}



static void Test_STT191()
{
  {
    init_simple_test("STT191");
    static STRUCT_IF_C STT191 lv;
    check2(sizeof(lv), 6, "sizeof(STT191)");
    check2(__alignof__(lv), 2, "__alignof__(STT191)");
    check_field_offset(lv, fa, 0, "STT191.fa");
    check_field_offset(lv, fb, 4, "STT191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT191, STT191)
//============================================================================


struct  STT1101  {
  short fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT1101) C1{ Fs Fi:8 Fs}



static void Test_STT1101()
{
  {
    init_simple_test("STT1101");
    static STRUCT_IF_C STT1101 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1101)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1101)");
    check_field_offset(lv, fa, 0, "STT1101.fa");
    check_field_offset(lv, fb, 4, "STT1101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1101, STT1101)
//============================================================================


struct  STT1111  {
  short fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT1111) C1{ Fs FL:8 Fs}



static void Test_STT1111()
{
  {
    init_simple_test("STT1111");
    static STRUCT_IF_C STT1111 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1111)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1111)");
    check_field_offset(lv, fa, 0, "STT1111.fa");
    check_field_offset(lv, fb, 4, "STT1111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1111, STT1111)
//============================================================================


struct  STT1121  {
  short fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT1121) C1{ Fs Fi:18 Fs}



static void Test_STT1121()
{
  {
    init_simple_test("STT1121");
    static STRUCT_IF_C STT1121 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT1121)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1121)");
    check_field_offset(lv, fa, 0, "STT1121.fa");
    check_field_offset(lv, fb, 8, "STT1121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1121, STT1121)
//============================================================================


struct  STT1131  {
  short fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT1131) C1{ Fs FL:18 Fs}



static void Test_STT1131()
{
  {
    init_simple_test("STT1131");
    static STRUCT_IF_C STT1131 lv;
    check2(sizeof(lv), 8, "sizeof(STT1131)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1131)");
    check_field_offset(lv, fa, 0, "STT1131.fa");
    check_field_offset(lv, fb, 6, "STT1131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1131, STT1131)
//============================================================================


struct  STT1141  {
  short fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT1141) C1{ Fs FL:48 Fs}



static void Test_STT1141()
{
  {
    init_simple_test("STT1141");
    static STRUCT_IF_C STT1141 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT1141)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1141)");
    check_field_offset(lv, fa, 0, "STT1141.fa");
    check_field_offset(lv, fb, 8, "STT1141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1141, STT1141)
//============================================================================


struct  STT1151  {
  short fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT1151) C1{ Fs Fc:3 Fs}



static void Test_STT1151()
{
  {
    init_simple_test("STT1151");
    static STRUCT_IF_C STT1151 lv;
    check2(sizeof(lv), 6, "sizeof(STT1151)");
    check2(__alignof__(lv), 2, "__alignof__(STT1151)");
    check_field_offset(lv, fa, 0, "STT1151.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1151");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1151");
    check_field_offset(lv, fb, 4, "STT1151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1151, STT1151)
//============================================================================


struct  STT1161  {
  short fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT1161) C1{ Fs Fs:3 Fs}



static void Test_STT1161()
{
  {
    init_simple_test("STT1161");
    static STRUCT_IF_C STT1161 lv;
    check2(sizeof(lv), 6, "sizeof(STT1161)");
    check2(__alignof__(lv), 2, "__alignof__(STT1161)");
    check_field_offset(lv, fa, 0, "STT1161.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1161");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1161");
    check_field_offset(lv, fb, 4, "STT1161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1161, STT1161)
//============================================================================


struct  STT1171  {
  short fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT1171) C1{ Fs Fi:3 Fs}



static void Test_STT1171()
{
  {
    init_simple_test("STT1171");
    static STRUCT_IF_C STT1171 lv;
    check2(sizeof(lv), 8, "sizeof(STT1171)");
    check2(__alignof__(lv), 4, "__alignof__(STT1171)");
    check_field_offset(lv, fa, 0, "STT1171.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1171");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1171");
    check_field_offset(lv, fb, 4, "STT1171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1171, STT1171)
//============================================================================


struct  STT1181  {
  short fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT1181) C1{ Fs FL:3 Fs}



static void Test_STT1181()
{
  {
    init_simple_test("STT1181");
    static STRUCT_IF_C STT1181 lv;
    check2(sizeof(lv), 8, "sizeof(STT1181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1181)");
    check_field_offset(lv, fa, 0, "STT1181.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1181");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1181");
    check_field_offset(lv, fb, 4, "STT1181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1181, STT1181)
//============================================================================


struct  STT1191  {
  short fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT1191) C1{ Fs Fs:8 Fs}



static void Test_STT1191()
{
  {
    init_simple_test("STT1191");
    static STRUCT_IF_C STT1191 lv;
    check2(sizeof(lv), 6, "sizeof(STT1191)");
    check2(__alignof__(lv), 2, "__alignof__(STT1191)");
    check_field_offset(lv, fa, 0, "STT1191.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1191");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1191");
    check_field_offset(lv, fb, 4, "STT1191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1191, STT1191)
//============================================================================


struct  STT1201  {
  short fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT1201) C1{ Fs Fi:8 Fs}



static void Test_STT1201()
{
  {
    init_simple_test("STT1201");
    static STRUCT_IF_C STT1201 lv;
    check2(sizeof(lv), 8, "sizeof(STT1201)");
    check2(__alignof__(lv), 4, "__alignof__(STT1201)");
    check_field_offset(lv, fa, 0, "STT1201.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1201");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1201");
    check_field_offset(lv, fb, 4, "STT1201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1201, STT1201)
//============================================================================


struct  STT1211  {
  short fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT1211) C1{ Fs FL:8 Fs}



static void Test_STT1211()
{
  {
    init_simple_test("STT1211");
    static STRUCT_IF_C STT1211 lv;
    check2(sizeof(lv), 8, "sizeof(STT1211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1211)");
    check_field_offset(lv, fa, 0, "STT1211.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1211");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1211");
    check_field_offset(lv, fb, 4, "STT1211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1211, STT1211)
//============================================================================


struct  STT1221  {
  short fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT1221) C1{ Fs Fi:18 Fs}



static void Test_STT1221()
{
  {
    init_simple_test("STT1221");
    static STRUCT_IF_C STT1221 lv;
    check2(sizeof(lv), 12, "sizeof(STT1221)");
    check2(__alignof__(lv), 4, "__alignof__(STT1221)");
    check_field_offset(lv, fa, 0, "STT1221.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1221");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1221");
    check_field_offset(lv, fb, 8, "STT1221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1221, STT1221)
//============================================================================


struct  STT1231  {
  short fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT1231) C1{ Fs FL:18 Fs}



static void Test_STT1231()
{
  {
    init_simple_test("STT1231");
    static STRUCT_IF_C STT1231 lv;
    check2(sizeof(lv), 8, "sizeof(STT1231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1231)");
    check_field_offset(lv, fa, 0, "STT1231.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1231");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1231");
    check_field_offset(lv, fb, 6, "STT1231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1231, STT1231)
//============================================================================


struct  STT1241  {
  short fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT1241) C1{ Fs FL:48 Fs}



static void Test_STT1241()
{
  {
    init_simple_test("STT1241");
    static STRUCT_IF_C STT1241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1241)");
    check_field_offset(lv, fa, 0, "STT1241.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1241");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1241");
    check_field_offset(lv, fb, 8, "STT1241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1241, STT1241)
//============================================================================


struct  STT112  {
  short fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT112) C1{ Fs Fc:0 Fi}



static void Test_STT112()
{
  {
    init_simple_test("STT112");
    static STRUCT_IF_C STT112 lv;
    check2(sizeof(lv), 8, "sizeof(STT112)");
    check2(__alignof__(lv), 4, "__alignof__(STT112)");
    check_field_offset(lv, fa, 0, "STT112.fa");
    check_field_offset(lv, fb, 4, "STT112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT112, STT112)
//============================================================================


struct  STT122  {
  short fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT122) C1{ Fs Fs:0 Fi}



static void Test_STT122()
{
  {
    init_simple_test("STT122");
    static STRUCT_IF_C STT122 lv;
    check2(sizeof(lv), 8, "sizeof(STT122)");
    check2(__alignof__(lv), 4, "__alignof__(STT122)");
    check_field_offset(lv, fa, 0, "STT122.fa");
    check_field_offset(lv, fb, 4, "STT122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT122, STT122)
//============================================================================


struct  STT132  {
  short fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT132) C1{ Fs Fi:0 Fi}



static void Test_STT132()
{
  {
    init_simple_test("STT132");
    static STRUCT_IF_C STT132 lv;
    check2(sizeof(lv), 8, "sizeof(STT132)");
    check2(__alignof__(lv), 4, "__alignof__(STT132)");
    check_field_offset(lv, fa, 0, "STT132.fa");
    check_field_offset(lv, fb, 4, "STT132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT132, STT132)
//============================================================================


struct  STT142  {
  short fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT142) C1{ Fs FL:0 Fi}



static void Test_STT142()
{
  {
    init_simple_test("STT142");
    static STRUCT_IF_C STT142 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT142)");
    check_field_offset(lv, fa, 0, "STT142.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT142, STT142)
//============================================================================


struct  STT152  {
  short fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT152) C1{ Fs Fc:3 Fi}



static void Test_STT152()
{
  {
    init_simple_test("STT152");
    static STRUCT_IF_C STT152 lv;
    check2(sizeof(lv), 8, "sizeof(STT152)");
    check2(__alignof__(lv), 4, "__alignof__(STT152)");
    check_field_offset(lv, fa, 0, "STT152.fa");
    check_field_offset(lv, fb, 4, "STT152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT152, STT152)
//============================================================================


struct  STT162  {
  short fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT162) C1{ Fs Fs:3 Fi}



static void Test_STT162()
{
  {
    init_simple_test("STT162");
    static STRUCT_IF_C STT162 lv;
    check2(sizeof(lv), 8, "sizeof(STT162)");
    check2(__alignof__(lv), 4, "__alignof__(STT162)");
    check_field_offset(lv, fa, 0, "STT162.fa");
    check_field_offset(lv, fb, 4, "STT162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT162, STT162)
//============================================================================


struct  STT172  {
  short fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT172) C1{ Fs Fi:3 Fi}



static void Test_STT172()
{
  {
    init_simple_test("STT172");
    static STRUCT_IF_C STT172 lv;
    check2(sizeof(lv), 8, "sizeof(STT172)");
    check2(__alignof__(lv), 4, "__alignof__(STT172)");
    check_field_offset(lv, fa, 0, "STT172.fa");
    check_field_offset(lv, fb, 4, "STT172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT172, STT172)
//============================================================================


struct  STT182  {
  short fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT182) C1{ Fs FL:3 Fi}



static void Test_STT182()
{
  {
    init_simple_test("STT182");
    static STRUCT_IF_C STT182 lv;
    check2(sizeof(lv), 8, "sizeof(STT182)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT182)");
    check_field_offset(lv, fa, 0, "STT182.fa");
    check_field_offset(lv, fb, 4, "STT182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT182, STT182)
//============================================================================


struct  STT192  {
  short fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT192) C1{ Fs Fs:8 Fi}



static void Test_STT192()
{
  {
    init_simple_test("STT192");
    static STRUCT_IF_C STT192 lv;
    check2(sizeof(lv), 8, "sizeof(STT192)");
    check2(__alignof__(lv), 4, "__alignof__(STT192)");
    check_field_offset(lv, fa, 0, "STT192.fa");
    check_field_offset(lv, fb, 4, "STT192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT192, STT192)
//============================================================================


struct  STT1102  {
  short fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT1102) C1{ Fs Fi:8 Fi}



static void Test_STT1102()
{
  {
    init_simple_test("STT1102");
    static STRUCT_IF_C STT1102 lv;
    check2(sizeof(lv), 8, "sizeof(STT1102)");
    check2(__alignof__(lv), 4, "__alignof__(STT1102)");
    check_field_offset(lv, fa, 0, "STT1102.fa");
    check_field_offset(lv, fb, 4, "STT1102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1102, STT1102)
//============================================================================


struct  STT1112  {
  short fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT1112) C1{ Fs FL:8 Fi}



static void Test_STT1112()
{
  {
    init_simple_test("STT1112");
    static STRUCT_IF_C STT1112 lv;
    check2(sizeof(lv), 8, "sizeof(STT1112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1112)");
    check_field_offset(lv, fa, 0, "STT1112.fa");
    check_field_offset(lv, fb, 4, "STT1112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1112, STT1112)
//============================================================================


struct  STT1122  {
  short fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT1122) C1{ Fs Fi:18 Fi}



static void Test_STT1122()
{
  {
    init_simple_test("STT1122");
    static STRUCT_IF_C STT1122 lv;
    check2(sizeof(lv), 12, "sizeof(STT1122)");
    check2(__alignof__(lv), 4, "__alignof__(STT1122)");
    check_field_offset(lv, fa, 0, "STT1122.fa");
    check_field_offset(lv, fb, 8, "STT1122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1122, STT1122)
//============================================================================


struct  STT1132  {
  short fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT1132) C1{ Fs FL:18 Fi}



static void Test_STT1132()
{
  {
    init_simple_test("STT1132");
    static STRUCT_IF_C STT1132 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1132)");
    check_field_offset(lv, fa, 0, "STT1132.fa");
    check_field_offset(lv, fb, 8, "STT1132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1132, STT1132)
//============================================================================


struct  STT1142  {
  short fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT1142) C1{ Fs FL:48 Fi}



static void Test_STT1142()
{
  {
    init_simple_test("STT1142");
    static STRUCT_IF_C STT1142 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1142)");
    check_field_offset(lv, fa, 0, "STT1142.fa");
    check_field_offset(lv, fb, 8, "STT1142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1142, STT1142)
//============================================================================


struct  STT1152  {
  short fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT1152) C1{ Fs Fc:3 Fi}



static void Test_STT1152()
{
  {
    init_simple_test("STT1152");
    static STRUCT_IF_C STT1152 lv;
    check2(sizeof(lv), 8, "sizeof(STT1152)");
    check2(__alignof__(lv), 4, "__alignof__(STT1152)");
    check_field_offset(lv, fa, 0, "STT1152.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1152");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1152");
    check_field_offset(lv, fb, 4, "STT1152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1152, STT1152)
//============================================================================


struct  STT1162  {
  short fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT1162) C1{ Fs Fs:3 Fi}



static void Test_STT1162()
{
  {
    init_simple_test("STT1162");
    static STRUCT_IF_C STT1162 lv;
    check2(sizeof(lv), 8, "sizeof(STT1162)");
    check2(__alignof__(lv), 4, "__alignof__(STT1162)");
    check_field_offset(lv, fa, 0, "STT1162.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1162");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1162");
    check_field_offset(lv, fb, 4, "STT1162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1162, STT1162)
//============================================================================


struct  STT1172  {
  short fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT1172) C1{ Fs Fi:3 Fi}



static void Test_STT1172()
{
  {
    init_simple_test("STT1172");
    static STRUCT_IF_C STT1172 lv;
    check2(sizeof(lv), 8, "sizeof(STT1172)");
    check2(__alignof__(lv), 4, "__alignof__(STT1172)");
    check_field_offset(lv, fa, 0, "STT1172.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1172");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1172");
    check_field_offset(lv, fb, 4, "STT1172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1172, STT1172)
//============================================================================


struct  STT1182  {
  short fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT1182) C1{ Fs FL:3 Fi}



static void Test_STT1182()
{
  {
    init_simple_test("STT1182");
    static STRUCT_IF_C STT1182 lv;
    check2(sizeof(lv), 8, "sizeof(STT1182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1182)");
    check_field_offset(lv, fa, 0, "STT1182.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1182");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1182");
    check_field_offset(lv, fb, 4, "STT1182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1182, STT1182)
//============================================================================


struct  STT1192  {
  short fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT1192) C1{ Fs Fs:8 Fi}



static void Test_STT1192()
{
  {
    init_simple_test("STT1192");
    static STRUCT_IF_C STT1192 lv;
    check2(sizeof(lv), 8, "sizeof(STT1192)");
    check2(__alignof__(lv), 4, "__alignof__(STT1192)");
    check_field_offset(lv, fa, 0, "STT1192.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1192");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1192");
    check_field_offset(lv, fb, 4, "STT1192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1192, STT1192)
//============================================================================


struct  STT1202  {
  short fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT1202) C1{ Fs Fi:8 Fi}



static void Test_STT1202()
{
  {
    init_simple_test("STT1202");
    static STRUCT_IF_C STT1202 lv;
    check2(sizeof(lv), 8, "sizeof(STT1202)");
    check2(__alignof__(lv), 4, "__alignof__(STT1202)");
    check_field_offset(lv, fa, 0, "STT1202.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1202");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1202");
    check_field_offset(lv, fb, 4, "STT1202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1202, STT1202)
//============================================================================


struct  STT1212  {
  short fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT1212) C1{ Fs FL:8 Fi}



static void Test_STT1212()
{
  {
    init_simple_test("STT1212");
    static STRUCT_IF_C STT1212 lv;
    check2(sizeof(lv), 8, "sizeof(STT1212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1212)");
    check_field_offset(lv, fa, 0, "STT1212.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1212");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1212");
    check_field_offset(lv, fb, 4, "STT1212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1212, STT1212)
//============================================================================


struct  STT1222  {
  short fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT1222) C1{ Fs Fi:18 Fi}



static void Test_STT1222()
{
  {
    init_simple_test("STT1222");
    static STRUCT_IF_C STT1222 lv;
    check2(sizeof(lv), 12, "sizeof(STT1222)");
    check2(__alignof__(lv), 4, "__alignof__(STT1222)");
    check_field_offset(lv, fa, 0, "STT1222.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1222");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1222");
    check_field_offset(lv, fb, 8, "STT1222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1222, STT1222)
//============================================================================


struct  STT1232  {
  short fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT1232) C1{ Fs FL:18 Fi}



static void Test_STT1232()
{
  {
    init_simple_test("STT1232");
    static STRUCT_IF_C STT1232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1232)");
    check_field_offset(lv, fa, 0, "STT1232.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1232");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1232");
    check_field_offset(lv, fb, 8, "STT1232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1232, STT1232)
//============================================================================


struct  STT1242  {
  short fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT1242) C1{ Fs FL:48 Fi}



static void Test_STT1242()
{
  {
    init_simple_test("STT1242");
    static STRUCT_IF_C STT1242 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1242)");
    check_field_offset(lv, fa, 0, "STT1242.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1242");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1242");
    check_field_offset(lv, fb, 8, "STT1242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1242, STT1242)
//============================================================================


struct  STT113  {
  short fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT113) C1{ Fs Fc:0 Fl}



static void Test_STT113()
{
  {
    init_simple_test("STT113");
    static STRUCT_IF_C STT113 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT113)");
    check_field_offset(lv, fa, 0, "STT113.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT113, STT113)
//============================================================================


struct  STT123  {
  short fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT123) C1{ Fs Fs:0 Fl}



static void Test_STT123()
{
  {
    init_simple_test("STT123");
    static STRUCT_IF_C STT123 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT123)");
    check_field_offset(lv, fa, 0, "STT123.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT123, STT123)
//============================================================================


struct  STT133  {
  short fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT133) C1{ Fs Fi:0 Fl}



static void Test_STT133()
{
  {
    init_simple_test("STT133");
    static STRUCT_IF_C STT133 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT133)");
    check_field_offset(lv, fa, 0, "STT133.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT133, STT133)
//============================================================================


struct  STT143  {
  short fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT143) C1{ Fs FL:0 Fl}



static void Test_STT143()
{
  {
    init_simple_test("STT143");
    static STRUCT_IF_C STT143 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT143)");
    check_field_offset(lv, fa, 0, "STT143.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT143, STT143)
//============================================================================


struct  STT153  {
  short fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT153) C1{ Fs Fc:3 Fl}



static void Test_STT153()
{
  {
    init_simple_test("STT153");
    static STRUCT_IF_C STT153 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT153)");
    check_field_offset(lv, fa, 0, "STT153.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT153, STT153)
//============================================================================


struct  STT163  {
  short fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT163) C1{ Fs Fs:3 Fl}



static void Test_STT163()
{
  {
    init_simple_test("STT163");
    static STRUCT_IF_C STT163 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT163)");
    check_field_offset(lv, fa, 0, "STT163.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT163, STT163)
//============================================================================


struct  STT173  {
  short fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT173) C1{ Fs Fi:3 Fl}



static void Test_STT173()
{
  {
    init_simple_test("STT173");
    static STRUCT_IF_C STT173 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT173)");
    check_field_offset(lv, fa, 0, "STT173.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT173, STT173)
//============================================================================


struct  STT183  {
  short fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT183) C1{ Fs FL:3 Fl}



static void Test_STT183()
{
  {
    init_simple_test("STT183");
    static STRUCT_IF_C STT183 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT183)");
    check_field_offset(lv, fa, 0, "STT183.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT183, STT183)
//============================================================================


struct  STT193  {
  short fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT193) C1{ Fs Fs:8 Fl}



static void Test_STT193()
{
  {
    init_simple_test("STT193");
    static STRUCT_IF_C STT193 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT193)");
    check_field_offset(lv, fa, 0, "STT193.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT193, STT193)
//============================================================================


struct  STT1103  {
  short fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT1103) C1{ Fs Fi:8 Fl}



static void Test_STT1103()
{
  {
    init_simple_test("STT1103");
    static STRUCT_IF_C STT1103 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1103)");
    check_field_offset(lv, fa, 0, "STT1103.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1103, STT1103)
//============================================================================


struct  STT1113  {
  short fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT1113) C1{ Fs FL:8 Fl}



static void Test_STT1113()
{
  {
    init_simple_test("STT1113");
    static STRUCT_IF_C STT1113 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1113)");
    check_field_offset(lv, fa, 0, "STT1113.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1113, STT1113)
//============================================================================


struct  STT1123  {
  short fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT1123) C1{ Fs Fi:18 Fl}



static void Test_STT1123()
{
  {
    init_simple_test("STT1123");
    static STRUCT_IF_C STT1123 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1123)");
    check_field_offset(lv, fa, 0, "STT1123.fa");
    check_field_offset(lv, fb, 8, "STT1123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1123, STT1123)
//============================================================================


struct  STT1133  {
  short fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT1133) C1{ Fs FL:18 Fl}



static void Test_STT1133()
{
  {
    init_simple_test("STT1133");
    static STRUCT_IF_C STT1133 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1133)");
    check_field_offset(lv, fa, 0, "STT1133.fa");
    check_field_offset(lv, fb, 8, "STT1133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1133, STT1133)
//============================================================================


struct  STT1143  {
  short fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT1143) C1{ Fs FL:48 Fl}



static void Test_STT1143()
{
  {
    init_simple_test("STT1143");
    static STRUCT_IF_C STT1143 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1143)");
    check_field_offset(lv, fa, 0, "STT1143.fa");
    check_field_offset(lv, fb, 8, "STT1143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1143, STT1143)
//============================================================================


struct  STT1153  {
  short fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT1153) C1{ Fs Fc:3 Fl}



static void Test_STT1153()
{
  {
    init_simple_test("STT1153");
    static STRUCT_IF_C STT1153 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1153)");
    check_field_offset(lv, fa, 0, "STT1153.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1153");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1153");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1153, STT1153)
//============================================================================


struct  STT1163  {
  short fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT1163) C1{ Fs Fs:3 Fl}



static void Test_STT1163()
{
  {
    init_simple_test("STT1163");
    static STRUCT_IF_C STT1163 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1163)");
    check_field_offset(lv, fa, 0, "STT1163.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1163");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1163");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1163, STT1163)
//============================================================================


struct  STT1173  {
  short fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT1173) C1{ Fs Fi:3 Fl}



static void Test_STT1173()
{
  {
    init_simple_test("STT1173");
    static STRUCT_IF_C STT1173 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1173)");
    check_field_offset(lv, fa, 0, "STT1173.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1173");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1173");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1173, STT1173)
//============================================================================


struct  STT1183  {
  short fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT1183) C1{ Fs FL:3 Fl}



static void Test_STT1183()
{
  {
    init_simple_test("STT1183");
    static STRUCT_IF_C STT1183 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1183)");
    check_field_offset(lv, fa, 0, "STT1183.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1183");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1183");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1183, STT1183)
//============================================================================


struct  STT1193  {
  short fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT1193) C1{ Fs Fs:8 Fl}



static void Test_STT1193()
{
  {
    init_simple_test("STT1193");
    static STRUCT_IF_C STT1193 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1193)");
    check_field_offset(lv, fa, 0, "STT1193.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1193");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1193");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1193, STT1193)
//============================================================================


struct  STT1203  {
  short fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT1203) C1{ Fs Fi:8 Fl}



static void Test_STT1203()
{
  {
    init_simple_test("STT1203");
    static STRUCT_IF_C STT1203 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1203)");
    check_field_offset(lv, fa, 0, "STT1203.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1203");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1203");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1203, STT1203)
//============================================================================


struct  STT1213  {
  short fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT1213) C1{ Fs FL:8 Fl}



static void Test_STT1213()
{
  {
    init_simple_test("STT1213");
    static STRUCT_IF_C STT1213 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1213)");
    check_field_offset(lv, fa, 0, "STT1213.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1213");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1213");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1213, STT1213)
//============================================================================


struct  STT1223  {
  short fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT1223) C1{ Fs Fi:18 Fl}



static void Test_STT1223()
{
  {
    init_simple_test("STT1223");
    static STRUCT_IF_C STT1223 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1223)");
    check_field_offset(lv, fa, 0, "STT1223.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1223");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1223");
    check_field_offset(lv, fb, 8, "STT1223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1223, STT1223)
//============================================================================


struct  STT1233  {
  short fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT1233) C1{ Fs FL:18 Fl}



static void Test_STT1233()
{
  {
    init_simple_test("STT1233");
    static STRUCT_IF_C STT1233 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1233)");
    check_field_offset(lv, fa, 0, "STT1233.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1233");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1233");
    check_field_offset(lv, fb, 8, "STT1233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1233, STT1233)
//============================================================================


struct  STT1243  {
  short fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT1243) C1{ Fs FL:48 Fl}



static void Test_STT1243()
{
  {
    init_simple_test("STT1243");
    static STRUCT_IF_C STT1243 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1243)");
    check_field_offset(lv, fa, 0, "STT1243.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1243");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1243");
    check_field_offset(lv, fb, 8, "STT1243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1243, STT1243)
//============================================================================


struct  STT114  {
  short fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT114) C1{ Fs Fc:0 FL}



static void Test_STT114()
{
  {
    init_simple_test("STT114");
    static STRUCT_IF_C STT114 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT114)");
    check_field_offset(lv, fa, 0, "STT114.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT114, STT114)
//============================================================================


struct  STT124  {
  short fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT124) C1{ Fs Fs:0 FL}



static void Test_STT124()
{
  {
    init_simple_test("STT124");
    static STRUCT_IF_C STT124 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT124)");
    check_field_offset(lv, fa, 0, "STT124.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT124, STT124)
//============================================================================


struct  STT134  {
  short fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT134) C1{ Fs Fi:0 FL}



static void Test_STT134()
{
  {
    init_simple_test("STT134");
    static STRUCT_IF_C STT134 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT134)");
    check_field_offset(lv, fa, 0, "STT134.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT134, STT134)
//============================================================================


struct  STT144  {
  short fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT144) C1{ Fs FL:0 FL}



static void Test_STT144()
{
  {
    init_simple_test("STT144");
    static STRUCT_IF_C STT144 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT144)");
    check_field_offset(lv, fa, 0, "STT144.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT144, STT144)
//============================================================================


struct  STT154  {
  short fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT154) C1{ Fs Fc:3 FL}



static void Test_STT154()
{
  {
    init_simple_test("STT154");
    static STRUCT_IF_C STT154 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT154)");
    check_field_offset(lv, fa, 0, "STT154.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT154, STT154)
//============================================================================


struct  STT164  {
  short fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT164) C1{ Fs Fs:3 FL}



static void Test_STT164()
{
  {
    init_simple_test("STT164");
    static STRUCT_IF_C STT164 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT164)");
    check_field_offset(lv, fa, 0, "STT164.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT164, STT164)
//============================================================================


struct  STT174  {
  short fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT174) C1{ Fs Fi:3 FL}



static void Test_STT174()
{
  {
    init_simple_test("STT174");
    static STRUCT_IF_C STT174 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT174)");
    check_field_offset(lv, fa, 0, "STT174.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT174, STT174)
//============================================================================


struct  STT184  {
  short fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT184) C1{ Fs FL:3 FL}



static void Test_STT184()
{
  {
    init_simple_test("STT184");
    static STRUCT_IF_C STT184 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT184)");
    check_field_offset(lv, fa, 0, "STT184.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT184, STT184)
//============================================================================


struct  STT194  {
  short fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT194) C1{ Fs Fs:8 FL}



static void Test_STT194()
{
  {
    init_simple_test("STT194");
    static STRUCT_IF_C STT194 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT194)");
    check_field_offset(lv, fa, 0, "STT194.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT194, STT194)
//============================================================================


struct  STT1104  {
  short fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT1104) C1{ Fs Fi:8 FL}



static void Test_STT1104()
{
  {
    init_simple_test("STT1104");
    static STRUCT_IF_C STT1104 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1104)");
    check_field_offset(lv, fa, 0, "STT1104.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1104, STT1104)
//============================================================================


struct  STT1114  {
  short fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT1114) C1{ Fs FL:8 FL}



static void Test_STT1114()
{
  {
    init_simple_test("STT1114");
    static STRUCT_IF_C STT1114 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1114)");
    check_field_offset(lv, fa, 0, "STT1114.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1114, STT1114)
//============================================================================


struct  STT1124  {
  short fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT1124) C1{ Fs Fi:18 FL}



static void Test_STT1124()
{
  {
    init_simple_test("STT1124");
    static STRUCT_IF_C STT1124 lv;
    check2(sizeof(lv), 16, "sizeof(STT1124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1124)");
    check_field_offset(lv, fa, 0, "STT1124.fa");
    check_field_offset(lv, fb, 8, "STT1124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1124, STT1124)
//============================================================================


struct  STT1134  {
  short fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT1134) C1{ Fs FL:18 FL}



static void Test_STT1134()
{
  {
    init_simple_test("STT1134");
    static STRUCT_IF_C STT1134 lv;
    check2(sizeof(lv), 16, "sizeof(STT1134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1134)");
    check_field_offset(lv, fa, 0, "STT1134.fa");
    check_field_offset(lv, fb, 8, "STT1134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1134, STT1134)
//============================================================================


struct  STT1144  {
  short fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT1144) C1{ Fs FL:48 FL}



static void Test_STT1144()
{
  {
    init_simple_test("STT1144");
    static STRUCT_IF_C STT1144 lv;
    check2(sizeof(lv), 16, "sizeof(STT1144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1144)");
    check_field_offset(lv, fa, 0, "STT1144.fa");
    check_field_offset(lv, fb, 8, "STT1144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1144, STT1144)
//============================================================================


struct  STT1154  {
  short fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT1154) C1{ Fs Fc:3 FL}



static void Test_STT1154()
{
  {
    init_simple_test("STT1154");
    static STRUCT_IF_C STT1154 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1154)");
    check_field_offset(lv, fa, 0, "STT1154.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1154");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1154");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1154, STT1154)
//============================================================================


struct  STT1164  {
  short fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT1164) C1{ Fs Fs:3 FL}



static void Test_STT1164()
{
  {
    init_simple_test("STT1164");
    static STRUCT_IF_C STT1164 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1164)");
    check_field_offset(lv, fa, 0, "STT1164.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1164");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1164");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1164, STT1164)
//============================================================================


struct  STT1174  {
  short fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT1174) C1{ Fs Fi:3 FL}



static void Test_STT1174()
{
  {
    init_simple_test("STT1174");
    static STRUCT_IF_C STT1174 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1174)");
    check_field_offset(lv, fa, 0, "STT1174.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1174");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1174");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1174, STT1174)
//============================================================================


struct  STT1184  {
  short fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT1184) C1{ Fs FL:3 FL}



static void Test_STT1184()
{
  {
    init_simple_test("STT1184");
    static STRUCT_IF_C STT1184 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1184)");
    check_field_offset(lv, fa, 0, "STT1184.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1184");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1184");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1184, STT1184)
//============================================================================


struct  STT1194  {
  short fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT1194) C1{ Fs Fs:8 FL}



static void Test_STT1194()
{
  {
    init_simple_test("STT1194");
    static STRUCT_IF_C STT1194 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1194)");
    check_field_offset(lv, fa, 0, "STT1194.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1194");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1194");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1194, STT1194)
//============================================================================


struct  STT1204  {
  short fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT1204) C1{ Fs Fi:8 FL}



static void Test_STT1204()
{
  {
    init_simple_test("STT1204");
    static STRUCT_IF_C STT1204 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1204)");
    check_field_offset(lv, fa, 0, "STT1204.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1204");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1204");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1204, STT1204)
//============================================================================


struct  STT1214  {
  short fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT1214) C1{ Fs FL:8 FL}



static void Test_STT1214()
{
  {
    init_simple_test("STT1214");
    static STRUCT_IF_C STT1214 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1214)");
    check_field_offset(lv, fa, 0, "STT1214.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1214");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1214");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1214, STT1214)
//============================================================================


struct  STT1224  {
  short fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT1224) C1{ Fs Fi:18 FL}



static void Test_STT1224()
{
  {
    init_simple_test("STT1224");
    static STRUCT_IF_C STT1224 lv;
    check2(sizeof(lv), 16, "sizeof(STT1224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1224)");
    check_field_offset(lv, fa, 0, "STT1224.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1224");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1224");
    check_field_offset(lv, fb, 8, "STT1224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1224, STT1224)
//============================================================================


struct  STT1234  {
  short fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT1234) C1{ Fs FL:18 FL}



static void Test_STT1234()
{
  {
    init_simple_test("STT1234");
    static STRUCT_IF_C STT1234 lv;
    check2(sizeof(lv), 16, "sizeof(STT1234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1234)");
    check_field_offset(lv, fa, 0, "STT1234.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1234");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1234");
    check_field_offset(lv, fb, 8, "STT1234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1234, STT1234)
//============================================================================


struct  STT1244  {
  short fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT1244) C1{ Fs FL:48 FL}



static void Test_STT1244()
{
  {
    init_simple_test("STT1244");
    static STRUCT_IF_C STT1244 lv;
    check2(sizeof(lv), 16, "sizeof(STT1244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1244)");
    check_field_offset(lv, fa, 0, "STT1244.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1244");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1244");
    check_field_offset(lv, fb, 8, "STT1244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1244, STT1244)
//============================================================================


struct  STT115  {
  short fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT115) C1{ Fs Fc:0 Fp}



static void Test_STT115()
{
  {
    init_simple_test("STT115");
    static STRUCT_IF_C STT115 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT115)");
    check_field_offset(lv, fa, 0, "STT115.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT115, STT115)
//============================================================================


struct  STT125  {
  short fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT125) C1{ Fs Fs:0 Fp}



static void Test_STT125()
{
  {
    init_simple_test("STT125");
    static STRUCT_IF_C STT125 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT125)");
    check_field_offset(lv, fa, 0, "STT125.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT125, STT125)
//============================================================================


struct  STT135  {
  short fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT135) C1{ Fs Fi:0 Fp}



static void Test_STT135()
{
  {
    init_simple_test("STT135");
    static STRUCT_IF_C STT135 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT135)");
    check_field_offset(lv, fa, 0, "STT135.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT135, STT135)
//============================================================================


struct  STT145  {
  short fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT145) C1{ Fs FL:0 Fp}



static void Test_STT145()
{
  {
    init_simple_test("STT145");
    static STRUCT_IF_C STT145 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT145)");
    check_field_offset(lv, fa, 0, "STT145.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT145, STT145)
//============================================================================


struct  STT155  {
  short fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT155) C1{ Fs Fc:3 Fp}



static void Test_STT155()
{
  {
    init_simple_test("STT155");
    static STRUCT_IF_C STT155 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT155)");
    check_field_offset(lv, fa, 0, "STT155.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT155, STT155)
//============================================================================


struct  STT165  {
  short fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT165) C1{ Fs Fs:3 Fp}



static void Test_STT165()
{
  {
    init_simple_test("STT165");
    static STRUCT_IF_C STT165 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT165)");
    check_field_offset(lv, fa, 0, "STT165.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT165, STT165)
//============================================================================


struct  STT175  {
  short fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT175) C1{ Fs Fi:3 Fp}



static void Test_STT175()
{
  {
    init_simple_test("STT175");
    static STRUCT_IF_C STT175 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT175)");
    check_field_offset(lv, fa, 0, "STT175.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT175, STT175)
//============================================================================


struct  STT185  {
  short fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT185) C1{ Fs FL:3 Fp}



static void Test_STT185()
{
  {
    init_simple_test("STT185");
    static STRUCT_IF_C STT185 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT185)");
    check_field_offset(lv, fa, 0, "STT185.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT185, STT185)
//============================================================================


struct  STT195  {
  short fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT195) C1{ Fs Fs:8 Fp}



static void Test_STT195()
{
  {
    init_simple_test("STT195");
    static STRUCT_IF_C STT195 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT195)");
    check_field_offset(lv, fa, 0, "STT195.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT195, STT195)
//============================================================================


struct  STT1105  {
  short fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT1105) C1{ Fs Fi:8 Fp}



static void Test_STT1105()
{
  {
    init_simple_test("STT1105");
    static STRUCT_IF_C STT1105 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1105)");
    check_field_offset(lv, fa, 0, "STT1105.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1105, STT1105)
//============================================================================


struct  STT1115  {
  short fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT1115) C1{ Fs FL:8 Fp}



static void Test_STT1115()
{
  {
    init_simple_test("STT1115");
    static STRUCT_IF_C STT1115 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1115)");
    check_field_offset(lv, fa, 0, "STT1115.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1115, STT1115)
//============================================================================


struct  STT1125  {
  short fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT1125) C1{ Fs Fi:18 Fp}



static void Test_STT1125()
{
  {
    init_simple_test("STT1125");
    static STRUCT_IF_C STT1125 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1125)");
    check_field_offset(lv, fa, 0, "STT1125.fa");
    check_field_offset(lv, fb, 8, "STT1125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1125, STT1125)
//============================================================================


struct  STT1135  {
  short fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT1135) C1{ Fs FL:18 Fp}



static void Test_STT1135()
{
  {
    init_simple_test("STT1135");
    static STRUCT_IF_C STT1135 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1135)");
    check_field_offset(lv, fa, 0, "STT1135.fa");
    check_field_offset(lv, fb, 8, "STT1135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1135, STT1135)
//============================================================================


struct  STT1145  {
  short fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT1145) C1{ Fs FL:48 Fp}



static void Test_STT1145()
{
  {
    init_simple_test("STT1145");
    static STRUCT_IF_C STT1145 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1145)");
    check_field_offset(lv, fa, 0, "STT1145.fa");
    check_field_offset(lv, fb, 8, "STT1145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1145, STT1145)
//============================================================================


struct  STT1155  {
  short fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT1155) C1{ Fs Fc:3 Fp}



static void Test_STT1155()
{
  {
    init_simple_test("STT1155");
    static STRUCT_IF_C STT1155 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1155)");
    check_field_offset(lv, fa, 0, "STT1155.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1155");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1155");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1155, STT1155)
//============================================================================


struct  STT1165  {
  short fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT1165) C1{ Fs Fs:3 Fp}



static void Test_STT1165()
{
  {
    init_simple_test("STT1165");
    static STRUCT_IF_C STT1165 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1165)");
    check_field_offset(lv, fa, 0, "STT1165.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1165");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1165");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1165, STT1165)
//============================================================================


struct  STT1175  {
  short fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT1175) C1{ Fs Fi:3 Fp}



static void Test_STT1175()
{
  {
    init_simple_test("STT1175");
    static STRUCT_IF_C STT1175 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1175)");
    check_field_offset(lv, fa, 0, "STT1175.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1175");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1175");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1175, STT1175)
//============================================================================


struct  STT1185  {
  short fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT1185) C1{ Fs FL:3 Fp}



static void Test_STT1185()
{
  {
    init_simple_test("STT1185");
    static STRUCT_IF_C STT1185 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1185)");
    check_field_offset(lv, fa, 0, "STT1185.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1185");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1185");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1185, STT1185)
//============================================================================


struct  STT1195  {
  short fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT1195) C1{ Fs Fs:8 Fp}



static void Test_STT1195()
{
  {
    init_simple_test("STT1195");
    static STRUCT_IF_C STT1195 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1195)");
    check_field_offset(lv, fa, 0, "STT1195.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1195");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1195");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1195, STT1195)
//============================================================================


struct  STT1205  {
  short fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT1205) C1{ Fs Fi:8 Fp}



static void Test_STT1205()
{
  {
    init_simple_test("STT1205");
    static STRUCT_IF_C STT1205 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1205)");
    check_field_offset(lv, fa, 0, "STT1205.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1205");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1205");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1205, STT1205)
//============================================================================


struct  STT1215  {
  short fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT1215) C1{ Fs FL:8 Fp}



static void Test_STT1215()
{
  {
    init_simple_test("STT1215");
    static STRUCT_IF_C STT1215 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1215)");
    check_field_offset(lv, fa, 0, "STT1215.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1215");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1215");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1215, STT1215)
//============================================================================


struct  STT1225  {
  short fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT1225) C1{ Fs Fi:18 Fp}



static void Test_STT1225()
{
  {
    init_simple_test("STT1225");
    static STRUCT_IF_C STT1225 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1225)");
    check_field_offset(lv, fa, 0, "STT1225.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1225");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1225");
    check_field_offset(lv, fb, 8, "STT1225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1225, STT1225)
//============================================================================


struct  STT1235  {
  short fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT1235) C1{ Fs FL:18 Fp}



static void Test_STT1235()
{
  {
    init_simple_test("STT1235");
    static STRUCT_IF_C STT1235 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1235)");
    check_field_offset(lv, fa, 0, "STT1235.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1235");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1235");
    check_field_offset(lv, fb, 8, "STT1235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1235, STT1235)
//============================================================================


struct  STT1245  {
  short fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT1245) C1{ Fs FL:48 Fp}



static void Test_STT1245()
{
  {
    init_simple_test("STT1245");
    static STRUCT_IF_C STT1245 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1245)");
    check_field_offset(lv, fa, 0, "STT1245.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1245");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1245");
    check_field_offset(lv, fb, 8, "STT1245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1245, STT1245)
//============================================================================


struct  STT116  {
  short fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT116) C1{ Fs Fc:0 Fi}



static void Test_STT116()
{
  {
    init_simple_test("STT116");
    static STRUCT_IF_C STT116 lv;
    check2(sizeof(lv), 8, "sizeof(STT116)");
    check2(__alignof__(lv), 4, "__alignof__(STT116)");
    check_field_offset(lv, fa, 0, "STT116.fa");
    check_field_offset(lv, fb, 4, "STT116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT116, STT116)
//============================================================================


struct  STT126  {
  short fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT126) C1{ Fs Fs:0 Fi}



static void Test_STT126()
{
  {
    init_simple_test("STT126");
    static STRUCT_IF_C STT126 lv;
    check2(sizeof(lv), 8, "sizeof(STT126)");
    check2(__alignof__(lv), 4, "__alignof__(STT126)");
    check_field_offset(lv, fa, 0, "STT126.fa");
    check_field_offset(lv, fb, 4, "STT126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT126, STT126)
//============================================================================


struct  STT136  {
  short fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT136) C1{ Fs Fi:0 Fi}



static void Test_STT136()
{
  {
    init_simple_test("STT136");
    static STRUCT_IF_C STT136 lv;
    check2(sizeof(lv), 8, "sizeof(STT136)");
    check2(__alignof__(lv), 4, "__alignof__(STT136)");
    check_field_offset(lv, fa, 0, "STT136.fa");
    check_field_offset(lv, fb, 4, "STT136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT136, STT136)
//============================================================================


struct  STT146  {
  short fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT146) C1{ Fs FL:0 Fi}



static void Test_STT146()
{
  {
    init_simple_test("STT146");
    static STRUCT_IF_C STT146 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT146)");
    check_field_offset(lv, fa, 0, "STT146.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT146, STT146)
//============================================================================


struct  STT156  {
  short fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT156) C1{ Fs Fc:3 Fi}



static void Test_STT156()
{
  {
    init_simple_test("STT156");
    static STRUCT_IF_C STT156 lv;
    check2(sizeof(lv), 8, "sizeof(STT156)");
    check2(__alignof__(lv), 4, "__alignof__(STT156)");
    check_field_offset(lv, fa, 0, "STT156.fa");
    check_field_offset(lv, fb, 4, "STT156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT156, STT156)
//============================================================================


struct  STT166  {
  short fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT166) C1{ Fs Fs:3 Fi}



static void Test_STT166()
{
  {
    init_simple_test("STT166");
    static STRUCT_IF_C STT166 lv;
    check2(sizeof(lv), 8, "sizeof(STT166)");
    check2(__alignof__(lv), 4, "__alignof__(STT166)");
    check_field_offset(lv, fa, 0, "STT166.fa");
    check_field_offset(lv, fb, 4, "STT166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT166, STT166)
//============================================================================


struct  STT176  {
  short fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT176) C1{ Fs Fi:3 Fi}



static void Test_STT176()
{
  {
    init_simple_test("STT176");
    static STRUCT_IF_C STT176 lv;
    check2(sizeof(lv), 8, "sizeof(STT176)");
    check2(__alignof__(lv), 4, "__alignof__(STT176)");
    check_field_offset(lv, fa, 0, "STT176.fa");
    check_field_offset(lv, fb, 4, "STT176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT176, STT176)
//============================================================================


struct  STT186  {
  short fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT186) C1{ Fs FL:3 Fi}



static void Test_STT186()
{
  {
    init_simple_test("STT186");
    static STRUCT_IF_C STT186 lv;
    check2(sizeof(lv), 8, "sizeof(STT186)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT186)");
    check_field_offset(lv, fa, 0, "STT186.fa");
    check_field_offset(lv, fb, 4, "STT186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT186, STT186)
//============================================================================


struct  STT196  {
  short fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT196) C1{ Fs Fs:8 Fi}



static void Test_STT196()
{
  {
    init_simple_test("STT196");
    static STRUCT_IF_C STT196 lv;
    check2(sizeof(lv), 8, "sizeof(STT196)");
    check2(__alignof__(lv), 4, "__alignof__(STT196)");
    check_field_offset(lv, fa, 0, "STT196.fa");
    check_field_offset(lv, fb, 4, "STT196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT196, STT196)
//============================================================================


struct  STT1106  {
  short fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT1106) C1{ Fs Fi:8 Fi}



static void Test_STT1106()
{
  {
    init_simple_test("STT1106");
    static STRUCT_IF_C STT1106 lv;
    check2(sizeof(lv), 8, "sizeof(STT1106)");
    check2(__alignof__(lv), 4, "__alignof__(STT1106)");
    check_field_offset(lv, fa, 0, "STT1106.fa");
    check_field_offset(lv, fb, 4, "STT1106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1106, STT1106)
//============================================================================


struct  STT1116  {
  short fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT1116) C1{ Fs FL:8 Fi}



static void Test_STT1116()
{
  {
    init_simple_test("STT1116");
    static STRUCT_IF_C STT1116 lv;
    check2(sizeof(lv), 8, "sizeof(STT1116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1116)");
    check_field_offset(lv, fa, 0, "STT1116.fa");
    check_field_offset(lv, fb, 4, "STT1116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1116, STT1116)
//============================================================================


struct  STT1126  {
  short fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT1126) C1{ Fs Fi:18 Fi}



static void Test_STT1126()
{
  {
    init_simple_test("STT1126");
    static STRUCT_IF_C STT1126 lv;
    check2(sizeof(lv), 12, "sizeof(STT1126)");
    check2(__alignof__(lv), 4, "__alignof__(STT1126)");
    check_field_offset(lv, fa, 0, "STT1126.fa");
    check_field_offset(lv, fb, 8, "STT1126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1126, STT1126)
//============================================================================


struct  STT1136  {
  short fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT1136) C1{ Fs FL:18 Fi}



static void Test_STT1136()
{
  {
    init_simple_test("STT1136");
    static STRUCT_IF_C STT1136 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1136)");
    check_field_offset(lv, fa, 0, "STT1136.fa");
    check_field_offset(lv, fb, 8, "STT1136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1136, STT1136)
//============================================================================


struct  STT1146  {
  short fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT1146) C1{ Fs FL:48 Fi}



static void Test_STT1146()
{
  {
    init_simple_test("STT1146");
    static STRUCT_IF_C STT1146 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1146)");
    check_field_offset(lv, fa, 0, "STT1146.fa");
    check_field_offset(lv, fb, 8, "STT1146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1146, STT1146)
//============================================================================


struct  STT1156  {
  short fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT1156) C1{ Fs Fc:3 Fi}



static void Test_STT1156()
{
  {
    init_simple_test("STT1156");
    static STRUCT_IF_C STT1156 lv;
    check2(sizeof(lv), 8, "sizeof(STT1156)");
    check2(__alignof__(lv), 4, "__alignof__(STT1156)");
    check_field_offset(lv, fa, 0, "STT1156.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1156");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1156");
    check_field_offset(lv, fb, 4, "STT1156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1156, STT1156)
//============================================================================


struct  STT1166  {
  short fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT1166) C1{ Fs Fs:3 Fi}



static void Test_STT1166()
{
  {
    init_simple_test("STT1166");
    static STRUCT_IF_C STT1166 lv;
    check2(sizeof(lv), 8, "sizeof(STT1166)");
    check2(__alignof__(lv), 4, "__alignof__(STT1166)");
    check_field_offset(lv, fa, 0, "STT1166.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1166");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1166");
    check_field_offset(lv, fb, 4, "STT1166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1166, STT1166)
//============================================================================


struct  STT1176  {
  short fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT1176) C1{ Fs Fi:3 Fi}



static void Test_STT1176()
{
  {
    init_simple_test("STT1176");
    static STRUCT_IF_C STT1176 lv;
    check2(sizeof(lv), 8, "sizeof(STT1176)");
    check2(__alignof__(lv), 4, "__alignof__(STT1176)");
    check_field_offset(lv, fa, 0, "STT1176.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1176");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1176");
    check_field_offset(lv, fb, 4, "STT1176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1176, STT1176)
//============================================================================


struct  STT1186  {
  short fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT1186) C1{ Fs FL:3 Fi}



static void Test_STT1186()
{
  {
    init_simple_test("STT1186");
    static STRUCT_IF_C STT1186 lv;
    check2(sizeof(lv), 8, "sizeof(STT1186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1186)");
    check_field_offset(lv, fa, 0, "STT1186.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1186");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1186");
    check_field_offset(lv, fb, 4, "STT1186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1186, STT1186)
//============================================================================


struct  STT1196  {
  short fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT1196) C1{ Fs Fs:8 Fi}



static void Test_STT1196()
{
  {
    init_simple_test("STT1196");
    static STRUCT_IF_C STT1196 lv;
    check2(sizeof(lv), 8, "sizeof(STT1196)");
    check2(__alignof__(lv), 4, "__alignof__(STT1196)");
    check_field_offset(lv, fa, 0, "STT1196.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1196");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1196");
    check_field_offset(lv, fb, 4, "STT1196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1196, STT1196)
//============================================================================


struct  STT1206  {
  short fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT1206) C1{ Fs Fi:8 Fi}



static void Test_STT1206()
{
  {
    init_simple_test("STT1206");
    static STRUCT_IF_C STT1206 lv;
    check2(sizeof(lv), 8, "sizeof(STT1206)");
    check2(__alignof__(lv), 4, "__alignof__(STT1206)");
    check_field_offset(lv, fa, 0, "STT1206.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1206");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1206");
    check_field_offset(lv, fb, 4, "STT1206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1206, STT1206)
//============================================================================


struct  STT1216  {
  short fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT1216) C1{ Fs FL:8 Fi}



static void Test_STT1216()
{
  {
    init_simple_test("STT1216");
    static STRUCT_IF_C STT1216 lv;
    check2(sizeof(lv), 8, "sizeof(STT1216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1216)");
    check_field_offset(lv, fa, 0, "STT1216.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1216");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1216");
    check_field_offset(lv, fb, 4, "STT1216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1216, STT1216)
//============================================================================


struct  STT1226  {
  short fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT1226) C1{ Fs Fi:18 Fi}



static void Test_STT1226()
{
  {
    init_simple_test("STT1226");
    static STRUCT_IF_C STT1226 lv;
    check2(sizeof(lv), 12, "sizeof(STT1226)");
    check2(__alignof__(lv), 4, "__alignof__(STT1226)");
    check_field_offset(lv, fa, 0, "STT1226.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1226");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1226");
    check_field_offset(lv, fb, 8, "STT1226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1226, STT1226)
//============================================================================


struct  STT1236  {
  short fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT1236) C1{ Fs FL:18 Fi}



static void Test_STT1236()
{
  {
    init_simple_test("STT1236");
    static STRUCT_IF_C STT1236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1236)");
    check_field_offset(lv, fa, 0, "STT1236.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1236");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1236");
    check_field_offset(lv, fb, 8, "STT1236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1236, STT1236)
//============================================================================


struct  STT1246  {
  short fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT1246) C1{ Fs FL:48 Fi}



static void Test_STT1246()
{
  {
    init_simple_test("STT1246");
    static STRUCT_IF_C STT1246 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1246)");
    check_field_offset(lv, fa, 0, "STT1246.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1246");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1246");
    check_field_offset(lv, fb, 8, "STT1246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1246, STT1246)
//============================================================================


struct  STT117  {
  short fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT117) C1{ Fs Fc:0 FL}



static void Test_STT117()
{
  {
    init_simple_test("STT117");
    static STRUCT_IF_C STT117 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT117)");
    check_field_offset(lv, fa, 0, "STT117.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT117, STT117)
//============================================================================


struct  STT127  {
  short fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT127) C1{ Fs Fs:0 FL}



static void Test_STT127()
{
  {
    init_simple_test("STT127");
    static STRUCT_IF_C STT127 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT127)");
    check_field_offset(lv, fa, 0, "STT127.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT127, STT127)
//============================================================================


struct  STT137  {
  short fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT137) C1{ Fs Fi:0 FL}



static void Test_STT137()
{
  {
    init_simple_test("STT137");
    static STRUCT_IF_C STT137 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT137)");
    check_field_offset(lv, fa, 0, "STT137.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT137, STT137)
//============================================================================


struct  STT147  {
  short fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT147) C1{ Fs FL:0 FL}



static void Test_STT147()
{
  {
    init_simple_test("STT147");
    static STRUCT_IF_C STT147 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT147)");
    check_field_offset(lv, fa, 0, "STT147.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT147, STT147)
//============================================================================


struct  STT157  {
  short fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT157) C1{ Fs Fc:3 FL}



static void Test_STT157()
{
  {
    init_simple_test("STT157");
    static STRUCT_IF_C STT157 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT157)");
    check_field_offset(lv, fa, 0, "STT157.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT157, STT157)
//============================================================================


struct  STT167  {
  short fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT167) C1{ Fs Fs:3 FL}



static void Test_STT167()
{
  {
    init_simple_test("STT167");
    static STRUCT_IF_C STT167 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT167)");
    check_field_offset(lv, fa, 0, "STT167.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT167, STT167)
//============================================================================


struct  STT177  {
  short fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT177) C1{ Fs Fi:3 FL}



static void Test_STT177()
{
  {
    init_simple_test("STT177");
    static STRUCT_IF_C STT177 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT177)");
    check_field_offset(lv, fa, 0, "STT177.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT177, STT177)
//============================================================================


struct  STT187  {
  short fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT187) C1{ Fs FL:3 FL}



static void Test_STT187()
{
  {
    init_simple_test("STT187");
    static STRUCT_IF_C STT187 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT187)");
    check_field_offset(lv, fa, 0, "STT187.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT187, STT187)
//============================================================================


struct  STT197  {
  short fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT197) C1{ Fs Fs:8 FL}



static void Test_STT197()
{
  {
    init_simple_test("STT197");
    static STRUCT_IF_C STT197 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT197)");
    check_field_offset(lv, fa, 0, "STT197.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT197, STT197)
//============================================================================


struct  STT1107  {
  short fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT1107) C1{ Fs Fi:8 FL}



static void Test_STT1107()
{
  {
    init_simple_test("STT1107");
    static STRUCT_IF_C STT1107 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1107)");
    check_field_offset(lv, fa, 0, "STT1107.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1107, STT1107)
//============================================================================


struct  STT1117  {
  short fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT1117) C1{ Fs FL:8 FL}



static void Test_STT1117()
{
  {
    init_simple_test("STT1117");
    static STRUCT_IF_C STT1117 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1117)");
    check_field_offset(lv, fa, 0, "STT1117.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1117, STT1117)
//============================================================================


struct  STT1127  {
  short fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT1127) C1{ Fs Fi:18 FL}



static void Test_STT1127()
{
  {
    init_simple_test("STT1127");
    static STRUCT_IF_C STT1127 lv;
    check2(sizeof(lv), 16, "sizeof(STT1127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1127)");
    check_field_offset(lv, fa, 0, "STT1127.fa");
    check_field_offset(lv, fb, 8, "STT1127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1127, STT1127)
//============================================================================


struct  STT1137  {
  short fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT1137) C1{ Fs FL:18 FL}



static void Test_STT1137()
{
  {
    init_simple_test("STT1137");
    static STRUCT_IF_C STT1137 lv;
    check2(sizeof(lv), 16, "sizeof(STT1137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1137)");
    check_field_offset(lv, fa, 0, "STT1137.fa");
    check_field_offset(lv, fb, 8, "STT1137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1137, STT1137)
//============================================================================


struct  STT1147  {
  short fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT1147) C1{ Fs FL:48 FL}



static void Test_STT1147()
{
  {
    init_simple_test("STT1147");
    static STRUCT_IF_C STT1147 lv;
    check2(sizeof(lv), 16, "sizeof(STT1147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1147)");
    check_field_offset(lv, fa, 0, "STT1147.fa");
    check_field_offset(lv, fb, 8, "STT1147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1147, STT1147)
//============================================================================


struct  STT1157  {
  short fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT1157) C1{ Fs Fc:3 FL}



static void Test_STT1157()
{
  {
    init_simple_test("STT1157");
    static STRUCT_IF_C STT1157 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1157)");
    check_field_offset(lv, fa, 0, "STT1157.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1157");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1157");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1157, STT1157)
//============================================================================


struct  STT1167  {
  short fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT1167) C1{ Fs Fs:3 FL}



static void Test_STT1167()
{
  {
    init_simple_test("STT1167");
    static STRUCT_IF_C STT1167 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1167)");
    check_field_offset(lv, fa, 0, "STT1167.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1167");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1167");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1167, STT1167)
//============================================================================


struct  STT1177  {
  short fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT1177) C1{ Fs Fi:3 FL}



static void Test_STT1177()
{
  {
    init_simple_test("STT1177");
    static STRUCT_IF_C STT1177 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1177)");
    check_field_offset(lv, fa, 0, "STT1177.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1177");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1177");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1177, STT1177)
//============================================================================


struct  STT1187  {
  short fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT1187) C1{ Fs FL:3 FL}



static void Test_STT1187()
{
  {
    init_simple_test("STT1187");
    static STRUCT_IF_C STT1187 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1187)");
    check_field_offset(lv, fa, 0, "STT1187.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1187");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1187");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1187, STT1187)
//============================================================================


struct  STT1197  {
  short fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT1197) C1{ Fs Fs:8 FL}



static void Test_STT1197()
{
  {
    init_simple_test("STT1197");
    static STRUCT_IF_C STT1197 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1197)");
    check_field_offset(lv, fa, 0, "STT1197.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1197");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1197");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1197, STT1197)
//============================================================================


struct  STT1207  {
  short fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT1207) C1{ Fs Fi:8 FL}



static void Test_STT1207()
{
  {
    init_simple_test("STT1207");
    static STRUCT_IF_C STT1207 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1207)");
    check_field_offset(lv, fa, 0, "STT1207.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1207");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1207");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1207, STT1207)
//============================================================================


struct  STT1217  {
  short fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT1217) C1{ Fs FL:8 FL}



static void Test_STT1217()
{
  {
    init_simple_test("STT1217");
    static STRUCT_IF_C STT1217 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1217)");
    check_field_offset(lv, fa, 0, "STT1217.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1217");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1217");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1217, STT1217)
//============================================================================


struct  STT1227  {
  short fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT1227) C1{ Fs Fi:18 FL}



static void Test_STT1227()
{
  {
    init_simple_test("STT1227");
    static STRUCT_IF_C STT1227 lv;
    check2(sizeof(lv), 16, "sizeof(STT1227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1227)");
    check_field_offset(lv, fa, 0, "STT1227.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1227");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1227");
    check_field_offset(lv, fb, 8, "STT1227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1227, STT1227)
//============================================================================


struct  STT1237  {
  short fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT1237) C1{ Fs FL:18 FL}



static void Test_STT1237()
{
  {
    init_simple_test("STT1237");
    static STRUCT_IF_C STT1237 lv;
    check2(sizeof(lv), 16, "sizeof(STT1237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1237)");
    check_field_offset(lv, fa, 0, "STT1237.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1237");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1237");
    check_field_offset(lv, fb, 8, "STT1237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1237, STT1237)
//============================================================================


struct  STT1247  {
  short fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT1247) C1{ Fs FL:48 FL}



static void Test_STT1247()
{
  {
    init_simple_test("STT1247");
    static STRUCT_IF_C STT1247 lv;
    check2(sizeof(lv), 16, "sizeof(STT1247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1247)");
    check_field_offset(lv, fa, 0, "STT1247.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1247");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1247");
    check_field_offset(lv, fb, 8, "STT1247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1247, STT1247)
//============================================================================


struct  STT118  {
  short fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT118) C1{ Fs Fc:0 FD}



static void Test_STT118()
{
  {
    init_simple_test("STT118");
    static STRUCT_IF_C STT118 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT118)");
    check_field_offset(lv, fa, 0, "STT118.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT118, STT118)
//============================================================================


struct  STT128  {
  short fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT128) C1{ Fs Fs:0 FD}



static void Test_STT128()
{
  {
    init_simple_test("STT128");
    static STRUCT_IF_C STT128 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT128)");
    check_field_offset(lv, fa, 0, "STT128.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT128, STT128)
//============================================================================


struct  STT138  {
  short fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT138) C1{ Fs Fi:0 FD}



static void Test_STT138()
{
  {
    init_simple_test("STT138");
    static STRUCT_IF_C STT138 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT138)");
    check_field_offset(lv, fa, 0, "STT138.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT138, STT138)
//============================================================================


struct  STT148  {
  short fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT148) C1{ Fs FL:0 FD}



static void Test_STT148()
{
  {
    init_simple_test("STT148");
    static STRUCT_IF_C STT148 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT148)");
    check_field_offset(lv, fa, 0, "STT148.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT148, STT148)
//============================================================================


struct  STT158  {
  short fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT158) C1{ Fs Fc:3 FD}



static void Test_STT158()
{
  {
    init_simple_test("STT158");
    static STRUCT_IF_C STT158 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT158)");
    check_field_offset(lv, fa, 0, "STT158.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT158, STT158)
//============================================================================


struct  STT168  {
  short fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT168) C1{ Fs Fs:3 FD}



static void Test_STT168()
{
  {
    init_simple_test("STT168");
    static STRUCT_IF_C STT168 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT168)");
    check_field_offset(lv, fa, 0, "STT168.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT168, STT168)
//============================================================================


struct  STT178  {
  short fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT178) C1{ Fs Fi:3 FD}



static void Test_STT178()
{
  {
    init_simple_test("STT178");
    static STRUCT_IF_C STT178 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT178)");
    check_field_offset(lv, fa, 0, "STT178.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT178, STT178)
//============================================================================


struct  STT188  {
  short fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT188) C1{ Fs FL:3 FD}



static void Test_STT188()
{
  {
    init_simple_test("STT188");
    static STRUCT_IF_C STT188 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT188)");
    check_field_offset(lv, fa, 0, "STT188.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT188, STT188)
//============================================================================


struct  STT198  {
  short fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT198) C1{ Fs Fs:8 FD}



static void Test_STT198()
{
  {
    init_simple_test("STT198");
    static STRUCT_IF_C STT198 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT198)");
    check_field_offset(lv, fa, 0, "STT198.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT198, STT198)
//============================================================================


struct  STT1108  {
  short fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT1108) C1{ Fs Fi:8 FD}



static void Test_STT1108()
{
  {
    init_simple_test("STT1108");
    static STRUCT_IF_C STT1108 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1108)");
    check_field_offset(lv, fa, 0, "STT1108.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1108, STT1108)
//============================================================================


struct  STT1118  {
  short fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT1118) C1{ Fs FL:8 FD}



static void Test_STT1118()
{
  {
    init_simple_test("STT1118");
    static STRUCT_IF_C STT1118 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1118)");
    check_field_offset(lv, fa, 0, "STT1118.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1118, STT1118)
//============================================================================


struct  STT1128  {
  short fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT1128) C1{ Fs Fi:18 FD}



static void Test_STT1128()
{
  {
    init_simple_test("STT1128");
    static STRUCT_IF_C STT1128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1128)");
    check_field_offset(lv, fa, 0, "STT1128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1128, STT1128)
//============================================================================


struct  STT1138  {
  short fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT1138) C1{ Fs FL:18 FD}



static void Test_STT1138()
{
  {
    init_simple_test("STT1138");
    static STRUCT_IF_C STT1138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1138)");
    check_field_offset(lv, fa, 0, "STT1138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1138, STT1138)
//============================================================================


struct  STT1148  {
  short fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT1148) C1{ Fs FL:48 FD}



static void Test_STT1148()
{
  {
    init_simple_test("STT1148");
    static STRUCT_IF_C STT1148 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1148)");
    check_field_offset(lv, fa, 0, "STT1148.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1148, STT1148)
//============================================================================


struct  STT1158  {
  short fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT1158) C1{ Fs Fc:3 FD}



static void Test_STT1158()
{
  {
    init_simple_test("STT1158");
    static STRUCT_IF_C STT1158 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1158)");
    check_field_offset(lv, fa, 0, "STT1158.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1158");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1158");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1158, STT1158)
//============================================================================


struct  STT1168  {
  short fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT1168) C1{ Fs Fs:3 FD}



static void Test_STT1168()
{
  {
    init_simple_test("STT1168");
    static STRUCT_IF_C STT1168 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1168)");
    check_field_offset(lv, fa, 0, "STT1168.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1168");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1168");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1168, STT1168)
//============================================================================


struct  STT1178  {
  short fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT1178) C1{ Fs Fi:3 FD}



static void Test_STT1178()
{
  {
    init_simple_test("STT1178");
    static STRUCT_IF_C STT1178 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1178)");
    check_field_offset(lv, fa, 0, "STT1178.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1178");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1178");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1178, STT1178)
//============================================================================


struct  STT1188  {
  short fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT1188) C1{ Fs FL:3 FD}



static void Test_STT1188()
{
  {
    init_simple_test("STT1188");
    static STRUCT_IF_C STT1188 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1188)");
    check_field_offset(lv, fa, 0, "STT1188.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1188");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1188");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1188, STT1188)
//============================================================================


struct  STT1198  {
  short fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT1198) C1{ Fs Fs:8 FD}



static void Test_STT1198()
{
  {
    init_simple_test("STT1198");
    static STRUCT_IF_C STT1198 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1198)");
    check_field_offset(lv, fa, 0, "STT1198.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1198");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1198");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1198, STT1198)
//============================================================================


struct  STT1208  {
  short fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT1208) C1{ Fs Fi:8 FD}



static void Test_STT1208()
{
  {
    init_simple_test("STT1208");
    static STRUCT_IF_C STT1208 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1208)");
    check_field_offset(lv, fa, 0, "STT1208.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1208");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1208");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1208, STT1208)
//============================================================================


struct  STT1218  {
  short fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT1218) C1{ Fs FL:8 FD}



static void Test_STT1218()
{
  {
    init_simple_test("STT1218");
    static STRUCT_IF_C STT1218 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1218)");
    check_field_offset(lv, fa, 0, "STT1218.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1218");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1218");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1218, STT1218)
//============================================================================


struct  STT1228  {
  short fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT1228) C1{ Fs Fi:18 FD}



static void Test_STT1228()
{
  {
    init_simple_test("STT1228");
    static STRUCT_IF_C STT1228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1228)");
    check_field_offset(lv, fa, 0, "STT1228.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1228");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1228, STT1228)
//============================================================================


struct  STT1238  {
  short fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT1238) C1{ Fs FL:18 FD}



static void Test_STT1238()
{
  {
    init_simple_test("STT1238");
    static STRUCT_IF_C STT1238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1238)");
    check_field_offset(lv, fa, 0, "STT1238.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1238");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1238, STT1238)
//============================================================================


struct  STT1248  {
  short fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT1248) C1{ Fs FL:48 FD}



static void Test_STT1248()
{
  {
    init_simple_test("STT1248");
    static STRUCT_IF_C STT1248 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1248)");
    check_field_offset(lv, fa, 0, "STT1248.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1248");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1248");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1248, STT1248)
//============================================================================


struct  STT119  {
  short fa;
  unsigned char  :0;
};
//SIG(1 STT119) C1{ Fs Fc:0}



static void Test_STT119()
{
  {
    init_simple_test("STT119");
    static STRUCT_IF_C STT119 lv;
    check2(sizeof(lv), 2, "sizeof(STT119)");
    check2(__alignof__(lv), 2, "__alignof__(STT119)");
    check_field_offset(lv, fa, 0, "STT119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT119, STT119)
//============================================================================


struct  STT129  {
  short fa;
  unsigned short  :0;
};
//SIG(1 STT129) C1{ Fs Fs:0}



static void Test_STT129()
{
  {
    init_simple_test("STT129");
    static STRUCT_IF_C STT129 lv;
    check2(sizeof(lv), 2, "sizeof(STT129)");
    check2(__alignof__(lv), 2, "__alignof__(STT129)");
    check_field_offset(lv, fa, 0, "STT129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT129, STT129)
//============================================================================


struct  STT139  {
  short fa;
  unsigned int  :0;
};
//SIG(1 STT139) C1{ Fs Fi:0}



static void Test_STT139()
{
  {
    init_simple_test("STT139");
    static STRUCT_IF_C STT139 lv;
    check2(sizeof(lv), 4, "sizeof(STT139)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT139)");
    check_field_offset(lv, fa, 0, "STT139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT139, STT139)
//============================================================================


struct  STT149  {
  short fa;
  __tsu64  :0;
};
//SIG(1 STT149) C1{ Fs FL:0}



static void Test_STT149()
{
  {
    init_simple_test("STT149");
    static STRUCT_IF_C STT149 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT149)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT149)");
    check_field_offset(lv, fa, 0, "STT149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT149, STT149)
//============================================================================


struct  STT159  {
  short fa;
  unsigned char  :3;
};
//SIG(1 STT159) C1{ Fs Fc:3}



static void Test_STT159()
{
  {
    init_simple_test("STT159");
    static STRUCT_IF_C STT159 lv;
    check2(sizeof(lv), 4, "sizeof(STT159)");
    check2(__alignof__(lv), 2, "__alignof__(STT159)");
    check_field_offset(lv, fa, 0, "STT159.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT159, STT159)
//============================================================================


struct  STT169  {
  short fa;
  unsigned short  :3;
};
//SIG(1 STT169) C1{ Fs Fs:3}



static void Test_STT169()
{
  {
    init_simple_test("STT169");
    static STRUCT_IF_C STT169 lv;
    check2(sizeof(lv), 4, "sizeof(STT169)");
    check2(__alignof__(lv), 2, "__alignof__(STT169)");
    check_field_offset(lv, fa, 0, "STT169.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT169, STT169)
//============================================================================


struct  STT179  {
  short fa;
  unsigned int  :3;
};
//SIG(1 STT179) C1{ Fs Fi:3}



static void Test_STT179()
{
  {
    init_simple_test("STT179");
    static STRUCT_IF_C STT179 lv;
    check2(sizeof(lv), 4, "sizeof(STT179)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT179)");
    check_field_offset(lv, fa, 0, "STT179.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT179, STT179)
//============================================================================


struct  STT189  {
  short fa;
  __tsu64  :3;
};
//SIG(1 STT189) C1{ Fs FL:3}



static void Test_STT189()
{
  {
    init_simple_test("STT189");
    static STRUCT_IF_C STT189 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT189)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT189)");
    check_field_offset(lv, fa, 0, "STT189.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT189, STT189)
//============================================================================


struct  STT199  {
  short fa;
  unsigned short  :8;
};
//SIG(1 STT199) C1{ Fs Fs:8}



static void Test_STT199()
{
  {
    init_simple_test("STT199");
    static STRUCT_IF_C STT199 lv;
    check2(sizeof(lv), 4, "sizeof(STT199)");
    check2(__alignof__(lv), 2, "__alignof__(STT199)");
    check_field_offset(lv, fa, 0, "STT199.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT199, STT199)
//============================================================================


struct  STT1109  {
  short fa;
  unsigned int  :8;
};
//SIG(1 STT1109) C1{ Fs Fi:8}



static void Test_STT1109()
{
  {
    init_simple_test("STT1109");
    static STRUCT_IF_C STT1109 lv;
    check2(sizeof(lv), 4, "sizeof(STT1109)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1109)");
    check_field_offset(lv, fa, 0, "STT1109.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1109, STT1109)
//============================================================================


struct  STT1119  {
  short fa;
  __tsu64  :8;
};
//SIG(1 STT1119) C1{ Fs FL:8}



static void Test_STT1119()
{
  {
    init_simple_test("STT1119");
    static STRUCT_IF_C STT1119 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT1119)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1119)");
    check_field_offset(lv, fa, 0, "STT1119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1119, STT1119)
//============================================================================


struct  STT1129  {
  short fa;
  unsigned int  :18;
};
//SIG(1 STT1129) C1{ Fs Fi:18}



static void Test_STT1129()
{
  {
    init_simple_test("STT1129");
    static STRUCT_IF_C STT1129 lv;
    check2(sizeof(lv), 8, "sizeof(STT1129)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1129)");
    check_field_offset(lv, fa, 0, "STT1129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1129, STT1129)
//============================================================================


struct  STT1139  {
  short fa;
  __tsu64  :18;
};
//SIG(1 STT1139) C1{ Fs FL:18}



static void Test_STT1139()
{
  {
    init_simple_test("STT1139");
    static STRUCT_IF_C STT1139 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1139)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1139)");
    check_field_offset(lv, fa, 0, "STT1139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1139, STT1139)
//============================================================================


struct  STT1149  {
  short fa;
  __tsu64  :48;
};
//SIG(1 STT1149) C1{ Fs FL:48}



static void Test_STT1149()
{
  {
    init_simple_test("STT1149");
    static STRUCT_IF_C STT1149 lv;
    check2(sizeof(lv), 8, "sizeof(STT1149)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1149)");
    check_field_offset(lv, fa, 0, "STT1149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1149, STT1149)
//============================================================================


struct  STT1159  {
  short fa;
  unsigned char bf:3;
};
//SIG(1 STT1159) C1{ Fs Fc:3}



static void Test_STT1159()
{
  {
    init_simple_test("STT1159");
    static STRUCT_IF_C STT1159 lv;
    check2(sizeof(lv), 4, "sizeof(STT1159)");
    check2(__alignof__(lv), 2, "__alignof__(STT1159)");
    check_field_offset(lv, fa, 0, "STT1159.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1159");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1159");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1159, STT1159)
//============================================================================


struct  STT1169  {
  short fa;
  unsigned short bf:3;
};
//SIG(1 STT1169) C1{ Fs Fs:3}



static void Test_STT1169()
{
  {
    init_simple_test("STT1169");
    static STRUCT_IF_C STT1169 lv;
    check2(sizeof(lv), 4, "sizeof(STT1169)");
    check2(__alignof__(lv), 2, "__alignof__(STT1169)");
    check_field_offset(lv, fa, 0, "STT1169.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1169");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1169");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1169, STT1169)
//============================================================================


struct  STT1179  {
  short fa;
  unsigned int bf:3;
};
//SIG(1 STT1179) C1{ Fs Fi:3}



static void Test_STT1179()
{
  {
    init_simple_test("STT1179");
    static STRUCT_IF_C STT1179 lv;
    check2(sizeof(lv), 4, "sizeof(STT1179)");
    check2(__alignof__(lv), 4, "__alignof__(STT1179)");
    check_field_offset(lv, fa, 0, "STT1179.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1179");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1179");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1179, STT1179)
//============================================================================


struct  STT1189  {
  short fa;
  __tsu64 bf:3;
};
//SIG(1 STT1189) C1{ Fs FL:3}



static void Test_STT1189()
{
  {
    init_simple_test("STT1189");
    static STRUCT_IF_C STT1189 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1189)");
    check_field_offset(lv, fa, 0, "STT1189.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1189");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1189");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1189, STT1189)
//============================================================================


struct  STT1199  {
  short fa;
  unsigned short bf:8;
};
//SIG(1 STT1199) C1{ Fs Fs:8}



static void Test_STT1199()
{
  {
    init_simple_test("STT1199");
    static STRUCT_IF_C STT1199 lv;
    check2(sizeof(lv), 4, "sizeof(STT1199)");
    check2(__alignof__(lv), 2, "__alignof__(STT1199)");
    check_field_offset(lv, fa, 0, "STT1199.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1199");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1199");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1199, STT1199)
//============================================================================


struct  STT1209  {
  short fa;
  unsigned int bf:8;
};
//SIG(1 STT1209) C1{ Fs Fi:8}



static void Test_STT1209()
{
  {
    init_simple_test("STT1209");
    static STRUCT_IF_C STT1209 lv;
    check2(sizeof(lv), 4, "sizeof(STT1209)");
    check2(__alignof__(lv), 4, "__alignof__(STT1209)");
    check_field_offset(lv, fa, 0, "STT1209.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1209");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1209");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1209, STT1209)
//============================================================================


struct  STT1219  {
  short fa;
  __tsu64 bf:8;
};
//SIG(1 STT1219) C1{ Fs FL:8}



static void Test_STT1219()
{
  {
    init_simple_test("STT1219");
    static STRUCT_IF_C STT1219 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1219)");
    check_field_offset(lv, fa, 0, "STT1219.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1219");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1219");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1219, STT1219)
//============================================================================


struct  STT1229  {
  short fa;
  unsigned int bf:18;
};
//SIG(1 STT1229) C1{ Fs Fi:18}



static void Test_STT1229()
{
  {
    init_simple_test("STT1229");
    static STRUCT_IF_C STT1229 lv;
    check2(sizeof(lv), 8, "sizeof(STT1229)");
    check2(__alignof__(lv), 4, "__alignof__(STT1229)");
    check_field_offset(lv, fa, 0, "STT1229.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1229");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1229");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1229, STT1229)
//============================================================================


struct  STT1239  {
  short fa;
  __tsu64 bf:18;
};
//SIG(1 STT1239) C1{ Fs FL:18}



static void Test_STT1239()
{
  {
    init_simple_test("STT1239");
    static STRUCT_IF_C STT1239 lv;
    check2(sizeof(lv), 8, "sizeof(STT1239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1239)");
    check_field_offset(lv, fa, 0, "STT1239.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1239");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1239");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1239, STT1239)
//============================================================================


struct  STT1249  {
  short fa;
  __tsu64 bf:48;
};
//SIG(1 STT1249) C1{ Fs FL:48}



static void Test_STT1249()
{
  {
    init_simple_test("STT1249");
    static STRUCT_IF_C STT1249 lv;
    check2(sizeof(lv), 8, "sizeof(STT1249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1249)");
    check_field_offset(lv, fa, 0, "STT1249.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1249");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1249");
  }
}
ARRANGE_TO_CALL_ME(Test_STT1249, STT1249)
//============================================================================


struct  STT210  {
  int fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT210) C1{ Fi Fc:0 Fc}



static void Test_STT210()
{
  {
    init_simple_test("STT210");
    static STRUCT_IF_C STT210 lv;
    check2(sizeof(lv), 8, "sizeof(STT210)");
    check2(__alignof__(lv), 4, "__alignof__(STT210)");
    check_field_offset(lv, fa, 0, "STT210.fa");
    check_field_offset(lv, fb, 4, "STT210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT210, STT210)
//============================================================================


struct  STT220  {
  int fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT220) C1{ Fi Fs:0 Fc}



static void Test_STT220()
{
  {
    init_simple_test("STT220");
    static STRUCT_IF_C STT220 lv;
    check2(sizeof(lv), 8, "sizeof(STT220)");
    check2(__alignof__(lv), 4, "__alignof__(STT220)");
    check_field_offset(lv, fa, 0, "STT220.fa");
    check_field_offset(lv, fb, 4, "STT220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT220, STT220)
//============================================================================


struct  STT230  {
  int fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT230) C1{ Fi Fi:0 Fc}



static void Test_STT230()
{
  {
    init_simple_test("STT230");
    static STRUCT_IF_C STT230 lv;
    check2(sizeof(lv), 8, "sizeof(STT230)");
    check2(__alignof__(lv), 4, "__alignof__(STT230)");
    check_field_offset(lv, fa, 0, "STT230.fa");
    check_field_offset(lv, fb, 4, "STT230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT230, STT230)
//============================================================================


struct  STT240  {
  int fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT240) C1{ Fi FL:0 Fc}



static void Test_STT240()
{
  {
    init_simple_test("STT240");
    static STRUCT_IF_C STT240 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT240)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT240)");
    check_field_offset(lv, fa, 0, "STT240.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT240, STT240)
//============================================================================


struct  STT250  {
  int fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT250) C1{ Fi Fc:3 Fc}



static void Test_STT250()
{
  {
    init_simple_test("STT250");
    static STRUCT_IF_C STT250 lv;
    check2(sizeof(lv), 8, "sizeof(STT250)");
    check2(__alignof__(lv), 4, "__alignof__(STT250)");
    check_field_offset(lv, fa, 0, "STT250.fa");
    check_field_offset(lv, fb, 5, "STT250.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT250, STT250)
//============================================================================


struct  STT260  {
  int fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT260) C1{ Fi Fs:3 Fc}



static void Test_STT260()
{
  {
    init_simple_test("STT260");
    static STRUCT_IF_C STT260 lv;
    check2(sizeof(lv), 8, "sizeof(STT260)");
    check2(__alignof__(lv), 4, "__alignof__(STT260)");
    check_field_offset(lv, fa, 0, "STT260.fa");
    check_field_offset(lv, fb, 5, "STT260.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT260, STT260)
//============================================================================


struct  STT270  {
  int fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT270) C1{ Fi Fi:3 Fc}



static void Test_STT270()
{
  {
    init_simple_test("STT270");
    static STRUCT_IF_C STT270 lv;
    check2(sizeof(lv), 8, "sizeof(STT270)");
    check2(__alignof__(lv), 4, "__alignof__(STT270)");
    check_field_offset(lv, fa, 0, "STT270.fa");
    check_field_offset(lv, fb, 5, "STT270.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT270, STT270)
//============================================================================


struct  STT280  {
  int fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT280) C1{ Fi FL:3 Fc}



static void Test_STT280()
{
  {
    init_simple_test("STT280");
    static STRUCT_IF_C STT280 lv;
    check2(sizeof(lv), 8, "sizeof(STT280)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT280)");
    check_field_offset(lv, fa, 0, "STT280.fa");
    check_field_offset(lv, fb, 5, "STT280.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT280, STT280)
//============================================================================


struct  STT290  {
  int fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT290) C1{ Fi Fs:8 Fc}



static void Test_STT290()
{
  {
    init_simple_test("STT290");
    static STRUCT_IF_C STT290 lv;
    check2(sizeof(lv), 8, "sizeof(STT290)");
    check2(__alignof__(lv), 4, "__alignof__(STT290)");
    check_field_offset(lv, fa, 0, "STT290.fa");
    check_field_offset(lv, fb, 5, "STT290.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT290, STT290)
//============================================================================


struct  STT2100  {
  int fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT2100) C1{ Fi Fi:8 Fc}



static void Test_STT2100()
{
  {
    init_simple_test("STT2100");
    static STRUCT_IF_C STT2100 lv;
    check2(sizeof(lv), 8, "sizeof(STT2100)");
    check2(__alignof__(lv), 4, "__alignof__(STT2100)");
    check_field_offset(lv, fa, 0, "STT2100.fa");
    check_field_offset(lv, fb, 5, "STT2100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2100, STT2100)
//============================================================================


struct  STT2110  {
  int fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT2110) C1{ Fi FL:8 Fc}



static void Test_STT2110()
{
  {
    init_simple_test("STT2110");
    static STRUCT_IF_C STT2110 lv;
    check2(sizeof(lv), 8, "sizeof(STT2110)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2110)");
    check_field_offset(lv, fa, 0, "STT2110.fa");
    check_field_offset(lv, fb, 5, "STT2110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2110, STT2110)
//============================================================================


struct  STT2120  {
  int fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT2120) C1{ Fi Fi:18 Fc}



static void Test_STT2120()
{
  {
    init_simple_test("STT2120");
    static STRUCT_IF_C STT2120 lv;
    check2(sizeof(lv), 8, "sizeof(STT2120)");
    check2(__alignof__(lv), 4, "__alignof__(STT2120)");
    check_field_offset(lv, fa, 0, "STT2120.fa");
    check_field_offset(lv, fb, 7, "STT2120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2120, STT2120)
//============================================================================


struct  STT2130  {
  int fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT2130) C1{ Fi FL:18 Fc}



static void Test_STT2130()
{
  {
    init_simple_test("STT2130");
    static STRUCT_IF_C STT2130 lv;
    check2(sizeof(lv), 8, "sizeof(STT2130)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2130)");
    check_field_offset(lv, fa, 0, "STT2130.fa");
    check_field_offset(lv, fb, 7, "STT2130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2130, STT2130)
//============================================================================


struct  STT2140  {
  int fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT2140) C1{ Fi FL:48 Fc}



static void Test_STT2140()
{
  {
    init_simple_test("STT2140");
    static STRUCT_IF_C STT2140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2140)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2140)");
    check_field_offset(lv, fa, 0, "STT2140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2140, STT2140)
//============================================================================


struct  STT2150  {
  int fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT2150) C1{ Fi Fc:3 Fc}



static void Test_STT2150()
{
  {
    init_simple_test("STT2150");
    static STRUCT_IF_C STT2150 lv;
    check2(sizeof(lv), 8, "sizeof(STT2150)");
    check2(__alignof__(lv), 4, "__alignof__(STT2150)");
    check_field_offset(lv, fa, 0, "STT2150.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2150");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2150");
    check_field_offset(lv, fb, 5, "STT2150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2150, STT2150)
//============================================================================


struct  STT2160  {
  int fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT2160) C1{ Fi Fs:3 Fc}



static void Test_STT2160()
{
  {
    init_simple_test("STT2160");
    static STRUCT_IF_C STT2160 lv;
    check2(sizeof(lv), 8, "sizeof(STT2160)");
    check2(__alignof__(lv), 4, "__alignof__(STT2160)");
    check_field_offset(lv, fa, 0, "STT2160.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2160");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2160");
    check_field_offset(lv, fb, 5, "STT2160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2160, STT2160)
//============================================================================


struct  STT2170  {
  int fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT2170) C1{ Fi Fi:3 Fc}



static void Test_STT2170()
{
  {
    init_simple_test("STT2170");
    static STRUCT_IF_C STT2170 lv;
    check2(sizeof(lv), 8, "sizeof(STT2170)");
    check2(__alignof__(lv), 4, "__alignof__(STT2170)");
    check_field_offset(lv, fa, 0, "STT2170.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2170");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2170");
    check_field_offset(lv, fb, 5, "STT2170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2170, STT2170)
//============================================================================


struct  STT2180  {
  int fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT2180) C1{ Fi FL:3 Fc}



static void Test_STT2180()
{
  {
    init_simple_test("STT2180");
    static STRUCT_IF_C STT2180 lv;
    check2(sizeof(lv), 8, "sizeof(STT2180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2180)");
    check_field_offset(lv, fa, 0, "STT2180.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2180");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2180");
    check_field_offset(lv, fb, 5, "STT2180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2180, STT2180)
//============================================================================


struct  STT2190  {
  int fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT2190) C1{ Fi Fs:8 Fc}



static void Test_STT2190()
{
  {
    init_simple_test("STT2190");
    static STRUCT_IF_C STT2190 lv;
    check2(sizeof(lv), 8, "sizeof(STT2190)");
    check2(__alignof__(lv), 4, "__alignof__(STT2190)");
    check_field_offset(lv, fa, 0, "STT2190.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2190");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2190");
    check_field_offset(lv, fb, 5, "STT2190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2190, STT2190)
//============================================================================


struct  STT2200  {
  int fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT2200) C1{ Fi Fi:8 Fc}



static void Test_STT2200()
{
  {
    init_simple_test("STT2200");
    static STRUCT_IF_C STT2200 lv;
    check2(sizeof(lv), 8, "sizeof(STT2200)");
    check2(__alignof__(lv), 4, "__alignof__(STT2200)");
    check_field_offset(lv, fa, 0, "STT2200.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2200");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2200");
    check_field_offset(lv, fb, 5, "STT2200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2200, STT2200)
//============================================================================


struct  STT2210  {
  int fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT2210) C1{ Fi FL:8 Fc}



static void Test_STT2210()
{
  {
    init_simple_test("STT2210");
    static STRUCT_IF_C STT2210 lv;
    check2(sizeof(lv), 8, "sizeof(STT2210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2210)");
    check_field_offset(lv, fa, 0, "STT2210.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2210");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2210");
    check_field_offset(lv, fb, 5, "STT2210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2210, STT2210)
//============================================================================


struct  STT2220  {
  int fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT2220) C1{ Fi Fi:18 Fc}



static void Test_STT2220()
{
  {
    init_simple_test("STT2220");
    static STRUCT_IF_C STT2220 lv;
    check2(sizeof(lv), 8, "sizeof(STT2220)");
    check2(__alignof__(lv), 4, "__alignof__(STT2220)");
    check_field_offset(lv, fa, 0, "STT2220.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2220");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2220");
    check_field_offset(lv, fb, 7, "STT2220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2220, STT2220)
//============================================================================


struct  STT2230  {
  int fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT2230) C1{ Fi FL:18 Fc}



static void Test_STT2230()
{
  {
    init_simple_test("STT2230");
    static STRUCT_IF_C STT2230 lv;
    check2(sizeof(lv), 8, "sizeof(STT2230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2230)");
    check_field_offset(lv, fa, 0, "STT2230.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2230");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2230");
    check_field_offset(lv, fb, 7, "STT2230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2230, STT2230)
//============================================================================


struct  STT2240  {
  int fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT2240) C1{ Fi FL:48 Fc}



static void Test_STT2240()
{
  {
    init_simple_test("STT2240");
    static STRUCT_IF_C STT2240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2240)");
    check_field_offset(lv, fa, 0, "STT2240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2240, STT2240)
//============================================================================


struct  STT211  {
  int fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT211) C1{ Fi Fc:0 Fs}



static void Test_STT211()
{
  {
    init_simple_test("STT211");
    static STRUCT_IF_C STT211 lv;
    check2(sizeof(lv), 8, "sizeof(STT211)");
    check2(__alignof__(lv), 4, "__alignof__(STT211)");
    check_field_offset(lv, fa, 0, "STT211.fa");
    check_field_offset(lv, fb, 4, "STT211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT211, STT211)
//============================================================================


struct  STT221  {
  int fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT221) C1{ Fi Fs:0 Fs}



static void Test_STT221()
{
  {
    init_simple_test("STT221");
    static STRUCT_IF_C STT221 lv;
    check2(sizeof(lv), 8, "sizeof(STT221)");
    check2(__alignof__(lv), 4, "__alignof__(STT221)");
    check_field_offset(lv, fa, 0, "STT221.fa");
    check_field_offset(lv, fb, 4, "STT221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT221, STT221)
//============================================================================


struct  STT231  {
  int fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT231) C1{ Fi Fi:0 Fs}



static void Test_STT231()
{
  {
    init_simple_test("STT231");
    static STRUCT_IF_C STT231 lv;
    check2(sizeof(lv), 8, "sizeof(STT231)");
    check2(__alignof__(lv), 4, "__alignof__(STT231)");
    check_field_offset(lv, fa, 0, "STT231.fa");
    check_field_offset(lv, fb, 4, "STT231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT231, STT231)
//============================================================================


struct  STT241  {
  int fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT241) C1{ Fi FL:0 Fs}



static void Test_STT241()
{
  {
    init_simple_test("STT241");
    static STRUCT_IF_C STT241 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT241)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT241)");
    check_field_offset(lv, fa, 0, "STT241.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT241, STT241)
//============================================================================


struct  STT251  {
  int fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT251) C1{ Fi Fc:3 Fs}



static void Test_STT251()
{
  {
    init_simple_test("STT251");
    static STRUCT_IF_C STT251 lv;
    check2(sizeof(lv), 8, "sizeof(STT251)");
    check2(__alignof__(lv), 4, "__alignof__(STT251)");
    check_field_offset(lv, fa, 0, "STT251.fa");
    check_field_offset(lv, fb, 6, "STT251.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT251, STT251)
//============================================================================


struct  STT261  {
  int fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT261) C1{ Fi Fs:3 Fs}



static void Test_STT261()
{
  {
    init_simple_test("STT261");
    static STRUCT_IF_C STT261 lv;
    check2(sizeof(lv), 8, "sizeof(STT261)");
    check2(__alignof__(lv), 4, "__alignof__(STT261)");
    check_field_offset(lv, fa, 0, "STT261.fa");
    check_field_offset(lv, fb, 6, "STT261.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT261, STT261)
//============================================================================


struct  STT271  {
  int fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT271) C1{ Fi Fi:3 Fs}



static void Test_STT271()
{
  {
    init_simple_test("STT271");
    static STRUCT_IF_C STT271 lv;
    check2(sizeof(lv), 8, "sizeof(STT271)");
    check2(__alignof__(lv), 4, "__alignof__(STT271)");
    check_field_offset(lv, fa, 0, "STT271.fa");
    check_field_offset(lv, fb, 6, "STT271.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT271, STT271)
//============================================================================


struct  STT281  {
  int fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT281) C1{ Fi FL:3 Fs}



static void Test_STT281()
{
  {
    init_simple_test("STT281");
    static STRUCT_IF_C STT281 lv;
    check2(sizeof(lv), 8, "sizeof(STT281)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT281)");
    check_field_offset(lv, fa, 0, "STT281.fa");
    check_field_offset(lv, fb, 6, "STT281.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT281, STT281)
//============================================================================


struct  STT291  {
  int fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT291) C1{ Fi Fs:8 Fs}



static void Test_STT291()
{
  {
    init_simple_test("STT291");
    static STRUCT_IF_C STT291 lv;
    check2(sizeof(lv), 8, "sizeof(STT291)");
    check2(__alignof__(lv), 4, "__alignof__(STT291)");
    check_field_offset(lv, fa, 0, "STT291.fa");
    check_field_offset(lv, fb, 6, "STT291.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT291, STT291)
//============================================================================


struct  STT2101  {
  int fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT2101) C1{ Fi Fi:8 Fs}



static void Test_STT2101()
{
  {
    init_simple_test("STT2101");
    static STRUCT_IF_C STT2101 lv;
    check2(sizeof(lv), 8, "sizeof(STT2101)");
    check2(__alignof__(lv), 4, "__alignof__(STT2101)");
    check_field_offset(lv, fa, 0, "STT2101.fa");
    check_field_offset(lv, fb, 6, "STT2101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2101, STT2101)
//============================================================================


struct  STT2111  {
  int fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT2111) C1{ Fi FL:8 Fs}



static void Test_STT2111()
{
  {
    init_simple_test("STT2111");
    static STRUCT_IF_C STT2111 lv;
    check2(sizeof(lv), 8, "sizeof(STT2111)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2111)");
    check_field_offset(lv, fa, 0, "STT2111.fa");
    check_field_offset(lv, fb, 6, "STT2111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2111, STT2111)
//============================================================================


struct  STT2121  {
  int fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT2121) C1{ Fi Fi:18 Fs}



static void Test_STT2121()
{
  {
    init_simple_test("STT2121");
    static STRUCT_IF_C STT2121 lv;
    check2(sizeof(lv), 12, "sizeof(STT2121)");
    check2(__alignof__(lv), 4, "__alignof__(STT2121)");
    check_field_offset(lv, fa, 0, "STT2121.fa");
    check_field_offset(lv, fb, 8, "STT2121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2121, STT2121)
//============================================================================


struct  STT2131  {
  int fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT2131) C1{ Fi FL:18 Fs}



static void Test_STT2131()
{
  {
    init_simple_test("STT2131");
    static STRUCT_IF_C STT2131 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2131)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2131)");
    check_field_offset(lv, fa, 0, "STT2131.fa");
    check_field_offset(lv, fb, 8, "STT2131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2131, STT2131)
//============================================================================


struct  STT2141  {
  int fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT2141) C1{ Fi FL:48 Fs}



static void Test_STT2141()
{
  {
    init_simple_test("STT2141");
    static STRUCT_IF_C STT2141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2141)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2141)");
    check_field_offset(lv, fa, 0, "STT2141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2141, STT2141)
//============================================================================


struct  STT2151  {
  int fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT2151) C1{ Fi Fc:3 Fs}



static void Test_STT2151()
{
  {
    init_simple_test("STT2151");
    static STRUCT_IF_C STT2151 lv;
    check2(sizeof(lv), 8, "sizeof(STT2151)");
    check2(__alignof__(lv), 4, "__alignof__(STT2151)");
    check_field_offset(lv, fa, 0, "STT2151.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2151");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2151");
    check_field_offset(lv, fb, 6, "STT2151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2151, STT2151)
//============================================================================


struct  STT2161  {
  int fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT2161) C1{ Fi Fs:3 Fs}



static void Test_STT2161()
{
  {
    init_simple_test("STT2161");
    static STRUCT_IF_C STT2161 lv;
    check2(sizeof(lv), 8, "sizeof(STT2161)");
    check2(__alignof__(lv), 4, "__alignof__(STT2161)");
    check_field_offset(lv, fa, 0, "STT2161.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2161");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2161");
    check_field_offset(lv, fb, 6, "STT2161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2161, STT2161)
//============================================================================


struct  STT2171  {
  int fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT2171) C1{ Fi Fi:3 Fs}



static void Test_STT2171()
{
  {
    init_simple_test("STT2171");
    static STRUCT_IF_C STT2171 lv;
    check2(sizeof(lv), 8, "sizeof(STT2171)");
    check2(__alignof__(lv), 4, "__alignof__(STT2171)");
    check_field_offset(lv, fa, 0, "STT2171.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2171");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2171");
    check_field_offset(lv, fb, 6, "STT2171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2171, STT2171)
//============================================================================


struct  STT2181  {
  int fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT2181) C1{ Fi FL:3 Fs}



static void Test_STT2181()
{
  {
    init_simple_test("STT2181");
    static STRUCT_IF_C STT2181 lv;
    check2(sizeof(lv), 8, "sizeof(STT2181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2181)");
    check_field_offset(lv, fa, 0, "STT2181.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2181");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2181");
    check_field_offset(lv, fb, 6, "STT2181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2181, STT2181)
//============================================================================


struct  STT2191  {
  int fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT2191) C1{ Fi Fs:8 Fs}



static void Test_STT2191()
{
  {
    init_simple_test("STT2191");
    static STRUCT_IF_C STT2191 lv;
    check2(sizeof(lv), 8, "sizeof(STT2191)");
    check2(__alignof__(lv), 4, "__alignof__(STT2191)");
    check_field_offset(lv, fa, 0, "STT2191.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2191");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2191");
    check_field_offset(lv, fb, 6, "STT2191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2191, STT2191)
//============================================================================


struct  STT2201  {
  int fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT2201) C1{ Fi Fi:8 Fs}



static void Test_STT2201()
{
  {
    init_simple_test("STT2201");
    static STRUCT_IF_C STT2201 lv;
    check2(sizeof(lv), 8, "sizeof(STT2201)");
    check2(__alignof__(lv), 4, "__alignof__(STT2201)");
    check_field_offset(lv, fa, 0, "STT2201.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2201");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2201");
    check_field_offset(lv, fb, 6, "STT2201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2201, STT2201)
//============================================================================


struct  STT2211  {
  int fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT2211) C1{ Fi FL:8 Fs}



static void Test_STT2211()
{
  {
    init_simple_test("STT2211");
    static STRUCT_IF_C STT2211 lv;
    check2(sizeof(lv), 8, "sizeof(STT2211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2211)");
    check_field_offset(lv, fa, 0, "STT2211.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2211");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2211");
    check_field_offset(lv, fb, 6, "STT2211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2211, STT2211)
//============================================================================


struct  STT2221  {
  int fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT2221) C1{ Fi Fi:18 Fs}



static void Test_STT2221()
{
  {
    init_simple_test("STT2221");
    static STRUCT_IF_C STT2221 lv;
    check2(sizeof(lv), 12, "sizeof(STT2221)");
    check2(__alignof__(lv), 4, "__alignof__(STT2221)");
    check_field_offset(lv, fa, 0, "STT2221.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2221");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2221");
    check_field_offset(lv, fb, 8, "STT2221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2221, STT2221)
//============================================================================


struct  STT2231  {
  int fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT2231) C1{ Fi FL:18 Fs}



static void Test_STT2231()
{
  {
    init_simple_test("STT2231");
    static STRUCT_IF_C STT2231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2231)");
    check_field_offset(lv, fa, 0, "STT2231.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2231");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2231");
    check_field_offset(lv, fb, 8, "STT2231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2231, STT2231)
//============================================================================


struct  STT2241  {
  int fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT2241) C1{ Fi FL:48 Fs}



static void Test_STT2241()
{
  {
    init_simple_test("STT2241");
    static STRUCT_IF_C STT2241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2241)");
    check_field_offset(lv, fa, 0, "STT2241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2241, STT2241)
//============================================================================


struct  STT212  {
  int fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT212) C1{ Fi Fc:0 Fi}



static void Test_STT212()
{
  {
    init_simple_test("STT212");
    static STRUCT_IF_C STT212 lv;
    check2(sizeof(lv), 8, "sizeof(STT212)");
    check2(__alignof__(lv), 4, "__alignof__(STT212)");
    check_field_offset(lv, fa, 0, "STT212.fa");
    check_field_offset(lv, fb, 4, "STT212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT212, STT212)
//============================================================================


struct  STT222  {
  int fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT222) C1{ Fi Fs:0 Fi}



static void Test_STT222()
{
  {
    init_simple_test("STT222");
    static STRUCT_IF_C STT222 lv;
    check2(sizeof(lv), 8, "sizeof(STT222)");
    check2(__alignof__(lv), 4, "__alignof__(STT222)");
    check_field_offset(lv, fa, 0, "STT222.fa");
    check_field_offset(lv, fb, 4, "STT222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT222, STT222)
//============================================================================


struct  STT232  {
  int fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT232) C1{ Fi Fi:0 Fi}



static void Test_STT232()
{
  {
    init_simple_test("STT232");
    static STRUCT_IF_C STT232 lv;
    check2(sizeof(lv), 8, "sizeof(STT232)");
    check2(__alignof__(lv), 4, "__alignof__(STT232)");
    check_field_offset(lv, fa, 0, "STT232.fa");
    check_field_offset(lv, fb, 4, "STT232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT232, STT232)
//============================================================================


struct  STT242  {
  int fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT242) C1{ Fi FL:0 Fi}



static void Test_STT242()
{
  {
    init_simple_test("STT242");
    static STRUCT_IF_C STT242 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT242)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT242)");
    check_field_offset(lv, fa, 0, "STT242.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT242, STT242)
//============================================================================


struct  STT252  {
  int fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT252) C1{ Fi Fc:3 Fi}



static void Test_STT252()
{
  {
    init_simple_test("STT252");
    static STRUCT_IF_C STT252 lv;
    check2(sizeof(lv), 12, "sizeof(STT252)");
    check2(__alignof__(lv), 4, "__alignof__(STT252)");
    check_field_offset(lv, fa, 0, "STT252.fa");
    check_field_offset(lv, fb, 8, "STT252.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT252, STT252)
//============================================================================


struct  STT262  {
  int fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT262) C1{ Fi Fs:3 Fi}



static void Test_STT262()
{
  {
    init_simple_test("STT262");
    static STRUCT_IF_C STT262 lv;
    check2(sizeof(lv), 12, "sizeof(STT262)");
    check2(__alignof__(lv), 4, "__alignof__(STT262)");
    check_field_offset(lv, fa, 0, "STT262.fa");
    check_field_offset(lv, fb, 8, "STT262.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT262, STT262)
//============================================================================


struct  STT272  {
  int fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT272) C1{ Fi Fi:3 Fi}



static void Test_STT272()
{
  {
    init_simple_test("STT272");
    static STRUCT_IF_C STT272 lv;
    check2(sizeof(lv), 12, "sizeof(STT272)");
    check2(__alignof__(lv), 4, "__alignof__(STT272)");
    check_field_offset(lv, fa, 0, "STT272.fa");
    check_field_offset(lv, fb, 8, "STT272.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT272, STT272)
//============================================================================


struct  STT282  {
  int fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT282) C1{ Fi FL:3 Fi}



static void Test_STT282()
{
  {
    init_simple_test("STT282");
    static STRUCT_IF_C STT282 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT282)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT282)");
    check_field_offset(lv, fa, 0, "STT282.fa");
    check_field_offset(lv, fb, 8, "STT282.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT282, STT282)
//============================================================================


struct  STT292  {
  int fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT292) C1{ Fi Fs:8 Fi}



static void Test_STT292()
{
  {
    init_simple_test("STT292");
    static STRUCT_IF_C STT292 lv;
    check2(sizeof(lv), 12, "sizeof(STT292)");
    check2(__alignof__(lv), 4, "__alignof__(STT292)");
    check_field_offset(lv, fa, 0, "STT292.fa");
    check_field_offset(lv, fb, 8, "STT292.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT292, STT292)
//============================================================================


struct  STT2102  {
  int fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT2102) C1{ Fi Fi:8 Fi}



static void Test_STT2102()
{
  {
    init_simple_test("STT2102");
    static STRUCT_IF_C STT2102 lv;
    check2(sizeof(lv), 12, "sizeof(STT2102)");
    check2(__alignof__(lv), 4, "__alignof__(STT2102)");
    check_field_offset(lv, fa, 0, "STT2102.fa");
    check_field_offset(lv, fb, 8, "STT2102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2102, STT2102)
//============================================================================


struct  STT2112  {
  int fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT2112) C1{ Fi FL:8 Fi}



static void Test_STT2112()
{
  {
    init_simple_test("STT2112");
    static STRUCT_IF_C STT2112 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2112)");
    check_field_offset(lv, fa, 0, "STT2112.fa");
    check_field_offset(lv, fb, 8, "STT2112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2112, STT2112)
//============================================================================


struct  STT2122  {
  int fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT2122) C1{ Fi Fi:18 Fi}



static void Test_STT2122()
{
  {
    init_simple_test("STT2122");
    static STRUCT_IF_C STT2122 lv;
    check2(sizeof(lv), 12, "sizeof(STT2122)");
    check2(__alignof__(lv), 4, "__alignof__(STT2122)");
    check_field_offset(lv, fa, 0, "STT2122.fa");
    check_field_offset(lv, fb, 8, "STT2122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2122, STT2122)
//============================================================================


struct  STT2132  {
  int fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT2132) C1{ Fi FL:18 Fi}



static void Test_STT2132()
{
  {
    init_simple_test("STT2132");
    static STRUCT_IF_C STT2132 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2132)");
    check_field_offset(lv, fa, 0, "STT2132.fa");
    check_field_offset(lv, fb, 8, "STT2132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2132, STT2132)
//============================================================================


struct  STT2142  {
  int fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT2142) C1{ Fi FL:48 Fi}



static void Test_STT2142()
{
  {
    init_simple_test("STT2142");
    static STRUCT_IF_C STT2142 lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(STT2142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2142)");
    check_field_offset(lv, fa, 0, "STT2142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2142, STT2142)
//============================================================================


struct  STT2152  {
  int fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT2152) C1{ Fi Fc:3 Fi}



static void Test_STT2152()
{
  {
    init_simple_test("STT2152");
    static STRUCT_IF_C STT2152 lv;
    check2(sizeof(lv), 12, "sizeof(STT2152)");
    check2(__alignof__(lv), 4, "__alignof__(STT2152)");
    check_field_offset(lv, fa, 0, "STT2152.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2152");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2152");
    check_field_offset(lv, fb, 8, "STT2152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2152, STT2152)
//============================================================================


struct  STT2162  {
  int fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT2162) C1{ Fi Fs:3 Fi}



static void Test_STT2162()
{
  {
    init_simple_test("STT2162");
    static STRUCT_IF_C STT2162 lv;
    check2(sizeof(lv), 12, "sizeof(STT2162)");
    check2(__alignof__(lv), 4, "__alignof__(STT2162)");
    check_field_offset(lv, fa, 0, "STT2162.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2162");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2162");
    check_field_offset(lv, fb, 8, "STT2162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2162, STT2162)
//============================================================================


struct  STT2172  {
  int fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT2172) C1{ Fi Fi:3 Fi}



static void Test_STT2172()
{
  {
    init_simple_test("STT2172");
    static STRUCT_IF_C STT2172 lv;
    check2(sizeof(lv), 12, "sizeof(STT2172)");
    check2(__alignof__(lv), 4, "__alignof__(STT2172)");
    check_field_offset(lv, fa, 0, "STT2172.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2172");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2172");
    check_field_offset(lv, fb, 8, "STT2172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2172, STT2172)
//============================================================================


struct  STT2182  {
  int fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT2182) C1{ Fi FL:3 Fi}



static void Test_STT2182()
{
  {
    init_simple_test("STT2182");
    static STRUCT_IF_C STT2182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2182)");
    check_field_offset(lv, fa, 0, "STT2182.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2182");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2182");
    check_field_offset(lv, fb, 8, "STT2182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2182, STT2182)
//============================================================================


struct  STT2192  {
  int fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT2192) C1{ Fi Fs:8 Fi}



static void Test_STT2192()
{
  {
    init_simple_test("STT2192");
    static STRUCT_IF_C STT2192 lv;
    check2(sizeof(lv), 12, "sizeof(STT2192)");
    check2(__alignof__(lv), 4, "__alignof__(STT2192)");
    check_field_offset(lv, fa, 0, "STT2192.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2192");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2192");
    check_field_offset(lv, fb, 8, "STT2192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2192, STT2192)
//============================================================================


struct  STT2202  {
  int fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT2202) C1{ Fi Fi:8 Fi}



static void Test_STT2202()
{
  {
    init_simple_test("STT2202");
    static STRUCT_IF_C STT2202 lv;
    check2(sizeof(lv), 12, "sizeof(STT2202)");
    check2(__alignof__(lv), 4, "__alignof__(STT2202)");
    check_field_offset(lv, fa, 0, "STT2202.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2202");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2202");
    check_field_offset(lv, fb, 8, "STT2202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2202, STT2202)
//============================================================================


struct  STT2212  {
  int fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT2212) C1{ Fi FL:8 Fi}



static void Test_STT2212()
{
  {
    init_simple_test("STT2212");
    static STRUCT_IF_C STT2212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2212)");
    check_field_offset(lv, fa, 0, "STT2212.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2212");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2212");
    check_field_offset(lv, fb, 8, "STT2212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2212, STT2212)
//============================================================================


struct  STT2222  {
  int fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT2222) C1{ Fi Fi:18 Fi}



static void Test_STT2222()
{
  {
    init_simple_test("STT2222");
    static STRUCT_IF_C STT2222 lv;
    check2(sizeof(lv), 12, "sizeof(STT2222)");
    check2(__alignof__(lv), 4, "__alignof__(STT2222)");
    check_field_offset(lv, fa, 0, "STT2222.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2222");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2222");
    check_field_offset(lv, fb, 8, "STT2222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2222, STT2222)
//============================================================================


struct  STT2232  {
  int fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT2232) C1{ Fi FL:18 Fi}



static void Test_STT2232()
{
  {
    init_simple_test("STT2232");
    static STRUCT_IF_C STT2232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2232)");
    check_field_offset(lv, fa, 0, "STT2232.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2232");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2232");
    check_field_offset(lv, fb, 8, "STT2232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2232, STT2232)
//============================================================================


struct  STT2242  {
  int fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT2242) C1{ Fi FL:48 Fi}



static void Test_STT2242()
{
  {
    init_simple_test("STT2242");
    static STRUCT_IF_C STT2242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2242)");
    check_field_offset(lv, fa, 0, "STT2242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2242, STT2242)
//============================================================================


struct  STT213  {
  int fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT213) C1{ Fi Fc:0 Fl}



static void Test_STT213()
{
  {
    init_simple_test("STT213");
    static STRUCT_IF_C STT213 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT213)");
    check_field_offset(lv, fa, 0, "STT213.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT213, STT213)
//============================================================================


struct  STT223  {
  int fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT223) C1{ Fi Fs:0 Fl}



static void Test_STT223()
{
  {
    init_simple_test("STT223");
    static STRUCT_IF_C STT223 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT223)");
    check_field_offset(lv, fa, 0, "STT223.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT223, STT223)
//============================================================================


struct  STT233  {
  int fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT233) C1{ Fi Fi:0 Fl}



static void Test_STT233()
{
  {
    init_simple_test("STT233");
    static STRUCT_IF_C STT233 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT233)");
    check_field_offset(lv, fa, 0, "STT233.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT233, STT233)
//============================================================================


struct  STT243  {
  int fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT243) C1{ Fi FL:0 Fl}



static void Test_STT243()
{
  {
    init_simple_test("STT243");
    static STRUCT_IF_C STT243 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT243)");
    check_field_offset(lv, fa, 0, "STT243.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT243, STT243)
//============================================================================


struct  STT253  {
  int fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT253) C1{ Fi Fc:3 Fl}



static void Test_STT253()
{
  {
    init_simple_test("STT253");
    static STRUCT_IF_C STT253 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT253)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT253)");
    check_field_offset(lv, fa, 0, "STT253.fa");
    check_field_offset(lv, fb, 8, "STT253.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT253, STT253)
//============================================================================


struct  STT263  {
  int fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT263) C1{ Fi Fs:3 Fl}



static void Test_STT263()
{
  {
    init_simple_test("STT263");
    static STRUCT_IF_C STT263 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT263)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT263)");
    check_field_offset(lv, fa, 0, "STT263.fa");
    check_field_offset(lv, fb, 8, "STT263.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT263, STT263)
//============================================================================


struct  STT273  {
  int fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT273) C1{ Fi Fi:3 Fl}



static void Test_STT273()
{
  {
    init_simple_test("STT273");
    static STRUCT_IF_C STT273 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT273)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT273)");
    check_field_offset(lv, fa, 0, "STT273.fa");
    check_field_offset(lv, fb, 8, "STT273.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT273, STT273)
//============================================================================


struct  STT283  {
  int fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT283) C1{ Fi FL:3 Fl}



static void Test_STT283()
{
  {
    init_simple_test("STT283");
    static STRUCT_IF_C STT283 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT283)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT283)");
    check_field_offset(lv, fa, 0, "STT283.fa");
    check_field_offset(lv, fb, 8, "STT283.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT283, STT283)
//============================================================================


struct  STT293  {
  int fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT293) C1{ Fi Fs:8 Fl}



static void Test_STT293()
{
  {
    init_simple_test("STT293");
    static STRUCT_IF_C STT293 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT293)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT293)");
    check_field_offset(lv, fa, 0, "STT293.fa");
    check_field_offset(lv, fb, 8, "STT293.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT293, STT293)
//============================================================================


struct  STT2103  {
  int fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT2103) C1{ Fi Fi:8 Fl}



static void Test_STT2103()
{
  {
    init_simple_test("STT2103");
    static STRUCT_IF_C STT2103 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2103)");
    check_field_offset(lv, fa, 0, "STT2103.fa");
    check_field_offset(lv, fb, 8, "STT2103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2103, STT2103)
//============================================================================


struct  STT2113  {
  int fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT2113) C1{ Fi FL:8 Fl}



static void Test_STT2113()
{
  {
    init_simple_test("STT2113");
    static STRUCT_IF_C STT2113 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2113)");
    check_field_offset(lv, fa, 0, "STT2113.fa");
    check_field_offset(lv, fb, 8, "STT2113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2113, STT2113)
//============================================================================


struct  STT2123  {
  int fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT2123) C1{ Fi Fi:18 Fl}



static void Test_STT2123()
{
  {
    init_simple_test("STT2123");
    static STRUCT_IF_C STT2123 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2123)");
    check_field_offset(lv, fa, 0, "STT2123.fa");
    check_field_offset(lv, fb, 8, "STT2123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2123, STT2123)
//============================================================================


struct  STT2133  {
  int fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT2133) C1{ Fi FL:18 Fl}



static void Test_STT2133()
{
  {
    init_simple_test("STT2133");
    static STRUCT_IF_C STT2133 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2133)");
    check_field_offset(lv, fa, 0, "STT2133.fa");
    check_field_offset(lv, fb, 8, "STT2133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2133, STT2133)
//============================================================================


struct  STT2143  {
  int fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT2143) C1{ Fi FL:48 Fl}



static void Test_STT2143()
{
  {
    init_simple_test("STT2143");
    static STRUCT_IF_C STT2143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2143)");
    check_field_offset(lv, fa, 0, "STT2143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2143, STT2143)
//============================================================================


struct  STT2153  {
  int fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT2153) C1{ Fi Fc:3 Fl}



static void Test_STT2153()
{
  {
    init_simple_test("STT2153");
    static STRUCT_IF_C STT2153 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2153)");
    check_field_offset(lv, fa, 0, "STT2153.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2153");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2153");
    check_field_offset(lv, fb, 8, "STT2153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2153, STT2153)
//============================================================================


struct  STT2163  {
  int fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT2163) C1{ Fi Fs:3 Fl}



static void Test_STT2163()
{
  {
    init_simple_test("STT2163");
    static STRUCT_IF_C STT2163 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2163)");
    check_field_offset(lv, fa, 0, "STT2163.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2163");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2163");
    check_field_offset(lv, fb, 8, "STT2163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2163, STT2163)
//============================================================================


struct  STT2173  {
  int fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT2173) C1{ Fi Fi:3 Fl}



static void Test_STT2173()
{
  {
    init_simple_test("STT2173");
    static STRUCT_IF_C STT2173 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2173)");
    check_field_offset(lv, fa, 0, "STT2173.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2173");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2173");
    check_field_offset(lv, fb, 8, "STT2173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2173, STT2173)
//============================================================================


struct  STT2183  {
  int fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT2183) C1{ Fi FL:3 Fl}



static void Test_STT2183()
{
  {
    init_simple_test("STT2183");
    static STRUCT_IF_C STT2183 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2183)");
    check_field_offset(lv, fa, 0, "STT2183.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2183");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2183");
    check_field_offset(lv, fb, 8, "STT2183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2183, STT2183)
//============================================================================


struct  STT2193  {
  int fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT2193) C1{ Fi Fs:8 Fl}



static void Test_STT2193()
{
  {
    init_simple_test("STT2193");
    static STRUCT_IF_C STT2193 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2193)");
    check_field_offset(lv, fa, 0, "STT2193.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2193");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2193");
    check_field_offset(lv, fb, 8, "STT2193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2193, STT2193)
//============================================================================


struct  STT2203  {
  int fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT2203) C1{ Fi Fi:8 Fl}



static void Test_STT2203()
{
  {
    init_simple_test("STT2203");
    static STRUCT_IF_C STT2203 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2203)");
    check_field_offset(lv, fa, 0, "STT2203.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2203");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2203");
    check_field_offset(lv, fb, 8, "STT2203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2203, STT2203)
//============================================================================


struct  STT2213  {
  int fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT2213) C1{ Fi FL:8 Fl}



static void Test_STT2213()
{
  {
    init_simple_test("STT2213");
    static STRUCT_IF_C STT2213 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2213)");
    check_field_offset(lv, fa, 0, "STT2213.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2213");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2213");
    check_field_offset(lv, fb, 8, "STT2213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2213, STT2213)
//============================================================================


struct  STT2223  {
  int fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT2223) C1{ Fi Fi:18 Fl}



static void Test_STT2223()
{
  {
    init_simple_test("STT2223");
    static STRUCT_IF_C STT2223 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2223)");
    check_field_offset(lv, fa, 0, "STT2223.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2223");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2223");
    check_field_offset(lv, fb, 8, "STT2223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2223, STT2223)
//============================================================================


struct  STT2233  {
  int fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT2233) C1{ Fi FL:18 Fl}



static void Test_STT2233()
{
  {
    init_simple_test("STT2233");
    static STRUCT_IF_C STT2233 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2233)");
    check_field_offset(lv, fa, 0, "STT2233.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2233");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2233");
    check_field_offset(lv, fb, 8, "STT2233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2233, STT2233)
//============================================================================


struct  STT2243  {
  int fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT2243) C1{ Fi FL:48 Fl}



static void Test_STT2243()
{
  {
    init_simple_test("STT2243");
    static STRUCT_IF_C STT2243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2243)");
    check_field_offset(lv, fa, 0, "STT2243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2243, STT2243)
//============================================================================


struct  STT214  {
  int fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT214) C1{ Fi Fc:0 FL}



static void Test_STT214()
{
  {
    init_simple_test("STT214");
    static STRUCT_IF_C STT214 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT214)");
    check_field_offset(lv, fa, 0, "STT214.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT214, STT214)
//============================================================================


struct  STT224  {
  int fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT224) C1{ Fi Fs:0 FL}



static void Test_STT224()
{
  {
    init_simple_test("STT224");
    static STRUCT_IF_C STT224 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT224)");
    check_field_offset(lv, fa, 0, "STT224.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT224, STT224)
//============================================================================


struct  STT234  {
  int fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT234) C1{ Fi Fi:0 FL}



static void Test_STT234()
{
  {
    init_simple_test("STT234");
    static STRUCT_IF_C STT234 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT234)");
    check_field_offset(lv, fa, 0, "STT234.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT234, STT234)
//============================================================================


struct  STT244  {
  int fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT244) C1{ Fi FL:0 FL}



static void Test_STT244()
{
  {
    init_simple_test("STT244");
    static STRUCT_IF_C STT244 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT244)");
    check_field_offset(lv, fa, 0, "STT244.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT244, STT244)
//============================================================================


struct  STT254  {
  int fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT254) C1{ Fi Fc:3 FL}



static void Test_STT254()
{
  {
    init_simple_test("STT254");
    static STRUCT_IF_C STT254 lv;
    check2(sizeof(lv), 16, "sizeof(STT254)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT254)");
    check_field_offset(lv, fa, 0, "STT254.fa");
    check_field_offset(lv, fb, 8, "STT254.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT254, STT254)
//============================================================================


struct  STT264  {
  int fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT264) C1{ Fi Fs:3 FL}



static void Test_STT264()
{
  {
    init_simple_test("STT264");
    static STRUCT_IF_C STT264 lv;
    check2(sizeof(lv), 16, "sizeof(STT264)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT264)");
    check_field_offset(lv, fa, 0, "STT264.fa");
    check_field_offset(lv, fb, 8, "STT264.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT264, STT264)
//============================================================================


struct  STT274  {
  int fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT274) C1{ Fi Fi:3 FL}



static void Test_STT274()
{
  {
    init_simple_test("STT274");
    static STRUCT_IF_C STT274 lv;
    check2(sizeof(lv), 16, "sizeof(STT274)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT274)");
    check_field_offset(lv, fa, 0, "STT274.fa");
    check_field_offset(lv, fb, 8, "STT274.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT274, STT274)
//============================================================================


struct  STT284  {
  int fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT284) C1{ Fi FL:3 FL}



static void Test_STT284()
{
  {
    init_simple_test("STT284");
    static STRUCT_IF_C STT284 lv;
    check2(sizeof(lv), 16, "sizeof(STT284)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT284)");
    check_field_offset(lv, fa, 0, "STT284.fa");
    check_field_offset(lv, fb, 8, "STT284.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT284, STT284)
//============================================================================


struct  STT294  {
  int fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT294) C1{ Fi Fs:8 FL}



static void Test_STT294()
{
  {
    init_simple_test("STT294");
    static STRUCT_IF_C STT294 lv;
    check2(sizeof(lv), 16, "sizeof(STT294)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT294)");
    check_field_offset(lv, fa, 0, "STT294.fa");
    check_field_offset(lv, fb, 8, "STT294.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT294, STT294)
//============================================================================


struct  STT2104  {
  int fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT2104) C1{ Fi Fi:8 FL}



static void Test_STT2104()
{
  {
    init_simple_test("STT2104");
    static STRUCT_IF_C STT2104 lv;
    check2(sizeof(lv), 16, "sizeof(STT2104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2104)");
    check_field_offset(lv, fa, 0, "STT2104.fa");
    check_field_offset(lv, fb, 8, "STT2104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2104, STT2104)
//============================================================================


struct  STT2114  {
  int fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT2114) C1{ Fi FL:8 FL}



static void Test_STT2114()
{
  {
    init_simple_test("STT2114");
    static STRUCT_IF_C STT2114 lv;
    check2(sizeof(lv), 16, "sizeof(STT2114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2114)");
    check_field_offset(lv, fa, 0, "STT2114.fa");
    check_field_offset(lv, fb, 8, "STT2114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2114, STT2114)
//============================================================================


struct  STT2124  {
  int fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT2124) C1{ Fi Fi:18 FL}



static void Test_STT2124()
{
  {
    init_simple_test("STT2124");
    static STRUCT_IF_C STT2124 lv;
    check2(sizeof(lv), 16, "sizeof(STT2124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2124)");
    check_field_offset(lv, fa, 0, "STT2124.fa");
    check_field_offset(lv, fb, 8, "STT2124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2124, STT2124)
//============================================================================


struct  STT2134  {
  int fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT2134) C1{ Fi FL:18 FL}



static void Test_STT2134()
{
  {
    init_simple_test("STT2134");
    static STRUCT_IF_C STT2134 lv;
    check2(sizeof(lv), 16, "sizeof(STT2134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2134)");
    check_field_offset(lv, fa, 0, "STT2134.fa");
    check_field_offset(lv, fb, 8, "STT2134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2134, STT2134)
//============================================================================


struct  STT2144  {
  int fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT2144) C1{ Fi FL:48 FL}



static void Test_STT2144()
{
  {
    init_simple_test("STT2144");
    static STRUCT_IF_C STT2144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2144)");
    check_field_offset(lv, fa, 0, "STT2144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2144, STT2144)
//============================================================================


struct  STT2154  {
  int fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT2154) C1{ Fi Fc:3 FL}



static void Test_STT2154()
{
  {
    init_simple_test("STT2154");
    static STRUCT_IF_C STT2154 lv;
    check2(sizeof(lv), 16, "sizeof(STT2154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2154)");
    check_field_offset(lv, fa, 0, "STT2154.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2154");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2154");
    check_field_offset(lv, fb, 8, "STT2154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2154, STT2154)
//============================================================================


struct  STT2164  {
  int fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT2164) C1{ Fi Fs:3 FL}



static void Test_STT2164()
{
  {
    init_simple_test("STT2164");
    static STRUCT_IF_C STT2164 lv;
    check2(sizeof(lv), 16, "sizeof(STT2164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2164)");
    check_field_offset(lv, fa, 0, "STT2164.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2164");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2164");
    check_field_offset(lv, fb, 8, "STT2164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2164, STT2164)
//============================================================================


struct  STT2174  {
  int fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT2174) C1{ Fi Fi:3 FL}



static void Test_STT2174()
{
  {
    init_simple_test("STT2174");
    static STRUCT_IF_C STT2174 lv;
    check2(sizeof(lv), 16, "sizeof(STT2174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2174)");
    check_field_offset(lv, fa, 0, "STT2174.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2174");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2174");
    check_field_offset(lv, fb, 8, "STT2174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2174, STT2174)
//============================================================================


struct  STT2184  {
  int fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT2184) C1{ Fi FL:3 FL}



static void Test_STT2184()
{
  {
    init_simple_test("STT2184");
    static STRUCT_IF_C STT2184 lv;
    check2(sizeof(lv), 16, "sizeof(STT2184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2184)");
    check_field_offset(lv, fa, 0, "STT2184.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2184");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2184");
    check_field_offset(lv, fb, 8, "STT2184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2184, STT2184)
//============================================================================


struct  STT2194  {
  int fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT2194) C1{ Fi Fs:8 FL}



static void Test_STT2194()
{
  {
    init_simple_test("STT2194");
    static STRUCT_IF_C STT2194 lv;
    check2(sizeof(lv), 16, "sizeof(STT2194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2194)");
    check_field_offset(lv, fa, 0, "STT2194.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2194");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2194");
    check_field_offset(lv, fb, 8, "STT2194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2194, STT2194)
//============================================================================


struct  STT2204  {
  int fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT2204) C1{ Fi Fi:8 FL}



static void Test_STT2204()
{
  {
    init_simple_test("STT2204");
    static STRUCT_IF_C STT2204 lv;
    check2(sizeof(lv), 16, "sizeof(STT2204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2204)");
    check_field_offset(lv, fa, 0, "STT2204.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2204");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2204");
    check_field_offset(lv, fb, 8, "STT2204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2204, STT2204)
//============================================================================


struct  STT2214  {
  int fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT2214) C1{ Fi FL:8 FL}



static void Test_STT2214()
{
  {
    init_simple_test("STT2214");
    static STRUCT_IF_C STT2214 lv;
    check2(sizeof(lv), 16, "sizeof(STT2214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2214)");
    check_field_offset(lv, fa, 0, "STT2214.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2214");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2214");
    check_field_offset(lv, fb, 8, "STT2214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2214, STT2214)
//============================================================================


struct  STT2224  {
  int fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT2224) C1{ Fi Fi:18 FL}



static void Test_STT2224()
{
  {
    init_simple_test("STT2224");
    static STRUCT_IF_C STT2224 lv;
    check2(sizeof(lv), 16, "sizeof(STT2224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2224)");
    check_field_offset(lv, fa, 0, "STT2224.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2224");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2224");
    check_field_offset(lv, fb, 8, "STT2224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2224, STT2224)
//============================================================================


struct  STT2234  {
  int fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT2234) C1{ Fi FL:18 FL}



static void Test_STT2234()
{
  {
    init_simple_test("STT2234");
    static STRUCT_IF_C STT2234 lv;
    check2(sizeof(lv), 16, "sizeof(STT2234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2234)");
    check_field_offset(lv, fa, 0, "STT2234.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2234");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2234");
    check_field_offset(lv, fb, 8, "STT2234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2234, STT2234)
//============================================================================


struct  STT2244  {
  int fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT2244) C1{ Fi FL:48 FL}



static void Test_STT2244()
{
  {
    init_simple_test("STT2244");
    static STRUCT_IF_C STT2244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2244)");
    check_field_offset(lv, fa, 0, "STT2244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2244, STT2244)
//============================================================================


struct  STT215  {
  int fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT215) C1{ Fi Fc:0 Fp}



static void Test_STT215()
{
  {
    init_simple_test("STT215");
    static STRUCT_IF_C STT215 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT215)");
    check_field_offset(lv, fa, 0, "STT215.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT215, STT215)
//============================================================================


struct  STT225  {
  int fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT225) C1{ Fi Fs:0 Fp}



static void Test_STT225()
{
  {
    init_simple_test("STT225");
    static STRUCT_IF_C STT225 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT225)");
    check_field_offset(lv, fa, 0, "STT225.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT225, STT225)
//============================================================================


struct  STT235  {
  int fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT235) C1{ Fi Fi:0 Fp}



static void Test_STT235()
{
  {
    init_simple_test("STT235");
    static STRUCT_IF_C STT235 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT235)");
    check_field_offset(lv, fa, 0, "STT235.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT235, STT235)
//============================================================================


struct  STT245  {
  int fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT245) C1{ Fi FL:0 Fp}



static void Test_STT245()
{
  {
    init_simple_test("STT245");
    static STRUCT_IF_C STT245 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT245)");
    check_field_offset(lv, fa, 0, "STT245.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT245, STT245)
//============================================================================


struct  STT255  {
  int fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT255) C1{ Fi Fc:3 Fp}



static void Test_STT255()
{
  {
    init_simple_test("STT255");
    static STRUCT_IF_C STT255 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT255)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT255)");
    check_field_offset(lv, fa, 0, "STT255.fa");
    check_field_offset(lv, fb, 8, "STT255.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT255, STT255)
//============================================================================


struct  STT265  {
  int fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT265) C1{ Fi Fs:3 Fp}



static void Test_STT265()
{
  {
    init_simple_test("STT265");
    static STRUCT_IF_C STT265 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT265)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT265)");
    check_field_offset(lv, fa, 0, "STT265.fa");
    check_field_offset(lv, fb, 8, "STT265.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT265, STT265)
//============================================================================


struct  STT275  {
  int fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT275) C1{ Fi Fi:3 Fp}



static void Test_STT275()
{
  {
    init_simple_test("STT275");
    static STRUCT_IF_C STT275 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT275)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT275)");
    check_field_offset(lv, fa, 0, "STT275.fa");
    check_field_offset(lv, fb, 8, "STT275.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT275, STT275)
//============================================================================


struct  STT285  {
  int fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT285) C1{ Fi FL:3 Fp}



static void Test_STT285()
{
  {
    init_simple_test("STT285");
    static STRUCT_IF_C STT285 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT285)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT285)");
    check_field_offset(lv, fa, 0, "STT285.fa");
    check_field_offset(lv, fb, 8, "STT285.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT285, STT285)
//============================================================================


struct  STT295  {
  int fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT295) C1{ Fi Fs:8 Fp}



static void Test_STT295()
{
  {
    init_simple_test("STT295");
    static STRUCT_IF_C STT295 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT295)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT295)");
    check_field_offset(lv, fa, 0, "STT295.fa");
    check_field_offset(lv, fb, 8, "STT295.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT295, STT295)
//============================================================================


struct  STT2105  {
  int fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT2105) C1{ Fi Fi:8 Fp}



static void Test_STT2105()
{
  {
    init_simple_test("STT2105");
    static STRUCT_IF_C STT2105 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2105)");
    check_field_offset(lv, fa, 0, "STT2105.fa");
    check_field_offset(lv, fb, 8, "STT2105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2105, STT2105)
//============================================================================


struct  STT2115  {
  int fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT2115) C1{ Fi FL:8 Fp}



static void Test_STT2115()
{
  {
    init_simple_test("STT2115");
    static STRUCT_IF_C STT2115 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2115)");
    check_field_offset(lv, fa, 0, "STT2115.fa");
    check_field_offset(lv, fb, 8, "STT2115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2115, STT2115)
//============================================================================


struct  STT2125  {
  int fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT2125) C1{ Fi Fi:18 Fp}



static void Test_STT2125()
{
  {
    init_simple_test("STT2125");
    static STRUCT_IF_C STT2125 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2125)");
    check_field_offset(lv, fa, 0, "STT2125.fa");
    check_field_offset(lv, fb, 8, "STT2125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2125, STT2125)
//============================================================================


struct  STT2135  {
  int fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT2135) C1{ Fi FL:18 Fp}



static void Test_STT2135()
{
  {
    init_simple_test("STT2135");
    static STRUCT_IF_C STT2135 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2135)");
    check_field_offset(lv, fa, 0, "STT2135.fa");
    check_field_offset(lv, fb, 8, "STT2135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2135, STT2135)
//============================================================================


struct  STT2145  {
  int fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT2145) C1{ Fi FL:48 Fp}



static void Test_STT2145()
{
  {
    init_simple_test("STT2145");
    static STRUCT_IF_C STT2145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2145)");
    check_field_offset(lv, fa, 0, "STT2145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2145, STT2145)
//============================================================================


struct  STT2155  {
  int fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT2155) C1{ Fi Fc:3 Fp}



static void Test_STT2155()
{
  {
    init_simple_test("STT2155");
    static STRUCT_IF_C STT2155 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2155)");
    check_field_offset(lv, fa, 0, "STT2155.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2155");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2155");
    check_field_offset(lv, fb, 8, "STT2155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2155, STT2155)
//============================================================================


struct  STT2165  {
  int fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT2165) C1{ Fi Fs:3 Fp}



static void Test_STT2165()
{
  {
    init_simple_test("STT2165");
    static STRUCT_IF_C STT2165 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2165)");
    check_field_offset(lv, fa, 0, "STT2165.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2165");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2165");
    check_field_offset(lv, fb, 8, "STT2165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2165, STT2165)
//============================================================================


struct  STT2175  {
  int fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT2175) C1{ Fi Fi:3 Fp}



static void Test_STT2175()
{
  {
    init_simple_test("STT2175");
    static STRUCT_IF_C STT2175 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2175)");
    check_field_offset(lv, fa, 0, "STT2175.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2175");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2175");
    check_field_offset(lv, fb, 8, "STT2175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2175, STT2175)
//============================================================================


struct  STT2185  {
  int fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT2185) C1{ Fi FL:3 Fp}



static void Test_STT2185()
{
  {
    init_simple_test("STT2185");
    static STRUCT_IF_C STT2185 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2185)");
    check_field_offset(lv, fa, 0, "STT2185.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2185");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2185");
    check_field_offset(lv, fb, 8, "STT2185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2185, STT2185)
//============================================================================


struct  STT2195  {
  int fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT2195) C1{ Fi Fs:8 Fp}



static void Test_STT2195()
{
  {
    init_simple_test("STT2195");
    static STRUCT_IF_C STT2195 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2195)");
    check_field_offset(lv, fa, 0, "STT2195.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2195");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2195");
    check_field_offset(lv, fb, 8, "STT2195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2195, STT2195)
//============================================================================


struct  STT2205  {
  int fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT2205) C1{ Fi Fi:8 Fp}



static void Test_STT2205()
{
  {
    init_simple_test("STT2205");
    static STRUCT_IF_C STT2205 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2205)");
    check_field_offset(lv, fa, 0, "STT2205.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2205");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2205");
    check_field_offset(lv, fb, 8, "STT2205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2205, STT2205)
//============================================================================


struct  STT2215  {
  int fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT2215) C1{ Fi FL:8 Fp}



static void Test_STT2215()
{
  {
    init_simple_test("STT2215");
    static STRUCT_IF_C STT2215 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2215)");
    check_field_offset(lv, fa, 0, "STT2215.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2215");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2215");
    check_field_offset(lv, fb, 8, "STT2215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2215, STT2215)
//============================================================================


struct  STT2225  {
  int fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT2225) C1{ Fi Fi:18 Fp}



static void Test_STT2225()
{
  {
    init_simple_test("STT2225");
    static STRUCT_IF_C STT2225 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2225)");
    check_field_offset(lv, fa, 0, "STT2225.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2225");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2225");
    check_field_offset(lv, fb, 8, "STT2225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2225, STT2225)
//============================================================================


struct  STT2235  {
  int fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT2235) C1{ Fi FL:18 Fp}



static void Test_STT2235()
{
  {
    init_simple_test("STT2235");
    static STRUCT_IF_C STT2235 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2235)");
    check_field_offset(lv, fa, 0, "STT2235.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2235");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2235");
    check_field_offset(lv, fb, 8, "STT2235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2235, STT2235)
//============================================================================


struct  STT2245  {
  int fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT2245) C1{ Fi FL:48 Fp}



static void Test_STT2245()
{
  {
    init_simple_test("STT2245");
    static STRUCT_IF_C STT2245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2245)");
    check_field_offset(lv, fa, 0, "STT2245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2245, STT2245)
//============================================================================


struct  STT216  {
  int fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT216) C1{ Fi Fc:0 Fi}



static void Test_STT216()
{
  {
    init_simple_test("STT216");
    static STRUCT_IF_C STT216 lv;
    check2(sizeof(lv), 8, "sizeof(STT216)");
    check2(__alignof__(lv), 4, "__alignof__(STT216)");
    check_field_offset(lv, fa, 0, "STT216.fa");
    check_field_offset(lv, fb, 4, "STT216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT216, STT216)
//============================================================================


struct  STT226  {
  int fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT226) C1{ Fi Fs:0 Fi}



static void Test_STT226()
{
  {
    init_simple_test("STT226");
    static STRUCT_IF_C STT226 lv;
    check2(sizeof(lv), 8, "sizeof(STT226)");
    check2(__alignof__(lv), 4, "__alignof__(STT226)");
    check_field_offset(lv, fa, 0, "STT226.fa");
    check_field_offset(lv, fb, 4, "STT226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT226, STT226)
//============================================================================


struct  STT236  {
  int fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT236) C1{ Fi Fi:0 Fi}



static void Test_STT236()
{
  {
    init_simple_test("STT236");
    static STRUCT_IF_C STT236 lv;
    check2(sizeof(lv), 8, "sizeof(STT236)");
    check2(__alignof__(lv), 4, "__alignof__(STT236)");
    check_field_offset(lv, fa, 0, "STT236.fa");
    check_field_offset(lv, fb, 4, "STT236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT236, STT236)
//============================================================================


struct  STT246  {
  int fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT246) C1{ Fi FL:0 Fi}



static void Test_STT246()
{
  {
    init_simple_test("STT246");
    static STRUCT_IF_C STT246 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT246)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT246)");
    check_field_offset(lv, fa, 0, "STT246.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT246, STT246)
//============================================================================


struct  STT256  {
  int fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT256) C1{ Fi Fc:3 Fi}



static void Test_STT256()
{
  {
    init_simple_test("STT256");
    static STRUCT_IF_C STT256 lv;
    check2(sizeof(lv), 12, "sizeof(STT256)");
    check2(__alignof__(lv), 4, "__alignof__(STT256)");
    check_field_offset(lv, fa, 0, "STT256.fa");
    check_field_offset(lv, fb, 8, "STT256.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT256, STT256)
//============================================================================


struct  STT266  {
  int fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT266) C1{ Fi Fs:3 Fi}



static void Test_STT266()
{
  {
    init_simple_test("STT266");
    static STRUCT_IF_C STT266 lv;
    check2(sizeof(lv), 12, "sizeof(STT266)");
    check2(__alignof__(lv), 4, "__alignof__(STT266)");
    check_field_offset(lv, fa, 0, "STT266.fa");
    check_field_offset(lv, fb, 8, "STT266.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT266, STT266)
//============================================================================


struct  STT276  {
  int fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT276) C1{ Fi Fi:3 Fi}



static void Test_STT276()
{
  {
    init_simple_test("STT276");
    static STRUCT_IF_C STT276 lv;
    check2(sizeof(lv), 12, "sizeof(STT276)");
    check2(__alignof__(lv), 4, "__alignof__(STT276)");
    check_field_offset(lv, fa, 0, "STT276.fa");
    check_field_offset(lv, fb, 8, "STT276.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT276, STT276)
//============================================================================


struct  STT286  {
  int fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT286) C1{ Fi FL:3 Fi}



static void Test_STT286()
{
  {
    init_simple_test("STT286");
    static STRUCT_IF_C STT286 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT286)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT286)");
    check_field_offset(lv, fa, 0, "STT286.fa");
    check_field_offset(lv, fb, 8, "STT286.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT286, STT286)
//============================================================================


struct  STT296  {
  int fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT296) C1{ Fi Fs:8 Fi}



static void Test_STT296()
{
  {
    init_simple_test("STT296");
    static STRUCT_IF_C STT296 lv;
    check2(sizeof(lv), 12, "sizeof(STT296)");
    check2(__alignof__(lv), 4, "__alignof__(STT296)");
    check_field_offset(lv, fa, 0, "STT296.fa");
    check_field_offset(lv, fb, 8, "STT296.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT296, STT296)
//============================================================================


struct  STT2106  {
  int fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT2106) C1{ Fi Fi:8 Fi}



static void Test_STT2106()
{
  {
    init_simple_test("STT2106");
    static STRUCT_IF_C STT2106 lv;
    check2(sizeof(lv), 12, "sizeof(STT2106)");
    check2(__alignof__(lv), 4, "__alignof__(STT2106)");
    check_field_offset(lv, fa, 0, "STT2106.fa");
    check_field_offset(lv, fb, 8, "STT2106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2106, STT2106)
//============================================================================


struct  STT2116  {
  int fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT2116) C1{ Fi FL:8 Fi}



static void Test_STT2116()
{
  {
    init_simple_test("STT2116");
    static STRUCT_IF_C STT2116 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2116)");
    check_field_offset(lv, fa, 0, "STT2116.fa");
    check_field_offset(lv, fb, 8, "STT2116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2116, STT2116)
//============================================================================


struct  STT2126  {
  int fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT2126) C1{ Fi Fi:18 Fi}



static void Test_STT2126()
{
  {
    init_simple_test("STT2126");
    static STRUCT_IF_C STT2126 lv;
    check2(sizeof(lv), 12, "sizeof(STT2126)");
    check2(__alignof__(lv), 4, "__alignof__(STT2126)");
    check_field_offset(lv, fa, 0, "STT2126.fa");
    check_field_offset(lv, fb, 8, "STT2126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2126, STT2126)
//============================================================================


struct  STT2136  {
  int fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT2136) C1{ Fi FL:18 Fi}



static void Test_STT2136()
{
  {
    init_simple_test("STT2136");
    static STRUCT_IF_C STT2136 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2136)");
    check_field_offset(lv, fa, 0, "STT2136.fa");
    check_field_offset(lv, fb, 8, "STT2136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2136, STT2136)
//============================================================================


struct  STT2146  {
  int fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT2146) C1{ Fi FL:48 Fi}



static void Test_STT2146()
{
  {
    init_simple_test("STT2146");
    static STRUCT_IF_C STT2146 lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(STT2146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2146)");
    check_field_offset(lv, fa, 0, "STT2146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2146, STT2146)
//============================================================================


struct  STT2156  {
  int fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT2156) C1{ Fi Fc:3 Fi}



static void Test_STT2156()
{
  {
    init_simple_test("STT2156");
    static STRUCT_IF_C STT2156 lv;
    check2(sizeof(lv), 12, "sizeof(STT2156)");
    check2(__alignof__(lv), 4, "__alignof__(STT2156)");
    check_field_offset(lv, fa, 0, "STT2156.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2156");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2156");
    check_field_offset(lv, fb, 8, "STT2156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2156, STT2156)
//============================================================================


struct  STT2166  {
  int fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT2166) C1{ Fi Fs:3 Fi}



static void Test_STT2166()
{
  {
    init_simple_test("STT2166");
    static STRUCT_IF_C STT2166 lv;
    check2(sizeof(lv), 12, "sizeof(STT2166)");
    check2(__alignof__(lv), 4, "__alignof__(STT2166)");
    check_field_offset(lv, fa, 0, "STT2166.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2166");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2166");
    check_field_offset(lv, fb, 8, "STT2166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2166, STT2166)
//============================================================================


struct  STT2176  {
  int fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT2176) C1{ Fi Fi:3 Fi}



static void Test_STT2176()
{
  {
    init_simple_test("STT2176");
    static STRUCT_IF_C STT2176 lv;
    check2(sizeof(lv), 12, "sizeof(STT2176)");
    check2(__alignof__(lv), 4, "__alignof__(STT2176)");
    check_field_offset(lv, fa, 0, "STT2176.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2176");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2176");
    check_field_offset(lv, fb, 8, "STT2176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2176, STT2176)
//============================================================================


struct  STT2186  {
  int fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT2186) C1{ Fi FL:3 Fi}



static void Test_STT2186()
{
  {
    init_simple_test("STT2186");
    static STRUCT_IF_C STT2186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2186)");
    check_field_offset(lv, fa, 0, "STT2186.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2186");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2186");
    check_field_offset(lv, fb, 8, "STT2186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2186, STT2186)
//============================================================================


struct  STT2196  {
  int fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT2196) C1{ Fi Fs:8 Fi}



static void Test_STT2196()
{
  {
    init_simple_test("STT2196");
    static STRUCT_IF_C STT2196 lv;
    check2(sizeof(lv), 12, "sizeof(STT2196)");
    check2(__alignof__(lv), 4, "__alignof__(STT2196)");
    check_field_offset(lv, fa, 0, "STT2196.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2196");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2196");
    check_field_offset(lv, fb, 8, "STT2196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2196, STT2196)
//============================================================================


struct  STT2206  {
  int fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT2206) C1{ Fi Fi:8 Fi}



static void Test_STT2206()
{
  {
    init_simple_test("STT2206");
    static STRUCT_IF_C STT2206 lv;
    check2(sizeof(lv), 12, "sizeof(STT2206)");
    check2(__alignof__(lv), 4, "__alignof__(STT2206)");
    check_field_offset(lv, fa, 0, "STT2206.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2206");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2206");
    check_field_offset(lv, fb, 8, "STT2206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2206, STT2206)
//============================================================================


struct  STT2216  {
  int fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT2216) C1{ Fi FL:8 Fi}



static void Test_STT2216()
{
  {
    init_simple_test("STT2216");
    static STRUCT_IF_C STT2216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2216)");
    check_field_offset(lv, fa, 0, "STT2216.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2216");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2216");
    check_field_offset(lv, fb, 8, "STT2216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2216, STT2216)
//============================================================================


struct  STT2226  {
  int fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT2226) C1{ Fi Fi:18 Fi}



static void Test_STT2226()
{
  {
    init_simple_test("STT2226");
    static STRUCT_IF_C STT2226 lv;
    check2(sizeof(lv), 12, "sizeof(STT2226)");
    check2(__alignof__(lv), 4, "__alignof__(STT2226)");
    check_field_offset(lv, fa, 0, "STT2226.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2226");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2226");
    check_field_offset(lv, fb, 8, "STT2226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2226, STT2226)
//============================================================================


struct  STT2236  {
  int fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT2236) C1{ Fi FL:18 Fi}



static void Test_STT2236()
{
  {
    init_simple_test("STT2236");
    static STRUCT_IF_C STT2236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2236)");
    check_field_offset(lv, fa, 0, "STT2236.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2236");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2236");
    check_field_offset(lv, fb, 8, "STT2236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2236, STT2236)
//============================================================================


struct  STT2246  {
  int fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT2246) C1{ Fi FL:48 Fi}



static void Test_STT2246()
{
  {
    init_simple_test("STT2246");
    static STRUCT_IF_C STT2246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2246)");
    check_field_offset(lv, fa, 0, "STT2246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2246, STT2246)
//============================================================================


struct  STT217  {
  int fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT217) C1{ Fi Fc:0 FL}



static void Test_STT217()
{
  {
    init_simple_test("STT217");
    static STRUCT_IF_C STT217 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT217)");
    check_field_offset(lv, fa, 0, "STT217.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT217, STT217)
//============================================================================


struct  STT227  {
  int fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT227) C1{ Fi Fs:0 FL}



static void Test_STT227()
{
  {
    init_simple_test("STT227");
    static STRUCT_IF_C STT227 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT227)");
    check_field_offset(lv, fa, 0, "STT227.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT227, STT227)
//============================================================================


struct  STT237  {
  int fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT237) C1{ Fi Fi:0 FL}



static void Test_STT237()
{
  {
    init_simple_test("STT237");
    static STRUCT_IF_C STT237 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT237)");
    check_field_offset(lv, fa, 0, "STT237.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT237, STT237)
//============================================================================


struct  STT247  {
  int fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT247) C1{ Fi FL:0 FL}



static void Test_STT247()
{
  {
    init_simple_test("STT247");
    static STRUCT_IF_C STT247 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT247)");
    check_field_offset(lv, fa, 0, "STT247.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT247, STT247)
//============================================================================


struct  STT257  {
  int fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT257) C1{ Fi Fc:3 FL}



static void Test_STT257()
{
  {
    init_simple_test("STT257");
    static STRUCT_IF_C STT257 lv;
    check2(sizeof(lv), 16, "sizeof(STT257)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT257)");
    check_field_offset(lv, fa, 0, "STT257.fa");
    check_field_offset(lv, fb, 8, "STT257.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT257, STT257)
//============================================================================


struct  STT267  {
  int fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT267) C1{ Fi Fs:3 FL}



static void Test_STT267()
{
  {
    init_simple_test("STT267");
    static STRUCT_IF_C STT267 lv;
    check2(sizeof(lv), 16, "sizeof(STT267)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT267)");
    check_field_offset(lv, fa, 0, "STT267.fa");
    check_field_offset(lv, fb, 8, "STT267.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT267, STT267)
//============================================================================


struct  STT277  {
  int fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT277) C1{ Fi Fi:3 FL}



static void Test_STT277()
{
  {
    init_simple_test("STT277");
    static STRUCT_IF_C STT277 lv;
    check2(sizeof(lv), 16, "sizeof(STT277)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT277)");
    check_field_offset(lv, fa, 0, "STT277.fa");
    check_field_offset(lv, fb, 8, "STT277.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT277, STT277)
//============================================================================


struct  STT287  {
  int fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT287) C1{ Fi FL:3 FL}



static void Test_STT287()
{
  {
    init_simple_test("STT287");
    static STRUCT_IF_C STT287 lv;
    check2(sizeof(lv), 16, "sizeof(STT287)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT287)");
    check_field_offset(lv, fa, 0, "STT287.fa");
    check_field_offset(lv, fb, 8, "STT287.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT287, STT287)
//============================================================================


struct  STT297  {
  int fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT297) C1{ Fi Fs:8 FL}



static void Test_STT297()
{
  {
    init_simple_test("STT297");
    static STRUCT_IF_C STT297 lv;
    check2(sizeof(lv), 16, "sizeof(STT297)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT297)");
    check_field_offset(lv, fa, 0, "STT297.fa");
    check_field_offset(lv, fb, 8, "STT297.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT297, STT297)
//============================================================================


struct  STT2107  {
  int fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT2107) C1{ Fi Fi:8 FL}



static void Test_STT2107()
{
  {
    init_simple_test("STT2107");
    static STRUCT_IF_C STT2107 lv;
    check2(sizeof(lv), 16, "sizeof(STT2107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2107)");
    check_field_offset(lv, fa, 0, "STT2107.fa");
    check_field_offset(lv, fb, 8, "STT2107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2107, STT2107)
//============================================================================


struct  STT2117  {
  int fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT2117) C1{ Fi FL:8 FL}



static void Test_STT2117()
{
  {
    init_simple_test("STT2117");
    static STRUCT_IF_C STT2117 lv;
    check2(sizeof(lv), 16, "sizeof(STT2117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2117)");
    check_field_offset(lv, fa, 0, "STT2117.fa");
    check_field_offset(lv, fb, 8, "STT2117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2117, STT2117)
//============================================================================


struct  STT2127  {
  int fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT2127) C1{ Fi Fi:18 FL}



static void Test_STT2127()
{
  {
    init_simple_test("STT2127");
    static STRUCT_IF_C STT2127 lv;
    check2(sizeof(lv), 16, "sizeof(STT2127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2127)");
    check_field_offset(lv, fa, 0, "STT2127.fa");
    check_field_offset(lv, fb, 8, "STT2127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2127, STT2127)
//============================================================================


struct  STT2137  {
  int fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT2137) C1{ Fi FL:18 FL}



static void Test_STT2137()
{
  {
    init_simple_test("STT2137");
    static STRUCT_IF_C STT2137 lv;
    check2(sizeof(lv), 16, "sizeof(STT2137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2137)");
    check_field_offset(lv, fa, 0, "STT2137.fa");
    check_field_offset(lv, fb, 8, "STT2137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2137, STT2137)
//============================================================================


struct  STT2147  {
  int fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT2147) C1{ Fi FL:48 FL}



static void Test_STT2147()
{
  {
    init_simple_test("STT2147");
    static STRUCT_IF_C STT2147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2147)");
    check_field_offset(lv, fa, 0, "STT2147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2147, STT2147)
//============================================================================


struct  STT2157  {
  int fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT2157) C1{ Fi Fc:3 FL}



static void Test_STT2157()
{
  {
    init_simple_test("STT2157");
    static STRUCT_IF_C STT2157 lv;
    check2(sizeof(lv), 16, "sizeof(STT2157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2157)");
    check_field_offset(lv, fa, 0, "STT2157.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2157");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2157");
    check_field_offset(lv, fb, 8, "STT2157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2157, STT2157)
//============================================================================


struct  STT2167  {
  int fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT2167) C1{ Fi Fs:3 FL}



static void Test_STT2167()
{
  {
    init_simple_test("STT2167");
    static STRUCT_IF_C STT2167 lv;
    check2(sizeof(lv), 16, "sizeof(STT2167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2167)");
    check_field_offset(lv, fa, 0, "STT2167.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2167");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2167");
    check_field_offset(lv, fb, 8, "STT2167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2167, STT2167)
//============================================================================


struct  STT2177  {
  int fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT2177) C1{ Fi Fi:3 FL}



static void Test_STT2177()
{
  {
    init_simple_test("STT2177");
    static STRUCT_IF_C STT2177 lv;
    check2(sizeof(lv), 16, "sizeof(STT2177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2177)");
    check_field_offset(lv, fa, 0, "STT2177.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2177");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2177");
    check_field_offset(lv, fb, 8, "STT2177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2177, STT2177)
//============================================================================


struct  STT2187  {
  int fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT2187) C1{ Fi FL:3 FL}



static void Test_STT2187()
{
  {
    init_simple_test("STT2187");
    static STRUCT_IF_C STT2187 lv;
    check2(sizeof(lv), 16, "sizeof(STT2187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2187)");
    check_field_offset(lv, fa, 0, "STT2187.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2187");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2187");
    check_field_offset(lv, fb, 8, "STT2187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2187, STT2187)
//============================================================================


struct  STT2197  {
  int fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT2197) C1{ Fi Fs:8 FL}



static void Test_STT2197()
{
  {
    init_simple_test("STT2197");
    static STRUCT_IF_C STT2197 lv;
    check2(sizeof(lv), 16, "sizeof(STT2197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2197)");
    check_field_offset(lv, fa, 0, "STT2197.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2197");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2197");
    check_field_offset(lv, fb, 8, "STT2197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2197, STT2197)
//============================================================================


struct  STT2207  {
  int fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT2207) C1{ Fi Fi:8 FL}



static void Test_STT2207()
{
  {
    init_simple_test("STT2207");
    static STRUCT_IF_C STT2207 lv;
    check2(sizeof(lv), 16, "sizeof(STT2207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2207)");
    check_field_offset(lv, fa, 0, "STT2207.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2207");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2207");
    check_field_offset(lv, fb, 8, "STT2207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2207, STT2207)
//============================================================================


struct  STT2217  {
  int fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT2217) C1{ Fi FL:8 FL}



static void Test_STT2217()
{
  {
    init_simple_test("STT2217");
    static STRUCT_IF_C STT2217 lv;
    check2(sizeof(lv), 16, "sizeof(STT2217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2217)");
    check_field_offset(lv, fa, 0, "STT2217.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2217");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2217");
    check_field_offset(lv, fb, 8, "STT2217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2217, STT2217)
//============================================================================


struct  STT2227  {
  int fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT2227) C1{ Fi Fi:18 FL}



static void Test_STT2227()
{
  {
    init_simple_test("STT2227");
    static STRUCT_IF_C STT2227 lv;
    check2(sizeof(lv), 16, "sizeof(STT2227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2227)");
    check_field_offset(lv, fa, 0, "STT2227.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2227");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2227");
    check_field_offset(lv, fb, 8, "STT2227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2227, STT2227)
//============================================================================


struct  STT2237  {
  int fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT2237) C1{ Fi FL:18 FL}



static void Test_STT2237()
{
  {
    init_simple_test("STT2237");
    static STRUCT_IF_C STT2237 lv;
    check2(sizeof(lv), 16, "sizeof(STT2237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2237)");
    check_field_offset(lv, fa, 0, "STT2237.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2237");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2237");
    check_field_offset(lv, fb, 8, "STT2237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2237, STT2237)
//============================================================================


struct  STT2247  {
  int fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT2247) C1{ Fi FL:48 FL}



static void Test_STT2247()
{
  {
    init_simple_test("STT2247");
    static STRUCT_IF_C STT2247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2247)");
    check_field_offset(lv, fa, 0, "STT2247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2247, STT2247)
//============================================================================


struct  STT218  {
  int fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT218) C1{ Fi Fc:0 FD}



static void Test_STT218()
{
  {
    init_simple_test("STT218");
    static STRUCT_IF_C STT218 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT218)");
    check_field_offset(lv, fa, 0, "STT218.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT218, STT218)
//============================================================================


struct  STT228  {
  int fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT228) C1{ Fi Fs:0 FD}



static void Test_STT228()
{
  {
    init_simple_test("STT228");
    static STRUCT_IF_C STT228 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT228)");
    check_field_offset(lv, fa, 0, "STT228.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT228, STT228)
//============================================================================


struct  STT238  {
  int fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT238) C1{ Fi Fi:0 FD}



static void Test_STT238()
{
  {
    init_simple_test("STT238");
    static STRUCT_IF_C STT238 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT238)");
    check_field_offset(lv, fa, 0, "STT238.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT238, STT238)
//============================================================================


struct  STT248  {
  int fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT248) C1{ Fi FL:0 FD}



static void Test_STT248()
{
  {
    init_simple_test("STT248");
    static STRUCT_IF_C STT248 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT248)");
    check_field_offset(lv, fa, 0, "STT248.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT248, STT248)
//============================================================================


struct  STT258  {
  int fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT258) C1{ Fi Fc:3 FD}



static void Test_STT258()
{
  {
    init_simple_test("STT258");
    static STRUCT_IF_C STT258 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT258)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT258)");
    check_field_offset(lv, fa, 0, "STT258.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT258.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT258, STT258)
//============================================================================


struct  STT268  {
  int fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT268) C1{ Fi Fs:3 FD}



static void Test_STT268()
{
  {
    init_simple_test("STT268");
    static STRUCT_IF_C STT268 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT268)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT268)");
    check_field_offset(lv, fa, 0, "STT268.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT268.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT268, STT268)
//============================================================================


struct  STT278  {
  int fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT278) C1{ Fi Fi:3 FD}



static void Test_STT278()
{
  {
    init_simple_test("STT278");
    static STRUCT_IF_C STT278 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT278)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT278)");
    check_field_offset(lv, fa, 0, "STT278.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT278.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT278, STT278)
//============================================================================


struct  STT288  {
  int fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT288) C1{ Fi FL:3 FD}



static void Test_STT288()
{
  {
    init_simple_test("STT288");
    static STRUCT_IF_C STT288 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT288)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT288)");
    check_field_offset(lv, fa, 0, "STT288.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT288.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT288, STT288)
//============================================================================


struct  STT298  {
  int fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT298) C1{ Fi Fs:8 FD}



static void Test_STT298()
{
  {
    init_simple_test("STT298");
    static STRUCT_IF_C STT298 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT298)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT298)");
    check_field_offset(lv, fa, 0, "STT298.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT298.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT298, STT298)
//============================================================================


struct  STT2108  {
  int fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT2108) C1{ Fi Fi:8 FD}



static void Test_STT2108()
{
  {
    init_simple_test("STT2108");
    static STRUCT_IF_C STT2108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2108)");
    check_field_offset(lv, fa, 0, "STT2108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2108, STT2108)
//============================================================================


struct  STT2118  {
  int fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT2118) C1{ Fi FL:8 FD}



static void Test_STT2118()
{
  {
    init_simple_test("STT2118");
    static STRUCT_IF_C STT2118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2118)");
    check_field_offset(lv, fa, 0, "STT2118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2118, STT2118)
//============================================================================


struct  STT2128  {
  int fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT2128) C1{ Fi Fi:18 FD}



static void Test_STT2128()
{
  {
    init_simple_test("STT2128");
    static STRUCT_IF_C STT2128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2128)");
    check_field_offset(lv, fa, 0, "STT2128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2128, STT2128)
//============================================================================


struct  STT2138  {
  int fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT2138) C1{ Fi FL:18 FD}



static void Test_STT2138()
{
  {
    init_simple_test("STT2138");
    static STRUCT_IF_C STT2138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2138)");
    check_field_offset(lv, fa, 0, "STT2138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2138, STT2138)
//============================================================================


struct  STT2148  {
  int fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT2148) C1{ Fi FL:48 FD}



static void Test_STT2148()
{
  {
    init_simple_test("STT2148");
    static STRUCT_IF_C STT2148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT2148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2148)");
    check_field_offset(lv, fa, 0, "STT2148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2148, STT2148)
//============================================================================


struct  STT2158  {
  int fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT2158) C1{ Fi Fc:3 FD}



static void Test_STT2158()
{
  {
    init_simple_test("STT2158");
    static STRUCT_IF_C STT2158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2158)");
    check_field_offset(lv, fa, 0, "STT2158.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2158");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2158, STT2158)
//============================================================================


struct  STT2168  {
  int fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT2168) C1{ Fi Fs:3 FD}



static void Test_STT2168()
{
  {
    init_simple_test("STT2168");
    static STRUCT_IF_C STT2168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2168)");
    check_field_offset(lv, fa, 0, "STT2168.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2168");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2168, STT2168)
//============================================================================


struct  STT2178  {
  int fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT2178) C1{ Fi Fi:3 FD}



static void Test_STT2178()
{
  {
    init_simple_test("STT2178");
    static STRUCT_IF_C STT2178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2178)");
    check_field_offset(lv, fa, 0, "STT2178.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2178");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2178, STT2178)
//============================================================================


struct  STT2188  {
  int fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT2188) C1{ Fi FL:3 FD}



static void Test_STT2188()
{
  {
    init_simple_test("STT2188");
    static STRUCT_IF_C STT2188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2188)");
    check_field_offset(lv, fa, 0, "STT2188.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2188");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2188, STT2188)
//============================================================================


struct  STT2198  {
  int fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT2198) C1{ Fi Fs:8 FD}



static void Test_STT2198()
{
  {
    init_simple_test("STT2198");
    static STRUCT_IF_C STT2198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2198)");
    check_field_offset(lv, fa, 0, "STT2198.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2198");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2198, STT2198)
//============================================================================


struct  STT2208  {
  int fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT2208) C1{ Fi Fi:8 FD}



static void Test_STT2208()
{
  {
    init_simple_test("STT2208");
    static STRUCT_IF_C STT2208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2208)");
    check_field_offset(lv, fa, 0, "STT2208.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2208");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2208, STT2208)
//============================================================================


struct  STT2218  {
  int fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT2218) C1{ Fi FL:8 FD}



static void Test_STT2218()
{
  {
    init_simple_test("STT2218");
    static STRUCT_IF_C STT2218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2218)");
    check_field_offset(lv, fa, 0, "STT2218.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2218");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2218, STT2218)
//============================================================================


struct  STT2228  {
  int fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT2228) C1{ Fi Fi:18 FD}



static void Test_STT2228()
{
  {
    init_simple_test("STT2228");
    static STRUCT_IF_C STT2228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2228)");
    check_field_offset(lv, fa, 0, "STT2228.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2228");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2228, STT2228)
//============================================================================


struct  STT2238  {
  int fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT2238) C1{ Fi FL:18 FD}



static void Test_STT2238()
{
  {
    init_simple_test("STT2238");
    static STRUCT_IF_C STT2238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2238)");
    check_field_offset(lv, fa, 0, "STT2238.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2238");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2238, STT2238)
//============================================================================


struct  STT2248  {
  int fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT2248) C1{ Fi FL:48 FD}



static void Test_STT2248()
{
  {
    init_simple_test("STT2248");
    static STRUCT_IF_C STT2248 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT2248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2248)");
    check_field_offset(lv, fa, 0, "STT2248.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2248");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2248");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2248, STT2248)
//============================================================================


struct  STT219  {
  int fa;
  unsigned char  :0;
};
//SIG(1 STT219) C1{ Fi Fc:0}



static void Test_STT219()
{
  {
    init_simple_test("STT219");
    static STRUCT_IF_C STT219 lv;
    check2(sizeof(lv), 4, "sizeof(STT219)");
    check2(__alignof__(lv), 4, "__alignof__(STT219)");
    check_field_offset(lv, fa, 0, "STT219.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT219, STT219)
//============================================================================


struct  STT229  {
  int fa;
  unsigned short  :0;
};
//SIG(1 STT229) C1{ Fi Fs:0}



static void Test_STT229()
{
  {
    init_simple_test("STT229");
    static STRUCT_IF_C STT229 lv;
    check2(sizeof(lv), 4, "sizeof(STT229)");
    check2(__alignof__(lv), 4, "__alignof__(STT229)");
    check_field_offset(lv, fa, 0, "STT229.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT229, STT229)
//============================================================================


struct  STT239  {
  int fa;
  unsigned int  :0;
};
//SIG(1 STT239) C1{ Fi Fi:0}



static void Test_STT239()
{
  {
    init_simple_test("STT239");
    static STRUCT_IF_C STT239 lv;
    check2(sizeof(lv), 4, "sizeof(STT239)");
    check2(__alignof__(lv), 4, "__alignof__(STT239)");
    check_field_offset(lv, fa, 0, "STT239.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT239, STT239)
//============================================================================


struct  STT249  {
  int fa;
  __tsu64  :0;
};
//SIG(1 STT249) C1{ Fi FL:0}



static void Test_STT249()
{
  {
    init_simple_test("STT249");
    static STRUCT_IF_C STT249 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT249)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT249)");
    check_field_offset(lv, fa, 0, "STT249.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT249, STT249)
//============================================================================


struct  STT259  {
  int fa;
  unsigned char  :3;
};
//SIG(1 STT259) C1{ Fi Fc:3}



static void Test_STT259()
{
  {
    init_simple_test("STT259");
    static STRUCT_IF_C STT259 lv;
    check2(sizeof(lv), 8, "sizeof(STT259)");
    check2(__alignof__(lv), 4, "__alignof__(STT259)");
    check_field_offset(lv, fa, 0, "STT259.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT259, STT259)
//============================================================================


struct  STT269  {
  int fa;
  unsigned short  :3;
};
//SIG(1 STT269) C1{ Fi Fs:3}



static void Test_STT269()
{
  {
    init_simple_test("STT269");
    static STRUCT_IF_C STT269 lv;
    check2(sizeof(lv), 8, "sizeof(STT269)");
    check2(__alignof__(lv), 4, "__alignof__(STT269)");
    check_field_offset(lv, fa, 0, "STT269.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT269, STT269)
//============================================================================


struct  STT279  {
  int fa;
  unsigned int  :3;
};
//SIG(1 STT279) C1{ Fi Fi:3}



static void Test_STT279()
{
  {
    init_simple_test("STT279");
    static STRUCT_IF_C STT279 lv;
    check2(sizeof(lv), 8, "sizeof(STT279)");
    check2(__alignof__(lv), 4, "__alignof__(STT279)");
    check_field_offset(lv, fa, 0, "STT279.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT279, STT279)
//============================================================================


struct  STT289  {
  int fa;
  __tsu64  :3;
};
//SIG(1 STT289) C1{ Fi FL:3}



static void Test_STT289()
{
  {
    init_simple_test("STT289");
    static STRUCT_IF_C STT289 lv;
    check2(sizeof(lv), 8, "sizeof(STT289)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT289)");
    check_field_offset(lv, fa, 0, "STT289.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT289, STT289)
//============================================================================


struct  STT299  {
  int fa;
  unsigned short  :8;
};
//SIG(1 STT299) C1{ Fi Fs:8}



static void Test_STT299()
{
  {
    init_simple_test("STT299");
    static STRUCT_IF_C STT299 lv;
    check2(sizeof(lv), 8, "sizeof(STT299)");
    check2(__alignof__(lv), 4, "__alignof__(STT299)");
    check_field_offset(lv, fa, 0, "STT299.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT299, STT299)
//============================================================================


struct  STT2109  {
  int fa;
  unsigned int  :8;
};
//SIG(1 STT2109) C1{ Fi Fi:8}



static void Test_STT2109()
{
  {
    init_simple_test("STT2109");
    static STRUCT_IF_C STT2109 lv;
    check2(sizeof(lv), 8, "sizeof(STT2109)");
    check2(__alignof__(lv), 4, "__alignof__(STT2109)");
    check_field_offset(lv, fa, 0, "STT2109.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2109, STT2109)
//============================================================================


struct  STT2119  {
  int fa;
  __tsu64  :8;
};
//SIG(1 STT2119) C1{ Fi FL:8}



static void Test_STT2119()
{
  {
    init_simple_test("STT2119");
    static STRUCT_IF_C STT2119 lv;
    check2(sizeof(lv), 8, "sizeof(STT2119)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2119)");
    check_field_offset(lv, fa, 0, "STT2119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2119, STT2119)
//============================================================================


struct  STT2129  {
  int fa;
  unsigned int  :18;
};
//SIG(1 STT2129) C1{ Fi Fi:18}



static void Test_STT2129()
{
  {
    init_simple_test("STT2129");
    static STRUCT_IF_C STT2129 lv;
    check2(sizeof(lv), 8, "sizeof(STT2129)");
    check2(__alignof__(lv), 4, "__alignof__(STT2129)");
    check_field_offset(lv, fa, 0, "STT2129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2129, STT2129)
//============================================================================


struct  STT2139  {
  int fa;
  __tsu64  :18;
};
//SIG(1 STT2139) C1{ Fi FL:18}



static void Test_STT2139()
{
  {
    init_simple_test("STT2139");
    static STRUCT_IF_C STT2139 lv;
    check2(sizeof(lv), 8, "sizeof(STT2139)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2139)");
    check_field_offset(lv, fa, 0, "STT2139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2139, STT2139)
//============================================================================


struct  STT2149  {
  int fa;
  __tsu64  :48;
};
//SIG(1 STT2149) C1{ Fi FL:48}



static void Test_STT2149()
{
  {
    init_simple_test("STT2149");
    static STRUCT_IF_C STT2149 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2149)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2149)");
    check_field_offset(lv, fa, 0, "STT2149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2149, STT2149)
//============================================================================


struct  STT2159  {
  int fa;
  unsigned char bf:3;
};
//SIG(1 STT2159) C1{ Fi Fc:3}



static void Test_STT2159()
{
  {
    init_simple_test("STT2159");
    static STRUCT_IF_C STT2159 lv;
    check2(sizeof(lv), 8, "sizeof(STT2159)");
    check2(__alignof__(lv), 4, "__alignof__(STT2159)");
    check_field_offset(lv, fa, 0, "STT2159.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2159");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2159");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2159, STT2159)
//============================================================================


struct  STT2169  {
  int fa;
  unsigned short bf:3;
};
//SIG(1 STT2169) C1{ Fi Fs:3}



static void Test_STT2169()
{
  {
    init_simple_test("STT2169");
    static STRUCT_IF_C STT2169 lv;
    check2(sizeof(lv), 8, "sizeof(STT2169)");
    check2(__alignof__(lv), 4, "__alignof__(STT2169)");
    check_field_offset(lv, fa, 0, "STT2169.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2169");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2169");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2169, STT2169)
//============================================================================


struct  STT2179  {
  int fa;
  unsigned int bf:3;
};
//SIG(1 STT2179) C1{ Fi Fi:3}



static void Test_STT2179()
{
  {
    init_simple_test("STT2179");
    static STRUCT_IF_C STT2179 lv;
    check2(sizeof(lv), 8, "sizeof(STT2179)");
    check2(__alignof__(lv), 4, "__alignof__(STT2179)");
    check_field_offset(lv, fa, 0, "STT2179.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2179");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2179");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2179, STT2179)
//============================================================================


struct  STT2189  {
  int fa;
  __tsu64 bf:3;
};
//SIG(1 STT2189) C1{ Fi FL:3}



static void Test_STT2189()
{
  {
    init_simple_test("STT2189");
    static STRUCT_IF_C STT2189 lv;
    check2(sizeof(lv), 8, "sizeof(STT2189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2189)");
    check_field_offset(lv, fa, 0, "STT2189.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2189");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2189");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2189, STT2189)
//============================================================================


struct  STT2199  {
  int fa;
  unsigned short bf:8;
};
//SIG(1 STT2199) C1{ Fi Fs:8}



static void Test_STT2199()
{
  {
    init_simple_test("STT2199");
    static STRUCT_IF_C STT2199 lv;
    check2(sizeof(lv), 8, "sizeof(STT2199)");
    check2(__alignof__(lv), 4, "__alignof__(STT2199)");
    check_field_offset(lv, fa, 0, "STT2199.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2199");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2199");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2199, STT2199)
//============================================================================


struct  STT2209  {
  int fa;
  unsigned int bf:8;
};
//SIG(1 STT2209) C1{ Fi Fi:8}



static void Test_STT2209()
{
  {
    init_simple_test("STT2209");
    static STRUCT_IF_C STT2209 lv;
    check2(sizeof(lv), 8, "sizeof(STT2209)");
    check2(__alignof__(lv), 4, "__alignof__(STT2209)");
    check_field_offset(lv, fa, 0, "STT2209.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2209");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2209");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2209, STT2209)
//============================================================================


struct  STT2219  {
  int fa;
  __tsu64 bf:8;
};
//SIG(1 STT2219) C1{ Fi FL:8}



static void Test_STT2219()
{
  {
    init_simple_test("STT2219");
    static STRUCT_IF_C STT2219 lv;
    check2(sizeof(lv), 8, "sizeof(STT2219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2219)");
    check_field_offset(lv, fa, 0, "STT2219.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2219");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2219");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2219, STT2219)
//============================================================================


struct  STT2229  {
  int fa;
  unsigned int bf:18;
};
//SIG(1 STT2229) C1{ Fi Fi:18}



static void Test_STT2229()
{
  {
    init_simple_test("STT2229");
    static STRUCT_IF_C STT2229 lv;
    check2(sizeof(lv), 8, "sizeof(STT2229)");
    check2(__alignof__(lv), 4, "__alignof__(STT2229)");
    check_field_offset(lv, fa, 0, "STT2229.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2229");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2229");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2229, STT2229)
//============================================================================


struct  STT2239  {
  int fa;
  __tsu64 bf:18;
};
//SIG(1 STT2239) C1{ Fi FL:18}



static void Test_STT2239()
{
  {
    init_simple_test("STT2239");
    static STRUCT_IF_C STT2239 lv;
    check2(sizeof(lv), 8, "sizeof(STT2239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2239)");
    check_field_offset(lv, fa, 0, "STT2239.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2239");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2239");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2239, STT2239)
//============================================================================


struct  STT2249  {
  int fa;
  __tsu64 bf:48;
};
//SIG(1 STT2249) C1{ Fi FL:48}



static void Test_STT2249()
{
  {
    init_simple_test("STT2249");
    static STRUCT_IF_C STT2249 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2249)");
    check_field_offset(lv, fa, 0, "STT2249.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2249");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2249");
  }
}
ARRANGE_TO_CALL_ME(Test_STT2249, STT2249)
//============================================================================


struct  STT310  {
  long fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT310) C1{ Fl Fc:0 Fc}



static void Test_STT310()
{
  {
    init_simple_test("STT310");
    static STRUCT_IF_C STT310 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT310)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT310)");
    check_field_offset(lv, fa, 0, "STT310.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT310.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT310, STT310)
//============================================================================


struct  STT320  {
  long fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT320) C1{ Fl Fs:0 Fc}



static void Test_STT320()
{
  {
    init_simple_test("STT320");
    static STRUCT_IF_C STT320 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT320)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT320)");
    check_field_offset(lv, fa, 0, "STT320.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT320.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT320, STT320)
//============================================================================


struct  STT330  {
  long fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT330) C1{ Fl Fi:0 Fc}



static void Test_STT330()
{
  {
    init_simple_test("STT330");
    static STRUCT_IF_C STT330 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT330)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT330)");
    check_field_offset(lv, fa, 0, "STT330.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT330.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT330, STT330)
//============================================================================


struct  STT340  {
  long fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT340) C1{ Fl FL:0 Fc}



static void Test_STT340()
{
  {
    init_simple_test("STT340");
    static STRUCT_IF_C STT340 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT340)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT340)");
    check_field_offset(lv, fa, 0, "STT340.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT340.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT340, STT340)
//============================================================================


struct  STT350  {
  long fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT350) C1{ Fl Fc:3 Fc}



static void Test_STT350()
{
  {
    init_simple_test("STT350");
    static STRUCT_IF_C STT350 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT350)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT350)");
    check_field_offset(lv, fa, 0, "STT350.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT350.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT350, STT350)
//============================================================================


struct  STT360  {
  long fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT360) C1{ Fl Fs:3 Fc}



static void Test_STT360()
{
  {
    init_simple_test("STT360");
    static STRUCT_IF_C STT360 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT360)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT360)");
    check_field_offset(lv, fa, 0, "STT360.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT360.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT360, STT360)
//============================================================================


struct  STT370  {
  long fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT370) C1{ Fl Fi:3 Fc}



static void Test_STT370()
{
  {
    init_simple_test("STT370");
    static STRUCT_IF_C STT370 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT370)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT370)");
    check_field_offset(lv, fa, 0, "STT370.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT370.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT370, STT370)
//============================================================================


struct  STT380  {
  long fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT380) C1{ Fl FL:3 Fc}



static void Test_STT380()
{
  {
    init_simple_test("STT380");
    static STRUCT_IF_C STT380 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT380)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT380)");
    check_field_offset(lv, fa, 0, "STT380.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT380.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT380, STT380)
//============================================================================


struct  STT390  {
  long fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT390) C1{ Fl Fs:8 Fc}



static void Test_STT390()
{
  {
    init_simple_test("STT390");
    static STRUCT_IF_C STT390 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT390)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT390)");
    check_field_offset(lv, fa, 0, "STT390.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT390.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT390, STT390)
//============================================================================


struct  STT3100  {
  long fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT3100) C1{ Fl Fi:8 Fc}



static void Test_STT3100()
{
  {
    init_simple_test("STT3100");
    static STRUCT_IF_C STT3100 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3100)");
    check_field_offset(lv, fa, 0, "STT3100.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3100, STT3100)
//============================================================================


struct  STT3110  {
  long fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT3110) C1{ Fl FL:8 Fc}



static void Test_STT3110()
{
  {
    init_simple_test("STT3110");
    static STRUCT_IF_C STT3110 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3110)");
    check_field_offset(lv, fa, 0, "STT3110.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3110, STT3110)
//============================================================================


struct  STT3120  {
  long fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT3120) C1{ Fl Fi:18 Fc}



static void Test_STT3120()
{
  {
    init_simple_test("STT3120");
    static STRUCT_IF_C STT3120 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3120)");
    check_field_offset(lv, fa, 0, "STT3120.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3120, STT3120)
//============================================================================


struct  STT3130  {
  long fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT3130) C1{ Fl FL:18 Fc}



static void Test_STT3130()
{
  {
    init_simple_test("STT3130");
    static STRUCT_IF_C STT3130 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3130)");
    check_field_offset(lv, fa, 0, "STT3130.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3130, STT3130)
//============================================================================


struct  STT3140  {
  long fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT3140) C1{ Fl FL:48 Fc}



static void Test_STT3140()
{
  {
    init_simple_test("STT3140");
    static STRUCT_IF_C STT3140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3140)");
    check_field_offset(lv, fa, 0, "STT3140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3140, STT3140)
//============================================================================


struct  STT3150  {
  long fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT3150) C1{ Fl Fc:3 Fc}



static void Test_STT3150()
{
  {
    init_simple_test("STT3150");
    static STRUCT_IF_C STT3150 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3150)");
    check_field_offset(lv, fa, 0, "STT3150.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3150");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3150");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3150, STT3150)
//============================================================================


struct  STT3160  {
  long fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT3160) C1{ Fl Fs:3 Fc}



static void Test_STT3160()
{
  {
    init_simple_test("STT3160");
    static STRUCT_IF_C STT3160 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3160)");
    check_field_offset(lv, fa, 0, "STT3160.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3160");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3160");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3160, STT3160)
//============================================================================


struct  STT3170  {
  long fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT3170) C1{ Fl Fi:3 Fc}



static void Test_STT3170()
{
  {
    init_simple_test("STT3170");
    static STRUCT_IF_C STT3170 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3170)");
    check_field_offset(lv, fa, 0, "STT3170.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3170");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3170");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3170, STT3170)
//============================================================================


struct  STT3180  {
  long fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT3180) C1{ Fl FL:3 Fc}



static void Test_STT3180()
{
  {
    init_simple_test("STT3180");
    static STRUCT_IF_C STT3180 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3180)");
    check_field_offset(lv, fa, 0, "STT3180.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3180");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3180");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3180, STT3180)
//============================================================================


struct  STT3190  {
  long fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT3190) C1{ Fl Fs:8 Fc}



static void Test_STT3190()
{
  {
    init_simple_test("STT3190");
    static STRUCT_IF_C STT3190 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3190)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3190)");
    check_field_offset(lv, fa, 0, "STT3190.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3190");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3190");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3190, STT3190)
//============================================================================


struct  STT3200  {
  long fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT3200) C1{ Fl Fi:8 Fc}



static void Test_STT3200()
{
  {
    init_simple_test("STT3200");
    static STRUCT_IF_C STT3200 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3200)");
    check_field_offset(lv, fa, 0, "STT3200.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3200");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3200");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3200, STT3200)
//============================================================================


struct  STT3210  {
  long fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT3210) C1{ Fl FL:8 Fc}



static void Test_STT3210()
{
  {
    init_simple_test("STT3210");
    static STRUCT_IF_C STT3210 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3210)");
    check_field_offset(lv, fa, 0, "STT3210.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3210");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3210");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3210, STT3210)
//============================================================================


struct  STT3220  {
  long fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT3220) C1{ Fl Fi:18 Fc}



static void Test_STT3220()
{
  {
    init_simple_test("STT3220");
    static STRUCT_IF_C STT3220 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3220)");
    check_field_offset(lv, fa, 0, "STT3220.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3220");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3220");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3220, STT3220)
//============================================================================


struct  STT3230  {
  long fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT3230) C1{ Fl FL:18 Fc}



static void Test_STT3230()
{
  {
    init_simple_test("STT3230");
    static STRUCT_IF_C STT3230 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3230)");
    check_field_offset(lv, fa, 0, "STT3230.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3230");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3230");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3230, STT3230)
//============================================================================


struct  STT3240  {
  long fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT3240) C1{ Fl FL:48 Fc}



static void Test_STT3240()
{
  {
    init_simple_test("STT3240");
    static STRUCT_IF_C STT3240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3240)");
    check_field_offset(lv, fa, 0, "STT3240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3240, STT3240)
//============================================================================


struct  STT311  {
  long fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT311) C1{ Fl Fc:0 Fs}



static void Test_STT311()
{
  {
    init_simple_test("STT311");
    static STRUCT_IF_C STT311 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT311)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT311)");
    check_field_offset(lv, fa, 0, "STT311.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT311.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT311, STT311)
//============================================================================


struct  STT321  {
  long fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT321) C1{ Fl Fs:0 Fs}



static void Test_STT321()
{
  {
    init_simple_test("STT321");
    static STRUCT_IF_C STT321 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT321)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT321)");
    check_field_offset(lv, fa, 0, "STT321.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT321.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT321, STT321)
//============================================================================


struct  STT331  {
  long fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT331) C1{ Fl Fi:0 Fs}



static void Test_STT331()
{
  {
    init_simple_test("STT331");
    static STRUCT_IF_C STT331 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT331)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT331)");
    check_field_offset(lv, fa, 0, "STT331.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT331.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT331, STT331)
//============================================================================


struct  STT341  {
  long fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT341) C1{ Fl FL:0 Fs}



static void Test_STT341()
{
  {
    init_simple_test("STT341");
    static STRUCT_IF_C STT341 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT341)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT341)");
    check_field_offset(lv, fa, 0, "STT341.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT341.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT341, STT341)
//============================================================================


struct  STT351  {
  long fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT351) C1{ Fl Fc:3 Fs}



static void Test_STT351()
{
  {
    init_simple_test("STT351");
    static STRUCT_IF_C STT351 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT351)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT351)");
    check_field_offset(lv, fa, 0, "STT351.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT351.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT351, STT351)
//============================================================================


struct  STT361  {
  long fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT361) C1{ Fl Fs:3 Fs}



static void Test_STT361()
{
  {
    init_simple_test("STT361");
    static STRUCT_IF_C STT361 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT361)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT361)");
    check_field_offset(lv, fa, 0, "STT361.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT361.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT361, STT361)
//============================================================================


struct  STT371  {
  long fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT371) C1{ Fl Fi:3 Fs}



static void Test_STT371()
{
  {
    init_simple_test("STT371");
    static STRUCT_IF_C STT371 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT371)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT371)");
    check_field_offset(lv, fa, 0, "STT371.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT371.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT371, STT371)
//============================================================================


struct  STT381  {
  long fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT381) C1{ Fl FL:3 Fs}



static void Test_STT381()
{
  {
    init_simple_test("STT381");
    static STRUCT_IF_C STT381 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT381)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT381)");
    check_field_offset(lv, fa, 0, "STT381.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT381.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT381, STT381)
//============================================================================


struct  STT391  {
  long fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT391) C1{ Fl Fs:8 Fs}



static void Test_STT391()
{
  {
    init_simple_test("STT391");
    static STRUCT_IF_C STT391 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT391)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT391)");
    check_field_offset(lv, fa, 0, "STT391.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT391.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT391, STT391)
//============================================================================


struct  STT3101  {
  long fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT3101) C1{ Fl Fi:8 Fs}



static void Test_STT3101()
{
  {
    init_simple_test("STT3101");
    static STRUCT_IF_C STT3101 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3101)");
    check_field_offset(lv, fa, 0, "STT3101.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3101, STT3101)
//============================================================================


struct  STT3111  {
  long fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT3111) C1{ Fl FL:8 Fs}



static void Test_STT3111()
{
  {
    init_simple_test("STT3111");
    static STRUCT_IF_C STT3111 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3111)");
    check_field_offset(lv, fa, 0, "STT3111.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3111, STT3111)
//============================================================================


struct  STT3121  {
  long fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT3121) C1{ Fl Fi:18 Fs}



static void Test_STT3121()
{
  {
    init_simple_test("STT3121");
    static STRUCT_IF_C STT3121 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3121)");
    check_field_offset(lv, fa, 0, "STT3121.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3121, STT3121)
//============================================================================


struct  STT3131  {
  long fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT3131) C1{ Fl FL:18 Fs}



static void Test_STT3131()
{
  {
    init_simple_test("STT3131");
    static STRUCT_IF_C STT3131 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3131)");
    check_field_offset(lv, fa, 0, "STT3131.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3131, STT3131)
//============================================================================


struct  STT3141  {
  long fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT3141) C1{ Fl FL:48 Fs}



static void Test_STT3141()
{
  {
    init_simple_test("STT3141");
    static STRUCT_IF_C STT3141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3141)");
    check_field_offset(lv, fa, 0, "STT3141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3141, STT3141)
//============================================================================


struct  STT3151  {
  long fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT3151) C1{ Fl Fc:3 Fs}



static void Test_STT3151()
{
  {
    init_simple_test("STT3151");
    static STRUCT_IF_C STT3151 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3151)");
    check_field_offset(lv, fa, 0, "STT3151.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3151");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3151");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3151, STT3151)
//============================================================================


struct  STT3161  {
  long fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT3161) C1{ Fl Fs:3 Fs}



static void Test_STT3161()
{
  {
    init_simple_test("STT3161");
    static STRUCT_IF_C STT3161 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3161)");
    check_field_offset(lv, fa, 0, "STT3161.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3161");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3161");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3161, STT3161)
//============================================================================


struct  STT3171  {
  long fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT3171) C1{ Fl Fi:3 Fs}



static void Test_STT3171()
{
  {
    init_simple_test("STT3171");
    static STRUCT_IF_C STT3171 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3171)");
    check_field_offset(lv, fa, 0, "STT3171.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3171");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3171");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3171, STT3171)
//============================================================================


struct  STT3181  {
  long fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT3181) C1{ Fl FL:3 Fs}



static void Test_STT3181()
{
  {
    init_simple_test("STT3181");
    static STRUCT_IF_C STT3181 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3181)");
    check_field_offset(lv, fa, 0, "STT3181.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3181");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3181");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3181, STT3181)
//============================================================================


struct  STT3191  {
  long fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT3191) C1{ Fl Fs:8 Fs}



static void Test_STT3191()
{
  {
    init_simple_test("STT3191");
    static STRUCT_IF_C STT3191 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3191)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3191)");
    check_field_offset(lv, fa, 0, "STT3191.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3191");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3191");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3191, STT3191)
//============================================================================


struct  STT3201  {
  long fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT3201) C1{ Fl Fi:8 Fs}



static void Test_STT3201()
{
  {
    init_simple_test("STT3201");
    static STRUCT_IF_C STT3201 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3201)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3201)");
    check_field_offset(lv, fa, 0, "STT3201.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3201");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3201");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3201, STT3201)
//============================================================================


struct  STT3211  {
  long fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT3211) C1{ Fl FL:8 Fs}



static void Test_STT3211()
{
  {
    init_simple_test("STT3211");
    static STRUCT_IF_C STT3211 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3211)");
    check_field_offset(lv, fa, 0, "STT3211.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3211");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3211");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3211, STT3211)
//============================================================================


struct  STT3221  {
  long fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT3221) C1{ Fl Fi:18 Fs}



static void Test_STT3221()
{
  {
    init_simple_test("STT3221");
    static STRUCT_IF_C STT3221 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3221)");
    check_field_offset(lv, fa, 0, "STT3221.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3221");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3221");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3221, STT3221)
//============================================================================


struct  STT3231  {
  long fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT3231) C1{ Fl FL:18 Fs}



static void Test_STT3231()
{
  {
    init_simple_test("STT3231");
    static STRUCT_IF_C STT3231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3231)");
    check_field_offset(lv, fa, 0, "STT3231.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3231");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3231");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3231, STT3231)
//============================================================================


struct  STT3241  {
  long fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT3241) C1{ Fl FL:48 Fs}



static void Test_STT3241()
{
  {
    init_simple_test("STT3241");
    static STRUCT_IF_C STT3241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3241)");
    check_field_offset(lv, fa, 0, "STT3241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3241, STT3241)
//============================================================================


struct  STT312  {
  long fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT312) C1{ Fl Fc:0 Fi}



static void Test_STT312()
{
  {
    init_simple_test("STT312");
    static STRUCT_IF_C STT312 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT312)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT312)");
    check_field_offset(lv, fa, 0, "STT312.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT312.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT312, STT312)
//============================================================================


struct  STT322  {
  long fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT322) C1{ Fl Fs:0 Fi}



static void Test_STT322()
{
  {
    init_simple_test("STT322");
    static STRUCT_IF_C STT322 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT322)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT322)");
    check_field_offset(lv, fa, 0, "STT322.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT322.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT322, STT322)
//============================================================================


struct  STT332  {
  long fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT332) C1{ Fl Fi:0 Fi}



static void Test_STT332()
{
  {
    init_simple_test("STT332");
    static STRUCT_IF_C STT332 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT332)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT332)");
    check_field_offset(lv, fa, 0, "STT332.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT332.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT332, STT332)
//============================================================================


struct  STT342  {
  long fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT342) C1{ Fl FL:0 Fi}



static void Test_STT342()
{
  {
    init_simple_test("STT342");
    static STRUCT_IF_C STT342 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT342)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT342)");
    check_field_offset(lv, fa, 0, "STT342.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT342.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT342, STT342)
//============================================================================


struct  STT352  {
  long fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT352) C1{ Fl Fc:3 Fi}



static void Test_STT352()
{
  {
    init_simple_test("STT352");
    static STRUCT_IF_C STT352 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT352)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT352)");
    check_field_offset(lv, fa, 0, "STT352.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT352.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT352, STT352)
//============================================================================


struct  STT362  {
  long fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT362) C1{ Fl Fs:3 Fi}



static void Test_STT362()
{
  {
    init_simple_test("STT362");
    static STRUCT_IF_C STT362 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT362)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT362)");
    check_field_offset(lv, fa, 0, "STT362.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT362.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT362, STT362)
//============================================================================


struct  STT372  {
  long fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT372) C1{ Fl Fi:3 Fi}



static void Test_STT372()
{
  {
    init_simple_test("STT372");
    static STRUCT_IF_C STT372 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT372)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT372)");
    check_field_offset(lv, fa, 0, "STT372.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT372.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT372, STT372)
//============================================================================


struct  STT382  {
  long fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT382) C1{ Fl FL:3 Fi}



static void Test_STT382()
{
  {
    init_simple_test("STT382");
    static STRUCT_IF_C STT382 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT382)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT382)");
    check_field_offset(lv, fa, 0, "STT382.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT382.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT382, STT382)
//============================================================================


struct  STT392  {
  long fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT392) C1{ Fl Fs:8 Fi}



static void Test_STT392()
{
  {
    init_simple_test("STT392");
    static STRUCT_IF_C STT392 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT392)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT392)");
    check_field_offset(lv, fa, 0, "STT392.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT392.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT392, STT392)
//============================================================================


struct  STT3102  {
  long fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT3102) C1{ Fl Fi:8 Fi}



static void Test_STT3102()
{
  {
    init_simple_test("STT3102");
    static STRUCT_IF_C STT3102 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3102)");
    check_field_offset(lv, fa, 0, "STT3102.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3102, STT3102)
//============================================================================


struct  STT3112  {
  long fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT3112) C1{ Fl FL:8 Fi}



static void Test_STT3112()
{
  {
    init_simple_test("STT3112");
    static STRUCT_IF_C STT3112 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3112)");
    check_field_offset(lv, fa, 0, "STT3112.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3112, STT3112)
//============================================================================


struct  STT3122  {
  long fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT3122) C1{ Fl Fi:18 Fi}



static void Test_STT3122()
{
  {
    init_simple_test("STT3122");
    static STRUCT_IF_C STT3122 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3122)");
    check_field_offset(lv, fa, 0, "STT3122.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3122, STT3122)
//============================================================================


struct  STT3132  {
  long fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT3132) C1{ Fl FL:18 Fi}



static void Test_STT3132()
{
  {
    init_simple_test("STT3132");
    static STRUCT_IF_C STT3132 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3132)");
    check_field_offset(lv, fa, 0, "STT3132.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3132, STT3132)
//============================================================================


struct  STT3142  {
  long fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT3142) C1{ Fl FL:48 Fi}



static void Test_STT3142()
{
  {
    init_simple_test("STT3142");
    static STRUCT_IF_C STT3142 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3142)");
    check_field_offset(lv, fa, 0, "STT3142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3142, STT3142)
//============================================================================


struct  STT3152  {
  long fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT3152) C1{ Fl Fc:3 Fi}



static void Test_STT3152()
{
  {
    init_simple_test("STT3152");
    static STRUCT_IF_C STT3152 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3152)");
    check_field_offset(lv, fa, 0, "STT3152.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3152");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3152");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3152, STT3152)
//============================================================================


struct  STT3162  {
  long fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT3162) C1{ Fl Fs:3 Fi}



static void Test_STT3162()
{
  {
    init_simple_test("STT3162");
    static STRUCT_IF_C STT3162 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3162)");
    check_field_offset(lv, fa, 0, "STT3162.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3162");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3162");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3162, STT3162)
//============================================================================


struct  STT3172  {
  long fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT3172) C1{ Fl Fi:3 Fi}



static void Test_STT3172()
{
  {
    init_simple_test("STT3172");
    static STRUCT_IF_C STT3172 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3172)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3172)");
    check_field_offset(lv, fa, 0, "STT3172.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3172");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3172");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3172, STT3172)
//============================================================================


struct  STT3182  {
  long fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT3182) C1{ Fl FL:3 Fi}



static void Test_STT3182()
{
  {
    init_simple_test("STT3182");
    static STRUCT_IF_C STT3182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3182)");
    check_field_offset(lv, fa, 0, "STT3182.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3182");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3182");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3182, STT3182)
//============================================================================


struct  STT3192  {
  long fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT3192) C1{ Fl Fs:8 Fi}



static void Test_STT3192()
{
  {
    init_simple_test("STT3192");
    static STRUCT_IF_C STT3192 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3192)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3192)");
    check_field_offset(lv, fa, 0, "STT3192.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3192");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3192");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3192, STT3192)
//============================================================================


struct  STT3202  {
  long fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT3202) C1{ Fl Fi:8 Fi}



static void Test_STT3202()
{
  {
    init_simple_test("STT3202");
    static STRUCT_IF_C STT3202 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3202)");
    check_field_offset(lv, fa, 0, "STT3202.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3202");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3202");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3202, STT3202)
//============================================================================


struct  STT3212  {
  long fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT3212) C1{ Fl FL:8 Fi}



static void Test_STT3212()
{
  {
    init_simple_test("STT3212");
    static STRUCT_IF_C STT3212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3212)");
    check_field_offset(lv, fa, 0, "STT3212.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3212");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3212");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3212, STT3212)
//============================================================================


struct  STT3222  {
  long fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT3222) C1{ Fl Fi:18 Fi}



static void Test_STT3222()
{
  {
    init_simple_test("STT3222");
    static STRUCT_IF_C STT3222 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3222)");
    check_field_offset(lv, fa, 0, "STT3222.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3222");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3222");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3222, STT3222)
//============================================================================


struct  STT3232  {
  long fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT3232) C1{ Fl FL:18 Fi}



static void Test_STT3232()
{
  {
    init_simple_test("STT3232");
    static STRUCT_IF_C STT3232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3232)");
    check_field_offset(lv, fa, 0, "STT3232.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3232");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3232");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3232, STT3232)
//============================================================================


struct  STT3242  {
  long fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT3242) C1{ Fl FL:48 Fi}



static void Test_STT3242()
{
  {
    init_simple_test("STT3242");
    static STRUCT_IF_C STT3242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3242)");
    check_field_offset(lv, fa, 0, "STT3242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3242, STT3242)
//============================================================================


struct  STT313  {
  long fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT313) C1{ Fl Fc:0 Fl}



static void Test_STT313()
{
  {
    init_simple_test("STT313");
    static STRUCT_IF_C STT313 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT313)");
    check_field_offset(lv, fa, 0, "STT313.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT313.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT313, STT313)
//============================================================================


struct  STT323  {
  long fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT323) C1{ Fl Fs:0 Fl}



static void Test_STT323()
{
  {
    init_simple_test("STT323");
    static STRUCT_IF_C STT323 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT323)");
    check_field_offset(lv, fa, 0, "STT323.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT323.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT323, STT323)
//============================================================================


struct  STT333  {
  long fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT333) C1{ Fl Fi:0 Fl}



static void Test_STT333()
{
  {
    init_simple_test("STT333");
    static STRUCT_IF_C STT333 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT333)");
    check_field_offset(lv, fa, 0, "STT333.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT333.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT333, STT333)
//============================================================================


struct  STT343  {
  long fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT343) C1{ Fl FL:0 Fl}



static void Test_STT343()
{
  {
    init_simple_test("STT343");
    static STRUCT_IF_C STT343 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT343)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT343)");
    check_field_offset(lv, fa, 0, "STT343.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT343.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT343, STT343)
//============================================================================


struct  STT353  {
  long fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT353) C1{ Fl Fc:3 Fl}



static void Test_STT353()
{
  {
    init_simple_test("STT353");
    static STRUCT_IF_C STT353 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT353)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT353)");
    check_field_offset(lv, fa, 0, "STT353.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT353.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT353, STT353)
//============================================================================


struct  STT363  {
  long fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT363) C1{ Fl Fs:3 Fl}



static void Test_STT363()
{
  {
    init_simple_test("STT363");
    static STRUCT_IF_C STT363 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT363)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT363)");
    check_field_offset(lv, fa, 0, "STT363.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT363.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT363, STT363)
//============================================================================


struct  STT373  {
  long fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT373) C1{ Fl Fi:3 Fl}



static void Test_STT373()
{
  {
    init_simple_test("STT373");
    static STRUCT_IF_C STT373 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT373)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT373)");
    check_field_offset(lv, fa, 0, "STT373.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT373.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT373, STT373)
//============================================================================


struct  STT383  {
  long fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT383) C1{ Fl FL:3 Fl}



static void Test_STT383()
{
  {
    init_simple_test("STT383");
    static STRUCT_IF_C STT383 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT383)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT383)");
    check_field_offset(lv, fa, 0, "STT383.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT383.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT383, STT383)
//============================================================================


struct  STT393  {
  long fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT393) C1{ Fl Fs:8 Fl}



static void Test_STT393()
{
  {
    init_simple_test("STT393");
    static STRUCT_IF_C STT393 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT393)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT393)");
    check_field_offset(lv, fa, 0, "STT393.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT393.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT393, STT393)
//============================================================================


struct  STT3103  {
  long fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT3103) C1{ Fl Fi:8 Fl}



static void Test_STT3103()
{
  {
    init_simple_test("STT3103");
    static STRUCT_IF_C STT3103 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3103)");
    check_field_offset(lv, fa, 0, "STT3103.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3103, STT3103)
//============================================================================


struct  STT3113  {
  long fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT3113) C1{ Fl FL:8 Fl}



static void Test_STT3113()
{
  {
    init_simple_test("STT3113");
    static STRUCT_IF_C STT3113 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3113)");
    check_field_offset(lv, fa, 0, "STT3113.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3113, STT3113)
//============================================================================


struct  STT3123  {
  long fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT3123) C1{ Fl Fi:18 Fl}



static void Test_STT3123()
{
  {
    init_simple_test("STT3123");
    static STRUCT_IF_C STT3123 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3123)");
    check_field_offset(lv, fa, 0, "STT3123.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3123, STT3123)
//============================================================================


struct  STT3133  {
  long fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT3133) C1{ Fl FL:18 Fl}



static void Test_STT3133()
{
  {
    init_simple_test("STT3133");
    static STRUCT_IF_C STT3133 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3133)");
    check_field_offset(lv, fa, 0, "STT3133.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3133, STT3133)
//============================================================================


struct  STT3143  {
  long fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT3143) C1{ Fl FL:48 Fl}



static void Test_STT3143()
{
  {
    init_simple_test("STT3143");
    static STRUCT_IF_C STT3143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3143)");
    check_field_offset(lv, fa, 0, "STT3143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3143, STT3143)
//============================================================================


struct  STT3153  {
  long fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT3153) C1{ Fl Fc:3 Fl}



static void Test_STT3153()
{
  {
    init_simple_test("STT3153");
    static STRUCT_IF_C STT3153 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3153)");
    check_field_offset(lv, fa, 0, "STT3153.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3153");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3153");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3153, STT3153)
//============================================================================


struct  STT3163  {
  long fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT3163) C1{ Fl Fs:3 Fl}



static void Test_STT3163()
{
  {
    init_simple_test("STT3163");
    static STRUCT_IF_C STT3163 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3163)");
    check_field_offset(lv, fa, 0, "STT3163.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3163");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3163");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3163, STT3163)
//============================================================================


struct  STT3173  {
  long fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT3173) C1{ Fl Fi:3 Fl}



static void Test_STT3173()
{
  {
    init_simple_test("STT3173");
    static STRUCT_IF_C STT3173 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3173)");
    check_field_offset(lv, fa, 0, "STT3173.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3173");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3173");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3173, STT3173)
//============================================================================


struct  STT3183  {
  long fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT3183) C1{ Fl FL:3 Fl}



static void Test_STT3183()
{
  {
    init_simple_test("STT3183");
    static STRUCT_IF_C STT3183 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3183)");
    check_field_offset(lv, fa, 0, "STT3183.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3183");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3183");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3183, STT3183)
//============================================================================


struct  STT3193  {
  long fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT3193) C1{ Fl Fs:8 Fl}



static void Test_STT3193()
{
  {
    init_simple_test("STT3193");
    static STRUCT_IF_C STT3193 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3193)");
    check_field_offset(lv, fa, 0, "STT3193.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3193");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3193");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3193, STT3193)
//============================================================================


struct  STT3203  {
  long fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT3203) C1{ Fl Fi:8 Fl}



static void Test_STT3203()
{
  {
    init_simple_test("STT3203");
    static STRUCT_IF_C STT3203 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3203)");
    check_field_offset(lv, fa, 0, "STT3203.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3203");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3203");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3203, STT3203)
//============================================================================


struct  STT3213  {
  long fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT3213) C1{ Fl FL:8 Fl}



static void Test_STT3213()
{
  {
    init_simple_test("STT3213");
    static STRUCT_IF_C STT3213 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3213)");
    check_field_offset(lv, fa, 0, "STT3213.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3213");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3213");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3213, STT3213)
//============================================================================


struct  STT3223  {
  long fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT3223) C1{ Fl Fi:18 Fl}



static void Test_STT3223()
{
  {
    init_simple_test("STT3223");
    static STRUCT_IF_C STT3223 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3223)");
    check_field_offset(lv, fa, 0, "STT3223.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3223");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3223");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3223, STT3223)
//============================================================================


struct  STT3233  {
  long fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT3233) C1{ Fl FL:18 Fl}



static void Test_STT3233()
{
  {
    init_simple_test("STT3233");
    static STRUCT_IF_C STT3233 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3233)");
    check_field_offset(lv, fa, 0, "STT3233.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3233");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3233");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3233, STT3233)
//============================================================================


struct  STT3243  {
  long fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT3243) C1{ Fl FL:48 Fl}



static void Test_STT3243()
{
  {
    init_simple_test("STT3243");
    static STRUCT_IF_C STT3243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3243)");
    check_field_offset(lv, fa, 0, "STT3243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3243, STT3243)
//============================================================================


struct  STT314  {
  long fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT314) C1{ Fl Fc:0 FL}



static void Test_STT314()
{
  {
    init_simple_test("STT314");
    static STRUCT_IF_C STT314 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT314)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT314)");
    check_field_offset(lv, fa, 0, "STT314.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT314.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT314, STT314)
//============================================================================


struct  STT324  {
  long fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT324) C1{ Fl Fs:0 FL}



static void Test_STT324()
{
  {
    init_simple_test("STT324");
    static STRUCT_IF_C STT324 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT324)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT324)");
    check_field_offset(lv, fa, 0, "STT324.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT324.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT324, STT324)
//============================================================================


struct  STT334  {
  long fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT334) C1{ Fl Fi:0 FL}



static void Test_STT334()
{
  {
    init_simple_test("STT334");
    static STRUCT_IF_C STT334 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT334)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT334)");
    check_field_offset(lv, fa, 0, "STT334.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT334.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT334, STT334)
//============================================================================


struct  STT344  {
  long fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT344) C1{ Fl FL:0 FL}



static void Test_STT344()
{
  {
    init_simple_test("STT344");
    static STRUCT_IF_C STT344 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT344)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT344)");
    check_field_offset(lv, fa, 0, "STT344.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT344.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT344, STT344)
//============================================================================


struct  STT354  {
  long fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT354) C1{ Fl Fc:3 FL}



static void Test_STT354()
{
  {
    init_simple_test("STT354");
    static STRUCT_IF_C STT354 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT354)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT354)");
    check_field_offset(lv, fa, 0, "STT354.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT354.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT354, STT354)
//============================================================================


struct  STT364  {
  long fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT364) C1{ Fl Fs:3 FL}



static void Test_STT364()
{
  {
    init_simple_test("STT364");
    static STRUCT_IF_C STT364 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT364)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT364)");
    check_field_offset(lv, fa, 0, "STT364.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT364.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT364, STT364)
//============================================================================


struct  STT374  {
  long fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT374) C1{ Fl Fi:3 FL}



static void Test_STT374()
{
  {
    init_simple_test("STT374");
    static STRUCT_IF_C STT374 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT374)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT374)");
    check_field_offset(lv, fa, 0, "STT374.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT374.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT374, STT374)
//============================================================================


struct  STT384  {
  long fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT384) C1{ Fl FL:3 FL}



static void Test_STT384()
{
  {
    init_simple_test("STT384");
    static STRUCT_IF_C STT384 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT384)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT384)");
    check_field_offset(lv, fa, 0, "STT384.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT384.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT384, STT384)
//============================================================================


struct  STT394  {
  long fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT394) C1{ Fl Fs:8 FL}



static void Test_STT394()
{
  {
    init_simple_test("STT394");
    static STRUCT_IF_C STT394 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT394)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT394)");
    check_field_offset(lv, fa, 0, "STT394.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT394.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT394, STT394)
//============================================================================


struct  STT3104  {
  long fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT3104) C1{ Fl Fi:8 FL}



static void Test_STT3104()
{
  {
    init_simple_test("STT3104");
    static STRUCT_IF_C STT3104 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3104)");
    check_field_offset(lv, fa, 0, "STT3104.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3104, STT3104)
//============================================================================


struct  STT3114  {
  long fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT3114) C1{ Fl FL:8 FL}



static void Test_STT3114()
{
  {
    init_simple_test("STT3114");
    static STRUCT_IF_C STT3114 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3114)");
    check_field_offset(lv, fa, 0, "STT3114.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3114, STT3114)
//============================================================================


struct  STT3124  {
  long fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT3124) C1{ Fl Fi:18 FL}



static void Test_STT3124()
{
  {
    init_simple_test("STT3124");
    static STRUCT_IF_C STT3124 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3124)");
    check_field_offset(lv, fa, 0, "STT3124.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3124, STT3124)
//============================================================================


struct  STT3134  {
  long fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT3134) C1{ Fl FL:18 FL}



static void Test_STT3134()
{
  {
    init_simple_test("STT3134");
    static STRUCT_IF_C STT3134 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3134)");
    check_field_offset(lv, fa, 0, "STT3134.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3134, STT3134)
//============================================================================


struct  STT3144  {
  long fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT3144) C1{ Fl FL:48 FL}



static void Test_STT3144()
{
  {
    init_simple_test("STT3144");
    static STRUCT_IF_C STT3144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3144)");
    check_field_offset(lv, fa, 0, "STT3144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3144, STT3144)
//============================================================================


struct  STT3154  {
  long fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT3154) C1{ Fl Fc:3 FL}



static void Test_STT3154()
{
  {
    init_simple_test("STT3154");
    static STRUCT_IF_C STT3154 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3154)");
    check_field_offset(lv, fa, 0, "STT3154.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3154");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3154");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3154, STT3154)
//============================================================================


struct  STT3164  {
  long fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT3164) C1{ Fl Fs:3 FL}



static void Test_STT3164()
{
  {
    init_simple_test("STT3164");
    static STRUCT_IF_C STT3164 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3164)");
    check_field_offset(lv, fa, 0, "STT3164.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3164");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3164");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3164, STT3164)
//============================================================================


struct  STT3174  {
  long fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT3174) C1{ Fl Fi:3 FL}



static void Test_STT3174()
{
  {
    init_simple_test("STT3174");
    static STRUCT_IF_C STT3174 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3174)");
    check_field_offset(lv, fa, 0, "STT3174.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3174");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3174");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3174, STT3174)
//============================================================================


struct  STT3184  {
  long fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT3184) C1{ Fl FL:3 FL}



static void Test_STT3184()
{
  {
    init_simple_test("STT3184");
    static STRUCT_IF_C STT3184 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3184)");
    check_field_offset(lv, fa, 0, "STT3184.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3184");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3184");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3184, STT3184)
//============================================================================


struct  STT3194  {
  long fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT3194) C1{ Fl Fs:8 FL}



static void Test_STT3194()
{
  {
    init_simple_test("STT3194");
    static STRUCT_IF_C STT3194 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3194)");
    check_field_offset(lv, fa, 0, "STT3194.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3194");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3194");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3194, STT3194)
//============================================================================


struct  STT3204  {
  long fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT3204) C1{ Fl Fi:8 FL}



static void Test_STT3204()
{
  {
    init_simple_test("STT3204");
    static STRUCT_IF_C STT3204 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3204)");
    check_field_offset(lv, fa, 0, "STT3204.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3204");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3204");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3204, STT3204)
//============================================================================


struct  STT3214  {
  long fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT3214) C1{ Fl FL:8 FL}



static void Test_STT3214()
{
  {
    init_simple_test("STT3214");
    static STRUCT_IF_C STT3214 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3214)");
    check_field_offset(lv, fa, 0, "STT3214.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3214");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3214");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3214, STT3214)
//============================================================================


struct  STT3224  {
  long fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT3224) C1{ Fl Fi:18 FL}



static void Test_STT3224()
{
  {
    init_simple_test("STT3224");
    static STRUCT_IF_C STT3224 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3224)");
    check_field_offset(lv, fa, 0, "STT3224.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3224");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3224");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3224, STT3224)
//============================================================================


struct  STT3234  {
  long fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT3234) C1{ Fl FL:18 FL}



static void Test_STT3234()
{
  {
    init_simple_test("STT3234");
    static STRUCT_IF_C STT3234 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3234)");
    check_field_offset(lv, fa, 0, "STT3234.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3234");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3234");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3234, STT3234)
//============================================================================


struct  STT3244  {
  long fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT3244) C1{ Fl FL:48 FL}



static void Test_STT3244()
{
  {
    init_simple_test("STT3244");
    static STRUCT_IF_C STT3244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3244)");
    check_field_offset(lv, fa, 0, "STT3244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3244, STT3244)
//============================================================================


struct  STT315  {
  long fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT315) C1{ Fl Fc:0 Fp}



static void Test_STT315()
{
  {
    init_simple_test("STT315");
    static STRUCT_IF_C STT315 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT315)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT315)");
    check_field_offset(lv, fa, 0, "STT315.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT315.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT315, STT315)
//============================================================================


struct  STT325  {
  long fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT325) C1{ Fl Fs:0 Fp}



static void Test_STT325()
{
  {
    init_simple_test("STT325");
    static STRUCT_IF_C STT325 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT325)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT325)");
    check_field_offset(lv, fa, 0, "STT325.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT325.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT325, STT325)
//============================================================================


struct  STT335  {
  long fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT335) C1{ Fl Fi:0 Fp}



static void Test_STT335()
{
  {
    init_simple_test("STT335");
    static STRUCT_IF_C STT335 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT335)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT335)");
    check_field_offset(lv, fa, 0, "STT335.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT335.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT335, STT335)
//============================================================================


struct  STT345  {
  long fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT345) C1{ Fl FL:0 Fp}



static void Test_STT345()
{
  {
    init_simple_test("STT345");
    static STRUCT_IF_C STT345 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT345)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT345)");
    check_field_offset(lv, fa, 0, "STT345.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT345.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT345, STT345)
//============================================================================


struct  STT355  {
  long fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT355) C1{ Fl Fc:3 Fp}



static void Test_STT355()
{
  {
    init_simple_test("STT355");
    static STRUCT_IF_C STT355 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT355)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT355)");
    check_field_offset(lv, fa, 0, "STT355.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT355.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT355, STT355)
//============================================================================


struct  STT365  {
  long fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT365) C1{ Fl Fs:3 Fp}



static void Test_STT365()
{
  {
    init_simple_test("STT365");
    static STRUCT_IF_C STT365 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT365)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT365)");
    check_field_offset(lv, fa, 0, "STT365.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT365.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT365, STT365)
//============================================================================


struct  STT375  {
  long fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT375) C1{ Fl Fi:3 Fp}



static void Test_STT375()
{
  {
    init_simple_test("STT375");
    static STRUCT_IF_C STT375 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT375)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT375)");
    check_field_offset(lv, fa, 0, "STT375.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT375.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT375, STT375)
//============================================================================


struct  STT385  {
  long fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT385) C1{ Fl FL:3 Fp}



static void Test_STT385()
{
  {
    init_simple_test("STT385");
    static STRUCT_IF_C STT385 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT385)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT385)");
    check_field_offset(lv, fa, 0, "STT385.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT385.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT385, STT385)
//============================================================================


struct  STT395  {
  long fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT395) C1{ Fl Fs:8 Fp}



static void Test_STT395()
{
  {
    init_simple_test("STT395");
    static STRUCT_IF_C STT395 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT395)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT395)");
    check_field_offset(lv, fa, 0, "STT395.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT395.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT395, STT395)
//============================================================================


struct  STT3105  {
  long fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT3105) C1{ Fl Fi:8 Fp}



static void Test_STT3105()
{
  {
    init_simple_test("STT3105");
    static STRUCT_IF_C STT3105 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3105)");
    check_field_offset(lv, fa, 0, "STT3105.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3105, STT3105)
//============================================================================


struct  STT3115  {
  long fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT3115) C1{ Fl FL:8 Fp}



static void Test_STT3115()
{
  {
    init_simple_test("STT3115");
    static STRUCT_IF_C STT3115 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3115)");
    check_field_offset(lv, fa, 0, "STT3115.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3115, STT3115)
//============================================================================


struct  STT3125  {
  long fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT3125) C1{ Fl Fi:18 Fp}



static void Test_STT3125()
{
  {
    init_simple_test("STT3125");
    static STRUCT_IF_C STT3125 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3125)");
    check_field_offset(lv, fa, 0, "STT3125.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3125, STT3125)
//============================================================================


struct  STT3135  {
  long fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT3135) C1{ Fl FL:18 Fp}



static void Test_STT3135()
{
  {
    init_simple_test("STT3135");
    static STRUCT_IF_C STT3135 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3135)");
    check_field_offset(lv, fa, 0, "STT3135.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3135, STT3135)
//============================================================================


struct  STT3145  {
  long fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT3145) C1{ Fl FL:48 Fp}



static void Test_STT3145()
{
  {
    init_simple_test("STT3145");
    static STRUCT_IF_C STT3145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3145)");
    check_field_offset(lv, fa, 0, "STT3145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3145, STT3145)
//============================================================================


struct  STT3155  {
  long fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT3155) C1{ Fl Fc:3 Fp}



static void Test_STT3155()
{
  {
    init_simple_test("STT3155");
    static STRUCT_IF_C STT3155 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3155)");
    check_field_offset(lv, fa, 0, "STT3155.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3155");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3155");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3155, STT3155)
//============================================================================


struct  STT3165  {
  long fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT3165) C1{ Fl Fs:3 Fp}



static void Test_STT3165()
{
  {
    init_simple_test("STT3165");
    static STRUCT_IF_C STT3165 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3165)");
    check_field_offset(lv, fa, 0, "STT3165.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3165");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3165");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3165, STT3165)
//============================================================================


struct  STT3175  {
  long fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT3175) C1{ Fl Fi:3 Fp}



static void Test_STT3175()
{
  {
    init_simple_test("STT3175");
    static STRUCT_IF_C STT3175 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3175)");
    check_field_offset(lv, fa, 0, "STT3175.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3175");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3175");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3175, STT3175)
//============================================================================


struct  STT3185  {
  long fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT3185) C1{ Fl FL:3 Fp}



static void Test_STT3185()
{
  {
    init_simple_test("STT3185");
    static STRUCT_IF_C STT3185 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3185)");
    check_field_offset(lv, fa, 0, "STT3185.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3185");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3185");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3185, STT3185)
//============================================================================


struct  STT3195  {
  long fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT3195) C1{ Fl Fs:8 Fp}



static void Test_STT3195()
{
  {
    init_simple_test("STT3195");
    static STRUCT_IF_C STT3195 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3195)");
    check_field_offset(lv, fa, 0, "STT3195.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3195");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3195");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3195, STT3195)
//============================================================================


struct  STT3205  {
  long fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT3205) C1{ Fl Fi:8 Fp}



static void Test_STT3205()
{
  {
    init_simple_test("STT3205");
    static STRUCT_IF_C STT3205 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3205)");
    check_field_offset(lv, fa, 0, "STT3205.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3205");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3205");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3205, STT3205)
//============================================================================


struct  STT3215  {
  long fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT3215) C1{ Fl FL:8 Fp}



static void Test_STT3215()
{
  {
    init_simple_test("STT3215");
    static STRUCT_IF_C STT3215 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3215)");
    check_field_offset(lv, fa, 0, "STT3215.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3215");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3215");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3215, STT3215)
//============================================================================


struct  STT3225  {
  long fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT3225) C1{ Fl Fi:18 Fp}



static void Test_STT3225()
{
  {
    init_simple_test("STT3225");
    static STRUCT_IF_C STT3225 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3225)");
    check_field_offset(lv, fa, 0, "STT3225.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3225");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3225");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3225, STT3225)
//============================================================================


struct  STT3235  {
  long fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT3235) C1{ Fl FL:18 Fp}



static void Test_STT3235()
{
  {
    init_simple_test("STT3235");
    static STRUCT_IF_C STT3235 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3235)");
    check_field_offset(lv, fa, 0, "STT3235.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3235");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3235");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3235, STT3235)
//============================================================================


struct  STT3245  {
  long fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT3245) C1{ Fl FL:48 Fp}



static void Test_STT3245()
{
  {
    init_simple_test("STT3245");
    static STRUCT_IF_C STT3245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3245)");
    check_field_offset(lv, fa, 0, "STT3245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3245, STT3245)
//============================================================================


struct  STT316  {
  long fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT316) C1{ Fl Fc:0 Fi}



static void Test_STT316()
{
  {
    init_simple_test("STT316");
    static STRUCT_IF_C STT316 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT316)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT316)");
    check_field_offset(lv, fa, 0, "STT316.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT316.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT316, STT316)
//============================================================================


struct  STT326  {
  long fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT326) C1{ Fl Fs:0 Fi}



static void Test_STT326()
{
  {
    init_simple_test("STT326");
    static STRUCT_IF_C STT326 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT326)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT326)");
    check_field_offset(lv, fa, 0, "STT326.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT326.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT326, STT326)
//============================================================================


struct  STT336  {
  long fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT336) C1{ Fl Fi:0 Fi}



static void Test_STT336()
{
  {
    init_simple_test("STT336");
    static STRUCT_IF_C STT336 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT336)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT336)");
    check_field_offset(lv, fa, 0, "STT336.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT336.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT336, STT336)
//============================================================================


struct  STT346  {
  long fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT346) C1{ Fl FL:0 Fi}



static void Test_STT346()
{
  {
    init_simple_test("STT346");
    static STRUCT_IF_C STT346 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT346)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT346)");
    check_field_offset(lv, fa, 0, "STT346.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT346.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT346, STT346)
//============================================================================


struct  STT356  {
  long fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT356) C1{ Fl Fc:3 Fi}



static void Test_STT356()
{
  {
    init_simple_test("STT356");
    static STRUCT_IF_C STT356 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT356)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT356)");
    check_field_offset(lv, fa, 0, "STT356.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT356.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT356, STT356)
//============================================================================


struct  STT366  {
  long fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT366) C1{ Fl Fs:3 Fi}



static void Test_STT366()
{
  {
    init_simple_test("STT366");
    static STRUCT_IF_C STT366 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT366)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT366)");
    check_field_offset(lv, fa, 0, "STT366.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT366.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT366, STT366)
//============================================================================


struct  STT376  {
  long fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT376) C1{ Fl Fi:3 Fi}



static void Test_STT376()
{
  {
    init_simple_test("STT376");
    static STRUCT_IF_C STT376 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT376)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT376)");
    check_field_offset(lv, fa, 0, "STT376.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT376.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT376, STT376)
//============================================================================


struct  STT386  {
  long fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT386) C1{ Fl FL:3 Fi}



static void Test_STT386()
{
  {
    init_simple_test("STT386");
    static STRUCT_IF_C STT386 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT386)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT386)");
    check_field_offset(lv, fa, 0, "STT386.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT386.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT386, STT386)
//============================================================================


struct  STT396  {
  long fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT396) C1{ Fl Fs:8 Fi}



static void Test_STT396()
{
  {
    init_simple_test("STT396");
    static STRUCT_IF_C STT396 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT396)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT396)");
    check_field_offset(lv, fa, 0, "STT396.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT396.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT396, STT396)
//============================================================================


struct  STT3106  {
  long fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT3106) C1{ Fl Fi:8 Fi}



static void Test_STT3106()
{
  {
    init_simple_test("STT3106");
    static STRUCT_IF_C STT3106 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3106)");
    check_field_offset(lv, fa, 0, "STT3106.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3106, STT3106)
//============================================================================


struct  STT3116  {
  long fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT3116) C1{ Fl FL:8 Fi}



static void Test_STT3116()
{
  {
    init_simple_test("STT3116");
    static STRUCT_IF_C STT3116 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3116)");
    check_field_offset(lv, fa, 0, "STT3116.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3116, STT3116)
//============================================================================


struct  STT3126  {
  long fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT3126) C1{ Fl Fi:18 Fi}



static void Test_STT3126()
{
  {
    init_simple_test("STT3126");
    static STRUCT_IF_C STT3126 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3126)");
    check_field_offset(lv, fa, 0, "STT3126.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3126, STT3126)
//============================================================================


struct  STT3136  {
  long fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT3136) C1{ Fl FL:18 Fi}



static void Test_STT3136()
{
  {
    init_simple_test("STT3136");
    static STRUCT_IF_C STT3136 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3136)");
    check_field_offset(lv, fa, 0, "STT3136.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3136, STT3136)
//============================================================================


struct  STT3146  {
  long fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT3146) C1{ Fl FL:48 Fi}



static void Test_STT3146()
{
  {
    init_simple_test("STT3146");
    static STRUCT_IF_C STT3146 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3146)");
    check_field_offset(lv, fa, 0, "STT3146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3146, STT3146)
//============================================================================


struct  STT3156  {
  long fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT3156) C1{ Fl Fc:3 Fi}



static void Test_STT3156()
{
  {
    init_simple_test("STT3156");
    static STRUCT_IF_C STT3156 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3156)");
    check_field_offset(lv, fa, 0, "STT3156.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3156");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3156");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3156, STT3156)
//============================================================================


struct  STT3166  {
  long fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT3166) C1{ Fl Fs:3 Fi}



static void Test_STT3166()
{
  {
    init_simple_test("STT3166");
    static STRUCT_IF_C STT3166 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3166)");
    check_field_offset(lv, fa, 0, "STT3166.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3166");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3166");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3166, STT3166)
//============================================================================


struct  STT3176  {
  long fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT3176) C1{ Fl Fi:3 Fi}



static void Test_STT3176()
{
  {
    init_simple_test("STT3176");
    static STRUCT_IF_C STT3176 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3176)");
    check_field_offset(lv, fa, 0, "STT3176.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3176");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3176");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3176, STT3176)
//============================================================================


struct  STT3186  {
  long fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT3186) C1{ Fl FL:3 Fi}



static void Test_STT3186()
{
  {
    init_simple_test("STT3186");
    static STRUCT_IF_C STT3186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3186)");
    check_field_offset(lv, fa, 0, "STT3186.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3186");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3186");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3186, STT3186)
//============================================================================


struct  STT3196  {
  long fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT3196) C1{ Fl Fs:8 Fi}



static void Test_STT3196()
{
  {
    init_simple_test("STT3196");
    static STRUCT_IF_C STT3196 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3196)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3196)");
    check_field_offset(lv, fa, 0, "STT3196.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3196");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3196");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3196, STT3196)
//============================================================================


struct  STT3206  {
  long fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT3206) C1{ Fl Fi:8 Fi}



static void Test_STT3206()
{
  {
    init_simple_test("STT3206");
    static STRUCT_IF_C STT3206 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3206)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3206)");
    check_field_offset(lv, fa, 0, "STT3206.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3206");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3206");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3206, STT3206)
//============================================================================


struct  STT3216  {
  long fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT3216) C1{ Fl FL:8 Fi}



static void Test_STT3216()
{
  {
    init_simple_test("STT3216");
    static STRUCT_IF_C STT3216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3216)");
    check_field_offset(lv, fa, 0, "STT3216.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3216");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3216");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3216, STT3216)
//============================================================================


struct  STT3226  {
  long fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT3226) C1{ Fl Fi:18 Fi}



static void Test_STT3226()
{
  {
    init_simple_test("STT3226");
    static STRUCT_IF_C STT3226 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3226)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3226)");
    check_field_offset(lv, fa, 0, "STT3226.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3226");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3226");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3226, STT3226)
//============================================================================


struct  STT3236  {
  long fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT3236) C1{ Fl FL:18 Fi}



static void Test_STT3236()
{
  {
    init_simple_test("STT3236");
    static STRUCT_IF_C STT3236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3236)");
    check_field_offset(lv, fa, 0, "STT3236.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3236");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3236");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3236, STT3236)
//============================================================================


struct  STT3246  {
  long fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT3246) C1{ Fl FL:48 Fi}



static void Test_STT3246()
{
  {
    init_simple_test("STT3246");
    static STRUCT_IF_C STT3246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3246)");
    check_field_offset(lv, fa, 0, "STT3246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3246, STT3246)
//============================================================================


struct  STT317  {
  long fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT317) C1{ Fl Fc:0 FL}



static void Test_STT317()
{
  {
    init_simple_test("STT317");
    static STRUCT_IF_C STT317 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT317)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT317)");
    check_field_offset(lv, fa, 0, "STT317.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT317.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT317, STT317)
//============================================================================


struct  STT327  {
  long fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT327) C1{ Fl Fs:0 FL}



static void Test_STT327()
{
  {
    init_simple_test("STT327");
    static STRUCT_IF_C STT327 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT327)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT327)");
    check_field_offset(lv, fa, 0, "STT327.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT327.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT327, STT327)
//============================================================================


struct  STT337  {
  long fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT337) C1{ Fl Fi:0 FL}



static void Test_STT337()
{
  {
    init_simple_test("STT337");
    static STRUCT_IF_C STT337 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT337)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT337)");
    check_field_offset(lv, fa, 0, "STT337.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT337.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT337, STT337)
//============================================================================


struct  STT347  {
  long fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT347) C1{ Fl FL:0 FL}



static void Test_STT347()
{
  {
    init_simple_test("STT347");
    static STRUCT_IF_C STT347 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT347)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT347)");
    check_field_offset(lv, fa, 0, "STT347.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT347.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT347, STT347)
//============================================================================


struct  STT357  {
  long fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT357) C1{ Fl Fc:3 FL}



static void Test_STT357()
{
  {
    init_simple_test("STT357");
    static STRUCT_IF_C STT357 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT357)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT357)");
    check_field_offset(lv, fa, 0, "STT357.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT357.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT357, STT357)
//============================================================================


struct  STT367  {
  long fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT367) C1{ Fl Fs:3 FL}



static void Test_STT367()
{
  {
    init_simple_test("STT367");
    static STRUCT_IF_C STT367 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT367)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT367)");
    check_field_offset(lv, fa, 0, "STT367.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT367.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT367, STT367)
//============================================================================


struct  STT377  {
  long fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT377) C1{ Fl Fi:3 FL}



static void Test_STT377()
{
  {
    init_simple_test("STT377");
    static STRUCT_IF_C STT377 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT377)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT377)");
    check_field_offset(lv, fa, 0, "STT377.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT377.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT377, STT377)
//============================================================================


struct  STT387  {
  long fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT387) C1{ Fl FL:3 FL}



static void Test_STT387()
{
  {
    init_simple_test("STT387");
    static STRUCT_IF_C STT387 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT387)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT387)");
    check_field_offset(lv, fa, 0, "STT387.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT387.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT387, STT387)
//============================================================================


struct  STT397  {
  long fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT397) C1{ Fl Fs:8 FL}



static void Test_STT397()
{
  {
    init_simple_test("STT397");
    static STRUCT_IF_C STT397 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT397)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT397)");
    check_field_offset(lv, fa, 0, "STT397.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT397.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT397, STT397)
//============================================================================


struct  STT3107  {
  long fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT3107) C1{ Fl Fi:8 FL}



static void Test_STT3107()
{
  {
    init_simple_test("STT3107");
    static STRUCT_IF_C STT3107 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3107)");
    check_field_offset(lv, fa, 0, "STT3107.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3107, STT3107)
//============================================================================


struct  STT3117  {
  long fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT3117) C1{ Fl FL:8 FL}



static void Test_STT3117()
{
  {
    init_simple_test("STT3117");
    static STRUCT_IF_C STT3117 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3117)");
    check_field_offset(lv, fa, 0, "STT3117.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3117, STT3117)
//============================================================================


struct  STT3127  {
  long fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT3127) C1{ Fl Fi:18 FL}



static void Test_STT3127()
{
  {
    init_simple_test("STT3127");
    static STRUCT_IF_C STT3127 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3127)");
    check_field_offset(lv, fa, 0, "STT3127.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3127, STT3127)
//============================================================================


struct  STT3137  {
  long fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT3137) C1{ Fl FL:18 FL}



static void Test_STT3137()
{
  {
    init_simple_test("STT3137");
    static STRUCT_IF_C STT3137 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3137)");
    check_field_offset(lv, fa, 0, "STT3137.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3137, STT3137)
//============================================================================


struct  STT3147  {
  long fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT3147) C1{ Fl FL:48 FL}



static void Test_STT3147()
{
  {
    init_simple_test("STT3147");
    static STRUCT_IF_C STT3147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3147)");
    check_field_offset(lv, fa, 0, "STT3147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3147, STT3147)
//============================================================================


struct  STT3157  {
  long fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT3157) C1{ Fl Fc:3 FL}



static void Test_STT3157()
{
  {
    init_simple_test("STT3157");
    static STRUCT_IF_C STT3157 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3157)");
    check_field_offset(lv, fa, 0, "STT3157.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3157");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3157");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3157, STT3157)
//============================================================================


struct  STT3167  {
  long fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT3167) C1{ Fl Fs:3 FL}



static void Test_STT3167()
{
  {
    init_simple_test("STT3167");
    static STRUCT_IF_C STT3167 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3167)");
    check_field_offset(lv, fa, 0, "STT3167.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3167");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3167");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3167, STT3167)
//============================================================================


struct  STT3177  {
  long fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT3177) C1{ Fl Fi:3 FL}



static void Test_STT3177()
{
  {
    init_simple_test("STT3177");
    static STRUCT_IF_C STT3177 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3177)");
    check_field_offset(lv, fa, 0, "STT3177.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3177");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3177");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3177, STT3177)
//============================================================================


struct  STT3187  {
  long fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT3187) C1{ Fl FL:3 FL}



static void Test_STT3187()
{
  {
    init_simple_test("STT3187");
    static STRUCT_IF_C STT3187 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3187)");
    check_field_offset(lv, fa, 0, "STT3187.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3187");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3187");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3187, STT3187)
//============================================================================


struct  STT3197  {
  long fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT3197) C1{ Fl Fs:8 FL}



static void Test_STT3197()
{
  {
    init_simple_test("STT3197");
    static STRUCT_IF_C STT3197 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3197)");
    check_field_offset(lv, fa, 0, "STT3197.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3197");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3197");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3197, STT3197)
//============================================================================


struct  STT3207  {
  long fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT3207) C1{ Fl Fi:8 FL}



static void Test_STT3207()
{
  {
    init_simple_test("STT3207");
    static STRUCT_IF_C STT3207 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3207)");
    check_field_offset(lv, fa, 0, "STT3207.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3207");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3207");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3207, STT3207)
//============================================================================


struct  STT3217  {
  long fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT3217) C1{ Fl FL:8 FL}



static void Test_STT3217()
{
  {
    init_simple_test("STT3217");
    static STRUCT_IF_C STT3217 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3217)");
    check_field_offset(lv, fa, 0, "STT3217.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3217");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3217");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3217, STT3217)
//============================================================================


struct  STT3227  {
  long fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT3227) C1{ Fl Fi:18 FL}



static void Test_STT3227()
{
  {
    init_simple_test("STT3227");
    static STRUCT_IF_C STT3227 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3227)");
    check_field_offset(lv, fa, 0, "STT3227.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3227");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3227");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3227, STT3227)
//============================================================================


struct  STT3237  {
  long fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT3237) C1{ Fl FL:18 FL}



static void Test_STT3237()
{
  {
    init_simple_test("STT3237");
    static STRUCT_IF_C STT3237 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3237)");
    check_field_offset(lv, fa, 0, "STT3237.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3237");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3237");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3237, STT3237)
//============================================================================


struct  STT3247  {
  long fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT3247) C1{ Fl FL:48 FL}



static void Test_STT3247()
{
  {
    init_simple_test("STT3247");
    static STRUCT_IF_C STT3247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3247)");
    check_field_offset(lv, fa, 0, "STT3247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3247, STT3247)
//============================================================================


struct  STT318  {
  long fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT318) C1{ Fl Fc:0 FD}



static void Test_STT318()
{
  {
    init_simple_test("STT318");
    static STRUCT_IF_C STT318 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT318)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT318)");
    check_field_offset(lv, fa, 0, "STT318.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT318.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT318, STT318)
//============================================================================


struct  STT328  {
  long fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT328) C1{ Fl Fs:0 FD}



static void Test_STT328()
{
  {
    init_simple_test("STT328");
    static STRUCT_IF_C STT328 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT328)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT328)");
    check_field_offset(lv, fa, 0, "STT328.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT328.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT328, STT328)
//============================================================================


struct  STT338  {
  long fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT338) C1{ Fl Fi:0 FD}



static void Test_STT338()
{
  {
    init_simple_test("STT338");
    static STRUCT_IF_C STT338 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT338)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT338)");
    check_field_offset(lv, fa, 0, "STT338.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT338.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT338, STT338)
//============================================================================


struct  STT348  {
  long fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT348) C1{ Fl FL:0 FD}



static void Test_STT348()
{
  {
    init_simple_test("STT348");
    static STRUCT_IF_C STT348 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT348)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT348)");
    check_field_offset(lv, fa, 0, "STT348.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT348.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT348, STT348)
//============================================================================


struct  STT358  {
  long fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT358) C1{ Fl Fc:3 FD}



static void Test_STT358()
{
  {
    init_simple_test("STT358");
    static STRUCT_IF_C STT358 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT358)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT358)");
    check_field_offset(lv, fa, 0, "STT358.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT358.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT358, STT358)
//============================================================================


struct  STT368  {
  long fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT368) C1{ Fl Fs:3 FD}



static void Test_STT368()
{
  {
    init_simple_test("STT368");
    static STRUCT_IF_C STT368 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT368)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT368)");
    check_field_offset(lv, fa, 0, "STT368.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT368.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT368, STT368)
//============================================================================


struct  STT378  {
  long fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT378) C1{ Fl Fi:3 FD}



static void Test_STT378()
{
  {
    init_simple_test("STT378");
    static STRUCT_IF_C STT378 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT378)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT378)");
    check_field_offset(lv, fa, 0, "STT378.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT378.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT378, STT378)
//============================================================================


struct  STT388  {
  long fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT388) C1{ Fl FL:3 FD}



static void Test_STT388()
{
  {
    init_simple_test("STT388");
    static STRUCT_IF_C STT388 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT388)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT388)");
    check_field_offset(lv, fa, 0, "STT388.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT388.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT388, STT388)
//============================================================================


struct  STT398  {
  long fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT398) C1{ Fl Fs:8 FD}



static void Test_STT398()
{
  {
    init_simple_test("STT398");
    static STRUCT_IF_C STT398 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT398)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT398)");
    check_field_offset(lv, fa, 0, "STT398.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT398.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT398, STT398)
//============================================================================


struct  STT3108  {
  long fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT3108) C1{ Fl Fi:8 FD}



static void Test_STT3108()
{
  {
    init_simple_test("STT3108");
    static STRUCT_IF_C STT3108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3108)");
    check_field_offset(lv, fa, 0, "STT3108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3108, STT3108)
//============================================================================


struct  STT3118  {
  long fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT3118) C1{ Fl FL:8 FD}



static void Test_STT3118()
{
  {
    init_simple_test("STT3118");
    static STRUCT_IF_C STT3118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3118)");
    check_field_offset(lv, fa, 0, "STT3118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3118, STT3118)
//============================================================================


struct  STT3128  {
  long fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT3128) C1{ Fl Fi:18 FD}



static void Test_STT3128()
{
  {
    init_simple_test("STT3128");
    static STRUCT_IF_C STT3128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3128)");
    check_field_offset(lv, fa, 0, "STT3128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3128, STT3128)
//============================================================================


struct  STT3138  {
  long fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT3138) C1{ Fl FL:18 FD}



static void Test_STT3138()
{
  {
    init_simple_test("STT3138");
    static STRUCT_IF_C STT3138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3138)");
    check_field_offset(lv, fa, 0, "STT3138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3138, STT3138)
//============================================================================


struct  STT3148  {
  long fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT3148) C1{ Fl FL:48 FD}



static void Test_STT3148()
{
  {
    init_simple_test("STT3148");
    static STRUCT_IF_C STT3148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT3148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3148)");
    check_field_offset(lv, fa, 0, "STT3148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3148, STT3148)
//============================================================================


struct  STT3158  {
  long fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT3158) C1{ Fl Fc:3 FD}



static void Test_STT3158()
{
  {
    init_simple_test("STT3158");
    static STRUCT_IF_C STT3158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3158)");
    check_field_offset(lv, fa, 0, "STT3158.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3158");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3158, STT3158)
//============================================================================


struct  STT3168  {
  long fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT3168) C1{ Fl Fs:3 FD}



static void Test_STT3168()
{
  {
    init_simple_test("STT3168");
    static STRUCT_IF_C STT3168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3168)");
    check_field_offset(lv, fa, 0, "STT3168.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3168");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3168, STT3168)
//============================================================================


struct  STT3178  {
  long fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT3178) C1{ Fl Fi:3 FD}



static void Test_STT3178()
{
  {
    init_simple_test("STT3178");
    static STRUCT_IF_C STT3178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3178)");
    check_field_offset(lv, fa, 0, "STT3178.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3178");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3178, STT3178)
//============================================================================


struct  STT3188  {
  long fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT3188) C1{ Fl FL:3 FD}



static void Test_STT3188()
{
  {
    init_simple_test("STT3188");
    static STRUCT_IF_C STT3188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3188)");
    check_field_offset(lv, fa, 0, "STT3188.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3188");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3188, STT3188)
//============================================================================


struct  STT3198  {
  long fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT3198) C1{ Fl Fs:8 FD}



static void Test_STT3198()
{
  {
    init_simple_test("STT3198");
    static STRUCT_IF_C STT3198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3198)");
    check_field_offset(lv, fa, 0, "STT3198.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3198");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3198, STT3198)
//============================================================================


struct  STT3208  {
  long fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT3208) C1{ Fl Fi:8 FD}



static void Test_STT3208()
{
  {
    init_simple_test("STT3208");
    static STRUCT_IF_C STT3208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3208)");
    check_field_offset(lv, fa, 0, "STT3208.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3208");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3208, STT3208)
//============================================================================


struct  STT3218  {
  long fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT3218) C1{ Fl FL:8 FD}



static void Test_STT3218()
{
  {
    init_simple_test("STT3218");
    static STRUCT_IF_C STT3218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3218)");
    check_field_offset(lv, fa, 0, "STT3218.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3218");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3218, STT3218)
//============================================================================


struct  STT3228  {
  long fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT3228) C1{ Fl Fi:18 FD}



static void Test_STT3228()
{
  {
    init_simple_test("STT3228");
    static STRUCT_IF_C STT3228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3228)");
    check_field_offset(lv, fa, 0, "STT3228.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3228");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3228, STT3228)
//============================================================================


struct  STT3238  {
  long fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT3238) C1{ Fl FL:18 FD}



static void Test_STT3238()
{
  {
    init_simple_test("STT3238");
    static STRUCT_IF_C STT3238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3238)");
    check_field_offset(lv, fa, 0, "STT3238.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3238");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3238, STT3238)
//============================================================================


struct  STT3248  {
  long fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT3248) C1{ Fl FL:48 FD}



static void Test_STT3248()
{
  {
    init_simple_test("STT3248");
    static STRUCT_IF_C STT3248 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT3248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3248)");
    check_field_offset(lv, fa, 0, "STT3248.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3248");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3248");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3248, STT3248)
//============================================================================


struct  STT319  {
  long fa;
  unsigned char  :0;
};
//SIG(1 STT319) C1{ Fl Fc:0}



static void Test_STT319()
{
  {
    init_simple_test("STT319");
    static STRUCT_IF_C STT319 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT319)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT319)");
    check_field_offset(lv, fa, 0, "STT319.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT319, STT319)
//============================================================================


struct  STT329  {
  long fa;
  unsigned short  :0;
};
//SIG(1 STT329) C1{ Fl Fs:0}



static void Test_STT329()
{
  {
    init_simple_test("STT329");
    static STRUCT_IF_C STT329 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT329)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT329)");
    check_field_offset(lv, fa, 0, "STT329.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT329, STT329)
//============================================================================


struct  STT339  {
  long fa;
  unsigned int  :0;
};
//SIG(1 STT339) C1{ Fl Fi:0}



static void Test_STT339()
{
  {
    init_simple_test("STT339");
    static STRUCT_IF_C STT339 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT339)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT339)");
    check_field_offset(lv, fa, 0, "STT339.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT339, STT339)
//============================================================================


struct  STT349  {
  long fa;
  __tsu64  :0;
};
//SIG(1 STT349) C1{ Fl FL:0}



static void Test_STT349()
{
  {
    init_simple_test("STT349");
    static STRUCT_IF_C STT349 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT349)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT349)");
    check_field_offset(lv, fa, 0, "STT349.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT349, STT349)
//============================================================================


struct  STT359  {
  long fa;
  unsigned char  :3;
};
//SIG(1 STT359) C1{ Fl Fc:3}



static void Test_STT359()
{
  {
    init_simple_test("STT359");
    static STRUCT_IF_C STT359 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT359)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT359)");
    check_field_offset(lv, fa, 0, "STT359.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT359, STT359)
//============================================================================


struct  STT369  {
  long fa;
  unsigned short  :3;
};
//SIG(1 STT369) C1{ Fl Fs:3}



static void Test_STT369()
{
  {
    init_simple_test("STT369");
    static STRUCT_IF_C STT369 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT369)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT369)");
    check_field_offset(lv, fa, 0, "STT369.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT369, STT369)
//============================================================================


struct  STT379  {
  long fa;
  unsigned int  :3;
};
//SIG(1 STT379) C1{ Fl Fi:3}



static void Test_STT379()
{
  {
    init_simple_test("STT379");
    static STRUCT_IF_C STT379 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT379)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT379)");
    check_field_offset(lv, fa, 0, "STT379.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT379, STT379)
//============================================================================


struct  STT389  {
  long fa;
  __tsu64  :3;
};
//SIG(1 STT389) C1{ Fl FL:3}



static void Test_STT389()
{
  {
    init_simple_test("STT389");
    static STRUCT_IF_C STT389 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT389)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT389)");
    check_field_offset(lv, fa, 0, "STT389.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT389, STT389)
//============================================================================


struct  STT399  {
  long fa;
  unsigned short  :8;
};
//SIG(1 STT399) C1{ Fl Fs:8}



static void Test_STT399()
{
  {
    init_simple_test("STT399");
    static STRUCT_IF_C STT399 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT399)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT399)");
    check_field_offset(lv, fa, 0, "STT399.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT399, STT399)
//============================================================================


struct  STT3109  {
  long fa;
  unsigned int  :8;
};
//SIG(1 STT3109) C1{ Fl Fi:8}



static void Test_STT3109()
{
  {
    init_simple_test("STT3109");
    static STRUCT_IF_C STT3109 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3109)");
    check_field_offset(lv, fa, 0, "STT3109.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3109, STT3109)
//============================================================================


struct  STT3119  {
  long fa;
  __tsu64  :8;
};
//SIG(1 STT3119) C1{ Fl FL:8}



static void Test_STT3119()
{
  {
    init_simple_test("STT3119");
    static STRUCT_IF_C STT3119 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3119)");
    check_field_offset(lv, fa, 0, "STT3119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3119, STT3119)
//============================================================================


struct  STT3129  {
  long fa;
  unsigned int  :18;
};
//SIG(1 STT3129) C1{ Fl Fi:18}



static void Test_STT3129()
{
  {
    init_simple_test("STT3129");
    static STRUCT_IF_C STT3129 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3129)");
    check_field_offset(lv, fa, 0, "STT3129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3129, STT3129)
//============================================================================


struct  STT3139  {
  long fa;
  __tsu64  :18;
};
//SIG(1 STT3139) C1{ Fl FL:18}



static void Test_STT3139()
{
  {
    init_simple_test("STT3139");
    static STRUCT_IF_C STT3139 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3139)");
    check_field_offset(lv, fa, 0, "STT3139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3139, STT3139)
//============================================================================


struct  STT3149  {
  long fa;
  __tsu64  :48;
};
//SIG(1 STT3149) C1{ Fl FL:48}



static void Test_STT3149()
{
  {
    init_simple_test("STT3149");
    static STRUCT_IF_C STT3149 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3149)");
    check_field_offset(lv, fa, 0, "STT3149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3149, STT3149)
//============================================================================


struct  STT3159  {
  long fa;
  unsigned char bf:3;
};
//SIG(1 STT3159) C1{ Fl Fc:3}



static void Test_STT3159()
{
  {
    init_simple_test("STT3159");
    static STRUCT_IF_C STT3159 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3159)");
    check_field_offset(lv, fa, 0, "STT3159.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3159");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3159");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3159, STT3159)
//============================================================================


struct  STT3169  {
  long fa;
  unsigned short bf:3;
};
//SIG(1 STT3169) C1{ Fl Fs:3}



static void Test_STT3169()
{
  {
    init_simple_test("STT3169");
    static STRUCT_IF_C STT3169 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3169)");
    check_field_offset(lv, fa, 0, "STT3169.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3169");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3169");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3169, STT3169)
//============================================================================


struct  STT3179  {
  long fa;
  unsigned int bf:3;
};
//SIG(1 STT3179) C1{ Fl Fi:3}



static void Test_STT3179()
{
  {
    init_simple_test("STT3179");
    static STRUCT_IF_C STT3179 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3179)");
    check_field_offset(lv, fa, 0, "STT3179.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3179");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3179");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3179, STT3179)
//============================================================================


struct  STT3189  {
  long fa;
  __tsu64 bf:3;
};
//SIG(1 STT3189) C1{ Fl FL:3}



static void Test_STT3189()
{
  {
    init_simple_test("STT3189");
    static STRUCT_IF_C STT3189 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3189)");
    check_field_offset(lv, fa, 0, "STT3189.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3189");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3189");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3189, STT3189)
//============================================================================


struct  STT3199  {
  long fa;
  unsigned short bf:8;
};
//SIG(1 STT3199) C1{ Fl Fs:8}



static void Test_STT3199()
{
  {
    init_simple_test("STT3199");
    static STRUCT_IF_C STT3199 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3199)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3199)");
    check_field_offset(lv, fa, 0, "STT3199.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3199");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3199");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3199, STT3199)
//============================================================================


struct  STT3209  {
  long fa;
  unsigned int bf:8;
};
//SIG(1 STT3209) C1{ Fl Fi:8}



static void Test_STT3209()
{
  {
    init_simple_test("STT3209");
    static STRUCT_IF_C STT3209 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3209)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3209)");
    check_field_offset(lv, fa, 0, "STT3209.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3209");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3209");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3209, STT3209)
//============================================================================


struct  STT3219  {
  long fa;
  __tsu64 bf:8;
};
//SIG(1 STT3219) C1{ Fl FL:8}



static void Test_STT3219()
{
  {
    init_simple_test("STT3219");
    static STRUCT_IF_C STT3219 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3219)");
    check_field_offset(lv, fa, 0, "STT3219.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3219");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3219");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3219, STT3219)
//============================================================================


struct  STT3229  {
  long fa;
  unsigned int bf:18;
};
//SIG(1 STT3229) C1{ Fl Fi:18}



static void Test_STT3229()
{
  {
    init_simple_test("STT3229");
    static STRUCT_IF_C STT3229 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3229)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3229)");
    check_field_offset(lv, fa, 0, "STT3229.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3229");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3229");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3229, STT3229)
//============================================================================


struct  STT3239  {
  long fa;
  __tsu64 bf:18;
};
//SIG(1 STT3239) C1{ Fl FL:18}



static void Test_STT3239()
{
  {
    init_simple_test("STT3239");
    static STRUCT_IF_C STT3239 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3239)");
    check_field_offset(lv, fa, 0, "STT3239.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3239");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3239");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3239, STT3239)
//============================================================================


struct  STT3249  {
  long fa;
  __tsu64 bf:48;
};
//SIG(1 STT3249) C1{ Fl FL:48}



static void Test_STT3249()
{
  {
    init_simple_test("STT3249");
    static STRUCT_IF_C STT3249 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3249)");
    check_field_offset(lv, fa, 0, "STT3249.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3249");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3249");
  }
}
ARRANGE_TO_CALL_ME(Test_STT3249, STT3249)
//============================================================================


struct  STT410  {
  __tsi64 fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT410) C1{ FL Fc:0 Fc}



static void Test_STT410()
{
  {
    init_simple_test("STT410");
    static STRUCT_IF_C STT410 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT410)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT410)");
    check_field_offset(lv, fa, 0, "STT410.fa");
    check_field_offset(lv, fb, 8, "STT410.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT410, STT410)
//============================================================================


struct  STT420  {
  __tsi64 fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT420) C1{ FL Fs:0 Fc}



static void Test_STT420()
{
  {
    init_simple_test("STT420");
    static STRUCT_IF_C STT420 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT420)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT420)");
    check_field_offset(lv, fa, 0, "STT420.fa");
    check_field_offset(lv, fb, 8, "STT420.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT420, STT420)
//============================================================================


struct  STT430  {
  __tsi64 fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT430) C1{ FL Fi:0 Fc}



static void Test_STT430()
{
  {
    init_simple_test("STT430");
    static STRUCT_IF_C STT430 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT430)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT430)");
    check_field_offset(lv, fa, 0, "STT430.fa");
    check_field_offset(lv, fb, 8, "STT430.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT430, STT430)
//============================================================================


struct  STT440  {
  __tsi64 fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT440) C1{ FL FL:0 Fc}



static void Test_STT440()
{
  {
    init_simple_test("STT440");
    static STRUCT_IF_C STT440 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT440)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT440)");
    check_field_offset(lv, fa, 0, "STT440.fa");
    check_field_offset(lv, fb, 8, "STT440.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT440, STT440)
//============================================================================


struct  STT450  {
  __tsi64 fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT450) C1{ FL Fc:3 Fc}



static void Test_STT450()
{
  {
    init_simple_test("STT450");
    static STRUCT_IF_C STT450 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT450)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT450)");
    check_field_offset(lv, fa, 0, "STT450.fa");
    check_field_offset(lv, fb, 9, "STT450.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT450, STT450)
//============================================================================


struct  STT460  {
  __tsi64 fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT460) C1{ FL Fs:3 Fc}



static void Test_STT460()
{
  {
    init_simple_test("STT460");
    static STRUCT_IF_C STT460 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT460)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT460)");
    check_field_offset(lv, fa, 0, "STT460.fa");
    check_field_offset(lv, fb, 9, "STT460.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT460, STT460)
//============================================================================


struct  STT470  {
  __tsi64 fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT470) C1{ FL Fi:3 Fc}



static void Test_STT470()
{
  {
    init_simple_test("STT470");
    static STRUCT_IF_C STT470 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT470)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT470)");
    check_field_offset(lv, fa, 0, "STT470.fa");
    check_field_offset(lv, fb, 9, "STT470.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT470, STT470)
//============================================================================


struct  STT480  {
  __tsi64 fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT480) C1{ FL FL:3 Fc}



static void Test_STT480()
{
  {
    init_simple_test("STT480");
    static STRUCT_IF_C STT480 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT480)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT480)");
    check_field_offset(lv, fa, 0, "STT480.fa");
    check_field_offset(lv, fb, 9, "STT480.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT480, STT480)
//============================================================================


struct  STT490  {
  __tsi64 fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT490) C1{ FL Fs:8 Fc}



static void Test_STT490()
{
  {
    init_simple_test("STT490");
    static STRUCT_IF_C STT490 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT490)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT490)");
    check_field_offset(lv, fa, 0, "STT490.fa");
    check_field_offset(lv, fb, 9, "STT490.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT490, STT490)
//============================================================================


struct  STT4100  {
  __tsi64 fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT4100) C1{ FL Fi:8 Fc}



static void Test_STT4100()
{
  {
    init_simple_test("STT4100");
    static STRUCT_IF_C STT4100 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4100)");
    check_field_offset(lv, fa, 0, "STT4100.fa");
    check_field_offset(lv, fb, 9, "STT4100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4100, STT4100)
//============================================================================


struct  STT4110  {
  __tsi64 fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT4110) C1{ FL FL:8 Fc}



static void Test_STT4110()
{
  {
    init_simple_test("STT4110");
    static STRUCT_IF_C STT4110 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4110)");
    check_field_offset(lv, fa, 0, "STT4110.fa");
    check_field_offset(lv, fb, 9, "STT4110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4110, STT4110)
//============================================================================


struct  STT4120  {
  __tsi64 fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT4120) C1{ FL Fi:18 Fc}



static void Test_STT4120()
{
  {
    init_simple_test("STT4120");
    static STRUCT_IF_C STT4120 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4120)");
    check_field_offset(lv, fa, 0, "STT4120.fa");
    check_field_offset(lv, fb, 11, "STT4120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4120, STT4120)
//============================================================================


struct  STT4130  {
  __tsi64 fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT4130) C1{ FL FL:18 Fc}



static void Test_STT4130()
{
  {
    init_simple_test("STT4130");
    static STRUCT_IF_C STT4130 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4130)");
    check_field_offset(lv, fa, 0, "STT4130.fa");
    check_field_offset(lv, fb, 11, "STT4130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4130, STT4130)
//============================================================================


struct  STT4140  {
  __tsi64 fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT4140) C1{ FL FL:48 Fc}



static void Test_STT4140()
{
  {
    init_simple_test("STT4140");
    static STRUCT_IF_C STT4140 lv;
    check2(sizeof(lv), 16, "sizeof(STT4140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4140)");
    check_field_offset(lv, fa, 0, "STT4140.fa");
    check_field_offset(lv, fb, 14, "STT4140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4140, STT4140)
//============================================================================


struct  STT4150  {
  __tsi64 fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT4150) C1{ FL Fc:3 Fc}



static void Test_STT4150()
{
  {
    init_simple_test("STT4150");
    static STRUCT_IF_C STT4150 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4150)");
    check_field_offset(lv, fa, 0, "STT4150.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4150");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4150");
    check_field_offset(lv, fb, 9, "STT4150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4150, STT4150)
//============================================================================


struct  STT4160  {
  __tsi64 fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT4160) C1{ FL Fs:3 Fc}



static void Test_STT4160()
{
  {
    init_simple_test("STT4160");
    static STRUCT_IF_C STT4160 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4160)");
    check_field_offset(lv, fa, 0, "STT4160.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4160");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4160");
    check_field_offset(lv, fb, 9, "STT4160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4160, STT4160)
//============================================================================


struct  STT4170  {
  __tsi64 fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT4170) C1{ FL Fi:3 Fc}



static void Test_STT4170()
{
  {
    init_simple_test("STT4170");
    static STRUCT_IF_C STT4170 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4170)");
    check_field_offset(lv, fa, 0, "STT4170.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4170");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4170");
    check_field_offset(lv, fb, 9, "STT4170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4170, STT4170)
//============================================================================


struct  STT4180  {
  __tsi64 fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT4180) C1{ FL FL:3 Fc}



static void Test_STT4180()
{
  {
    init_simple_test("STT4180");
    static STRUCT_IF_C STT4180 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4180)");
    check_field_offset(lv, fa, 0, "STT4180.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4180");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4180");
    check_field_offset(lv, fb, 9, "STT4180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4180, STT4180)
//============================================================================


struct  STT4190  {
  __tsi64 fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT4190) C1{ FL Fs:8 Fc}



static void Test_STT4190()
{
  {
    init_simple_test("STT4190");
    static STRUCT_IF_C STT4190 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4190)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4190)");
    check_field_offset(lv, fa, 0, "STT4190.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4190");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4190");
    check_field_offset(lv, fb, 9, "STT4190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4190, STT4190)
//============================================================================


struct  STT4200  {
  __tsi64 fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT4200) C1{ FL Fi:8 Fc}



static void Test_STT4200()
{
  {
    init_simple_test("STT4200");
    static STRUCT_IF_C STT4200 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4200)");
    check_field_offset(lv, fa, 0, "STT4200.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4200");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4200");
    check_field_offset(lv, fb, 9, "STT4200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4200, STT4200)
//============================================================================


struct  STT4210  {
  __tsi64 fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT4210) C1{ FL FL:8 Fc}



static void Test_STT4210()
{
  {
    init_simple_test("STT4210");
    static STRUCT_IF_C STT4210 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4210)");
    check_field_offset(lv, fa, 0, "STT4210.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4210");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4210");
    check_field_offset(lv, fb, 9, "STT4210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4210, STT4210)
//============================================================================


struct  STT4220  {
  __tsi64 fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT4220) C1{ FL Fi:18 Fc}



static void Test_STT4220()
{
  {
    init_simple_test("STT4220");
    static STRUCT_IF_C STT4220 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4220)");
    check_field_offset(lv, fa, 0, "STT4220.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4220");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4220");
    check_field_offset(lv, fb, 11, "STT4220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4220, STT4220)
//============================================================================


struct  STT4230  {
  __tsi64 fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT4230) C1{ FL FL:18 Fc}



static void Test_STT4230()
{
  {
    init_simple_test("STT4230");
    static STRUCT_IF_C STT4230 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4230)");
    check_field_offset(lv, fa, 0, "STT4230.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4230");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4230");
    check_field_offset(lv, fb, 11, "STT4230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4230, STT4230)
//============================================================================


struct  STT4240  {
  __tsi64 fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT4240) C1{ FL FL:48 Fc}



static void Test_STT4240()
{
  {
    init_simple_test("STT4240");
    static STRUCT_IF_C STT4240 lv;
    check2(sizeof(lv), 16, "sizeof(STT4240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4240)");
    check_field_offset(lv, fa, 0, "STT4240.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4240");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4240");
    check_field_offset(lv, fb, 14, "STT4240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4240, STT4240)
//============================================================================


struct  STT411  {
  __tsi64 fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT411) C1{ FL Fc:0 Fs}



static void Test_STT411()
{
  {
    init_simple_test("STT411");
    static STRUCT_IF_C STT411 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT411)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT411)");
    check_field_offset(lv, fa, 0, "STT411.fa");
    check_field_offset(lv, fb, 8, "STT411.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT411, STT411)
//============================================================================


struct  STT421  {
  __tsi64 fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT421) C1{ FL Fs:0 Fs}



static void Test_STT421()
{
  {
    init_simple_test("STT421");
    static STRUCT_IF_C STT421 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT421)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT421)");
    check_field_offset(lv, fa, 0, "STT421.fa");
    check_field_offset(lv, fb, 8, "STT421.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT421, STT421)
//============================================================================


struct  STT431  {
  __tsi64 fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT431) C1{ FL Fi:0 Fs}



static void Test_STT431()
{
  {
    init_simple_test("STT431");
    static STRUCT_IF_C STT431 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT431)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT431)");
    check_field_offset(lv, fa, 0, "STT431.fa");
    check_field_offset(lv, fb, 8, "STT431.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT431, STT431)
//============================================================================


struct  STT441  {
  __tsi64 fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT441) C1{ FL FL:0 Fs}



static void Test_STT441()
{
  {
    init_simple_test("STT441");
    static STRUCT_IF_C STT441 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT441)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT441)");
    check_field_offset(lv, fa, 0, "STT441.fa");
    check_field_offset(lv, fb, 8, "STT441.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT441, STT441)
//============================================================================


struct  STT451  {
  __tsi64 fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT451) C1{ FL Fc:3 Fs}



static void Test_STT451()
{
  {
    init_simple_test("STT451");
    static STRUCT_IF_C STT451 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT451)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT451)");
    check_field_offset(lv, fa, 0, "STT451.fa");
    check_field_offset(lv, fb, 10, "STT451.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT451, STT451)
//============================================================================


struct  STT461  {
  __tsi64 fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT461) C1{ FL Fs:3 Fs}



static void Test_STT461()
{
  {
    init_simple_test("STT461");
    static STRUCT_IF_C STT461 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT461)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT461)");
    check_field_offset(lv, fa, 0, "STT461.fa");
    check_field_offset(lv, fb, 10, "STT461.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT461, STT461)
//============================================================================


struct  STT471  {
  __tsi64 fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT471) C1{ FL Fi:3 Fs}



static void Test_STT471()
{
  {
    init_simple_test("STT471");
    static STRUCT_IF_C STT471 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT471)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT471)");
    check_field_offset(lv, fa, 0, "STT471.fa");
    check_field_offset(lv, fb, 10, "STT471.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT471, STT471)
//============================================================================


struct  STT481  {
  __tsi64 fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT481) C1{ FL FL:3 Fs}



static void Test_STT481()
{
  {
    init_simple_test("STT481");
    static STRUCT_IF_C STT481 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT481)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT481)");
    check_field_offset(lv, fa, 0, "STT481.fa");
    check_field_offset(lv, fb, 10, "STT481.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT481, STT481)
//============================================================================


struct  STT491  {
  __tsi64 fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT491) C1{ FL Fs:8 Fs}



static void Test_STT491()
{
  {
    init_simple_test("STT491");
    static STRUCT_IF_C STT491 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT491)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT491)");
    check_field_offset(lv, fa, 0, "STT491.fa");
    check_field_offset(lv, fb, 10, "STT491.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT491, STT491)
//============================================================================


struct  STT4101  {
  __tsi64 fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT4101) C1{ FL Fi:8 Fs}



static void Test_STT4101()
{
  {
    init_simple_test("STT4101");
    static STRUCT_IF_C STT4101 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4101)");
    check_field_offset(lv, fa, 0, "STT4101.fa");
    check_field_offset(lv, fb, 10, "STT4101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4101, STT4101)
//============================================================================


struct  STT4111  {
  __tsi64 fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT4111) C1{ FL FL:8 Fs}



static void Test_STT4111()
{
  {
    init_simple_test("STT4111");
    static STRUCT_IF_C STT4111 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4111)");
    check_field_offset(lv, fa, 0, "STT4111.fa");
    check_field_offset(lv, fb, 10, "STT4111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4111, STT4111)
//============================================================================


struct  STT4121  {
  __tsi64 fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT4121) C1{ FL Fi:18 Fs}



static void Test_STT4121()
{
  {
    init_simple_test("STT4121");
    static STRUCT_IF_C STT4121 lv;
    check2(sizeof(lv), 16, "sizeof(STT4121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4121)");
    check_field_offset(lv, fa, 0, "STT4121.fa");
    check_field_offset(lv, fb, 12, "STT4121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4121, STT4121)
//============================================================================


struct  STT4131  {
  __tsi64 fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT4131) C1{ FL FL:18 Fs}



static void Test_STT4131()
{
  {
    init_simple_test("STT4131");
    static STRUCT_IF_C STT4131 lv;
    check2(sizeof(lv), 16, "sizeof(STT4131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4131)");
    check_field_offset(lv, fa, 0, "STT4131.fa");
    check_field_offset(lv, fb, 12, "STT4131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4131, STT4131)
//============================================================================


struct  STT4141  {
  __tsi64 fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT4141) C1{ FL FL:48 Fs}



static void Test_STT4141()
{
  {
    init_simple_test("STT4141");
    static STRUCT_IF_C STT4141 lv;
    check2(sizeof(lv), 16, "sizeof(STT4141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4141)");
    check_field_offset(lv, fa, 0, "STT4141.fa");
    check_field_offset(lv, fb, 14, "STT4141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4141, STT4141)
//============================================================================


struct  STT4151  {
  __tsi64 fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT4151) C1{ FL Fc:3 Fs}



static void Test_STT4151()
{
  {
    init_simple_test("STT4151");
    static STRUCT_IF_C STT4151 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4151)");
    check_field_offset(lv, fa, 0, "STT4151.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4151");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4151");
    check_field_offset(lv, fb, 10, "STT4151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4151, STT4151)
//============================================================================


struct  STT4161  {
  __tsi64 fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT4161) C1{ FL Fs:3 Fs}



static void Test_STT4161()
{
  {
    init_simple_test("STT4161");
    static STRUCT_IF_C STT4161 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4161)");
    check_field_offset(lv, fa, 0, "STT4161.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4161");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4161");
    check_field_offset(lv, fb, 10, "STT4161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4161, STT4161)
//============================================================================


struct  STT4171  {
  __tsi64 fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT4171) C1{ FL Fi:3 Fs}



static void Test_STT4171()
{
  {
    init_simple_test("STT4171");
    static STRUCT_IF_C STT4171 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4171)");
    check_field_offset(lv, fa, 0, "STT4171.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4171");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4171");
    check_field_offset(lv, fb, 10, "STT4171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4171, STT4171)
//============================================================================


struct  STT4181  {
  __tsi64 fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT4181) C1{ FL FL:3 Fs}



static void Test_STT4181()
{
  {
    init_simple_test("STT4181");
    static STRUCT_IF_C STT4181 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4181)");
    check_field_offset(lv, fa, 0, "STT4181.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4181");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4181");
    check_field_offset(lv, fb, 10, "STT4181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4181, STT4181)
//============================================================================


struct  STT4191  {
  __tsi64 fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT4191) C1{ FL Fs:8 Fs}



static void Test_STT4191()
{
  {
    init_simple_test("STT4191");
    static STRUCT_IF_C STT4191 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4191)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4191)");
    check_field_offset(lv, fa, 0, "STT4191.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4191");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4191");
    check_field_offset(lv, fb, 10, "STT4191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4191, STT4191)
//============================================================================


struct  STT4201  {
  __tsi64 fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT4201) C1{ FL Fi:8 Fs}



static void Test_STT4201()
{
  {
    init_simple_test("STT4201");
    static STRUCT_IF_C STT4201 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4201)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4201)");
    check_field_offset(lv, fa, 0, "STT4201.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4201");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4201");
    check_field_offset(lv, fb, 10, "STT4201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4201, STT4201)
//============================================================================


struct  STT4211  {
  __tsi64 fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT4211) C1{ FL FL:8 Fs}



static void Test_STT4211()
{
  {
    init_simple_test("STT4211");
    static STRUCT_IF_C STT4211 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4211)");
    check_field_offset(lv, fa, 0, "STT4211.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4211");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4211");
    check_field_offset(lv, fb, 10, "STT4211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4211, STT4211)
//============================================================================


struct  STT4221  {
  __tsi64 fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT4221) C1{ FL Fi:18 Fs}



static void Test_STT4221()
{
  {
    init_simple_test("STT4221");
    static STRUCT_IF_C STT4221 lv;
    check2(sizeof(lv), 16, "sizeof(STT4221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4221)");
    check_field_offset(lv, fa, 0, "STT4221.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4221");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4221");
    check_field_offset(lv, fb, 12, "STT4221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4221, STT4221)
//============================================================================


struct  STT4231  {
  __tsi64 fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT4231) C1{ FL FL:18 Fs}



static void Test_STT4231()
{
  {
    init_simple_test("STT4231");
    static STRUCT_IF_C STT4231 lv;
    check2(sizeof(lv), 16, "sizeof(STT4231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4231)");
    check_field_offset(lv, fa, 0, "STT4231.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4231");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4231");
    check_field_offset(lv, fb, 12, "STT4231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4231, STT4231)
//============================================================================


struct  STT4241  {
  __tsi64 fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT4241) C1{ FL FL:48 Fs}



static void Test_STT4241()
{
  {
    init_simple_test("STT4241");
    static STRUCT_IF_C STT4241 lv;
    check2(sizeof(lv), 16, "sizeof(STT4241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4241)");
    check_field_offset(lv, fa, 0, "STT4241.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4241");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4241");
    check_field_offset(lv, fb, 14, "STT4241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4241, STT4241)
//============================================================================


struct  STT412  {
  __tsi64 fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT412) C1{ FL Fc:0 Fi}



static void Test_STT412()
{
  {
    init_simple_test("STT412");
    static STRUCT_IF_C STT412 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT412)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT412)");
    check_field_offset(lv, fa, 0, "STT412.fa");
    check_field_offset(lv, fb, 8, "STT412.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT412, STT412)
//============================================================================


struct  STT422  {
  __tsi64 fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT422) C1{ FL Fs:0 Fi}



static void Test_STT422()
{
  {
    init_simple_test("STT422");
    static STRUCT_IF_C STT422 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT422)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT422)");
    check_field_offset(lv, fa, 0, "STT422.fa");
    check_field_offset(lv, fb, 8, "STT422.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT422, STT422)
//============================================================================


struct  STT432  {
  __tsi64 fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT432) C1{ FL Fi:0 Fi}



static void Test_STT432()
{
  {
    init_simple_test("STT432");
    static STRUCT_IF_C STT432 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT432)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT432)");
    check_field_offset(lv, fa, 0, "STT432.fa");
    check_field_offset(lv, fb, 8, "STT432.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT432, STT432)
//============================================================================


struct  STT442  {
  __tsi64 fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT442) C1{ FL FL:0 Fi}



static void Test_STT442()
{
  {
    init_simple_test("STT442");
    static STRUCT_IF_C STT442 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT442)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT442)");
    check_field_offset(lv, fa, 0, "STT442.fa");
    check_field_offset(lv, fb, 8, "STT442.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT442, STT442)
//============================================================================


struct  STT452  {
  __tsi64 fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT452) C1{ FL Fc:3 Fi}



static void Test_STT452()
{
  {
    init_simple_test("STT452");
    static STRUCT_IF_C STT452 lv;
    check2(sizeof(lv), 16, "sizeof(STT452)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT452)");
    check_field_offset(lv, fa, 0, "STT452.fa");
    check_field_offset(lv, fb, 12, "STT452.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT452, STT452)
//============================================================================


struct  STT462  {
  __tsi64 fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT462) C1{ FL Fs:3 Fi}



static void Test_STT462()
{
  {
    init_simple_test("STT462");
    static STRUCT_IF_C STT462 lv;
    check2(sizeof(lv), 16, "sizeof(STT462)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT462)");
    check_field_offset(lv, fa, 0, "STT462.fa");
    check_field_offset(lv, fb, 12, "STT462.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT462, STT462)
//============================================================================


struct  STT472  {
  __tsi64 fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT472) C1{ FL Fi:3 Fi}



static void Test_STT472()
{
  {
    init_simple_test("STT472");
    static STRUCT_IF_C STT472 lv;
    check2(sizeof(lv), 16, "sizeof(STT472)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT472)");
    check_field_offset(lv, fa, 0, "STT472.fa");
    check_field_offset(lv, fb, 12, "STT472.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT472, STT472)
//============================================================================


struct  STT482  {
  __tsi64 fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT482) C1{ FL FL:3 Fi}



static void Test_STT482()
{
  {
    init_simple_test("STT482");
    static STRUCT_IF_C STT482 lv;
    check2(sizeof(lv), 16, "sizeof(STT482)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT482)");
    check_field_offset(lv, fa, 0, "STT482.fa");
    check_field_offset(lv, fb, 12, "STT482.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT482, STT482)
//============================================================================


struct  STT492  {
  __tsi64 fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT492) C1{ FL Fs:8 Fi}



static void Test_STT492()
{
  {
    init_simple_test("STT492");
    static STRUCT_IF_C STT492 lv;
    check2(sizeof(lv), 16, "sizeof(STT492)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT492)");
    check_field_offset(lv, fa, 0, "STT492.fa");
    check_field_offset(lv, fb, 12, "STT492.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT492, STT492)
//============================================================================


struct  STT4102  {
  __tsi64 fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT4102) C1{ FL Fi:8 Fi}



static void Test_STT4102()
{
  {
    init_simple_test("STT4102");
    static STRUCT_IF_C STT4102 lv;
    check2(sizeof(lv), 16, "sizeof(STT4102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4102)");
    check_field_offset(lv, fa, 0, "STT4102.fa");
    check_field_offset(lv, fb, 12, "STT4102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4102, STT4102)
//============================================================================


struct  STT4112  {
  __tsi64 fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT4112) C1{ FL FL:8 Fi}



static void Test_STT4112()
{
  {
    init_simple_test("STT4112");
    static STRUCT_IF_C STT4112 lv;
    check2(sizeof(lv), 16, "sizeof(STT4112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4112)");
    check_field_offset(lv, fa, 0, "STT4112.fa");
    check_field_offset(lv, fb, 12, "STT4112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4112, STT4112)
//============================================================================


struct  STT4122  {
  __tsi64 fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT4122) C1{ FL Fi:18 Fi}



static void Test_STT4122()
{
  {
    init_simple_test("STT4122");
    static STRUCT_IF_C STT4122 lv;
    check2(sizeof(lv), 16, "sizeof(STT4122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4122)");
    check_field_offset(lv, fa, 0, "STT4122.fa");
    check_field_offset(lv, fb, 12, "STT4122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4122, STT4122)
//============================================================================


struct  STT4132  {
  __tsi64 fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT4132) C1{ FL FL:18 Fi}



static void Test_STT4132()
{
  {
    init_simple_test("STT4132");
    static STRUCT_IF_C STT4132 lv;
    check2(sizeof(lv), 16, "sizeof(STT4132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4132)");
    check_field_offset(lv, fa, 0, "STT4132.fa");
    check_field_offset(lv, fb, 12, "STT4132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4132, STT4132)
//============================================================================


struct  STT4142  {
  __tsi64 fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT4142) C1{ FL FL:48 Fi}



static void Test_STT4142()
{
  {
    init_simple_test("STT4142");
    static STRUCT_IF_C STT4142 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4142)");
    check_field_offset(lv, fa, 0, "STT4142.fa");
    check_field_offset(lv, fb, 16, "STT4142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4142, STT4142)
//============================================================================


struct  STT4152  {
  __tsi64 fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT4152) C1{ FL Fc:3 Fi}



static void Test_STT4152()
{
  {
    init_simple_test("STT4152");
    static STRUCT_IF_C STT4152 lv;
    check2(sizeof(lv), 16, "sizeof(STT4152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4152)");
    check_field_offset(lv, fa, 0, "STT4152.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4152");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4152");
    check_field_offset(lv, fb, 12, "STT4152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4152, STT4152)
//============================================================================


struct  STT4162  {
  __tsi64 fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT4162) C1{ FL Fs:3 Fi}



static void Test_STT4162()
{
  {
    init_simple_test("STT4162");
    static STRUCT_IF_C STT4162 lv;
    check2(sizeof(lv), 16, "sizeof(STT4162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4162)");
    check_field_offset(lv, fa, 0, "STT4162.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4162");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4162");
    check_field_offset(lv, fb, 12, "STT4162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4162, STT4162)
//============================================================================


struct  STT4172  {
  __tsi64 fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT4172) C1{ FL Fi:3 Fi}



static void Test_STT4172()
{
  {
    init_simple_test("STT4172");
    static STRUCT_IF_C STT4172 lv;
    check2(sizeof(lv), 16, "sizeof(STT4172)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4172)");
    check_field_offset(lv, fa, 0, "STT4172.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4172");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4172");
    check_field_offset(lv, fb, 12, "STT4172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4172, STT4172)
//============================================================================


struct  STT4182  {
  __tsi64 fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT4182) C1{ FL FL:3 Fi}



static void Test_STT4182()
{
  {
    init_simple_test("STT4182");
    static STRUCT_IF_C STT4182 lv;
    check2(sizeof(lv), 16, "sizeof(STT4182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4182)");
    check_field_offset(lv, fa, 0, "STT4182.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4182");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4182");
    check_field_offset(lv, fb, 12, "STT4182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4182, STT4182)
//============================================================================


struct  STT4192  {
  __tsi64 fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT4192) C1{ FL Fs:8 Fi}



static void Test_STT4192()
{
  {
    init_simple_test("STT4192");
    static STRUCT_IF_C STT4192 lv;
    check2(sizeof(lv), 16, "sizeof(STT4192)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4192)");
    check_field_offset(lv, fa, 0, "STT4192.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4192");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4192");
    check_field_offset(lv, fb, 12, "STT4192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4192, STT4192)
//============================================================================


struct  STT4202  {
  __tsi64 fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT4202) C1{ FL Fi:8 Fi}



static void Test_STT4202()
{
  {
    init_simple_test("STT4202");
    static STRUCT_IF_C STT4202 lv;
    check2(sizeof(lv), 16, "sizeof(STT4202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4202)");
    check_field_offset(lv, fa, 0, "STT4202.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4202");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4202");
    check_field_offset(lv, fb, 12, "STT4202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4202, STT4202)
//============================================================================


struct  STT4212  {
  __tsi64 fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT4212) C1{ FL FL:8 Fi}



static void Test_STT4212()
{
  {
    init_simple_test("STT4212");
    static STRUCT_IF_C STT4212 lv;
    check2(sizeof(lv), 16, "sizeof(STT4212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4212)");
    check_field_offset(lv, fa, 0, "STT4212.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4212");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4212");
    check_field_offset(lv, fb, 12, "STT4212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4212, STT4212)
//============================================================================


struct  STT4222  {
  __tsi64 fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT4222) C1{ FL Fi:18 Fi}



static void Test_STT4222()
{
  {
    init_simple_test("STT4222");
    static STRUCT_IF_C STT4222 lv;
    check2(sizeof(lv), 16, "sizeof(STT4222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4222)");
    check_field_offset(lv, fa, 0, "STT4222.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4222");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4222");
    check_field_offset(lv, fb, 12, "STT4222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4222, STT4222)
//============================================================================


struct  STT4232  {
  __tsi64 fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT4232) C1{ FL FL:18 Fi}



static void Test_STT4232()
{
  {
    init_simple_test("STT4232");
    static STRUCT_IF_C STT4232 lv;
    check2(sizeof(lv), 16, "sizeof(STT4232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4232)");
    check_field_offset(lv, fa, 0, "STT4232.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4232");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4232");
    check_field_offset(lv, fb, 12, "STT4232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4232, STT4232)
//============================================================================


struct  STT4242  {
  __tsi64 fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT4242) C1{ FL FL:48 Fi}



static void Test_STT4242()
{
  {
    init_simple_test("STT4242");
    static STRUCT_IF_C STT4242 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4242)");
    check_field_offset(lv, fa, 0, "STT4242.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4242");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4242");
    check_field_offset(lv, fb, 16, "STT4242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4242, STT4242)
//============================================================================


struct  STT413  {
  __tsi64 fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT413) C1{ FL Fc:0 Fl}



static void Test_STT413()
{
  {
    init_simple_test("STT413");
    static STRUCT_IF_C STT413 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT413)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT413)");
    check_field_offset(lv, fa, 0, "STT413.fa");
    check_field_offset(lv, fb, 8, "STT413.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT413, STT413)
//============================================================================


struct  STT423  {
  __tsi64 fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT423) C1{ FL Fs:0 Fl}



static void Test_STT423()
{
  {
    init_simple_test("STT423");
    static STRUCT_IF_C STT423 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT423)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT423)");
    check_field_offset(lv, fa, 0, "STT423.fa");
    check_field_offset(lv, fb, 8, "STT423.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT423, STT423)
//============================================================================


struct  STT433  {
  __tsi64 fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT433) C1{ FL Fi:0 Fl}



static void Test_STT433()
{
  {
    init_simple_test("STT433");
    static STRUCT_IF_C STT433 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT433)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT433)");
    check_field_offset(lv, fa, 0, "STT433.fa");
    check_field_offset(lv, fb, 8, "STT433.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT433, STT433)
//============================================================================


struct  STT443  {
  __tsi64 fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT443) C1{ FL FL:0 Fl}



static void Test_STT443()
{
  {
    init_simple_test("STT443");
    static STRUCT_IF_C STT443 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT443)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT443)");
    check_field_offset(lv, fa, 0, "STT443.fa");
    check_field_offset(lv, fb, 8, "STT443.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT443, STT443)
//============================================================================


struct  STT453  {
  __tsi64 fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT453) C1{ FL Fc:3 Fl}



static void Test_STT453()
{
  {
    init_simple_test("STT453");
    static STRUCT_IF_C STT453 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT453)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT453)");
    check_field_offset(lv, fa, 0, "STT453.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT453.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT453, STT453)
//============================================================================


struct  STT463  {
  __tsi64 fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT463) C1{ FL Fs:3 Fl}



static void Test_STT463()
{
  {
    init_simple_test("STT463");
    static STRUCT_IF_C STT463 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT463)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT463)");
    check_field_offset(lv, fa, 0, "STT463.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT463.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT463, STT463)
//============================================================================


struct  STT473  {
  __tsi64 fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT473) C1{ FL Fi:3 Fl}



static void Test_STT473()
{
  {
    init_simple_test("STT473");
    static STRUCT_IF_C STT473 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT473)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT473)");
    check_field_offset(lv, fa, 0, "STT473.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT473.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT473, STT473)
//============================================================================


struct  STT483  {
  __tsi64 fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT483) C1{ FL FL:3 Fl}



static void Test_STT483()
{
  {
    init_simple_test("STT483");
    static STRUCT_IF_C STT483 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT483)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT483)");
    check_field_offset(lv, fa, 0, "STT483.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT483.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT483, STT483)
//============================================================================


struct  STT493  {
  __tsi64 fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT493) C1{ FL Fs:8 Fl}



static void Test_STT493()
{
  {
    init_simple_test("STT493");
    static STRUCT_IF_C STT493 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT493)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT493)");
    check_field_offset(lv, fa, 0, "STT493.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT493.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT493, STT493)
//============================================================================


struct  STT4103  {
  __tsi64 fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT4103) C1{ FL Fi:8 Fl}



static void Test_STT4103()
{
  {
    init_simple_test("STT4103");
    static STRUCT_IF_C STT4103 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4103)");
    check_field_offset(lv, fa, 0, "STT4103.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4103, STT4103)
//============================================================================


struct  STT4113  {
  __tsi64 fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT4113) C1{ FL FL:8 Fl}



static void Test_STT4113()
{
  {
    init_simple_test("STT4113");
    static STRUCT_IF_C STT4113 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4113)");
    check_field_offset(lv, fa, 0, "STT4113.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4113, STT4113)
//============================================================================


struct  STT4123  {
  __tsi64 fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT4123) C1{ FL Fi:18 Fl}



static void Test_STT4123()
{
  {
    init_simple_test("STT4123");
    static STRUCT_IF_C STT4123 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4123)");
    check_field_offset(lv, fa, 0, "STT4123.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4123, STT4123)
//============================================================================


struct  STT4133  {
  __tsi64 fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT4133) C1{ FL FL:18 Fl}



static void Test_STT4133()
{
  {
    init_simple_test("STT4133");
    static STRUCT_IF_C STT4133 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4133)");
    check_field_offset(lv, fa, 0, "STT4133.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4133, STT4133)
//============================================================================


struct  STT4143  {
  __tsi64 fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT4143) C1{ FL FL:48 Fl}



static void Test_STT4143()
{
  {
    init_simple_test("STT4143");
    static STRUCT_IF_C STT4143 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4143)");
    check_field_offset(lv, fa, 0, "STT4143.fa");
    check_field_offset(lv, fb, 16, "STT4143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4143, STT4143)
//============================================================================


struct  STT4153  {
  __tsi64 fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT4153) C1{ FL Fc:3 Fl}



static void Test_STT4153()
{
  {
    init_simple_test("STT4153");
    static STRUCT_IF_C STT4153 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4153)");
    check_field_offset(lv, fa, 0, "STT4153.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4153");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4153");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4153, STT4153)
//============================================================================


struct  STT4163  {
  __tsi64 fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT4163) C1{ FL Fs:3 Fl}



static void Test_STT4163()
{
  {
    init_simple_test("STT4163");
    static STRUCT_IF_C STT4163 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4163)");
    check_field_offset(lv, fa, 0, "STT4163.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4163");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4163");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4163, STT4163)
//============================================================================


struct  STT4173  {
  __tsi64 fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT4173) C1{ FL Fi:3 Fl}



static void Test_STT4173()
{
  {
    init_simple_test("STT4173");
    static STRUCT_IF_C STT4173 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4173)");
    check_field_offset(lv, fa, 0, "STT4173.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4173");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4173");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4173, STT4173)
//============================================================================


struct  STT4183  {
  __tsi64 fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT4183) C1{ FL FL:3 Fl}



static void Test_STT4183()
{
  {
    init_simple_test("STT4183");
    static STRUCT_IF_C STT4183 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4183)");
    check_field_offset(lv, fa, 0, "STT4183.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4183");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4183");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4183, STT4183)
//============================================================================


struct  STT4193  {
  __tsi64 fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT4193) C1{ FL Fs:8 Fl}



static void Test_STT4193()
{
  {
    init_simple_test("STT4193");
    static STRUCT_IF_C STT4193 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4193)");
    check_field_offset(lv, fa, 0, "STT4193.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4193");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4193");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4193, STT4193)
//============================================================================


struct  STT4203  {
  __tsi64 fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT4203) C1{ FL Fi:8 Fl}



static void Test_STT4203()
{
  {
    init_simple_test("STT4203");
    static STRUCT_IF_C STT4203 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4203)");
    check_field_offset(lv, fa, 0, "STT4203.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4203");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4203");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4203, STT4203)
//============================================================================


struct  STT4213  {
  __tsi64 fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT4213) C1{ FL FL:8 Fl}



static void Test_STT4213()
{
  {
    init_simple_test("STT4213");
    static STRUCT_IF_C STT4213 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4213)");
    check_field_offset(lv, fa, 0, "STT4213.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4213");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4213");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4213, STT4213)
//============================================================================


struct  STT4223  {
  __tsi64 fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT4223) C1{ FL Fi:18 Fl}



static void Test_STT4223()
{
  {
    init_simple_test("STT4223");
    static STRUCT_IF_C STT4223 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4223)");
    check_field_offset(lv, fa, 0, "STT4223.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4223");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4223");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4223, STT4223)
//============================================================================


struct  STT4233  {
  __tsi64 fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT4233) C1{ FL FL:18 Fl}



static void Test_STT4233()
{
  {
    init_simple_test("STT4233");
    static STRUCT_IF_C STT4233 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4233)");
    check_field_offset(lv, fa, 0, "STT4233.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4233");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4233");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4233, STT4233)
//============================================================================


struct  STT4243  {
  __tsi64 fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT4243) C1{ FL FL:48 Fl}



static void Test_STT4243()
{
  {
    init_simple_test("STT4243");
    static STRUCT_IF_C STT4243 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4243)");
    check_field_offset(lv, fa, 0, "STT4243.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4243");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4243");
    check_field_offset(lv, fb, 16, "STT4243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4243, STT4243)
//============================================================================


struct  STT414  {
  __tsi64 fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT414) C1{ FL Fc:0 FL}



static void Test_STT414()
{
  {
    init_simple_test("STT414");
    static STRUCT_IF_C STT414 lv;
    check2(sizeof(lv), 16, "sizeof(STT414)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT414)");
    check_field_offset(lv, fa, 0, "STT414.fa");
    check_field_offset(lv, fb, 8, "STT414.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT414, STT414)
//============================================================================


struct  STT424  {
  __tsi64 fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT424) C1{ FL Fs:0 FL}



static void Test_STT424()
{
  {
    init_simple_test("STT424");
    static STRUCT_IF_C STT424 lv;
    check2(sizeof(lv), 16, "sizeof(STT424)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT424)");
    check_field_offset(lv, fa, 0, "STT424.fa");
    check_field_offset(lv, fb, 8, "STT424.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT424, STT424)
//============================================================================


struct  STT434  {
  __tsi64 fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT434) C1{ FL Fi:0 FL}



static void Test_STT434()
{
  {
    init_simple_test("STT434");
    static STRUCT_IF_C STT434 lv;
    check2(sizeof(lv), 16, "sizeof(STT434)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT434)");
    check_field_offset(lv, fa, 0, "STT434.fa");
    check_field_offset(lv, fb, 8, "STT434.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT434, STT434)
//============================================================================


struct  STT444  {
  __tsi64 fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT444) C1{ FL FL:0 FL}



static void Test_STT444()
{
  {
    init_simple_test("STT444");
    static STRUCT_IF_C STT444 lv;
    check2(sizeof(lv), 16, "sizeof(STT444)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT444)");
    check_field_offset(lv, fa, 0, "STT444.fa");
    check_field_offset(lv, fb, 8, "STT444.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT444, STT444)
//============================================================================


struct  STT454  {
  __tsi64 fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT454) C1{ FL Fc:3 FL}



static void Test_STT454()
{
  {
    init_simple_test("STT454");
    static STRUCT_IF_C STT454 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT454)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT454)");
    check_field_offset(lv, fa, 0, "STT454.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT454.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT454, STT454)
//============================================================================


struct  STT464  {
  __tsi64 fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT464) C1{ FL Fs:3 FL}



static void Test_STT464()
{
  {
    init_simple_test("STT464");
    static STRUCT_IF_C STT464 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT464)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT464)");
    check_field_offset(lv, fa, 0, "STT464.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT464.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT464, STT464)
//============================================================================


struct  STT474  {
  __tsi64 fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT474) C1{ FL Fi:3 FL}



static void Test_STT474()
{
  {
    init_simple_test("STT474");
    static STRUCT_IF_C STT474 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT474)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT474)");
    check_field_offset(lv, fa, 0, "STT474.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT474.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT474, STT474)
//============================================================================


struct  STT484  {
  __tsi64 fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT484) C1{ FL FL:3 FL}



static void Test_STT484()
{
  {
    init_simple_test("STT484");
    static STRUCT_IF_C STT484 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT484)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT484)");
    check_field_offset(lv, fa, 0, "STT484.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT484.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT484, STT484)
//============================================================================


struct  STT494  {
  __tsi64 fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT494) C1{ FL Fs:8 FL}



static void Test_STT494()
{
  {
    init_simple_test("STT494");
    static STRUCT_IF_C STT494 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT494)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT494)");
    check_field_offset(lv, fa, 0, "STT494.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT494.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT494, STT494)
//============================================================================


struct  STT4104  {
  __tsi64 fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT4104) C1{ FL Fi:8 FL}



static void Test_STT4104()
{
  {
    init_simple_test("STT4104");
    static STRUCT_IF_C STT4104 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4104)");
    check_field_offset(lv, fa, 0, "STT4104.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4104, STT4104)
//============================================================================


struct  STT4114  {
  __tsi64 fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT4114) C1{ FL FL:8 FL}



static void Test_STT4114()
{
  {
    init_simple_test("STT4114");
    static STRUCT_IF_C STT4114 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4114)");
    check_field_offset(lv, fa, 0, "STT4114.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4114, STT4114)
//============================================================================


struct  STT4124  {
  __tsi64 fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT4124) C1{ FL Fi:18 FL}



static void Test_STT4124()
{
  {
    init_simple_test("STT4124");
    static STRUCT_IF_C STT4124 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4124)");
    check_field_offset(lv, fa, 0, "STT4124.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4124, STT4124)
//============================================================================


struct  STT4134  {
  __tsi64 fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT4134) C1{ FL FL:18 FL}



static void Test_STT4134()
{
  {
    init_simple_test("STT4134");
    static STRUCT_IF_C STT4134 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4134)");
    check_field_offset(lv, fa, 0, "STT4134.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4134, STT4134)
//============================================================================


struct  STT4144  {
  __tsi64 fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT4144) C1{ FL FL:48 FL}



static void Test_STT4144()
{
  {
    init_simple_test("STT4144");
    static STRUCT_IF_C STT4144 lv;
    check2(sizeof(lv), 24, "sizeof(STT4144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4144)");
    check_field_offset(lv, fa, 0, "STT4144.fa");
    check_field_offset(lv, fb, 16, "STT4144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4144, STT4144)
//============================================================================


struct  STT4154  {
  __tsi64 fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT4154) C1{ FL Fc:3 FL}



static void Test_STT4154()
{
  {
    init_simple_test("STT4154");
    static STRUCT_IF_C STT4154 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4154)");
    check_field_offset(lv, fa, 0, "STT4154.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4154");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4154");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4154, STT4154)
//============================================================================


struct  STT4164  {
  __tsi64 fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT4164) C1{ FL Fs:3 FL}



static void Test_STT4164()
{
  {
    init_simple_test("STT4164");
    static STRUCT_IF_C STT4164 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4164)");
    check_field_offset(lv, fa, 0, "STT4164.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4164");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4164");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4164, STT4164)
//============================================================================


struct  STT4174  {
  __tsi64 fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT4174) C1{ FL Fi:3 FL}



static void Test_STT4174()
{
  {
    init_simple_test("STT4174");
    static STRUCT_IF_C STT4174 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4174)");
    check_field_offset(lv, fa, 0, "STT4174.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4174");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4174");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4174, STT4174)
//============================================================================


struct  STT4184  {
  __tsi64 fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT4184) C1{ FL FL:3 FL}



static void Test_STT4184()
{
  {
    init_simple_test("STT4184");
    static STRUCT_IF_C STT4184 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4184)");
    check_field_offset(lv, fa, 0, "STT4184.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4184");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4184");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4184, STT4184)
//============================================================================


struct  STT4194  {
  __tsi64 fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT4194) C1{ FL Fs:8 FL}



static void Test_STT4194()
{
  {
    init_simple_test("STT4194");
    static STRUCT_IF_C STT4194 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4194)");
    check_field_offset(lv, fa, 0, "STT4194.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4194");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4194");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4194, STT4194)
//============================================================================


struct  STT4204  {
  __tsi64 fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT4204) C1{ FL Fi:8 FL}



static void Test_STT4204()
{
  {
    init_simple_test("STT4204");
    static STRUCT_IF_C STT4204 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4204)");
    check_field_offset(lv, fa, 0, "STT4204.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4204");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4204");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4204, STT4204)
//============================================================================


struct  STT4214  {
  __tsi64 fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT4214) C1{ FL FL:8 FL}



static void Test_STT4214()
{
  {
    init_simple_test("STT4214");
    static STRUCT_IF_C STT4214 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4214)");
    check_field_offset(lv, fa, 0, "STT4214.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4214");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4214");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4214, STT4214)
//============================================================================


struct  STT4224  {
  __tsi64 fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT4224) C1{ FL Fi:18 FL}



static void Test_STT4224()
{
  {
    init_simple_test("STT4224");
    static STRUCT_IF_C STT4224 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4224)");
    check_field_offset(lv, fa, 0, "STT4224.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4224");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4224");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4224, STT4224)
//============================================================================


struct  STT4234  {
  __tsi64 fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT4234) C1{ FL FL:18 FL}



static void Test_STT4234()
{
  {
    init_simple_test("STT4234");
    static STRUCT_IF_C STT4234 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4234)");
    check_field_offset(lv, fa, 0, "STT4234.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4234");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4234");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4234, STT4234)
//============================================================================


struct  STT4244  {
  __tsi64 fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT4244) C1{ FL FL:48 FL}



static void Test_STT4244()
{
  {
    init_simple_test("STT4244");
    static STRUCT_IF_C STT4244 lv;
    check2(sizeof(lv), 24, "sizeof(STT4244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4244)");
    check_field_offset(lv, fa, 0, "STT4244.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4244");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4244");
    check_field_offset(lv, fb, 16, "STT4244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4244, STT4244)
//============================================================================


struct  STT415  {
  __tsi64 fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT415) C1{ FL Fc:0 Fp}



static void Test_STT415()
{
  {
    init_simple_test("STT415");
    static STRUCT_IF_C STT415 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT415)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT415)");
    check_field_offset(lv, fa, 0, "STT415.fa");
    check_field_offset(lv, fb, 8, "STT415.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT415, STT415)
//============================================================================


struct  STT425  {
  __tsi64 fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT425) C1{ FL Fs:0 Fp}



static void Test_STT425()
{
  {
    init_simple_test("STT425");
    static STRUCT_IF_C STT425 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT425)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT425)");
    check_field_offset(lv, fa, 0, "STT425.fa");
    check_field_offset(lv, fb, 8, "STT425.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT425, STT425)
//============================================================================


struct  STT435  {
  __tsi64 fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT435) C1{ FL Fi:0 Fp}



static void Test_STT435()
{
  {
    init_simple_test("STT435");
    static STRUCT_IF_C STT435 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT435)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT435)");
    check_field_offset(lv, fa, 0, "STT435.fa");
    check_field_offset(lv, fb, 8, "STT435.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT435, STT435)
//============================================================================


struct  STT445  {
  __tsi64 fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT445) C1{ FL FL:0 Fp}



static void Test_STT445()
{
  {
    init_simple_test("STT445");
    static STRUCT_IF_C STT445 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT445)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT445)");
    check_field_offset(lv, fa, 0, "STT445.fa");
    check_field_offset(lv, fb, 8, "STT445.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT445, STT445)
//============================================================================


struct  STT455  {
  __tsi64 fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT455) C1{ FL Fc:3 Fp}



static void Test_STT455()
{
  {
    init_simple_test("STT455");
    static STRUCT_IF_C STT455 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT455)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT455)");
    check_field_offset(lv, fa, 0, "STT455.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT455.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT455, STT455)
//============================================================================


struct  STT465  {
  __tsi64 fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT465) C1{ FL Fs:3 Fp}



static void Test_STT465()
{
  {
    init_simple_test("STT465");
    static STRUCT_IF_C STT465 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT465)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT465)");
    check_field_offset(lv, fa, 0, "STT465.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT465.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT465, STT465)
//============================================================================


struct  STT475  {
  __tsi64 fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT475) C1{ FL Fi:3 Fp}



static void Test_STT475()
{
  {
    init_simple_test("STT475");
    static STRUCT_IF_C STT475 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT475)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT475)");
    check_field_offset(lv, fa, 0, "STT475.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT475.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT475, STT475)
//============================================================================


struct  STT485  {
  __tsi64 fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT485) C1{ FL FL:3 Fp}



static void Test_STT485()
{
  {
    init_simple_test("STT485");
    static STRUCT_IF_C STT485 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT485)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT485)");
    check_field_offset(lv, fa, 0, "STT485.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT485.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT485, STT485)
//============================================================================


struct  STT495  {
  __tsi64 fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT495) C1{ FL Fs:8 Fp}



static void Test_STT495()
{
  {
    init_simple_test("STT495");
    static STRUCT_IF_C STT495 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT495)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT495)");
    check_field_offset(lv, fa, 0, "STT495.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT495.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT495, STT495)
//============================================================================


struct  STT4105  {
  __tsi64 fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT4105) C1{ FL Fi:8 Fp}



static void Test_STT4105()
{
  {
    init_simple_test("STT4105");
    static STRUCT_IF_C STT4105 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4105)");
    check_field_offset(lv, fa, 0, "STT4105.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4105, STT4105)
//============================================================================


struct  STT4115  {
  __tsi64 fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT4115) C1{ FL FL:8 Fp}



static void Test_STT4115()
{
  {
    init_simple_test("STT4115");
    static STRUCT_IF_C STT4115 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4115)");
    check_field_offset(lv, fa, 0, "STT4115.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4115, STT4115)
//============================================================================


struct  STT4125  {
  __tsi64 fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT4125) C1{ FL Fi:18 Fp}



static void Test_STT4125()
{
  {
    init_simple_test("STT4125");
    static STRUCT_IF_C STT4125 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4125)");
    check_field_offset(lv, fa, 0, "STT4125.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4125, STT4125)
//============================================================================


struct  STT4135  {
  __tsi64 fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT4135) C1{ FL FL:18 Fp}



static void Test_STT4135()
{
  {
    init_simple_test("STT4135");
    static STRUCT_IF_C STT4135 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4135)");
    check_field_offset(lv, fa, 0, "STT4135.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4135, STT4135)
//============================================================================


struct  STT4145  {
  __tsi64 fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT4145) C1{ FL FL:48 Fp}



static void Test_STT4145()
{
  {
    init_simple_test("STT4145");
    static STRUCT_IF_C STT4145 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4145)");
    check_field_offset(lv, fa, 0, "STT4145.fa");
    check_field_offset(lv, fb, 16, "STT4145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4145, STT4145)
//============================================================================


struct  STT4155  {
  __tsi64 fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT4155) C1{ FL Fc:3 Fp}



static void Test_STT4155()
{
  {
    init_simple_test("STT4155");
    static STRUCT_IF_C STT4155 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4155)");
    check_field_offset(lv, fa, 0, "STT4155.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4155");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4155");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4155, STT4155)
//============================================================================


struct  STT4165  {
  __tsi64 fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT4165) C1{ FL Fs:3 Fp}



static void Test_STT4165()
{
  {
    init_simple_test("STT4165");
    static STRUCT_IF_C STT4165 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4165)");
    check_field_offset(lv, fa, 0, "STT4165.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4165");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4165");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4165, STT4165)
//============================================================================


struct  STT4175  {
  __tsi64 fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT4175) C1{ FL Fi:3 Fp}



static void Test_STT4175()
{
  {
    init_simple_test("STT4175");
    static STRUCT_IF_C STT4175 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4175)");
    check_field_offset(lv, fa, 0, "STT4175.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4175");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4175");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4175, STT4175)
//============================================================================


struct  STT4185  {
  __tsi64 fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT4185) C1{ FL FL:3 Fp}



static void Test_STT4185()
{
  {
    init_simple_test("STT4185");
    static STRUCT_IF_C STT4185 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4185)");
    check_field_offset(lv, fa, 0, "STT4185.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4185");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4185");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4185, STT4185)
//============================================================================


struct  STT4195  {
  __tsi64 fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT4195) C1{ FL Fs:8 Fp}



static void Test_STT4195()
{
  {
    init_simple_test("STT4195");
    static STRUCT_IF_C STT4195 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4195)");
    check_field_offset(lv, fa, 0, "STT4195.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4195");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4195");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4195, STT4195)
//============================================================================


struct  STT4205  {
  __tsi64 fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT4205) C1{ FL Fi:8 Fp}



static void Test_STT4205()
{
  {
    init_simple_test("STT4205");
    static STRUCT_IF_C STT4205 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4205)");
    check_field_offset(lv, fa, 0, "STT4205.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4205");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4205");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4205, STT4205)
//============================================================================


struct  STT4215  {
  __tsi64 fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT4215) C1{ FL FL:8 Fp}



static void Test_STT4215()
{
  {
    init_simple_test("STT4215");
    static STRUCT_IF_C STT4215 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4215)");
    check_field_offset(lv, fa, 0, "STT4215.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4215");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4215");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4215, STT4215)
//============================================================================


struct  STT4225  {
  __tsi64 fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT4225) C1{ FL Fi:18 Fp}



static void Test_STT4225()
{
  {
    init_simple_test("STT4225");
    static STRUCT_IF_C STT4225 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4225)");
    check_field_offset(lv, fa, 0, "STT4225.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4225");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4225");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4225, STT4225)
//============================================================================


struct  STT4235  {
  __tsi64 fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT4235) C1{ FL FL:18 Fp}



static void Test_STT4235()
{
  {
    init_simple_test("STT4235");
    static STRUCT_IF_C STT4235 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4235)");
    check_field_offset(lv, fa, 0, "STT4235.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4235");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4235");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4235, STT4235)
//============================================================================


struct  STT4245  {
  __tsi64 fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT4245) C1{ FL FL:48 Fp}



static void Test_STT4245()
{
  {
    init_simple_test("STT4245");
    static STRUCT_IF_C STT4245 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4245)");
    check_field_offset(lv, fa, 0, "STT4245.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4245");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4245");
    check_field_offset(lv, fb, 16, "STT4245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4245, STT4245)
//============================================================================


struct  STT416  {
  __tsi64 fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT416) C1{ FL Fc:0 Fi}



static void Test_STT416()
{
  {
    init_simple_test("STT416");
    static STRUCT_IF_C STT416 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT416)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT416)");
    check_field_offset(lv, fa, 0, "STT416.fa");
    check_field_offset(lv, fb, 8, "STT416.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT416, STT416)
//============================================================================


struct  STT426  {
  __tsi64 fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT426) C1{ FL Fs:0 Fi}



static void Test_STT426()
{
  {
    init_simple_test("STT426");
    static STRUCT_IF_C STT426 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT426)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT426)");
    check_field_offset(lv, fa, 0, "STT426.fa");
    check_field_offset(lv, fb, 8, "STT426.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT426, STT426)
//============================================================================


struct  STT436  {
  __tsi64 fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT436) C1{ FL Fi:0 Fi}



static void Test_STT436()
{
  {
    init_simple_test("STT436");
    static STRUCT_IF_C STT436 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT436)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT436)");
    check_field_offset(lv, fa, 0, "STT436.fa");
    check_field_offset(lv, fb, 8, "STT436.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT436, STT436)
//============================================================================


struct  STT446  {
  __tsi64 fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT446) C1{ FL FL:0 Fi}



static void Test_STT446()
{
  {
    init_simple_test("STT446");
    static STRUCT_IF_C STT446 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT446)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT446)");
    check_field_offset(lv, fa, 0, "STT446.fa");
    check_field_offset(lv, fb, 8, "STT446.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT446, STT446)
//============================================================================


struct  STT456  {
  __tsi64 fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT456) C1{ FL Fc:3 Fi}



static void Test_STT456()
{
  {
    init_simple_test("STT456");
    static STRUCT_IF_C STT456 lv;
    check2(sizeof(lv), 16, "sizeof(STT456)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT456)");
    check_field_offset(lv, fa, 0, "STT456.fa");
    check_field_offset(lv, fb, 12, "STT456.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT456, STT456)
//============================================================================


struct  STT466  {
  __tsi64 fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT466) C1{ FL Fs:3 Fi}



static void Test_STT466()
{
  {
    init_simple_test("STT466");
    static STRUCT_IF_C STT466 lv;
    check2(sizeof(lv), 16, "sizeof(STT466)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT466)");
    check_field_offset(lv, fa, 0, "STT466.fa");
    check_field_offset(lv, fb, 12, "STT466.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT466, STT466)
//============================================================================


struct  STT476  {
  __tsi64 fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT476) C1{ FL Fi:3 Fi}



static void Test_STT476()
{
  {
    init_simple_test("STT476");
    static STRUCT_IF_C STT476 lv;
    check2(sizeof(lv), 16, "sizeof(STT476)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT476)");
    check_field_offset(lv, fa, 0, "STT476.fa");
    check_field_offset(lv, fb, 12, "STT476.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT476, STT476)
//============================================================================


struct  STT486  {
  __tsi64 fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT486) C1{ FL FL:3 Fi}



static void Test_STT486()
{
  {
    init_simple_test("STT486");
    static STRUCT_IF_C STT486 lv;
    check2(sizeof(lv), 16, "sizeof(STT486)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT486)");
    check_field_offset(lv, fa, 0, "STT486.fa");
    check_field_offset(lv, fb, 12, "STT486.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT486, STT486)
//============================================================================


struct  STT496  {
  __tsi64 fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT496) C1{ FL Fs:8 Fi}



static void Test_STT496()
{
  {
    init_simple_test("STT496");
    static STRUCT_IF_C STT496 lv;
    check2(sizeof(lv), 16, "sizeof(STT496)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT496)");
    check_field_offset(lv, fa, 0, "STT496.fa");
    check_field_offset(lv, fb, 12, "STT496.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT496, STT496)
//============================================================================


struct  STT4106  {
  __tsi64 fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT4106) C1{ FL Fi:8 Fi}



static void Test_STT4106()
{
  {
    init_simple_test("STT4106");
    static STRUCT_IF_C STT4106 lv;
    check2(sizeof(lv), 16, "sizeof(STT4106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4106)");
    check_field_offset(lv, fa, 0, "STT4106.fa");
    check_field_offset(lv, fb, 12, "STT4106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4106, STT4106)
//============================================================================


struct  STT4116  {
  __tsi64 fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT4116) C1{ FL FL:8 Fi}



static void Test_STT4116()
{
  {
    init_simple_test("STT4116");
    static STRUCT_IF_C STT4116 lv;
    check2(sizeof(lv), 16, "sizeof(STT4116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4116)");
    check_field_offset(lv, fa, 0, "STT4116.fa");
    check_field_offset(lv, fb, 12, "STT4116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4116, STT4116)
//============================================================================


struct  STT4126  {
  __tsi64 fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT4126) C1{ FL Fi:18 Fi}



static void Test_STT4126()
{
  {
    init_simple_test("STT4126");
    static STRUCT_IF_C STT4126 lv;
    check2(sizeof(lv), 16, "sizeof(STT4126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4126)");
    check_field_offset(lv, fa, 0, "STT4126.fa");
    check_field_offset(lv, fb, 12, "STT4126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4126, STT4126)
//============================================================================


struct  STT4136  {
  __tsi64 fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT4136) C1{ FL FL:18 Fi}



static void Test_STT4136()
{
  {
    init_simple_test("STT4136");
    static STRUCT_IF_C STT4136 lv;
    check2(sizeof(lv), 16, "sizeof(STT4136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4136)");
    check_field_offset(lv, fa, 0, "STT4136.fa");
    check_field_offset(lv, fb, 12, "STT4136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4136, STT4136)
//============================================================================


struct  STT4146  {
  __tsi64 fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT4146) C1{ FL FL:48 Fi}



static void Test_STT4146()
{
  {
    init_simple_test("STT4146");
    static STRUCT_IF_C STT4146 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4146)");
    check_field_offset(lv, fa, 0, "STT4146.fa");
    check_field_offset(lv, fb, 16, "STT4146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4146, STT4146)
//============================================================================


struct  STT4156  {
  __tsi64 fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT4156) C1{ FL Fc:3 Fi}



static void Test_STT4156()
{
  {
    init_simple_test("STT4156");
    static STRUCT_IF_C STT4156 lv;
    check2(sizeof(lv), 16, "sizeof(STT4156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4156)");
    check_field_offset(lv, fa, 0, "STT4156.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4156");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4156");
    check_field_offset(lv, fb, 12, "STT4156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4156, STT4156)
//============================================================================


struct  STT4166  {
  __tsi64 fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT4166) C1{ FL Fs:3 Fi}



static void Test_STT4166()
{
  {
    init_simple_test("STT4166");
    static STRUCT_IF_C STT4166 lv;
    check2(sizeof(lv), 16, "sizeof(STT4166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4166)");
    check_field_offset(lv, fa, 0, "STT4166.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4166");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4166");
    check_field_offset(lv, fb, 12, "STT4166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4166, STT4166)
//============================================================================


struct  STT4176  {
  __tsi64 fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT4176) C1{ FL Fi:3 Fi}



static void Test_STT4176()
{
  {
    init_simple_test("STT4176");
    static STRUCT_IF_C STT4176 lv;
    check2(sizeof(lv), 16, "sizeof(STT4176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4176)");
    check_field_offset(lv, fa, 0, "STT4176.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4176");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4176");
    check_field_offset(lv, fb, 12, "STT4176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4176, STT4176)
//============================================================================


struct  STT4186  {
  __tsi64 fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT4186) C1{ FL FL:3 Fi}



static void Test_STT4186()
{
  {
    init_simple_test("STT4186");
    static STRUCT_IF_C STT4186 lv;
    check2(sizeof(lv), 16, "sizeof(STT4186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4186)");
    check_field_offset(lv, fa, 0, "STT4186.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4186");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4186");
    check_field_offset(lv, fb, 12, "STT4186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4186, STT4186)
//============================================================================


struct  STT4196  {
  __tsi64 fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT4196) C1{ FL Fs:8 Fi}



static void Test_STT4196()
{
  {
    init_simple_test("STT4196");
    static STRUCT_IF_C STT4196 lv;
    check2(sizeof(lv), 16, "sizeof(STT4196)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4196)");
    check_field_offset(lv, fa, 0, "STT4196.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4196");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4196");
    check_field_offset(lv, fb, 12, "STT4196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4196, STT4196)
//============================================================================


struct  STT4206  {
  __tsi64 fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT4206) C1{ FL Fi:8 Fi}



static void Test_STT4206()
{
  {
    init_simple_test("STT4206");
    static STRUCT_IF_C STT4206 lv;
    check2(sizeof(lv), 16, "sizeof(STT4206)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4206)");
    check_field_offset(lv, fa, 0, "STT4206.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4206");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4206");
    check_field_offset(lv, fb, 12, "STT4206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4206, STT4206)
//============================================================================


struct  STT4216  {
  __tsi64 fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT4216) C1{ FL FL:8 Fi}



static void Test_STT4216()
{
  {
    init_simple_test("STT4216");
    static STRUCT_IF_C STT4216 lv;
    check2(sizeof(lv), 16, "sizeof(STT4216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4216)");
    check_field_offset(lv, fa, 0, "STT4216.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4216");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4216");
    check_field_offset(lv, fb, 12, "STT4216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4216, STT4216)
//============================================================================


struct  STT4226  {
  __tsi64 fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT4226) C1{ FL Fi:18 Fi}



static void Test_STT4226()
{
  {
    init_simple_test("STT4226");
    static STRUCT_IF_C STT4226 lv;
    check2(sizeof(lv), 16, "sizeof(STT4226)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4226)");
    check_field_offset(lv, fa, 0, "STT4226.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4226");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4226");
    check_field_offset(lv, fb, 12, "STT4226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4226, STT4226)
//============================================================================


struct  STT4236  {
  __tsi64 fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT4236) C1{ FL FL:18 Fi}



static void Test_STT4236()
{
  {
    init_simple_test("STT4236");
    static STRUCT_IF_C STT4236 lv;
    check2(sizeof(lv), 16, "sizeof(STT4236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4236)");
    check_field_offset(lv, fa, 0, "STT4236.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4236");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4236");
    check_field_offset(lv, fb, 12, "STT4236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4236, STT4236)
//============================================================================


struct  STT4246  {
  __tsi64 fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT4246) C1{ FL FL:48 Fi}



static void Test_STT4246()
{
  {
    init_simple_test("STT4246");
    static STRUCT_IF_C STT4246 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4246)");
    check_field_offset(lv, fa, 0, "STT4246.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4246");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4246");
    check_field_offset(lv, fb, 16, "STT4246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4246, STT4246)
//============================================================================


struct  STT417  {
  __tsi64 fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT417) C1{ FL Fc:0 FL}



static void Test_STT417()
{
  {
    init_simple_test("STT417");
    static STRUCT_IF_C STT417 lv;
    check2(sizeof(lv), 16, "sizeof(STT417)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT417)");
    check_field_offset(lv, fa, 0, "STT417.fa");
    check_field_offset(lv, fb, 8, "STT417.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT417, STT417)
//============================================================================


struct  STT427  {
  __tsi64 fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT427) C1{ FL Fs:0 FL}



static void Test_STT427()
{
  {
    init_simple_test("STT427");
    static STRUCT_IF_C STT427 lv;
    check2(sizeof(lv), 16, "sizeof(STT427)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT427)");
    check_field_offset(lv, fa, 0, "STT427.fa");
    check_field_offset(lv, fb, 8, "STT427.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT427, STT427)
//============================================================================


struct  STT437  {
  __tsi64 fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT437) C1{ FL Fi:0 FL}



static void Test_STT437()
{
  {
    init_simple_test("STT437");
    static STRUCT_IF_C STT437 lv;
    check2(sizeof(lv), 16, "sizeof(STT437)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT437)");
    check_field_offset(lv, fa, 0, "STT437.fa");
    check_field_offset(lv, fb, 8, "STT437.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT437, STT437)
//============================================================================


struct  STT447  {
  __tsi64 fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT447) C1{ FL FL:0 FL}



static void Test_STT447()
{
  {
    init_simple_test("STT447");
    static STRUCT_IF_C STT447 lv;
    check2(sizeof(lv), 16, "sizeof(STT447)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT447)");
    check_field_offset(lv, fa, 0, "STT447.fa");
    check_field_offset(lv, fb, 8, "STT447.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT447, STT447)
//============================================================================


struct  STT457  {
  __tsi64 fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT457) C1{ FL Fc:3 FL}



static void Test_STT457()
{
  {
    init_simple_test("STT457");
    static STRUCT_IF_C STT457 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT457)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT457)");
    check_field_offset(lv, fa, 0, "STT457.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT457.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT457, STT457)
//============================================================================


struct  STT467  {
  __tsi64 fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT467) C1{ FL Fs:3 FL}



static void Test_STT467()
{
  {
    init_simple_test("STT467");
    static STRUCT_IF_C STT467 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT467)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT467)");
    check_field_offset(lv, fa, 0, "STT467.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT467.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT467, STT467)
//============================================================================


struct  STT477  {
  __tsi64 fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT477) C1{ FL Fi:3 FL}



static void Test_STT477()
{
  {
    init_simple_test("STT477");
    static STRUCT_IF_C STT477 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT477)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT477)");
    check_field_offset(lv, fa, 0, "STT477.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT477.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT477, STT477)
//============================================================================


struct  STT487  {
  __tsi64 fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT487) C1{ FL FL:3 FL}



static void Test_STT487()
{
  {
    init_simple_test("STT487");
    static STRUCT_IF_C STT487 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT487)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT487)");
    check_field_offset(lv, fa, 0, "STT487.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT487.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT487, STT487)
//============================================================================


struct  STT497  {
  __tsi64 fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT497) C1{ FL Fs:8 FL}



static void Test_STT497()
{
  {
    init_simple_test("STT497");
    static STRUCT_IF_C STT497 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT497)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT497)");
    check_field_offset(lv, fa, 0, "STT497.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT497.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT497, STT497)
//============================================================================


struct  STT4107  {
  __tsi64 fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT4107) C1{ FL Fi:8 FL}



static void Test_STT4107()
{
  {
    init_simple_test("STT4107");
    static STRUCT_IF_C STT4107 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4107)");
    check_field_offset(lv, fa, 0, "STT4107.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4107, STT4107)
//============================================================================


struct  STT4117  {
  __tsi64 fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT4117) C1{ FL FL:8 FL}



static void Test_STT4117()
{
  {
    init_simple_test("STT4117");
    static STRUCT_IF_C STT4117 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4117)");
    check_field_offset(lv, fa, 0, "STT4117.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4117, STT4117)
//============================================================================


struct  STT4127  {
  __tsi64 fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT4127) C1{ FL Fi:18 FL}



static void Test_STT4127()
{
  {
    init_simple_test("STT4127");
    static STRUCT_IF_C STT4127 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4127)");
    check_field_offset(lv, fa, 0, "STT4127.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4127, STT4127)
//============================================================================


struct  STT4137  {
  __tsi64 fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT4137) C1{ FL FL:18 FL}



static void Test_STT4137()
{
  {
    init_simple_test("STT4137");
    static STRUCT_IF_C STT4137 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4137)");
    check_field_offset(lv, fa, 0, "STT4137.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4137, STT4137)
//============================================================================


struct  STT4147  {
  __tsi64 fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT4147) C1{ FL FL:48 FL}



static void Test_STT4147()
{
  {
    init_simple_test("STT4147");
    static STRUCT_IF_C STT4147 lv;
    check2(sizeof(lv), 24, "sizeof(STT4147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4147)");
    check_field_offset(lv, fa, 0, "STT4147.fa");
    check_field_offset(lv, fb, 16, "STT4147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4147, STT4147)
//============================================================================


struct  STT4157  {
  __tsi64 fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT4157) C1{ FL Fc:3 FL}



static void Test_STT4157()
{
  {
    init_simple_test("STT4157");
    static STRUCT_IF_C STT4157 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4157)");
    check_field_offset(lv, fa, 0, "STT4157.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4157");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4157");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4157, STT4157)
//============================================================================


struct  STT4167  {
  __tsi64 fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT4167) C1{ FL Fs:3 FL}



static void Test_STT4167()
{
  {
    init_simple_test("STT4167");
    static STRUCT_IF_C STT4167 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4167)");
    check_field_offset(lv, fa, 0, "STT4167.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4167");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4167");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4167, STT4167)
//============================================================================


struct  STT4177  {
  __tsi64 fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT4177) C1{ FL Fi:3 FL}



static void Test_STT4177()
{
  {
    init_simple_test("STT4177");
    static STRUCT_IF_C STT4177 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4177)");
    check_field_offset(lv, fa, 0, "STT4177.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4177");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4177");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4177, STT4177)
//============================================================================


struct  STT4187  {
  __tsi64 fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT4187) C1{ FL FL:3 FL}



static void Test_STT4187()
{
  {
    init_simple_test("STT4187");
    static STRUCT_IF_C STT4187 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4187)");
    check_field_offset(lv, fa, 0, "STT4187.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4187");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4187");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4187, STT4187)
//============================================================================


struct  STT4197  {
  __tsi64 fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT4197) C1{ FL Fs:8 FL}



static void Test_STT4197()
{
  {
    init_simple_test("STT4197");
    static STRUCT_IF_C STT4197 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4197)");
    check_field_offset(lv, fa, 0, "STT4197.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4197");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4197");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4197, STT4197)
//============================================================================


struct  STT4207  {
  __tsi64 fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT4207) C1{ FL Fi:8 FL}



static void Test_STT4207()
{
  {
    init_simple_test("STT4207");
    static STRUCT_IF_C STT4207 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4207)");
    check_field_offset(lv, fa, 0, "STT4207.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4207");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4207");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4207, STT4207)
//============================================================================


struct  STT4217  {
  __tsi64 fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT4217) C1{ FL FL:8 FL}



static void Test_STT4217()
{
  {
    init_simple_test("STT4217");
    static STRUCT_IF_C STT4217 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4217)");
    check_field_offset(lv, fa, 0, "STT4217.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4217");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4217");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4217, STT4217)
//============================================================================


struct  STT4227  {
  __tsi64 fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT4227) C1{ FL Fi:18 FL}



static void Test_STT4227()
{
  {
    init_simple_test("STT4227");
    static STRUCT_IF_C STT4227 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4227)");
    check_field_offset(lv, fa, 0, "STT4227.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4227");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4227");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4227, STT4227)
//============================================================================


struct  STT4237  {
  __tsi64 fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT4237) C1{ FL FL:18 FL}



static void Test_STT4237()
{
  {
    init_simple_test("STT4237");
    static STRUCT_IF_C STT4237 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4237)");
    check_field_offset(lv, fa, 0, "STT4237.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4237");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4237");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4237, STT4237)
//============================================================================


struct  STT4247  {
  __tsi64 fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT4247) C1{ FL FL:48 FL}



static void Test_STT4247()
{
  {
    init_simple_test("STT4247");
    static STRUCT_IF_C STT4247 lv;
    check2(sizeof(lv), 24, "sizeof(STT4247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4247)");
    check_field_offset(lv, fa, 0, "STT4247.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4247");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4247");
    check_field_offset(lv, fb, 16, "STT4247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4247, STT4247)
//============================================================================


struct  STT418  {
  __tsi64 fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT418) C1{ FL Fc:0 FD}



static void Test_STT418()
{
  {
    init_simple_test("STT418");
    static STRUCT_IF_C STT418 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT418)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT418)");
    check_field_offset(lv, fa, 0, "STT418.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT418.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT418, STT418)
//============================================================================


struct  STT428  {
  __tsi64 fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT428) C1{ FL Fs:0 FD}



static void Test_STT428()
{
  {
    init_simple_test("STT428");
    static STRUCT_IF_C STT428 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT428)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT428)");
    check_field_offset(lv, fa, 0, "STT428.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT428.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT428, STT428)
//============================================================================


struct  STT438  {
  __tsi64 fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT438) C1{ FL Fi:0 FD}



static void Test_STT438()
{
  {
    init_simple_test("STT438");
    static STRUCT_IF_C STT438 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT438)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT438)");
    check_field_offset(lv, fa, 0, "STT438.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT438.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT438, STT438)
//============================================================================


struct  STT448  {
  __tsi64 fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT448) C1{ FL FL:0 FD}



static void Test_STT448()
{
  {
    init_simple_test("STT448");
    static STRUCT_IF_C STT448 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT448)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT448)");
    check_field_offset(lv, fa, 0, "STT448.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT448.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT448, STT448)
//============================================================================


struct  STT458  {
  __tsi64 fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT458) C1{ FL Fc:3 FD}



static void Test_STT458()
{
  {
    init_simple_test("STT458");
    static STRUCT_IF_C STT458 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT458)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT458)");
    check_field_offset(lv, fa, 0, "STT458.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT458.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT458, STT458)
//============================================================================


struct  STT468  {
  __tsi64 fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT468) C1{ FL Fs:3 FD}



static void Test_STT468()
{
  {
    init_simple_test("STT468");
    static STRUCT_IF_C STT468 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT468)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT468)");
    check_field_offset(lv, fa, 0, "STT468.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT468.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT468, STT468)
//============================================================================


struct  STT478  {
  __tsi64 fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT478) C1{ FL Fi:3 FD}



static void Test_STT478()
{
  {
    init_simple_test("STT478");
    static STRUCT_IF_C STT478 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT478)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT478)");
    check_field_offset(lv, fa, 0, "STT478.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT478.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT478, STT478)
//============================================================================


struct  STT488  {
  __tsi64 fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT488) C1{ FL FL:3 FD}



static void Test_STT488()
{
  {
    init_simple_test("STT488");
    static STRUCT_IF_C STT488 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT488)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT488)");
    check_field_offset(lv, fa, 0, "STT488.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT488.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT488, STT488)
//============================================================================


struct  STT498  {
  __tsi64 fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT498) C1{ FL Fs:8 FD}



static void Test_STT498()
{
  {
    init_simple_test("STT498");
    static STRUCT_IF_C STT498 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT498)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT498)");
    check_field_offset(lv, fa, 0, "STT498.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT498.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT498, STT498)
//============================================================================


struct  STT4108  {
  __tsi64 fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT4108) C1{ FL Fi:8 FD}



static void Test_STT4108()
{
  {
    init_simple_test("STT4108");
    static STRUCT_IF_C STT4108 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4108)");
    check_field_offset(lv, fa, 0, "STT4108.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4108, STT4108)
//============================================================================


struct  STT4118  {
  __tsi64 fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT4118) C1{ FL FL:8 FD}



static void Test_STT4118()
{
  {
    init_simple_test("STT4118");
    static STRUCT_IF_C STT4118 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4118)");
    check_field_offset(lv, fa, 0, "STT4118.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4118, STT4118)
//============================================================================


struct  STT4128  {
  __tsi64 fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT4128) C1{ FL Fi:18 FD}



static void Test_STT4128()
{
  {
    init_simple_test("STT4128");
    static STRUCT_IF_C STT4128 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4128)");
    check_field_offset(lv, fa, 0, "STT4128.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4128, STT4128)
//============================================================================


struct  STT4138  {
  __tsi64 fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT4138) C1{ FL FL:18 FD}



static void Test_STT4138()
{
  {
    init_simple_test("STT4138");
    static STRUCT_IF_C STT4138 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4138)");
    check_field_offset(lv, fa, 0, "STT4138.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4138, STT4138)
//============================================================================


struct  STT4148  {
  __tsi64 fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT4148) C1{ FL FL:48 FD}



static void Test_STT4148()
{
  {
    init_simple_test("STT4148");
    static STRUCT_IF_C STT4148 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(STT4148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4148)");
    check_field_offset(lv, fa, 0, "STT4148.fa");
    check_field_offset(lv, fb, 16, "STT4148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4148, STT4148)
//============================================================================


struct  STT4158  {
  __tsi64 fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT4158) C1{ FL Fc:3 FD}



static void Test_STT4158()
{
  {
    init_simple_test("STT4158");
    static STRUCT_IF_C STT4158 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4158)");
    check_field_offset(lv, fa, 0, "STT4158.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4158");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4158");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4158, STT4158)
//============================================================================


struct  STT4168  {
  __tsi64 fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT4168) C1{ FL Fs:3 FD}



static void Test_STT4168()
{
  {
    init_simple_test("STT4168");
    static STRUCT_IF_C STT4168 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4168)");
    check_field_offset(lv, fa, 0, "STT4168.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4168");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4168");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4168, STT4168)
//============================================================================


struct  STT4178  {
  __tsi64 fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT4178) C1{ FL Fi:3 FD}



static void Test_STT4178()
{
  {
    init_simple_test("STT4178");
    static STRUCT_IF_C STT4178 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4178)");
    check_field_offset(lv, fa, 0, "STT4178.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4178");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4178");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4178, STT4178)
//============================================================================


struct  STT4188  {
  __tsi64 fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT4188) C1{ FL FL:3 FD}



static void Test_STT4188()
{
  {
    init_simple_test("STT4188");
    static STRUCT_IF_C STT4188 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4188)");
    check_field_offset(lv, fa, 0, "STT4188.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4188");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4188");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4188, STT4188)
//============================================================================


struct  STT4198  {
  __tsi64 fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT4198) C1{ FL Fs:8 FD}



static void Test_STT4198()
{
  {
    init_simple_test("STT4198");
    static STRUCT_IF_C STT4198 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4198)");
    check_field_offset(lv, fa, 0, "STT4198.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4198");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4198");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4198, STT4198)
//============================================================================


struct  STT4208  {
  __tsi64 fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT4208) C1{ FL Fi:8 FD}



static void Test_STT4208()
{
  {
    init_simple_test("STT4208");
    static STRUCT_IF_C STT4208 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4208)");
    check_field_offset(lv, fa, 0, "STT4208.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4208");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4208");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4208, STT4208)
//============================================================================


struct  STT4218  {
  __tsi64 fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT4218) C1{ FL FL:8 FD}



static void Test_STT4218()
{
  {
    init_simple_test("STT4218");
    static STRUCT_IF_C STT4218 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4218)");
    check_field_offset(lv, fa, 0, "STT4218.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4218");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4218");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4218, STT4218)
//============================================================================


struct  STT4228  {
  __tsi64 fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT4228) C1{ FL Fi:18 FD}



static void Test_STT4228()
{
  {
    init_simple_test("STT4228");
    static STRUCT_IF_C STT4228 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4228)");
    check_field_offset(lv, fa, 0, "STT4228.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4228");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4228");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4228, STT4228)
//============================================================================


struct  STT4238  {
  __tsi64 fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT4238) C1{ FL FL:18 FD}



static void Test_STT4238()
{
  {
    init_simple_test("STT4238");
    static STRUCT_IF_C STT4238 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4238)");
    check_field_offset(lv, fa, 0, "STT4238.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4238");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4238");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4238, STT4238)
//============================================================================


struct  STT4248  {
  __tsi64 fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT4248) C1{ FL FL:48 FD}



static void Test_STT4248()
{
  {
    init_simple_test("STT4248");
    static STRUCT_IF_C STT4248 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(STT4248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4248)");
    check_field_offset(lv, fa, 0, "STT4248.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4248");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4248");
    check_field_offset(lv, fb, 16, "STT4248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4248, STT4248)
//============================================================================


struct  STT419  {
  __tsi64 fa;
  unsigned char  :0;
};
//SIG(1 STT419) C1{ FL Fc:0}



static void Test_STT419()
{
  {
    init_simple_test("STT419");
    static STRUCT_IF_C STT419 lv;
    check2(sizeof(lv), 8, "sizeof(STT419)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT419)");
    check_field_offset(lv, fa, 0, "STT419.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT419, STT419)
//============================================================================


struct  STT429  {
  __tsi64 fa;
  unsigned short  :0;
};
//SIG(1 STT429) C1{ FL Fs:0}



static void Test_STT429()
{
  {
    init_simple_test("STT429");
    static STRUCT_IF_C STT429 lv;
    check2(sizeof(lv), 8, "sizeof(STT429)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT429)");
    check_field_offset(lv, fa, 0, "STT429.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT429, STT429)
//============================================================================


struct  STT439  {
  __tsi64 fa;
  unsigned int  :0;
};
//SIG(1 STT439) C1{ FL Fi:0}



static void Test_STT439()
{
  {
    init_simple_test("STT439");
    static STRUCT_IF_C STT439 lv;
    check2(sizeof(lv), 8, "sizeof(STT439)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT439)");
    check_field_offset(lv, fa, 0, "STT439.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT439, STT439)
//============================================================================


struct  STT449  {
  __tsi64 fa;
  __tsu64  :0;
};
//SIG(1 STT449) C1{ FL FL:0}



static void Test_STT449()
{
  {
    init_simple_test("STT449");
    static STRUCT_IF_C STT449 lv;
    check2(sizeof(lv), 8, "sizeof(STT449)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT449)");
    check_field_offset(lv, fa, 0, "STT449.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT449, STT449)
//============================================================================


struct  STT459  {
  __tsi64 fa;
  unsigned char  :3;
};
//SIG(1 STT459) C1{ FL Fc:3}



static void Test_STT459()
{
  {
    init_simple_test("STT459");
    static STRUCT_IF_C STT459 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT459)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT459)");
    check_field_offset(lv, fa, 0, "STT459.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT459, STT459)
//============================================================================


struct  STT469  {
  __tsi64 fa;
  unsigned short  :3;
};
//SIG(1 STT469) C1{ FL Fs:3}



static void Test_STT469()
{
  {
    init_simple_test("STT469");
    static STRUCT_IF_C STT469 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT469)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT469)");
    check_field_offset(lv, fa, 0, "STT469.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT469, STT469)
//============================================================================


struct  STT479  {
  __tsi64 fa;
  unsigned int  :3;
};
//SIG(1 STT479) C1{ FL Fi:3}



static void Test_STT479()
{
  {
    init_simple_test("STT479");
    static STRUCT_IF_C STT479 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT479)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT479)");
    check_field_offset(lv, fa, 0, "STT479.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT479, STT479)
//============================================================================


struct  STT489  {
  __tsi64 fa;
  __tsu64  :3;
};
//SIG(1 STT489) C1{ FL FL:3}



static void Test_STT489()
{
  {
    init_simple_test("STT489");
    static STRUCT_IF_C STT489 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT489)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT489)");
    check_field_offset(lv, fa, 0, "STT489.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT489, STT489)
//============================================================================


struct  STT499  {
  __tsi64 fa;
  unsigned short  :8;
};
//SIG(1 STT499) C1{ FL Fs:8}



static void Test_STT499()
{
  {
    init_simple_test("STT499");
    static STRUCT_IF_C STT499 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT499)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT499)");
    check_field_offset(lv, fa, 0, "STT499.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT499, STT499)
//============================================================================


struct  STT4109  {
  __tsi64 fa;
  unsigned int  :8;
};
//SIG(1 STT4109) C1{ FL Fi:8}



static void Test_STT4109()
{
  {
    init_simple_test("STT4109");
    static STRUCT_IF_C STT4109 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4109)");
    check_field_offset(lv, fa, 0, "STT4109.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4109, STT4109)
//============================================================================


struct  STT4119  {
  __tsi64 fa;
  __tsu64  :8;
};
//SIG(1 STT4119) C1{ FL FL:8}



static void Test_STT4119()
{
  {
    init_simple_test("STT4119");
    static STRUCT_IF_C STT4119 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4119)");
    check_field_offset(lv, fa, 0, "STT4119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4119, STT4119)
//============================================================================


struct  STT4129  {
  __tsi64 fa;
  unsigned int  :18;
};
//SIG(1 STT4129) C1{ FL Fi:18}



static void Test_STT4129()
{
  {
    init_simple_test("STT4129");
    static STRUCT_IF_C STT4129 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4129)");
    check_field_offset(lv, fa, 0, "STT4129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4129, STT4129)
//============================================================================


struct  STT4139  {
  __tsi64 fa;
  __tsu64  :18;
};
//SIG(1 STT4139) C1{ FL FL:18}



static void Test_STT4139()
{
  {
    init_simple_test("STT4139");
    static STRUCT_IF_C STT4139 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4139)");
    check_field_offset(lv, fa, 0, "STT4139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4139, STT4139)
//============================================================================


struct  STT4149  {
  __tsi64 fa;
  __tsu64  :48;
};
//SIG(1 STT4149) C1{ FL FL:48}



static void Test_STT4149()
{
  {
    init_simple_test("STT4149");
    static STRUCT_IF_C STT4149 lv;
    check2(sizeof(lv), 16, "sizeof(STT4149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4149)");
    check_field_offset(lv, fa, 0, "STT4149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4149, STT4149)
//============================================================================


struct  STT4159  {
  __tsi64 fa;
  unsigned char bf:3;
};
//SIG(1 STT4159) C1{ FL Fc:3}



static void Test_STT4159()
{
  {
    init_simple_test("STT4159");
    static STRUCT_IF_C STT4159 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4159)");
    check_field_offset(lv, fa, 0, "STT4159.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4159");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4159");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4159, STT4159)
//============================================================================


struct  STT4169  {
  __tsi64 fa;
  unsigned short bf:3;
};
//SIG(1 STT4169) C1{ FL Fs:3}



static void Test_STT4169()
{
  {
    init_simple_test("STT4169");
    static STRUCT_IF_C STT4169 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4169)");
    check_field_offset(lv, fa, 0, "STT4169.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4169");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4169");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4169, STT4169)
//============================================================================


struct  STT4179  {
  __tsi64 fa;
  unsigned int bf:3;
};
//SIG(1 STT4179) C1{ FL Fi:3}



static void Test_STT4179()
{
  {
    init_simple_test("STT4179");
    static STRUCT_IF_C STT4179 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4179)");
    check_field_offset(lv, fa, 0, "STT4179.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4179");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4179");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4179, STT4179)
//============================================================================


struct  STT4189  {
  __tsi64 fa;
  __tsu64 bf:3;
};
//SIG(1 STT4189) C1{ FL FL:3}



static void Test_STT4189()
{
  {
    init_simple_test("STT4189");
    static STRUCT_IF_C STT4189 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4189)");
    check_field_offset(lv, fa, 0, "STT4189.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4189");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4189");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4189, STT4189)
//============================================================================


struct  STT4199  {
  __tsi64 fa;
  unsigned short bf:8;
};
//SIG(1 STT4199) C1{ FL Fs:8}



static void Test_STT4199()
{
  {
    init_simple_test("STT4199");
    static STRUCT_IF_C STT4199 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4199)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4199)");
    check_field_offset(lv, fa, 0, "STT4199.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4199");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4199");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4199, STT4199)
//============================================================================


struct  STT4209  {
  __tsi64 fa;
  unsigned int bf:8;
};
//SIG(1 STT4209) C1{ FL Fi:8}



static void Test_STT4209()
{
  {
    init_simple_test("STT4209");
    static STRUCT_IF_C STT4209 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4209)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4209)");
    check_field_offset(lv, fa, 0, "STT4209.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4209");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4209");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4209, STT4209)
//============================================================================


struct  STT4219  {
  __tsi64 fa;
  __tsu64 bf:8;
};
//SIG(1 STT4219) C1{ FL FL:8}



static void Test_STT4219()
{
  {
    init_simple_test("STT4219");
    static STRUCT_IF_C STT4219 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4219)");
    check_field_offset(lv, fa, 0, "STT4219.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4219");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4219");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4219, STT4219)
//============================================================================


struct  STT4229  {
  __tsi64 fa;
  unsigned int bf:18;
};
//SIG(1 STT4229) C1{ FL Fi:18}



static void Test_STT4229()
{
  {
    init_simple_test("STT4229");
    static STRUCT_IF_C STT4229 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4229)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4229)");
    check_field_offset(lv, fa, 0, "STT4229.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4229");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4229");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4229, STT4229)
//============================================================================


struct  STT4239  {
  __tsi64 fa;
  __tsu64 bf:18;
};
//SIG(1 STT4239) C1{ FL FL:18}



static void Test_STT4239()
{
  {
    init_simple_test("STT4239");
    static STRUCT_IF_C STT4239 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4239)");
    check_field_offset(lv, fa, 0, "STT4239.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4239");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4239");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4239, STT4239)
//============================================================================


struct  STT4249  {
  __tsi64 fa;
  __tsu64 bf:48;
};
//SIG(1 STT4249) C1{ FL FL:48}



static void Test_STT4249()
{
  {
    init_simple_test("STT4249");
    static STRUCT_IF_C STT4249 lv;
    check2(sizeof(lv), 16, "sizeof(STT4249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4249)");
    check_field_offset(lv, fa, 0, "STT4249.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4249");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4249");
  }
}
ARRANGE_TO_CALL_ME(Test_STT4249, STT4249)
//============================================================================


struct  STT510  {
  void *fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT510) C1{ Fp Fc:0 Fc}



static void Test_STT510()
{
  {
    init_simple_test("STT510");
    static STRUCT_IF_C STT510 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT510)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT510)");
    check_field_offset(lv, fa, 0, "STT510.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT510.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT510, STT510)
//============================================================================


struct  STT520  {
  void *fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT520) C1{ Fp Fs:0 Fc}



static void Test_STT520()
{
  {
    init_simple_test("STT520");
    static STRUCT_IF_C STT520 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT520)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT520)");
    check_field_offset(lv, fa, 0, "STT520.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT520.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT520, STT520)
//============================================================================


struct  STT530  {
  void *fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT530) C1{ Fp Fi:0 Fc}



static void Test_STT530()
{
  {
    init_simple_test("STT530");
    static STRUCT_IF_C STT530 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT530)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT530)");
    check_field_offset(lv, fa, 0, "STT530.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT530.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT530, STT530)
//============================================================================


struct  STT540  {
  void *fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT540) C1{ Fp FL:0 Fc}



static void Test_STT540()
{
  {
    init_simple_test("STT540");
    static STRUCT_IF_C STT540 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT540)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT540)");
    check_field_offset(lv, fa, 0, "STT540.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT540.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT540, STT540)
//============================================================================


struct  STT550  {
  void *fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT550) C1{ Fp Fc:3 Fc}



static void Test_STT550()
{
  {
    init_simple_test("STT550");
    static STRUCT_IF_C STT550 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT550)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT550)");
    check_field_offset(lv, fa, 0, "STT550.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT550.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT550, STT550)
//============================================================================


struct  STT560  {
  void *fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT560) C1{ Fp Fs:3 Fc}



static void Test_STT560()
{
  {
    init_simple_test("STT560");
    static STRUCT_IF_C STT560 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT560)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT560)");
    check_field_offset(lv, fa, 0, "STT560.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT560.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT560, STT560)
//============================================================================


struct  STT570  {
  void *fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT570) C1{ Fp Fi:3 Fc}



static void Test_STT570()
{
  {
    init_simple_test("STT570");
    static STRUCT_IF_C STT570 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT570)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT570)");
    check_field_offset(lv, fa, 0, "STT570.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT570.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT570, STT570)
//============================================================================


struct  STT580  {
  void *fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT580) C1{ Fp FL:3 Fc}



static void Test_STT580()
{
  {
    init_simple_test("STT580");
    static STRUCT_IF_C STT580 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT580)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT580)");
    check_field_offset(lv, fa, 0, "STT580.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT580.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT580, STT580)
//============================================================================


struct  STT590  {
  void *fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT590) C1{ Fp Fs:8 Fc}



static void Test_STT590()
{
  {
    init_simple_test("STT590");
    static STRUCT_IF_C STT590 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT590)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT590)");
    check_field_offset(lv, fa, 0, "STT590.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT590.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT590, STT590)
//============================================================================


struct  STT5100  {
  void *fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT5100) C1{ Fp Fi:8 Fc}



static void Test_STT5100()
{
  {
    init_simple_test("STT5100");
    static STRUCT_IF_C STT5100 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5100)");
    check_field_offset(lv, fa, 0, "STT5100.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5100, STT5100)
//============================================================================


struct  STT5110  {
  void *fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT5110) C1{ Fp FL:8 Fc}



static void Test_STT5110()
{
  {
    init_simple_test("STT5110");
    static STRUCT_IF_C STT5110 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5110)");
    check_field_offset(lv, fa, 0, "STT5110.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5110, STT5110)
//============================================================================


struct  STT5120  {
  void *fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT5120) C1{ Fp Fi:18 Fc}



static void Test_STT5120()
{
  {
    init_simple_test("STT5120");
    static STRUCT_IF_C STT5120 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5120)");
    check_field_offset(lv, fa, 0, "STT5120.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5120, STT5120)
//============================================================================


struct  STT5130  {
  void *fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT5130) C1{ Fp FL:18 Fc}



static void Test_STT5130()
{
  {
    init_simple_test("STT5130");
    static STRUCT_IF_C STT5130 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5130)");
    check_field_offset(lv, fa, 0, "STT5130.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5130, STT5130)
//============================================================================


struct  STT5140  {
  void *fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT5140) C1{ Fp FL:48 Fc}



static void Test_STT5140()
{
  {
    init_simple_test("STT5140");
    static STRUCT_IF_C STT5140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5140)");
    check_field_offset(lv, fa, 0, "STT5140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5140, STT5140)
//============================================================================


struct  STT5150  {
  void *fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT5150) C1{ Fp Fc:3 Fc}



static void Test_STT5150()
{
  {
    init_simple_test("STT5150");
    static STRUCT_IF_C STT5150 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5150)");
    check_field_offset(lv, fa, 0, "STT5150.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5150");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5150");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5150, STT5150)
//============================================================================


struct  STT5160  {
  void *fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT5160) C1{ Fp Fs:3 Fc}



static void Test_STT5160()
{
  {
    init_simple_test("STT5160");
    static STRUCT_IF_C STT5160 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5160)");
    check_field_offset(lv, fa, 0, "STT5160.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5160");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5160");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5160, STT5160)
//============================================================================


struct  STT5170  {
  void *fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT5170) C1{ Fp Fi:3 Fc}



static void Test_STT5170()
{
  {
    init_simple_test("STT5170");
    static STRUCT_IF_C STT5170 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5170)");
    check_field_offset(lv, fa, 0, "STT5170.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5170");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5170");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5170, STT5170)
//============================================================================


struct  STT5180  {
  void *fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT5180) C1{ Fp FL:3 Fc}



static void Test_STT5180()
{
  {
    init_simple_test("STT5180");
    static STRUCT_IF_C STT5180 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5180)");
    check_field_offset(lv, fa, 0, "STT5180.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5180");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5180");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5180, STT5180)
//============================================================================


struct  STT5190  {
  void *fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT5190) C1{ Fp Fs:8 Fc}



static void Test_STT5190()
{
  {
    init_simple_test("STT5190");
    static STRUCT_IF_C STT5190 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5190)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5190)");
    check_field_offset(lv, fa, 0, "STT5190.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5190");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5190");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5190, STT5190)
//============================================================================


struct  STT5200  {
  void *fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT5200) C1{ Fp Fi:8 Fc}



static void Test_STT5200()
{
  {
    init_simple_test("STT5200");
    static STRUCT_IF_C STT5200 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5200)");
    check_field_offset(lv, fa, 0, "STT5200.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5200");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5200");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5200, STT5200)
//============================================================================


struct  STT5210  {
  void *fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT5210) C1{ Fp FL:8 Fc}



static void Test_STT5210()
{
  {
    init_simple_test("STT5210");
    static STRUCT_IF_C STT5210 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5210)");
    check_field_offset(lv, fa, 0, "STT5210.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5210");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5210");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5210, STT5210)
//============================================================================


struct  STT5220  {
  void *fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT5220) C1{ Fp Fi:18 Fc}



static void Test_STT5220()
{
  {
    init_simple_test("STT5220");
    static STRUCT_IF_C STT5220 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5220)");
    check_field_offset(lv, fa, 0, "STT5220.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5220");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5220");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5220, STT5220)
//============================================================================


struct  STT5230  {
  void *fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT5230) C1{ Fp FL:18 Fc}



static void Test_STT5230()
{
  {
    init_simple_test("STT5230");
    static STRUCT_IF_C STT5230 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5230)");
    check_field_offset(lv, fa, 0, "STT5230.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5230");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5230");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5230, STT5230)
//============================================================================


struct  STT5240  {
  void *fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT5240) C1{ Fp FL:48 Fc}



static void Test_STT5240()
{
  {
    init_simple_test("STT5240");
    static STRUCT_IF_C STT5240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5240)");
    check_field_offset(lv, fa, 0, "STT5240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5240, STT5240)
//============================================================================


struct  STT511  {
  void *fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT511) C1{ Fp Fc:0 Fs}



static void Test_STT511()
{
  {
    init_simple_test("STT511");
    static STRUCT_IF_C STT511 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT511)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT511)");
    check_field_offset(lv, fa, 0, "STT511.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT511.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT511, STT511)
//============================================================================


struct  STT521  {
  void *fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT521) C1{ Fp Fs:0 Fs}



static void Test_STT521()
{
  {
    init_simple_test("STT521");
    static STRUCT_IF_C STT521 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT521)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT521)");
    check_field_offset(lv, fa, 0, "STT521.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT521.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT521, STT521)
//============================================================================


struct  STT531  {
  void *fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT531) C1{ Fp Fi:0 Fs}



static void Test_STT531()
{
  {
    init_simple_test("STT531");
    static STRUCT_IF_C STT531 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT531)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT531)");
    check_field_offset(lv, fa, 0, "STT531.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT531.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT531, STT531)
//============================================================================


struct  STT541  {
  void *fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT541) C1{ Fp FL:0 Fs}



static void Test_STT541()
{
  {
    init_simple_test("STT541");
    static STRUCT_IF_C STT541 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT541)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT541)");
    check_field_offset(lv, fa, 0, "STT541.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT541.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT541, STT541)
//============================================================================


struct  STT551  {
  void *fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT551) C1{ Fp Fc:3 Fs}



static void Test_STT551()
{
  {
    init_simple_test("STT551");
    static STRUCT_IF_C STT551 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT551)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT551)");
    check_field_offset(lv, fa, 0, "STT551.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT551.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT551, STT551)
//============================================================================


struct  STT561  {
  void *fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT561) C1{ Fp Fs:3 Fs}



static void Test_STT561()
{
  {
    init_simple_test("STT561");
    static STRUCT_IF_C STT561 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT561)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT561)");
    check_field_offset(lv, fa, 0, "STT561.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT561.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT561, STT561)
//============================================================================


struct  STT571  {
  void *fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT571) C1{ Fp Fi:3 Fs}



static void Test_STT571()
{
  {
    init_simple_test("STT571");
    static STRUCT_IF_C STT571 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT571)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT571)");
    check_field_offset(lv, fa, 0, "STT571.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT571.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT571, STT571)
//============================================================================


struct  STT581  {
  void *fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT581) C1{ Fp FL:3 Fs}



static void Test_STT581()
{
  {
    init_simple_test("STT581");
    static STRUCT_IF_C STT581 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT581)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT581)");
    check_field_offset(lv, fa, 0, "STT581.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT581.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT581, STT581)
//============================================================================


struct  STT591  {
  void *fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT591) C1{ Fp Fs:8 Fs}



static void Test_STT591()
{
  {
    init_simple_test("STT591");
    static STRUCT_IF_C STT591 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT591)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT591)");
    check_field_offset(lv, fa, 0, "STT591.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT591.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT591, STT591)
//============================================================================


struct  STT5101  {
  void *fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT5101) C1{ Fp Fi:8 Fs}



static void Test_STT5101()
{
  {
    init_simple_test("STT5101");
    static STRUCT_IF_C STT5101 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5101)");
    check_field_offset(lv, fa, 0, "STT5101.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5101, STT5101)
//============================================================================


struct  STT5111  {
  void *fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT5111) C1{ Fp FL:8 Fs}



static void Test_STT5111()
{
  {
    init_simple_test("STT5111");
    static STRUCT_IF_C STT5111 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5111)");
    check_field_offset(lv, fa, 0, "STT5111.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5111, STT5111)
//============================================================================


struct  STT5121  {
  void *fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT5121) C1{ Fp Fi:18 Fs}



static void Test_STT5121()
{
  {
    init_simple_test("STT5121");
    static STRUCT_IF_C STT5121 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5121)");
    check_field_offset(lv, fa, 0, "STT5121.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5121, STT5121)
//============================================================================


struct  STT5131  {
  void *fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT5131) C1{ Fp FL:18 Fs}



static void Test_STT5131()
{
  {
    init_simple_test("STT5131");
    static STRUCT_IF_C STT5131 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5131)");
    check_field_offset(lv, fa, 0, "STT5131.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5131, STT5131)
//============================================================================


struct  STT5141  {
  void *fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT5141) C1{ Fp FL:48 Fs}



static void Test_STT5141()
{
  {
    init_simple_test("STT5141");
    static STRUCT_IF_C STT5141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5141)");
    check_field_offset(lv, fa, 0, "STT5141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5141, STT5141)
//============================================================================


struct  STT5151  {
  void *fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT5151) C1{ Fp Fc:3 Fs}



static void Test_STT5151()
{
  {
    init_simple_test("STT5151");
    static STRUCT_IF_C STT5151 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5151)");
    check_field_offset(lv, fa, 0, "STT5151.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5151");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5151");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5151, STT5151)
//============================================================================


struct  STT5161  {
  void *fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT5161) C1{ Fp Fs:3 Fs}



static void Test_STT5161()
{
  {
    init_simple_test("STT5161");
    static STRUCT_IF_C STT5161 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5161)");
    check_field_offset(lv, fa, 0, "STT5161.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5161");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5161");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5161, STT5161)
//============================================================================


struct  STT5171  {
  void *fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT5171) C1{ Fp Fi:3 Fs}



static void Test_STT5171()
{
  {
    init_simple_test("STT5171");
    static STRUCT_IF_C STT5171 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5171)");
    check_field_offset(lv, fa, 0, "STT5171.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5171");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5171");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5171, STT5171)
//============================================================================


struct  STT5181  {
  void *fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT5181) C1{ Fp FL:3 Fs}



static void Test_STT5181()
{
  {
    init_simple_test("STT5181");
    static STRUCT_IF_C STT5181 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5181)");
    check_field_offset(lv, fa, 0, "STT5181.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5181");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5181");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5181, STT5181)
//============================================================================


struct  STT5191  {
  void *fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT5191) C1{ Fp Fs:8 Fs}



static void Test_STT5191()
{
  {
    init_simple_test("STT5191");
    static STRUCT_IF_C STT5191 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5191)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5191)");
    check_field_offset(lv, fa, 0, "STT5191.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5191");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5191");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5191, STT5191)
//============================================================================


struct  STT5201  {
  void *fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT5201) C1{ Fp Fi:8 Fs}



static void Test_STT5201()
{
  {
    init_simple_test("STT5201");
    static STRUCT_IF_C STT5201 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5201)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5201)");
    check_field_offset(lv, fa, 0, "STT5201.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5201");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5201");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5201, STT5201)
//============================================================================


struct  STT5211  {
  void *fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT5211) C1{ Fp FL:8 Fs}



static void Test_STT5211()
{
  {
    init_simple_test("STT5211");
    static STRUCT_IF_C STT5211 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5211)");
    check_field_offset(lv, fa, 0, "STT5211.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5211");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5211");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5211, STT5211)
//============================================================================


struct  STT5221  {
  void *fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT5221) C1{ Fp Fi:18 Fs}



static void Test_STT5221()
{
  {
    init_simple_test("STT5221");
    static STRUCT_IF_C STT5221 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5221)");
    check_field_offset(lv, fa, 0, "STT5221.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5221");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5221");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5221, STT5221)
//============================================================================


struct  STT5231  {
  void *fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT5231) C1{ Fp FL:18 Fs}



static void Test_STT5231()
{
  {
    init_simple_test("STT5231");
    static STRUCT_IF_C STT5231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5231)");
    check_field_offset(lv, fa, 0, "STT5231.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5231");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5231");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5231, STT5231)
//============================================================================


struct  STT5241  {
  void *fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT5241) C1{ Fp FL:48 Fs}



static void Test_STT5241()
{
  {
    init_simple_test("STT5241");
    static STRUCT_IF_C STT5241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5241)");
    check_field_offset(lv, fa, 0, "STT5241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5241, STT5241)
//============================================================================


struct  STT512  {
  void *fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT512) C1{ Fp Fc:0 Fi}



static void Test_STT512()
{
  {
    init_simple_test("STT512");
    static STRUCT_IF_C STT512 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT512)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT512)");
    check_field_offset(lv, fa, 0, "STT512.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT512.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT512, STT512)
//============================================================================


struct  STT522  {
  void *fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT522) C1{ Fp Fs:0 Fi}



static void Test_STT522()
{
  {
    init_simple_test("STT522");
    static STRUCT_IF_C STT522 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT522)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT522)");
    check_field_offset(lv, fa, 0, "STT522.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT522.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT522, STT522)
//============================================================================


struct  STT532  {
  void *fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT532) C1{ Fp Fi:0 Fi}



static void Test_STT532()
{
  {
    init_simple_test("STT532");
    static STRUCT_IF_C STT532 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT532)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT532)");
    check_field_offset(lv, fa, 0, "STT532.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT532.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT532, STT532)
//============================================================================


struct  STT542  {
  void *fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT542) C1{ Fp FL:0 Fi}



static void Test_STT542()
{
  {
    init_simple_test("STT542");
    static STRUCT_IF_C STT542 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT542)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT542)");
    check_field_offset(lv, fa, 0, "STT542.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT542.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT542, STT542)
//============================================================================


struct  STT552  {
  void *fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT552) C1{ Fp Fc:3 Fi}



static void Test_STT552()
{
  {
    init_simple_test("STT552");
    static STRUCT_IF_C STT552 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT552)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT552)");
    check_field_offset(lv, fa, 0, "STT552.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT552.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT552, STT552)
//============================================================================


struct  STT562  {
  void *fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT562) C1{ Fp Fs:3 Fi}



static void Test_STT562()
{
  {
    init_simple_test("STT562");
    static STRUCT_IF_C STT562 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT562)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT562)");
    check_field_offset(lv, fa, 0, "STT562.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT562.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT562, STT562)
//============================================================================


struct  STT572  {
  void *fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT572) C1{ Fp Fi:3 Fi}



static void Test_STT572()
{
  {
    init_simple_test("STT572");
    static STRUCT_IF_C STT572 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT572)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT572)");
    check_field_offset(lv, fa, 0, "STT572.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT572.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT572, STT572)
//============================================================================


struct  STT582  {
  void *fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT582) C1{ Fp FL:3 Fi}



static void Test_STT582()
{
  {
    init_simple_test("STT582");
    static STRUCT_IF_C STT582 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT582)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT582)");
    check_field_offset(lv, fa, 0, "STT582.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT582.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT582, STT582)
//============================================================================


struct  STT592  {
  void *fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT592) C1{ Fp Fs:8 Fi}



static void Test_STT592()
{
  {
    init_simple_test("STT592");
    static STRUCT_IF_C STT592 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT592)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT592)");
    check_field_offset(lv, fa, 0, "STT592.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT592.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT592, STT592)
//============================================================================


struct  STT5102  {
  void *fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT5102) C1{ Fp Fi:8 Fi}



static void Test_STT5102()
{
  {
    init_simple_test("STT5102");
    static STRUCT_IF_C STT5102 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5102)");
    check_field_offset(lv, fa, 0, "STT5102.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5102, STT5102)
//============================================================================


struct  STT5112  {
  void *fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT5112) C1{ Fp FL:8 Fi}



static void Test_STT5112()
{
  {
    init_simple_test("STT5112");
    static STRUCT_IF_C STT5112 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5112)");
    check_field_offset(lv, fa, 0, "STT5112.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5112, STT5112)
//============================================================================


struct  STT5122  {
  void *fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT5122) C1{ Fp Fi:18 Fi}



static void Test_STT5122()
{
  {
    init_simple_test("STT5122");
    static STRUCT_IF_C STT5122 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5122)");
    check_field_offset(lv, fa, 0, "STT5122.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5122, STT5122)
//============================================================================


struct  STT5132  {
  void *fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT5132) C1{ Fp FL:18 Fi}



static void Test_STT5132()
{
  {
    init_simple_test("STT5132");
    static STRUCT_IF_C STT5132 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5132)");
    check_field_offset(lv, fa, 0, "STT5132.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5132, STT5132)
//============================================================================


struct  STT5142  {
  void *fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT5142) C1{ Fp FL:48 Fi}



static void Test_STT5142()
{
  {
    init_simple_test("STT5142");
    static STRUCT_IF_C STT5142 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5142)");
    check_field_offset(lv, fa, 0, "STT5142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5142, STT5142)
//============================================================================


struct  STT5152  {
  void *fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT5152) C1{ Fp Fc:3 Fi}



static void Test_STT5152()
{
  {
    init_simple_test("STT5152");
    static STRUCT_IF_C STT5152 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5152)");
    check_field_offset(lv, fa, 0, "STT5152.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5152");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5152");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5152, STT5152)
//============================================================================


struct  STT5162  {
  void *fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT5162) C1{ Fp Fs:3 Fi}



static void Test_STT5162()
{
  {
    init_simple_test("STT5162");
    static STRUCT_IF_C STT5162 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5162)");
    check_field_offset(lv, fa, 0, "STT5162.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5162");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5162");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5162, STT5162)
//============================================================================


struct  STT5172  {
  void *fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT5172) C1{ Fp Fi:3 Fi}



static void Test_STT5172()
{
  {
    init_simple_test("STT5172");
    static STRUCT_IF_C STT5172 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5172)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5172)");
    check_field_offset(lv, fa, 0, "STT5172.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5172");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5172");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5172, STT5172)
//============================================================================


struct  STT5182  {
  void *fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT5182) C1{ Fp FL:3 Fi}



static void Test_STT5182()
{
  {
    init_simple_test("STT5182");
    static STRUCT_IF_C STT5182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5182)");
    check_field_offset(lv, fa, 0, "STT5182.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5182");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5182");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5182, STT5182)
//============================================================================


struct  STT5192  {
  void *fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT5192) C1{ Fp Fs:8 Fi}



static void Test_STT5192()
{
  {
    init_simple_test("STT5192");
    static STRUCT_IF_C STT5192 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5192)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5192)");
    check_field_offset(lv, fa, 0, "STT5192.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5192");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5192");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5192, STT5192)
//============================================================================


struct  STT5202  {
  void *fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT5202) C1{ Fp Fi:8 Fi}



static void Test_STT5202()
{
  {
    init_simple_test("STT5202");
    static STRUCT_IF_C STT5202 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5202)");
    check_field_offset(lv, fa, 0, "STT5202.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5202");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5202");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5202, STT5202)
//============================================================================


struct  STT5212  {
  void *fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT5212) C1{ Fp FL:8 Fi}



static void Test_STT5212()
{
  {
    init_simple_test("STT5212");
    static STRUCT_IF_C STT5212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5212)");
    check_field_offset(lv, fa, 0, "STT5212.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5212");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5212");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5212, STT5212)
//============================================================================


struct  STT5222  {
  void *fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT5222) C1{ Fp Fi:18 Fi}



static void Test_STT5222()
{
  {
    init_simple_test("STT5222");
    static STRUCT_IF_C STT5222 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5222)");
    check_field_offset(lv, fa, 0, "STT5222.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5222");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5222");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5222, STT5222)
//============================================================================


struct  STT5232  {
  void *fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT5232) C1{ Fp FL:18 Fi}



static void Test_STT5232()
{
  {
    init_simple_test("STT5232");
    static STRUCT_IF_C STT5232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5232)");
    check_field_offset(lv, fa, 0, "STT5232.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5232");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5232");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5232, STT5232)
//============================================================================


struct  STT5242  {
  void *fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT5242) C1{ Fp FL:48 Fi}



static void Test_STT5242()
{
  {
    init_simple_test("STT5242");
    static STRUCT_IF_C STT5242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5242)");
    check_field_offset(lv, fa, 0, "STT5242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5242, STT5242)
//============================================================================


struct  STT513  {
  void *fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT513) C1{ Fp Fc:0 Fl}



static void Test_STT513()
{
  {
    init_simple_test("STT513");
    static STRUCT_IF_C STT513 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT513)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT513)");
    check_field_offset(lv, fa, 0, "STT513.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT513.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT513, STT513)
//============================================================================


struct  STT523  {
  void *fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT523) C1{ Fp Fs:0 Fl}



static void Test_STT523()
{
  {
    init_simple_test("STT523");
    static STRUCT_IF_C STT523 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT523)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT523)");
    check_field_offset(lv, fa, 0, "STT523.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT523.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT523, STT523)
//============================================================================


struct  STT533  {
  void *fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT533) C1{ Fp Fi:0 Fl}



static void Test_STT533()
{
  {
    init_simple_test("STT533");
    static STRUCT_IF_C STT533 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT533)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT533)");
    check_field_offset(lv, fa, 0, "STT533.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT533.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT533, STT533)
//============================================================================


struct  STT543  {
  void *fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT543) C1{ Fp FL:0 Fl}



static void Test_STT543()
{
  {
    init_simple_test("STT543");
    static STRUCT_IF_C STT543 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT543)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT543)");
    check_field_offset(lv, fa, 0, "STT543.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT543.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT543, STT543)
//============================================================================


struct  STT553  {
  void *fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT553) C1{ Fp Fc:3 Fl}



static void Test_STT553()
{
  {
    init_simple_test("STT553");
    static STRUCT_IF_C STT553 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT553)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT553)");
    check_field_offset(lv, fa, 0, "STT553.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT553.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT553, STT553)
//============================================================================


struct  STT563  {
  void *fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT563) C1{ Fp Fs:3 Fl}



static void Test_STT563()
{
  {
    init_simple_test("STT563");
    static STRUCT_IF_C STT563 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT563)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT563)");
    check_field_offset(lv, fa, 0, "STT563.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT563.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT563, STT563)
//============================================================================


struct  STT573  {
  void *fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT573) C1{ Fp Fi:3 Fl}



static void Test_STT573()
{
  {
    init_simple_test("STT573");
    static STRUCT_IF_C STT573 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT573)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT573)");
    check_field_offset(lv, fa, 0, "STT573.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT573.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT573, STT573)
//============================================================================


struct  STT583  {
  void *fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT583) C1{ Fp FL:3 Fl}



static void Test_STT583()
{
  {
    init_simple_test("STT583");
    static STRUCT_IF_C STT583 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT583)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT583)");
    check_field_offset(lv, fa, 0, "STT583.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT583.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT583, STT583)
//============================================================================


struct  STT593  {
  void *fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT593) C1{ Fp Fs:8 Fl}



static void Test_STT593()
{
  {
    init_simple_test("STT593");
    static STRUCT_IF_C STT593 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT593)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT593)");
    check_field_offset(lv, fa, 0, "STT593.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT593.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT593, STT593)
//============================================================================


struct  STT5103  {
  void *fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT5103) C1{ Fp Fi:8 Fl}



static void Test_STT5103()
{
  {
    init_simple_test("STT5103");
    static STRUCT_IF_C STT5103 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5103)");
    check_field_offset(lv, fa, 0, "STT5103.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5103, STT5103)
//============================================================================


struct  STT5113  {
  void *fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT5113) C1{ Fp FL:8 Fl}



static void Test_STT5113()
{
  {
    init_simple_test("STT5113");
    static STRUCT_IF_C STT5113 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5113)");
    check_field_offset(lv, fa, 0, "STT5113.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5113, STT5113)
//============================================================================


struct  STT5123  {
  void *fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT5123) C1{ Fp Fi:18 Fl}



static void Test_STT5123()
{
  {
    init_simple_test("STT5123");
    static STRUCT_IF_C STT5123 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5123)");
    check_field_offset(lv, fa, 0, "STT5123.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5123, STT5123)
//============================================================================


struct  STT5133  {
  void *fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT5133) C1{ Fp FL:18 Fl}



static void Test_STT5133()
{
  {
    init_simple_test("STT5133");
    static STRUCT_IF_C STT5133 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5133)");
    check_field_offset(lv, fa, 0, "STT5133.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5133, STT5133)
//============================================================================


struct  STT5143  {
  void *fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT5143) C1{ Fp FL:48 Fl}



static void Test_STT5143()
{
  {
    init_simple_test("STT5143");
    static STRUCT_IF_C STT5143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5143)");
    check_field_offset(lv, fa, 0, "STT5143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5143, STT5143)
//============================================================================


struct  STT5153  {
  void *fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT5153) C1{ Fp Fc:3 Fl}



static void Test_STT5153()
{
  {
    init_simple_test("STT5153");
    static STRUCT_IF_C STT5153 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5153)");
    check_field_offset(lv, fa, 0, "STT5153.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5153");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5153");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5153, STT5153)
//============================================================================


struct  STT5163  {
  void *fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT5163) C1{ Fp Fs:3 Fl}



static void Test_STT5163()
{
  {
    init_simple_test("STT5163");
    static STRUCT_IF_C STT5163 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5163)");
    check_field_offset(lv, fa, 0, "STT5163.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5163");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5163");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5163, STT5163)
//============================================================================


struct  STT5173  {
  void *fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT5173) C1{ Fp Fi:3 Fl}



static void Test_STT5173()
{
  {
    init_simple_test("STT5173");
    static STRUCT_IF_C STT5173 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5173)");
    check_field_offset(lv, fa, 0, "STT5173.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5173");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5173");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5173, STT5173)
//============================================================================


struct  STT5183  {
  void *fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT5183) C1{ Fp FL:3 Fl}



static void Test_STT5183()
{
  {
    init_simple_test("STT5183");
    static STRUCT_IF_C STT5183 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5183)");
    check_field_offset(lv, fa, 0, "STT5183.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5183");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5183");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5183, STT5183)
//============================================================================


struct  STT5193  {
  void *fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT5193) C1{ Fp Fs:8 Fl}



static void Test_STT5193()
{
  {
    init_simple_test("STT5193");
    static STRUCT_IF_C STT5193 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5193)");
    check_field_offset(lv, fa, 0, "STT5193.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5193");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5193");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5193, STT5193)
//============================================================================


struct  STT5203  {
  void *fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT5203) C1{ Fp Fi:8 Fl}



static void Test_STT5203()
{
  {
    init_simple_test("STT5203");
    static STRUCT_IF_C STT5203 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5203)");
    check_field_offset(lv, fa, 0, "STT5203.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5203");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5203");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5203, STT5203)
//============================================================================


struct  STT5213  {
  void *fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT5213) C1{ Fp FL:8 Fl}



static void Test_STT5213()
{
  {
    init_simple_test("STT5213");
    static STRUCT_IF_C STT5213 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5213)");
    check_field_offset(lv, fa, 0, "STT5213.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5213");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5213");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5213, STT5213)
//============================================================================


struct  STT5223  {
  void *fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT5223) C1{ Fp Fi:18 Fl}



static void Test_STT5223()
{
  {
    init_simple_test("STT5223");
    static STRUCT_IF_C STT5223 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5223)");
    check_field_offset(lv, fa, 0, "STT5223.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5223");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5223");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5223, STT5223)
//============================================================================


struct  STT5233  {
  void *fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT5233) C1{ Fp FL:18 Fl}



static void Test_STT5233()
{
  {
    init_simple_test("STT5233");
    static STRUCT_IF_C STT5233 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5233)");
    check_field_offset(lv, fa, 0, "STT5233.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5233");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5233");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5233, STT5233)
//============================================================================


struct  STT5243  {
  void *fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT5243) C1{ Fp FL:48 Fl}



static void Test_STT5243()
{
  {
    init_simple_test("STT5243");
    static STRUCT_IF_C STT5243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5243)");
    check_field_offset(lv, fa, 0, "STT5243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5243, STT5243)
//============================================================================


struct  STT514  {
  void *fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT514) C1{ Fp Fc:0 FL}



static void Test_STT514()
{
  {
    init_simple_test("STT514");
    static STRUCT_IF_C STT514 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT514)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT514)");
    check_field_offset(lv, fa, 0, "STT514.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT514.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT514, STT514)
//============================================================================


struct  STT524  {
  void *fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT524) C1{ Fp Fs:0 FL}



static void Test_STT524()
{
  {
    init_simple_test("STT524");
    static STRUCT_IF_C STT524 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT524)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT524)");
    check_field_offset(lv, fa, 0, "STT524.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT524.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT524, STT524)
//============================================================================


struct  STT534  {
  void *fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT534) C1{ Fp Fi:0 FL}



static void Test_STT534()
{
  {
    init_simple_test("STT534");
    static STRUCT_IF_C STT534 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT534)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT534)");
    check_field_offset(lv, fa, 0, "STT534.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT534.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT534, STT534)
//============================================================================


struct  STT544  {
  void *fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT544) C1{ Fp FL:0 FL}



static void Test_STT544()
{
  {
    init_simple_test("STT544");
    static STRUCT_IF_C STT544 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT544)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT544)");
    check_field_offset(lv, fa, 0, "STT544.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT544.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT544, STT544)
//============================================================================


struct  STT554  {
  void *fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT554) C1{ Fp Fc:3 FL}



static void Test_STT554()
{
  {
    init_simple_test("STT554");
    static STRUCT_IF_C STT554 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT554)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT554)");
    check_field_offset(lv, fa, 0, "STT554.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT554.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT554, STT554)
//============================================================================


struct  STT564  {
  void *fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT564) C1{ Fp Fs:3 FL}



static void Test_STT564()
{
  {
    init_simple_test("STT564");
    static STRUCT_IF_C STT564 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT564)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT564)");
    check_field_offset(lv, fa, 0, "STT564.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT564.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT564, STT564)
//============================================================================


struct  STT574  {
  void *fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT574) C1{ Fp Fi:3 FL}



static void Test_STT574()
{
  {
    init_simple_test("STT574");
    static STRUCT_IF_C STT574 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT574)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT574)");
    check_field_offset(lv, fa, 0, "STT574.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT574.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT574, STT574)
//============================================================================


struct  STT584  {
  void *fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT584) C1{ Fp FL:3 FL}



static void Test_STT584()
{
  {
    init_simple_test("STT584");
    static STRUCT_IF_C STT584 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT584)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT584)");
    check_field_offset(lv, fa, 0, "STT584.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT584.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT584, STT584)
//============================================================================


struct  STT594  {
  void *fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT594) C1{ Fp Fs:8 FL}



static void Test_STT594()
{
  {
    init_simple_test("STT594");
    static STRUCT_IF_C STT594 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT594)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT594)");
    check_field_offset(lv, fa, 0, "STT594.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT594.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT594, STT594)
//============================================================================


struct  STT5104  {
  void *fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT5104) C1{ Fp Fi:8 FL}



static void Test_STT5104()
{
  {
    init_simple_test("STT5104");
    static STRUCT_IF_C STT5104 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5104)");
    check_field_offset(lv, fa, 0, "STT5104.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5104, STT5104)
//============================================================================


struct  STT5114  {
  void *fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT5114) C1{ Fp FL:8 FL}



static void Test_STT5114()
{
  {
    init_simple_test("STT5114");
    static STRUCT_IF_C STT5114 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5114)");
    check_field_offset(lv, fa, 0, "STT5114.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5114, STT5114)
//============================================================================


struct  STT5124  {
  void *fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT5124) C1{ Fp Fi:18 FL}



static void Test_STT5124()
{
  {
    init_simple_test("STT5124");
    static STRUCT_IF_C STT5124 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5124)");
    check_field_offset(lv, fa, 0, "STT5124.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5124, STT5124)
//============================================================================


struct  STT5134  {
  void *fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT5134) C1{ Fp FL:18 FL}



static void Test_STT5134()
{
  {
    init_simple_test("STT5134");
    static STRUCT_IF_C STT5134 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5134)");
    check_field_offset(lv, fa, 0, "STT5134.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5134, STT5134)
//============================================================================


struct  STT5144  {
  void *fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT5144) C1{ Fp FL:48 FL}



static void Test_STT5144()
{
  {
    init_simple_test("STT5144");
    static STRUCT_IF_C STT5144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5144)");
    check_field_offset(lv, fa, 0, "STT5144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5144, STT5144)
//============================================================================


struct  STT5154  {
  void *fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT5154) C1{ Fp Fc:3 FL}



static void Test_STT5154()
{
  {
    init_simple_test("STT5154");
    static STRUCT_IF_C STT5154 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5154)");
    check_field_offset(lv, fa, 0, "STT5154.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5154");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5154");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5154, STT5154)
//============================================================================


struct  STT5164  {
  void *fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT5164) C1{ Fp Fs:3 FL}



static void Test_STT5164()
{
  {
    init_simple_test("STT5164");
    static STRUCT_IF_C STT5164 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5164)");
    check_field_offset(lv, fa, 0, "STT5164.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5164");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5164");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5164, STT5164)
//============================================================================


struct  STT5174  {
  void *fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT5174) C1{ Fp Fi:3 FL}



static void Test_STT5174()
{
  {
    init_simple_test("STT5174");
    static STRUCT_IF_C STT5174 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5174)");
    check_field_offset(lv, fa, 0, "STT5174.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5174");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5174");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5174, STT5174)
//============================================================================


struct  STT5184  {
  void *fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT5184) C1{ Fp FL:3 FL}



static void Test_STT5184()
{
  {
    init_simple_test("STT5184");
    static STRUCT_IF_C STT5184 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5184)");
    check_field_offset(lv, fa, 0, "STT5184.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5184");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5184");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5184, STT5184)
//============================================================================


struct  STT5194  {
  void *fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT5194) C1{ Fp Fs:8 FL}



static void Test_STT5194()
{
  {
    init_simple_test("STT5194");
    static STRUCT_IF_C STT5194 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5194)");
    check_field_offset(lv, fa, 0, "STT5194.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5194");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5194");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5194, STT5194)
//============================================================================


struct  STT5204  {
  void *fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT5204) C1{ Fp Fi:8 FL}



static void Test_STT5204()
{
  {
    init_simple_test("STT5204");
    static STRUCT_IF_C STT5204 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5204)");
    check_field_offset(lv, fa, 0, "STT5204.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5204");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5204");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5204, STT5204)
//============================================================================


struct  STT5214  {
  void *fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT5214) C1{ Fp FL:8 FL}



static void Test_STT5214()
{
  {
    init_simple_test("STT5214");
    static STRUCT_IF_C STT5214 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5214)");
    check_field_offset(lv, fa, 0, "STT5214.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5214");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5214");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5214, STT5214)
//============================================================================


struct  STT5224  {
  void *fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT5224) C1{ Fp Fi:18 FL}



static void Test_STT5224()
{
  {
    init_simple_test("STT5224");
    static STRUCT_IF_C STT5224 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5224)");
    check_field_offset(lv, fa, 0, "STT5224.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5224");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5224");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5224, STT5224)
//============================================================================


struct  STT5234  {
  void *fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT5234) C1{ Fp FL:18 FL}



static void Test_STT5234()
{
  {
    init_simple_test("STT5234");
    static STRUCT_IF_C STT5234 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5234)");
    check_field_offset(lv, fa, 0, "STT5234.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5234");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5234");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5234, STT5234)
//============================================================================


struct  STT5244  {
  void *fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT5244) C1{ Fp FL:48 FL}



static void Test_STT5244()
{
  {
    init_simple_test("STT5244");
    static STRUCT_IF_C STT5244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5244)");
    check_field_offset(lv, fa, 0, "STT5244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5244, STT5244)
//============================================================================


struct  STT515  {
  void *fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT515) C1{ Fp Fc:0 Fp}



static void Test_STT515()
{
  {
    init_simple_test("STT515");
    static STRUCT_IF_C STT515 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT515)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT515)");
    check_field_offset(lv, fa, 0, "STT515.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT515.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT515, STT515)
//============================================================================


struct  STT525  {
  void *fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT525) C1{ Fp Fs:0 Fp}



static void Test_STT525()
{
  {
    init_simple_test("STT525");
    static STRUCT_IF_C STT525 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT525)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT525)");
    check_field_offset(lv, fa, 0, "STT525.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT525.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT525, STT525)
//============================================================================


struct  STT535  {
  void *fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT535) C1{ Fp Fi:0 Fp}



static void Test_STT535()
{
  {
    init_simple_test("STT535");
    static STRUCT_IF_C STT535 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT535)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT535)");
    check_field_offset(lv, fa, 0, "STT535.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT535.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT535, STT535)
//============================================================================


struct  STT545  {
  void *fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT545) C1{ Fp FL:0 Fp}



static void Test_STT545()
{
  {
    init_simple_test("STT545");
    static STRUCT_IF_C STT545 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT545)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT545)");
    check_field_offset(lv, fa, 0, "STT545.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT545.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT545, STT545)
//============================================================================


struct  STT555  {
  void *fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT555) C1{ Fp Fc:3 Fp}



static void Test_STT555()
{
  {
    init_simple_test("STT555");
    static STRUCT_IF_C STT555 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT555)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT555)");
    check_field_offset(lv, fa, 0, "STT555.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT555.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT555, STT555)
//============================================================================


struct  STT565  {
  void *fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT565) C1{ Fp Fs:3 Fp}



static void Test_STT565()
{
  {
    init_simple_test("STT565");
    static STRUCT_IF_C STT565 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT565)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT565)");
    check_field_offset(lv, fa, 0, "STT565.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT565.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT565, STT565)
//============================================================================


struct  STT575  {
  void *fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT575) C1{ Fp Fi:3 Fp}



static void Test_STT575()
{
  {
    init_simple_test("STT575");
    static STRUCT_IF_C STT575 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT575)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT575)");
    check_field_offset(lv, fa, 0, "STT575.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT575.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT575, STT575)
//============================================================================


struct  STT585  {
  void *fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT585) C1{ Fp FL:3 Fp}



static void Test_STT585()
{
  {
    init_simple_test("STT585");
    static STRUCT_IF_C STT585 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT585)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT585)");
    check_field_offset(lv, fa, 0, "STT585.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT585.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT585, STT585)
//============================================================================


struct  STT595  {
  void *fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT595) C1{ Fp Fs:8 Fp}



static void Test_STT595()
{
  {
    init_simple_test("STT595");
    static STRUCT_IF_C STT595 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT595)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT595)");
    check_field_offset(lv, fa, 0, "STT595.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT595.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT595, STT595)
//============================================================================


struct  STT5105  {
  void *fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT5105) C1{ Fp Fi:8 Fp}



static void Test_STT5105()
{
  {
    init_simple_test("STT5105");
    static STRUCT_IF_C STT5105 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5105)");
    check_field_offset(lv, fa, 0, "STT5105.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5105, STT5105)
//============================================================================


struct  STT5115  {
  void *fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT5115) C1{ Fp FL:8 Fp}



static void Test_STT5115()
{
  {
    init_simple_test("STT5115");
    static STRUCT_IF_C STT5115 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5115)");
    check_field_offset(lv, fa, 0, "STT5115.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5115, STT5115)
//============================================================================


struct  STT5125  {
  void *fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT5125) C1{ Fp Fi:18 Fp}



static void Test_STT5125()
{
  {
    init_simple_test("STT5125");
    static STRUCT_IF_C STT5125 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5125)");
    check_field_offset(lv, fa, 0, "STT5125.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5125, STT5125)
//============================================================================


struct  STT5135  {
  void *fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT5135) C1{ Fp FL:18 Fp}



static void Test_STT5135()
{
  {
    init_simple_test("STT5135");
    static STRUCT_IF_C STT5135 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5135)");
    check_field_offset(lv, fa, 0, "STT5135.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5135, STT5135)
//============================================================================


struct  STT5145  {
  void *fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT5145) C1{ Fp FL:48 Fp}



static void Test_STT5145()
{
  {
    init_simple_test("STT5145");
    static STRUCT_IF_C STT5145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5145)");
    check_field_offset(lv, fa, 0, "STT5145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5145, STT5145)
//============================================================================


struct  STT5155  {
  void *fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT5155) C1{ Fp Fc:3 Fp}



static void Test_STT5155()
{
  {
    init_simple_test("STT5155");
    static STRUCT_IF_C STT5155 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5155)");
    check_field_offset(lv, fa, 0, "STT5155.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5155");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5155");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5155, STT5155)
//============================================================================


struct  STT5165  {
  void *fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT5165) C1{ Fp Fs:3 Fp}



static void Test_STT5165()
{
  {
    init_simple_test("STT5165");
    static STRUCT_IF_C STT5165 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5165)");
    check_field_offset(lv, fa, 0, "STT5165.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5165");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5165");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5165, STT5165)
//============================================================================


struct  STT5175  {
  void *fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT5175) C1{ Fp Fi:3 Fp}



static void Test_STT5175()
{
  {
    init_simple_test("STT5175");
    static STRUCT_IF_C STT5175 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5175)");
    check_field_offset(lv, fa, 0, "STT5175.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5175");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5175");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5175, STT5175)
//============================================================================


struct  STT5185  {
  void *fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT5185) C1{ Fp FL:3 Fp}



static void Test_STT5185()
{
  {
    init_simple_test("STT5185");
    static STRUCT_IF_C STT5185 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5185)");
    check_field_offset(lv, fa, 0, "STT5185.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5185");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5185");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5185, STT5185)
//============================================================================


struct  STT5195  {
  void *fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT5195) C1{ Fp Fs:8 Fp}



static void Test_STT5195()
{
  {
    init_simple_test("STT5195");
    static STRUCT_IF_C STT5195 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5195)");
    check_field_offset(lv, fa, 0, "STT5195.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5195");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5195");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5195, STT5195)
//============================================================================


struct  STT5205  {
  void *fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT5205) C1{ Fp Fi:8 Fp}



static void Test_STT5205()
{
  {
    init_simple_test("STT5205");
    static STRUCT_IF_C STT5205 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5205)");
    check_field_offset(lv, fa, 0, "STT5205.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5205");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5205");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5205, STT5205)
//============================================================================


struct  STT5215  {
  void *fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT5215) C1{ Fp FL:8 Fp}



static void Test_STT5215()
{
  {
    init_simple_test("STT5215");
    static STRUCT_IF_C STT5215 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5215)");
    check_field_offset(lv, fa, 0, "STT5215.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5215");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5215");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5215, STT5215)
//============================================================================


struct  STT5225  {
  void *fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT5225) C1{ Fp Fi:18 Fp}



static void Test_STT5225()
{
  {
    init_simple_test("STT5225");
    static STRUCT_IF_C STT5225 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5225)");
    check_field_offset(lv, fa, 0, "STT5225.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5225");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5225");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5225, STT5225)
//============================================================================


struct  STT5235  {
  void *fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT5235) C1{ Fp FL:18 Fp}



static void Test_STT5235()
{
  {
    init_simple_test("STT5235");
    static STRUCT_IF_C STT5235 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5235)");
    check_field_offset(lv, fa, 0, "STT5235.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5235");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5235");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5235, STT5235)
//============================================================================


struct  STT5245  {
  void *fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT5245) C1{ Fp FL:48 Fp}



static void Test_STT5245()
{
  {
    init_simple_test("STT5245");
    static STRUCT_IF_C STT5245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5245)");
    check_field_offset(lv, fa, 0, "STT5245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5245, STT5245)
//============================================================================


struct  STT516  {
  void *fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT516) C1{ Fp Fc:0 Fi}



static void Test_STT516()
{
  {
    init_simple_test("STT516");
    static STRUCT_IF_C STT516 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT516)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT516)");
    check_field_offset(lv, fa, 0, "STT516.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT516.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT516, STT516)
//============================================================================


struct  STT526  {
  void *fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT526) C1{ Fp Fs:0 Fi}



static void Test_STT526()
{
  {
    init_simple_test("STT526");
    static STRUCT_IF_C STT526 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT526)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT526)");
    check_field_offset(lv, fa, 0, "STT526.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT526.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT526, STT526)
//============================================================================


struct  STT536  {
  void *fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT536) C1{ Fp Fi:0 Fi}



static void Test_STT536()
{
  {
    init_simple_test("STT536");
    static STRUCT_IF_C STT536 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT536)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT536)");
    check_field_offset(lv, fa, 0, "STT536.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT536.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT536, STT536)
//============================================================================


struct  STT546  {
  void *fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT546) C1{ Fp FL:0 Fi}



static void Test_STT546()
{
  {
    init_simple_test("STT546");
    static STRUCT_IF_C STT546 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT546)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT546)");
    check_field_offset(lv, fa, 0, "STT546.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT546.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT546, STT546)
//============================================================================


struct  STT556  {
  void *fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT556) C1{ Fp Fc:3 Fi}



static void Test_STT556()
{
  {
    init_simple_test("STT556");
    static STRUCT_IF_C STT556 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT556)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT556)");
    check_field_offset(lv, fa, 0, "STT556.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT556.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT556, STT556)
//============================================================================


struct  STT566  {
  void *fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT566) C1{ Fp Fs:3 Fi}



static void Test_STT566()
{
  {
    init_simple_test("STT566");
    static STRUCT_IF_C STT566 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT566)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT566)");
    check_field_offset(lv, fa, 0, "STT566.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT566.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT566, STT566)
//============================================================================


struct  STT576  {
  void *fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT576) C1{ Fp Fi:3 Fi}



static void Test_STT576()
{
  {
    init_simple_test("STT576");
    static STRUCT_IF_C STT576 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT576)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT576)");
    check_field_offset(lv, fa, 0, "STT576.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT576.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT576, STT576)
//============================================================================


struct  STT586  {
  void *fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT586) C1{ Fp FL:3 Fi}



static void Test_STT586()
{
  {
    init_simple_test("STT586");
    static STRUCT_IF_C STT586 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT586)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT586)");
    check_field_offset(lv, fa, 0, "STT586.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT586.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT586, STT586)
//============================================================================


struct  STT596  {
  void *fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT596) C1{ Fp Fs:8 Fi}



static void Test_STT596()
{
  {
    init_simple_test("STT596");
    static STRUCT_IF_C STT596 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT596)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT596)");
    check_field_offset(lv, fa, 0, "STT596.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT596.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT596, STT596)
//============================================================================


struct  STT5106  {
  void *fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT5106) C1{ Fp Fi:8 Fi}



static void Test_STT5106()
{
  {
    init_simple_test("STT5106");
    static STRUCT_IF_C STT5106 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5106)");
    check_field_offset(lv, fa, 0, "STT5106.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5106, STT5106)
//============================================================================


struct  STT5116  {
  void *fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT5116) C1{ Fp FL:8 Fi}



static void Test_STT5116()
{
  {
    init_simple_test("STT5116");
    static STRUCT_IF_C STT5116 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5116)");
    check_field_offset(lv, fa, 0, "STT5116.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5116, STT5116)
//============================================================================


struct  STT5126  {
  void *fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT5126) C1{ Fp Fi:18 Fi}



static void Test_STT5126()
{
  {
    init_simple_test("STT5126");
    static STRUCT_IF_C STT5126 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5126)");
    check_field_offset(lv, fa, 0, "STT5126.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5126, STT5126)
//============================================================================


struct  STT5136  {
  void *fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT5136) C1{ Fp FL:18 Fi}



static void Test_STT5136()
{
  {
    init_simple_test("STT5136");
    static STRUCT_IF_C STT5136 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5136)");
    check_field_offset(lv, fa, 0, "STT5136.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5136, STT5136)
//============================================================================


struct  STT5146  {
  void *fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT5146) C1{ Fp FL:48 Fi}



static void Test_STT5146()
{
  {
    init_simple_test("STT5146");
    static STRUCT_IF_C STT5146 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5146)");
    check_field_offset(lv, fa, 0, "STT5146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5146, STT5146)
//============================================================================


struct  STT5156  {
  void *fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT5156) C1{ Fp Fc:3 Fi}



static void Test_STT5156()
{
  {
    init_simple_test("STT5156");
    static STRUCT_IF_C STT5156 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5156)");
    check_field_offset(lv, fa, 0, "STT5156.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5156");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5156");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5156, STT5156)
//============================================================================


struct  STT5166  {
  void *fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT5166) C1{ Fp Fs:3 Fi}



static void Test_STT5166()
{
  {
    init_simple_test("STT5166");
    static STRUCT_IF_C STT5166 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5166)");
    check_field_offset(lv, fa, 0, "STT5166.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5166");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5166");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5166, STT5166)
//============================================================================


struct  STT5176  {
  void *fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT5176) C1{ Fp Fi:3 Fi}



static void Test_STT5176()
{
  {
    init_simple_test("STT5176");
    static STRUCT_IF_C STT5176 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5176)");
    check_field_offset(lv, fa, 0, "STT5176.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5176");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5176");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5176, STT5176)
//============================================================================


struct  STT5186  {
  void *fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT5186) C1{ Fp FL:3 Fi}



static void Test_STT5186()
{
  {
    init_simple_test("STT5186");
    static STRUCT_IF_C STT5186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5186)");
    check_field_offset(lv, fa, 0, "STT5186.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5186");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5186");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5186, STT5186)
//============================================================================


struct  STT5196  {
  void *fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT5196) C1{ Fp Fs:8 Fi}



static void Test_STT5196()
{
  {
    init_simple_test("STT5196");
    static STRUCT_IF_C STT5196 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5196)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5196)");
    check_field_offset(lv, fa, 0, "STT5196.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5196");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5196");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5196, STT5196)
//============================================================================


struct  STT5206  {
  void *fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT5206) C1{ Fp Fi:8 Fi}



static void Test_STT5206()
{
  {
    init_simple_test("STT5206");
    static STRUCT_IF_C STT5206 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5206)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5206)");
    check_field_offset(lv, fa, 0, "STT5206.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5206");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5206");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5206, STT5206)
//============================================================================


struct  STT5216  {
  void *fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT5216) C1{ Fp FL:8 Fi}



static void Test_STT5216()
{
  {
    init_simple_test("STT5216");
    static STRUCT_IF_C STT5216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5216)");
    check_field_offset(lv, fa, 0, "STT5216.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5216");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5216");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5216, STT5216)
//============================================================================


struct  STT5226  {
  void *fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT5226) C1{ Fp Fi:18 Fi}



static void Test_STT5226()
{
  {
    init_simple_test("STT5226");
    static STRUCT_IF_C STT5226 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5226)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5226)");
    check_field_offset(lv, fa, 0, "STT5226.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5226");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5226");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5226, STT5226)
//============================================================================


struct  STT5236  {
  void *fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT5236) C1{ Fp FL:18 Fi}



static void Test_STT5236()
{
  {
    init_simple_test("STT5236");
    static STRUCT_IF_C STT5236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5236)");
    check_field_offset(lv, fa, 0, "STT5236.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5236");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5236");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5236, STT5236)
//============================================================================


struct  STT5246  {
  void *fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT5246) C1{ Fp FL:48 Fi}



static void Test_STT5246()
{
  {
    init_simple_test("STT5246");
    static STRUCT_IF_C STT5246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5246)");
    check_field_offset(lv, fa, 0, "STT5246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5246, STT5246)
//============================================================================


struct  STT517  {
  void *fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT517) C1{ Fp Fc:0 FL}



static void Test_STT517()
{
  {
    init_simple_test("STT517");
    static STRUCT_IF_C STT517 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT517)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT517)");
    check_field_offset(lv, fa, 0, "STT517.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT517.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT517, STT517)
//============================================================================


struct  STT527  {
  void *fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT527) C1{ Fp Fs:0 FL}



static void Test_STT527()
{
  {
    init_simple_test("STT527");
    static STRUCT_IF_C STT527 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT527)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT527)");
    check_field_offset(lv, fa, 0, "STT527.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT527.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT527, STT527)
//============================================================================


struct  STT537  {
  void *fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT537) C1{ Fp Fi:0 FL}



static void Test_STT537()
{
  {
    init_simple_test("STT537");
    static STRUCT_IF_C STT537 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT537)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT537)");
    check_field_offset(lv, fa, 0, "STT537.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT537.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT537, STT537)
//============================================================================


struct  STT547  {
  void *fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT547) C1{ Fp FL:0 FL}



static void Test_STT547()
{
  {
    init_simple_test("STT547");
    static STRUCT_IF_C STT547 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT547)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT547)");
    check_field_offset(lv, fa, 0, "STT547.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT547.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT547, STT547)
//============================================================================


struct  STT557  {
  void *fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT557) C1{ Fp Fc:3 FL}



static void Test_STT557()
{
  {
    init_simple_test("STT557");
    static STRUCT_IF_C STT557 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT557)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT557)");
    check_field_offset(lv, fa, 0, "STT557.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT557.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT557, STT557)
//============================================================================


struct  STT567  {
  void *fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT567) C1{ Fp Fs:3 FL}



static void Test_STT567()
{
  {
    init_simple_test("STT567");
    static STRUCT_IF_C STT567 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT567)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT567)");
    check_field_offset(lv, fa, 0, "STT567.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT567.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT567, STT567)
//============================================================================


struct  STT577  {
  void *fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT577) C1{ Fp Fi:3 FL}



static void Test_STT577()
{
  {
    init_simple_test("STT577");
    static STRUCT_IF_C STT577 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT577)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT577)");
    check_field_offset(lv, fa, 0, "STT577.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT577.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT577, STT577)
//============================================================================


struct  STT587  {
  void *fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT587) C1{ Fp FL:3 FL}



static void Test_STT587()
{
  {
    init_simple_test("STT587");
    static STRUCT_IF_C STT587 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT587)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT587)");
    check_field_offset(lv, fa, 0, "STT587.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT587.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT587, STT587)
//============================================================================


struct  STT597  {
  void *fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT597) C1{ Fp Fs:8 FL}



static void Test_STT597()
{
  {
    init_simple_test("STT597");
    static STRUCT_IF_C STT597 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT597)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT597)");
    check_field_offset(lv, fa, 0, "STT597.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT597.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT597, STT597)
//============================================================================


struct  STT5107  {
  void *fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT5107) C1{ Fp Fi:8 FL}



static void Test_STT5107()
{
  {
    init_simple_test("STT5107");
    static STRUCT_IF_C STT5107 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5107)");
    check_field_offset(lv, fa, 0, "STT5107.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5107, STT5107)
//============================================================================


struct  STT5117  {
  void *fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT5117) C1{ Fp FL:8 FL}



static void Test_STT5117()
{
  {
    init_simple_test("STT5117");
    static STRUCT_IF_C STT5117 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5117)");
    check_field_offset(lv, fa, 0, "STT5117.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5117, STT5117)
//============================================================================


struct  STT5127  {
  void *fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT5127) C1{ Fp Fi:18 FL}



static void Test_STT5127()
{
  {
    init_simple_test("STT5127");
    static STRUCT_IF_C STT5127 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5127)");
    check_field_offset(lv, fa, 0, "STT5127.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5127, STT5127)
//============================================================================


struct  STT5137  {
  void *fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT5137) C1{ Fp FL:18 FL}



static void Test_STT5137()
{
  {
    init_simple_test("STT5137");
    static STRUCT_IF_C STT5137 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5137)");
    check_field_offset(lv, fa, 0, "STT5137.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5137, STT5137)
//============================================================================


struct  STT5147  {
  void *fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT5147) C1{ Fp FL:48 FL}



static void Test_STT5147()
{
  {
    init_simple_test("STT5147");
    static STRUCT_IF_C STT5147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5147)");
    check_field_offset(lv, fa, 0, "STT5147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5147, STT5147)
//============================================================================


struct  STT5157  {
  void *fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT5157) C1{ Fp Fc:3 FL}



static void Test_STT5157()
{
  {
    init_simple_test("STT5157");
    static STRUCT_IF_C STT5157 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5157)");
    check_field_offset(lv, fa, 0, "STT5157.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5157");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5157");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5157, STT5157)
//============================================================================


struct  STT5167  {
  void *fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT5167) C1{ Fp Fs:3 FL}



static void Test_STT5167()
{
  {
    init_simple_test("STT5167");
    static STRUCT_IF_C STT5167 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5167)");
    check_field_offset(lv, fa, 0, "STT5167.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5167");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5167");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5167, STT5167)
//============================================================================


struct  STT5177  {
  void *fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT5177) C1{ Fp Fi:3 FL}



static void Test_STT5177()
{
  {
    init_simple_test("STT5177");
    static STRUCT_IF_C STT5177 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5177)");
    check_field_offset(lv, fa, 0, "STT5177.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5177");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5177");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5177, STT5177)
//============================================================================


struct  STT5187  {
  void *fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT5187) C1{ Fp FL:3 FL}



static void Test_STT5187()
{
  {
    init_simple_test("STT5187");
    static STRUCT_IF_C STT5187 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5187)");
    check_field_offset(lv, fa, 0, "STT5187.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5187");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5187");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5187, STT5187)
//============================================================================


struct  STT5197  {
  void *fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT5197) C1{ Fp Fs:8 FL}



static void Test_STT5197()
{
  {
    init_simple_test("STT5197");
    static STRUCT_IF_C STT5197 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5197)");
    check_field_offset(lv, fa, 0, "STT5197.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5197");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5197");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5197, STT5197)
//============================================================================


struct  STT5207  {
  void *fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT5207) C1{ Fp Fi:8 FL}



static void Test_STT5207()
{
  {
    init_simple_test("STT5207");
    static STRUCT_IF_C STT5207 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5207)");
    check_field_offset(lv, fa, 0, "STT5207.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5207");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5207");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5207, STT5207)
//============================================================================


struct  STT5217  {
  void *fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT5217) C1{ Fp FL:8 FL}



static void Test_STT5217()
{
  {
    init_simple_test("STT5217");
    static STRUCT_IF_C STT5217 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5217)");
    check_field_offset(lv, fa, 0, "STT5217.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5217");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5217");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5217, STT5217)
//============================================================================


struct  STT5227  {
  void *fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT5227) C1{ Fp Fi:18 FL}



static void Test_STT5227()
{
  {
    init_simple_test("STT5227");
    static STRUCT_IF_C STT5227 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5227)");
    check_field_offset(lv, fa, 0, "STT5227.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5227");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5227");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5227, STT5227)
//============================================================================


struct  STT5237  {
  void *fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT5237) C1{ Fp FL:18 FL}



static void Test_STT5237()
{
  {
    init_simple_test("STT5237");
    static STRUCT_IF_C STT5237 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5237)");
    check_field_offset(lv, fa, 0, "STT5237.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5237");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5237");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5237, STT5237)
//============================================================================


struct  STT5247  {
  void *fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT5247) C1{ Fp FL:48 FL}



static void Test_STT5247()
{
  {
    init_simple_test("STT5247");
    static STRUCT_IF_C STT5247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5247)");
    check_field_offset(lv, fa, 0, "STT5247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5247, STT5247)
//============================================================================


struct  STT518  {
  void *fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT518) C1{ Fp Fc:0 FD}



static void Test_STT518()
{
  {
    init_simple_test("STT518");
    static STRUCT_IF_C STT518 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT518)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT518)");
    check_field_offset(lv, fa, 0, "STT518.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT518.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT518, STT518)
//============================================================================


struct  STT528  {
  void *fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT528) C1{ Fp Fs:0 FD}



static void Test_STT528()
{
  {
    init_simple_test("STT528");
    static STRUCT_IF_C STT528 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT528)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT528)");
    check_field_offset(lv, fa, 0, "STT528.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT528.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT528, STT528)
//============================================================================


struct  STT538  {
  void *fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT538) C1{ Fp Fi:0 FD}



static void Test_STT538()
{
  {
    init_simple_test("STT538");
    static STRUCT_IF_C STT538 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT538)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT538)");
    check_field_offset(lv, fa, 0, "STT538.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT538.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT538, STT538)
//============================================================================


struct  STT548  {
  void *fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT548) C1{ Fp FL:0 FD}



static void Test_STT548()
{
  {
    init_simple_test("STT548");
    static STRUCT_IF_C STT548 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT548)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT548)");
    check_field_offset(lv, fa, 0, "STT548.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT548.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT548, STT548)
//============================================================================


struct  STT558  {
  void *fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT558) C1{ Fp Fc:3 FD}



static void Test_STT558()
{
  {
    init_simple_test("STT558");
    static STRUCT_IF_C STT558 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT558)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT558)");
    check_field_offset(lv, fa, 0, "STT558.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT558.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT558, STT558)
//============================================================================


struct  STT568  {
  void *fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT568) C1{ Fp Fs:3 FD}



static void Test_STT568()
{
  {
    init_simple_test("STT568");
    static STRUCT_IF_C STT568 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT568)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT568)");
    check_field_offset(lv, fa, 0, "STT568.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT568.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT568, STT568)
//============================================================================


struct  STT578  {
  void *fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT578) C1{ Fp Fi:3 FD}



static void Test_STT578()
{
  {
    init_simple_test("STT578");
    static STRUCT_IF_C STT578 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT578)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT578)");
    check_field_offset(lv, fa, 0, "STT578.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT578.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT578, STT578)
//============================================================================


struct  STT588  {
  void *fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT588) C1{ Fp FL:3 FD}



static void Test_STT588()
{
  {
    init_simple_test("STT588");
    static STRUCT_IF_C STT588 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT588)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT588)");
    check_field_offset(lv, fa, 0, "STT588.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT588.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT588, STT588)
//============================================================================


struct  STT598  {
  void *fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT598) C1{ Fp Fs:8 FD}



static void Test_STT598()
{
  {
    init_simple_test("STT598");
    static STRUCT_IF_C STT598 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT598)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT598)");
    check_field_offset(lv, fa, 0, "STT598.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT598.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT598, STT598)
//============================================================================


struct  STT5108  {
  void *fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT5108) C1{ Fp Fi:8 FD}



static void Test_STT5108()
{
  {
    init_simple_test("STT5108");
    static STRUCT_IF_C STT5108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5108)");
    check_field_offset(lv, fa, 0, "STT5108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5108, STT5108)
//============================================================================


struct  STT5118  {
  void *fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT5118) C1{ Fp FL:8 FD}



static void Test_STT5118()
{
  {
    init_simple_test("STT5118");
    static STRUCT_IF_C STT5118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5118)");
    check_field_offset(lv, fa, 0, "STT5118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5118, STT5118)
//============================================================================


struct  STT5128  {
  void *fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT5128) C1{ Fp Fi:18 FD}



static void Test_STT5128()
{
  {
    init_simple_test("STT5128");
    static STRUCT_IF_C STT5128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5128)");
    check_field_offset(lv, fa, 0, "STT5128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5128, STT5128)
//============================================================================


struct  STT5138  {
  void *fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT5138) C1{ Fp FL:18 FD}



static void Test_STT5138()
{
  {
    init_simple_test("STT5138");
    static STRUCT_IF_C STT5138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5138)");
    check_field_offset(lv, fa, 0, "STT5138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5138, STT5138)
//============================================================================


struct  STT5148  {
  void *fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT5148) C1{ Fp FL:48 FD}



static void Test_STT5148()
{
  {
    init_simple_test("STT5148");
    static STRUCT_IF_C STT5148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT5148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5148)");
    check_field_offset(lv, fa, 0, "STT5148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5148, STT5148)
//============================================================================


struct  STT5158  {
  void *fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT5158) C1{ Fp Fc:3 FD}



static void Test_STT5158()
{
  {
    init_simple_test("STT5158");
    static STRUCT_IF_C STT5158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5158)");
    check_field_offset(lv, fa, 0, "STT5158.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5158");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5158, STT5158)
//============================================================================


struct  STT5168  {
  void *fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT5168) C1{ Fp Fs:3 FD}



static void Test_STT5168()
{
  {
    init_simple_test("STT5168");
    static STRUCT_IF_C STT5168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5168)");
    check_field_offset(lv, fa, 0, "STT5168.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5168");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5168, STT5168)
//============================================================================


struct  STT5178  {
  void *fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT5178) C1{ Fp Fi:3 FD}



static void Test_STT5178()
{
  {
    init_simple_test("STT5178");
    static STRUCT_IF_C STT5178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5178)");
    check_field_offset(lv, fa, 0, "STT5178.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5178");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5178, STT5178)
//============================================================================


struct  STT5188  {
  void *fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT5188) C1{ Fp FL:3 FD}



static void Test_STT5188()
{
  {
    init_simple_test("STT5188");
    static STRUCT_IF_C STT5188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5188)");
    check_field_offset(lv, fa, 0, "STT5188.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5188");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5188, STT5188)
//============================================================================


struct  STT5198  {
  void *fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT5198) C1{ Fp Fs:8 FD}



static void Test_STT5198()
{
  {
    init_simple_test("STT5198");
    static STRUCT_IF_C STT5198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5198)");
    check_field_offset(lv, fa, 0, "STT5198.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5198");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5198, STT5198)
//============================================================================


struct  STT5208  {
  void *fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT5208) C1{ Fp Fi:8 FD}



static void Test_STT5208()
{
  {
    init_simple_test("STT5208");
    static STRUCT_IF_C STT5208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5208)");
    check_field_offset(lv, fa, 0, "STT5208.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5208");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5208, STT5208)
//============================================================================


struct  STT5218  {
  void *fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT5218) C1{ Fp FL:8 FD}



static void Test_STT5218()
{
  {
    init_simple_test("STT5218");
    static STRUCT_IF_C STT5218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5218)");
    check_field_offset(lv, fa, 0, "STT5218.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5218");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5218, STT5218)
//============================================================================


struct  STT5228  {
  void *fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT5228) C1{ Fp Fi:18 FD}



static void Test_STT5228()
{
  {
    init_simple_test("STT5228");
    static STRUCT_IF_C STT5228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5228)");
    check_field_offset(lv, fa, 0, "STT5228.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5228");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5228, STT5228)
//============================================================================


struct  STT5238  {
  void *fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT5238) C1{ Fp FL:18 FD}



static void Test_STT5238()
{
  {
    init_simple_test("STT5238");
    static STRUCT_IF_C STT5238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5238)");
    check_field_offset(lv, fa, 0, "STT5238.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5238");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5238.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5238, STT5238)
//============================================================================


struct  STT5248  {
  void *fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT5248) C1{ Fp FL:48 FD}



static void Test_STT5248()
{
  {
    init_simple_test("STT5248");
    static STRUCT_IF_C STT5248 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT5248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5248)");
    check_field_offset(lv, fa, 0, "STT5248.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5248");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5248");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5248.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5248, STT5248)
//============================================================================


struct  STT519  {
  void *fa;
  unsigned char  :0;
};
//SIG(1 STT519) C1{ Fp Fc:0}



static void Test_STT519()
{
  {
    init_simple_test("STT519");
    static STRUCT_IF_C STT519 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT519)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT519)");
    check_field_offset(lv, fa, 0, "STT519.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT519, STT519)
//============================================================================


struct  STT529  {
  void *fa;
  unsigned short  :0;
};
//SIG(1 STT529) C1{ Fp Fs:0}



static void Test_STT529()
{
  {
    init_simple_test("STT529");
    static STRUCT_IF_C STT529 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT529)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT529)");
    check_field_offset(lv, fa, 0, "STT529.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT529, STT529)
//============================================================================


struct  STT539  {
  void *fa;
  unsigned int  :0;
};
//SIG(1 STT539) C1{ Fp Fi:0}



static void Test_STT539()
{
  {
    init_simple_test("STT539");
    static STRUCT_IF_C STT539 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT539)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT539)");
    check_field_offset(lv, fa, 0, "STT539.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT539, STT539)
//============================================================================


struct  STT549  {
  void *fa;
  __tsu64  :0;
};
//SIG(1 STT549) C1{ Fp FL:0}



static void Test_STT549()
{
  {
    init_simple_test("STT549");
    static STRUCT_IF_C STT549 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT549)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT549)");
    check_field_offset(lv, fa, 0, "STT549.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT549, STT549)
//============================================================================


struct  STT559  {
  void *fa;
  unsigned char  :3;
};
//SIG(1 STT559) C1{ Fp Fc:3}



static void Test_STT559()
{
  {
    init_simple_test("STT559");
    static STRUCT_IF_C STT559 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT559)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT559)");
    check_field_offset(lv, fa, 0, "STT559.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT559, STT559)
//============================================================================


struct  STT569  {
  void *fa;
  unsigned short  :3;
};
//SIG(1 STT569) C1{ Fp Fs:3}



static void Test_STT569()
{
  {
    init_simple_test("STT569");
    static STRUCT_IF_C STT569 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT569)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT569)");
    check_field_offset(lv, fa, 0, "STT569.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT569, STT569)
//============================================================================


struct  STT579  {
  void *fa;
  unsigned int  :3;
};
//SIG(1 STT579) C1{ Fp Fi:3}



static void Test_STT579()
{
  {
    init_simple_test("STT579");
    static STRUCT_IF_C STT579 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT579)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT579)");
    check_field_offset(lv, fa, 0, "STT579.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT579, STT579)
//============================================================================


struct  STT589  {
  void *fa;
  __tsu64  :3;
};
//SIG(1 STT589) C1{ Fp FL:3}



static void Test_STT589()
{
  {
    init_simple_test("STT589");
    static STRUCT_IF_C STT589 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT589)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT589)");
    check_field_offset(lv, fa, 0, "STT589.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT589, STT589)
//============================================================================


struct  STT599  {
  void *fa;
  unsigned short  :8;
};
//SIG(1 STT599) C1{ Fp Fs:8}



static void Test_STT599()
{
  {
    init_simple_test("STT599");
    static STRUCT_IF_C STT599 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT599)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT599)");
    check_field_offset(lv, fa, 0, "STT599.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT599, STT599)
//============================================================================


struct  STT5109  {
  void *fa;
  unsigned int  :8;
};
//SIG(1 STT5109) C1{ Fp Fi:8}



static void Test_STT5109()
{
  {
    init_simple_test("STT5109");
    static STRUCT_IF_C STT5109 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5109)");
    check_field_offset(lv, fa, 0, "STT5109.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5109, STT5109)
//============================================================================


struct  STT5119  {
  void *fa;
  __tsu64  :8;
};
//SIG(1 STT5119) C1{ Fp FL:8}



static void Test_STT5119()
{
  {
    init_simple_test("STT5119");
    static STRUCT_IF_C STT5119 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5119)");
    check_field_offset(lv, fa, 0, "STT5119.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5119, STT5119)
//============================================================================


struct  STT5129  {
  void *fa;
  unsigned int  :18;
};
//SIG(1 STT5129) C1{ Fp Fi:18}



static void Test_STT5129()
{
  {
    init_simple_test("STT5129");
    static STRUCT_IF_C STT5129 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5129)");
    check_field_offset(lv, fa, 0, "STT5129.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5129, STT5129)
//============================================================================


struct  STT5139  {
  void *fa;
  __tsu64  :18;
};
//SIG(1 STT5139) C1{ Fp FL:18}



static void Test_STT5139()
{
  {
    init_simple_test("STT5139");
    static STRUCT_IF_C STT5139 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5139)");
    check_field_offset(lv, fa, 0, "STT5139.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5139, STT5139)
//============================================================================


struct  STT5149  {
  void *fa;
  __tsu64  :48;
};
//SIG(1 STT5149) C1{ Fp FL:48}



static void Test_STT5149()
{
  {
    init_simple_test("STT5149");
    static STRUCT_IF_C STT5149 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5149)");
    check_field_offset(lv, fa, 0, "STT5149.fa");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5149, STT5149)
//============================================================================


struct  STT5159  {
  void *fa;
  unsigned char bf:3;
};
//SIG(1 STT5159) C1{ Fp Fc:3}



static void Test_STT5159()
{
  {
    init_simple_test("STT5159");
    static STRUCT_IF_C STT5159 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5159)");
    check_field_offset(lv, fa, 0, "STT5159.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5159");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5159");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5159, STT5159)
//============================================================================


struct  STT5169  {
  void *fa;
  unsigned short bf:3;
};
//SIG(1 STT5169) C1{ Fp Fs:3}



static void Test_STT5169()
{
  {
    init_simple_test("STT5169");
    static STRUCT_IF_C STT5169 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5169)");
    check_field_offset(lv, fa, 0, "STT5169.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5169");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5169");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5169, STT5169)
//============================================================================


struct  STT5179  {
  void *fa;
  unsigned int bf:3;
};
//SIG(1 STT5179) C1{ Fp Fi:3}



static void Test_STT5179()
{
  {
    init_simple_test("STT5179");
    static STRUCT_IF_C STT5179 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5179)");
    check_field_offset(lv, fa, 0, "STT5179.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5179");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5179");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5179, STT5179)
//============================================================================


struct  STT5189  {
  void *fa;
  __tsu64 bf:3;
};
//SIG(1 STT5189) C1{ Fp FL:3}



static void Test_STT5189()
{
  {
    init_simple_test("STT5189");
    static STRUCT_IF_C STT5189 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5189)");
    check_field_offset(lv, fa, 0, "STT5189.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5189");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5189");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5189, STT5189)
//============================================================================


struct  STT5199  {
  void *fa;
  unsigned short bf:8;
};
//SIG(1 STT5199) C1{ Fp Fs:8}



static void Test_STT5199()
{
  {
    init_simple_test("STT5199");
    static STRUCT_IF_C STT5199 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5199)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5199)");
    check_field_offset(lv, fa, 0, "STT5199.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5199");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5199");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5199, STT5199)
//============================================================================


struct  STT5209  {
  void *fa;
  unsigned int bf:8;
};
//SIG(1 STT5209) C1{ Fp Fi:8}



static void Test_STT5209()
{
  {
    init_simple_test("STT5209");
    static STRUCT_IF_C STT5209 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5209)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5209)");
    check_field_offset(lv, fa, 0, "STT5209.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5209");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5209");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5209, STT5209)
//============================================================================


struct  STT5219  {
  void *fa;
  __tsu64 bf:8;
};
//SIG(1 STT5219) C1{ Fp FL:8}



static void Test_STT5219()
{
  {
    init_simple_test("STT5219");
    static STRUCT_IF_C STT5219 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5219)");
    check_field_offset(lv, fa, 0, "STT5219.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5219");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5219");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5219, STT5219)
//============================================================================


struct  STT5229  {
  void *fa;
  unsigned int bf:18;
};
//SIG(1 STT5229) C1{ Fp Fi:18}



static void Test_STT5229()
{
  {
    init_simple_test("STT5229");
    static STRUCT_IF_C STT5229 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5229)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5229)");
    check_field_offset(lv, fa, 0, "STT5229.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5229");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5229");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5229, STT5229)
//============================================================================


struct  STT5239  {
  void *fa;
  __tsu64 bf:18;
};
//SIG(1 STT5239) C1{ Fp FL:18}



static void Test_STT5239()
{
  {
    init_simple_test("STT5239");
    static STRUCT_IF_C STT5239 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5239)");
    check_field_offset(lv, fa, 0, "STT5239.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5239");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5239");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5239, STT5239)
//============================================================================


struct  STT5249  {
  void *fa;
  __tsu64 bf:48;
};
//SIG(1 STT5249) C1{ Fp FL:48}



static void Test_STT5249()
{
  {
    init_simple_test("STT5249");
    static STRUCT_IF_C STT5249 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5249)");
    check_field_offset(lv, fa, 0, "STT5249.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5249");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5249");
  }
}
ARRANGE_TO_CALL_ME(Test_STT5249, STT5249)
//============================================================================


struct  STT610  {
  float fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT610) C1{ Fi Fc:0 Fc}



static void Test_STT610()
{
  {
    init_simple_test("STT610");
    static STRUCT_IF_C STT610 lv;
    check2(sizeof(lv), 8, "sizeof(STT610)");
    check2(__alignof__(lv), 4, "__alignof__(STT610)");
    check_field_offset(lv, fa, 0, "STT610.fa");
    check_field_offset(lv, fb, 4, "STT610.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT610, STT610)
//============================================================================


struct  STT620  {
  float fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT620) C1{ Fi Fs:0 Fc}



static void Test_STT620()
{
  {
    init_simple_test("STT620");
    static STRUCT_IF_C STT620 lv;
    check2(sizeof(lv), 8, "sizeof(STT620)");
    check2(__alignof__(lv), 4, "__alignof__(STT620)");
    check_field_offset(lv, fa, 0, "STT620.fa");
    check_field_offset(lv, fb, 4, "STT620.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT620, STT620)
//============================================================================


struct  STT630  {
  float fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT630) C1{ Fi Fi:0 Fc}



static void Test_STT630()
{
  {
    init_simple_test("STT630");
    static STRUCT_IF_C STT630 lv;
    check2(sizeof(lv), 8, "sizeof(STT630)");
    check2(__alignof__(lv), 4, "__alignof__(STT630)");
    check_field_offset(lv, fa, 0, "STT630.fa");
    check_field_offset(lv, fb, 4, "STT630.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT630, STT630)
//============================================================================


struct  STT640  {
  float fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT640) C1{ Fi FL:0 Fc}



static void Test_STT640()
{
  {
    init_simple_test("STT640");
    static STRUCT_IF_C STT640 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT640)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT640)");
    check_field_offset(lv, fa, 0, "STT640.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT640.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT640, STT640)
//============================================================================


struct  STT650  {
  float fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT650) C1{ Fi Fc:3 Fc}



static void Test_STT650()
{
  {
    init_simple_test("STT650");
    static STRUCT_IF_C STT650 lv;
    check2(sizeof(lv), 8, "sizeof(STT650)");
    check2(__alignof__(lv), 4, "__alignof__(STT650)");
    check_field_offset(lv, fa, 0, "STT650.fa");
    check_field_offset(lv, fb, 5, "STT650.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT650, STT650)
//============================================================================


struct  STT660  {
  float fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT660) C1{ Fi Fs:3 Fc}



static void Test_STT660()
{
  {
    init_simple_test("STT660");
    static STRUCT_IF_C STT660 lv;
    check2(sizeof(lv), 8, "sizeof(STT660)");
    check2(__alignof__(lv), 4, "__alignof__(STT660)");
    check_field_offset(lv, fa, 0, "STT660.fa");
    check_field_offset(lv, fb, 5, "STT660.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT660, STT660)
//============================================================================


struct  STT670  {
  float fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT670) C1{ Fi Fi:3 Fc}



static void Test_STT670()
{
  {
    init_simple_test("STT670");
    static STRUCT_IF_C STT670 lv;
    check2(sizeof(lv), 8, "sizeof(STT670)");
    check2(__alignof__(lv), 4, "__alignof__(STT670)");
    check_field_offset(lv, fa, 0, "STT670.fa");
    check_field_offset(lv, fb, 5, "STT670.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT670, STT670)
//============================================================================


struct  STT680  {
  float fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT680) C1{ Fi FL:3 Fc}



static void Test_STT680()
{
  {
    init_simple_test("STT680");
    static STRUCT_IF_C STT680 lv;
    check2(sizeof(lv), 8, "sizeof(STT680)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT680)");
    check_field_offset(lv, fa, 0, "STT680.fa");
    check_field_offset(lv, fb, 5, "STT680.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT680, STT680)
//============================================================================


struct  STT690  {
  float fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT690) C1{ Fi Fs:8 Fc}



static void Test_STT690()
{
  {
    init_simple_test("STT690");
    static STRUCT_IF_C STT690 lv;
    check2(sizeof(lv), 8, "sizeof(STT690)");
    check2(__alignof__(lv), 4, "__alignof__(STT690)");
    check_field_offset(lv, fa, 0, "STT690.fa");
    check_field_offset(lv, fb, 5, "STT690.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT690, STT690)
//============================================================================


struct  STT6100  {
  float fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT6100) C1{ Fi Fi:8 Fc}



static void Test_STT6100()
{
  {
    init_simple_test("STT6100");
    static STRUCT_IF_C STT6100 lv;
    check2(sizeof(lv), 8, "sizeof(STT6100)");
    check2(__alignof__(lv), 4, "__alignof__(STT6100)");
    check_field_offset(lv, fa, 0, "STT6100.fa");
    check_field_offset(lv, fb, 5, "STT6100.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6100, STT6100)
//============================================================================


struct  STT6110  {
  float fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT6110) C1{ Fi FL:8 Fc}



static void Test_STT6110()
{
  {
    init_simple_test("STT6110");
    static STRUCT_IF_C STT6110 lv;
    check2(sizeof(lv), 8, "sizeof(STT6110)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6110)");
    check_field_offset(lv, fa, 0, "STT6110.fa");
    check_field_offset(lv, fb, 5, "STT6110.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6110, STT6110)
//============================================================================


struct  STT6120  {
  float fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT6120) C1{ Fi Fi:18 Fc}



static void Test_STT6120()
{
  {
    init_simple_test("STT6120");
    static STRUCT_IF_C STT6120 lv;
    check2(sizeof(lv), 8, "sizeof(STT6120)");
    check2(__alignof__(lv), 4, "__alignof__(STT6120)");
    check_field_offset(lv, fa, 0, "STT6120.fa");
    check_field_offset(lv, fb, 7, "STT6120.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6120, STT6120)
//============================================================================


struct  STT6130  {
  float fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT6130) C1{ Fi FL:18 Fc}



static void Test_STT6130()
{
  {
    init_simple_test("STT6130");
    static STRUCT_IF_C STT6130 lv;
    check2(sizeof(lv), 8, "sizeof(STT6130)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6130)");
    check_field_offset(lv, fa, 0, "STT6130.fa");
    check_field_offset(lv, fb, 7, "STT6130.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6130, STT6130)
//============================================================================


struct  STT6140  {
  float fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT6140) C1{ Fi FL:48 Fc}



static void Test_STT6140()
{
  {
    init_simple_test("STT6140");
    static STRUCT_IF_C STT6140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6140)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6140)");
    check_field_offset(lv, fa, 0, "STT6140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT6140.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6140, STT6140)
//============================================================================


struct  STT6150  {
  float fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT6150) C1{ Fi Fc:3 Fc}



static void Test_STT6150()
{
  {
    init_simple_test("STT6150");
    static STRUCT_IF_C STT6150 lv;
    check2(sizeof(lv), 8, "sizeof(STT6150)");
    check2(__alignof__(lv), 4, "__alignof__(STT6150)");
    check_field_offset(lv, fa, 0, "STT6150.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6150");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6150");
    check_field_offset(lv, fb, 5, "STT6150.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6150, STT6150)
//============================================================================


struct  STT6160  {
  float fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT6160) C1{ Fi Fs:3 Fc}



static void Test_STT6160()
{
  {
    init_simple_test("STT6160");
    static STRUCT_IF_C STT6160 lv;
    check2(sizeof(lv), 8, "sizeof(STT6160)");
    check2(__alignof__(lv), 4, "__alignof__(STT6160)");
    check_field_offset(lv, fa, 0, "STT6160.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6160");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6160");
    check_field_offset(lv, fb, 5, "STT6160.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6160, STT6160)
//============================================================================


struct  STT6170  {
  float fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT6170) C1{ Fi Fi:3 Fc}



static void Test_STT6170()
{
  {
    init_simple_test("STT6170");
    static STRUCT_IF_C STT6170 lv;
    check2(sizeof(lv), 8, "sizeof(STT6170)");
    check2(__alignof__(lv), 4, "__alignof__(STT6170)");
    check_field_offset(lv, fa, 0, "STT6170.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6170");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6170");
    check_field_offset(lv, fb, 5, "STT6170.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6170, STT6170)
//============================================================================


struct  STT6180  {
  float fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT6180) C1{ Fi FL:3 Fc}



static void Test_STT6180()
{
  {
    init_simple_test("STT6180");
    static STRUCT_IF_C STT6180 lv;
    check2(sizeof(lv), 8, "sizeof(STT6180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6180)");
    check_field_offset(lv, fa, 0, "STT6180.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6180");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6180");
    check_field_offset(lv, fb, 5, "STT6180.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6180, STT6180)
//============================================================================


struct  STT6190  {
  float fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT6190) C1{ Fi Fs:8 Fc}



static void Test_STT6190()
{
  {
    init_simple_test("STT6190");
    static STRUCT_IF_C STT6190 lv;
    check2(sizeof(lv), 8, "sizeof(STT6190)");
    check2(__alignof__(lv), 4, "__alignof__(STT6190)");
    check_field_offset(lv, fa, 0, "STT6190.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6190");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6190");
    check_field_offset(lv, fb, 5, "STT6190.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6190, STT6190)
//============================================================================


struct  STT6200  {
  float fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT6200) C1{ Fi Fi:8 Fc}



static void Test_STT6200()
{
  {
    init_simple_test("STT6200");
    static STRUCT_IF_C STT6200 lv;
    check2(sizeof(lv), 8, "sizeof(STT6200)");
    check2(__alignof__(lv), 4, "__alignof__(STT6200)");
    check_field_offset(lv, fa, 0, "STT6200.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6200");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6200");
    check_field_offset(lv, fb, 5, "STT6200.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6200, STT6200)
//============================================================================


struct  STT6210  {
  float fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT6210) C1{ Fi FL:8 Fc}



static void Test_STT6210()
{
  {
    init_simple_test("STT6210");
    static STRUCT_IF_C STT6210 lv;
    check2(sizeof(lv), 8, "sizeof(STT6210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6210)");
    check_field_offset(lv, fa, 0, "STT6210.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6210");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6210");
    check_field_offset(lv, fb, 5, "STT6210.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6210, STT6210)
//============================================================================


struct  STT6220  {
  float fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT6220) C1{ Fi Fi:18 Fc}



static void Test_STT6220()
{
  {
    init_simple_test("STT6220");
    static STRUCT_IF_C STT6220 lv;
    check2(sizeof(lv), 8, "sizeof(STT6220)");
    check2(__alignof__(lv), 4, "__alignof__(STT6220)");
    check_field_offset(lv, fa, 0, "STT6220.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6220");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6220");
    check_field_offset(lv, fb, 7, "STT6220.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6220, STT6220)
//============================================================================


struct  STT6230  {
  float fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT6230) C1{ Fi FL:18 Fc}



static void Test_STT6230()
{
  {
    init_simple_test("STT6230");
    static STRUCT_IF_C STT6230 lv;
    check2(sizeof(lv), 8, "sizeof(STT6230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6230)");
    check_field_offset(lv, fa, 0, "STT6230.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6230");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6230");
    check_field_offset(lv, fb, 7, "STT6230.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6230, STT6230)
//============================================================================


struct  STT6240  {
  float fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT6240) C1{ Fi FL:48 Fc}



static void Test_STT6240()
{
  {
    init_simple_test("STT6240");
    static STRUCT_IF_C STT6240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6240)");
    check_field_offset(lv, fa, 0, "STT6240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT6240.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6240, STT6240)
//============================================================================


struct  STT611  {
  float fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT611) C1{ Fi Fc:0 Fs}



static void Test_STT611()
{
  {
    init_simple_test("STT611");
    static STRUCT_IF_C STT611 lv;
    check2(sizeof(lv), 8, "sizeof(STT611)");
    check2(__alignof__(lv), 4, "__alignof__(STT611)");
    check_field_offset(lv, fa, 0, "STT611.fa");
    check_field_offset(lv, fb, 4, "STT611.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT611, STT611)
//============================================================================


struct  STT621  {
  float fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT621) C1{ Fi Fs:0 Fs}



static void Test_STT621()
{
  {
    init_simple_test("STT621");
    static STRUCT_IF_C STT621 lv;
    check2(sizeof(lv), 8, "sizeof(STT621)");
    check2(__alignof__(lv), 4, "__alignof__(STT621)");
    check_field_offset(lv, fa, 0, "STT621.fa");
    check_field_offset(lv, fb, 4, "STT621.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT621, STT621)
//============================================================================


struct  STT631  {
  float fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT631) C1{ Fi Fi:0 Fs}



static void Test_STT631()
{
  {
    init_simple_test("STT631");
    static STRUCT_IF_C STT631 lv;
    check2(sizeof(lv), 8, "sizeof(STT631)");
    check2(__alignof__(lv), 4, "__alignof__(STT631)");
    check_field_offset(lv, fa, 0, "STT631.fa");
    check_field_offset(lv, fb, 4, "STT631.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT631, STT631)
//============================================================================


struct  STT641  {
  float fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT641) C1{ Fi FL:0 Fs}



static void Test_STT641()
{
  {
    init_simple_test("STT641");
    static STRUCT_IF_C STT641 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT641)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT641)");
    check_field_offset(lv, fa, 0, "STT641.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT641.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT641, STT641)
//============================================================================


struct  STT651  {
  float fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT651) C1{ Fi Fc:3 Fs}



static void Test_STT651()
{
  {
    init_simple_test("STT651");
    static STRUCT_IF_C STT651 lv;
    check2(sizeof(lv), 8, "sizeof(STT651)");
    check2(__alignof__(lv), 4, "__alignof__(STT651)");
    check_field_offset(lv, fa, 0, "STT651.fa");
    check_field_offset(lv, fb, 6, "STT651.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT651, STT651)
//============================================================================


struct  STT661  {
  float fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT661) C1{ Fi Fs:3 Fs}



static void Test_STT661()
{
  {
    init_simple_test("STT661");
    static STRUCT_IF_C STT661 lv;
    check2(sizeof(lv), 8, "sizeof(STT661)");
    check2(__alignof__(lv), 4, "__alignof__(STT661)");
    check_field_offset(lv, fa, 0, "STT661.fa");
    check_field_offset(lv, fb, 6, "STT661.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT661, STT661)
//============================================================================


struct  STT671  {
  float fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT671) C1{ Fi Fi:3 Fs}



static void Test_STT671()
{
  {
    init_simple_test("STT671");
    static STRUCT_IF_C STT671 lv;
    check2(sizeof(lv), 8, "sizeof(STT671)");
    check2(__alignof__(lv), 4, "__alignof__(STT671)");
    check_field_offset(lv, fa, 0, "STT671.fa");
    check_field_offset(lv, fb, 6, "STT671.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT671, STT671)
//============================================================================


struct  STT681  {
  float fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT681) C1{ Fi FL:3 Fs}



static void Test_STT681()
{
  {
    init_simple_test("STT681");
    static STRUCT_IF_C STT681 lv;
    check2(sizeof(lv), 8, "sizeof(STT681)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT681)");
    check_field_offset(lv, fa, 0, "STT681.fa");
    check_field_offset(lv, fb, 6, "STT681.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT681, STT681)
//============================================================================


struct  STT691  {
  float fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT691) C1{ Fi Fs:8 Fs}



static void Test_STT691()
{
  {
    init_simple_test("STT691");
    static STRUCT_IF_C STT691 lv;
    check2(sizeof(lv), 8, "sizeof(STT691)");
    check2(__alignof__(lv), 4, "__alignof__(STT691)");
    check_field_offset(lv, fa, 0, "STT691.fa");
    check_field_offset(lv, fb, 6, "STT691.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT691, STT691)
//============================================================================


struct  STT6101  {
  float fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT6101) C1{ Fi Fi:8 Fs}



static void Test_STT6101()
{
  {
    init_simple_test("STT6101");
    static STRUCT_IF_C STT6101 lv;
    check2(sizeof(lv), 8, "sizeof(STT6101)");
    check2(__alignof__(lv), 4, "__alignof__(STT6101)");
    check_field_offset(lv, fa, 0, "STT6101.fa");
    check_field_offset(lv, fb, 6, "STT6101.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6101, STT6101)
//============================================================================


struct  STT6111  {
  float fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT6111) C1{ Fi FL:8 Fs}



static void Test_STT6111()
{
  {
    init_simple_test("STT6111");
    static STRUCT_IF_C STT6111 lv;
    check2(sizeof(lv), 8, "sizeof(STT6111)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6111)");
    check_field_offset(lv, fa, 0, "STT6111.fa");
    check_field_offset(lv, fb, 6, "STT6111.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6111, STT6111)
//============================================================================


struct  STT6121  {
  float fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT6121) C1{ Fi Fi:18 Fs}



static void Test_STT6121()
{
  {
    init_simple_test("STT6121");
    static STRUCT_IF_C STT6121 lv;
    check2(sizeof(lv), 12, "sizeof(STT6121)");
    check2(__alignof__(lv), 4, "__alignof__(STT6121)");
    check_field_offset(lv, fa, 0, "STT6121.fa");
    check_field_offset(lv, fb, 8, "STT6121.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6121, STT6121)
//============================================================================


struct  STT6131  {
  float fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT6131) C1{ Fi FL:18 Fs}



static void Test_STT6131()
{
  {
    init_simple_test("STT6131");
    static STRUCT_IF_C STT6131 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT6131)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6131)");
    check_field_offset(lv, fa, 0, "STT6131.fa");
    check_field_offset(lv, fb, 8, "STT6131.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6131, STT6131)
//============================================================================


struct  STT6141  {
  float fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT6141) C1{ Fi FL:48 Fs}



static void Test_STT6141()
{
  {
    init_simple_test("STT6141");
    static STRUCT_IF_C STT6141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6141)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6141)");
    check_field_offset(lv, fa, 0, "STT6141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT6141.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6141, STT6141)
//============================================================================


struct  STT6151  {
  float fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT6151) C1{ Fi Fc:3 Fs}



static void Test_STT6151()
{
  {
    init_simple_test("STT6151");
    static STRUCT_IF_C STT6151 lv;
    check2(sizeof(lv), 8, "sizeof(STT6151)");
    check2(__alignof__(lv), 4, "__alignof__(STT6151)");
    check_field_offset(lv, fa, 0, "STT6151.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6151");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6151");
    check_field_offset(lv, fb, 6, "STT6151.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6151, STT6151)
//============================================================================


struct  STT6161  {
  float fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT6161) C1{ Fi Fs:3 Fs}



static void Test_STT6161()
{
  {
    init_simple_test("STT6161");
    static STRUCT_IF_C STT6161 lv;
    check2(sizeof(lv), 8, "sizeof(STT6161)");
    check2(__alignof__(lv), 4, "__alignof__(STT6161)");
    check_field_offset(lv, fa, 0, "STT6161.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6161");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6161");
    check_field_offset(lv, fb, 6, "STT6161.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6161, STT6161)
//============================================================================


struct  STT6171  {
  float fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT6171) C1{ Fi Fi:3 Fs}



static void Test_STT6171()
{
  {
    init_simple_test("STT6171");
    static STRUCT_IF_C STT6171 lv;
    check2(sizeof(lv), 8, "sizeof(STT6171)");
    check2(__alignof__(lv), 4, "__alignof__(STT6171)");
    check_field_offset(lv, fa, 0, "STT6171.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6171");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6171");
    check_field_offset(lv, fb, 6, "STT6171.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6171, STT6171)
//============================================================================


struct  STT6181  {
  float fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT6181) C1{ Fi FL:3 Fs}



static void Test_STT6181()
{
  {
    init_simple_test("STT6181");
    static STRUCT_IF_C STT6181 lv;
    check2(sizeof(lv), 8, "sizeof(STT6181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6181)");
    check_field_offset(lv, fa, 0, "STT6181.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6181");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6181");
    check_field_offset(lv, fb, 6, "STT6181.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6181, STT6181)
//============================================================================


struct  STT6191  {
  float fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT6191) C1{ Fi Fs:8 Fs}



static void Test_STT6191()
{
  {
    init_simple_test("STT6191");
    static STRUCT_IF_C STT6191 lv;
    check2(sizeof(lv), 8, "sizeof(STT6191)");
    check2(__alignof__(lv), 4, "__alignof__(STT6191)");
    check_field_offset(lv, fa, 0, "STT6191.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6191");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6191");
    check_field_offset(lv, fb, 6, "STT6191.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6191, STT6191)
//============================================================================


struct  STT6201  {
  float fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT6201) C1{ Fi Fi:8 Fs}



static void Test_STT6201()
{
  {
    init_simple_test("STT6201");
    static STRUCT_IF_C STT6201 lv;
    check2(sizeof(lv), 8, "sizeof(STT6201)");
    check2(__alignof__(lv), 4, "__alignof__(STT6201)");
    check_field_offset(lv, fa, 0, "STT6201.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6201");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6201");
    check_field_offset(lv, fb, 6, "STT6201.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6201, STT6201)
//============================================================================


struct  STT6211  {
  float fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT6211) C1{ Fi FL:8 Fs}



static void Test_STT6211()
{
  {
    init_simple_test("STT6211");
    static STRUCT_IF_C STT6211 lv;
    check2(sizeof(lv), 8, "sizeof(STT6211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6211)");
    check_field_offset(lv, fa, 0, "STT6211.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6211");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6211");
    check_field_offset(lv, fb, 6, "STT6211.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6211, STT6211)
//============================================================================


struct  STT6221  {
  float fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT6221) C1{ Fi Fi:18 Fs}



static void Test_STT6221()
{
  {
    init_simple_test("STT6221");
    static STRUCT_IF_C STT6221 lv;
    check2(sizeof(lv), 12, "sizeof(STT6221)");
    check2(__alignof__(lv), 4, "__alignof__(STT6221)");
    check_field_offset(lv, fa, 0, "STT6221.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6221");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6221");
    check_field_offset(lv, fb, 8, "STT6221.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6221, STT6221)
//============================================================================


struct  STT6231  {
  float fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT6231) C1{ Fi FL:18 Fs}



static void Test_STT6231()
{
  {
    init_simple_test("STT6231");
    static STRUCT_IF_C STT6231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6231)");
    check_field_offset(lv, fa, 0, "STT6231.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6231");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6231");
    check_field_offset(lv, fb, 8, "STT6231.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6231, STT6231)
//============================================================================


struct  STT6241  {
  float fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT6241) C1{ Fi FL:48 Fs}



static void Test_STT6241()
{
  {
    init_simple_test("STT6241");
    static STRUCT_IF_C STT6241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6241)");
    check_field_offset(lv, fa, 0, "STT6241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT6241.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6241, STT6241)
//============================================================================


struct  STT612  {
  float fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT612) C1{ Fi Fc:0 Fi}



static void Test_STT612()
{
  {
    init_simple_test("STT612");
    static STRUCT_IF_C STT612 lv;
    check2(sizeof(lv), 8, "sizeof(STT612)");
    check2(__alignof__(lv), 4, "__alignof__(STT612)");
    check_field_offset(lv, fa, 0, "STT612.fa");
    check_field_offset(lv, fb, 4, "STT612.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT612, STT612)
//============================================================================


struct  STT622  {
  float fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT622) C1{ Fi Fs:0 Fi}



static void Test_STT622()
{
  {
    init_simple_test("STT622");
    static STRUCT_IF_C STT622 lv;
    check2(sizeof(lv), 8, "sizeof(STT622)");
    check2(__alignof__(lv), 4, "__alignof__(STT622)");
    check_field_offset(lv, fa, 0, "STT622.fa");
    check_field_offset(lv, fb, 4, "STT622.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT622, STT622)
//============================================================================


struct  STT632  {
  float fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT632) C1{ Fi Fi:0 Fi}



static void Test_STT632()
{
  {
    init_simple_test("STT632");
    static STRUCT_IF_C STT632 lv;
    check2(sizeof(lv), 8, "sizeof(STT632)");
    check2(__alignof__(lv), 4, "__alignof__(STT632)");
    check_field_offset(lv, fa, 0, "STT632.fa");
    check_field_offset(lv, fb, 4, "STT632.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT632, STT632)
//============================================================================


struct  STT642  {
  float fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT642) C1{ Fi FL:0 Fi}



static void Test_STT642()
{
  {
    init_simple_test("STT642");
    static STRUCT_IF_C STT642 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT642)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT642)");
    check_field_offset(lv, fa, 0, "STT642.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT642.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT642, STT642)
//============================================================================


struct  STT652  {
  float fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT652) C1{ Fi Fc:3 Fi}



static void Test_STT652()
{
  {
    init_simple_test("STT652");
    static STRUCT_IF_C STT652 lv;
    check2(sizeof(lv), 12, "sizeof(STT652)");
    check2(__alignof__(lv), 4, "__alignof__(STT652)");
    check_field_offset(lv, fa, 0, "STT652.fa");
    check_field_offset(lv, fb, 8, "STT652.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT652, STT652)
//============================================================================


struct  STT662  {
  float fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT662) C1{ Fi Fs:3 Fi}



static void Test_STT662()
{
  {
    init_simple_test("STT662");
    static STRUCT_IF_C STT662 lv;
    check2(sizeof(lv), 12, "sizeof(STT662)");
    check2(__alignof__(lv), 4, "__alignof__(STT662)");
    check_field_offset(lv, fa, 0, "STT662.fa");
    check_field_offset(lv, fb, 8, "STT662.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT662, STT662)
//============================================================================


struct  STT672  {
  float fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT672) C1{ Fi Fi:3 Fi}



static void Test_STT672()
{
  {
    init_simple_test("STT672");
    static STRUCT_IF_C STT672 lv;
    check2(sizeof(lv), 12, "sizeof(STT672)");
    check2(__alignof__(lv), 4, "__alignof__(STT672)");
    check_field_offset(lv, fa, 0, "STT672.fa");
    check_field_offset(lv, fb, 8, "STT672.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT672, STT672)
//============================================================================


struct  STT682  {
  float fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT682) C1{ Fi FL:3 Fi}



static void Test_STT682()
{
  {
    init_simple_test("STT682");
    static STRUCT_IF_C STT682 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT682)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT682)");
    check_field_offset(lv, fa, 0, "STT682.fa");
    check_field_offset(lv, fb, 8, "STT682.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT682, STT682)
//============================================================================


struct  STT692  {
  float fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT692) C1{ Fi Fs:8 Fi}



static void Test_STT692()
{
  {
    init_simple_test("STT692");
    static STRUCT_IF_C STT692 lv;
    check2(sizeof(lv), 12, "sizeof(STT692)");
    check2(__alignof__(lv), 4, "__alignof__(STT692)");
    check_field_offset(lv, fa, 0, "STT692.fa");
    check_field_offset(lv, fb, 8, "STT692.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT692, STT692)
//============================================================================


struct  STT6102  {
  float fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT6102) C1{ Fi Fi:8 Fi}



static void Test_STT6102()
{
  {
    init_simple_test("STT6102");
    static STRUCT_IF_C STT6102 lv;
    check2(sizeof(lv), 12, "sizeof(STT6102)");
    check2(__alignof__(lv), 4, "__alignof__(STT6102)");
    check_field_offset(lv, fa, 0, "STT6102.fa");
    check_field_offset(lv, fb, 8, "STT6102.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6102, STT6102)
//============================================================================


struct  STT6112  {
  float fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT6112) C1{ Fi FL:8 Fi}



static void Test_STT6112()
{
  {
    init_simple_test("STT6112");
    static STRUCT_IF_C STT6112 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT6112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6112)");
    check_field_offset(lv, fa, 0, "STT6112.fa");
    check_field_offset(lv, fb, 8, "STT6112.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6112, STT6112)
//============================================================================


struct  STT6122  {
  float fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT6122) C1{ Fi Fi:18 Fi}



static void Test_STT6122()
{
  {
    init_simple_test("STT6122");
    static STRUCT_IF_C STT6122 lv;
    check2(sizeof(lv), 12, "sizeof(STT6122)");
    check2(__alignof__(lv), 4, "__alignof__(STT6122)");
    check_field_offset(lv, fa, 0, "STT6122.fa");
    check_field_offset(lv, fb, 8, "STT6122.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6122, STT6122)
//============================================================================


struct  STT6132  {
  float fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT6132) C1{ Fi FL:18 Fi}



static void Test_STT6132()
{
  {
    init_simple_test("STT6132");
    static STRUCT_IF_C STT6132 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT6132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6132)");
    check_field_offset(lv, fa, 0, "STT6132.fa");
    check_field_offset(lv, fb, 8, "STT6132.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6132, STT6132)
//============================================================================


struct  STT6142  {
  float fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT6142) C1{ Fi FL:48 Fi}



static void Test_STT6142()
{
  {
    init_simple_test("STT6142");
    static STRUCT_IF_C STT6142 lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(STT6142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6142)");
    check_field_offset(lv, fa, 0, "STT6142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6142.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6142, STT6142)
//============================================================================


struct  STT6152  {
  float fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT6152) C1{ Fi Fc:3 Fi}



static void Test_STT6152()
{
  {
    init_simple_test("STT6152");
    static STRUCT_IF_C STT6152 lv;
    check2(sizeof(lv), 12, "sizeof(STT6152)");
    check2(__alignof__(lv), 4, "__alignof__(STT6152)");
    check_field_offset(lv, fa, 0, "STT6152.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6152");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6152");
    check_field_offset(lv, fb, 8, "STT6152.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6152, STT6152)
//============================================================================


struct  STT6162  {
  float fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT6162) C1{ Fi Fs:3 Fi}



static void Test_STT6162()
{
  {
    init_simple_test("STT6162");
    static STRUCT_IF_C STT6162 lv;
    check2(sizeof(lv), 12, "sizeof(STT6162)");
    check2(__alignof__(lv), 4, "__alignof__(STT6162)");
    check_field_offset(lv, fa, 0, "STT6162.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6162");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6162");
    check_field_offset(lv, fb, 8, "STT6162.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6162, STT6162)
//============================================================================


struct  STT6172  {
  float fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT6172) C1{ Fi Fi:3 Fi}



static void Test_STT6172()
{
  {
    init_simple_test("STT6172");
    static STRUCT_IF_C STT6172 lv;
    check2(sizeof(lv), 12, "sizeof(STT6172)");
    check2(__alignof__(lv), 4, "__alignof__(STT6172)");
    check_field_offset(lv, fa, 0, "STT6172.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6172");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6172");
    check_field_offset(lv, fb, 8, "STT6172.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6172, STT6172)
//============================================================================


struct  STT6182  {
  float fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT6182) C1{ Fi FL:3 Fi}



static void Test_STT6182()
{
  {
    init_simple_test("STT6182");
    static STRUCT_IF_C STT6182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6182)");
    check_field_offset(lv, fa, 0, "STT6182.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6182");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6182");
    check_field_offset(lv, fb, 8, "STT6182.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6182, STT6182)
//============================================================================


struct  STT6192  {
  float fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT6192) C1{ Fi Fs:8 Fi}



static void Test_STT6192()
{
  {
    init_simple_test("STT6192");
    static STRUCT_IF_C STT6192 lv;
    check2(sizeof(lv), 12, "sizeof(STT6192)");
    check2(__alignof__(lv), 4, "__alignof__(STT6192)");
    check_field_offset(lv, fa, 0, "STT6192.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6192");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6192");
    check_field_offset(lv, fb, 8, "STT6192.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6192, STT6192)
//============================================================================


struct  STT6202  {
  float fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT6202) C1{ Fi Fi:8 Fi}



static void Test_STT6202()
{
  {
    init_simple_test("STT6202");
    static STRUCT_IF_C STT6202 lv;
    check2(sizeof(lv), 12, "sizeof(STT6202)");
    check2(__alignof__(lv), 4, "__alignof__(STT6202)");
    check_field_offset(lv, fa, 0, "STT6202.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6202");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6202");
    check_field_offset(lv, fb, 8, "STT6202.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6202, STT6202)
//============================================================================


struct  STT6212  {
  float fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT6212) C1{ Fi FL:8 Fi}



static void Test_STT6212()
{
  {
    init_simple_test("STT6212");
    static STRUCT_IF_C STT6212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6212)");
    check_field_offset(lv, fa, 0, "STT6212.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6212");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6212");
    check_field_offset(lv, fb, 8, "STT6212.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6212, STT6212)
//============================================================================


struct  STT6222  {
  float fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT6222) C1{ Fi Fi:18 Fi}



static void Test_STT6222()
{
  {
    init_simple_test("STT6222");
    static STRUCT_IF_C STT6222 lv;
    check2(sizeof(lv), 12, "sizeof(STT6222)");
    check2(__alignof__(lv), 4, "__alignof__(STT6222)");
    check_field_offset(lv, fa, 0, "STT6222.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6222");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6222");
    check_field_offset(lv, fb, 8, "STT6222.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6222, STT6222)
//============================================================================


struct  STT6232  {
  float fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT6232) C1{ Fi FL:18 Fi}



static void Test_STT6232()
{
  {
    init_simple_test("STT6232");
    static STRUCT_IF_C STT6232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6232)");
    check_field_offset(lv, fa, 0, "STT6232.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6232");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6232");
    check_field_offset(lv, fb, 8, "STT6232.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6232, STT6232)
//============================================================================


struct  STT6242  {
  float fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT6242) C1{ Fi FL:48 Fi}



static void Test_STT6242()
{
  {
    init_simple_test("STT6242");
    static STRUCT_IF_C STT6242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT6242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6242)");
    check_field_offset(lv, fa, 0, "STT6242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6242.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6242, STT6242)
//============================================================================


struct  STT613  {
  float fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT613) C1{ Fi Fc:0 Fl}



static void Test_STT613()
{
  {
    init_simple_test("STT613");
    static STRUCT_IF_C STT613 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT613)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT613)");
    check_field_offset(lv, fa, 0, "STT613.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT613.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT613, STT613)
//============================================================================


struct  STT623  {
  float fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT623) C1{ Fi Fs:0 Fl}



static void Test_STT623()
{
  {
    init_simple_test("STT623");
    static STRUCT_IF_C STT623 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT623)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT623)");
    check_field_offset(lv, fa, 0, "STT623.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT623.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT623, STT623)
//============================================================================


struct  STT633  {
  float fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT633) C1{ Fi Fi:0 Fl}



static void Test_STT633()
{
  {
    init_simple_test("STT633");
    static STRUCT_IF_C STT633 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT633)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT633)");
    check_field_offset(lv, fa, 0, "STT633.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT633.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT633, STT633)
//============================================================================


struct  STT643  {
  float fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT643) C1{ Fi FL:0 Fl}



static void Test_STT643()
{
  {
    init_simple_test("STT643");
    static STRUCT_IF_C STT643 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT643)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT643)");
    check_field_offset(lv, fa, 0, "STT643.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT643.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT643, STT643)
//============================================================================


struct  STT653  {
  float fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT653) C1{ Fi Fc:3 Fl}



static void Test_STT653()
{
  {
    init_simple_test("STT653");
    static STRUCT_IF_C STT653 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT653)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT653)");
    check_field_offset(lv, fa, 0, "STT653.fa");
    check_field_offset(lv, fb, 8, "STT653.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT653, STT653)
//============================================================================


struct  STT663  {
  float fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT663) C1{ Fi Fs:3 Fl}



static void Test_STT663()
{
  {
    init_simple_test("STT663");
    static STRUCT_IF_C STT663 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT663)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT663)");
    check_field_offset(lv, fa, 0, "STT663.fa");
    check_field_offset(lv, fb, 8, "STT663.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT663, STT663)
//============================================================================


struct  STT673  {
  float fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT673) C1{ Fi Fi:3 Fl}



static void Test_STT673()
{
  {
    init_simple_test("STT673");
    static STRUCT_IF_C STT673 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT673)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT673)");
    check_field_offset(lv, fa, 0, "STT673.fa");
    check_field_offset(lv, fb, 8, "STT673.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT673, STT673)
//============================================================================


struct  STT683  {
  float fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT683) C1{ Fi FL:3 Fl}



static void Test_STT683()
{
  {
    init_simple_test("STT683");
    static STRUCT_IF_C STT683 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT683)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT683)");
    check_field_offset(lv, fa, 0, "STT683.fa");
    check_field_offset(lv, fb, 8, "STT683.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT683, STT683)
//============================================================================


struct  STT693  {
  float fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT693) C1{ Fi Fs:8 Fl}



static void Test_STT693()
{
  {
    init_simple_test("STT693");
    static STRUCT_IF_C STT693 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT693)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT693)");
    check_field_offset(lv, fa, 0, "STT693.fa");
    check_field_offset(lv, fb, 8, "STT693.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT693, STT693)
//============================================================================


struct  STT6103  {
  float fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT6103) C1{ Fi Fi:8 Fl}



static void Test_STT6103()
{
  {
    init_simple_test("STT6103");
    static STRUCT_IF_C STT6103 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6103)");
    check_field_offset(lv, fa, 0, "STT6103.fa");
    check_field_offset(lv, fb, 8, "STT6103.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6103, STT6103)
//============================================================================


struct  STT6113  {
  float fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT6113) C1{ Fi FL:8 Fl}



static void Test_STT6113()
{
  {
    init_simple_test("STT6113");
    static STRUCT_IF_C STT6113 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6113)");
    check_field_offset(lv, fa, 0, "STT6113.fa");
    check_field_offset(lv, fb, 8, "STT6113.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6113, STT6113)
//============================================================================


struct  STT6123  {
  float fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT6123) C1{ Fi Fi:18 Fl}



static void Test_STT6123()
{
  {
    init_simple_test("STT6123");
    static STRUCT_IF_C STT6123 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6123)");
    check_field_offset(lv, fa, 0, "STT6123.fa");
    check_field_offset(lv, fb, 8, "STT6123.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6123, STT6123)
//============================================================================


struct  STT6133  {
  float fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT6133) C1{ Fi FL:18 Fl}



static void Test_STT6133()
{
  {
    init_simple_test("STT6133");
    static STRUCT_IF_C STT6133 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6133)");
    check_field_offset(lv, fa, 0, "STT6133.fa");
    check_field_offset(lv, fb, 8, "STT6133.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6133, STT6133)
//============================================================================


struct  STT6143  {
  float fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT6143) C1{ Fi FL:48 Fl}



static void Test_STT6143()
{
  {
    init_simple_test("STT6143");
    static STRUCT_IF_C STT6143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT6143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6143)");
    check_field_offset(lv, fa, 0, "STT6143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6143.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6143, STT6143)
//============================================================================


struct  STT6153  {
  float fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT6153) C1{ Fi Fc:3 Fl}



static void Test_STT6153()
{
  {
    init_simple_test("STT6153");
    static STRUCT_IF_C STT6153 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6153)");
    check_field_offset(lv, fa, 0, "STT6153.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6153");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6153");
    check_field_offset(lv, fb, 8, "STT6153.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6153, STT6153)
//============================================================================


struct  STT6163  {
  float fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT6163) C1{ Fi Fs:3 Fl}



static void Test_STT6163()
{
  {
    init_simple_test("STT6163");
    static STRUCT_IF_C STT6163 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6163)");
    check_field_offset(lv, fa, 0, "STT6163.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6163");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6163");
    check_field_offset(lv, fb, 8, "STT6163.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6163, STT6163)
//============================================================================


struct  STT6173  {
  float fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT6173) C1{ Fi Fi:3 Fl}



static void Test_STT6173()
{
  {
    init_simple_test("STT6173");
    static STRUCT_IF_C STT6173 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6173)");
    check_field_offset(lv, fa, 0, "STT6173.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6173");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6173");
    check_field_offset(lv, fb, 8, "STT6173.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6173, STT6173)
//============================================================================


struct  STT6183  {
  float fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT6183) C1{ Fi FL:3 Fl}



static void Test_STT6183()
{
  {
    init_simple_test("STT6183");
    static STRUCT_IF_C STT6183 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6183)");
    check_field_offset(lv, fa, 0, "STT6183.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6183");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6183");
    check_field_offset(lv, fb, 8, "STT6183.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6183, STT6183)
//============================================================================


struct  STT6193  {
  float fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT6193) C1{ Fi Fs:8 Fl}



static void Test_STT6193()
{
  {
    init_simple_test("STT6193");
    static STRUCT_IF_C STT6193 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6193)");
    check_field_offset(lv, fa, 0, "STT6193.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6193");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6193");
    check_field_offset(lv, fb, 8, "STT6193.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6193, STT6193)
//============================================================================


struct  STT6203  {
  float fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT6203) C1{ Fi Fi:8 Fl}



static void Test_STT6203()
{
  {
    init_simple_test("STT6203");
    static STRUCT_IF_C STT6203 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6203)");
    check_field_offset(lv, fa, 0, "STT6203.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6203");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6203");
    check_field_offset(lv, fb, 8, "STT6203.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6203, STT6203)
//============================================================================


struct  STT6213  {
  float fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT6213) C1{ Fi FL:8 Fl}



static void Test_STT6213()
{
  {
    init_simple_test("STT6213");
    static STRUCT_IF_C STT6213 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6213)");
    check_field_offset(lv, fa, 0, "STT6213.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6213");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6213");
    check_field_offset(lv, fb, 8, "STT6213.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6213, STT6213)
//============================================================================


struct  STT6223  {
  float fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT6223) C1{ Fi Fi:18 Fl}



static void Test_STT6223()
{
  {
    init_simple_test("STT6223");
    static STRUCT_IF_C STT6223 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6223)");
    check_field_offset(lv, fa, 0, "STT6223.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6223");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6223");
    check_field_offset(lv, fb, 8, "STT6223.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6223, STT6223)
//============================================================================


struct  STT6233  {
  float fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT6233) C1{ Fi FL:18 Fl}



static void Test_STT6233()
{
  {
    init_simple_test("STT6233");
    static STRUCT_IF_C STT6233 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6233)");
    check_field_offset(lv, fa, 0, "STT6233.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6233");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6233");
    check_field_offset(lv, fb, 8, "STT6233.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6233, STT6233)
//============================================================================


struct  STT6243  {
  float fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT6243) C1{ Fi FL:48 Fl}



static void Test_STT6243()
{
  {
    init_simple_test("STT6243");
    static STRUCT_IF_C STT6243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT6243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6243)");
    check_field_offset(lv, fa, 0, "STT6243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6243.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6243, STT6243)
//============================================================================


struct  STT614  {
  float fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT614) C1{ Fi Fc:0 FL}



static void Test_STT614()
{
  {
    init_simple_test("STT614");
    static STRUCT_IF_C STT614 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT614)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT614)");
    check_field_offset(lv, fa, 0, "STT614.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT614.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT614, STT614)
//============================================================================


struct  STT624  {
  float fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT624) C1{ Fi Fs:0 FL}



static void Test_STT624()
{
  {
    init_simple_test("STT624");
    static STRUCT_IF_C STT624 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT624)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT624)");
    check_field_offset(lv, fa, 0, "STT624.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT624.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT624, STT624)
//============================================================================


struct  STT634  {
  float fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT634) C1{ Fi Fi:0 FL}



static void Test_STT634()
{
  {
    init_simple_test("STT634");
    static STRUCT_IF_C STT634 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT634)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT634)");
    check_field_offset(lv, fa, 0, "STT634.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT634.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT634, STT634)
//============================================================================


struct  STT644  {
  float fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT644) C1{ Fi FL:0 FL}



static void Test_STT644()
{
  {
    init_simple_test("STT644");
    static STRUCT_IF_C STT644 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT644)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT644)");
    check_field_offset(lv, fa, 0, "STT644.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT644.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT644, STT644)
//============================================================================


struct  STT654  {
  float fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT654) C1{ Fi Fc:3 FL}



static void Test_STT654()
{
  {
    init_simple_test("STT654");
    static STRUCT_IF_C STT654 lv;
    check2(sizeof(lv), 16, "sizeof(STT654)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT654)");
    check_field_offset(lv, fa, 0, "STT654.fa");
    check_field_offset(lv, fb, 8, "STT654.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT654, STT654)
//============================================================================


struct  STT664  {
  float fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT664) C1{ Fi Fs:3 FL}



static void Test_STT664()
{
  {
    init_simple_test("STT664");
    static STRUCT_IF_C STT664 lv;
    check2(sizeof(lv), 16, "sizeof(STT664)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT664)");
    check_field_offset(lv, fa, 0, "STT664.fa");
    check_field_offset(lv, fb, 8, "STT664.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT664, STT664)
//============================================================================


struct  STT674  {
  float fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT674) C1{ Fi Fi:3 FL}



static void Test_STT674()
{
  {
    init_simple_test("STT674");
    static STRUCT_IF_C STT674 lv;
    check2(sizeof(lv), 16, "sizeof(STT674)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT674)");
    check_field_offset(lv, fa, 0, "STT674.fa");
    check_field_offset(lv, fb, 8, "STT674.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT674, STT674)
//============================================================================


struct  STT684  {
  float fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT684) C1{ Fi FL:3 FL}



static void Test_STT684()
{
  {
    init_simple_test("STT684");
    static STRUCT_IF_C STT684 lv;
    check2(sizeof(lv), 16, "sizeof(STT684)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT684)");
    check_field_offset(lv, fa, 0, "STT684.fa");
    check_field_offset(lv, fb, 8, "STT684.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT684, STT684)
//============================================================================


struct  STT694  {
  float fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT694) C1{ Fi Fs:8 FL}



static void Test_STT694()
{
  {
    init_simple_test("STT694");
    static STRUCT_IF_C STT694 lv;
    check2(sizeof(lv), 16, "sizeof(STT694)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT694)");
    check_field_offset(lv, fa, 0, "STT694.fa");
    check_field_offset(lv, fb, 8, "STT694.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT694, STT694)
//============================================================================


struct  STT6104  {
  float fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT6104) C1{ Fi Fi:8 FL}



static void Test_STT6104()
{
  {
    init_simple_test("STT6104");
    static STRUCT_IF_C STT6104 lv;
    check2(sizeof(lv), 16, "sizeof(STT6104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6104)");
    check_field_offset(lv, fa, 0, "STT6104.fa");
    check_field_offset(lv, fb, 8, "STT6104.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6104, STT6104)
//============================================================================


struct  STT6114  {
  float fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT6114) C1{ Fi FL:8 FL}



static void Test_STT6114()
{
  {
    init_simple_test("STT6114");
    static STRUCT_IF_C STT6114 lv;
    check2(sizeof(lv), 16, "sizeof(STT6114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6114)");
    check_field_offset(lv, fa, 0, "STT6114.fa");
    check_field_offset(lv, fb, 8, "STT6114.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6114, STT6114)
//============================================================================


struct  STT6124  {
  float fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT6124) C1{ Fi Fi:18 FL}



static void Test_STT6124()
{
  {
    init_simple_test("STT6124");
    static STRUCT_IF_C STT6124 lv;
    check2(sizeof(lv), 16, "sizeof(STT6124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6124)");
    check_field_offset(lv, fa, 0, "STT6124.fa");
    check_field_offset(lv, fb, 8, "STT6124.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6124, STT6124)
//============================================================================


struct  STT6134  {
  float fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT6134) C1{ Fi FL:18 FL}



static void Test_STT6134()
{
  {
    init_simple_test("STT6134");
    static STRUCT_IF_C STT6134 lv;
    check2(sizeof(lv), 16, "sizeof(STT6134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6134)");
    check_field_offset(lv, fa, 0, "STT6134.fa");
    check_field_offset(lv, fb, 8, "STT6134.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6134, STT6134)
//============================================================================


struct  STT6144  {
  float fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT6144) C1{ Fi FL:48 FL}



static void Test_STT6144()
{
  {
    init_simple_test("STT6144");
    static STRUCT_IF_C STT6144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT6144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6144)");
    check_field_offset(lv, fa, 0, "STT6144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6144.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6144, STT6144)
//============================================================================


struct  STT6154  {
  float fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT6154) C1{ Fi Fc:3 FL}



static void Test_STT6154()
{
  {
    init_simple_test("STT6154");
    static STRUCT_IF_C STT6154 lv;
    check2(sizeof(lv), 16, "sizeof(STT6154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6154)");
    check_field_offset(lv, fa, 0, "STT6154.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6154");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6154");
    check_field_offset(lv, fb, 8, "STT6154.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6154, STT6154)
//============================================================================


struct  STT6164  {
  float fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT6164) C1{ Fi Fs:3 FL}



static void Test_STT6164()
{
  {
    init_simple_test("STT6164");
    static STRUCT_IF_C STT6164 lv;
    check2(sizeof(lv), 16, "sizeof(STT6164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6164)");
    check_field_offset(lv, fa, 0, "STT6164.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6164");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6164");
    check_field_offset(lv, fb, 8, "STT6164.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6164, STT6164)
//============================================================================


struct  STT6174  {
  float fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT6174) C1{ Fi Fi:3 FL}



static void Test_STT6174()
{
  {
    init_simple_test("STT6174");
    static STRUCT_IF_C STT6174 lv;
    check2(sizeof(lv), 16, "sizeof(STT6174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6174)");
    check_field_offset(lv, fa, 0, "STT6174.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6174");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6174");
    check_field_offset(lv, fb, 8, "STT6174.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6174, STT6174)
//============================================================================


struct  STT6184  {
  float fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT6184) C1{ Fi FL:3 FL}



static void Test_STT6184()
{
  {
    init_simple_test("STT6184");
    static STRUCT_IF_C STT6184 lv;
    check2(sizeof(lv), 16, "sizeof(STT6184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6184)");
    check_field_offset(lv, fa, 0, "STT6184.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6184");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6184");
    check_field_offset(lv, fb, 8, "STT6184.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6184, STT6184)
//============================================================================


struct  STT6194  {
  float fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT6194) C1{ Fi Fs:8 FL}



static void Test_STT6194()
{
  {
    init_simple_test("STT6194");
    static STRUCT_IF_C STT6194 lv;
    check2(sizeof(lv), 16, "sizeof(STT6194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6194)");
    check_field_offset(lv, fa, 0, "STT6194.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6194");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6194");
    check_field_offset(lv, fb, 8, "STT6194.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6194, STT6194)
//============================================================================


struct  STT6204  {
  float fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT6204) C1{ Fi Fi:8 FL}



static void Test_STT6204()
{
  {
    init_simple_test("STT6204");
    static STRUCT_IF_C STT6204 lv;
    check2(sizeof(lv), 16, "sizeof(STT6204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6204)");
    check_field_offset(lv, fa, 0, "STT6204.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6204");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6204");
    check_field_offset(lv, fb, 8, "STT6204.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6204, STT6204)
//============================================================================


struct  STT6214  {
  float fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT6214) C1{ Fi FL:8 FL}



static void Test_STT6214()
{
  {
    init_simple_test("STT6214");
    static STRUCT_IF_C STT6214 lv;
    check2(sizeof(lv), 16, "sizeof(STT6214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6214)");
    check_field_offset(lv, fa, 0, "STT6214.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6214");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6214");
    check_field_offset(lv, fb, 8, "STT6214.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6214, STT6214)
//============================================================================


struct  STT6224  {
  float fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT6224) C1{ Fi Fi:18 FL}



static void Test_STT6224()
{
  {
    init_simple_test("STT6224");
    static STRUCT_IF_C STT6224 lv;
    check2(sizeof(lv), 16, "sizeof(STT6224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6224)");
    check_field_offset(lv, fa, 0, "STT6224.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6224");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6224");
    check_field_offset(lv, fb, 8, "STT6224.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6224, STT6224)
//============================================================================


struct  STT6234  {
  float fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT6234) C1{ Fi FL:18 FL}



static void Test_STT6234()
{
  {
    init_simple_test("STT6234");
    static STRUCT_IF_C STT6234 lv;
    check2(sizeof(lv), 16, "sizeof(STT6234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6234)");
    check_field_offset(lv, fa, 0, "STT6234.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6234");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6234");
    check_field_offset(lv, fb, 8, "STT6234.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6234, STT6234)
//============================================================================


struct  STT6244  {
  float fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT6244) C1{ Fi FL:48 FL}



static void Test_STT6244()
{
  {
    init_simple_test("STT6244");
    static STRUCT_IF_C STT6244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT6244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6244)");
    check_field_offset(lv, fa, 0, "STT6244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6244.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6244, STT6244)
//============================================================================


struct  STT615  {
  float fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT615) C1{ Fi Fc:0 Fp}



static void Test_STT615()
{
  {
    init_simple_test("STT615");
    static STRUCT_IF_C STT615 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT615)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT615)");
    check_field_offset(lv, fa, 0, "STT615.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT615.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT615, STT615)
//============================================================================


struct  STT625  {
  float fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT625) C1{ Fi Fs:0 Fp}



static void Test_STT625()
{
  {
    init_simple_test("STT625");
    static STRUCT_IF_C STT625 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT625)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT625)");
    check_field_offset(lv, fa, 0, "STT625.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT625.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT625, STT625)
//============================================================================


struct  STT635  {
  float fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT635) C1{ Fi Fi:0 Fp}



static void Test_STT635()
{
  {
    init_simple_test("STT635");
    static STRUCT_IF_C STT635 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT635)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT635)");
    check_field_offset(lv, fa, 0, "STT635.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT635.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT635, STT635)
//============================================================================


struct  STT645  {
  float fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT645) C1{ Fi FL:0 Fp}



static void Test_STT645()
{
  {
    init_simple_test("STT645");
    static STRUCT_IF_C STT645 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT645)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT645)");
    check_field_offset(lv, fa, 0, "STT645.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT645.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT645, STT645)
//============================================================================


struct  STT655  {
  float fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT655) C1{ Fi Fc:3 Fp}



static void Test_STT655()
{
  {
    init_simple_test("STT655");
    static STRUCT_IF_C STT655 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT655)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT655)");
    check_field_offset(lv, fa, 0, "STT655.fa");
    check_field_offset(lv, fb, 8, "STT655.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT655, STT655)
//============================================================================


struct  STT665  {
  float fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT665) C1{ Fi Fs:3 Fp}



static void Test_STT665()
{
  {
    init_simple_test("STT665");
    static STRUCT_IF_C STT665 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT665)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT665)");
    check_field_offset(lv, fa, 0, "STT665.fa");
    check_field_offset(lv, fb, 8, "STT665.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT665, STT665)
//============================================================================


struct  STT675  {
  float fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT675) C1{ Fi Fi:3 Fp}



static void Test_STT675()
{
  {
    init_simple_test("STT675");
    static STRUCT_IF_C STT675 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT675)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT675)");
    check_field_offset(lv, fa, 0, "STT675.fa");
    check_field_offset(lv, fb, 8, "STT675.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT675, STT675)
//============================================================================


struct  STT685  {
  float fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT685) C1{ Fi FL:3 Fp}



static void Test_STT685()
{
  {
    init_simple_test("STT685");
    static STRUCT_IF_C STT685 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT685)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT685)");
    check_field_offset(lv, fa, 0, "STT685.fa");
    check_field_offset(lv, fb, 8, "STT685.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT685, STT685)
//============================================================================


struct  STT695  {
  float fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT695) C1{ Fi Fs:8 Fp}



static void Test_STT695()
{
  {
    init_simple_test("STT695");
    static STRUCT_IF_C STT695 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT695)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT695)");
    check_field_offset(lv, fa, 0, "STT695.fa");
    check_field_offset(lv, fb, 8, "STT695.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT695, STT695)
//============================================================================


struct  STT6105  {
  float fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT6105) C1{ Fi Fi:8 Fp}



static void Test_STT6105()
{
  {
    init_simple_test("STT6105");
    static STRUCT_IF_C STT6105 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6105)");
    check_field_offset(lv, fa, 0, "STT6105.fa");
    check_field_offset(lv, fb, 8, "STT6105.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6105, STT6105)
//============================================================================


struct  STT6115  {
  float fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT6115) C1{ Fi FL:8 Fp}



static void Test_STT6115()
{
  {
    init_simple_test("STT6115");
    static STRUCT_IF_C STT6115 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6115)");
    check_field_offset(lv, fa, 0, "STT6115.fa");
    check_field_offset(lv, fb, 8, "STT6115.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6115, STT6115)
//============================================================================


struct  STT6125  {
  float fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT6125) C1{ Fi Fi:18 Fp}



static void Test_STT6125()
{
  {
    init_simple_test("STT6125");
    static STRUCT_IF_C STT6125 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6125)");
    check_field_offset(lv, fa, 0, "STT6125.fa");
    check_field_offset(lv, fb, 8, "STT6125.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6125, STT6125)
//============================================================================


struct  STT6135  {
  float fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT6135) C1{ Fi FL:18 Fp}



static void Test_STT6135()
{
  {
    init_simple_test("STT6135");
    static STRUCT_IF_C STT6135 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6135)");
    check_field_offset(lv, fa, 0, "STT6135.fa");
    check_field_offset(lv, fb, 8, "STT6135.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6135, STT6135)
//============================================================================


struct  STT6145  {
  float fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT6145) C1{ Fi FL:48 Fp}



static void Test_STT6145()
{
  {
    init_simple_test("STT6145");
    static STRUCT_IF_C STT6145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT6145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6145)");
    check_field_offset(lv, fa, 0, "STT6145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6145.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6145, STT6145)
//============================================================================


struct  STT6155  {
  float fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT6155) C1{ Fi Fc:3 Fp}



static void Test_STT6155()
{
  {
    init_simple_test("STT6155");
    static STRUCT_IF_C STT6155 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6155)");
    check_field_offset(lv, fa, 0, "STT6155.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6155");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6155");
    check_field_offset(lv, fb, 8, "STT6155.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6155, STT6155)
//============================================================================


struct  STT6165  {
  float fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT6165) C1{ Fi Fs:3 Fp}



static void Test_STT6165()
{
  {
    init_simple_test("STT6165");
    static STRUCT_IF_C STT6165 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6165)");
    check_field_offset(lv, fa, 0, "STT6165.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6165");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6165");
    check_field_offset(lv, fb, 8, "STT6165.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6165, STT6165)
//============================================================================


struct  STT6175  {
  float fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT6175) C1{ Fi Fi:3 Fp}



static void Test_STT6175()
{
  {
    init_simple_test("STT6175");
    static STRUCT_IF_C STT6175 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6175)");
    check_field_offset(lv, fa, 0, "STT6175.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6175");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6175");
    check_field_offset(lv, fb, 8, "STT6175.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6175, STT6175)
//============================================================================


struct  STT6185  {
  float fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT6185) C1{ Fi FL:3 Fp}



static void Test_STT6185()
{
  {
    init_simple_test("STT6185");
    static STRUCT_IF_C STT6185 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6185)");
    check_field_offset(lv, fa, 0, "STT6185.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6185");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6185");
    check_field_offset(lv, fb, 8, "STT6185.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6185, STT6185)
//============================================================================


struct  STT6195  {
  float fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT6195) C1{ Fi Fs:8 Fp}



static void Test_STT6195()
{
  {
    init_simple_test("STT6195");
    static STRUCT_IF_C STT6195 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6195)");
    check_field_offset(lv, fa, 0, "STT6195.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6195");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6195");
    check_field_offset(lv, fb, 8, "STT6195.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6195, STT6195)
//============================================================================


struct  STT6205  {
  float fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT6205) C1{ Fi Fi:8 Fp}



static void Test_STT6205()
{
  {
    init_simple_test("STT6205");
    static STRUCT_IF_C STT6205 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6205)");
    check_field_offset(lv, fa, 0, "STT6205.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6205");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6205");
    check_field_offset(lv, fb, 8, "STT6205.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6205, STT6205)
//============================================================================


struct  STT6215  {
  float fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT6215) C1{ Fi FL:8 Fp}



static void Test_STT6215()
{
  {
    init_simple_test("STT6215");
    static STRUCT_IF_C STT6215 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6215)");
    check_field_offset(lv, fa, 0, "STT6215.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6215");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6215");
    check_field_offset(lv, fb, 8, "STT6215.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6215, STT6215)
//============================================================================


struct  STT6225  {
  float fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT6225) C1{ Fi Fi:18 Fp}



static void Test_STT6225()
{
  {
    init_simple_test("STT6225");
    static STRUCT_IF_C STT6225 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6225)");
    check_field_offset(lv, fa, 0, "STT6225.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6225");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6225");
    check_field_offset(lv, fb, 8, "STT6225.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6225, STT6225)
//============================================================================


struct  STT6235  {
  float fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT6235) C1{ Fi FL:18 Fp}



static void Test_STT6235()
{
  {
    init_simple_test("STT6235");
    static STRUCT_IF_C STT6235 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6235)");
    check_field_offset(lv, fa, 0, "STT6235.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6235");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6235");
    check_field_offset(lv, fb, 8, "STT6235.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6235, STT6235)
//============================================================================


struct  STT6245  {
  float fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT6245) C1{ Fi FL:48 Fp}



static void Test_STT6245()
{
  {
    init_simple_test("STT6245");
    static STRUCT_IF_C STT6245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT6245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6245)");
    check_field_offset(lv, fa, 0, "STT6245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6245.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6245, STT6245)
//============================================================================


struct  STT616  {
  float fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT616) C1{ Fi Fc:0 Fi}



static void Test_STT616()
{
  {
    init_simple_test("STT616");
    static STRUCT_IF_C STT616 lv;
    check2(sizeof(lv), 8, "sizeof(STT616)");
    check2(__alignof__(lv), 4, "__alignof__(STT616)");
    check_field_offset(lv, fa, 0, "STT616.fa");
    check_field_offset(lv, fb, 4, "STT616.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT616, STT616)
//============================================================================


struct  STT626  {
  float fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT626) C1{ Fi Fs:0 Fi}



static void Test_STT626()
{
  {
    init_simple_test("STT626");
    static STRUCT_IF_C STT626 lv;
    check2(sizeof(lv), 8, "sizeof(STT626)");
    check2(__alignof__(lv), 4, "__alignof__(STT626)");
    check_field_offset(lv, fa, 0, "STT626.fa");
    check_field_offset(lv, fb, 4, "STT626.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT626, STT626)
//============================================================================


struct  STT636  {
  float fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT636) C1{ Fi Fi:0 Fi}



static void Test_STT636()
{
  {
    init_simple_test("STT636");
    static STRUCT_IF_C STT636 lv;
    check2(sizeof(lv), 8, "sizeof(STT636)");
    check2(__alignof__(lv), 4, "__alignof__(STT636)");
    check_field_offset(lv, fa, 0, "STT636.fa");
    check_field_offset(lv, fb, 4, "STT636.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT636, STT636)
//============================================================================


struct  STT646  {
  float fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT646) C1{ Fi FL:0 Fi}



static void Test_STT646()
{
  {
    init_simple_test("STT646");
    static STRUCT_IF_C STT646 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT646)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT646)");
    check_field_offset(lv, fa, 0, "STT646.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT646.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT646, STT646)
//============================================================================


struct  STT656  {
  float fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT656) C1{ Fi Fc:3 Fi}



static void Test_STT656()
{
  {
    init_simple_test("STT656");
    static STRUCT_IF_C STT656 lv;
    check2(sizeof(lv), 12, "sizeof(STT656)");
    check2(__alignof__(lv), 4, "__alignof__(STT656)");
    check_field_offset(lv, fa, 0, "STT656.fa");
    check_field_offset(lv, fb, 8, "STT656.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT656, STT656)
//============================================================================


struct  STT666  {
  float fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT666) C1{ Fi Fs:3 Fi}



static void Test_STT666()
{
  {
    init_simple_test("STT666");
    static STRUCT_IF_C STT666 lv;
    check2(sizeof(lv), 12, "sizeof(STT666)");
    check2(__alignof__(lv), 4, "__alignof__(STT666)");
    check_field_offset(lv, fa, 0, "STT666.fa");
    check_field_offset(lv, fb, 8, "STT666.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT666, STT666)
//============================================================================


struct  STT676  {
  float fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT676) C1{ Fi Fi:3 Fi}



static void Test_STT676()
{
  {
    init_simple_test("STT676");
    static STRUCT_IF_C STT676 lv;
    check2(sizeof(lv), 12, "sizeof(STT676)");
    check2(__alignof__(lv), 4, "__alignof__(STT676)");
    check_field_offset(lv, fa, 0, "STT676.fa");
    check_field_offset(lv, fb, 8, "STT676.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT676, STT676)
//============================================================================


struct  STT686  {
  float fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT686) C1{ Fi FL:3 Fi}



static void Test_STT686()
{
  {
    init_simple_test("STT686");
    static STRUCT_IF_C STT686 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT686)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT686)");
    check_field_offset(lv, fa, 0, "STT686.fa");
    check_field_offset(lv, fb, 8, "STT686.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT686, STT686)
//============================================================================


struct  STT696  {
  float fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT696) C1{ Fi Fs:8 Fi}



static void Test_STT696()
{
  {
    init_simple_test("STT696");
    static STRUCT_IF_C STT696 lv;
    check2(sizeof(lv), 12, "sizeof(STT696)");
    check2(__alignof__(lv), 4, "__alignof__(STT696)");
    check_field_offset(lv, fa, 0, "STT696.fa");
    check_field_offset(lv, fb, 8, "STT696.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT696, STT696)
//============================================================================


struct  STT6106  {
  float fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT6106) C1{ Fi Fi:8 Fi}



static void Test_STT6106()
{
  {
    init_simple_test("STT6106");
    static STRUCT_IF_C STT6106 lv;
    check2(sizeof(lv), 12, "sizeof(STT6106)");
    check2(__alignof__(lv), 4, "__alignof__(STT6106)");
    check_field_offset(lv, fa, 0, "STT6106.fa");
    check_field_offset(lv, fb, 8, "STT6106.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6106, STT6106)
//============================================================================


struct  STT6116  {
  float fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT6116) C1{ Fi FL:8 Fi}



static void Test_STT6116()
{
  {
    init_simple_test("STT6116");
    static STRUCT_IF_C STT6116 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT6116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6116)");
    check_field_offset(lv, fa, 0, "STT6116.fa");
    check_field_offset(lv, fb, 8, "STT6116.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6116, STT6116)
//============================================================================


struct  STT6126  {
  float fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT6126) C1{ Fi Fi:18 Fi}



static void Test_STT6126()
{
  {
    init_simple_test("STT6126");
    static STRUCT_IF_C STT6126 lv;
    check2(sizeof(lv), 12, "sizeof(STT6126)");
    check2(__alignof__(lv), 4, "__alignof__(STT6126)");
    check_field_offset(lv, fa, 0, "STT6126.fa");
    check_field_offset(lv, fb, 8, "STT6126.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6126, STT6126)
//============================================================================


struct  STT6136  {
  float fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT6136) C1{ Fi FL:18 Fi}



static void Test_STT6136()
{
  {
    init_simple_test("STT6136");
    static STRUCT_IF_C STT6136 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT6136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6136)");
    check_field_offset(lv, fa, 0, "STT6136.fa");
    check_field_offset(lv, fb, 8, "STT6136.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6136, STT6136)
//============================================================================


struct  STT6146  {
  float fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT6146) C1{ Fi FL:48 Fi}



static void Test_STT6146()
{
  {
    init_simple_test("STT6146");
    static STRUCT_IF_C STT6146 lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(STT6146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT6146)");
    check_field_offset(lv, fa, 0, "STT6146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6146.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6146, STT6146)
//============================================================================


struct  STT6156  {
  float fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT6156) C1{ Fi Fc:3 Fi}



static void Test_STT6156()
{
  {
    init_simple_test("STT6156");
    static STRUCT_IF_C STT6156 lv;
    check2(sizeof(lv), 12, "sizeof(STT6156)");
    check2(__alignof__(lv), 4, "__alignof__(STT6156)");
    check_field_offset(lv, fa, 0, "STT6156.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6156");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6156");
    check_field_offset(lv, fb, 8, "STT6156.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6156, STT6156)
//============================================================================


struct  STT6166  {
  float fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT6166) C1{ Fi Fs:3 Fi}



static void Test_STT6166()
{
  {
    init_simple_test("STT6166");
    static STRUCT_IF_C STT6166 lv;
    check2(sizeof(lv), 12, "sizeof(STT6166)");
    check2(__alignof__(lv), 4, "__alignof__(STT6166)");
    check_field_offset(lv, fa, 0, "STT6166.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6166");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6166");
    check_field_offset(lv, fb, 8, "STT6166.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6166, STT6166)
//============================================================================


struct  STT6176  {
  float fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT6176) C1{ Fi Fi:3 Fi}



static void Test_STT6176()
{
  {
    init_simple_test("STT6176");
    static STRUCT_IF_C STT6176 lv;
    check2(sizeof(lv), 12, "sizeof(STT6176)");
    check2(__alignof__(lv), 4, "__alignof__(STT6176)");
    check_field_offset(lv, fa, 0, "STT6176.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6176");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6176");
    check_field_offset(lv, fb, 8, "STT6176.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6176, STT6176)
//============================================================================


struct  STT6186  {
  float fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT6186) C1{ Fi FL:3 Fi}



static void Test_STT6186()
{
  {
    init_simple_test("STT6186");
    static STRUCT_IF_C STT6186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6186)");
    check_field_offset(lv, fa, 0, "STT6186.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6186");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6186");
    check_field_offset(lv, fb, 8, "STT6186.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6186, STT6186)
//============================================================================


struct  STT6196  {
  float fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT6196) C1{ Fi Fs:8 Fi}



static void Test_STT6196()
{
  {
    init_simple_test("STT6196");
    static STRUCT_IF_C STT6196 lv;
    check2(sizeof(lv), 12, "sizeof(STT6196)");
    check2(__alignof__(lv), 4, "__alignof__(STT6196)");
    check_field_offset(lv, fa, 0, "STT6196.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6196");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6196");
    check_field_offset(lv, fb, 8, "STT6196.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6196, STT6196)
//============================================================================


struct  STT6206  {
  float fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT6206) C1{ Fi Fi:8 Fi}



static void Test_STT6206()
{
  {
    init_simple_test("STT6206");
    static STRUCT_IF_C STT6206 lv;
    check2(sizeof(lv), 12, "sizeof(STT6206)");
    check2(__alignof__(lv), 4, "__alignof__(STT6206)");
    check_field_offset(lv, fa, 0, "STT6206.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6206");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6206");
    check_field_offset(lv, fb, 8, "STT6206.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6206, STT6206)
//============================================================================


struct  STT6216  {
  float fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT6216) C1{ Fi FL:8 Fi}



static void Test_STT6216()
{
  {
    init_simple_test("STT6216");
    static STRUCT_IF_C STT6216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6216)");
    check_field_offset(lv, fa, 0, "STT6216.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6216");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6216");
    check_field_offset(lv, fb, 8, "STT6216.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6216, STT6216)
//============================================================================


struct  STT6226  {
  float fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT6226) C1{ Fi Fi:18 Fi}



static void Test_STT6226()
{
  {
    init_simple_test("STT6226");
    static STRUCT_IF_C STT6226 lv;
    check2(sizeof(lv), 12, "sizeof(STT6226)");
    check2(__alignof__(lv), 4, "__alignof__(STT6226)");
    check_field_offset(lv, fa, 0, "STT6226.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6226");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6226");
    check_field_offset(lv, fb, 8, "STT6226.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6226, STT6226)
//============================================================================


struct  STT6236  {
  float fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT6236) C1{ Fi FL:18 Fi}



static void Test_STT6236()
{
  {
    init_simple_test("STT6236");
    static STRUCT_IF_C STT6236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT6236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6236)");
    check_field_offset(lv, fa, 0, "STT6236.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6236");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6236");
    check_field_offset(lv, fb, 8, "STT6236.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6236, STT6236)
//============================================================================


struct  STT6246  {
  float fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT6246) C1{ Fi FL:48 Fi}



static void Test_STT6246()
{
  {
    init_simple_test("STT6246");
    static STRUCT_IF_C STT6246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT6246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6246)");
    check_field_offset(lv, fa, 0, "STT6246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6246.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6246, STT6246)
//============================================================================


struct  STT617  {
  float fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT617) C1{ Fi Fc:0 FL}



static void Test_STT617()
{
  {
    init_simple_test("STT617");
    static STRUCT_IF_C STT617 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT617)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT617)");
    check_field_offset(lv, fa, 0, "STT617.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT617.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT617, STT617)
//============================================================================


struct  STT627  {
  float fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT627) C1{ Fi Fs:0 FL}



static void Test_STT627()
{
  {
    init_simple_test("STT627");
    static STRUCT_IF_C STT627 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT627)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT627)");
    check_field_offset(lv, fa, 0, "STT627.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT627.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT627, STT627)
//============================================================================


struct  STT637  {
  float fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT637) C1{ Fi Fi:0 FL}



static void Test_STT637()
{
  {
    init_simple_test("STT637");
    static STRUCT_IF_C STT637 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT637)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT637)");
    check_field_offset(lv, fa, 0, "STT637.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT637.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT637, STT637)
//============================================================================


struct  STT647  {
  float fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT647) C1{ Fi FL:0 FL}



static void Test_STT647()
{
  {
    init_simple_test("STT647");
    static STRUCT_IF_C STT647 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT647)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT647)");
    check_field_offset(lv, fa, 0, "STT647.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT647.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT647, STT647)
//============================================================================


struct  STT657  {
  float fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT657) C1{ Fi Fc:3 FL}



static void Test_STT657()
{
  {
    init_simple_test("STT657");
    static STRUCT_IF_C STT657 lv;
    check2(sizeof(lv), 16, "sizeof(STT657)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT657)");
    check_field_offset(lv, fa, 0, "STT657.fa");
    check_field_offset(lv, fb, 8, "STT657.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT657, STT657)
//============================================================================


struct  STT667  {
  float fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT667) C1{ Fi Fs:3 FL}



static void Test_STT667()
{
  {
    init_simple_test("STT667");
    static STRUCT_IF_C STT667 lv;
    check2(sizeof(lv), 16, "sizeof(STT667)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT667)");
    check_field_offset(lv, fa, 0, "STT667.fa");
    check_field_offset(lv, fb, 8, "STT667.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT667, STT667)
//============================================================================


struct  STT677  {
  float fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT677) C1{ Fi Fi:3 FL}



static void Test_STT677()
{
  {
    init_simple_test("STT677");
    static STRUCT_IF_C STT677 lv;
    check2(sizeof(lv), 16, "sizeof(STT677)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT677)");
    check_field_offset(lv, fa, 0, "STT677.fa");
    check_field_offset(lv, fb, 8, "STT677.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT677, STT677)
//============================================================================


struct  STT687  {
  float fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT687) C1{ Fi FL:3 FL}



static void Test_STT687()
{
  {
    init_simple_test("STT687");
    static STRUCT_IF_C STT687 lv;
    check2(sizeof(lv), 16, "sizeof(STT687)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT687)");
    check_field_offset(lv, fa, 0, "STT687.fa");
    check_field_offset(lv, fb, 8, "STT687.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT687, STT687)
//============================================================================


struct  STT697  {
  float fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT697) C1{ Fi Fs:8 FL}



static void Test_STT697()
{
  {
    init_simple_test("STT697");
    static STRUCT_IF_C STT697 lv;
    check2(sizeof(lv), 16, "sizeof(STT697)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT697)");
    check_field_offset(lv, fa, 0, "STT697.fa");
    check_field_offset(lv, fb, 8, "STT697.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT697, STT697)
//============================================================================


struct  STT6107  {
  float fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT6107) C1{ Fi Fi:8 FL}



static void Test_STT6107()
{
  {
    init_simple_test("STT6107");
    static STRUCT_IF_C STT6107 lv;
    check2(sizeof(lv), 16, "sizeof(STT6107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6107)");
    check_field_offset(lv, fa, 0, "STT6107.fa");
    check_field_offset(lv, fb, 8, "STT6107.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6107, STT6107)
//============================================================================


struct  STT6117  {
  float fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT6117) C1{ Fi FL:8 FL}



static void Test_STT6117()
{
  {
    init_simple_test("STT6117");
    static STRUCT_IF_C STT6117 lv;
    check2(sizeof(lv), 16, "sizeof(STT6117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6117)");
    check_field_offset(lv, fa, 0, "STT6117.fa");
    check_field_offset(lv, fb, 8, "STT6117.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6117, STT6117)
//============================================================================


struct  STT6127  {
  float fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT6127) C1{ Fi Fi:18 FL}



static void Test_STT6127()
{
  {
    init_simple_test("STT6127");
    static STRUCT_IF_C STT6127 lv;
    check2(sizeof(lv), 16, "sizeof(STT6127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6127)");
    check_field_offset(lv, fa, 0, "STT6127.fa");
    check_field_offset(lv, fb, 8, "STT6127.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6127, STT6127)
//============================================================================


struct  STT6137  {
  float fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT6137) C1{ Fi FL:18 FL}



static void Test_STT6137()
{
  {
    init_simple_test("STT6137");
    static STRUCT_IF_C STT6137 lv;
    check2(sizeof(lv), 16, "sizeof(STT6137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6137)");
    check_field_offset(lv, fa, 0, "STT6137.fa");
    check_field_offset(lv, fb, 8, "STT6137.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6137, STT6137)
//============================================================================


struct  STT6147  {
  float fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT6147) C1{ Fi FL:48 FL}



static void Test_STT6147()
{
  {
    init_simple_test("STT6147");
    static STRUCT_IF_C STT6147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT6147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6147)");
    check_field_offset(lv, fa, 0, "STT6147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6147.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6147, STT6147)
//============================================================================


struct  STT6157  {
  float fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT6157) C1{ Fi Fc:3 FL}



static void Test_STT6157()
{
  {
    init_simple_test("STT6157");
    static STRUCT_IF_C STT6157 lv;
    check2(sizeof(lv), 16, "sizeof(STT6157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6157)");
    check_field_offset(lv, fa, 0, "STT6157.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6157");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6157");
    check_field_offset(lv, fb, 8, "STT6157.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6157, STT6157)
//============================================================================


struct  STT6167  {
  float fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT6167) C1{ Fi Fs:3 FL}



static void Test_STT6167()
{
  {
    init_simple_test("STT6167");
    static STRUCT_IF_C STT6167 lv;
    check2(sizeof(lv), 16, "sizeof(STT6167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6167)");
    check_field_offset(lv, fa, 0, "STT6167.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6167");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6167");
    check_field_offset(lv, fb, 8, "STT6167.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6167, STT6167)
//============================================================================


struct  STT6177  {
  float fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT6177) C1{ Fi Fi:3 FL}



static void Test_STT6177()
{
  {
    init_simple_test("STT6177");
    static STRUCT_IF_C STT6177 lv;
    check2(sizeof(lv), 16, "sizeof(STT6177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6177)");
    check_field_offset(lv, fa, 0, "STT6177.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6177");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6177");
    check_field_offset(lv, fb, 8, "STT6177.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6177, STT6177)
//============================================================================


struct  STT6187  {
  float fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT6187) C1{ Fi FL:3 FL}



static void Test_STT6187()
{
  {
    init_simple_test("STT6187");
    static STRUCT_IF_C STT6187 lv;
    check2(sizeof(lv), 16, "sizeof(STT6187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6187)");
    check_field_offset(lv, fa, 0, "STT6187.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6187");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6187");
    check_field_offset(lv, fb, 8, "STT6187.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6187, STT6187)
//============================================================================


struct  STT6197  {
  float fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT6197) C1{ Fi Fs:8 FL}



static void Test_STT6197()
{
  {
    init_simple_test("STT6197");
    static STRUCT_IF_C STT6197 lv;
    check2(sizeof(lv), 16, "sizeof(STT6197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6197)");
    check_field_offset(lv, fa, 0, "STT6197.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6197");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6197");
    check_field_offset(lv, fb, 8, "STT6197.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6197, STT6197)
//============================================================================


struct  STT6207  {
  float fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT6207) C1{ Fi Fi:8 FL}



static void Test_STT6207()
{
  {
    init_simple_test("STT6207");
    static STRUCT_IF_C STT6207 lv;
    check2(sizeof(lv), 16, "sizeof(STT6207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6207)");
    check_field_offset(lv, fa, 0, "STT6207.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6207");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6207");
    check_field_offset(lv, fb, 8, "STT6207.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6207, STT6207)
//============================================================================


struct  STT6217  {
  float fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT6217) C1{ Fi FL:8 FL}



static void Test_STT6217()
{
  {
    init_simple_test("STT6217");
    static STRUCT_IF_C STT6217 lv;
    check2(sizeof(lv), 16, "sizeof(STT6217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6217)");
    check_field_offset(lv, fa, 0, "STT6217.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6217");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6217");
    check_field_offset(lv, fb, 8, "STT6217.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6217, STT6217)
//============================================================================


struct  STT6227  {
  float fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT6227) C1{ Fi Fi:18 FL}



static void Test_STT6227()
{
  {
    init_simple_test("STT6227");
    static STRUCT_IF_C STT6227 lv;
    check2(sizeof(lv), 16, "sizeof(STT6227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6227)");
    check_field_offset(lv, fa, 0, "STT6227.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6227");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6227");
    check_field_offset(lv, fb, 8, "STT6227.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6227, STT6227)
//============================================================================


struct  STT6237  {
  float fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT6237) C1{ Fi FL:18 FL}



static void Test_STT6237()
{
  {
    init_simple_test("STT6237");
    static STRUCT_IF_C STT6237 lv;
    check2(sizeof(lv), 16, "sizeof(STT6237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6237)");
    check_field_offset(lv, fa, 0, "STT6237.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6237");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6237");
    check_field_offset(lv, fb, 8, "STT6237.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6237, STT6237)
//============================================================================


struct  STT6247  {
  float fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT6247) C1{ Fi FL:48 FL}



static void Test_STT6247()
{
  {
    init_simple_test("STT6247");
    static STRUCT_IF_C STT6247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT6247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT6247)");
    check_field_offset(lv, fa, 0, "STT6247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT6247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT6247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6247.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6247, STT6247)
//============================================================================


struct  STT618  {
  float fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT618) C1{ Fi Fc:0 FD}



static void Test_STT618()
{
  {
    init_simple_test("STT618");
    static STRUCT_IF_C STT618 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT618)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT618)");
    check_field_offset(lv, fa, 0, "STT618.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT618.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT618, STT618)
//============================================================================


struct  STT628  {
  float fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT628) C1{ Fi Fs:0 FD}



static void Test_STT628()
{
  {
    init_simple_test("STT628");
    static STRUCT_IF_C STT628 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT628)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT628)");
    check_field_offset(lv, fa, 0, "STT628.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT628.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT628, STT628)
//============================================================================


struct  STT638  {
  float fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT638) C1{ Fi Fi:0 FD}



static void Test_STT638()
{
  {
    init_simple_test("STT638");
    static STRUCT_IF_C STT638 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT638)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT638)");
    check_field_offset(lv, fa, 0, "STT638.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT638.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT638, STT638)
//============================================================================


struct  STT648  {
  float fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT648) C1{ Fi FL:0 FD}



static void Test_STT648()
{
  {
    init_simple_test("STT648");
    static STRUCT_IF_C STT648 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT648)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT648)");
    check_field_offset(lv, fa, 0, "STT648.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT648.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT648, STT648)
//============================================================================


struct  STT658  {
  float fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT658) C1{ Fi Fc:3 FD}



static void Test_STT658()
{
  {
    init_simple_test("STT658");
    static STRUCT_IF_C STT658 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT658)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT658)");
    check_field_offset(lv, fa, 0, "STT658.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT658.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT658, STT658)
//============================================================================


struct  STT668  {
  float fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT668) C1{ Fi Fs:3 FD}



static void Test_STT668()
{
  {
    init_simple_test("STT668");
    static STRUCT_IF_C STT668 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT668)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT668)");
    check_field_offset(lv, fa, 0, "STT668.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT668.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT668, STT668)
//============================================================================


struct  STT678  {
  float fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT678) C1{ Fi Fi:3 FD}



static void Test_STT678()
{
  {
    init_simple_test("STT678");
    static STRUCT_IF_C STT678 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT678)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT678)");
    check_field_offset(lv, fa, 0, "STT678.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT678.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT678, STT678)
//============================================================================


struct  STT688  {
  float fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT688) C1{ Fi FL:3 FD}



static void Test_STT688()
{
  {
    init_simple_test("STT688");
    static STRUCT_IF_C STT688 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT688)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT688)");
    check_field_offset(lv, fa, 0, "STT688.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT688.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT688, STT688)
//============================================================================


struct  STT698  {
  float fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT698) C1{ Fi Fs:8 FD}



static void Test_STT698()
{
  {
    init_simple_test("STT698");
    static STRUCT_IF_C STT698 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT698)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT698)");
    check_field_offset(lv, fa, 0, "STT698.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT698.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT698, STT698)
//============================================================================


struct  STT6108  {
  float fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT6108) C1{ Fi Fi:8 FD}



static void Test_STT6108()
{
  {
    init_simple_test("STT6108");
    static STRUCT_IF_C STT6108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6108)");
    check_field_offset(lv, fa, 0, "STT6108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6108.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6108, STT6108)
//============================================================================


struct  STT6118  {
  float fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT6118) C1{ Fi FL:8 FD}



static void Test_STT6118()
{
  {
    init_simple_test("STT6118");
    static STRUCT_IF_C STT6118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6118)");
    check_field_offset(lv, fa, 0, "STT6118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6118.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6118, STT6118)
//============================================================================


struct  STT6128  {
  float fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT6128) C1{ Fi Fi:18 FD}



static void Test_STT6128()
{
  {
    init_simple_test("STT6128");
    static STRUCT_IF_C STT6128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6128)");
    check_field_offset(lv, fa, 0, "STT6128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6128.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6128, STT6128)
//============================================================================


struct  STT6138  {
  float fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT6138) C1{ Fi FL:18 FD}



static void Test_STT6138()
{
  {
    init_simple_test("STT6138");
    static STRUCT_IF_C STT6138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6138)");
    check_field_offset(lv, fa, 0, "STT6138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6138.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6138, STT6138)
//============================================================================


struct  STT6148  {
  float fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT6148) C1{ Fi FL:48 FD}



static void Test_STT6148()
{
  {
    init_simple_test("STT6148");
    static STRUCT_IF_C STT6148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT6148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6148)");
    check_field_offset(lv, fa, 0, "STT6148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT6148.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6148, STT6148)
//============================================================================


struct  STT6158  {
  float fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT6158) C1{ Fi Fc:3 FD}



static void Test_STT6158()
{
  {
    init_simple_test("STT6158");
    static STRUCT_IF_C STT6158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6158)");
    check_field_offset(lv, fa, 0, "STT6158.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6158");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6158.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6158, STT6158)
//============================================================================


struct  STT6168  {
  float fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT6168) C1{ Fi Fs:3 FD}



static void Test_STT6168()
{
  {
    init_simple_test("STT6168");
    static STRUCT_IF_C STT6168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6168)");
    check_field_offset(lv, fa, 0, "STT6168.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6168");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6168.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6168, STT6168)
//============================================================================


struct  STT6178  {
  float fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT6178) C1{ Fi Fi:3 FD}



static void Test_STT6178()
{
  {
    init_simple_test("STT6178");
    static STRUCT_IF_C STT6178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6178)");
    check_field_offset(lv, fa, 0, "STT6178.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6178");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6178.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6178, STT6178)
//============================================================================


struct  STT6188  {
  float fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT6188) C1{ Fi FL:3 FD}



static void Test_STT6188()
{
  {
    init_simple_test("STT6188");
    static STRUCT_IF_C STT6188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6188)");
    check_field_offset(lv, fa, 0, "STT6188.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT6188");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT6188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6188.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6188, STT6188)
//============================================================================


struct  STT6198  {
  float fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT6198) C1{ Fi Fs:8 FD}



static void Test_STT6198()
{
  {
    init_simple_test("STT6198");
    static STRUCT_IF_C STT6198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6198)");
    check_field_offset(lv, fa, 0, "STT6198.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6198");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6198.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6198, STT6198)
//============================================================================


struct  STT6208  {
  float fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT6208) C1{ Fi Fi:8 FD}



static void Test_STT6208()
{
  {
    init_simple_test("STT6208");
    static STRUCT_IF_C STT6208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6208)");
    check_field_offset(lv, fa, 0, "STT6208.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6208");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6208.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6208, STT6208)
//============================================================================


struct  STT6218  {
  float fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT6218) C1{ Fi FL:8 FD}



static void Test_STT6218()
{
  {
    init_simple_test("STT6218");
    static STRUCT_IF_C STT6218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6218)");
    check_field_offset(lv, fa, 0, "STT6218.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT6218");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT6218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6218.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6218, STT6218)
//============================================================================


struct  STT6228  {
  float fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT6228) C1{ Fi Fi:18 FD}



static void Test_STT6228()
{
  {
    init_simple_test("STT6228");
    static STRUCT_IF_C STT6228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT6228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT6228)");
    check_field_offset(lv, fa, 0, "STT6228.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT6228");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT6228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT6228.fb");
  }
}
ARRANGE_TO_CALL_ME(Test_STT6228, STT6228)
//============================================================================


struct  STT6238  {