// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu33_BFu0c_Vp  {
  __tsu64 v1:33;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu33_BFu0c_Vp) C1{ FL:33 Fc:0 Fp}



static void Test_BFu33_BFu0c_Vp()
{
  {
    init_simple_test("BFu33_BFu0c_Vp");
    static STRUCT_IF_C BFu33_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0c_Vp");
    check_field_offset(lv, v2, 8, "BFu33_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0c_Vp, BFu33_BFu0c_Vp)
//============================================================================


struct  BFu33_BFu0i  {
  __tsu64 v1:33;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu0i) C1{ FL:33 Fi:0}



static void Test_BFu33_BFu0i()
{
  {
    init_simple_test("BFu33_BFu0i");
    static STRUCT_IF_C BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i, BFu33_BFu0i)
//============================================================================


struct  BFu33_BFu0i_BFu0c  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu0i_BFu0c) C1{ FL:33 Fi:0 Fc:0}



static void Test_BFu33_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu0i_BFu0c");
    static STRUCT_IF_C BFu33_BFu0i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu0c, BFu33_BFu0i_BFu0c)
//============================================================================


struct  BFu33_BFu0i_BFu0i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu0i_BFu0i) C1{ FL:33 Fi:0 Fi:0}



static void Test_BFu33_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu0i");
    static STRUCT_IF_C BFu33_BFu0i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu0i, BFu33_BFu0i_BFu0i)
//============================================================================


struct  BFu33_BFu0i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu0i_BFu0ll) C1{ FL:33 Fi:0 FL:0}



static void Test_BFu33_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu0ll, BFu33_BFu0i_BFu0ll)
//============================================================================


struct  BFu33_BFu0i_BFu0s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu0i_BFu0s) C1{ FL:33 Fi:0 Fs:0}



static void Test_BFu33_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu0s");
    static STRUCT_IF_C BFu33_BFu0i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu0s, BFu33_BFu0i_BFu0s)
//============================================================================


struct  BFu33_BFu0i_BFu15i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu33_BFu0i_BFu15i) C1{ FL:33 Fi:0 Fi:15}



static void Test_BFu33_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu15i");
    static STRUCT_IF_C BFu33_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu33_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu15i, BFu33_BFu0i_BFu15i)
//============================================================================


struct  BFu33_BFu0i_BFu15ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu33_BFu0i_BFu15ll) C1{ FL:33 Fi:0 FL:15}



static void Test_BFu33_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu33_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu15ll, BFu33_BFu0i_BFu15ll)
//============================================================================


struct  BFu33_BFu0i_BFu15s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu33_BFu0i_BFu15s) C1{ FL:33 Fi:0 Fs:15}



static void Test_BFu33_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu15s");
    static STRUCT_IF_C BFu33_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu33_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu15s, BFu33_BFu0i_BFu15s)
//============================================================================


struct  BFu33_BFu0i_BFu16i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu33_BFu0i_BFu16i) C1{ FL:33 Fi:0 Fi:16}



static void Test_BFu33_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu16i");
    static STRUCT_IF_C BFu33_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu33_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu16i, BFu33_BFu0i_BFu16i)
//============================================================================


struct  BFu33_BFu0i_BFu16ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu33_BFu0i_BFu16ll) C1{ FL:33 Fi:0 FL:16}



static void Test_BFu33_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu33_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu16ll, BFu33_BFu0i_BFu16ll)
//============================================================================


struct  BFu33_BFu0i_BFu16s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu33_BFu0i_BFu16s) C1{ FL:33 Fi:0 Fs:16}



static void Test_BFu33_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu16s");
    static STRUCT_IF_C BFu33_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu33_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu16s, BFu33_BFu0i_BFu16s)
//============================================================================


struct  BFu33_BFu0i_BFu17i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu33_BFu0i_BFu17i) C1{ FL:33 Fi:0 Fi:17}



static void Test_BFu33_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu17i");
    static STRUCT_IF_C BFu33_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu33_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu33_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu17i, BFu33_BFu0i_BFu17i)
//============================================================================


struct  BFu33_BFu0i_BFu17ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu33_BFu0i_BFu17ll) C1{ FL:33 Fi:0 FL:17}



static void Test_BFu33_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu33_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu33_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu17ll, BFu33_BFu0i_BFu17ll)
//============================================================================


struct  BFu33_BFu0i_BFu1c  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu33_BFu0i_BFu1c) C1{ FL:33 Fi:0 Fc:1}



static void Test_BFu33_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu33_BFu0i_BFu1c");
    static STRUCT_IF_C BFu33_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu1c, BFu33_BFu0i_BFu1c)
//============================================================================


struct  BFu33_BFu0i_BFu1i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu33_BFu0i_BFu1i) C1{ FL:33 Fi:0 Fi:1}



static void Test_BFu33_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu1i");
    static STRUCT_IF_C BFu33_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu1i, BFu33_BFu0i_BFu1i)
//============================================================================


struct  BFu33_BFu0i_BFu1ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu33_BFu0i_BFu1ll) C1{ FL:33 Fi:0 FL:1}



static void Test_BFu33_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu1ll, BFu33_BFu0i_BFu1ll)
//============================================================================


struct  BFu33_BFu0i_BFu1s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu33_BFu0i_BFu1s) C1{ FL:33 Fi:0 Fs:1}



static void Test_BFu33_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu1s");
    static STRUCT_IF_C BFu33_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu1s, BFu33_BFu0i_BFu1s)
//============================================================================


struct  BFu33_BFu0i_BFu31i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu33_BFu0i_BFu31i) C1{ FL:33 Fi:0 Fi:31}



static void Test_BFu33_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu31i");
    static STRUCT_IF_C BFu33_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu33_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu33_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu31i, BFu33_BFu0i_BFu31i)
//============================================================================


struct  BFu33_BFu0i_BFu31ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu33_BFu0i_BFu31ll) C1{ FL:33 Fi:0 FL:31}



static void Test_BFu33_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu33_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu33_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu31ll, BFu33_BFu0i_BFu31ll)
//============================================================================


struct  BFu33_BFu0i_BFu32i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu33_BFu0i_BFu32i) C1{ FL:33 Fi:0 Fi:32}



static void Test_BFu33_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu32i");
    static STRUCT_IF_C BFu33_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu32i, BFu33_BFu0i_BFu32i)
//============================================================================


struct  BFu33_BFu0i_BFu32ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu33_BFu0i_BFu32ll) C1{ FL:33 Fi:0 FL:32}



static void Test_BFu33_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu32ll, BFu33_BFu0i_BFu32ll)
//============================================================================


struct  BFu33_BFu0i_BFu33  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu33_BFu0i_BFu33) C1{ FL:33 Fi:0 FL:33}



static void Test_BFu33_BFu0i_BFu33()
{
  {
    init_simple_test("BFu33_BFu0i_BFu33");
    static STRUCT_IF_C BFu33_BFu0i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu33_BFu0i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu33, BFu33_BFu0i_BFu33)
//============================================================================


struct  BFu33_BFu0i_BFu7c  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu33_BFu0i_BFu7c) C1{ FL:33 Fi:0 Fc:7}



static void Test_BFu33_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu33_BFu0i_BFu7c");
    static STRUCT_IF_C BFu33_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu7c, BFu33_BFu0i_BFu7c)
//============================================================================


struct  BFu33_BFu0i_BFu7i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu33_BFu0i_BFu7i) C1{ FL:33 Fi:0 Fi:7}



static void Test_BFu33_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu7i");
    static STRUCT_IF_C BFu33_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu7i, BFu33_BFu0i_BFu7i)
//============================================================================


struct  BFu33_BFu0i_BFu7ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu33_BFu0i_BFu7ll) C1{ FL:33 Fi:0 FL:7}



static void Test_BFu33_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu7ll, BFu33_BFu0i_BFu7ll)
//============================================================================


struct  BFu33_BFu0i_BFu7s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu33_BFu0i_BFu7s) C1{ FL:33 Fi:0 Fs:7}



static void Test_BFu33_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu7s");
    static STRUCT_IF_C BFu33_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu7s, BFu33_BFu0i_BFu7s)
//============================================================================


struct  BFu33_BFu0i_BFu8c  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu33_BFu0i_BFu8c) C1{ FL:33 Fi:0 Fc:8}



static void Test_BFu33_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu33_BFu0i_BFu8c");
    static STRUCT_IF_C BFu33_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu8c, BFu33_BFu0i_BFu8c)
//============================================================================


struct  BFu33_BFu0i_BFu8i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu33_BFu0i_BFu8i) C1{ FL:33 Fi:0 Fi:8}



static void Test_BFu33_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu8i");
    static STRUCT_IF_C BFu33_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu8i, BFu33_BFu0i_BFu8i)
//============================================================================


struct  BFu33_BFu0i_BFu8ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu33_BFu0i_BFu8ll) C1{ FL:33 Fi:0 FL:8}



static void Test_BFu33_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu8ll, BFu33_BFu0i_BFu8ll)
//============================================================================


struct  BFu33_BFu0i_BFu8s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu33_BFu0i_BFu8s) C1{ FL:33 Fi:0 Fs:8}



static void Test_BFu33_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu8s");
    static STRUCT_IF_C BFu33_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu8s, BFu33_BFu0i_BFu8s)
//============================================================================


struct  BFu33_BFu0i_BFu9i  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu33_BFu0i_BFu9i) C1{ FL:33 Fi:0 Fi:9}



static void Test_BFu33_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu33_BFu0i_BFu9i");
    static STRUCT_IF_C BFu33_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu33_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu9i, BFu33_BFu0i_BFu9i)
//============================================================================


struct  BFu33_BFu0i_BFu9ll  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu33_BFu0i_BFu9ll) C1{ FL:33 Fi:0 FL:9}



static void Test_BFu33_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu33_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu33_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu33_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu9ll, BFu33_BFu0i_BFu9ll)
//============================================================================


struct  BFu33_BFu0i_BFu9s  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu33_BFu0i_BFu9s) C1{ FL:33 Fi:0 Fs:9}



static void Test_BFu33_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu33_BFu0i_BFu9s");
    static STRUCT_IF_C BFu33_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu33_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_BFu9s, BFu33_BFu0i_BFu9s)
//============================================================================


struct  BFu33_BFu0i_C  {
  __tsu64 v1:33;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu33_BFu0i_C) C1{ FL:33 Fi:0 Fc}



static void Test_BFu33_BFu0i_C()
{
  {
    init_simple_test("BFu33_BFu0i_C");
    static STRUCT_IF_C BFu33_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_C");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_C, BFu33_BFu0i_C)
//============================================================================


struct  BFu33_BFu0i_D  {
  __tsu64 v1:33;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu33_BFu0i_D) C1{ FL:33 Fi:0 FL}



static void Test_BFu33_BFu0i_D()
{
  {
    init_simple_test("BFu33_BFu0i_D");
    static STRUCT_IF_C BFu33_BFu0i_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_D");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_D, BFu33_BFu0i_D)
//============================================================================


struct  BFu33_BFu0i_F  {
  __tsu64 v1:33;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu33_BFu0i_F) C1{ FL:33 Fi:0 Fi}



static void Test_BFu33_BFu0i_F()
{
  {
    init_simple_test("BFu33_BFu0i_F");
    static STRUCT_IF_C BFu33_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_F");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_F, BFu33_BFu0i_F)
//============================================================================


struct  BFu33_BFu0i_I  {
  __tsu64 v1:33;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu33_BFu0i_I) C1{ FL:33 Fi:0 Fi}



static void Test_BFu33_BFu0i_I()
{
  {
    init_simple_test("BFu33_BFu0i_I");
    static STRUCT_IF_C BFu33_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_I");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_I, BFu33_BFu0i_I)
//============================================================================


struct  BFu33_BFu0i_Ip  {
  __tsu64 v1:33;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu33_BFu0i_Ip) C1{ FL:33 Fi:0 Fp}



static void Test_BFu33_BFu0i_Ip()
{
  {
    init_simple_test("BFu33_BFu0i_Ip");
    static STRUCT_IF_C BFu33_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_Ip");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_Ip, BFu33_BFu0i_Ip)
//============================================================================


struct  BFu33_BFu0i_L  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu33_BFu0i_L) C1{ FL:33 Fi:0 FL}



static void Test_BFu33_BFu0i_L()
{
  {
    init_simple_test("BFu33_BFu0i_L");
    static STRUCT_IF_C BFu33_BFu0i_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_L");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_L, BFu33_BFu0i_L)
//============================================================================


struct  BFu33_BFu0i_S  {
  __tsu64 v1:33;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu33_BFu0i_S) C1{ FL:33 Fi:0 Fs}



static void Test_BFu33_BFu0i_S()
{
  {
    init_simple_test("BFu33_BFu0i_S");
    static STRUCT_IF_C BFu33_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_S");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_S, BFu33_BFu0i_S)
//============================================================================


struct  BFu33_BFu0i_Uc  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu33_BFu0i_Uc) C1{ FL:33 Fi:0 Fc}



static void Test_BFu33_BFu0i_Uc()
{
  {
    init_simple_test("BFu33_BFu0i_Uc");
    static STRUCT_IF_C BFu33_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_Uc");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_Uc, BFu33_BFu0i_Uc)
//============================================================================


struct  BFu33_BFu0i_Ui  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu33_BFu0i_Ui) C1{ FL:33 Fi:0 Fi}



static void Test_BFu33_BFu0i_Ui()
{
  {
    init_simple_test("BFu33_BFu0i_Ui");
    static STRUCT_IF_C BFu33_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_Ui");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_Ui, BFu33_BFu0i_Ui)
//============================================================================


struct  BFu33_BFu0i_Ul  {
  __tsu64 v1:33;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu33_BFu0i_Ul) C1{ FL:33 Fi:0 FL}



static void Test_BFu33_BFu0i_Ul()
{
  {
    init_simple_test("BFu33_BFu0i_Ul");
    static STRUCT_IF_C BFu33_BFu0i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_Ul");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_Ul, BFu33_BFu0i_Ul)
//============================================================================


struct  BFu33_BFu0i_Us  {
  __tsu64 v1:33;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu33_BFu0i_Us) C1{ FL:33 Fi:0 Fs}



static void Test_BFu33_BFu0i_Us()
{
  {
    init_simple_test("BFu33_BFu0i_Us");
    static STRUCT_IF_C BFu33_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_Us");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_Us, BFu33_BFu0i_Us)
//============================================================================


struct  BFu33_BFu0i_Vp  {
  __tsu64 v1:33;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu33_BFu0i_Vp) C1{ FL:33 Fi:0 Fp}



static void Test_BFu33_BFu0i_Vp()
{
  {
    init_simple_test("BFu33_BFu0i_Vp");
    static STRUCT_IF_C BFu33_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0i_Vp");
    check_field_offset(lv, v2, 8, "BFu33_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0i_Vp, BFu33_BFu0i_Vp)
//============================================================================


struct  BFu33_BFu0ll  {
  __tsu64 v1:33;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu0ll) C1{ FL:33 FL:0}



static void Test_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu0ll");
    static STRUCT_IF_C BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll, BFu33_BFu0ll)
//============================================================================


struct  BFu33_BFu0ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu0ll_BFu0c) C1{ FL:33 FL:0 Fc:0}



static void Test_BFu33_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu0c, BFu33_BFu0ll_BFu0c)
//============================================================================


struct  BFu33_BFu0ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu0ll_BFu0i) C1{ FL:33 FL:0 Fi:0}



static void Test_BFu33_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu0i, BFu33_BFu0ll_BFu0i)
//============================================================================


struct  BFu33_BFu0ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu0ll_BFu0ll) C1{ FL:33 FL:0 FL:0}



static void Test_BFu33_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu0ll, BFu33_BFu0ll_BFu0ll)
//============================================================================


struct  BFu33_BFu0ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu0ll_BFu0s) C1{ FL:33 FL:0 Fs:0}



static void Test_BFu33_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu0s, BFu33_BFu0ll_BFu0s)
//============================================================================


struct  BFu33_BFu0ll_BFu15i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu33_BFu0ll_BFu15i) C1{ FL:33 FL:0 Fi:15}



static void Test_BFu33_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu33_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu15i, BFu33_BFu0ll_BFu15i)
//============================================================================


struct  BFu33_BFu0ll_BFu15ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu33_BFu0ll_BFu15ll) C1{ FL:33 FL:0 FL:15}



static void Test_BFu33_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu33_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu15ll, BFu33_BFu0ll_BFu15ll)
//============================================================================


struct  BFu33_BFu0ll_BFu15s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu33_BFu0ll_BFu15s) C1{ FL:33 FL:0 Fs:15}



static void Test_BFu33_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu33_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu15s, BFu33_BFu0ll_BFu15s)
//============================================================================


struct  BFu33_BFu0ll_BFu16i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu33_BFu0ll_BFu16i) C1{ FL:33 FL:0 Fi:16}



static void Test_BFu33_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu33_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu16i, BFu33_BFu0ll_BFu16i)
//============================================================================


struct  BFu33_BFu0ll_BFu16ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu33_BFu0ll_BFu16ll) C1{ FL:33 FL:0 FL:16}



static void Test_BFu33_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu33_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu16ll, BFu33_BFu0ll_BFu16ll)
//============================================================================


struct  BFu33_BFu0ll_BFu16s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu33_BFu0ll_BFu16s) C1{ FL:33 FL:0 Fs:16}



static void Test_BFu33_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu33_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu16s, BFu33_BFu0ll_BFu16s)
//============================================================================


struct  BFu33_BFu0ll_BFu17i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu33_BFu0ll_BFu17i) C1{ FL:33 FL:0 Fi:17}



static void Test_BFu33_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu33_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu33_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu17i, BFu33_BFu0ll_BFu17i)
//============================================================================


struct  BFu33_BFu0ll_BFu17ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu33_BFu0ll_BFu17ll) C1{ FL:33 FL:0 FL:17}



static void Test_BFu33_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu33_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu33_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu17ll, BFu33_BFu0ll_BFu17ll)
//============================================================================


struct  BFu33_BFu0ll_BFu1c  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu33_BFu0ll_BFu1c) C1{ FL:33 FL:0 Fc:1}



static void Test_BFu33_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu33_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu1c, BFu33_BFu0ll_BFu1c)
//============================================================================


struct  BFu33_BFu0ll_BFu1i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu33_BFu0ll_BFu1i) C1{ FL:33 FL:0 Fi:1}



static void Test_BFu33_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu1i, BFu33_BFu0ll_BFu1i)
//============================================================================


struct  BFu33_BFu0ll_BFu1ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu33_BFu0ll_BFu1ll) C1{ FL:33 FL:0 FL:1}



static void Test_BFu33_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu1ll, BFu33_BFu0ll_BFu1ll)
//============================================================================


struct  BFu33_BFu0ll_BFu1s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu33_BFu0ll_BFu1s) C1{ FL:33 FL:0 Fs:1}



static void Test_BFu33_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu33_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu1s, BFu33_BFu0ll_BFu1s)
//============================================================================


struct  BFu33_BFu0ll_BFu31i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu33_BFu0ll_BFu31i) C1{ FL:33 FL:0 Fi:31}



static void Test_BFu33_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu33_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu33_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu31i, BFu33_BFu0ll_BFu31i)
//============================================================================


struct  BFu33_BFu0ll_BFu31ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu33_BFu0ll_BFu31ll) C1{ FL:33 FL:0 FL:31}



static void Test_BFu33_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu33_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu33_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu31ll, BFu33_BFu0ll_BFu31ll)
//============================================================================


struct  BFu33_BFu0ll_BFu32i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu33_BFu0ll_BFu32i) C1{ FL:33 FL:0 Fi:32}



static void Test_BFu33_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu32i, BFu33_BFu0ll_BFu32i)
//============================================================================


struct  BFu33_BFu0ll_BFu32ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu33_BFu0ll_BFu32ll) C1{ FL:33 FL:0 FL:32}



static void Test_BFu33_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu32ll, BFu33_BFu0ll_BFu32ll)
//============================================================================


struct  BFu33_BFu0ll_BFu33  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu33_BFu0ll_BFu33) C1{ FL:33 FL:0 FL:33}



static void Test_BFu33_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu33");
    static STRUCT_IF_C BFu33_BFu0ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu33_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu33, BFu33_BFu0ll_BFu33)
//============================================================================


struct  BFu33_BFu0ll_BFu7c  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu33_BFu0ll_BFu7c) C1{ FL:33 FL:0 Fc:7}



static void Test_BFu33_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu33_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu7c, BFu33_BFu0ll_BFu7c)
//============================================================================


struct  BFu33_BFu0ll_BFu7i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu33_BFu0ll_BFu7i) C1{ FL:33 FL:0 Fi:7}



static void Test_BFu33_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu7i, BFu33_BFu0ll_BFu7i)
//============================================================================


struct  BFu33_BFu0ll_BFu7ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu33_BFu0ll_BFu7ll) C1{ FL:33 FL:0 FL:7}



static void Test_BFu33_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu7ll, BFu33_BFu0ll_BFu7ll)
//============================================================================


struct  BFu33_BFu0ll_BFu7s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu33_BFu0ll_BFu7s) C1{ FL:33 FL:0 Fs:7}



static void Test_BFu33_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu33_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu7s, BFu33_BFu0ll_BFu7s)
//============================================================================


struct  BFu33_BFu0ll_BFu8c  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu33_BFu0ll_BFu8c) C1{ FL:33 FL:0 Fc:8}



static void Test_BFu33_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu33_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu8c, BFu33_BFu0ll_BFu8c)
//============================================================================


struct  BFu33_BFu0ll_BFu8i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu33_BFu0ll_BFu8i) C1{ FL:33 FL:0 Fi:8}



static void Test_BFu33_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu8i, BFu33_BFu0ll_BFu8i)
//============================================================================


struct  BFu33_BFu0ll_BFu8ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu33_BFu0ll_BFu8ll) C1{ FL:33 FL:0 FL:8}



static void Test_BFu33_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu8ll, BFu33_BFu0ll_BFu8ll)
//============================================================================


struct  BFu33_BFu0ll_BFu8s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu33_BFu0ll_BFu8s) C1{ FL:33 FL:0 Fs:8}



static void Test_BFu33_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu33_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu8s, BFu33_BFu0ll_BFu8s)
//============================================================================


struct  BFu33_BFu0ll_BFu9i  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu33_BFu0ll_BFu9i) C1{ FL:33 FL:0 Fi:9}



static void Test_BFu33_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu33_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu33_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu9i, BFu33_BFu0ll_BFu9i)
//============================================================================


struct  BFu33_BFu0ll_BFu9ll  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu33_BFu0ll_BFu9ll) C1{ FL:33 FL:0 FL:9}



static void Test_BFu33_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu33_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu33_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu9ll, BFu33_BFu0ll_BFu9ll)
//============================================================================


struct  BFu33_BFu0ll_BFu9s  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu33_BFu0ll_BFu9s) C1{ FL:33 FL:0 Fs:9}



static void Test_BFu33_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu33_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu33_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu33_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_BFu9s, BFu33_BFu0ll_BFu9s)
//============================================================================


struct  BFu33_BFu0ll_C  {
  __tsu64 v1:33;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu33_BFu0ll_C) C1{ FL:33 FL:0 Fc}



static void Test_BFu33_BFu0ll_C()
{
  {
    init_simple_test("BFu33_BFu0ll_C");
    static STRUCT_IF_C BFu33_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_C");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_C, BFu33_BFu0ll_C)
//============================================================================


struct  BFu33_BFu0ll_D  {
  __tsu64 v1:33;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu33_BFu0ll_D) C1{ FL:33 FL:0 FL}



static void Test_BFu33_BFu0ll_D()
{
  {
    init_simple_test("BFu33_BFu0ll_D");
    static STRUCT_IF_C BFu33_BFu0ll_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_D");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_D, BFu33_BFu0ll_D)
//============================================================================


struct  BFu33_BFu0ll_F  {
  __tsu64 v1:33;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu33_BFu0ll_F) C1{ FL:33 FL:0 Fi}



static void Test_BFu33_BFu0ll_F()
{
  {
    init_simple_test("BFu33_BFu0ll_F");
    static STRUCT_IF_C BFu33_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_F");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_F, BFu33_BFu0ll_F)
//============================================================================


struct  BFu33_BFu0ll_I  {
  __tsu64 v1:33;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu33_BFu0ll_I) C1{ FL:33 FL:0 Fi}



static void Test_BFu33_BFu0ll_I()
{
  {
    init_simple_test("BFu33_BFu0ll_I");
    static STRUCT_IF_C BFu33_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_I");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_I, BFu33_BFu0ll_I)
//============================================================================


struct  BFu33_BFu0ll_Ip  {
  __tsu64 v1:33;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu33_BFu0ll_Ip) C1{ FL:33 FL:0 Fp}



static void Test_BFu33_BFu0ll_Ip()
{
  {
    init_simple_test("BFu33_BFu0ll_Ip");
    static STRUCT_IF_C BFu33_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_Ip");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_Ip, BFu33_BFu0ll_Ip)
//============================================================================


struct  BFu33_BFu0ll_L  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu33_BFu0ll_L) C1{ FL:33 FL:0 FL}



static void Test_BFu33_BFu0ll_L()
{
  {
    init_simple_test("BFu33_BFu0ll_L");
    static STRUCT_IF_C BFu33_BFu0ll_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_L");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_L, BFu33_BFu0ll_L)
//============================================================================


struct  BFu33_BFu0ll_S  {
  __tsu64 v1:33;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu33_BFu0ll_S) C1{ FL:33 FL:0 Fs}



static void Test_BFu33_BFu0ll_S()
{
  {
    init_simple_test("BFu33_BFu0ll_S");
    static STRUCT_IF_C BFu33_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_S");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_S, BFu33_BFu0ll_S)
//============================================================================


struct  BFu33_BFu0ll_Uc  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu33_BFu0ll_Uc) C1{ FL:33 FL:0 Fc}



static void Test_BFu33_BFu0ll_Uc()
{
  {
    init_simple_test("BFu33_BFu0ll_Uc");
    static STRUCT_IF_C BFu33_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_Uc");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_Uc, BFu33_BFu0ll_Uc)
//============================================================================


struct  BFu33_BFu0ll_Ui  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu33_BFu0ll_Ui) C1{ FL:33 FL:0 Fi}



static void Test_BFu33_BFu0ll_Ui()
{
  {
    init_simple_test("BFu33_BFu0ll_Ui");
    static STRUCT_IF_C BFu33_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_Ui");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_Ui, BFu33_BFu0ll_Ui)
//============================================================================


struct  BFu33_BFu0ll_Ul  {
  __tsu64 v1:33;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu33_BFu0ll_Ul) C1{ FL:33 FL:0 FL}



static void Test_BFu33_BFu0ll_Ul()
{
  {
    init_simple_test("BFu33_BFu0ll_Ul");
    static STRUCT_IF_C BFu33_BFu0ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_Ul");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_Ul, BFu33_BFu0ll_Ul)
//============================================================================


struct  BFu33_BFu0ll_Us  {
  __tsu64 v1:33;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu33_BFu0ll_Us) C1{ FL:33 FL:0 Fs}



static void Test_BFu33_BFu0ll_Us()
{
  {
    init_simple_test("BFu33_BFu0ll_Us");
    static STRUCT_IF_C BFu33_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_Us");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_Us, BFu33_BFu0ll_Us)
//============================================================================


struct  BFu33_BFu0ll_Vp  {
  __tsu64 v1:33;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu33_BFu0ll_Vp) C1{ FL:33 FL:0 Fp}



static void Test_BFu33_BFu0ll_Vp()
{
  {
    init_simple_test("BFu33_BFu0ll_Vp");
    static STRUCT_IF_C BFu33_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0ll_Vp");
    check_field_offset(lv, v2, 8, "BFu33_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0ll_Vp, BFu33_BFu0ll_Vp)
//============================================================================


struct  BFu33_BFu0s  {
  __tsu64 v1:33;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu0s) C1{ FL:33 Fs:0}



static void Test_BFu33_BFu0s()
{
  {
    init_simple_test("BFu33_BFu0s");
    static STRUCT_IF_C BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s, BFu33_BFu0s)
//============================================================================


struct  BFu33_BFu0s_BFu0c  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu0s_BFu0c) C1{ FL:33 Fs:0 Fc:0}



static void Test_BFu33_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu0s_BFu0c");
    static STRUCT_IF_C BFu33_BFu0s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu0c, BFu33_BFu0s_BFu0c)
//============================================================================


struct  BFu33_BFu0s_BFu0i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu0s_BFu0i) C1{ FL:33 Fs:0 Fi:0}



static void Test_BFu33_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu0i");
    static STRUCT_IF_C BFu33_BFu0s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu0i, BFu33_BFu0s_BFu0i)
//============================================================================


struct  BFu33_BFu0s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu0s_BFu0ll) C1{ FL:33 Fs:0 FL:0}



static void Test_BFu33_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu0ll, BFu33_BFu0s_BFu0ll)
//============================================================================


struct  BFu33_BFu0s_BFu0s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu0s_BFu0s) C1{ FL:33 Fs:0 Fs:0}



static void Test_BFu33_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu0s");
    static STRUCT_IF_C BFu33_BFu0s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu0s, BFu33_BFu0s_BFu0s)
//============================================================================


struct  BFu33_BFu0s_BFu15i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu33_BFu0s_BFu15i) C1{ FL:33 Fs:0 Fi:15}



static void Test_BFu33_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu15i");
    static STRUCT_IF_C BFu33_BFu0s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 6, 0, 15, 1, "BFu33_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 6, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu15i, BFu33_BFu0s_BFu15i)
//============================================================================


struct  BFu33_BFu0s_BFu15ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu33_BFu0s_BFu15ll) C1{ FL:33 Fs:0 FL:15}



static void Test_BFu33_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 6, 0, 15, 1, "BFu33_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 6, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu15ll, BFu33_BFu0s_BFu15ll)
//============================================================================


struct  BFu33_BFu0s_BFu15s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu33_BFu0s_BFu15s) C1{ FL:33 Fs:0 Fs:15}



static void Test_BFu33_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu15s");
    static STRUCT_IF_C BFu33_BFu0s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 6, 0, 15, 1, "BFu33_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 6, 0, 15, hide_ull(1LL<<14), "BFu33_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu15s, BFu33_BFu0s_BFu15s)
//============================================================================


struct  BFu33_BFu0s_BFu16i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu33_BFu0s_BFu16i) C1{ FL:33 Fs:0 Fi:16}



static void Test_BFu33_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu16i");
    static STRUCT_IF_C BFu33_BFu0s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu16i, BFu33_BFu0s_BFu16i)
//============================================================================


struct  BFu33_BFu0s_BFu16ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu33_BFu0s_BFu16ll) C1{ FL:33 Fs:0 FL:16}



static void Test_BFu33_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu16ll, BFu33_BFu0s_BFu16ll)
//============================================================================


struct  BFu33_BFu0s_BFu16s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu33_BFu0s_BFu16s) C1{ FL:33 Fs:0 Fs:16}



static void Test_BFu33_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu16s");
    static STRUCT_IF_C BFu33_BFu0s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu16s, BFu33_BFu0s_BFu16s)
//============================================================================


struct  BFu33_BFu0s_BFu17i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu33_BFu0s_BFu17i) C1{ FL:33 Fs:0 Fi:17}



static void Test_BFu33_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu17i");
    static STRUCT_IF_C BFu33_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu33_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu33_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu17i, BFu33_BFu0s_BFu17i)
//============================================================================


struct  BFu33_BFu0s_BFu17ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu33_BFu0s_BFu17ll) C1{ FL:33 Fs:0 FL:17}



static void Test_BFu33_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 17, 1, "BFu33_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "BFu33_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu17ll, BFu33_BFu0s_BFu17ll)
//============================================================================


struct  BFu33_BFu0s_BFu1c  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu33_BFu0s_BFu1c) C1{ FL:33 Fs:0 Fc:1}



static void Test_BFu33_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu33_BFu0s_BFu1c");
    static STRUCT_IF_C BFu33_BFu0s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 6, 0, 1, 1, "BFu33_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu1c, BFu33_BFu0s_BFu1c)
//============================================================================


struct  BFu33_BFu0s_BFu1i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu33_BFu0s_BFu1i) C1{ FL:33 Fs:0 Fi:1}



static void Test_BFu33_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu1i");
    static STRUCT_IF_C BFu33_BFu0s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 6, 0, 1, 1, "BFu33_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu1i, BFu33_BFu0s_BFu1i)
//============================================================================


struct  BFu33_BFu0s_BFu1ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu33_BFu0s_BFu1ll) C1{ FL:33 Fs:0 FL:1}



static void Test_BFu33_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 6, 0, 1, 1, "BFu33_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu1ll, BFu33_BFu0s_BFu1ll)
//============================================================================


struct  BFu33_BFu0s_BFu1s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu33_BFu0s_BFu1s) C1{ FL:33 Fs:0 Fs:1}



static void Test_BFu33_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu1s");
    static STRUCT_IF_C BFu33_BFu0s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 6, 0, 1, 1, "BFu33_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu1s, BFu33_BFu0s_BFu1s)
//============================================================================


struct  BFu33_BFu0s_BFu31i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu33_BFu0s_BFu31i) C1{ FL:33 Fs:0 Fi:31}



static void Test_BFu33_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu31i");
    static STRUCT_IF_C BFu33_BFu0s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu33_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu33_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu31i, BFu33_BFu0s_BFu31i)
//============================================================================


struct  BFu33_BFu0s_BFu31ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu33_BFu0s_BFu31ll) C1{ FL:33 Fs:0 FL:31}



static void Test_BFu33_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 31, 1, "BFu33_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "BFu33_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu31ll, BFu33_BFu0s_BFu31ll)
//============================================================================


struct  BFu33_BFu0s_BFu32i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu33_BFu0s_BFu32i) C1{ FL:33 Fs:0 Fi:32}



static void Test_BFu33_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu32i");
    static STRUCT_IF_C BFu33_BFu0s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu32i, BFu33_BFu0s_BFu32i)
//============================================================================


struct  BFu33_BFu0s_BFu32ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu33_BFu0s_BFu32ll) C1{ FL:33 Fs:0 FL:32}



static void Test_BFu33_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 32, 1, "BFu33_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "BFu33_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu32ll, BFu33_BFu0s_BFu32ll)
//============================================================================


struct  BFu33_BFu0s_BFu33  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu33_BFu0s_BFu33) C1{ FL:33 Fs:0 FL:33}



static void Test_BFu33_BFu0s_BFu33()
{
  {
    init_simple_test("BFu33_BFu0s_BFu33");
    static STRUCT_IF_C BFu33_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 33, 1, "BFu33_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu33, BFu33_BFu0s_BFu33)
//============================================================================


struct  BFu33_BFu0s_BFu7c  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu33_BFu0s_BFu7c) C1{ FL:33 Fs:0 Fc:7}



static void Test_BFu33_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu33_BFu0s_BFu7c");
    static STRUCT_IF_C BFu33_BFu0s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 6, 0, 7, 1, "BFu33_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 6, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu7c, BFu33_BFu0s_BFu7c)
//============================================================================


struct  BFu33_BFu0s_BFu7i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu33_BFu0s_BFu7i) C1{ FL:33 Fs:0 Fi:7}



static void Test_BFu33_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu7i");
    static STRUCT_IF_C BFu33_BFu0s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 6, 0, 7, 1, "BFu33_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 6, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu7i, BFu33_BFu0s_BFu7i)
//============================================================================


struct  BFu33_BFu0s_BFu7ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu33_BFu0s_BFu7ll) C1{ FL:33 Fs:0 FL:7}



static void Test_BFu33_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 6, 0, 7, 1, "BFu33_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 6, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu7ll, BFu33_BFu0s_BFu7ll)
//============================================================================


struct  BFu33_BFu0s_BFu7s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu33_BFu0s_BFu7s) C1{ FL:33 Fs:0 Fs:7}



static void Test_BFu33_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu7s");
    static STRUCT_IF_C BFu33_BFu0s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 6, 0, 7, 1, "BFu33_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 6, 0, 7, hide_ull(1LL<<6), "BFu33_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu7s, BFu33_BFu0s_BFu7s)
//============================================================================


struct  BFu33_BFu0s_BFu8c  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu33_BFu0s_BFu8c) C1{ FL:33 Fs:0 Fc:8}



static void Test_BFu33_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu33_BFu0s_BFu8c");
    static STRUCT_IF_C BFu33_BFu0s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 6, 0, 8, 1, "BFu33_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 6, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu8c, BFu33_BFu0s_BFu8c)
//============================================================================


struct  BFu33_BFu0s_BFu8i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu33_BFu0s_BFu8i) C1{ FL:33 Fs:0 Fi:8}



static void Test_BFu33_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu8i");
    static STRUCT_IF_C BFu33_BFu0s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 6, 0, 8, 1, "BFu33_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 6, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu8i, BFu33_BFu0s_BFu8i)
//============================================================================


struct  BFu33_BFu0s_BFu8ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu33_BFu0s_BFu8ll) C1{ FL:33 Fs:0 FL:8}



static void Test_BFu33_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 6, 0, 8, 1, "BFu33_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 6, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu8ll, BFu33_BFu0s_BFu8ll)
//============================================================================


struct  BFu33_BFu0s_BFu8s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu33_BFu0s_BFu8s) C1{ FL:33 Fs:0 Fs:8}



static void Test_BFu33_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu8s");
    static STRUCT_IF_C BFu33_BFu0s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 6, 0, 8, 1, "BFu33_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 6, 0, 8, hide_ull(1LL<<7), "BFu33_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu8s, BFu33_BFu0s_BFu8s)
//============================================================================


struct  BFu33_BFu0s_BFu9i  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu33_BFu0s_BFu9i) C1{ FL:33 Fs:0 Fi:9}



static void Test_BFu33_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu33_BFu0s_BFu9i");
    static STRUCT_IF_C BFu33_BFu0s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 6, 0, 9, 1, "BFu33_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 6, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu9i, BFu33_BFu0s_BFu9i)
//============================================================================


struct  BFu33_BFu0s_BFu9ll  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu33_BFu0s_BFu9ll) C1{ FL:33 Fs:0 FL:9}



static void Test_BFu33_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu33_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu33_BFu0s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 6, 0, 9, 1, "BFu33_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 6, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu9ll, BFu33_BFu0s_BFu9ll)
//============================================================================


struct  BFu33_BFu0s_BFu9s  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu33_BFu0s_BFu9s) C1{ FL:33 Fs:0 Fs:9}



static void Test_BFu33_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu33_BFu0s_BFu9s");
    static STRUCT_IF_C BFu33_BFu0s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 6, 0, 9, 1, "BFu33_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 6, 0, 9, hide_ull(1LL<<8), "BFu33_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_BFu9s, BFu33_BFu0s_BFu9s)
//============================================================================


struct  BFu33_BFu0s_C  {
  __tsu64 v1:33;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu33_BFu0s_C) C1{ FL:33 Fs:0 Fc}



static void Test_BFu33_BFu0s_C()
{
  {
    init_simple_test("BFu33_BFu0s_C");
    static STRUCT_IF_C BFu33_BFu0s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_C");
    check_field_offset(lv, v2, 6, "BFu33_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_C, BFu33_BFu0s_C)
//============================================================================


struct  BFu33_BFu0s_D  {
  __tsu64 v1:33;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu33_BFu0s_D) C1{ FL:33 Fs:0 FL}



static void Test_BFu33_BFu0s_D()
{
  {
    init_simple_test("BFu33_BFu0s_D");
    static STRUCT_IF_C BFu33_BFu0s_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_D");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_D, BFu33_BFu0s_D)
//============================================================================


struct  BFu33_BFu0s_F  {
  __tsu64 v1:33;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu33_BFu0s_F) C1{ FL:33 Fs:0 Fi}



static void Test_BFu33_BFu0s_F()
{
  {
    init_simple_test("BFu33_BFu0s_F");
    static STRUCT_IF_C BFu33_BFu0s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_F");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_F, BFu33_BFu0s_F)
//============================================================================


struct  BFu33_BFu0s_I  {
  __tsu64 v1:33;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu33_BFu0s_I) C1{ FL:33 Fs:0 Fi}



static void Test_BFu33_BFu0s_I()
{
  {
    init_simple_test("BFu33_BFu0s_I");
    static STRUCT_IF_C BFu33_BFu0s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_I");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_I, BFu33_BFu0s_I)
//============================================================================


struct  BFu33_BFu0s_Ip  {
  __tsu64 v1:33;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu33_BFu0s_Ip) C1{ FL:33 Fs:0 Fp}



static void Test_BFu33_BFu0s_Ip()
{
  {
    init_simple_test("BFu33_BFu0s_Ip");
    static STRUCT_IF_C BFu33_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_Ip");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_Ip, BFu33_BFu0s_Ip)
//============================================================================


struct  BFu33_BFu0s_L  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu33_BFu0s_L) C1{ FL:33 Fs:0 FL}



static void Test_BFu33_BFu0s_L()
{
  {
    init_simple_test("BFu33_BFu0s_L");
    static STRUCT_IF_C BFu33_BFu0s_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_L");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_L, BFu33_BFu0s_L)
//============================================================================


struct  BFu33_BFu0s_S  {
  __tsu64 v1:33;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu33_BFu0s_S) C1{ FL:33 Fs:0 Fs}



static void Test_BFu33_BFu0s_S()
{
  {
    init_simple_test("BFu33_BFu0s_S");
    static STRUCT_IF_C BFu33_BFu0s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_S");
    check_field_offset(lv, v2, 6, "BFu33_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_S, BFu33_BFu0s_S)
//============================================================================


struct  BFu33_BFu0s_Uc  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu33_BFu0s_Uc) C1{ FL:33 Fs:0 Fc}



static void Test_BFu33_BFu0s_Uc()
{
  {
    init_simple_test("BFu33_BFu0s_Uc");
    static STRUCT_IF_C BFu33_BFu0s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_Uc");
    check_field_offset(lv, v2, 6, "BFu33_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_Uc, BFu33_BFu0s_Uc)
//============================================================================


struct  BFu33_BFu0s_Ui  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu33_BFu0s_Ui) C1{ FL:33 Fs:0 Fi}



static void Test_BFu33_BFu0s_Ui()
{
  {
    init_simple_test("BFu33_BFu0s_Ui");
    static STRUCT_IF_C BFu33_BFu0s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_Ui");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_Ui, BFu33_BFu0s_Ui)
//============================================================================


struct  BFu33_BFu0s_Ul  {
  __tsu64 v1:33;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu33_BFu0s_Ul) C1{ FL:33 Fs:0 FL}



static void Test_BFu33_BFu0s_Ul()
{
  {
    init_simple_test("BFu33_BFu0s_Ul");
    static STRUCT_IF_C BFu33_BFu0s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_Ul");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_Ul, BFu33_BFu0s_Ul)
//============================================================================


struct  BFu33_BFu0s_Us  {
  __tsu64 v1:33;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu33_BFu0s_Us) C1{ FL:33 Fs:0 Fs}



static void Test_BFu33_BFu0s_Us()
{
  {
    init_simple_test("BFu33_BFu0s_Us");
    static STRUCT_IF_C BFu33_BFu0s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_Us");
    check_field_offset(lv, v2, 6, "BFu33_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_Us, BFu33_BFu0s_Us)
//============================================================================


struct  BFu33_BFu0s_Vp  {
  __tsu64 v1:33;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu33_BFu0s_Vp) C1{ FL:33 Fs:0 Fp}



static void Test_BFu33_BFu0s_Vp()
{
  {
    init_simple_test("BFu33_BFu0s_Vp");
    static STRUCT_IF_C BFu33_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu0s_Vp");
    check_field_offset(lv, v2, 8, "BFu33_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu0s_Vp, BFu33_BFu0s_Vp)
//============================================================================


struct  BFu33_BFu15i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu15i_BFu0c) C1{ FL:33 Fi:15 Fc:0}



static void Test_BFu33_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu15i_BFu0c");
    static STRUCT_IF_C BFu33_BFu15i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15i_BFu0c, BFu33_BFu15i_BFu0c)
//============================================================================


struct  BFu33_BFu15i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu15i_BFu0i) C1{ FL:33 Fi:15 Fi:0}



static void Test_BFu33_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu15i_BFu0i");
    static STRUCT_IF_C BFu33_BFu15i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15i_BFu0i, BFu33_BFu15i_BFu0i)
//============================================================================


struct  BFu33_BFu15i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu15i_BFu0ll) C1{ FL:33 Fi:15 FL:0}



static void Test_BFu33_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu15i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15i_BFu0ll, BFu33_BFu15i_BFu0ll)
//============================================================================


struct  BFu33_BFu15i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu15i_BFu0s) C1{ FL:33 Fi:15 Fs:0}



static void Test_BFu33_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu15i_BFu0s");
    static STRUCT_IF_C BFu33_BFu15i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15i_BFu0s, BFu33_BFu15i_BFu0s)
//============================================================================


struct  BFu33_BFu15ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu15ll_BFu0c) C1{ FL:33 FL:15 Fc:0}



static void Test_BFu33_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15ll_BFu0c, BFu33_BFu15ll_BFu0c)
//============================================================================


struct  BFu33_BFu15ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu15ll_BFu0i) C1{ FL:33 FL:15 Fi:0}



static void Test_BFu33_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu15ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15ll_BFu0i, BFu33_BFu15ll_BFu0i)
//============================================================================


struct  BFu33_BFu15ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu15ll_BFu0ll) C1{ FL:33 FL:15 FL:0}



static void Test_BFu33_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15ll_BFu0ll, BFu33_BFu15ll_BFu0ll)
//============================================================================


struct  BFu33_BFu15ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu15ll_BFu0s) C1{ FL:33 FL:15 Fs:0}



static void Test_BFu33_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15ll_BFu0s, BFu33_BFu15ll_BFu0s)
//============================================================================


struct  BFu33_BFu15s_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu15s_BFu0c) C1{ FL:33 Fs:15 Fc:0}



static void Test_BFu33_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu15s_BFu0c");
    static STRUCT_IF_C BFu33_BFu15s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15s_BFu0c, BFu33_BFu15s_BFu0c)
//============================================================================


struct  BFu33_BFu15s_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu15s_BFu0i) C1{ FL:33 Fs:15 Fi:0}



static void Test_BFu33_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu15s_BFu0i");
    static STRUCT_IF_C BFu33_BFu15s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15s_BFu0i, BFu33_BFu15s_BFu0i)
//============================================================================


struct  BFu33_BFu15s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu15s_BFu0ll) C1{ FL:33 Fs:15 FL:0}



static void Test_BFu33_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu15s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15s_BFu0ll, BFu33_BFu15s_BFu0ll)
//============================================================================


struct  BFu33_BFu15s_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu15s_BFu0s) C1{ FL:33 Fs:15 Fs:0}



static void Test_BFu33_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu15s_BFu0s");
    static STRUCT_IF_C BFu33_BFu15s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu15s_BFu0s, BFu33_BFu15s_BFu0s)
//============================================================================


struct  BFu33_BFu16i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu16i_BFu0c) C1{ FL:33 Fi:16 Fc:0}



static void Test_BFu33_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu16i_BFu0c");
    static STRUCT_IF_C BFu33_BFu16i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16i_BFu0c, BFu33_BFu16i_BFu0c)
//============================================================================


struct  BFu33_BFu16i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu16i_BFu0i) C1{ FL:33 Fi:16 Fi:0}



static void Test_BFu33_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu16i_BFu0i");
    static STRUCT_IF_C BFu33_BFu16i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16i_BFu0i, BFu33_BFu16i_BFu0i)
//============================================================================


struct  BFu33_BFu16i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu16i_BFu0ll) C1{ FL:33 Fi:16 FL:0}



static void Test_BFu33_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu16i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16i_BFu0ll, BFu33_BFu16i_BFu0ll)
//============================================================================


struct  BFu33_BFu16i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu16i_BFu0s) C1{ FL:33 Fi:16 Fs:0}



static void Test_BFu33_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu16i_BFu0s");
    static STRUCT_IF_C BFu33_BFu16i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16i_BFu0s, BFu33_BFu16i_BFu0s)
//============================================================================


struct  BFu33_BFu16ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu16ll_BFu0c) C1{ FL:33 FL:16 Fc:0}



static void Test_BFu33_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16ll_BFu0c, BFu33_BFu16ll_BFu0c)
//============================================================================


struct  BFu33_BFu16ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu16ll_BFu0i) C1{ FL:33 FL:16 Fi:0}



static void Test_BFu33_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu16ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16ll_BFu0i, BFu33_BFu16ll_BFu0i)
//============================================================================


struct  BFu33_BFu16ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu16ll_BFu0ll) C1{ FL:33 FL:16 FL:0}



static void Test_BFu33_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16ll_BFu0ll, BFu33_BFu16ll_BFu0ll)
//============================================================================


struct  BFu33_BFu16ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu16ll_BFu0s) C1{ FL:33 FL:16 Fs:0}



static void Test_BFu33_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16ll_BFu0s, BFu33_BFu16ll_BFu0s)
//============================================================================


struct  BFu33_BFu16s_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu16s_BFu0c) C1{ FL:33 Fs:16 Fc:0}



static void Test_BFu33_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu16s_BFu0c");
    static STRUCT_IF_C BFu33_BFu16s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16s_BFu0c, BFu33_BFu16s_BFu0c)
//============================================================================


struct  BFu33_BFu16s_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu16s_BFu0i) C1{ FL:33 Fs:16 Fi:0}



static void Test_BFu33_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu16s_BFu0i");
    static STRUCT_IF_C BFu33_BFu16s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16s_BFu0i, BFu33_BFu16s_BFu0i)
//============================================================================


struct  BFu33_BFu16s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu16s_BFu0ll) C1{ FL:33 Fs:16 FL:0}



static void Test_BFu33_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu16s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16s_BFu0ll, BFu33_BFu16s_BFu0ll)
//============================================================================


struct  BFu33_BFu16s_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu16s_BFu0s) C1{ FL:33 Fs:16 Fs:0}



static void Test_BFu33_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu16s_BFu0s");
    static STRUCT_IF_C BFu33_BFu16s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu16s_BFu0s, BFu33_BFu16s_BFu0s)
//============================================================================


struct  BFu33_BFu17i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu17i_BFu0c) C1{ FL:33 Fi:17 Fc:0}



static void Test_BFu33_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu17i_BFu0c");
    static STRUCT_IF_C BFu33_BFu17i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17i_BFu0c, BFu33_BFu17i_BFu0c)
//============================================================================


struct  BFu33_BFu17i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu17i_BFu0i) C1{ FL:33 Fi:17 Fi:0}



static void Test_BFu33_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu17i_BFu0i");
    static STRUCT_IF_C BFu33_BFu17i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17i_BFu0i, BFu33_BFu17i_BFu0i)
//============================================================================


struct  BFu33_BFu17i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu17i_BFu0ll) C1{ FL:33 Fi:17 FL:0}



static void Test_BFu33_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu17i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17i_BFu0ll, BFu33_BFu17i_BFu0ll)
//============================================================================


struct  BFu33_BFu17i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu17i_BFu0s) C1{ FL:33 Fi:17 Fs:0}



static void Test_BFu33_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu17i_BFu0s");
    static STRUCT_IF_C BFu33_BFu17i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17i_BFu0s, BFu33_BFu17i_BFu0s)
//============================================================================


struct  BFu33_BFu17ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu17ll_BFu0c) C1{ FL:33 FL:17 Fc:0}



static void Test_BFu33_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17ll_BFu0c, BFu33_BFu17ll_BFu0c)
//============================================================================


struct  BFu33_BFu17ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu17ll_BFu0i) C1{ FL:33 FL:17 Fi:0}



static void Test_BFu33_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17ll_BFu0i, BFu33_BFu17ll_BFu0i)
//============================================================================


struct  BFu33_BFu17ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu17ll_BFu0ll) C1{ FL:33 FL:17 FL:0}



static void Test_BFu33_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17ll_BFu0ll, BFu33_BFu17ll_BFu0ll)
//============================================================================


struct  BFu33_BFu17ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu17ll_BFu0s) C1{ FL:33 FL:17 Fs:0}



static void Test_BFu33_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu17ll_BFu0s, BFu33_BFu17ll_BFu0s)
//============================================================================


struct  BFu33_BFu1c_BFu0c  {
  __tsu64 v1:33;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu1c_BFu0c) C1{ FL:33 Fc:1 Fc:0}



static void Test_BFu33_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu33_BFu1c_BFu0c");
    static STRUCT_IF_C BFu33_BFu1c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1c_BFu0c, BFu33_BFu1c_BFu0c)
//============================================================================


struct  BFu33_BFu1c_BFu0i  {
  __tsu64 v1:33;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu1c_BFu0i) C1{ FL:33 Fc:1 Fi:0}



static void Test_BFu33_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu33_BFu1c_BFu0i");
    static STRUCT_IF_C BFu33_BFu1c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1c_BFu0i, BFu33_BFu1c_BFu0i)
//============================================================================


struct  BFu33_BFu1c_BFu0ll  {
  __tsu64 v1:33;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu1c_BFu0ll) C1{ FL:33 Fc:1 FL:0}



static void Test_BFu33_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu33_BFu1c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1c_BFu0ll, BFu33_BFu1c_BFu0ll)
//============================================================================


struct  BFu33_BFu1c_BFu0s  {
  __tsu64 v1:33;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu1c_BFu0s) C1{ FL:33 Fc:1 Fs:0}



static void Test_BFu33_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu33_BFu1c_BFu0s");
    static STRUCT_IF_C BFu33_BFu1c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1c_BFu0s, BFu33_BFu1c_BFu0s)
//============================================================================


struct  BFu33_BFu1i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu1i_BFu0c) C1{ FL:33 Fi:1 Fc:0}



static void Test_BFu33_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu1i_BFu0c");
    static STRUCT_IF_C BFu33_BFu1i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1i_BFu0c, BFu33_BFu1i_BFu0c)
//============================================================================


struct  BFu33_BFu1i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu1i_BFu0i) C1{ FL:33 Fi:1 Fi:0}



static void Test_BFu33_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu1i_BFu0i");
    static STRUCT_IF_C BFu33_BFu1i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1i_BFu0i, BFu33_BFu1i_BFu0i)
//============================================================================


struct  BFu33_BFu1i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu1i_BFu0ll) C1{ FL:33 Fi:1 FL:0}



static void Test_BFu33_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu1i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1i_BFu0ll, BFu33_BFu1i_BFu0ll)
//============================================================================


struct  BFu33_BFu1i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu1i_BFu0s) C1{ FL:33 Fi:1 Fs:0}



static void Test_BFu33_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu1i_BFu0s");
    static STRUCT_IF_C BFu33_BFu1i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1i_BFu0s, BFu33_BFu1i_BFu0s)
//============================================================================


struct  BFu33_BFu1ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu1ll_BFu0c) C1{ FL:33 FL:1 Fc:0}



static void Test_BFu33_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1ll_BFu0c, BFu33_BFu1ll_BFu0c)
//============================================================================


struct  BFu33_BFu1ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu1ll_BFu0i) C1{ FL:33 FL:1 Fi:0}



static void Test_BFu33_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu1ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1ll_BFu0i, BFu33_BFu1ll_BFu0i)
//============================================================================


struct  BFu33_BFu1ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu1ll_BFu0ll) C1{ FL:33 FL:1 FL:0}



static void Test_BFu33_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1ll_BFu0ll, BFu33_BFu1ll_BFu0ll)
//============================================================================


struct  BFu33_BFu1ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu1ll_BFu0s) C1{ FL:33 FL:1 Fs:0}



static void Test_BFu33_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu1ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1ll_BFu0s, BFu33_BFu1ll_BFu0s)
//============================================================================


struct  BFu33_BFu1s_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu1s_BFu0c) C1{ FL:33 Fs:1 Fc:0}



static void Test_BFu33_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu1s_BFu0c");
    static STRUCT_IF_C BFu33_BFu1s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1s_BFu0c, BFu33_BFu1s_BFu0c)
//============================================================================


struct  BFu33_BFu1s_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu1s_BFu0i) C1{ FL:33 Fs:1 Fi:0}



static void Test_BFu33_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu1s_BFu0i");
    static STRUCT_IF_C BFu33_BFu1s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1s_BFu0i, BFu33_BFu1s_BFu0i)
//============================================================================


struct  BFu33_BFu1s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu1s_BFu0ll) C1{ FL:33 Fs:1 FL:0}



static void Test_BFu33_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu1s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1s_BFu0ll, BFu33_BFu1s_BFu0ll)
//============================================================================


struct  BFu33_BFu1s_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu1s_BFu0s) C1{ FL:33 Fs:1 Fs:0}



static void Test_BFu33_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu1s_BFu0s");
    static STRUCT_IF_C BFu33_BFu1s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu1s_BFu0s, BFu33_BFu1s_BFu0s)
//============================================================================


struct  BFu33_BFu31i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu31i_BFu0c) C1{ FL:33 Fi:31 Fc:0}



static void Test_BFu33_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu31i_BFu0c");
    static STRUCT_IF_C BFu33_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31i_BFu0c, BFu33_BFu31i_BFu0c)
//============================================================================


struct  BFu33_BFu31i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu31i_BFu0i) C1{ FL:33 Fi:31 Fi:0}



static void Test_BFu33_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu31i_BFu0i");
    static STRUCT_IF_C BFu33_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31i_BFu0i, BFu33_BFu31i_BFu0i)
//============================================================================


struct  BFu33_BFu31i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu31i_BFu0ll) C1{ FL:33 Fi:31 FL:0}



static void Test_BFu33_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31i_BFu0ll, BFu33_BFu31i_BFu0ll)
//============================================================================


struct  BFu33_BFu31i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu31i_BFu0s) C1{ FL:33 Fi:31 Fs:0}



static void Test_BFu33_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu31i_BFu0s");
    static STRUCT_IF_C BFu33_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31i_BFu0s, BFu33_BFu31i_BFu0s)
//============================================================================


struct  BFu33_BFu31ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu31ll_BFu0c) C1{ FL:33 FL:31 Fc:0}



static void Test_BFu33_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31ll_BFu0c, BFu33_BFu31ll_BFu0c)
//============================================================================


struct  BFu33_BFu31ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu31ll_BFu0i) C1{ FL:33 FL:31 Fi:0}



static void Test_BFu33_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31ll_BFu0i, BFu33_BFu31ll_BFu0i)
//============================================================================


struct  BFu33_BFu31ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu31ll_BFu0ll) C1{ FL:33 FL:31 FL:0}



static void Test_BFu33_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31ll_BFu0ll, BFu33_BFu31ll_BFu0ll)
//============================================================================


struct  BFu33_BFu31ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu31ll_BFu0s) C1{ FL:33 FL:31 Fs:0}



static void Test_BFu33_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu31ll_BFu0s, BFu33_BFu31ll_BFu0s)
//============================================================================


struct  BFu33_BFu32i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu32i_BFu0c) C1{ FL:33 Fi:32 Fc:0}



static void Test_BFu33_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu32i_BFu0c");
    static STRUCT_IF_C BFu33_BFu32i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32i_BFu0c, BFu33_BFu32i_BFu0c)
//============================================================================


struct  BFu33_BFu32i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu32i_BFu0i) C1{ FL:33 Fi:32 Fi:0}



static void Test_BFu33_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu32i_BFu0i");
    static STRUCT_IF_C BFu33_BFu32i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32i_BFu0i, BFu33_BFu32i_BFu0i)
//============================================================================


struct  BFu33_BFu32i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu32i_BFu0ll) C1{ FL:33 Fi:32 FL:0}



static void Test_BFu33_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32i_BFu0ll, BFu33_BFu32i_BFu0ll)
//============================================================================


struct  BFu33_BFu32i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu32i_BFu0s) C1{ FL:33 Fi:32 Fs:0}



static void Test_BFu33_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu32i_BFu0s");
    static STRUCT_IF_C BFu33_BFu32i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32i_BFu0s, BFu33_BFu32i_BFu0s)
//============================================================================


struct  BFu33_BFu32ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu32ll_BFu0c) C1{ FL:33 FL:32 Fc:0}



static void Test_BFu33_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu32ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu33_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu33_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32ll_BFu0c, BFu33_BFu32ll_BFu0c)
//============================================================================


struct  BFu33_BFu32ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu32ll_BFu0i) C1{ FL:33 FL:32 Fi:0}



static void Test_BFu33_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu33_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu33_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32ll_BFu0i, BFu33_BFu32ll_BFu0i)
//============================================================================


struct  BFu33_BFu32ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu32ll_BFu0ll) C1{ FL:33 FL:32 FL:0}



static void Test_BFu33_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu33_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu33_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32ll_BFu0ll, BFu33_BFu32ll_BFu0ll)
//============================================================================


struct  BFu33_BFu32ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu32ll_BFu0s) C1{ FL:33 FL:32 Fs:0}



static void Test_BFu33_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu32ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu33_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu33_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu32ll_BFu0s, BFu33_BFu32ll_BFu0s)
//============================================================================


struct  BFu33_BFu33_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu33_BFu0c) C1{ FL:33 FL:33 Fc:0}



static void Test_BFu33_BFu33_BFu0c()
{
  {
    init_simple_test("BFu33_BFu33_BFu0c");
    static STRUCT_IF_C BFu33_BFu33_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu33_BFu33_BFu0c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu33_BFu0c, BFu33_BFu33_BFu0c)
//============================================================================


struct  BFu33_BFu33_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu33_BFu0i) C1{ FL:33 FL:33 Fi:0}



static void Test_BFu33_BFu33_BFu0i()
{
  {
    init_simple_test("BFu33_BFu33_BFu0i");
    static STRUCT_IF_C BFu33_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu33_BFu33_BFu0i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu33_BFu0i, BFu33_BFu33_BFu0i)
//============================================================================


struct  BFu33_BFu33_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu33_BFu0ll) C1{ FL:33 FL:33 FL:0}



static void Test_BFu33_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu33_BFu0ll");
    static STRUCT_IF_C BFu33_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu33_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu33_BFu0ll, BFu33_BFu33_BFu0ll)
//============================================================================


struct  BFu33_BFu33_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu33_BFu0s) C1{ FL:33 FL:33 Fs:0}



static void Test_BFu33_BFu33_BFu0s()
{
  {
    init_simple_test("BFu33_BFu33_BFu0s");
    static STRUCT_IF_C BFu33_BFu33_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu33_BFu33_BFu0s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu33_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu33_BFu0s, BFu33_BFu33_BFu0s)
//============================================================================


struct  BFu33_BFu7c_BFu0c  {
  __tsu64 v1:33;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu7c_BFu0c) C1{ FL:33 Fc:7 Fc:0}



static void Test_BFu33_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu33_BFu7c_BFu0c");
    static STRUCT_IF_C BFu33_BFu7c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7c_BFu0c, BFu33_BFu7c_BFu0c)
//============================================================================


struct  BFu33_BFu7c_BFu0i  {
  __tsu64 v1:33;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu7c_BFu0i) C1{ FL:33 Fc:7 Fi:0}



static void Test_BFu33_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu33_BFu7c_BFu0i");
    static STRUCT_IF_C BFu33_BFu7c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7c_BFu0i, BFu33_BFu7c_BFu0i)
//============================================================================


struct  BFu33_BFu7c_BFu0ll  {
  __tsu64 v1:33;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu7c_BFu0ll) C1{ FL:33 Fc:7 FL:0}



static void Test_BFu33_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu33_BFu7c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7c_BFu0ll, BFu33_BFu7c_BFu0ll)
//============================================================================


struct  BFu33_BFu7c_BFu0s  {
  __tsu64 v1:33;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu7c_BFu0s) C1{ FL:33 Fc:7 Fs:0}



static void Test_BFu33_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu33_BFu7c_BFu0s");
    static STRUCT_IF_C BFu33_BFu7c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7c_BFu0s, BFu33_BFu7c_BFu0s)
//============================================================================


struct  BFu33_BFu7i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu7i_BFu0c) C1{ FL:33 Fi:7 Fc:0}



static void Test_BFu33_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu7i_BFu0c");
    static STRUCT_IF_C BFu33_BFu7i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7i_BFu0c, BFu33_BFu7i_BFu0c)
//============================================================================


struct  BFu33_BFu7i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu7i_BFu0i) C1{ FL:33 Fi:7 Fi:0}



static void Test_BFu33_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu7i_BFu0i");
    static STRUCT_IF_C BFu33_BFu7i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7i_BFu0i, BFu33_BFu7i_BFu0i)
//============================================================================


struct  BFu33_BFu7i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu7i_BFu0ll) C1{ FL:33 Fi:7 FL:0}



static void Test_BFu33_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu7i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7i_BFu0ll, BFu33_BFu7i_BFu0ll)
//============================================================================


struct  BFu33_BFu7i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu7i_BFu0s) C1{ FL:33 Fi:7 Fs:0}



static void Test_BFu33_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu7i_BFu0s");
    static STRUCT_IF_C BFu33_BFu7i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7i_BFu0s, BFu33_BFu7i_BFu0s)
//============================================================================


struct  BFu33_BFu7ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu7ll_BFu0c) C1{ FL:33 FL:7 Fc:0}



static void Test_BFu33_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7ll_BFu0c, BFu33_BFu7ll_BFu0c)
//============================================================================


struct  BFu33_BFu7ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu7ll_BFu0i) C1{ FL:33 FL:7 Fi:0}



static void Test_BFu33_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu7ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7ll_BFu0i, BFu33_BFu7ll_BFu0i)
//============================================================================


struct  BFu33_BFu7ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu7ll_BFu0ll) C1{ FL:33 FL:7 FL:0}



static void Test_BFu33_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7ll_BFu0ll, BFu33_BFu7ll_BFu0ll)
//============================================================================


struct  BFu33_BFu7ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu7ll_BFu0s) C1{ FL:33 FL:7 Fs:0}



static void Test_BFu33_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu7ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7ll_BFu0s, BFu33_BFu7ll_BFu0s)
//============================================================================


struct  BFu33_BFu7s_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu7s_BFu0c) C1{ FL:33 Fs:7 Fc:0}



static void Test_BFu33_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu7s_BFu0c");
    static STRUCT_IF_C BFu33_BFu7s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7s_BFu0c, BFu33_BFu7s_BFu0c)
//============================================================================


struct  BFu33_BFu7s_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu7s_BFu0i) C1{ FL:33 Fs:7 Fi:0}



static void Test_BFu33_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu7s_BFu0i");
    static STRUCT_IF_C BFu33_BFu7s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7s_BFu0i, BFu33_BFu7s_BFu0i)
//============================================================================


struct  BFu33_BFu7s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu7s_BFu0ll) C1{ FL:33 Fs:7 FL:0}



static void Test_BFu33_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu7s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7s_BFu0ll, BFu33_BFu7s_BFu0ll)
//============================================================================


struct  BFu33_BFu7s_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu7s_BFu0s) C1{ FL:33 Fs:7 Fs:0}



static void Test_BFu33_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu7s_BFu0s");
    static STRUCT_IF_C BFu33_BFu7s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu7s_BFu0s, BFu33_BFu7s_BFu0s)
//============================================================================


struct  BFu33_BFu8c_BFu0c  {
  __tsu64 v1:33;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu8c_BFu0c) C1{ FL:33 Fc:8 Fc:0}



static void Test_BFu33_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu33_BFu8c_BFu0c");
    static STRUCT_IF_C BFu33_BFu8c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu33_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu33_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8c_BFu0c, BFu33_BFu8c_BFu0c)
//============================================================================


struct  BFu33_BFu8c_BFu0i  {
  __tsu64 v1:33;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu8c_BFu0i) C1{ FL:33 Fc:8 Fi:0}



static void Test_BFu33_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu33_BFu8c_BFu0i");
    static STRUCT_IF_C BFu33_BFu8c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu33_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu33_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8c_BFu0i, BFu33_BFu8c_BFu0i)
//============================================================================


struct  BFu33_BFu8c_BFu0ll  {
  __tsu64 v1:33;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu8c_BFu0ll) C1{ FL:33 Fc:8 FL:0}



static void Test_BFu33_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu33_BFu8c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu33_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu33_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8c_BFu0ll, BFu33_BFu8c_BFu0ll)
//============================================================================


struct  BFu33_BFu8c_BFu0s  {
  __tsu64 v1:33;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu8c_BFu0s) C1{ FL:33 Fc:8 Fs:0}



static void Test_BFu33_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu33_BFu8c_BFu0s");
    static STRUCT_IF_C BFu33_BFu8c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu33_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu33_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8c_BFu0s, BFu33_BFu8c_BFu0s)
//============================================================================


struct  BFu33_BFu8i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu8i_BFu0c) C1{ FL:33 Fi:8 Fc:0}



static void Test_BFu33_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu8i_BFu0c");
    static STRUCT_IF_C BFu33_BFu8i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8i_BFu0c, BFu33_BFu8i_BFu0c)
//============================================================================


struct  BFu33_BFu8i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu8i_BFu0i) C1{ FL:33 Fi:8 Fi:0}



static void Test_BFu33_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu8i_BFu0i");
    static STRUCT_IF_C BFu33_BFu8i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8i_BFu0i, BFu33_BFu8i_BFu0i)
//============================================================================


struct  BFu33_BFu8i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu8i_BFu0ll) C1{ FL:33 Fi:8 FL:0}



static void Test_BFu33_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu8i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8i_BFu0ll, BFu33_BFu8i_BFu0ll)
//============================================================================


struct  BFu33_BFu8i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu8i_BFu0s) C1{ FL:33 Fi:8 Fs:0}



static void Test_BFu33_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu8i_BFu0s");
    static STRUCT_IF_C BFu33_BFu8i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8i_BFu0s, BFu33_BFu8i_BFu0s)
//============================================================================


struct  BFu33_BFu8ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu8ll_BFu0c) C1{ FL:33 FL:8 Fc:0}



static void Test_BFu33_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8ll_BFu0c, BFu33_BFu8ll_BFu0c)
//============================================================================


struct  BFu33_BFu8ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu8ll_BFu0i) C1{ FL:33 FL:8 Fi:0}



static void Test_BFu33_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu8ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8ll_BFu0i, BFu33_BFu8ll_BFu0i)
//============================================================================


struct  BFu33_BFu8ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu8ll_BFu0ll) C1{ FL:33 FL:8 FL:0}



static void Test_BFu33_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8ll_BFu0ll, BFu33_BFu8ll_BFu0ll)
//============================================================================


struct  BFu33_BFu8ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu8ll_BFu0s) C1{ FL:33 FL:8 Fs:0}



static void Test_BFu33_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu8ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8ll_BFu0s, BFu33_BFu8ll_BFu0s)
//============================================================================


struct  BFu33_BFu8s_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu8s_BFu0c) C1{ FL:33 Fs:8 Fc:0}



static void Test_BFu33_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu8s_BFu0c");
    static STRUCT_IF_C BFu33_BFu8s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8s_BFu0c, BFu33_BFu8s_BFu0c)
//============================================================================


struct  BFu33_BFu8s_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu8s_BFu0i) C1{ FL:33 Fs:8 Fi:0}



static void Test_BFu33_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu8s_BFu0i");
    static STRUCT_IF_C BFu33_BFu8s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8s_BFu0i, BFu33_BFu8s_BFu0i)
//============================================================================


struct  BFu33_BFu8s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu8s_BFu0ll) C1{ FL:33 Fs:8 FL:0}



static void Test_BFu33_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu8s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8s_BFu0ll, BFu33_BFu8s_BFu0ll)
//============================================================================


struct  BFu33_BFu8s_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu8s_BFu0s) C1{ FL:33 Fs:8 Fs:0}



static void Test_BFu33_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu8s_BFu0s");
    static STRUCT_IF_C BFu33_BFu8s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu8s_BFu0s, BFu33_BFu8s_BFu0s)
//============================================================================


struct  BFu33_BFu9i_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu9i_BFu0c) C1{ FL:33 Fi:9 Fc:0}



static void Test_BFu33_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu33_BFu9i_BFu0c");
    static STRUCT_IF_C BFu33_BFu9i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9i_BFu0c, BFu33_BFu9i_BFu0c)
//============================================================================


struct  BFu33_BFu9i_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu9i_BFu0i) C1{ FL:33 Fi:9 Fi:0}



static void Test_BFu33_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu33_BFu9i_BFu0i");
    static STRUCT_IF_C BFu33_BFu9i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9i_BFu0i, BFu33_BFu9i_BFu0i)
//============================================================================


struct  BFu33_BFu9i_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu9i_BFu0ll) C1{ FL:33 Fi:9 FL:0}



static void Test_BFu33_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu33_BFu9i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9i_BFu0ll, BFu33_BFu9i_BFu0ll)
//============================================================================


struct  BFu33_BFu9i_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu9i_BFu0s) C1{ FL:33 Fi:9 Fs:0}



static void Test_BFu33_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu33_BFu9i_BFu0s");
    static STRUCT_IF_C BFu33_BFu9i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9i_BFu0s, BFu33_BFu9i_BFu0s)
//============================================================================


struct  BFu33_BFu9ll_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu9ll_BFu0c) C1{ FL:33 FL:9 Fc:0}



static void Test_BFu33_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu33_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu33_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9ll_BFu0c, BFu33_BFu9ll_BFu0c)
//============================================================================


struct  BFu33_BFu9ll_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu9ll_BFu0i) C1{ FL:33 FL:9 Fi:0}



static void Test_BFu33_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu33_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu33_BFu9ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9ll_BFu0i, BFu33_BFu9ll_BFu0i)
//============================================================================


struct  BFu33_BFu9ll_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu9ll_BFu0ll) C1{ FL:33 FL:9 FL:0}



static void Test_BFu33_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu33_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9ll_BFu0ll, BFu33_BFu9ll_BFu0ll)
//============================================================================


struct  BFu33_BFu9ll_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu9ll_BFu0s) C1{ FL:33 FL:9 Fs:0}



static void Test_BFu33_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu33_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu33_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9ll_BFu0s, BFu33_BFu9ll_BFu0s)
//============================================================================


struct  BFu33_BFu9s_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu33_BFu9s_BFu0c) C1{ FL:33 Fs:9 Fc:0}



static void Test_BFu33_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu33_BFu9s_BFu0c");
    static STRUCT_IF_C BFu33_BFu9s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9s_BFu0c, BFu33_BFu9s_BFu0c)
//============================================================================


struct  BFu33_BFu9s_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu33_BFu9s_BFu0i) C1{ FL:33 Fs:9 Fi:0}



static void Test_BFu33_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu33_BFu9s_BFu0i");
    static STRUCT_IF_C BFu33_BFu9s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9s_BFu0i, BFu33_BFu9s_BFu0i)
//============================================================================


struct  BFu33_BFu9s_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu33_BFu9s_BFu0ll) C1{ FL:33 Fs:9 FL:0}



static void Test_BFu33_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu33_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu33_BFu9s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9s_BFu0ll, BFu33_BFu9s_BFu0ll)
//============================================================================


struct  BFu33_BFu9s_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu33_BFu9s_BFu0s) C1{ FL:33 Fs:9 Fs:0}



static void Test_BFu33_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu33_BFu9s_BFu0s");
    static STRUCT_IF_C BFu33_BFu9s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_BFu9s_BFu0s, BFu33_BFu9s_BFu0s)
//============================================================================


struct  BFu33_C_BFu0c  {
  __tsu64 v1:33;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu33_C_BFu0c) C1{ FL:33 Fc Fc:0}



static void Test_BFu33_C_BFu0c()
{
  {
    init_simple_test("BFu33_C_BFu0c");
    static STRUCT_IF_C BFu33_C_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_C_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_C_BFu0c");
    check_field_offset(lv, v2, 5, "BFu33_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_C_BFu0c, BFu33_C_BFu0c)
//============================================================================


struct  BFu33_C_BFu0i  {
  __tsu64 v1:33;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu33_C_BFu0i) C1{ FL:33 Fc Fi:0}



static void Test_BFu33_C_BFu0i()
{
  {
    init_simple_test("BFu33_C_BFu0i");
    static STRUCT_IF_C BFu33_C_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_C_BFu0i");
    check_field_offset(lv, v2, 5, "BFu33_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_C_BFu0i, BFu33_C_BFu0i)
//============================================================================


struct  BFu33_C_BFu0ll  {
  __tsu64 v1:33;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu33_C_BFu0ll) C1{ FL:33 Fc FL:0}



static void Test_BFu33_C_BFu0ll()
{
  {
    init_simple_test("BFu33_C_BFu0ll");
    static STRUCT_IF_C BFu33_C_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_C_BFu0ll");
    check_field_offset(lv, v2, 5, "BFu33_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_C_BFu0ll, BFu33_C_BFu0ll)
//============================================================================


struct  BFu33_C_BFu0s  {
  __tsu64 v1:33;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu33_C_BFu0s) C1{ FL:33 Fc Fs:0}



static void Test_BFu33_C_BFu0s()
{
  {
    init_simple_test("BFu33_C_BFu0s");
    static STRUCT_IF_C BFu33_C_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_C_BFu0s");
    check_field_offset(lv, v2, 5, "BFu33_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_C_BFu0s, BFu33_C_BFu0s)
//============================================================================


struct  BFu33_D_BFu0c  {
  __tsu64 v1:33;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu33_D_BFu0c) C1{ FL:33 FL Fc:0}



static void Test_BFu33_D_BFu0c()
{
  {
    init_simple_test("BFu33_D_BFu0c");
    static STRUCT_IF_C BFu33_D_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_D_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_D_BFu0c, BFu33_D_BFu0c)
//============================================================================


struct  BFu33_D_BFu0i  {
  __tsu64 v1:33;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu33_D_BFu0i) C1{ FL:33 FL Fi:0}



static void Test_BFu33_D_BFu0i()
{
  {
    init_simple_test("BFu33_D_BFu0i");
    static STRUCT_IF_C BFu33_D_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_D_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_D_BFu0i, BFu33_D_BFu0i)
//============================================================================


struct  BFu33_D_BFu0ll  {
  __tsu64 v1:33;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu33_D_BFu0ll) C1{ FL:33 FL FL:0}



static void Test_BFu33_D_BFu0ll()
{
  {
    init_simple_test("BFu33_D_BFu0ll");
    static STRUCT_IF_C BFu33_D_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_D_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_D_BFu0ll, BFu33_D_BFu0ll)
//============================================================================


struct  BFu33_D_BFu0s  {
  __tsu64 v1:33;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu33_D_BFu0s) C1{ FL:33 FL Fs:0}



static void Test_BFu33_D_BFu0s()
{
  {
    init_simple_test("BFu33_D_BFu0s");
    static STRUCT_IF_C BFu33_D_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_D_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_D_BFu0s, BFu33_D_BFu0s)
//============================================================================


struct  BFu33_F_BFu0c  {
  __tsu64 v1:33;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu33_F_BFu0c) C1{ FL:33 Fi Fc:0}



static void Test_BFu33_F_BFu0c()
{
  {
    init_simple_test("BFu33_F_BFu0c");
    static STRUCT_IF_C BFu33_F_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_F_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_F_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_F_BFu0c, BFu33_F_BFu0c)
//============================================================================


struct  BFu33_F_BFu0i  {
  __tsu64 v1:33;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu33_F_BFu0i) C1{ FL:33 Fi Fi:0}



static void Test_BFu33_F_BFu0i()
{
  {
    init_simple_test("BFu33_F_BFu0i");
    static STRUCT_IF_C BFu33_F_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_F_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_F_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_F_BFu0i, BFu33_F_BFu0i)
//============================================================================


struct  BFu33_F_BFu0ll  {
  __tsu64 v1:33;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu33_F_BFu0ll) C1{ FL:33 Fi FL:0}



static void Test_BFu33_F_BFu0ll()
{
  {
    init_simple_test("BFu33_F_BFu0ll");
    static STRUCT_IF_C BFu33_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_F_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_F_BFu0ll, BFu33_F_BFu0ll)
//============================================================================


struct  BFu33_F_BFu0s  {
  __tsu64 v1:33;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu33_F_BFu0s) C1{ FL:33 Fi Fs:0}



static void Test_BFu33_F_BFu0s()
{
  {
    init_simple_test("BFu33_F_BFu0s");
    static STRUCT_IF_C BFu33_F_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_F_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_F_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_F_BFu0s, BFu33_F_BFu0s)
//============================================================================


struct  BFu33_I_BFu0c  {
  __tsu64 v1:33;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu33_I_BFu0c) C1{ FL:33 Fi Fc:0}



static void Test_BFu33_I_BFu0c()
{
  {
    init_simple_test("BFu33_I_BFu0c");
    static STRUCT_IF_C BFu33_I_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_I_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_I_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_I_BFu0c, BFu33_I_BFu0c)
//============================================================================


struct  BFu33_I_BFu0i  {
  __tsu64 v1:33;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu33_I_BFu0i) C1{ FL:33 Fi Fi:0}



static void Test_BFu33_I_BFu0i()
{
  {
    init_simple_test("BFu33_I_BFu0i");
    static STRUCT_IF_C BFu33_I_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_I_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_I_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_I_BFu0i, BFu33_I_BFu0i)
//============================================================================


struct  BFu33_I_BFu0ll  {
  __tsu64 v1:33;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu33_I_BFu0ll) C1{ FL:33 Fi FL:0}



static void Test_BFu33_I_BFu0ll()
{
  {
    init_simple_test("BFu33_I_BFu0ll");
    static STRUCT_IF_C BFu33_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_I_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_I_BFu0ll, BFu33_I_BFu0ll)
//============================================================================


struct  BFu33_I_BFu0s  {
  __tsu64 v1:33;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu33_I_BFu0s) C1{ FL:33 Fi Fs:0}



static void Test_BFu33_I_BFu0s()
{
  {
    init_simple_test("BFu33_I_BFu0s");
    static STRUCT_IF_C BFu33_I_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_I_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_I_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_I_BFu0s, BFu33_I_BFu0s)
//============================================================================


struct  BFu33_Ip_BFu0c  {
  __tsu64 v1:33;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu33_Ip_BFu0c) C1{ FL:33 Fp Fc:0}



static void Test_BFu33_Ip_BFu0c()
{
  {
    init_simple_test("BFu33_Ip_BFu0c");
    static STRUCT_IF_C BFu33_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ip_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ip_BFu0c, BFu33_Ip_BFu0c)
//============================================================================


struct  BFu33_Ip_BFu0i  {
  __tsu64 v1:33;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu33_Ip_BFu0i) C1{ FL:33 Fp Fi:0}



static void Test_BFu33_Ip_BFu0i()
{
  {
    init_simple_test("BFu33_Ip_BFu0i");
    static STRUCT_IF_C BFu33_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ip_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ip_BFu0i, BFu33_Ip_BFu0i)
//============================================================================


struct  BFu33_Ip_BFu0ll  {
  __tsu64 v1:33;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu33_Ip_BFu0ll) C1{ FL:33 Fp FL:0}



static void Test_BFu33_Ip_BFu0ll()
{
  {
    init_simple_test("BFu33_Ip_BFu0ll");
    static STRUCT_IF_C BFu33_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ip_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ip_BFu0ll, BFu33_Ip_BFu0ll)
//============================================================================


struct  BFu33_Ip_BFu0s  {
  __tsu64 v1:33;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu33_Ip_BFu0s) C1{ FL:33 Fp Fs:0}



static void Test_BFu33_Ip_BFu0s()
{
  {
    init_simple_test("BFu33_Ip_BFu0s");
    static STRUCT_IF_C BFu33_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ip_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ip_BFu0s, BFu33_Ip_BFu0s)
//============================================================================


struct  BFu33_L_BFu0c  {
  __tsu64 v1:33;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu33_L_BFu0c) C1{ FL:33 FL Fc:0}



static void Test_BFu33_L_BFu0c()
{
  {
    init_simple_test("BFu33_L_BFu0c");
    static STRUCT_IF_C BFu33_L_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_L_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_L_BFu0c, BFu33_L_BFu0c)
//============================================================================


struct  BFu33_L_BFu0i  {
  __tsu64 v1:33;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu33_L_BFu0i) C1{ FL:33 FL Fi:0}



static void Test_BFu33_L_BFu0i()
{
  {
    init_simple_test("BFu33_L_BFu0i");
    static STRUCT_IF_C BFu33_L_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_L_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_L_BFu0i, BFu33_L_BFu0i)
//============================================================================


struct  BFu33_L_BFu0ll  {
  __tsu64 v1:33;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu33_L_BFu0ll) C1{ FL:33 FL FL:0}



static void Test_BFu33_L_BFu0ll()
{
  {
    init_simple_test("BFu33_L_BFu0ll");
    static STRUCT_IF_C BFu33_L_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_L_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_L_BFu0ll, BFu33_L_BFu0ll)
//============================================================================


struct  BFu33_L_BFu0s  {
  __tsu64 v1:33;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu33_L_BFu0s) C1{ FL:33 FL Fs:0}



static void Test_BFu33_L_BFu0s()
{
  {
    init_simple_test("BFu33_L_BFu0s");
    static STRUCT_IF_C BFu33_L_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_L_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_L_BFu0s, BFu33_L_BFu0s)
//============================================================================


struct  BFu33_S_BFu0c  {
  __tsu64 v1:33;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu33_S_BFu0c) C1{ FL:33 Fs Fc:0}



static void Test_BFu33_S_BFu0c()
{
  {
    init_simple_test("BFu33_S_BFu0c");
    static STRUCT_IF_C BFu33_S_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_S_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_S_BFu0c");
    check_field_offset(lv, v2, 6, "BFu33_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_S_BFu0c, BFu33_S_BFu0c)
//============================================================================


struct  BFu33_S_BFu0i  {
  __tsu64 v1:33;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu33_S_BFu0i) C1{ FL:33 Fs Fi:0}



static void Test_BFu33_S_BFu0i()
{
  {
    init_simple_test("BFu33_S_BFu0i");
    static STRUCT_IF_C BFu33_S_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_S_BFu0i");
    check_field_offset(lv, v2, 6, "BFu33_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_S_BFu0i, BFu33_S_BFu0i)
//============================================================================


struct  BFu33_S_BFu0ll  {
  __tsu64 v1:33;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu33_S_BFu0ll) C1{ FL:33 Fs FL:0}



static void Test_BFu33_S_BFu0ll()
{
  {
    init_simple_test("BFu33_S_BFu0ll");
    static STRUCT_IF_C BFu33_S_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_S_BFu0ll");
    check_field_offset(lv, v2, 6, "BFu33_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_S_BFu0ll, BFu33_S_BFu0ll)
//============================================================================


struct  BFu33_S_BFu0s  {
  __tsu64 v1:33;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu33_S_BFu0s) C1{ FL:33 Fs Fs:0}



static void Test_BFu33_S_BFu0s()
{
  {
    init_simple_test("BFu33_S_BFu0s");
    static STRUCT_IF_C BFu33_S_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_S_BFu0s");
    check_field_offset(lv, v2, 6, "BFu33_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_S_BFu0s, BFu33_S_BFu0s)
//============================================================================


struct  BFu33_Uc_BFu0c  {
  __tsu64 v1:33;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu33_Uc_BFu0c) C1{ FL:33 Fc Fc:0}



static void Test_BFu33_Uc_BFu0c()
{
  {
    init_simple_test("BFu33_Uc_BFu0c");
    static STRUCT_IF_C BFu33_Uc_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Uc_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Uc_BFu0c");
    check_field_offset(lv, v2, 5, "BFu33_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Uc_BFu0c, BFu33_Uc_BFu0c)
//============================================================================


struct  BFu33_Uc_BFu0i  {
  __tsu64 v1:33;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu33_Uc_BFu0i) C1{ FL:33 Fc Fi:0}



static void Test_BFu33_Uc_BFu0i()
{
  {
    init_simple_test("BFu33_Uc_BFu0i");
    static STRUCT_IF_C BFu33_Uc_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Uc_BFu0i");
    check_field_offset(lv, v2, 5, "BFu33_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Uc_BFu0i, BFu33_Uc_BFu0i)
//============================================================================


struct  BFu33_Uc_BFu0ll  {
  __tsu64 v1:33;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu33_Uc_BFu0ll) C1{ FL:33 Fc FL:0}



static void Test_BFu33_Uc_BFu0ll()
{
  {
    init_simple_test("BFu33_Uc_BFu0ll");
    static STRUCT_IF_C BFu33_Uc_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Uc_BFu0ll");
    check_field_offset(lv, v2, 5, "BFu33_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Uc_BFu0ll, BFu33_Uc_BFu0ll)
//============================================================================


struct  BFu33_Uc_BFu0s  {
  __tsu64 v1:33;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu33_Uc_BFu0s) C1{ FL:33 Fc Fs:0}



static void Test_BFu33_Uc_BFu0s()
{
  {
    init_simple_test("BFu33_Uc_BFu0s");
    static STRUCT_IF_C BFu33_Uc_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Uc_BFu0s");
    check_field_offset(lv, v2, 5, "BFu33_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Uc_BFu0s, BFu33_Uc_BFu0s)
//============================================================================


struct  BFu33_Ui_BFu0c  {
  __tsu64 v1:33;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu33_Ui_BFu0c) C1{ FL:33 Fi Fc:0}



static void Test_BFu33_Ui_BFu0c()
{
  {
    init_simple_test("BFu33_Ui_BFu0c");
    static STRUCT_IF_C BFu33_Ui_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ui_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ui_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ui_BFu0c, BFu33_Ui_BFu0c)
//============================================================================


struct  BFu33_Ui_BFu0i  {
  __tsu64 v1:33;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu33_Ui_BFu0i) C1{ FL:33 Fi Fi:0}



static void Test_BFu33_Ui_BFu0i()
{
  {
    init_simple_test("BFu33_Ui_BFu0i");
    static STRUCT_IF_C BFu33_Ui_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ui_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ui_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ui_BFu0i, BFu33_Ui_BFu0i)
//============================================================================


struct  BFu33_Ui_BFu0ll  {
  __tsu64 v1:33;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu33_Ui_BFu0ll) C1{ FL:33 Fi FL:0}



static void Test_BFu33_Ui_BFu0ll()
{
  {
    init_simple_test("BFu33_Ui_BFu0ll");
    static STRUCT_IF_C BFu33_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ui_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ui_BFu0ll, BFu33_Ui_BFu0ll)
//============================================================================


struct  BFu33_Ui_BFu0s  {
  __tsu64 v1:33;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu33_Ui_BFu0s) C1{ FL:33 Fi Fs:0}



static void Test_BFu33_Ui_BFu0s()
{
  {
    init_simple_test("BFu33_Ui_BFu0s");
    static STRUCT_IF_C BFu33_Ui_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Ui_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ui_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ui_BFu0s, BFu33_Ui_BFu0s)
//============================================================================


struct  BFu33_Ul_BFu0c  {
  __tsu64 v1:33;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu33_Ul_BFu0c) C1{ FL:33 FL Fc:0}



static void Test_BFu33_Ul_BFu0c()
{
  {
    init_simple_test("BFu33_Ul_BFu0c");
    static STRUCT_IF_C BFu33_Ul_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ul_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ul_BFu0c, BFu33_Ul_BFu0c)
//============================================================================


struct  BFu33_Ul_BFu0i  {
  __tsu64 v1:33;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu33_Ul_BFu0i) C1{ FL:33 FL Fi:0}



static void Test_BFu33_Ul_BFu0i()
{
  {
    init_simple_test("BFu33_Ul_BFu0i");
    static STRUCT_IF_C BFu33_Ul_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ul_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ul_BFu0i, BFu33_Ul_BFu0i)
//============================================================================


struct  BFu33_Ul_BFu0ll  {
  __tsu64 v1:33;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu33_Ul_BFu0ll) C1{ FL:33 FL FL:0}



static void Test_BFu33_Ul_BFu0ll()
{
  {
    init_simple_test("BFu33_Ul_BFu0ll");
    static STRUCT_IF_C BFu33_Ul_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ul_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ul_BFu0ll, BFu33_Ul_BFu0ll)
//============================================================================


struct  BFu33_Ul_BFu0s  {
  __tsu64 v1:33;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu33_Ul_BFu0s) C1{ FL:33 FL Fs:0}



static void Test_BFu33_Ul_BFu0s()
{
  {
    init_simple_test("BFu33_Ul_BFu0s");
    static STRUCT_IF_C BFu33_Ul_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ul_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Ul_BFu0s, BFu33_Ul_BFu0s)
//============================================================================


struct  BFu33_Us_BFu0c  {
  __tsu64 v1:33;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu33_Us_BFu0c) C1{ FL:33 Fs Fc:0}



static void Test_BFu33_Us_BFu0c()
{
  {
    init_simple_test("BFu33_Us_BFu0c");
    static STRUCT_IF_C BFu33_Us_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Us_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Us_BFu0c");
    check_field_offset(lv, v2, 6, "BFu33_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Us_BFu0c, BFu33_Us_BFu0c)
//============================================================================


struct  BFu33_Us_BFu0i  {
  __tsu64 v1:33;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu33_Us_BFu0i) C1{ FL:33 Fs Fi:0}



static void Test_BFu33_Us_BFu0i()
{
  {
    init_simple_test("BFu33_Us_BFu0i");
    static STRUCT_IF_C BFu33_Us_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Us_BFu0i");
    check_field_offset(lv, v2, 6, "BFu33_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Us_BFu0i, BFu33_Us_BFu0i)
//============================================================================


struct  BFu33_Us_BFu0ll  {
  __tsu64 v1:33;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu33_Us_BFu0ll) C1{ FL:33 Fs FL:0}



static void Test_BFu33_Us_BFu0ll()
{
  {
    init_simple_test("BFu33_Us_BFu0ll");
    static STRUCT_IF_C BFu33_Us_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Us_BFu0ll");
    check_field_offset(lv, v2, 6, "BFu33_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Us_BFu0ll, BFu33_Us_BFu0ll)
//============================================================================


struct  BFu33_Us_BFu0s  {
  __tsu64 v1:33;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu33_Us_BFu0s) C1{ FL:33 Fs Fs:0}



static void Test_BFu33_Us_BFu0s()
{
  {
    init_simple_test("BFu33_Us_BFu0s");
    static STRUCT_IF_C BFu33_Us_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Us_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Us_BFu0s");
    check_field_offset(lv, v2, 6, "BFu33_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Us_BFu0s, BFu33_Us_BFu0s)
//============================================================================


struct  BFu33_Vp_BFu0c  {
  __tsu64 v1:33;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu33_Vp_BFu0c) C1{ FL:33 Fp Fc:0}



static void Test_BFu33_Vp_BFu0c()
{
  {
    init_simple_test("BFu33_Vp_BFu0c");
    static STRUCT_IF_C BFu33_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Vp_BFu0c");
    check_field_offset(lv, v2, 8, "BFu33_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Vp_BFu0c, BFu33_Vp_BFu0c)
//============================================================================


struct  BFu33_Vp_BFu0i  {
  __tsu64 v1:33;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu33_Vp_BFu0i) C1{ FL:33 Fp Fi:0}



static void Test_BFu33_Vp_BFu0i()
{
  {
    init_simple_test("BFu33_Vp_BFu0i");
    static STRUCT_IF_C BFu33_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Vp_BFu0i");
    check_field_offset(lv, v2, 8, "BFu33_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Vp_BFu0i, BFu33_Vp_BFu0i)
//============================================================================


struct  BFu33_Vp_BFu0ll  {
  __tsu64 v1:33;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu33_Vp_BFu0ll) C1{ FL:33 Fp FL:0}



static void Test_BFu33_Vp_BFu0ll()
{
  {
    init_simple_test("BFu33_Vp_BFu0ll");
    static STRUCT_IF_C BFu33_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Vp_BFu0ll");
    check_field_offset(lv, v2, 8, "BFu33_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Vp_BFu0ll, BFu33_Vp_BFu0ll)
//============================================================================


struct  BFu33_Vp_BFu0s  {
  __tsu64 v1:33;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu33_Vp_BFu0s) C1{ FL:33 Fp Fs:0}



static void Test_BFu33_Vp_BFu0s()
{
  {
    init_simple_test("BFu33_Vp_BFu0s");
    static STRUCT_IF_C BFu33_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Vp_BFu0s");
    check_field_offset(lv, v2, 8, "BFu33_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu33_Vp_BFu0s, BFu33_Vp_BFu0s)
//============================================================================


struct  BFu7c_BFu0c  {
  unsigned char v1:7;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu0c) C1{ Fc:7 Fc:0}



static void Test_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu0c");
    static STRUCT_IF_C BFu7c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c, BFu7c_BFu0c)
//============================================================================


struct  BFu7c_BFu0c_BFu0c  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu0c_BFu0c) C1{ Fc:7 Fc:0 Fc:0}



static void Test_BFu7c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu0c");
    static STRUCT_IF_C BFu7c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu0c, BFu7c_BFu0c_BFu0c)
//============================================================================


struct  BFu7c_BFu0c_BFu0i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu0c_BFu0i) C1{ Fc:7 Fc:0 Fi:0}



static void Test_BFu7c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu0i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu0i, BFu7c_BFu0c_BFu0i)
//============================================================================


struct  BFu7c_BFu0c_BFu0ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu0c_BFu0ll) C1{ Fc:7 Fc:0 FL:0}



static void Test_BFu7c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu0ll, BFu7c_BFu0c_BFu0ll)
//============================================================================


struct  BFu7c_BFu0c_BFu0s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu0c_BFu0s) C1{ Fc:7 Fc:0 Fs:0}



static void Test_BFu7c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu0s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu0s, BFu7c_BFu0c_BFu0s)
//============================================================================


struct  BFu7c_BFu0c_BFu15i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7c_BFu0c_BFu15i) C1{ Fc:7 Fc:0 Fi:15}



static void Test_BFu7c_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu15i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu7c_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu15i, BFu7c_BFu0c_BFu15i)
//============================================================================


struct  BFu7c_BFu0c_BFu15ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7c_BFu0c_BFu15ll) C1{ Fc:7 Fc:0 FL:15}



static void Test_BFu7c_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu7c_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu15ll, BFu7c_BFu0c_BFu15ll)
//============================================================================


struct  BFu7c_BFu0c_BFu15s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7c_BFu0c_BFu15s) C1{ Fc:7 Fc:0 Fs:15}



static void Test_BFu7c_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu15s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu15s, BFu7c_BFu0c_BFu15s)
//============================================================================


struct  BFu7c_BFu0c_BFu16i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7c_BFu0c_BFu16i) C1{ Fc:7 Fc:0 Fi:16}



static void Test_BFu7c_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu16i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu7c_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu16i, BFu7c_BFu0c_BFu16i)
//============================================================================


struct  BFu7c_BFu0c_BFu16ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7c_BFu0c_BFu16ll) C1{ Fc:7 Fc:0 FL:16}



static void Test_BFu7c_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu7c_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu16ll, BFu7c_BFu0c_BFu16ll)
//============================================================================


struct  BFu7c_BFu0c_BFu16s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7c_BFu0c_BFu16s) C1{ Fc:7 Fc:0 Fs:16}



static void Test_BFu7c_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu16s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu16s, BFu7c_BFu0c_BFu16s)
//============================================================================


struct  BFu7c_BFu0c_BFu17i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7c_BFu0c_BFu17i) C1{ Fc:7 Fc:0 Fi:17}



static void Test_BFu7c_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu17i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu7c_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu17i, BFu7c_BFu0c_BFu17i)
//============================================================================


struct  BFu7c_BFu0c_BFu17ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7c_BFu0c_BFu17ll) C1{ Fc:7 Fc:0 FL:17}



static void Test_BFu7c_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu7c_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu17ll, BFu7c_BFu0c_BFu17ll)
//============================================================================


struct  BFu7c_BFu0c_BFu1c  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7c_BFu0c_BFu1c) C1{ Fc:7 Fc:0 Fc:1}



static void Test_BFu7c_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu1c");
    static STRUCT_IF_C BFu7c_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7c_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu1c, BFu7c_BFu0c_BFu1c)
//============================================================================


struct  BFu7c_BFu0c_BFu1i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7c_BFu0c_BFu1i) C1{ Fc:7 Fc:0 Fi:1}



static void Test_BFu7c_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu1i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7c_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu1i, BFu7c_BFu0c_BFu1i)
//============================================================================


struct  BFu7c_BFu0c_BFu1ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7c_BFu0c_BFu1ll) C1{ Fc:7 Fc:0 FL:1}



static void Test_BFu7c_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7c_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu1ll, BFu7c_BFu0c_BFu1ll)
//============================================================================


struct  BFu7c_BFu0c_BFu1s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7c_BFu0c_BFu1s) C1{ Fc:7 Fc:0 Fs:1}



static void Test_BFu7c_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu1s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7c_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu1s, BFu7c_BFu0c_BFu1s)
//============================================================================


struct  BFu7c_BFu0c_BFu31i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7c_BFu0c_BFu31i) C1{ Fc:7 Fc:0 Fi:31}



static void Test_BFu7c_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu31i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu31i, BFu7c_BFu0c_BFu31i)
//============================================================================


struct  BFu7c_BFu0c_BFu31ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7c_BFu0c_BFu31ll) C1{ Fc:7 Fc:0 FL:31}



static void Test_BFu7c_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu7c_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu31ll, BFu7c_BFu0c_BFu31ll)
//============================================================================


struct  BFu7c_BFu0c_BFu32i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7c_BFu0c_BFu32i) C1{ Fc:7 Fc:0 Fi:32}



static void Test_BFu7c_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu32i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu32i, BFu7c_BFu0c_BFu32i)
//============================================================================


struct  BFu7c_BFu0c_BFu32ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7c_BFu0c_BFu32ll) C1{ Fc:7 Fc:0 FL:32}



static void Test_BFu7c_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu7c_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu32ll, BFu7c_BFu0c_BFu32ll)
//============================================================================


struct  BFu7c_BFu0c_BFu33  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7c_BFu0c_BFu33) C1{ Fc:7 Fc:0 FL:33}



static void Test_BFu7c_BFu0c_BFu33()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu33");
    static STRUCT_IF_C BFu7c_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu7c_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu7c_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu33, BFu7c_BFu0c_BFu33)
//============================================================================


struct  BFu7c_BFu0c_BFu7c  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7c_BFu0c_BFu7c) C1{ Fc:7 Fc:0 Fc:7}



static void Test_BFu7c_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu7c");
    static STRUCT_IF_C BFu7c_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu7c, BFu7c_BFu0c_BFu7c)
//============================================================================


struct  BFu7c_BFu0c_BFu7i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7c_BFu0c_BFu7i) C1{ Fc:7 Fc:0 Fi:7}



static void Test_BFu7c_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu7i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu7i, BFu7c_BFu0c_BFu7i)
//============================================================================


struct  BFu7c_BFu0c_BFu7ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7c_BFu0c_BFu7ll) C1{ Fc:7 Fc:0 FL:7}



static void Test_BFu7c_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu7ll, BFu7c_BFu0c_BFu7ll)
//============================================================================


struct  BFu7c_BFu0c_BFu7s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7c_BFu0c_BFu7s) C1{ Fc:7 Fc:0 Fs:7}



static void Test_BFu7c_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu7s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu7s, BFu7c_BFu0c_BFu7s)
//============================================================================


struct  BFu7c_BFu0c_BFu8c  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7c_BFu0c_BFu8c) C1{ Fc:7 Fc:0 Fc:8}



static void Test_BFu7c_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu8c");
    static STRUCT_IF_C BFu7c_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu8c, BFu7c_BFu0c_BFu8c)
//============================================================================


struct  BFu7c_BFu0c_BFu8i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7c_BFu0c_BFu8i) C1{ Fc:7 Fc:0 Fi:8}



static void Test_BFu7c_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu8i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu8i, BFu7c_BFu0c_BFu8i)
//============================================================================


struct  BFu7c_BFu0c_BFu8ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7c_BFu0c_BFu8ll) C1{ Fc:7 Fc:0 FL:8}



static void Test_BFu7c_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu8ll, BFu7c_BFu0c_BFu8ll)
//============================================================================


struct  BFu7c_BFu0c_BFu8s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7c_BFu0c_BFu8s) C1{ Fc:7 Fc:0 Fs:8}



static void Test_BFu7c_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu8s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu8s, BFu7c_BFu0c_BFu8s)
//============================================================================


struct  BFu7c_BFu0c_BFu9i  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7c_BFu0c_BFu9i) C1{ Fc:7 Fc:0 Fi:9}



static void Test_BFu7c_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu9i");
    static STRUCT_IF_C BFu7c_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu7c_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu9i, BFu7c_BFu0c_BFu9i)
//============================================================================


struct  BFu7c_BFu0c_BFu9ll  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7c_BFu0c_BFu9ll) C1{ Fc:7 Fc:0 FL:9}



static void Test_BFu7c_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu7c_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu7c_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu9ll, BFu7c_BFu0c_BFu9ll)
//============================================================================


struct  BFu7c_BFu0c_BFu9s  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7c_BFu0c_BFu9s) C1{ Fc:7 Fc:0 Fs:9}



static void Test_BFu7c_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu7c_BFu0c_BFu9s");
    static STRUCT_IF_C BFu7c_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7c_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_BFu9s, BFu7c_BFu0c_BFu9s)
//============================================================================


struct  BFu7c_BFu0c_C  {
  unsigned char v1:7;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu7c_BFu0c_C) C1{ Fc:7 Fc:0 Fc}



static void Test_BFu7c_BFu0c_C()
{
  {
    init_simple_test("BFu7c_BFu0c_C");
    static STRUCT_IF_C BFu7c_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu7c_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_C, BFu7c_BFu0c_C)
//============================================================================


struct  BFu7c_BFu0c_D  {
  unsigned char v1:7;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu7c_BFu0c_D) C1{ Fc:7 Fc:0 FL}



static void Test_BFu7c_BFu0c_D()
{
  {
    init_simple_test("BFu7c_BFu0c_D");
    static STRUCT_IF_C BFu7c_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_D, BFu7c_BFu0c_D)
//============================================================================


struct  BFu7c_BFu0c_F  {
  unsigned char v1:7;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu7c_BFu0c_F) C1{ Fc:7 Fc:0 Fi}



static void Test_BFu7c_BFu0c_F()
{
  {
    init_simple_test("BFu7c_BFu0c_F");
    static STRUCT_IF_C BFu7c_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_F, BFu7c_BFu0c_F)
//============================================================================


struct  BFu7c_BFu0c_I  {
  unsigned char v1:7;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu7c_BFu0c_I) C1{ Fc:7 Fc:0 Fi}



static void Test_BFu7c_BFu0c_I()
{
  {
    init_simple_test("BFu7c_BFu0c_I");
    static STRUCT_IF_C BFu7c_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_I, BFu7c_BFu0c_I)
//============================================================================


struct  BFu7c_BFu0c_Ip  {
  unsigned char v1:7;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu7c_BFu0c_Ip) C1{ Fc:7 Fc:0 Fp}



static void Test_BFu7c_BFu0c_Ip()
{
  {
    init_simple_test("BFu7c_BFu0c_Ip");
    static STRUCT_IF_C BFu7c_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_Ip, BFu7c_BFu0c_Ip)
//============================================================================


struct  BFu7c_BFu0c_L  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu7c_BFu0c_L) C1{ Fc:7 Fc:0 FL}



static void Test_BFu7c_BFu0c_L()
{
  {
    init_simple_test("BFu7c_BFu0c_L");
    static STRUCT_IF_C BFu7c_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_L, BFu7c_BFu0c_L)
//============================================================================


struct  BFu7c_BFu0c_S  {
  unsigned char v1:7;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu7c_BFu0c_S) C1{ Fc:7 Fc:0 Fs}



static void Test_BFu7c_BFu0c_S()
{
  {
    init_simple_test("BFu7c_BFu0c_S");
    static STRUCT_IF_C BFu7c_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu7c_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_S, BFu7c_BFu0c_S)
//============================================================================


struct  BFu7c_BFu0c_Uc  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu7c_BFu0c_Uc) C1{ Fc:7 Fc:0 Fc}



static void Test_BFu7c_BFu0c_Uc()
{
  {
    init_simple_test("BFu7c_BFu0c_Uc");
    static STRUCT_IF_C BFu7c_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_Uc, BFu7c_BFu0c_Uc)
//============================================================================


struct  BFu7c_BFu0c_Ui  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu7c_BFu0c_Ui) C1{ Fc:7 Fc:0 Fi}



static void Test_BFu7c_BFu0c_Ui()
{
  {
    init_simple_test("BFu7c_BFu0c_Ui");
    static STRUCT_IF_C BFu7c_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_Ui, BFu7c_BFu0c_Ui)
//============================================================================


struct  BFu7c_BFu0c_Ul  {
  unsigned char v1:7;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu7c_BFu0c_Ul) C1{ Fc:7 Fc:0 FL}



static void Test_BFu7c_BFu0c_Ul()
{
  {
    init_simple_test("BFu7c_BFu0c_Ul");
    static STRUCT_IF_C BFu7c_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_Ul, BFu7c_BFu0c_Ul)
//============================================================================


struct  BFu7c_BFu0c_Us  {
  unsigned char v1:7;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu7c_BFu0c_Us) C1{ Fc:7 Fc:0 Fs}



static void Test_BFu7c_BFu0c_Us()
{
  {
    init_simple_test("BFu7c_BFu0c_Us");
    static STRUCT_IF_C BFu7c_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu7c_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_Us, BFu7c_BFu0c_Us)
//============================================================================


struct  BFu7c_BFu0c_Vp  {
  unsigned char v1:7;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu7c_BFu0c_Vp) C1{ Fc:7 Fc:0 Fp}



static void Test_BFu7c_BFu0c_Vp()
{
  {
    init_simple_test("BFu7c_BFu0c_Vp");
    static STRUCT_IF_C BFu7c_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0c_Vp, BFu7c_BFu0c_Vp)
//============================================================================


struct  BFu7c_BFu0i  {
  unsigned char v1:7;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu0i) C1{ Fc:7 Fi:0}



static void Test_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu0i");
    static STRUCT_IF_C BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i, BFu7c_BFu0i)
//============================================================================


struct  BFu7c_BFu0i_BFu0c  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu0i_BFu0c) C1{ Fc:7 Fi:0 Fc:0}



static void Test_BFu7c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu0c, BFu7c_BFu0i_BFu0c)
//============================================================================


struct  BFu7c_BFu0i_BFu0i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu0i_BFu0i) C1{ Fc:7 Fi:0 Fi:0}



static void Test_BFu7c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu0i, BFu7c_BFu0i_BFu0i)
//============================================================================


struct  BFu7c_BFu0i_BFu0ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu0i_BFu0ll) C1{ Fc:7 Fi:0 FL:0}



static void Test_BFu7c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu0ll, BFu7c_BFu0i_BFu0ll)
//============================================================================


struct  BFu7c_BFu0i_BFu0s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu0i_BFu0s) C1{ Fc:7 Fi:0 Fs:0}



static void Test_BFu7c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu0s, BFu7c_BFu0i_BFu0s)
//============================================================================


struct  BFu7c_BFu0i_BFu15i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7c_BFu0i_BFu15i) C1{ Fc:7 Fi:0 Fi:15}



static void Test_BFu7c_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu15i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7c_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu15i, BFu7c_BFu0i_BFu15i)
//============================================================================


struct  BFu7c_BFu0i_BFu15ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7c_BFu0i_BFu15ll) C1{ Fc:7 Fi:0 FL:15}



static void Test_BFu7c_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7c_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu15ll, BFu7c_BFu0i_BFu15ll)
//============================================================================


struct  BFu7c_BFu0i_BFu15s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7c_BFu0i_BFu15s) C1{ Fc:7 Fi:0 Fs:15}



static void Test_BFu7c_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu15s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7c_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu15s, BFu7c_BFu0i_BFu15s)
//============================================================================


struct  BFu7c_BFu0i_BFu16i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7c_BFu0i_BFu16i) C1{ Fc:7 Fi:0 Fi:16}



static void Test_BFu7c_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu16i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7c_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu16i, BFu7c_BFu0i_BFu16i)
//============================================================================


struct  BFu7c_BFu0i_BFu16ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7c_BFu0i_BFu16ll) C1{ Fc:7 Fi:0 FL:16}



static void Test_BFu7c_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7c_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu16ll, BFu7c_BFu0i_BFu16ll)
//============================================================================


struct  BFu7c_BFu0i_BFu16s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7c_BFu0i_BFu16s) C1{ Fc:7 Fi:0 Fs:16}



static void Test_BFu7c_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu16s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7c_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu16s, BFu7c_BFu0i_BFu16s)
//============================================================================


struct  BFu7c_BFu0i_BFu17i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7c_BFu0i_BFu17i) C1{ Fc:7 Fi:0 Fi:17}



static void Test_BFu7c_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu17i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7c_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu17i, BFu7c_BFu0i_BFu17i)
//============================================================================


struct  BFu7c_BFu0i_BFu17ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7c_BFu0i_BFu17ll) C1{ Fc:7 Fi:0 FL:17}



static void Test_BFu7c_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7c_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu17ll, BFu7c_BFu0i_BFu17ll)
//============================================================================


struct  BFu7c_BFu0i_BFu1c  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7c_BFu0i_BFu1c) C1{ Fc:7 Fi:0 Fc:1}



static void Test_BFu7c_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu1c");
    static STRUCT_IF_C BFu7c_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu7c_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7c_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu1c, BFu7c_BFu0i_BFu1c)
//============================================================================


struct  BFu7c_BFu0i_BFu1i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7c_BFu0i_BFu1i) C1{ Fc:7 Fi:0 Fi:1}



static void Test_BFu7c_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu1i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7c_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu1i, BFu7c_BFu0i_BFu1i)
//============================================================================


struct  BFu7c_BFu0i_BFu1ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7c_BFu0i_BFu1ll) C1{ Fc:7 Fi:0 FL:1}



static void Test_BFu7c_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7c_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu1ll, BFu7c_BFu0i_BFu1ll)
//============================================================================


struct  BFu7c_BFu0i_BFu1s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7c_BFu0i_BFu1s) C1{ Fc:7 Fi:0 Fs:1}



static void Test_BFu7c_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu1s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7c_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu1s, BFu7c_BFu0i_BFu1s)
//============================================================================


struct  BFu7c_BFu0i_BFu31i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7c_BFu0i_BFu31i) C1{ Fc:7 Fi:0 Fi:31}



static void Test_BFu7c_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu31i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu31i, BFu7c_BFu0i_BFu31i)
//============================================================================


struct  BFu7c_BFu0i_BFu31ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7c_BFu0i_BFu31ll) C1{ Fc:7 Fi:0 FL:31}



static void Test_BFu7c_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu31ll, BFu7c_BFu0i_BFu31ll)
//============================================================================


struct  BFu7c_BFu0i_BFu32i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7c_BFu0i_BFu32i) C1{ Fc:7 Fi:0 Fi:32}



static void Test_BFu7c_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu32i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu32i, BFu7c_BFu0i_BFu32i)
//============================================================================


struct  BFu7c_BFu0i_BFu32ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7c_BFu0i_BFu32ll) C1{ Fc:7 Fi:0 FL:32}



static void Test_BFu7c_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu32ll, BFu7c_BFu0i_BFu32ll)
//============================================================================


struct  BFu7c_BFu0i_BFu33  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7c_BFu0i_BFu33) C1{ Fc:7 Fi:0 FL:33}



static void Test_BFu7c_BFu0i_BFu33()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu33");
    static STRUCT_IF_C BFu7c_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu7c_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu7c_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu33, BFu7c_BFu0i_BFu33)
//============================================================================


struct  BFu7c_BFu0i_BFu7c  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7c_BFu0i_BFu7c) C1{ Fc:7 Fi:0 Fc:7}



static void Test_BFu7c_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu7c");
    static STRUCT_IF_C BFu7c_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu7c_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7c_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu7c, BFu7c_BFu0i_BFu7c)
//============================================================================


struct  BFu7c_BFu0i_BFu7i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7c_BFu0i_BFu7i) C1{ Fc:7 Fi:0 Fi:7}



static void Test_BFu7c_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu7i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7c_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu7i, BFu7c_BFu0i_BFu7i)
//============================================================================


struct  BFu7c_BFu0i_BFu7ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7c_BFu0i_BFu7ll) C1{ Fc:7 Fi:0 FL:7}



static void Test_BFu7c_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7c_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu7ll, BFu7c_BFu0i_BFu7ll)
//============================================================================


struct  BFu7c_BFu0i_BFu7s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7c_BFu0i_BFu7s) C1{ Fc:7 Fi:0 Fs:7}



static void Test_BFu7c_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu7s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7c_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu7s, BFu7c_BFu0i_BFu7s)
//============================================================================


struct  BFu7c_BFu0i_BFu8c  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7c_BFu0i_BFu8c) C1{ Fc:7 Fi:0 Fc:8}



static void Test_BFu7c_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu8c");
    static STRUCT_IF_C BFu7c_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu7c_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7c_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu8c, BFu7c_BFu0i_BFu8c)
//============================================================================


struct  BFu7c_BFu0i_BFu8i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7c_BFu0i_BFu8i) C1{ Fc:7 Fi:0 Fi:8}



static void Test_BFu7c_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu8i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7c_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu8i, BFu7c_BFu0i_BFu8i)
//============================================================================


struct  BFu7c_BFu0i_BFu8ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7c_BFu0i_BFu8ll) C1{ Fc:7 Fi:0 FL:8}



static void Test_BFu7c_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7c_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu8ll, BFu7c_BFu0i_BFu8ll)
//============================================================================


struct  BFu7c_BFu0i_BFu8s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7c_BFu0i_BFu8s) C1{ Fc:7 Fi:0 Fs:8}



static void Test_BFu7c_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu8s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7c_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu8s, BFu7c_BFu0i_BFu8s)
//============================================================================


struct  BFu7c_BFu0i_BFu9i  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7c_BFu0i_BFu9i) C1{ Fc:7 Fi:0 Fi:9}



static void Test_BFu7c_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu9i");
    static STRUCT_IF_C BFu7c_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7c_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu9i, BFu7c_BFu0i_BFu9i)
//============================================================================


struct  BFu7c_BFu0i_BFu9ll  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7c_BFu0i_BFu9ll) C1{ Fc:7 Fi:0 FL:9}



static void Test_BFu7c_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu7c_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7c_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu9ll, BFu7c_BFu0i_BFu9ll)
//============================================================================


struct  BFu7c_BFu0i_BFu9s  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7c_BFu0i_BFu9s) C1{ Fc:7 Fi:0 Fs:9}



static void Test_BFu7c_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu7c_BFu0i_BFu9s");
    static STRUCT_IF_C BFu7c_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7c_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_BFu9s, BFu7c_BFu0i_BFu9s)
//============================================================================


struct  BFu7c_BFu0i_C  {
  unsigned char v1:7;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu7c_BFu0i_C) C1{ Fc:7 Fi:0 Fc}



static void Test_BFu7c_BFu0i_C()
{
  {
    init_simple_test("BFu7c_BFu0i_C");
    static STRUCT_IF_C BFu7c_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu7c_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_C, BFu7c_BFu0i_C)
//============================================================================


struct  BFu7c_BFu0i_D  {
  unsigned char v1:7;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu7c_BFu0i_D) C1{ Fc:7 Fi:0 FL}



static void Test_BFu7c_BFu0i_D()
{
  {
    init_simple_test("BFu7c_BFu0i_D");
    static STRUCT_IF_C BFu7c_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_D, BFu7c_BFu0i_D)
//============================================================================


struct  BFu7c_BFu0i_F  {
  unsigned char v1:7;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu7c_BFu0i_F) C1{ Fc:7 Fi:0 Fi}



static void Test_BFu7c_BFu0i_F()
{
  {
    init_simple_test("BFu7c_BFu0i_F");
    static STRUCT_IF_C BFu7c_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_F, BFu7c_BFu0i_F)
//============================================================================


struct  BFu7c_BFu0i_I  {
  unsigned char v1:7;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu7c_BFu0i_I) C1{ Fc:7 Fi:0 Fi}



static void Test_BFu7c_BFu0i_I()
{
  {
    init_simple_test("BFu7c_BFu0i_I");
    static STRUCT_IF_C BFu7c_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_I, BFu7c_BFu0i_I)
//============================================================================


struct  BFu7c_BFu0i_Ip  {
  unsigned char v1:7;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu7c_BFu0i_Ip) C1{ Fc:7 Fi:0 Fp}



static void Test_BFu7c_BFu0i_Ip()
{
  {
    init_simple_test("BFu7c_BFu0i_Ip");
    static STRUCT_IF_C BFu7c_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_Ip, BFu7c_BFu0i_Ip)
//============================================================================


struct  BFu7c_BFu0i_L  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu7c_BFu0i_L) C1{ Fc:7 Fi:0 FL}



static void Test_BFu7c_BFu0i_L()
{
  {
    init_simple_test("BFu7c_BFu0i_L");
    static STRUCT_IF_C BFu7c_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_L, BFu7c_BFu0i_L)
//============================================================================


struct  BFu7c_BFu0i_S  {
  unsigned char v1:7;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu7c_BFu0i_S) C1{ Fc:7 Fi:0 Fs}



static void Test_BFu7c_BFu0i_S()
{
  {
    init_simple_test("BFu7c_BFu0i_S");
    static STRUCT_IF_C BFu7c_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_S, BFu7c_BFu0i_S)
//============================================================================


struct  BFu7c_BFu0i_Uc  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu7c_BFu0i_Uc) C1{ Fc:7 Fi:0 Fc}



static void Test_BFu7c_BFu0i_Uc()
{
  {
    init_simple_test("BFu7c_BFu0i_Uc");
    static STRUCT_IF_C BFu7c_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu7c_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_Uc, BFu7c_BFu0i_Uc)
//============================================================================


struct  BFu7c_BFu0i_Ui  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu7c_BFu0i_Ui) C1{ Fc:7 Fi:0 Fi}



static void Test_BFu7c_BFu0i_Ui()
{
  {
    init_simple_test("BFu7c_BFu0i_Ui");
    static STRUCT_IF_C BFu7c_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_Ui, BFu7c_BFu0i_Ui)
//============================================================================


struct  BFu7c_BFu0i_Ul  {
  unsigned char v1:7;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu7c_BFu0i_Ul) C1{ Fc:7 Fi:0 FL}



static void Test_BFu7c_BFu0i_Ul()
{
  {
    init_simple_test("BFu7c_BFu0i_Ul");
    static STRUCT_IF_C BFu7c_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_Ul, BFu7c_BFu0i_Ul)
//============================================================================


struct  BFu7c_BFu0i_Us  {
  unsigned char v1:7;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu7c_BFu0i_Us) C1{ Fc:7 Fi:0 Fs}



static void Test_BFu7c_BFu0i_Us()
{
  {
    init_simple_test("BFu7c_BFu0i_Us");
    static STRUCT_IF_C BFu7c_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu7c_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_Us, BFu7c_BFu0i_Us)
//============================================================================


struct  BFu7c_BFu0i_Vp  {
  unsigned char v1:7;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu7c_BFu0i_Vp) C1{ Fc:7 Fi:0 Fp}



static void Test_BFu7c_BFu0i_Vp()
{
  {
    init_simple_test("BFu7c_BFu0i_Vp");
    static STRUCT_IF_C BFu7c_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0i_Vp, BFu7c_BFu0i_Vp)
//============================================================================


struct  BFu7c_BFu0ll  {
  unsigned char v1:7;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu0ll) C1{ Fc:7 FL:0}



static void Test_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll, BFu7c_BFu0ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu0c  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu0ll_BFu0c) C1{ Fc:7 FL:0 Fc:0}



static void Test_BFu7c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu0c, BFu7c_BFu0ll_BFu0c)
//============================================================================


struct  BFu7c_BFu0ll_BFu0i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu0ll_BFu0i) C1{ Fc:7 FL:0 Fi:0}



static void Test_BFu7c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu0i, BFu7c_BFu0ll_BFu0i)
//============================================================================


struct  BFu7c_BFu0ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu0ll_BFu0ll) C1{ Fc:7 FL:0 FL:0}



static void Test_BFu7c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu0ll, BFu7c_BFu0ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu0s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu0ll_BFu0s) C1{ Fc:7 FL:0 Fs:0}



static void Test_BFu7c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu0s, BFu7c_BFu0ll_BFu0s)
//============================================================================


struct  BFu7c_BFu0ll_BFu15i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7c_BFu0ll_BFu15i) C1{ Fc:7 FL:0 Fi:15}



static void Test_BFu7c_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7c_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu15i, BFu7c_BFu0ll_BFu15i)
//============================================================================


struct  BFu7c_BFu0ll_BFu15ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7c_BFu0ll_BFu15ll) C1{ Fc:7 FL:0 FL:15}



static void Test_BFu7c_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7c_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu15ll, BFu7c_BFu0ll_BFu15ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu15s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7c_BFu0ll_BFu15s) C1{ Fc:7 FL:0 Fs:15}



static void Test_BFu7c_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7c_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu15s, BFu7c_BFu0ll_BFu15s)
//============================================================================


struct  BFu7c_BFu0ll_BFu16i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7c_BFu0ll_BFu16i) C1{ Fc:7 FL:0 Fi:16}



static void Test_BFu7c_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7c_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu16i, BFu7c_BFu0ll_BFu16i)
//============================================================================


struct  BFu7c_BFu0ll_BFu16ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7c_BFu0ll_BFu16ll) C1{ Fc:7 FL:0 FL:16}



static void Test_BFu7c_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7c_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu16ll, BFu7c_BFu0ll_BFu16ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu16s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7c_BFu0ll_BFu16s) C1{ Fc:7 FL:0 Fs:16}



static void Test_BFu7c_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7c_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu16s, BFu7c_BFu0ll_BFu16s)
//============================================================================


struct  BFu7c_BFu0ll_BFu17i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7c_BFu0ll_BFu17i) C1{ Fc:7 FL:0 Fi:17}



static void Test_BFu7c_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu7c_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu17i, BFu7c_BFu0ll_BFu17i)
//============================================================================


struct  BFu7c_BFu0ll_BFu17ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7c_BFu0ll_BFu17ll) C1{ Fc:7 FL:0 FL:17}



static void Test_BFu7c_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu7c_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu17ll, BFu7c_BFu0ll_BFu17ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu1c  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7c_BFu0ll_BFu1c) C1{ Fc:7 FL:0 Fc:1}



static void Test_BFu7c_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7c_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu1c, BFu7c_BFu0ll_BFu1c)
//============================================================================


struct  BFu7c_BFu0ll_BFu1i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7c_BFu0ll_BFu1i) C1{ Fc:7 FL:0 Fi:1}



static void Test_BFu7c_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7c_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu1i, BFu7c_BFu0ll_BFu1i)
//============================================================================


struct  BFu7c_BFu0ll_BFu1ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7c_BFu0ll_BFu1ll) C1{ Fc:7 FL:0 FL:1}



static void Test_BFu7c_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7c_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu1ll, BFu7c_BFu0ll_BFu1ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu1s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7c_BFu0ll_BFu1s) C1{ Fc:7 FL:0 Fs:1}



static void Test_BFu7c_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7c_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu1s, BFu7c_BFu0ll_BFu1s)
//============================================================================


struct  BFu7c_BFu0ll_BFu31i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7c_BFu0ll_BFu31i) C1{ Fc:7 FL:0 Fi:31}



static void Test_BFu7c_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu7c_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu31i, BFu7c_BFu0ll_BFu31i)
//============================================================================


struct  BFu7c_BFu0ll_BFu31ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7c_BFu0ll_BFu31ll) C1{ Fc:7 FL:0 FL:31}



static void Test_BFu7c_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu7c_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu31ll, BFu7c_BFu0ll_BFu31ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu32i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7c_BFu0ll_BFu32i) C1{ Fc:7 FL:0 Fi:32}



static void Test_BFu7c_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu7c_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu32i, BFu7c_BFu0ll_BFu32i)
//============================================================================


struct  BFu7c_BFu0ll_BFu32ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7c_BFu0ll_BFu32ll) C1{ Fc:7 FL:0 FL:32}



static void Test_BFu7c_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu7c_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu32ll, BFu7c_BFu0ll_BFu32ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu33  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7c_BFu0ll_BFu33) C1{ Fc:7 FL:0 FL:33}



static void Test_BFu7c_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu33");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu7c_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu7c_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu33, BFu7c_BFu0ll_BFu33)
//============================================================================


struct  BFu7c_BFu0ll_BFu7c  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7c_BFu0ll_BFu7c) C1{ Fc:7 FL:0 Fc:7}



static void Test_BFu7c_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7c_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu7c, BFu7c_BFu0ll_BFu7c)
//============================================================================


struct  BFu7c_BFu0ll_BFu7i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7c_BFu0ll_BFu7i) C1{ Fc:7 FL:0 Fi:7}



static void Test_BFu7c_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7c_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu7i, BFu7c_BFu0ll_BFu7i)
//============================================================================


struct  BFu7c_BFu0ll_BFu7ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7c_BFu0ll_BFu7ll) C1{ Fc:7 FL:0 FL:7}



static void Test_BFu7c_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7c_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu7ll, BFu7c_BFu0ll_BFu7ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu7s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7c_BFu0ll_BFu7s) C1{ Fc:7 FL:0 Fs:7}



static void Test_BFu7c_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7c_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu7s, BFu7c_BFu0ll_BFu7s)
//============================================================================


struct  BFu7c_BFu0ll_BFu8c  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7c_BFu0ll_BFu8c) C1{ Fc:7 FL:0 Fc:8}



static void Test_BFu7c_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7c_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu8c, BFu7c_BFu0ll_BFu8c)
//============================================================================


struct  BFu7c_BFu0ll_BFu8i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7c_BFu0ll_BFu8i) C1{ Fc:7 FL:0 Fi:8}



static void Test_BFu7c_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7c_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu8i, BFu7c_BFu0ll_BFu8i)
//============================================================================


struct  BFu7c_BFu0ll_BFu8ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7c_BFu0ll_BFu8ll) C1{ Fc:7 FL:0 FL:8}



static void Test_BFu7c_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7c_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu8ll, BFu7c_BFu0ll_BFu8ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu8s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7c_BFu0ll_BFu8s) C1{ Fc:7 FL:0 Fs:8}



static void Test_BFu7c_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7c_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu8s, BFu7c_BFu0ll_BFu8s)
//============================================================================


struct  BFu7c_BFu0ll_BFu9i  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7c_BFu0ll_BFu9i) C1{ Fc:7 FL:0 Fi:9}



static void Test_BFu7c_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7c_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu9i, BFu7c_BFu0ll_BFu9i)
//============================================================================


struct  BFu7c_BFu0ll_BFu9ll  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7c_BFu0ll_BFu9ll) C1{ Fc:7 FL:0 FL:9}



static void Test_BFu7c_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7c_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu9ll, BFu7c_BFu0ll_BFu9ll)
//============================================================================


struct  BFu7c_BFu0ll_BFu9s  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7c_BFu0ll_BFu9s) C1{ Fc:7 FL:0 Fs:9}



static void Test_BFu7c_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu7c_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu7c_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7c_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_BFu9s, BFu7c_BFu0ll_BFu9s)
//============================================================================


struct  BFu7c_BFu0ll_C  {
  unsigned char v1:7;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu7c_BFu0ll_C) C1{ Fc:7 FL:0 Fc}



static void Test_BFu7c_BFu0ll_C()
{
  {
    init_simple_test("BFu7c_BFu0ll_C");
    static STRUCT_IF_C BFu7c_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_C, BFu7c_BFu0ll_C)
//============================================================================


struct  BFu7c_BFu0ll_D  {
  unsigned char v1:7;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu7c_BFu0ll_D) C1{ Fc:7 FL:0 FL}



static void Test_BFu7c_BFu0ll_D()
{
  {
    init_simple_test("BFu7c_BFu0ll_D");
    static STRUCT_IF_C BFu7c_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_D, BFu7c_BFu0ll_D)
//============================================================================


struct  BFu7c_BFu0ll_F  {
  unsigned char v1:7;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu7c_BFu0ll_F) C1{ Fc:7 FL:0 Fi}



static void Test_BFu7c_BFu0ll_F()
{
  {
    init_simple_test("BFu7c_BFu0ll_F");
    static STRUCT_IF_C BFu7c_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_F, BFu7c_BFu0ll_F)
//============================================================================


struct  BFu7c_BFu0ll_I  {
  unsigned char v1:7;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu7c_BFu0ll_I) C1{ Fc:7 FL:0 Fi}



static void Test_BFu7c_BFu0ll_I()
{
  {
    init_simple_test("BFu7c_BFu0ll_I");
    static STRUCT_IF_C BFu7c_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_I, BFu7c_BFu0ll_I)
//============================================================================


struct  BFu7c_BFu0ll_Ip  {
  unsigned char v1:7;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu7c_BFu0ll_Ip) C1{ Fc:7 FL:0 Fp}



static void Test_BFu7c_BFu0ll_Ip()
{
  {
    init_simple_test("BFu7c_BFu0ll_Ip");
    static STRUCT_IF_C BFu7c_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_Ip, BFu7c_BFu0ll_Ip)
//============================================================================


struct  BFu7c_BFu0ll_L  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu7c_BFu0ll_L) C1{ Fc:7 FL:0 FL}



static void Test_BFu7c_BFu0ll_L()
{
  {
    init_simple_test("BFu7c_BFu0ll_L");
    static STRUCT_IF_C BFu7c_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_L, BFu7c_BFu0ll_L)
//============================================================================


struct  BFu7c_BFu0ll_S  {
  unsigned char v1:7;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu7c_BFu0ll_S) C1{ Fc:7 FL:0 Fs}



static void Test_BFu7c_BFu0ll_S()
{
  {
    init_simple_test("BFu7c_BFu0ll_S");
    static STRUCT_IF_C BFu7c_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_S, BFu7c_BFu0ll_S)
//============================================================================


struct  BFu7c_BFu0ll_Uc  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu7c_BFu0ll_Uc) C1{ Fc:7 FL:0 Fc}



static void Test_BFu7c_BFu0ll_Uc()
{
  {
    init_simple_test("BFu7c_BFu0ll_Uc");
    static STRUCT_IF_C BFu7c_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu7c_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_Uc, BFu7c_BFu0ll_Uc)
//============================================================================


struct  BFu7c_BFu0ll_Ui  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu7c_BFu0ll_Ui) C1{ Fc:7 FL:0 Fi}



static void Test_BFu7c_BFu0ll_Ui()
{
  {
    init_simple_test("BFu7c_BFu0ll_Ui");
    static STRUCT_IF_C BFu7c_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7c_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_Ui, BFu7c_BFu0ll_Ui)
//============================================================================


struct  BFu7c_BFu0ll_Ul  {
  unsigned char v1:7;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu7c_BFu0ll_Ul) C1{ Fc:7 FL:0 FL}



static void Test_BFu7c_BFu0ll_Ul()
{
  {
    init_simple_test("BFu7c_BFu0ll_Ul");
    static STRUCT_IF_C BFu7c_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_Ul, BFu7c_BFu0ll_Ul)
//============================================================================


struct  BFu7c_BFu0ll_Us  {
  unsigned char v1:7;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu7c_BFu0ll_Us) C1{ Fc:7 FL:0 Fs}



static void Test_BFu7c_BFu0ll_Us()
{
  {
    init_simple_test("BFu7c_BFu0ll_Us");
    static STRUCT_IF_C BFu7c_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu7c_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_Us, BFu7c_BFu0ll_Us)
//============================================================================


struct  BFu7c_BFu0ll_Vp  {
  unsigned char v1:7;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu7c_BFu0ll_Vp) C1{ Fc:7 FL:0 Fp}



static void Test_BFu7c_BFu0ll_Vp()
{
  {
    init_simple_test("BFu7c_BFu0ll_Vp");
    static STRUCT_IF_C BFu7c_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0ll_Vp, BFu7c_BFu0ll_Vp)
//============================================================================


struct  BFu7c_BFu0s  {
  unsigned char v1:7;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu0s) C1{ Fc:7 Fs:0}



static void Test_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu0s");
    static STRUCT_IF_C BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s, BFu7c_BFu0s)
//============================================================================


struct  BFu7c_BFu0s_BFu0c  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu0s_BFu0c) C1{ Fc:7 Fs:0 Fc:0}



static void Test_BFu7c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu0c, BFu7c_BFu0s_BFu0c)
//============================================================================


struct  BFu7c_BFu0s_BFu0i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu0s_BFu0i) C1{ Fc:7 Fs:0 Fi:0}



static void Test_BFu7c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu0i, BFu7c_BFu0s_BFu0i)
//============================================================================


struct  BFu7c_BFu0s_BFu0ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu0s_BFu0ll) C1{ Fc:7 Fs:0 FL:0}



static void Test_BFu7c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu0ll, BFu7c_BFu0s_BFu0ll)
//============================================================================


struct  BFu7c_BFu0s_BFu0s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu0s_BFu0s) C1{ Fc:7 Fs:0 Fs:0}



static void Test_BFu7c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu0s, BFu7c_BFu0s_BFu0s)
//============================================================================


struct  BFu7c_BFu0s_BFu15i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7c_BFu0s_BFu15i) C1{ Fc:7 Fs:0 Fi:15}



static void Test_BFu7c_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu15i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu15i, BFu7c_BFu0s_BFu15i)
//============================================================================


struct  BFu7c_BFu0s_BFu15ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7c_BFu0s_BFu15ll) C1{ Fc:7 Fs:0 FL:15}



static void Test_BFu7c_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu15ll, BFu7c_BFu0s_BFu15ll)
//============================================================================


struct  BFu7c_BFu0s_BFu15s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7c_BFu0s_BFu15s) C1{ Fc:7 Fs:0 Fs:15}



static void Test_BFu7c_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu15s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu15s, BFu7c_BFu0s_BFu15s)
//============================================================================


struct  BFu7c_BFu0s_BFu16i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7c_BFu0s_BFu16i) C1{ Fc:7 Fs:0 Fi:16}



static void Test_BFu7c_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu16i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu16i, BFu7c_BFu0s_BFu16i)
//============================================================================


struct  BFu7c_BFu0s_BFu16ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7c_BFu0s_BFu16ll) C1{ Fc:7 Fs:0 FL:16}



static void Test_BFu7c_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu16ll, BFu7c_BFu0s_BFu16ll)
//============================================================================


struct  BFu7c_BFu0s_BFu16s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7c_BFu0s_BFu16s) C1{ Fc:7 Fs:0 Fs:16}



static void Test_BFu7c_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu16s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu16s, BFu7c_BFu0s_BFu16s)
//============================================================================


struct  BFu7c_BFu0s_BFu17i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7c_BFu0s_BFu17i) C1{ Fc:7 Fs:0 Fi:17}



static void Test_BFu7c_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu17i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7c_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu17i, BFu7c_BFu0s_BFu17i)
//============================================================================


struct  BFu7c_BFu0s_BFu17ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7c_BFu0s_BFu17ll) C1{ Fc:7 Fs:0 FL:17}



static void Test_BFu7c_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu7c_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu7c_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu17ll, BFu7c_BFu0s_BFu17ll)
//============================================================================


struct  BFu7c_BFu0s_BFu1c  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7c_BFu0s_BFu1c) C1{ Fc:7 Fs:0 Fc:1}



static void Test_BFu7c_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu1c");
    static STRUCT_IF_C BFu7c_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu7c_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7c_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu1c, BFu7c_BFu0s_BFu1c)
//============================================================================


struct  BFu7c_BFu0s_BFu1i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7c_BFu0s_BFu1i) C1{ Fc:7 Fs:0 Fi:1}



static void Test_BFu7c_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu1i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7c_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu1i, BFu7c_BFu0s_BFu1i)
//============================================================================


struct  BFu7c_BFu0s_BFu1ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7c_BFu0s_BFu1ll) C1{ Fc:7 Fs:0 FL:1}



static void Test_BFu7c_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7c_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu1ll, BFu7c_BFu0s_BFu1ll)
//============================================================================


struct  BFu7c_BFu0s_BFu1s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7c_BFu0s_BFu1s) C1{ Fc:7 Fs:0 Fs:1}



static void Test_BFu7c_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu1s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7c_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu1s, BFu7c_BFu0s_BFu1s)
//============================================================================


struct  BFu7c_BFu0s_BFu31i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7c_BFu0s_BFu31i) C1{ Fc:7 Fs:0 Fi:31}



static void Test_BFu7c_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu31i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu31i, BFu7c_BFu0s_BFu31i)
//============================================================================


struct  BFu7c_BFu0s_BFu31ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7c_BFu0s_BFu31ll) C1{ Fc:7 Fs:0 FL:31}



static void Test_BFu7c_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu7c_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu31ll, BFu7c_BFu0s_BFu31ll)
//============================================================================


struct  BFu7c_BFu0s_BFu32i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7c_BFu0s_BFu32i) C1{ Fc:7 Fs:0 Fi:32}



static void Test_BFu7c_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu32i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu32i, BFu7c_BFu0s_BFu32i)
//============================================================================


struct  BFu7c_BFu0s_BFu32ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7c_BFu0s_BFu32ll) C1{ Fc:7 Fs:0 FL:32}



static void Test_BFu7c_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu7c_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu32ll, BFu7c_BFu0s_BFu32ll)
//============================================================================


struct  BFu7c_BFu0s_BFu33  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7c_BFu0s_BFu33) C1{ Fc:7 Fs:0 FL:33}



static void Test_BFu7c_BFu0s_BFu33()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu33");
    static STRUCT_IF_C BFu7c_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu7c_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu7c_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu33, BFu7c_BFu0s_BFu33)
//============================================================================


struct  BFu7c_BFu0s_BFu7c  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7c_BFu0s_BFu7c) C1{ Fc:7 Fs:0 Fc:7}



static void Test_BFu7c_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu7c");
    static STRUCT_IF_C BFu7c_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu7c_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7c_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu7c, BFu7c_BFu0s_BFu7c)
//============================================================================


struct  BFu7c_BFu0s_BFu7i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7c_BFu0s_BFu7i) C1{ Fc:7 Fs:0 Fi:7}



static void Test_BFu7c_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu7i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7c_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu7i, BFu7c_BFu0s_BFu7i)
//============================================================================


struct  BFu7c_BFu0s_BFu7ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7c_BFu0s_BFu7ll) C1{ Fc:7 Fs:0 FL:7}



static void Test_BFu7c_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7c_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu7ll, BFu7c_BFu0s_BFu7ll)
//============================================================================


struct  BFu7c_BFu0s_BFu7s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7c_BFu0s_BFu7s) C1{ Fc:7 Fs:0 Fs:7}



static void Test_BFu7c_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu7s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7c_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu7s, BFu7c_BFu0s_BFu7s)
//============================================================================


struct  BFu7c_BFu0s_BFu8c  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7c_BFu0s_BFu8c) C1{ Fc:7 Fs:0 Fc:8}



static void Test_BFu7c_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu8c");
    static STRUCT_IF_C BFu7c_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu7c_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7c_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu8c, BFu7c_BFu0s_BFu8c)
//============================================================================


struct  BFu7c_BFu0s_BFu8i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7c_BFu0s_BFu8i) C1{ Fc:7 Fs:0 Fi:8}



static void Test_BFu7c_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu8i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7c_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu8i, BFu7c_BFu0s_BFu8i)
//============================================================================


struct  BFu7c_BFu0s_BFu8ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7c_BFu0s_BFu8ll) C1{ Fc:7 Fs:0 FL:8}



static void Test_BFu7c_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7c_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu8ll, BFu7c_BFu0s_BFu8ll)
//============================================================================


struct  BFu7c_BFu0s_BFu8s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7c_BFu0s_BFu8s) C1{ Fc:7 Fs:0 Fs:8}



static void Test_BFu7c_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu8s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7c_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu8s, BFu7c_BFu0s_BFu8s)
//============================================================================


struct  BFu7c_BFu0s_BFu9i  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7c_BFu0s_BFu9i) C1{ Fc:7 Fs:0 Fi:9}



static void Test_BFu7c_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu9i");
    static STRUCT_IF_C BFu7c_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7c_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu9i, BFu7c_BFu0s_BFu9i)
//============================================================================


struct  BFu7c_BFu0s_BFu9ll  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7c_BFu0s_BFu9ll) C1{ Fc:7 Fs:0 FL:9}



static void Test_BFu7c_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu7c_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7c_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu9ll, BFu7c_BFu0s_BFu9ll)
//============================================================================


struct  BFu7c_BFu0s_BFu9s  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7c_BFu0s_BFu9s) C1{ Fc:7 Fs:0 Fs:9}



static void Test_BFu7c_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu7c_BFu0s_BFu9s");
    static STRUCT_IF_C BFu7c_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7c_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_BFu9s, BFu7c_BFu0s_BFu9s)
//============================================================================


struct  BFu7c_BFu0s_C  {
  unsigned char v1:7;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu7c_BFu0s_C) C1{ Fc:7 Fs:0 Fc}



static void Test_BFu7c_BFu0s_C()
{
  {
    init_simple_test("BFu7c_BFu0s_C");
    static STRUCT_IF_C BFu7c_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu7c_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu7c_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_C, BFu7c_BFu0s_C)
//============================================================================


struct  BFu7c_BFu0s_D  {
  unsigned char v1:7;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu7c_BFu0s_D) C1{ Fc:7 Fs:0 FL}



static void Test_BFu7c_BFu0s_D()
{
  {
    init_simple_test("BFu7c_BFu0s_D");
    static STRUCT_IF_C BFu7c_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_D, BFu7c_BFu0s_D)
//============================================================================


struct  BFu7c_BFu0s_F  {
  unsigned char v1:7;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu7c_BFu0s_F) C1{ Fc:7 Fs:0 Fi}



static void Test_BFu7c_BFu0s_F()
{
  {
    init_simple_test("BFu7c_BFu0s_F");
    static STRUCT_IF_C BFu7c_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_F, BFu7c_BFu0s_F)
//============================================================================


struct  BFu7c_BFu0s_I  {
  unsigned char v1:7;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu7c_BFu0s_I) C1{ Fc:7 Fs:0 Fi}



static void Test_BFu7c_BFu0s_I()
{
  {
    init_simple_test("BFu7c_BFu0s_I");
    static STRUCT_IF_C BFu7c_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_I, BFu7c_BFu0s_I)
//============================================================================


struct  BFu7c_BFu0s_Ip  {
  unsigned char v1:7;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu7c_BFu0s_Ip) C1{ Fc:7 Fs:0 Fp}



static void Test_BFu7c_BFu0s_Ip()
{
  {
    init_simple_test("BFu7c_BFu0s_Ip");
    static STRUCT_IF_C BFu7c_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_Ip, BFu7c_BFu0s_Ip)
//============================================================================


struct  BFu7c_BFu0s_L  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu7c_BFu0s_L) C1{ Fc:7 Fs:0 FL}



static void Test_BFu7c_BFu0s_L()
{
  {
    init_simple_test("BFu7c_BFu0s_L");
    static STRUCT_IF_C BFu7c_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_L, BFu7c_BFu0s_L)
//============================================================================


struct  BFu7c_BFu0s_S  {
  unsigned char v1:7;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu7c_BFu0s_S) C1{ Fc:7 Fs:0 Fs}



static void Test_BFu7c_BFu0s_S()
{
  {
    init_simple_test("BFu7c_BFu0s_S");
    static STRUCT_IF_C BFu7c_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu7c_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_S, BFu7c_BFu0s_S)
//============================================================================


struct  BFu7c_BFu0s_Uc  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu7c_BFu0s_Uc) C1{ Fc:7 Fs:0 Fc}



static void Test_BFu7c_BFu0s_Uc()
{
  {
    init_simple_test("BFu7c_BFu0s_Uc");
    static STRUCT_IF_C BFu7c_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu7c_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu7c_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_Uc, BFu7c_BFu0s_Uc)
//============================================================================


struct  BFu7c_BFu0s_Ui  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu7c_BFu0s_Ui) C1{ Fc:7 Fs:0 Fi}



static void Test_BFu7c_BFu0s_Ui()
{
  {
    init_simple_test("BFu7c_BFu0s_Ui");
    static STRUCT_IF_C BFu7c_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu7c_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_Ui, BFu7c_BFu0s_Ui)
//============================================================================


struct  BFu7c_BFu0s_Ul  {
  unsigned char v1:7;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu7c_BFu0s_Ul) C1{ Fc:7 Fs:0 FL}



static void Test_BFu7c_BFu0s_Ul()
{
  {
    init_simple_test("BFu7c_BFu0s_Ul");
    static STRUCT_IF_C BFu7c_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_Ul, BFu7c_BFu0s_Ul)
//============================================================================


struct  BFu7c_BFu0s_Us  {
  unsigned char v1:7;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu7c_BFu0s_Us) C1{ Fc:7 Fs:0 Fs}



static void Test_BFu7c_BFu0s_Us()
{
  {
    init_simple_test("BFu7c_BFu0s_Us");
    static STRUCT_IF_C BFu7c_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu0s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu7c_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_Us, BFu7c_BFu0s_Us)
//============================================================================


struct  BFu7c_BFu0s_Vp  {
  unsigned char v1:7;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu7c_BFu0s_Vp) C1{ Fc:7 Fs:0 Fp}



static void Test_BFu7c_BFu0s_Vp()
{
  {
    init_simple_test("BFu7c_BFu0s_Vp");
    static STRUCT_IF_C BFu7c_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu0s_Vp, BFu7c_BFu0s_Vp)
//============================================================================


struct  BFu7c_BFu15i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu15i_BFu0c) C1{ Fc:7 Fi:15 Fc:0}



static void Test_BFu7c_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu15i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15i_BFu0c, BFu7c_BFu15i_BFu0c)
//============================================================================


struct  BFu7c_BFu15i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu15i_BFu0i) C1{ Fc:7 Fi:15 Fi:0}



static void Test_BFu7c_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu15i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15i_BFu0i, BFu7c_BFu15i_BFu0i)
//============================================================================


struct  BFu7c_BFu15i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu15i_BFu0ll) C1{ Fc:7 Fi:15 FL:0}



static void Test_BFu7c_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15i_BFu0ll, BFu7c_BFu15i_BFu0ll)
//============================================================================


struct  BFu7c_BFu15i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu15i_BFu0s) C1{ Fc:7 Fi:15 Fs:0}



static void Test_BFu7c_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu15i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15i_BFu0s, BFu7c_BFu15i_BFu0s)
//============================================================================


struct  BFu7c_BFu15ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu15ll_BFu0c) C1{ Fc:7 FL:15 Fc:0}



static void Test_BFu7c_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15ll_BFu0c, BFu7c_BFu15ll_BFu0c)
//============================================================================


struct  BFu7c_BFu15ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu15ll_BFu0i) C1{ Fc:7 FL:15 Fi:0}



static void Test_BFu7c_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15ll_BFu0i, BFu7c_BFu15ll_BFu0i)
//============================================================================


struct  BFu7c_BFu15ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu15ll_BFu0ll) C1{ Fc:7 FL:15 FL:0}



static void Test_BFu7c_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15ll_BFu0ll, BFu7c_BFu15ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu15ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu15ll_BFu0s) C1{ Fc:7 FL:15 Fs:0}



static void Test_BFu7c_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15ll_BFu0s, BFu7c_BFu15ll_BFu0s)
//============================================================================


struct  BFu7c_BFu15s_BFu0c  {
  unsigned char v1:7;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu15s_BFu0c) C1{ Fc:7 Fs:15 Fc:0}



static void Test_BFu7c_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu15s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15s_BFu0c, BFu7c_BFu15s_BFu0c)
//============================================================================


struct  BFu7c_BFu15s_BFu0i  {
  unsigned char v1:7;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu15s_BFu0i) C1{ Fc:7 Fs:15 Fi:0}



static void Test_BFu7c_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu15s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15s_BFu0i, BFu7c_BFu15s_BFu0i)
//============================================================================


struct  BFu7c_BFu15s_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu15s_BFu0ll) C1{ Fc:7 Fs:15 FL:0}



static void Test_BFu7c_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15s_BFu0ll, BFu7c_BFu15s_BFu0ll)
//============================================================================


struct  BFu7c_BFu15s_BFu0s  {
  unsigned char v1:7;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu15s_BFu0s) C1{ Fc:7 Fs:15 Fs:0}



static void Test_BFu7c_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu15s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu15s_BFu0s, BFu7c_BFu15s_BFu0s)
//============================================================================


struct  BFu7c_BFu16i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu16i_BFu0c) C1{ Fc:7 Fi:16 Fc:0}



static void Test_BFu7c_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu16i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16i_BFu0c, BFu7c_BFu16i_BFu0c)
//============================================================================


struct  BFu7c_BFu16i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu16i_BFu0i) C1{ Fc:7 Fi:16 Fi:0}



static void Test_BFu7c_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu16i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16i_BFu0i, BFu7c_BFu16i_BFu0i)
//============================================================================


struct  BFu7c_BFu16i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu16i_BFu0ll) C1{ Fc:7 Fi:16 FL:0}



static void Test_BFu7c_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16i_BFu0ll, BFu7c_BFu16i_BFu0ll)
//============================================================================


struct  BFu7c_BFu16i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu16i_BFu0s) C1{ Fc:7 Fi:16 Fs:0}



static void Test_BFu7c_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu16i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16i_BFu0s, BFu7c_BFu16i_BFu0s)
//============================================================================


struct  BFu7c_BFu16ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu16ll_BFu0c) C1{ Fc:7 FL:16 Fc:0}



static void Test_BFu7c_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16ll_BFu0c, BFu7c_BFu16ll_BFu0c)
//============================================================================


struct  BFu7c_BFu16ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu16ll_BFu0i) C1{ Fc:7 FL:16 Fi:0}



static void Test_BFu7c_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16ll_BFu0i, BFu7c_BFu16ll_BFu0i)
//============================================================================


struct  BFu7c_BFu16ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu16ll_BFu0ll) C1{ Fc:7 FL:16 FL:0}



static void Test_BFu7c_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16ll_BFu0ll, BFu7c_BFu16ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu16ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu16ll_BFu0s) C1{ Fc:7 FL:16 Fs:0}



static void Test_BFu7c_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16ll_BFu0s, BFu7c_BFu16ll_BFu0s)
//============================================================================


struct  BFu7c_BFu16s_BFu0c  {
  unsigned char v1:7;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu16s_BFu0c) C1{ Fc:7 Fs:16 Fc:0}



static void Test_BFu7c_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu16s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16s_BFu0c, BFu7c_BFu16s_BFu0c)
//============================================================================


struct  BFu7c_BFu16s_BFu0i  {
  unsigned char v1:7;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu16s_BFu0i) C1{ Fc:7 Fs:16 Fi:0}



static void Test_BFu7c_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu16s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16s_BFu0i, BFu7c_BFu16s_BFu0i)
//============================================================================


struct  BFu7c_BFu16s_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu16s_BFu0ll) C1{ Fc:7 Fs:16 FL:0}



static void Test_BFu7c_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16s_BFu0ll, BFu7c_BFu16s_BFu0ll)
//============================================================================


struct  BFu7c_BFu16s_BFu0s  {
  unsigned char v1:7;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu16s_BFu0s) C1{ Fc:7 Fs:16 Fs:0}



static void Test_BFu7c_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu16s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu16s_BFu0s, BFu7c_BFu16s_BFu0s)
//============================================================================


struct  BFu7c_BFu17i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu17i_BFu0c) C1{ Fc:7 Fi:17 Fc:0}



static void Test_BFu7c_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu17i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17i_BFu0c, BFu7c_BFu17i_BFu0c)
//============================================================================


struct  BFu7c_BFu17i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu17i_BFu0i) C1{ Fc:7 Fi:17 Fi:0}



static void Test_BFu7c_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu17i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17i_BFu0i, BFu7c_BFu17i_BFu0i)
//============================================================================


struct  BFu7c_BFu17i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu17i_BFu0ll) C1{ Fc:7 Fi:17 FL:0}



static void Test_BFu7c_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17i_BFu0ll, BFu7c_BFu17i_BFu0ll)
//============================================================================


struct  BFu7c_BFu17i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu17i_BFu0s) C1{ Fc:7 Fi:17 Fs:0}



static void Test_BFu7c_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu17i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17i_BFu0s, BFu7c_BFu17i_BFu0s)
//============================================================================


struct  BFu7c_BFu17ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu17ll_BFu0c) C1{ Fc:7 FL:17 Fc:0}



static void Test_BFu7c_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17ll_BFu0c, BFu7c_BFu17ll_BFu0c)
//============================================================================


struct  BFu7c_BFu17ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu17ll_BFu0i) C1{ Fc:7 FL:17 Fi:0}



static void Test_BFu7c_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17ll_BFu0i, BFu7c_BFu17ll_BFu0i)
//============================================================================


struct  BFu7c_BFu17ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu17ll_BFu0ll) C1{ Fc:7 FL:17 FL:0}



static void Test_BFu7c_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17ll_BFu0ll, BFu7c_BFu17ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu17ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu17ll_BFu0s) C1{ Fc:7 FL:17 Fs:0}



static void Test_BFu7c_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu17ll_BFu0s, BFu7c_BFu17ll_BFu0s)
//============================================================================


struct  BFu7c_BFu1c_BFu0c  {
  unsigned char v1:7;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu1c_BFu0c) C1{ Fc:7 Fc:1 Fc:0}



static void Test_BFu7c_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu1c_BFu0c");
    static STRUCT_IF_C BFu7c_BFu1c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu7c_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1c_BFu0c, BFu7c_BFu1c_BFu0c)
//============================================================================


struct  BFu7c_BFu1c_BFu0i  {
  unsigned char v1:7;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu1c_BFu0i) C1{ Fc:7 Fc:1 Fi:0}



static void Test_BFu7c_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu1c_BFu0i");
    static STRUCT_IF_C BFu7c_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1c_BFu0i, BFu7c_BFu1c_BFu0i)
//============================================================================


struct  BFu7c_BFu1c_BFu0ll  {
  unsigned char v1:7;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu1c_BFu0ll) C1{ Fc:7 Fc:1 FL:0}



static void Test_BFu7c_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1c_BFu0ll, BFu7c_BFu1c_BFu0ll)
//============================================================================


struct  BFu7c_BFu1c_BFu0s  {
  unsigned char v1:7;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu1c_BFu0s) C1{ Fc:7 Fc:1 Fs:0}



static void Test_BFu7c_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu1c_BFu0s");
    static STRUCT_IF_C BFu7c_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1c_BFu0s, BFu7c_BFu1c_BFu0s)
//============================================================================


struct  BFu7c_BFu1i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu1i_BFu0c) C1{ Fc:7 Fi:1 Fc:0}



static void Test_BFu7c_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu1i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1i_BFu0c, BFu7c_BFu1i_BFu0c)
//============================================================================


struct  BFu7c_BFu1i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu1i_BFu0i) C1{ Fc:7 Fi:1 Fi:0}



static void Test_BFu7c_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu1i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1i_BFu0i, BFu7c_BFu1i_BFu0i)
//============================================================================


struct  BFu7c_BFu1i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu1i_BFu0ll) C1{ Fc:7 Fi:1 FL:0}



static void Test_BFu7c_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1i_BFu0ll, BFu7c_BFu1i_BFu0ll)
//============================================================================


struct  BFu7c_BFu1i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu1i_BFu0s) C1{ Fc:7 Fi:1 Fs:0}



static void Test_BFu7c_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu1i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1i_BFu0s, BFu7c_BFu1i_BFu0s)
//============================================================================


struct  BFu7c_BFu1ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu1ll_BFu0c) C1{ Fc:7 FL:1 Fc:0}



static void Test_BFu7c_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1ll_BFu0c, BFu7c_BFu1ll_BFu0c)
//============================================================================


struct  BFu7c_BFu1ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu1ll_BFu0i) C1{ Fc:7 FL:1 Fi:0}



static void Test_BFu7c_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1ll_BFu0i, BFu7c_BFu1ll_BFu0i)
//============================================================================


struct  BFu7c_BFu1ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu1ll_BFu0ll) C1{ Fc:7 FL:1 FL:0}



static void Test_BFu7c_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1ll_BFu0ll, BFu7c_BFu1ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu1ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu1ll_BFu0s) C1{ Fc:7 FL:1 Fs:0}



static void Test_BFu7c_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1ll_BFu0s, BFu7c_BFu1ll_BFu0s)
//============================================================================


struct  BFu7c_BFu1s_BFu0c  {
  unsigned char v1:7;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu1s_BFu0c) C1{ Fc:7 Fs:1 Fc:0}



static void Test_BFu7c_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu1s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu1s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1s_BFu0c, BFu7c_BFu1s_BFu0c)
//============================================================================


struct  BFu7c_BFu1s_BFu0i  {
  unsigned char v1:7;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu1s_BFu0i) C1{ Fc:7 Fs:1 Fi:0}



static void Test_BFu7c_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu1s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1s_BFu0i, BFu7c_BFu1s_BFu0i)
//============================================================================


struct  BFu7c_BFu1s_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu1s_BFu0ll) C1{ Fc:7 Fs:1 FL:0}



static void Test_BFu7c_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1s_BFu0ll, BFu7c_BFu1s_BFu0ll)
//============================================================================


struct  BFu7c_BFu1s_BFu0s  {
  unsigned char v1:7;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu1s_BFu0s) C1{ Fc:7 Fs:1 Fs:0}



static void Test_BFu7c_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu1s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu1s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu1s_BFu0s, BFu7c_BFu1s_BFu0s)
//============================================================================


struct  BFu7c_BFu31i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu31i_BFu0c) C1{ Fc:7 Fi:31 Fc:0}



static void Test_BFu7c_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu31i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31i_BFu0c, BFu7c_BFu31i_BFu0c)
//============================================================================


struct  BFu7c_BFu31i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu31i_BFu0i) C1{ Fc:7 Fi:31 Fi:0}



static void Test_BFu7c_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu31i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31i_BFu0i, BFu7c_BFu31i_BFu0i)
//============================================================================


struct  BFu7c_BFu31i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu31i_BFu0ll) C1{ Fc:7 Fi:31 FL:0}



static void Test_BFu7c_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31i_BFu0ll, BFu7c_BFu31i_BFu0ll)
//============================================================================


struct  BFu7c_BFu31i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu31i_BFu0s) C1{ Fc:7 Fi:31 Fs:0}



static void Test_BFu7c_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu31i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31i_BFu0s, BFu7c_BFu31i_BFu0s)
//============================================================================


struct  BFu7c_BFu31ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu31ll_BFu0c) C1{ Fc:7 FL:31 Fc:0}



static void Test_BFu7c_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31ll_BFu0c, BFu7c_BFu31ll_BFu0c)
//============================================================================


struct  BFu7c_BFu31ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu31ll_BFu0i) C1{ Fc:7 FL:31 Fi:0}



static void Test_BFu7c_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31ll_BFu0i, BFu7c_BFu31ll_BFu0i)
//============================================================================


struct  BFu7c_BFu31ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu31ll_BFu0ll) C1{ Fc:7 FL:31 FL:0}



static void Test_BFu7c_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31ll_BFu0ll, BFu7c_BFu31ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu31ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu31ll_BFu0s) C1{ Fc:7 FL:31 Fs:0}



static void Test_BFu7c_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu31ll_BFu0s, BFu7c_BFu31ll_BFu0s)
//============================================================================


struct  BFu7c_BFu32i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu32i_BFu0c) C1{ Fc:7 Fi:32 Fc:0}



static void Test_BFu7c_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu32i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32i_BFu0c, BFu7c_BFu32i_BFu0c)
//============================================================================


struct  BFu7c_BFu32i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu32i_BFu0i) C1{ Fc:7 Fi:32 Fi:0}



static void Test_BFu7c_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu32i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32i_BFu0i, BFu7c_BFu32i_BFu0i)
//============================================================================


struct  BFu7c_BFu32i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu32i_BFu0ll) C1{ Fc:7 Fi:32 FL:0}



static void Test_BFu7c_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32i_BFu0ll, BFu7c_BFu32i_BFu0ll)
//============================================================================


struct  BFu7c_BFu32i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu32i_BFu0s) C1{ Fc:7 Fi:32 Fs:0}



static void Test_BFu7c_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu32i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32i_BFu0s, BFu7c_BFu32i_BFu0s)
//============================================================================


struct  BFu7c_BFu32ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu32ll_BFu0c) C1{ Fc:7 FL:32 Fc:0}



static void Test_BFu7c_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32ll_BFu0c, BFu7c_BFu32ll_BFu0c)
//============================================================================


struct  BFu7c_BFu32ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu32ll_BFu0i) C1{ Fc:7 FL:32 Fi:0}



static void Test_BFu7c_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32ll_BFu0i, BFu7c_BFu32ll_BFu0i)
//============================================================================


struct  BFu7c_BFu32ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu32ll_BFu0ll) C1{ Fc:7 FL:32 FL:0}



static void Test_BFu7c_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32ll_BFu0ll, BFu7c_BFu32ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu32ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu32ll_BFu0s) C1{ Fc:7 FL:32 Fs:0}



static void Test_BFu7c_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu32ll_BFu0s, BFu7c_BFu32ll_BFu0s)
//============================================================================


struct  BFu7c_BFu33_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu33_BFu0c) C1{ Fc:7 FL:33 Fc:0}



static void Test_BFu7c_BFu33_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu33_BFu0c");
    static STRUCT_IF_C BFu7c_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7c_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7c_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu33_BFu0c, BFu7c_BFu33_BFu0c)
//============================================================================


struct  BFu7c_BFu33_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu33_BFu0i) C1{ Fc:7 FL:33 Fi:0}



static void Test_BFu7c_BFu33_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu33_BFu0i");
    static STRUCT_IF_C BFu7c_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7c_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7c_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu33_BFu0i, BFu7c_BFu33_BFu0i)
//============================================================================


struct  BFu7c_BFu33_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu33_BFu0ll) C1{ Fc:7 FL:33 FL:0}



static void Test_BFu7c_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu33_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7c_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7c_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu33_BFu0ll, BFu7c_BFu33_BFu0ll)
//============================================================================


struct  BFu7c_BFu33_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu33_BFu0s) C1{ Fc:7 FL:33 Fs:0}



static void Test_BFu7c_BFu33_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu33_BFu0s");
    static STRUCT_IF_C BFu7c_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7c_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7c_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu33_BFu0s, BFu7c_BFu33_BFu0s)
//============================================================================


struct  BFu7c_BFu7c_BFu0c  {
  unsigned char v1:7;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu7c_BFu0c) C1{ Fc:7 Fc:7 Fc:0}



static void Test_BFu7c_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu7c_BFu0c");
    static STRUCT_IF_C BFu7c_BFu7c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7c_BFu0c, BFu7c_BFu7c_BFu0c)
//============================================================================


struct  BFu7c_BFu7c_BFu0i  {
  unsigned char v1:7;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu7c_BFu0i) C1{ Fc:7 Fc:7 Fi:0}



static void Test_BFu7c_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu7c_BFu0i");
    static STRUCT_IF_C BFu7c_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7c_BFu0i, BFu7c_BFu7c_BFu0i)
//============================================================================


struct  BFu7c_BFu7c_BFu0ll  {
  unsigned char v1:7;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu7c_BFu0ll) C1{ Fc:7 Fc:7 FL:0}



static void Test_BFu7c_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7c_BFu0ll, BFu7c_BFu7c_BFu0ll)
//============================================================================


struct  BFu7c_BFu7c_BFu0s  {
  unsigned char v1:7;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu7c_BFu0s) C1{ Fc:7 Fc:7 Fs:0}



static void Test_BFu7c_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu7c_BFu0s");
    static STRUCT_IF_C BFu7c_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7c_BFu0s, BFu7c_BFu7c_BFu0s)
//============================================================================


struct  BFu7c_BFu7i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu7i_BFu0c) C1{ Fc:7 Fi:7 Fc:0}



static void Test_BFu7c_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu7i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7i_BFu0c, BFu7c_BFu7i_BFu0c)
//============================================================================


struct  BFu7c_BFu7i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu7i_BFu0i) C1{ Fc:7 Fi:7 Fi:0}



static void Test_BFu7c_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu7i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7i_BFu0i, BFu7c_BFu7i_BFu0i)
//============================================================================


struct  BFu7c_BFu7i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu7i_BFu0ll) C1{ Fc:7 Fi:7 FL:0}



static void Test_BFu7c_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7i_BFu0ll, BFu7c_BFu7i_BFu0ll)
//============================================================================


struct  BFu7c_BFu7i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu7i_BFu0s) C1{ Fc:7 Fi:7 Fs:0}



static void Test_BFu7c_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu7i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7i_BFu0s, BFu7c_BFu7i_BFu0s)
//============================================================================


struct  BFu7c_BFu7ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu7ll_BFu0c) C1{ Fc:7 FL:7 Fc:0}



static void Test_BFu7c_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7ll_BFu0c, BFu7c_BFu7ll_BFu0c)
//============================================================================


struct  BFu7c_BFu7ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu7ll_BFu0i) C1{ Fc:7 FL:7 Fi:0}



static void Test_BFu7c_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7ll_BFu0i, BFu7c_BFu7ll_BFu0i)
//============================================================================


struct  BFu7c_BFu7ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu7ll_BFu0ll) C1{ Fc:7 FL:7 FL:0}



static void Test_BFu7c_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7ll_BFu0ll, BFu7c_BFu7ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu7ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu7ll_BFu0s) C1{ Fc:7 FL:7 Fs:0}



static void Test_BFu7c_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7ll_BFu0s, BFu7c_BFu7ll_BFu0s)
//============================================================================


struct  BFu7c_BFu7s_BFu0c  {
  unsigned char v1:7;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu7s_BFu0c) C1{ Fc:7 Fs:7 Fc:0}



static void Test_BFu7c_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu7s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7s_BFu0c, BFu7c_BFu7s_BFu0c)
//============================================================================


struct  BFu7c_BFu7s_BFu0i  {
  unsigned char v1:7;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu7s_BFu0i) C1{ Fc:7 Fs:7 Fi:0}



static void Test_BFu7c_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu7s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7s_BFu0i, BFu7c_BFu7s_BFu0i)
//============================================================================


struct  BFu7c_BFu7s_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu7s_BFu0ll) C1{ Fc:7 Fs:7 FL:0}



static void Test_BFu7c_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7s_BFu0ll, BFu7c_BFu7s_BFu0ll)
//============================================================================


struct  BFu7c_BFu7s_BFu0s  {
  unsigned char v1:7;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu7s_BFu0s) C1{ Fc:7 Fs:7 Fs:0}



static void Test_BFu7c_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu7s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu7s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu7s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu7s_BFu0s, BFu7c_BFu7s_BFu0s)
//============================================================================


struct  BFu7c_BFu8c_BFu0c  {
  unsigned char v1:7;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu8c_BFu0c) C1{ Fc:7 Fc:8 Fc:0}



static void Test_BFu7c_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu8c_BFu0c");
    static STRUCT_IF_C BFu7c_BFu8c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8c_BFu0c, BFu7c_BFu8c_BFu0c)
//============================================================================


struct  BFu7c_BFu8c_BFu0i  {
  unsigned char v1:7;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu8c_BFu0i) C1{ Fc:7 Fc:8 Fi:0}



static void Test_BFu7c_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu8c_BFu0i");
    static STRUCT_IF_C BFu7c_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8c_BFu0i, BFu7c_BFu8c_BFu0i)
//============================================================================


struct  BFu7c_BFu8c_BFu0ll  {
  unsigned char v1:7;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu8c_BFu0ll) C1{ Fc:7 Fc:8 FL:0}



static void Test_BFu7c_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8c_BFu0ll, BFu7c_BFu8c_BFu0ll)
//============================================================================


struct  BFu7c_BFu8c_BFu0s  {
  unsigned char v1:7;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu8c_BFu0s) C1{ Fc:7 Fc:8 Fs:0}



static void Test_BFu7c_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu8c_BFu0s");
    static STRUCT_IF_C BFu7c_BFu8c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8c_BFu0s, BFu7c_BFu8c_BFu0s)
//============================================================================


struct  BFu7c_BFu8i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu8i_BFu0c) C1{ Fc:7 Fi:8 Fc:0}



static void Test_BFu7c_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu8i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8i_BFu0c, BFu7c_BFu8i_BFu0c)
//============================================================================


struct  BFu7c_BFu8i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu8i_BFu0i) C1{ Fc:7 Fi:8 Fi:0}



static void Test_BFu7c_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu8i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8i_BFu0i, BFu7c_BFu8i_BFu0i)
//============================================================================


struct  BFu7c_BFu8i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu8i_BFu0ll) C1{ Fc:7 Fi:8 FL:0}



static void Test_BFu7c_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8i_BFu0ll, BFu7c_BFu8i_BFu0ll)
//============================================================================


struct  BFu7c_BFu8i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu8i_BFu0s) C1{ Fc:7 Fi:8 Fs:0}



static void Test_BFu7c_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu8i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8i_BFu0s, BFu7c_BFu8i_BFu0s)
//============================================================================


struct  BFu7c_BFu8ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu8ll_BFu0c) C1{ Fc:7 FL:8 Fc:0}



static void Test_BFu7c_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8ll_BFu0c, BFu7c_BFu8ll_BFu0c)
//============================================================================


struct  BFu7c_BFu8ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu8ll_BFu0i) C1{ Fc:7 FL:8 Fi:0}



static void Test_BFu7c_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8ll_BFu0i, BFu7c_BFu8ll_BFu0i)
//============================================================================


struct  BFu7c_BFu8ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu8ll_BFu0ll) C1{ Fc:7 FL:8 FL:0}



static void Test_BFu7c_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8ll_BFu0ll, BFu7c_BFu8ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu8ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu8ll_BFu0s) C1{ Fc:7 FL:8 Fs:0}



static void Test_BFu7c_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8ll_BFu0s, BFu7c_BFu8ll_BFu0s)
//============================================================================


struct  BFu7c_BFu8s_BFu0c  {
  unsigned char v1:7;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu8s_BFu0c) C1{ Fc:7 Fs:8 Fc:0}



static void Test_BFu7c_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu8s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu8s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8s_BFu0c, BFu7c_BFu8s_BFu0c)
//============================================================================


struct  BFu7c_BFu8s_BFu0i  {
  unsigned char v1:7;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu8s_BFu0i) C1{ Fc:7 Fs:8 Fi:0}



static void Test_BFu7c_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu8s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8s_BFu0i, BFu7c_BFu8s_BFu0i)
//============================================================================


struct  BFu7c_BFu8s_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu8s_BFu0ll) C1{ Fc:7 Fs:8 FL:0}



static void Test_BFu7c_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8s_BFu0ll, BFu7c_BFu8s_BFu0ll)
//============================================================================


struct  BFu7c_BFu8s_BFu0s  {
  unsigned char v1:7;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu8s_BFu0s) C1{ Fc:7 Fs:8 Fs:0}



static void Test_BFu7c_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu8s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu8s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu8s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu8s_BFu0s, BFu7c_BFu8s_BFu0s)
//============================================================================


struct  BFu7c_BFu9i_BFu0c  {
  unsigned char v1:7;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu9i_BFu0c) C1{ Fc:7 Fi:9 Fc:0}



static void Test_BFu7c_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu9i_BFu0c");
    static STRUCT_IF_C BFu7c_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9i_BFu0c, BFu7c_BFu9i_BFu0c)
//============================================================================


struct  BFu7c_BFu9i_BFu0i  {
  unsigned char v1:7;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu9i_BFu0i) C1{ Fc:7 Fi:9 Fi:0}



static void Test_BFu7c_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu9i_BFu0i");
    static STRUCT_IF_C BFu7c_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9i_BFu0i, BFu7c_BFu9i_BFu0i)
//============================================================================


struct  BFu7c_BFu9i_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu9i_BFu0ll) C1{ Fc:7 Fi:9 FL:0}



static void Test_BFu7c_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9i_BFu0ll, BFu7c_BFu9i_BFu0ll)
//============================================================================


struct  BFu7c_BFu9i_BFu0s  {
  unsigned char v1:7;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu9i_BFu0s) C1{ Fc:7 Fi:9 Fs:0}



static void Test_BFu7c_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu9i_BFu0s");
    static STRUCT_IF_C BFu7c_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9i_BFu0s, BFu7c_BFu9i_BFu0s)
//============================================================================


struct  BFu7c_BFu9ll_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu9ll_BFu0c) C1{ Fc:7 FL:9 Fc:0}



static void Test_BFu7c_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu7c_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9ll_BFu0c, BFu7c_BFu9ll_BFu0c)
//============================================================================


struct  BFu7c_BFu9ll_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu9ll_BFu0i) C1{ Fc:7 FL:9 Fi:0}



static void Test_BFu7c_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu7c_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9ll_BFu0i, BFu7c_BFu9ll_BFu0i)
//============================================================================


struct  BFu7c_BFu9ll_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu9ll_BFu0ll) C1{ Fc:7 FL:9 FL:0}



static void Test_BFu7c_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9ll_BFu0ll, BFu7c_BFu9ll_BFu0ll)
//============================================================================


struct  BFu7c_BFu9ll_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu9ll_BFu0s) C1{ Fc:7 FL:9 Fs:0}



static void Test_BFu7c_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu7c_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9ll_BFu0s, BFu7c_BFu9ll_BFu0s)
//============================================================================


struct  BFu7c_BFu9s_BFu0c  {
  unsigned char v1:7;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu7c_BFu9s_BFu0c) C1{ Fc:7 Fs:9 Fc:0}



static void Test_BFu7c_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu7c_BFu9s_BFu0c");
    static STRUCT_IF_C BFu7c_BFu9s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu9s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9s_BFu0c, BFu7c_BFu9s_BFu0c)
//============================================================================


struct  BFu7c_BFu9s_BFu0i  {
  unsigned char v1:7;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu7c_BFu9s_BFu0i) C1{ Fc:7 Fs:9 Fi:0}



static void Test_BFu7c_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu7c_BFu9s_BFu0i");
    static STRUCT_IF_C BFu7c_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9s_BFu0i, BFu7c_BFu9s_BFu0i)
//============================================================================


struct  BFu7c_BFu9s_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu7c_BFu9s_BFu0ll) C1{ Fc:7 Fs:9 FL:0}



static void Test_BFu7c_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu7c_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu7c_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9s_BFu0ll, BFu7c_BFu9s_BFu0ll)
//============================================================================


struct  BFu7c_BFu9s_BFu0s  {
  unsigned char v1:7;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu7c_BFu9s_BFu0s) C1{ Fc:7 Fs:9 Fs:0}



static void Test_BFu7c_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu7c_BFu9s_BFu0s");
    static STRUCT_IF_C BFu7c_BFu9s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu9s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_BFu9s_BFu0s, BFu7c_BFu9s_BFu0s)
//============================================================================


struct  BFu7c_C_BFu0c  {
  unsigned char v1:7;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_C_BFu0c) C1{ Fc:7 Fc Fc:0}



static void Test_BFu7c_C_BFu0c()
{
  {
    init_simple_test("BFu7c_C_BFu0c");
    static STRUCT_IF_C BFu7c_C_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_C_BFu0c");
    check_field_offset(lv, v2, 1, "BFu7c_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_C_BFu0c, BFu7c_C_BFu0c)
//============================================================================


struct  BFu7c_C_BFu0i  {
  unsigned char v1:7;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_C_BFu0i) C1{ Fc:7 Fc Fi:0}



static void Test_BFu7c_C_BFu0i()
{
  {
    init_simple_test("BFu7c_C_BFu0i");
    static STRUCT_IF_C BFu7c_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_C_BFu0i");
    check_field_offset(lv, v2, 1, "BFu7c_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_C_BFu0i, BFu7c_C_BFu0i)
//============================================================================


struct  BFu7c_C_BFu0ll  {
  unsigned char v1:7;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_C_BFu0ll) C1{ Fc:7 Fc FL:0}



static void Test_BFu7c_C_BFu0ll()
{
  {
    init_simple_test("BFu7c_C_BFu0ll");
    static STRUCT_IF_C BFu7c_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_C_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu7c_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_C_BFu0ll, BFu7c_C_BFu0ll)
//============================================================================


struct  BFu7c_C_BFu0s  {
  unsigned char v1:7;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_C_BFu0s) C1{ Fc:7 Fc Fs:0}



static void Test_BFu7c_C_BFu0s()
{
  {
    init_simple_test("BFu7c_C_BFu0s");
    static STRUCT_IF_C BFu7c_C_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_C_BFu0s");
    check_field_offset(lv, v2, 1, "BFu7c_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_C_BFu0s, BFu7c_C_BFu0s)
//============================================================================


struct  BFu7c_D_BFu0c  {
  unsigned char v1:7;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_D_BFu0c) C1{ Fc:7 FL Fc:0}



static void Test_BFu7c_D_BFu0c()
{
  {
    init_simple_test("BFu7c_D_BFu0c");
    static STRUCT_IF_C BFu7c_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_D_BFu0c, BFu7c_D_BFu0c)
//============================================================================


struct  BFu7c_D_BFu0i  {
  unsigned char v1:7;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_D_BFu0i) C1{ Fc:7 FL Fi:0}



static void Test_BFu7c_D_BFu0i()
{
  {
    init_simple_test("BFu7c_D_BFu0i");
    static STRUCT_IF_C BFu7c_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_D_BFu0i, BFu7c_D_BFu0i)
//============================================================================


struct  BFu7c_D_BFu0ll  {
  unsigned char v1:7;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_D_BFu0ll) C1{ Fc:7 FL FL:0}



static void Test_BFu7c_D_BFu0ll()
{
  {
    init_simple_test("BFu7c_D_BFu0ll");
    static STRUCT_IF_C BFu7c_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_D_BFu0ll, BFu7c_D_BFu0ll)
//============================================================================


struct  BFu7c_D_BFu0s  {
  unsigned char v1:7;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_D_BFu0s) C1{ Fc:7 FL Fs:0}



static void Test_BFu7c_D_BFu0s()
{
  {
    init_simple_test("BFu7c_D_BFu0s");
    static STRUCT_IF_C BFu7c_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_D_BFu0s, BFu7c_D_BFu0s)
//============================================================================


struct  BFu7c_F_BFu0c  {
  unsigned char v1:7;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_F_BFu0c) C1{ Fc:7 Fi Fc:0}



static void Test_BFu7c_F_BFu0c()
{
  {
    init_simple_test("BFu7c_F_BFu0c");
    static STRUCT_IF_C BFu7c_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu7c_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_F_BFu0c, BFu7c_F_BFu0c)
//============================================================================


struct  BFu7c_F_BFu0i  {
  unsigned char v1:7;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_F_BFu0i) C1{ Fc:7 Fi Fi:0}



static void Test_BFu7c_F_BFu0i()
{
  {
    init_simple_test("BFu7c_F_BFu0i");
    static STRUCT_IF_C BFu7c_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu7c_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_F_BFu0i, BFu7c_F_BFu0i)
//============================================================================


struct  BFu7c_F_BFu0ll  {
  unsigned char v1:7;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_F_BFu0ll) C1{ Fc:7 Fi FL:0}



static void Test_BFu7c_F_BFu0ll()
{
  {
    init_simple_test("BFu7c_F_BFu0ll");
    static STRUCT_IF_C BFu7c_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu7c_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_F_BFu0ll, BFu7c_F_BFu0ll)
//============================================================================


struct  BFu7c_F_BFu0s  {
  unsigned char v1:7;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_F_BFu0s) C1{ Fc:7 Fi Fs:0}



static void Test_BFu7c_F_BFu0s()
{
  {
    init_simple_test("BFu7c_F_BFu0s");
    static STRUCT_IF_C BFu7c_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu7c_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_F_BFu0s, BFu7c_F_BFu0s)
//============================================================================


struct  BFu7c_I_BFu0c  {
  unsigned char v1:7;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_I_BFu0c) C1{ Fc:7 Fi Fc:0}



static void Test_BFu7c_I_BFu0c()
{
  {
    init_simple_test("BFu7c_I_BFu0c");
    static STRUCT_IF_C BFu7c_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu7c_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_I_BFu0c, BFu7c_I_BFu0c)
//============================================================================


struct  BFu7c_I_BFu0i  {
  unsigned char v1:7;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_I_BFu0i) C1{ Fc:7 Fi Fi:0}



static void Test_BFu7c_I_BFu0i()
{
  {
    init_simple_test("BFu7c_I_BFu0i");
    static STRUCT_IF_C BFu7c_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu7c_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_I_BFu0i, BFu7c_I_BFu0i)
//============================================================================


struct  BFu7c_I_BFu0ll  {
  unsigned char v1:7;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_I_BFu0ll) C1{ Fc:7 Fi FL:0}



static void Test_BFu7c_I_BFu0ll()
{
  {
    init_simple_test("BFu7c_I_BFu0ll");
    static STRUCT_IF_C BFu7c_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu7c_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_I_BFu0ll, BFu7c_I_BFu0ll)
//============================================================================


struct  BFu7c_I_BFu0s  {
  unsigned char v1:7;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_I_BFu0s) C1{ Fc:7 Fi Fs:0}



static void Test_BFu7c_I_BFu0s()
{
  {
    init_simple_test("BFu7c_I_BFu0s");
    static STRUCT_IF_C BFu7c_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu7c_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_I_BFu0s, BFu7c_I_BFu0s)
//============================================================================


struct  BFu7c_Ip_BFu0c  {
  unsigned char v1:7;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_Ip_BFu0c) C1{ Fc:7 Fp Fc:0}



static void Test_BFu7c_Ip_BFu0c()
{
  {
    init_simple_test("BFu7c_Ip_BFu0c");
    static STRUCT_IF_C BFu7c_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ip_BFu0c, BFu7c_Ip_BFu0c)
//============================================================================


struct  BFu7c_Ip_BFu0i  {
  unsigned char v1:7;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_Ip_BFu0i) C1{ Fc:7 Fp Fi:0}



static void Test_BFu7c_Ip_BFu0i()
{
  {
    init_simple_test("BFu7c_Ip_BFu0i");
    static STRUCT_IF_C BFu7c_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ip_BFu0i, BFu7c_Ip_BFu0i)
//============================================================================


struct  BFu7c_Ip_BFu0ll  {
  unsigned char v1:7;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_Ip_BFu0ll) C1{ Fc:7 Fp FL:0}



static void Test_BFu7c_Ip_BFu0ll()
{
  {
    init_simple_test("BFu7c_Ip_BFu0ll");
    static STRUCT_IF_C BFu7c_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ip_BFu0ll, BFu7c_Ip_BFu0ll)
//============================================================================


struct  BFu7c_Ip_BFu0s  {
  unsigned char v1:7;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_Ip_BFu0s) C1{ Fc:7 Fp Fs:0}



static void Test_BFu7c_Ip_BFu0s()
{
  {
    init_simple_test("BFu7c_Ip_BFu0s");
    static STRUCT_IF_C BFu7c_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ip_BFu0s, BFu7c_Ip_BFu0s)
//============================================================================


struct  BFu7c_L_BFu0c  {
  unsigned char v1:7;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_L_BFu0c) C1{ Fc:7 FL Fc:0}



static void Test_BFu7c_L_BFu0c()
{
  {
    init_simple_test("BFu7c_L_BFu0c");
    static STRUCT_IF_C BFu7c_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_L_BFu0c, BFu7c_L_BFu0c)
//============================================================================


struct  BFu7c_L_BFu0i  {
  unsigned char v1:7;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_L_BFu0i) C1{ Fc:7 FL Fi:0}



static void Test_BFu7c_L_BFu0i()
{
  {
    init_simple_test("BFu7c_L_BFu0i");
    static STRUCT_IF_C BFu7c_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_L_BFu0i, BFu7c_L_BFu0i)
//============================================================================


struct  BFu7c_L_BFu0ll  {
  unsigned char v1:7;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_L_BFu0ll) C1{ Fc:7 FL FL:0}



static void Test_BFu7c_L_BFu0ll()
{
  {
    init_simple_test("BFu7c_L_BFu0ll");
    static STRUCT_IF_C BFu7c_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_L_BFu0ll, BFu7c_L_BFu0ll)
//============================================================================


struct  BFu7c_L_BFu0s  {
  unsigned char v1:7;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_L_BFu0s) C1{ Fc:7 FL Fs:0}



static void Test_BFu7c_L_BFu0s()
{
  {
    init_simple_test("BFu7c_L_BFu0s");
    static STRUCT_IF_C BFu7c_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_L_BFu0s, BFu7c_L_BFu0s)
//============================================================================


struct  BFu7c_S_BFu0c  {
  unsigned char v1:7;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_S_BFu0c) C1{ Fc:7 Fs Fc:0}



static void Test_BFu7c_S_BFu0c()
{
  {
    init_simple_test("BFu7c_S_BFu0c");
    static STRUCT_IF_C BFu7c_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu7c_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu0c, BFu7c_S_BFu0c)
//============================================================================


struct  BFu7c_S_BFu0i  {
  unsigned char v1:7;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_S_BFu0i) C1{ Fc:7 Fs Fi:0}



static void Test_BFu7c_S_BFu0i()
{
  {
    init_simple_test("BFu7c_S_BFu0i");
    static STRUCT_IF_C BFu7c_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu7c_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu0i, BFu7c_S_BFu0i)
//============================================================================


struct  BFu7c_S_BFu0ll  {
  unsigned char v1:7;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_S_BFu0ll) C1{ Fc:7 Fs FL:0}



static void Test_BFu7c_S_BFu0ll()
{
  {
    init_simple_test("BFu7c_S_BFu0ll");
    static STRUCT_IF_C BFu7c_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu7c_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu0ll, BFu7c_S_BFu0ll)
//============================================================================


struct  BFu7c_S_BFu0s  {
  unsigned char v1:7;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_S_BFu0s) C1{ Fc:7 Fs Fs:0}



static void Test_BFu7c_S_BFu0s()
{
  {
    init_simple_test("BFu7c_S_BFu0s");
    static STRUCT_IF_C BFu7c_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_S_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu7c_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_S_BFu0s, BFu7c_S_BFu0s)
//============================================================================


struct  BFu7c_Uc_BFu0c  {
  unsigned char v1:7;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_Uc_BFu0c) C1{ Fc:7 Fc Fc:0}



static void Test_BFu7c_Uc_BFu0c()
{
  {
    init_simple_test("BFu7c_Uc_BFu0c");
    static STRUCT_IF_C BFu7c_Uc_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu0c");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu0c, BFu7c_Uc_BFu0c)
//============================================================================


struct  BFu7c_Uc_BFu0i  {
  unsigned char v1:7;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_Uc_BFu0i) C1{ Fc:7 Fc Fi:0}



static void Test_BFu7c_Uc_BFu0i()
{
  {
    init_simple_test("BFu7c_Uc_BFu0i");
    static STRUCT_IF_C BFu7c_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu0i");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu0i, BFu7c_Uc_BFu0i)
//============================================================================


struct  BFu7c_Uc_BFu0ll  {
  unsigned char v1:7;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_Uc_BFu0ll) C1{ Fc:7 Fc FL:0}



static void Test_BFu7c_Uc_BFu0ll()
{
  {
    init_simple_test("BFu7c_Uc_BFu0ll");
    static STRUCT_IF_C BFu7c_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu0ll, BFu7c_Uc_BFu0ll)
//============================================================================


struct  BFu7c_Uc_BFu0s  {
  unsigned char v1:7;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_Uc_BFu0s) C1{ Fc:7 Fc Fs:0}



static void Test_BFu7c_Uc_BFu0s()
{
  {
    init_simple_test("BFu7c_Uc_BFu0s");
    static STRUCT_IF_C BFu7c_Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu7c_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_BFu0s");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Uc_BFu0s, BFu7c_Uc_BFu0s)
//============================================================================


struct  BFu7c_Ui_BFu0c  {
  unsigned char v1:7;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_Ui_BFu0c) C1{ Fc:7 Fi Fc:0}



static void Test_BFu7c_Ui_BFu0c()
{
  {
    init_simple_test("BFu7c_Ui_BFu0c");
    static STRUCT_IF_C BFu7c_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu7c_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu0c, BFu7c_Ui_BFu0c)
//============================================================================


struct  BFu7c_Ui_BFu0i  {
  unsigned char v1:7;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_Ui_BFu0i) C1{ Fc:7 Fi Fi:0}



static void Test_BFu7c_Ui_BFu0i()
{
  {
    init_simple_test("BFu7c_Ui_BFu0i");
    static STRUCT_IF_C BFu7c_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu7c_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu0i, BFu7c_Ui_BFu0i)
//============================================================================


struct  BFu7c_Ui_BFu0ll  {
  unsigned char v1:7;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_Ui_BFu0ll) C1{ Fc:7 Fi FL:0}



static void Test_BFu7c_Ui_BFu0ll()
{
  {
    init_simple_test("BFu7c_Ui_BFu0ll");
    static STRUCT_IF_C BFu7c_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7c_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu7c_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu0ll, BFu7c_Ui_BFu0ll)
//============================================================================


struct  BFu7c_Ui_BFu0s  {
  unsigned char v1:7;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_Ui_BFu0s) C1{ Fc:7 Fi Fs:0}



static void Test_BFu7c_Ui_BFu0s()
{
  {
    init_simple_test("BFu7c_Ui_BFu0s");
    static STRUCT_IF_C BFu7c_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu7c_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ui_BFu0s, BFu7c_Ui_BFu0s)
//============================================================================


struct  BFu7c_Ul_BFu0c  {
  unsigned char v1:7;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_Ul_BFu0c) C1{ Fc:7 FL Fc:0}



static void Test_BFu7c_Ul_BFu0c()
{
  {
    init_simple_test("BFu7c_Ul_BFu0c");
    static STRUCT_IF_C BFu7c_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu0c, BFu7c_Ul_BFu0c)
//============================================================================


struct  BFu7c_Ul_BFu0i  {
  unsigned char v1:7;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_Ul_BFu0i) C1{ Fc:7 FL Fi:0}



static void Test_BFu7c_Ul_BFu0i()
{
  {
    init_simple_test("BFu7c_Ul_BFu0i");
    static STRUCT_IF_C BFu7c_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu0i, BFu7c_Ul_BFu0i)
//============================================================================


struct  BFu7c_Ul_BFu0ll  {
  unsigned char v1:7;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_Ul_BFu0ll) C1{ Fc:7 FL FL:0}



static void Test_BFu7c_Ul_BFu0ll()
{
  {
    init_simple_test("BFu7c_Ul_BFu0ll");
    static STRUCT_IF_C BFu7c_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu0ll, BFu7c_Ul_BFu0ll)
//============================================================================


struct  BFu7c_Ul_BFu0s  {
  unsigned char v1:7;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_Ul_BFu0s) C1{ Fc:7 FL Fs:0}



static void Test_BFu7c_Ul_BFu0s()
{
  {
    init_simple_test("BFu7c_Ul_BFu0s");
    static STRUCT_IF_C BFu7c_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Ul_BFu0s, BFu7c_Ul_BFu0s)
//============================================================================


struct  BFu7c_Us_BFu0c  {
  unsigned char v1:7;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_Us_BFu0c) C1{ Fc:7 Fs Fc:0}



static void Test_BFu7c_Us_BFu0c()
{
  {
    init_simple_test("BFu7c_Us_BFu0c");
    static STRUCT_IF_C BFu7c_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu7c_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu0c, BFu7c_Us_BFu0c)
//============================================================================


struct  BFu7c_Us_BFu0i  {
  unsigned char v1:7;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_Us_BFu0i) C1{ Fc:7 Fs Fi:0}



static void Test_BFu7c_Us_BFu0i()
{
  {
    init_simple_test("BFu7c_Us_BFu0i");
    static STRUCT_IF_C BFu7c_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu7c_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu0i, BFu7c_Us_BFu0i)
//============================================================================


struct  BFu7c_Us_BFu0ll  {
  unsigned char v1:7;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_Us_BFu0ll) C1{ Fc:7 Fs FL:0}



static void Test_BFu7c_Us_BFu0ll()
{
  {
    init_simple_test("BFu7c_Us_BFu0ll");
    static STRUCT_IF_C BFu7c_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu7c_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu7c_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu0ll, BFu7c_Us_BFu0ll)
//============================================================================


struct  BFu7c_Us_BFu0s  {
  unsigned char v1:7;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_Us_BFu0s) C1{ Fc:7 Fs Fs:0}



static void Test_BFu7c_Us_BFu0s()
{
  {
    init_simple_test("BFu7c_Us_BFu0s");
    static STRUCT_IF_C BFu7c_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_Us_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu7c_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Us_BFu0s, BFu7c_Us_BFu0s)
//============================================================================


struct  BFu7c_Vp_BFu0c  {
  unsigned char v1:7;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu7c_Vp_BFu0c) C1{ Fc:7 Fp Fc:0}



static void Test_BFu7c_Vp_BFu0c()
{
  {
    init_simple_test("BFu7c_Vp_BFu0c");
    static STRUCT_IF_C BFu7c_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu0c, BFu7c_Vp_BFu0c)
//============================================================================


struct  BFu7c_Vp_BFu0i  {
  unsigned char v1:7;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu7c_Vp_BFu0i) C1{ Fc:7 Fp Fi:0}



static void Test_BFu7c_Vp_BFu0i()
{
  {
    init_simple_test("BFu7c_Vp_BFu0i");
    static STRUCT_IF_C BFu7c_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu0i, BFu7c_Vp_BFu0i)
//============================================================================


struct  BFu7c_Vp_BFu0ll  {
  unsigned char v1:7;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu7c_Vp_BFu0ll) C1{ Fc:7 Fp FL:0}



static void Test_BFu7c_Vp_BFu0ll()
{
  {
    init_simple_test("BFu7c_Vp_BFu0ll");
    static STRUCT_IF_C BFu7c_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu0ll, BFu7c_Vp_BFu0ll)
//============================================================================


struct  BFu7c_Vp_BFu0s  {
  unsigned char v1:7;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu7c_Vp_BFu0s) C1{ Fc:7 Fp Fs:0}



static void Test_BFu7c_Vp_BFu0s()
{
  {
    init_simple_test("BFu7c_Vp_BFu0s");
    static STRUCT_IF_C BFu7c_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7c_Vp_BFu0s, BFu7c_Vp_BFu0s)
//============================================================================


struct  BFu7i_BFu0c  {
  unsigned int v1:7;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu0c) C1{ Fi:7 Fc:0}



static void Test_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c, BFu7i_BFu0c)
//============================================================================


struct  BFu7i_BFu0c_BFu0c  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu0c_BFu0c) C1{ Fi:7 Fc:0 Fc:0}



static void Test_BFu7i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu0c");
    static STRUCT_IF_C BFu7i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu0c, BFu7i_BFu0c_BFu0c)
//============================================================================


struct  BFu7i_BFu0c_BFu0i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu0c_BFu0i) C1{ Fi:7 Fc:0 Fi:0}



static void Test_BFu7i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu0i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu0i, BFu7i_BFu0c_BFu0i)
//============================================================================


struct  BFu7i_BFu0c_BFu0ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu0c_BFu0ll) C1{ Fi:7 Fc:0 FL:0}



static void Test_BFu7i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu0ll, BFu7i_BFu0c_BFu0ll)
//============================================================================


struct  BFu7i_BFu0c_BFu0s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu0c_BFu0s) C1{ Fi:7 Fc:0 Fs:0}



static void Test_BFu7i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu0s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu0s, BFu7i_BFu0c_BFu0s)
//============================================================================


struct  BFu7i_BFu0c_BFu15i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7i_BFu0c_BFu15i) C1{ Fi:7 Fc:0 Fi:15}



static void Test_BFu7i_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu15i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu7i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu15i, BFu7i_BFu0c_BFu15i)
//============================================================================


struct  BFu7i_BFu0c_BFu15ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7i_BFu0c_BFu15ll) C1{ Fi:7 Fc:0 FL:15}



static void Test_BFu7i_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu7i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu15ll, BFu7i_BFu0c_BFu15ll)
//============================================================================


struct  BFu7i_BFu0c_BFu15s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7i_BFu0c_BFu15s) C1{ Fi:7 Fc:0 Fs:15}



static void Test_BFu7i_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu15s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu15s, BFu7i_BFu0c_BFu15s)
//============================================================================


struct  BFu7i_BFu0c_BFu16i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7i_BFu0c_BFu16i) C1{ Fi:7 Fc:0 Fi:16}



static void Test_BFu7i_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu16i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu7i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu16i, BFu7i_BFu0c_BFu16i)
//============================================================================


struct  BFu7i_BFu0c_BFu16ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7i_BFu0c_BFu16ll) C1{ Fi:7 Fc:0 FL:16}



static void Test_BFu7i_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu7i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu16ll, BFu7i_BFu0c_BFu16ll)
//============================================================================


struct  BFu7i_BFu0c_BFu16s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7i_BFu0c_BFu16s) C1{ Fi:7 Fc:0 Fs:16}



static void Test_BFu7i_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu16s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu16s, BFu7i_BFu0c_BFu16s)
//============================================================================


struct  BFu7i_BFu0c_BFu17i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7i_BFu0c_BFu17i) C1{ Fi:7 Fc:0 Fi:17}



static void Test_BFu7i_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu17i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu7i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu17i, BFu7i_BFu0c_BFu17i)
//============================================================================


struct  BFu7i_BFu0c_BFu17ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7i_BFu0c_BFu17ll) C1{ Fi:7 Fc:0 FL:17}



static void Test_BFu7i_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu7i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu17ll, BFu7i_BFu0c_BFu17ll)
//============================================================================


struct  BFu7i_BFu0c_BFu1c  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7i_BFu0c_BFu1c) C1{ Fi:7 Fc:0 Fc:1}



static void Test_BFu7i_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu1c");
    static STRUCT_IF_C BFu7i_BFu0c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7i_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu1c, BFu7i_BFu0c_BFu1c)
//============================================================================


struct  BFu7i_BFu0c_BFu1i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7i_BFu0c_BFu1i) C1{ Fi:7 Fc:0 Fi:1}



static void Test_BFu7i_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu1i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7i_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu1i, BFu7i_BFu0c_BFu1i)
//============================================================================


struct  BFu7i_BFu0c_BFu1ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7i_BFu0c_BFu1ll) C1{ Fi:7 Fc:0 FL:1}



static void Test_BFu7i_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7i_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu1ll, BFu7i_BFu0c_BFu1ll)
//============================================================================


struct  BFu7i_BFu0c_BFu1s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7i_BFu0c_BFu1s) C1{ Fi:7 Fc:0 Fs:1}



static void Test_BFu7i_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu1s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7i_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu1s, BFu7i_BFu0c_BFu1s)
//============================================================================


struct  BFu7i_BFu0c_BFu31i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7i_BFu0c_BFu31i) C1{ Fi:7 Fc:0 Fi:31}



static void Test_BFu7i_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu31i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu31i, BFu7i_BFu0c_BFu31i)
//============================================================================


struct  BFu7i_BFu0c_BFu31ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7i_BFu0c_BFu31ll) C1{ Fi:7 Fc:0 FL:31}



static void Test_BFu7i_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu7i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu31ll, BFu7i_BFu0c_BFu31ll)
//============================================================================


struct  BFu7i_BFu0c_BFu32i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7i_BFu0c_BFu32i) C1{ Fi:7 Fc:0 Fi:32}



static void Test_BFu7i_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu32i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu32i, BFu7i_BFu0c_BFu32i)
//============================================================================


struct  BFu7i_BFu0c_BFu32ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7i_BFu0c_BFu32ll) C1{ Fi:7 Fc:0 FL:32}



static void Test_BFu7i_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu7i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu32ll, BFu7i_BFu0c_BFu32ll)
//============================================================================


struct  BFu7i_BFu0c_BFu33  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7i_BFu0c_BFu33) C1{ Fi:7 Fc:0 FL:33}



static void Test_BFu7i_BFu0c_BFu33()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu33");
    static STRUCT_IF_C BFu7i_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu7i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu7i_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu33, BFu7i_BFu0c_BFu33)
//============================================================================


struct  BFu7i_BFu0c_BFu7c  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7i_BFu0c_BFu7c) C1{ Fi:7 Fc:0 Fc:7}



static void Test_BFu7i_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu7c");
    static STRUCT_IF_C BFu7i_BFu0c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu7c, BFu7i_BFu0c_BFu7c)
//============================================================================


struct  BFu7i_BFu0c_BFu7i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7i_BFu0c_BFu7i) C1{ Fi:7 Fc:0 Fi:7}



static void Test_BFu7i_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu7i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu7i, BFu7i_BFu0c_BFu7i)
//============================================================================


struct  BFu7i_BFu0c_BFu7ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7i_BFu0c_BFu7ll) C1{ Fi:7 Fc:0 FL:7}



static void Test_BFu7i_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu7ll, BFu7i_BFu0c_BFu7ll)
//============================================================================


struct  BFu7i_BFu0c_BFu7s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7i_BFu0c_BFu7s) C1{ Fi:7 Fc:0 Fs:7}



static void Test_BFu7i_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu7s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu7s, BFu7i_BFu0c_BFu7s)
//============================================================================


struct  BFu7i_BFu0c_BFu8c  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7i_BFu0c_BFu8c) C1{ Fi:7 Fc:0 Fc:8}



static void Test_BFu7i_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu8c");
    static STRUCT_IF_C BFu7i_BFu0c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu8c, BFu7i_BFu0c_BFu8c)
//============================================================================


struct  BFu7i_BFu0c_BFu8i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7i_BFu0c_BFu8i) C1{ Fi:7 Fc:0 Fi:8}



static void Test_BFu7i_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu8i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu8i, BFu7i_BFu0c_BFu8i)
//============================================================================


struct  BFu7i_BFu0c_BFu8ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7i_BFu0c_BFu8ll) C1{ Fi:7 Fc:0 FL:8}



static void Test_BFu7i_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu8ll, BFu7i_BFu0c_BFu8ll)
//============================================================================


struct  BFu7i_BFu0c_BFu8s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7i_BFu0c_BFu8s) C1{ Fi:7 Fc:0 Fs:8}



static void Test_BFu7i_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu8s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu8s, BFu7i_BFu0c_BFu8s)
//============================================================================


struct  BFu7i_BFu0c_BFu9i  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7i_BFu0c_BFu9i) C1{ Fi:7 Fc:0 Fi:9}



static void Test_BFu7i_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu9i");
    static STRUCT_IF_C BFu7i_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu7i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu9i, BFu7i_BFu0c_BFu9i)
//============================================================================


struct  BFu7i_BFu0c_BFu9ll  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7i_BFu0c_BFu9ll) C1{ Fi:7 Fc:0 FL:9}



static void Test_BFu7i_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu7i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu9ll, BFu7i_BFu0c_BFu9ll)
//============================================================================


struct  BFu7i_BFu0c_BFu9s  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7i_BFu0c_BFu9s) C1{ Fi:7 Fc:0 Fs:9}



static void Test_BFu7i_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu0c_BFu9s");
    static STRUCT_IF_C BFu7i_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_BFu9s, BFu7i_BFu0c_BFu9s)
//============================================================================


struct  BFu7i_BFu0c_C  {
  unsigned int v1:7;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu7i_BFu0c_C) C1{ Fi:7 Fc:0 Fc}



static void Test_BFu7i_BFu0c_C()
{
  {
    init_simple_test("BFu7i_BFu0c_C");
    static STRUCT_IF_C BFu7i_BFu0c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu7i_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_C, BFu7i_BFu0c_C)
//============================================================================


struct  BFu7i_BFu0c_D  {
  unsigned int v1:7;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu7i_BFu0c_D) C1{ Fi:7 Fc:0 FL}



static void Test_BFu7i_BFu0c_D()
{
  {
    init_simple_test("BFu7i_BFu0c_D");
    static STRUCT_IF_C BFu7i_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_D, BFu7i_BFu0c_D)
//============================================================================


struct  BFu7i_BFu0c_F  {
  unsigned int v1:7;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu7i_BFu0c_F) C1{ Fi:7 Fc:0 Fi}



static void Test_BFu7i_BFu0c_F()
{
  {
    init_simple_test("BFu7i_BFu0c_F");
    static STRUCT_IF_C BFu7i_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_F, BFu7i_BFu0c_F)
//============================================================================


struct  BFu7i_BFu0c_I  {
  unsigned int v1:7;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu7i_BFu0c_I) C1{ Fi:7 Fc:0 Fi}



static void Test_BFu7i_BFu0c_I()
{
  {
    init_simple_test("BFu7i_BFu0c_I");
    static STRUCT_IF_C BFu7i_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_I, BFu7i_BFu0c_I)
//============================================================================


struct  BFu7i_BFu0c_Ip  {
  unsigned int v1:7;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu7i_BFu0c_Ip) C1{ Fi:7 Fc:0 Fp}



static void Test_BFu7i_BFu0c_Ip()
{
  {
    init_simple_test("BFu7i_BFu0c_Ip");
    static STRUCT_IF_C BFu7i_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_Ip, BFu7i_BFu0c_Ip)
//============================================================================


struct  BFu7i_BFu0c_L  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu7i_BFu0c_L) C1{ Fi:7 Fc:0 FL}



static void Test_BFu7i_BFu0c_L()
{
  {
    init_simple_test("BFu7i_BFu0c_L");
    static STRUCT_IF_C BFu7i_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_L, BFu7i_BFu0c_L)
//============================================================================


struct  BFu7i_BFu0c_S  {
  unsigned int v1:7;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu7i_BFu0c_S) C1{ Fi:7 Fc:0 Fs}



static void Test_BFu7i_BFu0c_S()
{
  {
    init_simple_test("BFu7i_BFu0c_S");
    static STRUCT_IF_C BFu7i_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu7i_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_S, BFu7i_BFu0c_S)
//============================================================================


struct  BFu7i_BFu0c_Uc  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu7i_BFu0c_Uc) C1{ Fi:7 Fc:0 Fc}



static void Test_BFu7i_BFu0c_Uc()
{
  {
    init_simple_test("BFu7i_BFu0c_Uc");
    static STRUCT_IF_C BFu7i_BFu0c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu7i_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_Uc, BFu7i_BFu0c_Uc)
//============================================================================


struct  BFu7i_BFu0c_Ui  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu7i_BFu0c_Ui) C1{ Fi:7 Fc:0 Fi}



static void Test_BFu7i_BFu0c_Ui()
{
  {
    init_simple_test("BFu7i_BFu0c_Ui");
    static STRUCT_IF_C BFu7i_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_Ui, BFu7i_BFu0c_Ui)
//============================================================================


struct  BFu7i_BFu0c_Ul  {
  unsigned int v1:7;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu7i_BFu0c_Ul) C1{ Fi:7 Fc:0 FL}



static void Test_BFu7i_BFu0c_Ul()
{
  {
    init_simple_test("BFu7i_BFu0c_Ul");
    static STRUCT_IF_C BFu7i_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_Ul, BFu7i_BFu0c_Ul)
//============================================================================


struct  BFu7i_BFu0c_Us  {
  unsigned int v1:7;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu7i_BFu0c_Us) C1{ Fi:7 Fc:0 Fs}



static void Test_BFu7i_BFu0c_Us()
{
  {
    init_simple_test("BFu7i_BFu0c_Us");
    static STRUCT_IF_C BFu7i_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu7i_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_Us, BFu7i_BFu0c_Us)
//============================================================================


struct  BFu7i_BFu0c_Vp  {
  unsigned int v1:7;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu7i_BFu0c_Vp) C1{ Fi:7 Fc:0 Fp}



static void Test_BFu7i_BFu0c_Vp()
{
  {
    init_simple_test("BFu7i_BFu0c_Vp");
    static STRUCT_IF_C BFu7i_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0c_Vp, BFu7i_BFu0c_Vp)
//============================================================================


struct  BFu7i_BFu0i  {
  unsigned int v1:7;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu0i) C1{ Fi:7 Fi:0}



static void Test_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i, BFu7i_BFu0i)
//============================================================================


struct  BFu7i_BFu0i_BFu0c  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu0i_BFu0c) C1{ Fi:7 Fi:0 Fc:0}



static void Test_BFu7i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu0c, BFu7i_BFu0i_BFu0c)
//============================================================================


struct  BFu7i_BFu0i_BFu0i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu0i_BFu0i) C1{ Fi:7 Fi:0 Fi:0}



static void Test_BFu7i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu0i, BFu7i_BFu0i_BFu0i)
//============================================================================


struct  BFu7i_BFu0i_BFu0ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu0i_BFu0ll) C1{ Fi:7 Fi:0 FL:0}



static void Test_BFu7i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu0ll, BFu7i_BFu0i_BFu0ll)
//============================================================================


struct  BFu7i_BFu0i_BFu0s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu0i_BFu0s) C1{ Fi:7 Fi:0 Fs:0}



static void Test_BFu7i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu0s, BFu7i_BFu0i_BFu0s)
//============================================================================


struct  BFu7i_BFu0i_BFu15i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7i_BFu0i_BFu15i) C1{ Fi:7 Fi:0 Fi:15}



static void Test_BFu7i_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu15i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu15i, BFu7i_BFu0i_BFu15i)
//============================================================================


struct  BFu7i_BFu0i_BFu15ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7i_BFu0i_BFu15ll) C1{ Fi:7 Fi:0 FL:15}



static void Test_BFu7i_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu15ll, BFu7i_BFu0i_BFu15ll)
//============================================================================


struct  BFu7i_BFu0i_BFu15s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7i_BFu0i_BFu15s) C1{ Fi:7 Fi:0 Fs:15}



static void Test_BFu7i_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu15s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu15s, BFu7i_BFu0i_BFu15s)
//============================================================================


struct  BFu7i_BFu0i_BFu16i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7i_BFu0i_BFu16i) C1{ Fi:7 Fi:0 Fi:16}



static void Test_BFu7i_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu16i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu16i, BFu7i_BFu0i_BFu16i)
//============================================================================


struct  BFu7i_BFu0i_BFu16ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7i_BFu0i_BFu16ll) C1{ Fi:7 Fi:0 FL:16}



static void Test_BFu7i_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu16ll, BFu7i_BFu0i_BFu16ll)
//============================================================================


struct  BFu7i_BFu0i_BFu16s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7i_BFu0i_BFu16s) C1{ Fi:7 Fi:0 Fs:16}



static void Test_BFu7i_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu16s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu16s, BFu7i_BFu0i_BFu16s)
//============================================================================


struct  BFu7i_BFu0i_BFu17i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7i_BFu0i_BFu17i) C1{ Fi:7 Fi:0 Fi:17}



static void Test_BFu7i_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu17i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu17i, BFu7i_BFu0i_BFu17i)
//============================================================================


struct  BFu7i_BFu0i_BFu17ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7i_BFu0i_BFu17ll) C1{ Fi:7 Fi:0 FL:17}



static void Test_BFu7i_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu17ll, BFu7i_BFu0i_BFu17ll)
//============================================================================


struct  BFu7i_BFu0i_BFu1c  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7i_BFu0i_BFu1c) C1{ Fi:7 Fi:0 Fc:1}



static void Test_BFu7i_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu1c");
    static STRUCT_IF_C BFu7i_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7i_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu1c, BFu7i_BFu0i_BFu1c)
//============================================================================


struct  BFu7i_BFu0i_BFu1i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7i_BFu0i_BFu1i) C1{ Fi:7 Fi:0 Fi:1}



static void Test_BFu7i_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu1i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7i_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu1i, BFu7i_BFu0i_BFu1i)
//============================================================================


struct  BFu7i_BFu0i_BFu1ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7i_BFu0i_BFu1ll) C1{ Fi:7 Fi:0 FL:1}



static void Test_BFu7i_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7i_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu1ll, BFu7i_BFu0i_BFu1ll)
//============================================================================


struct  BFu7i_BFu0i_BFu1s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7i_BFu0i_BFu1s) C1{ Fi:7 Fi:0 Fs:1}



static void Test_BFu7i_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu1s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7i_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu1s, BFu7i_BFu0i_BFu1s)
//============================================================================


struct  BFu7i_BFu0i_BFu31i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7i_BFu0i_BFu31i) C1{ Fi:7 Fi:0 Fi:31}



static void Test_BFu7i_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu31i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu31i, BFu7i_BFu0i_BFu31i)
//============================================================================


struct  BFu7i_BFu0i_BFu31ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7i_BFu0i_BFu31ll) C1{ Fi:7 Fi:0 FL:31}



static void Test_BFu7i_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu31ll, BFu7i_BFu0i_BFu31ll)
//============================================================================


struct  BFu7i_BFu0i_BFu32i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7i_BFu0i_BFu32i) C1{ Fi:7 Fi:0 Fi:32}



static void Test_BFu7i_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu32i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu32i, BFu7i_BFu0i_BFu32i)
//============================================================================


struct  BFu7i_BFu0i_BFu32ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7i_BFu0i_BFu32ll) C1{ Fi:7 Fi:0 FL:32}



static void Test_BFu7i_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu32ll, BFu7i_BFu0i_BFu32ll)
//============================================================================


struct  BFu7i_BFu0i_BFu33  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7i_BFu0i_BFu33) C1{ Fi:7 Fi:0 FL:33}



static void Test_BFu7i_BFu0i_BFu33()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu33");
    static STRUCT_IF_C BFu7i_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu7i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu7i_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu33, BFu7i_BFu0i_BFu33)
//============================================================================


struct  BFu7i_BFu0i_BFu7c  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7i_BFu0i_BFu7c) C1{ Fi:7 Fi:0 Fc:7}



static void Test_BFu7i_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu7c");
    static STRUCT_IF_C BFu7i_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu7c, BFu7i_BFu0i_BFu7c)
//============================================================================


struct  BFu7i_BFu0i_BFu7i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7i_BFu0i_BFu7i) C1{ Fi:7 Fi:0 Fi:7}



static void Test_BFu7i_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu7i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu7i, BFu7i_BFu0i_BFu7i)
//============================================================================


struct  BFu7i_BFu0i_BFu7ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7i_BFu0i_BFu7ll) C1{ Fi:7 Fi:0 FL:7}



static void Test_BFu7i_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu7ll, BFu7i_BFu0i_BFu7ll)
//============================================================================


struct  BFu7i_BFu0i_BFu7s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7i_BFu0i_BFu7s) C1{ Fi:7 Fi:0 Fs:7}



static void Test_BFu7i_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu7s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu7s, BFu7i_BFu0i_BFu7s)
//============================================================================


struct  BFu7i_BFu0i_BFu8c  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7i_BFu0i_BFu8c) C1{ Fi:7 Fi:0 Fc:8}



static void Test_BFu7i_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu8c");
    static STRUCT_IF_C BFu7i_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu8c, BFu7i_BFu0i_BFu8c)
//============================================================================


struct  BFu7i_BFu0i_BFu8i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7i_BFu0i_BFu8i) C1{ Fi:7 Fi:0 Fi:8}



static void Test_BFu7i_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu8i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu8i, BFu7i_BFu0i_BFu8i)
//============================================================================


struct  BFu7i_BFu0i_BFu8ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7i_BFu0i_BFu8ll) C1{ Fi:7 Fi:0 FL:8}



static void Test_BFu7i_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu8ll, BFu7i_BFu0i_BFu8ll)
//============================================================================


struct  BFu7i_BFu0i_BFu8s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7i_BFu0i_BFu8s) C1{ Fi:7 Fi:0 Fs:8}



static void Test_BFu7i_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu8s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu8s, BFu7i_BFu0i_BFu8s)
//============================================================================


struct  BFu7i_BFu0i_BFu9i  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7i_BFu0i_BFu9i) C1{ Fi:7 Fi:0 Fi:9}



static void Test_BFu7i_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu9i");
    static STRUCT_IF_C BFu7i_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu9i, BFu7i_BFu0i_BFu9i)
//============================================================================


struct  BFu7i_BFu0i_BFu9ll  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7i_BFu0i_BFu9ll) C1{ Fi:7 Fi:0 FL:9}



static void Test_BFu7i_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu9ll, BFu7i_BFu0i_BFu9ll)
//============================================================================


struct  BFu7i_BFu0i_BFu9s  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7i_BFu0i_BFu9s) C1{ Fi:7 Fi:0 Fs:9}



static void Test_BFu7i_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu0i_BFu9s");
    static STRUCT_IF_C BFu7i_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_BFu9s, BFu7i_BFu0i_BFu9s)
//============================================================================


struct  BFu7i_BFu0i_C  {
  unsigned int v1:7;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu7i_BFu0i_C) C1{ Fi:7 Fi:0 Fc}



static void Test_BFu7i_BFu0i_C()
{
  {
    init_simple_test("BFu7i_BFu0i_C");
    static STRUCT_IF_C BFu7i_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_C, BFu7i_BFu0i_C)
//============================================================================


struct  BFu7i_BFu0i_D  {
  unsigned int v1:7;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu7i_BFu0i_D) C1{ Fi:7 Fi:0 FL}



static void Test_BFu7i_BFu0i_D()
{
  {
    init_simple_test("BFu7i_BFu0i_D");
    static STRUCT_IF_C BFu7i_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_D, BFu7i_BFu0i_D)
//============================================================================


struct  BFu7i_BFu0i_F  {
  unsigned int v1:7;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu7i_BFu0i_F) C1{ Fi:7 Fi:0 Fi}



static void Test_BFu7i_BFu0i_F()
{
  {
    init_simple_test("BFu7i_BFu0i_F");
    static STRUCT_IF_C BFu7i_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_F, BFu7i_BFu0i_F)
//============================================================================


struct  BFu7i_BFu0i_I  {
  unsigned int v1:7;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu7i_BFu0i_I) C1{ Fi:7 Fi:0 Fi}



static void Test_BFu7i_BFu0i_I()
{
  {
    init_simple_test("BFu7i_BFu0i_I");
    static STRUCT_IF_C BFu7i_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_I, BFu7i_BFu0i_I)
//============================================================================


struct  BFu7i_BFu0i_Ip  {
  unsigned int v1:7;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu7i_BFu0i_Ip) C1{ Fi:7 Fi:0 Fp}



static void Test_BFu7i_BFu0i_Ip()
{
  {
    init_simple_test("BFu7i_BFu0i_Ip");
    static STRUCT_IF_C BFu7i_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_Ip, BFu7i_BFu0i_Ip)
//============================================================================


struct  BFu7i_BFu0i_L  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu7i_BFu0i_L) C1{ Fi:7 Fi:0 FL}



static void Test_BFu7i_BFu0i_L()
{
  {
    init_simple_test("BFu7i_BFu0i_L");
    static STRUCT_IF_C BFu7i_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_L, BFu7i_BFu0i_L)
//============================================================================


struct  BFu7i_BFu0i_S  {
  unsigned int v1:7;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu7i_BFu0i_S) C1{ Fi:7 Fi:0 Fs}



static void Test_BFu7i_BFu0i_S()
{
  {
    init_simple_test("BFu7i_BFu0i_S");
    static STRUCT_IF_C BFu7i_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_S, BFu7i_BFu0i_S)
//============================================================================


struct  BFu7i_BFu0i_Uc  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu7i_BFu0i_Uc) C1{ Fi:7 Fi:0 Fc}



static void Test_BFu7i_BFu0i_Uc()
{
  {
    init_simple_test("BFu7i_BFu0i_Uc");
    static STRUCT_IF_C BFu7i_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_Uc, BFu7i_BFu0i_Uc)
//============================================================================


struct  BFu7i_BFu0i_Ui  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu7i_BFu0i_Ui) C1{ Fi:7 Fi:0 Fi}



static void Test_BFu7i_BFu0i_Ui()
{
  {
    init_simple_test("BFu7i_BFu0i_Ui");
    static STRUCT_IF_C BFu7i_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_Ui, BFu7i_BFu0i_Ui)
//============================================================================


struct  BFu7i_BFu0i_Ul  {
  unsigned int v1:7;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu7i_BFu0i_Ul) C1{ Fi:7 Fi:0 FL}



static void Test_BFu7i_BFu0i_Ul()
{
  {
    init_simple_test("BFu7i_BFu0i_Ul");
    static STRUCT_IF_C BFu7i_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_Ul, BFu7i_BFu0i_Ul)
//============================================================================


struct  BFu7i_BFu0i_Us  {
  unsigned int v1:7;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu7i_BFu0i_Us) C1{ Fi:7 Fi:0 Fs}



static void Test_BFu7i_BFu0i_Us()
{
  {
    init_simple_test("BFu7i_BFu0i_Us");
    static STRUCT_IF_C BFu7i_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_Us, BFu7i_BFu0i_Us)
//============================================================================


struct  BFu7i_BFu0i_Vp  {
  unsigned int v1:7;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu7i_BFu0i_Vp) C1{ Fi:7 Fi:0 Fp}



static void Test_BFu7i_BFu0i_Vp()
{
  {
    init_simple_test("BFu7i_BFu0i_Vp");
    static STRUCT_IF_C BFu7i_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0i_Vp, BFu7i_BFu0i_Vp)
//============================================================================


struct  BFu7i_BFu0ll  {
  unsigned int v1:7;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu0ll) C1{ Fi:7 FL:0}



static void Test_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll, BFu7i_BFu0ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu0c  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu0ll_BFu0c) C1{ Fi:7 FL:0 Fc:0}



static void Test_BFu7i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu0c, BFu7i_BFu0ll_BFu0c)
//============================================================================


struct  BFu7i_BFu0ll_BFu0i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu0ll_BFu0i) C1{ Fi:7 FL:0 Fi:0}



static void Test_BFu7i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu0i, BFu7i_BFu0ll_BFu0i)
//============================================================================


struct  BFu7i_BFu0ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu0ll_BFu0ll) C1{ Fi:7 FL:0 FL:0}



static void Test_BFu7i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu0ll, BFu7i_BFu0ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu0s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu0ll_BFu0s) C1{ Fi:7 FL:0 Fs:0}



static void Test_BFu7i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu0s, BFu7i_BFu0ll_BFu0s)
//============================================================================


struct  BFu7i_BFu0ll_BFu15i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7i_BFu0ll_BFu15i) C1{ Fi:7 FL:0 Fi:15}



static void Test_BFu7i_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu15i, BFu7i_BFu0ll_BFu15i)
//============================================================================


struct  BFu7i_BFu0ll_BFu15ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7i_BFu0ll_BFu15ll) C1{ Fi:7 FL:0 FL:15}



static void Test_BFu7i_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu15ll, BFu7i_BFu0ll_BFu15ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu15s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7i_BFu0ll_BFu15s) C1{ Fi:7 FL:0 Fs:15}



static void Test_BFu7i_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu15s, BFu7i_BFu0ll_BFu15s)
//============================================================================


struct  BFu7i_BFu0ll_BFu16i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7i_BFu0ll_BFu16i) C1{ Fi:7 FL:0 Fi:16}



static void Test_BFu7i_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu16i, BFu7i_BFu0ll_BFu16i)
//============================================================================


struct  BFu7i_BFu0ll_BFu16ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7i_BFu0ll_BFu16ll) C1{ Fi:7 FL:0 FL:16}



static void Test_BFu7i_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu16ll, BFu7i_BFu0ll_BFu16ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu16s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7i_BFu0ll_BFu16s) C1{ Fi:7 FL:0 Fs:16}



static void Test_BFu7i_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu16s, BFu7i_BFu0ll_BFu16s)
//============================================================================


struct  BFu7i_BFu0ll_BFu17i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7i_BFu0ll_BFu17i) C1{ Fi:7 FL:0 Fi:17}



static void Test_BFu7i_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu7i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu17i, BFu7i_BFu0ll_BFu17i)
//============================================================================


struct  BFu7i_BFu0ll_BFu17ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7i_BFu0ll_BFu17ll) C1{ Fi:7 FL:0 FL:17}



static void Test_BFu7i_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu7i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu17ll, BFu7i_BFu0ll_BFu17ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu1c  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7i_BFu0ll_BFu1c) C1{ Fi:7 FL:0 Fc:1}



static void Test_BFu7i_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7i_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu1c, BFu7i_BFu0ll_BFu1c)
//============================================================================


struct  BFu7i_BFu0ll_BFu1i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7i_BFu0ll_BFu1i) C1{ Fi:7 FL:0 Fi:1}



static void Test_BFu7i_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7i_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu1i, BFu7i_BFu0ll_BFu1i)
//============================================================================


struct  BFu7i_BFu0ll_BFu1ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7i_BFu0ll_BFu1ll) C1{ Fi:7 FL:0 FL:1}



static void Test_BFu7i_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7i_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu1ll, BFu7i_BFu0ll_BFu1ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu1s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7i_BFu0ll_BFu1s) C1{ Fi:7 FL:0 Fs:1}



static void Test_BFu7i_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7i_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu1s, BFu7i_BFu0ll_BFu1s)
//============================================================================


struct  BFu7i_BFu0ll_BFu31i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7i_BFu0ll_BFu31i) C1{ Fi:7 FL:0 Fi:31}



static void Test_BFu7i_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu7i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu31i, BFu7i_BFu0ll_BFu31i)
//============================================================================


struct  BFu7i_BFu0ll_BFu31ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7i_BFu0ll_BFu31ll) C1{ Fi:7 FL:0 FL:31}



static void Test_BFu7i_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu7i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu31ll, BFu7i_BFu0ll_BFu31ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu32i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7i_BFu0ll_BFu32i) C1{ Fi:7 FL:0 Fi:32}



static void Test_BFu7i_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu7i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu32i, BFu7i_BFu0ll_BFu32i)
//============================================================================


struct  BFu7i_BFu0ll_BFu32ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7i_BFu0ll_BFu32ll) C1{ Fi:7 FL:0 FL:32}



static void Test_BFu7i_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu7i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu32ll, BFu7i_BFu0ll_BFu32ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu33  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7i_BFu0ll_BFu33) C1{ Fi:7 FL:0 FL:33}



static void Test_BFu7i_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu33");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu7i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu7i_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu33, BFu7i_BFu0ll_BFu33)
//============================================================================


struct  BFu7i_BFu0ll_BFu7c  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7i_BFu0ll_BFu7c) C1{ Fi:7 FL:0 Fc:7}



static void Test_BFu7i_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu7c, BFu7i_BFu0ll_BFu7c)
//============================================================================


struct  BFu7i_BFu0ll_BFu7i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7i_BFu0ll_BFu7i) C1{ Fi:7 FL:0 Fi:7}



static void Test_BFu7i_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu7i, BFu7i_BFu0ll_BFu7i)
//============================================================================


struct  BFu7i_BFu0ll_BFu7ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7i_BFu0ll_BFu7ll) C1{ Fi:7 FL:0 FL:7}



static void Test_BFu7i_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu7ll, BFu7i_BFu0ll_BFu7ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu7s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7i_BFu0ll_BFu7s) C1{ Fi:7 FL:0 Fs:7}



static void Test_BFu7i_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu7s, BFu7i_BFu0ll_BFu7s)
//============================================================================


struct  BFu7i_BFu0ll_BFu8c  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7i_BFu0ll_BFu8c) C1{ Fi:7 FL:0 Fc:8}



static void Test_BFu7i_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu8c, BFu7i_BFu0ll_BFu8c)
//============================================================================


struct  BFu7i_BFu0ll_BFu8i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7i_BFu0ll_BFu8i) C1{ Fi:7 FL:0 Fi:8}



static void Test_BFu7i_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu8i, BFu7i_BFu0ll_BFu8i)
//============================================================================


struct  BFu7i_BFu0ll_BFu8ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7i_BFu0ll_BFu8ll) C1{ Fi:7 FL:0 FL:8}



static void Test_BFu7i_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu8ll, BFu7i_BFu0ll_BFu8ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu8s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7i_BFu0ll_BFu8s) C1{ Fi:7 FL:0 Fs:8}



static void Test_BFu7i_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu8s, BFu7i_BFu0ll_BFu8s)
//============================================================================


struct  BFu7i_BFu0ll_BFu9i  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7i_BFu0ll_BFu9i) C1{ Fi:7 FL:0 Fi:9}



static void Test_BFu7i_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu9i, BFu7i_BFu0ll_BFu9i)
//============================================================================


struct  BFu7i_BFu0ll_BFu9ll  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7i_BFu0ll_BFu9ll) C1{ Fi:7 FL:0 FL:9}



static void Test_BFu7i_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu9ll, BFu7i_BFu0ll_BFu9ll)
//============================================================================


struct  BFu7i_BFu0ll_BFu9s  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7i_BFu0ll_BFu9s) C1{ Fi:7 FL:0 Fs:9}



static void Test_BFu7i_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu7i_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_BFu9s, BFu7i_BFu0ll_BFu9s)
//============================================================================


struct  BFu7i_BFu0ll_C  {
  unsigned int v1:7;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu7i_BFu0ll_C) C1{ Fi:7 FL:0 Fc}



static void Test_BFu7i_BFu0ll_C()
{
  {
    init_simple_test("BFu7i_BFu0ll_C");
    static STRUCT_IF_C BFu7i_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_C, BFu7i_BFu0ll_C)
//============================================================================


struct  BFu7i_BFu0ll_D  {
  unsigned int v1:7;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu7i_BFu0ll_D) C1{ Fi:7 FL:0 FL}



static void Test_BFu7i_BFu0ll_D()
{
  {
    init_simple_test("BFu7i_BFu0ll_D");
    static STRUCT_IF_C BFu7i_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_D, BFu7i_BFu0ll_D)
//============================================================================


struct  BFu7i_BFu0ll_F  {
  unsigned int v1:7;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu7i_BFu0ll_F) C1{ Fi:7 FL:0 Fi}



static void Test_BFu7i_BFu0ll_F()
{
  {
    init_simple_test("BFu7i_BFu0ll_F");
    static STRUCT_IF_C BFu7i_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_F, BFu7i_BFu0ll_F)
//============================================================================


struct  BFu7i_BFu0ll_I  {
  unsigned int v1:7;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu7i_BFu0ll_I) C1{ Fi:7 FL:0 Fi}



static void Test_BFu7i_BFu0ll_I()
{
  {
    init_simple_test("BFu7i_BFu0ll_I");
    static STRUCT_IF_C BFu7i_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_I, BFu7i_BFu0ll_I)
//============================================================================


struct  BFu7i_BFu0ll_Ip  {
  unsigned int v1:7;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu7i_BFu0ll_Ip) C1{ Fi:7 FL:0 Fp}



static void Test_BFu7i_BFu0ll_Ip()
{
  {
    init_simple_test("BFu7i_BFu0ll_Ip");
    static STRUCT_IF_C BFu7i_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_Ip, BFu7i_BFu0ll_Ip)
//============================================================================


struct  BFu7i_BFu0ll_L  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu7i_BFu0ll_L) C1{ Fi:7 FL:0 FL}



static void Test_BFu7i_BFu0ll_L()
{
  {
    init_simple_test("BFu7i_BFu0ll_L");
    static STRUCT_IF_C BFu7i_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_L, BFu7i_BFu0ll_L)
//============================================================================


struct  BFu7i_BFu0ll_S  {
  unsigned int v1:7;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu7i_BFu0ll_S) C1{ Fi:7 FL:0 Fs}



static void Test_BFu7i_BFu0ll_S()
{
  {
    init_simple_test("BFu7i_BFu0ll_S");
    static STRUCT_IF_C BFu7i_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_S, BFu7i_BFu0ll_S)
//============================================================================


struct  BFu7i_BFu0ll_Uc  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu7i_BFu0ll_Uc) C1{ Fi:7 FL:0 Fc}



static void Test_BFu7i_BFu0ll_Uc()
{
  {
    init_simple_test("BFu7i_BFu0ll_Uc");
    static STRUCT_IF_C BFu7i_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_Uc, BFu7i_BFu0ll_Uc)
//============================================================================


struct  BFu7i_BFu0ll_Ui  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu7i_BFu0ll_Ui) C1{ Fi:7 FL:0 Fi}



static void Test_BFu7i_BFu0ll_Ui()
{
  {
    init_simple_test("BFu7i_BFu0ll_Ui");
    static STRUCT_IF_C BFu7i_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_Ui, BFu7i_BFu0ll_Ui)
//============================================================================


struct  BFu7i_BFu0ll_Ul  {
  unsigned int v1:7;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu7i_BFu0ll_Ul) C1{ Fi:7 FL:0 FL}



static void Test_BFu7i_BFu0ll_Ul()
{
  {
    init_simple_test("BFu7i_BFu0ll_Ul");
    static STRUCT_IF_C BFu7i_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_Ul, BFu7i_BFu0ll_Ul)
//============================================================================


struct  BFu7i_BFu0ll_Us  {
  unsigned int v1:7;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu7i_BFu0ll_Us) C1{ Fi:7 FL:0 Fs}



static void Test_BFu7i_BFu0ll_Us()
{
  {
    init_simple_test("BFu7i_BFu0ll_Us");
    static STRUCT_IF_C BFu7i_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu7i_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_Us, BFu7i_BFu0ll_Us)
//============================================================================


struct  BFu7i_BFu0ll_Vp  {
  unsigned int v1:7;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu7i_BFu0ll_Vp) C1{ Fi:7 FL:0 Fp}



static void Test_BFu7i_BFu0ll_Vp()
{
  {
    init_simple_test("BFu7i_BFu0ll_Vp");
    static STRUCT_IF_C BFu7i_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0ll_Vp, BFu7i_BFu0ll_Vp)
//============================================================================


struct  BFu7i_BFu0s  {
  unsigned int v1:7;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu0s) C1{ Fi:7 Fs:0}



static void Test_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s, BFu7i_BFu0s)
//============================================================================


struct  BFu7i_BFu0s_BFu0c  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu0s_BFu0c) C1{ Fi:7 Fs:0 Fc:0}



static void Test_BFu7i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu0c, BFu7i_BFu0s_BFu0c)
//============================================================================


struct  BFu7i_BFu0s_BFu0i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu0s_BFu0i) C1{ Fi:7 Fs:0 Fi:0}



static void Test_BFu7i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu0i, BFu7i_BFu0s_BFu0i)
//============================================================================


struct  BFu7i_BFu0s_BFu0ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu0s_BFu0ll) C1{ Fi:7 Fs:0 FL:0}



static void Test_BFu7i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu0ll, BFu7i_BFu0s_BFu0ll)
//============================================================================


struct  BFu7i_BFu0s_BFu0s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu0s_BFu0s) C1{ Fi:7 Fs:0 Fs:0}



static void Test_BFu7i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu0s, BFu7i_BFu0s_BFu0s)
//============================================================================


struct  BFu7i_BFu0s_BFu15i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7i_BFu0s_BFu15i) C1{ Fi:7 Fs:0 Fi:15}



static void Test_BFu7i_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu15i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu15i, BFu7i_BFu0s_BFu15i)
//============================================================================


struct  BFu7i_BFu0s_BFu15ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7i_BFu0s_BFu15ll) C1{ Fi:7 Fs:0 FL:15}



static void Test_BFu7i_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu15ll, BFu7i_BFu0s_BFu15ll)
//============================================================================


struct  BFu7i_BFu0s_BFu15s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7i_BFu0s_BFu15s) C1{ Fi:7 Fs:0 Fs:15}



static void Test_BFu7i_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu15s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu15s, BFu7i_BFu0s_BFu15s)
//============================================================================


struct  BFu7i_BFu0s_BFu16i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7i_BFu0s_BFu16i) C1{ Fi:7 Fs:0 Fi:16}



static void Test_BFu7i_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu16i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu16i, BFu7i_BFu0s_BFu16i)
//============================================================================


struct  BFu7i_BFu0s_BFu16ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7i_BFu0s_BFu16ll) C1{ Fi:7 Fs:0 FL:16}



static void Test_BFu7i_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu16ll, BFu7i_BFu0s_BFu16ll)
//============================================================================


struct  BFu7i_BFu0s_BFu16s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7i_BFu0s_BFu16s) C1{ Fi:7 Fs:0 Fs:16}



static void Test_BFu7i_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu16s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu16s, BFu7i_BFu0s_BFu16s)
//============================================================================


struct  BFu7i_BFu0s_BFu17i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7i_BFu0s_BFu17i) C1{ Fi:7 Fs:0 Fi:17}



static void Test_BFu7i_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu17i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu17i, BFu7i_BFu0s_BFu17i)
//============================================================================


struct  BFu7i_BFu0s_BFu17ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7i_BFu0s_BFu17ll) C1{ Fi:7 Fs:0 FL:17}



static void Test_BFu7i_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu7i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu7i_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu17ll, BFu7i_BFu0s_BFu17ll)
//============================================================================


struct  BFu7i_BFu0s_BFu1c  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7i_BFu0s_BFu1c) C1{ Fi:7 Fs:0 Fc:1}



static void Test_BFu7i_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu1c");
    static STRUCT_IF_C BFu7i_BFu0s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7i_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu1c, BFu7i_BFu0s_BFu1c)
//============================================================================


struct  BFu7i_BFu0s_BFu1i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7i_BFu0s_BFu1i) C1{ Fi:7 Fs:0 Fi:1}



static void Test_BFu7i_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu1i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7i_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu1i, BFu7i_BFu0s_BFu1i)
//============================================================================


struct  BFu7i_BFu0s_BFu1ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7i_BFu0s_BFu1ll) C1{ Fi:7 Fs:0 FL:1}



static void Test_BFu7i_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7i_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu1ll, BFu7i_BFu0s_BFu1ll)
//============================================================================


struct  BFu7i_BFu0s_BFu1s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7i_BFu0s_BFu1s) C1{ Fi:7 Fs:0 Fs:1}



static void Test_BFu7i_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu1s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7i_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu1s, BFu7i_BFu0s_BFu1s)
//============================================================================


struct  BFu7i_BFu0s_BFu31i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7i_BFu0s_BFu31i) C1{ Fi:7 Fs:0 Fi:31}



static void Test_BFu7i_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu31i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu31i, BFu7i_BFu0s_BFu31i)
//============================================================================


struct  BFu7i_BFu0s_BFu31ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7i_BFu0s_BFu31ll) C1{ Fi:7 Fs:0 FL:31}



static void Test_BFu7i_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu7i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu31ll, BFu7i_BFu0s_BFu31ll)
//============================================================================


struct  BFu7i_BFu0s_BFu32i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7i_BFu0s_BFu32i) C1{ Fi:7 Fs:0 Fi:32}



static void Test_BFu7i_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu32i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu32i, BFu7i_BFu0s_BFu32i)
//============================================================================


struct  BFu7i_BFu0s_BFu32ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7i_BFu0s_BFu32ll) C1{ Fi:7 Fs:0 FL:32}



static void Test_BFu7i_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu7i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu32ll, BFu7i_BFu0s_BFu32ll)
//============================================================================


struct  BFu7i_BFu0s_BFu33  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7i_BFu0s_BFu33) C1{ Fi:7 Fs:0 FL:33}



static void Test_BFu7i_BFu0s_BFu33()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu33");
    static STRUCT_IF_C BFu7i_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu7i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu7i_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu33, BFu7i_BFu0s_BFu33)
//============================================================================


struct  BFu7i_BFu0s_BFu7c  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7i_BFu0s_BFu7c) C1{ Fi:7 Fs:0 Fc:7}



static void Test_BFu7i_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu7c");
    static STRUCT_IF_C BFu7i_BFu0s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu7c, BFu7i_BFu0s_BFu7c)
//============================================================================


struct  BFu7i_BFu0s_BFu7i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7i_BFu0s_BFu7i) C1{ Fi:7 Fs:0 Fi:7}



static void Test_BFu7i_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu7i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu7i, BFu7i_BFu0s_BFu7i)
//============================================================================


struct  BFu7i_BFu0s_BFu7ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7i_BFu0s_BFu7ll) C1{ Fi:7 Fs:0 FL:7}



static void Test_BFu7i_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu7ll, BFu7i_BFu0s_BFu7ll)
//============================================================================


struct  BFu7i_BFu0s_BFu7s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7i_BFu0s_BFu7s) C1{ Fi:7 Fs:0 Fs:7}



static void Test_BFu7i_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu7s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu7s, BFu7i_BFu0s_BFu7s)
//============================================================================


struct  BFu7i_BFu0s_BFu8c  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7i_BFu0s_BFu8c) C1{ Fi:7 Fs:0 Fc:8}



static void Test_BFu7i_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu8c");
    static STRUCT_IF_C BFu7i_BFu0s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu8c, BFu7i_BFu0s_BFu8c)
//============================================================================


struct  BFu7i_BFu0s_BFu8i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7i_BFu0s_BFu8i) C1{ Fi:7 Fs:0 Fi:8}



static void Test_BFu7i_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu8i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu8i, BFu7i_BFu0s_BFu8i)
//============================================================================


struct  BFu7i_BFu0s_BFu8ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7i_BFu0s_BFu8ll) C1{ Fi:7 Fs:0 FL:8}



static void Test_BFu7i_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu8ll, BFu7i_BFu0s_BFu8ll)
//============================================================================


struct  BFu7i_BFu0s_BFu8s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7i_BFu0s_BFu8s) C1{ Fi:7 Fs:0 Fs:8}



static void Test_BFu7i_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu8s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu8s, BFu7i_BFu0s_BFu8s)
//============================================================================


struct  BFu7i_BFu0s_BFu9i  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7i_BFu0s_BFu9i) C1{ Fi:7 Fs:0 Fi:9}



static void Test_BFu7i_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu9i");
    static STRUCT_IF_C BFu7i_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu9i, BFu7i_BFu0s_BFu9i)
//============================================================================


struct  BFu7i_BFu0s_BFu9ll  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7i_BFu0s_BFu9ll) C1{ Fi:7 Fs:0 FL:9}



static void Test_BFu7i_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu7i_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu9ll, BFu7i_BFu0s_BFu9ll)
//============================================================================


struct  BFu7i_BFu0s_BFu9s  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7i_BFu0s_BFu9s) C1{ Fi:7 Fs:0 Fs:9}



static void Test_BFu7i_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu7i_BFu0s_BFu9s");
    static STRUCT_IF_C BFu7i_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_BFu9s, BFu7i_BFu0s_BFu9s)
//============================================================================


struct  BFu7i_BFu0s_C  {
  unsigned int v1:7;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu7i_BFu0s_C) C1{ Fi:7 Fs:0 Fc}



static void Test_BFu7i_BFu0s_C()
{
  {
    init_simple_test("BFu7i_BFu0s_C");
    static STRUCT_IF_C BFu7i_BFu0s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu7i_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_C, BFu7i_BFu0s_C)
//============================================================================


struct  BFu7i_BFu0s_D  {
  unsigned int v1:7;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu7i_BFu0s_D) C1{ Fi:7 Fs:0 FL}



static void Test_BFu7i_BFu0s_D()
{
  {
    init_simple_test("BFu7i_BFu0s_D");
    static STRUCT_IF_C BFu7i_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_D, BFu7i_BFu0s_D)
//============================================================================


struct  BFu7i_BFu0s_F  {
  unsigned int v1:7;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu7i_BFu0s_F) C1{ Fi:7 Fs:0 Fi}



static void Test_BFu7i_BFu0s_F()
{
  {
    init_simple_test("BFu7i_BFu0s_F");
    static STRUCT_IF_C BFu7i_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_F, BFu7i_BFu0s_F)
//============================================================================


struct  BFu7i_BFu0s_I  {
  unsigned int v1:7;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu7i_BFu0s_I) C1{ Fi:7 Fs:0 Fi}



static void Test_BFu7i_BFu0s_I()
{
  {
    init_simple_test("BFu7i_BFu0s_I");
    static STRUCT_IF_C BFu7i_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_I, BFu7i_BFu0s_I)
//============================================================================


struct  BFu7i_BFu0s_Ip  {
  unsigned int v1:7;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu7i_BFu0s_Ip) C1{ Fi:7 Fs:0 Fp}



static void Test_BFu7i_BFu0s_Ip()
{
  {
    init_simple_test("BFu7i_BFu0s_Ip");
    static STRUCT_IF_C BFu7i_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_Ip, BFu7i_BFu0s_Ip)
//============================================================================


struct  BFu7i_BFu0s_L  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu7i_BFu0s_L) C1{ Fi:7 Fs:0 FL}



static void Test_BFu7i_BFu0s_L()
{
  {
    init_simple_test("BFu7i_BFu0s_L");
    static STRUCT_IF_C BFu7i_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_L, BFu7i_BFu0s_L)
//============================================================================


struct  BFu7i_BFu0s_S  {
  unsigned int v1:7;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu7i_BFu0s_S) C1{ Fi:7 Fs:0 Fs}



static void Test_BFu7i_BFu0s_S()
{
  {
    init_simple_test("BFu7i_BFu0s_S");
    static STRUCT_IF_C BFu7i_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu7i_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_S, BFu7i_BFu0s_S)
//============================================================================


struct  BFu7i_BFu0s_Uc  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu7i_BFu0s_Uc) C1{ Fi:7 Fs:0 Fc}



static void Test_BFu7i_BFu0s_Uc()
{
  {
    init_simple_test("BFu7i_BFu0s_Uc");
    static STRUCT_IF_C BFu7i_BFu0s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu7i_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_Uc, BFu7i_BFu0s_Uc)
//============================================================================


struct  BFu7i_BFu0s_Ui  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu7i_BFu0s_Ui) C1{ Fi:7 Fs:0 Fi}



static void Test_BFu7i_BFu0s_Ui()
{
  {
    init_simple_test("BFu7i_BFu0s_Ui");
    static STRUCT_IF_C BFu7i_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu7i_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_Ui, BFu7i_BFu0s_Ui)
//============================================================================


struct  BFu7i_BFu0s_Ul  {
  unsigned int v1:7;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu7i_BFu0s_Ul) C1{ Fi:7 Fs:0 FL}



static void Test_BFu7i_BFu0s_Ul()
{
  {
    init_simple_test("BFu7i_BFu0s_Ul");
    static STRUCT_IF_C BFu7i_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_Ul, BFu7i_BFu0s_Ul)
//============================================================================


struct  BFu7i_BFu0s_Us  {
  unsigned int v1:7;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu7i_BFu0s_Us) C1{ Fi:7 Fs:0 Fs}



static void Test_BFu7i_BFu0s_Us()
{
  {
    init_simple_test("BFu7i_BFu0s_Us");
    static STRUCT_IF_C BFu7i_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu0s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu7i_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_Us, BFu7i_BFu0s_Us)
//============================================================================


struct  BFu7i_BFu0s_Vp  {
  unsigned int v1:7;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu7i_BFu0s_Vp) C1{ Fi:7 Fs:0 Fp}



static void Test_BFu7i_BFu0s_Vp()
{
  {
    init_simple_test("BFu7i_BFu0s_Vp");
    static STRUCT_IF_C BFu7i_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu0s_Vp, BFu7i_BFu0s_Vp)
//============================================================================


struct  BFu7i_BFu15i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu15i_BFu0c) C1{ Fi:7 Fi:15 Fc:0}



static void Test_BFu7i_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu0c, BFu7i_BFu15i_BFu0c)
//============================================================================


struct  BFu7i_BFu15i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu15i_BFu0i) C1{ Fi:7 Fi:15 Fi:0}



static void Test_BFu7i_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu0i, BFu7i_BFu15i_BFu0i)
//============================================================================


struct  BFu7i_BFu15i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu15i_BFu0ll) C1{ Fi:7 Fi:15 FL:0}



static void Test_BFu7i_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu0ll, BFu7i_BFu15i_BFu0ll)
//============================================================================


struct  BFu7i_BFu15i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu15i_BFu0s) C1{ Fi:7 Fi:15 Fs:0}



static void Test_BFu7i_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu15i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15i_BFu0s, BFu7i_BFu15i_BFu0s)
//============================================================================


struct  BFu7i_BFu15ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu15ll_BFu0c) C1{ Fi:7 FL:15 Fc:0}



static void Test_BFu7i_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu0c, BFu7i_BFu15ll_BFu0c)
//============================================================================


struct  BFu7i_BFu15ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu15ll_BFu0i) C1{ Fi:7 FL:15 Fi:0}



static void Test_BFu7i_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu0i, BFu7i_BFu15ll_BFu0i)
//============================================================================


struct  BFu7i_BFu15ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu15ll_BFu0ll) C1{ Fi:7 FL:15 FL:0}



static void Test_BFu7i_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu0ll, BFu7i_BFu15ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu15ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu15ll_BFu0s) C1{ Fi:7 FL:15 Fs:0}



static void Test_BFu7i_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15ll_BFu0s, BFu7i_BFu15ll_BFu0s)
//============================================================================


struct  BFu7i_BFu15s_BFu0c  {
  unsigned int v1:7;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu15s_BFu0c) C1{ Fi:7 Fs:15 Fc:0}



static void Test_BFu7i_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu0c, BFu7i_BFu15s_BFu0c)
//============================================================================


struct  BFu7i_BFu15s_BFu0i  {
  unsigned int v1:7;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu15s_BFu0i) C1{ Fi:7 Fs:15 Fi:0}



static void Test_BFu7i_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu0i, BFu7i_BFu15s_BFu0i)
//============================================================================


struct  BFu7i_BFu15s_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu15s_BFu0ll) C1{ Fi:7 Fs:15 FL:0}



static void Test_BFu7i_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu0ll, BFu7i_BFu15s_BFu0ll)
//============================================================================


struct  BFu7i_BFu15s_BFu0s  {
  unsigned int v1:7;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu15s_BFu0s) C1{ Fi:7 Fs:15 Fs:0}



static void Test_BFu7i_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu15s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu15s_BFu0s, BFu7i_BFu15s_BFu0s)
//============================================================================


struct  BFu7i_BFu16i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu16i_BFu0c) C1{ Fi:7 Fi:16 Fc:0}



static void Test_BFu7i_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu0c, BFu7i_BFu16i_BFu0c)
//============================================================================


struct  BFu7i_BFu16i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu16i_BFu0i) C1{ Fi:7 Fi:16 Fi:0}



static void Test_BFu7i_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu0i, BFu7i_BFu16i_BFu0i)
//============================================================================


struct  BFu7i_BFu16i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu16i_BFu0ll) C1{ Fi:7 Fi:16 FL:0}



static void Test_BFu7i_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu0ll, BFu7i_BFu16i_BFu0ll)
//============================================================================


struct  BFu7i_BFu16i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu16i_BFu0s) C1{ Fi:7 Fi:16 Fs:0}



static void Test_BFu7i_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu16i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16i_BFu0s, BFu7i_BFu16i_BFu0s)
//============================================================================


struct  BFu7i_BFu16ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu16ll_BFu0c) C1{ Fi:7 FL:16 Fc:0}



static void Test_BFu7i_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu0c, BFu7i_BFu16ll_BFu0c)
//============================================================================


struct  BFu7i_BFu16ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu16ll_BFu0i) C1{ Fi:7 FL:16 Fi:0}



static void Test_BFu7i_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu0i, BFu7i_BFu16ll_BFu0i)
//============================================================================


struct  BFu7i_BFu16ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu16ll_BFu0ll) C1{ Fi:7 FL:16 FL:0}



static void Test_BFu7i_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu0ll, BFu7i_BFu16ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu16ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu16ll_BFu0s) C1{ Fi:7 FL:16 Fs:0}



static void Test_BFu7i_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16ll_BFu0s, BFu7i_BFu16ll_BFu0s)
//============================================================================


struct  BFu7i_BFu16s_BFu0c  {
  unsigned int v1:7;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu16s_BFu0c) C1{ Fi:7 Fs:16 Fc:0}



static void Test_BFu7i_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu0c, BFu7i_BFu16s_BFu0c)
//============================================================================


struct  BFu7i_BFu16s_BFu0i  {
  unsigned int v1:7;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu16s_BFu0i) C1{ Fi:7 Fs:16 Fi:0}



static void Test_BFu7i_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu0i, BFu7i_BFu16s_BFu0i)
//============================================================================


struct  BFu7i_BFu16s_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu16s_BFu0ll) C1{ Fi:7 Fs:16 FL:0}



static void Test_BFu7i_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu0ll, BFu7i_BFu16s_BFu0ll)
//============================================================================


struct  BFu7i_BFu16s_BFu0s  {
  unsigned int v1:7;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu16s_BFu0s) C1{ Fi:7 Fs:16 Fs:0}



static void Test_BFu7i_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu16s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu16s_BFu0s, BFu7i_BFu16s_BFu0s)
//============================================================================


struct  BFu7i_BFu17i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu17i_BFu0c) C1{ Fi:7 Fi:17 Fc:0}



static void Test_BFu7i_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu0c, BFu7i_BFu17i_BFu0c)
//============================================================================


struct  BFu7i_BFu17i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu17i_BFu0i) C1{ Fi:7 Fi:17 Fi:0}



static void Test_BFu7i_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu0i, BFu7i_BFu17i_BFu0i)
//============================================================================


struct  BFu7i_BFu17i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu17i_BFu0ll) C1{ Fi:7 Fi:17 FL:0}



static void Test_BFu7i_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu0ll, BFu7i_BFu17i_BFu0ll)
//============================================================================


struct  BFu7i_BFu17i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu17i_BFu0s) C1{ Fi:7 Fi:17 Fs:0}



static void Test_BFu7i_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu17i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17i_BFu0s, BFu7i_BFu17i_BFu0s)
//============================================================================


struct  BFu7i_BFu17ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu17ll_BFu0c) C1{ Fi:7 FL:17 Fc:0}



static void Test_BFu7i_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu0c, BFu7i_BFu17ll_BFu0c)
//============================================================================


struct  BFu7i_BFu17ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu17ll_BFu0i) C1{ Fi:7 FL:17 Fi:0}



static void Test_BFu7i_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu0i, BFu7i_BFu17ll_BFu0i)
//============================================================================


struct  BFu7i_BFu17ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu17ll_BFu0ll) C1{ Fi:7 FL:17 FL:0}



static void Test_BFu7i_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu0ll, BFu7i_BFu17ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu17ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu17ll_BFu0s) C1{ Fi:7 FL:17 Fs:0}



static void Test_BFu7i_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu17ll_BFu0s, BFu7i_BFu17ll_BFu0s)
//============================================================================


struct  BFu7i_BFu1c_BFu0c  {
  unsigned int v1:7;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu1c_BFu0c) C1{ Fi:7 Fc:1 Fc:0}



static void Test_BFu7i_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu1c_BFu0c");
    static STRUCT_IF_C BFu7i_BFu1c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1c_BFu0c, BFu7i_BFu1c_BFu0c)
//============================================================================


struct  BFu7i_BFu1c_BFu0i  {
  unsigned int v1:7;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu1c_BFu0i) C1{ Fi:7 Fc:1 Fi:0}



static void Test_BFu7i_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu1c_BFu0i");
    static STRUCT_IF_C BFu7i_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1c_BFu0i, BFu7i_BFu1c_BFu0i)
//============================================================================


struct  BFu7i_BFu1c_BFu0ll  {
  unsigned int v1:7;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu1c_BFu0ll) C1{ Fi:7 Fc:1 FL:0}



static void Test_BFu7i_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1c_BFu0ll, BFu7i_BFu1c_BFu0ll)
//============================================================================


struct  BFu7i_BFu1c_BFu0s  {
  unsigned int v1:7;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu1c_BFu0s) C1{ Fi:7 Fc:1 Fs:0}



static void Test_BFu7i_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu1c_BFu0s");
    static STRUCT_IF_C BFu7i_BFu1c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1c_BFu0s, BFu7i_BFu1c_BFu0s)
//============================================================================


struct  BFu7i_BFu1i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu1i_BFu0c) C1{ Fi:7 Fi:1 Fc:0}



static void Test_BFu7i_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu1i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1i_BFu0c, BFu7i_BFu1i_BFu0c)
//============================================================================


struct  BFu7i_BFu1i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu1i_BFu0i) C1{ Fi:7 Fi:1 Fi:0}



static void Test_BFu7i_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu1i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1i_BFu0i, BFu7i_BFu1i_BFu0i)
//============================================================================


struct  BFu7i_BFu1i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu1i_BFu0ll) C1{ Fi:7 Fi:1 FL:0}



static void Test_BFu7i_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1i_BFu0ll, BFu7i_BFu1i_BFu0ll)
//============================================================================


struct  BFu7i_BFu1i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu1i_BFu0s) C1{ Fi:7 Fi:1 Fs:0}



static void Test_BFu7i_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu1i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1i_BFu0s, BFu7i_BFu1i_BFu0s)
//============================================================================


struct  BFu7i_BFu1ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu1ll_BFu0c) C1{ Fi:7 FL:1 Fc:0}



static void Test_BFu7i_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1ll_BFu0c, BFu7i_BFu1ll_BFu0c)
//============================================================================


struct  BFu7i_BFu1ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu1ll_BFu0i) C1{ Fi:7 FL:1 Fi:0}



static void Test_BFu7i_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1ll_BFu0i, BFu7i_BFu1ll_BFu0i)
//============================================================================


struct  BFu7i_BFu1ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu1ll_BFu0ll) C1{ Fi:7 FL:1 FL:0}



static void Test_BFu7i_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1ll_BFu0ll, BFu7i_BFu1ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu1ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu1ll_BFu0s) C1{ Fi:7 FL:1 Fs:0}



static void Test_BFu7i_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1ll_BFu0s, BFu7i_BFu1ll_BFu0s)
//============================================================================


struct  BFu7i_BFu1s_BFu0c  {
  unsigned int v1:7;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu1s_BFu0c) C1{ Fi:7 Fs:1 Fc:0}



static void Test_BFu7i_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu1s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu1s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1s_BFu0c, BFu7i_BFu1s_BFu0c)
//============================================================================


struct  BFu7i_BFu1s_BFu0i  {
  unsigned int v1:7;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu1s_BFu0i) C1{ Fi:7 Fs:1 Fi:0}



static void Test_BFu7i_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu1s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1s_BFu0i, BFu7i_BFu1s_BFu0i)
//============================================================================


struct  BFu7i_BFu1s_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu1s_BFu0ll) C1{ Fi:7 Fs:1 FL:0}



static void Test_BFu7i_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1s_BFu0ll, BFu7i_BFu1s_BFu0ll)
//============================================================================


struct  BFu7i_BFu1s_BFu0s  {
  unsigned int v1:7;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu1s_BFu0s) C1{ Fi:7 Fs:1 Fs:0}



static void Test_BFu7i_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu1s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu1s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu1s_BFu0s, BFu7i_BFu1s_BFu0s)
//============================================================================


struct  BFu7i_BFu31i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu31i_BFu0c) C1{ Fi:7 Fi:31 Fc:0}



static void Test_BFu7i_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu31i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31i_BFu0c, BFu7i_BFu31i_BFu0c)
//============================================================================


struct  BFu7i_BFu31i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu31i_BFu0i) C1{ Fi:7 Fi:31 Fi:0}



static void Test_BFu7i_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu31i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31i_BFu0i, BFu7i_BFu31i_BFu0i)
//============================================================================


struct  BFu7i_BFu31i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu31i_BFu0ll) C1{ Fi:7 Fi:31 FL:0}



static void Test_BFu7i_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31i_BFu0ll, BFu7i_BFu31i_BFu0ll)
//============================================================================


struct  BFu7i_BFu31i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu31i_BFu0s) C1{ Fi:7 Fi:31 Fs:0}



static void Test_BFu7i_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu31i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31i_BFu0s, BFu7i_BFu31i_BFu0s)
//============================================================================


struct  BFu7i_BFu31ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu31ll_BFu0c) C1{ Fi:7 FL:31 Fc:0}



static void Test_BFu7i_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31ll_BFu0c, BFu7i_BFu31ll_BFu0c)
//============================================================================


struct  BFu7i_BFu31ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu31ll_BFu0i) C1{ Fi:7 FL:31 Fi:0}



static void Test_BFu7i_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31ll_BFu0i, BFu7i_BFu31ll_BFu0i)
//============================================================================


struct  BFu7i_BFu31ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu31ll_BFu0ll) C1{ Fi:7 FL:31 FL:0}



static void Test_BFu7i_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31ll_BFu0ll, BFu7i_BFu31ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu31ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu31ll_BFu0s) C1{ Fi:7 FL:31 Fs:0}



static void Test_BFu7i_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu31ll_BFu0s, BFu7i_BFu31ll_BFu0s)
//============================================================================


struct  BFu7i_BFu32i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu32i_BFu0c) C1{ Fi:7 Fi:32 Fc:0}



static void Test_BFu7i_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu32i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32i_BFu0c, BFu7i_BFu32i_BFu0c)
//============================================================================


struct  BFu7i_BFu32i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu32i_BFu0i) C1{ Fi:7 Fi:32 Fi:0}



static void Test_BFu7i_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu32i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32i_BFu0i, BFu7i_BFu32i_BFu0i)
//============================================================================


struct  BFu7i_BFu32i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu32i_BFu0ll) C1{ Fi:7 Fi:32 FL:0}



static void Test_BFu7i_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32i_BFu0ll, BFu7i_BFu32i_BFu0ll)
//============================================================================


struct  BFu7i_BFu32i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu32i_BFu0s) C1{ Fi:7 Fi:32 Fs:0}



static void Test_BFu7i_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu32i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32i_BFu0s, BFu7i_BFu32i_BFu0s)
//============================================================================


struct  BFu7i_BFu32ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu32ll_BFu0c) C1{ Fi:7 FL:32 Fc:0}



static void Test_BFu7i_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32ll_BFu0c, BFu7i_BFu32ll_BFu0c)
//============================================================================


struct  BFu7i_BFu32ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu32ll_BFu0i) C1{ Fi:7 FL:32 Fi:0}



static void Test_BFu7i_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32ll_BFu0i, BFu7i_BFu32ll_BFu0i)
//============================================================================


struct  BFu7i_BFu32ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu32ll_BFu0ll) C1{ Fi:7 FL:32 FL:0}



static void Test_BFu7i_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32ll_BFu0ll, BFu7i_BFu32ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu32ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu32ll_BFu0s) C1{ Fi:7 FL:32 Fs:0}



static void Test_BFu7i_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu32ll_BFu0s, BFu7i_BFu32ll_BFu0s)
//============================================================================


struct  BFu7i_BFu33_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu33_BFu0c) C1{ Fi:7 FL:33 Fc:0}



static void Test_BFu7i_BFu33_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu33_BFu0c");
    static STRUCT_IF_C BFu7i_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu33_BFu0c, BFu7i_BFu33_BFu0c)
//============================================================================


struct  BFu7i_BFu33_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu33_BFu0i) C1{ Fi:7 FL:33 Fi:0}



static void Test_BFu7i_BFu33_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu33_BFu0i");
    static STRUCT_IF_C BFu7i_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu33_BFu0i, BFu7i_BFu33_BFu0i)
//============================================================================


struct  BFu7i_BFu33_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu33_BFu0ll) C1{ Fi:7 FL:33 FL:0}



static void Test_BFu7i_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu33_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu33_BFu0ll, BFu7i_BFu33_BFu0ll)
//============================================================================


struct  BFu7i_BFu33_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu33_BFu0s) C1{ Fi:7 FL:33 Fs:0}



static void Test_BFu7i_BFu33_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu33_BFu0s");
    static STRUCT_IF_C BFu7i_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu33_BFu0s, BFu7i_BFu33_BFu0s)
//============================================================================


struct  BFu7i_BFu7c_BFu0c  {
  unsigned int v1:7;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu7c_BFu0c) C1{ Fi:7 Fc:7 Fc:0}



static void Test_BFu7i_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu7c_BFu0c");
    static STRUCT_IF_C BFu7i_BFu7c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7c_BFu0c, BFu7i_BFu7c_BFu0c)
//============================================================================


struct  BFu7i_BFu7c_BFu0i  {
  unsigned int v1:7;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu7c_BFu0i) C1{ Fi:7 Fc:7 Fi:0}



static void Test_BFu7i_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu7c_BFu0i");
    static STRUCT_IF_C BFu7i_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7c_BFu0i, BFu7i_BFu7c_BFu0i)
//============================================================================


struct  BFu7i_BFu7c_BFu0ll  {
  unsigned int v1:7;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu7c_BFu0ll) C1{ Fi:7 Fc:7 FL:0}



static void Test_BFu7i_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7c_BFu0ll, BFu7i_BFu7c_BFu0ll)
//============================================================================


struct  BFu7i_BFu7c_BFu0s  {
  unsigned int v1:7;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu7c_BFu0s) C1{ Fi:7 Fc:7 Fs:0}



static void Test_BFu7i_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu7c_BFu0s");
    static STRUCT_IF_C BFu7i_BFu7c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7c_BFu0s, BFu7i_BFu7c_BFu0s)
//============================================================================


struct  BFu7i_BFu7i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu7i_BFu0c) C1{ Fi:7 Fi:7 Fc:0}



static void Test_BFu7i_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu7i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7i_BFu0c, BFu7i_BFu7i_BFu0c)
//============================================================================


struct  BFu7i_BFu7i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu7i_BFu0i) C1{ Fi:7 Fi:7 Fi:0}



static void Test_BFu7i_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu7i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7i_BFu0i, BFu7i_BFu7i_BFu0i)
//============================================================================


struct  BFu7i_BFu7i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu7i_BFu0ll) C1{ Fi:7 Fi:7 FL:0}



static void Test_BFu7i_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7i_BFu0ll, BFu7i_BFu7i_BFu0ll)
//============================================================================


struct  BFu7i_BFu7i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu7i_BFu0s) C1{ Fi:7 Fi:7 Fs:0}



static void Test_BFu7i_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu7i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7i_BFu0s, BFu7i_BFu7i_BFu0s)
//============================================================================


struct  BFu7i_BFu7ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu7ll_BFu0c) C1{ Fi:7 FL:7 Fc:0}



static void Test_BFu7i_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7ll_BFu0c, BFu7i_BFu7ll_BFu0c)
//============================================================================


struct  BFu7i_BFu7ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu7ll_BFu0i) C1{ Fi:7 FL:7 Fi:0}



static void Test_BFu7i_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7ll_BFu0i, BFu7i_BFu7ll_BFu0i)
//============================================================================


struct  BFu7i_BFu7ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu7ll_BFu0ll) C1{ Fi:7 FL:7 FL:0}



static void Test_BFu7i_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7ll_BFu0ll, BFu7i_BFu7ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu7ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu7ll_BFu0s) C1{ Fi:7 FL:7 Fs:0}



static void Test_BFu7i_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7ll_BFu0s, BFu7i_BFu7ll_BFu0s)
//============================================================================


struct  BFu7i_BFu7s_BFu0c  {
  unsigned int v1:7;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu7s_BFu0c) C1{ Fi:7 Fs:7 Fc:0}



static void Test_BFu7i_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu7s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu7s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7s_BFu0c, BFu7i_BFu7s_BFu0c)
//============================================================================


struct  BFu7i_BFu7s_BFu0i  {
  unsigned int v1:7;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu7s_BFu0i) C1{ Fi:7 Fs:7 Fi:0}



static void Test_BFu7i_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu7s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7s_BFu0i, BFu7i_BFu7s_BFu0i)
//============================================================================


struct  BFu7i_BFu7s_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu7s_BFu0ll) C1{ Fi:7 Fs:7 FL:0}



static void Test_BFu7i_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7s_BFu0ll, BFu7i_BFu7s_BFu0ll)
//============================================================================


struct  BFu7i_BFu7s_BFu0s  {
  unsigned int v1:7;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu7s_BFu0s) C1{ Fi:7 Fs:7 Fs:0}



static void Test_BFu7i_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu7s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu7s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu7s_BFu0s, BFu7i_BFu7s_BFu0s)
//============================================================================


struct  BFu7i_BFu8c_BFu0c  {
  unsigned int v1:7;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu8c_BFu0c) C1{ Fi:7 Fc:8 Fc:0}



static void Test_BFu7i_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu8c_BFu0c");
    static STRUCT_IF_C BFu7i_BFu8c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8c_BFu0c, BFu7i_BFu8c_BFu0c)
//============================================================================


struct  BFu7i_BFu8c_BFu0i  {
  unsigned int v1:7;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu8c_BFu0i) C1{ Fi:7 Fc:8 Fi:0}



static void Test_BFu7i_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu8c_BFu0i");
    static STRUCT_IF_C BFu7i_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8c_BFu0i, BFu7i_BFu8c_BFu0i)
//============================================================================


struct  BFu7i_BFu8c_BFu0ll  {
  unsigned int v1:7;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu8c_BFu0ll) C1{ Fi:7 Fc:8 FL:0}



static void Test_BFu7i_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8c_BFu0ll, BFu7i_BFu8c_BFu0ll)
//============================================================================


struct  BFu7i_BFu8c_BFu0s  {
  unsigned int v1:7;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu8c_BFu0s) C1{ Fi:7 Fc:8 Fs:0}



static void Test_BFu7i_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu8c_BFu0s");
    static STRUCT_IF_C BFu7i_BFu8c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8c_BFu0s, BFu7i_BFu8c_BFu0s)
//============================================================================


struct  BFu7i_BFu8i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu8i_BFu0c) C1{ Fi:7 Fi:8 Fc:0}



static void Test_BFu7i_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu8i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8i_BFu0c, BFu7i_BFu8i_BFu0c)
//============================================================================


struct  BFu7i_BFu8i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu8i_BFu0i) C1{ Fi:7 Fi:8 Fi:0}



static void Test_BFu7i_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu8i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8i_BFu0i, BFu7i_BFu8i_BFu0i)
//============================================================================


struct  BFu7i_BFu8i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu8i_BFu0ll) C1{ Fi:7 Fi:8 FL:0}



static void Test_BFu7i_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8i_BFu0ll, BFu7i_BFu8i_BFu0ll)
//============================================================================


struct  BFu7i_BFu8i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu8i_BFu0s) C1{ Fi:7 Fi:8 Fs:0}



static void Test_BFu7i_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu8i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8i_BFu0s, BFu7i_BFu8i_BFu0s)
//============================================================================


struct  BFu7i_BFu8ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu8ll_BFu0c) C1{ Fi:7 FL:8 Fc:0}



static void Test_BFu7i_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8ll_BFu0c, BFu7i_BFu8ll_BFu0c)
//============================================================================


struct  BFu7i_BFu8ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu8ll_BFu0i) C1{ Fi:7 FL:8 Fi:0}



static void Test_BFu7i_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8ll_BFu0i, BFu7i_BFu8ll_BFu0i)
//============================================================================


struct  BFu7i_BFu8ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu8ll_BFu0ll) C1{ Fi:7 FL:8 FL:0}



static void Test_BFu7i_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8ll_BFu0ll, BFu7i_BFu8ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu8ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu8ll_BFu0s) C1{ Fi:7 FL:8 Fs:0}



static void Test_BFu7i_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8ll_BFu0s, BFu7i_BFu8ll_BFu0s)
//============================================================================


struct  BFu7i_BFu8s_BFu0c  {
  unsigned int v1:7;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu8s_BFu0c) C1{ Fi:7 Fs:8 Fc:0}



static void Test_BFu7i_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu8s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu8s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8s_BFu0c, BFu7i_BFu8s_BFu0c)
//============================================================================


struct  BFu7i_BFu8s_BFu0i  {
  unsigned int v1:7;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu8s_BFu0i) C1{ Fi:7 Fs:8 Fi:0}



static void Test_BFu7i_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu8s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8s_BFu0i, BFu7i_BFu8s_BFu0i)
//============================================================================


struct  BFu7i_BFu8s_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu8s_BFu0ll) C1{ Fi:7 Fs:8 FL:0}



static void Test_BFu7i_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8s_BFu0ll, BFu7i_BFu8s_BFu0ll)
//============================================================================


struct  BFu7i_BFu8s_BFu0s  {
  unsigned int v1:7;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu8s_BFu0s) C1{ Fi:7 Fs:8 Fs:0}



static void Test_BFu7i_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu8s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu8s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu8s_BFu0s, BFu7i_BFu8s_BFu0s)
//============================================================================


struct  BFu7i_BFu9i_BFu0c  {
  unsigned int v1:7;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu9i_BFu0c) C1{ Fi:7 Fi:9 Fc:0}



static void Test_BFu7i_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu9i_BFu0c");
    static STRUCT_IF_C BFu7i_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9i_BFu0c, BFu7i_BFu9i_BFu0c)
//============================================================================


struct  BFu7i_BFu9i_BFu0i  {
  unsigned int v1:7;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu9i_BFu0i) C1{ Fi:7 Fi:9 Fi:0}



static void Test_BFu7i_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu9i_BFu0i");
    static STRUCT_IF_C BFu7i_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9i_BFu0i, BFu7i_BFu9i_BFu0i)
//============================================================================


struct  BFu7i_BFu9i_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu9i_BFu0ll) C1{ Fi:7 Fi:9 FL:0}



static void Test_BFu7i_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9i_BFu0ll, BFu7i_BFu9i_BFu0ll)
//============================================================================


struct  BFu7i_BFu9i_BFu0s  {
  unsigned int v1:7;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu9i_BFu0s) C1{ Fi:7 Fi:9 Fs:0}



static void Test_BFu7i_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu9i_BFu0s");
    static STRUCT_IF_C BFu7i_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9i_BFu0s, BFu7i_BFu9i_BFu0s)
//============================================================================


struct  BFu7i_BFu9ll_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu9ll_BFu0c) C1{ Fi:7 FL:9 Fc:0}



static void Test_BFu7i_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu7i_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9ll_BFu0c, BFu7i_BFu9ll_BFu0c)
//============================================================================


struct  BFu7i_BFu9ll_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu9ll_BFu0i) C1{ Fi:7 FL:9 Fi:0}



static void Test_BFu7i_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu7i_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9ll_BFu0i, BFu7i_BFu9ll_BFu0i)
//============================================================================


struct  BFu7i_BFu9ll_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu9ll_BFu0ll) C1{ Fi:7 FL:9 FL:0}



static void Test_BFu7i_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9ll_BFu0ll, BFu7i_BFu9ll_BFu0ll)
//============================================================================


struct  BFu7i_BFu9ll_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu9ll_BFu0s) C1{ Fi:7 FL:9 Fs:0}



static void Test_BFu7i_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu7i_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9ll_BFu0s, BFu7i_BFu9ll_BFu0s)
//============================================================================


struct  BFu7i_BFu9s_BFu0c  {
  unsigned int v1:7;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu7i_BFu9s_BFu0c) C1{ Fi:7 Fs:9 Fc:0}



static void Test_BFu7i_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu7i_BFu9s_BFu0c");
    static STRUCT_IF_C BFu7i_BFu9s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9s_BFu0c, BFu7i_BFu9s_BFu0c)
//============================================================================


struct  BFu7i_BFu9s_BFu0i  {
  unsigned int v1:7;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu7i_BFu9s_BFu0i) C1{ Fi:7 Fs:9 Fi:0}



static void Test_BFu7i_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu7i_BFu9s_BFu0i");
    static STRUCT_IF_C BFu7i_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9s_BFu0i, BFu7i_BFu9s_BFu0i)
//============================================================================


struct  BFu7i_BFu9s_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu7i_BFu9s_BFu0ll) C1{ Fi:7 Fs:9 FL:0}



static void Test_BFu7i_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu7i_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu7i_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9s_BFu0ll, BFu7i_BFu9s_BFu0ll)
//============================================================================


struct  BFu7i_BFu9s_BFu0s  {
  unsigned int v1:7;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu7i_BFu9s_BFu0s) C1{ Fi:7 Fs:9 Fs:0}



static void Test_BFu7i_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu7i_BFu9s_BFu0s");
    static STRUCT_IF_C BFu7i_BFu9s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_BFu9s_BFu0s, BFu7i_BFu9s_BFu0s)
//============================================================================


struct  BFu7i_C_BFu0c  {
  unsigned int v1:7;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_C_BFu0c) C1{ Fi:7 Fc Fc:0}



static void Test_BFu7i_C_BFu0c()
{
  {
    init_simple_test("BFu7i_C_BFu0c");
    static STRUCT_IF_C BFu7i_C_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_C_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_C_BFu0c");
    check_field_offset(lv, v2, 1, "BFu7i_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_C_BFu0c, BFu7i_C_BFu0c)
//============================================================================


struct  BFu7i_C_BFu0i  {
  unsigned int v1:7;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_C_BFu0i) C1{ Fi:7 Fc Fi:0}



static void Test_BFu7i_C_BFu0i()
{
  {
    init_simple_test("BFu7i_C_BFu0i");
    static STRUCT_IF_C BFu7i_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_C_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_C_BFu0i");
    check_field_offset(lv, v2, 1, "BFu7i_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_C_BFu0i, BFu7i_C_BFu0i)
//============================================================================


struct  BFu7i_C_BFu0ll  {
  unsigned int v1:7;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_C_BFu0ll) C1{ Fi:7 Fc FL:0}



static void Test_BFu7i_C_BFu0ll()
{
  {
    init_simple_test("BFu7i_C_BFu0ll");
    static STRUCT_IF_C BFu7i_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_C_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu7i_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_C_BFu0ll, BFu7i_C_BFu0ll)
//============================================================================


struct  BFu7i_C_BFu0s  {
  unsigned int v1:7;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_C_BFu0s) C1{ Fi:7 Fc Fs:0}



static void Test_BFu7i_C_BFu0s()
{
  {
    init_simple_test("BFu7i_C_BFu0s");
    static STRUCT_IF_C BFu7i_C_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_C_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_C_BFu0s");
    check_field_offset(lv, v2, 1, "BFu7i_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_C_BFu0s, BFu7i_C_BFu0s)
//============================================================================


struct  BFu7i_D_BFu0c  {
  unsigned int v1:7;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_D_BFu0c) C1{ Fi:7 FL Fc:0}



static void Test_BFu7i_D_BFu0c()
{
  {
    init_simple_test("BFu7i_D_BFu0c");
    static STRUCT_IF_C BFu7i_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_D_BFu0c, BFu7i_D_BFu0c)
//============================================================================


struct  BFu7i_D_BFu0i  {
  unsigned int v1:7;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_D_BFu0i) C1{ Fi:7 FL Fi:0}



static void Test_BFu7i_D_BFu0i()
{
  {
    init_simple_test("BFu7i_D_BFu0i");
    static STRUCT_IF_C BFu7i_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_D_BFu0i, BFu7i_D_BFu0i)
//============================================================================


struct  BFu7i_D_BFu0ll  {
  unsigned int v1:7;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_D_BFu0ll) C1{ Fi:7 FL FL:0}



static void Test_BFu7i_D_BFu0ll()
{
  {
    init_simple_test("BFu7i_D_BFu0ll");
    static STRUCT_IF_C BFu7i_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_D_BFu0ll, BFu7i_D_BFu0ll)
//============================================================================


struct  BFu7i_D_BFu0s  {
  unsigned int v1:7;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_D_BFu0s) C1{ Fi:7 FL Fs:0}



static void Test_BFu7i_D_BFu0s()
{
  {
    init_simple_test("BFu7i_D_BFu0s");
    static STRUCT_IF_C BFu7i_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_D_BFu0s, BFu7i_D_BFu0s)
//============================================================================


struct  BFu7i_F_BFu0c  {
  unsigned int v1:7;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_F_BFu0c) C1{ Fi:7 Fi Fc:0}



static void Test_BFu7i_F_BFu0c()
{
  {
    init_simple_test("BFu7i_F_BFu0c");
    static STRUCT_IF_C BFu7i_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu7i_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_F_BFu0c, BFu7i_F_BFu0c)
//============================================================================


struct  BFu7i_F_BFu0i  {
  unsigned int v1:7;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_F_BFu0i) C1{ Fi:7 Fi Fi:0}



static void Test_BFu7i_F_BFu0i()
{
  {
    init_simple_test("BFu7i_F_BFu0i");
    static STRUCT_IF_C BFu7i_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu7i_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_F_BFu0i, BFu7i_F_BFu0i)
//============================================================================


struct  BFu7i_F_BFu0ll  {
  unsigned int v1:7;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_F_BFu0ll) C1{ Fi:7 Fi FL:0}



static void Test_BFu7i_F_BFu0ll()
{
  {
    init_simple_test("BFu7i_F_BFu0ll");
    static STRUCT_IF_C BFu7i_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu7i_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_F_BFu0ll, BFu7i_F_BFu0ll)
//============================================================================


struct  BFu7i_F_BFu0s  {
  unsigned int v1:7;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_F_BFu0s) C1{ Fi:7 Fi Fs:0}



static void Test_BFu7i_F_BFu0s()
{
  {
    init_simple_test("BFu7i_F_BFu0s");
    static STRUCT_IF_C BFu7i_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu7i_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_F_BFu0s, BFu7i_F_BFu0s)
//============================================================================


struct  BFu7i_I_BFu0c  {
  unsigned int v1:7;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_I_BFu0c) C1{ Fi:7 Fi Fc:0}



static void Test_BFu7i_I_BFu0c()
{
  {
    init_simple_test("BFu7i_I_BFu0c");
    static STRUCT_IF_C BFu7i_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu7i_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_I_BFu0c, BFu7i_I_BFu0c)
//============================================================================


struct  BFu7i_I_BFu0i  {
  unsigned int v1:7;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_I_BFu0i) C1{ Fi:7 Fi Fi:0}



static void Test_BFu7i_I_BFu0i()
{
  {
    init_simple_test("BFu7i_I_BFu0i");
    static STRUCT_IF_C BFu7i_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu7i_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_I_BFu0i, BFu7i_I_BFu0i)
//============================================================================


struct  BFu7i_I_BFu0ll  {
  unsigned int v1:7;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_I_BFu0ll) C1{ Fi:7 Fi FL:0}



static void Test_BFu7i_I_BFu0ll()
{
  {
    init_simple_test("BFu7i_I_BFu0ll");
    static STRUCT_IF_C BFu7i_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu7i_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_I_BFu0ll, BFu7i_I_BFu0ll)
//============================================================================


struct  BFu7i_I_BFu0s  {
  unsigned int v1:7;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_I_BFu0s) C1{ Fi:7 Fi Fs:0}



static void Test_BFu7i_I_BFu0s()
{
  {
    init_simple_test("BFu7i_I_BFu0s");
    static STRUCT_IF_C BFu7i_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu7i_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_I_BFu0s, BFu7i_I_BFu0s)
//============================================================================


struct  BFu7i_Ip_BFu0c  {
  unsigned int v1:7;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_Ip_BFu0c) C1{ Fi:7 Fp Fc:0}



static void Test_BFu7i_Ip_BFu0c()
{
  {
    init_simple_test("BFu7i_Ip_BFu0c");
    static STRUCT_IF_C BFu7i_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ip_BFu0c, BFu7i_Ip_BFu0c)
//============================================================================


struct  BFu7i_Ip_BFu0i  {
  unsigned int v1:7;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_Ip_BFu0i) C1{ Fi:7 Fp Fi:0}



static void Test_BFu7i_Ip_BFu0i()
{
  {
    init_simple_test("BFu7i_Ip_BFu0i");
    static STRUCT_IF_C BFu7i_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ip_BFu0i, BFu7i_Ip_BFu0i)
//============================================================================


struct  BFu7i_Ip_BFu0ll  {
  unsigned int v1:7;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_Ip_BFu0ll) C1{ Fi:7 Fp FL:0}



static void Test_BFu7i_Ip_BFu0ll()
{
  {
    init_simple_test("BFu7i_Ip_BFu0ll");
    static STRUCT_IF_C BFu7i_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ip_BFu0ll, BFu7i_Ip_BFu0ll)
//============================================================================


struct  BFu7i_Ip_BFu0s  {
  unsigned int v1:7;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_Ip_BFu0s) C1{ Fi:7 Fp Fs:0}



static void Test_BFu7i_Ip_BFu0s()
{
  {
    init_simple_test("BFu7i_Ip_BFu0s");
    static STRUCT_IF_C BFu7i_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ip_BFu0s, BFu7i_Ip_BFu0s)
//============================================================================


struct  BFu7i_L_BFu0c  {
  unsigned int v1:7;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_L_BFu0c) C1{ Fi:7 FL Fc:0}



static void Test_BFu7i_L_BFu0c()
{
  {
    init_simple_test("BFu7i_L_BFu0c");
    static STRUCT_IF_C BFu7i_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_L_BFu0c, BFu7i_L_BFu0c)
//============================================================================


struct  BFu7i_L_BFu0i  {
  unsigned int v1:7;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_L_BFu0i) C1{ Fi:7 FL Fi:0}



static void Test_BFu7i_L_BFu0i()
{
  {
    init_simple_test("BFu7i_L_BFu0i");
    static STRUCT_IF_C BFu7i_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_L_BFu0i, BFu7i_L_BFu0i)
//============================================================================


struct  BFu7i_L_BFu0ll  {
  unsigned int v1:7;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_L_BFu0ll) C1{ Fi:7 FL FL:0}



static void Test_BFu7i_L_BFu0ll()
{
  {
    init_simple_test("BFu7i_L_BFu0ll");
    static STRUCT_IF_C BFu7i_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_L_BFu0ll, BFu7i_L_BFu0ll)
//============================================================================


struct  BFu7i_L_BFu0s  {
  unsigned int v1:7;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_L_BFu0s) C1{ Fi:7 FL Fs:0}



static void Test_BFu7i_L_BFu0s()
{
  {
    init_simple_test("BFu7i_L_BFu0s");
    static STRUCT_IF_C BFu7i_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_L_BFu0s, BFu7i_L_BFu0s)
//============================================================================


struct  BFu7i_S_BFu0c  {
  unsigned int v1:7;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_S_BFu0c) C1{ Fi:7 Fs Fc:0}



static void Test_BFu7i_S_BFu0c()
{
  {
    init_simple_test("BFu7i_S_BFu0c");
    static STRUCT_IF_C BFu7i_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_S_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu7i_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_S_BFu0c, BFu7i_S_BFu0c)
//============================================================================


struct  BFu7i_S_BFu0i  {
  unsigned int v1:7;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_S_BFu0i) C1{ Fi:7 Fs Fi:0}



static void Test_BFu7i_S_BFu0i()
{
  {
    init_simple_test("BFu7i_S_BFu0i");
    static STRUCT_IF_C BFu7i_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_S_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu7i_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_S_BFu0i, BFu7i_S_BFu0i)
//============================================================================


struct  BFu7i_S_BFu0ll  {
  unsigned int v1:7;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_S_BFu0ll) C1{ Fi:7 Fs FL:0}



static void Test_BFu7i_S_BFu0ll()
{
  {
    init_simple_test("BFu7i_S_BFu0ll");
    static STRUCT_IF_C BFu7i_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu7i_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_S_BFu0ll, BFu7i_S_BFu0ll)
//============================================================================


struct  BFu7i_S_BFu0s  {
  unsigned int v1:7;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_S_BFu0s) C1{ Fi:7 Fs Fs:0}



static void Test_BFu7i_S_BFu0s()
{
  {
    init_simple_test("BFu7i_S_BFu0s");
    static STRUCT_IF_C BFu7i_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_S_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu7i_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_S_BFu0s, BFu7i_S_BFu0s)
//============================================================================


struct  BFu7i_Uc_BFu0c  {
  unsigned int v1:7;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_Uc_BFu0c) C1{ Fi:7 Fc Fc:0}



static void Test_BFu7i_Uc_BFu0c()
{
  {
    init_simple_test("BFu7i_Uc_BFu0c");
    static STRUCT_IF_C BFu7i_Uc_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Uc_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Uc_BFu0c");
    check_field_offset(lv, v2, 1, "BFu7i_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Uc_BFu0c, BFu7i_Uc_BFu0c)
//============================================================================


struct  BFu7i_Uc_BFu0i  {
  unsigned int v1:7;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_Uc_BFu0i) C1{ Fi:7 Fc Fi:0}



static void Test_BFu7i_Uc_BFu0i()
{
  {
    init_simple_test("BFu7i_Uc_BFu0i");
    static STRUCT_IF_C BFu7i_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Uc_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Uc_BFu0i");
    check_field_offset(lv, v2, 1, "BFu7i_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Uc_BFu0i, BFu7i_Uc_BFu0i)
//============================================================================


struct  BFu7i_Uc_BFu0ll  {
  unsigned int v1:7;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_Uc_BFu0ll) C1{ Fi:7 Fc FL:0}



static void Test_BFu7i_Uc_BFu0ll()
{
  {
    init_simple_test("BFu7i_Uc_BFu0ll");
    static STRUCT_IF_C BFu7i_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Uc_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu7i_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Uc_BFu0ll, BFu7i_Uc_BFu0ll)
//============================================================================


struct  BFu7i_Uc_BFu0s  {
  unsigned int v1:7;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_Uc_BFu0s) C1{ Fi:7 Fc Fs:0}



static void Test_BFu7i_Uc_BFu0s()
{
  {
    init_simple_test("BFu7i_Uc_BFu0s");
    static STRUCT_IF_C BFu7i_Uc_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Uc_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Uc_BFu0s");
    check_field_offset(lv, v2, 1, "BFu7i_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Uc_BFu0s, BFu7i_Uc_BFu0s)
//============================================================================


struct  BFu7i_Ui_BFu0c  {
  unsigned int v1:7;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_Ui_BFu0c) C1{ Fi:7 Fi Fc:0}



static void Test_BFu7i_Ui_BFu0c()
{
  {
    init_simple_test("BFu7i_Ui_BFu0c");
    static STRUCT_IF_C BFu7i_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu7i_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ui_BFu0c, BFu7i_Ui_BFu0c)
//============================================================================


struct  BFu7i_Ui_BFu0i  {
  unsigned int v1:7;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_Ui_BFu0i) C1{ Fi:7 Fi Fi:0}



static void Test_BFu7i_Ui_BFu0i()
{
  {
    init_simple_test("BFu7i_Ui_BFu0i");
    static STRUCT_IF_C BFu7i_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu7i_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ui_BFu0i, BFu7i_Ui_BFu0i)
//============================================================================


struct  BFu7i_Ui_BFu0ll  {
  unsigned int v1:7;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_Ui_BFu0ll) C1{ Fi:7 Fi FL:0}



static void Test_BFu7i_Ui_BFu0ll()
{
  {
    init_simple_test("BFu7i_Ui_BFu0ll");
    static STRUCT_IF_C BFu7i_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu7i_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ui_BFu0ll, BFu7i_Ui_BFu0ll)
//============================================================================


struct  BFu7i_Ui_BFu0s  {
  unsigned int v1:7;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_Ui_BFu0s) C1{ Fi:7 Fi Fs:0}



static void Test_BFu7i_Ui_BFu0s()
{
  {
    init_simple_test("BFu7i_Ui_BFu0s");
    static STRUCT_IF_C BFu7i_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu7i_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ui_BFu0s, BFu7i_Ui_BFu0s)
//============================================================================


struct  BFu7i_Ul_BFu0c  {
  unsigned int v1:7;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_Ul_BFu0c) C1{ Fi:7 FL Fc:0}



static void Test_BFu7i_Ul_BFu0c()
{
  {
    init_simple_test("BFu7i_Ul_BFu0c");
    static STRUCT_IF_C BFu7i_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ul_BFu0c, BFu7i_Ul_BFu0c)
//============================================================================


struct  BFu7i_Ul_BFu0i  {
  unsigned int v1:7;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_Ul_BFu0i) C1{ Fi:7 FL Fi:0}



static void Test_BFu7i_Ul_BFu0i()
{
  {
    init_simple_test("BFu7i_Ul_BFu0i");
    static STRUCT_IF_C BFu7i_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ul_BFu0i, BFu7i_Ul_BFu0i)
//============================================================================


struct  BFu7i_Ul_BFu0ll  {
  unsigned int v1:7;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_Ul_BFu0ll) C1{ Fi:7 FL FL:0}



static void Test_BFu7i_Ul_BFu0ll()
{
  {
    init_simple_test("BFu7i_Ul_BFu0ll");
    static STRUCT_IF_C BFu7i_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ul_BFu0ll, BFu7i_Ul_BFu0ll)
//============================================================================


struct  BFu7i_Ul_BFu0s  {
  unsigned int v1:7;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_Ul_BFu0s) C1{ Fi:7 FL Fs:0}



static void Test_BFu7i_Ul_BFu0s()
{
  {
    init_simple_test("BFu7i_Ul_BFu0s");
    static STRUCT_IF_C BFu7i_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Ul_BFu0s, BFu7i_Ul_BFu0s)
//============================================================================


struct  BFu7i_Us_BFu0c  {
  unsigned int v1:7;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_Us_BFu0c) C1{ Fi:7 Fs Fc:0}



static void Test_BFu7i_Us_BFu0c()
{
  {
    init_simple_test("BFu7i_Us_BFu0c");
    static STRUCT_IF_C BFu7i_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Us_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu7i_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Us_BFu0c, BFu7i_Us_BFu0c)
//============================================================================


struct  BFu7i_Us_BFu0i  {
  unsigned int v1:7;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_Us_BFu0i) C1{ Fi:7 Fs Fi:0}



static void Test_BFu7i_Us_BFu0i()
{
  {
    init_simple_test("BFu7i_Us_BFu0i");
    static STRUCT_IF_C BFu7i_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Us_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu7i_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Us_BFu0i, BFu7i_Us_BFu0i)
//============================================================================


struct  BFu7i_Us_BFu0ll  {
  unsigned int v1:7;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_Us_BFu0ll) C1{ Fi:7 Fs FL:0}



static void Test_BFu7i_Us_BFu0ll()
{
  {
    init_simple_test("BFu7i_Us_BFu0ll");
    static STRUCT_IF_C BFu7i_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu7i_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu7i_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Us_BFu0ll, BFu7i_Us_BFu0ll)
//============================================================================


struct  BFu7i_Us_BFu0s  {
  unsigned int v1:7;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_Us_BFu0s) C1{ Fi:7 Fs Fs:0}



static void Test_BFu7i_Us_BFu0s()
{
  {
    init_simple_test("BFu7i_Us_BFu0s");
    static STRUCT_IF_C BFu7i_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Us_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu7i_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Us_BFu0s, BFu7i_Us_BFu0s)
//============================================================================


struct  BFu7i_Vp_BFu0c  {
  unsigned int v1:7;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu7i_Vp_BFu0c) C1{ Fi:7 Fp Fc:0}



static void Test_BFu7i_Vp_BFu0c()
{
  {
    init_simple_test("BFu7i_Vp_BFu0c");
    static STRUCT_IF_C BFu7i_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Vp_BFu0c, BFu7i_Vp_BFu0c)
//============================================================================


struct  BFu7i_Vp_BFu0i  {
  unsigned int v1:7;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu7i_Vp_BFu0i) C1{ Fi:7 Fp Fi:0}



static void Test_BFu7i_Vp_BFu0i()
{
  {
    init_simple_test("BFu7i_Vp_BFu0i");
    static STRUCT_IF_C BFu7i_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Vp_BFu0i, BFu7i_Vp_BFu0i)
//============================================================================


struct  BFu7i_Vp_BFu0ll  {
  unsigned int v1:7;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu7i_Vp_BFu0ll) C1{ Fi:7 Fp FL:0}



static void Test_BFu7i_Vp_BFu0ll()
{
  {
    init_simple_test("BFu7i_Vp_BFu0ll");
    static STRUCT_IF_C BFu7i_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Vp_BFu0ll, BFu7i_Vp_BFu0ll)
//============================================================================


struct  BFu7i_Vp_BFu0s  {
  unsigned int v1:7;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu7i_Vp_BFu0s) C1{ Fi:7 Fp Fs:0}



static void Test_BFu7i_Vp_BFu0s()
{
  {
    init_simple_test("BFu7i_Vp_BFu0s");
    static STRUCT_IF_C BFu7i_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7i_Vp_BFu0s, BFu7i_Vp_BFu0s)
//============================================================================


struct  BFu7ll_BFu0c  {
  __tsu64 v1:7;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu0c) C1{ FL:7 Fc:0}



static void Test_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c, BFu7ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu0c_BFu0c  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu0c_BFu0c) C1{ FL:7 Fc:0 Fc:0}



static void Test_BFu7ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu0c, BFu7ll_BFu0c_BFu0c)
//============================================================================


struct  BFu7ll_BFu0c_BFu0i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu0c_BFu0i) C1{ FL:7 Fc:0 Fi:0}



static void Test_BFu7ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu0i, BFu7ll_BFu0c_BFu0i)
//============================================================================


struct  BFu7ll_BFu0c_BFu0ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu0c_BFu0ll) C1{ FL:7 Fc:0 FL:0}



static void Test_BFu7ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu0ll, BFu7ll_BFu0c_BFu0ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu0s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu0c_BFu0s) C1{ FL:7 Fc:0 Fs:0}



static void Test_BFu7ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu0s, BFu7ll_BFu0c_BFu0s)
//============================================================================


struct  BFu7ll_BFu0c_BFu15i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7ll_BFu0c_BFu15i) C1{ FL:7 Fc:0 Fi:15}



static void Test_BFu7ll_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu15i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu7ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu15i, BFu7ll_BFu0c_BFu15i)
//============================================================================


struct  BFu7ll_BFu0c_BFu15ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7ll_BFu0c_BFu15ll) C1{ FL:7 Fc:0 FL:15}



static void Test_BFu7ll_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu7ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu15ll, BFu7ll_BFu0c_BFu15ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu15s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7ll_BFu0c_BFu15s) C1{ FL:7 Fc:0 Fs:15}



static void Test_BFu7ll_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu15s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu15s, BFu7ll_BFu0c_BFu15s)
//============================================================================


struct  BFu7ll_BFu0c_BFu16i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7ll_BFu0c_BFu16i) C1{ FL:7 Fc:0 Fi:16}



static void Test_BFu7ll_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu16i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu7ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu16i, BFu7ll_BFu0c_BFu16i)
//============================================================================


struct  BFu7ll_BFu0c_BFu16ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7ll_BFu0c_BFu16ll) C1{ FL:7 Fc:0 FL:16}



static void Test_BFu7ll_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu7ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu16ll, BFu7ll_BFu0c_BFu16ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu16s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7ll_BFu0c_BFu16s) C1{ FL:7 Fc:0 Fs:16}



static void Test_BFu7ll_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu16s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu16s, BFu7ll_BFu0c_BFu16s)
//============================================================================


struct  BFu7ll_BFu0c_BFu17i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7ll_BFu0c_BFu17i) C1{ FL:7 Fc:0 Fi:17}



static void Test_BFu7ll_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu17i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu7ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu17i, BFu7ll_BFu0c_BFu17i)
//============================================================================


struct  BFu7ll_BFu0c_BFu17ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7ll_BFu0c_BFu17ll) C1{ FL:7 Fc:0 FL:17}



static void Test_BFu7ll_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu7ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu17ll, BFu7ll_BFu0c_BFu17ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu1c  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7ll_BFu0c_BFu1c) C1{ FL:7 Fc:0 Fc:1}



static void Test_BFu7ll_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu1c");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7ll_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu1c, BFu7ll_BFu0c_BFu1c)
//============================================================================


struct  BFu7ll_BFu0c_BFu1i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7ll_BFu0c_BFu1i) C1{ FL:7 Fc:0 Fi:1}



static void Test_BFu7ll_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu1i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7ll_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu1i, BFu7ll_BFu0c_BFu1i)
//============================================================================


struct  BFu7ll_BFu0c_BFu1ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7ll_BFu0c_BFu1ll) C1{ FL:7 Fc:0 FL:1}



static void Test_BFu7ll_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7ll_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu1ll, BFu7ll_BFu0c_BFu1ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu1s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7ll_BFu0c_BFu1s) C1{ FL:7 Fc:0 Fs:1}



static void Test_BFu7ll_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu1s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu7ll_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu1s, BFu7ll_BFu0c_BFu1s)
//============================================================================


struct  BFu7ll_BFu0c_BFu31i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7ll_BFu0c_BFu31i) C1{ FL:7 Fc:0 Fi:31}



static void Test_BFu7ll_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu31i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu31i, BFu7ll_BFu0c_BFu31i)
//============================================================================


struct  BFu7ll_BFu0c_BFu31ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7ll_BFu0c_BFu31ll) C1{ FL:7 Fc:0 FL:31}



static void Test_BFu7ll_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu7ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu31ll, BFu7ll_BFu0c_BFu31ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu32i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7ll_BFu0c_BFu32i) C1{ FL:7 Fc:0 Fi:32}



static void Test_BFu7ll_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu32i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu32i, BFu7ll_BFu0c_BFu32i)
//============================================================================


struct  BFu7ll_BFu0c_BFu32ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7ll_BFu0c_BFu32ll) C1{ FL:7 Fc:0 FL:32}



static void Test_BFu7ll_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu7ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu32ll, BFu7ll_BFu0c_BFu32ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu33  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7ll_BFu0c_BFu33) C1{ FL:7 Fc:0 FL:33}



static void Test_BFu7ll_BFu0c_BFu33()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu33");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu7ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu7ll_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu33, BFu7ll_BFu0c_BFu33)
//============================================================================


struct  BFu7ll_BFu0c_BFu7c  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7ll_BFu0c_BFu7c) C1{ FL:7 Fc:0 Fc:7}



static void Test_BFu7ll_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu7c");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu7c, BFu7ll_BFu0c_BFu7c)
//============================================================================


struct  BFu7ll_BFu0c_BFu7i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7ll_BFu0c_BFu7i) C1{ FL:7 Fc:0 Fi:7}



static void Test_BFu7ll_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu7i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu7i, BFu7ll_BFu0c_BFu7i)
//============================================================================


struct  BFu7ll_BFu0c_BFu7ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7ll_BFu0c_BFu7ll) C1{ FL:7 Fc:0 FL:7}



static void Test_BFu7ll_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu7ll, BFu7ll_BFu0c_BFu7ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu7s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7ll_BFu0c_BFu7s) C1{ FL:7 Fc:0 Fs:7}



static void Test_BFu7ll_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu7s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu7s, BFu7ll_BFu0c_BFu7s)
//============================================================================


struct  BFu7ll_BFu0c_BFu8c  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7ll_BFu0c_BFu8c) C1{ FL:7 Fc:0 Fc:8}



static void Test_BFu7ll_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu8c");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu8c, BFu7ll_BFu0c_BFu8c)
//============================================================================


struct  BFu7ll_BFu0c_BFu8i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7ll_BFu0c_BFu8i) C1{ FL:7 Fc:0 Fi:8}



static void Test_BFu7ll_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu8i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu8i, BFu7ll_BFu0c_BFu8i)
//============================================================================


struct  BFu7ll_BFu0c_BFu8ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7ll_BFu0c_BFu8ll) C1{ FL:7 Fc:0 FL:8}



static void Test_BFu7ll_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu8ll, BFu7ll_BFu0c_BFu8ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu8s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7ll_BFu0c_BFu8s) C1{ FL:7 Fc:0 Fs:8}



static void Test_BFu7ll_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu8s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu8s, BFu7ll_BFu0c_BFu8s)
//============================================================================


struct  BFu7ll_BFu0c_BFu9i  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7ll_BFu0c_BFu9i) C1{ FL:7 Fc:0 Fi:9}



static void Test_BFu7ll_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu9i");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu7ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu9i, BFu7ll_BFu0c_BFu9i)
//============================================================================


struct  BFu7ll_BFu0c_BFu9ll  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7ll_BFu0c_BFu9ll) C1{ FL:7 Fc:0 FL:9}



static void Test_BFu7ll_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu7ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu9ll, BFu7ll_BFu0c_BFu9ll)
//============================================================================


struct  BFu7ll_BFu0c_BFu9s  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7ll_BFu0c_BFu9s) C1{ FL:7 Fc:0 Fs:9}



static void Test_BFu7ll_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu7ll_BFu0c_BFu9s");
    static STRUCT_IF_C BFu7ll_BFu0c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_BFu9s, BFu7ll_BFu0c_BFu9s)
//============================================================================


struct  BFu7ll_BFu0c_C  {
  __tsu64 v1:7;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu7ll_BFu0c_C) C1{ FL:7 Fc:0 Fc}



static void Test_BFu7ll_BFu0c_C()
{
  {
    init_simple_test("BFu7ll_BFu0c_C");
    static STRUCT_IF_C BFu7ll_BFu0c_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu7ll_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_C, BFu7ll_BFu0c_C)
//============================================================================


struct  BFu7ll_BFu0c_D  {
  __tsu64 v1:7;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu7ll_BFu0c_D) C1{ FL:7 Fc:0 FL}



static void Test_BFu7ll_BFu0c_D()
{
  {
    init_simple_test("BFu7ll_BFu0c_D");
    static STRUCT_IF_C BFu7ll_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_D, BFu7ll_BFu0c_D)
//============================================================================


struct  BFu7ll_BFu0c_F  {
  __tsu64 v1:7;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu7ll_BFu0c_F) C1{ FL:7 Fc:0 Fi}



static void Test_BFu7ll_BFu0c_F()
{
  {
    init_simple_test("BFu7ll_BFu0c_F");
    static STRUCT_IF_C BFu7ll_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_F, BFu7ll_BFu0c_F)
//============================================================================


struct  BFu7ll_BFu0c_I  {
  __tsu64 v1:7;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu7ll_BFu0c_I) C1{ FL:7 Fc:0 Fi}



static void Test_BFu7ll_BFu0c_I()
{
  {
    init_simple_test("BFu7ll_BFu0c_I");
    static STRUCT_IF_C BFu7ll_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_I, BFu7ll_BFu0c_I)
//============================================================================


struct  BFu7ll_BFu0c_Ip  {
  __tsu64 v1:7;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu7ll_BFu0c_Ip) C1{ FL:7 Fc:0 Fp}



static void Test_BFu7ll_BFu0c_Ip()
{
  {
    init_simple_test("BFu7ll_BFu0c_Ip");
    static STRUCT_IF_C BFu7ll_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_Ip, BFu7ll_BFu0c_Ip)
//============================================================================


struct  BFu7ll_BFu0c_L  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu7ll_BFu0c_L) C1{ FL:7 Fc:0 FL}



static void Test_BFu7ll_BFu0c_L()
{
  {
    init_simple_test("BFu7ll_BFu0c_L");
    static STRUCT_IF_C BFu7ll_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_L, BFu7ll_BFu0c_L)
//============================================================================


struct  BFu7ll_BFu0c_S  {
  __tsu64 v1:7;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu7ll_BFu0c_S) C1{ FL:7 Fc:0 Fs}



static void Test_BFu7ll_BFu0c_S()
{
  {
    init_simple_test("BFu7ll_BFu0c_S");
    static STRUCT_IF_C BFu7ll_BFu0c_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu7ll_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_S, BFu7ll_BFu0c_S)
//============================================================================


struct  BFu7ll_BFu0c_Uc  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu7ll_BFu0c_Uc) C1{ FL:7 Fc:0 Fc}



static void Test_BFu7ll_BFu0c_Uc()
{
  {
    init_simple_test("BFu7ll_BFu0c_Uc");
    static STRUCT_IF_C BFu7ll_BFu0c_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu7ll_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_Uc, BFu7ll_BFu0c_Uc)
//============================================================================


struct  BFu7ll_BFu0c_Ui  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu7ll_BFu0c_Ui) C1{ FL:7 Fc:0 Fi}



static void Test_BFu7ll_BFu0c_Ui()
{
  {
    init_simple_test("BFu7ll_BFu0c_Ui");
    static STRUCT_IF_C BFu7ll_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_Ui, BFu7ll_BFu0c_Ui)
//============================================================================


struct  BFu7ll_BFu0c_Ul  {
  __tsu64 v1:7;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu7ll_BFu0c_Ul) C1{ FL:7 Fc:0 FL}



static void Test_BFu7ll_BFu0c_Ul()
{
  {
    init_simple_test("BFu7ll_BFu0c_Ul");
    static STRUCT_IF_C BFu7ll_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_Ul, BFu7ll_BFu0c_Ul)
//============================================================================


struct  BFu7ll_BFu0c_Us  {
  __tsu64 v1:7;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu7ll_BFu0c_Us) C1{ FL:7 Fc:0 Fs}



static void Test_BFu7ll_BFu0c_Us()
{
  {
    init_simple_test("BFu7ll_BFu0c_Us");
    static STRUCT_IF_C BFu7ll_BFu0c_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu7ll_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_Us, BFu7ll_BFu0c_Us)
//============================================================================


struct  BFu7ll_BFu0c_Vp  {
  __tsu64 v1:7;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu7ll_BFu0c_Vp) C1{ FL:7 Fc:0 Fp}



static void Test_BFu7ll_BFu0c_Vp()
{
  {
    init_simple_test("BFu7ll_BFu0c_Vp");
    static STRUCT_IF_C BFu7ll_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0c_Vp, BFu7ll_BFu0c_Vp)
//============================================================================


struct  BFu7ll_BFu0i  {
  __tsu64 v1:7;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu0i) C1{ FL:7 Fi:0}



static void Test_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i, BFu7ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu0i_BFu0c  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu0i_BFu0c) C1{ FL:7 Fi:0 Fc:0}



static void Test_BFu7ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu0c, BFu7ll_BFu0i_BFu0c)
//============================================================================


struct  BFu7ll_BFu0i_BFu0i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu0i_BFu0i) C1{ FL:7 Fi:0 Fi:0}



static void Test_BFu7ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu0i, BFu7ll_BFu0i_BFu0i)
//============================================================================


struct  BFu7ll_BFu0i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu0i_BFu0ll) C1{ FL:7 Fi:0 FL:0}



static void Test_BFu7ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu0ll, BFu7ll_BFu0i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu0s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu0i_BFu0s) C1{ FL:7 Fi:0 Fs:0}



static void Test_BFu7ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu0s, BFu7ll_BFu0i_BFu0s)
//============================================================================


struct  BFu7ll_BFu0i_BFu15i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7ll_BFu0i_BFu15i) C1{ FL:7 Fi:0 Fi:15}



static void Test_BFu7ll_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu15i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu15i, BFu7ll_BFu0i_BFu15i)
//============================================================================


struct  BFu7ll_BFu0i_BFu15ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7ll_BFu0i_BFu15ll) C1{ FL:7 Fi:0 FL:15}



static void Test_BFu7ll_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu15ll, BFu7ll_BFu0i_BFu15ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu15s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7ll_BFu0i_BFu15s) C1{ FL:7 Fi:0 Fs:15}



static void Test_BFu7ll_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu15s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu7ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu15s, BFu7ll_BFu0i_BFu15s)
//============================================================================


struct  BFu7ll_BFu0i_BFu16i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7ll_BFu0i_BFu16i) C1{ FL:7 Fi:0 Fi:16}



static void Test_BFu7ll_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu16i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu16i, BFu7ll_BFu0i_BFu16i)
//============================================================================


struct  BFu7ll_BFu0i_BFu16ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7ll_BFu0i_BFu16ll) C1{ FL:7 Fi:0 FL:16}



static void Test_BFu7ll_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu16ll, BFu7ll_BFu0i_BFu16ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu16s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7ll_BFu0i_BFu16s) C1{ FL:7 Fi:0 Fs:16}



static void Test_BFu7ll_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu16s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu7ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu16s, BFu7ll_BFu0i_BFu16s)
//============================================================================


struct  BFu7ll_BFu0i_BFu17i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7ll_BFu0i_BFu17i) C1{ FL:7 Fi:0 Fi:17}



static void Test_BFu7ll_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu17i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu17i, BFu7ll_BFu0i_BFu17i)
//============================================================================


struct  BFu7ll_BFu0i_BFu17ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7ll_BFu0i_BFu17ll) C1{ FL:7 Fi:0 FL:17}



static void Test_BFu7ll_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu17ll, BFu7ll_BFu0i_BFu17ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu1c  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7ll_BFu0i_BFu1c) C1{ FL:7 Fi:0 Fc:1}



static void Test_BFu7ll_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu1c");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7ll_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu1c, BFu7ll_BFu0i_BFu1c)
//============================================================================


struct  BFu7ll_BFu0i_BFu1i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7ll_BFu0i_BFu1i) C1{ FL:7 Fi:0 Fi:1}



static void Test_BFu7ll_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu1i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7ll_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu1i, BFu7ll_BFu0i_BFu1i)
//============================================================================


struct  BFu7ll_BFu0i_BFu1ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7ll_BFu0i_BFu1ll) C1{ FL:7 Fi:0 FL:1}



static void Test_BFu7ll_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7ll_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu1ll, BFu7ll_BFu0i_BFu1ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu1s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7ll_BFu0i_BFu1s) C1{ FL:7 Fi:0 Fs:1}



static void Test_BFu7ll_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu1s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu7ll_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu1s, BFu7ll_BFu0i_BFu1s)
//============================================================================


struct  BFu7ll_BFu0i_BFu31i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7ll_BFu0i_BFu31i) C1{ FL:7 Fi:0 Fi:31}



static void Test_BFu7ll_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu31i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu31i, BFu7ll_BFu0i_BFu31i)
//============================================================================


struct  BFu7ll_BFu0i_BFu31ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7ll_BFu0i_BFu31ll) C1{ FL:7 Fi:0 FL:31}



static void Test_BFu7ll_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu31ll, BFu7ll_BFu0i_BFu31ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu32i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7ll_BFu0i_BFu32i) C1{ FL:7 Fi:0 Fi:32}



static void Test_BFu7ll_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu32i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu32i, BFu7ll_BFu0i_BFu32i)
//============================================================================


struct  BFu7ll_BFu0i_BFu32ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7ll_BFu0i_BFu32ll) C1{ FL:7 Fi:0 FL:32}



static void Test_BFu7ll_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu32ll, BFu7ll_BFu0i_BFu32ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu33  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7ll_BFu0i_BFu33) C1{ FL:7 Fi:0 FL:33}



static void Test_BFu7ll_BFu0i_BFu33()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu33");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu7ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu7ll_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu33, BFu7ll_BFu0i_BFu33)
//============================================================================


struct  BFu7ll_BFu0i_BFu7c  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7ll_BFu0i_BFu7c) C1{ FL:7 Fi:0 Fc:7}



static void Test_BFu7ll_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu7c");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu7c, BFu7ll_BFu0i_BFu7c)
//============================================================================


struct  BFu7ll_BFu0i_BFu7i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7ll_BFu0i_BFu7i) C1{ FL:7 Fi:0 Fi:7}



static void Test_BFu7ll_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu7i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu7i, BFu7ll_BFu0i_BFu7i)
//============================================================================


struct  BFu7ll_BFu0i_BFu7ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7ll_BFu0i_BFu7ll) C1{ FL:7 Fi:0 FL:7}



static void Test_BFu7ll_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu7ll, BFu7ll_BFu0i_BFu7ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu7s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7ll_BFu0i_BFu7s) C1{ FL:7 Fi:0 Fs:7}



static void Test_BFu7ll_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu7s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu7ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu7s, BFu7ll_BFu0i_BFu7s)
//============================================================================


struct  BFu7ll_BFu0i_BFu8c  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7ll_BFu0i_BFu8c) C1{ FL:7 Fi:0 Fc:8}



static void Test_BFu7ll_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu8c");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu8c, BFu7ll_BFu0i_BFu8c)
//============================================================================


struct  BFu7ll_BFu0i_BFu8i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7ll_BFu0i_BFu8i) C1{ FL:7 Fi:0 Fi:8}



static void Test_BFu7ll_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu8i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu8i, BFu7ll_BFu0i_BFu8i)
//============================================================================


struct  BFu7ll_BFu0i_BFu8ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7ll_BFu0i_BFu8ll) C1{ FL:7 Fi:0 FL:8}



static void Test_BFu7ll_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu8ll, BFu7ll_BFu0i_BFu8ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu8s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7ll_BFu0i_BFu8s) C1{ FL:7 Fi:0 Fs:8}



static void Test_BFu7ll_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu8s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu7ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu8s, BFu7ll_BFu0i_BFu8s)
//============================================================================


struct  BFu7ll_BFu0i_BFu9i  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7ll_BFu0i_BFu9i) C1{ FL:7 Fi:0 Fi:9}



static void Test_BFu7ll_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu9i");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu9i, BFu7ll_BFu0i_BFu9i)
//============================================================================


struct  BFu7ll_BFu0i_BFu9ll  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7ll_BFu0i_BFu9ll) C1{ FL:7 Fi:0 FL:9}



static void Test_BFu7ll_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu9ll, BFu7ll_BFu0i_BFu9ll)
//============================================================================


struct  BFu7ll_BFu0i_BFu9s  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7ll_BFu0i_BFu9s) C1{ FL:7 Fi:0 Fs:9}



static void Test_BFu7ll_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu7ll_BFu0i_BFu9s");
    static STRUCT_IF_C BFu7ll_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu7ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_BFu9s, BFu7ll_BFu0i_BFu9s)
//============================================================================


struct  BFu7ll_BFu0i_C  {
  __tsu64 v1:7;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu7ll_BFu0i_C) C1{ FL:7 Fi:0 Fc}



static void Test_BFu7ll_BFu0i_C()
{
  {
    init_simple_test("BFu7ll_BFu0i_C");
    static STRUCT_IF_C BFu7ll_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_C, BFu7ll_BFu0i_C)
//============================================================================


struct  BFu7ll_BFu0i_D  {
  __tsu64 v1:7;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu7ll_BFu0i_D) C1{ FL:7 Fi:0 FL}



static void Test_BFu7ll_BFu0i_D()
{
  {
    init_simple_test("BFu7ll_BFu0i_D");
    static STRUCT_IF_C BFu7ll_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_D, BFu7ll_BFu0i_D)
//============================================================================


struct  BFu7ll_BFu0i_F  {
  __tsu64 v1:7;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu7ll_BFu0i_F) C1{ FL:7 Fi:0 Fi}



static void Test_BFu7ll_BFu0i_F()
{
  {
    init_simple_test("BFu7ll_BFu0i_F");
    static STRUCT_IF_C BFu7ll_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_F, BFu7ll_BFu0i_F)
//============================================================================


struct  BFu7ll_BFu0i_I  {
  __tsu64 v1:7;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu7ll_BFu0i_I) C1{ FL:7 Fi:0 Fi}



static void Test_BFu7ll_BFu0i_I()
{
  {
    init_simple_test("BFu7ll_BFu0i_I");
    static STRUCT_IF_C BFu7ll_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_I, BFu7ll_BFu0i_I)
//============================================================================


struct  BFu7ll_BFu0i_Ip  {
  __tsu64 v1:7;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu7ll_BFu0i_Ip) C1{ FL:7 Fi:0 Fp}



static void Test_BFu7ll_BFu0i_Ip()
{
  {
    init_simple_test("BFu7ll_BFu0i_Ip");
    static STRUCT_IF_C BFu7ll_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_Ip, BFu7ll_BFu0i_Ip)
//============================================================================


struct  BFu7ll_BFu0i_L  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu7ll_BFu0i_L) C1{ FL:7 Fi:0 FL}



static void Test_BFu7ll_BFu0i_L()
{
  {
    init_simple_test("BFu7ll_BFu0i_L");
    static STRUCT_IF_C BFu7ll_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_L, BFu7ll_BFu0i_L)
//============================================================================


struct  BFu7ll_BFu0i_S  {
  __tsu64 v1:7;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu7ll_BFu0i_S) C1{ FL:7 Fi:0 Fs}



static void Test_BFu7ll_BFu0i_S()
{
  {
    init_simple_test("BFu7ll_BFu0i_S");
    static STRUCT_IF_C BFu7ll_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_S, BFu7ll_BFu0i_S)
//============================================================================


struct  BFu7ll_BFu0i_Uc  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu7ll_BFu0i_Uc) C1{ FL:7 Fi:0 Fc}



static void Test_BFu7ll_BFu0i_Uc()
{
  {
    init_simple_test("BFu7ll_BFu0i_Uc");
    static STRUCT_IF_C BFu7ll_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_Uc, BFu7ll_BFu0i_Uc)
//============================================================================


struct  BFu7ll_BFu0i_Ui  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu7ll_BFu0i_Ui) C1{ FL:7 Fi:0 Fi}



static void Test_BFu7ll_BFu0i_Ui()
{
  {
    init_simple_test("BFu7ll_BFu0i_Ui");
    static STRUCT_IF_C BFu7ll_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_Ui, BFu7ll_BFu0i_Ui)
//============================================================================


struct  BFu7ll_BFu0i_Ul  {
  __tsu64 v1:7;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu7ll_BFu0i_Ul) C1{ FL:7 Fi:0 FL}



static void Test_BFu7ll_BFu0i_Ul()
{
  {
    init_simple_test("BFu7ll_BFu0i_Ul");
    static STRUCT_IF_C BFu7ll_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_Ul, BFu7ll_BFu0i_Ul)
//============================================================================


struct  BFu7ll_BFu0i_Us  {
  __tsu64 v1:7;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu7ll_BFu0i_Us) C1{ FL:7 Fi:0 Fs}



static void Test_BFu7ll_BFu0i_Us()
{
  {
    init_simple_test("BFu7ll_BFu0i_Us");
    static STRUCT_IF_C BFu7ll_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_Us, BFu7ll_BFu0i_Us)
//============================================================================


struct  BFu7ll_BFu0i_Vp  {
  __tsu64 v1:7;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu7ll_BFu0i_Vp) C1{ FL:7 Fi:0 Fp}



static void Test_BFu7ll_BFu0i_Vp()
{
  {
    init_simple_test("BFu7ll_BFu0i_Vp");
    static STRUCT_IF_C BFu7ll_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0i_Vp, BFu7ll_BFu0i_Vp)
//============================================================================


struct  BFu7ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu0ll) C1{ FL:7 FL:0}



static void Test_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll, BFu7ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu0ll_BFu0c) C1{ FL:7 FL:0 Fc:0}



static void Test_BFu7ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu0c, BFu7ll_BFu0ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu0ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu0ll_BFu0i) C1{ FL:7 FL:0 Fi:0}



static void Test_BFu7ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu0i, BFu7ll_BFu0ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu0ll_BFu0ll) C1{ FL:7 FL:0 FL:0}



static void Test_BFu7ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu0ll, BFu7ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu0ll_BFu0s) C1{ FL:7 FL:0 Fs:0}



static void Test_BFu7ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu0s, BFu7ll_BFu0ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu0ll_BFu15i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7ll_BFu0ll_BFu15i) C1{ FL:7 FL:0 Fi:15}



static void Test_BFu7ll_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu15i, BFu7ll_BFu0ll_BFu15i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu15ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7ll_BFu0ll_BFu15ll) C1{ FL:7 FL:0 FL:15}



static void Test_BFu7ll_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu15ll, BFu7ll_BFu0ll_BFu15ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu15s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7ll_BFu0ll_BFu15s) C1{ FL:7 FL:0 Fs:15}



static void Test_BFu7ll_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu7ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu15s, BFu7ll_BFu0ll_BFu15s)
//============================================================================


struct  BFu7ll_BFu0ll_BFu16i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7ll_BFu0ll_BFu16i) C1{ FL:7 FL:0 Fi:16}



static void Test_BFu7ll_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu16i, BFu7ll_BFu0ll_BFu16i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu16ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7ll_BFu0ll_BFu16ll) C1{ FL:7 FL:0 FL:16}



static void Test_BFu7ll_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu16ll, BFu7ll_BFu0ll_BFu16ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu16s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7ll_BFu0ll_BFu16s) C1{ FL:7 FL:0 Fs:16}



static void Test_BFu7ll_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu7ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu16s, BFu7ll_BFu0ll_BFu16s)
//============================================================================


struct  BFu7ll_BFu0ll_BFu17i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7ll_BFu0ll_BFu17i) C1{ FL:7 FL:0 Fi:17}



static void Test_BFu7ll_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu7ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu17i, BFu7ll_BFu0ll_BFu17i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu17ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7ll_BFu0ll_BFu17ll) C1{ FL:7 FL:0 FL:17}



static void Test_BFu7ll_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu7ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu17ll, BFu7ll_BFu0ll_BFu17ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu1c  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7ll_BFu0ll_BFu1c) C1{ FL:7 FL:0 Fc:1}



static void Test_BFu7ll_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7ll_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu1c, BFu7ll_BFu0ll_BFu1c)
//============================================================================


struct  BFu7ll_BFu0ll_BFu1i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7ll_BFu0ll_BFu1i) C1{ FL:7 FL:0 Fi:1}



static void Test_BFu7ll_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7ll_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu1i, BFu7ll_BFu0ll_BFu1i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu1ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7ll_BFu0ll_BFu1ll) C1{ FL:7 FL:0 FL:1}



static void Test_BFu7ll_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7ll_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu1ll, BFu7ll_BFu0ll_BFu1ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu1s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7ll_BFu0ll_BFu1s) C1{ FL:7 FL:0 Fs:1}



static void Test_BFu7ll_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu7ll_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu1s, BFu7ll_BFu0ll_BFu1s)
//============================================================================


struct  BFu7ll_BFu0ll_BFu31i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7ll_BFu0ll_BFu31i) C1{ FL:7 FL:0 Fi:31}



static void Test_BFu7ll_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu7ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu31i, BFu7ll_BFu0ll_BFu31i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu31ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7ll_BFu0ll_BFu31ll) C1{ FL:7 FL:0 FL:31}



static void Test_BFu7ll_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu7ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu31ll, BFu7ll_BFu0ll_BFu31ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu32i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7ll_BFu0ll_BFu32i) C1{ FL:7 FL:0 Fi:32}



static void Test_BFu7ll_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu7ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu32i, BFu7ll_BFu0ll_BFu32i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu32ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7ll_BFu0ll_BFu32ll) C1{ FL:7 FL:0 FL:32}



static void Test_BFu7ll_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu7ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu32ll, BFu7ll_BFu0ll_BFu32ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu33  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7ll_BFu0ll_BFu33) C1{ FL:7 FL:0 FL:33}



static void Test_BFu7ll_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu33");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu7ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu7ll_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu33, BFu7ll_BFu0ll_BFu33)
//============================================================================


struct  BFu7ll_BFu0ll_BFu7c  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7ll_BFu0ll_BFu7c) C1{ FL:7 FL:0 Fc:7}



static void Test_BFu7ll_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu7c, BFu7ll_BFu0ll_BFu7c)
//============================================================================


struct  BFu7ll_BFu0ll_BFu7i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7ll_BFu0ll_BFu7i) C1{ FL:7 FL:0 Fi:7}



static void Test_BFu7ll_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu7i, BFu7ll_BFu0ll_BFu7i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu7ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7ll_BFu0ll_BFu7ll) C1{ FL:7 FL:0 FL:7}



static void Test_BFu7ll_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu7ll, BFu7ll_BFu0ll_BFu7ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu7s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7ll_BFu0ll_BFu7s) C1{ FL:7 FL:0 Fs:7}



static void Test_BFu7ll_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu7ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu7s, BFu7ll_BFu0ll_BFu7s)
//============================================================================


struct  BFu7ll_BFu0ll_BFu8c  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7ll_BFu0ll_BFu8c) C1{ FL:7 FL:0 Fc:8}



static void Test_BFu7ll_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu8c, BFu7ll_BFu0ll_BFu8c)
//============================================================================


struct  BFu7ll_BFu0ll_BFu8i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7ll_BFu0ll_BFu8i) C1{ FL:7 FL:0 Fi:8}



static void Test_BFu7ll_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu8i, BFu7ll_BFu0ll_BFu8i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu8ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7ll_BFu0ll_BFu8ll) C1{ FL:7 FL:0 FL:8}



static void Test_BFu7ll_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu8ll, BFu7ll_BFu0ll_BFu8ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu8s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7ll_BFu0ll_BFu8s) C1{ FL:7 FL:0 Fs:8}



static void Test_BFu7ll_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu7ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu8s, BFu7ll_BFu0ll_BFu8s)
//============================================================================


struct  BFu7ll_BFu0ll_BFu9i  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7ll_BFu0ll_BFu9i) C1{ FL:7 FL:0 Fi:9}



static void Test_BFu7ll_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu9i, BFu7ll_BFu0ll_BFu9i)
//============================================================================


struct  BFu7ll_BFu0ll_BFu9ll  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7ll_BFu0ll_BFu9ll) C1{ FL:7 FL:0 FL:9}



static void Test_BFu7ll_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu9ll, BFu7ll_BFu0ll_BFu9ll)
//============================================================================


struct  BFu7ll_BFu0ll_BFu9s  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7ll_BFu0ll_BFu9s) C1{ FL:7 FL:0 Fs:9}



static void Test_BFu7ll_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu7ll_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu7ll_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu7ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_BFu9s, BFu7ll_BFu0ll_BFu9s)
//============================================================================


struct  BFu7ll_BFu0ll_C  {
  __tsu64 v1:7;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu7ll_BFu0ll_C) C1{ FL:7 FL:0 Fc}



static void Test_BFu7ll_BFu0ll_C()
{
  {
    init_simple_test("BFu7ll_BFu0ll_C");
    static STRUCT_IF_C BFu7ll_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_C, BFu7ll_BFu0ll_C)
//============================================================================


struct  BFu7ll_BFu0ll_D  {
  __tsu64 v1:7;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu7ll_BFu0ll_D) C1{ FL:7 FL:0 FL}



static void Test_BFu7ll_BFu0ll_D()
{
  {
    init_simple_test("BFu7ll_BFu0ll_D");
    static STRUCT_IF_C BFu7ll_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_D, BFu7ll_BFu0ll_D)
//============================================================================


struct  BFu7ll_BFu0ll_F  {
  __tsu64 v1:7;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu7ll_BFu0ll_F) C1{ FL:7 FL:0 Fi}



static void Test_BFu7ll_BFu0ll_F()
{
  {
    init_simple_test("BFu7ll_BFu0ll_F");
    static STRUCT_IF_C BFu7ll_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_F, BFu7ll_BFu0ll_F)
//============================================================================


struct  BFu7ll_BFu0ll_I  {
  __tsu64 v1:7;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu7ll_BFu0ll_I) C1{ FL:7 FL:0 Fi}



static void Test_BFu7ll_BFu0ll_I()
{
  {
    init_simple_test("BFu7ll_BFu0ll_I");
    static STRUCT_IF_C BFu7ll_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_I, BFu7ll_BFu0ll_I)
//============================================================================


struct  BFu7ll_BFu0ll_Ip  {
  __tsu64 v1:7;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu7ll_BFu0ll_Ip) C1{ FL:7 FL:0 Fp}



static void Test_BFu7ll_BFu0ll_Ip()
{
  {
    init_simple_test("BFu7ll_BFu0ll_Ip");
    static STRUCT_IF_C BFu7ll_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_Ip, BFu7ll_BFu0ll_Ip)
//============================================================================


struct  BFu7ll_BFu0ll_L  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu7ll_BFu0ll_L) C1{ FL:7 FL:0 FL}



static void Test_BFu7ll_BFu0ll_L()
{
  {
    init_simple_test("BFu7ll_BFu0ll_L");
    static STRUCT_IF_C BFu7ll_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_L, BFu7ll_BFu0ll_L)
//============================================================================


struct  BFu7ll_BFu0ll_S  {
  __tsu64 v1:7;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu7ll_BFu0ll_S) C1{ FL:7 FL:0 Fs}



static void Test_BFu7ll_BFu0ll_S()
{
  {
    init_simple_test("BFu7ll_BFu0ll_S");
    static STRUCT_IF_C BFu7ll_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_S, BFu7ll_BFu0ll_S)
//============================================================================


struct  BFu7ll_BFu0ll_Uc  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu7ll_BFu0ll_Uc) C1{ FL:7 FL:0 Fc}



static void Test_BFu7ll_BFu0ll_Uc()
{
  {
    init_simple_test("BFu7ll_BFu0ll_Uc");
    static STRUCT_IF_C BFu7ll_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_Uc, BFu7ll_BFu0ll_Uc)
//============================================================================


struct  BFu7ll_BFu0ll_Ui  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu7ll_BFu0ll_Ui) C1{ FL:7 FL:0 Fi}



static void Test_BFu7ll_BFu0ll_Ui()
{
  {
    init_simple_test("BFu7ll_BFu0ll_Ui");
    static STRUCT_IF_C BFu7ll_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_Ui, BFu7ll_BFu0ll_Ui)
//============================================================================


struct  BFu7ll_BFu0ll_Ul  {
  __tsu64 v1:7;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu7ll_BFu0ll_Ul) C1{ FL:7 FL:0 FL}



static void Test_BFu7ll_BFu0ll_Ul()
{
  {
    init_simple_test("BFu7ll_BFu0ll_Ul");
    static STRUCT_IF_C BFu7ll_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_Ul, BFu7ll_BFu0ll_Ul)
//============================================================================


struct  BFu7ll_BFu0ll_Us  {
  __tsu64 v1:7;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu7ll_BFu0ll_Us) C1{ FL:7 FL:0 Fs}



static void Test_BFu7ll_BFu0ll_Us()
{
  {
    init_simple_test("BFu7ll_BFu0ll_Us");
    static STRUCT_IF_C BFu7ll_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_Us, BFu7ll_BFu0ll_Us)
//============================================================================


struct  BFu7ll_BFu0ll_Vp  {
  __tsu64 v1:7;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu7ll_BFu0ll_Vp) C1{ FL:7 FL:0 Fp}



static void Test_BFu7ll_BFu0ll_Vp()
{
  {
    init_simple_test("BFu7ll_BFu0ll_Vp");
    static STRUCT_IF_C BFu7ll_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0ll_Vp, BFu7ll_BFu0ll_Vp)
//============================================================================


struct  BFu7ll_BFu0s  {
  __tsu64 v1:7;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu0s) C1{ FL:7 Fs:0}



static void Test_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s, BFu7ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu0s_BFu0c  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu0s_BFu0c) C1{ FL:7 Fs:0 Fc:0}



static void Test_BFu7ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu0c, BFu7ll_BFu0s_BFu0c)
//============================================================================


struct  BFu7ll_BFu0s_BFu0i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu0s_BFu0i) C1{ FL:7 Fs:0 Fi:0}



static void Test_BFu7ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu0i, BFu7ll_BFu0s_BFu0i)
//============================================================================


struct  BFu7ll_BFu0s_BFu0ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu0s_BFu0ll) C1{ FL:7 Fs:0 FL:0}



static void Test_BFu7ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu0ll, BFu7ll_BFu0s_BFu0ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu0s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu0s_BFu0s) C1{ FL:7 Fs:0 Fs:0}



static void Test_BFu7ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu0s, BFu7ll_BFu0s_BFu0s)
//============================================================================


struct  BFu7ll_BFu0s_BFu15i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu7ll_BFu0s_BFu15i) C1{ FL:7 Fs:0 Fi:15}



static void Test_BFu7ll_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu15i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu15i, BFu7ll_BFu0s_BFu15i)
//============================================================================


struct  BFu7ll_BFu0s_BFu15ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu7ll_BFu0s_BFu15ll) C1{ FL:7 Fs:0 FL:15}



static void Test_BFu7ll_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu15ll, BFu7ll_BFu0s_BFu15ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu15s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu7ll_BFu0s_BFu15s) C1{ FL:7 Fs:0 Fs:15}



static void Test_BFu7ll_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu15s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu15s, BFu7ll_BFu0s_BFu15s)
//============================================================================


struct  BFu7ll_BFu0s_BFu16i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu7ll_BFu0s_BFu16i) C1{ FL:7 Fs:0 Fi:16}



static void Test_BFu7ll_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu16i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu16i, BFu7ll_BFu0s_BFu16i)
//============================================================================


struct  BFu7ll_BFu0s_BFu16ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu7ll_BFu0s_BFu16ll) C1{ FL:7 Fs:0 FL:16}



static void Test_BFu7ll_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu16ll, BFu7ll_BFu0s_BFu16ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu16s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu7ll_BFu0s_BFu16s) C1{ FL:7 Fs:0 Fs:16}



static void Test_BFu7ll_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu16s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu16s, BFu7ll_BFu0s_BFu16s)
//============================================================================


struct  BFu7ll_BFu0s_BFu17i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu7ll_BFu0s_BFu17i) C1{ FL:7 Fs:0 Fi:17}



static void Test_BFu7ll_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu17i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu7ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu17i, BFu7ll_BFu0s_BFu17i)
//============================================================================


struct  BFu7ll_BFu0s_BFu17ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu7ll_BFu0s_BFu17ll) C1{ FL:7 Fs:0 FL:17}



static void Test_BFu7ll_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu7ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu7ll_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu17ll, BFu7ll_BFu0s_BFu17ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu1c  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu7ll_BFu0s_BFu1c) C1{ FL:7 Fs:0 Fc:1}



static void Test_BFu7ll_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu1c");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7ll_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu1c, BFu7ll_BFu0s_BFu1c)
//============================================================================


struct  BFu7ll_BFu0s_BFu1i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu7ll_BFu0s_BFu1i) C1{ FL:7 Fs:0 Fi:1}



static void Test_BFu7ll_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu1i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7ll_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu1i, BFu7ll_BFu0s_BFu1i)
//============================================================================


struct  BFu7ll_BFu0s_BFu1ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu7ll_BFu0s_BFu1ll) C1{ FL:7 Fs:0 FL:1}



static void Test_BFu7ll_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7ll_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu1ll, BFu7ll_BFu0s_BFu1ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu1s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu7ll_BFu0s_BFu1s) C1{ FL:7 Fs:0 Fs:1}



static void Test_BFu7ll_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu1s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu7ll_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu1s, BFu7ll_BFu0s_BFu1s)
//============================================================================


struct  BFu7ll_BFu0s_BFu31i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu7ll_BFu0s_BFu31i) C1{ FL:7 Fs:0 Fi:31}



static void Test_BFu7ll_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu31i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu31i, BFu7ll_BFu0s_BFu31i)
//============================================================================


struct  BFu7ll_BFu0s_BFu31ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu7ll_BFu0s_BFu31ll) C1{ FL:7 Fs:0 FL:31}



static void Test_BFu7ll_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu7ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu31ll, BFu7ll_BFu0s_BFu31ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu32i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu7ll_BFu0s_BFu32i) C1{ FL:7 Fs:0 Fi:32}



static void Test_BFu7ll_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu32i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu32i, BFu7ll_BFu0s_BFu32i)
//============================================================================


struct  BFu7ll_BFu0s_BFu32ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu7ll_BFu0s_BFu32ll) C1{ FL:7 Fs:0 FL:32}



static void Test_BFu7ll_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu7ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu32ll, BFu7ll_BFu0s_BFu32ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu33  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu7ll_BFu0s_BFu33) C1{ FL:7 Fs:0 FL:33}



static void Test_BFu7ll_BFu0s_BFu33()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu33");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu7ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu7ll_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu33, BFu7ll_BFu0s_BFu33)
//============================================================================


struct  BFu7ll_BFu0s_BFu7c  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu7ll_BFu0s_BFu7c) C1{ FL:7 Fs:0 Fc:7}



static void Test_BFu7ll_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu7c");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu7c, BFu7ll_BFu0s_BFu7c)
//============================================================================


struct  BFu7ll_BFu0s_BFu7i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu7ll_BFu0s_BFu7i) C1{ FL:7 Fs:0 Fi:7}



static void Test_BFu7ll_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu7i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu7i, BFu7ll_BFu0s_BFu7i)
//============================================================================


struct  BFu7ll_BFu0s_BFu7ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu7ll_BFu0s_BFu7ll) C1{ FL:7 Fs:0 FL:7}



static void Test_BFu7ll_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu7ll, BFu7ll_BFu0s_BFu7ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu7s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu7ll_BFu0s_BFu7s) C1{ FL:7 Fs:0 Fs:7}



static void Test_BFu7ll_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu7s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu7ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu7s, BFu7ll_BFu0s_BFu7s)
//============================================================================


struct  BFu7ll_BFu0s_BFu8c  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu7ll_BFu0s_BFu8c) C1{ FL:7 Fs:0 Fc:8}



static void Test_BFu7ll_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu8c");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu8c, BFu7ll_BFu0s_BFu8c)
//============================================================================


struct  BFu7ll_BFu0s_BFu8i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu7ll_BFu0s_BFu8i) C1{ FL:7 Fs:0 Fi:8}



static void Test_BFu7ll_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu8i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu8i, BFu7ll_BFu0s_BFu8i)
//============================================================================


struct  BFu7ll_BFu0s_BFu8ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu7ll_BFu0s_BFu8ll) C1{ FL:7 Fs:0 FL:8}



static void Test_BFu7ll_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu8ll, BFu7ll_BFu0s_BFu8ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu8s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu7ll_BFu0s_BFu8s) C1{ FL:7 Fs:0 Fs:8}



static void Test_BFu7ll_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu8s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu7ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu8s, BFu7ll_BFu0s_BFu8s)
//============================================================================


struct  BFu7ll_BFu0s_BFu9i  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu7ll_BFu0s_BFu9i) C1{ FL:7 Fs:0 Fi:9}



static void Test_BFu7ll_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu9i");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu9i, BFu7ll_BFu0s_BFu9i)
//============================================================================


struct  BFu7ll_BFu0s_BFu9ll  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu7ll_BFu0s_BFu9ll) C1{ FL:7 Fs:0 FL:9}



static void Test_BFu7ll_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu9ll, BFu7ll_BFu0s_BFu9ll)
//============================================================================


struct  BFu7ll_BFu0s_BFu9s  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu7ll_BFu0s_BFu9s) C1{ FL:7 Fs:0 Fs:9}



static void Test_BFu7ll_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu7ll_BFu0s_BFu9s");
    static STRUCT_IF_C BFu7ll_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu7ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_BFu9s, BFu7ll_BFu0s_BFu9s)
//============================================================================


struct  BFu7ll_BFu0s_C  {
  __tsu64 v1:7;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu7ll_BFu0s_C) C1{ FL:7 Fs:0 Fc}



static void Test_BFu7ll_BFu0s_C()
{
  {
    init_simple_test("BFu7ll_BFu0s_C");
    static STRUCT_IF_C BFu7ll_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu7ll_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_C, BFu7ll_BFu0s_C)
//============================================================================


struct  BFu7ll_BFu0s_D  {
  __tsu64 v1:7;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu7ll_BFu0s_D) C1{ FL:7 Fs:0 FL}



static void Test_BFu7ll_BFu0s_D()
{
  {
    init_simple_test("BFu7ll_BFu0s_D");
    static STRUCT_IF_C BFu7ll_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_D, BFu7ll_BFu0s_D)
//============================================================================


struct  BFu7ll_BFu0s_F  {
  __tsu64 v1:7;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu7ll_BFu0s_F) C1{ FL:7 Fs:0 Fi}



static void Test_BFu7ll_BFu0s_F()
{
  {
    init_simple_test("BFu7ll_BFu0s_F");
    static STRUCT_IF_C BFu7ll_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_F, BFu7ll_BFu0s_F)
//============================================================================


struct  BFu7ll_BFu0s_I  {
  __tsu64 v1:7;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu7ll_BFu0s_I) C1{ FL:7 Fs:0 Fi}



static void Test_BFu7ll_BFu0s_I()
{
  {
    init_simple_test("BFu7ll_BFu0s_I");
    static STRUCT_IF_C BFu7ll_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_I, BFu7ll_BFu0s_I)
//============================================================================


struct  BFu7ll_BFu0s_Ip  {
  __tsu64 v1:7;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu7ll_BFu0s_Ip) C1{ FL:7 Fs:0 Fp}



static void Test_BFu7ll_BFu0s_Ip()
{
  {
    init_simple_test("BFu7ll_BFu0s_Ip");
    static STRUCT_IF_C BFu7ll_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_Ip, BFu7ll_BFu0s_Ip)
//============================================================================


struct  BFu7ll_BFu0s_L  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu7ll_BFu0s_L) C1{ FL:7 Fs:0 FL}



static void Test_BFu7ll_BFu0s_L()
{
  {
    init_simple_test("BFu7ll_BFu0s_L");
    static STRUCT_IF_C BFu7ll_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_L, BFu7ll_BFu0s_L)
//============================================================================


struct  BFu7ll_BFu0s_S  {
  __tsu64 v1:7;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu7ll_BFu0s_S) C1{ FL:7 Fs:0 Fs}



static void Test_BFu7ll_BFu0s_S()
{
  {
    init_simple_test("BFu7ll_BFu0s_S");
    static STRUCT_IF_C BFu7ll_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu7ll_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_S, BFu7ll_BFu0s_S)
//============================================================================


struct  BFu7ll_BFu0s_Uc  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu7ll_BFu0s_Uc) C1{ FL:7 Fs:0 Fc}



static void Test_BFu7ll_BFu0s_Uc()
{
  {
    init_simple_test("BFu7ll_BFu0s_Uc");
    static STRUCT_IF_C BFu7ll_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu7ll_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_Uc, BFu7ll_BFu0s_Uc)
//============================================================================


struct  BFu7ll_BFu0s_Ui  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu7ll_BFu0s_Ui) C1{ FL:7 Fs:0 Fi}



static void Test_BFu7ll_BFu0s_Ui()
{
  {
    init_simple_test("BFu7ll_BFu0s_Ui");
    static STRUCT_IF_C BFu7ll_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu7ll_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_Ui, BFu7ll_BFu0s_Ui)
//============================================================================


struct  BFu7ll_BFu0s_Ul  {
  __tsu64 v1:7;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu7ll_BFu0s_Ul) C1{ FL:7 Fs:0 FL}



static void Test_BFu7ll_BFu0s_Ul()
{
  {
    init_simple_test("BFu7ll_BFu0s_Ul");
    static STRUCT_IF_C BFu7ll_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_Ul, BFu7ll_BFu0s_Ul)
//============================================================================


struct  BFu7ll_BFu0s_Us  {
  __tsu64 v1:7;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu7ll_BFu0s_Us) C1{ FL:7 Fs:0 Fs}



static void Test_BFu7ll_BFu0s_Us()
{
  {
    init_simple_test("BFu7ll_BFu0s_Us");
    static STRUCT_IF_C BFu7ll_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu7ll_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_Us, BFu7ll_BFu0s_Us)
//============================================================================


struct  BFu7ll_BFu0s_Vp  {
  __tsu64 v1:7;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu7ll_BFu0s_Vp) C1{ FL:7 Fs:0 Fp}



static void Test_BFu7ll_BFu0s_Vp()
{
  {
    init_simple_test("BFu7ll_BFu0s_Vp");
    static STRUCT_IF_C BFu7ll_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu0s_Vp, BFu7ll_BFu0s_Vp)
//============================================================================


struct  BFu7ll_BFu15i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu15i_BFu0c) C1{ FL:7 Fi:15 Fc:0}



static void Test_BFu7ll_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu15i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu15i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15i_BFu0c, BFu7ll_BFu15i_BFu0c)
//============================================================================


struct  BFu7ll_BFu15i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu15i_BFu0i) C1{ FL:7 Fi:15 Fi:0}



static void Test_BFu7ll_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu15i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15i_BFu0i, BFu7ll_BFu15i_BFu0i)
//============================================================================


struct  BFu7ll_BFu15i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu15i_BFu0ll) C1{ FL:7 Fi:15 FL:0}



static void Test_BFu7ll_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15i_BFu0ll, BFu7ll_BFu15i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu15i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu15i_BFu0s) C1{ FL:7 Fi:15 Fs:0}



static void Test_BFu7ll_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu15i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15i_BFu0s, BFu7ll_BFu15i_BFu0s)
//============================================================================


struct  BFu7ll_BFu15ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu15ll_BFu0c) C1{ FL:7 FL:15 Fc:0}



static void Test_BFu7ll_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15ll_BFu0c, BFu7ll_BFu15ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu15ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu15ll_BFu0i) C1{ FL:7 FL:15 Fi:0}



static void Test_BFu7ll_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15ll_BFu0i, BFu7ll_BFu15ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu15ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu15ll_BFu0ll) C1{ FL:7 FL:15 FL:0}



static void Test_BFu7ll_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15ll_BFu0ll, BFu7ll_BFu15ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu15ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu15ll_BFu0s) C1{ FL:7 FL:15 Fs:0}



static void Test_BFu7ll_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15ll_BFu0s, BFu7ll_BFu15ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu15s_BFu0c  {
  __tsu64 v1:7;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu15s_BFu0c) C1{ FL:7 Fs:15 Fc:0}



static void Test_BFu7ll_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu15s_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu15s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15s_BFu0c, BFu7ll_BFu15s_BFu0c)
//============================================================================


struct  BFu7ll_BFu15s_BFu0i  {
  __tsu64 v1:7;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu15s_BFu0i) C1{ FL:7 Fs:15 Fi:0}



static void Test_BFu7ll_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu15s_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15s_BFu0i, BFu7ll_BFu15s_BFu0i)
//============================================================================


struct  BFu7ll_BFu15s_BFu0ll  {
  __tsu64 v1:7;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu15s_BFu0ll) C1{ FL:7 Fs:15 FL:0}



static void Test_BFu7ll_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15s_BFu0ll, BFu7ll_BFu15s_BFu0ll)
//============================================================================


struct  BFu7ll_BFu15s_BFu0s  {
  __tsu64 v1:7;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu15s_BFu0s) C1{ FL:7 Fs:15 Fs:0}



static void Test_BFu7ll_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu15s_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu15s_BFu0s, BFu7ll_BFu15s_BFu0s)
//============================================================================


struct  BFu7ll_BFu16i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu16i_BFu0c) C1{ FL:7 Fi:16 Fc:0}



static void Test_BFu7ll_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu16i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu16i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16i_BFu0c, BFu7ll_BFu16i_BFu0c)
//============================================================================


struct  BFu7ll_BFu16i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu16i_BFu0i) C1{ FL:7 Fi:16 Fi:0}



static void Test_BFu7ll_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu16i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16i_BFu0i, BFu7ll_BFu16i_BFu0i)
//============================================================================


struct  BFu7ll_BFu16i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu16i_BFu0ll) C1{ FL:7 Fi:16 FL:0}



static void Test_BFu7ll_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16i_BFu0ll, BFu7ll_BFu16i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu16i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu16i_BFu0s) C1{ FL:7 Fi:16 Fs:0}



static void Test_BFu7ll_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu16i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16i_BFu0s, BFu7ll_BFu16i_BFu0s)
//============================================================================


struct  BFu7ll_BFu16ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu16ll_BFu0c) C1{ FL:7 FL:16 Fc:0}



static void Test_BFu7ll_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16ll_BFu0c, BFu7ll_BFu16ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu16ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu16ll_BFu0i) C1{ FL:7 FL:16 Fi:0}



static void Test_BFu7ll_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16ll_BFu0i, BFu7ll_BFu16ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu16ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu16ll_BFu0ll) C1{ FL:7 FL:16 FL:0}



static void Test_BFu7ll_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16ll_BFu0ll, BFu7ll_BFu16ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu16ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu16ll_BFu0s) C1{ FL:7 FL:16 Fs:0}



static void Test_BFu7ll_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16ll_BFu0s, BFu7ll_BFu16ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu16s_BFu0c  {
  __tsu64 v1:7;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu16s_BFu0c) C1{ FL:7 Fs:16 Fc:0}



static void Test_BFu7ll_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu16s_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu16s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16s_BFu0c, BFu7ll_BFu16s_BFu0c)
//============================================================================


struct  BFu7ll_BFu16s_BFu0i  {
  __tsu64 v1:7;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu16s_BFu0i) C1{ FL:7 Fs:16 Fi:0}



static void Test_BFu7ll_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu16s_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16s_BFu0i, BFu7ll_BFu16s_BFu0i)
//============================================================================


struct  BFu7ll_BFu16s_BFu0ll  {
  __tsu64 v1:7;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu16s_BFu0ll) C1{ FL:7 Fs:16 FL:0}



static void Test_BFu7ll_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16s_BFu0ll, BFu7ll_BFu16s_BFu0ll)
//============================================================================


struct  BFu7ll_BFu16s_BFu0s  {
  __tsu64 v1:7;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu16s_BFu0s) C1{ FL:7 Fs:16 Fs:0}



static void Test_BFu7ll_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu16s_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu16s_BFu0s, BFu7ll_BFu16s_BFu0s)
//============================================================================


struct  BFu7ll_BFu17i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu17i_BFu0c) C1{ FL:7 Fi:17 Fc:0}



static void Test_BFu7ll_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu17i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu17i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17i_BFu0c, BFu7ll_BFu17i_BFu0c)
//============================================================================


struct  BFu7ll_BFu17i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu17i_BFu0i) C1{ FL:7 Fi:17 Fi:0}



static void Test_BFu7ll_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu17i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17i_BFu0i, BFu7ll_BFu17i_BFu0i)
//============================================================================


struct  BFu7ll_BFu17i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu17i_BFu0ll) C1{ FL:7 Fi:17 FL:0}



static void Test_BFu7ll_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17i_BFu0ll, BFu7ll_BFu17i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu17i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu17i_BFu0s) C1{ FL:7 Fi:17 Fs:0}



static void Test_BFu7ll_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu17i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17i_BFu0s, BFu7ll_BFu17i_BFu0s)
//============================================================================


struct  BFu7ll_BFu17ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu17ll_BFu0c) C1{ FL:7 FL:17 Fc:0}



static void Test_BFu7ll_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17ll_BFu0c, BFu7ll_BFu17ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu17ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu17ll_BFu0i) C1{ FL:7 FL:17 Fi:0}



static void Test_BFu7ll_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17ll_BFu0i, BFu7ll_BFu17ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu17ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu17ll_BFu0ll) C1{ FL:7 FL:17 FL:0}



static void Test_BFu7ll_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17ll_BFu0ll, BFu7ll_BFu17ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu17ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu17ll_BFu0s) C1{ FL:7 FL:17 Fs:0}



static void Test_BFu7ll_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu17ll_BFu0s, BFu7ll_BFu17ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu1c_BFu0c  {
  __tsu64 v1:7;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu1c_BFu0c) C1{ FL:7 Fc:1 Fc:0}



static void Test_BFu7ll_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu1c_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu1c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1c_BFu0c, BFu7ll_BFu1c_BFu0c)
//============================================================================


struct  BFu7ll_BFu1c_BFu0i  {
  __tsu64 v1:7;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu1c_BFu0i) C1{ FL:7 Fc:1 Fi:0}



static void Test_BFu7ll_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu1c_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1c_BFu0i, BFu7ll_BFu1c_BFu0i)
//============================================================================


struct  BFu7ll_BFu1c_BFu0ll  {
  __tsu64 v1:7;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu1c_BFu0ll) C1{ FL:7 Fc:1 FL:0}



static void Test_BFu7ll_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1c_BFu0ll, BFu7ll_BFu1c_BFu0ll)
//============================================================================


struct  BFu7ll_BFu1c_BFu0s  {
  __tsu64 v1:7;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu1c_BFu0s) C1{ FL:7 Fc:1 Fs:0}



static void Test_BFu7ll_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu1c_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1c_BFu0s, BFu7ll_BFu1c_BFu0s)
//============================================================================


struct  BFu7ll_BFu1i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu1i_BFu0c) C1{ FL:7 Fi:1 Fc:0}



static void Test_BFu7ll_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu1i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu1i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1i_BFu0c, BFu7ll_BFu1i_BFu0c)
//============================================================================


struct  BFu7ll_BFu1i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu1i_BFu0i) C1{ FL:7 Fi:1 Fi:0}



static void Test_BFu7ll_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu1i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1i_BFu0i, BFu7ll_BFu1i_BFu0i)
//============================================================================


struct  BFu7ll_BFu1i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu1i_BFu0ll) C1{ FL:7 Fi:1 FL:0}



static void Test_BFu7ll_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1i_BFu0ll, BFu7ll_BFu1i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu1i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu1i_BFu0s) C1{ FL:7 Fi:1 Fs:0}



static void Test_BFu7ll_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu1i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1i_BFu0s, BFu7ll_BFu1i_BFu0s)
//============================================================================


struct  BFu7ll_BFu1ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu1ll_BFu0c) C1{ FL:7 FL:1 Fc:0}



static void Test_BFu7ll_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1ll_BFu0c, BFu7ll_BFu1ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu1ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu1ll_BFu0i) C1{ FL:7 FL:1 Fi:0}



static void Test_BFu7ll_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1ll_BFu0i, BFu7ll_BFu1ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu1ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu1ll_BFu0ll) C1{ FL:7 FL:1 FL:0}



static void Test_BFu7ll_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1ll_BFu0ll, BFu7ll_BFu1ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu1ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu1ll_BFu0s) C1{ FL:7 FL:1 Fs:0}



static void Test_BFu7ll_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1ll_BFu0s, BFu7ll_BFu1ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu1s_BFu0c  {
  __tsu64 v1:7;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu1s_BFu0c) C1{ FL:7 Fs:1 Fc:0}



static void Test_BFu7ll_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu1s_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu1s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1s_BFu0c, BFu7ll_BFu1s_BFu0c)
//============================================================================


struct  BFu7ll_BFu1s_BFu0i  {
  __tsu64 v1:7;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu1s_BFu0i) C1{ FL:7 Fs:1 Fi:0}



static void Test_BFu7ll_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu1s_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1s_BFu0i, BFu7ll_BFu1s_BFu0i)
//============================================================================


struct  BFu7ll_BFu1s_BFu0ll  {
  __tsu64 v1:7;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu1s_BFu0ll) C1{ FL:7 Fs:1 FL:0}



static void Test_BFu7ll_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1s_BFu0ll, BFu7ll_BFu1s_BFu0ll)
//============================================================================


struct  BFu7ll_BFu1s_BFu0s  {
  __tsu64 v1:7;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu1s_BFu0s) C1{ FL:7 Fs:1 Fs:0}



static void Test_BFu7ll_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu1s_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu1s_BFu0s, BFu7ll_BFu1s_BFu0s)
//============================================================================


struct  BFu7ll_BFu31i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu31i_BFu0c) C1{ FL:7 Fi:31 Fc:0}



static void Test_BFu7ll_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu31i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31i_BFu0c, BFu7ll_BFu31i_BFu0c)
//============================================================================


struct  BFu7ll_BFu31i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu31i_BFu0i) C1{ FL:7 Fi:31 Fi:0}



static void Test_BFu7ll_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu31i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31i_BFu0i, BFu7ll_BFu31i_BFu0i)
//============================================================================


struct  BFu7ll_BFu31i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu31i_BFu0ll) C1{ FL:7 Fi:31 FL:0}



static void Test_BFu7ll_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31i_BFu0ll, BFu7ll_BFu31i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu31i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu31i_BFu0s) C1{ FL:7 Fi:31 Fs:0}



static void Test_BFu7ll_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu31i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31i_BFu0s, BFu7ll_BFu31i_BFu0s)
//============================================================================


struct  BFu7ll_BFu31ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu31ll_BFu0c) C1{ FL:7 FL:31 Fc:0}



static void Test_BFu7ll_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31ll_BFu0c, BFu7ll_BFu31ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu31ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu31ll_BFu0i) C1{ FL:7 FL:31 Fi:0}



static void Test_BFu7ll_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31ll_BFu0i, BFu7ll_BFu31ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu31ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu31ll_BFu0ll) C1{ FL:7 FL:31 FL:0}



static void Test_BFu7ll_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31ll_BFu0ll, BFu7ll_BFu31ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu31ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu31ll_BFu0s) C1{ FL:7 FL:31 Fs:0}



static void Test_BFu7ll_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu31ll_BFu0s, BFu7ll_BFu31ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu32i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu32i_BFu0c) C1{ FL:7 Fi:32 Fc:0}



static void Test_BFu7ll_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu32i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32i_BFu0c, BFu7ll_BFu32i_BFu0c)
//============================================================================


struct  BFu7ll_BFu32i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu32i_BFu0i) C1{ FL:7 Fi:32 Fi:0}



static void Test_BFu7ll_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu32i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32i_BFu0i, BFu7ll_BFu32i_BFu0i)
//============================================================================


struct  BFu7ll_BFu32i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu32i_BFu0ll) C1{ FL:7 Fi:32 FL:0}



static void Test_BFu7ll_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32i_BFu0ll, BFu7ll_BFu32i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu32i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu32i_BFu0s) C1{ FL:7 Fi:32 Fs:0}



static void Test_BFu7ll_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu32i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32i_BFu0s, BFu7ll_BFu32i_BFu0s)
//============================================================================


struct  BFu7ll_BFu32ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu32ll_BFu0c) C1{ FL:7 FL:32 Fc:0}



static void Test_BFu7ll_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32ll_BFu0c, BFu7ll_BFu32ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu32ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu32ll_BFu0i) C1{ FL:7 FL:32 Fi:0}



static void Test_BFu7ll_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32ll_BFu0i, BFu7ll_BFu32ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu32ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu32ll_BFu0ll) C1{ FL:7 FL:32 FL:0}



static void Test_BFu7ll_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32ll_BFu0ll, BFu7ll_BFu32ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu32ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu32ll_BFu0s) C1{ FL:7 FL:32 Fs:0}



static void Test_BFu7ll_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu32ll_BFu0s, BFu7ll_BFu32ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu33_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu33_BFu0c) C1{ FL:7 FL:33 Fc:0}



static void Test_BFu7ll_BFu33_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu33_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7ll_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu33_BFu0c, BFu7ll_BFu33_BFu0c)
//============================================================================


struct  BFu7ll_BFu33_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu33_BFu0i) C1{ FL:7 FL:33 Fi:0}



static void Test_BFu7ll_BFu33_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu33_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7ll_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu33_BFu0i, BFu7ll_BFu33_BFu0i)
//============================================================================


struct  BFu7ll_BFu33_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu33_BFu0ll) C1{ FL:7 FL:33 FL:0}



static void Test_BFu7ll_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu33_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7ll_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu33_BFu0ll, BFu7ll_BFu33_BFu0ll)
//============================================================================


struct  BFu7ll_BFu33_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu33_BFu0s) C1{ FL:7 FL:33 Fs:0}



static void Test_BFu7ll_BFu33_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu33_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7ll_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu33_BFu0s, BFu7ll_BFu33_BFu0s)
//============================================================================


struct  BFu7ll_BFu7c_BFu0c  {
  __tsu64 v1:7;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu7c_BFu0c) C1{ FL:7 Fc:7 Fc:0}



static void Test_BFu7ll_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu7c_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu7c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7c_BFu0c, BFu7ll_BFu7c_BFu0c)
//============================================================================


struct  BFu7ll_BFu7c_BFu0i  {
  __tsu64 v1:7;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu7c_BFu0i) C1{ FL:7 Fc:7 Fi:0}



static void Test_BFu7ll_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu7c_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7c_BFu0i, BFu7ll_BFu7c_BFu0i)
//============================================================================


struct  BFu7ll_BFu7c_BFu0ll  {
  __tsu64 v1:7;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu7c_BFu0ll) C1{ FL:7 Fc:7 FL:0}



static void Test_BFu7ll_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7c_BFu0ll, BFu7ll_BFu7c_BFu0ll)
//============================================================================


struct  BFu7ll_BFu7c_BFu0s  {
  __tsu64 v1:7;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu7c_BFu0s) C1{ FL:7 Fc:7 Fs:0}



static void Test_BFu7ll_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu7c_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7c_BFu0s, BFu7ll_BFu7c_BFu0s)
//============================================================================


struct  BFu7ll_BFu7i_BFu0c  {
  __tsu64 v1:7;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu7i_BFu0c) C1{ FL:7 Fi:7 Fc:0}



static void Test_BFu7ll_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu7i_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu7i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7i_BFu0c, BFu7ll_BFu7i_BFu0c)
//============================================================================


struct  BFu7ll_BFu7i_BFu0i  {
  __tsu64 v1:7;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu7i_BFu0i) C1{ FL:7 Fi:7 Fi:0}



static void Test_BFu7ll_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu7i_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7i_BFu0i, BFu7ll_BFu7i_BFu0i)
//============================================================================


struct  BFu7ll_BFu7i_BFu0ll  {
  __tsu64 v1:7;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu7i_BFu0ll) C1{ FL:7 Fi:7 FL:0}



static void Test_BFu7ll_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7i_BFu0ll, BFu7ll_BFu7i_BFu0ll)
//============================================================================


struct  BFu7ll_BFu7i_BFu0s  {
  __tsu64 v1:7;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu7i_BFu0s) C1{ FL:7 Fi:7 Fs:0}



static void Test_BFu7ll_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu7i_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7i_BFu0s, BFu7ll_BFu7i_BFu0s)
//============================================================================


struct  BFu7ll_BFu7ll_BFu0c  {
  __tsu64 v1:7;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu7ll_BFu0c) C1{ FL:7 FL:7 Fc:0}



static void Test_BFu7ll_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7ll_BFu0c, BFu7ll_BFu7ll_BFu0c)
//============================================================================


struct  BFu7ll_BFu7ll_BFu0i  {
  __tsu64 v1:7;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu7ll_BFu0i) C1{ FL:7 FL:7 Fi:0}



static void Test_BFu7ll_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7ll_BFu0i, BFu7ll_BFu7ll_BFu0i)
//============================================================================


struct  BFu7ll_BFu7ll_BFu0ll  {
  __tsu64 v1:7;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu7ll_BFu0ll) C1{ FL:7 FL:7 FL:0}



static void Test_BFu7ll_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7ll_BFu0ll, BFu7ll_BFu7ll_BFu0ll)
//============================================================================


struct  BFu7ll_BFu7ll_BFu0s  {
  __tsu64 v1:7;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu7ll_BFu0s) C1{ FL:7 FL:7 Fs:0}



static void Test_BFu7ll_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7ll_BFu0s, BFu7ll_BFu7ll_BFu0s)
//============================================================================


struct  BFu7ll_BFu7s_BFu0c  {
  __tsu64 v1:7;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu7s_BFu0c) C1{ FL:7 Fs:7 Fc:0}



static void Test_BFu7ll_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu7s_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu7s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7s_BFu0c, BFu7ll_BFu7s_BFu0c)
//============================================================================


struct  BFu7ll_BFu7s_BFu0i  {
  __tsu64 v1:7;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu7s_BFu0i) C1{ FL:7 Fs:7 Fi:0}



static void Test_BFu7ll_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu7s_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7s_BFu0i, BFu7ll_BFu7s_BFu0i)
//============================================================================


struct  BFu7ll_BFu7s_BFu0ll  {
  __tsu64 v1:7;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu7ll_BFu7s_BFu0ll) C1{ FL:7 Fs:7 FL:0}



static void Test_BFu7ll_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu7ll_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu7ll_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7s_BFu0ll, BFu7ll_BFu7s_BFu0ll)
//============================================================================


struct  BFu7ll_BFu7s_BFu0s  {
  __tsu64 v1:7;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu7ll_BFu7s_BFu0s) C1{ FL:7 Fs:7 Fs:0}



static void Test_BFu7ll_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu7ll_BFu7s_BFu0s");
    static STRUCT_IF_C BFu7ll_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu7s_BFu0s, BFu7ll_BFu7s_BFu0s)
//============================================================================


struct  BFu7ll_BFu8c_BFu0c  {
  __tsu64 v1:7;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu7ll_BFu8c_BFu0c) C1{ FL:7 Fc:8 Fc:0}



static void Test_BFu7ll_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu7ll_BFu8c_BFu0c");
    static STRUCT_IF_C BFu7ll_BFu8c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu7ll_BFu8c_BFu0c, BFu7ll_BFu8c_BFu0c)
//============================================================================


struct  BFu7ll_BFu8c_BFu0i  {
  __tsu64 v1:7;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu7ll_BFu8c_BFu0i) C1{ FL:7 Fc:8 Fi:0}



static void Test_BFu7ll_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu7ll_BFu8c_BFu0i");
    static STRUCT_IF_C BFu7ll_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8c_BFu0i");
    set_bf_and