// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu17ll_BFu0ll_BFu1i  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu17ll_BFu0ll_BFu1i) C1{ FL:17 FL:0 Fi:1}



static void Test_BFu17ll_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu17ll_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu1i, BFu17ll_BFu0ll_BFu1i)
//============================================================================


struct  BFu17ll_BFu0ll_BFu1ll  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu17ll_BFu0ll_BFu1ll) C1{ FL:17 FL:0 FL:1}



static void Test_BFu17ll_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu17ll_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu1ll, BFu17ll_BFu0ll_BFu1ll)
//============================================================================


struct  BFu17ll_BFu0ll_BFu1s  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu17ll_BFu0ll_BFu1s) C1{ FL:17 FL:0 Fs:1}



static void Test_BFu17ll_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu17ll_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu1s, BFu17ll_BFu0ll_BFu1s)
//============================================================================


struct  BFu17ll_BFu0ll_BFu31i  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu17ll_BFu0ll_BFu31i) C1{ FL:17 FL:0 Fi:31}



static void Test_BFu17ll_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu17ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu31i, BFu17ll_BFu0ll_BFu31i)
//============================================================================


struct  BFu17ll_BFu0ll_BFu31ll  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu17ll_BFu0ll_BFu31ll) C1{ FL:17 FL:0 FL:31}



static void Test_BFu17ll_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu17ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu31ll, BFu17ll_BFu0ll_BFu31ll)
//============================================================================


struct  BFu17ll_BFu0ll_BFu32i  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu17ll_BFu0ll_BFu32i) C1{ FL:17 FL:0 Fi:32}



static void Test_BFu17ll_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu17ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu32i, BFu17ll_BFu0ll_BFu32i)
//============================================================================


struct  BFu17ll_BFu0ll_BFu32ll  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu17ll_BFu0ll_BFu32ll) C1{ FL:17 FL:0 FL:32}



static void Test_BFu17ll_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu17ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu32ll, BFu17ll_BFu0ll_BFu32ll)
//============================================================================


struct  BFu17ll_BFu0ll_BFu33  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu17ll_BFu0ll_BFu33) C1{ FL:17 FL:0 FL:33}



static void Test_BFu17ll_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu33");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu17ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu17ll_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu33, BFu17ll_BFu0ll_BFu33)
//============================================================================


struct  BFu17ll_BFu0ll_BFu7c  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu17ll_BFu0ll_BFu7c) C1{ FL:17 FL:0 Fc:7}



static void Test_BFu17ll_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu17ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu7c, BFu17ll_BFu0ll_BFu7c)
//============================================================================


struct  BFu17ll_BFu0ll_BFu7i  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu17ll_BFu0ll_BFu7i) C1{ FL:17 FL:0 Fi:7}



static void Test_BFu17ll_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu17ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu7i, BFu17ll_BFu0ll_BFu7i)
//============================================================================


struct  BFu17ll_BFu0ll_BFu7ll  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu17ll_BFu0ll_BFu7ll) C1{ FL:17 FL:0 FL:7}



static void Test_BFu17ll_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu17ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu7ll, BFu17ll_BFu0ll_BFu7ll)
//============================================================================


struct  BFu17ll_BFu0ll_BFu7s  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu17ll_BFu0ll_BFu7s) C1{ FL:17 FL:0 Fs:7}



static void Test_BFu17ll_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu17ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu7s, BFu17ll_BFu0ll_BFu7s)
//============================================================================


struct  BFu17ll_BFu0ll_BFu8c  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu17ll_BFu0ll_BFu8c) C1{ FL:17 FL:0 Fc:8}



static void Test_BFu17ll_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu17ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu8c, BFu17ll_BFu0ll_BFu8c)
//============================================================================


struct  BFu17ll_BFu0ll_BFu8i  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu17ll_BFu0ll_BFu8i) C1{ FL:17 FL:0 Fi:8}



static void Test_BFu17ll_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu17ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu8i, BFu17ll_BFu0ll_BFu8i)
//============================================================================


struct  BFu17ll_BFu0ll_BFu8ll  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu17ll_BFu0ll_BFu8ll) C1{ FL:17 FL:0 FL:8}



static void Test_BFu17ll_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu17ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu8ll, BFu17ll_BFu0ll_BFu8ll)
//============================================================================


struct  BFu17ll_BFu0ll_BFu8s  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu17ll_BFu0ll_BFu8s) C1{ FL:17 FL:0 Fs:8}



static void Test_BFu17ll_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu17ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu8s, BFu17ll_BFu0ll_BFu8s)
//============================================================================


struct  BFu17ll_BFu0ll_BFu9i  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu17ll_BFu0ll_BFu9i) C1{ FL:17 FL:0 Fi:9}



static void Test_BFu17ll_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu17ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu9i, BFu17ll_BFu0ll_BFu9i)
//============================================================================


struct  BFu17ll_BFu0ll_BFu9ll  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu17ll_BFu0ll_BFu9ll) C1{ FL:17 FL:0 FL:9}



static void Test_BFu17ll_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu17ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu9ll, BFu17ll_BFu0ll_BFu9ll)
//============================================================================


struct  BFu17ll_BFu0ll_BFu9s  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu17ll_BFu0ll_BFu9s) C1{ FL:17 FL:0 Fs:9}



static void Test_BFu17ll_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu17ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_BFu9s, BFu17ll_BFu0ll_BFu9s)
//============================================================================


struct  BFu17ll_BFu0ll_C  {
  __tsu64 v1:17;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu17ll_BFu0ll_C) C1{ FL:17 FL:0 Fc}



static void Test_BFu17ll_BFu0ll_C()
{
  {
    init_simple_test("BFu17ll_BFu0ll_C");
    static STRUCT_IF_C BFu17ll_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_C, BFu17ll_BFu0ll_C)
//============================================================================


struct  BFu17ll_BFu0ll_D  {
  __tsu64 v1:17;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu17ll_BFu0ll_D) C1{ FL:17 FL:0 FL}



static void Test_BFu17ll_BFu0ll_D()
{
  {
    init_simple_test("BFu17ll_BFu0ll_D");
    static STRUCT_IF_C BFu17ll_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_D, BFu17ll_BFu0ll_D)
//============================================================================


struct  BFu17ll_BFu0ll_F  {
  __tsu64 v1:17;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu17ll_BFu0ll_F) C1{ FL:17 FL:0 Fi}



static void Test_BFu17ll_BFu0ll_F()
{
  {
    init_simple_test("BFu17ll_BFu0ll_F");
    static STRUCT_IF_C BFu17ll_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_F, BFu17ll_BFu0ll_F)
//============================================================================


struct  BFu17ll_BFu0ll_I  {
  __tsu64 v1:17;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu17ll_BFu0ll_I) C1{ FL:17 FL:0 Fi}



static void Test_BFu17ll_BFu0ll_I()
{
  {
    init_simple_test("BFu17ll_BFu0ll_I");
    static STRUCT_IF_C BFu17ll_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_I, BFu17ll_BFu0ll_I)
//============================================================================


struct  BFu17ll_BFu0ll_Ip  {
  __tsu64 v1:17;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu17ll_BFu0ll_Ip) C1{ FL:17 FL:0 Fp}



static void Test_BFu17ll_BFu0ll_Ip()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Ip");
    static STRUCT_IF_C BFu17ll_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Ip, BFu17ll_BFu0ll_Ip)
//============================================================================


struct  BFu17ll_BFu0ll_L  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu17ll_BFu0ll_L) C1{ FL:17 FL:0 FL}



static void Test_BFu17ll_BFu0ll_L()
{
  {
    init_simple_test("BFu17ll_BFu0ll_L");
    static STRUCT_IF_C BFu17ll_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_L, BFu17ll_BFu0ll_L)
//============================================================================


struct  BFu17ll_BFu0ll_S  {
  __tsu64 v1:17;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu17ll_BFu0ll_S) C1{ FL:17 FL:0 Fs}



static void Test_BFu17ll_BFu0ll_S()
{
  {
    init_simple_test("BFu17ll_BFu0ll_S");
    static STRUCT_IF_C BFu17ll_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_S, BFu17ll_BFu0ll_S)
//============================================================================


struct  BFu17ll_BFu0ll_Uc  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu17ll_BFu0ll_Uc) C1{ FL:17 FL:0 Fc}



static void Test_BFu17ll_BFu0ll_Uc()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Uc");
    static STRUCT_IF_C BFu17ll_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Uc, BFu17ll_BFu0ll_Uc)
//============================================================================


struct  BFu17ll_BFu0ll_Ui  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu17ll_BFu0ll_Ui) C1{ FL:17 FL:0 Fi}



static void Test_BFu17ll_BFu0ll_Ui()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Ui");
    static STRUCT_IF_C BFu17ll_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Ui, BFu17ll_BFu0ll_Ui)
//============================================================================


struct  BFu17ll_BFu0ll_Ul  {
  __tsu64 v1:17;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu17ll_BFu0ll_Ul) C1{ FL:17 FL:0 FL}



static void Test_BFu17ll_BFu0ll_Ul()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Ul");
    static STRUCT_IF_C BFu17ll_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Ul, BFu17ll_BFu0ll_Ul)
//============================================================================


struct  BFu17ll_BFu0ll_Us  {
  __tsu64 v1:17;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu17ll_BFu0ll_Us) C1{ FL:17 FL:0 Fs}



static void Test_BFu17ll_BFu0ll_Us()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Us");
    static STRUCT_IF_C BFu17ll_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Us, BFu17ll_BFu0ll_Us)
//============================================================================


struct  BFu17ll_BFu0ll_Vp  {
  __tsu64 v1:17;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu17ll_BFu0ll_Vp) C1{ FL:17 FL:0 Fp}



static void Test_BFu17ll_BFu0ll_Vp()
{
  {
    init_simple_test("BFu17ll_BFu0ll_Vp");
    static STRUCT_IF_C BFu17ll_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0ll_Vp, BFu17ll_BFu0ll_Vp)
//============================================================================


struct  BFu17ll_BFu0s  {
  __tsu64 v1:17;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu0s) C1{ FL:17 Fs:0}



static void Test_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s, BFu17ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu0s_BFu0c  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu0s_BFu0c) C1{ FL:17 Fs:0 Fc:0}



static void Test_BFu17ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu0c, BFu17ll_BFu0s_BFu0c)
//============================================================================


struct  BFu17ll_BFu0s_BFu0i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu0s_BFu0i) C1{ FL:17 Fs:0 Fi:0}



static void Test_BFu17ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu0i, BFu17ll_BFu0s_BFu0i)
//============================================================================


struct  BFu17ll_BFu0s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu0s_BFu0ll) C1{ FL:17 Fs:0 FL:0}



static void Test_BFu17ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu0ll, BFu17ll_BFu0s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu0s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu0s_BFu0s) C1{ FL:17 Fs:0 Fs:0}



static void Test_BFu17ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu0s, BFu17ll_BFu0s_BFu0s)
//============================================================================


struct  BFu17ll_BFu0s_BFu15i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu17ll_BFu0s_BFu15i) C1{ FL:17 Fs:0 Fi:15}



static void Test_BFu17ll_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu15i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu17ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu15i, BFu17ll_BFu0s_BFu15i)
//============================================================================


struct  BFu17ll_BFu0s_BFu15ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu17ll_BFu0s_BFu15ll) C1{ FL:17 Fs:0 FL:15}



static void Test_BFu17ll_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu17ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu15ll, BFu17ll_BFu0s_BFu15ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu15s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu17ll_BFu0s_BFu15s) C1{ FL:17 Fs:0 Fs:15}



static void Test_BFu17ll_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu15s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu17ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu15s, BFu17ll_BFu0s_BFu15s)
//============================================================================


struct  BFu17ll_BFu0s_BFu16i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu17ll_BFu0s_BFu16i) C1{ FL:17 Fs:0 Fi:16}



static void Test_BFu17ll_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu16i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu16i, BFu17ll_BFu0s_BFu16i)
//============================================================================


struct  BFu17ll_BFu0s_BFu16ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu17ll_BFu0s_BFu16ll) C1{ FL:17 Fs:0 FL:16}



static void Test_BFu17ll_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu16ll, BFu17ll_BFu0s_BFu16ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu16s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu17ll_BFu0s_BFu16s) C1{ FL:17 Fs:0 Fs:16}



static void Test_BFu17ll_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu16s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu16s, BFu17ll_BFu0s_BFu16s)
//============================================================================


struct  BFu17ll_BFu0s_BFu17i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu17ll_BFu0s_BFu17i) C1{ FL:17 Fs:0 Fi:17}



static void Test_BFu17ll_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu17i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu17i, BFu17ll_BFu0s_BFu17i)
//============================================================================


struct  BFu17ll_BFu0s_BFu17ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu17ll_BFu0s_BFu17ll) C1{ FL:17 Fs:0 FL:17}



static void Test_BFu17ll_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu17ll, BFu17ll_BFu0s_BFu17ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu1c  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu17ll_BFu0s_BFu1c) C1{ FL:17 Fs:0 Fc:1}



static void Test_BFu17ll_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu1c");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu17ll_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu1c, BFu17ll_BFu0s_BFu1c)
//============================================================================


struct  BFu17ll_BFu0s_BFu1i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu17ll_BFu0s_BFu1i) C1{ FL:17 Fs:0 Fi:1}



static void Test_BFu17ll_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu1i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu17ll_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu1i, BFu17ll_BFu0s_BFu1i)
//============================================================================


struct  BFu17ll_BFu0s_BFu1ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu17ll_BFu0s_BFu1ll) C1{ FL:17 Fs:0 FL:1}



static void Test_BFu17ll_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu17ll_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu1ll, BFu17ll_BFu0s_BFu1ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu1s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu17ll_BFu0s_BFu1s) C1{ FL:17 Fs:0 Fs:1}



static void Test_BFu17ll_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu1s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu17ll_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu1s, BFu17ll_BFu0s_BFu1s)
//============================================================================


struct  BFu17ll_BFu0s_BFu31i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu17ll_BFu0s_BFu31i) C1{ FL:17 Fs:0 Fi:31}



static void Test_BFu17ll_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu31i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu31i, BFu17ll_BFu0s_BFu31i)
//============================================================================


struct  BFu17ll_BFu0s_BFu31ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu17ll_BFu0s_BFu31ll) C1{ FL:17 Fs:0 FL:31}



static void Test_BFu17ll_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu31ll, BFu17ll_BFu0s_BFu31ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu32i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu17ll_BFu0s_BFu32i) C1{ FL:17 Fs:0 Fi:32}



static void Test_BFu17ll_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu32i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu32i, BFu17ll_BFu0s_BFu32i)
//============================================================================


struct  BFu17ll_BFu0s_BFu32ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu17ll_BFu0s_BFu32ll) C1{ FL:17 Fs:0 FL:32}



static void Test_BFu17ll_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu32ll, BFu17ll_BFu0s_BFu32ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu33  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu17ll_BFu0s_BFu33) C1{ FL:17 Fs:0 FL:33}



static void Test_BFu17ll_BFu0s_BFu33()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu33");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu17ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu17ll_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu33, BFu17ll_BFu0s_BFu33)
//============================================================================


struct  BFu17ll_BFu0s_BFu7c  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu17ll_BFu0s_BFu7c) C1{ FL:17 Fs:0 Fc:7}



static void Test_BFu17ll_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu7c");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu17ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu7c, BFu17ll_BFu0s_BFu7c)
//============================================================================


struct  BFu17ll_BFu0s_BFu7i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu17ll_BFu0s_BFu7i) C1{ FL:17 Fs:0 Fi:7}



static void Test_BFu17ll_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu7i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu17ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu7i, BFu17ll_BFu0s_BFu7i)
//============================================================================


struct  BFu17ll_BFu0s_BFu7ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu17ll_BFu0s_BFu7ll) C1{ FL:17 Fs:0 FL:7}



static void Test_BFu17ll_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu17ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu7ll, BFu17ll_BFu0s_BFu7ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu7s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu17ll_BFu0s_BFu7s) C1{ FL:17 Fs:0 Fs:7}



static void Test_BFu17ll_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu7s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu17ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu7s, BFu17ll_BFu0s_BFu7s)
//============================================================================


struct  BFu17ll_BFu0s_BFu8c  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu17ll_BFu0s_BFu8c) C1{ FL:17 Fs:0 Fc:8}



static void Test_BFu17ll_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu8c");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu17ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu8c, BFu17ll_BFu0s_BFu8c)
//============================================================================


struct  BFu17ll_BFu0s_BFu8i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu17ll_BFu0s_BFu8i) C1{ FL:17 Fs:0 Fi:8}



static void Test_BFu17ll_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu8i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu17ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu8i, BFu17ll_BFu0s_BFu8i)
//============================================================================


struct  BFu17ll_BFu0s_BFu8ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu17ll_BFu0s_BFu8ll) C1{ FL:17 Fs:0 FL:8}



static void Test_BFu17ll_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu17ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu8ll, BFu17ll_BFu0s_BFu8ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu8s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu17ll_BFu0s_BFu8s) C1{ FL:17 Fs:0 Fs:8}



static void Test_BFu17ll_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu8s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu17ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu8s, BFu17ll_BFu0s_BFu8s)
//============================================================================


struct  BFu17ll_BFu0s_BFu9i  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu17ll_BFu0s_BFu9i) C1{ FL:17 Fs:0 Fi:9}



static void Test_BFu17ll_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu9i");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu17ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu9i, BFu17ll_BFu0s_BFu9i)
//============================================================================


struct  BFu17ll_BFu0s_BFu9ll  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu17ll_BFu0s_BFu9ll) C1{ FL:17 Fs:0 FL:9}



static void Test_BFu17ll_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu17ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu9ll, BFu17ll_BFu0s_BFu9ll)
//============================================================================


struct  BFu17ll_BFu0s_BFu9s  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu17ll_BFu0s_BFu9s) C1{ FL:17 Fs:0 Fs:9}



static void Test_BFu17ll_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu17ll_BFu0s_BFu9s");
    static STRUCT_IF_C BFu17ll_BFu0s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu17ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_BFu9s, BFu17ll_BFu0s_BFu9s)
//============================================================================


struct  BFu17ll_BFu0s_C  {
  __tsu64 v1:17;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu17ll_BFu0s_C) C1{ FL:17 Fs:0 Fc}



static void Test_BFu17ll_BFu0s_C()
{
  {
    init_simple_test("BFu17ll_BFu0s_C");
    static STRUCT_IF_C BFu17ll_BFu0s_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_C");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_C, BFu17ll_BFu0s_C)
//============================================================================


struct  BFu17ll_BFu0s_D  {
  __tsu64 v1:17;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu17ll_BFu0s_D) C1{ FL:17 Fs:0 FL}



static void Test_BFu17ll_BFu0s_D()
{
  {
    init_simple_test("BFu17ll_BFu0s_D");
    static STRUCT_IF_C BFu17ll_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_D, BFu17ll_BFu0s_D)
//============================================================================


struct  BFu17ll_BFu0s_F  {
  __tsu64 v1:17;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu17ll_BFu0s_F) C1{ FL:17 Fs:0 Fi}



static void Test_BFu17ll_BFu0s_F()
{
  {
    init_simple_test("BFu17ll_BFu0s_F");
    static STRUCT_IF_C BFu17ll_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_F, BFu17ll_BFu0s_F)
//============================================================================


struct  BFu17ll_BFu0s_I  {
  __tsu64 v1:17;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu17ll_BFu0s_I) C1{ FL:17 Fs:0 Fi}



static void Test_BFu17ll_BFu0s_I()
{
  {
    init_simple_test("BFu17ll_BFu0s_I");
    static STRUCT_IF_C BFu17ll_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_I, BFu17ll_BFu0s_I)
//============================================================================


struct  BFu17ll_BFu0s_Ip  {
  __tsu64 v1:17;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu17ll_BFu0s_Ip) C1{ FL:17 Fs:0 Fp}



static void Test_BFu17ll_BFu0s_Ip()
{
  {
    init_simple_test("BFu17ll_BFu0s_Ip");
    static STRUCT_IF_C BFu17ll_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Ip, BFu17ll_BFu0s_Ip)
//============================================================================


struct  BFu17ll_BFu0s_L  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu17ll_BFu0s_L) C1{ FL:17 Fs:0 FL}



static void Test_BFu17ll_BFu0s_L()
{
  {
    init_simple_test("BFu17ll_BFu0s_L");
    static STRUCT_IF_C BFu17ll_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_L, BFu17ll_BFu0s_L)
//============================================================================


struct  BFu17ll_BFu0s_S  {
  __tsu64 v1:17;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu17ll_BFu0s_S) C1{ FL:17 Fs:0 Fs}



static void Test_BFu17ll_BFu0s_S()
{
  {
    init_simple_test("BFu17ll_BFu0s_S");
    static STRUCT_IF_C BFu17ll_BFu0s_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_S");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_S, BFu17ll_BFu0s_S)
//============================================================================


struct  BFu17ll_BFu0s_Uc  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu17ll_BFu0s_Uc) C1{ FL:17 Fs:0 Fc}



static void Test_BFu17ll_BFu0s_Uc()
{
  {
    init_simple_test("BFu17ll_BFu0s_Uc");
    static STRUCT_IF_C BFu17ll_BFu0s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Uc");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Uc, BFu17ll_BFu0s_Uc)
//============================================================================


struct  BFu17ll_BFu0s_Ui  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu17ll_BFu0s_Ui) C1{ FL:17 Fs:0 Fi}



static void Test_BFu17ll_BFu0s_Ui()
{
  {
    init_simple_test("BFu17ll_BFu0s_Ui");
    static STRUCT_IF_C BFu17ll_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Ui, BFu17ll_BFu0s_Ui)
//============================================================================


struct  BFu17ll_BFu0s_Ul  {
  __tsu64 v1:17;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu17ll_BFu0s_Ul) C1{ FL:17 Fs:0 FL}



static void Test_BFu17ll_BFu0s_Ul()
{
  {
    init_simple_test("BFu17ll_BFu0s_Ul");
    static STRUCT_IF_C BFu17ll_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Ul, BFu17ll_BFu0s_Ul)
//============================================================================


struct  BFu17ll_BFu0s_Us  {
  __tsu64 v1:17;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu17ll_BFu0s_Us) C1{ FL:17 Fs:0 Fs}



static void Test_BFu17ll_BFu0s_Us()
{
  {
    init_simple_test("BFu17ll_BFu0s_Us");
    static STRUCT_IF_C BFu17ll_BFu0s_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Us");
    check_field_offset(lv, v2, 4, "BFu17ll_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Us, BFu17ll_BFu0s_Us)
//============================================================================


struct  BFu17ll_BFu0s_Vp  {
  __tsu64 v1:17;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu17ll_BFu0s_Vp) C1{ FL:17 Fs:0 Fp}



static void Test_BFu17ll_BFu0s_Vp()
{
  {
    init_simple_test("BFu17ll_BFu0s_Vp");
    static STRUCT_IF_C BFu17ll_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu0s_Vp, BFu17ll_BFu0s_Vp)
//============================================================================


struct  BFu17ll_BFu15i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu15i_BFu0c) C1{ FL:17 Fi:15 Fc:0}



static void Test_BFu17ll_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu15i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu15i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15i_BFu0c, BFu17ll_BFu15i_BFu0c)
//============================================================================


struct  BFu17ll_BFu15i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu15i_BFu0i) C1{ FL:17 Fi:15 Fi:0}



static void Test_BFu17ll_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu15i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15i_BFu0i, BFu17ll_BFu15i_BFu0i)
//============================================================================


struct  BFu17ll_BFu15i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu15i_BFu0ll) C1{ FL:17 Fi:15 FL:0}



static void Test_BFu17ll_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15i_BFu0ll, BFu17ll_BFu15i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu15i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu15i_BFu0s) C1{ FL:17 Fi:15 Fs:0}



static void Test_BFu17ll_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu15i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15i_BFu0s, BFu17ll_BFu15i_BFu0s)
//============================================================================


struct  BFu17ll_BFu15ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu15ll_BFu0c) C1{ FL:17 FL:15 Fc:0}



static void Test_BFu17ll_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15ll_BFu0c, BFu17ll_BFu15ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu15ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu15ll_BFu0i) C1{ FL:17 FL:15 Fi:0}



static void Test_BFu17ll_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15ll_BFu0i, BFu17ll_BFu15ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu15ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu15ll_BFu0ll) C1{ FL:17 FL:15 FL:0}



static void Test_BFu17ll_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15ll_BFu0ll, BFu17ll_BFu15ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu15ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu15ll_BFu0s) C1{ FL:17 FL:15 Fs:0}



static void Test_BFu17ll_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15ll_BFu0s, BFu17ll_BFu15ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu15s_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu15s_BFu0c) C1{ FL:17 Fs:15 Fc:0}



static void Test_BFu17ll_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu15s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu15s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15s_BFu0c, BFu17ll_BFu15s_BFu0c)
//============================================================================


struct  BFu17ll_BFu15s_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu15s_BFu0i) C1{ FL:17 Fs:15 Fi:0}



static void Test_BFu17ll_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu15s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15s_BFu0i, BFu17ll_BFu15s_BFu0i)
//============================================================================


struct  BFu17ll_BFu15s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu15s_BFu0ll) C1{ FL:17 Fs:15 FL:0}



static void Test_BFu17ll_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15s_BFu0ll, BFu17ll_BFu15s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu15s_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu15s_BFu0s) C1{ FL:17 Fs:15 Fs:0}



static void Test_BFu17ll_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu15s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu15s_BFu0s, BFu17ll_BFu15s_BFu0s)
//============================================================================


struct  BFu17ll_BFu16i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu16i_BFu0c) C1{ FL:17 Fi:16 Fc:0}



static void Test_BFu17ll_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu16i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu16i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16i_BFu0c, BFu17ll_BFu16i_BFu0c)
//============================================================================


struct  BFu17ll_BFu16i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu16i_BFu0i) C1{ FL:17 Fi:16 Fi:0}



static void Test_BFu17ll_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu16i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu16i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16i_BFu0i, BFu17ll_BFu16i_BFu0i)
//============================================================================


struct  BFu17ll_BFu16i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu16i_BFu0ll) C1{ FL:17 Fi:16 FL:0}



static void Test_BFu17ll_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu16i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16i_BFu0ll, BFu17ll_BFu16i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu16i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu16i_BFu0s) C1{ FL:17 Fi:16 Fs:0}



static void Test_BFu17ll_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu16i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu16i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16i_BFu0s, BFu17ll_BFu16i_BFu0s)
//============================================================================


struct  BFu17ll_BFu16ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu16ll_BFu0c) C1{ FL:17 FL:16 Fc:0}



static void Test_BFu17ll_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu17ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu17ll_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16ll_BFu0c, BFu17ll_BFu16ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu16ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu16ll_BFu0i) C1{ FL:17 FL:16 Fi:0}



static void Test_BFu17ll_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu16ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu17ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu17ll_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16ll_BFu0i, BFu17ll_BFu16ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu16ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu16ll_BFu0ll) C1{ FL:17 FL:16 FL:0}



static void Test_BFu17ll_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu17ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu17ll_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16ll_BFu0ll, BFu17ll_BFu16ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu16ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu16ll_BFu0s) C1{ FL:17 FL:16 Fs:0}



static void Test_BFu17ll_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu17ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu17ll_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16ll_BFu0s, BFu17ll_BFu16ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu16s_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu16s_BFu0c) C1{ FL:17 Fs:16 Fc:0}



static void Test_BFu17ll_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu16s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu16s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16s_BFu0c, BFu17ll_BFu16s_BFu0c)
//============================================================================


struct  BFu17ll_BFu16s_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu16s_BFu0i) C1{ FL:17 Fs:16 Fi:0}



static void Test_BFu17ll_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu16s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu16s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16s_BFu0i, BFu17ll_BFu16s_BFu0i)
//============================================================================


struct  BFu17ll_BFu16s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu16s_BFu0ll) C1{ FL:17 Fs:16 FL:0}



static void Test_BFu17ll_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu16s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16s_BFu0ll, BFu17ll_BFu16s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu16s_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu16s_BFu0s) C1{ FL:17 Fs:16 Fs:0}



static void Test_BFu17ll_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu16s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu16s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu16s_BFu0s, BFu17ll_BFu16s_BFu0s)
//============================================================================


struct  BFu17ll_BFu17i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu17i_BFu0c) C1{ FL:17 Fi:17 Fc:0}



static void Test_BFu17ll_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu17i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu17i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17i_BFu0c, BFu17ll_BFu17i_BFu0c)
//============================================================================


struct  BFu17ll_BFu17i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu17i_BFu0i) C1{ FL:17 Fi:17 Fi:0}



static void Test_BFu17ll_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu17i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu17i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17i_BFu0i, BFu17ll_BFu17i_BFu0i)
//============================================================================


struct  BFu17ll_BFu17i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu17i_BFu0ll) C1{ FL:17 Fi:17 FL:0}



static void Test_BFu17ll_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu17i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17i_BFu0ll, BFu17ll_BFu17i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu17i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu17i_BFu0s) C1{ FL:17 Fi:17 Fs:0}



static void Test_BFu17ll_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu17i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu17i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17i_BFu0s, BFu17ll_BFu17i_BFu0s)
//============================================================================


struct  BFu17ll_BFu17ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu17ll_BFu0c) C1{ FL:17 FL:17 Fc:0}



static void Test_BFu17ll_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu17ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17ll_BFu0c, BFu17ll_BFu17ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu17ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu17ll_BFu0i) C1{ FL:17 FL:17 Fi:0}



static void Test_BFu17ll_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu17ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17ll_BFu0i, BFu17ll_BFu17ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu17ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu17ll_BFu0ll) C1{ FL:17 FL:17 FL:0}



static void Test_BFu17ll_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu17ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17ll_BFu0ll, BFu17ll_BFu17ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu17ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu17ll_BFu0s) C1{ FL:17 FL:17 Fs:0}



static void Test_BFu17ll_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu17ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu17ll_BFu0s, BFu17ll_BFu17ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu1c_BFu0c  {
  __tsu64 v1:17;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu1c_BFu0c) C1{ FL:17 Fc:1 Fc:0}



static void Test_BFu17ll_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu1c_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu1c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1c_BFu0c, BFu17ll_BFu1c_BFu0c)
//============================================================================


struct  BFu17ll_BFu1c_BFu0i  {
  __tsu64 v1:17;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu1c_BFu0i) C1{ FL:17 Fc:1 Fi:0}



static void Test_BFu17ll_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu1c_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1c_BFu0i, BFu17ll_BFu1c_BFu0i)
//============================================================================


struct  BFu17ll_BFu1c_BFu0ll  {
  __tsu64 v1:17;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu1c_BFu0ll) C1{ FL:17 Fc:1 FL:0}



static void Test_BFu17ll_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1c_BFu0ll, BFu17ll_BFu1c_BFu0ll)
//============================================================================


struct  BFu17ll_BFu1c_BFu0s  {
  __tsu64 v1:17;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu1c_BFu0s) C1{ FL:17 Fc:1 Fs:0}



static void Test_BFu17ll_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu1c_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1c_BFu0s, BFu17ll_BFu1c_BFu0s)
//============================================================================


struct  BFu17ll_BFu1i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu1i_BFu0c) C1{ FL:17 Fi:1 Fc:0}



static void Test_BFu17ll_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu1i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu1i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1i_BFu0c, BFu17ll_BFu1i_BFu0c)
//============================================================================


struct  BFu17ll_BFu1i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu1i_BFu0i) C1{ FL:17 Fi:1 Fi:0}



static void Test_BFu17ll_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu1i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1i_BFu0i, BFu17ll_BFu1i_BFu0i)
//============================================================================


struct  BFu17ll_BFu1i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu1i_BFu0ll) C1{ FL:17 Fi:1 FL:0}



static void Test_BFu17ll_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1i_BFu0ll, BFu17ll_BFu1i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu1i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu1i_BFu0s) C1{ FL:17 Fi:1 Fs:0}



static void Test_BFu17ll_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu1i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1i_BFu0s, BFu17ll_BFu1i_BFu0s)
//============================================================================


struct  BFu17ll_BFu1ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu1ll_BFu0c) C1{ FL:17 FL:1 Fc:0}



static void Test_BFu17ll_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1ll_BFu0c, BFu17ll_BFu1ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu1ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu1ll_BFu0i) C1{ FL:17 FL:1 Fi:0}



static void Test_BFu17ll_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1ll_BFu0i, BFu17ll_BFu1ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu1ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu1ll_BFu0ll) C1{ FL:17 FL:1 FL:0}



static void Test_BFu17ll_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1ll_BFu0ll, BFu17ll_BFu1ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu1ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu1ll_BFu0s) C1{ FL:17 FL:1 Fs:0}



static void Test_BFu17ll_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1ll_BFu0s, BFu17ll_BFu1ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu1s_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu1s_BFu0c) C1{ FL:17 Fs:1 Fc:0}



static void Test_BFu17ll_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu1s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu1s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1s_BFu0c, BFu17ll_BFu1s_BFu0c)
//============================================================================


struct  BFu17ll_BFu1s_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu1s_BFu0i) C1{ FL:17 Fs:1 Fi:0}



static void Test_BFu17ll_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu1s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1s_BFu0i, BFu17ll_BFu1s_BFu0i)
//============================================================================


struct  BFu17ll_BFu1s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu1s_BFu0ll) C1{ FL:17 Fs:1 FL:0}



static void Test_BFu17ll_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1s_BFu0ll, BFu17ll_BFu1s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu1s_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu1s_BFu0s) C1{ FL:17 Fs:1 Fs:0}



static void Test_BFu17ll_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu1s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu1s_BFu0s, BFu17ll_BFu1s_BFu0s)
//============================================================================


struct  BFu17ll_BFu31i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu31i_BFu0c) C1{ FL:17 Fi:31 Fc:0}



static void Test_BFu17ll_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu31i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31i_BFu0c, BFu17ll_BFu31i_BFu0c)
//============================================================================


struct  BFu17ll_BFu31i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu31i_BFu0i) C1{ FL:17 Fi:31 Fi:0}



static void Test_BFu17ll_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu31i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31i_BFu0i, BFu17ll_BFu31i_BFu0i)
//============================================================================


struct  BFu17ll_BFu31i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu31i_BFu0ll) C1{ FL:17 Fi:31 FL:0}



static void Test_BFu17ll_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31i_BFu0ll, BFu17ll_BFu31i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu31i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu31i_BFu0s) C1{ FL:17 Fi:31 Fs:0}



static void Test_BFu17ll_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu31i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31i_BFu0s, BFu17ll_BFu31i_BFu0s)
//============================================================================


struct  BFu17ll_BFu31ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu31ll_BFu0c) C1{ FL:17 FL:31 Fc:0}



static void Test_BFu17ll_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu17ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu17ll_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31ll_BFu0c, BFu17ll_BFu31ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu31ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu31ll_BFu0i) C1{ FL:17 FL:31 Fi:0}



static void Test_BFu17ll_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu17ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu17ll_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31ll_BFu0i, BFu17ll_BFu31ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu31ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu31ll_BFu0ll) C1{ FL:17 FL:31 FL:0}



static void Test_BFu17ll_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu17ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu17ll_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31ll_BFu0ll, BFu17ll_BFu31ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu31ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu31ll_BFu0s) C1{ FL:17 FL:31 Fs:0}



static void Test_BFu17ll_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu17ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu17ll_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu31ll_BFu0s, BFu17ll_BFu31ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu32i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu32i_BFu0c) C1{ FL:17 Fi:32 Fc:0}



static void Test_BFu17ll_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu32i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32i_BFu0c, BFu17ll_BFu32i_BFu0c)
//============================================================================


struct  BFu17ll_BFu32i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu32i_BFu0i) C1{ FL:17 Fi:32 Fi:0}



static void Test_BFu17ll_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu32i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32i_BFu0i, BFu17ll_BFu32i_BFu0i)
//============================================================================


struct  BFu17ll_BFu32i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu32i_BFu0ll) C1{ FL:17 Fi:32 FL:0}



static void Test_BFu17ll_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32i_BFu0ll, BFu17ll_BFu32i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu32i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu32i_BFu0s) C1{ FL:17 Fi:32 Fs:0}



static void Test_BFu17ll_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu32i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32i_BFu0s, BFu17ll_BFu32i_BFu0s)
//============================================================================


struct  BFu17ll_BFu32ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu32ll_BFu0c) C1{ FL:17 FL:32 Fc:0}



static void Test_BFu17ll_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu17ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu17ll_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32ll_BFu0c, BFu17ll_BFu32ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu32ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu32ll_BFu0i) C1{ FL:17 FL:32 Fi:0}



static void Test_BFu17ll_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu17ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu17ll_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32ll_BFu0i, BFu17ll_BFu32ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu32ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu32ll_BFu0ll) C1{ FL:17 FL:32 FL:0}



static void Test_BFu17ll_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu17ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu17ll_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32ll_BFu0ll, BFu17ll_BFu32ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu32ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu32ll_BFu0s) C1{ FL:17 FL:32 Fs:0}



static void Test_BFu17ll_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu17ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu17ll_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu32ll_BFu0s, BFu17ll_BFu32ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu33_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu33_BFu0c) C1{ FL:17 FL:33 Fc:0}



static void Test_BFu17ll_BFu33_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu33_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu17ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu17ll_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu33_BFu0c, BFu17ll_BFu33_BFu0c)
//============================================================================


struct  BFu17ll_BFu33_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu33_BFu0i) C1{ FL:17 FL:33 Fi:0}



static void Test_BFu17ll_BFu33_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu33_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu17ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu17ll_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu33_BFu0i, BFu17ll_BFu33_BFu0i)
//============================================================================


struct  BFu17ll_BFu33_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu33_BFu0ll) C1{ FL:17 FL:33 FL:0}



static void Test_BFu17ll_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu33_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu17ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu17ll_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu33_BFu0ll, BFu17ll_BFu33_BFu0ll)
//============================================================================


struct  BFu17ll_BFu33_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu33_BFu0s) C1{ FL:17 FL:33 Fs:0}



static void Test_BFu17ll_BFu33_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu33_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu17ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu17ll_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu33_BFu0s, BFu17ll_BFu33_BFu0s)
//============================================================================


struct  BFu17ll_BFu7c_BFu0c  {
  __tsu64 v1:17;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu7c_BFu0c) C1{ FL:17 Fc:7 Fc:0}



static void Test_BFu17ll_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu7c_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu7c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7c_BFu0c, BFu17ll_BFu7c_BFu0c)
//============================================================================


struct  BFu17ll_BFu7c_BFu0i  {
  __tsu64 v1:17;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu7c_BFu0i) C1{ FL:17 Fc:7 Fi:0}



static void Test_BFu17ll_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu7c_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7c_BFu0i, BFu17ll_BFu7c_BFu0i)
//============================================================================


struct  BFu17ll_BFu7c_BFu0ll  {
  __tsu64 v1:17;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu7c_BFu0ll) C1{ FL:17 Fc:7 FL:0}



static void Test_BFu17ll_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7c_BFu0ll, BFu17ll_BFu7c_BFu0ll)
//============================================================================


struct  BFu17ll_BFu7c_BFu0s  {
  __tsu64 v1:17;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu7c_BFu0s) C1{ FL:17 Fc:7 Fs:0}



static void Test_BFu17ll_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu7c_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7c_BFu0s, BFu17ll_BFu7c_BFu0s)
//============================================================================


struct  BFu17ll_BFu7i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu7i_BFu0c) C1{ FL:17 Fi:7 Fc:0}



static void Test_BFu17ll_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu7i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu7i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7i_BFu0c, BFu17ll_BFu7i_BFu0c)
//============================================================================


struct  BFu17ll_BFu7i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu7i_BFu0i) C1{ FL:17 Fi:7 Fi:0}



static void Test_BFu17ll_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu7i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7i_BFu0i, BFu17ll_BFu7i_BFu0i)
//============================================================================


struct  BFu17ll_BFu7i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu7i_BFu0ll) C1{ FL:17 Fi:7 FL:0}



static void Test_BFu17ll_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7i_BFu0ll, BFu17ll_BFu7i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu7i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu7i_BFu0s) C1{ FL:17 Fi:7 Fs:0}



static void Test_BFu17ll_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu7i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7i_BFu0s, BFu17ll_BFu7i_BFu0s)
//============================================================================


struct  BFu17ll_BFu7ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu7ll_BFu0c) C1{ FL:17 FL:7 Fc:0}



static void Test_BFu17ll_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7ll_BFu0c, BFu17ll_BFu7ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu7ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu7ll_BFu0i) C1{ FL:17 FL:7 Fi:0}



static void Test_BFu17ll_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7ll_BFu0i, BFu17ll_BFu7ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu7ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu7ll_BFu0ll) C1{ FL:17 FL:7 FL:0}



static void Test_BFu17ll_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7ll_BFu0ll, BFu17ll_BFu7ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu7ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu7ll_BFu0s) C1{ FL:17 FL:7 Fs:0}



static void Test_BFu17ll_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7ll_BFu0s, BFu17ll_BFu7ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu7s_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu7s_BFu0c) C1{ FL:17 Fs:7 Fc:0}



static void Test_BFu17ll_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu7s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu7s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7s_BFu0c, BFu17ll_BFu7s_BFu0c)
//============================================================================


struct  BFu17ll_BFu7s_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu7s_BFu0i) C1{ FL:17 Fs:7 Fi:0}



static void Test_BFu17ll_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu7s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7s_BFu0i, BFu17ll_BFu7s_BFu0i)
//============================================================================


struct  BFu17ll_BFu7s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu7s_BFu0ll) C1{ FL:17 Fs:7 FL:0}



static void Test_BFu17ll_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7s_BFu0ll, BFu17ll_BFu7s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu7s_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu7s_BFu0s) C1{ FL:17 Fs:7 Fs:0}



static void Test_BFu17ll_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu7s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu7s_BFu0s, BFu17ll_BFu7s_BFu0s)
//============================================================================


struct  BFu17ll_BFu8c_BFu0c  {
  __tsu64 v1:17;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu8c_BFu0c) C1{ FL:17 Fc:8 Fc:0}



static void Test_BFu17ll_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu8c_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu8c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu17ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8c_BFu0c, BFu17ll_BFu8c_BFu0c)
//============================================================================


struct  BFu17ll_BFu8c_BFu0i  {
  __tsu64 v1:17;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu8c_BFu0i) C1{ FL:17 Fc:8 Fi:0}



static void Test_BFu17ll_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu8c_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu17ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8c_BFu0i, BFu17ll_BFu8c_BFu0i)
//============================================================================


struct  BFu17ll_BFu8c_BFu0ll  {
  __tsu64 v1:17;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu8c_BFu0ll) C1{ FL:17 Fc:8 FL:0}



static void Test_BFu17ll_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu17ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8c_BFu0ll, BFu17ll_BFu8c_BFu0ll)
//============================================================================


struct  BFu17ll_BFu8c_BFu0s  {
  __tsu64 v1:17;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu8c_BFu0s) C1{ FL:17 Fc:8 Fs:0}



static void Test_BFu17ll_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu8c_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu17ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8c_BFu0s, BFu17ll_BFu8c_BFu0s)
//============================================================================


struct  BFu17ll_BFu8i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu8i_BFu0c) C1{ FL:17 Fi:8 Fc:0}



static void Test_BFu17ll_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu8i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu8i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8i_BFu0c, BFu17ll_BFu8i_BFu0c)
//============================================================================


struct  BFu17ll_BFu8i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu8i_BFu0i) C1{ FL:17 Fi:8 Fi:0}



static void Test_BFu17ll_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu8i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8i_BFu0i, BFu17ll_BFu8i_BFu0i)
//============================================================================


struct  BFu17ll_BFu8i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu8i_BFu0ll) C1{ FL:17 Fi:8 FL:0}



static void Test_BFu17ll_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8i_BFu0ll, BFu17ll_BFu8i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu8i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu8i_BFu0s) C1{ FL:17 Fi:8 Fs:0}



static void Test_BFu17ll_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu8i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8i_BFu0s, BFu17ll_BFu8i_BFu0s)
//============================================================================


struct  BFu17ll_BFu8ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu8ll_BFu0c) C1{ FL:17 FL:8 Fc:0}



static void Test_BFu17ll_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8ll_BFu0c, BFu17ll_BFu8ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu8ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu8ll_BFu0i) C1{ FL:17 FL:8 Fi:0}



static void Test_BFu17ll_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8ll_BFu0i, BFu17ll_BFu8ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu8ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu8ll_BFu0ll) C1{ FL:17 FL:8 FL:0}



static void Test_BFu17ll_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8ll_BFu0ll, BFu17ll_BFu8ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu8ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu8ll_BFu0s) C1{ FL:17 FL:8 Fs:0}



static void Test_BFu17ll_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8ll_BFu0s, BFu17ll_BFu8ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu8s_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu8s_BFu0c) C1{ FL:17 Fs:8 Fc:0}



static void Test_BFu17ll_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu0c, BFu17ll_BFu8s_BFu0c)
//============================================================================


struct  BFu17ll_BFu8s_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu8s_BFu0i) C1{ FL:17 Fs:8 Fi:0}



static void Test_BFu17ll_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu0i, BFu17ll_BFu8s_BFu0i)
//============================================================================


struct  BFu17ll_BFu8s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu8s_BFu0ll) C1{ FL:17 Fs:8 FL:0}



static void Test_BFu17ll_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu0ll, BFu17ll_BFu8s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu8s_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu8s_BFu0s) C1{ FL:17 Fs:8 Fs:0}



static void Test_BFu17ll_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu8s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu8s_BFu0s, BFu17ll_BFu8s_BFu0s)
//============================================================================


struct  BFu17ll_BFu9i_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu9i_BFu0c) C1{ FL:17 Fi:9 Fc:0}



static void Test_BFu17ll_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu0c, BFu17ll_BFu9i_BFu0c)
//============================================================================


struct  BFu17ll_BFu9i_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu9i_BFu0i) C1{ FL:17 Fi:9 Fi:0}



static void Test_BFu17ll_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu0i, BFu17ll_BFu9i_BFu0i)
//============================================================================


struct  BFu17ll_BFu9i_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu9i_BFu0ll) C1{ FL:17 Fi:9 FL:0}



static void Test_BFu17ll_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu0ll, BFu17ll_BFu9i_BFu0ll)
//============================================================================


struct  BFu17ll_BFu9i_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu9i_BFu0s) C1{ FL:17 Fi:9 Fs:0}



static void Test_BFu17ll_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu9i_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9i_BFu0s, BFu17ll_BFu9i_BFu0s)
//============================================================================


struct  BFu17ll_BFu9ll_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu9ll_BFu0c) C1{ FL:17 FL:9 Fc:0}



static void Test_BFu17ll_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu0c, BFu17ll_BFu9ll_BFu0c)
//============================================================================


struct  BFu17ll_BFu9ll_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu9ll_BFu0i) C1{ FL:17 FL:9 Fi:0}



static void Test_BFu17ll_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu0i, BFu17ll_BFu9ll_BFu0i)
//============================================================================


struct  BFu17ll_BFu9ll_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu9ll_BFu0ll) C1{ FL:17 FL:9 FL:0}



static void Test_BFu17ll_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu0ll, BFu17ll_BFu9ll_BFu0ll)
//============================================================================


struct  BFu17ll_BFu9ll_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu9ll_BFu0s) C1{ FL:17 FL:9 Fs:0}



static void Test_BFu17ll_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9ll_BFu0s, BFu17ll_BFu9ll_BFu0s)
//============================================================================


struct  BFu17ll_BFu9s_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu17ll_BFu9s_BFu0c) C1{ FL:17 Fs:9 Fc:0}



static void Test_BFu17ll_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu0c");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu0c, BFu17ll_BFu9s_BFu0c)
//============================================================================


struct  BFu17ll_BFu9s_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu17ll_BFu9s_BFu0i) C1{ FL:17 Fs:9 Fi:0}



static void Test_BFu17ll_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu0i");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu0i, BFu17ll_BFu9s_BFu0i)
//============================================================================


struct  BFu17ll_BFu9s_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu17ll_BFu9s_BFu0ll) C1{ FL:17 Fs:9 FL:0}



static void Test_BFu17ll_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu0ll, BFu17ll_BFu9s_BFu0ll)
//============================================================================


struct  BFu17ll_BFu9s_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu17ll_BFu9s_BFu0s) C1{ FL:17 Fs:9 Fs:0}



static void Test_BFu17ll_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu17ll_BFu9s_BFu0s");
    static STRUCT_IF_C BFu17ll_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_BFu9s_BFu0s, BFu17ll_BFu9s_BFu0s)
//============================================================================


struct  BFu17ll_C_BFu0c  {
  __tsu64 v1:17;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_C_BFu0c) C1{ FL:17 Fc Fc:0}



static void Test_BFu17ll_C_BFu0c()
{
  {
    init_simple_test("BFu17ll_C_BFu0c");
    static STRUCT_IF_C BFu17ll_C_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_C_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu0c");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu0c, BFu17ll_C_BFu0c)
//============================================================================


struct  BFu17ll_C_BFu0i  {
  __tsu64 v1:17;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_C_BFu0i) C1{ FL:17 Fc Fi:0}



static void Test_BFu17ll_C_BFu0i()
{
  {
    init_simple_test("BFu17ll_C_BFu0i");
    static STRUCT_IF_C BFu17ll_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu0i");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu0i, BFu17ll_C_BFu0i)
//============================================================================


struct  BFu17ll_C_BFu0ll  {
  __tsu64 v1:17;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_C_BFu0ll) C1{ FL:17 Fc FL:0}



static void Test_BFu17ll_C_BFu0ll()
{
  {
    init_simple_test("BFu17ll_C_BFu0ll");
    static STRUCT_IF_C BFu17ll_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu0ll");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu0ll, BFu17ll_C_BFu0ll)
//============================================================================


struct  BFu17ll_C_BFu0s  {
  __tsu64 v1:17;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_C_BFu0s) C1{ FL:17 Fc Fs:0}



static void Test_BFu17ll_C_BFu0s()
{
  {
    init_simple_test("BFu17ll_C_BFu0s");
    static STRUCT_IF_C BFu17ll_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_BFu0s");
    check_field_offset(lv, v2, 3, "BFu17ll_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_C_BFu0s, BFu17ll_C_BFu0s)
//============================================================================


struct  BFu17ll_D_BFu0c  {
  __tsu64 v1:17;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_D_BFu0c) C1{ FL:17 FL Fc:0}



static void Test_BFu17ll_D_BFu0c()
{
  {
    init_simple_test("BFu17ll_D_BFu0c");
    static STRUCT_IF_C BFu17ll_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu0c, BFu17ll_D_BFu0c)
//============================================================================


struct  BFu17ll_D_BFu0i  {
  __tsu64 v1:17;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_D_BFu0i) C1{ FL:17 FL Fi:0}



static void Test_BFu17ll_D_BFu0i()
{
  {
    init_simple_test("BFu17ll_D_BFu0i");
    static STRUCT_IF_C BFu17ll_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu0i, BFu17ll_D_BFu0i)
//============================================================================


struct  BFu17ll_D_BFu0ll  {
  __tsu64 v1:17;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_D_BFu0ll) C1{ FL:17 FL FL:0}



static void Test_BFu17ll_D_BFu0ll()
{
  {
    init_simple_test("BFu17ll_D_BFu0ll");
    static STRUCT_IF_C BFu17ll_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu0ll, BFu17ll_D_BFu0ll)
//============================================================================


struct  BFu17ll_D_BFu0s  {
  __tsu64 v1:17;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_D_BFu0s) C1{ FL:17 FL Fs:0}



static void Test_BFu17ll_D_BFu0s()
{
  {
    init_simple_test("BFu17ll_D_BFu0s");
    static STRUCT_IF_C BFu17ll_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_D_BFu0s, BFu17ll_D_BFu0s)
//============================================================================


struct  BFu17ll_F_BFu0c  {
  __tsu64 v1:17;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_F_BFu0c) C1{ FL:17 Fi Fc:0}



static void Test_BFu17ll_F_BFu0c()
{
  {
    init_simple_test("BFu17ll_F_BFu0c");
    static STRUCT_IF_C BFu17ll_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_F_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu0c, BFu17ll_F_BFu0c)
//============================================================================


struct  BFu17ll_F_BFu0i  {
  __tsu64 v1:17;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_F_BFu0i) C1{ FL:17 Fi Fi:0}



static void Test_BFu17ll_F_BFu0i()
{
  {
    init_simple_test("BFu17ll_F_BFu0i");
    static STRUCT_IF_C BFu17ll_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_F_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu0i, BFu17ll_F_BFu0i)
//============================================================================


struct  BFu17ll_F_BFu0ll  {
  __tsu64 v1:17;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_F_BFu0ll) C1{ FL:17 Fi FL:0}



static void Test_BFu17ll_F_BFu0ll()
{
  {
    init_simple_test("BFu17ll_F_BFu0ll");
    static STRUCT_IF_C BFu17ll_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu0ll, BFu17ll_F_BFu0ll)
//============================================================================


struct  BFu17ll_F_BFu0s  {
  __tsu64 v1:17;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_F_BFu0s) C1{ FL:17 Fi Fs:0}



static void Test_BFu17ll_F_BFu0s()
{
  {
    init_simple_test("BFu17ll_F_BFu0s");
    static STRUCT_IF_C BFu17ll_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_F_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu17ll_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_F_BFu0s, BFu17ll_F_BFu0s)
//============================================================================


struct  BFu17ll_I_BFu0c  {
  __tsu64 v1:17;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_I_BFu0c) C1{ FL:17 Fi Fc:0}



static void Test_BFu17ll_I_BFu0c()
{
  {
    init_simple_test("BFu17ll_I_BFu0c");
    static STRUCT_IF_C BFu17ll_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_I_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu0c, BFu17ll_I_BFu0c)
//============================================================================


struct  BFu17ll_I_BFu0i  {
  __tsu64 v1:17;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_I_BFu0i) C1{ FL:17 Fi Fi:0}



static void Test_BFu17ll_I_BFu0i()
{
  {
    init_simple_test("BFu17ll_I_BFu0i");
    static STRUCT_IF_C BFu17ll_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_I_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu0i, BFu17ll_I_BFu0i)
//============================================================================


struct  BFu17ll_I_BFu0ll  {
  __tsu64 v1:17;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_I_BFu0ll) C1{ FL:17 Fi FL:0}



static void Test_BFu17ll_I_BFu0ll()
{
  {
    init_simple_test("BFu17ll_I_BFu0ll");
    static STRUCT_IF_C BFu17ll_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu0ll, BFu17ll_I_BFu0ll)
//============================================================================


struct  BFu17ll_I_BFu0s  {
  __tsu64 v1:17;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_I_BFu0s) C1{ FL:17 Fi Fs:0}



static void Test_BFu17ll_I_BFu0s()
{
  {
    init_simple_test("BFu17ll_I_BFu0s");
    static STRUCT_IF_C BFu17ll_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_I_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu17ll_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_I_BFu0s, BFu17ll_I_BFu0s)
//============================================================================


struct  BFu17ll_Ip_BFu0c  {
  __tsu64 v1:17;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_Ip_BFu0c) C1{ FL:17 Fp Fc:0}



static void Test_BFu17ll_Ip_BFu0c()
{
  {
    init_simple_test("BFu17ll_Ip_BFu0c");
    static STRUCT_IF_C BFu17ll_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu0c, BFu17ll_Ip_BFu0c)
//============================================================================


struct  BFu17ll_Ip_BFu0i  {
  __tsu64 v1:17;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_Ip_BFu0i) C1{ FL:17 Fp Fi:0}



static void Test_BFu17ll_Ip_BFu0i()
{
  {
    init_simple_test("BFu17ll_Ip_BFu0i");
    static STRUCT_IF_C BFu17ll_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu0i, BFu17ll_Ip_BFu0i)
//============================================================================


struct  BFu17ll_Ip_BFu0ll  {
  __tsu64 v1:17;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_Ip_BFu0ll) C1{ FL:17 Fp FL:0}



static void Test_BFu17ll_Ip_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Ip_BFu0ll");
    static STRUCT_IF_C BFu17ll_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu0ll, BFu17ll_Ip_BFu0ll)
//============================================================================


struct  BFu17ll_Ip_BFu0s  {
  __tsu64 v1:17;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_Ip_BFu0s) C1{ FL:17 Fp Fs:0}



static void Test_BFu17ll_Ip_BFu0s()
{
  {
    init_simple_test("BFu17ll_Ip_BFu0s");
    static STRUCT_IF_C BFu17ll_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ip_BFu0s, BFu17ll_Ip_BFu0s)
//============================================================================


struct  BFu17ll_L_BFu0c  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_L_BFu0c) C1{ FL:17 FL Fc:0}



static void Test_BFu17ll_L_BFu0c()
{
  {
    init_simple_test("BFu17ll_L_BFu0c");
    static STRUCT_IF_C BFu17ll_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu0c, BFu17ll_L_BFu0c)
//============================================================================


struct  BFu17ll_L_BFu0i  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_L_BFu0i) C1{ FL:17 FL Fi:0}



static void Test_BFu17ll_L_BFu0i()
{
  {
    init_simple_test("BFu17ll_L_BFu0i");
    static STRUCT_IF_C BFu17ll_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu0i, BFu17ll_L_BFu0i)
//============================================================================


struct  BFu17ll_L_BFu0ll  {
  __tsu64 v1:17;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_L_BFu0ll) C1{ FL:17 FL FL:0}



static void Test_BFu17ll_L_BFu0ll()
{
  {
    init_simple_test("BFu17ll_L_BFu0ll");
    static STRUCT_IF_C BFu17ll_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu0ll, BFu17ll_L_BFu0ll)
//============================================================================


struct  BFu17ll_L_BFu0s  {
  __tsu64 v1:17;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_L_BFu0s) C1{ FL:17 FL Fs:0}



static void Test_BFu17ll_L_BFu0s()
{
  {
    init_simple_test("BFu17ll_L_BFu0s");
    static STRUCT_IF_C BFu17ll_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_L_BFu0s, BFu17ll_L_BFu0s)
//============================================================================


struct  BFu17ll_S_BFu0c  {
  __tsu64 v1:17;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_S_BFu0c) C1{ FL:17 Fs Fc:0}



static void Test_BFu17ll_S_BFu0c()
{
  {
    init_simple_test("BFu17ll_S_BFu0c");
    static STRUCT_IF_C BFu17ll_S_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu0c");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu0c, BFu17ll_S_BFu0c)
//============================================================================


struct  BFu17ll_S_BFu0i  {
  __tsu64 v1:17;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_S_BFu0i) C1{ FL:17 Fs Fi:0}



static void Test_BFu17ll_S_BFu0i()
{
  {
    init_simple_test("BFu17ll_S_BFu0i");
    static STRUCT_IF_C BFu17ll_S_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu0i");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu0i, BFu17ll_S_BFu0i)
//============================================================================


struct  BFu17ll_S_BFu0ll  {
  __tsu64 v1:17;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_S_BFu0ll) C1{ FL:17 Fs FL:0}



static void Test_BFu17ll_S_BFu0ll()
{
  {
    init_simple_test("BFu17ll_S_BFu0ll");
    static STRUCT_IF_C BFu17ll_S_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu0ll, BFu17ll_S_BFu0ll)
//============================================================================


struct  BFu17ll_S_BFu0s  {
  __tsu64 v1:17;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_S_BFu0s) C1{ FL:17 Fs Fs:0}



static void Test_BFu17ll_S_BFu0s()
{
  {
    init_simple_test("BFu17ll_S_BFu0s");
    static STRUCT_IF_C BFu17ll_S_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_BFu0s");
    check_field_offset(lv, v2, 4, "BFu17ll_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_S_BFu0s, BFu17ll_S_BFu0s)
//============================================================================


struct  BFu17ll_Uc_BFu0c  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_Uc_BFu0c) C1{ FL:17 Fc Fc:0}



static void Test_BFu17ll_Uc_BFu0c()
{
  {
    init_simple_test("BFu17ll_Uc_BFu0c");
    static STRUCT_IF_C BFu17ll_Uc_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Uc_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu0c");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu0c, BFu17ll_Uc_BFu0c)
//============================================================================


struct  BFu17ll_Uc_BFu0i  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_Uc_BFu0i) C1{ FL:17 Fc Fi:0}



static void Test_BFu17ll_Uc_BFu0i()
{
  {
    init_simple_test("BFu17ll_Uc_BFu0i");
    static STRUCT_IF_C BFu17ll_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu0i");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu0i, BFu17ll_Uc_BFu0i)
//============================================================================


struct  BFu17ll_Uc_BFu0ll  {
  __tsu64 v1:17;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_Uc_BFu0ll) C1{ FL:17 Fc FL:0}



static void Test_BFu17ll_Uc_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Uc_BFu0ll");
    static STRUCT_IF_C BFu17ll_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu0ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu0ll, BFu17ll_Uc_BFu0ll)
//============================================================================


struct  BFu17ll_Uc_BFu0s  {
  __tsu64 v1:17;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_Uc_BFu0s) C1{ FL:17 Fc Fs:0}



static void Test_BFu17ll_Uc_BFu0s()
{
  {
    init_simple_test("BFu17ll_Uc_BFu0s");
    static STRUCT_IF_C BFu17ll_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_BFu0s");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Uc_BFu0s, BFu17ll_Uc_BFu0s)
//============================================================================


struct  BFu17ll_Ui_BFu0c  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_Ui_BFu0c) C1{ FL:17 Fi Fc:0}



static void Test_BFu17ll_Ui_BFu0c()
{
  {
    init_simple_test("BFu17ll_Ui_BFu0c");
    static STRUCT_IF_C BFu17ll_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Ui_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu0c, BFu17ll_Ui_BFu0c)
//============================================================================


struct  BFu17ll_Ui_BFu0i  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_Ui_BFu0i) C1{ FL:17 Fi Fi:0}



static void Test_BFu17ll_Ui_BFu0i()
{
  {
    init_simple_test("BFu17ll_Ui_BFu0i");
    static STRUCT_IF_C BFu17ll_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Ui_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu0i, BFu17ll_Ui_BFu0i)
//============================================================================


struct  BFu17ll_Ui_BFu0ll  {
  __tsu64 v1:17;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_Ui_BFu0ll) C1{ FL:17 Fi FL:0}



static void Test_BFu17ll_Ui_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Ui_BFu0ll");
    static STRUCT_IF_C BFu17ll_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu0ll, BFu17ll_Ui_BFu0ll)
//============================================================================


struct  BFu17ll_Ui_BFu0s  {
  __tsu64 v1:17;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_Ui_BFu0s) C1{ FL:17 Fi Fs:0}



static void Test_BFu17ll_Ui_BFu0s()
{
  {
    init_simple_test("BFu17ll_Ui_BFu0s");
    static STRUCT_IF_C BFu17ll_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Ui_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ui_BFu0s, BFu17ll_Ui_BFu0s)
//============================================================================


struct  BFu17ll_Ul_BFu0c  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_Ul_BFu0c) C1{ FL:17 FL Fc:0}



static void Test_BFu17ll_Ul_BFu0c()
{
  {
    init_simple_test("BFu17ll_Ul_BFu0c");
    static STRUCT_IF_C BFu17ll_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu0c, BFu17ll_Ul_BFu0c)
//============================================================================


struct  BFu17ll_Ul_BFu0i  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_Ul_BFu0i) C1{ FL:17 FL Fi:0}



static void Test_BFu17ll_Ul_BFu0i()
{
  {
    init_simple_test("BFu17ll_Ul_BFu0i");
    static STRUCT_IF_C BFu17ll_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu0i, BFu17ll_Ul_BFu0i)
//============================================================================


struct  BFu17ll_Ul_BFu0ll  {
  __tsu64 v1:17;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_Ul_BFu0ll) C1{ FL:17 FL FL:0}



static void Test_BFu17ll_Ul_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Ul_BFu0ll");
    static STRUCT_IF_C BFu17ll_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu0ll, BFu17ll_Ul_BFu0ll)
//============================================================================


struct  BFu17ll_Ul_BFu0s  {
  __tsu64 v1:17;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_Ul_BFu0s) C1{ FL:17 FL Fs:0}



static void Test_BFu17ll_Ul_BFu0s()
{
  {
    init_simple_test("BFu17ll_Ul_BFu0s");
    static STRUCT_IF_C BFu17ll_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Ul_BFu0s, BFu17ll_Ul_BFu0s)
//============================================================================


struct  BFu17ll_Us_BFu0c  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_Us_BFu0c) C1{ FL:17 Fs Fc:0}



static void Test_BFu17ll_Us_BFu0c()
{
  {
    init_simple_test("BFu17ll_Us_BFu0c");
    static STRUCT_IF_C BFu17ll_Us_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu0c");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu0c, BFu17ll_Us_BFu0c)
//============================================================================


struct  BFu17ll_Us_BFu0i  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_Us_BFu0i) C1{ FL:17 Fs Fi:0}



static void Test_BFu17ll_Us_BFu0i()
{
  {
    init_simple_test("BFu17ll_Us_BFu0i");
    static STRUCT_IF_C BFu17ll_Us_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu0i");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu0i, BFu17ll_Us_BFu0i)
//============================================================================


struct  BFu17ll_Us_BFu0ll  {
  __tsu64 v1:17;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_Us_BFu0ll) C1{ FL:17 Fs FL:0}



static void Test_BFu17ll_Us_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Us_BFu0ll");
    static STRUCT_IF_C BFu17ll_Us_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu0ll, BFu17ll_Us_BFu0ll)
//============================================================================


struct  BFu17ll_Us_BFu0s  {
  __tsu64 v1:17;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_Us_BFu0s) C1{ FL:17 Fs Fs:0}



static void Test_BFu17ll_Us_BFu0s()
{
  {
    init_simple_test("BFu17ll_Us_BFu0s");
    static STRUCT_IF_C BFu17ll_Us_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_BFu0s");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Us_BFu0s, BFu17ll_Us_BFu0s)
//============================================================================


struct  BFu17ll_Vp_BFu0c  {
  __tsu64 v1:17;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu17ll_Vp_BFu0c) C1{ FL:17 Fp Fc:0}



static void Test_BFu17ll_Vp_BFu0c()
{
  {
    init_simple_test("BFu17ll_Vp_BFu0c");
    static STRUCT_IF_C BFu17ll_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu0c, BFu17ll_Vp_BFu0c)
//============================================================================


struct  BFu17ll_Vp_BFu0i  {
  __tsu64 v1:17;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu17ll_Vp_BFu0i) C1{ FL:17 Fp Fi:0}



static void Test_BFu17ll_Vp_BFu0i()
{
  {
    init_simple_test("BFu17ll_Vp_BFu0i");
    static STRUCT_IF_C BFu17ll_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu0i, BFu17ll_Vp_BFu0i)
//============================================================================


struct  BFu17ll_Vp_BFu0ll  {
  __tsu64 v1:17;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu17ll_Vp_BFu0ll) C1{ FL:17 Fp FL:0}



static void Test_BFu17ll_Vp_BFu0ll()
{
  {
    init_simple_test("BFu17ll_Vp_BFu0ll");
    static STRUCT_IF_C BFu17ll_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu0ll, BFu17ll_Vp_BFu0ll)
//============================================================================


struct  BFu17ll_Vp_BFu0s  {
  __tsu64 v1:17;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu17ll_Vp_BFu0s) C1{ FL:17 Fp Fs:0}



static void Test_BFu17ll_Vp_BFu0s()
{
  {
    init_simple_test("BFu17ll_Vp_BFu0s");
    static STRUCT_IF_C BFu17ll_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu17ll_Vp_BFu0s, BFu17ll_Vp_BFu0s)
//============================================================================


struct  BFu1c_BFu0c  {
  unsigned char v1:1;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu0c) C1{ Fc:1 Fc:0}



static void Test_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu0c");
    static STRUCT_IF_C BFu1c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c, BFu1c_BFu0c)
//============================================================================


struct  BFu1c_BFu0c_BFu0c  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu0c_BFu0c) C1{ Fc:1 Fc:0 Fc:0}



static void Test_BFu1c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu0c");
    static STRUCT_IF_C BFu1c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu0c, BFu1c_BFu0c_BFu0c)
//============================================================================


struct  BFu1c_BFu0c_BFu0i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu0c_BFu0i) C1{ Fc:1 Fc:0 Fi:0}



static void Test_BFu1c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu0i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu0i, BFu1c_BFu0c_BFu0i)
//============================================================================


struct  BFu1c_BFu0c_BFu0ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu0c_BFu0ll) C1{ Fc:1 Fc:0 FL:0}



static void Test_BFu1c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu0ll, BFu1c_BFu0c_BFu0ll)
//============================================================================


struct  BFu1c_BFu0c_BFu0s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu0c_BFu0s) C1{ Fc:1 Fc:0 Fs:0}



static void Test_BFu1c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu0s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu0s, BFu1c_BFu0c_BFu0s)
//============================================================================


struct  BFu1c_BFu0c_BFu15i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1c_BFu0c_BFu15i) C1{ Fc:1 Fc:0 Fi:15}



static void Test_BFu1c_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu15i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1c_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu15i, BFu1c_BFu0c_BFu15i)
//============================================================================


struct  BFu1c_BFu0c_BFu15ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1c_BFu0c_BFu15ll) C1{ Fc:1 Fc:0 FL:15}



static void Test_BFu1c_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1c_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu15ll, BFu1c_BFu0c_BFu15ll)
//============================================================================


struct  BFu1c_BFu0c_BFu15s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1c_BFu0c_BFu15s) C1{ Fc:1 Fc:0 Fs:15}



static void Test_BFu1c_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu15s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1c_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu15s, BFu1c_BFu0c_BFu15s)
//============================================================================


struct  BFu1c_BFu0c_BFu16i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1c_BFu0c_BFu16i) C1{ Fc:1 Fc:0 Fi:16}



static void Test_BFu1c_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu16i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1c_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu16i, BFu1c_BFu0c_BFu16i)
//============================================================================


struct  BFu1c_BFu0c_BFu16ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1c_BFu0c_BFu16ll) C1{ Fc:1 Fc:0 FL:16}



static void Test_BFu1c_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1c_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu16ll, BFu1c_BFu0c_BFu16ll)
//============================================================================


struct  BFu1c_BFu0c_BFu16s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1c_BFu0c_BFu16s) C1{ Fc:1 Fc:0 Fs:16}



static void Test_BFu1c_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu16s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu16s, BFu1c_BFu0c_BFu16s)
//============================================================================


struct  BFu1c_BFu0c_BFu17i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1c_BFu0c_BFu17i) C1{ Fc:1 Fc:0 Fi:17}



static void Test_BFu1c_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu17i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1c_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu17i, BFu1c_BFu0c_BFu17i)
//============================================================================


struct  BFu1c_BFu0c_BFu17ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1c_BFu0c_BFu17ll) C1{ Fc:1 Fc:0 FL:17}



static void Test_BFu1c_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1c_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu17ll, BFu1c_BFu0c_BFu17ll)
//============================================================================


struct  BFu1c_BFu0c_BFu1c  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1c_BFu0c_BFu1c) C1{ Fc:1 Fc:0 Fc:1}



static void Test_BFu1c_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu1c");
    static STRUCT_IF_C BFu1c_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1c_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu1c, BFu1c_BFu0c_BFu1c)
//============================================================================


struct  BFu1c_BFu0c_BFu1i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1c_BFu0c_BFu1i) C1{ Fc:1 Fc:0 Fi:1}



static void Test_BFu1c_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu1i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1c_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu1i, BFu1c_BFu0c_BFu1i)
//============================================================================


struct  BFu1c_BFu0c_BFu1ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1c_BFu0c_BFu1ll) C1{ Fc:1 Fc:0 FL:1}



static void Test_BFu1c_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1c_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu1ll, BFu1c_BFu0c_BFu1ll)
//============================================================================


struct  BFu1c_BFu0c_BFu1s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1c_BFu0c_BFu1s) C1{ Fc:1 Fc:0 Fs:1}



static void Test_BFu1c_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu1s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1c_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu1s, BFu1c_BFu0c_BFu1s)
//============================================================================


struct  BFu1c_BFu0c_BFu31i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1c_BFu0c_BFu31i) C1{ Fc:1 Fc:0 Fi:31}



static void Test_BFu1c_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu31i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1c_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu31i, BFu1c_BFu0c_BFu31i)
//============================================================================


struct  BFu1c_BFu0c_BFu31ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1c_BFu0c_BFu31ll) C1{ Fc:1 Fc:0 FL:31}



static void Test_BFu1c_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu1c_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu31ll, BFu1c_BFu0c_BFu31ll)
//============================================================================


struct  BFu1c_BFu0c_BFu32i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1c_BFu0c_BFu32i) C1{ Fc:1 Fc:0 Fi:32}



static void Test_BFu1c_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu32i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu32i, BFu1c_BFu0c_BFu32i)
//============================================================================


struct  BFu1c_BFu0c_BFu32ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1c_BFu0c_BFu32ll) C1{ Fc:1 Fc:0 FL:32}



static void Test_BFu1c_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu1c_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu32ll, BFu1c_BFu0c_BFu32ll)
//============================================================================


struct  BFu1c_BFu0c_BFu33  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1c_BFu0c_BFu33) C1{ Fc:1 Fc:0 FL:33}



static void Test_BFu1c_BFu0c_BFu33()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu33");
    static STRUCT_IF_C BFu1c_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu1c_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu1c_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu33, BFu1c_BFu0c_BFu33)
//============================================================================


struct  BFu1c_BFu0c_BFu7c  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1c_BFu0c_BFu7c) C1{ Fc:1 Fc:0 Fc:7}



static void Test_BFu1c_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu7c");
    static STRUCT_IF_C BFu1c_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1c_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu7c, BFu1c_BFu0c_BFu7c)
//============================================================================


struct  BFu1c_BFu0c_BFu7i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1c_BFu0c_BFu7i) C1{ Fc:1 Fc:0 Fi:7}



static void Test_BFu1c_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu7i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1c_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu7i, BFu1c_BFu0c_BFu7i)
//============================================================================


struct  BFu1c_BFu0c_BFu7ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1c_BFu0c_BFu7ll) C1{ Fc:1 Fc:0 FL:7}



static void Test_BFu1c_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1c_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu7ll, BFu1c_BFu0c_BFu7ll)
//============================================================================


struct  BFu1c_BFu0c_BFu7s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1c_BFu0c_BFu7s) C1{ Fc:1 Fc:0 Fs:7}



static void Test_BFu1c_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu7s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1c_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu7s, BFu1c_BFu0c_BFu7s)
//============================================================================


struct  BFu1c_BFu0c_BFu8c  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1c_BFu0c_BFu8c) C1{ Fc:1 Fc:0 Fc:8}



static void Test_BFu1c_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu8c");
    static STRUCT_IF_C BFu1c_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu8c, BFu1c_BFu0c_BFu8c)
//============================================================================


struct  BFu1c_BFu0c_BFu8i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1c_BFu0c_BFu8i) C1{ Fc:1 Fc:0 Fi:8}



static void Test_BFu1c_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu8i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu8i, BFu1c_BFu0c_BFu8i)
//============================================================================


struct  BFu1c_BFu0c_BFu8ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1c_BFu0c_BFu8ll) C1{ Fc:1 Fc:0 FL:8}



static void Test_BFu1c_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu8ll, BFu1c_BFu0c_BFu8ll)
//============================================================================


struct  BFu1c_BFu0c_BFu8s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1c_BFu0c_BFu8s) C1{ Fc:1 Fc:0 Fs:8}



static void Test_BFu1c_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu8s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu8s, BFu1c_BFu0c_BFu8s)
//============================================================================


struct  BFu1c_BFu0c_BFu9i  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1c_BFu0c_BFu9i) C1{ Fc:1 Fc:0 Fi:9}



static void Test_BFu1c_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu9i");
    static STRUCT_IF_C BFu1c_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1c_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu9i, BFu1c_BFu0c_BFu9i)
//============================================================================


struct  BFu1c_BFu0c_BFu9ll  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1c_BFu0c_BFu9ll) C1{ Fc:1 Fc:0 FL:9}



static void Test_BFu1c_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1c_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu9ll, BFu1c_BFu0c_BFu9ll)
//============================================================================


struct  BFu1c_BFu0c_BFu9s  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1c_BFu0c_BFu9s) C1{ Fc:1 Fc:0 Fs:9}



static void Test_BFu1c_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu0c_BFu9s");
    static STRUCT_IF_C BFu1c_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1c_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_BFu9s, BFu1c_BFu0c_BFu9s)
//============================================================================


struct  BFu1c_BFu0c_C  {
  unsigned char v1:1;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu1c_BFu0c_C) C1{ Fc:1 Fc:0 Fc}



static void Test_BFu1c_BFu0c_C()
{
  {
    init_simple_test("BFu1c_BFu0c_C");
    static STRUCT_IF_C BFu1c_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu1c_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_C, BFu1c_BFu0c_C)
//============================================================================


struct  BFu1c_BFu0c_D  {
  unsigned char v1:1;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu1c_BFu0c_D) C1{ Fc:1 Fc:0 FL}



static void Test_BFu1c_BFu0c_D()
{
  {
    init_simple_test("BFu1c_BFu0c_D");
    static STRUCT_IF_C BFu1c_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_D, BFu1c_BFu0c_D)
//============================================================================


struct  BFu1c_BFu0c_F  {
  unsigned char v1:1;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu1c_BFu0c_F) C1{ Fc:1 Fc:0 Fi}



static void Test_BFu1c_BFu0c_F()
{
  {
    init_simple_test("BFu1c_BFu0c_F");
    static STRUCT_IF_C BFu1c_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_F, BFu1c_BFu0c_F)
//============================================================================


struct  BFu1c_BFu0c_I  {
  unsigned char v1:1;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu1c_BFu0c_I) C1{ Fc:1 Fc:0 Fi}



static void Test_BFu1c_BFu0c_I()
{
  {
    init_simple_test("BFu1c_BFu0c_I");
    static STRUCT_IF_C BFu1c_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_I, BFu1c_BFu0c_I)
//============================================================================


struct  BFu1c_BFu0c_Ip  {
  unsigned char v1:1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu1c_BFu0c_Ip) C1{ Fc:1 Fc:0 Fp}



static void Test_BFu1c_BFu0c_Ip()
{
  {
    init_simple_test("BFu1c_BFu0c_Ip");
    static STRUCT_IF_C BFu1c_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Ip, BFu1c_BFu0c_Ip)
//============================================================================


struct  BFu1c_BFu0c_L  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu1c_BFu0c_L) C1{ Fc:1 Fc:0 FL}



static void Test_BFu1c_BFu0c_L()
{
  {
    init_simple_test("BFu1c_BFu0c_L");
    static STRUCT_IF_C BFu1c_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_L, BFu1c_BFu0c_L)
//============================================================================


struct  BFu1c_BFu0c_S  {
  unsigned char v1:1;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu1c_BFu0c_S) C1{ Fc:1 Fc:0 Fs}



static void Test_BFu1c_BFu0c_S()
{
  {
    init_simple_test("BFu1c_BFu0c_S");
    static STRUCT_IF_C BFu1c_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu1c_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_S, BFu1c_BFu0c_S)
//============================================================================


struct  BFu1c_BFu0c_Uc  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu1c_BFu0c_Uc) C1{ Fc:1 Fc:0 Fc}



static void Test_BFu1c_BFu0c_Uc()
{
  {
    init_simple_test("BFu1c_BFu0c_Uc");
    static STRUCT_IF_C BFu1c_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu1c_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Uc, BFu1c_BFu0c_Uc)
//============================================================================


struct  BFu1c_BFu0c_Ui  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu1c_BFu0c_Ui) C1{ Fc:1 Fc:0 Fi}



static void Test_BFu1c_BFu0c_Ui()
{
  {
    init_simple_test("BFu1c_BFu0c_Ui");
    static STRUCT_IF_C BFu1c_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Ui, BFu1c_BFu0c_Ui)
//============================================================================


struct  BFu1c_BFu0c_Ul  {
  unsigned char v1:1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu1c_BFu0c_Ul) C1{ Fc:1 Fc:0 FL}



static void Test_BFu1c_BFu0c_Ul()
{
  {
    init_simple_test("BFu1c_BFu0c_Ul");
    static STRUCT_IF_C BFu1c_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Ul, BFu1c_BFu0c_Ul)
//============================================================================


struct  BFu1c_BFu0c_Us  {
  unsigned char v1:1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu1c_BFu0c_Us) C1{ Fc:1 Fc:0 Fs}



static void Test_BFu1c_BFu0c_Us()
{
  {
    init_simple_test("BFu1c_BFu0c_Us");
    static STRUCT_IF_C BFu1c_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu1c_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Us, BFu1c_BFu0c_Us)
//============================================================================


struct  BFu1c_BFu0c_Vp  {
  unsigned char v1:1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu1c_BFu0c_Vp) C1{ Fc:1 Fc:0 Fp}



static void Test_BFu1c_BFu0c_Vp()
{
  {
    init_simple_test("BFu1c_BFu0c_Vp");
    static STRUCT_IF_C BFu1c_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0c_Vp, BFu1c_BFu0c_Vp)
//============================================================================


struct  BFu1c_BFu0i  {
  unsigned char v1:1;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu0i) C1{ Fc:1 Fi:0}



static void Test_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu0i");
    static STRUCT_IF_C BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i, BFu1c_BFu0i)
//============================================================================


struct  BFu1c_BFu0i_BFu0c  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu0i_BFu0c) C1{ Fc:1 Fi:0 Fc:0}



static void Test_BFu1c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu0c, BFu1c_BFu0i_BFu0c)
//============================================================================


struct  BFu1c_BFu0i_BFu0i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu0i_BFu0i) C1{ Fc:1 Fi:0 Fi:0}



static void Test_BFu1c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu0i, BFu1c_BFu0i_BFu0i)
//============================================================================


struct  BFu1c_BFu0i_BFu0ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu0i_BFu0ll) C1{ Fc:1 Fi:0 FL:0}



static void Test_BFu1c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu0ll, BFu1c_BFu0i_BFu0ll)
//============================================================================


struct  BFu1c_BFu0i_BFu0s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu0i_BFu0s) C1{ Fc:1 Fi:0 Fs:0}



static void Test_BFu1c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu0s, BFu1c_BFu0i_BFu0s)
//============================================================================


struct  BFu1c_BFu0i_BFu15i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1c_BFu0i_BFu15i) C1{ Fc:1 Fi:0 Fi:15}



static void Test_BFu1c_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu15i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1c_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu15i, BFu1c_BFu0i_BFu15i)
//============================================================================


struct  BFu1c_BFu0i_BFu15ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1c_BFu0i_BFu15ll) C1{ Fc:1 Fi:0 FL:15}



static void Test_BFu1c_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1c_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu15ll, BFu1c_BFu0i_BFu15ll)
//============================================================================


struct  BFu1c_BFu0i_BFu15s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1c_BFu0i_BFu15s) C1{ Fc:1 Fi:0 Fs:15}



static void Test_BFu1c_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu15s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1c_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu15s, BFu1c_BFu0i_BFu15s)
//============================================================================


struct  BFu1c_BFu0i_BFu16i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1c_BFu0i_BFu16i) C1{ Fc:1 Fi:0 Fi:16}



static void Test_BFu1c_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu16i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1c_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu16i, BFu1c_BFu0i_BFu16i)
//============================================================================


struct  BFu1c_BFu0i_BFu16ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1c_BFu0i_BFu16ll) C1{ Fc:1 Fi:0 FL:16}



static void Test_BFu1c_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1c_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu16ll, BFu1c_BFu0i_BFu16ll)
//============================================================================


struct  BFu1c_BFu0i_BFu16s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1c_BFu0i_BFu16s) C1{ Fc:1 Fi:0 Fs:16}



static void Test_BFu1c_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu16s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1c_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu16s, BFu1c_BFu0i_BFu16s)
//============================================================================


struct  BFu1c_BFu0i_BFu17i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1c_BFu0i_BFu17i) C1{ Fc:1 Fi:0 Fi:17}



static void Test_BFu1c_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu17i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1c_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu17i, BFu1c_BFu0i_BFu17i)
//============================================================================


struct  BFu1c_BFu0i_BFu17ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1c_BFu0i_BFu17ll) C1{ Fc:1 Fi:0 FL:17}



static void Test_BFu1c_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1c_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu17ll, BFu1c_BFu0i_BFu17ll)
//============================================================================


struct  BFu1c_BFu0i_BFu1c  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1c_BFu0i_BFu1c) C1{ Fc:1 Fi:0 Fc:1}



static void Test_BFu1c_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu1c");
    static STRUCT_IF_C BFu1c_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu1c_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1c_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu1c, BFu1c_BFu0i_BFu1c)
//============================================================================


struct  BFu1c_BFu0i_BFu1i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1c_BFu0i_BFu1i) C1{ Fc:1 Fi:0 Fi:1}



static void Test_BFu1c_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu1i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1c_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu1i, BFu1c_BFu0i_BFu1i)
//============================================================================


struct  BFu1c_BFu0i_BFu1ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1c_BFu0i_BFu1ll) C1{ Fc:1 Fi:0 FL:1}



static void Test_BFu1c_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1c_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu1ll, BFu1c_BFu0i_BFu1ll)
//============================================================================


struct  BFu1c_BFu0i_BFu1s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1c_BFu0i_BFu1s) C1{ Fc:1 Fi:0 Fs:1}



static void Test_BFu1c_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu1s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1c_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu1s, BFu1c_BFu0i_BFu1s)
//============================================================================


struct  BFu1c_BFu0i_BFu31i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1c_BFu0i_BFu31i) C1{ Fc:1 Fi:0 Fi:31}



static void Test_BFu1c_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu31i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1c_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu31i, BFu1c_BFu0i_BFu31i)
//============================================================================


struct  BFu1c_BFu0i_BFu31ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1c_BFu0i_BFu31ll) C1{ Fc:1 Fi:0 FL:31}



static void Test_BFu1c_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1c_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu31ll, BFu1c_BFu0i_BFu31ll)
//============================================================================


struct  BFu1c_BFu0i_BFu32i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1c_BFu0i_BFu32i) C1{ Fc:1 Fi:0 Fi:32}



static void Test_BFu1c_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu32i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu32i, BFu1c_BFu0i_BFu32i)
//============================================================================


struct  BFu1c_BFu0i_BFu32ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1c_BFu0i_BFu32ll) C1{ Fc:1 Fi:0 FL:32}



static void Test_BFu1c_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu32ll, BFu1c_BFu0i_BFu32ll)
//============================================================================


struct  BFu1c_BFu0i_BFu33  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1c_BFu0i_BFu33) C1{ Fc:1 Fi:0 FL:33}



static void Test_BFu1c_BFu0i_BFu33()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu33");
    static STRUCT_IF_C BFu1c_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1c_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1c_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu33, BFu1c_BFu0i_BFu33)
//============================================================================


struct  BFu1c_BFu0i_BFu7c  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1c_BFu0i_BFu7c) C1{ Fc:1 Fi:0 Fc:7}



static void Test_BFu1c_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu7c");
    static STRUCT_IF_C BFu1c_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu1c_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1c_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu7c, BFu1c_BFu0i_BFu7c)
//============================================================================


struct  BFu1c_BFu0i_BFu7i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1c_BFu0i_BFu7i) C1{ Fc:1 Fi:0 Fi:7}



static void Test_BFu1c_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu7i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1c_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu7i, BFu1c_BFu0i_BFu7i)
//============================================================================


struct  BFu1c_BFu0i_BFu7ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1c_BFu0i_BFu7ll) C1{ Fc:1 Fi:0 FL:7}



static void Test_BFu1c_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1c_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu7ll, BFu1c_BFu0i_BFu7ll)
//============================================================================


struct  BFu1c_BFu0i_BFu7s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1c_BFu0i_BFu7s) C1{ Fc:1 Fi:0 Fs:7}



static void Test_BFu1c_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu7s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1c_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu7s, BFu1c_BFu0i_BFu7s)
//============================================================================


struct  BFu1c_BFu0i_BFu8c  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1c_BFu0i_BFu8c) C1{ Fc:1 Fi:0 Fc:8}



static void Test_BFu1c_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu8c");
    static STRUCT_IF_C BFu1c_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu1c_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1c_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu8c, BFu1c_BFu0i_BFu8c)
//============================================================================


struct  BFu1c_BFu0i_BFu8i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1c_BFu0i_BFu8i) C1{ Fc:1 Fi:0 Fi:8}



static void Test_BFu1c_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu8i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1c_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu8i, BFu1c_BFu0i_BFu8i)
//============================================================================


struct  BFu1c_BFu0i_BFu8ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1c_BFu0i_BFu8ll) C1{ Fc:1 Fi:0 FL:8}



static void Test_BFu1c_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1c_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu8ll, BFu1c_BFu0i_BFu8ll)
//============================================================================


struct  BFu1c_BFu0i_BFu8s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1c_BFu0i_BFu8s) C1{ Fc:1 Fi:0 Fs:8}



static void Test_BFu1c_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu8s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1c_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu8s, BFu1c_BFu0i_BFu8s)
//============================================================================


struct  BFu1c_BFu0i_BFu9i  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1c_BFu0i_BFu9i) C1{ Fc:1 Fi:0 Fi:9}



static void Test_BFu1c_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu9i");
    static STRUCT_IF_C BFu1c_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1c_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu9i, BFu1c_BFu0i_BFu9i)
//============================================================================


struct  BFu1c_BFu0i_BFu9ll  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1c_BFu0i_BFu9ll) C1{ Fc:1 Fi:0 FL:9}



static void Test_BFu1c_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1c_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu9ll, BFu1c_BFu0i_BFu9ll)
//============================================================================


struct  BFu1c_BFu0i_BFu9s  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1c_BFu0i_BFu9s) C1{ Fc:1 Fi:0 Fs:9}



static void Test_BFu1c_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu0i_BFu9s");
    static STRUCT_IF_C BFu1c_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1c_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_BFu9s, BFu1c_BFu0i_BFu9s)
//============================================================================


struct  BFu1c_BFu0i_C  {
  unsigned char v1:1;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu1c_BFu0i_C) C1{ Fc:1 Fi:0 Fc}



static void Test_BFu1c_BFu0i_C()
{
  {
    init_simple_test("BFu1c_BFu0i_C");
    static STRUCT_IF_C BFu1c_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu1c_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_C, BFu1c_BFu0i_C)
//============================================================================


struct  BFu1c_BFu0i_D  {
  unsigned char v1:1;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu1c_BFu0i_D) C1{ Fc:1 Fi:0 FL}



static void Test_BFu1c_BFu0i_D()
{
  {
    init_simple_test("BFu1c_BFu0i_D");
    static STRUCT_IF_C BFu1c_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_D, BFu1c_BFu0i_D)
//============================================================================


struct  BFu1c_BFu0i_F  {
  unsigned char v1:1;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu1c_BFu0i_F) C1{ Fc:1 Fi:0 Fi}



static void Test_BFu1c_BFu0i_F()
{
  {
    init_simple_test("BFu1c_BFu0i_F");
    static STRUCT_IF_C BFu1c_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_F, BFu1c_BFu0i_F)
//============================================================================


struct  BFu1c_BFu0i_I  {
  unsigned char v1:1;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu1c_BFu0i_I) C1{ Fc:1 Fi:0 Fi}



static void Test_BFu1c_BFu0i_I()
{
  {
    init_simple_test("BFu1c_BFu0i_I");
    static STRUCT_IF_C BFu1c_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_I, BFu1c_BFu0i_I)
//============================================================================


struct  BFu1c_BFu0i_Ip  {
  unsigned char v1:1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu1c_BFu0i_Ip) C1{ Fc:1 Fi:0 Fp}



static void Test_BFu1c_BFu0i_Ip()
{
  {
    init_simple_test("BFu1c_BFu0i_Ip");
    static STRUCT_IF_C BFu1c_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Ip, BFu1c_BFu0i_Ip)
//============================================================================


struct  BFu1c_BFu0i_L  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu1c_BFu0i_L) C1{ Fc:1 Fi:0 FL}



static void Test_BFu1c_BFu0i_L()
{
  {
    init_simple_test("BFu1c_BFu0i_L");
    static STRUCT_IF_C BFu1c_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_L, BFu1c_BFu0i_L)
//============================================================================


struct  BFu1c_BFu0i_S  {
  unsigned char v1:1;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu1c_BFu0i_S) C1{ Fc:1 Fi:0 Fs}



static void Test_BFu1c_BFu0i_S()
{
  {
    init_simple_test("BFu1c_BFu0i_S");
    static STRUCT_IF_C BFu1c_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_S, BFu1c_BFu0i_S)
//============================================================================


struct  BFu1c_BFu0i_Uc  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu1c_BFu0i_Uc) C1{ Fc:1 Fi:0 Fc}



static void Test_BFu1c_BFu0i_Uc()
{
  {
    init_simple_test("BFu1c_BFu0i_Uc");
    static STRUCT_IF_C BFu1c_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(BFu1c_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Uc, BFu1c_BFu0i_Uc)
//============================================================================


struct  BFu1c_BFu0i_Ui  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu1c_BFu0i_Ui) C1{ Fc:1 Fi:0 Fi}



static void Test_BFu1c_BFu0i_Ui()
{
  {
    init_simple_test("BFu1c_BFu0i_Ui");
    static STRUCT_IF_C BFu1c_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Ui, BFu1c_BFu0i_Ui)
//============================================================================


struct  BFu1c_BFu0i_Ul  {
  unsigned char v1:1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu1c_BFu0i_Ul) C1{ Fc:1 Fi:0 FL}



static void Test_BFu1c_BFu0i_Ul()
{
  {
    init_simple_test("BFu1c_BFu0i_Ul");
    static STRUCT_IF_C BFu1c_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Ul, BFu1c_BFu0i_Ul)
//============================================================================


struct  BFu1c_BFu0i_Us  {
  unsigned char v1:1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu1c_BFu0i_Us) C1{ Fc:1 Fi:0 Fs}



static void Test_BFu1c_BFu0i_Us()
{
  {
    init_simple_test("BFu1c_BFu0i_Us");
    static STRUCT_IF_C BFu1c_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1c_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Us, BFu1c_BFu0i_Us)
//============================================================================


struct  BFu1c_BFu0i_Vp  {
  unsigned char v1:1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu1c_BFu0i_Vp) C1{ Fc:1 Fi:0 Fp}



static void Test_BFu1c_BFu0i_Vp()
{
  {
    init_simple_test("BFu1c_BFu0i_Vp");
    static STRUCT_IF_C BFu1c_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0i_Vp, BFu1c_BFu0i_Vp)
//============================================================================


struct  BFu1c_BFu0ll  {
  unsigned char v1:1;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu0ll) C1{ Fc:1 FL:0}



static void Test_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll, BFu1c_BFu0ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu0c  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu0ll_BFu0c) C1{ Fc:1 FL:0 Fc:0}



static void Test_BFu1c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu0c, BFu1c_BFu0ll_BFu0c)
//============================================================================


struct  BFu1c_BFu0ll_BFu0i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu0ll_BFu0i) C1{ Fc:1 FL:0 Fi:0}



static void Test_BFu1c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu0i, BFu1c_BFu0ll_BFu0i)
//============================================================================


struct  BFu1c_BFu0ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu0ll_BFu0ll) C1{ Fc:1 FL:0 FL:0}



static void Test_BFu1c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu0ll, BFu1c_BFu0ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu0s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu0ll_BFu0s) C1{ Fc:1 FL:0 Fs:0}



static void Test_BFu1c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu0s, BFu1c_BFu0ll_BFu0s)
//============================================================================


struct  BFu1c_BFu0ll_BFu15i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1c_BFu0ll_BFu15i) C1{ Fc:1 FL:0 Fi:15}



static void Test_BFu1c_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1c_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu15i, BFu1c_BFu0ll_BFu15i)
//============================================================================


struct  BFu1c_BFu0ll_BFu15ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1c_BFu0ll_BFu15ll) C1{ Fc:1 FL:0 FL:15}



static void Test_BFu1c_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1c_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu15ll, BFu1c_BFu0ll_BFu15ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu15s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1c_BFu0ll_BFu15s) C1{ Fc:1 FL:0 Fs:15}



static void Test_BFu1c_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1c_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu15s, BFu1c_BFu0ll_BFu15s)
//============================================================================


struct  BFu1c_BFu0ll_BFu16i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1c_BFu0ll_BFu16i) C1{ Fc:1 FL:0 Fi:16}



static void Test_BFu1c_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1c_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu16i, BFu1c_BFu0ll_BFu16i)
//============================================================================


struct  BFu1c_BFu0ll_BFu16ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1c_BFu0ll_BFu16ll) C1{ Fc:1 FL:0 FL:16}



static void Test_BFu1c_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1c_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu16ll, BFu1c_BFu0ll_BFu16ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu16s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1c_BFu0ll_BFu16s) C1{ Fc:1 FL:0 Fs:16}



static void Test_BFu1c_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1c_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu16s, BFu1c_BFu0ll_BFu16s)
//============================================================================


struct  BFu1c_BFu0ll_BFu17i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1c_BFu0ll_BFu17i) C1{ Fc:1 FL:0 Fi:17}



static void Test_BFu1c_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu1c_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu17i, BFu1c_BFu0ll_BFu17i)
//============================================================================


struct  BFu1c_BFu0ll_BFu17ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1c_BFu0ll_BFu17ll) C1{ Fc:1 FL:0 FL:17}



static void Test_BFu1c_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu1c_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu17ll, BFu1c_BFu0ll_BFu17ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu1c  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1c_BFu0ll_BFu1c) C1{ Fc:1 FL:0 Fc:1}



static void Test_BFu1c_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu1c_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1c_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu1c, BFu1c_BFu0ll_BFu1c)
//============================================================================


struct  BFu1c_BFu0ll_BFu1i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1c_BFu0ll_BFu1i) C1{ Fc:1 FL:0 Fi:1}



static void Test_BFu1c_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1c_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu1i, BFu1c_BFu0ll_BFu1i)
//============================================================================


struct  BFu1c_BFu0ll_BFu1ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1c_BFu0ll_BFu1ll) C1{ Fc:1 FL:0 FL:1}



static void Test_BFu1c_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1c_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu1ll, BFu1c_BFu0ll_BFu1ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu1s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1c_BFu0ll_BFu1s) C1{ Fc:1 FL:0 Fs:1}



static void Test_BFu1c_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1c_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu1s, BFu1c_BFu0ll_BFu1s)
//============================================================================


struct  BFu1c_BFu0ll_BFu31i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1c_BFu0ll_BFu31i) C1{ Fc:1 FL:0 Fi:31}



static void Test_BFu1c_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu1c_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu31i, BFu1c_BFu0ll_BFu31i)
//============================================================================


struct  BFu1c_BFu0ll_BFu31ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1c_BFu0ll_BFu31ll) C1{ Fc:1 FL:0 FL:31}



static void Test_BFu1c_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu1c_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu31ll, BFu1c_BFu0ll_BFu31ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu32i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1c_BFu0ll_BFu32i) C1{ Fc:1 FL:0 Fi:32}



static void Test_BFu1c_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu1c_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu32i, BFu1c_BFu0ll_BFu32i)
//============================================================================


struct  BFu1c_BFu0ll_BFu32ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1c_BFu0ll_BFu32ll) C1{ Fc:1 FL:0 FL:32}



static void Test_BFu1c_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu1c_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu32ll, BFu1c_BFu0ll_BFu32ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu33  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1c_BFu0ll_BFu33) C1{ Fc:1 FL:0 FL:33}



static void Test_BFu1c_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu33");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1c_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1c_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu33, BFu1c_BFu0ll_BFu33)
//============================================================================


struct  BFu1c_BFu0ll_BFu7c  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1c_BFu0ll_BFu7c) C1{ Fc:1 FL:0 Fc:7}



static void Test_BFu1c_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu1c_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1c_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu7c, BFu1c_BFu0ll_BFu7c)
//============================================================================


struct  BFu1c_BFu0ll_BFu7i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1c_BFu0ll_BFu7i) C1{ Fc:1 FL:0 Fi:7}



static void Test_BFu1c_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1c_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu7i, BFu1c_BFu0ll_BFu7i)
//============================================================================


struct  BFu1c_BFu0ll_BFu7ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1c_BFu0ll_BFu7ll) C1{ Fc:1 FL:0 FL:7}



static void Test_BFu1c_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1c_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu7ll, BFu1c_BFu0ll_BFu7ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu7s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1c_BFu0ll_BFu7s) C1{ Fc:1 FL:0 Fs:7}



static void Test_BFu1c_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1c_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu7s, BFu1c_BFu0ll_BFu7s)
//============================================================================


struct  BFu1c_BFu0ll_BFu8c  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1c_BFu0ll_BFu8c) C1{ Fc:1 FL:0 Fc:8}



static void Test_BFu1c_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu1c_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1c_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu8c, BFu1c_BFu0ll_BFu8c)
//============================================================================


struct  BFu1c_BFu0ll_BFu8i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1c_BFu0ll_BFu8i) C1{ Fc:1 FL:0 Fi:8}



static void Test_BFu1c_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1c_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu8i, BFu1c_BFu0ll_BFu8i)
//============================================================================


struct  BFu1c_BFu0ll_BFu8ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1c_BFu0ll_BFu8ll) C1{ Fc:1 FL:0 FL:8}



static void Test_BFu1c_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1c_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu8ll, BFu1c_BFu0ll_BFu8ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu8s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1c_BFu0ll_BFu8s) C1{ Fc:1 FL:0 Fs:8}



static void Test_BFu1c_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1c_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu8s, BFu1c_BFu0ll_BFu8s)
//============================================================================


struct  BFu1c_BFu0ll_BFu9i  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1c_BFu0ll_BFu9i) C1{ Fc:1 FL:0 Fi:9}



static void Test_BFu1c_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1c_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu9i, BFu1c_BFu0ll_BFu9i)
//============================================================================


struct  BFu1c_BFu0ll_BFu9ll  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1c_BFu0ll_BFu9ll) C1{ Fc:1 FL:0 FL:9}



static void Test_BFu1c_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1c_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu9ll, BFu1c_BFu0ll_BFu9ll)
//============================================================================


struct  BFu1c_BFu0ll_BFu9s  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1c_BFu0ll_BFu9s) C1{ Fc:1 FL:0 Fs:9}



static void Test_BFu1c_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu1c_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1c_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_BFu9s, BFu1c_BFu0ll_BFu9s)
//============================================================================


struct  BFu1c_BFu0ll_C  {
  unsigned char v1:1;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu1c_BFu0ll_C) C1{ Fc:1 FL:0 Fc}



static void Test_BFu1c_BFu0ll_C()
{
  {
    init_simple_test("BFu1c_BFu0ll_C");
    static STRUCT_IF_C BFu1c_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu1c_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_C, BFu1c_BFu0ll_C)
//============================================================================


struct  BFu1c_BFu0ll_D  {
  unsigned char v1:1;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu1c_BFu0ll_D) C1{ Fc:1 FL:0 FL}



static void Test_BFu1c_BFu0ll_D()
{
  {
    init_simple_test("BFu1c_BFu0ll_D");
    static STRUCT_IF_C BFu1c_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_D, BFu1c_BFu0ll_D)
//============================================================================


struct  BFu1c_BFu0ll_F  {
  unsigned char v1:1;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu1c_BFu0ll_F) C1{ Fc:1 FL:0 Fi}



static void Test_BFu1c_BFu0ll_F()
{
  {
    init_simple_test("BFu1c_BFu0ll_F");
    static STRUCT_IF_C BFu1c_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_F, BFu1c_BFu0ll_F)
//============================================================================


struct  BFu1c_BFu0ll_I  {
  unsigned char v1:1;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu1c_BFu0ll_I) C1{ Fc:1 FL:0 Fi}



static void Test_BFu1c_BFu0ll_I()
{
  {
    init_simple_test("BFu1c_BFu0ll_I");
    static STRUCT_IF_C BFu1c_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_I, BFu1c_BFu0ll_I)
//============================================================================


struct  BFu1c_BFu0ll_Ip  {
  unsigned char v1:1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu1c_BFu0ll_Ip) C1{ Fc:1 FL:0 Fp}



static void Test_BFu1c_BFu0ll_Ip()
{
  {
    init_simple_test("BFu1c_BFu0ll_Ip");
    static STRUCT_IF_C BFu1c_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Ip, BFu1c_BFu0ll_Ip)
//============================================================================


struct  BFu1c_BFu0ll_L  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu1c_BFu0ll_L) C1{ Fc:1 FL:0 FL}



static void Test_BFu1c_BFu0ll_L()
{
  {
    init_simple_test("BFu1c_BFu0ll_L");
    static STRUCT_IF_C BFu1c_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_L, BFu1c_BFu0ll_L)
//============================================================================


struct  BFu1c_BFu0ll_S  {
  unsigned char v1:1;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu1c_BFu0ll_S) C1{ Fc:1 FL:0 Fs}



static void Test_BFu1c_BFu0ll_S()
{
  {
    init_simple_test("BFu1c_BFu0ll_S");
    static STRUCT_IF_C BFu1c_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_S, BFu1c_BFu0ll_S)
//============================================================================


struct  BFu1c_BFu0ll_Uc  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu1c_BFu0ll_Uc) C1{ Fc:1 FL:0 Fc}



static void Test_BFu1c_BFu0ll_Uc()
{
  {
    init_simple_test("BFu1c_BFu0ll_Uc");
    static STRUCT_IF_C BFu1c_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(BFu1c_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Uc, BFu1c_BFu0ll_Uc)
//============================================================================


struct  BFu1c_BFu0ll_Ui  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu1c_BFu0ll_Ui) C1{ Fc:1 FL:0 Fi}



static void Test_BFu1c_BFu0ll_Ui()
{
  {
    init_simple_test("BFu1c_BFu0ll_Ui");
    static STRUCT_IF_C BFu1c_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1c_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Ui, BFu1c_BFu0ll_Ui)
//============================================================================


struct  BFu1c_BFu0ll_Ul  {
  unsigned char v1:1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu1c_BFu0ll_Ul) C1{ Fc:1 FL:0 FL}



static void Test_BFu1c_BFu0ll_Ul()
{
  {
    init_simple_test("BFu1c_BFu0ll_Ul");
    static STRUCT_IF_C BFu1c_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Ul, BFu1c_BFu0ll_Ul)
//============================================================================


struct  BFu1c_BFu0ll_Us  {
  unsigned char v1:1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu1c_BFu0ll_Us) C1{ Fc:1 FL:0 Fs}



static void Test_BFu1c_BFu0ll_Us()
{
  {
    init_simple_test("BFu1c_BFu0ll_Us");
    static STRUCT_IF_C BFu1c_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu1c_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Us, BFu1c_BFu0ll_Us)
//============================================================================


struct  BFu1c_BFu0ll_Vp  {
  unsigned char v1:1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu1c_BFu0ll_Vp) C1{ Fc:1 FL:0 Fp}



static void Test_BFu1c_BFu0ll_Vp()
{
  {
    init_simple_test("BFu1c_BFu0ll_Vp");
    static STRUCT_IF_C BFu1c_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0ll_Vp, BFu1c_BFu0ll_Vp)
//============================================================================


struct  BFu1c_BFu0s  {
  unsigned char v1:1;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu0s) C1{ Fc:1 Fs:0}



static void Test_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu0s");
    static STRUCT_IF_C BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s, BFu1c_BFu0s)
//============================================================================


struct  BFu1c_BFu0s_BFu0c  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu0s_BFu0c) C1{ Fc:1 Fs:0 Fc:0}



static void Test_BFu1c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu0c, BFu1c_BFu0s_BFu0c)
//============================================================================


struct  BFu1c_BFu0s_BFu0i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu0s_BFu0i) C1{ Fc:1 Fs:0 Fi:0}



static void Test_BFu1c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu0i, BFu1c_BFu0s_BFu0i)
//============================================================================


struct  BFu1c_BFu0s_BFu0ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu0s_BFu0ll) C1{ Fc:1 Fs:0 FL:0}



static void Test_BFu1c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu0ll, BFu1c_BFu0s_BFu0ll)
//============================================================================


struct  BFu1c_BFu0s_BFu0s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu0s_BFu0s) C1{ Fc:1 Fs:0 Fs:0}



static void Test_BFu1c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu0s, BFu1c_BFu0s_BFu0s)
//============================================================================


struct  BFu1c_BFu0s_BFu15i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1c_BFu0s_BFu15i) C1{ Fc:1 Fs:0 Fi:15}



static void Test_BFu1c_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu15i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1c_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu15i, BFu1c_BFu0s_BFu15i)
//============================================================================


struct  BFu1c_BFu0s_BFu15ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1c_BFu0s_BFu15ll) C1{ Fc:1 Fs:0 FL:15}



static void Test_BFu1c_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1c_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu15ll, BFu1c_BFu0s_BFu15ll)
//============================================================================


struct  BFu1c_BFu0s_BFu15s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1c_BFu0s_BFu15s) C1{ Fc:1 Fs:0 Fs:15}



static void Test_BFu1c_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu15s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1c_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu15s, BFu1c_BFu0s_BFu15s)
//============================================================================


struct  BFu1c_BFu0s_BFu16i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1c_BFu0s_BFu16i) C1{ Fc:1 Fs:0 Fi:16}



static void Test_BFu1c_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu16i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu16i, BFu1c_BFu0s_BFu16i)
//============================================================================


struct  BFu1c_BFu0s_BFu16ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1c_BFu0s_BFu16ll) C1{ Fc:1 Fs:0 FL:16}



static void Test_BFu1c_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu16ll, BFu1c_BFu0s_BFu16ll)
//============================================================================


struct  BFu1c_BFu0s_BFu16s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1c_BFu0s_BFu16s) C1{ Fc:1 Fs:0 Fs:16}



static void Test_BFu1c_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu16s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu16s, BFu1c_BFu0s_BFu16s)
//============================================================================


struct  BFu1c_BFu0s_BFu17i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1c_BFu0s_BFu17i) C1{ Fc:1 Fs:0 Fi:17}



static void Test_BFu1c_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu17i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1c_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu17i, BFu1c_BFu0s_BFu17i)
//============================================================================


struct  BFu1c_BFu0s_BFu17ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1c_BFu0s_BFu17ll) C1{ Fc:1 Fs:0 FL:17}



static void Test_BFu1c_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu1c_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu1c_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu17ll, BFu1c_BFu0s_BFu17ll)
//============================================================================


struct  BFu1c_BFu0s_BFu1c  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1c_BFu0s_BFu1c) C1{ Fc:1 Fs:0 Fc:1}



static void Test_BFu1c_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu1c");
    static STRUCT_IF_C BFu1c_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu1c_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1c_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu1c, BFu1c_BFu0s_BFu1c)
//============================================================================


struct  BFu1c_BFu0s_BFu1i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1c_BFu0s_BFu1i) C1{ Fc:1 Fs:0 Fi:1}



static void Test_BFu1c_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu1i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1c_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu1i, BFu1c_BFu0s_BFu1i)
//============================================================================


struct  BFu1c_BFu0s_BFu1ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1c_BFu0s_BFu1ll) C1{ Fc:1 Fs:0 FL:1}



static void Test_BFu1c_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1c_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu1ll, BFu1c_BFu0s_BFu1ll)
//============================================================================


struct  BFu1c_BFu0s_BFu1s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1c_BFu0s_BFu1s) C1{ Fc:1 Fs:0 Fs:1}



static void Test_BFu1c_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu1s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1c_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu1s, BFu1c_BFu0s_BFu1s)
//============================================================================


struct  BFu1c_BFu0s_BFu31i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1c_BFu0s_BFu31i) C1{ Fc:1 Fs:0 Fi:31}



static void Test_BFu1c_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu31i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1c_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu31i, BFu1c_BFu0s_BFu31i)
//============================================================================


struct  BFu1c_BFu0s_BFu31ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1c_BFu0s_BFu31ll) C1{ Fc:1 Fs:0 FL:31}



static void Test_BFu1c_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu1c_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu1c_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu31ll, BFu1c_BFu0s_BFu31ll)
//============================================================================


struct  BFu1c_BFu0s_BFu32i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1c_BFu0s_BFu32i) C1{ Fc:1 Fs:0 Fi:32}



static void Test_BFu1c_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu32i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu32i, BFu1c_BFu0s_BFu32i)
//============================================================================


struct  BFu1c_BFu0s_BFu32ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1c_BFu0s_BFu32ll) C1{ Fc:1 Fs:0 FL:32}



static void Test_BFu1c_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu1c_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu32ll, BFu1c_BFu0s_BFu32ll)
//============================================================================


struct  BFu1c_BFu0s_BFu33  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1c_BFu0s_BFu33) C1{ Fc:1 Fs:0 FL:33}



static void Test_BFu1c_BFu0s_BFu33()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu33");
    static STRUCT_IF_C BFu1c_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu1c_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu1c_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu33, BFu1c_BFu0s_BFu33)
//============================================================================


struct  BFu1c_BFu0s_BFu7c  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1c_BFu0s_BFu7c) C1{ Fc:1 Fs:0 Fc:7}



static void Test_BFu1c_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu7c");
    static STRUCT_IF_C BFu1c_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu1c_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1c_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu7c, BFu1c_BFu0s_BFu7c)
//============================================================================


struct  BFu1c_BFu0s_BFu7i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1c_BFu0s_BFu7i) C1{ Fc:1 Fs:0 Fi:7}



static void Test_BFu1c_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu7i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1c_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu7i, BFu1c_BFu0s_BFu7i)
//============================================================================


struct  BFu1c_BFu0s_BFu7ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1c_BFu0s_BFu7ll) C1{ Fc:1 Fs:0 FL:7}



static void Test_BFu1c_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1c_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu7ll, BFu1c_BFu0s_BFu7ll)
//============================================================================


struct  BFu1c_BFu0s_BFu7s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1c_BFu0s_BFu7s) C1{ Fc:1 Fs:0 Fs:7}



static void Test_BFu1c_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu7s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1c_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu7s, BFu1c_BFu0s_BFu7s)
//============================================================================


struct  BFu1c_BFu0s_BFu8c  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1c_BFu0s_BFu8c) C1{ Fc:1 Fs:0 Fc:8}



static void Test_BFu1c_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu8c");
    static STRUCT_IF_C BFu1c_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu1c_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1c_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu8c, BFu1c_BFu0s_BFu8c)
//============================================================================


struct  BFu1c_BFu0s_BFu8i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1c_BFu0s_BFu8i) C1{ Fc:1 Fs:0 Fi:8}



static void Test_BFu1c_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu8i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1c_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu8i, BFu1c_BFu0s_BFu8i)
//============================================================================


struct  BFu1c_BFu0s_BFu8ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1c_BFu0s_BFu8ll) C1{ Fc:1 Fs:0 FL:8}



static void Test_BFu1c_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1c_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu8ll, BFu1c_BFu0s_BFu8ll)
//============================================================================


struct  BFu1c_BFu0s_BFu8s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1c_BFu0s_BFu8s) C1{ Fc:1 Fs:0 Fs:8}



static void Test_BFu1c_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu8s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1c_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu8s, BFu1c_BFu0s_BFu8s)
//============================================================================


struct  BFu1c_BFu0s_BFu9i  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1c_BFu0s_BFu9i) C1{ Fc:1 Fs:0 Fi:9}



static void Test_BFu1c_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu9i");
    static STRUCT_IF_C BFu1c_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1c_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu9i, BFu1c_BFu0s_BFu9i)
//============================================================================


struct  BFu1c_BFu0s_BFu9ll  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1c_BFu0s_BFu9ll) C1{ Fc:1 Fs:0 FL:9}



static void Test_BFu1c_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu1c_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1c_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu9ll, BFu1c_BFu0s_BFu9ll)
//============================================================================


struct  BFu1c_BFu0s_BFu9s  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1c_BFu0s_BFu9s) C1{ Fc:1 Fs:0 Fs:9}



static void Test_BFu1c_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu1c_BFu0s_BFu9s");
    static STRUCT_IF_C BFu1c_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1c_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_BFu9s, BFu1c_BFu0s_BFu9s)
//============================================================================


struct  BFu1c_BFu0s_C  {
  unsigned char v1:1;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu1c_BFu0s_C) C1{ Fc:1 Fs:0 Fc}



static void Test_BFu1c_BFu0s_C()
{
  {
    init_simple_test("BFu1c_BFu0s_C");
    static STRUCT_IF_C BFu1c_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu1c_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu1c_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_C, BFu1c_BFu0s_C)
//============================================================================


struct  BFu1c_BFu0s_D  {
  unsigned char v1:1;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu1c_BFu0s_D) C1{ Fc:1 Fs:0 FL}



static void Test_BFu1c_BFu0s_D()
{
  {
    init_simple_test("BFu1c_BFu0s_D");
    static STRUCT_IF_C BFu1c_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_D, BFu1c_BFu0s_D)
//============================================================================


struct  BFu1c_BFu0s_F  {
  unsigned char v1:1;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu1c_BFu0s_F) C1{ Fc:1 Fs:0 Fi}



static void Test_BFu1c_BFu0s_F()
{
  {
    init_simple_test("BFu1c_BFu0s_F");
    static STRUCT_IF_C BFu1c_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_F, BFu1c_BFu0s_F)
//============================================================================


struct  BFu1c_BFu0s_I  {
  unsigned char v1:1;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu1c_BFu0s_I) C1{ Fc:1 Fs:0 Fi}



static void Test_BFu1c_BFu0s_I()
{
  {
    init_simple_test("BFu1c_BFu0s_I");
    static STRUCT_IF_C BFu1c_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_I, BFu1c_BFu0s_I)
//============================================================================


struct  BFu1c_BFu0s_Ip  {
  unsigned char v1:1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu1c_BFu0s_Ip) C1{ Fc:1 Fs:0 Fp}



static void Test_BFu1c_BFu0s_Ip()
{
  {
    init_simple_test("BFu1c_BFu0s_Ip");
    static STRUCT_IF_C BFu1c_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Ip, BFu1c_BFu0s_Ip)
//============================================================================


struct  BFu1c_BFu0s_L  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu1c_BFu0s_L) C1{ Fc:1 Fs:0 FL}



static void Test_BFu1c_BFu0s_L()
{
  {
    init_simple_test("BFu1c_BFu0s_L");
    static STRUCT_IF_C BFu1c_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_L, BFu1c_BFu0s_L)
//============================================================================


struct  BFu1c_BFu0s_S  {
  unsigned char v1:1;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu1c_BFu0s_S) C1{ Fc:1 Fs:0 Fs}



static void Test_BFu1c_BFu0s_S()
{
  {
    init_simple_test("BFu1c_BFu0s_S");
    static STRUCT_IF_C BFu1c_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu1c_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_S, BFu1c_BFu0s_S)
//============================================================================


struct  BFu1c_BFu0s_Uc  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu1c_BFu0s_Uc) C1{ Fc:1 Fs:0 Fc}



static void Test_BFu1c_BFu0s_Uc()
{
  {
    init_simple_test("BFu1c_BFu0s_Uc");
    static STRUCT_IF_C BFu1c_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(BFu1c_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu1c_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Uc, BFu1c_BFu0s_Uc)
//============================================================================


struct  BFu1c_BFu0s_Ui  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu1c_BFu0s_Ui) C1{ Fc:1 Fs:0 Fi}



static void Test_BFu1c_BFu0s_Ui()
{
  {
    init_simple_test("BFu1c_BFu0s_Ui");
    static STRUCT_IF_C BFu1c_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu1c_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Ui, BFu1c_BFu0s_Ui)
//============================================================================


struct  BFu1c_BFu0s_Ul  {
  unsigned char v1:1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu1c_BFu0s_Ul) C1{ Fc:1 Fs:0 FL}



static void Test_BFu1c_BFu0s_Ul()
{
  {
    init_simple_test("BFu1c_BFu0s_Ul");
    static STRUCT_IF_C BFu1c_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Ul, BFu1c_BFu0s_Ul)
//============================================================================


struct  BFu1c_BFu0s_Us  {
  unsigned char v1:1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu1c_BFu0s_Us) C1{ Fc:1 Fs:0 Fs}



static void Test_BFu1c_BFu0s_Us()
{
  {
    init_simple_test("BFu1c_BFu0s_Us");
    static STRUCT_IF_C BFu1c_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu0s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu1c_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Us, BFu1c_BFu0s_Us)
//============================================================================


struct  BFu1c_BFu0s_Vp  {
  unsigned char v1:1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu1c_BFu0s_Vp) C1{ Fc:1 Fs:0 Fp}



static void Test_BFu1c_BFu0s_Vp()
{
  {
    init_simple_test("BFu1c_BFu0s_Vp");
    static STRUCT_IF_C BFu1c_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu0s_Vp, BFu1c_BFu0s_Vp)
//============================================================================


struct  BFu1c_BFu15i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu15i_BFu0c) C1{ Fc:1 Fi:15 Fc:0}



static void Test_BFu1c_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu0c, BFu1c_BFu15i_BFu0c)
//============================================================================


struct  BFu1c_BFu15i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu15i_BFu0i) C1{ Fc:1 Fi:15 Fi:0}



static void Test_BFu1c_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu0i, BFu1c_BFu15i_BFu0i)
//============================================================================


struct  BFu1c_BFu15i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu15i_BFu0ll) C1{ Fc:1 Fi:15 FL:0}



static void Test_BFu1c_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu0ll, BFu1c_BFu15i_BFu0ll)
//============================================================================


struct  BFu1c_BFu15i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu15i_BFu0s) C1{ Fc:1 Fi:15 Fs:0}



static void Test_BFu1c_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu15i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15i_BFu0s, BFu1c_BFu15i_BFu0s)
//============================================================================


struct  BFu1c_BFu15ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu15ll_BFu0c) C1{ Fc:1 FL:15 Fc:0}



static void Test_BFu1c_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu0c, BFu1c_BFu15ll_BFu0c)
//============================================================================


struct  BFu1c_BFu15ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu15ll_BFu0i) C1{ Fc:1 FL:15 Fi:0}



static void Test_BFu1c_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu0i, BFu1c_BFu15ll_BFu0i)
//============================================================================


struct  BFu1c_BFu15ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu15ll_BFu0ll) C1{ Fc:1 FL:15 FL:0}



static void Test_BFu1c_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu0ll, BFu1c_BFu15ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu15ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu15ll_BFu0s) C1{ Fc:1 FL:15 Fs:0}



static void Test_BFu1c_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15ll_BFu0s, BFu1c_BFu15ll_BFu0s)
//============================================================================


struct  BFu1c_BFu15s_BFu0c  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu15s_BFu0c) C1{ Fc:1 Fs:15 Fc:0}



static void Test_BFu1c_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu15s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu15s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu0c, BFu1c_BFu15s_BFu0c)
//============================================================================


struct  BFu1c_BFu15s_BFu0i  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu15s_BFu0i) C1{ Fc:1 Fs:15 Fi:0}



static void Test_BFu1c_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu0i, BFu1c_BFu15s_BFu0i)
//============================================================================


struct  BFu1c_BFu15s_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu15s_BFu0ll) C1{ Fc:1 Fs:15 FL:0}



static void Test_BFu1c_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu0ll, BFu1c_BFu15s_BFu0ll)
//============================================================================


struct  BFu1c_BFu15s_BFu0s  {
  unsigned char v1:1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu15s_BFu0s) C1{ Fc:1 Fs:15 Fs:0}



static void Test_BFu1c_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu15s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu15s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu15s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu15s_BFu0s, BFu1c_BFu15s_BFu0s)
//============================================================================


struct  BFu1c_BFu16i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu16i_BFu0c) C1{ Fc:1 Fi:16 Fc:0}



static void Test_BFu1c_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu0c, BFu1c_BFu16i_BFu0c)
//============================================================================


struct  BFu1c_BFu16i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu16i_BFu0i) C1{ Fc:1 Fi:16 Fi:0}



static void Test_BFu1c_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu0i, BFu1c_BFu16i_BFu0i)
//============================================================================


struct  BFu1c_BFu16i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu16i_BFu0ll) C1{ Fc:1 Fi:16 FL:0}



static void Test_BFu1c_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu0ll, BFu1c_BFu16i_BFu0ll)
//============================================================================


struct  BFu1c_BFu16i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu16i_BFu0s) C1{ Fc:1 Fi:16 Fs:0}



static void Test_BFu1c_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu16i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16i_BFu0s, BFu1c_BFu16i_BFu0s)
//============================================================================


struct  BFu1c_BFu16ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu16ll_BFu0c) C1{ Fc:1 FL:16 Fc:0}



static void Test_BFu1c_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu0c, BFu1c_BFu16ll_BFu0c)
//============================================================================


struct  BFu1c_BFu16ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu16ll_BFu0i) C1{ Fc:1 FL:16 Fi:0}



static void Test_BFu1c_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu0i, BFu1c_BFu16ll_BFu0i)
//============================================================================


struct  BFu1c_BFu16ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu16ll_BFu0ll) C1{ Fc:1 FL:16 FL:0}



static void Test_BFu1c_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu0ll, BFu1c_BFu16ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu16ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu16ll_BFu0s) C1{ Fc:1 FL:16 Fs:0}



static void Test_BFu1c_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16ll_BFu0s, BFu1c_BFu16ll_BFu0s)
//============================================================================


struct  BFu1c_BFu16s_BFu0c  {
  unsigned char v1:1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu16s_BFu0c) C1{ Fc:1 Fs:16 Fc:0}



static void Test_BFu1c_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu16s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16s_BFu0c, BFu1c_BFu16s_BFu0c)
//============================================================================


struct  BFu1c_BFu16s_BFu0i  {
  unsigned char v1:1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu16s_BFu0i) C1{ Fc:1 Fs:16 Fi:0}



static void Test_BFu1c_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu16s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16s_BFu0i, BFu1c_BFu16s_BFu0i)
//============================================================================


struct  BFu1c_BFu16s_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu16s_BFu0ll) C1{ Fc:1 Fs:16 FL:0}



static void Test_BFu1c_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16s_BFu0ll, BFu1c_BFu16s_BFu0ll)
//============================================================================


struct  BFu1c_BFu16s_BFu0s  {
  unsigned char v1:1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu16s_BFu0s) C1{ Fc:1 Fs:16 Fs:0}



static void Test_BFu1c_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu16s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu16s_BFu0s, BFu1c_BFu16s_BFu0s)
//============================================================================


struct  BFu1c_BFu17i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu17i_BFu0c) C1{ Fc:1 Fi:17 Fc:0}



static void Test_BFu1c_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu17i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17i_BFu0c, BFu1c_BFu17i_BFu0c)
//============================================================================


struct  BFu1c_BFu17i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu17i_BFu0i) C1{ Fc:1 Fi:17 Fi:0}



static void Test_BFu1c_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu17i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17i_BFu0i, BFu1c_BFu17i_BFu0i)
//============================================================================


struct  BFu1c_BFu17i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu17i_BFu0ll) C1{ Fc:1 Fi:17 FL:0}



static void Test_BFu1c_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17i_BFu0ll, BFu1c_BFu17i_BFu0ll)
//============================================================================


struct  BFu1c_BFu17i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu17i_BFu0s) C1{ Fc:1 Fi:17 Fs:0}



static void Test_BFu1c_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu17i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17i_BFu0s, BFu1c_BFu17i_BFu0s)
//============================================================================


struct  BFu1c_BFu17ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu17ll_BFu0c) C1{ Fc:1 FL:17 Fc:0}



static void Test_BFu1c_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17ll_BFu0c, BFu1c_BFu17ll_BFu0c)
//============================================================================


struct  BFu1c_BFu17ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu17ll_BFu0i) C1{ Fc:1 FL:17 Fi:0}



static void Test_BFu1c_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17ll_BFu0i, BFu1c_BFu17ll_BFu0i)
//============================================================================


struct  BFu1c_BFu17ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu17ll_BFu0ll) C1{ Fc:1 FL:17 FL:0}



static void Test_BFu1c_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17ll_BFu0ll, BFu1c_BFu17ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu17ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu17ll_BFu0s) C1{ Fc:1 FL:17 Fs:0}



static void Test_BFu1c_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu17ll_BFu0s, BFu1c_BFu17ll_BFu0s)
//============================================================================


struct  BFu1c_BFu1c_BFu0c  {
  unsigned char v1:1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu1c_BFu0c) C1{ Fc:1 Fc:1 Fc:0}



static void Test_BFu1c_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu1c_BFu0c");
    static STRUCT_IF_C BFu1c_BFu1c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1c_BFu0c, BFu1c_BFu1c_BFu0c)
//============================================================================


struct  BFu1c_BFu1c_BFu0i  {
  unsigned char v1:1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu1c_BFu0i) C1{ Fc:1 Fc:1 Fi:0}



static void Test_BFu1c_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu1c_BFu0i");
    static STRUCT_IF_C BFu1c_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1c_BFu0i, BFu1c_BFu1c_BFu0i)
//============================================================================


struct  BFu1c_BFu1c_BFu0ll  {
  unsigned char v1:1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu1c_BFu0ll) C1{ Fc:1 Fc:1 FL:0}



static void Test_BFu1c_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1c_BFu0ll, BFu1c_BFu1c_BFu0ll)
//============================================================================


struct  BFu1c_BFu1c_BFu0s  {
  unsigned char v1:1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu1c_BFu0s) C1{ Fc:1 Fc:1 Fs:0}



static void Test_BFu1c_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu1c_BFu0s");
    static STRUCT_IF_C BFu1c_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1c_BFu0s, BFu1c_BFu1c_BFu0s)
//============================================================================


struct  BFu1c_BFu1i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu1i_BFu0c) C1{ Fc:1 Fi:1 Fc:0}



static void Test_BFu1c_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu1i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1i_BFu0c, BFu1c_BFu1i_BFu0c)
//============================================================================


struct  BFu1c_BFu1i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu1i_BFu0i) C1{ Fc:1 Fi:1 Fi:0}



static void Test_BFu1c_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu1i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1i_BFu0i, BFu1c_BFu1i_BFu0i)
//============================================================================


struct  BFu1c_BFu1i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu1i_BFu0ll) C1{ Fc:1 Fi:1 FL:0}



static void Test_BFu1c_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1i_BFu0ll, BFu1c_BFu1i_BFu0ll)
//============================================================================


struct  BFu1c_BFu1i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu1i_BFu0s) C1{ Fc:1 Fi:1 Fs:0}



static void Test_BFu1c_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu1i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1i_BFu0s, BFu1c_BFu1i_BFu0s)
//============================================================================


struct  BFu1c_BFu1ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu1ll_BFu0c) C1{ Fc:1 FL:1 Fc:0}



static void Test_BFu1c_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1ll_BFu0c, BFu1c_BFu1ll_BFu0c)
//============================================================================


struct  BFu1c_BFu1ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu1ll_BFu0i) C1{ Fc:1 FL:1 Fi:0}



static void Test_BFu1c_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1ll_BFu0i, BFu1c_BFu1ll_BFu0i)
//============================================================================


struct  BFu1c_BFu1ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu1ll_BFu0ll) C1{ Fc:1 FL:1 FL:0}



static void Test_BFu1c_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1ll_BFu0ll, BFu1c_BFu1ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu1ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu1ll_BFu0s) C1{ Fc:1 FL:1 Fs:0}



static void Test_BFu1c_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1ll_BFu0s, BFu1c_BFu1ll_BFu0s)
//============================================================================


struct  BFu1c_BFu1s_BFu0c  {
  unsigned char v1:1;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu1s_BFu0c) C1{ Fc:1 Fs:1 Fc:0}



static void Test_BFu1c_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu1s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu1s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1s_BFu0c, BFu1c_BFu1s_BFu0c)
//============================================================================


struct  BFu1c_BFu1s_BFu0i  {
  unsigned char v1:1;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu1s_BFu0i) C1{ Fc:1 Fs:1 Fi:0}



static void Test_BFu1c_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu1s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1s_BFu0i, BFu1c_BFu1s_BFu0i)
//============================================================================


struct  BFu1c_BFu1s_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu1s_BFu0ll) C1{ Fc:1 Fs:1 FL:0}



static void Test_BFu1c_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1s_BFu0ll, BFu1c_BFu1s_BFu0ll)
//============================================================================


struct  BFu1c_BFu1s_BFu0s  {
  unsigned char v1:1;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu1s_BFu0s) C1{ Fc:1 Fs:1 Fs:0}



static void Test_BFu1c_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu1s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu1s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu1s_BFu0s, BFu1c_BFu1s_BFu0s)
//============================================================================


struct  BFu1c_BFu31i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu31i_BFu0c) C1{ Fc:1 Fi:31 Fc:0}



static void Test_BFu1c_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu31i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu31i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31i_BFu0c, BFu1c_BFu31i_BFu0c)
//============================================================================


struct  BFu1c_BFu31i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu31i_BFu0i) C1{ Fc:1 Fi:31 Fi:0}



static void Test_BFu1c_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu31i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu31i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31i_BFu0i, BFu1c_BFu31i_BFu0i)
//============================================================================


struct  BFu1c_BFu31i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu31i_BFu0ll) C1{ Fc:1 Fi:31 FL:0}



static void Test_BFu1c_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31i_BFu0ll, BFu1c_BFu31i_BFu0ll)
//============================================================================


struct  BFu1c_BFu31i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu31i_BFu0s) C1{ Fc:1 Fi:31 Fs:0}



static void Test_BFu1c_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu31i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu31i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31i_BFu0s, BFu1c_BFu31i_BFu0s)
//============================================================================


struct  BFu1c_BFu31ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu31ll_BFu0c) C1{ Fc:1 FL:31 Fc:0}



static void Test_BFu1c_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu31ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31ll_BFu0c, BFu1c_BFu31ll_BFu0c)
//============================================================================


struct  BFu1c_BFu31ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu31ll_BFu0i) C1{ Fc:1 FL:31 Fi:0}



static void Test_BFu1c_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31ll_BFu0i, BFu1c_BFu31ll_BFu0i)
//============================================================================


struct  BFu1c_BFu31ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu31ll_BFu0ll) C1{ Fc:1 FL:31 FL:0}



static void Test_BFu1c_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31ll_BFu0ll, BFu1c_BFu31ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu31ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu31ll_BFu0s) C1{ Fc:1 FL:31 Fs:0}



static void Test_BFu1c_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu31ll_BFu0s, BFu1c_BFu31ll_BFu0s)
//============================================================================


struct  BFu1c_BFu32i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu32i_BFu0c) C1{ Fc:1 Fi:32 Fc:0}



static void Test_BFu1c_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu32i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32i_BFu0c, BFu1c_BFu32i_BFu0c)
//============================================================================


struct  BFu1c_BFu32i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu32i_BFu0i) C1{ Fc:1 Fi:32 Fi:0}



static void Test_BFu1c_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu32i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32i_BFu0i, BFu1c_BFu32i_BFu0i)
//============================================================================


struct  BFu1c_BFu32i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu32i_BFu0ll) C1{ Fc:1 Fi:32 FL:0}



static void Test_BFu1c_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32i_BFu0ll, BFu1c_BFu32i_BFu0ll)
//============================================================================


struct  BFu1c_BFu32i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu32i_BFu0s) C1{ Fc:1 Fi:32 Fs:0}



static void Test_BFu1c_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu32i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32i_BFu0s, BFu1c_BFu32i_BFu0s)
//============================================================================


struct  BFu1c_BFu32ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu32ll_BFu0c) C1{ Fc:1 FL:32 Fc:0}



static void Test_BFu1c_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1c_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32ll_BFu0c, BFu1c_BFu32ll_BFu0c)
//============================================================================


struct  BFu1c_BFu32ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu32ll_BFu0i) C1{ Fc:1 FL:32 Fi:0}



static void Test_BFu1c_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1c_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32ll_BFu0i, BFu1c_BFu32ll_BFu0i)
//============================================================================


struct  BFu1c_BFu32ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu32ll_BFu0ll) C1{ Fc:1 FL:32 FL:0}



static void Test_BFu1c_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1c_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32ll_BFu0ll, BFu1c_BFu32ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu32ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu32ll_BFu0s) C1{ Fc:1 FL:32 Fs:0}



static void Test_BFu1c_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1c_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu32ll_BFu0s, BFu1c_BFu32ll_BFu0s)
//============================================================================


struct  BFu1c_BFu33_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu33_BFu0c) C1{ Fc:1 FL:33 Fc:0}



static void Test_BFu1c_BFu33_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu33_BFu0c");
    static STRUCT_IF_C BFu1c_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1c_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu33_BFu0c, BFu1c_BFu33_BFu0c)
//============================================================================


struct  BFu1c_BFu33_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu33_BFu0i) C1{ Fc:1 FL:33 Fi:0}



static void Test_BFu1c_BFu33_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu33_BFu0i");
    static STRUCT_IF_C BFu1c_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1c_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu33_BFu0i, BFu1c_BFu33_BFu0i)
//============================================================================


struct  BFu1c_BFu33_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu33_BFu0ll) C1{ Fc:1 FL:33 FL:0}



static void Test_BFu1c_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu33_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1c_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu33_BFu0ll, BFu1c_BFu33_BFu0ll)
//============================================================================


struct  BFu1c_BFu33_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu33_BFu0s) C1{ Fc:1 FL:33 Fs:0}



static void Test_BFu1c_BFu33_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu33_BFu0s");
    static STRUCT_IF_C BFu1c_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1c_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu33_BFu0s, BFu1c_BFu33_BFu0s)
//============================================================================


struct  BFu1c_BFu7c_BFu0c  {
  unsigned char v1:1;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu7c_BFu0c) C1{ Fc:1 Fc:7 Fc:0}



static void Test_BFu1c_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu7c_BFu0c");
    static STRUCT_IF_C BFu1c_BFu7c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu1c_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7c_BFu0c, BFu1c_BFu7c_BFu0c)
//============================================================================


struct  BFu1c_BFu7c_BFu0i  {
  unsigned char v1:1;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu7c_BFu0i) C1{ Fc:1 Fc:7 Fi:0}



static void Test_BFu1c_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu7c_BFu0i");
    static STRUCT_IF_C BFu1c_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7c_BFu0i, BFu1c_BFu7c_BFu0i)
//============================================================================


struct  BFu1c_BFu7c_BFu0ll  {
  unsigned char v1:1;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu7c_BFu0ll) C1{ Fc:1 Fc:7 FL:0}



static void Test_BFu1c_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7c_BFu0ll, BFu1c_BFu7c_BFu0ll)
//============================================================================


struct  BFu1c_BFu7c_BFu0s  {
  unsigned char v1:1;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu7c_BFu0s) C1{ Fc:1 Fc:7 Fs:0}



static void Test_BFu1c_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu7c_BFu0s");
    static STRUCT_IF_C BFu1c_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7c_BFu0s, BFu1c_BFu7c_BFu0s)
//============================================================================


struct  BFu1c_BFu7i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu7i_BFu0c) C1{ Fc:1 Fi:7 Fc:0}



static void Test_BFu1c_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu7i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7i_BFu0c, BFu1c_BFu7i_BFu0c)
//============================================================================


struct  BFu1c_BFu7i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu7i_BFu0i) C1{ Fc:1 Fi:7 Fi:0}



static void Test_BFu1c_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu7i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7i_BFu0i, BFu1c_BFu7i_BFu0i)
//============================================================================


struct  BFu1c_BFu7i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu7i_BFu0ll) C1{ Fc:1 Fi:7 FL:0}



static void Test_BFu1c_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7i_BFu0ll, BFu1c_BFu7i_BFu0ll)
//============================================================================


struct  BFu1c_BFu7i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu7i_BFu0s) C1{ Fc:1 Fi:7 Fs:0}



static void Test_BFu1c_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu7i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7i_BFu0s, BFu1c_BFu7i_BFu0s)
//============================================================================


struct  BFu1c_BFu7ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu7ll_BFu0c) C1{ Fc:1 FL:7 Fc:0}



static void Test_BFu1c_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7ll_BFu0c, BFu1c_BFu7ll_BFu0c)
//============================================================================


struct  BFu1c_BFu7ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu7ll_BFu0i) C1{ Fc:1 FL:7 Fi:0}



static void Test_BFu1c_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7ll_BFu0i, BFu1c_BFu7ll_BFu0i)
//============================================================================


struct  BFu1c_BFu7ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu7ll_BFu0ll) C1{ Fc:1 FL:7 FL:0}



static void Test_BFu1c_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7ll_BFu0ll, BFu1c_BFu7ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu7ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu7ll_BFu0s) C1{ Fc:1 FL:7 Fs:0}



static void Test_BFu1c_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7ll_BFu0s, BFu1c_BFu7ll_BFu0s)
//============================================================================


struct  BFu1c_BFu7s_BFu0c  {
  unsigned char v1:1;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu7s_BFu0c) C1{ Fc:1 Fs:7 Fc:0}



static void Test_BFu1c_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu7s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu7s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7s_BFu0c, BFu1c_BFu7s_BFu0c)
//============================================================================


struct  BFu1c_BFu7s_BFu0i  {
  unsigned char v1:1;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu7s_BFu0i) C1{ Fc:1 Fs:7 Fi:0}



static void Test_BFu1c_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu7s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7s_BFu0i, BFu1c_BFu7s_BFu0i)
//============================================================================


struct  BFu1c_BFu7s_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu7s_BFu0ll) C1{ Fc:1 Fs:7 FL:0}



static void Test_BFu1c_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7s_BFu0ll, BFu1c_BFu7s_BFu0ll)
//============================================================================


struct  BFu1c_BFu7s_BFu0s  {
  unsigned char v1:1;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu7s_BFu0s) C1{ Fc:1 Fs:7 Fs:0}



static void Test_BFu1c_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu7s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu7s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu7s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu7s_BFu0s, BFu1c_BFu7s_BFu0s)
//============================================================================


struct  BFu1c_BFu8c_BFu0c  {
  unsigned char v1:1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu8c_BFu0c) C1{ Fc:1 Fc:8 Fc:0}



static void Test_BFu1c_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu8c_BFu0c");
    static STRUCT_IF_C BFu1c_BFu8c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8c_BFu0c, BFu1c_BFu8c_BFu0c)
//============================================================================


struct  BFu1c_BFu8c_BFu0i  {
  unsigned char v1:1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu8c_BFu0i) C1{ Fc:1 Fc:8 Fi:0}



static void Test_BFu1c_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu8c_BFu0i");
    static STRUCT_IF_C BFu1c_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8c_BFu0i, BFu1c_BFu8c_BFu0i)
//============================================================================


struct  BFu1c_BFu8c_BFu0ll  {
  unsigned char v1:1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu8c_BFu0ll) C1{ Fc:1 Fc:8 FL:0}



static void Test_BFu1c_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8c_BFu0ll, BFu1c_BFu8c_BFu0ll)
//============================================================================


struct  BFu1c_BFu8c_BFu0s  {
  unsigned char v1:1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu8c_BFu0s) C1{ Fc:1 Fc:8 Fs:0}



static void Test_BFu1c_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu8c_BFu0s");
    static STRUCT_IF_C BFu1c_BFu8c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8c_BFu0s, BFu1c_BFu8c_BFu0s)
//============================================================================


struct  BFu1c_BFu8i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu8i_BFu0c) C1{ Fc:1 Fi:8 Fc:0}



static void Test_BFu1c_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu8i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8i_BFu0c, BFu1c_BFu8i_BFu0c)
//============================================================================


struct  BFu1c_BFu8i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu8i_BFu0i) C1{ Fc:1 Fi:8 Fi:0}



static void Test_BFu1c_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu8i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8i_BFu0i, BFu1c_BFu8i_BFu0i)
//============================================================================


struct  BFu1c_BFu8i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu8i_BFu0ll) C1{ Fc:1 Fi:8 FL:0}



static void Test_BFu1c_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8i_BFu0ll, BFu1c_BFu8i_BFu0ll)
//============================================================================


struct  BFu1c_BFu8i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu8i_BFu0s) C1{ Fc:1 Fi:8 Fs:0}



static void Test_BFu1c_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu8i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8i_BFu0s, BFu1c_BFu8i_BFu0s)
//============================================================================


struct  BFu1c_BFu8ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu8ll_BFu0c) C1{ Fc:1 FL:8 Fc:0}



static void Test_BFu1c_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8ll_BFu0c, BFu1c_BFu8ll_BFu0c)
//============================================================================


struct  BFu1c_BFu8ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu8ll_BFu0i) C1{ Fc:1 FL:8 Fi:0}



static void Test_BFu1c_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8ll_BFu0i, BFu1c_BFu8ll_BFu0i)
//============================================================================


struct  BFu1c_BFu8ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu8ll_BFu0ll) C1{ Fc:1 FL:8 FL:0}



static void Test_BFu1c_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8ll_BFu0ll, BFu1c_BFu8ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu8ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu8ll_BFu0s) C1{ Fc:1 FL:8 Fs:0}



static void Test_BFu1c_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8ll_BFu0s, BFu1c_BFu8ll_BFu0s)
//============================================================================


struct  BFu1c_BFu8s_BFu0c  {
  unsigned char v1:1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu8s_BFu0c) C1{ Fc:1 Fs:8 Fc:0}



static void Test_BFu1c_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu8s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu8s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu8s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8s_BFu0c, BFu1c_BFu8s_BFu0c)
//============================================================================


struct  BFu1c_BFu8s_BFu0i  {
  unsigned char v1:1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu8s_BFu0i) C1{ Fc:1 Fs:8 Fi:0}



static void Test_BFu1c_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu8s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8s_BFu0i, BFu1c_BFu8s_BFu0i)
//============================================================================


struct  BFu1c_BFu8s_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu8s_BFu0ll) C1{ Fc:1 Fs:8 FL:0}



static void Test_BFu1c_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8s_BFu0ll, BFu1c_BFu8s_BFu0ll)
//============================================================================


struct  BFu1c_BFu8s_BFu0s  {
  unsigned char v1:1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu8s_BFu0s) C1{ Fc:1 Fs:8 Fs:0}



static void Test_BFu1c_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu8s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu8s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu8s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu8s_BFu0s, BFu1c_BFu8s_BFu0s)
//============================================================================


struct  BFu1c_BFu9i_BFu0c  {
  unsigned char v1:1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu9i_BFu0c) C1{ Fc:1 Fi:9 Fc:0}



static void Test_BFu1c_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu9i_BFu0c");
    static STRUCT_IF_C BFu1c_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9i_BFu0c, BFu1c_BFu9i_BFu0c)
//============================================================================


struct  BFu1c_BFu9i_BFu0i  {
  unsigned char v1:1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu9i_BFu0i) C1{ Fc:1 Fi:9 Fi:0}



static void Test_BFu1c_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu9i_BFu0i");
    static STRUCT_IF_C BFu1c_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9i_BFu0i, BFu1c_BFu9i_BFu0i)
//============================================================================


struct  BFu1c_BFu9i_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu9i_BFu0ll) C1{ Fc:1 Fi:9 FL:0}



static void Test_BFu1c_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9i_BFu0ll, BFu1c_BFu9i_BFu0ll)
//============================================================================


struct  BFu1c_BFu9i_BFu0s  {
  unsigned char v1:1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu9i_BFu0s) C1{ Fc:1 Fi:9 Fs:0}



static void Test_BFu1c_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu9i_BFu0s");
    static STRUCT_IF_C BFu1c_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9i_BFu0s, BFu1c_BFu9i_BFu0s)
//============================================================================


struct  BFu1c_BFu9ll_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu9ll_BFu0c) C1{ Fc:1 FL:9 Fc:0}



static void Test_BFu1c_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu1c_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9ll_BFu0c, BFu1c_BFu9ll_BFu0c)
//============================================================================


struct  BFu1c_BFu9ll_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu9ll_BFu0i) C1{ Fc:1 FL:9 Fi:0}



static void Test_BFu1c_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu1c_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9ll_BFu0i, BFu1c_BFu9ll_BFu0i)
//============================================================================


struct  BFu1c_BFu9ll_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu9ll_BFu0ll) C1{ Fc:1 FL:9 FL:0}



static void Test_BFu1c_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9ll_BFu0ll, BFu1c_BFu9ll_BFu0ll)
//============================================================================


struct  BFu1c_BFu9ll_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu9ll_BFu0s) C1{ Fc:1 FL:9 Fs:0}



static void Test_BFu1c_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu1c_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9ll_BFu0s, BFu1c_BFu9ll_BFu0s)
//============================================================================


struct  BFu1c_BFu9s_BFu0c  {
  unsigned char v1:1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1c_BFu9s_BFu0c) C1{ Fc:1 Fs:9 Fc:0}



static void Test_BFu1c_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu1c_BFu9s_BFu0c");
    static STRUCT_IF_C BFu1c_BFu9s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu9s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9s_BFu0c, BFu1c_BFu9s_BFu0c)
//============================================================================


struct  BFu1c_BFu9s_BFu0i  {
  unsigned char v1:1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1c_BFu9s_BFu0i) C1{ Fc:1 Fs:9 Fi:0}



static void Test_BFu1c_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu1c_BFu9s_BFu0i");
    static STRUCT_IF_C BFu1c_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9s_BFu0i, BFu1c_BFu9s_BFu0i)
//============================================================================


struct  BFu1c_BFu9s_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1c_BFu9s_BFu0ll) C1{ Fc:1 Fs:9 FL:0}



static void Test_BFu1c_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu1c_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu1c_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9s_BFu0ll, BFu1c_BFu9s_BFu0ll)
//============================================================================


struct  BFu1c_BFu9s_BFu0s  {
  unsigned char v1:1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1c_BFu9s_BFu0s) C1{ Fc:1 Fs:9 Fs:0}



static void Test_BFu1c_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu1c_BFu9s_BFu0s");
    static STRUCT_IF_C BFu1c_BFu9s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu9s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_BFu9s_BFu0s, BFu1c_BFu9s_BFu0s)
//============================================================================


struct  BFu1c_C_BFu0c  {
  unsigned char v1:1;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_C_BFu0c) C1{ Fc:1 Fc Fc:0}



static void Test_BFu1c_C_BFu0c()
{
  {
    init_simple_test("BFu1c_C_BFu0c");
    static STRUCT_IF_C BFu1c_C_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_C_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1c_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_C_BFu0c, BFu1c_C_BFu0c)
//============================================================================


struct  BFu1c_C_BFu0i  {
  unsigned char v1:1;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_C_BFu0i) C1{ Fc:1 Fc Fi:0}



static void Test_BFu1c_C_BFu0i()
{
  {
    init_simple_test("BFu1c_C_BFu0i");
    static STRUCT_IF_C BFu1c_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_C_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1c_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_C_BFu0i, BFu1c_C_BFu0i)
//============================================================================


struct  BFu1c_C_BFu0ll  {
  unsigned char v1:1;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_C_BFu0ll) C1{ Fc:1 Fc FL:0}



static void Test_BFu1c_C_BFu0ll()
{
  {
    init_simple_test("BFu1c_C_BFu0ll");
    static STRUCT_IF_C BFu1c_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_C_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1c_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_C_BFu0ll, BFu1c_C_BFu0ll)
//============================================================================


struct  BFu1c_C_BFu0s  {
  unsigned char v1:1;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_C_BFu0s) C1{ Fc:1 Fc Fs:0}



static void Test_BFu1c_C_BFu0s()
{
  {
    init_simple_test("BFu1c_C_BFu0s");
    static STRUCT_IF_C BFu1c_C_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_C_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1c_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_C_BFu0s, BFu1c_C_BFu0s)
//============================================================================


struct  BFu1c_D_BFu0c  {
  unsigned char v1:1;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_D_BFu0c) C1{ Fc:1 FL Fc:0}



static void Test_BFu1c_D_BFu0c()
{
  {
    init_simple_test("BFu1c_D_BFu0c");
    static STRUCT_IF_C BFu1c_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_D_BFu0c, BFu1c_D_BFu0c)
//============================================================================


struct  BFu1c_D_BFu0i  {
  unsigned char v1:1;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_D_BFu0i) C1{ Fc:1 FL Fi:0}



static void Test_BFu1c_D_BFu0i()
{
  {
    init_simple_test("BFu1c_D_BFu0i");
    static STRUCT_IF_C BFu1c_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_D_BFu0i, BFu1c_D_BFu0i)
//============================================================================


struct  BFu1c_D_BFu0ll  {
  unsigned char v1:1;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_D_BFu0ll) C1{ Fc:1 FL FL:0}



static void Test_BFu1c_D_BFu0ll()
{
  {
    init_simple_test("BFu1c_D_BFu0ll");
    static STRUCT_IF_C BFu1c_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_D_BFu0ll, BFu1c_D_BFu0ll)
//============================================================================


struct  BFu1c_D_BFu0s  {
  unsigned char v1:1;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_D_BFu0s) C1{ Fc:1 FL Fs:0}



static void Test_BFu1c_D_BFu0s()
{
  {
    init_simple_test("BFu1c_D_BFu0s");
    static STRUCT_IF_C BFu1c_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_D_BFu0s, BFu1c_D_BFu0s)
//============================================================================


struct  BFu1c_F_BFu0c  {
  unsigned char v1:1;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_F_BFu0c) C1{ Fc:1 Fi Fc:0}



static void Test_BFu1c_F_BFu0c()
{
  {
    init_simple_test("BFu1c_F_BFu0c");
    static STRUCT_IF_C BFu1c_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1c_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_F_BFu0c, BFu1c_F_BFu0c)
//============================================================================


struct  BFu1c_F_BFu0i  {
  unsigned char v1:1;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_F_BFu0i) C1{ Fc:1 Fi Fi:0}



static void Test_BFu1c_F_BFu0i()
{
  {
    init_simple_test("BFu1c_F_BFu0i");
    static STRUCT_IF_C BFu1c_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1c_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_F_BFu0i, BFu1c_F_BFu0i)
//============================================================================


struct  BFu1c_F_BFu0ll  {
  unsigned char v1:1;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_F_BFu0ll) C1{ Fc:1 Fi FL:0}



static void Test_BFu1c_F_BFu0ll()
{
  {
    init_simple_test("BFu1c_F_BFu0ll");
    static STRUCT_IF_C BFu1c_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1c_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_F_BFu0ll, BFu1c_F_BFu0ll)
//============================================================================


struct  BFu1c_F_BFu0s  {
  unsigned char v1:1;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_F_BFu0s) C1{ Fc:1 Fi Fs:0}



static void Test_BFu1c_F_BFu0s()
{
  {
    init_simple_test("BFu1c_F_BFu0s");
    static STRUCT_IF_C BFu1c_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1c_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_F_BFu0s, BFu1c_F_BFu0s)
//============================================================================


struct  BFu1c_I_BFu0c  {
  unsigned char v1:1;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_I_BFu0c) C1{ Fc:1 Fi Fc:0}



static void Test_BFu1c_I_BFu0c()
{
  {
    init_simple_test("BFu1c_I_BFu0c");
    static STRUCT_IF_C BFu1c_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1c_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_I_BFu0c, BFu1c_I_BFu0c)
//============================================================================


struct  BFu1c_I_BFu0i  {
  unsigned char v1:1;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_I_BFu0i) C1{ Fc:1 Fi Fi:0}



static void Test_BFu1c_I_BFu0i()
{
  {
    init_simple_test("BFu1c_I_BFu0i");
    static STRUCT_IF_C BFu1c_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1c_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_I_BFu0i, BFu1c_I_BFu0i)
//============================================================================


struct  BFu1c_I_BFu0ll  {
  unsigned char v1:1;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_I_BFu0ll) C1{ Fc:1 Fi FL:0}



static void Test_BFu1c_I_BFu0ll()
{
  {
    init_simple_test("BFu1c_I_BFu0ll");
    static STRUCT_IF_C BFu1c_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1c_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_I_BFu0ll, BFu1c_I_BFu0ll)
//============================================================================


struct  BFu1c_I_BFu0s  {
  unsigned char v1:1;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_I_BFu0s) C1{ Fc:1 Fi Fs:0}



static void Test_BFu1c_I_BFu0s()
{
  {
    init_simple_test("BFu1c_I_BFu0s");
    static STRUCT_IF_C BFu1c_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1c_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_I_BFu0s, BFu1c_I_BFu0s)
//============================================================================


struct  BFu1c_Ip_BFu0c  {
  unsigned char v1:1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_Ip_BFu0c) C1{ Fc:1 Fp Fc:0}



static void Test_BFu1c_Ip_BFu0c()
{
  {
    init_simple_test("BFu1c_Ip_BFu0c");
    static STRUCT_IF_C BFu1c_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ip_BFu0c, BFu1c_Ip_BFu0c)
//============================================================================


struct  BFu1c_Ip_BFu0i  {
  unsigned char v1:1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_Ip_BFu0i) C1{ Fc:1 Fp Fi:0}



static void Test_BFu1c_Ip_BFu0i()
{
  {
    init_simple_test("BFu1c_Ip_BFu0i");
    static STRUCT_IF_C BFu1c_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ip_BFu0i, BFu1c_Ip_BFu0i)
//============================================================================


struct  BFu1c_Ip_BFu0ll  {
  unsigned char v1:1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_Ip_BFu0ll) C1{ Fc:1 Fp FL:0}



static void Test_BFu1c_Ip_BFu0ll()
{
  {
    init_simple_test("BFu1c_Ip_BFu0ll");
    static STRUCT_IF_C BFu1c_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ip_BFu0ll, BFu1c_Ip_BFu0ll)
//============================================================================


struct  BFu1c_Ip_BFu0s  {
  unsigned char v1:1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_Ip_BFu0s) C1{ Fc:1 Fp Fs:0}



static void Test_BFu1c_Ip_BFu0s()
{
  {
    init_simple_test("BFu1c_Ip_BFu0s");
    static STRUCT_IF_C BFu1c_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ip_BFu0s, BFu1c_Ip_BFu0s)
//============================================================================


struct  BFu1c_L_BFu0c  {
  unsigned char v1:1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_L_BFu0c) C1{ Fc:1 FL Fc:0}



static void Test_BFu1c_L_BFu0c()
{
  {
    init_simple_test("BFu1c_L_BFu0c");
    static STRUCT_IF_C BFu1c_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_L_BFu0c, BFu1c_L_BFu0c)
//============================================================================


struct  BFu1c_L_BFu0i  {
  unsigned char v1:1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_L_BFu0i) C1{ Fc:1 FL Fi:0}



static void Test_BFu1c_L_BFu0i()
{
  {
    init_simple_test("BFu1c_L_BFu0i");
    static STRUCT_IF_C BFu1c_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_L_BFu0i, BFu1c_L_BFu0i)
//============================================================================


struct  BFu1c_L_BFu0ll  {
  unsigned char v1:1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_L_BFu0ll) C1{ Fc:1 FL FL:0}



static void Test_BFu1c_L_BFu0ll()
{
  {
    init_simple_test("BFu1c_L_BFu0ll");
    static STRUCT_IF_C BFu1c_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_L_BFu0ll, BFu1c_L_BFu0ll)
//============================================================================


struct  BFu1c_L_BFu0s  {
  unsigned char v1:1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_L_BFu0s) C1{ Fc:1 FL Fs:0}



static void Test_BFu1c_L_BFu0s()
{
  {
    init_simple_test("BFu1c_L_BFu0s");
    static STRUCT_IF_C BFu1c_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_L_BFu0s, BFu1c_L_BFu0s)
//============================================================================


struct  BFu1c_S_BFu0c  {
  unsigned char v1:1;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_S_BFu0c) C1{ Fc:1 Fs Fc:0}



static void Test_BFu1c_S_BFu0c()
{
  {
    init_simple_test("BFu1c_S_BFu0c");
    static STRUCT_IF_C BFu1c_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_S_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu1c_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_S_BFu0c, BFu1c_S_BFu0c)
//============================================================================


struct  BFu1c_S_BFu0i  {
  unsigned char v1:1;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_S_BFu0i) C1{ Fc:1 Fs Fi:0}



static void Test_BFu1c_S_BFu0i()
{
  {
    init_simple_test("BFu1c_S_BFu0i");
    static STRUCT_IF_C BFu1c_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu1c_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_S_BFu0i, BFu1c_S_BFu0i)
//============================================================================


struct  BFu1c_S_BFu0ll  {
  unsigned char v1:1;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_S_BFu0ll) C1{ Fc:1 Fs FL:0}



static void Test_BFu1c_S_BFu0ll()
{
  {
    init_simple_test("BFu1c_S_BFu0ll");
    static STRUCT_IF_C BFu1c_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu1c_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_S_BFu0ll, BFu1c_S_BFu0ll)
//============================================================================


struct  BFu1c_S_BFu0s  {
  unsigned char v1:1;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_S_BFu0s) C1{ Fc:1 Fs Fs:0}



static void Test_BFu1c_S_BFu0s()
{
  {
    init_simple_test("BFu1c_S_BFu0s");
    static STRUCT_IF_C BFu1c_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_S_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu1c_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_S_BFu0s, BFu1c_S_BFu0s)
//============================================================================


struct  BFu1c_Uc_BFu0c  {
  unsigned char v1:1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_Uc_BFu0c) C1{ Fc:1 Fc Fc:0}



static void Test_BFu1c_Uc_BFu0c()
{
  {
    init_simple_test("BFu1c_Uc_BFu0c");
    static STRUCT_IF_C BFu1c_Uc_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Uc_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1c_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Uc_BFu0c, BFu1c_Uc_BFu0c)
//============================================================================


struct  BFu1c_Uc_BFu0i  {
  unsigned char v1:1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_Uc_BFu0i) C1{ Fc:1 Fc Fi:0}



static void Test_BFu1c_Uc_BFu0i()
{
  {
    init_simple_test("BFu1c_Uc_BFu0i");
    static STRUCT_IF_C BFu1c_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Uc_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1c_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Uc_BFu0i, BFu1c_Uc_BFu0i)
//============================================================================


struct  BFu1c_Uc_BFu0ll  {
  unsigned char v1:1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_Uc_BFu0ll) C1{ Fc:1 Fc FL:0}



static void Test_BFu1c_Uc_BFu0ll()
{
  {
    init_simple_test("BFu1c_Uc_BFu0ll");
    static STRUCT_IF_C BFu1c_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Uc_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1c_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Uc_BFu0ll, BFu1c_Uc_BFu0ll)
//============================================================================


struct  BFu1c_Uc_BFu0s  {
  unsigned char v1:1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_Uc_BFu0s) C1{ Fc:1 Fc Fs:0}



static void Test_BFu1c_Uc_BFu0s()
{
  {
    init_simple_test("BFu1c_Uc_BFu0s");
    static STRUCT_IF_C BFu1c_Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu1c_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Uc_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1c_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Uc_BFu0s, BFu1c_Uc_BFu0s)
//============================================================================


struct  BFu1c_Ui_BFu0c  {
  unsigned char v1:1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_Ui_BFu0c) C1{ Fc:1 Fi Fc:0}



static void Test_BFu1c_Ui_BFu0c()
{
  {
    init_simple_test("BFu1c_Ui_BFu0c");
    static STRUCT_IF_C BFu1c_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1c_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ui_BFu0c, BFu1c_Ui_BFu0c)
//============================================================================


struct  BFu1c_Ui_BFu0i  {
  unsigned char v1:1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_Ui_BFu0i) C1{ Fc:1 Fi Fi:0}



static void Test_BFu1c_Ui_BFu0i()
{
  {
    init_simple_test("BFu1c_Ui_BFu0i");
    static STRUCT_IF_C BFu1c_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1c_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ui_BFu0i, BFu1c_Ui_BFu0i)
//============================================================================


struct  BFu1c_Ui_BFu0ll  {
  unsigned char v1:1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_Ui_BFu0ll) C1{ Fc:1 Fi FL:0}



static void Test_BFu1c_Ui_BFu0ll()
{
  {
    init_simple_test("BFu1c_Ui_BFu0ll");
    static STRUCT_IF_C BFu1c_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1c_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1c_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ui_BFu0ll, BFu1c_Ui_BFu0ll)
//============================================================================


struct  BFu1c_Ui_BFu0s  {
  unsigned char v1:1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_Ui_BFu0s) C1{ Fc:1 Fi Fs:0}



static void Test_BFu1c_Ui_BFu0s()
{
  {
    init_simple_test("BFu1c_Ui_BFu0s");
    static STRUCT_IF_C BFu1c_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1c_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ui_BFu0s, BFu1c_Ui_BFu0s)
//============================================================================


struct  BFu1c_Ul_BFu0c  {
  unsigned char v1:1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_Ul_BFu0c) C1{ Fc:1 FL Fc:0}



static void Test_BFu1c_Ul_BFu0c()
{
  {
    init_simple_test("BFu1c_Ul_BFu0c");
    static STRUCT_IF_C BFu1c_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ul_BFu0c, BFu1c_Ul_BFu0c)
//============================================================================


struct  BFu1c_Ul_BFu0i  {
  unsigned char v1:1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_Ul_BFu0i) C1{ Fc:1 FL Fi:0}



static void Test_BFu1c_Ul_BFu0i()
{
  {
    init_simple_test("BFu1c_Ul_BFu0i");
    static STRUCT_IF_C BFu1c_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ul_BFu0i, BFu1c_Ul_BFu0i)
//============================================================================


struct  BFu1c_Ul_BFu0ll  {
  unsigned char v1:1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_Ul_BFu0ll) C1{ Fc:1 FL FL:0}



static void Test_BFu1c_Ul_BFu0ll()
{
  {
    init_simple_test("BFu1c_Ul_BFu0ll");
    static STRUCT_IF_C BFu1c_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ul_BFu0ll, BFu1c_Ul_BFu0ll)
//============================================================================


struct  BFu1c_Ul_BFu0s  {
  unsigned char v1:1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_Ul_BFu0s) C1{ Fc:1 FL Fs:0}



static void Test_BFu1c_Ul_BFu0s()
{
  {
    init_simple_test("BFu1c_Ul_BFu0s");
    static STRUCT_IF_C BFu1c_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Ul_BFu0s, BFu1c_Ul_BFu0s)
//============================================================================


struct  BFu1c_Us_BFu0c  {
  unsigned char v1:1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_Us_BFu0c) C1{ Fc:1 Fs Fc:0}



static void Test_BFu1c_Us_BFu0c()
{
  {
    init_simple_test("BFu1c_Us_BFu0c");
    static STRUCT_IF_C BFu1c_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Us_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu1c_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Us_BFu0c, BFu1c_Us_BFu0c)
//============================================================================


struct  BFu1c_Us_BFu0i  {
  unsigned char v1:1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_Us_BFu0i) C1{ Fc:1 Fs Fi:0}



static void Test_BFu1c_Us_BFu0i()
{
  {
    init_simple_test("BFu1c_Us_BFu0i");
    static STRUCT_IF_C BFu1c_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu1c_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Us_BFu0i, BFu1c_Us_BFu0i)
//============================================================================


struct  BFu1c_Us_BFu0ll  {
  unsigned char v1:1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_Us_BFu0ll) C1{ Fc:1 Fs FL:0}



static void Test_BFu1c_Us_BFu0ll()
{
  {
    init_simple_test("BFu1c_Us_BFu0ll");
    static STRUCT_IF_C BFu1c_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1c_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu1c_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Us_BFu0ll, BFu1c_Us_BFu0ll)
//============================================================================


struct  BFu1c_Us_BFu0s  {
  unsigned char v1:1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_Us_BFu0s) C1{ Fc:1 Fs Fs:0}



static void Test_BFu1c_Us_BFu0s()
{
  {
    init_simple_test("BFu1c_Us_BFu0s");
    static STRUCT_IF_C BFu1c_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Us_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu1c_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Us_BFu0s, BFu1c_Us_BFu0s)
//============================================================================


struct  BFu1c_Vp_BFu0c  {
  unsigned char v1:1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu1c_Vp_BFu0c) C1{ Fc:1 Fp Fc:0}



static void Test_BFu1c_Vp_BFu0c()
{
  {
    init_simple_test("BFu1c_Vp_BFu0c");
    static STRUCT_IF_C BFu1c_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Vp_BFu0c, BFu1c_Vp_BFu0c)
//============================================================================


struct  BFu1c_Vp_BFu0i  {
  unsigned char v1:1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu1c_Vp_BFu0i) C1{ Fc:1 Fp Fi:0}



static void Test_BFu1c_Vp_BFu0i()
{
  {
    init_simple_test("BFu1c_Vp_BFu0i");
    static STRUCT_IF_C BFu1c_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Vp_BFu0i, BFu1c_Vp_BFu0i)
//============================================================================


struct  BFu1c_Vp_BFu0ll  {
  unsigned char v1:1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu1c_Vp_BFu0ll) C1{ Fc:1 Fp FL:0}



static void Test_BFu1c_Vp_BFu0ll()
{
  {
    init_simple_test("BFu1c_Vp_BFu0ll");
    static STRUCT_IF_C BFu1c_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Vp_BFu0ll, BFu1c_Vp_BFu0ll)
//============================================================================


struct  BFu1c_Vp_BFu0s  {
  unsigned char v1:1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu1c_Vp_BFu0s) C1{ Fc:1 Fp Fs:0}



static void Test_BFu1c_Vp_BFu0s()
{
  {
    init_simple_test("BFu1c_Vp_BFu0s");
    static STRUCT_IF_C BFu1c_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1c_Vp_BFu0s, BFu1c_Vp_BFu0s)
//============================================================================


struct  BFu1i_BFu0c  {
  unsigned int v1:1;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu0c) C1{ Fi:1 Fc:0}



static void Test_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c, BFu1i_BFu0c)
//============================================================================


struct  BFu1i_BFu0c_BFu0c  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu0c_BFu0c) C1{ Fi:1 Fc:0 Fc:0}



static void Test_BFu1i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu0c");
    static STRUCT_IF_C BFu1i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu0c, BFu1i_BFu0c_BFu0c)
//============================================================================


struct  BFu1i_BFu0c_BFu0i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu0c_BFu0i) C1{ Fi:1 Fc:0 Fi:0}



static void Test_BFu1i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu0i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu0i, BFu1i_BFu0c_BFu0i)
//============================================================================


struct  BFu1i_BFu0c_BFu0ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu0c_BFu0ll) C1{ Fi:1 Fc:0 FL:0}



static void Test_BFu1i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu0ll, BFu1i_BFu0c_BFu0ll)
//============================================================================


struct  BFu1i_BFu0c_BFu0s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu0c_BFu0s) C1{ Fi:1 Fc:0 Fs:0}



static void Test_BFu1i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu0s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu0s, BFu1i_BFu0c_BFu0s)
//============================================================================


struct  BFu1i_BFu0c_BFu15i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1i_BFu0c_BFu15i) C1{ Fi:1 Fc:0 Fi:15}



static void Test_BFu1i_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu15i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu15i, BFu1i_BFu0c_BFu15i)
//============================================================================


struct  BFu1i_BFu0c_BFu15ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1i_BFu0c_BFu15ll) C1{ Fi:1 Fc:0 FL:15}



static void Test_BFu1i_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu15ll, BFu1i_BFu0c_BFu15ll)
//============================================================================


struct  BFu1i_BFu0c_BFu15s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1i_BFu0c_BFu15s) C1{ Fi:1 Fc:0 Fs:15}



static void Test_BFu1i_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu15s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu15s, BFu1i_BFu0c_BFu15s)
//============================================================================


struct  BFu1i_BFu0c_BFu16i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1i_BFu0c_BFu16i) C1{ Fi:1 Fc:0 Fi:16}



static void Test_BFu1i_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu16i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu16i, BFu1i_BFu0c_BFu16i)
//============================================================================


struct  BFu1i_BFu0c_BFu16ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1i_BFu0c_BFu16ll) C1{ Fi:1 Fc:0 FL:16}



static void Test_BFu1i_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu16ll, BFu1i_BFu0c_BFu16ll)
//============================================================================


struct  BFu1i_BFu0c_BFu16s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1i_BFu0c_BFu16s) C1{ Fi:1 Fc:0 Fs:16}



static void Test_BFu1i_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu16s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu16s, BFu1i_BFu0c_BFu16s)
//============================================================================


struct  BFu1i_BFu0c_BFu17i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1i_BFu0c_BFu17i) C1{ Fi:1 Fc:0 Fi:17}



static void Test_BFu1i_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu17i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu17i, BFu1i_BFu0c_BFu17i)
//============================================================================


struct  BFu1i_BFu0c_BFu17ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1i_BFu0c_BFu17ll) C1{ Fi:1 Fc:0 FL:17}



static void Test_BFu1i_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu17ll, BFu1i_BFu0c_BFu17ll)
//============================================================================


struct  BFu1i_BFu0c_BFu1c  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1i_BFu0c_BFu1c) C1{ Fi:1 Fc:0 Fc:1}



static void Test_BFu1i_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu1c");
    static STRUCT_IF_C BFu1i_BFu0c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1i_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu1c, BFu1i_BFu0c_BFu1c)
//============================================================================


struct  BFu1i_BFu0c_BFu1i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1i_BFu0c_BFu1i) C1{ Fi:1 Fc:0 Fi:1}



static void Test_BFu1i_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu1i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1i_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu1i, BFu1i_BFu0c_BFu1i)
//============================================================================


struct  BFu1i_BFu0c_BFu1ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1i_BFu0c_BFu1ll) C1{ Fi:1 Fc:0 FL:1}



static void Test_BFu1i_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1i_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu1ll, BFu1i_BFu0c_BFu1ll)
//============================================================================


struct  BFu1i_BFu0c_BFu1s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1i_BFu0c_BFu1s) C1{ Fi:1 Fc:0 Fs:1}



static void Test_BFu1i_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu1s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1i_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu1s, BFu1i_BFu0c_BFu1s)
//============================================================================


struct  BFu1i_BFu0c_BFu31i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1i_BFu0c_BFu31i) C1{ Fi:1 Fc:0 Fi:31}



static void Test_BFu1i_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu31i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu31i, BFu1i_BFu0c_BFu31i)
//============================================================================


struct  BFu1i_BFu0c_BFu31ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1i_BFu0c_BFu31ll) C1{ Fi:1 Fc:0 FL:31}



static void Test_BFu1i_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu1i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu31ll, BFu1i_BFu0c_BFu31ll)
//============================================================================


struct  BFu1i_BFu0c_BFu32i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1i_BFu0c_BFu32i) C1{ Fi:1 Fc:0 Fi:32}



static void Test_BFu1i_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu32i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu32i, BFu1i_BFu0c_BFu32i)
//============================================================================


struct  BFu1i_BFu0c_BFu32ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1i_BFu0c_BFu32ll) C1{ Fi:1 Fc:0 FL:32}



static void Test_BFu1i_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu1i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu32ll, BFu1i_BFu0c_BFu32ll)
//============================================================================


struct  BFu1i_BFu0c_BFu33  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1i_BFu0c_BFu33) C1{ Fi:1 Fc:0 FL:33}



static void Test_BFu1i_BFu0c_BFu33()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu33");
    static STRUCT_IF_C BFu1i_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu1i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu33, BFu1i_BFu0c_BFu33)
//============================================================================


struct  BFu1i_BFu0c_BFu7c  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1i_BFu0c_BFu7c) C1{ Fi:1 Fc:0 Fc:7}



static void Test_BFu1i_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu7c");
    static STRUCT_IF_C BFu1i_BFu0c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu7c, BFu1i_BFu0c_BFu7c)
//============================================================================


struct  BFu1i_BFu0c_BFu7i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1i_BFu0c_BFu7i) C1{ Fi:1 Fc:0 Fi:7}



static void Test_BFu1i_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu7i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu7i, BFu1i_BFu0c_BFu7i)
//============================================================================


struct  BFu1i_BFu0c_BFu7ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1i_BFu0c_BFu7ll) C1{ Fi:1 Fc:0 FL:7}



static void Test_BFu1i_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu7ll, BFu1i_BFu0c_BFu7ll)
//============================================================================


struct  BFu1i_BFu0c_BFu7s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1i_BFu0c_BFu7s) C1{ Fi:1 Fc:0 Fs:7}



static void Test_BFu1i_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu7s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu7s, BFu1i_BFu0c_BFu7s)
//============================================================================


struct  BFu1i_BFu0c_BFu8c  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1i_BFu0c_BFu8c) C1{ Fi:1 Fc:0 Fc:8}



static void Test_BFu1i_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu8c");
    static STRUCT_IF_C BFu1i_BFu0c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu8c, BFu1i_BFu0c_BFu8c)
//============================================================================


struct  BFu1i_BFu0c_BFu8i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1i_BFu0c_BFu8i) C1{ Fi:1 Fc:0 Fi:8}



static void Test_BFu1i_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu8i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu8i, BFu1i_BFu0c_BFu8i)
//============================================================================


struct  BFu1i_BFu0c_BFu8ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1i_BFu0c_BFu8ll) C1{ Fi:1 Fc:0 FL:8}



static void Test_BFu1i_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu8ll, BFu1i_BFu0c_BFu8ll)
//============================================================================


struct  BFu1i_BFu0c_BFu8s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1i_BFu0c_BFu8s) C1{ Fi:1 Fc:0 Fs:8}



static void Test_BFu1i_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu8s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu8s, BFu1i_BFu0c_BFu8s)
//============================================================================


struct  BFu1i_BFu0c_BFu9i  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1i_BFu0c_BFu9i) C1{ Fi:1 Fc:0 Fi:9}



static void Test_BFu1i_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu9i");
    static STRUCT_IF_C BFu1i_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu9i, BFu1i_BFu0c_BFu9i)
//============================================================================


struct  BFu1i_BFu0c_BFu9ll  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1i_BFu0c_BFu9ll) C1{ Fi:1 Fc:0 FL:9}



static void Test_BFu1i_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu9ll, BFu1i_BFu0c_BFu9ll)
//============================================================================


struct  BFu1i_BFu0c_BFu9s  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1i_BFu0c_BFu9s) C1{ Fi:1 Fc:0 Fs:9}



static void Test_BFu1i_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu0c_BFu9s");
    static STRUCT_IF_C BFu1i_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_BFu9s, BFu1i_BFu0c_BFu9s)
//============================================================================


struct  BFu1i_BFu0c_C  {
  unsigned int v1:1;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu1i_BFu0c_C) C1{ Fi:1 Fc:0 Fc}



static void Test_BFu1i_BFu0c_C()
{
  {
    init_simple_test("BFu1i_BFu0c_C");
    static STRUCT_IF_C BFu1i_BFu0c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu1i_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_C, BFu1i_BFu0c_C)
//============================================================================


struct  BFu1i_BFu0c_D  {
  unsigned int v1:1;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu1i_BFu0c_D) C1{ Fi:1 Fc:0 FL}



static void Test_BFu1i_BFu0c_D()
{
  {
    init_simple_test("BFu1i_BFu0c_D");
    static STRUCT_IF_C BFu1i_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_D, BFu1i_BFu0c_D)
//============================================================================


struct  BFu1i_BFu0c_F  {
  unsigned int v1:1;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu1i_BFu0c_F) C1{ Fi:1 Fc:0 Fi}



static void Test_BFu1i_BFu0c_F()
{
  {
    init_simple_test("BFu1i_BFu0c_F");
    static STRUCT_IF_C BFu1i_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_F, BFu1i_BFu0c_F)
//============================================================================


struct  BFu1i_BFu0c_I  {
  unsigned int v1:1;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu1i_BFu0c_I) C1{ Fi:1 Fc:0 Fi}



static void Test_BFu1i_BFu0c_I()
{
  {
    init_simple_test("BFu1i_BFu0c_I");
    static STRUCT_IF_C BFu1i_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_I, BFu1i_BFu0c_I)
//============================================================================


struct  BFu1i_BFu0c_Ip  {
  unsigned int v1:1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu1i_BFu0c_Ip) C1{ Fi:1 Fc:0 Fp}



static void Test_BFu1i_BFu0c_Ip()
{
  {
    init_simple_test("BFu1i_BFu0c_Ip");
    static STRUCT_IF_C BFu1i_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Ip, BFu1i_BFu0c_Ip)
//============================================================================


struct  BFu1i_BFu0c_L  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu1i_BFu0c_L) C1{ Fi:1 Fc:0 FL}



static void Test_BFu1i_BFu0c_L()
{
  {
    init_simple_test("BFu1i_BFu0c_L");
    static STRUCT_IF_C BFu1i_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_L, BFu1i_BFu0c_L)
//============================================================================


struct  BFu1i_BFu0c_S  {
  unsigned int v1:1;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu1i_BFu0c_S) C1{ Fi:1 Fc:0 Fs}



static void Test_BFu1i_BFu0c_S()
{
  {
    init_simple_test("BFu1i_BFu0c_S");
    static STRUCT_IF_C BFu1i_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu1i_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_S, BFu1i_BFu0c_S)
//============================================================================


struct  BFu1i_BFu0c_Uc  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu1i_BFu0c_Uc) C1{ Fi:1 Fc:0 Fc}



static void Test_BFu1i_BFu0c_Uc()
{
  {
    init_simple_test("BFu1i_BFu0c_Uc");
    static STRUCT_IF_C BFu1i_BFu0c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu1i_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Uc, BFu1i_BFu0c_Uc)
//============================================================================


struct  BFu1i_BFu0c_Ui  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu1i_BFu0c_Ui) C1{ Fi:1 Fc:0 Fi}



static void Test_BFu1i_BFu0c_Ui()
{
  {
    init_simple_test("BFu1i_BFu0c_Ui");
    static STRUCT_IF_C BFu1i_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Ui, BFu1i_BFu0c_Ui)
//============================================================================


struct  BFu1i_BFu0c_Ul  {
  unsigned int v1:1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu1i_BFu0c_Ul) C1{ Fi:1 Fc:0 FL}



static void Test_BFu1i_BFu0c_Ul()
{
  {
    init_simple_test("BFu1i_BFu0c_Ul");
    static STRUCT_IF_C BFu1i_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Ul, BFu1i_BFu0c_Ul)
//============================================================================


struct  BFu1i_BFu0c_Us  {
  unsigned int v1:1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu1i_BFu0c_Us) C1{ Fi:1 Fc:0 Fs}



static void Test_BFu1i_BFu0c_Us()
{
  {
    init_simple_test("BFu1i_BFu0c_Us");
    static STRUCT_IF_C BFu1i_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu1i_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Us, BFu1i_BFu0c_Us)
//============================================================================


struct  BFu1i_BFu0c_Vp  {
  unsigned int v1:1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu1i_BFu0c_Vp) C1{ Fi:1 Fc:0 Fp}



static void Test_BFu1i_BFu0c_Vp()
{
  {
    init_simple_test("BFu1i_BFu0c_Vp");
    static STRUCT_IF_C BFu1i_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0c_Vp, BFu1i_BFu0c_Vp)
//============================================================================


struct  BFu1i_BFu0i  {
  unsigned int v1:1;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu0i) C1{ Fi:1 Fi:0}



static void Test_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i, BFu1i_BFu0i)
//============================================================================


struct  BFu1i_BFu0i_BFu0c  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu0i_BFu0c) C1{ Fi:1 Fi:0 Fc:0}



static void Test_BFu1i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu0c, BFu1i_BFu0i_BFu0c)
//============================================================================


struct  BFu1i_BFu0i_BFu0i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu0i_BFu0i) C1{ Fi:1 Fi:0 Fi:0}



static void Test_BFu1i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu0i, BFu1i_BFu0i_BFu0i)
//============================================================================


struct  BFu1i_BFu0i_BFu0ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu0i_BFu0ll) C1{ Fi:1 Fi:0 FL:0}



static void Test_BFu1i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu0ll, BFu1i_BFu0i_BFu0ll)
//============================================================================


struct  BFu1i_BFu0i_BFu0s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu0i_BFu0s) C1{ Fi:1 Fi:0 Fs:0}



static void Test_BFu1i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu0s, BFu1i_BFu0i_BFu0s)
//============================================================================


struct  BFu1i_BFu0i_BFu15i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1i_BFu0i_BFu15i) C1{ Fi:1 Fi:0 Fi:15}



static void Test_BFu1i_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu15i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu15i, BFu1i_BFu0i_BFu15i)
//============================================================================


struct  BFu1i_BFu0i_BFu15ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1i_BFu0i_BFu15ll) C1{ Fi:1 Fi:0 FL:15}



static void Test_BFu1i_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu15ll, BFu1i_BFu0i_BFu15ll)
//============================================================================


struct  BFu1i_BFu0i_BFu15s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1i_BFu0i_BFu15s) C1{ Fi:1 Fi:0 Fs:15}



static void Test_BFu1i_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu15s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu15s, BFu1i_BFu0i_BFu15s)
//============================================================================


struct  BFu1i_BFu0i_BFu16i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1i_BFu0i_BFu16i) C1{ Fi:1 Fi:0 Fi:16}



static void Test_BFu1i_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu16i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu16i, BFu1i_BFu0i_BFu16i)
//============================================================================


struct  BFu1i_BFu0i_BFu16ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1i_BFu0i_BFu16ll) C1{ Fi:1 Fi:0 FL:16}



static void Test_BFu1i_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu16ll, BFu1i_BFu0i_BFu16ll)
//============================================================================


struct  BFu1i_BFu0i_BFu16s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1i_BFu0i_BFu16s) C1{ Fi:1 Fi:0 Fs:16}



static void Test_BFu1i_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu16s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu16s, BFu1i_BFu0i_BFu16s)
//============================================================================


struct  BFu1i_BFu0i_BFu17i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1i_BFu0i_BFu17i) C1{ Fi:1 Fi:0 Fi:17}



static void Test_BFu1i_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu17i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu17i, BFu1i_BFu0i_BFu17i)
//============================================================================


struct  BFu1i_BFu0i_BFu17ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1i_BFu0i_BFu17ll) C1{ Fi:1 Fi:0 FL:17}



static void Test_BFu1i_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu17ll, BFu1i_BFu0i_BFu17ll)
//============================================================================


struct  BFu1i_BFu0i_BFu1c  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1i_BFu0i_BFu1c) C1{ Fi:1 Fi:0 Fc:1}



static void Test_BFu1i_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu1c");
    static STRUCT_IF_C BFu1i_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1i_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu1c, BFu1i_BFu0i_BFu1c)
//============================================================================


struct  BFu1i_BFu0i_BFu1i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1i_BFu0i_BFu1i) C1{ Fi:1 Fi:0 Fi:1}



static void Test_BFu1i_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu1i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1i_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu1i, BFu1i_BFu0i_BFu1i)
//============================================================================


struct  BFu1i_BFu0i_BFu1ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1i_BFu0i_BFu1ll) C1{ Fi:1 Fi:0 FL:1}



static void Test_BFu1i_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1i_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu1ll, BFu1i_BFu0i_BFu1ll)
//============================================================================


struct  BFu1i_BFu0i_BFu1s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1i_BFu0i_BFu1s) C1{ Fi:1 Fi:0 Fs:1}



static void Test_BFu1i_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu1s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1i_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu1s, BFu1i_BFu0i_BFu1s)
//============================================================================


struct  BFu1i_BFu0i_BFu31i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1i_BFu0i_BFu31i) C1{ Fi:1 Fi:0 Fi:31}



static void Test_BFu1i_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu31i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu31i, BFu1i_BFu0i_BFu31i)
//============================================================================


struct  BFu1i_BFu0i_BFu31ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1i_BFu0i_BFu31ll) C1{ Fi:1 Fi:0 FL:31}



static void Test_BFu1i_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu31ll, BFu1i_BFu0i_BFu31ll)
//============================================================================


struct  BFu1i_BFu0i_BFu32i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1i_BFu0i_BFu32i) C1{ Fi:1 Fi:0 Fi:32}



static void Test_BFu1i_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu32i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu32i, BFu1i_BFu0i_BFu32i)
//============================================================================


struct  BFu1i_BFu0i_BFu32ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1i_BFu0i_BFu32ll) C1{ Fi:1 Fi:0 FL:32}



static void Test_BFu1i_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu32ll, BFu1i_BFu0i_BFu32ll)
//============================================================================


struct  BFu1i_BFu0i_BFu33  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1i_BFu0i_BFu33) C1{ Fi:1 Fi:0 FL:33}



static void Test_BFu1i_BFu0i_BFu33()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu33");
    static STRUCT_IF_C BFu1i_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1i_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu33, BFu1i_BFu0i_BFu33)
//============================================================================


struct  BFu1i_BFu0i_BFu7c  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1i_BFu0i_BFu7c) C1{ Fi:1 Fi:0 Fc:7}



static void Test_BFu1i_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu7c");
    static STRUCT_IF_C BFu1i_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu7c, BFu1i_BFu0i_BFu7c)
//============================================================================


struct  BFu1i_BFu0i_BFu7i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1i_BFu0i_BFu7i) C1{ Fi:1 Fi:0 Fi:7}



static void Test_BFu1i_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu7i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu7i, BFu1i_BFu0i_BFu7i)
//============================================================================


struct  BFu1i_BFu0i_BFu7ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1i_BFu0i_BFu7ll) C1{ Fi:1 Fi:0 FL:7}



static void Test_BFu1i_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu7ll, BFu1i_BFu0i_BFu7ll)
//============================================================================


struct  BFu1i_BFu0i_BFu7s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1i_BFu0i_BFu7s) C1{ Fi:1 Fi:0 Fs:7}



static void Test_BFu1i_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu7s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu7s, BFu1i_BFu0i_BFu7s)
//============================================================================


struct  BFu1i_BFu0i_BFu8c  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1i_BFu0i_BFu8c) C1{ Fi:1 Fi:0 Fc:8}



static void Test_BFu1i_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu8c");
    static STRUCT_IF_C BFu1i_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu8c, BFu1i_BFu0i_BFu8c)
//============================================================================


struct  BFu1i_BFu0i_BFu8i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1i_BFu0i_BFu8i) C1{ Fi:1 Fi:0 Fi:8}



static void Test_BFu1i_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu8i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu8i, BFu1i_BFu0i_BFu8i)
//============================================================================


struct  BFu1i_BFu0i_BFu8ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1i_BFu0i_BFu8ll) C1{ Fi:1 Fi:0 FL:8}



static void Test_BFu1i_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu8ll, BFu1i_BFu0i_BFu8ll)
//============================================================================


struct  BFu1i_BFu0i_BFu8s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1i_BFu0i_BFu8s) C1{ Fi:1 Fi:0 Fs:8}



static void Test_BFu1i_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu8s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu8s, BFu1i_BFu0i_BFu8s)
//============================================================================


struct  BFu1i_BFu0i_BFu9i  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1i_BFu0i_BFu9i) C1{ Fi:1 Fi:0 Fi:9}



static void Test_BFu1i_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu9i");
    static STRUCT_IF_C BFu1i_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu9i, BFu1i_BFu0i_BFu9i)
//============================================================================


struct  BFu1i_BFu0i_BFu9ll  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1i_BFu0i_BFu9ll) C1{ Fi:1 Fi:0 FL:9}



static void Test_BFu1i_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu9ll, BFu1i_BFu0i_BFu9ll)
//============================================================================


struct  BFu1i_BFu0i_BFu9s  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1i_BFu0i_BFu9s) C1{ Fi:1 Fi:0 Fs:9}



static void Test_BFu1i_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu0i_BFu9s");
    static STRUCT_IF_C BFu1i_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_BFu9s, BFu1i_BFu0i_BFu9s)
//============================================================================


struct  BFu1i_BFu0i_C  {
  unsigned int v1:1;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu1i_BFu0i_C) C1{ Fi:1 Fi:0 Fc}



static void Test_BFu1i_BFu0i_C()
{
  {
    init_simple_test("BFu1i_BFu0i_C");
    static STRUCT_IF_C BFu1i_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_C, BFu1i_BFu0i_C)
//============================================================================


struct  BFu1i_BFu0i_D  {
  unsigned int v1:1;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu1i_BFu0i_D) C1{ Fi:1 Fi:0 FL}



static void Test_BFu1i_BFu0i_D()
{
  {
    init_simple_test("BFu1i_BFu0i_D");
    static STRUCT_IF_C BFu1i_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_D, BFu1i_BFu0i_D)
//============================================================================


struct  BFu1i_BFu0i_F  {
  unsigned int v1:1;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu1i_BFu0i_F) C1{ Fi:1 Fi:0 Fi}



static void Test_BFu1i_BFu0i_F()
{
  {
    init_simple_test("BFu1i_BFu0i_F");
    static STRUCT_IF_C BFu1i_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_F, BFu1i_BFu0i_F)
//============================================================================


struct  BFu1i_BFu0i_I  {
  unsigned int v1:1;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu1i_BFu0i_I) C1{ Fi:1 Fi:0 Fi}



static void Test_BFu1i_BFu0i_I()
{
  {
    init_simple_test("BFu1i_BFu0i_I");
    static STRUCT_IF_C BFu1i_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_I, BFu1i_BFu0i_I)
//============================================================================


struct  BFu1i_BFu0i_Ip  {
  unsigned int v1:1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu1i_BFu0i_Ip) C1{ Fi:1 Fi:0 Fp}



static void Test_BFu1i_BFu0i_Ip()
{
  {
    init_simple_test("BFu1i_BFu0i_Ip");
    static STRUCT_IF_C BFu1i_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Ip, BFu1i_BFu0i_Ip)
//============================================================================


struct  BFu1i_BFu0i_L  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu1i_BFu0i_L) C1{ Fi:1 Fi:0 FL}



static void Test_BFu1i_BFu0i_L()
{
  {
    init_simple_test("BFu1i_BFu0i_L");
    static STRUCT_IF_C BFu1i_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_L, BFu1i_BFu0i_L)
//============================================================================


struct  BFu1i_BFu0i_S  {
  unsigned int v1:1;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu1i_BFu0i_S) C1{ Fi:1 Fi:0 Fs}



static void Test_BFu1i_BFu0i_S()
{
  {
    init_simple_test("BFu1i_BFu0i_S");
    static STRUCT_IF_C BFu1i_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_S, BFu1i_BFu0i_S)
//============================================================================


struct  BFu1i_BFu0i_Uc  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu1i_BFu0i_Uc) C1{ Fi:1 Fi:0 Fc}



static void Test_BFu1i_BFu0i_Uc()
{
  {
    init_simple_test("BFu1i_BFu0i_Uc");
    static STRUCT_IF_C BFu1i_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Uc, BFu1i_BFu0i_Uc)
//============================================================================


struct  BFu1i_BFu0i_Ui  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu1i_BFu0i_Ui) C1{ Fi:1 Fi:0 Fi}



static void Test_BFu1i_BFu0i_Ui()
{
  {
    init_simple_test("BFu1i_BFu0i_Ui");
    static STRUCT_IF_C BFu1i_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Ui, BFu1i_BFu0i_Ui)
//============================================================================


struct  BFu1i_BFu0i_Ul  {
  unsigned int v1:1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu1i_BFu0i_Ul) C1{ Fi:1 Fi:0 FL}



static void Test_BFu1i_BFu0i_Ul()
{
  {
    init_simple_test("BFu1i_BFu0i_Ul");
    static STRUCT_IF_C BFu1i_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Ul, BFu1i_BFu0i_Ul)
//============================================================================


struct  BFu1i_BFu0i_Us  {
  unsigned int v1:1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu1i_BFu0i_Us) C1{ Fi:1 Fi:0 Fs}



static void Test_BFu1i_BFu0i_Us()
{
  {
    init_simple_test("BFu1i_BFu0i_Us");
    static STRUCT_IF_C BFu1i_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Us, BFu1i_BFu0i_Us)
//============================================================================


struct  BFu1i_BFu0i_Vp  {
  unsigned int v1:1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu1i_BFu0i_Vp) C1{ Fi:1 Fi:0 Fp}



static void Test_BFu1i_BFu0i_Vp()
{
  {
    init_simple_test("BFu1i_BFu0i_Vp");
    static STRUCT_IF_C BFu1i_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0i_Vp, BFu1i_BFu0i_Vp)
//============================================================================


struct  BFu1i_BFu0ll  {
  unsigned int v1:1;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu0ll) C1{ Fi:1 FL:0}



static void Test_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll, BFu1i_BFu0ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu0c  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu0ll_BFu0c) C1{ Fi:1 FL:0 Fc:0}



static void Test_BFu1i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu0c, BFu1i_BFu0ll_BFu0c)
//============================================================================


struct  BFu1i_BFu0ll_BFu0i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu0ll_BFu0i) C1{ Fi:1 FL:0 Fi:0}



static void Test_BFu1i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu0i, BFu1i_BFu0ll_BFu0i)
//============================================================================


struct  BFu1i_BFu0ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu0ll_BFu0ll) C1{ Fi:1 FL:0 FL:0}



static void Test_BFu1i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu0ll, BFu1i_BFu0ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu0s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu0ll_BFu0s) C1{ Fi:1 FL:0 Fs:0}



static void Test_BFu1i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu0s, BFu1i_BFu0ll_BFu0s)
//============================================================================


struct  BFu1i_BFu0ll_BFu15i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1i_BFu0ll_BFu15i) C1{ Fi:1 FL:0 Fi:15}



static void Test_BFu1i_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu15i, BFu1i_BFu0ll_BFu15i)
//============================================================================


struct  BFu1i_BFu0ll_BFu15ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1i_BFu0ll_BFu15ll) C1{ Fi:1 FL:0 FL:15}



static void Test_BFu1i_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu15ll, BFu1i_BFu0ll_BFu15ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu15s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1i_BFu0ll_BFu15s) C1{ Fi:1 FL:0 Fs:15}



static void Test_BFu1i_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu15s, BFu1i_BFu0ll_BFu15s)
//============================================================================


struct  BFu1i_BFu0ll_BFu16i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1i_BFu0ll_BFu16i) C1{ Fi:1 FL:0 Fi:16}



static void Test_BFu1i_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu16i, BFu1i_BFu0ll_BFu16i)
//============================================================================


struct  BFu1i_BFu0ll_BFu16ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1i_BFu0ll_BFu16ll) C1{ Fi:1 FL:0 FL:16}



static void Test_BFu1i_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu16ll, BFu1i_BFu0ll_BFu16ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu16s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1i_BFu0ll_BFu16s) C1{ Fi:1 FL:0 Fs:16}



static void Test_BFu1i_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu16s, BFu1i_BFu0ll_BFu16s)
//============================================================================


struct  BFu1i_BFu0ll_BFu17i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1i_BFu0ll_BFu17i) C1{ Fi:1 FL:0 Fi:17}



static void Test_BFu1i_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu1i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu17i, BFu1i_BFu0ll_BFu17i)
//============================================================================


struct  BFu1i_BFu0ll_BFu17ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1i_BFu0ll_BFu17ll) C1{ Fi:1 FL:0 FL:17}



static void Test_BFu1i_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu1i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu17ll, BFu1i_BFu0ll_BFu17ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu1c  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1i_BFu0ll_BFu1c) C1{ Fi:1 FL:0 Fc:1}



static void Test_BFu1i_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1i_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu1c, BFu1i_BFu0ll_BFu1c)
//============================================================================


struct  BFu1i_BFu0ll_BFu1i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1i_BFu0ll_BFu1i) C1{ Fi:1 FL:0 Fi:1}



static void Test_BFu1i_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1i_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu1i, BFu1i_BFu0ll_BFu1i)
//============================================================================


struct  BFu1i_BFu0ll_BFu1ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1i_BFu0ll_BFu1ll) C1{ Fi:1 FL:0 FL:1}



static void Test_BFu1i_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1i_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu1ll, BFu1i_BFu0ll_BFu1ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu1s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1i_BFu0ll_BFu1s) C1{ Fi:1 FL:0 Fs:1}



static void Test_BFu1i_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1i_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu1s, BFu1i_BFu0ll_BFu1s)
//============================================================================


struct  BFu1i_BFu0ll_BFu31i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1i_BFu0ll_BFu31i) C1{ Fi:1 FL:0 Fi:31}



static void Test_BFu1i_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu1i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu31i, BFu1i_BFu0ll_BFu31i)
//============================================================================


struct  BFu1i_BFu0ll_BFu31ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1i_BFu0ll_BFu31ll) C1{ Fi:1 FL:0 FL:31}



static void Test_BFu1i_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu1i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu31ll, BFu1i_BFu0ll_BFu31ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu32i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1i_BFu0ll_BFu32i) C1{ Fi:1 FL:0 Fi:32}



static void Test_BFu1i_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu1i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu32i, BFu1i_BFu0ll_BFu32i)
//============================================================================


struct  BFu1i_BFu0ll_BFu32ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1i_BFu0ll_BFu32ll) C1{ Fi:1 FL:0 FL:32}



static void Test_BFu1i_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu1i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu32ll, BFu1i_BFu0ll_BFu32ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu33  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1i_BFu0ll_BFu33) C1{ Fi:1 FL:0 FL:33}



static void Test_BFu1i_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu33");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1i_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu33, BFu1i_BFu0ll_BFu33)
//============================================================================


struct  BFu1i_BFu0ll_BFu7c  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1i_BFu0ll_BFu7c) C1{ Fi:1 FL:0 Fc:7}



static void Test_BFu1i_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu7c, BFu1i_BFu0ll_BFu7c)
//============================================================================


struct  BFu1i_BFu0ll_BFu7i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1i_BFu0ll_BFu7i) C1{ Fi:1 FL:0 Fi:7}



static void Test_BFu1i_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu7i, BFu1i_BFu0ll_BFu7i)
//============================================================================


struct  BFu1i_BFu0ll_BFu7ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1i_BFu0ll_BFu7ll) C1{ Fi:1 FL:0 FL:7}



static void Test_BFu1i_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu7ll, BFu1i_BFu0ll_BFu7ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu7s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1i_BFu0ll_BFu7s) C1{ Fi:1 FL:0 Fs:7}



static void Test_BFu1i_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu7s, BFu1i_BFu0ll_BFu7s)
//============================================================================


struct  BFu1i_BFu0ll_BFu8c  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1i_BFu0ll_BFu8c) C1{ Fi:1 FL:0 Fc:8}



static void Test_BFu1i_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu8c, BFu1i_BFu0ll_BFu8c)
//============================================================================


struct  BFu1i_BFu0ll_BFu8i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1i_BFu0ll_BFu8i) C1{ Fi:1 FL:0 Fi:8}



static void Test_BFu1i_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu8i, BFu1i_BFu0ll_BFu8i)
//============================================================================


struct  BFu1i_BFu0ll_BFu8ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1i_BFu0ll_BFu8ll) C1{ Fi:1 FL:0 FL:8}



static void Test_BFu1i_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu8ll, BFu1i_BFu0ll_BFu8ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu8s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1i_BFu0ll_BFu8s) C1{ Fi:1 FL:0 Fs:8}



static void Test_BFu1i_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu8s, BFu1i_BFu0ll_BFu8s)
//============================================================================


struct  BFu1i_BFu0ll_BFu9i  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1i_BFu0ll_BFu9i) C1{ Fi:1 FL:0 Fi:9}



static void Test_BFu1i_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu9i, BFu1i_BFu0ll_BFu9i)
//============================================================================


struct  BFu1i_BFu0ll_BFu9ll  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1i_BFu0ll_BFu9ll) C1{ Fi:1 FL:0 FL:9}



static void Test_BFu1i_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu9ll, BFu1i_BFu0ll_BFu9ll)
//============================================================================


struct  BFu1i_BFu0ll_BFu9s  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1i_BFu0ll_BFu9s) C1{ Fi:1 FL:0 Fs:9}



static void Test_BFu1i_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu1i_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_BFu9s, BFu1i_BFu0ll_BFu9s)
//============================================================================


struct  BFu1i_BFu0ll_C  {
  unsigned int v1:1;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu1i_BFu0ll_C) C1{ Fi:1 FL:0 Fc}



static void Test_BFu1i_BFu0ll_C()
{
  {
    init_simple_test("BFu1i_BFu0ll_C");
    static STRUCT_IF_C BFu1i_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_C, BFu1i_BFu0ll_C)
//============================================================================


struct  BFu1i_BFu0ll_D  {
  unsigned int v1:1;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu1i_BFu0ll_D) C1{ Fi:1 FL:0 FL}



static void Test_BFu1i_BFu0ll_D()
{
  {
    init_simple_test("BFu1i_BFu0ll_D");
    static STRUCT_IF_C BFu1i_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_D, BFu1i_BFu0ll_D)
//============================================================================


struct  BFu1i_BFu0ll_F  {
  unsigned int v1:1;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu1i_BFu0ll_F) C1{ Fi:1 FL:0 Fi}



static void Test_BFu1i_BFu0ll_F()
{
  {
    init_simple_test("BFu1i_BFu0ll_F");
    static STRUCT_IF_C BFu1i_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_F, BFu1i_BFu0ll_F)
//============================================================================


struct  BFu1i_BFu0ll_I  {
  unsigned int v1:1;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu1i_BFu0ll_I) C1{ Fi:1 FL:0 Fi}



static void Test_BFu1i_BFu0ll_I()
{
  {
    init_simple_test("BFu1i_BFu0ll_I");
    static STRUCT_IF_C BFu1i_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_I, BFu1i_BFu0ll_I)
//============================================================================


struct  BFu1i_BFu0ll_Ip  {
  unsigned int v1:1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu1i_BFu0ll_Ip) C1{ Fi:1 FL:0 Fp}



static void Test_BFu1i_BFu0ll_Ip()
{
  {
    init_simple_test("BFu1i_BFu0ll_Ip");
    static STRUCT_IF_C BFu1i_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Ip, BFu1i_BFu0ll_Ip)
//============================================================================


struct  BFu1i_BFu0ll_L  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu1i_BFu0ll_L) C1{ Fi:1 FL:0 FL}



static void Test_BFu1i_BFu0ll_L()
{
  {
    init_simple_test("BFu1i_BFu0ll_L");
    static STRUCT_IF_C BFu1i_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_L, BFu1i_BFu0ll_L)
//============================================================================


struct  BFu1i_BFu0ll_S  {
  unsigned int v1:1;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu1i_BFu0ll_S) C1{ Fi:1 FL:0 Fs}



static void Test_BFu1i_BFu0ll_S()
{
  {
    init_simple_test("BFu1i_BFu0ll_S");
    static STRUCT_IF_C BFu1i_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_S, BFu1i_BFu0ll_S)
//============================================================================


struct  BFu1i_BFu0ll_Uc  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu1i_BFu0ll_Uc) C1{ Fi:1 FL:0 Fc}



static void Test_BFu1i_BFu0ll_Uc()
{
  {
    init_simple_test("BFu1i_BFu0ll_Uc");
    static STRUCT_IF_C BFu1i_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Uc, BFu1i_BFu0ll_Uc)
//============================================================================


struct  BFu1i_BFu0ll_Ui  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu1i_BFu0ll_Ui) C1{ Fi:1 FL:0 Fi}



static void Test_BFu1i_BFu0ll_Ui()
{
  {
    init_simple_test("BFu1i_BFu0ll_Ui");
    static STRUCT_IF_C BFu1i_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Ui, BFu1i_BFu0ll_Ui)
//============================================================================


struct  BFu1i_BFu0ll_Ul  {
  unsigned int v1:1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu1i_BFu0ll_Ul) C1{ Fi:1 FL:0 FL}



static void Test_BFu1i_BFu0ll_Ul()
{
  {
    init_simple_test("BFu1i_BFu0ll_Ul");
    static STRUCT_IF_C BFu1i_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Ul, BFu1i_BFu0ll_Ul)
//============================================================================


struct  BFu1i_BFu0ll_Us  {
  unsigned int v1:1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu1i_BFu0ll_Us) C1{ Fi:1 FL:0 Fs}



static void Test_BFu1i_BFu0ll_Us()
{
  {
    init_simple_test("BFu1i_BFu0ll_Us");
    static STRUCT_IF_C BFu1i_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu1i_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Us, BFu1i_BFu0ll_Us)
//============================================================================


struct  BFu1i_BFu0ll_Vp  {
  unsigned int v1:1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu1i_BFu0ll_Vp) C1{ Fi:1 FL:0 Fp}



static void Test_BFu1i_BFu0ll_Vp()
{
  {
    init_simple_test("BFu1i_BFu0ll_Vp");
    static STRUCT_IF_C BFu1i_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0ll_Vp, BFu1i_BFu0ll_Vp)
//============================================================================


struct  BFu1i_BFu0s  {
  unsigned int v1:1;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu0s) C1{ Fi:1 Fs:0}



static void Test_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s, BFu1i_BFu0s)
//============================================================================


struct  BFu1i_BFu0s_BFu0c  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu0s_BFu0c) C1{ Fi:1 Fs:0 Fc:0}



static void Test_BFu1i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu0c, BFu1i_BFu0s_BFu0c)
//============================================================================


struct  BFu1i_BFu0s_BFu0i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu0s_BFu0i) C1{ Fi:1 Fs:0 Fi:0}



static void Test_BFu1i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu0i, BFu1i_BFu0s_BFu0i)
//============================================================================


struct  BFu1i_BFu0s_BFu0ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu0s_BFu0ll) C1{ Fi:1 Fs:0 FL:0}



static void Test_BFu1i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu0ll, BFu1i_BFu0s_BFu0ll)
//============================================================================


struct  BFu1i_BFu0s_BFu0s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu0s_BFu0s) C1{ Fi:1 Fs:0 Fs:0}



static void Test_BFu1i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu0s, BFu1i_BFu0s_BFu0s)
//============================================================================


struct  BFu1i_BFu0s_BFu15i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1i_BFu0s_BFu15i) C1{ Fi:1 Fs:0 Fi:15}



static void Test_BFu1i_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu15i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu15i, BFu1i_BFu0s_BFu15i)
//============================================================================


struct  BFu1i_BFu0s_BFu15ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1i_BFu0s_BFu15ll) C1{ Fi:1 Fs:0 FL:15}



static void Test_BFu1i_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu15ll, BFu1i_BFu0s_BFu15ll)
//============================================================================


struct  BFu1i_BFu0s_BFu15s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1i_BFu0s_BFu15s) C1{ Fi:1 Fs:0 Fs:15}



static void Test_BFu1i_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu15s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu15s, BFu1i_BFu0s_BFu15s)
//============================================================================


struct  BFu1i_BFu0s_BFu16i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1i_BFu0s_BFu16i) C1{ Fi:1 Fs:0 Fi:16}



static void Test_BFu1i_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu16i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu16i, BFu1i_BFu0s_BFu16i)
//============================================================================


struct  BFu1i_BFu0s_BFu16ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1i_BFu0s_BFu16ll) C1{ Fi:1 Fs:0 FL:16}



static void Test_BFu1i_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu16ll, BFu1i_BFu0s_BFu16ll)
//============================================================================


struct  BFu1i_BFu0s_BFu16s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1i_BFu0s_BFu16s) C1{ Fi:1 Fs:0 Fs:16}



static void Test_BFu1i_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu16s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu16s, BFu1i_BFu0s_BFu16s)
//============================================================================


struct  BFu1i_BFu0s_BFu17i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1i_BFu0s_BFu17i) C1{ Fi:1 Fs:0 Fi:17}



static void Test_BFu1i_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu17i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu17i, BFu1i_BFu0s_BFu17i)
//============================================================================


struct  BFu1i_BFu0s_BFu17ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1i_BFu0s_BFu17ll) C1{ Fi:1 Fs:0 FL:17}



static void Test_BFu1i_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu1i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu1i_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu17ll, BFu1i_BFu0s_BFu17ll)
//============================================================================


struct  BFu1i_BFu0s_BFu1c  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1i_BFu0s_BFu1c) C1{ Fi:1 Fs:0 Fc:1}



static void Test_BFu1i_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu1c");
    static STRUCT_IF_C BFu1i_BFu0s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1i_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu1c, BFu1i_BFu0s_BFu1c)
//============================================================================


struct  BFu1i_BFu0s_BFu1i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1i_BFu0s_BFu1i) C1{ Fi:1 Fs:0 Fi:1}



static void Test_BFu1i_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu1i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1i_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu1i, BFu1i_BFu0s_BFu1i)
//============================================================================


struct  BFu1i_BFu0s_BFu1ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1i_BFu0s_BFu1ll) C1{ Fi:1 Fs:0 FL:1}



static void Test_BFu1i_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1i_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu1ll, BFu1i_BFu0s_BFu1ll)
//============================================================================


struct  BFu1i_BFu0s_BFu1s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1i_BFu0s_BFu1s) C1{ Fi:1 Fs:0 Fs:1}



static void Test_BFu1i_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu1s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1i_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu1s, BFu1i_BFu0s_BFu1s)
//============================================================================


struct  BFu1i_BFu0s_BFu31i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1i_BFu0s_BFu31i) C1{ Fi:1 Fs:0 Fi:31}



static void Test_BFu1i_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu31i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu31i, BFu1i_BFu0s_BFu31i)
//============================================================================


struct  BFu1i_BFu0s_BFu31ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1i_BFu0s_BFu31ll) C1{ Fi:1 Fs:0 FL:31}



static void Test_BFu1i_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu1i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu1i_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu31ll, BFu1i_BFu0s_BFu31ll)
//============================================================================


struct  BFu1i_BFu0s_BFu32i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1i_BFu0s_BFu32i) C1{ Fi:1 Fs:0 Fi:32}



static void Test_BFu1i_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu32i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu32i, BFu1i_BFu0s_BFu32i)
//============================================================================


struct  BFu1i_BFu0s_BFu32ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1i_BFu0s_BFu32ll) C1{ Fi:1 Fs:0 FL:32}



static void Test_BFu1i_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu1i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu32ll, BFu1i_BFu0s_BFu32ll)
//============================================================================


struct  BFu1i_BFu0s_BFu33  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1i_BFu0s_BFu33) C1{ Fi:1 Fs:0 FL:33}



static void Test_BFu1i_BFu0s_BFu33()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu33");
    static STRUCT_IF_C BFu1i_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu1i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu1i_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu33, BFu1i_BFu0s_BFu33)
//============================================================================


struct  BFu1i_BFu0s_BFu7c  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1i_BFu0s_BFu7c) C1{ Fi:1 Fs:0 Fc:7}



static void Test_BFu1i_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu7c");
    static STRUCT_IF_C BFu1i_BFu0s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu7c, BFu1i_BFu0s_BFu7c)
//============================================================================


struct  BFu1i_BFu0s_BFu7i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1i_BFu0s_BFu7i) C1{ Fi:1 Fs:0 Fi:7}



static void Test_BFu1i_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu7i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu7i, BFu1i_BFu0s_BFu7i)
//============================================================================


struct  BFu1i_BFu0s_BFu7ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1i_BFu0s_BFu7ll) C1{ Fi:1 Fs:0 FL:7}



static void Test_BFu1i_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu7ll, BFu1i_BFu0s_BFu7ll)
//============================================================================


struct  BFu1i_BFu0s_BFu7s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1i_BFu0s_BFu7s) C1{ Fi:1 Fs:0 Fs:7}



static void Test_BFu1i_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu7s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu7s, BFu1i_BFu0s_BFu7s)
//============================================================================


struct  BFu1i_BFu0s_BFu8c  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1i_BFu0s_BFu8c) C1{ Fi:1 Fs:0 Fc:8}



static void Test_BFu1i_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu8c");
    static STRUCT_IF_C BFu1i_BFu0s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu8c, BFu1i_BFu0s_BFu8c)
//============================================================================


struct  BFu1i_BFu0s_BFu8i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1i_BFu0s_BFu8i) C1{ Fi:1 Fs:0 Fi:8}



static void Test_BFu1i_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu8i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu8i, BFu1i_BFu0s_BFu8i)
//============================================================================


struct  BFu1i_BFu0s_BFu8ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1i_BFu0s_BFu8ll) C1{ Fi:1 Fs:0 FL:8}



static void Test_BFu1i_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu8ll, BFu1i_BFu0s_BFu8ll)
//============================================================================


struct  BFu1i_BFu0s_BFu8s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1i_BFu0s_BFu8s) C1{ Fi:1 Fs:0 Fs:8}



static void Test_BFu1i_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu8s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu8s, BFu1i_BFu0s_BFu8s)
//============================================================================


struct  BFu1i_BFu0s_BFu9i  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1i_BFu0s_BFu9i) C1{ Fi:1 Fs:0 Fi:9}



static void Test_BFu1i_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu9i");
    static STRUCT_IF_C BFu1i_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu9i, BFu1i_BFu0s_BFu9i)
//============================================================================


struct  BFu1i_BFu0s_BFu9ll  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1i_BFu0s_BFu9ll) C1{ Fi:1 Fs:0 FL:9}



static void Test_BFu1i_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu1i_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu9ll, BFu1i_BFu0s_BFu9ll)
//============================================================================


struct  BFu1i_BFu0s_BFu9s  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1i_BFu0s_BFu9s) C1{ Fi:1 Fs:0 Fs:9}



static void Test_BFu1i_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu1i_BFu0s_BFu9s");
    static STRUCT_IF_C BFu1i_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_BFu9s, BFu1i_BFu0s_BFu9s)
//============================================================================


struct  BFu1i_BFu0s_C  {
  unsigned int v1:1;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu1i_BFu0s_C) C1{ Fi:1 Fs:0 Fc}



static void Test_BFu1i_BFu0s_C()
{
  {
    init_simple_test("BFu1i_BFu0s_C");
    static STRUCT_IF_C BFu1i_BFu0s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu1i_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_C, BFu1i_BFu0s_C)
//============================================================================


struct  BFu1i_BFu0s_D  {
  unsigned int v1:1;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu1i_BFu0s_D) C1{ Fi:1 Fs:0 FL}



static void Test_BFu1i_BFu0s_D()
{
  {
    init_simple_test("BFu1i_BFu0s_D");
    static STRUCT_IF_C BFu1i_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_D, BFu1i_BFu0s_D)
//============================================================================


struct  BFu1i_BFu0s_F  {
  unsigned int v1:1;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu1i_BFu0s_F) C1{ Fi:1 Fs:0 Fi}



static void Test_BFu1i_BFu0s_F()
{
  {
    init_simple_test("BFu1i_BFu0s_F");
    static STRUCT_IF_C BFu1i_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_F, BFu1i_BFu0s_F)
//============================================================================


struct  BFu1i_BFu0s_I  {
  unsigned int v1:1;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu1i_BFu0s_I) C1{ Fi:1 Fs:0 Fi}



static void Test_BFu1i_BFu0s_I()
{
  {
    init_simple_test("BFu1i_BFu0s_I");
    static STRUCT_IF_C BFu1i_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_I, BFu1i_BFu0s_I)
//============================================================================


struct  BFu1i_BFu0s_Ip  {
  unsigned int v1:1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu1i_BFu0s_Ip) C1{ Fi:1 Fs:0 Fp}



static void Test_BFu1i_BFu0s_Ip()
{
  {
    init_simple_test("BFu1i_BFu0s_Ip");
    static STRUCT_IF_C BFu1i_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Ip, BFu1i_BFu0s_Ip)
//============================================================================


struct  BFu1i_BFu0s_L  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu1i_BFu0s_L) C1{ Fi:1 Fs:0 FL}



static void Test_BFu1i_BFu0s_L()
{
  {
    init_simple_test("BFu1i_BFu0s_L");
    static STRUCT_IF_C BFu1i_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_L, BFu1i_BFu0s_L)
//============================================================================


struct  BFu1i_BFu0s_S  {
  unsigned int v1:1;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu1i_BFu0s_S) C1{ Fi:1 Fs:0 Fs}



static void Test_BFu1i_BFu0s_S()
{
  {
    init_simple_test("BFu1i_BFu0s_S");
    static STRUCT_IF_C BFu1i_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu1i_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_S, BFu1i_BFu0s_S)
//============================================================================


struct  BFu1i_BFu0s_Uc  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu1i_BFu0s_Uc) C1{ Fi:1 Fs:0 Fc}



static void Test_BFu1i_BFu0s_Uc()
{
  {
    init_simple_test("BFu1i_BFu0s_Uc");
    static STRUCT_IF_C BFu1i_BFu0s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu1i_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Uc, BFu1i_BFu0s_Uc)
//============================================================================


struct  BFu1i_BFu0s_Ui  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu1i_BFu0s_Ui) C1{ Fi:1 Fs:0 Fi}



static void Test_BFu1i_BFu0s_Ui()
{
  {
    init_simple_test("BFu1i_BFu0s_Ui");
    static STRUCT_IF_C BFu1i_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu1i_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Ui, BFu1i_BFu0s_Ui)
//============================================================================


struct  BFu1i_BFu0s_Ul  {
  unsigned int v1:1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu1i_BFu0s_Ul) C1{ Fi:1 Fs:0 FL}



static void Test_BFu1i_BFu0s_Ul()
{
  {
    init_simple_test("BFu1i_BFu0s_Ul");
    static STRUCT_IF_C BFu1i_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Ul, BFu1i_BFu0s_Ul)
//============================================================================


struct  BFu1i_BFu0s_Us  {
  unsigned int v1:1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu1i_BFu0s_Us) C1{ Fi:1 Fs:0 Fs}



static void Test_BFu1i_BFu0s_Us()
{
  {
    init_simple_test("BFu1i_BFu0s_Us");
    static STRUCT_IF_C BFu1i_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu0s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu1i_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Us, BFu1i_BFu0s_Us)
//============================================================================


struct  BFu1i_BFu0s_Vp  {
  unsigned int v1:1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu1i_BFu0s_Vp) C1{ Fi:1 Fs:0 Fp}



static void Test_BFu1i_BFu0s_Vp()
{
  {
    init_simple_test("BFu1i_BFu0s_Vp");
    static STRUCT_IF_C BFu1i_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu0s_Vp, BFu1i_BFu0s_Vp)
//============================================================================


struct  BFu1i_BFu15i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu15i_BFu0c) C1{ Fi:1 Fi:15 Fc:0}



static void Test_BFu1i_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu0c, BFu1i_BFu15i_BFu0c)
//============================================================================


struct  BFu1i_BFu15i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu15i_BFu0i) C1{ Fi:1 Fi:15 Fi:0}



static void Test_BFu1i_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu0i, BFu1i_BFu15i_BFu0i)
//============================================================================


struct  BFu1i_BFu15i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu15i_BFu0ll) C1{ Fi:1 Fi:15 FL:0}



static void Test_BFu1i_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu0ll, BFu1i_BFu15i_BFu0ll)
//============================================================================


struct  BFu1i_BFu15i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu15i_BFu0s) C1{ Fi:1 Fi:15 Fs:0}



static void Test_BFu1i_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu15i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15i_BFu0s, BFu1i_BFu15i_BFu0s)
//============================================================================


struct  BFu1i_BFu15ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu15ll_BFu0c) C1{ Fi:1 FL:15 Fc:0}



static void Test_BFu1i_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu0c, BFu1i_BFu15ll_BFu0c)
//============================================================================


struct  BFu1i_BFu15ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu15ll_BFu0i) C1{ Fi:1 FL:15 Fi:0}



static void Test_BFu1i_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu0i, BFu1i_BFu15ll_BFu0i)
//============================================================================


struct  BFu1i_BFu15ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu15ll_BFu0ll) C1{ Fi:1 FL:15 FL:0}



static void Test_BFu1i_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu0ll, BFu1i_BFu15ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu15ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu15ll_BFu0s) C1{ Fi:1 FL:15 Fs:0}



static void Test_BFu1i_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15ll_BFu0s, BFu1i_BFu15ll_BFu0s)
//============================================================================


struct  BFu1i_BFu15s_BFu0c  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu15s_BFu0c) C1{ Fi:1 Fs:15 Fc:0}



static void Test_BFu1i_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu0c, BFu1i_BFu15s_BFu0c)
//============================================================================


struct  BFu1i_BFu15s_BFu0i  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu15s_BFu0i) C1{ Fi:1 Fs:15 Fi:0}



static void Test_BFu1i_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu0i, BFu1i_BFu15s_BFu0i)
//============================================================================


struct  BFu1i_BFu15s_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu15s_BFu0ll) C1{ Fi:1 Fs:15 FL:0}



static void Test_BFu1i_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu0ll, BFu1i_BFu15s_BFu0ll)
//============================================================================


struct  BFu1i_BFu15s_BFu0s  {
  unsigned int v1:1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu15s_BFu0s) C1{ Fi:1 Fs:15 Fs:0}



static void Test_BFu1i_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu15s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu15s_BFu0s, BFu1i_BFu15s_BFu0s)
//============================================================================


struct  BFu1i_BFu16i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu16i_BFu0c) C1{ Fi:1 Fi:16 Fc:0}



static void Test_BFu1i_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu0c, BFu1i_BFu16i_BFu0c)
//============================================================================


struct  BFu1i_BFu16i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu16i_BFu0i) C1{ Fi:1 Fi:16 Fi:0}



static void Test_BFu1i_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu0i, BFu1i_BFu16i_BFu0i)
//============================================================================


struct  BFu1i_BFu16i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu16i_BFu0ll) C1{ Fi:1 Fi:16 FL:0}



static void Test_BFu1i_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu0ll, BFu1i_BFu16i_BFu0ll)
//============================================================================


struct  BFu1i_BFu16i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu16i_BFu0s) C1{ Fi:1 Fi:16 Fs:0}



static void Test_BFu1i_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu16i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16i_BFu0s, BFu1i_BFu16i_BFu0s)
//============================================================================


struct  BFu1i_BFu16ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu16ll_BFu0c) C1{ Fi:1 FL:16 Fc:0}



static void Test_BFu1i_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu0c, BFu1i_BFu16ll_BFu0c)
//============================================================================


struct  BFu1i_BFu16ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu16ll_BFu0i) C1{ Fi:1 FL:16 Fi:0}



static void Test_BFu1i_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu0i, BFu1i_BFu16ll_BFu0i)
//============================================================================


struct  BFu1i_BFu16ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu16ll_BFu0ll) C1{ Fi:1 FL:16 FL:0}



static void Test_BFu1i_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu0ll, BFu1i_BFu16ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu16ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu16ll_BFu0s) C1{ Fi:1 FL:16 Fs:0}



static void Test_BFu1i_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16ll_BFu0s, BFu1i_BFu16ll_BFu0s)
//============================================================================


struct  BFu1i_BFu16s_BFu0c  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu16s_BFu0c) C1{ Fi:1 Fs:16 Fc:0}



static void Test_BFu1i_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu0c, BFu1i_BFu16s_BFu0c)
//============================================================================


struct  BFu1i_BFu16s_BFu0i  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu16s_BFu0i) C1{ Fi:1 Fs:16 Fi:0}



static void Test_BFu1i_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu0i, BFu1i_BFu16s_BFu0i)
//============================================================================


struct  BFu1i_BFu16s_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu16s_BFu0ll) C1{ Fi:1 Fs:16 FL:0}



static void Test_BFu1i_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu0ll, BFu1i_BFu16s_BFu0ll)
//============================================================================


struct  BFu1i_BFu16s_BFu0s  {
  unsigned int v1:1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu16s_BFu0s) C1{ Fi:1 Fs:16 Fs:0}



static void Test_BFu1i_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu16s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu16s_BFu0s, BFu1i_BFu16s_BFu0s)
//============================================================================


struct  BFu1i_BFu17i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu17i_BFu0c) C1{ Fi:1 Fi:17 Fc:0}



static void Test_BFu1i_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu0c, BFu1i_BFu17i_BFu0c)
//============================================================================


struct  BFu1i_BFu17i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu17i_BFu0i) C1{ Fi:1 Fi:17 Fi:0}



static void Test_BFu1i_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu0i, BFu1i_BFu17i_BFu0i)
//============================================================================


struct  BFu1i_BFu17i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu17i_BFu0ll) C1{ Fi:1 Fi:17 FL:0}



static void Test_BFu1i_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu0ll, BFu1i_BFu17i_BFu0ll)
//============================================================================


struct  BFu1i_BFu17i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu17i_BFu0s) C1{ Fi:1 Fi:17 Fs:0}



static void Test_BFu1i_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu17i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17i_BFu0s, BFu1i_BFu17i_BFu0s)
//============================================================================


struct  BFu1i_BFu17ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu17ll_BFu0c) C1{ Fi:1 FL:17 Fc:0}



static void Test_BFu1i_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu0c, BFu1i_BFu17ll_BFu0c)
//============================================================================


struct  BFu1i_BFu17ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu17ll_BFu0i) C1{ Fi:1 FL:17 Fi:0}



static void Test_BFu1i_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu0i, BFu1i_BFu17ll_BFu0i)
//============================================================================


struct  BFu1i_BFu17ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu17ll_BFu0ll) C1{ Fi:1 FL:17 FL:0}



static void Test_BFu1i_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu0ll, BFu1i_BFu17ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu17ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu17ll_BFu0s) C1{ Fi:1 FL:17 Fs:0}



static void Test_BFu1i_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu17ll_BFu0s, BFu1i_BFu17ll_BFu0s)
//============================================================================


struct  BFu1i_BFu1c_BFu0c  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu1c_BFu0c) C1{ Fi:1 Fc:1 Fc:0}



static void Test_BFu1i_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu0c");
    static STRUCT_IF_C BFu1i_BFu1c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu0c, BFu1i_BFu1c_BFu0c)
//============================================================================


struct  BFu1i_BFu1c_BFu0i  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu1c_BFu0i) C1{ Fi:1 Fc:1 Fi:0}



static void Test_BFu1i_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu0i");
    static STRUCT_IF_C BFu1i_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu0i, BFu1i_BFu1c_BFu0i)
//============================================================================


struct  BFu1i_BFu1c_BFu0ll  {
  unsigned int v1:1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu1c_BFu0ll) C1{ Fi:1 Fc:1 FL:0}



static void Test_BFu1i_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu0ll, BFu1i_BFu1c_BFu0ll)
//============================================================================


struct  BFu1i_BFu1c_BFu0s  {
  unsigned int v1:1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu1c_BFu0s) C1{ Fi:1 Fc:1 Fs:0}



static void Test_BFu1i_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu1c_BFu0s");
    static STRUCT_IF_C BFu1i_BFu1c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1c_BFu0s, BFu1i_BFu1c_BFu0s)
//============================================================================


struct  BFu1i_BFu1i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu1i_BFu0c) C1{ Fi:1 Fi:1 Fc:0}



static void Test_BFu1i_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu0c, BFu1i_BFu1i_BFu0c)
//============================================================================


struct  BFu1i_BFu1i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu1i_BFu0i) C1{ Fi:1 Fi:1 Fi:0}



static void Test_BFu1i_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu0i, BFu1i_BFu1i_BFu0i)
//============================================================================


struct  BFu1i_BFu1i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu1i_BFu0ll) C1{ Fi:1 Fi:1 FL:0}



static void Test_BFu1i_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu0ll, BFu1i_BFu1i_BFu0ll)
//============================================================================


struct  BFu1i_BFu1i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu1i_BFu0s) C1{ Fi:1 Fi:1 Fs:0}



static void Test_BFu1i_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu1i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1i_BFu0s, BFu1i_BFu1i_BFu0s)
//============================================================================


struct  BFu1i_BFu1ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu1ll_BFu0c) C1{ Fi:1 FL:1 Fc:0}



static void Test_BFu1i_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu0c, BFu1i_BFu1ll_BFu0c)
//============================================================================


struct  BFu1i_BFu1ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu1ll_BFu0i) C1{ Fi:1 FL:1 Fi:0}



static void Test_BFu1i_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu0i, BFu1i_BFu1ll_BFu0i)
//============================================================================


struct  BFu1i_BFu1ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu1ll_BFu0ll) C1{ Fi:1 FL:1 FL:0}



static void Test_BFu1i_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu0ll, BFu1i_BFu1ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu1ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu1ll_BFu0s) C1{ Fi:1 FL:1 Fs:0}



static void Test_BFu1i_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1ll_BFu0s, BFu1i_BFu1ll_BFu0s)
//============================================================================


struct  BFu1i_BFu1s_BFu0c  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu1s_BFu0c) C1{ Fi:1 Fs:1 Fc:0}



static void Test_BFu1i_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu1s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu0c, BFu1i_BFu1s_BFu0c)
//============================================================================


struct  BFu1i_BFu1s_BFu0i  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu1s_BFu0i) C1{ Fi:1 Fs:1 Fi:0}



static void Test_BFu1i_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu0i, BFu1i_BFu1s_BFu0i)
//============================================================================


struct  BFu1i_BFu1s_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu1s_BFu0ll) C1{ Fi:1 Fs:1 FL:0}



static void Test_BFu1i_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu0ll, BFu1i_BFu1s_BFu0ll)
//============================================================================


struct  BFu1i_BFu1s_BFu0s  {
  unsigned int v1:1;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu1s_BFu0s) C1{ Fi:1 Fs:1 Fs:0}



static void Test_BFu1i_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu1s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu1s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu1s_BFu0s, BFu1i_BFu1s_BFu0s)
//============================================================================


struct  BFu1i_BFu31i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu31i_BFu0c) C1{ Fi:1 Fi:31 Fc:0}



static void Test_BFu1i_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu31i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu0c, BFu1i_BFu31i_BFu0c)
//============================================================================


struct  BFu1i_BFu31i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu31i_BFu0i) C1{ Fi:1 Fi:31 Fi:0}



static void Test_BFu1i_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu31i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu0i, BFu1i_BFu31i_BFu0i)
//============================================================================


struct  BFu1i_BFu31i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu31i_BFu0ll) C1{ Fi:1 Fi:31 FL:0}



static void Test_BFu1i_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu0ll, BFu1i_BFu31i_BFu0ll)
//============================================================================


struct  BFu1i_BFu31i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu31i_BFu0s) C1{ Fi:1 Fi:31 Fs:0}



static void Test_BFu1i_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu31i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu31i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31i_BFu0s, BFu1i_BFu31i_BFu0s)
//============================================================================


struct  BFu1i_BFu31ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu31ll_BFu0c) C1{ Fi:1 FL:31 Fc:0}



static void Test_BFu1i_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu0c, BFu1i_BFu31ll_BFu0c)
//============================================================================


struct  BFu1i_BFu31ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu31ll_BFu0i) C1{ Fi:1 FL:31 Fi:0}



static void Test_BFu1i_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu0i, BFu1i_BFu31ll_BFu0i)
//============================================================================


struct  BFu1i_BFu31ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu31ll_BFu0ll) C1{ Fi:1 FL:31 FL:0}



static void Test_BFu1i_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu0ll, BFu1i_BFu31ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu31ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu31ll_BFu0s) C1{ Fi:1 FL:31 Fs:0}



static void Test_BFu1i_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu31ll_BFu0s, BFu1i_BFu31ll_BFu0s)
//============================================================================


struct  BFu1i_BFu32i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu32i_BFu0c) C1{ Fi:1 Fi:32 Fc:0}



static void Test_BFu1i_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu0c, BFu1i_BFu32i_BFu0c)
//============================================================================


struct  BFu1i_BFu32i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu32i_BFu0i) C1{ Fi:1 Fi:32 Fi:0}



static void Test_BFu1i_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu0i, BFu1i_BFu32i_BFu0i)
//============================================================================


struct  BFu1i_BFu32i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu32i_BFu0ll) C1{ Fi:1 Fi:32 FL:0}



static void Test_BFu1i_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu0ll, BFu1i_BFu32i_BFu0ll)
//============================================================================


struct  BFu1i_BFu32i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu32i_BFu0s) C1{ Fi:1 Fi:32 Fs:0}



static void Test_BFu1i_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu32i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32i_BFu0s, BFu1i_BFu32i_BFu0s)
//============================================================================


struct  BFu1i_BFu32ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu32ll_BFu0c) C1{ Fi:1 FL:32 Fc:0}



static void Test_BFu1i_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu0c, BFu1i_BFu32ll_BFu0c)
//============================================================================


struct  BFu1i_BFu32ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu32ll_BFu0i) C1{ Fi:1 FL:32 Fi:0}



static void Test_BFu1i_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu0i, BFu1i_BFu32ll_BFu0i)
//============================================================================


struct  BFu1i_BFu32ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu32ll_BFu0ll) C1{ Fi:1 FL:32 FL:0}



static void Test_BFu1i_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu0ll, BFu1i_BFu32ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu32ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu32ll_BFu0s) C1{ Fi:1 FL:32 Fs:0}



static void Test_BFu1i_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu32ll_BFu0s, BFu1i_BFu32ll_BFu0s)
//============================================================================


struct  BFu1i_BFu33_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu33_BFu0c) C1{ Fi:1 FL:33 Fc:0}



static void Test_BFu1i_BFu33_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu33_BFu0c");
    static STRUCT_IF_C BFu1i_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu0c, BFu1i_BFu33_BFu0c)
//============================================================================


struct  BFu1i_BFu33_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu33_BFu0i) C1{ Fi:1 FL:33 Fi:0}



static void Test_BFu1i_BFu33_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu33_BFu0i");
    static STRUCT_IF_C BFu1i_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu0i, BFu1i_BFu33_BFu0i)
//============================================================================


struct  BFu1i_BFu33_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu33_BFu0ll) C1{ Fi:1 FL:33 FL:0}



static void Test_BFu1i_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu33_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu0ll, BFu1i_BFu33_BFu0ll)
//============================================================================


struct  BFu1i_BFu33_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu33_BFu0s) C1{ Fi:1 FL:33 Fs:0}



static void Test_BFu1i_BFu33_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu33_BFu0s");
    static STRUCT_IF_C BFu1i_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu33_BFu0s, BFu1i_BFu33_BFu0s)
//============================================================================


struct  BFu1i_BFu7c_BFu0c  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu7c_BFu0c) C1{ Fi:1 Fc:7 Fc:0}



static void Test_BFu1i_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu0c");
    static STRUCT_IF_C BFu1i_BFu7c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu0c, BFu1i_BFu7c_BFu0c)
//============================================================================


struct  BFu1i_BFu7c_BFu0i  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu7c_BFu0i) C1{ Fi:1 Fc:7 Fi:0}



static void Test_BFu1i_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu0i");
    static STRUCT_IF_C BFu1i_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu0i, BFu1i_BFu7c_BFu0i)
//============================================================================


struct  BFu1i_BFu7c_BFu0ll  {
  unsigned int v1:1;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu7c_BFu0ll) C1{ Fi:1 Fc:7 FL:0}



static void Test_BFu1i_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu0ll, BFu1i_BFu7c_BFu0ll)
//============================================================================


struct  BFu1i_BFu7c_BFu0s  {
  unsigned int v1:1;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu7c_BFu0s) C1{ Fi:1 Fc:7 Fs:0}



static void Test_BFu1i_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu7c_BFu0s");
    static STRUCT_IF_C BFu1i_BFu7c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7c_BFu0s, BFu1i_BFu7c_BFu0s)
//============================================================================


struct  BFu1i_BFu7i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu7i_BFu0c) C1{ Fi:1 Fi:7 Fc:0}



static void Test_BFu1i_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu7i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7i_BFu0c, BFu1i_BFu7i_BFu0c)
//============================================================================


struct  BFu1i_BFu7i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu7i_BFu0i) C1{ Fi:1 Fi:7 Fi:0}



static void Test_BFu1i_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu7i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7i_BFu0i, BFu1i_BFu7i_BFu0i)
//============================================================================


struct  BFu1i_BFu7i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu7i_BFu0ll) C1{ Fi:1 Fi:7 FL:0}



static void Test_BFu1i_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7i_BFu0ll, BFu1i_BFu7i_BFu0ll)
//============================================================================


struct  BFu1i_BFu7i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu7i_BFu0s) C1{ Fi:1 Fi:7 Fs:0}



static void Test_BFu1i_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu7i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7i_BFu0s, BFu1i_BFu7i_BFu0s)
//============================================================================


struct  BFu1i_BFu7ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu7ll_BFu0c) C1{ Fi:1 FL:7 Fc:0}



static void Test_BFu1i_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7ll_BFu0c, BFu1i_BFu7ll_BFu0c)
//============================================================================


struct  BFu1i_BFu7ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu7ll_BFu0i) C1{ Fi:1 FL:7 Fi:0}



static void Test_BFu1i_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7ll_BFu0i, BFu1i_BFu7ll_BFu0i)
//============================================================================


struct  BFu1i_BFu7ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu7ll_BFu0ll) C1{ Fi:1 FL:7 FL:0}



static void Test_BFu1i_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7ll_BFu0ll, BFu1i_BFu7ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu7ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu7ll_BFu0s) C1{ Fi:1 FL:7 Fs:0}



static void Test_BFu1i_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7ll_BFu0s, BFu1i_BFu7ll_BFu0s)
//============================================================================


struct  BFu1i_BFu7s_BFu0c  {
  unsigned int v1:1;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu7s_BFu0c) C1{ Fi:1 Fs:7 Fc:0}



static void Test_BFu1i_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu7s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu7s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7s_BFu0c, BFu1i_BFu7s_BFu0c)
//============================================================================


struct  BFu1i_BFu7s_BFu0i  {
  unsigned int v1:1;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu7s_BFu0i) C1{ Fi:1 Fs:7 Fi:0}



static void Test_BFu1i_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu7s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7s_BFu0i, BFu1i_BFu7s_BFu0i)
//============================================================================


struct  BFu1i_BFu7s_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu7s_BFu0ll) C1{ Fi:1 Fs:7 FL:0}



static void Test_BFu1i_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7s_BFu0ll, BFu1i_BFu7s_BFu0ll)
//============================================================================


struct  BFu1i_BFu7s_BFu0s  {
  unsigned int v1:1;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu7s_BFu0s) C1{ Fi:1 Fs:7 Fs:0}



static void Test_BFu1i_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu7s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu7s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu7s_BFu0s, BFu1i_BFu7s_BFu0s)
//============================================================================


struct  BFu1i_BFu8c_BFu0c  {
  unsigned int v1:1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu8c_BFu0c) C1{ Fi:1 Fc:8 Fc:0}



static void Test_BFu1i_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu8c_BFu0c");
    static STRUCT_IF_C BFu1i_BFu8c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8c_BFu0c, BFu1i_BFu8c_BFu0c)
//============================================================================


struct  BFu1i_BFu8c_BFu0i  {
  unsigned int v1:1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu8c_BFu0i) C1{ Fi:1 Fc:8 Fi:0}



static void Test_BFu1i_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu8c_BFu0i");
    static STRUCT_IF_C BFu1i_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8c_BFu0i, BFu1i_BFu8c_BFu0i)
//============================================================================


struct  BFu1i_BFu8c_BFu0ll  {
  unsigned int v1:1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu8c_BFu0ll) C1{ Fi:1 Fc:8 FL:0}



static void Test_BFu1i_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8c_BFu0ll, BFu1i_BFu8c_BFu0ll)
//============================================================================


struct  BFu1i_BFu8c_BFu0s  {
  unsigned int v1:1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu8c_BFu0s) C1{ Fi:1 Fc:8 Fs:0}



static void Test_BFu1i_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu8c_BFu0s");
    static STRUCT_IF_C BFu1i_BFu8c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8c_BFu0s, BFu1i_BFu8c_BFu0s)
//============================================================================


struct  BFu1i_BFu8i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu8i_BFu0c) C1{ Fi:1 Fi:8 Fc:0}



static void Test_BFu1i_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu8i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8i_BFu0c, BFu1i_BFu8i_BFu0c)
//============================================================================


struct  BFu1i_BFu8i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu8i_BFu0i) C1{ Fi:1 Fi:8 Fi:0}



static void Test_BFu1i_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu8i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8i_BFu0i, BFu1i_BFu8i_BFu0i)
//============================================================================


struct  BFu1i_BFu8i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu8i_BFu0ll) C1{ Fi:1 Fi:8 FL:0}



static void Test_BFu1i_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8i_BFu0ll, BFu1i_BFu8i_BFu0ll)
//============================================================================


struct  BFu1i_BFu8i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu8i_BFu0s) C1{ Fi:1 Fi:8 Fs:0}



static void Test_BFu1i_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu8i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8i_BFu0s, BFu1i_BFu8i_BFu0s)
//============================================================================


struct  BFu1i_BFu8ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu8ll_BFu0c) C1{ Fi:1 FL:8 Fc:0}



static void Test_BFu1i_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8ll_BFu0c, BFu1i_BFu8ll_BFu0c)
//============================================================================


struct  BFu1i_BFu8ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu8ll_BFu0i) C1{ Fi:1 FL:8 Fi:0}



static void Test_BFu1i_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8ll_BFu0i, BFu1i_BFu8ll_BFu0i)
//============================================================================


struct  BFu1i_BFu8ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu8ll_BFu0ll) C1{ Fi:1 FL:8 FL:0}



static void Test_BFu1i_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8ll_BFu0ll, BFu1i_BFu8ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu8ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu8ll_BFu0s) C1{ Fi:1 FL:8 Fs:0}



static void Test_BFu1i_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8ll_BFu0s, BFu1i_BFu8ll_BFu0s)
//============================================================================


struct  BFu1i_BFu8s_BFu0c  {
  unsigned int v1:1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu8s_BFu0c) C1{ Fi:1 Fs:8 Fc:0}



static void Test_BFu1i_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu8s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu8s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8s_BFu0c, BFu1i_BFu8s_BFu0c)
//============================================================================


struct  BFu1i_BFu8s_BFu0i  {
  unsigned int v1:1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu8s_BFu0i) C1{ Fi:1 Fs:8 Fi:0}



static void Test_BFu1i_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu8s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8s_BFu0i, BFu1i_BFu8s_BFu0i)
//============================================================================


struct  BFu1i_BFu8s_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu8s_BFu0ll) C1{ Fi:1 Fs:8 FL:0}



static void Test_BFu1i_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8s_BFu0ll, BFu1i_BFu8s_BFu0ll)
//============================================================================


struct  BFu1i_BFu8s_BFu0s  {
  unsigned int v1:1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu8s_BFu0s) C1{ Fi:1 Fs:8 Fs:0}



static void Test_BFu1i_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu8s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu8s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu8s_BFu0s, BFu1i_BFu8s_BFu0s)
//============================================================================


struct  BFu1i_BFu9i_BFu0c  {
  unsigned int v1:1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu9i_BFu0c) C1{ Fi:1 Fi:9 Fc:0}



static void Test_BFu1i_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu9i_BFu0c");
    static STRUCT_IF_C BFu1i_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9i_BFu0c, BFu1i_BFu9i_BFu0c)
//============================================================================


struct  BFu1i_BFu9i_BFu0i  {
  unsigned int v1:1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu9i_BFu0i) C1{ Fi:1 Fi:9 Fi:0}



static void Test_BFu1i_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu9i_BFu0i");
    static STRUCT_IF_C BFu1i_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9i_BFu0i, BFu1i_BFu9i_BFu0i)
//============================================================================


struct  BFu1i_BFu9i_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu9i_BFu0ll) C1{ Fi:1 Fi:9 FL:0}



static void Test_BFu1i_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9i_BFu0ll, BFu1i_BFu9i_BFu0ll)
//============================================================================


struct  BFu1i_BFu9i_BFu0s  {
  unsigned int v1:1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu9i_BFu0s) C1{ Fi:1 Fi:9 Fs:0}



static void Test_BFu1i_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu9i_BFu0s");
    static STRUCT_IF_C BFu1i_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9i_BFu0s, BFu1i_BFu9i_BFu0s)
//============================================================================


struct  BFu1i_BFu9ll_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu9ll_BFu0c) C1{ Fi:1 FL:9 Fc:0}



static void Test_BFu1i_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu1i_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9ll_BFu0c, BFu1i_BFu9ll_BFu0c)
//============================================================================


struct  BFu1i_BFu9ll_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu9ll_BFu0i) C1{ Fi:1 FL:9 Fi:0}



static void Test_BFu1i_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu1i_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9ll_BFu0i, BFu1i_BFu9ll_BFu0i)
//============================================================================


struct  BFu1i_BFu9ll_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu9ll_BFu0ll) C1{ Fi:1 FL:9 FL:0}



static void Test_BFu1i_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9ll_BFu0ll, BFu1i_BFu9ll_BFu0ll)
//============================================================================


struct  BFu1i_BFu9ll_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu9ll_BFu0s) C1{ Fi:1 FL:9 Fs:0}



static void Test_BFu1i_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu1i_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9ll_BFu0s, BFu1i_BFu9ll_BFu0s)
//============================================================================


struct  BFu1i_BFu9s_BFu0c  {
  unsigned int v1:1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1i_BFu9s_BFu0c) C1{ Fi:1 Fs:9 Fc:0}



static void Test_BFu1i_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu1i_BFu9s_BFu0c");
    static STRUCT_IF_C BFu1i_BFu9s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9s_BFu0c, BFu1i_BFu9s_BFu0c)
//============================================================================


struct  BFu1i_BFu9s_BFu0i  {
  unsigned int v1:1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1i_BFu9s_BFu0i) C1{ Fi:1 Fs:9 Fi:0}



static void Test_BFu1i_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu1i_BFu9s_BFu0i");
    static STRUCT_IF_C BFu1i_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9s_BFu0i, BFu1i_BFu9s_BFu0i)
//============================================================================


struct  BFu1i_BFu9s_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1i_BFu9s_BFu0ll) C1{ Fi:1 Fs:9 FL:0}



static void Test_BFu1i_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu1i_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu1i_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9s_BFu0ll, BFu1i_BFu9s_BFu0ll)
//============================================================================


struct  BFu1i_BFu9s_BFu0s  {
  unsigned int v1:1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1i_BFu9s_BFu0s) C1{ Fi:1 Fs:9 Fs:0}



static void Test_BFu1i_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu1i_BFu9s_BFu0s");
    static STRUCT_IF_C BFu1i_BFu9s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_BFu9s_BFu0s, BFu1i_BFu9s_BFu0s)
//============================================================================


struct  BFu1i_C_BFu0c  {
  unsigned int v1:1;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_C_BFu0c) C1{ Fi:1 Fc Fc:0}



static void Test_BFu1i_C_BFu0c()
{
  {
    init_simple_test("BFu1i_C_BFu0c");
    static STRUCT_IF_C BFu1i_C_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_C_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_C_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1i_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_C_BFu0c, BFu1i_C_BFu0c)
//============================================================================


struct  BFu1i_C_BFu0i  {
  unsigned int v1:1;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_C_BFu0i) C1{ Fi:1 Fc Fi:0}



static void Test_BFu1i_C_BFu0i()
{
  {
    init_simple_test("BFu1i_C_BFu0i");
    static STRUCT_IF_C BFu1i_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_C_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_C_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1i_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_C_BFu0i, BFu1i_C_BFu0i)
//============================================================================


struct  BFu1i_C_BFu0ll  {
  unsigned int v1:1;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_C_BFu0ll) C1{ Fi:1 Fc FL:0}



static void Test_BFu1i_C_BFu0ll()
{
  {
    init_simple_test("BFu1i_C_BFu0ll");
    static STRUCT_IF_C BFu1i_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_C_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1i_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_C_BFu0ll, BFu1i_C_BFu0ll)
//============================================================================


struct  BFu1i_C_BFu0s  {
  unsigned int v1:1;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_C_BFu0s) C1{ Fi:1 Fc Fs:0}



static void Test_BFu1i_C_BFu0s()
{
  {
    init_simple_test("BFu1i_C_BFu0s");
    static STRUCT_IF_C BFu1i_C_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_C_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_C_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1i_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_C_BFu0s, BFu1i_C_BFu0s)
//============================================================================


struct  BFu1i_D_BFu0c  {
  unsigned int v1:1;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_D_BFu0c) C1{ Fi:1 FL Fc:0}



static void Test_BFu1i_D_BFu0c()
{
  {
    init_simple_test("BFu1i_D_BFu0c");
    static STRUCT_IF_C BFu1i_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_D_BFu0c, BFu1i_D_BFu0c)
//============================================================================


struct  BFu1i_D_BFu0i  {
  unsigned int v1:1;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_D_BFu0i) C1{ Fi:1 FL Fi:0}



static void Test_BFu1i_D_BFu0i()
{
  {
    init_simple_test("BFu1i_D_BFu0i");
    static STRUCT_IF_C BFu1i_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_D_BFu0i, BFu1i_D_BFu0i)
//============================================================================


struct  BFu1i_D_BFu0ll  {
  unsigned int v1:1;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_D_BFu0ll) C1{ Fi:1 FL FL:0}



static void Test_BFu1i_D_BFu0ll()
{
  {
    init_simple_test("BFu1i_D_BFu0ll");
    static STRUCT_IF_C BFu1i_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_D_BFu0ll, BFu1i_D_BFu0ll)
//============================================================================


struct  BFu1i_D_BFu0s  {
  unsigned int v1:1;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_D_BFu0s) C1{ Fi:1 FL Fs:0}



static void Test_BFu1i_D_BFu0s()
{
  {
    init_simple_test("BFu1i_D_BFu0s");
    static STRUCT_IF_C BFu1i_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_D_BFu0s, BFu1i_D_BFu0s)
//============================================================================


struct  BFu1i_F_BFu0c  {
  unsigned int v1:1;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_F_BFu0c) C1{ Fi:1 Fi Fc:0}



static void Test_BFu1i_F_BFu0c()
{
  {
    init_simple_test("BFu1i_F_BFu0c");
    static STRUCT_IF_C BFu1i_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1i_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_F_BFu0c, BFu1i_F_BFu0c)
//============================================================================


struct  BFu1i_F_BFu0i  {
  unsigned int v1:1;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_F_BFu0i) C1{ Fi:1 Fi Fi:0}



static void Test_BFu1i_F_BFu0i()
{
  {
    init_simple_test("BFu1i_F_BFu0i");
    static STRUCT_IF_C BFu1i_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1i_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_F_BFu0i, BFu1i_F_BFu0i)
//============================================================================


struct  BFu1i_F_BFu0ll  {
  unsigned int v1:1;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_F_BFu0ll) C1{ Fi:1 Fi FL:0}



static void Test_BFu1i_F_BFu0ll()
{
  {
    init_simple_test("BFu1i_F_BFu0ll");
    static STRUCT_IF_C BFu1i_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1i_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_F_BFu0ll, BFu1i_F_BFu0ll)
//============================================================================


struct  BFu1i_F_BFu0s  {
  unsigned int v1:1;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_F_BFu0s) C1{ Fi:1 Fi Fs:0}



static void Test_BFu1i_F_BFu0s()
{
  {
    init_simple_test("BFu1i_F_BFu0s");
    static STRUCT_IF_C BFu1i_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1i_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_F_BFu0s, BFu1i_F_BFu0s)
//============================================================================


struct  BFu1i_I_BFu0c  {
  unsigned int v1:1;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_I_BFu0c) C1{ Fi:1 Fi Fc:0}



static void Test_BFu1i_I_BFu0c()
{
  {
    init_simple_test("BFu1i_I_BFu0c");
    static STRUCT_IF_C BFu1i_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1i_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_I_BFu0c, BFu1i_I_BFu0c)
//============================================================================


struct  BFu1i_I_BFu0i  {
  unsigned int v1:1;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_I_BFu0i) C1{ Fi:1 Fi Fi:0}



static void Test_BFu1i_I_BFu0i()
{
  {
    init_simple_test("BFu1i_I_BFu0i");
    static STRUCT_IF_C BFu1i_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1i_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_I_BFu0i, BFu1i_I_BFu0i)
//============================================================================


struct  BFu1i_I_BFu0ll  {
  unsigned int v1:1;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_I_BFu0ll) C1{ Fi:1 Fi FL:0}



static void Test_BFu1i_I_BFu0ll()
{
  {
    init_simple_test("BFu1i_I_BFu0ll");
    static STRUCT_IF_C BFu1i_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1i_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_I_BFu0ll, BFu1i_I_BFu0ll)
//============================================================================


struct  BFu1i_I_BFu0s  {
  unsigned int v1:1;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_I_BFu0s) C1{ Fi:1 Fi Fs:0}



static void Test_BFu1i_I_BFu0s()
{
  {
    init_simple_test("BFu1i_I_BFu0s");
    static STRUCT_IF_C BFu1i_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1i_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_I_BFu0s, BFu1i_I_BFu0s)
//============================================================================


struct  BFu1i_Ip_BFu0c  {
  unsigned int v1:1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_Ip_BFu0c) C1{ Fi:1 Fp Fc:0}



static void Test_BFu1i_Ip_BFu0c()
{
  {
    init_simple_test("BFu1i_Ip_BFu0c");
    static STRUCT_IF_C BFu1i_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ip_BFu0c, BFu1i_Ip_BFu0c)
//============================================================================


struct  BFu1i_Ip_BFu0i  {
  unsigned int v1:1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_Ip_BFu0i) C1{ Fi:1 Fp Fi:0}



static void Test_BFu1i_Ip_BFu0i()
{
  {
    init_simple_test("BFu1i_Ip_BFu0i");
    static STRUCT_IF_C BFu1i_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ip_BFu0i, BFu1i_Ip_BFu0i)
//============================================================================


struct  BFu1i_Ip_BFu0ll  {
  unsigned int v1:1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_Ip_BFu0ll) C1{ Fi:1 Fp FL:0}



static void Test_BFu1i_Ip_BFu0ll()
{
  {
    init_simple_test("BFu1i_Ip_BFu0ll");
    static STRUCT_IF_C BFu1i_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ip_BFu0ll, BFu1i_Ip_BFu0ll)
//============================================================================


struct  BFu1i_Ip_BFu0s  {
  unsigned int v1:1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_Ip_BFu0s) C1{ Fi:1 Fp Fs:0}



static void Test_BFu1i_Ip_BFu0s()
{
  {
    init_simple_test("BFu1i_Ip_BFu0s");
    static STRUCT_IF_C BFu1i_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ip_BFu0s, BFu1i_Ip_BFu0s)
//============================================================================


struct  BFu1i_L_BFu0c  {
  unsigned int v1:1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_L_BFu0c) C1{ Fi:1 FL Fc:0}



static void Test_BFu1i_L_BFu0c()
{
  {
    init_simple_test("BFu1i_L_BFu0c");
    static STRUCT_IF_C BFu1i_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_L_BFu0c, BFu1i_L_BFu0c)
//============================================================================


struct  BFu1i_L_BFu0i  {
  unsigned int v1:1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_L_BFu0i) C1{ Fi:1 FL Fi:0}



static void Test_BFu1i_L_BFu0i()
{
  {
    init_simple_test("BFu1i_L_BFu0i");
    static STRUCT_IF_C BFu1i_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_L_BFu0i, BFu1i_L_BFu0i)
//============================================================================


struct  BFu1i_L_BFu0ll  {
  unsigned int v1:1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_L_BFu0ll) C1{ Fi:1 FL FL:0}



static void Test_BFu1i_L_BFu0ll()
{
  {
    init_simple_test("BFu1i_L_BFu0ll");
    static STRUCT_IF_C BFu1i_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_L_BFu0ll, BFu1i_L_BFu0ll)
//============================================================================


struct  BFu1i_L_BFu0s  {
  unsigned int v1:1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_L_BFu0s) C1{ Fi:1 FL Fs:0}



static void Test_BFu1i_L_BFu0s()
{
  {
    init_simple_test("BFu1i_L_BFu0s");
    static STRUCT_IF_C BFu1i_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_L_BFu0s, BFu1i_L_BFu0s)
//============================================================================


struct  BFu1i_S_BFu0c  {
  unsigned int v1:1;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_S_BFu0c) C1{ Fi:1 Fs Fc:0}



static void Test_BFu1i_S_BFu0c()
{
  {
    init_simple_test("BFu1i_S_BFu0c");
    static STRUCT_IF_C BFu1i_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_S_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu1i_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_S_BFu0c, BFu1i_S_BFu0c)
//============================================================================


struct  BFu1i_S_BFu0i  {
  unsigned int v1:1;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_S_BFu0i) C1{ Fi:1 Fs Fi:0}



static void Test_BFu1i_S_BFu0i()
{
  {
    init_simple_test("BFu1i_S_BFu0i");
    static STRUCT_IF_C BFu1i_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_S_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu1i_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_S_BFu0i, BFu1i_S_BFu0i)
//============================================================================


struct  BFu1i_S_BFu0ll  {
  unsigned int v1:1;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_S_BFu0ll) C1{ Fi:1 Fs FL:0}



static void Test_BFu1i_S_BFu0ll()
{
  {
    init_simple_test("BFu1i_S_BFu0ll");
    static STRUCT_IF_C BFu1i_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu1i_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_S_BFu0ll, BFu1i_S_BFu0ll)
//============================================================================


struct  BFu1i_S_BFu0s  {
  unsigned int v1:1;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_S_BFu0s) C1{ Fi:1 Fs Fs:0}



static void Test_BFu1i_S_BFu0s()
{
  {
    init_simple_test("BFu1i_S_BFu0s");
    static STRUCT_IF_C BFu1i_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_S_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu1i_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_S_BFu0s, BFu1i_S_BFu0s)
//============================================================================


struct  BFu1i_Uc_BFu0c  {
  unsigned int v1:1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_Uc_BFu0c) C1{ Fi:1 Fc Fc:0}



static void Test_BFu1i_Uc_BFu0c()
{
  {
    init_simple_test("BFu1i_Uc_BFu0c");
    static STRUCT_IF_C BFu1i_Uc_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Uc_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Uc_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1i_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Uc_BFu0c, BFu1i_Uc_BFu0c)
//============================================================================


struct  BFu1i_Uc_BFu0i  {
  unsigned int v1:1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_Uc_BFu0i) C1{ Fi:1 Fc Fi:0}



static void Test_BFu1i_Uc_BFu0i()
{
  {
    init_simple_test("BFu1i_Uc_BFu0i");
    static STRUCT_IF_C BFu1i_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Uc_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Uc_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1i_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Uc_BFu0i, BFu1i_Uc_BFu0i)
//============================================================================


struct  BFu1i_Uc_BFu0ll  {
  unsigned int v1:1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_Uc_BFu0ll) C1{ Fi:1 Fc FL:0}



static void Test_BFu1i_Uc_BFu0ll()
{
  {
    init_simple_test("BFu1i_Uc_BFu0ll");
    static STRUCT_IF_C BFu1i_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Uc_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1i_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Uc_BFu0ll, BFu1i_Uc_BFu0ll)
//============================================================================


struct  BFu1i_Uc_BFu0s  {
  unsigned int v1:1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_Uc_BFu0s) C1{ Fi:1 Fc Fs:0}



static void Test_BFu1i_Uc_BFu0s()
{
  {
    init_simple_test("BFu1i_Uc_BFu0s");
    static STRUCT_IF_C BFu1i_Uc_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Uc_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Uc_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1i_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Uc_BFu0s, BFu1i_Uc_BFu0s)
//============================================================================


struct  BFu1i_Ui_BFu0c  {
  unsigned int v1:1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_Ui_BFu0c) C1{ Fi:1 Fi Fc:0}



static void Test_BFu1i_Ui_BFu0c()
{
  {
    init_simple_test("BFu1i_Ui_BFu0c");
    static STRUCT_IF_C BFu1i_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1i_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ui_BFu0c, BFu1i_Ui_BFu0c)
//============================================================================


struct  BFu1i_Ui_BFu0i  {
  unsigned int v1:1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_Ui_BFu0i) C1{ Fi:1 Fi Fi:0}



static void Test_BFu1i_Ui_BFu0i()
{
  {
    init_simple_test("BFu1i_Ui_BFu0i");
    static STRUCT_IF_C BFu1i_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1i_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ui_BFu0i, BFu1i_Ui_BFu0i)
//============================================================================


struct  BFu1i_Ui_BFu0ll  {
  unsigned int v1:1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_Ui_BFu0ll) C1{ Fi:1 Fi FL:0}



static void Test_BFu1i_Ui_BFu0ll()
{
  {
    init_simple_test("BFu1i_Ui_BFu0ll");
    static STRUCT_IF_C BFu1i_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1i_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ui_BFu0ll, BFu1i_Ui_BFu0ll)
//============================================================================


struct  BFu1i_Ui_BFu0s  {
  unsigned int v1:1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_Ui_BFu0s) C1{ Fi:1 Fi Fs:0}



static void Test_BFu1i_Ui_BFu0s()
{
  {
    init_simple_test("BFu1i_Ui_BFu0s");
    static STRUCT_IF_C BFu1i_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1i_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ui_BFu0s, BFu1i_Ui_BFu0s)
//============================================================================


struct  BFu1i_Ul_BFu0c  {
  unsigned int v1:1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_Ul_BFu0c) C1{ Fi:1 FL Fc:0}



static void Test_BFu1i_Ul_BFu0c()
{
  {
    init_simple_test("BFu1i_Ul_BFu0c");
    static STRUCT_IF_C BFu1i_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ul_BFu0c, BFu1i_Ul_BFu0c)
//============================================================================


struct  BFu1i_Ul_BFu0i  {
  unsigned int v1:1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_Ul_BFu0i) C1{ Fi:1 FL Fi:0}



static void Test_BFu1i_Ul_BFu0i()
{
  {
    init_simple_test("BFu1i_Ul_BFu0i");
    static STRUCT_IF_C BFu1i_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ul_BFu0i, BFu1i_Ul_BFu0i)
//============================================================================


struct  BFu1i_Ul_BFu0ll  {
  unsigned int v1:1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_Ul_BFu0ll) C1{ Fi:1 FL FL:0}



static void Test_BFu1i_Ul_BFu0ll()
{
  {
    init_simple_test("BFu1i_Ul_BFu0ll");
    static STRUCT_IF_C BFu1i_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ul_BFu0ll, BFu1i_Ul_BFu0ll)
//============================================================================


struct  BFu1i_Ul_BFu0s  {
  unsigned int v1:1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_Ul_BFu0s) C1{ Fi:1 FL Fs:0}



static void Test_BFu1i_Ul_BFu0s()
{
  {
    init_simple_test("BFu1i_Ul_BFu0s");
    static STRUCT_IF_C BFu1i_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Ul_BFu0s, BFu1i_Ul_BFu0s)
//============================================================================


struct  BFu1i_Us_BFu0c  {
  unsigned int v1:1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_Us_BFu0c) C1{ Fi:1 Fs Fc:0}



static void Test_BFu1i_Us_BFu0c()
{
  {
    init_simple_test("BFu1i_Us_BFu0c");
    static STRUCT_IF_C BFu1i_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Us_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu1i_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Us_BFu0c, BFu1i_Us_BFu0c)
//============================================================================


struct  BFu1i_Us_BFu0i  {
  unsigned int v1:1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_Us_BFu0i) C1{ Fi:1 Fs Fi:0}



static void Test_BFu1i_Us_BFu0i()
{
  {
    init_simple_test("BFu1i_Us_BFu0i");
    static STRUCT_IF_C BFu1i_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Us_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu1i_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Us_BFu0i, BFu1i_Us_BFu0i)
//============================================================================


struct  BFu1i_Us_BFu0ll  {
  unsigned int v1:1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_Us_BFu0ll) C1{ Fi:1 Fs FL:0}



static void Test_BFu1i_Us_BFu0ll()
{
  {
    init_simple_test("BFu1i_Us_BFu0ll");
    static STRUCT_IF_C BFu1i_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu1i_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu1i_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Us_BFu0ll, BFu1i_Us_BFu0ll)
//============================================================================


struct  BFu1i_Us_BFu0s  {
  unsigned int v1:1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_Us_BFu0s) C1{ Fi:1 Fs Fs:0}



static void Test_BFu1i_Us_BFu0s()
{
  {
    init_simple_test("BFu1i_Us_BFu0s");
    static STRUCT_IF_C BFu1i_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Us_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu1i_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Us_BFu0s, BFu1i_Us_BFu0s)
//============================================================================


struct  BFu1i_Vp_BFu0c  {
  unsigned int v1:1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu1i_Vp_BFu0c) C1{ Fi:1 Fp Fc:0}



static void Test_BFu1i_Vp_BFu0c()
{
  {
    init_simple_test("BFu1i_Vp_BFu0c");
    static STRUCT_IF_C BFu1i_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Vp_BFu0c, BFu1i_Vp_BFu0c)
//============================================================================


struct  BFu1i_Vp_BFu0i  {
  unsigned int v1:1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu1i_Vp_BFu0i) C1{ Fi:1 Fp Fi:0}



static void Test_BFu1i_Vp_BFu0i()
{
  {
    init_simple_test("BFu1i_Vp_BFu0i");
    static STRUCT_IF_C BFu1i_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Vp_BFu0i, BFu1i_Vp_BFu0i)
//============================================================================


struct  BFu1i_Vp_BFu0ll  {
  unsigned int v1:1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu1i_Vp_BFu0ll) C1{ Fi:1 Fp FL:0}



static void Test_BFu1i_Vp_BFu0ll()
{
  {
    init_simple_test("BFu1i_Vp_BFu0ll");
    static STRUCT_IF_C BFu1i_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Vp_BFu0ll, BFu1i_Vp_BFu0ll)
//============================================================================


struct  BFu1i_Vp_BFu0s  {
  unsigned int v1:1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu1i_Vp_BFu0s) C1{ Fi:1 Fp Fs:0}



static void Test_BFu1i_Vp_BFu0s()
{
  {
    init_simple_test("BFu1i_Vp_BFu0s");
    static STRUCT_IF_C BFu1i_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1i_Vp_BFu0s, BFu1i_Vp_BFu0s)
//============================================================================


struct  BFu1ll_BFu0c  {
  __tsu64 v1:1;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu0c) C1{ FL:1 Fc:0}



static void Test_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c, BFu1ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu0c_BFu0c  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu0c_BFu0c) C1{ FL:1 Fc:0 Fc:0}



static void Test_BFu1ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu0c, BFu1ll_BFu0c_BFu0c)
//============================================================================


struct  BFu1ll_BFu0c_BFu0i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu0c_BFu0i) C1{ FL:1 Fc:0 Fi:0}



static void Test_BFu1ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu0i, BFu1ll_BFu0c_BFu0i)
//============================================================================


struct  BFu1ll_BFu0c_BFu0ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu0c_BFu0ll) C1{ FL:1 Fc:0 FL:0}



static void Test_BFu1ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu0ll, BFu1ll_BFu0c_BFu0ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu0s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu0c_BFu0s) C1{ FL:1 Fc:0 Fs:0}



static void Test_BFu1ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu0s, BFu1ll_BFu0c_BFu0s)
//============================================================================


struct  BFu1ll_BFu0c_BFu15i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1ll_BFu0c_BFu15i) C1{ FL:1 Fc:0 Fi:15}



static void Test_BFu1ll_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu15i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu15i, BFu1ll_BFu0c_BFu15i)
//============================================================================


struct  BFu1ll_BFu0c_BFu15ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1ll_BFu0c_BFu15ll) C1{ FL:1 Fc:0 FL:15}



static void Test_BFu1ll_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu15ll, BFu1ll_BFu0c_BFu15ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu15s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1ll_BFu0c_BFu15s) C1{ FL:1 Fc:0 Fs:15}



static void Test_BFu1ll_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu15s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu15s, BFu1ll_BFu0c_BFu15s)
//============================================================================


struct  BFu1ll_BFu0c_BFu16i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1ll_BFu0c_BFu16i) C1{ FL:1 Fc:0 Fi:16}



static void Test_BFu1ll_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu16i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu16i, BFu1ll_BFu0c_BFu16i)
//============================================================================


struct  BFu1ll_BFu0c_BFu16ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1ll_BFu0c_BFu16ll) C1{ FL:1 Fc:0 FL:16}



static void Test_BFu1ll_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu16ll, BFu1ll_BFu0c_BFu16ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu16s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1ll_BFu0c_BFu16s) C1{ FL:1 Fc:0 Fs:16}



static void Test_BFu1ll_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu16s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu16s, BFu1ll_BFu0c_BFu16s)
//============================================================================


struct  BFu1ll_BFu0c_BFu17i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1ll_BFu0c_BFu17i) C1{ FL:1 Fc:0 Fi:17}



static void Test_BFu1ll_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu17i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu17i, BFu1ll_BFu0c_BFu17i)
//============================================================================


struct  BFu1ll_BFu0c_BFu17ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1ll_BFu0c_BFu17ll) C1{ FL:1 Fc:0 FL:17}



static void Test_BFu1ll_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu17ll, BFu1ll_BFu0c_BFu17ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu1c  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1ll_BFu0c_BFu1c) C1{ FL:1 Fc:0 Fc:1}



static void Test_BFu1ll_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu1c");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1ll_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu1c, BFu1ll_BFu0c_BFu1c)
//============================================================================


struct  BFu1ll_BFu0c_BFu1i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1ll_BFu0c_BFu1i) C1{ FL:1 Fc:0 Fi:1}



static void Test_BFu1ll_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu1i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1ll_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu1i, BFu1ll_BFu0c_BFu1i)
//============================================================================


struct  BFu1ll_BFu0c_BFu1ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1ll_BFu0c_BFu1ll) C1{ FL:1 Fc:0 FL:1}



static void Test_BFu1ll_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1ll_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu1ll, BFu1ll_BFu0c_BFu1ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu1s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1ll_BFu0c_BFu1s) C1{ FL:1 Fc:0 Fs:1}



static void Test_BFu1ll_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu1s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1ll_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu1s, BFu1ll_BFu0c_BFu1s)
//============================================================================


struct  BFu1ll_BFu0c_BFu31i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1ll_BFu0c_BFu31i) C1{ FL:1 Fc:0 Fi:31}



static void Test_BFu1ll_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu31i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu31i, BFu1ll_BFu0c_BFu31i)
//============================================================================


struct  BFu1ll_BFu0c_BFu31ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1ll_BFu0c_BFu31ll) C1{ FL:1 Fc:0 FL:31}



static void Test_BFu1ll_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu1ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu31ll, BFu1ll_BFu0c_BFu31ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu32i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1ll_BFu0c_BFu32i) C1{ FL:1 Fc:0 Fi:32}



static void Test_BFu1ll_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu32i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu32i, BFu1ll_BFu0c_BFu32i)
//============================================================================


struct  BFu1ll_BFu0c_BFu32ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1ll_BFu0c_BFu32ll) C1{ FL:1 Fc:0 FL:32}



static void Test_BFu1ll_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu1ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu32ll, BFu1ll_BFu0c_BFu32ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu33  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1ll_BFu0c_BFu33) C1{ FL:1 Fc:0 FL:33}



static void Test_BFu1ll_BFu0c_BFu33()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu33");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu1ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu1ll_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu33, BFu1ll_BFu0c_BFu33)
//============================================================================


struct  BFu1ll_BFu0c_BFu7c  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1ll_BFu0c_BFu7c) C1{ FL:1 Fc:0 Fc:7}



static void Test_BFu1ll_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu7c");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu7c, BFu1ll_BFu0c_BFu7c)
//============================================================================


struct  BFu1ll_BFu0c_BFu7i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1ll_BFu0c_BFu7i) C1{ FL:1 Fc:0 Fi:7}



static void Test_BFu1ll_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu7i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu7i, BFu1ll_BFu0c_BFu7i)
//============================================================================


struct  BFu1ll_BFu0c_BFu7ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1ll_BFu0c_BFu7ll) C1{ FL:1 Fc:0 FL:7}



static void Test_BFu1ll_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu7ll, BFu1ll_BFu0c_BFu7ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu7s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1ll_BFu0c_BFu7s) C1{ FL:1 Fc:0 Fs:7}



static void Test_BFu1ll_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu7s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu7s, BFu1ll_BFu0c_BFu7s)
//============================================================================


struct  BFu1ll_BFu0c_BFu8c  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1ll_BFu0c_BFu8c) C1{ FL:1 Fc:0 Fc:8}



static void Test_BFu1ll_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu8c");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu8c, BFu1ll_BFu0c_BFu8c)
//============================================================================


struct  BFu1ll_BFu0c_BFu8i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1ll_BFu0c_BFu8i) C1{ FL:1 Fc:0 Fi:8}



static void Test_BFu1ll_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu8i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu8i, BFu1ll_BFu0c_BFu8i)
//============================================================================


struct  BFu1ll_BFu0c_BFu8ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1ll_BFu0c_BFu8ll) C1{ FL:1 Fc:0 FL:8}



static void Test_BFu1ll_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu8ll, BFu1ll_BFu0c_BFu8ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu8s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1ll_BFu0c_BFu8s) C1{ FL:1 Fc:0 Fs:8}



static void Test_BFu1ll_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu8s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu8s, BFu1ll_BFu0c_BFu8s)
//============================================================================


struct  BFu1ll_BFu0c_BFu9i  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1ll_BFu0c_BFu9i) C1{ FL:1 Fc:0 Fi:9}



static void Test_BFu1ll_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu9i");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu9i, BFu1ll_BFu0c_BFu9i)
//============================================================================


struct  BFu1ll_BFu0c_BFu9ll  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1ll_BFu0c_BFu9ll) C1{ FL:1 Fc:0 FL:9}



static void Test_BFu1ll_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu9ll, BFu1ll_BFu0c_BFu9ll)
//============================================================================


struct  BFu1ll_BFu0c_BFu9s  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1ll_BFu0c_BFu9s) C1{ FL:1 Fc:0 Fs:9}



static void Test_BFu1ll_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu1ll_BFu0c_BFu9s");
    static STRUCT_IF_C BFu1ll_BFu0c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_BFu9s, BFu1ll_BFu0c_BFu9s)
//============================================================================


struct  BFu1ll_BFu0c_C  {
  __tsu64 v1:1;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu1ll_BFu0c_C) C1{ FL:1 Fc:0 Fc}



static void Test_BFu1ll_BFu0c_C()
{
  {
    init_simple_test("BFu1ll_BFu0c_C");
    static STRUCT_IF_C BFu1ll_BFu0c_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu1ll_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_C, BFu1ll_BFu0c_C)
//============================================================================


struct  BFu1ll_BFu0c_D  {
  __tsu64 v1:1;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu1ll_BFu0c_D) C1{ FL:1 Fc:0 FL}



static void Test_BFu1ll_BFu0c_D()
{
  {
    init_simple_test("BFu1ll_BFu0c_D");
    static STRUCT_IF_C BFu1ll_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_D, BFu1ll_BFu0c_D)
//============================================================================


struct  BFu1ll_BFu0c_F  {
  __tsu64 v1:1;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu1ll_BFu0c_F) C1{ FL:1 Fc:0 Fi}



static void Test_BFu1ll_BFu0c_F()
{
  {
    init_simple_test("BFu1ll_BFu0c_F");
    static STRUCT_IF_C BFu1ll_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_F, BFu1ll_BFu0c_F)
//============================================================================


struct  BFu1ll_BFu0c_I  {
  __tsu64 v1:1;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu1ll_BFu0c_I) C1{ FL:1 Fc:0 Fi}



static void Test_BFu1ll_BFu0c_I()
{
  {
    init_simple_test("BFu1ll_BFu0c_I");
    static STRUCT_IF_C BFu1ll_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_I, BFu1ll_BFu0c_I)
//============================================================================


struct  BFu1ll_BFu0c_Ip  {
  __tsu64 v1:1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu1ll_BFu0c_Ip) C1{ FL:1 Fc:0 Fp}



static void Test_BFu1ll_BFu0c_Ip()
{
  {
    init_simple_test("BFu1ll_BFu0c_Ip");
    static STRUCT_IF_C BFu1ll_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Ip, BFu1ll_BFu0c_Ip)
//============================================================================


struct  BFu1ll_BFu0c_L  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu1ll_BFu0c_L) C1{ FL:1 Fc:0 FL}



static void Test_BFu1ll_BFu0c_L()
{
  {
    init_simple_test("BFu1ll_BFu0c_L");
    static STRUCT_IF_C BFu1ll_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_L, BFu1ll_BFu0c_L)
//============================================================================


struct  BFu1ll_BFu0c_S  {
  __tsu64 v1:1;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu1ll_BFu0c_S) C1{ FL:1 Fc:0 Fs}



static void Test_BFu1ll_BFu0c_S()
{
  {
    init_simple_test("BFu1ll_BFu0c_S");
    static STRUCT_IF_C BFu1ll_BFu0c_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu1ll_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_S, BFu1ll_BFu0c_S)
//============================================================================


struct  BFu1ll_BFu0c_Uc  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu1ll_BFu0c_Uc) C1{ FL:1 Fc:0 Fc}



static void Test_BFu1ll_BFu0c_Uc()
{
  {
    init_simple_test("BFu1ll_BFu0c_Uc");
    static STRUCT_IF_C BFu1ll_BFu0c_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu1ll_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Uc, BFu1ll_BFu0c_Uc)
//============================================================================


struct  BFu1ll_BFu0c_Ui  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu1ll_BFu0c_Ui) C1{ FL:1 Fc:0 Fi}



static void Test_BFu1ll_BFu0c_Ui()
{
  {
    init_simple_test("BFu1ll_BFu0c_Ui");
    static STRUCT_IF_C BFu1ll_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Ui, BFu1ll_BFu0c_Ui)
//============================================================================


struct  BFu1ll_BFu0c_Ul  {
  __tsu64 v1:1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu1ll_BFu0c_Ul) C1{ FL:1 Fc:0 FL}



static void Test_BFu1ll_BFu0c_Ul()
{
  {
    init_simple_test("BFu1ll_BFu0c_Ul");
    static STRUCT_IF_C BFu1ll_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Ul, BFu1ll_BFu0c_Ul)
//============================================================================


struct  BFu1ll_BFu0c_Us  {
  __tsu64 v1:1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu1ll_BFu0c_Us) C1{ FL:1 Fc:0 Fs}



static void Test_BFu1ll_BFu0c_Us()
{
  {
    init_simple_test("BFu1ll_BFu0c_Us");
    static STRUCT_IF_C BFu1ll_BFu0c_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu1ll_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Us, BFu1ll_BFu0c_Us)
//============================================================================


struct  BFu1ll_BFu0c_Vp  {
  __tsu64 v1:1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu1ll_BFu0c_Vp) C1{ FL:1 Fc:0 Fp}



static void Test_BFu1ll_BFu0c_Vp()
{
  {
    init_simple_test("BFu1ll_BFu0c_Vp");
    static STRUCT_IF_C BFu1ll_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0c_Vp, BFu1ll_BFu0c_Vp)
//============================================================================


struct  BFu1ll_BFu0i  {
  __tsu64 v1:1;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu0i) C1{ FL:1 Fi:0}



static void Test_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i, BFu1ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu0i_BFu0c  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu0i_BFu0c) C1{ FL:1 Fi:0 Fc:0}



static void Test_BFu1ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu0c, BFu1ll_BFu0i_BFu0c)
//============================================================================


struct  BFu1ll_BFu0i_BFu0i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu0i_BFu0i) C1{ FL:1 Fi:0 Fi:0}



static void Test_BFu1ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu0i, BFu1ll_BFu0i_BFu0i)
//============================================================================


struct  BFu1ll_BFu0i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu0i_BFu0ll) C1{ FL:1 Fi:0 FL:0}



static void Test_BFu1ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu0ll, BFu1ll_BFu0i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu0s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu0i_BFu0s) C1{ FL:1 Fi:0 Fs:0}



static void Test_BFu1ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu0s, BFu1ll_BFu0i_BFu0s)
//============================================================================


struct  BFu1ll_BFu0i_BFu15i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1ll_BFu0i_BFu15i) C1{ FL:1 Fi:0 Fi:15}



static void Test_BFu1ll_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu15i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu15i, BFu1ll_BFu0i_BFu15i)
//============================================================================


struct  BFu1ll_BFu0i_BFu15ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1ll_BFu0i_BFu15ll) C1{ FL:1 Fi:0 FL:15}



static void Test_BFu1ll_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu15ll, BFu1ll_BFu0i_BFu15ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu15s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1ll_BFu0i_BFu15s) C1{ FL:1 Fi:0 Fs:15}



static void Test_BFu1ll_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu15s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu15s, BFu1ll_BFu0i_BFu15s)
//============================================================================


struct  BFu1ll_BFu0i_BFu16i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1ll_BFu0i_BFu16i) C1{ FL:1 Fi:0 Fi:16}



static void Test_BFu1ll_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu16i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu16i, BFu1ll_BFu0i_BFu16i)
//============================================================================


struct  BFu1ll_BFu0i_BFu16ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1ll_BFu0i_BFu16ll) C1{ FL:1 Fi:0 FL:16}



static void Test_BFu1ll_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu16ll, BFu1ll_BFu0i_BFu16ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu16s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1ll_BFu0i_BFu16s) C1{ FL:1 Fi:0 Fs:16}



static void Test_BFu1ll_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu16s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu16s, BFu1ll_BFu0i_BFu16s)
//============================================================================


struct  BFu1ll_BFu0i_BFu17i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1ll_BFu0i_BFu17i) C1{ FL:1 Fi:0 Fi:17}



static void Test_BFu1ll_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu17i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu17i, BFu1ll_BFu0i_BFu17i)
//============================================================================


struct  BFu1ll_BFu0i_BFu17ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1ll_BFu0i_BFu17ll) C1{ FL:1 Fi:0 FL:17}



static void Test_BFu1ll_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu17ll, BFu1ll_BFu0i_BFu17ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu1c  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1ll_BFu0i_BFu1c) C1{ FL:1 Fi:0 Fc:1}



static void Test_BFu1ll_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu1c");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1ll_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu1c, BFu1ll_BFu0i_BFu1c)
//============================================================================


struct  BFu1ll_BFu0i_BFu1i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1ll_BFu0i_BFu1i) C1{ FL:1 Fi:0 Fi:1}



static void Test_BFu1ll_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu1i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1ll_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu1i, BFu1ll_BFu0i_BFu1i)
//============================================================================


struct  BFu1ll_BFu0i_BFu1ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1ll_BFu0i_BFu1ll) C1{ FL:1 Fi:0 FL:1}



static void Test_BFu1ll_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1ll_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu1ll, BFu1ll_BFu0i_BFu1ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu1s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1ll_BFu0i_BFu1s) C1{ FL:1 Fi:0 Fs:1}



static void Test_BFu1ll_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu1s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1ll_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu1s, BFu1ll_BFu0i_BFu1s)
//============================================================================


struct  BFu1ll_BFu0i_BFu31i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1ll_BFu0i_BFu31i) C1{ FL:1 Fi:0 Fi:31}



static void Test_BFu1ll_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu31i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu31i, BFu1ll_BFu0i_BFu31i)
//============================================================================


struct  BFu1ll_BFu0i_BFu31ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1ll_BFu0i_BFu31ll) C1{ FL:1 Fi:0 FL:31}



static void Test_BFu1ll_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu31ll, BFu1ll_BFu0i_BFu31ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu32i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1ll_BFu0i_BFu32i) C1{ FL:1 Fi:0 Fi:32}



static void Test_BFu1ll_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu32i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu32i, BFu1ll_BFu0i_BFu32i)
//============================================================================


struct  BFu1ll_BFu0i_BFu32ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1ll_BFu0i_BFu32ll) C1{ FL:1 Fi:0 FL:32}



static void Test_BFu1ll_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu32ll, BFu1ll_BFu0i_BFu32ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu33  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1ll_BFu0i_BFu33) C1{ FL:1 Fi:0 FL:33}



static void Test_BFu1ll_BFu0i_BFu33()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu33");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1ll_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu33, BFu1ll_BFu0i_BFu33)
//============================================================================


struct  BFu1ll_BFu0i_BFu7c  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1ll_BFu0i_BFu7c) C1{ FL:1 Fi:0 Fc:7}



static void Test_BFu1ll_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu7c");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu7c, BFu1ll_BFu0i_BFu7c)
//============================================================================


struct  BFu1ll_BFu0i_BFu7i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1ll_BFu0i_BFu7i) C1{ FL:1 Fi:0 Fi:7}



static void Test_BFu1ll_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu7i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu7i, BFu1ll_BFu0i_BFu7i)
//============================================================================


struct  BFu1ll_BFu0i_BFu7ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1ll_BFu0i_BFu7ll) C1{ FL:1 Fi:0 FL:7}



static void Test_BFu1ll_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu7ll, BFu1ll_BFu0i_BFu7ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu7s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1ll_BFu0i_BFu7s) C1{ FL:1 Fi:0 Fs:7}



static void Test_BFu1ll_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu7s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu7s, BFu1ll_BFu0i_BFu7s)
//============================================================================


struct  BFu1ll_BFu0i_BFu8c  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1ll_BFu0i_BFu8c) C1{ FL:1 Fi:0 Fc:8}



static void Test_BFu1ll_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu8c");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu8c, BFu1ll_BFu0i_BFu8c)
//============================================================================


struct  BFu1ll_BFu0i_BFu8i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1ll_BFu0i_BFu8i) C1{ FL:1 Fi:0 Fi:8}



static void Test_BFu1ll_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu8i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu8i, BFu1ll_BFu0i_BFu8i)
//============================================================================


struct  BFu1ll_BFu0i_BFu8ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1ll_BFu0i_BFu8ll) C1{ FL:1 Fi:0 FL:8}



static void Test_BFu1ll_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu8ll, BFu1ll_BFu0i_BFu8ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu8s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1ll_BFu0i_BFu8s) C1{ FL:1 Fi:0 Fs:8}



static void Test_BFu1ll_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu8s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu8s, BFu1ll_BFu0i_BFu8s)
//============================================================================


struct  BFu1ll_BFu0i_BFu9i  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1ll_BFu0i_BFu9i) C1{ FL:1 Fi:0 Fi:9}



static void Test_BFu1ll_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu9i");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu9i, BFu1ll_BFu0i_BFu9i)
//============================================================================


struct  BFu1ll_BFu0i_BFu9ll  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1ll_BFu0i_BFu9ll) C1{ FL:1 Fi:0 FL:9}



static void Test_BFu1ll_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu9ll, BFu1ll_BFu0i_BFu9ll)
//============================================================================


struct  BFu1ll_BFu0i_BFu9s  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1ll_BFu0i_BFu9s) C1{ FL:1 Fi:0 Fs:9}



static void Test_BFu1ll_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu1ll_BFu0i_BFu9s");
    static STRUCT_IF_C BFu1ll_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_BFu9s, BFu1ll_BFu0i_BFu9s)
//============================================================================


struct  BFu1ll_BFu0i_C  {
  __tsu64 v1:1;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu1ll_BFu0i_C) C1{ FL:1 Fi:0 Fc}



static void Test_BFu1ll_BFu0i_C()
{
  {
    init_simple_test("BFu1ll_BFu0i_C");
    static STRUCT_IF_C BFu1ll_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_C, BFu1ll_BFu0i_C)
//============================================================================


struct  BFu1ll_BFu0i_D  {
  __tsu64 v1:1;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu1ll_BFu0i_D) C1{ FL:1 Fi:0 FL}



static void Test_BFu1ll_BFu0i_D()
{
  {
    init_simple_test("BFu1ll_BFu0i_D");
    static STRUCT_IF_C BFu1ll_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_D, BFu1ll_BFu0i_D)
//============================================================================


struct  BFu1ll_BFu0i_F  {
  __tsu64 v1:1;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu1ll_BFu0i_F) C1{ FL:1 Fi:0 Fi}



static void Test_BFu1ll_BFu0i_F()
{
  {
    init_simple_test("BFu1ll_BFu0i_F");
    static STRUCT_IF_C BFu1ll_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_F, BFu1ll_BFu0i_F)
//============================================================================


struct  BFu1ll_BFu0i_I  {
  __tsu64 v1:1;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu1ll_BFu0i_I) C1{ FL:1 Fi:0 Fi}



static void Test_BFu1ll_BFu0i_I()
{
  {
    init_simple_test("BFu1ll_BFu0i_I");
    static STRUCT_IF_C BFu1ll_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_I, BFu1ll_BFu0i_I)
//============================================================================


struct  BFu1ll_BFu0i_Ip  {
  __tsu64 v1:1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu1ll_BFu0i_Ip) C1{ FL:1 Fi:0 Fp}



static void Test_BFu1ll_BFu0i_Ip()
{
  {
    init_simple_test("BFu1ll_BFu0i_Ip");
    static STRUCT_IF_C BFu1ll_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Ip, BFu1ll_BFu0i_Ip)
//============================================================================


struct  BFu1ll_BFu0i_L  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu1ll_BFu0i_L) C1{ FL:1 Fi:0 FL}



static void Test_BFu1ll_BFu0i_L()
{
  {
    init_simple_test("BFu1ll_BFu0i_L");
    static STRUCT_IF_C BFu1ll_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_L, BFu1ll_BFu0i_L)
//============================================================================


struct  BFu1ll_BFu0i_S  {
  __tsu64 v1:1;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu1ll_BFu0i_S) C1{ FL:1 Fi:0 Fs}



static void Test_BFu1ll_BFu0i_S()
{
  {
    init_simple_test("BFu1ll_BFu0i_S");
    static STRUCT_IF_C BFu1ll_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_S, BFu1ll_BFu0i_S)
//============================================================================


struct  BFu1ll_BFu0i_Uc  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu1ll_BFu0i_Uc) C1{ FL:1 Fi:0 Fc}



static void Test_BFu1ll_BFu0i_Uc()
{
  {
    init_simple_test("BFu1ll_BFu0i_Uc");
    static STRUCT_IF_C BFu1ll_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Uc, BFu1ll_BFu0i_Uc)
//============================================================================


struct  BFu1ll_BFu0i_Ui  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu1ll_BFu0i_Ui) C1{ FL:1 Fi:0 Fi}



static void Test_BFu1ll_BFu0i_Ui()
{
  {
    init_simple_test("BFu1ll_BFu0i_Ui");
    static STRUCT_IF_C BFu1ll_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Ui, BFu1ll_BFu0i_Ui)
//============================================================================


struct  BFu1ll_BFu0i_Ul  {
  __tsu64 v1:1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu1ll_BFu0i_Ul) C1{ FL:1 Fi:0 FL}



static void Test_BFu1ll_BFu0i_Ul()
{
  {
    init_simple_test("BFu1ll_BFu0i_Ul");
    static STRUCT_IF_C BFu1ll_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Ul, BFu1ll_BFu0i_Ul)
//============================================================================


struct  BFu1ll_BFu0i_Us  {
  __tsu64 v1:1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu1ll_BFu0i_Us) C1{ FL:1 Fi:0 Fs}



static void Test_BFu1ll_BFu0i_Us()
{
  {
    init_simple_test("BFu1ll_BFu0i_Us");
    static STRUCT_IF_C BFu1ll_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Us, BFu1ll_BFu0i_Us)
//============================================================================


struct  BFu1ll_BFu0i_Vp  {
  __tsu64 v1:1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu1ll_BFu0i_Vp) C1{ FL:1 Fi:0 Fp}



static void Test_BFu1ll_BFu0i_Vp()
{
  {
    init_simple_test("BFu1ll_BFu0i_Vp");
    static STRUCT_IF_C BFu1ll_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0i_Vp, BFu1ll_BFu0i_Vp)
//============================================================================


struct  BFu1ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu0ll) C1{ FL:1 FL:0}



static void Test_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll, BFu1ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu0ll_BFu0c) C1{ FL:1 FL:0 Fc:0}



static void Test_BFu1ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu0c, BFu1ll_BFu0ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu0ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu0ll_BFu0i) C1{ FL:1 FL:0 Fi:0}



static void Test_BFu1ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu0i, BFu1ll_BFu0ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu0ll_BFu0ll) C1{ FL:1 FL:0 FL:0}



static void Test_BFu1ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu0ll, BFu1ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu0ll_BFu0s) C1{ FL:1 FL:0 Fs:0}



static void Test_BFu1ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu0s, BFu1ll_BFu0ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu0ll_BFu15i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1ll_BFu0ll_BFu15i) C1{ FL:1 FL:0 Fi:15}



static void Test_BFu1ll_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu15i, BFu1ll_BFu0ll_BFu15i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu15ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1ll_BFu0ll_BFu15ll) C1{ FL:1 FL:0 FL:15}



static void Test_BFu1ll_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu15ll, BFu1ll_BFu0ll_BFu15ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu15s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1ll_BFu0ll_BFu15s) C1{ FL:1 FL:0 Fs:15}



static void Test_BFu1ll_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu1ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu15s, BFu1ll_BFu0ll_BFu15s)
//============================================================================


struct  BFu1ll_BFu0ll_BFu16i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1ll_BFu0ll_BFu16i) C1{ FL:1 FL:0 Fi:16}



static void Test_BFu1ll_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu16i, BFu1ll_BFu0ll_BFu16i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu16ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1ll_BFu0ll_BFu16ll) C1{ FL:1 FL:0 FL:16}



static void Test_BFu1ll_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu16ll, BFu1ll_BFu0ll_BFu16ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu16s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1ll_BFu0ll_BFu16s) C1{ FL:1 FL:0 Fs:16}



static void Test_BFu1ll_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu1ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu16s, BFu1ll_BFu0ll_BFu16s)
//============================================================================


struct  BFu1ll_BFu0ll_BFu17i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1ll_BFu0ll_BFu17i) C1{ FL:1 FL:0 Fi:17}



static void Test_BFu1ll_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu1ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu17i, BFu1ll_BFu0ll_BFu17i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu17ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1ll_BFu0ll_BFu17ll) C1{ FL:1 FL:0 FL:17}



static void Test_BFu1ll_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu1ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu17ll, BFu1ll_BFu0ll_BFu17ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu1c  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1ll_BFu0ll_BFu1c) C1{ FL:1 FL:0 Fc:1}



static void Test_BFu1ll_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1ll_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu1c, BFu1ll_BFu0ll_BFu1c)
//============================================================================


struct  BFu1ll_BFu0ll_BFu1i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1ll_BFu0ll_BFu1i) C1{ FL:1 FL:0 Fi:1}



static void Test_BFu1ll_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1ll_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu1i, BFu1ll_BFu0ll_BFu1i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu1ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1ll_BFu0ll_BFu1ll) C1{ FL:1 FL:0 FL:1}



static void Test_BFu1ll_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1ll_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu1ll, BFu1ll_BFu0ll_BFu1ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu1s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1ll_BFu0ll_BFu1s) C1{ FL:1 FL:0 Fs:1}



static void Test_BFu1ll_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu1ll_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu1s, BFu1ll_BFu0ll_BFu1s)
//============================================================================


struct  BFu1ll_BFu0ll_BFu31i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1ll_BFu0ll_BFu31i) C1{ FL:1 FL:0 Fi:31}



static void Test_BFu1ll_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu1ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu31i, BFu1ll_BFu0ll_BFu31i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu31ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1ll_BFu0ll_BFu31ll) C1{ FL:1 FL:0 FL:31}



static void Test_BFu1ll_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu1ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu31ll, BFu1ll_BFu0ll_BFu31ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu32i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1ll_BFu0ll_BFu32i) C1{ FL:1 FL:0 Fi:32}



static void Test_BFu1ll_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu1ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu32i, BFu1ll_BFu0ll_BFu32i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu32ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1ll_BFu0ll_BFu32ll) C1{ FL:1 FL:0 FL:32}



static void Test_BFu1ll_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu1ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu32ll, BFu1ll_BFu0ll_BFu32ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu33  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1ll_BFu0ll_BFu33) C1{ FL:1 FL:0 FL:33}



static void Test_BFu1ll_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu33");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1ll_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu33, BFu1ll_BFu0ll_BFu33)
//============================================================================


struct  BFu1ll_BFu0ll_BFu7c  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1ll_BFu0ll_BFu7c) C1{ FL:1 FL:0 Fc:7}



static void Test_BFu1ll_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu7c, BFu1ll_BFu0ll_BFu7c)
//============================================================================


struct  BFu1ll_BFu0ll_BFu7i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1ll_BFu0ll_BFu7i) C1{ FL:1 FL:0 Fi:7}



static void Test_BFu1ll_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu7i, BFu1ll_BFu0ll_BFu7i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu7ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1ll_BFu0ll_BFu7ll) C1{ FL:1 FL:0 FL:7}



static void Test_BFu1ll_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu7ll, BFu1ll_BFu0ll_BFu7ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu7s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1ll_BFu0ll_BFu7s) C1{ FL:1 FL:0 Fs:7}



static void Test_BFu1ll_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu1ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu7s, BFu1ll_BFu0ll_BFu7s)
//============================================================================


struct  BFu1ll_BFu0ll_BFu8c  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1ll_BFu0ll_BFu8c) C1{ FL:1 FL:0 Fc:8}



static void Test_BFu1ll_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu8c, BFu1ll_BFu0ll_BFu8c)
//============================================================================


struct  BFu1ll_BFu0ll_BFu8i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1ll_BFu0ll_BFu8i) C1{ FL:1 FL:0 Fi:8}



static void Test_BFu1ll_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu8i, BFu1ll_BFu0ll_BFu8i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu8ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1ll_BFu0ll_BFu8ll) C1{ FL:1 FL:0 FL:8}



static void Test_BFu1ll_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu8ll, BFu1ll_BFu0ll_BFu8ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu8s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1ll_BFu0ll_BFu8s) C1{ FL:1 FL:0 Fs:8}



static void Test_BFu1ll_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu1ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu8s, BFu1ll_BFu0ll_BFu8s)
//============================================================================


struct  BFu1ll_BFu0ll_BFu9i  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1ll_BFu0ll_BFu9i) C1{ FL:1 FL:0 Fi:9}



static void Test_BFu1ll_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu9i, BFu1ll_BFu0ll_BFu9i)
//============================================================================


struct  BFu1ll_BFu0ll_BFu9ll  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1ll_BFu0ll_BFu9ll) C1{ FL:1 FL:0 FL:9}



static void Test_BFu1ll_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu9ll, BFu1ll_BFu0ll_BFu9ll)
//============================================================================


struct  BFu1ll_BFu0ll_BFu9s  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1ll_BFu0ll_BFu9s) C1{ FL:1 FL:0 Fs:9}



static void Test_BFu1ll_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu1ll_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu1ll_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu1ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_BFu9s, BFu1ll_BFu0ll_BFu9s)
//============================================================================


struct  BFu1ll_BFu0ll_C  {
  __tsu64 v1:1;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu1ll_BFu0ll_C) C1{ FL:1 FL:0 Fc}



static void Test_BFu1ll_BFu0ll_C()
{
  {
    init_simple_test("BFu1ll_BFu0ll_C");
    static STRUCT_IF_C BFu1ll_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_C, BFu1ll_BFu0ll_C)
//============================================================================


struct  BFu1ll_BFu0ll_D  {
  __tsu64 v1:1;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu1ll_BFu0ll_D) C1{ FL:1 FL:0 FL}



static void Test_BFu1ll_BFu0ll_D()
{
  {
    init_simple_test("BFu1ll_BFu0ll_D");
    static STRUCT_IF_C BFu1ll_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_D, BFu1ll_BFu0ll_D)
//============================================================================


struct  BFu1ll_BFu0ll_F  {
  __tsu64 v1:1;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu1ll_BFu0ll_F) C1{ FL:1 FL:0 Fi}



static void Test_BFu1ll_BFu0ll_F()
{
  {
    init_simple_test("BFu1ll_BFu0ll_F");
    static STRUCT_IF_C BFu1ll_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_F, BFu1ll_BFu0ll_F)
//============================================================================


struct  BFu1ll_BFu0ll_I  {
  __tsu64 v1:1;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu1ll_BFu0ll_I) C1{ FL:1 FL:0 Fi}



static void Test_BFu1ll_BFu0ll_I()
{
  {
    init_simple_test("BFu1ll_BFu0ll_I");
    static STRUCT_IF_C BFu1ll_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_I, BFu1ll_BFu0ll_I)
//============================================================================


struct  BFu1ll_BFu0ll_Ip  {
  __tsu64 v1:1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu1ll_BFu0ll_Ip) C1{ FL:1 FL:0 Fp}



static void Test_BFu1ll_BFu0ll_Ip()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Ip");
    static STRUCT_IF_C BFu1ll_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Ip, BFu1ll_BFu0ll_Ip)
//============================================================================


struct  BFu1ll_BFu0ll_L  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu1ll_BFu0ll_L) C1{ FL:1 FL:0 FL}



static void Test_BFu1ll_BFu0ll_L()
{
  {
    init_simple_test("BFu1ll_BFu0ll_L");
    static STRUCT_IF_C BFu1ll_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_L, BFu1ll_BFu0ll_L)
//============================================================================


struct  BFu1ll_BFu0ll_S  {
  __tsu64 v1:1;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu1ll_BFu0ll_S) C1{ FL:1 FL:0 Fs}



static void Test_BFu1ll_BFu0ll_S()
{
  {
    init_simple_test("BFu1ll_BFu0ll_S");
    static STRUCT_IF_C BFu1ll_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_S, BFu1ll_BFu0ll_S)
//============================================================================


struct  BFu1ll_BFu0ll_Uc  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu1ll_BFu0ll_Uc) C1{ FL:1 FL:0 Fc}



static void Test_BFu1ll_BFu0ll_Uc()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Uc");
    static STRUCT_IF_C BFu1ll_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Uc, BFu1ll_BFu0ll_Uc)
//============================================================================


struct  BFu1ll_BFu0ll_Ui  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu1ll_BFu0ll_Ui) C1{ FL:1 FL:0 Fi}



static void Test_BFu1ll_BFu0ll_Ui()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Ui");
    static STRUCT_IF_C BFu1ll_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Ui, BFu1ll_BFu0ll_Ui)
//============================================================================


struct  BFu1ll_BFu0ll_Ul  {
  __tsu64 v1:1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu1ll_BFu0ll_Ul) C1{ FL:1 FL:0 FL}



static void Test_BFu1ll_BFu0ll_Ul()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Ul");
    static STRUCT_IF_C BFu1ll_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Ul, BFu1ll_BFu0ll_Ul)
//============================================================================


struct  BFu1ll_BFu0ll_Us  {
  __tsu64 v1:1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu1ll_BFu0ll_Us) C1{ FL:1 FL:0 Fs}



static void Test_BFu1ll_BFu0ll_Us()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Us");
    static STRUCT_IF_C BFu1ll_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Us, BFu1ll_BFu0ll_Us)
//============================================================================


struct  BFu1ll_BFu0ll_Vp  {
  __tsu64 v1:1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu1ll_BFu0ll_Vp) C1{ FL:1 FL:0 Fp}



static void Test_BFu1ll_BFu0ll_Vp()
{
  {
    init_simple_test("BFu1ll_BFu0ll_Vp");
    static STRUCT_IF_C BFu1ll_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0ll_Vp, BFu1ll_BFu0ll_Vp)
//============================================================================


struct  BFu1ll_BFu0s  {
  __tsu64 v1:1;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu0s) C1{ FL:1 Fs:0}



static void Test_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s, BFu1ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu0s_BFu0c  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu0s_BFu0c) C1{ FL:1 Fs:0 Fc:0}



static void Test_BFu1ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu0c, BFu1ll_BFu0s_BFu0c)
//============================================================================


struct  BFu1ll_BFu0s_BFu0i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu0s_BFu0i) C1{ FL:1 Fs:0 Fi:0}



static void Test_BFu1ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu0i, BFu1ll_BFu0s_BFu0i)
//============================================================================


struct  BFu1ll_BFu0s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu0s_BFu0ll) C1{ FL:1 Fs:0 FL:0}



static void Test_BFu1ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu0ll, BFu1ll_BFu0s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu0s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu0s_BFu0s) C1{ FL:1 Fs:0 Fs:0}



static void Test_BFu1ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu0s, BFu1ll_BFu0s_BFu0s)
//============================================================================


struct  BFu1ll_BFu0s_BFu15i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1ll_BFu0s_BFu15i) C1{ FL:1 Fs:0 Fi:15}



static void Test_BFu1ll_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu15i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu15i, BFu1ll_BFu0s_BFu15i)
//============================================================================


struct  BFu1ll_BFu0s_BFu15ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1ll_BFu0s_BFu15ll) C1{ FL:1 Fs:0 FL:15}



static void Test_BFu1ll_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu15ll, BFu1ll_BFu0s_BFu15ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu15s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1ll_BFu0s_BFu15s) C1{ FL:1 Fs:0 Fs:15}



static void Test_BFu1ll_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu15s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu15s, BFu1ll_BFu0s_BFu15s)
//============================================================================


struct  BFu1ll_BFu0s_BFu16i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1ll_BFu0s_BFu16i) C1{ FL:1 Fs:0 Fi:16}



static void Test_BFu1ll_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu16i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu16i, BFu1ll_BFu0s_BFu16i)
//============================================================================


struct  BFu1ll_BFu0s_BFu16ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1ll_BFu0s_BFu16ll) C1{ FL:1 Fs:0 FL:16}



static void Test_BFu1ll_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu16ll, BFu1ll_BFu0s_BFu16ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu16s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1ll_BFu0s_BFu16s) C1{ FL:1 Fs:0 Fs:16}



static void Test_BFu1ll_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu16s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu16s, BFu1ll_BFu0s_BFu16s)
//============================================================================


struct  BFu1ll_BFu0s_BFu17i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1ll_BFu0s_BFu17i) C1{ FL:1 Fs:0 Fi:17}



static void Test_BFu1ll_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu17i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu17i, BFu1ll_BFu0s_BFu17i)
//============================================================================


struct  BFu1ll_BFu0s_BFu17ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1ll_BFu0s_BFu17ll) C1{ FL:1 Fs:0 FL:17}



static void Test_BFu1ll_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu1ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu1ll_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu17ll, BFu1ll_BFu0s_BFu17ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu1c  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1ll_BFu0s_BFu1c) C1{ FL:1 Fs:0 Fc:1}



static void Test_BFu1ll_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu1c");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1ll_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu1c, BFu1ll_BFu0s_BFu1c)
//============================================================================


struct  BFu1ll_BFu0s_BFu1i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1ll_BFu0s_BFu1i) C1{ FL:1 Fs:0 Fi:1}



static void Test_BFu1ll_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu1i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1ll_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu1i, BFu1ll_BFu0s_BFu1i)
//============================================================================


struct  BFu1ll_BFu0s_BFu1ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1ll_BFu0s_BFu1ll) C1{ FL:1 Fs:0 FL:1}



static void Test_BFu1ll_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1ll_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu1ll, BFu1ll_BFu0s_BFu1ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu1s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1ll_BFu0s_BFu1s) C1{ FL:1 Fs:0 Fs:1}



static void Test_BFu1ll_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu1s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu1ll_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu1s, BFu1ll_BFu0s_BFu1s)
//============================================================================


struct  BFu1ll_BFu0s_BFu31i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1ll_BFu0s_BFu31i) C1{ FL:1 Fs:0 Fi:31}



static void Test_BFu1ll_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu31i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu31i, BFu1ll_BFu0s_BFu31i)
//============================================================================


struct  BFu1ll_BFu0s_BFu31ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1ll_BFu0s_BFu31ll) C1{ FL:1 Fs:0 FL:31}



static void Test_BFu1ll_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu1ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu1ll_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu31ll, BFu1ll_BFu0s_BFu31ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu32i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1ll_BFu0s_BFu32i) C1{ FL:1 Fs:0 Fi:32}



static void Test_BFu1ll_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu32i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu32i, BFu1ll_BFu0s_BFu32i)
//============================================================================


struct  BFu1ll_BFu0s_BFu32ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1ll_BFu0s_BFu32ll) C1{ FL:1 Fs:0 FL:32}



static void Test_BFu1ll_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu1ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu32ll, BFu1ll_BFu0s_BFu32ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu33  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1ll_BFu0s_BFu33) C1{ FL:1 Fs:0 FL:33}



static void Test_BFu1ll_BFu0s_BFu33()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu33");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu1ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu1ll_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu33, BFu1ll_BFu0s_BFu33)
//============================================================================


struct  BFu1ll_BFu0s_BFu7c  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1ll_BFu0s_BFu7c) C1{ FL:1 Fs:0 Fc:7}



static void Test_BFu1ll_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu7c");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu7c, BFu1ll_BFu0s_BFu7c)
//============================================================================


struct  BFu1ll_BFu0s_BFu7i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1ll_BFu0s_BFu7i) C1{ FL:1 Fs:0 Fi:7}



static void Test_BFu1ll_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu7i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu7i, BFu1ll_BFu0s_BFu7i)
//============================================================================


struct  BFu1ll_BFu0s_BFu7ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1ll_BFu0s_BFu7ll) C1{ FL:1 Fs:0 FL:7}



static void Test_BFu1ll_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu7ll, BFu1ll_BFu0s_BFu7ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu7s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1ll_BFu0s_BFu7s) C1{ FL:1 Fs:0 Fs:7}



static void Test_BFu1ll_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu7s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu1ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu7s, BFu1ll_BFu0s_BFu7s)
//============================================================================


struct  BFu1ll_BFu0s_BFu8c  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1ll_BFu0s_BFu8c) C1{ FL:1 Fs:0 Fc:8}



static void Test_BFu1ll_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu8c");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu8c, BFu1ll_BFu0s_BFu8c)
//============================================================================


struct  BFu1ll_BFu0s_BFu8i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1ll_BFu0s_BFu8i) C1{ FL:1 Fs:0 Fi:8}



static void Test_BFu1ll_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu8i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu8i, BFu1ll_BFu0s_BFu8i)
//============================================================================


struct  BFu1ll_BFu0s_BFu8ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1ll_BFu0s_BFu8ll) C1{ FL:1 Fs:0 FL:8}



static void Test_BFu1ll_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu8ll, BFu1ll_BFu0s_BFu8ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu8s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1ll_BFu0s_BFu8s) C1{ FL:1 Fs:0 Fs:8}



static void Test_BFu1ll_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu8s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu1ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu8s, BFu1ll_BFu0s_BFu8s)
//============================================================================


struct  BFu1ll_BFu0s_BFu9i  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1ll_BFu0s_BFu9i) C1{ FL:1 Fs:0 Fi:9}



static void Test_BFu1ll_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu9i");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu9i, BFu1ll_BFu0s_BFu9i)
//============================================================================


struct  BFu1ll_BFu0s_BFu9ll  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1ll_BFu0s_BFu9ll) C1{ FL:1 Fs:0 FL:9}



static void Test_BFu1ll_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu9ll, BFu1ll_BFu0s_BFu9ll)
//============================================================================


struct  BFu1ll_BFu0s_BFu9s  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1ll_BFu0s_BFu9s) C1{ FL:1 Fs:0 Fs:9}



static void Test_BFu1ll_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu1ll_BFu0s_BFu9s");
    static STRUCT_IF_C BFu1ll_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_BFu9s, BFu1ll_BFu0s_BFu9s)
//============================================================================


struct  BFu1ll_BFu0s_C  {
  __tsu64 v1:1;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu1ll_BFu0s_C) C1{ FL:1 Fs:0 Fc}



static void Test_BFu1ll_BFu0s_C()
{
  {
    init_simple_test("BFu1ll_BFu0s_C");
    static STRUCT_IF_C BFu1ll_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu1ll_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_C, BFu1ll_BFu0s_C)
//============================================================================


struct  BFu1ll_BFu0s_D  {
  __tsu64 v1:1;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu1ll_BFu0s_D) C1{ FL:1 Fs:0 FL}



static void Test_BFu1ll_BFu0s_D()
{
  {
    init_simple_test("BFu1ll_BFu0s_D");
    static STRUCT_IF_C BFu1ll_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_D, BFu1ll_BFu0s_D)
//============================================================================


struct  BFu1ll_BFu0s_F  {
  __tsu64 v1:1;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu1ll_BFu0s_F) C1{ FL:1 Fs:0 Fi}



static void Test_BFu1ll_BFu0s_F()
{
  {
    init_simple_test("BFu1ll_BFu0s_F");
    static STRUCT_IF_C BFu1ll_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_F, BFu1ll_BFu0s_F)
//============================================================================


struct  BFu1ll_BFu0s_I  {
  __tsu64 v1:1;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu1ll_BFu0s_I) C1{ FL:1 Fs:0 Fi}



static void Test_BFu1ll_BFu0s_I()
{
  {
    init_simple_test("BFu1ll_BFu0s_I");
    static STRUCT_IF_C BFu1ll_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_I, BFu1ll_BFu0s_I)
//============================================================================


struct  BFu1ll_BFu0s_Ip  {
  __tsu64 v1:1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu1ll_BFu0s_Ip) C1{ FL:1 Fs:0 Fp}



static void Test_BFu1ll_BFu0s_Ip()
{
  {
    init_simple_test("BFu1ll_BFu0s_Ip");
    static STRUCT_IF_C BFu1ll_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Ip, BFu1ll_BFu0s_Ip)
//============================================================================


struct  BFu1ll_BFu0s_L  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu1ll_BFu0s_L) C1{ FL:1 Fs:0 FL}



static void Test_BFu1ll_BFu0s_L()
{
  {
    init_simple_test("BFu1ll_BFu0s_L");
    static STRUCT_IF_C BFu1ll_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_L, BFu1ll_BFu0s_L)
//============================================================================


struct  BFu1ll_BFu0s_S  {
  __tsu64 v1:1;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu1ll_BFu0s_S) C1{ FL:1 Fs:0 Fs}



static void Test_BFu1ll_BFu0s_S()
{
  {
    init_simple_test("BFu1ll_BFu0s_S");
    static STRUCT_IF_C BFu1ll_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu1ll_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_S, BFu1ll_BFu0s_S)
//============================================================================


struct  BFu1ll_BFu0s_Uc  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu1ll_BFu0s_Uc) C1{ FL:1 Fs:0 Fc}



static void Test_BFu1ll_BFu0s_Uc()
{
  {
    init_simple_test("BFu1ll_BFu0s_Uc");
    static STRUCT_IF_C BFu1ll_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu1ll_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Uc, BFu1ll_BFu0s_Uc)
//============================================================================


struct  BFu1ll_BFu0s_Ui  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu1ll_BFu0s_Ui) C1{ FL:1 Fs:0 Fi}



static void Test_BFu1ll_BFu0s_Ui()
{
  {
    init_simple_test("BFu1ll_BFu0s_Ui");
    static STRUCT_IF_C BFu1ll_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu1ll_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Ui, BFu1ll_BFu0s_Ui)
//============================================================================


struct  BFu1ll_BFu0s_Ul  {
  __tsu64 v1:1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu1ll_BFu0s_Ul) C1{ FL:1 Fs:0 FL}



static void Test_BFu1ll_BFu0s_Ul()
{
  {
    init_simple_test("BFu1ll_BFu0s_Ul");
    static STRUCT_IF_C BFu1ll_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Ul, BFu1ll_BFu0s_Ul)
//============================================================================


struct  BFu1ll_BFu0s_Us  {
  __tsu64 v1:1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu1ll_BFu0s_Us) C1{ FL:1 Fs:0 Fs}



static void Test_BFu1ll_BFu0s_Us()
{
  {
    init_simple_test("BFu1ll_BFu0s_Us");
    static STRUCT_IF_C BFu1ll_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu1ll_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Us, BFu1ll_BFu0s_Us)
//============================================================================


struct  BFu1ll_BFu0s_Vp  {
  __tsu64 v1:1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu1ll_BFu0s_Vp) C1{ FL:1 Fs:0 Fp}



static void Test_BFu1ll_BFu0s_Vp()
{
  {
    init_simple_test("BFu1ll_BFu0s_Vp");
    static STRUCT_IF_C BFu1ll_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu0s_Vp, BFu1ll_BFu0s_Vp)
//============================================================================


struct  BFu1ll_BFu15i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu15i_BFu0c) C1{ FL:1 Fi:15 Fc:0}



static void Test_BFu1ll_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu15i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu15i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15i_BFu0c, BFu1ll_BFu15i_BFu0c)
//============================================================================


struct  BFu1ll_BFu15i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu15i_BFu0i) C1{ FL:1 Fi:15 Fi:0}



static void Test_BFu1ll_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu15i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15i_BFu0i, BFu1ll_BFu15i_BFu0i)
//============================================================================


struct  BFu1ll_BFu15i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu15i_BFu0ll) C1{ FL:1 Fi:15 FL:0}



static void Test_BFu1ll_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15i_BFu0ll, BFu1ll_BFu15i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu15i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu15i_BFu0s) C1{ FL:1 Fi:15 Fs:0}



static void Test_BFu1ll_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu15i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15i_BFu0s, BFu1ll_BFu15i_BFu0s)
//============================================================================


struct  BFu1ll_BFu15ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu15ll_BFu0c) C1{ FL:1 FL:15 Fc:0}



static void Test_BFu1ll_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15ll_BFu0c, BFu1ll_BFu15ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu15ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu15ll_BFu0i) C1{ FL:1 FL:15 Fi:0}



static void Test_BFu1ll_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15ll_BFu0i, BFu1ll_BFu15ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu15ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu15ll_BFu0ll) C1{ FL:1 FL:15 FL:0}



static void Test_BFu1ll_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15ll_BFu0ll, BFu1ll_BFu15ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu15ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu15ll_BFu0s) C1{ FL:1 FL:15 Fs:0}



static void Test_BFu1ll_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15ll_BFu0s, BFu1ll_BFu15ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu15s_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu15s_BFu0c) C1{ FL:1 Fs:15 Fc:0}



static void Test_BFu1ll_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu15s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu15s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15s_BFu0c, BFu1ll_BFu15s_BFu0c)
//============================================================================


struct  BFu1ll_BFu15s_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu15s_BFu0i) C1{ FL:1 Fs:15 Fi:0}



static void Test_BFu1ll_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu15s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15s_BFu0i, BFu1ll_BFu15s_BFu0i)
//============================================================================


struct  BFu1ll_BFu15s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu15s_BFu0ll) C1{ FL:1 Fs:15 FL:0}



static void Test_BFu1ll_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15s_BFu0ll, BFu1ll_BFu15s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu15s_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu15s_BFu0s) C1{ FL:1 Fs:15 Fs:0}



static void Test_BFu1ll_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu15s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu15s_BFu0s, BFu1ll_BFu15s_BFu0s)
//============================================================================


struct  BFu1ll_BFu16i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu16i_BFu0c) C1{ FL:1 Fi:16 Fc:0}



static void Test_BFu1ll_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu16i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu16i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16i_BFu0c, BFu1ll_BFu16i_BFu0c)
//============================================================================


struct  BFu1ll_BFu16i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu16i_BFu0i) C1{ FL:1 Fi:16 Fi:0}



static void Test_BFu1ll_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu16i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16i_BFu0i, BFu1ll_BFu16i_BFu0i)
//============================================================================


struct  BFu1ll_BFu16i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu16i_BFu0ll) C1{ FL:1 Fi:16 FL:0}



static void Test_BFu1ll_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16i_BFu0ll, BFu1ll_BFu16i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu16i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu16i_BFu0s) C1{ FL:1 Fi:16 Fs:0}



static void Test_BFu1ll_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu16i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16i_BFu0s, BFu1ll_BFu16i_BFu0s)
//============================================================================


struct  BFu1ll_BFu16ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu16ll_BFu0c) C1{ FL:1 FL:16 Fc:0}



static void Test_BFu1ll_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16ll_BFu0c, BFu1ll_BFu16ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu16ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu16ll_BFu0i) C1{ FL:1 FL:16 Fi:0}



static void Test_BFu1ll_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16ll_BFu0i, BFu1ll_BFu16ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu16ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu16ll_BFu0ll) C1{ FL:1 FL:16 FL:0}



static void Test_BFu1ll_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16ll_BFu0ll, BFu1ll_BFu16ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu16ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu16ll_BFu0s) C1{ FL:1 FL:16 Fs:0}



static void Test_BFu1ll_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16ll_BFu0s, BFu1ll_BFu16ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu16s_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu16s_BFu0c) C1{ FL:1 Fs:16 Fc:0}



static void Test_BFu1ll_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu16s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu16s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16s_BFu0c, BFu1ll_BFu16s_BFu0c)
//============================================================================


struct  BFu1ll_BFu16s_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu16s_BFu0i) C1{ FL:1 Fs:16 Fi:0}



static void Test_BFu1ll_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu16s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16s_BFu0i, BFu1ll_BFu16s_BFu0i)
//============================================================================


struct  BFu1ll_BFu16s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu16s_BFu0ll) C1{ FL:1 Fs:16 FL:0}



static void Test_BFu1ll_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16s_BFu0ll, BFu1ll_BFu16s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu16s_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu16s_BFu0s) C1{ FL:1 Fs:16 Fs:0}



static void Test_BFu1ll_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu16s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu16s_BFu0s, BFu1ll_BFu16s_BFu0s)
//============================================================================


struct  BFu1ll_BFu17i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu17i_BFu0c) C1{ FL:1 Fi:17 Fc:0}



static void Test_BFu1ll_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu17i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu17i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17i_BFu0c, BFu1ll_BFu17i_BFu0c)
//============================================================================


struct  BFu1ll_BFu17i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu17i_BFu0i) C1{ FL:1 Fi:17 Fi:0}



static void Test_BFu1ll_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu17i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17i_BFu0i, BFu1ll_BFu17i_BFu0i)
//============================================================================


struct  BFu1ll_BFu17i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu17i_BFu0ll) C1{ FL:1 Fi:17 FL:0}



static void Test_BFu1ll_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17i_BFu0ll, BFu1ll_BFu17i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu17i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu17i_BFu0s) C1{ FL:1 Fi:17 Fs:0}



static void Test_BFu1ll_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu17i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17i_BFu0s, BFu1ll_BFu17i_BFu0s)
//============================================================================


struct  BFu1ll_BFu17ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu17ll_BFu0c) C1{ FL:1 FL:17 Fc:0}



static void Test_BFu1ll_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17ll_BFu0c, BFu1ll_BFu17ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu17ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu17ll_BFu0i) C1{ FL:1 FL:17 Fi:0}



static void Test_BFu1ll_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17ll_BFu0i, BFu1ll_BFu17ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu17ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu17ll_BFu0ll) C1{ FL:1 FL:17 FL:0}



static void Test_BFu1ll_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17ll_BFu0ll, BFu1ll_BFu17ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu17ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu17ll_BFu0s) C1{ FL:1 FL:17 Fs:0}



static void Test_BFu1ll_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu17ll_BFu0s, BFu1ll_BFu17ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu1c_BFu0c  {
  __tsu64 v1:1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu1c_BFu0c) C1{ FL:1 Fc:1 Fc:0}



static void Test_BFu1ll_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu1c_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu1c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1c_BFu0c, BFu1ll_BFu1c_BFu0c)
//============================================================================


struct  BFu1ll_BFu1c_BFu0i  {
  __tsu64 v1:1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu1c_BFu0i) C1{ FL:1 Fc:1 Fi:0}



static void Test_BFu1ll_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu1c_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1c_BFu0i, BFu1ll_BFu1c_BFu0i)
//============================================================================


struct  BFu1ll_BFu1c_BFu0ll  {
  __tsu64 v1:1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu1c_BFu0ll) C1{ FL:1 Fc:1 FL:0}



static void Test_BFu1ll_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1c_BFu0ll, BFu1ll_BFu1c_BFu0ll)
//============================================================================


struct  BFu1ll_BFu1c_BFu0s  {
  __tsu64 v1:1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu1c_BFu0s) C1{ FL:1 Fc:1 Fs:0}



static void Test_BFu1ll_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu1c_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1c_BFu0s, BFu1ll_BFu1c_BFu0s)
//============================================================================


struct  BFu1ll_BFu1i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu1i_BFu0c) C1{ FL:1 Fi:1 Fc:0}



static void Test_BFu1ll_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu1i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu1i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1i_BFu0c, BFu1ll_BFu1i_BFu0c)
//============================================================================


struct  BFu1ll_BFu1i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu1i_BFu0i) C1{ FL:1 Fi:1 Fi:0}



static void Test_BFu1ll_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu1i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1i_BFu0i, BFu1ll_BFu1i_BFu0i)
//============================================================================


struct  BFu1ll_BFu1i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu1i_BFu0ll) C1{ FL:1 Fi:1 FL:0}



static void Test_BFu1ll_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1i_BFu0ll, BFu1ll_BFu1i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu1i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu1i_BFu0s) C1{ FL:1 Fi:1 Fs:0}



static void Test_BFu1ll_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu1i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1i_BFu0s, BFu1ll_BFu1i_BFu0s)
//============================================================================


struct  BFu1ll_BFu1ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu1ll_BFu0c) C1{ FL:1 FL:1 Fc:0}



static void Test_BFu1ll_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1ll_BFu0c, BFu1ll_BFu1ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu1ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu1ll_BFu0i) C1{ FL:1 FL:1 Fi:0}



static void Test_BFu1ll_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1ll_BFu0i, BFu1ll_BFu1ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu1ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu1ll_BFu0ll) C1{ FL:1 FL:1 FL:0}



static void Test_BFu1ll_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1ll_BFu0ll, BFu1ll_BFu1ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu1ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu1ll_BFu0s) C1{ FL:1 FL:1 Fs:0}



static void Test_BFu1ll_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1ll_BFu0s, BFu1ll_BFu1ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu1s_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu1s_BFu0c) C1{ FL:1 Fs:1 Fc:0}



static void Test_BFu1ll_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu1s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu1s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1s_BFu0c, BFu1ll_BFu1s_BFu0c)
//============================================================================


struct  BFu1ll_BFu1s_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu1s_BFu0i) C1{ FL:1 Fs:1 Fi:0}



static void Test_BFu1ll_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu1s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1s_BFu0i, BFu1ll_BFu1s_BFu0i)
//============================================================================


struct  BFu1ll_BFu1s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu1s_BFu0ll) C1{ FL:1 Fs:1 FL:0}



static void Test_BFu1ll_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1s_BFu0ll, BFu1ll_BFu1s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu1s_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu1s_BFu0s) C1{ FL:1 Fs:1 Fs:0}



static void Test_BFu1ll_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu1s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu1s_BFu0s, BFu1ll_BFu1s_BFu0s)
//============================================================================


struct  BFu1ll_BFu31i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu31i_BFu0c) C1{ FL:1 Fi:31 Fc:0}



static void Test_BFu1ll_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu31i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu31i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31i_BFu0c, BFu1ll_BFu31i_BFu0c)
//============================================================================


struct  BFu1ll_BFu31i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu31i_BFu0i) C1{ FL:1 Fi:31 Fi:0}



static void Test_BFu1ll_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu31i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu31i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31i_BFu0i, BFu1ll_BFu31i_BFu0i)
//============================================================================


struct  BFu1ll_BFu31i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu31i_BFu0ll) C1{ FL:1 Fi:31 FL:0}



static void Test_BFu1ll_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31i_BFu0ll, BFu1ll_BFu31i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu31i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu31i_BFu0s) C1{ FL:1 Fi:31 Fs:0}



static void Test_BFu1ll_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu31i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu31i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31i_BFu0s, BFu1ll_BFu31i_BFu0s)
//============================================================================


struct  BFu1ll_BFu31ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu31ll_BFu0c) C1{ FL:1 FL:31 Fc:0}



static void Test_BFu1ll_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu31ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31ll_BFu0c, BFu1ll_BFu31ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu31ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu31ll_BFu0i) C1{ FL:1 FL:31 Fi:0}



static void Test_BFu1ll_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31ll_BFu0i, BFu1ll_BFu31ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu31ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu31ll_BFu0ll) C1{ FL:1 FL:31 FL:0}



static void Test_BFu1ll_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31ll_BFu0ll, BFu1ll_BFu31ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu31ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu31ll_BFu0s) C1{ FL:1 FL:31 Fs:0}



static void Test_BFu1ll_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu31ll_BFu0s, BFu1ll_BFu31ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu32i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu32i_BFu0c) C1{ FL:1 Fi:32 Fc:0}



static void Test_BFu1ll_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu32i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32i_BFu0c, BFu1ll_BFu32i_BFu0c)
//============================================================================


struct  BFu1ll_BFu32i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu32i_BFu0i) C1{ FL:1 Fi:32 Fi:0}



static void Test_BFu1ll_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu32i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32i_BFu0i, BFu1ll_BFu32i_BFu0i)
//============================================================================


struct  BFu1ll_BFu32i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu32i_BFu0ll) C1{ FL:1 Fi:32 FL:0}



static void Test_BFu1ll_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32i_BFu0ll, BFu1ll_BFu32i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu32i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu32i_BFu0s) C1{ FL:1 Fi:32 Fs:0}



static void Test_BFu1ll_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu32i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32i_BFu0s, BFu1ll_BFu32i_BFu0s)
//============================================================================


struct  BFu1ll_BFu32ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu32ll_BFu0c) C1{ FL:1 FL:32 Fc:0}



static void Test_BFu1ll_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1ll_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32ll_BFu0c, BFu1ll_BFu32ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu32ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu32ll_BFu0i) C1{ FL:1 FL:32 Fi:0}



static void Test_BFu1ll_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1ll_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32ll_BFu0i, BFu1ll_BFu32ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu32ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu32ll_BFu0ll) C1{ FL:1 FL:32 FL:0}



static void Test_BFu1ll_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1ll_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32ll_BFu0ll, BFu1ll_BFu32ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu32ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu32ll_BFu0s) C1{ FL:1 FL:32 Fs:0}



static void Test_BFu1ll_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1ll_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu32ll_BFu0s, BFu1ll_BFu32ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu33_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu33_BFu0c) C1{ FL:1 FL:33 Fc:0}



static void Test_BFu1ll_BFu33_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu33_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1ll_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu33_BFu0c, BFu1ll_BFu33_BFu0c)
//============================================================================


struct  BFu1ll_BFu33_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu33_BFu0i) C1{ FL:1 FL:33 Fi:0}



static void Test_BFu1ll_BFu33_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu33_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1ll_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu33_BFu0i, BFu1ll_BFu33_BFu0i)
//============================================================================


struct  BFu1ll_BFu33_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu33_BFu0ll) C1{ FL:1 FL:33 FL:0}



static void Test_BFu1ll_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu33_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1ll_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu33_BFu0ll, BFu1ll_BFu33_BFu0ll)
//============================================================================


struct  BFu1ll_BFu33_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu33_BFu0s) C1{ FL:1 FL:33 Fs:0}



static void Test_BFu1ll_BFu33_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu33_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1ll_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu33_BFu0s, BFu1ll_BFu33_BFu0s)
//============================================================================


struct  BFu1ll_BFu7c_BFu0c  {
  __tsu64 v1:1;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu7c_BFu0c) C1{ FL:1 Fc:7 Fc:0}



static void Test_BFu1ll_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu7c_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu7c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7c_BFu0c, BFu1ll_BFu7c_BFu0c)
//============================================================================


struct  BFu1ll_BFu7c_BFu0i  {
  __tsu64 v1:1;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu7c_BFu0i) C1{ FL:1 Fc:7 Fi:0}



static void Test_BFu1ll_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu7c_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7c_BFu0i, BFu1ll_BFu7c_BFu0i)
//============================================================================


struct  BFu1ll_BFu7c_BFu0ll  {
  __tsu64 v1:1;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu7c_BFu0ll) C1{ FL:1 Fc:7 FL:0}



static void Test_BFu1ll_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7c_BFu0ll, BFu1ll_BFu7c_BFu0ll)
//============================================================================


struct  BFu1ll_BFu7c_BFu0s  {
  __tsu64 v1:1;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu7c_BFu0s) C1{ FL:1 Fc:7 Fs:0}



static void Test_BFu1ll_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu7c_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7c_BFu0s, BFu1ll_BFu7c_BFu0s)
//============================================================================


struct  BFu1ll_BFu7i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu7i_BFu0c) C1{ FL:1 Fi:7 Fc:0}



static void Test_BFu1ll_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu7i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu7i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7i_BFu0c, BFu1ll_BFu7i_BFu0c)
//============================================================================


struct  BFu1ll_BFu7i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu7i_BFu0i) C1{ FL:1 Fi:7 Fi:0}



static void Test_BFu1ll_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu7i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7i_BFu0i, BFu1ll_BFu7i_BFu0i)
//============================================================================


struct  BFu1ll_BFu7i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu7i_BFu0ll) C1{ FL:1 Fi:7 FL:0}



static void Test_BFu1ll_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7i_BFu0ll, BFu1ll_BFu7i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu7i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu7i_BFu0s) C1{ FL:1 Fi:7 Fs:0}



static void Test_BFu1ll_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu7i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7i_BFu0s, BFu1ll_BFu7i_BFu0s)
//============================================================================


struct  BFu1ll_BFu7ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu7ll_BFu0c) C1{ FL:1 FL:7 Fc:0}



static void Test_BFu1ll_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7ll_BFu0c, BFu1ll_BFu7ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu7ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu7ll_BFu0i) C1{ FL:1 FL:7 Fi:0}



static void Test_BFu1ll_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7ll_BFu0i, BFu1ll_BFu7ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu7ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu7ll_BFu0ll) C1{ FL:1 FL:7 FL:0}



static void Test_BFu1ll_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7ll_BFu0ll, BFu1ll_BFu7ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu7ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu7ll_BFu0s) C1{ FL:1 FL:7 Fs:0}



static void Test_BFu1ll_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7ll_BFu0s, BFu1ll_BFu7ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu7s_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu7s_BFu0c) C1{ FL:1 Fs:7 Fc:0}



static void Test_BFu1ll_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu7s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu7s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7s_BFu0c, BFu1ll_BFu7s_BFu0c)
//============================================================================


struct  BFu1ll_BFu7s_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu7s_BFu0i) C1{ FL:1 Fs:7 Fi:0}



static void Test_BFu1ll_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu7s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7s_BFu0i, BFu1ll_BFu7s_BFu0i)
//============================================================================


struct  BFu1ll_BFu7s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu7s_BFu0ll) C1{ FL:1 Fs:7 FL:0}



static void Test_BFu1ll_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7s_BFu0ll, BFu1ll_BFu7s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu7s_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu7s_BFu0s) C1{ FL:1 Fs:7 Fs:0}



static void Test_BFu1ll_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu7s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu7s_BFu0s, BFu1ll_BFu7s_BFu0s)
//============================================================================


struct  BFu1ll_BFu8c_BFu0c  {
  __tsu64 v1:1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu8c_BFu0c) C1{ FL:1 Fc:8 Fc:0}



static void Test_BFu1ll_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu8c_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu8c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8c_BFu0c, BFu1ll_BFu8c_BFu0c)
//============================================================================


struct  BFu1ll_BFu8c_BFu0i  {
  __tsu64 v1:1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu8c_BFu0i) C1{ FL:1 Fc:8 Fi:0}



static void Test_BFu1ll_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu8c_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8c_BFu0i, BFu1ll_BFu8c_BFu0i)
//============================================================================


struct  BFu1ll_BFu8c_BFu0ll  {
  __tsu64 v1:1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu8c_BFu0ll) C1{ FL:1 Fc:8 FL:0}



static void Test_BFu1ll_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8c_BFu0ll, BFu1ll_BFu8c_BFu0ll)
//============================================================================


struct  BFu1ll_BFu8c_BFu0s  {
  __tsu64 v1:1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu8c_BFu0s) C1{ FL:1 Fc:8 Fs:0}



static void Test_BFu1ll_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu8c_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8c_BFu0s, BFu1ll_BFu8c_BFu0s)
//============================================================================


struct  BFu1ll_BFu8i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu8i_BFu0c) C1{ FL:1 Fi:8 Fc:0}



static void Test_BFu1ll_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu8i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu8i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8i_BFu0c, BFu1ll_BFu8i_BFu0c)
//============================================================================


struct  BFu1ll_BFu8i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu8i_BFu0i) C1{ FL:1 Fi:8 Fi:0}



static void Test_BFu1ll_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu8i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8i_BFu0i, BFu1ll_BFu8i_BFu0i)
//============================================================================


struct  BFu1ll_BFu8i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu8i_BFu0ll) C1{ FL:1 Fi:8 FL:0}



static void Test_BFu1ll_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8i_BFu0ll, BFu1ll_BFu8i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu8i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu8i_BFu0s) C1{ FL:1 Fi:8 Fs:0}



static void Test_BFu1ll_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu8i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8i_BFu0s, BFu1ll_BFu8i_BFu0s)
//============================================================================


struct  BFu1ll_BFu8ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu8ll_BFu0c) C1{ FL:1 FL:8 Fc:0}



static void Test_BFu1ll_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8ll_BFu0c, BFu1ll_BFu8ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu8ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu8ll_BFu0i) C1{ FL:1 FL:8 Fi:0}



static void Test_BFu1ll_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8ll_BFu0i, BFu1ll_BFu8ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu8ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu8ll_BFu0ll) C1{ FL:1 FL:8 FL:0}



static void Test_BFu1ll_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8ll_BFu0ll, BFu1ll_BFu8ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu8ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu8ll_BFu0s) C1{ FL:1 FL:8 Fs:0}



static void Test_BFu1ll_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8ll_BFu0s, BFu1ll_BFu8ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu8s_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu8s_BFu0c) C1{ FL:1 Fs:8 Fc:0}



static void Test_BFu1ll_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu8s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu8s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8s_BFu0c, BFu1ll_BFu8s_BFu0c)
//============================================================================


struct  BFu1ll_BFu8s_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu8s_BFu0i) C1{ FL:1 Fs:8 Fi:0}



static void Test_BFu1ll_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu8s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8s_BFu0i, BFu1ll_BFu8s_BFu0i)
//============================================================================


struct  BFu1ll_BFu8s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu8s_BFu0ll) C1{ FL:1 Fs:8 FL:0}



static void Test_BFu1ll_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8s_BFu0ll, BFu1ll_BFu8s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu8s_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu8s_BFu0s) C1{ FL:1 Fs:8 Fs:0}



static void Test_BFu1ll_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu8s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu8s_BFu0s, BFu1ll_BFu8s_BFu0s)
//============================================================================


struct  BFu1ll_BFu9i_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu9i_BFu0c) C1{ FL:1 Fi:9 Fc:0}



static void Test_BFu1ll_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu9i_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu9i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9i_BFu0c, BFu1ll_BFu9i_BFu0c)
//============================================================================


struct  BFu1ll_BFu9i_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu9i_BFu0i) C1{ FL:1 Fi:9 Fi:0}



static void Test_BFu1ll_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu9i_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9i_BFu0i, BFu1ll_BFu9i_BFu0i)
//============================================================================


struct  BFu1ll_BFu9i_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu9i_BFu0ll) C1{ FL:1 Fi:9 FL:0}



static void Test_BFu1ll_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9i_BFu0ll, BFu1ll_BFu9i_BFu0ll)
//============================================================================


struct  BFu1ll_BFu9i_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu9i_BFu0s) C1{ FL:1 Fi:9 Fs:0}



static void Test_BFu1ll_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu9i_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9i_BFu0s, BFu1ll_BFu9i_BFu0s)
//============================================================================


struct  BFu1ll_BFu9ll_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu9ll_BFu0c) C1{ FL:1 FL:9 Fc:0}



static void Test_BFu1ll_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9ll_BFu0c, BFu1ll_BFu9ll_BFu0c)
//============================================================================


struct  BFu1ll_BFu9ll_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu9ll_BFu0i) C1{ FL:1 FL:9 Fi:0}



static void Test_BFu1ll_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9ll_BFu0i, BFu1ll_BFu9ll_BFu0i)
//============================================================================


struct  BFu1ll_BFu9ll_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu9ll_BFu0ll) C1{ FL:1 FL:9 FL:0}



static void Test_BFu1ll_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9ll_BFu0ll, BFu1ll_BFu9ll_BFu0ll)
//============================================================================


struct  BFu1ll_BFu9ll_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu9ll_BFu0s) C1{ FL:1 FL:9 Fs:0}



static void Test_BFu1ll_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9ll_BFu0s, BFu1ll_BFu9ll_BFu0s)
//============================================================================


struct  BFu1ll_BFu9s_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu1ll_BFu9s_BFu0c) C1{ FL:1 Fs:9 Fc:0}



static void Test_BFu1ll_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu1ll_BFu9s_BFu0c");
    static STRUCT_IF_C BFu1ll_BFu9s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9s_BFu0c, BFu1ll_BFu9s_BFu0c)
//============================================================================


struct  BFu1ll_BFu9s_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu1ll_BFu9s_BFu0i) C1{ FL:1 Fs:9 Fi:0}



static void Test_BFu1ll_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu1ll_BFu9s_BFu0i");
    static STRUCT_IF_C BFu1ll_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9s_BFu0i, BFu1ll_BFu9s_BFu0i)
//============================================================================


struct  BFu1ll_BFu9s_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu1ll_BFu9s_BFu0ll) C1{ FL:1 Fs:9 FL:0}



static void Test_BFu1ll_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu1ll_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu1ll_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9s_BFu0ll, BFu1ll_BFu9s_BFu0ll)
//============================================================================


struct  BFu1ll_BFu9s_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu1ll_BFu9s_BFu0s) C1{ FL:1 Fs:9 Fs:0}



static void Test_BFu1ll_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu1ll_BFu9s_BFu0s");
    static STRUCT_IF_C BFu1ll_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_BFu9s_BFu0s, BFu1ll_BFu9s_BFu0s)
//============================================================================


struct  BFu1ll_C_BFu0c  {
  __tsu64 v1:1;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_C_BFu0c) C1{ FL:1 Fc Fc:0}



static void Test_BFu1ll_C_BFu0c()
{
  {
    init_simple_test("BFu1ll_C_BFu0c");
    static STRUCT_IF_C BFu1ll_C_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_C_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_C_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1ll_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_C_BFu0c, BFu1ll_C_BFu0c)
//============================================================================


struct  BFu1ll_C_BFu0i  {
  __tsu64 v1:1;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_C_BFu0i) C1{ FL:1 Fc Fi:0}



static void Test_BFu1ll_C_BFu0i()
{
  {
    init_simple_test("BFu1ll_C_BFu0i");
    static STRUCT_IF_C BFu1ll_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_C_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1ll_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_C_BFu0i, BFu1ll_C_BFu0i)
//============================================================================


struct  BFu1ll_C_BFu0ll  {
  __tsu64 v1:1;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_C_BFu0ll) C1{ FL:1 Fc FL:0}



static void Test_BFu1ll_C_BFu0ll()
{
  {
    init_simple_test("BFu1ll_C_BFu0ll");
    static STRUCT_IF_C BFu1ll_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_C_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1ll_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_C_BFu0ll, BFu1ll_C_BFu0ll)
//============================================================================


struct  BFu1ll_C_BFu0s  {
  __tsu64 v1:1;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_C_BFu0s) C1{ FL:1 Fc Fs:0}



static void Test_BFu1ll_C_BFu0s()
{
  {
    init_simple_test("BFu1ll_C_BFu0s");
    static STRUCT_IF_C BFu1ll_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_C_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1ll_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_C_BFu0s, BFu1ll_C_BFu0s)
//============================================================================


struct  BFu1ll_D_BFu0c  {
  __tsu64 v1:1;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_D_BFu0c) C1{ FL:1 FL Fc:0}



static void Test_BFu1ll_D_BFu0c()
{
  {
    init_simple_test("BFu1ll_D_BFu0c");
    static STRUCT_IF_C BFu1ll_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_D_BFu0c, BFu1ll_D_BFu0c)
//============================================================================


struct  BFu1ll_D_BFu0i  {
  __tsu64 v1:1;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_D_BFu0i) C1{ FL:1 FL Fi:0}



static void Test_BFu1ll_D_BFu0i()
{
  {
    init_simple_test("BFu1ll_D_BFu0i");
    static STRUCT_IF_C BFu1ll_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_D_BFu0i, BFu1ll_D_BFu0i)
//============================================================================


struct  BFu1ll_D_BFu0ll  {
  __tsu64 v1:1;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_D_BFu0ll) C1{ FL:1 FL FL:0}



static void Test_BFu1ll_D_BFu0ll()
{
  {
    init_simple_test("BFu1ll_D_BFu0ll");
    static STRUCT_IF_C BFu1ll_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_D_BFu0ll, BFu1ll_D_BFu0ll)
//============================================================================


struct  BFu1ll_D_BFu0s  {
  __tsu64 v1:1;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_D_BFu0s) C1{ FL:1 FL Fs:0}



static void Test_BFu1ll_D_BFu0s()
{
  {
    init_simple_test("BFu1ll_D_BFu0s");
    static STRUCT_IF_C BFu1ll_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_D_BFu0s, BFu1ll_D_BFu0s)
//============================================================================


struct  BFu1ll_F_BFu0c  {
  __tsu64 v1:1;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_F_BFu0c) C1{ FL:1 Fi Fc:0}



static void Test_BFu1ll_F_BFu0c()
{
  {
    init_simple_test("BFu1ll_F_BFu0c");
    static STRUCT_IF_C BFu1ll_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_F_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1ll_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_F_BFu0c, BFu1ll_F_BFu0c)
//============================================================================


struct  BFu1ll_F_BFu0i  {
  __tsu64 v1:1;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_F_BFu0i) C1{ FL:1 Fi Fi:0}



static void Test_BFu1ll_F_BFu0i()
{
  {
    init_simple_test("BFu1ll_F_BFu0i");
    static STRUCT_IF_C BFu1ll_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_F_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1ll_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_F_BFu0i, BFu1ll_F_BFu0i)
//============================================================================


struct  BFu1ll_F_BFu0ll  {
  __tsu64 v1:1;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_F_BFu0ll) C1{ FL:1 Fi FL:0}



static void Test_BFu1ll_F_BFu0ll()
{
  {
    init_simple_test("BFu1ll_F_BFu0ll");
    static STRUCT_IF_C BFu1ll_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1ll_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_F_BFu0ll, BFu1ll_F_BFu0ll)
//============================================================================


struct  BFu1ll_F_BFu0s  {
  __tsu64 v1:1;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_F_BFu0s) C1{ FL:1 Fi Fs:0}



static void Test_BFu1ll_F_BFu0s()
{
  {
    init_simple_test("BFu1ll_F_BFu0s");
    static STRUCT_IF_C BFu1ll_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_F_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1ll_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_F_BFu0s, BFu1ll_F_BFu0s)
//============================================================================


struct  BFu1ll_I_BFu0c  {
  __tsu64 v1:1;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_I_BFu0c) C1{ FL:1 Fi Fc:0}



static void Test_BFu1ll_I_BFu0c()
{
  {
    init_simple_test("BFu1ll_I_BFu0c");
    static STRUCT_IF_C BFu1ll_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_I_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1ll_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_I_BFu0c, BFu1ll_I_BFu0c)
//============================================================================


struct  BFu1ll_I_BFu0i  {
  __tsu64 v1:1;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_I_BFu0i) C1{ FL:1 Fi Fi:0}



static void Test_BFu1ll_I_BFu0i()
{
  {
    init_simple_test("BFu1ll_I_BFu0i");
    static STRUCT_IF_C BFu1ll_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_I_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1ll_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_I_BFu0i, BFu1ll_I_BFu0i)
//============================================================================


struct  BFu1ll_I_BFu0ll  {
  __tsu64 v1:1;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_I_BFu0ll) C1{ FL:1 Fi FL:0}



static void Test_BFu1ll_I_BFu0ll()
{
  {
    init_simple_test("BFu1ll_I_BFu0ll");
    static STRUCT_IF_C BFu1ll_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1ll_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_I_BFu0ll, BFu1ll_I_BFu0ll)
//============================================================================


struct  BFu1ll_I_BFu0s  {
  __tsu64 v1:1;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_I_BFu0s) C1{ FL:1 Fi Fs:0}



static void Test_BFu1ll_I_BFu0s()
{
  {
    init_simple_test("BFu1ll_I_BFu0s");
    static STRUCT_IF_C BFu1ll_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_I_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1ll_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_I_BFu0s, BFu1ll_I_BFu0s)
//============================================================================


struct  BFu1ll_Ip_BFu0c  {
  __tsu64 v1:1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_Ip_BFu0c) C1{ FL:1 Fp Fc:0}



static void Test_BFu1ll_Ip_BFu0c()
{
  {
    init_simple_test("BFu1ll_Ip_BFu0c");
    static STRUCT_IF_C BFu1ll_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ip_BFu0c, BFu1ll_Ip_BFu0c)
//============================================================================


struct  BFu1ll_Ip_BFu0i  {
  __tsu64 v1:1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_Ip_BFu0i) C1{ FL:1 Fp Fi:0}



static void Test_BFu1ll_Ip_BFu0i()
{
  {
    init_simple_test("BFu1ll_Ip_BFu0i");
    static STRUCT_IF_C BFu1ll_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ip_BFu0i, BFu1ll_Ip_BFu0i)
//============================================================================


struct  BFu1ll_Ip_BFu0ll  {
  __tsu64 v1:1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_Ip_BFu0ll) C1{ FL:1 Fp FL:0}



static void Test_BFu1ll_Ip_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Ip_BFu0ll");
    static STRUCT_IF_C BFu1ll_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ip_BFu0ll, BFu1ll_Ip_BFu0ll)
//============================================================================


struct  BFu1ll_Ip_BFu0s  {
  __tsu64 v1:1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_Ip_BFu0s) C1{ FL:1 Fp Fs:0}



static void Test_BFu1ll_Ip_BFu0s()
{
  {
    init_simple_test("BFu1ll_Ip_BFu0s");
    static STRUCT_IF_C BFu1ll_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ip_BFu0s, BFu1ll_Ip_BFu0s)
//============================================================================


struct  BFu1ll_L_BFu0c  {
  __tsu64 v1:1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_L_BFu0c) C1{ FL:1 FL Fc:0}



static void Test_BFu1ll_L_BFu0c()
{
  {
    init_simple_test("BFu1ll_L_BFu0c");
    static STRUCT_IF_C BFu1ll_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_L_BFu0c, BFu1ll_L_BFu0c)
//============================================================================


struct  BFu1ll_L_BFu0i  {
  __tsu64 v1:1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_L_BFu0i) C1{ FL:1 FL Fi:0}



static void Test_BFu1ll_L_BFu0i()
{
  {
    init_simple_test("BFu1ll_L_BFu0i");
    static STRUCT_IF_C BFu1ll_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_L_BFu0i, BFu1ll_L_BFu0i)
//============================================================================


struct  BFu1ll_L_BFu0ll  {
  __tsu64 v1:1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_L_BFu0ll) C1{ FL:1 FL FL:0}



static void Test_BFu1ll_L_BFu0ll()
{
  {
    init_simple_test("BFu1ll_L_BFu0ll");
    static STRUCT_IF_C BFu1ll_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_L_BFu0ll, BFu1ll_L_BFu0ll)
//============================================================================


struct  BFu1ll_L_BFu0s  {
  __tsu64 v1:1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_L_BFu0s) C1{ FL:1 FL Fs:0}



static void Test_BFu1ll_L_BFu0s()
{
  {
    init_simple_test("BFu1ll_L_BFu0s");
    static STRUCT_IF_C BFu1ll_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_L_BFu0s, BFu1ll_L_BFu0s)
//============================================================================


struct  BFu1ll_S_BFu0c  {
  __tsu64 v1:1;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_S_BFu0c) C1{ FL:1 Fs Fc:0}



static void Test_BFu1ll_S_BFu0c()
{
  {
    init_simple_test("BFu1ll_S_BFu0c");
    static STRUCT_IF_C BFu1ll_S_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_S_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu1ll_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_S_BFu0c, BFu1ll_S_BFu0c)
//============================================================================


struct  BFu1ll_S_BFu0i  {
  __tsu64 v1:1;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_S_BFu0i) C1{ FL:1 Fs Fi:0}



static void Test_BFu1ll_S_BFu0i()
{
  {
    init_simple_test("BFu1ll_S_BFu0i");
    static STRUCT_IF_C BFu1ll_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu1ll_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_S_BFu0i, BFu1ll_S_BFu0i)
//============================================================================


struct  BFu1ll_S_BFu0ll  {
  __tsu64 v1:1;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_S_BFu0ll) C1{ FL:1 Fs FL:0}



static void Test_BFu1ll_S_BFu0ll()
{
  {
    init_simple_test("BFu1ll_S_BFu0ll");
    static STRUCT_IF_C BFu1ll_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu1ll_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_S_BFu0ll, BFu1ll_S_BFu0ll)
//============================================================================


struct  BFu1ll_S_BFu0s  {
  __tsu64 v1:1;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_S_BFu0s) C1{ FL:1 Fs Fs:0}



static void Test_BFu1ll_S_BFu0s()
{
  {
    init_simple_test("BFu1ll_S_BFu0s");
    static STRUCT_IF_C BFu1ll_S_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu1ll_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_S_BFu0s, BFu1ll_S_BFu0s)
//============================================================================


struct  BFu1ll_Uc_BFu0c  {
  __tsu64 v1:1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_Uc_BFu0c) C1{ FL:1 Fc Fc:0}



static void Test_BFu1ll_Uc_BFu0c()
{
  {
    init_simple_test("BFu1ll_Uc_BFu0c");
    static STRUCT_IF_C BFu1ll_Uc_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Uc_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Uc_BFu0c");
    check_field_offset(lv, v2, 1, "BFu1ll_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Uc_BFu0c, BFu1ll_Uc_BFu0c)
//============================================================================


struct  BFu1ll_Uc_BFu0i  {
  __tsu64 v1:1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_Uc_BFu0i) C1{ FL:1 Fc Fi:0}



static void Test_BFu1ll_Uc_BFu0i()
{
  {
    init_simple_test("BFu1ll_Uc_BFu0i");
    static STRUCT_IF_C BFu1ll_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Uc_BFu0i");
    check_field_offset(lv, v2, 1, "BFu1ll_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Uc_BFu0i, BFu1ll_Uc_BFu0i)
//============================================================================


struct  BFu1ll_Uc_BFu0ll  {
  __tsu64 v1:1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_Uc_BFu0ll) C1{ FL:1 Fc FL:0}



static void Test_BFu1ll_Uc_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Uc_BFu0ll");
    static STRUCT_IF_C BFu1ll_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Uc_BFu0ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Uc_BFu0ll, BFu1ll_Uc_BFu0ll)
//============================================================================


struct  BFu1ll_Uc_BFu0s  {
  __tsu64 v1:1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_Uc_BFu0s) C1{ FL:1 Fc Fs:0}



static void Test_BFu1ll_Uc_BFu0s()
{
  {
    init_simple_test("BFu1ll_Uc_BFu0s");
    static STRUCT_IF_C BFu1ll_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Uc_BFu0s");
    check_field_offset(lv, v2, 1, "BFu1ll_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Uc_BFu0s, BFu1ll_Uc_BFu0s)
//============================================================================


struct  BFu1ll_Ui_BFu0c  {
  __tsu64 v1:1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_Ui_BFu0c) C1{ FL:1 Fi Fc:0}



static void Test_BFu1ll_Ui_BFu0c()
{
  {
    init_simple_test("BFu1ll_Ui_BFu0c");
    static STRUCT_IF_C BFu1ll_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Ui_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu1ll_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ui_BFu0c, BFu1ll_Ui_BFu0c)
//============================================================================


struct  BFu1ll_Ui_BFu0i  {
  __tsu64 v1:1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_Ui_BFu0i) C1{ FL:1 Fi Fi:0}



static void Test_BFu1ll_Ui_BFu0i()
{
  {
    init_simple_test("BFu1ll_Ui_BFu0i");
    static STRUCT_IF_C BFu1ll_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Ui_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu1ll_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ui_BFu0i, BFu1ll_Ui_BFu0i)
//============================================================================


struct  BFu1ll_Ui_BFu0ll  {
  __tsu64 v1:1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_Ui_BFu0ll) C1{ FL:1 Fi FL:0}



static void Test_BFu1ll_Ui_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Ui_BFu0ll");
    static STRUCT_IF_C BFu1ll_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu1ll_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ui_BFu0ll, BFu1ll_Ui_BFu0ll)
//============================================================================


struct  BFu1ll_Ui_BFu0s  {
  __tsu64 v1:1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_Ui_BFu0s) C1{ FL:1 Fi Fs:0}



static void Test_BFu1ll_Ui_BFu0s()
{
  {
    init_simple_test("BFu1ll_Ui_BFu0s");
    static STRUCT_IF_C BFu1ll_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Ui_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu1ll_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ui_BFu0s, BFu1ll_Ui_BFu0s)
//============================================================================


struct  BFu1ll_Ul_BFu0c  {
  __tsu64 v1:1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_Ul_BFu0c) C1{ FL:1 FL Fc:0}



static void Test_BFu1ll_Ul_BFu0c()
{
  {
    init_simple_test("BFu1ll_Ul_BFu0c");
    static STRUCT_IF_C BFu1ll_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ul_BFu0c, BFu1ll_Ul_BFu0c)
//============================================================================


struct  BFu1ll_Ul_BFu0i  {
  __tsu64 v1:1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_Ul_BFu0i) C1{ FL:1 FL Fi:0}



static void Test_BFu1ll_Ul_BFu0i()
{
  {
    init_simple_test("BFu1ll_Ul_BFu0i");
    static STRUCT_IF_C BFu1ll_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ul_BFu0i, BFu1ll_Ul_BFu0i)
//============================================================================


struct  BFu1ll_Ul_BFu0ll  {
  __tsu64 v1:1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_Ul_BFu0ll) C1{ FL:1 FL FL:0}



static void Test_BFu1ll_Ul_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Ul_BFu0ll");
    static STRUCT_IF_C BFu1ll_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ul_BFu0ll, BFu1ll_Ul_BFu0ll)
//============================================================================


struct  BFu1ll_Ul_BFu0s  {
  __tsu64 v1:1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_Ul_BFu0s) C1{ FL:1 FL Fs:0}



static void Test_BFu1ll_Ul_BFu0s()
{
  {
    init_simple_test("BFu1ll_Ul_BFu0s");
    static STRUCT_IF_C BFu1ll_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Ul_BFu0s, BFu1ll_Ul_BFu0s)
//============================================================================


struct  BFu1ll_Us_BFu0c  {
  __tsu64 v1:1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_Us_BFu0c) C1{ FL:1 Fs Fc:0}



static void Test_BFu1ll_Us_BFu0c()
{
  {
    init_simple_test("BFu1ll_Us_BFu0c");
    static STRUCT_IF_C BFu1ll_Us_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Us_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu1ll_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Us_BFu0c, BFu1ll_Us_BFu0c)
//============================================================================


struct  BFu1ll_Us_BFu0i  {
  __tsu64 v1:1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_Us_BFu0i) C1{ FL:1 Fs Fi:0}



static void Test_BFu1ll_Us_BFu0i()
{
  {
    init_simple_test("BFu1ll_Us_BFu0i");
    static STRUCT_IF_C BFu1ll_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu1ll_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Us_BFu0i, BFu1ll_Us_BFu0i)
//============================================================================


struct  BFu1ll_Us_BFu0ll  {
  __tsu64 v1:1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_Us_BFu0ll) C1{ FL:1 Fs FL:0}



static void Test_BFu1ll_Us_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Us_BFu0ll");
    static STRUCT_IF_C BFu1ll_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu1ll_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Us_BFu0ll, BFu1ll_Us_BFu0ll)
//============================================================================


struct  BFu1ll_Us_BFu0s  {
  __tsu64 v1:1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_Us_BFu0s) C1{ FL:1 Fs Fs:0}



static void Test_BFu1ll_Us_BFu0s()
{
  {
    init_simple_test("BFu1ll_Us_BFu0s");
    static STRUCT_IF_C BFu1ll_Us_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Us_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu1ll_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Us_BFu0s, BFu1ll_Us_BFu0s)
//============================================================================


struct  BFu1ll_Vp_BFu0c  {
  __tsu64 v1:1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu1ll_Vp_BFu0c) C1{ FL:1 Fp Fc:0}



static void Test_BFu1ll_Vp_BFu0c()
{
  {
    init_simple_test("BFu1ll_Vp_BFu0c");
    static STRUCT_IF_C BFu1ll_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Vp_BFu0c, BFu1ll_Vp_BFu0c)
//============================================================================


struct  BFu1ll_Vp_BFu0i  {
  __tsu64 v1:1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu1ll_Vp_BFu0i) C1{ FL:1 Fp Fi:0}



static void Test_BFu1ll_Vp_BFu0i()
{
  {
    init_simple_test("BFu1ll_Vp_BFu0i");
    static STRUCT_IF_C BFu1ll_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Vp_BFu0i, BFu1ll_Vp_BFu0i)
//============================================================================


struct  BFu1ll_Vp_BFu0ll  {
  __tsu64 v1:1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu1ll_Vp_BFu0ll) C1{ FL:1 Fp FL:0}



static void Test_BFu1ll_Vp_BFu0ll()
{
  {
    init_simple_test("BFu1ll_Vp_BFu0ll");
    static STRUCT_IF_C BFu1ll_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Vp_BFu0ll, BFu1ll_Vp_BFu0ll)
//============================================================================


struct  BFu1ll_Vp_BFu0s  {
  __tsu64 v1:1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu1ll_Vp_BFu0s) C1{ FL:1 Fp Fs:0}



static void Test_BFu1ll_Vp_BFu0s()
{
  {
    init_simple_test("BFu1ll_Vp_BFu0s");
    static STRUCT_IF_C BFu1ll_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1ll_Vp_BFu0s, BFu1ll_Vp_BFu0s)
//============================================================================


struct  BFu1s_BFu0c  {
  unsigned short v1:1;
  unsigned char  :0;
};
//SIG(1 BFu1s_BFu0c) C1{ Fs:1 Fc:0}



static void Test_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu1s_BFu0c");
    static STRUCT_IF_C BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c, BFu1s_BFu0c)
//============================================================================


struct  BFu1s_BFu0c_BFu0c  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu1s_BFu0c_BFu0c) C1{ Fs:1 Fc:0 Fc:0}



static void Test_BFu1s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu0c");
    static STRUCT_IF_C BFu1s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu0c, BFu1s_BFu0c_BFu0c)
//============================================================================


struct  BFu1s_BFu0c_BFu0i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu1s_BFu0c_BFu0i) C1{ Fs:1 Fc:0 Fi:0}



static void Test_BFu1s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu0i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu0i, BFu1s_BFu0c_BFu0i)
//============================================================================


struct  BFu1s_BFu0c_BFu0ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu1s_BFu0c_BFu0ll) C1{ Fs:1 Fc:0 FL:0}



static void Test_BFu1s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu0ll, BFu1s_BFu0c_BFu0ll)
//============================================================================


struct  BFu1s_BFu0c_BFu0s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu1s_BFu0c_BFu0s) C1{ Fs:1 Fc:0 Fs:0}



static void Test_BFu1s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu0s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu0s, BFu1s_BFu0c_BFu0s)
//============================================================================


struct  BFu1s_BFu0c_BFu15i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1s_BFu0c_BFu15i) C1{ Fs:1 Fc:0 Fi:15}



static void Test_BFu1s_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu15i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1s_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1s_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu15i, BFu1s_BFu0c_BFu15i)
//============================================================================


struct  BFu1s_BFu0c_BFu15ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1s_BFu0c_BFu15ll) C1{ Fs:1 Fc:0 FL:15}



static void Test_BFu1s_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu1s_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu1s_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu15ll, BFu1s_BFu0c_BFu15ll)
//============================================================================


struct  BFu1s_BFu0c_BFu15s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1s_BFu0c_BFu15s) C1{ Fs:1 Fc:0 Fs:15}



static void Test_BFu1s_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu15s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu1s_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu1s_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu15s, BFu1s_BFu0c_BFu15s)
//============================================================================


struct  BFu1s_BFu0c_BFu16i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1s_BFu0c_BFu16i) C1{ Fs:1 Fc:0 Fi:16}



static void Test_BFu1s_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu16i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1s_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu16i, BFu1s_BFu0c_BFu16i)
//============================================================================


struct  BFu1s_BFu0c_BFu16ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1s_BFu0c_BFu16ll) C1{ Fs:1 Fc:0 FL:16}



static void Test_BFu1s_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu1s_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu16ll, BFu1s_BFu0c_BFu16ll)
//============================================================================


struct  BFu1s_BFu0c_BFu16s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1s_BFu0c_BFu16s) C1{ Fs:1 Fc:0 Fs:16}



static void Test_BFu1s_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu16s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1s_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu16s, BFu1s_BFu0c_BFu16s)
//============================================================================


struct  BFu1s_BFu0c_BFu17i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1s_BFu0c_BFu17i) C1{ Fs:1 Fc:0 Fi:17}



static void Test_BFu1s_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu17i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1s_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1s_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu17i, BFu1s_BFu0c_BFu17i)
//============================================================================


struct  BFu1s_BFu0c_BFu17ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1s_BFu0c_BFu17ll) C1{ Fs:1 Fc:0 FL:17}



static void Test_BFu1s_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu1s_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu1s_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu17ll, BFu1s_BFu0c_BFu17ll)
//============================================================================


struct  BFu1s_BFu0c_BFu1c  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1s_BFu0c_BFu1c) C1{ Fs:1 Fc:0 Fc:1}



static void Test_BFu1s_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu1c");
    static STRUCT_IF_C BFu1s_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1s_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu1c, BFu1s_BFu0c_BFu1c)
//============================================================================


struct  BFu1s_BFu0c_BFu1i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1s_BFu0c_BFu1i) C1{ Fs:1 Fc:0 Fi:1}



static void Test_BFu1s_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu1i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1s_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu1i, BFu1s_BFu0c_BFu1i)
//============================================================================


struct  BFu1s_BFu0c_BFu1ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1s_BFu0c_BFu1ll) C1{ Fs:1 Fc:0 FL:1}



static void Test_BFu1s_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1s_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu1ll, BFu1s_BFu0c_BFu1ll)
//============================================================================


struct  BFu1s_BFu0c_BFu1s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1s_BFu0c_BFu1s) C1{ Fs:1 Fc:0 Fs:1}



static void Test_BFu1s_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu1s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu1s_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu1s, BFu1s_BFu0c_BFu1s)
//============================================================================


struct  BFu1s_BFu0c_BFu31i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1s_BFu0c_BFu31i) C1{ Fs:1 Fc:0 Fi:31}



static void Test_BFu1s_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu31i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1s_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1s_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu31i, BFu1s_BFu0c_BFu31i)
//============================================================================


struct  BFu1s_BFu0c_BFu31ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1s_BFu0c_BFu31ll) C1{ Fs:1 Fc:0 FL:31}



static void Test_BFu1s_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu1s_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu1s_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu31ll, BFu1s_BFu0c_BFu31ll)
//============================================================================


struct  BFu1s_BFu0c_BFu32i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1s_BFu0c_BFu32i) C1{ Fs:1 Fc:0 Fi:32}



static void Test_BFu1s_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu32i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1s_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1s_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu32i, BFu1s_BFu0c_BFu32i)
//============================================================================


struct  BFu1s_BFu0c_BFu32ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1s_BFu0c_BFu32ll) C1{ Fs:1 Fc:0 FL:32}



static void Test_BFu1s_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu1s_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu1s_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu32ll, BFu1s_BFu0c_BFu32ll)
//============================================================================


struct  BFu1s_BFu0c_BFu33  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1s_BFu0c_BFu33) C1{ Fs:1 Fc:0 FL:33}



static void Test_BFu1s_BFu0c_BFu33()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu33");
    static STRUCT_IF_C BFu1s_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu1s_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu1s_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu33, BFu1s_BFu0c_BFu33)
//============================================================================


struct  BFu1s_BFu0c_BFu7c  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1s_BFu0c_BFu7c) C1{ Fs:1 Fc:0 Fc:7}



static void Test_BFu1s_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu7c");
    static STRUCT_IF_C BFu1s_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1s_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu7c, BFu1s_BFu0c_BFu7c)
//============================================================================


struct  BFu1s_BFu0c_BFu7i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1s_BFu0c_BFu7i) C1{ Fs:1 Fc:0 Fi:7}



static void Test_BFu1s_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu7i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1s_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu7i, BFu1s_BFu0c_BFu7i)
//============================================================================


struct  BFu1s_BFu0c_BFu7ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1s_BFu0c_BFu7ll) C1{ Fs:1 Fc:0 FL:7}



static void Test_BFu1s_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1s_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu7ll, BFu1s_BFu0c_BFu7ll)
//============================================================================


struct  BFu1s_BFu0c_BFu7s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1s_BFu0c_BFu7s) C1{ Fs:1 Fc:0 Fs:7}



static void Test_BFu1s_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu7s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu1s_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu7s, BFu1s_BFu0c_BFu7s)
//============================================================================


struct  BFu1s_BFu0c_BFu8c  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1s_BFu0c_BFu8c) C1{ Fs:1 Fc:0 Fc:8}



static void Test_BFu1s_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu8c");
    static STRUCT_IF_C BFu1s_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1s_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu8c, BFu1s_BFu0c_BFu8c)
//============================================================================


struct  BFu1s_BFu0c_BFu8i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1s_BFu0c_BFu8i) C1{ Fs:1 Fc:0 Fi:8}



static void Test_BFu1s_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu8i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1s_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu8i, BFu1s_BFu0c_BFu8i)
//============================================================================


struct  BFu1s_BFu0c_BFu8ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1s_BFu0c_BFu8ll) C1{ Fs:1 Fc:0 FL:8}



static void Test_BFu1s_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1s_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu8ll, BFu1s_BFu0c_BFu8ll)
//============================================================================


struct  BFu1s_BFu0c_BFu8s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1s_BFu0c_BFu8s) C1{ Fs:1 Fc:0 Fs:8}



static void Test_BFu1s_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu8s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1s_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu8s, BFu1s_BFu0c_BFu8s)
//============================================================================


struct  BFu1s_BFu0c_BFu9i  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1s_BFu0c_BFu9i) C1{ Fs:1 Fc:0 Fi:9}



static void Test_BFu1s_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu9i");
    static STRUCT_IF_C BFu1s_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1s_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1s_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu9i, BFu1s_BFu0c_BFu9i)
//============================================================================


struct  BFu1s_BFu0c_BFu9ll  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1s_BFu0c_BFu9ll) C1{ Fs:1 Fc:0 FL:9}



static void Test_BFu1s_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu1s_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu1s_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu1s_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu9ll, BFu1s_BFu0c_BFu9ll)
//============================================================================


struct  BFu1s_BFu0c_BFu9s  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1s_BFu0c_BFu9s) C1{ Fs:1 Fc:0 Fs:9}



static void Test_BFu1s_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu1s_BFu0c_BFu9s");
    static STRUCT_IF_C BFu1s_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu1s_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu1s_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_BFu9s, BFu1s_BFu0c_BFu9s)
//============================================================================


struct  BFu1s_BFu0c_C  {
  unsigned short v1:1;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu1s_BFu0c_C) C1{ Fs:1 Fc:0 Fc}



static void Test_BFu1s_BFu0c_C()
{
  {
    init_simple_test("BFu1s_BFu0c_C");
    static STRUCT_IF_C BFu1s_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_C");
    check_field_offset(lv, v2, 1, "BFu1s_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_C, BFu1s_BFu0c_C)
//============================================================================


struct  BFu1s_BFu0c_D  {
  unsigned short v1:1;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu1s_BFu0c_D) C1{ Fs:1 Fc:0 FL}



static void Test_BFu1s_BFu0c_D()
{
  {
    init_simple_test("BFu1s_BFu0c_D");
    static STRUCT_IF_C BFu1s_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_D, BFu1s_BFu0c_D)
//============================================================================


struct  BFu1s_BFu0c_F  {
  unsigned short v1:1;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu1s_BFu0c_F) C1{ Fs:1 Fc:0 Fi}



static void Test_BFu1s_BFu0c_F()
{
  {
    init_simple_test("BFu1s_BFu0c_F");
    static STRUCT_IF_C BFu1s_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_F, BFu1s_BFu0c_F)
//============================================================================


struct  BFu1s_BFu0c_I  {
  unsigned short v1:1;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu1s_BFu0c_I) C1{ Fs:1 Fc:0 Fi}



static void Test_BFu1s_BFu0c_I()
{
  {
    init_simple_test("BFu1s_BFu0c_I");
    static STRUCT_IF_C BFu1s_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_I, BFu1s_BFu0c_I)
//============================================================================


struct  BFu1s_BFu0c_Ip  {
  unsigned short v1:1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu1s_BFu0c_Ip) C1{ Fs:1 Fc:0 Fp}



static void Test_BFu1s_BFu0c_Ip()
{
  {
    init_simple_test("BFu1s_BFu0c_Ip");
    static STRUCT_IF_C BFu1s_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1s_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Ip, BFu1s_BFu0c_Ip)
//============================================================================


struct  BFu1s_BFu0c_L  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu1s_BFu0c_L) C1{ Fs:1 Fc:0 FL}



static void Test_BFu1s_BFu0c_L()
{
  {
    init_simple_test("BFu1s_BFu0c_L");
    static STRUCT_IF_C BFu1s_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_L, BFu1s_BFu0c_L)
//============================================================================


struct  BFu1s_BFu0c_S  {
  unsigned short v1:1;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu1s_BFu0c_S) C1{ Fs:1 Fc:0 Fs}



static void Test_BFu1s_BFu0c_S()
{
  {
    init_simple_test("BFu1s_BFu0c_S");
    static STRUCT_IF_C BFu1s_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu1s_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_S, BFu1s_BFu0c_S)
//============================================================================


struct  BFu1s_BFu0c_Uc  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu1s_BFu0c_Uc) C1{ Fs:1 Fc:0 Fc}



static void Test_BFu1s_BFu0c_Uc()
{
  {
    init_simple_test("BFu1s_BFu0c_Uc");
    static STRUCT_IF_C BFu1s_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu0c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Uc");
    check_field_offset(lv, v2, 1, "BFu1s_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Uc, BFu1s_BFu0c_Uc)
//============================================================================


struct  BFu1s_BFu0c_Ui  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu1s_BFu0c_Ui) C1{ Fs:1 Fc:0 Fi}



static void Test_BFu1s_BFu0c_Ui()
{
  {
    init_simple_test("BFu1s_BFu0c_Ui");
    static STRUCT_IF_C BFu1s_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Ui, BFu1s_BFu0c_Ui)
//============================================================================


struct  BFu1s_BFu0c_Ul  {
  unsigned short v1:1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu1s_BFu0c_Ul) C1{ Fs:1 Fc:0 FL}



static void Test_BFu1s_BFu0c_Ul()
{
  {
    init_simple_test("BFu1s_BFu0c_Ul");
    static STRUCT_IF_C BFu1s_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Ul, BFu1s_BFu0c_Ul)
//============================================================================


struct  BFu1s_BFu0c_Us  {
  unsigned short v1:1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu1s_BFu0c_Us) C1{ Fs:1 Fc:0 Fs}



static void Test_BFu1s_BFu0c_Us()
{
  {
    init_simple_test("BFu1s_BFu0c_Us");
    static STRUCT_IF_C BFu1s_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu1s_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Us, BFu1s_BFu0c_Us)
//============================================================================


struct  BFu1s_BFu0c_Vp  {
  unsigned short v1:1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu1s_BFu0c_Vp) C1{ Fs:1 Fc:0 Fp}



static void Test_BFu1s_BFu0c_Vp()
{
  {
    init_simple_test("BFu1s_BFu0c_Vp");
    static STRUCT_IF_C BFu1s_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1s_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0c_Vp, BFu1s_BFu0c_Vp)
//============================================================================


struct  BFu1s_BFu0i  {
  unsigned short v1:1;
  unsigned int  :0;
};
//SIG(1 BFu1s_BFu0i) C1{ Fs:1 Fi:0}



static void Test_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu1s_BFu0i");
    static STRUCT_IF_C BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i, BFu1s_BFu0i)
//============================================================================


struct  BFu1s_BFu0i_BFu0c  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu1s_BFu0i_BFu0c) C1{ Fs:1 Fi:0 Fc:0}



static void Test_BFu1s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu0c");
    static STRUCT_IF_C BFu1s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu0c, BFu1s_BFu0i_BFu0c)
//============================================================================


struct  BFu1s_BFu0i_BFu0i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu1s_BFu0i_BFu0i) C1{ Fs:1 Fi:0 Fi:0}



static void Test_BFu1s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu0i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu0i, BFu1s_BFu0i_BFu0i)
//============================================================================


struct  BFu1s_BFu0i_BFu0ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu1s_BFu0i_BFu0ll) C1{ Fs:1 Fi:0 FL:0}



static void Test_BFu1s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu0ll, BFu1s_BFu0i_BFu0ll)
//============================================================================


struct  BFu1s_BFu0i_BFu0s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu1s_BFu0i_BFu0s) C1{ Fs:1 Fi:0 Fs:0}



static void Test_BFu1s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu0s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu0s, BFu1s_BFu0i_BFu0s)
//============================================================================


struct  BFu1s_BFu0i_BFu15i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu1s_BFu0i_BFu15i) C1{ Fs:1 Fi:0 Fi:15}



static void Test_BFu1s_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu15i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1s_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1s_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu15i, BFu1s_BFu0i_BFu15i)
//============================================================================


struct  BFu1s_BFu0i_BFu15ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu1s_BFu0i_BFu15ll) C1{ Fs:1 Fi:0 FL:15}



static void Test_BFu1s_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1s_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1s_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu15ll, BFu1s_BFu0i_BFu15ll)
//============================================================================


struct  BFu1s_BFu0i_BFu15s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu1s_BFu0i_BFu15s) C1{ Fs:1 Fi:0 Fs:15}



static void Test_BFu1s_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu15s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu1s_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu1s_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu15s, BFu1s_BFu0i_BFu15s)
//============================================================================


struct  BFu1s_BFu0i_BFu16i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu1s_BFu0i_BFu16i) C1{ Fs:1 Fi:0 Fi:16}



static void Test_BFu1s_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu16i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1s_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu16i, BFu1s_BFu0i_BFu16i)
//============================================================================


struct  BFu1s_BFu0i_BFu16ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu1s_BFu0i_BFu16ll) C1{ Fs:1 Fi:0 FL:16}



static void Test_BFu1s_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1s_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu16ll, BFu1s_BFu0i_BFu16ll)
//============================================================================


struct  BFu1s_BFu0i_BFu16s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu1s_BFu0i_BFu16s) C1{ Fs:1 Fi:0 Fs:16}



static void Test_BFu1s_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu16s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu1s_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu16s, BFu1s_BFu0i_BFu16s)
//============================================================================


struct  BFu1s_BFu0i_BFu17i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu1s_BFu0i_BFu17i) C1{ Fs:1 Fi:0 Fi:17}



static void Test_BFu1s_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu17i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1s_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1s_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu17i, BFu1s_BFu0i_BFu17i)
//============================================================================


struct  BFu1s_BFu0i_BFu17ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu1s_BFu0i_BFu17ll) C1{ Fs:1 Fi:0 FL:17}



static void Test_BFu1s_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu1s_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu1s_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu17ll, BFu1s_BFu0i_BFu17ll)
//============================================================================


struct  BFu1s_BFu0i_BFu1c  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu1s_BFu0i_BFu1c) C1{ Fs:1 Fi:0 Fc:1}



static void Test_BFu1s_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu1c");
    static STRUCT_IF_C BFu1s_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1s_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu1c, BFu1s_BFu0i_BFu1c)
//============================================================================


struct  BFu1s_BFu0i_BFu1i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu1s_BFu0i_BFu1i) C1{ Fs:1 Fi:0 Fi:1}



static void Test_BFu1s_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu1i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1s_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu1i, BFu1s_BFu0i_BFu1i)
//============================================================================


struct  BFu1s_BFu0i_BFu1ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu1s_BFu0i_BFu1ll) C1{ Fs:1 Fi:0 FL:1}



static void Test_BFu1s_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1s_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu1ll, BFu1s_BFu0i_BFu1ll)
//============================================================================


struct  BFu1s_BFu0i_BFu1s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu1s_BFu0i_BFu1s) C1{ Fs:1 Fi:0 Fs:1}



static void Test_BFu1s_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu1s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu1s_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu1s, BFu1s_BFu0i_BFu1s)
//============================================================================


struct  BFu1s_BFu0i_BFu31i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu1s_BFu0i_BFu31i) C1{ Fs:1 Fi:0 Fi:31}



static void Test_BFu1s_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu31i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1s_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1s_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu31i, BFu1s_BFu0i_BFu31i)
//============================================================================


struct  BFu1s_BFu0i_BFu31ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu1s_BFu0i_BFu31ll) C1{ Fs:1 Fi:0 FL:31}



static void Test_BFu1s_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu1s_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu1s_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu31ll, BFu1s_BFu0i_BFu31ll)
//============================================================================


struct  BFu1s_BFu0i_BFu32i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu1s_BFu0i_BFu32i) C1{ Fs:1 Fi:0 Fi:32}



static void Test_BFu1s_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu32i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1s_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1s_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu32i, BFu1s_BFu0i_BFu32i)
//============================================================================


struct  BFu1s_BFu0i_BFu32ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu1s_BFu0i_BFu32ll) C1{ Fs:1 Fi:0 FL:32}



static void Test_BFu1s_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1s_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1s_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu32ll, BFu1s_BFu0i_BFu32ll)
//============================================================================


struct  BFu1s_BFu0i_BFu33  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu1s_BFu0i_BFu33) C1{ Fs:1 Fi:0 FL:33}



static void Test_BFu1s_BFu0i_BFu33()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu33");
    static STRUCT_IF_C BFu1s_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu1s_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu1s_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu33, BFu1s_BFu0i_BFu33)
//============================================================================


struct  BFu1s_BFu0i_BFu7c  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu1s_BFu0i_BFu7c) C1{ Fs:1 Fi:0 Fc:7}



static void Test_BFu1s_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu7c");
    static STRUCT_IF_C BFu1s_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1s_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu7c, BFu1s_BFu0i_BFu7c)
//============================================================================


struct  BFu1s_BFu0i_BFu7i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu1s_BFu0i_BFu7i) C1{ Fs:1 Fi:0 Fi:7}



static void Test_BFu1s_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu7i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1s_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu7i, BFu1s_BFu0i_BFu7i)
//============================================================================


struct  BFu1s_BFu0i_BFu7ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu1s_BFu0i_BFu7ll) C1{ Fs:1 Fi:0 FL:7}



static void Test_BFu1s_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1s_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu7ll, BFu1s_BFu0i_BFu7ll)
//============================================================================


struct  BFu1s_BFu0i_BFu7s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu1s_BFu0i_BFu7s) C1{ Fs:1 Fi:0 Fs:7}



static void Test_BFu1s_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu7s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu1s_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu1s_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu7s, BFu1s_BFu0i_BFu7s)
//============================================================================


struct  BFu1s_BFu0i_BFu8c  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu1s_BFu0i_BFu8c) C1{ Fs:1 Fi:0 Fc:8}



static void Test_BFu1s_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu8c");
    static STRUCT_IF_C BFu1s_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1s_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu8c, BFu1s_BFu0i_BFu8c)
//============================================================================


struct  BFu1s_BFu0i_BFu8i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu1s_BFu0i_BFu8i) C1{ Fs:1 Fi:0 Fi:8}



static void Test_BFu1s_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu8i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1s_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu8i, BFu1s_BFu0i_BFu8i)
//============================================================================


struct  BFu1s_BFu0i_BFu8ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu1s_BFu0i_BFu8ll) C1{ Fs:1 Fi:0 FL:8}



static void Test_BFu1s_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1s_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu8ll, BFu1s_BFu0i_BFu8ll)
//============================================================================


struct  BFu1s_BFu0i_BFu8s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu1s_BFu0i_BFu8s) C1{ Fs:1 Fi:0 Fs:8}



static void Test_BFu1s_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu8s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu1s_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu8s, BFu1s_BFu0i_BFu8s)
//============================================================================


struct  BFu1s_BFu0i_BFu9i  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu1s_BFu0i_BFu9i) C1{ Fs:1 Fi:0 Fi:9}



static void Test_BFu1s_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu9i");
    static STRUCT_IF_C BFu1s_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1s_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1s_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu9i, BFu1s_BFu0i_BFu9i)
//============================================================================


struct  BFu1s_BFu0i_BFu9ll  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu1s_BFu0i_BFu9ll) C1{ Fs:1 Fi:0 FL:9}



static void Test_BFu1s_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu1s_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1s_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1s_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu9ll, BFu1s_BFu0i_BFu9ll)
//============================================================================


struct  BFu1s_BFu0i_BFu9s  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu1s_BFu0i_BFu9s) C1{ Fs:1 Fi:0 Fs:9}



static void Test_BFu1s_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu1s_BFu0i_BFu9s");
    static STRUCT_IF_C BFu1s_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu1s_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu1s_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_BFu9s, BFu1s_BFu0i_BFu9s)
//============================================================================


struct  BFu1s_BFu0i_C  {
  unsigned short v1:1;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu1s_BFu0i_C) C1{ Fs:1 Fi:0 Fc}



static void Test_BFu1s_BFu0i_C()
{
  {
    init_simple_test("BFu1s_BFu0i_C");
    static STRUCT_IF_C BFu1s_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_C, BFu1s_BFu0i_C)
//============================================================================


struct  BFu1s_BFu0i_D  {
  unsigned short v1:1;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu1s_BFu0i_D) C1{ Fs:1 Fi:0 FL}



static void Test_BFu1s_BFu0i_D()
{
  {
    init_simple_test("BFu1s_BFu0i_D");
    static STRUCT_IF_C BFu1s_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_D, BFu1s_BFu0i_D)
//============================================================================


struct  BFu1s_BFu0i_F  {
  unsigned short v1:1;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu1s_BFu0i_F) C1{ Fs:1 Fi:0 Fi}



static void Test_BFu1s_BFu0i_F()
{
  {
    init_simple_test("BFu1s_BFu0i_F");
    static STRUCT_IF_C BFu1s_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_F, BFu1s_BFu0i_F)
//============================================================================


struct  BFu1s_BFu0i_I  {
  unsigned short v1:1;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu1s_BFu0i_I) C1{ Fs:1 Fi:0 Fi}



static void Test_BFu1s_BFu0i_I()
{
  {
    init_simple_test("BFu1s_BFu0i_I");
    static STRUCT_IF_C BFu1s_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_I, BFu1s_BFu0i_I)
//============================================================================


struct  BFu1s_BFu0i_Ip  {
  unsigned short v1:1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu1s_BFu0i_Ip) C1{ Fs:1 Fi:0 Fp}



static void Test_BFu1s_BFu0i_Ip()
{
  {
    init_simple_test("BFu1s_BFu0i_Ip");
    static STRUCT_IF_C BFu1s_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1s_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_Ip, BFu1s_BFu0i_Ip)
//============================================================================


struct  BFu1s_BFu0i_L  {
  unsigned short v1:1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu1s_BFu0i_L) C1{ Fs:1 Fi:0 FL}



static void Test_BFu1s_BFu0i_L()
{
  {
    init_simple_test("BFu1s_BFu0i_L");
    static STRUCT_IF_C BFu1s_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_L, BFu1s_BFu0i_L)
//============================================================================


struct  BFu1s_BFu0i_S  {
  unsigned short v1:1;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu1s_BFu0i_S) C1{ Fs:1 Fi:0 Fs}



static void Test_BFu1s_BFu0i_S()
{
  {
    init_simple_test("BFu1s_BFu0i_S");
    static STRUCT_IF_C BFu1s_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu1s_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu1s_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu1s_BFu0i_S, BFu1s_BFu0i_S)
//============================================================================


struct  BFu1s_BFu0i_Uc  {
  unsigned short v1:1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu1s_BFu0i_Uc) C1{ Fs:1 Fi:0 Fc}



static void Test_BFu1s_BFu0i_Uc()
{
  {
    init_simple_test("BFu1s_BFu0i_Uc");
    static STRUCT_IF_C BFu1s_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu1s_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(2