// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu0s_C_BFu7ll  {
  unsigned short  :0;
  char v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_C_BFu7ll) C1{ Fs:0 Fc FL:7}



static void Test_BFu0s_C_BFu7ll()
{
  {
    init_simple_test("BFu0s_C_BFu7ll");
    static STRUCT_IF_C BFu0s_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0s_C_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0s_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu7ll, BFu0s_C_BFu7ll)
//============================================================================


struct  BFu0s_C_BFu7s  {
  unsigned short  :0;
  char v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_C_BFu7s) C1{ Fs:0 Fc Fs:7}



static void Test_BFu0s_C_BFu7s()
{
  {
    init_simple_test("BFu0s_C_BFu7s");
    static STRUCT_IF_C BFu0s_C_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_C_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_C_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0s_C_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0s_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu7s, BFu0s_C_BFu7s)
//============================================================================


struct  BFu0s_C_BFu8c  {
  unsigned short  :0;
  char v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_C_BFu8c) C1{ Fs:0 Fc Fc:8}



static void Test_BFu0s_C_BFu8c()
{
  {
    init_simple_test("BFu0s_C_BFu8c");
    static STRUCT_IF_C BFu0s_C_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_C_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_C_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_C_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu8c, BFu0s_C_BFu8c)
//============================================================================


struct  BFu0s_C_BFu8i  {
  unsigned short  :0;
  char v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_C_BFu8i) C1{ Fs:0 Fc Fi:8}



static void Test_BFu0s_C_BFu8i()
{
  {
    init_simple_test("BFu0s_C_BFu8i");
    static STRUCT_IF_C BFu0s_C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_C_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_C_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu8i, BFu0s_C_BFu8i)
//============================================================================


struct  BFu0s_C_BFu8ll  {
  unsigned short  :0;
  char v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_C_BFu8ll) C1{ Fs:0 Fc FL:8}



static void Test_BFu0s_C_BFu8ll()
{
  {
    init_simple_test("BFu0s_C_BFu8ll");
    static STRUCT_IF_C BFu0s_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_C_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu8ll, BFu0s_C_BFu8ll)
//============================================================================


struct  BFu0s_C_BFu8s  {
  unsigned short  :0;
  char v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_C_BFu8s) C1{ Fs:0 Fc Fs:8}



static void Test_BFu0s_C_BFu8s()
{
  {
    init_simple_test("BFu0s_C_BFu8s");
    static STRUCT_IF_C BFu0s_C_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_C_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_C_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_C_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu8s, BFu0s_C_BFu8s)
//============================================================================


struct  BFu0s_C_BFu9i  {
  unsigned short  :0;
  char v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_C_BFu9i) C1{ Fs:0 Fc Fi:9}



static void Test_BFu0s_C_BFu9i()
{
  {
    init_simple_test("BFu0s_C_BFu9i");
    static STRUCT_IF_C BFu0s_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_C_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0s_C_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0s_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu9i, BFu0s_C_BFu9i)
//============================================================================


struct  BFu0s_C_BFu9ll  {
  unsigned short  :0;
  char v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_C_BFu9ll) C1{ Fs:0 Fc FL:9}



static void Test_BFu0s_C_BFu9ll()
{
  {
    init_simple_test("BFu0s_C_BFu9ll");
    static STRUCT_IF_C BFu0s_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0s_C_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0s_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu9ll, BFu0s_C_BFu9ll)
//============================================================================


struct  BFu0s_C_BFu9s  {
  unsigned short  :0;
  char v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_C_BFu9s) C1{ Fs:0 Fc Fs:9}



static void Test_BFu0s_C_BFu9s()
{
  {
    init_simple_test("BFu0s_C_BFu9s");
    static STRUCT_IF_C BFu0s_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_C_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_C_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_C_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_C_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_BFu9s, BFu0s_C_BFu9s)
//============================================================================


struct  BFu0s_C_C  {
  unsigned short  :0;
  char v1;
  char v2;
};
//SIG(1 BFu0s_C_C) C1{ Fs:0 Fc[2]}



static void Test_BFu0s_C_C()
{
  {
    init_simple_test("BFu0s_C_C");
    static STRUCT_IF_C BFu0s_C_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_C_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_C_C)");
    check_field_offset(lv, v1, 0, "BFu0s_C_C.v1");
    check_field_offset(lv, v2, 1, "BFu0s_C_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_C, BFu0s_C_C)
//============================================================================


struct  BFu0s_C_D  {
  unsigned short  :0;
  char v1;
  double v2;
};
//SIG(1 BFu0s_C_D) C1{ Fs:0 Fc FL}



static void Test_BFu0s_C_D()
{
  {
    init_simple_test("BFu0s_C_D");
    static STRUCT_IF_C BFu0s_C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_D)");
    check_field_offset(lv, v1, 0, "BFu0s_C_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_C_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_D, BFu0s_C_D)
//============================================================================


struct  BFu0s_C_F  {
  unsigned short  :0;
  char v1;
  float v2;
};
//SIG(1 BFu0s_C_F) C1{ Fs:0 Fc Fi}



static void Test_BFu0s_C_F()
{
  {
    init_simple_test("BFu0s_C_F");
    static STRUCT_IF_C BFu0s_C_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_C_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_C_F)");
    check_field_offset(lv, v1, 0, "BFu0s_C_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_C_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_F, BFu0s_C_F)
//============================================================================


struct  BFu0s_C_I  {
  unsigned short  :0;
  char v1;
  int v2;
};
//SIG(1 BFu0s_C_I) C1{ Fs:0 Fc Fi}



static void Test_BFu0s_C_I()
{
  {
    init_simple_test("BFu0s_C_I");
    static STRUCT_IF_C BFu0s_C_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_C_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_C_I)");
    check_field_offset(lv, v1, 0, "BFu0s_C_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_C_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_I, BFu0s_C_I)
//============================================================================


struct  BFu0s_C_Ip  {
  unsigned short  :0;
  char v1;
  int *v2;
};
//SIG(1 BFu0s_C_Ip) C1{ Fs:0 Fc Fp}



static void Test_BFu0s_C_Ip()
{
  {
    init_simple_test("BFu0s_C_Ip");
    static STRUCT_IF_C BFu0s_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_C_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Ip, BFu0s_C_Ip)
//============================================================================


struct  BFu0s_C_L  {
  unsigned short  :0;
  char v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_C_L) C1{ Fs:0 Fc FL}



static void Test_BFu0s_C_L()
{
  {
    init_simple_test("BFu0s_C_L");
    static STRUCT_IF_C BFu0s_C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_L)");
    check_field_offset(lv, v1, 0, "BFu0s_C_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_C_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_L, BFu0s_C_L)
//============================================================================


struct  BFu0s_C_S  {
  unsigned short  :0;
  char v1;
  short v2;
};
//SIG(1 BFu0s_C_S) C1{ Fs:0 Fc Fs}



static void Test_BFu0s_C_S()
{
  {
    init_simple_test("BFu0s_C_S");
    static STRUCT_IF_C BFu0s_C_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_C_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_C_S)");
    check_field_offset(lv, v1, 0, "BFu0s_C_S.v1");
    check_field_offset(lv, v2, 2, "BFu0s_C_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_S, BFu0s_C_S)
//============================================================================


struct  BFu0s_C_Uc  {
  unsigned short  :0;
  char v1;
  unsigned char v2;
};
//SIG(1 BFu0s_C_Uc) C1{ Fs:0 Fc[2]}



static void Test_BFu0s_C_Uc()
{
  {
    init_simple_test("BFu0s_C_Uc");
    static STRUCT_IF_C BFu0s_C_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_C_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_C_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Uc.v1");
    check_field_offset(lv, v2, 1, "BFu0s_C_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Uc, BFu0s_C_Uc)
//============================================================================


struct  BFu0s_C_Ui  {
  unsigned short  :0;
  char v1;
  unsigned int v2;
};
//SIG(1 BFu0s_C_Ui) C1{ Fs:0 Fc Fi}



static void Test_BFu0s_C_Ui()
{
  {
    init_simple_test("BFu0s_C_Ui");
    static STRUCT_IF_C BFu0s_C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_C_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_C_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Ui, BFu0s_C_Ui)
//============================================================================


struct  BFu0s_C_Ul  {
  unsigned short  :0;
  char v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_C_Ul) C1{ Fs:0 Fc FL}



static void Test_BFu0s_C_Ul()
{
  {
    init_simple_test("BFu0s_C_Ul");
    static STRUCT_IF_C BFu0s_C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_C_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Ul, BFu0s_C_Ul)
//============================================================================


struct  BFu0s_C_Us  {
  unsigned short  :0;
  char v1;
  unsigned short v2;
};
//SIG(1 BFu0s_C_Us) C1{ Fs:0 Fc Fs}



static void Test_BFu0s_C_Us()
{
  {
    init_simple_test("BFu0s_C_Us");
    static STRUCT_IF_C BFu0s_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_C_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_C_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0s_C_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Us, BFu0s_C_Us)
//============================================================================


struct  BFu0s_C_Vp  {
  unsigned short  :0;
  char v1;
  void *v2;
};
//SIG(1 BFu0s_C_Vp) C1{ Fs:0 Fc Fp}



static void Test_BFu0s_C_Vp()
{
  {
    init_simple_test("BFu0s_C_Vp");
    static STRUCT_IF_C BFu0s_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_C_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_C_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_C_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_C_Vp, BFu0s_C_Vp)
//============================================================================


struct  BFu0s_D  {
  unsigned short  :0;
  double v1;
};
//SIG(1 BFu0s_D) C1{ Fs:0 FL}



static void Test_BFu0s_D()
{
  {
    init_simple_test("BFu0s_D");
    static STRUCT_IF_C BFu0s_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D)");
    check_field_offset(lv, v1, 0, "BFu0s_D.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D, BFu0s_D)
//============================================================================


struct  BFu0s_D_BFu0c  {
  unsigned short  :0;
  double v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_D_BFu0c) C1{ Fs:0 FL Fc:0}



static void Test_BFu0s_D_BFu0c()
{
  {
    init_simple_test("BFu0s_D_BFu0c");
    static STRUCT_IF_C BFu0s_D_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu0c, BFu0s_D_BFu0c)
//============================================================================


struct  BFu0s_D_BFu0i  {
  unsigned short  :0;
  double v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_D_BFu0i) C1{ Fs:0 FL Fi:0}



static void Test_BFu0s_D_BFu0i()
{
  {
    init_simple_test("BFu0s_D_BFu0i");
    static STRUCT_IF_C BFu0s_D_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu0i, BFu0s_D_BFu0i)
//============================================================================


struct  BFu0s_D_BFu0ll  {
  unsigned short  :0;
  double v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_D_BFu0ll) C1{ Fs:0 FL FL:0}



static void Test_BFu0s_D_BFu0ll()
{
  {
    init_simple_test("BFu0s_D_BFu0ll");
    static STRUCT_IF_C BFu0s_D_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu0ll, BFu0s_D_BFu0ll)
//============================================================================


struct  BFu0s_D_BFu0s  {
  unsigned short  :0;
  double v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_D_BFu0s) C1{ Fs:0 FL Fs:0}



static void Test_BFu0s_D_BFu0s()
{
  {
    init_simple_test("BFu0s_D_BFu0s");
    static STRUCT_IF_C BFu0s_D_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu0s, BFu0s_D_BFu0s)
//============================================================================


struct  BFu0s_D_BFu15i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_D_BFu15i) C1{ Fs:0 FL Fi:15}



static void Test_BFu0s_D_BFu15i()
{
  {
    init_simple_test("BFu0s_D_BFu15i");
    static STRUCT_IF_C BFu0s_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_D_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu15i, BFu0s_D_BFu15i)
//============================================================================


struct  BFu0s_D_BFu15ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_D_BFu15ll) C1{ Fs:0 FL FL:15}



static void Test_BFu0s_D_BFu15ll()
{
  {
    init_simple_test("BFu0s_D_BFu15ll");
    static STRUCT_IF_C BFu0s_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_D_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu15ll, BFu0s_D_BFu15ll)
//============================================================================


struct  BFu0s_D_BFu15s  {
  unsigned short  :0;
  double v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_D_BFu15s) C1{ Fs:0 FL Fs:15}



static void Test_BFu0s_D_BFu15s()
{
  {
    init_simple_test("BFu0s_D_BFu15s");
    static STRUCT_IF_C BFu0s_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_D_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu15s, BFu0s_D_BFu15s)
//============================================================================


struct  BFu0s_D_BFu16i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_D_BFu16i) C1{ Fs:0 FL Fi:16}



static void Test_BFu0s_D_BFu16i()
{
  {
    init_simple_test("BFu0s_D_BFu16i");
    static STRUCT_IF_C BFu0s_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_D_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu16i, BFu0s_D_BFu16i)
//============================================================================


struct  BFu0s_D_BFu16ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_D_BFu16ll) C1{ Fs:0 FL FL:16}



static void Test_BFu0s_D_BFu16ll()
{
  {
    init_simple_test("BFu0s_D_BFu16ll");
    static STRUCT_IF_C BFu0s_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_D_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu16ll, BFu0s_D_BFu16ll)
//============================================================================


struct  BFu0s_D_BFu16s  {
  unsigned short  :0;
  double v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_D_BFu16s) C1{ Fs:0 FL Fs:16}



static void Test_BFu0s_D_BFu16s()
{
  {
    init_simple_test("BFu0s_D_BFu16s");
    static STRUCT_IF_C BFu0s_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_D_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu16s, BFu0s_D_BFu16s)
//============================================================================


struct  BFu0s_D_BFu17i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_D_BFu17i) C1{ Fs:0 FL Fi:17}



static void Test_BFu0s_D_BFu17i()
{
  {
    init_simple_test("BFu0s_D_BFu17i");
    static STRUCT_IF_C BFu0s_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0s_D_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0s_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu17i, BFu0s_D_BFu17i)
//============================================================================


struct  BFu0s_D_BFu17ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_D_BFu17ll) C1{ Fs:0 FL FL:17}



static void Test_BFu0s_D_BFu17ll()
{
  {
    init_simple_test("BFu0s_D_BFu17ll");
    static STRUCT_IF_C BFu0s_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0s_D_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0s_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu17ll, BFu0s_D_BFu17ll)
//============================================================================


struct  BFu0s_D_BFu1c  {
  unsigned short  :0;
  double v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_D_BFu1c) C1{ Fs:0 FL Fc:1}



static void Test_BFu0s_D_BFu1c()
{
  {
    init_simple_test("BFu0s_D_BFu1c");
    static STRUCT_IF_C BFu0s_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu1c, BFu0s_D_BFu1c)
//============================================================================


struct  BFu0s_D_BFu1i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_D_BFu1i) C1{ Fs:0 FL Fi:1}



static void Test_BFu0s_D_BFu1i()
{
  {
    init_simple_test("BFu0s_D_BFu1i");
    static STRUCT_IF_C BFu0s_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu1i, BFu0s_D_BFu1i)
//============================================================================


struct  BFu0s_D_BFu1ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_D_BFu1ll) C1{ Fs:0 FL FL:1}



static void Test_BFu0s_D_BFu1ll()
{
  {
    init_simple_test("BFu0s_D_BFu1ll");
    static STRUCT_IF_C BFu0s_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu1ll, BFu0s_D_BFu1ll)
//============================================================================


struct  BFu0s_D_BFu1s  {
  unsigned short  :0;
  double v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_D_BFu1s) C1{ Fs:0 FL Fs:1}



static void Test_BFu0s_D_BFu1s()
{
  {
    init_simple_test("BFu0s_D_BFu1s");
    static STRUCT_IF_C BFu0s_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu1s, BFu0s_D_BFu1s)
//============================================================================


struct  BFu0s_D_BFu31i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_D_BFu31i) C1{ Fs:0 FL Fi:31}



static void Test_BFu0s_D_BFu31i()
{
  {
    init_simple_test("BFu0s_D_BFu31i");
    static STRUCT_IF_C BFu0s_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0s_D_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0s_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu31i, BFu0s_D_BFu31i)
//============================================================================


struct  BFu0s_D_BFu31ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_D_BFu31ll) C1{ Fs:0 FL FL:31}



static void Test_BFu0s_D_BFu31ll()
{
  {
    init_simple_test("BFu0s_D_BFu31ll");
    static STRUCT_IF_C BFu0s_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0s_D_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0s_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu31ll, BFu0s_D_BFu31ll)
//============================================================================


struct  BFu0s_D_BFu32i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_D_BFu32i) C1{ Fs:0 FL Fi:32}



static void Test_BFu0s_D_BFu32i()
{
  {
    init_simple_test("BFu0s_D_BFu32i");
    static STRUCT_IF_C BFu0s_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0s_D_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0s_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu32i, BFu0s_D_BFu32i)
//============================================================================


struct  BFu0s_D_BFu32ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_D_BFu32ll) C1{ Fs:0 FL FL:32}



static void Test_BFu0s_D_BFu32ll()
{
  {
    init_simple_test("BFu0s_D_BFu32ll");
    static STRUCT_IF_C BFu0s_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0s_D_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0s_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu32ll, BFu0s_D_BFu32ll)
//============================================================================


struct  BFu0s_D_BFu33  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_D_BFu33) C1{ Fs:0 FL FL:33}



static void Test_BFu0s_D_BFu33()
{
  {
    init_simple_test("BFu0s_D_BFu33");
    static STRUCT_IF_C BFu0s_D_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0s_D_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0s_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu33, BFu0s_D_BFu33)
//============================================================================


struct  BFu0s_D_BFu7c  {
  unsigned short  :0;
  double v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_D_BFu7c) C1{ Fs:0 FL Fc:7}



static void Test_BFu0s_D_BFu7c()
{
  {
    init_simple_test("BFu0s_D_BFu7c");
    static STRUCT_IF_C BFu0s_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_D_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu7c, BFu0s_D_BFu7c)
//============================================================================


struct  BFu0s_D_BFu7i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_D_BFu7i) C1{ Fs:0 FL Fi:7}



static void Test_BFu0s_D_BFu7i()
{
  {
    init_simple_test("BFu0s_D_BFu7i");
    static STRUCT_IF_C BFu0s_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_D_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu7i, BFu0s_D_BFu7i)
//============================================================================


struct  BFu0s_D_BFu7ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_D_BFu7ll) C1{ Fs:0 FL FL:7}



static void Test_BFu0s_D_BFu7ll()
{
  {
    init_simple_test("BFu0s_D_BFu7ll");
    static STRUCT_IF_C BFu0s_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_D_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu7ll, BFu0s_D_BFu7ll)
//============================================================================


struct  BFu0s_D_BFu7s  {
  unsigned short  :0;
  double v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_D_BFu7s) C1{ Fs:0 FL Fs:7}



static void Test_BFu0s_D_BFu7s()
{
  {
    init_simple_test("BFu0s_D_BFu7s");
    static STRUCT_IF_C BFu0s_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_D_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu7s, BFu0s_D_BFu7s)
//============================================================================


struct  BFu0s_D_BFu8c  {
  unsigned short  :0;
  double v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_D_BFu8c) C1{ Fs:0 FL Fc:8}



static void Test_BFu0s_D_BFu8c()
{
  {
    init_simple_test("BFu0s_D_BFu8c");
    static STRUCT_IF_C BFu0s_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_D_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu8c, BFu0s_D_BFu8c)
//============================================================================


struct  BFu0s_D_BFu8i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_D_BFu8i) C1{ Fs:0 FL Fi:8}



static void Test_BFu0s_D_BFu8i()
{
  {
    init_simple_test("BFu0s_D_BFu8i");
    static STRUCT_IF_C BFu0s_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_D_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu8i, BFu0s_D_BFu8i)
//============================================================================


struct  BFu0s_D_BFu8ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_D_BFu8ll) C1{ Fs:0 FL FL:8}



static void Test_BFu0s_D_BFu8ll()
{
  {
    init_simple_test("BFu0s_D_BFu8ll");
    static STRUCT_IF_C BFu0s_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_D_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu8ll, BFu0s_D_BFu8ll)
//============================================================================


struct  BFu0s_D_BFu8s  {
  unsigned short  :0;
  double v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_D_BFu8s) C1{ Fs:0 FL Fs:8}



static void Test_BFu0s_D_BFu8s()
{
  {
    init_simple_test("BFu0s_D_BFu8s");
    static STRUCT_IF_C BFu0s_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_D_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu8s, BFu0s_D_BFu8s)
//============================================================================


struct  BFu0s_D_BFu9i  {
  unsigned short  :0;
  double v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_D_BFu9i) C1{ Fs:0 FL Fi:9}



static void Test_BFu0s_D_BFu9i()
{
  {
    init_simple_test("BFu0s_D_BFu9i");
    static STRUCT_IF_C BFu0s_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_D_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu9i, BFu0s_D_BFu9i)
//============================================================================


struct  BFu0s_D_BFu9ll  {
  unsigned short  :0;
  double v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_D_BFu9ll) C1{ Fs:0 FL FL:9}



static void Test_BFu0s_D_BFu9ll()
{
  {
    init_simple_test("BFu0s_D_BFu9ll");
    static STRUCT_IF_C BFu0s_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_D_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu9ll, BFu0s_D_BFu9ll)
//============================================================================


struct  BFu0s_D_BFu9s  {
  unsigned short  :0;
  double v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_D_BFu9s) C1{ Fs:0 FL Fs:9}



static void Test_BFu0s_D_BFu9s()
{
  {
    init_simple_test("BFu0s_D_BFu9s");
    static STRUCT_IF_C BFu0s_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_D_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_D_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_BFu9s, BFu0s_D_BFu9s)
//============================================================================


struct  BFu0s_D_C  {
  unsigned short  :0;
  double v1;
  char v2;
};
//SIG(1 BFu0s_D_C) C1{ Fs:0 FL Fc}



static void Test_BFu0s_D_C()
{
  {
    init_simple_test("BFu0s_D_C");
    static STRUCT_IF_C BFu0s_D_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_C)");
    check_field_offset(lv, v1, 0, "BFu0s_D_C.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_C, BFu0s_D_C)
//============================================================================


struct  BFu0s_D_D  {
  unsigned short  :0;
  double v1;
  double v2;
};
//SIG(1 BFu0s_D_D) C1{ Fs:0 FL[2]}



static void Test_BFu0s_D_D()
{
  {
    init_simple_test("BFu0s_D_D");
    static STRUCT_IF_C BFu0s_D_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_D)");
    check_field_offset(lv, v1, 0, "BFu0s_D_D.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_D, BFu0s_D_D)
//============================================================================


struct  BFu0s_D_F  {
  unsigned short  :0;
  double v1;
  float v2;
};
//SIG(1 BFu0s_D_F) C1{ Fs:0 FL Fi}



static void Test_BFu0s_D_F()
{
  {
    init_simple_test("BFu0s_D_F");
    static STRUCT_IF_C BFu0s_D_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_F)");
    check_field_offset(lv, v1, 0, "BFu0s_D_F.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_F, BFu0s_D_F)
//============================================================================


struct  BFu0s_D_I  {
  unsigned short  :0;
  double v1;
  int v2;
};
//SIG(1 BFu0s_D_I) C1{ Fs:0 FL Fi}



static void Test_BFu0s_D_I()
{
  {
    init_simple_test("BFu0s_D_I");
    static STRUCT_IF_C BFu0s_D_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_I)");
    check_field_offset(lv, v1, 0, "BFu0s_D_I.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_I, BFu0s_D_I)
//============================================================================


struct  BFu0s_D_Ip  {
  unsigned short  :0;
  double v1;
  int *v2;
};
//SIG(1 BFu0s_D_Ip) C1{ Fs:0 FL Fp}



static void Test_BFu0s_D_Ip()
{
  {
    init_simple_test("BFu0s_D_Ip");
    static STRUCT_IF_C BFu0s_D_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Ip, BFu0s_D_Ip)
//============================================================================


struct  BFu0s_D_L  {
  unsigned short  :0;
  double v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_D_L) C1{ Fs:0 FL[2]}



static void Test_BFu0s_D_L()
{
  {
    init_simple_test("BFu0s_D_L");
    static STRUCT_IF_C BFu0s_D_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_L)");
    check_field_offset(lv, v1, 0, "BFu0s_D_L.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_L, BFu0s_D_L)
//============================================================================


struct  BFu0s_D_S  {
  unsigned short  :0;
  double v1;
  short v2;
};
//SIG(1 BFu0s_D_S) C1{ Fs:0 FL Fs}



static void Test_BFu0s_D_S()
{
  {
    init_simple_test("BFu0s_D_S");
    static STRUCT_IF_C BFu0s_D_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_S)");
    check_field_offset(lv, v1, 0, "BFu0s_D_S.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_S, BFu0s_D_S)
//============================================================================


struct  BFu0s_D_Uc  {
  unsigned short  :0;
  double v1;
  unsigned char v2;
};
//SIG(1 BFu0s_D_Uc) C1{ Fs:0 FL Fc}



static void Test_BFu0s_D_Uc()
{
  {
    init_simple_test("BFu0s_D_Uc");
    static STRUCT_IF_C BFu0s_D_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Uc, BFu0s_D_Uc)
//============================================================================


struct  BFu0s_D_Ui  {
  unsigned short  :0;
  double v1;
  unsigned int v2;
};
//SIG(1 BFu0s_D_Ui) C1{ Fs:0 FL Fi}



static void Test_BFu0s_D_Ui()
{
  {
    init_simple_test("BFu0s_D_Ui");
    static STRUCT_IF_C BFu0s_D_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Ui, BFu0s_D_Ui)
//============================================================================


struct  BFu0s_D_Ul  {
  unsigned short  :0;
  double v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_D_Ul) C1{ Fs:0 FL[2]}



static void Test_BFu0s_D_Ul()
{
  {
    init_simple_test("BFu0s_D_Ul");
    static STRUCT_IF_C BFu0s_D_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Ul, BFu0s_D_Ul)
//============================================================================


struct  BFu0s_D_Us  {
  unsigned short  :0;
  double v1;
  unsigned short v2;
};
//SIG(1 BFu0s_D_Us) C1{ Fs:0 FL Fs}



static void Test_BFu0s_D_Us()
{
  {
    init_simple_test("BFu0s_D_Us");
    static STRUCT_IF_C BFu0s_D_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Us, BFu0s_D_Us)
//============================================================================


struct  BFu0s_D_Vp  {
  unsigned short  :0;
  double v1;
  void *v2;
};
//SIG(1 BFu0s_D_Vp) C1{ Fs:0 FL Fp}



static void Test_BFu0s_D_Vp()
{
  {
    init_simple_test("BFu0s_D_Vp");
    static STRUCT_IF_C BFu0s_D_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_D_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_D_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0s_D_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_D_Vp, BFu0s_D_Vp)
//============================================================================


struct  BFu0s_F  {
  unsigned short  :0;
  float v1;
};
//SIG(1 BFu0s_F) C1{ Fs:0 Fi}



static void Test_BFu0s_F()
{
  {
    init_simple_test("BFu0s_F");
    static STRUCT_IF_C BFu0s_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F)");
    check_field_offset(lv, v1, 0, "BFu0s_F.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F, BFu0s_F)
//============================================================================


struct  BFu0s_F_BFu0c  {
  unsigned short  :0;
  float v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_F_BFu0c) C1{ Fs:0 Fi Fc:0}



static void Test_BFu0s_F_BFu0c()
{
  {
    init_simple_test("BFu0s_F_BFu0c");
    static STRUCT_IF_C BFu0s_F_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu0c, BFu0s_F_BFu0c)
//============================================================================


struct  BFu0s_F_BFu0i  {
  unsigned short  :0;
  float v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_F_BFu0i) C1{ Fs:0 Fi Fi:0}



static void Test_BFu0s_F_BFu0i()
{
  {
    init_simple_test("BFu0s_F_BFu0i");
    static STRUCT_IF_C BFu0s_F_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu0i, BFu0s_F_BFu0i)
//============================================================================


struct  BFu0s_F_BFu0ll  {
  unsigned short  :0;
  float v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_F_BFu0ll) C1{ Fs:0 Fi FL:0}



static void Test_BFu0s_F_BFu0ll()
{
  {
    init_simple_test("BFu0s_F_BFu0ll");
    static STRUCT_IF_C BFu0s_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0s_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu0ll, BFu0s_F_BFu0ll)
//============================================================================


struct  BFu0s_F_BFu0s  {
  unsigned short  :0;
  float v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_F_BFu0s) C1{ Fs:0 Fi Fs:0}



static void Test_BFu0s_F_BFu0s()
{
  {
    init_simple_test("BFu0s_F_BFu0s");
    static STRUCT_IF_C BFu0s_F_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu0s, BFu0s_F_BFu0s)
//============================================================================


struct  BFu0s_F_BFu15i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_F_BFu15i) C1{ Fs:0 Fi Fi:15}



static void Test_BFu0s_F_BFu15i()
{
  {
    init_simple_test("BFu0s_F_BFu15i");
    static STRUCT_IF_C BFu0s_F_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_F_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu15i, BFu0s_F_BFu15i)
//============================================================================


struct  BFu0s_F_BFu15ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_F_BFu15ll) C1{ Fs:0 Fi FL:15}



static void Test_BFu0s_F_BFu15ll()
{
  {
    init_simple_test("BFu0s_F_BFu15ll");
    static STRUCT_IF_C BFu0s_F_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_F_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu15ll, BFu0s_F_BFu15ll)
//============================================================================


struct  BFu0s_F_BFu15s  {
  unsigned short  :0;
  float v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_F_BFu15s) C1{ Fs:0 Fi Fs:15}



static void Test_BFu0s_F_BFu15s()
{
  {
    init_simple_test("BFu0s_F_BFu15s");
    static STRUCT_IF_C BFu0s_F_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_F_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu15s, BFu0s_F_BFu15s)
//============================================================================


struct  BFu0s_F_BFu16i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_F_BFu16i) C1{ Fs:0 Fi Fi:16}



static void Test_BFu0s_F_BFu16i()
{
  {
    init_simple_test("BFu0s_F_BFu16i");
    static STRUCT_IF_C BFu0s_F_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_F_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu16i, BFu0s_F_BFu16i)
//============================================================================


struct  BFu0s_F_BFu16ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_F_BFu16ll) C1{ Fs:0 Fi FL:16}



static void Test_BFu0s_F_BFu16ll()
{
  {
    init_simple_test("BFu0s_F_BFu16ll");
    static STRUCT_IF_C BFu0s_F_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_F_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu16ll, BFu0s_F_BFu16ll)
//============================================================================


struct  BFu0s_F_BFu16s  {
  unsigned short  :0;
  float v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_F_BFu16s) C1{ Fs:0 Fi Fs:16}



static void Test_BFu0s_F_BFu16s()
{
  {
    init_simple_test("BFu0s_F_BFu16s");
    static STRUCT_IF_C BFu0s_F_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_F_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu16s, BFu0s_F_BFu16s)
//============================================================================


struct  BFu0s_F_BFu17i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_F_BFu17i) C1{ Fs:0 Fi Fi:17}



static void Test_BFu0s_F_BFu17i()
{
  {
    init_simple_test("BFu0s_F_BFu17i");
    static STRUCT_IF_C BFu0s_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_F_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu17i, BFu0s_F_BFu17i)
//============================================================================


struct  BFu0s_F_BFu17ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_F_BFu17ll) C1{ Fs:0 Fi FL:17}



static void Test_BFu0s_F_BFu17ll()
{
  {
    init_simple_test("BFu0s_F_BFu17ll");
    static STRUCT_IF_C BFu0s_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_F_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu17ll, BFu0s_F_BFu17ll)
//============================================================================


struct  BFu0s_F_BFu1c  {
  unsigned short  :0;
  float v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_F_BFu1c) C1{ Fs:0 Fi Fc:1}



static void Test_BFu0s_F_BFu1c()
{
  {
    init_simple_test("BFu0s_F_BFu1c");
    static STRUCT_IF_C BFu0s_F_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu1c, BFu0s_F_BFu1c)
//============================================================================


struct  BFu0s_F_BFu1i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_F_BFu1i) C1{ Fs:0 Fi Fi:1}



static void Test_BFu0s_F_BFu1i()
{
  {
    init_simple_test("BFu0s_F_BFu1i");
    static STRUCT_IF_C BFu0s_F_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu1i, BFu0s_F_BFu1i)
//============================================================================


struct  BFu0s_F_BFu1ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_F_BFu1ll) C1{ Fs:0 Fi FL:1}



static void Test_BFu0s_F_BFu1ll()
{
  {
    init_simple_test("BFu0s_F_BFu1ll");
    static STRUCT_IF_C BFu0s_F_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu1ll, BFu0s_F_BFu1ll)
//============================================================================


struct  BFu0s_F_BFu1s  {
  unsigned short  :0;
  float v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_F_BFu1s) C1{ Fs:0 Fi Fs:1}



static void Test_BFu0s_F_BFu1s()
{
  {
    init_simple_test("BFu0s_F_BFu1s");
    static STRUCT_IF_C BFu0s_F_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu1s, BFu0s_F_BFu1s)
//============================================================================


struct  BFu0s_F_BFu31i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_F_BFu31i) C1{ Fs:0 Fi Fi:31}



static void Test_BFu0s_F_BFu31i()
{
  {
    init_simple_test("BFu0s_F_BFu31i");
    static STRUCT_IF_C BFu0s_F_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_F_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu31i, BFu0s_F_BFu31i)
//============================================================================


struct  BFu0s_F_BFu31ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_F_BFu31ll) C1{ Fs:0 Fi FL:31}



static void Test_BFu0s_F_BFu31ll()
{
  {
    init_simple_test("BFu0s_F_BFu31ll");
    static STRUCT_IF_C BFu0s_F_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_F_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu31ll, BFu0s_F_BFu31ll)
//============================================================================


struct  BFu0s_F_BFu32i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_F_BFu32i) C1{ Fs:0 Fi Fi:32}



static void Test_BFu0s_F_BFu32i()
{
  {
    init_simple_test("BFu0s_F_BFu32i");
    static STRUCT_IF_C BFu0s_F_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_F_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu32i, BFu0s_F_BFu32i)
//============================================================================


struct  BFu0s_F_BFu32ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_F_BFu32ll) C1{ Fs:0 Fi FL:32}



static void Test_BFu0s_F_BFu32ll()
{
  {
    init_simple_test("BFu0s_F_BFu32ll");
    static STRUCT_IF_C BFu0s_F_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_F_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu32ll, BFu0s_F_BFu32ll)
//============================================================================


struct  BFu0s_F_BFu33  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_F_BFu33) C1{ Fs:0 Fi FL:33}



static void Test_BFu0s_F_BFu33()
{
  {
    init_simple_test("BFu0s_F_BFu33");
    static STRUCT_IF_C BFu0s_F_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0s_F_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0s_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu33, BFu0s_F_BFu33)
//============================================================================


struct  BFu0s_F_BFu7c  {
  unsigned short  :0;
  float v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_F_BFu7c) C1{ Fs:0 Fi Fc:7}



static void Test_BFu0s_F_BFu7c()
{
  {
    init_simple_test("BFu0s_F_BFu7c");
    static STRUCT_IF_C BFu0s_F_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_F_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu7c, BFu0s_F_BFu7c)
//============================================================================


struct  BFu0s_F_BFu7i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_F_BFu7i) C1{ Fs:0 Fi Fi:7}



static void Test_BFu0s_F_BFu7i()
{
  {
    init_simple_test("BFu0s_F_BFu7i");
    static STRUCT_IF_C BFu0s_F_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_F_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu7i, BFu0s_F_BFu7i)
//============================================================================


struct  BFu0s_F_BFu7ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_F_BFu7ll) C1{ Fs:0 Fi FL:7}



static void Test_BFu0s_F_BFu7ll()
{
  {
    init_simple_test("BFu0s_F_BFu7ll");
    static STRUCT_IF_C BFu0s_F_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_F_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu7ll, BFu0s_F_BFu7ll)
//============================================================================


struct  BFu0s_F_BFu7s  {
  unsigned short  :0;
  float v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_F_BFu7s) C1{ Fs:0 Fi Fs:7}



static void Test_BFu0s_F_BFu7s()
{
  {
    init_simple_test("BFu0s_F_BFu7s");
    static STRUCT_IF_C BFu0s_F_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_F_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu7s, BFu0s_F_BFu7s)
//============================================================================


struct  BFu0s_F_BFu8c  {
  unsigned short  :0;
  float v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_F_BFu8c) C1{ Fs:0 Fi Fc:8}



static void Test_BFu0s_F_BFu8c()
{
  {
    init_simple_test("BFu0s_F_BFu8c");
    static STRUCT_IF_C BFu0s_F_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_F_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu8c, BFu0s_F_BFu8c)
//============================================================================


struct  BFu0s_F_BFu8i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_F_BFu8i) C1{ Fs:0 Fi Fi:8}



static void Test_BFu0s_F_BFu8i()
{
  {
    init_simple_test("BFu0s_F_BFu8i");
    static STRUCT_IF_C BFu0s_F_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_F_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu8i, BFu0s_F_BFu8i)
//============================================================================


struct  BFu0s_F_BFu8ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_F_BFu8ll) C1{ Fs:0 Fi FL:8}



static void Test_BFu0s_F_BFu8ll()
{
  {
    init_simple_test("BFu0s_F_BFu8ll");
    static STRUCT_IF_C BFu0s_F_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_F_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu8ll, BFu0s_F_BFu8ll)
//============================================================================


struct  BFu0s_F_BFu8s  {
  unsigned short  :0;
  float v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_F_BFu8s) C1{ Fs:0 Fi Fs:8}



static void Test_BFu0s_F_BFu8s()
{
  {
    init_simple_test("BFu0s_F_BFu8s");
    static STRUCT_IF_C BFu0s_F_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_F_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu8s, BFu0s_F_BFu8s)
//============================================================================


struct  BFu0s_F_BFu9i  {
  unsigned short  :0;
  float v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_F_BFu9i) C1{ Fs:0 Fi Fi:9}



static void Test_BFu0s_F_BFu9i()
{
  {
    init_simple_test("BFu0s_F_BFu9i");
    static STRUCT_IF_C BFu0s_F_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_F_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu9i, BFu0s_F_BFu9i)
//============================================================================


struct  BFu0s_F_BFu9ll  {
  unsigned short  :0;
  float v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_F_BFu9ll) C1{ Fs:0 Fi FL:9}



static void Test_BFu0s_F_BFu9ll()
{
  {
    init_simple_test("BFu0s_F_BFu9ll");
    static STRUCT_IF_C BFu0s_F_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_F_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu9ll, BFu0s_F_BFu9ll)
//============================================================================


struct  BFu0s_F_BFu9s  {
  unsigned short  :0;
  float v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_F_BFu9s) C1{ Fs:0 Fi Fs:9}



static void Test_BFu0s_F_BFu9s()
{
  {
    init_simple_test("BFu0s_F_BFu9s");
    static STRUCT_IF_C BFu0s_F_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_F_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_F_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_BFu9s, BFu0s_F_BFu9s)
//============================================================================


struct  BFu0s_F_C  {
  unsigned short  :0;
  float v1;
  char v2;
};
//SIG(1 BFu0s_F_C) C1{ Fs:0 Fi Fc}



static void Test_BFu0s_F_C()
{
  {
    init_simple_test("BFu0s_F_C");
    static STRUCT_IF_C BFu0s_F_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_C)");
    check_field_offset(lv, v1, 0, "BFu0s_F_C.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_C, BFu0s_F_C)
//============================================================================


struct  BFu0s_F_D  {
  unsigned short  :0;
  float v1;
  double v2;
};
//SIG(1 BFu0s_F_D) C1{ Fs:0 Fi FL}



static void Test_BFu0s_F_D()
{
  {
    init_simple_test("BFu0s_F_D");
    static STRUCT_IF_C BFu0s_F_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_D)");
    check_field_offset(lv, v1, 0, "BFu0s_F_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_F_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_D, BFu0s_F_D)
//============================================================================


struct  BFu0s_F_F  {
  unsigned short  :0;
  float v1;
  float v2;
};
//SIG(1 BFu0s_F_F) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_F_F()
{
  {
    init_simple_test("BFu0s_F_F");
    static STRUCT_IF_C BFu0s_F_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_F)");
    check_field_offset(lv, v1, 0, "BFu0s_F_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_F, BFu0s_F_F)
//============================================================================


struct  BFu0s_F_I  {
  unsigned short  :0;
  float v1;
  int v2;
};
//SIG(1 BFu0s_F_I) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_F_I()
{
  {
    init_simple_test("BFu0s_F_I");
    static STRUCT_IF_C BFu0s_F_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_I)");
    check_field_offset(lv, v1, 0, "BFu0s_F_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_I, BFu0s_F_I)
//============================================================================


struct  BFu0s_F_Ip  {
  unsigned short  :0;
  float v1;
  int *v2;
};
//SIG(1 BFu0s_F_Ip) C1{ Fs:0 Fi Fp}



static void Test_BFu0s_F_Ip()
{
  {
    init_simple_test("BFu0s_F_Ip");
    static STRUCT_IF_C BFu0s_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_F_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Ip, BFu0s_F_Ip)
//============================================================================


struct  BFu0s_F_L  {
  unsigned short  :0;
  float v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_F_L) C1{ Fs:0 Fi FL}



static void Test_BFu0s_F_L()
{
  {
    init_simple_test("BFu0s_F_L");
    static STRUCT_IF_C BFu0s_F_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_L)");
    check_field_offset(lv, v1, 0, "BFu0s_F_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_F_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_L, BFu0s_F_L)
//============================================================================


struct  BFu0s_F_S  {
  unsigned short  :0;
  float v1;
  short v2;
};
//SIG(1 BFu0s_F_S) C1{ Fs:0 Fi Fs}



static void Test_BFu0s_F_S()
{
  {
    init_simple_test("BFu0s_F_S");
    static STRUCT_IF_C BFu0s_F_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_S)");
    check_field_offset(lv, v1, 0, "BFu0s_F_S.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_S, BFu0s_F_S)
//============================================================================


struct  BFu0s_F_Uc  {
  unsigned short  :0;
  float v1;
  unsigned char v2;
};
//SIG(1 BFu0s_F_Uc) C1{ Fs:0 Fi Fc}



static void Test_BFu0s_F_Uc()
{
  {
    init_simple_test("BFu0s_F_Uc");
    static STRUCT_IF_C BFu0s_F_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Uc, BFu0s_F_Uc)
//============================================================================


struct  BFu0s_F_Ui  {
  unsigned short  :0;
  float v1;
  unsigned int v2;
};
//SIG(1 BFu0s_F_Ui) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_F_Ui()
{
  {
    init_simple_test("BFu0s_F_Ui");
    static STRUCT_IF_C BFu0s_F_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Ui, BFu0s_F_Ui)
//============================================================================


struct  BFu0s_F_Ul  {
  unsigned short  :0;
  float v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_F_Ul) C1{ Fs:0 Fi FL}



static void Test_BFu0s_F_Ul()
{
  {
    init_simple_test("BFu0s_F_Ul");
    static STRUCT_IF_C BFu0s_F_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_F_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Ul, BFu0s_F_Ul)
//============================================================================


struct  BFu0s_F_Us  {
  unsigned short  :0;
  float v1;
  unsigned short v2;
};
//SIG(1 BFu0s_F_Us) C1{ Fs:0 Fi Fs}



static void Test_BFu0s_F_Us()
{
  {
    init_simple_test("BFu0s_F_Us");
    static STRUCT_IF_C BFu0s_F_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_F_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0s_F_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Us, BFu0s_F_Us)
//============================================================================


struct  BFu0s_F_Vp  {
  unsigned short  :0;
  float v1;
  void *v2;
};
//SIG(1 BFu0s_F_Vp) C1{ Fs:0 Fi Fp}



static void Test_BFu0s_F_Vp()
{
  {
    init_simple_test("BFu0s_F_Vp");
    static STRUCT_IF_C BFu0s_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_F_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_F_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_F_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_F_Vp, BFu0s_F_Vp)
//============================================================================


struct  BFu0s_I  {
  unsigned short  :0;
  int v1;
};
//SIG(1 BFu0s_I) C1{ Fs:0 Fi}



static void Test_BFu0s_I()
{
  {
    init_simple_test("BFu0s_I");
    static STRUCT_IF_C BFu0s_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I)");
    check_field_offset(lv, v1, 0, "BFu0s_I.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I, BFu0s_I)
//============================================================================


struct  BFu0s_I_BFu0c  {
  unsigned short  :0;
  int v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_I_BFu0c) C1{ Fs:0 Fi Fc:0}



static void Test_BFu0s_I_BFu0c()
{
  {
    init_simple_test("BFu0s_I_BFu0c");
    static STRUCT_IF_C BFu0s_I_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu0c, BFu0s_I_BFu0c)
//============================================================================


struct  BFu0s_I_BFu0i  {
  unsigned short  :0;
  int v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_I_BFu0i) C1{ Fs:0 Fi Fi:0}



static void Test_BFu0s_I_BFu0i()
{
  {
    init_simple_test("BFu0s_I_BFu0i");
    static STRUCT_IF_C BFu0s_I_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu0i, BFu0s_I_BFu0i)
//============================================================================


struct  BFu0s_I_BFu0ll  {
  unsigned short  :0;
  int v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_I_BFu0ll) C1{ Fs:0 Fi FL:0}



static void Test_BFu0s_I_BFu0ll()
{
  {
    init_simple_test("BFu0s_I_BFu0ll");
    static STRUCT_IF_C BFu0s_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0s_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu0ll, BFu0s_I_BFu0ll)
//============================================================================


struct  BFu0s_I_BFu0s  {
  unsigned short  :0;
  int v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_I_BFu0s) C1{ Fs:0 Fi Fs:0}



static void Test_BFu0s_I_BFu0s()
{
  {
    init_simple_test("BFu0s_I_BFu0s");
    static STRUCT_IF_C BFu0s_I_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu0s, BFu0s_I_BFu0s)
//============================================================================


struct  BFu0s_I_BFu15i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_I_BFu15i) C1{ Fs:0 Fi Fi:15}



static void Test_BFu0s_I_BFu15i()
{
  {
    init_simple_test("BFu0s_I_BFu15i");
    static STRUCT_IF_C BFu0s_I_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_I_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu15i, BFu0s_I_BFu15i)
//============================================================================


struct  BFu0s_I_BFu15ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_I_BFu15ll) C1{ Fs:0 Fi FL:15}



static void Test_BFu0s_I_BFu15ll()
{
  {
    init_simple_test("BFu0s_I_BFu15ll");
    static STRUCT_IF_C BFu0s_I_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_I_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu15ll, BFu0s_I_BFu15ll)
//============================================================================


struct  BFu0s_I_BFu15s  {
  unsigned short  :0;
  int v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_I_BFu15s) C1{ Fs:0 Fi Fs:15}



static void Test_BFu0s_I_BFu15s()
{
  {
    init_simple_test("BFu0s_I_BFu15s");
    static STRUCT_IF_C BFu0s_I_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_I_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu15s, BFu0s_I_BFu15s)
//============================================================================


struct  BFu0s_I_BFu16i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_I_BFu16i) C1{ Fs:0 Fi Fi:16}



static void Test_BFu0s_I_BFu16i()
{
  {
    init_simple_test("BFu0s_I_BFu16i");
    static STRUCT_IF_C BFu0s_I_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_I_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu16i, BFu0s_I_BFu16i)
//============================================================================


struct  BFu0s_I_BFu16ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_I_BFu16ll) C1{ Fs:0 Fi FL:16}



static void Test_BFu0s_I_BFu16ll()
{
  {
    init_simple_test("BFu0s_I_BFu16ll");
    static STRUCT_IF_C BFu0s_I_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_I_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu16ll, BFu0s_I_BFu16ll)
//============================================================================


struct  BFu0s_I_BFu16s  {
  unsigned short  :0;
  int v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_I_BFu16s) C1{ Fs:0 Fi Fs:16}



static void Test_BFu0s_I_BFu16s()
{
  {
    init_simple_test("BFu0s_I_BFu16s");
    static STRUCT_IF_C BFu0s_I_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_I_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu16s, BFu0s_I_BFu16s)
//============================================================================


struct  BFu0s_I_BFu17i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_I_BFu17i) C1{ Fs:0 Fi Fi:17}



static void Test_BFu0s_I_BFu17i()
{
  {
    init_simple_test("BFu0s_I_BFu17i");
    static STRUCT_IF_C BFu0s_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_I_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu17i, BFu0s_I_BFu17i)
//============================================================================


struct  BFu0s_I_BFu17ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_I_BFu17ll) C1{ Fs:0 Fi FL:17}



static void Test_BFu0s_I_BFu17ll()
{
  {
    init_simple_test("BFu0s_I_BFu17ll");
    static STRUCT_IF_C BFu0s_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_I_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu17ll, BFu0s_I_BFu17ll)
//============================================================================


struct  BFu0s_I_BFu1c  {
  unsigned short  :0;
  int v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_I_BFu1c) C1{ Fs:0 Fi Fc:1}



static void Test_BFu0s_I_BFu1c()
{
  {
    init_simple_test("BFu0s_I_BFu1c");
    static STRUCT_IF_C BFu0s_I_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu1c, BFu0s_I_BFu1c)
//============================================================================


struct  BFu0s_I_BFu1i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_I_BFu1i) C1{ Fs:0 Fi Fi:1}



static void Test_BFu0s_I_BFu1i()
{
  {
    init_simple_test("BFu0s_I_BFu1i");
    static STRUCT_IF_C BFu0s_I_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu1i, BFu0s_I_BFu1i)
//============================================================================


struct  BFu0s_I_BFu1ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_I_BFu1ll) C1{ Fs:0 Fi FL:1}



static void Test_BFu0s_I_BFu1ll()
{
  {
    init_simple_test("BFu0s_I_BFu1ll");
    static STRUCT_IF_C BFu0s_I_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu1ll, BFu0s_I_BFu1ll)
//============================================================================


struct  BFu0s_I_BFu1s  {
  unsigned short  :0;
  int v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_I_BFu1s) C1{ Fs:0 Fi Fs:1}



static void Test_BFu0s_I_BFu1s()
{
  {
    init_simple_test("BFu0s_I_BFu1s");
    static STRUCT_IF_C BFu0s_I_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu1s, BFu0s_I_BFu1s)
//============================================================================


struct  BFu0s_I_BFu31i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_I_BFu31i) C1{ Fs:0 Fi Fi:31}



static void Test_BFu0s_I_BFu31i()
{
  {
    init_simple_test("BFu0s_I_BFu31i");
    static STRUCT_IF_C BFu0s_I_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_I_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu31i, BFu0s_I_BFu31i)
//============================================================================


struct  BFu0s_I_BFu31ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_I_BFu31ll) C1{ Fs:0 Fi FL:31}



static void Test_BFu0s_I_BFu31ll()
{
  {
    init_simple_test("BFu0s_I_BFu31ll");
    static STRUCT_IF_C BFu0s_I_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_I_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu31ll, BFu0s_I_BFu31ll)
//============================================================================


struct  BFu0s_I_BFu32i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_I_BFu32i) C1{ Fs:0 Fi Fi:32}



static void Test_BFu0s_I_BFu32i()
{
  {
    init_simple_test("BFu0s_I_BFu32i");
    static STRUCT_IF_C BFu0s_I_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_I_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu32i, BFu0s_I_BFu32i)
//============================================================================


struct  BFu0s_I_BFu32ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_I_BFu32ll) C1{ Fs:0 Fi FL:32}



static void Test_BFu0s_I_BFu32ll()
{
  {
    init_simple_test("BFu0s_I_BFu32ll");
    static STRUCT_IF_C BFu0s_I_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_I_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu32ll, BFu0s_I_BFu32ll)
//============================================================================


struct  BFu0s_I_BFu33  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_I_BFu33) C1{ Fs:0 Fi FL:33}



static void Test_BFu0s_I_BFu33()
{
  {
    init_simple_test("BFu0s_I_BFu33");
    static STRUCT_IF_C BFu0s_I_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0s_I_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0s_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu33, BFu0s_I_BFu33)
//============================================================================


struct  BFu0s_I_BFu7c  {
  unsigned short  :0;
  int v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_I_BFu7c) C1{ Fs:0 Fi Fc:7}



static void Test_BFu0s_I_BFu7c()
{
  {
    init_simple_test("BFu0s_I_BFu7c");
    static STRUCT_IF_C BFu0s_I_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_I_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu7c, BFu0s_I_BFu7c)
//============================================================================


struct  BFu0s_I_BFu7i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_I_BFu7i) C1{ Fs:0 Fi Fi:7}



static void Test_BFu0s_I_BFu7i()
{
  {
    init_simple_test("BFu0s_I_BFu7i");
    static STRUCT_IF_C BFu0s_I_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_I_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu7i, BFu0s_I_BFu7i)
//============================================================================


struct  BFu0s_I_BFu7ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_I_BFu7ll) C1{ Fs:0 Fi FL:7}



static void Test_BFu0s_I_BFu7ll()
{
  {
    init_simple_test("BFu0s_I_BFu7ll");
    static STRUCT_IF_C BFu0s_I_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_I_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu7ll, BFu0s_I_BFu7ll)
//============================================================================


struct  BFu0s_I_BFu7s  {
  unsigned short  :0;
  int v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_I_BFu7s) C1{ Fs:0 Fi Fs:7}



static void Test_BFu0s_I_BFu7s()
{
  {
    init_simple_test("BFu0s_I_BFu7s");
    static STRUCT_IF_C BFu0s_I_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_I_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu7s, BFu0s_I_BFu7s)
//============================================================================


struct  BFu0s_I_BFu8c  {
  unsigned short  :0;
  int v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_I_BFu8c) C1{ Fs:0 Fi Fc:8}



static void Test_BFu0s_I_BFu8c()
{
  {
    init_simple_test("BFu0s_I_BFu8c");
    static STRUCT_IF_C BFu0s_I_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_I_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu8c, BFu0s_I_BFu8c)
//============================================================================


struct  BFu0s_I_BFu8i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_I_BFu8i) C1{ Fs:0 Fi Fi:8}



static void Test_BFu0s_I_BFu8i()
{
  {
    init_simple_test("BFu0s_I_BFu8i");
    static STRUCT_IF_C BFu0s_I_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_I_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu8i, BFu0s_I_BFu8i)
//============================================================================


struct  BFu0s_I_BFu8ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_I_BFu8ll) C1{ Fs:0 Fi FL:8}



static void Test_BFu0s_I_BFu8ll()
{
  {
    init_simple_test("BFu0s_I_BFu8ll");
    static STRUCT_IF_C BFu0s_I_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_I_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu8ll, BFu0s_I_BFu8ll)
//============================================================================


struct  BFu0s_I_BFu8s  {
  unsigned short  :0;
  int v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_I_BFu8s) C1{ Fs:0 Fi Fs:8}



static void Test_BFu0s_I_BFu8s()
{
  {
    init_simple_test("BFu0s_I_BFu8s");
    static STRUCT_IF_C BFu0s_I_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_I_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu8s, BFu0s_I_BFu8s)
//============================================================================


struct  BFu0s_I_BFu9i  {
  unsigned short  :0;
  int v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_I_BFu9i) C1{ Fs:0 Fi Fi:9}



static void Test_BFu0s_I_BFu9i()
{
  {
    init_simple_test("BFu0s_I_BFu9i");
    static STRUCT_IF_C BFu0s_I_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_I_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu9i, BFu0s_I_BFu9i)
//============================================================================


struct  BFu0s_I_BFu9ll  {
  unsigned short  :0;
  int v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_I_BFu9ll) C1{ Fs:0 Fi FL:9}



static void Test_BFu0s_I_BFu9ll()
{
  {
    init_simple_test("BFu0s_I_BFu9ll");
    static STRUCT_IF_C BFu0s_I_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_I_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu9ll, BFu0s_I_BFu9ll)
//============================================================================


struct  BFu0s_I_BFu9s  {
  unsigned short  :0;
  int v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_I_BFu9s) C1{ Fs:0 Fi Fs:9}



static void Test_BFu0s_I_BFu9s()
{
  {
    init_simple_test("BFu0s_I_BFu9s");
    static STRUCT_IF_C BFu0s_I_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_I_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_I_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_BFu9s, BFu0s_I_BFu9s)
//============================================================================


struct  BFu0s_I_C  {
  unsigned short  :0;
  int v1;
  char v2;
};
//SIG(1 BFu0s_I_C) C1{ Fs:0 Fi Fc}



static void Test_BFu0s_I_C()
{
  {
    init_simple_test("BFu0s_I_C");
    static STRUCT_IF_C BFu0s_I_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_C)");
    check_field_offset(lv, v1, 0, "BFu0s_I_C.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_C, BFu0s_I_C)
//============================================================================


struct  BFu0s_I_D  {
  unsigned short  :0;
  int v1;
  double v2;
};
//SIG(1 BFu0s_I_D) C1{ Fs:0 Fi FL}



static void Test_BFu0s_I_D()
{
  {
    init_simple_test("BFu0s_I_D");
    static STRUCT_IF_C BFu0s_I_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_D)");
    check_field_offset(lv, v1, 0, "BFu0s_I_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_I_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_D, BFu0s_I_D)
//============================================================================


struct  BFu0s_I_F  {
  unsigned short  :0;
  int v1;
  float v2;
};
//SIG(1 BFu0s_I_F) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_I_F()
{
  {
    init_simple_test("BFu0s_I_F");
    static STRUCT_IF_C BFu0s_I_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_F)");
    check_field_offset(lv, v1, 0, "BFu0s_I_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_F, BFu0s_I_F)
//============================================================================


struct  BFu0s_I_I  {
  unsigned short  :0;
  int v1;
  int v2;
};
//SIG(1 BFu0s_I_I) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_I_I()
{
  {
    init_simple_test("BFu0s_I_I");
    static STRUCT_IF_C BFu0s_I_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_I)");
    check_field_offset(lv, v1, 0, "BFu0s_I_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_I, BFu0s_I_I)
//============================================================================


struct  BFu0s_I_Ip  {
  unsigned short  :0;
  int v1;
  int *v2;
};
//SIG(1 BFu0s_I_Ip) C1{ Fs:0 Fi Fp}



static void Test_BFu0s_I_Ip()
{
  {
    init_simple_test("BFu0s_I_Ip");
    static STRUCT_IF_C BFu0s_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_I_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Ip, BFu0s_I_Ip)
//============================================================================


struct  BFu0s_I_L  {
  unsigned short  :0;
  int v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_I_L) C1{ Fs:0 Fi FL}



static void Test_BFu0s_I_L()
{
  {
    init_simple_test("BFu0s_I_L");
    static STRUCT_IF_C BFu0s_I_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_L)");
    check_field_offset(lv, v1, 0, "BFu0s_I_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_I_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_L, BFu0s_I_L)
//============================================================================


struct  BFu0s_I_S  {
  unsigned short  :0;
  int v1;
  short v2;
};
//SIG(1 BFu0s_I_S) C1{ Fs:0 Fi Fs}



static void Test_BFu0s_I_S()
{
  {
    init_simple_test("BFu0s_I_S");
    static STRUCT_IF_C BFu0s_I_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_S)");
    check_field_offset(lv, v1, 0, "BFu0s_I_S.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_S, BFu0s_I_S)
//============================================================================


struct  BFu0s_I_Uc  {
  unsigned short  :0;
  int v1;
  unsigned char v2;
};
//SIG(1 BFu0s_I_Uc) C1{ Fs:0 Fi Fc}



static void Test_BFu0s_I_Uc()
{
  {
    init_simple_test("BFu0s_I_Uc");
    static STRUCT_IF_C BFu0s_I_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Uc, BFu0s_I_Uc)
//============================================================================


struct  BFu0s_I_Ui  {
  unsigned short  :0;
  int v1;
  unsigned int v2;
};
//SIG(1 BFu0s_I_Ui) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_I_Ui()
{
  {
    init_simple_test("BFu0s_I_Ui");
    static STRUCT_IF_C BFu0s_I_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Ui, BFu0s_I_Ui)
//============================================================================


struct  BFu0s_I_Ul  {
  unsigned short  :0;
  int v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_I_Ul) C1{ Fs:0 Fi FL}



static void Test_BFu0s_I_Ul()
{
  {
    init_simple_test("BFu0s_I_Ul");
    static STRUCT_IF_C BFu0s_I_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_I_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Ul, BFu0s_I_Ul)
//============================================================================


struct  BFu0s_I_Us  {
  unsigned short  :0;
  int v1;
  unsigned short v2;
};
//SIG(1 BFu0s_I_Us) C1{ Fs:0 Fi Fs}



static void Test_BFu0s_I_Us()
{
  {
    init_simple_test("BFu0s_I_Us");
    static STRUCT_IF_C BFu0s_I_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_I_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_I_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0s_I_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Us, BFu0s_I_Us)
//============================================================================


struct  BFu0s_I_Vp  {
  unsigned short  :0;
  int v1;
  void *v2;
};
//SIG(1 BFu0s_I_Vp) C1{ Fs:0 Fi Fp}



static void Test_BFu0s_I_Vp()
{
  {
    init_simple_test("BFu0s_I_Vp");
    static STRUCT_IF_C BFu0s_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_I_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_I_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_I_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_I_Vp, BFu0s_I_Vp)
//============================================================================


struct  BFu0s_Ip  {
  unsigned short  :0;
  int *v1;
};
//SIG(1 BFu0s_Ip) C1{ Fs:0 Fp}



static void Test_BFu0s_Ip()
{
  {
    init_simple_test("BFu0s_Ip");
    static STRUCT_IF_C BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip, BFu0s_Ip)
//============================================================================


struct  BFu0s_Ip_BFu0c  {
  unsigned short  :0;
  int *v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_Ip_BFu0c) C1{ Fs:0 Fp Fc:0}



static void Test_BFu0s_Ip_BFu0c()
{
  {
    init_simple_test("BFu0s_Ip_BFu0c");
    static STRUCT_IF_C BFu0s_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu0c, BFu0s_Ip_BFu0c)
//============================================================================


struct  BFu0s_Ip_BFu0i  {
  unsigned short  :0;
  int *v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_Ip_BFu0i) C1{ Fs:0 Fp Fi:0}



static void Test_BFu0s_Ip_BFu0i()
{
  {
    init_simple_test("BFu0s_Ip_BFu0i");
    static STRUCT_IF_C BFu0s_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu0i, BFu0s_Ip_BFu0i)
//============================================================================


struct  BFu0s_Ip_BFu0ll  {
  unsigned short  :0;
  int *v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_Ip_BFu0ll) C1{ Fs:0 Fp FL:0}



static void Test_BFu0s_Ip_BFu0ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu0ll");
    static STRUCT_IF_C BFu0s_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu0ll, BFu0s_Ip_BFu0ll)
//============================================================================


struct  BFu0s_Ip_BFu0s  {
  unsigned short  :0;
  int *v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_Ip_BFu0s) C1{ Fs:0 Fp Fs:0}



static void Test_BFu0s_Ip_BFu0s()
{
  {
    init_simple_test("BFu0s_Ip_BFu0s");
    static STRUCT_IF_C BFu0s_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu0s, BFu0s_Ip_BFu0s)
//============================================================================


struct  BFu0s_Ip_BFu15i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_Ip_BFu15i) C1{ Fs:0 Fp Fi:15}



static void Test_BFu0s_Ip_BFu15i()
{
  {
    init_simple_test("BFu0s_Ip_BFu15i");
    static STRUCT_IF_C BFu0s_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0s_Ip_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0s_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu15i, BFu0s_Ip_BFu15i)
//============================================================================


struct  BFu0s_Ip_BFu15ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_Ip_BFu15ll) C1{ Fs:0 Fp FL:15}



static void Test_BFu0s_Ip_BFu15ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu15ll");
    static STRUCT_IF_C BFu0s_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0s_Ip_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0s_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu15ll, BFu0s_Ip_BFu15ll)
//============================================================================


struct  BFu0s_Ip_BFu15s  {
  unsigned short  :0;
  int *v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_Ip_BFu15s) C1{ Fs:0 Fp Fs:15}



static void Test_BFu0s_Ip_BFu15s()
{
  {
    init_simple_test("BFu0s_Ip_BFu15s");
    static STRUCT_IF_C BFu0s_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0s_Ip_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0s_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu15s, BFu0s_Ip_BFu15s)
//============================================================================


struct  BFu0s_Ip_BFu16i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_Ip_BFu16i) C1{ Fs:0 Fp Fi:16}



static void Test_BFu0s_Ip_BFu16i()
{
  {
    init_simple_test("BFu0s_Ip_BFu16i");
    static STRUCT_IF_C BFu0s_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0s_Ip_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0s_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu16i, BFu0s_Ip_BFu16i)
//============================================================================


struct  BFu0s_Ip_BFu16ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_Ip_BFu16ll) C1{ Fs:0 Fp FL:16}



static void Test_BFu0s_Ip_BFu16ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu16ll");
    static STRUCT_IF_C BFu0s_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0s_Ip_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0s_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu16ll, BFu0s_Ip_BFu16ll)
//============================================================================


struct  BFu0s_Ip_BFu16s  {
  unsigned short  :0;
  int *v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_Ip_BFu16s) C1{ Fs:0 Fp Fs:16}



static void Test_BFu0s_Ip_BFu16s()
{
  {
    init_simple_test("BFu0s_Ip_BFu16s");
    static STRUCT_IF_C BFu0s_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0s_Ip_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0s_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu16s, BFu0s_Ip_BFu16s)
//============================================================================


struct  BFu0s_Ip_BFu17i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_Ip_BFu17i) C1{ Fs:0 Fp Fi:17}



static void Test_BFu0s_Ip_BFu17i()
{
  {
    init_simple_test("BFu0s_Ip_BFu17i");
    static STRUCT_IF_C BFu0s_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0s_Ip_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0s_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu17i, BFu0s_Ip_BFu17i)
//============================================================================


struct  BFu0s_Ip_BFu17ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_Ip_BFu17ll) C1{ Fs:0 Fp FL:17}



static void Test_BFu0s_Ip_BFu17ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu17ll");
    static STRUCT_IF_C BFu0s_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0s_Ip_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0s_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu17ll, BFu0s_Ip_BFu17ll)
//============================================================================


struct  BFu0s_Ip_BFu1c  {
  unsigned short  :0;
  int *v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_Ip_BFu1c) C1{ Fs:0 Fp Fc:1}



static void Test_BFu0s_Ip_BFu1c()
{
  {
    init_simple_test("BFu0s_Ip_BFu1c");
    static STRUCT_IF_C BFu0s_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu1c, BFu0s_Ip_BFu1c)
//============================================================================


struct  BFu0s_Ip_BFu1i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_Ip_BFu1i) C1{ Fs:0 Fp Fi:1}



static void Test_BFu0s_Ip_BFu1i()
{
  {
    init_simple_test("BFu0s_Ip_BFu1i");
    static STRUCT_IF_C BFu0s_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu1i, BFu0s_Ip_BFu1i)
//============================================================================


struct  BFu0s_Ip_BFu1ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_Ip_BFu1ll) C1{ Fs:0 Fp FL:1}



static void Test_BFu0s_Ip_BFu1ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu1ll");
    static STRUCT_IF_C BFu0s_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu1ll, BFu0s_Ip_BFu1ll)
//============================================================================


struct  BFu0s_Ip_BFu1s  {
  unsigned short  :0;
  int *v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_Ip_BFu1s) C1{ Fs:0 Fp Fs:1}



static void Test_BFu0s_Ip_BFu1s()
{
  {
    init_simple_test("BFu0s_Ip_BFu1s");
    static STRUCT_IF_C BFu0s_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu1s, BFu0s_Ip_BFu1s)
//============================================================================


struct  BFu0s_Ip_BFu31i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_Ip_BFu31i) C1{ Fs:0 Fp Fi:31}



static void Test_BFu0s_Ip_BFu31i()
{
  {
    init_simple_test("BFu0s_Ip_BFu31i");
    static STRUCT_IF_C BFu0s_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0s_Ip_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0s_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu31i, BFu0s_Ip_BFu31i)
//============================================================================


struct  BFu0s_Ip_BFu31ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_Ip_BFu31ll) C1{ Fs:0 Fp FL:31}



static void Test_BFu0s_Ip_BFu31ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu31ll");
    static STRUCT_IF_C BFu0s_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0s_Ip_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0s_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu31ll, BFu0s_Ip_BFu31ll)
//============================================================================


struct  BFu0s_Ip_BFu32i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_Ip_BFu32i) C1{ Fs:0 Fp Fi:32}



static void Test_BFu0s_Ip_BFu32i()
{
  {
    init_simple_test("BFu0s_Ip_BFu32i");
    static STRUCT_IF_C BFu0s_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0s_Ip_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0s_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu32i, BFu0s_Ip_BFu32i)
//============================================================================


struct  BFu0s_Ip_BFu32ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_Ip_BFu32ll) C1{ Fs:0 Fp FL:32}



static void Test_BFu0s_Ip_BFu32ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu32ll");
    static STRUCT_IF_C BFu0s_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0s_Ip_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0s_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu32ll, BFu0s_Ip_BFu32ll)
//============================================================================


struct  BFu0s_Ip_BFu33  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_Ip_BFu33) C1{ Fs:0 Fp FL:33}



static void Test_BFu0s_Ip_BFu33()
{
  {
    init_simple_test("BFu0s_Ip_BFu33");
    static STRUCT_IF_C BFu0s_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0s_Ip_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0s_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu33, BFu0s_Ip_BFu33)
//============================================================================


struct  BFu0s_Ip_BFu7c  {
  unsigned short  :0;
  int *v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_Ip_BFu7c) C1{ Fs:0 Fp Fc:7}



static void Test_BFu0s_Ip_BFu7c()
{
  {
    init_simple_test("BFu0s_Ip_BFu7c");
    static STRUCT_IF_C BFu0s_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Ip_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu7c, BFu0s_Ip_BFu7c)
//============================================================================


struct  BFu0s_Ip_BFu7i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_Ip_BFu7i) C1{ Fs:0 Fp Fi:7}



static void Test_BFu0s_Ip_BFu7i()
{
  {
    init_simple_test("BFu0s_Ip_BFu7i");
    static STRUCT_IF_C BFu0s_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Ip_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu7i, BFu0s_Ip_BFu7i)
//============================================================================


struct  BFu0s_Ip_BFu7ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_Ip_BFu7ll) C1{ Fs:0 Fp FL:7}



static void Test_BFu0s_Ip_BFu7ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu7ll");
    static STRUCT_IF_C BFu0s_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Ip_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu7ll, BFu0s_Ip_BFu7ll)
//============================================================================


struct  BFu0s_Ip_BFu7s  {
  unsigned short  :0;
  int *v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_Ip_BFu7s) C1{ Fs:0 Fp Fs:7}



static void Test_BFu0s_Ip_BFu7s()
{
  {
    init_simple_test("BFu0s_Ip_BFu7s");
    static STRUCT_IF_C BFu0s_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Ip_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu7s, BFu0s_Ip_BFu7s)
//============================================================================


struct  BFu0s_Ip_BFu8c  {
  unsigned short  :0;
  int *v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_Ip_BFu8c) C1{ Fs:0 Fp Fc:8}



static void Test_BFu0s_Ip_BFu8c()
{
  {
    init_simple_test("BFu0s_Ip_BFu8c");
    static STRUCT_IF_C BFu0s_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Ip_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu8c, BFu0s_Ip_BFu8c)
//============================================================================


struct  BFu0s_Ip_BFu8i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_Ip_BFu8i) C1{ Fs:0 Fp Fi:8}



static void Test_BFu0s_Ip_BFu8i()
{
  {
    init_simple_test("BFu0s_Ip_BFu8i");
    static STRUCT_IF_C BFu0s_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Ip_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu8i, BFu0s_Ip_BFu8i)
//============================================================================


struct  BFu0s_Ip_BFu8ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_Ip_BFu8ll) C1{ Fs:0 Fp FL:8}



static void Test_BFu0s_Ip_BFu8ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu8ll");
    static STRUCT_IF_C BFu0s_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Ip_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu8ll, BFu0s_Ip_BFu8ll)
//============================================================================


struct  BFu0s_Ip_BFu8s  {
  unsigned short  :0;
  int *v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_Ip_BFu8s) C1{ Fs:0 Fp Fs:8}



static void Test_BFu0s_Ip_BFu8s()
{
  {
    init_simple_test("BFu0s_Ip_BFu8s");
    static STRUCT_IF_C BFu0s_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Ip_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu8s, BFu0s_Ip_BFu8s)
//============================================================================


struct  BFu0s_Ip_BFu9i  {
  unsigned short  :0;
  int *v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_Ip_BFu9i) C1{ Fs:0 Fp Fi:9}



static void Test_BFu0s_Ip_BFu9i()
{
  {
    init_simple_test("BFu0s_Ip_BFu9i");
    static STRUCT_IF_C BFu0s_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0s_Ip_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0s_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu9i, BFu0s_Ip_BFu9i)
//============================================================================


struct  BFu0s_Ip_BFu9ll  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_Ip_BFu9ll) C1{ Fs:0 Fp FL:9}



static void Test_BFu0s_Ip_BFu9ll()
{
  {
    init_simple_test("BFu0s_Ip_BFu9ll");
    static STRUCT_IF_C BFu0s_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0s_Ip_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0s_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu9ll, BFu0s_Ip_BFu9ll)
//============================================================================


struct  BFu0s_Ip_BFu9s  {
  unsigned short  :0;
  int *v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_Ip_BFu9s) C1{ Fs:0 Fp Fs:9}



static void Test_BFu0s_Ip_BFu9s()
{
  {
    init_simple_test("BFu0s_Ip_BFu9s");
    static STRUCT_IF_C BFu0s_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0s_Ip_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0s_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_BFu9s, BFu0s_Ip_BFu9s)
//============================================================================


struct  BFu0s_Ip_C  {
  unsigned short  :0;
  int *v1;
  char v2;
};
//SIG(1 BFu0s_Ip_C) C1{ Fs:0 Fp Fc}



static void Test_BFu0s_Ip_C()
{
  {
    init_simple_test("BFu0s_Ip_C");
    static STRUCT_IF_C BFu0s_Ip_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_C, BFu0s_Ip_C)
//============================================================================


struct  BFu0s_Ip_D  {
  unsigned short  :0;
  int *v1;
  double v2;
};
//SIG(1 BFu0s_Ip_D) C1{ Fs:0 Fp FL}



static void Test_BFu0s_Ip_D()
{
  {
    init_simple_test("BFu0s_Ip_D");
    static STRUCT_IF_C BFu0s_Ip_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_D, BFu0s_Ip_D)
//============================================================================


struct  BFu0s_Ip_F  {
  unsigned short  :0;
  int *v1;
  float v2;
};
//SIG(1 BFu0s_Ip_F) C1{ Fs:0 Fp Fi}



static void Test_BFu0s_Ip_F()
{
  {
    init_simple_test("BFu0s_Ip_F");
    static STRUCT_IF_C BFu0s_Ip_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_F, BFu0s_Ip_F)
//============================================================================


struct  BFu0s_Ip_I  {
  unsigned short  :0;
  int *v1;
  int v2;
};
//SIG(1 BFu0s_Ip_I) C1{ Fs:0 Fp Fi}



static void Test_BFu0s_Ip_I()
{
  {
    init_simple_test("BFu0s_Ip_I");
    static STRUCT_IF_C BFu0s_Ip_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_I, BFu0s_Ip_I)
//============================================================================


struct  BFu0s_Ip_Ip  {
  unsigned short  :0;
  int *v1;
  int *v2;
};
//SIG(1 BFu0s_Ip_Ip) C1{ Fs:0 Fp[2]}



static void Test_BFu0s_Ip_Ip()
{
  {
    init_simple_test("BFu0s_Ip_Ip");
    static STRUCT_IF_C BFu0s_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Ip, BFu0s_Ip_Ip)
//============================================================================


struct  BFu0s_Ip_L  {
  unsigned short  :0;
  int *v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_Ip_L) C1{ Fs:0 Fp FL}



static void Test_BFu0s_Ip_L()
{
  {
    init_simple_test("BFu0s_Ip_L");
    static STRUCT_IF_C BFu0s_Ip_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_L, BFu0s_Ip_L)
//============================================================================


struct  BFu0s_Ip_S  {
  unsigned short  :0;
  int *v1;
  short v2;
};
//SIG(1 BFu0s_Ip_S) C1{ Fs:0 Fp Fs}



static void Test_BFu0s_Ip_S()
{
  {
    init_simple_test("BFu0s_Ip_S");
    static STRUCT_IF_C BFu0s_Ip_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_S, BFu0s_Ip_S)
//============================================================================


struct  BFu0s_Ip_Uc  {
  unsigned short  :0;
  int *v1;
  unsigned char v2;
};
//SIG(1 BFu0s_Ip_Uc) C1{ Fs:0 Fp Fc}



static void Test_BFu0s_Ip_Uc()
{
  {
    init_simple_test("BFu0s_Ip_Uc");
    static STRUCT_IF_C BFu0s_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Uc, BFu0s_Ip_Uc)
//============================================================================


struct  BFu0s_Ip_Ui  {
  unsigned short  :0;
  int *v1;
  unsigned int v2;
};
//SIG(1 BFu0s_Ip_Ui) C1{ Fs:0 Fp Fi}



static void Test_BFu0s_Ip_Ui()
{
  {
    init_simple_test("BFu0s_Ip_Ui");
    static STRUCT_IF_C BFu0s_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Ui, BFu0s_Ip_Ui)
//============================================================================


struct  BFu0s_Ip_Ul  {
  unsigned short  :0;
  int *v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_Ip_Ul) C1{ Fs:0 Fp FL}



static void Test_BFu0s_Ip_Ul()
{
  {
    init_simple_test("BFu0s_Ip_Ul");
    static STRUCT_IF_C BFu0s_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Ul, BFu0s_Ip_Ul)
//============================================================================


struct  BFu0s_Ip_Us  {
  unsigned short  :0;
  int *v1;
  unsigned short v2;
};
//SIG(1 BFu0s_Ip_Us) C1{ Fs:0 Fp Fs}



static void Test_BFu0s_Ip_Us()
{
  {
    init_simple_test("BFu0s_Ip_Us");
    static STRUCT_IF_C BFu0s_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Us, BFu0s_Ip_Us)
//============================================================================


struct  BFu0s_Ip_Vp  {
  unsigned short  :0;
  int *v1;
  void *v2;
};
//SIG(1 BFu0s_Ip_Vp) C1{ Fs:0 Fp[2]}



static void Test_BFu0s_Ip_Vp()
{
  {
    init_simple_test("BFu0s_Ip_Vp");
    static STRUCT_IF_C BFu0s_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ip_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ip_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ip_Vp, BFu0s_Ip_Vp)
//============================================================================


struct  BFu0s_L  {
  unsigned short  :0;
  __tsi64 v1;
};
//SIG(1 BFu0s_L) C1{ Fs:0 FL}



static void Test_BFu0s_L()
{
  {
    init_simple_test("BFu0s_L");
    static STRUCT_IF_C BFu0s_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L)");
    check_field_offset(lv, v1, 0, "BFu0s_L.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L, BFu0s_L)
//============================================================================


struct  BFu0s_L_BFu0c  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_L_BFu0c) C1{ Fs:0 FL Fc:0}



static void Test_BFu0s_L_BFu0c()
{
  {
    init_simple_test("BFu0s_L_BFu0c");
    static STRUCT_IF_C BFu0s_L_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu0c, BFu0s_L_BFu0c)
//============================================================================


struct  BFu0s_L_BFu0i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_L_BFu0i) C1{ Fs:0 FL Fi:0}



static void Test_BFu0s_L_BFu0i()
{
  {
    init_simple_test("BFu0s_L_BFu0i");
    static STRUCT_IF_C BFu0s_L_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu0i, BFu0s_L_BFu0i)
//============================================================================


struct  BFu0s_L_BFu0ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_L_BFu0ll) C1{ Fs:0 FL FL:0}



static void Test_BFu0s_L_BFu0ll()
{
  {
    init_simple_test("BFu0s_L_BFu0ll");
    static STRUCT_IF_C BFu0s_L_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu0ll, BFu0s_L_BFu0ll)
//============================================================================


struct  BFu0s_L_BFu0s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_L_BFu0s) C1{ Fs:0 FL Fs:0}



static void Test_BFu0s_L_BFu0s()
{
  {
    init_simple_test("BFu0s_L_BFu0s");
    static STRUCT_IF_C BFu0s_L_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu0s, BFu0s_L_BFu0s)
//============================================================================


struct  BFu0s_L_BFu15i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_L_BFu15i) C1{ Fs:0 FL Fi:15}



static void Test_BFu0s_L_BFu15i()
{
  {
    init_simple_test("BFu0s_L_BFu15i");
    static STRUCT_IF_C BFu0s_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_L_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu15i, BFu0s_L_BFu15i)
//============================================================================


struct  BFu0s_L_BFu15ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_L_BFu15ll) C1{ Fs:0 FL FL:15}



static void Test_BFu0s_L_BFu15ll()
{
  {
    init_simple_test("BFu0s_L_BFu15ll");
    static STRUCT_IF_C BFu0s_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_L_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu15ll, BFu0s_L_BFu15ll)
//============================================================================


struct  BFu0s_L_BFu15s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_L_BFu15s) C1{ Fs:0 FL Fs:15}



static void Test_BFu0s_L_BFu15s()
{
  {
    init_simple_test("BFu0s_L_BFu15s");
    static STRUCT_IF_C BFu0s_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_L_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu15s, BFu0s_L_BFu15s)
//============================================================================


struct  BFu0s_L_BFu16i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_L_BFu16i) C1{ Fs:0 FL Fi:16}



static void Test_BFu0s_L_BFu16i()
{
  {
    init_simple_test("BFu0s_L_BFu16i");
    static STRUCT_IF_C BFu0s_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_L_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu16i, BFu0s_L_BFu16i)
//============================================================================


struct  BFu0s_L_BFu16ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_L_BFu16ll) C1{ Fs:0 FL FL:16}



static void Test_BFu0s_L_BFu16ll()
{
  {
    init_simple_test("BFu0s_L_BFu16ll");
    static STRUCT_IF_C BFu0s_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_L_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu16ll, BFu0s_L_BFu16ll)
//============================================================================


struct  BFu0s_L_BFu16s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_L_BFu16s) C1{ Fs:0 FL Fs:16}



static void Test_BFu0s_L_BFu16s()
{
  {
    init_simple_test("BFu0s_L_BFu16s");
    static STRUCT_IF_C BFu0s_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_L_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu16s, BFu0s_L_BFu16s)
//============================================================================


struct  BFu0s_L_BFu17i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_L_BFu17i) C1{ Fs:0 FL Fi:17}



static void Test_BFu0s_L_BFu17i()
{
  {
    init_simple_test("BFu0s_L_BFu17i");
    static STRUCT_IF_C BFu0s_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0s_L_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0s_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu17i, BFu0s_L_BFu17i)
//============================================================================


struct  BFu0s_L_BFu17ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_L_BFu17ll) C1{ Fs:0 FL FL:17}



static void Test_BFu0s_L_BFu17ll()
{
  {
    init_simple_test("BFu0s_L_BFu17ll");
    static STRUCT_IF_C BFu0s_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0s_L_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0s_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu17ll, BFu0s_L_BFu17ll)
//============================================================================


struct  BFu0s_L_BFu1c  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_L_BFu1c) C1{ Fs:0 FL Fc:1}



static void Test_BFu0s_L_BFu1c()
{
  {
    init_simple_test("BFu0s_L_BFu1c");
    static STRUCT_IF_C BFu0s_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu1c, BFu0s_L_BFu1c)
//============================================================================


struct  BFu0s_L_BFu1i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_L_BFu1i) C1{ Fs:0 FL Fi:1}



static void Test_BFu0s_L_BFu1i()
{
  {
    init_simple_test("BFu0s_L_BFu1i");
    static STRUCT_IF_C BFu0s_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu1i, BFu0s_L_BFu1i)
//============================================================================


struct  BFu0s_L_BFu1ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_L_BFu1ll) C1{ Fs:0 FL FL:1}



static void Test_BFu0s_L_BFu1ll()
{
  {
    init_simple_test("BFu0s_L_BFu1ll");
    static STRUCT_IF_C BFu0s_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu1ll, BFu0s_L_BFu1ll)
//============================================================================


struct  BFu0s_L_BFu1s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_L_BFu1s) C1{ Fs:0 FL Fs:1}



static void Test_BFu0s_L_BFu1s()
{
  {
    init_simple_test("BFu0s_L_BFu1s");
    static STRUCT_IF_C BFu0s_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu1s, BFu0s_L_BFu1s)
//============================================================================


struct  BFu0s_L_BFu31i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_L_BFu31i) C1{ Fs:0 FL Fi:31}



static void Test_BFu0s_L_BFu31i()
{
  {
    init_simple_test("BFu0s_L_BFu31i");
    static STRUCT_IF_C BFu0s_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0s_L_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0s_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu31i, BFu0s_L_BFu31i)
//============================================================================


struct  BFu0s_L_BFu31ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_L_BFu31ll) C1{ Fs:0 FL FL:31}



static void Test_BFu0s_L_BFu31ll()
{
  {
    init_simple_test("BFu0s_L_BFu31ll");
    static STRUCT_IF_C BFu0s_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0s_L_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0s_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu31ll, BFu0s_L_BFu31ll)
//============================================================================


struct  BFu0s_L_BFu32i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_L_BFu32i) C1{ Fs:0 FL Fi:32}



static void Test_BFu0s_L_BFu32i()
{
  {
    init_simple_test("BFu0s_L_BFu32i");
    static STRUCT_IF_C BFu0s_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0s_L_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0s_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu32i, BFu0s_L_BFu32i)
//============================================================================


struct  BFu0s_L_BFu32ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_L_BFu32ll) C1{ Fs:0 FL FL:32}



static void Test_BFu0s_L_BFu32ll()
{
  {
    init_simple_test("BFu0s_L_BFu32ll");
    static STRUCT_IF_C BFu0s_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0s_L_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0s_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu32ll, BFu0s_L_BFu32ll)
//============================================================================


struct  BFu0s_L_BFu33  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_L_BFu33) C1{ Fs:0 FL FL:33}



static void Test_BFu0s_L_BFu33()
{
  {
    init_simple_test("BFu0s_L_BFu33");
    static STRUCT_IF_C BFu0s_L_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0s_L_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0s_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu33, BFu0s_L_BFu33)
//============================================================================


struct  BFu0s_L_BFu7c  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_L_BFu7c) C1{ Fs:0 FL Fc:7}



static void Test_BFu0s_L_BFu7c()
{
  {
    init_simple_test("BFu0s_L_BFu7c");
    static STRUCT_IF_C BFu0s_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_L_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu7c, BFu0s_L_BFu7c)
//============================================================================


struct  BFu0s_L_BFu7i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_L_BFu7i) C1{ Fs:0 FL Fi:7}



static void Test_BFu0s_L_BFu7i()
{
  {
    init_simple_test("BFu0s_L_BFu7i");
    static STRUCT_IF_C BFu0s_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_L_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu7i, BFu0s_L_BFu7i)
//============================================================================


struct  BFu0s_L_BFu7ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_L_BFu7ll) C1{ Fs:0 FL FL:7}



static void Test_BFu0s_L_BFu7ll()
{
  {
    init_simple_test("BFu0s_L_BFu7ll");
    static STRUCT_IF_C BFu0s_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_L_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu7ll, BFu0s_L_BFu7ll)
//============================================================================


struct  BFu0s_L_BFu7s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_L_BFu7s) C1{ Fs:0 FL Fs:7}



static void Test_BFu0s_L_BFu7s()
{
  {
    init_simple_test("BFu0s_L_BFu7s");
    static STRUCT_IF_C BFu0s_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_L_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu7s, BFu0s_L_BFu7s)
//============================================================================


struct  BFu0s_L_BFu8c  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_L_BFu8c) C1{ Fs:0 FL Fc:8}



static void Test_BFu0s_L_BFu8c()
{
  {
    init_simple_test("BFu0s_L_BFu8c");
    static STRUCT_IF_C BFu0s_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_L_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu8c, BFu0s_L_BFu8c)
//============================================================================


struct  BFu0s_L_BFu8i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_L_BFu8i) C1{ Fs:0 FL Fi:8}



static void Test_BFu0s_L_BFu8i()
{
  {
    init_simple_test("BFu0s_L_BFu8i");
    static STRUCT_IF_C BFu0s_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_L_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu8i, BFu0s_L_BFu8i)
//============================================================================


struct  BFu0s_L_BFu8ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_L_BFu8ll) C1{ Fs:0 FL FL:8}



static void Test_BFu0s_L_BFu8ll()
{
  {
    init_simple_test("BFu0s_L_BFu8ll");
    static STRUCT_IF_C BFu0s_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_L_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu8ll, BFu0s_L_BFu8ll)
//============================================================================


struct  BFu0s_L_BFu8s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_L_BFu8s) C1{ Fs:0 FL Fs:8}



static void Test_BFu0s_L_BFu8s()
{
  {
    init_simple_test("BFu0s_L_BFu8s");
    static STRUCT_IF_C BFu0s_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_L_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu8s, BFu0s_L_BFu8s)
//============================================================================


struct  BFu0s_L_BFu9i  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_L_BFu9i) C1{ Fs:0 FL Fi:9}



static void Test_BFu0s_L_BFu9i()
{
  {
    init_simple_test("BFu0s_L_BFu9i");
    static STRUCT_IF_C BFu0s_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_L_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu9i, BFu0s_L_BFu9i)
//============================================================================


struct  BFu0s_L_BFu9ll  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_L_BFu9ll) C1{ Fs:0 FL FL:9}



static void Test_BFu0s_L_BFu9ll()
{
  {
    init_simple_test("BFu0s_L_BFu9ll");
    static STRUCT_IF_C BFu0s_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_L_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu9ll, BFu0s_L_BFu9ll)
//============================================================================


struct  BFu0s_L_BFu9s  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_L_BFu9s) C1{ Fs:0 FL Fs:9}



static void Test_BFu0s_L_BFu9s()
{
  {
    init_simple_test("BFu0s_L_BFu9s");
    static STRUCT_IF_C BFu0s_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_L_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_L_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_BFu9s, BFu0s_L_BFu9s)
//============================================================================


struct  BFu0s_L_C  {
  unsigned short  :0;
  __tsi64 v1;
  char v2;
};
//SIG(1 BFu0s_L_C) C1{ Fs:0 FL Fc}



static void Test_BFu0s_L_C()
{
  {
    init_simple_test("BFu0s_L_C");
    static STRUCT_IF_C BFu0s_L_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_C)");
    check_field_offset(lv, v1, 0, "BFu0s_L_C.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_C, BFu0s_L_C)
//============================================================================


struct  BFu0s_L_D  {
  unsigned short  :0;
  __tsi64 v1;
  double v2;
};
//SIG(1 BFu0s_L_D) C1{ Fs:0 FL[2]}



static void Test_BFu0s_L_D()
{
  {
    init_simple_test("BFu0s_L_D");
    static STRUCT_IF_C BFu0s_L_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_D)");
    check_field_offset(lv, v1, 0, "BFu0s_L_D.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_D, BFu0s_L_D)
//============================================================================


struct  BFu0s_L_F  {
  unsigned short  :0;
  __tsi64 v1;
  float v2;
};
//SIG(1 BFu0s_L_F) C1{ Fs:0 FL Fi}



static void Test_BFu0s_L_F()
{
  {
    init_simple_test("BFu0s_L_F");
    static STRUCT_IF_C BFu0s_L_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_F)");
    check_field_offset(lv, v1, 0, "BFu0s_L_F.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_F, BFu0s_L_F)
//============================================================================


struct  BFu0s_L_I  {
  unsigned short  :0;
  __tsi64 v1;
  int v2;
};
//SIG(1 BFu0s_L_I) C1{ Fs:0 FL Fi}



static void Test_BFu0s_L_I()
{
  {
    init_simple_test("BFu0s_L_I");
    static STRUCT_IF_C BFu0s_L_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_I)");
    check_field_offset(lv, v1, 0, "BFu0s_L_I.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_I, BFu0s_L_I)
//============================================================================


struct  BFu0s_L_Ip  {
  unsigned short  :0;
  __tsi64 v1;
  int *v2;
};
//SIG(1 BFu0s_L_Ip) C1{ Fs:0 FL Fp}



static void Test_BFu0s_L_Ip()
{
  {
    init_simple_test("BFu0s_L_Ip");
    static STRUCT_IF_C BFu0s_L_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Ip, BFu0s_L_Ip)
//============================================================================


struct  BFu0s_L_L  {
  unsigned short  :0;
  __tsi64 v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_L_L) C1{ Fs:0 FL[2]}



static void Test_BFu0s_L_L()
{
  {
    init_simple_test("BFu0s_L_L");
    static STRUCT_IF_C BFu0s_L_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_L)");
    check_field_offset(lv, v1, 0, "BFu0s_L_L.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_L, BFu0s_L_L)
//============================================================================


struct  BFu0s_L_S  {
  unsigned short  :0;
  __tsi64 v1;
  short v2;
};
//SIG(1 BFu0s_L_S) C1{ Fs:0 FL Fs}



static void Test_BFu0s_L_S()
{
  {
    init_simple_test("BFu0s_L_S");
    static STRUCT_IF_C BFu0s_L_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_S)");
    check_field_offset(lv, v1, 0, "BFu0s_L_S.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_S, BFu0s_L_S)
//============================================================================


struct  BFu0s_L_Uc  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned char v2;
};
//SIG(1 BFu0s_L_Uc) C1{ Fs:0 FL Fc}



static void Test_BFu0s_L_Uc()
{
  {
    init_simple_test("BFu0s_L_Uc");
    static STRUCT_IF_C BFu0s_L_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Uc, BFu0s_L_Uc)
//============================================================================


struct  BFu0s_L_Ui  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned int v2;
};
//SIG(1 BFu0s_L_Ui) C1{ Fs:0 FL Fi}



static void Test_BFu0s_L_Ui()
{
  {
    init_simple_test("BFu0s_L_Ui");
    static STRUCT_IF_C BFu0s_L_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Ui, BFu0s_L_Ui)
//============================================================================


struct  BFu0s_L_Ul  {
  unsigned short  :0;
  __tsi64 v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_L_Ul) C1{ Fs:0 FL[2]}



static void Test_BFu0s_L_Ul()
{
  {
    init_simple_test("BFu0s_L_Ul");
    static STRUCT_IF_C BFu0s_L_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Ul, BFu0s_L_Ul)
//============================================================================


struct  BFu0s_L_Us  {
  unsigned short  :0;
  __tsi64 v1;
  unsigned short v2;
};
//SIG(1 BFu0s_L_Us) C1{ Fs:0 FL Fs}



static void Test_BFu0s_L_Us()
{
  {
    init_simple_test("BFu0s_L_Us");
    static STRUCT_IF_C BFu0s_L_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Us, BFu0s_L_Us)
//============================================================================


struct  BFu0s_L_Vp  {
  unsigned short  :0;
  __tsi64 v1;
  void *v2;
};
//SIG(1 BFu0s_L_Vp) C1{ Fs:0 FL Fp}



static void Test_BFu0s_L_Vp()
{
  {
    init_simple_test("BFu0s_L_Vp");
    static STRUCT_IF_C BFu0s_L_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_L_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_L_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0s_L_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_L_Vp, BFu0s_L_Vp)
//============================================================================


struct  BFu0s_S  {
  unsigned short  :0;
  short v1;
};
//SIG(1 BFu0s_S) C1{ Fs:0 Fs}



static void Test_BFu0s_S()
{
  {
    init_simple_test("BFu0s_S");
    static STRUCT_IF_C BFu0s_S lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S)");
    check_field_offset(lv, v1, 0, "BFu0s_S.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S, BFu0s_S)
//============================================================================


struct  BFu0s_S_BFu0c  {
  unsigned short  :0;
  short v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_S_BFu0c) C1{ Fs:0 Fs Fc:0}



static void Test_BFu0s_S_BFu0c()
{
  {
    init_simple_test("BFu0s_S_BFu0c");
    static STRUCT_IF_C BFu0s_S_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_S_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu0c, BFu0s_S_BFu0c)
//============================================================================


struct  BFu0s_S_BFu0i  {
  unsigned short  :0;
  short v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_S_BFu0i) C1{ Fs:0 Fs Fi:0}



static void Test_BFu0s_S_BFu0i()
{
  {
    init_simple_test("BFu0s_S_BFu0i");
    static STRUCT_IF_C BFu0s_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0s_S_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu0i, BFu0s_S_BFu0i)
//============================================================================


struct  BFu0s_S_BFu0ll  {
  unsigned short  :0;
  short v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_S_BFu0ll) C1{ Fs:0 Fs FL:0}



static void Test_BFu0s_S_BFu0ll()
{
  {
    init_simple_test("BFu0s_S_BFu0ll");
    static STRUCT_IF_C BFu0s_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0s_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu0ll, BFu0s_S_BFu0ll)
//============================================================================


struct  BFu0s_S_BFu0s  {
  unsigned short  :0;
  short v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_S_BFu0s) C1{ Fs:0 Fs Fs:0}



static void Test_BFu0s_S_BFu0s()
{
  {
    init_simple_test("BFu0s_S_BFu0s");
    static STRUCT_IF_C BFu0s_S_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_S_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu0s, BFu0s_S_BFu0s)
//============================================================================


struct  BFu0s_S_BFu15i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_S_BFu15i) C1{ Fs:0 Fs Fi:15}



static void Test_BFu0s_S_BFu15i()
{
  {
    init_simple_test("BFu0s_S_BFu15i");
    static STRUCT_IF_C BFu0s_S_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_S_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu15i, BFu0s_S_BFu15i)
//============================================================================


struct  BFu0s_S_BFu15ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_S_BFu15ll) C1{ Fs:0 Fs FL:15}



static void Test_BFu0s_S_BFu15ll()
{
  {
    init_simple_test("BFu0s_S_BFu15ll");
    static STRUCT_IF_C BFu0s_S_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_S_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu15ll, BFu0s_S_BFu15ll)
//============================================================================


struct  BFu0s_S_BFu15s  {
  unsigned short  :0;
  short v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_S_BFu15s) C1{ Fs:0 Fs Fs:15}



static void Test_BFu0s_S_BFu15s()
{
  {
    init_simple_test("BFu0s_S_BFu15s");
    static STRUCT_IF_C BFu0s_S_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_S_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu15s, BFu0s_S_BFu15s)
//============================================================================


struct  BFu0s_S_BFu16i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_S_BFu16i) C1{ Fs:0 Fs Fi:16}



static void Test_BFu0s_S_BFu16i()
{
  {
    init_simple_test("BFu0s_S_BFu16i");
    static STRUCT_IF_C BFu0s_S_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_S_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu16i, BFu0s_S_BFu16i)
//============================================================================


struct  BFu0s_S_BFu16ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_S_BFu16ll) C1{ Fs:0 Fs FL:16}



static void Test_BFu0s_S_BFu16ll()
{
  {
    init_simple_test("BFu0s_S_BFu16ll");
    static STRUCT_IF_C BFu0s_S_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_S_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu16ll, BFu0s_S_BFu16ll)
//============================================================================


struct  BFu0s_S_BFu16s  {
  unsigned short  :0;
  short v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_S_BFu16s) C1{ Fs:0 Fs Fs:16}



static void Test_BFu0s_S_BFu16s()
{
  {
    init_simple_test("BFu0s_S_BFu16s");
    static STRUCT_IF_C BFu0s_S_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_S_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu16s, BFu0s_S_BFu16s)
//============================================================================


struct  BFu0s_S_BFu17i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_S_BFu17i) C1{ Fs:0 Fs Fi:17}



static void Test_BFu0s_S_BFu17i()
{
  {
    init_simple_test("BFu0s_S_BFu17i");
    static STRUCT_IF_C BFu0s_S_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_S_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu17i, BFu0s_S_BFu17i)
//============================================================================


struct  BFu0s_S_BFu17ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_S_BFu17ll) C1{ Fs:0 Fs FL:17}



static void Test_BFu0s_S_BFu17ll()
{
  {
    init_simple_test("BFu0s_S_BFu17ll");
    static STRUCT_IF_C BFu0s_S_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0s_S_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0s_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu17ll, BFu0s_S_BFu17ll)
//============================================================================


struct  BFu0s_S_BFu1c  {
  unsigned short  :0;
  short v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_S_BFu1c) C1{ Fs:0 Fs Fc:1}



static void Test_BFu0s_S_BFu1c()
{
  {
    init_simple_test("BFu0s_S_BFu1c");
    static STRUCT_IF_C BFu0s_S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu1c, BFu0s_S_BFu1c)
//============================================================================


struct  BFu0s_S_BFu1i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_S_BFu1i) C1{ Fs:0 Fs Fi:1}



static void Test_BFu0s_S_BFu1i()
{
  {
    init_simple_test("BFu0s_S_BFu1i");
    static STRUCT_IF_C BFu0s_S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu1i, BFu0s_S_BFu1i)
//============================================================================


struct  BFu0s_S_BFu1ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_S_BFu1ll) C1{ Fs:0 Fs FL:1}



static void Test_BFu0s_S_BFu1ll()
{
  {
    init_simple_test("BFu0s_S_BFu1ll");
    static STRUCT_IF_C BFu0s_S_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu1ll, BFu0s_S_BFu1ll)
//============================================================================


struct  BFu0s_S_BFu1s  {
  unsigned short  :0;
  short v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_S_BFu1s) C1{ Fs:0 Fs Fs:1}



static void Test_BFu0s_S_BFu1s()
{
  {
    init_simple_test("BFu0s_S_BFu1s");
    static STRUCT_IF_C BFu0s_S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu1s, BFu0s_S_BFu1s)
//============================================================================


struct  BFu0s_S_BFu31i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_S_BFu31i) C1{ Fs:0 Fs Fi:31}



static void Test_BFu0s_S_BFu31i()
{
  {
    init_simple_test("BFu0s_S_BFu31i");
    static STRUCT_IF_C BFu0s_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_S_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu31i, BFu0s_S_BFu31i)
//============================================================================


struct  BFu0s_S_BFu31ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_S_BFu31ll) C1{ Fs:0 Fs FL:31}



static void Test_BFu0s_S_BFu31ll()
{
  {
    init_simple_test("BFu0s_S_BFu31ll");
    static STRUCT_IF_C BFu0s_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0s_S_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0s_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu31ll, BFu0s_S_BFu31ll)
//============================================================================


struct  BFu0s_S_BFu32i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_S_BFu32i) C1{ Fs:0 Fs Fi:32}



static void Test_BFu0s_S_BFu32i()
{
  {
    init_simple_test("BFu0s_S_BFu32i");
    static STRUCT_IF_C BFu0s_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_S_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu32i, BFu0s_S_BFu32i)
//============================================================================


struct  BFu0s_S_BFu32ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_S_BFu32ll) C1{ Fs:0 Fs FL:32}



static void Test_BFu0s_S_BFu32ll()
{
  {
    init_simple_test("BFu0s_S_BFu32ll");
    static STRUCT_IF_C BFu0s_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0s_S_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0s_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu32ll, BFu0s_S_BFu32ll)
//============================================================================


struct  BFu0s_S_BFu33  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_S_BFu33) C1{ Fs:0 Fs FL:33}



static void Test_BFu0s_S_BFu33()
{
  {
    init_simple_test("BFu0s_S_BFu33");
    static STRUCT_IF_C BFu0s_S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0s_S_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0s_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu33, BFu0s_S_BFu33)
//============================================================================


struct  BFu0s_S_BFu7c  {
  unsigned short  :0;
  short v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_S_BFu7c) C1{ Fs:0 Fs Fc:7}



static void Test_BFu0s_S_BFu7c()
{
  {
    init_simple_test("BFu0s_S_BFu7c");
    static STRUCT_IF_C BFu0s_S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_S_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu7c, BFu0s_S_BFu7c)
//============================================================================


struct  BFu0s_S_BFu7i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_S_BFu7i) C1{ Fs:0 Fs Fi:7}



static void Test_BFu0s_S_BFu7i()
{
  {
    init_simple_test("BFu0s_S_BFu7i");
    static STRUCT_IF_C BFu0s_S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_S_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu7i, BFu0s_S_BFu7i)
//============================================================================


struct  BFu0s_S_BFu7ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_S_BFu7ll) C1{ Fs:0 Fs FL:7}



static void Test_BFu0s_S_BFu7ll()
{
  {
    init_simple_test("BFu0s_S_BFu7ll");
    static STRUCT_IF_C BFu0s_S_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_S_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu7ll, BFu0s_S_BFu7ll)
//============================================================================


struct  BFu0s_S_BFu7s  {
  unsigned short  :0;
  short v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_S_BFu7s) C1{ Fs:0 Fs Fs:7}



static void Test_BFu0s_S_BFu7s()
{
  {
    init_simple_test("BFu0s_S_BFu7s");
    static STRUCT_IF_C BFu0s_S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_S_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu7s, BFu0s_S_BFu7s)
//============================================================================


struct  BFu0s_S_BFu8c  {
  unsigned short  :0;
  short v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_S_BFu8c) C1{ Fs:0 Fs Fc:8}



static void Test_BFu0s_S_BFu8c()
{
  {
    init_simple_test("BFu0s_S_BFu8c");
    static STRUCT_IF_C BFu0s_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_S_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu8c, BFu0s_S_BFu8c)
//============================================================================


struct  BFu0s_S_BFu8i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_S_BFu8i) C1{ Fs:0 Fs Fi:8}



static void Test_BFu0s_S_BFu8i()
{
  {
    init_simple_test("BFu0s_S_BFu8i");
    static STRUCT_IF_C BFu0s_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_S_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu8i, BFu0s_S_BFu8i)
//============================================================================


struct  BFu0s_S_BFu8ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_S_BFu8ll) C1{ Fs:0 Fs FL:8}



static void Test_BFu0s_S_BFu8ll()
{
  {
    init_simple_test("BFu0s_S_BFu8ll");
    static STRUCT_IF_C BFu0s_S_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_S_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu8ll, BFu0s_S_BFu8ll)
//============================================================================


struct  BFu0s_S_BFu8s  {
  unsigned short  :0;
  short v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_S_BFu8s) C1{ Fs:0 Fs Fs:8}



static void Test_BFu0s_S_BFu8s()
{
  {
    init_simple_test("BFu0s_S_BFu8s");
    static STRUCT_IF_C BFu0s_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_S_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu8s, BFu0s_S_BFu8s)
//============================================================================


struct  BFu0s_S_BFu9i  {
  unsigned short  :0;
  short v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_S_BFu9i) C1{ Fs:0 Fs Fi:9}



static void Test_BFu0s_S_BFu9i()
{
  {
    init_simple_test("BFu0s_S_BFu9i");
    static STRUCT_IF_C BFu0s_S_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_S_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu9i, BFu0s_S_BFu9i)
//============================================================================


struct  BFu0s_S_BFu9ll  {
  unsigned short  :0;
  short v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_S_BFu9ll) C1{ Fs:0 Fs FL:9}



static void Test_BFu0s_S_BFu9ll()
{
  {
    init_simple_test("BFu0s_S_BFu9ll");
    static STRUCT_IF_C BFu0s_S_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_S_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu9ll, BFu0s_S_BFu9ll)
//============================================================================


struct  BFu0s_S_BFu9s  {
  unsigned short  :0;
  short v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_S_BFu9s) C1{ Fs:0 Fs Fs:9}



static void Test_BFu0s_S_BFu9s()
{
  {
    init_simple_test("BFu0s_S_BFu9s");
    static STRUCT_IF_C BFu0s_S_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_S_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_S_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_BFu9s, BFu0s_S_BFu9s)
//============================================================================


struct  BFu0s_S_C  {
  unsigned short  :0;
  short v1;
  char v2;
};
//SIG(1 BFu0s_S_C) C1{ Fs:0 Fs Fc}



static void Test_BFu0s_S_C()
{
  {
    init_simple_test("BFu0s_S_C");
    static STRUCT_IF_C BFu0s_S_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_C)");
    check_field_offset(lv, v1, 0, "BFu0s_S_C.v1");
    check_field_offset(lv, v2, 2, "BFu0s_S_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_C, BFu0s_S_C)
//============================================================================


struct  BFu0s_S_D  {
  unsigned short  :0;
  short v1;
  double v2;
};
//SIG(1 BFu0s_S_D) C1{ Fs:0 Fs FL}



static void Test_BFu0s_S_D()
{
  {
    init_simple_test("BFu0s_S_D");
    static STRUCT_IF_C BFu0s_S_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_S_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_D)");
    check_field_offset(lv, v1, 0, "BFu0s_S_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_S_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_D, BFu0s_S_D)
//============================================================================


struct  BFu0s_S_F  {
  unsigned short  :0;
  short v1;
  float v2;
};
//SIG(1 BFu0s_S_F) C1{ Fs:0 Fs Fi}



static void Test_BFu0s_S_F()
{
  {
    init_simple_test("BFu0s_S_F");
    static STRUCT_IF_C BFu0s_S_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_F)");
    check_field_offset(lv, v1, 0, "BFu0s_S_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_S_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_F, BFu0s_S_F)
//============================================================================


struct  BFu0s_S_I  {
  unsigned short  :0;
  short v1;
  int v2;
};
//SIG(1 BFu0s_S_I) C1{ Fs:0 Fs Fi}



static void Test_BFu0s_S_I()
{
  {
    init_simple_test("BFu0s_S_I");
    static STRUCT_IF_C BFu0s_S_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_I)");
    check_field_offset(lv, v1, 0, "BFu0s_S_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_S_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_I, BFu0s_S_I)
//============================================================================


struct  BFu0s_S_Ip  {
  unsigned short  :0;
  short v1;
  int *v2;
};
//SIG(1 BFu0s_S_Ip) C1{ Fs:0 Fs Fp}



static void Test_BFu0s_S_Ip()
{
  {
    init_simple_test("BFu0s_S_Ip");
    static STRUCT_IF_C BFu0s_S_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_S_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_S_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Ip, BFu0s_S_Ip)
//============================================================================


struct  BFu0s_S_L  {
  unsigned short  :0;
  short v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_S_L) C1{ Fs:0 Fs FL}



static void Test_BFu0s_S_L()
{
  {
    init_simple_test("BFu0s_S_L");
    static STRUCT_IF_C BFu0s_S_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_S_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_L)");
    check_field_offset(lv, v1, 0, "BFu0s_S_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_S_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_L, BFu0s_S_L)
//============================================================================


struct  BFu0s_S_S  {
  unsigned short  :0;
  short v1;
  short v2;
};
//SIG(1 BFu0s_S_S) C1{ Fs:0 Fs[2]}



static void Test_BFu0s_S_S()
{
  {
    init_simple_test("BFu0s_S_S");
    static STRUCT_IF_C BFu0s_S_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_S)");
    check_field_offset(lv, v1, 0, "BFu0s_S_S.v1");
    check_field_offset(lv, v2, 2, "BFu0s_S_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_S, BFu0s_S_S)
//============================================================================


struct  BFu0s_S_Uc  {
  unsigned short  :0;
  short v1;
  unsigned char v2;
};
//SIG(1 BFu0s_S_Uc) C1{ Fs:0 Fs Fc}



static void Test_BFu0s_S_Uc()
{
  {
    init_simple_test("BFu0s_S_Uc");
    static STRUCT_IF_C BFu0s_S_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Uc.v1");
    check_field_offset(lv, v2, 2, "BFu0s_S_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Uc, BFu0s_S_Uc)
//============================================================================


struct  BFu0s_S_Ui  {
  unsigned short  :0;
  short v1;
  unsigned int v2;
};
//SIG(1 BFu0s_S_Ui) C1{ Fs:0 Fs Fi}



static void Test_BFu0s_S_Ui()
{
  {
    init_simple_test("BFu0s_S_Ui");
    static STRUCT_IF_C BFu0s_S_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_S_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_S_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_S_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Ui, BFu0s_S_Ui)
//============================================================================


struct  BFu0s_S_Ul  {
  unsigned short  :0;
  short v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_S_Ul) C1{ Fs:0 Fs FL}



static void Test_BFu0s_S_Ul()
{
  {
    init_simple_test("BFu0s_S_Ul");
    static STRUCT_IF_C BFu0s_S_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_S_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_S_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Ul, BFu0s_S_Ul)
//============================================================================


struct  BFu0s_S_Us  {
  unsigned short  :0;
  short v1;
  unsigned short v2;
};
//SIG(1 BFu0s_S_Us) C1{ Fs:0 Fs[2]}



static void Test_BFu0s_S_Us()
{
  {
    init_simple_test("BFu0s_S_Us");
    static STRUCT_IF_C BFu0s_S_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_S_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_S_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0s_S_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Us, BFu0s_S_Us)
//============================================================================


struct  BFu0s_S_Vp  {
  unsigned short  :0;
  short v1;
  void *v2;
};
//SIG(1 BFu0s_S_Vp) C1{ Fs:0 Fs Fp}



static void Test_BFu0s_S_Vp()
{
  {
    init_simple_test("BFu0s_S_Vp");
    static STRUCT_IF_C BFu0s_S_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_S_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_S_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_S_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_S_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_S_Vp, BFu0s_S_Vp)
//============================================================================


struct  BFu0s_Uc  {
  unsigned short  :0;
  unsigned char v1;
};
//SIG(1 BFu0s_Uc) C1{ Fs:0 Fc}



static void Test_BFu0s_Uc()
{
  {
    init_simple_test("BFu0s_Uc");
    static STRUCT_IF_C BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc, BFu0s_Uc)
//============================================================================


struct  BFu0s_Uc_BFu0c  {
  unsigned short  :0;
  unsigned char v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_Uc_BFu0c) C1{ Fs:0 Fc Fc:0}



static void Test_BFu0s_Uc_BFu0c()
{
  {
    init_simple_test("BFu0s_Uc_BFu0c");
    static STRUCT_IF_C BFu0s_Uc_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0s_Uc_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu0c, BFu0s_Uc_BFu0c)
//============================================================================


struct  BFu0s_Uc_BFu0i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_Uc_BFu0i) C1{ Fs:0 Fc Fi:0}



static void Test_BFu0s_Uc_BFu0i()
{
  {
    init_simple_test("BFu0s_Uc_BFu0i");
    static STRUCT_IF_C BFu0s_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu0i, BFu0s_Uc_BFu0i)
//============================================================================


struct  BFu0s_Uc_BFu0ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_Uc_BFu0ll) C1{ Fs:0 Fc FL:0}



static void Test_BFu0s_Uc_BFu0ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu0ll");
    static STRUCT_IF_C BFu0s_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu0ll, BFu0s_Uc_BFu0ll)
//============================================================================


struct  BFu0s_Uc_BFu0s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_Uc_BFu0s) C1{ Fs:0 Fc Fs:0}



static void Test_BFu0s_Uc_BFu0s()
{
  {
    init_simple_test("BFu0s_Uc_BFu0s");
    static STRUCT_IF_C BFu0s_Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu0s, BFu0s_Uc_BFu0s)
//============================================================================


struct  BFu0s_Uc_BFu15i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_Uc_BFu15i) C1{ Fs:0 Fc Fi:15}



static void Test_BFu0s_Uc_BFu15i()
{
  {
    init_simple_test("BFu0s_Uc_BFu15i");
    static STRUCT_IF_C BFu0s_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0s_Uc_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0s_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu15i, BFu0s_Uc_BFu15i)
//============================================================================


struct  BFu0s_Uc_BFu15ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_Uc_BFu15ll) C1{ Fs:0 Fc FL:15}



static void Test_BFu0s_Uc_BFu15ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu15ll");
    static STRUCT_IF_C BFu0s_Uc_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0s_Uc_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0s_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu15ll, BFu0s_Uc_BFu15ll)
//============================================================================


struct  BFu0s_Uc_BFu15s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_Uc_BFu15s) C1{ Fs:0 Fc Fs:15}



static void Test_BFu0s_Uc_BFu15s()
{
  {
    init_simple_test("BFu0s_Uc_BFu15s");
    static STRUCT_IF_C BFu0s_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_Uc_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu15s, BFu0s_Uc_BFu15s)
//============================================================================


struct  BFu0s_Uc_BFu16i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_Uc_BFu16i) C1{ Fs:0 Fc Fi:16}



static void Test_BFu0s_Uc_BFu16i()
{
  {
    init_simple_test("BFu0s_Uc_BFu16i");
    static STRUCT_IF_C BFu0s_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0s_Uc_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0s_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu16i, BFu0s_Uc_BFu16i)
//============================================================================


struct  BFu0s_Uc_BFu16ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_Uc_BFu16ll) C1{ Fs:0 Fc FL:16}



static void Test_BFu0s_Uc_BFu16ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu16ll");
    static STRUCT_IF_C BFu0s_Uc_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0s_Uc_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0s_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu16ll, BFu0s_Uc_BFu16ll)
//============================================================================


struct  BFu0s_Uc_BFu16s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_Uc_BFu16s) C1{ Fs:0 Fc Fs:16}



static void Test_BFu0s_Uc_BFu16s()
{
  {
    init_simple_test("BFu0s_Uc_BFu16s");
    static STRUCT_IF_C BFu0s_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_Uc_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu16s, BFu0s_Uc_BFu16s)
//============================================================================


struct  BFu0s_Uc_BFu17i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_Uc_BFu17i) C1{ Fs:0 Fc Fi:17}



static void Test_BFu0s_Uc_BFu17i()
{
  {
    init_simple_test("BFu0s_Uc_BFu17i");
    static STRUCT_IF_C BFu0s_Uc_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0s_Uc_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0s_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu17i, BFu0s_Uc_BFu17i)
//============================================================================


struct  BFu0s_Uc_BFu17ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_Uc_BFu17ll) C1{ Fs:0 Fc FL:17}



static void Test_BFu0s_Uc_BFu17ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu17ll");
    static STRUCT_IF_C BFu0s_Uc_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0s_Uc_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0s_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu17ll, BFu0s_Uc_BFu17ll)
//============================================================================


struct  BFu0s_Uc_BFu1c  {
  unsigned short  :0;
  unsigned char v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_Uc_BFu1c) C1{ Fs:0 Fc Fc:1}



static void Test_BFu0s_Uc_BFu1c()
{
  {
    init_simple_test("BFu0s_Uc_BFu1c");
    static STRUCT_IF_C BFu0s_Uc_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0s_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu1c, BFu0s_Uc_BFu1c)
//============================================================================


struct  BFu0s_Uc_BFu1i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_Uc_BFu1i) C1{ Fs:0 Fc Fi:1}



static void Test_BFu0s_Uc_BFu1i()
{
  {
    init_simple_test("BFu0s_Uc_BFu1i");
    static STRUCT_IF_C BFu0s_Uc_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0s_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu1i, BFu0s_Uc_BFu1i)
//============================================================================


struct  BFu0s_Uc_BFu1ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_Uc_BFu1ll) C1{ Fs:0 Fc FL:1}



static void Test_BFu0s_Uc_BFu1ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu1ll");
    static STRUCT_IF_C BFu0s_Uc_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0s_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu1ll, BFu0s_Uc_BFu1ll)
//============================================================================


struct  BFu0s_Uc_BFu1s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_Uc_BFu1s) C1{ Fs:0 Fc Fs:1}



static void Test_BFu0s_Uc_BFu1s()
{
  {
    init_simple_test("BFu0s_Uc_BFu1s");
    static STRUCT_IF_C BFu0s_Uc_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0s_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu1s, BFu0s_Uc_BFu1s)
//============================================================================


struct  BFu0s_Uc_BFu31i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_Uc_BFu31i) C1{ Fs:0 Fc Fi:31}



static void Test_BFu0s_Uc_BFu31i()
{
  {
    init_simple_test("BFu0s_Uc_BFu31i");
    static STRUCT_IF_C BFu0s_Uc_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_Uc_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu31i, BFu0s_Uc_BFu31i)
//============================================================================


struct  BFu0s_Uc_BFu31ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_Uc_BFu31ll) C1{ Fs:0 Fc FL:31}



static void Test_BFu0s_Uc_BFu31ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu31ll");
    static STRUCT_IF_C BFu0s_Uc_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0s_Uc_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0s_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu31ll, BFu0s_Uc_BFu31ll)
//============================================================================


struct  BFu0s_Uc_BFu32i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_Uc_BFu32i) C1{ Fs:0 Fc Fi:32}



static void Test_BFu0s_Uc_BFu32i()
{
  {
    init_simple_test("BFu0s_Uc_BFu32i");
    static STRUCT_IF_C BFu0s_Uc_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_Uc_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu32i, BFu0s_Uc_BFu32i)
//============================================================================


struct  BFu0s_Uc_BFu32ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_Uc_BFu32ll) C1{ Fs:0 Fc FL:32}



static void Test_BFu0s_Uc_BFu32ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu32ll");
    static STRUCT_IF_C BFu0s_Uc_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0s_Uc_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0s_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu32ll, BFu0s_Uc_BFu32ll)
//============================================================================


struct  BFu0s_Uc_BFu33  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_Uc_BFu33) C1{ Fs:0 Fc FL:33}



static void Test_BFu0s_Uc_BFu33()
{
  {
    init_simple_test("BFu0s_Uc_BFu33");
    static STRUCT_IF_C BFu0s_Uc_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0s_Uc_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0s_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu33, BFu0s_Uc_BFu33)
//============================================================================


struct  BFu0s_Uc_BFu7c  {
  unsigned short  :0;
  unsigned char v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_Uc_BFu7c) C1{ Fs:0 Fc Fc:7}



static void Test_BFu0s_Uc_BFu7c()
{
  {
    init_simple_test("BFu0s_Uc_BFu7c");
    static STRUCT_IF_C BFu0s_Uc_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0s_Uc_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0s_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu7c, BFu0s_Uc_BFu7c)
//============================================================================


struct  BFu0s_Uc_BFu7i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_Uc_BFu7i) C1{ Fs:0 Fc Fi:7}



static void Test_BFu0s_Uc_BFu7i()
{
  {
    init_simple_test("BFu0s_Uc_BFu7i");
    static STRUCT_IF_C BFu0s_Uc_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0s_Uc_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0s_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu7i, BFu0s_Uc_BFu7i)
//============================================================================


struct  BFu0s_Uc_BFu7ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_Uc_BFu7ll) C1{ Fs:0 Fc FL:7}



static void Test_BFu0s_Uc_BFu7ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu7ll");
    static STRUCT_IF_C BFu0s_Uc_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0s_Uc_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0s_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu7ll, BFu0s_Uc_BFu7ll)
//============================================================================


struct  BFu0s_Uc_BFu7s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_Uc_BFu7s) C1{ Fs:0 Fc Fs:7}



static void Test_BFu0s_Uc_BFu7s()
{
  {
    init_simple_test("BFu0s_Uc_BFu7s");
    static STRUCT_IF_C BFu0s_Uc_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0s_Uc_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0s_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu7s, BFu0s_Uc_BFu7s)
//============================================================================


struct  BFu0s_Uc_BFu8c  {
  unsigned short  :0;
  unsigned char v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_Uc_BFu8c) C1{ Fs:0 Fc Fc:8}



static void Test_BFu0s_Uc_BFu8c()
{
  {
    init_simple_test("BFu0s_Uc_BFu8c");
    static STRUCT_IF_C BFu0s_Uc_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_Uc_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu8c, BFu0s_Uc_BFu8c)
//============================================================================


struct  BFu0s_Uc_BFu8i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_Uc_BFu8i) C1{ Fs:0 Fc Fi:8}



static void Test_BFu0s_Uc_BFu8i()
{
  {
    init_simple_test("BFu0s_Uc_BFu8i");
    static STRUCT_IF_C BFu0s_Uc_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_Uc_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu8i, BFu0s_Uc_BFu8i)
//============================================================================


struct  BFu0s_Uc_BFu8ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_Uc_BFu8ll) C1{ Fs:0 Fc FL:8}



static void Test_BFu0s_Uc_BFu8ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu8ll");
    static STRUCT_IF_C BFu0s_Uc_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_Uc_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu8ll, BFu0s_Uc_BFu8ll)
//============================================================================


struct  BFu0s_Uc_BFu8s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_Uc_BFu8s) C1{ Fs:0 Fc Fs:8}



static void Test_BFu0s_Uc_BFu8s()
{
  {
    init_simple_test("BFu0s_Uc_BFu8s");
    static STRUCT_IF_C BFu0s_Uc_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0s_Uc_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0s_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu8s, BFu0s_Uc_BFu8s)
//============================================================================


struct  BFu0s_Uc_BFu9i  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_Uc_BFu9i) C1{ Fs:0 Fc Fi:9}



static void Test_BFu0s_Uc_BFu9i()
{
  {
    init_simple_test("BFu0s_Uc_BFu9i");
    static STRUCT_IF_C BFu0s_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0s_Uc_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0s_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu9i, BFu0s_Uc_BFu9i)
//============================================================================


struct  BFu0s_Uc_BFu9ll  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_Uc_BFu9ll) C1{ Fs:0 Fc FL:9}



static void Test_BFu0s_Uc_BFu9ll()
{
  {
    init_simple_test("BFu0s_Uc_BFu9ll");
    static STRUCT_IF_C BFu0s_Uc_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Uc_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0s_Uc_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0s_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu9ll, BFu0s_Uc_BFu9ll)
//============================================================================


struct  BFu0s_Uc_BFu9s  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_Uc_BFu9s) C1{ Fs:0 Fc Fs:9}



static void Test_BFu0s_Uc_BFu9s()
{
  {
    init_simple_test("BFu0s_Uc_BFu9s");
    static STRUCT_IF_C BFu0s_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_Uc_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_BFu9s, BFu0s_Uc_BFu9s)
//============================================================================


struct  BFu0s_Uc_C  {
  unsigned short  :0;
  unsigned char v1;
  char v2;
};
//SIG(1 BFu0s_Uc_C) C1{ Fs:0 Fc[2]}



static void Test_BFu0s_Uc_C()
{
  {
    init_simple_test("BFu0s_Uc_C");
    static STRUCT_IF_C BFu0s_Uc_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_C.v1");
    check_field_offset(lv, v2, 1, "BFu0s_Uc_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_C, BFu0s_Uc_C)
//============================================================================


struct  BFu0s_Uc_D  {
  unsigned short  :0;
  unsigned char v1;
  double v2;
};
//SIG(1 BFu0s_Uc_D) C1{ Fs:0 Fc FL}



static void Test_BFu0s_Uc_D()
{
  {
    init_simple_test("BFu0s_Uc_D");
    static STRUCT_IF_C BFu0s_Uc_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Uc_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Uc_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_D, BFu0s_Uc_D)
//============================================================================


struct  BFu0s_Uc_F  {
  unsigned short  :0;
  unsigned char v1;
  float v2;
};
//SIG(1 BFu0s_Uc_F) C1{ Fs:0 Fc Fi}



static void Test_BFu0s_Uc_F()
{
  {
    init_simple_test("BFu0s_Uc_F");
    static STRUCT_IF_C BFu0s_Uc_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Uc_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_F, BFu0s_Uc_F)
//============================================================================


struct  BFu0s_Uc_I  {
  unsigned short  :0;
  unsigned char v1;
  int v2;
};
//SIG(1 BFu0s_Uc_I) C1{ Fs:0 Fc Fi}



static void Test_BFu0s_Uc_I()
{
  {
    init_simple_test("BFu0s_Uc_I");
    static STRUCT_IF_C BFu0s_Uc_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Uc_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_I, BFu0s_Uc_I)
//============================================================================


struct  BFu0s_Uc_Ip  {
  unsigned short  :0;
  unsigned char v1;
  int *v2;
};
//SIG(1 BFu0s_Uc_Ip) C1{ Fs:0 Fc Fp}



static void Test_BFu0s_Uc_Ip()
{
  {
    init_simple_test("BFu0s_Uc_Ip");
    static STRUCT_IF_C BFu0s_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Uc_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Ip, BFu0s_Uc_Ip)
//============================================================================


struct  BFu0s_Uc_L  {
  unsigned short  :0;
  unsigned char v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_Uc_L) C1{ Fs:0 Fc FL}



static void Test_BFu0s_Uc_L()
{
  {
    init_simple_test("BFu0s_Uc_L");
    static STRUCT_IF_C BFu0s_Uc_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Uc_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_L, BFu0s_Uc_L)
//============================================================================


struct  BFu0s_Uc_S  {
  unsigned short  :0;
  unsigned char v1;
  short v2;
};
//SIG(1 BFu0s_Uc_S) C1{ Fs:0 Fc Fs}



static void Test_BFu0s_Uc_S()
{
  {
    init_simple_test("BFu0s_Uc_S");
    static STRUCT_IF_C BFu0s_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_S.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Uc_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_S, BFu0s_Uc_S)
//============================================================================


struct  BFu0s_Uc_Uc  {
  unsigned short  :0;
  unsigned char v1;
  unsigned char v2;
};
//SIG(1 BFu0s_Uc_Uc) C1{ Fs:0 Fc[2]}



static void Test_BFu0s_Uc_Uc()
{
  {
    init_simple_test("BFu0s_Uc_Uc");
    static STRUCT_IF_C BFu0s_Uc_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Uc_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0s_Uc_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "BFu0s_Uc_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Uc, BFu0s_Uc_Uc)
//============================================================================


struct  BFu0s_Uc_Ui  {
  unsigned short  :0;
  unsigned char v1;
  unsigned int v2;
};
//SIG(1 BFu0s_Uc_Ui) C1{ Fs:0 Fc Fi}



static void Test_BFu0s_Uc_Ui()
{
  {
    init_simple_test("BFu0s_Uc_Ui");
    static STRUCT_IF_C BFu0s_Uc_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Uc_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Uc_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Uc_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Ui, BFu0s_Uc_Ui)
//============================================================================


struct  BFu0s_Uc_Ul  {
  unsigned short  :0;
  unsigned char v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_Uc_Ul) C1{ Fs:0 Fc FL}



static void Test_BFu0s_Uc_Ul()
{
  {
    init_simple_test("BFu0s_Uc_Ul");
    static STRUCT_IF_C BFu0s_Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Uc_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Ul, BFu0s_Uc_Ul)
//============================================================================


struct  BFu0s_Uc_Us  {
  unsigned short  :0;
  unsigned char v1;
  unsigned short v2;
};
//SIG(1 BFu0s_Uc_Us) C1{ Fs:0 Fc Fs}



static void Test_BFu0s_Uc_Us()
{
  {
    init_simple_test("BFu0s_Uc_Us");
    static STRUCT_IF_C BFu0s_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Uc_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Uc_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Uc_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Us, BFu0s_Uc_Us)
//============================================================================


struct  BFu0s_Uc_Vp  {
  unsigned short  :0;
  unsigned char v1;
  void *v2;
};
//SIG(1 BFu0s_Uc_Vp) C1{ Fs:0 Fc Fp}



static void Test_BFu0s_Uc_Vp()
{
  {
    init_simple_test("BFu0s_Uc_Vp");
    static STRUCT_IF_C BFu0s_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Uc_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Uc_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Uc_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Uc_Vp, BFu0s_Uc_Vp)
//============================================================================


struct  BFu0s_Ui  {
  unsigned short  :0;
  unsigned int v1;
};
//SIG(1 BFu0s_Ui) C1{ Fs:0 Fi}



static void Test_BFu0s_Ui()
{
  {
    init_simple_test("BFu0s_Ui");
    static STRUCT_IF_C BFu0s_Ui lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui, BFu0s_Ui)
//============================================================================


struct  BFu0s_Ui_BFu0c  {
  unsigned short  :0;
  unsigned int v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_Ui_BFu0c) C1{ Fs:0 Fi Fc:0}



static void Test_BFu0s_Ui_BFu0c()
{
  {
    init_simple_test("BFu0s_Ui_BFu0c");
    static STRUCT_IF_C BFu0s_Ui_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu0c, BFu0s_Ui_BFu0c)
//============================================================================


struct  BFu0s_Ui_BFu0i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_Ui_BFu0i) C1{ Fs:0 Fi Fi:0}



static void Test_BFu0s_Ui_BFu0i()
{
  {
    init_simple_test("BFu0s_Ui_BFu0i");
    static STRUCT_IF_C BFu0s_Ui_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu0i, BFu0s_Ui_BFu0i)
//============================================================================


struct  BFu0s_Ui_BFu0ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_Ui_BFu0ll) C1{ Fs:0 Fi FL:0}



static void Test_BFu0s_Ui_BFu0ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu0ll");
    static STRUCT_IF_C BFu0s_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0s_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu0ll, BFu0s_Ui_BFu0ll)
//============================================================================


struct  BFu0s_Ui_BFu0s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_Ui_BFu0s) C1{ Fs:0 Fi Fs:0}



static void Test_BFu0s_Ui_BFu0s()
{
  {
    init_simple_test("BFu0s_Ui_BFu0s");
    static STRUCT_IF_C BFu0s_Ui_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu0s, BFu0s_Ui_BFu0s)
//============================================================================


struct  BFu0s_Ui_BFu15i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_Ui_BFu15i) C1{ Fs:0 Fi Fi:15}



static void Test_BFu0s_Ui_BFu15i()
{
  {
    init_simple_test("BFu0s_Ui_BFu15i");
    static STRUCT_IF_C BFu0s_Ui_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_Ui_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu15i, BFu0s_Ui_BFu15i)
//============================================================================


struct  BFu0s_Ui_BFu15ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_Ui_BFu15ll) C1{ Fs:0 Fi FL:15}



static void Test_BFu0s_Ui_BFu15ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu15ll");
    static STRUCT_IF_C BFu0s_Ui_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_Ui_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu15ll, BFu0s_Ui_BFu15ll)
//============================================================================


struct  BFu0s_Ui_BFu15s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_Ui_BFu15s) C1{ Fs:0 Fi Fs:15}



static void Test_BFu0s_Ui_BFu15s()
{
  {
    init_simple_test("BFu0s_Ui_BFu15s");
    static STRUCT_IF_C BFu0s_Ui_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0s_Ui_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0s_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu15s, BFu0s_Ui_BFu15s)
//============================================================================


struct  BFu0s_Ui_BFu16i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_Ui_BFu16i) C1{ Fs:0 Fi Fi:16}



static void Test_BFu0s_Ui_BFu16i()
{
  {
    init_simple_test("BFu0s_Ui_BFu16i");
    static STRUCT_IF_C BFu0s_Ui_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_Ui_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu16i, BFu0s_Ui_BFu16i)
//============================================================================


struct  BFu0s_Ui_BFu16ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_Ui_BFu16ll) C1{ Fs:0 Fi FL:16}



static void Test_BFu0s_Ui_BFu16ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu16ll");
    static STRUCT_IF_C BFu0s_Ui_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_Ui_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu16ll, BFu0s_Ui_BFu16ll)
//============================================================================


struct  BFu0s_Ui_BFu16s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_Ui_BFu16s) C1{ Fs:0 Fi Fs:16}



static void Test_BFu0s_Ui_BFu16s()
{
  {
    init_simple_test("BFu0s_Ui_BFu16s");
    static STRUCT_IF_C BFu0s_Ui_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0s_Ui_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0s_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu16s, BFu0s_Ui_BFu16s)
//============================================================================


struct  BFu0s_Ui_BFu17i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_Ui_BFu17i) C1{ Fs:0 Fi Fi:17}



static void Test_BFu0s_Ui_BFu17i()
{
  {
    init_simple_test("BFu0s_Ui_BFu17i");
    static STRUCT_IF_C BFu0s_Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_Ui_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu17i, BFu0s_Ui_BFu17i)
//============================================================================


struct  BFu0s_Ui_BFu17ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_Ui_BFu17ll) C1{ Fs:0 Fi FL:17}



static void Test_BFu0s_Ui_BFu17ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu17ll");
    static STRUCT_IF_C BFu0s_Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_Ui_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu17ll, BFu0s_Ui_BFu17ll)
//============================================================================


struct  BFu0s_Ui_BFu1c  {
  unsigned short  :0;
  unsigned int v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_Ui_BFu1c) C1{ Fs:0 Fi Fc:1}



static void Test_BFu0s_Ui_BFu1c()
{
  {
    init_simple_test("BFu0s_Ui_BFu1c");
    static STRUCT_IF_C BFu0s_Ui_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu1c, BFu0s_Ui_BFu1c)
//============================================================================


struct  BFu0s_Ui_BFu1i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_Ui_BFu1i) C1{ Fs:0 Fi Fi:1}



static void Test_BFu0s_Ui_BFu1i()
{
  {
    init_simple_test("BFu0s_Ui_BFu1i");
    static STRUCT_IF_C BFu0s_Ui_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu1i, BFu0s_Ui_BFu1i)
//============================================================================


struct  BFu0s_Ui_BFu1ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_Ui_BFu1ll) C1{ Fs:0 Fi FL:1}



static void Test_BFu0s_Ui_BFu1ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu1ll");
    static STRUCT_IF_C BFu0s_Ui_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu1ll, BFu0s_Ui_BFu1ll)
//============================================================================


struct  BFu0s_Ui_BFu1s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_Ui_BFu1s) C1{ Fs:0 Fi Fs:1}



static void Test_BFu0s_Ui_BFu1s()
{
  {
    init_simple_test("BFu0s_Ui_BFu1s");
    static STRUCT_IF_C BFu0s_Ui_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0s_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu1s, BFu0s_Ui_BFu1s)
//============================================================================


struct  BFu0s_Ui_BFu31i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_Ui_BFu31i) C1{ Fs:0 Fi Fi:31}



static void Test_BFu0s_Ui_BFu31i()
{
  {
    init_simple_test("BFu0s_Ui_BFu31i");
    static STRUCT_IF_C BFu0s_Ui_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_Ui_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu31i, BFu0s_Ui_BFu31i)
//============================================================================


struct  BFu0s_Ui_BFu31ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_Ui_BFu31ll) C1{ Fs:0 Fi FL:31}



static void Test_BFu0s_Ui_BFu31ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu31ll");
    static STRUCT_IF_C BFu0s_Ui_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_Ui_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu31ll, BFu0s_Ui_BFu31ll)
//============================================================================


struct  BFu0s_Ui_BFu32i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_Ui_BFu32i) C1{ Fs:0 Fi Fi:32}



static void Test_BFu0s_Ui_BFu32i()
{
  {
    init_simple_test("BFu0s_Ui_BFu32i");
    static STRUCT_IF_C BFu0s_Ui_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_Ui_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu32i, BFu0s_Ui_BFu32i)
//============================================================================


struct  BFu0s_Ui_BFu32ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_Ui_BFu32ll) C1{ Fs:0 Fi FL:32}



static void Test_BFu0s_Ui_BFu32ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu32ll");
    static STRUCT_IF_C BFu0s_Ui_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_Ui_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu32ll, BFu0s_Ui_BFu32ll)
//============================================================================


struct  BFu0s_Ui_BFu33  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_Ui_BFu33) C1{ Fs:0 Fi FL:33}



static void Test_BFu0s_Ui_BFu33()
{
  {
    init_simple_test("BFu0s_Ui_BFu33");
    static STRUCT_IF_C BFu0s_Ui_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0s_Ui_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0s_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu33, BFu0s_Ui_BFu33)
//============================================================================


struct  BFu0s_Ui_BFu7c  {
  unsigned short  :0;
  unsigned int v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_Ui_BFu7c) C1{ Fs:0 Fi Fc:7}



static void Test_BFu0s_Ui_BFu7c()
{
  {
    init_simple_test("BFu0s_Ui_BFu7c");
    static STRUCT_IF_C BFu0s_Ui_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_Ui_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu7c, BFu0s_Ui_BFu7c)
//============================================================================


struct  BFu0s_Ui_BFu7i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_Ui_BFu7i) C1{ Fs:0 Fi Fi:7}



static void Test_BFu0s_Ui_BFu7i()
{
  {
    init_simple_test("BFu0s_Ui_BFu7i");
    static STRUCT_IF_C BFu0s_Ui_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_Ui_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu7i, BFu0s_Ui_BFu7i)
//============================================================================


struct  BFu0s_Ui_BFu7ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_Ui_BFu7ll) C1{ Fs:0 Fi FL:7}



static void Test_BFu0s_Ui_BFu7ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu7ll");
    static STRUCT_IF_C BFu0s_Ui_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_Ui_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu7ll, BFu0s_Ui_BFu7ll)
//============================================================================


struct  BFu0s_Ui_BFu7s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_Ui_BFu7s) C1{ Fs:0 Fi Fs:7}



static void Test_BFu0s_Ui_BFu7s()
{
  {
    init_simple_test("BFu0s_Ui_BFu7s");
    static STRUCT_IF_C BFu0s_Ui_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0s_Ui_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0s_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu7s, BFu0s_Ui_BFu7s)
//============================================================================


struct  BFu0s_Ui_BFu8c  {
  unsigned short  :0;
  unsigned int v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_Ui_BFu8c) C1{ Fs:0 Fi Fc:8}



static void Test_BFu0s_Ui_BFu8c()
{
  {
    init_simple_test("BFu0s_Ui_BFu8c");
    static STRUCT_IF_C BFu0s_Ui_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_Ui_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu8c, BFu0s_Ui_BFu8c)
//============================================================================


struct  BFu0s_Ui_BFu8i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_Ui_BFu8i) C1{ Fs:0 Fi Fi:8}



static void Test_BFu0s_Ui_BFu8i()
{
  {
    init_simple_test("BFu0s_Ui_BFu8i");
    static STRUCT_IF_C BFu0s_Ui_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_Ui_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu8i, BFu0s_Ui_BFu8i)
//============================================================================


struct  BFu0s_Ui_BFu8ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_Ui_BFu8ll) C1{ Fs:0 Fi FL:8}



static void Test_BFu0s_Ui_BFu8ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu8ll");
    static STRUCT_IF_C BFu0s_Ui_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_Ui_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu8ll, BFu0s_Ui_BFu8ll)
//============================================================================


struct  BFu0s_Ui_BFu8s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_Ui_BFu8s) C1{ Fs:0 Fi Fs:8}



static void Test_BFu0s_Ui_BFu8s()
{
  {
    init_simple_test("BFu0s_Ui_BFu8s");
    static STRUCT_IF_C BFu0s_Ui_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0s_Ui_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0s_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu8s, BFu0s_Ui_BFu8s)
//============================================================================


struct  BFu0s_Ui_BFu9i  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_Ui_BFu9i) C1{ Fs:0 Fi Fi:9}



static void Test_BFu0s_Ui_BFu9i()
{
  {
    init_simple_test("BFu0s_Ui_BFu9i");
    static STRUCT_IF_C BFu0s_Ui_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_Ui_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu9i, BFu0s_Ui_BFu9i)
//============================================================================


struct  BFu0s_Ui_BFu9ll  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_Ui_BFu9ll) C1{ Fs:0 Fi FL:9}



static void Test_BFu0s_Ui_BFu9ll()
{
  {
    init_simple_test("BFu0s_Ui_BFu9ll");
    static STRUCT_IF_C BFu0s_Ui_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_Ui_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu9ll, BFu0s_Ui_BFu9ll)
//============================================================================


struct  BFu0s_Ui_BFu9s  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_Ui_BFu9s) C1{ Fs:0 Fi Fs:9}



static void Test_BFu0s_Ui_BFu9s()
{
  {
    init_simple_test("BFu0s_Ui_BFu9s");
    static STRUCT_IF_C BFu0s_Ui_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0s_Ui_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0s_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_BFu9s, BFu0s_Ui_BFu9s)
//============================================================================


struct  BFu0s_Ui_C  {
  unsigned short  :0;
  unsigned int v1;
  char v2;
};
//SIG(1 BFu0s_Ui_C) C1{ Fs:0 Fi Fc}



static void Test_BFu0s_Ui_C()
{
  {
    init_simple_test("BFu0s_Ui_C");
    static STRUCT_IF_C BFu0s_Ui_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_C.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_C, BFu0s_Ui_C)
//============================================================================


struct  BFu0s_Ui_D  {
  unsigned short  :0;
  unsigned int v1;
  double v2;
};
//SIG(1 BFu0s_Ui_D) C1{ Fs:0 Fi FL}



static void Test_BFu0s_Ui_D()
{
  {
    init_simple_test("BFu0s_Ui_D");
    static STRUCT_IF_C BFu0s_Ui_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ui_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_D, BFu0s_Ui_D)
//============================================================================


struct  BFu0s_Ui_F  {
  unsigned short  :0;
  unsigned int v1;
  float v2;
};
//SIG(1 BFu0s_Ui_F) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_Ui_F()
{
  {
    init_simple_test("BFu0s_Ui_F");
    static STRUCT_IF_C BFu0s_Ui_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_F, BFu0s_Ui_F)
//============================================================================


struct  BFu0s_Ui_I  {
  unsigned short  :0;
  unsigned int v1;
  int v2;
};
//SIG(1 BFu0s_Ui_I) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_Ui_I()
{
  {
    init_simple_test("BFu0s_Ui_I");
    static STRUCT_IF_C BFu0s_Ui_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_I, BFu0s_Ui_I)
//============================================================================


struct  BFu0s_Ui_Ip  {
  unsigned short  :0;
  unsigned int v1;
  int *v2;
};
//SIG(1 BFu0s_Ui_Ip) C1{ Fs:0 Fi Fp}



static void Test_BFu0s_Ui_Ip()
{
  {
    init_simple_test("BFu0s_Ui_Ip");
    static STRUCT_IF_C BFu0s_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ui_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Ip, BFu0s_Ui_Ip)
//============================================================================


struct  BFu0s_Ui_L  {
  unsigned short  :0;
  unsigned int v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_Ui_L) C1{ Fs:0 Fi FL}



static void Test_BFu0s_Ui_L()
{
  {
    init_simple_test("BFu0s_Ui_L");
    static STRUCT_IF_C BFu0s_Ui_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ui_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_L, BFu0s_Ui_L)
//============================================================================


struct  BFu0s_Ui_S  {
  unsigned short  :0;
  unsigned int v1;
  short v2;
};
//SIG(1 BFu0s_Ui_S) C1{ Fs:0 Fi Fs}



static void Test_BFu0s_Ui_S()
{
  {
    init_simple_test("BFu0s_Ui_S");
    static STRUCT_IF_C BFu0s_Ui_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_S.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_S, BFu0s_Ui_S)
//============================================================================


struct  BFu0s_Ui_Uc  {
  unsigned short  :0;
  unsigned int v1;
  unsigned char v2;
};
//SIG(1 BFu0s_Ui_Uc) C1{ Fs:0 Fi Fc}



static void Test_BFu0s_Ui_Uc()
{
  {
    init_simple_test("BFu0s_Ui_Uc");
    static STRUCT_IF_C BFu0s_Ui_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Uc, BFu0s_Ui_Uc)
//============================================================================


struct  BFu0s_Ui_Ui  {
  unsigned short  :0;
  unsigned int v1;
  unsigned int v2;
};
//SIG(1 BFu0s_Ui_Ui) C1{ Fs:0 Fi[2]}



static void Test_BFu0s_Ui_Ui()
{
  {
    init_simple_test("BFu0s_Ui_Ui");
    static STRUCT_IF_C BFu0s_Ui_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Ui, BFu0s_Ui_Ui)
//============================================================================


struct  BFu0s_Ui_Ul  {
  unsigned short  :0;
  unsigned int v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_Ui_Ul) C1{ Fs:0 Fi FL}



static void Test_BFu0s_Ui_Ul()
{
  {
    init_simple_test("BFu0s_Ui_Ul");
    static STRUCT_IF_C BFu0s_Ui_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ui_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Ul, BFu0s_Ui_Ul)
//============================================================================


struct  BFu0s_Ui_Us  {
  unsigned short  :0;
  unsigned int v1;
  unsigned short v2;
};
//SIG(1 BFu0s_Ui_Us) C1{ Fs:0 Fi Fs}



static void Test_BFu0s_Ui_Us()
{
  {
    init_simple_test("BFu0s_Ui_Us");
    static STRUCT_IF_C BFu0s_Ui_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ui_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Ui_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Ui_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Us, BFu0s_Ui_Us)
//============================================================================


struct  BFu0s_Ui_Vp  {
  unsigned short  :0;
  unsigned int v1;
  void *v2;
};
//SIG(1 BFu0s_Ui_Vp) C1{ Fs:0 Fi Fp}



static void Test_BFu0s_Ui_Vp()
{
  {
    init_simple_test("BFu0s_Ui_Vp");
    static STRUCT_IF_C BFu0s_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ui_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Ui_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Ui_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ui_Vp, BFu0s_Ui_Vp)
//============================================================================


struct  BFu0s_Ul  {
  unsigned short  :0;
  __tsu64 v1;
};
//SIG(1 BFu0s_Ul) C1{ Fs:0 FL}



static void Test_BFu0s_Ul()
{
  {
    init_simple_test("BFu0s_Ul");
    static STRUCT_IF_C BFu0s_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul, BFu0s_Ul)
//============================================================================


struct  BFu0s_Ul_BFu0c  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_Ul_BFu0c) C1{ Fs:0 FL Fc:0}



static void Test_BFu0s_Ul_BFu0c()
{
  {
    init_simple_test("BFu0s_Ul_BFu0c");
    static STRUCT_IF_C BFu0s_Ul_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu0c, BFu0s_Ul_BFu0c)
//============================================================================


struct  BFu0s_Ul_BFu0i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_Ul_BFu0i) C1{ Fs:0 FL Fi:0}



static void Test_BFu0s_Ul_BFu0i()
{
  {
    init_simple_test("BFu0s_Ul_BFu0i");
    static STRUCT_IF_C BFu0s_Ul_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu0i, BFu0s_Ul_BFu0i)
//============================================================================


struct  BFu0s_Ul_BFu0ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_Ul_BFu0ll) C1{ Fs:0 FL FL:0}



static void Test_BFu0s_Ul_BFu0ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu0ll");
    static STRUCT_IF_C BFu0s_Ul_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu0ll, BFu0s_Ul_BFu0ll)
//============================================================================


struct  BFu0s_Ul_BFu0s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_Ul_BFu0s) C1{ Fs:0 FL Fs:0}



static void Test_BFu0s_Ul_BFu0s()
{
  {
    init_simple_test("BFu0s_Ul_BFu0s");
    static STRUCT_IF_C BFu0s_Ul_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu0s, BFu0s_Ul_BFu0s)
//============================================================================


struct  BFu0s_Ul_BFu15i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_Ul_BFu15i) C1{ Fs:0 FL Fi:15}



static void Test_BFu0s_Ul_BFu15i()
{
  {
    init_simple_test("BFu0s_Ul_BFu15i");
    static STRUCT_IF_C BFu0s_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_Ul_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu15i, BFu0s_Ul_BFu15i)
//============================================================================


struct  BFu0s_Ul_BFu15ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_Ul_BFu15ll) C1{ Fs:0 FL FL:15}



static void Test_BFu0s_Ul_BFu15ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu15ll");
    static STRUCT_IF_C BFu0s_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_Ul_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu15ll, BFu0s_Ul_BFu15ll)
//============================================================================


struct  BFu0s_Ul_BFu15s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_Ul_BFu15s) C1{ Fs:0 FL Fs:15}



static void Test_BFu0s_Ul_BFu15s()
{
  {
    init_simple_test("BFu0s_Ul_BFu15s");
    static STRUCT_IF_C BFu0s_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0s_Ul_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0s_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu15s, BFu0s_Ul_BFu15s)
//============================================================================


struct  BFu0s_Ul_BFu16i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_Ul_BFu16i) C1{ Fs:0 FL Fi:16}



static void Test_BFu0s_Ul_BFu16i()
{
  {
    init_simple_test("BFu0s_Ul_BFu16i");
    static STRUCT_IF_C BFu0s_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_Ul_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu16i, BFu0s_Ul_BFu16i)
//============================================================================


struct  BFu0s_Ul_BFu16ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_Ul_BFu16ll) C1{ Fs:0 FL FL:16}



static void Test_BFu0s_Ul_BFu16ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu16ll");
    static STRUCT_IF_C BFu0s_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_Ul_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu16ll, BFu0s_Ul_BFu16ll)
//============================================================================


struct  BFu0s_Ul_BFu16s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_Ul_BFu16s) C1{ Fs:0 FL Fs:16}



static void Test_BFu0s_Ul_BFu16s()
{
  {
    init_simple_test("BFu0s_Ul_BFu16s");
    static STRUCT_IF_C BFu0s_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0s_Ul_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0s_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu16s, BFu0s_Ul_BFu16s)
//============================================================================


struct  BFu0s_Ul_BFu17i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_Ul_BFu17i) C1{ Fs:0 FL Fi:17}



static void Test_BFu0s_Ul_BFu17i()
{
  {
    init_simple_test("BFu0s_Ul_BFu17i");
    static STRUCT_IF_C BFu0s_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0s_Ul_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0s_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu17i, BFu0s_Ul_BFu17i)
//============================================================================


struct  BFu0s_Ul_BFu17ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_Ul_BFu17ll) C1{ Fs:0 FL FL:17}



static void Test_BFu0s_Ul_BFu17ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu17ll");
    static STRUCT_IF_C BFu0s_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0s_Ul_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0s_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu17ll, BFu0s_Ul_BFu17ll)
//============================================================================


struct  BFu0s_Ul_BFu1c  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_Ul_BFu1c) C1{ Fs:0 FL Fc:1}



static void Test_BFu0s_Ul_BFu1c()
{
  {
    init_simple_test("BFu0s_Ul_BFu1c");
    static STRUCT_IF_C BFu0s_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu1c, BFu0s_Ul_BFu1c)
//============================================================================


struct  BFu0s_Ul_BFu1i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_Ul_BFu1i) C1{ Fs:0 FL Fi:1}



static void Test_BFu0s_Ul_BFu1i()
{
  {
    init_simple_test("BFu0s_Ul_BFu1i");
    static STRUCT_IF_C BFu0s_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu1i, BFu0s_Ul_BFu1i)
//============================================================================


struct  BFu0s_Ul_BFu1ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_Ul_BFu1ll) C1{ Fs:0 FL FL:1}



static void Test_BFu0s_Ul_BFu1ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu1ll");
    static STRUCT_IF_C BFu0s_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu1ll, BFu0s_Ul_BFu1ll)
//============================================================================


struct  BFu0s_Ul_BFu1s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_Ul_BFu1s) C1{ Fs:0 FL Fs:1}



static void Test_BFu0s_Ul_BFu1s()
{
  {
    init_simple_test("BFu0s_Ul_BFu1s");
    static STRUCT_IF_C BFu0s_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0s_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu1s, BFu0s_Ul_BFu1s)
//============================================================================


struct  BFu0s_Ul_BFu31i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_Ul_BFu31i) C1{ Fs:0 FL Fi:31}



static void Test_BFu0s_Ul_BFu31i()
{
  {
    init_simple_test("BFu0s_Ul_BFu31i");
    static STRUCT_IF_C BFu0s_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0s_Ul_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0s_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu31i, BFu0s_Ul_BFu31i)
//============================================================================


struct  BFu0s_Ul_BFu31ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_Ul_BFu31ll) C1{ Fs:0 FL FL:31}



static void Test_BFu0s_Ul_BFu31ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu31ll");
    static STRUCT_IF_C BFu0s_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0s_Ul_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0s_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu31ll, BFu0s_Ul_BFu31ll)
//============================================================================


struct  BFu0s_Ul_BFu32i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_Ul_BFu32i) C1{ Fs:0 FL Fi:32}



static void Test_BFu0s_Ul_BFu32i()
{
  {
    init_simple_test("BFu0s_Ul_BFu32i");
    static STRUCT_IF_C BFu0s_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0s_Ul_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0s_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu32i, BFu0s_Ul_BFu32i)
//============================================================================


struct  BFu0s_Ul_BFu32ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_Ul_BFu32ll) C1{ Fs:0 FL FL:32}



static void Test_BFu0s_Ul_BFu32ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu32ll");
    static STRUCT_IF_C BFu0s_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0s_Ul_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0s_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu32ll, BFu0s_Ul_BFu32ll)
//============================================================================


struct  BFu0s_Ul_BFu33  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_Ul_BFu33) C1{ Fs:0 FL FL:33}



static void Test_BFu0s_Ul_BFu33()
{
  {
    init_simple_test("BFu0s_Ul_BFu33");
    static STRUCT_IF_C BFu0s_Ul_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0s_Ul_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0s_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu33, BFu0s_Ul_BFu33)
//============================================================================


struct  BFu0s_Ul_BFu7c  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_Ul_BFu7c) C1{ Fs:0 FL Fc:7}



static void Test_BFu0s_Ul_BFu7c()
{
  {
    init_simple_test("BFu0s_Ul_BFu7c");
    static STRUCT_IF_C BFu0s_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_Ul_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu7c, BFu0s_Ul_BFu7c)
//============================================================================


struct  BFu0s_Ul_BFu7i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_Ul_BFu7i) C1{ Fs:0 FL Fi:7}



static void Test_BFu0s_Ul_BFu7i()
{
  {
    init_simple_test("BFu0s_Ul_BFu7i");
    static STRUCT_IF_C BFu0s_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_Ul_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu7i, BFu0s_Ul_BFu7i)
//============================================================================


struct  BFu0s_Ul_BFu7ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_Ul_BFu7ll) C1{ Fs:0 FL FL:7}



static void Test_BFu0s_Ul_BFu7ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu7ll");
    static STRUCT_IF_C BFu0s_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_Ul_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu7ll, BFu0s_Ul_BFu7ll)
//============================================================================


struct  BFu0s_Ul_BFu7s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_Ul_BFu7s) C1{ Fs:0 FL Fs:7}



static void Test_BFu0s_Ul_BFu7s()
{
  {
    init_simple_test("BFu0s_Ul_BFu7s");
    static STRUCT_IF_C BFu0s_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0s_Ul_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0s_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu7s, BFu0s_Ul_BFu7s)
//============================================================================


struct  BFu0s_Ul_BFu8c  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_Ul_BFu8c) C1{ Fs:0 FL Fc:8}



static void Test_BFu0s_Ul_BFu8c()
{
  {
    init_simple_test("BFu0s_Ul_BFu8c");
    static STRUCT_IF_C BFu0s_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_Ul_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu8c, BFu0s_Ul_BFu8c)
//============================================================================


struct  BFu0s_Ul_BFu8i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_Ul_BFu8i) C1{ Fs:0 FL Fi:8}



static void Test_BFu0s_Ul_BFu8i()
{
  {
    init_simple_test("BFu0s_Ul_BFu8i");
    static STRUCT_IF_C BFu0s_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_Ul_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu8i, BFu0s_Ul_BFu8i)
//============================================================================


struct  BFu0s_Ul_BFu8ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_Ul_BFu8ll) C1{ Fs:0 FL FL:8}



static void Test_BFu0s_Ul_BFu8ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu8ll");
    static STRUCT_IF_C BFu0s_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_Ul_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu8ll, BFu0s_Ul_BFu8ll)
//============================================================================


struct  BFu0s_Ul_BFu8s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_Ul_BFu8s) C1{ Fs:0 FL Fs:8}



static void Test_BFu0s_Ul_BFu8s()
{
  {
    init_simple_test("BFu0s_Ul_BFu8s");
    static STRUCT_IF_C BFu0s_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0s_Ul_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0s_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu8s, BFu0s_Ul_BFu8s)
//============================================================================


struct  BFu0s_Ul_BFu9i  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_Ul_BFu9i) C1{ Fs:0 FL Fi:9}



static void Test_BFu0s_Ul_BFu9i()
{
  {
    init_simple_test("BFu0s_Ul_BFu9i");
    static STRUCT_IF_C BFu0s_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_Ul_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu9i, BFu0s_Ul_BFu9i)
//============================================================================


struct  BFu0s_Ul_BFu9ll  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_Ul_BFu9ll) C1{ Fs:0 FL FL:9}



static void Test_BFu0s_Ul_BFu9ll()
{
  {
    init_simple_test("BFu0s_Ul_BFu9ll");
    static STRUCT_IF_C BFu0s_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_Ul_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu9ll, BFu0s_Ul_BFu9ll)
//============================================================================


struct  BFu0s_Ul_BFu9s  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_Ul_BFu9s) C1{ Fs:0 FL Fs:9}



static void Test_BFu0s_Ul_BFu9s()
{
  {
    init_simple_test("BFu0s_Ul_BFu9s");
    static STRUCT_IF_C BFu0s_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0s_Ul_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0s_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_BFu9s, BFu0s_Ul_BFu9s)
//============================================================================


struct  BFu0s_Ul_C  {
  unsigned short  :0;
  __tsu64 v1;
  char v2;
};
//SIG(1 BFu0s_Ul_C) C1{ Fs:0 FL Fc}



static void Test_BFu0s_Ul_C()
{
  {
    init_simple_test("BFu0s_Ul_C");
    static STRUCT_IF_C BFu0s_Ul_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_C.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_C, BFu0s_Ul_C)
//============================================================================


struct  BFu0s_Ul_D  {
  unsigned short  :0;
  __tsu64 v1;
  double v2;
};
//SIG(1 BFu0s_Ul_D) C1{ Fs:0 FL[2]}



static void Test_BFu0s_Ul_D()
{
  {
    init_simple_test("BFu0s_Ul_D");
    static STRUCT_IF_C BFu0s_Ul_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_D.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_D, BFu0s_Ul_D)
//============================================================================


struct  BFu0s_Ul_F  {
  unsigned short  :0;
  __tsu64 v1;
  float v2;
};
//SIG(1 BFu0s_Ul_F) C1{ Fs:0 FL Fi}



static void Test_BFu0s_Ul_F()
{
  {
    init_simple_test("BFu0s_Ul_F");
    static STRUCT_IF_C BFu0s_Ul_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_F.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_F, BFu0s_Ul_F)
//============================================================================


struct  BFu0s_Ul_I  {
  unsigned short  :0;
  __tsu64 v1;
  int v2;
};
//SIG(1 BFu0s_Ul_I) C1{ Fs:0 FL Fi}



static void Test_BFu0s_Ul_I()
{
  {
    init_simple_test("BFu0s_Ul_I");
    static STRUCT_IF_C BFu0s_Ul_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_I.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_I, BFu0s_Ul_I)
//============================================================================


struct  BFu0s_Ul_Ip  {
  unsigned short  :0;
  __tsu64 v1;
  int *v2;
};
//SIG(1 BFu0s_Ul_Ip) C1{ Fs:0 FL Fp}



static void Test_BFu0s_Ul_Ip()
{
  {
    init_simple_test("BFu0s_Ul_Ip");
    static STRUCT_IF_C BFu0s_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Ip, BFu0s_Ul_Ip)
//============================================================================


struct  BFu0s_Ul_L  {
  unsigned short  :0;
  __tsu64 v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_Ul_L) C1{ Fs:0 FL[2]}



static void Test_BFu0s_Ul_L()
{
  {
    init_simple_test("BFu0s_Ul_L");
    static STRUCT_IF_C BFu0s_Ul_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_L.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_L, BFu0s_Ul_L)
//============================================================================


struct  BFu0s_Ul_S  {
  unsigned short  :0;
  __tsu64 v1;
  short v2;
};
//SIG(1 BFu0s_Ul_S) C1{ Fs:0 FL Fs}



static void Test_BFu0s_Ul_S()
{
  {
    init_simple_test("BFu0s_Ul_S");
    static STRUCT_IF_C BFu0s_Ul_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_S.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_S, BFu0s_Ul_S)
//============================================================================


struct  BFu0s_Ul_Uc  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned char v2;
};
//SIG(1 BFu0s_Ul_Uc) C1{ Fs:0 FL Fc}



static void Test_BFu0s_Ul_Uc()
{
  {
    init_simple_test("BFu0s_Ul_Uc");
    static STRUCT_IF_C BFu0s_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Uc, BFu0s_Ul_Uc)
//============================================================================


struct  BFu0s_Ul_Ui  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned int v2;
};
//SIG(1 BFu0s_Ul_Ui) C1{ Fs:0 FL Fi}



static void Test_BFu0s_Ul_Ui()
{
  {
    init_simple_test("BFu0s_Ul_Ui");
    static STRUCT_IF_C BFu0s_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Ui, BFu0s_Ul_Ui)
//============================================================================


struct  BFu0s_Ul_Ul  {
  unsigned short  :0;
  __tsu64 v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_Ul_Ul) C1{ Fs:0 FL[2]}



static void Test_BFu0s_Ul_Ul()
{
  {
    init_simple_test("BFu0s_Ul_Ul");
    static STRUCT_IF_C BFu0s_Ul_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0s_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Ul, BFu0s_Ul_Ul)
//============================================================================


struct  BFu0s_Ul_Us  {
  unsigned short  :0;
  __tsu64 v1;
  unsigned short v2;
};
//SIG(1 BFu0s_Ul_Us) C1{ Fs:0 FL Fs}



static void Test_BFu0s_Ul_Us()
{
  {
    init_simple_test("BFu0s_Ul_Us");
    static STRUCT_IF_C BFu0s_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Us, BFu0s_Ul_Us)
//============================================================================


struct  BFu0s_Ul_Vp  {
  unsigned short  :0;
  __tsu64 v1;
  void *v2;
};
//SIG(1 BFu0s_Ul_Vp) C1{ Fs:0 FL Fp}



static void Test_BFu0s_Ul_Vp()
{
  {
    init_simple_test("BFu0s_Ul_Vp");
    static STRUCT_IF_C BFu0s_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Ul_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0s_Ul_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Ul_Vp, BFu0s_Ul_Vp)
//============================================================================


struct  BFu0s_Us  {
  unsigned short  :0;
  unsigned short v1;
};
//SIG(1 BFu0s_Us) C1{ Fs:0 Fs}



static void Test_BFu0s_Us()
{
  {
    init_simple_test("BFu0s_Us");
    static STRUCT_IF_C BFu0s_Us lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Us.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us, BFu0s_Us)
//============================================================================


struct  BFu0s_Us_BFu0c  {
  unsigned short  :0;
  unsigned short v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_Us_BFu0c) C1{ Fs:0 Fs Fc:0}



static void Test_BFu0s_Us_BFu0c()
{
  {
    init_simple_test("BFu0s_Us_BFu0c");
    static STRUCT_IF_C BFu0s_Us_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Us_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu0c, BFu0s_Us_BFu0c)
//============================================================================


struct  BFu0s_Us_BFu0i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_Us_BFu0i) C1{ Fs:0 Fs Fi:0}



static void Test_BFu0s_Us_BFu0i()
{
  {
    init_simple_test("BFu0s_Us_BFu0i");
    static STRUCT_IF_C BFu0s_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0s_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu0i, BFu0s_Us_BFu0i)
//============================================================================


struct  BFu0s_Us_BFu0ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_Us_BFu0ll) C1{ Fs:0 Fs FL:0}



static void Test_BFu0s_Us_BFu0ll()
{
  {
    init_simple_test("BFu0s_Us_BFu0ll");
    static STRUCT_IF_C BFu0s_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0s_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu0ll, BFu0s_Us_BFu0ll)
//============================================================================


struct  BFu0s_Us_BFu0s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_Us_BFu0s) C1{ Fs:0 Fs Fs:0}



static void Test_BFu0s_Us_BFu0s()
{
  {
    init_simple_test("BFu0s_Us_BFu0s");
    static STRUCT_IF_C BFu0s_Us_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0s_Us_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu0s, BFu0s_Us_BFu0s)
//============================================================================


struct  BFu0s_Us_BFu15i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_Us_BFu15i) C1{ Fs:0 Fs Fi:15}



static void Test_BFu0s_Us_BFu15i()
{
  {
    init_simple_test("BFu0s_Us_BFu15i");
    static STRUCT_IF_C BFu0s_Us_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_Us_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu15i, BFu0s_Us_BFu15i)
//============================================================================


struct  BFu0s_Us_BFu15ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_Us_BFu15ll) C1{ Fs:0 Fs FL:15}



static void Test_BFu0s_Us_BFu15ll()
{
  {
    init_simple_test("BFu0s_Us_BFu15ll");
    static STRUCT_IF_C BFu0s_Us_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_Us_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu15ll, BFu0s_Us_BFu15ll)
//============================================================================


struct  BFu0s_Us_BFu15s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_Us_BFu15s) C1{ Fs:0 Fs Fs:15}



static void Test_BFu0s_Us_BFu15s()
{
  {
    init_simple_test("BFu0s_Us_BFu15s");
    static STRUCT_IF_C BFu0s_Us_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0s_Us_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0s_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu15s, BFu0s_Us_BFu15s)
//============================================================================


struct  BFu0s_Us_BFu16i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_Us_BFu16i) C1{ Fs:0 Fs Fi:16}



static void Test_BFu0s_Us_BFu16i()
{
  {
    init_simple_test("BFu0s_Us_BFu16i");
    static STRUCT_IF_C BFu0s_Us_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_Us_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu16i, BFu0s_Us_BFu16i)
//============================================================================


struct  BFu0s_Us_BFu16ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_Us_BFu16ll) C1{ Fs:0 Fs FL:16}



static void Test_BFu0s_Us_BFu16ll()
{
  {
    init_simple_test("BFu0s_Us_BFu16ll");
    static STRUCT_IF_C BFu0s_Us_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_Us_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu16ll, BFu0s_Us_BFu16ll)
//============================================================================


struct  BFu0s_Us_BFu16s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_Us_BFu16s) C1{ Fs:0 Fs Fs:16}



static void Test_BFu0s_Us_BFu16s()
{
  {
    init_simple_test("BFu0s_Us_BFu16s");
    static STRUCT_IF_C BFu0s_Us_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0s_Us_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0s_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu16s, BFu0s_Us_BFu16s)
//============================================================================


struct  BFu0s_Us_BFu17i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_Us_BFu17i) C1{ Fs:0 Fs Fi:17}



static void Test_BFu0s_Us_BFu17i()
{
  {
    init_simple_test("BFu0s_Us_BFu17i");
    static STRUCT_IF_C BFu0s_Us_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0s_Us_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0s_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu17i, BFu0s_Us_BFu17i)
//============================================================================


struct  BFu0s_Us_BFu17ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_Us_BFu17ll) C1{ Fs:0 Fs FL:17}



static void Test_BFu0s_Us_BFu17ll()
{
  {
    init_simple_test("BFu0s_Us_BFu17ll");
    static STRUCT_IF_C BFu0s_Us_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0s_Us_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0s_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu17ll, BFu0s_Us_BFu17ll)
//============================================================================


struct  BFu0s_Us_BFu1c  {
  unsigned short  :0;
  unsigned short v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_Us_BFu1c) C1{ Fs:0 Fs Fc:1}



static void Test_BFu0s_Us_BFu1c()
{
  {
    init_simple_test("BFu0s_Us_BFu1c");
    static STRUCT_IF_C BFu0s_Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu1c, BFu0s_Us_BFu1c)
//============================================================================


struct  BFu0s_Us_BFu1i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_Us_BFu1i) C1{ Fs:0 Fs Fi:1}



static void Test_BFu0s_Us_BFu1i()
{
  {
    init_simple_test("BFu0s_Us_BFu1i");
    static STRUCT_IF_C BFu0s_Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu1i, BFu0s_Us_BFu1i)
//============================================================================


struct  BFu0s_Us_BFu1ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_Us_BFu1ll) C1{ Fs:0 Fs FL:1}



static void Test_BFu0s_Us_BFu1ll()
{
  {
    init_simple_test("BFu0s_Us_BFu1ll");
    static STRUCT_IF_C BFu0s_Us_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu1ll, BFu0s_Us_BFu1ll)
//============================================================================


struct  BFu0s_Us_BFu1s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_Us_BFu1s) C1{ Fs:0 Fs Fs:1}



static void Test_BFu0s_Us_BFu1s()
{
  {
    init_simple_test("BFu0s_Us_BFu1s");
    static STRUCT_IF_C BFu0s_Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0s_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu1s, BFu0s_Us_BFu1s)
//============================================================================


struct  BFu0s_Us_BFu31i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_Us_BFu31i) C1{ Fs:0 Fs Fi:31}



static void Test_BFu0s_Us_BFu31i()
{
  {
    init_simple_test("BFu0s_Us_BFu31i");
    static STRUCT_IF_C BFu0s_Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0s_Us_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0s_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu31i, BFu0s_Us_BFu31i)
//============================================================================


struct  BFu0s_Us_BFu31ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_Us_BFu31ll) C1{ Fs:0 Fs FL:31}



static void Test_BFu0s_Us_BFu31ll()
{
  {
    init_simple_test("BFu0s_Us_BFu31ll");
    static STRUCT_IF_C BFu0s_Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0s_Us_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0s_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu31ll, BFu0s_Us_BFu31ll)
//============================================================================


struct  BFu0s_Us_BFu32i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_Us_BFu32i) C1{ Fs:0 Fs Fi:32}



static void Test_BFu0s_Us_BFu32i()
{
  {
    init_simple_test("BFu0s_Us_BFu32i");
    static STRUCT_IF_C BFu0s_Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0s_Us_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0s_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu32i, BFu0s_Us_BFu32i)
//============================================================================


struct  BFu0s_Us_BFu32ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_Us_BFu32ll) C1{ Fs:0 Fs FL:32}



static void Test_BFu0s_Us_BFu32ll()
{
  {
    init_simple_test("BFu0s_Us_BFu32ll");
    static STRUCT_IF_C BFu0s_Us_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0s_Us_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0s_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu32ll, BFu0s_Us_BFu32ll)
//============================================================================


struct  BFu0s_Us_BFu33  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_Us_BFu33) C1{ Fs:0 Fs FL:33}



static void Test_BFu0s_Us_BFu33()
{
  {
    init_simple_test("BFu0s_Us_BFu33");
    static STRUCT_IF_C BFu0s_Us_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0s_Us_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0s_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu33, BFu0s_Us_BFu33)
//============================================================================


struct  BFu0s_Us_BFu7c  {
  unsigned short  :0;
  unsigned short v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_Us_BFu7c) C1{ Fs:0 Fs Fc:7}



static void Test_BFu0s_Us_BFu7c()
{
  {
    init_simple_test("BFu0s_Us_BFu7c");
    static STRUCT_IF_C BFu0s_Us_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_Us_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu7c, BFu0s_Us_BFu7c)
//============================================================================


struct  BFu0s_Us_BFu7i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_Us_BFu7i) C1{ Fs:0 Fs Fi:7}



static void Test_BFu0s_Us_BFu7i()
{
  {
    init_simple_test("BFu0s_Us_BFu7i");
    static STRUCT_IF_C BFu0s_Us_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_Us_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu7i, BFu0s_Us_BFu7i)
//============================================================================


struct  BFu0s_Us_BFu7ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_Us_BFu7ll) C1{ Fs:0 Fs FL:7}



static void Test_BFu0s_Us_BFu7ll()
{
  {
    init_simple_test("BFu0s_Us_BFu7ll");
    static STRUCT_IF_C BFu0s_Us_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_Us_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu7ll, BFu0s_Us_BFu7ll)
//============================================================================


struct  BFu0s_Us_BFu7s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_Us_BFu7s) C1{ Fs:0 Fs Fs:7}



static void Test_BFu0s_Us_BFu7s()
{
  {
    init_simple_test("BFu0s_Us_BFu7s");
    static STRUCT_IF_C BFu0s_Us_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0s_Us_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0s_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu7s, BFu0s_Us_BFu7s)
//============================================================================


struct  BFu0s_Us_BFu8c  {
  unsigned short  :0;
  unsigned short v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_Us_BFu8c) C1{ Fs:0 Fs Fc:8}



static void Test_BFu0s_Us_BFu8c()
{
  {
    init_simple_test("BFu0s_Us_BFu8c");
    static STRUCT_IF_C BFu0s_Us_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_Us_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu8c, BFu0s_Us_BFu8c)
//============================================================================


struct  BFu0s_Us_BFu8i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_Us_BFu8i) C1{ Fs:0 Fs Fi:8}



static void Test_BFu0s_Us_BFu8i()
{
  {
    init_simple_test("BFu0s_Us_BFu8i");
    static STRUCT_IF_C BFu0s_Us_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_Us_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu8i, BFu0s_Us_BFu8i)
//============================================================================


struct  BFu0s_Us_BFu8ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_Us_BFu8ll) C1{ Fs:0 Fs FL:8}



static void Test_BFu0s_Us_BFu8ll()
{
  {
    init_simple_test("BFu0s_Us_BFu8ll");
    static STRUCT_IF_C BFu0s_Us_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_Us_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu8ll, BFu0s_Us_BFu8ll)
//============================================================================


struct  BFu0s_Us_BFu8s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_Us_BFu8s) C1{ Fs:0 Fs Fs:8}



static void Test_BFu0s_Us_BFu8s()
{
  {
    init_simple_test("BFu0s_Us_BFu8s");
    static STRUCT_IF_C BFu0s_Us_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0s_Us_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0s_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu8s, BFu0s_Us_BFu8s)
//============================================================================


struct  BFu0s_Us_BFu9i  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_Us_BFu9i) C1{ Fs:0 Fs Fi:9}



static void Test_BFu0s_Us_BFu9i()
{
  {
    init_simple_test("BFu0s_Us_BFu9i");
    static STRUCT_IF_C BFu0s_Us_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_Us_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu9i, BFu0s_Us_BFu9i)
//============================================================================


struct  BFu0s_Us_BFu9ll  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_Us_BFu9ll) C1{ Fs:0 Fs FL:9}



static void Test_BFu0s_Us_BFu9ll()
{
  {
    init_simple_test("BFu0s_Us_BFu9ll");
    static STRUCT_IF_C BFu0s_Us_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_Us_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu9ll, BFu0s_Us_BFu9ll)
//============================================================================


struct  BFu0s_Us_BFu9s  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_Us_BFu9s) C1{ Fs:0 Fs Fs:9}



static void Test_BFu0s_Us_BFu9s()
{
  {
    init_simple_test("BFu0s_Us_BFu9s");
    static STRUCT_IF_C BFu0s_Us_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0s_Us_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0s_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_BFu9s, BFu0s_Us_BFu9s)
//============================================================================


struct  BFu0s_Us_C  {
  unsigned short  :0;
  unsigned short v1;
  char v2;
};
//SIG(1 BFu0s_Us_C) C1{ Fs:0 Fs Fc}



static void Test_BFu0s_Us_C()
{
  {
    init_simple_test("BFu0s_Us_C");
    static STRUCT_IF_C BFu0s_Us_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_C.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Us_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_C, BFu0s_Us_C)
//============================================================================


struct  BFu0s_Us_D  {
  unsigned short  :0;
  unsigned short v1;
  double v2;
};
//SIG(1 BFu0s_Us_D) C1{ Fs:0 Fs FL}



static void Test_BFu0s_Us_D()
{
  {
    init_simple_test("BFu0s_Us_D");
    static STRUCT_IF_C BFu0s_Us_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Us_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_D, BFu0s_Us_D)
//============================================================================


struct  BFu0s_Us_F  {
  unsigned short  :0;
  unsigned short v1;
  float v2;
};
//SIG(1 BFu0s_Us_F) C1{ Fs:0 Fs Fi}



static void Test_BFu0s_Us_F()
{
  {
    init_simple_test("BFu0s_Us_F");
    static STRUCT_IF_C BFu0s_Us_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_F.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Us_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_F, BFu0s_Us_F)
//============================================================================


struct  BFu0s_Us_I  {
  unsigned short  :0;
  unsigned short v1;
  int v2;
};
//SIG(1 BFu0s_Us_I) C1{ Fs:0 Fs Fi}



static void Test_BFu0s_Us_I()
{
  {
    init_simple_test("BFu0s_Us_I");
    static STRUCT_IF_C BFu0s_Us_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_I.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Us_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_I, BFu0s_Us_I)
//============================================================================


struct  BFu0s_Us_Ip  {
  unsigned short  :0;
  unsigned short v1;
  int *v2;
};
//SIG(1 BFu0s_Us_Ip) C1{ Fs:0 Fs Fp}



static void Test_BFu0s_Us_Ip()
{
  {
    init_simple_test("BFu0s_Us_Ip");
    static STRUCT_IF_C BFu0s_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Us_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Ip, BFu0s_Us_Ip)
//============================================================================


struct  BFu0s_Us_L  {
  unsigned short  :0;
  unsigned short v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_Us_L) C1{ Fs:0 Fs FL}



static void Test_BFu0s_Us_L()
{
  {
    init_simple_test("BFu0s_Us_L");
    static STRUCT_IF_C BFu0s_Us_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Us_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_L, BFu0s_Us_L)
//============================================================================


struct  BFu0s_Us_S  {
  unsigned short  :0;
  unsigned short v1;
  short v2;
};
//SIG(1 BFu0s_Us_S) C1{ Fs:0 Fs[2]}



static void Test_BFu0s_Us_S()
{
  {
    init_simple_test("BFu0s_Us_S");
    static STRUCT_IF_C BFu0s_Us_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_S.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Us_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_S, BFu0s_Us_S)
//============================================================================


struct  BFu0s_Us_Uc  {
  unsigned short  :0;
  unsigned short v1;
  unsigned char v2;
};
//SIG(1 BFu0s_Us_Uc) C1{ Fs:0 Fs Fc}



static void Test_BFu0s_Us_Uc()
{
  {
    init_simple_test("BFu0s_Us_Uc");
    static STRUCT_IF_C BFu0s_Us_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Uc.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Us_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Uc, BFu0s_Us_Uc)
//============================================================================


struct  BFu0s_Us_Ui  {
  unsigned short  :0;
  unsigned short v1;
  unsigned int v2;
};
//SIG(1 BFu0s_Us_Ui) C1{ Fs:0 Fs Fi}



static void Test_BFu0s_Us_Ui()
{
  {
    init_simple_test("BFu0s_Us_Ui");
    static STRUCT_IF_C BFu0s_Us_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0s_Us_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0s_Us_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0s_Us_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Ui, BFu0s_Us_Ui)
//============================================================================


struct  BFu0s_Us_Ul  {
  unsigned short  :0;
  unsigned short v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_Us_Ul) C1{ Fs:0 Fs FL}



static void Test_BFu0s_Us_Ul()
{
  {
    init_simple_test("BFu0s_Us_Ul");
    static STRUCT_IF_C BFu0s_Us_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Us_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Ul, BFu0s_Us_Ul)
//============================================================================


struct  BFu0s_Us_Us  {
  unsigned short  :0;
  unsigned short v1;
  unsigned short v2;
};
//SIG(1 BFu0s_Us_Us) C1{ Fs:0 Fs[2]}



static void Test_BFu0s_Us_Us()
{
  {
    init_simple_test("BFu0s_Us_Us");
    static STRUCT_IF_C BFu0s_Us_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0s_Us_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0s_Us_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0s_Us_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Us, BFu0s_Us_Us)
//============================================================================


struct  BFu0s_Us_Vp  {
  unsigned short  :0;
  unsigned short v1;
  void *v2;
};
//SIG(1 BFu0s_Us_Vp) C1{ Fs:0 Fs Fp}



static void Test_BFu0s_Us_Vp()
{
  {
    init_simple_test("BFu0s_Us_Vp");
    static STRUCT_IF_C BFu0s_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Us_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Us_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Us_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Us_Vp, BFu0s_Us_Vp)
//============================================================================


struct  BFu0s_Vp  {
  unsigned short  :0;
  void *v1;
};
//SIG(1 BFu0s_Vp) C1{ Fs:0 Fp}



static void Test_BFu0s_Vp()
{
  {
    init_simple_test("BFu0s_Vp");
    static STRUCT_IF_C BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp, BFu0s_Vp)
//============================================================================


struct  BFu0s_Vp_BFu0c  {
  unsigned short  :0;
  void *v1;
  unsigned char  :0;
};
//SIG(1 BFu0s_Vp_BFu0c) C1{ Fs:0 Fp Fc:0}



static void Test_BFu0s_Vp_BFu0c()
{
  {
    init_simple_test("BFu0s_Vp_BFu0c");
    static STRUCT_IF_C BFu0s_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu0c.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu0c, BFu0s_Vp_BFu0c)
//============================================================================


struct  BFu0s_Vp_BFu0i  {
  unsigned short  :0;
  void *v1;
  unsigned int  :0;
};
//SIG(1 BFu0s_Vp_BFu0i) C1{ Fs:0 Fp Fi:0}



static void Test_BFu0s_Vp_BFu0i()
{
  {
    init_simple_test("BFu0s_Vp_BFu0i");
    static STRUCT_IF_C BFu0s_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu0i.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu0i, BFu0s_Vp_BFu0i)
//============================================================================


struct  BFu0s_Vp_BFu0ll  {
  unsigned short  :0;
  void *v1;
  __tsu64  :0;
};
//SIG(1 BFu0s_Vp_BFu0ll) C1{ Fs:0 Fp FL:0}



static void Test_BFu0s_Vp_BFu0ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu0ll");
    static STRUCT_IF_C BFu0s_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu0ll.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu0ll, BFu0s_Vp_BFu0ll)
//============================================================================


struct  BFu0s_Vp_BFu0s  {
  unsigned short  :0;
  void *v1;
  unsigned short  :0;
};
//SIG(1 BFu0s_Vp_BFu0s) C1{ Fs:0 Fp Fs:0}



static void Test_BFu0s_Vp_BFu0s()
{
  {
    init_simple_test("BFu0s_Vp_BFu0s");
    static STRUCT_IF_C BFu0s_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0s_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu0s.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu0s, BFu0s_Vp_BFu0s)
//============================================================================


struct  BFu0s_Vp_BFu15i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:15;
};
//SIG(1 BFu0s_Vp_BFu15i) C1{ Fs:0 Fp Fi:15}



static void Test_BFu0s_Vp_BFu15i()
{
  {
    init_simple_test("BFu0s_Vp_BFu15i");
    static STRUCT_IF_C BFu0s_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0s_Vp_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0s_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu15i, BFu0s_Vp_BFu15i)
//============================================================================


struct  BFu0s_Vp_BFu15ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0s_Vp_BFu15ll) C1{ Fs:0 Fp FL:15}



static void Test_BFu0s_Vp_BFu15ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu15ll");
    static STRUCT_IF_C BFu0s_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0s_Vp_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0s_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu15ll, BFu0s_Vp_BFu15ll)
//============================================================================


struct  BFu0s_Vp_BFu15s  {
  unsigned short  :0;
  void *v1;
  unsigned short v2:15;
};
//SIG(1 BFu0s_Vp_BFu15s) C1{ Fs:0 Fp Fs:15}



static void Test_BFu0s_Vp_BFu15s()
{
  {
    init_simple_test("BFu0s_Vp_BFu15s");
    static STRUCT_IF_C BFu0s_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0s_Vp_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0s_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu15s, BFu0s_Vp_BFu15s)
//============================================================================


struct  BFu0s_Vp_BFu16i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:16;
};
//SIG(1 BFu0s_Vp_BFu16i) C1{ Fs:0 Fp Fi:16}



static void Test_BFu0s_Vp_BFu16i()
{
  {
    init_simple_test("BFu0s_Vp_BFu16i");
    static STRUCT_IF_C BFu0s_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0s_Vp_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0s_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu16i, BFu0s_Vp_BFu16i)
//============================================================================


struct  BFu0s_Vp_BFu16ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0s_Vp_BFu16ll) C1{ Fs:0 Fp FL:16}



static void Test_BFu0s_Vp_BFu16ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu16ll");
    static STRUCT_IF_C BFu0s_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0s_Vp_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0s_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu16ll, BFu0s_Vp_BFu16ll)
//============================================================================


struct  BFu0s_Vp_BFu16s  {
  unsigned short  :0;
  void *v1;
  unsigned short v2:16;
};
//SIG(1 BFu0s_Vp_BFu16s) C1{ Fs:0 Fp Fs:16}



static void Test_BFu0s_Vp_BFu16s()
{
  {
    init_simple_test("BFu0s_Vp_BFu16s");
    static STRUCT_IF_C BFu0s_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0s_Vp_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0s_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu16s, BFu0s_Vp_BFu16s)
//============================================================================


struct  BFu0s_Vp_BFu17i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:17;
};
//SIG(1 BFu0s_Vp_BFu17i) C1{ Fs:0 Fp Fi:17}



static void Test_BFu0s_Vp_BFu17i()
{
  {
    init_simple_test("BFu0s_Vp_BFu17i");
    static STRUCT_IF_C BFu0s_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0s_Vp_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0s_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu17i, BFu0s_Vp_BFu17i)
//============================================================================


struct  BFu0s_Vp_BFu17ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0s_Vp_BFu17ll) C1{ Fs:0 Fp FL:17}



static void Test_BFu0s_Vp_BFu17ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu17ll");
    static STRUCT_IF_C BFu0s_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0s_Vp_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0s_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu17ll, BFu0s_Vp_BFu17ll)
//============================================================================


struct  BFu0s_Vp_BFu1c  {
  unsigned short  :0;
  void *v1;
  unsigned char v2:1;
};
//SIG(1 BFu0s_Vp_BFu1c) C1{ Fs:0 Fp Fc:1}



static void Test_BFu0s_Vp_BFu1c()
{
  {
    init_simple_test("BFu0s_Vp_BFu1c");
    static STRUCT_IF_C BFu0s_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu1c, BFu0s_Vp_BFu1c)
//============================================================================


struct  BFu0s_Vp_BFu1i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:1;
};
//SIG(1 BFu0s_Vp_BFu1i) C1{ Fs:0 Fp Fi:1}



static void Test_BFu0s_Vp_BFu1i()
{
  {
    init_simple_test("BFu0s_Vp_BFu1i");
    static STRUCT_IF_C BFu0s_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu1i, BFu0s_Vp_BFu1i)
//============================================================================


struct  BFu0s_Vp_BFu1ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0s_Vp_BFu1ll) C1{ Fs:0 Fp FL:1}



static void Test_BFu0s_Vp_BFu1ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu1ll");
    static STRUCT_IF_C BFu0s_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu1ll, BFu0s_Vp_BFu1ll)
//============================================================================


struct  BFu0s_Vp_BFu1s  {
  unsigned short  :0;
  void *v1;
  unsigned short v2:1;
};
//SIG(1 BFu0s_Vp_BFu1s) C1{ Fs:0 Fp Fs:1}



static void Test_BFu0s_Vp_BFu1s()
{
  {
    init_simple_test("BFu0s_Vp_BFu1s");
    static STRUCT_IF_C BFu0s_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0s_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu1s, BFu0s_Vp_BFu1s)
//============================================================================


struct  BFu0s_Vp_BFu31i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:31;
};
//SIG(1 BFu0s_Vp_BFu31i) C1{ Fs:0 Fp Fi:31}



static void Test_BFu0s_Vp_BFu31i()
{
  {
    init_simple_test("BFu0s_Vp_BFu31i");
    static STRUCT_IF_C BFu0s_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0s_Vp_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0s_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu31i, BFu0s_Vp_BFu31i)
//============================================================================


struct  BFu0s_Vp_BFu31ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0s_Vp_BFu31ll) C1{ Fs:0 Fp FL:31}



static void Test_BFu0s_Vp_BFu31ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu31ll");
    static STRUCT_IF_C BFu0s_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0s_Vp_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0s_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu31ll, BFu0s_Vp_BFu31ll)
//============================================================================


struct  BFu0s_Vp_BFu32i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:32;
};
//SIG(1 BFu0s_Vp_BFu32i) C1{ Fs:0 Fp Fi:32}



static void Test_BFu0s_Vp_BFu32i()
{
  {
    init_simple_test("BFu0s_Vp_BFu32i");
    static STRUCT_IF_C BFu0s_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0s_Vp_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0s_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu32i, BFu0s_Vp_BFu32i)
//============================================================================


struct  BFu0s_Vp_BFu32ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0s_Vp_BFu32ll) C1{ Fs:0 Fp FL:32}



static void Test_BFu0s_Vp_BFu32ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu32ll");
    static STRUCT_IF_C BFu0s_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0s_Vp_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0s_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu32ll, BFu0s_Vp_BFu32ll)
//============================================================================


struct  BFu0s_Vp_BFu33  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0s_Vp_BFu33) C1{ Fs:0 Fp FL:33}



static void Test_BFu0s_Vp_BFu33()
{
  {
    init_simple_test("BFu0s_Vp_BFu33");
    static STRUCT_IF_C BFu0s_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0s_Vp_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0s_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu33, BFu0s_Vp_BFu33)
//============================================================================


struct  BFu0s_Vp_BFu7c  {
  unsigned short  :0;
  void *v1;
  unsigned char v2:7;
};
//SIG(1 BFu0s_Vp_BFu7c) C1{ Fs:0 Fp Fc:7}



static void Test_BFu0s_Vp_BFu7c()
{
  {
    init_simple_test("BFu0s_Vp_BFu7c");
    static STRUCT_IF_C BFu0s_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Vp_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu7c, BFu0s_Vp_BFu7c)
//============================================================================


struct  BFu0s_Vp_BFu7i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:7;
};
//SIG(1 BFu0s_Vp_BFu7i) C1{ Fs:0 Fp Fi:7}



static void Test_BFu0s_Vp_BFu7i()
{
  {
    init_simple_test("BFu0s_Vp_BFu7i");
    static STRUCT_IF_C BFu0s_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Vp_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu7i, BFu0s_Vp_BFu7i)
//============================================================================


struct  BFu0s_Vp_BFu7ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0s_Vp_BFu7ll) C1{ Fs:0 Fp FL:7}



static void Test_BFu0s_Vp_BFu7ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu7ll");
    static STRUCT_IF_C BFu0s_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Vp_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu7ll, BFu0s_Vp_BFu7ll)
//============================================================================


struct  BFu0s_Vp_BFu7s  {
  unsigned short  :0;
  void *v1;
  unsigned short v2:7;
};
//SIG(1 BFu0s_Vp_BFu7s) C1{ Fs:0 Fp Fs:7}



static void Test_BFu0s_Vp_BFu7s()
{
  {
    init_simple_test("BFu0s_Vp_BFu7s");
    static STRUCT_IF_C BFu0s_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0s_Vp_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0s_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu7s, BFu0s_Vp_BFu7s)
//============================================================================


struct  BFu0s_Vp_BFu8c  {
  unsigned short  :0;
  void *v1;
  unsigned char v2:8;
};
//SIG(1 BFu0s_Vp_BFu8c) C1{ Fs:0 Fp Fc:8}



static void Test_BFu0s_Vp_BFu8c()
{
  {
    init_simple_test("BFu0s_Vp_BFu8c");
    static STRUCT_IF_C BFu0s_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Vp_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu8c, BFu0s_Vp_BFu8c)
//============================================================================


struct  BFu0s_Vp_BFu8i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:8;
};
//SIG(1 BFu0s_Vp_BFu8i) C1{ Fs:0 Fp Fi:8}



static void Test_BFu0s_Vp_BFu8i()
{
  {
    init_simple_test("BFu0s_Vp_BFu8i");
    static STRUCT_IF_C BFu0s_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Vp_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu8i, BFu0s_Vp_BFu8i)
//============================================================================


struct  BFu0s_Vp_BFu8ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0s_Vp_BFu8ll) C1{ Fs:0 Fp FL:8}



static void Test_BFu0s_Vp_BFu8ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu8ll");
    static STRUCT_IF_C BFu0s_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Vp_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu8ll, BFu0s_Vp_BFu8ll)
//============================================================================


struct  BFu0s_Vp_BFu8s  {
  unsigned short  :0;
  void *v1;
  unsigned short v2:8;
};
//SIG(1 BFu0s_Vp_BFu8s) C1{ Fs:0 Fp Fs:8}



static void Test_BFu0s_Vp_BFu8s()
{
  {
    init_simple_test("BFu0s_Vp_BFu8s");
    static STRUCT_IF_C BFu0s_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0s_Vp_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0s_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu8s, BFu0s_Vp_BFu8s)
//============================================================================


struct  BFu0s_Vp_BFu9i  {
  unsigned short  :0;
  void *v1;
  unsigned int v2:9;
};
//SIG(1 BFu0s_Vp_BFu9i) C1{ Fs:0 Fp Fi:9}



static void Test_BFu0s_Vp_BFu9i()
{
  {
    init_simple_test("BFu0s_Vp_BFu9i");
    static STRUCT_IF_C BFu0s_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0s_Vp_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0s_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu9i, BFu0s_Vp_BFu9i)
//============================================================================


struct  BFu0s_Vp_BFu9ll  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0s_Vp_BFu9ll) C1{ Fs:0 Fp FL:9}



static void Test_BFu0s_Vp_BFu9ll()
{
  {
    init_simple_test("BFu0s_Vp_BFu9ll");
    static STRUCT_IF_C BFu0s_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0s_Vp_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0s_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu9ll, BFu0s_Vp_BFu9ll)
//============================================================================


struct  BFu0s_Vp_BFu9s  {
  unsigned short  :0;
  void *v1;
  unsigned short v2:9;
};
//SIG(1 BFu0s_Vp_BFu9s) C1{ Fs:0 Fp Fs:9}



static void Test_BFu0s_Vp_BFu9s()
{
  {
    init_simple_test("BFu0s_Vp_BFu9s");
    static STRUCT_IF_C BFu0s_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0s_Vp_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0s_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_BFu9s, BFu0s_Vp_BFu9s)
//============================================================================


struct  BFu0s_Vp_C  {
  unsigned short  :0;
  void *v1;
  char v2;
};
//SIG(1 BFu0s_Vp_C) C1{ Fs:0 Fp Fc}



static void Test_BFu0s_Vp_C()
{
  {
    init_simple_test("BFu0s_Vp_C");
    static STRUCT_IF_C BFu0s_Vp_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_C)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_C, BFu0s_Vp_C)
//============================================================================


struct  BFu0s_Vp_D  {
  unsigned short  :0;
  void *v1;
  double v2;
};
//SIG(1 BFu0s_Vp_D) C1{ Fs:0 Fp FL}



static void Test_BFu0s_Vp_D()
{
  {
    init_simple_test("BFu0s_Vp_D");
    static STRUCT_IF_C BFu0s_Vp_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_D)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_D, BFu0s_Vp_D)
//============================================================================


struct  BFu0s_Vp_F  {
  unsigned short  :0;
  void *v1;
  float v2;
};
//SIG(1 BFu0s_Vp_F) C1{ Fs:0 Fp Fi}



static void Test_BFu0s_Vp_F()
{
  {
    init_simple_test("BFu0s_Vp_F");
    static STRUCT_IF_C BFu0s_Vp_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_F)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_F, BFu0s_Vp_F)
//============================================================================


struct  BFu0s_Vp_I  {
  unsigned short  :0;
  void *v1;
  int v2;
};
//SIG(1 BFu0s_Vp_I) C1{ Fs:0 Fp Fi}



static void Test_BFu0s_Vp_I()
{
  {
    init_simple_test("BFu0s_Vp_I");
    static STRUCT_IF_C BFu0s_Vp_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_I)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_I, BFu0s_Vp_I)
//============================================================================


struct  BFu0s_Vp_Ip  {
  unsigned short  :0;
  void *v1;
  int *v2;
};
//SIG(1 BFu0s_Vp_Ip) C1{ Fs:0 Fp[2]}



static void Test_BFu0s_Vp_Ip()
{
  {
    init_simple_test("BFu0s_Vp_Ip");
    static STRUCT_IF_C BFu0s_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_Ip)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Ip, BFu0s_Vp_Ip)
//============================================================================


struct  BFu0s_Vp_L  {
  unsigned short  :0;
  void *v1;
  __tsi64 v2;
};
//SIG(1 BFu0s_Vp_L) C1{ Fs:0 Fp FL}



static void Test_BFu0s_Vp_L()
{
  {
    init_simple_test("BFu0s_Vp_L");
    static STRUCT_IF_C BFu0s_Vp_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_L)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_L, BFu0s_Vp_L)
//============================================================================


struct  BFu0s_Vp_S  {
  unsigned short  :0;
  void *v1;
  short v2;
};
//SIG(1 BFu0s_Vp_S) C1{ Fs:0 Fp Fs}



static void Test_BFu0s_Vp_S()
{
  {
    init_simple_test("BFu0s_Vp_S");
    static STRUCT_IF_C BFu0s_Vp_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_S)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_S, BFu0s_Vp_S)
//============================================================================


struct  BFu0s_Vp_Uc  {
  unsigned short  :0;
  void *v1;
  unsigned char v2;
};
//SIG(1 BFu0s_Vp_Uc) C1{ Fs:0 Fp Fc}



static void Test_BFu0s_Vp_Uc()
{
  {
    init_simple_test("BFu0s_Vp_Uc");
    static STRUCT_IF_C BFu0s_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_Uc)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Uc, BFu0s_Vp_Uc)
//============================================================================


struct  BFu0s_Vp_Ui  {
  unsigned short  :0;
  void *v1;
  unsigned int v2;
};
//SIG(1 BFu0s_Vp_Ui) C1{ Fs:0 Fp Fi}



static void Test_BFu0s_Vp_Ui()
{
  {
    init_simple_test("BFu0s_Vp_Ui");
    static STRUCT_IF_C BFu0s_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_Ui)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Ui, BFu0s_Vp_Ui)
//============================================================================


struct  BFu0s_Vp_Ul  {
  unsigned short  :0;
  void *v1;
  __tsu64 v2;
};
//SIG(1 BFu0s_Vp_Ul) C1{ Fs:0 Fp FL}



static void Test_BFu0s_Vp_Ul()
{
  {
    init_simple_test("BFu0s_Vp_Ul");
    static STRUCT_IF_C BFu0s_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0s_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_Ul)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Ul, BFu0s_Vp_Ul)
//============================================================================


struct  BFu0s_Vp_Us  {
  unsigned short  :0;
  void *v1;
  unsigned short v2;
};
//SIG(1 BFu0s_Vp_Us) C1{ Fs:0 Fp Fs}



static void Test_BFu0s_Vp_Us()
{
  {
    init_simple_test("BFu0s_Vp_Us");
    static STRUCT_IF_C BFu0s_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_Us)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Us, BFu0s_Vp_Us)
//============================================================================


struct  BFu0s_Vp_Vp  {
  unsigned short  :0;
  void *v1;
  void *v2;
};
//SIG(1 BFu0s_Vp_Vp) C1{ Fs:0 Fp[2]}



static void Test_BFu0s_Vp_Vp()
{
  {
    init_simple_test("BFu0s_Vp_Vp");
    static STRUCT_IF_C BFu0s_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0s_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0s_Vp_Vp)");
    check_field_offset(lv, v1, 0, "BFu0s_Vp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0s_Vp_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0s_Vp_Vp, BFu0s_Vp_Vp)
//============================================================================


struct  BFu15i_BFu0c  {
  unsigned int v1:15;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu0c) C1{ Fi:15 Fc:0}



static void Test_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c, BFu15i_BFu0c)
//============================================================================


struct  BFu15i_BFu0c_BFu0c  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu0c_BFu0c) C1{ Fi:15 Fc:0 Fc:0}



static void Test_BFu15i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu0c");
    static STRUCT_IF_C BFu15i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu0c, BFu15i_BFu0c_BFu0c)
//============================================================================


struct  BFu15i_BFu0c_BFu0i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu0c_BFu0i) C1{ Fi:15 Fc:0 Fi:0}



static void Test_BFu15i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu0i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu0i, BFu15i_BFu0c_BFu0i)
//============================================================================


struct  BFu15i_BFu0c_BFu0ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu0c_BFu0ll) C1{ Fi:15 Fc:0 FL:0}



static void Test_BFu15i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu0ll, BFu15i_BFu0c_BFu0ll)
//============================================================================


struct  BFu15i_BFu0c_BFu0s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu0c_BFu0s) C1{ Fi:15 Fc:0 Fs:0}



static void Test_BFu15i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu0s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu0s, BFu15i_BFu0c_BFu0s)
//============================================================================


struct  BFu15i_BFu0c_BFu15i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15i_BFu0c_BFu15i) C1{ Fi:15 Fc:0 Fi:15}



static void Test_BFu15i_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu15i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu15i, BFu15i_BFu0c_BFu15i)
//============================================================================


struct  BFu15i_BFu0c_BFu15ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15i_BFu0c_BFu15ll) C1{ Fi:15 Fc:0 FL:15}



static void Test_BFu15i_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu15ll, BFu15i_BFu0c_BFu15ll)
//============================================================================


struct  BFu15i_BFu0c_BFu15s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15i_BFu0c_BFu15s) C1{ Fi:15 Fc:0 Fs:15}



static void Test_BFu15i_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu15s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu15s, BFu15i_BFu0c_BFu15s)
//============================================================================


struct  BFu15i_BFu0c_BFu16i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15i_BFu0c_BFu16i) C1{ Fi:15 Fc:0 Fi:16}



static void Test_BFu15i_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu16i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu16i, BFu15i_BFu0c_BFu16i)
//============================================================================


struct  BFu15i_BFu0c_BFu16ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15i_BFu0c_BFu16ll) C1{ Fi:15 Fc:0 FL:16}



static void Test_BFu15i_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu16ll, BFu15i_BFu0c_BFu16ll)
//============================================================================


struct  BFu15i_BFu0c_BFu16s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15i_BFu0c_BFu16s) C1{ Fi:15 Fc:0 Fs:16}



static void Test_BFu15i_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu16s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu16s, BFu15i_BFu0c_BFu16s)
//============================================================================


struct  BFu15i_BFu0c_BFu17i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15i_BFu0c_BFu17i) C1{ Fi:15 Fc:0 Fi:17}



static void Test_BFu15i_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu17i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15i_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu17i, BFu15i_BFu0c_BFu17i)
//============================================================================


struct  BFu15i_BFu0c_BFu17ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15i_BFu0c_BFu17ll) C1{ Fi:15 Fc:0 FL:17}



static void Test_BFu15i_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu15i_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu17ll, BFu15i_BFu0c_BFu17ll)
//============================================================================


struct  BFu15i_BFu0c_BFu1c  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15i_BFu0c_BFu1c) C1{ Fi:15 Fc:0 Fc:1}



static void Test_BFu15i_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu1c");
    static STRUCT_IF_C BFu15i_BFu0c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu1c, BFu15i_BFu0c_BFu1c)
//============================================================================


struct  BFu15i_BFu0c_BFu1i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15i_BFu0c_BFu1i) C1{ Fi:15 Fc:0 Fi:1}



static void Test_BFu15i_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu1i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu1i, BFu15i_BFu0c_BFu1i)
//============================================================================


struct  BFu15i_BFu0c_BFu1ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15i_BFu0c_BFu1ll) C1{ Fi:15 Fc:0 FL:1}



static void Test_BFu15i_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu1ll, BFu15i_BFu0c_BFu1ll)
//============================================================================


struct  BFu15i_BFu0c_BFu1s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15i_BFu0c_BFu1s) C1{ Fi:15 Fc:0 Fs:1}



static void Test_BFu15i_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu1s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu1s, BFu15i_BFu0c_BFu1s)
//============================================================================


struct  BFu15i_BFu0c_BFu31i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15i_BFu0c_BFu31i) C1{ Fi:15 Fc:0 Fi:31}



static void Test_BFu15i_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu31i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu31i, BFu15i_BFu0c_BFu31i)
//============================================================================


struct  BFu15i_BFu0c_BFu31ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15i_BFu0c_BFu31ll) C1{ Fi:15 Fc:0 FL:31}



static void Test_BFu15i_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu15i_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu31ll, BFu15i_BFu0c_BFu31ll)
//============================================================================


struct  BFu15i_BFu0c_BFu32i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15i_BFu0c_BFu32i) C1{ Fi:15 Fc:0 Fi:32}



static void Test_BFu15i_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu32i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu32i, BFu15i_BFu0c_BFu32i)
//============================================================================


struct  BFu15i_BFu0c_BFu32ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15i_BFu0c_BFu32ll) C1{ Fi:15 Fc:0 FL:32}



static void Test_BFu15i_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu15i_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu32ll, BFu15i_BFu0c_BFu32ll)
//============================================================================


struct  BFu15i_BFu0c_BFu33  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15i_BFu0c_BFu33) C1{ Fi:15 Fc:0 FL:33}



static void Test_BFu15i_BFu0c_BFu33()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu33");
    static STRUCT_IF_C BFu15i_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu15i_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu15i_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu33, BFu15i_BFu0c_BFu33)
//============================================================================


struct  BFu15i_BFu0c_BFu7c  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15i_BFu0c_BFu7c) C1{ Fi:15 Fc:0 Fc:7}



static void Test_BFu15i_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu7c");
    static STRUCT_IF_C BFu15i_BFu0c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu7c, BFu15i_BFu0c_BFu7c)
//============================================================================


struct  BFu15i_BFu0c_BFu7i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15i_BFu0c_BFu7i) C1{ Fi:15 Fc:0 Fi:7}



static void Test_BFu15i_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu7i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu7i, BFu15i_BFu0c_BFu7i)
//============================================================================


struct  BFu15i_BFu0c_BFu7ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15i_BFu0c_BFu7ll) C1{ Fi:15 Fc:0 FL:7}



static void Test_BFu15i_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu7ll, BFu15i_BFu0c_BFu7ll)
//============================================================================


struct  BFu15i_BFu0c_BFu7s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15i_BFu0c_BFu7s) C1{ Fi:15 Fc:0 Fs:7}



static void Test_BFu15i_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu7s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu7s, BFu15i_BFu0c_BFu7s)
//============================================================================


struct  BFu15i_BFu0c_BFu8c  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15i_BFu0c_BFu8c) C1{ Fi:15 Fc:0 Fc:8}



static void Test_BFu15i_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu8c");
    static STRUCT_IF_C BFu15i_BFu0c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu8c, BFu15i_BFu0c_BFu8c)
//============================================================================


struct  BFu15i_BFu0c_BFu8i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15i_BFu0c_BFu8i) C1{ Fi:15 Fc:0 Fi:8}



static void Test_BFu15i_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu8i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu8i, BFu15i_BFu0c_BFu8i)
//============================================================================


struct  BFu15i_BFu0c_BFu8ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15i_BFu0c_BFu8ll) C1{ Fi:15 Fc:0 FL:8}



static void Test_BFu15i_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu8ll, BFu15i_BFu0c_BFu8ll)
//============================================================================


struct  BFu15i_BFu0c_BFu8s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15i_BFu0c_BFu8s) C1{ Fi:15 Fc:0 Fs:8}



static void Test_BFu15i_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu8s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu8s, BFu15i_BFu0c_BFu8s)
//============================================================================


struct  BFu15i_BFu0c_BFu9i  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15i_BFu0c_BFu9i) C1{ Fi:15 Fc:0 Fi:9}



static void Test_BFu15i_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu9i");
    static STRUCT_IF_C BFu15i_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu9i, BFu15i_BFu0c_BFu9i)
//============================================================================


struct  BFu15i_BFu0c_BFu9ll  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15i_BFu0c_BFu9ll) C1{ Fi:15 Fc:0 FL:9}



static void Test_BFu15i_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu9ll, BFu15i_BFu0c_BFu9ll)
//============================================================================


struct  BFu15i_BFu0c_BFu9s  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15i_BFu0c_BFu9s) C1{ Fi:15 Fc:0 Fs:9}



static void Test_BFu15i_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu0c_BFu9s");
    static STRUCT_IF_C BFu15i_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_BFu9s, BFu15i_BFu0c_BFu9s)
//============================================================================


struct  BFu15i_BFu0c_C  {
  unsigned int v1:15;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu15i_BFu0c_C) C1{ Fi:15 Fc:0 Fc}



static void Test_BFu15i_BFu0c_C()
{
  {
    init_simple_test("BFu15i_BFu0c_C");
    static STRUCT_IF_C BFu15i_BFu0c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_C");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_C, BFu15i_BFu0c_C)
//============================================================================


struct  BFu15i_BFu0c_D  {
  unsigned int v1:15;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu15i_BFu0c_D) C1{ Fi:15 Fc:0 FL}



static void Test_BFu15i_BFu0c_D()
{
  {
    init_simple_test("BFu15i_BFu0c_D");
    static STRUCT_IF_C BFu15i_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_D, BFu15i_BFu0c_D)
//============================================================================


struct  BFu15i_BFu0c_F  {
  unsigned int v1:15;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu15i_BFu0c_F) C1{ Fi:15 Fc:0 Fi}



static void Test_BFu15i_BFu0c_F()
{
  {
    init_simple_test("BFu15i_BFu0c_F");
    static STRUCT_IF_C BFu15i_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_F, BFu15i_BFu0c_F)
//============================================================================


struct  BFu15i_BFu0c_I  {
  unsigned int v1:15;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu15i_BFu0c_I) C1{ Fi:15 Fc:0 Fi}



static void Test_BFu15i_BFu0c_I()
{
  {
    init_simple_test("BFu15i_BFu0c_I");
    static STRUCT_IF_C BFu15i_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_I, BFu15i_BFu0c_I)
//============================================================================


struct  BFu15i_BFu0c_Ip  {
  unsigned int v1:15;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu15i_BFu0c_Ip) C1{ Fi:15 Fc:0 Fp}



static void Test_BFu15i_BFu0c_Ip()
{
  {
    init_simple_test("BFu15i_BFu0c_Ip");
    static STRUCT_IF_C BFu15i_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Ip, BFu15i_BFu0c_Ip)
//============================================================================


struct  BFu15i_BFu0c_L  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu15i_BFu0c_L) C1{ Fi:15 Fc:0 FL}



static void Test_BFu15i_BFu0c_L()
{
  {
    init_simple_test("BFu15i_BFu0c_L");
    static STRUCT_IF_C BFu15i_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_L, BFu15i_BFu0c_L)
//============================================================================


struct  BFu15i_BFu0c_S  {
  unsigned int v1:15;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu15i_BFu0c_S) C1{ Fi:15 Fc:0 Fs}



static void Test_BFu15i_BFu0c_S()
{
  {
    init_simple_test("BFu15i_BFu0c_S");
    static STRUCT_IF_C BFu15i_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_S, BFu15i_BFu0c_S)
//============================================================================


struct  BFu15i_BFu0c_Uc  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu15i_BFu0c_Uc) C1{ Fi:15 Fc:0 Fc}



static void Test_BFu15i_BFu0c_Uc()
{
  {
    init_simple_test("BFu15i_BFu0c_Uc");
    static STRUCT_IF_C BFu15i_BFu0c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Uc, BFu15i_BFu0c_Uc)
//============================================================================


struct  BFu15i_BFu0c_Ui  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu15i_BFu0c_Ui) C1{ Fi:15 Fc:0 Fi}



static void Test_BFu15i_BFu0c_Ui()
{
  {
    init_simple_test("BFu15i_BFu0c_Ui");
    static STRUCT_IF_C BFu15i_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Ui, BFu15i_BFu0c_Ui)
//============================================================================


struct  BFu15i_BFu0c_Ul  {
  unsigned int v1:15;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu15i_BFu0c_Ul) C1{ Fi:15 Fc:0 FL}



static void Test_BFu15i_BFu0c_Ul()
{
  {
    init_simple_test("BFu15i_BFu0c_Ul");
    static STRUCT_IF_C BFu15i_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Ul, BFu15i_BFu0c_Ul)
//============================================================================


struct  BFu15i_BFu0c_Us  {
  unsigned int v1:15;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu15i_BFu0c_Us) C1{ Fi:15 Fc:0 Fs}



static void Test_BFu15i_BFu0c_Us()
{
  {
    init_simple_test("BFu15i_BFu0c_Us");
    static STRUCT_IF_C BFu15i_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Us, BFu15i_BFu0c_Us)
//============================================================================


struct  BFu15i_BFu0c_Vp  {
  unsigned int v1:15;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu15i_BFu0c_Vp) C1{ Fi:15 Fc:0 Fp}



static void Test_BFu15i_BFu0c_Vp()
{
  {
    init_simple_test("BFu15i_BFu0c_Vp");
    static STRUCT_IF_C BFu15i_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0c_Vp, BFu15i_BFu0c_Vp)
//============================================================================


struct  BFu15i_BFu0i  {
  unsigned int v1:15;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu0i) C1{ Fi:15 Fi:0}



static void Test_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i, BFu15i_BFu0i)
//============================================================================


struct  BFu15i_BFu0i_BFu0c  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu0i_BFu0c) C1{ Fi:15 Fi:0 Fc:0}



static void Test_BFu15i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu0c, BFu15i_BFu0i_BFu0c)
//============================================================================


struct  BFu15i_BFu0i_BFu0i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu0i_BFu0i) C1{ Fi:15 Fi:0 Fi:0}



static void Test_BFu15i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu0i, BFu15i_BFu0i_BFu0i)
//============================================================================


struct  BFu15i_BFu0i_BFu0ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu0i_BFu0ll) C1{ Fi:15 Fi:0 FL:0}



static void Test_BFu15i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu0ll, BFu15i_BFu0i_BFu0ll)
//============================================================================


struct  BFu15i_BFu0i_BFu0s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu0i_BFu0s) C1{ Fi:15 Fi:0 Fs:0}



static void Test_BFu15i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu0s, BFu15i_BFu0i_BFu0s)
//============================================================================


struct  BFu15i_BFu0i_BFu15i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15i_BFu0i_BFu15i) C1{ Fi:15 Fi:0 Fi:15}



static void Test_BFu15i_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu15i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15i_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu15i, BFu15i_BFu0i_BFu15i)
//============================================================================


struct  BFu15i_BFu0i_BFu15ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15i_BFu0i_BFu15ll) C1{ Fi:15 Fi:0 FL:15}



static void Test_BFu15i_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15i_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu15ll, BFu15i_BFu0i_BFu15ll)
//============================================================================


struct  BFu15i_BFu0i_BFu15s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15i_BFu0i_BFu15s) C1{ Fi:15 Fi:0 Fs:15}



static void Test_BFu15i_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu15s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15i_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu15s, BFu15i_BFu0i_BFu15s)
//============================================================================


struct  BFu15i_BFu0i_BFu16i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15i_BFu0i_BFu16i) C1{ Fi:15 Fi:0 Fi:16}



static void Test_BFu15i_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu16i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15i_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu16i, BFu15i_BFu0i_BFu16i)
//============================================================================


struct  BFu15i_BFu0i_BFu16ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15i_BFu0i_BFu16ll) C1{ Fi:15 Fi:0 FL:16}



static void Test_BFu15i_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15i_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu16ll, BFu15i_BFu0i_BFu16ll)
//============================================================================


struct  BFu15i_BFu0i_BFu16s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15i_BFu0i_BFu16s) C1{ Fi:15 Fi:0 Fs:16}



static void Test_BFu15i_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu16s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15i_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu16s, BFu15i_BFu0i_BFu16s)
//============================================================================


struct  BFu15i_BFu0i_BFu17i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15i_BFu0i_BFu17i) C1{ Fi:15 Fi:0 Fi:17}



static void Test_BFu15i_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu17i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15i_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu17i, BFu15i_BFu0i_BFu17i)
//============================================================================


struct  BFu15i_BFu0i_BFu17ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15i_BFu0i_BFu17ll) C1{ Fi:15 Fi:0 FL:17}



static void Test_BFu15i_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15i_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu17ll, BFu15i_BFu0i_BFu17ll)
//============================================================================


struct  BFu15i_BFu0i_BFu1c  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15i_BFu0i_BFu1c) C1{ Fi:15 Fi:0 Fc:1}



static void Test_BFu15i_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu1c");
    static STRUCT_IF_C BFu15i_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15i_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu1c, BFu15i_BFu0i_BFu1c)
//============================================================================


struct  BFu15i_BFu0i_BFu1i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15i_BFu0i_BFu1i) C1{ Fi:15 Fi:0 Fi:1}



static void Test_BFu15i_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu1i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15i_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu1i, BFu15i_BFu0i_BFu1i)
//============================================================================


struct  BFu15i_BFu0i_BFu1ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15i_BFu0i_BFu1ll) C1{ Fi:15 Fi:0 FL:1}



static void Test_BFu15i_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15i_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu1ll, BFu15i_BFu0i_BFu1ll)
//============================================================================


struct  BFu15i_BFu0i_BFu1s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15i_BFu0i_BFu1s) C1{ Fi:15 Fi:0 Fs:1}



static void Test_BFu15i_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu1s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15i_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu1s, BFu15i_BFu0i_BFu1s)
//============================================================================


struct  BFu15i_BFu0i_BFu31i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15i_BFu0i_BFu31i) C1{ Fi:15 Fi:0 Fi:31}



static void Test_BFu15i_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu31i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu31i, BFu15i_BFu0i_BFu31i)
//============================================================================


struct  BFu15i_BFu0i_BFu31ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15i_BFu0i_BFu31ll) C1{ Fi:15 Fi:0 FL:31}



static void Test_BFu15i_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu31ll, BFu15i_BFu0i_BFu31ll)
//============================================================================


struct  BFu15i_BFu0i_BFu32i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15i_BFu0i_BFu32i) C1{ Fi:15 Fi:0 Fi:32}



static void Test_BFu15i_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu32i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu32i, BFu15i_BFu0i_BFu32i)
//============================================================================


struct  BFu15i_BFu0i_BFu32ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15i_BFu0i_BFu32ll) C1{ Fi:15 Fi:0 FL:32}



static void Test_BFu15i_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu32ll, BFu15i_BFu0i_BFu32ll)
//============================================================================


struct  BFu15i_BFu0i_BFu33  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15i_BFu0i_BFu33) C1{ Fi:15 Fi:0 FL:33}



static void Test_BFu15i_BFu0i_BFu33()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu33");
    static STRUCT_IF_C BFu15i_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu15i_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15i_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu33, BFu15i_BFu0i_BFu33)
//============================================================================


struct  BFu15i_BFu0i_BFu7c  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15i_BFu0i_BFu7c) C1{ Fi:15 Fi:0 Fc:7}



static void Test_BFu15i_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu7c");
    static STRUCT_IF_C BFu15i_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15i_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu7c, BFu15i_BFu0i_BFu7c)
//============================================================================


struct  BFu15i_BFu0i_BFu7i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15i_BFu0i_BFu7i) C1{ Fi:15 Fi:0 Fi:7}



static void Test_BFu15i_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu7i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15i_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu7i, BFu15i_BFu0i_BFu7i)
//============================================================================


struct  BFu15i_BFu0i_BFu7ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15i_BFu0i_BFu7ll) C1{ Fi:15 Fi:0 FL:7}



static void Test_BFu15i_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15i_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu7ll, BFu15i_BFu0i_BFu7ll)
//============================================================================


struct  BFu15i_BFu0i_BFu7s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15i_BFu0i_BFu7s) C1{ Fi:15 Fi:0 Fs:7}



static void Test_BFu15i_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu7s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15i_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu7s, BFu15i_BFu0i_BFu7s)
//============================================================================


struct  BFu15i_BFu0i_BFu8c  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15i_BFu0i_BFu8c) C1{ Fi:15 Fi:0 Fc:8}



static void Test_BFu15i_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu8c");
    static STRUCT_IF_C BFu15i_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15i_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu8c, BFu15i_BFu0i_BFu8c)
//============================================================================


struct  BFu15i_BFu0i_BFu8i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15i_BFu0i_BFu8i) C1{ Fi:15 Fi:0 Fi:8}



static void Test_BFu15i_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu8i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15i_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu8i, BFu15i_BFu0i_BFu8i)
//============================================================================


struct  BFu15i_BFu0i_BFu8ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15i_BFu0i_BFu8ll) C1{ Fi:15 Fi:0 FL:8}



static void Test_BFu15i_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15i_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu8ll, BFu15i_BFu0i_BFu8ll)
//============================================================================


struct  BFu15i_BFu0i_BFu8s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15i_BFu0i_BFu8s) C1{ Fi:15 Fi:0 Fs:8}



static void Test_BFu15i_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu8s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15i_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu8s, BFu15i_BFu0i_BFu8s)
//============================================================================


struct  BFu15i_BFu0i_BFu9i  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15i_BFu0i_BFu9i) C1{ Fi:15 Fi:0 Fi:9}



static void Test_BFu15i_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu9i");
    static STRUCT_IF_C BFu15i_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15i_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu9i, BFu15i_BFu0i_BFu9i)
//============================================================================


struct  BFu15i_BFu0i_BFu9ll  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15i_BFu0i_BFu9ll) C1{ Fi:15 Fi:0 FL:9}



static void Test_BFu15i_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15i_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu9ll, BFu15i_BFu0i_BFu9ll)
//============================================================================


struct  BFu15i_BFu0i_BFu9s  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15i_BFu0i_BFu9s) C1{ Fi:15 Fi:0 Fs:9}



static void Test_BFu15i_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu0i_BFu9s");
    static STRUCT_IF_C BFu15i_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15i_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_BFu9s, BFu15i_BFu0i_BFu9s)
//============================================================================


struct  BFu15i_BFu0i_C  {
  unsigned int v1:15;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu15i_BFu0i_C) C1{ Fi:15 Fi:0 Fc}



static void Test_BFu15i_BFu0i_C()
{
  {
    init_simple_test("BFu15i_BFu0i_C");
    static STRUCT_IF_C BFu15i_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_C, BFu15i_BFu0i_C)
//============================================================================


struct  BFu15i_BFu0i_D  {
  unsigned int v1:15;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu15i_BFu0i_D) C1{ Fi:15 Fi:0 FL}



static void Test_BFu15i_BFu0i_D()
{
  {
    init_simple_test("BFu15i_BFu0i_D");
    static STRUCT_IF_C BFu15i_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_D, BFu15i_BFu0i_D)
//============================================================================


struct  BFu15i_BFu0i_F  {
  unsigned int v1:15;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu15i_BFu0i_F) C1{ Fi:15 Fi:0 Fi}



static void Test_BFu15i_BFu0i_F()
{
  {
    init_simple_test("BFu15i_BFu0i_F");
    static STRUCT_IF_C BFu15i_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_F, BFu15i_BFu0i_F)
//============================================================================


struct  BFu15i_BFu0i_I  {
  unsigned int v1:15;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu15i_BFu0i_I) C1{ Fi:15 Fi:0 Fi}



static void Test_BFu15i_BFu0i_I()
{
  {
    init_simple_test("BFu15i_BFu0i_I");
    static STRUCT_IF_C BFu15i_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_I, BFu15i_BFu0i_I)
//============================================================================


struct  BFu15i_BFu0i_Ip  {
  unsigned int v1:15;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu15i_BFu0i_Ip) C1{ Fi:15 Fi:0 Fp}



static void Test_BFu15i_BFu0i_Ip()
{
  {
    init_simple_test("BFu15i_BFu0i_Ip");
    static STRUCT_IF_C BFu15i_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Ip, BFu15i_BFu0i_Ip)
//============================================================================


struct  BFu15i_BFu0i_L  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu15i_BFu0i_L) C1{ Fi:15 Fi:0 FL}



static void Test_BFu15i_BFu0i_L()
{
  {
    init_simple_test("BFu15i_BFu0i_L");
    static STRUCT_IF_C BFu15i_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_L, BFu15i_BFu0i_L)
//============================================================================


struct  BFu15i_BFu0i_S  {
  unsigned int v1:15;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu15i_BFu0i_S) C1{ Fi:15 Fi:0 Fs}



static void Test_BFu15i_BFu0i_S()
{
  {
    init_simple_test("BFu15i_BFu0i_S");
    static STRUCT_IF_C BFu15i_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_S, BFu15i_BFu0i_S)
//============================================================================


struct  BFu15i_BFu0i_Uc  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu15i_BFu0i_Uc) C1{ Fi:15 Fi:0 Fc}



static void Test_BFu15i_BFu0i_Uc()
{
  {
    init_simple_test("BFu15i_BFu0i_Uc");
    static STRUCT_IF_C BFu15i_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Uc, BFu15i_BFu0i_Uc)
//============================================================================


struct  BFu15i_BFu0i_Ui  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu15i_BFu0i_Ui) C1{ Fi:15 Fi:0 Fi}



static void Test_BFu15i_BFu0i_Ui()
{
  {
    init_simple_test("BFu15i_BFu0i_Ui");
    static STRUCT_IF_C BFu15i_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Ui, BFu15i_BFu0i_Ui)
//============================================================================


struct  BFu15i_BFu0i_Ul  {
  unsigned int v1:15;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu15i_BFu0i_Ul) C1{ Fi:15 Fi:0 FL}



static void Test_BFu15i_BFu0i_Ul()
{
  {
    init_simple_test("BFu15i_BFu0i_Ul");
    static STRUCT_IF_C BFu15i_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Ul, BFu15i_BFu0i_Ul)
//============================================================================


struct  BFu15i_BFu0i_Us  {
  unsigned int v1:15;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu15i_BFu0i_Us) C1{ Fi:15 Fi:0 Fs}



static void Test_BFu15i_BFu0i_Us()
{
  {
    init_simple_test("BFu15i_BFu0i_Us");
    static STRUCT_IF_C BFu15i_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Us, BFu15i_BFu0i_Us)
//============================================================================


struct  BFu15i_BFu0i_Vp  {
  unsigned int v1:15;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu15i_BFu0i_Vp) C1{ Fi:15 Fi:0 Fp}



static void Test_BFu15i_BFu0i_Vp()
{
  {
    init_simple_test("BFu15i_BFu0i_Vp");
    static STRUCT_IF_C BFu15i_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0i_Vp, BFu15i_BFu0i_Vp)
//============================================================================


struct  BFu15i_BFu0ll  {
  unsigned int v1:15;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu0ll) C1{ Fi:15 FL:0}



static void Test_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll, BFu15i_BFu0ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu0c  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu0ll_BFu0c) C1{ Fi:15 FL:0 Fc:0}



static void Test_BFu15i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu0c, BFu15i_BFu0ll_BFu0c)
//============================================================================


struct  BFu15i_BFu0ll_BFu0i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu0ll_BFu0i) C1{ Fi:15 FL:0 Fi:0}



static void Test_BFu15i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu0i, BFu15i_BFu0ll_BFu0i)
//============================================================================


struct  BFu15i_BFu0ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu0ll_BFu0ll) C1{ Fi:15 FL:0 FL:0}



static void Test_BFu15i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu0ll, BFu15i_BFu0ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu0s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu0ll_BFu0s) C1{ Fi:15 FL:0 Fs:0}



static void Test_BFu15i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu0s, BFu15i_BFu0ll_BFu0s)
//============================================================================


struct  BFu15i_BFu0ll_BFu15i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15i_BFu0ll_BFu15i) C1{ Fi:15 FL:0 Fi:15}



static void Test_BFu15i_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15i_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu15i, BFu15i_BFu0ll_BFu15i)
//============================================================================


struct  BFu15i_BFu0ll_BFu15ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15i_BFu0ll_BFu15ll) C1{ Fi:15 FL:0 FL:15}



static void Test_BFu15i_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15i_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu15ll, BFu15i_BFu0ll_BFu15ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu15s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15i_BFu0ll_BFu15s) C1{ Fi:15 FL:0 Fs:15}



static void Test_BFu15i_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15i_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu15s, BFu15i_BFu0ll_BFu15s)
//============================================================================


struct  BFu15i_BFu0ll_BFu16i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15i_BFu0ll_BFu16i) C1{ Fi:15 FL:0 Fi:16}



static void Test_BFu15i_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15i_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu16i, BFu15i_BFu0ll_BFu16i)
//============================================================================


struct  BFu15i_BFu0ll_BFu16ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15i_BFu0ll_BFu16ll) C1{ Fi:15 FL:0 FL:16}



static void Test_BFu15i_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15i_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu16ll, BFu15i_BFu0ll_BFu16ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu16s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15i_BFu0ll_BFu16s) C1{ Fi:15 FL:0 Fs:16}



static void Test_BFu15i_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15i_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu16s, BFu15i_BFu0ll_BFu16s)
//============================================================================


struct  BFu15i_BFu0ll_BFu17i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15i_BFu0ll_BFu17i) C1{ Fi:15 FL:0 Fi:17}



static void Test_BFu15i_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu15i_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu17i, BFu15i_BFu0ll_BFu17i)
//============================================================================


struct  BFu15i_BFu0ll_BFu17ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15i_BFu0ll_BFu17ll) C1{ Fi:15 FL:0 FL:17}



static void Test_BFu15i_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu15i_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu17ll, BFu15i_BFu0ll_BFu17ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu1c  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15i_BFu0ll_BFu1c) C1{ Fi:15 FL:0 Fc:1}



static void Test_BFu15i_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15i_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu1c, BFu15i_BFu0ll_BFu1c)
//============================================================================


struct  BFu15i_BFu0ll_BFu1i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15i_BFu0ll_BFu1i) C1{ Fi:15 FL:0 Fi:1}



static void Test_BFu15i_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15i_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu1i, BFu15i_BFu0ll_BFu1i)
//============================================================================


struct  BFu15i_BFu0ll_BFu1ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15i_BFu0ll_BFu1ll) C1{ Fi:15 FL:0 FL:1}



static void Test_BFu15i_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15i_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu1ll, BFu15i_BFu0ll_BFu1ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu1s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15i_BFu0ll_BFu1s) C1{ Fi:15 FL:0 Fs:1}



static void Test_BFu15i_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15i_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu1s, BFu15i_BFu0ll_BFu1s)
//============================================================================


struct  BFu15i_BFu0ll_BFu31i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15i_BFu0ll_BFu31i) C1{ Fi:15 FL:0 Fi:31}



static void Test_BFu15i_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu15i_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu31i, BFu15i_BFu0ll_BFu31i)
//============================================================================


struct  BFu15i_BFu0ll_BFu31ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15i_BFu0ll_BFu31ll) C1{ Fi:15 FL:0 FL:31}



static void Test_BFu15i_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu15i_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu31ll, BFu15i_BFu0ll_BFu31ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu32i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15i_BFu0ll_BFu32i) C1{ Fi:15 FL:0 Fi:32}



static void Test_BFu15i_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu15i_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu32i, BFu15i_BFu0ll_BFu32i)
//============================================================================


struct  BFu15i_BFu0ll_BFu32ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15i_BFu0ll_BFu32ll) C1{ Fi:15 FL:0 FL:32}



static void Test_BFu15i_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu15i_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu32ll, BFu15i_BFu0ll_BFu32ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu33  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15i_BFu0ll_BFu33) C1{ Fi:15 FL:0 FL:33}



static void Test_BFu15i_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu33");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu15i_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15i_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu33, BFu15i_BFu0ll_BFu33)
//============================================================================


struct  BFu15i_BFu0ll_BFu7c  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15i_BFu0ll_BFu7c) C1{ Fi:15 FL:0 Fc:7}



static void Test_BFu15i_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15i_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu7c, BFu15i_BFu0ll_BFu7c)
//============================================================================


struct  BFu15i_BFu0ll_BFu7i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15i_BFu0ll_BFu7i) C1{ Fi:15 FL:0 Fi:7}



static void Test_BFu15i_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15i_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu7i, BFu15i_BFu0ll_BFu7i)
//============================================================================


struct  BFu15i_BFu0ll_BFu7ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15i_BFu0ll_BFu7ll) C1{ Fi:15 FL:0 FL:7}



static void Test_BFu15i_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15i_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu7ll, BFu15i_BFu0ll_BFu7ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu7s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15i_BFu0ll_BFu7s) C1{ Fi:15 FL:0 Fs:7}



static void Test_BFu15i_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15i_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu7s, BFu15i_BFu0ll_BFu7s)
//============================================================================


struct  BFu15i_BFu0ll_BFu8c  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15i_BFu0ll_BFu8c) C1{ Fi:15 FL:0 Fc:8}



static void Test_BFu15i_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15i_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu8c, BFu15i_BFu0ll_BFu8c)
//============================================================================


struct  BFu15i_BFu0ll_BFu8i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15i_BFu0ll_BFu8i) C1{ Fi:15 FL:0 Fi:8}



static void Test_BFu15i_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15i_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu8i, BFu15i_BFu0ll_BFu8i)
//============================================================================


struct  BFu15i_BFu0ll_BFu8ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15i_BFu0ll_BFu8ll) C1{ Fi:15 FL:0 FL:8}



static void Test_BFu15i_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15i_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu8ll, BFu15i_BFu0ll_BFu8ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu8s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15i_BFu0ll_BFu8s) C1{ Fi:15 FL:0 Fs:8}



static void Test_BFu15i_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15i_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu8s, BFu15i_BFu0ll_BFu8s)
//============================================================================


struct  BFu15i_BFu0ll_BFu9i  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15i_BFu0ll_BFu9i) C1{ Fi:15 FL:0 Fi:9}



static void Test_BFu15i_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu15i_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu9i, BFu15i_BFu0ll_BFu9i)
//============================================================================


struct  BFu15i_BFu0ll_BFu9ll  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15i_BFu0ll_BFu9ll) C1{ Fi:15 FL:0 FL:9}



static void Test_BFu15i_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu15i_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu9ll, BFu15i_BFu0ll_BFu9ll)
//============================================================================


struct  BFu15i_BFu0ll_BFu9s  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15i_BFu0ll_BFu9s) C1{ Fi:15 FL:0 Fs:9}



static void Test_BFu15i_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu15i_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu15i_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_BFu9s, BFu15i_BFu0ll_BFu9s)
//============================================================================


struct  BFu15i_BFu0ll_C  {
  unsigned int v1:15;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu15i_BFu0ll_C) C1{ Fi:15 FL:0 Fc}



static void Test_BFu15i_BFu0ll_C()
{
  {
    init_simple_test("BFu15i_BFu0ll_C");
    static STRUCT_IF_C BFu15i_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_C, BFu15i_BFu0ll_C)
//============================================================================


struct  BFu15i_BFu0ll_D  {
  unsigned int v1:15;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu15i_BFu0ll_D) C1{ Fi:15 FL:0 FL}



static void Test_BFu15i_BFu0ll_D()
{
  {
    init_simple_test("BFu15i_BFu0ll_D");
    static STRUCT_IF_C BFu15i_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_D, BFu15i_BFu0ll_D)
//============================================================================


struct  BFu15i_BFu0ll_F  {
  unsigned int v1:15;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu15i_BFu0ll_F) C1{ Fi:15 FL:0 Fi}



static void Test_BFu15i_BFu0ll_F()
{
  {
    init_simple_test("BFu15i_BFu0ll_F");
    static STRUCT_IF_C BFu15i_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_F, BFu15i_BFu0ll_F)
//============================================================================


struct  BFu15i_BFu0ll_I  {
  unsigned int v1:15;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu15i_BFu0ll_I) C1{ Fi:15 FL:0 Fi}



static void Test_BFu15i_BFu0ll_I()
{
  {
    init_simple_test("BFu15i_BFu0ll_I");
    static STRUCT_IF_C BFu15i_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_I, BFu15i_BFu0ll_I)
//============================================================================


struct  BFu15i_BFu0ll_Ip  {
  unsigned int v1:15;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu15i_BFu0ll_Ip) C1{ Fi:15 FL:0 Fp}



static void Test_BFu15i_BFu0ll_Ip()
{
  {
    init_simple_test("BFu15i_BFu0ll_Ip");
    static STRUCT_IF_C BFu15i_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Ip, BFu15i_BFu0ll_Ip)
//============================================================================


struct  BFu15i_BFu0ll_L  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu15i_BFu0ll_L) C1{ Fi:15 FL:0 FL}



static void Test_BFu15i_BFu0ll_L()
{
  {
    init_simple_test("BFu15i_BFu0ll_L");
    static STRUCT_IF_C BFu15i_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_L, BFu15i_BFu0ll_L)
//============================================================================


struct  BFu15i_BFu0ll_S  {
  unsigned int v1:15;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu15i_BFu0ll_S) C1{ Fi:15 FL:0 Fs}



static void Test_BFu15i_BFu0ll_S()
{
  {
    init_simple_test("BFu15i_BFu0ll_S");
    static STRUCT_IF_C BFu15i_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_S, BFu15i_BFu0ll_S)
//============================================================================


struct  BFu15i_BFu0ll_Uc  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu15i_BFu0ll_Uc) C1{ Fi:15 FL:0 Fc}



static void Test_BFu15i_BFu0ll_Uc()
{
  {
    init_simple_test("BFu15i_BFu0ll_Uc");
    static STRUCT_IF_C BFu15i_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Uc, BFu15i_BFu0ll_Uc)
//============================================================================


struct  BFu15i_BFu0ll_Ui  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu15i_BFu0ll_Ui) C1{ Fi:15 FL:0 Fi}



static void Test_BFu15i_BFu0ll_Ui()
{
  {
    init_simple_test("BFu15i_BFu0ll_Ui");
    static STRUCT_IF_C BFu15i_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Ui, BFu15i_BFu0ll_Ui)
//============================================================================


struct  BFu15i_BFu0ll_Ul  {
  unsigned int v1:15;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu15i_BFu0ll_Ul) C1{ Fi:15 FL:0 FL}



static void Test_BFu15i_BFu0ll_Ul()
{
  {
    init_simple_test("BFu15i_BFu0ll_Ul");
    static STRUCT_IF_C BFu15i_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Ul, BFu15i_BFu0ll_Ul)
//============================================================================


struct  BFu15i_BFu0ll_Us  {
  unsigned int v1:15;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu15i_BFu0ll_Us) C1{ Fi:15 FL:0 Fs}



static void Test_BFu15i_BFu0ll_Us()
{
  {
    init_simple_test("BFu15i_BFu0ll_Us");
    static STRUCT_IF_C BFu15i_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15i_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Us, BFu15i_BFu0ll_Us)
//============================================================================


struct  BFu15i_BFu0ll_Vp  {
  unsigned int v1:15;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu15i_BFu0ll_Vp) C1{ Fi:15 FL:0 Fp}



static void Test_BFu15i_BFu0ll_Vp()
{
  {
    init_simple_test("BFu15i_BFu0ll_Vp");
    static STRUCT_IF_C BFu15i_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0ll_Vp, BFu15i_BFu0ll_Vp)
//============================================================================


struct  BFu15i_BFu0s  {
  unsigned int v1:15;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu0s) C1{ Fi:15 Fs:0}



static void Test_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s, BFu15i_BFu0s)
//============================================================================


struct  BFu15i_BFu0s_BFu0c  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu0s_BFu0c) C1{ Fi:15 Fs:0 Fc:0}



static void Test_BFu15i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu0c, BFu15i_BFu0s_BFu0c)
//============================================================================


struct  BFu15i_BFu0s_BFu0i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu0s_BFu0i) C1{ Fi:15 Fs:0 Fi:0}



static void Test_BFu15i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu0i, BFu15i_BFu0s_BFu0i)
//============================================================================


struct  BFu15i_BFu0s_BFu0ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu0s_BFu0ll) C1{ Fi:15 Fs:0 FL:0}



static void Test_BFu15i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu0ll, BFu15i_BFu0s_BFu0ll)
//============================================================================


struct  BFu15i_BFu0s_BFu0s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu0s_BFu0s) C1{ Fi:15 Fs:0 Fs:0}



static void Test_BFu15i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu0s, BFu15i_BFu0s_BFu0s)
//============================================================================


struct  BFu15i_BFu0s_BFu15i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15i_BFu0s_BFu15i) C1{ Fi:15 Fs:0 Fi:15}



static void Test_BFu15i_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu15i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu15i, BFu15i_BFu0s_BFu15i)
//============================================================================


struct  BFu15i_BFu0s_BFu15ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15i_BFu0s_BFu15ll) C1{ Fi:15 Fs:0 FL:15}



static void Test_BFu15i_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu15ll, BFu15i_BFu0s_BFu15ll)
//============================================================================


struct  BFu15i_BFu0s_BFu15s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15i_BFu0s_BFu15s) C1{ Fi:15 Fs:0 Fs:15}



static void Test_BFu15i_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu15s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu15s, BFu15i_BFu0s_BFu15s)
//============================================================================


struct  BFu15i_BFu0s_BFu16i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15i_BFu0s_BFu16i) C1{ Fi:15 Fs:0 Fi:16}



static void Test_BFu15i_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu16i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu16i, BFu15i_BFu0s_BFu16i)
//============================================================================


struct  BFu15i_BFu0s_BFu16ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15i_BFu0s_BFu16ll) C1{ Fi:15 Fs:0 FL:16}



static void Test_BFu15i_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu16ll, BFu15i_BFu0s_BFu16ll)
//============================================================================


struct  BFu15i_BFu0s_BFu16s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15i_BFu0s_BFu16s) C1{ Fi:15 Fs:0 Fs:16}



static void Test_BFu15i_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu16s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu16s, BFu15i_BFu0s_BFu16s)
//============================================================================


struct  BFu15i_BFu0s_BFu17i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15i_BFu0s_BFu17i) C1{ Fi:15 Fs:0 Fi:17}



static void Test_BFu15i_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu17i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15i_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu17i, BFu15i_BFu0s_BFu17i)
//============================================================================


struct  BFu15i_BFu0s_BFu17ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15i_BFu0s_BFu17ll) C1{ Fi:15 Fs:0 FL:17}



static void Test_BFu15i_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu15i_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu15i_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu17ll, BFu15i_BFu0s_BFu17ll)
//============================================================================


struct  BFu15i_BFu0s_BFu1c  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15i_BFu0s_BFu1c) C1{ Fi:15 Fs:0 Fc:1}



static void Test_BFu15i_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu1c");
    static STRUCT_IF_C BFu15i_BFu0s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu1c, BFu15i_BFu0s_BFu1c)
//============================================================================


struct  BFu15i_BFu0s_BFu1i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15i_BFu0s_BFu1i) C1{ Fi:15 Fs:0 Fi:1}



static void Test_BFu15i_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu1i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu1i, BFu15i_BFu0s_BFu1i)
//============================================================================


struct  BFu15i_BFu0s_BFu1ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15i_BFu0s_BFu1ll) C1{ Fi:15 Fs:0 FL:1}



static void Test_BFu15i_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu1ll, BFu15i_BFu0s_BFu1ll)
//============================================================================


struct  BFu15i_BFu0s_BFu1s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15i_BFu0s_BFu1s) C1{ Fi:15 Fs:0 Fs:1}



static void Test_BFu15i_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu1s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15i_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu1s, BFu15i_BFu0s_BFu1s)
//============================================================================


struct  BFu15i_BFu0s_BFu31i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15i_BFu0s_BFu31i) C1{ Fi:15 Fs:0 Fi:31}



static void Test_BFu15i_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu31i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu31i, BFu15i_BFu0s_BFu31i)
//============================================================================


struct  BFu15i_BFu0s_BFu31ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15i_BFu0s_BFu31ll) C1{ Fi:15 Fs:0 FL:31}



static void Test_BFu15i_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu15i_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu31ll, BFu15i_BFu0s_BFu31ll)
//============================================================================


struct  BFu15i_BFu0s_BFu32i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15i_BFu0s_BFu32i) C1{ Fi:15 Fs:0 Fi:32}



static void Test_BFu15i_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu32i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu32i, BFu15i_BFu0s_BFu32i)
//============================================================================


struct  BFu15i_BFu0s_BFu32ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15i_BFu0s_BFu32ll) C1{ Fi:15 Fs:0 FL:32}



static void Test_BFu15i_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu15i_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu32ll, BFu15i_BFu0s_BFu32ll)
//============================================================================


struct  BFu15i_BFu0s_BFu33  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15i_BFu0s_BFu33) C1{ Fi:15 Fs:0 FL:33}



static void Test_BFu15i_BFu0s_BFu33()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu33");
    static STRUCT_IF_C BFu15i_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu15i_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu15i_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu33, BFu15i_BFu0s_BFu33)
//============================================================================


struct  BFu15i_BFu0s_BFu7c  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15i_BFu0s_BFu7c) C1{ Fi:15 Fs:0 Fc:7}



static void Test_BFu15i_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu7c");
    static STRUCT_IF_C BFu15i_BFu0s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu7c, BFu15i_BFu0s_BFu7c)
//============================================================================


struct  BFu15i_BFu0s_BFu7i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15i_BFu0s_BFu7i) C1{ Fi:15 Fs:0 Fi:7}



static void Test_BFu15i_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu7i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu7i, BFu15i_BFu0s_BFu7i)
//============================================================================


struct  BFu15i_BFu0s_BFu7ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15i_BFu0s_BFu7ll) C1{ Fi:15 Fs:0 FL:7}



static void Test_BFu15i_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu7ll, BFu15i_BFu0s_BFu7ll)
//============================================================================


struct  BFu15i_BFu0s_BFu7s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15i_BFu0s_BFu7s) C1{ Fi:15 Fs:0 Fs:7}



static void Test_BFu15i_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu7s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu7s, BFu15i_BFu0s_BFu7s)
//============================================================================


struct  BFu15i_BFu0s_BFu8c  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15i_BFu0s_BFu8c) C1{ Fi:15 Fs:0 Fc:8}



static void Test_BFu15i_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu8c");
    static STRUCT_IF_C BFu15i_BFu0s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu8c, BFu15i_BFu0s_BFu8c)
//============================================================================


struct  BFu15i_BFu0s_BFu8i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15i_BFu0s_BFu8i) C1{ Fi:15 Fs:0 Fi:8}



static void Test_BFu15i_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu8i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu8i, BFu15i_BFu0s_BFu8i)
//============================================================================


struct  BFu15i_BFu0s_BFu8ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15i_BFu0s_BFu8ll) C1{ Fi:15 Fs:0 FL:8}



static void Test_BFu15i_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu8ll, BFu15i_BFu0s_BFu8ll)
//============================================================================


struct  BFu15i_BFu0s_BFu8s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15i_BFu0s_BFu8s) C1{ Fi:15 Fs:0 Fs:8}



static void Test_BFu15i_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu8s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu8s, BFu15i_BFu0s_BFu8s)
//============================================================================


struct  BFu15i_BFu0s_BFu9i  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15i_BFu0s_BFu9i) C1{ Fi:15 Fs:0 Fi:9}



static void Test_BFu15i_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu9i");
    static STRUCT_IF_C BFu15i_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu9i, BFu15i_BFu0s_BFu9i)
//============================================================================


struct  BFu15i_BFu0s_BFu9ll  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15i_BFu0s_BFu9ll) C1{ Fi:15 Fs:0 FL:9}



static void Test_BFu15i_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu15i_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu9ll, BFu15i_BFu0s_BFu9ll)
//============================================================================


struct  BFu15i_BFu0s_BFu9s  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15i_BFu0s_BFu9s) C1{ Fi:15 Fs:0 Fs:9}



static void Test_BFu15i_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu15i_BFu0s_BFu9s");
    static STRUCT_IF_C BFu15i_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_BFu9s, BFu15i_BFu0s_BFu9s)
//============================================================================


struct  BFu15i_BFu0s_C  {
  unsigned int v1:15;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu15i_BFu0s_C) C1{ Fi:15 Fs:0 Fc}



static void Test_BFu15i_BFu0s_C()
{
  {
    init_simple_test("BFu15i_BFu0s_C");
    static STRUCT_IF_C BFu15i_BFu0s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_C, BFu15i_BFu0s_C)
//============================================================================


struct  BFu15i_BFu0s_D  {
  unsigned int v1:15;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu15i_BFu0s_D) C1{ Fi:15 Fs:0 FL}



static void Test_BFu15i_BFu0s_D()
{
  {
    init_simple_test("BFu15i_BFu0s_D");
    static STRUCT_IF_C BFu15i_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_D, BFu15i_BFu0s_D)
//============================================================================


struct  BFu15i_BFu0s_F  {
  unsigned int v1:15;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu15i_BFu0s_F) C1{ Fi:15 Fs:0 Fi}



static void Test_BFu15i_BFu0s_F()
{
  {
    init_simple_test("BFu15i_BFu0s_F");
    static STRUCT_IF_C BFu15i_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_F, BFu15i_BFu0s_F)
//============================================================================


struct  BFu15i_BFu0s_I  {
  unsigned int v1:15;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu15i_BFu0s_I) C1{ Fi:15 Fs:0 Fi}



static void Test_BFu15i_BFu0s_I()
{
  {
    init_simple_test("BFu15i_BFu0s_I");
    static STRUCT_IF_C BFu15i_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_I, BFu15i_BFu0s_I)
//============================================================================


struct  BFu15i_BFu0s_Ip  {
  unsigned int v1:15;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu15i_BFu0s_Ip) C1{ Fi:15 Fs:0 Fp}



static void Test_BFu15i_BFu0s_Ip()
{
  {
    init_simple_test("BFu15i_BFu0s_Ip");
    static STRUCT_IF_C BFu15i_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Ip, BFu15i_BFu0s_Ip)
//============================================================================


struct  BFu15i_BFu0s_L  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu15i_BFu0s_L) C1{ Fi:15 Fs:0 FL}



static void Test_BFu15i_BFu0s_L()
{
  {
    init_simple_test("BFu15i_BFu0s_L");
    static STRUCT_IF_C BFu15i_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_L, BFu15i_BFu0s_L)
//============================================================================


struct  BFu15i_BFu0s_S  {
  unsigned int v1:15;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu15i_BFu0s_S) C1{ Fi:15 Fs:0 Fs}



static void Test_BFu15i_BFu0s_S()
{
  {
    init_simple_test("BFu15i_BFu0s_S");
    static STRUCT_IF_C BFu15i_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_S, BFu15i_BFu0s_S)
//============================================================================


struct  BFu15i_BFu0s_Uc  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu15i_BFu0s_Uc) C1{ Fi:15 Fs:0 Fc}



static void Test_BFu15i_BFu0s_Uc()
{
  {
    init_simple_test("BFu15i_BFu0s_Uc");
    static STRUCT_IF_C BFu15i_BFu0s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Uc, BFu15i_BFu0s_Uc)
//============================================================================


struct  BFu15i_BFu0s_Ui  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu15i_BFu0s_Ui) C1{ Fi:15 Fs:0 Fi}



static void Test_BFu15i_BFu0s_Ui()
{
  {
    init_simple_test("BFu15i_BFu0s_Ui");
    static STRUCT_IF_C BFu15i_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu15i_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Ui, BFu15i_BFu0s_Ui)
//============================================================================


struct  BFu15i_BFu0s_Ul  {
  unsigned int v1:15;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu15i_BFu0s_Ul) C1{ Fi:15 Fs:0 FL}



static void Test_BFu15i_BFu0s_Ul()
{
  {
    init_simple_test("BFu15i_BFu0s_Ul");
    static STRUCT_IF_C BFu15i_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Ul, BFu15i_BFu0s_Ul)
//============================================================================


struct  BFu15i_BFu0s_Us  {
  unsigned int v1:15;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu15i_BFu0s_Us) C1{ Fi:15 Fs:0 Fs}



static void Test_BFu15i_BFu0s_Us()
{
  {
    init_simple_test("BFu15i_BFu0s_Us");
    static STRUCT_IF_C BFu15i_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu0s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu15i_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Us, BFu15i_BFu0s_Us)
//============================================================================


struct  BFu15i_BFu0s_Vp  {
  unsigned int v1:15;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu15i_BFu0s_Vp) C1{ Fi:15 Fs:0 Fp}



static void Test_BFu15i_BFu0s_Vp()
{
  {
    init_simple_test("BFu15i_BFu0s_Vp");
    static STRUCT_IF_C BFu15i_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu0s_Vp, BFu15i_BFu0s_Vp)
//============================================================================


struct  BFu15i_BFu15i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu15i_BFu0c) C1{ Fi:15 Fi:15 Fc:0}



static void Test_BFu15i_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu15i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15i_BFu0c, BFu15i_BFu15i_BFu0c)
//============================================================================


struct  BFu15i_BFu15i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu15i_BFu0i) C1{ Fi:15 Fi:15 Fi:0}



static void Test_BFu15i_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu15i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15i_BFu0i, BFu15i_BFu15i_BFu0i)
//============================================================================


struct  BFu15i_BFu15i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu15i_BFu0ll) C1{ Fi:15 Fi:15 FL:0}



static void Test_BFu15i_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15i_BFu0ll, BFu15i_BFu15i_BFu0ll)
//============================================================================


struct  BFu15i_BFu15i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu15i_BFu0s) C1{ Fi:15 Fi:15 Fs:0}



static void Test_BFu15i_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu15i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15i_BFu0s, BFu15i_BFu15i_BFu0s)
//============================================================================


struct  BFu15i_BFu15ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu15ll_BFu0c) C1{ Fi:15 FL:15 Fc:0}



static void Test_BFu15i_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15ll_BFu0c, BFu15i_BFu15ll_BFu0c)
//============================================================================


struct  BFu15i_BFu15ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu15ll_BFu0i) C1{ Fi:15 FL:15 Fi:0}



static void Test_BFu15i_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15ll_BFu0i, BFu15i_BFu15ll_BFu0i)
//============================================================================


struct  BFu15i_BFu15ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu15ll_BFu0ll) C1{ Fi:15 FL:15 FL:0}



static void Test_BFu15i_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15ll_BFu0ll, BFu15i_BFu15ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu15ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu15ll_BFu0s) C1{ Fi:15 FL:15 Fs:0}



static void Test_BFu15i_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15ll_BFu0s, BFu15i_BFu15ll_BFu0s)
//============================================================================


struct  BFu15i_BFu15s_BFu0c  {
  unsigned int v1:15;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu15s_BFu0c) C1{ Fi:15 Fs:15 Fc:0}



static void Test_BFu15i_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu15s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu15s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15s_BFu0c, BFu15i_BFu15s_BFu0c)
//============================================================================


struct  BFu15i_BFu15s_BFu0i  {
  unsigned int v1:15;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu15s_BFu0i) C1{ Fi:15 Fs:15 Fi:0}



static void Test_BFu15i_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu15s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu15s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15s_BFu0i, BFu15i_BFu15s_BFu0i)
//============================================================================


struct  BFu15i_BFu15s_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu15s_BFu0ll) C1{ Fi:15 Fs:15 FL:0}



static void Test_BFu15i_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15s_BFu0ll, BFu15i_BFu15s_BFu0ll)
//============================================================================


struct  BFu15i_BFu15s_BFu0s  {
  unsigned int v1:15;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu15s_BFu0s) C1{ Fi:15 Fs:15 Fs:0}



static void Test_BFu15i_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu15s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu15s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu15s_BFu0s, BFu15i_BFu15s_BFu0s)
//============================================================================


struct  BFu15i_BFu16i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu16i_BFu0c) C1{ Fi:15 Fi:16 Fc:0}



static void Test_BFu15i_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu16i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16i_BFu0c, BFu15i_BFu16i_BFu0c)
//============================================================================


struct  BFu15i_BFu16i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu16i_BFu0i) C1{ Fi:15 Fi:16 Fi:0}



static void Test_BFu15i_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu16i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16i_BFu0i, BFu15i_BFu16i_BFu0i)
//============================================================================


struct  BFu15i_BFu16i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu16i_BFu0ll) C1{ Fi:15 Fi:16 FL:0}



static void Test_BFu15i_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16i_BFu0ll, BFu15i_BFu16i_BFu0ll)
//============================================================================


struct  BFu15i_BFu16i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu16i_BFu0s) C1{ Fi:15 Fi:16 Fs:0}



static void Test_BFu15i_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu16i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16i_BFu0s, BFu15i_BFu16i_BFu0s)
//============================================================================


struct  BFu15i_BFu16ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu16ll_BFu0c) C1{ Fi:15 FL:16 Fc:0}



static void Test_BFu15i_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16ll_BFu0c, BFu15i_BFu16ll_BFu0c)
//============================================================================


struct  BFu15i_BFu16ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu16ll_BFu0i) C1{ Fi:15 FL:16 Fi:0}



static void Test_BFu15i_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16ll_BFu0i, BFu15i_BFu16ll_BFu0i)
//============================================================================


struct  BFu15i_BFu16ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu16ll_BFu0ll) C1{ Fi:15 FL:16 FL:0}



static void Test_BFu15i_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16ll_BFu0ll, BFu15i_BFu16ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu16ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu16ll_BFu0s) C1{ Fi:15 FL:16 Fs:0}



static void Test_BFu15i_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16ll_BFu0s, BFu15i_BFu16ll_BFu0s)
//============================================================================


struct  BFu15i_BFu16s_BFu0c  {
  unsigned int v1:15;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu16s_BFu0c) C1{ Fi:15 Fs:16 Fc:0}



static void Test_BFu15i_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu16s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu16s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16s_BFu0c, BFu15i_BFu16s_BFu0c)
//============================================================================


struct  BFu15i_BFu16s_BFu0i  {
  unsigned int v1:15;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu16s_BFu0i) C1{ Fi:15 Fs:16 Fi:0}



static void Test_BFu15i_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu16s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu16s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16s_BFu0i, BFu15i_BFu16s_BFu0i)
//============================================================================


struct  BFu15i_BFu16s_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu16s_BFu0ll) C1{ Fi:15 Fs:16 FL:0}



static void Test_BFu15i_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16s_BFu0ll, BFu15i_BFu16s_BFu0ll)
//============================================================================


struct  BFu15i_BFu16s_BFu0s  {
  unsigned int v1:15;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu16s_BFu0s) C1{ Fi:15 Fs:16 Fs:0}



static void Test_BFu15i_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu16s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu16s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu16s_BFu0s, BFu15i_BFu16s_BFu0s)
//============================================================================


struct  BFu15i_BFu17i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu17i_BFu0c) C1{ Fi:15 Fi:17 Fc:0}



static void Test_BFu15i_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu17i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17i_BFu0c, BFu15i_BFu17i_BFu0c)
//============================================================================


struct  BFu15i_BFu17i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu17i_BFu0i) C1{ Fi:15 Fi:17 Fi:0}



static void Test_BFu15i_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu17i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17i_BFu0i, BFu15i_BFu17i_BFu0i)
//============================================================================


struct  BFu15i_BFu17i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu17i_BFu0ll) C1{ Fi:15 Fi:17 FL:0}



static void Test_BFu15i_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17i_BFu0ll, BFu15i_BFu17i_BFu0ll)
//============================================================================


struct  BFu15i_BFu17i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu17i_BFu0s) C1{ Fi:15 Fi:17 Fs:0}



static void Test_BFu15i_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu17i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17i_BFu0s, BFu15i_BFu17i_BFu0s)
//============================================================================


struct  BFu15i_BFu17ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu17ll_BFu0c) C1{ Fi:15 FL:17 Fc:0}



static void Test_BFu15i_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17ll_BFu0c, BFu15i_BFu17ll_BFu0c)
//============================================================================


struct  BFu15i_BFu17ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu17ll_BFu0i) C1{ Fi:15 FL:17 Fi:0}



static void Test_BFu15i_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17ll_BFu0i, BFu15i_BFu17ll_BFu0i)
//============================================================================


struct  BFu15i_BFu17ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu17ll_BFu0ll) C1{ Fi:15 FL:17 FL:0}



static void Test_BFu15i_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17ll_BFu0ll, BFu15i_BFu17ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu17ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu17ll_BFu0s) C1{ Fi:15 FL:17 Fs:0}



static void Test_BFu15i_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu17ll_BFu0s, BFu15i_BFu17ll_BFu0s)
//============================================================================


struct  BFu15i_BFu1c_BFu0c  {
  unsigned int v1:15;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu1c_BFu0c) C1{ Fi:15 Fc:1 Fc:0}



static void Test_BFu15i_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu1c_BFu0c");
    static STRUCT_IF_C BFu15i_BFu1c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1c_BFu0c, BFu15i_BFu1c_BFu0c)
//============================================================================


struct  BFu15i_BFu1c_BFu0i  {
  unsigned int v1:15;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu1c_BFu0i) C1{ Fi:15 Fc:1 Fi:0}



static void Test_BFu15i_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu1c_BFu0i");
    static STRUCT_IF_C BFu15i_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1c_BFu0i, BFu15i_BFu1c_BFu0i)
//============================================================================


struct  BFu15i_BFu1c_BFu0ll  {
  unsigned int v1:15;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu1c_BFu0ll) C1{ Fi:15 Fc:1 FL:0}



static void Test_BFu15i_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1c_BFu0ll, BFu15i_BFu1c_BFu0ll)
//============================================================================


struct  BFu15i_BFu1c_BFu0s  {
  unsigned int v1:15;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu1c_BFu0s) C1{ Fi:15 Fc:1 Fs:0}



static void Test_BFu15i_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu1c_BFu0s");
    static STRUCT_IF_C BFu15i_BFu1c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1c_BFu0s, BFu15i_BFu1c_BFu0s)
//============================================================================


struct  BFu15i_BFu1i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu1i_BFu0c) C1{ Fi:15 Fi:1 Fc:0}



static void Test_BFu15i_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu1i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1i_BFu0c, BFu15i_BFu1i_BFu0c)
//============================================================================


struct  BFu15i_BFu1i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu1i_BFu0i) C1{ Fi:15 Fi:1 Fi:0}



static void Test_BFu15i_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu1i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1i_BFu0i, BFu15i_BFu1i_BFu0i)
//============================================================================


struct  BFu15i_BFu1i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu1i_BFu0ll) C1{ Fi:15 Fi:1 FL:0}



static void Test_BFu15i_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1i_BFu0ll, BFu15i_BFu1i_BFu0ll)
//============================================================================


struct  BFu15i_BFu1i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu1i_BFu0s) C1{ Fi:15 Fi:1 Fs:0}



static void Test_BFu15i_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu1i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1i_BFu0s, BFu15i_BFu1i_BFu0s)
//============================================================================


struct  BFu15i_BFu1ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu1ll_BFu0c) C1{ Fi:15 FL:1 Fc:0}



static void Test_BFu15i_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1ll_BFu0c, BFu15i_BFu1ll_BFu0c)
//============================================================================


struct  BFu15i_BFu1ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu1ll_BFu0i) C1{ Fi:15 FL:1 Fi:0}



static void Test_BFu15i_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1ll_BFu0i, BFu15i_BFu1ll_BFu0i)
//============================================================================


struct  BFu15i_BFu1ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu1ll_BFu0ll) C1{ Fi:15 FL:1 FL:0}



static void Test_BFu15i_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1ll_BFu0ll, BFu15i_BFu1ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu1ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu1ll_BFu0s) C1{ Fi:15 FL:1 Fs:0}



static void Test_BFu15i_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1ll_BFu0s, BFu15i_BFu1ll_BFu0s)
//============================================================================


struct  BFu15i_BFu1s_BFu0c  {
  unsigned int v1:15;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu1s_BFu0c) C1{ Fi:15 Fs:1 Fc:0}



static void Test_BFu15i_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu1s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu1s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1s_BFu0c, BFu15i_BFu1s_BFu0c)
//============================================================================


struct  BFu15i_BFu1s_BFu0i  {
  unsigned int v1:15;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu1s_BFu0i) C1{ Fi:15 Fs:1 Fi:0}



static void Test_BFu15i_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu1s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1s_BFu0i, BFu15i_BFu1s_BFu0i)
//============================================================================


struct  BFu15i_BFu1s_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu1s_BFu0ll) C1{ Fi:15 Fs:1 FL:0}



static void Test_BFu15i_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1s_BFu0ll, BFu15i_BFu1s_BFu0ll)
//============================================================================


struct  BFu15i_BFu1s_BFu0s  {
  unsigned int v1:15;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu1s_BFu0s) C1{ Fi:15 Fs:1 Fs:0}



static void Test_BFu15i_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu1s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu1s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu1s_BFu0s, BFu15i_BFu1s_BFu0s)
//============================================================================


struct  BFu15i_BFu31i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu31i_BFu0c) C1{ Fi:15 Fi:31 Fc:0}



static void Test_BFu15i_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu31i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31i_BFu0c, BFu15i_BFu31i_BFu0c)
//============================================================================


struct  BFu15i_BFu31i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu31i_BFu0i) C1{ Fi:15 Fi:31 Fi:0}



static void Test_BFu15i_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu31i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31i_BFu0i, BFu15i_BFu31i_BFu0i)
//============================================================================


struct  BFu15i_BFu31i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu31i_BFu0ll) C1{ Fi:15 Fi:31 FL:0}



static void Test_BFu15i_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31i_BFu0ll, BFu15i_BFu31i_BFu0ll)
//============================================================================


struct  BFu15i_BFu31i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu31i_BFu0s) C1{ Fi:15 Fi:31 Fs:0}



static void Test_BFu15i_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu31i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31i_BFu0s, BFu15i_BFu31i_BFu0s)
//============================================================================


struct  BFu15i_BFu31ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu31ll_BFu0c) C1{ Fi:15 FL:31 Fc:0}



static void Test_BFu15i_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31ll_BFu0c, BFu15i_BFu31ll_BFu0c)
//============================================================================


struct  BFu15i_BFu31ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu31ll_BFu0i) C1{ Fi:15 FL:31 Fi:0}



static void Test_BFu15i_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31ll_BFu0i, BFu15i_BFu31ll_BFu0i)
//============================================================================


struct  BFu15i_BFu31ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu31ll_BFu0ll) C1{ Fi:15 FL:31 FL:0}



static void Test_BFu15i_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31ll_BFu0ll, BFu15i_BFu31ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu31ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu31ll_BFu0s) C1{ Fi:15 FL:31 Fs:0}



static void Test_BFu15i_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu31ll_BFu0s, BFu15i_BFu31ll_BFu0s)
//============================================================================


struct  BFu15i_BFu32i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu32i_BFu0c) C1{ Fi:15 Fi:32 Fc:0}



static void Test_BFu15i_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu32i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32i_BFu0c, BFu15i_BFu32i_BFu0c)
//============================================================================


struct  BFu15i_BFu32i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu32i_BFu0i) C1{ Fi:15 Fi:32 Fi:0}



static void Test_BFu15i_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu32i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32i_BFu0i, BFu15i_BFu32i_BFu0i)
//============================================================================


struct  BFu15i_BFu32i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu32i_BFu0ll) C1{ Fi:15 Fi:32 FL:0}



static void Test_BFu15i_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32i_BFu0ll, BFu15i_BFu32i_BFu0ll)
//============================================================================


struct  BFu15i_BFu32i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu32i_BFu0s) C1{ Fi:15 Fi:32 Fs:0}



static void Test_BFu15i_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu32i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32i_BFu0s, BFu15i_BFu32i_BFu0s)
//============================================================================


struct  BFu15i_BFu32ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu32ll_BFu0c) C1{ Fi:15 FL:32 Fc:0}



static void Test_BFu15i_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32ll_BFu0c, BFu15i_BFu32ll_BFu0c)
//============================================================================


struct  BFu15i_BFu32ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu32ll_BFu0i) C1{ Fi:15 FL:32 Fi:0}



static void Test_BFu15i_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32ll_BFu0i, BFu15i_BFu32ll_BFu0i)
//============================================================================


struct  BFu15i_BFu32ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu32ll_BFu0ll) C1{ Fi:15 FL:32 FL:0}



static void Test_BFu15i_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32ll_BFu0ll, BFu15i_BFu32ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu32ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu32ll_BFu0s) C1{ Fi:15 FL:32 Fs:0}



static void Test_BFu15i_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu32ll_BFu0s, BFu15i_BFu32ll_BFu0s)
//============================================================================


struct  BFu15i_BFu33_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu33_BFu0c) C1{ Fi:15 FL:33 Fc:0}



static void Test_BFu15i_BFu33_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu33_BFu0c");
    static STRUCT_IF_C BFu15i_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15i_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu33_BFu0c, BFu15i_BFu33_BFu0c)
//============================================================================


struct  BFu15i_BFu33_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu33_BFu0i) C1{ Fi:15 FL:33 Fi:0}



static void Test_BFu15i_BFu33_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu33_BFu0i");
    static STRUCT_IF_C BFu15i_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15i_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu33_BFu0i, BFu15i_BFu33_BFu0i)
//============================================================================


struct  BFu15i_BFu33_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu33_BFu0ll) C1{ Fi:15 FL:33 FL:0}



static void Test_BFu15i_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu33_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15i_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu33_BFu0ll, BFu15i_BFu33_BFu0ll)
//============================================================================


struct  BFu15i_BFu33_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu33_BFu0s) C1{ Fi:15 FL:33 Fs:0}



static void Test_BFu15i_BFu33_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu33_BFu0s");
    static STRUCT_IF_C BFu15i_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15i_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu33_BFu0s, BFu15i_BFu33_BFu0s)
//============================================================================


struct  BFu15i_BFu7c_BFu0c  {
  unsigned int v1:15;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu7c_BFu0c) C1{ Fi:15 Fc:7 Fc:0}



static void Test_BFu15i_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu7c_BFu0c");
    static STRUCT_IF_C BFu15i_BFu7c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7c_BFu0c, BFu15i_BFu7c_BFu0c)
//============================================================================


struct  BFu15i_BFu7c_BFu0i  {
  unsigned int v1:15;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu7c_BFu0i) C1{ Fi:15 Fc:7 Fi:0}



static void Test_BFu15i_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu7c_BFu0i");
    static STRUCT_IF_C BFu15i_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7c_BFu0i, BFu15i_BFu7c_BFu0i)
//============================================================================


struct  BFu15i_BFu7c_BFu0ll  {
  unsigned int v1:15;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu7c_BFu0ll) C1{ Fi:15 Fc:7 FL:0}



static void Test_BFu15i_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7c_BFu0ll, BFu15i_BFu7c_BFu0ll)
//============================================================================


struct  BFu15i_BFu7c_BFu0s  {
  unsigned int v1:15;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu7c_BFu0s) C1{ Fi:15 Fc:7 Fs:0}



static void Test_BFu15i_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu7c_BFu0s");
    static STRUCT_IF_C BFu15i_BFu7c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7c_BFu0s, BFu15i_BFu7c_BFu0s)
//============================================================================


struct  BFu15i_BFu7i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu7i_BFu0c) C1{ Fi:15 Fi:7 Fc:0}



static void Test_BFu15i_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu7i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7i_BFu0c, BFu15i_BFu7i_BFu0c)
//============================================================================


struct  BFu15i_BFu7i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu7i_BFu0i) C1{ Fi:15 Fi:7 Fi:0}



static void Test_BFu15i_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu7i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7i_BFu0i, BFu15i_BFu7i_BFu0i)
//============================================================================


struct  BFu15i_BFu7i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu7i_BFu0ll) C1{ Fi:15 Fi:7 FL:0}



static void Test_BFu15i_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7i_BFu0ll, BFu15i_BFu7i_BFu0ll)
//============================================================================


struct  BFu15i_BFu7i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu7i_BFu0s) C1{ Fi:15 Fi:7 Fs:0}



static void Test_BFu15i_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu7i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7i_BFu0s, BFu15i_BFu7i_BFu0s)
//============================================================================


struct  BFu15i_BFu7ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu7ll_BFu0c) C1{ Fi:15 FL:7 Fc:0}



static void Test_BFu15i_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7ll_BFu0c, BFu15i_BFu7ll_BFu0c)
//============================================================================


struct  BFu15i_BFu7ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu7ll_BFu0i) C1{ Fi:15 FL:7 Fi:0}



static void Test_BFu15i_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7ll_BFu0i, BFu15i_BFu7ll_BFu0i)
//============================================================================


struct  BFu15i_BFu7ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu7ll_BFu0ll) C1{ Fi:15 FL:7 FL:0}



static void Test_BFu15i_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7ll_BFu0ll, BFu15i_BFu7ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu7ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu7ll_BFu0s) C1{ Fi:15 FL:7 Fs:0}



static void Test_BFu15i_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7ll_BFu0s, BFu15i_BFu7ll_BFu0s)
//============================================================================


struct  BFu15i_BFu7s_BFu0c  {
  unsigned int v1:15;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu7s_BFu0c) C1{ Fi:15 Fs:7 Fc:0}



static void Test_BFu15i_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu7s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu7s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7s_BFu0c, BFu15i_BFu7s_BFu0c)
//============================================================================


struct  BFu15i_BFu7s_BFu0i  {
  unsigned int v1:15;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu7s_BFu0i) C1{ Fi:15 Fs:7 Fi:0}



static void Test_BFu15i_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu7s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7s_BFu0i, BFu15i_BFu7s_BFu0i)
//============================================================================


struct  BFu15i_BFu7s_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu7s_BFu0ll) C1{ Fi:15 Fs:7 FL:0}



static void Test_BFu15i_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7s_BFu0ll, BFu15i_BFu7s_BFu0ll)
//============================================================================


struct  BFu15i_BFu7s_BFu0s  {
  unsigned int v1:15;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu7s_BFu0s) C1{ Fi:15 Fs:7 Fs:0}



static void Test_BFu15i_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu7s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu7s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu7s_BFu0s, BFu15i_BFu7s_BFu0s)
//============================================================================


struct  BFu15i_BFu8c_BFu0c  {
  unsigned int v1:15;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu8c_BFu0c) C1{ Fi:15 Fc:8 Fc:0}



static void Test_BFu15i_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu0c");
    static STRUCT_IF_C BFu15i_BFu8c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu0c, BFu15i_BFu8c_BFu0c)
//============================================================================


struct  BFu15i_BFu8c_BFu0i  {
  unsigned int v1:15;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu8c_BFu0i) C1{ Fi:15 Fc:8 Fi:0}



static void Test_BFu15i_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu0i");
    static STRUCT_IF_C BFu15i_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu0i, BFu15i_BFu8c_BFu0i)
//============================================================================


struct  BFu15i_BFu8c_BFu0ll  {
  unsigned int v1:15;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu8c_BFu0ll) C1{ Fi:15 Fc:8 FL:0}



static void Test_BFu15i_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu0ll, BFu15i_BFu8c_BFu0ll)
//============================================================================


struct  BFu15i_BFu8c_BFu0s  {
  unsigned int v1:15;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu8c_BFu0s) C1{ Fi:15 Fc:8 Fs:0}



static void Test_BFu15i_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu8c_BFu0s");
    static STRUCT_IF_C BFu15i_BFu8c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8c_BFu0s, BFu15i_BFu8c_BFu0s)
//============================================================================


struct  BFu15i_BFu8i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu8i_BFu0c) C1{ Fi:15 Fi:8 Fc:0}



static void Test_BFu15i_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu0c, BFu15i_BFu8i_BFu0c)
//============================================================================


struct  BFu15i_BFu8i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu8i_BFu0i) C1{ Fi:15 Fi:8 Fi:0}



static void Test_BFu15i_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu0i, BFu15i_BFu8i_BFu0i)
//============================================================================


struct  BFu15i_BFu8i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu8i_BFu0ll) C1{ Fi:15 Fi:8 FL:0}



static void Test_BFu15i_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu0ll, BFu15i_BFu8i_BFu0ll)
//============================================================================


struct  BFu15i_BFu8i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu8i_BFu0s) C1{ Fi:15 Fi:8 Fs:0}



static void Test_BFu15i_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu8i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8i_BFu0s, BFu15i_BFu8i_BFu0s)
//============================================================================


struct  BFu15i_BFu8ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu8ll_BFu0c) C1{ Fi:15 FL:8 Fc:0}



static void Test_BFu15i_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu0c, BFu15i_BFu8ll_BFu0c)
//============================================================================


struct  BFu15i_BFu8ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu8ll_BFu0i) C1{ Fi:15 FL:8 Fi:0}



static void Test_BFu15i_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu0i, BFu15i_BFu8ll_BFu0i)
//============================================================================


struct  BFu15i_BFu8ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu8ll_BFu0ll) C1{ Fi:15 FL:8 FL:0}



static void Test_BFu15i_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu0ll, BFu15i_BFu8ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu8ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu8ll_BFu0s) C1{ Fi:15 FL:8 Fs:0}



static void Test_BFu15i_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8ll_BFu0s, BFu15i_BFu8ll_BFu0s)
//============================================================================


struct  BFu15i_BFu8s_BFu0c  {
  unsigned int v1:15;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu8s_BFu0c) C1{ Fi:15 Fs:8 Fc:0}



static void Test_BFu15i_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu8s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu0c, BFu15i_BFu8s_BFu0c)
//============================================================================


struct  BFu15i_BFu8s_BFu0i  {
  unsigned int v1:15;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu8s_BFu0i) C1{ Fi:15 Fs:8 Fi:0}



static void Test_BFu15i_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu0i, BFu15i_BFu8s_BFu0i)
//============================================================================


struct  BFu15i_BFu8s_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu8s_BFu0ll) C1{ Fi:15 Fs:8 FL:0}



static void Test_BFu15i_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu0ll, BFu15i_BFu8s_BFu0ll)
//============================================================================


struct  BFu15i_BFu8s_BFu0s  {
  unsigned int v1:15;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu8s_BFu0s) C1{ Fi:15 Fs:8 Fs:0}



static void Test_BFu15i_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu8s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu8s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu8s_BFu0s, BFu15i_BFu8s_BFu0s)
//============================================================================


struct  BFu15i_BFu9i_BFu0c  {
  unsigned int v1:15;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu9i_BFu0c) C1{ Fi:15 Fi:9 Fc:0}



static void Test_BFu15i_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu0c");
    static STRUCT_IF_C BFu15i_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu0c, BFu15i_BFu9i_BFu0c)
//============================================================================


struct  BFu15i_BFu9i_BFu0i  {
  unsigned int v1:15;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu9i_BFu0i) C1{ Fi:15 Fi:9 Fi:0}



static void Test_BFu15i_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu0i");
    static STRUCT_IF_C BFu15i_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu0i, BFu15i_BFu9i_BFu0i)
//============================================================================


struct  BFu15i_BFu9i_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu9i_BFu0ll) C1{ Fi:15 Fi:9 FL:0}



static void Test_BFu15i_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu0ll, BFu15i_BFu9i_BFu0ll)
//============================================================================


struct  BFu15i_BFu9i_BFu0s  {
  unsigned int v1:15;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu9i_BFu0s) C1{ Fi:15 Fi:9 Fs:0}



static void Test_BFu15i_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu9i_BFu0s");
    static STRUCT_IF_C BFu15i_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9i_BFu0s, BFu15i_BFu9i_BFu0s)
//============================================================================


struct  BFu15i_BFu9ll_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu9ll_BFu0c) C1{ Fi:15 FL:9 Fc:0}



static void Test_BFu15i_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu0c, BFu15i_BFu9ll_BFu0c)
//============================================================================


struct  BFu15i_BFu9ll_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu9ll_BFu0i) C1{ Fi:15 FL:9 Fi:0}



static void Test_BFu15i_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu0i, BFu15i_BFu9ll_BFu0i)
//============================================================================


struct  BFu15i_BFu9ll_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu9ll_BFu0ll) C1{ Fi:15 FL:9 FL:0}



static void Test_BFu15i_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu0ll, BFu15i_BFu9ll_BFu0ll)
//============================================================================


struct  BFu15i_BFu9ll_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu9ll_BFu0s) C1{ Fi:15 FL:9 Fs:0}



static void Test_BFu15i_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu15i_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9ll_BFu0s, BFu15i_BFu9ll_BFu0s)
//============================================================================


struct  BFu15i_BFu9s_BFu0c  {
  unsigned int v1:15;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu15i_BFu9s_BFu0c) C1{ Fi:15 Fs:9 Fc:0}



static void Test_BFu15i_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu0c");
    static STRUCT_IF_C BFu15i_BFu9s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu0c, BFu15i_BFu9s_BFu0c)
//============================================================================


struct  BFu15i_BFu9s_BFu0i  {
  unsigned int v1:15;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu15i_BFu9s_BFu0i) C1{ Fi:15 Fs:9 Fi:0}



static void Test_BFu15i_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu0i");
    static STRUCT_IF_C BFu15i_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu0i, BFu15i_BFu9s_BFu0i)
//============================================================================


struct  BFu15i_BFu9s_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu15i_BFu9s_BFu0ll) C1{ Fi:15 Fs:9 FL:0}



static void Test_BFu15i_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu15i_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu0ll, BFu15i_BFu9s_BFu0ll)
//============================================================================


struct  BFu15i_BFu9s_BFu0s  {
  unsigned int v1:15;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu15i_BFu9s_BFu0s) C1{ Fi:15 Fs:9 Fs:0}



static void Test_BFu15i_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu15i_BFu9s_BFu0s");
    static STRUCT_IF_C BFu15i_BFu9s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_BFu9s_BFu0s, BFu15i_BFu9s_BFu0s)
//============================================================================


struct  BFu15i_C_BFu0c  {
  unsigned int v1:15;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_C_BFu0c) C1{ Fi:15 Fc Fc:0}



static void Test_BFu15i_C_BFu0c()
{
  {
    init_simple_test("BFu15i_C_BFu0c");
    static STRUCT_IF_C BFu15i_C_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu0c, BFu15i_C_BFu0c)
//============================================================================


struct  BFu15i_C_BFu0i  {
  unsigned int v1:15;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_C_BFu0i) C1{ Fi:15 Fc Fi:0}



static void Test_BFu15i_C_BFu0i()
{
  {
    init_simple_test("BFu15i_C_BFu0i");
    static STRUCT_IF_C BFu15i_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu0i, BFu15i_C_BFu0i)
//============================================================================


struct  BFu15i_C_BFu0ll  {
  unsigned int v1:15;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_C_BFu0ll) C1{ Fi:15 Fc FL:0}



static void Test_BFu15i_C_BFu0ll()
{
  {
    init_simple_test("BFu15i_C_BFu0ll");
    static STRUCT_IF_C BFu15i_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu0ll, BFu15i_C_BFu0ll)
//============================================================================


struct  BFu15i_C_BFu0s  {
  unsigned int v1:15;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_C_BFu0s) C1{ Fi:15 Fc Fs:0}



static void Test_BFu15i_C_BFu0s()
{
  {
    init_simple_test("BFu15i_C_BFu0s");
    static STRUCT_IF_C BFu15i_C_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15i_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_C_BFu0s, BFu15i_C_BFu0s)
//============================================================================


struct  BFu15i_D_BFu0c  {
  unsigned int v1:15;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_D_BFu0c) C1{ Fi:15 FL Fc:0}



static void Test_BFu15i_D_BFu0c()
{
  {
    init_simple_test("BFu15i_D_BFu0c");
    static STRUCT_IF_C BFu15i_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu0c, BFu15i_D_BFu0c)
//============================================================================


struct  BFu15i_D_BFu0i  {
  unsigned int v1:15;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_D_BFu0i) C1{ Fi:15 FL Fi:0}



static void Test_BFu15i_D_BFu0i()
{
  {
    init_simple_test("BFu15i_D_BFu0i");
    static STRUCT_IF_C BFu15i_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu0i, BFu15i_D_BFu0i)
//============================================================================


struct  BFu15i_D_BFu0ll  {
  unsigned int v1:15;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_D_BFu0ll) C1{ Fi:15 FL FL:0}



static void Test_BFu15i_D_BFu0ll()
{
  {
    init_simple_test("BFu15i_D_BFu0ll");
    static STRUCT_IF_C BFu15i_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu0ll, BFu15i_D_BFu0ll)
//============================================================================


struct  BFu15i_D_BFu0s  {
  unsigned int v1:15;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_D_BFu0s) C1{ Fi:15 FL Fs:0}



static void Test_BFu15i_D_BFu0s()
{
  {
    init_simple_test("BFu15i_D_BFu0s");
    static STRUCT_IF_C BFu15i_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_D_BFu0s, BFu15i_D_BFu0s)
//============================================================================


struct  BFu15i_F_BFu0c  {
  unsigned int v1:15;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_F_BFu0c) C1{ Fi:15 Fi Fc:0}



static void Test_BFu15i_F_BFu0c()
{
  {
    init_simple_test("BFu15i_F_BFu0c");
    static STRUCT_IF_C BFu15i_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu15i_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu0c, BFu15i_F_BFu0c)
//============================================================================


struct  BFu15i_F_BFu0i  {
  unsigned int v1:15;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_F_BFu0i) C1{ Fi:15 Fi Fi:0}



static void Test_BFu15i_F_BFu0i()
{
  {
    init_simple_test("BFu15i_F_BFu0i");
    static STRUCT_IF_C BFu15i_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu15i_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu0i, BFu15i_F_BFu0i)
//============================================================================


struct  BFu15i_F_BFu0ll  {
  unsigned int v1:15;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_F_BFu0ll) C1{ Fi:15 Fi FL:0}



static void Test_BFu15i_F_BFu0ll()
{
  {
    init_simple_test("BFu15i_F_BFu0ll");
    static STRUCT_IF_C BFu15i_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu15i_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu0ll, BFu15i_F_BFu0ll)
//============================================================================


struct  BFu15i_F_BFu0s  {
  unsigned int v1:15;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_F_BFu0s) C1{ Fi:15 Fi Fs:0}



static void Test_BFu15i_F_BFu0s()
{
  {
    init_simple_test("BFu15i_F_BFu0s");
    static STRUCT_IF_C BFu15i_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu15i_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_F_BFu0s, BFu15i_F_BFu0s)
//============================================================================


struct  BFu15i_I_BFu0c  {
  unsigned int v1:15;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_I_BFu0c) C1{ Fi:15 Fi Fc:0}



static void Test_BFu15i_I_BFu0c()
{
  {
    init_simple_test("BFu15i_I_BFu0c");
    static STRUCT_IF_C BFu15i_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu15i_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu0c, BFu15i_I_BFu0c)
//============================================================================


struct  BFu15i_I_BFu0i  {
  unsigned int v1:15;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_I_BFu0i) C1{ Fi:15 Fi Fi:0}



static void Test_BFu15i_I_BFu0i()
{
  {
    init_simple_test("BFu15i_I_BFu0i");
    static STRUCT_IF_C BFu15i_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu15i_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu0i, BFu15i_I_BFu0i)
//============================================================================


struct  BFu15i_I_BFu0ll  {
  unsigned int v1:15;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_I_BFu0ll) C1{ Fi:15 Fi FL:0}



static void Test_BFu15i_I_BFu0ll()
{
  {
    init_simple_test("BFu15i_I_BFu0ll");
    static STRUCT_IF_C BFu15i_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu15i_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu0ll, BFu15i_I_BFu0ll)
//============================================================================


struct  BFu15i_I_BFu0s  {
  unsigned int v1:15;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_I_BFu0s) C1{ Fi:15 Fi Fs:0}



static void Test_BFu15i_I_BFu0s()
{
  {
    init_simple_test("BFu15i_I_BFu0s");
    static STRUCT_IF_C BFu15i_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu15i_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_I_BFu0s, BFu15i_I_BFu0s)
//============================================================================


struct  BFu15i_Ip_BFu0c  {
  unsigned int v1:15;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_Ip_BFu0c) C1{ Fi:15 Fp Fc:0}



static void Test_BFu15i_Ip_BFu0c()
{
  {
    init_simple_test("BFu15i_Ip_BFu0c");
    static STRUCT_IF_C BFu15i_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu0c, BFu15i_Ip_BFu0c)
//============================================================================


struct  BFu15i_Ip_BFu0i  {
  unsigned int v1:15;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_Ip_BFu0i) C1{ Fi:15 Fp Fi:0}



static void Test_BFu15i_Ip_BFu0i()
{
  {
    init_simple_test("BFu15i_Ip_BFu0i");
    static STRUCT_IF_C BFu15i_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu0i, BFu15i_Ip_BFu0i)
//============================================================================


struct  BFu15i_Ip_BFu0ll  {
  unsigned int v1:15;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_Ip_BFu0ll) C1{ Fi:15 Fp FL:0}



static void Test_BFu15i_Ip_BFu0ll()
{
  {
    init_simple_test("BFu15i_Ip_BFu0ll");
    static STRUCT_IF_C BFu15i_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu0ll, BFu15i_Ip_BFu0ll)
//============================================================================


struct  BFu15i_Ip_BFu0s  {
  unsigned int v1:15;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_Ip_BFu0s) C1{ Fi:15 Fp Fs:0}



static void Test_BFu15i_Ip_BFu0s()
{
  {
    init_simple_test("BFu15i_Ip_BFu0s");
    static STRUCT_IF_C BFu15i_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ip_BFu0s, BFu15i_Ip_BFu0s)
//============================================================================


struct  BFu15i_L_BFu0c  {
  unsigned int v1:15;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_L_BFu0c) C1{ Fi:15 FL Fc:0}



static void Test_BFu15i_L_BFu0c()
{
  {
    init_simple_test("BFu15i_L_BFu0c");
    static STRUCT_IF_C BFu15i_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu0c, BFu15i_L_BFu0c)
//============================================================================


struct  BFu15i_L_BFu0i  {
  unsigned int v1:15;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_L_BFu0i) C1{ Fi:15 FL Fi:0}



static void Test_BFu15i_L_BFu0i()
{
  {
    init_simple_test("BFu15i_L_BFu0i");
    static STRUCT_IF_C BFu15i_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu0i, BFu15i_L_BFu0i)
//============================================================================


struct  BFu15i_L_BFu0ll  {
  unsigned int v1:15;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_L_BFu0ll) C1{ Fi:15 FL FL:0}



static void Test_BFu15i_L_BFu0ll()
{
  {
    init_simple_test("BFu15i_L_BFu0ll");
    static STRUCT_IF_C BFu15i_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu0ll, BFu15i_L_BFu0ll)
//============================================================================


struct  BFu15i_L_BFu0s  {
  unsigned int v1:15;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_L_BFu0s) C1{ Fi:15 FL Fs:0}



static void Test_BFu15i_L_BFu0s()
{
  {
    init_simple_test("BFu15i_L_BFu0s");
    static STRUCT_IF_C BFu15i_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_L_BFu0s, BFu15i_L_BFu0s)
//============================================================================


struct  BFu15i_S_BFu0c  {
  unsigned int v1:15;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_S_BFu0c) C1{ Fi:15 Fs Fc:0}



static void Test_BFu15i_S_BFu0c()
{
  {
    init_simple_test("BFu15i_S_BFu0c");
    static STRUCT_IF_C BFu15i_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_S_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu0c, BFu15i_S_BFu0c)
//============================================================================


struct  BFu15i_S_BFu0i  {
  unsigned int v1:15;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_S_BFu0i) C1{ Fi:15 Fs Fi:0}



static void Test_BFu15i_S_BFu0i()
{
  {
    init_simple_test("BFu15i_S_BFu0i");
    static STRUCT_IF_C BFu15i_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_S_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu0i, BFu15i_S_BFu0i)
//============================================================================


struct  BFu15i_S_BFu0ll  {
  unsigned int v1:15;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_S_BFu0ll) C1{ Fi:15 Fs FL:0}



static void Test_BFu15i_S_BFu0ll()
{
  {
    init_simple_test("BFu15i_S_BFu0ll");
    static STRUCT_IF_C BFu15i_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu0ll, BFu15i_S_BFu0ll)
//============================================================================


struct  BFu15i_S_BFu0s  {
  unsigned int v1:15;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_S_BFu0s) C1{ Fi:15 Fs Fs:0}



static void Test_BFu15i_S_BFu0s()
{
  {
    init_simple_test("BFu15i_S_BFu0s");
    static STRUCT_IF_C BFu15i_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_S_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15i_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_S_BFu0s, BFu15i_S_BFu0s)
//============================================================================


struct  BFu15i_Uc_BFu0c  {
  unsigned int v1:15;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_Uc_BFu0c) C1{ Fi:15 Fc Fc:0}



static void Test_BFu15i_Uc_BFu0c()
{
  {
    init_simple_test("BFu15i_Uc_BFu0c");
    static STRUCT_IF_C BFu15i_Uc_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu0c, BFu15i_Uc_BFu0c)
//============================================================================


struct  BFu15i_Uc_BFu0i  {
  unsigned int v1:15;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_Uc_BFu0i) C1{ Fi:15 Fc Fi:0}



static void Test_BFu15i_Uc_BFu0i()
{
  {
    init_simple_test("BFu15i_Uc_BFu0i");
    static STRUCT_IF_C BFu15i_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu0i, BFu15i_Uc_BFu0i)
//============================================================================


struct  BFu15i_Uc_BFu0ll  {
  unsigned int v1:15;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_Uc_BFu0ll) C1{ Fi:15 Fc FL:0}



static void Test_BFu15i_Uc_BFu0ll()
{
  {
    init_simple_test("BFu15i_Uc_BFu0ll");
    static STRUCT_IF_C BFu15i_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu0ll, BFu15i_Uc_BFu0ll)
//============================================================================


struct  BFu15i_Uc_BFu0s  {
  unsigned int v1:15;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_Uc_BFu0s) C1{ Fi:15 Fc Fs:0}



static void Test_BFu15i_Uc_BFu0s()
{
  {
    init_simple_test("BFu15i_Uc_BFu0s");
    static STRUCT_IF_C BFu15i_Uc_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Uc_BFu0s, BFu15i_Uc_BFu0s)
//============================================================================


struct  BFu15i_Ui_BFu0c  {
  unsigned int v1:15;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_Ui_BFu0c) C1{ Fi:15 Fi Fc:0}



static void Test_BFu15i_Ui_BFu0c()
{
  {
    init_simple_test("BFu15i_Ui_BFu0c");
    static STRUCT_IF_C BFu15i_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu15i_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu0c, BFu15i_Ui_BFu0c)
//============================================================================


struct  BFu15i_Ui_BFu0i  {
  unsigned int v1:15;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_Ui_BFu0i) C1{ Fi:15 Fi Fi:0}



static void Test_BFu15i_Ui_BFu0i()
{
  {
    init_simple_test("BFu15i_Ui_BFu0i");
    static STRUCT_IF_C BFu15i_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu15i_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu0i, BFu15i_Ui_BFu0i)
//============================================================================


struct  BFu15i_Ui_BFu0ll  {
  unsigned int v1:15;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_Ui_BFu0ll) C1{ Fi:15 Fi FL:0}



static void Test_BFu15i_Ui_BFu0ll()
{
  {
    init_simple_test("BFu15i_Ui_BFu0ll");
    static STRUCT_IF_C BFu15i_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu15i_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu0ll, BFu15i_Ui_BFu0ll)
//============================================================================


struct  BFu15i_Ui_BFu0s  {
  unsigned int v1:15;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_Ui_BFu0s) C1{ Fi:15 Fi Fs:0}



static void Test_BFu15i_Ui_BFu0s()
{
  {
    init_simple_test("BFu15i_Ui_BFu0s");
    static STRUCT_IF_C BFu15i_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu15i_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ui_BFu0s, BFu15i_Ui_BFu0s)
//============================================================================


struct  BFu15i_Ul_BFu0c  {
  unsigned int v1:15;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_Ul_BFu0c) C1{ Fi:15 FL Fc:0}



static void Test_BFu15i_Ul_BFu0c()
{
  {
    init_simple_test("BFu15i_Ul_BFu0c");
    static STRUCT_IF_C BFu15i_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu0c, BFu15i_Ul_BFu0c)
//============================================================================


struct  BFu15i_Ul_BFu0i  {
  unsigned int v1:15;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_Ul_BFu0i) C1{ Fi:15 FL Fi:0}



static void Test_BFu15i_Ul_BFu0i()
{
  {
    init_simple_test("BFu15i_Ul_BFu0i");
    static STRUCT_IF_C BFu15i_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu0i, BFu15i_Ul_BFu0i)
//============================================================================


struct  BFu15i_Ul_BFu0ll  {
  unsigned int v1:15;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_Ul_BFu0ll) C1{ Fi:15 FL FL:0}



static void Test_BFu15i_Ul_BFu0ll()
{
  {
    init_simple_test("BFu15i_Ul_BFu0ll");
    static STRUCT_IF_C BFu15i_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu0ll, BFu15i_Ul_BFu0ll)
//============================================================================


struct  BFu15i_Ul_BFu0s  {
  unsigned int v1:15;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_Ul_BFu0s) C1{ Fi:15 FL Fs:0}



static void Test_BFu15i_Ul_BFu0s()
{
  {
    init_simple_test("BFu15i_Ul_BFu0s");
    static STRUCT_IF_C BFu15i_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Ul_BFu0s, BFu15i_Ul_BFu0s)
//============================================================================


struct  BFu15i_Us_BFu0c  {
  unsigned int v1:15;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_Us_BFu0c) C1{ Fi:15 Fs Fc:0}



static void Test_BFu15i_Us_BFu0c()
{
  {
    init_simple_test("BFu15i_Us_BFu0c");
    static STRUCT_IF_C BFu15i_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Us_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu0c, BFu15i_Us_BFu0c)
//============================================================================


struct  BFu15i_Us_BFu0i  {
  unsigned int v1:15;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_Us_BFu0i) C1{ Fi:15 Fs Fi:0}



static void Test_BFu15i_Us_BFu0i()
{
  {
    init_simple_test("BFu15i_Us_BFu0i");
    static STRUCT_IF_C BFu15i_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Us_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu0i, BFu15i_Us_BFu0i)
//============================================================================


struct  BFu15i_Us_BFu0ll  {
  unsigned int v1:15;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_Us_BFu0ll) C1{ Fi:15 Fs FL:0}



static void Test_BFu15i_Us_BFu0ll()
{
  {
    init_simple_test("BFu15i_Us_BFu0ll");
    static STRUCT_IF_C BFu15i_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15i_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu0ll, BFu15i_Us_BFu0ll)
//============================================================================


struct  BFu15i_Us_BFu0s  {
  unsigned int v1:15;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_Us_BFu0s) C1{ Fi:15 Fs Fs:0}



static void Test_BFu15i_Us_BFu0s()
{
  {
    init_simple_test("BFu15i_Us_BFu0s");
    static STRUCT_IF_C BFu15i_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Us_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15i_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Us_BFu0s, BFu15i_Us_BFu0s)
//============================================================================


struct  BFu15i_Vp_BFu0c  {
  unsigned int v1:15;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu15i_Vp_BFu0c) C1{ Fi:15 Fp Fc:0}



static void Test_BFu15i_Vp_BFu0c()
{
  {
    init_simple_test("BFu15i_Vp_BFu0c");
    static STRUCT_IF_C BFu15i_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu0c, BFu15i_Vp_BFu0c)
//============================================================================


struct  BFu15i_Vp_BFu0i  {
  unsigned int v1:15;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu15i_Vp_BFu0i) C1{ Fi:15 Fp Fi:0}



static void Test_BFu15i_Vp_BFu0i()
{
  {
    init_simple_test("BFu15i_Vp_BFu0i");
    static STRUCT_IF_C BFu15i_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu0i, BFu15i_Vp_BFu0i)
//============================================================================


struct  BFu15i_Vp_BFu0ll  {
  unsigned int v1:15;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu15i_Vp_BFu0ll) C1{ Fi:15 Fp FL:0}



static void Test_BFu15i_Vp_BFu0ll()
{
  {
    init_simple_test("BFu15i_Vp_BFu0ll");
    static STRUCT_IF_C BFu15i_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu0ll, BFu15i_Vp_BFu0ll)
//============================================================================


struct  BFu15i_Vp_BFu0s  {
  unsigned int v1:15;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu15i_Vp_BFu0s) C1{ Fi:15 Fp Fs:0}



static void Test_BFu15i_Vp_BFu0s()
{
  {
    init_simple_test("BFu15i_Vp_BFu0s");
    static STRUCT_IF_C BFu15i_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15i_Vp_BFu0s, BFu15i_Vp_BFu0s)
//============================================================================


struct  BFu15ll_BFu0c  {
  __tsu64 v1:15;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu0c) C1{ FL:15 Fc:0}



static void Test_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c, BFu15ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu0c_BFu0c  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu0c_BFu0c) C1{ FL:15 Fc:0 Fc:0}



static void Test_BFu15ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu0c, BFu15ll_BFu0c_BFu0c)
//============================================================================


struct  BFu15ll_BFu0c_BFu0i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu0c_BFu0i) C1{ FL:15 Fc:0 Fi:0}



static void Test_BFu15ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu0i, BFu15ll_BFu0c_BFu0i)
//============================================================================


struct  BFu15ll_BFu0c_BFu0ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu0c_BFu0ll) C1{ FL:15 Fc:0 FL:0}



static void Test_BFu15ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu0ll, BFu15ll_BFu0c_BFu0ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu0s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu0c_BFu0s) C1{ FL:15 Fc:0 Fs:0}



static void Test_BFu15ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu0s, BFu15ll_BFu0c_BFu0s)
//============================================================================


struct  BFu15ll_BFu0c_BFu15i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15ll_BFu0c_BFu15i) C1{ FL:15 Fc:0 Fi:15}



static void Test_BFu15ll_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu15i, BFu15ll_BFu0c_BFu15i)
//============================================================================


struct  BFu15ll_BFu0c_BFu15ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15ll_BFu0c_BFu15ll) C1{ FL:15 Fc:0 FL:15}



static void Test_BFu15ll_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu15ll, BFu15ll_BFu0c_BFu15ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu15s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15ll_BFu0c_BFu15s) C1{ FL:15 Fc:0 Fs:15}



static void Test_BFu15ll_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu15s, BFu15ll_BFu0c_BFu15s)
//============================================================================


struct  BFu15ll_BFu0c_BFu16i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15ll_BFu0c_BFu16i) C1{ FL:15 Fc:0 Fi:16}



static void Test_BFu15ll_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu16i, BFu15ll_BFu0c_BFu16i)
//============================================================================


struct  BFu15ll_BFu0c_BFu16ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15ll_BFu0c_BFu16ll) C1{ FL:15 Fc:0 FL:16}



static void Test_BFu15ll_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu16ll, BFu15ll_BFu0c_BFu16ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu16s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15ll_BFu0c_BFu16s) C1{ FL:15 Fc:0 Fs:16}



static void Test_BFu15ll_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu16s, BFu15ll_BFu0c_BFu16s)
//============================================================================


struct  BFu15ll_BFu0c_BFu17i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15ll_BFu0c_BFu17i) C1{ FL:15 Fc:0 Fi:17}



static void Test_BFu15ll_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15ll_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu17i, BFu15ll_BFu0c_BFu17i)
//============================================================================


struct  BFu15ll_BFu0c_BFu17ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15ll_BFu0c_BFu17ll) C1{ FL:15 Fc:0 FL:17}



static void Test_BFu15ll_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu15ll_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu17ll, BFu15ll_BFu0c_BFu17ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu1c  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15ll_BFu0c_BFu1c) C1{ FL:15 Fc:0 Fc:1}



static void Test_BFu15ll_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu1c, BFu15ll_BFu0c_BFu1c)
//============================================================================


struct  BFu15ll_BFu0c_BFu1i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15ll_BFu0c_BFu1i) C1{ FL:15 Fc:0 Fi:1}



static void Test_BFu15ll_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu1i, BFu15ll_BFu0c_BFu1i)
//============================================================================


struct  BFu15ll_BFu0c_BFu1ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15ll_BFu0c_BFu1ll) C1{ FL:15 Fc:0 FL:1}



static void Test_BFu15ll_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu1ll, BFu15ll_BFu0c_BFu1ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu1s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15ll_BFu0c_BFu1s) C1{ FL:15 Fc:0 Fs:1}



static void Test_BFu15ll_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu1s, BFu15ll_BFu0c_BFu1s)
//============================================================================


struct  BFu15ll_BFu0c_BFu31i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15ll_BFu0c_BFu31i) C1{ FL:15 Fc:0 Fi:31}



static void Test_BFu15ll_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu31i, BFu15ll_BFu0c_BFu31i)
//============================================================================


struct  BFu15ll_BFu0c_BFu31ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15ll_BFu0c_BFu31ll) C1{ FL:15 Fc:0 FL:31}



static void Test_BFu15ll_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu15ll_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu31ll, BFu15ll_BFu0c_BFu31ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu32i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15ll_BFu0c_BFu32i) C1{ FL:15 Fc:0 Fi:32}



static void Test_BFu15ll_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu32i, BFu15ll_BFu0c_BFu32i)
//============================================================================


struct  BFu15ll_BFu0c_BFu32ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15ll_BFu0c_BFu32ll) C1{ FL:15 Fc:0 FL:32}



static void Test_BFu15ll_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu15ll_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu32ll, BFu15ll_BFu0c_BFu32ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu33  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15ll_BFu0c_BFu33) C1{ FL:15 Fc:0 FL:33}



static void Test_BFu15ll_BFu0c_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu33");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu15ll_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu33, BFu15ll_BFu0c_BFu33)
//============================================================================


struct  BFu15ll_BFu0c_BFu7c  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15ll_BFu0c_BFu7c) C1{ FL:15 Fc:0 Fc:7}



static void Test_BFu15ll_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu7c, BFu15ll_BFu0c_BFu7c)
//============================================================================


struct  BFu15ll_BFu0c_BFu7i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15ll_BFu0c_BFu7i) C1{ FL:15 Fc:0 Fi:7}



static void Test_BFu15ll_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu7i, BFu15ll_BFu0c_BFu7i)
//============================================================================


struct  BFu15ll_BFu0c_BFu7ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15ll_BFu0c_BFu7ll) C1{ FL:15 Fc:0 FL:7}



static void Test_BFu15ll_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu7ll, BFu15ll_BFu0c_BFu7ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu7s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15ll_BFu0c_BFu7s) C1{ FL:15 Fc:0 Fs:7}



static void Test_BFu15ll_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu7s, BFu15ll_BFu0c_BFu7s)
//============================================================================


struct  BFu15ll_BFu0c_BFu8c  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15ll_BFu0c_BFu8c) C1{ FL:15 Fc:0 Fc:8}



static void Test_BFu15ll_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu8c, BFu15ll_BFu0c_BFu8c)
//============================================================================


struct  BFu15ll_BFu0c_BFu8i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15ll_BFu0c_BFu8i) C1{ FL:15 Fc:0 Fi:8}



static void Test_BFu15ll_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu8i, BFu15ll_BFu0c_BFu8i)
//============================================================================


struct  BFu15ll_BFu0c_BFu8ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15ll_BFu0c_BFu8ll) C1{ FL:15 Fc:0 FL:8}



static void Test_BFu15ll_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu8ll, BFu15ll_BFu0c_BFu8ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu8s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15ll_BFu0c_BFu8s) C1{ FL:15 Fc:0 Fs:8}



static void Test_BFu15ll_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu8s, BFu15ll_BFu0c_BFu8s)
//============================================================================


struct  BFu15ll_BFu0c_BFu9i  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15ll_BFu0c_BFu9i) C1{ FL:15 Fc:0 Fi:9}



static void Test_BFu15ll_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu9i, BFu15ll_BFu0c_BFu9i)
//============================================================================


struct  BFu15ll_BFu0c_BFu9ll  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15ll_BFu0c_BFu9ll) C1{ FL:15 Fc:0 FL:9}



static void Test_BFu15ll_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu9ll, BFu15ll_BFu0c_BFu9ll)
//============================================================================


struct  BFu15ll_BFu0c_BFu9s  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15ll_BFu0c_BFu9s) C1{ FL:15 Fc:0 Fs:9}



static void Test_BFu15ll_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu0c_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu0c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_BFu9s, BFu15ll_BFu0c_BFu9s)
//============================================================================


struct  BFu15ll_BFu0c_C  {
  __tsu64 v1:15;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu15ll_BFu0c_C) C1{ FL:15 Fc:0 Fc}



static void Test_BFu15ll_BFu0c_C()
{
  {
    init_simple_test("BFu15ll_BFu0c_C");
    static STRUCT_IF_C BFu15ll_BFu0c_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_C");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_C, BFu15ll_BFu0c_C)
//============================================================================


struct  BFu15ll_BFu0c_D  {
  __tsu64 v1:15;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu15ll_BFu0c_D) C1{ FL:15 Fc:0 FL}



static void Test_BFu15ll_BFu0c_D()
{
  {
    init_simple_test("BFu15ll_BFu0c_D");
    static STRUCT_IF_C BFu15ll_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_D, BFu15ll_BFu0c_D)
//============================================================================


struct  BFu15ll_BFu0c_F  {
  __tsu64 v1:15;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu15ll_BFu0c_F) C1{ FL:15 Fc:0 Fi}



static void Test_BFu15ll_BFu0c_F()
{
  {
    init_simple_test("BFu15ll_BFu0c_F");
    static STRUCT_IF_C BFu15ll_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_F, BFu15ll_BFu0c_F)
//============================================================================


struct  BFu15ll_BFu0c_I  {
  __tsu64 v1:15;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu15ll_BFu0c_I) C1{ FL:15 Fc:0 Fi}



static void Test_BFu15ll_BFu0c_I()
{
  {
    init_simple_test("BFu15ll_BFu0c_I");
    static STRUCT_IF_C BFu15ll_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_I, BFu15ll_BFu0c_I)
//============================================================================


struct  BFu15ll_BFu0c_Ip  {
  __tsu64 v1:15;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu15ll_BFu0c_Ip) C1{ FL:15 Fc:0 Fp}



static void Test_BFu15ll_BFu0c_Ip()
{
  {
    init_simple_test("BFu15ll_BFu0c_Ip");
    static STRUCT_IF_C BFu15ll_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Ip, BFu15ll_BFu0c_Ip)
//============================================================================


struct  BFu15ll_BFu0c_L  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu15ll_BFu0c_L) C1{ FL:15 Fc:0 FL}



static void Test_BFu15ll_BFu0c_L()
{
  {
    init_simple_test("BFu15ll_BFu0c_L");
    static STRUCT_IF_C BFu15ll_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_L, BFu15ll_BFu0c_L)
//============================================================================


struct  BFu15ll_BFu0c_S  {
  __tsu64 v1:15;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu15ll_BFu0c_S) C1{ FL:15 Fc:0 Fs}



static void Test_BFu15ll_BFu0c_S()
{
  {
    init_simple_test("BFu15ll_BFu0c_S");
    static STRUCT_IF_C BFu15ll_BFu0c_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_S, BFu15ll_BFu0c_S)
//============================================================================


struct  BFu15ll_BFu0c_Uc  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu15ll_BFu0c_Uc) C1{ FL:15 Fc:0 Fc}



static void Test_BFu15ll_BFu0c_Uc()
{
  {
    init_simple_test("BFu15ll_BFu0c_Uc");
    static STRUCT_IF_C BFu15ll_BFu0c_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Uc");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Uc, BFu15ll_BFu0c_Uc)
//============================================================================


struct  BFu15ll_BFu0c_Ui  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu15ll_BFu0c_Ui) C1{ FL:15 Fc:0 Fi}



static void Test_BFu15ll_BFu0c_Ui()
{
  {
    init_simple_test("BFu15ll_BFu0c_Ui");
    static STRUCT_IF_C BFu15ll_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Ui, BFu15ll_BFu0c_Ui)
//============================================================================


struct  BFu15ll_BFu0c_Ul  {
  __tsu64 v1:15;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu15ll_BFu0c_Ul) C1{ FL:15 Fc:0 FL}



static void Test_BFu15ll_BFu0c_Ul()
{
  {
    init_simple_test("BFu15ll_BFu0c_Ul");
    static STRUCT_IF_C BFu15ll_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Ul, BFu15ll_BFu0c_Ul)
//============================================================================


struct  BFu15ll_BFu0c_Us  {
  __tsu64 v1:15;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu15ll_BFu0c_Us) C1{ FL:15 Fc:0 Fs}



static void Test_BFu15ll_BFu0c_Us()
{
  {
    init_simple_test("BFu15ll_BFu0c_Us");
    static STRUCT_IF_C BFu15ll_BFu0c_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Us, BFu15ll_BFu0c_Us)
//============================================================================


struct  BFu15ll_BFu0c_Vp  {
  __tsu64 v1:15;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu15ll_BFu0c_Vp) C1{ FL:15 Fc:0 Fp}



static void Test_BFu15ll_BFu0c_Vp()
{
  {
    init_simple_test("BFu15ll_BFu0c_Vp");
    static STRUCT_IF_C BFu15ll_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0c_Vp, BFu15ll_BFu0c_Vp)
//============================================================================


struct  BFu15ll_BFu0i  {
  __tsu64 v1:15;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu0i) C1{ FL:15 Fi:0}



static void Test_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i, BFu15ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu0i_BFu0c  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu0i_BFu0c) C1{ FL:15 Fi:0 Fc:0}



static void Test_BFu15ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu0c, BFu15ll_BFu0i_BFu0c)
//============================================================================


struct  BFu15ll_BFu0i_BFu0i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu0i_BFu0i) C1{ FL:15 Fi:0 Fi:0}



static void Test_BFu15ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu0i, BFu15ll_BFu0i_BFu0i)
//============================================================================


struct  BFu15ll_BFu0i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu0i_BFu0ll) C1{ FL:15 Fi:0 FL:0}



static void Test_BFu15ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu0ll, BFu15ll_BFu0i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu0s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu0i_BFu0s) C1{ FL:15 Fi:0 Fs:0}



static void Test_BFu15ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu0s, BFu15ll_BFu0i_BFu0s)
//============================================================================


struct  BFu15ll_BFu0i_BFu15i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15ll_BFu0i_BFu15i) C1{ FL:15 Fi:0 Fi:15}



static void Test_BFu15ll_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15ll_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu15i, BFu15ll_BFu0i_BFu15i)
//============================================================================


struct  BFu15ll_BFu0i_BFu15ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15ll_BFu0i_BFu15ll) C1{ FL:15 Fi:0 FL:15}



static void Test_BFu15ll_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15ll_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu15ll, BFu15ll_BFu0i_BFu15ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu15s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15ll_BFu0i_BFu15s) C1{ FL:15 Fi:0 Fs:15}



static void Test_BFu15ll_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15ll_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu15s, BFu15ll_BFu0i_BFu15s)
//============================================================================


struct  BFu15ll_BFu0i_BFu16i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15ll_BFu0i_BFu16i) C1{ FL:15 Fi:0 Fi:16}



static void Test_BFu15ll_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15ll_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu16i, BFu15ll_BFu0i_BFu16i)
//============================================================================


struct  BFu15ll_BFu0i_BFu16ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15ll_BFu0i_BFu16ll) C1{ FL:15 Fi:0 FL:16}



static void Test_BFu15ll_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15ll_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu16ll, BFu15ll_BFu0i_BFu16ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu16s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15ll_BFu0i_BFu16s) C1{ FL:15 Fi:0 Fs:16}



static void Test_BFu15ll_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15ll_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu16s, BFu15ll_BFu0i_BFu16s)
//============================================================================


struct  BFu15ll_BFu0i_BFu17i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15ll_BFu0i_BFu17i) C1{ FL:15 Fi:0 Fi:17}



static void Test_BFu15ll_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15ll_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu17i, BFu15ll_BFu0i_BFu17i)
//============================================================================


struct  BFu15ll_BFu0i_BFu17ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15ll_BFu0i_BFu17ll) C1{ FL:15 Fi:0 FL:17}



static void Test_BFu15ll_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15ll_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu17ll, BFu15ll_BFu0i_BFu17ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu1c  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15ll_BFu0i_BFu1c) C1{ FL:15 Fi:0 Fc:1}



static void Test_BFu15ll_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15ll_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu1c, BFu15ll_BFu0i_BFu1c)
//============================================================================


struct  BFu15ll_BFu0i_BFu1i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15ll_BFu0i_BFu1i) C1{ FL:15 Fi:0 Fi:1}



static void Test_BFu15ll_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15ll_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu1i, BFu15ll_BFu0i_BFu1i)
//============================================================================


struct  BFu15ll_BFu0i_BFu1ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15ll_BFu0i_BFu1ll) C1{ FL:15 Fi:0 FL:1}



static void Test_BFu15ll_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15ll_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu1ll, BFu15ll_BFu0i_BFu1ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu1s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15ll_BFu0i_BFu1s) C1{ FL:15 Fi:0 Fs:1}



static void Test_BFu15ll_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15ll_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu1s, BFu15ll_BFu0i_BFu1s)
//============================================================================


struct  BFu15ll_BFu0i_BFu31i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15ll_BFu0i_BFu31i) C1{ FL:15 Fi:0 Fi:31}



static void Test_BFu15ll_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu31i, BFu15ll_BFu0i_BFu31i)
//============================================================================


struct  BFu15ll_BFu0i_BFu31ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15ll_BFu0i_BFu31ll) C1{ FL:15 Fi:0 FL:31}



static void Test_BFu15ll_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu31ll, BFu15ll_BFu0i_BFu31ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu32i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15ll_BFu0i_BFu32i) C1{ FL:15 Fi:0 Fi:32}



static void Test_BFu15ll_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu32i, BFu15ll_BFu0i_BFu32i)
//============================================================================


struct  BFu15ll_BFu0i_BFu32ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15ll_BFu0i_BFu32ll) C1{ FL:15 Fi:0 FL:32}



static void Test_BFu15ll_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu32ll, BFu15ll_BFu0i_BFu32ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu33  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15ll_BFu0i_BFu33) C1{ FL:15 Fi:0 FL:33}



static void Test_BFu15ll_BFu0i_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu33");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu15ll_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu33, BFu15ll_BFu0i_BFu33)
//============================================================================


struct  BFu15ll_BFu0i_BFu7c  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15ll_BFu0i_BFu7c) C1{ FL:15 Fi:0 Fc:7}



static void Test_BFu15ll_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15ll_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu7c, BFu15ll_BFu0i_BFu7c)
//============================================================================


struct  BFu15ll_BFu0i_BFu7i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15ll_BFu0i_BFu7i) C1{ FL:15 Fi:0 Fi:7}



static void Test_BFu15ll_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15ll_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu7i, BFu15ll_BFu0i_BFu7i)
//============================================================================


struct  BFu15ll_BFu0i_BFu7ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15ll_BFu0i_BFu7ll) C1{ FL:15 Fi:0 FL:7}



static void Test_BFu15ll_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15ll_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu7ll, BFu15ll_BFu0i_BFu7ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu7s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15ll_BFu0i_BFu7s) C1{ FL:15 Fi:0 Fs:7}



static void Test_BFu15ll_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15ll_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu7s, BFu15ll_BFu0i_BFu7s)
//============================================================================


struct  BFu15ll_BFu0i_BFu8c  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15ll_BFu0i_BFu8c) C1{ FL:15 Fi:0 Fc:8}



static void Test_BFu15ll_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15ll_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu8c, BFu15ll_BFu0i_BFu8c)
//============================================================================


struct  BFu15ll_BFu0i_BFu8i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15ll_BFu0i_BFu8i) C1{ FL:15 Fi:0 Fi:8}



static void Test_BFu15ll_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15ll_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu8i, BFu15ll_BFu0i_BFu8i)
//============================================================================


struct  BFu15ll_BFu0i_BFu8ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15ll_BFu0i_BFu8ll) C1{ FL:15 Fi:0 FL:8}



static void Test_BFu15ll_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15ll_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu8ll, BFu15ll_BFu0i_BFu8ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu8s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15ll_BFu0i_BFu8s) C1{ FL:15 Fi:0 Fs:8}



static void Test_BFu15ll_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15ll_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu8s, BFu15ll_BFu0i_BFu8s)
//============================================================================


struct  BFu15ll_BFu0i_BFu9i  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15ll_BFu0i_BFu9i) C1{ FL:15 Fi:0 Fi:9}



static void Test_BFu15ll_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15ll_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu9i, BFu15ll_BFu0i_BFu9i)
//============================================================================


struct  BFu15ll_BFu0i_BFu9ll  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15ll_BFu0i_BFu9ll) C1{ FL:15 Fi:0 FL:9}



static void Test_BFu15ll_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15ll_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu9ll, BFu15ll_BFu0i_BFu9ll)
//============================================================================


struct  BFu15ll_BFu0i_BFu9s  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15ll_BFu0i_BFu9s) C1{ FL:15 Fi:0 Fs:9}



static void Test_BFu15ll_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu0i_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15ll_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_BFu9s, BFu15ll_BFu0i_BFu9s)
//============================================================================


struct  BFu15ll_BFu0i_C  {
  __tsu64 v1:15;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu15ll_BFu0i_C) C1{ FL:15 Fi:0 Fc}



static void Test_BFu15ll_BFu0i_C()
{
  {
    init_simple_test("BFu15ll_BFu0i_C");
    static STRUCT_IF_C BFu15ll_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_C, BFu15ll_BFu0i_C)
//============================================================================


struct  BFu15ll_BFu0i_D  {
  __tsu64 v1:15;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu15ll_BFu0i_D) C1{ FL:15 Fi:0 FL}



static void Test_BFu15ll_BFu0i_D()
{
  {
    init_simple_test("BFu15ll_BFu0i_D");
    static STRUCT_IF_C BFu15ll_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_D, BFu15ll_BFu0i_D)
//============================================================================


struct  BFu15ll_BFu0i_F  {
  __tsu64 v1:15;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu15ll_BFu0i_F) C1{ FL:15 Fi:0 Fi}



static void Test_BFu15ll_BFu0i_F()
{
  {
    init_simple_test("BFu15ll_BFu0i_F");
    static STRUCT_IF_C BFu15ll_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_F, BFu15ll_BFu0i_F)
//============================================================================


struct  BFu15ll_BFu0i_I  {
  __tsu64 v1:15;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu15ll_BFu0i_I) C1{ FL:15 Fi:0 Fi}



static void Test_BFu15ll_BFu0i_I()
{
  {
    init_simple_test("BFu15ll_BFu0i_I");
    static STRUCT_IF_C BFu15ll_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_I, BFu15ll_BFu0i_I)
//============================================================================


struct  BFu15ll_BFu0i_Ip  {
  __tsu64 v1:15;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu15ll_BFu0i_Ip) C1{ FL:15 Fi:0 Fp}



static void Test_BFu15ll_BFu0i_Ip()
{
  {
    init_simple_test("BFu15ll_BFu0i_Ip");
    static STRUCT_IF_C BFu15ll_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Ip, BFu15ll_BFu0i_Ip)
//============================================================================


struct  BFu15ll_BFu0i_L  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu15ll_BFu0i_L) C1{ FL:15 Fi:0 FL}



static void Test_BFu15ll_BFu0i_L()
{
  {
    init_simple_test("BFu15ll_BFu0i_L");
    static STRUCT_IF_C BFu15ll_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_L, BFu15ll_BFu0i_L)
//============================================================================


struct  BFu15ll_BFu0i_S  {
  __tsu64 v1:15;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu15ll_BFu0i_S) C1{ FL:15 Fi:0 Fs}



static void Test_BFu15ll_BFu0i_S()
{
  {
    init_simple_test("BFu15ll_BFu0i_S");
    static STRUCT_IF_C BFu15ll_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_S, BFu15ll_BFu0i_S)
//============================================================================


struct  BFu15ll_BFu0i_Uc  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu15ll_BFu0i_Uc) C1{ FL:15 Fi:0 Fc}



static void Test_BFu15ll_BFu0i_Uc()
{
  {
    init_simple_test("BFu15ll_BFu0i_Uc");
    static STRUCT_IF_C BFu15ll_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Uc, BFu15ll_BFu0i_Uc)
//============================================================================


struct  BFu15ll_BFu0i_Ui  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu15ll_BFu0i_Ui) C1{ FL:15 Fi:0 Fi}



static void Test_BFu15ll_BFu0i_Ui()
{
  {
    init_simple_test("BFu15ll_BFu0i_Ui");
    static STRUCT_IF_C BFu15ll_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Ui, BFu15ll_BFu0i_Ui)
//============================================================================


struct  BFu15ll_BFu0i_Ul  {
  __tsu64 v1:15;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu15ll_BFu0i_Ul) C1{ FL:15 Fi:0 FL}



static void Test_BFu15ll_BFu0i_Ul()
{
  {
    init_simple_test("BFu15ll_BFu0i_Ul");
    static STRUCT_IF_C BFu15ll_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Ul, BFu15ll_BFu0i_Ul)
//============================================================================


struct  BFu15ll_BFu0i_Us  {
  __tsu64 v1:15;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu15ll_BFu0i_Us) C1{ FL:15 Fi:0 Fs}



static void Test_BFu15ll_BFu0i_Us()
{
  {
    init_simple_test("BFu15ll_BFu0i_Us");
    static STRUCT_IF_C BFu15ll_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Us, BFu15ll_BFu0i_Us)
//============================================================================


struct  BFu15ll_BFu0i_Vp  {
  __tsu64 v1:15;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu15ll_BFu0i_Vp) C1{ FL:15 Fi:0 Fp}



static void Test_BFu15ll_BFu0i_Vp()
{
  {
    init_simple_test("BFu15ll_BFu0i_Vp");
    static STRUCT_IF_C BFu15ll_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0i_Vp, BFu15ll_BFu0i_Vp)
//============================================================================


struct  BFu15ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu0ll) C1{ FL:15 FL:0}



static void Test_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll, BFu15ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu0ll_BFu0c) C1{ FL:15 FL:0 Fc:0}



static void Test_BFu15ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu0c, BFu15ll_BFu0ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu0ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu0ll_BFu0i) C1{ FL:15 FL:0 Fi:0}



static void Test_BFu15ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu0i, BFu15ll_BFu0ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu0ll_BFu0ll) C1{ FL:15 FL:0 FL:0}



static void Test_BFu15ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu0ll, BFu15ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu0ll_BFu0s) C1{ FL:15 FL:0 Fs:0}



static void Test_BFu15ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu0s, BFu15ll_BFu0ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu0ll_BFu15i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15ll_BFu0ll_BFu15i) C1{ FL:15 FL:0 Fi:15}



static void Test_BFu15ll_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15ll_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu15i, BFu15ll_BFu0ll_BFu15i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu15ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15ll_BFu0ll_BFu15ll) C1{ FL:15 FL:0 FL:15}



static void Test_BFu15ll_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15ll_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu15ll, BFu15ll_BFu0ll_BFu15ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu15s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15ll_BFu0ll_BFu15s) C1{ FL:15 FL:0 Fs:15}



static void Test_BFu15ll_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15ll_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu15s, BFu15ll_BFu0ll_BFu15s)
//============================================================================


struct  BFu15ll_BFu0ll_BFu16i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15ll_BFu0ll_BFu16i) C1{ FL:15 FL:0 Fi:16}



static void Test_BFu15ll_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15ll_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu16i, BFu15ll_BFu0ll_BFu16i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu16ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15ll_BFu0ll_BFu16ll) C1{ FL:15 FL:0 FL:16}



static void Test_BFu15ll_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15ll_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu16ll, BFu15ll_BFu0ll_BFu16ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu16s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15ll_BFu0ll_BFu16s) C1{ FL:15 FL:0 Fs:16}



static void Test_BFu15ll_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15ll_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu16s, BFu15ll_BFu0ll_BFu16s)
//============================================================================


struct  BFu15ll_BFu0ll_BFu17i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15ll_BFu0ll_BFu17i) C1{ FL:15 FL:0 Fi:17}



static void Test_BFu15ll_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu15ll_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu17i, BFu15ll_BFu0ll_BFu17i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu17ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15ll_BFu0ll_BFu17ll) C1{ FL:15 FL:0 FL:17}



static void Test_BFu15ll_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu15ll_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu17ll, BFu15ll_BFu0ll_BFu17ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu1c  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15ll_BFu0ll_BFu1c) C1{ FL:15 FL:0 Fc:1}



static void Test_BFu15ll_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15ll_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu1c, BFu15ll_BFu0ll_BFu1c)
//============================================================================


struct  BFu15ll_BFu0ll_BFu1i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15ll_BFu0ll_BFu1i) C1{ FL:15 FL:0 Fi:1}



static void Test_BFu15ll_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15ll_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu1i, BFu15ll_BFu0ll_BFu1i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu1ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15ll_BFu0ll_BFu1ll) C1{ FL:15 FL:0 FL:1}



static void Test_BFu15ll_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15ll_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu1ll, BFu15ll_BFu0ll_BFu1ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu1s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15ll_BFu0ll_BFu1s) C1{ FL:15 FL:0 Fs:1}



static void Test_BFu15ll_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15ll_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu1s, BFu15ll_BFu0ll_BFu1s)
//============================================================================


struct  BFu15ll_BFu0ll_BFu31i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15ll_BFu0ll_BFu31i) C1{ FL:15 FL:0 Fi:31}



static void Test_BFu15ll_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu15ll_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu31i, BFu15ll_BFu0ll_BFu31i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu31ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15ll_BFu0ll_BFu31ll) C1{ FL:15 FL:0 FL:31}



static void Test_BFu15ll_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu15ll_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu31ll, BFu15ll_BFu0ll_BFu31ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu32i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15ll_BFu0ll_BFu32i) C1{ FL:15 FL:0 Fi:32}



static void Test_BFu15ll_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu15ll_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu32i, BFu15ll_BFu0ll_BFu32i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu32ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15ll_BFu0ll_BFu32ll) C1{ FL:15 FL:0 FL:32}



static void Test_BFu15ll_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu15ll_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu32ll, BFu15ll_BFu0ll_BFu32ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu33  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15ll_BFu0ll_BFu33) C1{ FL:15 FL:0 FL:33}



static void Test_BFu15ll_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu33");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu15ll_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu33, BFu15ll_BFu0ll_BFu33)
//============================================================================


struct  BFu15ll_BFu0ll_BFu7c  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15ll_BFu0ll_BFu7c) C1{ FL:15 FL:0 Fc:7}



static void Test_BFu15ll_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15ll_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu7c, BFu15ll_BFu0ll_BFu7c)
//============================================================================


struct  BFu15ll_BFu0ll_BFu7i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15ll_BFu0ll_BFu7i) C1{ FL:15 FL:0 Fi:7}



static void Test_BFu15ll_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15ll_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu7i, BFu15ll_BFu0ll_BFu7i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu7ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15ll_BFu0ll_BFu7ll) C1{ FL:15 FL:0 FL:7}



static void Test_BFu15ll_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15ll_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu7ll, BFu15ll_BFu0ll_BFu7ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu7s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15ll_BFu0ll_BFu7s) C1{ FL:15 FL:0 Fs:7}



static void Test_BFu15ll_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15ll_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu7s, BFu15ll_BFu0ll_BFu7s)
//============================================================================


struct  BFu15ll_BFu0ll_BFu8c  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15ll_BFu0ll_BFu8c) C1{ FL:15 FL:0 Fc:8}



static void Test_BFu15ll_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15ll_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu8c, BFu15ll_BFu0ll_BFu8c)
//============================================================================


struct  BFu15ll_BFu0ll_BFu8i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15ll_BFu0ll_BFu8i) C1{ FL:15 FL:0 Fi:8}



static void Test_BFu15ll_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15ll_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu8i, BFu15ll_BFu0ll_BFu8i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu8ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15ll_BFu0ll_BFu8ll) C1{ FL:15 FL:0 FL:8}



static void Test_BFu15ll_BFu0ll_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15ll_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu8ll, BFu15ll_BFu0ll_BFu8ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu8s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15ll_BFu0ll_BFu8s) C1{ FL:15 FL:0 Fs:8}



static void Test_BFu15ll_BFu0ll_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15ll_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu8s, BFu15ll_BFu0ll_BFu8s)
//============================================================================


struct  BFu15ll_BFu0ll_BFu9i  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15ll_BFu0ll_BFu9i) C1{ FL:15 FL:0 Fi:9}



static void Test_BFu15ll_BFu0ll_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu15ll_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu9i, BFu15ll_BFu0ll_BFu9i)
//============================================================================


struct  BFu15ll_BFu0ll_BFu9ll  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15ll_BFu0ll_BFu9ll) C1{ FL:15 FL:0 FL:9}



static void Test_BFu15ll_BFu0ll_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu15ll_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu9ll, BFu15ll_BFu0ll_BFu9ll)
//============================================================================


struct  BFu15ll_BFu0ll_BFu9s  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15ll_BFu0ll_BFu9s) C1{ FL:15 FL:0 Fs:9}



static void Test_BFu15ll_BFu0ll_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu0ll_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu15ll_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_BFu9s, BFu15ll_BFu0ll_BFu9s)
//============================================================================


struct  BFu15ll_BFu0ll_C  {
  __tsu64 v1:15;
  __tsu64  :0;
  char v2;
};
//SIG(1 BFu15ll_BFu0ll_C) C1{ FL:15 FL:0 Fc}



static void Test_BFu15ll_BFu0ll_C()
{
  {
    init_simple_test("BFu15ll_BFu0ll_C");
    static STRUCT_IF_C BFu15ll_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_C");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_C, BFu15ll_BFu0ll_C)
//============================================================================


struct  BFu15ll_BFu0ll_D  {
  __tsu64 v1:15;
  __tsu64  :0;
  double v2;
};
//SIG(1 BFu15ll_BFu0ll_D) C1{ FL:15 FL:0 FL}



static void Test_BFu15ll_BFu0ll_D()
{
  {
    init_simple_test("BFu15ll_BFu0ll_D");
    static STRUCT_IF_C BFu15ll_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_D, BFu15ll_BFu0ll_D)
//============================================================================


struct  BFu15ll_BFu0ll_F  {
  __tsu64 v1:15;
  __tsu64  :0;
  float v2;
};
//SIG(1 BFu15ll_BFu0ll_F) C1{ FL:15 FL:0 Fi}



static void Test_BFu15ll_BFu0ll_F()
{
  {
    init_simple_test("BFu15ll_BFu0ll_F");
    static STRUCT_IF_C BFu15ll_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_F");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_F, BFu15ll_BFu0ll_F)
//============================================================================


struct  BFu15ll_BFu0ll_I  {
  __tsu64 v1:15;
  __tsu64  :0;
  int v2;
};
//SIG(1 BFu15ll_BFu0ll_I) C1{ FL:15 FL:0 Fi}



static void Test_BFu15ll_BFu0ll_I()
{
  {
    init_simple_test("BFu15ll_BFu0ll_I");
    static STRUCT_IF_C BFu15ll_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_I");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_I, BFu15ll_BFu0ll_I)
//============================================================================


struct  BFu15ll_BFu0ll_Ip  {
  __tsu64 v1:15;
  __tsu64  :0;
  int *v2;
};
//SIG(1 BFu15ll_BFu0ll_Ip) C1{ FL:15 FL:0 Fp}



static void Test_BFu15ll_BFu0ll_Ip()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Ip");
    static STRUCT_IF_C BFu15ll_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Ip, BFu15ll_BFu0ll_Ip)
//============================================================================


struct  BFu15ll_BFu0ll_L  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 BFu15ll_BFu0ll_L) C1{ FL:15 FL:0 FL}



static void Test_BFu15ll_BFu0ll_L()
{
  {
    init_simple_test("BFu15ll_BFu0ll_L");
    static STRUCT_IF_C BFu15ll_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_L, BFu15ll_BFu0ll_L)
//============================================================================


struct  BFu15ll_BFu0ll_S  {
  __tsu64 v1:15;
  __tsu64  :0;
  short v2;
};
//SIG(1 BFu15ll_BFu0ll_S) C1{ FL:15 FL:0 Fs}



static void Test_BFu15ll_BFu0ll_S()
{
  {
    init_simple_test("BFu15ll_BFu0ll_S");
    static STRUCT_IF_C BFu15ll_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_S");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_S, BFu15ll_BFu0ll_S)
//============================================================================


struct  BFu15ll_BFu0ll_Uc  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 BFu15ll_BFu0ll_Uc) C1{ FL:15 FL:0 Fc}



static void Test_BFu15ll_BFu0ll_Uc()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Uc");
    static STRUCT_IF_C BFu15ll_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Uc");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Uc, BFu15ll_BFu0ll_Uc)
//============================================================================


struct  BFu15ll_BFu0ll_Ui  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 BFu15ll_BFu0ll_Ui) C1{ FL:15 FL:0 Fi}



static void Test_BFu15ll_BFu0ll_Ui()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Ui");
    static STRUCT_IF_C BFu15ll_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Ui");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Ui, BFu15ll_BFu0ll_Ui)
//============================================================================


struct  BFu15ll_BFu0ll_Ul  {
  __tsu64 v1:15;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 BFu15ll_BFu0ll_Ul) C1{ FL:15 FL:0 FL}



static void Test_BFu15ll_BFu0ll_Ul()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Ul");
    static STRUCT_IF_C BFu15ll_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Ul, BFu15ll_BFu0ll_Ul)
//============================================================================


struct  BFu15ll_BFu0ll_Us  {
  __tsu64 v1:15;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 BFu15ll_BFu0ll_Us) C1{ FL:15 FL:0 Fs}



static void Test_BFu15ll_BFu0ll_Us()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Us");
    static STRUCT_IF_C BFu15ll_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Us");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Us, BFu15ll_BFu0ll_Us)
//============================================================================


struct  BFu15ll_BFu0ll_Vp  {
  __tsu64 v1:15;
  __tsu64  :0;
  void *v2;
};
//SIG(1 BFu15ll_BFu0ll_Vp) C1{ FL:15 FL:0 Fp}



static void Test_BFu15ll_BFu0ll_Vp()
{
  {
    init_simple_test("BFu15ll_BFu0ll_Vp");
    static STRUCT_IF_C BFu15ll_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0ll_Vp, BFu15ll_BFu0ll_Vp)
//============================================================================


struct  BFu15ll_BFu0s  {
  __tsu64 v1:15;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu0s) C1{ FL:15 Fs:0}



static void Test_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s, BFu15ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu0s_BFu0c  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu0s_BFu0c) C1{ FL:15 Fs:0 Fc:0}



static void Test_BFu15ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu0c, BFu15ll_BFu0s_BFu0c)
//============================================================================


struct  BFu15ll_BFu0s_BFu0i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu0s_BFu0i) C1{ FL:15 Fs:0 Fi:0}



static void Test_BFu15ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu0i, BFu15ll_BFu0s_BFu0i)
//============================================================================


struct  BFu15ll_BFu0s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu0s_BFu0ll) C1{ FL:15 Fs:0 FL:0}



static void Test_BFu15ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu0ll, BFu15ll_BFu0s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu0s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu0s_BFu0s) C1{ FL:15 Fs:0 Fs:0}



static void Test_BFu15ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu0s, BFu15ll_BFu0s_BFu0s)
//============================================================================


struct  BFu15ll_BFu0s_BFu15i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15ll_BFu0s_BFu15i) C1{ FL:15 Fs:0 Fi:15}



static void Test_BFu15ll_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu15i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu15i, BFu15ll_BFu0s_BFu15i)
//============================================================================


struct  BFu15ll_BFu0s_BFu15ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15ll_BFu0s_BFu15ll) C1{ FL:15 Fs:0 FL:15}



static void Test_BFu15ll_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu15ll, BFu15ll_BFu0s_BFu15ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu15s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15ll_BFu0s_BFu15s) C1{ FL:15 Fs:0 Fs:15}



static void Test_BFu15ll_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu15s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu15s, BFu15ll_BFu0s_BFu15s)
//============================================================================


struct  BFu15ll_BFu0s_BFu16i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15ll_BFu0s_BFu16i) C1{ FL:15 Fs:0 Fi:16}



static void Test_BFu15ll_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu16i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu16i, BFu15ll_BFu0s_BFu16i)
//============================================================================


struct  BFu15ll_BFu0s_BFu16ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15ll_BFu0s_BFu16ll) C1{ FL:15 Fs:0 FL:16}



static void Test_BFu15ll_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu16ll, BFu15ll_BFu0s_BFu16ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu16s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15ll_BFu0s_BFu16s) C1{ FL:15 Fs:0 Fs:16}



static void Test_BFu15ll_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu16s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu16s, BFu15ll_BFu0s_BFu16s)
//============================================================================


struct  BFu15ll_BFu0s_BFu17i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15ll_BFu0s_BFu17i) C1{ FL:15 Fs:0 Fi:17}



static void Test_BFu15ll_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu17i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15ll_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu17i, BFu15ll_BFu0s_BFu17i)
//============================================================================


struct  BFu15ll_BFu0s_BFu17ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15ll_BFu0s_BFu17ll) C1{ FL:15 Fs:0 FL:17}



static void Test_BFu15ll_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu15ll_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu15ll_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu17ll, BFu15ll_BFu0s_BFu17ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu1c  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15ll_BFu0s_BFu1c) C1{ FL:15 Fs:0 Fc:1}



static void Test_BFu15ll_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu1c");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu1c, BFu15ll_BFu0s_BFu1c)
//============================================================================


struct  BFu15ll_BFu0s_BFu1i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15ll_BFu0s_BFu1i) C1{ FL:15 Fs:0 Fi:1}



static void Test_BFu15ll_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu1i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu1i, BFu15ll_BFu0s_BFu1i)
//============================================================================


struct  BFu15ll_BFu0s_BFu1ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15ll_BFu0s_BFu1ll) C1{ FL:15 Fs:0 FL:1}



static void Test_BFu15ll_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu1ll, BFu15ll_BFu0s_BFu1ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu1s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15ll_BFu0s_BFu1s) C1{ FL:15 Fs:0 Fs:1}



static void Test_BFu15ll_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu1s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15ll_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu1s, BFu15ll_BFu0s_BFu1s)
//============================================================================


struct  BFu15ll_BFu0s_BFu31i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15ll_BFu0s_BFu31i) C1{ FL:15 Fs:0 Fi:31}



static void Test_BFu15ll_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu31i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu31i, BFu15ll_BFu0s_BFu31i)
//============================================================================


struct  BFu15ll_BFu0s_BFu31ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15ll_BFu0s_BFu31ll) C1{ FL:15 Fs:0 FL:31}



static void Test_BFu15ll_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu15ll_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu31ll, BFu15ll_BFu0s_BFu31ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu32i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15ll_BFu0s_BFu32i) C1{ FL:15 Fs:0 Fi:32}



static void Test_BFu15ll_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu32i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu32i, BFu15ll_BFu0s_BFu32i)
//============================================================================


struct  BFu15ll_BFu0s_BFu32ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15ll_BFu0s_BFu32ll) C1{ FL:15 Fs:0 FL:32}



static void Test_BFu15ll_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu15ll_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu32ll, BFu15ll_BFu0s_BFu32ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu33  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15ll_BFu0s_BFu33) C1{ FL:15 Fs:0 FL:33}



static void Test_BFu15ll_BFu0s_BFu33()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu33");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu15ll_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu15ll_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu33, BFu15ll_BFu0s_BFu33)
//============================================================================


struct  BFu15ll_BFu0s_BFu7c  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15ll_BFu0s_BFu7c) C1{ FL:15 Fs:0 Fc:7}



static void Test_BFu15ll_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu7c");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu7c, BFu15ll_BFu0s_BFu7c)
//============================================================================


struct  BFu15ll_BFu0s_BFu7i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15ll_BFu0s_BFu7i) C1{ FL:15 Fs:0 Fi:7}



static void Test_BFu15ll_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu7i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu7i, BFu15ll_BFu0s_BFu7i)
//============================================================================


struct  BFu15ll_BFu0s_BFu7ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15ll_BFu0s_BFu7ll) C1{ FL:15 Fs:0 FL:7}



static void Test_BFu15ll_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu7ll, BFu15ll_BFu0s_BFu7ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu7s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15ll_BFu0s_BFu7s) C1{ FL:15 Fs:0 Fs:7}



static void Test_BFu15ll_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu7s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu7s, BFu15ll_BFu0s_BFu7s)
//============================================================================


struct  BFu15ll_BFu0s_BFu8c  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15ll_BFu0s_BFu8c) C1{ FL:15 Fs:0 Fc:8}



static void Test_BFu15ll_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu8c");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu8c, BFu15ll_BFu0s_BFu8c)
//============================================================================


struct  BFu15ll_BFu0s_BFu8i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15ll_BFu0s_BFu8i) C1{ FL:15 Fs:0 Fi:8}



static void Test_BFu15ll_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu8i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu8i, BFu15ll_BFu0s_BFu8i)
//============================================================================


struct  BFu15ll_BFu0s_BFu8ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15ll_BFu0s_BFu8ll) C1{ FL:15 Fs:0 FL:8}



static void Test_BFu15ll_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu8ll, BFu15ll_BFu0s_BFu8ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu8s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15ll_BFu0s_BFu8s) C1{ FL:15 Fs:0 Fs:8}



static void Test_BFu15ll_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu8s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu8s, BFu15ll_BFu0s_BFu8s)
//============================================================================


struct  BFu15ll_BFu0s_BFu9i  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15ll_BFu0s_BFu9i) C1{ FL:15 Fs:0 Fi:9}



static void Test_BFu15ll_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu9i");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu9i, BFu15ll_BFu0s_BFu9i)
//============================================================================


struct  BFu15ll_BFu0s_BFu9ll  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15ll_BFu0s_BFu9ll) C1{ FL:15 Fs:0 FL:9}



static void Test_BFu15ll_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu9ll, BFu15ll_BFu0s_BFu9ll)
//============================================================================


struct  BFu15ll_BFu0s_BFu9s  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15ll_BFu0s_BFu9s) C1{ FL:15 Fs:0 Fs:9}



static void Test_BFu15ll_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu15ll_BFu0s_BFu9s");
    static STRUCT_IF_C BFu15ll_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_BFu9s, BFu15ll_BFu0s_BFu9s)
//============================================================================


struct  BFu15ll_BFu0s_C  {
  __tsu64 v1:15;
  unsigned short  :0;
  char v2;
};
//SIG(1 BFu15ll_BFu0s_C) C1{ FL:15 Fs:0 Fc}



static void Test_BFu15ll_BFu0s_C()
{
  {
    init_simple_test("BFu15ll_BFu0s_C");
    static STRUCT_IF_C BFu15ll_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_C");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_C, BFu15ll_BFu0s_C)
//============================================================================


struct  BFu15ll_BFu0s_D  {
  __tsu64 v1:15;
  unsigned short  :0;
  double v2;
};
//SIG(1 BFu15ll_BFu0s_D) C1{ FL:15 Fs:0 FL}



static void Test_BFu15ll_BFu0s_D()
{
  {
    init_simple_test("BFu15ll_BFu0s_D");
    static STRUCT_IF_C BFu15ll_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_D, BFu15ll_BFu0s_D)
//============================================================================


struct  BFu15ll_BFu0s_F  {
  __tsu64 v1:15;
  unsigned short  :0;
  float v2;
};
//SIG(1 BFu15ll_BFu0s_F) C1{ FL:15 Fs:0 Fi}



static void Test_BFu15ll_BFu0s_F()
{
  {
    init_simple_test("BFu15ll_BFu0s_F");
    static STRUCT_IF_C BFu15ll_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_F");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_F, BFu15ll_BFu0s_F)
//============================================================================


struct  BFu15ll_BFu0s_I  {
  __tsu64 v1:15;
  unsigned short  :0;
  int v2;
};
//SIG(1 BFu15ll_BFu0s_I) C1{ FL:15 Fs:0 Fi}



static void Test_BFu15ll_BFu0s_I()
{
  {
    init_simple_test("BFu15ll_BFu0s_I");
    static STRUCT_IF_C BFu15ll_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_I");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_I, BFu15ll_BFu0s_I)
//============================================================================


struct  BFu15ll_BFu0s_Ip  {
  __tsu64 v1:15;
  unsigned short  :0;
  int *v2;
};
//SIG(1 BFu15ll_BFu0s_Ip) C1{ FL:15 Fs:0 Fp}



static void Test_BFu15ll_BFu0s_Ip()
{
  {
    init_simple_test("BFu15ll_BFu0s_Ip");
    static STRUCT_IF_C BFu15ll_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Ip, BFu15ll_BFu0s_Ip)
//============================================================================


struct  BFu15ll_BFu0s_L  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 BFu15ll_BFu0s_L) C1{ FL:15 Fs:0 FL}



static void Test_BFu15ll_BFu0s_L()
{
  {
    init_simple_test("BFu15ll_BFu0s_L");
    static STRUCT_IF_C BFu15ll_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_L, BFu15ll_BFu0s_L)
//============================================================================


struct  BFu15ll_BFu0s_S  {
  __tsu64 v1:15;
  unsigned short  :0;
  short v2;
};
//SIG(1 BFu15ll_BFu0s_S) C1{ FL:15 Fs:0 Fs}



static void Test_BFu15ll_BFu0s_S()
{
  {
    init_simple_test("BFu15ll_BFu0s_S");
    static STRUCT_IF_C BFu15ll_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_S");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_S, BFu15ll_BFu0s_S)
//============================================================================


struct  BFu15ll_BFu0s_Uc  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 BFu15ll_BFu0s_Uc) C1{ FL:15 Fs:0 Fc}



static void Test_BFu15ll_BFu0s_Uc()
{
  {
    init_simple_test("BFu15ll_BFu0s_Uc");
    static STRUCT_IF_C BFu15ll_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Uc");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Uc, BFu15ll_BFu0s_Uc)
//============================================================================


struct  BFu15ll_BFu0s_Ui  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 BFu15ll_BFu0s_Ui) C1{ FL:15 Fs:0 Fi}



static void Test_BFu15ll_BFu0s_Ui()
{
  {
    init_simple_test("BFu15ll_BFu0s_Ui");
    static STRUCT_IF_C BFu15ll_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Ui");
    check_field_offset(lv, v2, 4, "BFu15ll_BFu0s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Ui, BFu15ll_BFu0s_Ui)
//============================================================================


struct  BFu15ll_BFu0s_Ul  {
  __tsu64 v1:15;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 BFu15ll_BFu0s_Ul) C1{ FL:15 Fs:0 FL}



static void Test_BFu15ll_BFu0s_Ul()
{
  {
    init_simple_test("BFu15ll_BFu0s_Ul");
    static STRUCT_IF_C BFu15ll_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Ul, BFu15ll_BFu0s_Ul)
//============================================================================


struct  BFu15ll_BFu0s_Us  {
  __tsu64 v1:15;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 BFu15ll_BFu0s_Us) C1{ FL:15 Fs:0 Fs}



static void Test_BFu15ll_BFu0s_Us()
{
  {
    init_simple_test("BFu15ll_BFu0s_Us");
    static STRUCT_IF_C BFu15ll_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Us");
    check_field_offset(lv, v2, 2, "BFu15ll_BFu0s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Us, BFu15ll_BFu0s_Us)
//============================================================================


struct  BFu15ll_BFu0s_Vp  {
  __tsu64 v1:15;
  unsigned short  :0;
  void *v2;
};
//SIG(1 BFu15ll_BFu0s_Vp) C1{ FL:15 Fs:0 Fp}



static void Test_BFu15ll_BFu0s_Vp()
{
  {
    init_simple_test("BFu15ll_BFu0s_Vp");
    static STRUCT_IF_C BFu15ll_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu0s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu0s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu0s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_BFu0s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu0s_Vp, BFu15ll_BFu0s_Vp)
//============================================================================


struct  BFu15ll_BFu15i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu15i_BFu0c) C1{ FL:15 Fi:15 Fc:0}



static void Test_BFu15ll_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu15i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFu0c, BFu15ll_BFu15i_BFu0c)
//============================================================================


struct  BFu15ll_BFu15i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu15i_BFu0i) C1{ FL:15 Fi:15 Fi:0}



static void Test_BFu15ll_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFu0i, BFu15ll_BFu15i_BFu0i)
//============================================================================


struct  BFu15ll_BFu15i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu15i_BFu0ll) C1{ FL:15 Fi:15 FL:0}



static void Test_BFu15ll_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFu0ll, BFu15ll_BFu15i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu15i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu15i_BFu0s) C1{ FL:15 Fi:15 Fs:0}



static void Test_BFu15ll_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu15i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15i_BFu0s, BFu15ll_BFu15i_BFu0s)
//============================================================================


struct  BFu15ll_BFu15ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu15ll_BFu0c) C1{ FL:15 FL:15 Fc:0}



static void Test_BFu15ll_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu0c, BFu15ll_BFu15ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu15ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu15ll_BFu0i) C1{ FL:15 FL:15 Fi:0}



static void Test_BFu15ll_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu0i, BFu15ll_BFu15ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu15ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu15ll_BFu0ll) C1{ FL:15 FL:15 FL:0}



static void Test_BFu15ll_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu0ll, BFu15ll_BFu15ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu15ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu15ll_BFu0s) C1{ FL:15 FL:15 Fs:0}



static void Test_BFu15ll_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15ll_BFu0s, BFu15ll_BFu15ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu15s_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu15s_BFu0c) C1{ FL:15 Fs:15 Fc:0}



static void Test_BFu15ll_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu0c, BFu15ll_BFu15s_BFu0c)
//============================================================================


struct  BFu15ll_BFu15s_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu15s_BFu0i) C1{ FL:15 Fs:15 Fi:0}



static void Test_BFu15ll_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu0i, BFu15ll_BFu15s_BFu0i)
//============================================================================


struct  BFu15ll_BFu15s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu15s_BFu0ll) C1{ FL:15 Fs:15 FL:0}



static void Test_BFu15ll_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu0ll, BFu15ll_BFu15s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu15s_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu15s_BFu0s) C1{ FL:15 Fs:15 Fs:0}



static void Test_BFu15ll_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu15s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu15s_BFu0s, BFu15ll_BFu15s_BFu0s)
//============================================================================


struct  BFu15ll_BFu16i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu16i_BFu0c) C1{ FL:15 Fi:16 Fc:0}



static void Test_BFu15ll_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu0c, BFu15ll_BFu16i_BFu0c)
//============================================================================


struct  BFu15ll_BFu16i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu16i_BFu0i) C1{ FL:15 Fi:16 Fi:0}



static void Test_BFu15ll_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu0i, BFu15ll_BFu16i_BFu0i)
//============================================================================


struct  BFu15ll_BFu16i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu16i_BFu0ll) C1{ FL:15 Fi:16 FL:0}



static void Test_BFu15ll_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu0ll, BFu15ll_BFu16i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu16i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu16i_BFu0s) C1{ FL:15 Fi:16 Fs:0}



static void Test_BFu15ll_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu16i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16i_BFu0s, BFu15ll_BFu16i_BFu0s)
//============================================================================


struct  BFu15ll_BFu16ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu16ll_BFu0c) C1{ FL:15 FL:16 Fc:0}



static void Test_BFu15ll_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu0c, BFu15ll_BFu16ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu16ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu16ll_BFu0i) C1{ FL:15 FL:16 Fi:0}



static void Test_BFu15ll_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu0i, BFu15ll_BFu16ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu16ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu16ll_BFu0ll) C1{ FL:15 FL:16 FL:0}



static void Test_BFu15ll_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu0ll, BFu15ll_BFu16ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu16ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu16ll_BFu0s) C1{ FL:15 FL:16 Fs:0}



static void Test_BFu15ll_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16ll_BFu0s, BFu15ll_BFu16ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu16s_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu16s_BFu0c) C1{ FL:15 Fs:16 Fc:0}



static void Test_BFu15ll_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu0c, BFu15ll_BFu16s_BFu0c)
//============================================================================


struct  BFu15ll_BFu16s_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu16s_BFu0i) C1{ FL:15 Fs:16 Fi:0}



static void Test_BFu15ll_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu0i, BFu15ll_BFu16s_BFu0i)
//============================================================================


struct  BFu15ll_BFu16s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu16s_BFu0ll) C1{ FL:15 Fs:16 FL:0}



static void Test_BFu15ll_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu0ll, BFu15ll_BFu16s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu16s_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu16s_BFu0s) C1{ FL:15 Fs:16 Fs:0}



static void Test_BFu15ll_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu16s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu16s_BFu0s, BFu15ll_BFu16s_BFu0s)
//============================================================================


struct  BFu15ll_BFu17i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu17i_BFu0c) C1{ FL:15 Fi:17 Fc:0}



static void Test_BFu15ll_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu0c, BFu15ll_BFu17i_BFu0c)
//============================================================================


struct  BFu15ll_BFu17i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu17i_BFu0i) C1{ FL:15 Fi:17 Fi:0}



static void Test_BFu15ll_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu0i, BFu15ll_BFu17i_BFu0i)
//============================================================================


struct  BFu15ll_BFu17i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu17i_BFu0ll) C1{ FL:15 Fi:17 FL:0}



static void Test_BFu15ll_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu0ll, BFu15ll_BFu17i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu17i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu17i_BFu0s) C1{ FL:15 Fi:17 Fs:0}



static void Test_BFu15ll_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu17i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17i_BFu0s, BFu15ll_BFu17i_BFu0s)
//============================================================================


struct  BFu15ll_BFu17ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu17ll_BFu0c) C1{ FL:15 FL:17 Fc:0}



static void Test_BFu15ll_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu0c, BFu15ll_BFu17ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu17ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu17ll_BFu0i) C1{ FL:15 FL:17 Fi:0}



static void Test_BFu15ll_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu0i, BFu15ll_BFu17ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu17ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu17ll_BFu0ll) C1{ FL:15 FL:17 FL:0}



static void Test_BFu15ll_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu0ll, BFu15ll_BFu17ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu17ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu17ll_BFu0s) C1{ FL:15 FL:17 Fs:0}



static void Test_BFu15ll_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu17ll_BFu0s, BFu15ll_BFu17ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu1c_BFu0c  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu1c_BFu0c) C1{ FL:15 Fc:1 Fc:0}



static void Test_BFu15ll_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu0c, BFu15ll_BFu1c_BFu0c)
//============================================================================


struct  BFu15ll_BFu1c_BFu0i  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu1c_BFu0i) C1{ FL:15 Fc:1 Fi:0}



static void Test_BFu15ll_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu0i, BFu15ll_BFu1c_BFu0i)
//============================================================================


struct  BFu15ll_BFu1c_BFu0ll  {
  __tsu64 v1:15;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu1c_BFu0ll) C1{ FL:15 Fc:1 FL:0}



static void Test_BFu15ll_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu0ll, BFu15ll_BFu1c_BFu0ll)
//============================================================================


struct  BFu15ll_BFu1c_BFu0s  {
  __tsu64 v1:15;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu1c_BFu0s) C1{ FL:15 Fc:1 Fs:0}



static void Test_BFu15ll_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu1c_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1c_BFu0s, BFu15ll_BFu1c_BFu0s)
//============================================================================


struct  BFu15ll_BFu1i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu1i_BFu0c) C1{ FL:15 Fi:1 Fc:0}



static void Test_BFu15ll_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu0c, BFu15ll_BFu1i_BFu0c)
//============================================================================


struct  BFu15ll_BFu1i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu1i_BFu0i) C1{ FL:15 Fi:1 Fi:0}



static void Test_BFu15ll_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu0i, BFu15ll_BFu1i_BFu0i)
//============================================================================


struct  BFu15ll_BFu1i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu1i_BFu0ll) C1{ FL:15 Fi:1 FL:0}



static void Test_BFu15ll_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu0ll, BFu15ll_BFu1i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu1i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu1i_BFu0s) C1{ FL:15 Fi:1 Fs:0}



static void Test_BFu15ll_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu1i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu1i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1i_BFu0s, BFu15ll_BFu1i_BFu0s)
//============================================================================


struct  BFu15ll_BFu1ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu1ll_BFu0c) C1{ FL:15 FL:1 Fc:0}



static void Test_BFu15ll_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu0c, BFu15ll_BFu1ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu1ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu1ll_BFu0i) C1{ FL:15 FL:1 Fi:0}



static void Test_BFu15ll_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu0i, BFu15ll_BFu1ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu1ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu1ll_BFu0ll) C1{ FL:15 FL:1 FL:0}



static void Test_BFu15ll_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu0ll, BFu15ll_BFu1ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu1ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu1ll_BFu0s) C1{ FL:15 FL:1 Fs:0}



static void Test_BFu15ll_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1ll_BFu0s, BFu15ll_BFu1ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu1s_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu1s_BFu0c) C1{ FL:15 Fs:1 Fc:0}



static void Test_BFu15ll_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu0c, BFu15ll_BFu1s_BFu0c)
//============================================================================


struct  BFu15ll_BFu1s_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu1s_BFu0i) C1{ FL:15 Fs:1 Fi:0}



static void Test_BFu15ll_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu0i, BFu15ll_BFu1s_BFu0i)
//============================================================================


struct  BFu15ll_BFu1s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu1s_BFu0ll) C1{ FL:15 Fs:1 FL:0}



static void Test_BFu15ll_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu0ll, BFu15ll_BFu1s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu1s_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu1s_BFu0s) C1{ FL:15 Fs:1 Fs:0}



static void Test_BFu15ll_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu1s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu1s_BFu0s, BFu15ll_BFu1s_BFu0s)
//============================================================================


struct  BFu15ll_BFu31i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu31i_BFu0c) C1{ FL:15 Fi:31 Fc:0}



static void Test_BFu15ll_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu0c, BFu15ll_BFu31i_BFu0c)
//============================================================================


struct  BFu15ll_BFu31i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu31i_BFu0i) C1{ FL:15 Fi:31 Fi:0}



static void Test_BFu15ll_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu0i, BFu15ll_BFu31i_BFu0i)
//============================================================================


struct  BFu15ll_BFu31i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu31i_BFu0ll) C1{ FL:15 Fi:31 FL:0}



static void Test_BFu15ll_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu0ll, BFu15ll_BFu31i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu31i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu31i_BFu0s) C1{ FL:15 Fi:31 Fs:0}



static void Test_BFu15ll_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu31i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31i_BFu0s, BFu15ll_BFu31i_BFu0s)
//============================================================================


struct  BFu15ll_BFu31ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu31ll_BFu0c) C1{ FL:15 FL:31 Fc:0}



static void Test_BFu15ll_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu0c, BFu15ll_BFu31ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu31ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu31ll_BFu0i) C1{ FL:15 FL:31 Fi:0}



static void Test_BFu15ll_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu0i, BFu15ll_BFu31ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu31ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu31ll_BFu0ll) C1{ FL:15 FL:31 FL:0}



static void Test_BFu15ll_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu0ll, BFu15ll_BFu31ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu31ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu31ll_BFu0s) C1{ FL:15 FL:31 Fs:0}



static void Test_BFu15ll_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu31ll_BFu0s, BFu15ll_BFu31ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu32i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu32i_BFu0c) C1{ FL:15 Fi:32 Fc:0}



static void Test_BFu15ll_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu0c, BFu15ll_BFu32i_BFu0c)
//============================================================================


struct  BFu15ll_BFu32i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu32i_BFu0i) C1{ FL:15 Fi:32 Fi:0}



static void Test_BFu15ll_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu0i, BFu15ll_BFu32i_BFu0i)
//============================================================================


struct  BFu15ll_BFu32i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu32i_BFu0ll) C1{ FL:15 Fi:32 FL:0}



static void Test_BFu15ll_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu0ll, BFu15ll_BFu32i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu32i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu32i_BFu0s) C1{ FL:15 Fi:32 Fs:0}



static void Test_BFu15ll_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu32i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32i_BFu0s, BFu15ll_BFu32i_BFu0s)
//============================================================================


struct  BFu15ll_BFu32ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu32ll_BFu0c) C1{ FL:15 FL:32 Fc:0}



static void Test_BFu15ll_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu0c, BFu15ll_BFu32ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu32ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu32ll_BFu0i) C1{ FL:15 FL:32 Fi:0}



static void Test_BFu15ll_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu0i, BFu15ll_BFu32ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu32ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu32ll_BFu0ll) C1{ FL:15 FL:32 FL:0}



static void Test_BFu15ll_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu0ll, BFu15ll_BFu32ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu32ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu32ll_BFu0s) C1{ FL:15 FL:32 Fs:0}



static void Test_BFu15ll_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu32ll_BFu0s, BFu15ll_BFu32ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu33_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu33_BFu0c) C1{ FL:15 FL:33 Fc:0}



static void Test_BFu15ll_BFu33_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu0c, BFu15ll_BFu33_BFu0c)
//============================================================================


struct  BFu15ll_BFu33_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu33_BFu0i) C1{ FL:15 FL:33 Fi:0}



static void Test_BFu15ll_BFu33_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu0i, BFu15ll_BFu33_BFu0i)
//============================================================================


struct  BFu15ll_BFu33_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu33_BFu0ll) C1{ FL:15 FL:33 FL:0}



static void Test_BFu15ll_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu0ll, BFu15ll_BFu33_BFu0ll)
//============================================================================


struct  BFu15ll_BFu33_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu33_BFu0s) C1{ FL:15 FL:33 Fs:0}



static void Test_BFu15ll_BFu33_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu33_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu33_BFu0s, BFu15ll_BFu33_BFu0s)
//============================================================================


struct  BFu15ll_BFu7c_BFu0c  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu7c_BFu0c) C1{ FL:15 Fc:7 Fc:0}



static void Test_BFu15ll_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu0c, BFu15ll_BFu7c_BFu0c)
//============================================================================


struct  BFu15ll_BFu7c_BFu0i  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu7c_BFu0i) C1{ FL:15 Fc:7 Fi:0}



static void Test_BFu15ll_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu0i, BFu15ll_BFu7c_BFu0i)
//============================================================================


struct  BFu15ll_BFu7c_BFu0ll  {
  __tsu64 v1:15;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu7c_BFu0ll) C1{ FL:15 Fc:7 FL:0}



static void Test_BFu15ll_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu0ll, BFu15ll_BFu7c_BFu0ll)
//============================================================================


struct  BFu15ll_BFu7c_BFu0s  {
  __tsu64 v1:15;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu7c_BFu0s) C1{ FL:15 Fc:7 Fs:0}



static void Test_BFu15ll_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu7c_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7c_BFu0s, BFu15ll_BFu7c_BFu0s)
//============================================================================


struct  BFu15ll_BFu7i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu7i_BFu0c) C1{ FL:15 Fi:7 Fc:0}



static void Test_BFu15ll_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu0c, BFu15ll_BFu7i_BFu0c)
//============================================================================


struct  BFu15ll_BFu7i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu7i_BFu0i) C1{ FL:15 Fi:7 Fi:0}



static void Test_BFu15ll_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu0i, BFu15ll_BFu7i_BFu0i)
//============================================================================


struct  BFu15ll_BFu7i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu7i_BFu0ll) C1{ FL:15 Fi:7 FL:0}



static void Test_BFu15ll_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu0ll, BFu15ll_BFu7i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu7i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu7i_BFu0s) C1{ FL:15 Fi:7 Fs:0}



static void Test_BFu15ll_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu7i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu7i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7i_BFu0s, BFu15ll_BFu7i_BFu0s)
//============================================================================


struct  BFu15ll_BFu7ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu7ll_BFu0c) C1{ FL:15 FL:7 Fc:0}



static void Test_BFu15ll_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu0c, BFu15ll_BFu7ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu7ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu7ll_BFu0i) C1{ FL:15 FL:7 Fi:0}



static void Test_BFu15ll_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu0i, BFu15ll_BFu7ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu7ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu7ll_BFu0ll) C1{ FL:15 FL:7 FL:0}



static void Test_BFu15ll_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu0ll, BFu15ll_BFu7ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu7ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu7ll_BFu0s) C1{ FL:15 FL:7 Fs:0}



static void Test_BFu15ll_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7ll_BFu0s, BFu15ll_BFu7ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu7s_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu7s_BFu0c) C1{ FL:15 Fs:7 Fc:0}



static void Test_BFu15ll_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu0c, BFu15ll_BFu7s_BFu0c)
//============================================================================


struct  BFu15ll_BFu7s_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu7s_BFu0i) C1{ FL:15 Fs:7 Fi:0}



static void Test_BFu15ll_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu0i, BFu15ll_BFu7s_BFu0i)
//============================================================================


struct  BFu15ll_BFu7s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu7s_BFu0ll) C1{ FL:15 Fs:7 FL:0}



static void Test_BFu15ll_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu0ll, BFu15ll_BFu7s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu7s_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu7s_BFu0s) C1{ FL:15 Fs:7 Fs:0}



static void Test_BFu15ll_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu7s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu7s_BFu0s, BFu15ll_BFu7s_BFu0s)
//============================================================================


struct  BFu15ll_BFu8c_BFu0c  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu8c_BFu0c) C1{ FL:15 Fc:8 Fc:0}



static void Test_BFu15ll_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu0c, BFu15ll_BFu8c_BFu0c)
//============================================================================


struct  BFu15ll_BFu8c_BFu0i  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu8c_BFu0i) C1{ FL:15 Fc:8 Fi:0}



static void Test_BFu15ll_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu0i, BFu15ll_BFu8c_BFu0i)
//============================================================================


struct  BFu15ll_BFu8c_BFu0ll  {
  __tsu64 v1:15;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu8c_BFu0ll) C1{ FL:15 Fc:8 FL:0}



static void Test_BFu15ll_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu0ll, BFu15ll_BFu8c_BFu0ll)
//============================================================================


struct  BFu15ll_BFu8c_BFu0s  {
  __tsu64 v1:15;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu8c_BFu0s) C1{ FL:15 Fc:8 Fs:0}



static void Test_BFu15ll_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu8c_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8c_BFu0s, BFu15ll_BFu8c_BFu0s)
//============================================================================


struct  BFu15ll_BFu8i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu8i_BFu0c) C1{ FL:15 Fi:8 Fc:0}



static void Test_BFu15ll_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu0c, BFu15ll_BFu8i_BFu0c)
//============================================================================


struct  BFu15ll_BFu8i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu8i_BFu0i) C1{ FL:15 Fi:8 Fi:0}



static void Test_BFu15ll_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu0i, BFu15ll_BFu8i_BFu0i)
//============================================================================


struct  BFu15ll_BFu8i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu8i_BFu0ll) C1{ FL:15 Fi:8 FL:0}



static void Test_BFu15ll_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu0ll, BFu15ll_BFu8i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu8i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu8i_BFu0s) C1{ FL:15 Fi:8 Fs:0}



static void Test_BFu15ll_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu8i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8i_BFu0s, BFu15ll_BFu8i_BFu0s)
//============================================================================


struct  BFu15ll_BFu8ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu8ll_BFu0c) C1{ FL:15 FL:8 Fc:0}



static void Test_BFu15ll_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu0c, BFu15ll_BFu8ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu8ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu8ll_BFu0i) C1{ FL:15 FL:8 Fi:0}



static void Test_BFu15ll_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu0i, BFu15ll_BFu8ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu8ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu8ll_BFu0ll) C1{ FL:15 FL:8 FL:0}



static void Test_BFu15ll_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu0ll, BFu15ll_BFu8ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu8ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu8ll_BFu0s) C1{ FL:15 FL:8 Fs:0}



static void Test_BFu15ll_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8ll_BFu0s, BFu15ll_BFu8ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu8s_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu8s_BFu0c) C1{ FL:15 Fs:8 Fc:0}



static void Test_BFu15ll_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu0c, BFu15ll_BFu8s_BFu0c)
//============================================================================


struct  BFu15ll_BFu8s_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu8s_BFu0i) C1{ FL:15 Fs:8 Fi:0}



static void Test_BFu15ll_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu0i, BFu15ll_BFu8s_BFu0i)
//============================================================================


struct  BFu15ll_BFu8s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu8s_BFu0ll) C1{ FL:15 Fs:8 FL:0}



static void Test_BFu15ll_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu0ll, BFu15ll_BFu8s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu8s_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu8s_BFu0s) C1{ FL:15 Fs:8 Fs:0}



static void Test_BFu15ll_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu8s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu8s_BFu0s, BFu15ll_BFu8s_BFu0s)
//============================================================================


struct  BFu15ll_BFu9i_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu9i_BFu0c) C1{ FL:15 Fi:9 Fc:0}



static void Test_BFu15ll_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu9i_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu9i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9i_BFu0c, BFu15ll_BFu9i_BFu0c)
//============================================================================


struct  BFu15ll_BFu9i_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu9i_BFu0i) C1{ FL:15 Fi:9 Fi:0}



static void Test_BFu15ll_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu9i_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9i_BFu0i, BFu15ll_BFu9i_BFu0i)
//============================================================================


struct  BFu15ll_BFu9i_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu9i_BFu0ll) C1{ FL:15 Fi:9 FL:0}



static void Test_BFu15ll_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9i_BFu0ll, BFu15ll_BFu9i_BFu0ll)
//============================================================================


struct  BFu15ll_BFu9i_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu9i_BFu0s) C1{ FL:15 Fi:9 Fs:0}



static void Test_BFu15ll_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu9i_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9i_BFu0s, BFu15ll_BFu9i_BFu0s)
//============================================================================


struct  BFu15ll_BFu9ll_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu9ll_BFu0c) C1{ FL:15 FL:9 Fc:0}



static void Test_BFu15ll_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9ll_BFu0c, BFu15ll_BFu9ll_BFu0c)
//============================================================================


struct  BFu15ll_BFu9ll_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu9ll_BFu0i) C1{ FL:15 FL:9 Fi:0}



static void Test_BFu15ll_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9ll_BFu0i, BFu15ll_BFu9ll_BFu0i)
//============================================================================


struct  BFu15ll_BFu9ll_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu9ll_BFu0ll) C1{ FL:15 FL:9 FL:0}



static void Test_BFu15ll_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9ll_BFu0ll, BFu15ll_BFu9ll_BFu0ll)
//============================================================================


struct  BFu15ll_BFu9ll_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu9ll_BFu0s) C1{ FL:15 FL:9 Fs:0}



static void Test_BFu15ll_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9ll_BFu0s, BFu15ll_BFu9ll_BFu0s)
//============================================================================


struct  BFu15ll_BFu9s_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 BFu15ll_BFu9s_BFu0c) C1{ FL:15 Fs:9 Fc:0}



static void Test_BFu15ll_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu15ll_BFu9s_BFu0c");
    static STRUCT_IF_C BFu15ll_BFu9s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu9s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9s_BFu0c, BFu15ll_BFu9s_BFu0c)
//============================================================================


struct  BFu15ll_BFu9s_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 BFu15ll_BFu9s_BFu0i) C1{ FL:15 Fs:9 Fi:0}



static void Test_BFu15ll_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu15ll_BFu9s_BFu0i");
    static STRUCT_IF_C BFu15ll_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu9s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9s_BFu0i, BFu15ll_BFu9s_BFu0i)
//============================================================================


struct  BFu15ll_BFu9s_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 BFu15ll_BFu9s_BFu0ll) C1{ FL:15 Fs:9 FL:0}



static void Test_BFu15ll_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu15ll_BFu9s_BFu0ll");
    static STRUCT_IF_C BFu15ll_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu9s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9s_BFu0ll, BFu15ll_BFu9s_BFu0ll)
//============================================================================


struct  BFu15ll_BFu9s_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 BFu15ll_BFu9s_BFu0s) C1{ FL:15 Fs:9 Fs:0}



static void Test_BFu15ll_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu15ll_BFu9s_BFu0s");
    static STRUCT_IF_C BFu15ll_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu9s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_BFu9s_BFu0s, BFu15ll_BFu9s_BFu0s)
//============================================================================


struct  BFu15ll_C_BFu0c  {
  __tsu64 v1:15;
  char v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_C_BFu0c) C1{ FL:15 Fc Fc:0}



static void Test_BFu15ll_C_BFu0c()
{
  {
    init_simple_test("BFu15ll_C_BFu0c");
    static STRUCT_IF_C BFu15ll_C_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_C_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_C_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_C_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_C_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15ll_C_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_C_BFu0c, BFu15ll_C_BFu0c)
//============================================================================


struct  BFu15ll_C_BFu0i  {
  __tsu64 v1:15;
  char v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_C_BFu0i) C1{ FL:15 Fc Fi:0}



static void Test_BFu15ll_C_BFu0i()
{
  {
    init_simple_test("BFu15ll_C_BFu0i");
    static STRUCT_IF_C BFu15ll_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_C_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_C_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_C_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15ll_C_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_C_BFu0i, BFu15ll_C_BFu0i)
//============================================================================


struct  BFu15ll_C_BFu0ll  {
  __tsu64 v1:15;
  char v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_C_BFu0ll) C1{ FL:15 Fc FL:0}



static void Test_BFu15ll_C_BFu0ll()
{
  {
    init_simple_test("BFu15ll_C_BFu0ll");
    static STRUCT_IF_C BFu15ll_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_C_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_C_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_C_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15ll_C_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_C_BFu0ll, BFu15ll_C_BFu0ll)
//============================================================================


struct  BFu15ll_C_BFu0s  {
  __tsu64 v1:15;
  char v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_C_BFu0s) C1{ FL:15 Fc Fs:0}



static void Test_BFu15ll_C_BFu0s()
{
  {
    init_simple_test("BFu15ll_C_BFu0s");
    static STRUCT_IF_C BFu15ll_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_C_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_C_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_C_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15ll_C_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_C_BFu0s, BFu15ll_C_BFu0s)
//============================================================================


struct  BFu15ll_D_BFu0c  {
  __tsu64 v1:15;
  double v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_D_BFu0c) C1{ FL:15 FL Fc:0}



static void Test_BFu15ll_D_BFu0c()
{
  {
    init_simple_test("BFu15ll_D_BFu0c");
    static STRUCT_IF_C BFu15ll_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_D_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_D_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_D_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_D_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_D_BFu0c, BFu15ll_D_BFu0c)
//============================================================================


struct  BFu15ll_D_BFu0i  {
  __tsu64 v1:15;
  double v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_D_BFu0i) C1{ FL:15 FL Fi:0}



static void Test_BFu15ll_D_BFu0i()
{
  {
    init_simple_test("BFu15ll_D_BFu0i");
    static STRUCT_IF_C BFu15ll_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_D_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_D_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_D_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_D_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_D_BFu0i, BFu15ll_D_BFu0i)
//============================================================================


struct  BFu15ll_D_BFu0ll  {
  __tsu64 v1:15;
  double v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_D_BFu0ll) C1{ FL:15 FL FL:0}



static void Test_BFu15ll_D_BFu0ll()
{
  {
    init_simple_test("BFu15ll_D_BFu0ll");
    static STRUCT_IF_C BFu15ll_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_D_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_D_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_D_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_D_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_D_BFu0ll, BFu15ll_D_BFu0ll)
//============================================================================


struct  BFu15ll_D_BFu0s  {
  __tsu64 v1:15;
  double v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_D_BFu0s) C1{ FL:15 FL Fs:0}



static void Test_BFu15ll_D_BFu0s()
{
  {
    init_simple_test("BFu15ll_D_BFu0s");
    static STRUCT_IF_C BFu15ll_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_D_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_D_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_D_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_D_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_D_BFu0s, BFu15ll_D_BFu0s)
//============================================================================


struct  BFu15ll_F_BFu0c  {
  __tsu64 v1:15;
  float v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_F_BFu0c) C1{ FL:15 Fi Fc:0}



static void Test_BFu15ll_F_BFu0c()
{
  {
    init_simple_test("BFu15ll_F_BFu0c");
    static STRUCT_IF_C BFu15ll_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_F_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_F_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_F_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_F_BFu0c");
    check_field_offset(lv, v2, 4, "BFu15ll_F_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_F_BFu0c, BFu15ll_F_BFu0c)
//============================================================================


struct  BFu15ll_F_BFu0i  {
  __tsu64 v1:15;
  float v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_F_BFu0i) C1{ FL:15 Fi Fi:0}



static void Test_BFu15ll_F_BFu0i()
{
  {
    init_simple_test("BFu15ll_F_BFu0i");
    static STRUCT_IF_C BFu15ll_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_F_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_F_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_F_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_F_BFu0i");
    check_field_offset(lv, v2, 4, "BFu15ll_F_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_F_BFu0i, BFu15ll_F_BFu0i)
//============================================================================


struct  BFu15ll_F_BFu0ll  {
  __tsu64 v1:15;
  float v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_F_BFu0ll) C1{ FL:15 Fi FL:0}



static void Test_BFu15ll_F_BFu0ll()
{
  {
    init_simple_test("BFu15ll_F_BFu0ll");
    static STRUCT_IF_C BFu15ll_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_F_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_F_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_F_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu15ll_F_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_F_BFu0ll, BFu15ll_F_BFu0ll)
//============================================================================


struct  BFu15ll_F_BFu0s  {
  __tsu64 v1:15;
  float v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_F_BFu0s) C1{ FL:15 Fi Fs:0}



static void Test_BFu15ll_F_BFu0s()
{
  {
    init_simple_test("BFu15ll_F_BFu0s");
    static STRUCT_IF_C BFu15ll_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_F_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_F_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_F_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_F_BFu0s");
    check_field_offset(lv, v2, 4, "BFu15ll_F_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_F_BFu0s, BFu15ll_F_BFu0s)
//============================================================================


struct  BFu15ll_I_BFu0c  {
  __tsu64 v1:15;
  int v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_I_BFu0c) C1{ FL:15 Fi Fc:0}



static void Test_BFu15ll_I_BFu0c()
{
  {
    init_simple_test("BFu15ll_I_BFu0c");
    static STRUCT_IF_C BFu15ll_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_I_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_I_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_I_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_I_BFu0c");
    check_field_offset(lv, v2, 4, "BFu15ll_I_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_I_BFu0c, BFu15ll_I_BFu0c)
//============================================================================


struct  BFu15ll_I_BFu0i  {
  __tsu64 v1:15;
  int v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_I_BFu0i) C1{ FL:15 Fi Fi:0}



static void Test_BFu15ll_I_BFu0i()
{
  {
    init_simple_test("BFu15ll_I_BFu0i");
    static STRUCT_IF_C BFu15ll_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_I_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_I_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_I_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_I_BFu0i");
    check_field_offset(lv, v2, 4, "BFu15ll_I_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_I_BFu0i, BFu15ll_I_BFu0i)
//============================================================================


struct  BFu15ll_I_BFu0ll  {
  __tsu64 v1:15;
  int v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_I_BFu0ll) C1{ FL:15 Fi FL:0}



static void Test_BFu15ll_I_BFu0ll()
{
  {
    init_simple_test("BFu15ll_I_BFu0ll");
    static STRUCT_IF_C BFu15ll_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_I_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_I_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_I_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu15ll_I_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_I_BFu0ll, BFu15ll_I_BFu0ll)
//============================================================================


struct  BFu15ll_I_BFu0s  {
  __tsu64 v1:15;
  int v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_I_BFu0s) C1{ FL:15 Fi Fs:0}



static void Test_BFu15ll_I_BFu0s()
{
  {
    init_simple_test("BFu15ll_I_BFu0s");
    static STRUCT_IF_C BFu15ll_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_I_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_I_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_I_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_I_BFu0s");
    check_field_offset(lv, v2, 4, "BFu15ll_I_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_I_BFu0s, BFu15ll_I_BFu0s)
//============================================================================


struct  BFu15ll_Ip_BFu0c  {
  __tsu64 v1:15;
  int *v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_Ip_BFu0c) C1{ FL:15 Fp Fc:0}



static void Test_BFu15ll_Ip_BFu0c()
{
  {
    init_simple_test("BFu15ll_Ip_BFu0c");
    static STRUCT_IF_C BFu15ll_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ip_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ip_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ip_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ip_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ip_BFu0c, BFu15ll_Ip_BFu0c)
//============================================================================


struct  BFu15ll_Ip_BFu0i  {
  __tsu64 v1:15;
  int *v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_Ip_BFu0i) C1{ FL:15 Fp Fi:0}



static void Test_BFu15ll_Ip_BFu0i()
{
  {
    init_simple_test("BFu15ll_Ip_BFu0i");
    static STRUCT_IF_C BFu15ll_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ip_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ip_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ip_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ip_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ip_BFu0i, BFu15ll_Ip_BFu0i)
//============================================================================


struct  BFu15ll_Ip_BFu0ll  {
  __tsu64 v1:15;
  int *v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_Ip_BFu0ll) C1{ FL:15 Fp FL:0}



static void Test_BFu15ll_Ip_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Ip_BFu0ll");
    static STRUCT_IF_C BFu15ll_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ip_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ip_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ip_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ip_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ip_BFu0ll, BFu15ll_Ip_BFu0ll)
//============================================================================


struct  BFu15ll_Ip_BFu0s  {
  __tsu64 v1:15;
  int *v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_Ip_BFu0s) C1{ FL:15 Fp Fs:0}



static void Test_BFu15ll_Ip_BFu0s()
{
  {
    init_simple_test("BFu15ll_Ip_BFu0s");
    static STRUCT_IF_C BFu15ll_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ip_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ip_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ip_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ip_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ip_BFu0s, BFu15ll_Ip_BFu0s)
//============================================================================


struct  BFu15ll_L_BFu0c  {
  __tsu64 v1:15;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_L_BFu0c) C1{ FL:15 FL Fc:0}



static void Test_BFu15ll_L_BFu0c()
{
  {
    init_simple_test("BFu15ll_L_BFu0c");
    static STRUCT_IF_C BFu15ll_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_L_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_L_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_L_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_L_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_L_BFu0c, BFu15ll_L_BFu0c)
//============================================================================


struct  BFu15ll_L_BFu0i  {
  __tsu64 v1:15;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_L_BFu0i) C1{ FL:15 FL Fi:0}



static void Test_BFu15ll_L_BFu0i()
{
  {
    init_simple_test("BFu15ll_L_BFu0i");
    static STRUCT_IF_C BFu15ll_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_L_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_L_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_L_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_L_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_L_BFu0i, BFu15ll_L_BFu0i)
//============================================================================


struct  BFu15ll_L_BFu0ll  {
  __tsu64 v1:15;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_L_BFu0ll) C1{ FL:15 FL FL:0}



static void Test_BFu15ll_L_BFu0ll()
{
  {
    init_simple_test("BFu15ll_L_BFu0ll");
    static STRUCT_IF_C BFu15ll_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_L_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_L_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_L_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_L_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_L_BFu0ll, BFu15ll_L_BFu0ll)
//============================================================================


struct  BFu15ll_L_BFu0s  {
  __tsu64 v1:15;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_L_BFu0s) C1{ FL:15 FL Fs:0}



static void Test_BFu15ll_L_BFu0s()
{
  {
    init_simple_test("BFu15ll_L_BFu0s");
    static STRUCT_IF_C BFu15ll_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_L_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_L_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_L_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_L_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_L_BFu0s, BFu15ll_L_BFu0s)
//============================================================================


struct  BFu15ll_S_BFu0c  {
  __tsu64 v1:15;
  short v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_S_BFu0c) C1{ FL:15 Fs Fc:0}



static void Test_BFu15ll_S_BFu0c()
{
  {
    init_simple_test("BFu15ll_S_BFu0c");
    static STRUCT_IF_C BFu15ll_S_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_S_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_S_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_S_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_S_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15ll_S_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_S_BFu0c, BFu15ll_S_BFu0c)
//============================================================================


struct  BFu15ll_S_BFu0i  {
  __tsu64 v1:15;
  short v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_S_BFu0i) C1{ FL:15 Fs Fi:0}



static void Test_BFu15ll_S_BFu0i()
{
  {
    init_simple_test("BFu15ll_S_BFu0i");
    static STRUCT_IF_C BFu15ll_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_S_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_S_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_S_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15ll_S_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_S_BFu0i, BFu15ll_S_BFu0i)
//============================================================================


struct  BFu15ll_S_BFu0ll  {
  __tsu64 v1:15;
  short v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_S_BFu0ll) C1{ FL:15 Fs FL:0}



static void Test_BFu15ll_S_BFu0ll()
{
  {
    init_simple_test("BFu15ll_S_BFu0ll");
    static STRUCT_IF_C BFu15ll_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_S_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_S_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_S_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15ll_S_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_S_BFu0ll, BFu15ll_S_BFu0ll)
//============================================================================


struct  BFu15ll_S_BFu0s  {
  __tsu64 v1:15;
  short v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_S_BFu0s) C1{ FL:15 Fs Fs:0}



static void Test_BFu15ll_S_BFu0s()
{
  {
    init_simple_test("BFu15ll_S_BFu0s");
    static STRUCT_IF_C BFu15ll_S_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_S_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_S_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_S_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15ll_S_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_S_BFu0s, BFu15ll_S_BFu0s)
//============================================================================


struct  BFu15ll_Uc_BFu0c  {
  __tsu64 v1:15;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_Uc_BFu0c) C1{ FL:15 Fc Fc:0}



static void Test_BFu15ll_Uc_BFu0c()
{
  {
    init_simple_test("BFu15ll_Uc_BFu0c");
    static STRUCT_IF_C BFu15ll_Uc_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Uc_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Uc_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Uc_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Uc_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15ll_Uc_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Uc_BFu0c, BFu15ll_Uc_BFu0c)
//============================================================================


struct  BFu15ll_Uc_BFu0i  {
  __tsu64 v1:15;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_Uc_BFu0i) C1{ FL:15 Fc Fi:0}



static void Test_BFu15ll_Uc_BFu0i()
{
  {
    init_simple_test("BFu15ll_Uc_BFu0i");
    static STRUCT_IF_C BFu15ll_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Uc_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Uc_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Uc_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15ll_Uc_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Uc_BFu0i, BFu15ll_Uc_BFu0i)
//============================================================================


struct  BFu15ll_Uc_BFu0ll  {
  __tsu64 v1:15;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_Uc_BFu0ll) C1{ FL:15 Fc FL:0}



static void Test_BFu15ll_Uc_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Uc_BFu0ll");
    static STRUCT_IF_C BFu15ll_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Uc_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Uc_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Uc_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Uc_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Uc_BFu0ll, BFu15ll_Uc_BFu0ll)
//============================================================================


struct  BFu15ll_Uc_BFu0s  {
  __tsu64 v1:15;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_Uc_BFu0s) C1{ FL:15 Fc Fs:0}



static void Test_BFu15ll_Uc_BFu0s()
{
  {
    init_simple_test("BFu15ll_Uc_BFu0s");
    static STRUCT_IF_C BFu15ll_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Uc_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Uc_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Uc_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15ll_Uc_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Uc_BFu0s, BFu15ll_Uc_BFu0s)
//============================================================================


struct  BFu15ll_Ui_BFu0c  {
  __tsu64 v1:15;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_Ui_BFu0c) C1{ FL:15 Fi Fc:0}



static void Test_BFu15ll_Ui_BFu0c()
{
  {
    init_simple_test("BFu15ll_Ui_BFu0c");
    static STRUCT_IF_C BFu15ll_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Ui_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ui_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ui_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ui_BFu0c");
    check_field_offset(lv, v2, 4, "BFu15ll_Ui_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ui_BFu0c, BFu15ll_Ui_BFu0c)
//============================================================================


struct  BFu15ll_Ui_BFu0i  {
  __tsu64 v1:15;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_Ui_BFu0i) C1{ FL:15 Fi Fi:0}



static void Test_BFu15ll_Ui_BFu0i()
{
  {
    init_simple_test("BFu15ll_Ui_BFu0i");
    static STRUCT_IF_C BFu15ll_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Ui_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ui_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ui_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ui_BFu0i");
    check_field_offset(lv, v2, 4, "BFu15ll_Ui_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ui_BFu0i, BFu15ll_Ui_BFu0i)
//============================================================================


struct  BFu15ll_Ui_BFu0ll  {
  __tsu64 v1:15;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_Ui_BFu0ll) C1{ FL:15 Fi FL:0}



static void Test_BFu15ll_Ui_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Ui_BFu0ll");
    static STRUCT_IF_C BFu15ll_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ui_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ui_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ui_BFu0ll");
    check_field_offset(lv, v2, 4, "BFu15ll_Ui_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ui_BFu0ll, BFu15ll_Ui_BFu0ll)
//============================================================================


struct  BFu15ll_Ui_BFu0s  {
  __tsu64 v1:15;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_Ui_BFu0s) C1{ FL:15 Fi Fs:0}



static void Test_BFu15ll_Ui_BFu0s()
{
  {
    init_simple_test("BFu15ll_Ui_BFu0s");
    static STRUCT_IF_C BFu15ll_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Ui_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ui_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ui_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ui_BFu0s");
    check_field_offset(lv, v2, 4, "BFu15ll_Ui_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ui_BFu0s, BFu15ll_Ui_BFu0s)
//============================================================================


struct  BFu15ll_Ul_BFu0c  {
  __tsu64 v1:15;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_Ul_BFu0c) C1{ FL:15 FL Fc:0}



static void Test_BFu15ll_Ul_BFu0c()
{
  {
    init_simple_test("BFu15ll_Ul_BFu0c");
    static STRUCT_IF_C BFu15ll_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ul_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ul_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ul_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ul_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ul_BFu0c, BFu15ll_Ul_BFu0c)
//============================================================================


struct  BFu15ll_Ul_BFu0i  {
  __tsu64 v1:15;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_Ul_BFu0i) C1{ FL:15 FL Fi:0}



static void Test_BFu15ll_Ul_BFu0i()
{
  {
    init_simple_test("BFu15ll_Ul_BFu0i");
    static STRUCT_IF_C BFu15ll_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ul_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ul_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ul_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ul_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ul_BFu0i, BFu15ll_Ul_BFu0i)
//============================================================================


struct  BFu15ll_Ul_BFu0ll  {
  __tsu64 v1:15;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_Ul_BFu0ll) C1{ FL:15 FL FL:0}



static void Test_BFu15ll_Ul_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Ul_BFu0ll");
    static STRUCT_IF_C BFu15ll_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ul_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ul_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ul_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ul_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ul_BFu0ll, BFu15ll_Ul_BFu0ll)
//============================================================================


struct  BFu15ll_Ul_BFu0s  {
  __tsu64 v1:15;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_Ul_BFu0s) C1{ FL:15 FL Fs:0}



static void Test_BFu15ll_Ul_BFu0s()
{
  {
    init_simple_test("BFu15ll_Ul_BFu0s");
    static STRUCT_IF_C BFu15ll_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ul_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ul_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ul_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ul_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Ul_BFu0s, BFu15ll_Ul_BFu0s)
//============================================================================


struct  BFu15ll_Us_BFu0c  {
  __tsu64 v1:15;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_Us_BFu0c) C1{ FL:15 Fs Fc:0}



static void Test_BFu15ll_Us_BFu0c()
{
  {
    init_simple_test("BFu15ll_Us_BFu0c");
    static STRUCT_IF_C BFu15ll_Us_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Us_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Us_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Us_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Us_BFu0c");
    check_field_offset(lv, v2, 2, "BFu15ll_Us_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Us_BFu0c, BFu15ll_Us_BFu0c)
//============================================================================


struct  BFu15ll_Us_BFu0i  {
  __tsu64 v1:15;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_Us_BFu0i) C1{ FL:15 Fs Fi:0}



static void Test_BFu15ll_Us_BFu0i()
{
  {
    init_simple_test("BFu15ll_Us_BFu0i");
    static STRUCT_IF_C BFu15ll_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Us_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Us_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Us_BFu0i");
    check_field_offset(lv, v2, 2, "BFu15ll_Us_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Us_BFu0i, BFu15ll_Us_BFu0i)
//============================================================================


struct  BFu15ll_Us_BFu0ll  {
  __tsu64 v1:15;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_Us_BFu0ll) C1{ FL:15 Fs FL:0}



static void Test_BFu15ll_Us_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Us_BFu0ll");
    static STRUCT_IF_C BFu15ll_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Us_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Us_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Us_BFu0ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Us_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Us_BFu0ll, BFu15ll_Us_BFu0ll)
//============================================================================


struct  BFu15ll_Us_BFu0s  {
  __tsu64 v1:15;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_Us_BFu0s) C1{ FL:15 Fs Fs:0}



static void Test_BFu15ll_Us_BFu0s()
{
  {
    init_simple_test("BFu15ll_Us_BFu0s");
    static STRUCT_IF_C BFu15ll_Us_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Us_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Us_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Us_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Us_BFu0s");
    check_field_offset(lv, v2, 2, "BFu15ll_Us_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Us_BFu0s, BFu15ll_Us_BFu0s)
//============================================================================


struct  BFu15ll_Vp_BFu0c  {
  __tsu64 v1:15;
  void *v2;
  unsigned char  :0;
};
//SIG(1 BFu15ll_Vp_BFu0c) C1{ FL:15 Fp Fc:0}



static void Test_BFu15ll_Vp_BFu0c()
{
  {
    init_simple_test("BFu15ll_Vp_BFu0c");
    static STRUCT_IF_C BFu15ll_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Vp_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Vp_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Vp_BFu0c");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Vp_BFu0c.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Vp_BFu0c, BFu15ll_Vp_BFu0c)
//============================================================================


struct  BFu15ll_Vp_BFu0i  {
  __tsu64 v1:15;
  void *v2;
  unsigned int  :0;
};
//SIG(1 BFu15ll_Vp_BFu0i) C1{ FL:15 Fp Fi:0}



static void Test_BFu15ll_Vp_BFu0i()
{
  {
    init_simple_test("BFu15ll_Vp_BFu0i");
    static STRUCT_IF_C BFu15ll_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Vp_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Vp_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Vp_BFu0i");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Vp_BFu0i.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Vp_BFu0i, BFu15ll_Vp_BFu0i)
//============================================================================


struct  BFu15ll_Vp_BFu0ll  {
  __tsu64 v1:15;
  void *v2;
  __tsu64  :0;
};
//SIG(1 BFu15ll_Vp_BFu0ll) C1{ FL:15 Fp FL:0}



static void Test_BFu15ll_Vp_BFu0ll()
{
  {
    init_simple_test("BFu15ll_Vp_BFu0ll");
    static STRUCT_IF_C BFu15ll_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Vp_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Vp_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Vp_BFu0ll");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Vp_BFu0ll.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Vp_BFu0ll, BFu15ll_Vp_BFu0ll)
//============================================================================


struct  BFu15ll_Vp_BFu0s  {
  __tsu64 v1:15;
  void *v2;
  unsigned short  :0;
};
//SIG(1 BFu15ll_Vp_BFu0s) C1{ FL:15 Fp Fs:0}



static void Test_BFu15ll_Vp_BFu0s()
{
  {
    init_simple_test("BFu15ll_Vp_BFu0s");
    static STRUCT_IF_C BFu15ll_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Vp_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Vp_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Vp_BFu0s");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Vp_BFu0s.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15ll_Vp_BFu0s, BFu15ll_Vp_BFu0s)
//============================================================================


struct  BFu15s_BFu0c  {
  unsigned short v1:15;
  unsigned char  :0;
};
//SIG(1 BFu15s_BFu0c) C1{ Fs:15 Fc:0}



static void Test_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu15s_BFu0c");
    static STRUCT_IF_C BFu15s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c, BFu15s_BFu0c)
//============================================================================


struct  BFu15s_BFu0c_BFu0c  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu15s_BFu0c_BFu0c) C1{ Fs:15 Fc:0 Fc:0}



static void Test_BFu15s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu0c");
    static STRUCT_IF_C BFu15s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_BFu0c_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu0c, BFu15s_BFu0c_BFu0c)
//============================================================================


struct  BFu15s_BFu0c_BFu0i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu15s_BFu0c_BFu0i) C1{ Fs:15 Fc:0 Fi:0}



static void Test_BFu15s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu0i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu0i, BFu15s_BFu0c_BFu0i)
//============================================================================


struct  BFu15s_BFu0c_BFu0ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu15s_BFu0c_BFu0ll) C1{ Fs:15 Fc:0 FL:0}



static void Test_BFu15s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu0ll, BFu15s_BFu0c_BFu0ll)
//============================================================================


struct  BFu15s_BFu0c_BFu0s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu15s_BFu0c_BFu0s) C1{ Fs:15 Fc:0 Fs:0}



static void Test_BFu15s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu0s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu15s_BFu0c_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu0s, BFu15s_BFu0c_BFu0s)
//============================================================================


struct  BFu15s_BFu0c_BFu15i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15s_BFu0c_BFu15i) C1{ Fs:15 Fc:0 Fi:15}



static void Test_BFu15s_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu15i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15s_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu15i, BFu15s_BFu0c_BFu15i)
//============================================================================


struct  BFu15s_BFu0c_BFu15ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15s_BFu0c_BFu15ll) C1{ Fs:15 Fc:0 FL:15}



static void Test_BFu15s_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu15ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15s_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu15ll, BFu15s_BFu0c_BFu15ll)
//============================================================================


struct  BFu15s_BFu0c_BFu15s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15s_BFu0c_BFu15s) C1{ Fs:15 Fc:0 Fs:15}



static void Test_BFu15s_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu15s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15s_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu15s, BFu15s_BFu0c_BFu15s)
//============================================================================


struct  BFu15s_BFu0c_BFu16i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15s_BFu0c_BFu16i) C1{ Fs:15 Fc:0 Fi:16}



static void Test_BFu15s_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu16i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15s_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu16i, BFu15s_BFu0c_BFu16i)
//============================================================================


struct  BFu15s_BFu0c_BFu16ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15s_BFu0c_BFu16ll) C1{ Fs:15 Fc:0 FL:16}



static void Test_BFu15s_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu16ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15s_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu16ll, BFu15s_BFu0c_BFu16ll)
//============================================================================


struct  BFu15s_BFu0c_BFu16s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15s_BFu0c_BFu16s) C1{ Fs:15 Fc:0 Fs:16}



static void Test_BFu15s_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu16s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15s_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu16s, BFu15s_BFu0c_BFu16s)
//============================================================================


struct  BFu15s_BFu0c_BFu17i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15s_BFu0c_BFu17i) C1{ Fs:15 Fc:0 Fi:17}



static void Test_BFu15s_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu17i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15s_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15s_BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu17i, BFu15s_BFu0c_BFu17i)
//============================================================================


struct  BFu15s_BFu0c_BFu17ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15s_BFu0c_BFu17ll) C1{ Fs:15 Fc:0 FL:17}



static void Test_BFu15s_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu17ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu15s_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu15s_BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu17ll, BFu15s_BFu0c_BFu17ll)
//============================================================================


struct  BFu15s_BFu0c_BFu1c  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15s_BFu0c_BFu1c) C1{ Fs:15 Fc:0 Fc:1}



static void Test_BFu15s_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu1c");
    static STRUCT_IF_C BFu15s_BFu0c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15s_BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu1c, BFu15s_BFu0c_BFu1c)
//============================================================================


struct  BFu15s_BFu0c_BFu1i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15s_BFu0c_BFu1i) C1{ Fs:15 Fc:0 Fi:1}



static void Test_BFu15s_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu1i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15s_BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu1i, BFu15s_BFu0c_BFu1i)
//============================================================================


struct  BFu15s_BFu0c_BFu1ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15s_BFu0c_BFu1ll) C1{ Fs:15 Fc:0 FL:1}



static void Test_BFu15s_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu1ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15s_BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu1ll, BFu15s_BFu0c_BFu1ll)
//============================================================================


struct  BFu15s_BFu0c_BFu1s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15s_BFu0c_BFu1s) C1{ Fs:15 Fc:0 Fs:1}



static void Test_BFu15s_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu1s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu15s_BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu1s, BFu15s_BFu0c_BFu1s)
//============================================================================


struct  BFu15s_BFu0c_BFu31i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15s_BFu0c_BFu31i) C1{ Fs:15 Fc:0 Fi:31}



static void Test_BFu15s_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu31i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15s_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15s_BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu31i, BFu15s_BFu0c_BFu31i)
//============================================================================


struct  BFu15s_BFu0c_BFu31ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15s_BFu0c_BFu31ll) C1{ Fs:15 Fc:0 FL:31}



static void Test_BFu15s_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu31ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu15s_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu15s_BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu31ll, BFu15s_BFu0c_BFu31ll)
//============================================================================


struct  BFu15s_BFu0c_BFu32i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15s_BFu0c_BFu32i) C1{ Fs:15 Fc:0 Fi:32}



static void Test_BFu15s_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu32i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15s_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15s_BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu32i, BFu15s_BFu0c_BFu32i)
//============================================================================


struct  BFu15s_BFu0c_BFu32ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15s_BFu0c_BFu32ll) C1{ Fs:15 Fc:0 FL:32}



static void Test_BFu15s_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu32ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu15s_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu15s_BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu32ll, BFu15s_BFu0c_BFu32ll)
//============================================================================


struct  BFu15s_BFu0c_BFu33  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15s_BFu0c_BFu33) C1{ Fs:15 Fc:0 FL:33}



static void Test_BFu15s_BFu0c_BFu33()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu33");
    static STRUCT_IF_C BFu15s_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu15s_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu15s_BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu33, BFu15s_BFu0c_BFu33)
//============================================================================


struct  BFu15s_BFu0c_BFu7c  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15s_BFu0c_BFu7c) C1{ Fs:15 Fc:0 Fc:7}



static void Test_BFu15s_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu7c");
    static STRUCT_IF_C BFu15s_BFu0c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15s_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu7c, BFu15s_BFu0c_BFu7c)
//============================================================================


struct  BFu15s_BFu0c_BFu7i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15s_BFu0c_BFu7i) C1{ Fs:15 Fc:0 Fi:7}



static void Test_BFu15s_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu7i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15s_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu7i, BFu15s_BFu0c_BFu7i)
//============================================================================


struct  BFu15s_BFu0c_BFu7ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15s_BFu0c_BFu7ll) C1{ Fs:15 Fc:0 FL:7}



static void Test_BFu15s_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu7ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15s_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu7ll, BFu15s_BFu0c_BFu7ll)
//============================================================================


struct  BFu15s_BFu0c_BFu7s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15s_BFu0c_BFu7s) C1{ Fs:15 Fc:0 Fs:7}



static void Test_BFu15s_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu7s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15s_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu7s, BFu15s_BFu0c_BFu7s)
//============================================================================


struct  BFu15s_BFu0c_BFu8c  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15s_BFu0c_BFu8c) C1{ Fs:15 Fc:0 Fc:8}



static void Test_BFu15s_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu8c");
    static STRUCT_IF_C BFu15s_BFu0c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15s_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu8c, BFu15s_BFu0c_BFu8c)
//============================================================================


struct  BFu15s_BFu0c_BFu8i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15s_BFu0c_BFu8i) C1{ Fs:15 Fc:0 Fi:8}



static void Test_BFu15s_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu8i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15s_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu8i, BFu15s_BFu0c_BFu8i)
//============================================================================


struct  BFu15s_BFu0c_BFu8ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15s_BFu0c_BFu8ll) C1{ Fs:15 Fc:0 FL:8}



static void Test_BFu15s_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu8ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15s_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu8ll, BFu15s_BFu0c_BFu8ll)
//============================================================================


struct  BFu15s_BFu0c_BFu8s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15s_BFu0c_BFu8s) C1{ Fs:15 Fc:0 Fs:8}



static void Test_BFu15s_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu8s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15s_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu8s, BFu15s_BFu0c_BFu8s)
//============================================================================


struct  BFu15s_BFu0c_BFu9i  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15s_BFu0c_BFu9i) C1{ Fs:15 Fc:0 Fi:9}



static void Test_BFu15s_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu9i");
    static STRUCT_IF_C BFu15s_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15s_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu9i, BFu15s_BFu0c_BFu9i)
//============================================================================


struct  BFu15s_BFu0c_BFu9ll  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15s_BFu0c_BFu9ll) C1{ Fs:15 Fc:0 FL:9}



static void Test_BFu15s_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu9ll");
    static STRUCT_IF_C BFu15s_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15s_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu9ll, BFu15s_BFu0c_BFu9ll)
//============================================================================


struct  BFu15s_BFu0c_BFu9s  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15s_BFu0c_BFu9s) C1{ Fs:15 Fc:0 Fs:9}



static void Test_BFu15s_BFu0c_BFu9s()
{
  {
    init_simple_test("BFu15s_BFu0c_BFu9s");
    static STRUCT_IF_C BFu15s_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15s_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu0c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_BFu9s, BFu15s_BFu0c_BFu9s)
//============================================================================


struct  BFu15s_BFu0c_C  {
  unsigned short v1:15;
  unsigned char  :0;
  char v2;
};
//SIG(1 BFu15s_BFu0c_C) C1{ Fs:15 Fc:0 Fc}



static void Test_BFu15s_BFu0c_C()
{
  {
    init_simple_test("BFu15s_BFu0c_C");
    static STRUCT_IF_C BFu15s_BFu0c_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_C");
    check_field_offset(lv, v2, 2, "BFu15s_BFu0c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_C, BFu15s_BFu0c_C)
//============================================================================


struct  BFu15s_BFu0c_D  {
  unsigned short v1:15;
  unsigned char  :0;
  double v2;
};
//SIG(1 BFu15s_BFu0c_D) C1{ Fs:15 Fc:0 FL}



static void Test_BFu15s_BFu0c_D()
{
  {
    init_simple_test("BFu15s_BFu0c_D");
    static STRUCT_IF_C BFu15s_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_D, BFu15s_BFu0c_D)
//============================================================================


struct  BFu15s_BFu0c_F  {
  unsigned short v1:15;
  unsigned char  :0;
  float v2;
};
//SIG(1 BFu15s_BFu0c_F) C1{ Fs:15 Fc:0 Fi}



static void Test_BFu15s_BFu0c_F()
{
  {
    init_simple_test("BFu15s_BFu0c_F");
    static STRUCT_IF_C BFu15s_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_F");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_F, BFu15s_BFu0c_F)
//============================================================================


struct  BFu15s_BFu0c_I  {
  unsigned short v1:15;
  unsigned char  :0;
  int v2;
};
//SIG(1 BFu15s_BFu0c_I) C1{ Fs:15 Fc:0 Fi}



static void Test_BFu15s_BFu0c_I()
{
  {
    init_simple_test("BFu15s_BFu0c_I");
    static STRUCT_IF_C BFu15s_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_I");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_I, BFu15s_BFu0c_I)
//============================================================================


struct  BFu15s_BFu0c_Ip  {
  unsigned short v1:15;
  unsigned char  :0;
  int *v2;
};
//SIG(1 BFu15s_BFu0c_Ip) C1{ Fs:15 Fc:0 Fp}



static void Test_BFu15s_BFu0c_Ip()
{
  {
    init_simple_test("BFu15s_BFu0c_Ip");
    static STRUCT_IF_C BFu15s_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Ip, BFu15s_BFu0c_Ip)
//============================================================================


struct  BFu15s_BFu0c_L  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 BFu15s_BFu0c_L) C1{ Fs:15 Fc:0 FL}



static void Test_BFu15s_BFu0c_L()
{
  {
    init_simple_test("BFu15s_BFu0c_L");
    static STRUCT_IF_C BFu15s_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_L, BFu15s_BFu0c_L)
//============================================================================


struct  BFu15s_BFu0c_S  {
  unsigned short v1:15;
  unsigned char  :0;
  short v2;
};
//SIG(1 BFu15s_BFu0c_S) C1{ Fs:15 Fc:0 Fs}



static void Test_BFu15s_BFu0c_S()
{
  {
    init_simple_test("BFu15s_BFu0c_S");
    static STRUCT_IF_C BFu15s_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_S");
    check_field_offset(lv, v2, 2, "BFu15s_BFu0c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_S, BFu15s_BFu0c_S)
//============================================================================


struct  BFu15s_BFu0c_Uc  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 BFu15s_BFu0c_Uc) C1{ Fs:15 Fc:0 Fc}



static void Test_BFu15s_BFu0c_Uc()
{
  {
    init_simple_test("BFu15s_BFu0c_Uc");
    static STRUCT_IF_C BFu15s_BFu0c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Uc");
    check_field_offset(lv, v2, 2, "BFu15s_BFu0c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Uc, BFu15s_BFu0c_Uc)
//============================================================================


struct  BFu15s_BFu0c_Ui  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 BFu15s_BFu0c_Ui) C1{ Fs:15 Fc:0 Fi}



static void Test_BFu15s_BFu0c_Ui()
{
  {
    init_simple_test("BFu15s_BFu0c_Ui");
    static STRUCT_IF_C BFu15s_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Ui");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Ui, BFu15s_BFu0c_Ui)
//============================================================================


struct  BFu15s_BFu0c_Ul  {
  unsigned short v1:15;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 BFu15s_BFu0c_Ul) C1{ Fs:15 Fc:0 FL}



static void Test_BFu15s_BFu0c_Ul()
{
  {
    init_simple_test("BFu15s_BFu0c_Ul");
    static STRUCT_IF_C BFu15s_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Ul, BFu15s_BFu0c_Ul)
//============================================================================


struct  BFu15s_BFu0c_Us  {
  unsigned short v1:15;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 BFu15s_BFu0c_Us) C1{ Fs:15 Fc:0 Fs}



static void Test_BFu15s_BFu0c_Us()
{
  {
    init_simple_test("BFu15s_BFu0c_Us");
    static STRUCT_IF_C BFu15s_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu0c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Us");
    check_field_offset(lv, v2, 2, "BFu15s_BFu0c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Us, BFu15s_BFu0c_Us)
//============================================================================


struct  BFu15s_BFu0c_Vp  {
  unsigned short v1:15;
  unsigned char  :0;
  void *v2;
};
//SIG(1 BFu15s_BFu0c_Vp) C1{ Fs:15 Fc:0 Fp}



static void Test_BFu15s_BFu0c_Vp()
{
  {
    init_simple_test("BFu15s_BFu0c_Vp");
    static STRUCT_IF_C BFu15s_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0c_Vp, BFu15s_BFu0c_Vp)
//============================================================================


struct  BFu15s_BFu0i  {
  unsigned short v1:15;
  unsigned int  :0;
};
//SIG(1 BFu15s_BFu0i) C1{ Fs:15 Fi:0}



static void Test_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu15s_BFu0i");
    static STRUCT_IF_C BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i, BFu15s_BFu0i)
//============================================================================


struct  BFu15s_BFu0i_BFu0c  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu15s_BFu0i_BFu0c) C1{ Fs:15 Fi:0 Fc:0}



static void Test_BFu15s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu0c");
    static STRUCT_IF_C BFu15s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu0c, BFu15s_BFu0i_BFu0c)
//============================================================================


struct  BFu15s_BFu0i_BFu0i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu15s_BFu0i_BFu0i) C1{ Fs:15 Fi:0 Fi:0}



static void Test_BFu15s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu0i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu0i, BFu15s_BFu0i_BFu0i)
//============================================================================


struct  BFu15s_BFu0i_BFu0ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu15s_BFu0i_BFu0ll) C1{ Fs:15 Fi:0 FL:0}



static void Test_BFu15s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu0ll, BFu15s_BFu0i_BFu0ll)
//============================================================================


struct  BFu15s_BFu0i_BFu0s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu15s_BFu0i_BFu0s) C1{ Fs:15 Fi:0 Fs:0}



static void Test_BFu15s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu0s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu0s, BFu15s_BFu0i_BFu0s)
//============================================================================


struct  BFu15s_BFu0i_BFu15i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15s_BFu0i_BFu15i) C1{ Fs:15 Fi:0 Fi:15}



static void Test_BFu15s_BFu0i_BFu15i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu15i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15s_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu15i, BFu15s_BFu0i_BFu15i)
//============================================================================


struct  BFu15s_BFu0i_BFu15ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15s_BFu0i_BFu15ll) C1{ Fs:15 Fi:0 FL:15}



static void Test_BFu15s_BFu0i_BFu15ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu15ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15s_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu15ll, BFu15s_BFu0i_BFu15ll)
//============================================================================


struct  BFu15s_BFu0i_BFu15s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15s_BFu0i_BFu15s) C1{ Fs:15 Fi:0 Fs:15}



static void Test_BFu15s_BFu0i_BFu15s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu15s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu15s_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu15s, BFu15s_BFu0i_BFu15s)
//============================================================================


struct  BFu15s_BFu0i_BFu16i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15s_BFu0i_BFu16i) C1{ Fs:15 Fi:0 Fi:16}



static void Test_BFu15s_BFu0i_BFu16i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu16i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15s_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu16i, BFu15s_BFu0i_BFu16i)
//============================================================================


struct  BFu15s_BFu0i_BFu16ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15s_BFu0i_BFu16ll) C1{ Fs:15 Fi:0 FL:16}



static void Test_BFu15s_BFu0i_BFu16ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu16ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15s_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu16ll, BFu15s_BFu0i_BFu16ll)
//============================================================================


struct  BFu15s_BFu0i_BFu16s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15s_BFu0i_BFu16s) C1{ Fs:15 Fi:0 Fs:16}



static void Test_BFu15s_BFu0i_BFu16s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu16s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu15s_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu16s, BFu15s_BFu0i_BFu16s)
//============================================================================


struct  BFu15s_BFu0i_BFu17i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15s_BFu0i_BFu17i) C1{ Fs:15 Fi:0 Fi:17}



static void Test_BFu15s_BFu0i_BFu17i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu17i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15s_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15s_BFu0i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu17i, BFu15s_BFu0i_BFu17i)
//============================================================================


struct  BFu15s_BFu0i_BFu17ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15s_BFu0i_BFu17ll) C1{ Fs:15 Fi:0 FL:17}



static void Test_BFu15s_BFu0i_BFu17ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu17ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu15s_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu15s_BFu0i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu17ll, BFu15s_BFu0i_BFu17ll)
//============================================================================


struct  BFu15s_BFu0i_BFu1c  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15s_BFu0i_BFu1c) C1{ Fs:15 Fi:0 Fc:1}



static void Test_BFu15s_BFu0i_BFu1c()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu1c");
    static STRUCT_IF_C BFu15s_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15s_BFu0i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu1c, BFu15s_BFu0i_BFu1c)
//============================================================================


struct  BFu15s_BFu0i_BFu1i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15s_BFu0i_BFu1i) C1{ Fs:15 Fi:0 Fi:1}



static void Test_BFu15s_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu1i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15s_BFu0i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu1i, BFu15s_BFu0i_BFu1i)
//============================================================================


struct  BFu15s_BFu0i_BFu1ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15s_BFu0i_BFu1ll) C1{ Fs:15 Fi:0 FL:1}



static void Test_BFu15s_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu1ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15s_BFu0i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu1ll, BFu15s_BFu0i_BFu1ll)
//============================================================================


struct  BFu15s_BFu0i_BFu1s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15s_BFu0i_BFu1s) C1{ Fs:15 Fi:0 Fs:1}



static void Test_BFu15s_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu1s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu15s_BFu0i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu1s, BFu15s_BFu0i_BFu1s)
//============================================================================


struct  BFu15s_BFu0i_BFu31i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15s_BFu0i_BFu31i) C1{ Fs:15 Fi:0 Fi:31}



static void Test_BFu15s_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu31i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15s_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15s_BFu0i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu31i, BFu15s_BFu0i_BFu31i)
//============================================================================


struct  BFu15s_BFu0i_BFu31ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15s_BFu0i_BFu31ll) C1{ Fs:15 Fi:0 FL:31}



static void Test_BFu15s_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu31ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15s_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15s_BFu0i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu31ll, BFu15s_BFu0i_BFu31ll)
//============================================================================


struct  BFu15s_BFu0i_BFu32i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15s_BFu0i_BFu32i) C1{ Fs:15 Fi:0 Fi:32}



static void Test_BFu15s_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu32i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15s_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15s_BFu0i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu32i, BFu15s_BFu0i_BFu32i)
//============================================================================


struct  BFu15s_BFu0i_BFu32ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15s_BFu0i_BFu32ll) C1{ Fs:15 Fi:0 FL:32}



static void Test_BFu15s_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu32ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15s_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15s_BFu0i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu32ll, BFu15s_BFu0i_BFu32ll)
//============================================================================


struct  BFu15s_BFu0i_BFu33  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15s_BFu0i_BFu33) C1{ Fs:15 Fi:0 FL:33}



static void Test_BFu15s_BFu0i_BFu33()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu33");
    static STRUCT_IF_C BFu15s_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu15s_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15s_BFu0i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu33, BFu15s_BFu0i_BFu33)
//============================================================================


struct  BFu15s_BFu0i_BFu7c  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15s_BFu0i_BFu7c) C1{ Fs:15 Fi:0 Fc:7}



static void Test_BFu15s_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu7c");
    static STRUCT_IF_C BFu15s_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15s_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu7c, BFu15s_BFu0i_BFu7c)
//============================================================================


struct  BFu15s_BFu0i_BFu7i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15s_BFu0i_BFu7i) C1{ Fs:15 Fi:0 Fi:7}



static void Test_BFu15s_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu7i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15s_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu7i, BFu15s_BFu0i_BFu7i)
//============================================================================


struct  BFu15s_BFu0i_BFu7ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15s_BFu0i_BFu7ll) C1{ Fs:15 Fi:0 FL:7}



static void Test_BFu15s_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu7ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15s_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu7ll, BFu15s_BFu0i_BFu7ll)
//============================================================================


struct  BFu15s_BFu0i_BFu7s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15s_BFu0i_BFu7s) C1{ Fs:15 Fi:0 Fs:7}



static void Test_BFu15s_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu7s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu15s_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu7s, BFu15s_BFu0i_BFu7s)
//============================================================================


struct  BFu15s_BFu0i_BFu8c  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15s_BFu0i_BFu8c) C1{ Fs:15 Fi:0 Fc:8}



static void Test_BFu15s_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu8c");
    static STRUCT_IF_C BFu15s_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15s_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu8c, BFu15s_BFu0i_BFu8c)
//============================================================================


struct  BFu15s_BFu0i_BFu8i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15s_BFu0i_BFu8i) C1{ Fs:15 Fi:0 Fi:8}



static void Test_BFu15s_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu8i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15s_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu8i, BFu15s_BFu0i_BFu8i)
//============================================================================


struct  BFu15s_BFu0i_BFu8ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 BFu15s_BFu0i_BFu8ll) C1{ Fs:15 Fi:0 FL:8}



static void Test_BFu15s_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu8ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15s_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu8ll, BFu15s_BFu0i_BFu8ll)
//============================================================================


struct  BFu15s_BFu0i_BFu8s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 BFu15s_BFu0i_BFu8s) C1{ Fs:15 Fi:0 Fs:8}



static void Test_BFu15s_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu8s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu15s_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu8s, BFu15s_BFu0i_BFu8s)
//============================================================================


struct  BFu15s_BFu0i_BFu9i  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 BFu15s_BFu0i_BFu9i) C1{ Fs:15 Fi:0 Fi:9}



static void Test_BFu15s_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu9i");
    static STRUCT_IF_C BFu15s_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15s_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu0i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu9i, BFu15s_BFu0i_BFu9i)
//============================================================================


struct  BFu15s_BFu0i_BFu9ll  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 BFu15s_BFu0i_BFu9ll) C1{ Fs:15 Fi:0 FL:9}



static void Test_BFu15s_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu9ll");
    static STRUCT_IF_C BFu15s_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15s_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu0i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu9ll, BFu15s_BFu0i_BFu9ll)
//============================================================================


struct  BFu15s_BFu0i_BFu9s  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 BFu15s_BFu0i_BFu9s) C1{ Fs:15 Fi:0 Fs:9}



static void Test_BFu15s_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu15s_BFu0i_BFu9s");
    static STRUCT_IF_C BFu15s_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu15s_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu0i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_BFu9s, BFu15s_BFu0i_BFu9s)
//============================================================================


struct  BFu15s_BFu0i_C  {
  unsigned short v1:15;
  unsigned int  :0;
  char v2;
};
//SIG(1 BFu15s_BFu0i_C) C1{ Fs:15 Fi:0 Fc}



static void Test_BFu15s_BFu0i_C()
{
  {
    init_simple_test("BFu15s_BFu0i_C");
    static STRUCT_IF_C BFu15s_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_C");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_C, BFu15s_BFu0i_C)
//============================================================================


struct  BFu15s_BFu0i_D  {
  unsigned short v1:15;
  unsigned int  :0;
  double v2;
};
//SIG(1 BFu15s_BFu0i_D) C1{ Fs:15 Fi:0 FL}



static void Test_BFu15s_BFu0i_D()
{
  {
    init_simple_test("BFu15s_BFu0i_D");
    static STRUCT_IF_C BFu15s_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_D, BFu15s_BFu0i_D)
//============================================================================


struct  BFu15s_BFu0i_F  {
  unsigned short v1:15;
  unsigned int  :0;
  float v2;
};
//SIG(1 BFu15s_BFu0i_F) C1{ Fs:15 Fi:0 Fi}



static void Test_BFu15s_BFu0i_F()
{
  {
    init_simple_test("BFu15s_BFu0i_F");
    static STRUCT_IF_C BFu15s_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_F");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_F, BFu15s_BFu0i_F)
//============================================================================


struct  BFu15s_BFu0i_I  {
  unsigned short v1:15;
  unsigned int  :0;
  int v2;
};
//SIG(1 BFu15s_BFu0i_I) C1{ Fs:15 Fi:0 Fi}



static void Test_BFu15s_BFu0i_I()
{
  {
    init_simple_test("BFu15s_BFu0i_I");
    static STRUCT_IF_C BFu15s_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_I");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_I, BFu15s_BFu0i_I)
//============================================================================


struct  BFu15s_BFu0i_Ip  {
  unsigned short v1:15;
  unsigned int  :0;
  int *v2;
};
//SIG(1 BFu15s_BFu0i_Ip) C1{ Fs:15 Fi:0 Fp}



static void Test_BFu15s_BFu0i_Ip()
{
  {
    init_simple_test("BFu15s_BFu0i_Ip");
    static STRUCT_IF_C BFu15s_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Ip, BFu15s_BFu0i_Ip)
//============================================================================


struct  BFu15s_BFu0i_L  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 BFu15s_BFu0i_L) C1{ Fs:15 Fi:0 FL}



static void Test_BFu15s_BFu0i_L()
{
  {
    init_simple_test("BFu15s_BFu0i_L");
    static STRUCT_IF_C BFu15s_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_L, BFu15s_BFu0i_L)
//============================================================================


struct  BFu15s_BFu0i_S  {
  unsigned short v1:15;
  unsigned int  :0;
  short v2;
};
//SIG(1 BFu15s_BFu0i_S) C1{ Fs:15 Fi:0 Fs}



static void Test_BFu15s_BFu0i_S()
{
  {
    init_simple_test("BFu15s_BFu0i_S");
    static STRUCT_IF_C BFu15s_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_S");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_S, BFu15s_BFu0i_S)
//============================================================================


struct  BFu15s_BFu0i_Uc  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 BFu15s_BFu0i_Uc) C1{ Fs:15 Fi:0 Fc}



static void Test_BFu15s_BFu0i_Uc()
{
  {
    init_simple_test("BFu15s_BFu0i_Uc");
    static STRUCT_IF_C BFu15s_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Uc");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Uc, BFu15s_BFu0i_Uc)
//============================================================================


struct  BFu15s_BFu0i_Ui  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 BFu15s_BFu0i_Ui) C1{ Fs:15 Fi:0 Fi}



static void Test_BFu15s_BFu0i_Ui()
{
  {
    init_simple_test("BFu15s_BFu0i_Ui");
    static STRUCT_IF_C BFu15s_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu0i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Ui");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Ui, BFu15s_BFu0i_Ui)
//============================================================================


struct  BFu15s_BFu0i_Ul  {
  unsigned short v1:15;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 BFu15s_BFu0i_Ul) C1{ Fs:15 Fi:0 FL}



static void Test_BFu15s_BFu0i_Ul()
{
  {
    init_simple_test("BFu15s_BFu0i_Ul");
    static STRUCT_IF_C BFu15s_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Ul, BFu15s_BFu0i_Ul)
//============================================================================


struct  BFu15s_BFu0i_Us  {
  unsigned short v1:15;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 BFu15s_BFu0i_Us) C1{ Fs:15 Fi:0 Fs}



static void Test_BFu15s_BFu0i_Us()
{
  {
    init_simple_test("BFu15s_BFu0i_Us");
    static STRUCT_IF_C BFu15s_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(BFu15s_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Us");
    check_field_offset(lv, v2, 4, "BFu15s_BFu0i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Us, BFu15s_BFu0i_Us)
//============================================================================


struct  BFu15s_BFu0i_Vp  {
  unsigned short v1:15;
  unsigned int  :0;
  void *v2;
};
//SIG(1 BFu15s_BFu0i_Vp) C1{ Fs:15 Fi:0 Fp}



static void Test_BFu15s_BFu0i_Vp()
{
  {
    init_simple_test("BFu15s_BFu0i_Vp");
    static STRUCT_IF_C BFu15s_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_BFu0i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0i_Vp, BFu15s_BFu0i_Vp)
//============================================================================


struct  BFu15s_BFu0ll  {
  unsigned short v1:15;
  __tsu64  :0;
};
//SIG(1 BFu15s_BFu0ll) C1{ Fs:15 FL:0}



static void Test_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu15s_BFu0ll");
    static STRUCT_IF_C BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll, BFu15s_BFu0ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu0c  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu15s_BFu0ll_BFu0c) C1{ Fs:15 FL:0 Fc:0}



static void Test_BFu15s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu0c, BFu15s_BFu0ll_BFu0c)
//============================================================================


struct  BFu15s_BFu0ll_BFu0i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu15s_BFu0ll_BFu0i) C1{ Fs:15 FL:0 Fi:0}



static void Test_BFu15s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu0i, BFu15s_BFu0ll_BFu0i)
//============================================================================


struct  BFu15s_BFu0ll_BFu0ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu15s_BFu0ll_BFu0ll) C1{ Fs:15 FL:0 FL:0}



static void Test_BFu15s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu0ll, BFu15s_BFu0ll_BFu0ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu0s  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu15s_BFu0ll_BFu0s) C1{ Fs:15 FL:0 Fs:0}



static void Test_BFu15s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu0s, BFu15s_BFu0ll_BFu0s)
//============================================================================


struct  BFu15s_BFu0ll_BFu15i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 BFu15s_BFu0ll_BFu15i) C1{ Fs:15 FL:0 Fi:15}



static void Test_BFu15s_BFu0ll_BFu15i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu15i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15s_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu15i, BFu15s_BFu0ll_BFu15i)
//============================================================================


struct  BFu15s_BFu0ll_BFu15ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 BFu15s_BFu0ll_BFu15ll) C1{ Fs:15 FL:0 FL:15}



static void Test_BFu15s_BFu0ll_BFu15ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu15ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15s_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu15ll, BFu15s_BFu0ll_BFu15ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu15s  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 BFu15s_BFu0ll_BFu15s) C1{ Fs:15 FL:0 Fs:15}



static void Test_BFu15s_BFu0ll_BFu15s()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu15s");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu15s_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu15s, BFu15s_BFu0ll_BFu15s)
//============================================================================


struct  BFu15s_BFu0ll_BFu16i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 BFu15s_BFu0ll_BFu16i) C1{ Fs:15 FL:0 Fi:16}



static void Test_BFu15s_BFu0ll_BFu16i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu16i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15s_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu16i, BFu15s_BFu0ll_BFu16i)
//============================================================================


struct  BFu15s_BFu0ll_BFu16ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 BFu15s_BFu0ll_BFu16ll) C1{ Fs:15 FL:0 FL:16}



static void Test_BFu15s_BFu0ll_BFu16ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu16ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15s_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu16ll, BFu15s_BFu0ll_BFu16ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu16s  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 BFu15s_BFu0ll_BFu16s) C1{ Fs:15 FL:0 Fs:16}



static void Test_BFu15s_BFu0ll_BFu16s()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu16s");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu15s_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu15s_BFu0ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu16s, BFu15s_BFu0ll_BFu16s)
//============================================================================


struct  BFu15s_BFu0ll_BFu17i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 BFu15s_BFu0ll_BFu17i) C1{ Fs:15 FL:0 Fi:17}



static void Test_BFu15s_BFu0ll_BFu17i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu17i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu15s_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu15s_BFu0ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu17i, BFu15s_BFu0ll_BFu17i)
//============================================================================


struct  BFu15s_BFu0ll_BFu17ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 BFu15s_BFu0ll_BFu17ll) C1{ Fs:15 FL:0 FL:17}



static void Test_BFu15s_BFu0ll_BFu17ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu17ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu15s_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu15s_BFu0ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu17ll, BFu15s_BFu0ll_BFu17ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu1c  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 BFu15s_BFu0ll_BFu1c) C1{ Fs:15 FL:0 Fc:1}



static void Test_BFu15s_BFu0ll_BFu1c()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu1c");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15s_BFu0ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu1c, BFu15s_BFu0ll_BFu1c)
//============================================================================


struct  BFu15s_BFu0ll_BFu1i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 BFu15s_BFu0ll_BFu1i) C1{ Fs:15 FL:0 Fi:1}



static void Test_BFu15s_BFu0ll_BFu1i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu1i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15s_BFu0ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu1i, BFu15s_BFu0ll_BFu1i)
//============================================================================


struct  BFu15s_BFu0ll_BFu1ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 BFu15s_BFu0ll_BFu1ll) C1{ Fs:15 FL:0 FL:1}



static void Test_BFu15s_BFu0ll_BFu1ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu1ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15s_BFu0ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu1ll, BFu15s_BFu0ll_BFu1ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu1s  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 BFu15s_BFu0ll_BFu1s) C1{ Fs:15 FL:0 Fs:1}



static void Test_BFu15s_BFu0ll_BFu1s()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu1s");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu15s_BFu0ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu1s, BFu15s_BFu0ll_BFu1s)
//============================================================================


struct  BFu15s_BFu0ll_BFu31i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 BFu15s_BFu0ll_BFu31i) C1{ Fs:15 FL:0 Fi:31}



static void Test_BFu15s_BFu0ll_BFu31i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu31i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu15s_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu15s_BFu0ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu31i, BFu15s_BFu0ll_BFu31i)
//============================================================================


struct  BFu15s_BFu0ll_BFu31ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 BFu15s_BFu0ll_BFu31ll) C1{ Fs:15 FL:0 FL:31}



static void Test_BFu15s_BFu0ll_BFu31ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu31ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu15s_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu15s_BFu0ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu31ll, BFu15s_BFu0ll_BFu31ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu32i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 BFu15s_BFu0ll_BFu32i) C1{ Fs:15 FL:0 Fi:32}



static void Test_BFu15s_BFu0ll_BFu32i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu32i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu15s_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu15s_BFu0ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu32i, BFu15s_BFu0ll_BFu32i)
//============================================================================


struct  BFu15s_BFu0ll_BFu32ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 BFu15s_BFu0ll_BFu32ll) C1{ Fs:15 FL:0 FL:32}



static void Test_BFu15s_BFu0ll_BFu32ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu32ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu15s_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu15s_BFu0ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu32ll, BFu15s_BFu0ll_BFu32ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu33  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 BFu15s_BFu0ll_BFu33) C1{ Fs:15 FL:0 FL:33}



static void Test_BFu15s_BFu0ll_BFu33()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu33");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu15s_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu15s_BFu0ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu33, BFu15s_BFu0ll_BFu33)
//============================================================================


struct  BFu15s_BFu0ll_BFu7c  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 BFu15s_BFu0ll_BFu7c) C1{ Fs:15 FL:0 Fc:7}



static void Test_BFu15s_BFu0ll_BFu7c()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu7c");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15s_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu7c, BFu15s_BFu0ll_BFu7c)
//============================================================================


struct  BFu15s_BFu0ll_BFu7i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 BFu15s_BFu0ll_BFu7i) C1{ Fs:15 FL:0 Fi:7}



static void Test_BFu15s_BFu0ll_BFu7i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu7i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15s_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu7i, BFu15s_BFu0ll_BFu7i)
//============================================================================


struct  BFu15s_BFu0ll_BFu7ll  {
  unsigned short v1:15;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 BFu15s_BFu0ll_BFu7ll) C1{ Fs:15 FL:0 FL:7}



static void Test_BFu15s_BFu0ll_BFu7ll()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu7ll");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu0ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15s_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu7ll, BFu15s_BFu0ll_BFu7ll)
//============================================================================


struct  BFu15s_BFu0ll_BFu7s  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 BFu15s_BFu0ll_BFu7s) C1{ Fs:15 FL:0 Fs:7}



static void Test_BFu15s_BFu0ll_BFu7s()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu7s");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu15s_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu15s_BFu0ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu7s, BFu15s_BFu0ll_BFu7s)
//============================================================================


struct  BFu15s_BFu0ll_BFu8c  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 BFu15s_BFu0ll_BFu8c) C1{ Fs:15 FL:0 Fc:8}



static void Test_BFu15s_BFu0ll_BFu8c()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu8c");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(BFu15s_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu15s_BFu0ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu15s_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu15s_BFu0ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu15s_BFu0ll_BFu8c, BFu15s_BFu0ll_BFu8c)
//============================================================================


struct  BFu15s_BFu0ll_BFu8i  {
  unsigned short v1:15;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 BFu15s_BFu0ll_BFu8i) C1{ Fs:15 FL:0 Fi:8}



static void Test_BFu15s_BFu0ll_BFu8i()
{
  {
    init_simple_test("BFu15s_BFu0ll_BFu8i");
    static STRUCT_IF_C BFu15s_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(BFu15s_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu15s_BFu0ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu0ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 