// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFu0c_BFu0s_BFs0s_BFs0s  {
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFu0c_BFu0s_BFs0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFu0c_BFu0s_BFs0s_BFs0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFs0s_BFs0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFs0s_BFs0s, BFu0c_BFu0s_BFs0s_BFs0s)
//============================================================================


struct  BFu0c_BFu0s_BFs0s_BFu0c  {
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu0s_BFs0s_BFu0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFu0c_BFu0s_BFs0s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFs0s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFs0s_BFu0c, BFu0c_BFu0s_BFs0s_BFu0c)
//============================================================================


struct  BFu0c_BFu0s_BFs0s_BFu0i  {
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu0s_BFs0s_BFu0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFu0c_BFu0s_BFs0s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFs0s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFs0s_BFu0i, BFu0c_BFu0s_BFs0s_BFu0i)
//============================================================================


struct  BFu0c_BFu0s_BFs0s_BFu0ll  {
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu0s_BFs0s_BFu0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFu0c_BFu0s_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFs0s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFs0s_BFu0ll, BFu0c_BFu0s_BFs0s_BFu0ll)
//============================================================================


struct  BFu0c_BFu0s_BFs0s_BFu0s  {
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu0s_BFs0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFu0c_BFu0s_BFs0s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFs0s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFs0s_BFu0s, BFu0c_BFu0s_BFs0s_BFu0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c) C1{ Fc:0 Fs:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c, BFu0c_BFu0s_BFu0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFs0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFs0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0c_BFs0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFs0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFs0c, BFu0c_BFu0s_BFu0c_BFs0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFs0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFs0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0c_BFs0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFs0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFs0i, BFu0c_BFu0s_BFu0c_BFs0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFs0ll  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFs0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFs0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFs0ll, BFu0c_BFu0s_BFu0c_BFs0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFs0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFs0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0c_BFs0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFs0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFs0s, BFu0c_BFu0s_BFu0c_BFs0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFu0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFu0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFu0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFu0c, BFu0c_BFu0s_BFu0c_BFu0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFu0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFu0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFu0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFu0i, BFu0c_BFu0s_BFu0c_BFu0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFu0ll  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFu0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFu0ll, BFu0c_BFu0s_BFu0c_BFu0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0c_BFu0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0c_BFu0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0c_BFu0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0c_BFu0s, BFu0c_BFu0s_BFu0c_BFu0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i) C1{ Fc:0 Fs:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i, BFu0c_BFu0s_BFu0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFs0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFs0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0i_BFs0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFs0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFs0c, BFu0c_BFu0s_BFu0i_BFs0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFs0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFs0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0i_BFs0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFs0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFs0i, BFu0c_BFu0s_BFu0i_BFs0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFs0ll  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFs0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFs0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFs0ll, BFu0c_BFu0s_BFu0i_BFs0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFs0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFs0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0i_BFs0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFs0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFs0s, BFu0c_BFu0s_BFu0i_BFs0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFu0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFu0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFu0c, BFu0c_BFu0s_BFu0i_BFu0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFu0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFu0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFu0i, BFu0c_BFu0s_BFu0i_BFu0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFu0ll  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFu0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFu0ll, BFu0c_BFu0s_BFu0i_BFu0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0i_BFu0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0i_BFu0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0i_BFu0s, BFu0c_BFu0s_BFu0i_BFu0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll) C1{ Fc:0 Fs:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll, BFu0c_BFu0s_BFu0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFs0c  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFs0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFs0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFs0c, BFu0c_BFu0s_BFu0ll_BFs0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFs0i  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFs0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFs0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFs0i, BFu0c_BFu0s_BFu0ll_BFs0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFs0ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFs0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFs0ll, BFu0c_BFu0s_BFu0ll_BFs0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFs0s  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFs0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFs0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFs0s, BFu0c_BFu0s_BFu0ll_BFs0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFu0c  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFu0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFu0c, BFu0c_BFu0s_BFu0ll_BFu0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFu0i  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFu0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFu0i, BFu0c_BFu0s_BFu0ll_BFu0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFu0ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFu0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFu0ll, BFu0c_BFu0s_BFu0ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0ll_BFu0s  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0ll_BFu0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0ll_BFu0s, BFu0c_BFu0s_BFu0ll_BFu0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s, BFu0c_BFu0s_BFu0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFs0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFs0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0s_BFs0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFs0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFs0c, BFu0c_BFu0s_BFu0s_BFs0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFs0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFs0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0s_BFs0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFs0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFs0i, BFu0c_BFu0s_BFu0s_BFs0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFs0ll  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFs0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFs0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFs0ll, BFu0c_BFu0s_BFu0s_BFs0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFs0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0s_BFs0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFs0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFs0s, BFu0c_BFu0s_BFu0s_BFs0s)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFu0c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFu0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFu0c_BFu0s_BFu0s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFu0c, BFu0c_BFu0s_BFu0s_BFu0c)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFu0i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFu0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFu0c_BFu0s_BFu0s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFu0i, BFu0c_BFu0s_BFu0s_BFu0i)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFu0ll  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFu0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFu0c_BFu0s_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFu0ll, BFu0c_BFu0s_BFu0s_BFu0ll)
//============================================================================


struct  BFu0c_BFu0s_BFu0s_BFu0s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu0s_BFu0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFu0c_BFu0s_BFu0s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu0s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFu0c_BFu0s_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu0s_BFu0s, BFu0c_BFu0s_BFu0s_BFu0s)
//============================================================================


struct  BFu0c_BFu0s_BFu15i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:15;
};
//SIG(1 BFu0c_BFu0s_BFu15i) C1{ Fc:0 Fs:0 Fi:15}



static void Test_BFu0c_BFu0s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu15i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu0s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu0s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu15i, BFu0c_BFu0s_BFu15i)
//============================================================================


struct  BFu0c_BFu0s_BFu15ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:15;
};
//SIG(1 BFu0c_BFu0s_BFu15ll) C1{ Fc:0 Fs:0 FL:15}



static void Test_BFu0c_BFu0s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu0s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu0s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu15ll, BFu0c_BFu0s_BFu15ll)
//============================================================================


struct  BFu0c_BFu0s_BFu15s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1:15;
};
//SIG(1 BFu0c_BFu0s_BFu15s) C1{ Fc:0 Fs:0 Fs:15}



static void Test_BFu0c_BFu0s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu15s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu0s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu0s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu15s, BFu0c_BFu0s_BFu15s)
//============================================================================


struct  BFu0c_BFu0s_BFu16i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:16;
};
//SIG(1 BFu0c_BFu0s_BFu16i) C1{ Fc:0 Fs:0 Fi:16}



static void Test_BFu0c_BFu0s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu16i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu0s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu0s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu16i, BFu0c_BFu0s_BFu16i)
//============================================================================


struct  BFu0c_BFu0s_BFu16ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:16;
};
//SIG(1 BFu0c_BFu0s_BFu16ll) C1{ Fc:0 Fs:0 FL:16}



static void Test_BFu0c_BFu0s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu0s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu0s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu16ll, BFu0c_BFu0s_BFu16ll)
//============================================================================


struct  BFu0c_BFu0s_BFu16s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1:16;
};
//SIG(1 BFu0c_BFu0s_BFu16s) C1{ Fc:0 Fs:0 Fs:16}



static void Test_BFu0c_BFu0s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu16s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu0s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu0s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu16s, BFu0c_BFu0s_BFu16s)
//============================================================================


struct  BFu0c_BFu0s_BFu17i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:17;
};
//SIG(1 BFu0c_BFu0s_BFu17i) C1{ Fc:0 Fs:0 Fi:17}



static void Test_BFu0c_BFu0s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu17i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu0s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu0s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu17i, BFu0c_BFu0s_BFu17i)
//============================================================================


struct  BFu0c_BFu0s_BFu17ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:17;
};
//SIG(1 BFu0c_BFu0s_BFu17ll) C1{ Fc:0 Fs:0 FL:17}



static void Test_BFu0c_BFu0s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu0s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu0s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu17ll, BFu0c_BFu0s_BFu17ll)
//============================================================================


struct  BFu0c_BFu0s_BFu1c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char v1:1;
};
//SIG(1 BFu0c_BFu0s_BFu1c) C1{ Fc:0 Fs:0 Fc:1}



static void Test_BFu0c_BFu0s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu1c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0c_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu0s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu1c, BFu0c_BFu0s_BFu1c)
//============================================================================


struct  BFu0c_BFu0s_BFu1i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:1;
};
//SIG(1 BFu0c_BFu0s_BFu1i) C1{ Fc:0 Fs:0 Fi:1}



static void Test_BFu0c_BFu0s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu1i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu0s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu1i, BFu0c_BFu0s_BFu1i)
//============================================================================


struct  BFu0c_BFu0s_BFu1ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:1;
};
//SIG(1 BFu0c_BFu0s_BFu1ll) C1{ Fc:0 Fs:0 FL:1}



static void Test_BFu0c_BFu0s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu0s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu1ll, BFu0c_BFu0s_BFu1ll)
//============================================================================


struct  BFu0c_BFu0s_BFu1s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1:1;
};
//SIG(1 BFu0c_BFu0s_BFu1s) C1{ Fc:0 Fs:0 Fs:1}



static void Test_BFu0c_BFu0s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu1s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu0s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu1s, BFu0c_BFu0s_BFu1s)
//============================================================================


struct  BFu0c_BFu0s_BFu31i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:31;
};
//SIG(1 BFu0c_BFu0s_BFu31i) C1{ Fc:0 Fs:0 Fi:31}



static void Test_BFu0c_BFu0s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu31i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu0s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu0s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu31i, BFu0c_BFu0s_BFu31i)
//============================================================================


struct  BFu0c_BFu0s_BFu31ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:31;
};
//SIG(1 BFu0c_BFu0s_BFu31ll) C1{ Fc:0 Fs:0 FL:31}



static void Test_BFu0c_BFu0s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu0s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu0s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu31ll, BFu0c_BFu0s_BFu31ll)
//============================================================================


struct  BFu0c_BFu0s_BFu32i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:32;
};
//SIG(1 BFu0c_BFu0s_BFu32i) C1{ Fc:0 Fs:0 Fi:32}



static void Test_BFu0c_BFu0s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu32i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu0s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu0s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu32i, BFu0c_BFu0s_BFu32i)
//============================================================================


struct  BFu0c_BFu0s_BFu32ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:32;
};
//SIG(1 BFu0c_BFu0s_BFu32ll) C1{ Fc:0 Fs:0 FL:32}



static void Test_BFu0c_BFu0s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu0s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu0s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu32ll, BFu0c_BFu0s_BFu32ll)
//============================================================================


struct  BFu0c_BFu0s_BFu33  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:33;
};
//SIG(1 BFu0c_BFu0s_BFu33) C1{ Fc:0 Fs:0 FL:33}



static void Test_BFu0c_BFu0s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu33");
    static STRUCT_IF_C BFu0c_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu0s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu0s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu33, BFu0c_BFu0s_BFu33)
//============================================================================


struct  BFu0c_BFu0s_BFu7c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char v1:7;
};
//SIG(1 BFu0c_BFu0s_BFu7c) C1{ Fc:0 Fs:0 Fc:7}



static void Test_BFu0c_BFu0s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu7c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0c_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu0s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu0s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu7c, BFu0c_BFu0s_BFu7c)
//============================================================================


struct  BFu0c_BFu0s_BFu7i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:7;
};
//SIG(1 BFu0c_BFu0s_BFu7i) C1{ Fc:0 Fs:0 Fi:7}



static void Test_BFu0c_BFu0s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu7i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu0s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu0s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu7i, BFu0c_BFu0s_BFu7i)
//============================================================================


struct  BFu0c_BFu0s_BFu7ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:7;
};
//SIG(1 BFu0c_BFu0s_BFu7ll) C1{ Fc:0 Fs:0 FL:7}



static void Test_BFu0c_BFu0s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu0s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu0s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu7ll, BFu0c_BFu0s_BFu7ll)
//============================================================================


struct  BFu0c_BFu0s_BFu7s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1:7;
};
//SIG(1 BFu0c_BFu0s_BFu7s) C1{ Fc:0 Fs:0 Fs:7}



static void Test_BFu0c_BFu0s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu7s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu0s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu0s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu7s, BFu0c_BFu0s_BFu7s)
//============================================================================


struct  BFu0c_BFu0s_BFu8c  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char v1:8;
};
//SIG(1 BFu0c_BFu0s_BFu8c) C1{ Fc:0 Fs:0 Fc:8}



static void Test_BFu0c_BFu0s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu8c");
    static STRUCT_IF_C BFu0c_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0c_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu0s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu0s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu8c, BFu0c_BFu0s_BFu8c)
//============================================================================


struct  BFu0c_BFu0s_BFu8i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:8;
};
//SIG(1 BFu0c_BFu0s_BFu8i) C1{ Fc:0 Fs:0 Fi:8}



static void Test_BFu0c_BFu0s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu8i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu0s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu0s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu8i, BFu0c_BFu0s_BFu8i)
//============================================================================


struct  BFu0c_BFu0s_BFu8ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:8;
};
//SIG(1 BFu0c_BFu0s_BFu8ll) C1{ Fc:0 Fs:0 FL:8}



static void Test_BFu0c_BFu0s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu0s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu0s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu8ll, BFu0c_BFu0s_BFu8ll)
//============================================================================


struct  BFu0c_BFu0s_BFu8s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1:8;
};
//SIG(1 BFu0c_BFu0s_BFu8s) C1{ Fc:0 Fs:0 Fs:8}



static void Test_BFu0c_BFu0s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu8s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu0s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu0s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu8s, BFu0c_BFu0s_BFu8s)
//============================================================================


struct  BFu0c_BFu0s_BFu9i  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1:9;
};
//SIG(1 BFu0c_BFu0s_BFu9i) C1{ Fc:0 Fs:0 Fi:9}



static void Test_BFu0c_BFu0s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu9i");
    static STRUCT_IF_C BFu0c_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu0s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu0s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu9i, BFu0c_BFu0s_BFu9i)
//============================================================================


struct  BFu0c_BFu0s_BFu9ll  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1:9;
};
//SIG(1 BFu0c_BFu0s_BFu9ll) C1{ Fc:0 Fs:0 FL:9}



static void Test_BFu0c_BFu0s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu0s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu0s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu9ll, BFu0c_BFu0s_BFu9ll)
//============================================================================


struct  BFu0c_BFu0s_BFu9s  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1:9;
};
//SIG(1 BFu0c_BFu0s_BFu9s) C1{ Fc:0 Fs:0 Fs:9}



static void Test_BFu0c_BFu0s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu0s_BFu9s");
    static STRUCT_IF_C BFu0c_BFu0s_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu0s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu0s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_BFu9s, BFu0c_BFu0s_BFu9s)
//============================================================================


struct  BFu0c_BFu0s_C  {
  unsigned char  :0;
  unsigned short  :0;
  char v1;
};
//SIG(1 BFu0c_BFu0s_C) C1{ Fc:0 Fs:0 Fc}



static void Test_BFu0c_BFu0s_C()
{
  {
    init_simple_test("BFu0c_BFu0s_C");
    static STRUCT_IF_C BFu0c_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0c_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_C)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_C.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_C, BFu0c_BFu0s_C)
//============================================================================


struct  BFu0c_BFu0s_D  {
  unsigned char  :0;
  unsigned short  :0;
  double v1;
};
//SIG(1 BFu0c_BFu0s_D) C1{ Fc:0 Fs:0 FL}



static void Test_BFu0c_BFu0s_D()
{
  {
    init_simple_test("BFu0c_BFu0s_D");
    static STRUCT_IF_C BFu0c_BFu0s_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_D)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_D.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_D, BFu0c_BFu0s_D)
//============================================================================


struct  BFu0c_BFu0s_F  {
  unsigned char  :0;
  unsigned short  :0;
  float v1;
};
//SIG(1 BFu0c_BFu0s_F) C1{ Fc:0 Fs:0 Fi}



static void Test_BFu0c_BFu0s_F()
{
  {
    init_simple_test("BFu0c_BFu0s_F");
    static STRUCT_IF_C BFu0c_BFu0s_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_F)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_F.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_F, BFu0c_BFu0s_F)
//============================================================================


struct  BFu0c_BFu0s_I  {
  unsigned char  :0;
  unsigned short  :0;
  int v1;
};
//SIG(1 BFu0c_BFu0s_I) C1{ Fc:0 Fs:0 Fi}



static void Test_BFu0c_BFu0s_I()
{
  {
    init_simple_test("BFu0c_BFu0s_I");
    static STRUCT_IF_C BFu0c_BFu0s_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_I)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_I.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_I, BFu0c_BFu0s_I)
//============================================================================


struct  BFu0c_BFu0s_Ip  {
  unsigned char  :0;
  unsigned short  :0;
  int *v1;
};
//SIG(1 BFu0c_BFu0s_Ip) C1{ Fc:0 Fs:0 Fp}



static void Test_BFu0c_BFu0s_Ip()
{
  {
    init_simple_test("BFu0c_BFu0s_Ip");
    static STRUCT_IF_C BFu0c_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Ip.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Ip, BFu0c_BFu0s_Ip)
//============================================================================


struct  BFu0c_BFu0s_L  {
  unsigned char  :0;
  unsigned short  :0;
  __tsi64 v1;
};
//SIG(1 BFu0c_BFu0s_L) C1{ Fc:0 Fs:0 FL}



static void Test_BFu0c_BFu0s_L()
{
  {
    init_simple_test("BFu0c_BFu0s_L");
    static STRUCT_IF_C BFu0c_BFu0s_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_L)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_L.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_L, BFu0c_BFu0s_L)
//============================================================================


struct  BFu0c_BFu0s_S  {
  unsigned char  :0;
  unsigned short  :0;
  short v1;
};
//SIG(1 BFu0c_BFu0s_S) C1{ Fc:0 Fs:0 Fs}



static void Test_BFu0c_BFu0s_S()
{
  {
    init_simple_test("BFu0c_BFu0s_S");
    static STRUCT_IF_C BFu0c_BFu0s_S lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_S)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_S.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_S, BFu0c_BFu0s_S)
//============================================================================


struct  BFu0c_BFu0s_Uc  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned char v1;
};
//SIG(1 BFu0c_BFu0s_Uc) C1{ Fc:0 Fs:0 Fc}



static void Test_BFu0c_BFu0s_Uc()
{
  {
    init_simple_test("BFu0c_BFu0s_Uc");
    static STRUCT_IF_C BFu0c_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0c_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Uc.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Uc, BFu0c_BFu0s_Uc)
//============================================================================


struct  BFu0c_BFu0s_Ui  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned int v1;
};
//SIG(1 BFu0c_BFu0s_Ui) C1{ Fc:0 Fs:0 Fi}



static void Test_BFu0c_BFu0s_Ui()
{
  {
    init_simple_test("BFu0c_BFu0s_Ui");
    static STRUCT_IF_C BFu0c_BFu0s_Ui lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Ui.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Ui, BFu0c_BFu0s_Ui)
//============================================================================


struct  BFu0c_BFu0s_Ul  {
  unsigned char  :0;
  unsigned short  :0;
  __tsu64 v1;
};
//SIG(1 BFu0c_BFu0s_Ul) C1{ Fc:0 Fs:0 FL}



static void Test_BFu0c_BFu0s_Ul()
{
  {
    init_simple_test("BFu0c_BFu0s_Ul");
    static STRUCT_IF_C BFu0c_BFu0s_Ul lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Ul.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Ul, BFu0c_BFu0s_Ul)
//============================================================================


struct  BFu0c_BFu0s_Us  {
  unsigned char  :0;
  unsigned short  :0;
  unsigned short v1;
};
//SIG(1 BFu0c_BFu0s_Us) C1{ Fc:0 Fs:0 Fs}



static void Test_BFu0c_BFu0s_Us()
{
  {
    init_simple_test("BFu0c_BFu0s_Us");
    static STRUCT_IF_C BFu0c_BFu0s_Us lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu0s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Us.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Us, BFu0c_BFu0s_Us)
//============================================================================


struct  BFu0c_BFu0s_Vp  {
  unsigned char  :0;
  unsigned short  :0;
  void *v1;
};
//SIG(1 BFu0c_BFu0s_Vp) C1{ Fc:0 Fs:0 Fp}



static void Test_BFu0c_BFu0s_Vp()
{
  {
    init_simple_test("BFu0c_BFu0s_Vp");
    static STRUCT_IF_C BFu0c_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "BFu0c_BFu0s_Vp.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu0s_Vp, BFu0c_BFu0s_Vp)
//============================================================================


struct  BFu0c_BFu15i  {
  unsigned char  :0;
  unsigned int v1:15;
};
//SIG(1 BFu0c_BFu15i) C1{ Fc:0 Fi:15}



static void Test_BFu0c_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu15i");
    static STRUCT_IF_C BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i, BFu0c_BFu15i)
//============================================================================


struct  BFu0c_BFu15i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu15i_BFu0c) C1{ Fc:0 Fi:15 Fc:0}



static void Test_BFu0c_BFu15i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu0c, BFu0c_BFu15i_BFu0c)
//============================================================================


struct  BFu0c_BFu15i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu15i_BFu0i) C1{ Fc:0 Fi:15 Fi:0}



static void Test_BFu0c_BFu15i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu0i, BFu0c_BFu15i_BFu0i)
//============================================================================


struct  BFu0c_BFu15i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu15i_BFu0ll) C1{ Fc:0 Fi:15 FL:0}



static void Test_BFu0c_BFu15i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu15i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu0ll, BFu0c_BFu15i_BFu0ll)
//============================================================================


struct  BFu0c_BFu15i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu15i_BFu0s) C1{ Fc:0 Fi:15 Fs:0}



static void Test_BFu0c_BFu15i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu0s, BFu0c_BFu15i_BFu0s)
//============================================================================


struct  BFu0c_BFu15i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu15i_BFu15i) C1{ Fc:0 Fi:15 Fi:15}



static void Test_BFu0c_BFu15i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu0c_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu15i, BFu0c_BFu15i_BFu15i)
//============================================================================


struct  BFu0c_BFu15i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu15i_BFu15ll) C1{ Fc:0 Fi:15 FL:15}



static void Test_BFu0c_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu0c_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu15ll, BFu0c_BFu15i_BFu15ll)
//============================================================================


struct  BFu0c_BFu15i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu15i_BFu15s) C1{ Fc:0 Fi:15 Fs:15}



static void Test_BFu0c_BFu15i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu15s, BFu0c_BFu15i_BFu15s)
//============================================================================


struct  BFu0c_BFu15i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu15i_BFu16i) C1{ Fc:0 Fi:15 Fi:16}



static void Test_BFu0c_BFu15i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu0c_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu16i, BFu0c_BFu15i_BFu16i)
//============================================================================


struct  BFu0c_BFu15i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu15i_BFu16ll) C1{ Fc:0 Fi:15 FL:16}



static void Test_BFu0c_BFu15i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu0c_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu16ll, BFu0c_BFu15i_BFu16ll)
//============================================================================


struct  BFu0c_BFu15i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu15i_BFu16s) C1{ Fc:0 Fi:15 Fs:16}



static void Test_BFu0c_BFu15i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu16s, BFu0c_BFu15i_BFu16s)
//============================================================================


struct  BFu0c_BFu15i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu15i_BFu17i) C1{ Fc:0 Fi:15 Fi:17}



static void Test_BFu0c_BFu15i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu0c_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu17i, BFu0c_BFu15i_BFu17i)
//============================================================================


struct  BFu0c_BFu15i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu15i_BFu17ll) C1{ Fc:0 Fi:15 FL:17}



static void Test_BFu0c_BFu15i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu0c_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu17ll, BFu0c_BFu15i_BFu17ll)
//============================================================================


struct  BFu0c_BFu15i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu15i_BFu1c) C1{ Fc:0 Fi:15 Fc:1}



static void Test_BFu0c_BFu15i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu1c, BFu0c_BFu15i_BFu1c)
//============================================================================


struct  BFu0c_BFu15i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu15i_BFu1i) C1{ Fc:0 Fi:15 Fi:1}



static void Test_BFu0c_BFu15i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu1i, BFu0c_BFu15i_BFu1i)
//============================================================================


struct  BFu0c_BFu15i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu15i_BFu1ll) C1{ Fc:0 Fi:15 FL:1}



static void Test_BFu0c_BFu15i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu1ll, BFu0c_BFu15i_BFu1ll)
//============================================================================


struct  BFu0c_BFu15i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu15i_BFu1s) C1{ Fc:0 Fi:15 Fs:1}



static void Test_BFu0c_BFu15i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu1s, BFu0c_BFu15i_BFu1s)
//============================================================================


struct  BFu0c_BFu15i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu15i_BFu31i) C1{ Fc:0 Fi:15 Fi:31}



static void Test_BFu0c_BFu15i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu31i, BFu0c_BFu15i_BFu31i)
//============================================================================


struct  BFu0c_BFu15i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu15i_BFu31ll) C1{ Fc:0 Fi:15 FL:31}



static void Test_BFu0c_BFu15i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu0c_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu31ll, BFu0c_BFu15i_BFu31ll)
//============================================================================


struct  BFu0c_BFu15i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu15i_BFu32i) C1{ Fc:0 Fi:15 Fi:32}



static void Test_BFu0c_BFu15i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu32i, BFu0c_BFu15i_BFu32i)
//============================================================================


struct  BFu0c_BFu15i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu15i_BFu32ll) C1{ Fc:0 Fi:15 FL:32}



static void Test_BFu0c_BFu15i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu0c_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu32ll, BFu0c_BFu15i_BFu32ll)
//============================================================================


struct  BFu0c_BFu15i_BFu33  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu15i_BFu33) C1{ Fc:0 Fi:15 FL:33}



static void Test_BFu0c_BFu15i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu33");
    static STRUCT_IF_C BFu0c_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu0c_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu33, BFu0c_BFu15i_BFu33)
//============================================================================


struct  BFu0c_BFu15i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu15i_BFu7c) C1{ Fc:0 Fi:15 Fc:7}



static void Test_BFu0c_BFu15i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu7c, BFu0c_BFu15i_BFu7c)
//============================================================================


struct  BFu0c_BFu15i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu15i_BFu7i) C1{ Fc:0 Fi:15 Fi:7}



static void Test_BFu0c_BFu15i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu0c_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu7i, BFu0c_BFu15i_BFu7i)
//============================================================================


struct  BFu0c_BFu15i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu15i_BFu7ll) C1{ Fc:0 Fi:15 FL:7}



static void Test_BFu0c_BFu15i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu0c_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu7ll, BFu0c_BFu15i_BFu7ll)
//============================================================================


struct  BFu0c_BFu15i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu15i_BFu7s) C1{ Fc:0 Fi:15 Fs:7}



static void Test_BFu0c_BFu15i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu7s, BFu0c_BFu15i_BFu7s)
//============================================================================


struct  BFu0c_BFu15i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu15i_BFu8c) C1{ Fc:0 Fi:15 Fc:8}



static void Test_BFu0c_BFu15i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu8c, BFu0c_BFu15i_BFu8c)
//============================================================================


struct  BFu0c_BFu15i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu15i_BFu8i) C1{ Fc:0 Fi:15 Fi:8}



static void Test_BFu0c_BFu15i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu0c_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu8i, BFu0c_BFu15i_BFu8i)
//============================================================================


struct  BFu0c_BFu15i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu15i_BFu8ll) C1{ Fc:0 Fi:15 FL:8}



static void Test_BFu0c_BFu15i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu0c_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu8ll, BFu0c_BFu15i_BFu8ll)
//============================================================================


struct  BFu0c_BFu15i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu15i_BFu8s) C1{ Fc:0 Fi:15 Fs:8}



static void Test_BFu0c_BFu15i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu8s, BFu0c_BFu15i_BFu8s)
//============================================================================


struct  BFu0c_BFu15i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu15i_BFu9i) C1{ Fc:0 Fi:15 Fi:9}



static void Test_BFu0c_BFu15i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu0c_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu9i, BFu0c_BFu15i_BFu9i)
//============================================================================


struct  BFu0c_BFu15i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu15i_BFu9ll) C1{ Fc:0 Fi:15 FL:9}



static void Test_BFu0c_BFu15i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu15i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu0c_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu9ll, BFu0c_BFu15i_BFu9ll)
//============================================================================


struct  BFu0c_BFu15i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu15i_BFu9s) C1{ Fc:0 Fi:15 Fs:9}



static void Test_BFu0c_BFu15i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu15i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_BFu9s, BFu0c_BFu15i_BFu9s)
//============================================================================


struct  BFu0c_BFu15i_C  {
  unsigned char  :0;
  unsigned int v1:15;
  char v2;
};
//SIG(1 BFu0c_BFu15i_C) C1{ Fc:0 Fi:15 Fc}



static void Test_BFu0c_BFu15i_C()
{
  {
    init_simple_test("BFu0c_BFu15i_C");
    static STRUCT_IF_C BFu0c_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_C, BFu0c_BFu15i_C)
//============================================================================


struct  BFu0c_BFu15i_D  {
  unsigned char  :0;
  unsigned int v1:15;
  double v2;
};
//SIG(1 BFu0c_BFu15i_D) C1{ Fc:0 Fi:15 FL}



static void Test_BFu0c_BFu15i_D()
{
  {
    init_simple_test("BFu0c_BFu15i_D");
    static STRUCT_IF_C BFu0c_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_D, BFu0c_BFu15i_D)
//============================================================================


struct  BFu0c_BFu15i_F  {
  unsigned char  :0;
  unsigned int v1:15;
  float v2;
};
//SIG(1 BFu0c_BFu15i_F) C1{ Fc:0 Fi:15 Fi}



static void Test_BFu0c_BFu15i_F()
{
  {
    init_simple_test("BFu0c_BFu15i_F");
    static STRUCT_IF_C BFu0c_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_F, BFu0c_BFu15i_F)
//============================================================================


struct  BFu0c_BFu15i_I  {
  unsigned char  :0;
  unsigned int v1:15;
  int v2;
};
//SIG(1 BFu0c_BFu15i_I) C1{ Fc:0 Fi:15 Fi}



static void Test_BFu0c_BFu15i_I()
{
  {
    init_simple_test("BFu0c_BFu15i_I");
    static STRUCT_IF_C BFu0c_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_I, BFu0c_BFu15i_I)
//============================================================================


struct  BFu0c_BFu15i_Ip  {
  unsigned char  :0;
  unsigned int v1:15;
  int *v2;
};
//SIG(1 BFu0c_BFu15i_Ip) C1{ Fc:0 Fi:15 Fp}



static void Test_BFu0c_BFu15i_Ip()
{
  {
    init_simple_test("BFu0c_BFu15i_Ip");
    static STRUCT_IF_C BFu0c_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Ip, BFu0c_BFu15i_Ip)
//============================================================================


struct  BFu0c_BFu15i_L  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu15i_L) C1{ Fc:0 Fi:15 FL}



static void Test_BFu0c_BFu15i_L()
{
  {
    init_simple_test("BFu0c_BFu15i_L");
    static STRUCT_IF_C BFu0c_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_L, BFu0c_BFu15i_L)
//============================================================================


struct  BFu0c_BFu15i_S  {
  unsigned char  :0;
  unsigned int v1:15;
  short v2;
};
//SIG(1 BFu0c_BFu15i_S) C1{ Fc:0 Fi:15 Fs}



static void Test_BFu0c_BFu15i_S()
{
  {
    init_simple_test("BFu0c_BFu15i_S");
    static STRUCT_IF_C BFu0c_BFu15i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_S, BFu0c_BFu15i_S)
//============================================================================


struct  BFu0c_BFu15i_Uc  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu15i_Uc) C1{ Fc:0 Fi:15 Fc}



static void Test_BFu0c_BFu15i_Uc()
{
  {
    init_simple_test("BFu0c_BFu15i_Uc");
    static STRUCT_IF_C BFu0c_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Uc, BFu0c_BFu15i_Uc)
//============================================================================


struct  BFu0c_BFu15i_Ui  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu15i_Ui) C1{ Fc:0 Fi:15 Fi}



static void Test_BFu0c_BFu15i_Ui()
{
  {
    init_simple_test("BFu0c_BFu15i_Ui");
    static STRUCT_IF_C BFu0c_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Ui, BFu0c_BFu15i_Ui)
//============================================================================


struct  BFu0c_BFu15i_Ul  {
  unsigned char  :0;
  unsigned int v1:15;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu15i_Ul) C1{ Fc:0 Fi:15 FL}



static void Test_BFu0c_BFu15i_Ul()
{
  {
    init_simple_test("BFu0c_BFu15i_Ul");
    static STRUCT_IF_C BFu0c_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Ul, BFu0c_BFu15i_Ul)
//============================================================================


struct  BFu0c_BFu15i_Us  {
  unsigned char  :0;
  unsigned int v1:15;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu15i_Us) C1{ Fc:0 Fi:15 Fs}



static void Test_BFu0c_BFu15i_Us()
{
  {
    init_simple_test("BFu0c_BFu15i_Us");
    static STRUCT_IF_C BFu0c_BFu15i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Us, BFu0c_BFu15i_Us)
//============================================================================


struct  BFu0c_BFu15i_Vp  {
  unsigned char  :0;
  unsigned int v1:15;
  void *v2;
};
//SIG(1 BFu0c_BFu15i_Vp) C1{ Fc:0 Fi:15 Fp}



static void Test_BFu0c_BFu15i_Vp()
{
  {
    init_simple_test("BFu0c_BFu15i_Vp");
    static STRUCT_IF_C BFu0c_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15i_Vp, BFu0c_BFu15i_Vp)
//============================================================================


struct  BFu0c_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:15;
};
//SIG(1 BFu0c_BFu15ll) C1{ Fc:0 FL:15}



static void Test_BFu0c_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll, BFu0c_BFu15ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu15ll_BFu0c) C1{ Fc:0 FL:15 Fc:0}



static void Test_BFu0c_BFu15ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu0c, BFu0c_BFu15ll_BFu0c)
//============================================================================


struct  BFu0c_BFu15ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu15ll_BFu0i) C1{ Fc:0 FL:15 Fi:0}



static void Test_BFu0c_BFu15ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu0i, BFu0c_BFu15ll_BFu0i)
//============================================================================


struct  BFu0c_BFu15ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu15ll_BFu0ll) C1{ Fc:0 FL:15 FL:0}



static void Test_BFu0c_BFu15ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu0ll, BFu0c_BFu15ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu15ll_BFu0s) C1{ Fc:0 FL:15 Fs:0}



static void Test_BFu0c_BFu15ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu0s, BFu0c_BFu15ll_BFu0s)
//============================================================================


struct  BFu0c_BFu15ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu15ll_BFu15i) C1{ Fc:0 FL:15 Fi:15}



static void Test_BFu0c_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu0c_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu15i, BFu0c_BFu15ll_BFu15i)
//============================================================================


struct  BFu0c_BFu15ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu15ll_BFu15ll) C1{ Fc:0 FL:15 FL:15}



static void Test_BFu0c_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu0c_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu15ll, BFu0c_BFu15ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu15ll_BFu15s) C1{ Fc:0 FL:15 Fs:15}



static void Test_BFu0c_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu15s, BFu0c_BFu15ll_BFu15s)
//============================================================================


struct  BFu0c_BFu15ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu15ll_BFu16i) C1{ Fc:0 FL:15 Fi:16}



static void Test_BFu0c_BFu15ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu0c_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu16i, BFu0c_BFu15ll_BFu16i)
//============================================================================


struct  BFu0c_BFu15ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu15ll_BFu16ll) C1{ Fc:0 FL:15 FL:16}



static void Test_BFu0c_BFu15ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu0c_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu16ll, BFu0c_BFu15ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu15ll_BFu16s) C1{ Fc:0 FL:15 Fs:16}



static void Test_BFu0c_BFu15ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu16s, BFu0c_BFu15ll_BFu16s)
//============================================================================


struct  BFu0c_BFu15ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu15ll_BFu17i) C1{ Fc:0 FL:15 Fi:17}



static void Test_BFu0c_BFu15ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu0c_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu17i, BFu0c_BFu15ll_BFu17i)
//============================================================================


struct  BFu0c_BFu15ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu15ll_BFu17ll) C1{ Fc:0 FL:15 FL:17}



static void Test_BFu0c_BFu15ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu0c_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu17ll, BFu0c_BFu15ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu15ll_BFu1c) C1{ Fc:0 FL:15 Fc:1}



static void Test_BFu0c_BFu15ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu1c, BFu0c_BFu15ll_BFu1c)
//============================================================================


struct  BFu0c_BFu15ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu15ll_BFu1i) C1{ Fc:0 FL:15 Fi:1}



static void Test_BFu0c_BFu15ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu1i, BFu0c_BFu15ll_BFu1i)
//============================================================================


struct  BFu0c_BFu15ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu15ll_BFu1ll) C1{ Fc:0 FL:15 FL:1}



static void Test_BFu0c_BFu15ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu1ll, BFu0c_BFu15ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu15ll_BFu1s) C1{ Fc:0 FL:15 Fs:1}



static void Test_BFu0c_BFu15ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu1s, BFu0c_BFu15ll_BFu1s)
//============================================================================


struct  BFu0c_BFu15ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu15ll_BFu31i) C1{ Fc:0 FL:15 Fi:31}



static void Test_BFu0c_BFu15ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu31i, BFu0c_BFu15ll_BFu31i)
//============================================================================


struct  BFu0c_BFu15ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu15ll_BFu31ll) C1{ Fc:0 FL:15 FL:31}



static void Test_BFu0c_BFu15ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu0c_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu31ll, BFu0c_BFu15ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu15ll_BFu32i) C1{ Fc:0 FL:15 Fi:32}



static void Test_BFu0c_BFu15ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu32i, BFu0c_BFu15ll_BFu32i)
//============================================================================


struct  BFu0c_BFu15ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu15ll_BFu32ll) C1{ Fc:0 FL:15 FL:32}



static void Test_BFu0c_BFu15ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu0c_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu32ll, BFu0c_BFu15ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu15ll_BFu33) C1{ Fc:0 FL:15 FL:33}



static void Test_BFu0c_BFu15ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu0c_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu33, BFu0c_BFu15ll_BFu33)
//============================================================================


struct  BFu0c_BFu15ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu15ll_BFu7c) C1{ Fc:0 FL:15 Fc:7}



static void Test_BFu0c_BFu15ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu7c, BFu0c_BFu15ll_BFu7c)
//============================================================================


struct  BFu0c_BFu15ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu15ll_BFu7i) C1{ Fc:0 FL:15 Fi:7}



static void Test_BFu0c_BFu15ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu0c_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu7i, BFu0c_BFu15ll_BFu7i)
//============================================================================


struct  BFu0c_BFu15ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu15ll_BFu7ll) C1{ Fc:0 FL:15 FL:7}



static void Test_BFu0c_BFu15ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu0c_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu7ll, BFu0c_BFu15ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu15ll_BFu7s) C1{ Fc:0 FL:15 Fs:7}



static void Test_BFu0c_BFu15ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu7s, BFu0c_BFu15ll_BFu7s)
//============================================================================


struct  BFu0c_BFu15ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu15ll_BFu8c) C1{ Fc:0 FL:15 Fc:8}



static void Test_BFu0c_BFu15ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu8c, BFu0c_BFu15ll_BFu8c)
//============================================================================


struct  BFu0c_BFu15ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu15ll_BFu8i) C1{ Fc:0 FL:15 Fi:8}



static void Test_BFu0c_BFu15ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu0c_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu8i, BFu0c_BFu15ll_BFu8i)
//============================================================================


struct  BFu0c_BFu15ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu15ll_BFu8ll) C1{ Fc:0 FL:15 FL:8}



static void Test_BFu0c_BFu15ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu0c_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu8ll, BFu0c_BFu15ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu15ll_BFu8s) C1{ Fc:0 FL:15 Fs:8}



static void Test_BFu0c_BFu15ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu8s, BFu0c_BFu15ll_BFu8s)
//============================================================================


struct  BFu0c_BFu15ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu15ll_BFu9i) C1{ Fc:0 FL:15 Fi:9}



static void Test_BFu0c_BFu15ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu0c_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu9i, BFu0c_BFu15ll_BFu9i)
//============================================================================


struct  BFu0c_BFu15ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu15ll_BFu9ll) C1{ Fc:0 FL:15 FL:9}



static void Test_BFu0c_BFu15ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu0c_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu9ll, BFu0c_BFu15ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu15ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu15ll_BFu9s) C1{ Fc:0 FL:15 Fs:9}



static void Test_BFu0c_BFu15ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu15ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu15ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_BFu9s, BFu0c_BFu15ll_BFu9s)
//============================================================================


struct  BFu0c_BFu15ll_C  {
  unsigned char  :0;
  __tsu64 v1:15;
  char v2;
};
//SIG(1 BFu0c_BFu15ll_C) C1{ Fc:0 FL:15 Fc}



static void Test_BFu0c_BFu15ll_C()
{
  {
    init_simple_test("BFu0c_BFu15ll_C");
    static STRUCT_IF_C BFu0c_BFu15ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_C, BFu0c_BFu15ll_C)
//============================================================================


struct  BFu0c_BFu15ll_D  {
  unsigned char  :0;
  __tsu64 v1:15;
  double v2;
};
//SIG(1 BFu0c_BFu15ll_D) C1{ Fc:0 FL:15 FL}



static void Test_BFu0c_BFu15ll_D()
{
  {
    init_simple_test("BFu0c_BFu15ll_D");
    static STRUCT_IF_C BFu0c_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_D, BFu0c_BFu15ll_D)
//============================================================================


struct  BFu0c_BFu15ll_F  {
  unsigned char  :0;
  __tsu64 v1:15;
  float v2;
};
//SIG(1 BFu0c_BFu15ll_F) C1{ Fc:0 FL:15 Fi}



static void Test_BFu0c_BFu15ll_F()
{
  {
    init_simple_test("BFu0c_BFu15ll_F");
    static STRUCT_IF_C BFu0c_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_F, BFu0c_BFu15ll_F)
//============================================================================


struct  BFu0c_BFu15ll_I  {
  unsigned char  :0;
  __tsu64 v1:15;
  int v2;
};
//SIG(1 BFu0c_BFu15ll_I) C1{ Fc:0 FL:15 Fi}



static void Test_BFu0c_BFu15ll_I()
{
  {
    init_simple_test("BFu0c_BFu15ll_I");
    static STRUCT_IF_C BFu0c_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_I, BFu0c_BFu15ll_I)
//============================================================================


struct  BFu0c_BFu15ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:15;
  int *v2;
};
//SIG(1 BFu0c_BFu15ll_Ip) C1{ Fc:0 FL:15 Fp}



static void Test_BFu0c_BFu15ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu15ll_Ip");
    static STRUCT_IF_C BFu0c_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Ip, BFu0c_BFu15ll_Ip)
//============================================================================


struct  BFu0c_BFu15ll_L  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu15ll_L) C1{ Fc:0 FL:15 FL}



static void Test_BFu0c_BFu15ll_L()
{
  {
    init_simple_test("BFu0c_BFu15ll_L");
    static STRUCT_IF_C BFu0c_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_L, BFu0c_BFu15ll_L)
//============================================================================


struct  BFu0c_BFu15ll_S  {
  unsigned char  :0;
  __tsu64 v1:15;
  short v2;
};
//SIG(1 BFu0c_BFu15ll_S) C1{ Fc:0 FL:15 Fs}



static void Test_BFu0c_BFu15ll_S()
{
  {
    init_simple_test("BFu0c_BFu15ll_S");
    static STRUCT_IF_C BFu0c_BFu15ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_S, BFu0c_BFu15ll_S)
//============================================================================


struct  BFu0c_BFu15ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu15ll_Uc) C1{ Fc:0 FL:15 Fc}



static void Test_BFu0c_BFu15ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu15ll_Uc");
    static STRUCT_IF_C BFu0c_BFu15ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Uc, BFu0c_BFu15ll_Uc)
//============================================================================


struct  BFu0c_BFu15ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu15ll_Ui) C1{ Fc:0 FL:15 Fi}



static void Test_BFu0c_BFu15ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu15ll_Ui");
    static STRUCT_IF_C BFu0c_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Ui, BFu0c_BFu15ll_Ui)
//============================================================================


struct  BFu0c_BFu15ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:15;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu15ll_Ul) C1{ Fc:0 FL:15 FL}



static void Test_BFu0c_BFu15ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu15ll_Ul");
    static STRUCT_IF_C BFu0c_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Ul, BFu0c_BFu15ll_Ul)
//============================================================================


struct  BFu0c_BFu15ll_Us  {
  unsigned char  :0;
  __tsu64 v1:15;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu15ll_Us) C1{ Fc:0 FL:15 Fs}



static void Test_BFu0c_BFu15ll_Us()
{
  {
    init_simple_test("BFu0c_BFu15ll_Us");
    static STRUCT_IF_C BFu0c_BFu15ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Us, BFu0c_BFu15ll_Us)
//============================================================================


struct  BFu0c_BFu15ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:15;
  void *v2;
};
//SIG(1 BFu0c_BFu15ll_Vp) C1{ Fc:0 FL:15 Fp}



static void Test_BFu0c_BFu15ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu15ll_Vp");
    static STRUCT_IF_C BFu0c_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15ll_Vp, BFu0c_BFu15ll_Vp)
//============================================================================


struct  BFu0c_BFu15s  {
  unsigned char  :0;
  unsigned short v1:15;
};
//SIG(1 BFu0c_BFu15s) C1{ Fc:0 Fs:15}



static void Test_BFu0c_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu15s");
    static STRUCT_IF_C BFu0c_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s, BFu0c_BFu15s)
//============================================================================


struct  BFu0c_BFu15s_BFu0c  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu15s_BFu0c) C1{ Fc:0 Fs:15 Fc:0}



static void Test_BFu0c_BFu15s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu15s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu0c, BFu0c_BFu15s_BFu0c)
//============================================================================


struct  BFu0c_BFu15s_BFu0i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu15s_BFu0i) C1{ Fc:0 Fs:15 Fi:0}



static void Test_BFu0c_BFu15s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu15s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu0i, BFu0c_BFu15s_BFu0i)
//============================================================================


struct  BFu0c_BFu15s_BFu0ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu15s_BFu0ll) C1{ Fc:0 Fs:15 FL:0}



static void Test_BFu0c_BFu15s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu15s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu0ll, BFu0c_BFu15s_BFu0ll)
//============================================================================


struct  BFu0c_BFu15s_BFu0s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu15s_BFu0s) C1{ Fc:0 Fs:15 Fs:0}



static void Test_BFu0c_BFu15s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu0s, BFu0c_BFu15s_BFu0s)
//============================================================================


struct  BFu0c_BFu15s_BFu15i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu15s_BFu15i) C1{ Fc:0 Fs:15 Fi:15}



static void Test_BFu0c_BFu15s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu15i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu0c_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu15i, BFu0c_BFu15s_BFu15i)
//============================================================================


struct  BFu0c_BFu15s_BFu15ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu15s_BFu15ll) C1{ Fc:0 Fs:15 FL:15}



static void Test_BFu0c_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu0c_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu15ll, BFu0c_BFu15s_BFu15ll)
//============================================================================


struct  BFu0c_BFu15s_BFu15s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu15s_BFu15s) C1{ Fc:0 Fs:15 Fs:15}



static void Test_BFu0c_BFu15s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu15s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu15s, BFu0c_BFu15s_BFu15s)
//============================================================================


struct  BFu0c_BFu15s_BFu16i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu15s_BFu16i) C1{ Fc:0 Fs:15 Fi:16}



static void Test_BFu0c_BFu15s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu16i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu0c_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu16i, BFu0c_BFu15s_BFu16i)
//============================================================================


struct  BFu0c_BFu15s_BFu16ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu15s_BFu16ll) C1{ Fc:0 Fs:15 FL:16}



static void Test_BFu0c_BFu15s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu0c_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu16ll, BFu0c_BFu15s_BFu16ll)
//============================================================================


struct  BFu0c_BFu15s_BFu16s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu15s_BFu16s) C1{ Fc:0 Fs:15 Fs:16}



static void Test_BFu0c_BFu15s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu16s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu16s, BFu0c_BFu15s_BFu16s)
//============================================================================


struct  BFu0c_BFu15s_BFu17i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu15s_BFu17i) C1{ Fc:0 Fs:15 Fi:17}



static void Test_BFu0c_BFu15s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu17i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu0c_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu17i, BFu0c_BFu15s_BFu17i)
//============================================================================


struct  BFu0c_BFu15s_BFu17ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu15s_BFu17ll) C1{ Fc:0 Fs:15 FL:17}



static void Test_BFu0c_BFu15s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu0c_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu17ll, BFu0c_BFu15s_BFu17ll)
//============================================================================


struct  BFu0c_BFu15s_BFu1c  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu15s_BFu1c) C1{ Fc:0 Fs:15 Fc:1}



static void Test_BFu0c_BFu15s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu1c");
    static STRUCT_IF_C BFu0c_BFu15s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu1c, BFu0c_BFu15s_BFu1c)
//============================================================================


struct  BFu0c_BFu15s_BFu1i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu15s_BFu1i) C1{ Fc:0 Fs:15 Fi:1}



static void Test_BFu0c_BFu15s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu1i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu1i, BFu0c_BFu15s_BFu1i)
//============================================================================


struct  BFu0c_BFu15s_BFu1ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu15s_BFu1ll) C1{ Fc:0 Fs:15 FL:1}



static void Test_BFu0c_BFu15s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu1ll, BFu0c_BFu15s_BFu1ll)
//============================================================================


struct  BFu0c_BFu15s_BFu1s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu15s_BFu1s) C1{ Fc:0 Fs:15 Fs:1}



static void Test_BFu0c_BFu15s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu1s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu15s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu0c_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu1s, BFu0c_BFu15s_BFu1s)
//============================================================================


struct  BFu0c_BFu15s_BFu31i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu15s_BFu31i) C1{ Fc:0 Fs:15 Fi:31}



static void Test_BFu0c_BFu15s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu31i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu31i, BFu0c_BFu15s_BFu31i)
//============================================================================


struct  BFu0c_BFu15s_BFu31ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu15s_BFu31ll) C1{ Fc:0 Fs:15 FL:31}



static void Test_BFu0c_BFu15s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu0c_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu31ll, BFu0c_BFu15s_BFu31ll)
//============================================================================


struct  BFu0c_BFu15s_BFu32i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu15s_BFu32i) C1{ Fc:0 Fs:15 Fi:32}



static void Test_BFu0c_BFu15s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu32i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu32i, BFu0c_BFu15s_BFu32i)
//============================================================================


struct  BFu0c_BFu15s_BFu32ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu15s_BFu32ll) C1{ Fc:0 Fs:15 FL:32}



static void Test_BFu0c_BFu15s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu0c_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu32ll, BFu0c_BFu15s_BFu32ll)
//============================================================================


struct  BFu0c_BFu15s_BFu33  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu15s_BFu33) C1{ Fc:0 Fs:15 FL:33}



static void Test_BFu0c_BFu15s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu33");
    static STRUCT_IF_C BFu0c_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu0c_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu33, BFu0c_BFu15s_BFu33)
//============================================================================


struct  BFu0c_BFu15s_BFu7c  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu15s_BFu7c) C1{ Fc:0 Fs:15 Fc:7}



static void Test_BFu0c_BFu15s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu7c");
    static STRUCT_IF_C BFu0c_BFu15s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu7c, BFu0c_BFu15s_BFu7c)
//============================================================================


struct  BFu0c_BFu15s_BFu7i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu15s_BFu7i) C1{ Fc:0 Fs:15 Fi:7}



static void Test_BFu0c_BFu15s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu7i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu0c_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu7i, BFu0c_BFu15s_BFu7i)
//============================================================================


struct  BFu0c_BFu15s_BFu7ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu15s_BFu7ll) C1{ Fc:0 Fs:15 FL:7}



static void Test_BFu0c_BFu15s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu0c_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu7ll, BFu0c_BFu15s_BFu7ll)
//============================================================================


struct  BFu0c_BFu15s_BFu7s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu15s_BFu7s) C1{ Fc:0 Fs:15 Fs:7}



static void Test_BFu0c_BFu15s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu7s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu7s, BFu0c_BFu15s_BFu7s)
//============================================================================


struct  BFu0c_BFu15s_BFu8c  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu15s_BFu8c) C1{ Fc:0 Fs:15 Fc:8}



static void Test_BFu0c_BFu15s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu8c");
    static STRUCT_IF_C BFu0c_BFu15s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu8c, BFu0c_BFu15s_BFu8c)
//============================================================================


struct  BFu0c_BFu15s_BFu8i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu15s_BFu8i) C1{ Fc:0 Fs:15 Fi:8}



static void Test_BFu0c_BFu15s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu8i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu0c_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu8i, BFu0c_BFu15s_BFu8i)
//============================================================================


struct  BFu0c_BFu15s_BFu8ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu15s_BFu8ll) C1{ Fc:0 Fs:15 FL:8}



static void Test_BFu0c_BFu15s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu0c_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu8ll, BFu0c_BFu15s_BFu8ll)
//============================================================================


struct  BFu0c_BFu15s_BFu8s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu15s_BFu8s) C1{ Fc:0 Fs:15 Fs:8}



static void Test_BFu0c_BFu15s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu8s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu8s, BFu0c_BFu15s_BFu8s)
//============================================================================


struct  BFu0c_BFu15s_BFu9i  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu15s_BFu9i) C1{ Fc:0 Fs:15 Fi:9}



static void Test_BFu0c_BFu15s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu9i");
    static STRUCT_IF_C BFu0c_BFu15s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu0c_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu9i, BFu0c_BFu15s_BFu9i)
//============================================================================


struct  BFu0c_BFu15s_BFu9ll  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu15s_BFu9ll) C1{ Fc:0 Fs:15 FL:9}



static void Test_BFu0c_BFu15s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu15s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu0c_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu9ll, BFu0c_BFu15s_BFu9ll)
//============================================================================


struct  BFu0c_BFu15s_BFu9s  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu15s_BFu9s) C1{ Fc:0 Fs:15 Fs:9}



static void Test_BFu0c_BFu15s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu15s_BFu9s");
    static STRUCT_IF_C BFu0c_BFu15s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_BFu9s, BFu0c_BFu15s_BFu9s)
//============================================================================


struct  BFu0c_BFu15s_C  {
  unsigned char  :0;
  unsigned short v1:15;
  char v2;
};
//SIG(1 BFu0c_BFu15s_C) C1{ Fc:0 Fs:15 Fc}



static void Test_BFu0c_BFu15s_C()
{
  {
    init_simple_test("BFu0c_BFu15s_C");
    static STRUCT_IF_C BFu0c_BFu15s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_C, BFu0c_BFu15s_C)
//============================================================================


struct  BFu0c_BFu15s_D  {
  unsigned char  :0;
  unsigned short v1:15;
  double v2;
};
//SIG(1 BFu0c_BFu15s_D) C1{ Fc:0 Fs:15 FL}



static void Test_BFu0c_BFu15s_D()
{
  {
    init_simple_test("BFu0c_BFu15s_D");
    static STRUCT_IF_C BFu0c_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_D, BFu0c_BFu15s_D)
//============================================================================


struct  BFu0c_BFu15s_F  {
  unsigned char  :0;
  unsigned short v1:15;
  float v2;
};
//SIG(1 BFu0c_BFu15s_F) C1{ Fc:0 Fs:15 Fi}



static void Test_BFu0c_BFu15s_F()
{
  {
    init_simple_test("BFu0c_BFu15s_F");
    static STRUCT_IF_C BFu0c_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_F, BFu0c_BFu15s_F)
//============================================================================


struct  BFu0c_BFu15s_I  {
  unsigned char  :0;
  unsigned short v1:15;
  int v2;
};
//SIG(1 BFu0c_BFu15s_I) C1{ Fc:0 Fs:15 Fi}



static void Test_BFu0c_BFu15s_I()
{
  {
    init_simple_test("BFu0c_BFu15s_I");
    static STRUCT_IF_C BFu0c_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_I, BFu0c_BFu15s_I)
//============================================================================


struct  BFu0c_BFu15s_Ip  {
  unsigned char  :0;
  unsigned short v1:15;
  int *v2;
};
//SIG(1 BFu0c_BFu15s_Ip) C1{ Fc:0 Fs:15 Fp}



static void Test_BFu0c_BFu15s_Ip()
{
  {
    init_simple_test("BFu0c_BFu15s_Ip");
    static STRUCT_IF_C BFu0c_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Ip, BFu0c_BFu15s_Ip)
//============================================================================


struct  BFu0c_BFu15s_L  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu15s_L) C1{ Fc:0 Fs:15 FL}



static void Test_BFu0c_BFu15s_L()
{
  {
    init_simple_test("BFu0c_BFu15s_L");
    static STRUCT_IF_C BFu0c_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_L, BFu0c_BFu15s_L)
//============================================================================


struct  BFu0c_BFu15s_S  {
  unsigned char  :0;
  unsigned short v1:15;
  short v2;
};
//SIG(1 BFu0c_BFu15s_S) C1{ Fc:0 Fs:15 Fs}



static void Test_BFu0c_BFu15s_S()
{
  {
    init_simple_test("BFu0c_BFu15s_S");
    static STRUCT_IF_C BFu0c_BFu15s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_S, BFu0c_BFu15s_S)
//============================================================================


struct  BFu0c_BFu15s_Uc  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu15s_Uc) C1{ Fc:0 Fs:15 Fc}



static void Test_BFu0c_BFu15s_Uc()
{
  {
    init_simple_test("BFu0c_BFu15s_Uc");
    static STRUCT_IF_C BFu0c_BFu15s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Uc, BFu0c_BFu15s_Uc)
//============================================================================


struct  BFu0c_BFu15s_Ui  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu15s_Ui) C1{ Fc:0 Fs:15 Fi}



static void Test_BFu0c_BFu15s_Ui()
{
  {
    init_simple_test("BFu0c_BFu15s_Ui");
    static STRUCT_IF_C BFu0c_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu15s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu15s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Ui, BFu0c_BFu15s_Ui)
//============================================================================


struct  BFu0c_BFu15s_Ul  {
  unsigned char  :0;
  unsigned short v1:15;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu15s_Ul) C1{ Fc:0 Fs:15 FL}



static void Test_BFu0c_BFu15s_Ul()
{
  {
    init_simple_test("BFu0c_BFu15s_Ul");
    static STRUCT_IF_C BFu0c_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Ul, BFu0c_BFu15s_Ul)
//============================================================================


struct  BFu0c_BFu15s_Us  {
  unsigned char  :0;
  unsigned short v1:15;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu15s_Us) C1{ Fc:0 Fs:15 Fs}



static void Test_BFu0c_BFu15s_Us()
{
  {
    init_simple_test("BFu0c_BFu15s_Us");
    static STRUCT_IF_C BFu0c_BFu15s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu15s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu15s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu15s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Us, BFu0c_BFu15s_Us)
//============================================================================


struct  BFu0c_BFu15s_Vp  {
  unsigned char  :0;
  unsigned short v1:15;
  void *v2;
};
//SIG(1 BFu0c_BFu15s_Vp) C1{ Fc:0 Fs:15 Fp}



static void Test_BFu0c_BFu15s_Vp()
{
  {
    init_simple_test("BFu0c_BFu15s_Vp");
    static STRUCT_IF_C BFu0c_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu15s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu0c_BFu15s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu15s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu15s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu15s_Vp, BFu0c_BFu15s_Vp)
//============================================================================


struct  BFu0c_BFu16i  {
  unsigned char  :0;
  unsigned int v1:16;
};
//SIG(1 BFu0c_BFu16i) C1{ Fc:0 Fi:16}



static void Test_BFu0c_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu16i");
    static STRUCT_IF_C BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i, BFu0c_BFu16i)
//============================================================================


struct  BFu0c_BFu16i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu16i_BFu0c) C1{ Fc:0 Fi:16 Fc:0}



static void Test_BFu0c_BFu16i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu0c, BFu0c_BFu16i_BFu0c)
//============================================================================


struct  BFu0c_BFu16i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu16i_BFu0i) C1{ Fc:0 Fi:16 Fi:0}



static void Test_BFu0c_BFu16i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu0i, BFu0c_BFu16i_BFu0i)
//============================================================================


struct  BFu0c_BFu16i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu16i_BFu0ll) C1{ Fc:0 Fi:16 FL:0}



static void Test_BFu0c_BFu16i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu16i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu0ll, BFu0c_BFu16i_BFu0ll)
//============================================================================


struct  BFu0c_BFu16i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu16i_BFu0s) C1{ Fc:0 Fi:16 Fs:0}



static void Test_BFu0c_BFu16i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu0s, BFu0c_BFu16i_BFu0s)
//============================================================================


struct  BFu0c_BFu16i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu16i_BFu15i) C1{ Fc:0 Fi:16 Fi:15}



static void Test_BFu0c_BFu16i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu15i, BFu0c_BFu16i_BFu15i)
//============================================================================


struct  BFu0c_BFu16i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu16i_BFu15ll) C1{ Fc:0 Fi:16 FL:15}



static void Test_BFu0c_BFu16i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu15ll, BFu0c_BFu16i_BFu15ll)
//============================================================================


struct  BFu0c_BFu16i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu16i_BFu15s) C1{ Fc:0 Fi:16 Fs:15}



static void Test_BFu0c_BFu16i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu15s, BFu0c_BFu16i_BFu15s)
//============================================================================


struct  BFu0c_BFu16i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu16i_BFu16i) C1{ Fc:0 Fi:16 Fi:16}



static void Test_BFu0c_BFu16i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu16i, BFu0c_BFu16i_BFu16i)
//============================================================================


struct  BFu0c_BFu16i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu16i_BFu16ll) C1{ Fc:0 Fi:16 FL:16}



static void Test_BFu0c_BFu16i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu16ll, BFu0c_BFu16i_BFu16ll)
//============================================================================


struct  BFu0c_BFu16i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu16i_BFu16s) C1{ Fc:0 Fi:16 Fs:16}



static void Test_BFu0c_BFu16i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu16s, BFu0c_BFu16i_BFu16s)
//============================================================================


struct  BFu0c_BFu16i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu16i_BFu17i) C1{ Fc:0 Fi:16 Fi:17}



static void Test_BFu0c_BFu16i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu17i, BFu0c_BFu16i_BFu17i)
//============================================================================


struct  BFu0c_BFu16i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu16i_BFu17ll) C1{ Fc:0 Fi:16 FL:17}



static void Test_BFu0c_BFu16i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu17ll, BFu0c_BFu16i_BFu17ll)
//============================================================================


struct  BFu0c_BFu16i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu16i_BFu1c) C1{ Fc:0 Fi:16 Fc:1}



static void Test_BFu0c_BFu16i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu1c, BFu0c_BFu16i_BFu1c)
//============================================================================


struct  BFu0c_BFu16i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu16i_BFu1i) C1{ Fc:0 Fi:16 Fi:1}



static void Test_BFu0c_BFu16i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu1i, BFu0c_BFu16i_BFu1i)
//============================================================================


struct  BFu0c_BFu16i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu16i_BFu1ll) C1{ Fc:0 Fi:16 FL:1}



static void Test_BFu0c_BFu16i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu1ll, BFu0c_BFu16i_BFu1ll)
//============================================================================


struct  BFu0c_BFu16i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu16i_BFu1s) C1{ Fc:0 Fi:16 Fs:1}



static void Test_BFu0c_BFu16i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu1s, BFu0c_BFu16i_BFu1s)
//============================================================================


struct  BFu0c_BFu16i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu16i_BFu31i) C1{ Fc:0 Fi:16 Fi:31}



static void Test_BFu0c_BFu16i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu31i, BFu0c_BFu16i_BFu31i)
//============================================================================


struct  BFu0c_BFu16i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu16i_BFu31ll) C1{ Fc:0 Fi:16 FL:31}



static void Test_BFu0c_BFu16i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu31ll, BFu0c_BFu16i_BFu31ll)
//============================================================================


struct  BFu0c_BFu16i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu16i_BFu32i) C1{ Fc:0 Fi:16 Fi:32}



static void Test_BFu0c_BFu16i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu32i, BFu0c_BFu16i_BFu32i)
//============================================================================


struct  BFu0c_BFu16i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu16i_BFu32ll) C1{ Fc:0 Fi:16 FL:32}



static void Test_BFu0c_BFu16i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu32ll, BFu0c_BFu16i_BFu32ll)
//============================================================================


struct  BFu0c_BFu16i_BFu33  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu16i_BFu33) C1{ Fc:0 Fi:16 FL:33}



static void Test_BFu0c_BFu16i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu33");
    static STRUCT_IF_C BFu0c_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0c_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu33, BFu0c_BFu16i_BFu33)
//============================================================================


struct  BFu0c_BFu16i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu16i_BFu7c) C1{ Fc:0 Fi:16 Fc:7}



static void Test_BFu0c_BFu16i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu7c, BFu0c_BFu16i_BFu7c)
//============================================================================


struct  BFu0c_BFu16i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu16i_BFu7i) C1{ Fc:0 Fi:16 Fi:7}



static void Test_BFu0c_BFu16i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu7i, BFu0c_BFu16i_BFu7i)
//============================================================================


struct  BFu0c_BFu16i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu16i_BFu7ll) C1{ Fc:0 Fi:16 FL:7}



static void Test_BFu0c_BFu16i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu7ll, BFu0c_BFu16i_BFu7ll)
//============================================================================


struct  BFu0c_BFu16i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu16i_BFu7s) C1{ Fc:0 Fi:16 Fs:7}



static void Test_BFu0c_BFu16i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu7s, BFu0c_BFu16i_BFu7s)
//============================================================================


struct  BFu0c_BFu16i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu16i_BFu8c) C1{ Fc:0 Fi:16 Fc:8}



static void Test_BFu0c_BFu16i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu8c, BFu0c_BFu16i_BFu8c)
//============================================================================


struct  BFu0c_BFu16i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu16i_BFu8i) C1{ Fc:0 Fi:16 Fi:8}



static void Test_BFu0c_BFu16i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu8i, BFu0c_BFu16i_BFu8i)
//============================================================================


struct  BFu0c_BFu16i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu16i_BFu8ll) C1{ Fc:0 Fi:16 FL:8}



static void Test_BFu0c_BFu16i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu8ll, BFu0c_BFu16i_BFu8ll)
//============================================================================


struct  BFu0c_BFu16i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu16i_BFu8s) C1{ Fc:0 Fi:16 Fs:8}



static void Test_BFu0c_BFu16i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu8s, BFu0c_BFu16i_BFu8s)
//============================================================================


struct  BFu0c_BFu16i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu16i_BFu9i) C1{ Fc:0 Fi:16 Fi:9}



static void Test_BFu0c_BFu16i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu16i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu9i, BFu0c_BFu16i_BFu9i)
//============================================================================


struct  BFu0c_BFu16i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu16i_BFu9ll) C1{ Fc:0 Fi:16 FL:9}



static void Test_BFu0c_BFu16i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu9ll, BFu0c_BFu16i_BFu9ll)
//============================================================================


struct  BFu0c_BFu16i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu16i_BFu9s) C1{ Fc:0 Fi:16 Fs:9}



static void Test_BFu0c_BFu16i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu16i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu16i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_BFu9s, BFu0c_BFu16i_BFu9s)
//============================================================================


struct  BFu0c_BFu16i_C  {
  unsigned char  :0;
  unsigned int v1:16;
  char v2;
};
//SIG(1 BFu0c_BFu16i_C) C1{ Fc:0 Fi:16 Fc}



static void Test_BFu0c_BFu16i_C()
{
  {
    init_simple_test("BFu0c_BFu16i_C");
    static STRUCT_IF_C BFu0c_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_C, BFu0c_BFu16i_C)
//============================================================================


struct  BFu0c_BFu16i_D  {
  unsigned char  :0;
  unsigned int v1:16;
  double v2;
};
//SIG(1 BFu0c_BFu16i_D) C1{ Fc:0 Fi:16 FL}



static void Test_BFu0c_BFu16i_D()
{
  {
    init_simple_test("BFu0c_BFu16i_D");
    static STRUCT_IF_C BFu0c_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_D, BFu0c_BFu16i_D)
//============================================================================


struct  BFu0c_BFu16i_F  {
  unsigned char  :0;
  unsigned int v1:16;
  float v2;
};
//SIG(1 BFu0c_BFu16i_F) C1{ Fc:0 Fi:16 Fi}



static void Test_BFu0c_BFu16i_F()
{
  {
    init_simple_test("BFu0c_BFu16i_F");
    static STRUCT_IF_C BFu0c_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_F, BFu0c_BFu16i_F)
//============================================================================


struct  BFu0c_BFu16i_I  {
  unsigned char  :0;
  unsigned int v1:16;
  int v2;
};
//SIG(1 BFu0c_BFu16i_I) C1{ Fc:0 Fi:16 Fi}



static void Test_BFu0c_BFu16i_I()
{
  {
    init_simple_test("BFu0c_BFu16i_I");
    static STRUCT_IF_C BFu0c_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_I, BFu0c_BFu16i_I)
//============================================================================


struct  BFu0c_BFu16i_Ip  {
  unsigned char  :0;
  unsigned int v1:16;
  int *v2;
};
//SIG(1 BFu0c_BFu16i_Ip) C1{ Fc:0 Fi:16 Fp}



static void Test_BFu0c_BFu16i_Ip()
{
  {
    init_simple_test("BFu0c_BFu16i_Ip");
    static STRUCT_IF_C BFu0c_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Ip, BFu0c_BFu16i_Ip)
//============================================================================


struct  BFu0c_BFu16i_L  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu16i_L) C1{ Fc:0 Fi:16 FL}



static void Test_BFu0c_BFu16i_L()
{
  {
    init_simple_test("BFu0c_BFu16i_L");
    static STRUCT_IF_C BFu0c_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_L, BFu0c_BFu16i_L)
//============================================================================


struct  BFu0c_BFu16i_S  {
  unsigned char  :0;
  unsigned int v1:16;
  short v2;
};
//SIG(1 BFu0c_BFu16i_S) C1{ Fc:0 Fi:16 Fs}



static void Test_BFu0c_BFu16i_S()
{
  {
    init_simple_test("BFu0c_BFu16i_S");
    static STRUCT_IF_C BFu0c_BFu16i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_S, BFu0c_BFu16i_S)
//============================================================================


struct  BFu0c_BFu16i_Uc  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu16i_Uc) C1{ Fc:0 Fi:16 Fc}



static void Test_BFu0c_BFu16i_Uc()
{
  {
    init_simple_test("BFu0c_BFu16i_Uc");
    static STRUCT_IF_C BFu0c_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Uc, BFu0c_BFu16i_Uc)
//============================================================================


struct  BFu0c_BFu16i_Ui  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu16i_Ui) C1{ Fc:0 Fi:16 Fi}



static void Test_BFu0c_BFu16i_Ui()
{
  {
    init_simple_test("BFu0c_BFu16i_Ui");
    static STRUCT_IF_C BFu0c_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Ui, BFu0c_BFu16i_Ui)
//============================================================================


struct  BFu0c_BFu16i_Ul  {
  unsigned char  :0;
  unsigned int v1:16;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu16i_Ul) C1{ Fc:0 Fi:16 FL}



static void Test_BFu0c_BFu16i_Ul()
{
  {
    init_simple_test("BFu0c_BFu16i_Ul");
    static STRUCT_IF_C BFu0c_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Ul, BFu0c_BFu16i_Ul)
//============================================================================


struct  BFu0c_BFu16i_Us  {
  unsigned char  :0;
  unsigned int v1:16;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu16i_Us) C1{ Fc:0 Fi:16 Fs}



static void Test_BFu0c_BFu16i_Us()
{
  {
    init_simple_test("BFu0c_BFu16i_Us");
    static STRUCT_IF_C BFu0c_BFu16i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Us, BFu0c_BFu16i_Us)
//============================================================================


struct  BFu0c_BFu16i_Vp  {
  unsigned char  :0;
  unsigned int v1:16;
  void *v2;
};
//SIG(1 BFu0c_BFu16i_Vp) C1{ Fc:0 Fi:16 Fp}



static void Test_BFu0c_BFu16i_Vp()
{
  {
    init_simple_test("BFu0c_BFu16i_Vp");
    static STRUCT_IF_C BFu0c_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16i_Vp, BFu0c_BFu16i_Vp)
//============================================================================


struct  BFu0c_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:16;
};
//SIG(1 BFu0c_BFu16ll) C1{ Fc:0 FL:16}



static void Test_BFu0c_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll, BFu0c_BFu16ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu16ll_BFu0c) C1{ Fc:0 FL:16 Fc:0}



static void Test_BFu0c_BFu16ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu0c, BFu0c_BFu16ll_BFu0c)
//============================================================================


struct  BFu0c_BFu16ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu16ll_BFu0i) C1{ Fc:0 FL:16 Fi:0}



static void Test_BFu0c_BFu16ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu0i, BFu0c_BFu16ll_BFu0i)
//============================================================================


struct  BFu0c_BFu16ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu16ll_BFu0ll) C1{ Fc:0 FL:16 FL:0}



static void Test_BFu0c_BFu16ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu0ll, BFu0c_BFu16ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu16ll_BFu0s) C1{ Fc:0 FL:16 Fs:0}



static void Test_BFu0c_BFu16ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu0s, BFu0c_BFu16ll_BFu0s)
//============================================================================


struct  BFu0c_BFu16ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu16ll_BFu15i) C1{ Fc:0 FL:16 Fi:15}



static void Test_BFu0c_BFu16ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu15i, BFu0c_BFu16ll_BFu15i)
//============================================================================


struct  BFu0c_BFu16ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu16ll_BFu15ll) C1{ Fc:0 FL:16 FL:15}



static void Test_BFu0c_BFu16ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu15ll, BFu0c_BFu16ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu16ll_BFu15s) C1{ Fc:0 FL:16 Fs:15}



static void Test_BFu0c_BFu16ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu15s, BFu0c_BFu16ll_BFu15s)
//============================================================================


struct  BFu0c_BFu16ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu16ll_BFu16i) C1{ Fc:0 FL:16 Fi:16}



static void Test_BFu0c_BFu16ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu16i, BFu0c_BFu16ll_BFu16i)
//============================================================================


struct  BFu0c_BFu16ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu16ll_BFu16ll) C1{ Fc:0 FL:16 FL:16}



static void Test_BFu0c_BFu16ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu16ll, BFu0c_BFu16ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu16ll_BFu16s) C1{ Fc:0 FL:16 Fs:16}



static void Test_BFu0c_BFu16ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu16s, BFu0c_BFu16ll_BFu16s)
//============================================================================


struct  BFu0c_BFu16ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu16ll_BFu17i) C1{ Fc:0 FL:16 Fi:17}



static void Test_BFu0c_BFu16ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu17i, BFu0c_BFu16ll_BFu17i)
//============================================================================


struct  BFu0c_BFu16ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu16ll_BFu17ll) C1{ Fc:0 FL:16 FL:17}



static void Test_BFu0c_BFu16ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu17ll, BFu0c_BFu16ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu16ll_BFu1c) C1{ Fc:0 FL:16 Fc:1}



static void Test_BFu0c_BFu16ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu1c, BFu0c_BFu16ll_BFu1c)
//============================================================================


struct  BFu0c_BFu16ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu16ll_BFu1i) C1{ Fc:0 FL:16 Fi:1}



static void Test_BFu0c_BFu16ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu1i, BFu0c_BFu16ll_BFu1i)
//============================================================================


struct  BFu0c_BFu16ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu16ll_BFu1ll) C1{ Fc:0 FL:16 FL:1}



static void Test_BFu0c_BFu16ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu1ll, BFu0c_BFu16ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu16ll_BFu1s) C1{ Fc:0 FL:16 Fs:1}



static void Test_BFu0c_BFu16ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu1s, BFu0c_BFu16ll_BFu1s)
//============================================================================


struct  BFu0c_BFu16ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu16ll_BFu31i) C1{ Fc:0 FL:16 Fi:31}



static void Test_BFu0c_BFu16ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu31i, BFu0c_BFu16ll_BFu31i)
//============================================================================


struct  BFu0c_BFu16ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu16ll_BFu31ll) C1{ Fc:0 FL:16 FL:31}



static void Test_BFu0c_BFu16ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu31ll, BFu0c_BFu16ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu16ll_BFu32i) C1{ Fc:0 FL:16 Fi:32}



static void Test_BFu0c_BFu16ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu32i, BFu0c_BFu16ll_BFu32i)
//============================================================================


struct  BFu0c_BFu16ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu16ll_BFu32ll) C1{ Fc:0 FL:16 FL:32}



static void Test_BFu0c_BFu16ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu32ll, BFu0c_BFu16ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu16ll_BFu33) C1{ Fc:0 FL:16 FL:33}



static void Test_BFu0c_BFu16ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0c_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu33, BFu0c_BFu16ll_BFu33)
//============================================================================


struct  BFu0c_BFu16ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu16ll_BFu7c) C1{ Fc:0 FL:16 Fc:7}



static void Test_BFu0c_BFu16ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu7c, BFu0c_BFu16ll_BFu7c)
//============================================================================


struct  BFu0c_BFu16ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu16ll_BFu7i) C1{ Fc:0 FL:16 Fi:7}



static void Test_BFu0c_BFu16ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu7i, BFu0c_BFu16ll_BFu7i)
//============================================================================


struct  BFu0c_BFu16ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu16ll_BFu7ll) C1{ Fc:0 FL:16 FL:7}



static void Test_BFu0c_BFu16ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu7ll, BFu0c_BFu16ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu16ll_BFu7s) C1{ Fc:0 FL:16 Fs:7}



static void Test_BFu0c_BFu16ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu7s, BFu0c_BFu16ll_BFu7s)
//============================================================================


struct  BFu0c_BFu16ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu16ll_BFu8c) C1{ Fc:0 FL:16 Fc:8}



static void Test_BFu0c_BFu16ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu8c, BFu0c_BFu16ll_BFu8c)
//============================================================================


struct  BFu0c_BFu16ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu16ll_BFu8i) C1{ Fc:0 FL:16 Fi:8}



static void Test_BFu0c_BFu16ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu8i, BFu0c_BFu16ll_BFu8i)
//============================================================================


struct  BFu0c_BFu16ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu16ll_BFu8ll) C1{ Fc:0 FL:16 FL:8}



static void Test_BFu0c_BFu16ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu8ll, BFu0c_BFu16ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu16ll_BFu8s) C1{ Fc:0 FL:16 Fs:8}



static void Test_BFu0c_BFu16ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu8s, BFu0c_BFu16ll_BFu8s)
//============================================================================


struct  BFu0c_BFu16ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu16ll_BFu9i) C1{ Fc:0 FL:16 Fi:9}



static void Test_BFu0c_BFu16ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu9i, BFu0c_BFu16ll_BFu9i)
//============================================================================


struct  BFu0c_BFu16ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu16ll_BFu9ll) C1{ Fc:0 FL:16 FL:9}



static void Test_BFu0c_BFu16ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu9ll, BFu0c_BFu16ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu16ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu16ll_BFu9s) C1{ Fc:0 FL:16 Fs:9}



static void Test_BFu0c_BFu16ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu16ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_BFu9s, BFu0c_BFu16ll_BFu9s)
//============================================================================


struct  BFu0c_BFu16ll_C  {
  unsigned char  :0;
  __tsu64 v1:16;
  char v2;
};
//SIG(1 BFu0c_BFu16ll_C) C1{ Fc:0 FL:16 Fc}



static void Test_BFu0c_BFu16ll_C()
{
  {
    init_simple_test("BFu0c_BFu16ll_C");
    static STRUCT_IF_C BFu0c_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_C, BFu0c_BFu16ll_C)
//============================================================================


struct  BFu0c_BFu16ll_D  {
  unsigned char  :0;
  __tsu64 v1:16;
  double v2;
};
//SIG(1 BFu0c_BFu16ll_D) C1{ Fc:0 FL:16 FL}



static void Test_BFu0c_BFu16ll_D()
{
  {
    init_simple_test("BFu0c_BFu16ll_D");
    static STRUCT_IF_C BFu0c_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_D, BFu0c_BFu16ll_D)
//============================================================================


struct  BFu0c_BFu16ll_F  {
  unsigned char  :0;
  __tsu64 v1:16;
  float v2;
};
//SIG(1 BFu0c_BFu16ll_F) C1{ Fc:0 FL:16 Fi}



static void Test_BFu0c_BFu16ll_F()
{
  {
    init_simple_test("BFu0c_BFu16ll_F");
    static STRUCT_IF_C BFu0c_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_F, BFu0c_BFu16ll_F)
//============================================================================


struct  BFu0c_BFu16ll_I  {
  unsigned char  :0;
  __tsu64 v1:16;
  int v2;
};
//SIG(1 BFu0c_BFu16ll_I) C1{ Fc:0 FL:16 Fi}



static void Test_BFu0c_BFu16ll_I()
{
  {
    init_simple_test("BFu0c_BFu16ll_I");
    static STRUCT_IF_C BFu0c_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_I, BFu0c_BFu16ll_I)
//============================================================================


struct  BFu0c_BFu16ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:16;
  int *v2;
};
//SIG(1 BFu0c_BFu16ll_Ip) C1{ Fc:0 FL:16 Fp}



static void Test_BFu0c_BFu16ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu16ll_Ip");
    static STRUCT_IF_C BFu0c_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Ip, BFu0c_BFu16ll_Ip)
//============================================================================


struct  BFu0c_BFu16ll_L  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu16ll_L) C1{ Fc:0 FL:16 FL}



static void Test_BFu0c_BFu16ll_L()
{
  {
    init_simple_test("BFu0c_BFu16ll_L");
    static STRUCT_IF_C BFu0c_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_L, BFu0c_BFu16ll_L)
//============================================================================


struct  BFu0c_BFu16ll_S  {
  unsigned char  :0;
  __tsu64 v1:16;
  short v2;
};
//SIG(1 BFu0c_BFu16ll_S) C1{ Fc:0 FL:16 Fs}



static void Test_BFu0c_BFu16ll_S()
{
  {
    init_simple_test("BFu0c_BFu16ll_S");
    static STRUCT_IF_C BFu0c_BFu16ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_S, BFu0c_BFu16ll_S)
//============================================================================


struct  BFu0c_BFu16ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu16ll_Uc) C1{ Fc:0 FL:16 Fc}



static void Test_BFu0c_BFu16ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu16ll_Uc");
    static STRUCT_IF_C BFu0c_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Uc, BFu0c_BFu16ll_Uc)
//============================================================================


struct  BFu0c_BFu16ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu16ll_Ui) C1{ Fc:0 FL:16 Fi}



static void Test_BFu0c_BFu16ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu16ll_Ui");
    static STRUCT_IF_C BFu0c_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Ui, BFu0c_BFu16ll_Ui)
//============================================================================


struct  BFu0c_BFu16ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:16;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu16ll_Ul) C1{ Fc:0 FL:16 FL}



static void Test_BFu0c_BFu16ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu16ll_Ul");
    static STRUCT_IF_C BFu0c_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Ul, BFu0c_BFu16ll_Ul)
//============================================================================


struct  BFu0c_BFu16ll_Us  {
  unsigned char  :0;
  __tsu64 v1:16;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu16ll_Us) C1{ Fc:0 FL:16 Fs}



static void Test_BFu0c_BFu16ll_Us()
{
  {
    init_simple_test("BFu0c_BFu16ll_Us");
    static STRUCT_IF_C BFu0c_BFu16ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Us, BFu0c_BFu16ll_Us)
//============================================================================


struct  BFu0c_BFu16ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:16;
  void *v2;
};
//SIG(1 BFu0c_BFu16ll_Vp) C1{ Fc:0 FL:16 Fp}



static void Test_BFu0c_BFu16ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu16ll_Vp");
    static STRUCT_IF_C BFu0c_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16ll_Vp, BFu0c_BFu16ll_Vp)
//============================================================================


struct  BFu0c_BFu16s  {
  unsigned char  :0;
  unsigned short v1:16;
};
//SIG(1 BFu0c_BFu16s) C1{ Fc:0 Fs:16}



static void Test_BFu0c_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu16s");
    static STRUCT_IF_C BFu0c_BFu16s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s, BFu0c_BFu16s)
//============================================================================


struct  BFu0c_BFu16s_BFu0c  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu16s_BFu0c) C1{ Fc:0 Fs:16 Fc:0}



static void Test_BFu0c_BFu16s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu16s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu16s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu0c, BFu0c_BFu16s_BFu0c)
//============================================================================


struct  BFu0c_BFu16s_BFu0i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu16s_BFu0i) C1{ Fc:0 Fs:16 Fi:0}



static void Test_BFu0c_BFu16s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu16s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu0i, BFu0c_BFu16s_BFu0i)
//============================================================================


struct  BFu0c_BFu16s_BFu0ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu16s_BFu0ll) C1{ Fc:0 Fs:16 FL:0}



static void Test_BFu0c_BFu16s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu16s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu0ll, BFu0c_BFu16s_BFu0ll)
//============================================================================


struct  BFu0c_BFu16s_BFu0s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu16s_BFu0s) C1{ Fc:0 Fs:16 Fs:0}



static void Test_BFu0c_BFu16s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu16s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu0s, BFu0c_BFu16s_BFu0s)
//============================================================================


struct  BFu0c_BFu16s_BFu15i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu16s_BFu15i) C1{ Fc:0 Fs:16 Fi:15}



static void Test_BFu0c_BFu16s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu15i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu15i, BFu0c_BFu16s_BFu15i)
//============================================================================


struct  BFu0c_BFu16s_BFu15ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu16s_BFu15ll) C1{ Fc:0 Fs:16 FL:15}



static void Test_BFu0c_BFu16s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu15ll, BFu0c_BFu16s_BFu15ll)
//============================================================================


struct  BFu0c_BFu16s_BFu15s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu16s_BFu15s) C1{ Fc:0 Fs:16 Fs:15}



static void Test_BFu0c_BFu16s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu15s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu15s, BFu0c_BFu16s_BFu15s)
//============================================================================


struct  BFu0c_BFu16s_BFu16i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu16s_BFu16i) C1{ Fc:0 Fs:16 Fi:16}



static void Test_BFu0c_BFu16s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu16i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu16i, BFu0c_BFu16s_BFu16i)
//============================================================================


struct  BFu0c_BFu16s_BFu16ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu16s_BFu16ll) C1{ Fc:0 Fs:16 FL:16}



static void Test_BFu0c_BFu16s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu16ll, BFu0c_BFu16s_BFu16ll)
//============================================================================


struct  BFu0c_BFu16s_BFu16s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu16s_BFu16s) C1{ Fc:0 Fs:16 Fs:16}



static void Test_BFu0c_BFu16s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu16s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu16s, BFu0c_BFu16s_BFu16s)
//============================================================================


struct  BFu0c_BFu16s_BFu17i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu16s_BFu17i) C1{ Fc:0 Fs:16 Fi:17}



static void Test_BFu0c_BFu16s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu17i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu17i, BFu0c_BFu16s_BFu17i)
//============================================================================


struct  BFu0c_BFu16s_BFu17ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu16s_BFu17ll) C1{ Fc:0 Fs:16 FL:17}



static void Test_BFu0c_BFu16s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0c_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu17ll, BFu0c_BFu16s_BFu17ll)
//============================================================================


struct  BFu0c_BFu16s_BFu1c  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu16s_BFu1c) C1{ Fc:0 Fs:16 Fc:1}



static void Test_BFu0c_BFu16s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu1c");
    static STRUCT_IF_C BFu0c_BFu16s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu1c, BFu0c_BFu16s_BFu1c)
//============================================================================


struct  BFu0c_BFu16s_BFu1i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu16s_BFu1i) C1{ Fc:0 Fs:16 Fi:1}



static void Test_BFu0c_BFu16s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu1i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu1i, BFu0c_BFu16s_BFu1i)
//============================================================================


struct  BFu0c_BFu16s_BFu1ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu16s_BFu1ll) C1{ Fc:0 Fs:16 FL:1}



static void Test_BFu0c_BFu16s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu1ll, BFu0c_BFu16s_BFu1ll)
//============================================================================


struct  BFu0c_BFu16s_BFu1s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu16s_BFu1s) C1{ Fc:0 Fs:16 Fs:1}



static void Test_BFu0c_BFu16s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu1s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0c_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu1s, BFu0c_BFu16s_BFu1s)
//============================================================================


struct  BFu0c_BFu16s_BFu31i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu16s_BFu31i) C1{ Fc:0 Fs:16 Fi:31}



static void Test_BFu0c_BFu16s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu31i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu31i, BFu0c_BFu16s_BFu31i)
//============================================================================


struct  BFu0c_BFu16s_BFu31ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu16s_BFu31ll) C1{ Fc:0 Fs:16 FL:31}



static void Test_BFu0c_BFu16s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0c_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu31ll, BFu0c_BFu16s_BFu31ll)
//============================================================================


struct  BFu0c_BFu16s_BFu32i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu16s_BFu32i) C1{ Fc:0 Fs:16 Fi:32}



static void Test_BFu0c_BFu16s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu32i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu32i, BFu0c_BFu16s_BFu32i)
//============================================================================


struct  BFu0c_BFu16s_BFu32ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu16s_BFu32ll) C1{ Fc:0 Fs:16 FL:32}



static void Test_BFu0c_BFu16s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0c_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu32ll, BFu0c_BFu16s_BFu32ll)
//============================================================================


struct  BFu0c_BFu16s_BFu33  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu16s_BFu33) C1{ Fc:0 Fs:16 FL:33}



static void Test_BFu0c_BFu16s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu33");
    static STRUCT_IF_C BFu0c_BFu16s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0c_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu33, BFu0c_BFu16s_BFu33)
//============================================================================


struct  BFu0c_BFu16s_BFu7c  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu16s_BFu7c) C1{ Fc:0 Fs:16 Fc:7}



static void Test_BFu0c_BFu16s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu7c");
    static STRUCT_IF_C BFu0c_BFu16s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu7c, BFu0c_BFu16s_BFu7c)
//============================================================================


struct  BFu0c_BFu16s_BFu7i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu16s_BFu7i) C1{ Fc:0 Fs:16 Fi:7}



static void Test_BFu0c_BFu16s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu7i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu7i, BFu0c_BFu16s_BFu7i)
//============================================================================


struct  BFu0c_BFu16s_BFu7ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu16s_BFu7ll) C1{ Fc:0 Fs:16 FL:7}



static void Test_BFu0c_BFu16s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu7ll, BFu0c_BFu16s_BFu7ll)
//============================================================================


struct  BFu0c_BFu16s_BFu7s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu16s_BFu7s) C1{ Fc:0 Fs:16 Fs:7}



static void Test_BFu0c_BFu16s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu7s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0c_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu7s, BFu0c_BFu16s_BFu7s)
//============================================================================


struct  BFu0c_BFu16s_BFu8c  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu16s_BFu8c) C1{ Fc:0 Fs:16 Fc:8}



static void Test_BFu0c_BFu16s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu8c");
    static STRUCT_IF_C BFu0c_BFu16s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu8c, BFu0c_BFu16s_BFu8c)
//============================================================================


struct  BFu0c_BFu16s_BFu8i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu16s_BFu8i) C1{ Fc:0 Fs:16 Fi:8}



static void Test_BFu0c_BFu16s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu8i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu8i, BFu0c_BFu16s_BFu8i)
//============================================================================


struct  BFu0c_BFu16s_BFu8ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu16s_BFu8ll) C1{ Fc:0 Fs:16 FL:8}



static void Test_BFu0c_BFu16s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu8ll, BFu0c_BFu16s_BFu8ll)
//============================================================================


struct  BFu0c_BFu16s_BFu8s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu16s_BFu8s) C1{ Fc:0 Fs:16 Fs:8}



static void Test_BFu0c_BFu16s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu8s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu8s, BFu0c_BFu16s_BFu8s)
//============================================================================


struct  BFu0c_BFu16s_BFu9i  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu16s_BFu9i) C1{ Fc:0 Fs:16 Fi:9}



static void Test_BFu0c_BFu16s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu9i");
    static STRUCT_IF_C BFu0c_BFu16s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu9i, BFu0c_BFu16s_BFu9i)
//============================================================================


struct  BFu0c_BFu16s_BFu9ll  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu16s_BFu9ll) C1{ Fc:0 Fs:16 FL:9}



static void Test_BFu0c_BFu16s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu16s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu9ll, BFu0c_BFu16s_BFu9ll)
//============================================================================


struct  BFu0c_BFu16s_BFu9s  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu16s_BFu9s) C1{ Fc:0 Fs:16 Fs:9}



static void Test_BFu0c_BFu16s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu16s_BFu9s");
    static STRUCT_IF_C BFu0c_BFu16s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_BFu9s, BFu0c_BFu16s_BFu9s)
//============================================================================


struct  BFu0c_BFu16s_C  {
  unsigned char  :0;
  unsigned short v1:16;
  char v2;
};
//SIG(1 BFu0c_BFu16s_C) C1{ Fc:0 Fs:16 Fc}



static void Test_BFu0c_BFu16s_C()
{
  {
    init_simple_test("BFu0c_BFu16s_C");
    static STRUCT_IF_C BFu0c_BFu16s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_C, BFu0c_BFu16s_C)
//============================================================================


struct  BFu0c_BFu16s_D  {
  unsigned char  :0;
  unsigned short v1:16;
  double v2;
};
//SIG(1 BFu0c_BFu16s_D) C1{ Fc:0 Fs:16 FL}



static void Test_BFu0c_BFu16s_D()
{
  {
    init_simple_test("BFu0c_BFu16s_D");
    static STRUCT_IF_C BFu0c_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_D, BFu0c_BFu16s_D)
//============================================================================


struct  BFu0c_BFu16s_F  {
  unsigned char  :0;
  unsigned short v1:16;
  float v2;
};
//SIG(1 BFu0c_BFu16s_F) C1{ Fc:0 Fs:16 Fi}



static void Test_BFu0c_BFu16s_F()
{
  {
    init_simple_test("BFu0c_BFu16s_F");
    static STRUCT_IF_C BFu0c_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_F, BFu0c_BFu16s_F)
//============================================================================


struct  BFu0c_BFu16s_I  {
  unsigned char  :0;
  unsigned short v1:16;
  int v2;
};
//SIG(1 BFu0c_BFu16s_I) C1{ Fc:0 Fs:16 Fi}



static void Test_BFu0c_BFu16s_I()
{
  {
    init_simple_test("BFu0c_BFu16s_I");
    static STRUCT_IF_C BFu0c_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_I, BFu0c_BFu16s_I)
//============================================================================


struct  BFu0c_BFu16s_Ip  {
  unsigned char  :0;
  unsigned short v1:16;
  int *v2;
};
//SIG(1 BFu0c_BFu16s_Ip) C1{ Fc:0 Fs:16 Fp}



static void Test_BFu0c_BFu16s_Ip()
{
  {
    init_simple_test("BFu0c_BFu16s_Ip");
    static STRUCT_IF_C BFu0c_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Ip, BFu0c_BFu16s_Ip)
//============================================================================


struct  BFu0c_BFu16s_L  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu16s_L) C1{ Fc:0 Fs:16 FL}



static void Test_BFu0c_BFu16s_L()
{
  {
    init_simple_test("BFu0c_BFu16s_L");
    static STRUCT_IF_C BFu0c_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_L, BFu0c_BFu16s_L)
//============================================================================


struct  BFu0c_BFu16s_S  {
  unsigned char  :0;
  unsigned short v1:16;
  short v2;
};
//SIG(1 BFu0c_BFu16s_S) C1{ Fc:0 Fs:16 Fs}



static void Test_BFu0c_BFu16s_S()
{
  {
    init_simple_test("BFu0c_BFu16s_S");
    static STRUCT_IF_C BFu0c_BFu16s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_S, BFu0c_BFu16s_S)
//============================================================================


struct  BFu0c_BFu16s_Uc  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu16s_Uc) C1{ Fc:0 Fs:16 Fc}



static void Test_BFu0c_BFu16s_Uc()
{
  {
    init_simple_test("BFu0c_BFu16s_Uc");
    static STRUCT_IF_C BFu0c_BFu16s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Uc, BFu0c_BFu16s_Uc)
//============================================================================


struct  BFu0c_BFu16s_Ui  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu16s_Ui) C1{ Fc:0 Fs:16 Fi}



static void Test_BFu0c_BFu16s_Ui()
{
  {
    init_simple_test("BFu0c_BFu16s_Ui");
    static STRUCT_IF_C BFu0c_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu16s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu16s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Ui, BFu0c_BFu16s_Ui)
//============================================================================


struct  BFu0c_BFu16s_Ul  {
  unsigned char  :0;
  unsigned short v1:16;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu16s_Ul) C1{ Fc:0 Fs:16 FL}



static void Test_BFu0c_BFu16s_Ul()
{
  {
    init_simple_test("BFu0c_BFu16s_Ul");
    static STRUCT_IF_C BFu0c_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Ul, BFu0c_BFu16s_Ul)
//============================================================================


struct  BFu0c_BFu16s_Us  {
  unsigned char  :0;
  unsigned short v1:16;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu16s_Us) C1{ Fc:0 Fs:16 Fs}



static void Test_BFu0c_BFu16s_Us()
{
  {
    init_simple_test("BFu0c_BFu16s_Us");
    static STRUCT_IF_C BFu0c_BFu16s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu16s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu16s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu16s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Us, BFu0c_BFu16s_Us)
//============================================================================


struct  BFu0c_BFu16s_Vp  {
  unsigned char  :0;
  unsigned short v1:16;
  void *v2;
};
//SIG(1 BFu0c_BFu16s_Vp) C1{ Fc:0 Fs:16 Fp}



static void Test_BFu0c_BFu16s_Vp()
{
  {
    init_simple_test("BFu0c_BFu16s_Vp");
    static STRUCT_IF_C BFu0c_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu16s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu0c_BFu16s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu16s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu16s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu16s_Vp, BFu0c_BFu16s_Vp)
//============================================================================


struct  BFu0c_BFu17i  {
  unsigned char  :0;
  unsigned int v1:17;
};
//SIG(1 BFu0c_BFu17i) C1{ Fc:0 Fi:17}



static void Test_BFu0c_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu17i");
    static STRUCT_IF_C BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i, BFu0c_BFu17i)
//============================================================================


struct  BFu0c_BFu17i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu17i_BFu0c) C1{ Fc:0 Fi:17 Fc:0}



static void Test_BFu0c_BFu17i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu0c, BFu0c_BFu17i_BFu0c)
//============================================================================


struct  BFu0c_BFu17i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu17i_BFu0i) C1{ Fc:0 Fi:17 Fi:0}



static void Test_BFu0c_BFu17i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu0i, BFu0c_BFu17i_BFu0i)
//============================================================================


struct  BFu0c_BFu17i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu17i_BFu0ll) C1{ Fc:0 Fi:17 FL:0}



static void Test_BFu0c_BFu17i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu17i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu0ll, BFu0c_BFu17i_BFu0ll)
//============================================================================


struct  BFu0c_BFu17i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu17i_BFu0s) C1{ Fc:0 Fi:17 Fs:0}



static void Test_BFu0c_BFu17i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu0s, BFu0c_BFu17i_BFu0s)
//============================================================================


struct  BFu0c_BFu17i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu17i_BFu15i) C1{ Fc:0 Fi:17 Fi:15}



static void Test_BFu0c_BFu17i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu0c_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu15i, BFu0c_BFu17i_BFu15i)
//============================================================================


struct  BFu0c_BFu17i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu17i_BFu15ll) C1{ Fc:0 Fi:17 FL:15}



static void Test_BFu0c_BFu17i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu0c_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu15ll, BFu0c_BFu17i_BFu15ll)
//============================================================================


struct  BFu0c_BFu17i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu17i_BFu15s) C1{ Fc:0 Fi:17 Fs:15}



static void Test_BFu0c_BFu17i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu0c_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu15s, BFu0c_BFu17i_BFu15s)
//============================================================================


struct  BFu0c_BFu17i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu17i_BFu16i) C1{ Fc:0 Fi:17 Fi:16}



static void Test_BFu0c_BFu17i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu16i, BFu0c_BFu17i_BFu16i)
//============================================================================


struct  BFu0c_BFu17i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu17i_BFu16ll) C1{ Fc:0 Fi:17 FL:16}



static void Test_BFu0c_BFu17i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu0c_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu16ll, BFu0c_BFu17i_BFu16ll)
//============================================================================


struct  BFu0c_BFu17i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu17i_BFu16s) C1{ Fc:0 Fi:17 Fs:16}



static void Test_BFu0c_BFu17i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu16s, BFu0c_BFu17i_BFu16s)
//============================================================================


struct  BFu0c_BFu17i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu17i_BFu17i) C1{ Fc:0 Fi:17 Fi:17}



static void Test_BFu0c_BFu17i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu17i, BFu0c_BFu17i_BFu17i)
//============================================================================


struct  BFu0c_BFu17i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu17i_BFu17ll) C1{ Fc:0 Fi:17 FL:17}



static void Test_BFu0c_BFu17i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu0c_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu17ll, BFu0c_BFu17i_BFu17ll)
//============================================================================


struct  BFu0c_BFu17i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu17i_BFu1c) C1{ Fc:0 Fi:17 Fc:1}



static void Test_BFu0c_BFu17i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu1c, BFu0c_BFu17i_BFu1c)
//============================================================================


struct  BFu0c_BFu17i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu17i_BFu1i) C1{ Fc:0 Fi:17 Fi:1}



static void Test_BFu0c_BFu17i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu1i, BFu0c_BFu17i_BFu1i)
//============================================================================


struct  BFu0c_BFu17i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu17i_BFu1ll) C1{ Fc:0 Fi:17 FL:1}



static void Test_BFu0c_BFu17i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu1ll, BFu0c_BFu17i_BFu1ll)
//============================================================================


struct  BFu0c_BFu17i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu17i_BFu1s) C1{ Fc:0 Fi:17 Fs:1}



static void Test_BFu0c_BFu17i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu1s, BFu0c_BFu17i_BFu1s)
//============================================================================


struct  BFu0c_BFu17i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu17i_BFu31i) C1{ Fc:0 Fi:17 Fi:31}



static void Test_BFu0c_BFu17i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu31i, BFu0c_BFu17i_BFu31i)
//============================================================================


struct  BFu0c_BFu17i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu17i_BFu31ll) C1{ Fc:0 Fi:17 FL:31}



static void Test_BFu0c_BFu17i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu0c_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu31ll, BFu0c_BFu17i_BFu31ll)
//============================================================================


struct  BFu0c_BFu17i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu17i_BFu32i) C1{ Fc:0 Fi:17 Fi:32}



static void Test_BFu0c_BFu17i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu32i, BFu0c_BFu17i_BFu32i)
//============================================================================


struct  BFu0c_BFu17i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu17i_BFu32ll) C1{ Fc:0 Fi:17 FL:32}



static void Test_BFu0c_BFu17i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu0c_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu32ll, BFu0c_BFu17i_BFu32ll)
//============================================================================


struct  BFu0c_BFu17i_BFu33  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu17i_BFu33) C1{ Fc:0 Fi:17 FL:33}



static void Test_BFu0c_BFu17i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu33");
    static STRUCT_IF_C BFu0c_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu0c_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu33, BFu0c_BFu17i_BFu33)
//============================================================================


struct  BFu0c_BFu17i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu17i_BFu7c) C1{ Fc:0 Fi:17 Fc:7}



static void Test_BFu0c_BFu17i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu7c, BFu0c_BFu17i_BFu7c)
//============================================================================


struct  BFu0c_BFu17i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu17i_BFu7i) C1{ Fc:0 Fi:17 Fi:7}



static void Test_BFu0c_BFu17i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu7i, BFu0c_BFu17i_BFu7i)
//============================================================================


struct  BFu0c_BFu17i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu17i_BFu7ll) C1{ Fc:0 Fi:17 FL:7}



static void Test_BFu0c_BFu17i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu7ll, BFu0c_BFu17i_BFu7ll)
//============================================================================


struct  BFu0c_BFu17i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu17i_BFu7s) C1{ Fc:0 Fi:17 Fs:7}



static void Test_BFu0c_BFu17i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu7s, BFu0c_BFu17i_BFu7s)
//============================================================================


struct  BFu0c_BFu17i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu17i_BFu8c) C1{ Fc:0 Fi:17 Fc:8}



static void Test_BFu0c_BFu17i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu17i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu0c_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu8c, BFu0c_BFu17i_BFu8c)
//============================================================================


struct  BFu0c_BFu17i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu17i_BFu8i) C1{ Fc:0 Fi:17 Fi:8}



static void Test_BFu0c_BFu17i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu0c_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu8i, BFu0c_BFu17i_BFu8i)
//============================================================================


struct  BFu0c_BFu17i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu17i_BFu8ll) C1{ Fc:0 Fi:17 FL:8}



static void Test_BFu0c_BFu17i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu0c_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu8ll, BFu0c_BFu17i_BFu8ll)
//============================================================================


struct  BFu0c_BFu17i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu17i_BFu8s) C1{ Fc:0 Fi:17 Fs:8}



static void Test_BFu0c_BFu17i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu0c_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu8s, BFu0c_BFu17i_BFu8s)
//============================================================================


struct  BFu0c_BFu17i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu17i_BFu9i) C1{ Fc:0 Fi:17 Fi:9}



static void Test_BFu0c_BFu17i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu17i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu0c_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu9i, BFu0c_BFu17i_BFu9i)
//============================================================================


struct  BFu0c_BFu17i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu17i_BFu9ll) C1{ Fc:0 Fi:17 FL:9}



static void Test_BFu0c_BFu17i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu17i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu0c_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu9ll, BFu0c_BFu17i_BFu9ll)
//============================================================================


struct  BFu0c_BFu17i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu17i_BFu9s) C1{ Fc:0 Fi:17 Fs:9}



static void Test_BFu0c_BFu17i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu17i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu17i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu0c_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_BFu9s, BFu0c_BFu17i_BFu9s)
//============================================================================


struct  BFu0c_BFu17i_C  {
  unsigned char  :0;
  unsigned int v1:17;
  char v2;
};
//SIG(1 BFu0c_BFu17i_C) C1{ Fc:0 Fi:17 Fc}



static void Test_BFu0c_BFu17i_C()
{
  {
    init_simple_test("BFu0c_BFu17i_C");
    static STRUCT_IF_C BFu0c_BFu17i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_C");
    check_field_offset(lv, v2, 3, "BFu0c_BFu17i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_C, BFu0c_BFu17i_C)
//============================================================================


struct  BFu0c_BFu17i_D  {
  unsigned char  :0;
  unsigned int v1:17;
  double v2;
};
//SIG(1 BFu0c_BFu17i_D) C1{ Fc:0 Fi:17 FL}



static void Test_BFu0c_BFu17i_D()
{
  {
    init_simple_test("BFu0c_BFu17i_D");
    static STRUCT_IF_C BFu0c_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_D, BFu0c_BFu17i_D)
//============================================================================


struct  BFu0c_BFu17i_F  {
  unsigned char  :0;
  unsigned int v1:17;
  float v2;
};
//SIG(1 BFu0c_BFu17i_F) C1{ Fc:0 Fi:17 Fi}



static void Test_BFu0c_BFu17i_F()
{
  {
    init_simple_test("BFu0c_BFu17i_F");
    static STRUCT_IF_C BFu0c_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_F, BFu0c_BFu17i_F)
//============================================================================


struct  BFu0c_BFu17i_I  {
  unsigned char  :0;
  unsigned int v1:17;
  int v2;
};
//SIG(1 BFu0c_BFu17i_I) C1{ Fc:0 Fi:17 Fi}



static void Test_BFu0c_BFu17i_I()
{
  {
    init_simple_test("BFu0c_BFu17i_I");
    static STRUCT_IF_C BFu0c_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_I, BFu0c_BFu17i_I)
//============================================================================


struct  BFu0c_BFu17i_Ip  {
  unsigned char  :0;
  unsigned int v1:17;
  int *v2;
};
//SIG(1 BFu0c_BFu17i_Ip) C1{ Fc:0 Fi:17 Fp}



static void Test_BFu0c_BFu17i_Ip()
{
  {
    init_simple_test("BFu0c_BFu17i_Ip");
    static STRUCT_IF_C BFu0c_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Ip, BFu0c_BFu17i_Ip)
//============================================================================


struct  BFu0c_BFu17i_L  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu17i_L) C1{ Fc:0 Fi:17 FL}



static void Test_BFu0c_BFu17i_L()
{
  {
    init_simple_test("BFu0c_BFu17i_L");
    static STRUCT_IF_C BFu0c_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_L, BFu0c_BFu17i_L)
//============================================================================


struct  BFu0c_BFu17i_S  {
  unsigned char  :0;
  unsigned int v1:17;
  short v2;
};
//SIG(1 BFu0c_BFu17i_S) C1{ Fc:0 Fi:17 Fs}



static void Test_BFu0c_BFu17i_S()
{
  {
    init_simple_test("BFu0c_BFu17i_S");
    static STRUCT_IF_C BFu0c_BFu17i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_S");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_S, BFu0c_BFu17i_S)
//============================================================================


struct  BFu0c_BFu17i_Uc  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu17i_Uc) C1{ Fc:0 Fi:17 Fc}



static void Test_BFu0c_BFu17i_Uc()
{
  {
    init_simple_test("BFu0c_BFu17i_Uc");
    static STRUCT_IF_C BFu0c_BFu17i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Uc");
    check_field_offset(lv, v2, 3, "BFu0c_BFu17i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Uc, BFu0c_BFu17i_Uc)
//============================================================================


struct  BFu0c_BFu17i_Ui  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu17i_Ui) C1{ Fc:0 Fi:17 Fi}



static void Test_BFu0c_BFu17i_Ui()
{
  {
    init_simple_test("BFu0c_BFu17i_Ui");
    static STRUCT_IF_C BFu0c_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Ui, BFu0c_BFu17i_Ui)
//============================================================================


struct  BFu0c_BFu17i_Ul  {
  unsigned char  :0;
  unsigned int v1:17;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu17i_Ul) C1{ Fc:0 Fi:17 FL}



static void Test_BFu0c_BFu17i_Ul()
{
  {
    init_simple_test("BFu0c_BFu17i_Ul");
    static STRUCT_IF_C BFu0c_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Ul, BFu0c_BFu17i_Ul)
//============================================================================


struct  BFu0c_BFu17i_Us  {
  unsigned char  :0;
  unsigned int v1:17;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu17i_Us) C1{ Fc:0 Fi:17 Fs}



static void Test_BFu0c_BFu17i_Us()
{
  {
    init_simple_test("BFu0c_BFu17i_Us");
    static STRUCT_IF_C BFu0c_BFu17i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu17i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Us");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Us, BFu0c_BFu17i_Us)
//============================================================================


struct  BFu0c_BFu17i_Vp  {
  unsigned char  :0;
  unsigned int v1:17;
  void *v2;
};
//SIG(1 BFu0c_BFu17i_Vp) C1{ Fc:0 Fi:17 Fp}



static void Test_BFu0c_BFu17i_Vp()
{
  {
    init_simple_test("BFu0c_BFu17i_Vp");
    static STRUCT_IF_C BFu0c_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17i_Vp, BFu0c_BFu17i_Vp)
//============================================================================


struct  BFu0c_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:17;
};
//SIG(1 BFu0c_BFu17ll) C1{ Fc:0 FL:17}



static void Test_BFu0c_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll, BFu0c_BFu17ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu17ll_BFu0c) C1{ Fc:0 FL:17 Fc:0}



static void Test_BFu0c_BFu17ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu0c, BFu0c_BFu17ll_BFu0c)
//============================================================================


struct  BFu0c_BFu17ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu17ll_BFu0i) C1{ Fc:0 FL:17 Fi:0}



static void Test_BFu0c_BFu17ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu0i, BFu0c_BFu17ll_BFu0i)
//============================================================================


struct  BFu0c_BFu17ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu17ll_BFu0ll) C1{ Fc:0 FL:17 FL:0}



static void Test_BFu0c_BFu17ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu0ll, BFu0c_BFu17ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu17ll_BFu0s) C1{ Fc:0 FL:17 Fs:0}



static void Test_BFu0c_BFu17ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu0s, BFu0c_BFu17ll_BFu0s)
//============================================================================


struct  BFu0c_BFu17ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu17ll_BFu15i) C1{ Fc:0 FL:17 Fi:15}



static void Test_BFu0c_BFu17ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu0c_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu15i, BFu0c_BFu17ll_BFu15i)
//============================================================================


struct  BFu0c_BFu17ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu17ll_BFu15ll) C1{ Fc:0 FL:17 FL:15}



static void Test_BFu0c_BFu17ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu0c_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu15ll, BFu0c_BFu17ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu17ll_BFu15s) C1{ Fc:0 FL:17 Fs:15}



static void Test_BFu0c_BFu17ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu0c_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu15s, BFu0c_BFu17ll_BFu15s)
//============================================================================


struct  BFu0c_BFu17ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu17ll_BFu16i) C1{ Fc:0 FL:17 Fi:16}



static void Test_BFu0c_BFu17ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu16i, BFu0c_BFu17ll_BFu16i)
//============================================================================


struct  BFu0c_BFu17ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu17ll_BFu16ll) C1{ Fc:0 FL:17 FL:16}



static void Test_BFu0c_BFu17ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu0c_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu16ll, BFu0c_BFu17ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu17ll_BFu16s) C1{ Fc:0 FL:17 Fs:16}



static void Test_BFu0c_BFu17ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu16s, BFu0c_BFu17ll_BFu16s)
//============================================================================


struct  BFu0c_BFu17ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu17ll_BFu17i) C1{ Fc:0 FL:17 Fi:17}



static void Test_BFu0c_BFu17ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu17i, BFu0c_BFu17ll_BFu17i)
//============================================================================


struct  BFu0c_BFu17ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu17ll_BFu17ll) C1{ Fc:0 FL:17 FL:17}



static void Test_BFu0c_BFu17ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu0c_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu17ll, BFu0c_BFu17ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu17ll_BFu1c) C1{ Fc:0 FL:17 Fc:1}



static void Test_BFu0c_BFu17ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu1c, BFu0c_BFu17ll_BFu1c)
//============================================================================


struct  BFu0c_BFu17ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu17ll_BFu1i) C1{ Fc:0 FL:17 Fi:1}



static void Test_BFu0c_BFu17ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu1i, BFu0c_BFu17ll_BFu1i)
//============================================================================


struct  BFu0c_BFu17ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu17ll_BFu1ll) C1{ Fc:0 FL:17 FL:1}



static void Test_BFu0c_BFu17ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu1ll, BFu0c_BFu17ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu17ll_BFu1s) C1{ Fc:0 FL:17 Fs:1}



static void Test_BFu0c_BFu17ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu0c_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu1s, BFu0c_BFu17ll_BFu1s)
//============================================================================


struct  BFu0c_BFu17ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu17ll_BFu31i) C1{ Fc:0 FL:17 Fi:31}



static void Test_BFu0c_BFu17ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu31i, BFu0c_BFu17ll_BFu31i)
//============================================================================


struct  BFu0c_BFu17ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu17ll_BFu31ll) C1{ Fc:0 FL:17 FL:31}



static void Test_BFu0c_BFu17ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu0c_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu31ll, BFu0c_BFu17ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu17ll_BFu32i) C1{ Fc:0 FL:17 Fi:32}



static void Test_BFu0c_BFu17ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu32i, BFu0c_BFu17ll_BFu32i)
//============================================================================


struct  BFu0c_BFu17ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu17ll_BFu32ll) C1{ Fc:0 FL:17 FL:32}



static void Test_BFu0c_BFu17ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu0c_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu32ll, BFu0c_BFu17ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu17ll_BFu33) C1{ Fc:0 FL:17 FL:33}



static void Test_BFu0c_BFu17ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu0c_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu33, BFu0c_BFu17ll_BFu33)
//============================================================================


struct  BFu0c_BFu17ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu17ll_BFu7c) C1{ Fc:0 FL:17 Fc:7}



static void Test_BFu0c_BFu17ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu7c, BFu0c_BFu17ll_BFu7c)
//============================================================================


struct  BFu0c_BFu17ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu17ll_BFu7i) C1{ Fc:0 FL:17 Fi:7}



static void Test_BFu0c_BFu17ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu7i, BFu0c_BFu17ll_BFu7i)
//============================================================================


struct  BFu0c_BFu17ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu17ll_BFu7ll) C1{ Fc:0 FL:17 FL:7}



static void Test_BFu0c_BFu17ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu7ll, BFu0c_BFu17ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu17ll_BFu7s) C1{ Fc:0 FL:17 Fs:7}



static void Test_BFu0c_BFu17ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu0c_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu7s, BFu0c_BFu17ll_BFu7s)
//============================================================================


struct  BFu0c_BFu17ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu17ll_BFu8c) C1{ Fc:0 FL:17 Fc:8}



static void Test_BFu0c_BFu17ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu0c_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu8c, BFu0c_BFu17ll_BFu8c)
//============================================================================


struct  BFu0c_BFu17ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu17ll_BFu8i) C1{ Fc:0 FL:17 Fi:8}



static void Test_BFu0c_BFu17ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu0c_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu8i, BFu0c_BFu17ll_BFu8i)
//============================================================================


struct  BFu0c_BFu17ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu17ll_BFu8ll) C1{ Fc:0 FL:17 FL:8}



static void Test_BFu0c_BFu17ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu0c_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu8ll, BFu0c_BFu17ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu17ll_BFu8s) C1{ Fc:0 FL:17 Fs:8}



static void Test_BFu0c_BFu17ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu0c_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu8s, BFu0c_BFu17ll_BFu8s)
//============================================================================


struct  BFu0c_BFu17ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu17ll_BFu9i) C1{ Fc:0 FL:17 Fi:9}



static void Test_BFu0c_BFu17ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu0c_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu9i, BFu0c_BFu17ll_BFu9i)
//============================================================================


struct  BFu0c_BFu17ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu17ll_BFu9ll) C1{ Fc:0 FL:17 FL:9}



static void Test_BFu0c_BFu17ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu0c_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu9ll, BFu0c_BFu17ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu17ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu17ll_BFu9s) C1{ Fc:0 FL:17 Fs:9}



static void Test_BFu0c_BFu17ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu17ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu0c_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_BFu9s, BFu0c_BFu17ll_BFu9s)
//============================================================================


struct  BFu0c_BFu17ll_C  {
  unsigned char  :0;
  __tsu64 v1:17;
  char v2;
};
//SIG(1 BFu0c_BFu17ll_C) C1{ Fc:0 FL:17 Fc}



static void Test_BFu0c_BFu17ll_C()
{
  {
    init_simple_test("BFu0c_BFu17ll_C");
    static STRUCT_IF_C BFu0c_BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_C");
    check_field_offset(lv, v2, 3, "BFu0c_BFu17ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_C, BFu0c_BFu17ll_C)
//============================================================================


struct  BFu0c_BFu17ll_D  {
  unsigned char  :0;
  __tsu64 v1:17;
  double v2;
};
//SIG(1 BFu0c_BFu17ll_D) C1{ Fc:0 FL:17 FL}



static void Test_BFu0c_BFu17ll_D()
{
  {
    init_simple_test("BFu0c_BFu17ll_D");
    static STRUCT_IF_C BFu0c_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_D, BFu0c_BFu17ll_D)
//============================================================================


struct  BFu0c_BFu17ll_F  {
  unsigned char  :0;
  __tsu64 v1:17;
  float v2;
};
//SIG(1 BFu0c_BFu17ll_F) C1{ Fc:0 FL:17 Fi}



static void Test_BFu0c_BFu17ll_F()
{
  {
    init_simple_test("BFu0c_BFu17ll_F");
    static STRUCT_IF_C BFu0c_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_F, BFu0c_BFu17ll_F)
//============================================================================


struct  BFu0c_BFu17ll_I  {
  unsigned char  :0;
  __tsu64 v1:17;
  int v2;
};
//SIG(1 BFu0c_BFu17ll_I) C1{ Fc:0 FL:17 Fi}



static void Test_BFu0c_BFu17ll_I()
{
  {
    init_simple_test("BFu0c_BFu17ll_I");
    static STRUCT_IF_C BFu0c_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_I, BFu0c_BFu17ll_I)
//============================================================================


struct  BFu0c_BFu17ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:17;
  int *v2;
};
//SIG(1 BFu0c_BFu17ll_Ip) C1{ Fc:0 FL:17 Fp}



static void Test_BFu0c_BFu17ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu17ll_Ip");
    static STRUCT_IF_C BFu0c_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Ip, BFu0c_BFu17ll_Ip)
//============================================================================


struct  BFu0c_BFu17ll_L  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu17ll_L) C1{ Fc:0 FL:17 FL}



static void Test_BFu0c_BFu17ll_L()
{
  {
    init_simple_test("BFu0c_BFu17ll_L");
    static STRUCT_IF_C BFu0c_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_L, BFu0c_BFu17ll_L)
//============================================================================


struct  BFu0c_BFu17ll_S  {
  unsigned char  :0;
  __tsu64 v1:17;
  short v2;
};
//SIG(1 BFu0c_BFu17ll_S) C1{ Fc:0 FL:17 Fs}



static void Test_BFu0c_BFu17ll_S()
{
  {
    init_simple_test("BFu0c_BFu17ll_S");
    static STRUCT_IF_C BFu0c_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_S");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_S, BFu0c_BFu17ll_S)
//============================================================================


struct  BFu0c_BFu17ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu17ll_Uc) C1{ Fc:0 FL:17 Fc}



static void Test_BFu0c_BFu17ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu17ll_Uc");
    static STRUCT_IF_C BFu0c_BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Uc");
    check_field_offset(lv, v2, 3, "BFu0c_BFu17ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Uc, BFu0c_BFu17ll_Uc)
//============================================================================


struct  BFu0c_BFu17ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu17ll_Ui) C1{ Fc:0 FL:17 Fi}



static void Test_BFu0c_BFu17ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu17ll_Ui");
    static STRUCT_IF_C BFu0c_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Ui, BFu0c_BFu17ll_Ui)
//============================================================================


struct  BFu0c_BFu17ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:17;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu17ll_Ul) C1{ Fc:0 FL:17 FL}



static void Test_BFu0c_BFu17ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu17ll_Ul");
    static STRUCT_IF_C BFu0c_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Ul, BFu0c_BFu17ll_Ul)
//============================================================================


struct  BFu0c_BFu17ll_Us  {
  unsigned char  :0;
  __tsu64 v1:17;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu17ll_Us) C1{ Fc:0 FL:17 Fs}



static void Test_BFu0c_BFu17ll_Us()
{
  {
    init_simple_test("BFu0c_BFu17ll_Us");
    static STRUCT_IF_C BFu0c_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Us");
    check_field_offset(lv, v2, 4, "BFu0c_BFu17ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Us, BFu0c_BFu17ll_Us)
//============================================================================


struct  BFu0c_BFu17ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:17;
  void *v2;
};
//SIG(1 BFu0c_BFu17ll_Vp) C1{ Fc:0 FL:17 Fp}



static void Test_BFu0c_BFu17ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu17ll_Vp");
    static STRUCT_IF_C BFu0c_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu17ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu0c_BFu17ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu17ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu17ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu17ll_Vp, BFu0c_BFu17ll_Vp)
//============================================================================


struct  BFu0c_BFu1c  {
  unsigned char  :0;
  unsigned char v1:1;
};
//SIG(1 BFu0c_BFu1c) C1{ Fc:0 Fc:1}



static void Test_BFu0c_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu1c");
    static STRUCT_IF_C BFu0c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c, BFu0c_BFu1c)
//============================================================================


struct  BFu0c_BFu1c_BFu0c  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu1c_BFu0c) C1{ Fc:0 Fc:1 Fc:0}



static void Test_BFu0c_BFu1c_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu0c");
    static STRUCT_IF_C BFu0c_BFu1c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu0c, BFu0c_BFu1c_BFu0c)
//============================================================================


struct  BFu0c_BFu1c_BFu0i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu1c_BFu0i) C1{ Fc:0 Fc:1 Fi:0}



static void Test_BFu0c_BFu1c_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu0i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu1c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu0i, BFu0c_BFu1c_BFu0i)
//============================================================================


struct  BFu0c_BFu1c_BFu0ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu1c_BFu0ll) C1{ Fc:0 Fc:1 FL:0}



static void Test_BFu0c_BFu1c_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu1c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu0ll, BFu0c_BFu1c_BFu0ll)
//============================================================================


struct  BFu0c_BFu1c_BFu0s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu1c_BFu0s) C1{ Fc:0 Fc:1 Fs:0}



static void Test_BFu0c_BFu1c_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu0s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu1c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu0s, BFu0c_BFu1c_BFu0s)
//============================================================================


struct  BFu0c_BFu1c_BFu15i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu1c_BFu15i) C1{ Fc:0 Fc:1 Fi:15}



static void Test_BFu0c_BFu1c_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu15i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu15i, BFu0c_BFu1c_BFu15i)
//============================================================================


struct  BFu0c_BFu1c_BFu15ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu1c_BFu15ll) C1{ Fc:0 Fc:1 FL:15}



static void Test_BFu0c_BFu1c_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu15ll, BFu0c_BFu1c_BFu15ll)
//============================================================================


struct  BFu0c_BFu1c_BFu15s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu1c_BFu15s) C1{ Fc:0 Fc:1 Fs:15}



static void Test_BFu0c_BFu1c_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu15s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu15s, BFu0c_BFu1c_BFu15s)
//============================================================================


struct  BFu0c_BFu1c_BFu16i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu1c_BFu16i) C1{ Fc:0 Fc:1 Fi:16}



static void Test_BFu0c_BFu1c_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu16i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu16i, BFu0c_BFu1c_BFu16i)
//============================================================================


struct  BFu0c_BFu1c_BFu16ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu1c_BFu16ll) C1{ Fc:0 Fc:1 FL:16}



static void Test_BFu0c_BFu1c_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu16ll, BFu0c_BFu1c_BFu16ll)
//============================================================================


struct  BFu0c_BFu1c_BFu16s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu1c_BFu16s) C1{ Fc:0 Fc:1 Fs:16}



static void Test_BFu0c_BFu1c_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu16s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu1c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu16s, BFu0c_BFu1c_BFu16s)
//============================================================================


struct  BFu0c_BFu1c_BFu17i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu1c_BFu17i) C1{ Fc:0 Fc:1 Fi:17}



static void Test_BFu0c_BFu1c_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu17i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1c_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu17i, BFu0c_BFu1c_BFu17i)
//============================================================================


struct  BFu0c_BFu1c_BFu17ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu1c_BFu17ll) C1{ Fc:0 Fc:1 FL:17}



static void Test_BFu0c_BFu1c_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu17ll, BFu0c_BFu1c_BFu17ll)
//============================================================================


struct  BFu0c_BFu1c_BFu1c  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu1c_BFu1c) C1{ Fc:0 Fc:1 Fc:1}



static void Test_BFu0c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu1c");
    static STRUCT_IF_C BFu0c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu1c, BFu0c_BFu1c_BFu1c)
//============================================================================


struct  BFu0c_BFu1c_BFu1i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu1c_BFu1i) C1{ Fc:0 Fc:1 Fi:1}



static void Test_BFu0c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu1i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu1i, BFu0c_BFu1c_BFu1i)
//============================================================================


struct  BFu0c_BFu1c_BFu1ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu1c_BFu1ll) C1{ Fc:0 Fc:1 FL:1}



static void Test_BFu0c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu1ll, BFu0c_BFu1c_BFu1ll)
//============================================================================


struct  BFu0c_BFu1c_BFu1s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu1c_BFu1s) C1{ Fc:0 Fc:1 Fs:1}



static void Test_BFu0c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu1s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu1s, BFu0c_BFu1c_BFu1s)
//============================================================================


struct  BFu0c_BFu1c_BFu31i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu1c_BFu31i) C1{ Fc:0 Fc:1 Fi:31}



static void Test_BFu0c_BFu1c_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu31i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu31i, BFu0c_BFu1c_BFu31i)
//============================================================================


struct  BFu0c_BFu1c_BFu31ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu1c_BFu31ll) C1{ Fc:0 Fc:1 FL:31}



static void Test_BFu0c_BFu1c_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu31ll, BFu0c_BFu1c_BFu31ll)
//============================================================================


struct  BFu0c_BFu1c_BFu32i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu1c_BFu32i) C1{ Fc:0 Fc:1 Fi:32}



static void Test_BFu0c_BFu1c_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu32i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu32i, BFu0c_BFu1c_BFu32i)
//============================================================================


struct  BFu0c_BFu1c_BFu32ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu1c_BFu32ll) C1{ Fc:0 Fc:1 FL:32}



static void Test_BFu0c_BFu1c_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0c_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu32ll, BFu0c_BFu1c_BFu32ll)
//============================================================================


struct  BFu0c_BFu1c_BFu33  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu1c_BFu33) C1{ Fc:0 Fc:1 FL:33}



static void Test_BFu0c_BFu1c_BFu33()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu33");
    static STRUCT_IF_C BFu0c_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0c_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu33, BFu0c_BFu1c_BFu33)
//============================================================================


struct  BFu0c_BFu1c_BFu7c  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu1c_BFu7c) C1{ Fc:0 Fc:1 Fc:7}



static void Test_BFu0c_BFu1c_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu7c");
    static STRUCT_IF_C BFu0c_BFu1c_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu7c, BFu0c_BFu1c_BFu7c)
//============================================================================


struct  BFu0c_BFu1c_BFu7i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu1c_BFu7i) C1{ Fc:0 Fc:1 Fi:7}



static void Test_BFu0c_BFu1c_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu7i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu7i, BFu0c_BFu1c_BFu7i)
//============================================================================


struct  BFu0c_BFu1c_BFu7ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu1c_BFu7ll) C1{ Fc:0 Fc:1 FL:7}



static void Test_BFu0c_BFu1c_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu7ll, BFu0c_BFu1c_BFu7ll)
//============================================================================


struct  BFu0c_BFu1c_BFu7s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu1c_BFu7s) C1{ Fc:0 Fc:1 Fs:7}



static void Test_BFu0c_BFu1c_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu7s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu7s, BFu0c_BFu1c_BFu7s)
//============================================================================


struct  BFu0c_BFu1c_BFu8c  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu1c_BFu8c) C1{ Fc:0 Fc:1 Fc:8}



static void Test_BFu0c_BFu1c_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu8c");
    static STRUCT_IF_C BFu0c_BFu1c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu8c, BFu0c_BFu1c_BFu8c)
//============================================================================


struct  BFu0c_BFu1c_BFu8i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu1c_BFu8i) C1{ Fc:0 Fc:1 Fi:8}



static void Test_BFu0c_BFu1c_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu8i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu8i, BFu0c_BFu1c_BFu8i)
//============================================================================


struct  BFu0c_BFu1c_BFu8ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu1c_BFu8ll) C1{ Fc:0 Fc:1 FL:8}



static void Test_BFu0c_BFu1c_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu8ll, BFu0c_BFu1c_BFu8ll)
//============================================================================


struct  BFu0c_BFu1c_BFu8s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu1c_BFu8s) C1{ Fc:0 Fc:1 Fs:8}



static void Test_BFu0c_BFu1c_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu8s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu8s, BFu0c_BFu1c_BFu8s)
//============================================================================


struct  BFu0c_BFu1c_BFu9i  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu1c_BFu9i) C1{ Fc:0 Fc:1 Fi:9}



static void Test_BFu0c_BFu1c_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu9i");
    static STRUCT_IF_C BFu0c_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu9i, BFu0c_BFu1c_BFu9i)
//============================================================================


struct  BFu0c_BFu1c_BFu9ll  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu1c_BFu9ll) C1{ Fc:0 Fc:1 FL:9}



static void Test_BFu0c_BFu1c_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu9ll, BFu0c_BFu1c_BFu9ll)
//============================================================================


struct  BFu0c_BFu1c_BFu9s  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu1c_BFu9s) C1{ Fc:0 Fc:1 Fs:9}



static void Test_BFu0c_BFu1c_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu1c_BFu9s");
    static STRUCT_IF_C BFu0c_BFu1c_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_BFu9s, BFu0c_BFu1c_BFu9s)
//============================================================================


struct  BFu0c_BFu1c_C  {
  unsigned char  :0;
  unsigned char v1:1;
  char v2;
};
//SIG(1 BFu0c_BFu1c_C) C1{ Fc:0 Fc:1 Fc}



static void Test_BFu0c_BFu1c_C()
{
  {
    init_simple_test("BFu0c_BFu1c_C");
    static STRUCT_IF_C BFu0c_BFu1c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_C, BFu0c_BFu1c_C)
//============================================================================


struct  BFu0c_BFu1c_D  {
  unsigned char  :0;
  unsigned char v1:1;
  double v2;
};
//SIG(1 BFu0c_BFu1c_D) C1{ Fc:0 Fc:1 FL}



static void Test_BFu0c_BFu1c_D()
{
  {
    init_simple_test("BFu0c_BFu1c_D");
    static STRUCT_IF_C BFu0c_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_D, BFu0c_BFu1c_D)
//============================================================================


struct  BFu0c_BFu1c_F  {
  unsigned char  :0;
  unsigned char v1:1;
  float v2;
};
//SIG(1 BFu0c_BFu1c_F) C1{ Fc:0 Fc:1 Fi}



static void Test_BFu0c_BFu1c_F()
{
  {
    init_simple_test("BFu0c_BFu1c_F");
    static STRUCT_IF_C BFu0c_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_F, BFu0c_BFu1c_F)
//============================================================================


struct  BFu0c_BFu1c_I  {
  unsigned char  :0;
  unsigned char v1:1;
  int v2;
};
//SIG(1 BFu0c_BFu1c_I) C1{ Fc:0 Fc:1 Fi}



static void Test_BFu0c_BFu1c_I()
{
  {
    init_simple_test("BFu0c_BFu1c_I");
    static STRUCT_IF_C BFu0c_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_I, BFu0c_BFu1c_I)
//============================================================================


struct  BFu0c_BFu1c_Ip  {
  unsigned char  :0;
  unsigned char v1:1;
  int *v2;
};
//SIG(1 BFu0c_BFu1c_Ip) C1{ Fc:0 Fc:1 Fp}



static void Test_BFu0c_BFu1c_Ip()
{
  {
    init_simple_test("BFu0c_BFu1c_Ip");
    static STRUCT_IF_C BFu0c_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Ip, BFu0c_BFu1c_Ip)
//============================================================================


struct  BFu0c_BFu1c_L  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu1c_L) C1{ Fc:0 Fc:1 FL}



static void Test_BFu0c_BFu1c_L()
{
  {
    init_simple_test("BFu0c_BFu1c_L");
    static STRUCT_IF_C BFu0c_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_L, BFu0c_BFu1c_L)
//============================================================================


struct  BFu0c_BFu1c_S  {
  unsigned char  :0;
  unsigned char v1:1;
  short v2;
};
//SIG(1 BFu0c_BFu1c_S) C1{ Fc:0 Fc:1 Fs}



static void Test_BFu0c_BFu1c_S()
{
  {
    init_simple_test("BFu0c_BFu1c_S");
    static STRUCT_IF_C BFu0c_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_S, BFu0c_BFu1c_S)
//============================================================================


struct  BFu0c_BFu1c_Uc  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu1c_Uc) C1{ Fc:0 Fc:1 Fc}



static void Test_BFu0c_BFu1c_Uc()
{
  {
    init_simple_test("BFu0c_BFu1c_Uc");
    static STRUCT_IF_C BFu0c_BFu1c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu1c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Uc, BFu0c_BFu1c_Uc)
//============================================================================


struct  BFu0c_BFu1c_Ui  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu1c_Ui) C1{ Fc:0 Fc:1 Fi}



static void Test_BFu0c_BFu1c_Ui()
{
  {
    init_simple_test("BFu0c_BFu1c_Ui");
    static STRUCT_IF_C BFu0c_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Ui, BFu0c_BFu1c_Ui)
//============================================================================


struct  BFu0c_BFu1c_Ul  {
  unsigned char  :0;
  unsigned char v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu1c_Ul) C1{ Fc:0 Fc:1 FL}



static void Test_BFu0c_BFu1c_Ul()
{
  {
    init_simple_test("BFu0c_BFu1c_Ul");
    static STRUCT_IF_C BFu0c_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Ul, BFu0c_BFu1c_Ul)
//============================================================================


struct  BFu0c_BFu1c_Us  {
  unsigned char  :0;
  unsigned char v1:1;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu1c_Us) C1{ Fc:0 Fc:1 Fs}



static void Test_BFu0c_BFu1c_Us()
{
  {
    init_simple_test("BFu0c_BFu1c_Us");
    static STRUCT_IF_C BFu0c_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Us, BFu0c_BFu1c_Us)
//============================================================================


struct  BFu0c_BFu1c_Vp  {
  unsigned char  :0;
  unsigned char v1:1;
  void *v2;
};
//SIG(1 BFu0c_BFu1c_Vp) C1{ Fc:0 Fc:1 Fp}



static void Test_BFu0c_BFu1c_Vp()
{
  {
    init_simple_test("BFu0c_BFu1c_Vp");
    static STRUCT_IF_C BFu0c_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1c_Vp, BFu0c_BFu1c_Vp)
//============================================================================


struct  BFu0c_BFu1i  {
  unsigned char  :0;
  unsigned int v1:1;
};
//SIG(1 BFu0c_BFu1i) C1{ Fc:0 Fi:1}



static void Test_BFu0c_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu1i");
    static STRUCT_IF_C BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i, BFu0c_BFu1i)
//============================================================================


struct  BFu0c_BFu1i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu1i_BFu0c) C1{ Fc:0 Fi:1 Fc:0}



static void Test_BFu0c_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu0c, BFu0c_BFu1i_BFu0c)
//============================================================================


struct  BFu0c_BFu1i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu1i_BFu0i) C1{ Fc:0 Fi:1 Fi:0}



static void Test_BFu0c_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu0i, BFu0c_BFu1i_BFu0i)
//============================================================================


struct  BFu0c_BFu1i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu1i_BFu0ll) C1{ Fc:0 Fi:1 FL:0}



static void Test_BFu0c_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu0ll, BFu0c_BFu1i_BFu0ll)
//============================================================================


struct  BFu0c_BFu1i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu1i_BFu0s) C1{ Fc:0 Fi:1 Fs:0}



static void Test_BFu0c_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu0s, BFu0c_BFu1i_BFu0s)
//============================================================================


struct  BFu0c_BFu1i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu1i_BFu15i) C1{ Fc:0 Fi:1 Fi:15}



static void Test_BFu0c_BFu1i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu15i, BFu0c_BFu1i_BFu15i)
//============================================================================


struct  BFu0c_BFu1i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu1i_BFu15ll) C1{ Fc:0 Fi:1 FL:15}



static void Test_BFu0c_BFu1i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu15ll, BFu0c_BFu1i_BFu15ll)
//============================================================================


struct  BFu0c_BFu1i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu1i_BFu15s) C1{ Fc:0 Fi:1 Fs:15}



static void Test_BFu0c_BFu1i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu15s, BFu0c_BFu1i_BFu15s)
//============================================================================


struct  BFu0c_BFu1i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu1i_BFu16i) C1{ Fc:0 Fi:1 Fi:16}



static void Test_BFu0c_BFu1i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu16i, BFu0c_BFu1i_BFu16i)
//============================================================================


struct  BFu0c_BFu1i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu1i_BFu16ll) C1{ Fc:0 Fi:1 FL:16}



static void Test_BFu0c_BFu1i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu16ll, BFu0c_BFu1i_BFu16ll)
//============================================================================


struct  BFu0c_BFu1i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu1i_BFu16s) C1{ Fc:0 Fi:1 Fs:16}



static void Test_BFu0c_BFu1i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu16s, BFu0c_BFu1i_BFu16s)
//============================================================================


struct  BFu0c_BFu1i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu1i_BFu17i) C1{ Fc:0 Fi:1 Fi:17}



static void Test_BFu0c_BFu1i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu17i, BFu0c_BFu1i_BFu17i)
//============================================================================


struct  BFu0c_BFu1i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu1i_BFu17ll) C1{ Fc:0 Fi:1 FL:17}



static void Test_BFu0c_BFu1i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu17ll, BFu0c_BFu1i_BFu17ll)
//============================================================================


struct  BFu0c_BFu1i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu1i_BFu1c) C1{ Fc:0 Fi:1 Fc:1}



static void Test_BFu0c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu1c, BFu0c_BFu1i_BFu1c)
//============================================================================


struct  BFu0c_BFu1i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu1i_BFu1i) C1{ Fc:0 Fi:1 Fi:1}



static void Test_BFu0c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu1i, BFu0c_BFu1i_BFu1i)
//============================================================================


struct  BFu0c_BFu1i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu1i_BFu1ll) C1{ Fc:0 Fi:1 FL:1}



static void Test_BFu0c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu1ll, BFu0c_BFu1i_BFu1ll)
//============================================================================


struct  BFu0c_BFu1i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu1i_BFu1s) C1{ Fc:0 Fi:1 Fs:1}



static void Test_BFu0c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu1s, BFu0c_BFu1i_BFu1s)
//============================================================================


struct  BFu0c_BFu1i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu1i_BFu31i) C1{ Fc:0 Fi:1 Fi:31}



static void Test_BFu0c_BFu1i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu31i, BFu0c_BFu1i_BFu31i)
//============================================================================


struct  BFu0c_BFu1i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu1i_BFu31ll) C1{ Fc:0 Fi:1 FL:31}



static void Test_BFu0c_BFu1i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu31ll, BFu0c_BFu1i_BFu31ll)
//============================================================================


struct  BFu0c_BFu1i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu1i_BFu32i) C1{ Fc:0 Fi:1 Fi:32}



static void Test_BFu0c_BFu1i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu32i, BFu0c_BFu1i_BFu32i)
//============================================================================


struct  BFu0c_BFu1i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu1i_BFu32ll) C1{ Fc:0 Fi:1 FL:32}



static void Test_BFu0c_BFu1i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0c_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu32ll, BFu0c_BFu1i_BFu32ll)
//============================================================================


struct  BFu0c_BFu1i_BFu33  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu1i_BFu33) C1{ Fc:0 Fi:1 FL:33}



static void Test_BFu0c_BFu1i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu33");
    static STRUCT_IF_C BFu0c_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0c_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu33, BFu0c_BFu1i_BFu33)
//============================================================================


struct  BFu0c_BFu1i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu1i_BFu7c) C1{ Fc:0 Fi:1 Fc:7}



static void Test_BFu0c_BFu1i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu7c, BFu0c_BFu1i_BFu7c)
//============================================================================


struct  BFu0c_BFu1i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu1i_BFu7i) C1{ Fc:0 Fi:1 Fi:7}



static void Test_BFu0c_BFu1i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu7i, BFu0c_BFu1i_BFu7i)
//============================================================================


struct  BFu0c_BFu1i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu1i_BFu7ll) C1{ Fc:0 Fi:1 FL:7}



static void Test_BFu0c_BFu1i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu7ll, BFu0c_BFu1i_BFu7ll)
//============================================================================


struct  BFu0c_BFu1i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu1i_BFu7s) C1{ Fc:0 Fi:1 Fs:7}



static void Test_BFu0c_BFu1i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu7s, BFu0c_BFu1i_BFu7s)
//============================================================================


struct  BFu0c_BFu1i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu1i_BFu8c) C1{ Fc:0 Fi:1 Fc:8}



static void Test_BFu0c_BFu1i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu8c, BFu0c_BFu1i_BFu8c)
//============================================================================


struct  BFu0c_BFu1i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu1i_BFu8i) C1{ Fc:0 Fi:1 Fi:8}



static void Test_BFu0c_BFu1i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu8i, BFu0c_BFu1i_BFu8i)
//============================================================================


struct  BFu0c_BFu1i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu1i_BFu8ll) C1{ Fc:0 Fi:1 FL:8}



static void Test_BFu0c_BFu1i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu8ll, BFu0c_BFu1i_BFu8ll)
//============================================================================


struct  BFu0c_BFu1i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu1i_BFu8s) C1{ Fc:0 Fi:1 Fs:8}



static void Test_BFu0c_BFu1i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu8s, BFu0c_BFu1i_BFu8s)
//============================================================================


struct  BFu0c_BFu1i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu1i_BFu9i) C1{ Fc:0 Fi:1 Fi:9}



static void Test_BFu0c_BFu1i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu9i, BFu0c_BFu1i_BFu9i)
//============================================================================


struct  BFu0c_BFu1i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu1i_BFu9ll) C1{ Fc:0 Fi:1 FL:9}



static void Test_BFu0c_BFu1i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu9ll, BFu0c_BFu1i_BFu9ll)
//============================================================================


struct  BFu0c_BFu1i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu1i_BFu9s) C1{ Fc:0 Fi:1 Fs:9}



static void Test_BFu0c_BFu1i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu1i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_BFu9s, BFu0c_BFu1i_BFu9s)
//============================================================================


struct  BFu0c_BFu1i_C  {
  unsigned char  :0;
  unsigned int v1:1;
  char v2;
};
//SIG(1 BFu0c_BFu1i_C) C1{ Fc:0 Fi:1 Fc}



static void Test_BFu0c_BFu1i_C()
{
  {
    init_simple_test("BFu0c_BFu1i_C");
    static STRUCT_IF_C BFu0c_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_C, BFu0c_BFu1i_C)
//============================================================================


struct  BFu0c_BFu1i_D  {
  unsigned char  :0;
  unsigned int v1:1;
  double v2;
};
//SIG(1 BFu0c_BFu1i_D) C1{ Fc:0 Fi:1 FL}



static void Test_BFu0c_BFu1i_D()
{
  {
    init_simple_test("BFu0c_BFu1i_D");
    static STRUCT_IF_C BFu0c_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_D, BFu0c_BFu1i_D)
//============================================================================


struct  BFu0c_BFu1i_F  {
  unsigned char  :0;
  unsigned int v1:1;
  float v2;
};
//SIG(1 BFu0c_BFu1i_F) C1{ Fc:0 Fi:1 Fi}



static void Test_BFu0c_BFu1i_F()
{
  {
    init_simple_test("BFu0c_BFu1i_F");
    static STRUCT_IF_C BFu0c_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_F, BFu0c_BFu1i_F)
//============================================================================


struct  BFu0c_BFu1i_I  {
  unsigned char  :0;
  unsigned int v1:1;
  int v2;
};
//SIG(1 BFu0c_BFu1i_I) C1{ Fc:0 Fi:1 Fi}



static void Test_BFu0c_BFu1i_I()
{
  {
    init_simple_test("BFu0c_BFu1i_I");
    static STRUCT_IF_C BFu0c_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_I, BFu0c_BFu1i_I)
//============================================================================


struct  BFu0c_BFu1i_Ip  {
  unsigned char  :0;
  unsigned int v1:1;
  int *v2;
};
//SIG(1 BFu0c_BFu1i_Ip) C1{ Fc:0 Fi:1 Fp}



static void Test_BFu0c_BFu1i_Ip()
{
  {
    init_simple_test("BFu0c_BFu1i_Ip");
    static STRUCT_IF_C BFu0c_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Ip, BFu0c_BFu1i_Ip)
//============================================================================


struct  BFu0c_BFu1i_L  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu1i_L) C1{ Fc:0 Fi:1 FL}



static void Test_BFu0c_BFu1i_L()
{
  {
    init_simple_test("BFu0c_BFu1i_L");
    static STRUCT_IF_C BFu0c_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_L, BFu0c_BFu1i_L)
//============================================================================


struct  BFu0c_BFu1i_S  {
  unsigned char  :0;
  unsigned int v1:1;
  short v2;
};
//SIG(1 BFu0c_BFu1i_S) C1{ Fc:0 Fi:1 Fs}



static void Test_BFu0c_BFu1i_S()
{
  {
    init_simple_test("BFu0c_BFu1i_S");
    static STRUCT_IF_C BFu0c_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_S, BFu0c_BFu1i_S)
//============================================================================


struct  BFu0c_BFu1i_Uc  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu1i_Uc) C1{ Fc:0 Fi:1 Fc}



static void Test_BFu0c_BFu1i_Uc()
{
  {
    init_simple_test("BFu0c_BFu1i_Uc");
    static STRUCT_IF_C BFu0c_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Uc, BFu0c_BFu1i_Uc)
//============================================================================


struct  BFu0c_BFu1i_Ui  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu1i_Ui) C1{ Fc:0 Fi:1 Fi}



static void Test_BFu0c_BFu1i_Ui()
{
  {
    init_simple_test("BFu0c_BFu1i_Ui");
    static STRUCT_IF_C BFu0c_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Ui, BFu0c_BFu1i_Ui)
//============================================================================


struct  BFu0c_BFu1i_Ul  {
  unsigned char  :0;
  unsigned int v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu1i_Ul) C1{ Fc:0 Fi:1 FL}



static void Test_BFu0c_BFu1i_Ul()
{
  {
    init_simple_test("BFu0c_BFu1i_Ul");
    static STRUCT_IF_C BFu0c_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Ul, BFu0c_BFu1i_Ul)
//============================================================================


struct  BFu0c_BFu1i_Us  {
  unsigned char  :0;
  unsigned int v1:1;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu1i_Us) C1{ Fc:0 Fi:1 Fs}



static void Test_BFu0c_BFu1i_Us()
{
  {
    init_simple_test("BFu0c_BFu1i_Us");
    static STRUCT_IF_C BFu0c_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Us, BFu0c_BFu1i_Us)
//============================================================================


struct  BFu0c_BFu1i_Vp  {
  unsigned char  :0;
  unsigned int v1:1;
  void *v2;
};
//SIG(1 BFu0c_BFu1i_Vp) C1{ Fc:0 Fi:1 Fp}



static void Test_BFu0c_BFu1i_Vp()
{
  {
    init_simple_test("BFu0c_BFu1i_Vp");
    static STRUCT_IF_C BFu0c_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1i_Vp, BFu0c_BFu1i_Vp)
//============================================================================


struct  BFu0c_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:1;
};
//SIG(1 BFu0c_BFu1ll) C1{ Fc:0 FL:1}



static void Test_BFu0c_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll, BFu0c_BFu1ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu1ll_BFu0c) C1{ Fc:0 FL:1 Fc:0}



static void Test_BFu0c_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu0c, BFu0c_BFu1ll_BFu0c)
//============================================================================


struct  BFu0c_BFu1ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu1ll_BFu0i) C1{ Fc:0 FL:1 Fi:0}



static void Test_BFu0c_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu0i, BFu0c_BFu1ll_BFu0i)
//============================================================================


struct  BFu0c_BFu1ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu1ll_BFu0ll) C1{ Fc:0 FL:1 FL:0}



static void Test_BFu0c_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu0ll, BFu0c_BFu1ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu1ll_BFu0s) C1{ Fc:0 FL:1 Fs:0}



static void Test_BFu0c_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu0s, BFu0c_BFu1ll_BFu0s)
//============================================================================


struct  BFu0c_BFu1ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu1ll_BFu15i) C1{ Fc:0 FL:1 Fi:15}



static void Test_BFu0c_BFu1ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu15i, BFu0c_BFu1ll_BFu15i)
//============================================================================


struct  BFu0c_BFu1ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu1ll_BFu15ll) C1{ Fc:0 FL:1 FL:15}



static void Test_BFu0c_BFu1ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu15ll, BFu0c_BFu1ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu1ll_BFu15s) C1{ Fc:0 FL:1 Fs:15}



static void Test_BFu0c_BFu1ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu15s, BFu0c_BFu1ll_BFu15s)
//============================================================================


struct  BFu0c_BFu1ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu1ll_BFu16i) C1{ Fc:0 FL:1 Fi:16}



static void Test_BFu0c_BFu1ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu16i, BFu0c_BFu1ll_BFu16i)
//============================================================================


struct  BFu0c_BFu1ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu1ll_BFu16ll) C1{ Fc:0 FL:1 FL:16}



static void Test_BFu0c_BFu1ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu16ll, BFu0c_BFu1ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu1ll_BFu16s) C1{ Fc:0 FL:1 Fs:16}



static void Test_BFu0c_BFu1ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu16s, BFu0c_BFu1ll_BFu16s)
//============================================================================


struct  BFu0c_BFu1ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu1ll_BFu17i) C1{ Fc:0 FL:1 Fi:17}



static void Test_BFu0c_BFu1ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu17i, BFu0c_BFu1ll_BFu17i)
//============================================================================


struct  BFu0c_BFu1ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu1ll_BFu17ll) C1{ Fc:0 FL:1 FL:17}



static void Test_BFu0c_BFu1ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu17ll, BFu0c_BFu1ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu1ll_BFu1c) C1{ Fc:0 FL:1 Fc:1}



static void Test_BFu0c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu1c, BFu0c_BFu1ll_BFu1c)
//============================================================================


struct  BFu0c_BFu1ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu1ll_BFu1i) C1{ Fc:0 FL:1 Fi:1}



static void Test_BFu0c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu1i, BFu0c_BFu1ll_BFu1i)
//============================================================================


struct  BFu0c_BFu1ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu1ll_BFu1ll) C1{ Fc:0 FL:1 FL:1}



static void Test_BFu0c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu1ll, BFu0c_BFu1ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu1ll_BFu1s) C1{ Fc:0 FL:1 Fs:1}



static void Test_BFu0c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu1s, BFu0c_BFu1ll_BFu1s)
//============================================================================


struct  BFu0c_BFu1ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu1ll_BFu31i) C1{ Fc:0 FL:1 Fi:31}



static void Test_BFu0c_BFu1ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu31i, BFu0c_BFu1ll_BFu31i)
//============================================================================


struct  BFu0c_BFu1ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu1ll_BFu31ll) C1{ Fc:0 FL:1 FL:31}



static void Test_BFu0c_BFu1ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu31ll, BFu0c_BFu1ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu1ll_BFu32i) C1{ Fc:0 FL:1 Fi:32}



static void Test_BFu0c_BFu1ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu32i, BFu0c_BFu1ll_BFu32i)
//============================================================================


struct  BFu0c_BFu1ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu1ll_BFu32ll) C1{ Fc:0 FL:1 FL:32}



static void Test_BFu0c_BFu1ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0c_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu32ll, BFu0c_BFu1ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu1ll_BFu33) C1{ Fc:0 FL:1 FL:33}



static void Test_BFu0c_BFu1ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0c_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu33, BFu0c_BFu1ll_BFu33)
//============================================================================


struct  BFu0c_BFu1ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu1ll_BFu7c) C1{ Fc:0 FL:1 Fc:7}



static void Test_BFu0c_BFu1ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu7c, BFu0c_BFu1ll_BFu7c)
//============================================================================


struct  BFu0c_BFu1ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu1ll_BFu7i) C1{ Fc:0 FL:1 Fi:7}



static void Test_BFu0c_BFu1ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu7i, BFu0c_BFu1ll_BFu7i)
//============================================================================


struct  BFu0c_BFu1ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu1ll_BFu7ll) C1{ Fc:0 FL:1 FL:7}



static void Test_BFu0c_BFu1ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu7ll, BFu0c_BFu1ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu1ll_BFu7s) C1{ Fc:0 FL:1 Fs:7}



static void Test_BFu0c_BFu1ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu7s, BFu0c_BFu1ll_BFu7s)
//============================================================================


struct  BFu0c_BFu1ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu1ll_BFu8c) C1{ Fc:0 FL:1 Fc:8}



static void Test_BFu0c_BFu1ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu8c, BFu0c_BFu1ll_BFu8c)
//============================================================================


struct  BFu0c_BFu1ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu1ll_BFu8i) C1{ Fc:0 FL:1 Fi:8}



static void Test_BFu0c_BFu1ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu8i, BFu0c_BFu1ll_BFu8i)
//============================================================================


struct  BFu0c_BFu1ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu1ll_BFu8ll) C1{ Fc:0 FL:1 FL:8}



static void Test_BFu0c_BFu1ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu8ll, BFu0c_BFu1ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu1ll_BFu8s) C1{ Fc:0 FL:1 Fs:8}



static void Test_BFu0c_BFu1ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu8s, BFu0c_BFu1ll_BFu8s)
//============================================================================


struct  BFu0c_BFu1ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu1ll_BFu9i) C1{ Fc:0 FL:1 Fi:9}



static void Test_BFu0c_BFu1ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu9i, BFu0c_BFu1ll_BFu9i)
//============================================================================


struct  BFu0c_BFu1ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu1ll_BFu9ll) C1{ Fc:0 FL:1 FL:9}



static void Test_BFu0c_BFu1ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu9ll, BFu0c_BFu1ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu1ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu1ll_BFu9s) C1{ Fc:0 FL:1 Fs:9}



static void Test_BFu0c_BFu1ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu1ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_BFu9s, BFu0c_BFu1ll_BFu9s)
//============================================================================


struct  BFu0c_BFu1ll_C  {
  unsigned char  :0;
  __tsu64 v1:1;
  char v2;
};
//SIG(1 BFu0c_BFu1ll_C) C1{ Fc:0 FL:1 Fc}



static void Test_BFu0c_BFu1ll_C()
{
  {
    init_simple_test("BFu0c_BFu1ll_C");
    static STRUCT_IF_C BFu0c_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_C, BFu0c_BFu1ll_C)
//============================================================================


struct  BFu0c_BFu1ll_D  {
  unsigned char  :0;
  __tsu64 v1:1;
  double v2;
};
//SIG(1 BFu0c_BFu1ll_D) C1{ Fc:0 FL:1 FL}



static void Test_BFu0c_BFu1ll_D()
{
  {
    init_simple_test("BFu0c_BFu1ll_D");
    static STRUCT_IF_C BFu0c_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_D, BFu0c_BFu1ll_D)
//============================================================================


struct  BFu0c_BFu1ll_F  {
  unsigned char  :0;
  __tsu64 v1:1;
  float v2;
};
//SIG(1 BFu0c_BFu1ll_F) C1{ Fc:0 FL:1 Fi}



static void Test_BFu0c_BFu1ll_F()
{
  {
    init_simple_test("BFu0c_BFu1ll_F");
    static STRUCT_IF_C BFu0c_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_F, BFu0c_BFu1ll_F)
//============================================================================


struct  BFu0c_BFu1ll_I  {
  unsigned char  :0;
  __tsu64 v1:1;
  int v2;
};
//SIG(1 BFu0c_BFu1ll_I) C1{ Fc:0 FL:1 Fi}



static void Test_BFu0c_BFu1ll_I()
{
  {
    init_simple_test("BFu0c_BFu1ll_I");
    static STRUCT_IF_C BFu0c_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_I, BFu0c_BFu1ll_I)
//============================================================================


struct  BFu0c_BFu1ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:1;
  int *v2;
};
//SIG(1 BFu0c_BFu1ll_Ip) C1{ Fc:0 FL:1 Fp}



static void Test_BFu0c_BFu1ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu1ll_Ip");
    static STRUCT_IF_C BFu0c_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Ip, BFu0c_BFu1ll_Ip)
//============================================================================


struct  BFu0c_BFu1ll_L  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu1ll_L) C1{ Fc:0 FL:1 FL}



static void Test_BFu0c_BFu1ll_L()
{
  {
    init_simple_test("BFu0c_BFu1ll_L");
    static STRUCT_IF_C BFu0c_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_L, BFu0c_BFu1ll_L)
//============================================================================


struct  BFu0c_BFu1ll_S  {
  unsigned char  :0;
  __tsu64 v1:1;
  short v2;
};
//SIG(1 BFu0c_BFu1ll_S) C1{ Fc:0 FL:1 Fs}



static void Test_BFu0c_BFu1ll_S()
{
  {
    init_simple_test("BFu0c_BFu1ll_S");
    static STRUCT_IF_C BFu0c_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_S, BFu0c_BFu1ll_S)
//============================================================================


struct  BFu0c_BFu1ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu1ll_Uc) C1{ Fc:0 FL:1 Fc}



static void Test_BFu0c_BFu1ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu1ll_Uc");
    static STRUCT_IF_C BFu0c_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Uc, BFu0c_BFu1ll_Uc)
//============================================================================


struct  BFu0c_BFu1ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu1ll_Ui) C1{ Fc:0 FL:1 Fi}



static void Test_BFu0c_BFu1ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu1ll_Ui");
    static STRUCT_IF_C BFu0c_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Ui, BFu0c_BFu1ll_Ui)
//============================================================================


struct  BFu0c_BFu1ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu1ll_Ul) C1{ Fc:0 FL:1 FL}



static void Test_BFu0c_BFu1ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu1ll_Ul");
    static STRUCT_IF_C BFu0c_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Ul, BFu0c_BFu1ll_Ul)
//============================================================================


struct  BFu0c_BFu1ll_Us  {
  unsigned char  :0;
  __tsu64 v1:1;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu1ll_Us) C1{ Fc:0 FL:1 Fs}



static void Test_BFu0c_BFu1ll_Us()
{
  {
    init_simple_test("BFu0c_BFu1ll_Us");
    static STRUCT_IF_C BFu0c_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Us, BFu0c_BFu1ll_Us)
//============================================================================


struct  BFu0c_BFu1ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:1;
  void *v2;
};
//SIG(1 BFu0c_BFu1ll_Vp) C1{ Fc:0 FL:1 Fp}



static void Test_BFu0c_BFu1ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu1ll_Vp");
    static STRUCT_IF_C BFu0c_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1ll_Vp, BFu0c_BFu1ll_Vp)
//============================================================================


struct  BFu0c_BFu1s  {
  unsigned char  :0;
  unsigned short v1:1;
};
//SIG(1 BFu0c_BFu1s) C1{ Fc:0 Fs:1}



static void Test_BFu0c_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu1s");
    static STRUCT_IF_C BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s, BFu0c_BFu1s)
//============================================================================


struct  BFu0c_BFu1s_BFu0c  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu1s_BFu0c) C1{ Fc:0 Fs:1 Fc:0}



static void Test_BFu0c_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu0c, BFu0c_BFu1s_BFu0c)
//============================================================================


struct  BFu0c_BFu1s_BFu0i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu1s_BFu0i) C1{ Fc:0 Fs:1 Fi:0}



static void Test_BFu0c_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu0i, BFu0c_BFu1s_BFu0i)
//============================================================================


struct  BFu0c_BFu1s_BFu0ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu1s_BFu0ll) C1{ Fc:0 Fs:1 FL:0}



static void Test_BFu0c_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu0ll, BFu0c_BFu1s_BFu0ll)
//============================================================================


struct  BFu0c_BFu1s_BFu0s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu1s_BFu0s) C1{ Fc:0 Fs:1 Fs:0}



static void Test_BFu0c_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu0s, BFu0c_BFu1s_BFu0s)
//============================================================================


struct  BFu0c_BFu1s_BFu15i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu1s_BFu15i) C1{ Fc:0 Fs:1 Fi:15}



static void Test_BFu0c_BFu1s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu15i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu15i, BFu0c_BFu1s_BFu15i)
//============================================================================


struct  BFu0c_BFu1s_BFu15ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu1s_BFu15ll) C1{ Fc:0 Fs:1 FL:15}



static void Test_BFu0c_BFu1s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu15ll, BFu0c_BFu1s_BFu15ll)
//============================================================================


struct  BFu0c_BFu1s_BFu15s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu1s_BFu15s) C1{ Fc:0 Fs:1 Fs:15}



static void Test_BFu0c_BFu1s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu15s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu15s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0c_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu15s, BFu0c_BFu1s_BFu15s)
//============================================================================


struct  BFu0c_BFu1s_BFu16i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu1s_BFu16i) C1{ Fc:0 Fs:1 Fi:16}



static void Test_BFu0c_BFu1s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu16i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu16i, BFu0c_BFu1s_BFu16i)
//============================================================================


struct  BFu0c_BFu1s_BFu16ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu1s_BFu16ll) C1{ Fc:0 Fs:1 FL:16}



static void Test_BFu0c_BFu1s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0c_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu16ll, BFu0c_BFu1s_BFu16ll)
//============================================================================


struct  BFu0c_BFu1s_BFu16s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu1s_BFu16s) C1{ Fc:0 Fs:1 Fs:16}



static void Test_BFu0c_BFu1s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu16s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu16s, BFu0c_BFu1s_BFu16s)
//============================================================================


struct  BFu0c_BFu1s_BFu17i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu1s_BFu17i) C1{ Fc:0 Fs:1 Fi:17}



static void Test_BFu0c_BFu1s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu17i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu17i, BFu0c_BFu1s_BFu17i)
//============================================================================


struct  BFu0c_BFu1s_BFu17ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu1s_BFu17ll) C1{ Fc:0 Fs:1 FL:17}



static void Test_BFu0c_BFu1s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0c_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu17ll, BFu0c_BFu1s_BFu17ll)
//============================================================================


struct  BFu0c_BFu1s_BFu1c  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu1s_BFu1c) C1{ Fc:0 Fs:1 Fc:1}



static void Test_BFu0c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu1c");
    static STRUCT_IF_C BFu0c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu1c, BFu0c_BFu1s_BFu1c)
//============================================================================


struct  BFu0c_BFu1s_BFu1i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu1s_BFu1i) C1{ Fc:0 Fs:1 Fi:1}



static void Test_BFu0c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu1i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu1i, BFu0c_BFu1s_BFu1i)
//============================================================================


struct  BFu0c_BFu1s_BFu1ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu1s_BFu1ll) C1{ Fc:0 Fs:1 FL:1}



static void Test_BFu0c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu1ll, BFu0c_BFu1s_BFu1ll)
//============================================================================


struct  BFu0c_BFu1s_BFu1s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu1s_BFu1s) C1{ Fc:0 Fs:1 Fs:1}



static void Test_BFu0c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu1s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu1s, BFu0c_BFu1s_BFu1s)
//============================================================================


struct  BFu0c_BFu1s_BFu31i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu1s_BFu31i) C1{ Fc:0 Fs:1 Fi:31}



static void Test_BFu0c_BFu1s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu31i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu31i, BFu0c_BFu1s_BFu31i)
//============================================================================


struct  BFu0c_BFu1s_BFu31ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu1s_BFu31ll) C1{ Fc:0 Fs:1 FL:31}



static void Test_BFu0c_BFu1s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0c_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu31ll, BFu0c_BFu1s_BFu31ll)
//============================================================================


struct  BFu0c_BFu1s_BFu32i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu1s_BFu32i) C1{ Fc:0 Fs:1 Fi:32}



static void Test_BFu0c_BFu1s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu32i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu32i, BFu0c_BFu1s_BFu32i)
//============================================================================


struct  BFu0c_BFu1s_BFu32ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu1s_BFu32ll) C1{ Fc:0 Fs:1 FL:32}



static void Test_BFu0c_BFu1s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0c_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu32ll, BFu0c_BFu1s_BFu32ll)
//============================================================================


struct  BFu0c_BFu1s_BFu33  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu1s_BFu33) C1{ Fc:0 Fs:1 FL:33}



static void Test_BFu0c_BFu1s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu33");
    static STRUCT_IF_C BFu0c_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0c_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu33, BFu0c_BFu1s_BFu33)
//============================================================================


struct  BFu0c_BFu1s_BFu7c  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu1s_BFu7c) C1{ Fc:0 Fs:1 Fc:7}



static void Test_BFu0c_BFu1s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu7c");
    static STRUCT_IF_C BFu0c_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu7c, BFu0c_BFu1s_BFu7c)
//============================================================================


struct  BFu0c_BFu1s_BFu7i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu1s_BFu7i) C1{ Fc:0 Fs:1 Fi:7}



static void Test_BFu0c_BFu1s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu7i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu7i, BFu0c_BFu1s_BFu7i)
//============================================================================


struct  BFu0c_BFu1s_BFu7ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu1s_BFu7ll) C1{ Fc:0 Fs:1 FL:7}



static void Test_BFu0c_BFu1s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu7ll, BFu0c_BFu1s_BFu7ll)
//============================================================================


struct  BFu0c_BFu1s_BFu7s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu1s_BFu7s) C1{ Fc:0 Fs:1 Fs:7}



static void Test_BFu0c_BFu1s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu7s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0c_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu7s, BFu0c_BFu1s_BFu7s)
//============================================================================


struct  BFu0c_BFu1s_BFu8c  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu1s_BFu8c) C1{ Fc:0 Fs:1 Fc:8}



static void Test_BFu0c_BFu1s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu8c");
    static STRUCT_IF_C BFu0c_BFu1s_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu8c, BFu0c_BFu1s_BFu8c)
//============================================================================


struct  BFu0c_BFu1s_BFu8i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu1s_BFu8i) C1{ Fc:0 Fs:1 Fi:8}



static void Test_BFu0c_BFu1s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu8i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu8i, BFu0c_BFu1s_BFu8i)
//============================================================================


struct  BFu0c_BFu1s_BFu8ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu1s_BFu8ll) C1{ Fc:0 Fs:1 FL:8}



static void Test_BFu0c_BFu1s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu8ll, BFu0c_BFu1s_BFu8ll)
//============================================================================


struct  BFu0c_BFu1s_BFu8s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu1s_BFu8s) C1{ Fc:0 Fs:1 Fs:8}



static void Test_BFu0c_BFu1s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu8s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0c_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu8s, BFu0c_BFu1s_BFu8s)
//============================================================================


struct  BFu0c_BFu1s_BFu9i  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu1s_BFu9i) C1{ Fc:0 Fs:1 Fi:9}



static void Test_BFu0c_BFu1s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu9i");
    static STRUCT_IF_C BFu0c_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu9i, BFu0c_BFu1s_BFu9i)
//============================================================================


struct  BFu0c_BFu1s_BFu9ll  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu1s_BFu9ll) C1{ Fc:0 Fs:1 FL:9}



static void Test_BFu0c_BFu1s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu9ll, BFu0c_BFu1s_BFu9ll)
//============================================================================


struct  BFu0c_BFu1s_BFu9s  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu1s_BFu9s) C1{ Fc:0 Fs:1 Fs:9}



static void Test_BFu0c_BFu1s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu1s_BFu9s");
    static STRUCT_IF_C BFu0c_BFu1s_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0c_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_BFu9s, BFu0c_BFu1s_BFu9s)
//============================================================================


struct  BFu0c_BFu1s_C  {
  unsigned char  :0;
  unsigned short v1:1;
  char v2;
};
//SIG(1 BFu0c_BFu1s_C) C1{ Fc:0 Fs:1 Fc}



static void Test_BFu0c_BFu1s_C()
{
  {
    init_simple_test("BFu0c_BFu1s_C");
    static STRUCT_IF_C BFu0c_BFu1s_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_C, BFu0c_BFu1s_C)
//============================================================================


struct  BFu0c_BFu1s_D  {
  unsigned char  :0;
  unsigned short v1:1;
  double v2;
};
//SIG(1 BFu0c_BFu1s_D) C1{ Fc:0 Fs:1 FL}



static void Test_BFu0c_BFu1s_D()
{
  {
    init_simple_test("BFu0c_BFu1s_D");
    static STRUCT_IF_C BFu0c_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_D, BFu0c_BFu1s_D)
//============================================================================


struct  BFu0c_BFu1s_F  {
  unsigned char  :0;
  unsigned short v1:1;
  float v2;
};
//SIG(1 BFu0c_BFu1s_F) C1{ Fc:0 Fs:1 Fi}



static void Test_BFu0c_BFu1s_F()
{
  {
    init_simple_test("BFu0c_BFu1s_F");
    static STRUCT_IF_C BFu0c_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_F, BFu0c_BFu1s_F)
//============================================================================


struct  BFu0c_BFu1s_I  {
  unsigned char  :0;
  unsigned short v1:1;
  int v2;
};
//SIG(1 BFu0c_BFu1s_I) C1{ Fc:0 Fs:1 Fi}



static void Test_BFu0c_BFu1s_I()
{
  {
    init_simple_test("BFu0c_BFu1s_I");
    static STRUCT_IF_C BFu0c_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_I, BFu0c_BFu1s_I)
//============================================================================


struct  BFu0c_BFu1s_Ip  {
  unsigned char  :0;
  unsigned short v1:1;
  int *v2;
};
//SIG(1 BFu0c_BFu1s_Ip) C1{ Fc:0 Fs:1 Fp}



static void Test_BFu0c_BFu1s_Ip()
{
  {
    init_simple_test("BFu0c_BFu1s_Ip");
    static STRUCT_IF_C BFu0c_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Ip, BFu0c_BFu1s_Ip)
//============================================================================


struct  BFu0c_BFu1s_L  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu1s_L) C1{ Fc:0 Fs:1 FL}



static void Test_BFu0c_BFu1s_L()
{
  {
    init_simple_test("BFu0c_BFu1s_L");
    static STRUCT_IF_C BFu0c_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_L, BFu0c_BFu1s_L)
//============================================================================


struct  BFu0c_BFu1s_S  {
  unsigned char  :0;
  unsigned short v1:1;
  short v2;
};
//SIG(1 BFu0c_BFu1s_S) C1{ Fc:0 Fs:1 Fs}



static void Test_BFu0c_BFu1s_S()
{
  {
    init_simple_test("BFu0c_BFu1s_S");
    static STRUCT_IF_C BFu0c_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_S, BFu0c_BFu1s_S)
//============================================================================


struct  BFu0c_BFu1s_Uc  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu1s_Uc) C1{ Fc:0 Fs:1 Fc}



static void Test_BFu0c_BFu1s_Uc()
{
  {
    init_simple_test("BFu0c_BFu1s_Uc");
    static STRUCT_IF_C BFu0c_BFu1s_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu1s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu1s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Uc, BFu0c_BFu1s_Uc)
//============================================================================


struct  BFu0c_BFu1s_Ui  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu1s_Ui) C1{ Fc:0 Fs:1 Fi}



static void Test_BFu0c_BFu1s_Ui()
{
  {
    init_simple_test("BFu0c_BFu1s_Ui");
    static STRUCT_IF_C BFu0c_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu1s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu1s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Ui, BFu0c_BFu1s_Ui)
//============================================================================


struct  BFu0c_BFu1s_Ul  {
  unsigned char  :0;
  unsigned short v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu1s_Ul) C1{ Fc:0 Fs:1 FL}



static void Test_BFu0c_BFu1s_Ul()
{
  {
    init_simple_test("BFu0c_BFu1s_Ul");
    static STRUCT_IF_C BFu0c_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Ul, BFu0c_BFu1s_Ul)
//============================================================================


struct  BFu0c_BFu1s_Us  {
  unsigned char  :0;
  unsigned short v1:1;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu1s_Us) C1{ Fc:0 Fs:1 Fs}



static void Test_BFu0c_BFu1s_Us()
{
  {
    init_simple_test("BFu0c_BFu1s_Us");
    static STRUCT_IF_C BFu0c_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu1s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu1s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu1s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Us, BFu0c_BFu1s_Us)
//============================================================================


struct  BFu0c_BFu1s_Vp  {
  unsigned char  :0;
  unsigned short v1:1;
  void *v2;
};
//SIG(1 BFu0c_BFu1s_Vp) C1{ Fc:0 Fs:1 Fp}



static void Test_BFu0c_BFu1s_Vp()
{
  {
    init_simple_test("BFu0c_BFu1s_Vp");
    static STRUCT_IF_C BFu0c_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu1s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0c_BFu1s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu1s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu1s_Vp, BFu0c_BFu1s_Vp)
//============================================================================


struct  BFu0c_BFu31i  {
  unsigned char  :0;
  unsigned int v1:31;
};
//SIG(1 BFu0c_BFu31i) C1{ Fc:0 Fi:31}



static void Test_BFu0c_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu31i");
    static STRUCT_IF_C BFu0c_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i, BFu0c_BFu31i)
//============================================================================


struct  BFu0c_BFu31i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu31i_BFu0c) C1{ Fc:0 Fi:31 Fc:0}



static void Test_BFu0c_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu31i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu0c, BFu0c_BFu31i_BFu0c)
//============================================================================


struct  BFu0c_BFu31i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu31i_BFu0i) C1{ Fc:0 Fi:31 Fi:0}



static void Test_BFu0c_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu0i, BFu0c_BFu31i_BFu0i)
//============================================================================


struct  BFu0c_BFu31i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu31i_BFu0ll) C1{ Fc:0 Fi:31 FL:0}



static void Test_BFu0c_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu0ll, BFu0c_BFu31i_BFu0ll)
//============================================================================


struct  BFu0c_BFu31i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu31i_BFu0s) C1{ Fc:0 Fi:31 Fs:0}



static void Test_BFu0c_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu0s, BFu0c_BFu31i_BFu0s)
//============================================================================


struct  BFu0c_BFu31i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu31i_BFu15i) C1{ Fc:0 Fi:31 Fi:15}



static void Test_BFu0c_BFu31i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu15i, BFu0c_BFu31i_BFu15i)
//============================================================================


struct  BFu0c_BFu31i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu31i_BFu15ll) C1{ Fc:0 Fi:31 FL:15}



static void Test_BFu0c_BFu31i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu0c_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu15ll, BFu0c_BFu31i_BFu15ll)
//============================================================================


struct  BFu0c_BFu31i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu31i_BFu15s) C1{ Fc:0 Fi:31 Fs:15}



static void Test_BFu0c_BFu31i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu15s, BFu0c_BFu31i_BFu15s)
//============================================================================


struct  BFu0c_BFu31i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu31i_BFu16i) C1{ Fc:0 Fi:31 Fi:16}



static void Test_BFu0c_BFu31i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu16i, BFu0c_BFu31i_BFu16i)
//============================================================================


struct  BFu0c_BFu31i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu31i_BFu16ll) C1{ Fc:0 Fi:31 FL:16}



static void Test_BFu0c_BFu31i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu0c_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu16ll, BFu0c_BFu31i_BFu16ll)
//============================================================================


struct  BFu0c_BFu31i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu31i_BFu16s) C1{ Fc:0 Fi:31 Fs:16}



static void Test_BFu0c_BFu31i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu16s, BFu0c_BFu31i_BFu16s)
//============================================================================


struct  BFu0c_BFu31i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu31i_BFu17i) C1{ Fc:0 Fi:31 Fi:17}



static void Test_BFu0c_BFu31i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu17i, BFu0c_BFu31i_BFu17i)
//============================================================================


struct  BFu0c_BFu31i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu31i_BFu17ll) C1{ Fc:0 Fi:31 FL:17}



static void Test_BFu0c_BFu31i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu0c_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu17ll, BFu0c_BFu31i_BFu17ll)
//============================================================================


struct  BFu0c_BFu31i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu31i_BFu1c) C1{ Fc:0 Fi:31 Fc:1}



static void Test_BFu0c_BFu31i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu31i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu1c, BFu0c_BFu31i_BFu1c)
//============================================================================


struct  BFu0c_BFu31i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu31i_BFu1i) C1{ Fc:0 Fi:31 Fi:1}



static void Test_BFu0c_BFu31i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu1i, BFu0c_BFu31i_BFu1i)
//============================================================================


struct  BFu0c_BFu31i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu31i_BFu1ll) C1{ Fc:0 Fi:31 FL:1}



static void Test_BFu0c_BFu31i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu1ll, BFu0c_BFu31i_BFu1ll)
//============================================================================


struct  BFu0c_BFu31i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu31i_BFu1s) C1{ Fc:0 Fi:31 Fs:1}



static void Test_BFu0c_BFu31i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu1s, BFu0c_BFu31i_BFu1s)
//============================================================================


struct  BFu0c_BFu31i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu31i_BFu31i) C1{ Fc:0 Fi:31 Fi:31}



static void Test_BFu0c_BFu31i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu31i, BFu0c_BFu31i_BFu31i)
//============================================================================


struct  BFu0c_BFu31i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu31i_BFu31ll) C1{ Fc:0 Fi:31 FL:31}



static void Test_BFu0c_BFu31i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu0c_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu31ll, BFu0c_BFu31i_BFu31ll)
//============================================================================


struct  BFu0c_BFu31i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu31i_BFu32i) C1{ Fc:0 Fi:31 Fi:32}



static void Test_BFu0c_BFu31i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu32i, BFu0c_BFu31i_BFu32i)
//============================================================================


struct  BFu0c_BFu31i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu31i_BFu32ll) C1{ Fc:0 Fi:31 FL:32}



static void Test_BFu0c_BFu31i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu0c_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu32ll, BFu0c_BFu31i_BFu32ll)
//============================================================================


struct  BFu0c_BFu31i_BFu33  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu31i_BFu33) C1{ Fc:0 Fi:31 FL:33}



static void Test_BFu0c_BFu31i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu33");
    static STRUCT_IF_C BFu0c_BFu31i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu0c_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu33, BFu0c_BFu31i_BFu33)
//============================================================================


struct  BFu0c_BFu31i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu31i_BFu7c) C1{ Fc:0 Fi:31 Fc:7}



static void Test_BFu0c_BFu31i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu31i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu7c, BFu0c_BFu31i_BFu7c)
//============================================================================


struct  BFu0c_BFu31i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu31i_BFu7i) C1{ Fc:0 Fi:31 Fi:7}



static void Test_BFu0c_BFu31i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu7i, BFu0c_BFu31i_BFu7i)
//============================================================================


struct  BFu0c_BFu31i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu31i_BFu7ll) C1{ Fc:0 Fi:31 FL:7}



static void Test_BFu0c_BFu31i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu0c_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu7ll, BFu0c_BFu31i_BFu7ll)
//============================================================================


struct  BFu0c_BFu31i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu31i_BFu7s) C1{ Fc:0 Fi:31 Fs:7}



static void Test_BFu0c_BFu31i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu7s, BFu0c_BFu31i_BFu7s)
//============================================================================


struct  BFu0c_BFu31i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu31i_BFu8c) C1{ Fc:0 Fi:31 Fc:8}



static void Test_BFu0c_BFu31i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu31i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu8c, BFu0c_BFu31i_BFu8c)
//============================================================================


struct  BFu0c_BFu31i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu31i_BFu8i) C1{ Fc:0 Fi:31 Fi:8}



static void Test_BFu0c_BFu31i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu8i, BFu0c_BFu31i_BFu8i)
//============================================================================


struct  BFu0c_BFu31i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu31i_BFu8ll) C1{ Fc:0 Fi:31 FL:8}



static void Test_BFu0c_BFu31i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu0c_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu8ll, BFu0c_BFu31i_BFu8ll)
//============================================================================


struct  BFu0c_BFu31i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu31i_BFu8s) C1{ Fc:0 Fi:31 Fs:8}



static void Test_BFu0c_BFu31i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu8s, BFu0c_BFu31i_BFu8s)
//============================================================================


struct  BFu0c_BFu31i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu31i_BFu9i) C1{ Fc:0 Fi:31 Fi:9}



static void Test_BFu0c_BFu31i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu31i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu9i, BFu0c_BFu31i_BFu9i)
//============================================================================


struct  BFu0c_BFu31i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu31i_BFu9ll) C1{ Fc:0 Fi:31 FL:9}



static void Test_BFu0c_BFu31i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu0c_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu9ll, BFu0c_BFu31i_BFu9ll)
//============================================================================


struct  BFu0c_BFu31i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu31i_BFu9s) C1{ Fc:0 Fi:31 Fs:9}



static void Test_BFu0c_BFu31i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu31i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu31i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_BFu9s, BFu0c_BFu31i_BFu9s)
//============================================================================


struct  BFu0c_BFu31i_C  {
  unsigned char  :0;
  unsigned int v1:31;
  char v2;
};
//SIG(1 BFu0c_BFu31i_C) C1{ Fc:0 Fi:31 Fc}



static void Test_BFu0c_BFu31i_C()
{
  {
    init_simple_test("BFu0c_BFu31i_C");
    static STRUCT_IF_C BFu0c_BFu31i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_C");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_C, BFu0c_BFu31i_C)
//============================================================================


struct  BFu0c_BFu31i_D  {
  unsigned char  :0;
  unsigned int v1:31;
  double v2;
};
//SIG(1 BFu0c_BFu31i_D) C1{ Fc:0 Fi:31 FL}



static void Test_BFu0c_BFu31i_D()
{
  {
    init_simple_test("BFu0c_BFu31i_D");
    static STRUCT_IF_C BFu0c_BFu31i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_D, BFu0c_BFu31i_D)
//============================================================================


struct  BFu0c_BFu31i_F  {
  unsigned char  :0;
  unsigned int v1:31;
  float v2;
};
//SIG(1 BFu0c_BFu31i_F) C1{ Fc:0 Fi:31 Fi}



static void Test_BFu0c_BFu31i_F()
{
  {
    init_simple_test("BFu0c_BFu31i_F");
    static STRUCT_IF_C BFu0c_BFu31i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_F, BFu0c_BFu31i_F)
//============================================================================


struct  BFu0c_BFu31i_I  {
  unsigned char  :0;
  unsigned int v1:31;
  int v2;
};
//SIG(1 BFu0c_BFu31i_I) C1{ Fc:0 Fi:31 Fi}



static void Test_BFu0c_BFu31i_I()
{
  {
    init_simple_test("BFu0c_BFu31i_I");
    static STRUCT_IF_C BFu0c_BFu31i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_I, BFu0c_BFu31i_I)
//============================================================================


struct  BFu0c_BFu31i_Ip  {
  unsigned char  :0;
  unsigned int v1:31;
  int *v2;
};
//SIG(1 BFu0c_BFu31i_Ip) C1{ Fc:0 Fi:31 Fp}



static void Test_BFu0c_BFu31i_Ip()
{
  {
    init_simple_test("BFu0c_BFu31i_Ip");
    static STRUCT_IF_C BFu0c_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Ip, BFu0c_BFu31i_Ip)
//============================================================================


struct  BFu0c_BFu31i_L  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu31i_L) C1{ Fc:0 Fi:31 FL}



static void Test_BFu0c_BFu31i_L()
{
  {
    init_simple_test("BFu0c_BFu31i_L");
    static STRUCT_IF_C BFu0c_BFu31i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_L, BFu0c_BFu31i_L)
//============================================================================


struct  BFu0c_BFu31i_S  {
  unsigned char  :0;
  unsigned int v1:31;
  short v2;
};
//SIG(1 BFu0c_BFu31i_S) C1{ Fc:0 Fi:31 Fs}



static void Test_BFu0c_BFu31i_S()
{
  {
    init_simple_test("BFu0c_BFu31i_S");
    static STRUCT_IF_C BFu0c_BFu31i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_S");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_S, BFu0c_BFu31i_S)
//============================================================================


struct  BFu0c_BFu31i_Uc  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu31i_Uc) C1{ Fc:0 Fi:31 Fc}



static void Test_BFu0c_BFu31i_Uc()
{
  {
    init_simple_test("BFu0c_BFu31i_Uc");
    static STRUCT_IF_C BFu0c_BFu31i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Uc");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Uc, BFu0c_BFu31i_Uc)
//============================================================================


struct  BFu0c_BFu31i_Ui  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu31i_Ui) C1{ Fc:0 Fi:31 Fi}



static void Test_BFu0c_BFu31i_Ui()
{
  {
    init_simple_test("BFu0c_BFu31i_Ui");
    static STRUCT_IF_C BFu0c_BFu31i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Ui, BFu0c_BFu31i_Ui)
//============================================================================


struct  BFu0c_BFu31i_Ul  {
  unsigned char  :0;
  unsigned int v1:31;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu31i_Ul) C1{ Fc:0 Fi:31 FL}



static void Test_BFu0c_BFu31i_Ul()
{
  {
    init_simple_test("BFu0c_BFu31i_Ul");
    static STRUCT_IF_C BFu0c_BFu31i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Ul, BFu0c_BFu31i_Ul)
//============================================================================


struct  BFu0c_BFu31i_Us  {
  unsigned char  :0;
  unsigned int v1:31;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu31i_Us) C1{ Fc:0 Fi:31 Fs}



static void Test_BFu0c_BFu31i_Us()
{
  {
    init_simple_test("BFu0c_BFu31i_Us");
    static STRUCT_IF_C BFu0c_BFu31i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu31i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Us");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Us, BFu0c_BFu31i_Us)
//============================================================================


struct  BFu0c_BFu31i_Vp  {
  unsigned char  :0;
  unsigned int v1:31;
  void *v2;
};
//SIG(1 BFu0c_BFu31i_Vp) C1{ Fc:0 Fi:31 Fp}



static void Test_BFu0c_BFu31i_Vp()
{
  {
    init_simple_test("BFu0c_BFu31i_Vp");
    static STRUCT_IF_C BFu0c_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31i_Vp, BFu0c_BFu31i_Vp)
//============================================================================


struct  BFu0c_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:31;
};
//SIG(1 BFu0c_BFu31ll) C1{ Fc:0 FL:31}



static void Test_BFu0c_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll, BFu0c_BFu31ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu31ll_BFu0c) C1{ Fc:0 FL:31 Fc:0}



static void Test_BFu0c_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu0c, BFu0c_BFu31ll_BFu0c)
//============================================================================


struct  BFu0c_BFu31ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu31ll_BFu0i) C1{ Fc:0 FL:31 Fi:0}



static void Test_BFu0c_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu0i, BFu0c_BFu31ll_BFu0i)
//============================================================================


struct  BFu0c_BFu31ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu31ll_BFu0ll) C1{ Fc:0 FL:31 FL:0}



static void Test_BFu0c_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu0ll, BFu0c_BFu31ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu31ll_BFu0s) C1{ Fc:0 FL:31 Fs:0}



static void Test_BFu0c_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu0s, BFu0c_BFu31ll_BFu0s)
//============================================================================


struct  BFu0c_BFu31ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu31ll_BFu15i) C1{ Fc:0 FL:31 Fi:15}



static void Test_BFu0c_BFu31ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu15i, BFu0c_BFu31ll_BFu15i)
//============================================================================


struct  BFu0c_BFu31ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu31ll_BFu15ll) C1{ Fc:0 FL:31 FL:15}



static void Test_BFu0c_BFu31ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu0c_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu15ll, BFu0c_BFu31ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu31ll_BFu15s) C1{ Fc:0 FL:31 Fs:15}



static void Test_BFu0c_BFu31ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu15s, BFu0c_BFu31ll_BFu15s)
//============================================================================


struct  BFu0c_BFu31ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu31ll_BFu16i) C1{ Fc:0 FL:31 Fi:16}



static void Test_BFu0c_BFu31ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu16i, BFu0c_BFu31ll_BFu16i)
//============================================================================


struct  BFu0c_BFu31ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu31ll_BFu16ll) C1{ Fc:0 FL:31 FL:16}



static void Test_BFu0c_BFu31ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu0c_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu16ll, BFu0c_BFu31ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu31ll_BFu16s) C1{ Fc:0 FL:31 Fs:16}



static void Test_BFu0c_BFu31ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu16s, BFu0c_BFu31ll_BFu16s)
//============================================================================


struct  BFu0c_BFu31ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu31ll_BFu17i) C1{ Fc:0 FL:31 Fi:17}



static void Test_BFu0c_BFu31ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu17i, BFu0c_BFu31ll_BFu17i)
//============================================================================


struct  BFu0c_BFu31ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu31ll_BFu17ll) C1{ Fc:0 FL:31 FL:17}



static void Test_BFu0c_BFu31ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu0c_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu17ll, BFu0c_BFu31ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu31ll_BFu1c) C1{ Fc:0 FL:31 Fc:1}



static void Test_BFu0c_BFu31ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu1c, BFu0c_BFu31ll_BFu1c)
//============================================================================


struct  BFu0c_BFu31ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu31ll_BFu1i) C1{ Fc:0 FL:31 Fi:1}



static void Test_BFu0c_BFu31ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu1i, BFu0c_BFu31ll_BFu1i)
//============================================================================


struct  BFu0c_BFu31ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu31ll_BFu1ll) C1{ Fc:0 FL:31 FL:1}



static void Test_BFu0c_BFu31ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu1ll, BFu0c_BFu31ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu31ll_BFu1s) C1{ Fc:0 FL:31 Fs:1}



static void Test_BFu0c_BFu31ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0c_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu1s, BFu0c_BFu31ll_BFu1s)
//============================================================================


struct  BFu0c_BFu31ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu31ll_BFu31i) C1{ Fc:0 FL:31 Fi:31}



static void Test_BFu0c_BFu31ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu31i, BFu0c_BFu31ll_BFu31i)
//============================================================================


struct  BFu0c_BFu31ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu31ll_BFu31ll) C1{ Fc:0 FL:31 FL:31}



static void Test_BFu0c_BFu31ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu0c_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu31ll, BFu0c_BFu31ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu31ll_BFu32i) C1{ Fc:0 FL:31 Fi:32}



static void Test_BFu0c_BFu31ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu32i, BFu0c_BFu31ll_BFu32i)
//============================================================================


struct  BFu0c_BFu31ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu31ll_BFu32ll) C1{ Fc:0 FL:31 FL:32}



static void Test_BFu0c_BFu31ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu0c_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu32ll, BFu0c_BFu31ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu31ll_BFu33) C1{ Fc:0 FL:31 FL:33}



static void Test_BFu0c_BFu31ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu0c_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu33, BFu0c_BFu31ll_BFu33)
//============================================================================


struct  BFu0c_BFu31ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu31ll_BFu7c) C1{ Fc:0 FL:31 Fc:7}



static void Test_BFu0c_BFu31ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu7c, BFu0c_BFu31ll_BFu7c)
//============================================================================


struct  BFu0c_BFu31ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu31ll_BFu7i) C1{ Fc:0 FL:31 Fi:7}



static void Test_BFu0c_BFu31ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu7i, BFu0c_BFu31ll_BFu7i)
//============================================================================


struct  BFu0c_BFu31ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu31ll_BFu7ll) C1{ Fc:0 FL:31 FL:7}



static void Test_BFu0c_BFu31ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu0c_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu7ll, BFu0c_BFu31ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu31ll_BFu7s) C1{ Fc:0 FL:31 Fs:7}



static void Test_BFu0c_BFu31ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu7s, BFu0c_BFu31ll_BFu7s)
//============================================================================


struct  BFu0c_BFu31ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu31ll_BFu8c) C1{ Fc:0 FL:31 Fc:8}



static void Test_BFu0c_BFu31ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu8c, BFu0c_BFu31ll_BFu8c)
//============================================================================


struct  BFu0c_BFu31ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu31ll_BFu8i) C1{ Fc:0 FL:31 Fi:8}



static void Test_BFu0c_BFu31ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu8i, BFu0c_BFu31ll_BFu8i)
//============================================================================


struct  BFu0c_BFu31ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu31ll_BFu8ll) C1{ Fc:0 FL:31 FL:8}



static void Test_BFu0c_BFu31ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu0c_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu8ll, BFu0c_BFu31ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu31ll_BFu8s) C1{ Fc:0 FL:31 Fs:8}



static void Test_BFu0c_BFu31ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu8s, BFu0c_BFu31ll_BFu8s)
//============================================================================


struct  BFu0c_BFu31ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu31ll_BFu9i) C1{ Fc:0 FL:31 Fi:9}



static void Test_BFu0c_BFu31ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu9i, BFu0c_BFu31ll_BFu9i)
//============================================================================


struct  BFu0c_BFu31ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu31ll_BFu9ll) C1{ Fc:0 FL:31 FL:9}



static void Test_BFu0c_BFu31ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu0c_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu9ll, BFu0c_BFu31ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu31ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu31ll_BFu9s) C1{ Fc:0 FL:31 Fs:9}



static void Test_BFu0c_BFu31ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu31ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_BFu9s, BFu0c_BFu31ll_BFu9s)
//============================================================================


struct  BFu0c_BFu31ll_C  {
  unsigned char  :0;
  __tsu64 v1:31;
  char v2;
};
//SIG(1 BFu0c_BFu31ll_C) C1{ Fc:0 FL:31 Fc}



static void Test_BFu0c_BFu31ll_C()
{
  {
    init_simple_test("BFu0c_BFu31ll_C");
    static STRUCT_IF_C BFu0c_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_C");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_C, BFu0c_BFu31ll_C)
//============================================================================


struct  BFu0c_BFu31ll_D  {
  unsigned char  :0;
  __tsu64 v1:31;
  double v2;
};
//SIG(1 BFu0c_BFu31ll_D) C1{ Fc:0 FL:31 FL}



static void Test_BFu0c_BFu31ll_D()
{
  {
    init_simple_test("BFu0c_BFu31ll_D");
    static STRUCT_IF_C BFu0c_BFu31ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_D, BFu0c_BFu31ll_D)
//============================================================================


struct  BFu0c_BFu31ll_F  {
  unsigned char  :0;
  __tsu64 v1:31;
  float v2;
};
//SIG(1 BFu0c_BFu31ll_F) C1{ Fc:0 FL:31 Fi}



static void Test_BFu0c_BFu31ll_F()
{
  {
    init_simple_test("BFu0c_BFu31ll_F");
    static STRUCT_IF_C BFu0c_BFu31ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_F, BFu0c_BFu31ll_F)
//============================================================================


struct  BFu0c_BFu31ll_I  {
  unsigned char  :0;
  __tsu64 v1:31;
  int v2;
};
//SIG(1 BFu0c_BFu31ll_I) C1{ Fc:0 FL:31 Fi}



static void Test_BFu0c_BFu31ll_I()
{
  {
    init_simple_test("BFu0c_BFu31ll_I");
    static STRUCT_IF_C BFu0c_BFu31ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_I, BFu0c_BFu31ll_I)
//============================================================================


struct  BFu0c_BFu31ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:31;
  int *v2;
};
//SIG(1 BFu0c_BFu31ll_Ip) C1{ Fc:0 FL:31 Fp}



static void Test_BFu0c_BFu31ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu31ll_Ip");
    static STRUCT_IF_C BFu0c_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Ip, BFu0c_BFu31ll_Ip)
//============================================================================


struct  BFu0c_BFu31ll_L  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu31ll_L) C1{ Fc:0 FL:31 FL}



static void Test_BFu0c_BFu31ll_L()
{
  {
    init_simple_test("BFu0c_BFu31ll_L");
    static STRUCT_IF_C BFu0c_BFu31ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_L, BFu0c_BFu31ll_L)
//============================================================================


struct  BFu0c_BFu31ll_S  {
  unsigned char  :0;
  __tsu64 v1:31;
  short v2;
};
//SIG(1 BFu0c_BFu31ll_S) C1{ Fc:0 FL:31 Fs}



static void Test_BFu0c_BFu31ll_S()
{
  {
    init_simple_test("BFu0c_BFu31ll_S");
    static STRUCT_IF_C BFu0c_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_S");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_S, BFu0c_BFu31ll_S)
//============================================================================


struct  BFu0c_BFu31ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu31ll_Uc) C1{ Fc:0 FL:31 Fc}



static void Test_BFu0c_BFu31ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu31ll_Uc");
    static STRUCT_IF_C BFu0c_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Uc");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Uc, BFu0c_BFu31ll_Uc)
//============================================================================


struct  BFu0c_BFu31ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu31ll_Ui) C1{ Fc:0 FL:31 Fi}



static void Test_BFu0c_BFu31ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu31ll_Ui");
    static STRUCT_IF_C BFu0c_BFu31ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Ui, BFu0c_BFu31ll_Ui)
//============================================================================


struct  BFu0c_BFu31ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:31;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu31ll_Ul) C1{ Fc:0 FL:31 FL}



static void Test_BFu0c_BFu31ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu31ll_Ul");
    static STRUCT_IF_C BFu0c_BFu31ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Ul, BFu0c_BFu31ll_Ul)
//============================================================================


struct  BFu0c_BFu31ll_Us  {
  unsigned char  :0;
  __tsu64 v1:31;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu31ll_Us) C1{ Fc:0 FL:31 Fs}



static void Test_BFu0c_BFu31ll_Us()
{
  {
    init_simple_test("BFu0c_BFu31ll_Us");
    static STRUCT_IF_C BFu0c_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Us");
    check_field_offset(lv, v2, 4, "BFu0c_BFu31ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Us, BFu0c_BFu31ll_Us)
//============================================================================


struct  BFu0c_BFu31ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:31;
  void *v2;
};
//SIG(1 BFu0c_BFu31ll_Vp) C1{ Fc:0 FL:31 Fp}



static void Test_BFu0c_BFu31ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu31ll_Vp");
    static STRUCT_IF_C BFu0c_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu31ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0c_BFu31ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu31ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu31ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu31ll_Vp, BFu0c_BFu31ll_Vp)
//============================================================================


struct  BFu0c_BFu32i  {
  unsigned char  :0;
  unsigned int v1:32;
};
//SIG(1 BFu0c_BFu32i) C1{ Fc:0 Fi:32}



static void Test_BFu0c_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu32i");
    static STRUCT_IF_C BFu0c_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i, BFu0c_BFu32i)
//============================================================================


struct  BFu0c_BFu32i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu32i_BFu0c) C1{ Fc:0 Fi:32 Fc:0}



static void Test_BFu0c_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu32i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu0c, BFu0c_BFu32i_BFu0c)
//============================================================================


struct  BFu0c_BFu32i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu32i_BFu0i) C1{ Fc:0 Fi:32 Fi:0}



static void Test_BFu0c_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu0i, BFu0c_BFu32i_BFu0i)
//============================================================================


struct  BFu0c_BFu32i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu32i_BFu0ll) C1{ Fc:0 Fi:32 FL:0}



static void Test_BFu0c_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu0ll, BFu0c_BFu32i_BFu0ll)
//============================================================================


struct  BFu0c_BFu32i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu32i_BFu0s) C1{ Fc:0 Fi:32 Fs:0}



static void Test_BFu0c_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu0s, BFu0c_BFu32i_BFu0s)
//============================================================================


struct  BFu0c_BFu32i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu32i_BFu15i) C1{ Fc:0 Fi:32 Fi:15}



static void Test_BFu0c_BFu32i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu15i, BFu0c_BFu32i_BFu15i)
//============================================================================


struct  BFu0c_BFu32i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu32i_BFu15ll) C1{ Fc:0 Fi:32 FL:15}



static void Test_BFu0c_BFu32i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu15ll, BFu0c_BFu32i_BFu15ll)
//============================================================================


struct  BFu0c_BFu32i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu32i_BFu15s) C1{ Fc:0 Fi:32 Fs:15}



static void Test_BFu0c_BFu32i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu15s, BFu0c_BFu32i_BFu15s)
//============================================================================


struct  BFu0c_BFu32i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu32i_BFu16i) C1{ Fc:0 Fi:32 Fi:16}



static void Test_BFu0c_BFu32i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu16i, BFu0c_BFu32i_BFu16i)
//============================================================================


struct  BFu0c_BFu32i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu32i_BFu16ll) C1{ Fc:0 Fi:32 FL:16}



static void Test_BFu0c_BFu32i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu16ll, BFu0c_BFu32i_BFu16ll)
//============================================================================


struct  BFu0c_BFu32i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu32i_BFu16s) C1{ Fc:0 Fi:32 Fs:16}



static void Test_BFu0c_BFu32i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu16s, BFu0c_BFu32i_BFu16s)
//============================================================================


struct  BFu0c_BFu32i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu32i_BFu17i) C1{ Fc:0 Fi:32 Fi:17}



static void Test_BFu0c_BFu32i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu17i, BFu0c_BFu32i_BFu17i)
//============================================================================


struct  BFu0c_BFu32i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu32i_BFu17ll) C1{ Fc:0 Fi:32 FL:17}



static void Test_BFu0c_BFu32i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu17ll, BFu0c_BFu32i_BFu17ll)
//============================================================================


struct  BFu0c_BFu32i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu32i_BFu1c) C1{ Fc:0 Fi:32 Fc:1}



static void Test_BFu0c_BFu32i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu32i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu1c, BFu0c_BFu32i_BFu1c)
//============================================================================


struct  BFu0c_BFu32i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu32i_BFu1i) C1{ Fc:0 Fi:32 Fi:1}



static void Test_BFu0c_BFu32i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu1i, BFu0c_BFu32i_BFu1i)
//============================================================================


struct  BFu0c_BFu32i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu32i_BFu1ll) C1{ Fc:0 Fi:32 FL:1}



static void Test_BFu0c_BFu32i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu1ll, BFu0c_BFu32i_BFu1ll)
//============================================================================


struct  BFu0c_BFu32i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu32i_BFu1s) C1{ Fc:0 Fi:32 Fs:1}



static void Test_BFu0c_BFu32i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu1s, BFu0c_BFu32i_BFu1s)
//============================================================================


struct  BFu0c_BFu32i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu32i_BFu31i) C1{ Fc:0 Fi:32 Fi:31}



static void Test_BFu0c_BFu32i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu31i, BFu0c_BFu32i_BFu31i)
//============================================================================


struct  BFu0c_BFu32i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu32i_BFu31ll) C1{ Fc:0 Fi:32 FL:31}



static void Test_BFu0c_BFu32i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu31ll, BFu0c_BFu32i_BFu31ll)
//============================================================================


struct  BFu0c_BFu32i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu32i_BFu32i) C1{ Fc:0 Fi:32 Fi:32}



static void Test_BFu0c_BFu32i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu32i, BFu0c_BFu32i_BFu32i)
//============================================================================


struct  BFu0c_BFu32i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu32i_BFu32ll) C1{ Fc:0 Fi:32 FL:32}



static void Test_BFu0c_BFu32i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu32ll, BFu0c_BFu32i_BFu32ll)
//============================================================================


struct  BFu0c_BFu32i_BFu33  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu32i_BFu33) C1{ Fc:0 Fi:32 FL:33}



static void Test_BFu0c_BFu32i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu33");
    static STRUCT_IF_C BFu0c_BFu32i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0c_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0c_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu33, BFu0c_BFu32i_BFu33)
//============================================================================


struct  BFu0c_BFu32i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu32i_BFu7c) C1{ Fc:0 Fi:32 Fc:7}



static void Test_BFu0c_BFu32i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu32i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu7c, BFu0c_BFu32i_BFu7c)
//============================================================================


struct  BFu0c_BFu32i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu32i_BFu7i) C1{ Fc:0 Fi:32 Fi:7}



static void Test_BFu0c_BFu32i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu7i, BFu0c_BFu32i_BFu7i)
//============================================================================


struct  BFu0c_BFu32i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu32i_BFu7ll) C1{ Fc:0 Fi:32 FL:7}



static void Test_BFu0c_BFu32i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu7ll, BFu0c_BFu32i_BFu7ll)
//============================================================================


struct  BFu0c_BFu32i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu32i_BFu7s) C1{ Fc:0 Fi:32 Fs:7}



static void Test_BFu0c_BFu32i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu7s, BFu0c_BFu32i_BFu7s)
//============================================================================


struct  BFu0c_BFu32i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu32i_BFu8c) C1{ Fc:0 Fi:32 Fc:8}



static void Test_BFu0c_BFu32i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu32i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu8c, BFu0c_BFu32i_BFu8c)
//============================================================================


struct  BFu0c_BFu32i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu32i_BFu8i) C1{ Fc:0 Fi:32 Fi:8}



static void Test_BFu0c_BFu32i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu8i, BFu0c_BFu32i_BFu8i)
//============================================================================


struct  BFu0c_BFu32i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu32i_BFu8ll) C1{ Fc:0 Fi:32 FL:8}



static void Test_BFu0c_BFu32i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu8ll, BFu0c_BFu32i_BFu8ll)
//============================================================================


struct  BFu0c_BFu32i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu32i_BFu8s) C1{ Fc:0 Fi:32 Fs:8}



static void Test_BFu0c_BFu32i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu8s, BFu0c_BFu32i_BFu8s)
//============================================================================


struct  BFu0c_BFu32i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu32i_BFu9i) C1{ Fc:0 Fi:32 Fi:9}



static void Test_BFu0c_BFu32i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu32i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu9i, BFu0c_BFu32i_BFu9i)
//============================================================================


struct  BFu0c_BFu32i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu32i_BFu9ll) C1{ Fc:0 Fi:32 FL:9}



static void Test_BFu0c_BFu32i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu9ll, BFu0c_BFu32i_BFu9ll)
//============================================================================


struct  BFu0c_BFu32i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu32i_BFu9s) C1{ Fc:0 Fi:32 Fs:9}



static void Test_BFu0c_BFu32i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu32i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu32i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_BFu9s, BFu0c_BFu32i_BFu9s)
//============================================================================


struct  BFu0c_BFu32i_C  {
  unsigned char  :0;
  unsigned int v1:32;
  char v2;
};
//SIG(1 BFu0c_BFu32i_C) C1{ Fc:0 Fi:32 Fc}



static void Test_BFu0c_BFu32i_C()
{
  {
    init_simple_test("BFu0c_BFu32i_C");
    static STRUCT_IF_C BFu0c_BFu32i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_C)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_C");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_C");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_C, BFu0c_BFu32i_C)
//============================================================================


struct  BFu0c_BFu32i_D  {
  unsigned char  :0;
  unsigned int v1:32;
  double v2;
};
//SIG(1 BFu0c_BFu32i_D) C1{ Fc:0 Fi:32 FL}



static void Test_BFu0c_BFu32i_D()
{
  {
    init_simple_test("BFu0c_BFu32i_D");
    static STRUCT_IF_C BFu0c_BFu32i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_D)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_D");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_D, BFu0c_BFu32i_D)
//============================================================================


struct  BFu0c_BFu32i_F  {
  unsigned char  :0;
  unsigned int v1:32;
  float v2;
};
//SIG(1 BFu0c_BFu32i_F) C1{ Fc:0 Fi:32 Fi}



static void Test_BFu0c_BFu32i_F()
{
  {
    init_simple_test("BFu0c_BFu32i_F");
    static STRUCT_IF_C BFu0c_BFu32i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_F)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_F");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_F, BFu0c_BFu32i_F)
//============================================================================


struct  BFu0c_BFu32i_I  {
  unsigned char  :0;
  unsigned int v1:32;
  int v2;
};
//SIG(1 BFu0c_BFu32i_I) C1{ Fc:0 Fi:32 Fi}



static void Test_BFu0c_BFu32i_I()
{
  {
    init_simple_test("BFu0c_BFu32i_I");
    static STRUCT_IF_C BFu0c_BFu32i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_I)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_I");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_I, BFu0c_BFu32i_I)
//============================================================================


struct  BFu0c_BFu32i_Ip  {
  unsigned char  :0;
  unsigned int v1:32;
  int *v2;
};
//SIG(1 BFu0c_BFu32i_Ip) C1{ Fc:0 Fi:32 Fp}



static void Test_BFu0c_BFu32i_Ip()
{
  {
    init_simple_test("BFu0c_BFu32i_Ip");
    static STRUCT_IF_C BFu0c_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Ip, BFu0c_BFu32i_Ip)
//============================================================================


struct  BFu0c_BFu32i_L  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu32i_L) C1{ Fc:0 Fi:32 FL}



static void Test_BFu0c_BFu32i_L()
{
  {
    init_simple_test("BFu0c_BFu32i_L");
    static STRUCT_IF_C BFu0c_BFu32i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_L)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_L");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_L, BFu0c_BFu32i_L)
//============================================================================


struct  BFu0c_BFu32i_S  {
  unsigned char  :0;
  unsigned int v1:32;
  short v2;
};
//SIG(1 BFu0c_BFu32i_S) C1{ Fc:0 Fi:32 Fs}



static void Test_BFu0c_BFu32i_S()
{
  {
    init_simple_test("BFu0c_BFu32i_S");
    static STRUCT_IF_C BFu0c_BFu32i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_S)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_S");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_S");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_S, BFu0c_BFu32i_S)
//============================================================================


struct  BFu0c_BFu32i_Uc  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu32i_Uc) C1{ Fc:0 Fi:32 Fc}



static void Test_BFu0c_BFu32i_Uc()
{
  {
    init_simple_test("BFu0c_BFu32i_Uc");
    static STRUCT_IF_C BFu0c_BFu32i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Uc");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Uc, BFu0c_BFu32i_Uc)
//============================================================================


struct  BFu0c_BFu32i_Ui  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu32i_Ui) C1{ Fc:0 Fi:32 Fi}



static void Test_BFu0c_BFu32i_Ui()
{
  {
    init_simple_test("BFu0c_BFu32i_Ui");
    static STRUCT_IF_C BFu0c_BFu32i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Ui, BFu0c_BFu32i_Ui)
//============================================================================


struct  BFu0c_BFu32i_Ul  {
  unsigned char  :0;
  unsigned int v1:32;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu32i_Ul) C1{ Fc:0 Fi:32 FL}



static void Test_BFu0c_BFu32i_Ul()
{
  {
    init_simple_test("BFu0c_BFu32i_Ul");
    static STRUCT_IF_C BFu0c_BFu32i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Ul, BFu0c_BFu32i_Ul)
//============================================================================


struct  BFu0c_BFu32i_Us  {
  unsigned char  :0;
  unsigned int v1:32;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu32i_Us) C1{ Fc:0 Fi:32 Fs}



static void Test_BFu0c_BFu32i_Us()
{
  {
    init_simple_test("BFu0c_BFu32i_Us");
    static STRUCT_IF_C BFu0c_BFu32i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu32i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Us");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Us");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Us, BFu0c_BFu32i_Us)
//============================================================================


struct  BFu0c_BFu32i_Vp  {
  unsigned char  :0;
  unsigned int v1:32;
  void *v2;
};
//SIG(1 BFu0c_BFu32i_Vp) C1{ Fc:0 Fi:32 Fp}



static void Test_BFu0c_BFu32i_Vp()
{
  {
    init_simple_test("BFu0c_BFu32i_Vp");
    static STRUCT_IF_C BFu0c_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32i_Vp, BFu0c_BFu32i_Vp)
//============================================================================


struct  BFu0c_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:32;
};
//SIG(1 BFu0c_BFu32ll) C1{ Fc:0 FL:32}



static void Test_BFu0c_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll, BFu0c_BFu32ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu32ll_BFu0c) C1{ Fc:0 FL:32 Fc:0}



static void Test_BFu0c_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu0c, BFu0c_BFu32ll_BFu0c)
//============================================================================


struct  BFu0c_BFu32ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu32ll_BFu0i) C1{ Fc:0 FL:32 Fi:0}



static void Test_BFu0c_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu0i, BFu0c_BFu32ll_BFu0i)
//============================================================================


struct  BFu0c_BFu32ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu32ll_BFu0ll) C1{ Fc:0 FL:32 FL:0}



static void Test_BFu0c_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu0ll, BFu0c_BFu32ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu32ll_BFu0s) C1{ Fc:0 FL:32 Fs:0}



static void Test_BFu0c_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu0s, BFu0c_BFu32ll_BFu0s)
//============================================================================


struct  BFu0c_BFu32ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu32ll_BFu15i) C1{ Fc:0 FL:32 Fi:15}



static void Test_BFu0c_BFu32ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu15i, BFu0c_BFu32ll_BFu15i)
//============================================================================


struct  BFu0c_BFu32ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu32ll_BFu15ll) C1{ Fc:0 FL:32 FL:15}



static void Test_BFu0c_BFu32ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu15ll, BFu0c_BFu32ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu32ll_BFu15s) C1{ Fc:0 FL:32 Fs:15}



static void Test_BFu0c_BFu32ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0c_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu15s, BFu0c_BFu32ll_BFu15s)
//============================================================================


struct  BFu0c_BFu32ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu32ll_BFu16i) C1{ Fc:0 FL:32 Fi:16}



static void Test_BFu0c_BFu32ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu16i, BFu0c_BFu32ll_BFu16i)
//============================================================================


struct  BFu0c_BFu32ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu32ll_BFu16ll) C1{ Fc:0 FL:32 FL:16}



static void Test_BFu0c_BFu32ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu16ll, BFu0c_BFu32ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu32ll_BFu16s) C1{ Fc:0 FL:32 Fs:16}



static void Test_BFu0c_BFu32ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0c_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu16s, BFu0c_BFu32ll_BFu16s)
//============================================================================


struct  BFu0c_BFu32ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu32ll_BFu17i) C1{ Fc:0 FL:32 Fi:17}



static void Test_BFu0c_BFu32ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu17i, BFu0c_BFu32ll_BFu17i)
//============================================================================


struct  BFu0c_BFu32ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu32ll_BFu17ll) C1{ Fc:0 FL:32 FL:17}



static void Test_BFu0c_BFu32ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0c_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu17ll, BFu0c_BFu32ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu32ll_BFu1c) C1{ Fc:0 FL:32 Fc:1}



static void Test_BFu0c_BFu32ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu1c, BFu0c_BFu32ll_BFu1c)
//============================================================================


struct  BFu0c_BFu32ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu32ll_BFu1i) C1{ Fc:0 FL:32 Fi:1}



static void Test_BFu0c_BFu32ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu1i, BFu0c_BFu32ll_BFu1i)
//============================================================================


struct  BFu0c_BFu32ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu32ll_BFu1ll) C1{ Fc:0 FL:32 FL:1}



static void Test_BFu0c_BFu32ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu1ll, BFu0c_BFu32ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu32ll_BFu1s) C1{ Fc:0 FL:32 Fs:1}



static void Test_BFu0c_BFu32ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0c_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu1s, BFu0c_BFu32ll_BFu1s)
//============================================================================


struct  BFu0c_BFu32ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu32ll_BFu31i) C1{ Fc:0 FL:32 Fi:31}



static void Test_BFu0c_BFu32ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu31i, BFu0c_BFu32ll_BFu31i)
//============================================================================


struct  BFu0c_BFu32ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu32ll_BFu31ll) C1{ Fc:0 FL:32 FL:31}



static void Test_BFu0c_BFu32ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu31ll, BFu0c_BFu32ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu32ll_BFu32i) C1{ Fc:0 FL:32 Fi:32}



static void Test_BFu0c_BFu32ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu32i, BFu0c_BFu32ll_BFu32i)
//============================================================================


struct  BFu0c_BFu32ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu32ll_BFu32ll) C1{ Fc:0 FL:32 FL:32}



static void Test_BFu0c_BFu32ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu32ll, BFu0c_BFu32ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu32ll_BFu33) C1{ Fc:0 FL:32 FL:33}



static void Test_BFu0c_BFu32ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0c_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0c_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu33, BFu0c_BFu32ll_BFu33)
//============================================================================


struct  BFu0c_BFu32ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu32ll_BFu7c) C1{ Fc:0 FL:32 Fc:7}



static void Test_BFu0c_BFu32ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu7c, BFu0c_BFu32ll_BFu7c)
//============================================================================


struct  BFu0c_BFu32ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu32ll_BFu7i) C1{ Fc:0 FL:32 Fi:7}



static void Test_BFu0c_BFu32ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu7i, BFu0c_BFu32ll_BFu7i)
//============================================================================


struct  BFu0c_BFu32ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu32ll_BFu7ll) C1{ Fc:0 FL:32 FL:7}



static void Test_BFu0c_BFu32ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu7ll, BFu0c_BFu32ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu32ll_BFu7s) C1{ Fc:0 FL:32 Fs:7}



static void Test_BFu0c_BFu32ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0c_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu7s, BFu0c_BFu32ll_BFu7s)
//============================================================================


struct  BFu0c_BFu32ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu32ll_BFu8c) C1{ Fc:0 FL:32 Fc:8}



static void Test_BFu0c_BFu32ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu8c, BFu0c_BFu32ll_BFu8c)
//============================================================================


struct  BFu0c_BFu32ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu32ll_BFu8i) C1{ Fc:0 FL:32 Fi:8}



static void Test_BFu0c_BFu32ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu8i, BFu0c_BFu32ll_BFu8i)
//============================================================================


struct  BFu0c_BFu32ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu32ll_BFu8ll) C1{ Fc:0 FL:32 FL:8}



static void Test_BFu0c_BFu32ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu8ll, BFu0c_BFu32ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu32ll_BFu8s) C1{ Fc:0 FL:32 Fs:8}



static void Test_BFu0c_BFu32ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0c_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu8s, BFu0c_BFu32ll_BFu8s)
//============================================================================


struct  BFu0c_BFu32ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu32ll_BFu9i) C1{ Fc:0 FL:32 Fi:9}



static void Test_BFu0c_BFu32ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu9i, BFu0c_BFu32ll_BFu9i)
//============================================================================


struct  BFu0c_BFu32ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu32ll_BFu9ll) C1{ Fc:0 FL:32 FL:9}



static void Test_BFu0c_BFu32ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu9ll, BFu0c_BFu32ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu32ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu32ll_BFu9s) C1{ Fc:0 FL:32 Fs:9}



static void Test_BFu0c_BFu32ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu32ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0c_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_BFu9s, BFu0c_BFu32ll_BFu9s)
//============================================================================


struct  BFu0c_BFu32ll_C  {
  unsigned char  :0;
  __tsu64 v1:32;
  char v2;
};
//SIG(1 BFu0c_BFu32ll_C) C1{ Fc:0 FL:32 Fc}



static void Test_BFu0c_BFu32ll_C()
{
  {
    init_simple_test("BFu0c_BFu32ll_C");
    static STRUCT_IF_C BFu0c_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_C");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_C");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_C, BFu0c_BFu32ll_C)
//============================================================================


struct  BFu0c_BFu32ll_D  {
  unsigned char  :0;
  __tsu64 v1:32;
  double v2;
};
//SIG(1 BFu0c_BFu32ll_D) C1{ Fc:0 FL:32 FL}



static void Test_BFu0c_BFu32ll_D()
{
  {
    init_simple_test("BFu0c_BFu32ll_D");
    static STRUCT_IF_C BFu0c_BFu32ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_D");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_D, BFu0c_BFu32ll_D)
//============================================================================


struct  BFu0c_BFu32ll_F  {
  unsigned char  :0;
  __tsu64 v1:32;
  float v2;
};
//SIG(1 BFu0c_BFu32ll_F) C1{ Fc:0 FL:32 Fi}



static void Test_BFu0c_BFu32ll_F()
{
  {
    init_simple_test("BFu0c_BFu32ll_F");
    static STRUCT_IF_C BFu0c_BFu32ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_F");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_F, BFu0c_BFu32ll_F)
//============================================================================


struct  BFu0c_BFu32ll_I  {
  unsigned char  :0;
  __tsu64 v1:32;
  int v2;
};
//SIG(1 BFu0c_BFu32ll_I) C1{ Fc:0 FL:32 Fi}



static void Test_BFu0c_BFu32ll_I()
{
  {
    init_simple_test("BFu0c_BFu32ll_I");
    static STRUCT_IF_C BFu0c_BFu32ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_I");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_I, BFu0c_BFu32ll_I)
//============================================================================


struct  BFu0c_BFu32ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:32;
  int *v2;
};
//SIG(1 BFu0c_BFu32ll_Ip) C1{ Fc:0 FL:32 Fp}



static void Test_BFu0c_BFu32ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu32ll_Ip");
    static STRUCT_IF_C BFu0c_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Ip, BFu0c_BFu32ll_Ip)
//============================================================================


struct  BFu0c_BFu32ll_L  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu32ll_L) C1{ Fc:0 FL:32 FL}



static void Test_BFu0c_BFu32ll_L()
{
  {
    init_simple_test("BFu0c_BFu32ll_L");
    static STRUCT_IF_C BFu0c_BFu32ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_L");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_L, BFu0c_BFu32ll_L)
//============================================================================


struct  BFu0c_BFu32ll_S  {
  unsigned char  :0;
  __tsu64 v1:32;
  short v2;
};
//SIG(1 BFu0c_BFu32ll_S) C1{ Fc:0 FL:32 Fs}



static void Test_BFu0c_BFu32ll_S()
{
  {
    init_simple_test("BFu0c_BFu32ll_S");
    static STRUCT_IF_C BFu0c_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_S");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_S");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_S, BFu0c_BFu32ll_S)
//============================================================================


struct  BFu0c_BFu32ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu32ll_Uc) C1{ Fc:0 FL:32 Fc}



static void Test_BFu0c_BFu32ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu32ll_Uc");
    static STRUCT_IF_C BFu0c_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Uc");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Uc, BFu0c_BFu32ll_Uc)
//============================================================================


struct  BFu0c_BFu32ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu32ll_Ui) C1{ Fc:0 FL:32 Fi}



static void Test_BFu0c_BFu32ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu32ll_Ui");
    static STRUCT_IF_C BFu0c_BFu32ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Ui, BFu0c_BFu32ll_Ui)
//============================================================================


struct  BFu0c_BFu32ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:32;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu32ll_Ul) C1{ Fc:0 FL:32 FL}



static void Test_BFu0c_BFu32ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu32ll_Ul");
    static STRUCT_IF_C BFu0c_BFu32ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Ul, BFu0c_BFu32ll_Ul)
//============================================================================


struct  BFu0c_BFu32ll_Us  {
  unsigned char  :0;
  __tsu64 v1:32;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu32ll_Us) C1{ Fc:0 FL:32 Fs}



static void Test_BFu0c_BFu32ll_Us()
{
  {
    init_simple_test("BFu0c_BFu32ll_Us");
    static STRUCT_IF_C BFu0c_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Us");
    check_field_offset(lv, v2, 4, "BFu0c_BFu32ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Us, BFu0c_BFu32ll_Us)
//============================================================================


struct  BFu0c_BFu32ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:32;
  void *v2;
};
//SIG(1 BFu0c_BFu32ll_Vp) C1{ Fc:0 FL:32 Fp}



static void Test_BFu0c_BFu32ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu32ll_Vp");
    static STRUCT_IF_C BFu0c_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu32ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0c_BFu32ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu32ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu32ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu32ll_Vp, BFu0c_BFu32ll_Vp)
//============================================================================


struct  BFu0c_BFu33  {
  unsigned char  :0;
  __tsu64 v1:33;
};
//SIG(1 BFu0c_BFu33) C1{ Fc:0 FL:33}



static void Test_BFu0c_BFu33()
{
  {
    init_simple_test("BFu0c_BFu33");
    static STRUCT_IF_C BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33, BFu0c_BFu33)
//============================================================================


struct  BFu0c_BFu33_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu33_BFu0c) C1{ Fc:0 FL:33 Fc:0}



static void Test_BFu0c_BFu33_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu33_BFu0c");
    static STRUCT_IF_C BFu0c_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu0c, BFu0c_BFu33_BFu0c)
//============================================================================


struct  BFu0c_BFu33_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu33_BFu0i) C1{ Fc:0 FL:33 Fi:0}



static void Test_BFu0c_BFu33_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu0i");
    static STRUCT_IF_C BFu0c_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu0i, BFu0c_BFu33_BFu0i)
//============================================================================


struct  BFu0c_BFu33_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu33_BFu0ll) C1{ Fc:0 FL:33 FL:0}



static void Test_BFu0c_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu0ll, BFu0c_BFu33_BFu0ll)
//============================================================================


struct  BFu0c_BFu33_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu33_BFu0s) C1{ Fc:0 FL:33 Fs:0}



static void Test_BFu0c_BFu33_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu0s");
    static STRUCT_IF_C BFu0c_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu0s, BFu0c_BFu33_BFu0s)
//============================================================================


struct  BFu0c_BFu33_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu33_BFu15i) C1{ Fc:0 FL:33 Fi:15}



static void Test_BFu0c_BFu33_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu15i");
    static STRUCT_IF_C BFu0c_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu0c_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu15i, BFu0c_BFu33_BFu15i)
//============================================================================


struct  BFu0c_BFu33_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu33_BFu15ll) C1{ Fc:0 FL:33 FL:15}



static void Test_BFu0c_BFu33_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu0c_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu15ll, BFu0c_BFu33_BFu15ll)
//============================================================================


struct  BFu0c_BFu33_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu33_BFu15s) C1{ Fc:0 FL:33 Fs:15}



static void Test_BFu0c_BFu33_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu15s");
    static STRUCT_IF_C BFu0c_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu0c_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu15s, BFu0c_BFu33_BFu15s)
//============================================================================


struct  BFu0c_BFu33_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu33_BFu16i) C1{ Fc:0 FL:33 Fi:16}



static void Test_BFu0c_BFu33_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu16i");
    static STRUCT_IF_C BFu0c_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu0c_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu16i, BFu0c_BFu33_BFu16i)
//============================================================================


struct  BFu0c_BFu33_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu33_BFu16ll) C1{ Fc:0 FL:33 FL:16}



static void Test_BFu0c_BFu33_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu0c_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu16ll, BFu0c_BFu33_BFu16ll)
//============================================================================


struct  BFu0c_BFu33_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu33_BFu16s) C1{ Fc:0 FL:33 Fs:16}



static void Test_BFu0c_BFu33_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu16s");
    static STRUCT_IF_C BFu0c_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu0c_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu16s, BFu0c_BFu33_BFu16s)
//============================================================================


struct  BFu0c_BFu33_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu33_BFu17i) C1{ Fc:0 FL:33 Fi:17}



static void Test_BFu0c_BFu33_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu17i");
    static STRUCT_IF_C BFu0c_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu0c_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu17i, BFu0c_BFu33_BFu17i)
//============================================================================


struct  BFu0c_BFu33_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu33_BFu17ll) C1{ Fc:0 FL:33 FL:17}



static void Test_BFu0c_BFu33_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu0c_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu17ll, BFu0c_BFu33_BFu17ll)
//============================================================================


struct  BFu0c_BFu33_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu33_BFu1c) C1{ Fc:0 FL:33 Fc:1}



static void Test_BFu0c_BFu33_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu33_BFu1c");
    static STRUCT_IF_C BFu0c_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0c_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu1c, BFu0c_BFu33_BFu1c)
//============================================================================


struct  BFu0c_BFu33_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu33_BFu1i) C1{ Fc:0 FL:33 Fi:1}



static void Test_BFu0c_BFu33_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu1i");
    static STRUCT_IF_C BFu0c_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0c_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu1i, BFu0c_BFu33_BFu1i)
//============================================================================


struct  BFu0c_BFu33_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu33_BFu1ll) C1{ Fc:0 FL:33 FL:1}



static void Test_BFu0c_BFu33_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0c_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu1ll, BFu0c_BFu33_BFu1ll)
//============================================================================


struct  BFu0c_BFu33_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu33_BFu1s) C1{ Fc:0 FL:33 Fs:1}



static void Test_BFu0c_BFu33_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu1s");
    static STRUCT_IF_C BFu0c_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0c_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu1s, BFu0c_BFu33_BFu1s)
//============================================================================


struct  BFu0c_BFu33_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu33_BFu31i) C1{ Fc:0 FL:33 Fi:31}



static void Test_BFu0c_BFu33_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu31i");
    static STRUCT_IF_C BFu0c_BFu33_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu0c_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu31i, BFu0c_BFu33_BFu31i)
//============================================================================


struct  BFu0c_BFu33_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu33_BFu31ll) C1{ Fc:0 FL:33 FL:31}



static void Test_BFu0c_BFu33_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu0c_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu31ll, BFu0c_BFu33_BFu31ll)
//============================================================================


struct  BFu0c_BFu33_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu33_BFu32i) C1{ Fc:0 FL:33 Fi:32}



static void Test_BFu0c_BFu33_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu32i");
    static STRUCT_IF_C BFu0c_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0c_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu32i, BFu0c_BFu33_BFu32i)
//============================================================================


struct  BFu0c_BFu33_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu33_BFu32ll) C1{ Fc:0 FL:33 FL:32}



static void Test_BFu0c_BFu33_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu0c_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu0c_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu32ll, BFu0c_BFu33_BFu32ll)
//============================================================================


struct  BFu0c_BFu33_BFu33  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu33_BFu33) C1{ Fc:0 FL:33 FL:33}



static void Test_BFu0c_BFu33_BFu33()
{
  {
    init_simple_test("BFu0c_BFu33_BFu33");
    static STRUCT_IF_C BFu0c_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu0c_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu33, BFu0c_BFu33_BFu33)
//============================================================================


struct  BFu0c_BFu33_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu33_BFu7c) C1{ Fc:0 FL:33 Fc:7}



static void Test_BFu0c_BFu33_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu33_BFu7c");
    static STRUCT_IF_C BFu0c_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0c_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu7c, BFu0c_BFu33_BFu7c)
//============================================================================


struct  BFu0c_BFu33_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu33_BFu7i) C1{ Fc:0 FL:33 Fi:7}



static void Test_BFu0c_BFu33_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu7i");
    static STRUCT_IF_C BFu0c_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0c_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu7i, BFu0c_BFu33_BFu7i)
//============================================================================


struct  BFu0c_BFu33_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu33_BFu7ll) C1{ Fc:0 FL:33 FL:7}



static void Test_BFu0c_BFu33_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0c_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu7ll, BFu0c_BFu33_BFu7ll)
//============================================================================


struct  BFu0c_BFu33_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu33_BFu7s) C1{ Fc:0 FL:33 Fs:7}



static void Test_BFu0c_BFu33_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu7s");
    static STRUCT_IF_C BFu0c_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0c_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu7s, BFu0c_BFu33_BFu7s)
//============================================================================


struct  BFu0c_BFu33_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu33_BFu8c) C1{ Fc:0 FL:33 Fc:8}



static void Test_BFu0c_BFu33_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu33_BFu8c");
    static STRUCT_IF_C BFu0c_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu0c_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu8c, BFu0c_BFu33_BFu8c)
//============================================================================


struct  BFu0c_BFu33_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu33_BFu8i) C1{ Fc:0 FL:33 Fi:8}



static void Test_BFu0c_BFu33_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu8i");
    static STRUCT_IF_C BFu0c_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu0c_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu8i, BFu0c_BFu33_BFu8i)
//============================================================================


struct  BFu0c_BFu33_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu33_BFu8ll) C1{ Fc:0 FL:33 FL:8}



static void Test_BFu0c_BFu33_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu0c_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu8ll, BFu0c_BFu33_BFu8ll)
//============================================================================


struct  BFu0c_BFu33_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu33_BFu8s) C1{ Fc:0 FL:33 Fs:8}



static void Test_BFu0c_BFu33_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu8s");
    static STRUCT_IF_C BFu0c_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu0c_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu8s, BFu0c_BFu33_BFu8s)
//============================================================================


struct  BFu0c_BFu33_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu33_BFu9i) C1{ Fc:0 FL:33 Fi:9}



static void Test_BFu0c_BFu33_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu33_BFu9i");
    static STRUCT_IF_C BFu0c_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu0c_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu9i, BFu0c_BFu33_BFu9i)
//============================================================================


struct  BFu0c_BFu33_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu33_BFu9ll) C1{ Fc:0 FL:33 FL:9}



static void Test_BFu0c_BFu33_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu33_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu0c_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu9ll, BFu0c_BFu33_BFu9ll)
//============================================================================


struct  BFu0c_BFu33_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu33_BFu9s) C1{ Fc:0 FL:33 Fs:9}



static void Test_BFu0c_BFu33_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu33_BFu9s");
    static STRUCT_IF_C BFu0c_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu0c_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_BFu9s, BFu0c_BFu33_BFu9s)
//============================================================================


struct  BFu0c_BFu33_C  {
  unsigned char  :0;
  __tsu64 v1:33;
  char v2;
};
//SIG(1 BFu0c_BFu33_C) C1{ Fc:0 FL:33 Fc}



static void Test_BFu0c_BFu33_C()
{
  {
    init_simple_test("BFu0c_BFu33_C");
    static STRUCT_IF_C BFu0c_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_C");
    check_field_offset(lv, v2, 5, "BFu0c_BFu33_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_C, BFu0c_BFu33_C)
//============================================================================


struct  BFu0c_BFu33_D  {
  unsigned char  :0;
  __tsu64 v1:33;
  double v2;
};
//SIG(1 BFu0c_BFu33_D) C1{ Fc:0 FL:33 FL}



static void Test_BFu0c_BFu33_D()
{
  {
    init_simple_test("BFu0c_BFu33_D");
    static STRUCT_IF_C BFu0c_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_D");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_D, BFu0c_BFu33_D)
//============================================================================


struct  BFu0c_BFu33_F  {
  unsigned char  :0;
  __tsu64 v1:33;
  float v2;
};
//SIG(1 BFu0c_BFu33_F) C1{ Fc:0 FL:33 Fi}



static void Test_BFu0c_BFu33_F()
{
  {
    init_simple_test("BFu0c_BFu33_F");
    static STRUCT_IF_C BFu0c_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_F");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_F, BFu0c_BFu33_F)
//============================================================================


struct  BFu0c_BFu33_I  {
  unsigned char  :0;
  __tsu64 v1:33;
  int v2;
};
//SIG(1 BFu0c_BFu33_I) C1{ Fc:0 FL:33 Fi}



static void Test_BFu0c_BFu33_I()
{
  {
    init_simple_test("BFu0c_BFu33_I");
    static STRUCT_IF_C BFu0c_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_I");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_I, BFu0c_BFu33_I)
//============================================================================


struct  BFu0c_BFu33_Ip  {
  unsigned char  :0;
  __tsu64 v1:33;
  int *v2;
};
//SIG(1 BFu0c_BFu33_Ip) C1{ Fc:0 FL:33 Fp}



static void Test_BFu0c_BFu33_Ip()
{
  {
    init_simple_test("BFu0c_BFu33_Ip");
    static STRUCT_IF_C BFu0c_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Ip");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Ip, BFu0c_BFu33_Ip)
//============================================================================


struct  BFu0c_BFu33_L  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu33_L) C1{ Fc:0 FL:33 FL}



static void Test_BFu0c_BFu33_L()
{
  {
    init_simple_test("BFu0c_BFu33_L");
    static STRUCT_IF_C BFu0c_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_L");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_L, BFu0c_BFu33_L)
//============================================================================


struct  BFu0c_BFu33_S  {
  unsigned char  :0;
  __tsu64 v1:33;
  short v2;
};
//SIG(1 BFu0c_BFu33_S) C1{ Fc:0 FL:33 Fs}



static void Test_BFu0c_BFu33_S()
{
  {
    init_simple_test("BFu0c_BFu33_S");
    static STRUCT_IF_C BFu0c_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_S");
    check_field_offset(lv, v2, 6, "BFu0c_BFu33_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_S, BFu0c_BFu33_S)
//============================================================================


struct  BFu0c_BFu33_Uc  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu33_Uc) C1{ Fc:0 FL:33 Fc}



static void Test_BFu0c_BFu33_Uc()
{
  {
    init_simple_test("BFu0c_BFu33_Uc");
    static STRUCT_IF_C BFu0c_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Uc");
    check_field_offset(lv, v2, 5, "BFu0c_BFu33_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Uc, BFu0c_BFu33_Uc)
//============================================================================


struct  BFu0c_BFu33_Ui  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu33_Ui) C1{ Fc:0 FL:33 Fi}



static void Test_BFu0c_BFu33_Ui()
{
  {
    init_simple_test("BFu0c_BFu33_Ui");
    static STRUCT_IF_C BFu0c_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Ui");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Ui, BFu0c_BFu33_Ui)
//============================================================================


struct  BFu0c_BFu33_Ul  {
  unsigned char  :0;
  __tsu64 v1:33;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu33_Ul) C1{ Fc:0 FL:33 FL}



static void Test_BFu0c_BFu33_Ul()
{
  {
    init_simple_test("BFu0c_BFu33_Ul");
    static STRUCT_IF_C BFu0c_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0c_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Ul");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Ul, BFu0c_BFu33_Ul)
//============================================================================


struct  BFu0c_BFu33_Us  {
  unsigned char  :0;
  __tsu64 v1:33;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu33_Us) C1{ Fc:0 FL:33 Fs}



static void Test_BFu0c_BFu33_Us()
{
  {
    init_simple_test("BFu0c_BFu33_Us");
    static STRUCT_IF_C BFu0c_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Us");
    check_field_offset(lv, v2, 6, "BFu0c_BFu33_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Us, BFu0c_BFu33_Us)
//============================================================================


struct  BFu0c_BFu33_Vp  {
  unsigned char  :0;
  __tsu64 v1:33;
  void *v2;
};
//SIG(1 BFu0c_BFu33_Vp) C1{ Fc:0 FL:33 Fp}



static void Test_BFu0c_BFu33_Vp()
{
  {
    init_simple_test("BFu0c_BFu33_Vp");
    static STRUCT_IF_C BFu0c_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu33_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0c_BFu33_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu33_Vp");
    check_field_offset(lv, v2, 8, "BFu0c_BFu33_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu33_Vp, BFu0c_BFu33_Vp)
//============================================================================


struct  BFu0c_BFu7c  {
  unsigned char  :0;
  unsigned char v1:7;
};
//SIG(1 BFu0c_BFu7c) C1{ Fc:0 Fc:7}



static void Test_BFu0c_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7c");
    static STRUCT_IF_C BFu0c_BFu7c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c, BFu0c_BFu7c)
//============================================================================


struct  BFu0c_BFu7c_BFu0c  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu7c_BFu0c) C1{ Fc:0 Fc:7 Fc:0}



static void Test_BFu0c_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu0c");
    static STRUCT_IF_C BFu0c_BFu7c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu0c, BFu0c_BFu7c_BFu0c)
//============================================================================


struct  BFu0c_BFu7c_BFu0i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu7c_BFu0i) C1{ Fc:0 Fc:7 Fi:0}



static void Test_BFu0c_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu0i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu0i, BFu0c_BFu7c_BFu0i)
//============================================================================


struct  BFu0c_BFu7c_BFu0ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu7c_BFu0ll) C1{ Fc:0 Fc:7 FL:0}



static void Test_BFu0c_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu0ll, BFu0c_BFu7c_BFu0ll)
//============================================================================


struct  BFu0c_BFu7c_BFu0s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu7c_BFu0s) C1{ Fc:0 Fc:7 Fs:0}



static void Test_BFu0c_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu0s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu0s, BFu0c_BFu7c_BFu0s)
//============================================================================


struct  BFu0c_BFu7c_BFu15i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu7c_BFu15i) C1{ Fc:0 Fc:7 Fi:15}



static void Test_BFu0c_BFu7c_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu15i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu15i, BFu0c_BFu7c_BFu15i)
//============================================================================


struct  BFu0c_BFu7c_BFu15ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu7c_BFu15ll) C1{ Fc:0 Fc:7 FL:15}



static void Test_BFu0c_BFu7c_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu15ll, BFu0c_BFu7c_BFu15ll)
//============================================================================


struct  BFu0c_BFu7c_BFu15s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu7c_BFu15s) C1{ Fc:0 Fc:7 Fs:15}



static void Test_BFu0c_BFu7c_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu15s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu15s, BFu0c_BFu7c_BFu15s)
//============================================================================


struct  BFu0c_BFu7c_BFu16i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu7c_BFu16i) C1{ Fc:0 Fc:7 Fi:16}



static void Test_BFu0c_BFu7c_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu16i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu16i, BFu0c_BFu7c_BFu16i)
//============================================================================


struct  BFu0c_BFu7c_BFu16ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu7c_BFu16ll) C1{ Fc:0 Fc:7 FL:16}



static void Test_BFu0c_BFu7c_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu16ll, BFu0c_BFu7c_BFu16ll)
//============================================================================


struct  BFu0c_BFu7c_BFu16s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu7c_BFu16s) C1{ Fc:0 Fc:7 Fs:16}



static void Test_BFu0c_BFu7c_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu16s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu16s, BFu0c_BFu7c_BFu16s)
//============================================================================


struct  BFu0c_BFu7c_BFu17i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu7c_BFu17i) C1{ Fc:0 Fc:7 Fi:17}



static void Test_BFu0c_BFu7c_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu17i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu17i, BFu0c_BFu7c_BFu17i)
//============================================================================


struct  BFu0c_BFu7c_BFu17ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu7c_BFu17ll) C1{ Fc:0 Fc:7 FL:17}



static void Test_BFu0c_BFu7c_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu17ll, BFu0c_BFu7c_BFu17ll)
//============================================================================


struct  BFu0c_BFu7c_BFu1c  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu7c_BFu1c) C1{ Fc:0 Fc:7 Fc:1}



static void Test_BFu0c_BFu7c_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu1c");
    static STRUCT_IF_C BFu0c_BFu7c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu1c, BFu0c_BFu7c_BFu1c)
//============================================================================


struct  BFu0c_BFu7c_BFu1i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu7c_BFu1i) C1{ Fc:0 Fc:7 Fi:1}



static void Test_BFu0c_BFu7c_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu1i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu1i, BFu0c_BFu7c_BFu1i)
//============================================================================


struct  BFu0c_BFu7c_BFu1ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu7c_BFu1ll) C1{ Fc:0 Fc:7 FL:1}



static void Test_BFu0c_BFu7c_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu1ll, BFu0c_BFu7c_BFu1ll)
//============================================================================


struct  BFu0c_BFu7c_BFu1s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu7c_BFu1s) C1{ Fc:0 Fc:7 Fs:1}



static void Test_BFu0c_BFu7c_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu1s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu1s, BFu0c_BFu7c_BFu1s)
//============================================================================


struct  BFu0c_BFu7c_BFu31i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu7c_BFu31i) C1{ Fc:0 Fc:7 Fi:31}



static void Test_BFu0c_BFu7c_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu31i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu31i, BFu0c_BFu7c_BFu31i)
//============================================================================


struct  BFu0c_BFu7c_BFu31ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu7c_BFu31ll) C1{ Fc:0 Fc:7 FL:31}



static void Test_BFu0c_BFu7c_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu31ll, BFu0c_BFu7c_BFu31ll)
//============================================================================


struct  BFu0c_BFu7c_BFu32i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu7c_BFu32i) C1{ Fc:0 Fc:7 Fi:32}



static void Test_BFu0c_BFu7c_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu32i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu32i, BFu0c_BFu7c_BFu32i)
//============================================================================


struct  BFu0c_BFu7c_BFu32ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu7c_BFu32ll) C1{ Fc:0 Fc:7 FL:32}



static void Test_BFu0c_BFu7c_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu32ll, BFu0c_BFu7c_BFu32ll)
//============================================================================


struct  BFu0c_BFu7c_BFu33  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu7c_BFu33) C1{ Fc:0 Fc:7 FL:33}



static void Test_BFu0c_BFu7c_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu33");
    static STRUCT_IF_C BFu0c_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu33, BFu0c_BFu7c_BFu33)
//============================================================================


struct  BFu0c_BFu7c_BFu7c  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu7c_BFu7c) C1{ Fc:0 Fc:7 Fc:7}



static void Test_BFu0c_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu7c");
    static STRUCT_IF_C BFu0c_BFu7c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu7c, BFu0c_BFu7c_BFu7c)
//============================================================================


struct  BFu0c_BFu7c_BFu7i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu7c_BFu7i) C1{ Fc:0 Fc:7 Fi:7}



static void Test_BFu0c_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu7i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu7i, BFu0c_BFu7c_BFu7i)
//============================================================================


struct  BFu0c_BFu7c_BFu7ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu7c_BFu7ll) C1{ Fc:0 Fc:7 FL:7}



static void Test_BFu0c_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu7ll, BFu0c_BFu7c_BFu7ll)
//============================================================================


struct  BFu0c_BFu7c_BFu7s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu7c_BFu7s) C1{ Fc:0 Fc:7 Fs:7}



static void Test_BFu0c_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu7s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu7s, BFu0c_BFu7c_BFu7s)
//============================================================================


struct  BFu0c_BFu7c_BFu8c  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu7c_BFu8c) C1{ Fc:0 Fc:7 Fc:8}



static void Test_BFu0c_BFu7c_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu8c");
    static STRUCT_IF_C BFu0c_BFu7c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu8c, BFu0c_BFu7c_BFu8c)
//============================================================================


struct  BFu0c_BFu7c_BFu8i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu7c_BFu8i) C1{ Fc:0 Fc:7 Fi:8}



static void Test_BFu0c_BFu7c_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu8i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu8i, BFu0c_BFu7c_BFu8i)
//============================================================================


struct  BFu0c_BFu7c_BFu8ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu7c_BFu8ll) C1{ Fc:0 Fc:7 FL:8}



static void Test_BFu0c_BFu7c_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu8ll, BFu0c_BFu7c_BFu8ll)
//============================================================================


struct  BFu0c_BFu7c_BFu8s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu7c_BFu8s) C1{ Fc:0 Fc:7 Fs:8}



static void Test_BFu0c_BFu7c_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu8s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu8s, BFu0c_BFu7c_BFu8s)
//============================================================================


struct  BFu0c_BFu7c_BFu9i  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu7c_BFu9i) C1{ Fc:0 Fc:7 Fi:9}



static void Test_BFu0c_BFu7c_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu9i");
    static STRUCT_IF_C BFu0c_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu9i, BFu0c_BFu7c_BFu9i)
//============================================================================


struct  BFu0c_BFu7c_BFu9ll  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu7c_BFu9ll) C1{ Fc:0 Fc:7 FL:9}



static void Test_BFu0c_BFu7c_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu9ll, BFu0c_BFu7c_BFu9ll)
//============================================================================


struct  BFu0c_BFu7c_BFu9s  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu7c_BFu9s) C1{ Fc:0 Fc:7 Fs:9}



static void Test_BFu0c_BFu7c_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7c_BFu9s");
    static STRUCT_IF_C BFu0c_BFu7c_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_BFu9s, BFu0c_BFu7c_BFu9s)
//============================================================================


struct  BFu0c_BFu7c_C  {
  unsigned char  :0;
  unsigned char v1:7;
  char v2;
};
//SIG(1 BFu0c_BFu7c_C) C1{ Fc:0 Fc:7 Fc}



static void Test_BFu0c_BFu7c_C()
{
  {
    init_simple_test("BFu0c_BFu7c_C");
    static STRUCT_IF_C BFu0c_BFu7c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_C, BFu0c_BFu7c_C)
//============================================================================


struct  BFu0c_BFu7c_D  {
  unsigned char  :0;
  unsigned char v1:7;
  double v2;
};
//SIG(1 BFu0c_BFu7c_D) C1{ Fc:0 Fc:7 FL}



static void Test_BFu0c_BFu7c_D()
{
  {
    init_simple_test("BFu0c_BFu7c_D");
    static STRUCT_IF_C BFu0c_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_D, BFu0c_BFu7c_D)
//============================================================================


struct  BFu0c_BFu7c_F  {
  unsigned char  :0;
  unsigned char v1:7;
  float v2;
};
//SIG(1 BFu0c_BFu7c_F) C1{ Fc:0 Fc:7 Fi}



static void Test_BFu0c_BFu7c_F()
{
  {
    init_simple_test("BFu0c_BFu7c_F");
    static STRUCT_IF_C BFu0c_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_F, BFu0c_BFu7c_F)
//============================================================================


struct  BFu0c_BFu7c_I  {
  unsigned char  :0;
  unsigned char v1:7;
  int v2;
};
//SIG(1 BFu0c_BFu7c_I) C1{ Fc:0 Fc:7 Fi}



static void Test_BFu0c_BFu7c_I()
{
  {
    init_simple_test("BFu0c_BFu7c_I");
    static STRUCT_IF_C BFu0c_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_I, BFu0c_BFu7c_I)
//============================================================================


struct  BFu0c_BFu7c_Ip  {
  unsigned char  :0;
  unsigned char v1:7;
  int *v2;
};
//SIG(1 BFu0c_BFu7c_Ip) C1{ Fc:0 Fc:7 Fp}



static void Test_BFu0c_BFu7c_Ip()
{
  {
    init_simple_test("BFu0c_BFu7c_Ip");
    static STRUCT_IF_C BFu0c_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Ip, BFu0c_BFu7c_Ip)
//============================================================================


struct  BFu0c_BFu7c_L  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu7c_L) C1{ Fc:0 Fc:7 FL}



static void Test_BFu0c_BFu7c_L()
{
  {
    init_simple_test("BFu0c_BFu7c_L");
    static STRUCT_IF_C BFu0c_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_L, BFu0c_BFu7c_L)
//============================================================================


struct  BFu0c_BFu7c_S  {
  unsigned char  :0;
  unsigned char v1:7;
  short v2;
};
//SIG(1 BFu0c_BFu7c_S) C1{ Fc:0 Fc:7 Fs}



static void Test_BFu0c_BFu7c_S()
{
  {
    init_simple_test("BFu0c_BFu7c_S");
    static STRUCT_IF_C BFu0c_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_S, BFu0c_BFu7c_S)
//============================================================================


struct  BFu0c_BFu7c_Uc  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu7c_Uc) C1{ Fc:0 Fc:7 Fc}



static void Test_BFu0c_BFu7c_Uc()
{
  {
    init_simple_test("BFu0c_BFu7c_Uc");
    static STRUCT_IF_C BFu0c_BFu7c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Uc, BFu0c_BFu7c_Uc)
//============================================================================


struct  BFu0c_BFu7c_Ui  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu7c_Ui) C1{ Fc:0 Fc:7 Fi}



static void Test_BFu0c_BFu7c_Ui()
{
  {
    init_simple_test("BFu0c_BFu7c_Ui");
    static STRUCT_IF_C BFu0c_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Ui, BFu0c_BFu7c_Ui)
//============================================================================


struct  BFu0c_BFu7c_Ul  {
  unsigned char  :0;
  unsigned char v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu7c_Ul) C1{ Fc:0 Fc:7 FL}



static void Test_BFu0c_BFu7c_Ul()
{
  {
    init_simple_test("BFu0c_BFu7c_Ul");
    static STRUCT_IF_C BFu0c_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Ul, BFu0c_BFu7c_Ul)
//============================================================================


struct  BFu0c_BFu7c_Us  {
  unsigned char  :0;
  unsigned char v1:7;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu7c_Us) C1{ Fc:0 Fc:7 Fs}



static void Test_BFu0c_BFu7c_Us()
{
  {
    init_simple_test("BFu0c_BFu7c_Us");
    static STRUCT_IF_C BFu0c_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Us, BFu0c_BFu7c_Us)
//============================================================================


struct  BFu0c_BFu7c_Vp  {
  unsigned char  :0;
  unsigned char v1:7;
  void *v2;
};
//SIG(1 BFu0c_BFu7c_Vp) C1{ Fc:0 Fc:7 Fp}



static void Test_BFu0c_BFu7c_Vp()
{
  {
    init_simple_test("BFu0c_BFu7c_Vp");
    static STRUCT_IF_C BFu0c_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7c_Vp, BFu0c_BFu7c_Vp)
//============================================================================


struct  BFu0c_BFu7i  {
  unsigned char  :0;
  unsigned int v1:7;
};
//SIG(1 BFu0c_BFu7i) C1{ Fc:0 Fi:7}



static void Test_BFu0c_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7i");
    static STRUCT_IF_C BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i, BFu0c_BFu7i)
//============================================================================


struct  BFu0c_BFu7i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu7i_BFu0c) C1{ Fc:0 Fi:7 Fc:0}



static void Test_BFu0c_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu0c, BFu0c_BFu7i_BFu0c)
//============================================================================


struct  BFu0c_BFu7i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu7i_BFu0i) C1{ Fc:0 Fi:7 Fi:0}



static void Test_BFu0c_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu0i, BFu0c_BFu7i_BFu0i)
//============================================================================


struct  BFu0c_BFu7i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu7i_BFu0ll) C1{ Fc:0 Fi:7 FL:0}



static void Test_BFu0c_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu0ll, BFu0c_BFu7i_BFu0ll)
//============================================================================


struct  BFu0c_BFu7i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu7i_BFu0s) C1{ Fc:0 Fi:7 Fs:0}



static void Test_BFu0c_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu0s, BFu0c_BFu7i_BFu0s)
//============================================================================


struct  BFu0c_BFu7i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu7i_BFu15i) C1{ Fc:0 Fi:7 Fi:15}



static void Test_BFu0c_BFu7i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu15i, BFu0c_BFu7i_BFu15i)
//============================================================================


struct  BFu0c_BFu7i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu7i_BFu15ll) C1{ Fc:0 Fi:7 FL:15}



static void Test_BFu0c_BFu7i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu15ll, BFu0c_BFu7i_BFu15ll)
//============================================================================


struct  BFu0c_BFu7i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu7i_BFu15s) C1{ Fc:0 Fi:7 Fs:15}



static void Test_BFu0c_BFu7i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu15s, BFu0c_BFu7i_BFu15s)
//============================================================================


struct  BFu0c_BFu7i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu7i_BFu16i) C1{ Fc:0 Fi:7 Fi:16}



static void Test_BFu0c_BFu7i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu16i, BFu0c_BFu7i_BFu16i)
//============================================================================


struct  BFu0c_BFu7i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu7i_BFu16ll) C1{ Fc:0 Fi:7 FL:16}



static void Test_BFu0c_BFu7i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu16ll, BFu0c_BFu7i_BFu16ll)
//============================================================================


struct  BFu0c_BFu7i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu7i_BFu16s) C1{ Fc:0 Fi:7 Fs:16}



static void Test_BFu0c_BFu7i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu16s, BFu0c_BFu7i_BFu16s)
//============================================================================


struct  BFu0c_BFu7i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu7i_BFu17i) C1{ Fc:0 Fi:7 Fi:17}



static void Test_BFu0c_BFu7i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu17i, BFu0c_BFu7i_BFu17i)
//============================================================================


struct  BFu0c_BFu7i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu7i_BFu17ll) C1{ Fc:0 Fi:7 FL:17}



static void Test_BFu0c_BFu7i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu17ll, BFu0c_BFu7i_BFu17ll)
//============================================================================


struct  BFu0c_BFu7i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu7i_BFu1c) C1{ Fc:0 Fi:7 Fc:1}



static void Test_BFu0c_BFu7i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu1c, BFu0c_BFu7i_BFu1c)
//============================================================================


struct  BFu0c_BFu7i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu7i_BFu1i) C1{ Fc:0 Fi:7 Fi:1}



static void Test_BFu0c_BFu7i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu1i, BFu0c_BFu7i_BFu1i)
//============================================================================


struct  BFu0c_BFu7i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu7i_BFu1ll) C1{ Fc:0 Fi:7 FL:1}



static void Test_BFu0c_BFu7i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu1ll, BFu0c_BFu7i_BFu1ll)
//============================================================================


struct  BFu0c_BFu7i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu7i_BFu1s) C1{ Fc:0 Fi:7 Fs:1}



static void Test_BFu0c_BFu7i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu1s, BFu0c_BFu7i_BFu1s)
//============================================================================


struct  BFu0c_BFu7i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu7i_BFu31i) C1{ Fc:0 Fi:7 Fi:31}



static void Test_BFu0c_BFu7i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu31i, BFu0c_BFu7i_BFu31i)
//============================================================================


struct  BFu0c_BFu7i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu7i_BFu31ll) C1{ Fc:0 Fi:7 FL:31}



static void Test_BFu0c_BFu7i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu31ll, BFu0c_BFu7i_BFu31ll)
//============================================================================


struct  BFu0c_BFu7i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu7i_BFu32i) C1{ Fc:0 Fi:7 Fi:32}



static void Test_BFu0c_BFu7i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu32i, BFu0c_BFu7i_BFu32i)
//============================================================================


struct  BFu0c_BFu7i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu7i_BFu32ll) C1{ Fc:0 Fi:7 FL:32}



static void Test_BFu0c_BFu7i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu32ll, BFu0c_BFu7i_BFu32ll)
//============================================================================


struct  BFu0c_BFu7i_BFu33  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu7i_BFu33) C1{ Fc:0 Fi:7 FL:33}



static void Test_BFu0c_BFu7i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu33");
    static STRUCT_IF_C BFu0c_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu33, BFu0c_BFu7i_BFu33)
//============================================================================


struct  BFu0c_BFu7i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu7i_BFu7c) C1{ Fc:0 Fi:7 Fc:7}



static void Test_BFu0c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu7c, BFu0c_BFu7i_BFu7c)
//============================================================================


struct  BFu0c_BFu7i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu7i_BFu7i) C1{ Fc:0 Fi:7 Fi:7}



static void Test_BFu0c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu7i, BFu0c_BFu7i_BFu7i)
//============================================================================


struct  BFu0c_BFu7i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu7i_BFu7ll) C1{ Fc:0 Fi:7 FL:7}



static void Test_BFu0c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu7ll, BFu0c_BFu7i_BFu7ll)
//============================================================================


struct  BFu0c_BFu7i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu7i_BFu7s) C1{ Fc:0 Fi:7 Fs:7}



static void Test_BFu0c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu7s, BFu0c_BFu7i_BFu7s)
//============================================================================


struct  BFu0c_BFu7i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu7i_BFu8c) C1{ Fc:0 Fi:7 Fc:8}



static void Test_BFu0c_BFu7i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu8c, BFu0c_BFu7i_BFu8c)
//============================================================================


struct  BFu0c_BFu7i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu7i_BFu8i) C1{ Fc:0 Fi:7 Fi:8}



static void Test_BFu0c_BFu7i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu8i, BFu0c_BFu7i_BFu8i)
//============================================================================


struct  BFu0c_BFu7i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu7i_BFu8ll) C1{ Fc:0 Fi:7 FL:8}



static void Test_BFu0c_BFu7i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu8ll, BFu0c_BFu7i_BFu8ll)
//============================================================================


struct  BFu0c_BFu7i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu7i_BFu8s) C1{ Fc:0 Fi:7 Fs:8}



static void Test_BFu0c_BFu7i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu8s, BFu0c_BFu7i_BFu8s)
//============================================================================


struct  BFu0c_BFu7i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu7i_BFu9i) C1{ Fc:0 Fi:7 Fi:9}



static void Test_BFu0c_BFu7i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu9i, BFu0c_BFu7i_BFu9i)
//============================================================================


struct  BFu0c_BFu7i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu7i_BFu9ll) C1{ Fc:0 Fi:7 FL:9}



static void Test_BFu0c_BFu7i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu9ll, BFu0c_BFu7i_BFu9ll)
//============================================================================


struct  BFu0c_BFu7i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu7i_BFu9s) C1{ Fc:0 Fi:7 Fs:9}



static void Test_BFu0c_BFu7i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_BFu9s, BFu0c_BFu7i_BFu9s)
//============================================================================


struct  BFu0c_BFu7i_C  {
  unsigned char  :0;
  unsigned int v1:7;
  char v2;
};
//SIG(1 BFu0c_BFu7i_C) C1{ Fc:0 Fi:7 Fc}



static void Test_BFu0c_BFu7i_C()
{
  {
    init_simple_test("BFu0c_BFu7i_C");
    static STRUCT_IF_C BFu0c_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_C, BFu0c_BFu7i_C)
//============================================================================


struct  BFu0c_BFu7i_D  {
  unsigned char  :0;
  unsigned int v1:7;
  double v2;
};
//SIG(1 BFu0c_BFu7i_D) C1{ Fc:0 Fi:7 FL}



static void Test_BFu0c_BFu7i_D()
{
  {
    init_simple_test("BFu0c_BFu7i_D");
    static STRUCT_IF_C BFu0c_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_D, BFu0c_BFu7i_D)
//============================================================================


struct  BFu0c_BFu7i_F  {
  unsigned char  :0;
  unsigned int v1:7;
  float v2;
};
//SIG(1 BFu0c_BFu7i_F) C1{ Fc:0 Fi:7 Fi}



static void Test_BFu0c_BFu7i_F()
{
  {
    init_simple_test("BFu0c_BFu7i_F");
    static STRUCT_IF_C BFu0c_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_F, BFu0c_BFu7i_F)
//============================================================================


struct  BFu0c_BFu7i_I  {
  unsigned char  :0;
  unsigned int v1:7;
  int v2;
};
//SIG(1 BFu0c_BFu7i_I) C1{ Fc:0 Fi:7 Fi}



static void Test_BFu0c_BFu7i_I()
{
  {
    init_simple_test("BFu0c_BFu7i_I");
    static STRUCT_IF_C BFu0c_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_I, BFu0c_BFu7i_I)
//============================================================================


struct  BFu0c_BFu7i_Ip  {
  unsigned char  :0;
  unsigned int v1:7;
  int *v2;
};
//SIG(1 BFu0c_BFu7i_Ip) C1{ Fc:0 Fi:7 Fp}



static void Test_BFu0c_BFu7i_Ip()
{
  {
    init_simple_test("BFu0c_BFu7i_Ip");
    static STRUCT_IF_C BFu0c_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Ip, BFu0c_BFu7i_Ip)
//============================================================================


struct  BFu0c_BFu7i_L  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu7i_L) C1{ Fc:0 Fi:7 FL}



static void Test_BFu0c_BFu7i_L()
{
  {
    init_simple_test("BFu0c_BFu7i_L");
    static STRUCT_IF_C BFu0c_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_L, BFu0c_BFu7i_L)
//============================================================================


struct  BFu0c_BFu7i_S  {
  unsigned char  :0;
  unsigned int v1:7;
  short v2;
};
//SIG(1 BFu0c_BFu7i_S) C1{ Fc:0 Fi:7 Fs}



static void Test_BFu0c_BFu7i_S()
{
  {
    init_simple_test("BFu0c_BFu7i_S");
    static STRUCT_IF_C BFu0c_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_S, BFu0c_BFu7i_S)
//============================================================================


struct  BFu0c_BFu7i_Uc  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu7i_Uc) C1{ Fc:0 Fi:7 Fc}



static void Test_BFu0c_BFu7i_Uc()
{
  {
    init_simple_test("BFu0c_BFu7i_Uc");
    static STRUCT_IF_C BFu0c_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Uc, BFu0c_BFu7i_Uc)
//============================================================================


struct  BFu0c_BFu7i_Ui  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu7i_Ui) C1{ Fc:0 Fi:7 Fi}



static void Test_BFu0c_BFu7i_Ui()
{
  {
    init_simple_test("BFu0c_BFu7i_Ui");
    static STRUCT_IF_C BFu0c_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Ui, BFu0c_BFu7i_Ui)
//============================================================================


struct  BFu0c_BFu7i_Ul  {
  unsigned char  :0;
  unsigned int v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu7i_Ul) C1{ Fc:0 Fi:7 FL}



static void Test_BFu0c_BFu7i_Ul()
{
  {
    init_simple_test("BFu0c_BFu7i_Ul");
    static STRUCT_IF_C BFu0c_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Ul, BFu0c_BFu7i_Ul)
//============================================================================


struct  BFu0c_BFu7i_Us  {
  unsigned char  :0;
  unsigned int v1:7;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu7i_Us) C1{ Fc:0 Fi:7 Fs}



static void Test_BFu0c_BFu7i_Us()
{
  {
    init_simple_test("BFu0c_BFu7i_Us");
    static STRUCT_IF_C BFu0c_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Us, BFu0c_BFu7i_Us)
//============================================================================


struct  BFu0c_BFu7i_Vp  {
  unsigned char  :0;
  unsigned int v1:7;
  void *v2;
};
//SIG(1 BFu0c_BFu7i_Vp) C1{ Fc:0 Fi:7 Fp}



static void Test_BFu0c_BFu7i_Vp()
{
  {
    init_simple_test("BFu0c_BFu7i_Vp");
    static STRUCT_IF_C BFu0c_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7i_Vp, BFu0c_BFu7i_Vp)
//============================================================================


struct  BFu0c_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:7;
};
//SIG(1 BFu0c_BFu7ll) C1{ Fc:0 FL:7}



static void Test_BFu0c_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll, BFu0c_BFu7ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu7ll_BFu0c) C1{ Fc:0 FL:7 Fc:0}



static void Test_BFu0c_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu0c, BFu0c_BFu7ll_BFu0c)
//============================================================================


struct  BFu0c_BFu7ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu7ll_BFu0i) C1{ Fc:0 FL:7 Fi:0}



static void Test_BFu0c_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu0i, BFu0c_BFu7ll_BFu0i)
//============================================================================


struct  BFu0c_BFu7ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu7ll_BFu0ll) C1{ Fc:0 FL:7 FL:0}



static void Test_BFu0c_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu0ll, BFu0c_BFu7ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu7ll_BFu0s) C1{ Fc:0 FL:7 Fs:0}



static void Test_BFu0c_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu0s, BFu0c_BFu7ll_BFu0s)
//============================================================================


struct  BFu0c_BFu7ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu7ll_BFu15i) C1{ Fc:0 FL:7 Fi:15}



static void Test_BFu0c_BFu7ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu15i, BFu0c_BFu7ll_BFu15i)
//============================================================================


struct  BFu0c_BFu7ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu7ll_BFu15ll) C1{ Fc:0 FL:7 FL:15}



static void Test_BFu0c_BFu7ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu15ll, BFu0c_BFu7ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu7ll_BFu15s) C1{ Fc:0 FL:7 Fs:15}



static void Test_BFu0c_BFu7ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu15s, BFu0c_BFu7ll_BFu15s)
//============================================================================


struct  BFu0c_BFu7ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu7ll_BFu16i) C1{ Fc:0 FL:7 Fi:16}



static void Test_BFu0c_BFu7ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu16i, BFu0c_BFu7ll_BFu16i)
//============================================================================


struct  BFu0c_BFu7ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu7ll_BFu16ll) C1{ Fc:0 FL:7 FL:16}



static void Test_BFu0c_BFu7ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu16ll, BFu0c_BFu7ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu7ll_BFu16s) C1{ Fc:0 FL:7 Fs:16}



static void Test_BFu0c_BFu7ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu16s, BFu0c_BFu7ll_BFu16s)
//============================================================================


struct  BFu0c_BFu7ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu7ll_BFu17i) C1{ Fc:0 FL:7 Fi:17}



static void Test_BFu0c_BFu7ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu17i, BFu0c_BFu7ll_BFu17i)
//============================================================================


struct  BFu0c_BFu7ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu7ll_BFu17ll) C1{ Fc:0 FL:7 FL:17}



static void Test_BFu0c_BFu7ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu17ll, BFu0c_BFu7ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu7ll_BFu1c) C1{ Fc:0 FL:7 Fc:1}



static void Test_BFu0c_BFu7ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu1c, BFu0c_BFu7ll_BFu1c)
//============================================================================


struct  BFu0c_BFu7ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu7ll_BFu1i) C1{ Fc:0 FL:7 Fi:1}



static void Test_BFu0c_BFu7ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu1i, BFu0c_BFu7ll_BFu1i)
//============================================================================


struct  BFu0c_BFu7ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu7ll_BFu1ll) C1{ Fc:0 FL:7 FL:1}



static void Test_BFu0c_BFu7ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu1ll, BFu0c_BFu7ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu7ll_BFu1s) C1{ Fc:0 FL:7 Fs:1}



static void Test_BFu0c_BFu7ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu1s, BFu0c_BFu7ll_BFu1s)
//============================================================================


struct  BFu0c_BFu7ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu7ll_BFu31i) C1{ Fc:0 FL:7 Fi:31}



static void Test_BFu0c_BFu7ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu31i, BFu0c_BFu7ll_BFu31i)
//============================================================================


struct  BFu0c_BFu7ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu7ll_BFu31ll) C1{ Fc:0 FL:7 FL:31}



static void Test_BFu0c_BFu7ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu31ll, BFu0c_BFu7ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu7ll_BFu32i) C1{ Fc:0 FL:7 Fi:32}



static void Test_BFu0c_BFu7ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu32i, BFu0c_BFu7ll_BFu32i)
//============================================================================


struct  BFu0c_BFu7ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu7ll_BFu32ll) C1{ Fc:0 FL:7 FL:32}



static void Test_BFu0c_BFu7ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu32ll, BFu0c_BFu7ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu7ll_BFu33) C1{ Fc:0 FL:7 FL:33}



static void Test_BFu0c_BFu7ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu33, BFu0c_BFu7ll_BFu33)
//============================================================================


struct  BFu0c_BFu7ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu7ll_BFu7c) C1{ Fc:0 FL:7 Fc:7}



static void Test_BFu0c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu7c, BFu0c_BFu7ll_BFu7c)
//============================================================================


struct  BFu0c_BFu7ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu7ll_BFu7i) C1{ Fc:0 FL:7 Fi:7}



static void Test_BFu0c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu7i, BFu0c_BFu7ll_BFu7i)
//============================================================================


struct  BFu0c_BFu7ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu7ll_BFu7ll) C1{ Fc:0 FL:7 FL:7}



static void Test_BFu0c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu7ll, BFu0c_BFu7ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu7ll_BFu7s) C1{ Fc:0 FL:7 Fs:7}



static void Test_BFu0c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu7s, BFu0c_BFu7ll_BFu7s)
//============================================================================


struct  BFu0c_BFu7ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu7ll_BFu8c) C1{ Fc:0 FL:7 Fc:8}



static void Test_BFu0c_BFu7ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu8c, BFu0c_BFu7ll_BFu8c)
//============================================================================


struct  BFu0c_BFu7ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu7ll_BFu8i) C1{ Fc:0 FL:7 Fi:8}



static void Test_BFu0c_BFu7ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu8i, BFu0c_BFu7ll_BFu8i)
//============================================================================


struct  BFu0c_BFu7ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu7ll_BFu8ll) C1{ Fc:0 FL:7 FL:8}



static void Test_BFu0c_BFu7ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu8ll, BFu0c_BFu7ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu7ll_BFu8s) C1{ Fc:0 FL:7 Fs:8}



static void Test_BFu0c_BFu7ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu8s, BFu0c_BFu7ll_BFu8s)
//============================================================================


struct  BFu0c_BFu7ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu7ll_BFu9i) C1{ Fc:0 FL:7 Fi:9}



static void Test_BFu0c_BFu7ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu9i, BFu0c_BFu7ll_BFu9i)
//============================================================================


struct  BFu0c_BFu7ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu7ll_BFu9ll) C1{ Fc:0 FL:7 FL:9}



static void Test_BFu0c_BFu7ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu9ll, BFu0c_BFu7ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu7ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu7ll_BFu9s) C1{ Fc:0 FL:7 Fs:9}



static void Test_BFu0c_BFu7ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_BFu9s, BFu0c_BFu7ll_BFu9s)
//============================================================================


struct  BFu0c_BFu7ll_C  {
  unsigned char  :0;
  __tsu64 v1:7;
  char v2;
};
//SIG(1 BFu0c_BFu7ll_C) C1{ Fc:0 FL:7 Fc}



static void Test_BFu0c_BFu7ll_C()
{
  {
    init_simple_test("BFu0c_BFu7ll_C");
    static STRUCT_IF_C BFu0c_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_C, BFu0c_BFu7ll_C)
//============================================================================


struct  BFu0c_BFu7ll_D  {
  unsigned char  :0;
  __tsu64 v1:7;
  double v2;
};
//SIG(1 BFu0c_BFu7ll_D) C1{ Fc:0 FL:7 FL}



static void Test_BFu0c_BFu7ll_D()
{
  {
    init_simple_test("BFu0c_BFu7ll_D");
    static STRUCT_IF_C BFu0c_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_D, BFu0c_BFu7ll_D)
//============================================================================


struct  BFu0c_BFu7ll_F  {
  unsigned char  :0;
  __tsu64 v1:7;
  float v2;
};
//SIG(1 BFu0c_BFu7ll_F) C1{ Fc:0 FL:7 Fi}



static void Test_BFu0c_BFu7ll_F()
{
  {
    init_simple_test("BFu0c_BFu7ll_F");
    static STRUCT_IF_C BFu0c_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_F, BFu0c_BFu7ll_F)
//============================================================================


struct  BFu0c_BFu7ll_I  {
  unsigned char  :0;
  __tsu64 v1:7;
  int v2;
};
//SIG(1 BFu0c_BFu7ll_I) C1{ Fc:0 FL:7 Fi}



static void Test_BFu0c_BFu7ll_I()
{
  {
    init_simple_test("BFu0c_BFu7ll_I");
    static STRUCT_IF_C BFu0c_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_I, BFu0c_BFu7ll_I)
//============================================================================


struct  BFu0c_BFu7ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:7;
  int *v2;
};
//SIG(1 BFu0c_BFu7ll_Ip) C1{ Fc:0 FL:7 Fp}



static void Test_BFu0c_BFu7ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu7ll_Ip");
    static STRUCT_IF_C BFu0c_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Ip, BFu0c_BFu7ll_Ip)
//============================================================================


struct  BFu0c_BFu7ll_L  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu7ll_L) C1{ Fc:0 FL:7 FL}



static void Test_BFu0c_BFu7ll_L()
{
  {
    init_simple_test("BFu0c_BFu7ll_L");
    static STRUCT_IF_C BFu0c_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_L, BFu0c_BFu7ll_L)
//============================================================================


struct  BFu0c_BFu7ll_S  {
  unsigned char  :0;
  __tsu64 v1:7;
  short v2;
};
//SIG(1 BFu0c_BFu7ll_S) C1{ Fc:0 FL:7 Fs}



static void Test_BFu0c_BFu7ll_S()
{
  {
    init_simple_test("BFu0c_BFu7ll_S");
    static STRUCT_IF_C BFu0c_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_S, BFu0c_BFu7ll_S)
//============================================================================


struct  BFu0c_BFu7ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu7ll_Uc) C1{ Fc:0 FL:7 Fc}



static void Test_BFu0c_BFu7ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu7ll_Uc");
    static STRUCT_IF_C BFu0c_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Uc, BFu0c_BFu7ll_Uc)
//============================================================================


struct  BFu0c_BFu7ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu7ll_Ui) C1{ Fc:0 FL:7 Fi}



static void Test_BFu0c_BFu7ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu7ll_Ui");
    static STRUCT_IF_C BFu0c_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Ui, BFu0c_BFu7ll_Ui)
//============================================================================


struct  BFu0c_BFu7ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu7ll_Ul) C1{ Fc:0 FL:7 FL}



static void Test_BFu0c_BFu7ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu7ll_Ul");
    static STRUCT_IF_C BFu0c_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Ul, BFu0c_BFu7ll_Ul)
//============================================================================


struct  BFu0c_BFu7ll_Us  {
  unsigned char  :0;
  __tsu64 v1:7;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu7ll_Us) C1{ Fc:0 FL:7 Fs}



static void Test_BFu0c_BFu7ll_Us()
{
  {
    init_simple_test("BFu0c_BFu7ll_Us");
    static STRUCT_IF_C BFu0c_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Us, BFu0c_BFu7ll_Us)
//============================================================================


struct  BFu0c_BFu7ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:7;
  void *v2;
};
//SIG(1 BFu0c_BFu7ll_Vp) C1{ Fc:0 FL:7 Fp}



static void Test_BFu0c_BFu7ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu7ll_Vp");
    static STRUCT_IF_C BFu0c_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7ll_Vp, BFu0c_BFu7ll_Vp)
//============================================================================


struct  BFu0c_BFu7s  {
  unsigned char  :0;
  unsigned short v1:7;
};
//SIG(1 BFu0c_BFu7s) C1{ Fc:0 Fs:7}



static void Test_BFu0c_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7s");
    static STRUCT_IF_C BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s, BFu0c_BFu7s)
//============================================================================


struct  BFu0c_BFu7s_BFu0c  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu7s_BFu0c) C1{ Fc:0 Fs:7 Fc:0}



static void Test_BFu0c_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu0c, BFu0c_BFu7s_BFu0c)
//============================================================================


struct  BFu0c_BFu7s_BFu0i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu7s_BFu0i) C1{ Fc:0 Fs:7 Fi:0}



static void Test_BFu0c_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu0i, BFu0c_BFu7s_BFu0i)
//============================================================================


struct  BFu0c_BFu7s_BFu0ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu7s_BFu0ll) C1{ Fc:0 Fs:7 FL:0}



static void Test_BFu0c_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu0ll, BFu0c_BFu7s_BFu0ll)
//============================================================================


struct  BFu0c_BFu7s_BFu0s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu7s_BFu0s) C1{ Fc:0 Fs:7 Fs:0}



static void Test_BFu0c_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu0s, BFu0c_BFu7s_BFu0s)
//============================================================================


struct  BFu0c_BFu7s_BFu15i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu7s_BFu15i) C1{ Fc:0 Fs:7 Fi:15}



static void Test_BFu0c_BFu7s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu15i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu15i, BFu0c_BFu7s_BFu15i)
//============================================================================


struct  BFu0c_BFu7s_BFu15ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu7s_BFu15ll) C1{ Fc:0 Fs:7 FL:15}



static void Test_BFu0c_BFu7s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0c_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0c_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu15ll, BFu0c_BFu7s_BFu15ll)
//============================================================================


struct  BFu0c_BFu7s_BFu15s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu7s_BFu15s) C1{ Fc:0 Fs:7 Fs:15}



static void Test_BFu0c_BFu7s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu15s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu15s, BFu0c_BFu7s_BFu15s)
//============================================================================


struct  BFu0c_BFu7s_BFu16i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu7s_BFu16i) C1{ Fc:0 Fs:7 Fi:16}



static void Test_BFu0c_BFu7s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu16i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu16i, BFu0c_BFu7s_BFu16i)
//============================================================================


struct  BFu0c_BFu7s_BFu16ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu7s_BFu16ll) C1{ Fc:0 Fs:7 FL:16}



static void Test_BFu0c_BFu7s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0c_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0c_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu16ll, BFu0c_BFu7s_BFu16ll)
//============================================================================


struct  BFu0c_BFu7s_BFu16s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu7s_BFu16s) C1{ Fc:0 Fs:7 Fs:16}



static void Test_BFu0c_BFu7s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu16s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu16s, BFu0c_BFu7s_BFu16s)
//============================================================================


struct  BFu0c_BFu7s_BFu17i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu7s_BFu17i) C1{ Fc:0 Fs:7 Fi:17}



static void Test_BFu0c_BFu7s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu17i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu17i, BFu0c_BFu7s_BFu17i)
//============================================================================


struct  BFu0c_BFu7s_BFu17ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu7s_BFu17ll) C1{ Fc:0 Fs:7 FL:17}



static void Test_BFu0c_BFu7s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0c_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0c_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu17ll, BFu0c_BFu7s_BFu17ll)
//============================================================================


struct  BFu0c_BFu7s_BFu1c  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu7s_BFu1c) C1{ Fc:0 Fs:7 Fc:1}



static void Test_BFu0c_BFu7s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1c");
    static STRUCT_IF_C BFu0c_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu1c, BFu0c_BFu7s_BFu1c)
//============================================================================


struct  BFu0c_BFu7s_BFu1i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu7s_BFu1i) C1{ Fc:0 Fs:7 Fi:1}



static void Test_BFu0c_BFu7s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu1i, BFu0c_BFu7s_BFu1i)
//============================================================================


struct  BFu0c_BFu7s_BFu1ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu7s_BFu1ll) C1{ Fc:0 Fs:7 FL:1}



static void Test_BFu0c_BFu7s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu1ll, BFu0c_BFu7s_BFu1ll)
//============================================================================


struct  BFu0c_BFu7s_BFu1s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu7s_BFu1s) C1{ Fc:0 Fs:7 Fs:1}



static void Test_BFu0c_BFu7s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu1s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0c_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu1s, BFu0c_BFu7s_BFu1s)
//============================================================================


struct  BFu0c_BFu7s_BFu31i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu7s_BFu31i) C1{ Fc:0 Fs:7 Fi:31}



static void Test_BFu0c_BFu7s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu31i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu31i, BFu0c_BFu7s_BFu31i)
//============================================================================


struct  BFu0c_BFu7s_BFu31ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu7s_BFu31ll) C1{ Fc:0 Fs:7 FL:31}



static void Test_BFu0c_BFu7s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0c_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0c_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu31ll, BFu0c_BFu7s_BFu31ll)
//============================================================================


struct  BFu0c_BFu7s_BFu32i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu7s_BFu32i) C1{ Fc:0 Fs:7 Fi:32}



static void Test_BFu0c_BFu7s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu32i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu32i, BFu0c_BFu7s_BFu32i)
//============================================================================


struct  BFu0c_BFu7s_BFu32ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu7s_BFu32ll) C1{ Fc:0 Fs:7 FL:32}



static void Test_BFu0c_BFu7s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0c_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0c_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu32ll, BFu0c_BFu7s_BFu32ll)
//============================================================================


struct  BFu0c_BFu7s_BFu33  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu7s_BFu33) C1{ Fc:0 Fs:7 FL:33}



static void Test_BFu0c_BFu7s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu33");
    static STRUCT_IF_C BFu0c_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0c_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0c_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu33, BFu0c_BFu7s_BFu33)
//============================================================================


struct  BFu0c_BFu7s_BFu7c  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu7s_BFu7c) C1{ Fc:0 Fs:7 Fc:7}



static void Test_BFu0c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7c");
    static STRUCT_IF_C BFu0c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu7c, BFu0c_BFu7s_BFu7c)
//============================================================================


struct  BFu0c_BFu7s_BFu7i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu7s_BFu7i) C1{ Fc:0 Fs:7 Fi:7}



static void Test_BFu0c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu7i, BFu0c_BFu7s_BFu7i)
//============================================================================


struct  BFu0c_BFu7s_BFu7ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu7s_BFu7ll) C1{ Fc:0 Fs:7 FL:7}



static void Test_BFu0c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu7ll, BFu0c_BFu7s_BFu7ll)
//============================================================================


struct  BFu0c_BFu7s_BFu7s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu7s_BFu7s) C1{ Fc:0 Fs:7 Fs:7}



static void Test_BFu0c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu7s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu7s, BFu0c_BFu7s_BFu7s)
//============================================================================


struct  BFu0c_BFu7s_BFu8c  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu7s_BFu8c) C1{ Fc:0 Fs:7 Fc:8}



static void Test_BFu0c_BFu7s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8c");
    static STRUCT_IF_C BFu0c_BFu7s_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu8c, BFu0c_BFu7s_BFu8c)
//============================================================================


struct  BFu0c_BFu7s_BFu8i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu7s_BFu8i) C1{ Fc:0 Fs:7 Fi:8}



static void Test_BFu0c_BFu7s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu8i, BFu0c_BFu7s_BFu8i)
//============================================================================


struct  BFu0c_BFu7s_BFu8ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu7s_BFu8ll) C1{ Fc:0 Fs:7 FL:8}



static void Test_BFu0c_BFu7s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu8ll, BFu0c_BFu7s_BFu8ll)
//============================================================================


struct  BFu0c_BFu7s_BFu8s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu7s_BFu8s) C1{ Fc:0 Fs:7 Fs:8}



static void Test_BFu0c_BFu7s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu8s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0c_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0c_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu8s, BFu0c_BFu7s_BFu8s)
//============================================================================


struct  BFu0c_BFu7s_BFu9i  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu7s_BFu9i) C1{ Fc:0 Fs:7 Fi:9}



static void Test_BFu0c_BFu7s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu9i");
    static STRUCT_IF_C BFu0c_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu9i, BFu0c_BFu7s_BFu9i)
//============================================================================


struct  BFu0c_BFu7s_BFu9ll  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu7s_BFu9ll) C1{ Fc:0 Fs:7 FL:9}



static void Test_BFu0c_BFu7s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu9ll, BFu0c_BFu7s_BFu9ll)
//============================================================================


struct  BFu0c_BFu7s_BFu9s  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu7s_BFu9s) C1{ Fc:0 Fs:7 Fs:9}



static void Test_BFu0c_BFu7s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu7s_BFu9s");
    static STRUCT_IF_C BFu0c_BFu7s_BFu9s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0c_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0c_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_BFu9s, BFu0c_BFu7s_BFu9s)
//============================================================================


struct  BFu0c_BFu7s_C  {
  unsigned char  :0;
  unsigned short v1:7;
  char v2;
};
//SIG(1 BFu0c_BFu7s_C) C1{ Fc:0 Fs:7 Fc}



static void Test_BFu0c_BFu7s_C()
{
  {
    init_simple_test("BFu0c_BFu7s_C");
    static STRUCT_IF_C BFu0c_BFu7s_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_C, BFu0c_BFu7s_C)
//============================================================================


struct  BFu0c_BFu7s_D  {
  unsigned char  :0;
  unsigned short v1:7;
  double v2;
};
//SIG(1 BFu0c_BFu7s_D) C1{ Fc:0 Fs:7 FL}



static void Test_BFu0c_BFu7s_D()
{
  {
    init_simple_test("BFu0c_BFu7s_D");
    static STRUCT_IF_C BFu0c_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_D, BFu0c_BFu7s_D)
//============================================================================


struct  BFu0c_BFu7s_F  {
  unsigned char  :0;
  unsigned short v1:7;
  float v2;
};
//SIG(1 BFu0c_BFu7s_F) C1{ Fc:0 Fs:7 Fi}



static void Test_BFu0c_BFu7s_F()
{
  {
    init_simple_test("BFu0c_BFu7s_F");
    static STRUCT_IF_C BFu0c_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_F, BFu0c_BFu7s_F)
//============================================================================


struct  BFu0c_BFu7s_I  {
  unsigned char  :0;
  unsigned short v1:7;
  int v2;
};
//SIG(1 BFu0c_BFu7s_I) C1{ Fc:0 Fs:7 Fi}



static void Test_BFu0c_BFu7s_I()
{
  {
    init_simple_test("BFu0c_BFu7s_I");
    static STRUCT_IF_C BFu0c_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_I, BFu0c_BFu7s_I)
//============================================================================


struct  BFu0c_BFu7s_Ip  {
  unsigned char  :0;
  unsigned short v1:7;
  int *v2;
};
//SIG(1 BFu0c_BFu7s_Ip) C1{ Fc:0 Fs:7 Fp}



static void Test_BFu0c_BFu7s_Ip()
{
  {
    init_simple_test("BFu0c_BFu7s_Ip");
    static STRUCT_IF_C BFu0c_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Ip, BFu0c_BFu7s_Ip)
//============================================================================


struct  BFu0c_BFu7s_L  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu7s_L) C1{ Fc:0 Fs:7 FL}



static void Test_BFu0c_BFu7s_L()
{
  {
    init_simple_test("BFu0c_BFu7s_L");
    static STRUCT_IF_C BFu0c_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_L, BFu0c_BFu7s_L)
//============================================================================


struct  BFu0c_BFu7s_S  {
  unsigned char  :0;
  unsigned short v1:7;
  short v2;
};
//SIG(1 BFu0c_BFu7s_S) C1{ Fc:0 Fs:7 Fs}



static void Test_BFu0c_BFu7s_S()
{
  {
    init_simple_test("BFu0c_BFu7s_S");
    static STRUCT_IF_C BFu0c_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_S, BFu0c_BFu7s_S)
//============================================================================


struct  BFu0c_BFu7s_Uc  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu7s_Uc) C1{ Fc:0 Fs:7 Fc}



static void Test_BFu0c_BFu7s_Uc()
{
  {
    init_simple_test("BFu0c_BFu7s_Uc");
    static STRUCT_IF_C BFu0c_BFu7s_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu7s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu7s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Uc, BFu0c_BFu7s_Uc)
//============================================================================


struct  BFu0c_BFu7s_Ui  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu7s_Ui) C1{ Fc:0 Fs:7 Fi}



static void Test_BFu0c_BFu7s_Ui()
{
  {
    init_simple_test("BFu0c_BFu7s_Ui");
    static STRUCT_IF_C BFu0c_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu7s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu7s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Ui, BFu0c_BFu7s_Ui)
//============================================================================


struct  BFu0c_BFu7s_Ul  {
  unsigned char  :0;
  unsigned short v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu7s_Ul) C1{ Fc:0 Fs:7 FL}



static void Test_BFu0c_BFu7s_Ul()
{
  {
    init_simple_test("BFu0c_BFu7s_Ul");
    static STRUCT_IF_C BFu0c_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Ul, BFu0c_BFu7s_Ul)
//============================================================================


struct  BFu0c_BFu7s_Us  {
  unsigned char  :0;
  unsigned short v1:7;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu7s_Us) C1{ Fc:0 Fs:7 Fs}



static void Test_BFu0c_BFu7s_Us()
{
  {
    init_simple_test("BFu0c_BFu7s_Us");
    static STRUCT_IF_C BFu0c_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu7s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu7s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu7s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Us, BFu0c_BFu7s_Us)
//============================================================================


struct  BFu0c_BFu7s_Vp  {
  unsigned char  :0;
  unsigned short v1:7;
  void *v2;
};
//SIG(1 BFu0c_BFu7s_Vp) C1{ Fc:0 Fs:7 Fp}



static void Test_BFu0c_BFu7s_Vp()
{
  {
    init_simple_test("BFu0c_BFu7s_Vp");
    static STRUCT_IF_C BFu0c_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu7s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0c_BFu7s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu7s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu7s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu7s_Vp, BFu0c_BFu7s_Vp)
//============================================================================


struct  BFu0c_BFu8c  {
  unsigned char  :0;
  unsigned char v1:8;
};
//SIG(1 BFu0c_BFu8c) C1{ Fc:0 Fc:8}



static void Test_BFu0c_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8c");
    static STRUCT_IF_C BFu0c_BFu8c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c, BFu0c_BFu8c)
//============================================================================


struct  BFu0c_BFu8c_BFu0c  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu8c_BFu0c) C1{ Fc:0 Fc:8 Fc:0}



static void Test_BFu0c_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0c");
    static STRUCT_IF_C BFu0c_BFu8c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(BFu0c_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu0c, BFu0c_BFu8c_BFu0c)
//============================================================================


struct  BFu0c_BFu8c_BFu0i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu8c_BFu0i) C1{ Fc:0 Fc:8 Fi:0}



static void Test_BFu0c_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu0i, BFu0c_BFu8c_BFu0i)
//============================================================================


struct  BFu0c_BFu8c_BFu0ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu8c_BFu0ll) C1{ Fc:0 Fc:8 FL:0}



static void Test_BFu0c_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu0ll, BFu0c_BFu8c_BFu0ll)
//============================================================================


struct  BFu0c_BFu8c_BFu0s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu8c_BFu0s) C1{ Fc:0 Fc:8 Fs:0}



static void Test_BFu0c_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu0s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0c_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu0s, BFu0c_BFu8c_BFu0s)
//============================================================================


struct  BFu0c_BFu8c_BFu15i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu8c_BFu15i) C1{ Fc:0 Fc:8 Fi:15}



static void Test_BFu0c_BFu8c_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu15i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu15i, BFu0c_BFu8c_BFu15i)
//============================================================================


struct  BFu0c_BFu8c_BFu15ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu8c_BFu15ll) C1{ Fc:0 Fc:8 FL:15}



static void Test_BFu0c_BFu8c_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu15ll, BFu0c_BFu8c_BFu15ll)
//============================================================================


struct  BFu0c_BFu8c_BFu15s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu8c_BFu15s) C1{ Fc:0 Fc:8 Fs:15}



static void Test_BFu0c_BFu8c_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu15s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu15s, BFu0c_BFu8c_BFu15s)
//============================================================================


struct  BFu0c_BFu8c_BFu16i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu8c_BFu16i) C1{ Fc:0 Fc:8 Fi:16}



static void Test_BFu0c_BFu8c_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu16i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu16i, BFu0c_BFu8c_BFu16i)
//============================================================================


struct  BFu0c_BFu8c_BFu16ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu8c_BFu16ll) C1{ Fc:0 Fc:8 FL:16}



static void Test_BFu0c_BFu8c_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu16ll, BFu0c_BFu8c_BFu16ll)
//============================================================================


struct  BFu0c_BFu8c_BFu16s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu8c_BFu16s) C1{ Fc:0 Fc:8 Fs:16}



static void Test_BFu0c_BFu8c_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu16s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu16s, BFu0c_BFu8c_BFu16s)
//============================================================================


struct  BFu0c_BFu8c_BFu17i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu8c_BFu17i) C1{ Fc:0 Fc:8 Fi:17}



static void Test_BFu0c_BFu8c_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu17i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu17i, BFu0c_BFu8c_BFu17i)
//============================================================================


struct  BFu0c_BFu8c_BFu17ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu8c_BFu17ll) C1{ Fc:0 Fc:8 FL:17}



static void Test_BFu0c_BFu8c_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu17ll, BFu0c_BFu8c_BFu17ll)
//============================================================================


struct  BFu0c_BFu8c_BFu1c  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu8c_BFu1c) C1{ Fc:0 Fc:8 Fc:1}



static void Test_BFu0c_BFu8c_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1c");
    static STRUCT_IF_C BFu0c_BFu8c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu1c, BFu0c_BFu8c_BFu1c)
//============================================================================


struct  BFu0c_BFu8c_BFu1i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu8c_BFu1i) C1{ Fc:0 Fc:8 Fi:1}



static void Test_BFu0c_BFu8c_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu1i, BFu0c_BFu8c_BFu1i)
//============================================================================


struct  BFu0c_BFu8c_BFu1ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu8c_BFu1ll) C1{ Fc:0 Fc:8 FL:1}



static void Test_BFu0c_BFu8c_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu1ll, BFu0c_BFu8c_BFu1ll)
//============================================================================


struct  BFu0c_BFu8c_BFu1s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu8c_BFu1s) C1{ Fc:0 Fc:8 Fs:1}



static void Test_BFu0c_BFu8c_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu1s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu1s, BFu0c_BFu8c_BFu1s)
//============================================================================


struct  BFu0c_BFu8c_BFu31i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu8c_BFu31i) C1{ Fc:0 Fc:8 Fi:31}



static void Test_BFu0c_BFu8c_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu31i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu31i, BFu0c_BFu8c_BFu31i)
//============================================================================


struct  BFu0c_BFu8c_BFu31ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu8c_BFu31ll) C1{ Fc:0 Fc:8 FL:31}



static void Test_BFu0c_BFu8c_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu31ll, BFu0c_BFu8c_BFu31ll)
//============================================================================


struct  BFu0c_BFu8c_BFu32i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu8c_BFu32i) C1{ Fc:0 Fc:8 Fi:32}



static void Test_BFu0c_BFu8c_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu32i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu32i, BFu0c_BFu8c_BFu32i)
//============================================================================


struct  BFu0c_BFu8c_BFu32ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu8c_BFu32ll) C1{ Fc:0 Fc:8 FL:32}



static void Test_BFu0c_BFu8c_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu32ll, BFu0c_BFu8c_BFu32ll)
//============================================================================


struct  BFu0c_BFu8c_BFu33  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu8c_BFu33) C1{ Fc:0 Fc:8 FL:33}



static void Test_BFu0c_BFu8c_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu33");
    static STRUCT_IF_C BFu0c_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu33, BFu0c_BFu8c_BFu33)
//============================================================================


struct  BFu0c_BFu8c_BFu7c  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu8c_BFu7c) C1{ Fc:0 Fc:8 Fc:7}



static void Test_BFu0c_BFu8c_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7c");
    static STRUCT_IF_C BFu0c_BFu8c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu7c, BFu0c_BFu8c_BFu7c)
//============================================================================


struct  BFu0c_BFu8c_BFu7i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu8c_BFu7i) C1{ Fc:0 Fc:8 Fi:7}



static void Test_BFu0c_BFu8c_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu7i, BFu0c_BFu8c_BFu7i)
//============================================================================


struct  BFu0c_BFu8c_BFu7ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu8c_BFu7ll) C1{ Fc:0 Fc:8 FL:7}



static void Test_BFu0c_BFu8c_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu7ll, BFu0c_BFu8c_BFu7ll)
//============================================================================


struct  BFu0c_BFu8c_BFu7s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu8c_BFu7s) C1{ Fc:0 Fc:8 Fs:7}



static void Test_BFu0c_BFu8c_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu7s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu7s, BFu0c_BFu8c_BFu7s)
//============================================================================


struct  BFu0c_BFu8c_BFu8c  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu8c_BFu8c) C1{ Fc:0 Fc:8 Fc:8}



static void Test_BFu0c_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8c");
    static STRUCT_IF_C BFu0c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu8c, BFu0c_BFu8c_BFu8c)
//============================================================================


struct  BFu0c_BFu8c_BFu8i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu8c_BFu8i) C1{ Fc:0 Fc:8 Fi:8}



static void Test_BFu0c_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu8i, BFu0c_BFu8c_BFu8i)
//============================================================================


struct  BFu0c_BFu8c_BFu8ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu8c_BFu8ll) C1{ Fc:0 Fc:8 FL:8}



static void Test_BFu0c_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu8ll, BFu0c_BFu8c_BFu8ll)
//============================================================================


struct  BFu0c_BFu8c_BFu8s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu8c_BFu8s) C1{ Fc:0 Fc:8 Fs:8}



static void Test_BFu0c_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu8s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu8s, BFu0c_BFu8c_BFu8s)
//============================================================================


struct  BFu0c_BFu8c_BFu9i  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu8c_BFu9i) C1{ Fc:0 Fc:8 Fi:9}



static void Test_BFu0c_BFu8c_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu9i");
    static STRUCT_IF_C BFu0c_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu9i, BFu0c_BFu8c_BFu9i)
//============================================================================


struct  BFu0c_BFu8c_BFu9ll  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu8c_BFu9ll) C1{ Fc:0 Fc:8 FL:9}



static void Test_BFu0c_BFu8c_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu9ll, BFu0c_BFu8c_BFu9ll)
//============================================================================


struct  BFu0c_BFu8c_BFu9s  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu8c_BFu9s) C1{ Fc:0 Fc:8 Fs:9}



static void Test_BFu0c_BFu8c_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8c_BFu9s");
    static STRUCT_IF_C BFu0c_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_BFu9s, BFu0c_BFu8c_BFu9s)
//============================================================================


struct  BFu0c_BFu8c_C  {
  unsigned char  :0;
  unsigned char v1:8;
  char v2;
};
//SIG(1 BFu0c_BFu8c_C) C1{ Fc:0 Fc:8 Fc}



static void Test_BFu0c_BFu8c_C()
{
  {
    init_simple_test("BFu0c_BFu8c_C");
    static STRUCT_IF_C BFu0c_BFu8c_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_C, BFu0c_BFu8c_C)
//============================================================================


struct  BFu0c_BFu8c_D  {
  unsigned char  :0;
  unsigned char v1:8;
  double v2;
};
//SIG(1 BFu0c_BFu8c_D) C1{ Fc:0 Fc:8 FL}



static void Test_BFu0c_BFu8c_D()
{
  {
    init_simple_test("BFu0c_BFu8c_D");
    static STRUCT_IF_C BFu0c_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8c_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_D, BFu0c_BFu8c_D)
//============================================================================


struct  BFu0c_BFu8c_F  {
  unsigned char  :0;
  unsigned char v1:8;
  float v2;
};
//SIG(1 BFu0c_BFu8c_F) C1{ Fc:0 Fc:8 Fi}



static void Test_BFu0c_BFu8c_F()
{
  {
    init_simple_test("BFu0c_BFu8c_F");
    static STRUCT_IF_C BFu0c_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8c_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_F, BFu0c_BFu8c_F)
//============================================================================


struct  BFu0c_BFu8c_I  {
  unsigned char  :0;
  unsigned char v1:8;
  int v2;
};
//SIG(1 BFu0c_BFu8c_I) C1{ Fc:0 Fc:8 Fi}



static void Test_BFu0c_BFu8c_I()
{
  {
    init_simple_test("BFu0c_BFu8c_I");
    static STRUCT_IF_C BFu0c_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8c_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_I, BFu0c_BFu8c_I)
//============================================================================


struct  BFu0c_BFu8c_Ip  {
  unsigned char  :0;
  unsigned char v1:8;
  int *v2;
};
//SIG(1 BFu0c_BFu8c_Ip) C1{ Fc:0 Fc:8 Fp}



static void Test_BFu0c_BFu8c_Ip()
{
  {
    init_simple_test("BFu0c_BFu8c_Ip");
    static STRUCT_IF_C BFu0c_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8c_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Ip, BFu0c_BFu8c_Ip)
//============================================================================


struct  BFu0c_BFu8c_L  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu8c_L) C1{ Fc:0 Fc:8 FL}



static void Test_BFu0c_BFu8c_L()
{
  {
    init_simple_test("BFu0c_BFu8c_L");
    static STRUCT_IF_C BFu0c_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8c_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_L, BFu0c_BFu8c_L)
//============================================================================


struct  BFu0c_BFu8c_S  {
  unsigned char  :0;
  unsigned char v1:8;
  short v2;
};
//SIG(1 BFu0c_BFu8c_S) C1{ Fc:0 Fc:8 Fs}



static void Test_BFu0c_BFu8c_S()
{
  {
    init_simple_test("BFu0c_BFu8c_S");
    static STRUCT_IF_C BFu0c_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8c_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_S, BFu0c_BFu8c_S)
//============================================================================


struct  BFu0c_BFu8c_Uc  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu8c_Uc) C1{ Fc:0 Fc:8 Fc}



static void Test_BFu0c_BFu8c_Uc()
{
  {
    init_simple_test("BFu0c_BFu8c_Uc");
    static STRUCT_IF_C BFu0c_BFu8c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu0c_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8c_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Uc, BFu0c_BFu8c_Uc)
//============================================================================


struct  BFu0c_BFu8c_Ui  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu8c_Ui) C1{ Fc:0 Fc:8 Fi}



static void Test_BFu0c_BFu8c_Ui()
{
  {
    init_simple_test("BFu0c_BFu8c_Ui");
    static STRUCT_IF_C BFu0c_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8c_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Ui, BFu0c_BFu8c_Ui)
//============================================================================


struct  BFu0c_BFu8c_Ul  {
  unsigned char  :0;
  unsigned char v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu8c_Ul) C1{ Fc:0 Fc:8 FL}



static void Test_BFu0c_BFu8c_Ul()
{
  {
    init_simple_test("BFu0c_BFu8c_Ul");
    static STRUCT_IF_C BFu0c_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8c_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Ul, BFu0c_BFu8c_Ul)
//============================================================================


struct  BFu0c_BFu8c_Us  {
  unsigned char  :0;
  unsigned char v1:8;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu8c_Us) C1{ Fc:0 Fc:8 Fs}



static void Test_BFu0c_BFu8c_Us()
{
  {
    init_simple_test("BFu0c_BFu8c_Us");
    static STRUCT_IF_C BFu0c_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8c_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Us, BFu0c_BFu8c_Us)
//============================================================================


struct  BFu0c_BFu8c_Vp  {
  unsigned char  :0;
  unsigned char v1:8;
  void *v2;
};
//SIG(1 BFu0c_BFu8c_Vp) C1{ Fc:0 Fc:8 Fp}



static void Test_BFu0c_BFu8c_Vp()
{
  {
    init_simple_test("BFu0c_BFu8c_Vp");
    static STRUCT_IF_C BFu0c_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8c_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8c_Vp, BFu0c_BFu8c_Vp)
//============================================================================


struct  BFu0c_BFu8i  {
  unsigned char  :0;
  unsigned int v1:8;
};
//SIG(1 BFu0c_BFu8i) C1{ Fc:0 Fi:8}



static void Test_BFu0c_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8i");
    static STRUCT_IF_C BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i, BFu0c_BFu8i)
//============================================================================


struct  BFu0c_BFu8i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu8i_BFu0c) C1{ Fc:0 Fi:8 Fc:0}



static void Test_BFu0c_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu0c, BFu0c_BFu8i_BFu0c)
//============================================================================


struct  BFu0c_BFu8i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu8i_BFu0i) C1{ Fc:0 Fi:8 Fi:0}



static void Test_BFu0c_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu0i, BFu0c_BFu8i_BFu0i)
//============================================================================


struct  BFu0c_BFu8i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu8i_BFu0ll) C1{ Fc:0 Fi:8 FL:0}



static void Test_BFu0c_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu0ll, BFu0c_BFu8i_BFu0ll)
//============================================================================


struct  BFu0c_BFu8i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu8i_BFu0s) C1{ Fc:0 Fi:8 Fs:0}



static void Test_BFu0c_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu0s, BFu0c_BFu8i_BFu0s)
//============================================================================


struct  BFu0c_BFu8i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu8i_BFu15i) C1{ Fc:0 Fi:8 Fi:15}



static void Test_BFu0c_BFu8i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu15i, BFu0c_BFu8i_BFu15i)
//============================================================================


struct  BFu0c_BFu8i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu8i_BFu15ll) C1{ Fc:0 Fi:8 FL:15}



static void Test_BFu0c_BFu8i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu15ll, BFu0c_BFu8i_BFu15ll)
//============================================================================


struct  BFu0c_BFu8i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu8i_BFu15s) C1{ Fc:0 Fi:8 Fs:15}



static void Test_BFu0c_BFu8i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu15s, BFu0c_BFu8i_BFu15s)
//============================================================================


struct  BFu0c_BFu8i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu8i_BFu16i) C1{ Fc:0 Fi:8 Fi:16}



static void Test_BFu0c_BFu8i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu16i, BFu0c_BFu8i_BFu16i)
//============================================================================


struct  BFu0c_BFu8i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu8i_BFu16ll) C1{ Fc:0 Fi:8 FL:16}



static void Test_BFu0c_BFu8i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu16ll, BFu0c_BFu8i_BFu16ll)
//============================================================================


struct  BFu0c_BFu8i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu8i_BFu16s) C1{ Fc:0 Fi:8 Fs:16}



static void Test_BFu0c_BFu8i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu16s, BFu0c_BFu8i_BFu16s)
//============================================================================


struct  BFu0c_BFu8i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu8i_BFu17i) C1{ Fc:0 Fi:8 Fi:17}



static void Test_BFu0c_BFu8i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu17i, BFu0c_BFu8i_BFu17i)
//============================================================================


struct  BFu0c_BFu8i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu8i_BFu17ll) C1{ Fc:0 Fi:8 FL:17}



static void Test_BFu0c_BFu8i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu17ll, BFu0c_BFu8i_BFu17ll)
//============================================================================


struct  BFu0c_BFu8i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu8i_BFu1c) C1{ Fc:0 Fi:8 Fc:1}



static void Test_BFu0c_BFu8i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu1c, BFu0c_BFu8i_BFu1c)
//============================================================================


struct  BFu0c_BFu8i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu8i_BFu1i) C1{ Fc:0 Fi:8 Fi:1}



static void Test_BFu0c_BFu8i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu1i, BFu0c_BFu8i_BFu1i)
//============================================================================


struct  BFu0c_BFu8i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu8i_BFu1ll) C1{ Fc:0 Fi:8 FL:1}



static void Test_BFu0c_BFu8i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu1ll, BFu0c_BFu8i_BFu1ll)
//============================================================================


struct  BFu0c_BFu8i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu8i_BFu1s) C1{ Fc:0 Fi:8 Fs:1}



static void Test_BFu0c_BFu8i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu1s, BFu0c_BFu8i_BFu1s)
//============================================================================


struct  BFu0c_BFu8i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu8i_BFu31i) C1{ Fc:0 Fi:8 Fi:31}



static void Test_BFu0c_BFu8i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu31i, BFu0c_BFu8i_BFu31i)
//============================================================================


struct  BFu0c_BFu8i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu8i_BFu31ll) C1{ Fc:0 Fi:8 FL:31}



static void Test_BFu0c_BFu8i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu31ll, BFu0c_BFu8i_BFu31ll)
//============================================================================


struct  BFu0c_BFu8i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu8i_BFu32i) C1{ Fc:0 Fi:8 Fi:32}



static void Test_BFu0c_BFu8i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu32i, BFu0c_BFu8i_BFu32i)
//============================================================================


struct  BFu0c_BFu8i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu8i_BFu32ll) C1{ Fc:0 Fi:8 FL:32}



static void Test_BFu0c_BFu8i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu32ll, BFu0c_BFu8i_BFu32ll)
//============================================================================


struct  BFu0c_BFu8i_BFu33  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu8i_BFu33) C1{ Fc:0 Fi:8 FL:33}



static void Test_BFu0c_BFu8i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu33");
    static STRUCT_IF_C BFu0c_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu33, BFu0c_BFu8i_BFu33)
//============================================================================


struct  BFu0c_BFu8i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu8i_BFu7c) C1{ Fc:0 Fi:8 Fc:7}



static void Test_BFu0c_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu7c, BFu0c_BFu8i_BFu7c)
//============================================================================


struct  BFu0c_BFu8i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu8i_BFu7i) C1{ Fc:0 Fi:8 Fi:7}



static void Test_BFu0c_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu7i, BFu0c_BFu8i_BFu7i)
//============================================================================


struct  BFu0c_BFu8i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu8i_BFu7ll) C1{ Fc:0 Fi:8 FL:7}



static void Test_BFu0c_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu7ll, BFu0c_BFu8i_BFu7ll)
//============================================================================


struct  BFu0c_BFu8i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu8i_BFu7s) C1{ Fc:0 Fi:8 Fs:7}



static void Test_BFu0c_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu7s, BFu0c_BFu8i_BFu7s)
//============================================================================


struct  BFu0c_BFu8i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu8i_BFu8c) C1{ Fc:0 Fi:8 Fc:8}



static void Test_BFu0c_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu8c, BFu0c_BFu8i_BFu8c)
//============================================================================


struct  BFu0c_BFu8i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu8i_BFu8i) C1{ Fc:0 Fi:8 Fi:8}



static void Test_BFu0c_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu8i, BFu0c_BFu8i_BFu8i)
//============================================================================


struct  BFu0c_BFu8i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu8i_BFu8ll) C1{ Fc:0 Fi:8 FL:8}



static void Test_BFu0c_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu8ll, BFu0c_BFu8i_BFu8ll)
//============================================================================


struct  BFu0c_BFu8i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu8i_BFu8s) C1{ Fc:0 Fi:8 Fs:8}



static void Test_BFu0c_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu8s, BFu0c_BFu8i_BFu8s)
//============================================================================


struct  BFu0c_BFu8i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu8i_BFu9i) C1{ Fc:0 Fi:8 Fi:9}



static void Test_BFu0c_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu9i, BFu0c_BFu8i_BFu9i)
//============================================================================


struct  BFu0c_BFu8i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu8i_BFu9ll) C1{ Fc:0 Fi:8 FL:9}



static void Test_BFu0c_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu9ll, BFu0c_BFu8i_BFu9ll)
//============================================================================


struct  BFu0c_BFu8i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu8i_BFu9s) C1{ Fc:0 Fi:8 Fs:9}



static void Test_BFu0c_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_BFu9s, BFu0c_BFu8i_BFu9s)
//============================================================================


struct  BFu0c_BFu8i_C  {
  unsigned char  :0;
  unsigned int v1:8;
  char v2;
};
//SIG(1 BFu0c_BFu8i_C) C1{ Fc:0 Fi:8 Fc}



static void Test_BFu0c_BFu8i_C()
{
  {
    init_simple_test("BFu0c_BFu8i_C");
    static STRUCT_IF_C BFu0c_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_C, BFu0c_BFu8i_C)
//============================================================================


struct  BFu0c_BFu8i_D  {
  unsigned char  :0;
  unsigned int v1:8;
  double v2;
};
//SIG(1 BFu0c_BFu8i_D) C1{ Fc:0 Fi:8 FL}



static void Test_BFu0c_BFu8i_D()
{
  {
    init_simple_test("BFu0c_BFu8i_D");
    static STRUCT_IF_C BFu0c_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_D, BFu0c_BFu8i_D)
//============================================================================


struct  BFu0c_BFu8i_F  {
  unsigned char  :0;
  unsigned int v1:8;
  float v2;
};
//SIG(1 BFu0c_BFu8i_F) C1{ Fc:0 Fi:8 Fi}



static void Test_BFu0c_BFu8i_F()
{
  {
    init_simple_test("BFu0c_BFu8i_F");
    static STRUCT_IF_C BFu0c_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_F, BFu0c_BFu8i_F)
//============================================================================


struct  BFu0c_BFu8i_I  {
  unsigned char  :0;
  unsigned int v1:8;
  int v2;
};
//SIG(1 BFu0c_BFu8i_I) C1{ Fc:0 Fi:8 Fi}



static void Test_BFu0c_BFu8i_I()
{
  {
    init_simple_test("BFu0c_BFu8i_I");
    static STRUCT_IF_C BFu0c_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_I, BFu0c_BFu8i_I)
//============================================================================


struct  BFu0c_BFu8i_Ip  {
  unsigned char  :0;
  unsigned int v1:8;
  int *v2;
};
//SIG(1 BFu0c_BFu8i_Ip) C1{ Fc:0 Fi:8 Fp}



static void Test_BFu0c_BFu8i_Ip()
{
  {
    init_simple_test("BFu0c_BFu8i_Ip");
    static STRUCT_IF_C BFu0c_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Ip, BFu0c_BFu8i_Ip)
//============================================================================


struct  BFu0c_BFu8i_L  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu8i_L) C1{ Fc:0 Fi:8 FL}



static void Test_BFu0c_BFu8i_L()
{
  {
    init_simple_test("BFu0c_BFu8i_L");
    static STRUCT_IF_C BFu0c_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_L, BFu0c_BFu8i_L)
//============================================================================


struct  BFu0c_BFu8i_S  {
  unsigned char  :0;
  unsigned int v1:8;
  short v2;
};
//SIG(1 BFu0c_BFu8i_S) C1{ Fc:0 Fi:8 Fs}



static void Test_BFu0c_BFu8i_S()
{
  {
    init_simple_test("BFu0c_BFu8i_S");
    static STRUCT_IF_C BFu0c_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_S, BFu0c_BFu8i_S)
//============================================================================


struct  BFu0c_BFu8i_Uc  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu8i_Uc) C1{ Fc:0 Fi:8 Fc}



static void Test_BFu0c_BFu8i_Uc()
{
  {
    init_simple_test("BFu0c_BFu8i_Uc");
    static STRUCT_IF_C BFu0c_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Uc, BFu0c_BFu8i_Uc)
//============================================================================


struct  BFu0c_BFu8i_Ui  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu8i_Ui) C1{ Fc:0 Fi:8 Fi}



static void Test_BFu0c_BFu8i_Ui()
{
  {
    init_simple_test("BFu0c_BFu8i_Ui");
    static STRUCT_IF_C BFu0c_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Ui, BFu0c_BFu8i_Ui)
//============================================================================


struct  BFu0c_BFu8i_Ul  {
  unsigned char  :0;
  unsigned int v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu8i_Ul) C1{ Fc:0 Fi:8 FL}



static void Test_BFu0c_BFu8i_Ul()
{
  {
    init_simple_test("BFu0c_BFu8i_Ul");
    static STRUCT_IF_C BFu0c_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Ul, BFu0c_BFu8i_Ul)
//============================================================================


struct  BFu0c_BFu8i_Us  {
  unsigned char  :0;
  unsigned int v1:8;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu8i_Us) C1{ Fc:0 Fi:8 Fs}



static void Test_BFu0c_BFu8i_Us()
{
  {
    init_simple_test("BFu0c_BFu8i_Us");
    static STRUCT_IF_C BFu0c_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Us, BFu0c_BFu8i_Us)
//============================================================================


struct  BFu0c_BFu8i_Vp  {
  unsigned char  :0;
  unsigned int v1:8;
  void *v2;
};
//SIG(1 BFu0c_BFu8i_Vp) C1{ Fc:0 Fi:8 Fp}



static void Test_BFu0c_BFu8i_Vp()
{
  {
    init_simple_test("BFu0c_BFu8i_Vp");
    static STRUCT_IF_C BFu0c_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8i_Vp, BFu0c_BFu8i_Vp)
//============================================================================


struct  BFu0c_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:8;
};
//SIG(1 BFu0c_BFu8ll) C1{ Fc:0 FL:8}



static void Test_BFu0c_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll, BFu0c_BFu8ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu8ll_BFu0c) C1{ Fc:0 FL:8 Fc:0}



static void Test_BFu0c_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu0c, BFu0c_BFu8ll_BFu0c)
//============================================================================


struct  BFu0c_BFu8ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu8ll_BFu0i) C1{ Fc:0 FL:8 Fi:0}



static void Test_BFu0c_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu0i, BFu0c_BFu8ll_BFu0i)
//============================================================================


struct  BFu0c_BFu8ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu8ll_BFu0ll) C1{ Fc:0 FL:8 FL:0}



static void Test_BFu0c_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu0ll, BFu0c_BFu8ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu8ll_BFu0s) C1{ Fc:0 FL:8 Fs:0}



static void Test_BFu0c_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu0s, BFu0c_BFu8ll_BFu0s)
//============================================================================


struct  BFu0c_BFu8ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu8ll_BFu15i) C1{ Fc:0 FL:8 Fi:15}



static void Test_BFu0c_BFu8ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu15i, BFu0c_BFu8ll_BFu15i)
//============================================================================


struct  BFu0c_BFu8ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu8ll_BFu15ll) C1{ Fc:0 FL:8 FL:15}



static void Test_BFu0c_BFu8ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu15ll, BFu0c_BFu8ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu8ll_BFu15s) C1{ Fc:0 FL:8 Fs:15}



static void Test_BFu0c_BFu8ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu15s, BFu0c_BFu8ll_BFu15s)
//============================================================================


struct  BFu0c_BFu8ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu8ll_BFu16i) C1{ Fc:0 FL:8 Fi:16}



static void Test_BFu0c_BFu8ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu16i, BFu0c_BFu8ll_BFu16i)
//============================================================================


struct  BFu0c_BFu8ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu8ll_BFu16ll) C1{ Fc:0 FL:8 FL:16}



static void Test_BFu0c_BFu8ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu16ll, BFu0c_BFu8ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu8ll_BFu16s) C1{ Fc:0 FL:8 Fs:16}



static void Test_BFu0c_BFu8ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu16s, BFu0c_BFu8ll_BFu16s)
//============================================================================


struct  BFu0c_BFu8ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu8ll_BFu17i) C1{ Fc:0 FL:8 Fi:17}



static void Test_BFu0c_BFu8ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu17i, BFu0c_BFu8ll_BFu17i)
//============================================================================


struct  BFu0c_BFu8ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu8ll_BFu17ll) C1{ Fc:0 FL:8 FL:17}



static void Test_BFu0c_BFu8ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu17ll, BFu0c_BFu8ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu8ll_BFu1c) C1{ Fc:0 FL:8 Fc:1}



static void Test_BFu0c_BFu8ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu1c, BFu0c_BFu8ll_BFu1c)
//============================================================================


struct  BFu0c_BFu8ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu8ll_BFu1i) C1{ Fc:0 FL:8 Fi:1}



static void Test_BFu0c_BFu8ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu1i, BFu0c_BFu8ll_BFu1i)
//============================================================================


struct  BFu0c_BFu8ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu8ll_BFu1ll) C1{ Fc:0 FL:8 FL:1}



static void Test_BFu0c_BFu8ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu1ll, BFu0c_BFu8ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu8ll_BFu1s) C1{ Fc:0 FL:8 Fs:1}



static void Test_BFu0c_BFu8ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu1s, BFu0c_BFu8ll_BFu1s)
//============================================================================


struct  BFu0c_BFu8ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu8ll_BFu31i) C1{ Fc:0 FL:8 Fi:31}



static void Test_BFu0c_BFu8ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu31i, BFu0c_BFu8ll_BFu31i)
//============================================================================


struct  BFu0c_BFu8ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu8ll_BFu31ll) C1{ Fc:0 FL:8 FL:31}



static void Test_BFu0c_BFu8ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu31ll, BFu0c_BFu8ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu8ll_BFu32i) C1{ Fc:0 FL:8 Fi:32}



static void Test_BFu0c_BFu8ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu32i, BFu0c_BFu8ll_BFu32i)
//============================================================================


struct  BFu0c_BFu8ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu8ll_BFu32ll) C1{ Fc:0 FL:8 FL:32}



static void Test_BFu0c_BFu8ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu32ll, BFu0c_BFu8ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu8ll_BFu33) C1{ Fc:0 FL:8 FL:33}



static void Test_BFu0c_BFu8ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu33, BFu0c_BFu8ll_BFu33)
//============================================================================


struct  BFu0c_BFu8ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu8ll_BFu7c) C1{ Fc:0 FL:8 Fc:7}



static void Test_BFu0c_BFu8ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu7c, BFu0c_BFu8ll_BFu7c)
//============================================================================


struct  BFu0c_BFu8ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu8ll_BFu7i) C1{ Fc:0 FL:8 Fi:7}



static void Test_BFu0c_BFu8ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu7i, BFu0c_BFu8ll_BFu7i)
//============================================================================


struct  BFu0c_BFu8ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu8ll_BFu7ll) C1{ Fc:0 FL:8 FL:7}



static void Test_BFu0c_BFu8ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu7ll, BFu0c_BFu8ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu8ll_BFu7s) C1{ Fc:0 FL:8 Fs:7}



static void Test_BFu0c_BFu8ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu7s, BFu0c_BFu8ll_BFu7s)
//============================================================================


struct  BFu0c_BFu8ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu8ll_BFu8c) C1{ Fc:0 FL:8 Fc:8}



static void Test_BFu0c_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu8c, BFu0c_BFu8ll_BFu8c)
//============================================================================


struct  BFu0c_BFu8ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu8ll_BFu8i) C1{ Fc:0 FL:8 Fi:8}



static void Test_BFu0c_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu8i, BFu0c_BFu8ll_BFu8i)
//============================================================================


struct  BFu0c_BFu8ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu8ll_BFu8ll) C1{ Fc:0 FL:8 FL:8}



static void Test_BFu0c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu8ll, BFu0c_BFu8ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu8ll_BFu8s) C1{ Fc:0 FL:8 Fs:8}



static void Test_BFu0c_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu8s, BFu0c_BFu8ll_BFu8s)
//============================================================================


struct  BFu0c_BFu8ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu8ll_BFu9i) C1{ Fc:0 FL:8 Fi:9}



static void Test_BFu0c_BFu8ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu9i, BFu0c_BFu8ll_BFu9i)
//============================================================================


struct  BFu0c_BFu8ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu8ll_BFu9ll) C1{ Fc:0 FL:8 FL:9}



static void Test_BFu0c_BFu8ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu9ll, BFu0c_BFu8ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu8ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu8ll_BFu9s) C1{ Fc:0 FL:8 Fs:9}



static void Test_BFu0c_BFu8ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_BFu9s, BFu0c_BFu8ll_BFu9s)
//============================================================================


struct  BFu0c_BFu8ll_C  {
  unsigned char  :0;
  __tsu64 v1:8;
  char v2;
};
//SIG(1 BFu0c_BFu8ll_C) C1{ Fc:0 FL:8 Fc}



static void Test_BFu0c_BFu8ll_C()
{
  {
    init_simple_test("BFu0c_BFu8ll_C");
    static STRUCT_IF_C BFu0c_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_C, BFu0c_BFu8ll_C)
//============================================================================


struct  BFu0c_BFu8ll_D  {
  unsigned char  :0;
  __tsu64 v1:8;
  double v2;
};
//SIG(1 BFu0c_BFu8ll_D) C1{ Fc:0 FL:8 FL}



static void Test_BFu0c_BFu8ll_D()
{
  {
    init_simple_test("BFu0c_BFu8ll_D");
    static STRUCT_IF_C BFu0c_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8ll_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_D, BFu0c_BFu8ll_D)
//============================================================================


struct  BFu0c_BFu8ll_F  {
  unsigned char  :0;
  __tsu64 v1:8;
  float v2;
};
//SIG(1 BFu0c_BFu8ll_F) C1{ Fc:0 FL:8 Fi}



static void Test_BFu0c_BFu8ll_F()
{
  {
    init_simple_test("BFu0c_BFu8ll_F");
    static STRUCT_IF_C BFu0c_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_F, BFu0c_BFu8ll_F)
//============================================================================


struct  BFu0c_BFu8ll_I  {
  unsigned char  :0;
  __tsu64 v1:8;
  int v2;
};
//SIG(1 BFu0c_BFu8ll_I) C1{ Fc:0 FL:8 Fi}



static void Test_BFu0c_BFu8ll_I()
{
  {
    init_simple_test("BFu0c_BFu8ll_I");
    static STRUCT_IF_C BFu0c_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_I, BFu0c_BFu8ll_I)
//============================================================================


struct  BFu0c_BFu8ll_Ip  {
  unsigned char  :0;
  __tsu64 v1:8;
  int *v2;
};
//SIG(1 BFu0c_BFu8ll_Ip) C1{ Fc:0 FL:8 Fp}



static void Test_BFu0c_BFu8ll_Ip()
{
  {
    init_simple_test("BFu0c_BFu8ll_Ip");
    static STRUCT_IF_C BFu0c_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Ip, BFu0c_BFu8ll_Ip)
//============================================================================


struct  BFu0c_BFu8ll_L  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu8ll_L) C1{ Fc:0 FL:8 FL}



static void Test_BFu0c_BFu8ll_L()
{
  {
    init_simple_test("BFu0c_BFu8ll_L");
    static STRUCT_IF_C BFu0c_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_L, BFu0c_BFu8ll_L)
//============================================================================


struct  BFu0c_BFu8ll_S  {
  unsigned char  :0;
  __tsu64 v1:8;
  short v2;
};
//SIG(1 BFu0c_BFu8ll_S) C1{ Fc:0 FL:8 Fs}



static void Test_BFu0c_BFu8ll_S()
{
  {
    init_simple_test("BFu0c_BFu8ll_S");
    static STRUCT_IF_C BFu0c_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_S, BFu0c_BFu8ll_S)
//============================================================================


struct  BFu0c_BFu8ll_Uc  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu8ll_Uc) C1{ Fc:0 FL:8 Fc}



static void Test_BFu0c_BFu8ll_Uc()
{
  {
    init_simple_test("BFu0c_BFu8ll_Uc");
    static STRUCT_IF_C BFu0c_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Uc, BFu0c_BFu8ll_Uc)
//============================================================================


struct  BFu0c_BFu8ll_Ui  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu8ll_Ui) C1{ Fc:0 FL:8 Fi}



static void Test_BFu0c_BFu8ll_Ui()
{
  {
    init_simple_test("BFu0c_BFu8ll_Ui");
    static STRUCT_IF_C BFu0c_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Ui, BFu0c_BFu8ll_Ui)
//============================================================================


struct  BFu0c_BFu8ll_Ul  {
  unsigned char  :0;
  __tsu64 v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu8ll_Ul) C1{ Fc:0 FL:8 FL}



static void Test_BFu0c_BFu8ll_Ul()
{
  {
    init_simple_test("BFu0c_BFu8ll_Ul");
    static STRUCT_IF_C BFu0c_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Ul, BFu0c_BFu8ll_Ul)
//============================================================================


struct  BFu0c_BFu8ll_Us  {
  unsigned char  :0;
  __tsu64 v1:8;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu8ll_Us) C1{ Fc:0 FL:8 Fs}



static void Test_BFu0c_BFu8ll_Us()
{
  {
    init_simple_test("BFu0c_BFu8ll_Us");
    static STRUCT_IF_C BFu0c_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Us, BFu0c_BFu8ll_Us)
//============================================================================


struct  BFu0c_BFu8ll_Vp  {
  unsigned char  :0;
  __tsu64 v1:8;
  void *v2;
};
//SIG(1 BFu0c_BFu8ll_Vp) C1{ Fc:0 FL:8 Fp}



static void Test_BFu0c_BFu8ll_Vp()
{
  {
    init_simple_test("BFu0c_BFu8ll_Vp");
    static STRUCT_IF_C BFu0c_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8ll_Vp, BFu0c_BFu8ll_Vp)
//============================================================================


struct  BFu0c_BFu8s  {
  unsigned char  :0;
  unsigned short v1:8;
};
//SIG(1 BFu0c_BFu8s) C1{ Fc:0 Fs:8}



static void Test_BFu0c_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8s");
    static STRUCT_IF_C BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s, BFu0c_BFu8s)
//============================================================================


struct  BFu0c_BFu8s_BFu0c  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu8s_BFu0c) C1{ Fc:0 Fs:8 Fc:0}



static void Test_BFu0c_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0c");
    static STRUCT_IF_C BFu0c_BFu8s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu0c, BFu0c_BFu8s_BFu0c)
//============================================================================


struct  BFu0c_BFu8s_BFu0i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu8s_BFu0i) C1{ Fc:0 Fs:8 Fi:0}



static void Test_BFu0c_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu0i, BFu0c_BFu8s_BFu0i)
//============================================================================


struct  BFu0c_BFu8s_BFu0ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu8s_BFu0ll) C1{ Fc:0 Fs:8 FL:0}



static void Test_BFu0c_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0c_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu0ll, BFu0c_BFu8s_BFu0ll)
//============================================================================


struct  BFu0c_BFu8s_BFu0s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu8s_BFu0s) C1{ Fc:0 Fs:8 Fs:0}



static void Test_BFu0c_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu0s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu0s, BFu0c_BFu8s_BFu0s)
//============================================================================


struct  BFu0c_BFu8s_BFu15i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu8s_BFu15i) C1{ Fc:0 Fs:8 Fi:15}



static void Test_BFu0c_BFu8s_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu15i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu15i, BFu0c_BFu8s_BFu15i)
//============================================================================


struct  BFu0c_BFu8s_BFu15ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu8s_BFu15ll) C1{ Fc:0 Fs:8 FL:15}



static void Test_BFu0c_BFu8s_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0c_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu15ll, BFu0c_BFu8s_BFu15ll)
//============================================================================


struct  BFu0c_BFu8s_BFu15s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu8s_BFu15s) C1{ Fc:0 Fs:8 Fs:15}



static void Test_BFu0c_BFu8s_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu15s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu15s, BFu0c_BFu8s_BFu15s)
//============================================================================


struct  BFu0c_BFu8s_BFu16i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu8s_BFu16i) C1{ Fc:0 Fs:8 Fi:16}



static void Test_BFu0c_BFu8s_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu16i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu16i, BFu0c_BFu8s_BFu16i)
//============================================================================


struct  BFu0c_BFu8s_BFu16ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu8s_BFu16ll) C1{ Fc:0 Fs:8 FL:16}



static void Test_BFu0c_BFu8s_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0c_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu16ll, BFu0c_BFu8s_BFu16ll)
//============================================================================


struct  BFu0c_BFu8s_BFu16s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu8s_BFu16s) C1{ Fc:0 Fs:8 Fs:16}



static void Test_BFu0c_BFu8s_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu16s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu16s, BFu0c_BFu8s_BFu16s)
//============================================================================


struct  BFu0c_BFu8s_BFu17i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu8s_BFu17i) C1{ Fc:0 Fs:8 Fi:17}



static void Test_BFu0c_BFu8s_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu17i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu17i, BFu0c_BFu8s_BFu17i)
//============================================================================


struct  BFu0c_BFu8s_BFu17ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu8s_BFu17ll) C1{ Fc:0 Fs:8 FL:17}



static void Test_BFu0c_BFu8s_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0c_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0c_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu17ll, BFu0c_BFu8s_BFu17ll)
//============================================================================


struct  BFu0c_BFu8s_BFu1c  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu8s_BFu1c) C1{ Fc:0 Fs:8 Fc:1}



static void Test_BFu0c_BFu8s_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1c");
    static STRUCT_IF_C BFu0c_BFu8s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu1c, BFu0c_BFu8s_BFu1c)
//============================================================================


struct  BFu0c_BFu8s_BFu1i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu8s_BFu1i) C1{ Fc:0 Fs:8 Fi:1}



static void Test_BFu0c_BFu8s_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu1i, BFu0c_BFu8s_BFu1i)
//============================================================================


struct  BFu0c_BFu8s_BFu1ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu8s_BFu1ll) C1{ Fc:0 Fs:8 FL:1}



static void Test_BFu0c_BFu8s_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu1ll, BFu0c_BFu8s_BFu1ll)
//============================================================================


struct  BFu0c_BFu8s_BFu1s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu8s_BFu1s) C1{ Fc:0 Fs:8 Fs:1}



static void Test_BFu0c_BFu8s_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu1s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0c_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu1s, BFu0c_BFu8s_BFu1s)
//============================================================================


struct  BFu0c_BFu8s_BFu31i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu8s_BFu31i) C1{ Fc:0 Fs:8 Fi:31}



static void Test_BFu0c_BFu8s_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu31i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu31i, BFu0c_BFu8s_BFu31i)
//============================================================================


struct  BFu0c_BFu8s_BFu31ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu8s_BFu31ll) C1{ Fc:0 Fs:8 FL:31}



static void Test_BFu0c_BFu8s_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0c_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu31ll, BFu0c_BFu8s_BFu31ll)
//============================================================================


struct  BFu0c_BFu8s_BFu32i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu8s_BFu32i) C1{ Fc:0 Fs:8 Fi:32}



static void Test_BFu0c_BFu8s_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu32i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu32i, BFu0c_BFu8s_BFu32i)
//============================================================================


struct  BFu0c_BFu8s_BFu32ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu8s_BFu32ll) C1{ Fc:0 Fs:8 FL:32}



static void Test_BFu0c_BFu8s_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0c_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu32ll, BFu0c_BFu8s_BFu32ll)
//============================================================================


struct  BFu0c_BFu8s_BFu33  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu8s_BFu33) C1{ Fc:0 Fs:8 FL:33}



static void Test_BFu0c_BFu8s_BFu33()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu33");
    static STRUCT_IF_C BFu0c_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0c_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0c_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu33, BFu0c_BFu8s_BFu33)
//============================================================================


struct  BFu0c_BFu8s_BFu7c  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu8s_BFu7c) C1{ Fc:0 Fs:8 Fc:7}



static void Test_BFu0c_BFu8s_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7c");
    static STRUCT_IF_C BFu0c_BFu8s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu7c, BFu0c_BFu8s_BFu7c)
//============================================================================


struct  BFu0c_BFu8s_BFu7i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu8s_BFu7i) C1{ Fc:0 Fs:8 Fi:7}



static void Test_BFu0c_BFu8s_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu7i, BFu0c_BFu8s_BFu7i)
//============================================================================


struct  BFu0c_BFu8s_BFu7ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu8s_BFu7ll) C1{ Fc:0 Fs:8 FL:7}



static void Test_BFu0c_BFu8s_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu7ll, BFu0c_BFu8s_BFu7ll)
//============================================================================


struct  BFu0c_BFu8s_BFu7s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu8s_BFu7s) C1{ Fc:0 Fs:8 Fs:7}



static void Test_BFu0c_BFu8s_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu7s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0c_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0c_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu7s, BFu0c_BFu8s_BFu7s)
//============================================================================


struct  BFu0c_BFu8s_BFu8c  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu8s_BFu8c) C1{ Fc:0 Fs:8 Fc:8}



static void Test_BFu0c_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8c");
    static STRUCT_IF_C BFu0c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu8c, BFu0c_BFu8s_BFu8c)
//============================================================================


struct  BFu0c_BFu8s_BFu8i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu8s_BFu8i) C1{ Fc:0 Fs:8 Fi:8}



static void Test_BFu0c_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu8i, BFu0c_BFu8s_BFu8i)
//============================================================================


struct  BFu0c_BFu8s_BFu8ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu8s_BFu8ll) C1{ Fc:0 Fs:8 FL:8}



static void Test_BFu0c_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu8ll, BFu0c_BFu8s_BFu8ll)
//============================================================================


struct  BFu0c_BFu8s_BFu8s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu8s_BFu8s) C1{ Fc:0 Fs:8 Fs:8}



static void Test_BFu0c_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu8s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu8s, BFu0c_BFu8s_BFu8s)
//============================================================================


struct  BFu0c_BFu8s_BFu9i  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu8s_BFu9i) C1{ Fc:0 Fs:8 Fi:9}



static void Test_BFu0c_BFu8s_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu9i");
    static STRUCT_IF_C BFu0c_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu9i, BFu0c_BFu8s_BFu9i)
//============================================================================


struct  BFu0c_BFu8s_BFu9ll  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu8s_BFu9ll) C1{ Fc:0 Fs:8 FL:9}



static void Test_BFu0c_BFu8s_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0c_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu9ll, BFu0c_BFu8s_BFu9ll)
//============================================================================


struct  BFu0c_BFu8s_BFu9s  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu8s_BFu9s) C1{ Fc:0 Fs:8 Fs:9}



static void Test_BFu0c_BFu8s_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu8s_BFu9s");
    static STRUCT_IF_C BFu0c_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_BFu9s, BFu0c_BFu8s_BFu9s)
//============================================================================


struct  BFu0c_BFu8s_C  {
  unsigned char  :0;
  unsigned short v1:8;
  char v2;
};
//SIG(1 BFu0c_BFu8s_C) C1{ Fc:0 Fs:8 Fc}



static void Test_BFu0c_BFu8s_C()
{
  {
    init_simple_test("BFu0c_BFu8s_C");
    static STRUCT_IF_C BFu0c_BFu8s_C lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_C");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_C, BFu0c_BFu8s_C)
//============================================================================


struct  BFu0c_BFu8s_D  {
  unsigned char  :0;
  unsigned short v1:8;
  double v2;
};
//SIG(1 BFu0c_BFu8s_D) C1{ Fc:0 Fs:8 FL}



static void Test_BFu0c_BFu8s_D()
{
  {
    init_simple_test("BFu0c_BFu8s_D");
    static STRUCT_IF_C BFu0c_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8s_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_D, BFu0c_BFu8s_D)
//============================================================================


struct  BFu0c_BFu8s_F  {
  unsigned char  :0;
  unsigned short v1:8;
  float v2;
};
//SIG(1 BFu0c_BFu8s_F) C1{ Fc:0 Fs:8 Fi}



static void Test_BFu0c_BFu8s_F()
{
  {
    init_simple_test("BFu0c_BFu8s_F");
    static STRUCT_IF_C BFu0c_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8s_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_F, BFu0c_BFu8s_F)
//============================================================================


struct  BFu0c_BFu8s_I  {
  unsigned char  :0;
  unsigned short v1:8;
  int v2;
};
//SIG(1 BFu0c_BFu8s_I) C1{ Fc:0 Fs:8 Fi}



static void Test_BFu0c_BFu8s_I()
{
  {
    init_simple_test("BFu0c_BFu8s_I");
    static STRUCT_IF_C BFu0c_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8s_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_I, BFu0c_BFu8s_I)
//============================================================================


struct  BFu0c_BFu8s_Ip  {
  unsigned char  :0;
  unsigned short v1:8;
  int *v2;
};
//SIG(1 BFu0c_BFu8s_Ip) C1{ Fc:0 Fs:8 Fp}



static void Test_BFu0c_BFu8s_Ip()
{
  {
    init_simple_test("BFu0c_BFu8s_Ip");
    static STRUCT_IF_C BFu0c_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8s_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Ip, BFu0c_BFu8s_Ip)
//============================================================================


struct  BFu0c_BFu8s_L  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu8s_L) C1{ Fc:0 Fs:8 FL}



static void Test_BFu0c_BFu8s_L()
{
  {
    init_simple_test("BFu0c_BFu8s_L");
    static STRUCT_IF_C BFu0c_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8s_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_L, BFu0c_BFu8s_L)
//============================================================================


struct  BFu0c_BFu8s_S  {
  unsigned char  :0;
  unsigned short v1:8;
  short v2;
};
//SIG(1 BFu0c_BFu8s_S) C1{ Fc:0 Fs:8 Fs}



static void Test_BFu0c_BFu8s_S()
{
  {
    init_simple_test("BFu0c_BFu8s_S");
    static STRUCT_IF_C BFu0c_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8s_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_S, BFu0c_BFu8s_S)
//============================================================================


struct  BFu0c_BFu8s_Uc  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu8s_Uc) C1{ Fc:0 Fs:8 Fc}



static void Test_BFu0c_BFu8s_Uc()
{
  {
    init_simple_test("BFu0c_BFu8s_Uc");
    static STRUCT_IF_C BFu0c_BFu8s_Uc lv;
    check2(sizeof(lv), 2, "sizeof(BFu0c_BFu8s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Uc");
    check_field_offset(lv, v2, 1, "BFu0c_BFu8s_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Uc, BFu0c_BFu8s_Uc)
//============================================================================


struct  BFu0c_BFu8s_Ui  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu8s_Ui) C1{ Fc:0 Fs:8 Fi}



static void Test_BFu0c_BFu8s_Ui()
{
  {
    init_simple_test("BFu0c_BFu8s_Ui");
    static STRUCT_IF_C BFu0c_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu8s_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Ui, BFu0c_BFu8s_Ui)
//============================================================================


struct  BFu0c_BFu8s_Ul  {
  unsigned char  :0;
  unsigned short v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu8s_Ul) C1{ Fc:0 Fs:8 FL}



static void Test_BFu0c_BFu8s_Ul()
{
  {
    init_simple_test("BFu0c_BFu8s_Ul");
    static STRUCT_IF_C BFu0c_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8s_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Ul, BFu0c_BFu8s_Ul)
//============================================================================


struct  BFu0c_BFu8s_Us  {
  unsigned char  :0;
  unsigned short v1:8;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu8s_Us) C1{ Fc:0 Fs:8 Fs}



static void Test_BFu0c_BFu8s_Us()
{
  {
    init_simple_test("BFu0c_BFu8s_Us");
    static STRUCT_IF_C BFu0c_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu8s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu0c_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu8s_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Us, BFu0c_BFu8s_Us)
//============================================================================


struct  BFu0c_BFu8s_Vp  {
  unsigned char  :0;
  unsigned short v1:8;
  void *v2;
};
//SIG(1 BFu0c_BFu8s_Vp) C1{ Fc:0 Fs:8 Fp}



static void Test_BFu0c_BFu8s_Vp()
{
  {
    init_simple_test("BFu0c_BFu8s_Vp");
    static STRUCT_IF_C BFu0c_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0c_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu8s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu8s_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu8s_Vp, BFu0c_BFu8s_Vp)
//============================================================================


struct  BFu0c_BFu9i  {
  unsigned char  :0;
  unsigned int v1:9;
};
//SIG(1 BFu0c_BFu9i) C1{ Fc:0 Fi:9}



static void Test_BFu0c_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9i");
    static STRUCT_IF_C BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i, BFu0c_BFu9i)
//============================================================================


struct  BFu0c_BFu9i_BFu0c  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu9i_BFu0c) C1{ Fc:0 Fi:9 Fc:0}



static void Test_BFu0c_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0c");
    static STRUCT_IF_C BFu0c_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu0c, BFu0c_BFu9i_BFu0c)
//============================================================================


struct  BFu0c_BFu9i_BFu0i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu9i_BFu0i) C1{ Fc:0 Fi:9 Fi:0}



static void Test_BFu0c_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu0i, BFu0c_BFu9i_BFu0i)
//============================================================================


struct  BFu0c_BFu9i_BFu0ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu9i_BFu0ll) C1{ Fc:0 Fi:9 FL:0}



static void Test_BFu0c_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0c_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu0ll, BFu0c_BFu9i_BFu0ll)
//============================================================================


struct  BFu0c_BFu9i_BFu0s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu9i_BFu0s) C1{ Fc:0 Fi:9 Fs:0}



static void Test_BFu0c_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu0s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu0s, BFu0c_BFu9i_BFu0s)
//============================================================================


struct  BFu0c_BFu9i_BFu15i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu9i_BFu15i) C1{ Fc:0 Fi:9 Fi:15}



static void Test_BFu0c_BFu9i_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu15i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu15i, BFu0c_BFu9i_BFu15i)
//============================================================================


struct  BFu0c_BFu9i_BFu15ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu9i_BFu15ll) C1{ Fc:0 Fi:9 FL:15}



static void Test_BFu0c_BFu9i_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu15ll, BFu0c_BFu9i_BFu15ll)
//============================================================================


struct  BFu0c_BFu9i_BFu15s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu9i_BFu15s) C1{ Fc:0 Fi:9 Fs:15}



static void Test_BFu0c_BFu9i_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu15s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu15s, BFu0c_BFu9i_BFu15s)
//============================================================================


struct  BFu0c_BFu9i_BFu16i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu9i_BFu16i) C1{ Fc:0 Fi:9 Fi:16}



static void Test_BFu0c_BFu9i_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu16i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu16i, BFu0c_BFu9i_BFu16i)
//============================================================================


struct  BFu0c_BFu9i_BFu16ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu9i_BFu16ll) C1{ Fc:0 Fi:9 FL:16}



static void Test_BFu0c_BFu9i_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu16ll, BFu0c_BFu9i_BFu16ll)
//============================================================================


struct  BFu0c_BFu9i_BFu16s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu9i_BFu16s) C1{ Fc:0 Fi:9 Fs:16}



static void Test_BFu0c_BFu9i_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu16s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu16s, BFu0c_BFu9i_BFu16s)
//============================================================================


struct  BFu0c_BFu9i_BFu17i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu9i_BFu17i) C1{ Fc:0 Fi:9 Fi:17}



static void Test_BFu0c_BFu9i_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu17i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu17i, BFu0c_BFu9i_BFu17i)
//============================================================================


struct  BFu0c_BFu9i_BFu17ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu9i_BFu17ll) C1{ Fc:0 Fi:9 FL:17}



static void Test_BFu0c_BFu9i_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu17ll, BFu0c_BFu9i_BFu17ll)
//============================================================================


struct  BFu0c_BFu9i_BFu1c  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu9i_BFu1c) C1{ Fc:0 Fi:9 Fc:1}



static void Test_BFu0c_BFu9i_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1c");
    static STRUCT_IF_C BFu0c_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu1c, BFu0c_BFu9i_BFu1c)
//============================================================================


struct  BFu0c_BFu9i_BFu1i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu9i_BFu1i) C1{ Fc:0 Fi:9 Fi:1}



static void Test_BFu0c_BFu9i_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu1i, BFu0c_BFu9i_BFu1i)
//============================================================================


struct  BFu0c_BFu9i_BFu1ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu9i_BFu1ll) C1{ Fc:0 Fi:9 FL:1}



static void Test_BFu0c_BFu9i_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu1ll, BFu0c_BFu9i_BFu1ll)
//============================================================================


struct  BFu0c_BFu9i_BFu1s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu9i_BFu1s) C1{ Fc:0 Fi:9 Fs:1}



static void Test_BFu0c_BFu9i_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu1s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu1s, BFu0c_BFu9i_BFu1s)
//============================================================================


struct  BFu0c_BFu9i_BFu31i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu9i_BFu31i) C1{ Fc:0 Fi:9 Fi:31}



static void Test_BFu0c_BFu9i_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu31i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu31i, BFu0c_BFu9i_BFu31i)
//============================================================================


struct  BFu0c_BFu9i_BFu31ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu9i_BFu31ll) C1{ Fc:0 Fi:9 FL:31}



static void Test_BFu0c_BFu9i_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu31ll, BFu0c_BFu9i_BFu31ll)
//============================================================================


struct  BFu0c_BFu9i_BFu32i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu9i_BFu32i) C1{ Fc:0 Fi:9 Fi:32}



static void Test_BFu0c_BFu9i_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu32i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu32i, BFu0c_BFu9i_BFu32i)
//============================================================================


struct  BFu0c_BFu9i_BFu32ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu9i_BFu32ll) C1{ Fc:0 Fi:9 FL:32}



static void Test_BFu0c_BFu9i_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu32ll, BFu0c_BFu9i_BFu32ll)
//============================================================================


struct  BFu0c_BFu9i_BFu33  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu9i_BFu33) C1{ Fc:0 Fi:9 FL:33}



static void Test_BFu0c_BFu9i_BFu33()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu33");
    static STRUCT_IF_C BFu0c_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0c_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu33, BFu0c_BFu9i_BFu33)
//============================================================================


struct  BFu0c_BFu9i_BFu7c  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu9i_BFu7c) C1{ Fc:0 Fi:9 Fc:7}



static void Test_BFu0c_BFu9i_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7c");
    static STRUCT_IF_C BFu0c_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu7c, BFu0c_BFu9i_BFu7c)
//============================================================================


struct  BFu0c_BFu9i_BFu7i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu9i_BFu7i) C1{ Fc:0 Fi:9 Fi:7}



static void Test_BFu0c_BFu9i_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu7i, BFu0c_BFu9i_BFu7i)
//============================================================================


struct  BFu0c_BFu9i_BFu7ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu9i_BFu7ll) C1{ Fc:0 Fi:9 FL:7}



static void Test_BFu0c_BFu9i_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu7ll, BFu0c_BFu9i_BFu7ll)
//============================================================================


struct  BFu0c_BFu9i_BFu7s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu9i_BFu7s) C1{ Fc:0 Fi:9 Fs:7}



static void Test_BFu0c_BFu9i_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu7s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu7s, BFu0c_BFu9i_BFu7s)
//============================================================================


struct  BFu0c_BFu9i_BFu8c  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu9i_BFu8c) C1{ Fc:0 Fi:9 Fc:8}



static void Test_BFu0c_BFu9i_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8c");
    static STRUCT_IF_C BFu0c_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu8c, BFu0c_BFu9i_BFu8c)
//============================================================================


struct  BFu0c_BFu9i_BFu8i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu9i_BFu8i) C1{ Fc:0 Fi:9 Fi:8}



static void Test_BFu0c_BFu9i_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu8i, BFu0c_BFu9i_BFu8i)
//============================================================================


struct  BFu0c_BFu9i_BFu8ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu9i_BFu8ll) C1{ Fc:0 Fi:9 FL:8}



static void Test_BFu0c_BFu9i_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu8ll, BFu0c_BFu9i_BFu8ll)
//============================================================================


struct  BFu0c_BFu9i_BFu8s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu9i_BFu8s) C1{ Fc:0 Fi:9 Fs:8}



static void Test_BFu0c_BFu9i_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu8s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu8s, BFu0c_BFu9i_BFu8s)
//============================================================================


struct  BFu0c_BFu9i_BFu9i  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu9i_BFu9i) C1{ Fc:0 Fi:9 Fi:9}



static void Test_BFu0c_BFu9i_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu9i");
    static STRUCT_IF_C BFu0c_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu9i, BFu0c_BFu9i_BFu9i)
//============================================================================


struct  BFu0c_BFu9i_BFu9ll  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu9i_BFu9ll) C1{ Fc:0 Fi:9 FL:9}



static void Test_BFu0c_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu9ll, BFu0c_BFu9i_BFu9ll)
//============================================================================


struct  BFu0c_BFu9i_BFu9s  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu9i_BFu9s) C1{ Fc:0 Fi:9 Fs:9}



static void Test_BFu0c_BFu9i_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu9i_BFu9s");
    static STRUCT_IF_C BFu0c_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_BFu9s, BFu0c_BFu9i_BFu9s)
//============================================================================


struct  BFu0c_BFu9i_C  {
  unsigned char  :0;
  unsigned int v1:9;
  char v2;
};
//SIG(1 BFu0c_BFu9i_C) C1{ Fc:0 Fi:9 Fc}



static void Test_BFu0c_BFu9i_C()
{
  {
    init_simple_test("BFu0c_BFu9i_C");
    static STRUCT_IF_C BFu0c_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_C");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_C, BFu0c_BFu9i_C)
//============================================================================


struct  BFu0c_BFu9i_D  {
  unsigned char  :0;
  unsigned int v1:9;
  double v2;
};
//SIG(1 BFu0c_BFu9i_D) C1{ Fc:0 Fi:9 FL}



static void Test_BFu0c_BFu9i_D()
{
  {
    init_simple_test("BFu0c_BFu9i_D");
    static STRUCT_IF_C BFu0c_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu9i_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_D, BFu0c_BFu9i_D)
//============================================================================


struct  BFu0c_BFu9i_F  {
  unsigned char  :0;
  unsigned int v1:9;
  float v2;
};
//SIG(1 BFu0c_BFu9i_F) C1{ Fc:0 Fi:9 Fi}



static void Test_BFu0c_BFu9i_F()
{
  {
    init_simple_test("BFu0c_BFu9i_F");
    static STRUCT_IF_C BFu0c_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_F");
    check_field_offset(lv, v2, 4, "BFu0c_BFu9i_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_F, BFu0c_BFu9i_F)
//============================================================================


struct  BFu0c_BFu9i_I  {
  unsigned char  :0;
  unsigned int v1:9;
  int v2;
};
//SIG(1 BFu0c_BFu9i_I) C1{ Fc:0 Fi:9 Fi}



static void Test_BFu0c_BFu9i_I()
{
  {
    init_simple_test("BFu0c_BFu9i_I");
    static STRUCT_IF_C BFu0c_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_I");
    check_field_offset(lv, v2, 4, "BFu0c_BFu9i_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_I, BFu0c_BFu9i_I)
//============================================================================


struct  BFu0c_BFu9i_Ip  {
  unsigned char  :0;
  unsigned int v1:9;
  int *v2;
};
//SIG(1 BFu0c_BFu9i_Ip) C1{ Fc:0 Fi:9 Fp}



static void Test_BFu0c_BFu9i_Ip()
{
  {
    init_simple_test("BFu0c_BFu9i_Ip");
    static STRUCT_IF_C BFu0c_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu9i_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Ip, BFu0c_BFu9i_Ip)
//============================================================================


struct  BFu0c_BFu9i_L  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsi64 v2;
};
//SIG(1 BFu0c_BFu9i_L) C1{ Fc:0 Fi:9 FL}



static void Test_BFu0c_BFu9i_L()
{
  {
    init_simple_test("BFu0c_BFu9i_L");
    static STRUCT_IF_C BFu0c_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu9i_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_L, BFu0c_BFu9i_L)
//============================================================================


struct  BFu0c_BFu9i_S  {
  unsigned char  :0;
  unsigned int v1:9;
  short v2;
};
//SIG(1 BFu0c_BFu9i_S) C1{ Fc:0 Fi:9 Fs}



static void Test_BFu0c_BFu9i_S()
{
  {
    init_simple_test("BFu0c_BFu9i_S");
    static STRUCT_IF_C BFu0c_BFu9i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_S");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_S, BFu0c_BFu9i_S)
//============================================================================


struct  BFu0c_BFu9i_Uc  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned char v2;
};
//SIG(1 BFu0c_BFu9i_Uc) C1{ Fc:0 Fi:9 Fc}



static void Test_BFu0c_BFu9i_Uc()
{
  {
    init_simple_test("BFu0c_BFu9i_Uc");
    static STRUCT_IF_C BFu0c_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Uc");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Uc, BFu0c_BFu9i_Uc)
//============================================================================


struct  BFu0c_BFu9i_Ui  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned int v2;
};
//SIG(1 BFu0c_BFu9i_Ui) C1{ Fc:0 Fi:9 Fi}



static void Test_BFu0c_BFu9i_Ui()
{
  {
    init_simple_test("BFu0c_BFu9i_Ui");
    static STRUCT_IF_C BFu0c_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Ui");
    check_field_offset(lv, v2, 4, "BFu0c_BFu9i_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Ui, BFu0c_BFu9i_Ui)
//============================================================================


struct  BFu0c_BFu9i_Ul  {
  unsigned char  :0;
  unsigned int v1:9;
  __tsu64 v2;
};
//SIG(1 BFu0c_BFu9i_Ul) C1{ Fc:0 Fi:9 FL}



static void Test_BFu0c_BFu9i_Ul()
{
  {
    init_simple_test("BFu0c_BFu9i_Ul");
    static STRUCT_IF_C BFu0c_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0c_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu9i_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Ul, BFu0c_BFu9i_Ul)
//============================================================================


struct  BFu0c_BFu9i_Us  {
  unsigned char  :0;
  unsigned int v1:9;
  unsigned short v2;
};
//SIG(1 BFu0c_BFu9i_Us) C1{ Fc:0 Fi:9 Fs}



static void Test_BFu0c_BFu9i_Us()
{
  {
    init_simple_test("BFu0c_BFu9i_Us");
    static STRUCT_IF_C BFu0c_BFu9i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0c_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0c_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Us");
    check_field_offset(lv, v2, 2, "BFu0c_BFu9i_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Us, BFu0c_BFu9i_Us)
//============================================================================


struct  BFu0c_BFu9i_Vp  {
  unsigned char  :0;
  unsigned int v1:9;
  void *v2;
};
//SIG(1 BFu0c_BFu9i_Vp) C1{ Fc:0 Fi:9 Fp}



static void Test_BFu0c_BFu9i_Vp()
{
  {
    init_simple_test("BFu0c_BFu9i_Vp");
    static STRUCT_IF_C BFu0c_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0c_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0c_BFu9i_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9i_Vp, BFu0c_BFu9i_Vp)
//============================================================================


struct  BFu0c_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:9;
};
//SIG(1 BFu0c_BFu9ll) C1{ Fc:0 FL:9}



static void Test_BFu0c_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll, BFu0c_BFu9ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu0c  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned char  :0;
};
//SIG(1 BFu0c_BFu9ll_BFu0c) C1{ Fc:0 FL:9 Fc:0}



static void Test_BFu0c_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0c");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu0c, BFu0c_BFu9ll_BFu0c)
//============================================================================


struct  BFu0c_BFu9ll_BFu0i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int  :0;
};
//SIG(1 BFu0c_BFu9ll_BFu0i) C1{ Fc:0 FL:9 Fi:0}



static void Test_BFu0c_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu0i, BFu0c_BFu9ll_BFu0i)
//============================================================================


struct  BFu0c_BFu9ll_BFu0ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64  :0;
};
//SIG(1 BFu0c_BFu9ll_BFu0ll) C1{ Fc:0 FL:9 FL:0}



static void Test_BFu0c_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu0ll, BFu0c_BFu9ll_BFu0ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu0s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short  :0;
};
//SIG(1 BFu0c_BFu9ll_BFu0s) C1{ Fc:0 FL:9 Fs:0}



static void Test_BFu0c_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu0s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu0s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu0s, BFu0c_BFu9ll_BFu0s)
//============================================================================


struct  BFu0c_BFu9ll_BFu15i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:15;
};
//SIG(1 BFu0c_BFu9ll_BFu15i) C1{ Fc:0 FL:9 Fi:15}



static void Test_BFu0c_BFu9ll_BFu15i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu15i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu15i, BFu0c_BFu9ll_BFu15i)
//============================================================================


struct  BFu0c_BFu9ll_BFu15ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:15;
};
//SIG(1 BFu0c_BFu9ll_BFu15ll) C1{ Fc:0 FL:9 FL:15}



static void Test_BFu0c_BFu9ll_BFu15ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu15ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0c_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0c_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu15ll, BFu0c_BFu9ll_BFu15ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu15s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short v2:15;
};
//SIG(1 BFu0c_BFu9ll_BFu15s) C1{ Fc:0 FL:9 Fs:15}



static void Test_BFu0c_BFu9ll_BFu15s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu15s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0c_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0c_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu15s, BFu0c_BFu9ll_BFu15s)
//============================================================================


struct  BFu0c_BFu9ll_BFu16i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:16;
};
//SIG(1 BFu0c_BFu9ll_BFu16i) C1{ Fc:0 FL:9 Fi:16}



static void Test_BFu0c_BFu9ll_BFu16i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu16i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu16i, BFu0c_BFu9ll_BFu16i)
//============================================================================


struct  BFu0c_BFu9ll_BFu16ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:16;
};
//SIG(1 BFu0c_BFu9ll_BFu16ll) C1{ Fc:0 FL:9 FL:16}



static void Test_BFu0c_BFu9ll_BFu16ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu16ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0c_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0c_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu16ll, BFu0c_BFu9ll_BFu16ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu16s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short v2:16;
};
//SIG(1 BFu0c_BFu9ll_BFu16s) C1{ Fc:0 FL:9 Fs:16}



static void Test_BFu0c_BFu9ll_BFu16s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu16s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0c_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0c_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu16s, BFu0c_BFu9ll_BFu16s)
//============================================================================


struct  BFu0c_BFu9ll_BFu17i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:17;
};
//SIG(1 BFu0c_BFu9ll_BFu17i) C1{ Fc:0 FL:9 Fi:17}



static void Test_BFu0c_BFu9ll_BFu17i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu17i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu17i, BFu0c_BFu9ll_BFu17i)
//============================================================================


struct  BFu0c_BFu9ll_BFu17ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:17;
};
//SIG(1 BFu0c_BFu9ll_BFu17ll) C1{ Fc:0 FL:9 FL:17}



static void Test_BFu0c_BFu9ll_BFu17ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu17ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0c_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0c_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu17ll, BFu0c_BFu9ll_BFu17ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu1c  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned char v2:1;
};
//SIG(1 BFu0c_BFu9ll_BFu1c) C1{ Fc:0 FL:9 Fc:1}



static void Test_BFu0c_BFu9ll_BFu1c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1c");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu1c, BFu0c_BFu9ll_BFu1c)
//============================================================================


struct  BFu0c_BFu9ll_BFu1i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:1;
};
//SIG(1 BFu0c_BFu9ll_BFu1i) C1{ Fc:0 FL:9 Fi:1}



static void Test_BFu0c_BFu9ll_BFu1i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu1i, BFu0c_BFu9ll_BFu1i)
//============================================================================


struct  BFu0c_BFu9ll_BFu1ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:1;
};
//SIG(1 BFu0c_BFu9ll_BFu1ll) C1{ Fc:0 FL:9 FL:1}



static void Test_BFu0c_BFu9ll_BFu1ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu1ll, BFu0c_BFu9ll_BFu1ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu1s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short v2:1;
};
//SIG(1 BFu0c_BFu9ll_BFu1s) C1{ Fc:0 FL:9 Fs:1}



static void Test_BFu0c_BFu9ll_BFu1s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu1s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0c_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu1s, BFu0c_BFu9ll_BFu1s)
//============================================================================


struct  BFu0c_BFu9ll_BFu31i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:31;
};
//SIG(1 BFu0c_BFu9ll_BFu31i) C1{ Fc:0 FL:9 Fi:31}



static void Test_BFu0c_BFu9ll_BFu31i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu31i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0c_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0c_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu31i, BFu0c_BFu9ll_BFu31i)
//============================================================================


struct  BFu0c_BFu9ll_BFu31ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:31;
};
//SIG(1 BFu0c_BFu9ll_BFu31ll) C1{ Fc:0 FL:9 FL:31}



static void Test_BFu0c_BFu9ll_BFu31ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu31ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0c_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0c_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu31ll, BFu0c_BFu9ll_BFu31ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu32i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:32;
};
//SIG(1 BFu0c_BFu9ll_BFu32i) C1{ Fc:0 FL:9 Fi:32}



static void Test_BFu0c_BFu9ll_BFu32i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu32i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0c_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0c_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu32i, BFu0c_BFu9ll_BFu32i)
//============================================================================


struct  BFu0c_BFu9ll_BFu32ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:32;
};
//SIG(1 BFu0c_BFu9ll_BFu32ll) C1{ Fc:0 FL:9 FL:32}



static void Test_BFu0c_BFu9ll_BFu32ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu32ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0c_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0c_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu32ll, BFu0c_BFu9ll_BFu32ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu33  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:33;
};
//SIG(1 BFu0c_BFu9ll_BFu33) C1{ Fc:0 FL:9 FL:33}



static void Test_BFu0c_BFu9ll_BFu33()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu33");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0c_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0c_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0c_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu33, BFu0c_BFu9ll_BFu33)
//============================================================================


struct  BFu0c_BFu9ll_BFu7c  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned char v2:7;
};
//SIG(1 BFu0c_BFu9ll_BFu7c) C1{ Fc:0 FL:9 Fc:7}



static void Test_BFu0c_BFu9ll_BFu7c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7c");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu7c, BFu0c_BFu9ll_BFu7c)
//============================================================================


struct  BFu0c_BFu9ll_BFu7i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:7;
};
//SIG(1 BFu0c_BFu9ll_BFu7i) C1{ Fc:0 FL:9 Fi:7}



static void Test_BFu0c_BFu9ll_BFu7i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu7i, BFu0c_BFu9ll_BFu7i)
//============================================================================


struct  BFu0c_BFu9ll_BFu7ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:7;
};
//SIG(1 BFu0c_BFu9ll_BFu7ll) C1{ Fc:0 FL:9 FL:7}



static void Test_BFu0c_BFu9ll_BFu7ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu7ll, BFu0c_BFu9ll_BFu7ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu7s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short v2:7;
};
//SIG(1 BFu0c_BFu9ll_BFu7s) C1{ Fc:0 FL:9 Fs:7}



static void Test_BFu0c_BFu9ll_BFu7s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu7s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0c_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0c_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu7s, BFu0c_BFu9ll_BFu7s)
//============================================================================


struct  BFu0c_BFu9ll_BFu8c  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned char v2:8;
};
//SIG(1 BFu0c_BFu9ll_BFu8c) C1{ Fc:0 FL:9 Fc:8}



static void Test_BFu0c_BFu9ll_BFu8c()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8c");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu8c, BFu0c_BFu9ll_BFu8c)
//============================================================================


struct  BFu0c_BFu9ll_BFu8i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:8;
};
//SIG(1 BFu0c_BFu9ll_BFu8i) C1{ Fc:0 FL:9 Fi:8}



static void Test_BFu0c_BFu9ll_BFu8i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu8i, BFu0c_BFu9ll_BFu8i)
//============================================================================


struct  BFu0c_BFu9ll_BFu8ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:8;
};
//SIG(1 BFu0c_BFu9ll_BFu8ll) C1{ Fc:0 FL:9 FL:8}



static void Test_BFu0c_BFu9ll_BFu8ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0c_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu8ll, BFu0c_BFu9ll_BFu8ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu8s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short v2:8;
};
//SIG(1 BFu0c_BFu9ll_BFu8s) C1{ Fc:0 FL:9 Fs:8}



static void Test_BFu0c_BFu9ll_BFu8s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu8s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0c_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0c_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu8s, BFu0c_BFu9ll_BFu8s)
//============================================================================


struct  BFu0c_BFu9ll_BFu9i  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned int v2:9;
};
//SIG(1 BFu0c_BFu9ll_BFu9i) C1{ Fc:0 FL:9 Fi:9}



static void Test_BFu0c_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu9i");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu9i, BFu0c_BFu9ll_BFu9i)
//============================================================================


struct  BFu0c_BFu9ll_BFu9ll  {
  unsigned char  :0;
  __tsu64 v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFu0c_BFu9ll_BFu9ll) C1{ Fc:0 FL:9 FL:9}



static void Test_BFu0c_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu9ll");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0c_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu9ll, BFu0c_BFu9ll_BFu9ll)
//============================================================================


struct  BFu0c_BFu9ll_BFu9s  {
  unsigned char  :0;
  __tsu64 v1:9;
  unsigned short v2:9;
};
//SIG(1 BFu0c_BFu9ll_BFu9s) C1{ Fc:0 FL:9 Fs:9}



static void Test_BFu0c_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFu0c_BFu9ll_BFu9s");
    static STRUCT_IF_C BFu0c_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0c_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0c_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0c_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0c_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0c_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFu0c_BFu9ll_BFu9s, BFu0c_BFu9ll_BFu9s)
//============================================================================


struct  BF