// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFs0c_BFs0c  {
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c) C1{ Fc:0 Fc:0}



static void Test_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c, BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0c  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c) C1{ Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c, BFs0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFs0c  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFs0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFs0c, BFs0c_BFs0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFs0i  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFs0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFs0i, BFs0c_BFs0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFs0ll  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFs0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFs0ll, BFs0c_BFs0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFs0s  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFs0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFs0s, BFs0c_BFs0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFu0c  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFu0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFu0c, BFs0c_BFs0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFu0i  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFu0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFu0i, BFs0c_BFs0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFu0ll  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFu0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFu0ll, BFs0c_BFs0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0c_BFu0s  {
  signed char  :0;
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0c_BFu0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0c_BFu0s, BFs0c_BFs0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0i  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i) C1{ Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i, BFs0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFs0c  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFs0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFs0c, BFs0c_BFs0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFs0i  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFs0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFs0i, BFs0c_BFs0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFs0ll  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFs0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFs0ll, BFs0c_BFs0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFs0s  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFs0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFs0s, BFs0c_BFs0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFu0c  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFu0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFu0c, BFs0c_BFs0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFu0i  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFu0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFu0i, BFs0c_BFs0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFu0ll  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFu0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFu0ll, BFs0c_BFs0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0i_BFu0s  {
  signed char  :0;
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0i_BFu0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0i_BFu0s, BFs0c_BFs0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll) C1{ Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll, BFs0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFs0c  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFs0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFs0c, BFs0c_BFs0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFs0i  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFs0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFs0i, BFs0c_BFs0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFs0ll  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFs0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFs0ll, BFs0c_BFs0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFs0s  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFs0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFs0s, BFs0c_BFs0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFu0c  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFu0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFu0c, BFs0c_BFs0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFu0i  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFu0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFu0i, BFs0c_BFs0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFu0ll  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFu0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFu0ll, BFs0c_BFs0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0ll_BFu0s  {
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0ll_BFu0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0ll_BFu0s, BFs0c_BFs0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0s  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s) C1{ Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s, BFs0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFs0c  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFs0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFs0c, BFs0c_BFs0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFs0i  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFs0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFs0i, BFs0c_BFs0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFs0ll  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFs0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFs0ll, BFs0c_BFs0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFs0s  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFs0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFs0s, BFs0c_BFs0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFu0c  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFu0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFu0c, BFs0c_BFs0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFu0i  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFu0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFu0i, BFs0c_BFs0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFu0ll  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFu0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFu0ll, BFs0c_BFs0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFs0s_BFu0s  {
  signed char  :0;
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFs0s_BFu0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFs0s_BFu0s, BFs0c_BFs0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0c  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c) C1{ Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c, BFs0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFs0c  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFs0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFs0c, BFs0c_BFs0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFs0i  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFs0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFs0i, BFs0c_BFs0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFs0ll  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFs0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFs0ll, BFs0c_BFs0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFs0s  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFs0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFs0s, BFs0c_BFs0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFu0c  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFu0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFs0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFu0c, BFs0c_BFs0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFu0i  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFu0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFu0i, BFs0c_BFs0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFu0ll  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFu0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFu0ll, BFs0c_BFs0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0c_BFu0s  {
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0c_BFu0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0c_BFu0s, BFs0c_BFs0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0i  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i) C1{ Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i, BFs0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFs0c  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFs0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFs0c, BFs0c_BFs0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFs0i  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFs0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFs0i, BFs0c_BFs0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFs0ll  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFs0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFs0ll, BFs0c_BFs0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFs0s  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFs0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFs0s, BFs0c_BFs0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFu0c  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFu0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFu0c, BFs0c_BFs0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFu0i  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFu0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFu0i, BFs0c_BFs0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFu0ll  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFu0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFu0ll, BFs0c_BFs0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0i_BFu0s  {
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0i_BFu0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0i_BFu0s, BFs0c_BFs0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll) C1{ Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll, BFs0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFs0c  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFs0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFs0c, BFs0c_BFs0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFs0i  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFs0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFs0i, BFs0c_BFs0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFs0ll  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFs0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFs0ll, BFs0c_BFs0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFs0s  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFs0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFs0s, BFs0c_BFs0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFu0c  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFu0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFu0c, BFs0c_BFs0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFu0i  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFu0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFu0i, BFs0c_BFs0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFu0ll  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFu0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFu0ll, BFs0c_BFs0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0ll_BFu0s  {
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0ll_BFu0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0ll_BFu0s, BFs0c_BFs0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0s  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s) C1{ Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s, BFs0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFs0c  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFs0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFs0c, BFs0c_BFs0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFs0i  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFs0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFs0i, BFs0c_BFs0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFs0ll  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFs0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFs0ll, BFs0c_BFs0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFs0s  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFs0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFs0s, BFs0c_BFs0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFu0c  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFu0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFu0c, BFs0c_BFs0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFu0i  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFu0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFu0i, BFs0c_BFs0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFu0ll  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFu0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFu0ll, BFs0c_BFs0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0c_BFu0s_BFu0s  {
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0c_BFu0s_BFu0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0c_BFu0s_BFu0s, BFs0c_BFs0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0i  {
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i) C1{ Fc:0 Fi:0}



static void Test_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i, BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0c  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c) C1{ Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c, BFs0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFs0c  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFs0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFs0c, BFs0c_BFs0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFs0i  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFs0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFs0i, BFs0c_BFs0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFs0ll  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFs0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFs0ll, BFs0c_BFs0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFs0s  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFs0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFs0s, BFs0c_BFs0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFu0c  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFu0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFu0c, BFs0c_BFs0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFu0i  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFu0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFu0i, BFs0c_BFs0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFu0ll  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFu0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFu0ll, BFs0c_BFs0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0c_BFu0s  {
  signed char  :0;
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0c_BFu0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0c_BFu0s, BFs0c_BFs0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0i  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i) C1{ Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i, BFs0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFs0c  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFs0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFs0c, BFs0c_BFs0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFs0i  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFs0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFs0i, BFs0c_BFs0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFs0ll  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFs0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFs0ll, BFs0c_BFs0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFs0s  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFs0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFs0s, BFs0c_BFs0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFu0c  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFu0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFu0c, BFs0c_BFs0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFu0i  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFu0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFu0i, BFs0c_BFs0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFu0ll  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFu0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFu0ll, BFs0c_BFs0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0i_BFu0s  {
  signed char  :0;
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0i_BFu0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0i_BFu0s, BFs0c_BFs0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll) C1{ Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll, BFs0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFs0c  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFs0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFs0c, BFs0c_BFs0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFs0i  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFs0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFs0i, BFs0c_BFs0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFs0ll  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFs0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFs0ll, BFs0c_BFs0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFs0s  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFs0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFs0s, BFs0c_BFs0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFu0c  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFu0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFu0c, BFs0c_BFs0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFu0i  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFu0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFu0i, BFs0c_BFs0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFu0ll  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFu0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFu0ll, BFs0c_BFs0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0ll_BFu0s  {
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0ll_BFu0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0ll_BFu0s, BFs0c_BFs0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0s  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s) C1{ Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s, BFs0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFs0c  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFs0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFs0c, BFs0c_BFs0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFs0i  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFs0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFs0i, BFs0c_BFs0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFs0ll  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFs0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFs0ll, BFs0c_BFs0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFs0s  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFs0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFs0s, BFs0c_BFs0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFu0c  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFu0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFu0c, BFs0c_BFs0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFu0i  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFu0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFu0i, BFs0c_BFs0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFu0ll  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFu0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFu0ll, BFs0c_BFs0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFs0s_BFu0s  {
  signed char  :0;
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFs0s_BFu0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFs0s_BFu0s, BFs0c_BFs0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0c  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c) C1{ Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c, BFs0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFs0c  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFs0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFs0c, BFs0c_BFs0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFs0i  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFs0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFs0i, BFs0c_BFs0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFs0ll  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFs0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFs0ll, BFs0c_BFs0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFs0s  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFs0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFs0s, BFs0c_BFs0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFu0c  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFu0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFu0c, BFs0c_BFs0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFu0i  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFu0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFu0i, BFs0c_BFs0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFu0ll  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFu0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFu0ll, BFs0c_BFs0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0c_BFu0s  {
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0c_BFu0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0c_BFu0s, BFs0c_BFs0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0i  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i) C1{ Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i, BFs0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFs0c  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFs0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFs0c, BFs0c_BFs0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFs0i  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFs0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFs0i, BFs0c_BFs0i_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFs0ll  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFs0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFs0ll, BFs0c_BFs0i_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFs0s  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFs0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFs0s, BFs0c_BFs0i_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFu0c  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFu0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFu0c, BFs0c_BFs0i_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFu0i  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFu0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFu0i, BFs0c_BFs0i_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFu0ll  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFu0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFu0ll, BFs0c_BFs0i_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0i_BFu0s  {
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0i_BFu0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0i_BFu0s, BFs0c_BFs0i_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll) C1{ Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll, BFs0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFs0c  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFs0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFs0c, BFs0c_BFs0i_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFs0i  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFs0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFs0i, BFs0c_BFs0i_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFs0ll  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFs0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFs0ll, BFs0c_BFs0i_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFs0s  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFs0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFs0s, BFs0c_BFs0i_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFu0c  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFu0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFu0c, BFs0c_BFs0i_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFu0i  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFu0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFu0i, BFs0c_BFs0i_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFu0ll  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFu0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFu0ll, BFs0c_BFs0i_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0ll_BFu0s  {
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0ll_BFu0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0ll_BFu0s, BFs0c_BFs0i_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0s  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s) C1{ Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s, BFs0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFs0c  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFs0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFs0c, BFs0c_BFs0i_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFs0i  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFs0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFs0i, BFs0c_BFs0i_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFs0ll  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFs0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFs0ll, BFs0c_BFs0i_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFs0s  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFs0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFs0s, BFs0c_BFs0i_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFu0c  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFu0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFu0c, BFs0c_BFs0i_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFu0i  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFu0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFu0i, BFs0c_BFs0i_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFu0ll  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFu0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFu0ll, BFs0c_BFs0i_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0i_BFu0s_BFu0s  {
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0i_BFu0s_BFu0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0i_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0i_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0i_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0i_BFu0s_BFu0s, BFs0c_BFs0i_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll) C1{ Fc:0 FL:0}



static void Test_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll, BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c) C1{ Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c, BFs0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFs0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFs0c, BFs0c_BFs0ll_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFs0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFs0i, BFs0c_BFs0ll_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFs0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFs0ll, BFs0c_BFs0ll_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFs0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFs0s, BFs0c_BFs0ll_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFu0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFu0c, BFs0c_BFs0ll_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFu0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFu0i, BFs0c_BFs0ll_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFu0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFu0ll, BFs0c_BFs0ll_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0c_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0c_BFu0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0c_BFu0s, BFs0c_BFs0ll_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i) C1{ Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i, BFs0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFs0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFs0c, BFs0c_BFs0ll_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFs0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFs0i, BFs0c_BFs0ll_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFs0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFs0ll, BFs0c_BFs0ll_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFs0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFs0s, BFs0c_BFs0ll_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFu0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFu0c, BFs0c_BFs0ll_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFu0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFu0i, BFs0c_BFs0ll_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFu0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFu0ll, BFs0c_BFs0ll_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0i_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0i_BFu0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0i_BFu0s, BFs0c_BFs0ll_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll) C1{ Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll, BFs0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFs0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFs0c, BFs0c_BFs0ll_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFs0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFs0i, BFs0c_BFs0ll_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFs0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFs0ll, BFs0c_BFs0ll_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFs0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFs0s, BFs0c_BFs0ll_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFu0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFu0c, BFs0c_BFs0ll_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFu0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFu0i, BFs0c_BFs0ll_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFu0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFu0ll, BFs0c_BFs0ll_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0ll_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0ll_BFu0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0ll_BFu0s, BFs0c_BFs0ll_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s) C1{ Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s, BFs0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFs0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFs0c, BFs0c_BFs0ll_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFs0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFs0i, BFs0c_BFs0ll_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFs0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFs0ll, BFs0c_BFs0ll_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFs0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFs0s, BFs0c_BFs0ll_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFu0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFu0c, BFs0c_BFs0ll_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFu0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFu0i, BFs0c_BFs0ll_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFu0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFu0ll, BFs0c_BFs0ll_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFs0s_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFs0s_BFu0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFs0s_BFu0s, BFs0c_BFs0ll_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c) C1{ Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c, BFs0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFs0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFs0c, BFs0c_BFs0ll_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFs0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFs0i, BFs0c_BFs0ll_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFs0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFs0ll, BFs0c_BFs0ll_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFs0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFs0s, BFs0c_BFs0ll_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFu0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFu0c, BFs0c_BFs0ll_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFu0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFu0i, BFs0c_BFs0ll_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFu0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFu0ll, BFs0c_BFs0ll_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0c_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0c_BFu0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0c_BFu0s, BFs0c_BFs0ll_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i) C1{ Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i, BFs0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFs0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFs0c, BFs0c_BFs0ll_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFs0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFs0i, BFs0c_BFs0ll_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFs0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFs0ll, BFs0c_BFs0ll_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFs0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFs0s, BFs0c_BFs0ll_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFu0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFu0c, BFs0c_BFs0ll_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFu0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFu0i, BFs0c_BFs0ll_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFu0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFu0ll, BFs0c_BFs0ll_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0i_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0i_BFu0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0i_BFu0s, BFs0c_BFs0ll_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll) C1{ Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll, BFs0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFs0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFs0c, BFs0c_BFs0ll_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFs0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFs0i, BFs0c_BFs0ll_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFs0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFs0ll, BFs0c_BFs0ll_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFs0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFs0s, BFs0c_BFs0ll_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFu0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFu0c, BFs0c_BFs0ll_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFu0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFu0i, BFs0c_BFs0ll_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFu0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFu0ll, BFs0c_BFs0ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0ll_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0ll_BFu0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0ll_BFu0s, BFs0c_BFs0ll_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s) C1{ Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s, BFs0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFs0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFs0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFs0c, BFs0c_BFs0ll_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFs0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFs0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFs0i, BFs0c_BFs0ll_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFs0ll  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFs0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFs0ll, BFs0c_BFs0ll_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFs0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFs0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFs0s, BFs0c_BFs0ll_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFu0c  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFu0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFu0c, BFs0c_BFs0ll_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFu0i  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFu0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFu0i, BFs0c_BFs0ll_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFu0ll  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFu0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFu0ll, BFs0c_BFs0ll_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0ll_BFu0s_BFu0s  {
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0ll_BFu0s_BFu0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0ll_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0ll_BFu0s_BFu0s, BFs0c_BFs0ll_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0s  {
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s) C1{ Fc:0 Fs:0}



static void Test_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s, BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0c  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c) C1{ Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c, BFs0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFs0c  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFs0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFs0c, BFs0c_BFs0s_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFs0i  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFs0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFs0i, BFs0c_BFs0s_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFs0ll  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFs0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFs0ll, BFs0c_BFs0s_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFs0s  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFs0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFs0s, BFs0c_BFs0s_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFu0c  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFu0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFu0c, BFs0c_BFs0s_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFu0i  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFu0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFu0i, BFs0c_BFs0s_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFu0ll  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFu0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFu0ll, BFs0c_BFs0s_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0c_BFu0s  {
  signed char  :0;
  signed short  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0c_BFu0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0c_BFu0s, BFs0c_BFs0s_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0i  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i) C1{ Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i, BFs0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFs0c  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFs0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFs0c, BFs0c_BFs0s_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFs0i  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFs0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFs0i, BFs0c_BFs0s_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFs0ll  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFs0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFs0ll, BFs0c_BFs0s_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFs0s  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFs0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFs0s, BFs0c_BFs0s_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFu0c  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFu0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFu0c, BFs0c_BFs0s_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFu0i  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFu0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFu0i, BFs0c_BFs0s_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFu0ll  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFu0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFu0ll, BFs0c_BFs0s_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0i_BFu0s  {
  signed char  :0;
  signed short  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0i_BFu0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0i_BFu0s, BFs0c_BFs0s_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll) C1{ Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll, BFs0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFs0c  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFs0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFs0c, BFs0c_BFs0s_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFs0i  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFs0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFs0i, BFs0c_BFs0s_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFs0ll  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFs0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFs0ll, BFs0c_BFs0s_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFs0s  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFs0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFs0s, BFs0c_BFs0s_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFu0c  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFu0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFu0c, BFs0c_BFs0s_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFu0i  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFu0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFu0i, BFs0c_BFs0s_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFu0ll  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFu0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFu0ll, BFs0c_BFs0s_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0ll_BFu0s  {
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0ll_BFu0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0ll_BFu0s, BFs0c_BFs0s_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0s  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s, BFs0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFs0c  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFs0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFs0c, BFs0c_BFs0s_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFs0i  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFs0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFs0i, BFs0c_BFs0s_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFs0ll  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFs0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFs0ll, BFs0c_BFs0s_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFs0s  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFs0s, BFs0c_BFs0s_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFu0c  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFu0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0s_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFu0c, BFs0c_BFs0s_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFu0i  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFu0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0s_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFu0i, BFs0c_BFs0s_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFu0ll  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFu0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0s_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFu0ll, BFs0c_BFs0s_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFs0s_BFu0s  {
  signed char  :0;
  signed short  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFs0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0s_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFs0s_BFu0s, BFs0c_BFs0s_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0c  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c) C1{ Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c, BFs0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFs0c  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFs0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFs0c, BFs0c_BFs0s_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFs0i  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFs0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFs0i, BFs0c_BFs0s_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFs0ll  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFs0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFs0ll, BFs0c_BFs0s_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFs0s  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFs0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFs0s, BFs0c_BFs0s_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFu0c  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFu0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFu0c, BFs0c_BFs0s_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFu0i  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFu0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFu0i, BFs0c_BFs0s_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFu0ll  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFu0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFu0ll, BFs0c_BFs0s_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0c_BFu0s  {
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0c_BFu0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0c_BFu0s, BFs0c_BFs0s_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0i  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i) C1{ Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i, BFs0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFs0c  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFs0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFs0c, BFs0c_BFs0s_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFs0i  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFs0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFs0i, BFs0c_BFs0s_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFs0ll  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFs0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFs0ll, BFs0c_BFs0s_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFs0s  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFs0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFs0s, BFs0c_BFs0s_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFu0c  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFu0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFu0c, BFs0c_BFs0s_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFu0i  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFu0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFu0i, BFs0c_BFs0s_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFu0ll  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFu0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFu0ll, BFs0c_BFs0s_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0i_BFu0s  {
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0i_BFu0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0i_BFu0s, BFs0c_BFs0s_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll) C1{ Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll, BFs0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFs0c  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFs0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFs0c, BFs0c_BFs0s_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFs0i  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFs0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFs0i, BFs0c_BFs0s_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFs0ll  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFs0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFs0ll, BFs0c_BFs0s_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFs0s  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFs0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFs0s, BFs0c_BFs0s_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFu0c  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFu0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFu0c, BFs0c_BFs0s_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFu0i  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFu0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFu0i, BFs0c_BFs0s_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFu0ll  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFu0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFu0ll, BFs0c_BFs0s_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0ll_BFu0s  {
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0ll_BFu0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0ll_BFu0s, BFs0c_BFs0s_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0s  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s, BFs0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFs0c  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFs0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFs0c, BFs0c_BFs0s_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFs0i  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFs0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFs0i, BFs0c_BFs0s_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFs0ll  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFs0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFs0ll, BFs0c_BFs0s_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFs0s  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFs0s, BFs0c_BFs0s_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFu0c  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFu0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFs0s_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFu0c, BFs0c_BFs0s_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFu0i  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFu0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFs0s_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFu0i, BFs0c_BFs0s_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFu0ll  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFu0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFs0s_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFu0ll, BFs0c_BFs0s_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFs0s_BFu0s_BFu0s  {
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFs0s_BFu0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFs0s_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFs0s_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFs0s_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFs0s_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFs0s_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFs0s_BFu0s_BFu0s, BFs0c_BFs0s_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0c  {
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c) C1{ Fc:0 Fc:0}



static void Test_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c, BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c) C1{ Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c, BFs0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFs0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFs0c, BFs0c_BFu0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFs0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFs0i, BFs0c_BFu0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFs0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFs0ll, BFs0c_BFu0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFs0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFs0s, BFs0c_BFu0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFu0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFu0c, BFs0c_BFu0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFu0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFu0i, BFs0c_BFu0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFu0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFu0ll, BFs0c_BFu0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0c_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0c_BFu0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0c_BFu0s, BFs0c_BFu0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i) C1{ Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i, BFs0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFs0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFs0c, BFs0c_BFu0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFs0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFs0i, BFs0c_BFu0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFs0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFs0ll, BFs0c_BFu0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFs0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFs0s, BFs0c_BFu0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFu0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFu0c, BFs0c_BFu0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFu0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFu0i, BFs0c_BFu0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFu0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFu0ll, BFs0c_BFu0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0i_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0i_BFu0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0i_BFu0s, BFs0c_BFu0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll) C1{ Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll, BFs0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFs0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFs0c, BFs0c_BFu0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFs0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFs0i, BFs0c_BFu0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFs0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFs0ll, BFs0c_BFu0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFs0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFs0s, BFs0c_BFu0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFu0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFu0c, BFs0c_BFu0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFu0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFu0i, BFs0c_BFu0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFu0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFu0ll, BFs0c_BFu0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0ll_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0ll_BFu0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0ll_BFu0s, BFs0c_BFu0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s) C1{ Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s, BFs0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFs0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFs0c, BFs0c_BFu0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFs0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFs0i, BFs0c_BFu0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFs0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFs0ll, BFs0c_BFu0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFs0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFs0s, BFs0c_BFu0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFu0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFu0c, BFs0c_BFu0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFu0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFu0i, BFs0c_BFu0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFu0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFu0ll, BFs0c_BFu0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFs0s_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFs0s_BFu0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFs0s_BFu0s, BFs0c_BFu0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c) C1{ Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c, BFs0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFs0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFs0c, BFs0c_BFu0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFs0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFs0i, BFs0c_BFu0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFs0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFs0ll, BFs0c_BFu0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFs0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFs0s, BFs0c_BFu0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFu0c) C1{ Fc:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs0c_BFu0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFu0c, BFs0c_BFu0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFu0i) C1{ Fc:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFu0i, BFs0c_BFu0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFu0ll) C1{ Fc:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFu0ll, BFs0c_BFu0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0c_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0c_BFu0s) C1{ Fc:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0c_BFu0s, BFs0c_BFu0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i) C1{ Fc:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i, BFs0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFs0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFs0c, BFs0c_BFu0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFs0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFs0i, BFs0c_BFu0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFs0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFs0ll, BFs0c_BFu0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFs0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFs0s, BFs0c_BFu0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFu0c) C1{ Fc:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFu0c, BFs0c_BFu0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFu0i) C1{ Fc:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFu0i, BFs0c_BFu0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFu0ll) C1{ Fc:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFu0ll, BFs0c_BFu0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0i_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0i_BFu0s) C1{ Fc:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0i_BFu0s, BFs0c_BFu0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll) C1{ Fc:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll, BFs0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFs0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFs0c, BFs0c_BFu0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFs0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFs0i, BFs0c_BFu0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFs0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFs0ll, BFs0c_BFu0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFs0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFs0s, BFs0c_BFu0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFu0c) C1{ Fc:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFu0c, BFs0c_BFu0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFu0i) C1{ Fc:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFu0i, BFs0c_BFu0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFu0ll) C1{ Fc:0 Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFu0ll, BFs0c_BFu0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0ll_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0ll_BFu0s) C1{ Fc:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0ll_BFu0s, BFs0c_BFu0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s) C1{ Fc:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s, BFs0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFs0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFs0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFs0c, BFs0c_BFu0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFs0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFs0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFs0i, BFs0c_BFu0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFs0ll  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFs0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFs0ll, BFs0c_BFu0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFs0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFs0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFs0s, BFs0c_BFu0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFu0c  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFu0c) C1{ Fc:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFu0c, BFs0c_BFu0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFu0i  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFu0i) C1{ Fc:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFu0i, BFs0c_BFu0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFu0ll  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFu0ll) C1{ Fc:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFu0ll, BFs0c_BFu0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0c_BFu0s_BFu0s  {
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0c_BFu0s_BFu0s) C1{ Fc:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0c_BFu0s_BFu0s, BFs0c_BFu0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0i  {
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i) C1{ Fc:0 Fi:0}



static void Test_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i, BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c) C1{ Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c, BFs0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFs0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFs0c, BFs0c_BFu0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFs0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFs0i, BFs0c_BFu0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFs0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFs0ll, BFs0c_BFu0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFs0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFs0s, BFs0c_BFu0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFu0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFu0c, BFs0c_BFu0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFu0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFu0i, BFs0c_BFu0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFu0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFu0ll, BFs0c_BFu0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0c_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0c_BFu0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0c_BFu0s, BFs0c_BFu0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i) C1{ Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i, BFs0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFs0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFs0c, BFs0c_BFu0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFs0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFs0i, BFs0c_BFu0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFs0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFs0ll, BFs0c_BFu0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFs0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFs0s, BFs0c_BFu0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFu0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFu0c, BFs0c_BFu0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFu0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFu0i, BFs0c_BFu0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFu0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFu0ll, BFs0c_BFu0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0i_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0i_BFu0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0i_BFu0s, BFs0c_BFu0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll) C1{ Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll, BFs0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFs0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFs0c, BFs0c_BFu0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFs0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFs0i, BFs0c_BFu0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFs0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFs0ll, BFs0c_BFu0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFs0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFs0s, BFs0c_BFu0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFu0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFu0c, BFs0c_BFu0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFu0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFu0i, BFs0c_BFu0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFu0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFu0ll, BFs0c_BFu0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0ll_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0ll_BFu0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0ll_BFu0s, BFs0c_BFu0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s) C1{ Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s, BFs0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFs0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFs0c, BFs0c_BFu0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFs0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFs0i, BFs0c_BFu0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFs0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFs0ll, BFs0c_BFu0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFs0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFs0s, BFs0c_BFu0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFu0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFu0c, BFs0c_BFu0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFu0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFu0i, BFs0c_BFu0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFu0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFu0ll, BFs0c_BFu0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFs0s_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFs0s_BFu0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFs0s_BFu0s, BFs0c_BFu0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c) C1{ Fc:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c, BFs0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFs0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFs0c, BFs0c_BFu0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFs0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFs0i, BFs0c_BFu0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFs0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFs0ll, BFs0c_BFu0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFs0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFs0s, BFs0c_BFu0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFu0c) C1{ Fc:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFu0c, BFs0c_BFu0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFu0i) C1{ Fc:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFu0i, BFs0c_BFu0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFu0ll) C1{ Fc:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFu0ll, BFs0c_BFu0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0c_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0c_BFu0s) C1{ Fc:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0c_BFu0s, BFs0c_BFu0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i) C1{ Fc:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i, BFs0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFs0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFs0c, BFs0c_BFu0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFs0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFs0i, BFs0c_BFu0i_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFs0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFs0ll, BFs0c_BFu0i_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFs0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFs0s, BFs0c_BFu0i_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFu0c) C1{ Fc:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFu0c, BFs0c_BFu0i_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFu0i) C1{ Fc:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFu0i, BFs0c_BFu0i_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFu0ll) C1{ Fc:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFu0ll, BFs0c_BFu0i_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0i_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0i_BFu0s) C1{ Fc:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0i_BFu0s, BFs0c_BFu0i_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll) C1{ Fc:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll, BFs0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFs0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFs0c, BFs0c_BFu0i_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFs0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFs0i, BFs0c_BFu0i_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFs0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFs0ll, BFs0c_BFu0i_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFs0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFs0s, BFs0c_BFu0i_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFu0c) C1{ Fc:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFu0c, BFs0c_BFu0i_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFu0i) C1{ Fc:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFu0i, BFs0c_BFu0i_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFu0ll) C1{ Fc:0 Fi:0 FL:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFu0ll, BFs0c_BFu0i_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0ll_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0ll_BFu0s) C1{ Fc:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0ll_BFu0s, BFs0c_BFu0i_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s) C1{ Fc:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s, BFs0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFs0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFs0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFs0c, BFs0c_BFu0i_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFs0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFs0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFs0i, BFs0c_BFu0i_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFs0ll  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFs0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFs0ll, BFs0c_BFu0i_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFs0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFs0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFs0s, BFs0c_BFu0i_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFu0c  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFu0c) C1{ Fc:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFu0c, BFs0c_BFu0i_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFu0i  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFu0i) C1{ Fc:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFu0i, BFs0c_BFu0i_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFu0ll  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFu0ll) C1{ Fc:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFu0ll, BFs0c_BFu0i_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0i_BFu0s_BFu0s  {
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0i_BFu0s_BFu0s) C1{ Fc:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0i_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0i_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0i_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0i_BFu0s_BFu0s, BFs0c_BFu0i_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll) C1{ Fc:0 FL:0}



static void Test_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll, BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c) C1{ Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c, BFs0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFs0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFs0c, BFs0c_BFu0ll_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFs0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFs0i, BFs0c_BFu0ll_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFs0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFs0ll, BFs0c_BFu0ll_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFs0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFs0s, BFs0c_BFu0ll_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFu0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFu0c, BFs0c_BFu0ll_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFu0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFu0i, BFs0c_BFu0ll_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFu0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFu0ll, BFs0c_BFu0ll_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0c_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0c_BFu0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0c_BFu0s, BFs0c_BFu0ll_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i) C1{ Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i, BFs0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFs0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFs0c, BFs0c_BFu0ll_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFs0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFs0i, BFs0c_BFu0ll_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFs0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFs0ll, BFs0c_BFu0ll_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFs0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFs0s, BFs0c_BFu0ll_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFu0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFu0c, BFs0c_BFu0ll_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFu0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFu0i, BFs0c_BFu0ll_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFu0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFu0ll, BFs0c_BFu0ll_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0i_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0i_BFu0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0i_BFu0s, BFs0c_BFu0ll_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll) C1{ Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll, BFs0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFs0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFs0c, BFs0c_BFu0ll_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFs0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFs0i, BFs0c_BFu0ll_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFs0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFs0ll, BFs0c_BFu0ll_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFs0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFs0s, BFs0c_BFu0ll_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFu0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFu0c, BFs0c_BFu0ll_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFu0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFu0i, BFs0c_BFu0ll_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFu0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFu0ll, BFs0c_BFu0ll_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0ll_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0ll_BFu0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0ll_BFu0s, BFs0c_BFu0ll_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s) C1{ Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s, BFs0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFs0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFs0c, BFs0c_BFu0ll_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFs0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFs0i, BFs0c_BFu0ll_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFs0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFs0ll, BFs0c_BFu0ll_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFs0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFs0s, BFs0c_BFu0ll_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFu0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFu0c, BFs0c_BFu0ll_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFu0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFu0i, BFs0c_BFu0ll_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFu0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFu0ll, BFs0c_BFu0ll_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFs0s_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFs0s_BFu0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFs0s_BFu0s, BFs0c_BFu0ll_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c) C1{ Fc:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c, BFs0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFs0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFs0c, BFs0c_BFu0ll_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFs0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFs0i, BFs0c_BFu0ll_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFs0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFs0ll, BFs0c_BFu0ll_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFs0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFs0s, BFs0c_BFu0ll_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFu0c) C1{ Fc:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFu0c, BFs0c_BFu0ll_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFu0i) C1{ Fc:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFu0i, BFs0c_BFu0ll_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFu0ll) C1{ Fc:0 FL:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFu0ll, BFs0c_BFu0ll_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0c_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0c_BFu0s) C1{ Fc:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0c_BFu0s, BFs0c_BFu0ll_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i) C1{ Fc:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i, BFs0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFs0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFs0c, BFs0c_BFu0ll_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFs0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFs0i, BFs0c_BFu0ll_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFs0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFs0ll, BFs0c_BFu0ll_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFs0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFs0s, BFs0c_BFu0ll_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFu0c) C1{ Fc:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFu0c, BFs0c_BFu0ll_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFu0i) C1{ Fc:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFu0i, BFs0c_BFu0ll_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFu0ll) C1{ Fc:0 FL:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFu0ll, BFs0c_BFu0ll_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0i_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0i_BFu0s) C1{ Fc:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0i_BFu0s, BFs0c_BFu0ll_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll) C1{ Fc:0 FL:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll, BFs0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFs0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFs0c, BFs0c_BFu0ll_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFs0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFs0i, BFs0c_BFu0ll_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFs0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFs0ll, BFs0c_BFu0ll_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFs0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFs0s, BFs0c_BFu0ll_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFu0c) C1{ Fc:0 FL:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFu0c, BFs0c_BFu0ll_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFu0i) C1{ Fc:0 FL:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFu0i, BFs0c_BFu0ll_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFu0ll) C1{ Fc:0 FL:0 FL:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFu0ll, BFs0c_BFu0ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0ll_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0ll_BFu0s) C1{ Fc:0 FL:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0ll_BFu0s, BFs0c_BFu0ll_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s) C1{ Fc:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s, BFs0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFs0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFs0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFs0c, BFs0c_BFu0ll_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFs0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFs0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFs0i, BFs0c_BFu0ll_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFs0ll  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFs0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFs0ll, BFs0c_BFu0ll_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFs0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFs0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFs0s, BFs0c_BFu0ll_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFu0c  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFu0c) C1{ Fc:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFu0c, BFs0c_BFu0ll_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFu0i  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFu0i) C1{ Fc:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFu0i, BFs0c_BFu0ll_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFu0ll  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFu0ll) C1{ Fc:0 FL:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFu0ll, BFs0c_BFu0ll_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0ll_BFu0s_BFu0s  {
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0ll_BFu0s_BFu0s) C1{ Fc:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0ll_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0ll_BFu0s_BFu0s, BFs0c_BFu0ll_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0s  {
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s) C1{ Fc:0 Fs:0}



static void Test_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s, BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c) C1{ Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c, BFs0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFs0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFs0c, BFs0c_BFu0s_BFs0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFs0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFs0i, BFs0c_BFu0s_BFs0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFs0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFs0ll, BFs0c_BFu0s_BFs0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFs0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFs0s, BFs0c_BFu0s_BFs0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFu0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFu0c, BFs0c_BFu0s_BFs0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFu0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFu0i, BFs0c_BFu0s_BFs0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFu0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFu0ll, BFs0c_BFu0s_BFs0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0c_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0c_BFu0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0c_BFu0s, BFs0c_BFu0s_BFs0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i) C1{ Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i, BFs0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFs0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFs0c, BFs0c_BFu0s_BFs0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFs0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFs0i, BFs0c_BFu0s_BFs0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFs0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFs0ll, BFs0c_BFu0s_BFs0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFs0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFs0s, BFs0c_BFu0s_BFs0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFu0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFu0c, BFs0c_BFu0s_BFs0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFu0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFu0i, BFs0c_BFu0s_BFs0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFu0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFu0ll, BFs0c_BFu0s_BFs0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0i_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0i_BFu0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0i_BFu0s, BFs0c_BFu0s_BFs0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll) C1{ Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll, BFs0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFs0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFs0c, BFs0c_BFu0s_BFs0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFs0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFs0i, BFs0c_BFu0s_BFs0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFs0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFs0ll, BFs0c_BFu0s_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFs0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFs0s, BFs0c_BFu0s_BFs0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFu0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFu0c, BFs0c_BFu0s_BFs0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFu0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFu0i, BFs0c_BFu0s_BFs0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFu0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFu0ll, BFs0c_BFu0s_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0ll_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0ll_BFu0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0ll_BFu0s, BFs0c_BFu0s_BFs0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s, BFs0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFs0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFs0c, BFs0c_BFu0s_BFs0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFs0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFs0i, BFs0c_BFu0s_BFs0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFs0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFs0ll, BFs0c_BFu0s_BFs0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFs0s, BFs0c_BFu0s_BFs0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFu0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0s_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFu0c, BFs0c_BFu0s_BFs0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFu0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0s_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFu0i, BFs0c_BFu0s_BFs0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFu0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0s_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFu0ll, BFs0c_BFu0s_BFs0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFs0s_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFs0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0s_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFs0s_BFu0s, BFs0c_BFu0s_BFs0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c) C1{ Fc:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c, BFs0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFs0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFs0c, BFs0c_BFu0s_BFu0c_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFs0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFs0i, BFs0c_BFu0s_BFu0c_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFs0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFs0ll, BFs0c_BFu0s_BFu0c_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFs0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFs0s, BFs0c_BFu0s_BFu0c_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFu0c) C1{ Fc:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFu0c, BFs0c_BFu0s_BFu0c_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFu0i) C1{ Fc:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFu0i, BFs0c_BFu0s_BFu0c_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFu0ll) C1{ Fc:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFu0ll, BFs0c_BFu0s_BFu0c_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0c_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0c_BFu0s) C1{ Fc:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0c_BFu0s, BFs0c_BFu0s_BFu0c_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i) C1{ Fc:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i, BFs0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFs0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFs0c, BFs0c_BFu0s_BFu0i_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFs0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFs0i, BFs0c_BFu0s_BFu0i_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFs0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFs0ll, BFs0c_BFu0s_BFu0i_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFs0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFs0s, BFs0c_BFu0s_BFu0i_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFu0c) C1{ Fc:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFu0c, BFs0c_BFu0s_BFu0i_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFu0i) C1{ Fc:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFu0i, BFs0c_BFu0s_BFu0i_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFu0ll) C1{ Fc:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFu0ll, BFs0c_BFu0s_BFu0i_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0i_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0i_BFu0s) C1{ Fc:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0i_BFu0s, BFs0c_BFu0s_BFu0i_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll) C1{ Fc:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll, BFs0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFs0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFs0c, BFs0c_BFu0s_BFu0ll_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFs0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFs0i, BFs0c_BFu0s_BFu0ll_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFs0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFs0ll, BFs0c_BFu0s_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFs0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFs0s, BFs0c_BFu0s_BFu0ll_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFu0c) C1{ Fc:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFu0c, BFs0c_BFu0s_BFu0ll_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFu0i) C1{ Fc:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFu0i, BFs0c_BFu0s_BFu0ll_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFu0ll) C1{ Fc:0 Fs:0 FL:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFu0ll, BFs0c_BFu0s_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0ll_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0ll_BFu0s) C1{ Fc:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0ll_BFu0s, BFs0c_BFu0s_BFu0ll_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s, BFs0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFs0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFs0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFs0c, BFs0c_BFu0s_BFu0s_BFs0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFs0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFs0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFs0i, BFs0c_BFu0s_BFu0s_BFs0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFs0ll  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFs0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFs0ll, BFs0c_BFu0s_BFu0s_BFs0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFs0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFs0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFs0s, BFs0c_BFu0s_BFu0s_BFs0s)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFu0c  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFu0c) C1{ Fc:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0c_BFu0s_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFu0c, BFs0c_BFu0s_BFu0s_BFu0c)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFu0i  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFu0i) C1{ Fc:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0c_BFu0s_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFu0i, BFs0c_BFu0s_BFu0s_BFu0i)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFu0ll  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFu0ll) C1{ Fc:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0c_BFu0s_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFu0ll, BFs0c_BFu0s_BFu0s_BFu0ll)
//============================================================================


struct  BFs0c_BFu0s_BFu0s_BFu0s  {
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0c_BFu0s_BFu0s_BFu0s) C1{ Fc:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0c_BFu0s_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0c_BFu0s_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0c_BFu0s_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0c_BFu0s_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0c_BFu0s_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0c_BFu0s_BFu0s_BFu0s, BFs0c_BFu0s_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0c  {
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c) C1{ Fi:0 Fc:0}



static void Test_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c, BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0c  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c) C1{ Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c, BFs0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFs0c  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFs0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFs0c, BFs0i_BFs0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFs0i  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFs0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFs0i, BFs0i_BFs0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFs0ll  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFs0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFs0ll, BFs0i_BFs0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFs0s  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFs0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFs0s, BFs0i_BFs0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFu0c  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFu0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFu0c, BFs0i_BFs0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFu0i  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFu0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFu0i, BFs0i_BFs0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFu0ll  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFu0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFu0ll, BFs0i_BFs0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0c_BFu0s  {
  signed int  :0;
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0c_BFu0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0c_BFu0s, BFs0i_BFs0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0i  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i) C1{ Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i, BFs0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFs0c  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFs0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFs0c, BFs0i_BFs0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFs0i  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFs0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFs0i, BFs0i_BFs0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFs0ll  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFs0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFs0ll, BFs0i_BFs0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFs0s  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFs0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFs0s, BFs0i_BFs0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFu0c  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFu0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFu0c, BFs0i_BFs0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFu0i  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFu0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFu0i, BFs0i_BFs0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFu0ll  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFu0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFu0ll, BFs0i_BFs0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0i_BFu0s  {
  signed int  :0;
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0i_BFu0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0i_BFu0s, BFs0i_BFs0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll) C1{ Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll, BFs0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFs0c  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFs0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFs0c, BFs0i_BFs0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFs0i  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFs0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFs0i, BFs0i_BFs0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFs0ll  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFs0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFs0ll, BFs0i_BFs0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFs0s  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFs0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFs0s, BFs0i_BFs0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFu0c  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFu0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFu0c, BFs0i_BFs0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFu0i  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFu0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFu0i, BFs0i_BFs0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFu0ll  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFu0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFu0ll, BFs0i_BFs0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0ll_BFu0s  {
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0ll_BFu0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0ll_BFu0s, BFs0i_BFs0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0s  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s) C1{ Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s, BFs0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFs0c  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFs0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFs0c, BFs0i_BFs0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFs0i  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFs0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFs0i, BFs0i_BFs0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFs0ll  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFs0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFs0ll, BFs0i_BFs0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFs0s  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFs0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFs0s, BFs0i_BFs0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFu0c  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFu0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFu0c, BFs0i_BFs0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFu0i  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFu0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFu0i, BFs0i_BFs0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFu0ll  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFu0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFu0ll, BFs0i_BFs0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFs0s_BFu0s  {
  signed int  :0;
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFs0s_BFu0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFs0s_BFu0s, BFs0i_BFs0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0c  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c) C1{ Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c, BFs0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFs0c  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFs0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFs0c, BFs0i_BFs0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFs0i  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFs0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFs0i, BFs0i_BFs0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFs0ll  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFs0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFs0ll, BFs0i_BFs0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFs0s  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFs0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFs0s, BFs0i_BFs0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFu0c  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFu0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFu0c, BFs0i_BFs0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFu0i  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFu0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFu0i, BFs0i_BFs0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFu0ll  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFu0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFu0ll, BFs0i_BFs0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0c_BFu0s  {
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0c_BFu0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0c_BFu0s, BFs0i_BFs0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0i  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i) C1{ Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i, BFs0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFs0c  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFs0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFs0c, BFs0i_BFs0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFs0i  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFs0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFs0i, BFs0i_BFs0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFs0ll  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFs0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFs0ll, BFs0i_BFs0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFs0s  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFs0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFs0s, BFs0i_BFs0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFu0c  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFu0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFu0c, BFs0i_BFs0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFu0i  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFu0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFu0i, BFs0i_BFs0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFu0ll  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFu0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFu0ll, BFs0i_BFs0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0i_BFu0s  {
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0i_BFu0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0i_BFu0s, BFs0i_BFs0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll) C1{ Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll, BFs0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFs0c  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFs0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFs0c, BFs0i_BFs0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFs0i  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFs0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFs0i, BFs0i_BFs0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFs0ll  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFs0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFs0ll, BFs0i_BFs0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFs0s  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFs0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFs0s, BFs0i_BFs0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFu0c  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFu0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFu0c, BFs0i_BFs0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFu0i  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFu0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFu0i, BFs0i_BFs0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFu0ll  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFu0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFu0ll, BFs0i_BFs0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0ll_BFu0s  {
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0ll_BFu0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0ll_BFu0s, BFs0i_BFs0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0s  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s) C1{ Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s, BFs0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFs0c  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFs0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFs0c, BFs0i_BFs0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFs0i  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFs0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFs0i, BFs0i_BFs0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFs0ll  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFs0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFs0ll, BFs0i_BFs0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFs0s  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFs0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFs0s, BFs0i_BFs0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFu0c  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFu0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFu0c, BFs0i_BFs0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFu0i  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFu0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFu0i, BFs0i_BFs0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFu0ll  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFu0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFu0ll, BFs0i_BFs0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0c_BFu0s_BFu0s  {
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0c_BFu0s_BFu0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0c_BFu0s_BFu0s, BFs0i_BFs0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0i  {
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i) C1{ Fi:0 Fi:0}



static void Test_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i, BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0c  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c) C1{ Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c, BFs0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFs0c  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFs0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFs0c, BFs0i_BFs0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFs0i  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFs0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFs0i, BFs0i_BFs0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFs0ll  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFs0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFs0ll, BFs0i_BFs0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFs0s  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFs0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFs0s, BFs0i_BFs0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFu0c  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFu0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFu0c, BFs0i_BFs0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFu0i  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFu0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFu0i, BFs0i_BFs0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFu0ll  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFu0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFu0ll, BFs0i_BFs0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0c_BFu0s  {
  signed int  :0;
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0c_BFu0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0c_BFu0s, BFs0i_BFs0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0i  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i) C1{ Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i, BFs0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFs0c  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFs0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFs0c, BFs0i_BFs0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFs0i  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFs0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFs0i, BFs0i_BFs0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFs0ll  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFs0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFs0ll, BFs0i_BFs0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFs0s  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFs0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFs0s, BFs0i_BFs0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFu0c  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFu0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFu0c, BFs0i_BFs0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFu0i  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFu0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFu0i, BFs0i_BFs0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFu0ll  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFu0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFu0ll, BFs0i_BFs0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0i_BFu0s  {
  signed int  :0;
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0i_BFu0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0i_BFu0s, BFs0i_BFs0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll) C1{ Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll, BFs0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFs0c  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFs0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFs0c, BFs0i_BFs0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFs0i  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFs0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFs0i, BFs0i_BFs0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFs0ll  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFs0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFs0ll, BFs0i_BFs0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFs0s  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFs0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFs0s, BFs0i_BFs0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFu0c  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFu0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFu0c, BFs0i_BFs0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFu0i  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFu0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFu0i, BFs0i_BFs0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFu0ll  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFu0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFu0ll, BFs0i_BFs0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0ll_BFu0s  {
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0ll_BFu0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0ll_BFu0s, BFs0i_BFs0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0s  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s) C1{ Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s, BFs0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFs0c  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFs0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFs0c, BFs0i_BFs0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFs0i  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFs0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFs0i, BFs0i_BFs0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFs0ll  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFs0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFs0ll, BFs0i_BFs0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFs0s  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFs0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFs0s, BFs0i_BFs0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFu0c  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFu0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFu0c, BFs0i_BFs0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFu0i  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFu0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFu0i, BFs0i_BFs0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFu0ll  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFu0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFu0ll, BFs0i_BFs0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFs0s_BFu0s  {
  signed int  :0;
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFs0s_BFu0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFs0s_BFu0s, BFs0i_BFs0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0c  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c) C1{ Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c, BFs0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFs0c  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFs0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFs0c, BFs0i_BFs0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFs0i  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFs0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFs0i, BFs0i_BFs0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFs0ll  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFs0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFs0ll, BFs0i_BFs0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFs0s  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFs0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFs0s, BFs0i_BFs0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFu0c  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFu0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFu0c, BFs0i_BFs0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFu0i  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFu0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFu0i, BFs0i_BFs0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFu0ll  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFu0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFu0ll, BFs0i_BFs0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0c_BFu0s  {
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0c_BFu0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0c_BFu0s, BFs0i_BFs0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0i  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i) C1{ Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i, BFs0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFs0c  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFs0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFs0c, BFs0i_BFs0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFs0i  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFs0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFs0i, BFs0i_BFs0i_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFs0ll  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFs0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFs0ll, BFs0i_BFs0i_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFs0s  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFs0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFs0s, BFs0i_BFs0i_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFu0c  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFu0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFu0c, BFs0i_BFs0i_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFu0i  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFu0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFu0i, BFs0i_BFs0i_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFu0ll  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFu0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFu0ll, BFs0i_BFs0i_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0i_BFu0s  {
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0i_BFu0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0i_BFu0s, BFs0i_BFs0i_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll) C1{ Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll, BFs0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFs0c  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFs0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFs0c, BFs0i_BFs0i_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFs0i  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFs0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFs0i, BFs0i_BFs0i_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFs0ll  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFs0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFs0ll, BFs0i_BFs0i_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFs0s  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFs0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFs0s, BFs0i_BFs0i_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFu0c  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFu0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFu0c, BFs0i_BFs0i_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFu0i  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFu0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFu0i, BFs0i_BFs0i_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFu0ll  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFu0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFu0ll, BFs0i_BFs0i_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0ll_BFu0s  {
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0ll_BFu0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0ll_BFu0s, BFs0i_BFs0i_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0s  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s) C1{ Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s, BFs0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFs0c  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFs0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFs0c, BFs0i_BFs0i_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFs0i  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFs0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFs0i, BFs0i_BFs0i_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFs0ll  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFs0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFs0ll, BFs0i_BFs0i_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFs0s  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFs0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFs0s, BFs0i_BFs0i_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFu0c  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFu0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFu0c, BFs0i_BFs0i_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFu0i  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFu0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFu0i, BFs0i_BFs0i_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFu0ll  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFu0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFu0ll, BFs0i_BFs0i_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0i_BFu0s_BFu0s  {
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0i_BFu0s_BFu0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0i_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0i_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0i_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0i_BFu0s_BFu0s, BFs0i_BFs0i_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll) C1{ Fi:0 FL:0}



static void Test_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll, BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c) C1{ Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c, BFs0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFs0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFs0c, BFs0i_BFs0ll_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFs0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFs0i, BFs0i_BFs0ll_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFs0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFs0ll, BFs0i_BFs0ll_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFs0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFs0s, BFs0i_BFs0ll_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFu0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFu0c, BFs0i_BFs0ll_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFu0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFu0i, BFs0i_BFs0ll_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFu0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFu0ll, BFs0i_BFs0ll_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0c_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0c_BFu0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0c_BFu0s, BFs0i_BFs0ll_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i) C1{ Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i, BFs0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFs0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFs0c, BFs0i_BFs0ll_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFs0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFs0i, BFs0i_BFs0ll_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFs0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFs0ll, BFs0i_BFs0ll_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFs0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFs0s, BFs0i_BFs0ll_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFu0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFu0c, BFs0i_BFs0ll_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFu0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFu0i, BFs0i_BFs0ll_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFu0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFu0ll, BFs0i_BFs0ll_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0i_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0i_BFu0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0i_BFu0s, BFs0i_BFs0ll_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll) C1{ Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll, BFs0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFs0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFs0c, BFs0i_BFs0ll_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFs0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFs0i, BFs0i_BFs0ll_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFs0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFs0ll, BFs0i_BFs0ll_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFs0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFs0s, BFs0i_BFs0ll_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFu0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFu0c, BFs0i_BFs0ll_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFu0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFu0i, BFs0i_BFs0ll_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFu0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFu0ll, BFs0i_BFs0ll_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0ll_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0ll_BFu0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0ll_BFu0s, BFs0i_BFs0ll_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s) C1{ Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s, BFs0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFs0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFs0c, BFs0i_BFs0ll_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFs0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFs0i, BFs0i_BFs0ll_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFs0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFs0ll, BFs0i_BFs0ll_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFs0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFs0s, BFs0i_BFs0ll_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFu0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFu0c, BFs0i_BFs0ll_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFu0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFu0i, BFs0i_BFs0ll_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFu0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFu0ll, BFs0i_BFs0ll_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFs0s_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFs0s_BFu0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFs0s_BFu0s, BFs0i_BFs0ll_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c) C1{ Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c, BFs0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFs0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFs0c, BFs0i_BFs0ll_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFs0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFs0i, BFs0i_BFs0ll_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFs0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFs0ll, BFs0i_BFs0ll_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFs0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFs0s, BFs0i_BFs0ll_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFu0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFu0c, BFs0i_BFs0ll_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFu0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFu0i, BFs0i_BFs0ll_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFu0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFu0ll, BFs0i_BFs0ll_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0c_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0c_BFu0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0c_BFu0s, BFs0i_BFs0ll_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i) C1{ Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i, BFs0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFs0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFs0c, BFs0i_BFs0ll_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFs0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFs0i, BFs0i_BFs0ll_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFs0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFs0ll, BFs0i_BFs0ll_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFs0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFs0s, BFs0i_BFs0ll_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFu0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFu0c, BFs0i_BFs0ll_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFu0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFu0i, BFs0i_BFs0ll_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFu0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFu0ll, BFs0i_BFs0ll_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0i_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0i_BFu0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0i_BFu0s, BFs0i_BFs0ll_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll) C1{ Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll, BFs0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFs0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFs0c, BFs0i_BFs0ll_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFs0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFs0i, BFs0i_BFs0ll_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFs0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFs0ll, BFs0i_BFs0ll_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFs0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFs0s, BFs0i_BFs0ll_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFu0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFu0c, BFs0i_BFs0ll_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFu0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFu0i, BFs0i_BFs0ll_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFu0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFu0ll, BFs0i_BFs0ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0ll_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0ll_BFu0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0ll_BFu0s, BFs0i_BFs0ll_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s) C1{ Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s, BFs0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFs0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFs0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFs0c, BFs0i_BFs0ll_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFs0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFs0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFs0i, BFs0i_BFs0ll_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFs0ll  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFs0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFs0ll, BFs0i_BFs0ll_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFs0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFs0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFs0s, BFs0i_BFs0ll_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFu0c  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFu0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFu0c, BFs0i_BFs0ll_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFu0i  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFu0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFu0i, BFs0i_BFs0ll_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFu0ll  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFu0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFu0ll, BFs0i_BFs0ll_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0ll_BFu0s_BFu0s  {
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0ll_BFu0s_BFu0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0ll_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0ll_BFu0s_BFu0s, BFs0i_BFs0ll_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0s  {
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s) C1{ Fi:0 Fs:0}



static void Test_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s, BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0c  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c) C1{ Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c, BFs0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFs0c  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFs0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFs0c, BFs0i_BFs0s_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFs0i  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFs0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFs0i, BFs0i_BFs0s_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFs0ll  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFs0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFs0ll, BFs0i_BFs0s_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFs0s  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFs0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFs0s, BFs0i_BFs0s_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFu0c  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFu0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFu0c, BFs0i_BFs0s_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFu0i  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFu0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFu0i, BFs0i_BFs0s_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFu0ll  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFu0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFu0ll, BFs0i_BFs0s_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0c_BFu0s  {
  signed int  :0;
  signed short  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0c_BFu0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0c_BFu0s, BFs0i_BFs0s_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0i  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i) C1{ Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i, BFs0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFs0c  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFs0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFs0c, BFs0i_BFs0s_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFs0i  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFs0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFs0i, BFs0i_BFs0s_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFs0ll  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFs0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFs0ll, BFs0i_BFs0s_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFs0s  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFs0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFs0s, BFs0i_BFs0s_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFu0c  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFu0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFu0c, BFs0i_BFs0s_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFu0i  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFu0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFu0i, BFs0i_BFs0s_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFu0ll  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFu0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFu0ll, BFs0i_BFs0s_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0i_BFu0s  {
  signed int  :0;
  signed short  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0i_BFu0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0i_BFu0s, BFs0i_BFs0s_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll) C1{ Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll, BFs0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFs0c  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFs0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFs0c, BFs0i_BFs0s_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFs0i  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFs0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFs0i, BFs0i_BFs0s_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFs0ll  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFs0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFs0ll, BFs0i_BFs0s_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFs0s  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFs0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFs0s, BFs0i_BFs0s_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFu0c  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFu0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFu0c, BFs0i_BFs0s_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFu0i  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFu0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFu0i, BFs0i_BFs0s_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFu0ll  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFu0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFu0ll, BFs0i_BFs0s_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0ll_BFu0s  {
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0ll_BFu0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0ll_BFu0s, BFs0i_BFs0s_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0s  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s) C1{ Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s, BFs0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFs0c  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFs0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFs0c, BFs0i_BFs0s_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFs0i  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFs0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFs0i, BFs0i_BFs0s_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFs0ll  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFs0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFs0ll, BFs0i_BFs0s_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFs0s  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFs0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFs0s, BFs0i_BFs0s_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFu0c  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFu0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0s_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFu0c, BFs0i_BFs0s_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFu0i  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFu0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0s_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFu0i, BFs0i_BFs0s_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFu0ll  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFu0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0s_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFu0ll, BFs0i_BFs0s_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFs0s_BFu0s  {
  signed int  :0;
  signed short  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFs0s_BFu0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0s_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFs0s_BFu0s, BFs0i_BFs0s_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0c  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c) C1{ Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c, BFs0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFs0c  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFs0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFs0c, BFs0i_BFs0s_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFs0i  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFs0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFs0i, BFs0i_BFs0s_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFs0ll  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFs0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFs0ll, BFs0i_BFs0s_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFs0s  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFs0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFs0s, BFs0i_BFs0s_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFu0c  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFu0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFu0c, BFs0i_BFs0s_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFu0i  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFu0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFu0i, BFs0i_BFs0s_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFu0ll  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFu0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFu0ll, BFs0i_BFs0s_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0c_BFu0s  {
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0c_BFu0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0c_BFu0s, BFs0i_BFs0s_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0i  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i) C1{ Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i, BFs0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFs0c  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFs0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFs0c, BFs0i_BFs0s_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFs0i  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFs0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFs0i, BFs0i_BFs0s_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFs0ll  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFs0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFs0ll, BFs0i_BFs0s_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFs0s  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFs0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFs0s, BFs0i_BFs0s_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFu0c  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFu0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFu0c, BFs0i_BFs0s_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFu0i  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFu0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFu0i, BFs0i_BFs0s_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFu0ll  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFu0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFu0ll, BFs0i_BFs0s_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0i_BFu0s  {
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0i_BFu0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0i_BFu0s, BFs0i_BFs0s_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll) C1{ Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll, BFs0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFs0c  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFs0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFs0c, BFs0i_BFs0s_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFs0i  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFs0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFs0i, BFs0i_BFs0s_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFs0ll  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFs0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFs0ll, BFs0i_BFs0s_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFs0s  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFs0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFs0s, BFs0i_BFs0s_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFu0c  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFu0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFu0c, BFs0i_BFs0s_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFu0i  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFu0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFu0i, BFs0i_BFs0s_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFu0ll  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFu0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFu0ll, BFs0i_BFs0s_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0ll_BFu0s  {
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0ll_BFu0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0ll_BFu0s, BFs0i_BFs0s_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0s  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s) C1{ Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s, BFs0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFs0c  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFs0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFs0c, BFs0i_BFs0s_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFs0i  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFs0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFs0i, BFs0i_BFs0s_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFs0ll  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFs0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFs0ll, BFs0i_BFs0s_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFs0s  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFs0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFs0s, BFs0i_BFs0s_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFu0c  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFu0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFs0s_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFu0c, BFs0i_BFs0s_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFu0i  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFu0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFs0s_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFu0i, BFs0i_BFs0s_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFu0ll  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFu0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFs0s_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFu0ll, BFs0i_BFs0s_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFs0s_BFu0s_BFu0s  {
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFs0s_BFu0s_BFu0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFs0s_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFs0s_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFs0s_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFs0s_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFs0s_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFs0s_BFu0s_BFu0s, BFs0i_BFs0s_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0c  {
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c) C1{ Fi:0 Fc:0}



static void Test_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c, BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c) C1{ Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c, BFs0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFs0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFs0c, BFs0i_BFu0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFs0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFs0i, BFs0i_BFu0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFs0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFs0ll, BFs0i_BFu0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFs0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFs0s, BFs0i_BFu0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFu0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFu0c, BFs0i_BFu0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFu0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFu0i, BFs0i_BFu0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFu0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFu0ll, BFs0i_BFu0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0c_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0c_BFu0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0c_BFu0s, BFs0i_BFu0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i) C1{ Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i, BFs0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFs0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFs0c, BFs0i_BFu0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFs0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFs0i, BFs0i_BFu0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFs0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFs0ll, BFs0i_BFu0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFs0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFs0s, BFs0i_BFu0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFu0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFu0c, BFs0i_BFu0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFu0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFu0i, BFs0i_BFu0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFu0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFu0ll, BFs0i_BFu0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0i_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0i_BFu0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0i_BFu0s, BFs0i_BFu0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll) C1{ Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll, BFs0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFs0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFs0c, BFs0i_BFu0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFs0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFs0i, BFs0i_BFu0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFs0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFs0ll, BFs0i_BFu0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFs0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFs0s, BFs0i_BFu0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFu0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFu0c, BFs0i_BFu0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFu0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFu0i, BFs0i_BFu0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFu0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFu0ll, BFs0i_BFu0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0ll_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0ll_BFu0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0ll_BFu0s, BFs0i_BFu0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s) C1{ Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s, BFs0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFs0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFs0c, BFs0i_BFu0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFs0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFs0i, BFs0i_BFu0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFs0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFs0ll, BFs0i_BFu0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFs0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFs0s, BFs0i_BFu0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFu0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFu0c, BFs0i_BFu0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFu0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFu0i, BFs0i_BFu0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFu0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFu0ll, BFs0i_BFu0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFs0s_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFs0s_BFu0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFs0s_BFu0s, BFs0i_BFu0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c) C1{ Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c, BFs0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFs0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFs0c, BFs0i_BFu0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFs0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFs0i, BFs0i_BFu0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFs0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFs0ll, BFs0i_BFu0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFs0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFs0s, BFs0i_BFu0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFu0c) C1{ Fi:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFu0c, BFs0i_BFu0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFu0i) C1{ Fi:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFu0i, BFs0i_BFu0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFu0ll) C1{ Fi:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFu0ll, BFs0i_BFu0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0c_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0c_BFu0s) C1{ Fi:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0c_BFu0s, BFs0i_BFu0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i) C1{ Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i, BFs0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFs0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFs0c, BFs0i_BFu0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFs0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFs0i, BFs0i_BFu0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFs0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFs0ll, BFs0i_BFu0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFs0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFs0s, BFs0i_BFu0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFu0c) C1{ Fi:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFu0c, BFs0i_BFu0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFu0i) C1{ Fi:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFu0i, BFs0i_BFu0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFu0ll) C1{ Fi:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFu0ll, BFs0i_BFu0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0i_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0i_BFu0s) C1{ Fi:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0i_BFu0s, BFs0i_BFu0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll) C1{ Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll, BFs0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFs0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFs0c, BFs0i_BFu0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFs0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFs0i, BFs0i_BFu0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFs0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFs0ll, BFs0i_BFu0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFs0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFs0s, BFs0i_BFu0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFu0c) C1{ Fi:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFu0c, BFs0i_BFu0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFu0i) C1{ Fi:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFu0i, BFs0i_BFu0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFu0ll) C1{ Fi:0 Fc:0 FL:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFu0ll, BFs0i_BFu0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0ll_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0ll_BFu0s) C1{ Fi:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0ll_BFu0s, BFs0i_BFu0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s) C1{ Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s, BFs0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFs0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFs0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFs0c, BFs0i_BFu0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFs0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFs0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFs0i, BFs0i_BFu0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFs0ll  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFs0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFs0ll, BFs0i_BFu0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFs0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFs0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFs0s, BFs0i_BFu0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFu0c  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFu0c) C1{ Fi:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFu0c, BFs0i_BFu0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFu0i  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFu0i) C1{ Fi:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFu0i, BFs0i_BFu0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFu0ll  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFu0ll) C1{ Fi:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFu0ll, BFs0i_BFu0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0c_BFu0s_BFu0s  {
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0c_BFu0s_BFu0s) C1{ Fi:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0c_BFu0s_BFu0s, BFs0i_BFu0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0i  {
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i) C1{ Fi:0 Fi:0}



static void Test_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i, BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c) C1{ Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c, BFs0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFs0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFs0c, BFs0i_BFu0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFs0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFs0i, BFs0i_BFu0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFs0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFs0ll, BFs0i_BFu0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFs0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFs0s, BFs0i_BFu0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFu0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFu0c, BFs0i_BFu0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFu0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFu0i, BFs0i_BFu0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFu0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFu0ll, BFs0i_BFu0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0c_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0c_BFu0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0c_BFu0s, BFs0i_BFu0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i) C1{ Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i, BFs0i_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFs0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFs0c, BFs0i_BFu0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFs0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFs0i, BFs0i_BFu0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFs0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFs0ll, BFs0i_BFu0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFs0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFs0s, BFs0i_BFu0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFu0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFu0c, BFs0i_BFu0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFu0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFu0i, BFs0i_BFu0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFu0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFu0ll, BFs0i_BFu0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0i_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0i_BFu0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0i_BFu0s, BFs0i_BFu0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll) C1{ Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll, BFs0i_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFs0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFs0c, BFs0i_BFu0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFs0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFs0i, BFs0i_BFu0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFs0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFs0ll, BFs0i_BFu0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFs0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFs0s, BFs0i_BFu0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFu0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFu0c, BFs0i_BFu0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFu0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFu0i, BFs0i_BFu0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFu0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFu0ll, BFs0i_BFu0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0ll_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0ll_BFu0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0ll_BFu0s, BFs0i_BFu0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s) C1{ Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s, BFs0i_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFs0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFs0c, BFs0i_BFu0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFs0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFs0i, BFs0i_BFu0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFs0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFs0ll, BFs0i_BFu0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFs0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFs0s, BFs0i_BFu0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFu0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFu0c, BFs0i_BFu0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFu0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFu0i, BFs0i_BFu0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFu0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFu0ll, BFs0i_BFu0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFs0s_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFs0s_BFu0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFs0s_BFu0s, BFs0i_BFu0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c) C1{ Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c, BFs0i_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFs0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFs0c, BFs0i_BFu0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFs0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFs0i, BFs0i_BFu0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFs0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFs0ll, BFs0i_BFu0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFs0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFs0s, BFs0i_BFu0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFu0c) C1{ Fi:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFu0c, BFs0i_BFu0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFu0i) C1{ Fi:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFu0i, BFs0i_BFu0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFu0ll) C1{ Fi:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFu0ll, BFs0i_BFu0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0c_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0c_BFu0s) C1{ Fi:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0c_BFu0s, BFs0i_BFu0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i) C1{ Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i, BFs0i_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFs0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFs0c, BFs0i_BFu0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFs0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFs0i, BFs0i_BFu0i_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFs0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFs0ll, BFs0i_BFu0i_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFs0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFs0s, BFs0i_BFu0i_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFu0c) C1{ Fi:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFu0c, BFs0i_BFu0i_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFu0i) C1{ Fi:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFu0i, BFs0i_BFu0i_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFu0ll) C1{ Fi:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFu0ll, BFs0i_BFu0i_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0i_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0i_BFu0s) C1{ Fi:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0i_BFu0s, BFs0i_BFu0i_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll) C1{ Fi:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll, BFs0i_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFs0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFs0c, BFs0i_BFu0i_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFs0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFs0i, BFs0i_BFu0i_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFs0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFs0ll, BFs0i_BFu0i_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFs0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFs0s, BFs0i_BFu0i_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFu0c) C1{ Fi:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFu0c, BFs0i_BFu0i_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFu0i) C1{ Fi:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFu0i, BFs0i_BFu0i_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFu0ll) C1{ Fi:0 Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFu0ll, BFs0i_BFu0i_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0ll_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0ll_BFu0s) C1{ Fi:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0ll_BFu0s, BFs0i_BFu0i_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s) C1{ Fi:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s, BFs0i_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFs0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFs0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFs0c, BFs0i_BFu0i_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFs0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFs0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFs0i, BFs0i_BFu0i_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFs0ll  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFs0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFs0ll, BFs0i_BFu0i_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFs0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFs0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFs0s, BFs0i_BFu0i_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFu0c  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFu0c) C1{ Fi:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFu0c, BFs0i_BFu0i_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFu0i  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFu0i) C1{ Fi:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFu0i, BFs0i_BFu0i_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFu0ll  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFu0ll) C1{ Fi:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFu0ll, BFs0i_BFu0i_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0i_BFu0s_BFu0s  {
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0i_BFu0s_BFu0s) C1{ Fi:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0i_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0i_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0i_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0i_BFu0s_BFu0s, BFs0i_BFu0i_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll) C1{ Fi:0 FL:0}



static void Test_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll, BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c) C1{ Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c, BFs0i_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFs0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFs0c, BFs0i_BFu0ll_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFs0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFs0i, BFs0i_BFu0ll_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFs0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFs0ll, BFs0i_BFu0ll_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFs0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFs0s, BFs0i_BFu0ll_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFu0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFu0c, BFs0i_BFu0ll_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFu0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFu0i, BFs0i_BFu0ll_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFu0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFu0ll, BFs0i_BFu0ll_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0c_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0c_BFu0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0c_BFu0s, BFs0i_BFu0ll_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i) C1{ Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i, BFs0i_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFs0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFs0c, BFs0i_BFu0ll_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFs0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFs0i, BFs0i_BFu0ll_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFs0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFs0ll, BFs0i_BFu0ll_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFs0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFs0s, BFs0i_BFu0ll_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFu0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFu0c, BFs0i_BFu0ll_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFu0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFu0i, BFs0i_BFu0ll_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFu0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFu0ll, BFs0i_BFu0ll_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0i_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0i_BFu0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0i_BFu0s, BFs0i_BFu0ll_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll) C1{ Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll, BFs0i_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFs0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFs0c, BFs0i_BFu0ll_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFs0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFs0i, BFs0i_BFu0ll_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFs0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFs0ll, BFs0i_BFu0ll_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFs0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFs0s, BFs0i_BFu0ll_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFu0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFu0c, BFs0i_BFu0ll_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFu0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFu0i, BFs0i_BFu0ll_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFu0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFu0ll, BFs0i_BFu0ll_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0ll_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0ll_BFu0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0ll_BFu0s, BFs0i_BFu0ll_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s) C1{ Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s, BFs0i_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFs0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFs0c, BFs0i_BFu0ll_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFs0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFs0i, BFs0i_BFu0ll_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFs0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFs0ll, BFs0i_BFu0ll_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFs0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFs0s, BFs0i_BFu0ll_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFu0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFu0c, BFs0i_BFu0ll_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFu0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFu0i, BFs0i_BFu0ll_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFu0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFu0ll, BFs0i_BFu0ll_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFs0s_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFs0s_BFu0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFs0s_BFu0s, BFs0i_BFu0ll_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c) C1{ Fi:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c, BFs0i_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFs0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFs0c, BFs0i_BFu0ll_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFs0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFs0i, BFs0i_BFu0ll_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFs0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFs0ll, BFs0i_BFu0ll_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFs0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFs0s, BFs0i_BFu0ll_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFu0c) C1{ Fi:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFu0c, BFs0i_BFu0ll_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFu0i) C1{ Fi:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFu0i, BFs0i_BFu0ll_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFu0ll) C1{ Fi:0 FL:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFu0ll, BFs0i_BFu0ll_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0c_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0c_BFu0s) C1{ Fi:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0c_BFu0s, BFs0i_BFu0ll_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i) C1{ Fi:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i, BFs0i_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFs0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFs0c, BFs0i_BFu0ll_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFs0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFs0i, BFs0i_BFu0ll_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFs0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFs0ll, BFs0i_BFu0ll_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFs0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFs0s, BFs0i_BFu0ll_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFu0c) C1{ Fi:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFu0c, BFs0i_BFu0ll_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFu0i) C1{ Fi:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFu0i, BFs0i_BFu0ll_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFu0ll) C1{ Fi:0 FL:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFu0ll, BFs0i_BFu0ll_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0i_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0i_BFu0s) C1{ Fi:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0i_BFu0s, BFs0i_BFu0ll_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll) C1{ Fi:0 FL:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll, BFs0i_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFs0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFs0c, BFs0i_BFu0ll_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFs0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFs0i, BFs0i_BFu0ll_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFs0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFs0ll, BFs0i_BFu0ll_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFs0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFs0s, BFs0i_BFu0ll_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFu0c) C1{ Fi:0 FL:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFu0c, BFs0i_BFu0ll_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFu0i) C1{ Fi:0 FL:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFu0i, BFs0i_BFu0ll_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFu0ll) C1{ Fi:0 FL:0 FL:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFu0ll, BFs0i_BFu0ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0ll_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0ll_BFu0s) C1{ Fi:0 FL:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0ll_BFu0s, BFs0i_BFu0ll_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s) C1{ Fi:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s, BFs0i_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFs0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFs0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFs0c, BFs0i_BFu0ll_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFs0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFs0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFs0i, BFs0i_BFu0ll_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFs0ll  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFs0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFs0ll, BFs0i_BFu0ll_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFs0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFs0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFs0s, BFs0i_BFu0ll_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFu0c  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFu0c) C1{ Fi:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFu0c, BFs0i_BFu0ll_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFu0i  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFu0i) C1{ Fi:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFu0i, BFs0i_BFu0ll_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFu0ll  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFu0ll) C1{ Fi:0 FL:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFu0ll, BFs0i_BFu0ll_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0ll_BFu0s_BFu0s  {
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0ll_BFu0s_BFu0s) C1{ Fi:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0ll_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0ll_BFu0s_BFu0s, BFs0i_BFu0ll_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0s  {
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s) C1{ Fi:0 Fs:0}



static void Test_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s, BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c) C1{ Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c, BFs0i_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFs0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFs0c, BFs0i_BFu0s_BFs0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFs0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFs0i, BFs0i_BFu0s_BFs0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFs0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFs0ll, BFs0i_BFu0s_BFs0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFs0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFs0s, BFs0i_BFu0s_BFs0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFu0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFu0c, BFs0i_BFu0s_BFs0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFu0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFu0i, BFs0i_BFu0s_BFs0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFu0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFu0ll, BFs0i_BFu0s_BFs0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0c_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0c_BFu0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0c_BFu0s, BFs0i_BFu0s_BFs0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i) C1{ Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i, BFs0i_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFs0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFs0c, BFs0i_BFu0s_BFs0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFs0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFs0i, BFs0i_BFu0s_BFs0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFs0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFs0ll, BFs0i_BFu0s_BFs0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFs0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFs0s, BFs0i_BFu0s_BFs0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFu0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFu0c, BFs0i_BFu0s_BFs0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFu0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFu0i, BFs0i_BFu0s_BFs0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFu0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFu0ll, BFs0i_BFu0s_BFs0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0i_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0i_BFu0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0i_BFu0s, BFs0i_BFu0s_BFs0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll) C1{ Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll, BFs0i_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFs0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFs0c, BFs0i_BFu0s_BFs0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFs0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFs0i, BFs0i_BFu0s_BFs0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFs0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFs0ll, BFs0i_BFu0s_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFs0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFs0s, BFs0i_BFu0s_BFs0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFu0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFu0c, BFs0i_BFu0s_BFs0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFu0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFu0i, BFs0i_BFu0s_BFs0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFu0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFu0ll, BFs0i_BFu0s_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0ll_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0ll_BFu0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0ll_BFu0s, BFs0i_BFu0s_BFs0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s) C1{ Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s, BFs0i_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFs0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFs0c, BFs0i_BFu0s_BFs0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFs0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFs0i, BFs0i_BFu0s_BFs0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFs0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFs0ll, BFs0i_BFu0s_BFs0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFs0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFs0s, BFs0i_BFu0s_BFs0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFu0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0s_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFu0c, BFs0i_BFu0s_BFs0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFu0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0s_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFu0i, BFs0i_BFu0s_BFs0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFu0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0s_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFu0ll, BFs0i_BFu0s_BFs0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFs0s_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFs0s_BFu0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0s_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFs0s_BFu0s, BFs0i_BFu0s_BFs0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c) C1{ Fi:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c, BFs0i_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFs0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFs0c, BFs0i_BFu0s_BFu0c_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFs0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFs0i, BFs0i_BFu0s_BFu0c_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFs0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFs0ll, BFs0i_BFu0s_BFu0c_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFs0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFs0s, BFs0i_BFu0s_BFu0c_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFu0c) C1{ Fi:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFu0c, BFs0i_BFu0s_BFu0c_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFu0i) C1{ Fi:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFu0i, BFs0i_BFu0s_BFu0c_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFu0ll) C1{ Fi:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFu0ll, BFs0i_BFu0s_BFu0c_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0c_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0c_BFu0s) C1{ Fi:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0c_BFu0s, BFs0i_BFu0s_BFu0c_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i) C1{ Fi:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i, BFs0i_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFs0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFs0c, BFs0i_BFu0s_BFu0i_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFs0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFs0i, BFs0i_BFu0s_BFu0i_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFs0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFs0ll, BFs0i_BFu0s_BFu0i_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFs0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFs0s, BFs0i_BFu0s_BFu0i_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFu0c) C1{ Fi:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFu0c, BFs0i_BFu0s_BFu0i_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFu0i) C1{ Fi:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFu0i, BFs0i_BFu0s_BFu0i_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFu0ll) C1{ Fi:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFu0ll, BFs0i_BFu0s_BFu0i_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0i_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0i_BFu0s) C1{ Fi:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0i_BFu0s, BFs0i_BFu0s_BFu0i_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll) C1{ Fi:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll, BFs0i_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFs0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFs0c, BFs0i_BFu0s_BFu0ll_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFs0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFs0i, BFs0i_BFu0s_BFu0ll_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFs0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFs0ll, BFs0i_BFu0s_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFs0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFs0s, BFs0i_BFu0s_BFu0ll_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFu0c) C1{ Fi:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFu0c, BFs0i_BFu0s_BFu0ll_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFu0i) C1{ Fi:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFu0i, BFs0i_BFu0s_BFu0ll_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFu0ll) C1{ Fi:0 Fs:0 FL:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFu0ll, BFs0i_BFu0s_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0ll_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0ll_BFu0s) C1{ Fi:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0ll_BFu0s, BFs0i_BFu0s_BFu0ll_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s) C1{ Fi:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s, BFs0i_BFu0s_BFu0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFs0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFs0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFs0c, BFs0i_BFu0s_BFu0s_BFs0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFs0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFs0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFs0i, BFs0i_BFu0s_BFu0s_BFs0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFs0ll  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFs0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFs0ll, BFs0i_BFu0s_BFu0s_BFs0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFs0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFs0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFs0s, BFs0i_BFu0s_BFu0s_BFs0s)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFu0c  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFu0c) C1{ Fi:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0i_BFu0s_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFu0c, BFs0i_BFu0s_BFu0s_BFu0c)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFu0i  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFu0i) C1{ Fi:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0i_BFu0s_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFu0i, BFs0i_BFu0s_BFu0s_BFu0i)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFu0ll  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFu0ll) C1{ Fi:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0i_BFu0s_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFu0ll, BFs0i_BFu0s_BFu0s_BFu0ll)
//============================================================================


struct  BFs0i_BFu0s_BFu0s_BFu0s  {
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0i_BFu0s_BFu0s_BFu0s) C1{ Fi:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0i_BFu0s_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0i_BFu0s_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0i_BFu0s_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0i_BFu0s_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0i_BFu0s_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0i_BFu0s_BFu0s_BFu0s, BFs0i_BFu0s_BFu0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c) C1{ FL:0 Fc:0}



static void Test_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c, BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c) C1{ FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c, BFs0ll_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFs0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFs0c, BFs0ll_BFs0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFs0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFs0i, BFs0ll_BFs0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFs0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFs0ll, BFs0ll_BFs0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFs0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFs0s, BFs0ll_BFs0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFu0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFu0c, BFs0ll_BFs0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFu0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFu0i, BFs0ll_BFs0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFu0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFu0ll, BFs0ll_BFs0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0c_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0c_BFu0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0c_BFu0s, BFs0ll_BFs0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i) C1{ FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i, BFs0ll_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFs0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFs0c, BFs0ll_BFs0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFs0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFs0i, BFs0ll_BFs0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFs0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFs0ll, BFs0ll_BFs0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFs0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFs0s, BFs0ll_BFs0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFu0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFu0c, BFs0ll_BFs0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFu0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFu0i, BFs0ll_BFs0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFu0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFu0ll, BFs0ll_BFs0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0i_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0i_BFu0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0i_BFu0s, BFs0ll_BFs0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll) C1{ FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll, BFs0ll_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFs0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFs0c, BFs0ll_BFs0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFs0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFs0i, BFs0ll_BFs0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFs0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFs0ll, BFs0ll_BFs0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFs0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFs0s, BFs0ll_BFs0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFu0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFu0c, BFs0ll_BFs0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFu0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFu0i, BFs0ll_BFs0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFu0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFu0ll, BFs0ll_BFs0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0ll_BFu0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0ll_BFu0s, BFs0ll_BFs0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s) C1{ FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s, BFs0ll_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFs0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFs0c, BFs0ll_BFs0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFs0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFs0i, BFs0ll_BFs0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFs0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFs0ll, BFs0ll_BFs0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFs0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFs0s, BFs0ll_BFs0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFu0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFu0c, BFs0ll_BFs0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFu0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFu0i, BFs0ll_BFs0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFu0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFu0ll, BFs0ll_BFs0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFs0s_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFs0s_BFu0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFs0s_BFu0s, BFs0ll_BFs0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c) C1{ FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c, BFs0ll_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFs0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFs0c, BFs0ll_BFs0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFs0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFs0i, BFs0ll_BFs0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFs0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFs0ll, BFs0ll_BFs0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFs0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFs0s, BFs0ll_BFs0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFu0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFu0c, BFs0ll_BFs0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFu0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFu0i, BFs0ll_BFs0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFu0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFu0ll, BFs0ll_BFs0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0c_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0c_BFu0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0c_BFu0s, BFs0ll_BFs0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i) C1{ FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i, BFs0ll_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFs0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFs0c, BFs0ll_BFs0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFs0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFs0i, BFs0ll_BFs0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFs0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFs0ll, BFs0ll_BFs0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFs0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFs0s, BFs0ll_BFs0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFu0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFu0c, BFs0ll_BFs0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFu0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFu0i, BFs0ll_BFs0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFu0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFu0ll, BFs0ll_BFs0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0i_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0i_BFu0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0i_BFu0s, BFs0ll_BFs0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll) C1{ FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll, BFs0ll_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFs0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFs0c, BFs0ll_BFs0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFs0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFs0i, BFs0ll_BFs0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFs0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFs0ll, BFs0ll_BFs0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFs0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFs0s, BFs0ll_BFs0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFu0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFu0c, BFs0ll_BFs0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFu0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFu0i, BFs0ll_BFs0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFu0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFu0ll, BFs0ll_BFs0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0ll_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0ll_BFu0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0ll_BFu0s, BFs0ll_BFs0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s) C1{ FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s, BFs0ll_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFs0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFs0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFs0c, BFs0ll_BFs0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFs0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFs0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFs0i, BFs0ll_BFs0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFs0ll  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFs0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFs0ll, BFs0ll_BFs0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFs0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFs0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFs0s, BFs0ll_BFs0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFu0c  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFu0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFu0c, BFs0ll_BFs0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFu0i  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFu0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFu0i, BFs0ll_BFs0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFu0ll  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFu0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFu0ll, BFs0ll_BFs0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0c_BFu0s_BFu0s  {
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0c_BFu0s_BFu0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0c_BFu0s_BFu0s, BFs0ll_BFs0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i) C1{ FL:0 Fi:0}



static void Test_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i, BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c) C1{ FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c, BFs0ll_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFs0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFs0c, BFs0ll_BFs0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFs0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFs0i, BFs0ll_BFs0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFs0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFs0ll, BFs0ll_BFs0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFs0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFs0s, BFs0ll_BFs0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFu0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFu0c, BFs0ll_BFs0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFu0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFu0i, BFs0ll_BFs0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFu0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFu0ll, BFs0ll_BFs0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0c_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0c_BFu0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0c_BFu0s, BFs0ll_BFs0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i) C1{ FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i, BFs0ll_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFs0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFs0c, BFs0ll_BFs0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFs0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFs0i, BFs0ll_BFs0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFs0ll) C1{ FL:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFs0ll, BFs0ll_BFs0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFs0s) C1{ FL:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFs0s, BFs0ll_BFs0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFu0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFu0c, BFs0ll_BFs0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFu0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFu0i, BFs0ll_BFs0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFu0ll) C1{ FL:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFu0ll, BFs0ll_BFs0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0i_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0i_BFu0s) C1{ FL:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0i_BFu0s, BFs0ll_BFs0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll) C1{ FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll, BFs0ll_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFs0c) C1{ FL:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFs0c, BFs0ll_BFs0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFs0i) C1{ FL:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFs0i, BFs0ll_BFs0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFs0ll) C1{ FL:0 Fi:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFs0ll, BFs0ll_BFs0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFs0s) C1{ FL:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFs0s, BFs0ll_BFs0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFu0c) C1{ FL:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFu0c, BFs0ll_BFs0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFu0i) C1{ FL:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFu0i, BFs0ll_BFs0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFu0ll) C1{ FL:0 Fi:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFu0ll, BFs0ll_BFs0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0ll_BFu0s) C1{ FL:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0ll_BFu0s, BFs0ll_BFs0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s) C1{ FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s, BFs0ll_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFs0c) C1{ FL:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFs0c, BFs0ll_BFs0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFs0i) C1{ FL:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFs0i, BFs0ll_BFs0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFs0ll) C1{ FL:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFs0ll, BFs0ll_BFs0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFs0s) C1{ FL:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFs0s, BFs0ll_BFs0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFu0c) C1{ FL:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFu0c, BFs0ll_BFs0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFu0i) C1{ FL:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFu0i, BFs0ll_BFs0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFu0ll) C1{ FL:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFu0ll, BFs0ll_BFs0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFs0s_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFs0s_BFu0s) C1{ FL:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFs0s_BFu0s, BFs0ll_BFs0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c) C1{ FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c, BFs0ll_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFs0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFs0c, BFs0ll_BFs0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFs0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFs0i, BFs0ll_BFs0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFs0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFs0ll, BFs0ll_BFs0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFs0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFs0s, BFs0ll_BFs0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFu0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFu0c, BFs0ll_BFs0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFu0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFu0i, BFs0ll_BFs0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFu0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFu0ll, BFs0ll_BFs0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0c_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0c_BFu0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0c_BFu0s, BFs0ll_BFs0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i) C1{ FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i, BFs0ll_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFs0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFs0c, BFs0ll_BFs0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFs0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFs0i, BFs0ll_BFs0i_BFu0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFs0ll) C1{ FL:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFs0ll, BFs0ll_BFs0i_BFu0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFs0s) C1{ FL:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFs0s, BFs0ll_BFs0i_BFu0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFu0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFu0c, BFs0ll_BFs0i_BFu0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFu0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFu0i, BFs0ll_BFs0i_BFu0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFu0ll) C1{ FL:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFu0ll, BFs0ll_BFs0i_BFu0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0i_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0i_BFu0s) C1{ FL:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0i_BFu0s, BFs0ll_BFs0i_BFu0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll) C1{ FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll, BFs0ll_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFs0c) C1{ FL:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFs0c, BFs0ll_BFs0i_BFu0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFs0i) C1{ FL:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFs0i, BFs0ll_BFs0i_BFu0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFs0ll) C1{ FL:0 Fi:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFs0ll, BFs0ll_BFs0i_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFs0s) C1{ FL:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFs0s, BFs0ll_BFs0i_BFu0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFu0c) C1{ FL:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFu0c, BFs0ll_BFs0i_BFu0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFu0i) C1{ FL:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFu0i, BFs0ll_BFs0i_BFu0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFu0ll) C1{ FL:0 Fi:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFu0ll, BFs0ll_BFs0i_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0ll_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0ll_BFu0s) C1{ FL:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0ll_BFu0s, BFs0ll_BFs0i_BFu0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s) C1{ FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s, BFs0ll_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFs0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFs0c) C1{ FL:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFs0c, BFs0ll_BFs0i_BFu0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFs0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFs0i) C1{ FL:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFs0i, BFs0ll_BFs0i_BFu0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFs0ll  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFs0ll) C1{ FL:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFs0ll, BFs0ll_BFs0i_BFu0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFs0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFs0s) C1{ FL:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFs0s, BFs0ll_BFs0i_BFu0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFu0c  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFu0c) C1{ FL:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFu0c, BFs0ll_BFs0i_BFu0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFu0i  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFu0i) C1{ FL:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFu0i, BFs0ll_BFs0i_BFu0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFu0ll  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFu0ll) C1{ FL:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFu0ll, BFs0ll_BFs0i_BFu0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0i_BFu0s_BFu0s  {
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0i_BFu0s_BFu0s) C1{ FL:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0i_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0i_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0i_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0i_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0i_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0i_BFu0s_BFu0s, BFs0ll_BFs0i_BFu0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll) C1{ FL:0 FL:0}



static void Test_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll, BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c) C1{ FL:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c, BFs0ll_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFs0c) C1{ FL:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFs0c, BFs0ll_BFs0ll_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFs0i) C1{ FL:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFs0i, BFs0ll_BFs0ll_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFs0ll) C1{ FL:0 FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFs0ll, BFs0ll_BFs0ll_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFs0s) C1{ FL:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFs0s, BFs0ll_BFs0ll_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFu0c) C1{ FL:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFu0c, BFs0ll_BFs0ll_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFu0i) C1{ FL:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFu0i, BFs0ll_BFs0ll_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFu0ll) C1{ FL:0 FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFu0ll, BFs0ll_BFs0ll_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0c_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0c_BFu0s) C1{ FL:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0c_BFu0s, BFs0ll_BFs0ll_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i) C1{ FL:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i, BFs0ll_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFs0c) C1{ FL:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFs0c, BFs0ll_BFs0ll_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFs0i) C1{ FL:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFs0i, BFs0ll_BFs0ll_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFs0ll) C1{ FL:0 FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFs0ll, BFs0ll_BFs0ll_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFs0s) C1{ FL:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFs0s, BFs0ll_BFs0ll_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFu0c) C1{ FL:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFu0c, BFs0ll_BFs0ll_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFu0i) C1{ FL:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFu0i, BFs0ll_BFs0ll_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFu0ll) C1{ FL:0 FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFu0ll, BFs0ll_BFs0ll_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0i_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0i_BFu0s) C1{ FL:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0i_BFu0s, BFs0ll_BFs0ll_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll) C1{ FL:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll, BFs0ll_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFs0c) C1{ FL:0 FL:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFs0c, BFs0ll_BFs0ll_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFs0i) C1{ FL:0 FL:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFs0i, BFs0ll_BFs0ll_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFs0ll) C1{ FL:0 FL:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFs0ll, BFs0ll_BFs0ll_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFs0s) C1{ FL:0 FL:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFs0s, BFs0ll_BFs0ll_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFu0c) C1{ FL:0 FL:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFu0c, BFs0ll_BFs0ll_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFu0i) C1{ FL:0 FL:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFu0i, BFs0ll_BFs0ll_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFu0ll) C1{ FL:0 FL:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFu0ll, BFs0ll_BFs0ll_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0ll_BFu0s) C1{ FL:0 FL:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0ll_BFu0s, BFs0ll_BFs0ll_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s) C1{ FL:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s, BFs0ll_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFs0c) C1{ FL:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFs0c, BFs0ll_BFs0ll_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFs0i) C1{ FL:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFs0i, BFs0ll_BFs0ll_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFs0ll) C1{ FL:0 FL:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFs0ll, BFs0ll_BFs0ll_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFs0s) C1{ FL:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFs0s, BFs0ll_BFs0ll_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFu0c) C1{ FL:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFu0c, BFs0ll_BFs0ll_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFu0i) C1{ FL:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFu0i, BFs0ll_BFs0ll_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFu0ll) C1{ FL:0 FL:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFu0ll, BFs0ll_BFs0ll_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFs0s_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFs0s_BFu0s) C1{ FL:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFs0s_BFu0s, BFs0ll_BFs0ll_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c) C1{ FL:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c, BFs0ll_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFs0c) C1{ FL:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFs0c, BFs0ll_BFs0ll_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFs0i) C1{ FL:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFs0i, BFs0ll_BFs0ll_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFs0ll) C1{ FL:0 FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFs0ll, BFs0ll_BFs0ll_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFs0s) C1{ FL:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFs0s, BFs0ll_BFs0ll_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFu0c) C1{ FL:0 FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFu0c, BFs0ll_BFs0ll_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFu0i) C1{ FL:0 FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFu0i, BFs0ll_BFs0ll_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFu0ll) C1{ FL:0 FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFu0ll, BFs0ll_BFs0ll_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0c_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0c_BFu0s) C1{ FL:0 FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0c_BFu0s, BFs0ll_BFs0ll_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i) C1{ FL:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i, BFs0ll_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFs0c) C1{ FL:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFs0c, BFs0ll_BFs0ll_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFs0i) C1{ FL:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFs0i, BFs0ll_BFs0ll_BFu0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFs0ll) C1{ FL:0 FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFs0ll, BFs0ll_BFs0ll_BFu0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFs0s) C1{ FL:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFs0s, BFs0ll_BFs0ll_BFu0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFu0c) C1{ FL:0 FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFu0c, BFs0ll_BFs0ll_BFu0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFu0i) C1{ FL:0 FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFu0i, BFs0ll_BFs0ll_BFu0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFu0ll) C1{ FL:0 FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFu0ll, BFs0ll_BFs0ll_BFu0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0i_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0i_BFu0s) C1{ FL:0 FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0i_BFu0s, BFs0ll_BFs0ll_BFu0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll) C1{ FL:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll, BFs0ll_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFs0c) C1{ FL:0 FL:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFs0c, BFs0ll_BFs0ll_BFu0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFs0i) C1{ FL:0 FL:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFs0i, BFs0ll_BFs0ll_BFu0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFs0ll) C1{ FL:0 FL:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFs0ll, BFs0ll_BFs0ll_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFs0s) C1{ FL:0 FL:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFs0s, BFs0ll_BFs0ll_BFu0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFu0c) C1{ FL:0 FL:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFu0c, BFs0ll_BFs0ll_BFu0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFu0i) C1{ FL:0 FL:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFu0i, BFs0ll_BFs0ll_BFu0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFu0ll) C1{ FL:0 FL:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFu0ll, BFs0ll_BFs0ll_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0ll_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0ll_BFu0s) C1{ FL:0 FL:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0ll_BFu0s, BFs0ll_BFs0ll_BFu0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s) C1{ FL:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s, BFs0ll_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFs0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFs0c) C1{ FL:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFs0c, BFs0ll_BFs0ll_BFu0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFs0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFs0i) C1{ FL:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFs0i, BFs0ll_BFs0ll_BFu0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFs0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFs0ll) C1{ FL:0 FL:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFs0ll, BFs0ll_BFs0ll_BFu0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFs0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFs0s) C1{ FL:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFs0s, BFs0ll_BFs0ll_BFu0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFu0c  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFu0c) C1{ FL:0 FL:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFu0c, BFs0ll_BFs0ll_BFu0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFu0i  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFu0i) C1{ FL:0 FL:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFu0i, BFs0ll_BFs0ll_BFu0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFu0ll  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFu0ll) C1{ FL:0 FL:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFu0ll, BFs0ll_BFs0ll_BFu0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0ll_BFu0s_BFu0s  {
  signed __tsi64  :0;
  signed __tsi64  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0ll_BFu0s_BFu0s) C1{ FL:0 FL:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0ll_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0ll_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0ll_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0ll_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0ll_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0ll_BFu0s_BFu0s, BFs0ll_BFs0ll_BFu0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s) C1{ FL:0 Fs:0}



static void Test_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s, BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c) C1{ FL:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c, BFs0ll_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFs0c) C1{ FL:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFs0c, BFs0ll_BFs0s_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFs0i) C1{ FL:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFs0i, BFs0ll_BFs0s_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFs0ll) C1{ FL:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFs0ll, BFs0ll_BFs0s_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFs0s) C1{ FL:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFs0s, BFs0ll_BFs0s_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFu0c) C1{ FL:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFu0c, BFs0ll_BFs0s_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFu0i) C1{ FL:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFu0i, BFs0ll_BFs0s_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFu0ll) C1{ FL:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFu0ll, BFs0ll_BFs0s_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0c_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0c_BFu0s) C1{ FL:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0c_BFu0s, BFs0ll_BFs0s_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i) C1{ FL:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i, BFs0ll_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFs0c) C1{ FL:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFs0c, BFs0ll_BFs0s_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFs0i) C1{ FL:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFs0i, BFs0ll_BFs0s_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFs0ll) C1{ FL:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFs0ll, BFs0ll_BFs0s_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFs0s) C1{ FL:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFs0s, BFs0ll_BFs0s_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFu0c) C1{ FL:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFu0c, BFs0ll_BFs0s_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFu0i) C1{ FL:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFu0i, BFs0ll_BFs0s_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFu0ll) C1{ FL:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFu0ll, BFs0ll_BFs0s_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0i_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0i_BFu0s) C1{ FL:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0i_BFu0s, BFs0ll_BFs0s_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll) C1{ FL:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll, BFs0ll_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFs0c) C1{ FL:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFs0c, BFs0ll_BFs0s_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFs0i) C1{ FL:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFs0i, BFs0ll_BFs0s_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFs0ll) C1{ FL:0 Fs:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFs0ll, BFs0ll_BFs0s_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFs0s) C1{ FL:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFs0s, BFs0ll_BFs0s_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFu0c) C1{ FL:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFu0c, BFs0ll_BFs0s_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFu0i) C1{ FL:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFu0i, BFs0ll_BFs0s_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFu0ll) C1{ FL:0 Fs:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFu0ll, BFs0ll_BFs0s_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0ll_BFu0s) C1{ FL:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0ll_BFu0s, BFs0ll_BFs0s_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s) C1{ FL:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s, BFs0ll_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFs0c) C1{ FL:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFs0c, BFs0ll_BFs0s_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFs0i) C1{ FL:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFs0i, BFs0ll_BFs0s_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFs0ll) C1{ FL:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFs0ll, BFs0ll_BFs0s_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFs0s) C1{ FL:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFs0s, BFs0ll_BFs0s_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFu0c) C1{ FL:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFu0c, BFs0ll_BFs0s_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFu0i) C1{ FL:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFu0i, BFs0ll_BFs0s_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFu0ll) C1{ FL:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFu0ll, BFs0ll_BFs0s_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFs0s_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFs0s_BFu0s) C1{ FL:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFs0s_BFu0s, BFs0ll_BFs0s_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c) C1{ FL:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c, BFs0ll_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFs0c) C1{ FL:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFs0c, BFs0ll_BFs0s_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFs0i) C1{ FL:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFs0i, BFs0ll_BFs0s_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFs0ll) C1{ FL:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFs0ll, BFs0ll_BFs0s_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFs0s) C1{ FL:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFs0s, BFs0ll_BFs0s_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFu0c) C1{ FL:0 Fs:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFu0c, BFs0ll_BFs0s_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFu0i) C1{ FL:0 Fs:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFu0i, BFs0ll_BFs0s_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFu0ll) C1{ FL:0 Fs:0 Fc:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFu0ll, BFs0ll_BFs0s_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0c_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0c_BFu0s) C1{ FL:0 Fs:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0c_BFu0s, BFs0ll_BFs0s_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i) C1{ FL:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i, BFs0ll_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFs0c) C1{ FL:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFs0c, BFs0ll_BFs0s_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFs0i) C1{ FL:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFs0i, BFs0ll_BFs0s_BFu0i_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFs0ll) C1{ FL:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFs0ll, BFs0ll_BFs0s_BFu0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFs0s) C1{ FL:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFs0s, BFs0ll_BFs0s_BFu0i_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFu0c) C1{ FL:0 Fs:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFu0c, BFs0ll_BFs0s_BFu0i_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFu0i) C1{ FL:0 Fs:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFu0i, BFs0ll_BFs0s_BFu0i_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFu0ll) C1{ FL:0 Fs:0 Fi:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFu0ll, BFs0ll_BFs0s_BFu0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0i_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0i_BFu0s) C1{ FL:0 Fs:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0i_BFu0s, BFs0ll_BFs0s_BFu0i_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll) C1{ FL:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll, BFs0ll_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFs0c) C1{ FL:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFs0c, BFs0ll_BFs0s_BFu0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFs0i) C1{ FL:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFs0i, BFs0ll_BFs0s_BFu0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFs0ll) C1{ FL:0 Fs:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFs0ll, BFs0ll_BFs0s_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFs0s) C1{ FL:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFs0s, BFs0ll_BFs0s_BFu0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFu0c) C1{ FL:0 Fs:0 FL:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFu0c, BFs0ll_BFs0s_BFu0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFu0i) C1{ FL:0 Fs:0 FL:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFu0i, BFs0ll_BFs0s_BFu0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFu0ll) C1{ FL:0 Fs:0 FL:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFu0ll, BFs0ll_BFs0s_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0ll_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0ll_BFu0s) C1{ FL:0 Fs:0 FL:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0ll_BFu0s, BFs0ll_BFs0s_BFu0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s) C1{ FL:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s, BFs0ll_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFs0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFs0c) C1{ FL:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFs0c, BFs0ll_BFs0s_BFu0s_BFs0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFs0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFs0i) C1{ FL:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFs0i, BFs0ll_BFs0s_BFu0s_BFs0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFs0ll  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFs0ll) C1{ FL:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFs0ll, BFs0ll_BFs0s_BFu0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFs0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFs0s) C1{ FL:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFs0s, BFs0ll_BFs0s_BFu0s_BFs0s)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFu0c  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFu0c) C1{ FL:0 Fs:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFu0c, BFs0ll_BFs0s_BFu0s_BFu0c)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFu0i  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFu0i) C1{ FL:0 Fs:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFu0i, BFs0ll_BFs0s_BFu0s_BFu0i)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFu0ll  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFu0ll) C1{ FL:0 Fs:0 Fs:0 FL:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFu0ll, BFs0ll_BFs0s_BFu0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFs0s_BFu0s_BFu0s  {
  signed __tsi64  :0;
  signed short  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFs0s_BFu0s_BFu0s) C1{ FL:0 Fs:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFs0s_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFs0s_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFs0s_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFs0s_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFs0s_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFs0s_BFu0s_BFu0s, BFs0ll_BFs0s_BFu0s_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c) C1{ FL:0 Fc:0}



static void Test_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c, BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c) C1{ FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c, BFs0ll_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFs0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFs0c, BFs0ll_BFu0c_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFs0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFs0i, BFs0ll_BFu0c_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFs0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFs0ll, BFs0ll_BFu0c_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFs0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFs0s, BFs0ll_BFu0c_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFu0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFu0c, BFs0ll_BFu0c_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFu0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFu0i, BFs0ll_BFu0c_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFu0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFu0ll, BFs0ll_BFu0c_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0c_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0c_BFu0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0c_BFu0s, BFs0ll_BFu0c_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i) C1{ FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i, BFs0ll_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFs0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFs0c, BFs0ll_BFu0c_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFs0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFs0i, BFs0ll_BFu0c_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFs0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFs0ll, BFs0ll_BFu0c_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFs0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFs0s, BFs0ll_BFu0c_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFu0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFu0c, BFs0ll_BFu0c_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFu0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFu0i, BFs0ll_BFu0c_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFu0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFu0ll, BFs0ll_BFu0c_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0i_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0i_BFu0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0i_BFu0s, BFs0ll_BFu0c_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll) C1{ FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll, BFs0ll_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFs0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFs0c, BFs0ll_BFu0c_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFs0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFs0i, BFs0ll_BFu0c_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFs0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFs0ll, BFs0ll_BFu0c_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFs0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFs0s, BFs0ll_BFu0c_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFu0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFu0c, BFs0ll_BFu0c_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFu0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFu0i, BFs0ll_BFu0c_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFu0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFu0ll, BFs0ll_BFu0c_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0ll_BFu0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0ll_BFu0s, BFs0ll_BFu0c_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s) C1{ FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s, BFs0ll_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFs0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFs0c, BFs0ll_BFu0c_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFs0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFs0i, BFs0ll_BFu0c_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFs0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFs0ll, BFs0ll_BFu0c_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFs0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFs0s, BFs0ll_BFu0c_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFu0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFu0c, BFs0ll_BFu0c_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFu0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFu0i, BFs0ll_BFu0c_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFu0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFu0ll, BFs0ll_BFu0c_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFs0s_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFs0s_BFu0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFs0s_BFu0s, BFs0ll_BFu0c_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c) C1{ FL:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c, BFs0ll_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFs0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFs0c, BFs0ll_BFu0c_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFs0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFs0i, BFs0ll_BFu0c_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFs0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFs0ll, BFs0ll_BFu0c_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFs0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFs0s, BFs0ll_BFu0c_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFu0c) C1{ FL:0 Fc:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFu0c, BFs0ll_BFu0c_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFu0i) C1{ FL:0 Fc:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFu0i, BFs0ll_BFu0c_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFu0ll) C1{ FL:0 Fc:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFu0ll, BFs0ll_BFu0c_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0c_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0c_BFu0s) C1{ FL:0 Fc:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0c_BFu0s, BFs0ll_BFu0c_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i) C1{ FL:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i, BFs0ll_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFs0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFs0c, BFs0ll_BFu0c_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFs0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFs0i, BFs0ll_BFu0c_BFu0i_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFs0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFs0ll, BFs0ll_BFu0c_BFu0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFs0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFs0s, BFs0ll_BFu0c_BFu0i_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFu0c) C1{ FL:0 Fc:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFu0c, BFs0ll_BFu0c_BFu0i_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFu0i) C1{ FL:0 Fc:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFu0i, BFs0ll_BFu0c_BFu0i_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFu0ll) C1{ FL:0 Fc:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFu0ll, BFs0ll_BFu0c_BFu0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0i_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0i_BFu0s) C1{ FL:0 Fc:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0i_BFu0s, BFs0ll_BFu0c_BFu0i_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll) C1{ FL:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll, BFs0ll_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFs0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFs0c, BFs0ll_BFu0c_BFu0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFs0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFs0i, BFs0ll_BFu0c_BFu0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFs0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFs0ll, BFs0ll_BFu0c_BFu0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFs0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFs0s, BFs0ll_BFu0c_BFu0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFu0c) C1{ FL:0 Fc:0 FL:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFu0c, BFs0ll_BFu0c_BFu0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFu0i) C1{ FL:0 Fc:0 FL:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFu0i, BFs0ll_BFu0c_BFu0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFu0ll) C1{ FL:0 Fc:0 FL:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFu0ll, BFs0ll_BFu0c_BFu0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0ll_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0ll_BFu0s) C1{ FL:0 Fc:0 FL:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0ll_BFu0s, BFs0ll_BFu0c_BFu0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s) C1{ FL:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s, BFs0ll_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFs0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFs0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFs0c, BFs0ll_BFu0c_BFu0s_BFs0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFs0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFs0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFs0i, BFs0ll_BFu0c_BFu0s_BFs0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFs0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFs0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFs0ll, BFs0ll_BFu0c_BFu0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFs0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFs0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFs0s, BFs0ll_BFu0c_BFu0s_BFs0s)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFu0c  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFu0c) C1{ FL:0 Fc:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFu0c, BFs0ll_BFu0c_BFu0s_BFu0c)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFu0i  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFu0i) C1{ FL:0 Fc:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFu0i, BFs0ll_BFu0c_BFu0s_BFu0i)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFu0ll  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFu0ll) C1{ FL:0 Fc:0 Fs:0 FL:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFu0ll, BFs0ll_BFu0c_BFu0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0c_BFu0s_BFu0s  {
  signed __tsi64  :0;
  unsigned char  :0;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0c_BFu0s_BFu0s) C1{ FL:0 Fc:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFu0c_BFu0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0c_BFu0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0c_BFu0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0c_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0c_BFu0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0c_BFu0s_BFu0s, BFs0ll_BFu0c_BFu0s_BFu0s)
//============================================================================


struct  BFs0ll_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i) C1{ FL:0 Fi:0}



static void Test_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i, BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c) C1{ FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c, BFs0ll_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFs0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFs0c, BFs0ll_BFu0i_BFs0c_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFs0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFs0i, BFs0ll_BFu0i_BFs0c_BFs0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFs0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFs0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFs0ll, BFs0ll_BFu0i_BFs0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFs0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFs0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFs0s, BFs0ll_BFu0i_BFs0c_BFs0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFu0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFu0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFu0c, BFs0ll_BFu0i_BFs0c_BFu0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFu0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFu0i, BFs0ll_BFu0i_BFs0c_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFu0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFu0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFu0ll, BFs0ll_BFu0i_BFs0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0c_BFu0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0c_BFu0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0c_BFu0s, BFs0ll_BFu0i_BFs0c_BFu0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i) C1{ FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i, BFs0ll_BFu0i_BFs0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFs0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFs0c, BFs0ll_BFu0i_BFs0i_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFs0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFs0i, BFs0ll_BFu0i_BFs0i_BFs0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFs0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFs0ll) C1{ FL:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFs0ll, BFs0ll_BFu0i_BFs0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFs0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFs0s) C1{ FL:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFs0s, BFs0ll_BFu0i_BFs0i_BFs0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFu0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFu0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFu0c, BFs0ll_BFu0i_BFs0i_BFu0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFu0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFu0i, BFs0ll_BFu0i_BFs0i_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFu0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFu0ll) C1{ FL:0 Fi:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFu0ll, BFs0ll_BFu0i_BFs0i_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0i_BFu0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed int  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0i_BFu0s) C1{ FL:0 Fi:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0i_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0i_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0i_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0i_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0i_BFu0s, BFs0ll_BFu0i_BFs0i_BFu0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll) C1{ FL:0 Fi:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll, BFs0ll_BFu0i_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFs0c) C1{ FL:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFs0c, BFs0ll_BFu0i_BFs0ll_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFs0i) C1{ FL:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFs0i, BFs0ll_BFu0i_BFs0ll_BFs0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFs0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFs0ll) C1{ FL:0 Fi:0 FL:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFs0ll, BFs0ll_BFu0i_BFs0ll_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFs0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFs0s) C1{ FL:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFs0s, BFs0ll_BFu0i_BFs0ll_BFs0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFu0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFu0c) C1{ FL:0 Fi:0 FL:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFu0c, BFs0ll_BFu0i_BFs0ll_BFu0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFu0i) C1{ FL:0 Fi:0 FL:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFu0i, BFs0ll_BFu0i_BFs0ll_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFu0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFu0ll) C1{ FL:0 Fi:0 FL:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFu0ll, BFs0ll_BFu0i_BFs0ll_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0ll_BFu0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed __tsi64  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0ll_BFu0s) C1{ FL:0 Fi:0 FL:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0ll_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0ll_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0ll_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0ll_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0ll_BFu0s, BFs0ll_BFu0i_BFs0ll_BFu0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s) C1{ FL:0 Fi:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s, BFs0ll_BFu0i_BFs0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFs0c) C1{ FL:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFs0c, BFs0ll_BFu0i_BFs0s_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFs0i) C1{ FL:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFs0i, BFs0ll_BFu0i_BFs0s_BFs0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFs0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFs0ll) C1{ FL:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFs0ll, BFs0ll_BFu0i_BFs0s_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFs0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFs0s) C1{ FL:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFs0s, BFs0ll_BFu0i_BFs0s_BFs0s)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFu0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFu0c) C1{ FL:0 Fi:0 Fs:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFu0c, BFs0ll_BFu0i_BFs0s_BFu0c)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFu0i) C1{ FL:0 Fi:0 Fs:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFu0i, BFs0ll_BFu0i_BFs0s_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFu0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFu0ll) C1{ FL:0 Fi:0 Fs:0 FL:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFu0ll, BFs0ll_BFu0i_BFs0s_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFs0s_BFu0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  signed short  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFs0s_BFu0s) C1{ FL:0 Fi:0 Fs:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFs0s_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFs0s_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFs0s_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFs0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFs0s_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFs0s_BFu0s, BFs0ll_BFu0i_BFs0s_BFu0s)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c) C1{ FL:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c, BFs0ll_BFu0i_BFu0c)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFs0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFs0c, BFs0ll_BFu0i_BFu0c_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFs0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFs0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFs0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFs0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFs0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFs0i, BFs0ll_BFu0i_BFu0c_BFs0i)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFs0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed __tsi64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFs0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFs0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFs0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFs0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFs0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFs0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFs0ll, BFs0ll_BFu0i_BFu0c_BFs0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFs0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  signed short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFs0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFs0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFs0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFs0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFs0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFs0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFs0s, BFs0ll_BFu0i_BFu0c_BFs0s)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFu0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFu0c) C1{ FL:0 Fi:0 Fc:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFu0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFu0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFu0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFu0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFu0c, BFs0ll_BFu0i_BFu0c_BFu0c)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFu0i) C1{ FL:0 Fi:0 Fc:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFu0i, BFs0ll_BFu0i_BFu0c_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFu0ll  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFu0ll) C1{ FL:0 Fi:0 Fc:0 FL:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFu0ll()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFu0ll");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFu0ll)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFu0ll, BFs0ll_BFu0i_BFu0c_BFu0ll)
//============================================================================


struct  BFs0ll_BFu0i_BFu0c_BFu0s  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0c_BFu0s) C1{ FL:0 Fi:0 Fc:0 Fs:0}



static void Test_BFs0ll_BFu0i_BFu0c_BFu0s()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0c_BFu0s");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0c_BFu0s lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0c_BFu0s)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0c_BFu0s, BFs0ll_BFu0i_BFu0c_BFu0s)
//============================================================================


struct  BFs0ll_BFu0i_BFu0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0i) C1{ FL:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFu0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0i");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0i lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0i)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0i, BFs0ll_BFu0i_BFu0i)
//============================================================================


struct  BFs0ll_BFu0i_BFu0i_BFs0c  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed char  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0i_BFs0c) C1{ FL:0 Fi:0 Fi:0 Fc:0}



static void Test_BFs0ll_BFu0i_BFu0i_BFs0c()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0i_BFs0c");
    static STRUCT_IF_C BFs0ll_BFu0i_BFu0i_BFs0c lv;
    check2(sizeof(lv), 0, "sizeof(BFs0ll_BFu0i_BFu0i_BFs0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFs0ll_BFu0i_BFu0i_BFs0c)");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs0ll_BFu0i_BFu0i_BFs0c, BFs0ll_BFu0i_BFu0i_BFs0c)
//============================================================================


struct  BFs0ll_BFu0i_BFu0i_BFs0i  {
  signed __tsi64  :0;
  unsigned int  :0;
  unsigned int  :0;
  signed int  :0;
};
//SIG(1 BFs0ll_BFu0i_BFu0i_BFs0i) C1{ FL:0 Fi:0 Fi:0 Fi:0}



static void Test_BFs0ll_BFu0i_BFu0i_BFs0i()
{
  {
    init_simple_test("BFs0ll_BFu0i_BFu0i_BFs0i");
    static STRUCT_IF_C BFs0ll_B