// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  A0  {
  int fa;
};
//SIG(-1 A0) C1{ Fi}



static void Test_A0()
{
  {
    init_simple_test("A0");
    A0 lv;
    check2(sizeof(lv), 4, "sizeof(A0)");
    check2(__alignof__(lv), 4, "__alignof__(A0)");
    check_field_offset(lv, fa, 0, "A0.fa");
  }
}
static Arrange_To_Call_Me vA0(Test_A0, "A0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI2A0[];
VTBL_ENTRY *P__ZTI2A0 = _ZTI2A0; 
Class_Descriptor cd_A0 = {  "A0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI2A0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  A1  {
  int fa;
  virtual void  foo(); // _ZN2A13fooEv
  ~A1(); // tgen
  A1(); // tgen
};
//SIG(-1 A1) C1{ v1 Fi}


void  A1 ::foo(){vfunc_called(this, "_ZN2A13fooEv");}
A1 ::~A1(){ note_dtor("A1", this);} // tgen
A1 ::A1(){ note_ctor("A1", this);} // tgen

static void Test_A1()
{
  extern Class_Descriptor cd_A1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_A1, buf);
    A1 *dp, &lv = *(dp=new (buf) A1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(A1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(A1)");
    check_field_offset(lv, fa, ABISELECT(8,4), "A1.fa");
    test_class_info(&lv, &cd_A1);
    dp->~A1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vA1(Test_A1, "A1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN2A1C1Ev();
extern void _ZN2A1D1Ev();
Name_Map name_map_A1[] = {
  NSPAIR(_ZN2A1C1Ev),
  NSPAIR(_ZN2A1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI2A1[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY vtc_A1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2A1[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
Class_Descriptor cd_A1 = {  "A1", // class name
  0,0,//no base classes
  &(vtc_A1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI2A1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV2A1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B0  {
  int fb;
};
//SIG(-1 B0) C1{ Fi}



static void Test_B0()
{
  {
    init_simple_test("B0");
    B0 lv;
    check2(sizeof(lv), 4, "sizeof(B0)");
    check2(__alignof__(lv), 4, "__alignof__(B0)");
    check_field_offset(lv, fb, 0, "B0.fb");
  }
}
static Arrange_To_Call_Me vB0(Test_B0, "B0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI2B0[];
VTBL_ENTRY *P__ZTI2B0 = _ZTI2B0; 
Class_Descriptor cd_B0 = {  "B0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI2B0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B1  {
  int fb;
  virtual void  foo(); // _ZN2B13fooEv
  ~B1(); // tgen
  B1(); // tgen
};
//SIG(-1 B1) C1{ v1 Fi}


void  B1 ::foo(){vfunc_called(this, "_ZN2B13fooEv");}
B1 ::~B1(){ note_dtor("B1", this);} // tgen
B1 ::B1(){ note_ctor("B1", this);} // tgen

static void Test_B1()
{
  extern Class_Descriptor cd_B1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_B1, buf);
    B1 *dp, &lv = *(dp=new (buf) B1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B1)");
    check_field_offset(lv, fb, ABISELECT(8,4), "B1.fb");
    test_class_info(&lv, &cd_B1);
    dp->~B1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vB1(Test_B1, "B1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN2B1C1Ev();
extern void _ZN2B1D1Ev();
Name_Map name_map_B1[] = {
  NSPAIR(_ZN2B1C1Ev),
  NSPAIR(_ZN2B1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI2B1[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_B1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2B1[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
Class_Descriptor cd_B1 = {  "B1", // class name
  0,0,//no base classes
  &(vtc_B1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI2B1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV2B1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D0  {
  int fd;
};
//SIG(-1 D0) C1{ Fi}



static void Test_D0()
{
  {
    init_simple_test("D0");
    D0 lv;
    check2(sizeof(lv), 4, "sizeof(D0)");
    check2(__alignof__(lv), 4, "__alignof__(D0)");
    check_field_offset(lv, fd, 0, "D0.fd");
  }
}
static Arrange_To_Call_Me vD0(Test_D0, "D0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI2D0[];
VTBL_ENTRY *P__ZTI2D0 = _ZTI2D0; 
Class_Descriptor cd_D0 = {  "D0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI2D0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D1  {
  int fd;
  virtual void  foo(); // _ZN2D13fooEv
  ~D1(); // tgen
  D1(); // tgen
};
//SIG(1 D1) C1{ v1 Fi}


void  D1 ::foo(){vfunc_called(this, "_ZN2D13fooEv");}
D1 ::~D1(){ note_dtor("D1", this);} // tgen
D1 ::D1(){ note_ctor("D1", this);} // tgen

static void Test_D1()
{
  extern Class_Descriptor cd_D1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_D1, buf);
    D1 *dp, &lv = *(dp=new (buf) D1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(D1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D1)");
    check_field_offset(lv, fd, ABISELECT(8,4), "D1.fd");
    test_class_info(&lv, &cd_D1);
    dp->~D1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vD1(Test_D1, "D1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN2D1C1Ev();
extern void _ZN2D1D1Ev();
Name_Map name_map_D1[] = {
  NSPAIR(_ZN2D1C1Ev),
  NSPAIR(_ZN2D1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI2D1[];
extern void _ZN2D13fooEv();
static  VTBL_ENTRY vtc_D1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2D1[0]),
  (VTBL_ENTRY)&_ZN2D13fooEv,
};
extern VTBL_ENTRY _ZTI2D1[];
extern  VTBL_ENTRY _ZTV2D1[];
Class_Descriptor cd_D1 = {  "D1", // class name
  0,0,//no base classes
  &(vtc_D1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI2D1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV2D1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F0  {
  int ff;
};
//SIG(-1 F0) C1{ Fi}



static void Test_F0()
{
  {
    init_simple_test("F0");
    F0 lv;
    check2(sizeof(lv), 4, "sizeof(F0)");
    check2(__alignof__(lv), 4, "__alignof__(F0)");
    check_field_offset(lv, ff, 0, "F0.ff");
  }
}
static Arrange_To_Call_Me vF0(Test_F0, "F0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI2F0[];
VTBL_ENTRY *P__ZTI2F0 = _ZTI2F0; 
Class_Descriptor cd_F0 = {  "F0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI2F0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F1  {
  int ff;
  virtual void  foo(); // _ZN2F13fooEv
  ~F1(); // tgen
  F1(); // tgen
};
//SIG(-1 F1) C1{ v1 Fi}


void  F1 ::foo(){vfunc_called(this, "_ZN2F13fooEv");}
F1 ::~F1(){ note_dtor("F1", this);} // tgen
F1 ::F1(){ note_ctor("F1", this);} // tgen

static void Test_F1()
{
  extern Class_Descriptor cd_F1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_F1, buf);
    F1 *dp, &lv = *(dp=new (buf) F1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(F1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F1)");
    check_field_offset(lv, ff, ABISELECT(8,4), "F1.ff");
    test_class_info(&lv, &cd_F1);
    dp->~F1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF1(Test_F1, "F1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN2F1C1Ev();
extern void _ZN2F1D1Ev();
Name_Map name_map_F1[] = {
  NSPAIR(_ZN2F1C1Ev),
  NSPAIR(_ZN2F1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI2F1[];
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_F1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2F1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
Class_Descriptor cd_F1 = {  "F1", // class name
  0,0,//no base classes
  &(vtc_F1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI2F1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV2F1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C0  : A0 , B0 {
  int fc;
};
//SIG(-1 C0) C1{ BC2{ Fi} BC3{ Fi} Fi}



static void Test_C0()
{
  extern Class_Descriptor cd_C0;
  void *lvp;
  {
    int buf[4];
    init_test(&cd_C0, buf);
    C0 &lv = *(new (buf) C0());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(C0)");
    check2(__alignof__(lv), 4, "__alignof__(C0)");
    check_base_class_offset(lv, (A0*), 0, "C0");
    check_base_class_offset(lv, (B0*), 4, "C0");
    check_field_offset(lv, fc, 8, "C0.fc");
    test_class_info(&lv, &cd_C0);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC0(Test_C0, "C0", 12);

#else // __cplusplus

extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C0[];
Class_Descriptor cd_C0 = {  "C0", // class name
  bases_C0, 2,
  0, // no vftv
  0, //no vtt
  12, // object size
  NSPAIRA(_ZTI2C0),ABISELECT(56,32), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C1  : A1 , B0 {
  int fc;
  ~C1(); // tgen
  C1(); // tgen
};
//SIG(-1 C1) C1{ BC2{ v1 Fi} BC3{ Fi} Fi}


C1 ::~C1(){ note_dtor("C1", this);} // tgen
C1 ::C1(){ note_ctor("C1", this);} // tgen

static void Test_C1()
{
  extern Class_Descriptor cd_C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C1, buf);
    C1 *dp, &lv = *(dp=new (buf) C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C1)");
    check_base_class_offset(lv, (A1*), 0, "C1");
    check_base_class_offset(lv, (B0*), ABISELECT(12,8), "C1");
    check_field_offset(lv, fc, ABISELECT(16,12), "C1.fc");
    test_class_info(&lv, &cd_C1);
    dp->~C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC1(Test_C1, "C1", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN2C1C1Ev();
extern void _ZN2C1D1Ev();
Name_Map name_map_C1[] = {
  NSPAIR(_ZN2C1C1Ev),
  NSPAIR(_ZN2C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C1[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY vtc_C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2C1[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
Class_Descriptor cd_C1 = {  "C1", // class name
  bases_C1, 2,
  &(vtc_C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI2C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C2  : virtual A0 , B0 {
  int fc;
  ~C2(); // tgen
  C2(); // tgen
};
//SIG(-1 C2) C1{ VBC2{ Fi} BC3{ Fi} Fi}


C2 ::~C2(){ note_dtor("C2", this);} // tgen
C2 ::C2(){ note_ctor("C2", this);} // tgen

static void Test_C2()
{
  extern Class_Descriptor cd_C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C2, buf);
    C2 *dp, &lv = *(dp=new (buf) C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C2)");
    check_base_class_offset(lv, (A0*), ABISELECT(16,12), "C2");
    check_base_class_offset(lv, (B0*), ABISELECT(8,4), "C2");
    check_field_offset(lv, fc, ABISELECT(12,8), "C2.fc");
    test_class_info(&lv, &cd_C2);
    dp->~C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC2(Test_C2, "C2", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN2C2C1Ev();
extern void _ZN2C2D1Ev();
Name_Map name_map_C2[] = {
  NSPAIR(_ZN2C2C1Ev),
  NSPAIR(_ZN2C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C2[];
static  VTBL_ENTRY vtc_C2[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
extern VTBL_ENTRY _ZTV2C2[];
static  VTT_ENTRY vtt_C2[] = {
  {&(_ZTV2C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
Class_Descriptor cd_C2 = {  "C2", // class name
  bases_C2, 2,
  &(vtc_C2[0]), // expected_vtbl_contents
  &(vtt_C2[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI2C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C2),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT2C2),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C3  : virtual A1 , B0 {
  int fc;
  ~C3(); // tgen
  C3(); // tgen
};
//SIG(-1 C3) C1{ VBC2{ v1 Fi} BC3{ Fi} Fi}


C3 ::~C3(){ note_dtor("C3", this);} // tgen
C3 ::C3(){ note_ctor("C3", this);} // tgen

static void Test_C3()
{
  extern Class_Descriptor cd_C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C3, buf);
    C3 *dp, &lv = *(dp=new (buf) C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C3)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,12), "C3");
    check_base_class_offset(lv, (B0*), ABISELECT(8,4), "C3");
    check_field_offset(lv, fc, ABISELECT(12,8), "C3.fc");
    test_class_info(&lv, &cd_C3);
    dp->~C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC3(Test_C3, "C3", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN2C3C1Ev();
extern void _ZN2C3D1Ev();
Name_Map name_map_C3[] = {
  NSPAIR(_ZN2C3C1Ev),
  NSPAIR(_ZN2C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C3[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY vtc_C3[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern VTBL_ENTRY _ZTV2C3[];
static  VTT_ENTRY vtt_C3[] = {
  {&(_ZTV2C3[3]),  3,7},
  {&(_ZTV2C3[6]),  6,7},
};
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
Class_Descriptor cd_C3 = {  "C3", // class name
  bases_C3, 2,
  &(vtc_C3[0]), // expected_vtbl_contents
  &(vtt_C3[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI2C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C3),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT2C3),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C4  : A0 , B1 {
  int fc;
  ~C4(); // tgen
  C4(); // tgen
};
//SIG(-1 C4) C1{ BC2{ Fi} BC3{ v1 Fi} Fi}


C4 ::~C4(){ note_dtor("C4", this);} // tgen
C4 ::C4(){ note_ctor("C4", this);} // tgen

static void Test_C4()
{
  extern Class_Descriptor cd_C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C4, buf);
    C4 *dp, &lv = *(dp=new (buf) C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C4)");
    check_base_class_offset(lv, (A0*), ABISELECT(12,8), "C4");
    check_base_class_offset(lv, (B1*), 0, "C4");
    check_field_offset(lv, fc, ABISELECT(16,12), "C4.fc");
    test_class_info(&lv, &cd_C4);
    dp->~C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC4(Test_C4, "C4", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN2C4C1Ev();
extern void _ZN2C4D1Ev();
Name_Map name_map_C4[] = {
  NSPAIR(_ZN2C4C1Ev),
  NSPAIR(_ZN2C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C4[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2C4[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
Class_Descriptor cd_C4 = {  "C4", // class name
  bases_C4, 2,
  &(vtc_C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI2C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C5  : A1 , B1 {
  int fc;
  ~C5(); // tgen
  C5(); // tgen
};
//SIG(-1 C5) C1{ BC2{ v1 Fi} BC3{ v2 Fi} Fi}


C5 ::~C5(){ note_dtor("C5", this);} // tgen
C5 ::C5(){ note_ctor("C5", this);} // tgen

static void Test_C5()
{
  extern Class_Descriptor cd_C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C5, buf);
    C5 *dp, &lv = *(dp=new (buf) C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C5)");
    check_base_class_offset(lv, (A1*), 0, "C5");
    check_base_class_offset(lv, (B1*), ABISELECT(16,8), "C5");
    check_field_offset(lv, fc, ABISELECT(28,16), "C5.fc");
    test_class_info(&lv, &cd_C5);
    dp->~C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC5(Test_C5, "C5", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN2C5C1Ev();
extern void _ZN2C5D1Ev();
Name_Map name_map_C5[] = {
  NSPAIR(_ZN2C5C1Ev),
  NSPAIR(_ZN2C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C5[];
extern void _ZN2A13fooEv();
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI2C5[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI2C5[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
Class_Descriptor cd_C5 = {  "C5", // class name
  bases_C5, 2,
  &(vtc_C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI2C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C5),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C6  : virtual A0 , B1 {
  int fc;
  ~C6(); // tgen
  C6(); // tgen
};
//SIG(-1 C6) C1{ VBC2{ Fi} BC3{ v1 Fi} Fi}


C6 ::~C6(){ note_dtor("C6", this);} // tgen
C6 ::C6(){ note_ctor("C6", this);} // tgen

static void Test_C6()
{
  extern Class_Descriptor cd_C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C6, buf);
    C6 *dp, &lv = *(dp=new (buf) C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C6)");
    check_base_class_offset(lv, (A0*), ABISELECT(16,12), "C6");
    check_base_class_offset(lv, (B1*), 0, "C6");
    check_field_offset(lv, fc, ABISELECT(12,8), "C6.fc");
    test_class_info(&lv, &cd_C6);
    dp->~C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC6(Test_C6, "C6", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN2C6C1Ev();
extern void _ZN2C6D1Ev();
Name_Map name_map_C6[] = {
  NSPAIR(_ZN2C6C1Ev),
  NSPAIR(_ZN2C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C6[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C6[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTV2C6[];
static  VTT_ENTRY vtt_C6[] = {
  {&(_ZTV2C6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
Class_Descriptor cd_C6 = {  "C6", // class name
  bases_C6, 2,
  &(vtc_C6[0]), // expected_vtbl_contents
  &(vtt_C6[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI2C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C6),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT2C6),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C7  : virtual A1 , B1 {
  int fc;
  ~C7(); // tgen
  C7(); // tgen
};
//SIG(-1 C7) C1{ VBC2{ v1 Fi} BC3{ v2 Fi} Fi}


C7 ::~C7(){ note_dtor("C7", this);} // tgen
C7 ::C7(){ note_ctor("C7", this);} // tgen

static void Test_C7()
{
  extern Class_Descriptor cd_C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C7, buf);
    C7 *dp, &lv = *(dp=new (buf) C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C7)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,12), "C7");
    check_base_class_offset(lv, (B1*), 0, "C7");
    check_field_offset(lv, fc, ABISELECT(12,8), "C7.fc");
    test_class_info(&lv, &cd_C7);
    dp->~C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC7(Test_C7, "C7", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN2C7C1Ev();
extern void _ZN2C7D1Ev();
Name_Map name_map_C7[] = {
  NSPAIR(_ZN2C7C1Ev),
  NSPAIR(_ZN2C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI2C7[];
extern void _ZN2B13fooEv();
extern void _ZN2A13fooEv();
static  VTBL_ENTRY vtc_C7[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern VTBL_ENTRY _ZTV2C7[];
static  VTT_ENTRY vtt_C7[] = {
  {&(_ZTV2C7[3]),  3,8},
  {&(_ZTV2C7[7]),  7,8},
};
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
Class_Descriptor cd_C7 = {  "C7", // class name
  bases_C7, 2,
  &(vtc_C7[0]), // expected_vtbl_contents
  &(vtt_C7[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI2C7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C7),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT2C7),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C8  : A0 , virtual B0 {
  int fc;
  ~C8(); // tgen
  C8(); // tgen
};
//SIG(-1 C8) C1{ BC2{ Fi} VBC3{ Fi} Fi}


C8 ::~C8(){ note_dtor("C8", this);} // tgen
C8 ::C8(){ note_ctor("C8", this);} // tgen

static void Test_C8()
{
  extern Class_Descriptor cd_C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C8, buf);
    C8 *dp, &lv = *(dp=new (buf) C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C8)");
    check_base_class_offset(lv, (A0*), ABISELECT(8,4), "C8");
    check_base_class_offset(lv, (B0*), ABISELECT(16,12), "C8");
    check_field_offset(lv, fc, ABISELECT(12,8), "C8.fc");
    test_class_info(&lv, &cd_C8);
    dp->~C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC8(Test_C8, "C8", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN2C8C1Ev();
extern void _ZN2C8D1Ev();
Name_Map name_map_C8[] = {
  NSPAIR(_ZN2C8C1Ev),
  NSPAIR(_ZN2C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI2C8[];
static  VTBL_ENTRY vtc_C8[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
extern VTBL_ENTRY _ZTV2C8[];
static  VTT_ENTRY vtt_C8[] = {
  {&(_ZTV2C8[3]),  3,3},
};
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
Class_Descriptor cd_C8 = {  "C8", // class name
  bases_C8, 2,
  &(vtc_C8[0]), // expected_vtbl_contents
  &(vtt_C8[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI2C8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C8),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT2C8),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C9  : A1 , virtual B0 {
  int fc;
  ~C9(); // tgen
  C9(); // tgen
};
//SIG(-1 C9) C1{ BC2{ v1 Fi} VBC3{ Fi} Fi}


C9 ::~C9(){ note_dtor("C9", this);} // tgen
C9 ::C9(){ note_ctor("C9", this);} // tgen

static void Test_C9()
{
  extern Class_Descriptor cd_C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C9, buf);
    C9 *dp, &lv = *(dp=new (buf) C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C9)");
    check_base_class_offset(lv, (A1*), 0, "C9");
    check_base_class_offset(lv, (B0*), ABISELECT(16,12), "C9");
    check_field_offset(lv, fc, ABISELECT(12,8), "C9.fc");
    test_class_info(&lv, &cd_C9);
    dp->~C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC9(Test_C9, "C9", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN2C9C1Ev();
extern void _ZN2C9D1Ev();
Name_Map name_map_C9[] = {
  NSPAIR(_ZN2C9C1Ev),
  NSPAIR(_ZN2C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI2C9[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY vtc_C9[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern VTBL_ENTRY _ZTV2C9[];
static  VTT_ENTRY vtt_C9[] = {
  {&(_ZTV2C9[3]),  3,4},
};
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
Class_Descriptor cd_C9 = {  "C9", // class name
  bases_C9, 2,
  &(vtc_C9[0]), // expected_vtbl_contents
  &(vtt_C9[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI2C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV2C9),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT2C9),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C10  : virtual A0 , virtual B0 {
  int fc;
  ~C10(); // tgen
  C10(); // tgen
};
//SIG(-1 C10) C1{ VBC2{ Fi} VBC3{ Fi} Fi}


C10 ::~C10(){ note_dtor("C10", this);} // tgen
C10 ::C10(){ note_ctor("C10", this);} // tgen

static void Test_C10()
{
  extern Class_Descriptor cd_C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C10, buf);
    C10 *dp, &lv = *(dp=new (buf) C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C10)");
    check_base_class_offset(lv, (A0*), ABISELECT(12,8), "C10");
    check_base_class_offset(lv, (B0*), ABISELECT(16,12), "C10");
    check_field_offset(lv, fc, ABISELECT(8,4), "C10.fc");
    test_class_info(&lv, &cd_C10);
    dp->~C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC10(Test_C10, "C10", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C10C1Ev();
extern void _ZN3C10D1Ev();
Name_Map name_map_C10[] = {
  NSPAIR(_ZN3C10C1Ev),
  NSPAIR(_ZN3C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C10[];
static  VTBL_ENTRY vtc_C10[] = {
  ABISELECT(16,12),
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
extern VTBL_ENTRY _ZTV3C10[];
static  VTT_ENTRY vtt_C10[] = {
  {&(_ZTV3C10[4]),  4,4},
};
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
Class_Descriptor cd_C10 = {  "C10", // class name
  bases_C10, 2,
  &(vtc_C10[0]), // expected_vtbl_contents
  &(vtt_C10[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C10),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C10),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C11  : virtual A1 , virtual B0 {
  int fc;
  ~C11(); // tgen
  C11(); // tgen
};
//SIG(-1 C11) C1{ VBC2{ v1 Fi} VBC3{ Fi} Fi}


C11 ::~C11(){ note_dtor("C11", this);} // tgen
C11 ::C11(){ note_ctor("C11", this);} // tgen

static void Test_C11()
{
  extern Class_Descriptor cd_C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C11, buf);
    C11 *dp, &lv = *(dp=new (buf) C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C11)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,8), "C11");
    check_base_class_offset(lv, (B0*), ABISELECT(28,16), "C11");
    check_field_offset(lv, fc, ABISELECT(8,4), "C11.fc");
    test_class_info(&lv, &cd_C11);
    dp->~C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC11(Test_C11, "C11", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C11C1Ev();
extern void _ZN3C11D1Ev();
Name_Map name_map_C11[] = {
  NSPAIR(_ZN3C11C1Ev),
  NSPAIR(_ZN3C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C11[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY vtc_C11[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern VTBL_ENTRY _ZTV3C11[];
static  VTT_ENTRY vtt_C11[] = {
  {&(_ZTV3C11[4]),  4,8},
  {&(_ZTV3C11[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
Class_Descriptor cd_C11 = {  "C11", // class name
  bases_C11, 2,
  &(vtc_C11[0]), // expected_vtbl_contents
  &(vtt_C11[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C11),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C11),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C12  : A0 , virtual B1 {
  int fc;
  ~C12(); // tgen
  C12(); // tgen
};
//SIG(-1 C12) C1{ BC2{ Fi} VBC3{ v1 Fi} Fi}


C12 ::~C12(){ note_dtor("C12", this);} // tgen
C12 ::C12(){ note_ctor("C12", this);} // tgen

static void Test_C12()
{
  extern Class_Descriptor cd_C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C12, buf);
    C12 *dp, &lv = *(dp=new (buf) C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C12)");
    check_base_class_offset(lv, (A0*), ABISELECT(8,4), "C12");
    check_base_class_offset(lv, (B1*), ABISELECT(16,12), "C12");
    check_field_offset(lv, fc, ABISELECT(12,8), "C12.fc");
    test_class_info(&lv, &cd_C12);
    dp->~C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC12(Test_C12, "C12", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C12C1Ev();
extern void _ZN3C12D1Ev();
Name_Map name_map_C12[] = {
  NSPAIR(_ZN3C12C1Ev),
  NSPAIR(_ZN3C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C12[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C12[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTV3C12[];
static  VTT_ENTRY vtt_C12[] = {
  {&(_ZTV3C12[3]),  3,7},
  {&(_ZTV3C12[6]),  6,7},
};
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
Class_Descriptor cd_C12 = {  "C12", // class name
  bases_C12, 2,
  &(vtc_C12[0]), // expected_vtbl_contents
  &(vtt_C12[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C12),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C13  : A1 , virtual B1 {
  int fc;
  ~C13(); // tgen
  C13(); // tgen
};
//SIG(-1 C13) C1{ BC2{ v1 Fi} VBC3{ v2 Fi} Fi}


C13 ::~C13(){ note_dtor("C13", this);} // tgen
C13 ::C13(){ note_ctor("C13", this);} // tgen

static void Test_C13()
{
  extern Class_Descriptor cd_C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C13, buf);
    C13 *dp, &lv = *(dp=new (buf) C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C13)");
    check_base_class_offset(lv, (A1*), 0, "C13");
    check_base_class_offset(lv, (B1*), ABISELECT(16,12), "C13");
    check_field_offset(lv, fc, ABISELECT(12,8), "C13.fc");
    test_class_info(&lv, &cd_C13);
    dp->~C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC13(Test_C13, "C13", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C13C1Ev();
extern void _ZN3C13D1Ev();
Name_Map name_map_C13[] = {
  NSPAIR(_ZN3C13C1Ev),
  NSPAIR(_ZN3C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C13[];
extern void _ZN2A13fooEv();
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C13[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTV3C13[];
static  VTT_ENTRY vtt_C13[] = {
  {&(_ZTV3C13[3]),  3,8},
  {&(_ZTV3C13[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
Class_Descriptor cd_C13 = {  "C13", // class name
  bases_C13, 2,
  &(vtc_C13[0]), // expected_vtbl_contents
  &(vtt_C13[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C13),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C13),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C14  : virtual A0 , virtual B1 {
  int fc;
  ~C14(); // tgen
  C14(); // tgen
};
//SIG(-1 C14) C1{ VBC2{ Fi} VBC3{ v1 Fi} Fi}


C14 ::~C14(){ note_dtor("C14", this);} // tgen
C14 ::C14(){ note_ctor("C14", this);} // tgen

static void Test_C14()
{
  extern Class_Descriptor cd_C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C14, buf);
    C14 *dp, &lv = *(dp=new (buf) C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C14)");
    check_base_class_offset(lv, (A0*), ABISELECT(12,8), "C14");
    check_base_class_offset(lv, (B1*), ABISELECT(16,12), "C14");
    check_field_offset(lv, fc, ABISELECT(8,4), "C14.fc");
    test_class_info(&lv, &cd_C14);
    dp->~C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC14(Test_C14, "C14", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C14C1Ev();
extern void _ZN3C14D1Ev();
Name_Map name_map_C14[] = {
  NSPAIR(_ZN3C14C1Ev),
  NSPAIR(_ZN3C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C14[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C14[] = {
  ABISELECT(16,12),
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTV3C14[];
static  VTT_ENTRY vtt_C14[] = {
  {&(_ZTV3C14[4]),  4,8},
  {&(_ZTV3C14[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
Class_Descriptor cd_C14 = {  "C14", // class name
  bases_C14, 2,
  &(vtc_C14[0]), // expected_vtbl_contents
  &(vtt_C14[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C14),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C14),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C15  : virtual A1 , virtual B1 {
  int fc;
  ~C15(); // tgen
  C15(); // tgen
};
//SIG(-1 C15) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} Fi}


C15 ::~C15(){ note_dtor("C15", this);} // tgen
C15 ::C15(){ note_ctor("C15", this);} // tgen

static void Test_C15()
{
  extern Class_Descriptor cd_C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_C15, buf);
    C15 *dp, &lv = *(dp=new (buf) C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C15)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,8), "C15");
    check_base_class_offset(lv, (B1*), ABISELECT(32,16), "C15");
    check_field_offset(lv, fc, ABISELECT(8,4), "C15.fc");
    test_class_info(&lv, &cd_C15);
    dp->~C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC15(Test_C15, "C15", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN3C15C1Ev();
extern void _ZN3C15D1Ev();
Name_Map name_map_C15[] = {
  NSPAIR(_ZN3C15C1Ev),
  NSPAIR(_ZN3C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C15[];
extern void _ZN2A13fooEv();
extern void _ZN2B13fooEv();
static  VTBL_ENTRY vtc_C15[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern VTBL_ENTRY _ZTV3C15[];
static  VTT_ENTRY vtt_C15[] = {
  {&(_ZTV3C15[4]),  4,12},
  {&(_ZTV3C15[7]),  7,12},
  {&(_ZTV3C15[11]),  11,12},
};
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
Class_Descriptor cd_C15 = {  "C15", // class name
  bases_C15, 2,
  &(vtc_C15[0]), // expected_vtbl_contents
  &(vtt_C15[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI3C15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C15),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C15),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C16  : A0 , B0 {
  int fc;
  virtual void  foo(); // _ZN3C163fooEv
  ~C16(); // tgen
  C16(); // tgen
};
//SIG(-1 C16) C1{ BC2{ Fi} BC3{ Fi} v1 Fi}


void  C16 ::foo(){vfunc_called(this, "_ZN3C163fooEv");}
C16 ::~C16(){ note_dtor("C16", this);} // tgen
C16 ::C16(){ note_ctor("C16", this);} // tgen

static void Test_C16()
{
  extern Class_Descriptor cd_C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C16, buf);
    C16 *dp, &lv = *(dp=new (buf) C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C16)");
    check_base_class_offset(lv, (A0*), ABISELECT(8,4), "C16");
    check_base_class_offset(lv, (B0*), ABISELECT(12,8), "C16");
    check_field_offset(lv, fc, ABISELECT(16,12), "C16.fc");
    test_class_info(&lv, &cd_C16);
    dp->~C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC16(Test_C16, "C16", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C16C1Ev();
extern void _ZN3C16D1Ev();
Name_Map name_map_C16[] = {
  NSPAIR(_ZN3C16C1Ev),
  NSPAIR(_ZN3C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C16[];
extern void _ZN3C163fooEv();
static  VTBL_ENTRY vtc_C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3C16[0]),
  (VTBL_ENTRY)&_ZN3C163fooEv,
};
extern VTBL_ENTRY _ZTI3C16[];
extern  VTBL_ENTRY _ZTV3C16[];
Class_Descriptor cd_C16 = {  "C16", // class name
  bases_C16, 2,
  &(vtc_C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C16),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C17  : A1 , B0 {
  int fc;
  virtual void  foo(); // _ZN3C173fooEv
  ~C17(); // tgen
  C17(); // tgen
};
//SIG(-1 C17) C1{ BC2{ v1 Fi} BC3{ Fi} v1 Fi}


void  C17 ::foo(){vfunc_called(this, "_ZN3C173fooEv");}
C17 ::~C17(){ note_dtor("C17", this);} // tgen
C17 ::C17(){ note_ctor("C17", this);} // tgen

static void Test_C17()
{
  extern Class_Descriptor cd_C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C17, buf);
    C17 *dp, &lv = *(dp=new (buf) C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C17)");
    check_base_class_offset(lv, (A1*), 0, "C17");
    check_base_class_offset(lv, (B0*), ABISELECT(12,8), "C17");
    check_field_offset(lv, fc, ABISELECT(16,12), "C17.fc");
    test_class_info(&lv, &cd_C17);
    dp->~C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC17(Test_C17, "C17", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C17C1Ev();
extern void _ZN3C17D1Ev();
Name_Map name_map_C17[] = {
  NSPAIR(_ZN3C17C1Ev),
  NSPAIR(_ZN3C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C17[];
extern void _ZN3C173fooEv();
static  VTBL_ENTRY vtc_C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3C17[0]),
  (VTBL_ENTRY)&_ZN3C173fooEv,
};
extern VTBL_ENTRY _ZTI3C17[];
extern  VTBL_ENTRY _ZTV3C17[];
Class_Descriptor cd_C17 = {  "C17", // class name
  bases_C17, 2,
  &(vtc_C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C17),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C18  : virtual A0 , B0 {
  int fc;
  virtual void  foo(); // _ZN3C183fooEv
  ~C18(); // tgen
  C18(); // tgen
};
//SIG(-1 C18) C1{ VBC2{ Fi} BC3{ Fi} v1 Fi}


void  C18 ::foo(){vfunc_called(this, "_ZN3C183fooEv");}
C18 ::~C18(){ note_dtor("C18", this);} // tgen
C18 ::C18(){ note_ctor("C18", this);} // tgen

static void Test_C18()
{
  extern Class_Descriptor cd_C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C18, buf);
    C18 *dp, &lv = *(dp=new (buf) C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C18)");
    check_base_class_offset(lv, (A0*), ABISELECT(16,12), "C18");
    check_base_class_offset(lv, (B0*), ABISELECT(8,4), "C18");
    check_field_offset(lv, fc, ABISELECT(12,8), "C18.fc");
    test_class_info(&lv, &cd_C18);
    dp->~C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC18(Test_C18, "C18", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C18C1Ev();
extern void _ZN3C18D1Ev();
Name_Map name_map_C18[] = {
  NSPAIR(_ZN3C18C1Ev),
  NSPAIR(_ZN3C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C18[];
extern void _ZN3C183fooEv();
static  VTBL_ENTRY vtc_C18[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C18[0]),
  (VTBL_ENTRY)&_ZN3C183fooEv,
};
extern VTBL_ENTRY _ZTV3C18[];
static  VTT_ENTRY vtt_C18[] = {
  {&(_ZTV3C18[3]),  3,4},
};
extern VTBL_ENTRY _ZTI3C18[];
extern  VTBL_ENTRY _ZTV3C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C18[];
Class_Descriptor cd_C18 = {  "C18", // class name
  bases_C18, 2,
  &(vtc_C18[0]), // expected_vtbl_contents
  &(vtt_C18[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C18),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C18),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C19  : virtual A1 , B0 {
  int fc;
  virtual void  foo(); // _ZN3C193fooEv
  ~C19(); // tgen
  C19(); // tgen
};
//SIG(-1 C19) C1{ VBC2{ v1 Fi} BC3{ Fi} v1 Fi}


void  C19 ::foo(){vfunc_called(this, "_ZN3C193fooEv");}
C19 ::~C19(){ note_dtor("C19", this);} // tgen
C19 ::C19(){ note_ctor("C19", this);} // tgen

static void Test_C19()
{
  extern Class_Descriptor cd_C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C19, buf);
    C19 *dp, &lv = *(dp=new (buf) C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C19)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,12), "C19");
    check_base_class_offset(lv, (B0*), ABISELECT(8,4), "C19");
    check_field_offset(lv, fc, ABISELECT(12,8), "C19.fc");
    test_class_info(&lv, &cd_C19);
    dp->~C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC19(Test_C19, "C19", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C19C1Ev();
extern void _ZN3C19D1Ev();
Name_Map name_map_C19[] = {
  NSPAIR(_ZN3C19C1Ev),
  NSPAIR(_ZN3C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C19[];
extern void _ZN3C193fooEv();
extern void ABISELECT(_ZTv0_n24_N3C193fooEv,_ZTv0_n12_N3C193fooEv)();
extern void ABISELECT(_ZThn16_N3C193fooEv,_ZThn12_N3C193fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C19[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C19[0]),
  (VTBL_ENTRY)&_ZN3C193fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C193fooEv,_ZTv0_n12_N3C193fooEv),
};
extern VTBL_ENTRY _ZTV3C19[];
static  VTT_ENTRY vtt_C19[] = {
  {&(_ZTV3C19[3]),  3,8},
  {&(_ZTV3C19[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C19[];
extern  VTBL_ENTRY _ZTV3C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C19[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C193fooEv,_ZTv0_n12_N3C193fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C193fooEv,_ZThn12_N3C193fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C19 = {  "C19", // class name
  bases_C19, 2,
  &(vtc_C19[0]), // expected_vtbl_contents
  &(vtt_C19[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C19),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C19),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C19),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C20  : A0 , B1 {
  int fc;
  virtual void  foo(); // _ZN3C203fooEv
  ~C20(); // tgen
  C20(); // tgen
};
//SIG(-1 C20) C1{ BC2{ Fi} BC3{ v1 Fi} v1 Fi}


void  C20 ::foo(){vfunc_called(this, "_ZN3C203fooEv");}
C20 ::~C20(){ note_dtor("C20", this);} // tgen
C20 ::C20(){ note_ctor("C20", this);} // tgen

static void Test_C20()
{
  extern Class_Descriptor cd_C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C20, buf);
    C20 *dp, &lv = *(dp=new (buf) C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C20)");
    check_base_class_offset(lv, (A0*), ABISELECT(12,8), "C20");
    check_base_class_offset(lv, (B1*), 0, "C20");
    check_field_offset(lv, fc, ABISELECT(16,12), "C20.fc");
    test_class_info(&lv, &cd_C20);
    dp->~C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC20(Test_C20, "C20", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C20C1Ev();
extern void _ZN3C20D1Ev();
Name_Map name_map_C20[] = {
  NSPAIR(_ZN3C20C1Ev),
  NSPAIR(_ZN3C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C20[];
extern void _ZN3C203fooEv();
static  VTBL_ENTRY vtc_C20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3C20[0]),
  (VTBL_ENTRY)&_ZN3C203fooEv,
};
extern VTBL_ENTRY _ZTI3C20[];
extern  VTBL_ENTRY _ZTV3C20[];
Class_Descriptor cd_C20 = {  "C20", // class name
  bases_C20, 2,
  &(vtc_C20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C20),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C21  : A1 , B1 {
  int fc;
  virtual void  foo(); // _ZN3C213fooEv
  ~C21(); // tgen
  C21(); // tgen
};
//SIG(-1 C21) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


void  C21 ::foo(){vfunc_called(this, "_ZN3C213fooEv");}
C21 ::~C21(){ note_dtor("C21", this);} // tgen
C21 ::C21(){ note_ctor("C21", this);} // tgen

static void Test_C21()
{
  extern Class_Descriptor cd_C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C21, buf);
    C21 *dp, &lv = *(dp=new (buf) C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C21)");
    check_base_class_offset(lv, (A1*), 0, "C21");
    check_base_class_offset(lv, (B1*), ABISELECT(16,8), "C21");
    check_field_offset(lv, fc, ABISELECT(28,16), "C21.fc");
    test_class_info(&lv, &cd_C21);
    dp->~C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC21(Test_C21, "C21", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C21C1Ev();
extern void _ZN3C21D1Ev();
Name_Map name_map_C21[] = {
  NSPAIR(_ZN3C21C1Ev),
  NSPAIR(_ZN3C21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C21[];
extern void _ZN3C213fooEv();
extern void ABISELECT(_ZThn16_N3C213fooEv,_ZThn8_N3C213fooEv)();
static  VTBL_ENTRY vtc_C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3C21[0]),
  (VTBL_ENTRY)&_ZN3C213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3C213fooEv,_ZThn8_N3C213fooEv),
};
extern VTBL_ENTRY _ZTI3C21[];
extern  VTBL_ENTRY _ZTV3C21[];
Class_Descriptor cd_C21 = {  "C21", // class name
  bases_C21, 2,
  &(vtc_C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C21),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C22  : virtual A0 , B1 {
  int fc;
  virtual void  foo(); // _ZN3C223fooEv
  ~C22(); // tgen
  C22(); // tgen
};
//SIG(-1 C22) C1{ VBC2{ Fi} BC3{ v1 Fi} v1 Fi}


void  C22 ::foo(){vfunc_called(this, "_ZN3C223fooEv");}
C22 ::~C22(){ note_dtor("C22", this);} // tgen
C22 ::C22(){ note_ctor("C22", this);} // tgen

static void Test_C22()
{
  extern Class_Descriptor cd_C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C22, buf);
    C22 *dp, &lv = *(dp=new (buf) C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C22)");
    check_base_class_offset(lv, (A0*), ABISELECT(16,12), "C22");
    check_base_class_offset(lv, (B1*), 0, "C22");
    check_field_offset(lv, fc, ABISELECT(12,8), "C22.fc");
    test_class_info(&lv, &cd_C22);
    dp->~C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC22(Test_C22, "C22", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C22C1Ev();
extern void _ZN3C22D1Ev();
Name_Map name_map_C22[] = {
  NSPAIR(_ZN3C22C1Ev),
  NSPAIR(_ZN3C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C22[];
extern void _ZN3C223fooEv();
static  VTBL_ENTRY vtc_C22[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C22[0]),
  (VTBL_ENTRY)&_ZN3C223fooEv,
};
extern VTBL_ENTRY _ZTV3C22[];
static  VTT_ENTRY vtt_C22[] = {
  {&(_ZTV3C22[3]),  3,4},
};
extern VTBL_ENTRY _ZTI3C22[];
extern  VTBL_ENTRY _ZTV3C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C22[];
Class_Descriptor cd_C22 = {  "C22", // class name
  bases_C22, 2,
  &(vtc_C22[0]), // expected_vtbl_contents
  &(vtt_C22[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C22),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C22),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C23  : virtual A1 , B1 {
  int fc;
  virtual void  foo(); // _ZN3C233fooEv
  ~C23(); // tgen
  C23(); // tgen
};
//SIG(-1 C23) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


void  C23 ::foo(){vfunc_called(this, "_ZN3C233fooEv");}
C23 ::~C23(){ note_dtor("C23", this);} // tgen
C23 ::C23(){ note_ctor("C23", this);} // tgen

static void Test_C23()
{
  extern Class_Descriptor cd_C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C23, buf);
    C23 *dp, &lv = *(dp=new (buf) C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C23)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,12), "C23");
    check_base_class_offset(lv, (B1*), 0, "C23");
    check_field_offset(lv, fc, ABISELECT(12,8), "C23.fc");
    test_class_info(&lv, &cd_C23);
    dp->~C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC23(Test_C23, "C23", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C23C1Ev();
extern void _ZN3C23D1Ev();
Name_Map name_map_C23[] = {
  NSPAIR(_ZN3C23C1Ev),
  NSPAIR(_ZN3C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3C23[];
extern void _ZN3C233fooEv();
extern void ABISELECT(_ZTv0_n24_N3C233fooEv,_ZTv0_n12_N3C233fooEv)();
extern void ABISELECT(_ZThn16_N3C233fooEv,_ZThn12_N3C233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C23[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C23[0]),
  (VTBL_ENTRY)&_ZN3C233fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C233fooEv,_ZTv0_n12_N3C233fooEv),
};
extern VTBL_ENTRY _ZTV3C23[];
static  VTT_ENTRY vtt_C23[] = {
  {&(_ZTV3C23[3]),  3,8},
  {&(_ZTV3C23[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C23[];
extern  VTBL_ENTRY _ZTV3C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C23[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C233fooEv,_ZTv0_n12_N3C233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C233fooEv,_ZThn12_N3C233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C23 = {  "C23", // class name
  bases_C23, 2,
  &(vtc_C23[0]), // expected_vtbl_contents
  &(vtt_C23[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C23),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C23),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C24  : A0 , virtual B0 {
  int fc;
  virtual void  foo(); // _ZN3C243fooEv
  ~C24(); // tgen
  C24(); // tgen
};
//SIG(-1 C24) C1{ BC2{ Fi} VBC3{ Fi} v1 Fi}


void  C24 ::foo(){vfunc_called(this, "_ZN3C243fooEv");}
C24 ::~C24(){ note_dtor("C24", this);} // tgen
C24 ::C24(){ note_ctor("C24", this);} // tgen

static void Test_C24()
{
  extern Class_Descriptor cd_C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C24, buf);
    C24 *dp, &lv = *(dp=new (buf) C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C24)");
    check_base_class_offset(lv, (A0*), ABISELECT(8,4), "C24");
    check_base_class_offset(lv, (B0*), ABISELECT(16,12), "C24");
    check_field_offset(lv, fc, ABISELECT(12,8), "C24.fc");
    test_class_info(&lv, &cd_C24);
    dp->~C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC24(Test_C24, "C24", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C24C1Ev();
extern void _ZN3C24D1Ev();
Name_Map name_map_C24[] = {
  NSPAIR(_ZN3C24C1Ev),
  NSPAIR(_ZN3C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C24[];
extern void _ZN3C243fooEv();
static  VTBL_ENTRY vtc_C24[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C24[0]),
  (VTBL_ENTRY)&_ZN3C243fooEv,
};
extern VTBL_ENTRY _ZTV3C24[];
static  VTT_ENTRY vtt_C24[] = {
  {&(_ZTV3C24[3]),  3,4},
};
extern VTBL_ENTRY _ZTI3C24[];
extern  VTBL_ENTRY _ZTV3C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C24[];
Class_Descriptor cd_C24 = {  "C24", // class name
  bases_C24, 2,
  &(vtc_C24[0]), // expected_vtbl_contents
  &(vtt_C24[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C24),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C24),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C25  : A1 , virtual B0 {
  int fc;
  virtual void  foo(); // _ZN3C253fooEv
  ~C25(); // tgen
  C25(); // tgen
};
//SIG(-1 C25) C1{ BC2{ v1 Fi} VBC3{ Fi} v1 Fi}


void  C25 ::foo(){vfunc_called(this, "_ZN3C253fooEv");}
C25 ::~C25(){ note_dtor("C25", this);} // tgen
C25 ::C25(){ note_ctor("C25", this);} // tgen

static void Test_C25()
{
  extern Class_Descriptor cd_C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C25, buf);
    C25 *dp, &lv = *(dp=new (buf) C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C25)");
    check_base_class_offset(lv, (A1*), 0, "C25");
    check_base_class_offset(lv, (B0*), ABISELECT(16,12), "C25");
    check_field_offset(lv, fc, ABISELECT(12,8), "C25.fc");
    test_class_info(&lv, &cd_C25);
    dp->~C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC25(Test_C25, "C25", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C25C1Ev();
extern void _ZN3C25D1Ev();
Name_Map name_map_C25[] = {
  NSPAIR(_ZN3C25C1Ev),
  NSPAIR(_ZN3C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C25[];
extern void _ZN3C253fooEv();
static  VTBL_ENTRY vtc_C25[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C25[0]),
  (VTBL_ENTRY)&_ZN3C253fooEv,
};
extern VTBL_ENTRY _ZTV3C25[];
static  VTT_ENTRY vtt_C25[] = {
  {&(_ZTV3C25[3]),  3,4},
};
extern VTBL_ENTRY _ZTI3C25[];
extern  VTBL_ENTRY _ZTV3C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C25[];
Class_Descriptor cd_C25 = {  "C25", // class name
  bases_C25, 2,
  &(vtc_C25[0]), // expected_vtbl_contents
  &(vtt_C25[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C25),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C25),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C26  : virtual A0 , virtual B0 {
  int fc;
  virtual void  foo(); // _ZN3C263fooEv
  ~C26(); // tgen
  C26(); // tgen
};
//SIG(-1 C26) C1{ VBC2{ Fi} VBC3{ Fi} v1 Fi}


void  C26 ::foo(){vfunc_called(this, "_ZN3C263fooEv");}
C26 ::~C26(){ note_dtor("C26", this);} // tgen
C26 ::C26(){ note_ctor("C26", this);} // tgen

static void Test_C26()
{
  extern Class_Descriptor cd_C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_C26, buf);
    C26 *dp, &lv = *(dp=new (buf) C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C26)");
    check_base_class_offset(lv, (A0*), ABISELECT(12,8), "C26");
    check_base_class_offset(lv, (B0*), ABISELECT(16,12), "C26");
    check_field_offset(lv, fc, ABISELECT(8,4), "C26.fc");
    test_class_info(&lv, &cd_C26);
    dp->~C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC26(Test_C26, "C26", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN3C26C1Ev();
extern void _ZN3C26D1Ev();
Name_Map name_map_C26[] = {
  NSPAIR(_ZN3C26C1Ev),
  NSPAIR(_ZN3C26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C26[];
extern void _ZN3C263fooEv();
static  VTBL_ENTRY vtc_C26[] = {
  ABISELECT(16,12),
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C26[0]),
  (VTBL_ENTRY)&_ZN3C263fooEv,
};
extern VTBL_ENTRY _ZTV3C26[];
static  VTT_ENTRY vtt_C26[] = {
  {&(_ZTV3C26[4]),  4,5},
};
extern VTBL_ENTRY _ZTI3C26[];
extern  VTBL_ENTRY _ZTV3C26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C26[];
Class_Descriptor cd_C26 = {  "C26", // class name
  bases_C26, 2,
  &(vtc_C26[0]), // expected_vtbl_contents
  &(vtt_C26[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI3C26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C26),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C26),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C27  : virtual A1 , virtual B0 {
  int fc;
  virtual void  foo(); // _ZN3C273fooEv
  ~C27(); // tgen
  C27(); // tgen
};
//SIG(-1 C27) C1{ VBC2{ v1 Fi} VBC3{ Fi} v1 Fi}


void  C27 ::foo(){vfunc_called(this, "_ZN3C273fooEv");}
C27 ::~C27(){ note_dtor("C27", this);} // tgen
C27 ::C27(){ note_ctor("C27", this);} // tgen

static void Test_C27()
{
  extern Class_Descriptor cd_C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C27, buf);
    C27 *dp, &lv = *(dp=new (buf) C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C27)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,8), "C27");
    check_base_class_offset(lv, (B0*), ABISELECT(28,16), "C27");
    check_field_offset(lv, fc, ABISELECT(8,4), "C27.fc");
    test_class_info(&lv, &cd_C27);
    dp->~C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC27(Test_C27, "C27", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C27C1Ev();
extern void _ZN3C27D1Ev();
Name_Map name_map_C27[] = {
  NSPAIR(_ZN3C27C1Ev),
  NSPAIR(_ZN3C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
static Base_Class bases_C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C27[];
extern void _ZN3C273fooEv();
extern void ABISELECT(_ZTv0_n24_N3C273fooEv,_ZTv0_n12_N3C273fooEv)();
extern void ABISELECT(_ZThn16_N3C273fooEv,_ZThn8_N3C273fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C27[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C27[0]),
  (VTBL_ENTRY)&_ZN3C273fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3C27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C273fooEv,_ZTv0_n12_N3C273fooEv),
};
extern VTBL_ENTRY _ZTV3C27[];
static  VTT_ENTRY vtt_C27[] = {
  {&(_ZTV3C27[4]),  4,9},
  {&(_ZTV3C27[8]),  8,9},
};
extern VTBL_ENTRY _ZTI3C27[];
extern  VTBL_ENTRY _ZTV3C27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C27[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C273fooEv,_ZTv0_n12_N3C273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C273fooEv,_ZThn8_N3C273fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C27 = {  "C27", // class name
  bases_C27, 2,
  &(vtc_C27[0]), // expected_vtbl_contents
  &(vtt_C27[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C27),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C27),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C27),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C28  : A0 , virtual B1 {
  int fc;
  virtual void  foo(); // _ZN3C283fooEv
  ~C28(); // tgen
  C28(); // tgen
};
//SIG(-1 C28) C1{ BC2{ Fi} VBC3{ v1 Fi} v1 Fi}


void  C28 ::foo(){vfunc_called(this, "_ZN3C283fooEv");}
C28 ::~C28(){ note_dtor("C28", this);} // tgen
C28 ::C28(){ note_ctor("C28", this);} // tgen

static void Test_C28()
{
  extern Class_Descriptor cd_C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C28, buf);
    C28 *dp, &lv = *(dp=new (buf) C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C28)");
    check_base_class_offset(lv, (A0*), ABISELECT(8,4), "C28");
    check_base_class_offset(lv, (B1*), ABISELECT(16,12), "C28");
    check_field_offset(lv, fc, ABISELECT(12,8), "C28.fc");
    test_class_info(&lv, &cd_C28);
    dp->~C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC28(Test_C28, "C28", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C28C1Ev();
extern void _ZN3C28D1Ev();
Name_Map name_map_C28[] = {
  NSPAIR(_ZN3C28C1Ev),
  NSPAIR(_ZN3C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C28[];
extern void _ZN3C283fooEv();
extern void ABISELECT(_ZTv0_n24_N3C283fooEv,_ZTv0_n12_N3C283fooEv)();
extern void ABISELECT(_ZThn16_N3C283fooEv,_ZThn12_N3C283fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C28[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C28[0]),
  (VTBL_ENTRY)&_ZN3C283fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C283fooEv,_ZTv0_n12_N3C283fooEv),
};
extern VTBL_ENTRY _ZTV3C28[];
static  VTT_ENTRY vtt_C28[] = {
  {&(_ZTV3C28[3]),  3,8},
  {&(_ZTV3C28[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C28[];
extern  VTBL_ENTRY _ZTV3C28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C28[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C283fooEv,_ZTv0_n12_N3C283fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C283fooEv,_ZThn12_N3C283fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C28 = {  "C28", // class name
  bases_C28, 2,
  &(vtc_C28[0]), // expected_vtbl_contents
  &(vtt_C28[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C28),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C28),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C29  : A1 , virtual B1 {
  int fc;
  virtual void  foo(); // _ZN3C293fooEv
  ~C29(); // tgen
  C29(); // tgen
};
//SIG(-1 C29) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  C29 ::foo(){vfunc_called(this, "_ZN3C293fooEv");}
C29 ::~C29(){ note_dtor("C29", this);} // tgen
C29 ::C29(){ note_ctor("C29", this);} // tgen

static void Test_C29()
{
  extern Class_Descriptor cd_C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C29, buf);
    C29 *dp, &lv = *(dp=new (buf) C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C29)");
    check_base_class_offset(lv, (A1*), 0, "C29");
    check_base_class_offset(lv, (B1*), ABISELECT(16,12), "C29");
    check_field_offset(lv, fc, ABISELECT(12,8), "C29.fc");
    test_class_info(&lv, &cd_C29);
    dp->~C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC29(Test_C29, "C29", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C29C1Ev();
extern void _ZN3C29D1Ev();
Name_Map name_map_C29[] = {
  NSPAIR(_ZN3C29C1Ev),
  NSPAIR(_ZN3C29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C29[];
extern void _ZN3C293fooEv();
extern void ABISELECT(_ZTv0_n24_N3C293fooEv,_ZTv0_n12_N3C293fooEv)();
extern void ABISELECT(_ZThn16_N3C293fooEv,_ZThn12_N3C293fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C29[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3C29[0]),
  (VTBL_ENTRY)&_ZN3C293fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C293fooEv,_ZTv0_n12_N3C293fooEv),
};
extern VTBL_ENTRY _ZTV3C29[];
static  VTT_ENTRY vtt_C29[] = {
  {&(_ZTV3C29[3]),  3,8},
  {&(_ZTV3C29[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3C29[];
extern  VTBL_ENTRY _ZTV3C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C29[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C293fooEv,_ZTv0_n12_N3C293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C293fooEv,_ZThn12_N3C293fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C29 = {  "C29", // class name
  bases_C29, 2,
  &(vtc_C29[0]), // expected_vtbl_contents
  &(vtt_C29[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C29),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C29),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C29),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C30  : virtual A0 , virtual B1 {
  int fc;
  virtual void  foo(); // _ZN3C303fooEv
  ~C30(); // tgen
  C30(); // tgen
};
//SIG(-1 C30) C1{ VBC2{ Fi} VBC3{ v1 Fi} v1 Fi}


void  C30 ::foo(){vfunc_called(this, "_ZN3C303fooEv");}
C30 ::~C30(){ note_dtor("C30", this);} // tgen
C30 ::C30(){ note_ctor("C30", this);} // tgen

static void Test_C30()
{
  extern Class_Descriptor cd_C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_C30, buf);
    C30 *dp, &lv = *(dp=new (buf) C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C30)");
    check_base_class_offset(lv, (A0*), ABISELECT(12,8), "C30");
    check_base_class_offset(lv, (B1*), ABISELECT(16,12), "C30");
    check_field_offset(lv, fc, ABISELECT(8,4), "C30.fc");
    test_class_info(&lv, &cd_C30);
    dp->~C30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC30(Test_C30, "C30", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3C30C1Ev();
extern void _ZN3C30D1Ev();
Name_Map name_map_C30[] = {
  NSPAIR(_ZN3C30C1Ev),
  NSPAIR(_ZN3C30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C30[];
extern void _ZN3C303fooEv();
extern void ABISELECT(_ZTv0_n24_N3C303fooEv,_ZTv0_n12_N3C303fooEv)();
extern void ABISELECT(_ZThn16_N3C303fooEv,_ZThn12_N3C303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C30[] = {
  ABISELECT(16,12),
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C30[0]),
  (VTBL_ENTRY)&_ZN3C303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3C30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C303fooEv,_ZTv0_n12_N3C303fooEv),
};
extern VTBL_ENTRY _ZTV3C30[];
static  VTT_ENTRY vtt_C30[] = {
  {&(_ZTV3C30[4]),  4,9},
  {&(_ZTV3C30[8]),  8,9},
};
extern VTBL_ENTRY _ZTI3C30[];
extern  VTBL_ENTRY _ZTV3C30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C30[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C303fooEv,_ZTv0_n12_N3C303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C303fooEv,_ZThn12_N3C303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C30 = {  "C30", // class name
  bases_C30, 2,
  &(vtc_C30[0]), // expected_vtbl_contents
  &(vtt_C30[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3C30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C30),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C30),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C31  : virtual A1 , virtual B1 {
  int fc;
  virtual void  foo(); // _ZN3C313fooEv
  ~C31(); // tgen
  C31(); // tgen
};
//SIG(-1 C31) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  C31 ::foo(){vfunc_called(this, "_ZN3C313fooEv");}
C31 ::~C31(){ note_dtor("C31", this);} // tgen
C31 ::C31(){ note_ctor("C31", this);} // tgen

static void Test_C31()
{
  extern Class_Descriptor cd_C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_C31, buf);
    C31 *dp, &lv = *(dp=new (buf) C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C31)");
    check_base_class_offset(lv, (A1*), ABISELECT(16,8), "C31");
    check_base_class_offset(lv, (B1*), ABISELECT(32,16), "C31");
    check_field_offset(lv, fc, ABISELECT(8,4), "C31.fc");
    test_class_info(&lv, &cd_C31);
    dp->~C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vC31(Test_C31, "C31", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN3C31C1Ev();
extern void _ZN3C31D1Ev();
Name_Map name_map_C31[] = {
  NSPAIR(_ZN3C31C1Ev),
  NSPAIR(_ZN3C31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
static Base_Class bases_C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_B1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3C31[];
extern void _ZN3C313fooEv();
extern void ABISELECT(_ZTv0_n24_N3C313fooEv,_ZTv0_n12_N3C313fooEv)();
extern void ABISELECT(_ZThn16_N3C313fooEv,_ZThn8_N3C313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3C313fooEv,_ZTv0_n12_N3C313fooEv)();
extern void ABISELECT(_ZThn32_N3C313fooEv,_ZThn16_N3C313fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_C31[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3C31[0]),
  (VTBL_ENTRY)&_ZN3C313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3C31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C313fooEv,_ZTv0_n12_N3C313fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI3C31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3C313fooEv,_ZTv0_n12_N3C313fooEv),
};
extern VTBL_ENTRY _ZTV3C31[];
static  VTT_ENTRY vtt_C31[] = {
  {&(_ZTV3C31[4]),  4,13},
  {&(_ZTV3C31[8]),  8,13},
  {&(_ZTV3C31[12]),  12,13},
};
extern VTBL_ENTRY _ZTI3C31[];
extern  VTBL_ENTRY _ZTV3C31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C31[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3C313fooEv,_ZTv0_n12_N3C313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N3C313fooEv,_ZThn16_N3C313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3C313fooEv,_ZThn8_N3C313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_C31 = {  "C31", // class name
  bases_C31, 2,
  &(vtc_C31[0]), // expected_vtbl_contents
  &(vtt_C31[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI3C31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3C31),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3C31),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E0x12  : C0 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E0x123fooEv
  ~E0x12(); // tgen
  E0x12(); // tgen
};
//SIG(-1 E0x12) C1{ BC2{ BC3{ Fi} BC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E0x12 ::foo(){vfunc_called(this, "_ZN5E0x123fooEv");}
E0x12 ::~E0x12(){ note_dtor("E0x12", this);} // tgen
E0x12 ::E0x12(){ note_ctor("E0x12", this);} // tgen

static void Test_E0x12()
{
  extern Class_Descriptor cd_E0x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E0x12, buf);
    E0x12 *dp, &lv = *(dp=new (buf) E0x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E0x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E0x12)");
    check_base_class_offset(lv, (A0*)(C0*), ABISELECT(8,4), "E0x12");
    check_base_class_offset(lv, (B0*)(C0*), ABISELECT(12,8), "E0x12");
    check_base_class_offset(lv, (C0*), ABISELECT(8,4), "E0x12");
    check_base_class_offset(lv, (D0*), ABISELECT(20,16), "E0x12");
    check_field_offset(lv, fd, ABISELECT(24,20), "E0x12.fd");
    test_class_info(&lv, &cd_E0x12);
    dp->~E0x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE0x12(Test_E0x12, "E0x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E0x12C1Ev();
extern void _ZN5E0x12D1Ev();
Name_Map name_map_E0x12[] = {
  NSPAIR(_ZN5E0x12C1Ev),
  NSPAIR(_ZN5E0x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E0x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E0x12[];
extern void _ZN5E0x123fooEv();
static  VTBL_ENTRY vtc_E0x12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5E0x12[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
};
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
Class_Descriptor cd_E0x12 = {  "E0x12", // class name
  bases_E0x12, 4,
  &(vtc_E0x12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E0x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E0x12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y0  : E0x12 , F1 {
  int ff;
  ~G0x12y0(); // tgen
  G0x12y0(); // tgen
};
//SIG(1 G0x12y0) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G0x12y0 ::~G0x12y0(){ note_dtor("G0x12y0", this);} // tgen
G0x12y0 ::G0x12y0(){ note_ctor("G0x12y0", this);} // tgen

static void Test_G0x12y0()
{
  extern Class_Descriptor cd_G0x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G0x12y0, buf);
    G0x12y0 *dp, &lv = *(dp=new (buf) G0x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G0x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y0)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(8,4), "G0x12y0");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(12,8), "G0x12y0");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(8,4), "G0x12y0");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(20,16), "G0x12y0");
    check_base_class_offset(lv, (E0x12*), 0, "G0x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(32,24), "G0x12y0");
    check_field_offset(lv, ff, ABISELECT(44,32), "G0x12y0.ff");
    test_class_info(&lv, &cd_G0x12y0);
    dp->~G0x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y0(Test_G0x12y0, "G0x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G0x12y0C1Ev();
extern void _ZN7G0x12y0D1Ev();
Name_Map name_map_G0x12y0[] = {
  NSPAIR(_ZN7G0x12y0C1Ev),
  NSPAIR(_ZN7G0x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G0x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,24), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y0[];
extern void _ZN5E0x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G0x12y0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y0[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G0x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTI7G0x12y0[];
extern  VTBL_ENTRY _ZTV7G0x12y0[];
Class_Descriptor cd_G0x12y0 = {  "G0x12y0", // class name
  bases_G0x12y0, 6,
  &(vtc_G0x12y0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G0x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y0),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y1  : virtual E0x12 , F1 {
  int ff;
  ~G0x12y1(); // tgen
  G0x12y1(); // tgen
};
//SIG(1 G0x12y1) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G0x12y1 ::~G0x12y1(){ note_dtor("G0x12y1", this);} // tgen
G0x12y1 ::G0x12y1(){ note_ctor("G0x12y1", this);} // tgen

static void Test_G0x12y1()
{
  extern Class_Descriptor cd_G0x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G0x12y1, buf);
    G0x12y1 *dp, &lv = *(dp=new (buf) G0x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G0x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y1)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(24,16), "G0x12y1");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(28,20), "G0x12y1");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(24,16), "G0x12y1");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(36,28), "G0x12y1");
    check_base_class_offset(lv, (E0x12*), ABISELECT(16,12), "G0x12y1");
    check_base_class_offset(lv, (F1*), 0, "G0x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G0x12y1.ff");
    test_class_info(&lv, &cd_G0x12y1);
    dp->~G0x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y1(Test_G0x12y1, "G0x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G0x12y1C1Ev();
extern void _ZN7G0x12y1D1Ev();
Name_Map name_map_G0x12y1[] = {
  NSPAIR(_ZN7G0x12y1C1Ev),
  NSPAIR(_ZN7G0x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G0x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E0x123fooEv();
static  VTBL_ENTRY vtc_G0x12y1[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G0x12y1[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
};
extern VTBL_ENTRY _ZTV7G0x12y1[];
static  VTT_ENTRY vtt_G0x12y1[] = {
  {&(_ZTV7G0x12y1[3]),  3,8},
  {&(_ZTV7G0x12y1[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G0x12y1[];
extern  VTBL_ENTRY _ZTV7G0x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G0x12y1[];
Class_Descriptor cd_G0x12y1 = {  "G0x12y1", // class name
  bases_G0x12y1, 6,
  &(vtc_G0x12y1[0]), // expected_vtbl_contents
  &(vtt_G0x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G0x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y1),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G0x12y1),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y2  : E0x12 , virtual F1 {
  int ff;
  ~G0x12y2(); // tgen
  G0x12y2(); // tgen
};
//SIG(1 G0x12y2) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G0x12y2 ::~G0x12y2(){ note_dtor("G0x12y2", this);} // tgen
G0x12y2 ::G0x12y2(){ note_ctor("G0x12y2", this);} // tgen

static void Test_G0x12y2()
{
  extern Class_Descriptor cd_G0x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G0x12y2, buf);
    G0x12y2 *dp, &lv = *(dp=new (buf) G0x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G0x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y2)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(8,4), "G0x12y2");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(12,8), "G0x12y2");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(8,4), "G0x12y2");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(20,16), "G0x12y2");
    check_base_class_offset(lv, (E0x12*), 0, "G0x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G0x12y2");
    check_field_offset(lv, ff, ABISELECT(28,24), "G0x12y2.ff");
    test_class_info(&lv, &cd_G0x12y2);
    dp->~G0x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y2(Test_G0x12y2, "G0x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G0x12y2C1Ev();
extern void _ZN7G0x12y2D1Ev();
Name_Map name_map_G0x12y2[] = {
  NSPAIR(_ZN7G0x12y2C1Ev),
  NSPAIR(_ZN7G0x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G0x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y2[];
extern void _ZN5E0x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G0x12y2[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y2[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G0x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G0x12y2[];
static  VTT_ENTRY vtt_G0x12y2[] = {
  {&(_ZTV7G0x12y2[3]),  3,8},
  {&(_ZTV7G0x12y2[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G0x12y2[];
extern  VTBL_ENTRY _ZTV7G0x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G0x12y2[];
Class_Descriptor cd_G0x12y2 = {  "G0x12y2", // class name
  bases_G0x12y2, 6,
  &(vtc_G0x12y2[0]), // expected_vtbl_contents
  &(vtt_G0x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G0x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y2),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G0x12y2),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y3  : virtual E0x12 , virtual F1 {
  int ff;
  ~G0x12y3(); // tgen
  G0x12y3(); // tgen
};
//SIG(1 G0x12y3) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G0x12y3 ::~G0x12y3(){ note_dtor("G0x12y3", this);} // tgen
G0x12y3 ::G0x12y3(){ note_ctor("G0x12y3", this);} // tgen

static void Test_G0x12y3()
{
  extern Class_Descriptor cd_G0x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G0x12y3, buf);
    G0x12y3 *dp, &lv = *(dp=new (buf) G0x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G0x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y3)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(24,12), "G0x12y3");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(28,16), "G0x12y3");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(24,12), "G0x12y3");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(36,24), "G0x12y3");
    check_base_class_offset(lv, (E0x12*), ABISELECT(16,8), "G0x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G0x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G0x12y3.ff");
    test_class_info(&lv, &cd_G0x12y3);
    dp->~G0x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y3(Test_G0x12y3, "G0x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G0x12y3C1Ev();
extern void _ZN7G0x12y3D1Ev();
Name_Map name_map_G0x12y3[] = {
  NSPAIR(_ZN7G0x12y3C1Ev),
  NSPAIR(_ZN7G0x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G0x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y3[];
extern void _ZN5E0x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G0x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y3[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G0x12y3[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G0x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G0x12y3[];
static  VTT_ENTRY vtt_G0x12y3[] = {
  {&(_ZTV7G0x12y3[4]),  4,12},
  {&(_ZTV7G0x12y3[7]),  7,12},
  {&(_ZTV7G0x12y3[11]),  11,12},
};
extern VTBL_ENTRY _ZTI7G0x12y3[];
extern  VTBL_ENTRY _ZTV7G0x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G0x12y3[];
Class_Descriptor cd_G0x12y3 = {  "G0x12y3", // class name
  bases_G0x12y3, 6,
  &(vtc_G0x12y3[0]), // expected_vtbl_contents
  &(vtt_G0x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G0x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y3),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G0x12y3),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y4  : E0x12 , F0 {
  int ff;
  ~G0x12y4(); // tgen
  G0x12y4(); // tgen
};
//SIG(1 G0x12y4) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G0x12y4 ::~G0x12y4(){ note_dtor("G0x12y4", this);} // tgen
G0x12y4 ::G0x12y4(){ note_ctor("G0x12y4", this);} // tgen

static void Test_G0x12y4()
{
  extern Class_Descriptor cd_G0x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G0x12y4, buf);
    G0x12y4 *dp, &lv = *(dp=new (buf) G0x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G0x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y4)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(8,4), "G0x12y4");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(12,8), "G0x12y4");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(8,4), "G0x12y4");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(20,16), "G0x12y4");
    check_base_class_offset(lv, (E0x12*), 0, "G0x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(28,24), "G0x12y4");
    check_field_offset(lv, ff, ABISELECT(32,28), "G0x12y4.ff");
    test_class_info(&lv, &cd_G0x12y4);
    dp->~G0x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y4(Test_G0x12y4, "G0x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G0x12y4C1Ev();
extern void _ZN7G0x12y4D1Ev();
Name_Map name_map_G0x12y4[] = {
  NSPAIR(_ZN7G0x12y4C1Ev),
  NSPAIR(_ZN7G0x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G0x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y4[];
extern void _ZN5E0x123fooEv();
static  VTBL_ENTRY vtc_G0x12y4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y4[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
};
extern VTBL_ENTRY _ZTI7G0x12y4[];
extern  VTBL_ENTRY _ZTV7G0x12y4[];
Class_Descriptor cd_G0x12y4 = {  "G0x12y4", // class name
  bases_G0x12y4, 6,
  &(vtc_G0x12y4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G0x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y5  : virtual E0x12 , F0 {
  int ff;
  ~G0x12y5(); // tgen
  G0x12y5(); // tgen
};
//SIG(1 G0x12y5) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G0x12y5 ::~G0x12y5(){ note_dtor("G0x12y5", this);} // tgen
G0x12y5 ::G0x12y5(){ note_ctor("G0x12y5", this);} // tgen

static void Test_G0x12y5()
{
  extern Class_Descriptor cd_G0x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G0x12y5, buf);
    G0x12y5 *dp, &lv = *(dp=new (buf) G0x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G0x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y5)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(24,16), "G0x12y5");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(28,20), "G0x12y5");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(24,16), "G0x12y5");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(36,28), "G0x12y5");
    check_base_class_offset(lv, (E0x12*), ABISELECT(16,12), "G0x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G0x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G0x12y5.ff");
    test_class_info(&lv, &cd_G0x12y5);
    dp->~G0x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y5(Test_G0x12y5, "G0x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G0x12y5C1Ev();
extern void _ZN7G0x12y5D1Ev();
Name_Map name_map_G0x12y5[] = {
  NSPAIR(_ZN7G0x12y5C1Ev),
  NSPAIR(_ZN7G0x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G0x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y5[];
extern void _ZN5E0x123fooEv();
static  VTBL_ENTRY vtc_G0x12y5[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y5[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G0x12y5[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
};
extern VTBL_ENTRY _ZTV7G0x12y5[];
static  VTT_ENTRY vtt_G0x12y5[] = {
  {&(_ZTV7G0x12y5[3]),  3,7},
  {&(_ZTV7G0x12y5[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7G0x12y5[];
extern  VTBL_ENTRY _ZTV7G0x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G0x12y5[];
Class_Descriptor cd_G0x12y5 = {  "G0x12y5", // class name
  bases_G0x12y5, 6,
  &(vtc_G0x12y5[0]), // expected_vtbl_contents
  &(vtt_G0x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G0x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y5),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G0x12y5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y6  : E0x12 , virtual F0 {
  int ff;
  ~G0x12y6(); // tgen
  G0x12y6(); // tgen
};
//SIG(1 G0x12y6) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G0x12y6 ::~G0x12y6(){ note_dtor("G0x12y6", this);} // tgen
G0x12y6 ::G0x12y6(){ note_ctor("G0x12y6", this);} // tgen

static void Test_G0x12y6()
{
  extern Class_Descriptor cd_G0x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G0x12y6, buf);
    G0x12y6 *dp, &lv = *(dp=new (buf) G0x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G0x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y6)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(8,4), "G0x12y6");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(12,8), "G0x12y6");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(8,4), "G0x12y6");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(20,16), "G0x12y6");
    check_base_class_offset(lv, (E0x12*), 0, "G0x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G0x12y6");
    check_field_offset(lv, ff, ABISELECT(28,24), "G0x12y6.ff");
    test_class_info(&lv, &cd_G0x12y6);
    dp->~G0x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y6(Test_G0x12y6, "G0x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G0x12y6C1Ev();
extern void _ZN7G0x12y6D1Ev();
Name_Map name_map_G0x12y6[] = {
  NSPAIR(_ZN7G0x12y6C1Ev),
  NSPAIR(_ZN7G0x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G0x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y6[];
extern void _ZN5E0x123fooEv();
static  VTBL_ENTRY vtc_G0x12y6[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y6[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
};
extern VTBL_ENTRY _ZTV7G0x12y6[];
static  VTT_ENTRY vtt_G0x12y6[] = {
  {&(_ZTV7G0x12y6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G0x12y6[];
extern  VTBL_ENTRY _ZTV7G0x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G0x12y6[];
Class_Descriptor cd_G0x12y6 = {  "G0x12y6", // class name
  bases_G0x12y6, 6,
  &(vtc_G0x12y6[0]), // expected_vtbl_contents
  &(vtt_G0x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G0x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y6),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G0x12y6),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G0x12y7  : virtual E0x12 , virtual F0 {
  int ff;
  ~G0x12y7(); // tgen
  G0x12y7(); // tgen
};
//SIG(1 G0x12y7) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G0x12y7 ::~G0x12y7(){ note_dtor("G0x12y7", this);} // tgen
G0x12y7 ::G0x12y7(){ note_ctor("G0x12y7", this);} // tgen

static void Test_G0x12y7()
{
  extern Class_Descriptor cd_G0x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G0x12y7, buf);
    G0x12y7 *dp, &lv = *(dp=new (buf) G0x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G0x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G0x12y7)");
    check_base_class_offset(lv, (A0*)(C0*)(E0x12*), ABISELECT(24,12), "G0x12y7");
    check_base_class_offset(lv, (B0*)(C0*)(E0x12*), ABISELECT(28,16), "G0x12y7");
    check_base_class_offset(lv, (C0*)(E0x12*), ABISELECT(24,12), "G0x12y7");
    check_base_class_offset(lv, (D0*)(E0x12*), ABISELECT(36,24), "G0x12y7");
    check_base_class_offset(lv, (E0x12*), ABISELECT(16,8), "G0x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G0x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G0x12y7.ff");
    test_class_info(&lv, &cd_G0x12y7);
    dp->~G0x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG0x12y7(Test_G0x12y7, "G0x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G0x12y7C1Ev();
extern void _ZN7G0x12y7D1Ev();
Name_Map name_map_G0x12y7[] = {
  NSPAIR(_ZN7G0x12y7C1Ev),
  NSPAIR(_ZN7G0x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C0;
extern VTBL_ENTRY _ZTI2C0[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E0x12;
extern VTBL_ENTRY _ZTI5E0x12[];
extern  VTBL_ENTRY _ZTV5E0x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G0x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E0x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G0x12y7[];
extern void _ZN5E0x123fooEv();
static  VTBL_ENTRY vtc_G0x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G0x12y7[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G0x12y7[0]),
  (VTBL_ENTRY)&_ZN5E0x123fooEv,
};
extern VTBL_ENTRY _ZTV7G0x12y7[];
static  VTT_ENTRY vtt_G0x12y7[] = {
  {&(_ZTV7G0x12y7[4]),  4,8},
  {&(_ZTV7G0x12y7[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G0x12y7[];
extern  VTBL_ENTRY _ZTV7G0x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G0x12y7[];
Class_Descriptor cd_G0x12y7 = {  "G0x12y7", // class name
  bases_G0x12y7, 6,
  &(vtc_G0x12y7[0]), // expected_vtbl_contents
  &(vtt_G0x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G0x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G0x12y7),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G0x12y7),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E1x12  : C1 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E1x123fooEv
  ~E1x12(); // tgen
  E1x12(); // tgen
};
//SIG(-1 E1x12) C1{ BC2{ BC3{ v1 Fi} BC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E1x12 ::foo(){vfunc_called(this, "_ZN5E1x123fooEv");}
E1x12 ::~E1x12(){ note_dtor("E1x12", this);} // tgen
E1x12 ::E1x12(){ note_ctor("E1x12", this);} // tgen

static void Test_E1x12()
{
  extern Class_Descriptor cd_E1x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E1x12, buf);
    E1x12 *dp, &lv = *(dp=new (buf) E1x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E1x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E1x12)");
    check_base_class_offset(lv, (A1*)(C1*), 0, "E1x12");
    check_base_class_offset(lv, (B0*)(C1*), ABISELECT(12,8), "E1x12");
    check_base_class_offset(lv, (C1*), 0, "E1x12");
    check_base_class_offset(lv, (D0*), ABISELECT(20,16), "E1x12");
    check_field_offset(lv, fd, ABISELECT(24,20), "E1x12.fd");
    test_class_info(&lv, &cd_E1x12);
    dp->~E1x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE1x12(Test_E1x12, "E1x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E1x12C1Ev();
extern void _ZN5E1x12D1Ev();
Name_Map name_map_E1x12[] = {
  NSPAIR(_ZN5E1x12C1Ev),
  NSPAIR(_ZN5E1x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E1x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E1x12[];
extern void _ZN5E1x123fooEv();
static  VTBL_ENTRY vtc_E1x12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5E1x12[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
};
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
Class_Descriptor cd_E1x12 = {  "E1x12", // class name
  bases_E1x12, 4,
  &(vtc_E1x12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E1x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E1x12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y0  : E1x12 , F1 {
  int ff;
  ~G1x12y0(); // tgen
  G1x12y0(); // tgen
};
//SIG(1 G1x12y0) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G1x12y0 ::~G1x12y0(){ note_dtor("G1x12y0", this);} // tgen
G1x12y0 ::G1x12y0(){ note_ctor("G1x12y0", this);} // tgen

static void Test_G1x12y0()
{
  extern Class_Descriptor cd_G1x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G1x12y0, buf);
    G1x12y0 *dp, &lv = *(dp=new (buf) G1x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G1x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y0)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), 0, "G1x12y0");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(12,8), "G1x12y0");
    check_base_class_offset(lv, (C1*)(E1x12*), 0, "G1x12y0");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(20,16), "G1x12y0");
    check_base_class_offset(lv, (E1x12*), 0, "G1x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(32,24), "G1x12y0");
    check_field_offset(lv, ff, ABISELECT(44,32), "G1x12y0.ff");
    test_class_info(&lv, &cd_G1x12y0);
    dp->~G1x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y0(Test_G1x12y0, "G1x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G1x12y0C1Ev();
extern void _ZN7G1x12y0D1Ev();
Name_Map name_map_G1x12y0[] = {
  NSPAIR(_ZN7G1x12y0C1Ev),
  NSPAIR(_ZN7G1x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G1x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,24), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y0[];
extern void _ZN5E1x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G1x12y0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y0[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G1x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTI7G1x12y0[];
extern  VTBL_ENTRY _ZTV7G1x12y0[];
Class_Descriptor cd_G1x12y0 = {  "G1x12y0", // class name
  bases_G1x12y0, 6,
  &(vtc_G1x12y0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G1x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y0),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y1  : virtual E1x12 , F1 {
  int ff;
  ~G1x12y1(); // tgen
  G1x12y1(); // tgen
};
//SIG(1 G1x12y1) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G1x12y1 ::~G1x12y1(){ note_dtor("G1x12y1", this);} // tgen
G1x12y1 ::G1x12y1(){ note_ctor("G1x12y1", this);} // tgen

static void Test_G1x12y1()
{
  extern Class_Descriptor cd_G1x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G1x12y1, buf);
    G1x12y1 *dp, &lv = *(dp=new (buf) G1x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G1x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y1)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), ABISELECT(16,12), "G1x12y1");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(28,20), "G1x12y1");
    check_base_class_offset(lv, (C1*)(E1x12*), ABISELECT(16,12), "G1x12y1");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(36,28), "G1x12y1");
    check_base_class_offset(lv, (E1x12*), ABISELECT(16,12), "G1x12y1");
    check_base_class_offset(lv, (F1*), 0, "G1x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G1x12y1.ff");
    test_class_info(&lv, &cd_G1x12y1);
    dp->~G1x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y1(Test_G1x12y1, "G1x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G1x12y1C1Ev();
extern void _ZN7G1x12y1D1Ev();
Name_Map name_map_G1x12y1[] = {
  NSPAIR(_ZN7G1x12y1C1Ev),
  NSPAIR(_ZN7G1x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G1x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E1x123fooEv();
static  VTBL_ENTRY vtc_G1x12y1[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G1x12y1[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
};
extern VTBL_ENTRY _ZTV7G1x12y1[];
static  VTT_ENTRY vtt_G1x12y1[] = {
  {&(_ZTV7G1x12y1[3]),  3,8},
  {&(_ZTV7G1x12y1[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G1x12y1[];
extern  VTBL_ENTRY _ZTV7G1x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G1x12y1[];
Class_Descriptor cd_G1x12y1 = {  "G1x12y1", // class name
  bases_G1x12y1, 6,
  &(vtc_G1x12y1[0]), // expected_vtbl_contents
  &(vtt_G1x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G1x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y1),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G1x12y1),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y2  : E1x12 , virtual F1 {
  int ff;
  ~G1x12y2(); // tgen
  G1x12y2(); // tgen
};
//SIG(1 G1x12y2) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G1x12y2 ::~G1x12y2(){ note_dtor("G1x12y2", this);} // tgen
G1x12y2 ::G1x12y2(){ note_ctor("G1x12y2", this);} // tgen

static void Test_G1x12y2()
{
  extern Class_Descriptor cd_G1x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G1x12y2, buf);
    G1x12y2 *dp, &lv = *(dp=new (buf) G1x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G1x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y2)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), 0, "G1x12y2");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(12,8), "G1x12y2");
    check_base_class_offset(lv, (C1*)(E1x12*), 0, "G1x12y2");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(20,16), "G1x12y2");
    check_base_class_offset(lv, (E1x12*), 0, "G1x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G1x12y2");
    check_field_offset(lv, ff, ABISELECT(28,24), "G1x12y2.ff");
    test_class_info(&lv, &cd_G1x12y2);
    dp->~G1x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y2(Test_G1x12y2, "G1x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G1x12y2C1Ev();
extern void _ZN7G1x12y2D1Ev();
Name_Map name_map_G1x12y2[] = {
  NSPAIR(_ZN7G1x12y2C1Ev),
  NSPAIR(_ZN7G1x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G1x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y2[];
extern void _ZN5E1x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G1x12y2[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y2[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G1x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G1x12y2[];
static  VTT_ENTRY vtt_G1x12y2[] = {
  {&(_ZTV7G1x12y2[3]),  3,8},
  {&(_ZTV7G1x12y2[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G1x12y2[];
extern  VTBL_ENTRY _ZTV7G1x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G1x12y2[];
Class_Descriptor cd_G1x12y2 = {  "G1x12y2", // class name
  bases_G1x12y2, 6,
  &(vtc_G1x12y2[0]), // expected_vtbl_contents
  &(vtt_G1x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G1x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y2),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G1x12y2),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y3  : virtual E1x12 , virtual F1 {
  int ff;
  ~G1x12y3(); // tgen
  G1x12y3(); // tgen
};
//SIG(1 G1x12y3) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G1x12y3 ::~G1x12y3(){ note_dtor("G1x12y3", this);} // tgen
G1x12y3 ::G1x12y3(){ note_ctor("G1x12y3", this);} // tgen

static void Test_G1x12y3()
{
  extern Class_Descriptor cd_G1x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G1x12y3, buf);
    G1x12y3 *dp, &lv = *(dp=new (buf) G1x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G1x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y3)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), ABISELECT(16,8), "G1x12y3");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(28,16), "G1x12y3");
    check_base_class_offset(lv, (C1*)(E1x12*), ABISELECT(16,8), "G1x12y3");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(36,24), "G1x12y3");
    check_base_class_offset(lv, (E1x12*), ABISELECT(16,8), "G1x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G1x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G1x12y3.ff");
    test_class_info(&lv, &cd_G1x12y3);
    dp->~G1x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y3(Test_G1x12y3, "G1x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G1x12y3C1Ev();
extern void _ZN7G1x12y3D1Ev();
Name_Map name_map_G1x12y3[] = {
  NSPAIR(_ZN7G1x12y3C1Ev),
  NSPAIR(_ZN7G1x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G1x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y3[];
extern void _ZN5E1x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G1x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y3[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G1x12y3[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G1x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G1x12y3[];
static  VTT_ENTRY vtt_G1x12y3[] = {
  {&(_ZTV7G1x12y3[4]),  4,12},
  {&(_ZTV7G1x12y3[7]),  7,12},
  {&(_ZTV7G1x12y3[11]),  11,12},
};
extern VTBL_ENTRY _ZTI7G1x12y3[];
extern  VTBL_ENTRY _ZTV7G1x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G1x12y3[];
Class_Descriptor cd_G1x12y3 = {  "G1x12y3", // class name
  bases_G1x12y3, 6,
  &(vtc_G1x12y3[0]), // expected_vtbl_contents
  &(vtt_G1x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G1x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y3),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G1x12y3),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y4  : E1x12 , F0 {
  int ff;
  ~G1x12y4(); // tgen
  G1x12y4(); // tgen
};
//SIG(1 G1x12y4) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G1x12y4 ::~G1x12y4(){ note_dtor("G1x12y4", this);} // tgen
G1x12y4 ::G1x12y4(){ note_ctor("G1x12y4", this);} // tgen

static void Test_G1x12y4()
{
  extern Class_Descriptor cd_G1x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G1x12y4, buf);
    G1x12y4 *dp, &lv = *(dp=new (buf) G1x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G1x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y4)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), 0, "G1x12y4");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(12,8), "G1x12y4");
    check_base_class_offset(lv, (C1*)(E1x12*), 0, "G1x12y4");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(20,16), "G1x12y4");
    check_base_class_offset(lv, (E1x12*), 0, "G1x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(28,24), "G1x12y4");
    check_field_offset(lv, ff, ABISELECT(32,28), "G1x12y4.ff");
    test_class_info(&lv, &cd_G1x12y4);
    dp->~G1x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y4(Test_G1x12y4, "G1x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G1x12y4C1Ev();
extern void _ZN7G1x12y4D1Ev();
Name_Map name_map_G1x12y4[] = {
  NSPAIR(_ZN7G1x12y4C1Ev),
  NSPAIR(_ZN7G1x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G1x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y4[];
extern void _ZN5E1x123fooEv();
static  VTBL_ENTRY vtc_G1x12y4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y4[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
};
extern VTBL_ENTRY _ZTI7G1x12y4[];
extern  VTBL_ENTRY _ZTV7G1x12y4[];
Class_Descriptor cd_G1x12y4 = {  "G1x12y4", // class name
  bases_G1x12y4, 6,
  &(vtc_G1x12y4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G1x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y5  : virtual E1x12 , F0 {
  int ff;
  ~G1x12y5(); // tgen
  G1x12y5(); // tgen
};
//SIG(1 G1x12y5) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G1x12y5 ::~G1x12y5(){ note_dtor("G1x12y5", this);} // tgen
G1x12y5 ::G1x12y5(){ note_ctor("G1x12y5", this);} // tgen

static void Test_G1x12y5()
{
  extern Class_Descriptor cd_G1x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G1x12y5, buf);
    G1x12y5 *dp, &lv = *(dp=new (buf) G1x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G1x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y5)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), ABISELECT(16,12), "G1x12y5");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(28,20), "G1x12y5");
    check_base_class_offset(lv, (C1*)(E1x12*), ABISELECT(16,12), "G1x12y5");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(36,28), "G1x12y5");
    check_base_class_offset(lv, (E1x12*), ABISELECT(16,12), "G1x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G1x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G1x12y5.ff");
    test_class_info(&lv, &cd_G1x12y5);
    dp->~G1x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y5(Test_G1x12y5, "G1x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G1x12y5C1Ev();
extern void _ZN7G1x12y5D1Ev();
Name_Map name_map_G1x12y5[] = {
  NSPAIR(_ZN7G1x12y5C1Ev),
  NSPAIR(_ZN7G1x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G1x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y5[];
extern void _ZN5E1x123fooEv();
static  VTBL_ENTRY vtc_G1x12y5[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y5[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G1x12y5[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
};
extern VTBL_ENTRY _ZTV7G1x12y5[];
static  VTT_ENTRY vtt_G1x12y5[] = {
  {&(_ZTV7G1x12y5[3]),  3,7},
  {&(_ZTV7G1x12y5[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7G1x12y5[];
extern  VTBL_ENTRY _ZTV7G1x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G1x12y5[];
Class_Descriptor cd_G1x12y5 = {  "G1x12y5", // class name
  bases_G1x12y5, 6,
  &(vtc_G1x12y5[0]), // expected_vtbl_contents
  &(vtt_G1x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G1x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y5),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G1x12y5),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y6  : E1x12 , virtual F0 {
  int ff;
  ~G1x12y6(); // tgen
  G1x12y6(); // tgen
};
//SIG(1 G1x12y6) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G1x12y6 ::~G1x12y6(){ note_dtor("G1x12y6", this);} // tgen
G1x12y6 ::G1x12y6(){ note_ctor("G1x12y6", this);} // tgen

static void Test_G1x12y6()
{
  extern Class_Descriptor cd_G1x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G1x12y6, buf);
    G1x12y6 *dp, &lv = *(dp=new (buf) G1x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G1x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y6)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), 0, "G1x12y6");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(12,8), "G1x12y6");
    check_base_class_offset(lv, (C1*)(E1x12*), 0, "G1x12y6");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(20,16), "G1x12y6");
    check_base_class_offset(lv, (E1x12*), 0, "G1x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G1x12y6");
    check_field_offset(lv, ff, ABISELECT(28,24), "G1x12y6.ff");
    test_class_info(&lv, &cd_G1x12y6);
    dp->~G1x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y6(Test_G1x12y6, "G1x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G1x12y6C1Ev();
extern void _ZN7G1x12y6D1Ev();
Name_Map name_map_G1x12y6[] = {
  NSPAIR(_ZN7G1x12y6C1Ev),
  NSPAIR(_ZN7G1x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G1x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y6[];
extern void _ZN5E1x123fooEv();
static  VTBL_ENTRY vtc_G1x12y6[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y6[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
};
extern VTBL_ENTRY _ZTV7G1x12y6[];
static  VTT_ENTRY vtt_G1x12y6[] = {
  {&(_ZTV7G1x12y6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G1x12y6[];
extern  VTBL_ENTRY _ZTV7G1x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G1x12y6[];
Class_Descriptor cd_G1x12y6 = {  "G1x12y6", // class name
  bases_G1x12y6, 6,
  &(vtc_G1x12y6[0]), // expected_vtbl_contents
  &(vtt_G1x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G1x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y6),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G1x12y6),1, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G1x12y7  : virtual E1x12 , virtual F0 {
  int ff;
  ~G1x12y7(); // tgen
  G1x12y7(); // tgen
};
//SIG(1 G1x12y7) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G1x12y7 ::~G1x12y7(){ note_dtor("G1x12y7", this);} // tgen
G1x12y7 ::G1x12y7(){ note_ctor("G1x12y7", this);} // tgen

static void Test_G1x12y7()
{
  extern Class_Descriptor cd_G1x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G1x12y7, buf);
    G1x12y7 *dp, &lv = *(dp=new (buf) G1x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G1x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G1x12y7)");
    check_base_class_offset(lv, (A1*)(C1*)(E1x12*), ABISELECT(16,8), "G1x12y7");
    check_base_class_offset(lv, (B0*)(C1*)(E1x12*), ABISELECT(28,16), "G1x12y7");
    check_base_class_offset(lv, (C1*)(E1x12*), ABISELECT(16,8), "G1x12y7");
    check_base_class_offset(lv, (D0*)(E1x12*), ABISELECT(36,24), "G1x12y7");
    check_base_class_offset(lv, (E1x12*), ABISELECT(16,8), "G1x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G1x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G1x12y7.ff");
    test_class_info(&lv, &cd_G1x12y7);
    dp->~G1x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG1x12y7(Test_G1x12y7, "G1x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G1x12y7C1Ev();
extern void _ZN7G1x12y7D1Ev();
Name_Map name_map_G1x12y7[] = {
  NSPAIR(_ZN7G1x12y7C1Ev),
  NSPAIR(_ZN7G1x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C1;
extern VTBL_ENTRY _ZTI2C1[];
extern  VTBL_ENTRY _ZTV2C1[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E1x12;
extern VTBL_ENTRY _ZTI5E1x12[];
extern  VTBL_ENTRY _ZTV5E1x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G1x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E1x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G1x12y7[];
extern void _ZN5E1x123fooEv();
static  VTBL_ENTRY vtc_G1x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G1x12y7[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G1x12y7[0]),
  (VTBL_ENTRY)&_ZN5E1x123fooEv,
};
extern VTBL_ENTRY _ZTV7G1x12y7[];
static  VTT_ENTRY vtt_G1x12y7[] = {
  {&(_ZTV7G1x12y7[4]),  4,8},
  {&(_ZTV7G1x12y7[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G1x12y7[];
extern  VTBL_ENTRY _ZTV7G1x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G1x12y7[];
Class_Descriptor cd_G1x12y7 = {  "G1x12y7", // class name
  bases_G1x12y7, 6,
  &(vtc_G1x12y7[0]), // expected_vtbl_contents
  &(vtt_G1x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G1x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G1x12y7),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G1x12y7),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E2x12  : C2 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E2x123fooEv
  ~E2x12(); // tgen
  E2x12(); // tgen
};
//SIG(-1 E2x12) C1{ BC2{ VBC3{ Fi} BC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E2x12 ::foo(){vfunc_called(this, "_ZN5E2x123fooEv");}
E2x12 ::~E2x12(){ note_dtor("E2x12", this);} // tgen
E2x12 ::E2x12(){ note_ctor("E2x12", this);} // tgen

static void Test_E2x12()
{
  extern Class_Descriptor cd_E2x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E2x12, buf);
    E2x12 *dp, &lv = *(dp=new (buf) E2x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E2x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E2x12)");
    check_base_class_offset(lv, (A0*)(C2*), ABISELECT(24,20), "E2x12");
    check_base_class_offset(lv, (B0*)(C2*), ABISELECT(8,4), "E2x12");
    check_base_class_offset(lv, (C2*), 0, "E2x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E2x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E2x12.fd");
    test_class_info(&lv, &cd_E2x12);
    dp->~E2x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE2x12(Test_E2x12, "E2x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E2x12C1Ev();
extern void _ZN5E2x12D1Ev();
Name_Map name_map_E2x12[] = {
  NSPAIR(_ZN5E2x12C1Ev),
  NSPAIR(_ZN5E2x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E2x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E2x12[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY vtc_E2x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
extern VTBL_ENTRY _ZTV5E2x12[];
static  VTBL_ENTRY _tg__ZTV2C2__5E2x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_E2x12[] = {
  {&(_ZTV5E2x12[3]),  3,4},
  {&(_tg__ZTV2C2__5E2x12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
Class_Descriptor cd_E2x12 = {  "E2x12", // class name
  bases_E2x12, 4,
  &(vtc_E2x12[0]), // expected_vtbl_contents
  &(vtt_E2x12[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E2x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E2x12),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5E2x12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y0  : E2x12 , F1 {
  int ff;
  ~G2x12y0(); // tgen
  G2x12y0(); // tgen
};
//SIG(1 G2x12y0) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G2x12y0 ::~G2x12y0(){ note_dtor("G2x12y0", this);} // tgen
G2x12y0 ::G2x12y0(){ note_ctor("G2x12y0", this);} // tgen

static void Test_G2x12y0()
{
  extern Class_Descriptor cd_G2x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G2x12y0, buf);
    G2x12y0 *dp, &lv = *(dp=new (buf) G2x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G2x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y0)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(40,32), "G2x12y0");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(8,4), "G2x12y0");
    check_base_class_offset(lv, (C2*)(E2x12*), 0, "G2x12y0");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(16,12), "G2x12y0");
    check_base_class_offset(lv, (E2x12*), 0, "G2x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G2x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G2x12y0.ff");
    test_class_info(&lv, &cd_G2x12y0);
    dp->~G2x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y0(Test_G2x12y0, "G2x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G2x12y0C1Ev();
extern void _ZN7G2x12y0D1Ev();
Name_Map name_map_G2x12y0[] = {
  NSPAIR(_ZN7G2x12y0C1Ev),
  NSPAIR(_ZN7G2x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G2x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y0[];
extern void _ZN5E2x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G2x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y0[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI7G2x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y0[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y0[] = {
  {&(_ZTV7G2x12y0[3]),  3,7},
  {&(_tg__ZTV5E2x12__7G2x12y0[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y0[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y0[];
extern  VTBL_ENTRY _ZTV7G2x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y0[];
Class_Descriptor cd_G2x12y0 = {  "G2x12y0", // class name
  bases_G2x12y0, 6,
  &(vtc_G2x12y0[0]), // expected_vtbl_contents
  &(vtt_G2x12y0[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G2x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y0),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y0),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y1  : virtual E2x12 , F1 {
  int ff;
  ~G2x12y1(); // tgen
  G2x12y1(); // tgen
};
//SIG(1 G2x12y1) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G2x12y1 ::~G2x12y1(){ note_dtor("G2x12y1", this);} // tgen
G2x12y1 ::G2x12y1(){ note_ctor("G2x12y1", this);} // tgen

static void Test_G2x12y1()
{
  extern Class_Descriptor cd_G2x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G2x12y1, buf);
    G2x12y1 *dp, &lv = *(dp=new (buf) G2x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G2x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y1)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(40,32), "G2x12y1");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(24,16), "G2x12y1");
    check_base_class_offset(lv, (C2*)(E2x12*), ABISELECT(16,12), "G2x12y1");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(32,24), "G2x12y1");
    check_base_class_offset(lv, (E2x12*), ABISELECT(16,12), "G2x12y1");
    check_base_class_offset(lv, (F1*), 0, "G2x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G2x12y1.ff");
    test_class_info(&lv, &cd_G2x12y1);
    dp->~G2x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y1(Test_G2x12y1, "G2x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G2x12y1C1Ev();
extern void _ZN7G2x12y1D1Ev();
Name_Map name_map_G2x12y1[] = {
  NSPAIR(_ZN7G2x12y1C1Ev),
  NSPAIR(_ZN7G2x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G2x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY vtc_G2x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G2x12y1[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y1[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y1[] = {
  {&(_ZTV7G2x12y1[4]),  4,10},
  {&(_ZTV7G2x12y1[9]),  9,10},
  {&(_tg__ZTV5E2x12__7G2x12y1[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y1[];
extern  VTBL_ENTRY _ZTV7G2x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y1[];
Class_Descriptor cd_G2x12y1 = {  "G2x12y1", // class name
  bases_G2x12y1, 6,
  &(vtc_G2x12y1[0]), // expected_vtbl_contents
  &(vtt_G2x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G2x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y1),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y1),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y2  : E2x12 , virtual F1 {
  int ff;
  ~G2x12y2(); // tgen
  G2x12y2(); // tgen
};
//SIG(1 G2x12y2) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G2x12y2 ::~G2x12y2(){ note_dtor("G2x12y2", this);} // tgen
G2x12y2 ::G2x12y2(){ note_ctor("G2x12y2", this);} // tgen

static void Test_G2x12y2()
{
  extern Class_Descriptor cd_G2x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G2x12y2, buf);
    G2x12y2 *dp, &lv = *(dp=new (buf) G2x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G2x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y2)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(28,24), "G2x12y2");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(8,4), "G2x12y2");
    check_base_class_offset(lv, (C2*)(E2x12*), 0, "G2x12y2");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(16,12), "G2x12y2");
    check_base_class_offset(lv, (E2x12*), 0, "G2x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G2x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G2x12y2.ff");
    test_class_info(&lv, &cd_G2x12y2);
    dp->~G2x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y2(Test_G2x12y2, "G2x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G2x12y2C1Ev();
extern void _ZN7G2x12y2D1Ev();
Name_Map name_map_G2x12y2[] = {
  NSPAIR(_ZN7G2x12y2C1Ev),
  NSPAIR(_ZN7G2x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G2x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y2[];
extern void _ZN5E2x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G2x12y2[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y2[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G2x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y2[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y2[] = {
  {&(_ZTV7G2x12y2[4]),  4,9},
  {&(_tg__ZTV5E2x12__7G2x12y2[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y2[3]),  3,3},
  {&(_ZTV7G2x12y2[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7G2x12y2[];
extern  VTBL_ENTRY _ZTV7G2x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y2[];
Class_Descriptor cd_G2x12y2 = {  "G2x12y2", // class name
  bases_G2x12y2, 6,
  &(vtc_G2x12y2[0]), // expected_vtbl_contents
  &(vtt_G2x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G2x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y2),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y2),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y3  : virtual E2x12 , virtual F1 {
  int ff;
  ~G2x12y3(); // tgen
  G2x12y3(); // tgen
};
//SIG(1 G2x12y3) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G2x12y3 ::~G2x12y3(){ note_dtor("G2x12y3", this);} // tgen
G2x12y3 ::G2x12y3(){ note_ctor("G2x12y3", this);} // tgen

static void Test_G2x12y3()
{
  extern Class_Descriptor cd_G2x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G2x12y3, buf);
    G2x12y3 *dp, &lv = *(dp=new (buf) G2x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G2x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y3)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(40,28), "G2x12y3");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(24,12), "G2x12y3");
    check_base_class_offset(lv, (C2*)(E2x12*), ABISELECT(16,8), "G2x12y3");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(32,20), "G2x12y3");
    check_base_class_offset(lv, (E2x12*), ABISELECT(16,8), "G2x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G2x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G2x12y3.ff");
    test_class_info(&lv, &cd_G2x12y3);
    dp->~G2x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y3(Test_G2x12y3, "G2x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G2x12y3C1Ev();
extern void _ZN7G2x12y3D1Ev();
Name_Map name_map_G2x12y3[] = {
  NSPAIR(_ZN7G2x12y3C1Ev),
  NSPAIR(_ZN7G2x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G2x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y3[];
extern void _ZN5E2x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G2x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G2x12y3[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G2x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y3[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y3[] = {
  {&(_ZTV7G2x12y3[5]),  5,14},
  {&(_ZTV7G2x12y3[9]),  9,14},
  {&(_ZTV7G2x12y3[13]),  13,14},
  {&(_tg__ZTV5E2x12__7G2x12y3[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y3[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y3[];
extern  VTBL_ENTRY _ZTV7G2x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y3[];
Class_Descriptor cd_G2x12y3 = {  "G2x12y3", // class name
  bases_G2x12y3, 6,
  &(vtc_G2x12y3[0]), // expected_vtbl_contents
  &(vtt_G2x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G2x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y3),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y3),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y4  : E2x12 , F0 {
  int ff;
  ~G2x12y4(); // tgen
  G2x12y4(); // tgen
};
//SIG(1 G2x12y4) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G2x12y4 ::~G2x12y4(){ note_dtor("G2x12y4", this);} // tgen
G2x12y4 ::G2x12y4(){ note_ctor("G2x12y4", this);} // tgen

static void Test_G2x12y4()
{
  extern Class_Descriptor cd_G2x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G2x12y4, buf);
    G2x12y4 *dp, &lv = *(dp=new (buf) G2x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G2x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y4)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(32,28), "G2x12y4");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(8,4), "G2x12y4");
    check_base_class_offset(lv, (C2*)(E2x12*), 0, "G2x12y4");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(16,12), "G2x12y4");
    check_base_class_offset(lv, (E2x12*), 0, "G2x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G2x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G2x12y4.ff");
    test_class_info(&lv, &cd_G2x12y4);
    dp->~G2x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y4(Test_G2x12y4, "G2x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G2x12y4C1Ev();
extern void _ZN7G2x12y4D1Ev();
Name_Map name_map_G2x12y4[] = {
  NSPAIR(_ZN7G2x12y4C1Ev),
  NSPAIR(_ZN7G2x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G2x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y4[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY vtc_G2x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y4[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y4[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y4[] = {
  {&(_ZTV7G2x12y4[3]),  3,4},
  {&(_tg__ZTV5E2x12__7G2x12y4[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y4[];
extern  VTBL_ENTRY _ZTV7G2x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y4[];
Class_Descriptor cd_G2x12y4 = {  "G2x12y4", // class name
  bases_G2x12y4, 6,
  &(vtc_G2x12y4[0]), // expected_vtbl_contents
  &(vtt_G2x12y4[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G2x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y4),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y4),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y5  : virtual E2x12 , F0 {
  int ff;
  ~G2x12y5(); // tgen
  G2x12y5(); // tgen
};
//SIG(1 G2x12y5) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G2x12y5 ::~G2x12y5(){ note_dtor("G2x12y5", this);} // tgen
G2x12y5 ::G2x12y5(){ note_ctor("G2x12y5", this);} // tgen

static void Test_G2x12y5()
{
  extern Class_Descriptor cd_G2x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G2x12y5, buf);
    G2x12y5 *dp, &lv = *(dp=new (buf) G2x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G2x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y5)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(40,32), "G2x12y5");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(24,16), "G2x12y5");
    check_base_class_offset(lv, (C2*)(E2x12*), ABISELECT(16,12), "G2x12y5");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(32,24), "G2x12y5");
    check_base_class_offset(lv, (E2x12*), ABISELECT(16,12), "G2x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G2x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G2x12y5.ff");
    test_class_info(&lv, &cd_G2x12y5);
    dp->~G2x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y5(Test_G2x12y5, "G2x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G2x12y5C1Ev();
extern void _ZN7G2x12y5D1Ev();
Name_Map name_map_G2x12y5[] = {
  NSPAIR(_ZN7G2x12y5C1Ev),
  NSPAIR(_ZN7G2x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G2x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y5[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY vtc_G2x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G2x12y5[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y5[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y5[] = {
  {&(_ZTV7G2x12y5[4]),  4,9},
  {&(_ZTV7G2x12y5[8]),  8,9},
  {&(_tg__ZTV5E2x12__7G2x12y5[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y5[];
extern  VTBL_ENTRY _ZTV7G2x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y5[];
Class_Descriptor cd_G2x12y5 = {  "G2x12y5", // class name
  bases_G2x12y5, 6,
  &(vtc_G2x12y5[0]), // expected_vtbl_contents
  &(vtt_G2x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G2x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y5),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y5),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y6  : E2x12 , virtual F0 {
  int ff;
  ~G2x12y6(); // tgen
  G2x12y6(); // tgen
};
//SIG(1 G2x12y6) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G2x12y6 ::~G2x12y6(){ note_dtor("G2x12y6", this);} // tgen
G2x12y6 ::G2x12y6(){ note_ctor("G2x12y6", this);} // tgen

static void Test_G2x12y6()
{
  extern Class_Descriptor cd_G2x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G2x12y6, buf);
    G2x12y6 *dp, &lv = *(dp=new (buf) G2x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G2x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y6)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(28,24), "G2x12y6");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(8,4), "G2x12y6");
    check_base_class_offset(lv, (C2*)(E2x12*), 0, "G2x12y6");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(16,12), "G2x12y6");
    check_base_class_offset(lv, (E2x12*), 0, "G2x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G2x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G2x12y6.ff");
    test_class_info(&lv, &cd_G2x12y6);
    dp->~G2x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y6(Test_G2x12y6, "G2x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G2x12y6C1Ev();
extern void _ZN7G2x12y6D1Ev();
Name_Map name_map_G2x12y6[] = {
  NSPAIR(_ZN7G2x12y6C1Ev),
  NSPAIR(_ZN7G2x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G2x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y6[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY vtc_G2x12y6[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y6[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y6[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y6[] = {
  {&(_ZTV7G2x12y6[4]),  4,5},
  {&(_tg__ZTV5E2x12__7G2x12y6[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y6[];
extern  VTBL_ENTRY _ZTV7G2x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y6[];
Class_Descriptor cd_G2x12y6 = {  "G2x12y6", // class name
  bases_G2x12y6, 6,
  &(vtc_G2x12y6[0]), // expected_vtbl_contents
  &(vtt_G2x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G2x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y6),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y6),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G2x12y7  : virtual E2x12 , virtual F0 {
  int ff;
  ~G2x12y7(); // tgen
  G2x12y7(); // tgen
};
//SIG(1 G2x12y7) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G2x12y7 ::~G2x12y7(){ note_dtor("G2x12y7", this);} // tgen
G2x12y7 ::G2x12y7(){ note_ctor("G2x12y7", this);} // tgen

static void Test_G2x12y7()
{
  extern Class_Descriptor cd_G2x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G2x12y7, buf);
    G2x12y7 *dp, &lv = *(dp=new (buf) G2x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G2x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G2x12y7)");
    check_base_class_offset(lv, (A0*)(C2*)(E2x12*), ABISELECT(40,28), "G2x12y7");
    check_base_class_offset(lv, (B0*)(C2*)(E2x12*), ABISELECT(24,12), "G2x12y7");
    check_base_class_offset(lv, (C2*)(E2x12*), ABISELECT(16,8), "G2x12y7");
    check_base_class_offset(lv, (D0*)(E2x12*), ABISELECT(32,20), "G2x12y7");
    check_base_class_offset(lv, (E2x12*), ABISELECT(16,8), "G2x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G2x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G2x12y7.ff");
    test_class_info(&lv, &cd_G2x12y7);
    dp->~G2x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG2x12y7(Test_G2x12y7, "G2x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G2x12y7C1Ev();
extern void _ZN7G2x12y7D1Ev();
Name_Map name_map_G2x12y7[] = {
  NSPAIR(_ZN7G2x12y7C1Ev),
  NSPAIR(_ZN7G2x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C2;
extern VTBL_ENTRY _ZTI2C2[];
extern  VTBL_ENTRY _ZTV2C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C2[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E2x12;
extern VTBL_ENTRY _ZTI5E2x12[];
extern  VTBL_ENTRY _ZTV5E2x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E2x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G2x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C2,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E2x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G2x12y7[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY vtc_G2x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G2x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G2x12y7[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
extern VTBL_ENTRY _ZTV7G2x12y7[];
extern void _ZN5E2x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E2x12__7G2x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E2x12[0]),
  (VTBL_ENTRY)&_ZN5E2x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C25E2x12__7G2x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C2[0]),
};
static  VTT_ENTRY vtt_G2x12y7[] = {
  {&(_ZTV7G2x12y7[5]),  5,10},
  {&(_ZTV7G2x12y7[9]),  9,10},
  {&(_tg__ZTV5E2x12__7G2x12y7[3]),  3,4},
  {&(_tg__ZTV2C25E2x12__7G2x12y7[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G2x12y7[];
extern  VTBL_ENTRY _ZTV7G2x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G2x12y7[];
Class_Descriptor cd_G2x12y7 = {  "G2x12y7", // class name
  bases_G2x12y7, 6,
  &(vtc_G2x12y7[0]), // expected_vtbl_contents
  &(vtt_G2x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G2x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G2x12y7),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G2x12y7),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E3x12  : C3 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E3x123fooEv
  ~E3x12(); // tgen
  E3x12(); // tgen
};
//SIG(-1 E3x12) C1{ BC2{ VBC3{ v1 Fi} BC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E3x12 ::foo(){vfunc_called(this, "_ZN5E3x123fooEv");}
E3x12 ::~E3x12(){ note_dtor("E3x12", this);} // tgen
E3x12 ::E3x12(){ note_ctor("E3x12", this);} // tgen

static void Test_E3x12()
{
  extern Class_Descriptor cd_E3x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E3x12, buf);
    E3x12 *dp, &lv = *(dp=new (buf) E3x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E3x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E3x12)");
    check_base_class_offset(lv, (A1*)(C3*), ABISELECT(24,20), "E3x12");
    check_base_class_offset(lv, (B0*)(C3*), ABISELECT(8,4), "E3x12");
    check_base_class_offset(lv, (C3*), 0, "E3x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E3x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E3x12.fd");
    test_class_info(&lv, &cd_E3x12);
    dp->~E3x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE3x12(Test_E3x12, "E3x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN5E3x12C1Ev();
extern void _ZN5E3x12D1Ev();
Name_Map name_map_E3x12[] = {
  NSPAIR(_ZN5E3x12C1Ev),
  NSPAIR(_ZN5E3x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E3x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E3x12[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E3x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV5E3x12[];
static  VTBL_ENTRY _tg__ZTV2C3__5E3x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C3__5E3x12[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_E3x12[] = {
  {&(_ZTV5E3x12[3]),  3,8},
  {&(_tg__ZTV2C3__5E3x12[3]),  3,3},
  {&(_tg__ZTV2A1__2C3__5E3x12[3]),  3,4},
  {&(_ZTV5E3x12[7]),  7,8},
};
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E3x12 = {  "E3x12", // class name
  bases_E3x12, 4,
  &(vtc_E3x12[0]), // expected_vtbl_contents
  &(vtt_E3x12[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI5E3x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E3x12),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5E3x12),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y0  : E3x12 , F1 {
  int ff;
  ~G3x12y0(); // tgen
  G3x12y0(); // tgen
};
//SIG(1 G3x12y0) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G3x12y0 ::~G3x12y0(){ note_dtor("G3x12y0", this);} // tgen
G3x12y0 ::G3x12y0(){ note_ctor("G3x12y0", this);} // tgen

static void Test_G3x12y0()
{
  extern Class_Descriptor cd_G3x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G3x12y0, buf);
    G3x12y0 *dp, &lv = *(dp=new (buf) G3x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G3x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y0)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(40,32), "G3x12y0");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(8,4), "G3x12y0");
    check_base_class_offset(lv, (C3*)(E3x12*), 0, "G3x12y0");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(16,12), "G3x12y0");
    check_base_class_offset(lv, (E3x12*), 0, "G3x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G3x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G3x12y0.ff");
    test_class_info(&lv, &cd_G3x12y0);
    dp->~G3x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y0(Test_G3x12y0, "G3x12y0", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G3x12y0C1Ev();
extern void _ZN7G3x12y0D1Ev();
Name_Map name_map_G3x12y0[] = {
  NSPAIR(_ZN7G3x12y0C1Ev),
  NSPAIR(_ZN7G3x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G3x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y0[];
extern void _ZN5E3x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn40_N5E3x123fooEv,_ZThn32_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G3x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y0[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI7G3x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI7G3x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV7G3x12y0[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y0[] = {
  0,
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn40_N5E3x123fooEv,_ZThn32_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y0[] = {
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y0[] = {
  {&(_ZTV7G3x12y0[3]),  3,11},
  {&(_tg__ZTV5E3x12__7G3x12y0[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y0[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y0[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y0[3]),  3,4},
  {&(_ZTV7G3x12y0[10]),  10,11},
};
extern VTBL_ENTRY _ZTI7G3x12y0[];
extern  VTBL_ENTRY _ZTV7G3x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y0[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N5E3x123fooEv,_ZThn32_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N5E3x123fooEv,_ZThn32_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y0 = {  "G3x12y0", // class name
  bases_G3x12y0, 6,
  &(vtc_G3x12y0[0]), // expected_vtbl_contents
  &(vtt_G3x12y0[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G3x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y0),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y0),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y1  : virtual E3x12 , F1 {
  int ff;
  ~G3x12y1(); // tgen
  G3x12y1(); // tgen
};
//SIG(1 G3x12y1) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G3x12y1 ::~G3x12y1(){ note_dtor("G3x12y1", this);} // tgen
G3x12y1 ::G3x12y1(){ note_ctor("G3x12y1", this);} // tgen

static void Test_G3x12y1()
{
  extern Class_Descriptor cd_G3x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G3x12y1, buf);
    G3x12y1 *dp, &lv = *(dp=new (buf) G3x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G3x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y1)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(40,32), "G3x12y1");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(24,16), "G3x12y1");
    check_base_class_offset(lv, (C3*)(E3x12*), ABISELECT(16,12), "G3x12y1");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(32,24), "G3x12y1");
    check_base_class_offset(lv, (E3x12*), ABISELECT(16,12), "G3x12y1");
    check_base_class_offset(lv, (F1*), 0, "G3x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G3x12y1.ff");
    test_class_info(&lv, &cd_G3x12y1);
    dp->~G3x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y1(Test_G3x12y1, "G3x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G3x12y1C1Ev();
extern void _ZN7G3x12y1D1Ev();
Name_Map name_map_G3x12y1[] = {
  NSPAIR(_ZN7G3x12y1C1Ev),
  NSPAIR(_ZN7G3x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G3x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G3x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G3x12y1[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI7G3x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV7G3x12y1[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y1[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y1[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y1[] = {
  {&(_ZTV7G3x12y1[4]),  4,14},
  {&(_ZTV7G3x12y1[9]),  9,14},
  {&(_ZTV7G3x12y1[13]),  13,14},
  {&(_tg__ZTV5E3x12__7G3x12y1[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y1[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y1[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G3x12y1[];
extern  VTBL_ENTRY _ZTV7G3x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y1[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y1 = {  "G3x12y1", // class name
  bases_G3x12y1, 6,
  &(vtc_G3x12y1[0]), // expected_vtbl_contents
  &(vtt_G3x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G3x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y1),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y1),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y2  : E3x12 , virtual F1 {
  int ff;
  ~G3x12y2(); // tgen
  G3x12y2(); // tgen
};
//SIG(1 G3x12y2) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G3x12y2 ::~G3x12y2(){ note_dtor("G3x12y2", this);} // tgen
G3x12y2 ::G3x12y2(){ note_ctor("G3x12y2", this);} // tgen

static void Test_G3x12y2()
{
  extern Class_Descriptor cd_G3x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G3x12y2, buf);
    G3x12y2 *dp, &lv = *(dp=new (buf) G3x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G3x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y2)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(32,24), "G3x12y2");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(8,4), "G3x12y2");
    check_base_class_offset(lv, (C3*)(E3x12*), 0, "G3x12y2");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(16,12), "G3x12y2");
    check_base_class_offset(lv, (E3x12*), 0, "G3x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G3x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G3x12y2.ff");
    test_class_info(&lv, &cd_G3x12y2);
    dp->~G3x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y2(Test_G3x12y2, "G3x12y2", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G3x12y2C1Ev();
extern void _ZN7G3x12y2D1Ev();
Name_Map name_map_G3x12y2[] = {
  NSPAIR(_ZN7G3x12y2C1Ev),
  NSPAIR(_ZN7G3x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G3x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y2[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G3x12y2[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y2[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G3x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G3x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G3x12y2[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y2[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y2[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y2[] = {
  {&(_ZTV7G3x12y2[4]),  4,13},
  {&(_tg__ZTV5E3x12__7G3x12y2[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y2[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y2[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y2[3]),  3,4},
  {&(_ZTV7G3x12y2[8]),  8,13},
  {&(_ZTV7G3x12y2[12]),  12,13},
};
extern VTBL_ENTRY _ZTI7G3x12y2[];
extern  VTBL_ENTRY _ZTV7G3x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y2[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y2 = {  "G3x12y2", // class name
  bases_G3x12y2, 6,
  &(vtc_G3x12y2[0]), // expected_vtbl_contents
  &(vtt_G3x12y2[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G3x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y2),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y2),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y3  : virtual E3x12 , virtual F1 {
  int ff;
  ~G3x12y3(); // tgen
  G3x12y3(); // tgen
};
//SIG(1 G3x12y3) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G3x12y3 ::~G3x12y3(){ note_dtor("G3x12y3", this);} // tgen
G3x12y3 ::G3x12y3(){ note_ctor("G3x12y3", this);} // tgen

static void Test_G3x12y3()
{
  extern Class_Descriptor cd_G3x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G3x12y3, buf);
    G3x12y3 *dp, &lv = *(dp=new (buf) G3x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G3x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y3)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(40,28), "G3x12y3");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(24,12), "G3x12y3");
    check_base_class_offset(lv, (C3*)(E3x12*), ABISELECT(16,8), "G3x12y3");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(32,20), "G3x12y3");
    check_base_class_offset(lv, (E3x12*), ABISELECT(16,8), "G3x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G3x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G3x12y3.ff");
    test_class_info(&lv, &cd_G3x12y3);
    dp->~G3x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y3(Test_G3x12y3, "G3x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN7G3x12y3C1Ev();
extern void _ZN7G3x12y3D1Ev();
Name_Map name_map_G3x12y3[] = {
  NSPAIR(_ZN7G3x12y3C1Ev),
  NSPAIR(_ZN7G3x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G3x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y3[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G3x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G3x12y3[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7G3x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7G3x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G3x12y3[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y3[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y3[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y3[] = {
  {&(_ZTV7G3x12y3[5]),  5,18},
  {&(_ZTV7G3x12y3[9]),  9,18},
  {&(_ZTV7G3x12y3[13]),  13,18},
  {&(_ZTV7G3x12y3[17]),  17,18},
  {&(_tg__ZTV5E3x12__7G3x12y3[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y3[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y3[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G3x12y3[];
extern  VTBL_ENTRY _ZTV7G3x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y3[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y3 = {  "G3x12y3", // class name
  bases_G3x12y3, 6,
  &(vtc_G3x12y3[0]), // expected_vtbl_contents
  &(vtt_G3x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI7G3x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y3),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y3),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y4  : E3x12 , F0 {
  int ff;
  ~G3x12y4(); // tgen
  G3x12y4(); // tgen
};
//SIG(1 G3x12y4) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G3x12y4 ::~G3x12y4(){ note_dtor("G3x12y4", this);} // tgen
G3x12y4 ::G3x12y4(){ note_ctor("G3x12y4", this);} // tgen

static void Test_G3x12y4()
{
  extern Class_Descriptor cd_G3x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G3x12y4, buf);
    G3x12y4 *dp, &lv = *(dp=new (buf) G3x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G3x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y4)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(32,28), "G3x12y4");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(8,4), "G3x12y4");
    check_base_class_offset(lv, (C3*)(E3x12*), 0, "G3x12y4");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(16,12), "G3x12y4");
    check_base_class_offset(lv, (E3x12*), 0, "G3x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G3x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G3x12y4.ff");
    test_class_info(&lv, &cd_G3x12y4);
    dp->~G3x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y4(Test_G3x12y4, "G3x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G3x12y4C1Ev();
extern void _ZN7G3x12y4D1Ev();
Name_Map name_map_G3x12y4[] = {
  NSPAIR(_ZN7G3x12y4C1Ev),
  NSPAIR(_ZN7G3x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G3x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y4[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn28_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G3x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y4[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G3x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV7G3x12y4[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y4[] = {
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn28_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y4[] = {
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y4[] = {
  {&(_ZTV7G3x12y4[3]),  3,8},
  {&(_tg__ZTV5E3x12__7G3x12y4[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y4[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y4[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y4[3]),  3,4},
  {&(_ZTV7G3x12y4[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G3x12y4[];
extern  VTBL_ENTRY _ZTV7G3x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y4[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn28_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn28_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y4 = {  "G3x12y4", // class name
  bases_G3x12y4, 6,
  &(vtc_G3x12y4[0]), // expected_vtbl_contents
  &(vtt_G3x12y4[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G3x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y4),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y4),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y5  : virtual E3x12 , F0 {
  int ff;
  ~G3x12y5(); // tgen
  G3x12y5(); // tgen
};
//SIG(1 G3x12y5) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G3x12y5 ::~G3x12y5(){ note_dtor("G3x12y5", this);} // tgen
G3x12y5 ::G3x12y5(){ note_ctor("G3x12y5", this);} // tgen

static void Test_G3x12y5()
{
  extern Class_Descriptor cd_G3x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G3x12y5, buf);
    G3x12y5 *dp, &lv = *(dp=new (buf) G3x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G3x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y5)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(40,32), "G3x12y5");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(24,16), "G3x12y5");
    check_base_class_offset(lv, (C3*)(E3x12*), ABISELECT(16,12), "G3x12y5");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(32,24), "G3x12y5");
    check_base_class_offset(lv, (E3x12*), ABISELECT(16,12), "G3x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G3x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G3x12y5.ff");
    test_class_info(&lv, &cd_G3x12y5);
    dp->~G3x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y5(Test_G3x12y5, "G3x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G3x12y5C1Ev();
extern void _ZN7G3x12y5D1Ev();
Name_Map name_map_G3x12y5[] = {
  NSPAIR(_ZN7G3x12y5C1Ev),
  NSPAIR(_ZN7G3x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G3x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y5[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G3x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G3x12y5[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI7G3x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV7G3x12y5[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y5[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y5[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y5[] = {
  {&(_ZTV7G3x12y5[4]),  4,13},
  {&(_ZTV7G3x12y5[8]),  8,13},
  {&(_ZTV7G3x12y5[12]),  12,13},
  {&(_tg__ZTV5E3x12__7G3x12y5[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y5[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y5[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G3x12y5[];
extern  VTBL_ENTRY _ZTV7G3x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y5[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y5 = {  "G3x12y5", // class name
  bases_G3x12y5, 6,
  &(vtc_G3x12y5[0]), // expected_vtbl_contents
  &(vtt_G3x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G3x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y5),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y5),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y6  : E3x12 , virtual F0 {
  int ff;
  ~G3x12y6(); // tgen
  G3x12y6(); // tgen
};
//SIG(1 G3x12y6) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G3x12y6 ::~G3x12y6(){ note_dtor("G3x12y6", this);} // tgen
G3x12y6 ::G3x12y6(){ note_ctor("G3x12y6", this);} // tgen

static void Test_G3x12y6()
{
  extern Class_Descriptor cd_G3x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G3x12y6, buf);
    G3x12y6 *dp, &lv = *(dp=new (buf) G3x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G3x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y6)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(32,24), "G3x12y6");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(8,4), "G3x12y6");
    check_base_class_offset(lv, (C3*)(E3x12*), 0, "G3x12y6");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(16,12), "G3x12y6");
    check_base_class_offset(lv, (E3x12*), 0, "G3x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G3x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G3x12y6.ff");
    test_class_info(&lv, &cd_G3x12y6);
    dp->~G3x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y6(Test_G3x12y6, "G3x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G3x12y6C1Ev();
extern void _ZN7G3x12y6D1Ev();
Name_Map name_map_G3x12y6[] = {
  NSPAIR(_ZN7G3x12y6C1Ev),
  NSPAIR(_ZN7G3x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G3x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y6[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G3x12y6[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y6[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G3x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV7G3x12y6[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y6[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y6[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y6[] = {
  {&(_ZTV7G3x12y6[4]),  4,9},
  {&(_tg__ZTV5E3x12__7G3x12y6[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y6[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y6[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y6[3]),  3,4},
  {&(_ZTV7G3x12y6[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7G3x12y6[];
extern  VTBL_ENTRY _ZTV7G3x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y6[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E3x123fooEv,_ZThn24_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y6 = {  "G3x12y6", // class name
  bases_G3x12y6, 6,
  &(vtc_G3x12y6[0]), // expected_vtbl_contents
  &(vtt_G3x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G3x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y6),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y6),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G3x12y7  : virtual E3x12 , virtual F0 {
  int ff;
  ~G3x12y7(); // tgen
  G3x12y7(); // tgen
};
//SIG(1 G3x12y7) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G3x12y7 ::~G3x12y7(){ note_dtor("G3x12y7", this);} // tgen
G3x12y7 ::G3x12y7(){ note_ctor("G3x12y7", this);} // tgen

static void Test_G3x12y7()
{
  extern Class_Descriptor cd_G3x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G3x12y7, buf);
    G3x12y7 *dp, &lv = *(dp=new (buf) G3x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G3x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G3x12y7)");
    check_base_class_offset(lv, (A1*)(C3*)(E3x12*), ABISELECT(40,28), "G3x12y7");
    check_base_class_offset(lv, (B0*)(C3*)(E3x12*), ABISELECT(24,12), "G3x12y7");
    check_base_class_offset(lv, (C3*)(E3x12*), ABISELECT(16,8), "G3x12y7");
    check_base_class_offset(lv, (D0*)(E3x12*), ABISELECT(32,20), "G3x12y7");
    check_base_class_offset(lv, (E3x12*), ABISELECT(16,8), "G3x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(52,36), "G3x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G3x12y7.ff");
    test_class_info(&lv, &cd_G3x12y7);
    dp->~G3x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG3x12y7(Test_G3x12y7, "G3x12y7", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G3x12y7C1Ev();
extern void _ZN7G3x12y7D1Ev();
Name_Map name_map_G3x12y7[] = {
  NSPAIR(_ZN7G3x12y7C1Ev),
  NSPAIR(_ZN7G3x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C3;
extern VTBL_ENTRY _ZTI2C3[];
extern  VTBL_ENTRY _ZTV2C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C3[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E3x12;
extern VTBL_ENTRY _ZTI5E3x12[];
extern  VTBL_ENTRY _ZTV5E3x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E3x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G3x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C3,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E3x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G3x12y7[];
extern void _ZN5E3x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G3x12y7[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G3x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G3x12y7[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7G3x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
extern VTBL_ENTRY _ZTV7G3x12y7[];
extern void _ZN5E3x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E3x12__7G3x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&_ZN5E3x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C35E3x12__7G3x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C3[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C35E3x12__7G3x12y7[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C3[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv)();
extern void ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E3x12__7G3x12y7[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E3x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv),
};
static  VTT_ENTRY vtt_G3x12y7[] = {
  {&(_ZTV7G3x12y7[5]),  5,14},
  {&(_ZTV7G3x12y7[9]),  9,14},
  {&(_ZTV7G3x12y7[13]),  13,14},
  {&(_tg__ZTV5E3x12__7G3x12y7[3]),  3,4},
  {&(_tg__ZTV2C35E3x12__7G3x12y7[3]),  3,3},
  {&(_tg__ZTV2A1__2C35E3x12__7G3x12y7[3]),  3,4},
  {&(_tg__ZTV2A1__5E3x12__7G3x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G3x12y7[];
extern  VTBL_ENTRY _ZTV7G3x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G3x12y7[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E3x123fooEv,_ZTv0_n12_N5E3x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E3x123fooEv,_ZThn20_N5E3x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G3x12y7 = {  "G3x12y7", // class name
  bases_G3x12y7, 6,
  &(vtc_G3x12y7[0]), // expected_vtbl_contents
  &(vtt_G3x12y7[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G3x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G3x12y7),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G3x12y7),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E4x12  : C4 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E4x123fooEv
  ~E4x12(); // tgen
  E4x12(); // tgen
};
//SIG(-1 E4x12) C1{ BC2{ BC3{ Fi} BC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E4x12 ::foo(){vfunc_called(this, "_ZN5E4x123fooEv");}
E4x12 ::~E4x12(){ note_dtor("E4x12", this);} // tgen
E4x12 ::E4x12(){ note_ctor("E4x12", this);} // tgen

static void Test_E4x12()
{
  extern Class_Descriptor cd_E4x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E4x12, buf);
    E4x12 *dp, &lv = *(dp=new (buf) E4x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E4x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E4x12)");
    check_base_class_offset(lv, (A0*)(C4*), ABISELECT(12,8), "E4x12");
    check_base_class_offset(lv, (B1*)(C4*), 0, "E4x12");
    check_base_class_offset(lv, (C4*), 0, "E4x12");
    check_base_class_offset(lv, (D0*), ABISELECT(20,16), "E4x12");
    check_field_offset(lv, fd, ABISELECT(24,20), "E4x12.fd");
    test_class_info(&lv, &cd_E4x12);
    dp->~E4x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE4x12(Test_E4x12, "E4x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E4x12C1Ev();
extern void _ZN5E4x12D1Ev();
Name_Map name_map_E4x12[] = {
  NSPAIR(_ZN5E4x12C1Ev),
  NSPAIR(_ZN5E4x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E4x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E4x12[];
extern void _ZN5E4x123fooEv();
static  VTBL_ENTRY vtc_E4x12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5E4x12[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
};
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
Class_Descriptor cd_E4x12 = {  "E4x12", // class name
  bases_E4x12, 4,
  &(vtc_E4x12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E4x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E4x12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y0  : E4x12 , F1 {
  int ff;
  ~G4x12y0(); // tgen
  G4x12y0(); // tgen
};
//SIG(1 G4x12y0) C1{ BC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G4x12y0 ::~G4x12y0(){ note_dtor("G4x12y0", this);} // tgen
G4x12y0 ::G4x12y0(){ note_ctor("G4x12y0", this);} // tgen

static void Test_G4x12y0()
{
  extern Class_Descriptor cd_G4x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G4x12y0, buf);
    G4x12y0 *dp, &lv = *(dp=new (buf) G4x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G4x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y0)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(12,8), "G4x12y0");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), 0, "G4x12y0");
    check_base_class_offset(lv, (C4*)(E4x12*), 0, "G4x12y0");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(20,16), "G4x12y0");
    check_base_class_offset(lv, (E4x12*), 0, "G4x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(32,24), "G4x12y0");
    check_field_offset(lv, ff, ABISELECT(44,32), "G4x12y0.ff");
    test_class_info(&lv, &cd_G4x12y0);
    dp->~G4x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y0(Test_G4x12y0, "G4x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G4x12y0C1Ev();
extern void _ZN7G4x12y0D1Ev();
Name_Map name_map_G4x12y0[] = {
  NSPAIR(_ZN7G4x12y0C1Ev),
  NSPAIR(_ZN7G4x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G4x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,24), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y0[];
extern void _ZN5E4x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G4x12y0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y0[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G4x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTI7G4x12y0[];
extern  VTBL_ENTRY _ZTV7G4x12y0[];
Class_Descriptor cd_G4x12y0 = {  "G4x12y0", // class name
  bases_G4x12y0, 6,
  &(vtc_G4x12y0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G4x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y0),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y1  : virtual E4x12 , F1 {
  int ff;
  ~G4x12y1(); // tgen
  G4x12y1(); // tgen
};
//SIG(1 G4x12y1) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G4x12y1 ::~G4x12y1(){ note_dtor("G4x12y1", this);} // tgen
G4x12y1 ::G4x12y1(){ note_ctor("G4x12y1", this);} // tgen

static void Test_G4x12y1()
{
  extern Class_Descriptor cd_G4x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G4x12y1, buf);
    G4x12y1 *dp, &lv = *(dp=new (buf) G4x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G4x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y1)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(28,20), "G4x12y1");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), ABISELECT(16,12), "G4x12y1");
    check_base_class_offset(lv, (C4*)(E4x12*), ABISELECT(16,12), "G4x12y1");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(36,28), "G4x12y1");
    check_base_class_offset(lv, (E4x12*), ABISELECT(16,12), "G4x12y1");
    check_base_class_offset(lv, (F1*), 0, "G4x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G4x12y1.ff");
    test_class_info(&lv, &cd_G4x12y1);
    dp->~G4x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y1(Test_G4x12y1, "G4x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G4x12y1C1Ev();
extern void _ZN7G4x12y1D1Ev();
Name_Map name_map_G4x12y1[] = {
  NSPAIR(_ZN7G4x12y1C1Ev),
  NSPAIR(_ZN7G4x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G4x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E4x123fooEv();
static  VTBL_ENTRY vtc_G4x12y1[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G4x12y1[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
};
extern VTBL_ENTRY _ZTV7G4x12y1[];
static  VTT_ENTRY vtt_G4x12y1[] = {
  {&(_ZTV7G4x12y1[3]),  3,8},
  {&(_ZTV7G4x12y1[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G4x12y1[];
extern  VTBL_ENTRY _ZTV7G4x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G4x12y1[];
Class_Descriptor cd_G4x12y1 = {  "G4x12y1", // class name
  bases_G4x12y1, 6,
  &(vtc_G4x12y1[0]), // expected_vtbl_contents
  &(vtt_G4x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G4x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y1),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G4x12y1),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y2  : E4x12 , virtual F1 {
  int ff;
  ~G4x12y2(); // tgen
  G4x12y2(); // tgen
};
//SIG(1 G4x12y2) C1{ BC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G4x12y2 ::~G4x12y2(){ note_dtor("G4x12y2", this);} // tgen
G4x12y2 ::G4x12y2(){ note_ctor("G4x12y2", this);} // tgen

static void Test_G4x12y2()
{
  extern Class_Descriptor cd_G4x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G4x12y2, buf);
    G4x12y2 *dp, &lv = *(dp=new (buf) G4x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G4x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y2)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(12,8), "G4x12y2");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), 0, "G4x12y2");
    check_base_class_offset(lv, (C4*)(E4x12*), 0, "G4x12y2");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(20,16), "G4x12y2");
    check_base_class_offset(lv, (E4x12*), 0, "G4x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G4x12y2");
    check_field_offset(lv, ff, ABISELECT(28,24), "G4x12y2.ff");
    test_class_info(&lv, &cd_G4x12y2);
    dp->~G4x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y2(Test_G4x12y2, "G4x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G4x12y2C1Ev();
extern void _ZN7G4x12y2D1Ev();
Name_Map name_map_G4x12y2[] = {
  NSPAIR(_ZN7G4x12y2C1Ev),
  NSPAIR(_ZN7G4x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G4x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y2[];
extern void _ZN5E4x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G4x12y2[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y2[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G4x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G4x12y2[];
static  VTT_ENTRY vtt_G4x12y2[] = {
  {&(_ZTV7G4x12y2[3]),  3,8},
  {&(_ZTV7G4x12y2[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G4x12y2[];
extern  VTBL_ENTRY _ZTV7G4x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G4x12y2[];
Class_Descriptor cd_G4x12y2 = {  "G4x12y2", // class name
  bases_G4x12y2, 6,
  &(vtc_G4x12y2[0]), // expected_vtbl_contents
  &(vtt_G4x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G4x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y2),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G4x12y2),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y3  : virtual E4x12 , virtual F1 {
  int ff;
  ~G4x12y3(); // tgen
  G4x12y3(); // tgen
};
//SIG(1 G4x12y3) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G4x12y3 ::~G4x12y3(){ note_dtor("G4x12y3", this);} // tgen
G4x12y3 ::G4x12y3(){ note_ctor("G4x12y3", this);} // tgen

static void Test_G4x12y3()
{
  extern Class_Descriptor cd_G4x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G4x12y3, buf);
    G4x12y3 *dp, &lv = *(dp=new (buf) G4x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G4x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y3)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(28,16), "G4x12y3");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), ABISELECT(16,8), "G4x12y3");
    check_base_class_offset(lv, (C4*)(E4x12*), ABISELECT(16,8), "G4x12y3");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(36,24), "G4x12y3");
    check_base_class_offset(lv, (E4x12*), ABISELECT(16,8), "G4x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G4x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G4x12y3.ff");
    test_class_info(&lv, &cd_G4x12y3);
    dp->~G4x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y3(Test_G4x12y3, "G4x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G4x12y3C1Ev();
extern void _ZN7G4x12y3D1Ev();
Name_Map name_map_G4x12y3[] = {
  NSPAIR(_ZN7G4x12y3C1Ev),
  NSPAIR(_ZN7G4x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G4x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y3[];
extern void _ZN5E4x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G4x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y3[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G4x12y3[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G4x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G4x12y3[];
static  VTT_ENTRY vtt_G4x12y3[] = {
  {&(_ZTV7G4x12y3[4]),  4,12},
  {&(_ZTV7G4x12y3[7]),  7,12},
  {&(_ZTV7G4x12y3[11]),  11,12},
};
extern VTBL_ENTRY _ZTI7G4x12y3[];
extern  VTBL_ENTRY _ZTV7G4x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G4x12y3[];
Class_Descriptor cd_G4x12y3 = {  "G4x12y3", // class name
  bases_G4x12y3, 6,
  &(vtc_G4x12y3[0]), // expected_vtbl_contents
  &(vtt_G4x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G4x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y3),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G4x12y3),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y4  : E4x12 , F0 {
  int ff;
  ~G4x12y4(); // tgen
  G4x12y4(); // tgen
};
//SIG(1 G4x12y4) C1{ BC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G4x12y4 ::~G4x12y4(){ note_dtor("G4x12y4", this);} // tgen
G4x12y4 ::G4x12y4(){ note_ctor("G4x12y4", this);} // tgen

static void Test_G4x12y4()
{
  extern Class_Descriptor cd_G4x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G4x12y4, buf);
    G4x12y4 *dp, &lv = *(dp=new (buf) G4x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G4x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y4)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(12,8), "G4x12y4");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), 0, "G4x12y4");
    check_base_class_offset(lv, (C4*)(E4x12*), 0, "G4x12y4");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(20,16), "G4x12y4");
    check_base_class_offset(lv, (E4x12*), 0, "G4x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(28,24), "G4x12y4");
    check_field_offset(lv, ff, ABISELECT(32,28), "G4x12y4.ff");
    test_class_info(&lv, &cd_G4x12y4);
    dp->~G4x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y4(Test_G4x12y4, "G4x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G4x12y4C1Ev();
extern void _ZN7G4x12y4D1Ev();
Name_Map name_map_G4x12y4[] = {
  NSPAIR(_ZN7G4x12y4C1Ev),
  NSPAIR(_ZN7G4x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G4x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y4[];
extern void _ZN5E4x123fooEv();
static  VTBL_ENTRY vtc_G4x12y4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y4[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
};
extern VTBL_ENTRY _ZTI7G4x12y4[];
extern  VTBL_ENTRY _ZTV7G4x12y4[];
Class_Descriptor cd_G4x12y4 = {  "G4x12y4", // class name
  bases_G4x12y4, 6,
  &(vtc_G4x12y4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G4x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y5  : virtual E4x12 , F0 {
  int ff;
  ~G4x12y5(); // tgen
  G4x12y5(); // tgen
};
//SIG(1 G4x12y5) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G4x12y5 ::~G4x12y5(){ note_dtor("G4x12y5", this);} // tgen
G4x12y5 ::G4x12y5(){ note_ctor("G4x12y5", this);} // tgen

static void Test_G4x12y5()
{
  extern Class_Descriptor cd_G4x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G4x12y5, buf);
    G4x12y5 *dp, &lv = *(dp=new (buf) G4x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G4x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y5)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(28,20), "G4x12y5");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), ABISELECT(16,12), "G4x12y5");
    check_base_class_offset(lv, (C4*)(E4x12*), ABISELECT(16,12), "G4x12y5");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(36,28), "G4x12y5");
    check_base_class_offset(lv, (E4x12*), ABISELECT(16,12), "G4x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G4x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G4x12y5.ff");
    test_class_info(&lv, &cd_G4x12y5);
    dp->~G4x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y5(Test_G4x12y5, "G4x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G4x12y5C1Ev();
extern void _ZN7G4x12y5D1Ev();
Name_Map name_map_G4x12y5[] = {
  NSPAIR(_ZN7G4x12y5C1Ev),
  NSPAIR(_ZN7G4x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G4x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y5[];
extern void _ZN5E4x123fooEv();
static  VTBL_ENTRY vtc_G4x12y5[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y5[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G4x12y5[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
};
extern VTBL_ENTRY _ZTV7G4x12y5[];
static  VTT_ENTRY vtt_G4x12y5[] = {
  {&(_ZTV7G4x12y5[3]),  3,7},
  {&(_ZTV7G4x12y5[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7G4x12y5[];
extern  VTBL_ENTRY _ZTV7G4x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G4x12y5[];
Class_Descriptor cd_G4x12y5 = {  "G4x12y5", // class name
  bases_G4x12y5, 6,
  &(vtc_G4x12y5[0]), // expected_vtbl_contents
  &(vtt_G4x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G4x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y5),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G4x12y5),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y6  : E4x12 , virtual F0 {
  int ff;
  ~G4x12y6(); // tgen
  G4x12y6(); // tgen
};
//SIG(1 G4x12y6) C1{ BC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G4x12y6 ::~G4x12y6(){ note_dtor("G4x12y6", this);} // tgen
G4x12y6 ::G4x12y6(){ note_ctor("G4x12y6", this);} // tgen

static void Test_G4x12y6()
{
  extern Class_Descriptor cd_G4x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G4x12y6, buf);
    G4x12y6 *dp, &lv = *(dp=new (buf) G4x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G4x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y6)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(12,8), "G4x12y6");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), 0, "G4x12y6");
    check_base_class_offset(lv, (C4*)(E4x12*), 0, "G4x12y6");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(20,16), "G4x12y6");
    check_base_class_offset(lv, (E4x12*), 0, "G4x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G4x12y6");
    check_field_offset(lv, ff, ABISELECT(28,24), "G4x12y6.ff");
    test_class_info(&lv, &cd_G4x12y6);
    dp->~G4x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y6(Test_G4x12y6, "G4x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G4x12y6C1Ev();
extern void _ZN7G4x12y6D1Ev();
Name_Map name_map_G4x12y6[] = {
  NSPAIR(_ZN7G4x12y6C1Ev),
  NSPAIR(_ZN7G4x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G4x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y6[];
extern void _ZN5E4x123fooEv();
static  VTBL_ENTRY vtc_G4x12y6[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y6[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
};
extern VTBL_ENTRY _ZTV7G4x12y6[];
static  VTT_ENTRY vtt_G4x12y6[] = {
  {&(_ZTV7G4x12y6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G4x12y6[];
extern  VTBL_ENTRY _ZTV7G4x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G4x12y6[];
Class_Descriptor cd_G4x12y6 = {  "G4x12y6", // class name
  bases_G4x12y6, 6,
  &(vtc_G4x12y6[0]), // expected_vtbl_contents
  &(vtt_G4x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G4x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y6),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G4x12y6),1, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G4x12y7  : virtual E4x12 , virtual F0 {
  int ff;
  ~G4x12y7(); // tgen
  G4x12y7(); // tgen
};
//SIG(1 G4x12y7) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G4x12y7 ::~G4x12y7(){ note_dtor("G4x12y7", this);} // tgen
G4x12y7 ::G4x12y7(){ note_ctor("G4x12y7", this);} // tgen

static void Test_G4x12y7()
{
  extern Class_Descriptor cd_G4x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G4x12y7, buf);
    G4x12y7 *dp, &lv = *(dp=new (buf) G4x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G4x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G4x12y7)");
    check_base_class_offset(lv, (A0*)(C4*)(E4x12*), ABISELECT(28,16), "G4x12y7");
    check_base_class_offset(lv, (B1*)(C4*)(E4x12*), ABISELECT(16,8), "G4x12y7");
    check_base_class_offset(lv, (C4*)(E4x12*), ABISELECT(16,8), "G4x12y7");
    check_base_class_offset(lv, (D0*)(E4x12*), ABISELECT(36,24), "G4x12y7");
    check_base_class_offset(lv, (E4x12*), ABISELECT(16,8), "G4x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G4x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G4x12y7.ff");
    test_class_info(&lv, &cd_G4x12y7);
    dp->~G4x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG4x12y7(Test_G4x12y7, "G4x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G4x12y7C1Ev();
extern void _ZN7G4x12y7D1Ev();
Name_Map name_map_G4x12y7[] = {
  NSPAIR(_ZN7G4x12y7C1Ev),
  NSPAIR(_ZN7G4x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C4;
extern VTBL_ENTRY _ZTI2C4[];
extern  VTBL_ENTRY _ZTV2C4[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E4x12;
extern VTBL_ENTRY _ZTI5E4x12[];
extern  VTBL_ENTRY _ZTV5E4x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G4x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C4,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E4x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G4x12y7[];
extern void _ZN5E4x123fooEv();
static  VTBL_ENTRY vtc_G4x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G4x12y7[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G4x12y7[0]),
  (VTBL_ENTRY)&_ZN5E4x123fooEv,
};
extern VTBL_ENTRY _ZTV7G4x12y7[];
static  VTT_ENTRY vtt_G4x12y7[] = {
  {&(_ZTV7G4x12y7[4]),  4,8},
  {&(_ZTV7G4x12y7[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G4x12y7[];
extern  VTBL_ENTRY _ZTV7G4x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G4x12y7[];
Class_Descriptor cd_G4x12y7 = {  "G4x12y7", // class name
  bases_G4x12y7, 6,
  &(vtc_G4x12y7[0]), // expected_vtbl_contents
  &(vtt_G4x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G4x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G4x12y7),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G4x12y7),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E5x12  : C5 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E5x123fooEv
  ~E5x12(); // tgen
  E5x12(); // tgen
};
//SIG(-1 E5x12) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E5x12 ::foo(){vfunc_called(this, "_ZN5E5x123fooEv");}
E5x12 ::~E5x12(){ note_dtor("E5x12", this);} // tgen
E5x12 ::E5x12(){ note_ctor("E5x12", this);} // tgen

static void Test_E5x12()
{
  extern Class_Descriptor cd_E5x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E5x12, buf);
    E5x12 *dp, &lv = *(dp=new (buf) E5x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E5x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E5x12)");
    check_base_class_offset(lv, (A1*)(C5*), 0, "E5x12");
    check_base_class_offset(lv, (B1*)(C5*), ABISELECT(16,8), "E5x12");
    check_base_class_offset(lv, (C5*), 0, "E5x12");
    check_base_class_offset(lv, (D0*), ABISELECT(32,20), "E5x12");
    check_field_offset(lv, fd, ABISELECT(36,24), "E5x12.fd");
    test_class_info(&lv, &cd_E5x12);
    dp->~E5x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE5x12(Test_E5x12, "E5x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN5E5x12C1Ev();
extern void _ZN5E5x12D1Ev();
Name_Map name_map_E5x12[] = {
  NSPAIR(_ZN5E5x12C1Ev),
  NSPAIR(_ZN5E5x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E5x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E5x12[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
static  VTBL_ENTRY vtc_E5x12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5E5x12[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5E5x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
};
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
Class_Descriptor cd_E5x12 = {  "E5x12", // class name
  bases_E5x12, 4,
  &(vtc_E5x12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI5E5x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E5x12),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y0  : E5x12 , F1 {
  int ff;
  ~G5x12y0(); // tgen
  G5x12y0(); // tgen
};
//SIG(1 G5x12y0) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G5x12y0 ::~G5x12y0(){ note_dtor("G5x12y0", this);} // tgen
G5x12y0 ::G5x12y0(){ note_ctor("G5x12y0", this);} // tgen

static void Test_G5x12y0()
{
  extern Class_Descriptor cd_G5x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G5x12y0, buf);
    G5x12y0 *dp, &lv = *(dp=new (buf) G5x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G5x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y0)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), 0, "G5x12y0");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(16,8), "G5x12y0");
    check_base_class_offset(lv, (C5*)(E5x12*), 0, "G5x12y0");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(32,20), "G5x12y0");
    check_base_class_offset(lv, (E5x12*), 0, "G5x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(40,28), "G5x12y0");
    check_field_offset(lv, ff, ABISELECT(52,36), "G5x12y0.ff");
    test_class_info(&lv, &cd_G5x12y0);
    dp->~G5x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y0(Test_G5x12y0, "G5x12y0", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G5x12y0C1Ev();
extern void _ZN7G5x12y0D1Ev();
Name_Map name_map_G5x12y0[] = {
  NSPAIR(_ZN7G5x12y0C1Ev),
  NSPAIR(_ZN7G5x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G5x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(40,28), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y0[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G5x12y0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y0[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G5x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7G5x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTI7G5x12y0[];
extern  VTBL_ENTRY _ZTV7G5x12y0[];
Class_Descriptor cd_G5x12y0 = {  "G5x12y0", // class name
  bases_G5x12y0, 6,
  &(vtc_G5x12y0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G5x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y0),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y1  : virtual E5x12 , F1 {
  int ff;
  ~G5x12y1(); // tgen
  G5x12y1(); // tgen
};
//SIG(1 G5x12y1) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G5x12y1 ::~G5x12y1(){ note_dtor("G5x12y1", this);} // tgen
G5x12y1 ::G5x12y1(){ note_ctor("G5x12y1", this);} // tgen

static void Test_G5x12y1()
{
  extern Class_Descriptor cd_G5x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G5x12y1, buf);
    G5x12y1 *dp, &lv = *(dp=new (buf) G5x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G5x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y1)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), ABISELECT(16,12), "G5x12y1");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(32,20), "G5x12y1");
    check_base_class_offset(lv, (C5*)(E5x12*), ABISELECT(16,12), "G5x12y1");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(48,32), "G5x12y1");
    check_base_class_offset(lv, (E5x12*), ABISELECT(16,12), "G5x12y1");
    check_base_class_offset(lv, (F1*), 0, "G5x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G5x12y1.ff");
    test_class_info(&lv, &cd_G5x12y1);
    dp->~G5x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y1(Test_G5x12y1, "G5x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G5x12y1C1Ev();
extern void _ZN7G5x12y1D1Ev();
Name_Map name_map_G5x12y1[] = {
  NSPAIR(_ZN7G5x12y1C1Ev),
  NSPAIR(_ZN7G5x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G5x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
static  VTBL_ENTRY vtc_G5x12y1[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G5x12y1[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7G5x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
};
extern VTBL_ENTRY _ZTV7G5x12y1[];
static  VTT_ENTRY vtt_G5x12y1[] = {
  {&(_ZTV7G5x12y1[3]),  3,11},
  {&(_ZTV7G5x12y1[7]),  7,11},
  {&(_ZTV7G5x12y1[10]),  10,11},
};
extern VTBL_ENTRY _ZTI7G5x12y1[];
extern  VTBL_ENTRY _ZTV7G5x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G5x12y1[];
Class_Descriptor cd_G5x12y1 = {  "G5x12y1", // class name
  bases_G5x12y1, 6,
  &(vtc_G5x12y1[0]), // expected_vtbl_contents
  &(vtt_G5x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G5x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y1),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G5x12y1),3, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y2  : E5x12 , virtual F1 {
  int ff;
  ~G5x12y2(); // tgen
  G5x12y2(); // tgen
};
//SIG(1 G5x12y2) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G5x12y2 ::~G5x12y2(){ note_dtor("G5x12y2", this);} // tgen
G5x12y2 ::G5x12y2(){ note_ctor("G5x12y2", this);} // tgen

static void Test_G5x12y2()
{
  extern Class_Descriptor cd_G5x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G5x12y2, buf);
    G5x12y2 *dp, &lv = *(dp=new (buf) G5x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G5x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y2)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), 0, "G5x12y2");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(16,8), "G5x12y2");
    check_base_class_offset(lv, (C5*)(E5x12*), 0, "G5x12y2");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(32,20), "G5x12y2");
    check_base_class_offset(lv, (E5x12*), 0, "G5x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G5x12y2");
    check_field_offset(lv, ff, ABISELECT(40,28), "G5x12y2.ff");
    test_class_info(&lv, &cd_G5x12y2);
    dp->~G5x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y2(Test_G5x12y2, "G5x12y2", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G5x12y2C1Ev();
extern void _ZN7G5x12y2D1Ev();
Name_Map name_map_G5x12y2[] = {
  NSPAIR(_ZN7G5x12y2C1Ev),
  NSPAIR(_ZN7G5x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G5x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y2[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G5x12y2[] = {
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y2[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G5x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G5x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G5x12y2[];
static  VTT_ENTRY vtt_G5x12y2[] = {
  {&(_ZTV7G5x12y2[3]),  3,11},
  {&(_ZTV7G5x12y2[10]),  10,11},
};
extern VTBL_ENTRY _ZTI7G5x12y2[];
extern  VTBL_ENTRY _ZTV7G5x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G5x12y2[];
Class_Descriptor cd_G5x12y2 = {  "G5x12y2", // class name
  bases_G5x12y2, 6,
  &(vtc_G5x12y2[0]), // expected_vtbl_contents
  &(vtt_G5x12y2[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G5x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y2),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G5x12y2),2, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y3  : virtual E5x12 , virtual F1 {
  int ff;
  ~G5x12y3(); // tgen
  G5x12y3(); // tgen
};
//SIG(1 G5x12y3) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G5x12y3 ::~G5x12y3(){ note_dtor("G5x12y3", this);} // tgen
G5x12y3 ::G5x12y3(){ note_ctor("G5x12y3", this);} // tgen

static void Test_G5x12y3()
{
  extern Class_Descriptor cd_G5x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G5x12y3, buf);
    G5x12y3 *dp, &lv = *(dp=new (buf) G5x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G5x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y3)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), ABISELECT(16,8), "G5x12y3");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(32,16), "G5x12y3");
    check_base_class_offset(lv, (C5*)(E5x12*), ABISELECT(16,8), "G5x12y3");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(48,28), "G5x12y3");
    check_base_class_offset(lv, (E5x12*), ABISELECT(16,8), "G5x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G5x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G5x12y3.ff");
    test_class_info(&lv, &cd_G5x12y3);
    dp->~G5x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y3(Test_G5x12y3, "G5x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN7G5x12y3C1Ev();
extern void _ZN7G5x12y3D1Ev();
Name_Map name_map_G5x12y3[] = {
  NSPAIR(_ZN7G5x12y3C1Ev),
  NSPAIR(_ZN7G5x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G5x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y3[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G5x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y3[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G5x12y3[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7G5x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7G5x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G5x12y3[];
static  VTT_ENTRY vtt_G5x12y3[] = {
  {&(_ZTV7G5x12y3[4]),  4,15},
  {&(_ZTV7G5x12y3[7]),  7,15},
  {&(_ZTV7G5x12y3[10]),  10,15},
  {&(_ZTV7G5x12y3[14]),  14,15},
};
extern VTBL_ENTRY _ZTI7G5x12y3[];
extern  VTBL_ENTRY _ZTV7G5x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G5x12y3[];
Class_Descriptor cd_G5x12y3 = {  "G5x12y3", // class name
  bases_G5x12y3, 6,
  &(vtc_G5x12y3[0]), // expected_vtbl_contents
  &(vtt_G5x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI7G5x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y3),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G5x12y3),4, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y4  : E5x12 , F0 {
  int ff;
  ~G5x12y4(); // tgen
  G5x12y4(); // tgen
};
//SIG(1 G5x12y4) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G5x12y4 ::~G5x12y4(){ note_dtor("G5x12y4", this);} // tgen
G5x12y4 ::G5x12y4(){ note_ctor("G5x12y4", this);} // tgen

static void Test_G5x12y4()
{
  extern Class_Descriptor cd_G5x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G5x12y4, buf);
    G5x12y4 *dp, &lv = *(dp=new (buf) G5x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G5x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y4)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), 0, "G5x12y4");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(16,8), "G5x12y4");
    check_base_class_offset(lv, (C5*)(E5x12*), 0, "G5x12y4");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(32,20), "G5x12y4");
    check_base_class_offset(lv, (E5x12*), 0, "G5x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(40,28), "G5x12y4");
    check_field_offset(lv, ff, ABISELECT(44,32), "G5x12y4.ff");
    test_class_info(&lv, &cd_G5x12y4);
    dp->~G5x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y4(Test_G5x12y4, "G5x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G5x12y4C1Ev();
extern void _ZN7G5x12y4D1Ev();
Name_Map name_map_G5x12y4[] = {
  NSPAIR(_ZN7G5x12y4C1Ev),
  NSPAIR(_ZN7G5x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G5x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y4[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
static  VTBL_ENTRY vtc_G5x12y4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y4[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G5x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
};
extern VTBL_ENTRY _ZTI7G5x12y4[];
extern  VTBL_ENTRY _ZTV7G5x12y4[];
Class_Descriptor cd_G5x12y4 = {  "G5x12y4", // class name
  bases_G5x12y4, 6,
  &(vtc_G5x12y4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G5x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y4),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y5  : virtual E5x12 , F0 {
  int ff;
  ~G5x12y5(); // tgen
  G5x12y5(); // tgen
};
//SIG(1 G5x12y5) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G5x12y5 ::~G5x12y5(){ note_dtor("G5x12y5", this);} // tgen
G5x12y5 ::G5x12y5(){ note_ctor("G5x12y5", this);} // tgen

static void Test_G5x12y5()
{
  extern Class_Descriptor cd_G5x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G5x12y5, buf);
    G5x12y5 *dp, &lv = *(dp=new (buf) G5x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G5x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y5)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), ABISELECT(16,12), "G5x12y5");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(32,20), "G5x12y5");
    check_base_class_offset(lv, (C5*)(E5x12*), ABISELECT(16,12), "G5x12y5");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(48,32), "G5x12y5");
    check_base_class_offset(lv, (E5x12*), ABISELECT(16,12), "G5x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G5x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G5x12y5.ff");
    test_class_info(&lv, &cd_G5x12y5);
    dp->~G5x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y5(Test_G5x12y5, "G5x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G5x12y5C1Ev();
extern void _ZN7G5x12y5D1Ev();
Name_Map name_map_G5x12y5[] = {
  NSPAIR(_ZN7G5x12y5C1Ev),
  NSPAIR(_ZN7G5x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G5x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y5[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
static  VTBL_ENTRY vtc_G5x12y5[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y5[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G5x12y5[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7G5x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
};
extern VTBL_ENTRY _ZTV7G5x12y5[];
static  VTT_ENTRY vtt_G5x12y5[] = {
  {&(_ZTV7G5x12y5[3]),  3,10},
  {&(_ZTV7G5x12y5[6]),  6,10},
  {&(_ZTV7G5x12y5[9]),  9,10},
};
extern VTBL_ENTRY _ZTI7G5x12y5[];
extern  VTBL_ENTRY _ZTV7G5x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G5x12y5[];
Class_Descriptor cd_G5x12y5 = {  "G5x12y5", // class name
  bases_G5x12y5, 6,
  &(vtc_G5x12y5[0]), // expected_vtbl_contents
  &(vtt_G5x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G5x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y5),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G5x12y5),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y6  : E5x12 , virtual F0 {
  int ff;
  ~G5x12y6(); // tgen
  G5x12y6(); // tgen
};
//SIG(1 G5x12y6) C1{ BC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G5x12y6 ::~G5x12y6(){ note_dtor("G5x12y6", this);} // tgen
G5x12y6 ::G5x12y6(){ note_ctor("G5x12y6", this);} // tgen

static void Test_G5x12y6()
{
  extern Class_Descriptor cd_G5x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G5x12y6, buf);
    G5x12y6 *dp, &lv = *(dp=new (buf) G5x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G5x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y6)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), 0, "G5x12y6");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(16,8), "G5x12y6");
    check_base_class_offset(lv, (C5*)(E5x12*), 0, "G5x12y6");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(32,20), "G5x12y6");
    check_base_class_offset(lv, (E5x12*), 0, "G5x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G5x12y6");
    check_field_offset(lv, ff, ABISELECT(40,28), "G5x12y6.ff");
    test_class_info(&lv, &cd_G5x12y6);
    dp->~G5x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y6(Test_G5x12y6, "G5x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G5x12y6C1Ev();
extern void _ZN7G5x12y6D1Ev();
Name_Map name_map_G5x12y6[] = {
  NSPAIR(_ZN7G5x12y6C1Ev),
  NSPAIR(_ZN7G5x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G5x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y6[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
static  VTBL_ENTRY vtc_G5x12y6[] = {
  ABISELECT(44,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y6[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G5x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
};
extern VTBL_ENTRY _ZTV7G5x12y6[];
static  VTT_ENTRY vtt_G5x12y6[] = {
  {&(_ZTV7G5x12y6[3]),  3,7},
};
extern VTBL_ENTRY _ZTI7G5x12y6[];
extern  VTBL_ENTRY _ZTV7G5x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G5x12y6[];
Class_Descriptor cd_G5x12y6 = {  "G5x12y6", // class name
  bases_G5x12y6, 6,
  &(vtc_G5x12y6[0]), // expected_vtbl_contents
  &(vtt_G5x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G5x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y6),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G5x12y6),1, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G5x12y7  : virtual E5x12 , virtual F0 {
  int ff;
  ~G5x12y7(); // tgen
  G5x12y7(); // tgen
};
//SIG(1 G5x12y7) C1{ VBC2{ BC3{ BC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G5x12y7 ::~G5x12y7(){ note_dtor("G5x12y7", this);} // tgen
G5x12y7 ::G5x12y7(){ note_ctor("G5x12y7", this);} // tgen

static void Test_G5x12y7()
{
  extern Class_Descriptor cd_G5x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G5x12y7, buf);
    G5x12y7 *dp, &lv = *(dp=new (buf) G5x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G5x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G5x12y7)");
    check_base_class_offset(lv, (A1*)(C5*)(E5x12*), ABISELECT(16,8), "G5x12y7");
    check_base_class_offset(lv, (B1*)(C5*)(E5x12*), ABISELECT(32,16), "G5x12y7");
    check_base_class_offset(lv, (C5*)(E5x12*), ABISELECT(16,8), "G5x12y7");
    check_base_class_offset(lv, (D0*)(E5x12*), ABISELECT(48,28), "G5x12y7");
    check_base_class_offset(lv, (E5x12*), ABISELECT(16,8), "G5x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(56,36), "G5x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G5x12y7.ff");
    test_class_info(&lv, &cd_G5x12y7);
    dp->~G5x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG5x12y7(Test_G5x12y7, "G5x12y7", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G5x12y7C1Ev();
extern void _ZN7G5x12y7D1Ev();
Name_Map name_map_G5x12y7[] = {
  NSPAIR(_ZN7G5x12y7C1Ev),
  NSPAIR(_ZN7G5x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C5;
extern VTBL_ENTRY _ZTI2C5[];
extern  VTBL_ENTRY _ZTV2C5[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E5x12;
extern VTBL_ENTRY _ZTI5E5x12[];
extern  VTBL_ENTRY _ZTV5E5x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G5x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C5,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E5x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G5x12y7[];
extern void _ZN5E5x123fooEv();
extern void ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv)();
static  VTBL_ENTRY vtc_G5x12y7[] = {
  ABISELECT(56,36),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G5x12y7[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G5x12y7[0]),
  (VTBL_ENTRY)&_ZN5E5x123fooEv,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7G5x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N5E5x123fooEv,_ZThn8_N5E5x123fooEv),
};
extern VTBL_ENTRY _ZTV7G5x12y7[];
static  VTT_ENTRY vtt_G5x12y7[] = {
  {&(_ZTV7G5x12y7[4]),  4,11},
  {&(_ZTV7G5x12y7[7]),  7,11},
  {&(_ZTV7G5x12y7[10]),  10,11},
};
extern VTBL_ENTRY _ZTI7G5x12y7[];
extern  VTBL_ENTRY _ZTV7G5x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G5x12y7[];
Class_Descriptor cd_G5x12y7 = {  "G5x12y7", // class name
  bases_G5x12y7, 6,
  &(vtc_G5x12y7[0]), // expected_vtbl_contents
  &(vtt_G5x12y7[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G5x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G5x12y7),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G5x12y7),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E6x12  : C6 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E6x123fooEv
  ~E6x12(); // tgen
  E6x12(); // tgen
};
//SIG(-1 E6x12) C1{ BC2{ VBC3{ Fi} BC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E6x12 ::foo(){vfunc_called(this, "_ZN5E6x123fooEv");}
E6x12 ::~E6x12(){ note_dtor("E6x12", this);} // tgen
E6x12 ::E6x12(){ note_ctor("E6x12", this);} // tgen

static void Test_E6x12()
{
  extern Class_Descriptor cd_E6x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E6x12, buf);
    E6x12 *dp, &lv = *(dp=new (buf) E6x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E6x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E6x12)");
    check_base_class_offset(lv, (A0*)(C6*), ABISELECT(24,20), "E6x12");
    check_base_class_offset(lv, (B1*)(C6*), 0, "E6x12");
    check_base_class_offset(lv, (C6*), 0, "E6x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E6x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E6x12.fd");
    test_class_info(&lv, &cd_E6x12);
    dp->~E6x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE6x12(Test_E6x12, "E6x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E6x12C1Ev();
extern void _ZN5E6x12D1Ev();
Name_Map name_map_E6x12[] = {
  NSPAIR(_ZN5E6x12C1Ev),
  NSPAIR(_ZN5E6x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E6x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E6x12[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY vtc_E6x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern VTBL_ENTRY _ZTV5E6x12[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C6__5E6x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_E6x12[] = {
  {&(_ZTV5E6x12[3]),  3,4},
  {&(_tg__ZTV2C6__5E6x12[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
Class_Descriptor cd_E6x12 = {  "E6x12", // class name
  bases_E6x12, 4,
  &(vtc_E6x12[0]), // expected_vtbl_contents
  &(vtt_E6x12[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E6x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E6x12),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5E6x12),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y0  : E6x12 , F1 {
  int ff;
  ~G6x12y0(); // tgen
  G6x12y0(); // tgen
};
//SIG(1 G6x12y0) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G6x12y0 ::~G6x12y0(){ note_dtor("G6x12y0", this);} // tgen
G6x12y0 ::G6x12y0(){ note_ctor("G6x12y0", this);} // tgen

static void Test_G6x12y0()
{
  extern Class_Descriptor cd_G6x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G6x12y0, buf);
    G6x12y0 *dp, &lv = *(dp=new (buf) G6x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G6x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y0)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(40,32), "G6x12y0");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), 0, "G6x12y0");
    check_base_class_offset(lv, (C6*)(E6x12*), 0, "G6x12y0");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(16,12), "G6x12y0");
    check_base_class_offset(lv, (E6x12*), 0, "G6x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G6x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G6x12y0.ff");
    test_class_info(&lv, &cd_G6x12y0);
    dp->~G6x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y0(Test_G6x12y0, "G6x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G6x12y0C1Ev();
extern void _ZN7G6x12y0D1Ev();
Name_Map name_map_G6x12y0[] = {
  NSPAIR(_ZN7G6x12y0C1Ev),
  NSPAIR(_ZN7G6x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G6x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y0[];
extern void _ZN5E6x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G6x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y0[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI7G6x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y0[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y0[] = {
  {&(_ZTV7G6x12y0[3]),  3,7},
  {&(_tg__ZTV5E6x12__7G6x12y0[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y0[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y0[];
extern  VTBL_ENTRY _ZTV7G6x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y0[];
Class_Descriptor cd_G6x12y0 = {  "G6x12y0", // class name
  bases_G6x12y0, 6,
  &(vtc_G6x12y0[0]), // expected_vtbl_contents
  &(vtt_G6x12y0[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G6x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y0),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y0),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y1  : virtual E6x12 , F1 {
  int ff;
  ~G6x12y1(); // tgen
  G6x12y1(); // tgen
};
//SIG(1 G6x12y1) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G6x12y1 ::~G6x12y1(){ note_dtor("G6x12y1", this);} // tgen
G6x12y1 ::G6x12y1(){ note_ctor("G6x12y1", this);} // tgen

static void Test_G6x12y1()
{
  extern Class_Descriptor cd_G6x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G6x12y1, buf);
    G6x12y1 *dp, &lv = *(dp=new (buf) G6x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G6x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y1)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(40,32), "G6x12y1");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), ABISELECT(16,12), "G6x12y1");
    check_base_class_offset(lv, (C6*)(E6x12*), ABISELECT(16,12), "G6x12y1");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(32,24), "G6x12y1");
    check_base_class_offset(lv, (E6x12*), ABISELECT(16,12), "G6x12y1");
    check_base_class_offset(lv, (F1*), 0, "G6x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G6x12y1.ff");
    test_class_info(&lv, &cd_G6x12y1);
    dp->~G6x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y1(Test_G6x12y1, "G6x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G6x12y1C1Ev();
extern void _ZN7G6x12y1D1Ev();
Name_Map name_map_G6x12y1[] = {
  NSPAIR(_ZN7G6x12y1C1Ev),
  NSPAIR(_ZN7G6x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G6x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY vtc_G6x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G6x12y1[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y1[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y1[] = {
  {&(_ZTV7G6x12y1[4]),  4,10},
  {&(_ZTV7G6x12y1[9]),  9,10},
  {&(_tg__ZTV5E6x12__7G6x12y1[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y1[];
extern  VTBL_ENTRY _ZTV7G6x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y1[];
Class_Descriptor cd_G6x12y1 = {  "G6x12y1", // class name
  bases_G6x12y1, 6,
  &(vtc_G6x12y1[0]), // expected_vtbl_contents
  &(vtt_G6x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G6x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y1),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y1),4, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y2  : E6x12 , virtual F1 {
  int ff;
  ~G6x12y2(); // tgen
  G6x12y2(); // tgen
};
//SIG(1 G6x12y2) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G6x12y2 ::~G6x12y2(){ note_dtor("G6x12y2", this);} // tgen
G6x12y2 ::G6x12y2(){ note_ctor("G6x12y2", this);} // tgen

static void Test_G6x12y2()
{
  extern Class_Descriptor cd_G6x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G6x12y2, buf);
    G6x12y2 *dp, &lv = *(dp=new (buf) G6x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G6x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y2)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(28,24), "G6x12y2");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), 0, "G6x12y2");
    check_base_class_offset(lv, (C6*)(E6x12*), 0, "G6x12y2");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(16,12), "G6x12y2");
    check_base_class_offset(lv, (E6x12*), 0, "G6x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G6x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G6x12y2.ff");
    test_class_info(&lv, &cd_G6x12y2);
    dp->~G6x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y2(Test_G6x12y2, "G6x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G6x12y2C1Ev();
extern void _ZN7G6x12y2D1Ev();
Name_Map name_map_G6x12y2[] = {
  NSPAIR(_ZN7G6x12y2C1Ev),
  NSPAIR(_ZN7G6x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G6x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y2[];
extern void _ZN5E6x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G6x12y2[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y2[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G6x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y2[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y2[] = {
  {&(_ZTV7G6x12y2[4]),  4,9},
  {&(_tg__ZTV5E6x12__7G6x12y2[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y2[3]),  3,4},
  {&(_ZTV7G6x12y2[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7G6x12y2[];
extern  VTBL_ENTRY _ZTV7G6x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y2[];
Class_Descriptor cd_G6x12y2 = {  "G6x12y2", // class name
  bases_G6x12y2, 6,
  &(vtc_G6x12y2[0]), // expected_vtbl_contents
  &(vtt_G6x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G6x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y2),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y2),4, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y3  : virtual E6x12 , virtual F1 {
  int ff;
  ~G6x12y3(); // tgen
  G6x12y3(); // tgen
};
//SIG(1 G6x12y3) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G6x12y3 ::~G6x12y3(){ note_dtor("G6x12y3", this);} // tgen
G6x12y3 ::G6x12y3(){ note_ctor("G6x12y3", this);} // tgen

static void Test_G6x12y3()
{
  extern Class_Descriptor cd_G6x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G6x12y3, buf);
    G6x12y3 *dp, &lv = *(dp=new (buf) G6x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G6x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y3)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(40,28), "G6x12y3");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), ABISELECT(16,8), "G6x12y3");
    check_base_class_offset(lv, (C6*)(E6x12*), ABISELECT(16,8), "G6x12y3");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(32,20), "G6x12y3");
    check_base_class_offset(lv, (E6x12*), ABISELECT(16,8), "G6x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G6x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G6x12y3.ff");
    test_class_info(&lv, &cd_G6x12y3);
    dp->~G6x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y3(Test_G6x12y3, "G6x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G6x12y3C1Ev();
extern void _ZN7G6x12y3D1Ev();
Name_Map name_map_G6x12y3[] = {
  NSPAIR(_ZN7G6x12y3C1Ev),
  NSPAIR(_ZN7G6x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G6x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y3[];
extern void _ZN5E6x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G6x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G6x12y3[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G6x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y3[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y3[] = {
  {&(_ZTV7G6x12y3[5]),  5,14},
  {&(_ZTV7G6x12y3[9]),  9,14},
  {&(_ZTV7G6x12y3[13]),  13,14},
  {&(_tg__ZTV5E6x12__7G6x12y3[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y3[];
extern  VTBL_ENTRY _ZTV7G6x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y3[];
Class_Descriptor cd_G6x12y3 = {  "G6x12y3", // class name
  bases_G6x12y3, 6,
  &(vtc_G6x12y3[0]), // expected_vtbl_contents
  &(vtt_G6x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G6x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y3),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y3),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y4  : E6x12 , F0 {
  int ff;
  ~G6x12y4(); // tgen
  G6x12y4(); // tgen
};
//SIG(1 G6x12y4) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G6x12y4 ::~G6x12y4(){ note_dtor("G6x12y4", this);} // tgen
G6x12y4 ::G6x12y4(){ note_ctor("G6x12y4", this);} // tgen

static void Test_G6x12y4()
{
  extern Class_Descriptor cd_G6x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G6x12y4, buf);
    G6x12y4 *dp, &lv = *(dp=new (buf) G6x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G6x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y4)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(32,28), "G6x12y4");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), 0, "G6x12y4");
    check_base_class_offset(lv, (C6*)(E6x12*), 0, "G6x12y4");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(16,12), "G6x12y4");
    check_base_class_offset(lv, (E6x12*), 0, "G6x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G6x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G6x12y4.ff");
    test_class_info(&lv, &cd_G6x12y4);
    dp->~G6x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y4(Test_G6x12y4, "G6x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G6x12y4C1Ev();
extern void _ZN7G6x12y4D1Ev();
Name_Map name_map_G6x12y4[] = {
  NSPAIR(_ZN7G6x12y4C1Ev),
  NSPAIR(_ZN7G6x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G6x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y4[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY vtc_G6x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y4[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y4[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y4[] = {
  {&(_ZTV7G6x12y4[3]),  3,4},
  {&(_tg__ZTV5E6x12__7G6x12y4[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y4[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y4[];
extern  VTBL_ENTRY _ZTV7G6x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y4[];
Class_Descriptor cd_G6x12y4 = {  "G6x12y4", // class name
  bases_G6x12y4, 6,
  &(vtc_G6x12y4[0]), // expected_vtbl_contents
  &(vtt_G6x12y4[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G6x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y4),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y4),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y5  : virtual E6x12 , F0 {
  int ff;
  ~G6x12y5(); // tgen
  G6x12y5(); // tgen
};
//SIG(1 G6x12y5) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G6x12y5 ::~G6x12y5(){ note_dtor("G6x12y5", this);} // tgen
G6x12y5 ::G6x12y5(){ note_ctor("G6x12y5", this);} // tgen

static void Test_G6x12y5()
{
  extern Class_Descriptor cd_G6x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G6x12y5, buf);
    G6x12y5 *dp, &lv = *(dp=new (buf) G6x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G6x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y5)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(40,32), "G6x12y5");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), ABISELECT(16,12), "G6x12y5");
    check_base_class_offset(lv, (C6*)(E6x12*), ABISELECT(16,12), "G6x12y5");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(32,24), "G6x12y5");
    check_base_class_offset(lv, (E6x12*), ABISELECT(16,12), "G6x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G6x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G6x12y5.ff");
    test_class_info(&lv, &cd_G6x12y5);
    dp->~G6x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y5(Test_G6x12y5, "G6x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G6x12y5C1Ev();
extern void _ZN7G6x12y5D1Ev();
Name_Map name_map_G6x12y5[] = {
  NSPAIR(_ZN7G6x12y5C1Ev),
  NSPAIR(_ZN7G6x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G6x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y5[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY vtc_G6x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G6x12y5[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y5[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y5[] = {
  {&(_ZTV7G6x12y5[4]),  4,9},
  {&(_ZTV7G6x12y5[8]),  8,9},
  {&(_tg__ZTV5E6x12__7G6x12y5[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y5[];
extern  VTBL_ENTRY _ZTV7G6x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y5[];
Class_Descriptor cd_G6x12y5 = {  "G6x12y5", // class name
  bases_G6x12y5, 6,
  &(vtc_G6x12y5[0]), // expected_vtbl_contents
  &(vtt_G6x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G6x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y5),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y5),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y6  : E6x12 , virtual F0 {
  int ff;
  ~G6x12y6(); // tgen
  G6x12y6(); // tgen
};
//SIG(1 G6x12y6) C1{ BC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G6x12y6 ::~G6x12y6(){ note_dtor("G6x12y6", this);} // tgen
G6x12y6 ::G6x12y6(){ note_ctor("G6x12y6", this);} // tgen

static void Test_G6x12y6()
{
  extern Class_Descriptor cd_G6x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G6x12y6, buf);
    G6x12y6 *dp, &lv = *(dp=new (buf) G6x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G6x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y6)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(28,24), "G6x12y6");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), 0, "G6x12y6");
    check_base_class_offset(lv, (C6*)(E6x12*), 0, "G6x12y6");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(16,12), "G6x12y6");
    check_base_class_offset(lv, (E6x12*), 0, "G6x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G6x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G6x12y6.ff");
    test_class_info(&lv, &cd_G6x12y6);
    dp->~G6x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y6(Test_G6x12y6, "G6x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G6x12y6C1Ev();
extern void _ZN7G6x12y6D1Ev();
Name_Map name_map_G6x12y6[] = {
  NSPAIR(_ZN7G6x12y6C1Ev),
  NSPAIR(_ZN7G6x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G6x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y6[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY vtc_G6x12y6[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y6[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y6[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y6[] = {
  {&(_ZTV7G6x12y6[4]),  4,5},
  {&(_tg__ZTV5E6x12__7G6x12y6[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y6[];
extern  VTBL_ENTRY _ZTV7G6x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y6[];
Class_Descriptor cd_G6x12y6 = {  "G6x12y6", // class name
  bases_G6x12y6, 6,
  &(vtc_G6x12y6[0]), // expected_vtbl_contents
  &(vtt_G6x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G6x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y6),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y6),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G6x12y7  : virtual E6x12 , virtual F0 {
  int ff;
  ~G6x12y7(); // tgen
  G6x12y7(); // tgen
};
//SIG(1 G6x12y7) C1{ VBC2{ BC3{ VBC4{ Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G6x12y7 ::~G6x12y7(){ note_dtor("G6x12y7", this);} // tgen
G6x12y7 ::G6x12y7(){ note_ctor("G6x12y7", this);} // tgen

static void Test_G6x12y7()
{
  extern Class_Descriptor cd_G6x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G6x12y7, buf);
    G6x12y7 *dp, &lv = *(dp=new (buf) G6x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G6x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G6x12y7)");
    check_base_class_offset(lv, (A0*)(C6*)(E6x12*), ABISELECT(40,28), "G6x12y7");
    check_base_class_offset(lv, (B1*)(C6*)(E6x12*), ABISELECT(16,8), "G6x12y7");
    check_base_class_offset(lv, (C6*)(E6x12*), ABISELECT(16,8), "G6x12y7");
    check_base_class_offset(lv, (D0*)(E6x12*), ABISELECT(32,20), "G6x12y7");
    check_base_class_offset(lv, (E6x12*), ABISELECT(16,8), "G6x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G6x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G6x12y7.ff");
    test_class_info(&lv, &cd_G6x12y7);
    dp->~G6x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG6x12y7(Test_G6x12y7, "G6x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G6x12y7C1Ev();
extern void _ZN7G6x12y7D1Ev();
Name_Map name_map_G6x12y7[] = {
  NSPAIR(_ZN7G6x12y7C1Ev),
  NSPAIR(_ZN7G6x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C6;
extern VTBL_ENTRY _ZTI2C6[];
extern  VTBL_ENTRY _ZTV2C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C6[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E6x12;
extern VTBL_ENTRY _ZTI5E6x12[];
extern  VTBL_ENTRY _ZTV5E6x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E6x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G6x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E6x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G6x12y7[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY vtc_G6x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G6x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G6x12y7[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern VTBL_ENTRY _ZTV7G6x12y7[];
extern void _ZN5E6x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E6x12__7G6x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E6x12[0]),
  (VTBL_ENTRY)&_ZN5E6x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C65E6x12__7G6x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C6[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_G6x12y7[] = {
  {&(_ZTV7G6x12y7[5]),  5,10},
  {&(_ZTV7G6x12y7[9]),  9,10},
  {&(_tg__ZTV5E6x12__7G6x12y7[3]),  3,4},
  {&(_tg__ZTV2C65E6x12__7G6x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G6x12y7[];
extern  VTBL_ENTRY _ZTV7G6x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G6x12y7[];
Class_Descriptor cd_G6x12y7 = {  "G6x12y7", // class name
  bases_G6x12y7, 6,
  &(vtc_G6x12y7[0]), // expected_vtbl_contents
  &(vtt_G6x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G6x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G6x12y7),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G6x12y7),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E7x12  : C7 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E7x123fooEv
  ~E7x12(); // tgen
  E7x12(); // tgen
};
//SIG(-1 E7x12) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E7x12 ::foo(){vfunc_called(this, "_ZN5E7x123fooEv");}
E7x12 ::~E7x12(){ note_dtor("E7x12", this);} // tgen
E7x12 ::E7x12(){ note_ctor("E7x12", this);} // tgen

static void Test_E7x12()
{
  extern Class_Descriptor cd_E7x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E7x12, buf);
    E7x12 *dp, &lv = *(dp=new (buf) E7x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E7x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E7x12)");
    check_base_class_offset(lv, (A1*)(C7*), ABISELECT(24,20), "E7x12");
    check_base_class_offset(lv, (B1*)(C7*), 0, "E7x12");
    check_base_class_offset(lv, (C7*), 0, "E7x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E7x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E7x12.fd");
    test_class_info(&lv, &cd_E7x12);
    dp->~E7x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE7x12(Test_E7x12, "E7x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN5E7x12C1Ev();
extern void _ZN5E7x12D1Ev();
Name_Map name_map_E7x12[] = {
  NSPAIR(_ZN5E7x12C1Ev),
  NSPAIR(_ZN5E7x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E7x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E7x12[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E7x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV5E7x12[];
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C7__5E7x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C7__5E7x12[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_E7x12[] = {
  {&(_ZTV5E7x12[3]),  3,8},
  {&(_tg__ZTV2C7__5E7x12[3]),  3,4},
  {&(_tg__ZTV2A1__2C7__5E7x12[3]),  3,4},
  {&(_ZTV5E7x12[7]),  7,8},
};
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E7x12 = {  "E7x12", // class name
  bases_E7x12, 4,
  &(vtc_E7x12[0]), // expected_vtbl_contents
  &(vtt_E7x12[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI5E7x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E7x12),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5E7x12),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y0  : E7x12 , F1 {
  int ff;
  ~G7x12y0(); // tgen
  G7x12y0(); // tgen
};
//SIG(1 G7x12y0) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G7x12y0 ::~G7x12y0(){ note_dtor("G7x12y0", this);} // tgen
G7x12y0 ::G7x12y0(){ note_ctor("G7x12y0", this);} // tgen

static void Test_G7x12y0()
{
  extern Class_Descriptor cd_G7x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G7x12y0, buf);
    G7x12y0 *dp, &lv = *(dp=new (buf) G7x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G7x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y0)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(40,32), "G7x12y0");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), 0, "G7x12y0");
    check_base_class_offset(lv, (C7*)(E7x12*), 0, "G7x12y0");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(16,12), "G7x12y0");
    check_base_class_offset(lv, (E7x12*), 0, "G7x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G7x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G7x12y0.ff");
    test_class_info(&lv, &cd_G7x12y0);
    dp->~G7x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y0(Test_G7x12y0, "G7x12y0", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G7x12y0C1Ev();
extern void _ZN7G7x12y0D1Ev();
Name_Map name_map_G7x12y0[] = {
  NSPAIR(_ZN7G7x12y0C1Ev),
  NSPAIR(_ZN7G7x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G7x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y0[];
extern void _ZN5E7x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn40_N5E7x123fooEv,_ZThn32_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G7x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y0[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI7G7x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI7G7x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV7G7x12y0[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y0[] = {
  0,
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn40_N5E7x123fooEv,_ZThn32_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y0[] = {
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y0[] = {
  {&(_ZTV7G7x12y0[3]),  3,11},
  {&(_tg__ZTV5E7x12__7G7x12y0[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y0[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y0[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y0[3]),  3,4},
  {&(_ZTV7G7x12y0[10]),  10,11},
};
extern VTBL_ENTRY _ZTI7G7x12y0[];
extern  VTBL_ENTRY _ZTV7G7x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y0[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N5E7x123fooEv,_ZThn32_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N5E7x123fooEv,_ZThn32_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y0 = {  "G7x12y0", // class name
  bases_G7x12y0, 6,
  &(vtc_G7x12y0[0]), // expected_vtbl_contents
  &(vtt_G7x12y0[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G7x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y0),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y0),6, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y1  : virtual E7x12 , F1 {
  int ff;
  ~G7x12y1(); // tgen
  G7x12y1(); // tgen
};
//SIG(1 G7x12y1) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G7x12y1 ::~G7x12y1(){ note_dtor("G7x12y1", this);} // tgen
G7x12y1 ::G7x12y1(){ note_ctor("G7x12y1", this);} // tgen

static void Test_G7x12y1()
{
  extern Class_Descriptor cd_G7x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G7x12y1, buf);
    G7x12y1 *dp, &lv = *(dp=new (buf) G7x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G7x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y1)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(40,32), "G7x12y1");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), ABISELECT(16,12), "G7x12y1");
    check_base_class_offset(lv, (C7*)(E7x12*), ABISELECT(16,12), "G7x12y1");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(32,24), "G7x12y1");
    check_base_class_offset(lv, (E7x12*), ABISELECT(16,12), "G7x12y1");
    check_base_class_offset(lv, (F1*), 0, "G7x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G7x12y1.ff");
    test_class_info(&lv, &cd_G7x12y1);
    dp->~G7x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y1(Test_G7x12y1, "G7x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G7x12y1C1Ev();
extern void _ZN7G7x12y1D1Ev();
Name_Map name_map_G7x12y1[] = {
  NSPAIR(_ZN7G7x12y1C1Ev),
  NSPAIR(_ZN7G7x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G7x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G7x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G7x12y1[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI7G7x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV7G7x12y1[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y1[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y1[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y1[] = {
  {&(_ZTV7G7x12y1[4]),  4,14},
  {&(_ZTV7G7x12y1[9]),  9,14},
  {&(_ZTV7G7x12y1[13]),  13,14},
  {&(_tg__ZTV5E7x12__7G7x12y1[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y1[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y1[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G7x12y1[];
extern  VTBL_ENTRY _ZTV7G7x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y1[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y1 = {  "G7x12y1", // class name
  bases_G7x12y1, 6,
  &(vtc_G7x12y1[0]), // expected_vtbl_contents
  &(vtt_G7x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G7x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y1),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y1),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y2  : E7x12 , virtual F1 {
  int ff;
  ~G7x12y2(); // tgen
  G7x12y2(); // tgen
};
//SIG(1 G7x12y2) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G7x12y2 ::~G7x12y2(){ note_dtor("G7x12y2", this);} // tgen
G7x12y2 ::G7x12y2(){ note_ctor("G7x12y2", this);} // tgen

static void Test_G7x12y2()
{
  extern Class_Descriptor cd_G7x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G7x12y2, buf);
    G7x12y2 *dp, &lv = *(dp=new (buf) G7x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G7x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y2)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(32,24), "G7x12y2");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), 0, "G7x12y2");
    check_base_class_offset(lv, (C7*)(E7x12*), 0, "G7x12y2");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(16,12), "G7x12y2");
    check_base_class_offset(lv, (E7x12*), 0, "G7x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G7x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G7x12y2.ff");
    test_class_info(&lv, &cd_G7x12y2);
    dp->~G7x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y2(Test_G7x12y2, "G7x12y2", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G7x12y2C1Ev();
extern void _ZN7G7x12y2D1Ev();
Name_Map name_map_G7x12y2[] = {
  NSPAIR(_ZN7G7x12y2C1Ev),
  NSPAIR(_ZN7G7x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G7x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y2[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G7x12y2[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y2[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G7x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G7x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G7x12y2[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y2[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y2[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y2[] = {
  {&(_ZTV7G7x12y2[4]),  4,13},
  {&(_tg__ZTV5E7x12__7G7x12y2[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y2[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y2[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y2[3]),  3,4},
  {&(_ZTV7G7x12y2[8]),  8,13},
  {&(_ZTV7G7x12y2[12]),  12,13},
};
extern VTBL_ENTRY _ZTI7G7x12y2[];
extern  VTBL_ENTRY _ZTV7G7x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y2[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y2 = {  "G7x12y2", // class name
  bases_G7x12y2, 6,
  &(vtc_G7x12y2[0]), // expected_vtbl_contents
  &(vtt_G7x12y2[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G7x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y2),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y2),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y3  : virtual E7x12 , virtual F1 {
  int ff;
  ~G7x12y3(); // tgen
  G7x12y3(); // tgen
};
//SIG(1 G7x12y3) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G7x12y3 ::~G7x12y3(){ note_dtor("G7x12y3", this);} // tgen
G7x12y3 ::G7x12y3(){ note_ctor("G7x12y3", this);} // tgen

static void Test_G7x12y3()
{
  extern Class_Descriptor cd_G7x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G7x12y3, buf);
    G7x12y3 *dp, &lv = *(dp=new (buf) G7x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G7x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y3)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(40,28), "G7x12y3");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), ABISELECT(16,8), "G7x12y3");
    check_base_class_offset(lv, (C7*)(E7x12*), ABISELECT(16,8), "G7x12y3");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(32,20), "G7x12y3");
    check_base_class_offset(lv, (E7x12*), ABISELECT(16,8), "G7x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G7x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G7x12y3.ff");
    test_class_info(&lv, &cd_G7x12y3);
    dp->~G7x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y3(Test_G7x12y3, "G7x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN7G7x12y3C1Ev();
extern void _ZN7G7x12y3D1Ev();
Name_Map name_map_G7x12y3[] = {
  NSPAIR(_ZN7G7x12y3C1Ev),
  NSPAIR(_ZN7G7x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G7x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y3[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G7x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G7x12y3[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7G7x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7G7x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G7x12y3[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y3[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y3[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y3[] = {
  {&(_ZTV7G7x12y3[5]),  5,18},
  {&(_ZTV7G7x12y3[9]),  9,18},
  {&(_ZTV7G7x12y3[13]),  13,18},
  {&(_ZTV7G7x12y3[17]),  17,18},
  {&(_tg__ZTV5E7x12__7G7x12y3[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y3[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y3[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G7x12y3[];
extern  VTBL_ENTRY _ZTV7G7x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y3[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y3 = {  "G7x12y3", // class name
  bases_G7x12y3, 6,
  &(vtc_G7x12y3[0]), // expected_vtbl_contents
  &(vtt_G7x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI7G7x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y3),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y3),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y4  : E7x12 , F0 {
  int ff;
  ~G7x12y4(); // tgen
  G7x12y4(); // tgen
};
//SIG(1 G7x12y4) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G7x12y4 ::~G7x12y4(){ note_dtor("G7x12y4", this);} // tgen
G7x12y4 ::G7x12y4(){ note_ctor("G7x12y4", this);} // tgen

static void Test_G7x12y4()
{
  extern Class_Descriptor cd_G7x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G7x12y4, buf);
    G7x12y4 *dp, &lv = *(dp=new (buf) G7x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G7x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y4)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(32,28), "G7x12y4");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), 0, "G7x12y4");
    check_base_class_offset(lv, (C7*)(E7x12*), 0, "G7x12y4");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(16,12), "G7x12y4");
    check_base_class_offset(lv, (E7x12*), 0, "G7x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G7x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G7x12y4.ff");
    test_class_info(&lv, &cd_G7x12y4);
    dp->~G7x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y4(Test_G7x12y4, "G7x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G7x12y4C1Ev();
extern void _ZN7G7x12y4D1Ev();
Name_Map name_map_G7x12y4[] = {
  NSPAIR(_ZN7G7x12y4C1Ev),
  NSPAIR(_ZN7G7x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G7x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y4[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn28_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G7x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y4[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G7x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV7G7x12y4[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y4[] = {
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn28_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y4[] = {
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y4[] = {
  {&(_ZTV7G7x12y4[3]),  3,8},
  {&(_tg__ZTV5E7x12__7G7x12y4[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y4[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y4[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y4[3]),  3,4},
  {&(_ZTV7G7x12y4[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7G7x12y4[];
extern  VTBL_ENTRY _ZTV7G7x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y4[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn28_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn28_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y4 = {  "G7x12y4", // class name
  bases_G7x12y4, 6,
  &(vtc_G7x12y4[0]), // expected_vtbl_contents
  &(vtt_G7x12y4[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G7x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y4),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y4),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y5  : virtual E7x12 , F0 {
  int ff;
  ~G7x12y5(); // tgen
  G7x12y5(); // tgen
};
//SIG(1 G7x12y5) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G7x12y5 ::~G7x12y5(){ note_dtor("G7x12y5", this);} // tgen
G7x12y5 ::G7x12y5(){ note_ctor("G7x12y5", this);} // tgen

static void Test_G7x12y5()
{
  extern Class_Descriptor cd_G7x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G7x12y5, buf);
    G7x12y5 *dp, &lv = *(dp=new (buf) G7x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G7x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y5)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(40,32), "G7x12y5");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), ABISELECT(16,12), "G7x12y5");
    check_base_class_offset(lv, (C7*)(E7x12*), ABISELECT(16,12), "G7x12y5");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(32,24), "G7x12y5");
    check_base_class_offset(lv, (E7x12*), ABISELECT(16,12), "G7x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G7x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G7x12y5.ff");
    test_class_info(&lv, &cd_G7x12y5);
    dp->~G7x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y5(Test_G7x12y5, "G7x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G7x12y5C1Ev();
extern void _ZN7G7x12y5D1Ev();
Name_Map name_map_G7x12y5[] = {
  NSPAIR(_ZN7G7x12y5C1Ev),
  NSPAIR(_ZN7G7x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G7x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y5[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G7x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G7x12y5[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI7G7x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV7G7x12y5[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y5[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y5[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y5[] = {
  {&(_ZTV7G7x12y5[4]),  4,13},
  {&(_ZTV7G7x12y5[8]),  8,13},
  {&(_ZTV7G7x12y5[12]),  12,13},
  {&(_tg__ZTV5E7x12__7G7x12y5[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y5[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y5[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G7x12y5[];
extern  VTBL_ENTRY _ZTV7G7x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y5[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y5 = {  "G7x12y5", // class name
  bases_G7x12y5, 6,
  &(vtc_G7x12y5[0]), // expected_vtbl_contents
  &(vtt_G7x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G7x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y5),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y5),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y6  : E7x12 , virtual F0 {
  int ff;
  ~G7x12y6(); // tgen
  G7x12y6(); // tgen
};
//SIG(1 G7x12y6) C1{ BC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G7x12y6 ::~G7x12y6(){ note_dtor("G7x12y6", this);} // tgen
G7x12y6 ::G7x12y6(){ note_ctor("G7x12y6", this);} // tgen

static void Test_G7x12y6()
{
  extern Class_Descriptor cd_G7x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G7x12y6, buf);
    G7x12y6 *dp, &lv = *(dp=new (buf) G7x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G7x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y6)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(32,24), "G7x12y6");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), 0, "G7x12y6");
    check_base_class_offset(lv, (C7*)(E7x12*), 0, "G7x12y6");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(16,12), "G7x12y6");
    check_base_class_offset(lv, (E7x12*), 0, "G7x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G7x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G7x12y6.ff");
    test_class_info(&lv, &cd_G7x12y6);
    dp->~G7x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y6(Test_G7x12y6, "G7x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G7x12y6C1Ev();
extern void _ZN7G7x12y6D1Ev();
Name_Map name_map_G7x12y6[] = {
  NSPAIR(_ZN7G7x12y6C1Ev),
  NSPAIR(_ZN7G7x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G7x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y6[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G7x12y6[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y6[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7G7x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV7G7x12y6[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y6[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y6[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y6[] = {
  {&(_ZTV7G7x12y6[4]),  4,9},
  {&(_tg__ZTV5E7x12__7G7x12y6[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y6[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y6[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y6[3]),  3,4},
  {&(_ZTV7G7x12y6[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7G7x12y6[];
extern  VTBL_ENTRY _ZTV7G7x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y6[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5E7x123fooEv,_ZThn24_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y6 = {  "G7x12y6", // class name
  bases_G7x12y6, 6,
  &(vtc_G7x12y6[0]), // expected_vtbl_contents
  &(vtt_G7x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G7x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y6),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y6),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G7x12y7  : virtual E7x12 , virtual F0 {
  int ff;
  ~G7x12y7(); // tgen
  G7x12y7(); // tgen
};
//SIG(1 G7x12y7) C1{ VBC2{ BC3{ VBC4{ v1 Fi} BC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G7x12y7 ::~G7x12y7(){ note_dtor("G7x12y7", this);} // tgen
G7x12y7 ::G7x12y7(){ note_ctor("G7x12y7", this);} // tgen

static void Test_G7x12y7()
{
  extern Class_Descriptor cd_G7x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G7x12y7, buf);
    G7x12y7 *dp, &lv = *(dp=new (buf) G7x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G7x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G7x12y7)");
    check_base_class_offset(lv, (A1*)(C7*)(E7x12*), ABISELECT(40,28), "G7x12y7");
    check_base_class_offset(lv, (B1*)(C7*)(E7x12*), ABISELECT(16,8), "G7x12y7");
    check_base_class_offset(lv, (C7*)(E7x12*), ABISELECT(16,8), "G7x12y7");
    check_base_class_offset(lv, (D0*)(E7x12*), ABISELECT(32,20), "G7x12y7");
    check_base_class_offset(lv, (E7x12*), ABISELECT(16,8), "G7x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(52,36), "G7x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G7x12y7.ff");
    test_class_info(&lv, &cd_G7x12y7);
    dp->~G7x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG7x12y7(Test_G7x12y7, "G7x12y7", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN7G7x12y7C1Ev();
extern void _ZN7G7x12y7D1Ev();
Name_Map name_map_G7x12y7[] = {
  NSPAIR(_ZN7G7x12y7C1Ev),
  NSPAIR(_ZN7G7x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C7;
extern VTBL_ENTRY _ZTI2C7[];
extern  VTBL_ENTRY _ZTV2C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C7[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E7x12;
extern VTBL_ENTRY _ZTI5E7x12[];
extern  VTBL_ENTRY _ZTV5E7x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E7x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G7x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C7,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E7x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G7x12y7[];
extern void _ZN5E7x123fooEv();
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G7x12y7[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G7x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G7x12y7[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7G7x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
extern VTBL_ENTRY _ZTV7G7x12y7[];
extern void _ZN5E7x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E7x12__7G7x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&_ZN5E7x123fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2C75E7x12__7G7x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__2C75E7x12__7G7x12y7[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI2C7[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv)();
extern void ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__5E7x12__7G7x12y7[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI5E7x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv),
};
static  VTT_ENTRY vtt_G7x12y7[] = {
  {&(_ZTV7G7x12y7[5]),  5,14},
  {&(_ZTV7G7x12y7[9]),  9,14},
  {&(_ZTV7G7x12y7[13]),  13,14},
  {&(_tg__ZTV5E7x12__7G7x12y7[3]),  3,4},
  {&(_tg__ZTV2C75E7x12__7G7x12y7[3]),  3,4},
  {&(_tg__ZTV2A1__2C75E7x12__7G7x12y7[3]),  3,4},
  {&(_tg__ZTV2A1__5E7x12__7G7x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G7x12y7[];
extern  VTBL_ENTRY _ZTV7G7x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G7x12y7[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5E7x123fooEv,_ZTv0_n12_N5E7x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N5E7x123fooEv,_ZThn20_N5E7x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G7x12y7 = {  "G7x12y7", // class name
  bases_G7x12y7, 6,
  &(vtc_G7x12y7[0]), // expected_vtbl_contents
  &(vtt_G7x12y7[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI7G7x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G7x12y7),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G7x12y7),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E8x12  : C8 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E8x123fooEv
  ~E8x12(); // tgen
  E8x12(); // tgen
};
//SIG(-1 E8x12) C1{ BC2{ BC3{ Fi} VBC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E8x12 ::foo(){vfunc_called(this, "_ZN5E8x123fooEv");}
E8x12 ::~E8x12(){ note_dtor("E8x12", this);} // tgen
E8x12 ::E8x12(){ note_ctor("E8x12", this);} // tgen

static void Test_E8x12()
{
  extern Class_Descriptor cd_E8x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E8x12, buf);
    E8x12 *dp, &lv = *(dp=new (buf) E8x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E8x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E8x12)");
    check_base_class_offset(lv, (A0*)(C8*), ABISELECT(8,4), "E8x12");
    check_base_class_offset(lv, (B0*)(C8*), ABISELECT(24,20), "E8x12");
    check_base_class_offset(lv, (C8*), 0, "E8x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E8x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E8x12.fd");
    test_class_info(&lv, &cd_E8x12);
    dp->~E8x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE8x12(Test_E8x12, "E8x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E8x12C1Ev();
extern void _ZN5E8x12D1Ev();
Name_Map name_map_E8x12[] = {
  NSPAIR(_ZN5E8x12C1Ev),
  NSPAIR(_ZN5E8x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E8x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E8x12[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY vtc_E8x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
extern VTBL_ENTRY _ZTV5E8x12[];
static  VTBL_ENTRY _tg__ZTV2C8__5E8x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_E8x12[] = {
  {&(_ZTV5E8x12[3]),  3,4},
  {&(_tg__ZTV2C8__5E8x12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
Class_Descriptor cd_E8x12 = {  "E8x12", // class name
  bases_E8x12, 4,
  &(vtc_E8x12[0]), // expected_vtbl_contents
  &(vtt_E8x12[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E8x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E8x12),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5E8x12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y0  : E8x12 , F1 {
  int ff;
  ~G8x12y0(); // tgen
  G8x12y0(); // tgen
};
//SIG(1 G8x12y0) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G8x12y0 ::~G8x12y0(){ note_dtor("G8x12y0", this);} // tgen
G8x12y0 ::G8x12y0(){ note_ctor("G8x12y0", this);} // tgen

static void Test_G8x12y0()
{
  extern Class_Descriptor cd_G8x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G8x12y0, buf);
    G8x12y0 *dp, &lv = *(dp=new (buf) G8x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G8x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y0)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(8,4), "G8x12y0");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(40,32), "G8x12y0");
    check_base_class_offset(lv, (C8*)(E8x12*), 0, "G8x12y0");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(16,12), "G8x12y0");
    check_base_class_offset(lv, (E8x12*), 0, "G8x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G8x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G8x12y0.ff");
    test_class_info(&lv, &cd_G8x12y0);
    dp->~G8x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y0(Test_G8x12y0, "G8x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G8x12y0C1Ev();
extern void _ZN7G8x12y0D1Ev();
Name_Map name_map_G8x12y0[] = {
  NSPAIR(_ZN7G8x12y0C1Ev),
  NSPAIR(_ZN7G8x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G8x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y0[];
extern void _ZN5E8x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G8x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y0[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI7G8x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y0[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y0[] = {
  {&(_ZTV7G8x12y0[3]),  3,7},
  {&(_tg__ZTV5E8x12__7G8x12y0[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y0[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y0[];
extern  VTBL_ENTRY _ZTV7G8x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y0[];
Class_Descriptor cd_G8x12y0 = {  "G8x12y0", // class name
  bases_G8x12y0, 6,
  &(vtc_G8x12y0[0]), // expected_vtbl_contents
  &(vtt_G8x12y0[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G8x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y0),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y0),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y1  : virtual E8x12 , F1 {
  int ff;
  ~G8x12y1(); // tgen
  G8x12y1(); // tgen
};
//SIG(1 G8x12y1) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G8x12y1 ::~G8x12y1(){ note_dtor("G8x12y1", this);} // tgen
G8x12y1 ::G8x12y1(){ note_ctor("G8x12y1", this);} // tgen

static void Test_G8x12y1()
{
  extern Class_Descriptor cd_G8x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G8x12y1, buf);
    G8x12y1 *dp, &lv = *(dp=new (buf) G8x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G8x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y1)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(24,16), "G8x12y1");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(40,32), "G8x12y1");
    check_base_class_offset(lv, (C8*)(E8x12*), ABISELECT(16,12), "G8x12y1");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(32,24), "G8x12y1");
    check_base_class_offset(lv, (E8x12*), ABISELECT(16,12), "G8x12y1");
    check_base_class_offset(lv, (F1*), 0, "G8x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G8x12y1.ff");
    test_class_info(&lv, &cd_G8x12y1);
    dp->~G8x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y1(Test_G8x12y1, "G8x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G8x12y1C1Ev();
extern void _ZN7G8x12y1D1Ev();
Name_Map name_map_G8x12y1[] = {
  NSPAIR(_ZN7G8x12y1C1Ev),
  NSPAIR(_ZN7G8x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G8x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY vtc_G8x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G8x12y1[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y1[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y1[] = {
  {&(_ZTV7G8x12y1[4]),  4,10},
  {&(_ZTV7G8x12y1[9]),  9,10},
  {&(_tg__ZTV5E8x12__7G8x12y1[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y1[];
extern  VTBL_ENTRY _ZTV7G8x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y1[];
Class_Descriptor cd_G8x12y1 = {  "G8x12y1", // class name
  bases_G8x12y1, 6,
  &(vtc_G8x12y1[0]), // expected_vtbl_contents
  &(vtt_G8x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G8x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y1),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y1),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y2  : E8x12 , virtual F1 {
  int ff;
  ~G8x12y2(); // tgen
  G8x12y2(); // tgen
};
//SIG(1 G8x12y2) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G8x12y2 ::~G8x12y2(){ note_dtor("G8x12y2", this);} // tgen
G8x12y2 ::G8x12y2(){ note_ctor("G8x12y2", this);} // tgen

static void Test_G8x12y2()
{
  extern Class_Descriptor cd_G8x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G8x12y2, buf);
    G8x12y2 *dp, &lv = *(dp=new (buf) G8x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G8x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y2)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(8,4), "G8x12y2");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(28,24), "G8x12y2");
    check_base_class_offset(lv, (C8*)(E8x12*), 0, "G8x12y2");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(16,12), "G8x12y2");
    check_base_class_offset(lv, (E8x12*), 0, "G8x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G8x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G8x12y2.ff");
    test_class_info(&lv, &cd_G8x12y2);
    dp->~G8x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y2(Test_G8x12y2, "G8x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G8x12y2C1Ev();
extern void _ZN7G8x12y2D1Ev();
Name_Map name_map_G8x12y2[] = {
  NSPAIR(_ZN7G8x12y2C1Ev),
  NSPAIR(_ZN7G8x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G8x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y2[];
extern void _ZN5E8x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G8x12y2[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y2[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G8x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y2[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y2[] = {
  {&(_ZTV7G8x12y2[4]),  4,9},
  {&(_tg__ZTV5E8x12__7G8x12y2[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y2[3]),  3,3},
  {&(_ZTV7G8x12y2[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7G8x12y2[];
extern  VTBL_ENTRY _ZTV7G8x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y2[];
Class_Descriptor cd_G8x12y2 = {  "G8x12y2", // class name
  bases_G8x12y2, 6,
  &(vtc_G8x12y2[0]), // expected_vtbl_contents
  &(vtt_G8x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G8x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y2),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y2),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y3  : virtual E8x12 , virtual F1 {
  int ff;
  ~G8x12y3(); // tgen
  G8x12y3(); // tgen
};
//SIG(1 G8x12y3) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G8x12y3 ::~G8x12y3(){ note_dtor("G8x12y3", this);} // tgen
G8x12y3 ::G8x12y3(){ note_ctor("G8x12y3", this);} // tgen

static void Test_G8x12y3()
{
  extern Class_Descriptor cd_G8x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G8x12y3, buf);
    G8x12y3 *dp, &lv = *(dp=new (buf) G8x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G8x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y3)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(24,12), "G8x12y3");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(40,28), "G8x12y3");
    check_base_class_offset(lv, (C8*)(E8x12*), ABISELECT(16,8), "G8x12y3");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(32,20), "G8x12y3");
    check_base_class_offset(lv, (E8x12*), ABISELECT(16,8), "G8x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G8x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G8x12y3.ff");
    test_class_info(&lv, &cd_G8x12y3);
    dp->~G8x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y3(Test_G8x12y3, "G8x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G8x12y3C1Ev();
extern void _ZN7G8x12y3D1Ev();
Name_Map name_map_G8x12y3[] = {
  NSPAIR(_ZN7G8x12y3C1Ev),
  NSPAIR(_ZN7G8x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G8x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y3[];
extern void _ZN5E8x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G8x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G8x12y3[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G8x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y3[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y3[] = {
  {&(_ZTV7G8x12y3[5]),  5,14},
  {&(_ZTV7G8x12y3[9]),  9,14},
  {&(_ZTV7G8x12y3[13]),  13,14},
  {&(_tg__ZTV5E8x12__7G8x12y3[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y3[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y3[];
extern  VTBL_ENTRY _ZTV7G8x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y3[];
Class_Descriptor cd_G8x12y3 = {  "G8x12y3", // class name
  bases_G8x12y3, 6,
  &(vtc_G8x12y3[0]), // expected_vtbl_contents
  &(vtt_G8x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G8x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y3),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y3),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y4  : E8x12 , F0 {
  int ff;
  ~G8x12y4(); // tgen
  G8x12y4(); // tgen
};
//SIG(1 G8x12y4) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G8x12y4 ::~G8x12y4(){ note_dtor("G8x12y4", this);} // tgen
G8x12y4 ::G8x12y4(){ note_ctor("G8x12y4", this);} // tgen

static void Test_G8x12y4()
{
  extern Class_Descriptor cd_G8x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G8x12y4, buf);
    G8x12y4 *dp, &lv = *(dp=new (buf) G8x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G8x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y4)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(8,4), "G8x12y4");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(32,28), "G8x12y4");
    check_base_class_offset(lv, (C8*)(E8x12*), 0, "G8x12y4");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(16,12), "G8x12y4");
    check_base_class_offset(lv, (E8x12*), 0, "G8x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G8x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G8x12y4.ff");
    test_class_info(&lv, &cd_G8x12y4);
    dp->~G8x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y4(Test_G8x12y4, "G8x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G8x12y4C1Ev();
extern void _ZN7G8x12y4D1Ev();
Name_Map name_map_G8x12y4[] = {
  NSPAIR(_ZN7G8x12y4C1Ev),
  NSPAIR(_ZN7G8x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G8x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y4[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY vtc_G8x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y4[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y4[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y4[] = {
  {&(_ZTV7G8x12y4[3]),  3,4},
  {&(_tg__ZTV5E8x12__7G8x12y4[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y4[];
extern  VTBL_ENTRY _ZTV7G8x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y4[];
Class_Descriptor cd_G8x12y4 = {  "G8x12y4", // class name
  bases_G8x12y4, 6,
  &(vtc_G8x12y4[0]), // expected_vtbl_contents
  &(vtt_G8x12y4[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G8x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y4),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y4),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y5  : virtual E8x12 , F0 {
  int ff;
  ~G8x12y5(); // tgen
  G8x12y5(); // tgen
};
//SIG(1 G8x12y5) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G8x12y5 ::~G8x12y5(){ note_dtor("G8x12y5", this);} // tgen
G8x12y5 ::G8x12y5(){ note_ctor("G8x12y5", this);} // tgen

static void Test_G8x12y5()
{
  extern Class_Descriptor cd_G8x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G8x12y5, buf);
    G8x12y5 *dp, &lv = *(dp=new (buf) G8x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G8x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y5)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(24,16), "G8x12y5");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(40,32), "G8x12y5");
    check_base_class_offset(lv, (C8*)(E8x12*), ABISELECT(16,12), "G8x12y5");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(32,24), "G8x12y5");
    check_base_class_offset(lv, (E8x12*), ABISELECT(16,12), "G8x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G8x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G8x12y5.ff");
    test_class_info(&lv, &cd_G8x12y5);
    dp->~G8x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y5(Test_G8x12y5, "G8x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G8x12y5C1Ev();
extern void _ZN7G8x12y5D1Ev();
Name_Map name_map_G8x12y5[] = {
  NSPAIR(_ZN7G8x12y5C1Ev),
  NSPAIR(_ZN7G8x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G8x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y5[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY vtc_G8x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G8x12y5[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y5[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y5[] = {
  {&(_ZTV7G8x12y5[4]),  4,9},
  {&(_ZTV7G8x12y5[8]),  8,9},
  {&(_tg__ZTV5E8x12__7G8x12y5[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y5[];
extern  VTBL_ENTRY _ZTV7G8x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y5[];
Class_Descriptor cd_G8x12y5 = {  "G8x12y5", // class name
  bases_G8x12y5, 6,
  &(vtc_G8x12y5[0]), // expected_vtbl_contents
  &(vtt_G8x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G8x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y5),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y5),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y6  : E8x12 , virtual F0 {
  int ff;
  ~G8x12y6(); // tgen
  G8x12y6(); // tgen
};
//SIG(1 G8x12y6) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G8x12y6 ::~G8x12y6(){ note_dtor("G8x12y6", this);} // tgen
G8x12y6 ::G8x12y6(){ note_ctor("G8x12y6", this);} // tgen

static void Test_G8x12y6()
{
  extern Class_Descriptor cd_G8x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G8x12y6, buf);
    G8x12y6 *dp, &lv = *(dp=new (buf) G8x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G8x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y6)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(8,4), "G8x12y6");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(28,24), "G8x12y6");
    check_base_class_offset(lv, (C8*)(E8x12*), 0, "G8x12y6");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(16,12), "G8x12y6");
    check_base_class_offset(lv, (E8x12*), 0, "G8x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G8x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G8x12y6.ff");
    test_class_info(&lv, &cd_G8x12y6);
    dp->~G8x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y6(Test_G8x12y6, "G8x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G8x12y6C1Ev();
extern void _ZN7G8x12y6D1Ev();
Name_Map name_map_G8x12y6[] = {
  NSPAIR(_ZN7G8x12y6C1Ev),
  NSPAIR(_ZN7G8x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G8x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y6[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY vtc_G8x12y6[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y6[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y6[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y6[] = {
  {&(_ZTV7G8x12y6[4]),  4,5},
  {&(_tg__ZTV5E8x12__7G8x12y6[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y6[];
extern  VTBL_ENTRY _ZTV7G8x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y6[];
Class_Descriptor cd_G8x12y6 = {  "G8x12y6", // class name
  bases_G8x12y6, 6,
  &(vtc_G8x12y6[0]), // expected_vtbl_contents
  &(vtt_G8x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G8x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y6),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y6),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G8x12y7  : virtual E8x12 , virtual F0 {
  int ff;
  ~G8x12y7(); // tgen
  G8x12y7(); // tgen
};
//SIG(1 G8x12y7) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G8x12y7 ::~G8x12y7(){ note_dtor("G8x12y7", this);} // tgen
G8x12y7 ::G8x12y7(){ note_ctor("G8x12y7", this);} // tgen

static void Test_G8x12y7()
{
  extern Class_Descriptor cd_G8x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G8x12y7, buf);
    G8x12y7 *dp, &lv = *(dp=new (buf) G8x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G8x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G8x12y7)");
    check_base_class_offset(lv, (A0*)(C8*)(E8x12*), ABISELECT(24,12), "G8x12y7");
    check_base_class_offset(lv, (B0*)(C8*)(E8x12*), ABISELECT(40,28), "G8x12y7");
    check_base_class_offset(lv, (C8*)(E8x12*), ABISELECT(16,8), "G8x12y7");
    check_base_class_offset(lv, (D0*)(E8x12*), ABISELECT(32,20), "G8x12y7");
    check_base_class_offset(lv, (E8x12*), ABISELECT(16,8), "G8x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G8x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G8x12y7.ff");
    test_class_info(&lv, &cd_G8x12y7);
    dp->~G8x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG8x12y7(Test_G8x12y7, "G8x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G8x12y7C1Ev();
extern void _ZN7G8x12y7D1Ev();
Name_Map name_map_G8x12y7[] = {
  NSPAIR(_ZN7G8x12y7C1Ev),
  NSPAIR(_ZN7G8x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C8;
extern VTBL_ENTRY _ZTI2C8[];
extern  VTBL_ENTRY _ZTV2C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C8[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E8x12;
extern VTBL_ENTRY _ZTI5E8x12[];
extern  VTBL_ENTRY _ZTV5E8x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E8x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G8x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C8,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E8x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G8x12y7[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY vtc_G8x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G8x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G8x12y7[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
extern VTBL_ENTRY _ZTV7G8x12y7[];
extern void _ZN5E8x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E8x12__7G8x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E8x12[0]),
  (VTBL_ENTRY)&_ZN5E8x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV2C85E8x12__7G8x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C8[0]),
};
static  VTT_ENTRY vtt_G8x12y7[] = {
  {&(_ZTV7G8x12y7[5]),  5,10},
  {&(_ZTV7G8x12y7[9]),  9,10},
  {&(_tg__ZTV5E8x12__7G8x12y7[3]),  3,4},
  {&(_tg__ZTV2C85E8x12__7G8x12y7[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7G8x12y7[];
extern  VTBL_ENTRY _ZTV7G8x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G8x12y7[];
Class_Descriptor cd_G8x12y7 = {  "G8x12y7", // class name
  bases_G8x12y7, 6,
  &(vtc_G8x12y7[0]), // expected_vtbl_contents
  &(vtt_G8x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G8x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G8x12y7),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G8x12y7),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E9x12  : C9 , D0 {
  int fd;
  virtual void  foo(); // _ZN5E9x123fooEv
  ~E9x12(); // tgen
  E9x12(); // tgen
};
//SIG(-1 E9x12) C1{ BC2{ BC3{ v1 Fi} VBC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E9x12 ::foo(){vfunc_called(this, "_ZN5E9x123fooEv");}
E9x12 ::~E9x12(){ note_dtor("E9x12", this);} // tgen
E9x12 ::E9x12(){ note_ctor("E9x12", this);} // tgen

static void Test_E9x12()
{
  extern Class_Descriptor cd_E9x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E9x12, buf);
    E9x12 *dp, &lv = *(dp=new (buf) E9x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E9x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E9x12)");
    check_base_class_offset(lv, (A1*)(C9*), 0, "E9x12");
    check_base_class_offset(lv, (B0*)(C9*), ABISELECT(24,20), "E9x12");
    check_base_class_offset(lv, (C9*), 0, "E9x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E9x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E9x12.fd");
    test_class_info(&lv, &cd_E9x12);
    dp->~E9x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE9x12(Test_E9x12, "E9x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN5E9x12C1Ev();
extern void _ZN5E9x12D1Ev();
Name_Map name_map_E9x12[] = {
  NSPAIR(_ZN5E9x12C1Ev),
  NSPAIR(_ZN5E9x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E9x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5E9x12[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY vtc_E9x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern VTBL_ENTRY _ZTV5E9x12[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C9__5E9x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_E9x12[] = {
  {&(_ZTV5E9x12[3]),  3,4},
  {&(_tg__ZTV2C9__5E9x12[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
Class_Descriptor cd_E9x12 = {  "E9x12", // class name
  bases_E9x12, 4,
  &(vtc_E9x12[0]), // expected_vtbl_contents
  &(vtt_E9x12[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI5E9x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5E9x12),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5E9x12),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y0  : E9x12 , F1 {
  int ff;
  ~G9x12y0(); // tgen
  G9x12y0(); // tgen
};
//SIG(1 G9x12y0) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G9x12y0 ::~G9x12y0(){ note_dtor("G9x12y0", this);} // tgen
G9x12y0 ::G9x12y0(){ note_ctor("G9x12y0", this);} // tgen

static void Test_G9x12y0()
{
  extern Class_Descriptor cd_G9x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G9x12y0, buf);
    G9x12y0 *dp, &lv = *(dp=new (buf) G9x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G9x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y0)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), 0, "G9x12y0");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(40,32), "G9x12y0");
    check_base_class_offset(lv, (C9*)(E9x12*), 0, "G9x12y0");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(16,12), "G9x12y0");
    check_base_class_offset(lv, (E9x12*), 0, "G9x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G9x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G9x12y0.ff");
    test_class_info(&lv, &cd_G9x12y0);
    dp->~G9x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y0(Test_G9x12y0, "G9x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G9x12y0C1Ev();
extern void _ZN7G9x12y0D1Ev();
Name_Map name_map_G9x12y0[] = {
  NSPAIR(_ZN7G9x12y0C1Ev),
  NSPAIR(_ZN7G9x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G9x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y0[];
extern void _ZN5E9x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G9x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y0[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI7G9x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y0[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y0[] = {
  {&(_ZTV7G9x12y0[3]),  3,7},
  {&(_tg__ZTV5E9x12__7G9x12y0[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y0[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y0[];
extern  VTBL_ENTRY _ZTV7G9x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y0[];
Class_Descriptor cd_G9x12y0 = {  "G9x12y0", // class name
  bases_G9x12y0, 6,
  &(vtc_G9x12y0[0]), // expected_vtbl_contents
  &(vtt_G9x12y0[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G9x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y0),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y0),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y1  : virtual E9x12 , F1 {
  int ff;
  ~G9x12y1(); // tgen
  G9x12y1(); // tgen
};
//SIG(1 G9x12y1) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G9x12y1 ::~G9x12y1(){ note_dtor("G9x12y1", this);} // tgen
G9x12y1 ::G9x12y1(){ note_ctor("G9x12y1", this);} // tgen

static void Test_G9x12y1()
{
  extern Class_Descriptor cd_G9x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G9x12y1, buf);
    G9x12y1 *dp, &lv = *(dp=new (buf) G9x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G9x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y1)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), ABISELECT(16,12), "G9x12y1");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(40,32), "G9x12y1");
    check_base_class_offset(lv, (C9*)(E9x12*), ABISELECT(16,12), "G9x12y1");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(32,24), "G9x12y1");
    check_base_class_offset(lv, (E9x12*), ABISELECT(16,12), "G9x12y1");
    check_base_class_offset(lv, (F1*), 0, "G9x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G9x12y1.ff");
    test_class_info(&lv, &cd_G9x12y1);
    dp->~G9x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y1(Test_G9x12y1, "G9x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G9x12y1C1Ev();
extern void _ZN7G9x12y1D1Ev();
Name_Map name_map_G9x12y1[] = {
  NSPAIR(_ZN7G9x12y1C1Ev),
  NSPAIR(_ZN7G9x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G9x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY vtc_G9x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G9x12y1[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y1[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y1[] = {
  {&(_ZTV7G9x12y1[4]),  4,10},
  {&(_ZTV7G9x12y1[9]),  9,10},
  {&(_tg__ZTV5E9x12__7G9x12y1[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y1[];
extern  VTBL_ENTRY _ZTV7G9x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y1[];
Class_Descriptor cd_G9x12y1 = {  "G9x12y1", // class name
  bases_G9x12y1, 6,
  &(vtc_G9x12y1[0]), // expected_vtbl_contents
  &(vtt_G9x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G9x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y1),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y1),4, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y2  : E9x12 , virtual F1 {
  int ff;
  ~G9x12y2(); // tgen
  G9x12y2(); // tgen
};
//SIG(1 G9x12y2) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G9x12y2 ::~G9x12y2(){ note_dtor("G9x12y2", this);} // tgen
G9x12y2 ::G9x12y2(){ note_ctor("G9x12y2", this);} // tgen

static void Test_G9x12y2()
{
  extern Class_Descriptor cd_G9x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G9x12y2, buf);
    G9x12y2 *dp, &lv = *(dp=new (buf) G9x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G9x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y2)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), 0, "G9x12y2");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(28,24), "G9x12y2");
    check_base_class_offset(lv, (C9*)(E9x12*), 0, "G9x12y2");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(16,12), "G9x12y2");
    check_base_class_offset(lv, (E9x12*), 0, "G9x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G9x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G9x12y2.ff");
    test_class_info(&lv, &cd_G9x12y2);
    dp->~G9x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y2(Test_G9x12y2, "G9x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G9x12y2C1Ev();
extern void _ZN7G9x12y2D1Ev();
Name_Map name_map_G9x12y2[] = {
  NSPAIR(_ZN7G9x12y2C1Ev),
  NSPAIR(_ZN7G9x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G9x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y2[];
extern void _ZN5E9x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G9x12y2[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y2[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI7G9x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y2[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y2[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y2[] = {
  {&(_ZTV7G9x12y2[4]),  4,9},
  {&(_tg__ZTV5E9x12__7G9x12y2[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y2[3]),  3,4},
  {&(_ZTV7G9x12y2[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7G9x12y2[];
extern  VTBL_ENTRY _ZTV7G9x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y2[];
Class_Descriptor cd_G9x12y2 = {  "G9x12y2", // class name
  bases_G9x12y2, 6,
  &(vtc_G9x12y2[0]), // expected_vtbl_contents
  &(vtt_G9x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G9x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y2),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y2),4, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y3  : virtual E9x12 , virtual F1 {
  int ff;
  ~G9x12y3(); // tgen
  G9x12y3(); // tgen
};
//SIG(1 G9x12y3) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G9x12y3 ::~G9x12y3(){ note_dtor("G9x12y3", this);} // tgen
G9x12y3 ::G9x12y3(){ note_ctor("G9x12y3", this);} // tgen

static void Test_G9x12y3()
{
  extern Class_Descriptor cd_G9x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G9x12y3, buf);
    G9x12y3 *dp, &lv = *(dp=new (buf) G9x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G9x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y3)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), ABISELECT(16,8), "G9x12y3");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(40,28), "G9x12y3");
    check_base_class_offset(lv, (C9*)(E9x12*), ABISELECT(16,8), "G9x12y3");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(32,20), "G9x12y3");
    check_base_class_offset(lv, (E9x12*), ABISELECT(16,8), "G9x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G9x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G9x12y3.ff");
    test_class_info(&lv, &cd_G9x12y3);
    dp->~G9x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y3(Test_G9x12y3, "G9x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7G9x12y3C1Ev();
extern void _ZN7G9x12y3D1Ev();
Name_Map name_map_G9x12y3[] = {
  NSPAIR(_ZN7G9x12y3C1Ev),
  NSPAIR(_ZN7G9x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G9x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y3[];
extern void _ZN5E9x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G9x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G9x12y3[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI7G9x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y3[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y3[] = {
  {&(_ZTV7G9x12y3[5]),  5,14},
  {&(_ZTV7G9x12y3[9]),  9,14},
  {&(_ZTV7G9x12y3[13]),  13,14},
  {&(_tg__ZTV5E9x12__7G9x12y3[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y3[];
extern  VTBL_ENTRY _ZTV7G9x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y3[];
Class_Descriptor cd_G9x12y3 = {  "G9x12y3", // class name
  bases_G9x12y3, 6,
  &(vtc_G9x12y3[0]), // expected_vtbl_contents
  &(vtt_G9x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7G9x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y3),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y3),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y4  : E9x12 , F0 {
  int ff;
  ~G9x12y4(); // tgen
  G9x12y4(); // tgen
};
//SIG(1 G9x12y4) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G9x12y4 ::~G9x12y4(){ note_dtor("G9x12y4", this);} // tgen
G9x12y4 ::G9x12y4(){ note_ctor("G9x12y4", this);} // tgen

static void Test_G9x12y4()
{
  extern Class_Descriptor cd_G9x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G9x12y4, buf);
    G9x12y4 *dp, &lv = *(dp=new (buf) G9x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G9x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y4)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), 0, "G9x12y4");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(32,28), "G9x12y4");
    check_base_class_offset(lv, (C9*)(E9x12*), 0, "G9x12y4");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(16,12), "G9x12y4");
    check_base_class_offset(lv, (E9x12*), 0, "G9x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G9x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G9x12y4.ff");
    test_class_info(&lv, &cd_G9x12y4);
    dp->~G9x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y4(Test_G9x12y4, "G9x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G9x12y4C1Ev();
extern void _ZN7G9x12y4D1Ev();
Name_Map name_map_G9x12y4[] = {
  NSPAIR(_ZN7G9x12y4C1Ev),
  NSPAIR(_ZN7G9x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G9x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y4[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY vtc_G9x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y4[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y4[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y4[] = {
  {&(_ZTV7G9x12y4[3]),  3,4},
  {&(_tg__ZTV5E9x12__7G9x12y4[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y4[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y4[];
extern  VTBL_ENTRY _ZTV7G9x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y4[];
Class_Descriptor cd_G9x12y4 = {  "G9x12y4", // class name
  bases_G9x12y4, 6,
  &(vtc_G9x12y4[0]), // expected_vtbl_contents
  &(vtt_G9x12y4[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G9x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y4),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y4),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y5  : virtual E9x12 , F0 {
  int ff;
  ~G9x12y5(); // tgen
  G9x12y5(); // tgen
};
//SIG(1 G9x12y5) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G9x12y5 ::~G9x12y5(){ note_dtor("G9x12y5", this);} // tgen
G9x12y5 ::G9x12y5(){ note_ctor("G9x12y5", this);} // tgen

static void Test_G9x12y5()
{
  extern Class_Descriptor cd_G9x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G9x12y5, buf);
    G9x12y5 *dp, &lv = *(dp=new (buf) G9x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G9x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y5)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), ABISELECT(16,12), "G9x12y5");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(40,32), "G9x12y5");
    check_base_class_offset(lv, (C9*)(E9x12*), ABISELECT(16,12), "G9x12y5");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(32,24), "G9x12y5");
    check_base_class_offset(lv, (E9x12*), ABISELECT(16,12), "G9x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G9x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G9x12y5.ff");
    test_class_info(&lv, &cd_G9x12y5);
    dp->~G9x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y5(Test_G9x12y5, "G9x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G9x12y5C1Ev();
extern void _ZN7G9x12y5D1Ev();
Name_Map name_map_G9x12y5[] = {
  NSPAIR(_ZN7G9x12y5C1Ev),
  NSPAIR(_ZN7G9x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G9x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y5[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY vtc_G9x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7G9x12y5[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y5[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y5[] = {
  {&(_ZTV7G9x12y5[4]),  4,9},
  {&(_ZTV7G9x12y5[8]),  8,9},
  {&(_tg__ZTV5E9x12__7G9x12y5[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y5[];
extern  VTBL_ENTRY _ZTV7G9x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y5[];
Class_Descriptor cd_G9x12y5 = {  "G9x12y5", // class name
  bases_G9x12y5, 6,
  &(vtc_G9x12y5[0]), // expected_vtbl_contents
  &(vtt_G9x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G9x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y5),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y5),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y6  : E9x12 , virtual F0 {
  int ff;
  ~G9x12y6(); // tgen
  G9x12y6(); // tgen
};
//SIG(1 G9x12y6) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G9x12y6 ::~G9x12y6(){ note_dtor("G9x12y6", this);} // tgen
G9x12y6 ::G9x12y6(){ note_ctor("G9x12y6", this);} // tgen

static void Test_G9x12y6()
{
  extern Class_Descriptor cd_G9x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G9x12y6, buf);
    G9x12y6 *dp, &lv = *(dp=new (buf) G9x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G9x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y6)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), 0, "G9x12y6");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(28,24), "G9x12y6");
    check_base_class_offset(lv, (C9*)(E9x12*), 0, "G9x12y6");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(16,12), "G9x12y6");
    check_base_class_offset(lv, (E9x12*), 0, "G9x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G9x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G9x12y6.ff");
    test_class_info(&lv, &cd_G9x12y6);
    dp->~G9x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y6(Test_G9x12y6, "G9x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN7G9x12y6C1Ev();
extern void _ZN7G9x12y6D1Ev();
Name_Map name_map_G9x12y6[] = {
  NSPAIR(_ZN7G9x12y6C1Ev),
  NSPAIR(_ZN7G9x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G9x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y6[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY vtc_G9x12y6[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y6[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y6[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y6[] = {
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y6[] = {
  {&(_ZTV7G9x12y6[4]),  4,5},
  {&(_tg__ZTV5E9x12__7G9x12y6[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y6[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y6[];
extern  VTBL_ENTRY _ZTV7G9x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y6[];
Class_Descriptor cd_G9x12y6 = {  "G9x12y6", // class name
  bases_G9x12y6, 6,
  &(vtc_G9x12y6[0]), // expected_vtbl_contents
  &(vtt_G9x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI7G9x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y6),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y6),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G9x12y7  : virtual E9x12 , virtual F0 {
  int ff;
  ~G9x12y7(); // tgen
  G9x12y7(); // tgen
};
//SIG(1 G9x12y7) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G9x12y7 ::~G9x12y7(){ note_dtor("G9x12y7", this);} // tgen
G9x12y7 ::G9x12y7(){ note_ctor("G9x12y7", this);} // tgen

static void Test_G9x12y7()
{
  extern Class_Descriptor cd_G9x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G9x12y7, buf);
    G9x12y7 *dp, &lv = *(dp=new (buf) G9x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G9x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G9x12y7)");
    check_base_class_offset(lv, (A1*)(C9*)(E9x12*), ABISELECT(16,8), "G9x12y7");
    check_base_class_offset(lv, (B0*)(C9*)(E9x12*), ABISELECT(40,28), "G9x12y7");
    check_base_class_offset(lv, (C9*)(E9x12*), ABISELECT(16,8), "G9x12y7");
    check_base_class_offset(lv, (D0*)(E9x12*), ABISELECT(32,20), "G9x12y7");
    check_base_class_offset(lv, (E9x12*), ABISELECT(16,8), "G9x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G9x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G9x12y7.ff");
    test_class_info(&lv, &cd_G9x12y7);
    dp->~G9x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG9x12y7(Test_G9x12y7, "G9x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7G9x12y7C1Ev();
extern void _ZN7G9x12y7D1Ev();
Name_Map name_map_G9x12y7[] = {
  NSPAIR(_ZN7G9x12y7C1Ev),
  NSPAIR(_ZN7G9x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C9;
extern VTBL_ENTRY _ZTI2C9[];
extern  VTBL_ENTRY _ZTV2C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT2C9[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E9x12;
extern VTBL_ENTRY _ZTI5E9x12[];
extern  VTBL_ENTRY _ZTV5E9x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5E9x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G9x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C9,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E9x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7G9x12y7[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY vtc_G9x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7G9x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7G9x12y7[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern VTBL_ENTRY _ZTV7G9x12y7[];
extern void _ZN5E9x123fooEv();
static  VTBL_ENTRY _tg__ZTV5E9x12__7G9x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5E9x12[0]),
  (VTBL_ENTRY)&_ZN5E9x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2C95E9x12__7G9x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI2C9[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_G9x12y7[] = {
  {&(_ZTV7G9x12y7[5]),  5,10},
  {&(_ZTV7G9x12y7[9]),  9,10},
  {&(_tg__ZTV5E9x12__7G9x12y7[3]),  3,4},
  {&(_tg__ZTV2C95E9x12__7G9x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7G9x12y7[];
extern  VTBL_ENTRY _ZTV7G9x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7G9x12y7[];
Class_Descriptor cd_G9x12y7 = {  "G9x12y7", // class name
  bases_G9x12y7, 6,
  &(vtc_G9x12y7[0]), // expected_vtbl_contents
  &(vtt_G9x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7G9x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7G9x12y7),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7G9x12y7),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E10x12  : C10 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E10x123fooEv
  ~E10x12(); // tgen
  E10x12(); // tgen
};
//SIG(-1 E10x12) C1{ BC2{ VBC3{ Fi} VBC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E10x12 ::foo(){vfunc_called(this, "_ZN6E10x123fooEv");}
E10x12 ::~E10x12(){ note_dtor("E10x12", this);} // tgen
E10x12 ::E10x12(){ note_ctor("E10x12", this);} // tgen

static void Test_E10x12()
{
  extern Class_Descriptor cd_E10x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E10x12, buf);
    E10x12 *dp, &lv = *(dp=new (buf) E10x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E10x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E10x12)");
    check_base_class_offset(lv, (A0*)(C10*), ABISELECT(20,16), "E10x12");
    check_base_class_offset(lv, (B0*)(C10*), ABISELECT(24,20), "E10x12");
    check_base_class_offset(lv, (C10*), 0, "E10x12");
    check_base_class_offset(lv, (D0*), ABISELECT(12,8), "E10x12");
    check_field_offset(lv, fd, ABISELECT(16,12), "E10x12.fd");
    test_class_info(&lv, &cd_E10x12);
    dp->~E10x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE10x12(Test_E10x12, "E10x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6E10x12C1Ev();
extern void _ZN6E10x12D1Ev();
Name_Map name_map_E10x12[] = {
  NSPAIR(_ZN6E10x12C1Ev),
  NSPAIR(_ZN6E10x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E10x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E10x12[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY vtc_E10x12[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
extern VTBL_ENTRY _ZTV6E10x12[];
static  VTBL_ENTRY _tg__ZTV3C10__6E10x12[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_E10x12[] = {
  {&(_ZTV6E10x12[4]),  4,5},
  {&(_tg__ZTV3C10__6E10x12[4]),  4,4},
};
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
Class_Descriptor cd_E10x12 = {  "E10x12", // class name
  bases_E10x12, 4,
  &(vtc_E10x12[0]), // expected_vtbl_contents
  &(vtt_E10x12[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6E10x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E10x12),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6E10x12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y0  : E10x12 , F1 {
  int ff;
  ~G10x12y0(); // tgen
  G10x12y0(); // tgen
};
//SIG(1 G10x12y0) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G10x12y0 ::~G10x12y0(){ note_dtor("G10x12y0", this);} // tgen
G10x12y0 ::G10x12y0(){ note_ctor("G10x12y0", this);} // tgen

static void Test_G10x12y0()
{
  extern Class_Descriptor cd_G10x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G10x12y0, buf);
    G10x12y0 *dp, &lv = *(dp=new (buf) G10x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G10x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y0)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(40,28), "G10x12y0");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(44,32), "G10x12y0");
    check_base_class_offset(lv, (C10*)(E10x12*), 0, "G10x12y0");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(12,8), "G10x12y0");
    check_base_class_offset(lv, (E10x12*), 0, "G10x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,16), "G10x12y0");
    check_field_offset(lv, ff, ABISELECT(36,24), "G10x12y0.ff");
    test_class_info(&lv, &cd_G10x12y0);
    dp->~G10x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y0(Test_G10x12y0, "G10x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G10x12y0C1Ev();
extern void _ZN8G10x12y0D1Ev();
Name_Map name_map_G10x12y0[] = {
  NSPAIR(_ZN8G10x12y0C1Ev),
  NSPAIR(_ZN8G10x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G10x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y0[];
extern void _ZN6E10x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G10x12y0[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y0[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8G10x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y0[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y0[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y0[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y0[] = {
  {&(_ZTV8G10x12y0[4]),  4,8},
  {&(_tg__ZTV6E10x12__8G10x12y0[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y0[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y0[];
extern  VTBL_ENTRY _ZTV8G10x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y0[];
Class_Descriptor cd_G10x12y0 = {  "G10x12y0", // class name
  bases_G10x12y0, 6,
  &(vtc_G10x12y0[0]), // expected_vtbl_contents
  &(vtt_G10x12y0[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G10x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y0),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y0),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y1  : virtual E10x12 , F1 {
  int ff;
  ~G10x12y1(); // tgen
  G10x12y1(); // tgen
};
//SIG(1 G10x12y1) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G10x12y1 ::~G10x12y1(){ note_dtor("G10x12y1", this);} // tgen
G10x12y1 ::G10x12y1(){ note_ctor("G10x12y1", this);} // tgen

static void Test_G10x12y1()
{
  extern Class_Descriptor cd_G10x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G10x12y1, buf);
    G10x12y1 *dp, &lv = *(dp=new (buf) G10x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G10x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y1)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(36,28), "G10x12y1");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(40,32), "G10x12y1");
    check_base_class_offset(lv, (C10*)(E10x12*), ABISELECT(16,12), "G10x12y1");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(28,20), "G10x12y1");
    check_base_class_offset(lv, (E10x12*), ABISELECT(16,12), "G10x12y1");
    check_base_class_offset(lv, (F1*), 0, "G10x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G10x12y1.ff");
    test_class_info(&lv, &cd_G10x12y1);
    dp->~G10x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y1(Test_G10x12y1, "G10x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G10x12y1C1Ev();
extern void _ZN8G10x12y1D1Ev();
Name_Map name_map_G10x12y1[] = {
  NSPAIR(_ZN8G10x12y1C1Ev),
  NSPAIR(_ZN8G10x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G10x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY vtc_G10x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(36,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G10x12y1[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y1[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y1[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y1[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y1[] = {
  {&(_ZTV8G10x12y1[5]),  5,12},
  {&(_ZTV8G10x12y1[11]),  11,12},
  {&(_tg__ZTV6E10x12__8G10x12y1[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y1[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y1[];
extern  VTBL_ENTRY _ZTV8G10x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y1[];
Class_Descriptor cd_G10x12y1 = {  "G10x12y1", // class name
  bases_G10x12y1, 6,
  &(vtc_G10x12y1[0]), // expected_vtbl_contents
  &(vtt_G10x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G10x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y1),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y1),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y2  : E10x12 , virtual F1 {
  int ff;
  ~G10x12y2(); // tgen
  G10x12y2(); // tgen
};
//SIG(1 G10x12y2) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G10x12y2 ::~G10x12y2(){ note_dtor("G10x12y2", this);} // tgen
G10x12y2 ::G10x12y2(){ note_ctor("G10x12y2", this);} // tgen

static void Test_G10x12y2()
{
  extern Class_Descriptor cd_G10x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G10x12y2, buf);
    G10x12y2 *dp, &lv = *(dp=new (buf) G10x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G10x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y2)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(24,20), "G10x12y2");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(28,24), "G10x12y2");
    check_base_class_offset(lv, (C10*)(E10x12*), 0, "G10x12y2");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(12,8), "G10x12y2");
    check_base_class_offset(lv, (E10x12*), 0, "G10x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G10x12y2");
    check_field_offset(lv, ff, ABISELECT(20,16), "G10x12y2.ff");
    test_class_info(&lv, &cd_G10x12y2);
    dp->~G10x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y2(Test_G10x12y2, "G10x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G10x12y2C1Ev();
extern void _ZN8G10x12y2D1Ev();
Name_Map name_map_G10x12y2[] = {
  NSPAIR(_ZN8G10x12y2C1Ev),
  NSPAIR(_ZN8G10x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G10x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y2[];
extern void _ZN6E10x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G10x12y2[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y2[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI8G10x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y2[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y2[] = {
  ABISELECT(28,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y2[] = {
  ABISELECT(28,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y2[] = {
  {&(_ZTV8G10x12y2[5]),  5,10},
  {&(_tg__ZTV6E10x12__8G10x12y2[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y2[4]),  4,4},
  {&(_ZTV8G10x12y2[9]),  9,10},
};
extern VTBL_ENTRY _ZTI8G10x12y2[];
extern  VTBL_ENTRY _ZTV8G10x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y2[];
Class_Descriptor cd_G10x12y2 = {  "G10x12y2", // class name
  bases_G10x12y2, 6,
  &(vtc_G10x12y2[0]), // expected_vtbl_contents
  &(vtt_G10x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G10x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y2),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y2),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y3  : virtual E10x12 , virtual F1 {
  int ff;
  ~G10x12y3(); // tgen
  G10x12y3(); // tgen
};
//SIG(1 G10x12y3) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G10x12y3 ::~G10x12y3(){ note_dtor("G10x12y3", this);} // tgen
G10x12y3 ::G10x12y3(){ note_ctor("G10x12y3", this);} // tgen

static void Test_G10x12y3()
{
  extern Class_Descriptor cd_G10x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G10x12y3, buf);
    G10x12y3 *dp, &lv = *(dp=new (buf) G10x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G10x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y3)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(36,24), "G10x12y3");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(40,28), "G10x12y3");
    check_base_class_offset(lv, (C10*)(E10x12*), ABISELECT(16,8), "G10x12y3");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(28,16), "G10x12y3");
    check_base_class_offset(lv, (E10x12*), ABISELECT(16,8), "G10x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G10x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G10x12y3.ff");
    test_class_info(&lv, &cd_G10x12y3);
    dp->~G10x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y3(Test_G10x12y3, "G10x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G10x12y3C1Ev();
extern void _ZN8G10x12y3D1Ev();
Name_Map name_map_G10x12y3[] = {
  NSPAIR(_ZN8G10x12y3C1Ev),
  NSPAIR(_ZN8G10x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G10x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y3[];
extern void _ZN6E10x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G10x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G10x12y3[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G10x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y3[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y3[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y3[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y3[] = {
  {&(_ZTV8G10x12y3[6]),  6,16},
  {&(_ZTV8G10x12y3[11]),  11,16},
  {&(_ZTV8G10x12y3[15]),  15,16},
  {&(_tg__ZTV6E10x12__8G10x12y3[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y3[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y3[];
extern  VTBL_ENTRY _ZTV8G10x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y3[];
Class_Descriptor cd_G10x12y3 = {  "G10x12y3", // class name
  bases_G10x12y3, 6,
  &(vtc_G10x12y3[0]), // expected_vtbl_contents
  &(vtt_G10x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G10x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y3),16, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y3),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y4  : E10x12 , F0 {
  int ff;
  ~G10x12y4(); // tgen
  G10x12y4(); // tgen
};
//SIG(1 G10x12y4) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G10x12y4 ::~G10x12y4(){ note_dtor("G10x12y4", this);} // tgen
G10x12y4 ::G10x12y4(){ note_ctor("G10x12y4", this);} // tgen

static void Test_G10x12y4()
{
  extern Class_Descriptor cd_G10x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G10x12y4, buf);
    G10x12y4 *dp, &lv = *(dp=new (buf) G10x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G10x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y4)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(28,24), "G10x12y4");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(32,28), "G10x12y4");
    check_base_class_offset(lv, (C10*)(E10x12*), 0, "G10x12y4");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(12,8), "G10x12y4");
    check_base_class_offset(lv, (E10x12*), 0, "G10x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(20,16), "G10x12y4");
    check_field_offset(lv, ff, ABISELECT(24,20), "G10x12y4.ff");
    test_class_info(&lv, &cd_G10x12y4);
    dp->~G10x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y4(Test_G10x12y4, "G10x12y4", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN8G10x12y4C1Ev();
extern void _ZN8G10x12y4D1Ev();
Name_Map name_map_G10x12y4[] = {
  NSPAIR(_ZN8G10x12y4C1Ev),
  NSPAIR(_ZN8G10x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G10x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y4[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY vtc_G10x12y4[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y4[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y4[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y4[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y4[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y4[] = {
  {&(_ZTV8G10x12y4[4]),  4,5},
  {&(_tg__ZTV6E10x12__8G10x12y4[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y4[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y4[];
extern  VTBL_ENTRY _ZTV8G10x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y4[];
Class_Descriptor cd_G10x12y4 = {  "G10x12y4", // class name
  bases_G10x12y4, 6,
  &(vtc_G10x12y4[0]), // expected_vtbl_contents
  &(vtt_G10x12y4[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI8G10x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y4),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y4),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y5  : virtual E10x12 , F0 {
  int ff;
  ~G10x12y5(); // tgen
  G10x12y5(); // tgen
};
//SIG(1 G10x12y5) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G10x12y5 ::~G10x12y5(){ note_dtor("G10x12y5", this);} // tgen
G10x12y5 ::G10x12y5(){ note_ctor("G10x12y5", this);} // tgen

static void Test_G10x12y5()
{
  extern Class_Descriptor cd_G10x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G10x12y5, buf);
    G10x12y5 *dp, &lv = *(dp=new (buf) G10x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G10x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y5)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(36,28), "G10x12y5");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(40,32), "G10x12y5");
    check_base_class_offset(lv, (C10*)(E10x12*), ABISELECT(16,12), "G10x12y5");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(28,20), "G10x12y5");
    check_base_class_offset(lv, (E10x12*), ABISELECT(16,12), "G10x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G10x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G10x12y5.ff");
    test_class_info(&lv, &cd_G10x12y5);
    dp->~G10x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y5(Test_G10x12y5, "G10x12y5", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G10x12y5C1Ev();
extern void _ZN8G10x12y5D1Ev();
Name_Map name_map_G10x12y5[] = {
  NSPAIR(_ZN8G10x12y5C1Ev),
  NSPAIR(_ZN8G10x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G10x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y5[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY vtc_G10x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(36,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G10x12y5[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y5[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y5[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y5[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y5[] = {
  {&(_ZTV8G10x12y5[5]),  5,11},
  {&(_ZTV8G10x12y5[10]),  10,11},
  {&(_tg__ZTV6E10x12__8G10x12y5[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y5[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y5[];
extern  VTBL_ENTRY _ZTV8G10x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y5[];
Class_Descriptor cd_G10x12y5 = {  "G10x12y5", // class name
  bases_G10x12y5, 6,
  &(vtc_G10x12y5[0]), // expected_vtbl_contents
  &(vtt_G10x12y5[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G10x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y5),11, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y5),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y6  : E10x12 , virtual F0 {
  int ff;
  ~G10x12y6(); // tgen
  G10x12y6(); // tgen
};
//SIG(1 G10x12y6) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G10x12y6 ::~G10x12y6(){ note_dtor("G10x12y6", this);} // tgen
G10x12y6 ::G10x12y6(){ note_ctor("G10x12y6", this);} // tgen

static void Test_G10x12y6()
{
  extern Class_Descriptor cd_G10x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G10x12y6, buf);
    G10x12y6 *dp, &lv = *(dp=new (buf) G10x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G10x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y6)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(24,20), "G10x12y6");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(28,24), "G10x12y6");
    check_base_class_offset(lv, (C10*)(E10x12*), 0, "G10x12y6");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(12,8), "G10x12y6");
    check_base_class_offset(lv, (E10x12*), 0, "G10x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(32,28), "G10x12y6");
    check_field_offset(lv, ff, ABISELECT(20,16), "G10x12y6.ff");
    test_class_info(&lv, &cd_G10x12y6);
    dp->~G10x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y6(Test_G10x12y6, "G10x12y6", ABISELECT(40,32));

#else // __cplusplus

extern void _ZN8G10x12y6C1Ev();
extern void _ZN8G10x12y6D1Ev();
Name_Map name_map_G10x12y6[] = {
  NSPAIR(_ZN8G10x12y6C1Ev),
  NSPAIR(_ZN8G10x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G10x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(32,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y6[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY vtc_G10x12y6[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y6[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y6[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y6[] = {
  ABISELECT(28,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y6[] = {
  ABISELECT(28,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y6[] = {
  {&(_ZTV8G10x12y6[5]),  5,6},
  {&(_tg__ZTV6E10x12__8G10x12y6[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y6[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y6[];
extern  VTBL_ENTRY _ZTV8G10x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y6[];
Class_Descriptor cd_G10x12y6 = {  "G10x12y6", // class name
  bases_G10x12y6, 6,
  &(vtc_G10x12y6[0]), // expected_vtbl_contents
  &(vtt_G10x12y6[0]), // expected_vtt_contents
  ABISELECT(40,32), // object size
  NSPAIRA(_ZTI8G10x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y6),6, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y6),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G10x12y7  : virtual E10x12 , virtual F0 {
  int ff;
  ~G10x12y7(); // tgen
  G10x12y7(); // tgen
};
//SIG(1 G10x12y7) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G10x12y7 ::~G10x12y7(){ note_dtor("G10x12y7", this);} // tgen
G10x12y7 ::G10x12y7(){ note_ctor("G10x12y7", this);} // tgen

static void Test_G10x12y7()
{
  extern Class_Descriptor cd_G10x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G10x12y7, buf);
    G10x12y7 *dp, &lv = *(dp=new (buf) G10x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G10x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G10x12y7)");
    check_base_class_offset(lv, (A0*)(C10*)(E10x12*), ABISELECT(36,24), "G10x12y7");
    check_base_class_offset(lv, (B0*)(C10*)(E10x12*), ABISELECT(40,28), "G10x12y7");
    check_base_class_offset(lv, (C10*)(E10x12*), ABISELECT(16,8), "G10x12y7");
    check_base_class_offset(lv, (D0*)(E10x12*), ABISELECT(28,16), "G10x12y7");
    check_base_class_offset(lv, (E10x12*), ABISELECT(16,8), "G10x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G10x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G10x12y7.ff");
    test_class_info(&lv, &cd_G10x12y7);
    dp->~G10x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG10x12y7(Test_G10x12y7, "G10x12y7", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G10x12y7C1Ev();
extern void _ZN8G10x12y7D1Ev();
Name_Map name_map_G10x12y7[] = {
  NSPAIR(_ZN8G10x12y7C1Ev),
  NSPAIR(_ZN8G10x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C10;
extern VTBL_ENTRY _ZTI3C10[];
extern  VTBL_ENTRY _ZTV3C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C10[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E10x12;
extern VTBL_ENTRY _ZTI6E10x12[];
extern  VTBL_ENTRY _ZTV6E10x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E10x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G10x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E10x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G10x12y7[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY vtc_G10x12y7[] = {
  ABISELECT(44,32),
  ABISELECT(40,28),
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G10x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G10x12y7[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
extern VTBL_ENTRY _ZTV8G10x12y7[];
extern void _ZN6E10x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E10x12__8G10x12y7[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E10x12[0]),
  (VTBL_ENTRY)&_ZN6E10x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C106E10x12__8G10x12y7[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C10[0]),
};
static  VTT_ENTRY vtt_G10x12y7[] = {
  {&(_ZTV8G10x12y7[6]),  6,12},
  {&(_ZTV8G10x12y7[11]),  11,12},
  {&(_tg__ZTV6E10x12__8G10x12y7[4]),  4,5},
  {&(_tg__ZTV3C106E10x12__8G10x12y7[4]),  4,4},
};
extern VTBL_ENTRY _ZTI8G10x12y7[];
extern  VTBL_ENTRY _ZTV8G10x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G10x12y7[];
Class_Descriptor cd_G10x12y7 = {  "G10x12y7", // class name
  bases_G10x12y7, 6,
  &(vtc_G10x12y7[0]), // expected_vtbl_contents
  &(vtt_G10x12y7[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G10x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G10x12y7),12, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G10x12y7),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E11x12  : C11 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E11x123fooEv
  ~E11x12(); // tgen
  E11x12(); // tgen
};
//SIG(-1 E11x12) C1{ BC2{ VBC3{ v1 Fi} VBC4{ Fi} Fi} BC5{ Fi} v1 Fi}


void  E11x12 ::foo(){vfunc_called(this, "_ZN6E11x123fooEv");}
E11x12 ::~E11x12(){ note_dtor("E11x12", this);} // tgen
E11x12 ::E11x12(){ note_ctor("E11x12", this);} // tgen

static void Test_E11x12()
{
  extern Class_Descriptor cd_E11x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E11x12, buf);
    E11x12 *dp, &lv = *(dp=new (buf) E11x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E11x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E11x12)");
    check_base_class_offset(lv, (A1*)(C11*), ABISELECT(24,16), "E11x12");
    check_base_class_offset(lv, (B0*)(C11*), ABISELECT(36,24), "E11x12");
    check_base_class_offset(lv, (C11*), 0, "E11x12");
    check_base_class_offset(lv, (D0*), ABISELECT(12,8), "E11x12");
    check_field_offset(lv, fd, ABISELECT(16,12), "E11x12.fd");
    test_class_info(&lv, &cd_E11x12);
    dp->~E11x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE11x12(Test_E11x12, "E11x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6E11x12C1Ev();
extern void _ZN6E11x12D1Ev();
Name_Map name_map_E11x12[] = {
  NSPAIR(_ZN6E11x12C1Ev),
  NSPAIR(_ZN6E11x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E11x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E11x12[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E11x12[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV6E11x12[];
static  VTBL_ENTRY _tg__ZTV3C11__6E11x12[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C11__6E11x12[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
static  VTT_ENTRY vtt_E11x12[] = {
  {&(_ZTV6E11x12[4]),  4,9},
  {&(_tg__ZTV3C11__6E11x12[4]),  4,4},
  {&(_tg__ZTV2A1__3C11__6E11x12[3]),  3,4},
  {&(_ZTV6E11x12[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E11x12 = {  "E11x12", // class name
  bases_E11x12, 4,
  &(vtc_E11x12[0]), // expected_vtbl_contents
  &(vtt_E11x12[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6E11x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E11x12),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6E11x12),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y0  : E11x12 , F1 {
  int ff;
  ~G11x12y0(); // tgen
  G11x12y0(); // tgen
};
//SIG(1 G11x12y0) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G11x12y0 ::~G11x12y0(){ note_dtor("G11x12y0", this);} // tgen
G11x12y0 ::G11x12y0(){ note_ctor("G11x12y0", this);} // tgen

static void Test_G11x12y0()
{
  extern Class_Descriptor cd_G11x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G11x12y0, buf);
    G11x12y0 *dp, &lv = *(dp=new (buf) G11x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G11x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y0)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(40,28), "G11x12y0");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(52,36), "G11x12y0");
    check_base_class_offset(lv, (C11*)(E11x12*), 0, "G11x12y0");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(12,8), "G11x12y0");
    check_base_class_offset(lv, (E11x12*), 0, "G11x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,16), "G11x12y0");
    check_field_offset(lv, ff, ABISELECT(36,24), "G11x12y0.ff");
    test_class_info(&lv, &cd_G11x12y0);
    dp->~G11x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y0(Test_G11x12y0, "G11x12y0", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G11x12y0C1Ev();
extern void _ZN8G11x12y0D1Ev();
Name_Map name_map_G11x12y0[] = {
  NSPAIR(_ZN8G11x12y0C1Ev),
  NSPAIR(_ZN8G11x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G11x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y0[];
extern void _ZN6E11x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn40_N6E11x123fooEv,_ZThn28_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11x12y0[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y0[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8G11x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G11x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV8G11x12y0[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y0[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y0[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y0[] = {
  0,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn40_N6E11x123fooEv,_ZThn28_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y0[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y0[] = {
  {&(_ZTV8G11x12y0[4]),  4,12},
  {&(_tg__ZTV6E11x12__8G11x12y0[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y0[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y0[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y0[3]),  3,4},
  {&(_ZTV8G11x12y0[11]),  11,12},
};
extern VTBL_ENTRY _ZTI8G11x12y0[];
extern  VTBL_ENTRY _ZTV8G11x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y0[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E11x123fooEv,_ZThn28_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E11x123fooEv,_ZThn28_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y0 = {  "G11x12y0", // class name
  bases_G11x12y0, 6,
  &(vtc_G11x12y0[0]), // expected_vtbl_contents
  &(vtt_G11x12y0[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G11x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y0),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y0),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y1  : virtual E11x12 , F1 {
  int ff;
  ~G11x12y1(); // tgen
  G11x12y1(); // tgen
};
//SIG(1 G11x12y1) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G11x12y1 ::~G11x12y1(){ note_dtor("G11x12y1", this);} // tgen
G11x12y1 ::G11x12y1(){ note_ctor("G11x12y1", this);} // tgen

static void Test_G11x12y1()
{
  extern Class_Descriptor cd_G11x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G11x12y1, buf);
    G11x12y1 *dp, &lv = *(dp=new (buf) G11x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G11x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y1)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(40,28), "G11x12y1");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(52,36), "G11x12y1");
    check_base_class_offset(lv, (C11*)(E11x12*), ABISELECT(16,12), "G11x12y1");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(28,20), "G11x12y1");
    check_base_class_offset(lv, (E11x12*), ABISELECT(16,12), "G11x12y1");
    check_base_class_offset(lv, (F1*), 0, "G11x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G11x12y1.ff");
    test_class_info(&lv, &cd_G11x12y1);
    dp->~G11x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y1(Test_G11x12y1, "G11x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G11x12y1C1Ev();
extern void _ZN8G11x12y1D1Ev();
Name_Map name_map_G11x12y1[] = {
  NSPAIR(_ZN8G11x12y1C1Ev),
  NSPAIR(_ZN8G11x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G11x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11x12y1[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(36,24),
  ABISELECT(24,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G11x12y1[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G11x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV8G11x12y1[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y1[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y1[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y1[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y1[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y1[] = {
  {&(_ZTV8G11x12y1[5]),  5,16},
  {&(_ZTV8G11x12y1[11]),  11,16},
  {&(_ZTV8G11x12y1[15]),  15,16},
  {&(_tg__ZTV6E11x12__8G11x12y1[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y1[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y1[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G11x12y1[];
extern  VTBL_ENTRY _ZTV8G11x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y1[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y1 = {  "G11x12y1", // class name
  bases_G11x12y1, 6,
  &(vtc_G11x12y1[0]), // expected_vtbl_contents
  &(vtt_G11x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G11x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y1),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y1),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y2  : E11x12 , virtual F1 {
  int ff;
  ~G11x12y2(); // tgen
  G11x12y2(); // tgen
};
//SIG(1 G11x12y2) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G11x12y2 ::~G11x12y2(){ note_dtor("G11x12y2", this);} // tgen
G11x12y2 ::G11x12y2(){ note_ctor("G11x12y2", this);} // tgen

static void Test_G11x12y2()
{
  extern Class_Descriptor cd_G11x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G11x12y2, buf);
    G11x12y2 *dp, &lv = *(dp=new (buf) G11x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G11x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y2)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(24,20), "G11x12y2");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(36,28), "G11x12y2");
    check_base_class_offset(lv, (C11*)(E11x12*), 0, "G11x12y2");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(12,8), "G11x12y2");
    check_base_class_offset(lv, (E11x12*), 0, "G11x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(40,32), "G11x12y2");
    check_field_offset(lv, ff, ABISELECT(20,16), "G11x12y2.ff");
    test_class_info(&lv, &cd_G11x12y2);
    dp->~G11x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y2(Test_G11x12y2, "G11x12y2", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G11x12y2C1Ev();
extern void _ZN8G11x12y2D1Ev();
Name_Map name_map_G11x12y2[] = {
  NSPAIR(_ZN8G11x12y2C1Ev),
  NSPAIR(_ZN8G11x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G11x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(40,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y2[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G11x12y2[] = {
  ABISELECT(40,32),
  ABISELECT(36,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y2[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI8G11x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
  0,
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G11x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G11x12y2[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y2[] = {
  ABISELECT(36,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y2[] = {
  ABISELECT(36,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y2[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y2[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y2[] = {
  {&(_ZTV8G11x12y2[5]),  5,14},
  {&(_tg__ZTV6E11x12__8G11x12y2[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y2[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y2[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y2[3]),  3,4},
  {&(_ZTV8G11x12y2[9]),  9,14},
  {&(_ZTV8G11x12y2[13]),  13,14},
};
extern VTBL_ENTRY _ZTI8G11x12y2[];
extern  VTBL_ENTRY _ZTV8G11x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y2[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y2 = {  "G11x12y2", // class name
  bases_G11x12y2, 6,
  &(vtc_G11x12y2[0]), // expected_vtbl_contents
  &(vtt_G11x12y2[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G11x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y2),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y2),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y3  : virtual E11x12 , virtual F1 {
  int ff;
  ~G11x12y3(); // tgen
  G11x12y3(); // tgen
};
//SIG(1 G11x12y3) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G11x12y3 ::~G11x12y3(){ note_dtor("G11x12y3", this);} // tgen
G11x12y3 ::G11x12y3(){ note_ctor("G11x12y3", this);} // tgen

static void Test_G11x12y3()
{
  extern Class_Descriptor cd_G11x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G11x12y3, buf);
    G11x12y3 *dp, &lv = *(dp=new (buf) G11x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G11x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y3)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(40,24), "G11x12y3");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(52,32), "G11x12y3");
    check_base_class_offset(lv, (C11*)(E11x12*), ABISELECT(16,8), "G11x12y3");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(28,16), "G11x12y3");
    check_base_class_offset(lv, (E11x12*), ABISELECT(16,8), "G11x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G11x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G11x12y3.ff");
    test_class_info(&lv, &cd_G11x12y3);
    dp->~G11x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y3(Test_G11x12y3, "G11x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G11x12y3C1Ev();
extern void _ZN8G11x12y3D1Ev();
Name_Map name_map_G11x12y3[] = {
  NSPAIR(_ZN8G11x12y3C1Ev),
  NSPAIR(_ZN8G11x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G11x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(52,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y3[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G11x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(52,32),
  ABISELECT(40,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y3[0]),
  0,
  ABISELECT(36,24),
  ABISELECT(24,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G11x12y3[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8G11x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G11x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G11x12y3[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y3[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y3[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y3[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y3[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y3[] = {
  {&(_ZTV8G11x12y3[6]),  6,20},
  {&(_ZTV8G11x12y3[11]),  11,20},
  {&(_ZTV8G11x12y3[15]),  15,20},
  {&(_ZTV8G11x12y3[19]),  19,20},
  {&(_tg__ZTV6E11x12__8G11x12y3[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y3[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y3[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G11x12y3[];
extern  VTBL_ENTRY _ZTV8G11x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y3[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y3 = {  "G11x12y3", // class name
  bases_G11x12y3, 6,
  &(vtc_G11x12y3[0]), // expected_vtbl_contents
  &(vtt_G11x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G11x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y3),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y3),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y4  : E11x12 , F0 {
  int ff;
  ~G11x12y4(); // tgen
  G11x12y4(); // tgen
};
//SIG(1 G11x12y4) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G11x12y4 ::~G11x12y4(){ note_dtor("G11x12y4", this);} // tgen
G11x12y4 ::G11x12y4(){ note_ctor("G11x12y4", this);} // tgen

static void Test_G11x12y4()
{
  extern Class_Descriptor cd_G11x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G11x12y4, buf);
    G11x12y4 *dp, &lv = *(dp=new (buf) G11x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G11x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y4)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(32,24), "G11x12y4");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(44,32), "G11x12y4");
    check_base_class_offset(lv, (C11*)(E11x12*), 0, "G11x12y4");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(12,8), "G11x12y4");
    check_base_class_offset(lv, (E11x12*), 0, "G11x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(20,16), "G11x12y4");
    check_field_offset(lv, ff, ABISELECT(24,20), "G11x12y4.ff");
    test_class_info(&lv, &cd_G11x12y4);
    dp->~G11x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y4(Test_G11x12y4, "G11x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G11x12y4C1Ev();
extern void _ZN8G11x12y4D1Ev();
Name_Map name_map_G11x12y4[] = {
  NSPAIR(_ZN8G11x12y4C1Ev),
  NSPAIR(_ZN8G11x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G11x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y4[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn32_N6E11x123fooEv,_ZThn24_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11x12y4[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y4[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G11x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV8G11x12y4[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y4[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y4[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y4[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn32_N6E11x123fooEv,_ZThn24_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y4[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y4[] = {
  {&(_ZTV8G11x12y4[4]),  4,9},
  {&(_tg__ZTV6E11x12__8G11x12y4[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y4[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y4[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y4[3]),  3,4},
  {&(_ZTV8G11x12y4[8]),  8,9},
};
extern VTBL_ENTRY _ZTI8G11x12y4[];
extern  VTBL_ENTRY _ZTV8G11x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y4[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E11x123fooEv,_ZThn24_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E11x123fooEv,_ZThn24_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y4 = {  "G11x12y4", // class name
  bases_G11x12y4, 6,
  &(vtc_G11x12y4[0]), // expected_vtbl_contents
  &(vtt_G11x12y4[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G11x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y4),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y4),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y5  : virtual E11x12 , F0 {
  int ff;
  ~G11x12y5(); // tgen
  G11x12y5(); // tgen
};
//SIG(1 G11x12y5) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G11x12y5 ::~G11x12y5(){ note_dtor("G11x12y5", this);} // tgen
G11x12y5 ::G11x12y5(){ note_ctor("G11x12y5", this);} // tgen

static void Test_G11x12y5()
{
  extern Class_Descriptor cd_G11x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G11x12y5, buf);
    G11x12y5 *dp, &lv = *(dp=new (buf) G11x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G11x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y5)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(40,28), "G11x12y5");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(52,36), "G11x12y5");
    check_base_class_offset(lv, (C11*)(E11x12*), ABISELECT(16,12), "G11x12y5");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(28,20), "G11x12y5");
    check_base_class_offset(lv, (E11x12*), ABISELECT(16,12), "G11x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G11x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G11x12y5.ff");
    test_class_info(&lv, &cd_G11x12y5);
    dp->~G11x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y5(Test_G11x12y5, "G11x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G11x12y5C1Ev();
extern void _ZN8G11x12y5D1Ev();
Name_Map name_map_G11x12y5[] = {
  NSPAIR(_ZN8G11x12y5C1Ev),
  NSPAIR(_ZN8G11x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G11x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y5[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11x12y5[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y5[0]),
  0,
  ABISELECT(36,24),
  ABISELECT(24,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G11x12y5[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G11x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV8G11x12y5[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y5[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y5[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y5[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y5[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y5[] = {
  {&(_ZTV8G11x12y5[5]),  5,15},
  {&(_ZTV8G11x12y5[10]),  10,15},
  {&(_ZTV8G11x12y5[14]),  14,15},
  {&(_tg__ZTV6E11x12__8G11x12y5[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y5[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y5[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G11x12y5[];
extern  VTBL_ENTRY _ZTV8G11x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y5[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y5 = {  "G11x12y5", // class name
  bases_G11x12y5, 6,
  &(vtc_G11x12y5[0]), // expected_vtbl_contents
  &(vtt_G11x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G11x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y5),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y5),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y6  : E11x12 , virtual F0 {
  int ff;
  ~G11x12y6(); // tgen
  G11x12y6(); // tgen
};
//SIG(1 G11x12y6) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G11x12y6 ::~G11x12y6(){ note_dtor("G11x12y6", this);} // tgen
G11x12y6 ::G11x12y6(){ note_ctor("G11x12y6", this);} // tgen

static void Test_G11x12y6()
{
  extern Class_Descriptor cd_G11x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G11x12y6, buf);
    G11x12y6 *dp, &lv = *(dp=new (buf) G11x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G11x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y6)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(24,20), "G11x12y6");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(36,28), "G11x12y6");
    check_base_class_offset(lv, (C11*)(E11x12*), 0, "G11x12y6");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(12,8), "G11x12y6");
    check_base_class_offset(lv, (E11x12*), 0, "G11x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(40,32), "G11x12y6");
    check_field_offset(lv, ff, ABISELECT(20,16), "G11x12y6.ff");
    test_class_info(&lv, &cd_G11x12y6);
    dp->~G11x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y6(Test_G11x12y6, "G11x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G11x12y6C1Ev();
extern void _ZN8G11x12y6D1Ev();
Name_Map name_map_G11x12y6[] = {
  NSPAIR(_ZN8G11x12y6C1Ev),
  NSPAIR(_ZN8G11x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G11x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(40,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y6[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11x12y6[] = {
  ABISELECT(40,32),
  ABISELECT(36,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y6[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI8G11x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV8G11x12y6[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y6[] = {
  ABISELECT(36,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y6[] = {
  ABISELECT(36,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y6[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y6[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y6[] = {
  {&(_ZTV8G11x12y6[5]),  5,10},
  {&(_tg__ZTV6E11x12__8G11x12y6[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y6[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y6[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y6[3]),  3,4},
  {&(_ZTV8G11x12y6[9]),  9,10},
};
extern VTBL_ENTRY _ZTI8G11x12y6[];
extern  VTBL_ENTRY _ZTV8G11x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y6[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn20_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y6 = {  "G11x12y6", // class name
  bases_G11x12y6, 6,
  &(vtc_G11x12y6[0]), // expected_vtbl_contents
  &(vtt_G11x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G11x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y6),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y6),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11x12y7  : virtual E11x12 , virtual F0 {
  int ff;
  ~G11x12y7(); // tgen
  G11x12y7(); // tgen
};
//SIG(1 G11x12y7) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G11x12y7 ::~G11x12y7(){ note_dtor("G11x12y7", this);} // tgen
G11x12y7 ::G11x12y7(){ note_ctor("G11x12y7", this);} // tgen

static void Test_G11x12y7()
{
  extern Class_Descriptor cd_G11x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G11x12y7, buf);
    G11x12y7 *dp, &lv = *(dp=new (buf) G11x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G11x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11x12y7)");
    check_base_class_offset(lv, (A1*)(C11*)(E11x12*), ABISELECT(40,24), "G11x12y7");
    check_base_class_offset(lv, (B0*)(C11*)(E11x12*), ABISELECT(52,32), "G11x12y7");
    check_base_class_offset(lv, (C11*)(E11x12*), ABISELECT(16,8), "G11x12y7");
    check_base_class_offset(lv, (D0*)(E11x12*), ABISELECT(28,16), "G11x12y7");
    check_base_class_offset(lv, (E11x12*), ABISELECT(16,8), "G11x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(56,36), "G11x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G11x12y7.ff");
    test_class_info(&lv, &cd_G11x12y7);
    dp->~G11x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11x12y7(Test_G11x12y7, "G11x12y7", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G11x12y7C1Ev();
extern void _ZN8G11x12y7D1Ev();
Name_Map name_map_G11x12y7[] = {
  NSPAIR(_ZN8G11x12y7C1Ev),
  NSPAIR(_ZN8G11x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C11;
extern VTBL_ENTRY _ZTI3C11[];
extern  VTBL_ENTRY _ZTV3C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C11[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E11x12;
extern VTBL_ENTRY _ZTI6E11x12[];
extern  VTBL_ENTRY _ZTV6E11x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E11x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G11x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B0,    ABISELECT(52,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C11,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E11x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G11x12y7[];
extern void _ZN6E11x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11x12y7[] = {
  ABISELECT(56,36),
  ABISELECT(52,32),
  ABISELECT(40,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G11x12y7[0]),
  0,
  ABISELECT(36,24),
  ABISELECT(24,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G11x12y7[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8G11x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
extern VTBL_ENTRY _ZTV8G11x12y7[];
extern void _ZN6E11x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E11x12__8G11x12y7[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&_ZN6E11x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C116E11x12__8G11x12y7[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C11[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C116E11x12__8G11x12y7[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C11[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv)();
extern void ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E11x12__8G11x12y7[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E11x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv),
};
static  VTT_ENTRY vtt_G11x12y7[] = {
  {&(_ZTV8G11x12y7[6]),  6,16},
  {&(_ZTV8G11x12y7[11]),  11,16},
  {&(_ZTV8G11x12y7[15]),  15,16},
  {&(_tg__ZTV6E11x12__8G11x12y7[4]),  4,5},
  {&(_tg__ZTV3C116E11x12__8G11x12y7[4]),  4,4},
  {&(_tg__ZTV2A1__3C116E11x12__8G11x12y7[3]),  3,4},
  {&(_tg__ZTV2A1__6E11x12__8G11x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G11x12y7[];
extern  VTBL_ENTRY _ZTV8G11x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G11x12y7[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E11x123fooEv,_ZTv0_n12_N6E11x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E11x123fooEv,_ZThn16_N6E11x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11x12y7 = {  "G11x12y7", // class name
  bases_G11x12y7, 6,
  &(vtc_G11x12y7[0]), // expected_vtbl_contents
  &(vtt_G11x12y7[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G11x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G11x12y7),16, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G11x12y7),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E12x12  : C12 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E12x123fooEv
  ~E12x12(); // tgen
  E12x12(); // tgen
};
//SIG(-1 E12x12) C1{ BC2{ BC3{ Fi} VBC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E12x12 ::foo(){vfunc_called(this, "_ZN6E12x123fooEv");}
E12x12 ::~E12x12(){ note_dtor("E12x12", this);} // tgen
E12x12 ::E12x12(){ note_ctor("E12x12", this);} // tgen

static void Test_E12x12()
{
  extern Class_Descriptor cd_E12x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E12x12, buf);
    E12x12 *dp, &lv = *(dp=new (buf) E12x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E12x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E12x12)");
    check_base_class_offset(lv, (A0*)(C12*), ABISELECT(8,4), "E12x12");
    check_base_class_offset(lv, (B1*)(C12*), ABISELECT(24,20), "E12x12");
    check_base_class_offset(lv, (C12*), 0, "E12x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E12x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E12x12.fd");
    test_class_info(&lv, &cd_E12x12);
    dp->~E12x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE12x12(Test_E12x12, "E12x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6E12x12C1Ev();
extern void _ZN6E12x12D1Ev();
Name_Map name_map_E12x12[] = {
  NSPAIR(_ZN6E12x12C1Ev),
  NSPAIR(_ZN6E12x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E12x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E12x12[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E12x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV6E12x12[];
static  VTBL_ENTRY _tg__ZTV3C12__6E12x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C12__6E12x12[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_E12x12[] = {
  {&(_ZTV6E12x12[3]),  3,8},
  {&(_tg__ZTV3C12__6E12x12[3]),  3,3},
  {&(_tg__ZTV2B1__3C12__6E12x12[3]),  3,4},
  {&(_ZTV6E12x12[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E12x12 = {  "E12x12", // class name
  bases_E12x12, 4,
  &(vtc_E12x12[0]), // expected_vtbl_contents
  &(vtt_E12x12[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6E12x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E12x12),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6E12x12),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y0  : E12x12 , F1 {
  int ff;
  ~G12x12y0(); // tgen
  G12x12y0(); // tgen
};
//SIG(1 G12x12y0) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G12x12y0 ::~G12x12y0(){ note_dtor("G12x12y0", this);} // tgen
G12x12y0 ::G12x12y0(){ note_ctor("G12x12y0", this);} // tgen

static void Test_G12x12y0()
{
  extern Class_Descriptor cd_G12x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G12x12y0, buf);
    G12x12y0 *dp, &lv = *(dp=new (buf) G12x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G12x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y0)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(8,4), "G12x12y0");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(40,32), "G12x12y0");
    check_base_class_offset(lv, (C12*)(E12x12*), 0, "G12x12y0");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(16,12), "G12x12y0");
    check_base_class_offset(lv, (E12x12*), 0, "G12x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G12x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G12x12y0.ff");
    test_class_info(&lv, &cd_G12x12y0);
    dp->~G12x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y0(Test_G12x12y0, "G12x12y0", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G12x12y0C1Ev();
extern void _ZN8G12x12y0D1Ev();
Name_Map name_map_G12x12y0[] = {
  NSPAIR(_ZN8G12x12y0C1Ev),
  NSPAIR(_ZN8G12x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G12x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y0[];
extern void _ZN6E12x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn40_N6E12x123fooEv,_ZThn32_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y0[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI8G12x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G12x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV8G12x12y0[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y0[] = {
  0,
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn40_N6E12x123fooEv,_ZThn32_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y0[] = {
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y0[] = {
  {&(_ZTV8G12x12y0[3]),  3,11},
  {&(_tg__ZTV6E12x12__8G12x12y0[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y0[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y0[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y0[3]),  3,4},
  {&(_ZTV8G12x12y0[10]),  10,11},
};
extern VTBL_ENTRY _ZTI8G12x12y0[];
extern  VTBL_ENTRY _ZTV8G12x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y0[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E12x123fooEv,_ZThn32_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E12x123fooEv,_ZThn32_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y0 = {  "G12x12y0", // class name
  bases_G12x12y0, 6,
  &(vtc_G12x12y0[0]), // expected_vtbl_contents
  &(vtt_G12x12y0[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G12x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y0),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y0),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y1  : virtual E12x12 , F1 {
  int ff;
  ~G12x12y1(); // tgen
  G12x12y1(); // tgen
};
//SIG(1 G12x12y1) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G12x12y1 ::~G12x12y1(){ note_dtor("G12x12y1", this);} // tgen
G12x12y1 ::G12x12y1(){ note_ctor("G12x12y1", this);} // tgen

static void Test_G12x12y1()
{
  extern Class_Descriptor cd_G12x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G12x12y1, buf);
    G12x12y1 *dp, &lv = *(dp=new (buf) G12x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G12x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y1)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(24,16), "G12x12y1");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(40,32), "G12x12y1");
    check_base_class_offset(lv, (C12*)(E12x12*), ABISELECT(16,12), "G12x12y1");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(32,24), "G12x12y1");
    check_base_class_offset(lv, (E12x12*), ABISELECT(16,12), "G12x12y1");
    check_base_class_offset(lv, (F1*), 0, "G12x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G12x12y1.ff");
    test_class_info(&lv, &cd_G12x12y1);
    dp->~G12x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y1(Test_G12x12y1, "G12x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G12x12y1C1Ev();
extern void _ZN8G12x12y1D1Ev();
Name_Map name_map_G12x12y1[] = {
  NSPAIR(_ZN8G12x12y1C1Ev),
  NSPAIR(_ZN8G12x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G12x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G12x12y1[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G12x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV8G12x12y1[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y1[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y1[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y1[] = {
  {&(_ZTV8G12x12y1[4]),  4,14},
  {&(_ZTV8G12x12y1[9]),  9,14},
  {&(_ZTV8G12x12y1[13]),  13,14},
  {&(_tg__ZTV6E12x12__8G12x12y1[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y1[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y1[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G12x12y1[];
extern  VTBL_ENTRY _ZTV8G12x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y1[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y1 = {  "G12x12y1", // class name
  bases_G12x12y1, 6,
  &(vtc_G12x12y1[0]), // expected_vtbl_contents
  &(vtt_G12x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G12x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y1),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y1),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y2  : E12x12 , virtual F1 {
  int ff;
  ~G12x12y2(); // tgen
  G12x12y2(); // tgen
};
//SIG(1 G12x12y2) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G12x12y2 ::~G12x12y2(){ note_dtor("G12x12y2", this);} // tgen
G12x12y2 ::G12x12y2(){ note_ctor("G12x12y2", this);} // tgen

static void Test_G12x12y2()
{
  extern Class_Descriptor cd_G12x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G12x12y2, buf);
    G12x12y2 *dp, &lv = *(dp=new (buf) G12x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G12x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y2)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(8,4), "G12x12y2");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(32,24), "G12x12y2");
    check_base_class_offset(lv, (C12*)(E12x12*), 0, "G12x12y2");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(16,12), "G12x12y2");
    check_base_class_offset(lv, (E12x12*), 0, "G12x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G12x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G12x12y2.ff");
    test_class_info(&lv, &cd_G12x12y2);
    dp->~G12x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y2(Test_G12x12y2, "G12x12y2", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G12x12y2C1Ev();
extern void _ZN8G12x12y2D1Ev();
Name_Map name_map_G12x12y2[] = {
  NSPAIR(_ZN8G12x12y2C1Ev),
  NSPAIR(_ZN8G12x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G12x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y2[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G12x12y2[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y2[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G12x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G12x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G12x12y2[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y2[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y2[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y2[] = {
  {&(_ZTV8G12x12y2[4]),  4,13},
  {&(_tg__ZTV6E12x12__8G12x12y2[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y2[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y2[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y2[3]),  3,4},
  {&(_ZTV8G12x12y2[8]),  8,13},
  {&(_ZTV8G12x12y2[12]),  12,13},
};
extern VTBL_ENTRY _ZTI8G12x12y2[];
extern  VTBL_ENTRY _ZTV8G12x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y2[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y2 = {  "G12x12y2", // class name
  bases_G12x12y2, 6,
  &(vtc_G12x12y2[0]), // expected_vtbl_contents
  &(vtt_G12x12y2[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G12x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y2),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y2),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y3  : virtual E12x12 , virtual F1 {
  int ff;
  ~G12x12y3(); // tgen
  G12x12y3(); // tgen
};
//SIG(1 G12x12y3) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G12x12y3 ::~G12x12y3(){ note_dtor("G12x12y3", this);} // tgen
G12x12y3 ::G12x12y3(){ note_ctor("G12x12y3", this);} // tgen

static void Test_G12x12y3()
{
  extern Class_Descriptor cd_G12x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G12x12y3, buf);
    G12x12y3 *dp, &lv = *(dp=new (buf) G12x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G12x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y3)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(24,12), "G12x12y3");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(40,28), "G12x12y3");
    check_base_class_offset(lv, (C12*)(E12x12*), ABISELECT(16,8), "G12x12y3");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(32,20), "G12x12y3");
    check_base_class_offset(lv, (E12x12*), ABISELECT(16,8), "G12x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G12x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G12x12y3.ff");
    test_class_info(&lv, &cd_G12x12y3);
    dp->~G12x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y3(Test_G12x12y3, "G12x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G12x12y3C1Ev();
extern void _ZN8G12x12y3D1Ev();
Name_Map name_map_G12x12y3[] = {
  NSPAIR(_ZN8G12x12y3C1Ev),
  NSPAIR(_ZN8G12x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G12x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y3[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G12x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G12x12y3[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G12x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G12x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G12x12y3[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y3[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y3[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y3[] = {
  {&(_ZTV8G12x12y3[5]),  5,18},
  {&(_ZTV8G12x12y3[9]),  9,18},
  {&(_ZTV8G12x12y3[13]),  13,18},
  {&(_ZTV8G12x12y3[17]),  17,18},
  {&(_tg__ZTV6E12x12__8G12x12y3[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y3[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y3[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G12x12y3[];
extern  VTBL_ENTRY _ZTV8G12x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y3[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y3 = {  "G12x12y3", // class name
  bases_G12x12y3, 6,
  &(vtc_G12x12y3[0]), // expected_vtbl_contents
  &(vtt_G12x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G12x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y3),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y3),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y4  : E12x12 , F0 {
  int ff;
  ~G12x12y4(); // tgen
  G12x12y4(); // tgen
};
//SIG(1 G12x12y4) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G12x12y4 ::~G12x12y4(){ note_dtor("G12x12y4", this);} // tgen
G12x12y4 ::G12x12y4(){ note_ctor("G12x12y4", this);} // tgen

static void Test_G12x12y4()
{
  extern Class_Descriptor cd_G12x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G12x12y4, buf);
    G12x12y4 *dp, &lv = *(dp=new (buf) G12x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G12x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y4)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(8,4), "G12x12y4");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(32,28), "G12x12y4");
    check_base_class_offset(lv, (C12*)(E12x12*), 0, "G12x12y4");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(16,12), "G12x12y4");
    check_base_class_offset(lv, (E12x12*), 0, "G12x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G12x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G12x12y4.ff");
    test_class_info(&lv, &cd_G12x12y4);
    dp->~G12x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y4(Test_G12x12y4, "G12x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G12x12y4C1Ev();
extern void _ZN8G12x12y4D1Ev();
Name_Map name_map_G12x12y4[] = {
  NSPAIR(_ZN8G12x12y4C1Ev),
  NSPAIR(_ZN8G12x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G12x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y4[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn28_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y4[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI8G12x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV8G12x12y4[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y4[] = {
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn28_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y4[] = {
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y4[] = {
  {&(_ZTV8G12x12y4[3]),  3,8},
  {&(_tg__ZTV6E12x12__8G12x12y4[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y4[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y4[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y4[3]),  3,4},
  {&(_ZTV8G12x12y4[7]),  7,8},
};
extern VTBL_ENTRY _ZTI8G12x12y4[];
extern  VTBL_ENTRY _ZTV8G12x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y4[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn28_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn28_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y4 = {  "G12x12y4", // class name
  bases_G12x12y4, 6,
  &(vtc_G12x12y4[0]), // expected_vtbl_contents
  &(vtt_G12x12y4[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G12x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y4),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y4),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y5  : virtual E12x12 , F0 {
  int ff;
  ~G12x12y5(); // tgen
  G12x12y5(); // tgen
};
//SIG(1 G12x12y5) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G12x12y5 ::~G12x12y5(){ note_dtor("G12x12y5", this);} // tgen
G12x12y5 ::G12x12y5(){ note_ctor("G12x12y5", this);} // tgen

static void Test_G12x12y5()
{
  extern Class_Descriptor cd_G12x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G12x12y5, buf);
    G12x12y5 *dp, &lv = *(dp=new (buf) G12x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G12x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y5)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(24,16), "G12x12y5");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(40,32), "G12x12y5");
    check_base_class_offset(lv, (C12*)(E12x12*), ABISELECT(16,12), "G12x12y5");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(32,24), "G12x12y5");
    check_base_class_offset(lv, (E12x12*), ABISELECT(16,12), "G12x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G12x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G12x12y5.ff");
    test_class_info(&lv, &cd_G12x12y5);
    dp->~G12x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y5(Test_G12x12y5, "G12x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G12x12y5C1Ev();
extern void _ZN8G12x12y5D1Ev();
Name_Map name_map_G12x12y5[] = {
  NSPAIR(_ZN8G12x12y5C1Ev),
  NSPAIR(_ZN8G12x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G12x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y5[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G12x12y5[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G12x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV8G12x12y5[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y5[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y5[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y5[] = {
  {&(_ZTV8G12x12y5[4]),  4,13},
  {&(_ZTV8G12x12y5[8]),  8,13},
  {&(_ZTV8G12x12y5[12]),  12,13},
  {&(_tg__ZTV6E12x12__8G12x12y5[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y5[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y5[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G12x12y5[];
extern  VTBL_ENTRY _ZTV8G12x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y5[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y5 = {  "G12x12y5", // class name
  bases_G12x12y5, 6,
  &(vtc_G12x12y5[0]), // expected_vtbl_contents
  &(vtt_G12x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G12x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y5),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y5),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y6  : E12x12 , virtual F0 {
  int ff;
  ~G12x12y6(); // tgen
  G12x12y6(); // tgen
};
//SIG(1 G12x12y6) C1{ BC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G12x12y6 ::~G12x12y6(){ note_dtor("G12x12y6", this);} // tgen
G12x12y6 ::G12x12y6(){ note_ctor("G12x12y6", this);} // tgen

static void Test_G12x12y6()
{
  extern Class_Descriptor cd_G12x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G12x12y6, buf);
    G12x12y6 *dp, &lv = *(dp=new (buf) G12x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G12x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y6)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(8,4), "G12x12y6");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(32,24), "G12x12y6");
    check_base_class_offset(lv, (C12*)(E12x12*), 0, "G12x12y6");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(16,12), "G12x12y6");
    check_base_class_offset(lv, (E12x12*), 0, "G12x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G12x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G12x12y6.ff");
    test_class_info(&lv, &cd_G12x12y6);
    dp->~G12x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y6(Test_G12x12y6, "G12x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G12x12y6C1Ev();
extern void _ZN8G12x12y6D1Ev();
Name_Map name_map_G12x12y6[] = {
  NSPAIR(_ZN8G12x12y6C1Ev),
  NSPAIR(_ZN8G12x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G12x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y6[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12x12y6[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y6[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G12x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV8G12x12y6[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y6[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y6[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y6[] = {
  {&(_ZTV8G12x12y6[4]),  4,9},
  {&(_tg__ZTV6E12x12__8G12x12y6[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y6[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y6[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y6[3]),  3,4},
  {&(_ZTV8G12x12y6[8]),  8,9},
};
extern VTBL_ENTRY _ZTI8G12x12y6[];
extern  VTBL_ENTRY _ZTV8G12x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y6[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E12x123fooEv,_ZThn24_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y6 = {  "G12x12y6", // class name
  bases_G12x12y6, 6,
  &(vtc_G12x12y6[0]), // expected_vtbl_contents
  &(vtt_G12x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G12x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y6),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y6),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12x12y7  : virtual E12x12 , virtual F0 {
  int ff;
  ~G12x12y7(); // tgen
  G12x12y7(); // tgen
};
//SIG(1 G12x12y7) C1{ VBC2{ BC3{ BC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G12x12y7 ::~G12x12y7(){ note_dtor("G12x12y7", this);} // tgen
G12x12y7 ::G12x12y7(){ note_ctor("G12x12y7", this);} // tgen

static void Test_G12x12y7()
{
  extern Class_Descriptor cd_G12x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G12x12y7, buf);
    G12x12y7 *dp, &lv = *(dp=new (buf) G12x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G12x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12x12y7)");
    check_base_class_offset(lv, (A0*)(C12*)(E12x12*), ABISELECT(24,12), "G12x12y7");
    check_base_class_offset(lv, (B1*)(C12*)(E12x12*), ABISELECT(40,28), "G12x12y7");
    check_base_class_offset(lv, (C12*)(E12x12*), ABISELECT(16,8), "G12x12y7");
    check_base_class_offset(lv, (D0*)(E12x12*), ABISELECT(32,20), "G12x12y7");
    check_base_class_offset(lv, (E12x12*), ABISELECT(16,8), "G12x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(52,36), "G12x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G12x12y7.ff");
    test_class_info(&lv, &cd_G12x12y7);
    dp->~G12x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12x12y7(Test_G12x12y7, "G12x12y7", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G12x12y7C1Ev();
extern void _ZN8G12x12y7D1Ev();
Name_Map name_map_G12x12y7[] = {
  NSPAIR(_ZN8G12x12y7C1Ev),
  NSPAIR(_ZN8G12x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C12;
extern VTBL_ENTRY _ZTI3C12[];
extern  VTBL_ENTRY _ZTV3C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C12[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E12x12;
extern VTBL_ENTRY _ZTI6E12x12[];
extern  VTBL_ENTRY _ZTV6E12x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E12x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G12x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C12,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E12x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G12x12y7[];
extern void _ZN6E12x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12x12y7[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G12x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G12x12y7[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G12x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
extern VTBL_ENTRY _ZTV8G12x12y7[];
extern void _ZN6E12x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E12x12__8G12x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&_ZN6E12x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C126E12x12__8G12x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C12[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C126E12x12__8G12x12y7[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C12[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv)();
extern void ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E12x12__8G12x12y7[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E12x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv),
};
static  VTT_ENTRY vtt_G12x12y7[] = {
  {&(_ZTV8G12x12y7[5]),  5,14},
  {&(_ZTV8G12x12y7[9]),  9,14},
  {&(_ZTV8G12x12y7[13]),  13,14},
  {&(_tg__ZTV6E12x12__8G12x12y7[3]),  3,4},
  {&(_tg__ZTV3C126E12x12__8G12x12y7[3]),  3,3},
  {&(_tg__ZTV2B1__3C126E12x12__8G12x12y7[3]),  3,4},
  {&(_tg__ZTV2B1__6E12x12__8G12x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G12x12y7[];
extern  VTBL_ENTRY _ZTV8G12x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G12x12y7[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E12x123fooEv,_ZTv0_n12_N6E12x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E12x123fooEv,_ZThn20_N6E12x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12x12y7 = {  "G12x12y7", // class name
  bases_G12x12y7, 6,
  &(vtc_G12x12y7[0]), // expected_vtbl_contents
  &(vtt_G12x12y7[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G12x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G12x12y7),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G12x12y7),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E13x12  : C13 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E13x123fooEv
  ~E13x12(); // tgen
  E13x12(); // tgen
};
//SIG(-1 E13x12) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E13x12 ::foo(){vfunc_called(this, "_ZN6E13x123fooEv");}
E13x12 ::~E13x12(){ note_dtor("E13x12", this);} // tgen
E13x12 ::E13x12(){ note_ctor("E13x12", this);} // tgen

static void Test_E13x12()
{
  extern Class_Descriptor cd_E13x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E13x12, buf);
    E13x12 *dp, &lv = *(dp=new (buf) E13x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E13x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E13x12)");
    check_base_class_offset(lv, (A1*)(C13*), 0, "E13x12");
    check_base_class_offset(lv, (B1*)(C13*), ABISELECT(24,20), "E13x12");
    check_base_class_offset(lv, (C13*), 0, "E13x12");
    check_base_class_offset(lv, (D0*), ABISELECT(16,12), "E13x12");
    check_field_offset(lv, fd, ABISELECT(20,16), "E13x12.fd");
    test_class_info(&lv, &cd_E13x12);
    dp->~E13x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE13x12(Test_E13x12, "E13x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6E13x12C1Ev();
extern void _ZN6E13x12D1Ev();
Name_Map name_map_E13x12[] = {
  NSPAIR(_ZN6E13x12C1Ev),
  NSPAIR(_ZN6E13x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E13x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E13x12[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E13x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV6E13x12[];
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C13__6E13x12[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C13__6E13x12[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_E13x12[] = {
  {&(_ZTV6E13x12[3]),  3,8},
  {&(_tg__ZTV3C13__6E13x12[3]),  3,4},
  {&(_tg__ZTV2B1__3C13__6E13x12[3]),  3,4},
  {&(_ZTV6E13x12[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E13x12 = {  "E13x12", // class name
  bases_E13x12, 4,
  &(vtc_E13x12[0]), // expected_vtbl_contents
  &(vtt_E13x12[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6E13x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E13x12),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6E13x12),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y0  : E13x12 , F1 {
  int ff;
  ~G13x12y0(); // tgen
  G13x12y0(); // tgen
};
//SIG(1 G13x12y0) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G13x12y0 ::~G13x12y0(){ note_dtor("G13x12y0", this);} // tgen
G13x12y0 ::G13x12y0(){ note_ctor("G13x12y0", this);} // tgen

static void Test_G13x12y0()
{
  extern Class_Descriptor cd_G13x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G13x12y0, buf);
    G13x12y0 *dp, &lv = *(dp=new (buf) G13x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G13x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y0)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), 0, "G13x12y0");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(40,32), "G13x12y0");
    check_base_class_offset(lv, (C13*)(E13x12*), 0, "G13x12y0");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(16,12), "G13x12y0");
    check_base_class_offset(lv, (E13x12*), 0, "G13x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,20), "G13x12y0");
    check_field_offset(lv, ff, ABISELECT(36,28), "G13x12y0.ff");
    test_class_info(&lv, &cd_G13x12y0);
    dp->~G13x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y0(Test_G13x12y0, "G13x12y0", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G13x12y0C1Ev();
extern void _ZN8G13x12y0D1Ev();
Name_Map name_map_G13x12y0[] = {
  NSPAIR(_ZN8G13x12y0C1Ev),
  NSPAIR(_ZN8G13x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G13x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,20), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y0[];
extern void _ZN6E13x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn40_N6E13x123fooEv,_ZThn32_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y0[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI8G13x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G13x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV8G13x12y0[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y0[] = {
  ABISELECT(40,32),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y0[] = {
  0,
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn40_N6E13x123fooEv,_ZThn32_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y0[] = {
  ABISELECT(-40,-32),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y0[] = {
  {&(_ZTV8G13x12y0[3]),  3,11},
  {&(_tg__ZTV6E13x12__8G13x12y0[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y0[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y0[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y0[3]),  3,4},
  {&(_ZTV8G13x12y0[10]),  10,11},
};
extern VTBL_ENTRY _ZTI8G13x12y0[];
extern  VTBL_ENTRY _ZTV8G13x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y0[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E13x123fooEv,_ZThn32_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E13x123fooEv,_ZThn32_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y0 = {  "G13x12y0", // class name
  bases_G13x12y0, 6,
  &(vtc_G13x12y0[0]), // expected_vtbl_contents
  &(vtt_G13x12y0[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G13x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y0),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y0),6, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y1  : virtual E13x12 , F1 {
  int ff;
  ~G13x12y1(); // tgen
  G13x12y1(); // tgen
};
//SIG(1 G13x12y1) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G13x12y1 ::~G13x12y1(){ note_dtor("G13x12y1", this);} // tgen
G13x12y1 ::G13x12y1(){ note_ctor("G13x12y1", this);} // tgen

static void Test_G13x12y1()
{
  extern Class_Descriptor cd_G13x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G13x12y1, buf);
    G13x12y1 *dp, &lv = *(dp=new (buf) G13x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G13x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y1)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), ABISELECT(16,12), "G13x12y1");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(40,32), "G13x12y1");
    check_base_class_offset(lv, (C13*)(E13x12*), ABISELECT(16,12), "G13x12y1");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(32,24), "G13x12y1");
    check_base_class_offset(lv, (E13x12*), ABISELECT(16,12), "G13x12y1");
    check_base_class_offset(lv, (F1*), 0, "G13x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G13x12y1.ff");
    test_class_info(&lv, &cd_G13x12y1);
    dp->~G13x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y1(Test_G13x12y1, "G13x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G13x12y1C1Ev();
extern void _ZN8G13x12y1D1Ev();
Name_Map name_map_G13x12y1[] = {
  NSPAIR(_ZN8G13x12y1C1Ev),
  NSPAIR(_ZN8G13x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G13x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G13x12y1[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G13x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV8G13x12y1[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y1[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y1[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y1[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y1[] = {
  {&(_ZTV8G13x12y1[4]),  4,14},
  {&(_ZTV8G13x12y1[9]),  9,14},
  {&(_ZTV8G13x12y1[13]),  13,14},
  {&(_tg__ZTV6E13x12__8G13x12y1[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y1[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y1[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G13x12y1[];
extern  VTBL_ENTRY _ZTV8G13x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y1[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y1 = {  "G13x12y1", // class name
  bases_G13x12y1, 6,
  &(vtc_G13x12y1[0]), // expected_vtbl_contents
  &(vtt_G13x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G13x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y1),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y1),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y2  : E13x12 , virtual F1 {
  int ff;
  ~G13x12y2(); // tgen
  G13x12y2(); // tgen
};
//SIG(1 G13x12y2) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G13x12y2 ::~G13x12y2(){ note_dtor("G13x12y2", this);} // tgen
G13x12y2 ::G13x12y2(){ note_ctor("G13x12y2", this);} // tgen

static void Test_G13x12y2()
{
  extern Class_Descriptor cd_G13x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G13x12y2, buf);
    G13x12y2 *dp, &lv = *(dp=new (buf) G13x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G13x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y2)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), 0, "G13x12y2");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(32,24), "G13x12y2");
    check_base_class_offset(lv, (C13*)(E13x12*), 0, "G13x12y2");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(16,12), "G13x12y2");
    check_base_class_offset(lv, (E13x12*), 0, "G13x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G13x12y2");
    check_field_offset(lv, ff, ABISELECT(24,20), "G13x12y2.ff");
    test_class_info(&lv, &cd_G13x12y2);
    dp->~G13x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y2(Test_G13x12y2, "G13x12y2", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G13x12y2C1Ev();
extern void _ZN8G13x12y2D1Ev();
Name_Map name_map_G13x12y2[] = {
  NSPAIR(_ZN8G13x12y2C1Ev),
  NSPAIR(_ZN8G13x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G13x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y2[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G13x12y2[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y2[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G13x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G13x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G13x12y2[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y2[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y2[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y2[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y2[] = {
  {&(_ZTV8G13x12y2[4]),  4,13},
  {&(_tg__ZTV6E13x12__8G13x12y2[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y2[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y2[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y2[3]),  3,4},
  {&(_ZTV8G13x12y2[8]),  8,13},
  {&(_ZTV8G13x12y2[12]),  12,13},
};
extern VTBL_ENTRY _ZTI8G13x12y2[];
extern  VTBL_ENTRY _ZTV8G13x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y2[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y2 = {  "G13x12y2", // class name
  bases_G13x12y2, 6,
  &(vtc_G13x12y2[0]), // expected_vtbl_contents
  &(vtt_G13x12y2[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G13x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y2),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y2),7, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y3  : virtual E13x12 , virtual F1 {
  int ff;
  ~G13x12y3(); // tgen
  G13x12y3(); // tgen
};
//SIG(1 G13x12y3) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G13x12y3 ::~G13x12y3(){ note_dtor("G13x12y3", this);} // tgen
G13x12y3 ::G13x12y3(){ note_ctor("G13x12y3", this);} // tgen

static void Test_G13x12y3()
{
  extern Class_Descriptor cd_G13x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G13x12y3, buf);
    G13x12y3 *dp, &lv = *(dp=new (buf) G13x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G13x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y3)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), ABISELECT(16,8), "G13x12y3");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(40,28), "G13x12y3");
    check_base_class_offset(lv, (C13*)(E13x12*), ABISELECT(16,8), "G13x12y3");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(32,20), "G13x12y3");
    check_base_class_offset(lv, (E13x12*), ABISELECT(16,8), "G13x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G13x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G13x12y3.ff");
    test_class_info(&lv, &cd_G13x12y3);
    dp->~G13x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y3(Test_G13x12y3, "G13x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G13x12y3C1Ev();
extern void _ZN8G13x12y3D1Ev();
Name_Map name_map_G13x12y3[] = {
  NSPAIR(_ZN8G13x12y3C1Ev),
  NSPAIR(_ZN8G13x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G13x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y3[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G13x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G13x12y3[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G13x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G13x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G13x12y3[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y3[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y3[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y3[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y3[] = {
  {&(_ZTV8G13x12y3[5]),  5,18},
  {&(_ZTV8G13x12y3[9]),  9,18},
  {&(_ZTV8G13x12y3[13]),  13,18},
  {&(_ZTV8G13x12y3[17]),  17,18},
  {&(_tg__ZTV6E13x12__8G13x12y3[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y3[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y3[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G13x12y3[];
extern  VTBL_ENTRY _ZTV8G13x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y3[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y3 = {  "G13x12y3", // class name
  bases_G13x12y3, 6,
  &(vtc_G13x12y3[0]), // expected_vtbl_contents
  &(vtt_G13x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G13x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y3),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y3),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y4  : E13x12 , F0 {
  int ff;
  ~G13x12y4(); // tgen
  G13x12y4(); // tgen
};
//SIG(1 G13x12y4) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G13x12y4 ::~G13x12y4(){ note_dtor("G13x12y4", this);} // tgen
G13x12y4 ::G13x12y4(){ note_ctor("G13x12y4", this);} // tgen

static void Test_G13x12y4()
{
  extern Class_Descriptor cd_G13x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G13x12y4, buf);
    G13x12y4 *dp, &lv = *(dp=new (buf) G13x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G13x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y4)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), 0, "G13x12y4");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(32,28), "G13x12y4");
    check_base_class_offset(lv, (C13*)(E13x12*), 0, "G13x12y4");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(16,12), "G13x12y4");
    check_base_class_offset(lv, (E13x12*), 0, "G13x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(24,20), "G13x12y4");
    check_field_offset(lv, ff, ABISELECT(28,24), "G13x12y4.ff");
    test_class_info(&lv, &cd_G13x12y4);
    dp->~G13x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y4(Test_G13x12y4, "G13x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G13x12y4C1Ev();
extern void _ZN8G13x12y4D1Ev();
Name_Map name_map_G13x12y4[] = {
  NSPAIR(_ZN8G13x12y4C1Ev),
  NSPAIR(_ZN8G13x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G13x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y4[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn28_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y4[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI8G13x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV8G13x12y4[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y4[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y4[] = {
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn28_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y4[] = {
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y4[] = {
  {&(_ZTV8G13x12y4[3]),  3,8},
  {&(_tg__ZTV6E13x12__8G13x12y4[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y4[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y4[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y4[3]),  3,4},
  {&(_ZTV8G13x12y4[7]),  7,8},
};
extern VTBL_ENTRY _ZTI8G13x12y4[];
extern  VTBL_ENTRY _ZTV8G13x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y4[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn28_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn28_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y4 = {  "G13x12y4", // class name
  bases_G13x12y4, 6,
  &(vtc_G13x12y4[0]), // expected_vtbl_contents
  &(vtt_G13x12y4[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G13x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y4),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y4),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y5  : virtual E13x12 , F0 {
  int ff;
  ~G13x12y5(); // tgen
  G13x12y5(); // tgen
};
//SIG(1 G13x12y5) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G13x12y5 ::~G13x12y5(){ note_dtor("G13x12y5", this);} // tgen
G13x12y5 ::G13x12y5(){ note_ctor("G13x12y5", this);} // tgen

static void Test_G13x12y5()
{
  extern Class_Descriptor cd_G13x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G13x12y5, buf);
    G13x12y5 *dp, &lv = *(dp=new (buf) G13x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G13x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y5)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), ABISELECT(16,12), "G13x12y5");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(40,32), "G13x12y5");
    check_base_class_offset(lv, (C13*)(E13x12*), ABISELECT(16,12), "G13x12y5");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(32,24), "G13x12y5");
    check_base_class_offset(lv, (E13x12*), ABISELECT(16,12), "G13x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G13x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G13x12y5.ff");
    test_class_info(&lv, &cd_G13x12y5);
    dp->~G13x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y5(Test_G13x12y5, "G13x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G13x12y5C1Ev();
extern void _ZN8G13x12y5D1Ev();
Name_Map name_map_G13x12y5[] = {
  NSPAIR(_ZN8G13x12y5C1Ev),
  NSPAIR(_ZN8G13x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G13x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y5[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G13x12y5[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G13x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV8G13x12y5[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y5[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y5[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y5[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y5[] = {
  {&(_ZTV8G13x12y5[4]),  4,13},
  {&(_ZTV8G13x12y5[8]),  8,13},
  {&(_ZTV8G13x12y5[12]),  12,13},
  {&(_tg__ZTV6E13x12__8G13x12y5[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y5[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y5[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G13x12y5[];
extern  VTBL_ENTRY _ZTV8G13x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y5[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y5 = {  "G13x12y5", // class name
  bases_G13x12y5, 6,
  &(vtc_G13x12y5[0]), // expected_vtbl_contents
  &(vtt_G13x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G13x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y5),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y5),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y6  : E13x12 , virtual F0 {
  int ff;
  ~G13x12y6(); // tgen
  G13x12y6(); // tgen
};
//SIG(1 G13x12y6) C1{ BC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G13x12y6 ::~G13x12y6(){ note_dtor("G13x12y6", this);} // tgen
G13x12y6 ::G13x12y6(){ note_ctor("G13x12y6", this);} // tgen

static void Test_G13x12y6()
{
  extern Class_Descriptor cd_G13x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G13x12y6, buf);
    G13x12y6 *dp, &lv = *(dp=new (buf) G13x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G13x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y6)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), 0, "G13x12y6");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(32,24), "G13x12y6");
    check_base_class_offset(lv, (C13*)(E13x12*), 0, "G13x12y6");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(16,12), "G13x12y6");
    check_base_class_offset(lv, (E13x12*), 0, "G13x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G13x12y6");
    check_field_offset(lv, ff, ABISELECT(24,20), "G13x12y6.ff");
    test_class_info(&lv, &cd_G13x12y6);
    dp->~G13x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y6(Test_G13x12y6, "G13x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G13x12y6C1Ev();
extern void _ZN8G13x12y6D1Ev();
Name_Map name_map_G13x12y6[] = {
  NSPAIR(_ZN8G13x12y6C1Ev),
  NSPAIR(_ZN8G13x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G13x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y6[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13x12y6[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y6[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G13x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV8G13x12y6[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y6[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y6[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y6[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y6[] = {
  {&(_ZTV8G13x12y6[4]),  4,9},
  {&(_tg__ZTV6E13x12__8G13x12y6[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y6[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y6[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y6[3]),  3,4},
  {&(_ZTV8G13x12y6[8]),  8,9},
};
extern VTBL_ENTRY _ZTI8G13x12y6[];
extern  VTBL_ENTRY _ZTV8G13x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y6[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E13x123fooEv,_ZThn24_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y6 = {  "G13x12y6", // class name
  bases_G13x12y6, 6,
  &(vtc_G13x12y6[0]), // expected_vtbl_contents
  &(vtt_G13x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G13x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y6),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y6),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13x12y7  : virtual E13x12 , virtual F0 {
  int ff;
  ~G13x12y7(); // tgen
  G13x12y7(); // tgen
};
//SIG(1 G13x12y7) C1{ VBC2{ BC3{ BC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G13x12y7 ::~G13x12y7(){ note_dtor("G13x12y7", this);} // tgen
G13x12y7 ::G13x12y7(){ note_ctor("G13x12y7", this);} // tgen

static void Test_G13x12y7()
{
  extern Class_Descriptor cd_G13x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G13x12y7, buf);
    G13x12y7 *dp, &lv = *(dp=new (buf) G13x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G13x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13x12y7)");
    check_base_class_offset(lv, (A1*)(C13*)(E13x12*), ABISELECT(16,8), "G13x12y7");
    check_base_class_offset(lv, (B1*)(C13*)(E13x12*), ABISELECT(40,28), "G13x12y7");
    check_base_class_offset(lv, (C13*)(E13x12*), ABISELECT(16,8), "G13x12y7");
    check_base_class_offset(lv, (D0*)(E13x12*), ABISELECT(32,20), "G13x12y7");
    check_base_class_offset(lv, (E13x12*), ABISELECT(16,8), "G13x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(52,36), "G13x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G13x12y7.ff");
    test_class_info(&lv, &cd_G13x12y7);
    dp->~G13x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13x12y7(Test_G13x12y7, "G13x12y7", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G13x12y7C1Ev();
extern void _ZN8G13x12y7D1Ev();
Name_Map name_map_G13x12y7[] = {
  NSPAIR(_ZN8G13x12y7C1Ev),
  NSPAIR(_ZN8G13x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C13;
extern VTBL_ENTRY _ZTI3C13[];
extern  VTBL_ENTRY _ZTV3C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C13[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E13x12;
extern VTBL_ENTRY _ZTI6E13x12[];
extern  VTBL_ENTRY _ZTV6E13x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E13x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G13x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C13,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E13x12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G13x12y7[];
extern void _ZN6E13x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13x12y7[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G13x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G13x12y7[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G13x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
extern VTBL_ENTRY _ZTV8G13x12y7[];
extern void _ZN6E13x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E13x12__8G13x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&_ZN6E13x123fooEv,
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV3C136E13x12__8G13x12y7[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C136E13x12__8G13x12y7[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C13[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv)();
extern void ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E13x12__8G13x12y7[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E13x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv),
};
static  VTT_ENTRY vtt_G13x12y7[] = {
  {&(_ZTV8G13x12y7[5]),  5,14},
  {&(_ZTV8G13x12y7[9]),  9,14},
  {&(_ZTV8G13x12y7[13]),  13,14},
  {&(_tg__ZTV6E13x12__8G13x12y7[3]),  3,4},
  {&(_tg__ZTV3C136E13x12__8G13x12y7[3]),  3,4},
  {&(_tg__ZTV2B1__3C136E13x12__8G13x12y7[3]),  3,4},
  {&(_tg__ZTV2B1__6E13x12__8G13x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G13x12y7[];
extern  VTBL_ENTRY _ZTV8G13x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G13x12y7[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E13x123fooEv,_ZTv0_n12_N6E13x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E13x123fooEv,_ZThn20_N6E13x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13x12y7 = {  "G13x12y7", // class name
  bases_G13x12y7, 6,
  &(vtc_G13x12y7[0]), // expected_vtbl_contents
  &(vtt_G13x12y7[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G13x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G13x12y7),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G13x12y7),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E14x12  : C14 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E14x123fooEv
  ~E14x12(); // tgen
  E14x12(); // tgen
};
//SIG(-1 E14x12) C1{ BC2{ VBC3{ Fi} VBC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E14x12 ::foo(){vfunc_called(this, "_ZN6E14x123fooEv");}
E14x12 ::~E14x12(){ note_dtor("E14x12", this);} // tgen
E14x12 ::E14x12(){ note_ctor("E14x12", this);} // tgen

static void Test_E14x12()
{
  extern Class_Descriptor cd_E14x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_E14x12, buf);
    E14x12 *dp, &lv = *(dp=new (buf) E14x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(E14x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E14x12)");
    check_base_class_offset(lv, (A0*)(C14*), ABISELECT(20,16), "E14x12");
    check_base_class_offset(lv, (B1*)(C14*), ABISELECT(24,20), "E14x12");
    check_base_class_offset(lv, (C14*), 0, "E14x12");
    check_base_class_offset(lv, (D0*), ABISELECT(12,8), "E14x12");
    check_field_offset(lv, fd, ABISELECT(16,12), "E14x12.fd");
    test_class_info(&lv, &cd_E14x12);
    dp->~E14x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE14x12(Test_E14x12, "E14x12", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN6E14x12C1Ev();
extern void _ZN6E14x12D1Ev();
Name_Map name_map_E14x12[] = {
  NSPAIR(_ZN6E14x12C1Ev),
  NSPAIR(_ZN6E14x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E14x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(24,20), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E14x12[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E14x12[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV6E14x12[];
static  VTBL_ENTRY _tg__ZTV3C14__6E14x12[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C14__6E14x12[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_E14x12[] = {
  {&(_ZTV6E14x12[4]),  4,9},
  {&(_tg__ZTV3C14__6E14x12[4]),  4,4},
  {&(_tg__ZTV2B1__3C14__6E14x12[3]),  3,4},
  {&(_ZTV6E14x12[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E14x12 = {  "E14x12", // class name
  bases_E14x12, 4,
  &(vtc_E14x12[0]), // expected_vtbl_contents
  &(vtt_E14x12[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI6E14x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E14x12),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6E14x12),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y0  : E14x12 , F1 {
  int ff;
  ~G14x12y0(); // tgen
  G14x12y0(); // tgen
};
//SIG(1 G14x12y0) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G14x12y0 ::~G14x12y0(){ note_dtor("G14x12y0", this);} // tgen
G14x12y0 ::G14x12y0(){ note_ctor("G14x12y0", this);} // tgen

static void Test_G14x12y0()
{
  extern Class_Descriptor cd_G14x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G14x12y0, buf);
    G14x12y0 *dp, &lv = *(dp=new (buf) G14x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G14x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y0)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(40,28), "G14x12y0");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(48,32), "G14x12y0");
    check_base_class_offset(lv, (C14*)(E14x12*), 0, "G14x12y0");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(12,8), "G14x12y0");
    check_base_class_offset(lv, (E14x12*), 0, "G14x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,16), "G14x12y0");
    check_field_offset(lv, ff, ABISELECT(36,24), "G14x12y0.ff");
    test_class_info(&lv, &cd_G14x12y0);
    dp->~G14x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y0(Test_G14x12y0, "G14x12y0", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G14x12y0C1Ev();
extern void _ZN8G14x12y0D1Ev();
Name_Map name_map_G14x12y0[] = {
  NSPAIR(_ZN8G14x12y0C1Ev),
  NSPAIR(_ZN8G14x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G14x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y0[];
extern void _ZN6E14x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn48_N6E14x123fooEv,_ZThn32_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G14x12y0[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y0[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8G14x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G14x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV8G14x12y0[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y0[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y0[] = {
  ABISELECT(48,32),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y0[] = {
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn48_N6E14x123fooEv,_ZThn32_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y0[] = {
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y0[] = {
  {&(_ZTV8G14x12y0[4]),  4,12},
  {&(_tg__ZTV6E14x12__8G14x12y0[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y0[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y0[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y0[3]),  3,4},
  {&(_ZTV8G14x12y0[11]),  11,12},
};
extern VTBL_ENTRY _ZTI8G14x12y0[];
extern  VTBL_ENTRY _ZTV8G14x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y0[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6E14x123fooEv,_ZThn32_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6E14x123fooEv,_ZThn32_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y0 = {  "G14x12y0", // class name
  bases_G14x12y0, 6,
  &(vtc_G14x12y0[0]), // expected_vtbl_contents
  &(vtt_G14x12y0[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G14x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y0),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y0),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y1  : virtual E14x12 , F1 {
  int ff;
  ~G14x12y1(); // tgen
  G14x12y1(); // tgen
};
//SIG(1 G14x12y1) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G14x12y1 ::~G14x12y1(){ note_dtor("G14x12y1", this);} // tgen
G14x12y1 ::G14x12y1(){ note_ctor("G14x12y1", this);} // tgen

static void Test_G14x12y1()
{
  extern Class_Descriptor cd_G14x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G14x12y1, buf);
    G14x12y1 *dp, &lv = *(dp=new (buf) G14x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G14x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y1)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(36,28), "G14x12y1");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(40,32), "G14x12y1");
    check_base_class_offset(lv, (C14*)(E14x12*), ABISELECT(16,12), "G14x12y1");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(28,20), "G14x12y1");
    check_base_class_offset(lv, (E14x12*), ABISELECT(16,12), "G14x12y1");
    check_base_class_offset(lv, (F1*), 0, "G14x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G14x12y1.ff");
    test_class_info(&lv, &cd_G14x12y1);
    dp->~G14x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y1(Test_G14x12y1, "G14x12y1", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G14x12y1C1Ev();
extern void _ZN8G14x12y1D1Ev();
Name_Map name_map_G14x12y1[] = {
  NSPAIR(_ZN8G14x12y1C1Ev),
  NSPAIR(_ZN8G14x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G14x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G14x12y1[] = {
  ABISELECT(40,32),
  ABISELECT(36,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G14x12y1[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G14x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV8G14x12y1[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y1[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y1[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y1[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y1[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y1[] = {
  {&(_ZTV8G14x12y1[5]),  5,16},
  {&(_ZTV8G14x12y1[11]),  11,16},
  {&(_ZTV8G14x12y1[15]),  15,16},
  {&(_tg__ZTV6E14x12__8G14x12y1[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y1[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y1[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G14x12y1[];
extern  VTBL_ENTRY _ZTV8G14x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y1[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y1 = {  "G14x12y1", // class name
  bases_G14x12y1, 6,
  &(vtc_G14x12y1[0]), // expected_vtbl_contents
  &(vtt_G14x12y1[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G14x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y1),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y1),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y2  : E14x12 , virtual F1 {
  int ff;
  ~G14x12y2(); // tgen
  G14x12y2(); // tgen
};
//SIG(1 G14x12y2) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G14x12y2 ::~G14x12y2(){ note_dtor("G14x12y2", this);} // tgen
G14x12y2 ::G14x12y2(){ note_ctor("G14x12y2", this);} // tgen

static void Test_G14x12y2()
{
  extern Class_Descriptor cd_G14x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G14x12y2, buf);
    G14x12y2 *dp, &lv = *(dp=new (buf) G14x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G14x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y2)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(24,20), "G14x12y2");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(32,24), "G14x12y2");
    check_base_class_offset(lv, (C14*)(E14x12*), 0, "G14x12y2");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(12,8), "G14x12y2");
    check_base_class_offset(lv, (E14x12*), 0, "G14x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G14x12y2");
    check_field_offset(lv, ff, ABISELECT(20,16), "G14x12y2.ff");
    test_class_info(&lv, &cd_G14x12y2);
    dp->~G14x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y2(Test_G14x12y2, "G14x12y2", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G14x12y2C1Ev();
extern void _ZN8G14x12y2D1Ev();
Name_Map name_map_G14x12y2[] = {
  NSPAIR(_ZN8G14x12y2C1Ev),
  NSPAIR(_ZN8G14x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G14x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(32,24), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y2[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G14x12y2[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y2[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G14x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G14x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G14x12y2[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y2[] = {
  ABISELECT(32,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y2[] = {
  ABISELECT(32,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y2[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y2[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y2[] = {
  {&(_ZTV8G14x12y2[5]),  5,14},
  {&(_tg__ZTV6E14x12__8G14x12y2[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y2[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y2[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y2[3]),  3,4},
  {&(_ZTV8G14x12y2[9]),  9,14},
  {&(_ZTV8G14x12y2[13]),  13,14},
};
extern VTBL_ENTRY _ZTI8G14x12y2[];
extern  VTBL_ENTRY _ZTV8G14x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y2[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y2 = {  "G14x12y2", // class name
  bases_G14x12y2, 6,
  &(vtc_G14x12y2[0]), // expected_vtbl_contents
  &(vtt_G14x12y2[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G14x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y2),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y2),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y3  : virtual E14x12 , virtual F1 {
  int ff;
  ~G14x12y3(); // tgen
  G14x12y3(); // tgen
};
//SIG(1 G14x12y3) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G14x12y3 ::~G14x12y3(){ note_dtor("G14x12y3", this);} // tgen
G14x12y3 ::G14x12y3(){ note_ctor("G14x12y3", this);} // tgen

static void Test_G14x12y3()
{
  extern Class_Descriptor cd_G14x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G14x12y3, buf);
    G14x12y3 *dp, &lv = *(dp=new (buf) G14x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G14x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y3)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(36,24), "G14x12y3");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(40,28), "G14x12y3");
    check_base_class_offset(lv, (C14*)(E14x12*), ABISELECT(16,8), "G14x12y3");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(28,16), "G14x12y3");
    check_base_class_offset(lv, (E14x12*), ABISELECT(16,8), "G14x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G14x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G14x12y3.ff");
    test_class_info(&lv, &cd_G14x12y3);
    dp->~G14x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y3(Test_G14x12y3, "G14x12y3", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G14x12y3C1Ev();
extern void _ZN8G14x12y3D1Ev();
Name_Map name_map_G14x12y3[] = {
  NSPAIR(_ZN8G14x12y3C1Ev),
  NSPAIR(_ZN8G14x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G14x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y3[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G14x12y3[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y3[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G14x12y3[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G14x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G14x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G14x12y3[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y3[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y3[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y3[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y3[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y3[] = {
  {&(_ZTV8G14x12y3[6]),  6,20},
  {&(_ZTV8G14x12y3[11]),  11,20},
  {&(_ZTV8G14x12y3[15]),  15,20},
  {&(_ZTV8G14x12y3[19]),  19,20},
  {&(_tg__ZTV6E14x12__8G14x12y3[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y3[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y3[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G14x12y3[];
extern  VTBL_ENTRY _ZTV8G14x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y3[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y3 = {  "G14x12y3", // class name
  bases_G14x12y3, 6,
  &(vtc_G14x12y3[0]), // expected_vtbl_contents
  &(vtt_G14x12y3[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G14x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y3),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y3),8, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y4  : E14x12 , F0 {
  int ff;
  ~G14x12y4(); // tgen
  G14x12y4(); // tgen
};
//SIG(1 G14x12y4) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G14x12y4 ::~G14x12y4(){ note_dtor("G14x12y4", this);} // tgen
G14x12y4 ::G14x12y4(){ note_ctor("G14x12y4", this);} // tgen

static void Test_G14x12y4()
{
  extern Class_Descriptor cd_G14x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G14x12y4, buf);
    G14x12y4 *dp, &lv = *(dp=new (buf) G14x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G14x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y4)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(28,24), "G14x12y4");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(32,28), "G14x12y4");
    check_base_class_offset(lv, (C14*)(E14x12*), 0, "G14x12y4");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(12,8), "G14x12y4");
    check_base_class_offset(lv, (E14x12*), 0, "G14x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(20,16), "G14x12y4");
    check_field_offset(lv, ff, ABISELECT(24,20), "G14x12y4.ff");
    test_class_info(&lv, &cd_G14x12y4);
    dp->~G14x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y4(Test_G14x12y4, "G14x12y4", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G14x12y4C1Ev();
extern void _ZN8G14x12y4D1Ev();
Name_Map name_map_G14x12y4[] = {
  NSPAIR(_ZN8G14x12y4C1Ev),
  NSPAIR(_ZN8G14x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G14x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(28,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(32,28), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y4[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn28_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G14x12y4[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y4[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI8G14x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV8G14x12y4[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y4[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y4[] = {
  ABISELECT(32,28),
  ABISELECT(28,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y4[] = {
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn28_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y4[] = {
  ABISELECT(-32,-28),
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y4[] = {
  {&(_ZTV8G14x12y4[4]),  4,9},
  {&(_tg__ZTV6E14x12__8G14x12y4[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y4[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y4[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y4[3]),  3,4},
  {&(_ZTV8G14x12y4[8]),  8,9},
};
extern VTBL_ENTRY _ZTI8G14x12y4[];
extern  VTBL_ENTRY _ZTV8G14x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y4[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn28_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn28_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y4 = {  "G14x12y4", // class name
  bases_G14x12y4, 6,
  &(vtc_G14x12y4[0]), // expected_vtbl_contents
  &(vtt_G14x12y4[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G14x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y4),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y4),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y5  : virtual E14x12 , F0 {
  int ff;
  ~G14x12y5(); // tgen
  G14x12y5(); // tgen
};
//SIG(1 G14x12y5) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G14x12y5 ::~G14x12y5(){ note_dtor("G14x12y5", this);} // tgen
G14x12y5 ::G14x12y5(){ note_ctor("G14x12y5", this);} // tgen

static void Test_G14x12y5()
{
  extern Class_Descriptor cd_G14x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G14x12y5, buf);
    G14x12y5 *dp, &lv = *(dp=new (buf) G14x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G14x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y5)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(36,28), "G14x12y5");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(40,32), "G14x12y5");
    check_base_class_offset(lv, (C14*)(E14x12*), ABISELECT(16,12), "G14x12y5");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(28,20), "G14x12y5");
    check_base_class_offset(lv, (E14x12*), ABISELECT(16,12), "G14x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G14x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G14x12y5.ff");
    test_class_info(&lv, &cd_G14x12y5);
    dp->~G14x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y5(Test_G14x12y5, "G14x12y5", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G14x12y5C1Ev();
extern void _ZN8G14x12y5D1Ev();
Name_Map name_map_G14x12y5[] = {
  NSPAIR(_ZN8G14x12y5C1Ev),
  NSPAIR(_ZN8G14x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G14x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y5[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G14x12y5[] = {
  ABISELECT(40,32),
  ABISELECT(36,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y5[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G14x12y5[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-32),
  (VTBL_ENTRY)&(_ZTI8G14x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV8G14x12y5[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y5[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y5[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y5[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y5[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y5[] = {
  {&(_ZTV8G14x12y5[5]),  5,15},
  {&(_ZTV8G14x12y5[10]),  10,15},
  {&(_ZTV8G14x12y5[14]),  14,15},
  {&(_tg__ZTV6E14x12__8G14x12y5[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y5[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y5[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G14x12y5[];
extern  VTBL_ENTRY _ZTV8G14x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y5[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y5 = {  "G14x12y5", // class name
  bases_G14x12y5, 6,
  &(vtc_G14x12y5[0]), // expected_vtbl_contents
  &(vtt_G14x12y5[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G14x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y5),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y5),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y6  : E14x12 , virtual F0 {
  int ff;
  ~G14x12y6(); // tgen
  G14x12y6(); // tgen
};
//SIG(1 G14x12y6) C1{ BC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G14x12y6 ::~G14x12y6(){ note_dtor("G14x12y6", this);} // tgen
G14x12y6 ::G14x12y6(){ note_ctor("G14x12y6", this);} // tgen

static void Test_G14x12y6()
{
  extern Class_Descriptor cd_G14x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G14x12y6, buf);
    G14x12y6 *dp, &lv = *(dp=new (buf) G14x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G14x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y6)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(24,20), "G14x12y6");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(32,24), "G14x12y6");
    check_base_class_offset(lv, (C14*)(E14x12*), 0, "G14x12y6");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(12,8), "G14x12y6");
    check_base_class_offset(lv, (E14x12*), 0, "G14x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(44,32), "G14x12y6");
    check_field_offset(lv, ff, ABISELECT(20,16), "G14x12y6.ff");
    test_class_info(&lv, &cd_G14x12y6);
    dp->~G14x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y6(Test_G14x12y6, "G14x12y6", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G14x12y6C1Ev();
extern void _ZN8G14x12y6D1Ev();
Name_Map name_map_G14x12y6[] = {
  NSPAIR(_ZN8G14x12y6C1Ev),
  NSPAIR(_ZN8G14x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G14x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(32,24), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(44,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y6[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G14x12y6[] = {
  ABISELECT(44,32),
  ABISELECT(32,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y6[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G14x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV8G14x12y6[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y6[] = {
  ABISELECT(32,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y6[] = {
  ABISELECT(32,24),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y6[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y6[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y6[] = {
  {&(_ZTV8G14x12y6[5]),  5,10},
  {&(_tg__ZTV6E14x12__8G14x12y6[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y6[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y6[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y6[3]),  3,4},
  {&(_ZTV8G14x12y6[9]),  9,10},
};
extern VTBL_ENTRY _ZTI8G14x12y6[];
extern  VTBL_ENTRY _ZTV8G14x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y6[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E14x123fooEv,_ZThn24_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y6 = {  "G14x12y6", // class name
  bases_G14x12y6, 6,
  &(vtc_G14x12y6[0]), // expected_vtbl_contents
  &(vtt_G14x12y6[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G14x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y6),10, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y6),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G14x12y7  : virtual E14x12 , virtual F0 {
  int ff;
  ~G14x12y7(); // tgen
  G14x12y7(); // tgen
};
//SIG(1 G14x12y7) C1{ VBC2{ BC3{ VBC4{ Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G14x12y7 ::~G14x12y7(){ note_dtor("G14x12y7", this);} // tgen
G14x12y7 ::G14x12y7(){ note_ctor("G14x12y7", this);} // tgen

static void Test_G14x12y7()
{
  extern Class_Descriptor cd_G14x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G14x12y7, buf);
    G14x12y7 *dp, &lv = *(dp=new (buf) G14x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G14x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G14x12y7)");
    check_base_class_offset(lv, (A0*)(C14*)(E14x12*), ABISELECT(36,24), "G14x12y7");
    check_base_class_offset(lv, (B1*)(C14*)(E14x12*), ABISELECT(40,28), "G14x12y7");
    check_base_class_offset(lv, (C14*)(E14x12*), ABISELECT(16,8), "G14x12y7");
    check_base_class_offset(lv, (D0*)(E14x12*), ABISELECT(28,16), "G14x12y7");
    check_base_class_offset(lv, (E14x12*), ABISELECT(16,8), "G14x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(52,36), "G14x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G14x12y7.ff");
    test_class_info(&lv, &cd_G14x12y7);
    dp->~G14x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG14x12y7(Test_G14x12y7, "G14x12y7", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G14x12y7C1Ev();
extern void _ZN8G14x12y7D1Ev();
Name_Map name_map_G14x12y7[] = {
  NSPAIR(_ZN8G14x12y7C1Ev),
  NSPAIR(_ZN8G14x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C14;
extern VTBL_ENTRY _ZTI3C14[];
extern  VTBL_ENTRY _ZTV3C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C14[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E14x12;
extern VTBL_ENTRY _ZTI6E14x12[];
extern  VTBL_ENTRY _ZTV6E14x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E14x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G14x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C14,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E14x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G14x12y7[];
extern void _ZN6E14x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G14x12y7[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G14x12y7[0]),
  0,
  ABISELECT(24,20),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G14x12y7[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G14x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
extern VTBL_ENTRY _ZTV8G14x12y7[];
extern void _ZN6E14x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E14x12__8G14x12y7[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&_ZN6E14x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C146E14x12__8G14x12y7[] = {
  ABISELECT(24,20),
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C14[0]),
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C146E14x12__8G14x12y7[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C14[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv)();
extern void ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E14x12__8G14x12y7[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E14x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv),
};
static  VTT_ENTRY vtt_G14x12y7[] = {
  {&(_ZTV8G14x12y7[6]),  6,16},
  {&(_ZTV8G14x12y7[11]),  11,16},
  {&(_ZTV8G14x12y7[15]),  15,16},
  {&(_tg__ZTV6E14x12__8G14x12y7[4]),  4,5},
  {&(_tg__ZTV3C146E14x12__8G14x12y7[4]),  4,4},
  {&(_tg__ZTV2B1__3C146E14x12__8G14x12y7[3]),  3,4},
  {&(_tg__ZTV2B1__6E14x12__8G14x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G14x12y7[];
extern  VTBL_ENTRY _ZTV8G14x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G14x12y7[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E14x123fooEv,_ZTv0_n12_N6E14x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E14x123fooEv,_ZThn20_N6E14x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G14x12y7 = {  "G14x12y7", // class name
  bases_G14x12y7, 6,
  &(vtc_G14x12y7[0]), // expected_vtbl_contents
  &(vtt_G14x12y7[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G14x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G14x12y7),16, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G14x12y7),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E15x12  : C15 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E15x123fooEv
  ~E15x12(); // tgen
  E15x12(); // tgen
};
//SIG(-1 E15x12) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} Fi} BC5{ Fi} v1 Fi}


void  E15x12 ::foo(){vfunc_called(this, "_ZN6E15x123fooEv");}
E15x12 ::~E15x12(){ note_dtor("E15x12", this);} // tgen
E15x12 ::E15x12(){ note_ctor("E15x12", this);} // tgen

static void Test_E15x12()
{
  extern Class_Descriptor cd_E15x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_E15x12, buf);
    E15x12 *dp, &lv = *(dp=new (buf) E15x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(E15x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E15x12)");
    check_base_class_offset(lv, (A1*)(C15*), ABISELECT(24,16), "E15x12");
    check_base_class_offset(lv, (B1*)(C15*), ABISELECT(40,24), "E15x12");
    check_base_class_offset(lv, (C15*), 0, "E15x12");
    check_base_class_offset(lv, (D0*), ABISELECT(12,8), "E15x12");
    check_field_offset(lv, fd, ABISELECT(16,12), "E15x12.fd");
    test_class_info(&lv, &cd_E15x12);
    dp->~E15x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE15x12(Test_E15x12, "E15x12", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN6E15x12C1Ev();
extern void _ZN6E15x12D1Ev();
Name_Map name_map_E15x12[] = {
  NSPAIR(_ZN6E15x12C1Ev),
  NSPAIR(_ZN6E15x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E15x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E15x12[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E15x12[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV6E15x12[];
static  VTBL_ENTRY _tg__ZTV3C15__6E15x12[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C15__6E15x12[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C15__6E15x12[] = {
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
static  VTT_ENTRY vtt_E15x12[] = {
  {&(_ZTV6E15x12[4]),  4,13},
  {&(_tg__ZTV3C15__6E15x12[4]),  4,4},
  {&(_tg__ZTV2A1__3C15__6E15x12[3]),  3,4},
  {&(_tg__ZTV2B1__3C15__6E15x12[3]),  3,4},
  {&(_ZTV6E15x12[8]),  8,13},
  {&(_ZTV6E15x12[12]),  12,13},
};
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E15x12 = {  "E15x12", // class name
  bases_E15x12, 4,
  &(vtc_E15x12[0]), // expected_vtbl_contents
  &(vtt_E15x12[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI6E15x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E15x12),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6E15x12),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y0  : E15x12 , F1 {
  int ff;
  ~G15x12y0(); // tgen
  G15x12y0(); // tgen
};
//SIG(1 G15x12y0) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G15x12y0 ::~G15x12y0(){ note_dtor("G15x12y0", this);} // tgen
G15x12y0 ::G15x12y0(){ note_ctor("G15x12y0", this);} // tgen

static void Test_G15x12y0()
{
  extern Class_Descriptor cd_G15x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G15x12y0, buf);
    G15x12y0 *dp, &lv = *(dp=new (buf) G15x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G15x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y0)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(40,28), "G15x12y0");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(56,36), "G15x12y0");
    check_base_class_offset(lv, (C15*)(E15x12*), 0, "G15x12y0");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(12,8), "G15x12y0");
    check_base_class_offset(lv, (E15x12*), 0, "G15x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(24,16), "G15x12y0");
    check_field_offset(lv, ff, ABISELECT(36,24), "G15x12y0.ff");
    test_class_info(&lv, &cd_G15x12y0);
    dp->~G15x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y0(Test_G15x12y0, "G15x12y0", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G15x12y0C1Ev();
extern void _ZN8G15x12y0D1Ev();
Name_Map name_map_G15x12y0[] = {
  NSPAIR(_ZN8G15x12y0C1Ev),
  NSPAIR(_ZN8G15x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G15x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(56,36), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y0[];
extern void _ZN6E15x123fooEv();
extern void _ZN2F13fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn56_N6E15x123fooEv,_ZThn36_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G15x12y0[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y0[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8G15x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G15x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G15x12y0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV8G15x12y0[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y0[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y0[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y0[] = {
  0,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y0[] = {
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y0[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn56_N6E15x123fooEv,_ZThn36_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y0[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y0[] = {
  {&(_ZTV8G15x12y0[4]),  4,16},
  {&(_tg__ZTV6E15x12__8G15x12y0[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y0[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y0[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y0[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y0[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y0[3]),  3,4},
  {&(_ZTV8G15x12y0[11]),  11,16},
  {&(_ZTV8G15x12y0[15]),  15,16},
};
extern VTBL_ENTRY _ZTI8G15x12y0[];
extern  VTBL_ENTRY _ZTV8G15x12y0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y0[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N6E15x123fooEv,_ZThn36_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N6E15x123fooEv,_ZThn36_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y0 = {  "G15x12y0", // class name
  bases_G15x12y0, 6,
  &(vtc_G15x12y0[0]), // expected_vtbl_contents
  &(vtt_G15x12y0[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G15x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y0),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y0),9, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y1  : virtual E15x12 , F1 {
  int ff;
  ~G15x12y1(); // tgen
  G15x12y1(); // tgen
};
//SIG(1 G15x12y1) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G15x12y1 ::~G15x12y1(){ note_dtor("G15x12y1", this);} // tgen
G15x12y1 ::G15x12y1(){ note_ctor("G15x12y1", this);} // tgen

static void Test_G15x12y1()
{
  extern Class_Descriptor cd_G15x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G15x12y1, buf);
    G15x12y1 *dp, &lv = *(dp=new (buf) G15x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G15x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y1)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(40,28), "G15x12y1");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(56,36), "G15x12y1");
    check_base_class_offset(lv, (C15*)(E15x12*), ABISELECT(16,12), "G15x12y1");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(28,20), "G15x12y1");
    check_base_class_offset(lv, (E15x12*), ABISELECT(16,12), "G15x12y1");
    check_base_class_offset(lv, (F1*), 0, "G15x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G15x12y1.ff");
    test_class_info(&lv, &cd_G15x12y1);
    dp->~G15x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y1(Test_G15x12y1, "G15x12y1", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G15x12y1C1Ev();
extern void _ZN8G15x12y1D1Ev();
Name_Map name_map_G15x12y1[] = {
  NSPAIR(_ZN8G15x12y1C1Ev),
  NSPAIR(_ZN8G15x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G15x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(56,36), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G15x12y1[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(40,24),
  ABISELECT(24,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G15x12y1[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G15x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G15x12y1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV8G15x12y1[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y1[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y1[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y1[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y1[] = {
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y1[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y1[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y1[] = {
  {&(_ZTV8G15x12y1[5]),  5,20},
  {&(_ZTV8G15x12y1[11]),  11,20},
  {&(_ZTV8G15x12y1[15]),  15,20},
  {&(_ZTV8G15x12y1[19]),  19,20},
  {&(_tg__ZTV6E15x12__8G15x12y1[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y1[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y1[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y1[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y1[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y1[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G15x12y1[];
extern  VTBL_ENTRY _ZTV8G15x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y1[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y1 = {  "G15x12y1", // class name
  bases_G15x12y1, 6,
  &(vtc_G15x12y1[0]), // expected_vtbl_contents
  &(vtt_G15x12y1[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G15x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y1),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y1),10, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y2  : E15x12 , virtual F1 {
  int ff;
  ~G15x12y2(); // tgen
  G15x12y2(); // tgen
};
//SIG(1 G15x12y2) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G15x12y2 ::~G15x12y2(){ note_dtor("G15x12y2", this);} // tgen
G15x12y2 ::G15x12y2(){ note_ctor("G15x12y2", this);} // tgen

static void Test_G15x12y2()
{
  extern Class_Descriptor cd_G15x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G15x12y2, buf);
    G15x12y2 *dp, &lv = *(dp=new (buf) G15x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G15x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y2)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(24,20), "G15x12y2");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(40,28), "G15x12y2");
    check_base_class_offset(lv, (C15*)(E15x12*), 0, "G15x12y2");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(12,8), "G15x12y2");
    check_base_class_offset(lv, (E15x12*), 0, "G15x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(56,36), "G15x12y2");
    check_field_offset(lv, ff, ABISELECT(20,16), "G15x12y2.ff");
    test_class_info(&lv, &cd_G15x12y2);
    dp->~G15x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y2(Test_G15x12y2, "G15x12y2", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G15x12y2C1Ev();
extern void _ZN8G15x12y2D1Ev();
Name_Map name_map_G15x12y2[] = {
  NSPAIR(_ZN8G15x12y2C1Ev),
  NSPAIR(_ZN8G15x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G15x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(56,36), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y2[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G15x12y2[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y2[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI8G15x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G15x12y2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G15x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G15x12y2[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y2[] = {
  ABISELECT(40,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y2[] = {
  ABISELECT(40,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y2[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y2[] = {
  0,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y2[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y2[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y2[] = {
  {&(_ZTV8G15x12y2[5]),  5,18},
  {&(_tg__ZTV6E15x12__8G15x12y2[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y2[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y2[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y2[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y2[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y2[3]),  3,4},
  {&(_ZTV8G15x12y2[9]),  9,18},
  {&(_ZTV8G15x12y2[13]),  13,18},
  {&(_ZTV8G15x12y2[17]),  17,18},
};
extern VTBL_ENTRY _ZTI8G15x12y2[];
extern  VTBL_ENTRY _ZTV8G15x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y2[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y2 = {  "G15x12y2", // class name
  bases_G15x12y2, 6,
  &(vtc_G15x12y2[0]), // expected_vtbl_contents
  &(vtt_G15x12y2[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G15x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y2),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y2),10, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y3  : virtual E15x12 , virtual F1 {
  int ff;
  ~G15x12y3(); // tgen
  G15x12y3(); // tgen
};
//SIG(1 G15x12y3) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G15x12y3 ::~G15x12y3(){ note_dtor("G15x12y3", this);} // tgen
G15x12y3 ::G15x12y3(){ note_ctor("G15x12y3", this);} // tgen

static void Test_G15x12y3()
{
  extern Class_Descriptor cd_G15x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_G15x12y3, buf);
    G15x12y3 *dp, &lv = *(dp=new (buf) G15x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(G15x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y3)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(40,24), "G15x12y3");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(56,32), "G15x12y3");
    check_base_class_offset(lv, (C15*)(E15x12*), ABISELECT(16,8), "G15x12y3");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(28,16), "G15x12y3");
    check_base_class_offset(lv, (E15x12*), ABISELECT(16,8), "G15x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(72,40), "G15x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G15x12y3.ff");
    test_class_info(&lv, &cd_G15x12y3);
    dp->~G15x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y3(Test_G15x12y3, "G15x12y3", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN8G15x12y3C1Ev();
extern void _ZN8G15x12y3D1Ev();
Name_Map name_map_G15x12y3[] = {
  NSPAIR(_ZN8G15x12y3C1Ev),
  NSPAIR(_ZN8G15x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G15x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(56,32), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(72,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y3[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G15x12y3[] = {
  ABISELECT(72,40),
  ABISELECT(56,32),
  ABISELECT(40,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y3[0]),
  0,
  ABISELECT(40,24),
  ABISELECT(24,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G15x12y3[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8G15x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI8G15x12y3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  0,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI8G15x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G15x12y3[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y3[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y3[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y3[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y3[] = {
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y3[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y3[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y3[] = {
  {&(_ZTV8G15x12y3[6]),  6,24},
  {&(_ZTV8G15x12y3[11]),  11,24},
  {&(_ZTV8G15x12y3[15]),  15,24},
  {&(_ZTV8G15x12y3[19]),  19,24},
  {&(_ZTV8G15x12y3[23]),  23,24},
  {&(_tg__ZTV6E15x12__8G15x12y3[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y3[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y3[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y3[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y3[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y3[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G15x12y3[];
extern  VTBL_ENTRY _ZTV8G15x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y3[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y3 = {  "G15x12y3", // class name
  bases_G15x12y3, 6,
  &(vtc_G15x12y3[0]), // expected_vtbl_contents
  &(vtt_G15x12y3[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI8G15x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y3),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y3),11, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y4  : E15x12 , F0 {
  int ff;
  ~G15x12y4(); // tgen
  G15x12y4(); // tgen
};
//SIG(1 G15x12y4) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G15x12y4 ::~G15x12y4(){ note_dtor("G15x12y4", this);} // tgen
G15x12y4 ::G15x12y4(){ note_ctor("G15x12y4", this);} // tgen

static void Test_G15x12y4()
{
  extern Class_Descriptor cd_G15x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G15x12y4, buf);
    G15x12y4 *dp, &lv = *(dp=new (buf) G15x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G15x12y4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y4)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(32,24), "G15x12y4");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(48,32), "G15x12y4");
    check_base_class_offset(lv, (C15*)(E15x12*), 0, "G15x12y4");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(12,8), "G15x12y4");
    check_base_class_offset(lv, (E15x12*), 0, "G15x12y4");
    check_base_class_offset(lv, (F0*), ABISELECT(20,16), "G15x12y4");
    check_field_offset(lv, ff, ABISELECT(24,20), "G15x12y4.ff");
    test_class_info(&lv, &cd_G15x12y4);
    dp->~G15x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y4(Test_G15x12y4, "G15x12y4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G15x12y4C1Ev();
extern void _ZN8G15x12y4D1Ev();
Name_Map name_map_G15x12y4[] = {
  NSPAIR(_ZN8G15x12y4C1Ev),
  NSPAIR(_ZN8G15x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G15x12y4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(48,32), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y4[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn32_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn48_N6E15x123fooEv,_ZThn32_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G15x12y4[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y4[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G15x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G15x12y4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV8G15x12y4[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y4[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y4[] = {
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y4[] = {
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y4[] = {
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn32_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y4[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn48_N6E15x123fooEv,_ZThn32_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y4[] = {
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y4[] = {
  {&(_ZTV8G15x12y4[4]),  4,13},
  {&(_tg__ZTV6E15x12__8G15x12y4[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y4[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y4[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y4[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y4[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y4[3]),  3,4},
  {&(_ZTV8G15x12y4[8]),  8,13},
  {&(_ZTV8G15x12y4[12]),  12,13},
};
extern VTBL_ENTRY _ZTI8G15x12y4[];
extern  VTBL_ENTRY _ZTV8G15x12y4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y4[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6E15x123fooEv,_ZThn32_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6E15x123fooEv,_ZThn32_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y4 = {  "G15x12y4", // class name
  bases_G15x12y4, 6,
  &(vtc_G15x12y4[0]), // expected_vtbl_contents
  &(vtt_G15x12y4[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G15x12y4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y4),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y4),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y5  : virtual E15x12 , F0 {
  int ff;
  ~G15x12y5(); // tgen
  G15x12y5(); // tgen
};
//SIG(1 G15x12y5) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G15x12y5 ::~G15x12y5(){ note_dtor("G15x12y5", this);} // tgen
G15x12y5 ::G15x12y5(){ note_ctor("G15x12y5", this);} // tgen

static void Test_G15x12y5()
{
  extern Class_Descriptor cd_G15x12y5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G15x12y5, buf);
    G15x12y5 *dp, &lv = *(dp=new (buf) G15x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G15x12y5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y5)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(40,28), "G15x12y5");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(56,36), "G15x12y5");
    check_base_class_offset(lv, (C15*)(E15x12*), ABISELECT(16,12), "G15x12y5");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(28,20), "G15x12y5");
    check_base_class_offset(lv, (E15x12*), ABISELECT(16,12), "G15x12y5");
    check_base_class_offset(lv, (F0*), ABISELECT(8,4), "G15x12y5");
    check_field_offset(lv, ff, ABISELECT(12,8), "G15x12y5.ff");
    test_class_info(&lv, &cd_G15x12y5);
    dp->~G15x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y5(Test_G15x12y5, "G15x12y5", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G15x12y5C1Ev();
extern void _ZN8G15x12y5D1Ev();
Name_Map name_map_G15x12y5[] = {
  NSPAIR(_ZN8G15x12y5C1Ev),
  NSPAIR(_ZN8G15x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G15x12y5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y5[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G15x12y5[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y5[0]),
  0,
  ABISELECT(40,24),
  ABISELECT(24,16),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G15x12y5[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G15x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8G15x12y5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV8G15x12y5[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y5[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y5[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y5[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y5[] = {
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y5[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y5[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y5[] = {
  {&(_ZTV8G15x12y5[5]),  5,19},
  {&(_ZTV8G15x12y5[10]),  10,19},
  {&(_ZTV8G15x12y5[14]),  14,19},
  {&(_ZTV8G15x12y5[18]),  18,19},
  {&(_tg__ZTV6E15x12__8G15x12y5[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y5[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y5[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y5[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y5[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y5[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G15x12y5[];
extern  VTBL_ENTRY _ZTV8G15x12y5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y5[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y5 = {  "G15x12y5", // class name
  bases_G15x12y5, 6,
  &(vtc_G15x12y5[0]), // expected_vtbl_contents
  &(vtt_G15x12y5[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G15x12y5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y5),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y5),10, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y6  : E15x12 , virtual F0 {
  int ff;
  ~G15x12y6(); // tgen
  G15x12y6(); // tgen
};
//SIG(1 G15x12y6) C1{ BC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G15x12y6 ::~G15x12y6(){ note_dtor("G15x12y6", this);} // tgen
G15x12y6 ::G15x12y6(){ note_ctor("G15x12y6", this);} // tgen

static void Test_G15x12y6()
{
  extern Class_Descriptor cd_G15x12y6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_G15x12y6, buf);
    G15x12y6 *dp, &lv = *(dp=new (buf) G15x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(G15x12y6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y6)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(24,20), "G15x12y6");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(40,28), "G15x12y6");
    check_base_class_offset(lv, (C15*)(E15x12*), 0, "G15x12y6");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(12,8), "G15x12y6");
    check_base_class_offset(lv, (E15x12*), 0, "G15x12y6");
    check_base_class_offset(lv, (F0*), ABISELECT(52,36), "G15x12y6");
    check_field_offset(lv, ff, ABISELECT(20,16), "G15x12y6.ff");
    test_class_info(&lv, &cd_G15x12y6);
    dp->~G15x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y6(Test_G15x12y6, "G15x12y6", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8G15x12y6C1Ev();
extern void _ZN8G15x12y6D1Ev();
Name_Map name_map_G15x12y6[] = {
  NSPAIR(_ZN8G15x12y6C1Ev),
  NSPAIR(_ZN8G15x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G15x12y6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(24,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(40,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F0,    ABISELECT(52,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y6[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G15x12y6[] = {
  ABISELECT(52,36),
  ABISELECT(40,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y6[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI8G15x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI8G15x12y6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV8G15x12y6[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y6[] = {
  ABISELECT(40,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y6[] = {
  ABISELECT(40,28),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y6[] = {
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y6[] = {
  0,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y6[] = {
  ABISELECT(-24,-20),
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y6[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y6[] = {
  {&(_ZTV8G15x12y6[5]),  5,14},
  {&(_tg__ZTV6E15x12__8G15x12y6[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y6[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y6[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y6[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y6[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y6[3]),  3,4},
  {&(_ZTV8G15x12y6[9]),  9,14},
  {&(_ZTV8G15x12y6[13]),  13,14},
};
extern VTBL_ENTRY _ZTI8G15x12y6[];
extern  VTBL_ENTRY _ZTV8G15x12y6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y6[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn28_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn20_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y6 = {  "G15x12y6", // class name
  bases_G15x12y6, 6,
  &(vtc_G15x12y6[0]), // expected_vtbl_contents
  &(vtt_G15x12y6[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8G15x12y6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y6),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y6),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G15x12y7  : virtual E15x12 , virtual F0 {
  int ff;
  ~G15x12y7(); // tgen
  G15x12y7(); // tgen
};
//SIG(1 G15x12y7) C1{ VBC2{ BC3{ VBC4{ v1 Fi} VBC5{ v1 Fi} Fi} BC6{ Fi} v1 Fi} VBC7{ Fi} Fi}


G15x12y7 ::~G15x12y7(){ note_dtor("G15x12y7", this);} // tgen
G15x12y7 ::G15x12y7(){ note_ctor("G15x12y7", this);} // tgen

static void Test_G15x12y7()
{
  extern Class_Descriptor cd_G15x12y7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_G15x12y7, buf);
    G15x12y7 *dp, &lv = *(dp=new (buf) G15x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(G15x12y7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G15x12y7)");
    check_base_class_offset(lv, (A1*)(C15*)(E15x12*), ABISELECT(40,24), "G15x12y7");
    check_base_class_offset(lv, (B1*)(C15*)(E15x12*), ABISELECT(56,32), "G15x12y7");
    check_base_class_offset(lv, (C15*)(E15x12*), ABISELECT(16,8), "G15x12y7");
    check_base_class_offset(lv, (D0*)(E15x12*), ABISELECT(28,16), "G15x12y7");
    check_base_class_offset(lv, (E15x12*), ABISELECT(16,8), "G15x12y7");
    check_base_class_offset(lv, (F0*), ABISELECT(68,40), "G15x12y7");
    check_field_offset(lv, ff, ABISELECT(8,4), "G15x12y7.ff");
    test_class_info(&lv, &cd_G15x12y7);
    dp->~G15x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG15x12y7(Test_G15x12y7, "G15x12y7", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8G15x12y7C1Ev();
extern void _ZN8G15x12y7D1Ev();
Name_Map name_map_G15x12y7[] = {
  NSPAIR(_ZN8G15x12y7C1Ev),
  NSPAIR(_ZN8G15x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A1;
extern VTBL_ENTRY _ZTI2A1[];
extern  VTBL_ENTRY _ZTV2A1[];
extern Class_Descriptor cd_B1;
extern VTBL_ENTRY _ZTI2B1[];
extern  VTBL_ENTRY _ZTV2B1[];
extern Class_Descriptor cd_C15;
extern VTBL_ENTRY _ZTI3C15[];
extern  VTBL_ENTRY _ZTV3C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3C15[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E15x12;
extern VTBL_ENTRY _ZTI6E15x12[];
extern  VTBL_ENTRY _ZTV6E15x12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6E15x12[];
extern Class_Descriptor cd_F0;
extern VTBL_ENTRY _ZTI2F0[];
static Base_Class bases_G15x12y7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A1,    ABISELECT(40,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_B1,    ABISELECT(56,32), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_C15,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E15x12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F0,    ABISELECT(68,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G15x12y7[];
extern void _ZN6E15x123fooEv();
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G15x12y7[] = {
  ABISELECT(68,40),
  ABISELECT(56,32),
  ABISELECT(40,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G15x12y7[0]),
  0,
  ABISELECT(40,24),
  ABISELECT(24,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G15x12y7[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8G15x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI8G15x12y7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern VTBL_ENTRY _ZTV8G15x12y7[];
extern void _ZN6E15x123fooEv();
static  VTBL_ENTRY _tg__ZTV6E15x12__8G15x12y7[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&_ZN6E15x123fooEv,
};
static  VTBL_ENTRY _tg__ZTV3C156E15x12__8G15x12y7[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3C15[0]),
};
extern void _ZN2A13fooEv();
static  VTBL_ENTRY _tg__ZTV2A1__3C156E15x12__8G15x12y7[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2A13fooEv,
};
extern void _ZN2B13fooEv();
static  VTBL_ENTRY _tg__ZTV2B1__3C156E15x12__8G15x12y7[] = {
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3C15[0]),
  (VTBL_ENTRY)&_ZN2B13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2A1__6E15x12__8G15x12y7[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv)();
extern void ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV2B1__6E15x12__8G15x12y7[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI6E15x12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv),
};
static  VTT_ENTRY vtt_G15x12y7[] = {
  {&(_ZTV8G15x12y7[6]),  6,20},
  {&(_ZTV8G15x12y7[11]),  11,20},
  {&(_ZTV8G15x12y7[15]),  15,20},
  {&(_ZTV8G15x12y7[19]),  19,20},
  {&(_tg__ZTV6E15x12__8G15x12y7[4]),  4,5},
  {&(_tg__ZTV3C156E15x12__8G15x12y7[4]),  4,4},
  {&(_tg__ZTV2A1__3C156E15x12__8G15x12y7[3]),  3,4},
  {&(_tg__ZTV2B1__3C156E15x12__8G15x12y7[3]),  3,4},
  {&(_tg__ZTV2A1__6E15x12__8G15x12y7[3]),  3,4},
  {&(_tg__ZTV2B1__6E15x12__8G15x12y7[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8G15x12y7[];
extern  VTBL_ENTRY _ZTV8G15x12y7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G15x12y7[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6E15x123fooEv,_ZTv0_n12_N6E15x123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N6E15x123fooEv,_ZThn24_N6E15x123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6E15x123fooEv,_ZThn16_N6E15x123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G15x12y7 = {  "G15x12y7", // class name
  bases_G15x12y7, 6,
  &(vtc_G15x12y7[0]), // expected_vtbl_contents
  &(vtt_G15x12y7[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8G15x12y7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G15x12y7),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G15x12y7),10, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E16x12  : C16 , D0 {
  int fd;
  virtual void  foo(); // _ZN6E16x123fooEv
  ~E16x12(); // tgen
  E16x12(); // tgen
};
//SIG(-1 E16x12) C1{ BC2{ BC3{ Fi} BC4{ Fi} v1 Fi} BC5{ Fi} v1 Fi}


void  E16x12 ::foo(){vfunc_called(this, "_ZN6E16x123fooEv");}
E16x12 ::~E16x12(){ note_dtor("E16x12", this);} // tgen
E16x12 ::E16x12(){ note_ctor("E16x12", this);} // tgen

static void Test_E16x12()
{
  extern Class_Descriptor cd_E16x12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_E16x12, buf);
    E16x12 *dp, &lv = *(dp=new (buf) E16x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(E16x12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E16x12)");
    check_base_class_offset(lv, (A0*)(C16*), ABISELECT(8,4), "E16x12");
    check_base_class_offset(lv, (B0*)(C16*), ABISELECT(12,8), "E16x12");
    check_base_class_offset(lv, (C16*), 0, "E16x12");
    check_base_class_offset(lv, (D0*), ABISELECT(20,16), "E16x12");
    check_field_offset(lv, fd, ABISELECT(24,20), "E16x12.fd");
    test_class_info(&lv, &cd_E16x12);
    dp->~E16x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE16x12(Test_E16x12, "E16x12", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6E16x12C1Ev();
extern void _ZN6E16x12D1Ev();
Name_Map name_map_E16x12[] = {
  NSPAIR(_ZN6E16x12C1Ev),
  NSPAIR(_ZN6E16x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C16;
extern VTBL_ENTRY _ZTI3C16[];
extern  VTBL_ENTRY _ZTV3C16[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
static Base_Class bases_E16x12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6E16x12[];
extern void _ZN6E16x123fooEv();
static  VTBL_ENTRY vtc_E16x12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6E16x12[0]),
  (VTBL_ENTRY)&_ZN6E16x123fooEv,
};
extern VTBL_ENTRY _ZTI6E16x12[];
extern  VTBL_ENTRY _ZTV6E16x12[];
Class_Descriptor cd_E16x12 = {  "E16x12", // class name
  bases_E16x12, 4,
  &(vtc_E16x12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6E16x12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6E16x12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G16x12y0  : E16x12 , F1 {
  int ff;
  ~G16x12y0(); // tgen
  G16x12y0(); // tgen
};
//SIG(1 G16x12y0) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} v1 Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G16x12y0 ::~G16x12y0(){ note_dtor("G16x12y0", this);} // tgen
G16x12y0 ::G16x12y0(){ note_ctor("G16x12y0", this);} // tgen

static void Test_G16x12y0()
{
  extern Class_Descriptor cd_G16x12y0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G16x12y0, buf);
    G16x12y0 *dp, &lv = *(dp=new (buf) G16x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G16x12y0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G16x12y0)");
    check_base_class_offset(lv, (A0*)(C16*)(E16x12*), ABISELECT(8,4), "G16x12y0");
    check_base_class_offset(lv, (B0*)(C16*)(E16x12*), ABISELECT(12,8), "G16x12y0");
    check_base_class_offset(lv, (C16*)(E16x12*), 0, "G16x12y0");
    check_base_class_offset(lv, (D0*)(E16x12*), ABISELECT(20,16), "G16x12y0");
    check_base_class_offset(lv, (E16x12*), 0, "G16x12y0");
    check_base_class_offset(lv, (F1*), ABISELECT(32,24), "G16x12y0");
    check_field_offset(lv, ff, ABISELECT(44,32), "G16x12y0.ff");
    test_class_info(&lv, &cd_G16x12y0);
    dp->~G16x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG16x12y0(Test_G16x12y0, "G16x12y0", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G16x12y0C1Ev();
extern void _ZN8G16x12y0D1Ev();
Name_Map name_map_G16x12y0[] = {
  NSPAIR(_ZN8G16x12y0C1Ev),
  NSPAIR(_ZN8G16x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C16;
extern VTBL_ENTRY _ZTI3C16[];
extern  VTBL_ENTRY _ZTV3C16[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E16x12;
extern VTBL_ENTRY _ZTI6E16x12[];
extern  VTBL_ENTRY _ZTV6E16x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G16x12y0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E16x12,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,24), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G16x12y0[];
extern void _ZN6E16x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G16x12y0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8G16x12y0[0]),
  (VTBL_ENTRY)&_ZN6E16x123fooEv,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8G16x12y0[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTI8G16x12y0[];
extern  VTBL_ENTRY _ZTV8G16x12y0[];
Class_Descriptor cd_G16x12y0 = {  "G16x12y0", // class name
  bases_G16x12y0, 6,
  &(vtc_G16x12y0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G16x12y0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G16x12y0),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G16x12y1  : virtual E16x12 , F1 {
  int ff;
  ~G16x12y1(); // tgen
  G16x12y1(); // tgen
};
//SIG(1 G16x12y1) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ Fi} v1 Fi} BC6{ Fi} v1 Fi} BC7{ v2 Fi} Fi}


G16x12y1 ::~G16x12y1(){ note_dtor("G16x12y1", this);} // tgen
G16x12y1 ::G16x12y1(){ note_ctor("G16x12y1", this);} // tgen

static void Test_G16x12y1()
{
  extern Class_Descriptor cd_G16x12y1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G16x12y1, buf);
    G16x12y1 *dp, &lv = *(dp=new (buf) G16x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G16x12y1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G16x12y1)");
    check_base_class_offset(lv, (A0*)(C16*)(E16x12*), ABISELECT(24,16), "G16x12y1");
    check_base_class_offset(lv, (B0*)(C16*)(E16x12*), ABISELECT(28,20), "G16x12y1");
    check_base_class_offset(lv, (C16*)(E16x12*), ABISELECT(16,12), "G16x12y1");
    check_base_class_offset(lv, (D0*)(E16x12*), ABISELECT(36,28), "G16x12y1");
    check_base_class_offset(lv, (E16x12*), ABISELECT(16,12), "G16x12y1");
    check_base_class_offset(lv, (F1*), 0, "G16x12y1");
    check_field_offset(lv, ff, ABISELECT(12,8), "G16x12y1.ff");
    test_class_info(&lv, &cd_G16x12y1);
    dp->~G16x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG16x12y1(Test_G16x12y1, "G16x12y1", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G16x12y1C1Ev();
extern void _ZN8G16x12y1D1Ev();
Name_Map name_map_G16x12y1[] = {
  NSPAIR(_ZN8G16x12y1C1Ev),
  NSPAIR(_ZN8G16x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C16;
extern VTBL_ENTRY _ZTI3C16[];
extern  VTBL_ENTRY _ZTV3C16[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E16x12;
extern VTBL_ENTRY _ZTI6E16x12[];
extern  VTBL_ENTRY _ZTV6E16x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G16x12y1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C16,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E16x12,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8G16x12y1[];
extern void _ZN2F13fooEv();
extern void _ZN6E16x123fooEv();
static  VTBL_ENTRY vtc_G16x12y1[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8G16x12y1[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8G16x12y1[0]),
  (VTBL_ENTRY)&_ZN6E16x123fooEv,
};
extern VTBL_ENTRY _ZTV8G16x12y1[];
static  VTT_ENTRY vtt_G16x12y1[] = {
  {&(_ZTV8G16x12y1[3]),  3,8},
  {&(_ZTV8G16x12y1[7]),  7,8},
};
extern VTBL_ENTRY _ZTI8G16x12y1[];
extern  VTBL_ENTRY _ZTV8G16x12y1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G16x12y1[];
Class_Descriptor cd_G16x12y1 = {  "G16x12y1", // class name
  bases_G16x12y1, 6,
  &(vtc_G16x12y1[0]), // expected_vtbl_contents
  &(vtt_G16x12y1[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G16x12y1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G16x12y1),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G16x12y1),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G16x12y2  : E16x12 , virtual F1 {
  int ff;
  ~G16x12y2(); // tgen
  G16x12y2(); // tgen
};
//SIG(1 G16x12y2) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} v1 Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G16x12y2 ::~G16x12y2(){ note_dtor("G16x12y2", this);} // tgen
G16x12y2 ::G16x12y2(){ note_ctor("G16x12y2", this);} // tgen

static void Test_G16x12y2()
{
  extern Class_Descriptor cd_G16x12y2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_G16x12y2, buf);
    G16x12y2 *dp, &lv = *(dp=new (buf) G16x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(G16x12y2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G16x12y2)");
    check_base_class_offset(lv, (A0*)(C16*)(E16x12*), ABISELECT(8,4), "G16x12y2");
    check_base_class_offset(lv, (B0*)(C16*)(E16x12*), ABISELECT(12,8), "G16x12y2");
    check_base_class_offset(lv, (C16*)(E16x12*), 0, "G16x12y2");
    check_base_class_offset(lv, (D0*)(E16x12*), ABISELECT(20,16), "G16x12y2");
    check_base_class_offset(lv, (E16x12*), 0, "G16x12y2");
    check_base_class_offset(lv, (F1*), ABISELECT(32,28), "G16x12y2");
    check_field_offset(lv, ff, ABISELECT(28,24), "G16x12y2.ff");
    test_class_info(&lv, &cd_G16x12y2);
    dp->~G16x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG16x12y2(Test_G16x12y2, "G16x12y2", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8G16x12y2C1Ev();
extern void _ZN8G16x12y2D1Ev();
Name_Map name_map_G16x12y2[] = {
  NSPAIR(_ZN8G16x12y2C1Ev),
  NSPAIR(_ZN8G16x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C16;
extern VTBL_ENTRY _ZTI3C16[];
extern  VTBL_ENTRY _ZTV3C16[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E16x12;
extern VTBL_ENTRY _ZTI6E16x12[];
extern  VTBL_ENTRY _ZTV6E16x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G16x12y2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E16x12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_F1,    ABISELECT(32,28), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G16x12y2[];
extern void _ZN6E16x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G16x12y2[] = {
  ABISELECT(32,28),
  0,
  (VTBL_ENTRY)&(_ZTI8G16x12y2[0]),
  (VTBL_ENTRY)&_ZN6E16x123fooEv,
  0,
  ABISELECT(-32,-28),
  (VTBL_ENTRY)&(_ZTI8G16x12y2[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G16x12y2[];
static  VTT_ENTRY vtt_G16x12y2[] = {
  {&(_ZTV8G16x12y2[3]),  3,8},
  {&(_ZTV8G16x12y2[7]),  7,8},
};
extern VTBL_ENTRY _ZTI8G16x12y2[];
extern  VTBL_ENTRY _ZTV8G16x12y2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G16x12y2[];
Class_Descriptor cd_G16x12y2 = {  "G16x12y2", // class name
  bases_G16x12y2, 6,
  &(vtc_G16x12y2[0]), // expected_vtbl_contents
  &(vtt_G16x12y2[0]), // expected_vtt_contents
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8G16x12y2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G16x12y2),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G16x12y2),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G16x12y3  : virtual E16x12 , virtual F1 {
  int ff;
  ~G16x12y3(); // tgen
  G16x12y3(); // tgen
};
//SIG(1 G16x12y3) C1{ VBC2{ BC3{ BC4{ Fi} BC5{ Fi} v1 Fi} BC6{ Fi} v1 Fi} VBC7{ v2 Fi} Fi}


G16x12y3 ::~G16x12y3(){ note_dtor("G16x12y3", this);} // tgen
G16x12y3 ::G16x12y3(){ note_ctor("G16x12y3", this);} // tgen

static void Test_G16x12y3()
{
  extern Class_Descriptor cd_G16x12y3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_G16x12y3, buf);
    G16x12y3 *dp, &lv = *(dp=new (buf) G16x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(G16x12y3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G16x12y3)");
    check_base_class_offset(lv, (A0*)(C16*)(E16x12*), ABISELECT(24,12), "G16x12y3");
    check_base_class_offset(lv, (B0*)(C16*)(E16x12*), ABISELECT(28,16), "G16x12y3");
    check_base_class_offset(lv, (C16*)(E16x12*), ABISELECT(16,8), "G16x12y3");
    check_base_class_offset(lv, (D0*)(E16x12*), ABISELECT(36,24), "G16x12y3");
    check_base_class_offset(lv, (E16x12*), ABISELECT(16,8), "G16x12y3");
    check_base_class_offset(lv, (F1*), ABISELECT(48,32), "G16x12y3");
    check_field_offset(lv, ff, ABISELECT(8,4), "G16x12y3.ff");
    test_class_info(&lv, &cd_G16x12y3);
    dp->~G16x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG16x12y3(Test_G16x12y3, "G16x12y3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8G16x12y3C1Ev();
extern void _ZN8G16x12y3D1Ev();
Name_Map name_map_G16x12y3[] = {
  NSPAIR(_ZN8G16x12y3C1Ev),
  NSPAIR(_ZN8G16x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_A0;
extern VTBL_ENTRY _ZTI2A0[];
extern Class_Descriptor cd_B0;
extern VTBL_ENTRY _ZTI2B0[];
extern Class_Descriptor cd_C16;
extern VTBL_ENTRY _ZTI3C16[];
extern  VTBL_ENTRY _ZTV3C16[];
extern Class_Descriptor cd_D0;
extern VTBL_ENTRY _ZTI2D0[];
extern Class_Descriptor cd_E16x12;
extern VTBL_ENTRY _ZTI6E16x12[];
extern  VTBL_ENTRY _ZTV6E16x12[];
extern Class_Descriptor cd_F1;
extern VTBL_ENTRY _ZTI2F1[];
extern  VTBL_ENTRY _ZTV2F1[];
static Base_Class bases_G16x12y3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_A0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_B0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_C16,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_D0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_E16x12,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F1,    ABISELECT(48,32), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8G16x12y3[];
extern void _ZN6E16x123fooEv();
extern void _ZN2F13fooEv();
static  VTBL_ENTRY vtc_G16x12y3[] = {
  ABISELECT(48,32),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8G16x12y3[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8G16x12y3[0]),
  (VTBL_ENTRY)&_ZN6E16x123fooEv,
  0,
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8G16x12y3[0]),
  (VTBL_ENTRY)&_ZN2F13fooEv,
};
extern VTBL_ENTRY _ZTV8G16x12y3[];
static  VTT_ENTRY vtt_G16x12y3[] = {
  {&(_ZTV8G16x12y3[4]),  4,12},
  {&(_ZTV8G16x12y3[7]),  7,12},
  {&(_ZTV8G16x12y3[11]),  11,12},
};
extern VTBL_ENTRY _ZTI8G16x12y3[];
extern  VTBL_ENTRY _ZTV8G16x12y3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8G16x12y3[];
Class_Descriptor cd_G16x12y3 = {  "G16x12y3", // class name
  bases_G16x12y3, 6,
  &(vtc_G16x12y3[0]), // expected_vtbl_contents
  &(vtt_G16x12y3[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8G16x12y3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8G16x12y3),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8G16x12y3),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G16x12y4  : E16x12 , F0 {
  int ff;
  ~G16x12y4(); // tgen
  G16x12y4(); // tgen
};
//SIG(1 G16x12y4) C1{ BC2{ BC3{ BC4{ Fi} BC5{ Fi} v1 Fi} BC6{ Fi} v1 Fi} BC7{ Fi} Fi}


G16x12y4 ::~G16x12y4(){ note_dtor("G16x12y4", this);} // tgen
G16x12y4 ::G16x12y4(){ note_ctor("G16x12y4", this);} // tgen

static void Test_G16x12y4()
{
  extern Class_Descriptor cd_G16x12y4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_G16x12y4, buf);
    G16x12y4 *dp, &lv = *(dp=new (buf) G16x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(G16x12y4)");
    check2(__alignof__(lv), ABISELECT(