// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace ccc { 
struct  AA0  {
  virtual void  abc(); // _ZN3ccc3AA03abcEv
  virtual void  efg(); // _ZN3ccc3AA03efgEv
  virtual void  pqr(); // _ZN3ccc3AA03pqrEv
  ~AA0(); // tgen
  AA0(); // tgen
};
//SIG(-1 _ZN3ccc3AA0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA0 ::abc(){vfunc_called(this, "_ZN3ccc3AA03abcEv");}
void  ccc::AA0 ::efg(){vfunc_called(this, "_ZN3ccc3AA03efgEv");}
void  ccc::AA0 ::pqr(){vfunc_called(this, "_ZN3ccc3AA03pqrEv");}
ccc::AA0 ::~AA0(){ note_dtor("_ZN3ccc3AA0E", this);} // tgen
ccc::AA0 ::AA0(){ note_ctor("_ZN3ccc3AA0E", this);} // tgen
}
static void Test__ZN3ccc3AA0E()
{
  extern Class_Descriptor cd__ZN3ccc3AA0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA0E, buf);
    ::ccc::AA0 *dp, &lv = *(dp=new (buf) ::ccc::AA0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA0E)");
    test_class_info(&lv, &cd__ZN3ccc3AA0E);
    dp->::ccc::AA0::~AA0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA0E(Test__ZN3ccc3AA0E, "_ZN3ccc3AA0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA0C1Ev();
extern void _ZN3ccc3AA0D1Ev();
Name_Map name_map__ZN3ccc3AA0E[] = {
  NSPAIR(_ZN3ccc3AA0C1Ev),
  NSPAIR(_ZN3ccc3AA0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
Class_Descriptor cd__ZN3ccc3AA0E = {  "_ZN3ccc3AA0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB0  {
  virtual void  abc(); // _ZN3ccc3BB03abcEv
  virtual void  efg(); // _ZN3ccc3BB03efgEv
  virtual void  pqr(); // _ZN3ccc3BB03pqrEv
  ~BB0(); // tgen
  BB0(); // tgen
};
//SIG(1 _ZN3ccc3BB0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB0 ::abc(){vfunc_called(this, "_ZN3ccc3BB03abcEv");}
void  ccc::BB0 ::efg(){vfunc_called(this, "_ZN3ccc3BB03efgEv");}
void  ccc::BB0 ::pqr(){vfunc_called(this, "_ZN3ccc3BB03pqrEv");}
ccc::BB0 ::~BB0(){ note_dtor("_ZN3ccc3BB0E", this);} // tgen
ccc::BB0 ::BB0(){ note_ctor("_ZN3ccc3BB0E", this);} // tgen
}
static void Test__ZN3ccc3BB0E()
{
  extern Class_Descriptor cd__ZN3ccc3BB0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB0E, buf);
    ::ccc::BB0 *dp, &lv = *(dp=new (buf) ::ccc::BB0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB0E)");
    test_class_info(&lv, &cd__ZN3ccc3BB0E);
    dp->::ccc::BB0::~BB0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB0E(Test__ZN3ccc3BB0E, "_ZN3ccc3BB0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB0C1Ev();
extern void _ZN3ccc3BB0D1Ev();
Name_Map name_map__ZN3ccc3BB0E[] = {
  NSPAIR(_ZN3ccc3BB0C1Ev),
  NSPAIR(_ZN3ccc3BB0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern void _ZN3ccc3BB03abcEv();
extern void _ZN3ccc3BB03efgEv();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
Class_Descriptor cd__ZN3ccc3BB0E = {  "_ZN3ccc3BB0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x0  : virtual ::ccc::AA0 {
  virtual void  abc(); // _ZN3ccc5EE0x03abcEv
  virtual void  efg(); // _ZN3ccc5EE0x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE0x03pqrEv
  ~EE0x0(); // tgen
  EE0x0(); // tgen
};
//SIG(1 _ZN3ccc5EE0x0E) C1{ VBC2{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE0x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x03abcEv");}
void  ccc::EE0x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x03efgEv");}
void  ccc::EE0x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x03pqrEv");}
ccc::EE0x0 ::~EE0x0(){ note_dtor("_ZN3ccc5EE0x0E", this);} // tgen
ccc::EE0x0 ::EE0x0(){ note_ctor("_ZN3ccc5EE0x0E", this);} // tgen
}
static void Test__ZN3ccc5EE0x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x0E, buf);
    ::ccc::EE0x0 *dp, &lv = *(dp=new (buf) ::ccc::EE0x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x0E);
    dp->::ccc::EE0x0::~EE0x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x0E(Test__ZN3ccc5EE0x0E, "_ZN3ccc5EE0x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x0C1Ev();
extern void _ZN3ccc5EE0x0D1Ev();
Name_Map name_map__ZN3ccc5EE0x0E[] = {
  NSPAIR(_ZN3ccc5EE0x0C1Ev),
  NSPAIR(_ZN3ccc5EE0x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x0E[];
extern void _ZN3ccc5EE0x03abcEv();
extern void _ZN3ccc5EE0x03efgEv();
extern void _ZN3ccc5EE0x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x0E[] = {
  {&(_ZTVN3ccc5EE0x0E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x0E[];
Class_Descriptor cd__ZN3ccc5EE0x0E = {  "_ZN3ccc5EE0x0E", // class name
  bases__ZN3ccc5EE0x0E, 1,
  &(vtc__ZN3ccc5EE0x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x0E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x1  : virtual ::ccc::AA0 {
  virtual void  abc(); // _ZN3ccc5EE0x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE0x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE0x13efgEv
  ~EE0x1(); // tgen
  EE0x1(); // tgen
};
//SIG(1 _ZN3ccc5EE0x1E) C1{ VBC2{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE0x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x13abcEv");}
void  ccc::EE0x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x13pqrEv");}
void  ccc::EE0x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x13efgEv");}
ccc::EE0x1 ::~EE0x1(){ note_dtor("_ZN3ccc5EE0x1E", this);} // tgen
ccc::EE0x1 ::EE0x1(){ note_ctor("_ZN3ccc5EE0x1E", this);} // tgen
}
static void Test__ZN3ccc5EE0x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x1E, buf);
    ::ccc::EE0x1 *dp, &lv = *(dp=new (buf) ::ccc::EE0x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x1E);
    dp->::ccc::EE0x1::~EE0x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x1E(Test__ZN3ccc5EE0x1E, "_ZN3ccc5EE0x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x1C1Ev();
extern void _ZN3ccc5EE0x1D1Ev();
Name_Map name_map__ZN3ccc5EE0x1E[] = {
  NSPAIR(_ZN3ccc5EE0x1C1Ev),
  NSPAIR(_ZN3ccc5EE0x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x1E[];
extern void _ZN3ccc5EE0x13abcEv();
extern void _ZN3ccc5EE0x13efgEv();
extern void _ZN3ccc5EE0x13pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x13pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x1E[] = {
  {&(_ZTVN3ccc5EE0x1E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x1E[];
Class_Descriptor cd__ZN3ccc5EE0x1E = {  "_ZN3ccc5EE0x1E", // class name
  bases__ZN3ccc5EE0x1E, 1,
  &(vtc__ZN3ccc5EE0x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x1E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x2  : virtual ::ccc::AA0 {
  virtual void  efg(); // _ZN3ccc5EE0x23efgEv
  virtual void  abc(); // _ZN3ccc5EE0x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE0x23pqrEv
  ~EE0x2(); // tgen
  EE0x2(); // tgen
};
//SIG(1 _ZN3ccc5EE0x2E) C1{ VBC2{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE0x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x23efgEv");}
void  ccc::EE0x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x23abcEv");}
void  ccc::EE0x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x23pqrEv");}
ccc::EE0x2 ::~EE0x2(){ note_dtor("_ZN3ccc5EE0x2E", this);} // tgen
ccc::EE0x2 ::EE0x2(){ note_ctor("_ZN3ccc5EE0x2E", this);} // tgen
}
static void Test__ZN3ccc5EE0x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x2E, buf);
    ::ccc::EE0x2 *dp, &lv = *(dp=new (buf) ::ccc::EE0x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x2E);
    dp->::ccc::EE0x2::~EE0x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x2E(Test__ZN3ccc5EE0x2E, "_ZN3ccc5EE0x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x2C1Ev();
extern void _ZN3ccc5EE0x2D1Ev();
Name_Map name_map__ZN3ccc5EE0x2E[] = {
  NSPAIR(_ZN3ccc5EE0x2C1Ev),
  NSPAIR(_ZN3ccc5EE0x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x2E[];
extern void _ZN3ccc5EE0x23abcEv();
extern void _ZN3ccc5EE0x23efgEv();
extern void _ZN3ccc5EE0x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x2E[] = {
  {&(_ZTVN3ccc5EE0x2E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x2E[];
Class_Descriptor cd__ZN3ccc5EE0x2E = {  "_ZN3ccc5EE0x2E", // class name
  bases__ZN3ccc5EE0x2E, 1,
  &(vtc__ZN3ccc5EE0x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x2E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x3  : virtual ::ccc::AA0 {
  virtual void  efg(); // _ZN3ccc5EE0x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE0x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE0x33abcEv
  ~EE0x3(); // tgen
  EE0x3(); // tgen
};
//SIG(1 _ZN3ccc5EE0x3E) C1{ VBC2{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE0x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x33efgEv");}
void  ccc::EE0x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x33pqrEv");}
void  ccc::EE0x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x33abcEv");}
ccc::EE0x3 ::~EE0x3(){ note_dtor("_ZN3ccc5EE0x3E", this);} // tgen
ccc::EE0x3 ::EE0x3(){ note_ctor("_ZN3ccc5EE0x3E", this);} // tgen
}
static void Test__ZN3ccc5EE0x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x3E, buf);
    ::ccc::EE0x3 *dp, &lv = *(dp=new (buf) ::ccc::EE0x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x3E);
    dp->::ccc::EE0x3::~EE0x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x3E(Test__ZN3ccc5EE0x3E, "_ZN3ccc5EE0x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x3C1Ev();
extern void _ZN3ccc5EE0x3D1Ev();
Name_Map name_map__ZN3ccc5EE0x3E[] = {
  NSPAIR(_ZN3ccc5EE0x3C1Ev),
  NSPAIR(_ZN3ccc5EE0x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x3E[];
extern void _ZN3ccc5EE0x33abcEv();
extern void _ZN3ccc5EE0x33efgEv();
extern void _ZN3ccc5EE0x33pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x33pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x3E[] = {
  {&(_ZTVN3ccc5EE0x3E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x3E[];
Class_Descriptor cd__ZN3ccc5EE0x3E = {  "_ZN3ccc5EE0x3E", // class name
  bases__ZN3ccc5EE0x3E, 1,
  &(vtc__ZN3ccc5EE0x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x3E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x4  : virtual ::ccc::AA0 {
  virtual void  pqr(); // _ZN3ccc5EE0x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE0x43abcEv
  virtual void  efg(); // _ZN3ccc5EE0x43efgEv
  ~EE0x4(); // tgen
  EE0x4(); // tgen
};
//SIG(1 _ZN3ccc5EE0x4E) C1{ VBC2{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE0x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x43pqrEv");}
void  ccc::EE0x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x43abcEv");}
void  ccc::EE0x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x43efgEv");}
ccc::EE0x4 ::~EE0x4(){ note_dtor("_ZN3ccc5EE0x4E", this);} // tgen
ccc::EE0x4 ::EE0x4(){ note_ctor("_ZN3ccc5EE0x4E", this);} // tgen
}
static void Test__ZN3ccc5EE0x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x4E, buf);
    ::ccc::EE0x4 *dp, &lv = *(dp=new (buf) ::ccc::EE0x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x4E);
    dp->::ccc::EE0x4::~EE0x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x4E(Test__ZN3ccc5EE0x4E, "_ZN3ccc5EE0x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x4C1Ev();
extern void _ZN3ccc5EE0x4D1Ev();
Name_Map name_map__ZN3ccc5EE0x4E[] = {
  NSPAIR(_ZN3ccc5EE0x4C1Ev),
  NSPAIR(_ZN3ccc5EE0x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x4E[];
extern void _ZN3ccc5EE0x43abcEv();
extern void _ZN3ccc5EE0x43efgEv();
extern void _ZN3ccc5EE0x43pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x43pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x4E[] = {
  {&(_ZTVN3ccc5EE0x4E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x4E[];
Class_Descriptor cd__ZN3ccc5EE0x4E = {  "_ZN3ccc5EE0x4E", // class name
  bases__ZN3ccc5EE0x4E, 1,
  &(vtc__ZN3ccc5EE0x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x4E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x5  : virtual ::ccc::AA0 {
  virtual void  pqr(); // _ZN3ccc5EE0x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE0x53efgEv
  virtual void  abc(); // _ZN3ccc5EE0x53abcEv
  ~EE0x5(); // tgen
  EE0x5(); // tgen
};
//SIG(1 _ZN3ccc5EE0x5E) C1{ VBC2{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE0x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x53pqrEv");}
void  ccc::EE0x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x53efgEv");}
void  ccc::EE0x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x53abcEv");}
ccc::EE0x5 ::~EE0x5(){ note_dtor("_ZN3ccc5EE0x5E", this);} // tgen
ccc::EE0x5 ::EE0x5(){ note_ctor("_ZN3ccc5EE0x5E", this);} // tgen
}
static void Test__ZN3ccc5EE0x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x5E, buf);
    ::ccc::EE0x5 *dp, &lv = *(dp=new (buf) ::ccc::EE0x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x5E);
    dp->::ccc::EE0x5::~EE0x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x5E(Test__ZN3ccc5EE0x5E, "_ZN3ccc5EE0x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x5C1Ev();
extern void _ZN3ccc5EE0x5D1Ev();
Name_Map name_map__ZN3ccc5EE0x5E[] = {
  NSPAIR(_ZN3ccc5EE0x5C1Ev),
  NSPAIR(_ZN3ccc5EE0x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x5E[];
extern void _ZN3ccc5EE0x53abcEv();
extern void _ZN3ccc5EE0x53efgEv();
extern void _ZN3ccc5EE0x53pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x53pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x5E[] = {
  {&(_ZTVN3ccc5EE0x5E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x5E[];
Class_Descriptor cd__ZN3ccc5EE0x5E = {  "_ZN3ccc5EE0x5E", // class name
  bases__ZN3ccc5EE0x5E, 1,
  &(vtc__ZN3ccc5EE0x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x5E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x6  : virtual ::ccc::AA0 {
  virtual void  abc(); // _ZN3ccc5EE0x63abcEv
  virtual void  efg(); // _ZN3ccc5EE0x63efgEv
  ~EE0x6(); // tgen
  EE0x6(); // tgen
};
//SIG(1 _ZN3ccc5EE0x6E) C1{ VBC2{ v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE0x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x63abcEv");}
void  ccc::EE0x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x63efgEv");}
ccc::EE0x6 ::~EE0x6(){ note_dtor("_ZN3ccc5EE0x6E", this);} // tgen
ccc::EE0x6 ::EE0x6(){ note_ctor("_ZN3ccc5EE0x6E", this);} // tgen
}
static void Test__ZN3ccc5EE0x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x6E, buf);
    ::ccc::EE0x6 *dp, &lv = *(dp=new (buf) ::ccc::EE0x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x6E);
    dp->::ccc::EE0x6::~EE0x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x6E(Test__ZN3ccc5EE0x6E, "_ZN3ccc5EE0x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x6C1Ev();
extern void _ZN3ccc5EE0x6D1Ev();
Name_Map name_map__ZN3ccc5EE0x6E[] = {
  NSPAIR(_ZN3ccc5EE0x6C1Ev),
  NSPAIR(_ZN3ccc5EE0x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x6E[];
extern void _ZN3ccc5EE0x63abcEv();
extern void _ZN3ccc5EE0x63efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x6E[] = {
  {&(_ZTVN3ccc5EE0x6E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x6E[];
Class_Descriptor cd__ZN3ccc5EE0x6E = {  "_ZN3ccc5EE0x6E", // class name
  bases__ZN3ccc5EE0x6E, 1,
  &(vtc__ZN3ccc5EE0x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x6E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x7  : virtual ::ccc::AA0 {
  virtual void  abc(); // _ZN3ccc5EE0x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE0x73pqrEv
  ~EE0x7(); // tgen
  EE0x7(); // tgen
};
//SIG(1 _ZN3ccc5EE0x7E) C1{ VBC2{ v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE0x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x73abcEv");}
void  ccc::EE0x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x73pqrEv");}
ccc::EE0x7 ::~EE0x7(){ note_dtor("_ZN3ccc5EE0x7E", this);} // tgen
ccc::EE0x7 ::EE0x7(){ note_ctor("_ZN3ccc5EE0x7E", this);} // tgen
}
static void Test__ZN3ccc5EE0x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x7E, buf);
    ::ccc::EE0x7 *dp, &lv = *(dp=new (buf) ::ccc::EE0x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x7E);
    dp->::ccc::EE0x7::~EE0x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x7E(Test__ZN3ccc5EE0x7E, "_ZN3ccc5EE0x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x7C1Ev();
extern void _ZN3ccc5EE0x7D1Ev();
Name_Map name_map__ZN3ccc5EE0x7E[] = {
  NSPAIR(_ZN3ccc5EE0x7C1Ev),
  NSPAIR(_ZN3ccc5EE0x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x7E[];
extern void _ZN3ccc5EE0x73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc5EE0x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x7E[] = {
  {&(_ZTVN3ccc5EE0x7E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x7E[];
Class_Descriptor cd__ZN3ccc5EE0x7E = {  "_ZN3ccc5EE0x7E", // class name
  bases__ZN3ccc5EE0x7E, 1,
  &(vtc__ZN3ccc5EE0x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x7E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x8  : virtual ::ccc::AA0 {
  virtual void  efg(); // _ZN3ccc5EE0x83efgEv
  virtual void  abc(); // _ZN3ccc5EE0x83abcEv
  ~EE0x8(); // tgen
  EE0x8(); // tgen
};
//SIG(1 _ZN3ccc5EE0x8E) C1{ VBC2{ v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE0x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x83efgEv");}
void  ccc::EE0x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE0x83abcEv");}
ccc::EE0x8 ::~EE0x8(){ note_dtor("_ZN3ccc5EE0x8E", this);} // tgen
ccc::EE0x8 ::EE0x8(){ note_ctor("_ZN3ccc5EE0x8E", this);} // tgen
}
static void Test__ZN3ccc5EE0x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x8E, buf);
    ::ccc::EE0x8 *dp, &lv = *(dp=new (buf) ::ccc::EE0x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x8E);
    dp->::ccc::EE0x8::~EE0x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x8E(Test__ZN3ccc5EE0x8E, "_ZN3ccc5EE0x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x8C1Ev();
extern void _ZN3ccc5EE0x8D1Ev();
Name_Map name_map__ZN3ccc5EE0x8E[] = {
  NSPAIR(_ZN3ccc5EE0x8C1Ev),
  NSPAIR(_ZN3ccc5EE0x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x8E[];
extern void _ZN3ccc5EE0x83abcEv();
extern void _ZN3ccc5EE0x83efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE0x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x8E[] = {
  {&(_ZTVN3ccc5EE0x8E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x8E[];
Class_Descriptor cd__ZN3ccc5EE0x8E = {  "_ZN3ccc5EE0x8E", // class name
  bases__ZN3ccc5EE0x8E, 1,
  &(vtc__ZN3ccc5EE0x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x8E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x9  : virtual ::ccc::AA0 {
  virtual void  efg(); // _ZN3ccc5EE0x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE0x93pqrEv
  ~EE0x9(); // tgen
  EE0x9(); // tgen
};
//SIG(1 _ZN3ccc5EE0x9E) C1{ VBC2{ v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE0x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE0x93efgEv");}
void  ccc::EE0x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE0x93pqrEv");}
ccc::EE0x9 ::~EE0x9(){ note_dtor("_ZN3ccc5EE0x9E", this);} // tgen
ccc::EE0x9 ::EE0x9(){ note_ctor("_ZN3ccc5EE0x9E", this);} // tgen
}
static void Test__ZN3ccc5EE0x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE0x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE0x9E, buf);
    ::ccc::EE0x9 *dp, &lv = *(dp=new (buf) ::ccc::EE0x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE0x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE0x9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc5EE0x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE0x9E);
    dp->::ccc::EE0x9::~EE0x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE0x9E(Test__ZN3ccc5EE0x9E, "_ZN3ccc5EE0x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE0x9C1Ev();
extern void _ZN3ccc5EE0x9D1Ev();
Name_Map name_map__ZN3ccc5EE0x9E[] = {
  NSPAIR(_ZN3ccc5EE0x9C1Ev),
  NSPAIR(_ZN3ccc5EE0x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc5EE0x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE0x9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc5EE0x93efgEv();
extern void _ZN3ccc5EE0x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE0x9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE0x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE0x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE0x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE0x9E[] = {
  {&(_ZTVN3ccc5EE0x9E[6]),  6,9},
  {&(_ZTVN3ccc5EE0x9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE0x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE0x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE0x9E[];
Class_Descriptor cd__ZN3ccc5EE0x9E = {  "_ZN3ccc5EE0x9E", // class name
  bases__ZN3ccc5EE0x9E, 1,
  &(vtc__ZN3ccc5EE0x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE0x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE0x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE0x9E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE0x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x10  : virtual ::ccc::AA0 {
  virtual void  pqr(); // _ZN3ccc6EE0x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE0x103abcEv
  ~EE0x10(); // tgen
  EE0x10(); // tgen
};
//SIG(1 _ZN3ccc6EE0x10E) C1{ VBC2{ v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE0x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE0x103pqrEv");}
void  ccc::EE0x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE0x103abcEv");}
ccc::EE0x10 ::~EE0x10(){ note_dtor("_ZN3ccc6EE0x10E", this);} // tgen
ccc::EE0x10 ::EE0x10(){ note_ctor("_ZN3ccc6EE0x10E", this);} // tgen
}
static void Test__ZN3ccc6EE0x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE0x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE0x10E, buf);
    ::ccc::EE0x10 *dp, &lv = *(dp=new (buf) ::ccc::EE0x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE0x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE0x10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc6EE0x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE0x10E);
    dp->::ccc::EE0x10::~EE0x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE0x10E(Test__ZN3ccc6EE0x10E, "_ZN3ccc6EE0x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE0x10C1Ev();
extern void _ZN3ccc6EE0x10D1Ev();
Name_Map name_map__ZN3ccc6EE0x10E[] = {
  NSPAIR(_ZN3ccc6EE0x10C1Ev),
  NSPAIR(_ZN3ccc6EE0x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc6EE0x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE0x10E[];
extern void _ZN3ccc6EE0x103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc6EE0x103pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE0x10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE0x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE0x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE0x103pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE0x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE0x10E[] = {
  {&(_ZTVN3ccc6EE0x10E[6]),  6,9},
  {&(_ZTVN3ccc6EE0x10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE0x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE0x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE0x10E[];
Class_Descriptor cd__ZN3ccc6EE0x10E = {  "_ZN3ccc6EE0x10E", // class name
  bases__ZN3ccc6EE0x10E, 1,
  &(vtc__ZN3ccc6EE0x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE0x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE0x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE0x10E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE0x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x11  : virtual ::ccc::AA0 {
  virtual void  pqr(); // _ZN3ccc6EE0x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE0x113efgEv
  ~EE0x11(); // tgen
  EE0x11(); // tgen
};
//SIG(1 _ZN3ccc6EE0x11E) C1{ VBC2{ v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE0x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE0x113pqrEv");}
void  ccc::EE0x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE0x113efgEv");}
ccc::EE0x11 ::~EE0x11(){ note_dtor("_ZN3ccc6EE0x11E", this);} // tgen
ccc::EE0x11 ::EE0x11(){ note_ctor("_ZN3ccc6EE0x11E", this);} // tgen
}
static void Test__ZN3ccc6EE0x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE0x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE0x11E, buf);
    ::ccc::EE0x11 *dp, &lv = *(dp=new (buf) ::ccc::EE0x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE0x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE0x11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc6EE0x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE0x11E);
    dp->::ccc::EE0x11::~EE0x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE0x11E(Test__ZN3ccc6EE0x11E, "_ZN3ccc6EE0x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE0x11C1Ev();
extern void _ZN3ccc6EE0x11D1Ev();
Name_Map name_map__ZN3ccc6EE0x11E[] = {
  NSPAIR(_ZN3ccc6EE0x11C1Ev),
  NSPAIR(_ZN3ccc6EE0x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc6EE0x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE0x11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc6EE0x113efgEv();
extern void _ZN3ccc6EE0x113pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE0x11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE0x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE0x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE0x113pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE0x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE0x11E[] = {
  {&(_ZTVN3ccc6EE0x11E[6]),  6,9},
  {&(_ZTVN3ccc6EE0x11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE0x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE0x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE0x11E[];
Class_Descriptor cd__ZN3ccc6EE0x11E = {  "_ZN3ccc6EE0x11E", // class name
  bases__ZN3ccc6EE0x11E, 1,
  &(vtc__ZN3ccc6EE0x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE0x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE0x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE0x11E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE0x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x12  : virtual ::ccc::AA0 {
  virtual void  abc(); // _ZN3ccc6EE0x123abcEv
  ~EE0x12(); // tgen
  EE0x12(); // tgen
};
//SIG(1 _ZN3ccc6EE0x12E) C1{ VBC2{ v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::EE0x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE0x123abcEv");}
ccc::EE0x12 ::~EE0x12(){ note_dtor("_ZN3ccc6EE0x12E", this);} // tgen
ccc::EE0x12 ::EE0x12(){ note_ctor("_ZN3ccc6EE0x12E", this);} // tgen
}
static void Test__ZN3ccc6EE0x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE0x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE0x12E, buf);
    ::ccc::EE0x12 *dp, &lv = *(dp=new (buf) ::ccc::EE0x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE0x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE0x12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc6EE0x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE0x12E);
    dp->::ccc::EE0x12::~EE0x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE0x12E(Test__ZN3ccc6EE0x12E, "_ZN3ccc6EE0x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE0x12C1Ev();
extern void _ZN3ccc6EE0x12D1Ev();
Name_Map name_map__ZN3ccc6EE0x12E[] = {
  NSPAIR(_ZN3ccc6EE0x12C1Ev),
  NSPAIR(_ZN3ccc6EE0x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc6EE0x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE0x12E[];
extern void _ZN3ccc6EE0x123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE0x12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE0x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE0x123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE0x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE0x12E[] = {
  {&(_ZTVN3ccc6EE0x12E[6]),  6,9},
  {&(_ZTVN3ccc6EE0x12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE0x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE0x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE0x12E[];
Class_Descriptor cd__ZN3ccc6EE0x12E = {  "_ZN3ccc6EE0x12E", // class name
  bases__ZN3ccc6EE0x12E, 1,
  &(vtc__ZN3ccc6EE0x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE0x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE0x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE0x12E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE0x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x13  : virtual ::ccc::AA0 {
  virtual void  efg(); // _ZN3ccc6EE0x133efgEv
  ~EE0x13(); // tgen
  EE0x13(); // tgen
};
//SIG(1 _ZN3ccc6EE0x13E) C1{ VBC2{ v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::EE0x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE0x133efgEv");}
ccc::EE0x13 ::~EE0x13(){ note_dtor("_ZN3ccc6EE0x13E", this);} // tgen
ccc::EE0x13 ::EE0x13(){ note_ctor("_ZN3ccc6EE0x13E", this);} // tgen
}
static void Test__ZN3ccc6EE0x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE0x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE0x13E, buf);
    ::ccc::EE0x13 *dp, &lv = *(dp=new (buf) ::ccc::EE0x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE0x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE0x13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc6EE0x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE0x13E);
    dp->::ccc::EE0x13::~EE0x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE0x13E(Test__ZN3ccc6EE0x13E, "_ZN3ccc6EE0x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE0x13C1Ev();
extern void _ZN3ccc6EE0x13D1Ev();
Name_Map name_map__ZN3ccc6EE0x13E[] = {
  NSPAIR(_ZN3ccc6EE0x13C1Ev),
  NSPAIR(_ZN3ccc6EE0x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc6EE0x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE0x13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc6EE0x133efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE0x13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE0x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE0x133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE0x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE0x13E[] = {
  {&(_ZTVN3ccc6EE0x13E[6]),  6,9},
  {&(_ZTVN3ccc6EE0x13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE0x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE0x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE0x13E[];
Class_Descriptor cd__ZN3ccc6EE0x13E = {  "_ZN3ccc6EE0x13E", // class name
  bases__ZN3ccc6EE0x13E, 1,
  &(vtc__ZN3ccc6EE0x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE0x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE0x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE0x13E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE0x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x14  : virtual ::ccc::AA0 {
  virtual void  pqr(); // _ZN3ccc6EE0x143pqrEv
  ~EE0x14(); // tgen
  EE0x14(); // tgen
};
//SIG(1 _ZN3ccc6EE0x14E) C1{ VBC2{ v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::EE0x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE0x143pqrEv");}
ccc::EE0x14 ::~EE0x14(){ note_dtor("_ZN3ccc6EE0x14E", this);} // tgen
ccc::EE0x14 ::EE0x14(){ note_ctor("_ZN3ccc6EE0x14E", this);} // tgen
}
static void Test__ZN3ccc6EE0x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE0x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE0x14E, buf);
    ::ccc::EE0x14 *dp, &lv = *(dp=new (buf) ::ccc::EE0x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE0x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE0x14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc6EE0x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE0x14E);
    dp->::ccc::EE0x14::~EE0x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE0x14E(Test__ZN3ccc6EE0x14E, "_ZN3ccc6EE0x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE0x14C1Ev();
extern void _ZN3ccc6EE0x14D1Ev();
Name_Map name_map__ZN3ccc6EE0x14E[] = {
  NSPAIR(_ZN3ccc6EE0x14C1Ev),
  NSPAIR(_ZN3ccc6EE0x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc6EE0x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE0x14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc6EE0x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE0x14E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE0x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE0x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE0x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE0x14E[] = {
  {&(_ZTVN3ccc6EE0x14E[6]),  6,9},
  {&(_ZTVN3ccc6EE0x14E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE0x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE0x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE0x14E[];
Class_Descriptor cd__ZN3ccc6EE0x14E = {  "_ZN3ccc6EE0x14E", // class name
  bases__ZN3ccc6EE0x14E, 1,
  &(vtc__ZN3ccc6EE0x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE0x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE0x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE0x14E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE0x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE0x15  : virtual ::ccc::AA0 {
  ~EE0x15(); // tgen
  EE0x15(); // tgen
};
//SIG(1 _ZN3ccc6EE0x15E) C1{ VBC2{ v1 v2 v3}}
}
namespace ccc { 
ccc::EE0x15 ::~EE0x15(){ note_dtor("_ZN3ccc6EE0x15E", this);} // tgen
ccc::EE0x15 ::EE0x15(){ note_ctor("_ZN3ccc6EE0x15E", this);} // tgen
}
static void Test__ZN3ccc6EE0x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE0x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE0x15E, buf);
    ::ccc::EE0x15 *dp, &lv = *(dp=new (buf) ::ccc::EE0x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE0x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE0x15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc6EE0x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE0x15E);
    dp->::ccc::EE0x15::~EE0x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE0x15E(Test__ZN3ccc6EE0x15E, "_ZN3ccc6EE0x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE0x15C1Ev();
extern void _ZN3ccc6EE0x15D1Ev();
Name_Map name_map__ZN3ccc6EE0x15E[] = {
  NSPAIR(_ZN3ccc6EE0x15C1Ev),
  NSPAIR(_ZN3ccc6EE0x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
static Base_Class bases__ZN3ccc6EE0x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE0x15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE0x15E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE0x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE0x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE0x15E[] = {
  {&(_ZTVN3ccc6EE0x15E[6]),  6,9},
  {&(_ZTVN3ccc6EE0x15E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE0x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE0x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE0x15E[];
Class_Descriptor cd__ZN3ccc6EE0x15E = {  "_ZN3ccc6EE0x15E", // class name
  bases__ZN3ccc6EE0x15E, 1,
  &(vtc__ZN3ccc6EE0x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE0x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE0x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE0x15E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE0x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA1  {
  virtual void  abc(); // _ZN3ccc3AA13abcEv
  virtual void  pqr(); // _ZN3ccc3AA13pqrEv
  virtual void  efg(); // _ZN3ccc3AA13efgEv
  ~AA1(); // tgen
  AA1(); // tgen
};
//SIG(-1 _ZN3ccc3AA1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA1 ::abc(){vfunc_called(this, "_ZN3ccc3AA13abcEv");}
void  ccc::AA1 ::pqr(){vfunc_called(this, "_ZN3ccc3AA13pqrEv");}
void  ccc::AA1 ::efg(){vfunc_called(this, "_ZN3ccc3AA13efgEv");}
ccc::AA1 ::~AA1(){ note_dtor("_ZN3ccc3AA1E", this);} // tgen
ccc::AA1 ::AA1(){ note_ctor("_ZN3ccc3AA1E", this);} // tgen
}
static void Test__ZN3ccc3AA1E()
{
  extern Class_Descriptor cd__ZN3ccc3AA1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA1E, buf);
    ::ccc::AA1 *dp, &lv = *(dp=new (buf) ::ccc::AA1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA1E)");
    test_class_info(&lv, &cd__ZN3ccc3AA1E);
    dp->::ccc::AA1::~AA1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA1E(Test__ZN3ccc3AA1E, "_ZN3ccc3AA1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA1C1Ev();
extern void _ZN3ccc3AA1D1Ev();
Name_Map name_map__ZN3ccc3AA1E[] = {
  NSPAIR(_ZN3ccc3AA1C1Ev),
  NSPAIR(_ZN3ccc3AA1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
Class_Descriptor cd__ZN3ccc3AA1E = {  "_ZN3ccc3AA1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB1  {
  virtual void  abc(); // _ZN3ccc3BB13abcEv
  virtual void  pqr(); // _ZN3ccc3BB13pqrEv
  virtual void  efg(); // _ZN3ccc3BB13efgEv
  ~BB1(); // tgen
  BB1(); // tgen
};
//SIG(1 _ZN3ccc3BB1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB1 ::abc(){vfunc_called(this, "_ZN3ccc3BB13abcEv");}
void  ccc::BB1 ::pqr(){vfunc_called(this, "_ZN3ccc3BB13pqrEv");}
void  ccc::BB1 ::efg(){vfunc_called(this, "_ZN3ccc3BB13efgEv");}
ccc::BB1 ::~BB1(){ note_dtor("_ZN3ccc3BB1E", this);} // tgen
ccc::BB1 ::BB1(){ note_ctor("_ZN3ccc3BB1E", this);} // tgen
}
static void Test__ZN3ccc3BB1E()
{
  extern Class_Descriptor cd__ZN3ccc3BB1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB1E, buf);
    ::ccc::BB1 *dp, &lv = *(dp=new (buf) ::ccc::BB1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB1E)");
    test_class_info(&lv, &cd__ZN3ccc3BB1E);
    dp->::ccc::BB1::~BB1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB1E(Test__ZN3ccc3BB1E, "_ZN3ccc3BB1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB1C1Ev();
extern void _ZN3ccc3BB1D1Ev();
Name_Map name_map__ZN3ccc3BB1E[] = {
  NSPAIR(_ZN3ccc3BB1C1Ev),
  NSPAIR(_ZN3ccc3BB1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern void _ZN3ccc3BB13abcEv();
extern void _ZN3ccc3BB13pqrEv();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
Class_Descriptor cd__ZN3ccc3BB1E = {  "_ZN3ccc3BB1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x0  : virtual ::ccc::AA1 {
  virtual void  abc(); // _ZN3ccc5EE1x03abcEv
  virtual void  efg(); // _ZN3ccc5EE1x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE1x03pqrEv
  ~EE1x0(); // tgen
  EE1x0(); // tgen
};
//SIG(1 _ZN3ccc5EE1x0E) C1{ VBC2{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE1x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x03abcEv");}
void  ccc::EE1x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x03efgEv");}
void  ccc::EE1x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x03pqrEv");}
ccc::EE1x0 ::~EE1x0(){ note_dtor("_ZN3ccc5EE1x0E", this);} // tgen
ccc::EE1x0 ::EE1x0(){ note_ctor("_ZN3ccc5EE1x0E", this);} // tgen
}
static void Test__ZN3ccc5EE1x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x0E, buf);
    ::ccc::EE1x0 *dp, &lv = *(dp=new (buf) ::ccc::EE1x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x0E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x0E);
    dp->::ccc::EE1x0::~EE1x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x0E(Test__ZN3ccc5EE1x0E, "_ZN3ccc5EE1x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x0C1Ev();
extern void _ZN3ccc5EE1x0D1Ev();
Name_Map name_map__ZN3ccc5EE1x0E[] = {
  NSPAIR(_ZN3ccc5EE1x0C1Ev),
  NSPAIR(_ZN3ccc5EE1x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x0E[];
extern void _ZN3ccc5EE1x03abcEv();
extern void _ZN3ccc5EE1x03pqrEv();
extern void _ZN3ccc5EE1x03efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x03efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x0E[] = {
  {&(_ZTVN3ccc5EE1x0E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x0E[];
Class_Descriptor cd__ZN3ccc5EE1x0E = {  "_ZN3ccc5EE1x0E", // class name
  bases__ZN3ccc5EE1x0E, 1,
  &(vtc__ZN3ccc5EE1x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x0E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x1  : virtual ::ccc::AA1 {
  virtual void  abc(); // _ZN3ccc5EE1x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE1x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE1x13efgEv
  ~EE1x1(); // tgen
  EE1x1(); // tgen
};
//SIG(1 _ZN3ccc5EE1x1E) C1{ VBC2{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE1x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x13abcEv");}
void  ccc::EE1x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x13pqrEv");}
void  ccc::EE1x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x13efgEv");}
ccc::EE1x1 ::~EE1x1(){ note_dtor("_ZN3ccc5EE1x1E", this);} // tgen
ccc::EE1x1 ::EE1x1(){ note_ctor("_ZN3ccc5EE1x1E", this);} // tgen
}
static void Test__ZN3ccc5EE1x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x1E, buf);
    ::ccc::EE1x1 *dp, &lv = *(dp=new (buf) ::ccc::EE1x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x1E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x1E);
    dp->::ccc::EE1x1::~EE1x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x1E(Test__ZN3ccc5EE1x1E, "_ZN3ccc5EE1x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x1C1Ev();
extern void _ZN3ccc5EE1x1D1Ev();
Name_Map name_map__ZN3ccc5EE1x1E[] = {
  NSPAIR(_ZN3ccc5EE1x1C1Ev),
  NSPAIR(_ZN3ccc5EE1x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x1E[];
extern void _ZN3ccc5EE1x13abcEv();
extern void _ZN3ccc5EE1x13pqrEv();
extern void _ZN3ccc5EE1x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x1E[] = {
  {&(_ZTVN3ccc5EE1x1E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x1E[];
Class_Descriptor cd__ZN3ccc5EE1x1E = {  "_ZN3ccc5EE1x1E", // class name
  bases__ZN3ccc5EE1x1E, 1,
  &(vtc__ZN3ccc5EE1x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x1E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x2  : virtual ::ccc::AA1 {
  virtual void  efg(); // _ZN3ccc5EE1x23efgEv
  virtual void  abc(); // _ZN3ccc5EE1x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE1x23pqrEv
  ~EE1x2(); // tgen
  EE1x2(); // tgen
};
//SIG(1 _ZN3ccc5EE1x2E) C1{ VBC2{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE1x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x23efgEv");}
void  ccc::EE1x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x23abcEv");}
void  ccc::EE1x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x23pqrEv");}
ccc::EE1x2 ::~EE1x2(){ note_dtor("_ZN3ccc5EE1x2E", this);} // tgen
ccc::EE1x2 ::EE1x2(){ note_ctor("_ZN3ccc5EE1x2E", this);} // tgen
}
static void Test__ZN3ccc5EE1x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x2E, buf);
    ::ccc::EE1x2 *dp, &lv = *(dp=new (buf) ::ccc::EE1x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x2E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x2E);
    dp->::ccc::EE1x2::~EE1x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x2E(Test__ZN3ccc5EE1x2E, "_ZN3ccc5EE1x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x2C1Ev();
extern void _ZN3ccc5EE1x2D1Ev();
Name_Map name_map__ZN3ccc5EE1x2E[] = {
  NSPAIR(_ZN3ccc5EE1x2C1Ev),
  NSPAIR(_ZN3ccc5EE1x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x2E[];
extern void _ZN3ccc5EE1x23abcEv();
extern void _ZN3ccc5EE1x23pqrEv();
extern void _ZN3ccc5EE1x23efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x23efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x2E[] = {
  {&(_ZTVN3ccc5EE1x2E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x2E[];
Class_Descriptor cd__ZN3ccc5EE1x2E = {  "_ZN3ccc5EE1x2E", // class name
  bases__ZN3ccc5EE1x2E, 1,
  &(vtc__ZN3ccc5EE1x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x2E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x3  : virtual ::ccc::AA1 {
  virtual void  efg(); // _ZN3ccc5EE1x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE1x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE1x33abcEv
  ~EE1x3(); // tgen
  EE1x3(); // tgen
};
//SIG(1 _ZN3ccc5EE1x3E) C1{ VBC2{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE1x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x33efgEv");}
void  ccc::EE1x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x33pqrEv");}
void  ccc::EE1x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x33abcEv");}
ccc::EE1x3 ::~EE1x3(){ note_dtor("_ZN3ccc5EE1x3E", this);} // tgen
ccc::EE1x3 ::EE1x3(){ note_ctor("_ZN3ccc5EE1x3E", this);} // tgen
}
static void Test__ZN3ccc5EE1x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x3E, buf);
    ::ccc::EE1x3 *dp, &lv = *(dp=new (buf) ::ccc::EE1x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x3E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x3E);
    dp->::ccc::EE1x3::~EE1x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x3E(Test__ZN3ccc5EE1x3E, "_ZN3ccc5EE1x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x3C1Ev();
extern void _ZN3ccc5EE1x3D1Ev();
Name_Map name_map__ZN3ccc5EE1x3E[] = {
  NSPAIR(_ZN3ccc5EE1x3C1Ev),
  NSPAIR(_ZN3ccc5EE1x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x3E[];
extern void _ZN3ccc5EE1x33abcEv();
extern void _ZN3ccc5EE1x33pqrEv();
extern void _ZN3ccc5EE1x33efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x33efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x3E[] = {
  {&(_ZTVN3ccc5EE1x3E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x3E[];
Class_Descriptor cd__ZN3ccc5EE1x3E = {  "_ZN3ccc5EE1x3E", // class name
  bases__ZN3ccc5EE1x3E, 1,
  &(vtc__ZN3ccc5EE1x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x3E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x4  : virtual ::ccc::AA1 {
  virtual void  pqr(); // _ZN3ccc5EE1x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE1x43abcEv
  virtual void  efg(); // _ZN3ccc5EE1x43efgEv
  ~EE1x4(); // tgen
  EE1x4(); // tgen
};
//SIG(1 _ZN3ccc5EE1x4E) C1{ VBC2{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE1x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x43pqrEv");}
void  ccc::EE1x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x43abcEv");}
void  ccc::EE1x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x43efgEv");}
ccc::EE1x4 ::~EE1x4(){ note_dtor("_ZN3ccc5EE1x4E", this);} // tgen
ccc::EE1x4 ::EE1x4(){ note_ctor("_ZN3ccc5EE1x4E", this);} // tgen
}
static void Test__ZN3ccc5EE1x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x4E, buf);
    ::ccc::EE1x4 *dp, &lv = *(dp=new (buf) ::ccc::EE1x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x4E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x4E);
    dp->::ccc::EE1x4::~EE1x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x4E(Test__ZN3ccc5EE1x4E, "_ZN3ccc5EE1x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x4C1Ev();
extern void _ZN3ccc5EE1x4D1Ev();
Name_Map name_map__ZN3ccc5EE1x4E[] = {
  NSPAIR(_ZN3ccc5EE1x4C1Ev),
  NSPAIR(_ZN3ccc5EE1x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x4E[];
extern void _ZN3ccc5EE1x43abcEv();
extern void _ZN3ccc5EE1x43pqrEv();
extern void _ZN3ccc5EE1x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x4E[] = {
  {&(_ZTVN3ccc5EE1x4E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x4E[];
Class_Descriptor cd__ZN3ccc5EE1x4E = {  "_ZN3ccc5EE1x4E", // class name
  bases__ZN3ccc5EE1x4E, 1,
  &(vtc__ZN3ccc5EE1x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x4E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x5  : virtual ::ccc::AA1 {
  virtual void  pqr(); // _ZN3ccc5EE1x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE1x53efgEv
  virtual void  abc(); // _ZN3ccc5EE1x53abcEv
  ~EE1x5(); // tgen
  EE1x5(); // tgen
};
//SIG(1 _ZN3ccc5EE1x5E) C1{ VBC2{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE1x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x53pqrEv");}
void  ccc::EE1x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x53efgEv");}
void  ccc::EE1x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x53abcEv");}
ccc::EE1x5 ::~EE1x5(){ note_dtor("_ZN3ccc5EE1x5E", this);} // tgen
ccc::EE1x5 ::EE1x5(){ note_ctor("_ZN3ccc5EE1x5E", this);} // tgen
}
static void Test__ZN3ccc5EE1x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x5E, buf);
    ::ccc::EE1x5 *dp, &lv = *(dp=new (buf) ::ccc::EE1x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x5E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x5E);
    dp->::ccc::EE1x5::~EE1x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x5E(Test__ZN3ccc5EE1x5E, "_ZN3ccc5EE1x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x5C1Ev();
extern void _ZN3ccc5EE1x5D1Ev();
Name_Map name_map__ZN3ccc5EE1x5E[] = {
  NSPAIR(_ZN3ccc5EE1x5C1Ev),
  NSPAIR(_ZN3ccc5EE1x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x5E[];
extern void _ZN3ccc5EE1x53abcEv();
extern void _ZN3ccc5EE1x53pqrEv();
extern void _ZN3ccc5EE1x53efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x53efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x5E[] = {
  {&(_ZTVN3ccc5EE1x5E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x5E[];
Class_Descriptor cd__ZN3ccc5EE1x5E = {  "_ZN3ccc5EE1x5E", // class name
  bases__ZN3ccc5EE1x5E, 1,
  &(vtc__ZN3ccc5EE1x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x5E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x6  : virtual ::ccc::AA1 {
  virtual void  abc(); // _ZN3ccc5EE1x63abcEv
  virtual void  efg(); // _ZN3ccc5EE1x63efgEv
  ~EE1x6(); // tgen
  EE1x6(); // tgen
};
//SIG(1 _ZN3ccc5EE1x6E) C1{ VBC2{ v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE1x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x63abcEv");}
void  ccc::EE1x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x63efgEv");}
ccc::EE1x6 ::~EE1x6(){ note_dtor("_ZN3ccc5EE1x6E", this);} // tgen
ccc::EE1x6 ::EE1x6(){ note_ctor("_ZN3ccc5EE1x6E", this);} // tgen
}
static void Test__ZN3ccc5EE1x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x6E, buf);
    ::ccc::EE1x6 *dp, &lv = *(dp=new (buf) ::ccc::EE1x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x6E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x6E);
    dp->::ccc::EE1x6::~EE1x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x6E(Test__ZN3ccc5EE1x6E, "_ZN3ccc5EE1x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x6C1Ev();
extern void _ZN3ccc5EE1x6D1Ev();
Name_Map name_map__ZN3ccc5EE1x6E[] = {
  NSPAIR(_ZN3ccc5EE1x6C1Ev),
  NSPAIR(_ZN3ccc5EE1x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x6E[];
extern void _ZN3ccc5EE1x63abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc5EE1x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x6E[] = {
  {&(_ZTVN3ccc5EE1x6E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x6E[];
Class_Descriptor cd__ZN3ccc5EE1x6E = {  "_ZN3ccc5EE1x6E", // class name
  bases__ZN3ccc5EE1x6E, 1,
  &(vtc__ZN3ccc5EE1x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x6E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x7  : virtual ::ccc::AA1 {
  virtual void  abc(); // _ZN3ccc5EE1x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE1x73pqrEv
  ~EE1x7(); // tgen
  EE1x7(); // tgen
};
//SIG(1 _ZN3ccc5EE1x7E) C1{ VBC2{ v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE1x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x73abcEv");}
void  ccc::EE1x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x73pqrEv");}
ccc::EE1x7 ::~EE1x7(){ note_dtor("_ZN3ccc5EE1x7E", this);} // tgen
ccc::EE1x7 ::EE1x7(){ note_ctor("_ZN3ccc5EE1x7E", this);} // tgen
}
static void Test__ZN3ccc5EE1x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x7E, buf);
    ::ccc::EE1x7 *dp, &lv = *(dp=new (buf) ::ccc::EE1x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x7E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x7E);
    dp->::ccc::EE1x7::~EE1x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x7E(Test__ZN3ccc5EE1x7E, "_ZN3ccc5EE1x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x7C1Ev();
extern void _ZN3ccc5EE1x7D1Ev();
Name_Map name_map__ZN3ccc5EE1x7E[] = {
  NSPAIR(_ZN3ccc5EE1x7C1Ev),
  NSPAIR(_ZN3ccc5EE1x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x7E[];
extern void _ZN3ccc5EE1x73abcEv();
extern void _ZN3ccc5EE1x73pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x7E[] = {
  {&(_ZTVN3ccc5EE1x7E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x7E[];
Class_Descriptor cd__ZN3ccc5EE1x7E = {  "_ZN3ccc5EE1x7E", // class name
  bases__ZN3ccc5EE1x7E, 1,
  &(vtc__ZN3ccc5EE1x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x7E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x8  : virtual ::ccc::AA1 {
  virtual void  efg(); // _ZN3ccc5EE1x83efgEv
  virtual void  abc(); // _ZN3ccc5EE1x83abcEv
  ~EE1x8(); // tgen
  EE1x8(); // tgen
};
//SIG(1 _ZN3ccc5EE1x8E) C1{ VBC2{ v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE1x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x83efgEv");}
void  ccc::EE1x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE1x83abcEv");}
ccc::EE1x8 ::~EE1x8(){ note_dtor("_ZN3ccc5EE1x8E", this);} // tgen
ccc::EE1x8 ::EE1x8(){ note_ctor("_ZN3ccc5EE1x8E", this);} // tgen
}
static void Test__ZN3ccc5EE1x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x8E, buf);
    ::ccc::EE1x8 *dp, &lv = *(dp=new (buf) ::ccc::EE1x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x8E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x8E);
    dp->::ccc::EE1x8::~EE1x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x8E(Test__ZN3ccc5EE1x8E, "_ZN3ccc5EE1x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x8C1Ev();
extern void _ZN3ccc5EE1x8D1Ev();
Name_Map name_map__ZN3ccc5EE1x8E[] = {
  NSPAIR(_ZN3ccc5EE1x8C1Ev),
  NSPAIR(_ZN3ccc5EE1x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x8E[];
extern void _ZN3ccc5EE1x83abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc5EE1x83efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE1x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x83efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x8E[] = {
  {&(_ZTVN3ccc5EE1x8E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x8E[];
Class_Descriptor cd__ZN3ccc5EE1x8E = {  "_ZN3ccc5EE1x8E", // class name
  bases__ZN3ccc5EE1x8E, 1,
  &(vtc__ZN3ccc5EE1x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x8E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x9  : virtual ::ccc::AA1 {
  virtual void  efg(); // _ZN3ccc5EE1x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE1x93pqrEv
  ~EE1x9(); // tgen
  EE1x9(); // tgen
};
//SIG(1 _ZN3ccc5EE1x9E) C1{ VBC2{ v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE1x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE1x93efgEv");}
void  ccc::EE1x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE1x93pqrEv");}
ccc::EE1x9 ::~EE1x9(){ note_dtor("_ZN3ccc5EE1x9E", this);} // tgen
ccc::EE1x9 ::EE1x9(){ note_ctor("_ZN3ccc5EE1x9E", this);} // tgen
}
static void Test__ZN3ccc5EE1x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE1x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE1x9E, buf);
    ::ccc::EE1x9 *dp, &lv = *(dp=new (buf) ::ccc::EE1x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE1x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE1x9E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc5EE1x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE1x9E);
    dp->::ccc::EE1x9::~EE1x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE1x9E(Test__ZN3ccc5EE1x9E, "_ZN3ccc5EE1x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE1x9C1Ev();
extern void _ZN3ccc5EE1x9D1Ev();
Name_Map name_map__ZN3ccc5EE1x9E[] = {
  NSPAIR(_ZN3ccc5EE1x9C1Ev),
  NSPAIR(_ZN3ccc5EE1x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc5EE1x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE1x9E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc5EE1x93pqrEv();
extern void _ZN3ccc5EE1x93efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE1x9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE1x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE1x93efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE1x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE1x9E[] = {
  {&(_ZTVN3ccc5EE1x9E[6]),  6,9},
  {&(_ZTVN3ccc5EE1x9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE1x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE1x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE1x9E[];
Class_Descriptor cd__ZN3ccc5EE1x9E = {  "_ZN3ccc5EE1x9E", // class name
  bases__ZN3ccc5EE1x9E, 1,
  &(vtc__ZN3ccc5EE1x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE1x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE1x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE1x9E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE1x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x10  : virtual ::ccc::AA1 {
  virtual void  pqr(); // _ZN3ccc6EE1x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE1x103abcEv
  ~EE1x10(); // tgen
  EE1x10(); // tgen
};
//SIG(1 _ZN3ccc6EE1x10E) C1{ VBC2{ v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE1x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE1x103pqrEv");}
void  ccc::EE1x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE1x103abcEv");}
ccc::EE1x10 ::~EE1x10(){ note_dtor("_ZN3ccc6EE1x10E", this);} // tgen
ccc::EE1x10 ::EE1x10(){ note_ctor("_ZN3ccc6EE1x10E", this);} // tgen
}
static void Test__ZN3ccc6EE1x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE1x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE1x10E, buf);
    ::ccc::EE1x10 *dp, &lv = *(dp=new (buf) ::ccc::EE1x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE1x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE1x10E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc6EE1x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE1x10E);
    dp->::ccc::EE1x10::~EE1x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE1x10E(Test__ZN3ccc6EE1x10E, "_ZN3ccc6EE1x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE1x10C1Ev();
extern void _ZN3ccc6EE1x10D1Ev();
Name_Map name_map__ZN3ccc6EE1x10E[] = {
  NSPAIR(_ZN3ccc6EE1x10C1Ev),
  NSPAIR(_ZN3ccc6EE1x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc6EE1x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE1x10E[];
extern void _ZN3ccc6EE1x103abcEv();
extern void _ZN3ccc6EE1x103pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE1x10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE1x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE1x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE1x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE1x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE1x10E[] = {
  {&(_ZTVN3ccc6EE1x10E[6]),  6,9},
  {&(_ZTVN3ccc6EE1x10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE1x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE1x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE1x10E[];
Class_Descriptor cd__ZN3ccc6EE1x10E = {  "_ZN3ccc6EE1x10E", // class name
  bases__ZN3ccc6EE1x10E, 1,
  &(vtc__ZN3ccc6EE1x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE1x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE1x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE1x10E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE1x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x11  : virtual ::ccc::AA1 {
  virtual void  pqr(); // _ZN3ccc6EE1x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE1x113efgEv
  ~EE1x11(); // tgen
  EE1x11(); // tgen
};
//SIG(1 _ZN3ccc6EE1x11E) C1{ VBC2{ v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE1x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE1x113pqrEv");}
void  ccc::EE1x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE1x113efgEv");}
ccc::EE1x11 ::~EE1x11(){ note_dtor("_ZN3ccc6EE1x11E", this);} // tgen
ccc::EE1x11 ::EE1x11(){ note_ctor("_ZN3ccc6EE1x11E", this);} // tgen
}
static void Test__ZN3ccc6EE1x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE1x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE1x11E, buf);
    ::ccc::EE1x11 *dp, &lv = *(dp=new (buf) ::ccc::EE1x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE1x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE1x11E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc6EE1x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE1x11E);
    dp->::ccc::EE1x11::~EE1x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE1x11E(Test__ZN3ccc6EE1x11E, "_ZN3ccc6EE1x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE1x11C1Ev();
extern void _ZN3ccc6EE1x11D1Ev();
Name_Map name_map__ZN3ccc6EE1x11E[] = {
  NSPAIR(_ZN3ccc6EE1x11C1Ev),
  NSPAIR(_ZN3ccc6EE1x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc6EE1x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE1x11E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc6EE1x113pqrEv();
extern void _ZN3ccc6EE1x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE1x11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE1x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE1x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE1x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE1x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE1x11E[] = {
  {&(_ZTVN3ccc6EE1x11E[6]),  6,9},
  {&(_ZTVN3ccc6EE1x11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE1x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE1x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE1x11E[];
Class_Descriptor cd__ZN3ccc6EE1x11E = {  "_ZN3ccc6EE1x11E", // class name
  bases__ZN3ccc6EE1x11E, 1,
  &(vtc__ZN3ccc6EE1x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE1x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE1x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE1x11E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE1x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x12  : virtual ::ccc::AA1 {
  virtual void  abc(); // _ZN3ccc6EE1x123abcEv
  ~EE1x12(); // tgen
  EE1x12(); // tgen
};
//SIG(1 _ZN3ccc6EE1x12E) C1{ VBC2{ v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::EE1x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE1x123abcEv");}
ccc::EE1x12 ::~EE1x12(){ note_dtor("_ZN3ccc6EE1x12E", this);} // tgen
ccc::EE1x12 ::EE1x12(){ note_ctor("_ZN3ccc6EE1x12E", this);} // tgen
}
static void Test__ZN3ccc6EE1x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE1x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE1x12E, buf);
    ::ccc::EE1x12 *dp, &lv = *(dp=new (buf) ::ccc::EE1x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE1x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE1x12E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc6EE1x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE1x12E);
    dp->::ccc::EE1x12::~EE1x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE1x12E(Test__ZN3ccc6EE1x12E, "_ZN3ccc6EE1x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE1x12C1Ev();
extern void _ZN3ccc6EE1x12D1Ev();
Name_Map name_map__ZN3ccc6EE1x12E[] = {
  NSPAIR(_ZN3ccc6EE1x12C1Ev),
  NSPAIR(_ZN3ccc6EE1x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc6EE1x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE1x12E[];
extern void _ZN3ccc6EE1x123abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE1x12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE1x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE1x123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE1x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE1x12E[] = {
  {&(_ZTVN3ccc6EE1x12E[6]),  6,9},
  {&(_ZTVN3ccc6EE1x12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE1x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE1x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE1x12E[];
Class_Descriptor cd__ZN3ccc6EE1x12E = {  "_ZN3ccc6EE1x12E", // class name
  bases__ZN3ccc6EE1x12E, 1,
  &(vtc__ZN3ccc6EE1x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE1x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE1x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE1x12E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE1x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x13  : virtual ::ccc::AA1 {
  virtual void  efg(); // _ZN3ccc6EE1x133efgEv
  ~EE1x13(); // tgen
  EE1x13(); // tgen
};
//SIG(1 _ZN3ccc6EE1x13E) C1{ VBC2{ v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::EE1x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE1x133efgEv");}
ccc::EE1x13 ::~EE1x13(){ note_dtor("_ZN3ccc6EE1x13E", this);} // tgen
ccc::EE1x13 ::EE1x13(){ note_ctor("_ZN3ccc6EE1x13E", this);} // tgen
}
static void Test__ZN3ccc6EE1x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE1x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE1x13E, buf);
    ::ccc::EE1x13 *dp, &lv = *(dp=new (buf) ::ccc::EE1x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE1x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE1x13E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc6EE1x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE1x13E);
    dp->::ccc::EE1x13::~EE1x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE1x13E(Test__ZN3ccc6EE1x13E, "_ZN3ccc6EE1x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE1x13C1Ev();
extern void _ZN3ccc6EE1x13D1Ev();
Name_Map name_map__ZN3ccc6EE1x13E[] = {
  NSPAIR(_ZN3ccc6EE1x13C1Ev),
  NSPAIR(_ZN3ccc6EE1x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc6EE1x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE1x13E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc6EE1x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE1x13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE1x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE1x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE1x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE1x13E[] = {
  {&(_ZTVN3ccc6EE1x13E[6]),  6,9},
  {&(_ZTVN3ccc6EE1x13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE1x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE1x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE1x13E[];
Class_Descriptor cd__ZN3ccc6EE1x13E = {  "_ZN3ccc6EE1x13E", // class name
  bases__ZN3ccc6EE1x13E, 1,
  &(vtc__ZN3ccc6EE1x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE1x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE1x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE1x13E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE1x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x14  : virtual ::ccc::AA1 {
  virtual void  pqr(); // _ZN3ccc6EE1x143pqrEv
  ~EE1x14(); // tgen
  EE1x14(); // tgen
};
//SIG(1 _ZN3ccc6EE1x14E) C1{ VBC2{ v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::EE1x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE1x143pqrEv");}
ccc::EE1x14 ::~EE1x14(){ note_dtor("_ZN3ccc6EE1x14E", this);} // tgen
ccc::EE1x14 ::EE1x14(){ note_ctor("_ZN3ccc6EE1x14E", this);} // tgen
}
static void Test__ZN3ccc6EE1x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE1x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE1x14E, buf);
    ::ccc::EE1x14 *dp, &lv = *(dp=new (buf) ::ccc::EE1x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE1x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE1x14E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc6EE1x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE1x14E);
    dp->::ccc::EE1x14::~EE1x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE1x14E(Test__ZN3ccc6EE1x14E, "_ZN3ccc6EE1x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE1x14C1Ev();
extern void _ZN3ccc6EE1x14D1Ev();
Name_Map name_map__ZN3ccc6EE1x14E[] = {
  NSPAIR(_ZN3ccc6EE1x14C1Ev),
  NSPAIR(_ZN3ccc6EE1x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc6EE1x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE1x14E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc6EE1x143pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE1x14E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE1x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE1x143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE1x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE1x14E[] = {
  {&(_ZTVN3ccc6EE1x14E[6]),  6,9},
  {&(_ZTVN3ccc6EE1x14E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE1x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE1x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE1x14E[];
Class_Descriptor cd__ZN3ccc6EE1x14E = {  "_ZN3ccc6EE1x14E", // class name
  bases__ZN3ccc6EE1x14E, 1,
  &(vtc__ZN3ccc6EE1x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE1x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE1x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE1x14E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE1x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE1x15  : virtual ::ccc::AA1 {
  ~EE1x15(); // tgen
  EE1x15(); // tgen
};
//SIG(1 _ZN3ccc6EE1x15E) C1{ VBC2{ v1 v2 v3}}
}
namespace ccc { 
ccc::EE1x15 ::~EE1x15(){ note_dtor("_ZN3ccc6EE1x15E", this);} // tgen
ccc::EE1x15 ::EE1x15(){ note_ctor("_ZN3ccc6EE1x15E", this);} // tgen
}
static void Test__ZN3ccc6EE1x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE1x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE1x15E, buf);
    ::ccc::EE1x15 *dp, &lv = *(dp=new (buf) ::ccc::EE1x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE1x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE1x15E)");
    check_base_class_offset(lv, (::ccc::AA1*), 0, "_ZN3ccc6EE1x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE1x15E);
    dp->::ccc::EE1x15::~EE1x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE1x15E(Test__ZN3ccc6EE1x15E, "_ZN3ccc6EE1x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE1x15C1Ev();
extern void _ZN3ccc6EE1x15D1Ev();
Name_Map name_map__ZN3ccc6EE1x15E[] = {
  NSPAIR(_ZN3ccc6EE1x15C1Ev),
  NSPAIR(_ZN3ccc6EE1x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA1E;
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
static Base_Class bases__ZN3ccc6EE1x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE1x15E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE1x15E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE1x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE1x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE1x15E[] = {
  {&(_ZTVN3ccc6EE1x15E[6]),  6,9},
  {&(_ZTVN3ccc6EE1x15E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE1x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE1x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE1x15E[];
Class_Descriptor cd__ZN3ccc6EE1x15E = {  "_ZN3ccc6EE1x15E", // class name
  bases__ZN3ccc6EE1x15E, 1,
  &(vtc__ZN3ccc6EE1x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE1x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE1x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE1x15E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE1x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA2  {
  virtual void  efg(); // _ZN3ccc3AA23efgEv
  virtual void  abc(); // _ZN3ccc3AA23abcEv
  virtual void  pqr(); // _ZN3ccc3AA23pqrEv
  ~AA2(); // tgen
  AA2(); // tgen
};
//SIG(-1 _ZN3ccc3AA2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA2 ::efg(){vfunc_called(this, "_ZN3ccc3AA23efgEv");}
void  ccc::AA2 ::abc(){vfunc_called(this, "_ZN3ccc3AA23abcEv");}
void  ccc::AA2 ::pqr(){vfunc_called(this, "_ZN3ccc3AA23pqrEv");}
ccc::AA2 ::~AA2(){ note_dtor("_ZN3ccc3AA2E", this);} // tgen
ccc::AA2 ::AA2(){ note_ctor("_ZN3ccc3AA2E", this);} // tgen
}
static void Test__ZN3ccc3AA2E()
{
  extern Class_Descriptor cd__ZN3ccc3AA2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA2E, buf);
    ::ccc::AA2 *dp, &lv = *(dp=new (buf) ::ccc::AA2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA2E)");
    test_class_info(&lv, &cd__ZN3ccc3AA2E);
    dp->::ccc::AA2::~AA2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA2E(Test__ZN3ccc3AA2E, "_ZN3ccc3AA2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA2C1Ev();
extern void _ZN3ccc3AA2D1Ev();
Name_Map name_map__ZN3ccc3AA2E[] = {
  NSPAIR(_ZN3ccc3AA2C1Ev),
  NSPAIR(_ZN3ccc3AA2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
Class_Descriptor cd__ZN3ccc3AA2E = {  "_ZN3ccc3AA2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB2  {
  virtual void  efg(); // _ZN3ccc3BB23efgEv
  virtual void  abc(); // _ZN3ccc3BB23abcEv
  virtual void  pqr(); // _ZN3ccc3BB23pqrEv
  ~BB2(); // tgen
  BB2(); // tgen
};
//SIG(1 _ZN3ccc3BB2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB2 ::efg(){vfunc_called(this, "_ZN3ccc3BB23efgEv");}
void  ccc::BB2 ::abc(){vfunc_called(this, "_ZN3ccc3BB23abcEv");}
void  ccc::BB2 ::pqr(){vfunc_called(this, "_ZN3ccc3BB23pqrEv");}
ccc::BB2 ::~BB2(){ note_dtor("_ZN3ccc3BB2E", this);} // tgen
ccc::BB2 ::BB2(){ note_ctor("_ZN3ccc3BB2E", this);} // tgen
}
static void Test__ZN3ccc3BB2E()
{
  extern Class_Descriptor cd__ZN3ccc3BB2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB2E, buf);
    ::ccc::BB2 *dp, &lv = *(dp=new (buf) ::ccc::BB2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB2E)");
    test_class_info(&lv, &cd__ZN3ccc3BB2E);
    dp->::ccc::BB2::~BB2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB2E(Test__ZN3ccc3BB2E, "_ZN3ccc3BB2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB2C1Ev();
extern void _ZN3ccc3BB2D1Ev();
Name_Map name_map__ZN3ccc3BB2E[] = {
  NSPAIR(_ZN3ccc3BB2C1Ev),
  NSPAIR(_ZN3ccc3BB2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern void _ZN3ccc3BB23efgEv();
extern void _ZN3ccc3BB23abcEv();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
Class_Descriptor cd__ZN3ccc3BB2E = {  "_ZN3ccc3BB2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x0  : virtual ::ccc::AA2 {
  virtual void  abc(); // _ZN3ccc5EE2x03abcEv
  virtual void  efg(); // _ZN3ccc5EE2x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE2x03pqrEv
  ~EE2x0(); // tgen
  EE2x0(); // tgen
};
//SIG(1 _ZN3ccc5EE2x0E) C1{ VBC2{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE2x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x03abcEv");}
void  ccc::EE2x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x03efgEv");}
void  ccc::EE2x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x03pqrEv");}
ccc::EE2x0 ::~EE2x0(){ note_dtor("_ZN3ccc5EE2x0E", this);} // tgen
ccc::EE2x0 ::EE2x0(){ note_ctor("_ZN3ccc5EE2x0E", this);} // tgen
}
static void Test__ZN3ccc5EE2x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x0E, buf);
    ::ccc::EE2x0 *dp, &lv = *(dp=new (buf) ::ccc::EE2x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x0E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x0E);
    dp->::ccc::EE2x0::~EE2x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x0E(Test__ZN3ccc5EE2x0E, "_ZN3ccc5EE2x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x0C1Ev();
extern void _ZN3ccc5EE2x0D1Ev();
Name_Map name_map__ZN3ccc5EE2x0E[] = {
  NSPAIR(_ZN3ccc5EE2x0C1Ev),
  NSPAIR(_ZN3ccc5EE2x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x0E[];
extern void _ZN3ccc5EE2x03efgEv();
extern void _ZN3ccc5EE2x03abcEv();
extern void _ZN3ccc5EE2x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x0E[] = {
  {&(_ZTVN3ccc5EE2x0E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x0E[];
Class_Descriptor cd__ZN3ccc5EE2x0E = {  "_ZN3ccc5EE2x0E", // class name
  bases__ZN3ccc5EE2x0E, 1,
  &(vtc__ZN3ccc5EE2x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x0E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x1  : virtual ::ccc::AA2 {
  virtual void  abc(); // _ZN3ccc5EE2x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE2x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE2x13efgEv
  ~EE2x1(); // tgen
  EE2x1(); // tgen
};
//SIG(1 _ZN3ccc5EE2x1E) C1{ VBC2{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE2x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x13abcEv");}
void  ccc::EE2x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x13pqrEv");}
void  ccc::EE2x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x13efgEv");}
ccc::EE2x1 ::~EE2x1(){ note_dtor("_ZN3ccc5EE2x1E", this);} // tgen
ccc::EE2x1 ::EE2x1(){ note_ctor("_ZN3ccc5EE2x1E", this);} // tgen
}
static void Test__ZN3ccc5EE2x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x1E, buf);
    ::ccc::EE2x1 *dp, &lv = *(dp=new (buf) ::ccc::EE2x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x1E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x1E);
    dp->::ccc::EE2x1::~EE2x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x1E(Test__ZN3ccc5EE2x1E, "_ZN3ccc5EE2x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x1C1Ev();
extern void _ZN3ccc5EE2x1D1Ev();
Name_Map name_map__ZN3ccc5EE2x1E[] = {
  NSPAIR(_ZN3ccc5EE2x1C1Ev),
  NSPAIR(_ZN3ccc5EE2x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x1E[];
extern void _ZN3ccc5EE2x13efgEv();
extern void _ZN3ccc5EE2x13abcEv();
extern void _ZN3ccc5EE2x13pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x13pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x1E[] = {
  {&(_ZTVN3ccc5EE2x1E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x1E[];
Class_Descriptor cd__ZN3ccc5EE2x1E = {  "_ZN3ccc5EE2x1E", // class name
  bases__ZN3ccc5EE2x1E, 1,
  &(vtc__ZN3ccc5EE2x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x1E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x2  : virtual ::ccc::AA2 {
  virtual void  efg(); // _ZN3ccc5EE2x23efgEv
  virtual void  abc(); // _ZN3ccc5EE2x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE2x23pqrEv
  ~EE2x2(); // tgen
  EE2x2(); // tgen
};
//SIG(1 _ZN3ccc5EE2x2E) C1{ VBC2{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE2x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x23efgEv");}
void  ccc::EE2x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x23abcEv");}
void  ccc::EE2x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x23pqrEv");}
ccc::EE2x2 ::~EE2x2(){ note_dtor("_ZN3ccc5EE2x2E", this);} // tgen
ccc::EE2x2 ::EE2x2(){ note_ctor("_ZN3ccc5EE2x2E", this);} // tgen
}
static void Test__ZN3ccc5EE2x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x2E, buf);
    ::ccc::EE2x2 *dp, &lv = *(dp=new (buf) ::ccc::EE2x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x2E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x2E);
    dp->::ccc::EE2x2::~EE2x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x2E(Test__ZN3ccc5EE2x2E, "_ZN3ccc5EE2x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x2C1Ev();
extern void _ZN3ccc5EE2x2D1Ev();
Name_Map name_map__ZN3ccc5EE2x2E[] = {
  NSPAIR(_ZN3ccc5EE2x2C1Ev),
  NSPAIR(_ZN3ccc5EE2x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x2E[];
extern void _ZN3ccc5EE2x23efgEv();
extern void _ZN3ccc5EE2x23abcEv();
extern void _ZN3ccc5EE2x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x2E[] = {
  {&(_ZTVN3ccc5EE2x2E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x2E[];
Class_Descriptor cd__ZN3ccc5EE2x2E = {  "_ZN3ccc5EE2x2E", // class name
  bases__ZN3ccc5EE2x2E, 1,
  &(vtc__ZN3ccc5EE2x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x2E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x3  : virtual ::ccc::AA2 {
  virtual void  efg(); // _ZN3ccc5EE2x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE2x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE2x33abcEv
  ~EE2x3(); // tgen
  EE2x3(); // tgen
};
//SIG(1 _ZN3ccc5EE2x3E) C1{ VBC2{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE2x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x33efgEv");}
void  ccc::EE2x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x33pqrEv");}
void  ccc::EE2x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x33abcEv");}
ccc::EE2x3 ::~EE2x3(){ note_dtor("_ZN3ccc5EE2x3E", this);} // tgen
ccc::EE2x3 ::EE2x3(){ note_ctor("_ZN3ccc5EE2x3E", this);} // tgen
}
static void Test__ZN3ccc5EE2x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x3E, buf);
    ::ccc::EE2x3 *dp, &lv = *(dp=new (buf) ::ccc::EE2x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x3E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x3E);
    dp->::ccc::EE2x3::~EE2x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x3E(Test__ZN3ccc5EE2x3E, "_ZN3ccc5EE2x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x3C1Ev();
extern void _ZN3ccc5EE2x3D1Ev();
Name_Map name_map__ZN3ccc5EE2x3E[] = {
  NSPAIR(_ZN3ccc5EE2x3C1Ev),
  NSPAIR(_ZN3ccc5EE2x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x3E[];
extern void _ZN3ccc5EE2x33efgEv();
extern void _ZN3ccc5EE2x33abcEv();
extern void _ZN3ccc5EE2x33pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x33pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x3E[] = {
  {&(_ZTVN3ccc5EE2x3E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x3E[];
Class_Descriptor cd__ZN3ccc5EE2x3E = {  "_ZN3ccc5EE2x3E", // class name
  bases__ZN3ccc5EE2x3E, 1,
  &(vtc__ZN3ccc5EE2x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x3E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x4  : virtual ::ccc::AA2 {
  virtual void  pqr(); // _ZN3ccc5EE2x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE2x43abcEv
  virtual void  efg(); // _ZN3ccc5EE2x43efgEv
  ~EE2x4(); // tgen
  EE2x4(); // tgen
};
//SIG(1 _ZN3ccc5EE2x4E) C1{ VBC2{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE2x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x43pqrEv");}
void  ccc::EE2x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x43abcEv");}
void  ccc::EE2x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x43efgEv");}
ccc::EE2x4 ::~EE2x4(){ note_dtor("_ZN3ccc5EE2x4E", this);} // tgen
ccc::EE2x4 ::EE2x4(){ note_ctor("_ZN3ccc5EE2x4E", this);} // tgen
}
static void Test__ZN3ccc5EE2x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x4E, buf);
    ::ccc::EE2x4 *dp, &lv = *(dp=new (buf) ::ccc::EE2x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x4E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x4E);
    dp->::ccc::EE2x4::~EE2x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x4E(Test__ZN3ccc5EE2x4E, "_ZN3ccc5EE2x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x4C1Ev();
extern void _ZN3ccc5EE2x4D1Ev();
Name_Map name_map__ZN3ccc5EE2x4E[] = {
  NSPAIR(_ZN3ccc5EE2x4C1Ev),
  NSPAIR(_ZN3ccc5EE2x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x4E[];
extern void _ZN3ccc5EE2x43efgEv();
extern void _ZN3ccc5EE2x43abcEv();
extern void _ZN3ccc5EE2x43pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x43pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x4E[] = {
  {&(_ZTVN3ccc5EE2x4E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x4E[];
Class_Descriptor cd__ZN3ccc5EE2x4E = {  "_ZN3ccc5EE2x4E", // class name
  bases__ZN3ccc5EE2x4E, 1,
  &(vtc__ZN3ccc5EE2x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x4E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x5  : virtual ::ccc::AA2 {
  virtual void  pqr(); // _ZN3ccc5EE2x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE2x53efgEv
  virtual void  abc(); // _ZN3ccc5EE2x53abcEv
  ~EE2x5(); // tgen
  EE2x5(); // tgen
};
//SIG(1 _ZN3ccc5EE2x5E) C1{ VBC2{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE2x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x53pqrEv");}
void  ccc::EE2x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x53efgEv");}
void  ccc::EE2x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x53abcEv");}
ccc::EE2x5 ::~EE2x5(){ note_dtor("_ZN3ccc5EE2x5E", this);} // tgen
ccc::EE2x5 ::EE2x5(){ note_ctor("_ZN3ccc5EE2x5E", this);} // tgen
}
static void Test__ZN3ccc5EE2x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x5E, buf);
    ::ccc::EE2x5 *dp, &lv = *(dp=new (buf) ::ccc::EE2x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x5E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x5E);
    dp->::ccc::EE2x5::~EE2x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x5E(Test__ZN3ccc5EE2x5E, "_ZN3ccc5EE2x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x5C1Ev();
extern void _ZN3ccc5EE2x5D1Ev();
Name_Map name_map__ZN3ccc5EE2x5E[] = {
  NSPAIR(_ZN3ccc5EE2x5C1Ev),
  NSPAIR(_ZN3ccc5EE2x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x5E[];
extern void _ZN3ccc5EE2x53efgEv();
extern void _ZN3ccc5EE2x53abcEv();
extern void _ZN3ccc5EE2x53pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x53pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x5E[] = {
  {&(_ZTVN3ccc5EE2x5E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x5E[];
Class_Descriptor cd__ZN3ccc5EE2x5E = {  "_ZN3ccc5EE2x5E", // class name
  bases__ZN3ccc5EE2x5E, 1,
  &(vtc__ZN3ccc5EE2x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x5E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x6  : virtual ::ccc::AA2 {
  virtual void  abc(); // _ZN3ccc5EE2x63abcEv
  virtual void  efg(); // _ZN3ccc5EE2x63efgEv
  ~EE2x6(); // tgen
  EE2x6(); // tgen
};
//SIG(1 _ZN3ccc5EE2x6E) C1{ VBC2{ v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE2x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x63abcEv");}
void  ccc::EE2x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x63efgEv");}
ccc::EE2x6 ::~EE2x6(){ note_dtor("_ZN3ccc5EE2x6E", this);} // tgen
ccc::EE2x6 ::EE2x6(){ note_ctor("_ZN3ccc5EE2x6E", this);} // tgen
}
static void Test__ZN3ccc5EE2x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x6E, buf);
    ::ccc::EE2x6 *dp, &lv = *(dp=new (buf) ::ccc::EE2x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x6E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x6E);
    dp->::ccc::EE2x6::~EE2x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x6E(Test__ZN3ccc5EE2x6E, "_ZN3ccc5EE2x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x6C1Ev();
extern void _ZN3ccc5EE2x6D1Ev();
Name_Map name_map__ZN3ccc5EE2x6E[] = {
  NSPAIR(_ZN3ccc5EE2x6C1Ev),
  NSPAIR(_ZN3ccc5EE2x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x6E[];
extern void _ZN3ccc5EE2x63efgEv();
extern void _ZN3ccc5EE2x63abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x6E[] = {
  {&(_ZTVN3ccc5EE2x6E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x6E[];
Class_Descriptor cd__ZN3ccc5EE2x6E = {  "_ZN3ccc5EE2x6E", // class name
  bases__ZN3ccc5EE2x6E, 1,
  &(vtc__ZN3ccc5EE2x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x6E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x7  : virtual ::ccc::AA2 {
  virtual void  abc(); // _ZN3ccc5EE2x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE2x73pqrEv
  ~EE2x7(); // tgen
  EE2x7(); // tgen
};
//SIG(1 _ZN3ccc5EE2x7E) C1{ VBC2{ v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE2x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x73abcEv");}
void  ccc::EE2x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x73pqrEv");}
ccc::EE2x7 ::~EE2x7(){ note_dtor("_ZN3ccc5EE2x7E", this);} // tgen
ccc::EE2x7 ::EE2x7(){ note_ctor("_ZN3ccc5EE2x7E", this);} // tgen
}
static void Test__ZN3ccc5EE2x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x7E, buf);
    ::ccc::EE2x7 *dp, &lv = *(dp=new (buf) ::ccc::EE2x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x7E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x7E);
    dp->::ccc::EE2x7::~EE2x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x7E(Test__ZN3ccc5EE2x7E, "_ZN3ccc5EE2x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x7C1Ev();
extern void _ZN3ccc5EE2x7D1Ev();
Name_Map name_map__ZN3ccc5EE2x7E[] = {
  NSPAIR(_ZN3ccc5EE2x7C1Ev),
  NSPAIR(_ZN3ccc5EE2x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x7E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc5EE2x73abcEv();
extern void _ZN3ccc5EE2x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x7E[] = {
  {&(_ZTVN3ccc5EE2x7E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x7E[];
Class_Descriptor cd__ZN3ccc5EE2x7E = {  "_ZN3ccc5EE2x7E", // class name
  bases__ZN3ccc5EE2x7E, 1,
  &(vtc__ZN3ccc5EE2x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x7E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x8  : virtual ::ccc::AA2 {
  virtual void  efg(); // _ZN3ccc5EE2x83efgEv
  virtual void  abc(); // _ZN3ccc5EE2x83abcEv
  ~EE2x8(); // tgen
  EE2x8(); // tgen
};
//SIG(1 _ZN3ccc5EE2x8E) C1{ VBC2{ v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE2x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x83efgEv");}
void  ccc::EE2x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE2x83abcEv");}
ccc::EE2x8 ::~EE2x8(){ note_dtor("_ZN3ccc5EE2x8E", this);} // tgen
ccc::EE2x8 ::EE2x8(){ note_ctor("_ZN3ccc5EE2x8E", this);} // tgen
}
static void Test__ZN3ccc5EE2x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x8E, buf);
    ::ccc::EE2x8 *dp, &lv = *(dp=new (buf) ::ccc::EE2x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x8E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x8E);
    dp->::ccc::EE2x8::~EE2x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x8E(Test__ZN3ccc5EE2x8E, "_ZN3ccc5EE2x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x8C1Ev();
extern void _ZN3ccc5EE2x8D1Ev();
Name_Map name_map__ZN3ccc5EE2x8E[] = {
  NSPAIR(_ZN3ccc5EE2x8C1Ev),
  NSPAIR(_ZN3ccc5EE2x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x8E[];
extern void _ZN3ccc5EE2x83efgEv();
extern void _ZN3ccc5EE2x83abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x8E[] = {
  {&(_ZTVN3ccc5EE2x8E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x8E[];
Class_Descriptor cd__ZN3ccc5EE2x8E = {  "_ZN3ccc5EE2x8E", // class name
  bases__ZN3ccc5EE2x8E, 1,
  &(vtc__ZN3ccc5EE2x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x8E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x9  : virtual ::ccc::AA2 {
  virtual void  efg(); // _ZN3ccc5EE2x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE2x93pqrEv
  ~EE2x9(); // tgen
  EE2x9(); // tgen
};
//SIG(1 _ZN3ccc5EE2x9E) C1{ VBC2{ v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE2x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE2x93efgEv");}
void  ccc::EE2x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE2x93pqrEv");}
ccc::EE2x9 ::~EE2x9(){ note_dtor("_ZN3ccc5EE2x9E", this);} // tgen
ccc::EE2x9 ::EE2x9(){ note_ctor("_ZN3ccc5EE2x9E", this);} // tgen
}
static void Test__ZN3ccc5EE2x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE2x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE2x9E, buf);
    ::ccc::EE2x9 *dp, &lv = *(dp=new (buf) ::ccc::EE2x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE2x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE2x9E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc5EE2x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE2x9E);
    dp->::ccc::EE2x9::~EE2x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE2x9E(Test__ZN3ccc5EE2x9E, "_ZN3ccc5EE2x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE2x9C1Ev();
extern void _ZN3ccc5EE2x9D1Ev();
Name_Map name_map__ZN3ccc5EE2x9E[] = {
  NSPAIR(_ZN3ccc5EE2x9C1Ev),
  NSPAIR(_ZN3ccc5EE2x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc5EE2x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE2x9E[];
extern void _ZN3ccc5EE2x93efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc5EE2x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE2x9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE2x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE2x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE2x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE2x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE2x9E[] = {
  {&(_ZTVN3ccc5EE2x9E[6]),  6,9},
  {&(_ZTVN3ccc5EE2x9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE2x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE2x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE2x9E[];
Class_Descriptor cd__ZN3ccc5EE2x9E = {  "_ZN3ccc5EE2x9E", // class name
  bases__ZN3ccc5EE2x9E, 1,
  &(vtc__ZN3ccc5EE2x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE2x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE2x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE2x9E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE2x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x10  : virtual ::ccc::AA2 {
  virtual void  pqr(); // _ZN3ccc6EE2x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE2x103abcEv
  ~EE2x10(); // tgen
  EE2x10(); // tgen
};
//SIG(1 _ZN3ccc6EE2x10E) C1{ VBC2{ v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE2x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE2x103pqrEv");}
void  ccc::EE2x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE2x103abcEv");}
ccc::EE2x10 ::~EE2x10(){ note_dtor("_ZN3ccc6EE2x10E", this);} // tgen
ccc::EE2x10 ::EE2x10(){ note_ctor("_ZN3ccc6EE2x10E", this);} // tgen
}
static void Test__ZN3ccc6EE2x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE2x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE2x10E, buf);
    ::ccc::EE2x10 *dp, &lv = *(dp=new (buf) ::ccc::EE2x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE2x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE2x10E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc6EE2x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE2x10E);
    dp->::ccc::EE2x10::~EE2x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE2x10E(Test__ZN3ccc6EE2x10E, "_ZN3ccc6EE2x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE2x10C1Ev();
extern void _ZN3ccc6EE2x10D1Ev();
Name_Map name_map__ZN3ccc6EE2x10E[] = {
  NSPAIR(_ZN3ccc6EE2x10C1Ev),
  NSPAIR(_ZN3ccc6EE2x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc6EE2x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE2x10E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc6EE2x103abcEv();
extern void _ZN3ccc6EE2x103pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE2x10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE2x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE2x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE2x103pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE2x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE2x10E[] = {
  {&(_ZTVN3ccc6EE2x10E[6]),  6,9},
  {&(_ZTVN3ccc6EE2x10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE2x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE2x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE2x10E[];
Class_Descriptor cd__ZN3ccc6EE2x10E = {  "_ZN3ccc6EE2x10E", // class name
  bases__ZN3ccc6EE2x10E, 1,
  &(vtc__ZN3ccc6EE2x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE2x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE2x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE2x10E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE2x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x11  : virtual ::ccc::AA2 {
  virtual void  pqr(); // _ZN3ccc6EE2x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE2x113efgEv
  ~EE2x11(); // tgen
  EE2x11(); // tgen
};
//SIG(1 _ZN3ccc6EE2x11E) C1{ VBC2{ v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE2x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE2x113pqrEv");}
void  ccc::EE2x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE2x113efgEv");}
ccc::EE2x11 ::~EE2x11(){ note_dtor("_ZN3ccc6EE2x11E", this);} // tgen
ccc::EE2x11 ::EE2x11(){ note_ctor("_ZN3ccc6EE2x11E", this);} // tgen
}
static void Test__ZN3ccc6EE2x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE2x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE2x11E, buf);
    ::ccc::EE2x11 *dp, &lv = *(dp=new (buf) ::ccc::EE2x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE2x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE2x11E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc6EE2x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE2x11E);
    dp->::ccc::EE2x11::~EE2x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE2x11E(Test__ZN3ccc6EE2x11E, "_ZN3ccc6EE2x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE2x11C1Ev();
extern void _ZN3ccc6EE2x11D1Ev();
Name_Map name_map__ZN3ccc6EE2x11E[] = {
  NSPAIR(_ZN3ccc6EE2x11C1Ev),
  NSPAIR(_ZN3ccc6EE2x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc6EE2x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE2x11E[];
extern void _ZN3ccc6EE2x113efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc6EE2x113pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE2x11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE2x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE2x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE2x113pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE2x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE2x11E[] = {
  {&(_ZTVN3ccc6EE2x11E[6]),  6,9},
  {&(_ZTVN3ccc6EE2x11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE2x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE2x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE2x11E[];
Class_Descriptor cd__ZN3ccc6EE2x11E = {  "_ZN3ccc6EE2x11E", // class name
  bases__ZN3ccc6EE2x11E, 1,
  &(vtc__ZN3ccc6EE2x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE2x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE2x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE2x11E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE2x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x12  : virtual ::ccc::AA2 {
  virtual void  abc(); // _ZN3ccc6EE2x123abcEv
  ~EE2x12(); // tgen
  EE2x12(); // tgen
};
//SIG(1 _ZN3ccc6EE2x12E) C1{ VBC2{ v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::EE2x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE2x123abcEv");}
ccc::EE2x12 ::~EE2x12(){ note_dtor("_ZN3ccc6EE2x12E", this);} // tgen
ccc::EE2x12 ::EE2x12(){ note_ctor("_ZN3ccc6EE2x12E", this);} // tgen
}
static void Test__ZN3ccc6EE2x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE2x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE2x12E, buf);
    ::ccc::EE2x12 *dp, &lv = *(dp=new (buf) ::ccc::EE2x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE2x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE2x12E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc6EE2x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE2x12E);
    dp->::ccc::EE2x12::~EE2x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE2x12E(Test__ZN3ccc6EE2x12E, "_ZN3ccc6EE2x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE2x12C1Ev();
extern void _ZN3ccc6EE2x12D1Ev();
Name_Map name_map__ZN3ccc6EE2x12E[] = {
  NSPAIR(_ZN3ccc6EE2x12C1Ev),
  NSPAIR(_ZN3ccc6EE2x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc6EE2x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE2x12E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc6EE2x123abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE2x12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE2x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE2x123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE2x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE2x12E[] = {
  {&(_ZTVN3ccc6EE2x12E[6]),  6,9},
  {&(_ZTVN3ccc6EE2x12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE2x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE2x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE2x12E[];
Class_Descriptor cd__ZN3ccc6EE2x12E = {  "_ZN3ccc6EE2x12E", // class name
  bases__ZN3ccc6EE2x12E, 1,
  &(vtc__ZN3ccc6EE2x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE2x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE2x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE2x12E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE2x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x13  : virtual ::ccc::AA2 {
  virtual void  efg(); // _ZN3ccc6EE2x133efgEv
  ~EE2x13(); // tgen
  EE2x13(); // tgen
};
//SIG(1 _ZN3ccc6EE2x13E) C1{ VBC2{ v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::EE2x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE2x133efgEv");}
ccc::EE2x13 ::~EE2x13(){ note_dtor("_ZN3ccc6EE2x13E", this);} // tgen
ccc::EE2x13 ::EE2x13(){ note_ctor("_ZN3ccc6EE2x13E", this);} // tgen
}
static void Test__ZN3ccc6EE2x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE2x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE2x13E, buf);
    ::ccc::EE2x13 *dp, &lv = *(dp=new (buf) ::ccc::EE2x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE2x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE2x13E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc6EE2x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE2x13E);
    dp->::ccc::EE2x13::~EE2x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE2x13E(Test__ZN3ccc6EE2x13E, "_ZN3ccc6EE2x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE2x13C1Ev();
extern void _ZN3ccc6EE2x13D1Ev();
Name_Map name_map__ZN3ccc6EE2x13E[] = {
  NSPAIR(_ZN3ccc6EE2x13C1Ev),
  NSPAIR(_ZN3ccc6EE2x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc6EE2x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE2x13E[];
extern void _ZN3ccc6EE2x133efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE2x13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE2x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE2x133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE2x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE2x13E[] = {
  {&(_ZTVN3ccc6EE2x13E[6]),  6,9},
  {&(_ZTVN3ccc6EE2x13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE2x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE2x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE2x13E[];
Class_Descriptor cd__ZN3ccc6EE2x13E = {  "_ZN3ccc6EE2x13E", // class name
  bases__ZN3ccc6EE2x13E, 1,
  &(vtc__ZN3ccc6EE2x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE2x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE2x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE2x13E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE2x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x14  : virtual ::ccc::AA2 {
  virtual void  pqr(); // _ZN3ccc6EE2x143pqrEv
  ~EE2x14(); // tgen
  EE2x14(); // tgen
};
//SIG(1 _ZN3ccc6EE2x14E) C1{ VBC2{ v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::EE2x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE2x143pqrEv");}
ccc::EE2x14 ::~EE2x14(){ note_dtor("_ZN3ccc6EE2x14E", this);} // tgen
ccc::EE2x14 ::EE2x14(){ note_ctor("_ZN3ccc6EE2x14E", this);} // tgen
}
static void Test__ZN3ccc6EE2x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE2x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE2x14E, buf);
    ::ccc::EE2x14 *dp, &lv = *(dp=new (buf) ::ccc::EE2x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE2x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE2x14E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc6EE2x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE2x14E);
    dp->::ccc::EE2x14::~EE2x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE2x14E(Test__ZN3ccc6EE2x14E, "_ZN3ccc6EE2x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE2x14C1Ev();
extern void _ZN3ccc6EE2x14D1Ev();
Name_Map name_map__ZN3ccc6EE2x14E[] = {
  NSPAIR(_ZN3ccc6EE2x14C1Ev),
  NSPAIR(_ZN3ccc6EE2x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc6EE2x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE2x14E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc6EE2x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE2x14E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE2x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE2x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE2x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE2x14E[] = {
  {&(_ZTVN3ccc6EE2x14E[6]),  6,9},
  {&(_ZTVN3ccc6EE2x14E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE2x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE2x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE2x14E[];
Class_Descriptor cd__ZN3ccc6EE2x14E = {  "_ZN3ccc6EE2x14E", // class name
  bases__ZN3ccc6EE2x14E, 1,
  &(vtc__ZN3ccc6EE2x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE2x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE2x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE2x14E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE2x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE2x15  : virtual ::ccc::AA2 {
  ~EE2x15(); // tgen
  EE2x15(); // tgen
};
//SIG(1 _ZN3ccc6EE2x15E) C1{ VBC2{ v1 v2 v3}}
}
namespace ccc { 
ccc::EE2x15 ::~EE2x15(){ note_dtor("_ZN3ccc6EE2x15E", this);} // tgen
ccc::EE2x15 ::EE2x15(){ note_ctor("_ZN3ccc6EE2x15E", this);} // tgen
}
static void Test__ZN3ccc6EE2x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE2x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE2x15E, buf);
    ::ccc::EE2x15 *dp, &lv = *(dp=new (buf) ::ccc::EE2x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE2x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE2x15E)");
    check_base_class_offset(lv, (::ccc::AA2*), 0, "_ZN3ccc6EE2x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE2x15E);
    dp->::ccc::EE2x15::~EE2x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE2x15E(Test__ZN3ccc6EE2x15E, "_ZN3ccc6EE2x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE2x15C1Ev();
extern void _ZN3ccc6EE2x15D1Ev();
Name_Map name_map__ZN3ccc6EE2x15E[] = {
  NSPAIR(_ZN3ccc6EE2x15C1Ev),
  NSPAIR(_ZN3ccc6EE2x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA2E;
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
static Base_Class bases__ZN3ccc6EE2x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE2x15E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE2x15E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE2x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE2x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE2x15E[] = {
  {&(_ZTVN3ccc6EE2x15E[6]),  6,9},
  {&(_ZTVN3ccc6EE2x15E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE2x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE2x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE2x15E[];
Class_Descriptor cd__ZN3ccc6EE2x15E = {  "_ZN3ccc6EE2x15E", // class name
  bases__ZN3ccc6EE2x15E, 1,
  &(vtc__ZN3ccc6EE2x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE2x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE2x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE2x15E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE2x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA3  {
  virtual void  efg(); // _ZN3ccc3AA33efgEv
  virtual void  pqr(); // _ZN3ccc3AA33pqrEv
  virtual void  abc(); // _ZN3ccc3AA33abcEv
  ~AA3(); // tgen
  AA3(); // tgen
};
//SIG(-1 _ZN3ccc3AA3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA3 ::efg(){vfunc_called(this, "_ZN3ccc3AA33efgEv");}
void  ccc::AA3 ::pqr(){vfunc_called(this, "_ZN3ccc3AA33pqrEv");}
void  ccc::AA3 ::abc(){vfunc_called(this, "_ZN3ccc3AA33abcEv");}
ccc::AA3 ::~AA3(){ note_dtor("_ZN3ccc3AA3E", this);} // tgen
ccc::AA3 ::AA3(){ note_ctor("_ZN3ccc3AA3E", this);} // tgen
}
static void Test__ZN3ccc3AA3E()
{
  extern Class_Descriptor cd__ZN3ccc3AA3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA3E, buf);
    ::ccc::AA3 *dp, &lv = *(dp=new (buf) ::ccc::AA3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA3E)");
    test_class_info(&lv, &cd__ZN3ccc3AA3E);
    dp->::ccc::AA3::~AA3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA3E(Test__ZN3ccc3AA3E, "_ZN3ccc3AA3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA3C1Ev();
extern void _ZN3ccc3AA3D1Ev();
Name_Map name_map__ZN3ccc3AA3E[] = {
  NSPAIR(_ZN3ccc3AA3C1Ev),
  NSPAIR(_ZN3ccc3AA3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
Class_Descriptor cd__ZN3ccc3AA3E = {  "_ZN3ccc3AA3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB3  {
  virtual void  efg(); // _ZN3ccc3BB33efgEv
  virtual void  pqr(); // _ZN3ccc3BB33pqrEv
  virtual void  abc(); // _ZN3ccc3BB33abcEv
  ~BB3(); // tgen
  BB3(); // tgen
};
//SIG(1 _ZN3ccc3BB3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB3 ::efg(){vfunc_called(this, "_ZN3ccc3BB33efgEv");}
void  ccc::BB3 ::pqr(){vfunc_called(this, "_ZN3ccc3BB33pqrEv");}
void  ccc::BB3 ::abc(){vfunc_called(this, "_ZN3ccc3BB33abcEv");}
ccc::BB3 ::~BB3(){ note_dtor("_ZN3ccc3BB3E", this);} // tgen
ccc::BB3 ::BB3(){ note_ctor("_ZN3ccc3BB3E", this);} // tgen
}
static void Test__ZN3ccc3BB3E()
{
  extern Class_Descriptor cd__ZN3ccc3BB3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB3E, buf);
    ::ccc::BB3 *dp, &lv = *(dp=new (buf) ::ccc::BB3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB3E)");
    test_class_info(&lv, &cd__ZN3ccc3BB3E);
    dp->::ccc::BB3::~BB3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB3E(Test__ZN3ccc3BB3E, "_ZN3ccc3BB3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB3C1Ev();
extern void _ZN3ccc3BB3D1Ev();
Name_Map name_map__ZN3ccc3BB3E[] = {
  NSPAIR(_ZN3ccc3BB3C1Ev),
  NSPAIR(_ZN3ccc3BB3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
Class_Descriptor cd__ZN3ccc3BB3E = {  "_ZN3ccc3BB3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x0  : virtual ::ccc::AA3 {
  virtual void  abc(); // _ZN3ccc5EE3x03abcEv
  virtual void  efg(); // _ZN3ccc5EE3x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE3x03pqrEv
  ~EE3x0(); // tgen
  EE3x0(); // tgen
};
//SIG(1 _ZN3ccc5EE3x0E) C1{ VBC2{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE3x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x03abcEv");}
void  ccc::EE3x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x03efgEv");}
void  ccc::EE3x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x03pqrEv");}
ccc::EE3x0 ::~EE3x0(){ note_dtor("_ZN3ccc5EE3x0E", this);} // tgen
ccc::EE3x0 ::EE3x0(){ note_ctor("_ZN3ccc5EE3x0E", this);} // tgen
}
static void Test__ZN3ccc5EE3x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x0E, buf);
    ::ccc::EE3x0 *dp, &lv = *(dp=new (buf) ::ccc::EE3x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x0E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x0E);
    dp->::ccc::EE3x0::~EE3x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x0E(Test__ZN3ccc5EE3x0E, "_ZN3ccc5EE3x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x0C1Ev();
extern void _ZN3ccc5EE3x0D1Ev();
Name_Map name_map__ZN3ccc5EE3x0E[] = {
  NSPAIR(_ZN3ccc5EE3x0C1Ev),
  NSPAIR(_ZN3ccc5EE3x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x0E[];
extern void _ZN3ccc5EE3x03efgEv();
extern void _ZN3ccc5EE3x03pqrEv();
extern void _ZN3ccc5EE3x03abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x03abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x0E[] = {
  {&(_ZTVN3ccc5EE3x0E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x0E[];
Class_Descriptor cd__ZN3ccc5EE3x0E = {  "_ZN3ccc5EE3x0E", // class name
  bases__ZN3ccc5EE3x0E, 1,
  &(vtc__ZN3ccc5EE3x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x0E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x1  : virtual ::ccc::AA3 {
  virtual void  abc(); // _ZN3ccc5EE3x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE3x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE3x13efgEv
  ~EE3x1(); // tgen
  EE3x1(); // tgen
};
//SIG(1 _ZN3ccc5EE3x1E) C1{ VBC2{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE3x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x13abcEv");}
void  ccc::EE3x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x13pqrEv");}
void  ccc::EE3x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x13efgEv");}
ccc::EE3x1 ::~EE3x1(){ note_dtor("_ZN3ccc5EE3x1E", this);} // tgen
ccc::EE3x1 ::EE3x1(){ note_ctor("_ZN3ccc5EE3x1E", this);} // tgen
}
static void Test__ZN3ccc5EE3x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x1E, buf);
    ::ccc::EE3x1 *dp, &lv = *(dp=new (buf) ::ccc::EE3x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x1E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x1E);
    dp->::ccc::EE3x1::~EE3x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x1E(Test__ZN3ccc5EE3x1E, "_ZN3ccc5EE3x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x1C1Ev();
extern void _ZN3ccc5EE3x1D1Ev();
Name_Map name_map__ZN3ccc5EE3x1E[] = {
  NSPAIR(_ZN3ccc5EE3x1C1Ev),
  NSPAIR(_ZN3ccc5EE3x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x1E[];
extern void _ZN3ccc5EE3x13efgEv();
extern void _ZN3ccc5EE3x13pqrEv();
extern void _ZN3ccc5EE3x13abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x13abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x1E[] = {
  {&(_ZTVN3ccc5EE3x1E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x1E[];
Class_Descriptor cd__ZN3ccc5EE3x1E = {  "_ZN3ccc5EE3x1E", // class name
  bases__ZN3ccc5EE3x1E, 1,
  &(vtc__ZN3ccc5EE3x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x1E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x2  : virtual ::ccc::AA3 {
  virtual void  efg(); // _ZN3ccc5EE3x23efgEv
  virtual void  abc(); // _ZN3ccc5EE3x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE3x23pqrEv
  ~EE3x2(); // tgen
  EE3x2(); // tgen
};
//SIG(1 _ZN3ccc5EE3x2E) C1{ VBC2{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE3x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x23efgEv");}
void  ccc::EE3x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x23abcEv");}
void  ccc::EE3x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x23pqrEv");}
ccc::EE3x2 ::~EE3x2(){ note_dtor("_ZN3ccc5EE3x2E", this);} // tgen
ccc::EE3x2 ::EE3x2(){ note_ctor("_ZN3ccc5EE3x2E", this);} // tgen
}
static void Test__ZN3ccc5EE3x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x2E, buf);
    ::ccc::EE3x2 *dp, &lv = *(dp=new (buf) ::ccc::EE3x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x2E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x2E);
    dp->::ccc::EE3x2::~EE3x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x2E(Test__ZN3ccc5EE3x2E, "_ZN3ccc5EE3x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x2C1Ev();
extern void _ZN3ccc5EE3x2D1Ev();
Name_Map name_map__ZN3ccc5EE3x2E[] = {
  NSPAIR(_ZN3ccc5EE3x2C1Ev),
  NSPAIR(_ZN3ccc5EE3x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x2E[];
extern void _ZN3ccc5EE3x23efgEv();
extern void _ZN3ccc5EE3x23pqrEv();
extern void _ZN3ccc5EE3x23abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x23abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x2E[] = {
  {&(_ZTVN3ccc5EE3x2E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x2E[];
Class_Descriptor cd__ZN3ccc5EE3x2E = {  "_ZN3ccc5EE3x2E", // class name
  bases__ZN3ccc5EE3x2E, 1,
  &(vtc__ZN3ccc5EE3x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x2E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x3  : virtual ::ccc::AA3 {
  virtual void  efg(); // _ZN3ccc5EE3x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE3x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE3x33abcEv
  ~EE3x3(); // tgen
  EE3x3(); // tgen
};
//SIG(1 _ZN3ccc5EE3x3E) C1{ VBC2{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE3x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x33efgEv");}
void  ccc::EE3x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x33pqrEv");}
void  ccc::EE3x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x33abcEv");}
ccc::EE3x3 ::~EE3x3(){ note_dtor("_ZN3ccc5EE3x3E", this);} // tgen
ccc::EE3x3 ::EE3x3(){ note_ctor("_ZN3ccc5EE3x3E", this);} // tgen
}
static void Test__ZN3ccc5EE3x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x3E, buf);
    ::ccc::EE3x3 *dp, &lv = *(dp=new (buf) ::ccc::EE3x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x3E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x3E);
    dp->::ccc::EE3x3::~EE3x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x3E(Test__ZN3ccc5EE3x3E, "_ZN3ccc5EE3x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x3C1Ev();
extern void _ZN3ccc5EE3x3D1Ev();
Name_Map name_map__ZN3ccc5EE3x3E[] = {
  NSPAIR(_ZN3ccc5EE3x3C1Ev),
  NSPAIR(_ZN3ccc5EE3x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x3E[];
extern void _ZN3ccc5EE3x33efgEv();
extern void _ZN3ccc5EE3x33pqrEv();
extern void _ZN3ccc5EE3x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x3E[] = {
  {&(_ZTVN3ccc5EE3x3E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x3E[];
Class_Descriptor cd__ZN3ccc5EE3x3E = {  "_ZN3ccc5EE3x3E", // class name
  bases__ZN3ccc5EE3x3E, 1,
  &(vtc__ZN3ccc5EE3x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x3E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x4  : virtual ::ccc::AA3 {
  virtual void  pqr(); // _ZN3ccc5EE3x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE3x43abcEv
  virtual void  efg(); // _ZN3ccc5EE3x43efgEv
  ~EE3x4(); // tgen
  EE3x4(); // tgen
};
//SIG(1 _ZN3ccc5EE3x4E) C1{ VBC2{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE3x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x43pqrEv");}
void  ccc::EE3x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x43abcEv");}
void  ccc::EE3x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x43efgEv");}
ccc::EE3x4 ::~EE3x4(){ note_dtor("_ZN3ccc5EE3x4E", this);} // tgen
ccc::EE3x4 ::EE3x4(){ note_ctor("_ZN3ccc5EE3x4E", this);} // tgen
}
static void Test__ZN3ccc5EE3x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x4E, buf);
    ::ccc::EE3x4 *dp, &lv = *(dp=new (buf) ::ccc::EE3x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x4E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x4E);
    dp->::ccc::EE3x4::~EE3x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x4E(Test__ZN3ccc5EE3x4E, "_ZN3ccc5EE3x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x4C1Ev();
extern void _ZN3ccc5EE3x4D1Ev();
Name_Map name_map__ZN3ccc5EE3x4E[] = {
  NSPAIR(_ZN3ccc5EE3x4C1Ev),
  NSPAIR(_ZN3ccc5EE3x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x4E[];
extern void _ZN3ccc5EE3x43efgEv();
extern void _ZN3ccc5EE3x43pqrEv();
extern void _ZN3ccc5EE3x43abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x43abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x4E[] = {
  {&(_ZTVN3ccc5EE3x4E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x4E[];
Class_Descriptor cd__ZN3ccc5EE3x4E = {  "_ZN3ccc5EE3x4E", // class name
  bases__ZN3ccc5EE3x4E, 1,
  &(vtc__ZN3ccc5EE3x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x4E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x5  : virtual ::ccc::AA3 {
  virtual void  pqr(); // _ZN3ccc5EE3x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE3x53efgEv
  virtual void  abc(); // _ZN3ccc5EE3x53abcEv
  ~EE3x5(); // tgen
  EE3x5(); // tgen
};
//SIG(1 _ZN3ccc5EE3x5E) C1{ VBC2{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE3x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x53pqrEv");}
void  ccc::EE3x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x53efgEv");}
void  ccc::EE3x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x53abcEv");}
ccc::EE3x5 ::~EE3x5(){ note_dtor("_ZN3ccc5EE3x5E", this);} // tgen
ccc::EE3x5 ::EE3x5(){ note_ctor("_ZN3ccc5EE3x5E", this);} // tgen
}
static void Test__ZN3ccc5EE3x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x5E, buf);
    ::ccc::EE3x5 *dp, &lv = *(dp=new (buf) ::ccc::EE3x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x5E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x5E);
    dp->::ccc::EE3x5::~EE3x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x5E(Test__ZN3ccc5EE3x5E, "_ZN3ccc5EE3x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x5C1Ev();
extern void _ZN3ccc5EE3x5D1Ev();
Name_Map name_map__ZN3ccc5EE3x5E[] = {
  NSPAIR(_ZN3ccc5EE3x5C1Ev),
  NSPAIR(_ZN3ccc5EE3x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x5E[];
extern void _ZN3ccc5EE3x53efgEv();
extern void _ZN3ccc5EE3x53pqrEv();
extern void _ZN3ccc5EE3x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x5E[] = {
  {&(_ZTVN3ccc5EE3x5E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x5E[];
Class_Descriptor cd__ZN3ccc5EE3x5E = {  "_ZN3ccc5EE3x5E", // class name
  bases__ZN3ccc5EE3x5E, 1,
  &(vtc__ZN3ccc5EE3x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x5E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x6  : virtual ::ccc::AA3 {
  virtual void  abc(); // _ZN3ccc5EE3x63abcEv
  virtual void  efg(); // _ZN3ccc5EE3x63efgEv
  ~EE3x6(); // tgen
  EE3x6(); // tgen
};
//SIG(1 _ZN3ccc5EE3x6E) C1{ VBC2{ v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE3x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x63abcEv");}
void  ccc::EE3x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x63efgEv");}
ccc::EE3x6 ::~EE3x6(){ note_dtor("_ZN3ccc5EE3x6E", this);} // tgen
ccc::EE3x6 ::EE3x6(){ note_ctor("_ZN3ccc5EE3x6E", this);} // tgen
}
static void Test__ZN3ccc5EE3x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x6E, buf);
    ::ccc::EE3x6 *dp, &lv = *(dp=new (buf) ::ccc::EE3x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x6E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x6E);
    dp->::ccc::EE3x6::~EE3x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x6E(Test__ZN3ccc5EE3x6E, "_ZN3ccc5EE3x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x6C1Ev();
extern void _ZN3ccc5EE3x6D1Ev();
Name_Map name_map__ZN3ccc5EE3x6E[] = {
  NSPAIR(_ZN3ccc5EE3x6C1Ev),
  NSPAIR(_ZN3ccc5EE3x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x6E[];
extern void _ZN3ccc5EE3x63efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc5EE3x63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x6E[] = {
  {&(_ZTVN3ccc5EE3x6E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x6E[];
Class_Descriptor cd__ZN3ccc5EE3x6E = {  "_ZN3ccc5EE3x6E", // class name
  bases__ZN3ccc5EE3x6E, 1,
  &(vtc__ZN3ccc5EE3x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x6E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x7  : virtual ::ccc::AA3 {
  virtual void  abc(); // _ZN3ccc5EE3x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE3x73pqrEv
  ~EE3x7(); // tgen
  EE3x7(); // tgen
};
//SIG(1 _ZN3ccc5EE3x7E) C1{ VBC2{ v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE3x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x73abcEv");}
void  ccc::EE3x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x73pqrEv");}
ccc::EE3x7 ::~EE3x7(){ note_dtor("_ZN3ccc5EE3x7E", this);} // tgen
ccc::EE3x7 ::EE3x7(){ note_ctor("_ZN3ccc5EE3x7E", this);} // tgen
}
static void Test__ZN3ccc5EE3x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x7E, buf);
    ::ccc::EE3x7 *dp, &lv = *(dp=new (buf) ::ccc::EE3x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x7E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x7E);
    dp->::ccc::EE3x7::~EE3x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x7E(Test__ZN3ccc5EE3x7E, "_ZN3ccc5EE3x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x7C1Ev();
extern void _ZN3ccc5EE3x7D1Ev();
Name_Map name_map__ZN3ccc5EE3x7E[] = {
  NSPAIR(_ZN3ccc5EE3x7C1Ev),
  NSPAIR(_ZN3ccc5EE3x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x7E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc5EE3x73pqrEv();
extern void _ZN3ccc5EE3x73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x7E[] = {
  {&(_ZTVN3ccc5EE3x7E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x7E[];
Class_Descriptor cd__ZN3ccc5EE3x7E = {  "_ZN3ccc5EE3x7E", // class name
  bases__ZN3ccc5EE3x7E, 1,
  &(vtc__ZN3ccc5EE3x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x7E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x8  : virtual ::ccc::AA3 {
  virtual void  efg(); // _ZN3ccc5EE3x83efgEv
  virtual void  abc(); // _ZN3ccc5EE3x83abcEv
  ~EE3x8(); // tgen
  EE3x8(); // tgen
};
//SIG(1 _ZN3ccc5EE3x8E) C1{ VBC2{ v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE3x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x83efgEv");}
void  ccc::EE3x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE3x83abcEv");}
ccc::EE3x8 ::~EE3x8(){ note_dtor("_ZN3ccc5EE3x8E", this);} // tgen
ccc::EE3x8 ::EE3x8(){ note_ctor("_ZN3ccc5EE3x8E", this);} // tgen
}
static void Test__ZN3ccc5EE3x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x8E, buf);
    ::ccc::EE3x8 *dp, &lv = *(dp=new (buf) ::ccc::EE3x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x8E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x8E);
    dp->::ccc::EE3x8::~EE3x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x8E(Test__ZN3ccc5EE3x8E, "_ZN3ccc5EE3x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x8C1Ev();
extern void _ZN3ccc5EE3x8D1Ev();
Name_Map name_map__ZN3ccc5EE3x8E[] = {
  NSPAIR(_ZN3ccc5EE3x8C1Ev),
  NSPAIR(_ZN3ccc5EE3x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x8E[];
extern void _ZN3ccc5EE3x83efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc5EE3x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x8E[] = {
  {&(_ZTVN3ccc5EE3x8E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x8E[];
Class_Descriptor cd__ZN3ccc5EE3x8E = {  "_ZN3ccc5EE3x8E", // class name
  bases__ZN3ccc5EE3x8E, 1,
  &(vtc__ZN3ccc5EE3x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x8E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x9  : virtual ::ccc::AA3 {
  virtual void  efg(); // _ZN3ccc5EE3x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE3x93pqrEv
  ~EE3x9(); // tgen
  EE3x9(); // tgen
};
//SIG(1 _ZN3ccc5EE3x9E) C1{ VBC2{ v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE3x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE3x93efgEv");}
void  ccc::EE3x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE3x93pqrEv");}
ccc::EE3x9 ::~EE3x9(){ note_dtor("_ZN3ccc5EE3x9E", this);} // tgen
ccc::EE3x9 ::EE3x9(){ note_ctor("_ZN3ccc5EE3x9E", this);} // tgen
}
static void Test__ZN3ccc5EE3x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE3x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE3x9E, buf);
    ::ccc::EE3x9 *dp, &lv = *(dp=new (buf) ::ccc::EE3x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE3x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE3x9E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc5EE3x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE3x9E);
    dp->::ccc::EE3x9::~EE3x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE3x9E(Test__ZN3ccc5EE3x9E, "_ZN3ccc5EE3x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE3x9C1Ev();
extern void _ZN3ccc5EE3x9D1Ev();
Name_Map name_map__ZN3ccc5EE3x9E[] = {
  NSPAIR(_ZN3ccc5EE3x9C1Ev),
  NSPAIR(_ZN3ccc5EE3x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc5EE3x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE3x9E[];
extern void _ZN3ccc5EE3x93efgEv();
extern void _ZN3ccc5EE3x93pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE3x9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE3x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE3x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE3x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE3x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE3x9E[] = {
  {&(_ZTVN3ccc5EE3x9E[6]),  6,9},
  {&(_ZTVN3ccc5EE3x9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE3x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE3x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE3x9E[];
Class_Descriptor cd__ZN3ccc5EE3x9E = {  "_ZN3ccc5EE3x9E", // class name
  bases__ZN3ccc5EE3x9E, 1,
  &(vtc__ZN3ccc5EE3x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE3x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE3x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE3x9E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE3x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x10  : virtual ::ccc::AA3 {
  virtual void  pqr(); // _ZN3ccc6EE3x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE3x103abcEv
  ~EE3x10(); // tgen
  EE3x10(); // tgen
};
//SIG(1 _ZN3ccc6EE3x10E) C1{ VBC2{ v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE3x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE3x103pqrEv");}
void  ccc::EE3x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE3x103abcEv");}
ccc::EE3x10 ::~EE3x10(){ note_dtor("_ZN3ccc6EE3x10E", this);} // tgen
ccc::EE3x10 ::EE3x10(){ note_ctor("_ZN3ccc6EE3x10E", this);} // tgen
}
static void Test__ZN3ccc6EE3x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE3x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE3x10E, buf);
    ::ccc::EE3x10 *dp, &lv = *(dp=new (buf) ::ccc::EE3x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE3x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE3x10E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc6EE3x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE3x10E);
    dp->::ccc::EE3x10::~EE3x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE3x10E(Test__ZN3ccc6EE3x10E, "_ZN3ccc6EE3x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE3x10C1Ev();
extern void _ZN3ccc6EE3x10D1Ev();
Name_Map name_map__ZN3ccc6EE3x10E[] = {
  NSPAIR(_ZN3ccc6EE3x10C1Ev),
  NSPAIR(_ZN3ccc6EE3x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc6EE3x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE3x10E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc6EE3x103pqrEv();
extern void _ZN3ccc6EE3x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE3x10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE3x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE3x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE3x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE3x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE3x10E[] = {
  {&(_ZTVN3ccc6EE3x10E[6]),  6,9},
  {&(_ZTVN3ccc6EE3x10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE3x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE3x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE3x10E[];
Class_Descriptor cd__ZN3ccc6EE3x10E = {  "_ZN3ccc6EE3x10E", // class name
  bases__ZN3ccc6EE3x10E, 1,
  &(vtc__ZN3ccc6EE3x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE3x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE3x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE3x10E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE3x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x11  : virtual ::ccc::AA3 {
  virtual void  pqr(); // _ZN3ccc6EE3x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE3x113efgEv
  ~EE3x11(); // tgen
  EE3x11(); // tgen
};
//SIG(1 _ZN3ccc6EE3x11E) C1{ VBC2{ v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE3x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE3x113pqrEv");}
void  ccc::EE3x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE3x113efgEv");}
ccc::EE3x11 ::~EE3x11(){ note_dtor("_ZN3ccc6EE3x11E", this);} // tgen
ccc::EE3x11 ::EE3x11(){ note_ctor("_ZN3ccc6EE3x11E", this);} // tgen
}
static void Test__ZN3ccc6EE3x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE3x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE3x11E, buf);
    ::ccc::EE3x11 *dp, &lv = *(dp=new (buf) ::ccc::EE3x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE3x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE3x11E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc6EE3x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE3x11E);
    dp->::ccc::EE3x11::~EE3x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE3x11E(Test__ZN3ccc6EE3x11E, "_ZN3ccc6EE3x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE3x11C1Ev();
extern void _ZN3ccc6EE3x11D1Ev();
Name_Map name_map__ZN3ccc6EE3x11E[] = {
  NSPAIR(_ZN3ccc6EE3x11C1Ev),
  NSPAIR(_ZN3ccc6EE3x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc6EE3x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE3x11E[];
extern void _ZN3ccc6EE3x113efgEv();
extern void _ZN3ccc6EE3x113pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE3x11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE3x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE3x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE3x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE3x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE3x11E[] = {
  {&(_ZTVN3ccc6EE3x11E[6]),  6,9},
  {&(_ZTVN3ccc6EE3x11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE3x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE3x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE3x11E[];
Class_Descriptor cd__ZN3ccc6EE3x11E = {  "_ZN3ccc6EE3x11E", // class name
  bases__ZN3ccc6EE3x11E, 1,
  &(vtc__ZN3ccc6EE3x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE3x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE3x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE3x11E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE3x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x12  : virtual ::ccc::AA3 {
  virtual void  abc(); // _ZN3ccc6EE3x123abcEv
  ~EE3x12(); // tgen
  EE3x12(); // tgen
};
//SIG(1 _ZN3ccc6EE3x12E) C1{ VBC2{ v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::EE3x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE3x123abcEv");}
ccc::EE3x12 ::~EE3x12(){ note_dtor("_ZN3ccc6EE3x12E", this);} // tgen
ccc::EE3x12 ::EE3x12(){ note_ctor("_ZN3ccc6EE3x12E", this);} // tgen
}
static void Test__ZN3ccc6EE3x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE3x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE3x12E, buf);
    ::ccc::EE3x12 *dp, &lv = *(dp=new (buf) ::ccc::EE3x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE3x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE3x12E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc6EE3x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE3x12E);
    dp->::ccc::EE3x12::~EE3x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE3x12E(Test__ZN3ccc6EE3x12E, "_ZN3ccc6EE3x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE3x12C1Ev();
extern void _ZN3ccc6EE3x12D1Ev();
Name_Map name_map__ZN3ccc6EE3x12E[] = {
  NSPAIR(_ZN3ccc6EE3x12C1Ev),
  NSPAIR(_ZN3ccc6EE3x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc6EE3x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE3x12E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc6EE3x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE3x12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE3x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE3x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE3x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE3x12E[] = {
  {&(_ZTVN3ccc6EE3x12E[6]),  6,9},
  {&(_ZTVN3ccc6EE3x12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE3x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE3x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE3x12E[];
Class_Descriptor cd__ZN3ccc6EE3x12E = {  "_ZN3ccc6EE3x12E", // class name
  bases__ZN3ccc6EE3x12E, 1,
  &(vtc__ZN3ccc6EE3x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE3x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE3x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE3x12E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE3x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x13  : virtual ::ccc::AA3 {
  virtual void  efg(); // _ZN3ccc6EE3x133efgEv
  ~EE3x13(); // tgen
  EE3x13(); // tgen
};
//SIG(1 _ZN3ccc6EE3x13E) C1{ VBC2{ v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::EE3x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE3x133efgEv");}
ccc::EE3x13 ::~EE3x13(){ note_dtor("_ZN3ccc6EE3x13E", this);} // tgen
ccc::EE3x13 ::EE3x13(){ note_ctor("_ZN3ccc6EE3x13E", this);} // tgen
}
static void Test__ZN3ccc6EE3x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE3x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE3x13E, buf);
    ::ccc::EE3x13 *dp, &lv = *(dp=new (buf) ::ccc::EE3x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE3x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE3x13E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc6EE3x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE3x13E);
    dp->::ccc::EE3x13::~EE3x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE3x13E(Test__ZN3ccc6EE3x13E, "_ZN3ccc6EE3x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE3x13C1Ev();
extern void _ZN3ccc6EE3x13D1Ev();
Name_Map name_map__ZN3ccc6EE3x13E[] = {
  NSPAIR(_ZN3ccc6EE3x13C1Ev),
  NSPAIR(_ZN3ccc6EE3x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc6EE3x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE3x13E[];
extern void _ZN3ccc6EE3x133efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE3x13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE3x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE3x133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE3x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE3x13E[] = {
  {&(_ZTVN3ccc6EE3x13E[6]),  6,9},
  {&(_ZTVN3ccc6EE3x13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE3x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE3x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE3x13E[];
Class_Descriptor cd__ZN3ccc6EE3x13E = {  "_ZN3ccc6EE3x13E", // class name
  bases__ZN3ccc6EE3x13E, 1,
  &(vtc__ZN3ccc6EE3x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE3x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE3x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE3x13E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE3x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x14  : virtual ::ccc::AA3 {
  virtual void  pqr(); // _ZN3ccc6EE3x143pqrEv
  ~EE3x14(); // tgen
  EE3x14(); // tgen
};
//SIG(1 _ZN3ccc6EE3x14E) C1{ VBC2{ v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::EE3x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE3x143pqrEv");}
ccc::EE3x14 ::~EE3x14(){ note_dtor("_ZN3ccc6EE3x14E", this);} // tgen
ccc::EE3x14 ::EE3x14(){ note_ctor("_ZN3ccc6EE3x14E", this);} // tgen
}
static void Test__ZN3ccc6EE3x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE3x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE3x14E, buf);
    ::ccc::EE3x14 *dp, &lv = *(dp=new (buf) ::ccc::EE3x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE3x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE3x14E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc6EE3x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE3x14E);
    dp->::ccc::EE3x14::~EE3x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE3x14E(Test__ZN3ccc6EE3x14E, "_ZN3ccc6EE3x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE3x14C1Ev();
extern void _ZN3ccc6EE3x14D1Ev();
Name_Map name_map__ZN3ccc6EE3x14E[] = {
  NSPAIR(_ZN3ccc6EE3x14C1Ev),
  NSPAIR(_ZN3ccc6EE3x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc6EE3x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE3x14E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc6EE3x143pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE3x14E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE3x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE3x143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE3x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE3x14E[] = {
  {&(_ZTVN3ccc6EE3x14E[6]),  6,9},
  {&(_ZTVN3ccc6EE3x14E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE3x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE3x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE3x14E[];
Class_Descriptor cd__ZN3ccc6EE3x14E = {  "_ZN3ccc6EE3x14E", // class name
  bases__ZN3ccc6EE3x14E, 1,
  &(vtc__ZN3ccc6EE3x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE3x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE3x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE3x14E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE3x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE3x15  : virtual ::ccc::AA3 {
  ~EE3x15(); // tgen
  EE3x15(); // tgen
};
//SIG(1 _ZN3ccc6EE3x15E) C1{ VBC2{ v1 v2 v3}}
}
namespace ccc { 
ccc::EE3x15 ::~EE3x15(){ note_dtor("_ZN3ccc6EE3x15E", this);} // tgen
ccc::EE3x15 ::EE3x15(){ note_ctor("_ZN3ccc6EE3x15E", this);} // tgen
}
static void Test__ZN3ccc6EE3x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE3x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE3x15E, buf);
    ::ccc::EE3x15 *dp, &lv = *(dp=new (buf) ::ccc::EE3x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE3x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE3x15E)");
    check_base_class_offset(lv, (::ccc::AA3*), 0, "_ZN3ccc6EE3x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE3x15E);
    dp->::ccc::EE3x15::~EE3x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE3x15E(Test__ZN3ccc6EE3x15E, "_ZN3ccc6EE3x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE3x15C1Ev();
extern void _ZN3ccc6EE3x15D1Ev();
Name_Map name_map__ZN3ccc6EE3x15E[] = {
  NSPAIR(_ZN3ccc6EE3x15C1Ev),
  NSPAIR(_ZN3ccc6EE3x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA3E;
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
static Base_Class bases__ZN3ccc6EE3x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE3x15E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE3x15E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE3x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE3x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE3x15E[] = {
  {&(_ZTVN3ccc6EE3x15E[6]),  6,9},
  {&(_ZTVN3ccc6EE3x15E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE3x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE3x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE3x15E[];
Class_Descriptor cd__ZN3ccc6EE3x15E = {  "_ZN3ccc6EE3x15E", // class name
  bases__ZN3ccc6EE3x15E, 1,
  &(vtc__ZN3ccc6EE3x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE3x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE3x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE3x15E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE3x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA4  {
  virtual void  pqr(); // _ZN3ccc3AA43pqrEv
  virtual void  abc(); // _ZN3ccc3AA43abcEv
  virtual void  efg(); // _ZN3ccc3AA43efgEv
  ~AA4(); // tgen
  AA4(); // tgen
};
//SIG(-1 _ZN3ccc3AA4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA4 ::pqr(){vfunc_called(this, "_ZN3ccc3AA43pqrEv");}
void  ccc::AA4 ::abc(){vfunc_called(this, "_ZN3ccc3AA43abcEv");}
void  ccc::AA4 ::efg(){vfunc_called(this, "_ZN3ccc3AA43efgEv");}
ccc::AA4 ::~AA4(){ note_dtor("_ZN3ccc3AA4E", this);} // tgen
ccc::AA4 ::AA4(){ note_ctor("_ZN3ccc3AA4E", this);} // tgen
}
static void Test__ZN3ccc3AA4E()
{
  extern Class_Descriptor cd__ZN3ccc3AA4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA4E, buf);
    ::ccc::AA4 *dp, &lv = *(dp=new (buf) ::ccc::AA4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA4E)");
    test_class_info(&lv, &cd__ZN3ccc3AA4E);
    dp->::ccc::AA4::~AA4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA4E(Test__ZN3ccc3AA4E, "_ZN3ccc3AA4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA4C1Ev();
extern void _ZN3ccc3AA4D1Ev();
Name_Map name_map__ZN3ccc3AA4E[] = {
  NSPAIR(_ZN3ccc3AA4C1Ev),
  NSPAIR(_ZN3ccc3AA4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
Class_Descriptor cd__ZN3ccc3AA4E = {  "_ZN3ccc3AA4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB4  {
  virtual void  pqr(); // _ZN3ccc3BB43pqrEv
  virtual void  abc(); // _ZN3ccc3BB43abcEv
  virtual void  efg(); // _ZN3ccc3BB43efgEv
  ~BB4(); // tgen
  BB4(); // tgen
};
//SIG(1 _ZN3ccc3BB4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB4 ::pqr(){vfunc_called(this, "_ZN3ccc3BB43pqrEv");}
void  ccc::BB4 ::abc(){vfunc_called(this, "_ZN3ccc3BB43abcEv");}
void  ccc::BB4 ::efg(){vfunc_called(this, "_ZN3ccc3BB43efgEv");}
ccc::BB4 ::~BB4(){ note_dtor("_ZN3ccc3BB4E", this);} // tgen
ccc::BB4 ::BB4(){ note_ctor("_ZN3ccc3BB4E", this);} // tgen
}
static void Test__ZN3ccc3BB4E()
{
  extern Class_Descriptor cd__ZN3ccc3BB4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB4E, buf);
    ::ccc::BB4 *dp, &lv = *(dp=new (buf) ::ccc::BB4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB4E)");
    test_class_info(&lv, &cd__ZN3ccc3BB4E);
    dp->::ccc::BB4::~BB4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB4E(Test__ZN3ccc3BB4E, "_ZN3ccc3BB4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB4C1Ev();
extern void _ZN3ccc3BB4D1Ev();
Name_Map name_map__ZN3ccc3BB4E[] = {
  NSPAIR(_ZN3ccc3BB4C1Ev),
  NSPAIR(_ZN3ccc3BB4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
Class_Descriptor cd__ZN3ccc3BB4E = {  "_ZN3ccc3BB4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x0  : virtual ::ccc::AA4 {
  virtual void  abc(); // _ZN3ccc5EE4x03abcEv
  virtual void  efg(); // _ZN3ccc5EE4x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE4x03pqrEv
  ~EE4x0(); // tgen
  EE4x0(); // tgen
};
//SIG(1 _ZN3ccc5EE4x0E) C1{ VBC2{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE4x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x03abcEv");}
void  ccc::EE4x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x03efgEv");}
void  ccc::EE4x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x03pqrEv");}
ccc::EE4x0 ::~EE4x0(){ note_dtor("_ZN3ccc5EE4x0E", this);} // tgen
ccc::EE4x0 ::EE4x0(){ note_ctor("_ZN3ccc5EE4x0E", this);} // tgen
}
static void Test__ZN3ccc5EE4x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x0E, buf);
    ::ccc::EE4x0 *dp, &lv = *(dp=new (buf) ::ccc::EE4x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x0E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x0E);
    dp->::ccc::EE4x0::~EE4x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x0E(Test__ZN3ccc5EE4x0E, "_ZN3ccc5EE4x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x0C1Ev();
extern void _ZN3ccc5EE4x0D1Ev();
Name_Map name_map__ZN3ccc5EE4x0E[] = {
  NSPAIR(_ZN3ccc5EE4x0C1Ev),
  NSPAIR(_ZN3ccc5EE4x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x0E[];
extern void _ZN3ccc5EE4x03pqrEv();
extern void _ZN3ccc5EE4x03abcEv();
extern void _ZN3ccc5EE4x03efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x03efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x0E[] = {
  {&(_ZTVN3ccc5EE4x0E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x0E[];
Class_Descriptor cd__ZN3ccc5EE4x0E = {  "_ZN3ccc5EE4x0E", // class name
  bases__ZN3ccc5EE4x0E, 1,
  &(vtc__ZN3ccc5EE4x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x0E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x1  : virtual ::ccc::AA4 {
  virtual void  abc(); // _ZN3ccc5EE4x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE4x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE4x13efgEv
  ~EE4x1(); // tgen
  EE4x1(); // tgen
};
//SIG(1 _ZN3ccc5EE4x1E) C1{ VBC2{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE4x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x13abcEv");}
void  ccc::EE4x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x13pqrEv");}
void  ccc::EE4x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x13efgEv");}
ccc::EE4x1 ::~EE4x1(){ note_dtor("_ZN3ccc5EE4x1E", this);} // tgen
ccc::EE4x1 ::EE4x1(){ note_ctor("_ZN3ccc5EE4x1E", this);} // tgen
}
static void Test__ZN3ccc5EE4x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x1E, buf);
    ::ccc::EE4x1 *dp, &lv = *(dp=new (buf) ::ccc::EE4x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x1E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x1E);
    dp->::ccc::EE4x1::~EE4x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x1E(Test__ZN3ccc5EE4x1E, "_ZN3ccc5EE4x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x1C1Ev();
extern void _ZN3ccc5EE4x1D1Ev();
Name_Map name_map__ZN3ccc5EE4x1E[] = {
  NSPAIR(_ZN3ccc5EE4x1C1Ev),
  NSPAIR(_ZN3ccc5EE4x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x1E[];
extern void _ZN3ccc5EE4x13pqrEv();
extern void _ZN3ccc5EE4x13abcEv();
extern void _ZN3ccc5EE4x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x1E[] = {
  {&(_ZTVN3ccc5EE4x1E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x1E[];
Class_Descriptor cd__ZN3ccc5EE4x1E = {  "_ZN3ccc5EE4x1E", // class name
  bases__ZN3ccc5EE4x1E, 1,
  &(vtc__ZN3ccc5EE4x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x1E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x2  : virtual ::ccc::AA4 {
  virtual void  efg(); // _ZN3ccc5EE4x23efgEv
  virtual void  abc(); // _ZN3ccc5EE4x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE4x23pqrEv
  ~EE4x2(); // tgen
  EE4x2(); // tgen
};
//SIG(1 _ZN3ccc5EE4x2E) C1{ VBC2{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE4x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x23efgEv");}
void  ccc::EE4x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x23abcEv");}
void  ccc::EE4x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x23pqrEv");}
ccc::EE4x2 ::~EE4x2(){ note_dtor("_ZN3ccc5EE4x2E", this);} // tgen
ccc::EE4x2 ::EE4x2(){ note_ctor("_ZN3ccc5EE4x2E", this);} // tgen
}
static void Test__ZN3ccc5EE4x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x2E, buf);
    ::ccc::EE4x2 *dp, &lv = *(dp=new (buf) ::ccc::EE4x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x2E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x2E);
    dp->::ccc::EE4x2::~EE4x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x2E(Test__ZN3ccc5EE4x2E, "_ZN3ccc5EE4x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x2C1Ev();
extern void _ZN3ccc5EE4x2D1Ev();
Name_Map name_map__ZN3ccc5EE4x2E[] = {
  NSPAIR(_ZN3ccc5EE4x2C1Ev),
  NSPAIR(_ZN3ccc5EE4x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x2E[];
extern void _ZN3ccc5EE4x23pqrEv();
extern void _ZN3ccc5EE4x23abcEv();
extern void _ZN3ccc5EE4x23efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x23efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x2E[] = {
  {&(_ZTVN3ccc5EE4x2E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x2E[];
Class_Descriptor cd__ZN3ccc5EE4x2E = {  "_ZN3ccc5EE4x2E", // class name
  bases__ZN3ccc5EE4x2E, 1,
  &(vtc__ZN3ccc5EE4x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x2E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x3  : virtual ::ccc::AA4 {
  virtual void  efg(); // _ZN3ccc5EE4x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE4x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE4x33abcEv
  ~EE4x3(); // tgen
  EE4x3(); // tgen
};
//SIG(1 _ZN3ccc5EE4x3E) C1{ VBC2{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE4x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x33efgEv");}
void  ccc::EE4x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x33pqrEv");}
void  ccc::EE4x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x33abcEv");}
ccc::EE4x3 ::~EE4x3(){ note_dtor("_ZN3ccc5EE4x3E", this);} // tgen
ccc::EE4x3 ::EE4x3(){ note_ctor("_ZN3ccc5EE4x3E", this);} // tgen
}
static void Test__ZN3ccc5EE4x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x3E, buf);
    ::ccc::EE4x3 *dp, &lv = *(dp=new (buf) ::ccc::EE4x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x3E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x3E);
    dp->::ccc::EE4x3::~EE4x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x3E(Test__ZN3ccc5EE4x3E, "_ZN3ccc5EE4x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x3C1Ev();
extern void _ZN3ccc5EE4x3D1Ev();
Name_Map name_map__ZN3ccc5EE4x3E[] = {
  NSPAIR(_ZN3ccc5EE4x3C1Ev),
  NSPAIR(_ZN3ccc5EE4x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x3E[];
extern void _ZN3ccc5EE4x33pqrEv();
extern void _ZN3ccc5EE4x33abcEv();
extern void _ZN3ccc5EE4x33efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x33efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x3E[] = {
  {&(_ZTVN3ccc5EE4x3E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x3E[];
Class_Descriptor cd__ZN3ccc5EE4x3E = {  "_ZN3ccc5EE4x3E", // class name
  bases__ZN3ccc5EE4x3E, 1,
  &(vtc__ZN3ccc5EE4x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x3E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x4  : virtual ::ccc::AA4 {
  virtual void  pqr(); // _ZN3ccc5EE4x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE4x43abcEv
  virtual void  efg(); // _ZN3ccc5EE4x43efgEv
  ~EE4x4(); // tgen
  EE4x4(); // tgen
};
//SIG(1 _ZN3ccc5EE4x4E) C1{ VBC2{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE4x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x43pqrEv");}
void  ccc::EE4x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x43abcEv");}
void  ccc::EE4x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x43efgEv");}
ccc::EE4x4 ::~EE4x4(){ note_dtor("_ZN3ccc5EE4x4E", this);} // tgen
ccc::EE4x4 ::EE4x4(){ note_ctor("_ZN3ccc5EE4x4E", this);} // tgen
}
static void Test__ZN3ccc5EE4x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x4E, buf);
    ::ccc::EE4x4 *dp, &lv = *(dp=new (buf) ::ccc::EE4x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x4E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x4E);
    dp->::ccc::EE4x4::~EE4x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x4E(Test__ZN3ccc5EE4x4E, "_ZN3ccc5EE4x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x4C1Ev();
extern void _ZN3ccc5EE4x4D1Ev();
Name_Map name_map__ZN3ccc5EE4x4E[] = {
  NSPAIR(_ZN3ccc5EE4x4C1Ev),
  NSPAIR(_ZN3ccc5EE4x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x4E[];
extern void _ZN3ccc5EE4x43pqrEv();
extern void _ZN3ccc5EE4x43abcEv();
extern void _ZN3ccc5EE4x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x4E[] = {
  {&(_ZTVN3ccc5EE4x4E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x4E[];
Class_Descriptor cd__ZN3ccc5EE4x4E = {  "_ZN3ccc5EE4x4E", // class name
  bases__ZN3ccc5EE4x4E, 1,
  &(vtc__ZN3ccc5EE4x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x4E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x5  : virtual ::ccc::AA4 {
  virtual void  pqr(); // _ZN3ccc5EE4x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE4x53efgEv
  virtual void  abc(); // _ZN3ccc5EE4x53abcEv
  ~EE4x5(); // tgen
  EE4x5(); // tgen
};
//SIG(1 _ZN3ccc5EE4x5E) C1{ VBC2{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE4x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x53pqrEv");}
void  ccc::EE4x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x53efgEv");}
void  ccc::EE4x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x53abcEv");}
ccc::EE4x5 ::~EE4x5(){ note_dtor("_ZN3ccc5EE4x5E", this);} // tgen
ccc::EE4x5 ::EE4x5(){ note_ctor("_ZN3ccc5EE4x5E", this);} // tgen
}
static void Test__ZN3ccc5EE4x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x5E, buf);
    ::ccc::EE4x5 *dp, &lv = *(dp=new (buf) ::ccc::EE4x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x5E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x5E);
    dp->::ccc::EE4x5::~EE4x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x5E(Test__ZN3ccc5EE4x5E, "_ZN3ccc5EE4x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x5C1Ev();
extern void _ZN3ccc5EE4x5D1Ev();
Name_Map name_map__ZN3ccc5EE4x5E[] = {
  NSPAIR(_ZN3ccc5EE4x5C1Ev),
  NSPAIR(_ZN3ccc5EE4x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x5E[];
extern void _ZN3ccc5EE4x53pqrEv();
extern void _ZN3ccc5EE4x53abcEv();
extern void _ZN3ccc5EE4x53efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x53efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x5E[] = {
  {&(_ZTVN3ccc5EE4x5E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x5E[];
Class_Descriptor cd__ZN3ccc5EE4x5E = {  "_ZN3ccc5EE4x5E", // class name
  bases__ZN3ccc5EE4x5E, 1,
  &(vtc__ZN3ccc5EE4x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x5E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x6  : virtual ::ccc::AA4 {
  virtual void  abc(); // _ZN3ccc5EE4x63abcEv
  virtual void  efg(); // _ZN3ccc5EE4x63efgEv
  ~EE4x6(); // tgen
  EE4x6(); // tgen
};
//SIG(1 _ZN3ccc5EE4x6E) C1{ VBC2{ v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE4x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x63abcEv");}
void  ccc::EE4x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x63efgEv");}
ccc::EE4x6 ::~EE4x6(){ note_dtor("_ZN3ccc5EE4x6E", this);} // tgen
ccc::EE4x6 ::EE4x6(){ note_ctor("_ZN3ccc5EE4x6E", this);} // tgen
}
static void Test__ZN3ccc5EE4x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x6E, buf);
    ::ccc::EE4x6 *dp, &lv = *(dp=new (buf) ::ccc::EE4x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x6E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x6E);
    dp->::ccc::EE4x6::~EE4x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x6E(Test__ZN3ccc5EE4x6E, "_ZN3ccc5EE4x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x6C1Ev();
extern void _ZN3ccc5EE4x6D1Ev();
Name_Map name_map__ZN3ccc5EE4x6E[] = {
  NSPAIR(_ZN3ccc5EE4x6C1Ev),
  NSPAIR(_ZN3ccc5EE4x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x6E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc5EE4x63abcEv();
extern void _ZN3ccc5EE4x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x6E[] = {
  {&(_ZTVN3ccc5EE4x6E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x6E[];
Class_Descriptor cd__ZN3ccc5EE4x6E = {  "_ZN3ccc5EE4x6E", // class name
  bases__ZN3ccc5EE4x6E, 1,
  &(vtc__ZN3ccc5EE4x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x6E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x7  : virtual ::ccc::AA4 {
  virtual void  abc(); // _ZN3ccc5EE4x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE4x73pqrEv
  ~EE4x7(); // tgen
  EE4x7(); // tgen
};
//SIG(1 _ZN3ccc5EE4x7E) C1{ VBC2{ v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE4x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x73abcEv");}
void  ccc::EE4x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x73pqrEv");}
ccc::EE4x7 ::~EE4x7(){ note_dtor("_ZN3ccc5EE4x7E", this);} // tgen
ccc::EE4x7 ::EE4x7(){ note_ctor("_ZN3ccc5EE4x7E", this);} // tgen
}
static void Test__ZN3ccc5EE4x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x7E, buf);
    ::ccc::EE4x7 *dp, &lv = *(dp=new (buf) ::ccc::EE4x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x7E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x7E);
    dp->::ccc::EE4x7::~EE4x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x7E(Test__ZN3ccc5EE4x7E, "_ZN3ccc5EE4x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x7C1Ev();
extern void _ZN3ccc5EE4x7D1Ev();
Name_Map name_map__ZN3ccc5EE4x7E[] = {
  NSPAIR(_ZN3ccc5EE4x7C1Ev),
  NSPAIR(_ZN3ccc5EE4x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x7E[];
extern void _ZN3ccc5EE4x73pqrEv();
extern void _ZN3ccc5EE4x73abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x7E[] = {
  {&(_ZTVN3ccc5EE4x7E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x7E[];
Class_Descriptor cd__ZN3ccc5EE4x7E = {  "_ZN3ccc5EE4x7E", // class name
  bases__ZN3ccc5EE4x7E, 1,
  &(vtc__ZN3ccc5EE4x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x7E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x8  : virtual ::ccc::AA4 {
  virtual void  efg(); // _ZN3ccc5EE4x83efgEv
  virtual void  abc(); // _ZN3ccc5EE4x83abcEv
  ~EE4x8(); // tgen
  EE4x8(); // tgen
};
//SIG(1 _ZN3ccc5EE4x8E) C1{ VBC2{ v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE4x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x83efgEv");}
void  ccc::EE4x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE4x83abcEv");}
ccc::EE4x8 ::~EE4x8(){ note_dtor("_ZN3ccc5EE4x8E", this);} // tgen
ccc::EE4x8 ::EE4x8(){ note_ctor("_ZN3ccc5EE4x8E", this);} // tgen
}
static void Test__ZN3ccc5EE4x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x8E, buf);
    ::ccc::EE4x8 *dp, &lv = *(dp=new (buf) ::ccc::EE4x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x8E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x8E);
    dp->::ccc::EE4x8::~EE4x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x8E(Test__ZN3ccc5EE4x8E, "_ZN3ccc5EE4x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x8C1Ev();
extern void _ZN3ccc5EE4x8D1Ev();
Name_Map name_map__ZN3ccc5EE4x8E[] = {
  NSPAIR(_ZN3ccc5EE4x8C1Ev),
  NSPAIR(_ZN3ccc5EE4x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x8E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc5EE4x83abcEv();
extern void _ZN3ccc5EE4x83efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x83efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x8E[] = {
  {&(_ZTVN3ccc5EE4x8E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x8E[];
Class_Descriptor cd__ZN3ccc5EE4x8E = {  "_ZN3ccc5EE4x8E", // class name
  bases__ZN3ccc5EE4x8E, 1,
  &(vtc__ZN3ccc5EE4x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x8E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x9  : virtual ::ccc::AA4 {
  virtual void  efg(); // _ZN3ccc5EE4x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE4x93pqrEv
  ~EE4x9(); // tgen
  EE4x9(); // tgen
};
//SIG(1 _ZN3ccc5EE4x9E) C1{ VBC2{ v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE4x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE4x93efgEv");}
void  ccc::EE4x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE4x93pqrEv");}
ccc::EE4x9 ::~EE4x9(){ note_dtor("_ZN3ccc5EE4x9E", this);} // tgen
ccc::EE4x9 ::EE4x9(){ note_ctor("_ZN3ccc5EE4x9E", this);} // tgen
}
static void Test__ZN3ccc5EE4x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE4x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE4x9E, buf);
    ::ccc::EE4x9 *dp, &lv = *(dp=new (buf) ::ccc::EE4x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE4x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE4x9E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc5EE4x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE4x9E);
    dp->::ccc::EE4x9::~EE4x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE4x9E(Test__ZN3ccc5EE4x9E, "_ZN3ccc5EE4x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE4x9C1Ev();
extern void _ZN3ccc5EE4x9D1Ev();
Name_Map name_map__ZN3ccc5EE4x9E[] = {
  NSPAIR(_ZN3ccc5EE4x9C1Ev),
  NSPAIR(_ZN3ccc5EE4x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc5EE4x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE4x9E[];
extern void _ZN3ccc5EE4x93pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc5EE4x93efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE4x9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE4x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE4x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE4x93efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE4x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE4x9E[] = {
  {&(_ZTVN3ccc5EE4x9E[6]),  6,9},
  {&(_ZTVN3ccc5EE4x9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE4x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE4x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE4x9E[];
Class_Descriptor cd__ZN3ccc5EE4x9E = {  "_ZN3ccc5EE4x9E", // class name
  bases__ZN3ccc5EE4x9E, 1,
  &(vtc__ZN3ccc5EE4x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE4x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE4x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE4x9E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE4x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x10  : virtual ::ccc::AA4 {
  virtual void  pqr(); // _ZN3ccc6EE4x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE4x103abcEv
  ~EE4x10(); // tgen
  EE4x10(); // tgen
};
//SIG(1 _ZN3ccc6EE4x10E) C1{ VBC2{ v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE4x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE4x103pqrEv");}
void  ccc::EE4x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE4x103abcEv");}
ccc::EE4x10 ::~EE4x10(){ note_dtor("_ZN3ccc6EE4x10E", this);} // tgen
ccc::EE4x10 ::EE4x10(){ note_ctor("_ZN3ccc6EE4x10E", this);} // tgen
}
static void Test__ZN3ccc6EE4x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE4x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE4x10E, buf);
    ::ccc::EE4x10 *dp, &lv = *(dp=new (buf) ::ccc::EE4x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE4x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE4x10E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc6EE4x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE4x10E);
    dp->::ccc::EE4x10::~EE4x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE4x10E(Test__ZN3ccc6EE4x10E, "_ZN3ccc6EE4x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE4x10C1Ev();
extern void _ZN3ccc6EE4x10D1Ev();
Name_Map name_map__ZN3ccc6EE4x10E[] = {
  NSPAIR(_ZN3ccc6EE4x10C1Ev),
  NSPAIR(_ZN3ccc6EE4x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc6EE4x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE4x10E[];
extern void _ZN3ccc6EE4x103pqrEv();
extern void _ZN3ccc6EE4x103abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE4x10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE4x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE4x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE4x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE4x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE4x10E[] = {
  {&(_ZTVN3ccc6EE4x10E[6]),  6,9},
  {&(_ZTVN3ccc6EE4x10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE4x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE4x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE4x10E[];
Class_Descriptor cd__ZN3ccc6EE4x10E = {  "_ZN3ccc6EE4x10E", // class name
  bases__ZN3ccc6EE4x10E, 1,
  &(vtc__ZN3ccc6EE4x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE4x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE4x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE4x10E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE4x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x11  : virtual ::ccc::AA4 {
  virtual void  pqr(); // _ZN3ccc6EE4x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE4x113efgEv
  ~EE4x11(); // tgen
  EE4x11(); // tgen
};
//SIG(1 _ZN3ccc6EE4x11E) C1{ VBC2{ v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE4x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE4x113pqrEv");}
void  ccc::EE4x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE4x113efgEv");}
ccc::EE4x11 ::~EE4x11(){ note_dtor("_ZN3ccc6EE4x11E", this);} // tgen
ccc::EE4x11 ::EE4x11(){ note_ctor("_ZN3ccc6EE4x11E", this);} // tgen
}
static void Test__ZN3ccc6EE4x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE4x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE4x11E, buf);
    ::ccc::EE4x11 *dp, &lv = *(dp=new (buf) ::ccc::EE4x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE4x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE4x11E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc6EE4x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE4x11E);
    dp->::ccc::EE4x11::~EE4x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE4x11E(Test__ZN3ccc6EE4x11E, "_ZN3ccc6EE4x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE4x11C1Ev();
extern void _ZN3ccc6EE4x11D1Ev();
Name_Map name_map__ZN3ccc6EE4x11E[] = {
  NSPAIR(_ZN3ccc6EE4x11C1Ev),
  NSPAIR(_ZN3ccc6EE4x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc6EE4x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE4x11E[];
extern void _ZN3ccc6EE4x113pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc6EE4x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE4x11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE4x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE4x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE4x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE4x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE4x11E[] = {
  {&(_ZTVN3ccc6EE4x11E[6]),  6,9},
  {&(_ZTVN3ccc6EE4x11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE4x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE4x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE4x11E[];
Class_Descriptor cd__ZN3ccc6EE4x11E = {  "_ZN3ccc6EE4x11E", // class name
  bases__ZN3ccc6EE4x11E, 1,
  &(vtc__ZN3ccc6EE4x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE4x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE4x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE4x11E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE4x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x12  : virtual ::ccc::AA4 {
  virtual void  abc(); // _ZN3ccc6EE4x123abcEv
  ~EE4x12(); // tgen
  EE4x12(); // tgen
};
//SIG(1 _ZN3ccc6EE4x12E) C1{ VBC2{ v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::EE4x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE4x123abcEv");}
ccc::EE4x12 ::~EE4x12(){ note_dtor("_ZN3ccc6EE4x12E", this);} // tgen
ccc::EE4x12 ::EE4x12(){ note_ctor("_ZN3ccc6EE4x12E", this);} // tgen
}
static void Test__ZN3ccc6EE4x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE4x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE4x12E, buf);
    ::ccc::EE4x12 *dp, &lv = *(dp=new (buf) ::ccc::EE4x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE4x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE4x12E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc6EE4x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE4x12E);
    dp->::ccc::EE4x12::~EE4x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE4x12E(Test__ZN3ccc6EE4x12E, "_ZN3ccc6EE4x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE4x12C1Ev();
extern void _ZN3ccc6EE4x12D1Ev();
Name_Map name_map__ZN3ccc6EE4x12E[] = {
  NSPAIR(_ZN3ccc6EE4x12C1Ev),
  NSPAIR(_ZN3ccc6EE4x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc6EE4x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE4x12E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc6EE4x123abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE4x12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE4x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE4x123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE4x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE4x12E[] = {
  {&(_ZTVN3ccc6EE4x12E[6]),  6,9},
  {&(_ZTVN3ccc6EE4x12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE4x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE4x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE4x12E[];
Class_Descriptor cd__ZN3ccc6EE4x12E = {  "_ZN3ccc6EE4x12E", // class name
  bases__ZN3ccc6EE4x12E, 1,
  &(vtc__ZN3ccc6EE4x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE4x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE4x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE4x12E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE4x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x13  : virtual ::ccc::AA4 {
  virtual void  efg(); // _ZN3ccc6EE4x133efgEv
  ~EE4x13(); // tgen
  EE4x13(); // tgen
};
//SIG(1 _ZN3ccc6EE4x13E) C1{ VBC2{ v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::EE4x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE4x133efgEv");}
ccc::EE4x13 ::~EE4x13(){ note_dtor("_ZN3ccc6EE4x13E", this);} // tgen
ccc::EE4x13 ::EE4x13(){ note_ctor("_ZN3ccc6EE4x13E", this);} // tgen
}
static void Test__ZN3ccc6EE4x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE4x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE4x13E, buf);
    ::ccc::EE4x13 *dp, &lv = *(dp=new (buf) ::ccc::EE4x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE4x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE4x13E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc6EE4x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE4x13E);
    dp->::ccc::EE4x13::~EE4x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE4x13E(Test__ZN3ccc6EE4x13E, "_ZN3ccc6EE4x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE4x13C1Ev();
extern void _ZN3ccc6EE4x13D1Ev();
Name_Map name_map__ZN3ccc6EE4x13E[] = {
  NSPAIR(_ZN3ccc6EE4x13C1Ev),
  NSPAIR(_ZN3ccc6EE4x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc6EE4x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE4x13E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc6EE4x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE4x13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE4x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE4x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE4x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE4x13E[] = {
  {&(_ZTVN3ccc6EE4x13E[6]),  6,9},
  {&(_ZTVN3ccc6EE4x13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE4x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE4x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE4x13E[];
Class_Descriptor cd__ZN3ccc6EE4x13E = {  "_ZN3ccc6EE4x13E", // class name
  bases__ZN3ccc6EE4x13E, 1,
  &(vtc__ZN3ccc6EE4x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE4x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE4x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE4x13E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE4x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x14  : virtual ::ccc::AA4 {
  virtual void  pqr(); // _ZN3ccc6EE4x143pqrEv
  ~EE4x14(); // tgen
  EE4x14(); // tgen
};
//SIG(1 _ZN3ccc6EE4x14E) C1{ VBC2{ v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::EE4x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE4x143pqrEv");}
ccc::EE4x14 ::~EE4x14(){ note_dtor("_ZN3ccc6EE4x14E", this);} // tgen
ccc::EE4x14 ::EE4x14(){ note_ctor("_ZN3ccc6EE4x14E", this);} // tgen
}
static void Test__ZN3ccc6EE4x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE4x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE4x14E, buf);
    ::ccc::EE4x14 *dp, &lv = *(dp=new (buf) ::ccc::EE4x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE4x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE4x14E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc6EE4x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE4x14E);
    dp->::ccc::EE4x14::~EE4x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE4x14E(Test__ZN3ccc6EE4x14E, "_ZN3ccc6EE4x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE4x14C1Ev();
extern void _ZN3ccc6EE4x14D1Ev();
Name_Map name_map__ZN3ccc6EE4x14E[] = {
  NSPAIR(_ZN3ccc6EE4x14C1Ev),
  NSPAIR(_ZN3ccc6EE4x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc6EE4x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE4x14E[];
extern void _ZN3ccc6EE4x143pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE4x14E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE4x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE4x143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE4x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE4x14E[] = {
  {&(_ZTVN3ccc6EE4x14E[6]),  6,9},
  {&(_ZTVN3ccc6EE4x14E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE4x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE4x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE4x14E[];
Class_Descriptor cd__ZN3ccc6EE4x14E = {  "_ZN3ccc6EE4x14E", // class name
  bases__ZN3ccc6EE4x14E, 1,
  &(vtc__ZN3ccc6EE4x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE4x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE4x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE4x14E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE4x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE4x15  : virtual ::ccc::AA4 {
  ~EE4x15(); // tgen
  EE4x15(); // tgen
};
//SIG(1 _ZN3ccc6EE4x15E) C1{ VBC2{ v1 v2 v3}}
}
namespace ccc { 
ccc::EE4x15 ::~EE4x15(){ note_dtor("_ZN3ccc6EE4x15E", this);} // tgen
ccc::EE4x15 ::EE4x15(){ note_ctor("_ZN3ccc6EE4x15E", this);} // tgen
}
static void Test__ZN3ccc6EE4x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE4x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE4x15E, buf);
    ::ccc::EE4x15 *dp, &lv = *(dp=new (buf) ::ccc::EE4x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE4x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE4x15E)");
    check_base_class_offset(lv, (::ccc::AA4*), 0, "_ZN3ccc6EE4x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE4x15E);
    dp->::ccc::EE4x15::~EE4x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE4x15E(Test__ZN3ccc6EE4x15E, "_ZN3ccc6EE4x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE4x15C1Ev();
extern void _ZN3ccc6EE4x15D1Ev();
Name_Map name_map__ZN3ccc6EE4x15E[] = {
  NSPAIR(_ZN3ccc6EE4x15C1Ev),
  NSPAIR(_ZN3ccc6EE4x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA4E;
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
static Base_Class bases__ZN3ccc6EE4x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE4x15E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE4x15E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE4x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE4x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE4x15E[] = {
  {&(_ZTVN3ccc6EE4x15E[6]),  6,9},
  {&(_ZTVN3ccc6EE4x15E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE4x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE4x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE4x15E[];
Class_Descriptor cd__ZN3ccc6EE4x15E = {  "_ZN3ccc6EE4x15E", // class name
  bases__ZN3ccc6EE4x15E, 1,
  &(vtc__ZN3ccc6EE4x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE4x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE4x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE4x15E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE4x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA5  {
  virtual void  pqr(); // _ZN3ccc3AA53pqrEv
  virtual void  efg(); // _ZN3ccc3AA53efgEv
  virtual void  abc(); // _ZN3ccc3AA53abcEv
  ~AA5(); // tgen
  AA5(); // tgen
};
//SIG(-1 _ZN3ccc3AA5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA5 ::pqr(){vfunc_called(this, "_ZN3ccc3AA53pqrEv");}
void  ccc::AA5 ::efg(){vfunc_called(this, "_ZN3ccc3AA53efgEv");}
void  ccc::AA5 ::abc(){vfunc_called(this, "_ZN3ccc3AA53abcEv");}
ccc::AA5 ::~AA5(){ note_dtor("_ZN3ccc3AA5E", this);} // tgen
ccc::AA5 ::AA5(){ note_ctor("_ZN3ccc3AA5E", this);} // tgen
}
static void Test__ZN3ccc3AA5E()
{
  extern Class_Descriptor cd__ZN3ccc3AA5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA5E, buf);
    ::ccc::AA5 *dp, &lv = *(dp=new (buf) ::ccc::AA5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA5E)");
    test_class_info(&lv, &cd__ZN3ccc3AA5E);
    dp->::ccc::AA5::~AA5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA5E(Test__ZN3ccc3AA5E, "_ZN3ccc3AA5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA5C1Ev();
extern void _ZN3ccc3AA5D1Ev();
Name_Map name_map__ZN3ccc3AA5E[] = {
  NSPAIR(_ZN3ccc3AA5C1Ev),
  NSPAIR(_ZN3ccc3AA5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
Class_Descriptor cd__ZN3ccc3AA5E = {  "_ZN3ccc3AA5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB5  {
  virtual void  pqr(); // _ZN3ccc3BB53pqrEv
  virtual void  efg(); // _ZN3ccc3BB53efgEv
  virtual void  abc(); // _ZN3ccc3BB53abcEv
  ~BB5(); // tgen
  BB5(); // tgen
};
//SIG(1 _ZN3ccc3BB5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB5 ::pqr(){vfunc_called(this, "_ZN3ccc3BB53pqrEv");}
void  ccc::BB5 ::efg(){vfunc_called(this, "_ZN3ccc3BB53efgEv");}
void  ccc::BB5 ::abc(){vfunc_called(this, "_ZN3ccc3BB53abcEv");}
ccc::BB5 ::~BB5(){ note_dtor("_ZN3ccc3BB5E", this);} // tgen
ccc::BB5 ::BB5(){ note_ctor("_ZN3ccc3BB5E", this);} // tgen
}
static void Test__ZN3ccc3BB5E()
{
  extern Class_Descriptor cd__ZN3ccc3BB5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB5E, buf);
    ::ccc::BB5 *dp, &lv = *(dp=new (buf) ::ccc::BB5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB5E)");
    test_class_info(&lv, &cd__ZN3ccc3BB5E);
    dp->::ccc::BB5::~BB5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB5E(Test__ZN3ccc3BB5E, "_ZN3ccc3BB5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB5C1Ev();
extern void _ZN3ccc3BB5D1Ev();
Name_Map name_map__ZN3ccc3BB5E[] = {
  NSPAIR(_ZN3ccc3BB5C1Ev),
  NSPAIR(_ZN3ccc3BB5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
Class_Descriptor cd__ZN3ccc3BB5E = {  "_ZN3ccc3BB5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x0  : virtual ::ccc::AA5 {
  virtual void  abc(); // _ZN3ccc5EE5x03abcEv
  virtual void  efg(); // _ZN3ccc5EE5x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE5x03pqrEv
  ~EE5x0(); // tgen
  EE5x0(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x0E) C1{ VBC2{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE5x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x03abcEv");}
void  ccc::EE5x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x03efgEv");}
void  ccc::EE5x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x03pqrEv");}
ccc::EE5x0 ::~EE5x0(){ note_dtor("_ZN3ccc5EE5x0E", this);} // tgen
ccc::EE5x0 ::EE5x0(){ note_ctor("_ZN3ccc5EE5x0E", this);} // tgen
}
static void Test__ZN3ccc5EE5x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x0E, buf);
    ::ccc::EE5x0 *dp, &lv = *(dp=new (buf) ::ccc::EE5x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x0E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x0E);
    dp->::ccc::EE5x0::~EE5x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x0E(Test__ZN3ccc5EE5x0E, "_ZN3ccc5EE5x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x0C1Ev();
extern void _ZN3ccc5EE5x0D1Ev();
Name_Map name_map__ZN3ccc5EE5x0E[] = {
  NSPAIR(_ZN3ccc5EE5x0C1Ev),
  NSPAIR(_ZN3ccc5EE5x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern void _ZN3ccc5EE5x03pqrEv();
extern void _ZN3ccc5EE5x03efgEv();
extern void _ZN3ccc5EE5x03abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x03abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x0E[] = {
  {&(_ZTVN3ccc5EE5x0E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
Class_Descriptor cd__ZN3ccc5EE5x0E = {  "_ZN3ccc5EE5x0E", // class name
  bases__ZN3ccc5EE5x0E, 1,
  &(vtc__ZN3ccc5EE5x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x0E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x1  : virtual ::ccc::AA5 {
  virtual void  abc(); // _ZN3ccc5EE5x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE5x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE5x13efgEv
  ~EE5x1(); // tgen
  EE5x1(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x1E) C1{ VBC2{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE5x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x13abcEv");}
void  ccc::EE5x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x13pqrEv");}
void  ccc::EE5x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x13efgEv");}
ccc::EE5x1 ::~EE5x1(){ note_dtor("_ZN3ccc5EE5x1E", this);} // tgen
ccc::EE5x1 ::EE5x1(){ note_ctor("_ZN3ccc5EE5x1E", this);} // tgen
}
static void Test__ZN3ccc5EE5x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x1E, buf);
    ::ccc::EE5x1 *dp, &lv = *(dp=new (buf) ::ccc::EE5x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x1E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x1E);
    dp->::ccc::EE5x1::~EE5x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x1E(Test__ZN3ccc5EE5x1E, "_ZN3ccc5EE5x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x1C1Ev();
extern void _ZN3ccc5EE5x1D1Ev();
Name_Map name_map__ZN3ccc5EE5x1E[] = {
  NSPAIR(_ZN3ccc5EE5x1C1Ev),
  NSPAIR(_ZN3ccc5EE5x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x1E[];
extern void _ZN3ccc5EE5x13pqrEv();
extern void _ZN3ccc5EE5x13efgEv();
extern void _ZN3ccc5EE5x13abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x13abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x1E[] = {
  {&(_ZTVN3ccc5EE5x1E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x1E[];
Class_Descriptor cd__ZN3ccc5EE5x1E = {  "_ZN3ccc5EE5x1E", // class name
  bases__ZN3ccc5EE5x1E, 1,
  &(vtc__ZN3ccc5EE5x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x1E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x2  : virtual ::ccc::AA5 {
  virtual void  efg(); // _ZN3ccc5EE5x23efgEv
  virtual void  abc(); // _ZN3ccc5EE5x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE5x23pqrEv
  ~EE5x2(); // tgen
  EE5x2(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x2E) C1{ VBC2{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE5x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x23efgEv");}
void  ccc::EE5x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x23abcEv");}
void  ccc::EE5x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x23pqrEv");}
ccc::EE5x2 ::~EE5x2(){ note_dtor("_ZN3ccc5EE5x2E", this);} // tgen
ccc::EE5x2 ::EE5x2(){ note_ctor("_ZN3ccc5EE5x2E", this);} // tgen
}
static void Test__ZN3ccc5EE5x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x2E, buf);
    ::ccc::EE5x2 *dp, &lv = *(dp=new (buf) ::ccc::EE5x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x2E);
    dp->::ccc::EE5x2::~EE5x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x2E(Test__ZN3ccc5EE5x2E, "_ZN3ccc5EE5x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x2C1Ev();
extern void _ZN3ccc5EE5x2D1Ev();
Name_Map name_map__ZN3ccc5EE5x2E[] = {
  NSPAIR(_ZN3ccc5EE5x2C1Ev),
  NSPAIR(_ZN3ccc5EE5x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x2E[];
extern void _ZN3ccc5EE5x23pqrEv();
extern void _ZN3ccc5EE5x23efgEv();
extern void _ZN3ccc5EE5x23abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x23abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x2E[] = {
  {&(_ZTVN3ccc5EE5x2E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x2E[];
Class_Descriptor cd__ZN3ccc5EE5x2E = {  "_ZN3ccc5EE5x2E", // class name
  bases__ZN3ccc5EE5x2E, 1,
  &(vtc__ZN3ccc5EE5x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x2E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x3  : virtual ::ccc::AA5 {
  virtual void  efg(); // _ZN3ccc5EE5x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE5x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE5x33abcEv
  ~EE5x3(); // tgen
  EE5x3(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x3E) C1{ VBC2{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE5x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x33efgEv");}
void  ccc::EE5x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x33pqrEv");}
void  ccc::EE5x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x33abcEv");}
ccc::EE5x3 ::~EE5x3(){ note_dtor("_ZN3ccc5EE5x3E", this);} // tgen
ccc::EE5x3 ::EE5x3(){ note_ctor("_ZN3ccc5EE5x3E", this);} // tgen
}
static void Test__ZN3ccc5EE5x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x3E, buf);
    ::ccc::EE5x3 *dp, &lv = *(dp=new (buf) ::ccc::EE5x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x3E);
    dp->::ccc::EE5x3::~EE5x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x3E(Test__ZN3ccc5EE5x3E, "_ZN3ccc5EE5x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x3C1Ev();
extern void _ZN3ccc5EE5x3D1Ev();
Name_Map name_map__ZN3ccc5EE5x3E[] = {
  NSPAIR(_ZN3ccc5EE5x3C1Ev),
  NSPAIR(_ZN3ccc5EE5x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x3E[];
extern void _ZN3ccc5EE5x33pqrEv();
extern void _ZN3ccc5EE5x33efgEv();
extern void _ZN3ccc5EE5x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x3E[] = {
  {&(_ZTVN3ccc5EE5x3E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x3E[];
Class_Descriptor cd__ZN3ccc5EE5x3E = {  "_ZN3ccc5EE5x3E", // class name
  bases__ZN3ccc5EE5x3E, 1,
  &(vtc__ZN3ccc5EE5x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x3E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x4  : virtual ::ccc::AA5 {
  virtual void  pqr(); // _ZN3ccc5EE5x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE5x43abcEv
  virtual void  efg(); // _ZN3ccc5EE5x43efgEv
  ~EE5x4(); // tgen
  EE5x4(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x4E) C1{ VBC2{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE5x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x43pqrEv");}
void  ccc::EE5x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x43abcEv");}
void  ccc::EE5x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x43efgEv");}
ccc::EE5x4 ::~EE5x4(){ note_dtor("_ZN3ccc5EE5x4E", this);} // tgen
ccc::EE5x4 ::EE5x4(){ note_ctor("_ZN3ccc5EE5x4E", this);} // tgen
}
static void Test__ZN3ccc5EE5x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x4E, buf);
    ::ccc::EE5x4 *dp, &lv = *(dp=new (buf) ::ccc::EE5x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x4E);
    dp->::ccc::EE5x4::~EE5x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x4E(Test__ZN3ccc5EE5x4E, "_ZN3ccc5EE5x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x4C1Ev();
extern void _ZN3ccc5EE5x4D1Ev();
Name_Map name_map__ZN3ccc5EE5x4E[] = {
  NSPAIR(_ZN3ccc5EE5x4C1Ev),
  NSPAIR(_ZN3ccc5EE5x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x4E[];
extern void _ZN3ccc5EE5x43pqrEv();
extern void _ZN3ccc5EE5x43efgEv();
extern void _ZN3ccc5EE5x43abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x43abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x4E[] = {
  {&(_ZTVN3ccc5EE5x4E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x4E[];
Class_Descriptor cd__ZN3ccc5EE5x4E = {  "_ZN3ccc5EE5x4E", // class name
  bases__ZN3ccc5EE5x4E, 1,
  &(vtc__ZN3ccc5EE5x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x4E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x5  : virtual ::ccc::AA5 {
  virtual void  pqr(); // _ZN3ccc5EE5x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE5x53efgEv
  virtual void  abc(); // _ZN3ccc5EE5x53abcEv
  ~EE5x5(); // tgen
  EE5x5(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x5E) C1{ VBC2{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE5x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x53pqrEv");}
void  ccc::EE5x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x53efgEv");}
void  ccc::EE5x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x53abcEv");}
ccc::EE5x5 ::~EE5x5(){ note_dtor("_ZN3ccc5EE5x5E", this);} // tgen
ccc::EE5x5 ::EE5x5(){ note_ctor("_ZN3ccc5EE5x5E", this);} // tgen
}
static void Test__ZN3ccc5EE5x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x5E, buf);
    ::ccc::EE5x5 *dp, &lv = *(dp=new (buf) ::ccc::EE5x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x5E);
    dp->::ccc::EE5x5::~EE5x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x5E(Test__ZN3ccc5EE5x5E, "_ZN3ccc5EE5x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x5C1Ev();
extern void _ZN3ccc5EE5x5D1Ev();
Name_Map name_map__ZN3ccc5EE5x5E[] = {
  NSPAIR(_ZN3ccc5EE5x5C1Ev),
  NSPAIR(_ZN3ccc5EE5x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x5E[];
extern void _ZN3ccc5EE5x53pqrEv();
extern void _ZN3ccc5EE5x53efgEv();
extern void _ZN3ccc5EE5x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x5E[] = {
  {&(_ZTVN3ccc5EE5x5E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x5E[];
Class_Descriptor cd__ZN3ccc5EE5x5E = {  "_ZN3ccc5EE5x5E", // class name
  bases__ZN3ccc5EE5x5E, 1,
  &(vtc__ZN3ccc5EE5x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x5E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x6  : virtual ::ccc::AA5 {
  virtual void  abc(); // _ZN3ccc5EE5x63abcEv
  virtual void  efg(); // _ZN3ccc5EE5x63efgEv
  ~EE5x6(); // tgen
  EE5x6(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x6E) C1{ VBC2{ v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE5x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x63abcEv");}
void  ccc::EE5x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x63efgEv");}
ccc::EE5x6 ::~EE5x6(){ note_dtor("_ZN3ccc5EE5x6E", this);} // tgen
ccc::EE5x6 ::EE5x6(){ note_ctor("_ZN3ccc5EE5x6E", this);} // tgen
}
static void Test__ZN3ccc5EE5x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x6E, buf);
    ::ccc::EE5x6 *dp, &lv = *(dp=new (buf) ::ccc::EE5x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x6E);
    dp->::ccc::EE5x6::~EE5x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x6E(Test__ZN3ccc5EE5x6E, "_ZN3ccc5EE5x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x6C1Ev();
extern void _ZN3ccc5EE5x6D1Ev();
Name_Map name_map__ZN3ccc5EE5x6E[] = {
  NSPAIR(_ZN3ccc5EE5x6C1Ev),
  NSPAIR(_ZN3ccc5EE5x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc5EE5x63efgEv();
extern void _ZN3ccc5EE5x63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x6E[] = {
  {&(_ZTVN3ccc5EE5x6E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x6E[];
Class_Descriptor cd__ZN3ccc5EE5x6E = {  "_ZN3ccc5EE5x6E", // class name
  bases__ZN3ccc5EE5x6E, 1,
  &(vtc__ZN3ccc5EE5x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x6E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x7  : virtual ::ccc::AA5 {
  virtual void  abc(); // _ZN3ccc5EE5x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE5x73pqrEv
  ~EE5x7(); // tgen
  EE5x7(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x7E) C1{ VBC2{ v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE5x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x73abcEv");}
void  ccc::EE5x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x73pqrEv");}
ccc::EE5x7 ::~EE5x7(){ note_dtor("_ZN3ccc5EE5x7E", this);} // tgen
ccc::EE5x7 ::EE5x7(){ note_ctor("_ZN3ccc5EE5x7E", this);} // tgen
}
static void Test__ZN3ccc5EE5x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x7E, buf);
    ::ccc::EE5x7 *dp, &lv = *(dp=new (buf) ::ccc::EE5x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x7E);
    dp->::ccc::EE5x7::~EE5x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x7E(Test__ZN3ccc5EE5x7E, "_ZN3ccc5EE5x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x7C1Ev();
extern void _ZN3ccc5EE5x7D1Ev();
Name_Map name_map__ZN3ccc5EE5x7E[] = {
  NSPAIR(_ZN3ccc5EE5x7C1Ev),
  NSPAIR(_ZN3ccc5EE5x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x7E[];
extern void _ZN3ccc5EE5x73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc5EE5x73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x7E[] = {
  {&(_ZTVN3ccc5EE5x7E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x7E[];
Class_Descriptor cd__ZN3ccc5EE5x7E = {  "_ZN3ccc5EE5x7E", // class name
  bases__ZN3ccc5EE5x7E, 1,
  &(vtc__ZN3ccc5EE5x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x7E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x8  : virtual ::ccc::AA5 {
  virtual void  efg(); // _ZN3ccc5EE5x83efgEv
  virtual void  abc(); // _ZN3ccc5EE5x83abcEv
  ~EE5x8(); // tgen
  EE5x8(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x8E) C1{ VBC2{ v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE5x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x83efgEv");}
void  ccc::EE5x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE5x83abcEv");}
ccc::EE5x8 ::~EE5x8(){ note_dtor("_ZN3ccc5EE5x8E", this);} // tgen
ccc::EE5x8 ::EE5x8(){ note_ctor("_ZN3ccc5EE5x8E", this);} // tgen
}
static void Test__ZN3ccc5EE5x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x8E, buf);
    ::ccc::EE5x8 *dp, &lv = *(dp=new (buf) ::ccc::EE5x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x8E);
    dp->::ccc::EE5x8::~EE5x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x8E(Test__ZN3ccc5EE5x8E, "_ZN3ccc5EE5x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x8C1Ev();
extern void _ZN3ccc5EE5x8D1Ev();
Name_Map name_map__ZN3ccc5EE5x8E[] = {
  NSPAIR(_ZN3ccc5EE5x8C1Ev),
  NSPAIR(_ZN3ccc5EE5x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc5EE5x83efgEv();
extern void _ZN3ccc5EE5x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x8E[] = {
  {&(_ZTVN3ccc5EE5x8E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x8E[];
Class_Descriptor cd__ZN3ccc5EE5x8E = {  "_ZN3ccc5EE5x8E", // class name
  bases__ZN3ccc5EE5x8E, 1,
  &(vtc__ZN3ccc5EE5x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x8E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x9  : virtual ::ccc::AA5 {
  virtual void  efg(); // _ZN3ccc5EE5x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE5x93pqrEv
  ~EE5x9(); // tgen
  EE5x9(); // tgen
};
//SIG(-1 _ZN3ccc5EE5x9E) C1{ VBC2{ v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE5x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE5x93efgEv");}
void  ccc::EE5x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE5x93pqrEv");}
ccc::EE5x9 ::~EE5x9(){ note_dtor("_ZN3ccc5EE5x9E", this);} // tgen
ccc::EE5x9 ::EE5x9(){ note_ctor("_ZN3ccc5EE5x9E", this);} // tgen
}
static void Test__ZN3ccc5EE5x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE5x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE5x9E, buf);
    ::ccc::EE5x9 *dp, &lv = *(dp=new (buf) ::ccc::EE5x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE5x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE5x9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc5EE5x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE5x9E);
    dp->::ccc::EE5x9::~EE5x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE5x9E(Test__ZN3ccc5EE5x9E, "_ZN3ccc5EE5x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE5x9C1Ev();
extern void _ZN3ccc5EE5x9D1Ev();
Name_Map name_map__ZN3ccc5EE5x9E[] = {
  NSPAIR(_ZN3ccc5EE5x9C1Ev),
  NSPAIR(_ZN3ccc5EE5x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc5EE5x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE5x9E[];
extern void _ZN3ccc5EE5x93pqrEv();
extern void _ZN3ccc5EE5x93efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE5x9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE5x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE5x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE5x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE5x9E[] = {
  {&(_ZTVN3ccc5EE5x9E[6]),  6,9},
  {&(_ZTVN3ccc5EE5x9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc5EE5x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x9E[];
Class_Descriptor cd__ZN3ccc5EE5x9E = {  "_ZN3ccc5EE5x9E", // class name
  bases__ZN3ccc5EE5x9E, 1,
  &(vtc__ZN3ccc5EE5x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE5x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE5x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE5x9E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE5x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x10  : virtual ::ccc::AA5 {
  virtual void  pqr(); // _ZN3ccc6EE5x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE5x103abcEv
  ~EE5x10(); // tgen
  EE5x10(); // tgen
};
//SIG(-1 _ZN3ccc6EE5x10E) C1{ VBC2{ v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE5x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE5x103pqrEv");}
void  ccc::EE5x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE5x103abcEv");}
ccc::EE5x10 ::~EE5x10(){ note_dtor("_ZN3ccc6EE5x10E", this);} // tgen
ccc::EE5x10 ::EE5x10(){ note_ctor("_ZN3ccc6EE5x10E", this);} // tgen
}
static void Test__ZN3ccc6EE5x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE5x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE5x10E, buf);
    ::ccc::EE5x10 *dp, &lv = *(dp=new (buf) ::ccc::EE5x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE5x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE5x10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc6EE5x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE5x10E);
    dp->::ccc::EE5x10::~EE5x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE5x10E(Test__ZN3ccc6EE5x10E, "_ZN3ccc6EE5x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE5x10C1Ev();
extern void _ZN3ccc6EE5x10D1Ev();
Name_Map name_map__ZN3ccc6EE5x10E[] = {
  NSPAIR(_ZN3ccc6EE5x10C1Ev),
  NSPAIR(_ZN3ccc6EE5x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc6EE5x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE5x10E[];
extern void _ZN3ccc6EE5x103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc6EE5x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE5x10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE5x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE5x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE5x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE5x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE5x10E[] = {
  {&(_ZTVN3ccc6EE5x10E[6]),  6,9},
  {&(_ZTVN3ccc6EE5x10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE5x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE5x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE5x10E[];
Class_Descriptor cd__ZN3ccc6EE5x10E = {  "_ZN3ccc6EE5x10E", // class name
  bases__ZN3ccc6EE5x10E, 1,
  &(vtc__ZN3ccc6EE5x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE5x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE5x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE5x10E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE5x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x11  : virtual ::ccc::AA5 {
  virtual void  pqr(); // _ZN3ccc6EE5x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE5x113efgEv
  ~EE5x11(); // tgen
  EE5x11(); // tgen
};
//SIG(-1 _ZN3ccc6EE5x11E) C1{ VBC2{ v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE5x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE5x113pqrEv");}
void  ccc::EE5x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE5x113efgEv");}
ccc::EE5x11 ::~EE5x11(){ note_dtor("_ZN3ccc6EE5x11E", this);} // tgen
ccc::EE5x11 ::EE5x11(){ note_ctor("_ZN3ccc6EE5x11E", this);} // tgen
}
static void Test__ZN3ccc6EE5x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE5x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE5x11E, buf);
    ::ccc::EE5x11 *dp, &lv = *(dp=new (buf) ::ccc::EE5x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE5x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE5x11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc6EE5x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE5x11E);
    dp->::ccc::EE5x11::~EE5x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE5x11E(Test__ZN3ccc6EE5x11E, "_ZN3ccc6EE5x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE5x11C1Ev();
extern void _ZN3ccc6EE5x11D1Ev();
Name_Map name_map__ZN3ccc6EE5x11E[] = {
  NSPAIR(_ZN3ccc6EE5x11C1Ev),
  NSPAIR(_ZN3ccc6EE5x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc6EE5x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE5x11E[];
extern void _ZN3ccc6EE5x113pqrEv();
extern void _ZN3ccc6EE5x113efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE5x11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE5x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE5x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE5x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE5x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE5x11E[] = {
  {&(_ZTVN3ccc6EE5x11E[6]),  6,9},
  {&(_ZTVN3ccc6EE5x11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE5x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE5x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE5x11E[];
Class_Descriptor cd__ZN3ccc6EE5x11E = {  "_ZN3ccc6EE5x11E", // class name
  bases__ZN3ccc6EE5x11E, 1,
  &(vtc__ZN3ccc6EE5x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE5x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE5x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE5x11E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE5x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x12  : virtual ::ccc::AA5 {
  virtual void  abc(); // _ZN3ccc6EE5x123abcEv
  ~EE5x12(); // tgen
  EE5x12(); // tgen
};
//SIG(-1 _ZN3ccc6EE5x12E) C1{ VBC2{ v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::EE5x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE5x123abcEv");}
ccc::EE5x12 ::~EE5x12(){ note_dtor("_ZN3ccc6EE5x12E", this);} // tgen
ccc::EE5x12 ::EE5x12(){ note_ctor("_ZN3ccc6EE5x12E", this);} // tgen
}
static void Test__ZN3ccc6EE5x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE5x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE5x12E, buf);
    ::ccc::EE5x12 *dp, &lv = *(dp=new (buf) ::ccc::EE5x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE5x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE5x12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc6EE5x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE5x12E);
    dp->::ccc::EE5x12::~EE5x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE5x12E(Test__ZN3ccc6EE5x12E, "_ZN3ccc6EE5x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE5x12C1Ev();
extern void _ZN3ccc6EE5x12D1Ev();
Name_Map name_map__ZN3ccc6EE5x12E[] = {
  NSPAIR(_ZN3ccc6EE5x12C1Ev),
  NSPAIR(_ZN3ccc6EE5x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc6EE5x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE5x12E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc6EE5x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE5x12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE5x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE5x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE5x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE5x12E[] = {
  {&(_ZTVN3ccc6EE5x12E[6]),  6,9},
  {&(_ZTVN3ccc6EE5x12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE5x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE5x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE5x12E[];
Class_Descriptor cd__ZN3ccc6EE5x12E = {  "_ZN3ccc6EE5x12E", // class name
  bases__ZN3ccc6EE5x12E, 1,
  &(vtc__ZN3ccc6EE5x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE5x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE5x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE5x12E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE5x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x13  : virtual ::ccc::AA5 {
  virtual void  efg(); // _ZN3ccc6EE5x133efgEv
  ~EE5x13(); // tgen
  EE5x13(); // tgen
};
//SIG(-1 _ZN3ccc6EE5x13E) C1{ VBC2{ v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::EE5x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE5x133efgEv");}
ccc::EE5x13 ::~EE5x13(){ note_dtor("_ZN3ccc6EE5x13E", this);} // tgen
ccc::EE5x13 ::EE5x13(){ note_ctor("_ZN3ccc6EE5x13E", this);} // tgen
}
static void Test__ZN3ccc6EE5x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE5x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE5x13E, buf);
    ::ccc::EE5x13 *dp, &lv = *(dp=new (buf) ::ccc::EE5x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE5x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE5x13E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc6EE5x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE5x13E);
    dp->::ccc::EE5x13::~EE5x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE5x13E(Test__ZN3ccc6EE5x13E, "_ZN3ccc6EE5x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE5x13C1Ev();
extern void _ZN3ccc6EE5x13D1Ev();
Name_Map name_map__ZN3ccc6EE5x13E[] = {
  NSPAIR(_ZN3ccc6EE5x13C1Ev),
  NSPAIR(_ZN3ccc6EE5x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc6EE5x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE5x13E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc6EE5x133efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE5x13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE5x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE5x133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE5x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE5x13E[] = {
  {&(_ZTVN3ccc6EE5x13E[6]),  6,9},
  {&(_ZTVN3ccc6EE5x13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE5x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE5x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE5x13E[];
Class_Descriptor cd__ZN3ccc6EE5x13E = {  "_ZN3ccc6EE5x13E", // class name
  bases__ZN3ccc6EE5x13E, 1,
  &(vtc__ZN3ccc6EE5x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE5x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE5x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE5x13E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE5x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x14  : virtual ::ccc::AA5 {
  virtual void  pqr(); // _ZN3ccc6EE5x143pqrEv
  ~EE5x14(); // tgen
  EE5x14(); // tgen
};
//SIG(-1 _ZN3ccc6EE5x14E) C1{ VBC2{ v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::EE5x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE5x143pqrEv");}
ccc::EE5x14 ::~EE5x14(){ note_dtor("_ZN3ccc6EE5x14E", this);} // tgen
ccc::EE5x14 ::EE5x14(){ note_ctor("_ZN3ccc6EE5x14E", this);} // tgen
}
static void Test__ZN3ccc6EE5x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE5x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE5x14E, buf);
    ::ccc::EE5x14 *dp, &lv = *(dp=new (buf) ::ccc::EE5x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE5x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE5x14E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc6EE5x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE5x14E);
    dp->::ccc::EE5x14::~EE5x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE5x14E(Test__ZN3ccc6EE5x14E, "_ZN3ccc6EE5x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE5x14C1Ev();
extern void _ZN3ccc6EE5x14D1Ev();
Name_Map name_map__ZN3ccc6EE5x14E[] = {
  NSPAIR(_ZN3ccc6EE5x14C1Ev),
  NSPAIR(_ZN3ccc6EE5x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc6EE5x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE5x14E[];
extern void _ZN3ccc6EE5x143pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE5x14E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE5x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE5x143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE5x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE5x14E[] = {
  {&(_ZTVN3ccc6EE5x14E[6]),  6,9},
  {&(_ZTVN3ccc6EE5x14E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE5x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE5x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE5x14E[];
Class_Descriptor cd__ZN3ccc6EE5x14E = {  "_ZN3ccc6EE5x14E", // class name
  bases__ZN3ccc6EE5x14E, 1,
  &(vtc__ZN3ccc6EE5x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE5x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE5x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE5x14E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE5x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE5x15  : virtual ::ccc::AA5 {
  ~EE5x15(); // tgen
  EE5x15(); // tgen
};
//SIG(-1 _ZN3ccc6EE5x15E) C1{ VBC2{ v1 v2 v3}}
}
namespace ccc { 
ccc::EE5x15 ::~EE5x15(){ note_dtor("_ZN3ccc6EE5x15E", this);} // tgen
ccc::EE5x15 ::EE5x15(){ note_ctor("_ZN3ccc6EE5x15E", this);} // tgen
}
static void Test__ZN3ccc6EE5x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE5x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE5x15E, buf);
    ::ccc::EE5x15 *dp, &lv = *(dp=new (buf) ::ccc::EE5x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE5x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE5x15E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc6EE5x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE5x15E);
    dp->::ccc::EE5x15::~EE5x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE5x15E(Test__ZN3ccc6EE5x15E, "_ZN3ccc6EE5x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE5x15C1Ev();
extern void _ZN3ccc6EE5x15D1Ev();
Name_Map name_map__ZN3ccc6EE5x15E[] = {
  NSPAIR(_ZN3ccc6EE5x15C1Ev),
  NSPAIR(_ZN3ccc6EE5x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
static Base_Class bases__ZN3ccc6EE5x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE5x15E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE5x15E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE5x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE5x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE5x15E[] = {
  {&(_ZTVN3ccc6EE5x15E[6]),  6,9},
  {&(_ZTVN3ccc6EE5x15E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc6EE5x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE5x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE5x15E[];
Class_Descriptor cd__ZN3ccc6EE5x15E = {  "_ZN3ccc6EE5x15E", // class name
  bases__ZN3ccc6EE5x15E, 1,
  &(vtc__ZN3ccc6EE5x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE5x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE5x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE5x15E),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE5x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA6  {
  virtual void  abc(); // _ZN3ccc3AA63abcEv
  virtual void  efg(); // _ZN3ccc3AA63efgEv
  ~AA6(); // tgen
  AA6(); // tgen
};
//SIG(-1 _ZN3ccc3AA6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA6 ::abc(){vfunc_called(this, "_ZN3ccc3AA63abcEv");}
void  ccc::AA6 ::efg(){vfunc_called(this, "_ZN3ccc3AA63efgEv");}
ccc::AA6 ::~AA6(){ note_dtor("_ZN3ccc3AA6E", this);} // tgen
ccc::AA6 ::AA6(){ note_ctor("_ZN3ccc3AA6E", this);} // tgen
}
static void Test__ZN3ccc3AA6E()
{
  extern Class_Descriptor cd__ZN3ccc3AA6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA6E, buf);
    ::ccc::AA6 *dp, &lv = *(dp=new (buf) ::ccc::AA6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA6E)");
    test_class_info(&lv, &cd__ZN3ccc3AA6E);
    dp->::ccc::AA6::~AA6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA6E(Test__ZN3ccc3AA6E, "_ZN3ccc3AA6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA6C1Ev();
extern void _ZN3ccc3AA6D1Ev();
Name_Map name_map__ZN3ccc3AA6E[] = {
  NSPAIR(_ZN3ccc3AA6C1Ev),
  NSPAIR(_ZN3ccc3AA6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc3AA63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
Class_Descriptor cd__ZN3ccc3AA6E = {  "_ZN3ccc3AA6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB6  {
  virtual void  abc(); // _ZN3ccc3BB63abcEv
  virtual void  efg(); // _ZN3ccc3BB63efgEv
  ~BB6(); // tgen
  BB6(); // tgen
};
//SIG(1 _ZN3ccc3BB6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB6 ::abc(){vfunc_called(this, "_ZN3ccc3BB63abcEv");}
void  ccc::BB6 ::efg(){vfunc_called(this, "_ZN3ccc3BB63efgEv");}
ccc::BB6 ::~BB6(){ note_dtor("_ZN3ccc3BB6E", this);} // tgen
ccc::BB6 ::BB6(){ note_ctor("_ZN3ccc3BB6E", this);} // tgen
}
static void Test__ZN3ccc3BB6E()
{
  extern Class_Descriptor cd__ZN3ccc3BB6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB6E, buf);
    ::ccc::BB6 *dp, &lv = *(dp=new (buf) ::ccc::BB6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB6E)");
    test_class_info(&lv, &cd__ZN3ccc3BB6E);
    dp->::ccc::BB6::~BB6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB6E(Test__ZN3ccc3BB6E, "_ZN3ccc3BB6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB6C1Ev();
extern void _ZN3ccc3BB6D1Ev();
Name_Map name_map__ZN3ccc3BB6E[] = {
  NSPAIR(_ZN3ccc3BB6C1Ev),
  NSPAIR(_ZN3ccc3BB6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
Class_Descriptor cd__ZN3ccc3BB6E = {  "_ZN3ccc3BB6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x0  : virtual ::ccc::AA6 {
  virtual void  abc(); // _ZN3ccc5EE6x03abcEv
  virtual void  efg(); // _ZN3ccc5EE6x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE6x03pqrEv
  ~EE6x0(); // tgen
  EE6x0(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x0E) C1{ VBC2{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE6x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x03abcEv");}
void  ccc::EE6x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x03efgEv");}
void  ccc::EE6x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x03pqrEv");}
ccc::EE6x0 ::~EE6x0(){ note_dtor("_ZN3ccc5EE6x0E", this);} // tgen
ccc::EE6x0 ::EE6x0(){ note_ctor("_ZN3ccc5EE6x0E", this);} // tgen
}
static void Test__ZN3ccc5EE6x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x0E, buf);
    ::ccc::EE6x0 *dp, &lv = *(dp=new (buf) ::ccc::EE6x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x0E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x0E);
    dp->::ccc::EE6x0::~EE6x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x0E(Test__ZN3ccc5EE6x0E, "_ZN3ccc5EE6x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x0C1Ev();
extern void _ZN3ccc5EE6x0D1Ev();
Name_Map name_map__ZN3ccc5EE6x0E[] = {
  NSPAIR(_ZN3ccc5EE6x0C1Ev),
  NSPAIR(_ZN3ccc5EE6x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x0E[];
extern void _ZN3ccc5EE6x03abcEv();
extern void _ZN3ccc5EE6x03efgEv();
extern void _ZN3ccc5EE6x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x0E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x0E[] = {
  {&(_ZTVN3ccc5EE6x0E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x0E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x0E[];
Class_Descriptor cd__ZN3ccc5EE6x0E = {  "_ZN3ccc5EE6x0E", // class name
  bases__ZN3ccc5EE6x0E, 1,
  &(vtc__ZN3ccc5EE6x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x0E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x1  : virtual ::ccc::AA6 {
  virtual void  abc(); // _ZN3ccc5EE6x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE6x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE6x13efgEv
  ~EE6x1(); // tgen
  EE6x1(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x1E) C1{ VBC2{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE6x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x13abcEv");}
void  ccc::EE6x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x13pqrEv");}
void  ccc::EE6x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x13efgEv");}
ccc::EE6x1 ::~EE6x1(){ note_dtor("_ZN3ccc5EE6x1E", this);} // tgen
ccc::EE6x1 ::EE6x1(){ note_ctor("_ZN3ccc5EE6x1E", this);} // tgen
}
static void Test__ZN3ccc5EE6x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x1E, buf);
    ::ccc::EE6x1 *dp, &lv = *(dp=new (buf) ::ccc::EE6x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x1E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x1E);
    dp->::ccc::EE6x1::~EE6x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x1E(Test__ZN3ccc5EE6x1E, "_ZN3ccc5EE6x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x1C1Ev();
extern void _ZN3ccc5EE6x1D1Ev();
Name_Map name_map__ZN3ccc5EE6x1E[] = {
  NSPAIR(_ZN3ccc5EE6x1C1Ev),
  NSPAIR(_ZN3ccc5EE6x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x1E[];
extern void _ZN3ccc5EE6x13abcEv();
extern void _ZN3ccc5EE6x13efgEv();
extern void _ZN3ccc5EE6x13pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x1E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x13pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x1E[] = {
  {&(_ZTVN3ccc5EE6x1E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x1E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x1E[];
Class_Descriptor cd__ZN3ccc5EE6x1E = {  "_ZN3ccc5EE6x1E", // class name
  bases__ZN3ccc5EE6x1E, 1,
  &(vtc__ZN3ccc5EE6x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x1E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x2  : virtual ::ccc::AA6 {
  virtual void  efg(); // _ZN3ccc5EE6x23efgEv
  virtual void  abc(); // _ZN3ccc5EE6x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE6x23pqrEv
  ~EE6x2(); // tgen
  EE6x2(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x2E) C1{ VBC2{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE6x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x23efgEv");}
void  ccc::EE6x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x23abcEv");}
void  ccc::EE6x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x23pqrEv");}
ccc::EE6x2 ::~EE6x2(){ note_dtor("_ZN3ccc5EE6x2E", this);} // tgen
ccc::EE6x2 ::EE6x2(){ note_ctor("_ZN3ccc5EE6x2E", this);} // tgen
}
static void Test__ZN3ccc5EE6x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x2E, buf);
    ::ccc::EE6x2 *dp, &lv = *(dp=new (buf) ::ccc::EE6x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x2E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x2E);
    dp->::ccc::EE6x2::~EE6x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x2E(Test__ZN3ccc5EE6x2E, "_ZN3ccc5EE6x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x2C1Ev();
extern void _ZN3ccc5EE6x2D1Ev();
Name_Map name_map__ZN3ccc5EE6x2E[] = {
  NSPAIR(_ZN3ccc5EE6x2C1Ev),
  NSPAIR(_ZN3ccc5EE6x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x2E[];
extern void _ZN3ccc5EE6x23abcEv();
extern void _ZN3ccc5EE6x23efgEv();
extern void _ZN3ccc5EE6x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x2E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x2E[] = {
  {&(_ZTVN3ccc5EE6x2E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x2E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x2E[];
Class_Descriptor cd__ZN3ccc5EE6x2E = {  "_ZN3ccc5EE6x2E", // class name
  bases__ZN3ccc5EE6x2E, 1,
  &(vtc__ZN3ccc5EE6x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x2E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x3  : virtual ::ccc::AA6 {
  virtual void  efg(); // _ZN3ccc5EE6x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE6x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE6x33abcEv
  ~EE6x3(); // tgen
  EE6x3(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x3E) C1{ VBC2{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE6x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x33efgEv");}
void  ccc::EE6x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x33pqrEv");}
void  ccc::EE6x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x33abcEv");}
ccc::EE6x3 ::~EE6x3(){ note_dtor("_ZN3ccc5EE6x3E", this);} // tgen
ccc::EE6x3 ::EE6x3(){ note_ctor("_ZN3ccc5EE6x3E", this);} // tgen
}
static void Test__ZN3ccc5EE6x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x3E, buf);
    ::ccc::EE6x3 *dp, &lv = *(dp=new (buf) ::ccc::EE6x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x3E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x3E);
    dp->::ccc::EE6x3::~EE6x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x3E(Test__ZN3ccc5EE6x3E, "_ZN3ccc5EE6x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x3C1Ev();
extern void _ZN3ccc5EE6x3D1Ev();
Name_Map name_map__ZN3ccc5EE6x3E[] = {
  NSPAIR(_ZN3ccc5EE6x3C1Ev),
  NSPAIR(_ZN3ccc5EE6x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x3E[];
extern void _ZN3ccc5EE6x33abcEv();
extern void _ZN3ccc5EE6x33efgEv();
extern void _ZN3ccc5EE6x33pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x3E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x33pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x3E[] = {
  {&(_ZTVN3ccc5EE6x3E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x3E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x3E[];
Class_Descriptor cd__ZN3ccc5EE6x3E = {  "_ZN3ccc5EE6x3E", // class name
  bases__ZN3ccc5EE6x3E, 1,
  &(vtc__ZN3ccc5EE6x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x3E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x4  : virtual ::ccc::AA6 {
  virtual void  pqr(); // _ZN3ccc5EE6x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE6x43abcEv
  virtual void  efg(); // _ZN3ccc5EE6x43efgEv
  ~EE6x4(); // tgen
  EE6x4(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x4E) C1{ VBC2{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE6x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x43pqrEv");}
void  ccc::EE6x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x43abcEv");}
void  ccc::EE6x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x43efgEv");}
ccc::EE6x4 ::~EE6x4(){ note_dtor("_ZN3ccc5EE6x4E", this);} // tgen
ccc::EE6x4 ::EE6x4(){ note_ctor("_ZN3ccc5EE6x4E", this);} // tgen
}
static void Test__ZN3ccc5EE6x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x4E, buf);
    ::ccc::EE6x4 *dp, &lv = *(dp=new (buf) ::ccc::EE6x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x4E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x4E);
    dp->::ccc::EE6x4::~EE6x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x4E(Test__ZN3ccc5EE6x4E, "_ZN3ccc5EE6x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x4C1Ev();
extern void _ZN3ccc5EE6x4D1Ev();
Name_Map name_map__ZN3ccc5EE6x4E[] = {
  NSPAIR(_ZN3ccc5EE6x4C1Ev),
  NSPAIR(_ZN3ccc5EE6x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x4E[];
extern void _ZN3ccc5EE6x43abcEv();
extern void _ZN3ccc5EE6x43efgEv();
extern void _ZN3ccc5EE6x43pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x4E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x43pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x4E[] = {
  {&(_ZTVN3ccc5EE6x4E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x4E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x4E[];
Class_Descriptor cd__ZN3ccc5EE6x4E = {  "_ZN3ccc5EE6x4E", // class name
  bases__ZN3ccc5EE6x4E, 1,
  &(vtc__ZN3ccc5EE6x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x4E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x5  : virtual ::ccc::AA6 {
  virtual void  pqr(); // _ZN3ccc5EE6x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE6x53efgEv
  virtual void  abc(); // _ZN3ccc5EE6x53abcEv
  ~EE6x5(); // tgen
  EE6x5(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x5E) C1{ VBC2{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE6x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x53pqrEv");}
void  ccc::EE6x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x53efgEv");}
void  ccc::EE6x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x53abcEv");}
ccc::EE6x5 ::~EE6x5(){ note_dtor("_ZN3ccc5EE6x5E", this);} // tgen
ccc::EE6x5 ::EE6x5(){ note_ctor("_ZN3ccc5EE6x5E", this);} // tgen
}
static void Test__ZN3ccc5EE6x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x5E, buf);
    ::ccc::EE6x5 *dp, &lv = *(dp=new (buf) ::ccc::EE6x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x5E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x5E);
    dp->::ccc::EE6x5::~EE6x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x5E(Test__ZN3ccc5EE6x5E, "_ZN3ccc5EE6x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x5C1Ev();
extern void _ZN3ccc5EE6x5D1Ev();
Name_Map name_map__ZN3ccc5EE6x5E[] = {
  NSPAIR(_ZN3ccc5EE6x5C1Ev),
  NSPAIR(_ZN3ccc5EE6x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x5E[];
extern void _ZN3ccc5EE6x53abcEv();
extern void _ZN3ccc5EE6x53efgEv();
extern void _ZN3ccc5EE6x53pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x5E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x53pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x5E[] = {
  {&(_ZTVN3ccc5EE6x5E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x5E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x5E[];
Class_Descriptor cd__ZN3ccc5EE6x5E = {  "_ZN3ccc5EE6x5E", // class name
  bases__ZN3ccc5EE6x5E, 1,
  &(vtc__ZN3ccc5EE6x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x5E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x6  : virtual ::ccc::AA6 {
  virtual void  abc(); // _ZN3ccc5EE6x63abcEv
  virtual void  efg(); // _ZN3ccc5EE6x63efgEv
  ~EE6x6(); // tgen
  EE6x6(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x6E) C1{ VBC2{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE6x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x63abcEv");}
void  ccc::EE6x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x63efgEv");}
ccc::EE6x6 ::~EE6x6(){ note_dtor("_ZN3ccc5EE6x6E", this);} // tgen
ccc::EE6x6 ::EE6x6(){ note_ctor("_ZN3ccc5EE6x6E", this);} // tgen
}
static void Test__ZN3ccc5EE6x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x6E, buf);
    ::ccc::EE6x6 *dp, &lv = *(dp=new (buf) ::ccc::EE6x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x6E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x6E);
    dp->::ccc::EE6x6::~EE6x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x6E(Test__ZN3ccc5EE6x6E, "_ZN3ccc5EE6x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x6C1Ev();
extern void _ZN3ccc5EE6x6D1Ev();
Name_Map name_map__ZN3ccc5EE6x6E[] = {
  NSPAIR(_ZN3ccc5EE6x6C1Ev),
  NSPAIR(_ZN3ccc5EE6x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x6E[];
extern void _ZN3ccc5EE6x63abcEv();
extern void _ZN3ccc5EE6x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x6E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x6E[] = {
  {&(_ZTVN3ccc5EE6x6E[5]),  5,7},
  {&(_ZTVN3ccc5EE6x6E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x6E[];
Class_Descriptor cd__ZN3ccc5EE6x6E = {  "_ZN3ccc5EE6x6E", // class name
  bases__ZN3ccc5EE6x6E, 1,
  &(vtc__ZN3ccc5EE6x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x6E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x7  : virtual ::ccc::AA6 {
  virtual void  abc(); // _ZN3ccc5EE6x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE6x73pqrEv
  ~EE6x7(); // tgen
  EE6x7(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x7E) C1{ VBC2{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE6x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x73abcEv");}
void  ccc::EE6x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x73pqrEv");}
ccc::EE6x7 ::~EE6x7(){ note_dtor("_ZN3ccc5EE6x7E", this);} // tgen
ccc::EE6x7 ::EE6x7(){ note_ctor("_ZN3ccc5EE6x7E", this);} // tgen
}
static void Test__ZN3ccc5EE6x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x7E, buf);
    ::ccc::EE6x7 *dp, &lv = *(dp=new (buf) ::ccc::EE6x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x7E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x7E);
    dp->::ccc::EE6x7::~EE6x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x7E(Test__ZN3ccc5EE6x7E, "_ZN3ccc5EE6x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x7C1Ev();
extern void _ZN3ccc5EE6x7D1Ev();
Name_Map name_map__ZN3ccc5EE6x7E[] = {
  NSPAIR(_ZN3ccc5EE6x7C1Ev),
  NSPAIR(_ZN3ccc5EE6x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x7E[];
extern void _ZN3ccc5EE6x73abcEv();
extern void _ZN3ccc3AA63efgEv();
extern void _ZN3ccc5EE6x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x7E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x7E[] = {
  {&(_ZTVN3ccc5EE6x7E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x7E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x7E[];
Class_Descriptor cd__ZN3ccc5EE6x7E = {  "_ZN3ccc5EE6x7E", // class name
  bases__ZN3ccc5EE6x7E, 1,
  &(vtc__ZN3ccc5EE6x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x7E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x8  : virtual ::ccc::AA6 {
  virtual void  efg(); // _ZN3ccc5EE6x83efgEv
  virtual void  abc(); // _ZN3ccc5EE6x83abcEv
  ~EE6x8(); // tgen
  EE6x8(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x8E) C1{ VBC2{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE6x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x83efgEv");}
void  ccc::EE6x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE6x83abcEv");}
ccc::EE6x8 ::~EE6x8(){ note_dtor("_ZN3ccc5EE6x8E", this);} // tgen
ccc::EE6x8 ::EE6x8(){ note_ctor("_ZN3ccc5EE6x8E", this);} // tgen
}
static void Test__ZN3ccc5EE6x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x8E, buf);
    ::ccc::EE6x8 *dp, &lv = *(dp=new (buf) ::ccc::EE6x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x8E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x8E);
    dp->::ccc::EE6x8::~EE6x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x8E(Test__ZN3ccc5EE6x8E, "_ZN3ccc5EE6x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x8C1Ev();
extern void _ZN3ccc5EE6x8D1Ev();
Name_Map name_map__ZN3ccc5EE6x8E[] = {
  NSPAIR(_ZN3ccc5EE6x8C1Ev),
  NSPAIR(_ZN3ccc5EE6x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x8E[];
extern void _ZN3ccc5EE6x83abcEv();
extern void _ZN3ccc5EE6x83efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x8E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE6x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x83efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x8E[] = {
  {&(_ZTVN3ccc5EE6x8E[5]),  5,7},
  {&(_ZTVN3ccc5EE6x8E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x8E[];
Class_Descriptor cd__ZN3ccc5EE6x8E = {  "_ZN3ccc5EE6x8E", // class name
  bases__ZN3ccc5EE6x8E, 1,
  &(vtc__ZN3ccc5EE6x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x8E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x9  : virtual ::ccc::AA6 {
  virtual void  efg(); // _ZN3ccc5EE6x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE6x93pqrEv
  ~EE6x9(); // tgen
  EE6x9(); // tgen
};
//SIG(-1 _ZN3ccc5EE6x9E) C1{ VBC2{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE6x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE6x93efgEv");}
void  ccc::EE6x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE6x93pqrEv");}
ccc::EE6x9 ::~EE6x9(){ note_dtor("_ZN3ccc5EE6x9E", this);} // tgen
ccc::EE6x9 ::EE6x9(){ note_ctor("_ZN3ccc5EE6x9E", this);} // tgen
}
static void Test__ZN3ccc5EE6x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE6x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE6x9E, buf);
    ::ccc::EE6x9 *dp, &lv = *(dp=new (buf) ::ccc::EE6x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE6x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE6x9E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc5EE6x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE6x9E);
    dp->::ccc::EE6x9::~EE6x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE6x9E(Test__ZN3ccc5EE6x9E, "_ZN3ccc5EE6x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE6x9C1Ev();
extern void _ZN3ccc5EE6x9D1Ev();
Name_Map name_map__ZN3ccc5EE6x9E[] = {
  NSPAIR(_ZN3ccc5EE6x9C1Ev),
  NSPAIR(_ZN3ccc5EE6x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc5EE6x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE6x9E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc5EE6x93efgEv();
extern void _ZN3ccc5EE6x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE6x9E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE6x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE6x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE6x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE6x9E[] = {
  {&(_ZTVN3ccc5EE6x9E[5]),  5,8},
  {&(_ZTVN3ccc5EE6x9E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE6x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE6x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE6x9E[];
Class_Descriptor cd__ZN3ccc5EE6x9E = {  "_ZN3ccc5EE6x9E", // class name
  bases__ZN3ccc5EE6x9E, 1,
  &(vtc__ZN3ccc5EE6x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE6x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE6x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE6x9E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE6x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x10  : virtual ::ccc::AA6 {
  virtual void  pqr(); // _ZN3ccc6EE6x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE6x103abcEv
  ~EE6x10(); // tgen
  EE6x10(); // tgen
};
//SIG(-1 _ZN3ccc6EE6x10E) C1{ VBC2{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE6x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE6x103pqrEv");}
void  ccc::EE6x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE6x103abcEv");}
ccc::EE6x10 ::~EE6x10(){ note_dtor("_ZN3ccc6EE6x10E", this);} // tgen
ccc::EE6x10 ::EE6x10(){ note_ctor("_ZN3ccc6EE6x10E", this);} // tgen
}
static void Test__ZN3ccc6EE6x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE6x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE6x10E, buf);
    ::ccc::EE6x10 *dp, &lv = *(dp=new (buf) ::ccc::EE6x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE6x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE6x10E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc6EE6x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE6x10E);
    dp->::ccc::EE6x10::~EE6x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE6x10E(Test__ZN3ccc6EE6x10E, "_ZN3ccc6EE6x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE6x10C1Ev();
extern void _ZN3ccc6EE6x10D1Ev();
Name_Map name_map__ZN3ccc6EE6x10E[] = {
  NSPAIR(_ZN3ccc6EE6x10C1Ev),
  NSPAIR(_ZN3ccc6EE6x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc6EE6x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE6x10E[];
extern void _ZN3ccc6EE6x103abcEv();
extern void _ZN3ccc3AA63efgEv();
extern void _ZN3ccc6EE6x103pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE6x10E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE6x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE6x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE6x103pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE6x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE6x10E[] = {
  {&(_ZTVN3ccc6EE6x10E[5]),  5,8},
  {&(_ZTVN3ccc6EE6x10E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE6x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE6x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE6x10E[];
Class_Descriptor cd__ZN3ccc6EE6x10E = {  "_ZN3ccc6EE6x10E", // class name
  bases__ZN3ccc6EE6x10E, 1,
  &(vtc__ZN3ccc6EE6x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE6x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE6x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE6x10E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE6x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x11  : virtual ::ccc::AA6 {
  virtual void  pqr(); // _ZN3ccc6EE6x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE6x113efgEv
  ~EE6x11(); // tgen
  EE6x11(); // tgen
};
//SIG(-1 _ZN3ccc6EE6x11E) C1{ VBC2{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE6x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE6x113pqrEv");}
void  ccc::EE6x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE6x113efgEv");}
ccc::EE6x11 ::~EE6x11(){ note_dtor("_ZN3ccc6EE6x11E", this);} // tgen
ccc::EE6x11 ::EE6x11(){ note_ctor("_ZN3ccc6EE6x11E", this);} // tgen
}
static void Test__ZN3ccc6EE6x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE6x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE6x11E, buf);
    ::ccc::EE6x11 *dp, &lv = *(dp=new (buf) ::ccc::EE6x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE6x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE6x11E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc6EE6x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE6x11E);
    dp->::ccc::EE6x11::~EE6x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE6x11E(Test__ZN3ccc6EE6x11E, "_ZN3ccc6EE6x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE6x11C1Ev();
extern void _ZN3ccc6EE6x11D1Ev();
Name_Map name_map__ZN3ccc6EE6x11E[] = {
  NSPAIR(_ZN3ccc6EE6x11C1Ev),
  NSPAIR(_ZN3ccc6EE6x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc6EE6x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE6x11E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc6EE6x113efgEv();
extern void _ZN3ccc6EE6x113pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE6x11E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE6x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE6x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE6x113pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE6x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE6x11E[] = {
  {&(_ZTVN3ccc6EE6x11E[5]),  5,8},
  {&(_ZTVN3ccc6EE6x11E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE6x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE6x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE6x11E[];
Class_Descriptor cd__ZN3ccc6EE6x11E = {  "_ZN3ccc6EE6x11E", // class name
  bases__ZN3ccc6EE6x11E, 1,
  &(vtc__ZN3ccc6EE6x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE6x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE6x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE6x11E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE6x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x12  : virtual ::ccc::AA6 {
  virtual void  abc(); // _ZN3ccc6EE6x123abcEv
  ~EE6x12(); // tgen
  EE6x12(); // tgen
};
//SIG(-1 _ZN3ccc6EE6x12E) C1{ VBC2{ v1 v2} v1}
}
namespace ccc { 
void  ccc::EE6x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE6x123abcEv");}
ccc::EE6x12 ::~EE6x12(){ note_dtor("_ZN3ccc6EE6x12E", this);} // tgen
ccc::EE6x12 ::EE6x12(){ note_ctor("_ZN3ccc6EE6x12E", this);} // tgen
}
static void Test__ZN3ccc6EE6x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE6x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE6x12E, buf);
    ::ccc::EE6x12 *dp, &lv = *(dp=new (buf) ::ccc::EE6x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE6x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE6x12E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc6EE6x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE6x12E);
    dp->::ccc::EE6x12::~EE6x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE6x12E(Test__ZN3ccc6EE6x12E, "_ZN3ccc6EE6x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE6x12C1Ev();
extern void _ZN3ccc6EE6x12D1Ev();
Name_Map name_map__ZN3ccc6EE6x12E[] = {
  NSPAIR(_ZN3ccc6EE6x12C1Ev),
  NSPAIR(_ZN3ccc6EE6x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc6EE6x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE6x12E[];
extern void _ZN3ccc6EE6x123abcEv();
extern void _ZN3ccc3AA63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE6x12E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE6x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE6x123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE6x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE6x12E[] = {
  {&(_ZTVN3ccc6EE6x12E[5]),  5,7},
  {&(_ZTVN3ccc6EE6x12E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE6x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE6x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE6x12E[];
Class_Descriptor cd__ZN3ccc6EE6x12E = {  "_ZN3ccc6EE6x12E", // class name
  bases__ZN3ccc6EE6x12E, 1,
  &(vtc__ZN3ccc6EE6x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE6x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE6x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE6x12E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE6x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x13  : virtual ::ccc::AA6 {
  virtual void  efg(); // _ZN3ccc6EE6x133efgEv
  ~EE6x13(); // tgen
  EE6x13(); // tgen
};
//SIG(-1 _ZN3ccc6EE6x13E) C1{ VBC2{ v2 v1} v1}
}
namespace ccc { 
void  ccc::EE6x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE6x133efgEv");}
ccc::EE6x13 ::~EE6x13(){ note_dtor("_ZN3ccc6EE6x13E", this);} // tgen
ccc::EE6x13 ::EE6x13(){ note_ctor("_ZN3ccc6EE6x13E", this);} // tgen
}
static void Test__ZN3ccc6EE6x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE6x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE6x13E, buf);
    ::ccc::EE6x13 *dp, &lv = *(dp=new (buf) ::ccc::EE6x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE6x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE6x13E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc6EE6x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE6x13E);
    dp->::ccc::EE6x13::~EE6x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE6x13E(Test__ZN3ccc6EE6x13E, "_ZN3ccc6EE6x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE6x13C1Ev();
extern void _ZN3ccc6EE6x13D1Ev();
Name_Map name_map__ZN3ccc6EE6x13E[] = {
  NSPAIR(_ZN3ccc6EE6x13C1Ev),
  NSPAIR(_ZN3ccc6EE6x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc6EE6x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE6x13E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc6EE6x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE6x13E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE6x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE6x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE6x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE6x13E[] = {
  {&(_ZTVN3ccc6EE6x13E[5]),  5,7},
  {&(_ZTVN3ccc6EE6x13E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE6x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE6x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE6x13E[];
Class_Descriptor cd__ZN3ccc6EE6x13E = {  "_ZN3ccc6EE6x13E", // class name
  bases__ZN3ccc6EE6x13E, 1,
  &(vtc__ZN3ccc6EE6x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE6x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE6x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE6x13E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE6x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x14  : virtual ::ccc::AA6 {
  virtual void  pqr(); // _ZN3ccc6EE6x143pqrEv
  ~EE6x14(); // tgen
  EE6x14(); // tgen
};
//SIG(-1 _ZN3ccc6EE6x14E) C1{ VBC2{ v2 v3} v1}
}
namespace ccc { 
void  ccc::EE6x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE6x143pqrEv");}
ccc::EE6x14 ::~EE6x14(){ note_dtor("_ZN3ccc6EE6x14E", this);} // tgen
ccc::EE6x14 ::EE6x14(){ note_ctor("_ZN3ccc6EE6x14E", this);} // tgen
}
static void Test__ZN3ccc6EE6x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE6x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE6x14E, buf);
    ::ccc::EE6x14 *dp, &lv = *(dp=new (buf) ::ccc::EE6x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE6x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE6x14E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc6EE6x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE6x14E);
    dp->::ccc::EE6x14::~EE6x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE6x14E(Test__ZN3ccc6EE6x14E, "_ZN3ccc6EE6x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE6x14C1Ev();
extern void _ZN3ccc6EE6x14D1Ev();
Name_Map name_map__ZN3ccc6EE6x14E[] = {
  NSPAIR(_ZN3ccc6EE6x14C1Ev),
  NSPAIR(_ZN3ccc6EE6x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc6EE6x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE6x14E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc3AA63efgEv();
extern void _ZN3ccc6EE6x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE6x14E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE6x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE6x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE6x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE6x14E[] = {
  {&(_ZTVN3ccc6EE6x14E[5]),  5,8},
  {&(_ZTVN3ccc6EE6x14E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE6x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE6x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE6x14E[];
Class_Descriptor cd__ZN3ccc6EE6x14E = {  "_ZN3ccc6EE6x14E", // class name
  bases__ZN3ccc6EE6x14E, 1,
  &(vtc__ZN3ccc6EE6x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE6x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE6x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE6x14E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE6x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE6x15  : virtual ::ccc::AA6 {
  ~EE6x15(); // tgen
  EE6x15(); // tgen
};
//SIG(-1 _ZN3ccc6EE6x15E) C1{ VBC2{ v1 v2}}
}
namespace ccc { 
ccc::EE6x15 ::~EE6x15(){ note_dtor("_ZN3ccc6EE6x15E", this);} // tgen
ccc::EE6x15 ::EE6x15(){ note_ctor("_ZN3ccc6EE6x15E", this);} // tgen
}
static void Test__ZN3ccc6EE6x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE6x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE6x15E, buf);
    ::ccc::EE6x15 *dp, &lv = *(dp=new (buf) ::ccc::EE6x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE6x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE6x15E)");
    check_base_class_offset(lv, (::ccc::AA6*), 0, "_ZN3ccc6EE6x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE6x15E);
    dp->::ccc::EE6x15::~EE6x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE6x15E(Test__ZN3ccc6EE6x15E, "_ZN3ccc6EE6x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE6x15C1Ev();
extern void _ZN3ccc6EE6x15D1Ev();
Name_Map name_map__ZN3ccc6EE6x15E[] = {
  NSPAIR(_ZN3ccc6EE6x15C1Ev),
  NSPAIR(_ZN3ccc6EE6x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA6E;
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
static Base_Class bases__ZN3ccc6EE6x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE6x15E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc3AA63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE6x15E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE6x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE6x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE6x15E[] = {
  {&(_ZTVN3ccc6EE6x15E[5]),  5,7},
  {&(_ZTVN3ccc6EE6x15E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE6x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE6x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE6x15E[];
Class_Descriptor cd__ZN3ccc6EE6x15E = {  "_ZN3ccc6EE6x15E", // class name
  bases__ZN3ccc6EE6x15E, 1,
  &(vtc__ZN3ccc6EE6x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE6x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE6x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE6x15E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE6x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA7  {
  virtual void  abc(); // _ZN3ccc3AA73abcEv
  virtual void  pqr(); // _ZN3ccc3AA73pqrEv
  ~AA7(); // tgen
  AA7(); // tgen
};
//SIG(-1 _ZN3ccc3AA7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA7 ::abc(){vfunc_called(this, "_ZN3ccc3AA73abcEv");}
void  ccc::AA7 ::pqr(){vfunc_called(this, "_ZN3ccc3AA73pqrEv");}
ccc::AA7 ::~AA7(){ note_dtor("_ZN3ccc3AA7E", this);} // tgen
ccc::AA7 ::AA7(){ note_ctor("_ZN3ccc3AA7E", this);} // tgen
}
static void Test__ZN3ccc3AA7E()
{
  extern Class_Descriptor cd__ZN3ccc3AA7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA7E, buf);
    ::ccc::AA7 *dp, &lv = *(dp=new (buf) ::ccc::AA7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA7E)");
    test_class_info(&lv, &cd__ZN3ccc3AA7E);
    dp->::ccc::AA7::~AA7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA7E(Test__ZN3ccc3AA7E, "_ZN3ccc3AA7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA7C1Ev();
extern void _ZN3ccc3AA7D1Ev();
Name_Map name_map__ZN3ccc3AA7E[] = {
  NSPAIR(_ZN3ccc3AA7C1Ev),
  NSPAIR(_ZN3ccc3AA7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc3AA73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
Class_Descriptor cd__ZN3ccc3AA7E = {  "_ZN3ccc3AA7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB7  {
  virtual void  abc(); // _ZN3ccc3BB73abcEv
  virtual void  pqr(); // _ZN3ccc3BB73pqrEv
  ~BB7(); // tgen
  BB7(); // tgen
};
//SIG(1 _ZN3ccc3BB7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB7 ::abc(){vfunc_called(this, "_ZN3ccc3BB73abcEv");}
void  ccc::BB7 ::pqr(){vfunc_called(this, "_ZN3ccc3BB73pqrEv");}
ccc::BB7 ::~BB7(){ note_dtor("_ZN3ccc3BB7E", this);} // tgen
ccc::BB7 ::BB7(){ note_ctor("_ZN3ccc3BB7E", this);} // tgen
}
static void Test__ZN3ccc3BB7E()
{
  extern Class_Descriptor cd__ZN3ccc3BB7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB7E, buf);
    ::ccc::BB7 *dp, &lv = *(dp=new (buf) ::ccc::BB7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB7E)");
    test_class_info(&lv, &cd__ZN3ccc3BB7E);
    dp->::ccc::BB7::~BB7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB7E(Test__ZN3ccc3BB7E, "_ZN3ccc3BB7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB7C1Ev();
extern void _ZN3ccc3BB7D1Ev();
Name_Map name_map__ZN3ccc3BB7E[] = {
  NSPAIR(_ZN3ccc3BB7C1Ev),
  NSPAIR(_ZN3ccc3BB7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
Class_Descriptor cd__ZN3ccc3BB7E = {  "_ZN3ccc3BB7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x0  : virtual ::ccc::AA7 {
  virtual void  abc(); // _ZN3ccc5EE7x03abcEv
  virtual void  efg(); // _ZN3ccc5EE7x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE7x03pqrEv
  ~EE7x0(); // tgen
  EE7x0(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x0E) C1{ VBC2{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE7x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x03abcEv");}
void  ccc::EE7x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x03efgEv");}
void  ccc::EE7x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x03pqrEv");}
ccc::EE7x0 ::~EE7x0(){ note_dtor("_ZN3ccc5EE7x0E", this);} // tgen
ccc::EE7x0 ::EE7x0(){ note_ctor("_ZN3ccc5EE7x0E", this);} // tgen
}
static void Test__ZN3ccc5EE7x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x0E, buf);
    ::ccc::EE7x0 *dp, &lv = *(dp=new (buf) ::ccc::EE7x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x0E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x0E);
    dp->::ccc::EE7x0::~EE7x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x0E(Test__ZN3ccc5EE7x0E, "_ZN3ccc5EE7x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x0C1Ev();
extern void _ZN3ccc5EE7x0D1Ev();
Name_Map name_map__ZN3ccc5EE7x0E[] = {
  NSPAIR(_ZN3ccc5EE7x0C1Ev),
  NSPAIR(_ZN3ccc5EE7x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x0E[];
extern void _ZN3ccc5EE7x03abcEv();
extern void _ZN3ccc5EE7x03pqrEv();
extern void _ZN3ccc5EE7x03efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x0E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x03efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x0E[] = {
  {&(_ZTVN3ccc5EE7x0E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x0E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x0E[];
Class_Descriptor cd__ZN3ccc5EE7x0E = {  "_ZN3ccc5EE7x0E", // class name
  bases__ZN3ccc5EE7x0E, 1,
  &(vtc__ZN3ccc5EE7x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x0E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x1  : virtual ::ccc::AA7 {
  virtual void  abc(); // _ZN3ccc5EE7x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE7x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE7x13efgEv
  ~EE7x1(); // tgen
  EE7x1(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x1E) C1{ VBC2{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE7x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x13abcEv");}
void  ccc::EE7x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x13pqrEv");}
void  ccc::EE7x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x13efgEv");}
ccc::EE7x1 ::~EE7x1(){ note_dtor("_ZN3ccc5EE7x1E", this);} // tgen
ccc::EE7x1 ::EE7x1(){ note_ctor("_ZN3ccc5EE7x1E", this);} // tgen
}
static void Test__ZN3ccc5EE7x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x1E, buf);
    ::ccc::EE7x1 *dp, &lv = *(dp=new (buf) ::ccc::EE7x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x1E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x1E);
    dp->::ccc::EE7x1::~EE7x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x1E(Test__ZN3ccc5EE7x1E, "_ZN3ccc5EE7x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x1C1Ev();
extern void _ZN3ccc5EE7x1D1Ev();
Name_Map name_map__ZN3ccc5EE7x1E[] = {
  NSPAIR(_ZN3ccc5EE7x1C1Ev),
  NSPAIR(_ZN3ccc5EE7x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x1E[];
extern void _ZN3ccc5EE7x13abcEv();
extern void _ZN3ccc5EE7x13pqrEv();
extern void _ZN3ccc5EE7x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x1E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x1E[] = {
  {&(_ZTVN3ccc5EE7x1E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x1E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x1E[];
Class_Descriptor cd__ZN3ccc5EE7x1E = {  "_ZN3ccc5EE7x1E", // class name
  bases__ZN3ccc5EE7x1E, 1,
  &(vtc__ZN3ccc5EE7x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x1E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x2  : virtual ::ccc::AA7 {
  virtual void  efg(); // _ZN3ccc5EE7x23efgEv
  virtual void  abc(); // _ZN3ccc5EE7x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE7x23pqrEv
  ~EE7x2(); // tgen
  EE7x2(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x2E) C1{ VBC2{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE7x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x23efgEv");}
void  ccc::EE7x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x23abcEv");}
void  ccc::EE7x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x23pqrEv");}
ccc::EE7x2 ::~EE7x2(){ note_dtor("_ZN3ccc5EE7x2E", this);} // tgen
ccc::EE7x2 ::EE7x2(){ note_ctor("_ZN3ccc5EE7x2E", this);} // tgen
}
static void Test__ZN3ccc5EE7x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x2E, buf);
    ::ccc::EE7x2 *dp, &lv = *(dp=new (buf) ::ccc::EE7x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x2E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x2E);
    dp->::ccc::EE7x2::~EE7x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x2E(Test__ZN3ccc5EE7x2E, "_ZN3ccc5EE7x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x2C1Ev();
extern void _ZN3ccc5EE7x2D1Ev();
Name_Map name_map__ZN3ccc5EE7x2E[] = {
  NSPAIR(_ZN3ccc5EE7x2C1Ev),
  NSPAIR(_ZN3ccc5EE7x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x2E[];
extern void _ZN3ccc5EE7x23abcEv();
extern void _ZN3ccc5EE7x23pqrEv();
extern void _ZN3ccc5EE7x23efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x2E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x23efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x2E[] = {
  {&(_ZTVN3ccc5EE7x2E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x2E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x2E[];
Class_Descriptor cd__ZN3ccc5EE7x2E = {  "_ZN3ccc5EE7x2E", // class name
  bases__ZN3ccc5EE7x2E, 1,
  &(vtc__ZN3ccc5EE7x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x2E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x3  : virtual ::ccc::AA7 {
  virtual void  efg(); // _ZN3ccc5EE7x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE7x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE7x33abcEv
  ~EE7x3(); // tgen
  EE7x3(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x3E) C1{ VBC2{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE7x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x33efgEv");}
void  ccc::EE7x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x33pqrEv");}
void  ccc::EE7x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x33abcEv");}
ccc::EE7x3 ::~EE7x3(){ note_dtor("_ZN3ccc5EE7x3E", this);} // tgen
ccc::EE7x3 ::EE7x3(){ note_ctor("_ZN3ccc5EE7x3E", this);} // tgen
}
static void Test__ZN3ccc5EE7x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x3E, buf);
    ::ccc::EE7x3 *dp, &lv = *(dp=new (buf) ::ccc::EE7x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x3E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x3E);
    dp->::ccc::EE7x3::~EE7x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x3E(Test__ZN3ccc5EE7x3E, "_ZN3ccc5EE7x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x3C1Ev();
extern void _ZN3ccc5EE7x3D1Ev();
Name_Map name_map__ZN3ccc5EE7x3E[] = {
  NSPAIR(_ZN3ccc5EE7x3C1Ev),
  NSPAIR(_ZN3ccc5EE7x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x3E[];
extern void _ZN3ccc5EE7x33abcEv();
extern void _ZN3ccc5EE7x33pqrEv();
extern void _ZN3ccc5EE7x33efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x3E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x33efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x3E[] = {
  {&(_ZTVN3ccc5EE7x3E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x3E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x3E[];
Class_Descriptor cd__ZN3ccc5EE7x3E = {  "_ZN3ccc5EE7x3E", // class name
  bases__ZN3ccc5EE7x3E, 1,
  &(vtc__ZN3ccc5EE7x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x3E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x4  : virtual ::ccc::AA7 {
  virtual void  pqr(); // _ZN3ccc5EE7x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE7x43abcEv
  virtual void  efg(); // _ZN3ccc5EE7x43efgEv
  ~EE7x4(); // tgen
  EE7x4(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x4E) C1{ VBC2{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE7x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x43pqrEv");}
void  ccc::EE7x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x43abcEv");}
void  ccc::EE7x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x43efgEv");}
ccc::EE7x4 ::~EE7x4(){ note_dtor("_ZN3ccc5EE7x4E", this);} // tgen
ccc::EE7x4 ::EE7x4(){ note_ctor("_ZN3ccc5EE7x4E", this);} // tgen
}
static void Test__ZN3ccc5EE7x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x4E, buf);
    ::ccc::EE7x4 *dp, &lv = *(dp=new (buf) ::ccc::EE7x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x4E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x4E);
    dp->::ccc::EE7x4::~EE7x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x4E(Test__ZN3ccc5EE7x4E, "_ZN3ccc5EE7x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x4C1Ev();
extern void _ZN3ccc5EE7x4D1Ev();
Name_Map name_map__ZN3ccc5EE7x4E[] = {
  NSPAIR(_ZN3ccc5EE7x4C1Ev),
  NSPAIR(_ZN3ccc5EE7x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x4E[];
extern void _ZN3ccc5EE7x43abcEv();
extern void _ZN3ccc5EE7x43pqrEv();
extern void _ZN3ccc5EE7x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x4E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x4E[] = {
  {&(_ZTVN3ccc5EE7x4E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x4E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x4E[];
Class_Descriptor cd__ZN3ccc5EE7x4E = {  "_ZN3ccc5EE7x4E", // class name
  bases__ZN3ccc5EE7x4E, 1,
  &(vtc__ZN3ccc5EE7x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x4E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x5  : virtual ::ccc::AA7 {
  virtual void  pqr(); // _ZN3ccc5EE7x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE7x53efgEv
  virtual void  abc(); // _ZN3ccc5EE7x53abcEv
  ~EE7x5(); // tgen
  EE7x5(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x5E) C1{ VBC2{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE7x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x53pqrEv");}
void  ccc::EE7x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x53efgEv");}
void  ccc::EE7x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x53abcEv");}
ccc::EE7x5 ::~EE7x5(){ note_dtor("_ZN3ccc5EE7x5E", this);} // tgen
ccc::EE7x5 ::EE7x5(){ note_ctor("_ZN3ccc5EE7x5E", this);} // tgen
}
static void Test__ZN3ccc5EE7x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x5E, buf);
    ::ccc::EE7x5 *dp, &lv = *(dp=new (buf) ::ccc::EE7x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x5E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x5E);
    dp->::ccc::EE7x5::~EE7x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x5E(Test__ZN3ccc5EE7x5E, "_ZN3ccc5EE7x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x5C1Ev();
extern void _ZN3ccc5EE7x5D1Ev();
Name_Map name_map__ZN3ccc5EE7x5E[] = {
  NSPAIR(_ZN3ccc5EE7x5C1Ev),
  NSPAIR(_ZN3ccc5EE7x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x5E[];
extern void _ZN3ccc5EE7x53abcEv();
extern void _ZN3ccc5EE7x53pqrEv();
extern void _ZN3ccc5EE7x53efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x5E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x53efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x5E[] = {
  {&(_ZTVN3ccc5EE7x5E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x5E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x5E[];
Class_Descriptor cd__ZN3ccc5EE7x5E = {  "_ZN3ccc5EE7x5E", // class name
  bases__ZN3ccc5EE7x5E, 1,
  &(vtc__ZN3ccc5EE7x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x5E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x6  : virtual ::ccc::AA7 {
  virtual void  abc(); // _ZN3ccc5EE7x63abcEv
  virtual void  efg(); // _ZN3ccc5EE7x63efgEv
  ~EE7x6(); // tgen
  EE7x6(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x6E) C1{ VBC2{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE7x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x63abcEv");}
void  ccc::EE7x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x63efgEv");}
ccc::EE7x6 ::~EE7x6(){ note_dtor("_ZN3ccc5EE7x6E", this);} // tgen
ccc::EE7x6 ::EE7x6(){ note_ctor("_ZN3ccc5EE7x6E", this);} // tgen
}
static void Test__ZN3ccc5EE7x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x6E, buf);
    ::ccc::EE7x6 *dp, &lv = *(dp=new (buf) ::ccc::EE7x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x6E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x6E);
    dp->::ccc::EE7x6::~EE7x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x6E(Test__ZN3ccc5EE7x6E, "_ZN3ccc5EE7x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x6C1Ev();
extern void _ZN3ccc5EE7x6D1Ev();
Name_Map name_map__ZN3ccc5EE7x6E[] = {
  NSPAIR(_ZN3ccc5EE7x6C1Ev),
  NSPAIR(_ZN3ccc5EE7x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x6E[];
extern void _ZN3ccc5EE7x63abcEv();
extern void _ZN3ccc3AA73pqrEv();
extern void _ZN3ccc5EE7x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x6E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x6E[] = {
  {&(_ZTVN3ccc5EE7x6E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x6E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x6E[];
Class_Descriptor cd__ZN3ccc5EE7x6E = {  "_ZN3ccc5EE7x6E", // class name
  bases__ZN3ccc5EE7x6E, 1,
  &(vtc__ZN3ccc5EE7x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x6E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x7  : virtual ::ccc::AA7 {
  virtual void  abc(); // _ZN3ccc5EE7x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE7x73pqrEv
  ~EE7x7(); // tgen
  EE7x7(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x7E) C1{ VBC2{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE7x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x73abcEv");}
void  ccc::EE7x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x73pqrEv");}
ccc::EE7x7 ::~EE7x7(){ note_dtor("_ZN3ccc5EE7x7E", this);} // tgen
ccc::EE7x7 ::EE7x7(){ note_ctor("_ZN3ccc5EE7x7E", this);} // tgen
}
static void Test__ZN3ccc5EE7x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x7E, buf);
    ::ccc::EE7x7 *dp, &lv = *(dp=new (buf) ::ccc::EE7x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x7E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x7E);
    dp->::ccc::EE7x7::~EE7x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x7E(Test__ZN3ccc5EE7x7E, "_ZN3ccc5EE7x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x7C1Ev();
extern void _ZN3ccc5EE7x7D1Ev();
Name_Map name_map__ZN3ccc5EE7x7E[] = {
  NSPAIR(_ZN3ccc5EE7x7C1Ev),
  NSPAIR(_ZN3ccc5EE7x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x7E[];
extern void _ZN3ccc5EE7x73abcEv();
extern void _ZN3ccc5EE7x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x7E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x7E[] = {
  {&(_ZTVN3ccc5EE7x7E[5]),  5,7},
  {&(_ZTVN3ccc5EE7x7E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x7E[];
Class_Descriptor cd__ZN3ccc5EE7x7E = {  "_ZN3ccc5EE7x7E", // class name
  bases__ZN3ccc5EE7x7E, 1,
  &(vtc__ZN3ccc5EE7x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x7E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x8  : virtual ::ccc::AA7 {
  virtual void  efg(); // _ZN3ccc5EE7x83efgEv
  virtual void  abc(); // _ZN3ccc5EE7x83abcEv
  ~EE7x8(); // tgen
  EE7x8(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x8E) C1{ VBC2{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE7x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x83efgEv");}
void  ccc::EE7x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE7x83abcEv");}
ccc::EE7x8 ::~EE7x8(){ note_dtor("_ZN3ccc5EE7x8E", this);} // tgen
ccc::EE7x8 ::EE7x8(){ note_ctor("_ZN3ccc5EE7x8E", this);} // tgen
}
static void Test__ZN3ccc5EE7x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x8E, buf);
    ::ccc::EE7x8 *dp, &lv = *(dp=new (buf) ::ccc::EE7x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x8E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x8E);
    dp->::ccc::EE7x8::~EE7x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x8E(Test__ZN3ccc5EE7x8E, "_ZN3ccc5EE7x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x8C1Ev();
extern void _ZN3ccc5EE7x8D1Ev();
Name_Map name_map__ZN3ccc5EE7x8E[] = {
  NSPAIR(_ZN3ccc5EE7x8C1Ev),
  NSPAIR(_ZN3ccc5EE7x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x8E[];
extern void _ZN3ccc5EE7x83abcEv();
extern void _ZN3ccc3AA73pqrEv();
extern void _ZN3ccc5EE7x83efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x8E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE7x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x83efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x8E[] = {
  {&(_ZTVN3ccc5EE7x8E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x8E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x8E[];
Class_Descriptor cd__ZN3ccc5EE7x8E = {  "_ZN3ccc5EE7x8E", // class name
  bases__ZN3ccc5EE7x8E, 1,
  &(vtc__ZN3ccc5EE7x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x8E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x9  : virtual ::ccc::AA7 {
  virtual void  efg(); // _ZN3ccc5EE7x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE7x93pqrEv
  ~EE7x9(); // tgen
  EE7x9(); // tgen
};
//SIG(-1 _ZN3ccc5EE7x9E) C1{ VBC2{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE7x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE7x93efgEv");}
void  ccc::EE7x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE7x93pqrEv");}
ccc::EE7x9 ::~EE7x9(){ note_dtor("_ZN3ccc5EE7x9E", this);} // tgen
ccc::EE7x9 ::EE7x9(){ note_ctor("_ZN3ccc5EE7x9E", this);} // tgen
}
static void Test__ZN3ccc5EE7x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE7x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE7x9E, buf);
    ::ccc::EE7x9 *dp, &lv = *(dp=new (buf) ::ccc::EE7x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE7x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE7x9E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc5EE7x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE7x9E);
    dp->::ccc::EE7x9::~EE7x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE7x9E(Test__ZN3ccc5EE7x9E, "_ZN3ccc5EE7x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE7x9C1Ev();
extern void _ZN3ccc5EE7x9D1Ev();
Name_Map name_map__ZN3ccc5EE7x9E[] = {
  NSPAIR(_ZN3ccc5EE7x9C1Ev),
  NSPAIR(_ZN3ccc5EE7x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc5EE7x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE7x9E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc5EE7x93pqrEv();
extern void _ZN3ccc5EE7x93efgEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE7x9E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE7x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE7x93efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE7x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE7x9E[] = {
  {&(_ZTVN3ccc5EE7x9E[5]),  5,8},
  {&(_ZTVN3ccc5EE7x9E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE7x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE7x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE7x9E[];
Class_Descriptor cd__ZN3ccc5EE7x9E = {  "_ZN3ccc5EE7x9E", // class name
  bases__ZN3ccc5EE7x9E, 1,
  &(vtc__ZN3ccc5EE7x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE7x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE7x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE7x9E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE7x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x10  : virtual ::ccc::AA7 {
  virtual void  pqr(); // _ZN3ccc6EE7x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE7x103abcEv
  ~EE7x10(); // tgen
  EE7x10(); // tgen
};
//SIG(-1 _ZN3ccc6EE7x10E) C1{ VBC2{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE7x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE7x103pqrEv");}
void  ccc::EE7x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE7x103abcEv");}
ccc::EE7x10 ::~EE7x10(){ note_dtor("_ZN3ccc6EE7x10E", this);} // tgen
ccc::EE7x10 ::EE7x10(){ note_ctor("_ZN3ccc6EE7x10E", this);} // tgen
}
static void Test__ZN3ccc6EE7x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE7x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE7x10E, buf);
    ::ccc::EE7x10 *dp, &lv = *(dp=new (buf) ::ccc::EE7x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE7x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE7x10E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc6EE7x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE7x10E);
    dp->::ccc::EE7x10::~EE7x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE7x10E(Test__ZN3ccc6EE7x10E, "_ZN3ccc6EE7x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE7x10C1Ev();
extern void _ZN3ccc6EE7x10D1Ev();
Name_Map name_map__ZN3ccc6EE7x10E[] = {
  NSPAIR(_ZN3ccc6EE7x10C1Ev),
  NSPAIR(_ZN3ccc6EE7x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc6EE7x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE7x10E[];
extern void _ZN3ccc6EE7x103abcEv();
extern void _ZN3ccc6EE7x103pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE7x10E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE7x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE7x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE7x103pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE7x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE7x10E[] = {
  {&(_ZTVN3ccc6EE7x10E[5]),  5,7},
  {&(_ZTVN3ccc6EE7x10E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE7x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE7x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE7x10E[];
Class_Descriptor cd__ZN3ccc6EE7x10E = {  "_ZN3ccc6EE7x10E", // class name
  bases__ZN3ccc6EE7x10E, 1,
  &(vtc__ZN3ccc6EE7x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE7x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE7x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE7x10E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE7x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x11  : virtual ::ccc::AA7 {
  virtual void  pqr(); // _ZN3ccc6EE7x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE7x113efgEv
  ~EE7x11(); // tgen
  EE7x11(); // tgen
};
//SIG(-1 _ZN3ccc6EE7x11E) C1{ VBC2{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE7x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE7x113pqrEv");}
void  ccc::EE7x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE7x113efgEv");}
ccc::EE7x11 ::~EE7x11(){ note_dtor("_ZN3ccc6EE7x11E", this);} // tgen
ccc::EE7x11 ::EE7x11(){ note_ctor("_ZN3ccc6EE7x11E", this);} // tgen
}
static void Test__ZN3ccc6EE7x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE7x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE7x11E, buf);
    ::ccc::EE7x11 *dp, &lv = *(dp=new (buf) ::ccc::EE7x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE7x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE7x11E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc6EE7x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE7x11E);
    dp->::ccc::EE7x11::~EE7x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE7x11E(Test__ZN3ccc6EE7x11E, "_ZN3ccc6EE7x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE7x11C1Ev();
extern void _ZN3ccc6EE7x11D1Ev();
Name_Map name_map__ZN3ccc6EE7x11E[] = {
  NSPAIR(_ZN3ccc6EE7x11C1Ev),
  NSPAIR(_ZN3ccc6EE7x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc6EE7x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE7x11E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc6EE7x113pqrEv();
extern void _ZN3ccc6EE7x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE7x11E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE7x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE7x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE7x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE7x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE7x11E[] = {
  {&(_ZTVN3ccc6EE7x11E[5]),  5,8},
  {&(_ZTVN3ccc6EE7x11E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE7x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE7x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE7x11E[];
Class_Descriptor cd__ZN3ccc6EE7x11E = {  "_ZN3ccc6EE7x11E", // class name
  bases__ZN3ccc6EE7x11E, 1,
  &(vtc__ZN3ccc6EE7x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE7x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE7x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE7x11E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE7x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x12  : virtual ::ccc::AA7 {
  virtual void  abc(); // _ZN3ccc6EE7x123abcEv
  ~EE7x12(); // tgen
  EE7x12(); // tgen
};
//SIG(-1 _ZN3ccc6EE7x12E) C1{ VBC2{ v1 v2} v1}
}
namespace ccc { 
void  ccc::EE7x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE7x123abcEv");}
ccc::EE7x12 ::~EE7x12(){ note_dtor("_ZN3ccc6EE7x12E", this);} // tgen
ccc::EE7x12 ::EE7x12(){ note_ctor("_ZN3ccc6EE7x12E", this);} // tgen
}
static void Test__ZN3ccc6EE7x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE7x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE7x12E, buf);
    ::ccc::EE7x12 *dp, &lv = *(dp=new (buf) ::ccc::EE7x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE7x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE7x12E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc6EE7x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE7x12E);
    dp->::ccc::EE7x12::~EE7x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE7x12E(Test__ZN3ccc6EE7x12E, "_ZN3ccc6EE7x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE7x12C1Ev();
extern void _ZN3ccc6EE7x12D1Ev();
Name_Map name_map__ZN3ccc6EE7x12E[] = {
  NSPAIR(_ZN3ccc6EE7x12C1Ev),
  NSPAIR(_ZN3ccc6EE7x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc6EE7x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE7x12E[];
extern void _ZN3ccc6EE7x123abcEv();
extern void _ZN3ccc3AA73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE7x12E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE7x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE7x123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE7x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE7x12E[] = {
  {&(_ZTVN3ccc6EE7x12E[5]),  5,7},
  {&(_ZTVN3ccc6EE7x12E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE7x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE7x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE7x12E[];
Class_Descriptor cd__ZN3ccc6EE7x12E = {  "_ZN3ccc6EE7x12E", // class name
  bases__ZN3ccc6EE7x12E, 1,
  &(vtc__ZN3ccc6EE7x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE7x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE7x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE7x12E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE7x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x13  : virtual ::ccc::AA7 {
  virtual void  efg(); // _ZN3ccc6EE7x133efgEv
  ~EE7x13(); // tgen
  EE7x13(); // tgen
};
//SIG(-1 _ZN3ccc6EE7x13E) C1{ VBC2{ v2 v3} v1}
}
namespace ccc { 
void  ccc::EE7x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE7x133efgEv");}
ccc::EE7x13 ::~EE7x13(){ note_dtor("_ZN3ccc6EE7x13E", this);} // tgen
ccc::EE7x13 ::EE7x13(){ note_ctor("_ZN3ccc6EE7x13E", this);} // tgen
}
static void Test__ZN3ccc6EE7x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE7x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE7x13E, buf);
    ::ccc::EE7x13 *dp, &lv = *(dp=new (buf) ::ccc::EE7x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE7x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE7x13E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc6EE7x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE7x13E);
    dp->::ccc::EE7x13::~EE7x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE7x13E(Test__ZN3ccc6EE7x13E, "_ZN3ccc6EE7x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE7x13C1Ev();
extern void _ZN3ccc6EE7x13D1Ev();
Name_Map name_map__ZN3ccc6EE7x13E[] = {
  NSPAIR(_ZN3ccc6EE7x13C1Ev),
  NSPAIR(_ZN3ccc6EE7x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc6EE7x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE7x13E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc3AA73pqrEv();
extern void _ZN3ccc6EE7x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE7x13E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE7x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE7x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE7x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE7x13E[] = {
  {&(_ZTVN3ccc6EE7x13E[5]),  5,8},
  {&(_ZTVN3ccc6EE7x13E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE7x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE7x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE7x13E[];
Class_Descriptor cd__ZN3ccc6EE7x13E = {  "_ZN3ccc6EE7x13E", // class name
  bases__ZN3ccc6EE7x13E, 1,
  &(vtc__ZN3ccc6EE7x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE7x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE7x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE7x13E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE7x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x14  : virtual ::ccc::AA7 {
  virtual void  pqr(); // _ZN3ccc6EE7x143pqrEv
  ~EE7x14(); // tgen
  EE7x14(); // tgen
};
//SIG(-1 _ZN3ccc6EE7x14E) C1{ VBC2{ v2 v1} v1}
}
namespace ccc { 
void  ccc::EE7x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE7x143pqrEv");}
ccc::EE7x14 ::~EE7x14(){ note_dtor("_ZN3ccc6EE7x14E", this);} // tgen
ccc::EE7x14 ::EE7x14(){ note_ctor("_ZN3ccc6EE7x14E", this);} // tgen
}
static void Test__ZN3ccc6EE7x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE7x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE7x14E, buf);
    ::ccc::EE7x14 *dp, &lv = *(dp=new (buf) ::ccc::EE7x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE7x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE7x14E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc6EE7x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE7x14E);
    dp->::ccc::EE7x14::~EE7x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE7x14E(Test__ZN3ccc6EE7x14E, "_ZN3ccc6EE7x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE7x14C1Ev();
extern void _ZN3ccc6EE7x14D1Ev();
Name_Map name_map__ZN3ccc6EE7x14E[] = {
  NSPAIR(_ZN3ccc6EE7x14C1Ev),
  NSPAIR(_ZN3ccc6EE7x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc6EE7x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE7x14E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc6EE7x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE7x14E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE7x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE7x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE7x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE7x14E[] = {
  {&(_ZTVN3ccc6EE7x14E[5]),  5,7},
  {&(_ZTVN3ccc6EE7x14E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE7x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE7x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE7x14E[];
Class_Descriptor cd__ZN3ccc6EE7x14E = {  "_ZN3ccc6EE7x14E", // class name
  bases__ZN3ccc6EE7x14E, 1,
  &(vtc__ZN3ccc6EE7x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE7x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE7x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE7x14E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE7x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE7x15  : virtual ::ccc::AA7 {
  ~EE7x15(); // tgen
  EE7x15(); // tgen
};
//SIG(-1 _ZN3ccc6EE7x15E) C1{ VBC2{ v1 v2}}
}
namespace ccc { 
ccc::EE7x15 ::~EE7x15(){ note_dtor("_ZN3ccc6EE7x15E", this);} // tgen
ccc::EE7x15 ::EE7x15(){ note_ctor("_ZN3ccc6EE7x15E", this);} // tgen
}
static void Test__ZN3ccc6EE7x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE7x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE7x15E, buf);
    ::ccc::EE7x15 *dp, &lv = *(dp=new (buf) ::ccc::EE7x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE7x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE7x15E)");
    check_base_class_offset(lv, (::ccc::AA7*), 0, "_ZN3ccc6EE7x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE7x15E);
    dp->::ccc::EE7x15::~EE7x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE7x15E(Test__ZN3ccc6EE7x15E, "_ZN3ccc6EE7x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE7x15C1Ev();
extern void _ZN3ccc6EE7x15D1Ev();
Name_Map name_map__ZN3ccc6EE7x15E[] = {
  NSPAIR(_ZN3ccc6EE7x15C1Ev),
  NSPAIR(_ZN3ccc6EE7x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA7E;
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
static Base_Class bases__ZN3ccc6EE7x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE7x15E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc3AA73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE7x15E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE7x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE7x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE7x15E[] = {
  {&(_ZTVN3ccc6EE7x15E[5]),  5,7},
  {&(_ZTVN3ccc6EE7x15E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE7x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE7x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE7x15E[];
Class_Descriptor cd__ZN3ccc6EE7x15E = {  "_ZN3ccc6EE7x15E", // class name
  bases__ZN3ccc6EE7x15E, 1,
  &(vtc__ZN3ccc6EE7x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE7x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE7x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE7x15E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE7x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA8  {
  virtual void  efg(); // _ZN3ccc3AA83efgEv
  virtual void  abc(); // _ZN3ccc3AA83abcEv
  ~AA8(); // tgen
  AA8(); // tgen
};
//SIG(-1 _ZN3ccc3AA8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA8 ::efg(){vfunc_called(this, "_ZN3ccc3AA83efgEv");}
void  ccc::AA8 ::abc(){vfunc_called(this, "_ZN3ccc3AA83abcEv");}
ccc::AA8 ::~AA8(){ note_dtor("_ZN3ccc3AA8E", this);} // tgen
ccc::AA8 ::AA8(){ note_ctor("_ZN3ccc3AA8E", this);} // tgen
}
static void Test__ZN3ccc3AA8E()
{
  extern Class_Descriptor cd__ZN3ccc3AA8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA8E, buf);
    ::ccc::AA8 *dp, &lv = *(dp=new (buf) ::ccc::AA8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA8E)");
    test_class_info(&lv, &cd__ZN3ccc3AA8E);
    dp->::ccc::AA8::~AA8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA8E(Test__ZN3ccc3AA8E, "_ZN3ccc3AA8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA8C1Ev();
extern void _ZN3ccc3AA8D1Ev();
Name_Map name_map__ZN3ccc3AA8E[] = {
  NSPAIR(_ZN3ccc3AA8C1Ev),
  NSPAIR(_ZN3ccc3AA8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc3AA83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
Class_Descriptor cd__ZN3ccc3AA8E = {  "_ZN3ccc3AA8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB8  {
  virtual void  efg(); // _ZN3ccc3BB83efgEv
  virtual void  abc(); // _ZN3ccc3BB83abcEv
  ~BB8(); // tgen
  BB8(); // tgen
};
//SIG(1 _ZN3ccc3BB8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB8 ::efg(){vfunc_called(this, "_ZN3ccc3BB83efgEv");}
void  ccc::BB8 ::abc(){vfunc_called(this, "_ZN3ccc3BB83abcEv");}
ccc::BB8 ::~BB8(){ note_dtor("_ZN3ccc3BB8E", this);} // tgen
ccc::BB8 ::BB8(){ note_ctor("_ZN3ccc3BB8E", this);} // tgen
}
static void Test__ZN3ccc3BB8E()
{
  extern Class_Descriptor cd__ZN3ccc3BB8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB8E, buf);
    ::ccc::BB8 *dp, &lv = *(dp=new (buf) ::ccc::BB8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB8E)");
    test_class_info(&lv, &cd__ZN3ccc3BB8E);
    dp->::ccc::BB8::~BB8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB8E(Test__ZN3ccc3BB8E, "_ZN3ccc3BB8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB8C1Ev();
extern void _ZN3ccc3BB8D1Ev();
Name_Map name_map__ZN3ccc3BB8E[] = {
  NSPAIR(_ZN3ccc3BB8C1Ev),
  NSPAIR(_ZN3ccc3BB8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
Class_Descriptor cd__ZN3ccc3BB8E = {  "_ZN3ccc3BB8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x0  : virtual ::ccc::AA8 {
  virtual void  abc(); // _ZN3ccc5EE8x03abcEv
  virtual void  efg(); // _ZN3ccc5EE8x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE8x03pqrEv
  ~EE8x0(); // tgen
  EE8x0(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x0E) C1{ VBC2{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE8x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x03abcEv");}
void  ccc::EE8x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x03efgEv");}
void  ccc::EE8x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x03pqrEv");}
ccc::EE8x0 ::~EE8x0(){ note_dtor("_ZN3ccc5EE8x0E", this);} // tgen
ccc::EE8x0 ::EE8x0(){ note_ctor("_ZN3ccc5EE8x0E", this);} // tgen
}
static void Test__ZN3ccc5EE8x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x0E, buf);
    ::ccc::EE8x0 *dp, &lv = *(dp=new (buf) ::ccc::EE8x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x0E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x0E);
    dp->::ccc::EE8x0::~EE8x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x0E(Test__ZN3ccc5EE8x0E, "_ZN3ccc5EE8x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x0C1Ev();
extern void _ZN3ccc5EE8x0D1Ev();
Name_Map name_map__ZN3ccc5EE8x0E[] = {
  NSPAIR(_ZN3ccc5EE8x0C1Ev),
  NSPAIR(_ZN3ccc5EE8x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x0E[];
extern void _ZN3ccc5EE8x03efgEv();
extern void _ZN3ccc5EE8x03abcEv();
extern void _ZN3ccc5EE8x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x0E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x0E[] = {
  {&(_ZTVN3ccc5EE8x0E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x0E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x0E[];
Class_Descriptor cd__ZN3ccc5EE8x0E = {  "_ZN3ccc5EE8x0E", // class name
  bases__ZN3ccc5EE8x0E, 1,
  &(vtc__ZN3ccc5EE8x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x0E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x1  : virtual ::ccc::AA8 {
  virtual void  abc(); // _ZN3ccc5EE8x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE8x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE8x13efgEv
  ~EE8x1(); // tgen
  EE8x1(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x1E) C1{ VBC2{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE8x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x13abcEv");}
void  ccc::EE8x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x13pqrEv");}
void  ccc::EE8x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x13efgEv");}
ccc::EE8x1 ::~EE8x1(){ note_dtor("_ZN3ccc5EE8x1E", this);} // tgen
ccc::EE8x1 ::EE8x1(){ note_ctor("_ZN3ccc5EE8x1E", this);} // tgen
}
static void Test__ZN3ccc5EE8x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x1E, buf);
    ::ccc::EE8x1 *dp, &lv = *(dp=new (buf) ::ccc::EE8x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x1E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x1E);
    dp->::ccc::EE8x1::~EE8x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x1E(Test__ZN3ccc5EE8x1E, "_ZN3ccc5EE8x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x1C1Ev();
extern void _ZN3ccc5EE8x1D1Ev();
Name_Map name_map__ZN3ccc5EE8x1E[] = {
  NSPAIR(_ZN3ccc5EE8x1C1Ev),
  NSPAIR(_ZN3ccc5EE8x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x1E[];
extern void _ZN3ccc5EE8x13efgEv();
extern void _ZN3ccc5EE8x13abcEv();
extern void _ZN3ccc5EE8x13pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x1E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x13pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x1E[] = {
  {&(_ZTVN3ccc5EE8x1E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x1E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x1E[];
Class_Descriptor cd__ZN3ccc5EE8x1E = {  "_ZN3ccc5EE8x1E", // class name
  bases__ZN3ccc5EE8x1E, 1,
  &(vtc__ZN3ccc5EE8x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x1E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x2  : virtual ::ccc::AA8 {
  virtual void  efg(); // _ZN3ccc5EE8x23efgEv
  virtual void  abc(); // _ZN3ccc5EE8x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE8x23pqrEv
  ~EE8x2(); // tgen
  EE8x2(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x2E) C1{ VBC2{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE8x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x23efgEv");}
void  ccc::EE8x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x23abcEv");}
void  ccc::EE8x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x23pqrEv");}
ccc::EE8x2 ::~EE8x2(){ note_dtor("_ZN3ccc5EE8x2E", this);} // tgen
ccc::EE8x2 ::EE8x2(){ note_ctor("_ZN3ccc5EE8x2E", this);} // tgen
}
static void Test__ZN3ccc5EE8x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x2E, buf);
    ::ccc::EE8x2 *dp, &lv = *(dp=new (buf) ::ccc::EE8x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x2E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x2E);
    dp->::ccc::EE8x2::~EE8x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x2E(Test__ZN3ccc5EE8x2E, "_ZN3ccc5EE8x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x2C1Ev();
extern void _ZN3ccc5EE8x2D1Ev();
Name_Map name_map__ZN3ccc5EE8x2E[] = {
  NSPAIR(_ZN3ccc5EE8x2C1Ev),
  NSPAIR(_ZN3ccc5EE8x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x2E[];
extern void _ZN3ccc5EE8x23efgEv();
extern void _ZN3ccc5EE8x23abcEv();
extern void _ZN3ccc5EE8x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x2E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x2E[] = {
  {&(_ZTVN3ccc5EE8x2E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x2E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x2E[];
Class_Descriptor cd__ZN3ccc5EE8x2E = {  "_ZN3ccc5EE8x2E", // class name
  bases__ZN3ccc5EE8x2E, 1,
  &(vtc__ZN3ccc5EE8x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x2E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x3  : virtual ::ccc::AA8 {
  virtual void  efg(); // _ZN3ccc5EE8x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE8x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE8x33abcEv
  ~EE8x3(); // tgen
  EE8x3(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x3E) C1{ VBC2{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE8x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x33efgEv");}
void  ccc::EE8x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x33pqrEv");}
void  ccc::EE8x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x33abcEv");}
ccc::EE8x3 ::~EE8x3(){ note_dtor("_ZN3ccc5EE8x3E", this);} // tgen
ccc::EE8x3 ::EE8x3(){ note_ctor("_ZN3ccc5EE8x3E", this);} // tgen
}
static void Test__ZN3ccc5EE8x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x3E, buf);
    ::ccc::EE8x3 *dp, &lv = *(dp=new (buf) ::ccc::EE8x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x3E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x3E);
    dp->::ccc::EE8x3::~EE8x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x3E(Test__ZN3ccc5EE8x3E, "_ZN3ccc5EE8x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x3C1Ev();
extern void _ZN3ccc5EE8x3D1Ev();
Name_Map name_map__ZN3ccc5EE8x3E[] = {
  NSPAIR(_ZN3ccc5EE8x3C1Ev),
  NSPAIR(_ZN3ccc5EE8x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x3E[];
extern void _ZN3ccc5EE8x33efgEv();
extern void _ZN3ccc5EE8x33abcEv();
extern void _ZN3ccc5EE8x33pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x3E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x33pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x3E[] = {
  {&(_ZTVN3ccc5EE8x3E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x3E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x3E[];
Class_Descriptor cd__ZN3ccc5EE8x3E = {  "_ZN3ccc5EE8x3E", // class name
  bases__ZN3ccc5EE8x3E, 1,
  &(vtc__ZN3ccc5EE8x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x3E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x4  : virtual ::ccc::AA8 {
  virtual void  pqr(); // _ZN3ccc5EE8x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE8x43abcEv
  virtual void  efg(); // _ZN3ccc5EE8x43efgEv
  ~EE8x4(); // tgen
  EE8x4(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x4E) C1{ VBC2{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE8x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x43pqrEv");}
void  ccc::EE8x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x43abcEv");}
void  ccc::EE8x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x43efgEv");}
ccc::EE8x4 ::~EE8x4(){ note_dtor("_ZN3ccc5EE8x4E", this);} // tgen
ccc::EE8x4 ::EE8x4(){ note_ctor("_ZN3ccc5EE8x4E", this);} // tgen
}
static void Test__ZN3ccc5EE8x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x4E, buf);
    ::ccc::EE8x4 *dp, &lv = *(dp=new (buf) ::ccc::EE8x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x4E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x4E);
    dp->::ccc::EE8x4::~EE8x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x4E(Test__ZN3ccc5EE8x4E, "_ZN3ccc5EE8x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x4C1Ev();
extern void _ZN3ccc5EE8x4D1Ev();
Name_Map name_map__ZN3ccc5EE8x4E[] = {
  NSPAIR(_ZN3ccc5EE8x4C1Ev),
  NSPAIR(_ZN3ccc5EE8x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x4E[];
extern void _ZN3ccc5EE8x43efgEv();
extern void _ZN3ccc5EE8x43abcEv();
extern void _ZN3ccc5EE8x43pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x4E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x43pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x4E[] = {
  {&(_ZTVN3ccc5EE8x4E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x4E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x4E[];
Class_Descriptor cd__ZN3ccc5EE8x4E = {  "_ZN3ccc5EE8x4E", // class name
  bases__ZN3ccc5EE8x4E, 1,
  &(vtc__ZN3ccc5EE8x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x4E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x5  : virtual ::ccc::AA8 {
  virtual void  pqr(); // _ZN3ccc5EE8x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE8x53efgEv
  virtual void  abc(); // _ZN3ccc5EE8x53abcEv
  ~EE8x5(); // tgen
  EE8x5(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x5E) C1{ VBC2{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE8x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x53pqrEv");}
void  ccc::EE8x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x53efgEv");}
void  ccc::EE8x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x53abcEv");}
ccc::EE8x5 ::~EE8x5(){ note_dtor("_ZN3ccc5EE8x5E", this);} // tgen
ccc::EE8x5 ::EE8x5(){ note_ctor("_ZN3ccc5EE8x5E", this);} // tgen
}
static void Test__ZN3ccc5EE8x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x5E, buf);
    ::ccc::EE8x5 *dp, &lv = *(dp=new (buf) ::ccc::EE8x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x5E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x5E);
    dp->::ccc::EE8x5::~EE8x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x5E(Test__ZN3ccc5EE8x5E, "_ZN3ccc5EE8x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x5C1Ev();
extern void _ZN3ccc5EE8x5D1Ev();
Name_Map name_map__ZN3ccc5EE8x5E[] = {
  NSPAIR(_ZN3ccc5EE8x5C1Ev),
  NSPAIR(_ZN3ccc5EE8x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x5E[];
extern void _ZN3ccc5EE8x53efgEv();
extern void _ZN3ccc5EE8x53abcEv();
extern void _ZN3ccc5EE8x53pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x5E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x53pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x5E[] = {
  {&(_ZTVN3ccc5EE8x5E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x5E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x5E[];
Class_Descriptor cd__ZN3ccc5EE8x5E = {  "_ZN3ccc5EE8x5E", // class name
  bases__ZN3ccc5EE8x5E, 1,
  &(vtc__ZN3ccc5EE8x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x5E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x6  : virtual ::ccc::AA8 {
  virtual void  abc(); // _ZN3ccc5EE8x63abcEv
  virtual void  efg(); // _ZN3ccc5EE8x63efgEv
  ~EE8x6(); // tgen
  EE8x6(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x6E) C1{ VBC2{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE8x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x63abcEv");}
void  ccc::EE8x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x63efgEv");}
ccc::EE8x6 ::~EE8x6(){ note_dtor("_ZN3ccc5EE8x6E", this);} // tgen
ccc::EE8x6 ::EE8x6(){ note_ctor("_ZN3ccc5EE8x6E", this);} // tgen
}
static void Test__ZN3ccc5EE8x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x6E, buf);
    ::ccc::EE8x6 *dp, &lv = *(dp=new (buf) ::ccc::EE8x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x6E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x6E);
    dp->::ccc::EE8x6::~EE8x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x6E(Test__ZN3ccc5EE8x6E, "_ZN3ccc5EE8x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x6C1Ev();
extern void _ZN3ccc5EE8x6D1Ev();
Name_Map name_map__ZN3ccc5EE8x6E[] = {
  NSPAIR(_ZN3ccc5EE8x6C1Ev),
  NSPAIR(_ZN3ccc5EE8x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x6E[];
extern void _ZN3ccc5EE8x63efgEv();
extern void _ZN3ccc5EE8x63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x6E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x6E[] = {
  {&(_ZTVN3ccc5EE8x6E[5]),  5,7},
  {&(_ZTVN3ccc5EE8x6E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x6E[];
Class_Descriptor cd__ZN3ccc5EE8x6E = {  "_ZN3ccc5EE8x6E", // class name
  bases__ZN3ccc5EE8x6E, 1,
  &(vtc__ZN3ccc5EE8x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x6E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x7  : virtual ::ccc::AA8 {
  virtual void  abc(); // _ZN3ccc5EE8x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE8x73pqrEv
  ~EE8x7(); // tgen
  EE8x7(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x7E) C1{ VBC2{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE8x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x73abcEv");}
void  ccc::EE8x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x73pqrEv");}
ccc::EE8x7 ::~EE8x7(){ note_dtor("_ZN3ccc5EE8x7E", this);} // tgen
ccc::EE8x7 ::EE8x7(){ note_ctor("_ZN3ccc5EE8x7E", this);} // tgen
}
static void Test__ZN3ccc5EE8x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x7E, buf);
    ::ccc::EE8x7 *dp, &lv = *(dp=new (buf) ::ccc::EE8x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x7E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x7E);
    dp->::ccc::EE8x7::~EE8x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x7E(Test__ZN3ccc5EE8x7E, "_ZN3ccc5EE8x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x7C1Ev();
extern void _ZN3ccc5EE8x7D1Ev();
Name_Map name_map__ZN3ccc5EE8x7E[] = {
  NSPAIR(_ZN3ccc5EE8x7C1Ev),
  NSPAIR(_ZN3ccc5EE8x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x7E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc5EE8x73abcEv();
extern void _ZN3ccc5EE8x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x7E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x7E[] = {
  {&(_ZTVN3ccc5EE8x7E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x7E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x7E[];
Class_Descriptor cd__ZN3ccc5EE8x7E = {  "_ZN3ccc5EE8x7E", // class name
  bases__ZN3ccc5EE8x7E, 1,
  &(vtc__ZN3ccc5EE8x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x7E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x8  : virtual ::ccc::AA8 {
  virtual void  efg(); // _ZN3ccc5EE8x83efgEv
  virtual void  abc(); // _ZN3ccc5EE8x83abcEv
  ~EE8x8(); // tgen
  EE8x8(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x8E) C1{ VBC2{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE8x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x83efgEv");}
void  ccc::EE8x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE8x83abcEv");}
ccc::EE8x8 ::~EE8x8(){ note_dtor("_ZN3ccc5EE8x8E", this);} // tgen
ccc::EE8x8 ::EE8x8(){ note_ctor("_ZN3ccc5EE8x8E", this);} // tgen
}
static void Test__ZN3ccc5EE8x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x8E, buf);
    ::ccc::EE8x8 *dp, &lv = *(dp=new (buf) ::ccc::EE8x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x8E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x8E);
    dp->::ccc::EE8x8::~EE8x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x8E(Test__ZN3ccc5EE8x8E, "_ZN3ccc5EE8x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x8C1Ev();
extern void _ZN3ccc5EE8x8D1Ev();
Name_Map name_map__ZN3ccc5EE8x8E[] = {
  NSPAIR(_ZN3ccc5EE8x8C1Ev),
  NSPAIR(_ZN3ccc5EE8x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x8E[];
extern void _ZN3ccc5EE8x83efgEv();
extern void _ZN3ccc5EE8x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x8E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x8E[] = {
  {&(_ZTVN3ccc5EE8x8E[5]),  5,7},
  {&(_ZTVN3ccc5EE8x8E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x8E[];
Class_Descriptor cd__ZN3ccc5EE8x8E = {  "_ZN3ccc5EE8x8E", // class name
  bases__ZN3ccc5EE8x8E, 1,
  &(vtc__ZN3ccc5EE8x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x8E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x9  : virtual ::ccc::AA8 {
  virtual void  efg(); // _ZN3ccc5EE8x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE8x93pqrEv
  ~EE8x9(); // tgen
  EE8x9(); // tgen
};
//SIG(-1 _ZN3ccc5EE8x9E) C1{ VBC2{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE8x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE8x93efgEv");}
void  ccc::EE8x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE8x93pqrEv");}
ccc::EE8x9 ::~EE8x9(){ note_dtor("_ZN3ccc5EE8x9E", this);} // tgen
ccc::EE8x9 ::EE8x9(){ note_ctor("_ZN3ccc5EE8x9E", this);} // tgen
}
static void Test__ZN3ccc5EE8x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE8x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE8x9E, buf);
    ::ccc::EE8x9 *dp, &lv = *(dp=new (buf) ::ccc::EE8x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE8x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE8x9E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc5EE8x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE8x9E);
    dp->::ccc::EE8x9::~EE8x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE8x9E(Test__ZN3ccc5EE8x9E, "_ZN3ccc5EE8x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE8x9C1Ev();
extern void _ZN3ccc5EE8x9D1Ev();
Name_Map name_map__ZN3ccc5EE8x9E[] = {
  NSPAIR(_ZN3ccc5EE8x9C1Ev),
  NSPAIR(_ZN3ccc5EE8x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc5EE8x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE8x9E[];
extern void _ZN3ccc5EE8x93efgEv();
extern void _ZN3ccc3AA83abcEv();
extern void _ZN3ccc5EE8x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE8x9E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE8x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE8x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
  (VTBL_ENTRY)&_ZN3ccc5EE8x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE8x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE8x9E[] = {
  {&(_ZTVN3ccc5EE8x9E[5]),  5,8},
  {&(_ZTVN3ccc5EE8x9E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE8x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE8x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE8x9E[];
Class_Descriptor cd__ZN3ccc5EE8x9E = {  "_ZN3ccc5EE8x9E", // class name
  bases__ZN3ccc5EE8x9E, 1,
  &(vtc__ZN3ccc5EE8x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE8x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE8x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE8x9E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE8x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x10  : virtual ::ccc::AA8 {
  virtual void  pqr(); // _ZN3ccc6EE8x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE8x103abcEv
  ~EE8x10(); // tgen
  EE8x10(); // tgen
};
//SIG(-1 _ZN3ccc6EE8x10E) C1{ VBC2{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE8x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE8x103pqrEv");}
void  ccc::EE8x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE8x103abcEv");}
ccc::EE8x10 ::~EE8x10(){ note_dtor("_ZN3ccc6EE8x10E", this);} // tgen
ccc::EE8x10 ::EE8x10(){ note_ctor("_ZN3ccc6EE8x10E", this);} // tgen
}
static void Test__ZN3ccc6EE8x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE8x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE8x10E, buf);
    ::ccc::EE8x10 *dp, &lv = *(dp=new (buf) ::ccc::EE8x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE8x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE8x10E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc6EE8x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE8x10E);
    dp->::ccc::EE8x10::~EE8x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE8x10E(Test__ZN3ccc6EE8x10E, "_ZN3ccc6EE8x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE8x10C1Ev();
extern void _ZN3ccc6EE8x10D1Ev();
Name_Map name_map__ZN3ccc6EE8x10E[] = {
  NSPAIR(_ZN3ccc6EE8x10C1Ev),
  NSPAIR(_ZN3ccc6EE8x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc6EE8x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE8x10E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc6EE8x103abcEv();
extern void _ZN3ccc6EE8x103pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE8x10E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE8x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE8x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE8x103pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE8x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE8x10E[] = {
  {&(_ZTVN3ccc6EE8x10E[5]),  5,8},
  {&(_ZTVN3ccc6EE8x10E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE8x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE8x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE8x10E[];
Class_Descriptor cd__ZN3ccc6EE8x10E = {  "_ZN3ccc6EE8x10E", // class name
  bases__ZN3ccc6EE8x10E, 1,
  &(vtc__ZN3ccc6EE8x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE8x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE8x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE8x10E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE8x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x11  : virtual ::ccc::AA8 {
  virtual void  pqr(); // _ZN3ccc6EE8x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE8x113efgEv
  ~EE8x11(); // tgen
  EE8x11(); // tgen
};
//SIG(-1 _ZN3ccc6EE8x11E) C1{ VBC2{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE8x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE8x113pqrEv");}
void  ccc::EE8x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE8x113efgEv");}
ccc::EE8x11 ::~EE8x11(){ note_dtor("_ZN3ccc6EE8x11E", this);} // tgen
ccc::EE8x11 ::EE8x11(){ note_ctor("_ZN3ccc6EE8x11E", this);} // tgen
}
static void Test__ZN3ccc6EE8x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE8x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE8x11E, buf);
    ::ccc::EE8x11 *dp, &lv = *(dp=new (buf) ::ccc::EE8x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE8x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE8x11E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc6EE8x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE8x11E);
    dp->::ccc::EE8x11::~EE8x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE8x11E(Test__ZN3ccc6EE8x11E, "_ZN3ccc6EE8x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE8x11C1Ev();
extern void _ZN3ccc6EE8x11D1Ev();
Name_Map name_map__ZN3ccc6EE8x11E[] = {
  NSPAIR(_ZN3ccc6EE8x11C1Ev),
  NSPAIR(_ZN3ccc6EE8x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc6EE8x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE8x11E[];
extern void _ZN3ccc6EE8x113efgEv();
extern void _ZN3ccc3AA83abcEv();
extern void _ZN3ccc6EE8x113pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE8x11E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE8x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE8x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE8x113pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE8x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE8x11E[] = {
  {&(_ZTVN3ccc6EE8x11E[5]),  5,8},
  {&(_ZTVN3ccc6EE8x11E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE8x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE8x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE8x11E[];
Class_Descriptor cd__ZN3ccc6EE8x11E = {  "_ZN3ccc6EE8x11E", // class name
  bases__ZN3ccc6EE8x11E, 1,
  &(vtc__ZN3ccc6EE8x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE8x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE8x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE8x11E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE8x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x12  : virtual ::ccc::AA8 {
  virtual void  abc(); // _ZN3ccc6EE8x123abcEv
  ~EE8x12(); // tgen
  EE8x12(); // tgen
};
//SIG(-1 _ZN3ccc6EE8x12E) C1{ VBC2{ v2 v1} v1}
}
namespace ccc { 
void  ccc::EE8x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE8x123abcEv");}
ccc::EE8x12 ::~EE8x12(){ note_dtor("_ZN3ccc6EE8x12E", this);} // tgen
ccc::EE8x12 ::EE8x12(){ note_ctor("_ZN3ccc6EE8x12E", this);} // tgen
}
static void Test__ZN3ccc6EE8x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE8x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE8x12E, buf);
    ::ccc::EE8x12 *dp, &lv = *(dp=new (buf) ::ccc::EE8x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE8x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE8x12E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc6EE8x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE8x12E);
    dp->::ccc::EE8x12::~EE8x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE8x12E(Test__ZN3ccc6EE8x12E, "_ZN3ccc6EE8x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE8x12C1Ev();
extern void _ZN3ccc6EE8x12D1Ev();
Name_Map name_map__ZN3ccc6EE8x12E[] = {
  NSPAIR(_ZN3ccc6EE8x12C1Ev),
  NSPAIR(_ZN3ccc6EE8x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc6EE8x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE8x12E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc6EE8x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE8x12E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE8x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE8x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE8x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE8x12E[] = {
  {&(_ZTVN3ccc6EE8x12E[5]),  5,7},
  {&(_ZTVN3ccc6EE8x12E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE8x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE8x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE8x12E[];
Class_Descriptor cd__ZN3ccc6EE8x12E = {  "_ZN3ccc6EE8x12E", // class name
  bases__ZN3ccc6EE8x12E, 1,
  &(vtc__ZN3ccc6EE8x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE8x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE8x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE8x12E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE8x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x13  : virtual ::ccc::AA8 {
  virtual void  efg(); // _ZN3ccc6EE8x133efgEv
  ~EE8x13(); // tgen
  EE8x13(); // tgen
};
//SIG(-1 _ZN3ccc6EE8x13E) C1{ VBC2{ v1 v2} v1}
}
namespace ccc { 
void  ccc::EE8x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE8x133efgEv");}
ccc::EE8x13 ::~EE8x13(){ note_dtor("_ZN3ccc6EE8x13E", this);} // tgen
ccc::EE8x13 ::EE8x13(){ note_ctor("_ZN3ccc6EE8x13E", this);} // tgen
}
static void Test__ZN3ccc6EE8x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE8x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE8x13E, buf);
    ::ccc::EE8x13 *dp, &lv = *(dp=new (buf) ::ccc::EE8x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE8x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE8x13E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc6EE8x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE8x13E);
    dp->::ccc::EE8x13::~EE8x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE8x13E(Test__ZN3ccc6EE8x13E, "_ZN3ccc6EE8x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE8x13C1Ev();
extern void _ZN3ccc6EE8x13D1Ev();
Name_Map name_map__ZN3ccc6EE8x13E[] = {
  NSPAIR(_ZN3ccc6EE8x13C1Ev),
  NSPAIR(_ZN3ccc6EE8x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc6EE8x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE8x13E[];
extern void _ZN3ccc6EE8x133efgEv();
extern void _ZN3ccc3AA83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE8x13E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE8x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE8x133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE8x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE8x13E[] = {
  {&(_ZTVN3ccc6EE8x13E[5]),  5,7},
  {&(_ZTVN3ccc6EE8x13E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE8x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE8x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE8x13E[];
Class_Descriptor cd__ZN3ccc6EE8x13E = {  "_ZN3ccc6EE8x13E", // class name
  bases__ZN3ccc6EE8x13E, 1,
  &(vtc__ZN3ccc6EE8x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE8x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE8x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE8x13E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE8x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x14  : virtual ::ccc::AA8 {
  virtual void  pqr(); // _ZN3ccc6EE8x143pqrEv
  ~EE8x14(); // tgen
  EE8x14(); // tgen
};
//SIG(-1 _ZN3ccc6EE8x14E) C1{ VBC2{ v2 v3} v1}
}
namespace ccc { 
void  ccc::EE8x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE8x143pqrEv");}
ccc::EE8x14 ::~EE8x14(){ note_dtor("_ZN3ccc6EE8x14E", this);} // tgen
ccc::EE8x14 ::EE8x14(){ note_ctor("_ZN3ccc6EE8x14E", this);} // tgen
}
static void Test__ZN3ccc6EE8x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE8x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE8x14E, buf);
    ::ccc::EE8x14 *dp, &lv = *(dp=new (buf) ::ccc::EE8x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE8x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE8x14E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc6EE8x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE8x14E);
    dp->::ccc::EE8x14::~EE8x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE8x14E(Test__ZN3ccc6EE8x14E, "_ZN3ccc6EE8x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE8x14C1Ev();
extern void _ZN3ccc6EE8x14D1Ev();
Name_Map name_map__ZN3ccc6EE8x14E[] = {
  NSPAIR(_ZN3ccc6EE8x14C1Ev),
  NSPAIR(_ZN3ccc6EE8x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc6EE8x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE8x14E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc3AA83abcEv();
extern void _ZN3ccc6EE8x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE8x14E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE8x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE8x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE8x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE8x14E[] = {
  {&(_ZTVN3ccc6EE8x14E[5]),  5,8},
  {&(_ZTVN3ccc6EE8x14E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE8x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE8x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE8x14E[];
Class_Descriptor cd__ZN3ccc6EE8x14E = {  "_ZN3ccc6EE8x14E", // class name
  bases__ZN3ccc6EE8x14E, 1,
  &(vtc__ZN3ccc6EE8x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE8x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE8x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE8x14E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE8x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE8x15  : virtual ::ccc::AA8 {
  ~EE8x15(); // tgen
  EE8x15(); // tgen
};
//SIG(-1 _ZN3ccc6EE8x15E) C1{ VBC2{ v1 v2}}
}
namespace ccc { 
ccc::EE8x15 ::~EE8x15(){ note_dtor("_ZN3ccc6EE8x15E", this);} // tgen
ccc::EE8x15 ::EE8x15(){ note_ctor("_ZN3ccc6EE8x15E", this);} // tgen
}
static void Test__ZN3ccc6EE8x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE8x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE8x15E, buf);
    ::ccc::EE8x15 *dp, &lv = *(dp=new (buf) ::ccc::EE8x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE8x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE8x15E)");
    check_base_class_offset(lv, (::ccc::AA8*), 0, "_ZN3ccc6EE8x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE8x15E);
    dp->::ccc::EE8x15::~EE8x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE8x15E(Test__ZN3ccc6EE8x15E, "_ZN3ccc6EE8x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE8x15C1Ev();
extern void _ZN3ccc6EE8x15D1Ev();
Name_Map name_map__ZN3ccc6EE8x15E[] = {
  NSPAIR(_ZN3ccc6EE8x15C1Ev),
  NSPAIR(_ZN3ccc6EE8x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA8E;
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
static Base_Class bases__ZN3ccc6EE8x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE8x15E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc3AA83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE8x15E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE8x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE8x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE8x15E[] = {
  {&(_ZTVN3ccc6EE8x15E[5]),  5,7},
  {&(_ZTVN3ccc6EE8x15E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE8x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE8x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE8x15E[];
Class_Descriptor cd__ZN3ccc6EE8x15E = {  "_ZN3ccc6EE8x15E", // class name
  bases__ZN3ccc6EE8x15E, 1,
  &(vtc__ZN3ccc6EE8x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE8x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE8x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE8x15E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE8x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA9  {
  virtual void  efg(); // _ZN3ccc3AA93efgEv
  virtual void  pqr(); // _ZN3ccc3AA93pqrEv
  ~AA9(); // tgen
  AA9(); // tgen
};
//SIG(-1 _ZN3ccc3AA9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA9 ::efg(){vfunc_called(this, "_ZN3ccc3AA93efgEv");}
void  ccc::AA9 ::pqr(){vfunc_called(this, "_ZN3ccc3AA93pqrEv");}
ccc::AA9 ::~AA9(){ note_dtor("_ZN3ccc3AA9E", this);} // tgen
ccc::AA9 ::AA9(){ note_ctor("_ZN3ccc3AA9E", this);} // tgen
}
static void Test__ZN3ccc3AA9E()
{
  extern Class_Descriptor cd__ZN3ccc3AA9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA9E, buf);
    ::ccc::AA9 *dp, &lv = *(dp=new (buf) ::ccc::AA9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA9E)");
    test_class_info(&lv, &cd__ZN3ccc3AA9E);
    dp->::ccc::AA9::~AA9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA9E(Test__ZN3ccc3AA9E, "_ZN3ccc3AA9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA9C1Ev();
extern void _ZN3ccc3AA9D1Ev();
Name_Map name_map__ZN3ccc3AA9E[] = {
  NSPAIR(_ZN3ccc3AA9C1Ev),
  NSPAIR(_ZN3ccc3AA9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc3AA93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
Class_Descriptor cd__ZN3ccc3AA9E = {  "_ZN3ccc3AA9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB9  {
  virtual void  efg(); // _ZN3ccc3BB93efgEv
  virtual void  pqr(); // _ZN3ccc3BB93pqrEv
  ~BB9(); // tgen
  BB9(); // tgen
};
//SIG(1 _ZN3ccc3BB9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB9 ::efg(){vfunc_called(this, "_ZN3ccc3BB93efgEv");}
void  ccc::BB9 ::pqr(){vfunc_called(this, "_ZN3ccc3BB93pqrEv");}
ccc::BB9 ::~BB9(){ note_dtor("_ZN3ccc3BB9E", this);} // tgen
ccc::BB9 ::BB9(){ note_ctor("_ZN3ccc3BB9E", this);} // tgen
}
static void Test__ZN3ccc3BB9E()
{
  extern Class_Descriptor cd__ZN3ccc3BB9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB9E, buf);
    ::ccc::BB9 *dp, &lv = *(dp=new (buf) ::ccc::BB9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB9E)");
    test_class_info(&lv, &cd__ZN3ccc3BB9E);
    dp->::ccc::BB9::~BB9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB9E(Test__ZN3ccc3BB9E, "_ZN3ccc3BB9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB9C1Ev();
extern void _ZN3ccc3BB9D1Ev();
Name_Map name_map__ZN3ccc3BB9E[] = {
  NSPAIR(_ZN3ccc3BB9C1Ev),
  NSPAIR(_ZN3ccc3BB9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
Class_Descriptor cd__ZN3ccc3BB9E = {  "_ZN3ccc3BB9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x0  : virtual ::ccc::AA9 {
  virtual void  abc(); // _ZN3ccc5EE9x03abcEv
  virtual void  efg(); // _ZN3ccc5EE9x03efgEv
  virtual void  pqr(); // _ZN3ccc5EE9x03pqrEv
  ~EE9x0(); // tgen
  EE9x0(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x0E) C1{ VBC2{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE9x0 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x03abcEv");}
void  ccc::EE9x0 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x03efgEv");}
void  ccc::EE9x0 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x03pqrEv");}
ccc::EE9x0 ::~EE9x0(){ note_dtor("_ZN3ccc5EE9x0E", this);} // tgen
ccc::EE9x0 ::EE9x0(){ note_ctor("_ZN3ccc5EE9x0E", this);} // tgen
}
static void Test__ZN3ccc5EE9x0E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x0E, buf);
    ::ccc::EE9x0 *dp, &lv = *(dp=new (buf) ::ccc::EE9x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x0E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x0E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x0E);
    dp->::ccc::EE9x0::~EE9x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x0E(Test__ZN3ccc5EE9x0E, "_ZN3ccc5EE9x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x0C1Ev();
extern void _ZN3ccc5EE9x0D1Ev();
Name_Map name_map__ZN3ccc5EE9x0E[] = {
  NSPAIR(_ZN3ccc5EE9x0C1Ev),
  NSPAIR(_ZN3ccc5EE9x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x0E[];
extern void _ZN3ccc5EE9x03efgEv();
extern void _ZN3ccc5EE9x03pqrEv();
extern void _ZN3ccc5EE9x03abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x0E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x03abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x0E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x0E[] = {
  {&(_ZTVN3ccc5EE9x0E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x0E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x0E[];
Class_Descriptor cd__ZN3ccc5EE9x0E = {  "_ZN3ccc5EE9x0E", // class name
  bases__ZN3ccc5EE9x0E, 1,
  &(vtc__ZN3ccc5EE9x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x0E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x1  : virtual ::ccc::AA9 {
  virtual void  abc(); // _ZN3ccc5EE9x13abcEv
  virtual void  pqr(); // _ZN3ccc5EE9x13pqrEv
  virtual void  efg(); // _ZN3ccc5EE9x13efgEv
  ~EE9x1(); // tgen
  EE9x1(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x1E) C1{ VBC2{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE9x1 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x13abcEv");}
void  ccc::EE9x1 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x13pqrEv");}
void  ccc::EE9x1 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x13efgEv");}
ccc::EE9x1 ::~EE9x1(){ note_dtor("_ZN3ccc5EE9x1E", this);} // tgen
ccc::EE9x1 ::EE9x1(){ note_ctor("_ZN3ccc5EE9x1E", this);} // tgen
}
static void Test__ZN3ccc5EE9x1E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x1E, buf);
    ::ccc::EE9x1 *dp, &lv = *(dp=new (buf) ::ccc::EE9x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x1E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x1E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x1E);
    dp->::ccc::EE9x1::~EE9x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x1E(Test__ZN3ccc5EE9x1E, "_ZN3ccc5EE9x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x1C1Ev();
extern void _ZN3ccc5EE9x1D1Ev();
Name_Map name_map__ZN3ccc5EE9x1E[] = {
  NSPAIR(_ZN3ccc5EE9x1C1Ev),
  NSPAIR(_ZN3ccc5EE9x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x1E[];
extern void _ZN3ccc5EE9x13efgEv();
extern void _ZN3ccc5EE9x13pqrEv();
extern void _ZN3ccc5EE9x13abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x1E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x13abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x1E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x1E[] = {
  {&(_ZTVN3ccc5EE9x1E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x1E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x1E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x1E[];
Class_Descriptor cd__ZN3ccc5EE9x1E = {  "_ZN3ccc5EE9x1E", // class name
  bases__ZN3ccc5EE9x1E, 1,
  &(vtc__ZN3ccc5EE9x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x1E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x2  : virtual ::ccc::AA9 {
  virtual void  efg(); // _ZN3ccc5EE9x23efgEv
  virtual void  abc(); // _ZN3ccc5EE9x23abcEv
  virtual void  pqr(); // _ZN3ccc5EE9x23pqrEv
  ~EE9x2(); // tgen
  EE9x2(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x2E) C1{ VBC2{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE9x2 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x23efgEv");}
void  ccc::EE9x2 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x23abcEv");}
void  ccc::EE9x2 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x23pqrEv");}
ccc::EE9x2 ::~EE9x2(){ note_dtor("_ZN3ccc5EE9x2E", this);} // tgen
ccc::EE9x2 ::EE9x2(){ note_ctor("_ZN3ccc5EE9x2E", this);} // tgen
}
static void Test__ZN3ccc5EE9x2E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x2E, buf);
    ::ccc::EE9x2 *dp, &lv = *(dp=new (buf) ::ccc::EE9x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x2E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x2E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x2E);
    dp->::ccc::EE9x2::~EE9x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x2E(Test__ZN3ccc5EE9x2E, "_ZN3ccc5EE9x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x2C1Ev();
extern void _ZN3ccc5EE9x2D1Ev();
Name_Map name_map__ZN3ccc5EE9x2E[] = {
  NSPAIR(_ZN3ccc5EE9x2C1Ev),
  NSPAIR(_ZN3ccc5EE9x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x2E[];
extern void _ZN3ccc5EE9x23efgEv();
extern void _ZN3ccc5EE9x23pqrEv();
extern void _ZN3ccc5EE9x23abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x2E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x23abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x2E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x2E[] = {
  {&(_ZTVN3ccc5EE9x2E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x2E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x2E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x2E[];
Class_Descriptor cd__ZN3ccc5EE9x2E = {  "_ZN3ccc5EE9x2E", // class name
  bases__ZN3ccc5EE9x2E, 1,
  &(vtc__ZN3ccc5EE9x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x2E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x3  : virtual ::ccc::AA9 {
  virtual void  efg(); // _ZN3ccc5EE9x33efgEv
  virtual void  pqr(); // _ZN3ccc5EE9x33pqrEv
  virtual void  abc(); // _ZN3ccc5EE9x33abcEv
  ~EE9x3(); // tgen
  EE9x3(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x3E) C1{ VBC2{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE9x3 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x33efgEv");}
void  ccc::EE9x3 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x33pqrEv");}
void  ccc::EE9x3 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x33abcEv");}
ccc::EE9x3 ::~EE9x3(){ note_dtor("_ZN3ccc5EE9x3E", this);} // tgen
ccc::EE9x3 ::EE9x3(){ note_ctor("_ZN3ccc5EE9x3E", this);} // tgen
}
static void Test__ZN3ccc5EE9x3E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x3E, buf);
    ::ccc::EE9x3 *dp, &lv = *(dp=new (buf) ::ccc::EE9x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x3E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x3E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x3E);
    dp->::ccc::EE9x3::~EE9x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x3E(Test__ZN3ccc5EE9x3E, "_ZN3ccc5EE9x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x3C1Ev();
extern void _ZN3ccc5EE9x3D1Ev();
Name_Map name_map__ZN3ccc5EE9x3E[] = {
  NSPAIR(_ZN3ccc5EE9x3C1Ev),
  NSPAIR(_ZN3ccc5EE9x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x3E[];
extern void _ZN3ccc5EE9x33efgEv();
extern void _ZN3ccc5EE9x33pqrEv();
extern void _ZN3ccc5EE9x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x3E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x3E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x3E[] = {
  {&(_ZTVN3ccc5EE9x3E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x3E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x3E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x3E[];
Class_Descriptor cd__ZN3ccc5EE9x3E = {  "_ZN3ccc5EE9x3E", // class name
  bases__ZN3ccc5EE9x3E, 1,
  &(vtc__ZN3ccc5EE9x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x3E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x4  : virtual ::ccc::AA9 {
  virtual void  pqr(); // _ZN3ccc5EE9x43pqrEv
  virtual void  abc(); // _ZN3ccc5EE9x43abcEv
  virtual void  efg(); // _ZN3ccc5EE9x43efgEv
  ~EE9x4(); // tgen
  EE9x4(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x4E) C1{ VBC2{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE9x4 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x43pqrEv");}
void  ccc::EE9x4 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x43abcEv");}
void  ccc::EE9x4 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x43efgEv");}
ccc::EE9x4 ::~EE9x4(){ note_dtor("_ZN3ccc5EE9x4E", this);} // tgen
ccc::EE9x4 ::EE9x4(){ note_ctor("_ZN3ccc5EE9x4E", this);} // tgen
}
static void Test__ZN3ccc5EE9x4E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x4E, buf);
    ::ccc::EE9x4 *dp, &lv = *(dp=new (buf) ::ccc::EE9x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x4E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x4E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x4E);
    dp->::ccc::EE9x4::~EE9x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x4E(Test__ZN3ccc5EE9x4E, "_ZN3ccc5EE9x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x4C1Ev();
extern void _ZN3ccc5EE9x4D1Ev();
Name_Map name_map__ZN3ccc5EE9x4E[] = {
  NSPAIR(_ZN3ccc5EE9x4C1Ev),
  NSPAIR(_ZN3ccc5EE9x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x4E[];
extern void _ZN3ccc5EE9x43efgEv();
extern void _ZN3ccc5EE9x43pqrEv();
extern void _ZN3ccc5EE9x43abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x4E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x43abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x4E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x4E[] = {
  {&(_ZTVN3ccc5EE9x4E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x4E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x4E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x4E[];
Class_Descriptor cd__ZN3ccc5EE9x4E = {  "_ZN3ccc5EE9x4E", // class name
  bases__ZN3ccc5EE9x4E, 1,
  &(vtc__ZN3ccc5EE9x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x4E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x5  : virtual ::ccc::AA9 {
  virtual void  pqr(); // _ZN3ccc5EE9x53pqrEv
  virtual void  efg(); // _ZN3ccc5EE9x53efgEv
  virtual void  abc(); // _ZN3ccc5EE9x53abcEv
  ~EE9x5(); // tgen
  EE9x5(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x5E) C1{ VBC2{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE9x5 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x53pqrEv");}
void  ccc::EE9x5 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x53efgEv");}
void  ccc::EE9x5 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x53abcEv");}
ccc::EE9x5 ::~EE9x5(){ note_dtor("_ZN3ccc5EE9x5E", this);} // tgen
ccc::EE9x5 ::EE9x5(){ note_ctor("_ZN3ccc5EE9x5E", this);} // tgen
}
static void Test__ZN3ccc5EE9x5E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x5E, buf);
    ::ccc::EE9x5 *dp, &lv = *(dp=new (buf) ::ccc::EE9x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x5E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x5E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x5E);
    dp->::ccc::EE9x5::~EE9x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x5E(Test__ZN3ccc5EE9x5E, "_ZN3ccc5EE9x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x5C1Ev();
extern void _ZN3ccc5EE9x5D1Ev();
Name_Map name_map__ZN3ccc5EE9x5E[] = {
  NSPAIR(_ZN3ccc5EE9x5C1Ev),
  NSPAIR(_ZN3ccc5EE9x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x5E[];
extern void _ZN3ccc5EE9x53efgEv();
extern void _ZN3ccc5EE9x53pqrEv();
extern void _ZN3ccc5EE9x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x5E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x5E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x5E[] = {
  {&(_ZTVN3ccc5EE9x5E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x5E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x5E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x5E[];
Class_Descriptor cd__ZN3ccc5EE9x5E = {  "_ZN3ccc5EE9x5E", // class name
  bases__ZN3ccc5EE9x5E, 1,
  &(vtc__ZN3ccc5EE9x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x5E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x6  : virtual ::ccc::AA9 {
  virtual void  abc(); // _ZN3ccc5EE9x63abcEv
  virtual void  efg(); // _ZN3ccc5EE9x63efgEv
  ~EE9x6(); // tgen
  EE9x6(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x6E) C1{ VBC2{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE9x6 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x63abcEv");}
void  ccc::EE9x6 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x63efgEv");}
ccc::EE9x6 ::~EE9x6(){ note_dtor("_ZN3ccc5EE9x6E", this);} // tgen
ccc::EE9x6 ::EE9x6(){ note_ctor("_ZN3ccc5EE9x6E", this);} // tgen
}
static void Test__ZN3ccc5EE9x6E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x6E, buf);
    ::ccc::EE9x6 *dp, &lv = *(dp=new (buf) ::ccc::EE9x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x6E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x6E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x6E);
    dp->::ccc::EE9x6::~EE9x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x6E(Test__ZN3ccc5EE9x6E, "_ZN3ccc5EE9x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x6C1Ev();
extern void _ZN3ccc5EE9x6D1Ev();
Name_Map name_map__ZN3ccc5EE9x6E[] = {
  NSPAIR(_ZN3ccc5EE9x6C1Ev),
  NSPAIR(_ZN3ccc5EE9x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x6E[];
extern void _ZN3ccc5EE9x63efgEv();
extern void _ZN3ccc3AA93pqrEv();
extern void _ZN3ccc5EE9x63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x6E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x6E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x6E[] = {
  {&(_ZTVN3ccc5EE9x6E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x6E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x6E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x6E[];
Class_Descriptor cd__ZN3ccc5EE9x6E = {  "_ZN3ccc5EE9x6E", // class name
  bases__ZN3ccc5EE9x6E, 1,
  &(vtc__ZN3ccc5EE9x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x6E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x7  : virtual ::ccc::AA9 {
  virtual void  abc(); // _ZN3ccc5EE9x73abcEv
  virtual void  pqr(); // _ZN3ccc5EE9x73pqrEv
  ~EE9x7(); // tgen
  EE9x7(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x7E) C1{ VBC2{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE9x7 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x73abcEv");}
void  ccc::EE9x7 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x73pqrEv");}
ccc::EE9x7 ::~EE9x7(){ note_dtor("_ZN3ccc5EE9x7E", this);} // tgen
ccc::EE9x7 ::EE9x7(){ note_ctor("_ZN3ccc5EE9x7E", this);} // tgen
}
static void Test__ZN3ccc5EE9x7E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x7E, buf);
    ::ccc::EE9x7 *dp, &lv = *(dp=new (buf) ::ccc::EE9x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x7E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x7E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x7E);
    dp->::ccc::EE9x7::~EE9x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x7E(Test__ZN3ccc5EE9x7E, "_ZN3ccc5EE9x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x7C1Ev();
extern void _ZN3ccc5EE9x7D1Ev();
Name_Map name_map__ZN3ccc5EE9x7E[] = {
  NSPAIR(_ZN3ccc5EE9x7C1Ev),
  NSPAIR(_ZN3ccc5EE9x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x7E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc5EE9x73pqrEv();
extern void _ZN3ccc5EE9x73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x7E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x7E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x7E[] = {
  {&(_ZTVN3ccc5EE9x7E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x7E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x7E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x7E[];
Class_Descriptor cd__ZN3ccc5EE9x7E = {  "_ZN3ccc5EE9x7E", // class name
  bases__ZN3ccc5EE9x7E, 1,
  &(vtc__ZN3ccc5EE9x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x7E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x8  : virtual ::ccc::AA9 {
  virtual void  efg(); // _ZN3ccc5EE9x83efgEv
  virtual void  abc(); // _ZN3ccc5EE9x83abcEv
  ~EE9x8(); // tgen
  EE9x8(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x8E) C1{ VBC2{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE9x8 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x83efgEv");}
void  ccc::EE9x8 ::abc(){vfunc_called(this, "_ZN3ccc5EE9x83abcEv");}
ccc::EE9x8 ::~EE9x8(){ note_dtor("_ZN3ccc5EE9x8E", this);} // tgen
ccc::EE9x8 ::EE9x8(){ note_ctor("_ZN3ccc5EE9x8E", this);} // tgen
}
static void Test__ZN3ccc5EE9x8E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x8E, buf);
    ::ccc::EE9x8 *dp, &lv = *(dp=new (buf) ::ccc::EE9x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x8E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x8E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x8E);
    dp->::ccc::EE9x8::~EE9x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x8E(Test__ZN3ccc5EE9x8E, "_ZN3ccc5EE9x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x8C1Ev();
extern void _ZN3ccc5EE9x8D1Ev();
Name_Map name_map__ZN3ccc5EE9x8E[] = {
  NSPAIR(_ZN3ccc5EE9x8C1Ev),
  NSPAIR(_ZN3ccc5EE9x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x8E[];
extern void _ZN3ccc5EE9x83efgEv();
extern void _ZN3ccc3AA93pqrEv();
extern void _ZN3ccc5EE9x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x8E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x8E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x8E[] = {
  {&(_ZTVN3ccc5EE9x8E[5]),  5,8},
  {&(_ZTVN3ccc5EE9x8E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x8E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x8E[];
Class_Descriptor cd__ZN3ccc5EE9x8E = {  "_ZN3ccc5EE9x8E", // class name
  bases__ZN3ccc5EE9x8E, 1,
  &(vtc__ZN3ccc5EE9x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x8E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x9  : virtual ::ccc::AA9 {
  virtual void  efg(); // _ZN3ccc5EE9x93efgEv
  virtual void  pqr(); // _ZN3ccc5EE9x93pqrEv
  ~EE9x9(); // tgen
  EE9x9(); // tgen
};
//SIG(-1 _ZN3ccc5EE9x9E) C1{ VBC2{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE9x9 ::efg(){vfunc_called(this, "_ZN3ccc5EE9x93efgEv");}
void  ccc::EE9x9 ::pqr(){vfunc_called(this, "_ZN3ccc5EE9x93pqrEv");}
ccc::EE9x9 ::~EE9x9(){ note_dtor("_ZN3ccc5EE9x9E", this);} // tgen
ccc::EE9x9 ::EE9x9(){ note_ctor("_ZN3ccc5EE9x9E", this);} // tgen
}
static void Test__ZN3ccc5EE9x9E()
{
  extern Class_Descriptor cd__ZN3ccc5EE9x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc5EE9x9E, buf);
    ::ccc::EE9x9 *dp, &lv = *(dp=new (buf) ::ccc::EE9x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc5EE9x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc5EE9x9E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc5EE9x9E");
    test_class_info(&lv, &cd__ZN3ccc5EE9x9E);
    dp->::ccc::EE9x9::~EE9x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc5EE9x9E(Test__ZN3ccc5EE9x9E, "_ZN3ccc5EE9x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc5EE9x9C1Ev();
extern void _ZN3ccc5EE9x9D1Ev();
Name_Map name_map__ZN3ccc5EE9x9E[] = {
  NSPAIR(_ZN3ccc5EE9x9C1Ev),
  NSPAIR(_ZN3ccc5EE9x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc5EE9x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc5EE9x9E[];
extern void _ZN3ccc5EE9x93efgEv();
extern void _ZN3ccc5EE9x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc5EE9x9E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE9x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc5EE9x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc5EE9x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc5EE9x9E[];
static  VTT_ENTRY vtt__ZN3ccc5EE9x9E[] = {
  {&(_ZTVN3ccc5EE9x9E[5]),  5,7},
  {&(_ZTVN3ccc5EE9x9E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc5EE9x9E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE9x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE9x9E[];
Class_Descriptor cd__ZN3ccc5EE9x9E = {  "_ZN3ccc5EE9x9E", // class name
  bases__ZN3ccc5EE9x9E, 1,
  &(vtc__ZN3ccc5EE9x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc5EE9x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc5EE9x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc5EE9x9E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc5EE9x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x10  : virtual ::ccc::AA9 {
  virtual void  pqr(); // _ZN3ccc6EE9x103pqrEv
  virtual void  abc(); // _ZN3ccc6EE9x103abcEv
  ~EE9x10(); // tgen
  EE9x10(); // tgen
};
//SIG(-1 _ZN3ccc6EE9x10E) C1{ VBC2{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE9x10 ::pqr(){vfunc_called(this, "_ZN3ccc6EE9x103pqrEv");}
void  ccc::EE9x10 ::abc(){vfunc_called(this, "_ZN3ccc6EE9x103abcEv");}
ccc::EE9x10 ::~EE9x10(){ note_dtor("_ZN3ccc6EE9x10E", this);} // tgen
ccc::EE9x10 ::EE9x10(){ note_ctor("_ZN3ccc6EE9x10E", this);} // tgen
}
static void Test__ZN3ccc6EE9x10E()
{
  extern Class_Descriptor cd__ZN3ccc6EE9x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE9x10E, buf);
    ::ccc::EE9x10 *dp, &lv = *(dp=new (buf) ::ccc::EE9x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE9x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE9x10E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc6EE9x10E");
    test_class_info(&lv, &cd__ZN3ccc6EE9x10E);
    dp->::ccc::EE9x10::~EE9x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE9x10E(Test__ZN3ccc6EE9x10E, "_ZN3ccc6EE9x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE9x10C1Ev();
extern void _ZN3ccc6EE9x10D1Ev();
Name_Map name_map__ZN3ccc6EE9x10E[] = {
  NSPAIR(_ZN3ccc6EE9x10C1Ev),
  NSPAIR(_ZN3ccc6EE9x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc6EE9x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE9x10E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc6EE9x103pqrEv();
extern void _ZN3ccc6EE9x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE9x10E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE9x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE9x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE9x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE9x10E[];
static  VTT_ENTRY vtt__ZN3ccc6EE9x10E[] = {
  {&(_ZTVN3ccc6EE9x10E[5]),  5,8},
  {&(_ZTVN3ccc6EE9x10E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE9x10E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE9x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE9x10E[];
Class_Descriptor cd__ZN3ccc6EE9x10E = {  "_ZN3ccc6EE9x10E", // class name
  bases__ZN3ccc6EE9x10E, 1,
  &(vtc__ZN3ccc6EE9x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE9x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE9x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE9x10E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE9x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x11  : virtual ::ccc::AA9 {
  virtual void  pqr(); // _ZN3ccc6EE9x113pqrEv
  virtual void  efg(); // _ZN3ccc6EE9x113efgEv
  ~EE9x11(); // tgen
  EE9x11(); // tgen
};
//SIG(-1 _ZN3ccc6EE9x11E) C1{ VBC2{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE9x11 ::pqr(){vfunc_called(this, "_ZN3ccc6EE9x113pqrEv");}
void  ccc::EE9x11 ::efg(){vfunc_called(this, "_ZN3ccc6EE9x113efgEv");}
ccc::EE9x11 ::~EE9x11(){ note_dtor("_ZN3ccc6EE9x11E", this);} // tgen
ccc::EE9x11 ::EE9x11(){ note_ctor("_ZN3ccc6EE9x11E", this);} // tgen
}
static void Test__ZN3ccc6EE9x11E()
{
  extern Class_Descriptor cd__ZN3ccc6EE9x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE9x11E, buf);
    ::ccc::EE9x11 *dp, &lv = *(dp=new (buf) ::ccc::EE9x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE9x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE9x11E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc6EE9x11E");
    test_class_info(&lv, &cd__ZN3ccc6EE9x11E);
    dp->::ccc::EE9x11::~EE9x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE9x11E(Test__ZN3ccc6EE9x11E, "_ZN3ccc6EE9x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE9x11C1Ev();
extern void _ZN3ccc6EE9x11D1Ev();
Name_Map name_map__ZN3ccc6EE9x11E[] = {
  NSPAIR(_ZN3ccc6EE9x11C1Ev),
  NSPAIR(_ZN3ccc6EE9x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc6EE9x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE9x11E[];
extern void _ZN3ccc6EE9x113efgEv();
extern void _ZN3ccc6EE9x113pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE9x11E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE9x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE9x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE9x113pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE9x11E[];
static  VTT_ENTRY vtt__ZN3ccc6EE9x11E[] = {
  {&(_ZTVN3ccc6EE9x11E[5]),  5,7},
  {&(_ZTVN3ccc6EE9x11E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE9x11E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE9x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE9x11E[];
Class_Descriptor cd__ZN3ccc6EE9x11E = {  "_ZN3ccc6EE9x11E", // class name
  bases__ZN3ccc6EE9x11E, 1,
  &(vtc__ZN3ccc6EE9x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE9x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE9x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE9x11E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE9x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x12  : virtual ::ccc::AA9 {
  virtual void  abc(); // _ZN3ccc6EE9x123abcEv
  ~EE9x12(); // tgen
  EE9x12(); // tgen
};
//SIG(-1 _ZN3ccc6EE9x12E) C1{ VBC2{ v2 v3} v1}
}
namespace ccc { 
void  ccc::EE9x12 ::abc(){vfunc_called(this, "_ZN3ccc6EE9x123abcEv");}
ccc::EE9x12 ::~EE9x12(){ note_dtor("_ZN3ccc6EE9x12E", this);} // tgen
ccc::EE9x12 ::EE9x12(){ note_ctor("_ZN3ccc6EE9x12E", this);} // tgen
}
static void Test__ZN3ccc6EE9x12E()
{
  extern Class_Descriptor cd__ZN3ccc6EE9x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE9x12E, buf);
    ::ccc::EE9x12 *dp, &lv = *(dp=new (buf) ::ccc::EE9x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE9x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE9x12E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc6EE9x12E");
    test_class_info(&lv, &cd__ZN3ccc6EE9x12E);
    dp->::ccc::EE9x12::~EE9x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE9x12E(Test__ZN3ccc6EE9x12E, "_ZN3ccc6EE9x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE9x12C1Ev();
extern void _ZN3ccc6EE9x12D1Ev();
Name_Map name_map__ZN3ccc6EE9x12E[] = {
  NSPAIR(_ZN3ccc6EE9x12C1Ev),
  NSPAIR(_ZN3ccc6EE9x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc6EE9x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE9x12E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc3AA93pqrEv();
extern void _ZN3ccc6EE9x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE9x12E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE9x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE9x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE9x12E[];
static  VTT_ENTRY vtt__ZN3ccc6EE9x12E[] = {
  {&(_ZTVN3ccc6EE9x12E[5]),  5,8},
  {&(_ZTVN3ccc6EE9x12E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE9x12E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE9x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE9x12E[];
Class_Descriptor cd__ZN3ccc6EE9x12E = {  "_ZN3ccc6EE9x12E", // class name
  bases__ZN3ccc6EE9x12E, 1,
  &(vtc__ZN3ccc6EE9x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE9x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE9x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE9x12E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE9x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x13  : virtual ::ccc::AA9 {
  virtual void  efg(); // _ZN3ccc6EE9x133efgEv
  ~EE9x13(); // tgen
  EE9x13(); // tgen
};
//SIG(-1 _ZN3ccc6EE9x13E) C1{ VBC2{ v1 v2} v1}
}
namespace ccc { 
void  ccc::EE9x13 ::efg(){vfunc_called(this, "_ZN3ccc6EE9x133efgEv");}
ccc::EE9x13 ::~EE9x13(){ note_dtor("_ZN3ccc6EE9x13E", this);} // tgen
ccc::EE9x13 ::EE9x13(){ note_ctor("_ZN3ccc6EE9x13E", this);} // tgen
}
static void Test__ZN3ccc6EE9x13E()
{
  extern Class_Descriptor cd__ZN3ccc6EE9x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE9x13E, buf);
    ::ccc::EE9x13 *dp, &lv = *(dp=new (buf) ::ccc::EE9x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE9x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE9x13E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc6EE9x13E");
    test_class_info(&lv, &cd__ZN3ccc6EE9x13E);
    dp->::ccc::EE9x13::~EE9x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE9x13E(Test__ZN3ccc6EE9x13E, "_ZN3ccc6EE9x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE9x13C1Ev();
extern void _ZN3ccc6EE9x13D1Ev();
Name_Map name_map__ZN3ccc6EE9x13E[] = {
  NSPAIR(_ZN3ccc6EE9x13C1Ev),
  NSPAIR(_ZN3ccc6EE9x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc6EE9x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE9x13E[];
extern void _ZN3ccc6EE9x133efgEv();
extern void _ZN3ccc3AA93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE9x13E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE9x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE9x133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE9x13E[];
static  VTT_ENTRY vtt__ZN3ccc6EE9x13E[] = {
  {&(_ZTVN3ccc6EE9x13E[5]),  5,7},
  {&(_ZTVN3ccc6EE9x13E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE9x13E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE9x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE9x13E[];
Class_Descriptor cd__ZN3ccc6EE9x13E = {  "_ZN3ccc6EE9x13E", // class name
  bases__ZN3ccc6EE9x13E, 1,
  &(vtc__ZN3ccc6EE9x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE9x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE9x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE9x13E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE9x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x14  : virtual ::ccc::AA9 {
  virtual void  pqr(); // _ZN3ccc6EE9x143pqrEv
  ~EE9x14(); // tgen
  EE9x14(); // tgen
};
//SIG(-1 _ZN3ccc6EE9x14E) C1{ VBC2{ v2 v1} v1}
}
namespace ccc { 
void  ccc::EE9x14 ::pqr(){vfunc_called(this, "_ZN3ccc6EE9x143pqrEv");}
ccc::EE9x14 ::~EE9x14(){ note_dtor("_ZN3ccc6EE9x14E", this);} // tgen
ccc::EE9x14 ::EE9x14(){ note_ctor("_ZN3ccc6EE9x14E", this);} // tgen
}
static void Test__ZN3ccc6EE9x14E()
{
  extern Class_Descriptor cd__ZN3ccc6EE9x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE9x14E, buf);
    ::ccc::EE9x14 *dp, &lv = *(dp=new (buf) ::ccc::EE9x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE9x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE9x14E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc6EE9x14E");
    test_class_info(&lv, &cd__ZN3ccc6EE9x14E);
    dp->::ccc::EE9x14::~EE9x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE9x14E(Test__ZN3ccc6EE9x14E, "_ZN3ccc6EE9x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE9x14C1Ev();
extern void _ZN3ccc6EE9x14D1Ev();
Name_Map name_map__ZN3ccc6EE9x14E[] = {
  NSPAIR(_ZN3ccc6EE9x14C1Ev),
  NSPAIR(_ZN3ccc6EE9x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc6EE9x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE9x14E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc6EE9x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE9x14E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE9x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE9x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE9x14E[];
static  VTT_ENTRY vtt__ZN3ccc6EE9x14E[] = {
  {&(_ZTVN3ccc6EE9x14E[5]),  5,7},
  {&(_ZTVN3ccc6EE9x14E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE9x14E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE9x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE9x14E[];
Class_Descriptor cd__ZN3ccc6EE9x14E = {  "_ZN3ccc6EE9x14E", // class name
  bases__ZN3ccc6EE9x14E, 1,
  &(vtc__ZN3ccc6EE9x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE9x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE9x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE9x14E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE9x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE9x15  : virtual ::ccc::AA9 {
  ~EE9x15(); // tgen
  EE9x15(); // tgen
};
//SIG(-1 _ZN3ccc6EE9x15E) C1{ VBC2{ v1 v2}}
}
namespace ccc { 
ccc::EE9x15 ::~EE9x15(){ note_dtor("_ZN3ccc6EE9x15E", this);} // tgen
ccc::EE9x15 ::EE9x15(){ note_ctor("_ZN3ccc6EE9x15E", this);} // tgen
}
static void Test__ZN3ccc6EE9x15E()
{
  extern Class_Descriptor cd__ZN3ccc6EE9x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE9x15E, buf);
    ::ccc::EE9x15 *dp, &lv = *(dp=new (buf) ::ccc::EE9x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE9x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE9x15E)");
    check_base_class_offset(lv, (::ccc::AA9*), 0, "_ZN3ccc6EE9x15E");
    test_class_info(&lv, &cd__ZN3ccc6EE9x15E);
    dp->::ccc::EE9x15::~EE9x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE9x15E(Test__ZN3ccc6EE9x15E, "_ZN3ccc6EE9x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE9x15C1Ev();
extern void _ZN3ccc6EE9x15D1Ev();
Name_Map name_map__ZN3ccc6EE9x15E[] = {
  NSPAIR(_ZN3ccc6EE9x15C1Ev),
  NSPAIR(_ZN3ccc6EE9x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA9E;
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
static Base_Class bases__ZN3ccc6EE9x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE9x15E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc3AA93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE9x15E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE9x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE9x15E[];
static  VTT_ENTRY vtt__ZN3ccc6EE9x15E[] = {
  {&(_ZTVN3ccc6EE9x15E[5]),  5,7},
  {&(_ZTVN3ccc6EE9x15E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE9x15E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE9x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE9x15E[];
Class_Descriptor cd__ZN3ccc6EE9x15E = {  "_ZN3ccc6EE9x15E", // class name
  bases__ZN3ccc6EE9x15E, 1,
  &(vtc__ZN3ccc6EE9x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE9x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE9x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE9x15E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE9x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA10  {
  virtual void  pqr(); // _ZN3ccc4AA103pqrEv
  virtual void  abc(); // _ZN3ccc4AA103abcEv
  ~AA10(); // tgen
  AA10(); // tgen
};
//SIG(-1 _ZN3ccc4AA10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA10 ::pqr(){vfunc_called(this, "_ZN3ccc4AA103pqrEv");}
void  ccc::AA10 ::abc(){vfunc_called(this, "_ZN3ccc4AA103abcEv");}
ccc::AA10 ::~AA10(){ note_dtor("_ZN3ccc4AA10E", this);} // tgen
ccc::AA10 ::AA10(){ note_ctor("_ZN3ccc4AA10E", this);} // tgen
}
static void Test__ZN3ccc4AA10E()
{
  extern Class_Descriptor cd__ZN3ccc4AA10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA10E, buf);
    ::ccc::AA10 *dp, &lv = *(dp=new (buf) ::ccc::AA10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA10E)");
    test_class_info(&lv, &cd__ZN3ccc4AA10E);
    dp->::ccc::AA10::~AA10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA10E(Test__ZN3ccc4AA10E, "_ZN3ccc4AA10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA10C1Ev();
extern void _ZN3ccc4AA10D1Ev();
Name_Map name_map__ZN3ccc4AA10E[] = {
  NSPAIR(_ZN3ccc4AA10C1Ev),
  NSPAIR(_ZN3ccc4AA10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
Class_Descriptor cd__ZN3ccc4AA10E = {  "_ZN3ccc4AA10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB10  {
  virtual void  pqr(); // _ZN3ccc4BB103pqrEv
  virtual void  abc(); // _ZN3ccc4BB103abcEv
  ~BB10(); // tgen
  BB10(); // tgen
};
//SIG(1 _ZN3ccc4BB10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB10 ::pqr(){vfunc_called(this, "_ZN3ccc4BB103pqrEv");}
void  ccc::BB10 ::abc(){vfunc_called(this, "_ZN3ccc4BB103abcEv");}
ccc::BB10 ::~BB10(){ note_dtor("_ZN3ccc4BB10E", this);} // tgen
ccc::BB10 ::BB10(){ note_ctor("_ZN3ccc4BB10E", this);} // tgen
}
static void Test__ZN3ccc4BB10E()
{
  extern Class_Descriptor cd__ZN3ccc4BB10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB10E, buf);
    ::ccc::BB10 *dp, &lv = *(dp=new (buf) ::ccc::BB10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB10E)");
    test_class_info(&lv, &cd__ZN3ccc4BB10E);
    dp->::ccc::BB10::~BB10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB10E(Test__ZN3ccc4BB10E, "_ZN3ccc4BB10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB10C1Ev();
extern void _ZN3ccc4BB10D1Ev();
Name_Map name_map__ZN3ccc4BB10E[] = {
  NSPAIR(_ZN3ccc4BB10C1Ev),
  NSPAIR(_ZN3ccc4BB10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
Class_Descriptor cd__ZN3ccc4BB10E = {  "_ZN3ccc4BB10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x0  : virtual ::ccc::AA10 {
  virtual void  abc(); // _ZN3ccc6EE10x03abcEv
  virtual void  efg(); // _ZN3ccc6EE10x03efgEv
  virtual void  pqr(); // _ZN3ccc6EE10x03pqrEv
  ~EE10x0(); // tgen
  EE10x0(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x0E) C1{ VBC2{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE10x0 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x03abcEv");}
void  ccc::EE10x0 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x03efgEv");}
void  ccc::EE10x0 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x03pqrEv");}
ccc::EE10x0 ::~EE10x0(){ note_dtor("_ZN3ccc6EE10x0E", this);} // tgen
ccc::EE10x0 ::EE10x0(){ note_ctor("_ZN3ccc6EE10x0E", this);} // tgen
}
static void Test__ZN3ccc6EE10x0E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x0E, buf);
    ::ccc::EE10x0 *dp, &lv = *(dp=new (buf) ::ccc::EE10x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x0E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x0E);
    dp->::ccc::EE10x0::~EE10x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x0E(Test__ZN3ccc6EE10x0E, "_ZN3ccc6EE10x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x0C1Ev();
extern void _ZN3ccc6EE10x0D1Ev();
Name_Map name_map__ZN3ccc6EE10x0E[] = {
  NSPAIR(_ZN3ccc6EE10x0C1Ev),
  NSPAIR(_ZN3ccc6EE10x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x0E[];
extern void _ZN3ccc6EE10x03pqrEv();
extern void _ZN3ccc6EE10x03abcEv();
extern void _ZN3ccc6EE10x03efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x0E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x03efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x0E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x0E[] = {
  {&(_ZTVN3ccc6EE10x0E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x0E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x0E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x0E[];
Class_Descriptor cd__ZN3ccc6EE10x0E = {  "_ZN3ccc6EE10x0E", // class name
  bases__ZN3ccc6EE10x0E, 1,
  &(vtc__ZN3ccc6EE10x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x0E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x1  : virtual ::ccc::AA10 {
  virtual void  abc(); // _ZN3ccc6EE10x13abcEv
  virtual void  pqr(); // _ZN3ccc6EE10x13pqrEv
  virtual void  efg(); // _ZN3ccc6EE10x13efgEv
  ~EE10x1(); // tgen
  EE10x1(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x1E) C1{ VBC2{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE10x1 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x13abcEv");}
void  ccc::EE10x1 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x13pqrEv");}
void  ccc::EE10x1 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x13efgEv");}
ccc::EE10x1 ::~EE10x1(){ note_dtor("_ZN3ccc6EE10x1E", this);} // tgen
ccc::EE10x1 ::EE10x1(){ note_ctor("_ZN3ccc6EE10x1E", this);} // tgen
}
static void Test__ZN3ccc6EE10x1E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x1E, buf);
    ::ccc::EE10x1 *dp, &lv = *(dp=new (buf) ::ccc::EE10x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x1E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x1E);
    dp->::ccc::EE10x1::~EE10x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x1E(Test__ZN3ccc6EE10x1E, "_ZN3ccc6EE10x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x1C1Ev();
extern void _ZN3ccc6EE10x1D1Ev();
Name_Map name_map__ZN3ccc6EE10x1E[] = {
  NSPAIR(_ZN3ccc6EE10x1C1Ev),
  NSPAIR(_ZN3ccc6EE10x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x1E[];
extern void _ZN3ccc6EE10x13pqrEv();
extern void _ZN3ccc6EE10x13abcEv();
extern void _ZN3ccc6EE10x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x1E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x1E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x1E[] = {
  {&(_ZTVN3ccc6EE10x1E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x1E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x1E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x1E[];
Class_Descriptor cd__ZN3ccc6EE10x1E = {  "_ZN3ccc6EE10x1E", // class name
  bases__ZN3ccc6EE10x1E, 1,
  &(vtc__ZN3ccc6EE10x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x1E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x2  : virtual ::ccc::AA10 {
  virtual void  efg(); // _ZN3ccc6EE10x23efgEv
  virtual void  abc(); // _ZN3ccc6EE10x23abcEv
  virtual void  pqr(); // _ZN3ccc6EE10x23pqrEv
  ~EE10x2(); // tgen
  EE10x2(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x2E) C1{ VBC2{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE10x2 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x23efgEv");}
void  ccc::EE10x2 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x23abcEv");}
void  ccc::EE10x2 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x23pqrEv");}
ccc::EE10x2 ::~EE10x2(){ note_dtor("_ZN3ccc6EE10x2E", this);} // tgen
ccc::EE10x2 ::EE10x2(){ note_ctor("_ZN3ccc6EE10x2E", this);} // tgen
}
static void Test__ZN3ccc6EE10x2E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x2E, buf);
    ::ccc::EE10x2 *dp, &lv = *(dp=new (buf) ::ccc::EE10x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x2E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x2E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x2E);
    dp->::ccc::EE10x2::~EE10x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x2E(Test__ZN3ccc6EE10x2E, "_ZN3ccc6EE10x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x2C1Ev();
extern void _ZN3ccc6EE10x2D1Ev();
Name_Map name_map__ZN3ccc6EE10x2E[] = {
  NSPAIR(_ZN3ccc6EE10x2C1Ev),
  NSPAIR(_ZN3ccc6EE10x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x2E[];
extern void _ZN3ccc6EE10x23pqrEv();
extern void _ZN3ccc6EE10x23abcEv();
extern void _ZN3ccc6EE10x23efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x2E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x23efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x2E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x2E[] = {
  {&(_ZTVN3ccc6EE10x2E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x2E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x2E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x2E[];
Class_Descriptor cd__ZN3ccc6EE10x2E = {  "_ZN3ccc6EE10x2E", // class name
  bases__ZN3ccc6EE10x2E, 1,
  &(vtc__ZN3ccc6EE10x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x2E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x3  : virtual ::ccc::AA10 {
  virtual void  efg(); // _ZN3ccc6EE10x33efgEv
  virtual void  pqr(); // _ZN3ccc6EE10x33pqrEv
  virtual void  abc(); // _ZN3ccc6EE10x33abcEv
  ~EE10x3(); // tgen
  EE10x3(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x3E) C1{ VBC2{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE10x3 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x33efgEv");}
void  ccc::EE10x3 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x33pqrEv");}
void  ccc::EE10x3 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x33abcEv");}
ccc::EE10x3 ::~EE10x3(){ note_dtor("_ZN3ccc6EE10x3E", this);} // tgen
ccc::EE10x3 ::EE10x3(){ note_ctor("_ZN3ccc6EE10x3E", this);} // tgen
}
static void Test__ZN3ccc6EE10x3E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x3E, buf);
    ::ccc::EE10x3 *dp, &lv = *(dp=new (buf) ::ccc::EE10x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x3E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x3E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x3E);
    dp->::ccc::EE10x3::~EE10x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x3E(Test__ZN3ccc6EE10x3E, "_ZN3ccc6EE10x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x3C1Ev();
extern void _ZN3ccc6EE10x3D1Ev();
Name_Map name_map__ZN3ccc6EE10x3E[] = {
  NSPAIR(_ZN3ccc6EE10x3C1Ev),
  NSPAIR(_ZN3ccc6EE10x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x3E[];
extern void _ZN3ccc6EE10x33pqrEv();
extern void _ZN3ccc6EE10x33abcEv();
extern void _ZN3ccc6EE10x33efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x3E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x33efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x3E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x3E[] = {
  {&(_ZTVN3ccc6EE10x3E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x3E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x3E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x3E[];
Class_Descriptor cd__ZN3ccc6EE10x3E = {  "_ZN3ccc6EE10x3E", // class name
  bases__ZN3ccc6EE10x3E, 1,
  &(vtc__ZN3ccc6EE10x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x3E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x4  : virtual ::ccc::AA10 {
  virtual void  pqr(); // _ZN3ccc6EE10x43pqrEv
  virtual void  abc(); // _ZN3ccc6EE10x43abcEv
  virtual void  efg(); // _ZN3ccc6EE10x43efgEv
  ~EE10x4(); // tgen
  EE10x4(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x4E) C1{ VBC2{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE10x4 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x43pqrEv");}
void  ccc::EE10x4 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x43abcEv");}
void  ccc::EE10x4 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x43efgEv");}
ccc::EE10x4 ::~EE10x4(){ note_dtor("_ZN3ccc6EE10x4E", this);} // tgen
ccc::EE10x4 ::EE10x4(){ note_ctor("_ZN3ccc6EE10x4E", this);} // tgen
}
static void Test__ZN3ccc6EE10x4E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x4E, buf);
    ::ccc::EE10x4 *dp, &lv = *(dp=new (buf) ::ccc::EE10x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x4E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x4E);
    dp->::ccc::EE10x4::~EE10x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x4E(Test__ZN3ccc6EE10x4E, "_ZN3ccc6EE10x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x4C1Ev();
extern void _ZN3ccc6EE10x4D1Ev();
Name_Map name_map__ZN3ccc6EE10x4E[] = {
  NSPAIR(_ZN3ccc6EE10x4C1Ev),
  NSPAIR(_ZN3ccc6EE10x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x4E[];
extern void _ZN3ccc6EE10x43pqrEv();
extern void _ZN3ccc6EE10x43abcEv();
extern void _ZN3ccc6EE10x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x4E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x4E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x4E[] = {
  {&(_ZTVN3ccc6EE10x4E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x4E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x4E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x4E[];
Class_Descriptor cd__ZN3ccc6EE10x4E = {  "_ZN3ccc6EE10x4E", // class name
  bases__ZN3ccc6EE10x4E, 1,
  &(vtc__ZN3ccc6EE10x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x4E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x5  : virtual ::ccc::AA10 {
  virtual void  pqr(); // _ZN3ccc6EE10x53pqrEv
  virtual void  efg(); // _ZN3ccc6EE10x53efgEv
  virtual void  abc(); // _ZN3ccc6EE10x53abcEv
  ~EE10x5(); // tgen
  EE10x5(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x5E) C1{ VBC2{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE10x5 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x53pqrEv");}
void  ccc::EE10x5 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x53efgEv");}
void  ccc::EE10x5 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x53abcEv");}
ccc::EE10x5 ::~EE10x5(){ note_dtor("_ZN3ccc6EE10x5E", this);} // tgen
ccc::EE10x5 ::EE10x5(){ note_ctor("_ZN3ccc6EE10x5E", this);} // tgen
}
static void Test__ZN3ccc6EE10x5E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x5E, buf);
    ::ccc::EE10x5 *dp, &lv = *(dp=new (buf) ::ccc::EE10x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x5E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x5E);
    dp->::ccc::EE10x5::~EE10x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x5E(Test__ZN3ccc6EE10x5E, "_ZN3ccc6EE10x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x5C1Ev();
extern void _ZN3ccc6EE10x5D1Ev();
Name_Map name_map__ZN3ccc6EE10x5E[] = {
  NSPAIR(_ZN3ccc6EE10x5C1Ev),
  NSPAIR(_ZN3ccc6EE10x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x5E[];
extern void _ZN3ccc6EE10x53pqrEv();
extern void _ZN3ccc6EE10x53abcEv();
extern void _ZN3ccc6EE10x53efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x5E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x53efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x5E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x5E[] = {
  {&(_ZTVN3ccc6EE10x5E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x5E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x5E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x5E[];
Class_Descriptor cd__ZN3ccc6EE10x5E = {  "_ZN3ccc6EE10x5E", // class name
  bases__ZN3ccc6EE10x5E, 1,
  &(vtc__ZN3ccc6EE10x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x5E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x6  : virtual ::ccc::AA10 {
  virtual void  abc(); // _ZN3ccc6EE10x63abcEv
  virtual void  efg(); // _ZN3ccc6EE10x63efgEv
  ~EE10x6(); // tgen
  EE10x6(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x6E) C1{ VBC2{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE10x6 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x63abcEv");}
void  ccc::EE10x6 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x63efgEv");}
ccc::EE10x6 ::~EE10x6(){ note_dtor("_ZN3ccc6EE10x6E", this);} // tgen
ccc::EE10x6 ::EE10x6(){ note_ctor("_ZN3ccc6EE10x6E", this);} // tgen
}
static void Test__ZN3ccc6EE10x6E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x6E, buf);
    ::ccc::EE10x6 *dp, &lv = *(dp=new (buf) ::ccc::EE10x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x6E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x6E);
    dp->::ccc::EE10x6::~EE10x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x6E(Test__ZN3ccc6EE10x6E, "_ZN3ccc6EE10x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x6C1Ev();
extern void _ZN3ccc6EE10x6D1Ev();
Name_Map name_map__ZN3ccc6EE10x6E[] = {
  NSPAIR(_ZN3ccc6EE10x6C1Ev),
  NSPAIR(_ZN3ccc6EE10x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc6EE10x63abcEv();
extern void _ZN3ccc6EE10x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x6E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x6E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x6E[] = {
  {&(_ZTVN3ccc6EE10x6E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x6E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x6E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x6E[];
Class_Descriptor cd__ZN3ccc6EE10x6E = {  "_ZN3ccc6EE10x6E", // class name
  bases__ZN3ccc6EE10x6E, 1,
  &(vtc__ZN3ccc6EE10x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x6E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x7  : virtual ::ccc::AA10 {
  virtual void  abc(); // _ZN3ccc6EE10x73abcEv
  virtual void  pqr(); // _ZN3ccc6EE10x73pqrEv
  ~EE10x7(); // tgen
  EE10x7(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x7E) C1{ VBC2{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE10x7 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x73abcEv");}
void  ccc::EE10x7 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x73pqrEv");}
ccc::EE10x7 ::~EE10x7(){ note_dtor("_ZN3ccc6EE10x7E", this);} // tgen
ccc::EE10x7 ::EE10x7(){ note_ctor("_ZN3ccc6EE10x7E", this);} // tgen
}
static void Test__ZN3ccc6EE10x7E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x7E, buf);
    ::ccc::EE10x7 *dp, &lv = *(dp=new (buf) ::ccc::EE10x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x7E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x7E);
    dp->::ccc::EE10x7::~EE10x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x7E(Test__ZN3ccc6EE10x7E, "_ZN3ccc6EE10x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x7C1Ev();
extern void _ZN3ccc6EE10x7D1Ev();
Name_Map name_map__ZN3ccc6EE10x7E[] = {
  NSPAIR(_ZN3ccc6EE10x7C1Ev),
  NSPAIR(_ZN3ccc6EE10x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x7E[];
extern void _ZN3ccc6EE10x73pqrEv();
extern void _ZN3ccc6EE10x73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x7E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x7E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x7E[] = {
  {&(_ZTVN3ccc6EE10x7E[5]),  5,7},
  {&(_ZTVN3ccc6EE10x7E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x7E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x7E[];
Class_Descriptor cd__ZN3ccc6EE10x7E = {  "_ZN3ccc6EE10x7E", // class name
  bases__ZN3ccc6EE10x7E, 1,
  &(vtc__ZN3ccc6EE10x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x7E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x8  : virtual ::ccc::AA10 {
  virtual void  efg(); // _ZN3ccc6EE10x83efgEv
  virtual void  abc(); // _ZN3ccc6EE10x83abcEv
  ~EE10x8(); // tgen
  EE10x8(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x8E) C1{ VBC2{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE10x8 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x83efgEv");}
void  ccc::EE10x8 ::abc(){vfunc_called(this, "_ZN3ccc6EE10x83abcEv");}
ccc::EE10x8 ::~EE10x8(){ note_dtor("_ZN3ccc6EE10x8E", this);} // tgen
ccc::EE10x8 ::EE10x8(){ note_ctor("_ZN3ccc6EE10x8E", this);} // tgen
}
static void Test__ZN3ccc6EE10x8E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x8E, buf);
    ::ccc::EE10x8 *dp, &lv = *(dp=new (buf) ::ccc::EE10x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x8E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x8E);
    dp->::ccc::EE10x8::~EE10x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x8E(Test__ZN3ccc6EE10x8E, "_ZN3ccc6EE10x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x8C1Ev();
extern void _ZN3ccc6EE10x8D1Ev();
Name_Map name_map__ZN3ccc6EE10x8E[] = {
  NSPAIR(_ZN3ccc6EE10x8C1Ev),
  NSPAIR(_ZN3ccc6EE10x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc6EE10x83abcEv();
extern void _ZN3ccc6EE10x83efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x8E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x83efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x8E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x8E[] = {
  {&(_ZTVN3ccc6EE10x8E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x8E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x8E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x8E[];
Class_Descriptor cd__ZN3ccc6EE10x8E = {  "_ZN3ccc6EE10x8E", // class name
  bases__ZN3ccc6EE10x8E, 1,
  &(vtc__ZN3ccc6EE10x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x8E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x9  : virtual ::ccc::AA10 {
  virtual void  efg(); // _ZN3ccc6EE10x93efgEv
  virtual void  pqr(); // _ZN3ccc6EE10x93pqrEv
  ~EE10x9(); // tgen
  EE10x9(); // tgen
};
//SIG(-1 _ZN3ccc6EE10x9E) C1{ VBC2{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE10x9 ::efg(){vfunc_called(this, "_ZN3ccc6EE10x93efgEv");}
void  ccc::EE10x9 ::pqr(){vfunc_called(this, "_ZN3ccc6EE10x93pqrEv");}
ccc::EE10x9 ::~EE10x9(){ note_dtor("_ZN3ccc6EE10x9E", this);} // tgen
ccc::EE10x9 ::EE10x9(){ note_ctor("_ZN3ccc6EE10x9E", this);} // tgen
}
static void Test__ZN3ccc6EE10x9E()
{
  extern Class_Descriptor cd__ZN3ccc6EE10x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE10x9E, buf);
    ::ccc::EE10x9 *dp, &lv = *(dp=new (buf) ::ccc::EE10x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE10x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE10x9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc6EE10x9E");
    test_class_info(&lv, &cd__ZN3ccc6EE10x9E);
    dp->::ccc::EE10x9::~EE10x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE10x9E(Test__ZN3ccc6EE10x9E, "_ZN3ccc6EE10x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE10x9C1Ev();
extern void _ZN3ccc6EE10x9D1Ev();
Name_Map name_map__ZN3ccc6EE10x9E[] = {
  NSPAIR(_ZN3ccc6EE10x9C1Ev),
  NSPAIR(_ZN3ccc6EE10x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc6EE10x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE10x9E[];
extern void _ZN3ccc6EE10x93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc6EE10x93efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE10x9E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE10x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE10x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE10x93efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE10x9E[];
static  VTT_ENTRY vtt__ZN3ccc6EE10x9E[] = {
  {&(_ZTVN3ccc6EE10x9E[5]),  5,8},
  {&(_ZTVN3ccc6EE10x9E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE10x9E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE10x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE10x9E[];
Class_Descriptor cd__ZN3ccc6EE10x9E = {  "_ZN3ccc6EE10x9E", // class name
  bases__ZN3ccc6EE10x9E, 1,
  &(vtc__ZN3ccc6EE10x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE10x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE10x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE10x9E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE10x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x10  : virtual ::ccc::AA10 {
  virtual void  pqr(); // _ZN3ccc7EE10x103pqrEv
  virtual void  abc(); // _ZN3ccc7EE10x103abcEv
  ~EE10x10(); // tgen
  EE10x10(); // tgen
};
//SIG(-1 _ZN3ccc7EE10x10E) C1{ VBC2{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE10x10 ::pqr(){vfunc_called(this, "_ZN3ccc7EE10x103pqrEv");}
void  ccc::EE10x10 ::abc(){vfunc_called(this, "_ZN3ccc7EE10x103abcEv");}
ccc::EE10x10 ::~EE10x10(){ note_dtor("_ZN3ccc7EE10x10E", this);} // tgen
ccc::EE10x10 ::EE10x10(){ note_ctor("_ZN3ccc7EE10x10E", this);} // tgen
}
static void Test__ZN3ccc7EE10x10E()
{
  extern Class_Descriptor cd__ZN3ccc7EE10x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE10x10E, buf);
    ::ccc::EE10x10 *dp, &lv = *(dp=new (buf) ::ccc::EE10x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE10x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE10x10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc7EE10x10E");
    test_class_info(&lv, &cd__ZN3ccc7EE10x10E);
    dp->::ccc::EE10x10::~EE10x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE10x10E(Test__ZN3ccc7EE10x10E, "_ZN3ccc7EE10x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE10x10C1Ev();
extern void _ZN3ccc7EE10x10D1Ev();
Name_Map name_map__ZN3ccc7EE10x10E[] = {
  NSPAIR(_ZN3ccc7EE10x10C1Ev),
  NSPAIR(_ZN3ccc7EE10x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc7EE10x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE10x10E[];
extern void _ZN3ccc7EE10x103pqrEv();
extern void _ZN3ccc7EE10x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE10x10E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE10x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE10x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE10x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE10x10E[];
static  VTT_ENTRY vtt__ZN3ccc7EE10x10E[] = {
  {&(_ZTVN3ccc7EE10x10E[5]),  5,7},
  {&(_ZTVN3ccc7EE10x10E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE10x10E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE10x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE10x10E[];
Class_Descriptor cd__ZN3ccc7EE10x10E = {  "_ZN3ccc7EE10x10E", // class name
  bases__ZN3ccc7EE10x10E, 1,
  &(vtc__ZN3ccc7EE10x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE10x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE10x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE10x10E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE10x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x11  : virtual ::ccc::AA10 {
  virtual void  pqr(); // _ZN3ccc7EE10x113pqrEv
  virtual void  efg(); // _ZN3ccc7EE10x113efgEv
  ~EE10x11(); // tgen
  EE10x11(); // tgen
};
//SIG(-1 _ZN3ccc7EE10x11E) C1{ VBC2{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE10x11 ::pqr(){vfunc_called(this, "_ZN3ccc7EE10x113pqrEv");}
void  ccc::EE10x11 ::efg(){vfunc_called(this, "_ZN3ccc7EE10x113efgEv");}
ccc::EE10x11 ::~EE10x11(){ note_dtor("_ZN3ccc7EE10x11E", this);} // tgen
ccc::EE10x11 ::EE10x11(){ note_ctor("_ZN3ccc7EE10x11E", this);} // tgen
}
static void Test__ZN3ccc7EE10x11E()
{
  extern Class_Descriptor cd__ZN3ccc7EE10x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE10x11E, buf);
    ::ccc::EE10x11 *dp, &lv = *(dp=new (buf) ::ccc::EE10x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE10x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE10x11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc7EE10x11E");
    test_class_info(&lv, &cd__ZN3ccc7EE10x11E);
    dp->::ccc::EE10x11::~EE10x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE10x11E(Test__ZN3ccc7EE10x11E, "_ZN3ccc7EE10x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE10x11C1Ev();
extern void _ZN3ccc7EE10x11D1Ev();
Name_Map name_map__ZN3ccc7EE10x11E[] = {
  NSPAIR(_ZN3ccc7EE10x11C1Ev),
  NSPAIR(_ZN3ccc7EE10x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc7EE10x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE10x11E[];
extern void _ZN3ccc7EE10x113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc7EE10x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE10x11E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE10x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE10x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc7EE10x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE10x11E[];
static  VTT_ENTRY vtt__ZN3ccc7EE10x11E[] = {
  {&(_ZTVN3ccc7EE10x11E[5]),  5,8},
  {&(_ZTVN3ccc7EE10x11E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc7EE10x11E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE10x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE10x11E[];
Class_Descriptor cd__ZN3ccc7EE10x11E = {  "_ZN3ccc7EE10x11E", // class name
  bases__ZN3ccc7EE10x11E, 1,
  &(vtc__ZN3ccc7EE10x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE10x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE10x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE10x11E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE10x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x12  : virtual ::ccc::AA10 {
  virtual void  abc(); // _ZN3ccc7EE10x123abcEv
  ~EE10x12(); // tgen
  EE10x12(); // tgen
};
//SIG(-1 _ZN3ccc7EE10x12E) C1{ VBC2{ v2 v1} v1}
}
namespace ccc { 
void  ccc::EE10x12 ::abc(){vfunc_called(this, "_ZN3ccc7EE10x123abcEv");}
ccc::EE10x12 ::~EE10x12(){ note_dtor("_ZN3ccc7EE10x12E", this);} // tgen
ccc::EE10x12 ::EE10x12(){ note_ctor("_ZN3ccc7EE10x12E", this);} // tgen
}
static void Test__ZN3ccc7EE10x12E()
{
  extern Class_Descriptor cd__ZN3ccc7EE10x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE10x12E, buf);
    ::ccc::EE10x12 *dp, &lv = *(dp=new (buf) ::ccc::EE10x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE10x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE10x12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc7EE10x12E");
    test_class_info(&lv, &cd__ZN3ccc7EE10x12E);
    dp->::ccc::EE10x12::~EE10x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE10x12E(Test__ZN3ccc7EE10x12E, "_ZN3ccc7EE10x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE10x12C1Ev();
extern void _ZN3ccc7EE10x12D1Ev();
Name_Map name_map__ZN3ccc7EE10x12E[] = {
  NSPAIR(_ZN3ccc7EE10x12C1Ev),
  NSPAIR(_ZN3ccc7EE10x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc7EE10x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE10x12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc7EE10x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE10x12E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE10x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE10x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE10x12E[];
static  VTT_ENTRY vtt__ZN3ccc7EE10x12E[] = {
  {&(_ZTVN3ccc7EE10x12E[5]),  5,7},
  {&(_ZTVN3ccc7EE10x12E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE10x12E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE10x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE10x12E[];
Class_Descriptor cd__ZN3ccc7EE10x12E = {  "_ZN3ccc7EE10x12E", // class name
  bases__ZN3ccc7EE10x12E, 1,
  &(vtc__ZN3ccc7EE10x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE10x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE10x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE10x12E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE10x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x13  : virtual ::ccc::AA10 {
  virtual void  efg(); // _ZN3ccc7EE10x133efgEv
  ~EE10x13(); // tgen
  EE10x13(); // tgen
};
//SIG(-1 _ZN3ccc7EE10x13E) C1{ VBC2{ v2 v3} v1}
}
namespace ccc { 
void  ccc::EE10x13 ::efg(){vfunc_called(this, "_ZN3ccc7EE10x133efgEv");}
ccc::EE10x13 ::~EE10x13(){ note_dtor("_ZN3ccc7EE10x13E", this);} // tgen
ccc::EE10x13 ::EE10x13(){ note_ctor("_ZN3ccc7EE10x13E", this);} // tgen
}
static void Test__ZN3ccc7EE10x13E()
{
  extern Class_Descriptor cd__ZN3ccc7EE10x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE10x13E, buf);
    ::ccc::EE10x13 *dp, &lv = *(dp=new (buf) ::ccc::EE10x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE10x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE10x13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc7EE10x13E");
    test_class_info(&lv, &cd__ZN3ccc7EE10x13E);
    dp->::ccc::EE10x13::~EE10x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE10x13E(Test__ZN3ccc7EE10x13E, "_ZN3ccc7EE10x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE10x13C1Ev();
extern void _ZN3ccc7EE10x13D1Ev();
Name_Map name_map__ZN3ccc7EE10x13E[] = {
  NSPAIR(_ZN3ccc7EE10x13C1Ev),
  NSPAIR(_ZN3ccc7EE10x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc7EE10x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE10x13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc7EE10x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE10x13E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE10x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc7EE10x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE10x13E[];
static  VTT_ENTRY vtt__ZN3ccc7EE10x13E[] = {
  {&(_ZTVN3ccc7EE10x13E[5]),  5,8},
  {&(_ZTVN3ccc7EE10x13E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc7EE10x13E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE10x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE10x13E[];
Class_Descriptor cd__ZN3ccc7EE10x13E = {  "_ZN3ccc7EE10x13E", // class name
  bases__ZN3ccc7EE10x13E, 1,
  &(vtc__ZN3ccc7EE10x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE10x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE10x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE10x13E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE10x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x14  : virtual ::ccc::AA10 {
  virtual void  pqr(); // _ZN3ccc7EE10x143pqrEv
  ~EE10x14(); // tgen
  EE10x14(); // tgen
};
//SIG(-1 _ZN3ccc7EE10x14E) C1{ VBC2{ v1 v2} v1}
}
namespace ccc { 
void  ccc::EE10x14 ::pqr(){vfunc_called(this, "_ZN3ccc7EE10x143pqrEv");}
ccc::EE10x14 ::~EE10x14(){ note_dtor("_ZN3ccc7EE10x14E", this);} // tgen
ccc::EE10x14 ::EE10x14(){ note_ctor("_ZN3ccc7EE10x14E", this);} // tgen
}
static void Test__ZN3ccc7EE10x14E()
{
  extern Class_Descriptor cd__ZN3ccc7EE10x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE10x14E, buf);
    ::ccc::EE10x14 *dp, &lv = *(dp=new (buf) ::ccc::EE10x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE10x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE10x14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc7EE10x14E");
    test_class_info(&lv, &cd__ZN3ccc7EE10x14E);
    dp->::ccc::EE10x14::~EE10x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE10x14E(Test__ZN3ccc7EE10x14E, "_ZN3ccc7EE10x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE10x14C1Ev();
extern void _ZN3ccc7EE10x14D1Ev();
Name_Map name_map__ZN3ccc7EE10x14E[] = {
  NSPAIR(_ZN3ccc7EE10x14C1Ev),
  NSPAIR(_ZN3ccc7EE10x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc7EE10x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE10x14E[];
extern void _ZN3ccc7EE10x143pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE10x14E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE10x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE10x143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE10x14E[];
static  VTT_ENTRY vtt__ZN3ccc7EE10x14E[] = {
  {&(_ZTVN3ccc7EE10x14E[5]),  5,7},
  {&(_ZTVN3ccc7EE10x14E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE10x14E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE10x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE10x14E[];
Class_Descriptor cd__ZN3ccc7EE10x14E = {  "_ZN3ccc7EE10x14E", // class name
  bases__ZN3ccc7EE10x14E, 1,
  &(vtc__ZN3ccc7EE10x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE10x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE10x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE10x14E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE10x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE10x15  : virtual ::ccc::AA10 {
  ~EE10x15(); // tgen
  EE10x15(); // tgen
};
//SIG(-1 _ZN3ccc7EE10x15E) C1{ VBC2{ v1 v2}}
}
namespace ccc { 
ccc::EE10x15 ::~EE10x15(){ note_dtor("_ZN3ccc7EE10x15E", this);} // tgen
ccc::EE10x15 ::EE10x15(){ note_ctor("_ZN3ccc7EE10x15E", this);} // tgen
}
static void Test__ZN3ccc7EE10x15E()
{
  extern Class_Descriptor cd__ZN3ccc7EE10x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE10x15E, buf);
    ::ccc::EE10x15 *dp, &lv = *(dp=new (buf) ::ccc::EE10x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE10x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE10x15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc7EE10x15E");
    test_class_info(&lv, &cd__ZN3ccc7EE10x15E);
    dp->::ccc::EE10x15::~EE10x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE10x15E(Test__ZN3ccc7EE10x15E, "_ZN3ccc7EE10x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE10x15C1Ev();
extern void _ZN3ccc7EE10x15D1Ev();
Name_Map name_map__ZN3ccc7EE10x15E[] = {
  NSPAIR(_ZN3ccc7EE10x15C1Ev),
  NSPAIR(_ZN3ccc7EE10x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
static Base_Class bases__ZN3ccc7EE10x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE10x15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE10x15E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE10x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE10x15E[];
static  VTT_ENTRY vtt__ZN3ccc7EE10x15E[] = {
  {&(_ZTVN3ccc7EE10x15E[5]),  5,7},
  {&(_ZTVN3ccc7EE10x15E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE10x15E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE10x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE10x15E[];
Class_Descriptor cd__ZN3ccc7EE10x15E = {  "_ZN3ccc7EE10x15E", // class name
  bases__ZN3ccc7EE10x15E, 1,
  &(vtc__ZN3ccc7EE10x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE10x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE10x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE10x15E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE10x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA11  {
  virtual void  pqr(); // _ZN3ccc4AA113pqrEv
  virtual void  efg(); // _ZN3ccc4AA113efgEv
  ~AA11(); // tgen
  AA11(); // tgen
};
//SIG(-1 _ZN3ccc4AA11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA11 ::pqr(){vfunc_called(this, "_ZN3ccc4AA113pqrEv");}
void  ccc::AA11 ::efg(){vfunc_called(this, "_ZN3ccc4AA113efgEv");}
ccc::AA11 ::~AA11(){ note_dtor("_ZN3ccc4AA11E", this);} // tgen
ccc::AA11 ::AA11(){ note_ctor("_ZN3ccc4AA11E", this);} // tgen
}
static void Test__ZN3ccc4AA11E()
{
  extern Class_Descriptor cd__ZN3ccc4AA11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA11E, buf);
    ::ccc::AA11 *dp, &lv = *(dp=new (buf) ::ccc::AA11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA11E)");
    test_class_info(&lv, &cd__ZN3ccc4AA11E);
    dp->::ccc::AA11::~AA11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA11E(Test__ZN3ccc4AA11E, "_ZN3ccc4AA11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA11C1Ev();
extern void _ZN3ccc4AA11D1Ev();
Name_Map name_map__ZN3ccc4AA11E[] = {
  NSPAIR(_ZN3ccc4AA11C1Ev),
  NSPAIR(_ZN3ccc4AA11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc4AA113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
Class_Descriptor cd__ZN3ccc4AA11E = {  "_ZN3ccc4AA11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB11  {
  virtual void  pqr(); // _ZN3ccc4BB113pqrEv
  virtual void  efg(); // _ZN3ccc4BB113efgEv
  ~BB11(); // tgen
  BB11(); // tgen
};
//SIG(1 _ZN3ccc4BB11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB11 ::pqr(){vfunc_called(this, "_ZN3ccc4BB113pqrEv");}
void  ccc::BB11 ::efg(){vfunc_called(this, "_ZN3ccc4BB113efgEv");}
ccc::BB11 ::~BB11(){ note_dtor("_ZN3ccc4BB11E", this);} // tgen
ccc::BB11 ::BB11(){ note_ctor("_ZN3ccc4BB11E", this);} // tgen
}
static void Test__ZN3ccc4BB11E()
{
  extern Class_Descriptor cd__ZN3ccc4BB11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB11E, buf);
    ::ccc::BB11 *dp, &lv = *(dp=new (buf) ::ccc::BB11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB11E)");
    test_class_info(&lv, &cd__ZN3ccc4BB11E);
    dp->::ccc::BB11::~BB11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB11E(Test__ZN3ccc4BB11E, "_ZN3ccc4BB11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB11C1Ev();
extern void _ZN3ccc4BB11D1Ev();
Name_Map name_map__ZN3ccc4BB11E[] = {
  NSPAIR(_ZN3ccc4BB11C1Ev),
  NSPAIR(_ZN3ccc4BB11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
Class_Descriptor cd__ZN3ccc4BB11E = {  "_ZN3ccc4BB11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x0  : virtual ::ccc::AA11 {
  virtual void  abc(); // _ZN3ccc6EE11x03abcEv
  virtual void  efg(); // _ZN3ccc6EE11x03efgEv
  virtual void  pqr(); // _ZN3ccc6EE11x03pqrEv
  ~EE11x0(); // tgen
  EE11x0(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x0E) C1{ VBC2{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE11x0 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x03abcEv");}
void  ccc::EE11x0 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x03efgEv");}
void  ccc::EE11x0 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x03pqrEv");}
ccc::EE11x0 ::~EE11x0(){ note_dtor("_ZN3ccc6EE11x0E", this);} // tgen
ccc::EE11x0 ::EE11x0(){ note_ctor("_ZN3ccc6EE11x0E", this);} // tgen
}
static void Test__ZN3ccc6EE11x0E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x0E, buf);
    ::ccc::EE11x0 *dp, &lv = *(dp=new (buf) ::ccc::EE11x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x0E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x0E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x0E);
    dp->::ccc::EE11x0::~EE11x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x0E(Test__ZN3ccc6EE11x0E, "_ZN3ccc6EE11x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x0C1Ev();
extern void _ZN3ccc6EE11x0D1Ev();
Name_Map name_map__ZN3ccc6EE11x0E[] = {
  NSPAIR(_ZN3ccc6EE11x0C1Ev),
  NSPAIR(_ZN3ccc6EE11x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x0E[];
extern void _ZN3ccc6EE11x03pqrEv();
extern void _ZN3ccc6EE11x03efgEv();
extern void _ZN3ccc6EE11x03abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x0E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x03abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x0E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x0E[] = {
  {&(_ZTVN3ccc6EE11x0E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x0E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x0E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x0E[];
Class_Descriptor cd__ZN3ccc6EE11x0E = {  "_ZN3ccc6EE11x0E", // class name
  bases__ZN3ccc6EE11x0E, 1,
  &(vtc__ZN3ccc6EE11x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x0E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x1  : virtual ::ccc::AA11 {
  virtual void  abc(); // _ZN3ccc6EE11x13abcEv
  virtual void  pqr(); // _ZN3ccc6EE11x13pqrEv
  virtual void  efg(); // _ZN3ccc6EE11x13efgEv
  ~EE11x1(); // tgen
  EE11x1(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x1E) C1{ VBC2{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE11x1 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x13abcEv");}
void  ccc::EE11x1 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x13pqrEv");}
void  ccc::EE11x1 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x13efgEv");}
ccc::EE11x1 ::~EE11x1(){ note_dtor("_ZN3ccc6EE11x1E", this);} // tgen
ccc::EE11x1 ::EE11x1(){ note_ctor("_ZN3ccc6EE11x1E", this);} // tgen
}
static void Test__ZN3ccc6EE11x1E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x1E, buf);
    ::ccc::EE11x1 *dp, &lv = *(dp=new (buf) ::ccc::EE11x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x1E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x1E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x1E);
    dp->::ccc::EE11x1::~EE11x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x1E(Test__ZN3ccc6EE11x1E, "_ZN3ccc6EE11x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x1C1Ev();
extern void _ZN3ccc6EE11x1D1Ev();
Name_Map name_map__ZN3ccc6EE11x1E[] = {
  NSPAIR(_ZN3ccc6EE11x1C1Ev),
  NSPAIR(_ZN3ccc6EE11x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x1E[];
extern void _ZN3ccc6EE11x13pqrEv();
extern void _ZN3ccc6EE11x13efgEv();
extern void _ZN3ccc6EE11x13abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x1E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x13abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x1E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x1E[] = {
  {&(_ZTVN3ccc6EE11x1E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x1E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x1E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x1E[];
Class_Descriptor cd__ZN3ccc6EE11x1E = {  "_ZN3ccc6EE11x1E", // class name
  bases__ZN3ccc6EE11x1E, 1,
  &(vtc__ZN3ccc6EE11x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x1E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x2  : virtual ::ccc::AA11 {
  virtual void  efg(); // _ZN3ccc6EE11x23efgEv
  virtual void  abc(); // _ZN3ccc6EE11x23abcEv
  virtual void  pqr(); // _ZN3ccc6EE11x23pqrEv
  ~EE11x2(); // tgen
  EE11x2(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x2E) C1{ VBC2{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE11x2 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x23efgEv");}
void  ccc::EE11x2 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x23abcEv");}
void  ccc::EE11x2 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x23pqrEv");}
ccc::EE11x2 ::~EE11x2(){ note_dtor("_ZN3ccc6EE11x2E", this);} // tgen
ccc::EE11x2 ::EE11x2(){ note_ctor("_ZN3ccc6EE11x2E", this);} // tgen
}
static void Test__ZN3ccc6EE11x2E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x2E, buf);
    ::ccc::EE11x2 *dp, &lv = *(dp=new (buf) ::ccc::EE11x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x2E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x2E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x2E);
    dp->::ccc::EE11x2::~EE11x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x2E(Test__ZN3ccc6EE11x2E, "_ZN3ccc6EE11x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x2C1Ev();
extern void _ZN3ccc6EE11x2D1Ev();
Name_Map name_map__ZN3ccc6EE11x2E[] = {
  NSPAIR(_ZN3ccc6EE11x2C1Ev),
  NSPAIR(_ZN3ccc6EE11x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x2E[];
extern void _ZN3ccc6EE11x23pqrEv();
extern void _ZN3ccc6EE11x23efgEv();
extern void _ZN3ccc6EE11x23abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x2E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x23abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x2E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x2E[] = {
  {&(_ZTVN3ccc6EE11x2E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x2E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x2E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x2E[];
Class_Descriptor cd__ZN3ccc6EE11x2E = {  "_ZN3ccc6EE11x2E", // class name
  bases__ZN3ccc6EE11x2E, 1,
  &(vtc__ZN3ccc6EE11x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x2E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x3  : virtual ::ccc::AA11 {
  virtual void  efg(); // _ZN3ccc6EE11x33efgEv
  virtual void  pqr(); // _ZN3ccc6EE11x33pqrEv
  virtual void  abc(); // _ZN3ccc6EE11x33abcEv
  ~EE11x3(); // tgen
  EE11x3(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x3E) C1{ VBC2{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE11x3 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x33efgEv");}
void  ccc::EE11x3 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x33pqrEv");}
void  ccc::EE11x3 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x33abcEv");}
ccc::EE11x3 ::~EE11x3(){ note_dtor("_ZN3ccc6EE11x3E", this);} // tgen
ccc::EE11x3 ::EE11x3(){ note_ctor("_ZN3ccc6EE11x3E", this);} // tgen
}
static void Test__ZN3ccc6EE11x3E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x3E, buf);
    ::ccc::EE11x3 *dp, &lv = *(dp=new (buf) ::ccc::EE11x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x3E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x3E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x3E);
    dp->::ccc::EE11x3::~EE11x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x3E(Test__ZN3ccc6EE11x3E, "_ZN3ccc6EE11x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x3C1Ev();
extern void _ZN3ccc6EE11x3D1Ev();
Name_Map name_map__ZN3ccc6EE11x3E[] = {
  NSPAIR(_ZN3ccc6EE11x3C1Ev),
  NSPAIR(_ZN3ccc6EE11x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x3E[];
extern void _ZN3ccc6EE11x33pqrEv();
extern void _ZN3ccc6EE11x33efgEv();
extern void _ZN3ccc6EE11x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x3E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x3E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x3E[] = {
  {&(_ZTVN3ccc6EE11x3E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x3E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x3E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x3E[];
Class_Descriptor cd__ZN3ccc6EE11x3E = {  "_ZN3ccc6EE11x3E", // class name
  bases__ZN3ccc6EE11x3E, 1,
  &(vtc__ZN3ccc6EE11x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x3E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x4  : virtual ::ccc::AA11 {
  virtual void  pqr(); // _ZN3ccc6EE11x43pqrEv
  virtual void  abc(); // _ZN3ccc6EE11x43abcEv
  virtual void  efg(); // _ZN3ccc6EE11x43efgEv
  ~EE11x4(); // tgen
  EE11x4(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x4E) C1{ VBC2{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE11x4 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x43pqrEv");}
void  ccc::EE11x4 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x43abcEv");}
void  ccc::EE11x4 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x43efgEv");}
ccc::EE11x4 ::~EE11x4(){ note_dtor("_ZN3ccc6EE11x4E", this);} // tgen
ccc::EE11x4 ::EE11x4(){ note_ctor("_ZN3ccc6EE11x4E", this);} // tgen
}
static void Test__ZN3ccc6EE11x4E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x4E, buf);
    ::ccc::EE11x4 *dp, &lv = *(dp=new (buf) ::ccc::EE11x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x4E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x4E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x4E);
    dp->::ccc::EE11x4::~EE11x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x4E(Test__ZN3ccc6EE11x4E, "_ZN3ccc6EE11x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x4C1Ev();
extern void _ZN3ccc6EE11x4D1Ev();
Name_Map name_map__ZN3ccc6EE11x4E[] = {
  NSPAIR(_ZN3ccc6EE11x4C1Ev),
  NSPAIR(_ZN3ccc6EE11x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x4E[];
extern void _ZN3ccc6EE11x43pqrEv();
extern void _ZN3ccc6EE11x43efgEv();
extern void _ZN3ccc6EE11x43abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x4E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x43abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x4E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x4E[] = {
  {&(_ZTVN3ccc6EE11x4E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x4E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x4E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x4E[];
Class_Descriptor cd__ZN3ccc6EE11x4E = {  "_ZN3ccc6EE11x4E", // class name
  bases__ZN3ccc6EE11x4E, 1,
  &(vtc__ZN3ccc6EE11x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x4E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x5  : virtual ::ccc::AA11 {
  virtual void  pqr(); // _ZN3ccc6EE11x53pqrEv
  virtual void  efg(); // _ZN3ccc6EE11x53efgEv
  virtual void  abc(); // _ZN3ccc6EE11x53abcEv
  ~EE11x5(); // tgen
  EE11x5(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x5E) C1{ VBC2{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE11x5 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x53pqrEv");}
void  ccc::EE11x5 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x53efgEv");}
void  ccc::EE11x5 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x53abcEv");}
ccc::EE11x5 ::~EE11x5(){ note_dtor("_ZN3ccc6EE11x5E", this);} // tgen
ccc::EE11x5 ::EE11x5(){ note_ctor("_ZN3ccc6EE11x5E", this);} // tgen
}
static void Test__ZN3ccc6EE11x5E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x5E, buf);
    ::ccc::EE11x5 *dp, &lv = *(dp=new (buf) ::ccc::EE11x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x5E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x5E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x5E);
    dp->::ccc::EE11x5::~EE11x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x5E(Test__ZN3ccc6EE11x5E, "_ZN3ccc6EE11x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x5C1Ev();
extern void _ZN3ccc6EE11x5D1Ev();
Name_Map name_map__ZN3ccc6EE11x5E[] = {
  NSPAIR(_ZN3ccc6EE11x5C1Ev),
  NSPAIR(_ZN3ccc6EE11x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x5E[];
extern void _ZN3ccc6EE11x53pqrEv();
extern void _ZN3ccc6EE11x53efgEv();
extern void _ZN3ccc6EE11x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x5E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x5E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x5E[] = {
  {&(_ZTVN3ccc6EE11x5E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x5E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x5E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x5E[];
Class_Descriptor cd__ZN3ccc6EE11x5E = {  "_ZN3ccc6EE11x5E", // class name
  bases__ZN3ccc6EE11x5E, 1,
  &(vtc__ZN3ccc6EE11x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x5E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x6  : virtual ::ccc::AA11 {
  virtual void  abc(); // _ZN3ccc6EE11x63abcEv
  virtual void  efg(); // _ZN3ccc6EE11x63efgEv
  ~EE11x6(); // tgen
  EE11x6(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x6E) C1{ VBC2{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE11x6 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x63abcEv");}
void  ccc::EE11x6 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x63efgEv");}
ccc::EE11x6 ::~EE11x6(){ note_dtor("_ZN3ccc6EE11x6E", this);} // tgen
ccc::EE11x6 ::EE11x6(){ note_ctor("_ZN3ccc6EE11x6E", this);} // tgen
}
static void Test__ZN3ccc6EE11x6E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x6E, buf);
    ::ccc::EE11x6 *dp, &lv = *(dp=new (buf) ::ccc::EE11x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x6E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x6E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x6E);
    dp->::ccc::EE11x6::~EE11x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x6E(Test__ZN3ccc6EE11x6E, "_ZN3ccc6EE11x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x6C1Ev();
extern void _ZN3ccc6EE11x6D1Ev();
Name_Map name_map__ZN3ccc6EE11x6E[] = {
  NSPAIR(_ZN3ccc6EE11x6C1Ev),
  NSPAIR(_ZN3ccc6EE11x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x6E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc6EE11x63efgEv();
extern void _ZN3ccc6EE11x63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x6E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x6E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x6E[] = {
  {&(_ZTVN3ccc6EE11x6E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x6E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x6E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x6E[];
Class_Descriptor cd__ZN3ccc6EE11x6E = {  "_ZN3ccc6EE11x6E", // class name
  bases__ZN3ccc6EE11x6E, 1,
  &(vtc__ZN3ccc6EE11x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x6E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x7  : virtual ::ccc::AA11 {
  virtual void  abc(); // _ZN3ccc6EE11x73abcEv
  virtual void  pqr(); // _ZN3ccc6EE11x73pqrEv
  ~EE11x7(); // tgen
  EE11x7(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x7E) C1{ VBC2{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE11x7 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x73abcEv");}
void  ccc::EE11x7 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x73pqrEv");}
ccc::EE11x7 ::~EE11x7(){ note_dtor("_ZN3ccc6EE11x7E", this);} // tgen
ccc::EE11x7 ::EE11x7(){ note_ctor("_ZN3ccc6EE11x7E", this);} // tgen
}
static void Test__ZN3ccc6EE11x7E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x7E, buf);
    ::ccc::EE11x7 *dp, &lv = *(dp=new (buf) ::ccc::EE11x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x7E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x7E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x7E);
    dp->::ccc::EE11x7::~EE11x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x7E(Test__ZN3ccc6EE11x7E, "_ZN3ccc6EE11x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x7C1Ev();
extern void _ZN3ccc6EE11x7D1Ev();
Name_Map name_map__ZN3ccc6EE11x7E[] = {
  NSPAIR(_ZN3ccc6EE11x7C1Ev),
  NSPAIR(_ZN3ccc6EE11x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x7E[];
extern void _ZN3ccc6EE11x73pqrEv();
extern void _ZN3ccc4AA113efgEv();
extern void _ZN3ccc6EE11x73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x7E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x7E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x7E[] = {
  {&(_ZTVN3ccc6EE11x7E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x7E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x7E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x7E[];
Class_Descriptor cd__ZN3ccc6EE11x7E = {  "_ZN3ccc6EE11x7E", // class name
  bases__ZN3ccc6EE11x7E, 1,
  &(vtc__ZN3ccc6EE11x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x7E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x8  : virtual ::ccc::AA11 {
  virtual void  efg(); // _ZN3ccc6EE11x83efgEv
  virtual void  abc(); // _ZN3ccc6EE11x83abcEv
  ~EE11x8(); // tgen
  EE11x8(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x8E) C1{ VBC2{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE11x8 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x83efgEv");}
void  ccc::EE11x8 ::abc(){vfunc_called(this, "_ZN3ccc6EE11x83abcEv");}
ccc::EE11x8 ::~EE11x8(){ note_dtor("_ZN3ccc6EE11x8E", this);} // tgen
ccc::EE11x8 ::EE11x8(){ note_ctor("_ZN3ccc6EE11x8E", this);} // tgen
}
static void Test__ZN3ccc6EE11x8E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x8E, buf);
    ::ccc::EE11x8 *dp, &lv = *(dp=new (buf) ::ccc::EE11x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x8E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x8E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x8E);
    dp->::ccc::EE11x8::~EE11x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x8E(Test__ZN3ccc6EE11x8E, "_ZN3ccc6EE11x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x8C1Ev();
extern void _ZN3ccc6EE11x8D1Ev();
Name_Map name_map__ZN3ccc6EE11x8E[] = {
  NSPAIR(_ZN3ccc6EE11x8C1Ev),
  NSPAIR(_ZN3ccc6EE11x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x8E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc6EE11x83efgEv();
extern void _ZN3ccc6EE11x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x8E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x8E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x8E[] = {
  {&(_ZTVN3ccc6EE11x8E[5]),  5,8},
  {&(_ZTVN3ccc6EE11x8E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x8E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x8E[];
Class_Descriptor cd__ZN3ccc6EE11x8E = {  "_ZN3ccc6EE11x8E", // class name
  bases__ZN3ccc6EE11x8E, 1,
  &(vtc__ZN3ccc6EE11x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x8E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x9  : virtual ::ccc::AA11 {
  virtual void  efg(); // _ZN3ccc6EE11x93efgEv
  virtual void  pqr(); // _ZN3ccc6EE11x93pqrEv
  ~EE11x9(); // tgen
  EE11x9(); // tgen
};
//SIG(-1 _ZN3ccc6EE11x9E) C1{ VBC2{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::EE11x9 ::efg(){vfunc_called(this, "_ZN3ccc6EE11x93efgEv");}
void  ccc::EE11x9 ::pqr(){vfunc_called(this, "_ZN3ccc6EE11x93pqrEv");}
ccc::EE11x9 ::~EE11x9(){ note_dtor("_ZN3ccc6EE11x9E", this);} // tgen
ccc::EE11x9 ::EE11x9(){ note_ctor("_ZN3ccc6EE11x9E", this);} // tgen
}
static void Test__ZN3ccc6EE11x9E()
{
  extern Class_Descriptor cd__ZN3ccc6EE11x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE11x9E, buf);
    ::ccc::EE11x9 *dp, &lv = *(dp=new (buf) ::ccc::EE11x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE11x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE11x9E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc6EE11x9E");
    test_class_info(&lv, &cd__ZN3ccc6EE11x9E);
    dp->::ccc::EE11x9::~EE11x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE11x9E(Test__ZN3ccc6EE11x9E, "_ZN3ccc6EE11x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE11x9C1Ev();
extern void _ZN3ccc6EE11x9D1Ev();
Name_Map name_map__ZN3ccc6EE11x9E[] = {
  NSPAIR(_ZN3ccc6EE11x9C1Ev),
  NSPAIR(_ZN3ccc6EE11x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc6EE11x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE11x9E[];
extern void _ZN3ccc6EE11x93pqrEv();
extern void _ZN3ccc6EE11x93efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE11x9E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE11x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE11x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE11x93efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE11x9E[];
static  VTT_ENTRY vtt__ZN3ccc6EE11x9E[] = {
  {&(_ZTVN3ccc6EE11x9E[5]),  5,7},
  {&(_ZTVN3ccc6EE11x9E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE11x9E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE11x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE11x9E[];
Class_Descriptor cd__ZN3ccc6EE11x9E = {  "_ZN3ccc6EE11x9E", // class name
  bases__ZN3ccc6EE11x9E, 1,
  &(vtc__ZN3ccc6EE11x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE11x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE11x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE11x9E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE11x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x10  : virtual ::ccc::AA11 {
  virtual void  pqr(); // _ZN3ccc7EE11x103pqrEv
  virtual void  abc(); // _ZN3ccc7EE11x103abcEv
  ~EE11x10(); // tgen
  EE11x10(); // tgen
};
//SIG(-1 _ZN3ccc7EE11x10E) C1{ VBC2{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::EE11x10 ::pqr(){vfunc_called(this, "_ZN3ccc7EE11x103pqrEv");}
void  ccc::EE11x10 ::abc(){vfunc_called(this, "_ZN3ccc7EE11x103abcEv");}
ccc::EE11x10 ::~EE11x10(){ note_dtor("_ZN3ccc7EE11x10E", this);} // tgen
ccc::EE11x10 ::EE11x10(){ note_ctor("_ZN3ccc7EE11x10E", this);} // tgen
}
static void Test__ZN3ccc7EE11x10E()
{
  extern Class_Descriptor cd__ZN3ccc7EE11x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE11x10E, buf);
    ::ccc::EE11x10 *dp, &lv = *(dp=new (buf) ::ccc::EE11x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE11x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE11x10E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc7EE11x10E");
    test_class_info(&lv, &cd__ZN3ccc7EE11x10E);
    dp->::ccc::EE11x10::~EE11x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE11x10E(Test__ZN3ccc7EE11x10E, "_ZN3ccc7EE11x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE11x10C1Ev();
extern void _ZN3ccc7EE11x10D1Ev();
Name_Map name_map__ZN3ccc7EE11x10E[] = {
  NSPAIR(_ZN3ccc7EE11x10C1Ev),
  NSPAIR(_ZN3ccc7EE11x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc7EE11x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE11x10E[];
extern void _ZN3ccc7EE11x103pqrEv();
extern void _ZN3ccc4AA113efgEv();
extern void _ZN3ccc7EE11x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE11x10E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE11x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE11x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
  (VTBL_ENTRY)&_ZN3ccc7EE11x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE11x10E[];
static  VTT_ENTRY vtt__ZN3ccc7EE11x10E[] = {
  {&(_ZTVN3ccc7EE11x10E[5]),  5,8},
  {&(_ZTVN3ccc7EE11x10E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc7EE11x10E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE11x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE11x10E[];
Class_Descriptor cd__ZN3ccc7EE11x10E = {  "_ZN3ccc7EE11x10E", // class name
  bases__ZN3ccc7EE11x10E, 1,
  &(vtc__ZN3ccc7EE11x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE11x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE11x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE11x10E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE11x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x11  : virtual ::ccc::AA11 {
  virtual void  pqr(); // _ZN3ccc7EE11x113pqrEv
  virtual void  efg(); // _ZN3ccc7EE11x113efgEv
  ~EE11x11(); // tgen
  EE11x11(); // tgen
};
//SIG(-1 _ZN3ccc7EE11x11E) C1{ VBC2{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::EE11x11 ::pqr(){vfunc_called(this, "_ZN3ccc7EE11x113pqrEv");}
void  ccc::EE11x11 ::efg(){vfunc_called(this, "_ZN3ccc7EE11x113efgEv");}
ccc::EE11x11 ::~EE11x11(){ note_dtor("_ZN3ccc7EE11x11E", this);} // tgen
ccc::EE11x11 ::EE11x11(){ note_ctor("_ZN3ccc7EE11x11E", this);} // tgen
}
static void Test__ZN3ccc7EE11x11E()
{
  extern Class_Descriptor cd__ZN3ccc7EE11x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE11x11E, buf);
    ::ccc::EE11x11 *dp, &lv = *(dp=new (buf) ::ccc::EE11x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE11x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE11x11E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc7EE11x11E");
    test_class_info(&lv, &cd__ZN3ccc7EE11x11E);
    dp->::ccc::EE11x11::~EE11x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE11x11E(Test__ZN3ccc7EE11x11E, "_ZN3ccc7EE11x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE11x11C1Ev();
extern void _ZN3ccc7EE11x11D1Ev();
Name_Map name_map__ZN3ccc7EE11x11E[] = {
  NSPAIR(_ZN3ccc7EE11x11C1Ev),
  NSPAIR(_ZN3ccc7EE11x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc7EE11x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE11x11E[];
extern void _ZN3ccc7EE11x113pqrEv();
extern void _ZN3ccc7EE11x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE11x11E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE11x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE11x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE11x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE11x11E[];
static  VTT_ENTRY vtt__ZN3ccc7EE11x11E[] = {
  {&(_ZTVN3ccc7EE11x11E[5]),  5,7},
  {&(_ZTVN3ccc7EE11x11E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE11x11E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE11x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE11x11E[];
Class_Descriptor cd__ZN3ccc7EE11x11E = {  "_ZN3ccc7EE11x11E", // class name
  bases__ZN3ccc7EE11x11E, 1,
  &(vtc__ZN3ccc7EE11x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE11x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE11x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE11x11E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE11x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x12  : virtual ::ccc::AA11 {
  virtual void  abc(); // _ZN3ccc7EE11x123abcEv
  ~EE11x12(); // tgen
  EE11x12(); // tgen
};
//SIG(-1 _ZN3ccc7EE11x12E) C1{ VBC2{ v2 v3} v1}
}
namespace ccc { 
void  ccc::EE11x12 ::abc(){vfunc_called(this, "_ZN3ccc7EE11x123abcEv");}
ccc::EE11x12 ::~EE11x12(){ note_dtor("_ZN3ccc7EE11x12E", this);} // tgen
ccc::EE11x12 ::EE11x12(){ note_ctor("_ZN3ccc7EE11x12E", this);} // tgen
}
static void Test__ZN3ccc7EE11x12E()
{
  extern Class_Descriptor cd__ZN3ccc7EE11x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE11x12E, buf);
    ::ccc::EE11x12 *dp, &lv = *(dp=new (buf) ::ccc::EE11x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE11x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE11x12E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc7EE11x12E");
    test_class_info(&lv, &cd__ZN3ccc7EE11x12E);
    dp->::ccc::EE11x12::~EE11x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE11x12E(Test__ZN3ccc7EE11x12E, "_ZN3ccc7EE11x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE11x12C1Ev();
extern void _ZN3ccc7EE11x12D1Ev();
Name_Map name_map__ZN3ccc7EE11x12E[] = {
  NSPAIR(_ZN3ccc7EE11x12C1Ev),
  NSPAIR(_ZN3ccc7EE11x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc7EE11x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE11x12E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc4AA113efgEv();
extern void _ZN3ccc7EE11x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE11x12E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE11x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
  (VTBL_ENTRY)&_ZN3ccc7EE11x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE11x12E[];
static  VTT_ENTRY vtt__ZN3ccc7EE11x12E[] = {
  {&(_ZTVN3ccc7EE11x12E[5]),  5,8},
  {&(_ZTVN3ccc7EE11x12E[5]),  5,8},
};
extern VTBL_ENTRY _ZTIN3ccc7EE11x12E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE11x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE11x12E[];
Class_Descriptor cd__ZN3ccc7EE11x12E = {  "_ZN3ccc7EE11x12E", // class name
  bases__ZN3ccc7EE11x12E, 1,
  &(vtc__ZN3ccc7EE11x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE11x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE11x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE11x12E),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE11x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x13  : virtual ::ccc::AA11 {
  virtual void  efg(); // _ZN3ccc7EE11x133efgEv
  ~EE11x13(); // tgen
  EE11x13(); // tgen
};
//SIG(-1 _ZN3ccc7EE11x13E) C1{ VBC2{ v2 v1} v1}
}
namespace ccc { 
void  ccc::EE11x13 ::efg(){vfunc_called(this, "_ZN3ccc7EE11x133efgEv");}
ccc::EE11x13 ::~EE11x13(){ note_dtor("_ZN3ccc7EE11x13E", this);} // tgen
ccc::EE11x13 ::EE11x13(){ note_ctor("_ZN3ccc7EE11x13E", this);} // tgen
}
static void Test__ZN3ccc7EE11x13E()
{
  extern Class_Descriptor cd__ZN3ccc7EE11x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE11x13E, buf);
    ::ccc::EE11x13 *dp, &lv = *(dp=new (buf) ::ccc::EE11x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE11x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE11x13E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc7EE11x13E");
    test_class_info(&lv, &cd__ZN3ccc7EE11x13E);
    dp->::ccc::EE11x13::~EE11x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE11x13E(Test__ZN3ccc7EE11x13E, "_ZN3ccc7EE11x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE11x13C1Ev();
extern void _ZN3ccc7EE11x13D1Ev();
Name_Map name_map__ZN3ccc7EE11x13E[] = {
  NSPAIR(_ZN3ccc7EE11x13C1Ev),
  NSPAIR(_ZN3ccc7EE11x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc7EE11x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE11x13E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc7EE11x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE11x13E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE11x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE11x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE11x13E[];
static  VTT_ENTRY vtt__ZN3ccc7EE11x13E[] = {
  {&(_ZTVN3ccc7EE11x13E[5]),  5,7},
  {&(_ZTVN3ccc7EE11x13E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE11x13E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE11x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE11x13E[];
Class_Descriptor cd__ZN3ccc7EE11x13E = {  "_ZN3ccc7EE11x13E", // class name
  bases__ZN3ccc7EE11x13E, 1,
  &(vtc__ZN3ccc7EE11x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE11x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE11x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE11x13E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE11x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x14  : virtual ::ccc::AA11 {
  virtual void  pqr(); // _ZN3ccc7EE11x143pqrEv
  ~EE11x14(); // tgen
  EE11x14(); // tgen
};
//SIG(-1 _ZN3ccc7EE11x14E) C1{ VBC2{ v1 v2} v1}
}
namespace ccc { 
void  ccc::EE11x14 ::pqr(){vfunc_called(this, "_ZN3ccc7EE11x143pqrEv");}
ccc::EE11x14 ::~EE11x14(){ note_dtor("_ZN3ccc7EE11x14E", this);} // tgen
ccc::EE11x14 ::EE11x14(){ note_ctor("_ZN3ccc7EE11x14E", this);} // tgen
}
static void Test__ZN3ccc7EE11x14E()
{
  extern Class_Descriptor cd__ZN3ccc7EE11x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE11x14E, buf);
    ::ccc::EE11x14 *dp, &lv = *(dp=new (buf) ::ccc::EE11x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE11x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE11x14E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc7EE11x14E");
    test_class_info(&lv, &cd__ZN3ccc7EE11x14E);
    dp->::ccc::EE11x14::~EE11x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE11x14E(Test__ZN3ccc7EE11x14E, "_ZN3ccc7EE11x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE11x14C1Ev();
extern void _ZN3ccc7EE11x14D1Ev();
Name_Map name_map__ZN3ccc7EE11x14E[] = {
  NSPAIR(_ZN3ccc7EE11x14C1Ev),
  NSPAIR(_ZN3ccc7EE11x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc7EE11x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE11x14E[];
extern void _ZN3ccc7EE11x143pqrEv();
extern void _ZN3ccc4AA113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE11x14E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE11x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE11x143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE11x14E[];
static  VTT_ENTRY vtt__ZN3ccc7EE11x14E[] = {
  {&(_ZTVN3ccc7EE11x14E[5]),  5,7},
  {&(_ZTVN3ccc7EE11x14E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE11x14E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE11x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE11x14E[];
Class_Descriptor cd__ZN3ccc7EE11x14E = {  "_ZN3ccc7EE11x14E", // class name
  bases__ZN3ccc7EE11x14E, 1,
  &(vtc__ZN3ccc7EE11x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE11x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE11x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE11x14E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE11x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE11x15  : virtual ::ccc::AA11 {
  ~EE11x15(); // tgen
  EE11x15(); // tgen
};
//SIG(-1 _ZN3ccc7EE11x15E) C1{ VBC2{ v1 v2}}
}
namespace ccc { 
ccc::EE11x15 ::~EE11x15(){ note_dtor("_ZN3ccc7EE11x15E", this);} // tgen
ccc::EE11x15 ::EE11x15(){ note_ctor("_ZN3ccc7EE11x15E", this);} // tgen
}
static void Test__ZN3ccc7EE11x15E()
{
  extern Class_Descriptor cd__ZN3ccc7EE11x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE11x15E, buf);
    ::ccc::EE11x15 *dp, &lv = *(dp=new (buf) ::ccc::EE11x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE11x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE11x15E)");
    check_base_class_offset(lv, (::ccc::AA11*), 0, "_ZN3ccc7EE11x15E");
    test_class_info(&lv, &cd__ZN3ccc7EE11x15E);
    dp->::ccc::EE11x15::~EE11x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE11x15E(Test__ZN3ccc7EE11x15E, "_ZN3ccc7EE11x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE11x15C1Ev();
extern void _ZN3ccc7EE11x15D1Ev();
Name_Map name_map__ZN3ccc7EE11x15E[] = {
  NSPAIR(_ZN3ccc7EE11x15C1Ev),
  NSPAIR(_ZN3ccc7EE11x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA11E;
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
static Base_Class bases__ZN3ccc7EE11x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE11x15E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc4AA113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE11x15E[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE11x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE11x15E[];
static  VTT_ENTRY vtt__ZN3ccc7EE11x15E[] = {
  {&(_ZTVN3ccc7EE11x15E[5]),  5,7},
  {&(_ZTVN3ccc7EE11x15E[5]),  5,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE11x15E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE11x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE11x15E[];
Class_Descriptor cd__ZN3ccc7EE11x15E = {  "_ZN3ccc7EE11x15E", // class name
  bases__ZN3ccc7EE11x15E, 1,
  &(vtc__ZN3ccc7EE11x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE11x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE11x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE11x15E),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE11x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA12  {
  virtual void  abc(); // _ZN3ccc4AA123abcEv
  ~AA12(); // tgen
  AA12(); // tgen
};
//SIG(-1 _ZN3ccc4AA12E) C1{ v1}
}
namespace ccc { 
void  ccc::AA12 ::abc(){vfunc_called(this, "_ZN3ccc4AA123abcEv");}
ccc::AA12 ::~AA12(){ note_dtor("_ZN3ccc4AA12E", this);} // tgen
ccc::AA12 ::AA12(){ note_ctor("_ZN3ccc4AA12E", this);} // tgen
}
static void Test__ZN3ccc4AA12E()
{
  extern Class_Descriptor cd__ZN3ccc4AA12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA12E, buf);
    ::ccc::AA12 *dp, &lv = *(dp=new (buf) ::ccc::AA12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA12E)");
    test_class_info(&lv, &cd__ZN3ccc4AA12E);
    dp->::ccc::AA12::~AA12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA12E(Test__ZN3ccc4AA12E, "_ZN3ccc4AA12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA12C1Ev();
extern void _ZN3ccc4AA12D1Ev();
Name_Map name_map__ZN3ccc4AA12E[] = {
  NSPAIR(_ZN3ccc4AA12C1Ev),
  NSPAIR(_ZN3ccc4AA12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern void _ZN3ccc4AA123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
Class_Descriptor cd__ZN3ccc4AA12E = {  "_ZN3ccc4AA12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB12  {
  virtual void  abc(); // _ZN3ccc4BB123abcEv
  ~BB12(); // tgen
  BB12(); // tgen
};
//SIG(1 _ZN3ccc4BB12E) C1{ v1}
}
namespace ccc { 
void  ccc::BB12 ::abc(){vfunc_called(this, "_ZN3ccc4BB123abcEv");}
ccc::BB12 ::~BB12(){ note_dtor("_ZN3ccc4BB12E", this);} // tgen
ccc::BB12 ::BB12(){ note_ctor("_ZN3ccc4BB12E", this);} // tgen
}
static void Test__ZN3ccc4BB12E()
{
  extern Class_Descriptor cd__ZN3ccc4BB12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB12E, buf);
    ::ccc::BB12 *dp, &lv = *(dp=new (buf) ::ccc::BB12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB12E)");
    test_class_info(&lv, &cd__ZN3ccc4BB12E);
    dp->::ccc::BB12::~BB12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB12E(Test__ZN3ccc4BB12E, "_ZN3ccc4BB12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB12C1Ev();
extern void _ZN3ccc4BB12D1Ev();
Name_Map name_map__ZN3ccc4BB12E[] = {
  NSPAIR(_ZN3ccc4BB12C1Ev),
  NSPAIR(_ZN3ccc4BB12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
Class_Descriptor cd__ZN3ccc4BB12E = {  "_ZN3ccc4BB12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x0  : virtual ::ccc::AA12 {
  virtual void  abc(); // _ZN3ccc6EE12x03abcEv
  virtual void  efg(); // _ZN3ccc6EE12x03efgEv
  virtual void  pqr(); // _ZN3ccc6EE12x03pqrEv
  ~EE12x0(); // tgen
  EE12x0(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x0E) C1{ VBC2{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE12x0 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x03abcEv");}
void  ccc::EE12x0 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x03efgEv");}
void  ccc::EE12x0 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x03pqrEv");}
ccc::EE12x0 ::~EE12x0(){ note_dtor("_ZN3ccc6EE12x0E", this);} // tgen
ccc::EE12x0 ::EE12x0(){ note_ctor("_ZN3ccc6EE12x0E", this);} // tgen
}
static void Test__ZN3ccc6EE12x0E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x0E, buf);
    ::ccc::EE12x0 *dp, &lv = *(dp=new (buf) ::ccc::EE12x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x0E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x0E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x0E);
    dp->::ccc::EE12x0::~EE12x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x0E(Test__ZN3ccc6EE12x0E, "_ZN3ccc6EE12x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x0C1Ev();
extern void _ZN3ccc6EE12x0D1Ev();
Name_Map name_map__ZN3ccc6EE12x0E[] = {
  NSPAIR(_ZN3ccc6EE12x0C1Ev),
  NSPAIR(_ZN3ccc6EE12x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x0E[];
extern void _ZN3ccc6EE12x03abcEv();
extern void _ZN3ccc6EE12x03efgEv();
extern void _ZN3ccc6EE12x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x0E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x0E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x0E[] = {
  {&(_ZTVN3ccc6EE12x0E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x0E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x0E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x0E[];
Class_Descriptor cd__ZN3ccc6EE12x0E = {  "_ZN3ccc6EE12x0E", // class name
  bases__ZN3ccc6EE12x0E, 1,
  &(vtc__ZN3ccc6EE12x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x0E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x1  : virtual ::ccc::AA12 {
  virtual void  abc(); // _ZN3ccc6EE12x13abcEv
  virtual void  pqr(); // _ZN3ccc6EE12x13pqrEv
  virtual void  efg(); // _ZN3ccc6EE12x13efgEv
  ~EE12x1(); // tgen
  EE12x1(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x1E) C1{ VBC2{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE12x1 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x13abcEv");}
void  ccc::EE12x1 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x13pqrEv");}
void  ccc::EE12x1 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x13efgEv");}
ccc::EE12x1 ::~EE12x1(){ note_dtor("_ZN3ccc6EE12x1E", this);} // tgen
ccc::EE12x1 ::EE12x1(){ note_ctor("_ZN3ccc6EE12x1E", this);} // tgen
}
static void Test__ZN3ccc6EE12x1E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x1E, buf);
    ::ccc::EE12x1 *dp, &lv = *(dp=new (buf) ::ccc::EE12x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x1E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x1E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x1E);
    dp->::ccc::EE12x1::~EE12x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x1E(Test__ZN3ccc6EE12x1E, "_ZN3ccc6EE12x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x1C1Ev();
extern void _ZN3ccc6EE12x1D1Ev();
Name_Map name_map__ZN3ccc6EE12x1E[] = {
  NSPAIR(_ZN3ccc6EE12x1C1Ev),
  NSPAIR(_ZN3ccc6EE12x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x1E[];
extern void _ZN3ccc6EE12x13abcEv();
extern void _ZN3ccc6EE12x13pqrEv();
extern void _ZN3ccc6EE12x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x1E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x1E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x1E[] = {
  {&(_ZTVN3ccc6EE12x1E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x1E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x1E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x1E[];
Class_Descriptor cd__ZN3ccc6EE12x1E = {  "_ZN3ccc6EE12x1E", // class name
  bases__ZN3ccc6EE12x1E, 1,
  &(vtc__ZN3ccc6EE12x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x1E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x2  : virtual ::ccc::AA12 {
  virtual void  efg(); // _ZN3ccc6EE12x23efgEv
  virtual void  abc(); // _ZN3ccc6EE12x23abcEv
  virtual void  pqr(); // _ZN3ccc6EE12x23pqrEv
  ~EE12x2(); // tgen
  EE12x2(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x2E) C1{ VBC2{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE12x2 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x23efgEv");}
void  ccc::EE12x2 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x23abcEv");}
void  ccc::EE12x2 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x23pqrEv");}
ccc::EE12x2 ::~EE12x2(){ note_dtor("_ZN3ccc6EE12x2E", this);} // tgen
ccc::EE12x2 ::EE12x2(){ note_ctor("_ZN3ccc6EE12x2E", this);} // tgen
}
static void Test__ZN3ccc6EE12x2E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x2E, buf);
    ::ccc::EE12x2 *dp, &lv = *(dp=new (buf) ::ccc::EE12x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x2E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x2E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x2E);
    dp->::ccc::EE12x2::~EE12x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x2E(Test__ZN3ccc6EE12x2E, "_ZN3ccc6EE12x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x2C1Ev();
extern void _ZN3ccc6EE12x2D1Ev();
Name_Map name_map__ZN3ccc6EE12x2E[] = {
  NSPAIR(_ZN3ccc6EE12x2C1Ev),
  NSPAIR(_ZN3ccc6EE12x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x2E[];
extern void _ZN3ccc6EE12x23abcEv();
extern void _ZN3ccc6EE12x23efgEv();
extern void _ZN3ccc6EE12x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x2E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x2E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x2E[] = {
  {&(_ZTVN3ccc6EE12x2E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x2E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x2E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x2E[];
Class_Descriptor cd__ZN3ccc6EE12x2E = {  "_ZN3ccc6EE12x2E", // class name
  bases__ZN3ccc6EE12x2E, 1,
  &(vtc__ZN3ccc6EE12x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x2E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x3  : virtual ::ccc::AA12 {
  virtual void  efg(); // _ZN3ccc6EE12x33efgEv
  virtual void  pqr(); // _ZN3ccc6EE12x33pqrEv
  virtual void  abc(); // _ZN3ccc6EE12x33abcEv
  ~EE12x3(); // tgen
  EE12x3(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x3E) C1{ VBC2{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE12x3 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x33efgEv");}
void  ccc::EE12x3 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x33pqrEv");}
void  ccc::EE12x3 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x33abcEv");}
ccc::EE12x3 ::~EE12x3(){ note_dtor("_ZN3ccc6EE12x3E", this);} // tgen
ccc::EE12x3 ::EE12x3(){ note_ctor("_ZN3ccc6EE12x3E", this);} // tgen
}
static void Test__ZN3ccc6EE12x3E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x3E, buf);
    ::ccc::EE12x3 *dp, &lv = *(dp=new (buf) ::ccc::EE12x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x3E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x3E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x3E);
    dp->::ccc::EE12x3::~EE12x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x3E(Test__ZN3ccc6EE12x3E, "_ZN3ccc6EE12x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x3C1Ev();
extern void _ZN3ccc6EE12x3D1Ev();
Name_Map name_map__ZN3ccc6EE12x3E[] = {
  NSPAIR(_ZN3ccc6EE12x3C1Ev),
  NSPAIR(_ZN3ccc6EE12x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x3E[];
extern void _ZN3ccc6EE12x33abcEv();
extern void _ZN3ccc6EE12x33efgEv();
extern void _ZN3ccc6EE12x33pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x3E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x33abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x33pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x3E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x3E[] = {
  {&(_ZTVN3ccc6EE12x3E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x3E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x3E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x3E[];
Class_Descriptor cd__ZN3ccc6EE12x3E = {  "_ZN3ccc6EE12x3E", // class name
  bases__ZN3ccc6EE12x3E, 1,
  &(vtc__ZN3ccc6EE12x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x3E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x4  : virtual ::ccc::AA12 {
  virtual void  pqr(); // _ZN3ccc6EE12x43pqrEv
  virtual void  abc(); // _ZN3ccc6EE12x43abcEv
  virtual void  efg(); // _ZN3ccc6EE12x43efgEv
  ~EE12x4(); // tgen
  EE12x4(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x4E) C1{ VBC2{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE12x4 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x43pqrEv");}
void  ccc::EE12x4 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x43abcEv");}
void  ccc::EE12x4 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x43efgEv");}
ccc::EE12x4 ::~EE12x4(){ note_dtor("_ZN3ccc6EE12x4E", this);} // tgen
ccc::EE12x4 ::EE12x4(){ note_ctor("_ZN3ccc6EE12x4E", this);} // tgen
}
static void Test__ZN3ccc6EE12x4E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x4E, buf);
    ::ccc::EE12x4 *dp, &lv = *(dp=new (buf) ::ccc::EE12x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x4E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x4E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x4E);
    dp->::ccc::EE12x4::~EE12x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x4E(Test__ZN3ccc6EE12x4E, "_ZN3ccc6EE12x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x4C1Ev();
extern void _ZN3ccc6EE12x4D1Ev();
Name_Map name_map__ZN3ccc6EE12x4E[] = {
  NSPAIR(_ZN3ccc6EE12x4C1Ev),
  NSPAIR(_ZN3ccc6EE12x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x4E[];
extern void _ZN3ccc6EE12x43abcEv();
extern void _ZN3ccc6EE12x43pqrEv();
extern void _ZN3ccc6EE12x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x4E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x4E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x4E[] = {
  {&(_ZTVN3ccc6EE12x4E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x4E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x4E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x4E[];
Class_Descriptor cd__ZN3ccc6EE12x4E = {  "_ZN3ccc6EE12x4E", // class name
  bases__ZN3ccc6EE12x4E, 1,
  &(vtc__ZN3ccc6EE12x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x4E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x5  : virtual ::ccc::AA12 {
  virtual void  pqr(); // _ZN3ccc6EE12x53pqrEv
  virtual void  efg(); // _ZN3ccc6EE12x53efgEv
  virtual void  abc(); // _ZN3ccc6EE12x53abcEv
  ~EE12x5(); // tgen
  EE12x5(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x5E) C1{ VBC2{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE12x5 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x53pqrEv");}
void  ccc::EE12x5 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x53efgEv");}
void  ccc::EE12x5 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x53abcEv");}
ccc::EE12x5 ::~EE12x5(){ note_dtor("_ZN3ccc6EE12x5E", this);} // tgen
ccc::EE12x5 ::EE12x5(){ note_ctor("_ZN3ccc6EE12x5E", this);} // tgen
}
static void Test__ZN3ccc6EE12x5E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x5E, buf);
    ::ccc::EE12x5 *dp, &lv = *(dp=new (buf) ::ccc::EE12x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x5E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x5E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x5E);
    dp->::ccc::EE12x5::~EE12x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x5E(Test__ZN3ccc6EE12x5E, "_ZN3ccc6EE12x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x5C1Ev();
extern void _ZN3ccc6EE12x5D1Ev();
Name_Map name_map__ZN3ccc6EE12x5E[] = {
  NSPAIR(_ZN3ccc6EE12x5C1Ev),
  NSPAIR(_ZN3ccc6EE12x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x5E[];
extern void _ZN3ccc6EE12x53abcEv();
extern void _ZN3ccc6EE12x53pqrEv();
extern void _ZN3ccc6EE12x53efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x5E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x53abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x53efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x5E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x5E[] = {
  {&(_ZTVN3ccc6EE12x5E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x5E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x5E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x5E[];
Class_Descriptor cd__ZN3ccc6EE12x5E = {  "_ZN3ccc6EE12x5E", // class name
  bases__ZN3ccc6EE12x5E, 1,
  &(vtc__ZN3ccc6EE12x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x5E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x6  : virtual ::ccc::AA12 {
  virtual void  abc(); // _ZN3ccc6EE12x63abcEv
  virtual void  efg(); // _ZN3ccc6EE12x63efgEv
  ~EE12x6(); // tgen
  EE12x6(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x6E) C1{ VBC2{ v1} v1 v2}
}
namespace ccc { 
void  ccc::EE12x6 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x63abcEv");}
void  ccc::EE12x6 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x63efgEv");}
ccc::EE12x6 ::~EE12x6(){ note_dtor("_ZN3ccc6EE12x6E", this);} // tgen
ccc::EE12x6 ::EE12x6(){ note_ctor("_ZN3ccc6EE12x6E", this);} // tgen
}
static void Test__ZN3ccc6EE12x6E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x6E, buf);
    ::ccc::EE12x6 *dp, &lv = *(dp=new (buf) ::ccc::EE12x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x6E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x6E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x6E);
    dp->::ccc::EE12x6::~EE12x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x6E(Test__ZN3ccc6EE12x6E, "_ZN3ccc6EE12x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x6C1Ev();
extern void _ZN3ccc6EE12x6D1Ev();
Name_Map name_map__ZN3ccc6EE12x6E[] = {
  NSPAIR(_ZN3ccc6EE12x6C1Ev),
  NSPAIR(_ZN3ccc6EE12x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x6E[];
extern void _ZN3ccc6EE12x63abcEv();
extern void _ZN3ccc6EE12x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x6E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x6E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x6E[] = {
  {&(_ZTVN3ccc6EE12x6E[4]),  4,6},
  {&(_ZTVN3ccc6EE12x6E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x6E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x6E[];
Class_Descriptor cd__ZN3ccc6EE12x6E = {  "_ZN3ccc6EE12x6E", // class name
  bases__ZN3ccc6EE12x6E, 1,
  &(vtc__ZN3ccc6EE12x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x6E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x7  : virtual ::ccc::AA12 {
  virtual void  abc(); // _ZN3ccc6EE12x73abcEv
  virtual void  pqr(); // _ZN3ccc6EE12x73pqrEv
  ~EE12x7(); // tgen
  EE12x7(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x7E) C1{ VBC2{ v1} v1 v2}
}
namespace ccc { 
void  ccc::EE12x7 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x73abcEv");}
void  ccc::EE12x7 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x73pqrEv");}
ccc::EE12x7 ::~EE12x7(){ note_dtor("_ZN3ccc6EE12x7E", this);} // tgen
ccc::EE12x7 ::EE12x7(){ note_ctor("_ZN3ccc6EE12x7E", this);} // tgen
}
static void Test__ZN3ccc6EE12x7E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x7E, buf);
    ::ccc::EE12x7 *dp, &lv = *(dp=new (buf) ::ccc::EE12x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x7E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x7E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x7E);
    dp->::ccc::EE12x7::~EE12x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x7E(Test__ZN3ccc6EE12x7E, "_ZN3ccc6EE12x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x7C1Ev();
extern void _ZN3ccc6EE12x7D1Ev();
Name_Map name_map__ZN3ccc6EE12x7E[] = {
  NSPAIR(_ZN3ccc6EE12x7C1Ev),
  NSPAIR(_ZN3ccc6EE12x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x7E[];
extern void _ZN3ccc6EE12x73abcEv();
extern void _ZN3ccc6EE12x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x7E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x7E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x7E[] = {
  {&(_ZTVN3ccc6EE12x7E[4]),  4,6},
  {&(_ZTVN3ccc6EE12x7E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x7E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x7E[];
Class_Descriptor cd__ZN3ccc6EE12x7E = {  "_ZN3ccc6EE12x7E", // class name
  bases__ZN3ccc6EE12x7E, 1,
  &(vtc__ZN3ccc6EE12x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x7E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x8  : virtual ::ccc::AA12 {
  virtual void  efg(); // _ZN3ccc6EE12x83efgEv
  virtual void  abc(); // _ZN3ccc6EE12x83abcEv
  ~EE12x8(); // tgen
  EE12x8(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x8E) C1{ VBC2{ v2} v1 v2}
}
namespace ccc { 
void  ccc::EE12x8 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x83efgEv");}
void  ccc::EE12x8 ::abc(){vfunc_called(this, "_ZN3ccc6EE12x83abcEv");}
ccc::EE12x8 ::~EE12x8(){ note_dtor("_ZN3ccc6EE12x8E", this);} // tgen
ccc::EE12x8 ::EE12x8(){ note_ctor("_ZN3ccc6EE12x8E", this);} // tgen
}
static void Test__ZN3ccc6EE12x8E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x8E, buf);
    ::ccc::EE12x8 *dp, &lv = *(dp=new (buf) ::ccc::EE12x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x8E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x8E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x8E);
    dp->::ccc::EE12x8::~EE12x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x8E(Test__ZN3ccc6EE12x8E, "_ZN3ccc6EE12x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x8C1Ev();
extern void _ZN3ccc6EE12x8D1Ev();
Name_Map name_map__ZN3ccc6EE12x8E[] = {
  NSPAIR(_ZN3ccc6EE12x8C1Ev),
  NSPAIR(_ZN3ccc6EE12x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x8E[];
extern void _ZN3ccc6EE12x83abcEv();
extern void _ZN3ccc6EE12x83efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x8E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE12x83abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x83efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x8E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x8E[] = {
  {&(_ZTVN3ccc6EE12x8E[4]),  4,6},
  {&(_ZTVN3ccc6EE12x8E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x8E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x8E[];
Class_Descriptor cd__ZN3ccc6EE12x8E = {  "_ZN3ccc6EE12x8E", // class name
  bases__ZN3ccc6EE12x8E, 1,
  &(vtc__ZN3ccc6EE12x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x8E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x9  : virtual ::ccc::AA12 {
  virtual void  efg(); // _ZN3ccc6EE12x93efgEv
  virtual void  pqr(); // _ZN3ccc6EE12x93pqrEv
  ~EE12x9(); // tgen
  EE12x9(); // tgen
};
//SIG(-1 _ZN3ccc6EE12x9E) C1{ VBC2{ v3} v1 v2}
}
namespace ccc { 
void  ccc::EE12x9 ::efg(){vfunc_called(this, "_ZN3ccc6EE12x93efgEv");}
void  ccc::EE12x9 ::pqr(){vfunc_called(this, "_ZN3ccc6EE12x93pqrEv");}
ccc::EE12x9 ::~EE12x9(){ note_dtor("_ZN3ccc6EE12x9E", this);} // tgen
ccc::EE12x9 ::EE12x9(){ note_ctor("_ZN3ccc6EE12x9E", this);} // tgen
}
static void Test__ZN3ccc6EE12x9E()
{
  extern Class_Descriptor cd__ZN3ccc6EE12x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE12x9E, buf);
    ::ccc::EE12x9 *dp, &lv = *(dp=new (buf) ::ccc::EE12x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE12x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE12x9E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc6EE12x9E");
    test_class_info(&lv, &cd__ZN3ccc6EE12x9E);
    dp->::ccc::EE12x9::~EE12x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE12x9E(Test__ZN3ccc6EE12x9E, "_ZN3ccc6EE12x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE12x9C1Ev();
extern void _ZN3ccc6EE12x9D1Ev();
Name_Map name_map__ZN3ccc6EE12x9E[] = {
  NSPAIR(_ZN3ccc6EE12x9C1Ev),
  NSPAIR(_ZN3ccc6EE12x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc6EE12x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE12x9E[];
extern void _ZN3ccc4AA123abcEv();
extern void _ZN3ccc6EE12x93efgEv();
extern void _ZN3ccc6EE12x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE12x9E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE12x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE12x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE12x9E[];
static  VTT_ENTRY vtt__ZN3ccc6EE12x9E[] = {
  {&(_ZTVN3ccc6EE12x9E[4]),  4,7},
  {&(_ZTVN3ccc6EE12x9E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE12x9E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE12x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE12x9E[];
Class_Descriptor cd__ZN3ccc6EE12x9E = {  "_ZN3ccc6EE12x9E", // class name
  bases__ZN3ccc6EE12x9E, 1,
  &(vtc__ZN3ccc6EE12x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE12x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE12x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE12x9E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE12x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x10  : virtual ::ccc::AA12 {
  virtual void  pqr(); // _ZN3ccc7EE12x103pqrEv
  virtual void  abc(); // _ZN3ccc7EE12x103abcEv
  ~EE12x10(); // tgen
  EE12x10(); // tgen
};
//SIG(-1 _ZN3ccc7EE12x10E) C1{ VBC2{ v2} v1 v2}
}
namespace ccc { 
void  ccc::EE12x10 ::pqr(){vfunc_called(this, "_ZN3ccc7EE12x103pqrEv");}
void  ccc::EE12x10 ::abc(){vfunc_called(this, "_ZN3ccc7EE12x103abcEv");}
ccc::EE12x10 ::~EE12x10(){ note_dtor("_ZN3ccc7EE12x10E", this);} // tgen
ccc::EE12x10 ::EE12x10(){ note_ctor("_ZN3ccc7EE12x10E", this);} // tgen
}
static void Test__ZN3ccc7EE12x10E()
{
  extern Class_Descriptor cd__ZN3ccc7EE12x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE12x10E, buf);
    ::ccc::EE12x10 *dp, &lv = *(dp=new (buf) ::ccc::EE12x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE12x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE12x10E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc7EE12x10E");
    test_class_info(&lv, &cd__ZN3ccc7EE12x10E);
    dp->::ccc::EE12x10::~EE12x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE12x10E(Test__ZN3ccc7EE12x10E, "_ZN3ccc7EE12x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE12x10C1Ev();
extern void _ZN3ccc7EE12x10D1Ev();
Name_Map name_map__ZN3ccc7EE12x10E[] = {
  NSPAIR(_ZN3ccc7EE12x10C1Ev),
  NSPAIR(_ZN3ccc7EE12x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc7EE12x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE12x10E[];
extern void _ZN3ccc7EE12x103abcEv();
extern void _ZN3ccc7EE12x103pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE12x10E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE12x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE12x103abcEv,
  (VTBL_ENTRY)&_ZN3ccc7EE12x103pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE12x10E[];
static  VTT_ENTRY vtt__ZN3ccc7EE12x10E[] = {
  {&(_ZTVN3ccc7EE12x10E[4]),  4,6},
  {&(_ZTVN3ccc7EE12x10E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE12x10E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE12x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE12x10E[];
Class_Descriptor cd__ZN3ccc7EE12x10E = {  "_ZN3ccc7EE12x10E", // class name
  bases__ZN3ccc7EE12x10E, 1,
  &(vtc__ZN3ccc7EE12x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE12x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE12x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE12x10E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE12x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x11  : virtual ::ccc::AA12 {
  virtual void  pqr(); // _ZN3ccc7EE12x113pqrEv
  virtual void  efg(); // _ZN3ccc7EE12x113efgEv
  ~EE12x11(); // tgen
  EE12x11(); // tgen
};
//SIG(-1 _ZN3ccc7EE12x11E) C1{ VBC2{ v3} v1 v2}
}
namespace ccc { 
void  ccc::EE12x11 ::pqr(){vfunc_called(this, "_ZN3ccc7EE12x113pqrEv");}
void  ccc::EE12x11 ::efg(){vfunc_called(this, "_ZN3ccc7EE12x113efgEv");}
ccc::EE12x11 ::~EE12x11(){ note_dtor("_ZN3ccc7EE12x11E", this);} // tgen
ccc::EE12x11 ::EE12x11(){ note_ctor("_ZN3ccc7EE12x11E", this);} // tgen
}
static void Test__ZN3ccc7EE12x11E()
{
  extern Class_Descriptor cd__ZN3ccc7EE12x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE12x11E, buf);
    ::ccc::EE12x11 *dp, &lv = *(dp=new (buf) ::ccc::EE12x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE12x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE12x11E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc7EE12x11E");
    test_class_info(&lv, &cd__ZN3ccc7EE12x11E);
    dp->::ccc::EE12x11::~EE12x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE12x11E(Test__ZN3ccc7EE12x11E, "_ZN3ccc7EE12x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE12x11C1Ev();
extern void _ZN3ccc7EE12x11D1Ev();
Name_Map name_map__ZN3ccc7EE12x11E[] = {
  NSPAIR(_ZN3ccc7EE12x11C1Ev),
  NSPAIR(_ZN3ccc7EE12x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc7EE12x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE12x11E[];
extern void _ZN3ccc4AA123abcEv();
extern void _ZN3ccc7EE12x113pqrEv();
extern void _ZN3ccc7EE12x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE12x11E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE12x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
  (VTBL_ENTRY)&_ZN3ccc7EE12x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE12x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE12x11E[];
static  VTT_ENTRY vtt__ZN3ccc7EE12x11E[] = {
  {&(_ZTVN3ccc7EE12x11E[4]),  4,7},
  {&(_ZTVN3ccc7EE12x11E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE12x11E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE12x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE12x11E[];
Class_Descriptor cd__ZN3ccc7EE12x11E = {  "_ZN3ccc7EE12x11E", // class name
  bases__ZN3ccc7EE12x11E, 1,
  &(vtc__ZN3ccc7EE12x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE12x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE12x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE12x11E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE12x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x12  : virtual ::ccc::AA12 {
  virtual void  abc(); // _ZN3ccc7EE12x123abcEv
  ~EE12x12(); // tgen
  EE12x12(); // tgen
};
//SIG(-1 _ZN3ccc7EE12x12E) C1{ VBC2{ v1} v1}
}
namespace ccc { 
void  ccc::EE12x12 ::abc(){vfunc_called(this, "_ZN3ccc7EE12x123abcEv");}
ccc::EE12x12 ::~EE12x12(){ note_dtor("_ZN3ccc7EE12x12E", this);} // tgen
ccc::EE12x12 ::EE12x12(){ note_ctor("_ZN3ccc7EE12x12E", this);} // tgen
}
static void Test__ZN3ccc7EE12x12E()
{
  extern Class_Descriptor cd__ZN3ccc7EE12x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE12x12E, buf);
    ::ccc::EE12x12 *dp, &lv = *(dp=new (buf) ::ccc::EE12x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE12x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE12x12E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc7EE12x12E");
    test_class_info(&lv, &cd__ZN3ccc7EE12x12E);
    dp->::ccc::EE12x12::~EE12x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE12x12E(Test__ZN3ccc7EE12x12E, "_ZN3ccc7EE12x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE12x12C1Ev();
extern void _ZN3ccc7EE12x12D1Ev();
Name_Map name_map__ZN3ccc7EE12x12E[] = {
  NSPAIR(_ZN3ccc7EE12x12C1Ev),
  NSPAIR(_ZN3ccc7EE12x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc7EE12x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE12x12E[];
extern void _ZN3ccc7EE12x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE12x12E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE12x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE12x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE12x12E[];
static  VTT_ENTRY vtt__ZN3ccc7EE12x12E[] = {
  {&(_ZTVN3ccc7EE12x12E[4]),  4,5},
  {&(_ZTVN3ccc7EE12x12E[4]),  4,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE12x12E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE12x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE12x12E[];
Class_Descriptor cd__ZN3ccc7EE12x12E = {  "_ZN3ccc7EE12x12E", // class name
  bases__ZN3ccc7EE12x12E, 1,
  &(vtc__ZN3ccc7EE12x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE12x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE12x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE12x12E),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE12x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x13  : virtual ::ccc::AA12 {
  virtual void  efg(); // _ZN3ccc7EE12x133efgEv
  ~EE12x13(); // tgen
  EE12x13(); // tgen
};
//SIG(-1 _ZN3ccc7EE12x13E) C1{ VBC2{ v2} v1}
}
namespace ccc { 
void  ccc::EE12x13 ::efg(){vfunc_called(this, "_ZN3ccc7EE12x133efgEv");}
ccc::EE12x13 ::~EE12x13(){ note_dtor("_ZN3ccc7EE12x13E", this);} // tgen
ccc::EE12x13 ::EE12x13(){ note_ctor("_ZN3ccc7EE12x13E", this);} // tgen
}
static void Test__ZN3ccc7EE12x13E()
{
  extern Class_Descriptor cd__ZN3ccc7EE12x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE12x13E, buf);
    ::ccc::EE12x13 *dp, &lv = *(dp=new (buf) ::ccc::EE12x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE12x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE12x13E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc7EE12x13E");
    test_class_info(&lv, &cd__ZN3ccc7EE12x13E);
    dp->::ccc::EE12x13::~EE12x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE12x13E(Test__ZN3ccc7EE12x13E, "_ZN3ccc7EE12x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE12x13C1Ev();
extern void _ZN3ccc7EE12x13D1Ev();
Name_Map name_map__ZN3ccc7EE12x13E[] = {
  NSPAIR(_ZN3ccc7EE12x13C1Ev),
  NSPAIR(_ZN3ccc7EE12x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc7EE12x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE12x13E[];
extern void _ZN3ccc4AA123abcEv();
extern void _ZN3ccc7EE12x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE12x13E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE12x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
  (VTBL_ENTRY)&_ZN3ccc7EE12x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE12x13E[];
static  VTT_ENTRY vtt__ZN3ccc7EE12x13E[] = {
  {&(_ZTVN3ccc7EE12x13E[4]),  4,6},
  {&(_ZTVN3ccc7EE12x13E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE12x13E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE12x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE12x13E[];
Class_Descriptor cd__ZN3ccc7EE12x13E = {  "_ZN3ccc7EE12x13E", // class name
  bases__ZN3ccc7EE12x13E, 1,
  &(vtc__ZN3ccc7EE12x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE12x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE12x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE12x13E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE12x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x14  : virtual ::ccc::AA12 {
  virtual void  pqr(); // _ZN3ccc7EE12x143pqrEv
  ~EE12x14(); // tgen
  EE12x14(); // tgen
};
//SIG(-1 _ZN3ccc7EE12x14E) C1{ VBC2{ v2} v1}
}
namespace ccc { 
void  ccc::EE12x14 ::pqr(){vfunc_called(this, "_ZN3ccc7EE12x143pqrEv");}
ccc::EE12x14 ::~EE12x14(){ note_dtor("_ZN3ccc7EE12x14E", this);} // tgen
ccc::EE12x14 ::EE12x14(){ note_ctor("_ZN3ccc7EE12x14E", this);} // tgen
}
static void Test__ZN3ccc7EE12x14E()
{
  extern Class_Descriptor cd__ZN3ccc7EE12x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE12x14E, buf);
    ::ccc::EE12x14 *dp, &lv = *(dp=new (buf) ::ccc::EE12x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE12x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE12x14E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc7EE12x14E");
    test_class_info(&lv, &cd__ZN3ccc7EE12x14E);
    dp->::ccc::EE12x14::~EE12x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE12x14E(Test__ZN3ccc7EE12x14E, "_ZN3ccc7EE12x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE12x14C1Ev();
extern void _ZN3ccc7EE12x14D1Ev();
Name_Map name_map__ZN3ccc7EE12x14E[] = {
  NSPAIR(_ZN3ccc7EE12x14C1Ev),
  NSPAIR(_ZN3ccc7EE12x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc7EE12x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE12x14E[];
extern void _ZN3ccc4AA123abcEv();
extern void _ZN3ccc7EE12x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE12x14E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE12x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
  (VTBL_ENTRY)&_ZN3ccc7EE12x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE12x14E[];
static  VTT_ENTRY vtt__ZN3ccc7EE12x14E[] = {
  {&(_ZTVN3ccc7EE12x14E[4]),  4,6},
  {&(_ZTVN3ccc7EE12x14E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE12x14E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE12x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE12x14E[];
Class_Descriptor cd__ZN3ccc7EE12x14E = {  "_ZN3ccc7EE12x14E", // class name
  bases__ZN3ccc7EE12x14E, 1,
  &(vtc__ZN3ccc7EE12x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE12x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE12x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE12x14E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE12x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE12x15  : virtual ::ccc::AA12 {
  ~EE12x15(); // tgen
  EE12x15(); // tgen
};
//SIG(-1 _ZN3ccc7EE12x15E) C1{ VBC2{ v1}}
}
namespace ccc { 
ccc::EE12x15 ::~EE12x15(){ note_dtor("_ZN3ccc7EE12x15E", this);} // tgen
ccc::EE12x15 ::EE12x15(){ note_ctor("_ZN3ccc7EE12x15E", this);} // tgen
}
static void Test__ZN3ccc7EE12x15E()
{
  extern Class_Descriptor cd__ZN3ccc7EE12x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE12x15E, buf);
    ::ccc::EE12x15 *dp, &lv = *(dp=new (buf) ::ccc::EE12x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE12x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE12x15E)");
    check_base_class_offset(lv, (::ccc::AA12*), 0, "_ZN3ccc7EE12x15E");
    test_class_info(&lv, &cd__ZN3ccc7EE12x15E);
    dp->::ccc::EE12x15::~EE12x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE12x15E(Test__ZN3ccc7EE12x15E, "_ZN3ccc7EE12x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE12x15C1Ev();
extern void _ZN3ccc7EE12x15D1Ev();
Name_Map name_map__ZN3ccc7EE12x15E[] = {
  NSPAIR(_ZN3ccc7EE12x15C1Ev),
  NSPAIR(_ZN3ccc7EE12x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA12E;
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
static Base_Class bases__ZN3ccc7EE12x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE12x15E[];
extern void _ZN3ccc4AA123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE12x15E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE12x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE12x15E[];
static  VTT_ENTRY vtt__ZN3ccc7EE12x15E[] = {
  {&(_ZTVN3ccc7EE12x15E[4]),  4,5},
  {&(_ZTVN3ccc7EE12x15E[4]),  4,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE12x15E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE12x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE12x15E[];
Class_Descriptor cd__ZN3ccc7EE12x15E = {  "_ZN3ccc7EE12x15E", // class name
  bases__ZN3ccc7EE12x15E, 1,
  &(vtc__ZN3ccc7EE12x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE12x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE12x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE12x15E),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE12x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA13  {
  virtual void  efg(); // _ZN3ccc4AA133efgEv
  ~AA13(); // tgen
  AA13(); // tgen
};
//SIG(-1 _ZN3ccc4AA13E) C1{ v1}
}
namespace ccc { 
void  ccc::AA13 ::efg(){vfunc_called(this, "_ZN3ccc4AA133efgEv");}
ccc::AA13 ::~AA13(){ note_dtor("_ZN3ccc4AA13E", this);} // tgen
ccc::AA13 ::AA13(){ note_ctor("_ZN3ccc4AA13E", this);} // tgen
}
static void Test__ZN3ccc4AA13E()
{
  extern Class_Descriptor cd__ZN3ccc4AA13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA13E, buf);
    ::ccc::AA13 *dp, &lv = *(dp=new (buf) ::ccc::AA13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA13E)");
    test_class_info(&lv, &cd__ZN3ccc4AA13E);
    dp->::ccc::AA13::~AA13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA13E(Test__ZN3ccc4AA13E, "_ZN3ccc4AA13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA13C1Ev();
extern void _ZN3ccc4AA13D1Ev();
Name_Map name_map__ZN3ccc4AA13E[] = {
  NSPAIR(_ZN3ccc4AA13C1Ev),
  NSPAIR(_ZN3ccc4AA13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern void _ZN3ccc4AA133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
Class_Descriptor cd__ZN3ccc4AA13E = {  "_ZN3ccc4AA13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB13  {
  virtual void  efg(); // _ZN3ccc4BB133efgEv
  ~BB13(); // tgen
  BB13(); // tgen
};
//SIG(1 _ZN3ccc4BB13E) C1{ v1}
}
namespace ccc { 
void  ccc::BB13 ::efg(){vfunc_called(this, "_ZN3ccc4BB133efgEv");}
ccc::BB13 ::~BB13(){ note_dtor("_ZN3ccc4BB13E", this);} // tgen
ccc::BB13 ::BB13(){ note_ctor("_ZN3ccc4BB13E", this);} // tgen
}
static void Test__ZN3ccc4BB13E()
{
  extern Class_Descriptor cd__ZN3ccc4BB13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB13E, buf);
    ::ccc::BB13 *dp, &lv = *(dp=new (buf) ::ccc::BB13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB13E)");
    test_class_info(&lv, &cd__ZN3ccc4BB13E);
    dp->::ccc::BB13::~BB13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB13E(Test__ZN3ccc4BB13E, "_ZN3ccc4BB13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB13C1Ev();
extern void _ZN3ccc4BB13D1Ev();
Name_Map name_map__ZN3ccc4BB13E[] = {
  NSPAIR(_ZN3ccc4BB13C1Ev),
  NSPAIR(_ZN3ccc4BB13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
Class_Descriptor cd__ZN3ccc4BB13E = {  "_ZN3ccc4BB13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x0  : virtual ::ccc::AA13 {
  virtual void  abc(); // _ZN3ccc6EE13x03abcEv
  virtual void  efg(); // _ZN3ccc6EE13x03efgEv
  virtual void  pqr(); // _ZN3ccc6EE13x03pqrEv
  ~EE13x0(); // tgen
  EE13x0(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x0E) C1{ VBC2{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE13x0 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x03abcEv");}
void  ccc::EE13x0 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x03efgEv");}
void  ccc::EE13x0 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x03pqrEv");}
ccc::EE13x0 ::~EE13x0(){ note_dtor("_ZN3ccc6EE13x0E", this);} // tgen
ccc::EE13x0 ::EE13x0(){ note_ctor("_ZN3ccc6EE13x0E", this);} // tgen
}
static void Test__ZN3ccc6EE13x0E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x0E, buf);
    ::ccc::EE13x0 *dp, &lv = *(dp=new (buf) ::ccc::EE13x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x0E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x0E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x0E);
    dp->::ccc::EE13x0::~EE13x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x0E(Test__ZN3ccc6EE13x0E, "_ZN3ccc6EE13x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x0C1Ev();
extern void _ZN3ccc6EE13x0D1Ev();
Name_Map name_map__ZN3ccc6EE13x0E[] = {
  NSPAIR(_ZN3ccc6EE13x0C1Ev),
  NSPAIR(_ZN3ccc6EE13x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x0E[];
extern void _ZN3ccc6EE13x03efgEv();
extern void _ZN3ccc6EE13x03abcEv();
extern void _ZN3ccc6EE13x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x0E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x0E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x0E[] = {
  {&(_ZTVN3ccc6EE13x0E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x0E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x0E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x0E[];
Class_Descriptor cd__ZN3ccc6EE13x0E = {  "_ZN3ccc6EE13x0E", // class name
  bases__ZN3ccc6EE13x0E, 1,
  &(vtc__ZN3ccc6EE13x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x0E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x1  : virtual ::ccc::AA13 {
  virtual void  abc(); // _ZN3ccc6EE13x13abcEv
  virtual void  pqr(); // _ZN3ccc6EE13x13pqrEv
  virtual void  efg(); // _ZN3ccc6EE13x13efgEv
  ~EE13x1(); // tgen
  EE13x1(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x1E) C1{ VBC2{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE13x1 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x13abcEv");}
void  ccc::EE13x1 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x13pqrEv");}
void  ccc::EE13x1 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x13efgEv");}
ccc::EE13x1 ::~EE13x1(){ note_dtor("_ZN3ccc6EE13x1E", this);} // tgen
ccc::EE13x1 ::EE13x1(){ note_ctor("_ZN3ccc6EE13x1E", this);} // tgen
}
static void Test__ZN3ccc6EE13x1E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x1E, buf);
    ::ccc::EE13x1 *dp, &lv = *(dp=new (buf) ::ccc::EE13x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x1E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x1E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x1E);
    dp->::ccc::EE13x1::~EE13x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x1E(Test__ZN3ccc6EE13x1E, "_ZN3ccc6EE13x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x1C1Ev();
extern void _ZN3ccc6EE13x1D1Ev();
Name_Map name_map__ZN3ccc6EE13x1E[] = {
  NSPAIR(_ZN3ccc6EE13x1C1Ev),
  NSPAIR(_ZN3ccc6EE13x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x1E[];
extern void _ZN3ccc6EE13x13efgEv();
extern void _ZN3ccc6EE13x13abcEv();
extern void _ZN3ccc6EE13x13pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x1E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x13efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x13pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x1E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x1E[] = {
  {&(_ZTVN3ccc6EE13x1E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x1E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x1E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x1E[];
Class_Descriptor cd__ZN3ccc6EE13x1E = {  "_ZN3ccc6EE13x1E", // class name
  bases__ZN3ccc6EE13x1E, 1,
  &(vtc__ZN3ccc6EE13x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x1E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x2  : virtual ::ccc::AA13 {
  virtual void  efg(); // _ZN3ccc6EE13x23efgEv
  virtual void  abc(); // _ZN3ccc6EE13x23abcEv
  virtual void  pqr(); // _ZN3ccc6EE13x23pqrEv
  ~EE13x2(); // tgen
  EE13x2(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x2E) C1{ VBC2{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE13x2 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x23efgEv");}
void  ccc::EE13x2 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x23abcEv");}
void  ccc::EE13x2 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x23pqrEv");}
ccc::EE13x2 ::~EE13x2(){ note_dtor("_ZN3ccc6EE13x2E", this);} // tgen
ccc::EE13x2 ::EE13x2(){ note_ctor("_ZN3ccc6EE13x2E", this);} // tgen
}
static void Test__ZN3ccc6EE13x2E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x2E, buf);
    ::ccc::EE13x2 *dp, &lv = *(dp=new (buf) ::ccc::EE13x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x2E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x2E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x2E);
    dp->::ccc::EE13x2::~EE13x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x2E(Test__ZN3ccc6EE13x2E, "_ZN3ccc6EE13x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x2C1Ev();
extern void _ZN3ccc6EE13x2D1Ev();
Name_Map name_map__ZN3ccc6EE13x2E[] = {
  NSPAIR(_ZN3ccc6EE13x2C1Ev),
  NSPAIR(_ZN3ccc6EE13x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x2E[];
extern void _ZN3ccc6EE13x23efgEv();
extern void _ZN3ccc6EE13x23abcEv();
extern void _ZN3ccc6EE13x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x2E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x2E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x2E[] = {
  {&(_ZTVN3ccc6EE13x2E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x2E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x2E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x2E[];
Class_Descriptor cd__ZN3ccc6EE13x2E = {  "_ZN3ccc6EE13x2E", // class name
  bases__ZN3ccc6EE13x2E, 1,
  &(vtc__ZN3ccc6EE13x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x2E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x3  : virtual ::ccc::AA13 {
  virtual void  efg(); // _ZN3ccc6EE13x33efgEv
  virtual void  pqr(); // _ZN3ccc6EE13x33pqrEv
  virtual void  abc(); // _ZN3ccc6EE13x33abcEv
  ~EE13x3(); // tgen
  EE13x3(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x3E) C1{ VBC2{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE13x3 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x33efgEv");}
void  ccc::EE13x3 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x33pqrEv");}
void  ccc::EE13x3 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x33abcEv");}
ccc::EE13x3 ::~EE13x3(){ note_dtor("_ZN3ccc6EE13x3E", this);} // tgen
ccc::EE13x3 ::EE13x3(){ note_ctor("_ZN3ccc6EE13x3E", this);} // tgen
}
static void Test__ZN3ccc6EE13x3E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x3E, buf);
    ::ccc::EE13x3 *dp, &lv = *(dp=new (buf) ::ccc::EE13x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x3E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x3E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x3E);
    dp->::ccc::EE13x3::~EE13x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x3E(Test__ZN3ccc6EE13x3E, "_ZN3ccc6EE13x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x3C1Ev();
extern void _ZN3ccc6EE13x3D1Ev();
Name_Map name_map__ZN3ccc6EE13x3E[] = {
  NSPAIR(_ZN3ccc6EE13x3C1Ev),
  NSPAIR(_ZN3ccc6EE13x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x3E[];
extern void _ZN3ccc6EE13x33efgEv();
extern void _ZN3ccc6EE13x33pqrEv();
extern void _ZN3ccc6EE13x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x3E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x3E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x3E[] = {
  {&(_ZTVN3ccc6EE13x3E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x3E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x3E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x3E[];
Class_Descriptor cd__ZN3ccc6EE13x3E = {  "_ZN3ccc6EE13x3E", // class name
  bases__ZN3ccc6EE13x3E, 1,
  &(vtc__ZN3ccc6EE13x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x3E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x4  : virtual ::ccc::AA13 {
  virtual void  pqr(); // _ZN3ccc6EE13x43pqrEv
  virtual void  abc(); // _ZN3ccc6EE13x43abcEv
  virtual void  efg(); // _ZN3ccc6EE13x43efgEv
  ~EE13x4(); // tgen
  EE13x4(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x4E) C1{ VBC2{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE13x4 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x43pqrEv");}
void  ccc::EE13x4 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x43abcEv");}
void  ccc::EE13x4 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x43efgEv");}
ccc::EE13x4 ::~EE13x4(){ note_dtor("_ZN3ccc6EE13x4E", this);} // tgen
ccc::EE13x4 ::EE13x4(){ note_ctor("_ZN3ccc6EE13x4E", this);} // tgen
}
static void Test__ZN3ccc6EE13x4E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x4E, buf);
    ::ccc::EE13x4 *dp, &lv = *(dp=new (buf) ::ccc::EE13x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x4E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x4E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x4E);
    dp->::ccc::EE13x4::~EE13x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x4E(Test__ZN3ccc6EE13x4E, "_ZN3ccc6EE13x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x4C1Ev();
extern void _ZN3ccc6EE13x4D1Ev();
Name_Map name_map__ZN3ccc6EE13x4E[] = {
  NSPAIR(_ZN3ccc6EE13x4C1Ev),
  NSPAIR(_ZN3ccc6EE13x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x4E[];
extern void _ZN3ccc6EE13x43efgEv();
extern void _ZN3ccc6EE13x43pqrEv();
extern void _ZN3ccc6EE13x43abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x4E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x43efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x43abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x4E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x4E[] = {
  {&(_ZTVN3ccc6EE13x4E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x4E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x4E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x4E[];
Class_Descriptor cd__ZN3ccc6EE13x4E = {  "_ZN3ccc6EE13x4E", // class name
  bases__ZN3ccc6EE13x4E, 1,
  &(vtc__ZN3ccc6EE13x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x4E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x5  : virtual ::ccc::AA13 {
  virtual void  pqr(); // _ZN3ccc6EE13x53pqrEv
  virtual void  efg(); // _ZN3ccc6EE13x53efgEv
  virtual void  abc(); // _ZN3ccc6EE13x53abcEv
  ~EE13x5(); // tgen
  EE13x5(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x5E) C1{ VBC2{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE13x5 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x53pqrEv");}
void  ccc::EE13x5 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x53efgEv");}
void  ccc::EE13x5 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x53abcEv");}
ccc::EE13x5 ::~EE13x5(){ note_dtor("_ZN3ccc6EE13x5E", this);} // tgen
ccc::EE13x5 ::EE13x5(){ note_ctor("_ZN3ccc6EE13x5E", this);} // tgen
}
static void Test__ZN3ccc6EE13x5E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x5E, buf);
    ::ccc::EE13x5 *dp, &lv = *(dp=new (buf) ::ccc::EE13x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x5E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x5E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x5E);
    dp->::ccc::EE13x5::~EE13x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x5E(Test__ZN3ccc6EE13x5E, "_ZN3ccc6EE13x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x5C1Ev();
extern void _ZN3ccc6EE13x5D1Ev();
Name_Map name_map__ZN3ccc6EE13x5E[] = {
  NSPAIR(_ZN3ccc6EE13x5C1Ev),
  NSPAIR(_ZN3ccc6EE13x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x5E[];
extern void _ZN3ccc6EE13x53efgEv();
extern void _ZN3ccc6EE13x53pqrEv();
extern void _ZN3ccc6EE13x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x5E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x5E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x5E[] = {
  {&(_ZTVN3ccc6EE13x5E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x5E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x5E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x5E[];
Class_Descriptor cd__ZN3ccc6EE13x5E = {  "_ZN3ccc6EE13x5E", // class name
  bases__ZN3ccc6EE13x5E, 1,
  &(vtc__ZN3ccc6EE13x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x5E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x6  : virtual ::ccc::AA13 {
  virtual void  abc(); // _ZN3ccc6EE13x63abcEv
  virtual void  efg(); // _ZN3ccc6EE13x63efgEv
  ~EE13x6(); // tgen
  EE13x6(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x6E) C1{ VBC2{ v2} v1 v2}
}
namespace ccc { 
void  ccc::EE13x6 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x63abcEv");}
void  ccc::EE13x6 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x63efgEv");}
ccc::EE13x6 ::~EE13x6(){ note_dtor("_ZN3ccc6EE13x6E", this);} // tgen
ccc::EE13x6 ::EE13x6(){ note_ctor("_ZN3ccc6EE13x6E", this);} // tgen
}
static void Test__ZN3ccc6EE13x6E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x6E, buf);
    ::ccc::EE13x6 *dp, &lv = *(dp=new (buf) ::ccc::EE13x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x6E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x6E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x6E);
    dp->::ccc::EE13x6::~EE13x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x6E(Test__ZN3ccc6EE13x6E, "_ZN3ccc6EE13x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x6C1Ev();
extern void _ZN3ccc6EE13x6D1Ev();
Name_Map name_map__ZN3ccc6EE13x6E[] = {
  NSPAIR(_ZN3ccc6EE13x6C1Ev),
  NSPAIR(_ZN3ccc6EE13x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x6E[];
extern void _ZN3ccc6EE13x63efgEv();
extern void _ZN3ccc6EE13x63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x6E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x63efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x6E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x6E[] = {
  {&(_ZTVN3ccc6EE13x6E[4]),  4,6},
  {&(_ZTVN3ccc6EE13x6E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x6E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x6E[];
Class_Descriptor cd__ZN3ccc6EE13x6E = {  "_ZN3ccc6EE13x6E", // class name
  bases__ZN3ccc6EE13x6E, 1,
  &(vtc__ZN3ccc6EE13x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x6E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x7  : virtual ::ccc::AA13 {
  virtual void  abc(); // _ZN3ccc6EE13x73abcEv
  virtual void  pqr(); // _ZN3ccc6EE13x73pqrEv
  ~EE13x7(); // tgen
  EE13x7(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x7E) C1{ VBC2{ v3} v1 v2}
}
namespace ccc { 
void  ccc::EE13x7 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x73abcEv");}
void  ccc::EE13x7 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x73pqrEv");}
ccc::EE13x7 ::~EE13x7(){ note_dtor("_ZN3ccc6EE13x7E", this);} // tgen
ccc::EE13x7 ::EE13x7(){ note_ctor("_ZN3ccc6EE13x7E", this);} // tgen
}
static void Test__ZN3ccc6EE13x7E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x7E, buf);
    ::ccc::EE13x7 *dp, &lv = *(dp=new (buf) ::ccc::EE13x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x7E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x7E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x7E);
    dp->::ccc::EE13x7::~EE13x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x7E(Test__ZN3ccc6EE13x7E, "_ZN3ccc6EE13x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x7C1Ev();
extern void _ZN3ccc6EE13x7D1Ev();
Name_Map name_map__ZN3ccc6EE13x7E[] = {
  NSPAIR(_ZN3ccc6EE13x7C1Ev),
  NSPAIR(_ZN3ccc6EE13x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x7E[];
extern void _ZN3ccc4AA133efgEv();
extern void _ZN3ccc6EE13x73abcEv();
extern void _ZN3ccc6EE13x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x7E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x7E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x7E[] = {
  {&(_ZTVN3ccc6EE13x7E[4]),  4,7},
  {&(_ZTVN3ccc6EE13x7E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x7E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x7E[];
Class_Descriptor cd__ZN3ccc6EE13x7E = {  "_ZN3ccc6EE13x7E", // class name
  bases__ZN3ccc6EE13x7E, 1,
  &(vtc__ZN3ccc6EE13x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x7E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x8  : virtual ::ccc::AA13 {
  virtual void  efg(); // _ZN3ccc6EE13x83efgEv
  virtual void  abc(); // _ZN3ccc6EE13x83abcEv
  ~EE13x8(); // tgen
  EE13x8(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x8E) C1{ VBC2{ v1} v1 v2}
}
namespace ccc { 
void  ccc::EE13x8 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x83efgEv");}
void  ccc::EE13x8 ::abc(){vfunc_called(this, "_ZN3ccc6EE13x83abcEv");}
ccc::EE13x8 ::~EE13x8(){ note_dtor("_ZN3ccc6EE13x8E", this);} // tgen
ccc::EE13x8 ::EE13x8(){ note_ctor("_ZN3ccc6EE13x8E", this);} // tgen
}
static void Test__ZN3ccc6EE13x8E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x8E, buf);
    ::ccc::EE13x8 *dp, &lv = *(dp=new (buf) ::ccc::EE13x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x8E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x8E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x8E);
    dp->::ccc::EE13x8::~EE13x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x8E(Test__ZN3ccc6EE13x8E, "_ZN3ccc6EE13x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x8C1Ev();
extern void _ZN3ccc6EE13x8D1Ev();
Name_Map name_map__ZN3ccc6EE13x8E[] = {
  NSPAIR(_ZN3ccc6EE13x8C1Ev),
  NSPAIR(_ZN3ccc6EE13x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x8E[];
extern void _ZN3ccc6EE13x83efgEv();
extern void _ZN3ccc6EE13x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x8E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x8E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x8E[] = {
  {&(_ZTVN3ccc6EE13x8E[4]),  4,6},
  {&(_ZTVN3ccc6EE13x8E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x8E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x8E[];
Class_Descriptor cd__ZN3ccc6EE13x8E = {  "_ZN3ccc6EE13x8E", // class name
  bases__ZN3ccc6EE13x8E, 1,
  &(vtc__ZN3ccc6EE13x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x8E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x9  : virtual ::ccc::AA13 {
  virtual void  efg(); // _ZN3ccc6EE13x93efgEv
  virtual void  pqr(); // _ZN3ccc6EE13x93pqrEv
  ~EE13x9(); // tgen
  EE13x9(); // tgen
};
//SIG(-1 _ZN3ccc6EE13x9E) C1{ VBC2{ v1} v1 v2}
}
namespace ccc { 
void  ccc::EE13x9 ::efg(){vfunc_called(this, "_ZN3ccc6EE13x93efgEv");}
void  ccc::EE13x9 ::pqr(){vfunc_called(this, "_ZN3ccc6EE13x93pqrEv");}
ccc::EE13x9 ::~EE13x9(){ note_dtor("_ZN3ccc6EE13x9E", this);} // tgen
ccc::EE13x9 ::EE13x9(){ note_ctor("_ZN3ccc6EE13x9E", this);} // tgen
}
static void Test__ZN3ccc6EE13x9E()
{
  extern Class_Descriptor cd__ZN3ccc6EE13x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE13x9E, buf);
    ::ccc::EE13x9 *dp, &lv = *(dp=new (buf) ::ccc::EE13x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE13x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE13x9E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc6EE13x9E");
    test_class_info(&lv, &cd__ZN3ccc6EE13x9E);
    dp->::ccc::EE13x9::~EE13x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE13x9E(Test__ZN3ccc6EE13x9E, "_ZN3ccc6EE13x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE13x9C1Ev();
extern void _ZN3ccc6EE13x9D1Ev();
Name_Map name_map__ZN3ccc6EE13x9E[] = {
  NSPAIR(_ZN3ccc6EE13x9C1Ev),
  NSPAIR(_ZN3ccc6EE13x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc6EE13x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE13x9E[];
extern void _ZN3ccc6EE13x93efgEv();
extern void _ZN3ccc6EE13x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE13x9E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE13x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE13x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE13x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE13x9E[];
static  VTT_ENTRY vtt__ZN3ccc6EE13x9E[] = {
  {&(_ZTVN3ccc6EE13x9E[4]),  4,6},
  {&(_ZTVN3ccc6EE13x9E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE13x9E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE13x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE13x9E[];
Class_Descriptor cd__ZN3ccc6EE13x9E = {  "_ZN3ccc6EE13x9E", // class name
  bases__ZN3ccc6EE13x9E, 1,
  &(vtc__ZN3ccc6EE13x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE13x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE13x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE13x9E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE13x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x10  : virtual ::ccc::AA13 {
  virtual void  pqr(); // _ZN3ccc7EE13x103pqrEv
  virtual void  abc(); // _ZN3ccc7EE13x103abcEv
  ~EE13x10(); // tgen
  EE13x10(); // tgen
};
//SIG(-1 _ZN3ccc7EE13x10E) C1{ VBC2{ v3} v1 v2}
}
namespace ccc { 
void  ccc::EE13x10 ::pqr(){vfunc_called(this, "_ZN3ccc7EE13x103pqrEv");}
void  ccc::EE13x10 ::abc(){vfunc_called(this, "_ZN3ccc7EE13x103abcEv");}
ccc::EE13x10 ::~EE13x10(){ note_dtor("_ZN3ccc7EE13x10E", this);} // tgen
ccc::EE13x10 ::EE13x10(){ note_ctor("_ZN3ccc7EE13x10E", this);} // tgen
}
static void Test__ZN3ccc7EE13x10E()
{
  extern Class_Descriptor cd__ZN3ccc7EE13x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE13x10E, buf);
    ::ccc::EE13x10 *dp, &lv = *(dp=new (buf) ::ccc::EE13x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE13x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE13x10E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc7EE13x10E");
    test_class_info(&lv, &cd__ZN3ccc7EE13x10E);
    dp->::ccc::EE13x10::~EE13x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE13x10E(Test__ZN3ccc7EE13x10E, "_ZN3ccc7EE13x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE13x10C1Ev();
extern void _ZN3ccc7EE13x10D1Ev();
Name_Map name_map__ZN3ccc7EE13x10E[] = {
  NSPAIR(_ZN3ccc7EE13x10C1Ev),
  NSPAIR(_ZN3ccc7EE13x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc7EE13x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE13x10E[];
extern void _ZN3ccc4AA133efgEv();
extern void _ZN3ccc7EE13x103pqrEv();
extern void _ZN3ccc7EE13x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE13x10E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE13x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
  (VTBL_ENTRY)&_ZN3ccc7EE13x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE13x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE13x10E[];
static  VTT_ENTRY vtt__ZN3ccc7EE13x10E[] = {
  {&(_ZTVN3ccc7EE13x10E[4]),  4,7},
  {&(_ZTVN3ccc7EE13x10E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc7EE13x10E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE13x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE13x10E[];
Class_Descriptor cd__ZN3ccc7EE13x10E = {  "_ZN3ccc7EE13x10E", // class name
  bases__ZN3ccc7EE13x10E, 1,
  &(vtc__ZN3ccc7EE13x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE13x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE13x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE13x10E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE13x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x11  : virtual ::ccc::AA13 {
  virtual void  pqr(); // _ZN3ccc7EE13x113pqrEv
  virtual void  efg(); // _ZN3ccc7EE13x113efgEv
  ~EE13x11(); // tgen
  EE13x11(); // tgen
};
//SIG(-1 _ZN3ccc7EE13x11E) C1{ VBC2{ v2} v1 v2}
}
namespace ccc { 
void  ccc::EE13x11 ::pqr(){vfunc_called(this, "_ZN3ccc7EE13x113pqrEv");}
void  ccc::EE13x11 ::efg(){vfunc_called(this, "_ZN3ccc7EE13x113efgEv");}
ccc::EE13x11 ::~EE13x11(){ note_dtor("_ZN3ccc7EE13x11E", this);} // tgen
ccc::EE13x11 ::EE13x11(){ note_ctor("_ZN3ccc7EE13x11E", this);} // tgen
}
static void Test__ZN3ccc7EE13x11E()
{
  extern Class_Descriptor cd__ZN3ccc7EE13x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE13x11E, buf);
    ::ccc::EE13x11 *dp, &lv = *(dp=new (buf) ::ccc::EE13x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE13x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE13x11E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc7EE13x11E");
    test_class_info(&lv, &cd__ZN3ccc7EE13x11E);
    dp->::ccc::EE13x11::~EE13x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE13x11E(Test__ZN3ccc7EE13x11E, "_ZN3ccc7EE13x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE13x11C1Ev();
extern void _ZN3ccc7EE13x11D1Ev();
Name_Map name_map__ZN3ccc7EE13x11E[] = {
  NSPAIR(_ZN3ccc7EE13x11C1Ev),
  NSPAIR(_ZN3ccc7EE13x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc7EE13x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE13x11E[];
extern void _ZN3ccc7EE13x113efgEv();
extern void _ZN3ccc7EE13x113pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE13x11E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE13x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE13x113efgEv,
  (VTBL_ENTRY)&_ZN3ccc7EE13x113pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE13x11E[];
static  VTT_ENTRY vtt__ZN3ccc7EE13x11E[] = {
  {&(_ZTVN3ccc7EE13x11E[4]),  4,6},
  {&(_ZTVN3ccc7EE13x11E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE13x11E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE13x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE13x11E[];
Class_Descriptor cd__ZN3ccc7EE13x11E = {  "_ZN3ccc7EE13x11E", // class name
  bases__ZN3ccc7EE13x11E, 1,
  &(vtc__ZN3ccc7EE13x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE13x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE13x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE13x11E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE13x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x12  : virtual ::ccc::AA13 {
  virtual void  abc(); // _ZN3ccc7EE13x123abcEv
  ~EE13x12(); // tgen
  EE13x12(); // tgen
};
//SIG(-1 _ZN3ccc7EE13x12E) C1{ VBC2{ v2} v1}
}
namespace ccc { 
void  ccc::EE13x12 ::abc(){vfunc_called(this, "_ZN3ccc7EE13x123abcEv");}
ccc::EE13x12 ::~EE13x12(){ note_dtor("_ZN3ccc7EE13x12E", this);} // tgen
ccc::EE13x12 ::EE13x12(){ note_ctor("_ZN3ccc7EE13x12E", this);} // tgen
}
static void Test__ZN3ccc7EE13x12E()
{
  extern Class_Descriptor cd__ZN3ccc7EE13x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE13x12E, buf);
    ::ccc::EE13x12 *dp, &lv = *(dp=new (buf) ::ccc::EE13x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE13x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE13x12E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc7EE13x12E");
    test_class_info(&lv, &cd__ZN3ccc7EE13x12E);
    dp->::ccc::EE13x12::~EE13x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE13x12E(Test__ZN3ccc7EE13x12E, "_ZN3ccc7EE13x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE13x12C1Ev();
extern void _ZN3ccc7EE13x12D1Ev();
Name_Map name_map__ZN3ccc7EE13x12E[] = {
  NSPAIR(_ZN3ccc7EE13x12C1Ev),
  NSPAIR(_ZN3ccc7EE13x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc7EE13x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE13x12E[];
extern void _ZN3ccc4AA133efgEv();
extern void _ZN3ccc7EE13x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE13x12E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE13x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
  (VTBL_ENTRY)&_ZN3ccc7EE13x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE13x12E[];
static  VTT_ENTRY vtt__ZN3ccc7EE13x12E[] = {
  {&(_ZTVN3ccc7EE13x12E[4]),  4,6},
  {&(_ZTVN3ccc7EE13x12E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE13x12E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE13x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE13x12E[];
Class_Descriptor cd__ZN3ccc7EE13x12E = {  "_ZN3ccc7EE13x12E", // class name
  bases__ZN3ccc7EE13x12E, 1,
  &(vtc__ZN3ccc7EE13x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE13x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE13x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE13x12E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE13x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x13  : virtual ::ccc::AA13 {
  virtual void  efg(); // _ZN3ccc7EE13x133efgEv
  ~EE13x13(); // tgen
  EE13x13(); // tgen
};
//SIG(-1 _ZN3ccc7EE13x13E) C1{ VBC2{ v1} v1}
}
namespace ccc { 
void  ccc::EE13x13 ::efg(){vfunc_called(this, "_ZN3ccc7EE13x133efgEv");}
ccc::EE13x13 ::~EE13x13(){ note_dtor("_ZN3ccc7EE13x13E", this);} // tgen
ccc::EE13x13 ::EE13x13(){ note_ctor("_ZN3ccc7EE13x13E", this);} // tgen
}
static void Test__ZN3ccc7EE13x13E()
{
  extern Class_Descriptor cd__ZN3ccc7EE13x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE13x13E, buf);
    ::ccc::EE13x13 *dp, &lv = *(dp=new (buf) ::ccc::EE13x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE13x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE13x13E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc7EE13x13E");
    test_class_info(&lv, &cd__ZN3ccc7EE13x13E);
    dp->::ccc::EE13x13::~EE13x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE13x13E(Test__ZN3ccc7EE13x13E, "_ZN3ccc7EE13x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE13x13C1Ev();
extern void _ZN3ccc7EE13x13D1Ev();
Name_Map name_map__ZN3ccc7EE13x13E[] = {
  NSPAIR(_ZN3ccc7EE13x13C1Ev),
  NSPAIR(_ZN3ccc7EE13x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc7EE13x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE13x13E[];
extern void _ZN3ccc7EE13x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE13x13E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE13x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE13x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE13x13E[];
static  VTT_ENTRY vtt__ZN3ccc7EE13x13E[] = {
  {&(_ZTVN3ccc7EE13x13E[4]),  4,5},
  {&(_ZTVN3ccc7EE13x13E[4]),  4,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE13x13E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE13x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE13x13E[];
Class_Descriptor cd__ZN3ccc7EE13x13E = {  "_ZN3ccc7EE13x13E", // class name
  bases__ZN3ccc7EE13x13E, 1,
  &(vtc__ZN3ccc7EE13x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE13x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE13x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE13x13E),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE13x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x14  : virtual ::ccc::AA13 {
  virtual void  pqr(); // _ZN3ccc7EE13x143pqrEv
  ~EE13x14(); // tgen
  EE13x14(); // tgen
};
//SIG(-1 _ZN3ccc7EE13x14E) C1{ VBC2{ v2} v1}
}
namespace ccc { 
void  ccc::EE13x14 ::pqr(){vfunc_called(this, "_ZN3ccc7EE13x143pqrEv");}
ccc::EE13x14 ::~EE13x14(){ note_dtor("_ZN3ccc7EE13x14E", this);} // tgen
ccc::EE13x14 ::EE13x14(){ note_ctor("_ZN3ccc7EE13x14E", this);} // tgen
}
static void Test__ZN3ccc7EE13x14E()
{
  extern Class_Descriptor cd__ZN3ccc7EE13x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE13x14E, buf);
    ::ccc::EE13x14 *dp, &lv = *(dp=new (buf) ::ccc::EE13x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE13x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE13x14E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc7EE13x14E");
    test_class_info(&lv, &cd__ZN3ccc7EE13x14E);
    dp->::ccc::EE13x14::~EE13x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE13x14E(Test__ZN3ccc7EE13x14E, "_ZN3ccc7EE13x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE13x14C1Ev();
extern void _ZN3ccc7EE13x14D1Ev();
Name_Map name_map__ZN3ccc7EE13x14E[] = {
  NSPAIR(_ZN3ccc7EE13x14C1Ev),
  NSPAIR(_ZN3ccc7EE13x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc7EE13x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE13x14E[];
extern void _ZN3ccc4AA133efgEv();
extern void _ZN3ccc7EE13x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE13x14E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE13x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
  (VTBL_ENTRY)&_ZN3ccc7EE13x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE13x14E[];
static  VTT_ENTRY vtt__ZN3ccc7EE13x14E[] = {
  {&(_ZTVN3ccc7EE13x14E[4]),  4,6},
  {&(_ZTVN3ccc7EE13x14E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE13x14E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE13x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE13x14E[];
Class_Descriptor cd__ZN3ccc7EE13x14E = {  "_ZN3ccc7EE13x14E", // class name
  bases__ZN3ccc7EE13x14E, 1,
  &(vtc__ZN3ccc7EE13x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE13x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE13x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE13x14E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE13x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE13x15  : virtual ::ccc::AA13 {
  ~EE13x15(); // tgen
  EE13x15(); // tgen
};
//SIG(-1 _ZN3ccc7EE13x15E) C1{ VBC2{ v1}}
}
namespace ccc { 
ccc::EE13x15 ::~EE13x15(){ note_dtor("_ZN3ccc7EE13x15E", this);} // tgen
ccc::EE13x15 ::EE13x15(){ note_ctor("_ZN3ccc7EE13x15E", this);} // tgen
}
static void Test__ZN3ccc7EE13x15E()
{
  extern Class_Descriptor cd__ZN3ccc7EE13x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE13x15E, buf);
    ::ccc::EE13x15 *dp, &lv = *(dp=new (buf) ::ccc::EE13x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE13x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE13x15E)");
    check_base_class_offset(lv, (::ccc::AA13*), 0, "_ZN3ccc7EE13x15E");
    test_class_info(&lv, &cd__ZN3ccc7EE13x15E);
    dp->::ccc::EE13x15::~EE13x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE13x15E(Test__ZN3ccc7EE13x15E, "_ZN3ccc7EE13x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE13x15C1Ev();
extern void _ZN3ccc7EE13x15D1Ev();
Name_Map name_map__ZN3ccc7EE13x15E[] = {
  NSPAIR(_ZN3ccc7EE13x15C1Ev),
  NSPAIR(_ZN3ccc7EE13x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA13E;
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
static Base_Class bases__ZN3ccc7EE13x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA13E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE13x15E[];
extern void _ZN3ccc4AA133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE13x15E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE13x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE13x15E[];
static  VTT_ENTRY vtt__ZN3ccc7EE13x15E[] = {
  {&(_ZTVN3ccc7EE13x15E[4]),  4,5},
  {&(_ZTVN3ccc7EE13x15E[4]),  4,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE13x15E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE13x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE13x15E[];
Class_Descriptor cd__ZN3ccc7EE13x15E = {  "_ZN3ccc7EE13x15E", // class name
  bases__ZN3ccc7EE13x15E, 1,
  &(vtc__ZN3ccc7EE13x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE13x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE13x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE13x15E),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE13x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA14  {
  virtual void  pqr(); // _ZN3ccc4AA143pqrEv
  ~AA14(); // tgen
  AA14(); // tgen
};
//SIG(-1 _ZN3ccc4AA14E) C1{ v1}
}
namespace ccc { 
void  ccc::AA14 ::pqr(){vfunc_called(this, "_ZN3ccc4AA143pqrEv");}
ccc::AA14 ::~AA14(){ note_dtor("_ZN3ccc4AA14E", this);} // tgen
ccc::AA14 ::AA14(){ note_ctor("_ZN3ccc4AA14E", this);} // tgen
}
static void Test__ZN3ccc4AA14E()
{
  extern Class_Descriptor cd__ZN3ccc4AA14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA14E, buf);
    ::ccc::AA14 *dp, &lv = *(dp=new (buf) ::ccc::AA14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA14E)");
    test_class_info(&lv, &cd__ZN3ccc4AA14E);
    dp->::ccc::AA14::~AA14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA14E(Test__ZN3ccc4AA14E, "_ZN3ccc4AA14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA14C1Ev();
extern void _ZN3ccc4AA14D1Ev();
Name_Map name_map__ZN3ccc4AA14E[] = {
  NSPAIR(_ZN3ccc4AA14C1Ev),
  NSPAIR(_ZN3ccc4AA14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern void _ZN3ccc4AA143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
Class_Descriptor cd__ZN3ccc4AA14E = {  "_ZN3ccc4AA14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB14  {
  virtual void  pqr(); // _ZN3ccc4BB143pqrEv
  ~BB14(); // tgen
  BB14(); // tgen
};
//SIG(1 _ZN3ccc4BB14E) C1{ v1}
}
namespace ccc { 
void  ccc::BB14 ::pqr(){vfunc_called(this, "_ZN3ccc4BB143pqrEv");}
ccc::BB14 ::~BB14(){ note_dtor("_ZN3ccc4BB14E", this);} // tgen
ccc::BB14 ::BB14(){ note_ctor("_ZN3ccc4BB14E", this);} // tgen
}
static void Test__ZN3ccc4BB14E()
{
  extern Class_Descriptor cd__ZN3ccc4BB14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB14E, buf);
    ::ccc::BB14 *dp, &lv = *(dp=new (buf) ::ccc::BB14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB14E)");
    test_class_info(&lv, &cd__ZN3ccc4BB14E);
    dp->::ccc::BB14::~BB14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB14E(Test__ZN3ccc4BB14E, "_ZN3ccc4BB14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB14C1Ev();
extern void _ZN3ccc4BB14D1Ev();
Name_Map name_map__ZN3ccc4BB14E[] = {
  NSPAIR(_ZN3ccc4BB14C1Ev),
  NSPAIR(_ZN3ccc4BB14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern void _ZN3ccc4BB143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
Class_Descriptor cd__ZN3ccc4BB14E = {  "_ZN3ccc4BB14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x0  : virtual ::ccc::AA14 {
  virtual void  abc(); // _ZN3ccc6EE14x03abcEv
  virtual void  efg(); // _ZN3ccc6EE14x03efgEv
  virtual void  pqr(); // _ZN3ccc6EE14x03pqrEv
  ~EE14x0(); // tgen
  EE14x0(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x0E) C1{ VBC2{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE14x0 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x03abcEv");}
void  ccc::EE14x0 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x03efgEv");}
void  ccc::EE14x0 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x03pqrEv");}
ccc::EE14x0 ::~EE14x0(){ note_dtor("_ZN3ccc6EE14x0E", this);} // tgen
ccc::EE14x0 ::EE14x0(){ note_ctor("_ZN3ccc6EE14x0E", this);} // tgen
}
static void Test__ZN3ccc6EE14x0E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x0E, buf);
    ::ccc::EE14x0 *dp, &lv = *(dp=new (buf) ::ccc::EE14x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x0E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x0E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x0E);
    dp->::ccc::EE14x0::~EE14x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x0E(Test__ZN3ccc6EE14x0E, "_ZN3ccc6EE14x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x0C1Ev();
extern void _ZN3ccc6EE14x0D1Ev();
Name_Map name_map__ZN3ccc6EE14x0E[] = {
  NSPAIR(_ZN3ccc6EE14x0C1Ev),
  NSPAIR(_ZN3ccc6EE14x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x0E[];
extern void _ZN3ccc6EE14x03pqrEv();
extern void _ZN3ccc6EE14x03abcEv();
extern void _ZN3ccc6EE14x03efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x0E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x03efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x0E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x0E[] = {
  {&(_ZTVN3ccc6EE14x0E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x0E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x0E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x0E[];
Class_Descriptor cd__ZN3ccc6EE14x0E = {  "_ZN3ccc6EE14x0E", // class name
  bases__ZN3ccc6EE14x0E, 1,
  &(vtc__ZN3ccc6EE14x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x0E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x0E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x1  : virtual ::ccc::AA14 {
  virtual void  abc(); // _ZN3ccc6EE14x13abcEv
  virtual void  pqr(); // _ZN3ccc6EE14x13pqrEv
  virtual void  efg(); // _ZN3ccc6EE14x13efgEv
  ~EE14x1(); // tgen
  EE14x1(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x1E) C1{ VBC2{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE14x1 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x13abcEv");}
void  ccc::EE14x1 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x13pqrEv");}
void  ccc::EE14x1 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x13efgEv");}
ccc::EE14x1 ::~EE14x1(){ note_dtor("_ZN3ccc6EE14x1E", this);} // tgen
ccc::EE14x1 ::EE14x1(){ note_ctor("_ZN3ccc6EE14x1E", this);} // tgen
}
static void Test__ZN3ccc6EE14x1E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x1E, buf);
    ::ccc::EE14x1 *dp, &lv = *(dp=new (buf) ::ccc::EE14x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x1E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x1E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x1E);
    dp->::ccc::EE14x1::~EE14x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x1E(Test__ZN3ccc6EE14x1E, "_ZN3ccc6EE14x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x1C1Ev();
extern void _ZN3ccc6EE14x1D1Ev();
Name_Map name_map__ZN3ccc6EE14x1E[] = {
  NSPAIR(_ZN3ccc6EE14x1C1Ev),
  NSPAIR(_ZN3ccc6EE14x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x1E[];
extern void _ZN3ccc6EE14x13pqrEv();
extern void _ZN3ccc6EE14x13abcEv();
extern void _ZN3ccc6EE14x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x1E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x1E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x1E[] = {
  {&(_ZTVN3ccc6EE14x1E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x1E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x1E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x1E[];
Class_Descriptor cd__ZN3ccc6EE14x1E = {  "_ZN3ccc6EE14x1E", // class name
  bases__ZN3ccc6EE14x1E, 1,
  &(vtc__ZN3ccc6EE14x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x1E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x1E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x2  : virtual ::ccc::AA14 {
  virtual void  efg(); // _ZN3ccc6EE14x23efgEv
  virtual void  abc(); // _ZN3ccc6EE14x23abcEv
  virtual void  pqr(); // _ZN3ccc6EE14x23pqrEv
  ~EE14x2(); // tgen
  EE14x2(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x2E) C1{ VBC2{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE14x2 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x23efgEv");}
void  ccc::EE14x2 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x23abcEv");}
void  ccc::EE14x2 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x23pqrEv");}
ccc::EE14x2 ::~EE14x2(){ note_dtor("_ZN3ccc6EE14x2E", this);} // tgen
ccc::EE14x2 ::EE14x2(){ note_ctor("_ZN3ccc6EE14x2E", this);} // tgen
}
static void Test__ZN3ccc6EE14x2E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x2E, buf);
    ::ccc::EE14x2 *dp, &lv = *(dp=new (buf) ::ccc::EE14x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x2E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x2E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x2E);
    dp->::ccc::EE14x2::~EE14x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x2E(Test__ZN3ccc6EE14x2E, "_ZN3ccc6EE14x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x2C1Ev();
extern void _ZN3ccc6EE14x2D1Ev();
Name_Map name_map__ZN3ccc6EE14x2E[] = {
  NSPAIR(_ZN3ccc6EE14x2C1Ev),
  NSPAIR(_ZN3ccc6EE14x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x2E[];
extern void _ZN3ccc6EE14x23pqrEv();
extern void _ZN3ccc6EE14x23efgEv();
extern void _ZN3ccc6EE14x23abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x2E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x23abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x2E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x2E[] = {
  {&(_ZTVN3ccc6EE14x2E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x2E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x2E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x2E[];
Class_Descriptor cd__ZN3ccc6EE14x2E = {  "_ZN3ccc6EE14x2E", // class name
  bases__ZN3ccc6EE14x2E, 1,
  &(vtc__ZN3ccc6EE14x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x2E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x2E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x3  : virtual ::ccc::AA14 {
  virtual void  efg(); // _ZN3ccc6EE14x33efgEv
  virtual void  pqr(); // _ZN3ccc6EE14x33pqrEv
  virtual void  abc(); // _ZN3ccc6EE14x33abcEv
  ~EE14x3(); // tgen
  EE14x3(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x3E) C1{ VBC2{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE14x3 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x33efgEv");}
void  ccc::EE14x3 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x33pqrEv");}
void  ccc::EE14x3 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x33abcEv");}
ccc::EE14x3 ::~EE14x3(){ note_dtor("_ZN3ccc6EE14x3E", this);} // tgen
ccc::EE14x3 ::EE14x3(){ note_ctor("_ZN3ccc6EE14x3E", this);} // tgen
}
static void Test__ZN3ccc6EE14x3E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x3E, buf);
    ::ccc::EE14x3 *dp, &lv = *(dp=new (buf) ::ccc::EE14x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x3E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x3E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x3E);
    dp->::ccc::EE14x3::~EE14x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x3E(Test__ZN3ccc6EE14x3E, "_ZN3ccc6EE14x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x3C1Ev();
extern void _ZN3ccc6EE14x3D1Ev();
Name_Map name_map__ZN3ccc6EE14x3E[] = {
  NSPAIR(_ZN3ccc6EE14x3C1Ev),
  NSPAIR(_ZN3ccc6EE14x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x3E[];
extern void _ZN3ccc6EE14x33pqrEv();
extern void _ZN3ccc6EE14x33efgEv();
extern void _ZN3ccc6EE14x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x3E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x3E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x3E[] = {
  {&(_ZTVN3ccc6EE14x3E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x3E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x3E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x3E[];
Class_Descriptor cd__ZN3ccc6EE14x3E = {  "_ZN3ccc6EE14x3E", // class name
  bases__ZN3ccc6EE14x3E, 1,
  &(vtc__ZN3ccc6EE14x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x3E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x3E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x4  : virtual ::ccc::AA14 {
  virtual void  pqr(); // _ZN3ccc6EE14x43pqrEv
  virtual void  abc(); // _ZN3ccc6EE14x43abcEv
  virtual void  efg(); // _ZN3ccc6EE14x43efgEv
  ~EE14x4(); // tgen
  EE14x4(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x4E) C1{ VBC2{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE14x4 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x43pqrEv");}
void  ccc::EE14x4 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x43abcEv");}
void  ccc::EE14x4 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x43efgEv");}
ccc::EE14x4 ::~EE14x4(){ note_dtor("_ZN3ccc6EE14x4E", this);} // tgen
ccc::EE14x4 ::EE14x4(){ note_ctor("_ZN3ccc6EE14x4E", this);} // tgen
}
static void Test__ZN3ccc6EE14x4E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x4E, buf);
    ::ccc::EE14x4 *dp, &lv = *(dp=new (buf) ::ccc::EE14x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x4E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x4E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x4E);
    dp->::ccc::EE14x4::~EE14x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x4E(Test__ZN3ccc6EE14x4E, "_ZN3ccc6EE14x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x4C1Ev();
extern void _ZN3ccc6EE14x4D1Ev();
Name_Map name_map__ZN3ccc6EE14x4E[] = {
  NSPAIR(_ZN3ccc6EE14x4C1Ev),
  NSPAIR(_ZN3ccc6EE14x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x4E[];
extern void _ZN3ccc6EE14x43pqrEv();
extern void _ZN3ccc6EE14x43abcEv();
extern void _ZN3ccc6EE14x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x4E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x4E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x4E[] = {
  {&(_ZTVN3ccc6EE14x4E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x4E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x4E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x4E[];
Class_Descriptor cd__ZN3ccc6EE14x4E = {  "_ZN3ccc6EE14x4E", // class name
  bases__ZN3ccc6EE14x4E, 1,
  &(vtc__ZN3ccc6EE14x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x4E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x4E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x5  : virtual ::ccc::AA14 {
  virtual void  pqr(); // _ZN3ccc6EE14x53pqrEv
  virtual void  efg(); // _ZN3ccc6EE14x53efgEv
  virtual void  abc(); // _ZN3ccc6EE14x53abcEv
  ~EE14x5(); // tgen
  EE14x5(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x5E) C1{ VBC2{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE14x5 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x53pqrEv");}
void  ccc::EE14x5 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x53efgEv");}
void  ccc::EE14x5 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x53abcEv");}
ccc::EE14x5 ::~EE14x5(){ note_dtor("_ZN3ccc6EE14x5E", this);} // tgen
ccc::EE14x5 ::EE14x5(){ note_ctor("_ZN3ccc6EE14x5E", this);} // tgen
}
static void Test__ZN3ccc6EE14x5E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x5E, buf);
    ::ccc::EE14x5 *dp, &lv = *(dp=new (buf) ::ccc::EE14x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x5E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x5E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x5E);
    dp->::ccc::EE14x5::~EE14x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x5E(Test__ZN3ccc6EE14x5E, "_ZN3ccc6EE14x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x5C1Ev();
extern void _ZN3ccc6EE14x5D1Ev();
Name_Map name_map__ZN3ccc6EE14x5E[] = {
  NSPAIR(_ZN3ccc6EE14x5C1Ev),
  NSPAIR(_ZN3ccc6EE14x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x5E[];
extern void _ZN3ccc6EE14x53pqrEv();
extern void _ZN3ccc6EE14x53efgEv();
extern void _ZN3ccc6EE14x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x5E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x5E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x5E[] = {
  {&(_ZTVN3ccc6EE14x5E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x5E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x5E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x5E[];
Class_Descriptor cd__ZN3ccc6EE14x5E = {  "_ZN3ccc6EE14x5E", // class name
  bases__ZN3ccc6EE14x5E, 1,
  &(vtc__ZN3ccc6EE14x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x5E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x5E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x6  : virtual ::ccc::AA14 {
  virtual void  abc(); // _ZN3ccc6EE14x63abcEv
  virtual void  efg(); // _ZN3ccc6EE14x63efgEv
  ~EE14x6(); // tgen
  EE14x6(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x6E) C1{ VBC2{ v3} v1 v2}
}
namespace ccc { 
void  ccc::EE14x6 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x63abcEv");}
void  ccc::EE14x6 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x63efgEv");}
ccc::EE14x6 ::~EE14x6(){ note_dtor("_ZN3ccc6EE14x6E", this);} // tgen
ccc::EE14x6 ::EE14x6(){ note_ctor("_ZN3ccc6EE14x6E", this);} // tgen
}
static void Test__ZN3ccc6EE14x6E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x6E, buf);
    ::ccc::EE14x6 *dp, &lv = *(dp=new (buf) ::ccc::EE14x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x6E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x6E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x6E);
    dp->::ccc::EE14x6::~EE14x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x6E(Test__ZN3ccc6EE14x6E, "_ZN3ccc6EE14x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x6C1Ev();
extern void _ZN3ccc6EE14x6D1Ev();
Name_Map name_map__ZN3ccc6EE14x6E[] = {
  NSPAIR(_ZN3ccc6EE14x6C1Ev),
  NSPAIR(_ZN3ccc6EE14x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x6E[];
extern void _ZN3ccc4AA143pqrEv();
extern void _ZN3ccc6EE14x63abcEv();
extern void _ZN3ccc6EE14x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x6E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x6E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x6E[] = {
  {&(_ZTVN3ccc6EE14x6E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x6E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x6E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x6E[];
Class_Descriptor cd__ZN3ccc6EE14x6E = {  "_ZN3ccc6EE14x6E", // class name
  bases__ZN3ccc6EE14x6E, 1,
  &(vtc__ZN3ccc6EE14x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x6E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x6E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x7  : virtual ::ccc::AA14 {
  virtual void  abc(); // _ZN3ccc6EE14x73abcEv
  virtual void  pqr(); // _ZN3ccc6EE14x73pqrEv
  ~EE14x7(); // tgen
  EE14x7(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x7E) C1{ VBC2{ v2} v1 v2}
}
namespace ccc { 
void  ccc::EE14x7 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x73abcEv");}
void  ccc::EE14x7 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x73pqrEv");}
ccc::EE14x7 ::~EE14x7(){ note_dtor("_ZN3ccc6EE14x7E", this);} // tgen
ccc::EE14x7 ::EE14x7(){ note_ctor("_ZN3ccc6EE14x7E", this);} // tgen
}
static void Test__ZN3ccc6EE14x7E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x7E, buf);
    ::ccc::EE14x7 *dp, &lv = *(dp=new (buf) ::ccc::EE14x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x7E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x7E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x7E);
    dp->::ccc::EE14x7::~EE14x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x7E(Test__ZN3ccc6EE14x7E, "_ZN3ccc6EE14x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x7C1Ev();
extern void _ZN3ccc6EE14x7D1Ev();
Name_Map name_map__ZN3ccc6EE14x7E[] = {
  NSPAIR(_ZN3ccc6EE14x7C1Ev),
  NSPAIR(_ZN3ccc6EE14x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x7E[];
extern void _ZN3ccc6EE14x73pqrEv();
extern void _ZN3ccc6EE14x73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x7E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x7E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x7E[] = {
  {&(_ZTVN3ccc6EE14x7E[4]),  4,6},
  {&(_ZTVN3ccc6EE14x7E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x7E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x7E[];
Class_Descriptor cd__ZN3ccc6EE14x7E = {  "_ZN3ccc6EE14x7E", // class name
  bases__ZN3ccc6EE14x7E, 1,
  &(vtc__ZN3ccc6EE14x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x7E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x7E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x8  : virtual ::ccc::AA14 {
  virtual void  efg(); // _ZN3ccc6EE14x83efgEv
  virtual void  abc(); // _ZN3ccc6EE14x83abcEv
  ~EE14x8(); // tgen
  EE14x8(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x8E) C1{ VBC2{ v3} v1 v2}
}
namespace ccc { 
void  ccc::EE14x8 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x83efgEv");}
void  ccc::EE14x8 ::abc(){vfunc_called(this, "_ZN3ccc6EE14x83abcEv");}
ccc::EE14x8 ::~EE14x8(){ note_dtor("_ZN3ccc6EE14x8E", this);} // tgen
ccc::EE14x8 ::EE14x8(){ note_ctor("_ZN3ccc6EE14x8E", this);} // tgen
}
static void Test__ZN3ccc6EE14x8E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x8E, buf);
    ::ccc::EE14x8 *dp, &lv = *(dp=new (buf) ::ccc::EE14x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x8E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x8E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x8E);
    dp->::ccc::EE14x8::~EE14x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x8E(Test__ZN3ccc6EE14x8E, "_ZN3ccc6EE14x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x8C1Ev();
extern void _ZN3ccc6EE14x8D1Ev();
Name_Map name_map__ZN3ccc6EE14x8E[] = {
  NSPAIR(_ZN3ccc6EE14x8C1Ev),
  NSPAIR(_ZN3ccc6EE14x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x8E[];
extern void _ZN3ccc4AA143pqrEv();
extern void _ZN3ccc6EE14x83efgEv();
extern void _ZN3ccc6EE14x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x8E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x8E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x8E[] = {
  {&(_ZTVN3ccc6EE14x8E[4]),  4,7},
  {&(_ZTVN3ccc6EE14x8E[4]),  4,7},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x8E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x8E[];
Class_Descriptor cd__ZN3ccc6EE14x8E = {  "_ZN3ccc6EE14x8E", // class name
  bases__ZN3ccc6EE14x8E, 1,
  &(vtc__ZN3ccc6EE14x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x8E),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x8E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x9  : virtual ::ccc::AA14 {
  virtual void  efg(); // _ZN3ccc6EE14x93efgEv
  virtual void  pqr(); // _ZN3ccc6EE14x93pqrEv
  ~EE14x9(); // tgen
  EE14x9(); // tgen
};
//SIG(-1 _ZN3ccc6EE14x9E) C1{ VBC2{ v2} v1 v2}
}
namespace ccc { 
void  ccc::EE14x9 ::efg(){vfunc_called(this, "_ZN3ccc6EE14x93efgEv");}
void  ccc::EE14x9 ::pqr(){vfunc_called(this, "_ZN3ccc6EE14x93pqrEv");}
ccc::EE14x9 ::~EE14x9(){ note_dtor("_ZN3ccc6EE14x9E", this);} // tgen
ccc::EE14x9 ::EE14x9(){ note_ctor("_ZN3ccc6EE14x9E", this);} // tgen
}
static void Test__ZN3ccc6EE14x9E()
{
  extern Class_Descriptor cd__ZN3ccc6EE14x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE14x9E, buf);
    ::ccc::EE14x9 *dp, &lv = *(dp=new (buf) ::ccc::EE14x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE14x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE14x9E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc6EE14x9E");
    test_class_info(&lv, &cd__ZN3ccc6EE14x9E);
    dp->::ccc::EE14x9::~EE14x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE14x9E(Test__ZN3ccc6EE14x9E, "_ZN3ccc6EE14x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE14x9C1Ev();
extern void _ZN3ccc6EE14x9D1Ev();
Name_Map name_map__ZN3ccc6EE14x9E[] = {
  NSPAIR(_ZN3ccc6EE14x9C1Ev),
  NSPAIR(_ZN3ccc6EE14x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc6EE14x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE14x9E[];
extern void _ZN3ccc6EE14x93pqrEv();
extern void _ZN3ccc6EE14x93efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE14x9E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE14x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE14x93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE14x93efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE14x9E[];
static  VTT_ENTRY vtt__ZN3ccc6EE14x9E[] = {
  {&(_ZTVN3ccc6EE14x9E[4]),  4,6},
  {&(_ZTVN3ccc6EE14x9E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE14x9E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE14x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE14x9E[];
Class_Descriptor cd__ZN3ccc6EE14x9E = {  "_ZN3ccc6EE14x9E", // class name
  bases__ZN3ccc6EE14x9E, 1,
  &(vtc__ZN3ccc6EE14x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE14x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE14x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE14x9E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE14x9E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x10  : virtual ::ccc::AA14 {
  virtual void  pqr(); // _ZN3ccc7EE14x103pqrEv
  virtual void  abc(); // _ZN3ccc7EE14x103abcEv
  ~EE14x10(); // tgen
  EE14x10(); // tgen
};
//SIG(-1 _ZN3ccc7EE14x10E) C1{ VBC2{ v1} v1 v2}
}
namespace ccc { 
void  ccc::EE14x10 ::pqr(){vfunc_called(this, "_ZN3ccc7EE14x103pqrEv");}
void  ccc::EE14x10 ::abc(){vfunc_called(this, "_ZN3ccc7EE14x103abcEv");}
ccc::EE14x10 ::~EE14x10(){ note_dtor("_ZN3ccc7EE14x10E", this);} // tgen
ccc::EE14x10 ::EE14x10(){ note_ctor("_ZN3ccc7EE14x10E", this);} // tgen
}
static void Test__ZN3ccc7EE14x10E()
{
  extern Class_Descriptor cd__ZN3ccc7EE14x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE14x10E, buf);
    ::ccc::EE14x10 *dp, &lv = *(dp=new (buf) ::ccc::EE14x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE14x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE14x10E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc7EE14x10E");
    test_class_info(&lv, &cd__ZN3ccc7EE14x10E);
    dp->::ccc::EE14x10::~EE14x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE14x10E(Test__ZN3ccc7EE14x10E, "_ZN3ccc7EE14x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE14x10C1Ev();
extern void _ZN3ccc7EE14x10D1Ev();
Name_Map name_map__ZN3ccc7EE14x10E[] = {
  NSPAIR(_ZN3ccc7EE14x10C1Ev),
  NSPAIR(_ZN3ccc7EE14x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc7EE14x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE14x10E[];
extern void _ZN3ccc7EE14x103pqrEv();
extern void _ZN3ccc7EE14x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE14x10E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE14x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE14x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE14x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE14x10E[];
static  VTT_ENTRY vtt__ZN3ccc7EE14x10E[] = {
  {&(_ZTVN3ccc7EE14x10E[4]),  4,6},
  {&(_ZTVN3ccc7EE14x10E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE14x10E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE14x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE14x10E[];
Class_Descriptor cd__ZN3ccc7EE14x10E = {  "_ZN3ccc7EE14x10E", // class name
  bases__ZN3ccc7EE14x10E, 1,
  &(vtc__ZN3ccc7EE14x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE14x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE14x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE14x10E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE14x10E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x11  : virtual ::ccc::AA14 {
  virtual void  pqr(); // _ZN3ccc7EE14x113pqrEv
  virtual void  efg(); // _ZN3ccc7EE14x113efgEv
  ~EE14x11(); // tgen
  EE14x11(); // tgen
};
//SIG(-1 _ZN3ccc7EE14x11E) C1{ VBC2{ v1} v1 v2}
}
namespace ccc { 
void  ccc::EE14x11 ::pqr(){vfunc_called(this, "_ZN3ccc7EE14x113pqrEv");}
void  ccc::EE14x11 ::efg(){vfunc_called(this, "_ZN3ccc7EE14x113efgEv");}
ccc::EE14x11 ::~EE14x11(){ note_dtor("_ZN3ccc7EE14x11E", this);} // tgen
ccc::EE14x11 ::EE14x11(){ note_ctor("_ZN3ccc7EE14x11E", this);} // tgen
}
static void Test__ZN3ccc7EE14x11E()
{
  extern Class_Descriptor cd__ZN3ccc7EE14x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE14x11E, buf);
    ::ccc::EE14x11 *dp, &lv = *(dp=new (buf) ::ccc::EE14x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE14x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE14x11E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc7EE14x11E");
    test_class_info(&lv, &cd__ZN3ccc7EE14x11E);
    dp->::ccc::EE14x11::~EE14x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE14x11E(Test__ZN3ccc7EE14x11E, "_ZN3ccc7EE14x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE14x11C1Ev();
extern void _ZN3ccc7EE14x11D1Ev();
Name_Map name_map__ZN3ccc7EE14x11E[] = {
  NSPAIR(_ZN3ccc7EE14x11C1Ev),
  NSPAIR(_ZN3ccc7EE14x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc7EE14x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE14x11E[];
extern void _ZN3ccc7EE14x113pqrEv();
extern void _ZN3ccc7EE14x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE14x11E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE14x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE14x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE14x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE14x11E[];
static  VTT_ENTRY vtt__ZN3ccc7EE14x11E[] = {
  {&(_ZTVN3ccc7EE14x11E[4]),  4,6},
  {&(_ZTVN3ccc7EE14x11E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE14x11E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE14x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE14x11E[];
Class_Descriptor cd__ZN3ccc7EE14x11E = {  "_ZN3ccc7EE14x11E", // class name
  bases__ZN3ccc7EE14x11E, 1,
  &(vtc__ZN3ccc7EE14x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE14x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE14x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE14x11E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE14x11E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x12  : virtual ::ccc::AA14 {
  virtual void  abc(); // _ZN3ccc7EE14x123abcEv
  ~EE14x12(); // tgen
  EE14x12(); // tgen
};
//SIG(-1 _ZN3ccc7EE14x12E) C1{ VBC2{ v2} v1}
}
namespace ccc { 
void  ccc::EE14x12 ::abc(){vfunc_called(this, "_ZN3ccc7EE14x123abcEv");}
ccc::EE14x12 ::~EE14x12(){ note_dtor("_ZN3ccc7EE14x12E", this);} // tgen
ccc::EE14x12 ::EE14x12(){ note_ctor("_ZN3ccc7EE14x12E", this);} // tgen
}
static void Test__ZN3ccc7EE14x12E()
{
  extern Class_Descriptor cd__ZN3ccc7EE14x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE14x12E, buf);
    ::ccc::EE14x12 *dp, &lv = *(dp=new (buf) ::ccc::EE14x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE14x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE14x12E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc7EE14x12E");
    test_class_info(&lv, &cd__ZN3ccc7EE14x12E);
    dp->::ccc::EE14x12::~EE14x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE14x12E(Test__ZN3ccc7EE14x12E, "_ZN3ccc7EE14x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE14x12C1Ev();
extern void _ZN3ccc7EE14x12D1Ev();
Name_Map name_map__ZN3ccc7EE14x12E[] = {
  NSPAIR(_ZN3ccc7EE14x12C1Ev),
  NSPAIR(_ZN3ccc7EE14x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc7EE14x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE14x12E[];
extern void _ZN3ccc4AA143pqrEv();
extern void _ZN3ccc7EE14x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE14x12E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE14x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE14x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE14x12E[];
static  VTT_ENTRY vtt__ZN3ccc7EE14x12E[] = {
  {&(_ZTVN3ccc7EE14x12E[4]),  4,6},
  {&(_ZTVN3ccc7EE14x12E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE14x12E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE14x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE14x12E[];
Class_Descriptor cd__ZN3ccc7EE14x12E = {  "_ZN3ccc7EE14x12E", // class name
  bases__ZN3ccc7EE14x12E, 1,
  &(vtc__ZN3ccc7EE14x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE14x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE14x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE14x12E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE14x12E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x13  : virtual ::ccc::AA14 {
  virtual void  efg(); // _ZN3ccc7EE14x133efgEv
  ~EE14x13(); // tgen
  EE14x13(); // tgen
};
//SIG(-1 _ZN3ccc7EE14x13E) C1{ VBC2{ v2} v1}
}
namespace ccc { 
void  ccc::EE14x13 ::efg(){vfunc_called(this, "_ZN3ccc7EE14x133efgEv");}
ccc::EE14x13 ::~EE14x13(){ note_dtor("_ZN3ccc7EE14x13E", this);} // tgen
ccc::EE14x13 ::EE14x13(){ note_ctor("_ZN3ccc7EE14x13E", this);} // tgen
}
static void Test__ZN3ccc7EE14x13E()
{
  extern Class_Descriptor cd__ZN3ccc7EE14x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE14x13E, buf);
    ::ccc::EE14x13 *dp, &lv = *(dp=new (buf) ::ccc::EE14x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE14x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE14x13E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc7EE14x13E");
    test_class_info(&lv, &cd__ZN3ccc7EE14x13E);
    dp->::ccc::EE14x13::~EE14x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE14x13E(Test__ZN3ccc7EE14x13E, "_ZN3ccc7EE14x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE14x13C1Ev();
extern void _ZN3ccc7EE14x13D1Ev();
Name_Map name_map__ZN3ccc7EE14x13E[] = {
  NSPAIR(_ZN3ccc7EE14x13C1Ev),
  NSPAIR(_ZN3ccc7EE14x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc7EE14x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE14x13E[];
extern void _ZN3ccc4AA143pqrEv();
extern void _ZN3ccc7EE14x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE14x13E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE14x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE14x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE14x13E[];
static  VTT_ENTRY vtt__ZN3ccc7EE14x13E[] = {
  {&(_ZTVN3ccc7EE14x13E[4]),  4,6},
  {&(_ZTVN3ccc7EE14x13E[4]),  4,6},
};
extern VTBL_ENTRY _ZTIN3ccc7EE14x13E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE14x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE14x13E[];
Class_Descriptor cd__ZN3ccc7EE14x13E = {  "_ZN3ccc7EE14x13E", // class name
  bases__ZN3ccc7EE14x13E, 1,
  &(vtc__ZN3ccc7EE14x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE14x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE14x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE14x13E),6, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE14x13E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x14  : virtual ::ccc::AA14 {
  virtual void  pqr(); // _ZN3ccc7EE14x143pqrEv
  ~EE14x14(); // tgen
  EE14x14(); // tgen
};
//SIG(-1 _ZN3ccc7EE14x14E) C1{ VBC2{ v1} v1}
}
namespace ccc { 
void  ccc::EE14x14 ::pqr(){vfunc_called(this, "_ZN3ccc7EE14x143pqrEv");}
ccc::EE14x14 ::~EE14x14(){ note_dtor("_ZN3ccc7EE14x14E", this);} // tgen
ccc::EE14x14 ::EE14x14(){ note_ctor("_ZN3ccc7EE14x14E", this);} // tgen
}
static void Test__ZN3ccc7EE14x14E()
{
  extern Class_Descriptor cd__ZN3ccc7EE14x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE14x14E, buf);
    ::ccc::EE14x14 *dp, &lv = *(dp=new (buf) ::ccc::EE14x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE14x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE14x14E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc7EE14x14E");
    test_class_info(&lv, &cd__ZN3ccc7EE14x14E);
    dp->::ccc::EE14x14::~EE14x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE14x14E(Test__ZN3ccc7EE14x14E, "_ZN3ccc7EE14x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE14x14C1Ev();
extern void _ZN3ccc7EE14x14D1Ev();
Name_Map name_map__ZN3ccc7EE14x14E[] = {
  NSPAIR(_ZN3ccc7EE14x14C1Ev),
  NSPAIR(_ZN3ccc7EE14x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc7EE14x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE14x14E[];
extern void _ZN3ccc7EE14x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE14x14E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE14x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE14x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE14x14E[];
static  VTT_ENTRY vtt__ZN3ccc7EE14x14E[] = {
  {&(_ZTVN3ccc7EE14x14E[4]),  4,5},
  {&(_ZTVN3ccc7EE14x14E[4]),  4,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE14x14E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE14x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE14x14E[];
Class_Descriptor cd__ZN3ccc7EE14x14E = {  "_ZN3ccc7EE14x14E", // class name
  bases__ZN3ccc7EE14x14E, 1,
  &(vtc__ZN3ccc7EE14x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE14x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE14x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE14x14E),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE14x14E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE14x15  : virtual ::ccc::AA14 {
  ~EE14x15(); // tgen
  EE14x15(); // tgen
};
//SIG(-1 _ZN3ccc7EE14x15E) C1{ VBC2{ v1}}
}
namespace ccc { 
ccc::EE14x15 ::~EE14x15(){ note_dtor("_ZN3ccc7EE14x15E", this);} // tgen
ccc::EE14x15 ::EE14x15(){ note_ctor("_ZN3ccc7EE14x15E", this);} // tgen
}
static void Test__ZN3ccc7EE14x15E()
{
  extern Class_Descriptor cd__ZN3ccc7EE14x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE14x15E, buf);
    ::ccc::EE14x15 *dp, &lv = *(dp=new (buf) ::ccc::EE14x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE14x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE14x15E)");
    check_base_class_offset(lv, (::ccc::AA14*), 0, "_ZN3ccc7EE14x15E");
    test_class_info(&lv, &cd__ZN3ccc7EE14x15E);
    dp->::ccc::EE14x15::~EE14x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE14x15E(Test__ZN3ccc7EE14x15E, "_ZN3ccc7EE14x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE14x15C1Ev();
extern void _ZN3ccc7EE14x15D1Ev();
Name_Map name_map__ZN3ccc7EE14x15E[] = {
  NSPAIR(_ZN3ccc7EE14x15C1Ev),
  NSPAIR(_ZN3ccc7EE14x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA14E;
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
static Base_Class bases__ZN3ccc7EE14x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA14E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE14x15E[];
extern void _ZN3ccc4AA143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE14x15E[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE14x15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE14x15E[];
static  VTT_ENTRY vtt__ZN3ccc7EE14x15E[] = {
  {&(_ZTVN3ccc7EE14x15E[4]),  4,5},
  {&(_ZTVN3ccc7EE14x15E[4]),  4,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE14x15E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE14x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE14x15E[];
Class_Descriptor cd__ZN3ccc7EE14x15E = {  "_ZN3ccc7EE14x15E", // class name
  bases__ZN3ccc7EE14x15E, 1,
  &(vtc__ZN3ccc7EE14x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE14x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE14x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE14x15E),5, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE14x15E),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA15  {
};
//SIG(-1 _ZN3ccc4AA15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4AA15E()
{
  {
    init_simple_test("_ZN3ccc4AA15E");
    ::ccc::AA15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4AA15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4AA15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4AA15E(Test__ZN3ccc4AA15E, "_ZN3ccc4AA15E", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
VTBL_ENTRY *P__ZTIN3ccc4AA15E = _ZTIN3ccc4AA15E; 
Class_Descriptor cd__ZN3ccc4AA15E = {  "_ZN3ccc4AA15E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTIN3ccc4AA15E),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB15  {
};
//SIG(1 _ZN3ccc4BB15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4BB15E()
{
  {
    init_simple_test("_ZN3ccc4BB15E");
    ::ccc::BB15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4BB15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4BB15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4BB15E(Test__ZN3ccc4BB15E, "_ZN3ccc4BB15E", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x0  : virtual ::ccc::AA15 {
  virtual void  abc(); // _ZN3ccc6EE15x03abcEv
  virtual void  efg(); // _ZN3ccc6EE15x03efgEv
  virtual void  pqr(); // _ZN3ccc6EE15x03pqrEv
  ~EE15x0(); // tgen
  EE15x0(); // tgen
};
//SIG(1 _ZN3ccc6EE15x0E) C1{ VBC2{} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE15x0 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x03abcEv");}
void  ccc::EE15x0 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x03efgEv");}
void  ccc::EE15x0 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x03pqrEv");}
ccc::EE15x0 ::~EE15x0(){ note_dtor("_ZN3ccc6EE15x0E", this);} // tgen
ccc::EE15x0 ::EE15x0(){ note_ctor("_ZN3ccc6EE15x0E", this);} // tgen
}
static void Test__ZN3ccc6EE15x0E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x0E, buf);
    ::ccc::EE15x0 *dp, &lv = *(dp=new (buf) ::ccc::EE15x0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x0E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x0E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x0E);
    dp->::ccc::EE15x0::~EE15x0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x0E(Test__ZN3ccc6EE15x0E, "_ZN3ccc6EE15x0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x0C1Ev();
extern void _ZN3ccc6EE15x0D1Ev();
Name_Map name_map__ZN3ccc6EE15x0E[] = {
  NSPAIR(_ZN3ccc6EE15x0C1Ev),
  NSPAIR(_ZN3ccc6EE15x0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x0E[];
extern void _ZN3ccc6EE15x03abcEv();
extern void _ZN3ccc6EE15x03efgEv();
extern void _ZN3ccc6EE15x03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x0E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x0E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x03abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x03efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x03pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x0E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x0E[] = {
  {&(_ZTVN3ccc6EE15x0E[3]),  3,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x0E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x0E[];
Class_Descriptor cd__ZN3ccc6EE15x0E = {  "_ZN3ccc6EE15x0E", // class name
  bases__ZN3ccc6EE15x0E, 1,
  &(vtc__ZN3ccc6EE15x0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x0E),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x0E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x1  : virtual ::ccc::AA15 {
  virtual void  abc(); // _ZN3ccc6EE15x13abcEv
  virtual void  pqr(); // _ZN3ccc6EE15x13pqrEv
  virtual void  efg(); // _ZN3ccc6EE15x13efgEv
  ~EE15x1(); // tgen
  EE15x1(); // tgen
};
//SIG(1 _ZN3ccc6EE15x1E) C1{ VBC2{} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE15x1 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x13abcEv");}
void  ccc::EE15x1 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x13pqrEv");}
void  ccc::EE15x1 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x13efgEv");}
ccc::EE15x1 ::~EE15x1(){ note_dtor("_ZN3ccc6EE15x1E", this);} // tgen
ccc::EE15x1 ::EE15x1(){ note_ctor("_ZN3ccc6EE15x1E", this);} // tgen
}
static void Test__ZN3ccc6EE15x1E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x1E, buf);
    ::ccc::EE15x1 *dp, &lv = *(dp=new (buf) ::ccc::EE15x1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x1E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x1E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x1E);
    dp->::ccc::EE15x1::~EE15x1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x1E(Test__ZN3ccc6EE15x1E, "_ZN3ccc6EE15x1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x1C1Ev();
extern void _ZN3ccc6EE15x1D1Ev();
Name_Map name_map__ZN3ccc6EE15x1E[] = {
  NSPAIR(_ZN3ccc6EE15x1C1Ev),
  NSPAIR(_ZN3ccc6EE15x1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x1E[];
extern void _ZN3ccc6EE15x13abcEv();
extern void _ZN3ccc6EE15x13pqrEv();
extern void _ZN3ccc6EE15x13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x1E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x1E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x13abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x13efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x1E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x1E[] = {
  {&(_ZTVN3ccc6EE15x1E[3]),  3,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x1E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x1E[];
Class_Descriptor cd__ZN3ccc6EE15x1E = {  "_ZN3ccc6EE15x1E", // class name
  bases__ZN3ccc6EE15x1E, 1,
  &(vtc__ZN3ccc6EE15x1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x1E),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x1E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x2  : virtual ::ccc::AA15 {
  virtual void  efg(); // _ZN3ccc6EE15x23efgEv
  virtual void  abc(); // _ZN3ccc6EE15x23abcEv
  virtual void  pqr(); // _ZN3ccc6EE15x23pqrEv
  ~EE15x2(); // tgen
  EE15x2(); // tgen
};
//SIG(1 _ZN3ccc6EE15x2E) C1{ VBC2{} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE15x2 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x23efgEv");}
void  ccc::EE15x2 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x23abcEv");}
void  ccc::EE15x2 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x23pqrEv");}
ccc::EE15x2 ::~EE15x2(){ note_dtor("_ZN3ccc6EE15x2E", this);} // tgen
ccc::EE15x2 ::EE15x2(){ note_ctor("_ZN3ccc6EE15x2E", this);} // tgen
}
static void Test__ZN3ccc6EE15x2E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x2E, buf);
    ::ccc::EE15x2 *dp, &lv = *(dp=new (buf) ::ccc::EE15x2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x2E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x2E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x2E);
    dp->::ccc::EE15x2::~EE15x2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x2E(Test__ZN3ccc6EE15x2E, "_ZN3ccc6EE15x2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x2C1Ev();
extern void _ZN3ccc6EE15x2D1Ev();
Name_Map name_map__ZN3ccc6EE15x2E[] = {
  NSPAIR(_ZN3ccc6EE15x2C1Ev),
  NSPAIR(_ZN3ccc6EE15x2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x2E[];
extern void _ZN3ccc6EE15x23efgEv();
extern void _ZN3ccc6EE15x23abcEv();
extern void _ZN3ccc6EE15x23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x2E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x2E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x23efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x23abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x23pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x2E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x2E[] = {
  {&(_ZTVN3ccc6EE15x2E[3]),  3,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x2E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x2E[];
Class_Descriptor cd__ZN3ccc6EE15x2E = {  "_ZN3ccc6EE15x2E", // class name
  bases__ZN3ccc6EE15x2E, 1,
  &(vtc__ZN3ccc6EE15x2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x2E),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x2E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x3  : virtual ::ccc::AA15 {
  virtual void  efg(); // _ZN3ccc6EE15x33efgEv
  virtual void  pqr(); // _ZN3ccc6EE15x33pqrEv
  virtual void  abc(); // _ZN3ccc6EE15x33abcEv
  ~EE15x3(); // tgen
  EE15x3(); // tgen
};
//SIG(1 _ZN3ccc6EE15x3E) C1{ VBC2{} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE15x3 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x33efgEv");}
void  ccc::EE15x3 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x33pqrEv");}
void  ccc::EE15x3 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x33abcEv");}
ccc::EE15x3 ::~EE15x3(){ note_dtor("_ZN3ccc6EE15x3E", this);} // tgen
ccc::EE15x3 ::EE15x3(){ note_ctor("_ZN3ccc6EE15x3E", this);} // tgen
}
static void Test__ZN3ccc6EE15x3E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x3E, buf);
    ::ccc::EE15x3 *dp, &lv = *(dp=new (buf) ::ccc::EE15x3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x3E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x3E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x3E);
    dp->::ccc::EE15x3::~EE15x3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x3E(Test__ZN3ccc6EE15x3E, "_ZN3ccc6EE15x3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x3C1Ev();
extern void _ZN3ccc6EE15x3D1Ev();
Name_Map name_map__ZN3ccc6EE15x3E[] = {
  NSPAIR(_ZN3ccc6EE15x3C1Ev),
  NSPAIR(_ZN3ccc6EE15x3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x3E[];
extern void _ZN3ccc6EE15x33efgEv();
extern void _ZN3ccc6EE15x33pqrEv();
extern void _ZN3ccc6EE15x33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x3E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x3E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x33efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x3E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x3E[] = {
  {&(_ZTVN3ccc6EE15x3E[3]),  3,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x3E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x3E[];
Class_Descriptor cd__ZN3ccc6EE15x3E = {  "_ZN3ccc6EE15x3E", // class name
  bases__ZN3ccc6EE15x3E, 1,
  &(vtc__ZN3ccc6EE15x3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x3E),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x3E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x4  : virtual ::ccc::AA15 {
  virtual void  pqr(); // _ZN3ccc6EE15x43pqrEv
  virtual void  abc(); // _ZN3ccc6EE15x43abcEv
  virtual void  efg(); // _ZN3ccc6EE15x43efgEv
  ~EE15x4(); // tgen
  EE15x4(); // tgen
};
//SIG(1 _ZN3ccc6EE15x4E) C1{ VBC2{} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE15x4 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x43pqrEv");}
void  ccc::EE15x4 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x43abcEv");}
void  ccc::EE15x4 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x43efgEv");}
ccc::EE15x4 ::~EE15x4(){ note_dtor("_ZN3ccc6EE15x4E", this);} // tgen
ccc::EE15x4 ::EE15x4(){ note_ctor("_ZN3ccc6EE15x4E", this);} // tgen
}
static void Test__ZN3ccc6EE15x4E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x4E, buf);
    ::ccc::EE15x4 *dp, &lv = *(dp=new (buf) ::ccc::EE15x4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x4E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x4E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x4E);
    dp->::ccc::EE15x4::~EE15x4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x4E(Test__ZN3ccc6EE15x4E, "_ZN3ccc6EE15x4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x4C1Ev();
extern void _ZN3ccc6EE15x4D1Ev();
Name_Map name_map__ZN3ccc6EE15x4E[] = {
  NSPAIR(_ZN3ccc6EE15x4C1Ev),
  NSPAIR(_ZN3ccc6EE15x4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x4E[];
extern void _ZN3ccc6EE15x43pqrEv();
extern void _ZN3ccc6EE15x43abcEv();
extern void _ZN3ccc6EE15x43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x4E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x4E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x43abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x4E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x4E[] = {
  {&(_ZTVN3ccc6EE15x4E[3]),  3,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x4E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x4E[];
Class_Descriptor cd__ZN3ccc6EE15x4E = {  "_ZN3ccc6EE15x4E", // class name
  bases__ZN3ccc6EE15x4E, 1,
  &(vtc__ZN3ccc6EE15x4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x4E),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x4E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x5  : virtual ::ccc::AA15 {
  virtual void  pqr(); // _ZN3ccc6EE15x53pqrEv
  virtual void  efg(); // _ZN3ccc6EE15x53efgEv
  virtual void  abc(); // _ZN3ccc6EE15x53abcEv
  ~EE15x5(); // tgen
  EE15x5(); // tgen
};
//SIG(1 _ZN3ccc6EE15x5E) C1{ VBC2{} v1 v2 v3}
}
namespace ccc { 
void  ccc::EE15x5 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x53pqrEv");}
void  ccc::EE15x5 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x53efgEv");}
void  ccc::EE15x5 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x53abcEv");}
ccc::EE15x5 ::~EE15x5(){ note_dtor("_ZN3ccc6EE15x5E", this);} // tgen
ccc::EE15x5 ::EE15x5(){ note_ctor("_ZN3ccc6EE15x5E", this);} // tgen
}
static void Test__ZN3ccc6EE15x5E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x5E, buf);
    ::ccc::EE15x5 *dp, &lv = *(dp=new (buf) ::ccc::EE15x5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x5E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x5E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x5E);
    dp->::ccc::EE15x5::~EE15x5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x5E(Test__ZN3ccc6EE15x5E, "_ZN3ccc6EE15x5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x5C1Ev();
extern void _ZN3ccc6EE15x5D1Ev();
Name_Map name_map__ZN3ccc6EE15x5E[] = {
  NSPAIR(_ZN3ccc6EE15x5C1Ev),
  NSPAIR(_ZN3ccc6EE15x5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x5E[];
extern void _ZN3ccc6EE15x53pqrEv();
extern void _ZN3ccc6EE15x53efgEv();
extern void _ZN3ccc6EE15x53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x5E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x5E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x53efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x5E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x5E[] = {
  {&(_ZTVN3ccc6EE15x5E[3]),  3,6},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x5E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x5E[];
Class_Descriptor cd__ZN3ccc6EE15x5E = {  "_ZN3ccc6EE15x5E", // class name
  bases__ZN3ccc6EE15x5E, 1,
  &(vtc__ZN3ccc6EE15x5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x5E),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x5E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x6  : virtual ::ccc::AA15 {
  virtual void  abc(); // _ZN3ccc6EE15x63abcEv
  virtual void  efg(); // _ZN3ccc6EE15x63efgEv
  ~EE15x6(); // tgen
  EE15x6(); // tgen
};
//SIG(1 _ZN3ccc6EE15x6E) C1{ VBC2{} v1 v2}
}
namespace ccc { 
void  ccc::EE15x6 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x63abcEv");}
void  ccc::EE15x6 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x63efgEv");}
ccc::EE15x6 ::~EE15x6(){ note_dtor("_ZN3ccc6EE15x6E", this);} // tgen
ccc::EE15x6 ::EE15x6(){ note_ctor("_ZN3ccc6EE15x6E", this);} // tgen
}
static void Test__ZN3ccc6EE15x6E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x6E, buf);
    ::ccc::EE15x6 *dp, &lv = *(dp=new (buf) ::ccc::EE15x6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x6E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x6E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x6E);
    dp->::ccc::EE15x6::~EE15x6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x6E(Test__ZN3ccc6EE15x6E, "_ZN3ccc6EE15x6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x6C1Ev();
extern void _ZN3ccc6EE15x6D1Ev();
Name_Map name_map__ZN3ccc6EE15x6E[] = {
  NSPAIR(_ZN3ccc6EE15x6C1Ev),
  NSPAIR(_ZN3ccc6EE15x6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x6E[];
extern void _ZN3ccc6EE15x63abcEv();
extern void _ZN3ccc6EE15x63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x6E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x6E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x63abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x6E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x6E[] = {
  {&(_ZTVN3ccc6EE15x6E[3]),  3,5},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x6E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x6E[];
Class_Descriptor cd__ZN3ccc6EE15x6E = {  "_ZN3ccc6EE15x6E", // class name
  bases__ZN3ccc6EE15x6E, 1,
  &(vtc__ZN3ccc6EE15x6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x6E),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x6E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x7  : virtual ::ccc::AA15 {
  virtual void  abc(); // _ZN3ccc6EE15x73abcEv
  virtual void  pqr(); // _ZN3ccc6EE15x73pqrEv
  ~EE15x7(); // tgen
  EE15x7(); // tgen
};
//SIG(1 _ZN3ccc6EE15x7E) C1{ VBC2{} v1 v2}
}
namespace ccc { 
void  ccc::EE15x7 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x73abcEv");}
void  ccc::EE15x7 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x73pqrEv");}
ccc::EE15x7 ::~EE15x7(){ note_dtor("_ZN3ccc6EE15x7E", this);} // tgen
ccc::EE15x7 ::EE15x7(){ note_ctor("_ZN3ccc6EE15x7E", this);} // tgen
}
static void Test__ZN3ccc6EE15x7E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x7E, buf);
    ::ccc::EE15x7 *dp, &lv = *(dp=new (buf) ::ccc::EE15x7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x7E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x7E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x7E);
    dp->::ccc::EE15x7::~EE15x7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x7E(Test__ZN3ccc6EE15x7E, "_ZN3ccc6EE15x7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x7C1Ev();
extern void _ZN3ccc6EE15x7D1Ev();
Name_Map name_map__ZN3ccc6EE15x7E[] = {
  NSPAIR(_ZN3ccc6EE15x7C1Ev),
  NSPAIR(_ZN3ccc6EE15x7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x7E[];
extern void _ZN3ccc6EE15x73abcEv();
extern void _ZN3ccc6EE15x73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x7E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x7E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x73abcEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x7E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x7E[] = {
  {&(_ZTVN3ccc6EE15x7E[3]),  3,5},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x7E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x7E[];
Class_Descriptor cd__ZN3ccc6EE15x7E = {  "_ZN3ccc6EE15x7E", // class name
  bases__ZN3ccc6EE15x7E, 1,
  &(vtc__ZN3ccc6EE15x7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x7E),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x7E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x8  : virtual ::ccc::AA15 {
  virtual void  efg(); // _ZN3ccc6EE15x83efgEv
  virtual void  abc(); // _ZN3ccc6EE15x83abcEv
  ~EE15x8(); // tgen
  EE15x8(); // tgen
};
//SIG(1 _ZN3ccc6EE15x8E) C1{ VBC2{} v1 v2}
}
namespace ccc { 
void  ccc::EE15x8 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x83efgEv");}
void  ccc::EE15x8 ::abc(){vfunc_called(this, "_ZN3ccc6EE15x83abcEv");}
ccc::EE15x8 ::~EE15x8(){ note_dtor("_ZN3ccc6EE15x8E", this);} // tgen
ccc::EE15x8 ::EE15x8(){ note_ctor("_ZN3ccc6EE15x8E", this);} // tgen
}
static void Test__ZN3ccc6EE15x8E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x8E, buf);
    ::ccc::EE15x8 *dp, &lv = *(dp=new (buf) ::ccc::EE15x8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x8E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x8E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x8E);
    dp->::ccc::EE15x8::~EE15x8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x8E(Test__ZN3ccc6EE15x8E, "_ZN3ccc6EE15x8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x8C1Ev();
extern void _ZN3ccc6EE15x8D1Ev();
Name_Map name_map__ZN3ccc6EE15x8E[] = {
  NSPAIR(_ZN3ccc6EE15x8C1Ev),
  NSPAIR(_ZN3ccc6EE15x8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x8E[];
extern void _ZN3ccc6EE15x83efgEv();
extern void _ZN3ccc6EE15x83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x8E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x8E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x83efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x8E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x8E[] = {
  {&(_ZTVN3ccc6EE15x8E[3]),  3,5},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x8E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x8E[];
Class_Descriptor cd__ZN3ccc6EE15x8E = {  "_ZN3ccc6EE15x8E", // class name
  bases__ZN3ccc6EE15x8E, 1,
  &(vtc__ZN3ccc6EE15x8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x8E),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x8E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x9  : virtual ::ccc::AA15 {
  virtual void  efg(); // _ZN3ccc6EE15x93efgEv
  virtual void  pqr(); // _ZN3ccc6EE15x93pqrEv
  ~EE15x9(); // tgen
  EE15x9(); // tgen
};
//SIG(1 _ZN3ccc6EE15x9E) C1{ VBC2{} v1 v2}
}
namespace ccc { 
void  ccc::EE15x9 ::efg(){vfunc_called(this, "_ZN3ccc6EE15x93efgEv");}
void  ccc::EE15x9 ::pqr(){vfunc_called(this, "_ZN3ccc6EE15x93pqrEv");}
ccc::EE15x9 ::~EE15x9(){ note_dtor("_ZN3ccc6EE15x9E", this);} // tgen
ccc::EE15x9 ::EE15x9(){ note_ctor("_ZN3ccc6EE15x9E", this);} // tgen
}
static void Test__ZN3ccc6EE15x9E()
{
  extern Class_Descriptor cd__ZN3ccc6EE15x9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc6EE15x9E, buf);
    ::ccc::EE15x9 *dp, &lv = *(dp=new (buf) ::ccc::EE15x9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc6EE15x9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc6EE15x9E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc6EE15x9E");
    test_class_info(&lv, &cd__ZN3ccc6EE15x9E);
    dp->::ccc::EE15x9::~EE15x9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc6EE15x9E(Test__ZN3ccc6EE15x9E, "_ZN3ccc6EE15x9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc6EE15x9C1Ev();
extern void _ZN3ccc6EE15x9D1Ev();
Name_Map name_map__ZN3ccc6EE15x9E[] = {
  NSPAIR(_ZN3ccc6EE15x9C1Ev),
  NSPAIR(_ZN3ccc6EE15x9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc6EE15x9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc6EE15x9E[];
extern void _ZN3ccc6EE15x93efgEv();
extern void _ZN3ccc6EE15x93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc6EE15x9E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc6EE15x9E[0]),
  (VTBL_ENTRY)&_ZN3ccc6EE15x93efgEv,
  (VTBL_ENTRY)&_ZN3ccc6EE15x93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc6EE15x9E[];
static  VTT_ENTRY vtt__ZN3ccc6EE15x9E[] = {
  {&(_ZTVN3ccc6EE15x9E[3]),  3,5},
};
extern VTBL_ENTRY _ZTIN3ccc6EE15x9E[];
extern  VTBL_ENTRY _ZTVN3ccc6EE15x9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc6EE15x9E[];
Class_Descriptor cd__ZN3ccc6EE15x9E = {  "_ZN3ccc6EE15x9E", // class name
  bases__ZN3ccc6EE15x9E, 1,
  &(vtc__ZN3ccc6EE15x9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc6EE15x9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc6EE15x9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc6EE15x9E),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc6EE15x9E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x10  : virtual ::ccc::AA15 {
  virtual void  pqr(); // _ZN3ccc7EE15x103pqrEv
  virtual void  abc(); // _ZN3ccc7EE15x103abcEv
  ~EE15x10(); // tgen
  EE15x10(); // tgen
};
//SIG(1 _ZN3ccc7EE15x10E) C1{ VBC2{} v1 v2}
}
namespace ccc { 
void  ccc::EE15x10 ::pqr(){vfunc_called(this, "_ZN3ccc7EE15x103pqrEv");}
void  ccc::EE15x10 ::abc(){vfunc_called(this, "_ZN3ccc7EE15x103abcEv");}
ccc::EE15x10 ::~EE15x10(){ note_dtor("_ZN3ccc7EE15x10E", this);} // tgen
ccc::EE15x10 ::EE15x10(){ note_ctor("_ZN3ccc7EE15x10E", this);} // tgen
}
static void Test__ZN3ccc7EE15x10E()
{
  extern Class_Descriptor cd__ZN3ccc7EE15x10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE15x10E, buf);
    ::ccc::EE15x10 *dp, &lv = *(dp=new (buf) ::ccc::EE15x10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE15x10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE15x10E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc7EE15x10E");
    test_class_info(&lv, &cd__ZN3ccc7EE15x10E);
    dp->::ccc::EE15x10::~EE15x10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE15x10E(Test__ZN3ccc7EE15x10E, "_ZN3ccc7EE15x10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE15x10C1Ev();
extern void _ZN3ccc7EE15x10D1Ev();
Name_Map name_map__ZN3ccc7EE15x10E[] = {
  NSPAIR(_ZN3ccc7EE15x10C1Ev),
  NSPAIR(_ZN3ccc7EE15x10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc7EE15x10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE15x10E[];
extern void _ZN3ccc7EE15x103pqrEv();
extern void _ZN3ccc7EE15x103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE15x10E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE15x10E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE15x103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE15x103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE15x10E[];
static  VTT_ENTRY vtt__ZN3ccc7EE15x10E[] = {
  {&(_ZTVN3ccc7EE15x10E[3]),  3,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE15x10E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE15x10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE15x10E[];
Class_Descriptor cd__ZN3ccc7EE15x10E = {  "_ZN3ccc7EE15x10E", // class name
  bases__ZN3ccc7EE15x10E, 1,
  &(vtc__ZN3ccc7EE15x10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE15x10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE15x10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE15x10E),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE15x10E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x11  : virtual ::ccc::AA15 {
  virtual void  pqr(); // _ZN3ccc7EE15x113pqrEv
  virtual void  efg(); // _ZN3ccc7EE15x113efgEv
  ~EE15x11(); // tgen
  EE15x11(); // tgen
};
//SIG(1 _ZN3ccc7EE15x11E) C1{ VBC2{} v1 v2}
}
namespace ccc { 
void  ccc::EE15x11 ::pqr(){vfunc_called(this, "_ZN3ccc7EE15x113pqrEv");}
void  ccc::EE15x11 ::efg(){vfunc_called(this, "_ZN3ccc7EE15x113efgEv");}
ccc::EE15x11 ::~EE15x11(){ note_dtor("_ZN3ccc7EE15x11E", this);} // tgen
ccc::EE15x11 ::EE15x11(){ note_ctor("_ZN3ccc7EE15x11E", this);} // tgen
}
static void Test__ZN3ccc7EE15x11E()
{
  extern Class_Descriptor cd__ZN3ccc7EE15x11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE15x11E, buf);
    ::ccc::EE15x11 *dp, &lv = *(dp=new (buf) ::ccc::EE15x11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE15x11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE15x11E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc7EE15x11E");
    test_class_info(&lv, &cd__ZN3ccc7EE15x11E);
    dp->::ccc::EE15x11::~EE15x11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE15x11E(Test__ZN3ccc7EE15x11E, "_ZN3ccc7EE15x11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE15x11C1Ev();
extern void _ZN3ccc7EE15x11D1Ev();
Name_Map name_map__ZN3ccc7EE15x11E[] = {
  NSPAIR(_ZN3ccc7EE15x11C1Ev),
  NSPAIR(_ZN3ccc7EE15x11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc7EE15x11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE15x11E[];
extern void _ZN3ccc7EE15x113pqrEv();
extern void _ZN3ccc7EE15x113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE15x11E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE15x11E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE15x113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7EE15x113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE15x11E[];
static  VTT_ENTRY vtt__ZN3ccc7EE15x11E[] = {
  {&(_ZTVN3ccc7EE15x11E[3]),  3,5},
};
extern VTBL_ENTRY _ZTIN3ccc7EE15x11E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE15x11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE15x11E[];
Class_Descriptor cd__ZN3ccc7EE15x11E = {  "_ZN3ccc7EE15x11E", // class name
  bases__ZN3ccc7EE15x11E, 1,
  &(vtc__ZN3ccc7EE15x11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE15x11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE15x11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE15x11E),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE15x11E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x12  : virtual ::ccc::AA15 {
  virtual void  abc(); // _ZN3ccc7EE15x123abcEv
  ~EE15x12(); // tgen
  EE15x12(); // tgen
};
//SIG(1 _ZN3ccc7EE15x12E) C1{ VBC2{} v1}
}
namespace ccc { 
void  ccc::EE15x12 ::abc(){vfunc_called(this, "_ZN3ccc7EE15x123abcEv");}
ccc::EE15x12 ::~EE15x12(){ note_dtor("_ZN3ccc7EE15x12E", this);} // tgen
ccc::EE15x12 ::EE15x12(){ note_ctor("_ZN3ccc7EE15x12E", this);} // tgen
}
static void Test__ZN3ccc7EE15x12E()
{
  extern Class_Descriptor cd__ZN3ccc7EE15x12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE15x12E, buf);
    ::ccc::EE15x12 *dp, &lv = *(dp=new (buf) ::ccc::EE15x12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE15x12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE15x12E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc7EE15x12E");
    test_class_info(&lv, &cd__ZN3ccc7EE15x12E);
    dp->::ccc::EE15x12::~EE15x12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE15x12E(Test__ZN3ccc7EE15x12E, "_ZN3ccc7EE15x12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE15x12C1Ev();
extern void _ZN3ccc7EE15x12D1Ev();
Name_Map name_map__ZN3ccc7EE15x12E[] = {
  NSPAIR(_ZN3ccc7EE15x12C1Ev),
  NSPAIR(_ZN3ccc7EE15x12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc7EE15x12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE15x12E[];
extern void _ZN3ccc7EE15x123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE15x12E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE15x12E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE15x123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE15x12E[];
static  VTT_ENTRY vtt__ZN3ccc7EE15x12E[] = {
  {&(_ZTVN3ccc7EE15x12E[3]),  3,4},
};
extern VTBL_ENTRY _ZTIN3ccc7EE15x12E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE15x12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE15x12E[];
Class_Descriptor cd__ZN3ccc7EE15x12E = {  "_ZN3ccc7EE15x12E", // class name
  bases__ZN3ccc7EE15x12E, 1,
  &(vtc__ZN3ccc7EE15x12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE15x12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE15x12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE15x12E),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE15x12E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x13  : virtual ::ccc::AA15 {
  virtual void  efg(); // _ZN3ccc7EE15x133efgEv
  ~EE15x13(); // tgen
  EE15x13(); // tgen
};
//SIG(1 _ZN3ccc7EE15x13E) C1{ VBC2{} v1}
}
namespace ccc { 
void  ccc::EE15x13 ::efg(){vfunc_called(this, "_ZN3ccc7EE15x133efgEv");}
ccc::EE15x13 ::~EE15x13(){ note_dtor("_ZN3ccc7EE15x13E", this);} // tgen
ccc::EE15x13 ::EE15x13(){ note_ctor("_ZN3ccc7EE15x13E", this);} // tgen
}
static void Test__ZN3ccc7EE15x13E()
{
  extern Class_Descriptor cd__ZN3ccc7EE15x13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE15x13E, buf);
    ::ccc::EE15x13 *dp, &lv = *(dp=new (buf) ::ccc::EE15x13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE15x13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE15x13E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc7EE15x13E");
    test_class_info(&lv, &cd__ZN3ccc7EE15x13E);
    dp->::ccc::EE15x13::~EE15x13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE15x13E(Test__ZN3ccc7EE15x13E, "_ZN3ccc7EE15x13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE15x13C1Ev();
extern void _ZN3ccc7EE15x13D1Ev();
Name_Map name_map__ZN3ccc7EE15x13E[] = {
  NSPAIR(_ZN3ccc7EE15x13C1Ev),
  NSPAIR(_ZN3ccc7EE15x13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc7EE15x13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE15x13E[];
extern void _ZN3ccc7EE15x133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE15x13E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE15x13E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE15x133efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE15x13E[];
static  VTT_ENTRY vtt__ZN3ccc7EE15x13E[] = {
  {&(_ZTVN3ccc7EE15x13E[3]),  3,4},
};
extern VTBL_ENTRY _ZTIN3ccc7EE15x13E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE15x13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE15x13E[];
Class_Descriptor cd__ZN3ccc7EE15x13E = {  "_ZN3ccc7EE15x13E", // class name
  bases__ZN3ccc7EE15x13E, 1,
  &(vtc__ZN3ccc7EE15x13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE15x13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE15x13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE15x13E),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE15x13E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x14  : virtual ::ccc::AA15 {
  virtual void  pqr(); // _ZN3ccc7EE15x143pqrEv
  ~EE15x14(); // tgen
  EE15x14(); // tgen
};
//SIG(1 _ZN3ccc7EE15x14E) C1{ VBC2{} v1}
}
namespace ccc { 
void  ccc::EE15x14 ::pqr(){vfunc_called(this, "_ZN3ccc7EE15x143pqrEv");}
ccc::EE15x14 ::~EE15x14(){ note_dtor("_ZN3ccc7EE15x14E", this);} // tgen
ccc::EE15x14 ::EE15x14(){ note_ctor("_ZN3ccc7EE15x14E", this);} // tgen
}
static void Test__ZN3ccc7EE15x14E()
{
  extern Class_Descriptor cd__ZN3ccc7EE15x14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE15x14E, buf);
    ::ccc::EE15x14 *dp, &lv = *(dp=new (buf) ::ccc::EE15x14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE15x14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE15x14E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc7EE15x14E");
    test_class_info(&lv, &cd__ZN3ccc7EE15x14E);
    dp->::ccc::EE15x14::~EE15x14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE15x14E(Test__ZN3ccc7EE15x14E, "_ZN3ccc7EE15x14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE15x14C1Ev();
extern void _ZN3ccc7EE15x14D1Ev();
Name_Map name_map__ZN3ccc7EE15x14E[] = {
  NSPAIR(_ZN3ccc7EE15x14C1Ev),
  NSPAIR(_ZN3ccc7EE15x14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc7EE15x14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE15x14E[];
extern void _ZN3ccc7EE15x143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7EE15x14E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE15x14E[0]),
  (VTBL_ENTRY)&_ZN3ccc7EE15x143pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7EE15x14E[];
static  VTT_ENTRY vtt__ZN3ccc7EE15x14E[] = {
  {&(_ZTVN3ccc7EE15x14E[3]),  3,4},
};
extern VTBL_ENTRY _ZTIN3ccc7EE15x14E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE15x14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE15x14E[];
Class_Descriptor cd__ZN3ccc7EE15x14E = {  "_ZN3ccc7EE15x14E", // class name
  bases__ZN3ccc7EE15x14E, 1,
  &(vtc__ZN3ccc7EE15x14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE15x14E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE15x14E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE15x14E),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE15x14E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  EE15x15  : virtual ::ccc::AA15 {
  ~EE15x15(); // tgen
  EE15x15(); // tgen
};
//SIG(1 _ZN3ccc7EE15x15E) C1{ VBC2{}}
}
namespace ccc { 
ccc::EE15x15 ::~EE15x15(){ note_dtor("_ZN3ccc7EE15x15E", this);} // tgen
ccc::EE15x15 ::EE15x15(){ note_ctor("_ZN3ccc7EE15x15E", this);} // tgen
}
static void Test__ZN3ccc7EE15x15E()
{
  extern Class_Descriptor cd__ZN3ccc7EE15x15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7EE15x15E, buf);
    ::ccc::EE15x15 *dp, &lv = *(dp=new (buf) ::ccc::EE15x15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7EE15x15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7EE15x15E)");
    check_base_class_offset(lv, (::ccc::AA15*), 0, "_ZN3ccc7EE15x15E");
    test_class_info(&lv, &cd__ZN3ccc7EE15x15E);
    dp->::ccc::EE15x15::~EE15x15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7EE15x15E(Test__ZN3ccc7EE15x15E, "_ZN3ccc7EE15x15E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7EE15x15C1Ev();
extern void _ZN3ccc7EE15x15D1Ev();
Name_Map name_map__ZN3ccc7EE15x15E[] = {
  NSPAIR(_ZN3ccc7EE15x15C1Ev),
  NSPAIR(_ZN3ccc7EE15x15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA15E;
extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
static Base_Class bases__ZN3ccc7EE15x15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA15E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7EE15x15E[];
static  VTBL_ENTRY vtc__ZN3ccc7EE15x15E[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7EE15x15E[0]),
};
extern VTBL_ENTRY _ZTVN3ccc7EE15x15E[];
static  VTT_ENTRY vtt__ZN3ccc7EE15x15E[] = {
  {&(_ZTVN3ccc7EE15x15E[3]),  3,3},
};
extern VTBL_ENTRY _ZTIN3ccc7EE15x15E[];
extern  VTBL_ENTRY _ZTVN3ccc7EE15x15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7EE15x15E[];
Class_Descriptor cd__ZN3ccc7EE15x15E = {  "_ZN3ccc7EE15x15E", // class name
  bases__ZN3ccc7EE15x15E, 1,
  &(vtc__ZN3ccc7EE15x15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7EE15x15E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7EE15x15E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7EE15x15E),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7EE15x15E),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y0  : virtual ::ccc::EE5x0 {
  virtual void  abc(); // _ZN3ccc7FF5x0y03abcEv
  virtual void  efg(); // _ZN3ccc7FF5x0y03efgEv
  virtual void  pqr(); // _ZN3ccc7FF5x0y03pqrEv
  ~FF5x0y0(); // tgen
  FF5x0y0(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y0E) C1{ VBC2{ VBC3{ v3 v2 v1} v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::FF5x0y0 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y03abcEv");}
void  ccc::FF5x0y0 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y03efgEv");}
void  ccc::FF5x0y0 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y03pqrEv");}
ccc::FF5x0y0 ::~FF5x0y0(){ note_dtor("_ZN3ccc7FF5x0y0E", this);} // tgen
ccc::FF5x0y0 ::FF5x0y0(){ note_ctor("_ZN3ccc7FF5x0y0E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y0E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y0E, buf);
    ::ccc::FF5x0y0 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y0E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y0E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y0E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y0E);
    dp->::ccc::FF5x0y0::~FF5x0y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y0E(Test__ZN3ccc7FF5x0y0E, "_ZN3ccc7FF5x0y0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y0C1Ev();
extern void _ZN3ccc7FF5x0y0D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y0E[] = {
  NSPAIR(_ZN3ccc7FF5x0y0C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y0E[];
extern void _ZN3ccc7FF5x0y03pqrEv();
extern void _ZN3ccc7FF5x0y03efgEv();
extern void _ZN3ccc7FF5x0y03abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y0E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y03abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y0E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y0E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y0E[] = {
  {&(_ZTVN3ccc7FF5x0y0E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y0E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y0E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y0E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y0E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y0E[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y0E = {  "_ZN3ccc7FF5x0y0E", // class name
  bases__ZN3ccc7FF5x0y0E, 2,
  &(vtc__ZN3ccc7FF5x0y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y0E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y0E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y0E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y0E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y1  : virtual ::ccc::EE5x0 {
  virtual void  abc(); // _ZN3ccc7FF5x0y13abcEv
  virtual void  pqr(); // _ZN3ccc7FF5x0y13pqrEv
  virtual void  efg(); // _ZN3ccc7FF5x0y13efgEv
  ~FF5x0y1(); // tgen
  FF5x0y1(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y1E) C1{ VBC2{ VBC3{ v2 v3 v1} v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::FF5x0y1 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y13abcEv");}
void  ccc::FF5x0y1 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y13pqrEv");}
void  ccc::FF5x0y1 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y13efgEv");}
ccc::FF5x0y1 ::~FF5x0y1(){ note_dtor("_ZN3ccc7FF5x0y1E", this);} // tgen
ccc::FF5x0y1 ::FF5x0y1(){ note_ctor("_ZN3ccc7FF5x0y1E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y1E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y1E, buf);
    ::ccc::FF5x0y1 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y1E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y1E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y1E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y1E);
    dp->::ccc::FF5x0y1::~FF5x0y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y1E(Test__ZN3ccc7FF5x0y1E, "_ZN3ccc7FF5x0y1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y1C1Ev();
extern void _ZN3ccc7FF5x0y1D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y1E[] = {
  NSPAIR(_ZN3ccc7FF5x0y1C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y1E[];
extern void _ZN3ccc7FF5x0y13pqrEv();
extern void _ZN3ccc7FF5x0y13efgEv();
extern void _ZN3ccc7FF5x0y13abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y1E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y13abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y1E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y1E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y1E[] = {
  {&(_ZTVN3ccc7FF5x0y1E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y1E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y1E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y1E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y1E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y1E[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y1E = {  "_ZN3ccc7FF5x0y1E", // class name
  bases__ZN3ccc7FF5x0y1E, 2,
  &(vtc__ZN3ccc7FF5x0y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y1E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y1E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y1E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y1E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y2  : virtual ::ccc::EE5x0 {
  virtual void  efg(); // _ZN3ccc7FF5x0y23efgEv
  virtual void  abc(); // _ZN3ccc7FF5x0y23abcEv
  virtual void  pqr(); // _ZN3ccc7FF5x0y23pqrEv
  ~FF5x0y2(); // tgen
  FF5x0y2(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y2E) C1{ VBC2{ VBC3{ v3 v1 v2} v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::FF5x0y2 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y23efgEv");}
void  ccc::FF5x0y2 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y23abcEv");}
void  ccc::FF5x0y2 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y23pqrEv");}
ccc::FF5x0y2 ::~FF5x0y2(){ note_dtor("_ZN3ccc7FF5x0y2E", this);} // tgen
ccc::FF5x0y2 ::FF5x0y2(){ note_ctor("_ZN3ccc7FF5x0y2E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y2E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y2E, buf);
    ::ccc::FF5x0y2 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y2E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y2E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y2E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y2E);
    dp->::ccc::FF5x0y2::~FF5x0y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y2E(Test__ZN3ccc7FF5x0y2E, "_ZN3ccc7FF5x0y2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y2C1Ev();
extern void _ZN3ccc7FF5x0y2D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y2E[] = {
  NSPAIR(_ZN3ccc7FF5x0y2C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y2E[];
extern void _ZN3ccc7FF5x0y23pqrEv();
extern void _ZN3ccc7FF5x0y23efgEv();
extern void _ZN3ccc7FF5x0y23abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y2E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y23abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y2E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y2E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y2E[] = {
  {&(_ZTVN3ccc7FF5x0y2E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y2E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y2E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y2E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y2E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y2E[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y2E = {  "_ZN3ccc7FF5x0y2E", // class name
  bases__ZN3ccc7FF5x0y2E, 2,
  &(vtc__ZN3ccc7FF5x0y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y2E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y2E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y2E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y2E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y3  : virtual ::ccc::EE5x0 {
  virtual void  efg(); // _ZN3ccc7FF5x0y33efgEv
  virtual void  pqr(); // _ZN3ccc7FF5x0y33pqrEv
  virtual void  abc(); // _ZN3ccc7FF5x0y33abcEv
  ~FF5x0y3(); // tgen
  FF5x0y3(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y3E) C1{ VBC2{ VBC3{ v2 v1 v3} v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::FF5x0y3 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y33efgEv");}
void  ccc::FF5x0y3 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y33pqrEv");}
void  ccc::FF5x0y3 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y33abcEv");}
ccc::FF5x0y3 ::~FF5x0y3(){ note_dtor("_ZN3ccc7FF5x0y3E", this);} // tgen
ccc::FF5x0y3 ::FF5x0y3(){ note_ctor("_ZN3ccc7FF5x0y3E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y3E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y3E, buf);
    ::ccc::FF5x0y3 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y3E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y3E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y3E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y3E);
    dp->::ccc::FF5x0y3::~FF5x0y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y3E(Test__ZN3ccc7FF5x0y3E, "_ZN3ccc7FF5x0y3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y3C1Ev();
extern void _ZN3ccc7FF5x0y3D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y3E[] = {
  NSPAIR(_ZN3ccc7FF5x0y3C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y3E[];
extern void _ZN3ccc7FF5x0y33pqrEv();
extern void _ZN3ccc7FF5x0y33efgEv();
extern void _ZN3ccc7FF5x0y33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y3E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y3E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y3E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y3E[] = {
  {&(_ZTVN3ccc7FF5x0y3E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y3E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y3E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y3E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y3E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y3E[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y3E = {  "_ZN3ccc7FF5x0y3E", // class name
  bases__ZN3ccc7FF5x0y3E, 2,
  &(vtc__ZN3ccc7FF5x0y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y3E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y3E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y3E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y3E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y4  : virtual ::ccc::EE5x0 {
  virtual void  pqr(); // _ZN3ccc7FF5x0y43pqrEv
  virtual void  abc(); // _ZN3ccc7FF5x0y43abcEv
  virtual void  efg(); // _ZN3ccc7FF5x0y43efgEv
  ~FF5x0y4(); // tgen
  FF5x0y4(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y4E) C1{ VBC2{ VBC3{ v1 v3 v2} v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::FF5x0y4 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y43pqrEv");}
void  ccc::FF5x0y4 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y43abcEv");}
void  ccc::FF5x0y4 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y43efgEv");}
ccc::FF5x0y4 ::~FF5x0y4(){ note_dtor("_ZN3ccc7FF5x0y4E", this);} // tgen
ccc::FF5x0y4 ::FF5x0y4(){ note_ctor("_ZN3ccc7FF5x0y4E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y4E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y4E, buf);
    ::ccc::FF5x0y4 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y4E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y4E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y4E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y4E);
    dp->::ccc::FF5x0y4::~FF5x0y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y4E(Test__ZN3ccc7FF5x0y4E, "_ZN3ccc7FF5x0y4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y4C1Ev();
extern void _ZN3ccc7FF5x0y4D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y4E[] = {
  NSPAIR(_ZN3ccc7FF5x0y4C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y4E[];
extern void _ZN3ccc7FF5x0y43pqrEv();
extern void _ZN3ccc7FF5x0y43efgEv();
extern void _ZN3ccc7FF5x0y43abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y4E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y43abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y4E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y4E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y4E[] = {
  {&(_ZTVN3ccc7FF5x0y4E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y4E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y4E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y4E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y4E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y4E[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y4E = {  "_ZN3ccc7FF5x0y4E", // class name
  bases__ZN3ccc7FF5x0y4E, 2,
  &(vtc__ZN3ccc7FF5x0y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y4E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y4E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y4E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y4E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y5  : virtual ::ccc::EE5x0 {
  virtual void  pqr(); // _ZN3ccc7FF5x0y53pqrEv
  virtual void  efg(); // _ZN3ccc7FF5x0y53efgEv
  virtual void  abc(); // _ZN3ccc7FF5x0y53abcEv
  ~FF5x0y5(); // tgen
  FF5x0y5(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y5E) C1{ VBC2{ VBC3{ v1 v2 v3} v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::FF5x0y5 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y53pqrEv");}
void  ccc::FF5x0y5 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y53efgEv");}
void  ccc::FF5x0y5 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y53abcEv");}
ccc::FF5x0y5 ::~FF5x0y5(){ note_dtor("_ZN3ccc7FF5x0y5E", this);} // tgen
ccc::FF5x0y5 ::FF5x0y5(){ note_ctor("_ZN3ccc7FF5x0y5E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y5E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y5E, buf);
    ::ccc::FF5x0y5 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y5E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y5E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y5E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y5E);
    dp->::ccc::FF5x0y5::~FF5x0y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y5E(Test__ZN3ccc7FF5x0y5E, "_ZN3ccc7FF5x0y5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y5C1Ev();
extern void _ZN3ccc7FF5x0y5D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y5E[] = {
  NSPAIR(_ZN3ccc7FF5x0y5C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y5E[];
extern void _ZN3ccc7FF5x0y53pqrEv();
extern void _ZN3ccc7FF5x0y53efgEv();
extern void _ZN3ccc7FF5x0y53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y5E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y5E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y5E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y5E[] = {
  {&(_ZTVN3ccc7FF5x0y5E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y5E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y5E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y5E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y5E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y5E[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y5E = {  "_ZN3ccc7FF5x0y5E", // class name
  bases__ZN3ccc7FF5x0y5E, 2,
  &(vtc__ZN3ccc7FF5x0y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y5E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y5E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y5E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y5E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y6  : virtual ::ccc::EE5x0 {
  virtual void  abc(); // _ZN3ccc7FF5x0y63abcEv
  virtual void  efg(); // _ZN3ccc7FF5x0y63efgEv
  ~FF5x0y6(); // tgen
  FF5x0y6(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y6E) C1{ VBC2{ VBC3{ v3 v2 v1} v1 v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::FF5x0y6 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y63abcEv");}
void  ccc::FF5x0y6 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y63efgEv");}
ccc::FF5x0y6 ::~FF5x0y6(){ note_dtor("_ZN3ccc7FF5x0y6E", this);} // tgen
ccc::FF5x0y6 ::FF5x0y6(){ note_ctor("_ZN3ccc7FF5x0y6E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y6E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y6E, buf);
    ::ccc::FF5x0y6 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y6E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y6E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y6E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y6E);
    dp->::ccc::FF5x0y6::~FF5x0y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y6E(Test__ZN3ccc7FF5x0y6E, "_ZN3ccc7FF5x0y6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y6C1Ev();
extern void _ZN3ccc7FF5x0y6D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y6E[] = {
  NSPAIR(_ZN3ccc7FF5x0y6C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y6E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void _ZN3ccc7FF5x0y63efgEv();
extern void _ZN3ccc7FF5x0y63abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y6E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y63abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y6E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y6E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y6E[] = {
  {&(_ZTVN3ccc7FF5x0y6E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y6E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y6E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y6E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y6E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y6E[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y6E = {  "_ZN3ccc7FF5x0y6E", // class name
  bases__ZN3ccc7FF5x0y6E, 2,
  &(vtc__ZN3ccc7FF5x0y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y6E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y6E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y6E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y6E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y7  : virtual ::ccc::EE5x0 {
  virtual void  abc(); // _ZN3ccc7FF5x0y73abcEv
  virtual void  pqr(); // _ZN3ccc7FF5x0y73pqrEv
  ~FF5x0y7(); // tgen
  FF5x0y7(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y7E) C1{ VBC2{ VBC3{ v2 v3 v1} v1 v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::FF5x0y7 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y73abcEv");}
void  ccc::FF5x0y7 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y73pqrEv");}
ccc::FF5x0y7 ::~FF5x0y7(){ note_dtor("_ZN3ccc7FF5x0y7E", this);} // tgen
ccc::FF5x0y7 ::FF5x0y7(){ note_ctor("_ZN3ccc7FF5x0y7E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y7E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y7E, buf);
    ::ccc::FF5x0y7 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y7E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y7E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y7E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y7E);
    dp->::ccc::FF5x0y7::~FF5x0y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y7E(Test__ZN3ccc7FF5x0y7E, "_ZN3ccc7FF5x0y7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y7C1Ev();
extern void _ZN3ccc7FF5x0y7D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y7E[] = {
  NSPAIR(_ZN3ccc7FF5x0y7C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y7E[];
extern void _ZN3ccc7FF5x0y73pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void _ZN3ccc7FF5x0y73abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y7E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y73pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y73abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y7E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y7E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y7E[] = {
  {&(_ZTVN3ccc7FF5x0y7E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y7E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y7E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y7E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y7E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y7E[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y7E = {  "_ZN3ccc7FF5x0y7E", // class name
  bases__ZN3ccc7FF5x0y7E, 2,
  &(vtc__ZN3ccc7FF5x0y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y7E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y7E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y7E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y7E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y8  : virtual ::ccc::EE5x0 {
  virtual void  efg(); // _ZN3ccc7FF5x0y83efgEv
  virtual void  abc(); // _ZN3ccc7FF5x0y83abcEv
  ~FF5x0y8(); // tgen
  FF5x0y8(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y8E) C1{ VBC2{ VBC3{ v3 v1 v2} v2 v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::FF5x0y8 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y83efgEv");}
void  ccc::FF5x0y8 ::abc(){vfunc_called(this, "_ZN3ccc7FF5x0y83abcEv");}
ccc::FF5x0y8 ::~FF5x0y8(){ note_dtor("_ZN3ccc7FF5x0y8E", this);} // tgen
ccc::FF5x0y8 ::FF5x0y8(){ note_ctor("_ZN3ccc7FF5x0y8E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y8E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y8E, buf);
    ::ccc::FF5x0y8 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y8E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y8E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y8E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y8E);
    dp->::ccc::FF5x0y8::~FF5x0y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y8E(Test__ZN3ccc7FF5x0y8E, "_ZN3ccc7FF5x0y8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y8C1Ev();
extern void _ZN3ccc7FF5x0y8D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y8E[] = {
  NSPAIR(_ZN3ccc7FF5x0y8C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y8E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void _ZN3ccc7FF5x0y83efgEv();
extern void _ZN3ccc7FF5x0y83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y8E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y8E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y8E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y8E[] = {
  {&(_ZTVN3ccc7FF5x0y8E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y8E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y8E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y8E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y8E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y8E[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y8E = {  "_ZN3ccc7FF5x0y8E", // class name
  bases__ZN3ccc7FF5x0y8E, 2,
  &(vtc__ZN3ccc7FF5x0y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y8E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y8E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y8E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y8E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y9  : virtual ::ccc::EE5x0 {
  virtual void  efg(); // _ZN3ccc7FF5x0y93efgEv
  virtual void  pqr(); // _ZN3ccc7FF5x0y93pqrEv
  ~FF5x0y9(); // tgen
  FF5x0y9(); // tgen
};
//SIG(1 _ZN3ccc7FF5x0y9E) C1{ VBC2{ VBC3{ v2 v1 v3} v3 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::FF5x0y9 ::efg(){vfunc_called(this, "_ZN3ccc7FF5x0y93efgEv");}
void  ccc::FF5x0y9 ::pqr(){vfunc_called(this, "_ZN3ccc7FF5x0y93pqrEv");}
ccc::FF5x0y9 ::~FF5x0y9(){ note_dtor("_ZN3ccc7FF5x0y9E", this);} // tgen
ccc::FF5x0y9 ::FF5x0y9(){ note_ctor("_ZN3ccc7FF5x0y9E", this);} // tgen
}
static void Test__ZN3ccc7FF5x0y9E()
{
  extern Class_Descriptor cd__ZN3ccc7FF5x0y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc7FF5x0y9E, buf);
    ::ccc::FF5x0y9 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc7FF5x0y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7FF5x0y9E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y9E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc7FF5x0y9E");
    test_class_info(&lv, &cd__ZN3ccc7FF5x0y9E);
    dp->::ccc::FF5x0y9::~FF5x0y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7FF5x0y9E(Test__ZN3ccc7FF5x0y9E, "_ZN3ccc7FF5x0y9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc7FF5x0y9C1Ev();
extern void _ZN3ccc7FF5x0y9D1Ev();
Name_Map name_map__ZN3ccc7FF5x0y9E[] = {
  NSPAIR(_ZN3ccc7FF5x0y9C1Ev),
  NSPAIR(_ZN3ccc7FF5x0y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc7FF5x0y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y9E[];
extern void _ZN3ccc7FF5x0y93pqrEv();
extern void _ZN3ccc7FF5x0y93efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7FF5x0y9E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7FF5x0y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7FF5x0y93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7FF5x0y9E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y9E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc7FF5x0y9E[] = {
  {&(_ZTVN3ccc7FF5x0y9E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y9E[7]),  7,10},
  {&(_ZTVN3ccc7FF5x0y9E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y9E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_7FF5x0y9E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc7FF5x0y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7FF5x0y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7FF5x0y9E[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7FF5x0y9E = {  "_ZN3ccc7FF5x0y9E", // class name
  bases__ZN3ccc7FF5x0y9E, 2,
  &(vtc__ZN3ccc7FF5x0y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7FF5x0y9E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc7FF5x0y9E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7FF5x0y9E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7FF5x0y9E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y10  : virtual ::ccc::EE5x0 {
  virtual void  pqr(); // _ZN3ccc8FF5x0y103pqrEv
  virtual void  abc(); // _ZN3ccc8FF5x0y103abcEv
  ~FF5x0y10(); // tgen
  FF5x0y10(); // tgen
};
//SIG(1 _ZN3ccc8FF5x0y10E) C1{ VBC2{ VBC3{ v1 v3 v2} v2 v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::FF5x0y10 ::pqr(){vfunc_called(this, "_ZN3ccc8FF5x0y103pqrEv");}
void  ccc::FF5x0y10 ::abc(){vfunc_called(this, "_ZN3ccc8FF5x0y103abcEv");}
ccc::FF5x0y10 ::~FF5x0y10(){ note_dtor("_ZN3ccc8FF5x0y10E", this);} // tgen
ccc::FF5x0y10 ::FF5x0y10(){ note_ctor("_ZN3ccc8FF5x0y10E", this);} // tgen
}
static void Test__ZN3ccc8FF5x0y10E()
{
  extern Class_Descriptor cd__ZN3ccc8FF5x0y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc8FF5x0y10E, buf);
    ::ccc::FF5x0y10 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc8FF5x0y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8FF5x0y10E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y10E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y10E");
    test_class_info(&lv, &cd__ZN3ccc8FF5x0y10E);
    dp->::ccc::FF5x0y10::~FF5x0y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8FF5x0y10E(Test__ZN3ccc8FF5x0y10E, "_ZN3ccc8FF5x0y10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc8FF5x0y10C1Ev();
extern void _ZN3ccc8FF5x0y10D1Ev();
Name_Map name_map__ZN3ccc8FF5x0y10E[] = {
  NSPAIR(_ZN3ccc8FF5x0y10C1Ev),
  NSPAIR(_ZN3ccc8FF5x0y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc8FF5x0y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y10E[];
extern void _ZN3ccc8FF5x0y103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void _ZN3ccc8FF5x0y103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8FF5x0y10E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8FF5x0y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8FF5x0y10E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y10E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc8FF5x0y10E[] = {
  {&(_ZTVN3ccc8FF5x0y10E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y10E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y10E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y10E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y10E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8FF5x0y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8FF5x0y10E[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8FF5x0y10E = {  "_ZN3ccc8FF5x0y10E", // class name
  bases__ZN3ccc8FF5x0y10E, 2,
  &(vtc__ZN3ccc8FF5x0y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8FF5x0y10E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc8FF5x0y10E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8FF5x0y10E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8FF5x0y10E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y11  : virtual ::ccc::EE5x0 {
  virtual void  pqr(); // _ZN3ccc8FF5x0y113pqrEv
  virtual void  efg(); // _ZN3ccc8FF5x0y113efgEv
  ~FF5x0y11(); // tgen
  FF5x0y11(); // tgen
};
//SIG(1 _ZN3ccc8FF5x0y11E) C1{ VBC2{ VBC3{ v1 v2 v3} v3 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::FF5x0y11 ::pqr(){vfunc_called(this, "_ZN3ccc8FF5x0y113pqrEv");}
void  ccc::FF5x0y11 ::efg(){vfunc_called(this, "_ZN3ccc8FF5x0y113efgEv");}
ccc::FF5x0y11 ::~FF5x0y11(){ note_dtor("_ZN3ccc8FF5x0y11E", this);} // tgen
ccc::FF5x0y11 ::FF5x0y11(){ note_ctor("_ZN3ccc8FF5x0y11E", this);} // tgen
}
static void Test__ZN3ccc8FF5x0y11E()
{
  extern Class_Descriptor cd__ZN3ccc8FF5x0y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc8FF5x0y11E, buf);
    ::ccc::FF5x0y11 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc8FF5x0y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8FF5x0y11E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y11E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y11E");
    test_class_info(&lv, &cd__ZN3ccc8FF5x0y11E);
    dp->::ccc::FF5x0y11::~FF5x0y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8FF5x0y11E(Test__ZN3ccc8FF5x0y11E, "_ZN3ccc8FF5x0y11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc8FF5x0y11C1Ev();
extern void _ZN3ccc8FF5x0y11D1Ev();
Name_Map name_map__ZN3ccc8FF5x0y11E[] = {
  NSPAIR(_ZN3ccc8FF5x0y11C1Ev),
  NSPAIR(_ZN3ccc8FF5x0y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc8FF5x0y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y11E[];
extern void _ZN3ccc8FF5x0y113pqrEv();
extern void _ZN3ccc8FF5x0y113efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8FF5x0y11E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8FF5x0y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y113efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8FF5x0y11E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y11E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc8FF5x0y11E[] = {
  {&(_ZTVN3ccc8FF5x0y11E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y11E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y11E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y11E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y11E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8FF5x0y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8FF5x0y11E[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8FF5x0y11E = {  "_ZN3ccc8FF5x0y11E", // class name
  bases__ZN3ccc8FF5x0y11E, 2,
  &(vtc__ZN3ccc8FF5x0y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8FF5x0y11E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc8FF5x0y11E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8FF5x0y11E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8FF5x0y11E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y12  : virtual ::ccc::EE5x0 {
  virtual void  abc(); // _ZN3ccc8FF5x0y123abcEv
  ~FF5x0y12(); // tgen
  FF5x0y12(); // tgen
};
//SIG(1 _ZN3ccc8FF5x0y12E) C1{ VBC2{ VBC3{ v3 v2 v1} v1 v2 v3} v1}
}
namespace ccc { 
void  ccc::FF5x0y12 ::abc(){vfunc_called(this, "_ZN3ccc8FF5x0y123abcEv");}
ccc::FF5x0y12 ::~FF5x0y12(){ note_dtor("_ZN3ccc8FF5x0y12E", this);} // tgen
ccc::FF5x0y12 ::FF5x0y12(){ note_ctor("_ZN3ccc8FF5x0y12E", this);} // tgen
}
static void Test__ZN3ccc8FF5x0y12E()
{
  extern Class_Descriptor cd__ZN3ccc8FF5x0y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc8FF5x0y12E, buf);
    ::ccc::FF5x0y12 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc8FF5x0y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8FF5x0y12E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y12E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y12E");
    test_class_info(&lv, &cd__ZN3ccc8FF5x0y12E);
    dp->::ccc::FF5x0y12::~FF5x0y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8FF5x0y12E(Test__ZN3ccc8FF5x0y12E, "_ZN3ccc8FF5x0y12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc8FF5x0y12C1Ev();
extern void _ZN3ccc8FF5x0y12D1Ev();
Name_Map name_map__ZN3ccc8FF5x0y12E[] = {
  NSPAIR(_ZN3ccc8FF5x0y12C1Ev),
  NSPAIR(_ZN3ccc8FF5x0y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc8FF5x0y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y12E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void _ZN3ccc8FF5x0y123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8FF5x0y12E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8FF5x0y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y123abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8FF5x0y12E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y12E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc8FF5x0y12E[] = {
  {&(_ZTVN3ccc8FF5x0y12E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y12E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y12E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y12E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y12E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8FF5x0y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8FF5x0y12E[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8FF5x0y12E = {  "_ZN3ccc8FF5x0y12E", // class name
  bases__ZN3ccc8FF5x0y12E, 2,
  &(vtc__ZN3ccc8FF5x0y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8FF5x0y12E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc8FF5x0y12E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8FF5x0y12E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8FF5x0y12E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y13  : virtual ::ccc::EE5x0 {
  virtual void  efg(); // _ZN3ccc8FF5x0y133efgEv
  ~FF5x0y13(); // tgen
  FF5x0y13(); // tgen
};
//SIG(1 _ZN3ccc8FF5x0y13E) C1{ VBC2{ VBC3{ v3 v1 v2} v2 v1 v3} v1}
}
namespace ccc { 
void  ccc::FF5x0y13 ::efg(){vfunc_called(this, "_ZN3ccc8FF5x0y133efgEv");}
ccc::FF5x0y13 ::~FF5x0y13(){ note_dtor("_ZN3ccc8FF5x0y13E", this);} // tgen
ccc::FF5x0y13 ::FF5x0y13(){ note_ctor("_ZN3ccc8FF5x0y13E", this);} // tgen
}
static void Test__ZN3ccc8FF5x0y13E()
{
  extern Class_Descriptor cd__ZN3ccc8FF5x0y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc8FF5x0y13E, buf);
    ::ccc::FF5x0y13 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc8FF5x0y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8FF5x0y13E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y13E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y13E");
    test_class_info(&lv, &cd__ZN3ccc8FF5x0y13E);
    dp->::ccc::FF5x0y13::~FF5x0y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8FF5x0y13E(Test__ZN3ccc8FF5x0y13E, "_ZN3ccc8FF5x0y13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc8FF5x0y13C1Ev();
extern void _ZN3ccc8FF5x0y13D1Ev();
Name_Map name_map__ZN3ccc8FF5x0y13E[] = {
  NSPAIR(_ZN3ccc8FF5x0y13C1Ev),
  NSPAIR(_ZN3ccc8FF5x0y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc8FF5x0y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y13E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void _ZN3ccc8FF5x0y133efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8FF5x0y13E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8FF5x0y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y133efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8FF5x0y13E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y13E[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc5EE5x0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
static  VTT_ENTRY vtt__ZN3ccc8FF5x0y13E[] = {
  {&(_ZTVN3ccc8FF5x0y13E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y13E[7]),  7,10},
  {&(_ZTVN3ccc8FF5x0y13E[7]),  7,10},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y13E[6]),  6,9},
  {&(_tg__ZTVN3ccc5EE5x0E__NS_8FF5x0y13E[6]),  6,9},
};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8FF5x0y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8FF5x0y13E[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03efgEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03abcEv,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv), // 
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  (VTBL_ENTRY)_ZN3ccc5EE5x03pqrEv,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8FF5x0y13E = {  "_ZN3ccc8FF5x0y13E", // class name
  bases__ZN3ccc8FF5x0y13E, 2,
  &(vtc__ZN3ccc8FF5x0y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8FF5x0y13E[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc8FF5x0y13E),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8FF5x0y13E),10, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8FF5x0y13E),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  FF5x0y14  : virtual ::ccc::EE5x0 {
  virtual void  pqr(); // _ZN3ccc8FF5x0y143pqrEv
  ~FF5x0y14(); // tgen
  FF5x0y14(); // tgen
};
//SIG(1 _ZN3ccc8FF5x0y14E) C1{ VBC2{ VBC3{ v1 v3 v2} v2 v3 v1} v1}
}
namespace ccc { 
void  ccc::FF5x0y14 ::pqr(){vfunc_called(this, "_ZN3ccc8FF5x0y143pqrEv");}
ccc::FF5x0y14 ::~FF5x0y14(){ note_dtor("_ZN3ccc8FF5x0y14E", this);} // tgen
ccc::FF5x0y14 ::FF5x0y14(){ note_ctor("_ZN3ccc8FF5x0y14E", this);} // tgen
}
static void Test__ZN3ccc8FF5x0y14E()
{
  extern Class_Descriptor cd__ZN3ccc8FF5x0y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc8FF5x0y14E, buf);
    ::ccc::FF5x0y14 *dp, &lv = *(dp=new (buf) ::ccc::FF5x0y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc8FF5x0y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8FF5x0y14E)");
    check_base_class_offset(lv, (::ccc::AA5*)(::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y14E");
    check_base_class_offset(lv, (::ccc::EE5x0*), 0, "_ZN3ccc8FF5x0y14E");
    test_class_info(&lv, &cd__ZN3ccc8FF5x0y14E);
    dp->::ccc::FF5x0y14::~FF5x0y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8FF5x0y14E(Test__ZN3ccc8FF5x0y14E, "_ZN3ccc8FF5x0y14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc8FF5x0y14C1Ev();
extern void _ZN3ccc8FF5x0y14D1Ev();
Name_Map name_map__ZN3ccc8FF5x0y14E[] = {
  NSPAIR(_ZN3ccc8FF5x0y14C1Ev),
  NSPAIR(_ZN3ccc8FF5x0y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc5EE5x0E;
extern VTBL_ENTRY _ZTIN3ccc5EE5x0E[];
extern  VTBL_ENTRY _ZTVN3ccc5EE5x0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc5EE5x0E[];
static Base_Class bases__ZN3ccc8FF5x0y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd__ZN3ccc5EE5x0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8FF5x0y14E[];
extern void _ZN3ccc8FF5x0y143pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv)();
extern void _ZN3ccc5EE5x03efgEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv)();
extern void _ZN3ccc5EE5x03abcEv() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8FF5x0y14E[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8FF5x0y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8FF5x0y143pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5EE5x03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc5EE5x03abcEv,_ZTv0_n20_N3ccc5EE5x03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8FF5x0y14E[];
extern void ABISELECT(_ZTv0_n24_N3ccc5EE5x03pqrEv,_ZTv0_n12_N3ccc5EE5x03pqrEv)();
extern void _ZN3ccc5EE5x03pqrEv() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc5EE5x03efgEv,_ZTv0_n16_N3ccc5E