// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace ccc { 
struct  AA0  {
  virtual void  abc(); // _ZN3ccc3AA03abcEv
  virtual void  efg(); // _ZN3ccc3AA03efgEv
  virtual void  pqr(); // _ZN3ccc3AA03pqrEv
  ~AA0(); // tgen
  AA0(); // tgen
};
//SIG(1 _ZN3ccc3AA0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA0 ::abc(){vfunc_called(this, "_ZN3ccc3AA03abcEv");}
void  ccc::AA0 ::efg(){vfunc_called(this, "_ZN3ccc3AA03efgEv");}
void  ccc::AA0 ::pqr(){vfunc_called(this, "_ZN3ccc3AA03pqrEv");}
ccc::AA0 ::~AA0(){ note_dtor("_ZN3ccc3AA0E", this);} // tgen
ccc::AA0 ::AA0(){ note_ctor("_ZN3ccc3AA0E", this);} // tgen
}
static void Test__ZN3ccc3AA0E()
{
  extern Class_Descriptor cd__ZN3ccc3AA0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA0E, buf);
    ::ccc::AA0 *dp, &lv = *(dp=new (buf) ::ccc::AA0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA0E)");
    test_class_info(&lv, &cd__ZN3ccc3AA0E);
    dp->::ccc::AA0::~AA0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA0E(Test__ZN3ccc3AA0E, "_ZN3ccc3AA0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA0C1Ev();
extern void _ZN3ccc3AA0D1Ev();
Name_Map name_map__ZN3ccc3AA0E[] = {
  NSPAIR(_ZN3ccc3AA0C1Ev),
  NSPAIR(_ZN3ccc3AA0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
Class_Descriptor cd__ZN3ccc3AA0E = {  "_ZN3ccc3AA0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB0  {
  virtual void  abc(); // _ZN3ccc3BB03abcEv
  virtual void  efg(); // _ZN3ccc3BB03efgEv
  virtual void  pqr(); // _ZN3ccc3BB03pqrEv
  ~BB0(); // tgen
  BB0(); // tgen
};
//SIG(-1 _ZN3ccc3BB0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB0 ::abc(){vfunc_called(this, "_ZN3ccc3BB03abcEv");}
void  ccc::BB0 ::efg(){vfunc_called(this, "_ZN3ccc3BB03efgEv");}
void  ccc::BB0 ::pqr(){vfunc_called(this, "_ZN3ccc3BB03pqrEv");}
ccc::BB0 ::~BB0(){ note_dtor("_ZN3ccc3BB0E", this);} // tgen
ccc::BB0 ::BB0(){ note_ctor("_ZN3ccc3BB0E", this);} // tgen
}
static void Test__ZN3ccc3BB0E()
{
  extern Class_Descriptor cd__ZN3ccc3BB0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB0E, buf);
    ::ccc::BB0 *dp, &lv = *(dp=new (buf) ::ccc::BB0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB0E)");
    test_class_info(&lv, &cd__ZN3ccc3BB0E);
    dp->::ccc::BB0::~BB0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB0E(Test__ZN3ccc3BB0E, "_ZN3ccc3BB0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB0C1Ev();
extern void _ZN3ccc3BB0D1Ev();
Name_Map name_map__ZN3ccc3BB0E[] = {
  NSPAIR(_ZN3ccc3BB0C1Ev),
  NSPAIR(_ZN3ccc3BB0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern void _ZN3ccc3BB03abcEv();
extern void _ZN3ccc3BB03efgEv();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
Class_Descriptor cd__ZN3ccc3BB0E = {  "_ZN3ccc3BB0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA1  {
  virtual void  abc(); // _ZN3ccc3AA13abcEv
  virtual void  pqr(); // _ZN3ccc3AA13pqrEv
  virtual void  efg(); // _ZN3ccc3AA13efgEv
  ~AA1(); // tgen
  AA1(); // tgen
};
//SIG(1 _ZN3ccc3AA1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA1 ::abc(){vfunc_called(this, "_ZN3ccc3AA13abcEv");}
void  ccc::AA1 ::pqr(){vfunc_called(this, "_ZN3ccc3AA13pqrEv");}
void  ccc::AA1 ::efg(){vfunc_called(this, "_ZN3ccc3AA13efgEv");}
ccc::AA1 ::~AA1(){ note_dtor("_ZN3ccc3AA1E", this);} // tgen
ccc::AA1 ::AA1(){ note_ctor("_ZN3ccc3AA1E", this);} // tgen
}
static void Test__ZN3ccc3AA1E()
{
  extern Class_Descriptor cd__ZN3ccc3AA1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA1E, buf);
    ::ccc::AA1 *dp, &lv = *(dp=new (buf) ::ccc::AA1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA1E)");
    test_class_info(&lv, &cd__ZN3ccc3AA1E);
    dp->::ccc::AA1::~AA1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA1E(Test__ZN3ccc3AA1E, "_ZN3ccc3AA1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA1C1Ev();
extern void _ZN3ccc3AA1D1Ev();
Name_Map name_map__ZN3ccc3AA1E[] = {
  NSPAIR(_ZN3ccc3AA1C1Ev),
  NSPAIR(_ZN3ccc3AA1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
Class_Descriptor cd__ZN3ccc3AA1E = {  "_ZN3ccc3AA1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB1  {
  virtual void  abc(); // _ZN3ccc3BB13abcEv
  virtual void  pqr(); // _ZN3ccc3BB13pqrEv
  virtual void  efg(); // _ZN3ccc3BB13efgEv
  ~BB1(); // tgen
  BB1(); // tgen
};
//SIG(-1 _ZN3ccc3BB1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB1 ::abc(){vfunc_called(this, "_ZN3ccc3BB13abcEv");}
void  ccc::BB1 ::pqr(){vfunc_called(this, "_ZN3ccc3BB13pqrEv");}
void  ccc::BB1 ::efg(){vfunc_called(this, "_ZN3ccc3BB13efgEv");}
ccc::BB1 ::~BB1(){ note_dtor("_ZN3ccc3BB1E", this);} // tgen
ccc::BB1 ::BB1(){ note_ctor("_ZN3ccc3BB1E", this);} // tgen
}
static void Test__ZN3ccc3BB1E()
{
  extern Class_Descriptor cd__ZN3ccc3BB1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB1E, buf);
    ::ccc::BB1 *dp, &lv = *(dp=new (buf) ::ccc::BB1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB1E)");
    test_class_info(&lv, &cd__ZN3ccc3BB1E);
    dp->::ccc::BB1::~BB1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB1E(Test__ZN3ccc3BB1E, "_ZN3ccc3BB1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB1C1Ev();
extern void _ZN3ccc3BB1D1Ev();
Name_Map name_map__ZN3ccc3BB1E[] = {
  NSPAIR(_ZN3ccc3BB1C1Ev),
  NSPAIR(_ZN3ccc3BB1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern void _ZN3ccc3BB13abcEv();
extern void _ZN3ccc3BB13pqrEv();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
Class_Descriptor cd__ZN3ccc3BB1E = {  "_ZN3ccc3BB1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA2  {
  virtual void  efg(); // _ZN3ccc3AA23efgEv
  virtual void  abc(); // _ZN3ccc3AA23abcEv
  virtual void  pqr(); // _ZN3ccc3AA23pqrEv
  ~AA2(); // tgen
  AA2(); // tgen
};
//SIG(1 _ZN3ccc3AA2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA2 ::efg(){vfunc_called(this, "_ZN3ccc3AA23efgEv");}
void  ccc::AA2 ::abc(){vfunc_called(this, "_ZN3ccc3AA23abcEv");}
void  ccc::AA2 ::pqr(){vfunc_called(this, "_ZN3ccc3AA23pqrEv");}
ccc::AA2 ::~AA2(){ note_dtor("_ZN3ccc3AA2E", this);} // tgen
ccc::AA2 ::AA2(){ note_ctor("_ZN3ccc3AA2E", this);} // tgen
}
static void Test__ZN3ccc3AA2E()
{
  extern Class_Descriptor cd__ZN3ccc3AA2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA2E, buf);
    ::ccc::AA2 *dp, &lv = *(dp=new (buf) ::ccc::AA2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA2E)");
    test_class_info(&lv, &cd__ZN3ccc3AA2E);
    dp->::ccc::AA2::~AA2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA2E(Test__ZN3ccc3AA2E, "_ZN3ccc3AA2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA2C1Ev();
extern void _ZN3ccc3AA2D1Ev();
Name_Map name_map__ZN3ccc3AA2E[] = {
  NSPAIR(_ZN3ccc3AA2C1Ev),
  NSPAIR(_ZN3ccc3AA2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
Class_Descriptor cd__ZN3ccc3AA2E = {  "_ZN3ccc3AA2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB2  {
  virtual void  efg(); // _ZN3ccc3BB23efgEv
  virtual void  abc(); // _ZN3ccc3BB23abcEv
  virtual void  pqr(); // _ZN3ccc3BB23pqrEv
  ~BB2(); // tgen
  BB2(); // tgen
};
//SIG(-1 _ZN3ccc3BB2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB2 ::efg(){vfunc_called(this, "_ZN3ccc3BB23efgEv");}
void  ccc::BB2 ::abc(){vfunc_called(this, "_ZN3ccc3BB23abcEv");}
void  ccc::BB2 ::pqr(){vfunc_called(this, "_ZN3ccc3BB23pqrEv");}
ccc::BB2 ::~BB2(){ note_dtor("_ZN3ccc3BB2E", this);} // tgen
ccc::BB2 ::BB2(){ note_ctor("_ZN3ccc3BB2E", this);} // tgen
}
static void Test__ZN3ccc3BB2E()
{
  extern Class_Descriptor cd__ZN3ccc3BB2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB2E, buf);
    ::ccc::BB2 *dp, &lv = *(dp=new (buf) ::ccc::BB2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB2E)");
    test_class_info(&lv, &cd__ZN3ccc3BB2E);
    dp->::ccc::BB2::~BB2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB2E(Test__ZN3ccc3BB2E, "_ZN3ccc3BB2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB2C1Ev();
extern void _ZN3ccc3BB2D1Ev();
Name_Map name_map__ZN3ccc3BB2E[] = {
  NSPAIR(_ZN3ccc3BB2C1Ev),
  NSPAIR(_ZN3ccc3BB2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern void _ZN3ccc3BB23efgEv();
extern void _ZN3ccc3BB23abcEv();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
Class_Descriptor cd__ZN3ccc3BB2E = {  "_ZN3ccc3BB2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA3  {
  virtual void  efg(); // _ZN3ccc3AA33efgEv
  virtual void  pqr(); // _ZN3ccc3AA33pqrEv
  virtual void  abc(); // _ZN3ccc3AA33abcEv
  ~AA3(); // tgen
  AA3(); // tgen
};
//SIG(1 _ZN3ccc3AA3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA3 ::efg(){vfunc_called(this, "_ZN3ccc3AA33efgEv");}
void  ccc::AA3 ::pqr(){vfunc_called(this, "_ZN3ccc3AA33pqrEv");}
void  ccc::AA3 ::abc(){vfunc_called(this, "_ZN3ccc3AA33abcEv");}
ccc::AA3 ::~AA3(){ note_dtor("_ZN3ccc3AA3E", this);} // tgen
ccc::AA3 ::AA3(){ note_ctor("_ZN3ccc3AA3E", this);} // tgen
}
static void Test__ZN3ccc3AA3E()
{
  extern Class_Descriptor cd__ZN3ccc3AA3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA3E, buf);
    ::ccc::AA3 *dp, &lv = *(dp=new (buf) ::ccc::AA3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA3E)");
    test_class_info(&lv, &cd__ZN3ccc3AA3E);
    dp->::ccc::AA3::~AA3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA3E(Test__ZN3ccc3AA3E, "_ZN3ccc3AA3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA3C1Ev();
extern void _ZN3ccc3AA3D1Ev();
Name_Map name_map__ZN3ccc3AA3E[] = {
  NSPAIR(_ZN3ccc3AA3C1Ev),
  NSPAIR(_ZN3ccc3AA3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
Class_Descriptor cd__ZN3ccc3AA3E = {  "_ZN3ccc3AA3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB3  {
  virtual void  efg(); // _ZN3ccc3BB33efgEv
  virtual void  pqr(); // _ZN3ccc3BB33pqrEv
  virtual void  abc(); // _ZN3ccc3BB33abcEv
  ~BB3(); // tgen
  BB3(); // tgen
};
//SIG(-1 _ZN3ccc3BB3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB3 ::efg(){vfunc_called(this, "_ZN3ccc3BB33efgEv");}
void  ccc::BB3 ::pqr(){vfunc_called(this, "_ZN3ccc3BB33pqrEv");}
void  ccc::BB3 ::abc(){vfunc_called(this, "_ZN3ccc3BB33abcEv");}
ccc::BB3 ::~BB3(){ note_dtor("_ZN3ccc3BB3E", this);} // tgen
ccc::BB3 ::BB3(){ note_ctor("_ZN3ccc3BB3E", this);} // tgen
}
static void Test__ZN3ccc3BB3E()
{
  extern Class_Descriptor cd__ZN3ccc3BB3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB3E, buf);
    ::ccc::BB3 *dp, &lv = *(dp=new (buf) ::ccc::BB3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB3E)");
    test_class_info(&lv, &cd__ZN3ccc3BB3E);
    dp->::ccc::BB3::~BB3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB3E(Test__ZN3ccc3BB3E, "_ZN3ccc3BB3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB3C1Ev();
extern void _ZN3ccc3BB3D1Ev();
Name_Map name_map__ZN3ccc3BB3E[] = {
  NSPAIR(_ZN3ccc3BB3C1Ev),
  NSPAIR(_ZN3ccc3BB3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
Class_Descriptor cd__ZN3ccc3BB3E = {  "_ZN3ccc3BB3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA4  {
  virtual void  pqr(); // _ZN3ccc3AA43pqrEv
  virtual void  abc(); // _ZN3ccc3AA43abcEv
  virtual void  efg(); // _ZN3ccc3AA43efgEv
  ~AA4(); // tgen
  AA4(); // tgen
};
//SIG(1 _ZN3ccc3AA4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA4 ::pqr(){vfunc_called(this, "_ZN3ccc3AA43pqrEv");}
void  ccc::AA4 ::abc(){vfunc_called(this, "_ZN3ccc3AA43abcEv");}
void  ccc::AA4 ::efg(){vfunc_called(this, "_ZN3ccc3AA43efgEv");}
ccc::AA4 ::~AA4(){ note_dtor("_ZN3ccc3AA4E", this);} // tgen
ccc::AA4 ::AA4(){ note_ctor("_ZN3ccc3AA4E", this);} // tgen
}
static void Test__ZN3ccc3AA4E()
{
  extern Class_Descriptor cd__ZN3ccc3AA4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA4E, buf);
    ::ccc::AA4 *dp, &lv = *(dp=new (buf) ::ccc::AA4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA4E)");
    test_class_info(&lv, &cd__ZN3ccc3AA4E);
    dp->::ccc::AA4::~AA4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA4E(Test__ZN3ccc3AA4E, "_ZN3ccc3AA4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA4C1Ev();
extern void _ZN3ccc3AA4D1Ev();
Name_Map name_map__ZN3ccc3AA4E[] = {
  NSPAIR(_ZN3ccc3AA4C1Ev),
  NSPAIR(_ZN3ccc3AA4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
Class_Descriptor cd__ZN3ccc3AA4E = {  "_ZN3ccc3AA4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB4  {
  virtual void  pqr(); // _ZN3ccc3BB43pqrEv
  virtual void  abc(); // _ZN3ccc3BB43abcEv
  virtual void  efg(); // _ZN3ccc3BB43efgEv
  ~BB4(); // tgen
  BB4(); // tgen
};
//SIG(-1 _ZN3ccc3BB4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB4 ::pqr(){vfunc_called(this, "_ZN3ccc3BB43pqrEv");}
void  ccc::BB4 ::abc(){vfunc_called(this, "_ZN3ccc3BB43abcEv");}
void  ccc::BB4 ::efg(){vfunc_called(this, "_ZN3ccc3BB43efgEv");}
ccc::BB4 ::~BB4(){ note_dtor("_ZN3ccc3BB4E", this);} // tgen
ccc::BB4 ::BB4(){ note_ctor("_ZN3ccc3BB4E", this);} // tgen
}
static void Test__ZN3ccc3BB4E()
{
  extern Class_Descriptor cd__ZN3ccc3BB4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB4E, buf);
    ::ccc::BB4 *dp, &lv = *(dp=new (buf) ::ccc::BB4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB4E)");
    test_class_info(&lv, &cd__ZN3ccc3BB4E);
    dp->::ccc::BB4::~BB4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB4E(Test__ZN3ccc3BB4E, "_ZN3ccc3BB4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB4C1Ev();
extern void _ZN3ccc3BB4D1Ev();
Name_Map name_map__ZN3ccc3BB4E[] = {
  NSPAIR(_ZN3ccc3BB4C1Ev),
  NSPAIR(_ZN3ccc3BB4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
Class_Descriptor cd__ZN3ccc3BB4E = {  "_ZN3ccc3BB4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA5  {
  virtual void  pqr(); // _ZN3ccc3AA53pqrEv
  virtual void  efg(); // _ZN3ccc3AA53efgEv
  virtual void  abc(); // _ZN3ccc3AA53abcEv
  ~AA5(); // tgen
  AA5(); // tgen
};
//SIG(1 _ZN3ccc3AA5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA5 ::pqr(){vfunc_called(this, "_ZN3ccc3AA53pqrEv");}
void  ccc::AA5 ::efg(){vfunc_called(this, "_ZN3ccc3AA53efgEv");}
void  ccc::AA5 ::abc(){vfunc_called(this, "_ZN3ccc3AA53abcEv");}
ccc::AA5 ::~AA5(){ note_dtor("_ZN3ccc3AA5E", this);} // tgen
ccc::AA5 ::AA5(){ note_ctor("_ZN3ccc3AA5E", this);} // tgen
}
static void Test__ZN3ccc3AA5E()
{
  extern Class_Descriptor cd__ZN3ccc3AA5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA5E, buf);
    ::ccc::AA5 *dp, &lv = *(dp=new (buf) ::ccc::AA5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA5E)");
    test_class_info(&lv, &cd__ZN3ccc3AA5E);
    dp->::ccc::AA5::~AA5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA5E(Test__ZN3ccc3AA5E, "_ZN3ccc3AA5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA5C1Ev();
extern void _ZN3ccc3AA5D1Ev();
Name_Map name_map__ZN3ccc3AA5E[] = {
  NSPAIR(_ZN3ccc3AA5C1Ev),
  NSPAIR(_ZN3ccc3AA5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
Class_Descriptor cd__ZN3ccc3AA5E = {  "_ZN3ccc3AA5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB5  {
  virtual void  pqr(); // _ZN3ccc3BB53pqrEv
  virtual void  efg(); // _ZN3ccc3BB53efgEv
  virtual void  abc(); // _ZN3ccc3BB53abcEv
  ~BB5(); // tgen
  BB5(); // tgen
};
//SIG(-1 _ZN3ccc3BB5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB5 ::pqr(){vfunc_called(this, "_ZN3ccc3BB53pqrEv");}
void  ccc::BB5 ::efg(){vfunc_called(this, "_ZN3ccc3BB53efgEv");}
void  ccc::BB5 ::abc(){vfunc_called(this, "_ZN3ccc3BB53abcEv");}
ccc::BB5 ::~BB5(){ note_dtor("_ZN3ccc3BB5E", this);} // tgen
ccc::BB5 ::BB5(){ note_ctor("_ZN3ccc3BB5E", this);} // tgen
}
static void Test__ZN3ccc3BB5E()
{
  extern Class_Descriptor cd__ZN3ccc3BB5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB5E, buf);
    ::ccc::BB5 *dp, &lv = *(dp=new (buf) ::ccc::BB5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB5E)");
    test_class_info(&lv, &cd__ZN3ccc3BB5E);
    dp->::ccc::BB5::~BB5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB5E(Test__ZN3ccc3BB5E, "_ZN3ccc3BB5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB5C1Ev();
extern void _ZN3ccc3BB5D1Ev();
Name_Map name_map__ZN3ccc3BB5E[] = {
  NSPAIR(_ZN3ccc3BB5C1Ev),
  NSPAIR(_ZN3ccc3BB5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
Class_Descriptor cd__ZN3ccc3BB5E = {  "_ZN3ccc3BB5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA6  {
  virtual void  abc(); // _ZN3ccc3AA63abcEv
  virtual void  efg(); // _ZN3ccc3AA63efgEv
  ~AA6(); // tgen
  AA6(); // tgen
};
//SIG(1 _ZN3ccc3AA6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA6 ::abc(){vfunc_called(this, "_ZN3ccc3AA63abcEv");}
void  ccc::AA6 ::efg(){vfunc_called(this, "_ZN3ccc3AA63efgEv");}
ccc::AA6 ::~AA6(){ note_dtor("_ZN3ccc3AA6E", this);} // tgen
ccc::AA6 ::AA6(){ note_ctor("_ZN3ccc3AA6E", this);} // tgen
}
static void Test__ZN3ccc3AA6E()
{
  extern Class_Descriptor cd__ZN3ccc3AA6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA6E, buf);
    ::ccc::AA6 *dp, &lv = *(dp=new (buf) ::ccc::AA6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA6E)");
    test_class_info(&lv, &cd__ZN3ccc3AA6E);
    dp->::ccc::AA6::~AA6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA6E(Test__ZN3ccc3AA6E, "_ZN3ccc3AA6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA6C1Ev();
extern void _ZN3ccc3AA6D1Ev();
Name_Map name_map__ZN3ccc3AA6E[] = {
  NSPAIR(_ZN3ccc3AA6C1Ev),
  NSPAIR(_ZN3ccc3AA6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc3AA63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
Class_Descriptor cd__ZN3ccc3AA6E = {  "_ZN3ccc3AA6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB6  {
  virtual void  abc(); // _ZN3ccc3BB63abcEv
  virtual void  efg(); // _ZN3ccc3BB63efgEv
  ~BB6(); // tgen
  BB6(); // tgen
};
//SIG(-1 _ZN3ccc3BB6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB6 ::abc(){vfunc_called(this, "_ZN3ccc3BB63abcEv");}
void  ccc::BB6 ::efg(){vfunc_called(this, "_ZN3ccc3BB63efgEv");}
ccc::BB6 ::~BB6(){ note_dtor("_ZN3ccc3BB6E", this);} // tgen
ccc::BB6 ::BB6(){ note_ctor("_ZN3ccc3BB6E", this);} // tgen
}
static void Test__ZN3ccc3BB6E()
{
  extern Class_Descriptor cd__ZN3ccc3BB6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB6E, buf);
    ::ccc::BB6 *dp, &lv = *(dp=new (buf) ::ccc::BB6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB6E)");
    test_class_info(&lv, &cd__ZN3ccc3BB6E);
    dp->::ccc::BB6::~BB6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB6E(Test__ZN3ccc3BB6E, "_ZN3ccc3BB6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB6C1Ev();
extern void _ZN3ccc3BB6D1Ev();
Name_Map name_map__ZN3ccc3BB6E[] = {
  NSPAIR(_ZN3ccc3BB6C1Ev),
  NSPAIR(_ZN3ccc3BB6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
Class_Descriptor cd__ZN3ccc3BB6E = {  "_ZN3ccc3BB6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA7  {
  virtual void  abc(); // _ZN3ccc3AA73abcEv
  virtual void  pqr(); // _ZN3ccc3AA73pqrEv
  ~AA7(); // tgen
  AA7(); // tgen
};
//SIG(1 _ZN3ccc3AA7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA7 ::abc(){vfunc_called(this, "_ZN3ccc3AA73abcEv");}
void  ccc::AA7 ::pqr(){vfunc_called(this, "_ZN3ccc3AA73pqrEv");}
ccc::AA7 ::~AA7(){ note_dtor("_ZN3ccc3AA7E", this);} // tgen
ccc::AA7 ::AA7(){ note_ctor("_ZN3ccc3AA7E", this);} // tgen
}
static void Test__ZN3ccc3AA7E()
{
  extern Class_Descriptor cd__ZN3ccc3AA7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA7E, buf);
    ::ccc::AA7 *dp, &lv = *(dp=new (buf) ::ccc::AA7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA7E)");
    test_class_info(&lv, &cd__ZN3ccc3AA7E);
    dp->::ccc::AA7::~AA7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA7E(Test__ZN3ccc3AA7E, "_ZN3ccc3AA7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA7C1Ev();
extern void _ZN3ccc3AA7D1Ev();
Name_Map name_map__ZN3ccc3AA7E[] = {
  NSPAIR(_ZN3ccc3AA7C1Ev),
  NSPAIR(_ZN3ccc3AA7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc3AA73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
Class_Descriptor cd__ZN3ccc3AA7E = {  "_ZN3ccc3AA7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB7  {
  virtual void  abc(); // _ZN3ccc3BB73abcEv
  virtual void  pqr(); // _ZN3ccc3BB73pqrEv
  ~BB7(); // tgen
  BB7(); // tgen
};
//SIG(-1 _ZN3ccc3BB7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB7 ::abc(){vfunc_called(this, "_ZN3ccc3BB73abcEv");}
void  ccc::BB7 ::pqr(){vfunc_called(this, "_ZN3ccc3BB73pqrEv");}
ccc::BB7 ::~BB7(){ note_dtor("_ZN3ccc3BB7E", this);} // tgen
ccc::BB7 ::BB7(){ note_ctor("_ZN3ccc3BB7E", this);} // tgen
}
static void Test__ZN3ccc3BB7E()
{
  extern Class_Descriptor cd__ZN3ccc3BB7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB7E, buf);
    ::ccc::BB7 *dp, &lv = *(dp=new (buf) ::ccc::BB7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB7E)");
    test_class_info(&lv, &cd__ZN3ccc3BB7E);
    dp->::ccc::BB7::~BB7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB7E(Test__ZN3ccc3BB7E, "_ZN3ccc3BB7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB7C1Ev();
extern void _ZN3ccc3BB7D1Ev();
Name_Map name_map__ZN3ccc3BB7E[] = {
  NSPAIR(_ZN3ccc3BB7C1Ev),
  NSPAIR(_ZN3ccc3BB7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
Class_Descriptor cd__ZN3ccc3BB7E = {  "_ZN3ccc3BB7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA8  {
  virtual void  efg(); // _ZN3ccc3AA83efgEv
  virtual void  abc(); // _ZN3ccc3AA83abcEv
  ~AA8(); // tgen
  AA8(); // tgen
};
//SIG(1 _ZN3ccc3AA8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA8 ::efg(){vfunc_called(this, "_ZN3ccc3AA83efgEv");}
void  ccc::AA8 ::abc(){vfunc_called(this, "_ZN3ccc3AA83abcEv");}
ccc::AA8 ::~AA8(){ note_dtor("_ZN3ccc3AA8E", this);} // tgen
ccc::AA8 ::AA8(){ note_ctor("_ZN3ccc3AA8E", this);} // tgen
}
static void Test__ZN3ccc3AA8E()
{
  extern Class_Descriptor cd__ZN3ccc3AA8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA8E, buf);
    ::ccc::AA8 *dp, &lv = *(dp=new (buf) ::ccc::AA8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA8E)");
    test_class_info(&lv, &cd__ZN3ccc3AA8E);
    dp->::ccc::AA8::~AA8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA8E(Test__ZN3ccc3AA8E, "_ZN3ccc3AA8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA8C1Ev();
extern void _ZN3ccc3AA8D1Ev();
Name_Map name_map__ZN3ccc3AA8E[] = {
  NSPAIR(_ZN3ccc3AA8C1Ev),
  NSPAIR(_ZN3ccc3AA8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc3AA83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
Class_Descriptor cd__ZN3ccc3AA8E = {  "_ZN3ccc3AA8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB8  {
  virtual void  efg(); // _ZN3ccc3BB83efgEv
  virtual void  abc(); // _ZN3ccc3BB83abcEv
  ~BB8(); // tgen
  BB8(); // tgen
};
//SIG(-1 _ZN3ccc3BB8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB8 ::efg(){vfunc_called(this, "_ZN3ccc3BB83efgEv");}
void  ccc::BB8 ::abc(){vfunc_called(this, "_ZN3ccc3BB83abcEv");}
ccc::BB8 ::~BB8(){ note_dtor("_ZN3ccc3BB8E", this);} // tgen
ccc::BB8 ::BB8(){ note_ctor("_ZN3ccc3BB8E", this);} // tgen
}
static void Test__ZN3ccc3BB8E()
{
  extern Class_Descriptor cd__ZN3ccc3BB8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB8E, buf);
    ::ccc::BB8 *dp, &lv = *(dp=new (buf) ::ccc::BB8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB8E)");
    test_class_info(&lv, &cd__ZN3ccc3BB8E);
    dp->::ccc::BB8::~BB8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB8E(Test__ZN3ccc3BB8E, "_ZN3ccc3BB8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB8C1Ev();
extern void _ZN3ccc3BB8D1Ev();
Name_Map name_map__ZN3ccc3BB8E[] = {
  NSPAIR(_ZN3ccc3BB8C1Ev),
  NSPAIR(_ZN3ccc3BB8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
Class_Descriptor cd__ZN3ccc3BB8E = {  "_ZN3ccc3BB8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA9  {
  virtual void  efg(); // _ZN3ccc3AA93efgEv
  virtual void  pqr(); // _ZN3ccc3AA93pqrEv
  ~AA9(); // tgen
  AA9(); // tgen
};
//SIG(1 _ZN3ccc3AA9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA9 ::efg(){vfunc_called(this, "_ZN3ccc3AA93efgEv");}
void  ccc::AA9 ::pqr(){vfunc_called(this, "_ZN3ccc3AA93pqrEv");}
ccc::AA9 ::~AA9(){ note_dtor("_ZN3ccc3AA9E", this);} // tgen
ccc::AA9 ::AA9(){ note_ctor("_ZN3ccc3AA9E", this);} // tgen
}
static void Test__ZN3ccc3AA9E()
{
  extern Class_Descriptor cd__ZN3ccc3AA9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA9E, buf);
    ::ccc::AA9 *dp, &lv = *(dp=new (buf) ::ccc::AA9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA9E)");
    test_class_info(&lv, &cd__ZN3ccc3AA9E);
    dp->::ccc::AA9::~AA9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA9E(Test__ZN3ccc3AA9E, "_ZN3ccc3AA9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA9C1Ev();
extern void _ZN3ccc3AA9D1Ev();
Name_Map name_map__ZN3ccc3AA9E[] = {
  NSPAIR(_ZN3ccc3AA9C1Ev),
  NSPAIR(_ZN3ccc3AA9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc3AA93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
Class_Descriptor cd__ZN3ccc3AA9E = {  "_ZN3ccc3AA9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB9  {
  virtual void  efg(); // _ZN3ccc3BB93efgEv
  virtual void  pqr(); // _ZN3ccc3BB93pqrEv
  ~BB9(); // tgen
  BB9(); // tgen
};
//SIG(-1 _ZN3ccc3BB9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB9 ::efg(){vfunc_called(this, "_ZN3ccc3BB93efgEv");}
void  ccc::BB9 ::pqr(){vfunc_called(this, "_ZN3ccc3BB93pqrEv");}
ccc::BB9 ::~BB9(){ note_dtor("_ZN3ccc3BB9E", this);} // tgen
ccc::BB9 ::BB9(){ note_ctor("_ZN3ccc3BB9E", this);} // tgen
}
static void Test__ZN3ccc3BB9E()
{
  extern Class_Descriptor cd__ZN3ccc3BB9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB9E, buf);
    ::ccc::BB9 *dp, &lv = *(dp=new (buf) ::ccc::BB9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB9E)");
    test_class_info(&lv, &cd__ZN3ccc3BB9E);
    dp->::ccc::BB9::~BB9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB9E(Test__ZN3ccc3BB9E, "_ZN3ccc3BB9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB9C1Ev();
extern void _ZN3ccc3BB9D1Ev();
Name_Map name_map__ZN3ccc3BB9E[] = {
  NSPAIR(_ZN3ccc3BB9C1Ev),
  NSPAIR(_ZN3ccc3BB9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
Class_Descriptor cd__ZN3ccc3BB9E = {  "_ZN3ccc3BB9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA10  {
  virtual void  pqr(); // _ZN3ccc4AA103pqrEv
  virtual void  abc(); // _ZN3ccc4AA103abcEv
  ~AA10(); // tgen
  AA10(); // tgen
};
//SIG(-1 _ZN3ccc4AA10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA10 ::pqr(){vfunc_called(this, "_ZN3ccc4AA103pqrEv");}
void  ccc::AA10 ::abc(){vfunc_called(this, "_ZN3ccc4AA103abcEv");}
ccc::AA10 ::~AA10(){ note_dtor("_ZN3ccc4AA10E", this);} // tgen
ccc::AA10 ::AA10(){ note_ctor("_ZN3ccc4AA10E", this);} // tgen
}
static void Test__ZN3ccc4AA10E()
{
  extern Class_Descriptor cd__ZN3ccc4AA10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA10E, buf);
    ::ccc::AA10 *dp, &lv = *(dp=new (buf) ::ccc::AA10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA10E)");
    test_class_info(&lv, &cd__ZN3ccc4AA10E);
    dp->::ccc::AA10::~AA10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA10E(Test__ZN3ccc4AA10E, "_ZN3ccc4AA10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA10C1Ev();
extern void _ZN3ccc4AA10D1Ev();
Name_Map name_map__ZN3ccc4AA10E[] = {
  NSPAIR(_ZN3ccc4AA10C1Ev),
  NSPAIR(_ZN3ccc4AA10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
Class_Descriptor cd__ZN3ccc4AA10E = {  "_ZN3ccc4AA10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB10  {
  virtual void  pqr(); // _ZN3ccc4BB103pqrEv
  virtual void  abc(); // _ZN3ccc4BB103abcEv
  ~BB10(); // tgen
  BB10(); // tgen
};
//SIG(-1 _ZN3ccc4BB10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB10 ::pqr(){vfunc_called(this, "_ZN3ccc4BB103pqrEv");}
void  ccc::BB10 ::abc(){vfunc_called(this, "_ZN3ccc4BB103abcEv");}
ccc::BB10 ::~BB10(){ note_dtor("_ZN3ccc4BB10E", this);} // tgen
ccc::BB10 ::BB10(){ note_ctor("_ZN3ccc4BB10E", this);} // tgen
}
static void Test__ZN3ccc4BB10E()
{
  extern Class_Descriptor cd__ZN3ccc4BB10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB10E, buf);
    ::ccc::BB10 *dp, &lv = *(dp=new (buf) ::ccc::BB10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB10E)");
    test_class_info(&lv, &cd__ZN3ccc4BB10E);
    dp->::ccc::BB10::~BB10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB10E(Test__ZN3ccc4BB10E, "_ZN3ccc4BB10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB10C1Ev();
extern void _ZN3ccc4BB10D1Ev();
Name_Map name_map__ZN3ccc4BB10E[] = {
  NSPAIR(_ZN3ccc4BB10C1Ev),
  NSPAIR(_ZN3ccc4BB10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
Class_Descriptor cd__ZN3ccc4BB10E = {  "_ZN3ccc4BB10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA11  {
  virtual void  pqr(); // _ZN3ccc4AA113pqrEv
  virtual void  efg(); // _ZN3ccc4AA113efgEv
  ~AA11(); // tgen
  AA11(); // tgen
};
//SIG(-1 _ZN3ccc4AA11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA11 ::pqr(){vfunc_called(this, "_ZN3ccc4AA113pqrEv");}
void  ccc::AA11 ::efg(){vfunc_called(this, "_ZN3ccc4AA113efgEv");}
ccc::AA11 ::~AA11(){ note_dtor("_ZN3ccc4AA11E", this);} // tgen
ccc::AA11 ::AA11(){ note_ctor("_ZN3ccc4AA11E", this);} // tgen
}
static void Test__ZN3ccc4AA11E()
{
  extern Class_Descriptor cd__ZN3ccc4AA11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA11E, buf);
    ::ccc::AA11 *dp, &lv = *(dp=new (buf) ::ccc::AA11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA11E)");
    test_class_info(&lv, &cd__ZN3ccc4AA11E);
    dp->::ccc::AA11::~AA11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA11E(Test__ZN3ccc4AA11E, "_ZN3ccc4AA11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA11C1Ev();
extern void _ZN3ccc4AA11D1Ev();
Name_Map name_map__ZN3ccc4AA11E[] = {
  NSPAIR(_ZN3ccc4AA11C1Ev),
  NSPAIR(_ZN3ccc4AA11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc4AA113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
Class_Descriptor cd__ZN3ccc4AA11E = {  "_ZN3ccc4AA11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB11  {
  virtual void  pqr(); // _ZN3ccc4BB113pqrEv
  virtual void  efg(); // _ZN3ccc4BB113efgEv
  ~BB11(); // tgen
  BB11(); // tgen
};
//SIG(-1 _ZN3ccc4BB11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB11 ::pqr(){vfunc_called(this, "_ZN3ccc4BB113pqrEv");}
void  ccc::BB11 ::efg(){vfunc_called(this, "_ZN3ccc4BB113efgEv");}
ccc::BB11 ::~BB11(){ note_dtor("_ZN3ccc4BB11E", this);} // tgen
ccc::BB11 ::BB11(){ note_ctor("_ZN3ccc4BB11E", this);} // tgen
}
static void Test__ZN3ccc4BB11E()
{
  extern Class_Descriptor cd__ZN3ccc4BB11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB11E, buf);
    ::ccc::BB11 *dp, &lv = *(dp=new (buf) ::ccc::BB11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB11E)");
    test_class_info(&lv, &cd__ZN3ccc4BB11E);
    dp->::ccc::BB11::~BB11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB11E(Test__ZN3ccc4BB11E, "_ZN3ccc4BB11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB11C1Ev();
extern void _ZN3ccc4BB11D1Ev();
Name_Map name_map__ZN3ccc4BB11E[] = {
  NSPAIR(_ZN3ccc4BB11C1Ev),
  NSPAIR(_ZN3ccc4BB11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
Class_Descriptor cd__ZN3ccc4BB11E = {  "_ZN3ccc4BB11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA12  {
  virtual void  abc(); // _ZN3ccc4AA123abcEv
  ~AA12(); // tgen
  AA12(); // tgen
};
//SIG(-1 _ZN3ccc4AA12E) C1{ v1}
}
namespace ccc { 
void  ccc::AA12 ::abc(){vfunc_called(this, "_ZN3ccc4AA123abcEv");}
ccc::AA12 ::~AA12(){ note_dtor("_ZN3ccc4AA12E", this);} // tgen
ccc::AA12 ::AA12(){ note_ctor("_ZN3ccc4AA12E", this);} // tgen
}
static void Test__ZN3ccc4AA12E()
{
  extern Class_Descriptor cd__ZN3ccc4AA12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA12E, buf);
    ::ccc::AA12 *dp, &lv = *(dp=new (buf) ::ccc::AA12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA12E)");
    test_class_info(&lv, &cd__ZN3ccc4AA12E);
    dp->::ccc::AA12::~AA12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA12E(Test__ZN3ccc4AA12E, "_ZN3ccc4AA12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA12C1Ev();
extern void _ZN3ccc4AA12D1Ev();
Name_Map name_map__ZN3ccc4AA12E[] = {
  NSPAIR(_ZN3ccc4AA12C1Ev),
  NSPAIR(_ZN3ccc4AA12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern void _ZN3ccc4AA123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
Class_Descriptor cd__ZN3ccc4AA12E = {  "_ZN3ccc4AA12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB12  {
  virtual void  abc(); // _ZN3ccc4BB123abcEv
  ~BB12(); // tgen
  BB12(); // tgen
};
//SIG(-1 _ZN3ccc4BB12E) C1{ v1}
}
namespace ccc { 
void  ccc::BB12 ::abc(){vfunc_called(this, "_ZN3ccc4BB123abcEv");}
ccc::BB12 ::~BB12(){ note_dtor("_ZN3ccc4BB12E", this);} // tgen
ccc::BB12 ::BB12(){ note_ctor("_ZN3ccc4BB12E", this);} // tgen
}
static void Test__ZN3ccc4BB12E()
{
  extern Class_Descriptor cd__ZN3ccc4BB12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB12E, buf);
    ::ccc::BB12 *dp, &lv = *(dp=new (buf) ::ccc::BB12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB12E)");
    test_class_info(&lv, &cd__ZN3ccc4BB12E);
    dp->::ccc::BB12::~BB12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB12E(Test__ZN3ccc4BB12E, "_ZN3ccc4BB12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB12C1Ev();
extern void _ZN3ccc4BB12D1Ev();
Name_Map name_map__ZN3ccc4BB12E[] = {
  NSPAIR(_ZN3ccc4BB12C1Ev),
  NSPAIR(_ZN3ccc4BB12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
Class_Descriptor cd__ZN3ccc4BB12E = {  "_ZN3ccc4BB12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA13  {
  virtual void  efg(); // _ZN3ccc4AA133efgEv
  ~AA13(); // tgen
  AA13(); // tgen
};
//SIG(-1 _ZN3ccc4AA13E) C1{ v1}
}
namespace ccc { 
void  ccc::AA13 ::efg(){vfunc_called(this, "_ZN3ccc4AA133efgEv");}
ccc::AA13 ::~AA13(){ note_dtor("_ZN3ccc4AA13E", this);} // tgen
ccc::AA13 ::AA13(){ note_ctor("_ZN3ccc4AA13E", this);} // tgen
}
static void Test__ZN3ccc4AA13E()
{
  extern Class_Descriptor cd__ZN3ccc4AA13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA13E, buf);
    ::ccc::AA13 *dp, &lv = *(dp=new (buf) ::ccc::AA13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA13E)");
    test_class_info(&lv, &cd__ZN3ccc4AA13E);
    dp->::ccc::AA13::~AA13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA13E(Test__ZN3ccc4AA13E, "_ZN3ccc4AA13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA13C1Ev();
extern void _ZN3ccc4AA13D1Ev();
Name_Map name_map__ZN3ccc4AA13E[] = {
  NSPAIR(_ZN3ccc4AA13C1Ev),
  NSPAIR(_ZN3ccc4AA13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern void _ZN3ccc4AA133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
Class_Descriptor cd__ZN3ccc4AA13E = {  "_ZN3ccc4AA13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB13  {
  virtual void  efg(); // _ZN3ccc4BB133efgEv
  ~BB13(); // tgen
  BB13(); // tgen
};
//SIG(-1 _ZN3ccc4BB13E) C1{ v1}
}
namespace ccc { 
void  ccc::BB13 ::efg(){vfunc_called(this, "_ZN3ccc4BB133efgEv");}
ccc::BB13 ::~BB13(){ note_dtor("_ZN3ccc4BB13E", this);} // tgen
ccc::BB13 ::BB13(){ note_ctor("_ZN3ccc4BB13E", this);} // tgen
}
static void Test__ZN3ccc4BB13E()
{
  extern Class_Descriptor cd__ZN3ccc4BB13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB13E, buf);
    ::ccc::BB13 *dp, &lv = *(dp=new (buf) ::ccc::BB13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB13E)");
    test_class_info(&lv, &cd__ZN3ccc4BB13E);
    dp->::ccc::BB13::~BB13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB13E(Test__ZN3ccc4BB13E, "_ZN3ccc4BB13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB13C1Ev();
extern void _ZN3ccc4BB13D1Ev();
Name_Map name_map__ZN3ccc4BB13E[] = {
  NSPAIR(_ZN3ccc4BB13C1Ev),
  NSPAIR(_ZN3ccc4BB13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
Class_Descriptor cd__ZN3ccc4BB13E = {  "_ZN3ccc4BB13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA14  {
  virtual void  pqr(); // _ZN3ccc4AA143pqrEv
  ~AA14(); // tgen
  AA14(); // tgen
};
//SIG(-1 _ZN3ccc4AA14E) C1{ v1}
}
namespace ccc { 
void  ccc::AA14 ::pqr(){vfunc_called(this, "_ZN3ccc4AA143pqrEv");}
ccc::AA14 ::~AA14(){ note_dtor("_ZN3ccc4AA14E", this);} // tgen
ccc::AA14 ::AA14(){ note_ctor("_ZN3ccc4AA14E", this);} // tgen
}
static void Test__ZN3ccc4AA14E()
{
  extern Class_Descriptor cd__ZN3ccc4AA14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA14E, buf);
    ::ccc::AA14 *dp, &lv = *(dp=new (buf) ::ccc::AA14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA14E)");
    test_class_info(&lv, &cd__ZN3ccc4AA14E);
    dp->::ccc::AA14::~AA14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA14E(Test__ZN3ccc4AA14E, "_ZN3ccc4AA14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA14C1Ev();
extern void _ZN3ccc4AA14D1Ev();
Name_Map name_map__ZN3ccc4AA14E[] = {
  NSPAIR(_ZN3ccc4AA14C1Ev),
  NSPAIR(_ZN3ccc4AA14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern void _ZN3ccc4AA143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
Class_Descriptor cd__ZN3ccc4AA14E = {  "_ZN3ccc4AA14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB14  {
  virtual void  pqr(); // _ZN3ccc4BB143pqrEv
  ~BB14(); // tgen
  BB14(); // tgen
};
//SIG(-1 _ZN3ccc4BB14E) C1{ v1}
}
namespace ccc { 
void  ccc::BB14 ::pqr(){vfunc_called(this, "_ZN3ccc4BB143pqrEv");}
ccc::BB14 ::~BB14(){ note_dtor("_ZN3ccc4BB14E", this);} // tgen
ccc::BB14 ::BB14(){ note_ctor("_ZN3ccc4BB14E", this);} // tgen
}
static void Test__ZN3ccc4BB14E()
{
  extern Class_Descriptor cd__ZN3ccc4BB14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB14E, buf);
    ::ccc::BB14 *dp, &lv = *(dp=new (buf) ::ccc::BB14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB14E)");
    test_class_info(&lv, &cd__ZN3ccc4BB14E);
    dp->::ccc::BB14::~BB14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB14E(Test__ZN3ccc4BB14E, "_ZN3ccc4BB14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB14C1Ev();
extern void _ZN3ccc4BB14D1Ev();
Name_Map name_map__ZN3ccc4BB14E[] = {
  NSPAIR(_ZN3ccc4BB14C1Ev),
  NSPAIR(_ZN3ccc4BB14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern void _ZN3ccc4BB143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
Class_Descriptor cd__ZN3ccc4BB14E = {  "_ZN3ccc4BB14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA15  {
};
//SIG(-1 _ZN3ccc4AA15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4AA15E()
{
  {
    init_simple_test("_ZN3ccc4AA15E");
    ::ccc::AA15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4AA15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4AA15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4AA15E(Test__ZN3ccc4AA15E, "_ZN3ccc4AA15E", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
VTBL_ENTRY *P__ZTIN3ccc4AA15E = _ZTIN3ccc4AA15E; 
Class_Descriptor cd__ZN3ccc4AA15E = {  "_ZN3ccc4AA15E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTIN3ccc4AA15E),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB15  {
};
//SIG(-1 _ZN3ccc4BB15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4BB15E()
{
  {
    init_simple_test("_ZN3ccc4BB15E");
    ::ccc::BB15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4BB15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4BB15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4BB15E(Test__ZN3ccc4BB15E, "_ZN3ccc4BB15E", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTIN3ccc4BB15E[];
VTBL_ENTRY *P__ZTIN3ccc4BB15E = _ZTIN3ccc4BB15E; 
Class_Descriptor cd__ZN3ccc4BB15E = {  "_ZN3ccc4BB15E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTIN3ccc4BB15E),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y4  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC10x6y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x6y43abcEv
  virtual void  efg(); // _ZN3ccc8CC10x6y43efgEv
  ~CC10x6y4(); // tgen
  CC10x6y4(); // tgen
};
//SIG(1 _ZN3ccc8CC10x6y4E) C1{ VBC2{ v1 v2} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x6y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x6y43pqrEv");}
void  ccc::CC10x6y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x6y43abcEv");}
void  ccc::CC10x6y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x6y43efgEv");}
ccc::CC10x6y4 ::~CC10x6y4(){ note_dtor("_ZN3ccc8CC10x6y4E", this);} // tgen
ccc::CC10x6y4 ::CC10x6y4(){ note_ctor("_ZN3ccc8CC10x6y4E", this);} // tgen
}
static void Test__ZN3ccc8CC10x6y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x6y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x6y4E, buf);
    ::ccc::CC10x6y4 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x6y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x6y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x6y4E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC10x6y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x6y4E);
    dp->::ccc::CC10x6y4::~CC10x6y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x6y4E(Test__ZN3ccc8CC10x6y4E, "_ZN3ccc8CC10x6y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x6y4C1Ev();
extern void _ZN3ccc8CC10x6y4D1Ev();
Name_Map name_map__ZN3ccc8CC10x6y4E[] = {
  NSPAIR(_ZN3ccc8CC10x6y4C1Ev),
  NSPAIR(_ZN3ccc8CC10x6y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC10x6y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y4E[];
extern void _ZN3ccc8CC10x6y43abcEv();
extern void _ZN3ccc8CC10x6y43efgEv();
extern void _ZN3ccc8CC10x6y43pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x6y43pqrEv,_ZTv0_n12_N3ccc8CC10x6y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y43pqrEv,_ZThn4_N3ccc8CC10x6y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x6y43abcEv,_ZTv0_n16_N3ccc8CC10x6y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y43abcEv,_ZThn4_N3ccc8CC10x6y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x6y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y43pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x6y43pqrEv,_ZTv0_n12_N3ccc8CC10x6y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x6y43abcEv,_ZTv0_n16_N3ccc8CC10x6y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x6y4E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x6y4E[] = {
  {&(_ZTVN3ccc8CC10x6y4E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x6y4E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x6y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x6y4E[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x6y43abcEv,_ZTv0_n16_N3ccc8CC10x6y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y43abcEv,_ZThn4_N3ccc8CC10x6y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x6y43pqrEv,_ZTv0_n12_N3ccc8CC10x6y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y43pqrEv,_ZThn4_N3ccc8CC10x6y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x6y4E = {  "_ZN3ccc8CC10x6y4E", // class name
  bases__ZN3ccc8CC10x6y4E, 2,
  &(vtc__ZN3ccc8CC10x6y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x6y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x6y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x6y4E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x6y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y4  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8DD10x6y43pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x6y43abcEv
  virtual void  efg(); // _ZN3ccc8DD10x6y43efgEv
  ~DD10x6y4(); // tgen
  DD10x6y4(); // tgen
};
//SIG(1 _ZN3ccc8DD10x6y4E) C1{ VBC2{ v1 v2} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x6y4 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x6y43pqrEv");}
void  ccc::DD10x6y4 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x6y43abcEv");}
void  ccc::DD10x6y4 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x6y43efgEv");}
ccc::DD10x6y4 ::~DD10x6y4(){ note_dtor("_ZN3ccc8DD10x6y4E", this);} // tgen
ccc::DD10x6y4 ::DD10x6y4(){ note_ctor("_ZN3ccc8DD10x6y4E", this);} // tgen
}
static void Test__ZN3ccc8DD10x6y4E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x6y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x6y4E, buf);
    ::ccc::DD10x6y4 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x6y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x6y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x6y4E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD10x6y4E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x6y4E);
    dp->::ccc::DD10x6y4::~DD10x6y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x6y4E(Test__ZN3ccc8DD10x6y4E, "_ZN3ccc8DD10x6y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x6y4C1Ev();
extern void _ZN3ccc8DD10x6y4D1Ev();
Name_Map name_map__ZN3ccc8DD10x6y4E[] = {
  NSPAIR(_ZN3ccc8DD10x6y4C1Ev),
  NSPAIR(_ZN3ccc8DD10x6y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD10x6y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y4E[];
extern void _ZN3ccc8DD10x6y43pqrEv();
extern void _ZN3ccc8DD10x6y43abcEv();
extern void _ZN3ccc8DD10x6y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x6y43abcEv,_ZTv0_n12_N3ccc8DD10x6y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y43abcEv,_ZThn4_N3ccc8DD10x6y43abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x6y43efgEv,_ZTv0_n16_N3ccc8DD10x6y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y43efgEv,_ZThn4_N3ccc8DD10x6y43efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x6y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x6y43abcEv,_ZTv0_n12_N3ccc8DD10x6y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x6y43efgEv,_ZTv0_n16_N3ccc8DD10x6y43efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x6y4E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x6y4E[] = {
  {&(_ZTVN3ccc8DD10x6y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y4E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x6y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x6y4E[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x6y43efgEv,_ZTv0_n16_N3ccc8DD10x6y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y43efgEv,_ZThn4_N3ccc8DD10x6y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x6y43abcEv,_ZTv0_n12_N3ccc8DD10x6y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y43abcEv,_ZThn4_N3ccc8DD10x6y43abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x6y4E = {  "_ZN3ccc8DD10x6y4E", // class name
  bases__ZN3ccc8DD10x6y4E, 2,
  &(vtc__ZN3ccc8DD10x6y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x6y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x6y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x6y4E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x6y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y5  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC10x6y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x6y53efgEv
  virtual void  abc(); // _ZN3ccc8CC10x6y53abcEv
  ~CC10x6y5(); // tgen
  CC10x6y5(); // tgen
};
//SIG(1 _ZN3ccc8CC10x6y5E) C1{ VBC2{ v1 v3} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x6y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x6y53pqrEv");}
void  ccc::CC10x6y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x6y53efgEv");}
void  ccc::CC10x6y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x6y53abcEv");}
ccc::CC10x6y5 ::~CC10x6y5(){ note_dtor("_ZN3ccc8CC10x6y5E", this);} // tgen
ccc::CC10x6y5 ::CC10x6y5(){ note_ctor("_ZN3ccc8CC10x6y5E", this);} // tgen
}
static void Test__ZN3ccc8CC10x6y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x6y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x6y5E, buf);
    ::ccc::CC10x6y5 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x6y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x6y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x6y5E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC10x6y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x6y5E);
    dp->::ccc::CC10x6y5::~CC10x6y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x6y5E(Test__ZN3ccc8CC10x6y5E, "_ZN3ccc8CC10x6y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x6y5C1Ev();
extern void _ZN3ccc8CC10x6y5D1Ev();
Name_Map name_map__ZN3ccc8CC10x6y5E[] = {
  NSPAIR(_ZN3ccc8CC10x6y5C1Ev),
  NSPAIR(_ZN3ccc8CC10x6y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC10x6y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y5E[];
extern void _ZN3ccc8CC10x6y53abcEv();
extern void _ZN3ccc8CC10x6y53efgEv();
extern void _ZN3ccc8CC10x6y53pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x6y53pqrEv,_ZTv0_n12_N3ccc8CC10x6y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y53pqrEv,_ZThn4_N3ccc8CC10x6y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x6y53abcEv,_ZTv0_n16_N3ccc8CC10x6y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y53abcEv,_ZThn4_N3ccc8CC10x6y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x6y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y53pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x6y53pqrEv,_ZTv0_n12_N3ccc8CC10x6y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x6y53abcEv,_ZTv0_n16_N3ccc8CC10x6y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x6y5E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x6y5E[] = {
  {&(_ZTVN3ccc8CC10x6y5E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x6y5E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x6y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x6y5E[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x6y53abcEv,_ZTv0_n16_N3ccc8CC10x6y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y53abcEv,_ZThn4_N3ccc8CC10x6y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x6y53pqrEv,_ZTv0_n12_N3ccc8CC10x6y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y53pqrEv,_ZThn4_N3ccc8CC10x6y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x6y5E = {  "_ZN3ccc8CC10x6y5E", // class name
  bases__ZN3ccc8CC10x6y5E, 2,
  &(vtc__ZN3ccc8CC10x6y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x6y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x6y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x6y5E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x6y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y5  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8DD10x6y53pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x6y53efgEv
  virtual void  abc(); // _ZN3ccc8DD10x6y53abcEv
  ~DD10x6y5(); // tgen
  DD10x6y5(); // tgen
};
//SIG(1 _ZN3ccc8DD10x6y5E) C1{ VBC2{ v1 v3} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x6y5 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x6y53pqrEv");}
void  ccc::DD10x6y5 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x6y53efgEv");}
void  ccc::DD10x6y5 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x6y53abcEv");}
ccc::DD10x6y5 ::~DD10x6y5(){ note_dtor("_ZN3ccc8DD10x6y5E", this);} // tgen
ccc::DD10x6y5 ::DD10x6y5(){ note_ctor("_ZN3ccc8DD10x6y5E", this);} // tgen
}
static void Test__ZN3ccc8DD10x6y5E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x6y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x6y5E, buf);
    ::ccc::DD10x6y5 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x6y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x6y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x6y5E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD10x6y5E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x6y5E);
    dp->::ccc::DD10x6y5::~DD10x6y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x6y5E(Test__ZN3ccc8DD10x6y5E, "_ZN3ccc8DD10x6y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x6y5C1Ev();
extern void _ZN3ccc8DD10x6y5D1Ev();
Name_Map name_map__ZN3ccc8DD10x6y5E[] = {
  NSPAIR(_ZN3ccc8DD10x6y5C1Ev),
  NSPAIR(_ZN3ccc8DD10x6y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD10x6y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y5E[];
extern void _ZN3ccc8DD10x6y53pqrEv();
extern void _ZN3ccc8DD10x6y53abcEv();
extern void _ZN3ccc8DD10x6y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x6y53abcEv,_ZTv0_n12_N3ccc8DD10x6y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y53abcEv,_ZThn4_N3ccc8DD10x6y53abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x6y53efgEv,_ZTv0_n16_N3ccc8DD10x6y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y53efgEv,_ZThn4_N3ccc8DD10x6y53efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x6y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x6y53abcEv,_ZTv0_n12_N3ccc8DD10x6y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x6y53efgEv,_ZTv0_n16_N3ccc8DD10x6y53efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x6y5E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x6y5E[] = {
  {&(_ZTVN3ccc8DD10x6y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y5E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x6y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x6y5E[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x6y53efgEv,_ZTv0_n16_N3ccc8DD10x6y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y53efgEv,_ZThn4_N3ccc8DD10x6y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x6y53abcEv,_ZTv0_n12_N3ccc8DD10x6y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y53abcEv,_ZThn4_N3ccc8DD10x6y53abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x6y5E = {  "_ZN3ccc8DD10x6y5E", // class name
  bases__ZN3ccc8DD10x6y5E, 2,
  &(vtc__ZN3ccc8DD10x6y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x6y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x6y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x6y5E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x6y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y6  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8CC10x6y63abcEv
  virtual void  efg(); // _ZN3ccc8CC10x6y63efgEv
  ~CC10x6y6(); // tgen
  CC10x6y6(); // tgen
};
//SIG(1 _ZN3ccc8CC10x6y6E) C1{ VBC2{ v3 v1} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x6y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x6y63abcEv");}
void  ccc::CC10x6y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x6y63efgEv");}
ccc::CC10x6y6 ::~CC10x6y6(){ note_dtor("_ZN3ccc8CC10x6y6E", this);} // tgen
ccc::CC10x6y6 ::CC10x6y6(){ note_ctor("_ZN3ccc8CC10x6y6E", this);} // tgen
}
static void Test__ZN3ccc8CC10x6y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x6y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x6y6E, buf);
    ::ccc::CC10x6y6 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x6y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x6y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x6y6E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC10x6y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x6y6E);
    dp->::ccc::CC10x6y6::~CC10x6y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x6y6E(Test__ZN3ccc8CC10x6y6E, "_ZN3ccc8CC10x6y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x6y6C1Ev();
extern void _ZN3ccc8CC10x6y6D1Ev();
Name_Map name_map__ZN3ccc8CC10x6y6E[] = {
  NSPAIR(_ZN3ccc8CC10x6y6C1Ev),
  NSPAIR(_ZN3ccc8CC10x6y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC10x6y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y6E[];
extern void _ZN3ccc8CC10x6y63abcEv();
extern void _ZN3ccc8CC10x6y63efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x6y63abcEv,_ZTv0_n16_N3ccc8CC10x6y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y63abcEv,_ZThn4_N3ccc8CC10x6y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x6y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y63efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x6y63abcEv,_ZTv0_n16_N3ccc8CC10x6y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x6y6E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x6y6E[] = {
  {&(_ZTVN3ccc8CC10x6y6E[3]),  3,11},
  {&(_ZTVN3ccc8CC10x6y6E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x6y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x6y6E[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x6y63abcEv,_ZTv0_n16_N3ccc8CC10x6y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y63abcEv,_ZThn4_N3ccc8CC10x6y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x6y6E = {  "_ZN3ccc8CC10x6y6E", // class name
  bases__ZN3ccc8CC10x6y6E, 2,
  &(vtc__ZN3ccc8CC10x6y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x6y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x6y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x6y6E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x6y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y6  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8DD10x6y63abcEv
  virtual void  efg(); // _ZN3ccc8DD10x6y63efgEv
  ~DD10x6y6(); // tgen
  DD10x6y6(); // tgen
};
//SIG(1 _ZN3ccc8DD10x6y6E) C1{ VBC2{ v3 v1} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x6y6 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x6y63abcEv");}
void  ccc::DD10x6y6 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x6y63efgEv");}
ccc::DD10x6y6 ::~DD10x6y6(){ note_dtor("_ZN3ccc8DD10x6y6E", this);} // tgen
ccc::DD10x6y6 ::DD10x6y6(){ note_ctor("_ZN3ccc8DD10x6y6E", this);} // tgen
}
static void Test__ZN3ccc8DD10x6y6E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x6y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x6y6E, buf);
    ::ccc::DD10x6y6 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x6y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x6y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x6y6E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD10x6y6E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x6y6E);
    dp->::ccc::DD10x6y6::~DD10x6y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x6y6E(Test__ZN3ccc8DD10x6y6E, "_ZN3ccc8DD10x6y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x6y6C1Ev();
extern void _ZN3ccc8DD10x6y6D1Ev();
Name_Map name_map__ZN3ccc8DD10x6y6E[] = {
  NSPAIR(_ZN3ccc8DD10x6y6C1Ev),
  NSPAIR(_ZN3ccc8DD10x6y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD10x6y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x6y63abcEv();
extern void _ZN3ccc8DD10x6y63efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x6y63abcEv,_ZTv0_n12_N3ccc8DD10x6y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y63abcEv,_ZThn4_N3ccc8DD10x6y63abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x6y63efgEv,_ZTv0_n16_N3ccc8DD10x6y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y63efgEv,_ZThn4_N3ccc8DD10x6y63efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x6y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y63efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x6y63abcEv,_ZTv0_n12_N3ccc8DD10x6y63abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x6y63efgEv,_ZTv0_n16_N3ccc8DD10x6y63efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x6y6E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x6y6E[] = {
  {&(_ZTVN3ccc8DD10x6y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y6E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x6y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x6y6E[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x6y63efgEv,_ZTv0_n16_N3ccc8DD10x6y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y63efgEv,_ZThn4_N3ccc8DD10x6y63efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x6y63abcEv,_ZTv0_n12_N3ccc8DD10x6y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y63abcEv,_ZThn4_N3ccc8DD10x6y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x6y6E = {  "_ZN3ccc8DD10x6y6E", // class name
  bases__ZN3ccc8DD10x6y6E, 2,
  &(vtc__ZN3ccc8DD10x6y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x6y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x6y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x6y6E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x6y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y7  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8CC10x6y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x6y73pqrEv
  ~CC10x6y7(); // tgen
  CC10x6y7(); // tgen
};
//SIG(1 _ZN3ccc8CC10x6y7E) C1{ VBC2{ v2 v1} BC3{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::CC10x6y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x6y73abcEv");}
void  ccc::CC10x6y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x6y73pqrEv");}
ccc::CC10x6y7 ::~CC10x6y7(){ note_dtor("_ZN3ccc8CC10x6y7E", this);} // tgen
ccc::CC10x6y7 ::CC10x6y7(){ note_ctor("_ZN3ccc8CC10x6y7E", this);} // tgen
}
static void Test__ZN3ccc8CC10x6y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x6y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x6y7E, buf);
    ::ccc::CC10x6y7 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x6y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x6y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x6y7E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC10x6y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x6y7E);
    dp->::ccc::CC10x6y7::~CC10x6y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x6y7E(Test__ZN3ccc8CC10x6y7E, "_ZN3ccc8CC10x6y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x6y7C1Ev();
extern void _ZN3ccc8CC10x6y7D1Ev();
Name_Map name_map__ZN3ccc8CC10x6y7E[] = {
  NSPAIR(_ZN3ccc8CC10x6y7C1Ev),
  NSPAIR(_ZN3ccc8CC10x6y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC10x6y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y7E[];
extern void _ZN3ccc8CC10x6y73abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc8CC10x6y73pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x6y73pqrEv,_ZTv0_n12_N3ccc8CC10x6y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y73pqrEv,_ZThn4_N3ccc8CC10x6y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x6y73abcEv,_ZTv0_n16_N3ccc8CC10x6y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y73abcEv,_ZThn4_N3ccc8CC10x6y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x6y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y73pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x6y73pqrEv,_ZTv0_n12_N3ccc8CC10x6y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x6y73abcEv,_ZTv0_n16_N3ccc8CC10x6y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x6y7E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x6y7E[] = {
  {&(_ZTVN3ccc8CC10x6y7E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x6y7E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x6y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x6y7E[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x6y73abcEv,_ZTv0_n16_N3ccc8CC10x6y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y73abcEv,_ZThn4_N3ccc8CC10x6y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x6y73pqrEv,_ZTv0_n12_N3ccc8CC10x6y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y73pqrEv,_ZThn4_N3ccc8CC10x6y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x6y7E = {  "_ZN3ccc8CC10x6y7E", // class name
  bases__ZN3ccc8CC10x6y7E, 2,
  &(vtc__ZN3ccc8CC10x6y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x6y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x6y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x6y7E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x6y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y7  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8DD10x6y73abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x6y73pqrEv
  ~DD10x6y7(); // tgen
  DD10x6y7(); // tgen
};
//SIG(1 _ZN3ccc8DD10x6y7E) C1{ VBC2{ v2 v1} VBC3{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::DD10x6y7 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x6y73abcEv");}
void  ccc::DD10x6y7 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x6y73pqrEv");}
ccc::DD10x6y7 ::~DD10x6y7(){ note_dtor("_ZN3ccc8DD10x6y7E", this);} // tgen
ccc::DD10x6y7 ::DD10x6y7(){ note_ctor("_ZN3ccc8DD10x6y7E", this);} // tgen
}
static void Test__ZN3ccc8DD10x6y7E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x6y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x6y7E, buf);
    ::ccc::DD10x6y7 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x6y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x6y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x6y7E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD10x6y7E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x6y7E);
    dp->::ccc::DD10x6y7::~DD10x6y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x6y7E(Test__ZN3ccc8DD10x6y7E, "_ZN3ccc8DD10x6y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x6y7C1Ev();
extern void _ZN3ccc8DD10x6y7D1Ev();
Name_Map name_map__ZN3ccc8DD10x6y7E[] = {
  NSPAIR(_ZN3ccc8DD10x6y7C1Ev),
  NSPAIR(_ZN3ccc8DD10x6y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD10x6y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y7E[];
extern void _ZN3ccc8DD10x6y73pqrEv();
extern void _ZN3ccc8DD10x6y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x6y73abcEv,_ZTv0_n12_N3ccc8DD10x6y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y73abcEv,_ZThn4_N3ccc8DD10x6y73abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD10x6y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y73abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x6y73abcEv,_ZTv0_n12_N3ccc8DD10x6y73abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x6y7E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x6y7E[] = {
  {&(_ZTVN3ccc8DD10x6y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x6y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x6y7E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x6y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x6y7E[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x6y73abcEv,_ZTv0_n12_N3ccc8DD10x6y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y73abcEv,_ZThn4_N3ccc8DD10x6y73abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x6y7E = {  "_ZN3ccc8DD10x6y7E", // class name
  bases__ZN3ccc8DD10x6y7E, 2,
  &(vtc__ZN3ccc8DD10x6y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x6y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x6y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x6y7E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x6y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y8  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8CC10x6y83efgEv
  virtual void  abc(); // _ZN3ccc8CC10x6y83abcEv
  ~CC10x6y8(); // tgen
  CC10x6y8(); // tgen
};
//SIG(1 _ZN3ccc8CC10x6y8E) C1{ VBC2{ v3 v2} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x6y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x6y83efgEv");}
void  ccc::CC10x6y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x6y83abcEv");}
ccc::CC10x6y8 ::~CC10x6y8(){ note_dtor("_ZN3ccc8CC10x6y8E", this);} // tgen
ccc::CC10x6y8 ::CC10x6y8(){ note_ctor("_ZN3ccc8CC10x6y8E", this);} // tgen
}
static void Test__ZN3ccc8CC10x6y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x6y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x6y8E, buf);
    ::ccc::CC10x6y8 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x6y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x6y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x6y8E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC10x6y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x6y8E);
    dp->::ccc::CC10x6y8::~CC10x6y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x6y8E(Test__ZN3ccc8CC10x6y8E, "_ZN3ccc8CC10x6y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x6y8C1Ev();
extern void _ZN3ccc8CC10x6y8D1Ev();
Name_Map name_map__ZN3ccc8CC10x6y8E[] = {
  NSPAIR(_ZN3ccc8CC10x6y8C1Ev),
  NSPAIR(_ZN3ccc8CC10x6y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC10x6y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y8E[];
extern void _ZN3ccc8CC10x6y83abcEv();
extern void _ZN3ccc8CC10x6y83efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x6y83abcEv,_ZTv0_n16_N3ccc8CC10x6y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y83abcEv,_ZThn4_N3ccc8CC10x6y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x6y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y83efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x6y83abcEv,_ZTv0_n16_N3ccc8CC10x6y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x6y8E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x6y8E[] = {
  {&(_ZTVN3ccc8CC10x6y8E[3]),  3,11},
  {&(_ZTVN3ccc8CC10x6y8E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x6y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x6y8E[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x6y83abcEv,_ZTv0_n16_N3ccc8CC10x6y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y83abcEv,_ZThn4_N3ccc8CC10x6y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x6y8E = {  "_ZN3ccc8CC10x6y8E", // class name
  bases__ZN3ccc8CC10x6y8E, 2,
  &(vtc__ZN3ccc8CC10x6y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x6y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x6y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x6y8E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x6y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y8  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8DD10x6y83efgEv
  virtual void  abc(); // _ZN3ccc8DD10x6y83abcEv
  ~DD10x6y8(); // tgen
  DD10x6y8(); // tgen
};
//SIG(1 _ZN3ccc8DD10x6y8E) C1{ VBC2{ v3 v2} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x6y8 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x6y83efgEv");}
void  ccc::DD10x6y8 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x6y83abcEv");}
ccc::DD10x6y8 ::~DD10x6y8(){ note_dtor("_ZN3ccc8DD10x6y8E", this);} // tgen
ccc::DD10x6y8 ::DD10x6y8(){ note_ctor("_ZN3ccc8DD10x6y8E", this);} // tgen
}
static void Test__ZN3ccc8DD10x6y8E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x6y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x6y8E, buf);
    ::ccc::DD10x6y8 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x6y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x6y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x6y8E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD10x6y8E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x6y8E);
    dp->::ccc::DD10x6y8::~DD10x6y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x6y8E(Test__ZN3ccc8DD10x6y8E, "_ZN3ccc8DD10x6y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x6y8C1Ev();
extern void _ZN3ccc8DD10x6y8D1Ev();
Name_Map name_map__ZN3ccc8DD10x6y8E[] = {
  NSPAIR(_ZN3ccc8DD10x6y8C1Ev),
  NSPAIR(_ZN3ccc8DD10x6y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD10x6y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x6y83abcEv();
extern void _ZN3ccc8DD10x6y83efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x6y83abcEv,_ZTv0_n12_N3ccc8DD10x6y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y83abcEv,_ZThn4_N3ccc8DD10x6y83abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x6y83efgEv,_ZTv0_n16_N3ccc8DD10x6y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y83efgEv,_ZThn4_N3ccc8DD10x6y83efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x6y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y83efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x6y83abcEv,_ZTv0_n12_N3ccc8DD10x6y83abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x6y83efgEv,_ZTv0_n16_N3ccc8DD10x6y83efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x6y8E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x6y8E[] = {
  {&(_ZTVN3ccc8DD10x6y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y8E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x6y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x6y8E[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x6y83efgEv,_ZTv0_n16_N3ccc8DD10x6y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y83efgEv,_ZThn4_N3ccc8DD10x6y83efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x6y83abcEv,_ZTv0_n12_N3ccc8DD10x6y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y83abcEv,_ZThn4_N3ccc8DD10x6y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x6y8E = {  "_ZN3ccc8DD10x6y8E", // class name
  bases__ZN3ccc8DD10x6y8E, 2,
  &(vtc__ZN3ccc8DD10x6y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x6y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x6y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x6y8E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x6y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y9  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8CC10x6y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x6y93pqrEv
  ~CC10x6y9(); // tgen
  CC10x6y9(); // tgen
};
//SIG(1 _ZN3ccc8CC10x6y9E) C1{ VBC2{ v2 v3} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x6y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x6y93efgEv");}
void  ccc::CC10x6y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x6y93pqrEv");}
ccc::CC10x6y9 ::~CC10x6y9(){ note_dtor("_ZN3ccc8CC10x6y9E", this);} // tgen
ccc::CC10x6y9 ::CC10x6y9(){ note_ctor("_ZN3ccc8CC10x6y9E", this);} // tgen
}
static void Test__ZN3ccc8CC10x6y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x6y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x6y9E, buf);
    ::ccc::CC10x6y9 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x6y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x6y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x6y9E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC10x6y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x6y9E);
    dp->::ccc::CC10x6y9::~CC10x6y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x6y9E(Test__ZN3ccc8CC10x6y9E, "_ZN3ccc8CC10x6y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x6y9C1Ev();
extern void _ZN3ccc8CC10x6y9D1Ev();
Name_Map name_map__ZN3ccc8CC10x6y9E[] = {
  NSPAIR(_ZN3ccc8CC10x6y9C1Ev),
  NSPAIR(_ZN3ccc8CC10x6y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC10x6y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y9E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc8CC10x6y93efgEv();
extern void _ZN3ccc8CC10x6y93pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x6y93pqrEv,_ZTv0_n12_N3ccc8CC10x6y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x6y93pqrEv,_ZThn4_N3ccc8CC10x6y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC10x6y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x6y93pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x6y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x6y93pqrEv,_ZTv0_n12_N3ccc8CC10x6y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x6y9E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x6y9E[] = {
  {&(_ZTVN3ccc8CC10x6y9E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x6y9E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x6y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x6y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x6y9E[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x6y93pqrEv,_ZTv0_n12_N3ccc8CC10x6y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x6y93pqrEv,_ZThn4_N3ccc8CC10x6y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x6y9E = {  "_ZN3ccc8CC10x6y9E", // class name
  bases__ZN3ccc8CC10x6y9E, 2,
  &(vtc__ZN3ccc8CC10x6y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x6y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x6y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x6y9E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x6y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y9  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8DD10x6y93efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x6y93pqrEv
  ~DD10x6y9(); // tgen
  DD10x6y9(); // tgen
};
//SIG(1 _ZN3ccc8DD10x6y9E) C1{ VBC2{ v2 v3} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x6y9 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x6y93efgEv");}
void  ccc::DD10x6y9 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x6y93pqrEv");}
ccc::DD10x6y9 ::~DD10x6y9(){ note_dtor("_ZN3ccc8DD10x6y9E", this);} // tgen
ccc::DD10x6y9 ::DD10x6y9(){ note_ctor("_ZN3ccc8DD10x6y9E", this);} // tgen
}
static void Test__ZN3ccc8DD10x6y9E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x6y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x6y9E, buf);
    ::ccc::DD10x6y9 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x6y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x6y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x6y9E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD10x6y9E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x6y9E);
    dp->::ccc::DD10x6y9::~DD10x6y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x6y9E(Test__ZN3ccc8DD10x6y9E, "_ZN3ccc8DD10x6y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x6y9C1Ev();
extern void _ZN3ccc8DD10x6y9D1Ev();
Name_Map name_map__ZN3ccc8DD10x6y9E[] = {
  NSPAIR(_ZN3ccc8DD10x6y9C1Ev),
  NSPAIR(_ZN3ccc8DD10x6y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD10x6y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y9E[];
extern void _ZN3ccc8DD10x6y93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc8DD10x6y93efgEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x6y93efgEv,_ZTv0_n16_N3ccc8DD10x6y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x6y93efgEv,_ZThn4_N3ccc8DD10x6y93efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x6y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x6y93efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x6y93efgEv,_ZTv0_n16_N3ccc8DD10x6y93efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x6y9E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x6y9E[] = {
  {&(_ZTVN3ccc8DD10x6y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x6y9E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x6y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x6y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x6y9E[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x6y93efgEv,_ZTv0_n16_N3ccc8DD10x6y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x6y93efgEv,_ZThn4_N3ccc8DD10x6y93efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x6y9E = {  "_ZN3ccc8DD10x6y9E", // class name
  bases__ZN3ccc8DD10x6y9E, 2,
  &(vtc__ZN3ccc8DD10x6y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x6y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x6y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x6y9E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x6y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y10  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc9CC10x6y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x6y103abcEv
  ~CC10x6y10(); // tgen
  CC10x6y10(); // tgen
};
//SIG(1 _ZN3ccc9CC10x6y10E) C1{ VBC2{ v1 v2} BC3{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::CC10x6y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x6y103pqrEv");}
void  ccc::CC10x6y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x6y103abcEv");}
ccc::CC10x6y10 ::~CC10x6y10(){ note_dtor("_ZN3ccc9CC10x6y10E", this);} // tgen
ccc::CC10x6y10 ::CC10x6y10(){ note_ctor("_ZN3ccc9CC10x6y10E", this);} // tgen
}
static void Test__ZN3ccc9CC10x6y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x6y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x6y10E, buf);
    ::ccc::CC10x6y10 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x6y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x6y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x6y10E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc9CC10x6y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x6y10E);
    dp->::ccc::CC10x6y10::~CC10x6y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x6y10E(Test__ZN3ccc9CC10x6y10E, "_ZN3ccc9CC10x6y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x6y10C1Ev();
extern void _ZN3ccc9CC10x6y10D1Ev();
Name_Map name_map__ZN3ccc9CC10x6y10E[] = {
  NSPAIR(_ZN3ccc9CC10x6y10C1Ev),
  NSPAIR(_ZN3ccc9CC10x6y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9CC10x6y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y10E[];
extern void _ZN3ccc9CC10x6y103abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc9CC10x6y103pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x6y103pqrEv,_ZTv0_n12_N3ccc9CC10x6y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x6y103pqrEv,_ZThn4_N3ccc9CC10x6y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x6y103abcEv,_ZTv0_n16_N3ccc9CC10x6y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x6y103abcEv,_ZThn4_N3ccc9CC10x6y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x6y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y103pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x6y103pqrEv,_ZTv0_n12_N3ccc9CC10x6y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x6y103abcEv,_ZTv0_n16_N3ccc9CC10x6y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x6y10E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x6y10E[] = {
  {&(_ZTVN3ccc9CC10x6y10E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x6y10E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x6y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x6y10E[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x6y103abcEv,_ZTv0_n16_N3ccc9CC10x6y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x6y103abcEv,_ZThn4_N3ccc9CC10x6y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x6y103pqrEv,_ZTv0_n12_N3ccc9CC10x6y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x6y103pqrEv,_ZThn4_N3ccc9CC10x6y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x6y10E = {  "_ZN3ccc9CC10x6y10E", // class name
  bases__ZN3ccc9CC10x6y10E, 2,
  &(vtc__ZN3ccc9CC10x6y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x6y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x6y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x6y10E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x6y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y10  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc9DD10x6y103pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x6y103abcEv
  ~DD10x6y10(); // tgen
  DD10x6y10(); // tgen
};
//SIG(1 _ZN3ccc9DD10x6y10E) C1{ VBC2{ v1 v2} VBC3{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::DD10x6y10 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x6y103pqrEv");}
void  ccc::DD10x6y10 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x6y103abcEv");}
ccc::DD10x6y10 ::~DD10x6y10(){ note_dtor("_ZN3ccc9DD10x6y10E", this);} // tgen
ccc::DD10x6y10 ::DD10x6y10(){ note_ctor("_ZN3ccc9DD10x6y10E", this);} // tgen
}
static void Test__ZN3ccc9DD10x6y10E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x6y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x6y10E, buf);
    ::ccc::DD10x6y10 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x6y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x6y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x6y10E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc9DD10x6y10E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x6y10E);
    dp->::ccc::DD10x6y10::~DD10x6y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x6y10E(Test__ZN3ccc9DD10x6y10E, "_ZN3ccc9DD10x6y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x6y10C1Ev();
extern void _ZN3ccc9DD10x6y10D1Ev();
Name_Map name_map__ZN3ccc9DD10x6y10E[] = {
  NSPAIR(_ZN3ccc9DD10x6y10C1Ev),
  NSPAIR(_ZN3ccc9DD10x6y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9DD10x6y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y10E[];
extern void _ZN3ccc9DD10x6y103pqrEv();
extern void _ZN3ccc9DD10x6y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x6y103abcEv,_ZTv0_n12_N3ccc9DD10x6y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x6y103abcEv,_ZThn4_N3ccc9DD10x6y103abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x6y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x6y103abcEv,_ZTv0_n12_N3ccc9DD10x6y103abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x6y10E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x6y10E[] = {
  {&(_ZTVN3ccc9DD10x6y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y10E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x6y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x6y10E[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x6y103abcEv,_ZTv0_n12_N3ccc9DD10x6y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x6y103abcEv,_ZThn4_N3ccc9DD10x6y103abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x6y10E = {  "_ZN3ccc9DD10x6y10E", // class name
  bases__ZN3ccc9DD10x6y10E, 2,
  &(vtc__ZN3ccc9DD10x6y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x6y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x6y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x6y10E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x6y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y11  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc9CC10x6y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x6y113efgEv
  ~CC10x6y11(); // tgen
  CC10x6y11(); // tgen
};
//SIG(1 _ZN3ccc9CC10x6y11E) C1{ VBC2{ v1 v3} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x6y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x6y113pqrEv");}
void  ccc::CC10x6y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x6y113efgEv");}
ccc::CC10x6y11 ::~CC10x6y11(){ note_dtor("_ZN3ccc9CC10x6y11E", this);} // tgen
ccc::CC10x6y11 ::CC10x6y11(){ note_ctor("_ZN3ccc9CC10x6y11E", this);} // tgen
}
static void Test__ZN3ccc9CC10x6y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x6y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x6y11E, buf);
    ::ccc::CC10x6y11 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x6y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x6y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x6y11E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc9CC10x6y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x6y11E);
    dp->::ccc::CC10x6y11::~CC10x6y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x6y11E(Test__ZN3ccc9CC10x6y11E, "_ZN3ccc9CC10x6y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x6y11C1Ev();
extern void _ZN3ccc9CC10x6y11D1Ev();
Name_Map name_map__ZN3ccc9CC10x6y11E[] = {
  NSPAIR(_ZN3ccc9CC10x6y11C1Ev),
  NSPAIR(_ZN3ccc9CC10x6y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9CC10x6y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y11E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc9CC10x6y113efgEv();
extern void _ZN3ccc9CC10x6y113pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x6y113pqrEv,_ZTv0_n12_N3ccc9CC10x6y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x6y113pqrEv,_ZThn4_N3ccc9CC10x6y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x6y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y113pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x6y113pqrEv,_ZTv0_n12_N3ccc9CC10x6y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x6y11E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x6y11E[] = {
  {&(_ZTVN3ccc9CC10x6y11E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x6y11E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x6y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x6y11E[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x6y113pqrEv,_ZTv0_n12_N3ccc9CC10x6y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x6y113pqrEv,_ZThn4_N3ccc9CC10x6y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x6y11E = {  "_ZN3ccc9CC10x6y11E", // class name
  bases__ZN3ccc9CC10x6y11E, 2,
  &(vtc__ZN3ccc9CC10x6y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x6y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x6y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x6y11E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x6y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y11  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc9DD10x6y113pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x6y113efgEv
  ~DD10x6y11(); // tgen
  DD10x6y11(); // tgen
};
//SIG(1 _ZN3ccc9DD10x6y11E) C1{ VBC2{ v1 v3} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x6y11 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x6y113pqrEv");}
void  ccc::DD10x6y11 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x6y113efgEv");}
ccc::DD10x6y11 ::~DD10x6y11(){ note_dtor("_ZN3ccc9DD10x6y11E", this);} // tgen
ccc::DD10x6y11 ::DD10x6y11(){ note_ctor("_ZN3ccc9DD10x6y11E", this);} // tgen
}
static void Test__ZN3ccc9DD10x6y11E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x6y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x6y11E, buf);
    ::ccc::DD10x6y11 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x6y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x6y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x6y11E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc9DD10x6y11E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x6y11E);
    dp->::ccc::DD10x6y11::~DD10x6y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x6y11E(Test__ZN3ccc9DD10x6y11E, "_ZN3ccc9DD10x6y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x6y11C1Ev();
extern void _ZN3ccc9DD10x6y11D1Ev();
Name_Map name_map__ZN3ccc9DD10x6y11E[] = {
  NSPAIR(_ZN3ccc9DD10x6y11C1Ev),
  NSPAIR(_ZN3ccc9DD10x6y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9DD10x6y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y11E[];
extern void _ZN3ccc9DD10x6y113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x6y113efgEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x6y113efgEv,_ZTv0_n16_N3ccc9DD10x6y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x6y113efgEv,_ZThn4_N3ccc9DD10x6y113efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x6y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y113efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x6y113efgEv,_ZTv0_n16_N3ccc9DD10x6y113efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x6y11E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x6y11E[] = {
  {&(_ZTVN3ccc9DD10x6y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x6y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x6y11E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x6y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x6y11E[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x6y113efgEv,_ZTv0_n16_N3ccc9DD10x6y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x6y113efgEv,_ZThn4_N3ccc9DD10x6y113efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x6y11E = {  "_ZN3ccc9DD10x6y11E", // class name
  bases__ZN3ccc9DD10x6y11E, 2,
  &(vtc__ZN3ccc9DD10x6y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x6y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x6y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x6y11E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x6y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y12  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc9CC10x6y123abcEv
  ~CC10x6y12(); // tgen
  CC10x6y12(); // tgen
};
//SIG(1 _ZN3ccc9CC10x6y12E) C1{ VBC2{ v2 v1} BC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::CC10x6y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x6y123abcEv");}
ccc::CC10x6y12 ::~CC10x6y12(){ note_dtor("_ZN3ccc9CC10x6y12E", this);} // tgen
ccc::CC10x6y12 ::CC10x6y12(){ note_ctor("_ZN3ccc9CC10x6y12E", this);} // tgen
}
static void Test__ZN3ccc9CC10x6y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x6y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x6y12E, buf);
    ::ccc::CC10x6y12 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x6y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x6y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x6y12E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc9CC10x6y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x6y12E);
    dp->::ccc::CC10x6y12::~CC10x6y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x6y12E(Test__ZN3ccc9CC10x6y12E, "_ZN3ccc9CC10x6y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x6y12C1Ev();
extern void _ZN3ccc9CC10x6y12D1Ev();
Name_Map name_map__ZN3ccc9CC10x6y12E[] = {
  NSPAIR(_ZN3ccc9CC10x6y12C1Ev),
  NSPAIR(_ZN3ccc9CC10x6y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9CC10x6y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y12E[];
extern void _ZN3ccc9CC10x6y123abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x6y123abcEv,_ZTv0_n16_N3ccc9CC10x6y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x6y123abcEv,_ZThn4_N3ccc9CC10x6y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x6y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x6y123abcEv,_ZTv0_n16_N3ccc9CC10x6y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x6y12E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x6y12E[] = {
  {&(_ZTVN3ccc9CC10x6y12E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x6y12E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x6y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x6y12E[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x6y123abcEv,_ZTv0_n16_N3ccc9CC10x6y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x6y123abcEv,_ZThn4_N3ccc9CC10x6y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x6y12E = {  "_ZN3ccc9CC10x6y12E", // class name
  bases__ZN3ccc9CC10x6y12E, 2,
  &(vtc__ZN3ccc9CC10x6y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x6y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x6y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x6y12E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x6y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y12  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc9DD10x6y123abcEv
  ~DD10x6y12(); // tgen
  DD10x6y12(); // tgen
};
//SIG(1 _ZN3ccc9DD10x6y12E) C1{ VBC2{ v2 v1} VBC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::DD10x6y12 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x6y123abcEv");}
ccc::DD10x6y12 ::~DD10x6y12(){ note_dtor("_ZN3ccc9DD10x6y12E", this);} // tgen
ccc::DD10x6y12 ::DD10x6y12(){ note_ctor("_ZN3ccc9DD10x6y12E", this);} // tgen
}
static void Test__ZN3ccc9DD10x6y12E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x6y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x6y12E, buf);
    ::ccc::DD10x6y12 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x6y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x6y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x6y12E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc9DD10x6y12E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x6y12E);
    dp->::ccc::DD10x6y12::~DD10x6y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x6y12E(Test__ZN3ccc9DD10x6y12E, "_ZN3ccc9DD10x6y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x6y12C1Ev();
extern void _ZN3ccc9DD10x6y12D1Ev();
Name_Map name_map__ZN3ccc9DD10x6y12E[] = {
  NSPAIR(_ZN3ccc9DD10x6y12C1Ev),
  NSPAIR(_ZN3ccc9DD10x6y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9DD10x6y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x6y123abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x6y123abcEv,_ZTv0_n12_N3ccc9DD10x6y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x6y123abcEv,_ZThn4_N3ccc9DD10x6y123abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x6y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y123abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x6y123abcEv,_ZTv0_n12_N3ccc9DD10x6y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x6y12E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x6y12E[] = {
  {&(_ZTVN3ccc9DD10x6y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y12E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x6y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x6y12E[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x6y123abcEv,_ZTv0_n12_N3ccc9DD10x6y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x6y123abcEv,_ZThn4_N3ccc9DD10x6y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x6y12E = {  "_ZN3ccc9DD10x6y12E", // class name
  bases__ZN3ccc9DD10x6y12E, 2,
  &(vtc__ZN3ccc9DD10x6y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x6y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x6y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x6y12E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x6y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y13  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc9CC10x6y133efgEv
  ~CC10x6y13(); // tgen
  CC10x6y13(); // tgen
};
//SIG(1 _ZN3ccc9CC10x6y13E) C1{ VBC2{ v2 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC10x6y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x6y133efgEv");}
ccc::CC10x6y13 ::~CC10x6y13(){ note_dtor("_ZN3ccc9CC10x6y13E", this);} // tgen
ccc::CC10x6y13 ::CC10x6y13(){ note_ctor("_ZN3ccc9CC10x6y13E", this);} // tgen
}
static void Test__ZN3ccc9CC10x6y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x6y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x6y13E, buf);
    ::ccc::CC10x6y13 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x6y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x6y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x6y13E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc9CC10x6y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x6y13E);
    dp->::ccc::CC10x6y13::~CC10x6y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x6y13E(Test__ZN3ccc9CC10x6y13E, "_ZN3ccc9CC10x6y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x6y13C1Ev();
extern void _ZN3ccc9CC10x6y13D1Ev();
Name_Map name_map__ZN3ccc9CC10x6y13E[] = {
  NSPAIR(_ZN3ccc9CC10x6y13C1Ev),
  NSPAIR(_ZN3ccc9CC10x6y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9CC10x6y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y13E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc9CC10x6y133efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x6y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y133efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x6y13E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x6y13E[] = {
  {&(_ZTVN3ccc9CC10x6y13E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x6y13E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x6y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x6y13E[];
Class_Descriptor cd__ZN3ccc9CC10x6y13E = {  "_ZN3ccc9CC10x6y13E", // class name
  bases__ZN3ccc9CC10x6y13E, 2,
  &(vtc__ZN3ccc9CC10x6y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x6y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x6y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x6y13E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x6y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y13  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc9DD10x6y133efgEv
  ~DD10x6y13(); // tgen
  DD10x6y13(); // tgen
};
//SIG(1 _ZN3ccc9DD10x6y13E) C1{ VBC2{ v2 v3} VBC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::DD10x6y13 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x6y133efgEv");}
ccc::DD10x6y13 ::~DD10x6y13(){ note_dtor("_ZN3ccc9DD10x6y13E", this);} // tgen
ccc::DD10x6y13 ::DD10x6y13(){ note_ctor("_ZN3ccc9DD10x6y13E", this);} // tgen
}
static void Test__ZN3ccc9DD10x6y13E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x6y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x6y13E, buf);
    ::ccc::DD10x6y13 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x6y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x6y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x6y13E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc9DD10x6y13E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x6y13E);
    dp->::ccc::DD10x6y13::~DD10x6y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x6y13E(Test__ZN3ccc9DD10x6y13E, "_ZN3ccc9DD10x6y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x6y13C1Ev();
extern void _ZN3ccc9DD10x6y13D1Ev();
Name_Map name_map__ZN3ccc9DD10x6y13E[] = {
  NSPAIR(_ZN3ccc9DD10x6y13C1Ev),
  NSPAIR(_ZN3ccc9DD10x6y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9DD10x6y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x6y133efgEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x6y133efgEv,_ZTv0_n16_N3ccc9DD10x6y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x6y133efgEv,_ZThn4_N3ccc9DD10x6y133efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x6y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y133efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x6y133efgEv,_ZTv0_n16_N3ccc9DD10x6y133efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x6y13E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x6y13E[] = {
  {&(_ZTVN3ccc9DD10x6y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x6y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x6y13E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x6y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x6y13E[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x6y133efgEv,_ZTv0_n16_N3ccc9DD10x6y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x6y133efgEv,_ZThn4_N3ccc9DD10x6y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x6y13E = {  "_ZN3ccc9DD10x6y13E", // class name
  bases__ZN3ccc9DD10x6y13E, 2,
  &(vtc__ZN3ccc9DD10x6y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x6y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x6y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x6y13E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x6y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y14  : virtual ::ccc::AA10 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc9CC10x6y143pqrEv
  ~CC10x6y14(); // tgen
  CC10x6y14(); // tgen
};
//SIG(1 _ZN3ccc9CC10x6y14E) C1{ VBC2{ v1 v2} BC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::CC10x6y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x6y143pqrEv");}
ccc::CC10x6y14 ::~CC10x6y14(){ note_dtor("_ZN3ccc9CC10x6y14E", this);} // tgen
ccc::CC10x6y14 ::CC10x6y14(){ note_ctor("_ZN3ccc9CC10x6y14E", this);} // tgen
}
static void Test__ZN3ccc9CC10x6y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x6y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x6y14E, buf);
    ::ccc::CC10x6y14 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x6y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x6y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x6y14E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc9CC10x6y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x6y14E);
    dp->::ccc::CC10x6y14::~CC10x6y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x6y14E(Test__ZN3ccc9CC10x6y14E, "_ZN3ccc9CC10x6y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x6y14C1Ev();
extern void _ZN3ccc9CC10x6y14D1Ev();
Name_Map name_map__ZN3ccc9CC10x6y14E[] = {
  NSPAIR(_ZN3ccc9CC10x6y14C1Ev),
  NSPAIR(_ZN3ccc9CC10x6y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9CC10x6y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y14E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc9CC10x6y143pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x6y143pqrEv,_ZTv0_n12_N3ccc9CC10x6y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x6y143pqrEv,_ZThn4_N3ccc9CC10x6y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x6y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x6y143pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x6y143pqrEv,_ZTv0_n12_N3ccc9CC10x6y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x6y14E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x6y14E[] = {
  {&(_ZTVN3ccc9CC10x6y14E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x6y14E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x6y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x6y14E[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x6y143pqrEv,_ZTv0_n12_N3ccc9CC10x6y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x6y143pqrEv,_ZThn4_N3ccc9CC10x6y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x6y14E = {  "_ZN3ccc9CC10x6y14E", // class name
  bases__ZN3ccc9CC10x6y14E, 2,
  &(vtc__ZN3ccc9CC10x6y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x6y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x6y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x6y14E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x6y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y14  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc9DD10x6y143pqrEv
  ~DD10x6y14(); // tgen
  DD10x6y14(); // tgen
};
//SIG(1 _ZN3ccc9DD10x6y14E) C1{ VBC2{ v1 v2} VBC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::DD10x6y14 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x6y143pqrEv");}
ccc::DD10x6y14 ::~DD10x6y14(){ note_dtor("_ZN3ccc9DD10x6y14E", this);} // tgen
ccc::DD10x6y14 ::DD10x6y14(){ note_ctor("_ZN3ccc9DD10x6y14E", this);} // tgen
}
static void Test__ZN3ccc9DD10x6y14E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x6y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x6y14E, buf);
    ::ccc::DD10x6y14 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x6y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x6y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x6y14E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc9DD10x6y14E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x6y14E);
    dp->::ccc::DD10x6y14::~DD10x6y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x6y14E(Test__ZN3ccc9DD10x6y14E, "_ZN3ccc9DD10x6y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x6y14C1Ev();
extern void _ZN3ccc9DD10x6y14D1Ev();
Name_Map name_map__ZN3ccc9DD10x6y14E[] = {
  NSPAIR(_ZN3ccc9DD10x6y14C1Ev),
  NSPAIR(_ZN3ccc9DD10x6y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9DD10x6y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y14E[];
extern void _ZN3ccc9DD10x6y143pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x6y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x6y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x6y14E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x6y14E[] = {
  {&(_ZTVN3ccc9DD10x6y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y14E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x6y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x6y14E[];
Class_Descriptor cd__ZN3ccc9DD10x6y14E = {  "_ZN3ccc9DD10x6y14E", // class name
  bases__ZN3ccc9DD10x6y14E, 2,
  &(vtc__ZN3ccc9DD10x6y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x6y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x6y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x6y14E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x6y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x6y15  : virtual ::ccc::AA10 , ::ccc::BB6 {
  ~CC10x6y15(); // tgen
  CC10x6y15(); // tgen
};
//SIG(1 _ZN3ccc9CC10x6y15E) C1{ VBC2{ v1 v2} BC3{ v3 v4}}
}
namespace ccc { 
ccc::CC10x6y15 ::~CC10x6y15(){ note_dtor("_ZN3ccc9CC10x6y15E", this);} // tgen
ccc::CC10x6y15 ::CC10x6y15(){ note_ctor("_ZN3ccc9CC10x6y15E", this);} // tgen
}
static void Test__ZN3ccc9CC10x6y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x6y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x6y15E, buf);
    ::ccc::CC10x6y15 *dp, &lv = *(dp=new (buf) ::ccc::CC10x6y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x6y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x6y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x6y15E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc9CC10x6y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x6y15E);
    dp->::ccc::CC10x6y15::~CC10x6y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x6y15E(Test__ZN3ccc9CC10x6y15E, "_ZN3ccc9CC10x6y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x6y15C1Ev();
extern void _ZN3ccc9CC10x6y15D1Ev();
Name_Map name_map__ZN3ccc9CC10x6y15E[] = {
  NSPAIR(_ZN3ccc9CC10x6y15C1Ev),
  NSPAIR(_ZN3ccc9CC10x6y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9CC10x6y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y15E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x6y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x6y15E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x6y15E[] = {
  {&(_ZTVN3ccc9CC10x6y15E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x6y15E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x6y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x6y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x6y15E[];
Class_Descriptor cd__ZN3ccc9CC10x6y15E = {  "_ZN3ccc9CC10x6y15E", // class name
  bases__ZN3ccc9CC10x6y15E, 2,
  &(vtc__ZN3ccc9CC10x6y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x6y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x6y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x6y15E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x6y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x6y15  : virtual ::ccc::AA10 , virtual ::ccc::BB6 {
  ~DD10x6y15(); // tgen
  DD10x6y15(); // tgen
};
//SIG(1 _ZN3ccc9DD10x6y15E) C1{ VBC2{ v1 v2} VBC3{ v3 v4}}
}
namespace ccc { 
ccc::DD10x6y15 ::~DD10x6y15(){ note_dtor("_ZN3ccc9DD10x6y15E", this);} // tgen
ccc::DD10x6y15 ::DD10x6y15(){ note_ctor("_ZN3ccc9DD10x6y15E", this);} // tgen
}
static void Test__ZN3ccc9DD10x6y15E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x6y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x6y15E, buf);
    ::ccc::DD10x6y15 *dp, &lv = *(dp=new (buf) ::ccc::DD10x6y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x6y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x6y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x6y15E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc9DD10x6y15E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x6y15E);
    dp->::ccc::DD10x6y15::~DD10x6y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x6y15E(Test__ZN3ccc9DD10x6y15E, "_ZN3ccc9DD10x6y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x6y15C1Ev();
extern void _ZN3ccc9DD10x6y15D1Ev();
Name_Map name_map__ZN3ccc9DD10x6y15E[] = {
  NSPAIR(_ZN3ccc9DD10x6y15C1Ev),
  NSPAIR(_ZN3ccc9DD10x6y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc9DD10x6y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x6y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x6y15E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x6y15E[] = {
  {&(_ZTVN3ccc9DD10x6y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x6y15E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x6y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x6y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x6y15E[];
Class_Descriptor cd__ZN3ccc9DD10x6y15E = {  "_ZN3ccc9DD10x6y15E", // class name
  bases__ZN3ccc9DD10x6y15E, 2,
  &(vtc__ZN3ccc9DD10x6y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x6y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x6y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x6y15E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x6y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y0  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8CC10x7y03abcEv
  virtual void  efg(); // _ZN3ccc8CC10x7y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x7y03pqrEv
  ~CC10x7y0(); // tgen
  CC10x7y0(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y0E) C1{ VBC2{ v3 v1} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x7y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y03abcEv");}
void  ccc::CC10x7y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y03efgEv");}
void  ccc::CC10x7y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y03pqrEv");}
ccc::CC10x7y0 ::~CC10x7y0(){ note_dtor("_ZN3ccc8CC10x7y0E", this);} // tgen
ccc::CC10x7y0 ::CC10x7y0(){ note_ctor("_ZN3ccc8CC10x7y0E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y0E, buf);
    ::ccc::CC10x7y0 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y0E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y0E);
    dp->::ccc::CC10x7y0::~CC10x7y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y0E(Test__ZN3ccc8CC10x7y0E, "_ZN3ccc8CC10x7y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y0C1Ev();
extern void _ZN3ccc8CC10x7y0D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y0E[] = {
  NSPAIR(_ZN3ccc8CC10x7y0C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y0E[];
extern void _ZN3ccc8CC10x7y03abcEv();
extern void _ZN3ccc8CC10x7y03pqrEv();
extern void _ZN3ccc8CC10x7y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y03pqrEv,_ZTv0_n12_N3ccc8CC10x7y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y03pqrEv,_ZThn4_N3ccc8CC10x7y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y03abcEv,_ZTv0_n16_N3ccc8CC10x7y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y03abcEv,_ZThn4_N3ccc8CC10x7y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y03pqrEv,_ZTv0_n12_N3ccc8CC10x7y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y03abcEv,_ZTv0_n16_N3ccc8CC10x7y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y0E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y0E[] = {
  {&(_ZTVN3ccc8CC10x7y0E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y0E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y0E[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y03abcEv,_ZTv0_n16_N3ccc8CC10x7y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y03abcEv,_ZThn4_N3ccc8CC10x7y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y03pqrEv,_ZTv0_n12_N3ccc8CC10x7y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y03pqrEv,_ZThn4_N3ccc8CC10x7y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y0E = {  "_ZN3ccc8CC10x7y0E", // class name
  bases__ZN3ccc8CC10x7y0E, 2,
  &(vtc__ZN3ccc8CC10x7y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y0E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y0  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8DD10x7y03abcEv
  virtual void  efg(); // _ZN3ccc8DD10x7y03efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x7y03pqrEv
  ~DD10x7y0(); // tgen
  DD10x7y0(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y0E) C1{ VBC2{ v3 v1} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x7y0 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y03abcEv");}
void  ccc::DD10x7y0 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y03efgEv");}
void  ccc::DD10x7y0 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y03pqrEv");}
ccc::DD10x7y0 ::~DD10x7y0(){ note_dtor("_ZN3ccc8DD10x7y0E", this);} // tgen
ccc::DD10x7y0 ::DD10x7y0(){ note_ctor("_ZN3ccc8DD10x7y0E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y0E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y0E, buf);
    ::ccc::DD10x7y0 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y0E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y0E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y0E);
    dp->::ccc::DD10x7y0::~DD10x7y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y0E(Test__ZN3ccc8DD10x7y0E, "_ZN3ccc8DD10x7y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y0C1Ev();
extern void _ZN3ccc8DD10x7y0D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y0E[] = {
  NSPAIR(_ZN3ccc8DD10x7y0C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y0E[];
extern void _ZN3ccc8DD10x7y03pqrEv();
extern void _ZN3ccc8DD10x7y03abcEv();
extern void _ZN3ccc8DD10x7y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y03abcEv,_ZTv0_n12_N3ccc8DD10x7y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y03abcEv,_ZThn4_N3ccc8DD10x7y03abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y03pqrEv,_ZTv0_n16_N3ccc8DD10x7y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y03pqrEv,_ZThn4_N3ccc8DD10x7y03pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y03abcEv,_ZTv0_n12_N3ccc8DD10x7y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y03pqrEv,_ZTv0_n16_N3ccc8DD10x7y03pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y0E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y0E[] = {
  {&(_ZTVN3ccc8DD10x7y0E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y0E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y0E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y0E[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y03pqrEv,_ZTv0_n16_N3ccc8DD10x7y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y03pqrEv,_ZThn4_N3ccc8DD10x7y03pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y03abcEv,_ZTv0_n12_N3ccc8DD10x7y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y03abcEv,_ZThn4_N3ccc8DD10x7y03abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y0E = {  "_ZN3ccc8DD10x7y0E", // class name
  bases__ZN3ccc8DD10x7y0E, 2,
  &(vtc__ZN3ccc8DD10x7y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y0E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y1  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8CC10x7y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x7y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x7y13efgEv
  ~CC10x7y1(); // tgen
  CC10x7y1(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y1E) C1{ VBC2{ v2 v1} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x7y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y13abcEv");}
void  ccc::CC10x7y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y13pqrEv");}
void  ccc::CC10x7y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y13efgEv");}
ccc::CC10x7y1 ::~CC10x7y1(){ note_dtor("_ZN3ccc8CC10x7y1E", this);} // tgen
ccc::CC10x7y1 ::CC10x7y1(){ note_ctor("_ZN3ccc8CC10x7y1E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y1E, buf);
    ::ccc::CC10x7y1 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y1E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y1E);
    dp->::ccc::CC10x7y1::~CC10x7y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y1E(Test__ZN3ccc8CC10x7y1E, "_ZN3ccc8CC10x7y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y1C1Ev();
extern void _ZN3ccc8CC10x7y1D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y1E[] = {
  NSPAIR(_ZN3ccc8CC10x7y1C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y1E[];
extern void _ZN3ccc8CC10x7y13abcEv();
extern void _ZN3ccc8CC10x7y13pqrEv();
extern void _ZN3ccc8CC10x7y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y13pqrEv,_ZTv0_n12_N3ccc8CC10x7y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y13pqrEv,_ZThn4_N3ccc8CC10x7y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y13abcEv,_ZTv0_n16_N3ccc8CC10x7y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y13abcEv,_ZThn4_N3ccc8CC10x7y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y13pqrEv,_ZTv0_n12_N3ccc8CC10x7y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y13abcEv,_ZTv0_n16_N3ccc8CC10x7y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y1E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y1E[] = {
  {&(_ZTVN3ccc8CC10x7y1E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y1E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y1E[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y13abcEv,_ZTv0_n16_N3ccc8CC10x7y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y13abcEv,_ZThn4_N3ccc8CC10x7y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y13pqrEv,_ZTv0_n12_N3ccc8CC10x7y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y13pqrEv,_ZThn4_N3ccc8CC10x7y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y1E = {  "_ZN3ccc8CC10x7y1E", // class name
  bases__ZN3ccc8CC10x7y1E, 2,
  &(vtc__ZN3ccc8CC10x7y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y1E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y1  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8DD10x7y13abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x7y13pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x7y13efgEv
  ~DD10x7y1(); // tgen
  DD10x7y1(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y1E) C1{ VBC2{ v2 v1} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x7y1 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y13abcEv");}
void  ccc::DD10x7y1 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y13pqrEv");}
void  ccc::DD10x7y1 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y13efgEv");}
ccc::DD10x7y1 ::~DD10x7y1(){ note_dtor("_ZN3ccc8DD10x7y1E", this);} // tgen
ccc::DD10x7y1 ::DD10x7y1(){ note_ctor("_ZN3ccc8DD10x7y1E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y1E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y1E, buf);
    ::ccc::DD10x7y1 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y1E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y1E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y1E);
    dp->::ccc::DD10x7y1::~DD10x7y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y1E(Test__ZN3ccc8DD10x7y1E, "_ZN3ccc8DD10x7y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y1C1Ev();
extern void _ZN3ccc8DD10x7y1D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y1E[] = {
  NSPAIR(_ZN3ccc8DD10x7y1C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y1E[];
extern void _ZN3ccc8DD10x7y13pqrEv();
extern void _ZN3ccc8DD10x7y13abcEv();
extern void _ZN3ccc8DD10x7y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y13abcEv,_ZTv0_n12_N3ccc8DD10x7y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y13abcEv,_ZThn4_N3ccc8DD10x7y13abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y13pqrEv,_ZTv0_n16_N3ccc8DD10x7y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y13pqrEv,_ZThn4_N3ccc8DD10x7y13pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y13abcEv,_ZTv0_n12_N3ccc8DD10x7y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y13pqrEv,_ZTv0_n16_N3ccc8DD10x7y13pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y1E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y1E[] = {
  {&(_ZTVN3ccc8DD10x7y1E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y1E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y1E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y1E[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y13pqrEv,_ZTv0_n16_N3ccc8DD10x7y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y13pqrEv,_ZThn4_N3ccc8DD10x7y13pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y13abcEv,_ZTv0_n12_N3ccc8DD10x7y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y13abcEv,_ZThn4_N3ccc8DD10x7y13abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y1E = {  "_ZN3ccc8DD10x7y1E", // class name
  bases__ZN3ccc8DD10x7y1E, 2,
  &(vtc__ZN3ccc8DD10x7y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y1E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y2  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8CC10x7y23efgEv
  virtual void  abc(); // _ZN3ccc8CC10x7y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x7y23pqrEv
  ~CC10x7y2(); // tgen
  CC10x7y2(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y2E) C1{ VBC2{ v3 v2} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x7y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y23efgEv");}
void  ccc::CC10x7y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y23abcEv");}
void  ccc::CC10x7y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y23pqrEv");}
ccc::CC10x7y2 ::~CC10x7y2(){ note_dtor("_ZN3ccc8CC10x7y2E", this);} // tgen
ccc::CC10x7y2 ::CC10x7y2(){ note_ctor("_ZN3ccc8CC10x7y2E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y2E, buf);
    ::ccc::CC10x7y2 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y2E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y2E);
    dp->::ccc::CC10x7y2::~CC10x7y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y2E(Test__ZN3ccc8CC10x7y2E, "_ZN3ccc8CC10x7y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y2C1Ev();
extern void _ZN3ccc8CC10x7y2D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y2E[] = {
  NSPAIR(_ZN3ccc8CC10x7y2C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y2E[];
extern void _ZN3ccc8CC10x7y23abcEv();
extern void _ZN3ccc8CC10x7y23pqrEv();
extern void _ZN3ccc8CC10x7y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y23pqrEv,_ZTv0_n12_N3ccc8CC10x7y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y23pqrEv,_ZThn4_N3ccc8CC10x7y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y23abcEv,_ZTv0_n16_N3ccc8CC10x7y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y23abcEv,_ZThn4_N3ccc8CC10x7y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y23pqrEv,_ZTv0_n12_N3ccc8CC10x7y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y23abcEv,_ZTv0_n16_N3ccc8CC10x7y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y2E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y2E[] = {
  {&(_ZTVN3ccc8CC10x7y2E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y2E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y2E[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y23abcEv,_ZTv0_n16_N3ccc8CC10x7y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y23abcEv,_ZThn4_N3ccc8CC10x7y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y23pqrEv,_ZTv0_n12_N3ccc8CC10x7y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y23pqrEv,_ZThn4_N3ccc8CC10x7y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y2E = {  "_ZN3ccc8CC10x7y2E", // class name
  bases__ZN3ccc8CC10x7y2E, 2,
  &(vtc__ZN3ccc8CC10x7y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y2E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y2  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8DD10x7y23efgEv
  virtual void  abc(); // _ZN3ccc8DD10x7y23abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x7y23pqrEv
  ~DD10x7y2(); // tgen
  DD10x7y2(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y2E) C1{ VBC2{ v3 v2} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x7y2 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y23efgEv");}
void  ccc::DD10x7y2 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y23abcEv");}
void  ccc::DD10x7y2 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y23pqrEv");}
ccc::DD10x7y2 ::~DD10x7y2(){ note_dtor("_ZN3ccc8DD10x7y2E", this);} // tgen
ccc::DD10x7y2 ::DD10x7y2(){ note_ctor("_ZN3ccc8DD10x7y2E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y2E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y2E, buf);
    ::ccc::DD10x7y2 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y2E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y2E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y2E);
    dp->::ccc::DD10x7y2::~DD10x7y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y2E(Test__ZN3ccc8DD10x7y2E, "_ZN3ccc8DD10x7y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y2C1Ev();
extern void _ZN3ccc8DD10x7y2D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y2E[] = {
  NSPAIR(_ZN3ccc8DD10x7y2C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y2E[];
extern void _ZN3ccc8DD10x7y23pqrEv();
extern void _ZN3ccc8DD10x7y23abcEv();
extern void _ZN3ccc8DD10x7y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y23abcEv,_ZTv0_n12_N3ccc8DD10x7y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y23abcEv,_ZThn4_N3ccc8DD10x7y23abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y23pqrEv,_ZTv0_n16_N3ccc8DD10x7y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y23pqrEv,_ZThn4_N3ccc8DD10x7y23pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y23abcEv,_ZTv0_n12_N3ccc8DD10x7y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y23pqrEv,_ZTv0_n16_N3ccc8DD10x7y23pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y2E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y2E[] = {
  {&(_ZTVN3ccc8DD10x7y2E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y2E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y2E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y2E[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y23pqrEv,_ZTv0_n16_N3ccc8DD10x7y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y23pqrEv,_ZThn4_N3ccc8DD10x7y23pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y23abcEv,_ZTv0_n12_N3ccc8DD10x7y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y23abcEv,_ZThn4_N3ccc8DD10x7y23abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y2E = {  "_ZN3ccc8DD10x7y2E", // class name
  bases__ZN3ccc8DD10x7y2E, 2,
  &(vtc__ZN3ccc8DD10x7y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y2E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y3  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8CC10x7y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x7y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x7y33abcEv
  ~CC10x7y3(); // tgen
  CC10x7y3(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y3E) C1{ VBC2{ v2 v3} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x7y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y33efgEv");}
void  ccc::CC10x7y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y33pqrEv");}
void  ccc::CC10x7y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y33abcEv");}
ccc::CC10x7y3 ::~CC10x7y3(){ note_dtor("_ZN3ccc8CC10x7y3E", this);} // tgen
ccc::CC10x7y3 ::CC10x7y3(){ note_ctor("_ZN3ccc8CC10x7y3E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y3E, buf);
    ::ccc::CC10x7y3 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y3E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y3E);
    dp->::ccc::CC10x7y3::~CC10x7y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y3E(Test__ZN3ccc8CC10x7y3E, "_ZN3ccc8CC10x7y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y3C1Ev();
extern void _ZN3ccc8CC10x7y3D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y3E[] = {
  NSPAIR(_ZN3ccc8CC10x7y3C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y3E[];
extern void _ZN3ccc8CC10x7y33abcEv();
extern void _ZN3ccc8CC10x7y33pqrEv();
extern void _ZN3ccc8CC10x7y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y33pqrEv,_ZTv0_n12_N3ccc8CC10x7y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y33pqrEv,_ZThn4_N3ccc8CC10x7y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y33abcEv,_ZTv0_n16_N3ccc8CC10x7y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y33abcEv,_ZThn4_N3ccc8CC10x7y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y33pqrEv,_ZTv0_n12_N3ccc8CC10x7y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y33abcEv,_ZTv0_n16_N3ccc8CC10x7y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y3E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y3E[] = {
  {&(_ZTVN3ccc8CC10x7y3E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y3E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y3E[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y33abcEv,_ZTv0_n16_N3ccc8CC10x7y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y33abcEv,_ZThn4_N3ccc8CC10x7y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y33pqrEv,_ZTv0_n12_N3ccc8CC10x7y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y33pqrEv,_ZThn4_N3ccc8CC10x7y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y3E = {  "_ZN3ccc8CC10x7y3E", // class name
  bases__ZN3ccc8CC10x7y3E, 2,
  &(vtc__ZN3ccc8CC10x7y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y3E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y3  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8DD10x7y33efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x7y33pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x7y33abcEv
  ~DD10x7y3(); // tgen
  DD10x7y3(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y3E) C1{ VBC2{ v2 v3} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x7y3 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y33efgEv");}
void  ccc::DD10x7y3 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y33pqrEv");}
void  ccc::DD10x7y3 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y33abcEv");}
ccc::DD10x7y3 ::~DD10x7y3(){ note_dtor("_ZN3ccc8DD10x7y3E", this);} // tgen
ccc::DD10x7y3 ::DD10x7y3(){ note_ctor("_ZN3ccc8DD10x7y3E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y3E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y3E, buf);
    ::ccc::DD10x7y3 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y3E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y3E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y3E);
    dp->::ccc::DD10x7y3::~DD10x7y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y3E(Test__ZN3ccc8DD10x7y3E, "_ZN3ccc8DD10x7y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y3C1Ev();
extern void _ZN3ccc8DD10x7y3D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y3E[] = {
  NSPAIR(_ZN3ccc8DD10x7y3C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y3E[];
extern void _ZN3ccc8DD10x7y33pqrEv();
extern void _ZN3ccc8DD10x7y33abcEv();
extern void _ZN3ccc8DD10x7y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y33abcEv,_ZTv0_n12_N3ccc8DD10x7y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y33abcEv,_ZThn4_N3ccc8DD10x7y33abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y33pqrEv,_ZTv0_n16_N3ccc8DD10x7y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y33pqrEv,_ZThn4_N3ccc8DD10x7y33pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y33abcEv,_ZTv0_n12_N3ccc8DD10x7y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y33pqrEv,_ZTv0_n16_N3ccc8DD10x7y33pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y3E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y3E[] = {
  {&(_ZTVN3ccc8DD10x7y3E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y3E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y3E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y3E[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y33pqrEv,_ZTv0_n16_N3ccc8DD10x7y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y33pqrEv,_ZThn4_N3ccc8DD10x7y33pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y33abcEv,_ZTv0_n12_N3ccc8DD10x7y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y33abcEv,_ZThn4_N3ccc8DD10x7y33abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y3E = {  "_ZN3ccc8DD10x7y3E", // class name
  bases__ZN3ccc8DD10x7y3E, 2,
  &(vtc__ZN3ccc8DD10x7y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y3E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y4  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC10x7y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x7y43abcEv
  virtual void  efg(); // _ZN3ccc8CC10x7y43efgEv
  ~CC10x7y4(); // tgen
  CC10x7y4(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y4E) C1{ VBC2{ v1 v2} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x7y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y43pqrEv");}
void  ccc::CC10x7y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y43abcEv");}
void  ccc::CC10x7y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y43efgEv");}
ccc::CC10x7y4 ::~CC10x7y4(){ note_dtor("_ZN3ccc8CC10x7y4E", this);} // tgen
ccc::CC10x7y4 ::CC10x7y4(){ note_ctor("_ZN3ccc8CC10x7y4E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y4E, buf);
    ::ccc::CC10x7y4 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y4E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y4E);
    dp->::ccc::CC10x7y4::~CC10x7y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y4E(Test__ZN3ccc8CC10x7y4E, "_ZN3ccc8CC10x7y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y4C1Ev();
extern void _ZN3ccc8CC10x7y4D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y4E[] = {
  NSPAIR(_ZN3ccc8CC10x7y4C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y4E[];
extern void _ZN3ccc8CC10x7y43abcEv();
extern void _ZN3ccc8CC10x7y43pqrEv();
extern void _ZN3ccc8CC10x7y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y43pqrEv,_ZTv0_n12_N3ccc8CC10x7y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y43pqrEv,_ZThn4_N3ccc8CC10x7y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y43abcEv,_ZTv0_n16_N3ccc8CC10x7y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y43abcEv,_ZThn4_N3ccc8CC10x7y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y43pqrEv,_ZTv0_n12_N3ccc8CC10x7y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y43abcEv,_ZTv0_n16_N3ccc8CC10x7y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y4E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y4E[] = {
  {&(_ZTVN3ccc8CC10x7y4E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y4E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y4E[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y43abcEv,_ZTv0_n16_N3ccc8CC10x7y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y43abcEv,_ZThn4_N3ccc8CC10x7y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y43pqrEv,_ZTv0_n12_N3ccc8CC10x7y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y43pqrEv,_ZThn4_N3ccc8CC10x7y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y4E = {  "_ZN3ccc8CC10x7y4E", // class name
  bases__ZN3ccc8CC10x7y4E, 2,
  &(vtc__ZN3ccc8CC10x7y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y4E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y4  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8DD10x7y43pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x7y43abcEv
  virtual void  efg(); // _ZN3ccc8DD10x7y43efgEv
  ~DD10x7y4(); // tgen
  DD10x7y4(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y4E) C1{ VBC2{ v1 v2} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x7y4 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y43pqrEv");}
void  ccc::DD10x7y4 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y43abcEv");}
void  ccc::DD10x7y4 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y43efgEv");}
ccc::DD10x7y4 ::~DD10x7y4(){ note_dtor("_ZN3ccc8DD10x7y4E", this);} // tgen
ccc::DD10x7y4 ::DD10x7y4(){ note_ctor("_ZN3ccc8DD10x7y4E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y4E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y4E, buf);
    ::ccc::DD10x7y4 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y4E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y4E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y4E);
    dp->::ccc::DD10x7y4::~DD10x7y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y4E(Test__ZN3ccc8DD10x7y4E, "_ZN3ccc8DD10x7y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y4C1Ev();
extern void _ZN3ccc8DD10x7y4D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y4E[] = {
  NSPAIR(_ZN3ccc8DD10x7y4C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y4E[];
extern void _ZN3ccc8DD10x7y43pqrEv();
extern void _ZN3ccc8DD10x7y43abcEv();
extern void _ZN3ccc8DD10x7y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y43abcEv,_ZTv0_n12_N3ccc8DD10x7y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y43abcEv,_ZThn4_N3ccc8DD10x7y43abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y43pqrEv,_ZTv0_n16_N3ccc8DD10x7y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y43pqrEv,_ZThn4_N3ccc8DD10x7y43pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y43abcEv,_ZTv0_n12_N3ccc8DD10x7y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y43pqrEv,_ZTv0_n16_N3ccc8DD10x7y43pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y4E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y4E[] = {
  {&(_ZTVN3ccc8DD10x7y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y4E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y4E[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y43pqrEv,_ZTv0_n16_N3ccc8DD10x7y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y43pqrEv,_ZThn4_N3ccc8DD10x7y43pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y43abcEv,_ZTv0_n12_N3ccc8DD10x7y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y43abcEv,_ZThn4_N3ccc8DD10x7y43abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y4E = {  "_ZN3ccc8DD10x7y4E", // class name
  bases__ZN3ccc8DD10x7y4E, 2,
  &(vtc__ZN3ccc8DD10x7y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y4E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y5  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC10x7y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x7y53efgEv
  virtual void  abc(); // _ZN3ccc8CC10x7y53abcEv
  ~CC10x7y5(); // tgen
  CC10x7y5(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y5E) C1{ VBC2{ v1 v3} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x7y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y53pqrEv");}
void  ccc::CC10x7y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y53efgEv");}
void  ccc::CC10x7y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y53abcEv");}
ccc::CC10x7y5 ::~CC10x7y5(){ note_dtor("_ZN3ccc8CC10x7y5E", this);} // tgen
ccc::CC10x7y5 ::CC10x7y5(){ note_ctor("_ZN3ccc8CC10x7y5E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y5E, buf);
    ::ccc::CC10x7y5 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y5E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y5E);
    dp->::ccc::CC10x7y5::~CC10x7y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y5E(Test__ZN3ccc8CC10x7y5E, "_ZN3ccc8CC10x7y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y5C1Ev();
extern void _ZN3ccc8CC10x7y5D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y5E[] = {
  NSPAIR(_ZN3ccc8CC10x7y5C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y5E[];
extern void _ZN3ccc8CC10x7y53abcEv();
extern void _ZN3ccc8CC10x7y53pqrEv();
extern void _ZN3ccc8CC10x7y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y53pqrEv,_ZTv0_n12_N3ccc8CC10x7y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y53pqrEv,_ZThn4_N3ccc8CC10x7y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y53abcEv,_ZTv0_n16_N3ccc8CC10x7y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y53abcEv,_ZThn4_N3ccc8CC10x7y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y53pqrEv,_ZTv0_n12_N3ccc8CC10x7y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y53abcEv,_ZTv0_n16_N3ccc8CC10x7y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y5E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y5E[] = {
  {&(_ZTVN3ccc8CC10x7y5E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y5E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y5E[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y53abcEv,_ZTv0_n16_N3ccc8CC10x7y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y53abcEv,_ZThn4_N3ccc8CC10x7y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y53pqrEv,_ZTv0_n12_N3ccc8CC10x7y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y53pqrEv,_ZThn4_N3ccc8CC10x7y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y5E = {  "_ZN3ccc8CC10x7y5E", // class name
  bases__ZN3ccc8CC10x7y5E, 2,
  &(vtc__ZN3ccc8CC10x7y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y5E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y5  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8DD10x7y53pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x7y53efgEv
  virtual void  abc(); // _ZN3ccc8DD10x7y53abcEv
  ~DD10x7y5(); // tgen
  DD10x7y5(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y5E) C1{ VBC2{ v1 v3} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x7y5 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y53pqrEv");}
void  ccc::DD10x7y5 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y53efgEv");}
void  ccc::DD10x7y5 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y53abcEv");}
ccc::DD10x7y5 ::~DD10x7y5(){ note_dtor("_ZN3ccc8DD10x7y5E", this);} // tgen
ccc::DD10x7y5 ::DD10x7y5(){ note_ctor("_ZN3ccc8DD10x7y5E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y5E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y5E, buf);
    ::ccc::DD10x7y5 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y5E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y5E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y5E);
    dp->::ccc::DD10x7y5::~DD10x7y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y5E(Test__ZN3ccc8DD10x7y5E, "_ZN3ccc8DD10x7y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y5C1Ev();
extern void _ZN3ccc8DD10x7y5D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y5E[] = {
  NSPAIR(_ZN3ccc8DD10x7y5C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y5E[];
extern void _ZN3ccc8DD10x7y53pqrEv();
extern void _ZN3ccc8DD10x7y53abcEv();
extern void _ZN3ccc8DD10x7y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y53abcEv,_ZTv0_n12_N3ccc8DD10x7y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y53abcEv,_ZThn4_N3ccc8DD10x7y53abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y53pqrEv,_ZTv0_n16_N3ccc8DD10x7y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y53pqrEv,_ZThn4_N3ccc8DD10x7y53pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y53abcEv,_ZTv0_n12_N3ccc8DD10x7y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y53pqrEv,_ZTv0_n16_N3ccc8DD10x7y53pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y5E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y5E[] = {
  {&(_ZTVN3ccc8DD10x7y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y5E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y5E[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y53pqrEv,_ZTv0_n16_N3ccc8DD10x7y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y53pqrEv,_ZThn4_N3ccc8DD10x7y53pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y53abcEv,_ZTv0_n12_N3ccc8DD10x7y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y53abcEv,_ZThn4_N3ccc8DD10x7y53abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y5E = {  "_ZN3ccc8DD10x7y5E", // class name
  bases__ZN3ccc8DD10x7y5E, 2,
  &(vtc__ZN3ccc8DD10x7y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y5E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y6  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8CC10x7y63abcEv
  virtual void  efg(); // _ZN3ccc8CC10x7y63efgEv
  ~CC10x7y6(); // tgen
  CC10x7y6(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y6E) C1{ VBC2{ v3 v1} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x7y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y63abcEv");}
void  ccc::CC10x7y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y63efgEv");}
ccc::CC10x7y6 ::~CC10x7y6(){ note_dtor("_ZN3ccc8CC10x7y6E", this);} // tgen
ccc::CC10x7y6 ::CC10x7y6(){ note_ctor("_ZN3ccc8CC10x7y6E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y6E, buf);
    ::ccc::CC10x7y6 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y6E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y6E);
    dp->::ccc::CC10x7y6::~CC10x7y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y6E(Test__ZN3ccc8CC10x7y6E, "_ZN3ccc8CC10x7y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y6C1Ev();
extern void _ZN3ccc8CC10x7y6D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y6E[] = {
  NSPAIR(_ZN3ccc8CC10x7y6C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y6E[];
extern void _ZN3ccc8CC10x7y63abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc8CC10x7y63efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y63abcEv,_ZTv0_n16_N3ccc8CC10x7y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y63abcEv,_ZThn4_N3ccc8CC10x7y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y63efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y63abcEv,_ZTv0_n16_N3ccc8CC10x7y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y6E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y6E[] = {
  {&(_ZTVN3ccc8CC10x7y6E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y6E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y6E[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y63abcEv,_ZTv0_n16_N3ccc8CC10x7y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y63abcEv,_ZThn4_N3ccc8CC10x7y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y6E = {  "_ZN3ccc8CC10x7y6E", // class name
  bases__ZN3ccc8CC10x7y6E, 2,
  &(vtc__ZN3ccc8CC10x7y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y6E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y6  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8DD10x7y63abcEv
  virtual void  efg(); // _ZN3ccc8DD10x7y63efgEv
  ~DD10x7y6(); // tgen
  DD10x7y6(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y6E) C1{ VBC2{ v3 v1} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x7y6 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y63abcEv");}
void  ccc::DD10x7y6 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y63efgEv");}
ccc::DD10x7y6 ::~DD10x7y6(){ note_dtor("_ZN3ccc8DD10x7y6E", this);} // tgen
ccc::DD10x7y6 ::DD10x7y6(){ note_ctor("_ZN3ccc8DD10x7y6E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y6E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y6E, buf);
    ::ccc::DD10x7y6 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y6E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y6E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y6E);
    dp->::ccc::DD10x7y6::~DD10x7y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y6E(Test__ZN3ccc8DD10x7y6E, "_ZN3ccc8DD10x7y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y6C1Ev();
extern void _ZN3ccc8DD10x7y6D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y6E[] = {
  NSPAIR(_ZN3ccc8DD10x7y6C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x7y63abcEv();
extern void _ZN3ccc8DD10x7y63efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y63abcEv,_ZTv0_n12_N3ccc8DD10x7y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y63abcEv,_ZThn4_N3ccc8DD10x7y63abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y63efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y63abcEv,_ZTv0_n12_N3ccc8DD10x7y63abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y6E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y6E[] = {
  {&(_ZTVN3ccc8DD10x7y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y6E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y6E[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y63abcEv,_ZTv0_n12_N3ccc8DD10x7y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y63abcEv,_ZThn4_N3ccc8DD10x7y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y6E = {  "_ZN3ccc8DD10x7y6E", // class name
  bases__ZN3ccc8DD10x7y6E, 2,
  &(vtc__ZN3ccc8DD10x7y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y6E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y7  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8CC10x7y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x7y73pqrEv
  ~CC10x7y7(); // tgen
  CC10x7y7(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y7E) C1{ VBC2{ v2 v1} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x7y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y73abcEv");}
void  ccc::CC10x7y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y73pqrEv");}
ccc::CC10x7y7 ::~CC10x7y7(){ note_dtor("_ZN3ccc8CC10x7y7E", this);} // tgen
ccc::CC10x7y7 ::CC10x7y7(){ note_ctor("_ZN3ccc8CC10x7y7E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y7E, buf);
    ::ccc::CC10x7y7 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y7E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y7E);
    dp->::ccc::CC10x7y7::~CC10x7y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y7E(Test__ZN3ccc8CC10x7y7E, "_ZN3ccc8CC10x7y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y7C1Ev();
extern void _ZN3ccc8CC10x7y7D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y7E[] = {
  NSPAIR(_ZN3ccc8CC10x7y7C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y7E[];
extern void _ZN3ccc8CC10x7y73abcEv();
extern void _ZN3ccc8CC10x7y73pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y73pqrEv,_ZTv0_n12_N3ccc8CC10x7y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y73pqrEv,_ZThn4_N3ccc8CC10x7y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y73abcEv,_ZTv0_n16_N3ccc8CC10x7y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y73abcEv,_ZThn4_N3ccc8CC10x7y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y73pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y73pqrEv,_ZTv0_n12_N3ccc8CC10x7y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y73abcEv,_ZTv0_n16_N3ccc8CC10x7y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y7E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y7E[] = {
  {&(_ZTVN3ccc8CC10x7y7E[3]),  3,11},
  {&(_ZTVN3ccc8CC10x7y7E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y7E[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y73abcEv,_ZTv0_n16_N3ccc8CC10x7y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y73abcEv,_ZThn4_N3ccc8CC10x7y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y73pqrEv,_ZTv0_n12_N3ccc8CC10x7y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y73pqrEv,_ZThn4_N3ccc8CC10x7y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y7E = {  "_ZN3ccc8CC10x7y7E", // class name
  bases__ZN3ccc8CC10x7y7E, 2,
  &(vtc__ZN3ccc8CC10x7y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y7E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y7  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8DD10x7y73abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x7y73pqrEv
  ~DD10x7y7(); // tgen
  DD10x7y7(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y7E) C1{ VBC2{ v2 v1} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x7y7 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y73abcEv");}
void  ccc::DD10x7y7 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y73pqrEv");}
ccc::DD10x7y7 ::~DD10x7y7(){ note_dtor("_ZN3ccc8DD10x7y7E", this);} // tgen
ccc::DD10x7y7 ::DD10x7y7(){ note_ctor("_ZN3ccc8DD10x7y7E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y7E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y7E, buf);
    ::ccc::DD10x7y7 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y7E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y7E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y7E);
    dp->::ccc::DD10x7y7::~DD10x7y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y7E(Test__ZN3ccc8DD10x7y7E, "_ZN3ccc8DD10x7y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y7C1Ev();
extern void _ZN3ccc8DD10x7y7D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y7E[] = {
  NSPAIR(_ZN3ccc8DD10x7y7C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y7E[];
extern void _ZN3ccc8DD10x7y73pqrEv();
extern void _ZN3ccc8DD10x7y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y73abcEv,_ZTv0_n12_N3ccc8DD10x7y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y73abcEv,_ZThn4_N3ccc8DD10x7y73abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y73pqrEv,_ZTv0_n16_N3ccc8DD10x7y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y73pqrEv,_ZThn4_N3ccc8DD10x7y73pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y73abcEv,_ZTv0_n12_N3ccc8DD10x7y73abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y73pqrEv,_ZTv0_n16_N3ccc8DD10x7y73pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y7E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y7E[] = {
  {&(_ZTVN3ccc8DD10x7y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x7y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x7y7E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y7E[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y73pqrEv,_ZTv0_n16_N3ccc8DD10x7y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y73pqrEv,_ZThn4_N3ccc8DD10x7y73pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y73abcEv,_ZTv0_n12_N3ccc8DD10x7y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y73abcEv,_ZThn4_N3ccc8DD10x7y73abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y7E = {  "_ZN3ccc8DD10x7y7E", // class name
  bases__ZN3ccc8DD10x7y7E, 2,
  &(vtc__ZN3ccc8DD10x7y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y7E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y8  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8CC10x7y83efgEv
  virtual void  abc(); // _ZN3ccc8CC10x7y83abcEv
  ~CC10x7y8(); // tgen
  CC10x7y8(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y8E) C1{ VBC2{ v3 v2} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x7y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y83efgEv");}
void  ccc::CC10x7y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x7y83abcEv");}
ccc::CC10x7y8 ::~CC10x7y8(){ note_dtor("_ZN3ccc8CC10x7y8E", this);} // tgen
ccc::CC10x7y8 ::CC10x7y8(){ note_ctor("_ZN3ccc8CC10x7y8E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y8E, buf);
    ::ccc::CC10x7y8 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y8E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y8E);
    dp->::ccc::CC10x7y8::~CC10x7y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y8E(Test__ZN3ccc8CC10x7y8E, "_ZN3ccc8CC10x7y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y8C1Ev();
extern void _ZN3ccc8CC10x7y8D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y8E[] = {
  NSPAIR(_ZN3ccc8CC10x7y8C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y8E[];
extern void _ZN3ccc8CC10x7y83abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc8CC10x7y83efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x7y83abcEv,_ZTv0_n16_N3ccc8CC10x7y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y83abcEv,_ZThn4_N3ccc8CC10x7y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y83efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x7y83abcEv,_ZTv0_n16_N3ccc8CC10x7y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y8E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y8E[] = {
  {&(_ZTVN3ccc8CC10x7y8E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y8E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y8E[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x7y83abcEv,_ZTv0_n16_N3ccc8CC10x7y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y83abcEv,_ZThn4_N3ccc8CC10x7y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y8E = {  "_ZN3ccc8CC10x7y8E", // class name
  bases__ZN3ccc8CC10x7y8E, 2,
  &(vtc__ZN3ccc8CC10x7y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y8E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y8  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8DD10x7y83efgEv
  virtual void  abc(); // _ZN3ccc8DD10x7y83abcEv
  ~DD10x7y8(); // tgen
  DD10x7y8(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y8E) C1{ VBC2{ v3 v2} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x7y8 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y83efgEv");}
void  ccc::DD10x7y8 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x7y83abcEv");}
ccc::DD10x7y8 ::~DD10x7y8(){ note_dtor("_ZN3ccc8DD10x7y8E", this);} // tgen
ccc::DD10x7y8 ::DD10x7y8(){ note_ctor("_ZN3ccc8DD10x7y8E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y8E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y8E, buf);
    ::ccc::DD10x7y8 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y8E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y8E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y8E);
    dp->::ccc::DD10x7y8::~DD10x7y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y8E(Test__ZN3ccc8DD10x7y8E, "_ZN3ccc8DD10x7y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y8C1Ev();
extern void _ZN3ccc8DD10x7y8D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y8E[] = {
  NSPAIR(_ZN3ccc8DD10x7y8C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x7y83abcEv();
extern void _ZN3ccc8DD10x7y83efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x7y83abcEv,_ZTv0_n12_N3ccc8DD10x7y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y83abcEv,_ZThn4_N3ccc8DD10x7y83abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y83efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x7y83abcEv,_ZTv0_n12_N3ccc8DD10x7y83abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y8E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y8E[] = {
  {&(_ZTVN3ccc8DD10x7y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y8E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y8E[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x7y83abcEv,_ZTv0_n12_N3ccc8DD10x7y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y83abcEv,_ZThn4_N3ccc8DD10x7y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y8E = {  "_ZN3ccc8DD10x7y8E", // class name
  bases__ZN3ccc8DD10x7y8E, 2,
  &(vtc__ZN3ccc8DD10x7y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y8E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y9  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8CC10x7y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x7y93pqrEv
  ~CC10x7y9(); // tgen
  CC10x7y9(); // tgen
};
//SIG(1 _ZN3ccc8CC10x7y9E) C1{ VBC2{ v2 v3} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x7y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x7y93efgEv");}
void  ccc::CC10x7y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x7y93pqrEv");}
ccc::CC10x7y9 ::~CC10x7y9(){ note_dtor("_ZN3ccc8CC10x7y9E", this);} // tgen
ccc::CC10x7y9 ::CC10x7y9(){ note_ctor("_ZN3ccc8CC10x7y9E", this);} // tgen
}
static void Test__ZN3ccc8CC10x7y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x7y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x7y9E, buf);
    ::ccc::CC10x7y9 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x7y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x7y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x7y9E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC10x7y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x7y9E);
    dp->::ccc::CC10x7y9::~CC10x7y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x7y9E(Test__ZN3ccc8CC10x7y9E, "_ZN3ccc8CC10x7y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x7y9C1Ev();
extern void _ZN3ccc8CC10x7y9D1Ev();
Name_Map name_map__ZN3ccc8CC10x7y9E[] = {
  NSPAIR(_ZN3ccc8CC10x7y9C1Ev),
  NSPAIR(_ZN3ccc8CC10x7y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC10x7y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y9E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc8CC10x7y93pqrEv();
extern void _ZN3ccc8CC10x7y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x7y93pqrEv,_ZTv0_n12_N3ccc8CC10x7y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x7y93pqrEv,_ZThn4_N3ccc8CC10x7y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC10x7y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x7y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x7y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x7y93pqrEv,_ZTv0_n12_N3ccc8CC10x7y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x7y9E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x7y9E[] = {
  {&(_ZTVN3ccc8CC10x7y9E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x7y9E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x7y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x7y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x7y9E[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x7y93pqrEv,_ZTv0_n12_N3ccc8CC10x7y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x7y93pqrEv,_ZThn4_N3ccc8CC10x7y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x7y9E = {  "_ZN3ccc8CC10x7y9E", // class name
  bases__ZN3ccc8CC10x7y9E, 2,
  &(vtc__ZN3ccc8CC10x7y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x7y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x7y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x7y9E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x7y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y9  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8DD10x7y93efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x7y93pqrEv
  ~DD10x7y9(); // tgen
  DD10x7y9(); // tgen
};
//SIG(1 _ZN3ccc8DD10x7y9E) C1{ VBC2{ v2 v3} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x7y9 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x7y93efgEv");}
void  ccc::DD10x7y9 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x7y93pqrEv");}
ccc::DD10x7y9 ::~DD10x7y9(){ note_dtor("_ZN3ccc8DD10x7y9E", this);} // tgen
ccc::DD10x7y9 ::DD10x7y9(){ note_ctor("_ZN3ccc8DD10x7y9E", this);} // tgen
}
static void Test__ZN3ccc8DD10x7y9E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x7y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x7y9E, buf);
    ::ccc::DD10x7y9 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x7y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x7y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x7y9E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD10x7y9E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x7y9E);
    dp->::ccc::DD10x7y9::~DD10x7y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x7y9E(Test__ZN3ccc8DD10x7y9E, "_ZN3ccc8DD10x7y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x7y9C1Ev();
extern void _ZN3ccc8DD10x7y9D1Ev();
Name_Map name_map__ZN3ccc8DD10x7y9E[] = {
  NSPAIR(_ZN3ccc8DD10x7y9C1Ev),
  NSPAIR(_ZN3ccc8DD10x7y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD10x7y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y9E[];
extern void _ZN3ccc8DD10x7y93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc8DD10x7y93efgEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x7y93pqrEv,_ZTv0_n16_N3ccc8DD10x7y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x7y93pqrEv,_ZThn4_N3ccc8DD10x7y93pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x7y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x7y93efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x7y93pqrEv,_ZTv0_n16_N3ccc8DD10x7y93pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x7y9E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x7y9E[] = {
  {&(_ZTVN3ccc8DD10x7y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x7y9E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x7y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x7y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x7y9E[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x7y93pqrEv,_ZTv0_n16_N3ccc8DD10x7y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x7y93pqrEv,_ZThn4_N3ccc8DD10x7y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x7y9E = {  "_ZN3ccc8DD10x7y9E", // class name
  bases__ZN3ccc8DD10x7y9E, 2,
  &(vtc__ZN3ccc8DD10x7y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x7y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x7y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x7y9E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x7y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y10  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc9CC10x7y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x7y103abcEv
  ~CC10x7y10(); // tgen
  CC10x7y10(); // tgen
};
//SIG(1 _ZN3ccc9CC10x7y10E) C1{ VBC2{ v1 v2} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x7y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x7y103pqrEv");}
void  ccc::CC10x7y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x7y103abcEv");}
ccc::CC10x7y10 ::~CC10x7y10(){ note_dtor("_ZN3ccc9CC10x7y10E", this);} // tgen
ccc::CC10x7y10 ::CC10x7y10(){ note_ctor("_ZN3ccc9CC10x7y10E", this);} // tgen
}
static void Test__ZN3ccc9CC10x7y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x7y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x7y10E, buf);
    ::ccc::CC10x7y10 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x7y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x7y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x7y10E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc9CC10x7y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x7y10E);
    dp->::ccc::CC10x7y10::~CC10x7y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x7y10E(Test__ZN3ccc9CC10x7y10E, "_ZN3ccc9CC10x7y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x7y10C1Ev();
extern void _ZN3ccc9CC10x7y10D1Ev();
Name_Map name_map__ZN3ccc9CC10x7y10E[] = {
  NSPAIR(_ZN3ccc9CC10x7y10C1Ev),
  NSPAIR(_ZN3ccc9CC10x7y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9CC10x7y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y10E[];
extern void _ZN3ccc9CC10x7y103abcEv();
extern void _ZN3ccc9CC10x7y103pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x7y103pqrEv,_ZTv0_n12_N3ccc9CC10x7y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x7y103pqrEv,_ZThn4_N3ccc9CC10x7y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x7y103abcEv,_ZTv0_n16_N3ccc9CC10x7y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x7y103abcEv,_ZThn4_N3ccc9CC10x7y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x7y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y103pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x7y103pqrEv,_ZTv0_n12_N3ccc9CC10x7y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x7y103abcEv,_ZTv0_n16_N3ccc9CC10x7y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x7y10E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x7y10E[] = {
  {&(_ZTVN3ccc9CC10x7y10E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x7y10E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x7y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x7y10E[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x7y103abcEv,_ZTv0_n16_N3ccc9CC10x7y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x7y103abcEv,_ZThn4_N3ccc9CC10x7y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x7y103pqrEv,_ZTv0_n12_N3ccc9CC10x7y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x7y103pqrEv,_ZThn4_N3ccc9CC10x7y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x7y10E = {  "_ZN3ccc9CC10x7y10E", // class name
  bases__ZN3ccc9CC10x7y10E, 2,
  &(vtc__ZN3ccc9CC10x7y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x7y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x7y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x7y10E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x7y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y10  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc9DD10x7y103pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x7y103abcEv
  ~DD10x7y10(); // tgen
  DD10x7y10(); // tgen
};
//SIG(1 _ZN3ccc9DD10x7y10E) C1{ VBC2{ v1 v2} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x7y10 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x7y103pqrEv");}
void  ccc::DD10x7y10 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x7y103abcEv");}
ccc::DD10x7y10 ::~DD10x7y10(){ note_dtor("_ZN3ccc9DD10x7y10E", this);} // tgen
ccc::DD10x7y10 ::DD10x7y10(){ note_ctor("_ZN3ccc9DD10x7y10E", this);} // tgen
}
static void Test__ZN3ccc9DD10x7y10E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x7y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x7y10E, buf);
    ::ccc::DD10x7y10 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x7y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x7y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x7y10E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc9DD10x7y10E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x7y10E);
    dp->::ccc::DD10x7y10::~DD10x7y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x7y10E(Test__ZN3ccc9DD10x7y10E, "_ZN3ccc9DD10x7y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x7y10C1Ev();
extern void _ZN3ccc9DD10x7y10D1Ev();
Name_Map name_map__ZN3ccc9DD10x7y10E[] = {
  NSPAIR(_ZN3ccc9DD10x7y10C1Ev),
  NSPAIR(_ZN3ccc9DD10x7y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9DD10x7y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y10E[];
extern void _ZN3ccc9DD10x7y103pqrEv();
extern void _ZN3ccc9DD10x7y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x7y103abcEv,_ZTv0_n12_N3ccc9DD10x7y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x7y103abcEv,_ZThn4_N3ccc9DD10x7y103abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x7y103pqrEv,_ZTv0_n16_N3ccc9DD10x7y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x7y103pqrEv,_ZThn4_N3ccc9DD10x7y103pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x7y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x7y103abcEv,_ZTv0_n12_N3ccc9DD10x7y103abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x7y103pqrEv,_ZTv0_n16_N3ccc9DD10x7y103pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x7y10E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x7y10E[] = {
  {&(_ZTVN3ccc9DD10x7y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y10E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x7y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x7y10E[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x7y103pqrEv,_ZTv0_n16_N3ccc9DD10x7y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x7y103pqrEv,_ZThn4_N3ccc9DD10x7y103pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x7y103abcEv,_ZTv0_n12_N3ccc9DD10x7y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x7y103abcEv,_ZThn4_N3ccc9DD10x7y103abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x7y10E = {  "_ZN3ccc9DD10x7y10E", // class name
  bases__ZN3ccc9DD10x7y10E, 2,
  &(vtc__ZN3ccc9DD10x7y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x7y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x7y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x7y10E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x7y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y11  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc9CC10x7y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x7y113efgEv
  ~CC10x7y11(); // tgen
  CC10x7y11(); // tgen
};
//SIG(1 _ZN3ccc9CC10x7y11E) C1{ VBC2{ v1 v3} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x7y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x7y113pqrEv");}
void  ccc::CC10x7y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x7y113efgEv");}
ccc::CC10x7y11 ::~CC10x7y11(){ note_dtor("_ZN3ccc9CC10x7y11E", this);} // tgen
ccc::CC10x7y11 ::CC10x7y11(){ note_ctor("_ZN3ccc9CC10x7y11E", this);} // tgen
}
static void Test__ZN3ccc9CC10x7y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x7y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x7y11E, buf);
    ::ccc::CC10x7y11 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x7y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x7y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x7y11E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc9CC10x7y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x7y11E);
    dp->::ccc::CC10x7y11::~CC10x7y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x7y11E(Test__ZN3ccc9CC10x7y11E, "_ZN3ccc9CC10x7y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x7y11C1Ev();
extern void _ZN3ccc9CC10x7y11D1Ev();
Name_Map name_map__ZN3ccc9CC10x7y11E[] = {
  NSPAIR(_ZN3ccc9CC10x7y11C1Ev),
  NSPAIR(_ZN3ccc9CC10x7y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9CC10x7y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y11E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc9CC10x7y113pqrEv();
extern void _ZN3ccc9CC10x7y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x7y113pqrEv,_ZTv0_n12_N3ccc9CC10x7y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x7y113pqrEv,_ZThn4_N3ccc9CC10x7y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x7y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x7y113pqrEv,_ZTv0_n12_N3ccc9CC10x7y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x7y11E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x7y11E[] = {
  {&(_ZTVN3ccc9CC10x7y11E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x7y11E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x7y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x7y11E[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x7y113pqrEv,_ZTv0_n12_N3ccc9CC10x7y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x7y113pqrEv,_ZThn4_N3ccc9CC10x7y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x7y11E = {  "_ZN3ccc9CC10x7y11E", // class name
  bases__ZN3ccc9CC10x7y11E, 2,
  &(vtc__ZN3ccc9CC10x7y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x7y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x7y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x7y11E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x7y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y11  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc9DD10x7y113pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x7y113efgEv
  ~DD10x7y11(); // tgen
  DD10x7y11(); // tgen
};
//SIG(1 _ZN3ccc9DD10x7y11E) C1{ VBC2{ v1 v3} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x7y11 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x7y113pqrEv");}
void  ccc::DD10x7y11 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x7y113efgEv");}
ccc::DD10x7y11 ::~DD10x7y11(){ note_dtor("_ZN3ccc9DD10x7y11E", this);} // tgen
ccc::DD10x7y11 ::DD10x7y11(){ note_ctor("_ZN3ccc9DD10x7y11E", this);} // tgen
}
static void Test__ZN3ccc9DD10x7y11E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x7y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x7y11E, buf);
    ::ccc::DD10x7y11 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x7y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x7y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x7y11E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc9DD10x7y11E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x7y11E);
    dp->::ccc::DD10x7y11::~DD10x7y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x7y11E(Test__ZN3ccc9DD10x7y11E, "_ZN3ccc9DD10x7y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x7y11C1Ev();
extern void _ZN3ccc9DD10x7y11D1Ev();
Name_Map name_map__ZN3ccc9DD10x7y11E[] = {
  NSPAIR(_ZN3ccc9DD10x7y11C1Ev),
  NSPAIR(_ZN3ccc9DD10x7y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9DD10x7y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y11E[];
extern void _ZN3ccc9DD10x7y113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x7y113efgEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x7y113pqrEv,_ZTv0_n16_N3ccc9DD10x7y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x7y113pqrEv,_ZThn4_N3ccc9DD10x7y113pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x7y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y113efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x7y113pqrEv,_ZTv0_n16_N3ccc9DD10x7y113pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x7y11E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x7y11E[] = {
  {&(_ZTVN3ccc9DD10x7y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x7y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x7y11E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x7y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x7y11E[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x7y113pqrEv,_ZTv0_n16_N3ccc9DD10x7y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x7y113pqrEv,_ZThn4_N3ccc9DD10x7y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x7y11E = {  "_ZN3ccc9DD10x7y11E", // class name
  bases__ZN3ccc9DD10x7y11E, 2,
  &(vtc__ZN3ccc9DD10x7y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x7y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x7y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x7y11E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x7y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y12  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc9CC10x7y123abcEv
  ~CC10x7y12(); // tgen
  CC10x7y12(); // tgen
};
//SIG(1 _ZN3ccc9CC10x7y12E) C1{ VBC2{ v2 v1} BC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::CC10x7y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x7y123abcEv");}
ccc::CC10x7y12 ::~CC10x7y12(){ note_dtor("_ZN3ccc9CC10x7y12E", this);} // tgen
ccc::CC10x7y12 ::CC10x7y12(){ note_ctor("_ZN3ccc9CC10x7y12E", this);} // tgen
}
static void Test__ZN3ccc9CC10x7y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x7y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x7y12E, buf);
    ::ccc::CC10x7y12 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x7y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x7y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x7y12E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc9CC10x7y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x7y12E);
    dp->::ccc::CC10x7y12::~CC10x7y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x7y12E(Test__ZN3ccc9CC10x7y12E, "_ZN3ccc9CC10x7y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x7y12C1Ev();
extern void _ZN3ccc9CC10x7y12D1Ev();
Name_Map name_map__ZN3ccc9CC10x7y12E[] = {
  NSPAIR(_ZN3ccc9CC10x7y12C1Ev),
  NSPAIR(_ZN3ccc9CC10x7y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9CC10x7y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y12E[];
extern void _ZN3ccc9CC10x7y123abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x7y123abcEv,_ZTv0_n16_N3ccc9CC10x7y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x7y123abcEv,_ZThn4_N3ccc9CC10x7y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x7y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x7y123abcEv,_ZTv0_n16_N3ccc9CC10x7y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x7y12E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x7y12E[] = {
  {&(_ZTVN3ccc9CC10x7y12E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x7y12E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x7y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x7y12E[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x7y123abcEv,_ZTv0_n16_N3ccc9CC10x7y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x7y123abcEv,_ZThn4_N3ccc9CC10x7y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x7y12E = {  "_ZN3ccc9CC10x7y12E", // class name
  bases__ZN3ccc9CC10x7y12E, 2,
  &(vtc__ZN3ccc9CC10x7y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x7y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x7y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x7y12E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x7y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y12  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc9DD10x7y123abcEv
  ~DD10x7y12(); // tgen
  DD10x7y12(); // tgen
};
//SIG(1 _ZN3ccc9DD10x7y12E) C1{ VBC2{ v2 v1} VBC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::DD10x7y12 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x7y123abcEv");}
ccc::DD10x7y12 ::~DD10x7y12(){ note_dtor("_ZN3ccc9DD10x7y12E", this);} // tgen
ccc::DD10x7y12 ::DD10x7y12(){ note_ctor("_ZN3ccc9DD10x7y12E", this);} // tgen
}
static void Test__ZN3ccc9DD10x7y12E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x7y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x7y12E, buf);
    ::ccc::DD10x7y12 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x7y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x7y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x7y12E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc9DD10x7y12E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x7y12E);
    dp->::ccc::DD10x7y12::~DD10x7y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x7y12E(Test__ZN3ccc9DD10x7y12E, "_ZN3ccc9DD10x7y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x7y12C1Ev();
extern void _ZN3ccc9DD10x7y12D1Ev();
Name_Map name_map__ZN3ccc9DD10x7y12E[] = {
  NSPAIR(_ZN3ccc9DD10x7y12C1Ev),
  NSPAIR(_ZN3ccc9DD10x7y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9DD10x7y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x7y123abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x7y123abcEv,_ZTv0_n12_N3ccc9DD10x7y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x7y123abcEv,_ZThn4_N3ccc9DD10x7y123abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x7y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y123abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x7y123abcEv,_ZTv0_n12_N3ccc9DD10x7y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x7y12E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x7y12E[] = {
  {&(_ZTVN3ccc9DD10x7y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y12E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x7y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x7y12E[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x7y123abcEv,_ZTv0_n12_N3ccc9DD10x7y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x7y123abcEv,_ZThn4_N3ccc9DD10x7y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x7y12E = {  "_ZN3ccc9DD10x7y12E", // class name
  bases__ZN3ccc9DD10x7y12E, 2,
  &(vtc__ZN3ccc9DD10x7y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x7y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x7y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x7y12E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x7y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y13  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc9CC10x7y133efgEv
  ~CC10x7y13(); // tgen
  CC10x7y13(); // tgen
};
//SIG(1 _ZN3ccc9CC10x7y13E) C1{ VBC2{ v2 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC10x7y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x7y133efgEv");}
ccc::CC10x7y13 ::~CC10x7y13(){ note_dtor("_ZN3ccc9CC10x7y13E", this);} // tgen
ccc::CC10x7y13 ::CC10x7y13(){ note_ctor("_ZN3ccc9CC10x7y13E", this);} // tgen
}
static void Test__ZN3ccc9CC10x7y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x7y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x7y13E, buf);
    ::ccc::CC10x7y13 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x7y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x7y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x7y13E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc9CC10x7y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x7y13E);
    dp->::ccc::CC10x7y13::~CC10x7y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x7y13E(Test__ZN3ccc9CC10x7y13E, "_ZN3ccc9CC10x7y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x7y13C1Ev();
extern void _ZN3ccc9CC10x7y13D1Ev();
Name_Map name_map__ZN3ccc9CC10x7y13E[] = {
  NSPAIR(_ZN3ccc9CC10x7y13C1Ev),
  NSPAIR(_ZN3ccc9CC10x7y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9CC10x7y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y13E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc9CC10x7y133efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x7y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y133efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x7y13E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x7y13E[] = {
  {&(_ZTVN3ccc9CC10x7y13E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x7y13E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x7y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x7y13E[];
Class_Descriptor cd__ZN3ccc9CC10x7y13E = {  "_ZN3ccc9CC10x7y13E", // class name
  bases__ZN3ccc9CC10x7y13E, 2,
  &(vtc__ZN3ccc9CC10x7y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x7y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x7y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x7y13E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x7y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y13  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc9DD10x7y133efgEv
  ~DD10x7y13(); // tgen
  DD10x7y13(); // tgen
};
//SIG(1 _ZN3ccc9DD10x7y13E) C1{ VBC2{ v2 v3} VBC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::DD10x7y13 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x7y133efgEv");}
ccc::DD10x7y13 ::~DD10x7y13(){ note_dtor("_ZN3ccc9DD10x7y13E", this);} // tgen
ccc::DD10x7y13 ::DD10x7y13(){ note_ctor("_ZN3ccc9DD10x7y13E", this);} // tgen
}
static void Test__ZN3ccc9DD10x7y13E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x7y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x7y13E, buf);
    ::ccc::DD10x7y13 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x7y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x7y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x7y13E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc9DD10x7y13E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x7y13E);
    dp->::ccc::DD10x7y13::~DD10x7y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x7y13E(Test__ZN3ccc9DD10x7y13E, "_ZN3ccc9DD10x7y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x7y13C1Ev();
extern void _ZN3ccc9DD10x7y13D1Ev();
Name_Map name_map__ZN3ccc9DD10x7y13E[] = {
  NSPAIR(_ZN3ccc9DD10x7y13C1Ev),
  NSPAIR(_ZN3ccc9DD10x7y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9DD10x7y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x7y133efgEv();
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x7y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y133efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x7y13E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x7y13E[] = {
  {&(_ZTVN3ccc9DD10x7y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x7y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x7y13E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x7y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x7y13E[];
Class_Descriptor cd__ZN3ccc9DD10x7y13E = {  "_ZN3ccc9DD10x7y13E", // class name
  bases__ZN3ccc9DD10x7y13E, 2,
  &(vtc__ZN3ccc9DD10x7y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x7y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x7y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x7y13E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x7y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y14  : virtual ::ccc::AA10 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc9CC10x7y143pqrEv
  ~CC10x7y14(); // tgen
  CC10x7y14(); // tgen
};
//SIG(1 _ZN3ccc9CC10x7y14E) C1{ VBC2{ v1 v2} BC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::CC10x7y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x7y143pqrEv");}
ccc::CC10x7y14 ::~CC10x7y14(){ note_dtor("_ZN3ccc9CC10x7y14E", this);} // tgen
ccc::CC10x7y14 ::CC10x7y14(){ note_ctor("_ZN3ccc9CC10x7y14E", this);} // tgen
}
static void Test__ZN3ccc9CC10x7y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x7y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x7y14E, buf);
    ::ccc::CC10x7y14 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x7y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x7y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x7y14E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc9CC10x7y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x7y14E);
    dp->::ccc::CC10x7y14::~CC10x7y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x7y14E(Test__ZN3ccc9CC10x7y14E, "_ZN3ccc9CC10x7y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x7y14C1Ev();
extern void _ZN3ccc9CC10x7y14D1Ev();
Name_Map name_map__ZN3ccc9CC10x7y14E[] = {
  NSPAIR(_ZN3ccc9CC10x7y14C1Ev),
  NSPAIR(_ZN3ccc9CC10x7y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9CC10x7y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y14E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc9CC10x7y143pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x7y143pqrEv,_ZTv0_n12_N3ccc9CC10x7y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x7y143pqrEv,_ZThn4_N3ccc9CC10x7y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x7y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x7y143pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x7y143pqrEv,_ZTv0_n12_N3ccc9CC10x7y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x7y14E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x7y14E[] = {
  {&(_ZTVN3ccc9CC10x7y14E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x7y14E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x7y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x7y14E[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x7y143pqrEv,_ZTv0_n12_N3ccc9CC10x7y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x7y143pqrEv,_ZThn4_N3ccc9CC10x7y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x7y14E = {  "_ZN3ccc9CC10x7y14E", // class name
  bases__ZN3ccc9CC10x7y14E, 2,
  &(vtc__ZN3ccc9CC10x7y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x7y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x7y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x7y14E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x7y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y14  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc9DD10x7y143pqrEv
  ~DD10x7y14(); // tgen
  DD10x7y14(); // tgen
};
//SIG(1 _ZN3ccc9DD10x7y14E) C1{ VBC2{ v1 v2} VBC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::DD10x7y14 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x7y143pqrEv");}
ccc::DD10x7y14 ::~DD10x7y14(){ note_dtor("_ZN3ccc9DD10x7y14E", this);} // tgen
ccc::DD10x7y14 ::DD10x7y14(){ note_ctor("_ZN3ccc9DD10x7y14E", this);} // tgen
}
static void Test__ZN3ccc9DD10x7y14E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x7y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x7y14E, buf);
    ::ccc::DD10x7y14 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x7y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x7y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x7y14E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc9DD10x7y14E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x7y14E);
    dp->::ccc::DD10x7y14::~DD10x7y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x7y14E(Test__ZN3ccc9DD10x7y14E, "_ZN3ccc9DD10x7y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x7y14C1Ev();
extern void _ZN3ccc9DD10x7y14D1Ev();
Name_Map name_map__ZN3ccc9DD10x7y14E[] = {
  NSPAIR(_ZN3ccc9DD10x7y14C1Ev),
  NSPAIR(_ZN3ccc9DD10x7y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9DD10x7y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y14E[];
extern void _ZN3ccc9DD10x7y143pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x7y143pqrEv,_ZTv0_n16_N3ccc9DD10x7y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x7y143pqrEv,_ZThn4_N3ccc9DD10x7y143pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x7y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x7y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x7y143pqrEv,_ZTv0_n16_N3ccc9DD10x7y143pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x7y14E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x7y14E[] = {
  {&(_ZTVN3ccc9DD10x7y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y14E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x7y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x7y14E[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x7y143pqrEv,_ZTv0_n16_N3ccc9DD10x7y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x7y143pqrEv,_ZThn4_N3ccc9DD10x7y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x7y14E = {  "_ZN3ccc9DD10x7y14E", // class name
  bases__ZN3ccc9DD10x7y14E, 2,
  &(vtc__ZN3ccc9DD10x7y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x7y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x7y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x7y14E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x7y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x7y15  : virtual ::ccc::AA10 , ::ccc::BB7 {
  ~CC10x7y15(); // tgen
  CC10x7y15(); // tgen
};
//SIG(1 _ZN3ccc9CC10x7y15E) C1{ VBC2{ v1 v2} BC3{ v3 v4}}
}
namespace ccc { 
ccc::CC10x7y15 ::~CC10x7y15(){ note_dtor("_ZN3ccc9CC10x7y15E", this);} // tgen
ccc::CC10x7y15 ::CC10x7y15(){ note_ctor("_ZN3ccc9CC10x7y15E", this);} // tgen
}
static void Test__ZN3ccc9CC10x7y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x7y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x7y15E, buf);
    ::ccc::CC10x7y15 *dp, &lv = *(dp=new (buf) ::ccc::CC10x7y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x7y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x7y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x7y15E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc9CC10x7y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x7y15E);
    dp->::ccc::CC10x7y15::~CC10x7y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x7y15E(Test__ZN3ccc9CC10x7y15E, "_ZN3ccc9CC10x7y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x7y15C1Ev();
extern void _ZN3ccc9CC10x7y15D1Ev();
Name_Map name_map__ZN3ccc9CC10x7y15E[] = {
  NSPAIR(_ZN3ccc9CC10x7y15C1Ev),
  NSPAIR(_ZN3ccc9CC10x7y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9CC10x7y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y15E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x7y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x7y15E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x7y15E[] = {
  {&(_ZTVN3ccc9CC10x7y15E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x7y15E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x7y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x7y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x7y15E[];
Class_Descriptor cd__ZN3ccc9CC10x7y15E = {  "_ZN3ccc9CC10x7y15E", // class name
  bases__ZN3ccc9CC10x7y15E, 2,
  &(vtc__ZN3ccc9CC10x7y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x7y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x7y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x7y15E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x7y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x7y15  : virtual ::ccc::AA10 , virtual ::ccc::BB7 {
  ~DD10x7y15(); // tgen
  DD10x7y15(); // tgen
};
//SIG(1 _ZN3ccc9DD10x7y15E) C1{ VBC2{ v1 v2} VBC3{ v3 v4}}
}
namespace ccc { 
ccc::DD10x7y15 ::~DD10x7y15(){ note_dtor("_ZN3ccc9DD10x7y15E", this);} // tgen
ccc::DD10x7y15 ::DD10x7y15(){ note_ctor("_ZN3ccc9DD10x7y15E", this);} // tgen
}
static void Test__ZN3ccc9DD10x7y15E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x7y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x7y15E, buf);
    ::ccc::DD10x7y15 *dp, &lv = *(dp=new (buf) ::ccc::DD10x7y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x7y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x7y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x7y15E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc9DD10x7y15E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x7y15E);
    dp->::ccc::DD10x7y15::~DD10x7y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x7y15E(Test__ZN3ccc9DD10x7y15E, "_ZN3ccc9DD10x7y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x7y15C1Ev();
extern void _ZN3ccc9DD10x7y15D1Ev();
Name_Map name_map__ZN3ccc9DD10x7y15E[] = {
  NSPAIR(_ZN3ccc9DD10x7y15C1Ev),
  NSPAIR(_ZN3ccc9DD10x7y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc9DD10x7y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x7y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x7y15E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x7y15E[] = {
  {&(_ZTVN3ccc9DD10x7y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x7y15E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x7y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x7y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x7y15E[];
Class_Descriptor cd__ZN3ccc9DD10x7y15E = {  "_ZN3ccc9DD10x7y15E", // class name
  bases__ZN3ccc9DD10x7y15E, 2,
  &(vtc__ZN3ccc9DD10x7y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x7y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x7y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x7y15E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x7y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y0  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8CC10x8y03abcEv
  virtual void  efg(); // _ZN3ccc8CC10x8y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x8y03pqrEv
  ~CC10x8y0(); // tgen
  CC10x8y0(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y0E) C1{ VBC2{ v3 v1} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x8y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y03abcEv");}
void  ccc::CC10x8y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y03efgEv");}
void  ccc::CC10x8y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y03pqrEv");}
ccc::CC10x8y0 ::~CC10x8y0(){ note_dtor("_ZN3ccc8CC10x8y0E", this);} // tgen
ccc::CC10x8y0 ::CC10x8y0(){ note_ctor("_ZN3ccc8CC10x8y0E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y0E, buf);
    ::ccc::CC10x8y0 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y0E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y0E);
    dp->::ccc::CC10x8y0::~CC10x8y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y0E(Test__ZN3ccc8CC10x8y0E, "_ZN3ccc8CC10x8y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y0C1Ev();
extern void _ZN3ccc8CC10x8y0D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y0E[] = {
  NSPAIR(_ZN3ccc8CC10x8y0C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y0E[];
extern void _ZN3ccc8CC10x8y03efgEv();
extern void _ZN3ccc8CC10x8y03abcEv();
extern void _ZN3ccc8CC10x8y03pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y03pqrEv,_ZTv0_n12_N3ccc8CC10x8y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y03pqrEv,_ZThn4_N3ccc8CC10x8y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y03abcEv,_ZTv0_n16_N3ccc8CC10x8y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y03abcEv,_ZThn4_N3ccc8CC10x8y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y03pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y03pqrEv,_ZTv0_n12_N3ccc8CC10x8y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y03abcEv,_ZTv0_n16_N3ccc8CC10x8y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y0E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y0E[] = {
  {&(_ZTVN3ccc8CC10x8y0E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y0E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y0E[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y03abcEv,_ZTv0_n16_N3ccc8CC10x8y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y03abcEv,_ZThn4_N3ccc8CC10x8y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y03pqrEv,_ZTv0_n12_N3ccc8CC10x8y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y03pqrEv,_ZThn4_N3ccc8CC10x8y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y0E = {  "_ZN3ccc8CC10x8y0E", // class name
  bases__ZN3ccc8CC10x8y0E, 2,
  &(vtc__ZN3ccc8CC10x8y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y0E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y0  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8DD10x8y03abcEv
  virtual void  efg(); // _ZN3ccc8DD10x8y03efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x8y03pqrEv
  ~DD10x8y0(); // tgen
  DD10x8y0(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y0E) C1{ VBC2{ v3 v1} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x8y0 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y03abcEv");}
void  ccc::DD10x8y0 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y03efgEv");}
void  ccc::DD10x8y0 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y03pqrEv");}
ccc::DD10x8y0 ::~DD10x8y0(){ note_dtor("_ZN3ccc8DD10x8y0E", this);} // tgen
ccc::DD10x8y0 ::DD10x8y0(){ note_ctor("_ZN3ccc8DD10x8y0E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y0E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y0E, buf);
    ::ccc::DD10x8y0 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y0E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y0E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y0E);
    dp->::ccc::DD10x8y0::~DD10x8y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y0E(Test__ZN3ccc8DD10x8y0E, "_ZN3ccc8DD10x8y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y0C1Ev();
extern void _ZN3ccc8DD10x8y0D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y0E[] = {
  NSPAIR(_ZN3ccc8DD10x8y0C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y0E[];
extern void _ZN3ccc8DD10x8y03pqrEv();
extern void _ZN3ccc8DD10x8y03abcEv();
extern void _ZN3ccc8DD10x8y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y03efgEv,_ZTv0_n12_N3ccc8DD10x8y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y03efgEv,_ZThn4_N3ccc8DD10x8y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y03abcEv,_ZTv0_n16_N3ccc8DD10x8y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y03abcEv,_ZThn4_N3ccc8DD10x8y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y03efgEv,_ZTv0_n12_N3ccc8DD10x8y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y03abcEv,_ZTv0_n16_N3ccc8DD10x8y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y0E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y0E[] = {
  {&(_ZTVN3ccc8DD10x8y0E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y0E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y0E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y0E[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y03abcEv,_ZTv0_n16_N3ccc8DD10x8y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y03abcEv,_ZThn4_N3ccc8DD10x8y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y03efgEv,_ZTv0_n12_N3ccc8DD10x8y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y03efgEv,_ZThn4_N3ccc8DD10x8y03efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y0E = {  "_ZN3ccc8DD10x8y0E", // class name
  bases__ZN3ccc8DD10x8y0E, 2,
  &(vtc__ZN3ccc8DD10x8y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y0E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y1  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8CC10x8y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x8y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x8y13efgEv
  ~CC10x8y1(); // tgen
  CC10x8y1(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y1E) C1{ VBC2{ v2 v1} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x8y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y13abcEv");}
void  ccc::CC10x8y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y13pqrEv");}
void  ccc::CC10x8y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y13efgEv");}
ccc::CC10x8y1 ::~CC10x8y1(){ note_dtor("_ZN3ccc8CC10x8y1E", this);} // tgen
ccc::CC10x8y1 ::CC10x8y1(){ note_ctor("_ZN3ccc8CC10x8y1E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y1E, buf);
    ::ccc::CC10x8y1 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y1E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y1E);
    dp->::ccc::CC10x8y1::~CC10x8y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y1E(Test__ZN3ccc8CC10x8y1E, "_ZN3ccc8CC10x8y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y1C1Ev();
extern void _ZN3ccc8CC10x8y1D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y1E[] = {
  NSPAIR(_ZN3ccc8CC10x8y1C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y1E[];
extern void _ZN3ccc8CC10x8y13efgEv();
extern void _ZN3ccc8CC10x8y13abcEv();
extern void _ZN3ccc8CC10x8y13pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y13pqrEv,_ZTv0_n12_N3ccc8CC10x8y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y13pqrEv,_ZThn4_N3ccc8CC10x8y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y13abcEv,_ZTv0_n16_N3ccc8CC10x8y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y13abcEv,_ZThn4_N3ccc8CC10x8y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y13pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y13pqrEv,_ZTv0_n12_N3ccc8CC10x8y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y13abcEv,_ZTv0_n16_N3ccc8CC10x8y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y1E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y1E[] = {
  {&(_ZTVN3ccc8CC10x8y1E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y1E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y1E[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y13abcEv,_ZTv0_n16_N3ccc8CC10x8y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y13abcEv,_ZThn4_N3ccc8CC10x8y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y13pqrEv,_ZTv0_n12_N3ccc8CC10x8y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y13pqrEv,_ZThn4_N3ccc8CC10x8y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y1E = {  "_ZN3ccc8CC10x8y1E", // class name
  bases__ZN3ccc8CC10x8y1E, 2,
  &(vtc__ZN3ccc8CC10x8y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y1E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y1  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8DD10x8y13abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x8y13pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x8y13efgEv
  ~DD10x8y1(); // tgen
  DD10x8y1(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y1E) C1{ VBC2{ v2 v1} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x8y1 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y13abcEv");}
void  ccc::DD10x8y1 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y13pqrEv");}
void  ccc::DD10x8y1 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y13efgEv");}
ccc::DD10x8y1 ::~DD10x8y1(){ note_dtor("_ZN3ccc8DD10x8y1E", this);} // tgen
ccc::DD10x8y1 ::DD10x8y1(){ note_ctor("_ZN3ccc8DD10x8y1E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y1E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y1E, buf);
    ::ccc::DD10x8y1 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y1E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y1E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y1E);
    dp->::ccc::DD10x8y1::~DD10x8y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y1E(Test__ZN3ccc8DD10x8y1E, "_ZN3ccc8DD10x8y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y1C1Ev();
extern void _ZN3ccc8DD10x8y1D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y1E[] = {
  NSPAIR(_ZN3ccc8DD10x8y1C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y1E[];
extern void _ZN3ccc8DD10x8y13pqrEv();
extern void _ZN3ccc8DD10x8y13abcEv();
extern void _ZN3ccc8DD10x8y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y13efgEv,_ZTv0_n12_N3ccc8DD10x8y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y13efgEv,_ZThn4_N3ccc8DD10x8y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y13abcEv,_ZTv0_n16_N3ccc8DD10x8y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y13abcEv,_ZThn4_N3ccc8DD10x8y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y13efgEv,_ZTv0_n12_N3ccc8DD10x8y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y13abcEv,_ZTv0_n16_N3ccc8DD10x8y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y1E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y1E[] = {
  {&(_ZTVN3ccc8DD10x8y1E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y1E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y1E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y1E[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y13abcEv,_ZTv0_n16_N3ccc8DD10x8y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y13abcEv,_ZThn4_N3ccc8DD10x8y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y13efgEv,_ZTv0_n12_N3ccc8DD10x8y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y13efgEv,_ZThn4_N3ccc8DD10x8y13efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y1E = {  "_ZN3ccc8DD10x8y1E", // class name
  bases__ZN3ccc8DD10x8y1E, 2,
  &(vtc__ZN3ccc8DD10x8y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y1E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y2  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8CC10x8y23efgEv
  virtual void  abc(); // _ZN3ccc8CC10x8y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x8y23pqrEv
  ~CC10x8y2(); // tgen
  CC10x8y2(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y2E) C1{ VBC2{ v3 v2} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x8y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y23efgEv");}
void  ccc::CC10x8y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y23abcEv");}
void  ccc::CC10x8y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y23pqrEv");}
ccc::CC10x8y2 ::~CC10x8y2(){ note_dtor("_ZN3ccc8CC10x8y2E", this);} // tgen
ccc::CC10x8y2 ::CC10x8y2(){ note_ctor("_ZN3ccc8CC10x8y2E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y2E, buf);
    ::ccc::CC10x8y2 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y2E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y2E);
    dp->::ccc::CC10x8y2::~CC10x8y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y2E(Test__ZN3ccc8CC10x8y2E, "_ZN3ccc8CC10x8y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y2C1Ev();
extern void _ZN3ccc8CC10x8y2D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y2E[] = {
  NSPAIR(_ZN3ccc8CC10x8y2C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y2E[];
extern void _ZN3ccc8CC10x8y23efgEv();
extern void _ZN3ccc8CC10x8y23abcEv();
extern void _ZN3ccc8CC10x8y23pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y23pqrEv,_ZTv0_n12_N3ccc8CC10x8y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y23pqrEv,_ZThn4_N3ccc8CC10x8y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y23abcEv,_ZTv0_n16_N3ccc8CC10x8y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y23abcEv,_ZThn4_N3ccc8CC10x8y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y23pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y23pqrEv,_ZTv0_n12_N3ccc8CC10x8y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y23abcEv,_ZTv0_n16_N3ccc8CC10x8y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y2E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y2E[] = {
  {&(_ZTVN3ccc8CC10x8y2E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y2E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y2E[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y23abcEv,_ZTv0_n16_N3ccc8CC10x8y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y23abcEv,_ZThn4_N3ccc8CC10x8y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y23pqrEv,_ZTv0_n12_N3ccc8CC10x8y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y23pqrEv,_ZThn4_N3ccc8CC10x8y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y2E = {  "_ZN3ccc8CC10x8y2E", // class name
  bases__ZN3ccc8CC10x8y2E, 2,
  &(vtc__ZN3ccc8CC10x8y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y2E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y2  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8DD10x8y23efgEv
  virtual void  abc(); // _ZN3ccc8DD10x8y23abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x8y23pqrEv
  ~DD10x8y2(); // tgen
  DD10x8y2(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y2E) C1{ VBC2{ v3 v2} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x8y2 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y23efgEv");}
void  ccc::DD10x8y2 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y23abcEv");}
void  ccc::DD10x8y2 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y23pqrEv");}
ccc::DD10x8y2 ::~DD10x8y2(){ note_dtor("_ZN3ccc8DD10x8y2E", this);} // tgen
ccc::DD10x8y2 ::DD10x8y2(){ note_ctor("_ZN3ccc8DD10x8y2E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y2E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y2E, buf);
    ::ccc::DD10x8y2 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y2E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y2E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y2E);
    dp->::ccc::DD10x8y2::~DD10x8y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y2E(Test__ZN3ccc8DD10x8y2E, "_ZN3ccc8DD10x8y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y2C1Ev();
extern void _ZN3ccc8DD10x8y2D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y2E[] = {
  NSPAIR(_ZN3ccc8DD10x8y2C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y2E[];
extern void _ZN3ccc8DD10x8y23pqrEv();
extern void _ZN3ccc8DD10x8y23abcEv();
extern void _ZN3ccc8DD10x8y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y23efgEv,_ZTv0_n12_N3ccc8DD10x8y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y23efgEv,_ZThn4_N3ccc8DD10x8y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y23abcEv,_ZTv0_n16_N3ccc8DD10x8y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y23abcEv,_ZThn4_N3ccc8DD10x8y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y23efgEv,_ZTv0_n12_N3ccc8DD10x8y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y23abcEv,_ZTv0_n16_N3ccc8DD10x8y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y2E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y2E[] = {
  {&(_ZTVN3ccc8DD10x8y2E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y2E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y2E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y2E[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y23abcEv,_ZTv0_n16_N3ccc8DD10x8y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y23abcEv,_ZThn4_N3ccc8DD10x8y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y23efgEv,_ZTv0_n12_N3ccc8DD10x8y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y23efgEv,_ZThn4_N3ccc8DD10x8y23efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y2E = {  "_ZN3ccc8DD10x8y2E", // class name
  bases__ZN3ccc8DD10x8y2E, 2,
  &(vtc__ZN3ccc8DD10x8y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y2E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y3  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8CC10x8y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x8y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x8y33abcEv
  ~CC10x8y3(); // tgen
  CC10x8y3(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y3E) C1{ VBC2{ v2 v3} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x8y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y33efgEv");}
void  ccc::CC10x8y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y33pqrEv");}
void  ccc::CC10x8y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y33abcEv");}
ccc::CC10x8y3 ::~CC10x8y3(){ note_dtor("_ZN3ccc8CC10x8y3E", this);} // tgen
ccc::CC10x8y3 ::CC10x8y3(){ note_ctor("_ZN3ccc8CC10x8y3E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y3E, buf);
    ::ccc::CC10x8y3 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y3E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y3E);
    dp->::ccc::CC10x8y3::~CC10x8y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y3E(Test__ZN3ccc8CC10x8y3E, "_ZN3ccc8CC10x8y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y3C1Ev();
extern void _ZN3ccc8CC10x8y3D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y3E[] = {
  NSPAIR(_ZN3ccc8CC10x8y3C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y3E[];
extern void _ZN3ccc8CC10x8y33efgEv();
extern void _ZN3ccc8CC10x8y33abcEv();
extern void _ZN3ccc8CC10x8y33pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y33pqrEv,_ZTv0_n12_N3ccc8CC10x8y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y33pqrEv,_ZThn4_N3ccc8CC10x8y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y33abcEv,_ZTv0_n16_N3ccc8CC10x8y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y33abcEv,_ZThn4_N3ccc8CC10x8y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y33pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y33pqrEv,_ZTv0_n12_N3ccc8CC10x8y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y33abcEv,_ZTv0_n16_N3ccc8CC10x8y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y3E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y3E[] = {
  {&(_ZTVN3ccc8CC10x8y3E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y3E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y3E[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y33abcEv,_ZTv0_n16_N3ccc8CC10x8y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y33abcEv,_ZThn4_N3ccc8CC10x8y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y33pqrEv,_ZTv0_n12_N3ccc8CC10x8y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y33pqrEv,_ZThn4_N3ccc8CC10x8y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y3E = {  "_ZN3ccc8CC10x8y3E", // class name
  bases__ZN3ccc8CC10x8y3E, 2,
  &(vtc__ZN3ccc8CC10x8y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y3E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y3  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8DD10x8y33efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x8y33pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x8y33abcEv
  ~DD10x8y3(); // tgen
  DD10x8y3(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y3E) C1{ VBC2{ v2 v3} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x8y3 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y33efgEv");}
void  ccc::DD10x8y3 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y33pqrEv");}
void  ccc::DD10x8y3 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y33abcEv");}
ccc::DD10x8y3 ::~DD10x8y3(){ note_dtor("_ZN3ccc8DD10x8y3E", this);} // tgen
ccc::DD10x8y3 ::DD10x8y3(){ note_ctor("_ZN3ccc8DD10x8y3E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y3E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y3E, buf);
    ::ccc::DD10x8y3 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y3E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y3E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y3E);
    dp->::ccc::DD10x8y3::~DD10x8y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y3E(Test__ZN3ccc8DD10x8y3E, "_ZN3ccc8DD10x8y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y3C1Ev();
extern void _ZN3ccc8DD10x8y3D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y3E[] = {
  NSPAIR(_ZN3ccc8DD10x8y3C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y3E[];
extern void _ZN3ccc8DD10x8y33pqrEv();
extern void _ZN3ccc8DD10x8y33abcEv();
extern void _ZN3ccc8DD10x8y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y33efgEv,_ZTv0_n12_N3ccc8DD10x8y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y33efgEv,_ZThn4_N3ccc8DD10x8y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y33abcEv,_ZTv0_n16_N3ccc8DD10x8y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y33abcEv,_ZThn4_N3ccc8DD10x8y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y33efgEv,_ZTv0_n12_N3ccc8DD10x8y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y33abcEv,_ZTv0_n16_N3ccc8DD10x8y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y3E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y3E[] = {
  {&(_ZTVN3ccc8DD10x8y3E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y3E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y3E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y3E[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y33abcEv,_ZTv0_n16_N3ccc8DD10x8y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y33abcEv,_ZThn4_N3ccc8DD10x8y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y33efgEv,_ZTv0_n12_N3ccc8DD10x8y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y33efgEv,_ZThn4_N3ccc8DD10x8y33efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y3E = {  "_ZN3ccc8DD10x8y3E", // class name
  bases__ZN3ccc8DD10x8y3E, 2,
  &(vtc__ZN3ccc8DD10x8y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y3E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y4  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC10x8y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x8y43abcEv
  virtual void  efg(); // _ZN3ccc8CC10x8y43efgEv
  ~CC10x8y4(); // tgen
  CC10x8y4(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y4E) C1{ VBC2{ v1 v2} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x8y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y43pqrEv");}
void  ccc::CC10x8y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y43abcEv");}
void  ccc::CC10x8y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y43efgEv");}
ccc::CC10x8y4 ::~CC10x8y4(){ note_dtor("_ZN3ccc8CC10x8y4E", this);} // tgen
ccc::CC10x8y4 ::CC10x8y4(){ note_ctor("_ZN3ccc8CC10x8y4E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y4E, buf);
    ::ccc::CC10x8y4 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y4E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y4E);
    dp->::ccc::CC10x8y4::~CC10x8y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y4E(Test__ZN3ccc8CC10x8y4E, "_ZN3ccc8CC10x8y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y4C1Ev();
extern void _ZN3ccc8CC10x8y4D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y4E[] = {
  NSPAIR(_ZN3ccc8CC10x8y4C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y4E[];
extern void _ZN3ccc8CC10x8y43efgEv();
extern void _ZN3ccc8CC10x8y43abcEv();
extern void _ZN3ccc8CC10x8y43pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y43pqrEv,_ZTv0_n12_N3ccc8CC10x8y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y43pqrEv,_ZThn4_N3ccc8CC10x8y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y43abcEv,_ZTv0_n16_N3ccc8CC10x8y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y43abcEv,_ZThn4_N3ccc8CC10x8y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y43pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y43pqrEv,_ZTv0_n12_N3ccc8CC10x8y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y43abcEv,_ZTv0_n16_N3ccc8CC10x8y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y4E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y4E[] = {
  {&(_ZTVN3ccc8CC10x8y4E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y4E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y4E[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y43abcEv,_ZTv0_n16_N3ccc8CC10x8y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y43abcEv,_ZThn4_N3ccc8CC10x8y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y43pqrEv,_ZTv0_n12_N3ccc8CC10x8y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y43pqrEv,_ZThn4_N3ccc8CC10x8y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y4E = {  "_ZN3ccc8CC10x8y4E", // class name
  bases__ZN3ccc8CC10x8y4E, 2,
  &(vtc__ZN3ccc8CC10x8y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y4E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y4  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8DD10x8y43pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x8y43abcEv
  virtual void  efg(); // _ZN3ccc8DD10x8y43efgEv
  ~DD10x8y4(); // tgen
  DD10x8y4(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y4E) C1{ VBC2{ v1 v2} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x8y4 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y43pqrEv");}
void  ccc::DD10x8y4 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y43abcEv");}
void  ccc::DD10x8y4 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y43efgEv");}
ccc::DD10x8y4 ::~DD10x8y4(){ note_dtor("_ZN3ccc8DD10x8y4E", this);} // tgen
ccc::DD10x8y4 ::DD10x8y4(){ note_ctor("_ZN3ccc8DD10x8y4E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y4E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y4E, buf);
    ::ccc::DD10x8y4 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y4E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y4E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y4E);
    dp->::ccc::DD10x8y4::~DD10x8y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y4E(Test__ZN3ccc8DD10x8y4E, "_ZN3ccc8DD10x8y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y4C1Ev();
extern void _ZN3ccc8DD10x8y4D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y4E[] = {
  NSPAIR(_ZN3ccc8DD10x8y4C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y4E[];
extern void _ZN3ccc8DD10x8y43pqrEv();
extern void _ZN3ccc8DD10x8y43abcEv();
extern void _ZN3ccc8DD10x8y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y43efgEv,_ZTv0_n12_N3ccc8DD10x8y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y43efgEv,_ZThn4_N3ccc8DD10x8y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y43abcEv,_ZTv0_n16_N3ccc8DD10x8y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y43abcEv,_ZThn4_N3ccc8DD10x8y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y43efgEv,_ZTv0_n12_N3ccc8DD10x8y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y43abcEv,_ZTv0_n16_N3ccc8DD10x8y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y4E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y4E[] = {
  {&(_ZTVN3ccc8DD10x8y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y4E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y4E[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y43abcEv,_ZTv0_n16_N3ccc8DD10x8y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y43abcEv,_ZThn4_N3ccc8DD10x8y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y43efgEv,_ZTv0_n12_N3ccc8DD10x8y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y43efgEv,_ZThn4_N3ccc8DD10x8y43efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y4E = {  "_ZN3ccc8DD10x8y4E", // class name
  bases__ZN3ccc8DD10x8y4E, 2,
  &(vtc__ZN3ccc8DD10x8y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y4E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y5  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC10x8y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x8y53efgEv
  virtual void  abc(); // _ZN3ccc8CC10x8y53abcEv
  ~CC10x8y5(); // tgen
  CC10x8y5(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y5E) C1{ VBC2{ v1 v3} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x8y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y53pqrEv");}
void  ccc::CC10x8y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y53efgEv");}
void  ccc::CC10x8y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y53abcEv");}
ccc::CC10x8y5 ::~CC10x8y5(){ note_dtor("_ZN3ccc8CC10x8y5E", this);} // tgen
ccc::CC10x8y5 ::CC10x8y5(){ note_ctor("_ZN3ccc8CC10x8y5E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y5E, buf);
    ::ccc::CC10x8y5 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y5E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y5E);
    dp->::ccc::CC10x8y5::~CC10x8y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y5E(Test__ZN3ccc8CC10x8y5E, "_ZN3ccc8CC10x8y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y5C1Ev();
extern void _ZN3ccc8CC10x8y5D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y5E[] = {
  NSPAIR(_ZN3ccc8CC10x8y5C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y5E[];
extern void _ZN3ccc8CC10x8y53efgEv();
extern void _ZN3ccc8CC10x8y53abcEv();
extern void _ZN3ccc8CC10x8y53pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y53pqrEv,_ZTv0_n12_N3ccc8CC10x8y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y53pqrEv,_ZThn4_N3ccc8CC10x8y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y53abcEv,_ZTv0_n16_N3ccc8CC10x8y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y53abcEv,_ZThn4_N3ccc8CC10x8y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y53pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y53pqrEv,_ZTv0_n12_N3ccc8CC10x8y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y53abcEv,_ZTv0_n16_N3ccc8CC10x8y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y5E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y5E[] = {
  {&(_ZTVN3ccc8CC10x8y5E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y5E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y5E[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y53abcEv,_ZTv0_n16_N3ccc8CC10x8y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y53abcEv,_ZThn4_N3ccc8CC10x8y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y53pqrEv,_ZTv0_n12_N3ccc8CC10x8y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y53pqrEv,_ZThn4_N3ccc8CC10x8y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y5E = {  "_ZN3ccc8CC10x8y5E", // class name
  bases__ZN3ccc8CC10x8y5E, 2,
  &(vtc__ZN3ccc8CC10x8y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y5E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y5  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8DD10x8y53pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x8y53efgEv
  virtual void  abc(); // _ZN3ccc8DD10x8y53abcEv
  ~DD10x8y5(); // tgen
  DD10x8y5(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y5E) C1{ VBC2{ v1 v3} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x8y5 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y53pqrEv");}
void  ccc::DD10x8y5 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y53efgEv");}
void  ccc::DD10x8y5 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y53abcEv");}
ccc::DD10x8y5 ::~DD10x8y5(){ note_dtor("_ZN3ccc8DD10x8y5E", this);} // tgen
ccc::DD10x8y5 ::DD10x8y5(){ note_ctor("_ZN3ccc8DD10x8y5E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y5E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y5E, buf);
    ::ccc::DD10x8y5 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y5E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y5E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y5E);
    dp->::ccc::DD10x8y5::~DD10x8y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y5E(Test__ZN3ccc8DD10x8y5E, "_ZN3ccc8DD10x8y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y5C1Ev();
extern void _ZN3ccc8DD10x8y5D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y5E[] = {
  NSPAIR(_ZN3ccc8DD10x8y5C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y5E[];
extern void _ZN3ccc8DD10x8y53pqrEv();
extern void _ZN3ccc8DD10x8y53abcEv();
extern void _ZN3ccc8DD10x8y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y53efgEv,_ZTv0_n12_N3ccc8DD10x8y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y53efgEv,_ZThn4_N3ccc8DD10x8y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y53abcEv,_ZTv0_n16_N3ccc8DD10x8y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y53abcEv,_ZThn4_N3ccc8DD10x8y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y53efgEv,_ZTv0_n12_N3ccc8DD10x8y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y53abcEv,_ZTv0_n16_N3ccc8DD10x8y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y5E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y5E[] = {
  {&(_ZTVN3ccc8DD10x8y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y5E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y5E[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y53abcEv,_ZTv0_n16_N3ccc8DD10x8y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y53abcEv,_ZThn4_N3ccc8DD10x8y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y53efgEv,_ZTv0_n12_N3ccc8DD10x8y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y53efgEv,_ZThn4_N3ccc8DD10x8y53efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y5E = {  "_ZN3ccc8DD10x8y5E", // class name
  bases__ZN3ccc8DD10x8y5E, 2,
  &(vtc__ZN3ccc8DD10x8y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y5E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y6  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8CC10x8y63abcEv
  virtual void  efg(); // _ZN3ccc8CC10x8y63efgEv
  ~CC10x8y6(); // tgen
  CC10x8y6(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y6E) C1{ VBC2{ v3 v1} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x8y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y63abcEv");}
void  ccc::CC10x8y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y63efgEv");}
ccc::CC10x8y6 ::~CC10x8y6(){ note_dtor("_ZN3ccc8CC10x8y6E", this);} // tgen
ccc::CC10x8y6 ::CC10x8y6(){ note_ctor("_ZN3ccc8CC10x8y6E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y6E, buf);
    ::ccc::CC10x8y6 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y6E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y6E);
    dp->::ccc::CC10x8y6::~CC10x8y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y6E(Test__ZN3ccc8CC10x8y6E, "_ZN3ccc8CC10x8y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y6C1Ev();
extern void _ZN3ccc8CC10x8y6D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y6E[] = {
  NSPAIR(_ZN3ccc8CC10x8y6C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y6E[];
extern void _ZN3ccc8CC10x8y63efgEv();
extern void _ZN3ccc8CC10x8y63abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y63abcEv,_ZTv0_n16_N3ccc8CC10x8y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y63abcEv,_ZThn4_N3ccc8CC10x8y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y63abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y63abcEv,_ZTv0_n16_N3ccc8CC10x8y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y6E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y6E[] = {
  {&(_ZTVN3ccc8CC10x8y6E[3]),  3,11},
  {&(_ZTVN3ccc8CC10x8y6E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y6E[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y63abcEv,_ZTv0_n16_N3ccc8CC10x8y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y63abcEv,_ZThn4_N3ccc8CC10x8y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y6E = {  "_ZN3ccc8CC10x8y6E", // class name
  bases__ZN3ccc8CC10x8y6E, 2,
  &(vtc__ZN3ccc8CC10x8y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y6E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y6  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8DD10x8y63abcEv
  virtual void  efg(); // _ZN3ccc8DD10x8y63efgEv
  ~DD10x8y6(); // tgen
  DD10x8y6(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y6E) C1{ VBC2{ v3 v1} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x8y6 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y63abcEv");}
void  ccc::DD10x8y6 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y63efgEv");}
ccc::DD10x8y6 ::~DD10x8y6(){ note_dtor("_ZN3ccc8DD10x8y6E", this);} // tgen
ccc::DD10x8y6 ::DD10x8y6(){ note_ctor("_ZN3ccc8DD10x8y6E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y6E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y6E, buf);
    ::ccc::DD10x8y6 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y6E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y6E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y6E);
    dp->::ccc::DD10x8y6::~DD10x8y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y6E(Test__ZN3ccc8DD10x8y6E, "_ZN3ccc8DD10x8y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y6C1Ev();
extern void _ZN3ccc8DD10x8y6D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y6E[] = {
  NSPAIR(_ZN3ccc8DD10x8y6C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x8y63abcEv();
extern void _ZN3ccc8DD10x8y63efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y63efgEv,_ZTv0_n12_N3ccc8DD10x8y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y63efgEv,_ZThn4_N3ccc8DD10x8y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y63abcEv,_ZTv0_n16_N3ccc8DD10x8y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y63abcEv,_ZThn4_N3ccc8DD10x8y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y63efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y63efgEv,_ZTv0_n12_N3ccc8DD10x8y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y63abcEv,_ZTv0_n16_N3ccc8DD10x8y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y6E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y6E[] = {
  {&(_ZTVN3ccc8DD10x8y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y6E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y6E[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y63abcEv,_ZTv0_n16_N3ccc8DD10x8y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y63abcEv,_ZThn4_N3ccc8DD10x8y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y63efgEv,_ZTv0_n12_N3ccc8DD10x8y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y63efgEv,_ZThn4_N3ccc8DD10x8y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y6E = {  "_ZN3ccc8DD10x8y6E", // class name
  bases__ZN3ccc8DD10x8y6E, 2,
  &(vtc__ZN3ccc8DD10x8y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y6E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y7  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8CC10x8y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x8y73pqrEv
  ~CC10x8y7(); // tgen
  CC10x8y7(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y7E) C1{ VBC2{ v2 v1} BC3{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x8y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y73abcEv");}
void  ccc::CC10x8y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y73pqrEv");}
ccc::CC10x8y7 ::~CC10x8y7(){ note_dtor("_ZN3ccc8CC10x8y7E", this);} // tgen
ccc::CC10x8y7 ::CC10x8y7(){ note_ctor("_ZN3ccc8CC10x8y7E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y7E, buf);
    ::ccc::CC10x8y7 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y7E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y7E);
    dp->::ccc::CC10x8y7::~CC10x8y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y7E(Test__ZN3ccc8CC10x8y7E, "_ZN3ccc8CC10x8y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y7C1Ev();
extern void _ZN3ccc8CC10x8y7D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y7E[] = {
  NSPAIR(_ZN3ccc8CC10x8y7C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y7E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc8CC10x8y73abcEv();
extern void _ZN3ccc8CC10x8y73pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y73pqrEv,_ZTv0_n12_N3ccc8CC10x8y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y73pqrEv,_ZThn4_N3ccc8CC10x8y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y73abcEv,_ZTv0_n16_N3ccc8CC10x8y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y73abcEv,_ZThn4_N3ccc8CC10x8y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y73pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y73pqrEv,_ZTv0_n12_N3ccc8CC10x8y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y73abcEv,_ZTv0_n16_N3ccc8CC10x8y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y7E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y7E[] = {
  {&(_ZTVN3ccc8CC10x8y7E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y7E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y7E[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y73abcEv,_ZTv0_n16_N3ccc8CC10x8y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y73abcEv,_ZThn4_N3ccc8CC10x8y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y73pqrEv,_ZTv0_n12_N3ccc8CC10x8y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y73pqrEv,_ZThn4_N3ccc8CC10x8y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y7E = {  "_ZN3ccc8CC10x8y7E", // class name
  bases__ZN3ccc8CC10x8y7E, 2,
  &(vtc__ZN3ccc8CC10x8y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y7E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y7  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8DD10x8y73abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x8y73pqrEv
  ~DD10x8y7(); // tgen
  DD10x8y7(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y7E) C1{ VBC2{ v2 v1} VBC3{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x8y7 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y73abcEv");}
void  ccc::DD10x8y7 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y73pqrEv");}
ccc::DD10x8y7 ::~DD10x8y7(){ note_dtor("_ZN3ccc8DD10x8y7E", this);} // tgen
ccc::DD10x8y7 ::DD10x8y7(){ note_ctor("_ZN3ccc8DD10x8y7E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y7E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y7E, buf);
    ::ccc::DD10x8y7 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y7E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y7E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y7E);
    dp->::ccc::DD10x8y7::~DD10x8y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y7E(Test__ZN3ccc8DD10x8y7E, "_ZN3ccc8DD10x8y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y7C1Ev();
extern void _ZN3ccc8DD10x8y7D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y7E[] = {
  NSPAIR(_ZN3ccc8DD10x8y7C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y7E[];
extern void _ZN3ccc8DD10x8y73pqrEv();
extern void _ZN3ccc8DD10x8y73abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y73abcEv,_ZTv0_n16_N3ccc8DD10x8y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y73abcEv,_ZThn4_N3ccc8DD10x8y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y73abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y73abcEv,_ZTv0_n16_N3ccc8DD10x8y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y7E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y7E[] = {
  {&(_ZTVN3ccc8DD10x8y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x8y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x8y7E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y7E[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y73abcEv,_ZTv0_n16_N3ccc8DD10x8y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y73abcEv,_ZThn4_N3ccc8DD10x8y73abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y7E = {  "_ZN3ccc8DD10x8y7E", // class name
  bases__ZN3ccc8DD10x8y7E, 2,
  &(vtc__ZN3ccc8DD10x8y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y7E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y8  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8CC10x8y83efgEv
  virtual void  abc(); // _ZN3ccc8CC10x8y83abcEv
  ~CC10x8y8(); // tgen
  CC10x8y8(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y8E) C1{ VBC2{ v3 v2} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x8y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y83efgEv");}
void  ccc::CC10x8y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x8y83abcEv");}
ccc::CC10x8y8 ::~CC10x8y8(){ note_dtor("_ZN3ccc8CC10x8y8E", this);} // tgen
ccc::CC10x8y8 ::CC10x8y8(){ note_ctor("_ZN3ccc8CC10x8y8E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y8E, buf);
    ::ccc::CC10x8y8 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y8E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y8E);
    dp->::ccc::CC10x8y8::~CC10x8y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y8E(Test__ZN3ccc8CC10x8y8E, "_ZN3ccc8CC10x8y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y8C1Ev();
extern void _ZN3ccc8CC10x8y8D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y8E[] = {
  NSPAIR(_ZN3ccc8CC10x8y8C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y8E[];
extern void _ZN3ccc8CC10x8y83efgEv();
extern void _ZN3ccc8CC10x8y83abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x8y83abcEv,_ZTv0_n16_N3ccc8CC10x8y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y83abcEv,_ZThn4_N3ccc8CC10x8y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y83abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x8y83abcEv,_ZTv0_n16_N3ccc8CC10x8y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y8E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y8E[] = {
  {&(_ZTVN3ccc8CC10x8y8E[3]),  3,11},
  {&(_ZTVN3ccc8CC10x8y8E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y8E[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x8y83abcEv,_ZTv0_n16_N3ccc8CC10x8y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y83abcEv,_ZThn4_N3ccc8CC10x8y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y8E = {  "_ZN3ccc8CC10x8y8E", // class name
  bases__ZN3ccc8CC10x8y8E, 2,
  &(vtc__ZN3ccc8CC10x8y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y8E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y8  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8DD10x8y83efgEv
  virtual void  abc(); // _ZN3ccc8DD10x8y83abcEv
  ~DD10x8y8(); // tgen
  DD10x8y8(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y8E) C1{ VBC2{ v3 v2} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x8y8 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y83efgEv");}
void  ccc::DD10x8y8 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x8y83abcEv");}
ccc::DD10x8y8 ::~DD10x8y8(){ note_dtor("_ZN3ccc8DD10x8y8E", this);} // tgen
ccc::DD10x8y8 ::DD10x8y8(){ note_ctor("_ZN3ccc8DD10x8y8E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y8E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y8E, buf);
    ::ccc::DD10x8y8 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y8E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y8E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y8E);
    dp->::ccc::DD10x8y8::~DD10x8y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y8E(Test__ZN3ccc8DD10x8y8E, "_ZN3ccc8DD10x8y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y8C1Ev();
extern void _ZN3ccc8DD10x8y8D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y8E[] = {
  NSPAIR(_ZN3ccc8DD10x8y8C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x8y83abcEv();
extern void _ZN3ccc8DD10x8y83efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y83efgEv,_ZTv0_n12_N3ccc8DD10x8y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y83efgEv,_ZThn4_N3ccc8DD10x8y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x8y83abcEv,_ZTv0_n16_N3ccc8DD10x8y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y83abcEv,_ZThn4_N3ccc8DD10x8y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y83efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y83efgEv,_ZTv0_n12_N3ccc8DD10x8y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x8y83abcEv,_ZTv0_n16_N3ccc8DD10x8y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y8E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y8E[] = {
  {&(_ZTVN3ccc8DD10x8y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y8E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y8E[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x8y83abcEv,_ZTv0_n16_N3ccc8DD10x8y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y83abcEv,_ZThn4_N3ccc8DD10x8y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y83efgEv,_ZTv0_n12_N3ccc8DD10x8y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y83efgEv,_ZThn4_N3ccc8DD10x8y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y8E = {  "_ZN3ccc8DD10x8y8E", // class name
  bases__ZN3ccc8DD10x8y8E, 2,
  &(vtc__ZN3ccc8DD10x8y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y8E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y9  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8CC10x8y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x8y93pqrEv
  ~CC10x8y9(); // tgen
  CC10x8y9(); // tgen
};
//SIG(1 _ZN3ccc8CC10x8y9E) C1{ VBC2{ v2 v3} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x8y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x8y93efgEv");}
void  ccc::CC10x8y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x8y93pqrEv");}
ccc::CC10x8y9 ::~CC10x8y9(){ note_dtor("_ZN3ccc8CC10x8y9E", this);} // tgen
ccc::CC10x8y9 ::CC10x8y9(){ note_ctor("_ZN3ccc8CC10x8y9E", this);} // tgen
}
static void Test__ZN3ccc8CC10x8y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x8y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x8y9E, buf);
    ::ccc::CC10x8y9 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x8y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x8y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x8y9E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC10x8y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x8y9E);
    dp->::ccc::CC10x8y9::~CC10x8y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x8y9E(Test__ZN3ccc8CC10x8y9E, "_ZN3ccc8CC10x8y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x8y9C1Ev();
extern void _ZN3ccc8CC10x8y9D1Ev();
Name_Map name_map__ZN3ccc8CC10x8y9E[] = {
  NSPAIR(_ZN3ccc8CC10x8y9C1Ev),
  NSPAIR(_ZN3ccc8CC10x8y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC10x8y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y9E[];
extern void _ZN3ccc8CC10x8y93efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc8CC10x8y93pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x8y93pqrEv,_ZTv0_n12_N3ccc8CC10x8y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x8y93pqrEv,_ZThn4_N3ccc8CC10x8y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC10x8y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x8y93pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x8y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x8y93pqrEv,_ZTv0_n12_N3ccc8CC10x8y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x8y9E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x8y9E[] = {
  {&(_ZTVN3ccc8CC10x8y9E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x8y9E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x8y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x8y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x8y9E[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x8y93pqrEv,_ZTv0_n12_N3ccc8CC10x8y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x8y93pqrEv,_ZThn4_N3ccc8CC10x8y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x8y9E = {  "_ZN3ccc8CC10x8y9E", // class name
  bases__ZN3ccc8CC10x8y9E, 2,
  &(vtc__ZN3ccc8CC10x8y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x8y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x8y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x8y9E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x8y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y9  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8DD10x8y93efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x8y93pqrEv
  ~DD10x8y9(); // tgen
  DD10x8y9(); // tgen
};
//SIG(1 _ZN3ccc8DD10x8y9E) C1{ VBC2{ v2 v3} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x8y9 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x8y93efgEv");}
void  ccc::DD10x8y9 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x8y93pqrEv");}
ccc::DD10x8y9 ::~DD10x8y9(){ note_dtor("_ZN3ccc8DD10x8y9E", this);} // tgen
ccc::DD10x8y9 ::DD10x8y9(){ note_ctor("_ZN3ccc8DD10x8y9E", this);} // tgen
}
static void Test__ZN3ccc8DD10x8y9E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x8y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x8y9E, buf);
    ::ccc::DD10x8y9 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x8y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x8y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x8y9E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD10x8y9E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x8y9E);
    dp->::ccc::DD10x8y9::~DD10x8y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x8y9E(Test__ZN3ccc8DD10x8y9E, "_ZN3ccc8DD10x8y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x8y9C1Ev();
extern void _ZN3ccc8DD10x8y9D1Ev();
Name_Map name_map__ZN3ccc8DD10x8y9E[] = {
  NSPAIR(_ZN3ccc8DD10x8y9C1Ev),
  NSPAIR(_ZN3ccc8DD10x8y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD10x8y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y9E[];
extern void _ZN3ccc8DD10x8y93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc8DD10x8y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x8y93efgEv,_ZTv0_n12_N3ccc8DD10x8y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x8y93efgEv,_ZThn4_N3ccc8DD10x8y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD10x8y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x8y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x8y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x8y93efgEv,_ZTv0_n12_N3ccc8DD10x8y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x8y9E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x8y9E[] = {
  {&(_ZTVN3ccc8DD10x8y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x8y9E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x8y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x8y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x8y9E[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x8y93efgEv,_ZTv0_n12_N3ccc8DD10x8y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x8y93efgEv,_ZThn4_N3ccc8DD10x8y93efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x8y9E = {  "_ZN3ccc8DD10x8y9E", // class name
  bases__ZN3ccc8DD10x8y9E, 2,
  &(vtc__ZN3ccc8DD10x8y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x8y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x8y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x8y9E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x8y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y10  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc9CC10x8y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x8y103abcEv
  ~CC10x8y10(); // tgen
  CC10x8y10(); // tgen
};
//SIG(1 _ZN3ccc9CC10x8y10E) C1{ VBC2{ v1 v2} BC3{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x8y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x8y103pqrEv");}
void  ccc::CC10x8y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x8y103abcEv");}
ccc::CC10x8y10 ::~CC10x8y10(){ note_dtor("_ZN3ccc9CC10x8y10E", this);} // tgen
ccc::CC10x8y10 ::CC10x8y10(){ note_ctor("_ZN3ccc9CC10x8y10E", this);} // tgen
}
static void Test__ZN3ccc9CC10x8y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x8y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x8y10E, buf);
    ::ccc::CC10x8y10 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x8y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x8y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x8y10E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc9CC10x8y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x8y10E);
    dp->::ccc::CC10x8y10::~CC10x8y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x8y10E(Test__ZN3ccc9CC10x8y10E, "_ZN3ccc9CC10x8y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x8y10C1Ev();
extern void _ZN3ccc9CC10x8y10D1Ev();
Name_Map name_map__ZN3ccc9CC10x8y10E[] = {
  NSPAIR(_ZN3ccc9CC10x8y10C1Ev),
  NSPAIR(_ZN3ccc9CC10x8y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9CC10x8y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y10E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc9CC10x8y103abcEv();
extern void _ZN3ccc9CC10x8y103pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x8y103pqrEv,_ZTv0_n12_N3ccc9CC10x8y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x8y103pqrEv,_ZThn4_N3ccc9CC10x8y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x8y103abcEv,_ZTv0_n16_N3ccc9CC10x8y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x8y103abcEv,_ZThn4_N3ccc9CC10x8y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x8y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y103pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x8y103pqrEv,_ZTv0_n12_N3ccc9CC10x8y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x8y103abcEv,_ZTv0_n16_N3ccc9CC10x8y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x8y10E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x8y10E[] = {
  {&(_ZTVN3ccc9CC10x8y10E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x8y10E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x8y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x8y10E[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x8y103abcEv,_ZTv0_n16_N3ccc9CC10x8y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x8y103abcEv,_ZThn4_N3ccc9CC10x8y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x8y103pqrEv,_ZTv0_n12_N3ccc9CC10x8y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x8y103pqrEv,_ZThn4_N3ccc9CC10x8y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x8y10E = {  "_ZN3ccc9CC10x8y10E", // class name
  bases__ZN3ccc9CC10x8y10E, 2,
  &(vtc__ZN3ccc9CC10x8y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x8y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x8y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x8y10E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x8y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y10  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc9DD10x8y103pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x8y103abcEv
  ~DD10x8y10(); // tgen
  DD10x8y10(); // tgen
};
//SIG(1 _ZN3ccc9DD10x8y10E) C1{ VBC2{ v1 v2} VBC3{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x8y10 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x8y103pqrEv");}
void  ccc::DD10x8y10 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x8y103abcEv");}
ccc::DD10x8y10 ::~DD10x8y10(){ note_dtor("_ZN3ccc9DD10x8y10E", this);} // tgen
ccc::DD10x8y10 ::DD10x8y10(){ note_ctor("_ZN3ccc9DD10x8y10E", this);} // tgen
}
static void Test__ZN3ccc9DD10x8y10E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x8y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x8y10E, buf);
    ::ccc::DD10x8y10 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x8y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x8y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x8y10E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc9DD10x8y10E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x8y10E);
    dp->::ccc::DD10x8y10::~DD10x8y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x8y10E(Test__ZN3ccc9DD10x8y10E, "_ZN3ccc9DD10x8y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x8y10C1Ev();
extern void _ZN3ccc9DD10x8y10D1Ev();
Name_Map name_map__ZN3ccc9DD10x8y10E[] = {
  NSPAIR(_ZN3ccc9DD10x8y10C1Ev),
  NSPAIR(_ZN3ccc9DD10x8y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9DD10x8y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y10E[];
extern void _ZN3ccc9DD10x8y103pqrEv();
extern void _ZN3ccc9DD10x8y103abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x8y103abcEv,_ZTv0_n16_N3ccc9DD10x8y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x8y103abcEv,_ZThn4_N3ccc9DD10x8y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x8y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x8y103abcEv,_ZTv0_n16_N3ccc9DD10x8y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x8y10E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x8y10E[] = {
  {&(_ZTVN3ccc9DD10x8y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y10E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x8y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x8y10E[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x8y103abcEv,_ZTv0_n16_N3ccc9DD10x8y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x8y103abcEv,_ZThn4_N3ccc9DD10x8y103abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x8y10E = {  "_ZN3ccc9DD10x8y10E", // class name
  bases__ZN3ccc9DD10x8y10E, 2,
  &(vtc__ZN3ccc9DD10x8y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x8y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x8y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x8y10E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x8y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y11  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc9CC10x8y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x8y113efgEv
  ~CC10x8y11(); // tgen
  CC10x8y11(); // tgen
};
//SIG(1 _ZN3ccc9CC10x8y11E) C1{ VBC2{ v1 v3} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x8y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x8y113pqrEv");}
void  ccc::CC10x8y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x8y113efgEv");}
ccc::CC10x8y11 ::~CC10x8y11(){ note_dtor("_ZN3ccc9CC10x8y11E", this);} // tgen
ccc::CC10x8y11 ::CC10x8y11(){ note_ctor("_ZN3ccc9CC10x8y11E", this);} // tgen
}
static void Test__ZN3ccc9CC10x8y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x8y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x8y11E, buf);
    ::ccc::CC10x8y11 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x8y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x8y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x8y11E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc9CC10x8y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x8y11E);
    dp->::ccc::CC10x8y11::~CC10x8y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x8y11E(Test__ZN3ccc9CC10x8y11E, "_ZN3ccc9CC10x8y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x8y11C1Ev();
extern void _ZN3ccc9CC10x8y11D1Ev();
Name_Map name_map__ZN3ccc9CC10x8y11E[] = {
  NSPAIR(_ZN3ccc9CC10x8y11C1Ev),
  NSPAIR(_ZN3ccc9CC10x8y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9CC10x8y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y11E[];
extern void _ZN3ccc9CC10x8y113efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc9CC10x8y113pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x8y113pqrEv,_ZTv0_n12_N3ccc9CC10x8y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x8y113pqrEv,_ZThn4_N3ccc9CC10x8y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x8y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y113pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x8y113pqrEv,_ZTv0_n12_N3ccc9CC10x8y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x8y11E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x8y11E[] = {
  {&(_ZTVN3ccc9CC10x8y11E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x8y11E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x8y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x8y11E[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x8y113pqrEv,_ZTv0_n12_N3ccc9CC10x8y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x8y113pqrEv,_ZThn4_N3ccc9CC10x8y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x8y11E = {  "_ZN3ccc9CC10x8y11E", // class name
  bases__ZN3ccc9CC10x8y11E, 2,
  &(vtc__ZN3ccc9CC10x8y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x8y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x8y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x8y11E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x8y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y11  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc9DD10x8y113pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x8y113efgEv
  ~DD10x8y11(); // tgen
  DD10x8y11(); // tgen
};
//SIG(1 _ZN3ccc9DD10x8y11E) C1{ VBC2{ v1 v3} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x8y11 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x8y113pqrEv");}
void  ccc::DD10x8y11 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x8y113efgEv");}
ccc::DD10x8y11 ::~DD10x8y11(){ note_dtor("_ZN3ccc9DD10x8y11E", this);} // tgen
ccc::DD10x8y11 ::DD10x8y11(){ note_ctor("_ZN3ccc9DD10x8y11E", this);} // tgen
}
static void Test__ZN3ccc9DD10x8y11E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x8y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x8y11E, buf);
    ::ccc::DD10x8y11 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x8y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x8y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x8y11E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc9DD10x8y11E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x8y11E);
    dp->::ccc::DD10x8y11::~DD10x8y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x8y11E(Test__ZN3ccc9DD10x8y11E, "_ZN3ccc9DD10x8y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x8y11C1Ev();
extern void _ZN3ccc9DD10x8y11D1Ev();
Name_Map name_map__ZN3ccc9DD10x8y11E[] = {
  NSPAIR(_ZN3ccc9DD10x8y11C1Ev),
  NSPAIR(_ZN3ccc9DD10x8y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9DD10x8y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y11E[];
extern void _ZN3ccc9DD10x8y113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x8y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x8y113efgEv,_ZTv0_n12_N3ccc9DD10x8y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x8y113efgEv,_ZThn4_N3ccc9DD10x8y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x8y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x8y113efgEv,_ZTv0_n12_N3ccc9DD10x8y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x8y11E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x8y11E[] = {
  {&(_ZTVN3ccc9DD10x8y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x8y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x8y11E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x8y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x8y11E[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x8y113efgEv,_ZTv0_n12_N3ccc9DD10x8y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x8y113efgEv,_ZThn4_N3ccc9DD10x8y113efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x8y11E = {  "_ZN3ccc9DD10x8y11E", // class name
  bases__ZN3ccc9DD10x8y11E, 2,
  &(vtc__ZN3ccc9DD10x8y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x8y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x8y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x8y11E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x8y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y12  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc9CC10x8y123abcEv
  ~CC10x8y12(); // tgen
  CC10x8y12(); // tgen
};
//SIG(1 _ZN3ccc9CC10x8y12E) C1{ VBC2{ v2 v1} BC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::CC10x8y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x8y123abcEv");}
ccc::CC10x8y12 ::~CC10x8y12(){ note_dtor("_ZN3ccc9CC10x8y12E", this);} // tgen
ccc::CC10x8y12 ::CC10x8y12(){ note_ctor("_ZN3ccc9CC10x8y12E", this);} // tgen
}
static void Test__ZN3ccc9CC10x8y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x8y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x8y12E, buf);
    ::ccc::CC10x8y12 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x8y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x8y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x8y12E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc9CC10x8y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x8y12E);
    dp->::ccc::CC10x8y12::~CC10x8y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x8y12E(Test__ZN3ccc9CC10x8y12E, "_ZN3ccc9CC10x8y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x8y12C1Ev();
extern void _ZN3ccc9CC10x8y12D1Ev();
Name_Map name_map__ZN3ccc9CC10x8y12E[] = {
  NSPAIR(_ZN3ccc9CC10x8y12C1Ev),
  NSPAIR(_ZN3ccc9CC10x8y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9CC10x8y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y12E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc9CC10x8y123abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x8y123abcEv,_ZTv0_n16_N3ccc9CC10x8y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x8y123abcEv,_ZThn4_N3ccc9CC10x8y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x8y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y123abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x8y123abcEv,_ZTv0_n16_N3ccc9CC10x8y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x8y12E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x8y12E[] = {
  {&(_ZTVN3ccc9CC10x8y12E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x8y12E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x8y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x8y12E[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x8y123abcEv,_ZTv0_n16_N3ccc9CC10x8y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x8y123abcEv,_ZThn4_N3ccc9CC10x8y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x8y12E = {  "_ZN3ccc9CC10x8y12E", // class name
  bases__ZN3ccc9CC10x8y12E, 2,
  &(vtc__ZN3ccc9CC10x8y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x8y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x8y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x8y12E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x8y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y12  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc9DD10x8y123abcEv
  ~DD10x8y12(); // tgen
  DD10x8y12(); // tgen
};
//SIG(1 _ZN3ccc9DD10x8y12E) C1{ VBC2{ v2 v1} VBC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::DD10x8y12 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x8y123abcEv");}
ccc::DD10x8y12 ::~DD10x8y12(){ note_dtor("_ZN3ccc9DD10x8y12E", this);} // tgen
ccc::DD10x8y12 ::DD10x8y12(){ note_ctor("_ZN3ccc9DD10x8y12E", this);} // tgen
}
static void Test__ZN3ccc9DD10x8y12E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x8y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x8y12E, buf);
    ::ccc::DD10x8y12 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x8y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x8y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x8y12E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc9DD10x8y12E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x8y12E);
    dp->::ccc::DD10x8y12::~DD10x8y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x8y12E(Test__ZN3ccc9DD10x8y12E, "_ZN3ccc9DD10x8y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x8y12C1Ev();
extern void _ZN3ccc9DD10x8y12D1Ev();
Name_Map name_map__ZN3ccc9DD10x8y12E[] = {
  NSPAIR(_ZN3ccc9DD10x8y12C1Ev),
  NSPAIR(_ZN3ccc9DD10x8y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9DD10x8y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x8y123abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x8y123abcEv,_ZTv0_n16_N3ccc9DD10x8y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x8y123abcEv,_ZThn4_N3ccc9DD10x8y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x8y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y123abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x8y123abcEv,_ZTv0_n16_N3ccc9DD10x8y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x8y12E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x8y12E[] = {
  {&(_ZTVN3ccc9DD10x8y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y12E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x8y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x8y12E[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x8y123abcEv,_ZTv0_n16_N3ccc9DD10x8y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x8y123abcEv,_ZThn4_N3ccc9DD10x8y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x8y12E = {  "_ZN3ccc9DD10x8y12E", // class name
  bases__ZN3ccc9DD10x8y12E, 2,
  &(vtc__ZN3ccc9DD10x8y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x8y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x8y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x8y12E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x8y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y13  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc9CC10x8y133efgEv
  ~CC10x8y13(); // tgen
  CC10x8y13(); // tgen
};
//SIG(1 _ZN3ccc9CC10x8y13E) C1{ VBC2{ v2 v3} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC10x8y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x8y133efgEv");}
ccc::CC10x8y13 ::~CC10x8y13(){ note_dtor("_ZN3ccc9CC10x8y13E", this);} // tgen
ccc::CC10x8y13 ::CC10x8y13(){ note_ctor("_ZN3ccc9CC10x8y13E", this);} // tgen
}
static void Test__ZN3ccc9CC10x8y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x8y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x8y13E, buf);
    ::ccc::CC10x8y13 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x8y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x8y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x8y13E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc9CC10x8y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x8y13E);
    dp->::ccc::CC10x8y13::~CC10x8y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x8y13E(Test__ZN3ccc9CC10x8y13E, "_ZN3ccc9CC10x8y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x8y13C1Ev();
extern void _ZN3ccc9CC10x8y13D1Ev();
Name_Map name_map__ZN3ccc9CC10x8y13E[] = {
  NSPAIR(_ZN3ccc9CC10x8y13C1Ev),
  NSPAIR(_ZN3ccc9CC10x8y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9CC10x8y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y13E[];
extern void _ZN3ccc9CC10x8y133efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x8y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x8y13E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x8y13E[] = {
  {&(_ZTVN3ccc9CC10x8y13E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x8y13E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x8y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x8y13E[];
Class_Descriptor cd__ZN3ccc9CC10x8y13E = {  "_ZN3ccc9CC10x8y13E", // class name
  bases__ZN3ccc9CC10x8y13E, 2,
  &(vtc__ZN3ccc9CC10x8y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x8y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x8y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x8y13E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x8y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y13  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc9DD10x8y133efgEv
  ~DD10x8y13(); // tgen
  DD10x8y13(); // tgen
};
//SIG(1 _ZN3ccc9DD10x8y13E) C1{ VBC2{ v2 v3} VBC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::DD10x8y13 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x8y133efgEv");}
ccc::DD10x8y13 ::~DD10x8y13(){ note_dtor("_ZN3ccc9DD10x8y13E", this);} // tgen
ccc::DD10x8y13 ::DD10x8y13(){ note_ctor("_ZN3ccc9DD10x8y13E", this);} // tgen
}
static void Test__ZN3ccc9DD10x8y13E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x8y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x8y13E, buf);
    ::ccc::DD10x8y13 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x8y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x8y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x8y13E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc9DD10x8y13E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x8y13E);
    dp->::ccc::DD10x8y13::~DD10x8y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x8y13E(Test__ZN3ccc9DD10x8y13E, "_ZN3ccc9DD10x8y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x8y13C1Ev();
extern void _ZN3ccc9DD10x8y13D1Ev();
Name_Map name_map__ZN3ccc9DD10x8y13E[] = {
  NSPAIR(_ZN3ccc9DD10x8y13C1Ev),
  NSPAIR(_ZN3ccc9DD10x8y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9DD10x8y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x8y133efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x8y133efgEv,_ZTv0_n12_N3ccc9DD10x8y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x8y133efgEv,_ZThn4_N3ccc9DD10x8y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x8y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y133efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x8y133efgEv,_ZTv0_n12_N3ccc9DD10x8y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x8y13E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x8y13E[] = {
  {&(_ZTVN3ccc9DD10x8y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x8y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x8y13E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x8y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x8y13E[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x8y133efgEv,_ZTv0_n12_N3ccc9DD10x8y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x8y133efgEv,_ZThn4_N3ccc9DD10x8y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x8y13E = {  "_ZN3ccc9DD10x8y13E", // class name
  bases__ZN3ccc9DD10x8y13E, 2,
  &(vtc__ZN3ccc9DD10x8y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x8y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x8y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x8y13E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x8y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y14  : virtual ::ccc::AA10 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc9CC10x8y143pqrEv
  ~CC10x8y14(); // tgen
  CC10x8y14(); // tgen
};
//SIG(1 _ZN3ccc9CC10x8y14E) C1{ VBC2{ v1 v2} BC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::CC10x8y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x8y143pqrEv");}
ccc::CC10x8y14 ::~CC10x8y14(){ note_dtor("_ZN3ccc9CC10x8y14E", this);} // tgen
ccc::CC10x8y14 ::CC10x8y14(){ note_ctor("_ZN3ccc9CC10x8y14E", this);} // tgen
}
static void Test__ZN3ccc9CC10x8y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x8y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x8y14E, buf);
    ::ccc::CC10x8y14 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x8y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x8y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x8y14E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc9CC10x8y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x8y14E);
    dp->::ccc::CC10x8y14::~CC10x8y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x8y14E(Test__ZN3ccc9CC10x8y14E, "_ZN3ccc9CC10x8y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x8y14C1Ev();
extern void _ZN3ccc9CC10x8y14D1Ev();
Name_Map name_map__ZN3ccc9CC10x8y14E[] = {
  NSPAIR(_ZN3ccc9CC10x8y14C1Ev),
  NSPAIR(_ZN3ccc9CC10x8y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9CC10x8y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y14E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc9CC10x8y143pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x8y143pqrEv,_ZTv0_n12_N3ccc9CC10x8y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x8y143pqrEv,_ZThn4_N3ccc9CC10x8y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x8y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x8y143pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x8y143pqrEv,_ZTv0_n12_N3ccc9CC10x8y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x8y14E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x8y14E[] = {
  {&(_ZTVN3ccc9CC10x8y14E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x8y14E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x8y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x8y14E[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x8y143pqrEv,_ZTv0_n12_N3ccc9CC10x8y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x8y143pqrEv,_ZThn4_N3ccc9CC10x8y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x8y14E = {  "_ZN3ccc9CC10x8y14E", // class name
  bases__ZN3ccc9CC10x8y14E, 2,
  &(vtc__ZN3ccc9CC10x8y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x8y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x8y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x8y14E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x8y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y14  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc9DD10x8y143pqrEv
  ~DD10x8y14(); // tgen
  DD10x8y14(); // tgen
};
//SIG(1 _ZN3ccc9DD10x8y14E) C1{ VBC2{ v1 v2} VBC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::DD10x8y14 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x8y143pqrEv");}
ccc::DD10x8y14 ::~DD10x8y14(){ note_dtor("_ZN3ccc9DD10x8y14E", this);} // tgen
ccc::DD10x8y14 ::DD10x8y14(){ note_ctor("_ZN3ccc9DD10x8y14E", this);} // tgen
}
static void Test__ZN3ccc9DD10x8y14E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x8y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x8y14E, buf);
    ::ccc::DD10x8y14 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x8y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x8y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x8y14E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc9DD10x8y14E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x8y14E);
    dp->::ccc::DD10x8y14::~DD10x8y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x8y14E(Test__ZN3ccc9DD10x8y14E, "_ZN3ccc9DD10x8y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x8y14C1Ev();
extern void _ZN3ccc9DD10x8y14D1Ev();
Name_Map name_map__ZN3ccc9DD10x8y14E[] = {
  NSPAIR(_ZN3ccc9DD10x8y14C1Ev),
  NSPAIR(_ZN3ccc9DD10x8y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9DD10x8y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y14E[];
extern void _ZN3ccc9DD10x8y143pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x8y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x8y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x8y14E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x8y14E[] = {
  {&(_ZTVN3ccc9DD10x8y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y14E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x8y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x8y14E[];
Class_Descriptor cd__ZN3ccc9DD10x8y14E = {  "_ZN3ccc9DD10x8y14E", // class name
  bases__ZN3ccc9DD10x8y14E, 2,
  &(vtc__ZN3ccc9DD10x8y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x8y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x8y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x8y14E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x8y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x8y15  : virtual ::ccc::AA10 , ::ccc::BB8 {
  ~CC10x8y15(); // tgen
  CC10x8y15(); // tgen
};
//SIG(1 _ZN3ccc9CC10x8y15E) C1{ VBC2{ v1 v2} BC3{ v3 v4}}
}
namespace ccc { 
ccc::CC10x8y15 ::~CC10x8y15(){ note_dtor("_ZN3ccc9CC10x8y15E", this);} // tgen
ccc::CC10x8y15 ::CC10x8y15(){ note_ctor("_ZN3ccc9CC10x8y15E", this);} // tgen
}
static void Test__ZN3ccc9CC10x8y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x8y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x8y15E, buf);
    ::ccc::CC10x8y15 *dp, &lv = *(dp=new (buf) ::ccc::CC10x8y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x8y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x8y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x8y15E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc9CC10x8y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x8y15E);
    dp->::ccc::CC10x8y15::~CC10x8y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x8y15E(Test__ZN3ccc9CC10x8y15E, "_ZN3ccc9CC10x8y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x8y15C1Ev();
extern void _ZN3ccc9CC10x8y15D1Ev();
Name_Map name_map__ZN3ccc9CC10x8y15E[] = {
  NSPAIR(_ZN3ccc9CC10x8y15C1Ev),
  NSPAIR(_ZN3ccc9CC10x8y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9CC10x8y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y15E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x8y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x8y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x8y15E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x8y15E[] = {
  {&(_ZTVN3ccc9CC10x8y15E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x8y15E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x8y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x8y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x8y15E[];
Class_Descriptor cd__ZN3ccc9CC10x8y15E = {  "_ZN3ccc9CC10x8y15E", // class name
  bases__ZN3ccc9CC10x8y15E, 2,
  &(vtc__ZN3ccc9CC10x8y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x8y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x8y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x8y15E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x8y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x8y15  : virtual ::ccc::AA10 , virtual ::ccc::BB8 {
  ~DD10x8y15(); // tgen
  DD10x8y15(); // tgen
};
//SIG(1 _ZN3ccc9DD10x8y15E) C1{ VBC2{ v1 v2} VBC3{ v3 v4}}
}
namespace ccc { 
ccc::DD10x8y15 ::~DD10x8y15(){ note_dtor("_ZN3ccc9DD10x8y15E", this);} // tgen
ccc::DD10x8y15 ::DD10x8y15(){ note_ctor("_ZN3ccc9DD10x8y15E", this);} // tgen
}
static void Test__ZN3ccc9DD10x8y15E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x8y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x8y15E, buf);
    ::ccc::DD10x8y15 *dp, &lv = *(dp=new (buf) ::ccc::DD10x8y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x8y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x8y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x8y15E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc9DD10x8y15E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x8y15E);
    dp->::ccc::DD10x8y15::~DD10x8y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x8y15E(Test__ZN3ccc9DD10x8y15E, "_ZN3ccc9DD10x8y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x8y15C1Ev();
extern void _ZN3ccc9DD10x8y15D1Ev();
Name_Map name_map__ZN3ccc9DD10x8y15E[] = {
  NSPAIR(_ZN3ccc9DD10x8y15C1Ev),
  NSPAIR(_ZN3ccc9DD10x8y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc9DD10x8y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x8y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x8y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x8y15E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x8y15E[] = {
  {&(_ZTVN3ccc9DD10x8y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x8y15E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x8y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x8y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x8y15E[];
Class_Descriptor cd__ZN3ccc9DD10x8y15E = {  "_ZN3ccc9DD10x8y15E", // class name
  bases__ZN3ccc9DD10x8y15E, 2,
  &(vtc__ZN3ccc9DD10x8y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x8y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x8y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x8y15E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x8y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y0  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8CC10x9y03abcEv
  virtual void  efg(); // _ZN3ccc8CC10x9y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x9y03pqrEv
  ~CC10x9y0(); // tgen
  CC10x9y0(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y0E) C1{ VBC2{ v3 v1} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x9y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y03abcEv");}
void  ccc::CC10x9y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y03efgEv");}
void  ccc::CC10x9y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y03pqrEv");}
ccc::CC10x9y0 ::~CC10x9y0(){ note_dtor("_ZN3ccc8CC10x9y0E", this);} // tgen
ccc::CC10x9y0 ::CC10x9y0(){ note_ctor("_ZN3ccc8CC10x9y0E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y0E, buf);
    ::ccc::CC10x9y0 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y0E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y0E);
    dp->::ccc::CC10x9y0::~CC10x9y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y0E(Test__ZN3ccc8CC10x9y0E, "_ZN3ccc8CC10x9y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y0C1Ev();
extern void _ZN3ccc8CC10x9y0D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y0E[] = {
  NSPAIR(_ZN3ccc8CC10x9y0C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y0E[];
extern void _ZN3ccc8CC10x9y03efgEv();
extern void _ZN3ccc8CC10x9y03pqrEv();
extern void _ZN3ccc8CC10x9y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y03pqrEv,_ZTv0_n12_N3ccc8CC10x9y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y03pqrEv,_ZThn4_N3ccc8CC10x9y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y03abcEv,_ZTv0_n16_N3ccc8CC10x9y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y03abcEv,_ZThn4_N3ccc8CC10x9y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y03pqrEv,_ZTv0_n12_N3ccc8CC10x9y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y03abcEv,_ZTv0_n16_N3ccc8CC10x9y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y0E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y0E[] = {
  {&(_ZTVN3ccc8CC10x9y0E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y0E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y0E[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y03abcEv,_ZTv0_n16_N3ccc8CC10x9y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y03abcEv,_ZThn4_N3ccc8CC10x9y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y03pqrEv,_ZTv0_n12_N3ccc8CC10x9y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y03pqrEv,_ZThn4_N3ccc8CC10x9y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y0E = {  "_ZN3ccc8CC10x9y0E", // class name
  bases__ZN3ccc8CC10x9y0E, 2,
  &(vtc__ZN3ccc8CC10x9y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y0E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y0  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8DD10x9y03abcEv
  virtual void  efg(); // _ZN3ccc8DD10x9y03efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x9y03pqrEv
  ~DD10x9y0(); // tgen
  DD10x9y0(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y0E) C1{ VBC2{ v3 v1} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x9y0 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y03abcEv");}
void  ccc::DD10x9y0 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y03efgEv");}
void  ccc::DD10x9y0 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y03pqrEv");}
ccc::DD10x9y0 ::~DD10x9y0(){ note_dtor("_ZN3ccc8DD10x9y0E", this);} // tgen
ccc::DD10x9y0 ::DD10x9y0(){ note_ctor("_ZN3ccc8DD10x9y0E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y0E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y0E, buf);
    ::ccc::DD10x9y0 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y0E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y0E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y0E);
    dp->::ccc::DD10x9y0::~DD10x9y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y0E(Test__ZN3ccc8DD10x9y0E, "_ZN3ccc8DD10x9y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y0C1Ev();
extern void _ZN3ccc8DD10x9y0D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y0E[] = {
  NSPAIR(_ZN3ccc8DD10x9y0C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y0E[];
extern void _ZN3ccc8DD10x9y03pqrEv();
extern void _ZN3ccc8DD10x9y03abcEv();
extern void _ZN3ccc8DD10x9y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y03efgEv,_ZTv0_n12_N3ccc8DD10x9y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y03efgEv,_ZThn4_N3ccc8DD10x9y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y03pqrEv,_ZTv0_n16_N3ccc8DD10x9y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y03pqrEv,_ZThn4_N3ccc8DD10x9y03pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y03efgEv,_ZTv0_n12_N3ccc8DD10x9y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y03pqrEv,_ZTv0_n16_N3ccc8DD10x9y03pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y0E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y0E[] = {
  {&(_ZTVN3ccc8DD10x9y0E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y0E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y0E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y0E[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y03pqrEv,_ZTv0_n16_N3ccc8DD10x9y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y03pqrEv,_ZThn4_N3ccc8DD10x9y03pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y03efgEv,_ZTv0_n12_N3ccc8DD10x9y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y03efgEv,_ZThn4_N3ccc8DD10x9y03efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y0E = {  "_ZN3ccc8DD10x9y0E", // class name
  bases__ZN3ccc8DD10x9y0E, 2,
  &(vtc__ZN3ccc8DD10x9y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y0E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y1  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8CC10x9y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x9y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x9y13efgEv
  ~CC10x9y1(); // tgen
  CC10x9y1(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y1E) C1{ VBC2{ v2 v1} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x9y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y13abcEv");}
void  ccc::CC10x9y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y13pqrEv");}
void  ccc::CC10x9y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y13efgEv");}
ccc::CC10x9y1 ::~CC10x9y1(){ note_dtor("_ZN3ccc8CC10x9y1E", this);} // tgen
ccc::CC10x9y1 ::CC10x9y1(){ note_ctor("_ZN3ccc8CC10x9y1E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y1E, buf);
    ::ccc::CC10x9y1 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y1E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y1E);
    dp->::ccc::CC10x9y1::~CC10x9y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y1E(Test__ZN3ccc8CC10x9y1E, "_ZN3ccc8CC10x9y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y1C1Ev();
extern void _ZN3ccc8CC10x9y1D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y1E[] = {
  NSPAIR(_ZN3ccc8CC10x9y1C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y1E[];
extern void _ZN3ccc8CC10x9y13efgEv();
extern void _ZN3ccc8CC10x9y13pqrEv();
extern void _ZN3ccc8CC10x9y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y13pqrEv,_ZTv0_n12_N3ccc8CC10x9y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y13pqrEv,_ZThn4_N3ccc8CC10x9y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y13abcEv,_ZTv0_n16_N3ccc8CC10x9y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y13abcEv,_ZThn4_N3ccc8CC10x9y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y13pqrEv,_ZTv0_n12_N3ccc8CC10x9y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y13abcEv,_ZTv0_n16_N3ccc8CC10x9y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y1E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y1E[] = {
  {&(_ZTVN3ccc8CC10x9y1E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y1E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y1E[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y13abcEv,_ZTv0_n16_N3ccc8CC10x9y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y13abcEv,_ZThn4_N3ccc8CC10x9y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y13pqrEv,_ZTv0_n12_N3ccc8CC10x9y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y13pqrEv,_ZThn4_N3ccc8CC10x9y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y1E = {  "_ZN3ccc8CC10x9y1E", // class name
  bases__ZN3ccc8CC10x9y1E, 2,
  &(vtc__ZN3ccc8CC10x9y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y1E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y1  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8DD10x9y13abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x9y13pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x9y13efgEv
  ~DD10x9y1(); // tgen
  DD10x9y1(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y1E) C1{ VBC2{ v2 v1} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x9y1 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y13abcEv");}
void  ccc::DD10x9y1 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y13pqrEv");}
void  ccc::DD10x9y1 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y13efgEv");}
ccc::DD10x9y1 ::~DD10x9y1(){ note_dtor("_ZN3ccc8DD10x9y1E", this);} // tgen
ccc::DD10x9y1 ::DD10x9y1(){ note_ctor("_ZN3ccc8DD10x9y1E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y1E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y1E, buf);
    ::ccc::DD10x9y1 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y1E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y1E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y1E);
    dp->::ccc::DD10x9y1::~DD10x9y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y1E(Test__ZN3ccc8DD10x9y1E, "_ZN3ccc8DD10x9y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y1C1Ev();
extern void _ZN3ccc8DD10x9y1D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y1E[] = {
  NSPAIR(_ZN3ccc8DD10x9y1C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y1E[];
extern void _ZN3ccc8DD10x9y13pqrEv();
extern void _ZN3ccc8DD10x9y13abcEv();
extern void _ZN3ccc8DD10x9y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y13efgEv,_ZTv0_n12_N3ccc8DD10x9y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y13efgEv,_ZThn4_N3ccc8DD10x9y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y13pqrEv,_ZTv0_n16_N3ccc8DD10x9y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y13pqrEv,_ZThn4_N3ccc8DD10x9y13pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y13efgEv,_ZTv0_n12_N3ccc8DD10x9y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y13pqrEv,_ZTv0_n16_N3ccc8DD10x9y13pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y1E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y1E[] = {
  {&(_ZTVN3ccc8DD10x9y1E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y1E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y1E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y1E[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y13pqrEv,_ZTv0_n16_N3ccc8DD10x9y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y13pqrEv,_ZThn4_N3ccc8DD10x9y13pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y13efgEv,_ZTv0_n12_N3ccc8DD10x9y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y13efgEv,_ZThn4_N3ccc8DD10x9y13efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y1E = {  "_ZN3ccc8DD10x9y1E", // class name
  bases__ZN3ccc8DD10x9y1E, 2,
  &(vtc__ZN3ccc8DD10x9y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y1E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y2  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8CC10x9y23efgEv
  virtual void  abc(); // _ZN3ccc8CC10x9y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x9y23pqrEv
  ~CC10x9y2(); // tgen
  CC10x9y2(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y2E) C1{ VBC2{ v3 v2} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x9y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y23efgEv");}
void  ccc::CC10x9y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y23abcEv");}
void  ccc::CC10x9y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y23pqrEv");}
ccc::CC10x9y2 ::~CC10x9y2(){ note_dtor("_ZN3ccc8CC10x9y2E", this);} // tgen
ccc::CC10x9y2 ::CC10x9y2(){ note_ctor("_ZN3ccc8CC10x9y2E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y2E, buf);
    ::ccc::CC10x9y2 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y2E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y2E);
    dp->::ccc::CC10x9y2::~CC10x9y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y2E(Test__ZN3ccc8CC10x9y2E, "_ZN3ccc8CC10x9y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y2C1Ev();
extern void _ZN3ccc8CC10x9y2D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y2E[] = {
  NSPAIR(_ZN3ccc8CC10x9y2C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y2E[];
extern void _ZN3ccc8CC10x9y23efgEv();
extern void _ZN3ccc8CC10x9y23pqrEv();
extern void _ZN3ccc8CC10x9y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y23pqrEv,_ZTv0_n12_N3ccc8CC10x9y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y23pqrEv,_ZThn4_N3ccc8CC10x9y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y23abcEv,_ZTv0_n16_N3ccc8CC10x9y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y23abcEv,_ZThn4_N3ccc8CC10x9y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y23pqrEv,_ZTv0_n12_N3ccc8CC10x9y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y23abcEv,_ZTv0_n16_N3ccc8CC10x9y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y2E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y2E[] = {
  {&(_ZTVN3ccc8CC10x9y2E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y2E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y2E[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y23abcEv,_ZTv0_n16_N3ccc8CC10x9y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y23abcEv,_ZThn4_N3ccc8CC10x9y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y23pqrEv,_ZTv0_n12_N3ccc8CC10x9y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y23pqrEv,_ZThn4_N3ccc8CC10x9y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y2E = {  "_ZN3ccc8CC10x9y2E", // class name
  bases__ZN3ccc8CC10x9y2E, 2,
  &(vtc__ZN3ccc8CC10x9y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y2E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y2  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8DD10x9y23efgEv
  virtual void  abc(); // _ZN3ccc8DD10x9y23abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x9y23pqrEv
  ~DD10x9y2(); // tgen
  DD10x9y2(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y2E) C1{ VBC2{ v3 v2} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x9y2 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y23efgEv");}
void  ccc::DD10x9y2 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y23abcEv");}
void  ccc::DD10x9y2 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y23pqrEv");}
ccc::DD10x9y2 ::~DD10x9y2(){ note_dtor("_ZN3ccc8DD10x9y2E", this);} // tgen
ccc::DD10x9y2 ::DD10x9y2(){ note_ctor("_ZN3ccc8DD10x9y2E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y2E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y2E, buf);
    ::ccc::DD10x9y2 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y2E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y2E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y2E);
    dp->::ccc::DD10x9y2::~DD10x9y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y2E(Test__ZN3ccc8DD10x9y2E, "_ZN3ccc8DD10x9y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y2C1Ev();
extern void _ZN3ccc8DD10x9y2D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y2E[] = {
  NSPAIR(_ZN3ccc8DD10x9y2C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y2E[];
extern void _ZN3ccc8DD10x9y23pqrEv();
extern void _ZN3ccc8DD10x9y23abcEv();
extern void _ZN3ccc8DD10x9y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y23efgEv,_ZTv0_n12_N3ccc8DD10x9y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y23efgEv,_ZThn4_N3ccc8DD10x9y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y23pqrEv,_ZTv0_n16_N3ccc8DD10x9y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y23pqrEv,_ZThn4_N3ccc8DD10x9y23pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y23efgEv,_ZTv0_n12_N3ccc8DD10x9y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y23pqrEv,_ZTv0_n16_N3ccc8DD10x9y23pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y2E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y2E[] = {
  {&(_ZTVN3ccc8DD10x9y2E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y2E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y2E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y2E[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y23pqrEv,_ZTv0_n16_N3ccc8DD10x9y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y23pqrEv,_ZThn4_N3ccc8DD10x9y23pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y23efgEv,_ZTv0_n12_N3ccc8DD10x9y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y23efgEv,_ZThn4_N3ccc8DD10x9y23efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y2E = {  "_ZN3ccc8DD10x9y2E", // class name
  bases__ZN3ccc8DD10x9y2E, 2,
  &(vtc__ZN3ccc8DD10x9y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y2E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y3  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8CC10x9y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x9y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x9y33abcEv
  ~CC10x9y3(); // tgen
  CC10x9y3(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y3E) C1{ VBC2{ v2 v3} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x9y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y33efgEv");}
void  ccc::CC10x9y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y33pqrEv");}
void  ccc::CC10x9y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y33abcEv");}
ccc::CC10x9y3 ::~CC10x9y3(){ note_dtor("_ZN3ccc8CC10x9y3E", this);} // tgen
ccc::CC10x9y3 ::CC10x9y3(){ note_ctor("_ZN3ccc8CC10x9y3E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y3E, buf);
    ::ccc::CC10x9y3 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y3E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y3E);
    dp->::ccc::CC10x9y3::~CC10x9y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y3E(Test__ZN3ccc8CC10x9y3E, "_ZN3ccc8CC10x9y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y3C1Ev();
extern void _ZN3ccc8CC10x9y3D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y3E[] = {
  NSPAIR(_ZN3ccc8CC10x9y3C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y3E[];
extern void _ZN3ccc8CC10x9y33efgEv();
extern void _ZN3ccc8CC10x9y33pqrEv();
extern void _ZN3ccc8CC10x9y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y33pqrEv,_ZTv0_n12_N3ccc8CC10x9y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y33pqrEv,_ZThn4_N3ccc8CC10x9y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y33abcEv,_ZTv0_n16_N3ccc8CC10x9y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y33abcEv,_ZThn4_N3ccc8CC10x9y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y33pqrEv,_ZTv0_n12_N3ccc8CC10x9y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y33abcEv,_ZTv0_n16_N3ccc8CC10x9y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y3E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y3E[] = {
  {&(_ZTVN3ccc8CC10x9y3E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y3E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y3E[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y33abcEv,_ZTv0_n16_N3ccc8CC10x9y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y33abcEv,_ZThn4_N3ccc8CC10x9y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y33pqrEv,_ZTv0_n12_N3ccc8CC10x9y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y33pqrEv,_ZThn4_N3ccc8CC10x9y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y3E = {  "_ZN3ccc8CC10x9y3E", // class name
  bases__ZN3ccc8CC10x9y3E, 2,
  &(vtc__ZN3ccc8CC10x9y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y3E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y3  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8DD10x9y33efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x9y33pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x9y33abcEv
  ~DD10x9y3(); // tgen
  DD10x9y3(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y3E) C1{ VBC2{ v2 v3} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x9y3 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y33efgEv");}
void  ccc::DD10x9y3 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y33pqrEv");}
void  ccc::DD10x9y3 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y33abcEv");}
ccc::DD10x9y3 ::~DD10x9y3(){ note_dtor("_ZN3ccc8DD10x9y3E", this);} // tgen
ccc::DD10x9y3 ::DD10x9y3(){ note_ctor("_ZN3ccc8DD10x9y3E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y3E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y3E, buf);
    ::ccc::DD10x9y3 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y3E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y3E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y3E);
    dp->::ccc::DD10x9y3::~DD10x9y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y3E(Test__ZN3ccc8DD10x9y3E, "_ZN3ccc8DD10x9y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y3C1Ev();
extern void _ZN3ccc8DD10x9y3D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y3E[] = {
  NSPAIR(_ZN3ccc8DD10x9y3C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y3E[];
extern void _ZN3ccc8DD10x9y33pqrEv();
extern void _ZN3ccc8DD10x9y33abcEv();
extern void _ZN3ccc8DD10x9y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y33efgEv,_ZTv0_n12_N3ccc8DD10x9y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y33efgEv,_ZThn4_N3ccc8DD10x9y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y33pqrEv,_ZTv0_n16_N3ccc8DD10x9y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y33pqrEv,_ZThn4_N3ccc8DD10x9y33pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y33efgEv,_ZTv0_n12_N3ccc8DD10x9y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y33pqrEv,_ZTv0_n16_N3ccc8DD10x9y33pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y3E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y3E[] = {
  {&(_ZTVN3ccc8DD10x9y3E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y3E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y3E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y3E[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y33pqrEv,_ZTv0_n16_N3ccc8DD10x9y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y33pqrEv,_ZThn4_N3ccc8DD10x9y33pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y33efgEv,_ZTv0_n12_N3ccc8DD10x9y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y33efgEv,_ZThn4_N3ccc8DD10x9y33efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y3E = {  "_ZN3ccc8DD10x9y3E", // class name
  bases__ZN3ccc8DD10x9y3E, 2,
  &(vtc__ZN3ccc8DD10x9y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y3E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y4  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8CC10x9y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC10x9y43abcEv
  virtual void  efg(); // _ZN3ccc8CC10x9y43efgEv
  ~CC10x9y4(); // tgen
  CC10x9y4(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y4E) C1{ VBC2{ v1 v2} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x9y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y43pqrEv");}
void  ccc::CC10x9y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y43abcEv");}
void  ccc::CC10x9y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y43efgEv");}
ccc::CC10x9y4 ::~CC10x9y4(){ note_dtor("_ZN3ccc8CC10x9y4E", this);} // tgen
ccc::CC10x9y4 ::CC10x9y4(){ note_ctor("_ZN3ccc8CC10x9y4E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y4E, buf);
    ::ccc::CC10x9y4 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y4E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y4E);
    dp->::ccc::CC10x9y4::~CC10x9y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y4E(Test__ZN3ccc8CC10x9y4E, "_ZN3ccc8CC10x9y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y4C1Ev();
extern void _ZN3ccc8CC10x9y4D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y4E[] = {
  NSPAIR(_ZN3ccc8CC10x9y4C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y4E[];
extern void _ZN3ccc8CC10x9y43efgEv();
extern void _ZN3ccc8CC10x9y43pqrEv();
extern void _ZN3ccc8CC10x9y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y43pqrEv,_ZTv0_n12_N3ccc8CC10x9y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y43pqrEv,_ZThn4_N3ccc8CC10x9y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y43abcEv,_ZTv0_n16_N3ccc8CC10x9y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y43abcEv,_ZThn4_N3ccc8CC10x9y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y43pqrEv,_ZTv0_n12_N3ccc8CC10x9y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y43abcEv,_ZTv0_n16_N3ccc8CC10x9y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y4E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y4E[] = {
  {&(_ZTVN3ccc8CC10x9y4E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y4E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y4E[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y43abcEv,_ZTv0_n16_N3ccc8CC10x9y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y43abcEv,_ZThn4_N3ccc8CC10x9y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y43pqrEv,_ZTv0_n12_N3ccc8CC10x9y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y43pqrEv,_ZThn4_N3ccc8CC10x9y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y4E = {  "_ZN3ccc8CC10x9y4E", // class name
  bases__ZN3ccc8CC10x9y4E, 2,
  &(vtc__ZN3ccc8CC10x9y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y4E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y4  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8DD10x9y43pqrEv
  virtual void  abc(); // _ZN3ccc8DD10x9y43abcEv
  virtual void  efg(); // _ZN3ccc8DD10x9y43efgEv
  ~DD10x9y4(); // tgen
  DD10x9y4(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y4E) C1{ VBC2{ v1 v2} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x9y4 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y43pqrEv");}
void  ccc::DD10x9y4 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y43abcEv");}
void  ccc::DD10x9y4 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y43efgEv");}
ccc::DD10x9y4 ::~DD10x9y4(){ note_dtor("_ZN3ccc8DD10x9y4E", this);} // tgen
ccc::DD10x9y4 ::DD10x9y4(){ note_ctor("_ZN3ccc8DD10x9y4E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y4E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y4E, buf);
    ::ccc::DD10x9y4 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y4E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y4E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y4E);
    dp->::ccc::DD10x9y4::~DD10x9y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y4E(Test__ZN3ccc8DD10x9y4E, "_ZN3ccc8DD10x9y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y4C1Ev();
extern void _ZN3ccc8DD10x9y4D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y4E[] = {
  NSPAIR(_ZN3ccc8DD10x9y4C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y4E[];
extern void _ZN3ccc8DD10x9y43pqrEv();
extern void _ZN3ccc8DD10x9y43abcEv();
extern void _ZN3ccc8DD10x9y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y43efgEv,_ZTv0_n12_N3ccc8DD10x9y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y43efgEv,_ZThn4_N3ccc8DD10x9y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y43pqrEv,_ZTv0_n16_N3ccc8DD10x9y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y43pqrEv,_ZThn4_N3ccc8DD10x9y43pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y43efgEv,_ZTv0_n12_N3ccc8DD10x9y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y43pqrEv,_ZTv0_n16_N3ccc8DD10x9y43pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y4E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y4E[] = {
  {&(_ZTVN3ccc8DD10x9y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y4E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y4E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y4E[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y43pqrEv,_ZTv0_n16_N3ccc8DD10x9y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y43pqrEv,_ZThn4_N3ccc8DD10x9y43pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y43efgEv,_ZTv0_n12_N3ccc8DD10x9y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y43efgEv,_ZThn4_N3ccc8DD10x9y43efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y4E = {  "_ZN3ccc8DD10x9y4E", // class name
  bases__ZN3ccc8DD10x9y4E, 2,
  &(vtc__ZN3ccc8DD10x9y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y4E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y5  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8CC10x9y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC10x9y53efgEv
  virtual void  abc(); // _ZN3ccc8CC10x9y53abcEv
  ~CC10x9y5(); // tgen
  CC10x9y5(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y5E) C1{ VBC2{ v1 v3} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x9y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y53pqrEv");}
void  ccc::CC10x9y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y53efgEv");}
void  ccc::CC10x9y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y53abcEv");}
ccc::CC10x9y5 ::~CC10x9y5(){ note_dtor("_ZN3ccc8CC10x9y5E", this);} // tgen
ccc::CC10x9y5 ::CC10x9y5(){ note_ctor("_ZN3ccc8CC10x9y5E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y5E, buf);
    ::ccc::CC10x9y5 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y5E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y5E);
    dp->::ccc::CC10x9y5::~CC10x9y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y5E(Test__ZN3ccc8CC10x9y5E, "_ZN3ccc8CC10x9y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y5C1Ev();
extern void _ZN3ccc8CC10x9y5D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y5E[] = {
  NSPAIR(_ZN3ccc8CC10x9y5C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y5E[];
extern void _ZN3ccc8CC10x9y53efgEv();
extern void _ZN3ccc8CC10x9y53pqrEv();
extern void _ZN3ccc8CC10x9y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y53pqrEv,_ZTv0_n12_N3ccc8CC10x9y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y53pqrEv,_ZThn4_N3ccc8CC10x9y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y53abcEv,_ZTv0_n16_N3ccc8CC10x9y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y53abcEv,_ZThn4_N3ccc8CC10x9y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y53pqrEv,_ZTv0_n12_N3ccc8CC10x9y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y53abcEv,_ZTv0_n16_N3ccc8CC10x9y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y5E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y5E[] = {
  {&(_ZTVN3ccc8CC10x9y5E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y5E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y5E[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y53abcEv,_ZTv0_n16_N3ccc8CC10x9y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y53abcEv,_ZThn4_N3ccc8CC10x9y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y53pqrEv,_ZTv0_n12_N3ccc8CC10x9y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y53pqrEv,_ZThn4_N3ccc8CC10x9y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y5E = {  "_ZN3ccc8CC10x9y5E", // class name
  bases__ZN3ccc8CC10x9y5E, 2,
  &(vtc__ZN3ccc8CC10x9y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y5E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y5  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8DD10x9y53pqrEv
  virtual void  efg(); // _ZN3ccc8DD10x9y53efgEv
  virtual void  abc(); // _ZN3ccc8DD10x9y53abcEv
  ~DD10x9y5(); // tgen
  DD10x9y5(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y5E) C1{ VBC2{ v1 v3} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x9y5 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y53pqrEv");}
void  ccc::DD10x9y5 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y53efgEv");}
void  ccc::DD10x9y5 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y53abcEv");}
ccc::DD10x9y5 ::~DD10x9y5(){ note_dtor("_ZN3ccc8DD10x9y5E", this);} // tgen
ccc::DD10x9y5 ::DD10x9y5(){ note_ctor("_ZN3ccc8DD10x9y5E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y5E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y5E, buf);
    ::ccc::DD10x9y5 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y5E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y5E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y5E);
    dp->::ccc::DD10x9y5::~DD10x9y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y5E(Test__ZN3ccc8DD10x9y5E, "_ZN3ccc8DD10x9y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y5C1Ev();
extern void _ZN3ccc8DD10x9y5D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y5E[] = {
  NSPAIR(_ZN3ccc8DD10x9y5C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y5E[];
extern void _ZN3ccc8DD10x9y53pqrEv();
extern void _ZN3ccc8DD10x9y53abcEv();
extern void _ZN3ccc8DD10x9y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y53efgEv,_ZTv0_n12_N3ccc8DD10x9y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y53efgEv,_ZThn4_N3ccc8DD10x9y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y53pqrEv,_ZTv0_n16_N3ccc8DD10x9y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y53pqrEv,_ZThn4_N3ccc8DD10x9y53pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y53efgEv,_ZTv0_n12_N3ccc8DD10x9y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y53pqrEv,_ZTv0_n16_N3ccc8DD10x9y53pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y5E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y5E[] = {
  {&(_ZTVN3ccc8DD10x9y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y5E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y5E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y5E[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y53pqrEv,_ZTv0_n16_N3ccc8DD10x9y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y53pqrEv,_ZThn4_N3ccc8DD10x9y53pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y53efgEv,_ZTv0_n12_N3ccc8DD10x9y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y53efgEv,_ZThn4_N3ccc8DD10x9y53efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y5E = {  "_ZN3ccc8DD10x9y5E", // class name
  bases__ZN3ccc8DD10x9y5E, 2,
  &(vtc__ZN3ccc8DD10x9y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y5E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y6  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8CC10x9y63abcEv
  virtual void  efg(); // _ZN3ccc8CC10x9y63efgEv
  ~CC10x9y6(); // tgen
  CC10x9y6(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y6E) C1{ VBC2{ v3 v1} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x9y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y63abcEv");}
void  ccc::CC10x9y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y63efgEv");}
ccc::CC10x9y6 ::~CC10x9y6(){ note_dtor("_ZN3ccc8CC10x9y6E", this);} // tgen
ccc::CC10x9y6 ::CC10x9y6(){ note_ctor("_ZN3ccc8CC10x9y6E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y6E, buf);
    ::ccc::CC10x9y6 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y6E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y6E);
    dp->::ccc::CC10x9y6::~CC10x9y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y6E(Test__ZN3ccc8CC10x9y6E, "_ZN3ccc8CC10x9y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y6C1Ev();
extern void _ZN3ccc8CC10x9y6D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y6E[] = {
  NSPAIR(_ZN3ccc8CC10x9y6C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y6E[];
extern void _ZN3ccc8CC10x9y63efgEv();
extern void _ZN3ccc3BB93pqrEv();
extern void _ZN3ccc8CC10x9y63abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y63abcEv,_ZTv0_n16_N3ccc8CC10x9y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y63abcEv,_ZThn4_N3ccc8CC10x9y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y63abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y63abcEv,_ZTv0_n16_N3ccc8CC10x9y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y6E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y6E[] = {
  {&(_ZTVN3ccc8CC10x9y6E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y6E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y6E[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y63abcEv,_ZTv0_n16_N3ccc8CC10x9y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y63abcEv,_ZThn4_N3ccc8CC10x9y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y6E = {  "_ZN3ccc8CC10x9y6E", // class name
  bases__ZN3ccc8CC10x9y6E, 2,
  &(vtc__ZN3ccc8CC10x9y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y6E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y6  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8DD10x9y63abcEv
  virtual void  efg(); // _ZN3ccc8DD10x9y63efgEv
  ~DD10x9y6(); // tgen
  DD10x9y6(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y6E) C1{ VBC2{ v3 v1} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x9y6 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y63abcEv");}
void  ccc::DD10x9y6 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y63efgEv");}
ccc::DD10x9y6 ::~DD10x9y6(){ note_dtor("_ZN3ccc8DD10x9y6E", this);} // tgen
ccc::DD10x9y6 ::DD10x9y6(){ note_ctor("_ZN3ccc8DD10x9y6E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y6E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y6E, buf);
    ::ccc::DD10x9y6 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y6E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y6E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y6E);
    dp->::ccc::DD10x9y6::~DD10x9y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y6E(Test__ZN3ccc8DD10x9y6E, "_ZN3ccc8DD10x9y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y6C1Ev();
extern void _ZN3ccc8DD10x9y6D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y6E[] = {
  NSPAIR(_ZN3ccc8DD10x9y6C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x9y63abcEv();
extern void _ZN3ccc8DD10x9y63efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y63efgEv,_ZTv0_n12_N3ccc8DD10x9y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y63efgEv,_ZThn4_N3ccc8DD10x9y63efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y63efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y63efgEv,_ZTv0_n12_N3ccc8DD10x9y63efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y6E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y6E[] = {
  {&(_ZTVN3ccc8DD10x9y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y6E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y6E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y6E[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y63efgEv,_ZTv0_n12_N3ccc8DD10x9y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y63efgEv,_ZThn4_N3ccc8DD10x9y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y6E = {  "_ZN3ccc8DD10x9y6E", // class name
  bases__ZN3ccc8DD10x9y6E, 2,
  &(vtc__ZN3ccc8DD10x9y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y6E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y7  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8CC10x9y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC10x9y73pqrEv
  ~CC10x9y7(); // tgen
  CC10x9y7(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y7E) C1{ VBC2{ v2 v1} BC3{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x9y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y73abcEv");}
void  ccc::CC10x9y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y73pqrEv");}
ccc::CC10x9y7 ::~CC10x9y7(){ note_dtor("_ZN3ccc8CC10x9y7E", this);} // tgen
ccc::CC10x9y7 ::CC10x9y7(){ note_ctor("_ZN3ccc8CC10x9y7E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y7E, buf);
    ::ccc::CC10x9y7 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y7E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y7E);
    dp->::ccc::CC10x9y7::~CC10x9y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y7E(Test__ZN3ccc8CC10x9y7E, "_ZN3ccc8CC10x9y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y7C1Ev();
extern void _ZN3ccc8CC10x9y7D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y7E[] = {
  NSPAIR(_ZN3ccc8CC10x9y7C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y7E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc8CC10x9y73pqrEv();
extern void _ZN3ccc8CC10x9y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y73pqrEv,_ZTv0_n12_N3ccc8CC10x9y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y73pqrEv,_ZThn4_N3ccc8CC10x9y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y73abcEv,_ZTv0_n16_N3ccc8CC10x9y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y73abcEv,_ZThn4_N3ccc8CC10x9y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y73pqrEv,_ZTv0_n12_N3ccc8CC10x9y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y73abcEv,_ZTv0_n16_N3ccc8CC10x9y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y7E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y7E[] = {
  {&(_ZTVN3ccc8CC10x9y7E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y7E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y7E[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y73abcEv,_ZTv0_n16_N3ccc8CC10x9y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y73abcEv,_ZThn4_N3ccc8CC10x9y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y73pqrEv,_ZTv0_n12_N3ccc8CC10x9y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y73pqrEv,_ZThn4_N3ccc8CC10x9y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y7E = {  "_ZN3ccc8CC10x9y7E", // class name
  bases__ZN3ccc8CC10x9y7E, 2,
  &(vtc__ZN3ccc8CC10x9y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y7E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y7  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8DD10x9y73abcEv
  virtual void  pqr(); // _ZN3ccc8DD10x9y73pqrEv
  ~DD10x9y7(); // tgen
  DD10x9y7(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y7E) C1{ VBC2{ v2 v1} VBC3{ v3 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x9y7 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y73abcEv");}
void  ccc::DD10x9y7 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y73pqrEv");}
ccc::DD10x9y7 ::~DD10x9y7(){ note_dtor("_ZN3ccc8DD10x9y7E", this);} // tgen
ccc::DD10x9y7 ::DD10x9y7(){ note_ctor("_ZN3ccc8DD10x9y7E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y7E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y7E, buf);
    ::ccc::DD10x9y7 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y7E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y7E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y7E);
    dp->::ccc::DD10x9y7::~DD10x9y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y7E(Test__ZN3ccc8DD10x9y7E, "_ZN3ccc8DD10x9y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y7C1Ev();
extern void _ZN3ccc8DD10x9y7D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y7E[] = {
  NSPAIR(_ZN3ccc8DD10x9y7C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y7E[];
extern void _ZN3ccc8DD10x9y73pqrEv();
extern void _ZN3ccc8DD10x9y73abcEv();
extern void _ZN3ccc3BB93efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y73pqrEv,_ZTv0_n16_N3ccc8DD10x9y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y73pqrEv,_ZThn4_N3ccc8DD10x9y73pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y73abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y73pqrEv,_ZTv0_n16_N3ccc8DD10x9y73pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y7E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y7E[] = {
  {&(_ZTVN3ccc8DD10x9y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x9y7E[6]),  6,14},
  {&(_ZTVN3ccc8DD10x9y7E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y7E[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y73pqrEv,_ZTv0_n16_N3ccc8DD10x9y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y73pqrEv,_ZThn4_N3ccc8DD10x9y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y7E = {  "_ZN3ccc8DD10x9y7E", // class name
  bases__ZN3ccc8DD10x9y7E, 2,
  &(vtc__ZN3ccc8DD10x9y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y7E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y8  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8CC10x9y83efgEv
  virtual void  abc(); // _ZN3ccc8CC10x9y83abcEv
  ~CC10x9y8(); // tgen
  CC10x9y8(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y8E) C1{ VBC2{ v3 v2} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x9y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y83efgEv");}
void  ccc::CC10x9y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC10x9y83abcEv");}
ccc::CC10x9y8 ::~CC10x9y8(){ note_dtor("_ZN3ccc8CC10x9y8E", this);} // tgen
ccc::CC10x9y8 ::CC10x9y8(){ note_ctor("_ZN3ccc8CC10x9y8E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y8E, buf);
    ::ccc::CC10x9y8 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y8E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y8E);
    dp->::ccc::CC10x9y8::~CC10x9y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y8E(Test__ZN3ccc8CC10x9y8E, "_ZN3ccc8CC10x9y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y8C1Ev();
extern void _ZN3ccc8CC10x9y8D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y8E[] = {
  NSPAIR(_ZN3ccc8CC10x9y8C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y8E[];
extern void _ZN3ccc8CC10x9y83efgEv();
extern void _ZN3ccc3BB93pqrEv();
extern void _ZN3ccc8CC10x9y83abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC10x9y83abcEv,_ZTv0_n16_N3ccc8CC10x9y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y83abcEv,_ZThn4_N3ccc8CC10x9y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y83abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC10x9y83abcEv,_ZTv0_n16_N3ccc8CC10x9y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y8E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y8E[] = {
  {&(_ZTVN3ccc8CC10x9y8E[3]),  3,12},
  {&(_ZTVN3ccc8CC10x9y8E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y8E[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC10x9y83abcEv,_ZTv0_n16_N3ccc8CC10x9y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y83abcEv,_ZThn4_N3ccc8CC10x9y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y8E = {  "_ZN3ccc8CC10x9y8E", // class name
  bases__ZN3ccc8CC10x9y8E, 2,
  &(vtc__ZN3ccc8CC10x9y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y8E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y8  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8DD10x9y83efgEv
  virtual void  abc(); // _ZN3ccc8DD10x9y83abcEv
  ~DD10x9y8(); // tgen
  DD10x9y8(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y8E) C1{ VBC2{ v3 v2} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x9y8 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y83efgEv");}
void  ccc::DD10x9y8 ::abc(){vfunc_called(this, "_ZN3ccc8DD10x9y83abcEv");}
ccc::DD10x9y8 ::~DD10x9y8(){ note_dtor("_ZN3ccc8DD10x9y8E", this);} // tgen
ccc::DD10x9y8 ::DD10x9y8(){ note_ctor("_ZN3ccc8DD10x9y8E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y8E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y8E, buf);
    ::ccc::DD10x9y8 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y8E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y8E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y8E);
    dp->::ccc::DD10x9y8::~DD10x9y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y8E(Test__ZN3ccc8DD10x9y8E, "_ZN3ccc8DD10x9y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y8C1Ev();
extern void _ZN3ccc8DD10x9y8D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y8E[] = {
  NSPAIR(_ZN3ccc8DD10x9y8C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc8DD10x9y83abcEv();
extern void _ZN3ccc8DD10x9y83efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y83efgEv,_ZTv0_n12_N3ccc8DD10x9y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y83efgEv,_ZThn4_N3ccc8DD10x9y83efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y83efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y83efgEv,_ZTv0_n12_N3ccc8DD10x9y83efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y8E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y8E[] = {
  {&(_ZTVN3ccc8DD10x9y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y8E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y8E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y8E[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y83efgEv,_ZTv0_n12_N3ccc8DD10x9y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y83efgEv,_ZThn4_N3ccc8DD10x9y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y8E = {  "_ZN3ccc8DD10x9y8E", // class name
  bases__ZN3ccc8DD10x9y8E, 2,
  &(vtc__ZN3ccc8DD10x9y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y8E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y9  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8CC10x9y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC10x9y93pqrEv
  ~CC10x9y9(); // tgen
  CC10x9y9(); // tgen
};
//SIG(1 _ZN3ccc8CC10x9y9E) C1{ VBC2{ v2 v3} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x9y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC10x9y93efgEv");}
void  ccc::CC10x9y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC10x9y93pqrEv");}
ccc::CC10x9y9 ::~CC10x9y9(){ note_dtor("_ZN3ccc8CC10x9y9E", this);} // tgen
ccc::CC10x9y9 ::CC10x9y9(){ note_ctor("_ZN3ccc8CC10x9y9E", this);} // tgen
}
static void Test__ZN3ccc8CC10x9y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC10x9y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC10x9y9E, buf);
    ::ccc::CC10x9y9 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC10x9y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC10x9y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc8CC10x9y9E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc8CC10x9y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC10x9y9E);
    dp->::ccc::CC10x9y9::~CC10x9y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC10x9y9E(Test__ZN3ccc8CC10x9y9E, "_ZN3ccc8CC10x9y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC10x9y9C1Ev();
extern void _ZN3ccc8CC10x9y9D1Ev();
Name_Map name_map__ZN3ccc8CC10x9y9E[] = {
  NSPAIR(_ZN3ccc8CC10x9y9C1Ev),
  NSPAIR(_ZN3ccc8CC10x9y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC10x9y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y9E[];
extern void _ZN3ccc8CC10x9y93efgEv();
extern void _ZN3ccc8CC10x9y93pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC10x9y93pqrEv,_ZTv0_n12_N3ccc8CC10x9y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC10x9y93pqrEv,_ZThn4_N3ccc8CC10x9y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC10x9y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC10x9y93pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC10x9y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC10x9y93pqrEv,_ZTv0_n12_N3ccc8CC10x9y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC10x9y9E[];
static  VTT_ENTRY vtt__ZN3ccc8CC10x9y9E[] = {
  {&(_ZTVN3ccc8CC10x9y9E[3]),  3,11},
  {&(_ZTVN3ccc8CC10x9y9E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc8CC10x9y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC10x9y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC10x9y9E[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC10x9y93pqrEv,_ZTv0_n12_N3ccc8CC10x9y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC10x9y93pqrEv,_ZThn4_N3ccc8CC10x9y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC10x9y9E = {  "_ZN3ccc8CC10x9y9E", // class name
  bases__ZN3ccc8CC10x9y9E, 2,
  &(vtc__ZN3ccc8CC10x9y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC10x9y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC10x9y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC10x9y9E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC10x9y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y9  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8DD10x9y93efgEv
  virtual void  pqr(); // _ZN3ccc8DD10x9y93pqrEv
  ~DD10x9y9(); // tgen
  DD10x9y9(); // tgen
};
//SIG(1 _ZN3ccc8DD10x9y9E) C1{ VBC2{ v2 v3} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x9y9 ::efg(){vfunc_called(this, "_ZN3ccc8DD10x9y93efgEv");}
void  ccc::DD10x9y9 ::pqr(){vfunc_called(this, "_ZN3ccc8DD10x9y93pqrEv");}
ccc::DD10x9y9 ::~DD10x9y9(){ note_dtor("_ZN3ccc8DD10x9y9E", this);} // tgen
ccc::DD10x9y9 ::DD10x9y9(){ note_ctor("_ZN3ccc8DD10x9y9E", this);} // tgen
}
static void Test__ZN3ccc8DD10x9y9E()
{
  extern Class_Descriptor cd__ZN3ccc8DD10x9y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD10x9y9E, buf);
    ::ccc::DD10x9y9 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD10x9y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD10x9y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc8DD10x9y9E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8DD10x9y9E");
    test_class_info(&lv, &cd__ZN3ccc8DD10x9y9E);
    dp->::ccc::DD10x9y9::~DD10x9y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD10x9y9E(Test__ZN3ccc8DD10x9y9E, "_ZN3ccc8DD10x9y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD10x9y9C1Ev();
extern void _ZN3ccc8DD10x9y9D1Ev();
Name_Map name_map__ZN3ccc8DD10x9y9E[] = {
  NSPAIR(_ZN3ccc8DD10x9y9C1Ev),
  NSPAIR(_ZN3ccc8DD10x9y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8DD10x9y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y9E[];
extern void _ZN3ccc8DD10x9y93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc8DD10x9y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD10x9y93efgEv,_ZTv0_n12_N3ccc8DD10x9y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y93efgEv,_ZThn4_N3ccc8DD10x9y93efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD10x9y93pqrEv,_ZTv0_n16_N3ccc8DD10x9y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD10x9y93pqrEv,_ZThn4_N3ccc8DD10x9y93pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD10x9y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc8DD10x9y93efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD10x9y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD10x9y93efgEv,_ZTv0_n12_N3ccc8DD10x9y93efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD10x9y93pqrEv,_ZTv0_n16_N3ccc8DD10x9y93pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD10x9y9E[];
static  VTT_ENTRY vtt__ZN3ccc8DD10x9y9E[] = {
  {&(_ZTVN3ccc8DD10x9y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y9E[6]),  6,15},
  {&(_ZTVN3ccc8DD10x9y9E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc8DD10x9y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD10x9y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD10x9y9E[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD10x9y93pqrEv,_ZTv0_n16_N3ccc8DD10x9y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y93pqrEv,_ZThn4_N3ccc8DD10x9y93pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD10x9y93efgEv,_ZTv0_n12_N3ccc8DD10x9y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD10x9y93efgEv,_ZThn4_N3ccc8DD10x9y93efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD10x9y9E = {  "_ZN3ccc8DD10x9y9E", // class name
  bases__ZN3ccc8DD10x9y9E, 2,
  &(vtc__ZN3ccc8DD10x9y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD10x9y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD10x9y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD10x9y9E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD10x9y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y10  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc9CC10x9y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x9y103abcEv
  ~CC10x9y10(); // tgen
  CC10x9y10(); // tgen
};
//SIG(1 _ZN3ccc9CC10x9y10E) C1{ VBC2{ v1 v2} BC3{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x9y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x9y103pqrEv");}
void  ccc::CC10x9y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x9y103abcEv");}
ccc::CC10x9y10 ::~CC10x9y10(){ note_dtor("_ZN3ccc9CC10x9y10E", this);} // tgen
ccc::CC10x9y10 ::CC10x9y10(){ note_ctor("_ZN3ccc9CC10x9y10E", this);} // tgen
}
static void Test__ZN3ccc9CC10x9y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x9y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x9y10E, buf);
    ::ccc::CC10x9y10 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x9y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x9y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x9y10E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc9CC10x9y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x9y10E);
    dp->::ccc::CC10x9y10::~CC10x9y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x9y10E(Test__ZN3ccc9CC10x9y10E, "_ZN3ccc9CC10x9y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x9y10C1Ev();
extern void _ZN3ccc9CC10x9y10D1Ev();
Name_Map name_map__ZN3ccc9CC10x9y10E[] = {
  NSPAIR(_ZN3ccc9CC10x9y10C1Ev),
  NSPAIR(_ZN3ccc9CC10x9y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9CC10x9y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y10E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc9CC10x9y103pqrEv();
extern void _ZN3ccc9CC10x9y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x9y103pqrEv,_ZTv0_n12_N3ccc9CC10x9y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x9y103pqrEv,_ZThn4_N3ccc9CC10x9y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x9y103abcEv,_ZTv0_n16_N3ccc9CC10x9y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x9y103abcEv,_ZThn4_N3ccc9CC10x9y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x9y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x9y103pqrEv,_ZTv0_n12_N3ccc9CC10x9y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x9y103abcEv,_ZTv0_n16_N3ccc9CC10x9y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x9y10E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x9y10E[] = {
  {&(_ZTVN3ccc9CC10x9y10E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x9y10E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x9y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x9y10E[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x9y103abcEv,_ZTv0_n16_N3ccc9CC10x9y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x9y103abcEv,_ZThn4_N3ccc9CC10x9y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x9y103pqrEv,_ZTv0_n12_N3ccc9CC10x9y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x9y103pqrEv,_ZThn4_N3ccc9CC10x9y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x9y10E = {  "_ZN3ccc9CC10x9y10E", // class name
  bases__ZN3ccc9CC10x9y10E, 2,
  &(vtc__ZN3ccc9CC10x9y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x9y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x9y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x9y10E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x9y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y10  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc9DD10x9y103pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x9y103abcEv
  ~DD10x9y10(); // tgen
  DD10x9y10(); // tgen
};
//SIG(1 _ZN3ccc9DD10x9y10E) C1{ VBC2{ v1 v2} VBC3{ v3 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x9y10 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x9y103pqrEv");}
void  ccc::DD10x9y10 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x9y103abcEv");}
ccc::DD10x9y10 ::~DD10x9y10(){ note_dtor("_ZN3ccc9DD10x9y10E", this);} // tgen
ccc::DD10x9y10 ::DD10x9y10(){ note_ctor("_ZN3ccc9DD10x9y10E", this);} // tgen
}
static void Test__ZN3ccc9DD10x9y10E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x9y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x9y10E, buf);
    ::ccc::DD10x9y10 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x9y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x9y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x9y10E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc9DD10x9y10E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x9y10E);
    dp->::ccc::DD10x9y10::~DD10x9y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x9y10E(Test__ZN3ccc9DD10x9y10E, "_ZN3ccc9DD10x9y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x9y10C1Ev();
extern void _ZN3ccc9DD10x9y10D1Ev();
Name_Map name_map__ZN3ccc9DD10x9y10E[] = {
  NSPAIR(_ZN3ccc9DD10x9y10C1Ev),
  NSPAIR(_ZN3ccc9DD10x9y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9DD10x9y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y10E[];
extern void _ZN3ccc9DD10x9y103pqrEv();
extern void _ZN3ccc9DD10x9y103abcEv();
extern void _ZN3ccc3BB93efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x9y103pqrEv,_ZTv0_n16_N3ccc9DD10x9y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x9y103pqrEv,_ZThn4_N3ccc9DD10x9y103pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x9y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x9y103pqrEv,_ZTv0_n16_N3ccc9DD10x9y103pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x9y10E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x9y10E[] = {
  {&(_ZTVN3ccc9DD10x9y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y10E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y10E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x9y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x9y10E[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x9y103pqrEv,_ZTv0_n16_N3ccc9DD10x9y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x9y103pqrEv,_ZThn4_N3ccc9DD10x9y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x9y10E = {  "_ZN3ccc9DD10x9y10E", // class name
  bases__ZN3ccc9DD10x9y10E, 2,
  &(vtc__ZN3ccc9DD10x9y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x9y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x9y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x9y10E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x9y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y11  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc9CC10x9y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x9y113efgEv
  ~CC10x9y11(); // tgen
  CC10x9y11(); // tgen
};
//SIG(1 _ZN3ccc9CC10x9y11E) C1{ VBC2{ v1 v3} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x9y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x9y113pqrEv");}
void  ccc::CC10x9y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x9y113efgEv");}
ccc::CC10x9y11 ::~CC10x9y11(){ note_dtor("_ZN3ccc9CC10x9y11E", this);} // tgen
ccc::CC10x9y11 ::CC10x9y11(){ note_ctor("_ZN3ccc9CC10x9y11E", this);} // tgen
}
static void Test__ZN3ccc9CC10x9y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x9y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x9y11E, buf);
    ::ccc::CC10x9y11 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x9y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x9y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x9y11E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc9CC10x9y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x9y11E);
    dp->::ccc::CC10x9y11::~CC10x9y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x9y11E(Test__ZN3ccc9CC10x9y11E, "_ZN3ccc9CC10x9y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x9y11C1Ev();
extern void _ZN3ccc9CC10x9y11D1Ev();
Name_Map name_map__ZN3ccc9CC10x9y11E[] = {
  NSPAIR(_ZN3ccc9CC10x9y11C1Ev),
  NSPAIR(_ZN3ccc9CC10x9y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9CC10x9y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y11E[];
extern void _ZN3ccc9CC10x9y113efgEv();
extern void _ZN3ccc9CC10x9y113pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x9y113pqrEv,_ZTv0_n12_N3ccc9CC10x9y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x9y113pqrEv,_ZThn4_N3ccc9CC10x9y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x9y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y113pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x9y113pqrEv,_ZTv0_n12_N3ccc9CC10x9y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x9y11E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x9y11E[] = {
  {&(_ZTVN3ccc9CC10x9y11E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x9y11E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x9y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x9y11E[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x9y113pqrEv,_ZTv0_n12_N3ccc9CC10x9y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x9y113pqrEv,_ZThn4_N3ccc9CC10x9y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x9y11E = {  "_ZN3ccc9CC10x9y11E", // class name
  bases__ZN3ccc9CC10x9y11E, 2,
  &(vtc__ZN3ccc9CC10x9y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x9y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x9y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x9y11E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x9y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y11  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc9DD10x9y113pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x9y113efgEv
  ~DD10x9y11(); // tgen
  DD10x9y11(); // tgen
};
//SIG(1 _ZN3ccc9DD10x9y11E) C1{ VBC2{ v1 v3} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x9y11 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x9y113pqrEv");}
void  ccc::DD10x9y11 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x9y113efgEv");}
ccc::DD10x9y11 ::~DD10x9y11(){ note_dtor("_ZN3ccc9DD10x9y11E", this);} // tgen
ccc::DD10x9y11 ::DD10x9y11(){ note_ctor("_ZN3ccc9DD10x9y11E", this);} // tgen
}
static void Test__ZN3ccc9DD10x9y11E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x9y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x9y11E, buf);
    ::ccc::DD10x9y11 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x9y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x9y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x9y11E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc9DD10x9y11E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x9y11E);
    dp->::ccc::DD10x9y11::~DD10x9y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x9y11E(Test__ZN3ccc9DD10x9y11E, "_ZN3ccc9DD10x9y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x9y11C1Ev();
extern void _ZN3ccc9DD10x9y11D1Ev();
Name_Map name_map__ZN3ccc9DD10x9y11E[] = {
  NSPAIR(_ZN3ccc9DD10x9y11C1Ev),
  NSPAIR(_ZN3ccc9DD10x9y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9DD10x9y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y11E[];
extern void _ZN3ccc9DD10x9y113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x9y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x9y113efgEv,_ZTv0_n12_N3ccc9DD10x9y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x9y113efgEv,_ZThn4_N3ccc9DD10x9y113efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x9y113pqrEv,_ZTv0_n16_N3ccc9DD10x9y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x9y113pqrEv,_ZThn4_N3ccc9DD10x9y113pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x9y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y113efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x9y113efgEv,_ZTv0_n12_N3ccc9DD10x9y113efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x9y113pqrEv,_ZTv0_n16_N3ccc9DD10x9y113pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x9y11E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x9y11E[] = {
  {&(_ZTVN3ccc9DD10x9y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x9y11E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x9y11E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x9y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x9y11E[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x9y113pqrEv,_ZTv0_n16_N3ccc9DD10x9y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x9y113pqrEv,_ZThn4_N3ccc9DD10x9y113pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x9y113efgEv,_ZTv0_n12_N3ccc9DD10x9y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x9y113efgEv,_ZThn4_N3ccc9DD10x9y113efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x9y11E = {  "_ZN3ccc9DD10x9y11E", // class name
  bases__ZN3ccc9DD10x9y11E, 2,
  &(vtc__ZN3ccc9DD10x9y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x9y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x9y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x9y11E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x9y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y12  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc9CC10x9y123abcEv
  ~CC10x9y12(); // tgen
  CC10x9y12(); // tgen
};
//SIG(1 _ZN3ccc9CC10x9y12E) C1{ VBC2{ v2 v1} BC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::CC10x9y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x9y123abcEv");}
ccc::CC10x9y12 ::~CC10x9y12(){ note_dtor("_ZN3ccc9CC10x9y12E", this);} // tgen
ccc::CC10x9y12 ::CC10x9y12(){ note_ctor("_ZN3ccc9CC10x9y12E", this);} // tgen
}
static void Test__ZN3ccc9CC10x9y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x9y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x9y12E, buf);
    ::ccc::CC10x9y12 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x9y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x9y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x9y12E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc9CC10x9y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x9y12E);
    dp->::ccc::CC10x9y12::~CC10x9y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x9y12E(Test__ZN3ccc9CC10x9y12E, "_ZN3ccc9CC10x9y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x9y12C1Ev();
extern void _ZN3ccc9CC10x9y12D1Ev();
Name_Map name_map__ZN3ccc9CC10x9y12E[] = {
  NSPAIR(_ZN3ccc9CC10x9y12C1Ev),
  NSPAIR(_ZN3ccc9CC10x9y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9CC10x9y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y12E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
extern void _ZN3ccc9CC10x9y123abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x9y123abcEv,_ZTv0_n16_N3ccc9CC10x9y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x9y123abcEv,_ZThn4_N3ccc9CC10x9y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x9y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y123abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x9y123abcEv,_ZTv0_n16_N3ccc9CC10x9y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x9y12E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x9y12E[] = {
  {&(_ZTVN3ccc9CC10x9y12E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x9y12E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x9y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x9y12E[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x9y123abcEv,_ZTv0_n16_N3ccc9CC10x9y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x9y123abcEv,_ZThn4_N3ccc9CC10x9y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x9y12E = {  "_ZN3ccc9CC10x9y12E", // class name
  bases__ZN3ccc9CC10x9y12E, 2,
  &(vtc__ZN3ccc9CC10x9y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x9y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x9y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x9y12E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x9y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y12  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc9DD10x9y123abcEv
  ~DD10x9y12(); // tgen
  DD10x9y12(); // tgen
};
//SIG(1 _ZN3ccc9DD10x9y12E) C1{ VBC2{ v2 v1} VBC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::DD10x9y12 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x9y123abcEv");}
ccc::DD10x9y12 ::~DD10x9y12(){ note_dtor("_ZN3ccc9DD10x9y12E", this);} // tgen
ccc::DD10x9y12 ::DD10x9y12(){ note_ctor("_ZN3ccc9DD10x9y12E", this);} // tgen
}
static void Test__ZN3ccc9DD10x9y12E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x9y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x9y12E, buf);
    ::ccc::DD10x9y12 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x9y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x9y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x9y12E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc9DD10x9y12E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x9y12E);
    dp->::ccc::DD10x9y12::~DD10x9y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x9y12E(Test__ZN3ccc9DD10x9y12E, "_ZN3ccc9DD10x9y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x9y12C1Ev();
extern void _ZN3ccc9DD10x9y12D1Ev();
Name_Map name_map__ZN3ccc9DD10x9y12E[] = {
  NSPAIR(_ZN3ccc9DD10x9y12C1Ev),
  NSPAIR(_ZN3ccc9DD10x9y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9DD10x9y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x9y123abcEv();
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x9y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y123abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x9y12E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x9y12E[] = {
  {&(_ZTVN3ccc9DD10x9y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y12E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y12E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x9y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x9y12E[];
Class_Descriptor cd__ZN3ccc9DD10x9y12E = {  "_ZN3ccc9DD10x9y12E", // class name
  bases__ZN3ccc9DD10x9y12E, 2,
  &(vtc__ZN3ccc9DD10x9y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x9y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x9y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x9y12E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x9y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y13  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc9CC10x9y133efgEv
  ~CC10x9y13(); // tgen
  CC10x9y13(); // tgen
};
//SIG(1 _ZN3ccc9CC10x9y13E) C1{ VBC2{ v2 v3} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC10x9y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x9y133efgEv");}
ccc::CC10x9y13 ::~CC10x9y13(){ note_dtor("_ZN3ccc9CC10x9y13E", this);} // tgen
ccc::CC10x9y13 ::CC10x9y13(){ note_ctor("_ZN3ccc9CC10x9y13E", this);} // tgen
}
static void Test__ZN3ccc9CC10x9y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x9y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x9y13E, buf);
    ::ccc::CC10x9y13 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x9y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x9y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x9y13E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc9CC10x9y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x9y13E);
    dp->::ccc::CC10x9y13::~CC10x9y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x9y13E(Test__ZN3ccc9CC10x9y13E, "_ZN3ccc9CC10x9y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x9y13C1Ev();
extern void _ZN3ccc9CC10x9y13D1Ev();
Name_Map name_map__ZN3ccc9CC10x9y13E[] = {
  NSPAIR(_ZN3ccc9CC10x9y13C1Ev),
  NSPAIR(_ZN3ccc9CC10x9y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9CC10x9y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y13E[];
extern void _ZN3ccc9CC10x9y133efgEv();
extern void _ZN3ccc3BB93pqrEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x9y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x9y13E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x9y13E[] = {
  {&(_ZTVN3ccc9CC10x9y13E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x9y13E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x9y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x9y13E[];
Class_Descriptor cd__ZN3ccc9CC10x9y13E = {  "_ZN3ccc9CC10x9y13E", // class name
  bases__ZN3ccc9CC10x9y13E, 2,
  &(vtc__ZN3ccc9CC10x9y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x9y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x9y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x9y13E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x9y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y13  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc9DD10x9y133efgEv
  ~DD10x9y13(); // tgen
  DD10x9y13(); // tgen
};
//SIG(1 _ZN3ccc9DD10x9y13E) C1{ VBC2{ v2 v3} VBC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::DD10x9y13 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x9y133efgEv");}
ccc::DD10x9y13 ::~DD10x9y13(){ note_dtor("_ZN3ccc9DD10x9y13E", this);} // tgen
ccc::DD10x9y13 ::DD10x9y13(){ note_ctor("_ZN3ccc9DD10x9y13E", this);} // tgen
}
static void Test__ZN3ccc9DD10x9y13E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x9y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x9y13E, buf);
    ::ccc::DD10x9y13 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x9y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x9y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x9y13E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc9DD10x9y13E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x9y13E);
    dp->::ccc::DD10x9y13::~DD10x9y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x9y13E(Test__ZN3ccc9DD10x9y13E, "_ZN3ccc9DD10x9y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x9y13C1Ev();
extern void _ZN3ccc9DD10x9y13D1Ev();
Name_Map name_map__ZN3ccc9DD10x9y13E[] = {
  NSPAIR(_ZN3ccc9DD10x9y13C1Ev),
  NSPAIR(_ZN3ccc9DD10x9y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9DD10x9y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x9y133efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x9y133efgEv,_ZTv0_n12_N3ccc9DD10x9y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x9y133efgEv,_ZThn4_N3ccc9DD10x9y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x9y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y133efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x9y133efgEv,_ZTv0_n12_N3ccc9DD10x9y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x9y13E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x9y13E[] = {
  {&(_ZTVN3ccc9DD10x9y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x9y13E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x9y13E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x9y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x9y13E[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x9y133efgEv,_ZTv0_n12_N3ccc9DD10x9y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x9y133efgEv,_ZThn4_N3ccc9DD10x9y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x9y13E = {  "_ZN3ccc9DD10x9y13E", // class name
  bases__ZN3ccc9DD10x9y13E, 2,
  &(vtc__ZN3ccc9DD10x9y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x9y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x9y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x9y13E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x9y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y14  : virtual ::ccc::AA10 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc9CC10x9y143pqrEv
  ~CC10x9y14(); // tgen
  CC10x9y14(); // tgen
};
//SIG(1 _ZN3ccc9CC10x9y14E) C1{ VBC2{ v1 v2} BC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::CC10x9y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x9y143pqrEv");}
ccc::CC10x9y14 ::~CC10x9y14(){ note_dtor("_ZN3ccc9CC10x9y14E", this);} // tgen
ccc::CC10x9y14 ::CC10x9y14(){ note_ctor("_ZN3ccc9CC10x9y14E", this);} // tgen
}
static void Test__ZN3ccc9CC10x9y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x9y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x9y14E, buf);
    ::ccc::CC10x9y14 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x9y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x9y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x9y14E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc9CC10x9y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x9y14E);
    dp->::ccc::CC10x9y14::~CC10x9y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x9y14E(Test__ZN3ccc9CC10x9y14E, "_ZN3ccc9CC10x9y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x9y14C1Ev();
extern void _ZN3ccc9CC10x9y14D1Ev();
Name_Map name_map__ZN3ccc9CC10x9y14E[] = {
  NSPAIR(_ZN3ccc9CC10x9y14C1Ev),
  NSPAIR(_ZN3ccc9CC10x9y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9CC10x9y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y14E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc9CC10x9y143pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x9y143pqrEv,_ZTv0_n12_N3ccc9CC10x9y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x9y143pqrEv,_ZThn4_N3ccc9CC10x9y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x9y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x9y143pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x9y143pqrEv,_ZTv0_n12_N3ccc9CC10x9y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x9y14E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x9y14E[] = {
  {&(_ZTVN3ccc9CC10x9y14E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x9y14E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x9y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x9y14E[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x9y143pqrEv,_ZTv0_n12_N3ccc9CC10x9y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x9y143pqrEv,_ZThn4_N3ccc9CC10x9y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x9y14E = {  "_ZN3ccc9CC10x9y14E", // class name
  bases__ZN3ccc9CC10x9y14E, 2,
  &(vtc__ZN3ccc9CC10x9y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x9y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x9y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x9y14E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x9y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y14  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc9DD10x9y143pqrEv
  ~DD10x9y14(); // tgen
  DD10x9y14(); // tgen
};
//SIG(1 _ZN3ccc9DD10x9y14E) C1{ VBC2{ v1 v2} VBC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::DD10x9y14 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x9y143pqrEv");}
ccc::DD10x9y14 ::~DD10x9y14(){ note_dtor("_ZN3ccc9DD10x9y14E", this);} // tgen
ccc::DD10x9y14 ::DD10x9y14(){ note_ctor("_ZN3ccc9DD10x9y14E", this);} // tgen
}
static void Test__ZN3ccc9DD10x9y14E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x9y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x9y14E, buf);
    ::ccc::DD10x9y14 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x9y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x9y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x9y14E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc9DD10x9y14E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x9y14E);
    dp->::ccc::DD10x9y14::~DD10x9y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x9y14E(Test__ZN3ccc9DD10x9y14E, "_ZN3ccc9DD10x9y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x9y14C1Ev();
extern void _ZN3ccc9DD10x9y14D1Ev();
Name_Map name_map__ZN3ccc9DD10x9y14E[] = {
  NSPAIR(_ZN3ccc9DD10x9y14C1Ev),
  NSPAIR(_ZN3ccc9DD10x9y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9DD10x9y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y14E[];
extern void _ZN3ccc9DD10x9y143pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB93efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x9y143pqrEv,_ZTv0_n16_N3ccc9DD10x9y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x9y143pqrEv,_ZThn4_N3ccc9DD10x9y143pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x9y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x9y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x9y143pqrEv,_ZTv0_n16_N3ccc9DD10x9y143pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x9y14E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x9y14E[] = {
  {&(_ZTVN3ccc9DD10x9y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y14E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y14E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x9y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x9y14E[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x9y143pqrEv,_ZTv0_n16_N3ccc9DD10x9y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x9y143pqrEv,_ZThn4_N3ccc9DD10x9y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x9y14E = {  "_ZN3ccc9DD10x9y14E", // class name
  bases__ZN3ccc9DD10x9y14E, 2,
  &(vtc__ZN3ccc9DD10x9y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x9y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x9y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x9y14E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x9y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x9y15  : virtual ::ccc::AA10 , ::ccc::BB9 {
  ~CC10x9y15(); // tgen
  CC10x9y15(); // tgen
};
//SIG(1 _ZN3ccc9CC10x9y15E) C1{ VBC2{ v1 v2} BC3{ v3 v4}}
}
namespace ccc { 
ccc::CC10x9y15 ::~CC10x9y15(){ note_dtor("_ZN3ccc9CC10x9y15E", this);} // tgen
ccc::CC10x9y15 ::CC10x9y15(){ note_ctor("_ZN3ccc9CC10x9y15E", this);} // tgen
}
static void Test__ZN3ccc9CC10x9y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x9y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x9y15E, buf);
    ::ccc::CC10x9y15 *dp, &lv = *(dp=new (buf) ::ccc::CC10x9y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x9y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x9y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x9y15E");
    check_base_class_offset(lv, (::ccc::BB9*), 0, "_ZN3ccc9CC10x9y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x9y15E);
    dp->::ccc::CC10x9y15::~CC10x9y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x9y15E(Test__ZN3ccc9CC10x9y15E, "_ZN3ccc9CC10x9y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x9y15C1Ev();
extern void _ZN3ccc9CC10x9y15D1Ev();
Name_Map name_map__ZN3ccc9CC10x9y15E[] = {
  NSPAIR(_ZN3ccc9CC10x9y15C1Ev),
  NSPAIR(_ZN3ccc9CC10x9y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9CC10x9y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y15E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x9y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x9y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x9y15E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x9y15E[] = {
  {&(_ZTVN3ccc9CC10x9y15E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x9y15E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x9y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x9y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x9y15E[];
Class_Descriptor cd__ZN3ccc9CC10x9y15E = {  "_ZN3ccc9CC10x9y15E", // class name
  bases__ZN3ccc9CC10x9y15E, 2,
  &(vtc__ZN3ccc9CC10x9y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x9y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x9y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x9y15E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x9y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x9y15  : virtual ::ccc::AA10 , virtual ::ccc::BB9 {
  ~DD10x9y15(); // tgen
  DD10x9y15(); // tgen
};
//SIG(1 _ZN3ccc9DD10x9y15E) C1{ VBC2{ v1 v2} VBC3{ v3 v4}}
}
namespace ccc { 
ccc::DD10x9y15 ::~DD10x9y15(){ note_dtor("_ZN3ccc9DD10x9y15E", this);} // tgen
ccc::DD10x9y15 ::DD10x9y15(){ note_ctor("_ZN3ccc9DD10x9y15E", this);} // tgen
}
static void Test__ZN3ccc9DD10x9y15E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x9y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x9y15E, buf);
    ::ccc::DD10x9y15 *dp, &lv = *(dp=new (buf) ::ccc::DD10x9y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x9y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x9y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x9y15E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc9DD10x9y15E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x9y15E);
    dp->::ccc::DD10x9y15::~DD10x9y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x9y15E(Test__ZN3ccc9DD10x9y15E, "_ZN3ccc9DD10x9y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x9y15C1Ev();
extern void _ZN3ccc9DD10x9y15D1Ev();
Name_Map name_map__ZN3ccc9DD10x9y15E[] = {
  NSPAIR(_ZN3ccc9DD10x9y15C1Ev),
  NSPAIR(_ZN3ccc9DD10x9y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc9DD10x9y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x9y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x9y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x9y15E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x9y15E[] = {
  {&(_ZTVN3ccc9DD10x9y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y15E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x9y15E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x9y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x9y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x9y15E[];
Class_Descriptor cd__ZN3ccc9DD10x9y15E = {  "_ZN3ccc9DD10x9y15E", // class name
  bases__ZN3ccc9DD10x9y15E, 2,
  &(vtc__ZN3ccc9DD10x9y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x9y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x9y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x9y15E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x9y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y0  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9CC10x10y03abcEv
  virtual void  efg(); // _ZN3ccc9CC10x10y03efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x10y03pqrEv
  ~CC10x10y0(); // tgen
  CC10x10y0(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y0E) C1{ VBC2{ v3 v1} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x10y0 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y03abcEv");}
void  ccc::CC10x10y0 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y03efgEv");}
void  ccc::CC10x10y0 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y03pqrEv");}
ccc::CC10x10y0 ::~CC10x10y0(){ note_dtor("_ZN3ccc9CC10x10y0E", this);} // tgen
ccc::CC10x10y0 ::CC10x10y0(){ note_ctor("_ZN3ccc9CC10x10y0E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y0E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y0E, buf);
    ::ccc::CC10x10y0 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y0E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y0E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y0E);
    dp->::ccc::CC10x10y0::~CC10x10y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y0E(Test__ZN3ccc9CC10x10y0E, "_ZN3ccc9CC10x10y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y0C1Ev();
extern void _ZN3ccc9CC10x10y0D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y0E[] = {
  NSPAIR(_ZN3ccc9CC10x10y0C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y0E[];
extern void _ZN3ccc9CC10x10y03pqrEv();
extern void _ZN3ccc9CC10x10y03abcEv();
extern void _ZN3ccc9CC10x10y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y03pqrEv,_ZTv0_n12_N3ccc9CC10x10y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y03pqrEv,_ZThn4_N3ccc9CC10x10y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y03abcEv,_ZTv0_n16_N3ccc9CC10x10y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y03abcEv,_ZThn4_N3ccc9CC10x10y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y03pqrEv,_ZTv0_n12_N3ccc9CC10x10y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y03abcEv,_ZTv0_n16_N3ccc9CC10x10y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y0E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y0E[] = {
  {&(_ZTVN3ccc9CC10x10y0E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y0E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y0E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y0E[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y03abcEv,_ZTv0_n16_N3ccc9CC10x10y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y03abcEv,_ZThn4_N3ccc9CC10x10y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y03pqrEv,_ZTv0_n12_N3ccc9CC10x10y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y03pqrEv,_ZThn4_N3ccc9CC10x10y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y0E = {  "_ZN3ccc9CC10x10y0E", // class name
  bases__ZN3ccc9CC10x10y0E, 2,
  &(vtc__ZN3ccc9CC10x10y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y0E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y0  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9DD10x10y03abcEv
  virtual void  efg(); // _ZN3ccc9DD10x10y03efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x10y03pqrEv
  ~DD10x10y0(); // tgen
  DD10x10y0(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y0E) C1{ VBC2{ v3 v1} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x10y0 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y03abcEv");}
void  ccc::DD10x10y0 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y03efgEv");}
void  ccc::DD10x10y0 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y03pqrEv");}
ccc::DD10x10y0 ::~DD10x10y0(){ note_dtor("_ZN3ccc9DD10x10y0E", this);} // tgen
ccc::DD10x10y0 ::DD10x10y0(){ note_ctor("_ZN3ccc9DD10x10y0E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y0E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y0E, buf);
    ::ccc::DD10x10y0 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y0E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y0E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y0E);
    dp->::ccc::DD10x10y0::~DD10x10y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y0E(Test__ZN3ccc9DD10x10y0E, "_ZN3ccc9DD10x10y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y0C1Ev();
extern void _ZN3ccc9DD10x10y0D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y0E[] = {
  NSPAIR(_ZN3ccc9DD10x10y0C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y0E[];
extern void _ZN3ccc9DD10x10y03pqrEv();
extern void _ZN3ccc9DD10x10y03abcEv();
extern void _ZN3ccc9DD10x10y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y03pqrEv,_ZTv0_n12_N3ccc9DD10x10y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y03pqrEv,_ZThn4_N3ccc9DD10x10y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y03abcEv,_ZTv0_n16_N3ccc9DD10x10y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y03abcEv,_ZThn4_N3ccc9DD10x10y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y03pqrEv,_ZTv0_n12_N3ccc9DD10x10y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y03abcEv,_ZTv0_n16_N3ccc9DD10x10y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y0E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y0E[] = {
  {&(_ZTVN3ccc9DD10x10y0E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y0E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y0E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y0E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y0E[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y03abcEv,_ZTv0_n16_N3ccc9DD10x10y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y03abcEv,_ZThn4_N3ccc9DD10x10y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y03pqrEv,_ZTv0_n12_N3ccc9DD10x10y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y03pqrEv,_ZThn4_N3ccc9DD10x10y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y0E = {  "_ZN3ccc9DD10x10y0E", // class name
  bases__ZN3ccc9DD10x10y0E, 2,
  &(vtc__ZN3ccc9DD10x10y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y0E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y1  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9CC10x10y13abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x10y13pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x10y13efgEv
  ~CC10x10y1(); // tgen
  CC10x10y1(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y1E) C1{ VBC2{ v2 v1} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x10y1 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y13abcEv");}
void  ccc::CC10x10y1 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y13pqrEv");}
void  ccc::CC10x10y1 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y13efgEv");}
ccc::CC10x10y1 ::~CC10x10y1(){ note_dtor("_ZN3ccc9CC10x10y1E", this);} // tgen
ccc::CC10x10y1 ::CC10x10y1(){ note_ctor("_ZN3ccc9CC10x10y1E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y1E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y1E, buf);
    ::ccc::CC10x10y1 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y1E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y1E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y1E);
    dp->::ccc::CC10x10y1::~CC10x10y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y1E(Test__ZN3ccc9CC10x10y1E, "_ZN3ccc9CC10x10y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y1C1Ev();
extern void _ZN3ccc9CC10x10y1D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y1E[] = {
  NSPAIR(_ZN3ccc9CC10x10y1C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y1E[];
extern void _ZN3ccc9CC10x10y13pqrEv();
extern void _ZN3ccc9CC10x10y13abcEv();
extern void _ZN3ccc9CC10x10y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y13pqrEv,_ZTv0_n12_N3ccc9CC10x10y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y13pqrEv,_ZThn4_N3ccc9CC10x10y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y13abcEv,_ZTv0_n16_N3ccc9CC10x10y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y13abcEv,_ZThn4_N3ccc9CC10x10y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y13pqrEv,_ZTv0_n12_N3ccc9CC10x10y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y13abcEv,_ZTv0_n16_N3ccc9CC10x10y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y1E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y1E[] = {
  {&(_ZTVN3ccc9CC10x10y1E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y1E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y1E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y1E[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y13abcEv,_ZTv0_n16_N3ccc9CC10x10y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y13abcEv,_ZThn4_N3ccc9CC10x10y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y13pqrEv,_ZTv0_n12_N3ccc9CC10x10y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y13pqrEv,_ZThn4_N3ccc9CC10x10y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y1E = {  "_ZN3ccc9CC10x10y1E", // class name
  bases__ZN3ccc9CC10x10y1E, 2,
  &(vtc__ZN3ccc9CC10x10y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y1E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y1  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9DD10x10y13abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x10y13pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x10y13efgEv
  ~DD10x10y1(); // tgen
  DD10x10y1(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y1E) C1{ VBC2{ v2 v1} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x10y1 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y13abcEv");}
void  ccc::DD10x10y1 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y13pqrEv");}
void  ccc::DD10x10y1 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y13efgEv");}
ccc::DD10x10y1 ::~DD10x10y1(){ note_dtor("_ZN3ccc9DD10x10y1E", this);} // tgen
ccc::DD10x10y1 ::DD10x10y1(){ note_ctor("_ZN3ccc9DD10x10y1E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y1E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y1E, buf);
    ::ccc::DD10x10y1 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y1E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y1E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y1E);
    dp->::ccc::DD10x10y1::~DD10x10y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y1E(Test__ZN3ccc9DD10x10y1E, "_ZN3ccc9DD10x10y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y1C1Ev();
extern void _ZN3ccc9DD10x10y1D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y1E[] = {
  NSPAIR(_ZN3ccc9DD10x10y1C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y1E[];
extern void _ZN3ccc9DD10x10y13pqrEv();
extern void _ZN3ccc9DD10x10y13abcEv();
extern void _ZN3ccc9DD10x10y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y13pqrEv,_ZTv0_n12_N3ccc9DD10x10y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y13pqrEv,_ZThn4_N3ccc9DD10x10y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y13abcEv,_ZTv0_n16_N3ccc9DD10x10y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y13abcEv,_ZThn4_N3ccc9DD10x10y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y13pqrEv,_ZTv0_n12_N3ccc9DD10x10y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y13abcEv,_ZTv0_n16_N3ccc9DD10x10y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y1E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y1E[] = {
  {&(_ZTVN3ccc9DD10x10y1E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y1E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y1E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y1E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y1E[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y13abcEv,_ZTv0_n16_N3ccc9DD10x10y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y13abcEv,_ZThn4_N3ccc9DD10x10y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y13pqrEv,_ZTv0_n12_N3ccc9DD10x10y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y13pqrEv,_ZThn4_N3ccc9DD10x10y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y1E = {  "_ZN3ccc9DD10x10y1E", // class name
  bases__ZN3ccc9DD10x10y1E, 2,
  &(vtc__ZN3ccc9DD10x10y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y1E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y2  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9CC10x10y23efgEv
  virtual void  abc(); // _ZN3ccc9CC10x10y23abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x10y23pqrEv
  ~CC10x10y2(); // tgen
  CC10x10y2(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y2E) C1{ VBC2{ v3 v2} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x10y2 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y23efgEv");}
void  ccc::CC10x10y2 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y23abcEv");}
void  ccc::CC10x10y2 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y23pqrEv");}
ccc::CC10x10y2 ::~CC10x10y2(){ note_dtor("_ZN3ccc9CC10x10y2E", this);} // tgen
ccc::CC10x10y2 ::CC10x10y2(){ note_ctor("_ZN3ccc9CC10x10y2E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y2E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y2E, buf);
    ::ccc::CC10x10y2 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y2E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y2E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y2E);
    dp->::ccc::CC10x10y2::~CC10x10y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y2E(Test__ZN3ccc9CC10x10y2E, "_ZN3ccc9CC10x10y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y2C1Ev();
extern void _ZN3ccc9CC10x10y2D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y2E[] = {
  NSPAIR(_ZN3ccc9CC10x10y2C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y2E[];
extern void _ZN3ccc9CC10x10y23pqrEv();
extern void _ZN3ccc9CC10x10y23abcEv();
extern void _ZN3ccc9CC10x10y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y23pqrEv,_ZTv0_n12_N3ccc9CC10x10y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y23pqrEv,_ZThn4_N3ccc9CC10x10y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y23abcEv,_ZTv0_n16_N3ccc9CC10x10y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y23abcEv,_ZThn4_N3ccc9CC10x10y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y23pqrEv,_ZTv0_n12_N3ccc9CC10x10y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y23abcEv,_ZTv0_n16_N3ccc9CC10x10y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y2E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y2E[] = {
  {&(_ZTVN3ccc9CC10x10y2E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y2E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y2E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y2E[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y23abcEv,_ZTv0_n16_N3ccc9CC10x10y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y23abcEv,_ZThn4_N3ccc9CC10x10y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y23pqrEv,_ZTv0_n12_N3ccc9CC10x10y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y23pqrEv,_ZThn4_N3ccc9CC10x10y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y2E = {  "_ZN3ccc9CC10x10y2E", // class name
  bases__ZN3ccc9CC10x10y2E, 2,
  &(vtc__ZN3ccc9CC10x10y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y2E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y2  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9DD10x10y23efgEv
  virtual void  abc(); // _ZN3ccc9DD10x10y23abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x10y23pqrEv
  ~DD10x10y2(); // tgen
  DD10x10y2(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y2E) C1{ VBC2{ v3 v2} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x10y2 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y23efgEv");}
void  ccc::DD10x10y2 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y23abcEv");}
void  ccc::DD10x10y2 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y23pqrEv");}
ccc::DD10x10y2 ::~DD10x10y2(){ note_dtor("_ZN3ccc9DD10x10y2E", this);} // tgen
ccc::DD10x10y2 ::DD10x10y2(){ note_ctor("_ZN3ccc9DD10x10y2E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y2E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y2E, buf);
    ::ccc::DD10x10y2 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y2E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y2E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y2E);
    dp->::ccc::DD10x10y2::~DD10x10y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y2E(Test__ZN3ccc9DD10x10y2E, "_ZN3ccc9DD10x10y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y2C1Ev();
extern void _ZN3ccc9DD10x10y2D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y2E[] = {
  NSPAIR(_ZN3ccc9DD10x10y2C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y2E[];
extern void _ZN3ccc9DD10x10y23pqrEv();
extern void _ZN3ccc9DD10x10y23abcEv();
extern void _ZN3ccc9DD10x10y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y23pqrEv,_ZTv0_n12_N3ccc9DD10x10y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y23pqrEv,_ZThn4_N3ccc9DD10x10y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y23abcEv,_ZTv0_n16_N3ccc9DD10x10y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y23abcEv,_ZThn4_N3ccc9DD10x10y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y23pqrEv,_ZTv0_n12_N3ccc9DD10x10y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y23abcEv,_ZTv0_n16_N3ccc9DD10x10y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y2E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y2E[] = {
  {&(_ZTVN3ccc9DD10x10y2E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y2E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y2E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y2E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y2E[];
static VTBL_ENTRY alt_thunk_names110[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y23abcEv,_ZTv0_n16_N3ccc9DD10x10y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y23abcEv,_ZThn4_N3ccc9DD10x10y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y23pqrEv,_ZTv0_n12_N3ccc9DD10x10y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y23pqrEv,_ZThn4_N3ccc9DD10x10y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y2E = {  "_ZN3ccc9DD10x10y2E", // class name
  bases__ZN3ccc9DD10x10y2E, 2,
  &(vtc__ZN3ccc9DD10x10y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y2E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names110,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y3  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9CC10x10y33efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x10y33pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x10y33abcEv
  ~CC10x10y3(); // tgen
  CC10x10y3(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y3E) C1{ VBC2{ v2 v3} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x10y3 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y33efgEv");}
void  ccc::CC10x10y3 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y33pqrEv");}
void  ccc::CC10x10y3 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y33abcEv");}
ccc::CC10x10y3 ::~CC10x10y3(){ note_dtor("_ZN3ccc9CC10x10y3E", this);} // tgen
ccc::CC10x10y3 ::CC10x10y3(){ note_ctor("_ZN3ccc9CC10x10y3E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y3E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y3E, buf);
    ::ccc::CC10x10y3 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y3E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y3E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y3E);
    dp->::ccc::CC10x10y3::~CC10x10y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y3E(Test__ZN3ccc9CC10x10y3E, "_ZN3ccc9CC10x10y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y3C1Ev();
extern void _ZN3ccc9CC10x10y3D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y3E[] = {
  NSPAIR(_ZN3ccc9CC10x10y3C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y3E[];
extern void _ZN3ccc9CC10x10y33pqrEv();
extern void _ZN3ccc9CC10x10y33abcEv();
extern void _ZN3ccc9CC10x10y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y33pqrEv,_ZTv0_n12_N3ccc9CC10x10y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y33pqrEv,_ZThn4_N3ccc9CC10x10y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y33abcEv,_ZTv0_n16_N3ccc9CC10x10y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y33abcEv,_ZThn4_N3ccc9CC10x10y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y33pqrEv,_ZTv0_n12_N3ccc9CC10x10y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y33abcEv,_ZTv0_n16_N3ccc9CC10x10y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y3E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y3E[] = {
  {&(_ZTVN3ccc9CC10x10y3E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y3E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y3E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y3E[];
static VTBL_ENTRY alt_thunk_names111[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y33abcEv,_ZTv0_n16_N3ccc9CC10x10y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y33abcEv,_ZThn4_N3ccc9CC10x10y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y33pqrEv,_ZTv0_n12_N3ccc9CC10x10y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y33pqrEv,_ZThn4_N3ccc9CC10x10y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y3E = {  "_ZN3ccc9CC10x10y3E", // class name
  bases__ZN3ccc9CC10x10y3E, 2,
  &(vtc__ZN3ccc9CC10x10y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y3E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names111,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y3  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9DD10x10y33efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x10y33pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x10y33abcEv
  ~DD10x10y3(); // tgen
  DD10x10y3(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y3E) C1{ VBC2{ v2 v3} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x10y3 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y33efgEv");}
void  ccc::DD10x10y3 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y33pqrEv");}
void  ccc::DD10x10y3 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y33abcEv");}
ccc::DD10x10y3 ::~DD10x10y3(){ note_dtor("_ZN3ccc9DD10x10y3E", this);} // tgen
ccc::DD10x10y3 ::DD10x10y3(){ note_ctor("_ZN3ccc9DD10x10y3E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y3E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y3E, buf);
    ::ccc::DD10x10y3 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y3E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y3E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y3E);
    dp->::ccc::DD10x10y3::~DD10x10y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y3E(Test__ZN3ccc9DD10x10y3E, "_ZN3ccc9DD10x10y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y3C1Ev();
extern void _ZN3ccc9DD10x10y3D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y3E[] = {
  NSPAIR(_ZN3ccc9DD10x10y3C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y3E[];
extern void _ZN3ccc9DD10x10y33pqrEv();
extern void _ZN3ccc9DD10x10y33abcEv();
extern void _ZN3ccc9DD10x10y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y33pqrEv,_ZTv0_n12_N3ccc9DD10x10y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y33pqrEv,_ZThn4_N3ccc9DD10x10y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y33abcEv,_ZTv0_n16_N3ccc9DD10x10y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y33abcEv,_ZThn4_N3ccc9DD10x10y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y33pqrEv,_ZTv0_n12_N3ccc9DD10x10y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y33abcEv,_ZTv0_n16_N3ccc9DD10x10y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y3E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y3E[] = {
  {&(_ZTVN3ccc9DD10x10y3E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y3E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y3E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y3E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y3E[];
static VTBL_ENTRY alt_thunk_names112[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y33abcEv,_ZTv0_n16_N3ccc9DD10x10y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y33abcEv,_ZThn4_N3ccc9DD10x10y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y33pqrEv,_ZTv0_n12_N3ccc9DD10x10y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y33pqrEv,_ZThn4_N3ccc9DD10x10y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y3E = {  "_ZN3ccc9DD10x10y3E", // class name
  bases__ZN3ccc9DD10x10y3E, 2,
  &(vtc__ZN3ccc9DD10x10y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y3E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names112,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y4  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9CC10x10y43pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x10y43abcEv
  virtual void  efg(); // _ZN3ccc9CC10x10y43efgEv
  ~CC10x10y4(); // tgen
  CC10x10y4(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y4E) C1{ VBC2{ v1 v2} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x10y4 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y43pqrEv");}
void  ccc::CC10x10y4 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y43abcEv");}
void  ccc::CC10x10y4 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y43efgEv");}
ccc::CC10x10y4 ::~CC10x10y4(){ note_dtor("_ZN3ccc9CC10x10y4E", this);} // tgen
ccc::CC10x10y4 ::CC10x10y4(){ note_ctor("_ZN3ccc9CC10x10y4E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y4E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y4E, buf);
    ::ccc::CC10x10y4 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y4E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y4E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y4E);
    dp->::ccc::CC10x10y4::~CC10x10y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y4E(Test__ZN3ccc9CC10x10y4E, "_ZN3ccc9CC10x10y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y4C1Ev();
extern void _ZN3ccc9CC10x10y4D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y4E[] = {
  NSPAIR(_ZN3ccc9CC10x10y4C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y4E[];
extern void _ZN3ccc9CC10x10y43pqrEv();
extern void _ZN3ccc9CC10x10y43abcEv();
extern void _ZN3ccc9CC10x10y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y43pqrEv,_ZTv0_n12_N3ccc9CC10x10y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y43pqrEv,_ZThn4_N3ccc9CC10x10y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y43abcEv,_ZTv0_n16_N3ccc9CC10x10y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y43abcEv,_ZThn4_N3ccc9CC10x10y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y43pqrEv,_ZTv0_n12_N3ccc9CC10x10y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y43abcEv,_ZTv0_n16_N3ccc9CC10x10y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y4E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y4E[] = {
  {&(_ZTVN3ccc9CC10x10y4E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y4E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y4E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y4E[];
static VTBL_ENTRY alt_thunk_names113[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y43abcEv,_ZTv0_n16_N3ccc9CC10x10y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y43abcEv,_ZThn4_N3ccc9CC10x10y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y43pqrEv,_ZTv0_n12_N3ccc9CC10x10y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y43pqrEv,_ZThn4_N3ccc9CC10x10y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y4E = {  "_ZN3ccc9CC10x10y4E", // class name
  bases__ZN3ccc9CC10x10y4E, 2,
  &(vtc__ZN3ccc9CC10x10y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y4E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names113,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y4  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9DD10x10y43pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x10y43abcEv
  virtual void  efg(); // _ZN3ccc9DD10x10y43efgEv
  ~DD10x10y4(); // tgen
  DD10x10y4(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y4E) C1{ VBC2{ v1 v2} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x10y4 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y43pqrEv");}
void  ccc::DD10x10y4 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y43abcEv");}
void  ccc::DD10x10y4 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y43efgEv");}
ccc::DD10x10y4 ::~DD10x10y4(){ note_dtor("_ZN3ccc9DD10x10y4E", this);} // tgen
ccc::DD10x10y4 ::DD10x10y4(){ note_ctor("_ZN3ccc9DD10x10y4E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y4E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y4E, buf);
    ::ccc::DD10x10y4 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y4E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y4E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y4E);
    dp->::ccc::DD10x10y4::~DD10x10y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y4E(Test__ZN3ccc9DD10x10y4E, "_ZN3ccc9DD10x10y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y4C1Ev();
extern void _ZN3ccc9DD10x10y4D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y4E[] = {
  NSPAIR(_ZN3ccc9DD10x10y4C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y4E[];
extern void _ZN3ccc9DD10x10y43pqrEv();
extern void _ZN3ccc9DD10x10y43abcEv();
extern void _ZN3ccc9DD10x10y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y43pqrEv,_ZTv0_n12_N3ccc9DD10x10y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y43pqrEv,_ZThn4_N3ccc9DD10x10y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y43abcEv,_ZTv0_n16_N3ccc9DD10x10y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y43abcEv,_ZThn4_N3ccc9DD10x10y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y43pqrEv,_ZTv0_n12_N3ccc9DD10x10y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y43abcEv,_ZTv0_n16_N3ccc9DD10x10y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y4E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y4E[] = {
  {&(_ZTVN3ccc9DD10x10y4E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y4E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y4E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y4E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y4E[];
static VTBL_ENTRY alt_thunk_names114[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y43abcEv,_ZTv0_n16_N3ccc9DD10x10y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y43abcEv,_ZThn4_N3ccc9DD10x10y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y43pqrEv,_ZTv0_n12_N3ccc9DD10x10y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y43pqrEv,_ZThn4_N3ccc9DD10x10y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y4E = {  "_ZN3ccc9DD10x10y4E", // class name
  bases__ZN3ccc9DD10x10y4E, 2,
  &(vtc__ZN3ccc9DD10x10y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y4E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names114,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y5  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9CC10x10y53pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x10y53efgEv
  virtual void  abc(); // _ZN3ccc9CC10x10y53abcEv
  ~CC10x10y5(); // tgen
  CC10x10y5(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y5E) C1{ VBC2{ v1 v3} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x10y5 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y53pqrEv");}
void  ccc::CC10x10y5 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y53efgEv");}
void  ccc::CC10x10y5 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y53abcEv");}
ccc::CC10x10y5 ::~CC10x10y5(){ note_dtor("_ZN3ccc9CC10x10y5E", this);} // tgen
ccc::CC10x10y5 ::CC10x10y5(){ note_ctor("_ZN3ccc9CC10x10y5E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y5E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y5E, buf);
    ::ccc::CC10x10y5 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y5E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y5E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y5E);
    dp->::ccc::CC10x10y5::~CC10x10y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y5E(Test__ZN3ccc9CC10x10y5E, "_ZN3ccc9CC10x10y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y5C1Ev();
extern void _ZN3ccc9CC10x10y5D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y5E[] = {
  NSPAIR(_ZN3ccc9CC10x10y5C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y5E[];
extern void _ZN3ccc9CC10x10y53pqrEv();
extern void _ZN3ccc9CC10x10y53abcEv();
extern void _ZN3ccc9CC10x10y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y53pqrEv,_ZTv0_n12_N3ccc9CC10x10y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y53pqrEv,_ZThn4_N3ccc9CC10x10y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y53abcEv,_ZTv0_n16_N3ccc9CC10x10y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y53abcEv,_ZThn4_N3ccc9CC10x10y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y53pqrEv,_ZTv0_n12_N3ccc9CC10x10y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y53abcEv,_ZTv0_n16_N3ccc9CC10x10y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y5E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y5E[] = {
  {&(_ZTVN3ccc9CC10x10y5E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y5E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y5E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y5E[];
static VTBL_ENTRY alt_thunk_names115[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y53abcEv,_ZTv0_n16_N3ccc9CC10x10y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y53abcEv,_ZThn4_N3ccc9CC10x10y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y53pqrEv,_ZTv0_n12_N3ccc9CC10x10y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y53pqrEv,_ZThn4_N3ccc9CC10x10y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y5E = {  "_ZN3ccc9CC10x10y5E", // class name
  bases__ZN3ccc9CC10x10y5E, 2,
  &(vtc__ZN3ccc9CC10x10y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y5E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names115,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y5  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9DD10x10y53pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x10y53efgEv
  virtual void  abc(); // _ZN3ccc9DD10x10y53abcEv
  ~DD10x10y5(); // tgen
  DD10x10y5(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y5E) C1{ VBC2{ v1 v3} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x10y5 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y53pqrEv");}
void  ccc::DD10x10y5 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y53efgEv");}
void  ccc::DD10x10y5 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y53abcEv");}
ccc::DD10x10y5 ::~DD10x10y5(){ note_dtor("_ZN3ccc9DD10x10y5E", this);} // tgen
ccc::DD10x10y5 ::DD10x10y5(){ note_ctor("_ZN3ccc9DD10x10y5E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y5E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y5E, buf);
    ::ccc::DD10x10y5 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y5E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y5E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y5E);
    dp->::ccc::DD10x10y5::~DD10x10y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y5E(Test__ZN3ccc9DD10x10y5E, "_ZN3ccc9DD10x10y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y5C1Ev();
extern void _ZN3ccc9DD10x10y5D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y5E[] = {
  NSPAIR(_ZN3ccc9DD10x10y5C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y5E[];
extern void _ZN3ccc9DD10x10y53pqrEv();
extern void _ZN3ccc9DD10x10y53abcEv();
extern void _ZN3ccc9DD10x10y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y53pqrEv,_ZTv0_n12_N3ccc9DD10x10y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y53pqrEv,_ZThn4_N3ccc9DD10x10y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y53abcEv,_ZTv0_n16_N3ccc9DD10x10y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y53abcEv,_ZThn4_N3ccc9DD10x10y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y53pqrEv,_ZTv0_n12_N3ccc9DD10x10y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y53abcEv,_ZTv0_n16_N3ccc9DD10x10y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y5E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y5E[] = {
  {&(_ZTVN3ccc9DD10x10y5E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y5E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y5E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y5E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y5E[];
static VTBL_ENTRY alt_thunk_names116[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y53abcEv,_ZTv0_n16_N3ccc9DD10x10y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y53abcEv,_ZThn4_N3ccc9DD10x10y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y53pqrEv,_ZTv0_n12_N3ccc9DD10x10y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y53pqrEv,_ZThn4_N3ccc9DD10x10y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y5E = {  "_ZN3ccc9DD10x10y5E", // class name
  bases__ZN3ccc9DD10x10y5E, 2,
  &(vtc__ZN3ccc9DD10x10y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y5E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names116,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y6  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9CC10x10y63abcEv
  virtual void  efg(); // _ZN3ccc9CC10x10y63efgEv
  ~CC10x10y6(); // tgen
  CC10x10y6(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y6E) C1{ VBC2{ v3 v1} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x10y6 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y63abcEv");}
void  ccc::CC10x10y6 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y63efgEv");}
ccc::CC10x10y6 ::~CC10x10y6(){ note_dtor("_ZN3ccc9CC10x10y6E", this);} // tgen
ccc::CC10x10y6 ::CC10x10y6(){ note_ctor("_ZN3ccc9CC10x10y6E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y6E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y6E, buf);
    ::ccc::CC10x10y6 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y6E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y6E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y6E);
    dp->::ccc::CC10x10y6::~CC10x10y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y6E(Test__ZN3ccc9CC10x10y6E, "_ZN3ccc9CC10x10y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y6C1Ev();
extern void _ZN3ccc9CC10x10y6D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y6E[] = {
  NSPAIR(_ZN3ccc9CC10x10y6C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y6E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc9CC10x10y63abcEv();
extern void _ZN3ccc9CC10x10y63efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y63abcEv,_ZTv0_n16_N3ccc9CC10x10y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y63abcEv,_ZThn4_N3ccc9CC10x10y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y63efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y63abcEv,_ZTv0_n16_N3ccc9CC10x10y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y6E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y6E[] = {
  {&(_ZTVN3ccc9CC10x10y6E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y6E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y6E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y6E[];
static VTBL_ENTRY alt_thunk_names117[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y63abcEv,_ZTv0_n16_N3ccc9CC10x10y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y63abcEv,_ZThn4_N3ccc9CC10x10y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y6E = {  "_ZN3ccc9CC10x10y6E", // class name
  bases__ZN3ccc9CC10x10y6E, 2,
  &(vtc__ZN3ccc9CC10x10y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y6E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names117,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y6  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9DD10x10y63abcEv
  virtual void  efg(); // _ZN3ccc9DD10x10y63efgEv
  ~DD10x10y6(); // tgen
  DD10x10y6(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y6E) C1{ VBC2{ v3 v1} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x10y6 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y63abcEv");}
void  ccc::DD10x10y6 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y63efgEv");}
ccc::DD10x10y6 ::~DD10x10y6(){ note_dtor("_ZN3ccc9DD10x10y6E", this);} // tgen
ccc::DD10x10y6 ::DD10x10y6(){ note_ctor("_ZN3ccc9DD10x10y6E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y6E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y6E, buf);
    ::ccc::DD10x10y6 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y6E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y6E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y6E);
    dp->::ccc::DD10x10y6::~DD10x10y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y6E(Test__ZN3ccc9DD10x10y6E, "_ZN3ccc9DD10x10y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y6C1Ev();
extern void _ZN3ccc9DD10x10y6D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y6E[] = {
  NSPAIR(_ZN3ccc9DD10x10y6C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x10y63abcEv();
extern void _ZN3ccc9DD10x10y63efgEv();
extern void _ZN3ccc4BB103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y63abcEv,_ZTv0_n16_N3ccc9DD10x10y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y63abcEv,_ZThn4_N3ccc9DD10x10y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y63efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y63abcEv,_ZTv0_n16_N3ccc9DD10x10y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y6E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y6E[] = {
  {&(_ZTVN3ccc9DD10x10y6E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y6E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y6E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y6E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y6E[];
static VTBL_ENTRY alt_thunk_names118[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y63abcEv,_ZTv0_n16_N3ccc9DD10x10y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y63abcEv,_ZThn4_N3ccc9DD10x10y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y6E = {  "_ZN3ccc9DD10x10y6E", // class name
  bases__ZN3ccc9DD10x10y6E, 2,
  &(vtc__ZN3ccc9DD10x10y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y6E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names118,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y7  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9CC10x10y73abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x10y73pqrEv
  ~CC10x10y7(); // tgen
  CC10x10y7(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y7E) C1{ VBC2{ v2 v1} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x10y7 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y73abcEv");}
void  ccc::CC10x10y7 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y73pqrEv");}
ccc::CC10x10y7 ::~CC10x10y7(){ note_dtor("_ZN3ccc9CC10x10y7E", this);} // tgen
ccc::CC10x10y7 ::CC10x10y7(){ note_ctor("_ZN3ccc9CC10x10y7E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y7E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y7E, buf);
    ::ccc::CC10x10y7 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y7E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y7E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y7E);
    dp->::ccc::CC10x10y7::~CC10x10y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y7E(Test__ZN3ccc9CC10x10y7E, "_ZN3ccc9CC10x10y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y7C1Ev();
extern void _ZN3ccc9CC10x10y7D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y7E[] = {
  NSPAIR(_ZN3ccc9CC10x10y7C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y7E[];
extern void _ZN3ccc9CC10x10y73pqrEv();
extern void _ZN3ccc9CC10x10y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y73pqrEv,_ZTv0_n12_N3ccc9CC10x10y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y73pqrEv,_ZThn4_N3ccc9CC10x10y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y73abcEv,_ZTv0_n16_N3ccc9CC10x10y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y73abcEv,_ZThn4_N3ccc9CC10x10y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y73pqrEv,_ZTv0_n12_N3ccc9CC10x10y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y73abcEv,_ZTv0_n16_N3ccc9CC10x10y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y7E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y7E[] = {
  {&(_ZTVN3ccc9CC10x10y7E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x10y7E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y7E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y7E[];
static VTBL_ENTRY alt_thunk_names119[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y73abcEv,_ZTv0_n16_N3ccc9CC10x10y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y73abcEv,_ZThn4_N3ccc9CC10x10y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y73pqrEv,_ZTv0_n12_N3ccc9CC10x10y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y73pqrEv,_ZThn4_N3ccc9CC10x10y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y7E = {  "_ZN3ccc9CC10x10y7E", // class name
  bases__ZN3ccc9CC10x10y7E, 2,
  &(vtc__ZN3ccc9CC10x10y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y7E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names119,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y7  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9DD10x10y73abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x10y73pqrEv
  ~DD10x10y7(); // tgen
  DD10x10y7(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y7E) C1{ VBC2{ v2 v1} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x10y7 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y73abcEv");}
void  ccc::DD10x10y7 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y73pqrEv");}
ccc::DD10x10y7 ::~DD10x10y7(){ note_dtor("_ZN3ccc9DD10x10y7E", this);} // tgen
ccc::DD10x10y7 ::DD10x10y7(){ note_ctor("_ZN3ccc9DD10x10y7E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y7E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y7E, buf);
    ::ccc::DD10x10y7 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y7E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y7E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y7E);
    dp->::ccc::DD10x10y7::~DD10x10y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y7E(Test__ZN3ccc9DD10x10y7E, "_ZN3ccc9DD10x10y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y7C1Ev();
extern void _ZN3ccc9DD10x10y7D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y7E[] = {
  NSPAIR(_ZN3ccc9DD10x10y7C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y7E[];
extern void _ZN3ccc9DD10x10y73pqrEv();
extern void _ZN3ccc9DD10x10y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y73pqrEv,_ZTv0_n12_N3ccc9DD10x10y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y73pqrEv,_ZThn4_N3ccc9DD10x10y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y73abcEv,_ZTv0_n16_N3ccc9DD10x10y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y73abcEv,_ZThn4_N3ccc9DD10x10y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y73pqrEv,_ZTv0_n12_N3ccc9DD10x10y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y73abcEv,_ZTv0_n16_N3ccc9DD10x10y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y7E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y7E[] = {
  {&(_ZTVN3ccc9DD10x10y7E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x10y7E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x10y7E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y7E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y7E[];
static VTBL_ENTRY alt_thunk_names120[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y73abcEv,_ZTv0_n16_N3ccc9DD10x10y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y73abcEv,_ZThn4_N3ccc9DD10x10y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y73pqrEv,_ZTv0_n12_N3ccc9DD10x10y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y73pqrEv,_ZThn4_N3ccc9DD10x10y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y7E = {  "_ZN3ccc9DD10x10y7E", // class name
  bases__ZN3ccc9DD10x10y7E, 2,
  &(vtc__ZN3ccc9DD10x10y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y7E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names120,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y8  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9CC10x10y83efgEv
  virtual void  abc(); // _ZN3ccc9CC10x10y83abcEv
  ~CC10x10y8(); // tgen
  CC10x10y8(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y8E) C1{ VBC2{ v3 v2} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x10y8 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y83efgEv");}
void  ccc::CC10x10y8 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x10y83abcEv");}
ccc::CC10x10y8 ::~CC10x10y8(){ note_dtor("_ZN3ccc9CC10x10y8E", this);} // tgen
ccc::CC10x10y8 ::CC10x10y8(){ note_ctor("_ZN3ccc9CC10x10y8E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y8E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y8E, buf);
    ::ccc::CC10x10y8 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y8E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y8E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y8E);
    dp->::ccc::CC10x10y8::~CC10x10y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y8E(Test__ZN3ccc9CC10x10y8E, "_ZN3ccc9CC10x10y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y8C1Ev();
extern void _ZN3ccc9CC10x10y8D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y8E[] = {
  NSPAIR(_ZN3ccc9CC10x10y8C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y8E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc9CC10x10y83abcEv();
extern void _ZN3ccc9CC10x10y83efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x10y83abcEv,_ZTv0_n16_N3ccc9CC10x10y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y83abcEv,_ZThn4_N3ccc9CC10x10y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y83efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x10y83abcEv,_ZTv0_n16_N3ccc9CC10x10y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y8E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y8E[] = {
  {&(_ZTVN3ccc9CC10x10y8E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y8E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y8E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y8E[];
static VTBL_ENTRY alt_thunk_names121[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x10y83abcEv,_ZTv0_n16_N3ccc9CC10x10y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y83abcEv,_ZThn4_N3ccc9CC10x10y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y8E = {  "_ZN3ccc9CC10x10y8E", // class name
  bases__ZN3ccc9CC10x10y8E, 2,
  &(vtc__ZN3ccc9CC10x10y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y8E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names121,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y8  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9DD10x10y83efgEv
  virtual void  abc(); // _ZN3ccc9DD10x10y83abcEv
  ~DD10x10y8(); // tgen
  DD10x10y8(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y8E) C1{ VBC2{ v3 v2} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x10y8 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y83efgEv");}
void  ccc::DD10x10y8 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x10y83abcEv");}
ccc::DD10x10y8 ::~DD10x10y8(){ note_dtor("_ZN3ccc9DD10x10y8E", this);} // tgen
ccc::DD10x10y8 ::DD10x10y8(){ note_ctor("_ZN3ccc9DD10x10y8E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y8E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y8E, buf);
    ::ccc::DD10x10y8 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y8E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y8E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y8E);
    dp->::ccc::DD10x10y8::~DD10x10y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y8E(Test__ZN3ccc9DD10x10y8E, "_ZN3ccc9DD10x10y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y8C1Ev();
extern void _ZN3ccc9DD10x10y8D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y8E[] = {
  NSPAIR(_ZN3ccc9DD10x10y8C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x10y83abcEv();
extern void _ZN3ccc9DD10x10y83efgEv();
extern void _ZN3ccc4BB103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x10y83abcEv,_ZTv0_n16_N3ccc9DD10x10y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y83abcEv,_ZThn4_N3ccc9DD10x10y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y83efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x10y83abcEv,_ZTv0_n16_N3ccc9DD10x10y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y8E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y8E[] = {
  {&(_ZTVN3ccc9DD10x10y8E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y8E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y8E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y8E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y8E[];
static VTBL_ENTRY alt_thunk_names122[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x10y83abcEv,_ZTv0_n16_N3ccc9DD10x10y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y83abcEv,_ZThn4_N3ccc9DD10x10y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y8E = {  "_ZN3ccc9DD10x10y8E", // class name
  bases__ZN3ccc9DD10x10y8E, 2,
  &(vtc__ZN3ccc9DD10x10y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y8E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names122,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y9  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9CC10x10y93efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x10y93pqrEv
  ~CC10x10y9(); // tgen
  CC10x10y9(); // tgen
};
//SIG(1 _ZN3ccc9CC10x10y9E) C1{ VBC2{ v2 v3} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x10y9 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x10y93efgEv");}
void  ccc::CC10x10y9 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x10y93pqrEv");}
ccc::CC10x10y9 ::~CC10x10y9(){ note_dtor("_ZN3ccc9CC10x10y9E", this);} // tgen
ccc::CC10x10y9 ::CC10x10y9(){ note_ctor("_ZN3ccc9CC10x10y9E", this);} // tgen
}
static void Test__ZN3ccc9CC10x10y9E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x10y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x10y9E, buf);
    ::ccc::CC10x10y9 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x10y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x10y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x10y9E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc9CC10x10y9E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x10y9E);
    dp->::ccc::CC10x10y9::~CC10x10y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x10y9E(Test__ZN3ccc9CC10x10y9E, "_ZN3ccc9CC10x10y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x10y9C1Ev();
extern void _ZN3ccc9CC10x10y9D1Ev();
Name_Map name_map__ZN3ccc9CC10x10y9E[] = {
  NSPAIR(_ZN3ccc9CC10x10y9C1Ev),
  NSPAIR(_ZN3ccc9CC10x10y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC10x10y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y9E[];
extern void _ZN3ccc9CC10x10y93pqrEv();
extern void _ZN3ccc4BB103abcEv();
extern void _ZN3ccc9CC10x10y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x10y93pqrEv,_ZTv0_n12_N3ccc9CC10x10y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x10y93pqrEv,_ZThn4_N3ccc9CC10x10y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x10y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x10y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x10y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x10y93pqrEv,_ZTv0_n12_N3ccc9CC10x10y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x10y9E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x10y9E[] = {
  {&(_ZTVN3ccc9CC10x10y9E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x10y9E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x10y9E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x10y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x10y9E[];
static VTBL_ENTRY alt_thunk_names123[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x10y93pqrEv,_ZTv0_n12_N3ccc9CC10x10y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x10y93pqrEv,_ZThn4_N3ccc9CC10x10y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x10y9E = {  "_ZN3ccc9CC10x10y9E", // class name
  bases__ZN3ccc9CC10x10y9E, 2,
  &(vtc__ZN3ccc9CC10x10y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x10y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x10y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x10y9E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x10y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names123,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y9  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9DD10x10y93efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x10y93pqrEv
  ~DD10x10y9(); // tgen
  DD10x10y9(); // tgen
};
//SIG(1 _ZN3ccc9DD10x10y9E) C1{ VBC2{ v2 v3} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x10y9 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x10y93efgEv");}
void  ccc::DD10x10y9 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x10y93pqrEv");}
ccc::DD10x10y9 ::~DD10x10y9(){ note_dtor("_ZN3ccc9DD10x10y9E", this);} // tgen
ccc::DD10x10y9 ::DD10x10y9(){ note_ctor("_ZN3ccc9DD10x10y9E", this);} // tgen
}
static void Test__ZN3ccc9DD10x10y9E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x10y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x10y9E, buf);
    ::ccc::DD10x10y9 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x10y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x10y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x10y9E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9DD10x10y9E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x10y9E);
    dp->::ccc::DD10x10y9::~DD10x10y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x10y9E(Test__ZN3ccc9DD10x10y9E, "_ZN3ccc9DD10x10y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x10y9C1Ev();
extern void _ZN3ccc9DD10x10y9D1Ev();
Name_Map name_map__ZN3ccc9DD10x10y9E[] = {
  NSPAIR(_ZN3ccc9DD10x10y9C1Ev),
  NSPAIR(_ZN3ccc9DD10x10y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9DD10x10y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y9E[];
extern void _ZN3ccc9DD10x10y93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x10y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x10y93pqrEv,_ZTv0_n12_N3ccc9DD10x10y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x10y93pqrEv,_ZThn4_N3ccc9DD10x10y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x10y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x10y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x10y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x10y93pqrEv,_ZTv0_n12_N3ccc9DD10x10y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x10y9E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x10y9E[] = {
  {&(_ZTVN3ccc9DD10x10y9E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y9E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x10y9E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x10y9E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x10y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x10y9E[];
static VTBL_ENTRY alt_thunk_names124[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x10y93pqrEv,_ZTv0_n12_N3ccc9DD10x10y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x10y93pqrEv,_ZThn4_N3ccc9DD10x10y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x10y9E = {  "_ZN3ccc9DD10x10y9E", // class name
  bases__ZN3ccc9DD10x10y9E, 2,
  &(vtc__ZN3ccc9DD10x10y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x10y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x10y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x10y9E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x10y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names124,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y10  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc10CC10x10y103pqrEv
  virtual void  abc(); // _ZN3ccc10CC10x10y103abcEv
  ~CC10x10y10(); // tgen
  CC10x10y10(); // tgen
};
//SIG(1 _ZN3ccc10CC10x10y10E) C1{ VBC2{ v1 v2} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x10y10 ::pqr(){vfunc_called(this, "_ZN3ccc10CC10x10y103pqrEv");}
void  ccc::CC10x10y10 ::abc(){vfunc_called(this, "_ZN3ccc10CC10x10y103abcEv");}
ccc::CC10x10y10 ::~CC10x10y10(){ note_dtor("_ZN3ccc10CC10x10y10E", this);} // tgen
ccc::CC10x10y10 ::CC10x10y10(){ note_ctor("_ZN3ccc10CC10x10y10E", this);} // tgen
}
static void Test__ZN3ccc10CC10x10y10E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x10y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x10y10E, buf);
    ::ccc::CC10x10y10 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x10y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x10y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x10y10E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc10CC10x10y10E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x10y10E);
    dp->::ccc::CC10x10y10::~CC10x10y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x10y10E(Test__ZN3ccc10CC10x10y10E, "_ZN3ccc10CC10x10y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x10y10C1Ev();
extern void _ZN3ccc10CC10x10y10D1Ev();
Name_Map name_map__ZN3ccc10CC10x10y10E[] = {
  NSPAIR(_ZN3ccc10CC10x10y10C1Ev),
  NSPAIR(_ZN3ccc10CC10x10y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10CC10x10y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y10E[];
extern void _ZN3ccc10CC10x10y103pqrEv();
extern void _ZN3ccc10CC10x10y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10CC10x10y103pqrEv,_ZTv0_n12_N3ccc10CC10x10y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x10y103pqrEv,_ZThn4_N3ccc10CC10x10y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc10CC10x10y103abcEv,_ZTv0_n16_N3ccc10CC10x10y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x10y103abcEv,_ZThn4_N3ccc10CC10x10y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10CC10x10y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10CC10x10y103pqrEv,_ZTv0_n12_N3ccc10CC10x10y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10CC10x10y103abcEv,_ZTv0_n16_N3ccc10CC10x10y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x10y10E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x10y10E[] = {
  {&(_ZTVN3ccc10CC10x10y10E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x10y10E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y10E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x10y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x10y10E[];
static VTBL_ENTRY alt_thunk_names125[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10CC10x10y103abcEv,_ZTv0_n16_N3ccc10CC10x10y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x10y103abcEv,_ZThn4_N3ccc10CC10x10y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10CC10x10y103pqrEv,_ZTv0_n12_N3ccc10CC10x10y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x10y103pqrEv,_ZThn4_N3ccc10CC10x10y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x10y10E = {  "_ZN3ccc10CC10x10y10E", // class name
  bases__ZN3ccc10CC10x10y10E, 2,
  &(vtc__ZN3ccc10CC10x10y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x10y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x10y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x10y10E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x10y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names125,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y10  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc10DD10x10y103pqrEv
  virtual void  abc(); // _ZN3ccc10DD10x10y103abcEv
  ~DD10x10y10(); // tgen
  DD10x10y10(); // tgen
};
//SIG(1 _ZN3ccc10DD10x10y10E) C1{ VBC2{ v1 v2} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x10y10 ::pqr(){vfunc_called(this, "_ZN3ccc10DD10x10y103pqrEv");}
void  ccc::DD10x10y10 ::abc(){vfunc_called(this, "_ZN3ccc10DD10x10y103abcEv");}
ccc::DD10x10y10 ::~DD10x10y10(){ note_dtor("_ZN3ccc10DD10x10y10E", this);} // tgen
ccc::DD10x10y10 ::DD10x10y10(){ note_ctor("_ZN3ccc10DD10x10y10E", this);} // tgen
}
static void Test__ZN3ccc10DD10x10y10E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x10y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x10y10E, buf);
    ::ccc::DD10x10y10 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x10y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x10y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x10y10E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc10DD10x10y10E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x10y10E);
    dp->::ccc::DD10x10y10::~DD10x10y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x10y10E(Test__ZN3ccc10DD10x10y10E, "_ZN3ccc10DD10x10y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x10y10C1Ev();
extern void _ZN3ccc10DD10x10y10D1Ev();
Name_Map name_map__ZN3ccc10DD10x10y10E[] = {
  NSPAIR(_ZN3ccc10DD10x10y10C1Ev),
  NSPAIR(_ZN3ccc10DD10x10y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10DD10x10y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y10E[];
extern void _ZN3ccc10DD10x10y103pqrEv();
extern void _ZN3ccc10DD10x10y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10DD10x10y103pqrEv,_ZTv0_n12_N3ccc10DD10x10y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x10y103pqrEv,_ZThn4_N3ccc10DD10x10y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc10DD10x10y103abcEv,_ZTv0_n16_N3ccc10DD10x10y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x10y103abcEv,_ZThn4_N3ccc10DD10x10y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10DD10x10y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10DD10x10y103pqrEv,_ZTv0_n12_N3ccc10DD10x10y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10DD10x10y103abcEv,_ZTv0_n16_N3ccc10DD10x10y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x10y10E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x10y10E[] = {
  {&(_ZTVN3ccc10DD10x10y10E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y10E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y10E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y10E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x10y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x10y10E[];
static VTBL_ENTRY alt_thunk_names126[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10DD10x10y103abcEv,_ZTv0_n16_N3ccc10DD10x10y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x10y103abcEv,_ZThn4_N3ccc10DD10x10y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10DD10x10y103pqrEv,_ZTv0_n12_N3ccc10DD10x10y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x10y103pqrEv,_ZThn4_N3ccc10DD10x10y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x10y10E = {  "_ZN3ccc10DD10x10y10E", // class name
  bases__ZN3ccc10DD10x10y10E, 2,
  &(vtc__ZN3ccc10DD10x10y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x10y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x10y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x10y10E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x10y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names126,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y11  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc10CC10x10y113pqrEv
  virtual void  efg(); // _ZN3ccc10CC10x10y113efgEv
  ~CC10x10y11(); // tgen
  CC10x10y11(); // tgen
};
//SIG(1 _ZN3ccc10CC10x10y11E) C1{ VBC2{ v1 v3} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC10x10y11 ::pqr(){vfunc_called(this, "_ZN3ccc10CC10x10y113pqrEv");}
void  ccc::CC10x10y11 ::efg(){vfunc_called(this, "_ZN3ccc10CC10x10y113efgEv");}
ccc::CC10x10y11 ::~CC10x10y11(){ note_dtor("_ZN3ccc10CC10x10y11E", this);} // tgen
ccc::CC10x10y11 ::CC10x10y11(){ note_ctor("_ZN3ccc10CC10x10y11E", this);} // tgen
}
static void Test__ZN3ccc10CC10x10y11E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x10y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x10y11E, buf);
    ::ccc::CC10x10y11 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x10y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x10y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x10y11E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc10CC10x10y11E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x10y11E);
    dp->::ccc::CC10x10y11::~CC10x10y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x10y11E(Test__ZN3ccc10CC10x10y11E, "_ZN3ccc10CC10x10y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x10y11C1Ev();
extern void _ZN3ccc10CC10x10y11D1Ev();
Name_Map name_map__ZN3ccc10CC10x10y11E[] = {
  NSPAIR(_ZN3ccc10CC10x10y11C1Ev),
  NSPAIR(_ZN3ccc10CC10x10y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10CC10x10y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y11E[];
extern void _ZN3ccc10CC10x10y113pqrEv();
extern void _ZN3ccc4BB103abcEv();
extern void _ZN3ccc10CC10x10y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10CC10x10y113pqrEv,_ZTv0_n12_N3ccc10CC10x10y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x10y113pqrEv,_ZThn4_N3ccc10CC10x10y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x10y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10CC10x10y113pqrEv,_ZTv0_n12_N3ccc10CC10x10y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x10y11E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x10y11E[] = {
  {&(_ZTVN3ccc10CC10x10y11E[3]),  3,12},
  {&(_ZTVN3ccc10CC10x10y11E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y11E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x10y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x10y11E[];
static VTBL_ENTRY alt_thunk_names127[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10CC10x10y113pqrEv,_ZTv0_n12_N3ccc10CC10x10y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x10y113pqrEv,_ZThn4_N3ccc10CC10x10y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x10y11E = {  "_ZN3ccc10CC10x10y11E", // class name
  bases__ZN3ccc10CC10x10y11E, 2,
  &(vtc__ZN3ccc10CC10x10y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x10y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x10y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x10y11E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x10y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names127,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y11  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc10DD10x10y113pqrEv
  virtual void  efg(); // _ZN3ccc10DD10x10y113efgEv
  ~DD10x10y11(); // tgen
  DD10x10y11(); // tgen
};
//SIG(1 _ZN3ccc10DD10x10y11E) C1{ VBC2{ v1 v3} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD10x10y11 ::pqr(){vfunc_called(this, "_ZN3ccc10DD10x10y113pqrEv");}
void  ccc::DD10x10y11 ::efg(){vfunc_called(this, "_ZN3ccc10DD10x10y113efgEv");}
ccc::DD10x10y11 ::~DD10x10y11(){ note_dtor("_ZN3ccc10DD10x10y11E", this);} // tgen
ccc::DD10x10y11 ::DD10x10y11(){ note_ctor("_ZN3ccc10DD10x10y11E", this);} // tgen
}
static void Test__ZN3ccc10DD10x10y11E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x10y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x10y11E, buf);
    ::ccc::DD10x10y11 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x10y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x10y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x10y11E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc10DD10x10y11E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x10y11E);
    dp->::ccc::DD10x10y11::~DD10x10y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x10y11E(Test__ZN3ccc10DD10x10y11E, "_ZN3ccc10DD10x10y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x10y11C1Ev();
extern void _ZN3ccc10DD10x10y11D1Ev();
Name_Map name_map__ZN3ccc10DD10x10y11E[] = {
  NSPAIR(_ZN3ccc10DD10x10y11C1Ev),
  NSPAIR(_ZN3ccc10DD10x10y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10DD10x10y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y11E[];
extern void _ZN3ccc10DD10x10y113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc10DD10x10y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10DD10x10y113pqrEv,_ZTv0_n12_N3ccc10DD10x10y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x10y113pqrEv,_ZThn4_N3ccc10DD10x10y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x10y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10DD10x10y113pqrEv,_ZTv0_n12_N3ccc10DD10x10y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x10y11E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x10y11E[] = {
  {&(_ZTVN3ccc10DD10x10y11E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x10y11E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x10y11E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y11E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x10y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x10y11E[];
static VTBL_ENTRY alt_thunk_names128[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10DD10x10y113pqrEv,_ZTv0_n12_N3ccc10DD10x10y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x10y113pqrEv,_ZThn4_N3ccc10DD10x10y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x10y11E = {  "_ZN3ccc10DD10x10y11E", // class name
  bases__ZN3ccc10DD10x10y11E, 2,
  &(vtc__ZN3ccc10DD10x10y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x10y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x10y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x10y11E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x10y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names128,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y12  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc10CC10x10y123abcEv
  ~CC10x10y12(); // tgen
  CC10x10y12(); // tgen
};
//SIG(1 _ZN3ccc10CC10x10y12E) C1{ VBC2{ v2 v1} BC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::CC10x10y12 ::abc(){vfunc_called(this, "_ZN3ccc10CC10x10y123abcEv");}
ccc::CC10x10y12 ::~CC10x10y12(){ note_dtor("_ZN3ccc10CC10x10y12E", this);} // tgen
ccc::CC10x10y12 ::CC10x10y12(){ note_ctor("_ZN3ccc10CC10x10y12E", this);} // tgen
}
static void Test__ZN3ccc10CC10x10y12E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x10y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x10y12E, buf);
    ::ccc::CC10x10y12 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x10y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x10y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x10y12E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc10CC10x10y12E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x10y12E);
    dp->::ccc::CC10x10y12::~CC10x10y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x10y12E(Test__ZN3ccc10CC10x10y12E, "_ZN3ccc10CC10x10y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x10y12C1Ev();
extern void _ZN3ccc10CC10x10y12D1Ev();
Name_Map name_map__ZN3ccc10CC10x10y12E[] = {
  NSPAIR(_ZN3ccc10CC10x10y12C1Ev),
  NSPAIR(_ZN3ccc10CC10x10y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10CC10x10y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y12E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc10CC10x10y123abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc10CC10x10y123abcEv,_ZTv0_n16_N3ccc10CC10x10y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x10y123abcEv,_ZThn4_N3ccc10CC10x10y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10CC10x10y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y123abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10CC10x10y123abcEv,_ZTv0_n16_N3ccc10CC10x10y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x10y12E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x10y12E[] = {
  {&(_ZTVN3ccc10CC10x10y12E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x10y12E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y12E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x10y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x10y12E[];
static VTBL_ENTRY alt_thunk_names129[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10CC10x10y123abcEv,_ZTv0_n16_N3ccc10CC10x10y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x10y123abcEv,_ZThn4_N3ccc10CC10x10y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x10y12E = {  "_ZN3ccc10CC10x10y12E", // class name
  bases__ZN3ccc10CC10x10y12E, 2,
  &(vtc__ZN3ccc10CC10x10y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x10y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x10y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x10y12E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x10y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names129,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y12  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc10DD10x10y123abcEv
  ~DD10x10y12(); // tgen
  DD10x10y12(); // tgen
};
//SIG(1 _ZN3ccc10DD10x10y12E) C1{ VBC2{ v2 v1} VBC3{ v3 v1} v1}
}
namespace ccc { 
void  ccc::DD10x10y12 ::abc(){vfunc_called(this, "_ZN3ccc10DD10x10y123abcEv");}
ccc::DD10x10y12 ::~DD10x10y12(){ note_dtor("_ZN3ccc10DD10x10y12E", this);} // tgen
ccc::DD10x10y12 ::DD10x10y12(){ note_ctor("_ZN3ccc10DD10x10y12E", this);} // tgen
}
static void Test__ZN3ccc10DD10x10y12E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x10y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x10y12E, buf);
    ::ccc::DD10x10y12 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x10y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x10y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x10y12E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc10DD10x10y12E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x10y12E);
    dp->::ccc::DD10x10y12::~DD10x10y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x10y12E(Test__ZN3ccc10DD10x10y12E, "_ZN3ccc10DD10x10y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x10y12C1Ev();
extern void _ZN3ccc10DD10x10y12D1Ev();
Name_Map name_map__ZN3ccc10DD10x10y12E[] = {
  NSPAIR(_ZN3ccc10DD10x10y12C1Ev),
  NSPAIR(_ZN3ccc10DD10x10y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10DD10x10y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc10DD10x10y123abcEv();
extern void _ZN3ccc4BB103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc10DD10x10y123abcEv,_ZTv0_n16_N3ccc10DD10x10y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x10y123abcEv,_ZThn4_N3ccc10DD10x10y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10DD10x10y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y123abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10DD10x10y123abcEv,_ZTv0_n16_N3ccc10DD10x10y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x10y12E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x10y12E[] = {
  {&(_ZTVN3ccc10DD10x10y12E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y12E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y12E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y12E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x10y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x10y12E[];
static VTBL_ENTRY alt_thunk_names130[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10DD10x10y123abcEv,_ZTv0_n16_N3ccc10DD10x10y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x10y123abcEv,_ZThn4_N3ccc10DD10x10y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x10y12E = {  "_ZN3ccc10DD10x10y12E", // class name
  bases__ZN3ccc10DD10x10y12E, 2,
  &(vtc__ZN3ccc10DD10x10y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x10y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x10y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x10y12E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x10y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names130,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y13  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc10CC10x10y133efgEv
  ~CC10x10y13(); // tgen
  CC10x10y13(); // tgen
};
//SIG(1 _ZN3ccc10CC10x10y13E) C1{ VBC2{ v2 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC10x10y13 ::efg(){vfunc_called(this, "_ZN3ccc10CC10x10y133efgEv");}
ccc::CC10x10y13 ::~CC10x10y13(){ note_dtor("_ZN3ccc10CC10x10y13E", this);} // tgen
ccc::CC10x10y13 ::CC10x10y13(){ note_ctor("_ZN3ccc10CC10x10y13E", this);} // tgen
}
static void Test__ZN3ccc10CC10x10y13E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x10y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x10y13E, buf);
    ::ccc::CC10x10y13 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x10y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x10y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x10y13E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc10CC10x10y13E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x10y13E);
    dp->::ccc::CC10x10y13::~CC10x10y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x10y13E(Test__ZN3ccc10CC10x10y13E, "_ZN3ccc10CC10x10y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x10y13C1Ev();
extern void _ZN3ccc10CC10x10y13D1Ev();
Name_Map name_map__ZN3ccc10CC10x10y13E[] = {
  NSPAIR(_ZN3ccc10CC10x10y13C1Ev),
  NSPAIR(_ZN3ccc10CC10x10y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10CC10x10y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y13E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
extern void _ZN3ccc10CC10x10y133efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x10y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y133efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x10y13E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x10y13E[] = {
  {&(_ZTVN3ccc10CC10x10y13E[3]),  3,12},
  {&(_ZTVN3ccc10CC10x10y13E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y13E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x10y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x10y13E[];
Class_Descriptor cd__ZN3ccc10CC10x10y13E = {  "_ZN3ccc10CC10x10y13E", // class name
  bases__ZN3ccc10CC10x10y13E, 2,
  &(vtc__ZN3ccc10CC10x10y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x10y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x10y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x10y13E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x10y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y13  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc10DD10x10y133efgEv
  ~DD10x10y13(); // tgen
  DD10x10y13(); // tgen
};
//SIG(1 _ZN3ccc10DD10x10y13E) C1{ VBC2{ v2 v3} VBC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::DD10x10y13 ::efg(){vfunc_called(this, "_ZN3ccc10DD10x10y133efgEv");}
ccc::DD10x10y13 ::~DD10x10y13(){ note_dtor("_ZN3ccc10DD10x10y13E", this);} // tgen
ccc::DD10x10y13 ::DD10x10y13(){ note_ctor("_ZN3ccc10DD10x10y13E", this);} // tgen
}
static void Test__ZN3ccc10DD10x10y13E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x10y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x10y13E, buf);
    ::ccc::DD10x10y13 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x10y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x10y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x10y13E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc10DD10x10y13E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x10y13E);
    dp->::ccc::DD10x10y13::~DD10x10y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x10y13E(Test__ZN3ccc10DD10x10y13E, "_ZN3ccc10DD10x10y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x10y13C1Ev();
extern void _ZN3ccc10DD10x10y13D1Ev();
Name_Map name_map__ZN3ccc10DD10x10y13E[] = {
  NSPAIR(_ZN3ccc10DD10x10y13C1Ev),
  NSPAIR(_ZN3ccc10DD10x10y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10DD10x10y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc10DD10x10y133efgEv();
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x10y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y133efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x10y13E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x10y13E[] = {
  {&(_ZTVN3ccc10DD10x10y13E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x10y13E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x10y13E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y13E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x10y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x10y13E[];
Class_Descriptor cd__ZN3ccc10DD10x10y13E = {  "_ZN3ccc10DD10x10y13E", // class name
  bases__ZN3ccc10DD10x10y13E, 2,
  &(vtc__ZN3ccc10DD10x10y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x10y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x10y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x10y13E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x10y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y14  : virtual ::ccc::AA10 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc10CC10x10y143pqrEv
  ~CC10x10y14(); // tgen
  CC10x10y14(); // tgen
};
//SIG(1 _ZN3ccc10CC10x10y14E) C1{ VBC2{ v1 v2} BC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::CC10x10y14 ::pqr(){vfunc_called(this, "_ZN3ccc10CC10x10y143pqrEv");}
ccc::CC10x10y14 ::~CC10x10y14(){ note_dtor("_ZN3ccc10CC10x10y14E", this);} // tgen
ccc::CC10x10y14 ::CC10x10y14(){ note_ctor("_ZN3ccc10CC10x10y14E", this);} // tgen
}
static void Test__ZN3ccc10CC10x10y14E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x10y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x10y14E, buf);
    ::ccc::CC10x10y14 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x10y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x10y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x10y14E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc10CC10x10y14E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x10y14E);
    dp->::ccc::CC10x10y14::~CC10x10y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x10y14E(Test__ZN3ccc10CC10x10y14E, "_ZN3ccc10CC10x10y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x10y14C1Ev();
extern void _ZN3ccc10CC10x10y14D1Ev();
Name_Map name_map__ZN3ccc10CC10x10y14E[] = {
  NSPAIR(_ZN3ccc10CC10x10y14C1Ev),
  NSPAIR(_ZN3ccc10CC10x10y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10CC10x10y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y14E[];
extern void _ZN3ccc10CC10x10y143pqrEv();
extern void _ZN3ccc4BB103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10CC10x10y143pqrEv,_ZTv0_n12_N3ccc10CC10x10y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x10y143pqrEv,_ZThn4_N3ccc10CC10x10y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x10y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc10CC10x10y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10CC10x10y143pqrEv,_ZTv0_n12_N3ccc10CC10x10y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x10y14E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x10y14E[] = {
  {&(_ZTVN3ccc10CC10x10y14E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x10y14E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y14E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x10y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x10y14E[];
static VTBL_ENTRY alt_thunk_names131[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10CC10x10y143pqrEv,_ZTv0_n12_N3ccc10CC10x10y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x10y143pqrEv,_ZThn4_N3ccc10CC10x10y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x10y14E = {  "_ZN3ccc10CC10x10y14E", // class name
  bases__ZN3ccc10CC10x10y14E, 2,
  &(vtc__ZN3ccc10CC10x10y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x10y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x10y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x10y14E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x10y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names131,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y14  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc10DD10x10y143pqrEv
  ~DD10x10y14(); // tgen
  DD10x10y14(); // tgen
};
//SIG(1 _ZN3ccc10DD10x10y14E) C1{ VBC2{ v1 v2} VBC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::DD10x10y14 ::pqr(){vfunc_called(this, "_ZN3ccc10DD10x10y143pqrEv");}
ccc::DD10x10y14 ::~DD10x10y14(){ note_dtor("_ZN3ccc10DD10x10y14E", this);} // tgen
ccc::DD10x10y14 ::DD10x10y14(){ note_ctor("_ZN3ccc10DD10x10y14E", this);} // tgen
}
static void Test__ZN3ccc10DD10x10y14E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x10y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x10y14E, buf);
    ::ccc::DD10x10y14 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x10y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x10y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x10y14E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc10DD10x10y14E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x10y14E);
    dp->::ccc::DD10x10y14::~DD10x10y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x10y14E(Test__ZN3ccc10DD10x10y14E, "_ZN3ccc10DD10x10y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x10y14C1Ev();
extern void _ZN3ccc10DD10x10y14D1Ev();
Name_Map name_map__ZN3ccc10DD10x10y14E[] = {
  NSPAIR(_ZN3ccc10DD10x10y14C1Ev),
  NSPAIR(_ZN3ccc10DD10x10y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10DD10x10y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y14E[];
extern void _ZN3ccc10DD10x10y143pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10DD10x10y143pqrEv,_ZTv0_n12_N3ccc10DD10x10y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x10y143pqrEv,_ZThn4_N3ccc10DD10x10y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x10y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc10DD10x10y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10DD10x10y143pqrEv,_ZTv0_n12_N3ccc10DD10x10y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x10y14E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x10y14E[] = {
  {&(_ZTVN3ccc10DD10x10y14E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y14E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y14E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y14E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x10y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x10y14E[];
static VTBL_ENTRY alt_thunk_names132[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10DD10x10y143pqrEv,_ZTv0_n12_N3ccc10DD10x10y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x10y143pqrEv,_ZThn4_N3ccc10DD10x10y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x10y14E = {  "_ZN3ccc10DD10x10y14E", // class name
  bases__ZN3ccc10DD10x10y14E, 2,
  &(vtc__ZN3ccc10DD10x10y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x10y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x10y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x10y14E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x10y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names132,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x10y15  : virtual ::ccc::AA10 , ::ccc::BB10 {
  ~CC10x10y15(); // tgen
  CC10x10y15(); // tgen
};
//SIG(1 _ZN3ccc10CC10x10y15E) C1{ VBC2{ v1 v2} BC3{ v3 v4}}
}
namespace ccc { 
ccc::CC10x10y15 ::~CC10x10y15(){ note_dtor("_ZN3ccc10CC10x10y15E", this);} // tgen
ccc::CC10x10y15 ::CC10x10y15(){ note_ctor("_ZN3ccc10CC10x10y15E", this);} // tgen
}
static void Test__ZN3ccc10CC10x10y15E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x10y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x10y15E, buf);
    ::ccc::CC10x10y15 *dp, &lv = *(dp=new (buf) ::ccc::CC10x10y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x10y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x10y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x10y15E");
    check_base_class_offset(lv, (::ccc::BB10*), 0, "_ZN3ccc10CC10x10y15E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x10y15E);
    dp->::ccc::CC10x10y15::~CC10x10y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x10y15E(Test__ZN3ccc10CC10x10y15E, "_ZN3ccc10CC10x10y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x10y15C1Ev();
extern void _ZN3ccc10CC10x10y15D1Ev();
Name_Map name_map__ZN3ccc10CC10x10y15E[] = {
  NSPAIR(_ZN3ccc10CC10x10y15C1Ev),
  NSPAIR(_ZN3ccc10CC10x10y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10CC10x10y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y15E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x10y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x10y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x10y15E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x10y15E[] = {
  {&(_ZTVN3ccc10CC10x10y15E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x10y15E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x10y15E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x10y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x10y15E[];
Class_Descriptor cd__ZN3ccc10CC10x10y15E = {  "_ZN3ccc10CC10x10y15E", // class name
  bases__ZN3ccc10CC10x10y15E, 2,
  &(vtc__ZN3ccc10CC10x10y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x10y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x10y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x10y15E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x10y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x10y15  : virtual ::ccc::AA10 , virtual ::ccc::BB10 {
  ~DD10x10y15(); // tgen
  DD10x10y15(); // tgen
};
//SIG(1 _ZN3ccc10DD10x10y15E) C1{ VBC2{ v1 v2} VBC3{ v3 v4}}
}
namespace ccc { 
ccc::DD10x10y15 ::~DD10x10y15(){ note_dtor("_ZN3ccc10DD10x10y15E", this);} // tgen
ccc::DD10x10y15 ::DD10x10y15(){ note_ctor("_ZN3ccc10DD10x10y15E", this);} // tgen
}
static void Test__ZN3ccc10DD10x10y15E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x10y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x10y15E, buf);
    ::ccc::DD10x10y15 *dp, &lv = *(dp=new (buf) ::ccc::DD10x10y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x10y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x10y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x10y15E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc10DD10x10y15E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x10y15E);
    dp->::ccc::DD10x10y15::~DD10x10y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x10y15E(Test__ZN3ccc10DD10x10y15E, "_ZN3ccc10DD10x10y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x10y15C1Ev();
extern void _ZN3ccc10DD10x10y15D1Ev();
Name_Map name_map__ZN3ccc10DD10x10y15E[] = {
  NSPAIR(_ZN3ccc10DD10x10y15C1Ev),
  NSPAIR(_ZN3ccc10DD10x10y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc10DD10x10y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x10y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x10y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x10y15E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x10y15E[] = {
  {&(_ZTVN3ccc10DD10x10y15E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y15E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x10y15E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x10y15E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x10y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x10y15E[];
Class_Descriptor cd__ZN3ccc10DD10x10y15E = {  "_ZN3ccc10DD10x10y15E", // class name
  bases__ZN3ccc10DD10x10y15E, 2,
  &(vtc__ZN3ccc10DD10x10y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x10y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x10y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x10y15E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x10y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y0  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9CC10x11y03abcEv
  virtual void  efg(); // _ZN3ccc9CC10x11y03efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x11y03pqrEv
  ~CC10x11y0(); // tgen
  CC10x11y0(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y0E) C1{ VBC2{ v3 v1} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x11y0 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y03abcEv");}
void  ccc::CC10x11y0 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y03efgEv");}
void  ccc::CC10x11y0 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y03pqrEv");}
ccc::CC10x11y0 ::~CC10x11y0(){ note_dtor("_ZN3ccc9CC10x11y0E", this);} // tgen
ccc::CC10x11y0 ::CC10x11y0(){ note_ctor("_ZN3ccc9CC10x11y0E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y0E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y0E, buf);
    ::ccc::CC10x11y0 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y0E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y0E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y0E);
    dp->::ccc::CC10x11y0::~CC10x11y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y0E(Test__ZN3ccc9CC10x11y0E, "_ZN3ccc9CC10x11y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y0C1Ev();
extern void _ZN3ccc9CC10x11y0D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y0E[] = {
  NSPAIR(_ZN3ccc9CC10x11y0C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y0E[];
extern void _ZN3ccc9CC10x11y03pqrEv();
extern void _ZN3ccc9CC10x11y03efgEv();
extern void _ZN3ccc9CC10x11y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y03pqrEv,_ZTv0_n12_N3ccc9CC10x11y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y03pqrEv,_ZThn4_N3ccc9CC10x11y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y03abcEv,_ZTv0_n16_N3ccc9CC10x11y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y03abcEv,_ZThn4_N3ccc9CC10x11y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y03pqrEv,_ZTv0_n12_N3ccc9CC10x11y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y03abcEv,_ZTv0_n16_N3ccc9CC10x11y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y0E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y0E[] = {
  {&(_ZTVN3ccc9CC10x11y0E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y0E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y0E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y0E[];
static VTBL_ENTRY alt_thunk_names133[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y03abcEv,_ZTv0_n16_N3ccc9CC10x11y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y03abcEv,_ZThn4_N3ccc9CC10x11y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y03pqrEv,_ZTv0_n12_N3ccc9CC10x11y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y03pqrEv,_ZThn4_N3ccc9CC10x11y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y0E = {  "_ZN3ccc9CC10x11y0E", // class name
  bases__ZN3ccc9CC10x11y0E, 2,
  &(vtc__ZN3ccc9CC10x11y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y0E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names133,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y0  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9DD10x11y03abcEv
  virtual void  efg(); // _ZN3ccc9DD10x11y03efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x11y03pqrEv
  ~DD10x11y0(); // tgen
  DD10x11y0(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y0E) C1{ VBC2{ v3 v1} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x11y0 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y03abcEv");}
void  ccc::DD10x11y0 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y03efgEv");}
void  ccc::DD10x11y0 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y03pqrEv");}
ccc::DD10x11y0 ::~DD10x11y0(){ note_dtor("_ZN3ccc9DD10x11y0E", this);} // tgen
ccc::DD10x11y0 ::DD10x11y0(){ note_ctor("_ZN3ccc9DD10x11y0E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y0E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y0E, buf);
    ::ccc::DD10x11y0 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y0E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y0E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y0E);
    dp->::ccc::DD10x11y0::~DD10x11y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y0E(Test__ZN3ccc9DD10x11y0E, "_ZN3ccc9DD10x11y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y0C1Ev();
extern void _ZN3ccc9DD10x11y0D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y0E[] = {
  NSPAIR(_ZN3ccc9DD10x11y0C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y0E[];
extern void _ZN3ccc9DD10x11y03pqrEv();
extern void _ZN3ccc9DD10x11y03abcEv();
extern void _ZN3ccc9DD10x11y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y03pqrEv,_ZTv0_n12_N3ccc9DD10x11y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y03pqrEv,_ZThn4_N3ccc9DD10x11y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y03efgEv,_ZTv0_n16_N3ccc9DD10x11y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y03efgEv,_ZThn4_N3ccc9DD10x11y03efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y03pqrEv,_ZTv0_n12_N3ccc9DD10x11y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y03efgEv,_ZTv0_n16_N3ccc9DD10x11y03efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y0E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y0E[] = {
  {&(_ZTVN3ccc9DD10x11y0E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y0E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y0E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y0E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y0E[];
static VTBL_ENTRY alt_thunk_names134[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y03efgEv,_ZTv0_n16_N3ccc9DD10x11y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y03efgEv,_ZThn4_N3ccc9DD10x11y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y03pqrEv,_ZTv0_n12_N3ccc9DD10x11y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y03pqrEv,_ZThn4_N3ccc9DD10x11y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y0E = {  "_ZN3ccc9DD10x11y0E", // class name
  bases__ZN3ccc9DD10x11y0E, 2,
  &(vtc__ZN3ccc9DD10x11y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y0E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names134,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y1  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9CC10x11y13abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x11y13pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x11y13efgEv
  ~CC10x11y1(); // tgen
  CC10x11y1(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y1E) C1{ VBC2{ v2 v1} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x11y1 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y13abcEv");}
void  ccc::CC10x11y1 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y13pqrEv");}
void  ccc::CC10x11y1 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y13efgEv");}
ccc::CC10x11y1 ::~CC10x11y1(){ note_dtor("_ZN3ccc9CC10x11y1E", this);} // tgen
ccc::CC10x11y1 ::CC10x11y1(){ note_ctor("_ZN3ccc9CC10x11y1E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y1E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y1E, buf);
    ::ccc::CC10x11y1 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y1E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y1E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y1E);
    dp->::ccc::CC10x11y1::~CC10x11y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y1E(Test__ZN3ccc9CC10x11y1E, "_ZN3ccc9CC10x11y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y1C1Ev();
extern void _ZN3ccc9CC10x11y1D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y1E[] = {
  NSPAIR(_ZN3ccc9CC10x11y1C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y1E[];
extern void _ZN3ccc9CC10x11y13pqrEv();
extern void _ZN3ccc9CC10x11y13efgEv();
extern void _ZN3ccc9CC10x11y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y13pqrEv,_ZTv0_n12_N3ccc9CC10x11y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y13pqrEv,_ZThn4_N3ccc9CC10x11y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y13abcEv,_ZTv0_n16_N3ccc9CC10x11y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y13abcEv,_ZThn4_N3ccc9CC10x11y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y13pqrEv,_ZTv0_n12_N3ccc9CC10x11y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y13abcEv,_ZTv0_n16_N3ccc9CC10x11y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y1E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y1E[] = {
  {&(_ZTVN3ccc9CC10x11y1E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y1E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y1E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y1E[];
static VTBL_ENTRY alt_thunk_names135[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y13abcEv,_ZTv0_n16_N3ccc9CC10x11y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y13abcEv,_ZThn4_N3ccc9CC10x11y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y13pqrEv,_ZTv0_n12_N3ccc9CC10x11y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y13pqrEv,_ZThn4_N3ccc9CC10x11y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y1E = {  "_ZN3ccc9CC10x11y1E", // class name
  bases__ZN3ccc9CC10x11y1E, 2,
  &(vtc__ZN3ccc9CC10x11y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y1E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names135,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y1  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9DD10x11y13abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x11y13pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x11y13efgEv
  ~DD10x11y1(); // tgen
  DD10x11y1(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y1E) C1{ VBC2{ v2 v1} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x11y1 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y13abcEv");}
void  ccc::DD10x11y1 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y13pqrEv");}
void  ccc::DD10x11y1 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y13efgEv");}
ccc::DD10x11y1 ::~DD10x11y1(){ note_dtor("_ZN3ccc9DD10x11y1E", this);} // tgen
ccc::DD10x11y1 ::DD10x11y1(){ note_ctor("_ZN3ccc9DD10x11y1E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y1E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y1E, buf);
    ::ccc::DD10x11y1 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y1E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y1E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y1E);
    dp->::ccc::DD10x11y1::~DD10x11y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y1E(Test__ZN3ccc9DD10x11y1E, "_ZN3ccc9DD10x11y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y1C1Ev();
extern void _ZN3ccc9DD10x11y1D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y1E[] = {
  NSPAIR(_ZN3ccc9DD10x11y1C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y1E[];
extern void _ZN3ccc9DD10x11y13pqrEv();
extern void _ZN3ccc9DD10x11y13abcEv();
extern void _ZN3ccc9DD10x11y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y13pqrEv,_ZTv0_n12_N3ccc9DD10x11y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y13pqrEv,_ZThn4_N3ccc9DD10x11y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y13efgEv,_ZTv0_n16_N3ccc9DD10x11y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y13efgEv,_ZThn4_N3ccc9DD10x11y13efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y13pqrEv,_ZTv0_n12_N3ccc9DD10x11y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y13efgEv,_ZTv0_n16_N3ccc9DD10x11y13efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y1E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y1E[] = {
  {&(_ZTVN3ccc9DD10x11y1E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y1E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y1E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y1E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y1E[];
static VTBL_ENTRY alt_thunk_names136[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y13efgEv,_ZTv0_n16_N3ccc9DD10x11y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y13efgEv,_ZThn4_N3ccc9DD10x11y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y13pqrEv,_ZTv0_n12_N3ccc9DD10x11y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y13pqrEv,_ZThn4_N3ccc9DD10x11y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y1E = {  "_ZN3ccc9DD10x11y1E", // class name
  bases__ZN3ccc9DD10x11y1E, 2,
  &(vtc__ZN3ccc9DD10x11y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y1E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names136,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y2  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9CC10x11y23efgEv
  virtual void  abc(); // _ZN3ccc9CC10x11y23abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x11y23pqrEv
  ~CC10x11y2(); // tgen
  CC10x11y2(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y2E) C1{ VBC2{ v3 v2} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x11y2 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y23efgEv");}
void  ccc::CC10x11y2 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y23abcEv");}
void  ccc::CC10x11y2 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y23pqrEv");}
ccc::CC10x11y2 ::~CC10x11y2(){ note_dtor("_ZN3ccc9CC10x11y2E", this);} // tgen
ccc::CC10x11y2 ::CC10x11y2(){ note_ctor("_ZN3ccc9CC10x11y2E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y2E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y2E, buf);
    ::ccc::CC10x11y2 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y2E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y2E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y2E);
    dp->::ccc::CC10x11y2::~CC10x11y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y2E(Test__ZN3ccc9CC10x11y2E, "_ZN3ccc9CC10x11y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y2C1Ev();
extern void _ZN3ccc9CC10x11y2D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y2E[] = {
  NSPAIR(_ZN3ccc9CC10x11y2C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y2E[];
extern void _ZN3ccc9CC10x11y23pqrEv();
extern void _ZN3ccc9CC10x11y23efgEv();
extern void _ZN3ccc9CC10x11y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y23pqrEv,_ZTv0_n12_N3ccc9CC10x11y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y23pqrEv,_ZThn4_N3ccc9CC10x11y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y23abcEv,_ZTv0_n16_N3ccc9CC10x11y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y23abcEv,_ZThn4_N3ccc9CC10x11y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y23pqrEv,_ZTv0_n12_N3ccc9CC10x11y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y23abcEv,_ZTv0_n16_N3ccc9CC10x11y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y2E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y2E[] = {
  {&(_ZTVN3ccc9CC10x11y2E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y2E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y2E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y2E[];
static VTBL_ENTRY alt_thunk_names137[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y23abcEv,_ZTv0_n16_N3ccc9CC10x11y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y23abcEv,_ZThn4_N3ccc9CC10x11y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y23pqrEv,_ZTv0_n12_N3ccc9CC10x11y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y23pqrEv,_ZThn4_N3ccc9CC10x11y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y2E = {  "_ZN3ccc9CC10x11y2E", // class name
  bases__ZN3ccc9CC10x11y2E, 2,
  &(vtc__ZN3ccc9CC10x11y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y2E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names137,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y2  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9DD10x11y23efgEv
  virtual void  abc(); // _ZN3ccc9DD10x11y23abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x11y23pqrEv
  ~DD10x11y2(); // tgen
  DD10x11y2(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y2E) C1{ VBC2{ v3 v2} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x11y2 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y23efgEv");}
void  ccc::DD10x11y2 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y23abcEv");}
void  ccc::DD10x11y2 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y23pqrEv");}
ccc::DD10x11y2 ::~DD10x11y2(){ note_dtor("_ZN3ccc9DD10x11y2E", this);} // tgen
ccc::DD10x11y2 ::DD10x11y2(){ note_ctor("_ZN3ccc9DD10x11y2E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y2E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y2E, buf);
    ::ccc::DD10x11y2 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y2E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y2E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y2E);
    dp->::ccc::DD10x11y2::~DD10x11y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y2E(Test__ZN3ccc9DD10x11y2E, "_ZN3ccc9DD10x11y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y2C1Ev();
extern void _ZN3ccc9DD10x11y2D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y2E[] = {
  NSPAIR(_ZN3ccc9DD10x11y2C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y2E[];
extern void _ZN3ccc9DD10x11y23pqrEv();
extern void _ZN3ccc9DD10x11y23abcEv();
extern void _ZN3ccc9DD10x11y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y23pqrEv,_ZTv0_n12_N3ccc9DD10x11y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y23pqrEv,_ZThn4_N3ccc9DD10x11y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y23efgEv,_ZTv0_n16_N3ccc9DD10x11y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y23efgEv,_ZThn4_N3ccc9DD10x11y23efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y23pqrEv,_ZTv0_n12_N3ccc9DD10x11y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y23efgEv,_ZTv0_n16_N3ccc9DD10x11y23efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y2E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y2E[] = {
  {&(_ZTVN3ccc9DD10x11y2E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y2E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y2E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y2E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y2E[];
static VTBL_ENTRY alt_thunk_names138[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y23efgEv,_ZTv0_n16_N3ccc9DD10x11y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y23efgEv,_ZThn4_N3ccc9DD10x11y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y23pqrEv,_ZTv0_n12_N3ccc9DD10x11y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y23pqrEv,_ZThn4_N3ccc9DD10x11y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y2E = {  "_ZN3ccc9DD10x11y2E", // class name
  bases__ZN3ccc9DD10x11y2E, 2,
  &(vtc__ZN3ccc9DD10x11y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y2E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names138,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y3  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9CC10x11y33efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x11y33pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x11y33abcEv
  ~CC10x11y3(); // tgen
  CC10x11y3(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y3E) C1{ VBC2{ v2 v3} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x11y3 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y33efgEv");}
void  ccc::CC10x11y3 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y33pqrEv");}
void  ccc::CC10x11y3 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y33abcEv");}
ccc::CC10x11y3 ::~CC10x11y3(){ note_dtor("_ZN3ccc9CC10x11y3E", this);} // tgen
ccc::CC10x11y3 ::CC10x11y3(){ note_ctor("_ZN3ccc9CC10x11y3E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y3E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y3E, buf);
    ::ccc::CC10x11y3 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y3E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y3E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y3E);
    dp->::ccc::CC10x11y3::~CC10x11y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y3E(Test__ZN3ccc9CC10x11y3E, "_ZN3ccc9CC10x11y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y3C1Ev();
extern void _ZN3ccc9CC10x11y3D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y3E[] = {
  NSPAIR(_ZN3ccc9CC10x11y3C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y3E[];
extern void _ZN3ccc9CC10x11y33pqrEv();
extern void _ZN3ccc9CC10x11y33efgEv();
extern void _ZN3ccc9CC10x11y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y33pqrEv,_ZTv0_n12_N3ccc9CC10x11y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y33pqrEv,_ZThn4_N3ccc9CC10x11y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y33abcEv,_ZTv0_n16_N3ccc9CC10x11y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y33abcEv,_ZThn4_N3ccc9CC10x11y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y33pqrEv,_ZTv0_n12_N3ccc9CC10x11y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y33abcEv,_ZTv0_n16_N3ccc9CC10x11y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y3E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y3E[] = {
  {&(_ZTVN3ccc9CC10x11y3E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y3E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y3E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y3E[];
static VTBL_ENTRY alt_thunk_names139[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y33abcEv,_ZTv0_n16_N3ccc9CC10x11y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y33abcEv,_ZThn4_N3ccc9CC10x11y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y33pqrEv,_ZTv0_n12_N3ccc9CC10x11y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y33pqrEv,_ZThn4_N3ccc9CC10x11y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y3E = {  "_ZN3ccc9CC10x11y3E", // class name
  bases__ZN3ccc9CC10x11y3E, 2,
  &(vtc__ZN3ccc9CC10x11y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y3E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names139,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y3  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9DD10x11y33efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x11y33pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x11y33abcEv
  ~DD10x11y3(); // tgen
  DD10x11y3(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y3E) C1{ VBC2{ v2 v3} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x11y3 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y33efgEv");}
void  ccc::DD10x11y3 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y33pqrEv");}
void  ccc::DD10x11y3 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y33abcEv");}
ccc::DD10x11y3 ::~DD10x11y3(){ note_dtor("_ZN3ccc9DD10x11y3E", this);} // tgen
ccc::DD10x11y3 ::DD10x11y3(){ note_ctor("_ZN3ccc9DD10x11y3E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y3E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y3E, buf);
    ::ccc::DD10x11y3 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y3E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y3E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y3E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y3E);
    dp->::ccc::DD10x11y3::~DD10x11y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y3E(Test__ZN3ccc9DD10x11y3E, "_ZN3ccc9DD10x11y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y3C1Ev();
extern void _ZN3ccc9DD10x11y3D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y3E[] = {
  NSPAIR(_ZN3ccc9DD10x11y3C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y3E[];
extern void _ZN3ccc9DD10x11y33pqrEv();
extern void _ZN3ccc9DD10x11y33abcEv();
extern void _ZN3ccc9DD10x11y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y33pqrEv,_ZTv0_n12_N3ccc9DD10x11y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y33pqrEv,_ZThn4_N3ccc9DD10x11y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y33efgEv,_ZTv0_n16_N3ccc9DD10x11y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y33efgEv,_ZThn4_N3ccc9DD10x11y33efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y33pqrEv,_ZTv0_n12_N3ccc9DD10x11y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y33efgEv,_ZTv0_n16_N3ccc9DD10x11y33efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y3E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y3E[] = {
  {&(_ZTVN3ccc9DD10x11y3E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y3E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y3E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y3E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y3E[];
static VTBL_ENTRY alt_thunk_names140[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y33efgEv,_ZTv0_n16_N3ccc9DD10x11y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y33efgEv,_ZThn4_N3ccc9DD10x11y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y33pqrEv,_ZTv0_n12_N3ccc9DD10x11y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y33pqrEv,_ZThn4_N3ccc9DD10x11y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y3E = {  "_ZN3ccc9DD10x11y3E", // class name
  bases__ZN3ccc9DD10x11y3E, 2,
  &(vtc__ZN3ccc9DD10x11y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y3E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names140,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y4  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9CC10x11y43pqrEv
  virtual void  abc(); // _ZN3ccc9CC10x11y43abcEv
  virtual void  efg(); // _ZN3ccc9CC10x11y43efgEv
  ~CC10x11y4(); // tgen
  CC10x11y4(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y4E) C1{ VBC2{ v1 v2} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x11y4 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y43pqrEv");}
void  ccc::CC10x11y4 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y43abcEv");}
void  ccc::CC10x11y4 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y43efgEv");}
ccc::CC10x11y4 ::~CC10x11y4(){ note_dtor("_ZN3ccc9CC10x11y4E", this);} // tgen
ccc::CC10x11y4 ::CC10x11y4(){ note_ctor("_ZN3ccc9CC10x11y4E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y4E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y4E, buf);
    ::ccc::CC10x11y4 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y4E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y4E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y4E);
    dp->::ccc::CC10x11y4::~CC10x11y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y4E(Test__ZN3ccc9CC10x11y4E, "_ZN3ccc9CC10x11y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y4C1Ev();
extern void _ZN3ccc9CC10x11y4D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y4E[] = {
  NSPAIR(_ZN3ccc9CC10x11y4C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y4E[];
extern void _ZN3ccc9CC10x11y43pqrEv();
extern void _ZN3ccc9CC10x11y43efgEv();
extern void _ZN3ccc9CC10x11y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y43pqrEv,_ZTv0_n12_N3ccc9CC10x11y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y43pqrEv,_ZThn4_N3ccc9CC10x11y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y43abcEv,_ZTv0_n16_N3ccc9CC10x11y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y43abcEv,_ZThn4_N3ccc9CC10x11y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y43pqrEv,_ZTv0_n12_N3ccc9CC10x11y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y43abcEv,_ZTv0_n16_N3ccc9CC10x11y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y4E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y4E[] = {
  {&(_ZTVN3ccc9CC10x11y4E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y4E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y4E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y4E[];
static VTBL_ENTRY alt_thunk_names141[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y43abcEv,_ZTv0_n16_N3ccc9CC10x11y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y43abcEv,_ZThn4_N3ccc9CC10x11y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y43pqrEv,_ZTv0_n12_N3ccc9CC10x11y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y43pqrEv,_ZThn4_N3ccc9CC10x11y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y4E = {  "_ZN3ccc9CC10x11y4E", // class name
  bases__ZN3ccc9CC10x11y4E, 2,
  &(vtc__ZN3ccc9CC10x11y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y4E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names141,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y4  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9DD10x11y43pqrEv
  virtual void  abc(); // _ZN3ccc9DD10x11y43abcEv
  virtual void  efg(); // _ZN3ccc9DD10x11y43efgEv
  ~DD10x11y4(); // tgen
  DD10x11y4(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y4E) C1{ VBC2{ v1 v2} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x11y4 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y43pqrEv");}
void  ccc::DD10x11y4 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y43abcEv");}
void  ccc::DD10x11y4 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y43efgEv");}
ccc::DD10x11y4 ::~DD10x11y4(){ note_dtor("_ZN3ccc9DD10x11y4E", this);} // tgen
ccc::DD10x11y4 ::DD10x11y4(){ note_ctor("_ZN3ccc9DD10x11y4E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y4E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y4E, buf);
    ::ccc::DD10x11y4 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y4E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y4E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y4E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y4E);
    dp->::ccc::DD10x11y4::~DD10x11y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y4E(Test__ZN3ccc9DD10x11y4E, "_ZN3ccc9DD10x11y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y4C1Ev();
extern void _ZN3ccc9DD10x11y4D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y4E[] = {
  NSPAIR(_ZN3ccc9DD10x11y4C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y4E[];
extern void _ZN3ccc9DD10x11y43pqrEv();
extern void _ZN3ccc9DD10x11y43abcEv();
extern void _ZN3ccc9DD10x11y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y43pqrEv,_ZTv0_n12_N3ccc9DD10x11y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y43pqrEv,_ZThn4_N3ccc9DD10x11y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y43efgEv,_ZTv0_n16_N3ccc9DD10x11y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y43efgEv,_ZThn4_N3ccc9DD10x11y43efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y43pqrEv,_ZTv0_n12_N3ccc9DD10x11y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y43efgEv,_ZTv0_n16_N3ccc9DD10x11y43efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y4E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y4E[] = {
  {&(_ZTVN3ccc9DD10x11y4E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y4E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y4E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y4E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y4E[];
static VTBL_ENTRY alt_thunk_names142[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y43efgEv,_ZTv0_n16_N3ccc9DD10x11y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y43efgEv,_ZThn4_N3ccc9DD10x11y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y43pqrEv,_ZTv0_n12_N3ccc9DD10x11y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y43pqrEv,_ZThn4_N3ccc9DD10x11y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y4E = {  "_ZN3ccc9DD10x11y4E", // class name
  bases__ZN3ccc9DD10x11y4E, 2,
  &(vtc__ZN3ccc9DD10x11y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y4E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names142,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y5  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9CC10x11y53pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x11y53efgEv
  virtual void  abc(); // _ZN3ccc9CC10x11y53abcEv
  ~CC10x11y5(); // tgen
  CC10x11y5(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y5E) C1{ VBC2{ v1 v3} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x11y5 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y53pqrEv");}
void  ccc::CC10x11y5 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y53efgEv");}
void  ccc::CC10x11y5 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y53abcEv");}
ccc::CC10x11y5 ::~CC10x11y5(){ note_dtor("_ZN3ccc9CC10x11y5E", this);} // tgen
ccc::CC10x11y5 ::CC10x11y5(){ note_ctor("_ZN3ccc9CC10x11y5E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y5E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y5E, buf);
    ::ccc::CC10x11y5 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y5E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y5E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y5E);
    dp->::ccc::CC10x11y5::~CC10x11y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y5E(Test__ZN3ccc9CC10x11y5E, "_ZN3ccc9CC10x11y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y5C1Ev();
extern void _ZN3ccc9CC10x11y5D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y5E[] = {
  NSPAIR(_ZN3ccc9CC10x11y5C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y5E[];
extern void _ZN3ccc9CC10x11y53pqrEv();
extern void _ZN3ccc9CC10x11y53efgEv();
extern void _ZN3ccc9CC10x11y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y53pqrEv,_ZTv0_n12_N3ccc9CC10x11y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y53pqrEv,_ZThn4_N3ccc9CC10x11y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y53abcEv,_ZTv0_n16_N3ccc9CC10x11y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y53abcEv,_ZThn4_N3ccc9CC10x11y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y53pqrEv,_ZTv0_n12_N3ccc9CC10x11y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y53abcEv,_ZTv0_n16_N3ccc9CC10x11y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y5E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y5E[] = {
  {&(_ZTVN3ccc9CC10x11y5E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y5E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y5E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y5E[];
static VTBL_ENTRY alt_thunk_names143[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y53abcEv,_ZTv0_n16_N3ccc9CC10x11y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y53abcEv,_ZThn4_N3ccc9CC10x11y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y53pqrEv,_ZTv0_n12_N3ccc9CC10x11y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y53pqrEv,_ZThn4_N3ccc9CC10x11y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y5E = {  "_ZN3ccc9CC10x11y5E", // class name
  bases__ZN3ccc9CC10x11y5E, 2,
  &(vtc__ZN3ccc9CC10x11y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y5E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names143,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y5  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9DD10x11y53pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x11y53efgEv
  virtual void  abc(); // _ZN3ccc9DD10x11y53abcEv
  ~DD10x11y5(); // tgen
  DD10x11y5(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y5E) C1{ VBC2{ v1 v3} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x11y5 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y53pqrEv");}
void  ccc::DD10x11y5 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y53efgEv");}
void  ccc::DD10x11y5 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y53abcEv");}
ccc::DD10x11y5 ::~DD10x11y5(){ note_dtor("_ZN3ccc9DD10x11y5E", this);} // tgen
ccc::DD10x11y5 ::DD10x11y5(){ note_ctor("_ZN3ccc9DD10x11y5E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y5E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y5E, buf);
    ::ccc::DD10x11y5 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y5E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y5E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y5E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y5E);
    dp->::ccc::DD10x11y5::~DD10x11y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y5E(Test__ZN3ccc9DD10x11y5E, "_ZN3ccc9DD10x11y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y5C1Ev();
extern void _ZN3ccc9DD10x11y5D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y5E[] = {
  NSPAIR(_ZN3ccc9DD10x11y5C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y5E[];
extern void _ZN3ccc9DD10x11y53pqrEv();
extern void _ZN3ccc9DD10x11y53abcEv();
extern void _ZN3ccc9DD10x11y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y53pqrEv,_ZTv0_n12_N3ccc9DD10x11y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y53pqrEv,_ZThn4_N3ccc9DD10x11y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y53efgEv,_ZTv0_n16_N3ccc9DD10x11y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y53efgEv,_ZThn4_N3ccc9DD10x11y53efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y53pqrEv,_ZTv0_n12_N3ccc9DD10x11y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y53efgEv,_ZTv0_n16_N3ccc9DD10x11y53efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y5E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y5E[] = {
  {&(_ZTVN3ccc9DD10x11y5E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y5E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y5E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y5E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y5E[];
static VTBL_ENTRY alt_thunk_names144[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y53efgEv,_ZTv0_n16_N3ccc9DD10x11y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y53efgEv,_ZThn4_N3ccc9DD10x11y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y53pqrEv,_ZTv0_n12_N3ccc9DD10x11y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y53pqrEv,_ZThn4_N3ccc9DD10x11y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y5E = {  "_ZN3ccc9DD10x11y5E", // class name
  bases__ZN3ccc9DD10x11y5E, 2,
  &(vtc__ZN3ccc9DD10x11y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y5E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names144,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y6  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9CC10x11y63abcEv
  virtual void  efg(); // _ZN3ccc9CC10x11y63efgEv
  ~CC10x11y6(); // tgen
  CC10x11y6(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y6E) C1{ VBC2{ v3 v1} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x11y6 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y63abcEv");}
void  ccc::CC10x11y6 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y63efgEv");}
ccc::CC10x11y6 ::~CC10x11y6(){ note_dtor("_ZN3ccc9CC10x11y6E", this);} // tgen
ccc::CC10x11y6 ::CC10x11y6(){ note_ctor("_ZN3ccc9CC10x11y6E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y6E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y6E, buf);
    ::ccc::CC10x11y6 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y6E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y6E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y6E);
    dp->::ccc::CC10x11y6::~CC10x11y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y6E(Test__ZN3ccc9CC10x11y6E, "_ZN3ccc9CC10x11y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y6C1Ev();
extern void _ZN3ccc9CC10x11y6D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y6E[] = {
  NSPAIR(_ZN3ccc9CC10x11y6C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y6E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc9CC10x11y63efgEv();
extern void _ZN3ccc9CC10x11y63abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y63abcEv,_ZTv0_n16_N3ccc9CC10x11y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y63abcEv,_ZThn4_N3ccc9CC10x11y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y63abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y63abcEv,_ZTv0_n16_N3ccc9CC10x11y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y6E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y6E[] = {
  {&(_ZTVN3ccc9CC10x11y6E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y6E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y6E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y6E[];
static VTBL_ENTRY alt_thunk_names145[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y63abcEv,_ZTv0_n16_N3ccc9CC10x11y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y63abcEv,_ZThn4_N3ccc9CC10x11y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y6E = {  "_ZN3ccc9CC10x11y6E", // class name
  bases__ZN3ccc9CC10x11y6E, 2,
  &(vtc__ZN3ccc9CC10x11y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y6E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names145,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y6  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9DD10x11y63abcEv
  virtual void  efg(); // _ZN3ccc9DD10x11y63efgEv
  ~DD10x11y6(); // tgen
  DD10x11y6(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y6E) C1{ VBC2{ v3 v1} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x11y6 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y63abcEv");}
void  ccc::DD10x11y6 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y63efgEv");}
ccc::DD10x11y6 ::~DD10x11y6(){ note_dtor("_ZN3ccc9DD10x11y6E", this);} // tgen
ccc::DD10x11y6 ::DD10x11y6(){ note_ctor("_ZN3ccc9DD10x11y6E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y6E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y6E, buf);
    ::ccc::DD10x11y6 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y6E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y6E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y6E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y6E);
    dp->::ccc::DD10x11y6::~DD10x11y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y6E(Test__ZN3ccc9DD10x11y6E, "_ZN3ccc9DD10x11y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y6C1Ev();
extern void _ZN3ccc9DD10x11y6D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y6E[] = {
  NSPAIR(_ZN3ccc9DD10x11y6C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y6E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x11y63abcEv();
extern void _ZN3ccc9DD10x11y63efgEv();
extern void _ZN3ccc4BB113pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y63efgEv,_ZTv0_n16_N3ccc9DD10x11y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y63efgEv,_ZThn4_N3ccc9DD10x11y63efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y63efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y63efgEv,_ZTv0_n16_N3ccc9DD10x11y63efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y6E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y6E[] = {
  {&(_ZTVN3ccc9DD10x11y6E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y6E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y6E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y6E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y6E[];
static VTBL_ENTRY alt_thunk_names146[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y63efgEv,_ZTv0_n16_N3ccc9DD10x11y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y63efgEv,_ZThn4_N3ccc9DD10x11y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y6E = {  "_ZN3ccc9DD10x11y6E", // class name
  bases__ZN3ccc9DD10x11y6E, 2,
  &(vtc__ZN3ccc9DD10x11y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y6E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names146,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y7  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9CC10x11y73abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x11y73pqrEv
  ~CC10x11y7(); // tgen
  CC10x11y7(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y7E) C1{ VBC2{ v2 v1} BC3{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::CC10x11y7 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y73abcEv");}
void  ccc::CC10x11y7 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y73pqrEv");}
ccc::CC10x11y7 ::~CC10x11y7(){ note_dtor("_ZN3ccc9CC10x11y7E", this);} // tgen
ccc::CC10x11y7 ::CC10x11y7(){ note_ctor("_ZN3ccc9CC10x11y7E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y7E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y7E, buf);
    ::ccc::CC10x11y7 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y7E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y7E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y7E);
    dp->::ccc::CC10x11y7::~CC10x11y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y7E(Test__ZN3ccc9CC10x11y7E, "_ZN3ccc9CC10x11y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y7C1Ev();
extern void _ZN3ccc9CC10x11y7D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y7E[] = {
  NSPAIR(_ZN3ccc9CC10x11y7C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y7E[];
extern void _ZN3ccc9CC10x11y73pqrEv();
extern void _ZN3ccc4BB113efgEv();
extern void _ZN3ccc9CC10x11y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y73pqrEv,_ZTv0_n12_N3ccc9CC10x11y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y73pqrEv,_ZThn4_N3ccc9CC10x11y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y73abcEv,_ZTv0_n16_N3ccc9CC10x11y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y73abcEv,_ZThn4_N3ccc9CC10x11y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y73pqrEv,_ZTv0_n12_N3ccc9CC10x11y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y73abcEv,_ZTv0_n16_N3ccc9CC10x11y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y7E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y7E[] = {
  {&(_ZTVN3ccc9CC10x11y7E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y7E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y7E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y7E[];
static VTBL_ENTRY alt_thunk_names147[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y73abcEv,_ZTv0_n16_N3ccc9CC10x11y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y73abcEv,_ZThn4_N3ccc9CC10x11y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y73pqrEv,_ZTv0_n12_N3ccc9CC10x11y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y73pqrEv,_ZThn4_N3ccc9CC10x11y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y7E = {  "_ZN3ccc9CC10x11y7E", // class name
  bases__ZN3ccc9CC10x11y7E, 2,
  &(vtc__ZN3ccc9CC10x11y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y7E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names147,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y7  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9DD10x11y73abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x11y73pqrEv
  ~DD10x11y7(); // tgen
  DD10x11y7(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y7E) C1{ VBC2{ v2 v1} VBC3{ v2 v3} v1 v2}
}
namespace ccc { 
void  ccc::DD10x11y7 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y73abcEv");}
void  ccc::DD10x11y7 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y73pqrEv");}
ccc::DD10x11y7 ::~DD10x11y7(){ note_dtor("_ZN3ccc9DD10x11y7E", this);} // tgen
ccc::DD10x11y7 ::DD10x11y7(){ note_ctor("_ZN3ccc9DD10x11y7E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y7E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y7E, buf);
    ::ccc::DD10x11y7 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y7E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y7E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y7E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y7E);
    dp->::ccc::DD10x11y7::~DD10x11y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y7E(Test__ZN3ccc9DD10x11y7E, "_ZN3ccc9DD10x11y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y7C1Ev();
extern void _ZN3ccc9DD10x11y7D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y7E[] = {
  NSPAIR(_ZN3ccc9DD10x11y7C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y7E[];
extern void _ZN3ccc9DD10x11y73pqrEv();
extern void _ZN3ccc9DD10x11y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y73pqrEv,_ZTv0_n12_N3ccc9DD10x11y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y73pqrEv,_ZThn4_N3ccc9DD10x11y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y73abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y73pqrEv,_ZTv0_n12_N3ccc9DD10x11y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y7E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y7E[] = {
  {&(_ZTVN3ccc9DD10x11y7E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x11y7E[6]),  6,14},
  {&(_ZTVN3ccc9DD10x11y7E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y7E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y7E[];
static VTBL_ENTRY alt_thunk_names148[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y73pqrEv,_ZTv0_n12_N3ccc9DD10x11y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y73pqrEv,_ZThn4_N3ccc9DD10x11y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y7E = {  "_ZN3ccc9DD10x11y7E", // class name
  bases__ZN3ccc9DD10x11y7E, 2,
  &(vtc__ZN3ccc9DD10x11y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y7E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names148,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y8  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9CC10x11y83efgEv
  virtual void  abc(); // _ZN3ccc9CC10x11y83abcEv
  ~CC10x11y8(); // tgen
  CC10x11y8(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y8E) C1{ VBC2{ v3 v2} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x11y8 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y83efgEv");}
void  ccc::CC10x11y8 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x11y83abcEv");}
ccc::CC10x11y8 ::~CC10x11y8(){ note_dtor("_ZN3ccc9CC10x11y8E", this);} // tgen
ccc::CC10x11y8 ::CC10x11y8(){ note_ctor("_ZN3ccc9CC10x11y8E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y8E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y8E, buf);
    ::ccc::CC10x11y8 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y8E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y8E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y8E);
    dp->::ccc::CC10x11y8::~CC10x11y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y8E(Test__ZN3ccc9CC10x11y8E, "_ZN3ccc9CC10x11y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y8C1Ev();
extern void _ZN3ccc9CC10x11y8D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y8E[] = {
  NSPAIR(_ZN3ccc9CC10x11y8C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y8E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc9CC10x11y83efgEv();
extern void _ZN3ccc9CC10x11y83abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x11y83abcEv,_ZTv0_n16_N3ccc9CC10x11y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y83abcEv,_ZThn4_N3ccc9CC10x11y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y83abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x11y83abcEv,_ZTv0_n16_N3ccc9CC10x11y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y8E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y8E[] = {
  {&(_ZTVN3ccc9CC10x11y8E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x11y8E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y8E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y8E[];
static VTBL_ENTRY alt_thunk_names149[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x11y83abcEv,_ZTv0_n16_N3ccc9CC10x11y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y83abcEv,_ZThn4_N3ccc9CC10x11y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y8E = {  "_ZN3ccc9CC10x11y8E", // class name
  bases__ZN3ccc9CC10x11y8E, 2,
  &(vtc__ZN3ccc9CC10x11y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y8E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names149,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y8  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9DD10x11y83efgEv
  virtual void  abc(); // _ZN3ccc9DD10x11y83abcEv
  ~DD10x11y8(); // tgen
  DD10x11y8(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y8E) C1{ VBC2{ v3 v2} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x11y8 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y83efgEv");}
void  ccc::DD10x11y8 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x11y83abcEv");}
ccc::DD10x11y8 ::~DD10x11y8(){ note_dtor("_ZN3ccc9DD10x11y8E", this);} // tgen
ccc::DD10x11y8 ::DD10x11y8(){ note_ctor("_ZN3ccc9DD10x11y8E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y8E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y8E, buf);
    ::ccc::DD10x11y8 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y8E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y8E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y8E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y8E);
    dp->::ccc::DD10x11y8::~DD10x11y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y8E(Test__ZN3ccc9DD10x11y8E, "_ZN3ccc9DD10x11y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y8C1Ev();
extern void _ZN3ccc9DD10x11y8D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y8E[] = {
  NSPAIR(_ZN3ccc9DD10x11y8C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y8E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc9DD10x11y83abcEv();
extern void _ZN3ccc9DD10x11y83efgEv();
extern void _ZN3ccc4BB113pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y83efgEv,_ZTv0_n16_N3ccc9DD10x11y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y83efgEv,_ZThn4_N3ccc9DD10x11y83efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y83efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y83efgEv,_ZTv0_n16_N3ccc9DD10x11y83efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y8E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y8E[] = {
  {&(_ZTVN3ccc9DD10x11y8E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y8E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y8E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y8E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y8E[];
static VTBL_ENTRY alt_thunk_names150[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y83efgEv,_ZTv0_n16_N3ccc9DD10x11y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y83efgEv,_ZThn4_N3ccc9DD10x11y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y8E = {  "_ZN3ccc9DD10x11y8E", // class name
  bases__ZN3ccc9DD10x11y8E, 2,
  &(vtc__ZN3ccc9DD10x11y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y8E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names150,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y9  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9CC10x11y93efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x11y93pqrEv
  ~CC10x11y9(); // tgen
  CC10x11y9(); // tgen
};
//SIG(1 _ZN3ccc9CC10x11y9E) C1{ VBC2{ v2 v3} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC10x11y9 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x11y93efgEv");}
void  ccc::CC10x11y9 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x11y93pqrEv");}
ccc::CC10x11y9 ::~CC10x11y9(){ note_dtor("_ZN3ccc9CC10x11y9E", this);} // tgen
ccc::CC10x11y9 ::CC10x11y9(){ note_ctor("_ZN3ccc9CC10x11y9E", this);} // tgen
}
static void Test__ZN3ccc9CC10x11y9E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x11y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x11y9E, buf);
    ::ccc::CC10x11y9 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x11y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x11y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x11y9E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc9CC10x11y9E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x11y9E);
    dp->::ccc::CC10x11y9::~CC10x11y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x11y9E(Test__ZN3ccc9CC10x11y9E, "_ZN3ccc9CC10x11y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x11y9C1Ev();
extern void _ZN3ccc9CC10x11y9D1Ev();
Name_Map name_map__ZN3ccc9CC10x11y9E[] = {
  NSPAIR(_ZN3ccc9CC10x11y9C1Ev),
  NSPAIR(_ZN3ccc9CC10x11y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC10x11y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y9E[];
extern void _ZN3ccc9CC10x11y93pqrEv();
extern void _ZN3ccc9CC10x11y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x11y93pqrEv,_ZTv0_n12_N3ccc9CC10x11y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x11y93pqrEv,_ZThn4_N3ccc9CC10x11y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC10x11y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x11y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x11y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x11y93pqrEv,_ZTv0_n12_N3ccc9CC10x11y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x11y9E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x11y9E[] = {
  {&(_ZTVN3ccc9CC10x11y9E[3]),  3,11},
  {&(_ZTVN3ccc9CC10x11y9E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x11y9E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x11y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x11y9E[];
static VTBL_ENTRY alt_thunk_names151[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x11y93pqrEv,_ZTv0_n12_N3ccc9CC10x11y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x11y93pqrEv,_ZThn4_N3ccc9CC10x11y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x11y9E = {  "_ZN3ccc9CC10x11y9E", // class name
  bases__ZN3ccc9CC10x11y9E, 2,
  &(vtc__ZN3ccc9CC10x11y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x11y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x11y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x11y9E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x11y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names151,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y9  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9DD10x11y93efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x11y93pqrEv
  ~DD10x11y9(); // tgen
  DD10x11y9(); // tgen
};
//SIG(1 _ZN3ccc9DD10x11y9E) C1{ VBC2{ v2 v3} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD10x11y9 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x11y93efgEv");}
void  ccc::DD10x11y9 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x11y93pqrEv");}
ccc::DD10x11y9 ::~DD10x11y9(){ note_dtor("_ZN3ccc9DD10x11y9E", this);} // tgen
ccc::DD10x11y9 ::DD10x11y9(){ note_ctor("_ZN3ccc9DD10x11y9E", this);} // tgen
}
static void Test__ZN3ccc9DD10x11y9E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x11y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x11y9E, buf);
    ::ccc::DD10x11y9 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x11y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x11y9E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x11y9E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9DD10x11y9E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x11y9E);
    dp->::ccc::DD10x11y9::~DD10x11y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x11y9E(Test__ZN3ccc9DD10x11y9E, "_ZN3ccc9DD10x11y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x11y9C1Ev();
extern void _ZN3ccc9DD10x11y9D1Ev();
Name_Map name_map__ZN3ccc9DD10x11y9E[] = {
  NSPAIR(_ZN3ccc9DD10x11y9C1Ev),
  NSPAIR(_ZN3ccc9DD10x11y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9DD10x11y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y9E[];
extern void _ZN3ccc9DD10x11y93pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc9DD10x11y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x11y93pqrEv,_ZTv0_n12_N3ccc9DD10x11y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y93pqrEv,_ZThn4_N3ccc9DD10x11y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9DD10x11y93efgEv,_ZTv0_n16_N3ccc9DD10x11y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x11y93efgEv,_ZThn4_N3ccc9DD10x11y93efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x11y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x11y93efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x11y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x11y93pqrEv,_ZTv0_n12_N3ccc9DD10x11y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9DD10x11y93efgEv,_ZTv0_n16_N3ccc9DD10x11y93efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x11y9E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x11y9E[] = {
  {&(_ZTVN3ccc9DD10x11y9E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y9E[6]),  6,15},
  {&(_ZTVN3ccc9DD10x11y9E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x11y9E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x11y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x11y9E[];
static VTBL_ENTRY alt_thunk_names152[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9DD10x11y93efgEv,_ZTv0_n16_N3ccc9DD10x11y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y93efgEv,_ZThn4_N3ccc9DD10x11y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x11y93pqrEv,_ZTv0_n12_N3ccc9DD10x11y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x11y93pqrEv,_ZThn4_N3ccc9DD10x11y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x11y9E = {  "_ZN3ccc9DD10x11y9E", // class name
  bases__ZN3ccc9DD10x11y9E, 2,
  &(vtc__ZN3ccc9DD10x11y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x11y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x11y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x11y9E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x11y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names152,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y10  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc10CC10x11y103pqrEv
  virtual void  abc(); // _ZN3ccc10CC10x11y103abcEv
  ~CC10x11y10(); // tgen
  CC10x11y10(); // tgen
};
//SIG(1 _ZN3ccc10CC10x11y10E) C1{ VBC2{ v1 v2} BC3{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::CC10x11y10 ::pqr(){vfunc_called(this, "_ZN3ccc10CC10x11y103pqrEv");}
void  ccc::CC10x11y10 ::abc(){vfunc_called(this, "_ZN3ccc10CC10x11y103abcEv");}
ccc::CC10x11y10 ::~CC10x11y10(){ note_dtor("_ZN3ccc10CC10x11y10E", this);} // tgen
ccc::CC10x11y10 ::CC10x11y10(){ note_ctor("_ZN3ccc10CC10x11y10E", this);} // tgen
}
static void Test__ZN3ccc10CC10x11y10E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x11y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x11y10E, buf);
    ::ccc::CC10x11y10 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x11y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x11y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x11y10E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc10CC10x11y10E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x11y10E);
    dp->::ccc::CC10x11y10::~CC10x11y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x11y10E(Test__ZN3ccc10CC10x11y10E, "_ZN3ccc10CC10x11y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x11y10C1Ev();
extern void _ZN3ccc10CC10x11y10D1Ev();
Name_Map name_map__ZN3ccc10CC10x11y10E[] = {
  NSPAIR(_ZN3ccc10CC10x11y10C1Ev),
  NSPAIR(_ZN3ccc10CC10x11y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10CC10x11y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y10E[];
extern void _ZN3ccc10CC10x11y103pqrEv();
extern void _ZN3ccc4BB113efgEv();
extern void _ZN3ccc10CC10x11y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10CC10x11y103pqrEv,_ZTv0_n12_N3ccc10CC10x11y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x11y103pqrEv,_ZThn4_N3ccc10CC10x11y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc10CC10x11y103abcEv,_ZTv0_n16_N3ccc10CC10x11y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x11y103abcEv,_ZThn4_N3ccc10CC10x11y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10CC10x11y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10CC10x11y103pqrEv,_ZTv0_n12_N3ccc10CC10x11y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10CC10x11y103abcEv,_ZTv0_n16_N3ccc10CC10x11y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x11y10E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x11y10E[] = {
  {&(_ZTVN3ccc10CC10x11y10E[3]),  3,12},
  {&(_ZTVN3ccc10CC10x11y10E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y10E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x11y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x11y10E[];
static VTBL_ENTRY alt_thunk_names153[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10CC10x11y103abcEv,_ZTv0_n16_N3ccc10CC10x11y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x11y103abcEv,_ZThn4_N3ccc10CC10x11y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10CC10x11y103pqrEv,_ZTv0_n12_N3ccc10CC10x11y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x11y103pqrEv,_ZThn4_N3ccc10CC10x11y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x11y10E = {  "_ZN3ccc10CC10x11y10E", // class name
  bases__ZN3ccc10CC10x11y10E, 2,
  &(vtc__ZN3ccc10CC10x11y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x11y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x11y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x11y10E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x11y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names153,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y10  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc10DD10x11y103pqrEv
  virtual void  abc(); // _ZN3ccc10DD10x11y103abcEv
  ~DD10x11y10(); // tgen
  DD10x11y10(); // tgen
};
//SIG(1 _ZN3ccc10DD10x11y10E) C1{ VBC2{ v1 v2} VBC3{ v1 v3} v1 v2}
}
namespace ccc { 
void  ccc::DD10x11y10 ::pqr(){vfunc_called(this, "_ZN3ccc10DD10x11y103pqrEv");}
void  ccc::DD10x11y10 ::abc(){vfunc_called(this, "_ZN3ccc10DD10x11y103abcEv");}
ccc::DD10x11y10 ::~DD10x11y10(){ note_dtor("_ZN3ccc10DD10x11y10E", this);} // tgen
ccc::DD10x11y10 ::DD10x11y10(){ note_ctor("_ZN3ccc10DD10x11y10E", this);} // tgen
}
static void Test__ZN3ccc10DD10x11y10E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x11y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x11y10E, buf);
    ::ccc::DD10x11y10 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x11y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x11y10E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x11y10E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc10DD10x11y10E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x11y10E);
    dp->::ccc::DD10x11y10::~DD10x11y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x11y10E(Test__ZN3ccc10DD10x11y10E, "_ZN3ccc10DD10x11y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x11y10C1Ev();
extern void _ZN3ccc10DD10x11y10D1Ev();
Name_Map name_map__ZN3ccc10DD10x11y10E[] = {
  NSPAIR(_ZN3ccc10DD10x11y10C1Ev),
  NSPAIR(_ZN3ccc10DD10x11y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10DD10x11y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y10E[];
extern void _ZN3ccc10DD10x11y103pqrEv();
extern void _ZN3ccc10DD10x11y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10DD10x11y103pqrEv,_ZTv0_n12_N3ccc10DD10x11y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x11y103pqrEv,_ZThn4_N3ccc10DD10x11y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x11y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10DD10x11y103pqrEv,_ZTv0_n12_N3ccc10DD10x11y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x11y10E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x11y10E[] = {
  {&(_ZTVN3ccc10DD10x11y10E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y10E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y10E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y10E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x11y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x11y10E[];
static VTBL_ENTRY alt_thunk_names154[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10DD10x11y103pqrEv,_ZTv0_n12_N3ccc10DD10x11y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x11y103pqrEv,_ZThn4_N3ccc10DD10x11y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x11y10E = {  "_ZN3ccc10DD10x11y10E", // class name
  bases__ZN3ccc10DD10x11y10E, 2,
  &(vtc__ZN3ccc10DD10x11y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x11y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x11y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x11y10E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x11y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names154,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y11  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc10CC10x11y113pqrEv
  virtual void  efg(); // _ZN3ccc10CC10x11y113efgEv
  ~CC10x11y11(); // tgen
  CC10x11y11(); // tgen
};
//SIG(1 _ZN3ccc10CC10x11y11E) C1{ VBC2{ v1 v3} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC10x11y11 ::pqr(){vfunc_called(this, "_ZN3ccc10CC10x11y113pqrEv");}
void  ccc::CC10x11y11 ::efg(){vfunc_called(this, "_ZN3ccc10CC10x11y113efgEv");}
ccc::CC10x11y11 ::~CC10x11y11(){ note_dtor("_ZN3ccc10CC10x11y11E", this);} // tgen
ccc::CC10x11y11 ::CC10x11y11(){ note_ctor("_ZN3ccc10CC10x11y11E", this);} // tgen
}
static void Test__ZN3ccc10CC10x11y11E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x11y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x11y11E, buf);
    ::ccc::CC10x11y11 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x11y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x11y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x11y11E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc10CC10x11y11E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x11y11E);
    dp->::ccc::CC10x11y11::~CC10x11y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x11y11E(Test__ZN3ccc10CC10x11y11E, "_ZN3ccc10CC10x11y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x11y11C1Ev();
extern void _ZN3ccc10CC10x11y11D1Ev();
Name_Map name_map__ZN3ccc10CC10x11y11E[] = {
  NSPAIR(_ZN3ccc10CC10x11y11C1Ev),
  NSPAIR(_ZN3ccc10CC10x11y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10CC10x11y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y11E[];
extern void _ZN3ccc10CC10x11y113pqrEv();
extern void _ZN3ccc10CC10x11y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10CC10x11y113pqrEv,_ZTv0_n12_N3ccc10CC10x11y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x11y113pqrEv,_ZThn4_N3ccc10CC10x11y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x11y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10CC10x11y113pqrEv,_ZTv0_n12_N3ccc10CC10x11y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x11y11E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x11y11E[] = {
  {&(_ZTVN3ccc10CC10x11y11E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x11y11E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y11E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x11y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x11y11E[];
static VTBL_ENTRY alt_thunk_names155[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10CC10x11y113pqrEv,_ZTv0_n12_N3ccc10CC10x11y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x11y113pqrEv,_ZThn4_N3ccc10CC10x11y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x11y11E = {  "_ZN3ccc10CC10x11y11E", // class name
  bases__ZN3ccc10CC10x11y11E, 2,
  &(vtc__ZN3ccc10CC10x11y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x11y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x11y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x11y11E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x11y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names155,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y11  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc10DD10x11y113pqrEv
  virtual void  efg(); // _ZN3ccc10DD10x11y113efgEv
  ~DD10x11y11(); // tgen
  DD10x11y11(); // tgen
};
//SIG(1 _ZN3ccc10DD10x11y11E) C1{ VBC2{ v1 v3} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD10x11y11 ::pqr(){vfunc_called(this, "_ZN3ccc10DD10x11y113pqrEv");}
void  ccc::DD10x11y11 ::efg(){vfunc_called(this, "_ZN3ccc10DD10x11y113efgEv");}
ccc::DD10x11y11 ::~DD10x11y11(){ note_dtor("_ZN3ccc10DD10x11y11E", this);} // tgen
ccc::DD10x11y11 ::DD10x11y11(){ note_ctor("_ZN3ccc10DD10x11y11E", this);} // tgen
}
static void Test__ZN3ccc10DD10x11y11E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x11y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x11y11E, buf);
    ::ccc::DD10x11y11 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x11y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x11y11E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x11y11E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc10DD10x11y11E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x11y11E);
    dp->::ccc::DD10x11y11::~DD10x11y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x11y11E(Test__ZN3ccc10DD10x11y11E, "_ZN3ccc10DD10x11y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x11y11C1Ev();
extern void _ZN3ccc10DD10x11y11D1Ev();
Name_Map name_map__ZN3ccc10DD10x11y11E[] = {
  NSPAIR(_ZN3ccc10DD10x11y11C1Ev),
  NSPAIR(_ZN3ccc10DD10x11y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10DD10x11y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y11E[];
extern void _ZN3ccc10DD10x11y113pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc10DD10x11y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10DD10x11y113pqrEv,_ZTv0_n12_N3ccc10DD10x11y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x11y113pqrEv,_ZThn4_N3ccc10DD10x11y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc10DD10x11y113efgEv,_ZTv0_n16_N3ccc10DD10x11y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x11y113efgEv,_ZThn4_N3ccc10DD10x11y113efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10DD10x11y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y113efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10DD10x11y113pqrEv,_ZTv0_n12_N3ccc10DD10x11y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10DD10x11y113efgEv,_ZTv0_n16_N3ccc10DD10x11y113efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x11y11E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x11y11E[] = {
  {&(_ZTVN3ccc10DD10x11y11E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x11y11E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x11y11E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y11E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x11y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x11y11E[];
static VTBL_ENTRY alt_thunk_names156[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10DD10x11y113efgEv,_ZTv0_n16_N3ccc10DD10x11y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x11y113efgEv,_ZThn4_N3ccc10DD10x11y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10DD10x11y113pqrEv,_ZTv0_n12_N3ccc10DD10x11y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x11y113pqrEv,_ZThn4_N3ccc10DD10x11y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x11y11E = {  "_ZN3ccc10DD10x11y11E", // class name
  bases__ZN3ccc10DD10x11y11E, 2,
  &(vtc__ZN3ccc10DD10x11y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x11y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x11y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x11y11E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x11y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names156,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y12  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc10CC10x11y123abcEv
  ~CC10x11y12(); // tgen
  CC10x11y12(); // tgen
};
//SIG(1 _ZN3ccc10CC10x11y12E) C1{ VBC2{ v2 v1} BC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::CC10x11y12 ::abc(){vfunc_called(this, "_ZN3ccc10CC10x11y123abcEv");}
ccc::CC10x11y12 ::~CC10x11y12(){ note_dtor("_ZN3ccc10CC10x11y12E", this);} // tgen
ccc::CC10x11y12 ::CC10x11y12(){ note_ctor("_ZN3ccc10CC10x11y12E", this);} // tgen
}
static void Test__ZN3ccc10CC10x11y12E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x11y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x11y12E, buf);
    ::ccc::CC10x11y12 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x11y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x11y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x11y12E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc10CC10x11y12E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x11y12E);
    dp->::ccc::CC10x11y12::~CC10x11y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x11y12E(Test__ZN3ccc10CC10x11y12E, "_ZN3ccc10CC10x11y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x11y12C1Ev();
extern void _ZN3ccc10CC10x11y12D1Ev();
Name_Map name_map__ZN3ccc10CC10x11y12E[] = {
  NSPAIR(_ZN3ccc10CC10x11y12C1Ev),
  NSPAIR(_ZN3ccc10CC10x11y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10CC10x11y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y12E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
extern void _ZN3ccc10CC10x11y123abcEv();
extern void _ZN3ccc4AA103pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc10CC10x11y123abcEv,_ZTv0_n16_N3ccc10CC10x11y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x11y123abcEv,_ZThn4_N3ccc10CC10x11y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10CC10x11y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y123abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10CC10x11y123abcEv,_ZTv0_n16_N3ccc10CC10x11y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x11y12E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x11y12E[] = {
  {&(_ZTVN3ccc10CC10x11y12E[3]),  3,12},
  {&(_ZTVN3ccc10CC10x11y12E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y12E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x11y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x11y12E[];
static VTBL_ENTRY alt_thunk_names157[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10CC10x11y123abcEv,_ZTv0_n16_N3ccc10CC10x11y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x11y123abcEv,_ZThn4_N3ccc10CC10x11y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x11y12E = {  "_ZN3ccc10CC10x11y12E", // class name
  bases__ZN3ccc10CC10x11y12E, 2,
  &(vtc__ZN3ccc10CC10x11y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x11y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x11y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x11y12E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x11y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names157,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y12  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc10DD10x11y123abcEv
  ~DD10x11y12(); // tgen
  DD10x11y12(); // tgen
};
//SIG(1 _ZN3ccc10DD10x11y12E) C1{ VBC2{ v2 v1} VBC3{ v3 v4} v1}
}
namespace ccc { 
void  ccc::DD10x11y12 ::abc(){vfunc_called(this, "_ZN3ccc10DD10x11y123abcEv");}
ccc::DD10x11y12 ::~DD10x11y12(){ note_dtor("_ZN3ccc10DD10x11y12E", this);} // tgen
ccc::DD10x11y12 ::DD10x11y12(){ note_ctor("_ZN3ccc10DD10x11y12E", this);} // tgen
}
static void Test__ZN3ccc10DD10x11y12E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x11y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x11y12E, buf);
    ::ccc::DD10x11y12 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x11y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x11y12E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x11y12E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc10DD10x11y12E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x11y12E);
    dp->::ccc::DD10x11y12::~DD10x11y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x11y12E(Test__ZN3ccc10DD10x11y12E, "_ZN3ccc10DD10x11y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x11y12C1Ev();
extern void _ZN3ccc10DD10x11y12D1Ev();
Name_Map name_map__ZN3ccc10DD10x11y12E[] = {
  NSPAIR(_ZN3ccc10DD10x11y12C1Ev),
  NSPAIR(_ZN3ccc10DD10x11y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10DD10x11y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y12E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc10DD10x11y123abcEv();
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x11y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y123abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x11y12E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x11y12E[] = {
  {&(_ZTVN3ccc10DD10x11y12E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y12E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y12E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y12E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x11y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x11y12E[];
Class_Descriptor cd__ZN3ccc10DD10x11y12E = {  "_ZN3ccc10DD10x11y12E", // class name
  bases__ZN3ccc10DD10x11y12E, 2,
  &(vtc__ZN3ccc10DD10x11y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x11y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x11y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x11y12E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x11y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y13  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc10CC10x11y133efgEv
  ~CC10x11y13(); // tgen
  CC10x11y13(); // tgen
};
//SIG(1 _ZN3ccc10CC10x11y13E) C1{ VBC2{ v2 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC10x11y13 ::efg(){vfunc_called(this, "_ZN3ccc10CC10x11y133efgEv");}
ccc::CC10x11y13 ::~CC10x11y13(){ note_dtor("_ZN3ccc10CC10x11y13E", this);} // tgen
ccc::CC10x11y13 ::CC10x11y13(){ note_ctor("_ZN3ccc10CC10x11y13E", this);} // tgen
}
static void Test__ZN3ccc10CC10x11y13E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x11y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x11y13E, buf);
    ::ccc::CC10x11y13 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x11y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x11y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x11y13E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc10CC10x11y13E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x11y13E);
    dp->::ccc::CC10x11y13::~CC10x11y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x11y13E(Test__ZN3ccc10CC10x11y13E, "_ZN3ccc10CC10x11y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x11y13C1Ev();
extern void _ZN3ccc10CC10x11y13D1Ev();
Name_Map name_map__ZN3ccc10CC10x11y13E[] = {
  NSPAIR(_ZN3ccc10CC10x11y13C1Ev),
  NSPAIR(_ZN3ccc10CC10x11y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10CC10x11y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y13E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc10CC10x11y133efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x11y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y133efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x11y13E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x11y13E[] = {
  {&(_ZTVN3ccc10CC10x11y13E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x11y13E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y13E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x11y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x11y13E[];
Class_Descriptor cd__ZN3ccc10CC10x11y13E = {  "_ZN3ccc10CC10x11y13E", // class name
  bases__ZN3ccc10CC10x11y13E, 2,
  &(vtc__ZN3ccc10CC10x11y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x11y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x11y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x11y13E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x11y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y13  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc10DD10x11y133efgEv
  ~DD10x11y13(); // tgen
  DD10x11y13(); // tgen
};
//SIG(1 _ZN3ccc10DD10x11y13E) C1{ VBC2{ v2 v3} VBC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::DD10x11y13 ::efg(){vfunc_called(this, "_ZN3ccc10DD10x11y133efgEv");}
ccc::DD10x11y13 ::~DD10x11y13(){ note_dtor("_ZN3ccc10DD10x11y13E", this);} // tgen
ccc::DD10x11y13 ::DD10x11y13(){ note_ctor("_ZN3ccc10DD10x11y13E", this);} // tgen
}
static void Test__ZN3ccc10DD10x11y13E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x11y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x11y13E, buf);
    ::ccc::DD10x11y13 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x11y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x11y13E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x11y13E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc10DD10x11y13E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x11y13E);
    dp->::ccc::DD10x11y13::~DD10x11y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x11y13E(Test__ZN3ccc10DD10x11y13E, "_ZN3ccc10DD10x11y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x11y13C1Ev();
extern void _ZN3ccc10DD10x11y13D1Ev();
Name_Map name_map__ZN3ccc10DD10x11y13E[] = {
  NSPAIR(_ZN3ccc10DD10x11y13C1Ev),
  NSPAIR(_ZN3ccc10DD10x11y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10DD10x11y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y13E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc10DD10x11y133efgEv();
extern void _ZN3ccc4BB113pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc10DD10x11y133efgEv,_ZTv0_n16_N3ccc10DD10x11y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x11y133efgEv,_ZThn4_N3ccc10DD10x11y133efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc10DD10x11y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y133efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc10DD10x11y133efgEv,_ZTv0_n16_N3ccc10DD10x11y133efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x11y13E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x11y13E[] = {
  {&(_ZTVN3ccc10DD10x11y13E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x11y13E[6]),  6,15},
  {&(_ZTVN3ccc10DD10x11y13E[13]),  13,15},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y13E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x11y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x11y13E[];
static VTBL_ENTRY alt_thunk_names158[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc10DD10x11y133efgEv,_ZTv0_n16_N3ccc10DD10x11y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x11y133efgEv,_ZThn4_N3ccc10DD10x11y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x11y13E = {  "_ZN3ccc10DD10x11y13E", // class name
  bases__ZN3ccc10DD10x11y13E, 2,
  &(vtc__ZN3ccc10DD10x11y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x11y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x11y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x11y13E),15, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x11y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names158,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y14  : virtual ::ccc::AA10 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc10CC10x11y143pqrEv
  ~CC10x11y14(); // tgen
  CC10x11y14(); // tgen
};
//SIG(1 _ZN3ccc10CC10x11y14E) C1{ VBC2{ v1 v2} BC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::CC10x11y14 ::pqr(){vfunc_called(this, "_ZN3ccc10CC10x11y143pqrEv");}
ccc::CC10x11y14 ::~CC10x11y14(){ note_dtor("_ZN3ccc10CC10x11y14E", this);} // tgen
ccc::CC10x11y14 ::CC10x11y14(){ note_ctor("_ZN3ccc10CC10x11y14E", this);} // tgen
}
static void Test__ZN3ccc10CC10x11y14E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x11y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x11y14E, buf);
    ::ccc::CC10x11y14 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x11y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x11y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x11y14E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc10CC10x11y14E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x11y14E);
    dp->::ccc::CC10x11y14::~CC10x11y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x11y14E(Test__ZN3ccc10CC10x11y14E, "_ZN3ccc10CC10x11y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x11y14C1Ev();
extern void _ZN3ccc10CC10x11y14D1Ev();
Name_Map name_map__ZN3ccc10CC10x11y14E[] = {
  NSPAIR(_ZN3ccc10CC10x11y14C1Ev),
  NSPAIR(_ZN3ccc10CC10x11y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10CC10x11y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y14E[];
extern void _ZN3ccc10CC10x11y143pqrEv();
extern void _ZN3ccc4BB113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10CC10x11y143pqrEv,_ZTv0_n12_N3ccc10CC10x11y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10CC10x11y143pqrEv,_ZThn4_N3ccc10CC10x11y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x11y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc10CC10x11y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10CC10x11y143pqrEv,_ZTv0_n12_N3ccc10CC10x11y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x11y14E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x11y14E[] = {
  {&(_ZTVN3ccc10CC10x11y14E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x11y14E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y14E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x11y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x11y14E[];
static VTBL_ENTRY alt_thunk_names159[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10CC10x11y143pqrEv,_ZTv0_n12_N3ccc10CC10x11y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10CC10x11y143pqrEv,_ZThn4_N3ccc10CC10x11y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10CC10x11y14E = {  "_ZN3ccc10CC10x11y14E", // class name
  bases__ZN3ccc10CC10x11y14E, 2,
  &(vtc__ZN3ccc10CC10x11y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x11y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x11y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x11y14E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x11y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names159,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y14  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc10DD10x11y143pqrEv
  ~DD10x11y14(); // tgen
  DD10x11y14(); // tgen
};
//SIG(1 _ZN3ccc10DD10x11y14E) C1{ VBC2{ v1 v2} VBC3{ v1 v3} v1}
}
namespace ccc { 
void  ccc::DD10x11y14 ::pqr(){vfunc_called(this, "_ZN3ccc10DD10x11y143pqrEv");}
ccc::DD10x11y14 ::~DD10x11y14(){ note_dtor("_ZN3ccc10DD10x11y14E", this);} // tgen
ccc::DD10x11y14 ::DD10x11y14(){ note_ctor("_ZN3ccc10DD10x11y14E", this);} // tgen
}
static void Test__ZN3ccc10DD10x11y14E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x11y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x11y14E, buf);
    ::ccc::DD10x11y14 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x11y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x11y14E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x11y14E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc10DD10x11y14E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x11y14E);
    dp->::ccc::DD10x11y14::~DD10x11y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x11y14E(Test__ZN3ccc10DD10x11y14E, "_ZN3ccc10DD10x11y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x11y14C1Ev();
extern void _ZN3ccc10DD10x11y14D1Ev();
Name_Map name_map__ZN3ccc10DD10x11y14E[] = {
  NSPAIR(_ZN3ccc10DD10x11y14C1Ev),
  NSPAIR(_ZN3ccc10DD10x11y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10DD10x11y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y14E[];
extern void _ZN3ccc10DD10x11y143pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc10DD10x11y143pqrEv,_ZTv0_n12_N3ccc10DD10x11y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc10DD10x11y143pqrEv,_ZThn4_N3ccc10DD10x11y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x11y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc10DD10x11y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc10DD10x11y143pqrEv,_ZTv0_n12_N3ccc10DD10x11y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x11y14E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x11y14E[] = {
  {&(_ZTVN3ccc10DD10x11y14E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y14E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y14E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y14E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x11y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x11y14E[];
static VTBL_ENTRY alt_thunk_names160[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc10DD10x11y143pqrEv,_ZTv0_n12_N3ccc10DD10x11y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc10DD10x11y143pqrEv,_ZThn4_N3ccc10DD10x11y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc10DD10x11y14E = {  "_ZN3ccc10DD10x11y14E", // class name
  bases__ZN3ccc10DD10x11y14E, 2,
  &(vtc__ZN3ccc10DD10x11y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x11y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x11y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x11y14E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x11y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names160,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x11y15  : virtual ::ccc::AA10 , ::ccc::BB11 {
  ~CC10x11y15(); // tgen
  CC10x11y15(); // tgen
};
//SIG(1 _ZN3ccc10CC10x11y15E) C1{ VBC2{ v1 v2} BC3{ v3 v4}}
}
namespace ccc { 
ccc::CC10x11y15 ::~CC10x11y15(){ note_dtor("_ZN3ccc10CC10x11y15E", this);} // tgen
ccc::CC10x11y15 ::CC10x11y15(){ note_ctor("_ZN3ccc10CC10x11y15E", this);} // tgen
}
static void Test__ZN3ccc10CC10x11y15E()
{
  extern Class_Descriptor cd__ZN3ccc10CC10x11y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10CC10x11y15E, buf);
    ::ccc::CC10x11y15 *dp, &lv = *(dp=new (buf) ::ccc::CC10x11y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10CC10x11y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10CC10x11y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc10CC10x11y15E");
    check_base_class_offset(lv, (::ccc::BB11*), 0, "_ZN3ccc10CC10x11y15E");
    test_class_info(&lv, &cd__ZN3ccc10CC10x11y15E);
    dp->::ccc::CC10x11y15::~CC10x11y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10CC10x11y15E(Test__ZN3ccc10CC10x11y15E, "_ZN3ccc10CC10x11y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10CC10x11y15C1Ev();
extern void _ZN3ccc10CC10x11y15D1Ev();
Name_Map name_map__ZN3ccc10CC10x11y15E[] = {
  NSPAIR(_ZN3ccc10CC10x11y15C1Ev),
  NSPAIR(_ZN3ccc10CC10x11y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10CC10x11y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y15E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc10CC10x11y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10CC10x11y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc10CC10x11y15E[];
static  VTT_ENTRY vtt__ZN3ccc10CC10x11y15E[] = {
  {&(_ZTVN3ccc10CC10x11y15E[3]),  3,11},
  {&(_ZTVN3ccc10CC10x11y15E[9]),  9,11},
};
extern VTBL_ENTRY _ZTIN3ccc10CC10x11y15E[];
extern  VTBL_ENTRY _ZTVN3ccc10CC10x11y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10CC10x11y15E[];
Class_Descriptor cd__ZN3ccc10CC10x11y15E = {  "_ZN3ccc10CC10x11y15E", // class name
  bases__ZN3ccc10CC10x11y15E, 2,
  &(vtc__ZN3ccc10CC10x11y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10CC10x11y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10CC10x11y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10CC10x11y15E),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10CC10x11y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x11y15  : virtual ::ccc::AA10 , virtual ::ccc::BB11 {
  ~DD10x11y15(); // tgen
  DD10x11y15(); // tgen
};
//SIG(1 _ZN3ccc10DD10x11y15E) C1{ VBC2{ v1 v2} VBC3{ v3 v4}}
}
namespace ccc { 
ccc::DD10x11y15 ::~DD10x11y15(){ note_dtor("_ZN3ccc10DD10x11y15E", this);} // tgen
ccc::DD10x11y15 ::DD10x11y15(){ note_ctor("_ZN3ccc10DD10x11y15E", this);} // tgen
}
static void Test__ZN3ccc10DD10x11y15E()
{
  extern Class_Descriptor cd__ZN3ccc10DD10x11y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc10DD10x11y15E, buf);
    ::ccc::DD10x11y15 *dp, &lv = *(dp=new (buf) ::ccc::DD10x11y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc10DD10x11y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc10DD10x11y15E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc10DD10x11y15E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc10DD10x11y15E");
    test_class_info(&lv, &cd__ZN3ccc10DD10x11y15E);
    dp->::ccc::DD10x11y15::~DD10x11y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc10DD10x11y15E(Test__ZN3ccc10DD10x11y15E, "_ZN3ccc10DD10x11y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc10DD10x11y15C1Ev();
extern void _ZN3ccc10DD10x11y15D1Ev();
Name_Map name_map__ZN3ccc10DD10x11y15E[] = {
  NSPAIR(_ZN3ccc10DD10x11y15C1Ev),
  NSPAIR(_ZN3ccc10DD10x11y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc10DD10x11y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y15E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc10DD10x11y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc10DD10x11y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc10DD10x11y15E[];
static  VTT_ENTRY vtt__ZN3ccc10DD10x11y15E[] = {
  {&(_ZTVN3ccc10DD10x11y15E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y15E[6]),  6,14},
  {&(_ZTVN3ccc10DD10x11y15E[12]),  12,14},
};
extern VTBL_ENTRY _ZTIN3ccc10DD10x11y15E[];
extern  VTBL_ENTRY _ZTVN3ccc10DD10x11y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc10DD10x11y15E[];
Class_Descriptor cd__ZN3ccc10DD10x11y15E = {  "_ZN3ccc10DD10x11y15E", // class name
  bases__ZN3ccc10DD10x11y15E, 2,
  &(vtc__ZN3ccc10DD10x11y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc10DD10x11y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc10DD10x11y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc10DD10x11y15E),14, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc10DD10x11y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x12y0  : virtual ::ccc::AA10 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc9CC10x12y03abcEv
  virtual void  efg(); // _ZN3ccc9CC10x12y03efgEv
  virtual void  pqr(); // _ZN3ccc9CC10x12y03pqrEv
  ~CC10x12y0(); // tgen
  CC10x12y0(); // tgen
};
//SIG(1 _ZN3ccc9CC10x12y0E) C1{ VBC2{ v3 v1} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x12y0 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x12y03abcEv");}
void  ccc::CC10x12y0 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x12y03efgEv");}
void  ccc::CC10x12y0 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x12y03pqrEv");}
ccc::CC10x12y0 ::~CC10x12y0(){ note_dtor("_ZN3ccc9CC10x12y0E", this);} // tgen
ccc::CC10x12y0 ::CC10x12y0(){ note_ctor("_ZN3ccc9CC10x12y0E", this);} // tgen
}
static void Test__ZN3ccc9CC10x12y0E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x12y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x12y0E, buf);
    ::ccc::CC10x12y0 *dp, &lv = *(dp=new (buf) ::ccc::CC10x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x12y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x12y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x12y0E");
    check_base_class_offset(lv, (::ccc::BB12*), 0, "_ZN3ccc9CC10x12y0E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x12y0E);
    dp->::ccc::CC10x12y0::~CC10x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x12y0E(Test__ZN3ccc9CC10x12y0E, "_ZN3ccc9CC10x12y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x12y0C1Ev();
extern void _ZN3ccc9CC10x12y0D1Ev();
Name_Map name_map__ZN3ccc9CC10x12y0E[] = {
  NSPAIR(_ZN3ccc9CC10x12y0C1Ev),
  NSPAIR(_ZN3ccc9CC10x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC10x12y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x12y0E[];
extern void _ZN3ccc9CC10x12y03abcEv();
extern void _ZN3ccc9CC10x12y03efgEv();
extern void _ZN3ccc9CC10x12y03pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x12y03pqrEv,_ZTv0_n12_N3ccc9CC10x12y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x12y03pqrEv,_ZThn4_N3ccc9CC10x12y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x12y03abcEv,_ZTv0_n16_N3ccc9CC10x12y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x12y03abcEv,_ZThn4_N3ccc9CC10x12y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x12y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x12y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y03pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x12y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x12y03pqrEv,_ZTv0_n12_N3ccc9CC10x12y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x12y03abcEv,_ZTv0_n16_N3ccc9CC10x12y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x12y0E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x12y0E[] = {
  {&(_ZTVN3ccc9CC10x12y0E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x12y0E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x12y0E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x12y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x12y0E[];
static VTBL_ENTRY alt_thunk_names161[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x12y03abcEv,_ZTv0_n16_N3ccc9CC10x12y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x12y03abcEv,_ZThn4_N3ccc9CC10x12y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x12y03pqrEv,_ZTv0_n12_N3ccc9CC10x12y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x12y03pqrEv,_ZThn4_N3ccc9CC10x12y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x12y0E = {  "_ZN3ccc9CC10x12y0E", // class name
  bases__ZN3ccc9CC10x12y0E, 2,
  &(vtc__ZN3ccc9CC10x12y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x12y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x12y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x12y0E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x12y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names161,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x12y0  : virtual ::ccc::AA10 , virtual ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc9DD10x12y03abcEv
  virtual void  efg(); // _ZN3ccc9DD10x12y03efgEv
  virtual void  pqr(); // _ZN3ccc9DD10x12y03pqrEv
  ~DD10x12y0(); // tgen
  DD10x12y0(); // tgen
};
//SIG(1 _ZN3ccc9DD10x12y0E) C1{ VBC2{ v3 v1} VBC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x12y0 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x12y03abcEv");}
void  ccc::DD10x12y0 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x12y03efgEv");}
void  ccc::DD10x12y0 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x12y03pqrEv");}
ccc::DD10x12y0 ::~DD10x12y0(){ note_dtor("_ZN3ccc9DD10x12y0E", this);} // tgen
ccc::DD10x12y0 ::DD10x12y0(){ note_ctor("_ZN3ccc9DD10x12y0E", this);} // tgen
}
static void Test__ZN3ccc9DD10x12y0E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x12y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x12y0E, buf);
    ::ccc::DD10x12y0 *dp, &lv = *(dp=new (buf) ::ccc::DD10x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x12y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x12y0E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x12y0E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9DD10x12y0E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x12y0E);
    dp->::ccc::DD10x12y0::~DD10x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x12y0E(Test__ZN3ccc9DD10x12y0E, "_ZN3ccc9DD10x12y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x12y0C1Ev();
extern void _ZN3ccc9DD10x12y0D1Ev();
Name_Map name_map__ZN3ccc9DD10x12y0E[] = {
  NSPAIR(_ZN3ccc9DD10x12y0C1Ev),
  NSPAIR(_ZN3ccc9DD10x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9DD10x12y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x12y0E[];
extern void _ZN3ccc9DD10x12y03pqrEv();
extern void _ZN3ccc9DD10x12y03abcEv();
extern void _ZN3ccc9DD10x12y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x12y03abcEv,_ZTv0_n12_N3ccc9DD10x12y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x12y03abcEv,_ZThn4_N3ccc9DD10x12y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x12y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x12y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x12y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x12y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x12y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x12y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x12y03abcEv,_ZTv0_n12_N3ccc9DD10x12y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x12y0E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x12y0E[] = {
  {&(_ZTVN3ccc9DD10x12y0E[6]),  6,13},
  {&(_ZTVN3ccc9DD10x12y0E[6]),  6,13},
  {&(_ZTVN3ccc9DD10x12y0E[12]),  12,13},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x12y0E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x12y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x12y0E[];
static VTBL_ENTRY alt_thunk_names162[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x12y03abcEv,_ZTv0_n12_N3ccc9DD10x12y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x12y03abcEv,_ZThn4_N3ccc9DD10x12y03abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x12y0E = {  "_ZN3ccc9DD10x12y0E", // class name
  bases__ZN3ccc9DD10x12y0E, 2,
  &(vtc__ZN3ccc9DD10x12y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x12y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x12y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x12y0E),13, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x12y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names162,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x12y1  : virtual ::ccc::AA10 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc9CC10x12y13abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x12y13pqrEv
  virtual void  efg(); // _ZN3ccc9CC10x12y13efgEv
  ~CC10x12y1(); // tgen
  CC10x12y1(); // tgen
};
//SIG(1 _ZN3ccc9CC10x12y1E) C1{ VBC2{ v2 v1} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x12y1 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x12y13abcEv");}
void  ccc::CC10x12y1 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x12y13pqrEv");}
void  ccc::CC10x12y1 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x12y13efgEv");}
ccc::CC10x12y1 ::~CC10x12y1(){ note_dtor("_ZN3ccc9CC10x12y1E", this);} // tgen
ccc::CC10x12y1 ::CC10x12y1(){ note_ctor("_ZN3ccc9CC10x12y1E", this);} // tgen
}
static void Test__ZN3ccc9CC10x12y1E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x12y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x12y1E, buf);
    ::ccc::CC10x12y1 *dp, &lv = *(dp=new (buf) ::ccc::CC10x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x12y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x12y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x12y1E");
    check_base_class_offset(lv, (::ccc::BB12*), 0, "_ZN3ccc9CC10x12y1E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x12y1E);
    dp->::ccc::CC10x12y1::~CC10x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x12y1E(Test__ZN3ccc9CC10x12y1E, "_ZN3ccc9CC10x12y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x12y1C1Ev();
extern void _ZN3ccc9CC10x12y1D1Ev();
Name_Map name_map__ZN3ccc9CC10x12y1E[] = {
  NSPAIR(_ZN3ccc9CC10x12y1C1Ev),
  NSPAIR(_ZN3ccc9CC10x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC10x12y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x12y1E[];
extern void _ZN3ccc9CC10x12y13abcEv();
extern void _ZN3ccc9CC10x12y13pqrEv();
extern void _ZN3ccc9CC10x12y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x12y13pqrEv,_ZTv0_n12_N3ccc9CC10x12y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x12y13pqrEv,_ZThn4_N3ccc9CC10x12y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x12y13abcEv,_ZTv0_n16_N3ccc9CC10x12y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x12y13abcEv,_ZThn4_N3ccc9CC10x12y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x12y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x12y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x12y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x12y13pqrEv,_ZTv0_n12_N3ccc9CC10x12y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x12y13abcEv,_ZTv0_n16_N3ccc9CC10x12y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x12y1E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x12y1E[] = {
  {&(_ZTVN3ccc9CC10x12y1E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x12y1E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x12y1E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x12y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x12y1E[];
static VTBL_ENTRY alt_thunk_names163[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x12y13abcEv,_ZTv0_n16_N3ccc9CC10x12y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x12y13abcEv,_ZThn4_N3ccc9CC10x12y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x12y13pqrEv,_ZTv0_n12_N3ccc9CC10x12y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x12y13pqrEv,_ZThn4_N3ccc9CC10x12y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x12y1E = {  "_ZN3ccc9CC10x12y1E", // class name
  bases__ZN3ccc9CC10x12y1E, 2,
  &(vtc__ZN3ccc9CC10x12y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x12y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC10x12y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC10x12y1E),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9CC10x12y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names163,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD10x12y1  : virtual ::ccc::AA10 , virtual ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc9DD10x12y13abcEv
  virtual void  pqr(); // _ZN3ccc9DD10x12y13pqrEv
  virtual void  efg(); // _ZN3ccc9DD10x12y13efgEv
  ~DD10x12y1(); // tgen
  DD10x12y1(); // tgen
};
//SIG(1 _ZN3ccc9DD10x12y1E) C1{ VBC2{ v2 v1} VBC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD10x12y1 ::abc(){vfunc_called(this, "_ZN3ccc9DD10x12y13abcEv");}
void  ccc::DD10x12y1 ::pqr(){vfunc_called(this, "_ZN3ccc9DD10x12y13pqrEv");}
void  ccc::DD10x12y1 ::efg(){vfunc_called(this, "_ZN3ccc9DD10x12y13efgEv");}
ccc::DD10x12y1 ::~DD10x12y1(){ note_dtor("_ZN3ccc9DD10x12y1E", this);} // tgen
ccc::DD10x12y1 ::DD10x12y1(){ note_ctor("_ZN3ccc9DD10x12y1E", this);} // tgen
}
static void Test__ZN3ccc9DD10x12y1E()
{
  extern Class_Descriptor cd__ZN3ccc9DD10x12y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9DD10x12y1E, buf);
    ::ccc::DD10x12y1 *dp, &lv = *(dp=new (buf) ::ccc::DD10x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9DD10x12y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9DD10x12y1E)");
    check_base_class_offset(lv, (::ccc::AA10*), 0, "_ZN3ccc9DD10x12y1E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9DD10x12y1E");
    test_class_info(&lv, &cd__ZN3ccc9DD10x12y1E);
    dp->::ccc::DD10x12y1::~DD10x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9DD10x12y1E(Test__ZN3ccc9DD10x12y1E, "_ZN3ccc9DD10x12y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9DD10x12y1C1Ev();
extern void _ZN3ccc9DD10x12y1D1Ev();
Name_Map name_map__ZN3ccc9DD10x12y1E[] = {
  NSPAIR(_ZN3ccc9DD10x12y1C1Ev),
  NSPAIR(_ZN3ccc9DD10x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9DD10x12y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9DD10x12y1E[];
extern void _ZN3ccc9DD10x12y13pqrEv();
extern void _ZN3ccc9DD10x12y13abcEv();
extern void _ZN3ccc9DD10x12y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9DD10x12y13abcEv,_ZTv0_n12_N3ccc9DD10x12y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9DD10x12y13abcEv,_ZThn4_N3ccc9DD10x12y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9DD10x12y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x12y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc9DD10x12y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x12y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc9DD10x12y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9DD10x12y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9DD10x12y13abcEv,_ZTv0_n12_N3ccc9DD10x12y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9DD10x12y1E[];
static  VTT_ENTRY vtt__ZN3ccc9DD10x12y1E[] = {
  {&(_ZTVN3ccc9DD10x12y1E[6]),  6,13},
  {&(_ZTVN3ccc9DD10x12y1E[6]),  6,13},
  {&(_ZTVN3ccc9DD10x12y1E[12]),  12,13},
};
extern VTBL_ENTRY _ZTIN3ccc9DD10x12y1E[];
extern  VTBL_ENTRY _ZTVN3ccc9DD10x12y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9DD10x12y1E[];
static VTBL_ENTRY alt_thunk_names164[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9DD10x12y13abcEv,_ZTv0_n12_N3ccc9DD10x12y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9DD10x12y13abcEv,_ZThn4_N3ccc9DD10x12y13abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9DD10x12y1E = {  "_ZN3ccc9DD10x12y1E", // class name
  bases__ZN3ccc9DD10x12y1E, 2,
  &(vtc__ZN3ccc9DD10x12y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9DD10x12y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9DD10x12y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9DD10x12y1E),13, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc9DD10x12y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names164,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC10x12y2  : virtual ::ccc::AA10 , ::ccc::BB12 {
  virtual void  efg(); // _ZN3ccc9CC10x12y23efgEv
  virtual void  abc(); // _ZN3ccc9CC10x12y23abcEv
  virtual void  pqr(); // _ZN3ccc9CC10x12y23pqrEv
  ~CC10x12y2(); // tgen
  CC10x12y2(); // tgen
};
//SIG(1 _ZN3ccc9CC10x12y2E) C1{ VBC2{ v3 v2} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC10x12y2 ::efg(){vfunc_called(this, "_ZN3ccc9CC10x12y23efgEv");}
void  ccc::CC10x12y2 ::abc(){vfunc_called(this, "_ZN3ccc9CC10x12y23abcEv");}
void  ccc::CC10x12y2 ::pqr(){vfunc_called(this, "_ZN3ccc9CC10x12y23pqrEv");}
ccc::CC10x12y2 ::~CC10x12y2(){ note_dtor("_ZN3ccc9CC10x12y2E", this);} // tgen
ccc::CC10x12y2 ::CC10x12y2(){ note_ctor("_ZN3ccc9CC10x12y2E", this);} // tgen
}
static void Test__ZN3ccc9CC10x12y2E()
{
  extern Class_Descriptor cd__ZN3ccc9CC10x12y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC10x12y2E, buf);
    ::ccc::CC10x12y2 *dp, &lv = *(dp=new (buf) ::ccc::CC10x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC10x12y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC10x12y2E)");
    check_base_class_offset(lv, (::ccc::AA10*), ABISELECT(8,4), "_ZN3ccc9CC10x12y2E");
    check_base_class_offset(lv, (::ccc::BB12*), 0, "_ZN3ccc9CC10x12y2E");
    test_class_info(&lv, &cd__ZN3ccc9CC10x12y2E);
    dp->::ccc::CC10x12y2::~CC10x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC10x12y2E(Test__ZN3ccc9CC10x12y2E, "_ZN3ccc9CC10x12y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC10x12y2C1Ev();
extern void _ZN3ccc9CC10x12y2D1Ev();
Name_Map name_map__ZN3ccc9CC10x12y2E[] = {
  NSPAIR(_ZN3ccc9CC10x12y2C1Ev),
  NSPAIR(_ZN3ccc9CC10x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc4AA10E;
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC10x12y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc4AA10E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc4BB12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC10x12y2E[];
extern void _ZN3ccc9CC10x12y23abcEv();
extern void _ZN3ccc9CC10x12y23efgEv();
extern void _ZN3ccc9CC10x12y23pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc9CC10x12y23pqrEv,_ZTv0_n12_N3ccc9CC10x12y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x12y23pqrEv,_ZThn4_N3ccc9CC10x12y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc9CC10x12y23abcEv,_ZTv0_n16_N3ccc9CC10x12y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC10x12y23abcEv,_ZThn4_N3ccc9CC10x12y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc9CC10x12y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x12y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC10x12y23pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC10x12y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc9CC10x12y23pqrEv,_ZTv0_n12_N3ccc9CC10x12y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc9CC10x12y23abcEv,_ZTv0_n16_N3ccc9CC10x12y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc9CC10x12y2E[];
static  VTT_ENTRY vtt__ZN3ccc9CC10x12y2E[] = {
  {&(_ZTVN3ccc9CC10x12y2E[3]),  3,12},
  {&(_ZTVN3ccc9CC10x12y2E[10]),  10,12},
};
extern VTBL_ENTRY _ZTIN3ccc9CC10x12y2E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC10x12y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc9CC10x12y2E[];
static VTBL_ENTRY alt_thunk_names165[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc9CC10x12y23abcEv,_ZTv0_n16_N3ccc9CC10x12y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x12y23abcEv,_ZThn4_N3ccc9CC10x12y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc9CC10x12y23pqrEv,_ZTv0_n12_N3ccc9CC10x12y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc9CC10x12y23pqrEv,_ZThn4_N3ccc9CC10x12y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc9CC10x12y2E = {  "_ZN3ccc9CC10x12y2E", // class name
  bases__ZN3ccc9CC10x12y2E, 2,
  &(vtc__ZN3ccc9CC10x12y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc9CC10x12y2E[0]), // expected_vtt_co